// Compiled by ClojureScript 1.11.57 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__5823__auto___64218 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null)))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_64269){
var state_val_64270 = (state_64269[(1)]);
if((state_val_64270 === (7))){
var inst_64264 = (state_64269[(2)]);
var _ = (function (){var statearr_64271 = state_64269;
(statearr_64271[(4)] = cljs.core.rest.call(null,(state_64269[(4)])));

return statearr_64271;
})();
var state_64269__$1 = state_64269;
var statearr_64272_64299 = state_64269__$1;
(statearr_64272_64299[(2)] = inst_64264);

(statearr_64272_64299[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64270 === (1))){
var state_64269__$1 = state_64269;
var statearr_64273_64300 = state_64269__$1;
(statearr_64273_64300[(2)] = null);

(statearr_64273_64300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64270 === (4))){
var inst_64219 = (state_64269[(2)]);
var state_64269__$1 = state_64269;
var statearr_64274_64301 = state_64269__$1;
(statearr_64274_64301[(2)] = inst_64219);

(statearr_64274_64301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64270 === (13))){
var inst_64260 = (state_64269[(2)]);
var state_64269__$1 = state_64269;
var statearr_64275_64302 = state_64269__$1;
(statearr_64275_64302[(2)] = inst_64260);

(statearr_64275_64302[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64270 === (6))){
var inst_64237 = (state_64269[(7)]);
var inst_64244 = (state_64269[(8)]);
var inst_64243 = cljs.core.seq.call(null,inst_64237);
var inst_64244__$1 = cljs.core.first.call(null,inst_64243);
var inst_64245 = cljs.core.next.call(null,inst_64243);
var inst_64246 = cljs.core.not.call(null,inst_64244__$1);
var state_64269__$1 = (function (){var statearr_64276 = state_64269;
(statearr_64276[(9)] = inst_64245);

(statearr_64276[(8)] = inst_64244__$1);

return statearr_64276;
})();
if(inst_64246){
var statearr_64277_64303 = state_64269__$1;
(statearr_64277_64303[(1)] = (8));

} else {
var statearr_64278_64304 = state_64269__$1;
(statearr_64278_64304[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64270 === (3))){
var inst_64267 = (state_64269[(2)]);
var state_64269__$1 = state_64269;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64269__$1,inst_64267);
} else {
if((state_val_64270 === (12))){
var inst_64245 = (state_64269[(9)]);
var inst_64238 = (state_64269[(10)]);
var inst_64244 = (state_64269[(8)]);
var inst_64257 = cljs.core.conj.call(null,inst_64238,inst_64244);
var inst_64237 = inst_64245;
var inst_64238__$1 = inst_64257;
var state_64269__$1 = (function (){var statearr_64279 = state_64269;
(statearr_64279[(7)] = inst_64237);

(statearr_64279[(10)] = inst_64238__$1);

return statearr_64279;
})();
var statearr_64280_64305 = state_64269__$1;
(statearr_64280_64305[(2)] = null);

(statearr_64280_64305[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64270 === (2))){
var _ = (function (){var statearr_64281 = state_64269;
(statearr_64281[(4)] = cljs.core.cons.call(null,(5),(state_64269[(4)])));

return statearr_64281;
})();
var inst_64232 = args;
var inst_64233 = cljs.core.seq.call(null,inst_64232);
var inst_64234 = cljs.core.first.call(null,inst_64233);
var inst_64235 = cljs.core.next.call(null,inst_64233);
var inst_64236 = cljs.core.PersistentVector.EMPTY;
var inst_64237 = inst_64232;
var inst_64238 = inst_64236;
var state_64269__$1 = (function (){var statearr_64282 = state_64269;
(statearr_64282[(7)] = inst_64237);

(statearr_64282[(11)] = inst_64234);

(statearr_64282[(12)] = inst_64235);

(statearr_64282[(10)] = inst_64238);

return statearr_64282;
})();
var statearr_64283_64306 = state_64269__$1;
(statearr_64283_64306[(2)] = null);

(statearr_64283_64306[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64270 === (11))){
var inst_64244 = (state_64269[(8)]);
var state_64269__$1 = state_64269;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64269__$1,(14),inst_64244);
} else {
if((state_val_64270 === (9))){
var inst_64244 = (state_64269[(8)]);
var inst_64249 = fluree.db.util.async.channel_QMARK_.call(null,inst_64244);
var state_64269__$1 = state_64269;
if(inst_64249){
var statearr_64285_64307 = state_64269__$1;
(statearr_64285_64307[(1)] = (11));

} else {
var statearr_64286_64308 = state_64269__$1;
(statearr_64286_64308[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64270 === (5))){
var _ = (function (){var statearr_64287 = state_64269;
(statearr_64287[(4)] = cljs.core.rest.call(null,(state_64269[(4)])));

return statearr_64287;
})();
var state_64269__$1 = state_64269;
var ex64284 = (state_64269__$1[(2)]);
var statearr_64288_64309 = state_64269__$1;
(statearr_64288_64309[(5)] = ex64284);


if((ex64284 instanceof Error)){
var statearr_64289_64310 = state_64269__$1;
(statearr_64289_64310[(1)] = (4));

(statearr_64289_64310[(5)] = null);

} else {
throw ex64284;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64270 === (14))){
var inst_64245 = (state_64269[(9)]);
var inst_64238 = (state_64269[(10)]);
var inst_64252 = (state_64269[(2)]);
var inst_64253 = fluree.db.util.async.throw_err.call(null,inst_64252);
var inst_64254 = cljs.core.conj.call(null,inst_64238,inst_64253);
var inst_64237 = inst_64245;
var inst_64238__$1 = inst_64254;
var state_64269__$1 = (function (){var statearr_64290 = state_64269;
(statearr_64290[(7)] = inst_64237);

(statearr_64290[(10)] = inst_64238__$1);

return statearr_64290;
})();
var statearr_64291_64311 = state_64269__$1;
(statearr_64291_64311[(2)] = null);

(statearr_64291_64311[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64270 === (10))){
var inst_64262 = (state_64269[(2)]);
var state_64269__$1 = state_64269;
var statearr_64292_64312 = state_64269__$1;
(statearr_64292_64312[(2)] = inst_64262);

(statearr_64292_64312[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64270 === (8))){
var inst_64238 = (state_64269[(10)]);
var state_64269__$1 = state_64269;
var statearr_64293_64313 = state_64269__$1;
(statearr_64293_64313[(2)] = inst_64238);

(statearr_64293_64313[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10945__auto____0 = (function (){
var statearr_64294 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64294[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10945__auto__);

(statearr_64294[(1)] = (1));

return statearr_64294;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10945__auto____1 = (function (state_64269){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_64269);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e64295){var ex__10948__auto__ = e64295;
var statearr_64296_64314 = state_64269;
(statearr_64296_64314[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_64269[(4)]))){
var statearr_64297_64315 = state_64269;
(statearr_64297_64315[(1)] = cljs.core.first.call(null,(state_64269[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64316 = state_64269;
state_64269 = G__64316;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10945__auto__ = function(state_64269){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10945__auto____1.call(this,state_64269);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_64298 = f__11019__auto__.call(null);
(statearr_64298[(6)] = c__11018__auto__);

return statearr_64298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__64317 = entry;
var res = cljs.core.nth.call(null,vec__64317,(0),null);
var cost = cljs.core.nth.call(null,vec__64317,(1),null);
fluree.db.util.log.debug.call(null,"Smart function stack: ",res);

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.call(null,new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.call(null,new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.call(null,new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.call(null,msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack.call(null,_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_64365){
var state_val_64366 = (state_64365[(1)]);
if((state_val_64366 === (7))){
var state_64365__$1 = state_64365;
var statearr_64367_64396 = state_64365__$1;
(statearr_64367_64396[(2)] = coll);

(statearr_64367_64396[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64366 === (1))){
var state_64365__$1 = state_64365;
var statearr_64368_64397 = state_64365__$1;
(statearr_64368_64397[(2)] = null);

(statearr_64368_64397[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64366 === (4))){
var inst_64320 = (state_64365[(2)]);
var state_64365__$1 = state_64365;
var statearr_64369_64398 = state_64365__$1;
(statearr_64369_64398[(2)] = inst_64320);

(statearr_64369_64398[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64366 === (15))){
var inst_64339 = (state_64365[(7)]);
var inst_64347 = (state_64365[(2)]);
var inst_64348 = fluree.db.dbfunctions.internal.nth.call(null,inst_64339,inst_64347);
var inst_64349 = cljs.core.count.call(null,inst_64339);
var inst_64350 = ((9) + inst_64349);
var inst_64351 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64352 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64353 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64354 = [inst_64339,inst_64347];
var inst_64355 = (new cljs.core.PersistentVector(null,2,(5),inst_64353,inst_64354,null));
var inst_64356 = ["nth",inst_64355,inst_64348];
var inst_64357 = cljs.core.PersistentHashMap.fromArrays(inst_64352,inst_64356);
var inst_64358 = [inst_64357,inst_64350];
var inst_64359 = (new cljs.core.PersistentVector(null,2,(5),inst_64351,inst_64358,null));
var inst_64360 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64359);
var _ = (function (){var statearr_64370 = state_64365;
(statearr_64370[(4)] = cljs.core.rest.call(null,(state_64365[(4)])));

return statearr_64370;
})();
var state_64365__$1 = (function (){var statearr_64371 = state_64365;
(statearr_64371[(8)] = inst_64360);

return statearr_64371;
})();
var statearr_64372_64399 = state_64365__$1;
(statearr_64372_64399[(2)] = inst_64348);

(statearr_64372_64399[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64366 === (13))){
var state_64365__$1 = state_64365;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64365__$1,(16),key);
} else {
if((state_val_64366 === (6))){
var state_64365__$1 = state_64365;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64365__$1,(9),coll);
} else {
if((state_val_64366 === (3))){
var inst_64363 = (state_64365[(2)]);
var state_64365__$1 = state_64365;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64365__$1,inst_64363);
} else {
if((state_val_64366 === (12))){
var inst_64339 = (state_64365[(2)]);
var inst_64340 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_64365__$1 = (function (){var statearr_64373 = state_64365;
(statearr_64373[(7)] = inst_64339);

return statearr_64373;
})();
if(inst_64340){
var statearr_64374_64400 = state_64365__$1;
(statearr_64374_64400[(1)] = (13));

} else {
var statearr_64375_64401 = state_64365__$1;
(statearr_64375_64401[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64366 === (2))){
var _ = (function (){var statearr_64376 = state_64365;
(statearr_64376[(4)] = cljs.core.cons.call(null,(5),(state_64365[(4)])));

return statearr_64376;
})();
var inst_64326 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_64365__$1 = state_64365;
if(inst_64326){
var statearr_64377_64402 = state_64365__$1;
(statearr_64377_64402[(1)] = (6));

} else {
var statearr_64378_64403 = state_64365__$1;
(statearr_64378_64403[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64366 === (11))){
var inst_64333 = (state_64365[(9)]);
var state_64365__$1 = state_64365;
var statearr_64380_64404 = state_64365__$1;
(statearr_64380_64404[(2)] = inst_64333);

(statearr_64380_64404[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64366 === (9))){
var inst_64329 = (state_64365[(2)]);
var inst_64330 = fluree.db.util.async.throw_err.call(null,inst_64329);
var state_64365__$1 = state_64365;
var statearr_64381_64405 = state_64365__$1;
(statearr_64381_64405[(2)] = inst_64330);

(statearr_64381_64405[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64366 === (5))){
var _ = (function (){var statearr_64382 = state_64365;
(statearr_64382[(4)] = cljs.core.rest.call(null,(state_64365[(4)])));

return statearr_64382;
})();
var state_64365__$1 = state_64365;
var ex64379 = (state_64365__$1[(2)]);
var statearr_64383_64406 = state_64365__$1;
(statearr_64383_64406[(5)] = ex64379);


if((ex64379 instanceof Error)){
var statearr_64384_64407 = state_64365__$1;
(statearr_64384_64407[(1)] = (4));

(statearr_64384_64407[(5)] = null);

} else {
throw ex64379;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64366 === (14))){
var state_64365__$1 = state_64365;
var statearr_64385_64408 = state_64365__$1;
(statearr_64385_64408[(2)] = key);

(statearr_64385_64408[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64366 === (16))){
var inst_64343 = (state_64365[(2)]);
var inst_64344 = fluree.db.util.async.throw_err.call(null,inst_64343);
var state_64365__$1 = state_64365;
var statearr_64386_64409 = state_64365__$1;
(statearr_64386_64409[(2)] = inst_64344);

(statearr_64386_64409[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64366 === (10))){
var inst_64333 = (state_64365[(9)]);
var inst_64336 = cljs.core.vec.call(null,inst_64333);
var state_64365__$1 = state_64365;
var statearr_64387_64410 = state_64365__$1;
(statearr_64387_64410[(2)] = inst_64336);

(statearr_64387_64410[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64366 === (8))){
var inst_64333 = (state_64365[(9)]);
var inst_64333__$1 = (state_64365[(2)]);
var inst_64334 = cljs.core.set_QMARK_.call(null,inst_64333__$1);
var state_64365__$1 = (function (){var statearr_64388 = state_64365;
(statearr_64388[(9)] = inst_64333__$1);

return statearr_64388;
})();
if(inst_64334){
var statearr_64389_64411 = state_64365__$1;
(statearr_64389_64411[(1)] = (10));

} else {
var statearr_64390_64412 = state_64365__$1;
(statearr_64390_64412[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__10945__auto____0 = (function (){
var statearr_64391 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64391[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__10945__auto__);

(statearr_64391[(1)] = (1));

return statearr_64391;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__10945__auto____1 = (function (state_64365){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_64365);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e64392){var ex__10948__auto__ = e64392;
var statearr_64393_64413 = state_64365;
(statearr_64393_64413[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_64365[(4)]))){
var statearr_64394_64414 = state_64365;
(statearr_64394_64414[(1)] = cljs.core.first.call(null,(state_64365[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64415 = state_64365;
state_64365 = G__64415;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__10945__auto__ = function(state_64365){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__10945__auto____1.call(this,state_64365);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_64395 = f__11019__auto__.call(null);
(statearr_64395[(6)] = c__11018__auto__);

return statearr_64395;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_64476){
var state_val_64477 = (state_64476[(1)]);
if((state_val_64477 === (7))){
var state_64476__$1 = state_64476;
var statearr_64478_64512 = state_64476__$1;
(statearr_64478_64512[(2)] = test);

(statearr_64478_64512[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64477 === (20))){
var inst_64450 = (state_64476[(2)]);
var inst_64451 = fluree.db.util.async.throw_err.call(null,inst_64450);
var state_64476__$1 = state_64476;
var statearr_64479_64513 = state_64476__$1;
(statearr_64479_64513[(2)] = inst_64451);

(statearr_64479_64513[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64477 === (1))){
var state_64476__$1 = state_64476;
var statearr_64480_64514 = state_64476__$1;
(statearr_64480_64514[(2)] = null);

(statearr_64480_64514[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64477 === (4))){
var inst_64416 = (state_64476[(2)]);
var state_64476__$1 = state_64476;
var statearr_64481_64515 = state_64476__$1;
(statearr_64481_64515[(2)] = inst_64416);

(statearr_64481_64515[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64477 === (15))){
var inst_64434 = (state_64476[(7)]);
var inst_64442 = (state_64476[(2)]);
var inst_64443 = [inst_64442,f];
var inst_64444 = (new cljs.core.PersistentVector(null,2,(5),inst_64434,inst_64443,null));
var state_64476__$1 = state_64476;
var statearr_64482_64516 = state_64476__$1;
(statearr_64482_64516[(2)] = inst_64444);

(statearr_64482_64516[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64477 === (13))){
var state_64476__$1 = state_64476;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64476__$1,(16),t);
} else {
if((state_val_64477 === (6))){
var state_64476__$1 = state_64476;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64476__$1,(9),test);
} else {
if((state_val_64477 === (17))){
var state_64476__$1 = state_64476;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64476__$1,(20),f);
} else {
if((state_val_64477 === (3))){
var inst_64474 = (state_64476[(2)]);
var state_64476__$1 = state_64476;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64476__$1,inst_64474);
} else {
if((state_val_64477 === (12))){
var inst_64432 = (state_64476[(8)]);
var inst_64458 = (state_64476[(2)]);
var inst_64459 = cljs.core.nth.call(null,inst_64458,(0),null);
var inst_64460 = cljs.core.nth.call(null,inst_64458,(1),null);
var inst_64461 = fluree.db.dbfunctions.internal.if_else.call(null,inst_64432,inst_64459,inst_64460);
var inst_64462 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64463 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64464 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64465 = [inst_64432,inst_64459,inst_64460];
var inst_64466 = (new cljs.core.PersistentVector(null,3,(5),inst_64464,inst_64465,null));
var inst_64467 = ["if-else",inst_64466,inst_64461];
var inst_64468 = cljs.core.PersistentHashMap.fromArrays(inst_64463,inst_64467);
var inst_64469 = [inst_64468,(10)];
var inst_64470 = (new cljs.core.PersistentVector(null,2,(5),inst_64462,inst_64469,null));
var inst_64471 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64470);
var _ = (function (){var statearr_64483 = state_64476;
(statearr_64483[(4)] = cljs.core.rest.call(null,(state_64476[(4)])));

return statearr_64483;
})();
var state_64476__$1 = (function (){var statearr_64484 = state_64476;
(statearr_64484[(9)] = inst_64471);

return statearr_64484;
})();
var statearr_64485_64517 = state_64476__$1;
(statearr_64485_64517[(2)] = inst_64461);

(statearr_64485_64517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64477 === (2))){
var _ = (function (){var statearr_64486 = state_64476;
(statearr_64486[(4)] = cljs.core.cons.call(null,(5),(state_64476[(4)])));

return statearr_64486;
})();
var inst_64425 = fluree.db.util.async.channel_QMARK_.call(null,test);
var state_64476__$1 = state_64476;
if(inst_64425){
var statearr_64487_64518 = state_64476__$1;
(statearr_64487_64518[(1)] = (6));

} else {
var statearr_64488_64519 = state_64476__$1;
(statearr_64488_64519[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64477 === (19))){
var inst_64446 = (state_64476[(10)]);
var inst_64454 = (state_64476[(2)]);
var inst_64455 = [f,inst_64454];
var inst_64456 = (new cljs.core.PersistentVector(null,2,(5),inst_64446,inst_64455,null));
var state_64476__$1 = state_64476;
var statearr_64489_64520 = state_64476__$1;
(statearr_64489_64520[(2)] = inst_64456);

(statearr_64489_64520[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64477 === (11))){
var inst_64446 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64447 = fluree.db.util.async.channel_QMARK_.call(null,f);
var state_64476__$1 = (function (){var statearr_64491 = state_64476;
(statearr_64491[(10)] = inst_64446);

return statearr_64491;
})();
if(inst_64447){
var statearr_64492_64521 = state_64476__$1;
(statearr_64492_64521[(1)] = (17));

} else {
var statearr_64493_64522 = state_64476__$1;
(statearr_64493_64522[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64477 === (9))){
var inst_64428 = (state_64476[(2)]);
var inst_64429 = fluree.db.util.async.throw_err.call(null,inst_64428);
var state_64476__$1 = state_64476;
var statearr_64494_64523 = state_64476__$1;
(statearr_64494_64523[(2)] = inst_64429);

(statearr_64494_64523[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64477 === (5))){
var _ = (function (){var statearr_64495 = state_64476;
(statearr_64495[(4)] = cljs.core.rest.call(null,(state_64476[(4)])));

return statearr_64495;
})();
var state_64476__$1 = state_64476;
var ex64490 = (state_64476__$1[(2)]);
var statearr_64496_64524 = state_64476__$1;
(statearr_64496_64524[(5)] = ex64490);


if((ex64490 instanceof Error)){
var statearr_64497_64525 = state_64476__$1;
(statearr_64497_64525[(1)] = (4));

(statearr_64497_64525[(5)] = null);

} else {
throw ex64490;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64477 === (14))){
var state_64476__$1 = state_64476;
var statearr_64498_64526 = state_64476__$1;
(statearr_64498_64526[(2)] = t);

(statearr_64498_64526[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64477 === (16))){
var inst_64438 = (state_64476[(2)]);
var inst_64439 = fluree.db.util.async.throw_err.call(null,inst_64438);
var state_64476__$1 = state_64476;
var statearr_64499_64527 = state_64476__$1;
(statearr_64499_64527[(2)] = inst_64439);

(statearr_64499_64527[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64477 === (10))){
var inst_64434 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64435 = fluree.db.util.async.channel_QMARK_.call(null,t);
var state_64476__$1 = (function (){var statearr_64500 = state_64476;
(statearr_64500[(7)] = inst_64434);

return statearr_64500;
})();
if(inst_64435){
var statearr_64501_64528 = state_64476__$1;
(statearr_64501_64528[(1)] = (13));

} else {
var statearr_64502_64529 = state_64476__$1;
(statearr_64502_64529[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64477 === (18))){
var state_64476__$1 = state_64476;
var statearr_64503_64530 = state_64476__$1;
(statearr_64503_64530[(2)] = f);

(statearr_64503_64530[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64477 === (8))){
var inst_64432 = (state_64476[(8)]);
var inst_64432__$1 = (state_64476[(2)]);
var state_64476__$1 = (function (){var statearr_64504 = state_64476;
(statearr_64504[(8)] = inst_64432__$1);

return statearr_64504;
})();
if(cljs.core.truth_(inst_64432__$1)){
var statearr_64505_64531 = state_64476__$1;
(statearr_64505_64531[(1)] = (10));

} else {
var statearr_64506_64532 = state_64476__$1;
(statearr_64506_64532[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__10945__auto____0 = (function (){
var statearr_64507 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_64507[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__10945__auto__);

(statearr_64507[(1)] = (1));

return statearr_64507;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__10945__auto____1 = (function (state_64476){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_64476);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e64508){var ex__10948__auto__ = e64508;
var statearr_64509_64533 = state_64476;
(statearr_64509_64533[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_64476[(4)]))){
var statearr_64510_64534 = state_64476;
(statearr_64510_64534[(1)] = cljs.core.first.call(null,(state_64476[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64535 = state_64476;
state_64476 = G__64535;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__10945__auto__ = function(state_64476){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__10945__auto____1.call(this,state_64476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_64511 = f__11019__auto__.call(null);
(statearr_64511[(6)] = c__11018__auto__);

return statearr_64511;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_64565){
var state_val_64566 = (state_64565[(1)]);
if((state_val_64566 === (7))){
var state_64565__$1 = state_64565;
var statearr_64567_64586 = state_64565__$1;
(statearr_64567_64586[(2)] = arg);

(statearr_64567_64586[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64566 === (1))){
var state_64565__$1 = state_64565;
var statearr_64568_64587 = state_64565__$1;
(statearr_64568_64587[(2)] = null);

(statearr_64568_64587[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64566 === (4))){
var inst_64536 = (state_64565[(2)]);
var state_64565__$1 = state_64565;
var statearr_64569_64588 = state_64565__$1;
(statearr_64569_64588[(2)] = inst_64536);

(statearr_64569_64588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64566 === (6))){
var state_64565__$1 = state_64565;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64565__$1,(9),arg);
} else {
if((state_val_64566 === (3))){
var inst_64563 = (state_64565[(2)]);
var state_64565__$1 = state_64565;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64565__$1,inst_64563);
} else {
if((state_val_64566 === (2))){
var _ = (function (){var statearr_64571 = state_64565;
(statearr_64571[(4)] = cljs.core.cons.call(null,(5),(state_64565[(4)])));

return statearr_64571;
})();
var inst_64542 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_64565__$1 = state_64565;
if(inst_64542){
var statearr_64572_64589 = state_64565__$1;
(statearr_64572_64589[(1)] = (6));

} else {
var statearr_64573_64590 = state_64565__$1;
(statearr_64573_64590[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64566 === (9))){
var inst_64545 = (state_64565[(2)]);
var inst_64546 = fluree.db.util.async.throw_err.call(null,inst_64545);
var state_64565__$1 = state_64565;
var statearr_64574_64591 = state_64565__$1;
(statearr_64574_64591[(2)] = inst_64546);

(statearr_64574_64591[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64566 === (5))){
var _ = (function (){var statearr_64575 = state_64565;
(statearr_64575[(4)] = cljs.core.rest.call(null,(state_64565[(4)])));

return statearr_64575;
})();
var state_64565__$1 = state_64565;
var ex64570 = (state_64565__$1[(2)]);
var statearr_64576_64592 = state_64565__$1;
(statearr_64576_64592[(5)] = ex64570);


if((ex64570 instanceof Error)){
var statearr_64577_64593 = state_64565__$1;
(statearr_64577_64593[(1)] = (4));

(statearr_64577_64593[(5)] = null);

} else {
throw ex64570;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64566 === (8))){
var inst_64549 = (state_64565[(2)]);
var inst_64550 = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,inst_64549);
var inst_64551 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64552 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64553 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64554 = [inst_64549];
var inst_64555 = (new cljs.core.PersistentVector(null,1,(5),inst_64553,inst_64554,null));
var inst_64556 = ["nil?",inst_64555,inst_64550];
var inst_64557 = cljs.core.PersistentHashMap.fromArrays(inst_64552,inst_64556);
var inst_64558 = [inst_64557,(10)];
var inst_64559 = (new cljs.core.PersistentVector(null,2,(5),inst_64551,inst_64558,null));
var inst_64560 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64559);
var _ = (function (){var statearr_64578 = state_64565;
(statearr_64578[(4)] = cljs.core.rest.call(null,(state_64565[(4)])));

return statearr_64578;
})();
var state_64565__$1 = (function (){var statearr_64579 = state_64565;
(statearr_64579[(7)] = inst_64560);

return statearr_64579;
})();
var statearr_64580_64594 = state_64565__$1;
(statearr_64580_64594[(2)] = inst_64550);

(statearr_64580_64594[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10945__auto____0 = (function (){
var statearr_64581 = [null,null,null,null,null,null,null,null];
(statearr_64581[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10945__auto__);

(statearr_64581[(1)] = (1));

return statearr_64581;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10945__auto____1 = (function (state_64565){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_64565);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e64582){var ex__10948__auto__ = e64582;
var statearr_64583_64595 = state_64565;
(statearr_64583_64595[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_64565[(4)]))){
var statearr_64584_64596 = state_64565;
(statearr_64584_64596[(1)] = cljs.core.first.call(null,(state_64565[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64597 = state_64565;
state_64565 = G__64597;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10945__auto__ = function(state_64565){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10945__auto____1.call(this,state_64565);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_64585 = f__11019__auto__.call(null);
(statearr_64585[(6)] = c__11018__auto__);

return statearr_64585;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_64627){
var state_val_64628 = (state_64627[(1)]);
if((state_val_64628 === (7))){
var state_64627__$1 = state_64627;
var statearr_64629_64648 = state_64627__$1;
(statearr_64629_64648[(2)] = arg);

(statearr_64629_64648[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64628 === (1))){
var state_64627__$1 = state_64627;
var statearr_64630_64649 = state_64627__$1;
(statearr_64630_64649[(2)] = null);

(statearr_64630_64649[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64628 === (4))){
var inst_64598 = (state_64627[(2)]);
var state_64627__$1 = state_64627;
var statearr_64631_64650 = state_64627__$1;
(statearr_64631_64650[(2)] = inst_64598);

(statearr_64631_64650[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64628 === (6))){
var state_64627__$1 = state_64627;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64627__$1,(9),arg);
} else {
if((state_val_64628 === (3))){
var inst_64625 = (state_64627[(2)]);
var state_64627__$1 = state_64627;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64627__$1,inst_64625);
} else {
if((state_val_64628 === (2))){
var _ = (function (){var statearr_64633 = state_64627;
(statearr_64633[(4)] = cljs.core.cons.call(null,(5),(state_64627[(4)])));

return statearr_64633;
})();
var inst_64604 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_64627__$1 = state_64627;
if(inst_64604){
var statearr_64634_64651 = state_64627__$1;
(statearr_64634_64651[(1)] = (6));

} else {
var statearr_64635_64652 = state_64627__$1;
(statearr_64635_64652[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64628 === (9))){
var inst_64607 = (state_64627[(2)]);
var inst_64608 = fluree.db.util.async.throw_err.call(null,inst_64607);
var state_64627__$1 = state_64627;
var statearr_64636_64653 = state_64627__$1;
(statearr_64636_64653[(2)] = inst_64608);

(statearr_64636_64653[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64628 === (5))){
var _ = (function (){var statearr_64637 = state_64627;
(statearr_64637[(4)] = cljs.core.rest.call(null,(state_64627[(4)])));

return statearr_64637;
})();
var state_64627__$1 = state_64627;
var ex64632 = (state_64627__$1[(2)]);
var statearr_64638_64654 = state_64627__$1;
(statearr_64638_64654[(5)] = ex64632);


if((ex64632 instanceof Error)){
var statearr_64639_64655 = state_64627__$1;
(statearr_64639_64655[(1)] = (4));

(statearr_64639_64655[(5)] = null);

} else {
throw ex64632;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64628 === (8))){
var inst_64611 = (state_64627[(2)]);
var inst_64612 = fluree.db.dbfunctions.internal.not.call(null,inst_64611);
var inst_64613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64614 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64615 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64616 = [inst_64611];
var inst_64617 = (new cljs.core.PersistentVector(null,1,(5),inst_64615,inst_64616,null));
var inst_64618 = ["not?",inst_64617,inst_64612];
var inst_64619 = cljs.core.PersistentHashMap.fromArrays(inst_64614,inst_64618);
var inst_64620 = [inst_64619,(10)];
var inst_64621 = (new cljs.core.PersistentVector(null,2,(5),inst_64613,inst_64620,null));
var inst_64622 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64621);
var _ = (function (){var statearr_64640 = state_64627;
(statearr_64640[(4)] = cljs.core.rest.call(null,(state_64627[(4)])));

return statearr_64640;
})();
var state_64627__$1 = (function (){var statearr_64641 = state_64627;
(statearr_64641[(7)] = inst_64622);

return statearr_64641;
})();
var statearr_64642_64656 = state_64627__$1;
(statearr_64642_64656[(2)] = inst_64612);

(statearr_64642_64656[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__10945__auto____0 = (function (){
var statearr_64643 = [null,null,null,null,null,null,null,null];
(statearr_64643[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__10945__auto__);

(statearr_64643[(1)] = (1));

return statearr_64643;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__10945__auto____1 = (function (state_64627){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_64627);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e64644){var ex__10948__auto__ = e64644;
var statearr_64645_64657 = state_64627;
(statearr_64645_64657[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_64627[(4)]))){
var statearr_64646_64658 = state_64627;
(statearr_64646_64658[(1)] = cljs.core.first.call(null,(state_64627[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64659 = state_64627;
state_64627 = G__64659;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__10945__auto__ = function(state_64627){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__10945__auto____1.call(this,state_64627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_64647 = f__11019__auto__.call(null);
(statearr_64647[(6)] = c__11018__auto__);

return statearr_64647;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_64689){
var state_val_64690 = (state_64689[(1)]);
if((state_val_64690 === (7))){
var state_64689__$1 = state_64689;
var statearr_64691_64710 = state_64689__$1;
(statearr_64691_64710[(2)] = arg);

(statearr_64691_64710[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64690 === (1))){
var state_64689__$1 = state_64689;
var statearr_64692_64711 = state_64689__$1;
(statearr_64692_64711[(2)] = null);

(statearr_64692_64711[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64690 === (4))){
var inst_64660 = (state_64689[(2)]);
var state_64689__$1 = state_64689;
var statearr_64693_64712 = state_64689__$1;
(statearr_64693_64712[(2)] = inst_64660);

(statearr_64693_64712[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64690 === (6))){
var state_64689__$1 = state_64689;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64689__$1,(9),arg);
} else {
if((state_val_64690 === (3))){
var inst_64687 = (state_64689[(2)]);
var state_64689__$1 = state_64689;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64689__$1,inst_64687);
} else {
if((state_val_64690 === (2))){
var _ = (function (){var statearr_64695 = state_64689;
(statearr_64695[(4)] = cljs.core.cons.call(null,(5),(state_64689[(4)])));

return statearr_64695;
})();
var inst_64666 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_64689__$1 = state_64689;
if(inst_64666){
var statearr_64696_64713 = state_64689__$1;
(statearr_64696_64713[(1)] = (6));

} else {
var statearr_64697_64714 = state_64689__$1;
(statearr_64697_64714[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64690 === (9))){
var inst_64669 = (state_64689[(2)]);
var inst_64670 = fluree.db.util.async.throw_err.call(null,inst_64669);
var state_64689__$1 = state_64689;
var statearr_64698_64715 = state_64689__$1;
(statearr_64698_64715[(2)] = inst_64670);

(statearr_64698_64715[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64690 === (5))){
var _ = (function (){var statearr_64699 = state_64689;
(statearr_64699[(4)] = cljs.core.rest.call(null,(state_64689[(4)])));

return statearr_64699;
})();
var state_64689__$1 = state_64689;
var ex64694 = (state_64689__$1[(2)]);
var statearr_64700_64716 = state_64689__$1;
(statearr_64700_64716[(5)] = ex64694);


if((ex64694 instanceof Error)){
var statearr_64701_64717 = state_64689__$1;
(statearr_64701_64717[(1)] = (4));

(statearr_64701_64717[(5)] = null);

} else {
throw ex64694;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64690 === (8))){
var inst_64673 = (state_64689[(2)]);
var inst_64674 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_64673);
var inst_64675 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64676 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64677 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64678 = [inst_64673];
var inst_64679 = (new cljs.core.PersistentVector(null,1,(5),inst_64677,inst_64678,null));
var inst_64680 = ["empty?",inst_64679,inst_64674];
var inst_64681 = cljs.core.PersistentHashMap.fromArrays(inst_64676,inst_64680);
var inst_64682 = [inst_64681,(10)];
var inst_64683 = (new cljs.core.PersistentVector(null,2,(5),inst_64675,inst_64682,null));
var inst_64684 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64683);
var _ = (function (){var statearr_64702 = state_64689;
(statearr_64702[(4)] = cljs.core.rest.call(null,(state_64689[(4)])));

return statearr_64702;
})();
var state_64689__$1 = (function (){var statearr_64703 = state_64689;
(statearr_64703[(7)] = inst_64684);

return statearr_64703;
})();
var statearr_64704_64718 = state_64689__$1;
(statearr_64704_64718[(2)] = inst_64674);

(statearr_64704_64718[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10945__auto____0 = (function (){
var statearr_64705 = [null,null,null,null,null,null,null,null];
(statearr_64705[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10945__auto__);

(statearr_64705[(1)] = (1));

return statearr_64705;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10945__auto____1 = (function (state_64689){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_64689);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e64706){var ex__10948__auto__ = e64706;
var statearr_64707_64719 = state_64689;
(statearr_64707_64719[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_64689[(4)]))){
var statearr_64708_64720 = state_64689;
(statearr_64708_64720[(1)] = cljs.core.first.call(null,(state_64689[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64721 = state_64689;
state_64689 = G__64721;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10945__auto__ = function(state_64689){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10945__auto____1.call(this,state_64689);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_64709 = f__11019__auto__.call(null);
(statearr_64709[(6)] = c__11018__auto__);

return statearr_64709;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__5774__auto__ = [];
var len__5768__auto___64766 = arguments.length;
var i__5769__auto___64767 = (0);
while(true){
if((i__5769__auto___64767 < len__5768__auto___64766)){
args__5774__auto__.push((arguments[i__5769__auto___64767]));

var G__64768 = (i__5769__auto___64767 + (1));
i__5769__auto___64767 = G__64768;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_64749){
var state_val_64750 = (state_64749[(1)]);
if((state_val_64750 === (1))){
var state_64749__$1 = state_64749;
var statearr_64751_64769 = state_64749__$1;
(statearr_64751_64769[(2)] = null);

(statearr_64751_64769[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64750 === (2))){
var _ = (function (){var statearr_64752 = state_64749;
(statearr_64752[(4)] = cljs.core.cons.call(null,(5),(state_64749[(4)])));

return statearr_64752;
})();
var inst_64730 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_64749__$1 = state_64749;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64749__$1,(6),inst_64730);
} else {
if((state_val_64750 === (3))){
var inst_64747 = (state_64749[(2)]);
var state_64749__$1 = state_64749;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64749__$1,inst_64747);
} else {
if((state_val_64750 === (4))){
var inst_64724 = (state_64749[(2)]);
var state_64749__$1 = state_64749;
var statearr_64754_64770 = state_64749__$1;
(statearr_64754_64770[(2)] = inst_64724);

(statearr_64754_64770[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64750 === (5))){
var _ = (function (){var statearr_64755 = state_64749;
(statearr_64755[(4)] = cljs.core.rest.call(null,(state_64749[(4)])));

return statearr_64755;
})();
var state_64749__$1 = state_64749;
var ex64753 = (state_64749__$1[(2)]);
var statearr_64756_64771 = state_64749__$1;
(statearr_64756_64771[(5)] = ex64753);


if((ex64753 instanceof Error)){
var statearr_64757_64772 = state_64749__$1;
(statearr_64757_64772[(1)] = (4));

(statearr_64757_64772[(5)] = null);

} else {
throw ex64753;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64750 === (6))){
var inst_64732 = (state_64749[(2)]);
var inst_64733 = fluree.db.util.async.throw_err.call(null,inst_64732);
var inst_64734 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.str,inst_64733);
var inst_64735 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64736 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64737 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64738 = [inst_64733];
var inst_64739 = (new cljs.core.PersistentVector(null,1,(5),inst_64737,inst_64738,null));
var inst_64740 = ["str",inst_64739,inst_64734];
var inst_64741 = cljs.core.PersistentHashMap.fromArrays(inst_64736,inst_64740);
var inst_64742 = [inst_64741,(10)];
var inst_64743 = (new cljs.core.PersistentVector(null,2,(5),inst_64735,inst_64742,null));
var inst_64744 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64743);
var _ = (function (){var statearr_64758 = state_64749;
(statearr_64758[(4)] = cljs.core.rest.call(null,(state_64749[(4)])));

return statearr_64758;
})();
var state_64749__$1 = (function (){var statearr_64759 = state_64749;
(statearr_64759[(7)] = inst_64744);

return statearr_64759;
})();
var statearr_64760_64773 = state_64749__$1;
(statearr_64760_64773[(2)] = inst_64734);

(statearr_64760_64773[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10945__auto____0 = (function (){
var statearr_64761 = [null,null,null,null,null,null,null,null];
(statearr_64761[(0)] = fluree$db$dbfunctions$fns$state_machine__10945__auto__);

(statearr_64761[(1)] = (1));

return statearr_64761;
});
var fluree$db$dbfunctions$fns$state_machine__10945__auto____1 = (function (state_64749){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_64749);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e64762){var ex__10948__auto__ = e64762;
var statearr_64763_64774 = state_64749;
(statearr_64763_64774[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_64749[(4)]))){
var statearr_64764_64775 = state_64749;
(statearr_64764_64775[(1)] = cljs.core.first.call(null,(state_64749[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64776 = state_64749;
state_64749 = G__64776;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10945__auto__ = function(state_64749){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____1.call(this,state_64749);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_64765 = f__11019__auto__.call(null);
(statearr_64765[(6)] = c__11018__auto__);

return statearr_64765;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq64722){
var G__64723 = cljs.core.first.call(null,seq64722);
var seq64722__$1 = cljs.core.next.call(null,seq64722);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64723,seq64722__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_64802){
var state_val_64803 = (state_64802[(1)]);
if((state_val_64803 === (1))){
var state_64802__$1 = state_64802;
var statearr_64804_64819 = state_64802__$1;
(statearr_64804_64819[(2)] = null);

(statearr_64804_64819[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64803 === (2))){
var _ = (function (){var statearr_64805 = state_64802;
(statearr_64805[(4)] = cljs.core.cons.call(null,(5),(state_64802[(4)])));

return statearr_64805;
})();
var inst_64783 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_64802__$1 = state_64802;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64802__$1,(6),inst_64783);
} else {
if((state_val_64803 === (3))){
var inst_64800 = (state_64802[(2)]);
var state_64802__$1 = state_64802;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64802__$1,inst_64800);
} else {
if((state_val_64803 === (4))){
var inst_64777 = (state_64802[(2)]);
var state_64802__$1 = state_64802;
var statearr_64807_64820 = state_64802__$1;
(statearr_64807_64820[(2)] = inst_64777);

(statearr_64807_64820[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64803 === (5))){
var _ = (function (){var statearr_64808 = state_64802;
(statearr_64808[(4)] = cljs.core.rest.call(null,(state_64802[(4)])));

return statearr_64808;
})();
var state_64802__$1 = state_64802;
var ex64806 = (state_64802__$1[(2)]);
var statearr_64809_64821 = state_64802__$1;
(statearr_64809_64821[(5)] = ex64806);


if((ex64806 instanceof Error)){
var statearr_64810_64822 = state_64802__$1;
(statearr_64810_64822[(1)] = (4));

(statearr_64810_64822[(5)] = null);

} else {
throw ex64806;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64803 === (6))){
var inst_64785 = (state_64802[(2)]);
var inst_64786 = fluree.db.util.async.throw_err.call(null,inst_64785);
var inst_64787 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.subs,inst_64786);
var inst_64788 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64789 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64790 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64791 = [inst_64786];
var inst_64792 = (new cljs.core.PersistentVector(null,1,(5),inst_64790,inst_64791,null));
var inst_64793 = ["subs",inst_64792,inst_64787];
var inst_64794 = cljs.core.PersistentHashMap.fromArrays(inst_64789,inst_64793);
var inst_64795 = [inst_64794,(30)];
var inst_64796 = (new cljs.core.PersistentVector(null,2,(5),inst_64788,inst_64795,null));
var inst_64797 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64796);
var _ = (function (){var statearr_64811 = state_64802;
(statearr_64811[(4)] = cljs.core.rest.call(null,(state_64802[(4)])));

return statearr_64811;
})();
var state_64802__$1 = (function (){var statearr_64812 = state_64802;
(statearr_64812[(7)] = inst_64797);

return statearr_64812;
})();
var statearr_64813_64823 = state_64802__$1;
(statearr_64813_64823[(2)] = inst_64787);

(statearr_64813_64823[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__10945__auto____0 = (function (){
var statearr_64814 = [null,null,null,null,null,null,null,null];
(statearr_64814[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__10945__auto__);

(statearr_64814[(1)] = (1));

return statearr_64814;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__10945__auto____1 = (function (state_64802){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_64802);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e64815){var ex__10948__auto__ = e64815;
var statearr_64816_64824 = state_64802;
(statearr_64816_64824[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_64802[(4)]))){
var statearr_64817_64825 = state_64802;
(statearr_64817_64825[(1)] = cljs.core.first.call(null,(state_64802[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64826 = state_64802;
state_64802 = G__64826;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__10945__auto__ = function(state_64802){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__10945__auto____1.call(this,state_64802);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_64818 = f__11019__auto__.call(null);
(statearr_64818[(6)] = c__11018__auto__);

return statearr_64818;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_64856){
var state_val_64857 = (state_64856[(1)]);
if((state_val_64857 === (7))){
var state_64856__$1 = state_64856;
var statearr_64858_64877 = state_64856__$1;
(statearr_64858_64877[(2)] = str);

(statearr_64858_64877[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64857 === (1))){
var state_64856__$1 = state_64856;
var statearr_64859_64878 = state_64856__$1;
(statearr_64859_64878[(2)] = null);

(statearr_64859_64878[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64857 === (4))){
var inst_64827 = (state_64856[(2)]);
var state_64856__$1 = state_64856;
var statearr_64860_64879 = state_64856__$1;
(statearr_64860_64879[(2)] = inst_64827);

(statearr_64860_64879[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64857 === (6))){
var state_64856__$1 = state_64856;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64856__$1,(9),str);
} else {
if((state_val_64857 === (3))){
var inst_64854 = (state_64856[(2)]);
var state_64856__$1 = state_64856;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64856__$1,inst_64854);
} else {
if((state_val_64857 === (2))){
var _ = (function (){var statearr_64862 = state_64856;
(statearr_64862[(4)] = cljs.core.cons.call(null,(5),(state_64856[(4)])));

return statearr_64862;
})();
var inst_64833 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_64856__$1 = state_64856;
if(inst_64833){
var statearr_64863_64880 = state_64856__$1;
(statearr_64863_64880[(1)] = (6));

} else {
var statearr_64864_64881 = state_64856__$1;
(statearr_64864_64881[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64857 === (9))){
var inst_64836 = (state_64856[(2)]);
var inst_64837 = fluree.db.util.async.throw_err.call(null,inst_64836);
var state_64856__$1 = state_64856;
var statearr_64865_64882 = state_64856__$1;
(statearr_64865_64882[(2)] = inst_64837);

(statearr_64865_64882[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64857 === (5))){
var _ = (function (){var statearr_64866 = state_64856;
(statearr_64866[(4)] = cljs.core.rest.call(null,(state_64856[(4)])));

return statearr_64866;
})();
var state_64856__$1 = state_64856;
var ex64861 = (state_64856__$1[(2)]);
var statearr_64867_64883 = state_64856__$1;
(statearr_64867_64883[(5)] = ex64861);


if((ex64861 instanceof Error)){
var statearr_64868_64884 = state_64856__$1;
(statearr_64868_64884[(1)] = (4));

(statearr_64868_64884[(5)] = null);

} else {
throw ex64861;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64857 === (8))){
var inst_64840 = (state_64856[(2)]);
var inst_64841 = fluree.db.dbfunctions.internal.lower_case.call(null,inst_64840);
var inst_64842 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64843 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64844 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64845 = [inst_64840];
var inst_64846 = (new cljs.core.PersistentVector(null,1,(5),inst_64844,inst_64845,null));
var inst_64847 = ["lower-case",inst_64846,inst_64841];
var inst_64848 = cljs.core.PersistentHashMap.fromArrays(inst_64843,inst_64847);
var inst_64849 = [inst_64848,(10)];
var inst_64850 = (new cljs.core.PersistentVector(null,2,(5),inst_64842,inst_64849,null));
var inst_64851 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64850);
var _ = (function (){var statearr_64869 = state_64856;
(statearr_64869[(4)] = cljs.core.rest.call(null,(state_64856[(4)])));

return statearr_64869;
})();
var state_64856__$1 = (function (){var statearr_64870 = state_64856;
(statearr_64870[(7)] = inst_64851);

return statearr_64870;
})();
var statearr_64871_64885 = state_64856__$1;
(statearr_64871_64885[(2)] = inst_64841);

(statearr_64871_64885[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__10945__auto____0 = (function (){
var statearr_64872 = [null,null,null,null,null,null,null,null];
(statearr_64872[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__10945__auto__);

(statearr_64872[(1)] = (1));

return statearr_64872;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__10945__auto____1 = (function (state_64856){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_64856);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e64873){var ex__10948__auto__ = e64873;
var statearr_64874_64886 = state_64856;
(statearr_64874_64886[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_64856[(4)]))){
var statearr_64875_64887 = state_64856;
(statearr_64875_64887[(1)] = cljs.core.first.call(null,(state_64856[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64888 = state_64856;
state_64856 = G__64888;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__10945__auto__ = function(state_64856){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__10945__auto____1.call(this,state_64856);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_64876 = f__11019__auto__.call(null);
(statearr_64876[(6)] = c__11018__auto__);

return statearr_64876;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_64918){
var state_val_64919 = (state_64918[(1)]);
if((state_val_64919 === (7))){
var state_64918__$1 = state_64918;
var statearr_64920_64939 = state_64918__$1;
(statearr_64920_64939[(2)] = str);

(statearr_64920_64939[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64919 === (1))){
var state_64918__$1 = state_64918;
var statearr_64921_64940 = state_64918__$1;
(statearr_64921_64940[(2)] = null);

(statearr_64921_64940[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64919 === (4))){
var inst_64889 = (state_64918[(2)]);
var state_64918__$1 = state_64918;
var statearr_64922_64941 = state_64918__$1;
(statearr_64922_64941[(2)] = inst_64889);

(statearr_64922_64941[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64919 === (6))){
var state_64918__$1 = state_64918;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64918__$1,(9),str);
} else {
if((state_val_64919 === (3))){
var inst_64916 = (state_64918[(2)]);
var state_64918__$1 = state_64918;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64918__$1,inst_64916);
} else {
if((state_val_64919 === (2))){
var _ = (function (){var statearr_64924 = state_64918;
(statearr_64924[(4)] = cljs.core.cons.call(null,(5),(state_64918[(4)])));

return statearr_64924;
})();
var inst_64895 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_64918__$1 = state_64918;
if(inst_64895){
var statearr_64925_64942 = state_64918__$1;
(statearr_64925_64942[(1)] = (6));

} else {
var statearr_64926_64943 = state_64918__$1;
(statearr_64926_64943[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64919 === (9))){
var inst_64898 = (state_64918[(2)]);
var inst_64899 = fluree.db.util.async.throw_err.call(null,inst_64898);
var state_64918__$1 = state_64918;
var statearr_64927_64944 = state_64918__$1;
(statearr_64927_64944[(2)] = inst_64899);

(statearr_64927_64944[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64919 === (5))){
var _ = (function (){var statearr_64928 = state_64918;
(statearr_64928[(4)] = cljs.core.rest.call(null,(state_64918[(4)])));

return statearr_64928;
})();
var state_64918__$1 = state_64918;
var ex64923 = (state_64918__$1[(2)]);
var statearr_64929_64945 = state_64918__$1;
(statearr_64929_64945[(5)] = ex64923);


if((ex64923 instanceof Error)){
var statearr_64930_64946 = state_64918__$1;
(statearr_64930_64946[(1)] = (4));

(statearr_64930_64946[(5)] = null);

} else {
throw ex64923;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64919 === (8))){
var inst_64902 = (state_64918[(2)]);
var inst_64903 = fluree.db.dbfunctions.internal.upper_case.call(null,inst_64902);
var inst_64904 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64905 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64907 = [inst_64902];
var inst_64908 = (new cljs.core.PersistentVector(null,1,(5),inst_64906,inst_64907,null));
var inst_64909 = ["upper-case",inst_64908,inst_64903];
var inst_64910 = cljs.core.PersistentHashMap.fromArrays(inst_64905,inst_64909);
var inst_64911 = [inst_64910,(10)];
var inst_64912 = (new cljs.core.PersistentVector(null,2,(5),inst_64904,inst_64911,null));
var inst_64913 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64912);
var _ = (function (){var statearr_64931 = state_64918;
(statearr_64931[(4)] = cljs.core.rest.call(null,(state_64918[(4)])));

return statearr_64931;
})();
var state_64918__$1 = (function (){var statearr_64932 = state_64918;
(statearr_64932[(7)] = inst_64913);

return statearr_64932;
})();
var statearr_64933_64947 = state_64918__$1;
(statearr_64933_64947[(2)] = inst_64903);

(statearr_64933_64947[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__10945__auto____0 = (function (){
var statearr_64934 = [null,null,null,null,null,null,null,null];
(statearr_64934[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__10945__auto__);

(statearr_64934[(1)] = (1));

return statearr_64934;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__10945__auto____1 = (function (state_64918){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_64918);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e64935){var ex__10948__auto__ = e64935;
var statearr_64936_64948 = state_64918;
(statearr_64936_64948[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_64918[(4)]))){
var statearr_64937_64949 = state_64918;
(statearr_64937_64949[(1)] = cljs.core.first.call(null,(state_64918[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64950 = state_64918;
state_64918 = G__64950;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__10945__auto__ = function(state_64918){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__10945__auto____1.call(this,state_64918);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_64938 = f__11019__auto__.call(null);
(statearr_64938[(6)] = c__11018__auto__);

return statearr_64938;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__5043__auto__)){
return (!(typeof cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__5043__auto__;
}
})())){
var res = cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__64952 = arguments.length;
switch (G__64952) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_64980){
var state_val_64981 = (state_64980[(1)]);
if((state_val_64981 === (1))){
var state_64980__$1 = state_64980;
var statearr_64982_64998 = state_64980__$1;
(statearr_64982_64998[(2)] = null);

(statearr_64982_64998[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64981 === (2))){
var _ = (function (){var statearr_64983 = state_64980;
(statearr_64983[(4)] = cljs.core.cons.call(null,(5),(state_64980[(4)])));

return statearr_64983;
})();
var inst_64962 = fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,additional_select);
var state_64980__$1 = state_64980;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64980__$1,(6),inst_64962);
} else {
if((state_val_64981 === (3))){
var inst_64978 = (state_64980[(2)]);
var state_64980__$1 = state_64980;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64980__$1,inst_64978);
} else {
if((state_val_64981 === (4))){
var inst_64953 = (state_64980[(2)]);
var state_64980__$1 = state_64980;
var statearr_64985_64999 = state_64980__$1;
(statearr_64985_64999[(2)] = inst_64953);

(statearr_64985_64999[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64981 === (5))){
var _ = (function (){var statearr_64986 = state_64980;
(statearr_64986[(4)] = cljs.core.rest.call(null,(state_64980[(4)])));

return statearr_64986;
})();
var state_64980__$1 = state_64980;
var ex64984 = (state_64980__$1[(2)]);
var statearr_64987_65000 = state_64980__$1;
(statearr_64987_65000[(5)] = ex64984);


if((ex64984 instanceof Error)){
var statearr_64988_65001 = state_64980__$1;
(statearr_64988_65001[(1)] = (4));

(statearr_64988_65001[(5)] = null);

} else {
throw ex64984;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64981 === (6))){
var inst_64964 = (state_64980[(2)]);
var inst_64965 = fluree.db.util.async.throw_err.call(null,inst_64964);
var inst_64966 = cljs.core.nth.call(null,inst_64965,(0),null);
var inst_64967 = cljs.core.nth.call(null,inst_64965,(1),null);
var inst_64968 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64969 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64970 = ["?s","?ctx",inst_64966];
var inst_64971 = cljs.core.PersistentHashMap.fromArrays(inst_64969,inst_64970);
var inst_64972 = ((10) + inst_64967);
var inst_64973 = [inst_64971,inst_64972];
var inst_64974 = (new cljs.core.PersistentVector(null,2,(5),inst_64968,inst_64973,null));
var inst_64975 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64974);
var _ = (function (){var statearr_64989 = state_64980;
(statearr_64989[(4)] = cljs.core.rest.call(null,(state_64980[(4)])));

return statearr_64989;
})();
var state_64980__$1 = (function (){var statearr_64990 = state_64980;
(statearr_64990[(7)] = inst_64975);

return statearr_64990;
})();
var statearr_64991_65002 = state_64980__$1;
(statearr_64991_65002[(2)] = inst_64966);

(statearr_64991_65002[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10945__auto____0 = (function (){
var statearr_64992 = [null,null,null,null,null,null,null,null];
(statearr_64992[(0)] = fluree$db$dbfunctions$fns$state_machine__10945__auto__);

(statearr_64992[(1)] = (1));

return statearr_64992;
});
var fluree$db$dbfunctions$fns$state_machine__10945__auto____1 = (function (state_64980){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_64980);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e64993){var ex__10948__auto__ = e64993;
var statearr_64994_65003 = state_64980;
(statearr_64994_65003[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_64980[(4)]))){
var statearr_64995_65004 = state_64980;
(statearr_64995_65004[(1)] = cljs.core.first.call(null,(state_64980[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65005 = state_64980;
state_64980 = G__65005;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10945__auto__ = function(state_64980){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____1.call(this,state_64980);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_64996 = f__11019__auto__.call(null);
(statearr_64996[(6)] = c__11018__auto__);

return statearr_64996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__65007 = arguments.length;
switch (G__65007) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_65045){
var state_val_65046 = (state_65045[(1)]);
if((state_val_65046 === (7))){
var inst_65038 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?p from this function interface");
var state_65045__$1 = state_65045;
var statearr_65047_65067 = state_65045__$1;
(statearr_65047_65067[(2)] = inst_65038);

(statearr_65047_65067[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65046 === (1))){
var state_65045__$1 = state_65045;
var statearr_65048_65068 = state_65045__$1;
(statearr_65048_65068[(2)] = null);

(statearr_65048_65068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65046 === (4))){
var inst_65008 = (state_65045[(2)]);
var state_65045__$1 = state_65045;
var statearr_65049_65069 = state_65045__$1;
(statearr_65049_65069[(2)] = inst_65008);

(statearr_65049_65069[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65046 === (6))){
var inst_65019 = fluree.db.dbfunctions.fns.coerce_args.call(null,additional_select);
var state_65045__$1 = state_65045;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65045__$1,(10),inst_65019);
} else {
if((state_val_65046 === (3))){
var inst_65043 = (state_65045[(2)]);
var state_65045__$1 = state_65045;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65045__$1,inst_65043);
} else {
if((state_val_65046 === (2))){
var _ = (function (){var statearr_65051 = state_65045;
(statearr_65051[(4)] = cljs.core.cons.call(null,(5),(state_65045[(4)])));

return statearr_65051;
})();
var inst_65014 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_65045__$1 = state_65045;
if(cljs.core.truth_(inst_65014)){
var statearr_65052_65070 = state_65045__$1;
(statearr_65052_65070[(1)] = (6));

} else {
var statearr_65053_65071 = state_65045__$1;
(statearr_65053_65071[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65046 === (9))){
var inst_65025 = (state_65045[(2)]);
var inst_65026 = fluree.db.util.async.throw_err.call(null,inst_65025);
var inst_65027 = cljs.core.nth.call(null,inst_65026,(0),null);
var inst_65028 = cljs.core.nth.call(null,inst_65026,(1),null);
var inst_65029 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65030 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65031 = ["?p","?ctx",inst_65027];
var inst_65032 = cljs.core.PersistentHashMap.fromArrays(inst_65030,inst_65031);
var inst_65033 = ((10) + inst_65028);
var inst_65034 = [inst_65032,inst_65033];
var inst_65035 = (new cljs.core.PersistentVector(null,2,(5),inst_65029,inst_65034,null));
var inst_65036 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65035);
var state_65045__$1 = (function (){var statearr_65054 = state_65045;
(statearr_65054[(7)] = inst_65036);

return statearr_65054;
})();
var statearr_65055_65072 = state_65045__$1;
(statearr_65055_65072[(2)] = inst_65027);

(statearr_65055_65072[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65046 === (5))){
var _ = (function (){var statearr_65056 = state_65045;
(statearr_65056[(4)] = cljs.core.rest.call(null,(state_65045[(4)])));

return statearr_65056;
})();
var state_65045__$1 = state_65045;
var ex65050 = (state_65045__$1[(2)]);
var statearr_65057_65073 = state_65045__$1;
(statearr_65057_65073[(5)] = ex65050);


if((ex65050 instanceof Error)){
var statearr_65058_65074 = state_65045__$1;
(statearr_65058_65074[(1)] = (4));

(statearr_65058_65074[(5)] = null);

} else {
throw ex65050;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65046 === (10))){
var inst_65021 = (state_65045[(2)]);
var inst_65022 = fluree.db.util.async.throw_err.call(null,inst_65021);
var inst_65023 = fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,inst_65022);
var state_65045__$1 = state_65045;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65045__$1,(9),inst_65023);
} else {
if((state_val_65046 === (8))){
var inst_65040 = (state_65045[(2)]);
var _ = (function (){var statearr_65059 = state_65045;
(statearr_65059[(4)] = cljs.core.rest.call(null,(state_65045[(4)])));

return statearr_65059;
})();
var state_65045__$1 = state_65045;
var statearr_65060_65075 = state_65045__$1;
(statearr_65060_65075[(2)] = inst_65040);

(statearr_65060_65075[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10945__auto____0 = (function (){
var statearr_65061 = [null,null,null,null,null,null,null,null];
(statearr_65061[(0)] = fluree$db$dbfunctions$fns$state_machine__10945__auto__);

(statearr_65061[(1)] = (1));

return statearr_65061;
});
var fluree$db$dbfunctions$fns$state_machine__10945__auto____1 = (function (state_65045){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_65045);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e65062){var ex__10948__auto__ = e65062;
var statearr_65063_65076 = state_65045;
(statearr_65063_65076[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_65045[(4)]))){
var statearr_65064_65077 = state_65045;
(statearr_65064_65077[(1)] = cljs.core.first.call(null,(state_65045[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65078 = state_65045;
state_65045 = G__65078;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10945__auto__ = function(state_65045){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____1.call(this,state_65045);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_65065 = f__11019__auto__.call(null);
(statearr_65065[(6)] = c__11018__auto__);

return statearr_65065;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__5774__auto__ = [];
var len__5768__auto___65127 = arguments.length;
var i__5769__auto___65128 = (0);
while(true){
if((i__5769__auto___65128 < len__5768__auto___65127)){
args__5774__auto__.push((arguments[i__5769__auto___65128]));

var G__65129 = (i__5769__auto___65128 + (1));
i__5769__auto___65128 = G__65129;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_65110){
var state_val_65111 = (state_65110[(1)]);
if((state_val_65111 === (1))){
var state_65110__$1 = state_65110;
var statearr_65112_65130 = state_65110__$1;
(statearr_65112_65130[(2)] = null);

(statearr_65112_65130[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65111 === (2))){
var _ = (function (){var statearr_65113 = state_65110;
(statearr_65113[(4)] = cljs.core.cons.call(null,(5),(state_65110[(4)])));

return statearr_65113;
})();
var inst_65087 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_65110__$1 = state_65110;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65110__$1,(6),inst_65087);
} else {
if((state_val_65111 === (3))){
var inst_65108 = (state_65110[(2)]);
var state_65110__$1 = state_65110;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65110__$1,inst_65108);
} else {
if((state_val_65111 === (4))){
var inst_65081 = (state_65110[(2)]);
var state_65110__$1 = state_65110;
var statearr_65115_65131 = state_65110__$1;
(statearr_65115_65131[(2)] = inst_65081);

(statearr_65115_65131[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65111 === (5))){
var _ = (function (){var statearr_65116 = state_65110;
(statearr_65116[(4)] = cljs.core.rest.call(null,(state_65110[(4)])));

return statearr_65116;
})();
var state_65110__$1 = state_65110;
var ex65114 = (state_65110__$1[(2)]);
var statearr_65117_65132 = state_65110__$1;
(statearr_65117_65132[(5)] = ex65114);


if((ex65114 instanceof Error)){
var statearr_65118_65133 = state_65110__$1;
(statearr_65118_65133[(1)] = (4));

(statearr_65118_65133[(5)] = null);

} else {
throw ex65114;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65111 === (6))){
var inst_65089 = (state_65110[(2)]);
var inst_65090 = fluree.db.util.async.throw_err.call(null,inst_65089);
var inst_65091 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.and,inst_65090);
var inst_65092 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65093 = [inst_65090];
var inst_65094 = (new cljs.core.PersistentVector(null,1,(5),inst_65092,inst_65093,null));
var inst_65095 = cljs.core.count.call(null,inst_65094);
var inst_65096 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65097 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65098 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65099 = [inst_65090];
var inst_65100 = (new cljs.core.PersistentVector(null,1,(5),inst_65098,inst_65099,null));
var inst_65101 = ["and",inst_65100,inst_65091];
var inst_65102 = cljs.core.PersistentHashMap.fromArrays(inst_65097,inst_65101);
var inst_65103 = [inst_65102,inst_65095];
var inst_65104 = (new cljs.core.PersistentVector(null,2,(5),inst_65096,inst_65103,null));
var inst_65105 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65104);
var _ = (function (){var statearr_65119 = state_65110;
(statearr_65119[(4)] = cljs.core.rest.call(null,(state_65110[(4)])));

return statearr_65119;
})();
var state_65110__$1 = (function (){var statearr_65120 = state_65110;
(statearr_65120[(7)] = inst_65105);

return statearr_65120;
})();
var statearr_65121_65134 = state_65110__$1;
(statearr_65121_65134[(2)] = inst_65091);

(statearr_65121_65134[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10945__auto____0 = (function (){
var statearr_65122 = [null,null,null,null,null,null,null,null];
(statearr_65122[(0)] = fluree$db$dbfunctions$fns$state_machine__10945__auto__);

(statearr_65122[(1)] = (1));

return statearr_65122;
});
var fluree$db$dbfunctions$fns$state_machine__10945__auto____1 = (function (state_65110){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_65110);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e65123){var ex__10948__auto__ = e65123;
var statearr_65124_65135 = state_65110;
(statearr_65124_65135[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_65110[(4)]))){
var statearr_65125_65136 = state_65110;
(statearr_65125_65136[(1)] = cljs.core.first.call(null,(state_65110[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65137 = state_65110;
state_65110 = G__65137;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10945__auto__ = function(state_65110){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____1.call(this,state_65110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_65126 = f__11019__auto__.call(null);
(statearr_65126[(6)] = c__11018__auto__);

return statearr_65126;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq65079){
var G__65080 = cljs.core.first.call(null,seq65079);
var seq65079__$1 = cljs.core.next.call(null,seq65079);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65080,seq65079__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__5774__auto__ = [];
var len__5768__auto___65186 = arguments.length;
var i__5769__auto___65187 = (0);
while(true){
if((i__5769__auto___65187 < len__5768__auto___65186)){
args__5774__auto__.push((arguments[i__5769__auto___65187]));

var G__65188 = (i__5769__auto___65187 + (1));
i__5769__auto___65187 = G__65188;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_65169){
var state_val_65170 = (state_65169[(1)]);
if((state_val_65170 === (1))){
var state_65169__$1 = state_65169;
var statearr_65171_65189 = state_65169__$1;
(statearr_65171_65189[(2)] = null);

(statearr_65171_65189[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65170 === (2))){
var _ = (function (){var statearr_65172 = state_65169;
(statearr_65172[(4)] = cljs.core.cons.call(null,(5),(state_65169[(4)])));

return statearr_65172;
})();
var inst_65146 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_65169__$1 = state_65169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65169__$1,(6),inst_65146);
} else {
if((state_val_65170 === (3))){
var inst_65167 = (state_65169[(2)]);
var state_65169__$1 = state_65169;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65169__$1,inst_65167);
} else {
if((state_val_65170 === (4))){
var inst_65140 = (state_65169[(2)]);
var state_65169__$1 = state_65169;
var statearr_65174_65190 = state_65169__$1;
(statearr_65174_65190[(2)] = inst_65140);

(statearr_65174_65190[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65170 === (5))){
var _ = (function (){var statearr_65175 = state_65169;
(statearr_65175[(4)] = cljs.core.rest.call(null,(state_65169[(4)])));

return statearr_65175;
})();
var state_65169__$1 = state_65169;
var ex65173 = (state_65169__$1[(2)]);
var statearr_65176_65191 = state_65169__$1;
(statearr_65176_65191[(5)] = ex65173);


if((ex65173 instanceof Error)){
var statearr_65177_65192 = state_65169__$1;
(statearr_65177_65192[(1)] = (4));

(statearr_65177_65192[(5)] = null);

} else {
throw ex65173;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65170 === (6))){
var inst_65148 = (state_65169[(2)]);
var inst_65149 = fluree.db.util.async.throw_err.call(null,inst_65148);
var inst_65150 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.or,inst_65149);
var inst_65151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65152 = [inst_65149];
var inst_65153 = (new cljs.core.PersistentVector(null,1,(5),inst_65151,inst_65152,null));
var inst_65154 = cljs.core.count.call(null,inst_65153);
var inst_65155 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65156 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65157 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65158 = [inst_65149];
var inst_65159 = (new cljs.core.PersistentVector(null,1,(5),inst_65157,inst_65158,null));
var inst_65160 = ["or",inst_65159,inst_65150];
var inst_65161 = cljs.core.PersistentHashMap.fromArrays(inst_65156,inst_65160);
var inst_65162 = [inst_65161,inst_65154];
var inst_65163 = (new cljs.core.PersistentVector(null,2,(5),inst_65155,inst_65162,null));
var inst_65164 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65163);
var _ = (function (){var statearr_65178 = state_65169;
(statearr_65178[(4)] = cljs.core.rest.call(null,(state_65169[(4)])));

return statearr_65178;
})();
var state_65169__$1 = (function (){var statearr_65179 = state_65169;
(statearr_65179[(7)] = inst_65164);

return statearr_65179;
})();
var statearr_65180_65193 = state_65169__$1;
(statearr_65180_65193[(2)] = inst_65150);

(statearr_65180_65193[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10945__auto____0 = (function (){
var statearr_65181 = [null,null,null,null,null,null,null,null];
(statearr_65181[(0)] = fluree$db$dbfunctions$fns$state_machine__10945__auto__);

(statearr_65181[(1)] = (1));

return statearr_65181;
});
var fluree$db$dbfunctions$fns$state_machine__10945__auto____1 = (function (state_65169){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_65169);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e65182){var ex__10948__auto__ = e65182;
var statearr_65183_65194 = state_65169;
(statearr_65183_65194[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_65169[(4)]))){
var statearr_65184_65195 = state_65169;
(statearr_65184_65195[(1)] = cljs.core.first.call(null,(state_65169[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65196 = state_65169;
state_65169 = G__65196;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10945__auto__ = function(state_65169){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____1.call(this,state_65169);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_65185 = f__11019__auto__.call(null);
(statearr_65185[(6)] = c__11018__auto__);

return statearr_65185;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq65138){
var G__65139 = cljs.core.first.call(null,seq65138);
var seq65138__$1 = cljs.core.next.call(null,seq65138);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65139,seq65138__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_65234){
var state_val_65235 = (state_65234[(1)]);
if((state_val_65235 === (7))){
var inst_65210 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_65234__$1 = state_65234;
if(inst_65210){
var statearr_65236_65259 = state_65234__$1;
(statearr_65236_65259[(1)] = (10));

} else {
var statearr_65237_65260 = state_65234__$1;
(statearr_65237_65260[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65235 === (1))){
var state_65234__$1 = state_65234;
var statearr_65238_65261 = state_65234__$1;
(statearr_65238_65261[(2)] = null);

(statearr_65238_65261[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65235 === (4))){
var inst_65197 = (state_65234[(2)]);
var state_65234__$1 = state_65234;
var statearr_65239_65262 = state_65234__$1;
(statearr_65239_65262[(2)] = inst_65197);

(statearr_65239_65262[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65235 === (13))){
var inst_65213 = (state_65234[(2)]);
var inst_65214 = fluree.db.util.async.throw_err.call(null,inst_65213);
var state_65234__$1 = state_65234;
var statearr_65240_65263 = state_65234__$1;
(statearr_65240_65263[(2)] = inst_65214);

(statearr_65240_65263[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65235 === (6))){
var inst_65205 = fluree.db.dbfunctions.fns.coerce_args.call(null,coll);
var state_65234__$1 = state_65234;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65234__$1,(9),inst_65205);
} else {
if((state_val_65235 === (3))){
var inst_65232 = (state_65234[(2)]);
var state_65234__$1 = state_65234;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65234__$1,inst_65232);
} else {
if((state_val_65235 === (12))){
var inst_65217 = (state_65234[(2)]);
var state_65234__$1 = state_65234;
var statearr_65241_65264 = state_65234__$1;
(statearr_65241_65264[(2)] = inst_65217);

(statearr_65241_65264[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65235 === (2))){
var _ = (function (){var statearr_65242 = state_65234;
(statearr_65242[(4)] = cljs.core.cons.call(null,(5),(state_65234[(4)])));

return statearr_65242;
})();
var inst_65203 = cljs.core.vector_QMARK_.call(null,coll);
var state_65234__$1 = state_65234;
if(inst_65203){
var statearr_65243_65265 = state_65234__$1;
(statearr_65243_65265[(1)] = (6));

} else {
var statearr_65244_65266 = state_65234__$1;
(statearr_65244_65266[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65235 === (11))){
var state_65234__$1 = state_65234;
var statearr_65246_65267 = state_65234__$1;
(statearr_65246_65267[(2)] = coll);

(statearr_65246_65267[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65235 === (9))){
var inst_65207 = (state_65234[(2)]);
var inst_65208 = fluree.db.util.async.throw_err.call(null,inst_65207);
var state_65234__$1 = state_65234;
var statearr_65247_65268 = state_65234__$1;
(statearr_65247_65268[(2)] = inst_65208);

(statearr_65247_65268[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65235 === (5))){
var _ = (function (){var statearr_65248 = state_65234;
(statearr_65248[(4)] = cljs.core.rest.call(null,(state_65234[(4)])));

return statearr_65248;
})();
var state_65234__$1 = state_65234;
var ex65245 = (state_65234__$1[(2)]);
var statearr_65249_65269 = state_65234__$1;
(statearr_65249_65269[(5)] = ex65245);


if((ex65245 instanceof Error)){
var statearr_65250_65270 = state_65234__$1;
(statearr_65250_65270[(1)] = (4));

(statearr_65250_65270[(5)] = null);

} else {
throw ex65245;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65235 === (10))){
var state_65234__$1 = state_65234;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65234__$1,(13),coll);
} else {
if((state_val_65235 === (8))){
var inst_65219 = (state_65234[(2)]);
var inst_65220 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_65219);
var inst_65221 = cljs.core.count.call(null,inst_65220);
var inst_65222 = ((9) + inst_65221);
var inst_65223 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65224 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65225 = ["count",inst_65219,inst_65221];
var inst_65226 = cljs.core.PersistentHashMap.fromArrays(inst_65224,inst_65225);
var inst_65227 = [inst_65226,inst_65222];
var inst_65228 = (new cljs.core.PersistentVector(null,2,(5),inst_65223,inst_65227,null));
var inst_65229 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65228);
var _ = (function (){var statearr_65251 = state_65234;
(statearr_65251[(4)] = cljs.core.rest.call(null,(state_65234[(4)])));

return statearr_65251;
})();
var state_65234__$1 = (function (){var statearr_65252 = state_65234;
(statearr_65252[(7)] = inst_65229);

return statearr_65252;
})();
var statearr_65253_65271 = state_65234__$1;
(statearr_65253_65271[(2)] = inst_65221);

(statearr_65253_65271[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__10945__auto____0 = (function (){
var statearr_65254 = [null,null,null,null,null,null,null,null];
(statearr_65254[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__10945__auto__);

(statearr_65254[(1)] = (1));

return statearr_65254;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__10945__auto____1 = (function (state_65234){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_65234);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e65255){var ex__10948__auto__ = e65255;
var statearr_65256_65272 = state_65234;
(statearr_65256_65272[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_65234[(4)]))){
var statearr_65257_65273 = state_65234;
(statearr_65257_65273[(1)] = cljs.core.first.call(null,(state_65234[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65274 = state_65234;
state_65234 = G__65274;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__10945__auto__ = function(state_65234){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__10945__auto____1.call(this,state_65234);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_65258 = f__11019__auto__.call(null);
(statearr_65258[(6)] = c__11018__auto__);

return statearr_65258;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_65324){
var state_val_65325 = (state_65324[(1)]);
if((state_val_65325 === (7))){
var state_65324__$1 = state_65324;
var statearr_65326_65359 = state_65324__$1;
(statearr_65326_65359[(2)] = subject);

(statearr_65326_65359[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65325 === (1))){
var state_65324__$1 = state_65324;
var statearr_65327_65360 = state_65324__$1;
(statearr_65327_65360[(2)] = null);

(statearr_65327_65360[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65325 === (4))){
var inst_65275 = (state_65324[(2)]);
var state_65324__$1 = state_65324;
var statearr_65328_65361 = state_65324__$1;
(statearr_65328_65361[(2)] = inst_65275);

(statearr_65328_65361[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65325 === (15))){
var inst_65288 = (state_65324[(7)]);
var state_65324__$1 = state_65324;
var statearr_65329_65362 = state_65324__$1;
(statearr_65329_65362[(2)] = inst_65288);

(statearr_65329_65362[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65325 === (13))){
var inst_65292 = (state_65324[(2)]);
var inst_65293 = fluree.db.util.async.throw_err.call(null,inst_65292);
var state_65324__$1 = state_65324;
var statearr_65330_65363 = state_65324__$1;
(statearr_65330_65363[(2)] = inst_65293);

(statearr_65330_65363[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65325 === (6))){
var state_65324__$1 = state_65324;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65324__$1,(9),subject);
} else {
if((state_val_65325 === (17))){
var inst_65288 = (state_65324[(7)]);
var inst_65302 = cljs.core.first.call(null,inst_65288);
var state_65324__$1 = state_65324;
var statearr_65331_65364 = state_65324__$1;
(statearr_65331_65364[(2)] = inst_65302);

(statearr_65331_65364[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65325 === (3))){
var inst_65322 = (state_65324[(2)]);
var state_65324__$1 = state_65324;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65324__$1,inst_65322);
} else {
if((state_val_65325 === (12))){
var inst_65288 = (state_65324[(7)]);
var inst_65296 = (state_65324[(2)]);
var inst_65297 = cljs.core.vector_QMARK_.call(null,inst_65288);
var state_65324__$1 = (function (){var statearr_65332 = state_65324;
(statearr_65332[(8)] = inst_65296);

return statearr_65332;
})();
if(inst_65297){
var statearr_65333_65365 = state_65324__$1;
(statearr_65333_65365[(1)] = (14));

} else {
var statearr_65334_65366 = state_65324__$1;
(statearr_65334_65366[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65325 === (2))){
var _ = (function (){var statearr_65335 = state_65324;
(statearr_65335[(4)] = cljs.core.cons.call(null,(5),(state_65324[(4)])));

return statearr_65335;
})();
var inst_65281 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_65324__$1 = state_65324;
if(inst_65281){
var statearr_65336_65367 = state_65324__$1;
(statearr_65336_65367[(1)] = (6));

} else {
var statearr_65337_65368 = state_65324__$1;
(statearr_65337_65368[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65325 === (19))){
var inst_65305 = (state_65324[(2)]);
var state_65324__$1 = state_65324;
var statearr_65338_65369 = state_65324__$1;
(statearr_65338_65369[(2)] = inst_65305);

(statearr_65338_65369[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65325 === (11))){
var state_65324__$1 = state_65324;
var statearr_65340_65370 = state_65324__$1;
(statearr_65340_65370[(2)] = pred);

(statearr_65340_65370[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65325 === (9))){
var inst_65284 = (state_65324[(2)]);
var inst_65285 = fluree.db.util.async.throw_err.call(null,inst_65284);
var state_65324__$1 = state_65324;
var statearr_65341_65371 = state_65324__$1;
(statearr_65341_65371[(2)] = inst_65285);

(statearr_65341_65371[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65325 === (5))){
var _ = (function (){var statearr_65342 = state_65324;
(statearr_65342[(4)] = cljs.core.rest.call(null,(state_65324[(4)])));

return statearr_65342;
})();
var state_65324__$1 = state_65324;
var ex65339 = (state_65324__$1[(2)]);
var statearr_65343_65372 = state_65324__$1;
(statearr_65343_65372[(5)] = ex65339);


if((ex65339 instanceof Error)){
var statearr_65344_65373 = state_65324__$1;
(statearr_65344_65373[(1)] = (4));

(statearr_65344_65373[(5)] = null);

} else {
throw ex65339;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65325 === (14))){
var inst_65288 = (state_65324[(7)]);
var inst_65299 = cljs.core.count.call(null,inst_65288);
var inst_65300 = cljs.core._EQ_.call(null,(1),inst_65299);
var state_65324__$1 = state_65324;
if(inst_65300){
var statearr_65345_65374 = state_65324__$1;
(statearr_65345_65374[(1)] = (17));

} else {
var statearr_65346_65375 = state_65324__$1;
(statearr_65346_65375[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65325 === (16))){
var inst_65296 = (state_65324[(8)]);
var inst_65288 = (state_65324[(7)]);
var inst_65308 = (state_65324[(2)]);
var inst_65309 = fluree.db.dbfunctions.internal.get.call(null,inst_65308,inst_65296);
var inst_65310 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65311 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65312 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65313 = [inst_65288,inst_65296];
var inst_65314 = (new cljs.core.PersistentVector(null,2,(5),inst_65312,inst_65313,null));
var inst_65315 = ["get",inst_65314,inst_65309];
var inst_65316 = cljs.core.PersistentHashMap.fromArrays(inst_65311,inst_65315);
var inst_65317 = [inst_65316,(10)];
var inst_65318 = (new cljs.core.PersistentVector(null,2,(5),inst_65310,inst_65317,null));
var inst_65319 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65318);
var _ = (function (){var statearr_65347 = state_65324;
(statearr_65347[(4)] = cljs.core.rest.call(null,(state_65324[(4)])));

return statearr_65347;
})();
var state_65324__$1 = (function (){var statearr_65348 = state_65324;
(statearr_65348[(9)] = inst_65319);

return statearr_65348;
})();
var statearr_65349_65376 = state_65324__$1;
(statearr_65349_65376[(2)] = inst_65309);

(statearr_65349_65376[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65325 === (10))){
var state_65324__$1 = state_65324;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65324__$1,(13),pred);
} else {
if((state_val_65325 === (18))){
var inst_65288 = (state_65324[(7)]);
var state_65324__$1 = state_65324;
var statearr_65350_65377 = state_65324__$1;
(statearr_65350_65377[(2)] = inst_65288);

(statearr_65350_65377[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65325 === (8))){
var inst_65288 = (state_65324[(2)]);
var inst_65289 = fluree.db.util.async.channel_QMARK_.call(null,pred);
var state_65324__$1 = (function (){var statearr_65351 = state_65324;
(statearr_65351[(7)] = inst_65288);

return statearr_65351;
})();
if(inst_65289){
var statearr_65352_65378 = state_65324__$1;
(statearr_65352_65378[(1)] = (10));

} else {
var statearr_65353_65379 = state_65324__$1;
(statearr_65353_65379[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__10945__auto____0 = (function (){
var statearr_65354 = [null,null,null,null,null,null,null,null,null,null];
(statearr_65354[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__10945__auto__);

(statearr_65354[(1)] = (1));

return statearr_65354;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__10945__auto____1 = (function (state_65324){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_65324);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e65355){var ex__10948__auto__ = e65355;
var statearr_65356_65380 = state_65324;
(statearr_65356_65380[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_65324[(4)]))){
var statearr_65357_65381 = state_65324;
(statearr_65357_65381[(1)] = cljs.core.first.call(null,(state_65324[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65382 = state_65324;
state_65324 = G__65382;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__10945__auto__ = function(state_65324){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__10945__auto____1.call(this,state_65324);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_65358 = f__11019__auto__.call(null);
(statearr_65358[(6)] = c__11018__auto__);

return statearr_65358;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_65421){
var state_val_65422 = (state_65421[(1)]);
if((state_val_65422 === (7))){
var inst_65389 = (state_65421[(7)]);
var state_65421__$1 = state_65421;
var statearr_65423_65447 = state_65421__$1;
(statearr_65423_65447[(2)] = inst_65389);

(statearr_65423_65447[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65422 === (1))){
var state_65421__$1 = state_65421;
var statearr_65424_65448 = state_65421__$1;
(statearr_65424_65448[(2)] = null);

(statearr_65424_65448[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65422 === (4))){
var inst_65383 = (state_65421[(2)]);
var state_65421__$1 = state_65421;
var statearr_65425_65449 = state_65421__$1;
(statearr_65425_65449[(2)] = inst_65383);

(statearr_65425_65449[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65422 === (6))){
var inst_65391 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_65421__$1 = state_65421;
var statearr_65426_65450 = state_65421__$1;
(statearr_65426_65450[(2)] = inst_65391);

(statearr_65426_65450[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65422 === (3))){
var inst_65419 = (state_65421[(2)]);
var state_65421__$1 = state_65421;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65421__$1,inst_65419);
} else {
if((state_val_65422 === (12))){
var inst_65401 = (state_65421[(2)]);
var inst_65402 = fluree.db.util.async.throw_err.call(null,inst_65401);
var inst_65403 = cljs.core.nth.call(null,inst_65402,(0),null);
var inst_65404 = cljs.core.nth.call(null,inst_65402,(1),null);
var inst_65405 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65406 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65407 = ["?pO","?ctx",inst_65403];
var inst_65408 = cljs.core.PersistentHashMap.fromArrays(inst_65406,inst_65407);
var inst_65409 = ((10) + inst_65404);
var inst_65410 = [inst_65408,inst_65409];
var inst_65411 = (new cljs.core.PersistentVector(null,2,(5),inst_65405,inst_65410,null));
var inst_65412 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65411);
var state_65421__$1 = (function (){var statearr_65427 = state_65421;
(statearr_65427[(8)] = inst_65412);

return statearr_65427;
})();
var statearr_65428_65451 = state_65421__$1;
(statearr_65428_65451[(2)] = inst_65403);

(statearr_65428_65451[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65422 === (2))){
var inst_65389 = (state_65421[(7)]);
var _ = (function (){var statearr_65429 = state_65421;
(statearr_65429[(4)] = cljs.core.cons.call(null,(5),(state_65421[(4)])));

return statearr_65429;
})();
var inst_65389__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_65421__$1 = (function (){var statearr_65430 = state_65421;
(statearr_65430[(7)] = inst_65389__$1);

return statearr_65430;
})();
if(cljs.core.truth_(inst_65389__$1)){
var statearr_65431_65452 = state_65421__$1;
(statearr_65431_65452[(1)] = (6));

} else {
var statearr_65432_65453 = state_65421__$1;
(statearr_65432_65453[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65422 === (11))){
var inst_65416 = (state_65421[(2)]);
var _ = (function (){var statearr_65434 = state_65421;
(statearr_65434[(4)] = cljs.core.rest.call(null,(state_65421[(4)])));

return statearr_65434;
})();
var state_65421__$1 = state_65421;
var statearr_65435_65454 = state_65421__$1;
(statearr_65435_65454[(2)] = inst_65416);

(statearr_65435_65454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65422 === (9))){
var inst_65399 = fluree.db.dbfunctions.internal._QMARK_pO.call(null,_QMARK_ctx);
var state_65421__$1 = state_65421;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65421__$1,(12),inst_65399);
} else {
if((state_val_65422 === (5))){
var _ = (function (){var statearr_65436 = state_65421;
(statearr_65436[(4)] = cljs.core.rest.call(null,(state_65421[(4)])));

return statearr_65436;
})();
var state_65421__$1 = state_65421;
var ex65433 = (state_65421__$1[(2)]);
var statearr_65437_65455 = state_65421__$1;
(statearr_65437_65455[(5)] = ex65433);


if((ex65433 instanceof Error)){
var statearr_65438_65456 = state_65421__$1;
(statearr_65438_65456[(1)] = (4));

(statearr_65438_65456[(5)] = null);

} else {
throw ex65433;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65422 === (10))){
var inst_65414 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_65421__$1 = state_65421;
var statearr_65439_65457 = state_65421__$1;
(statearr_65439_65457[(2)] = inst_65414);

(statearr_65439_65457[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65422 === (8))){
var inst_65394 = (state_65421[(2)]);
var state_65421__$1 = state_65421;
if(cljs.core.truth_(inst_65394)){
var statearr_65440_65458 = state_65421__$1;
(statearr_65440_65458[(1)] = (9));

} else {
var statearr_65441_65459 = state_65421__$1;
(statearr_65441_65459[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10945__auto____0 = (function (){
var statearr_65442 = [null,null,null,null,null,null,null,null,null];
(statearr_65442[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10945__auto__);

(statearr_65442[(1)] = (1));

return statearr_65442;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10945__auto____1 = (function (state_65421){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_65421);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e65443){var ex__10948__auto__ = e65443;
var statearr_65444_65460 = state_65421;
(statearr_65444_65460[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_65421[(4)]))){
var statearr_65445_65461 = state_65421;
(statearr_65445_65461[(1)] = cljs.core.first.call(null,(state_65421[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65462 = state_65421;
state_65421 = G__65462;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10945__auto__ = function(state_65421){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10945__auto____1.call(this,state_65421);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_65446 = f__11019__auto__.call(null);
(statearr_65446[(6)] = c__11018__auto__);

return statearr_65446;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_65514){
var state_val_65515 = (state_65514[(1)]);
if((state_val_65515 === (7))){
var state_65514__$1 = state_65514;
var statearr_65516_65549 = state_65514__$1;
(statearr_65516_65549[(2)] = subject);

(statearr_65516_65549[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65515 === (1))){
var state_65514__$1 = state_65514;
var statearr_65517_65550 = state_65514__$1;
(statearr_65517_65550[(2)] = null);

(statearr_65517_65550[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65515 === (4))){
var inst_65463 = (state_65514[(2)]);
var state_65514__$1 = state_65514;
var statearr_65518_65551 = state_65514__$1;
(statearr_65518_65551[(2)] = inst_65463);

(statearr_65518_65551[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65515 === (15))){
var inst_65476 = (state_65514[(7)]);
var state_65514__$1 = state_65514;
var statearr_65519_65552 = state_65514__$1;
(statearr_65519_65552[(2)] = inst_65476);

(statearr_65519_65552[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65515 === (13))){
var inst_65480 = (state_65514[(2)]);
var inst_65481 = fluree.db.util.async.throw_err.call(null,inst_65480);
var state_65514__$1 = state_65514;
var statearr_65520_65553 = state_65514__$1;
(statearr_65520_65553[(2)] = inst_65481);

(statearr_65520_65553[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65515 === (6))){
var state_65514__$1 = state_65514;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65514__$1,(9),subject);
} else {
if((state_val_65515 === (17))){
var inst_65476 = (state_65514[(7)]);
var inst_65490 = cljs.core.first.call(null,inst_65476);
var state_65514__$1 = state_65514;
var statearr_65521_65554 = state_65514__$1;
(statearr_65521_65554[(2)] = inst_65490);

(statearr_65521_65554[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65515 === (3))){
var inst_65512 = (state_65514[(2)]);
var state_65514__$1 = state_65514;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65514__$1,inst_65512);
} else {
if((state_val_65515 === (12))){
var inst_65476 = (state_65514[(7)]);
var inst_65484 = (state_65514[(2)]);
var inst_65485 = cljs.core.vector_QMARK_.call(null,inst_65476);
var state_65514__$1 = (function (){var statearr_65522 = state_65514;
(statearr_65522[(8)] = inst_65484);

return statearr_65522;
})();
if(inst_65485){
var statearr_65523_65555 = state_65514__$1;
(statearr_65523_65555[(1)] = (14));

} else {
var statearr_65524_65556 = state_65514__$1;
(statearr_65524_65556[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65515 === (2))){
var _ = (function (){var statearr_65525 = state_65514;
(statearr_65525[(4)] = cljs.core.cons.call(null,(5),(state_65514[(4)])));

return statearr_65525;
})();
var inst_65469 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_65514__$1 = state_65514;
if(inst_65469){
var statearr_65526_65557 = state_65514__$1;
(statearr_65526_65557[(1)] = (6));

} else {
var statearr_65527_65558 = state_65514__$1;
(statearr_65527_65558[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65515 === (19))){
var inst_65493 = (state_65514[(2)]);
var state_65514__$1 = state_65514;
var statearr_65528_65559 = state_65514__$1;
(statearr_65528_65559[(2)] = inst_65493);

(statearr_65528_65559[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65515 === (11))){
var state_65514__$1 = state_65514;
var statearr_65530_65560 = state_65514__$1;
(statearr_65530_65560[(2)] = path);

(statearr_65530_65560[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65515 === (9))){
var inst_65472 = (state_65514[(2)]);
var inst_65473 = fluree.db.util.async.throw_err.call(null,inst_65472);
var state_65514__$1 = state_65514;
var statearr_65531_65561 = state_65514__$1;
(statearr_65531_65561[(2)] = inst_65473);

(statearr_65531_65561[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65515 === (5))){
var _ = (function (){var statearr_65532 = state_65514;
(statearr_65532[(4)] = cljs.core.rest.call(null,(state_65514[(4)])));

return statearr_65532;
})();
var state_65514__$1 = state_65514;
var ex65529 = (state_65514__$1[(2)]);
var statearr_65533_65562 = state_65514__$1;
(statearr_65533_65562[(5)] = ex65529);


if((ex65529 instanceof Error)){
var statearr_65534_65563 = state_65514__$1;
(statearr_65534_65563[(1)] = (4));

(statearr_65534_65563[(5)] = null);

} else {
throw ex65529;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65515 === (14))){
var inst_65476 = (state_65514[(7)]);
var inst_65487 = cljs.core.count.call(null,inst_65476);
var inst_65488 = cljs.core._EQ_.call(null,(1),inst_65487);
var state_65514__$1 = state_65514;
if(inst_65488){
var statearr_65535_65564 = state_65514__$1;
(statearr_65535_65564[(1)] = (17));

} else {
var statearr_65536_65565 = state_65514__$1;
(statearr_65536_65565[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65515 === (16))){
var inst_65476 = (state_65514[(7)]);
var inst_65484 = (state_65514[(8)]);
var inst_65496 = (state_65514[(2)]);
var inst_65497 = fluree.db.dbfunctions.internal.get_all.call(null,inst_65496,inst_65484);
var inst_65498 = cljs.core.count.call(null,inst_65484);
var inst_65499 = ((9) + inst_65498);
var inst_65500 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65501 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65502 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65503 = [inst_65476,inst_65484];
var inst_65504 = (new cljs.core.PersistentVector(null,2,(5),inst_65502,inst_65503,null));
var inst_65505 = ["get-all",inst_65504,inst_65497];
var inst_65506 = cljs.core.PersistentHashMap.fromArrays(inst_65501,inst_65505);
var inst_65507 = [inst_65506,inst_65499];
var inst_65508 = (new cljs.core.PersistentVector(null,2,(5),inst_65500,inst_65507,null));
var inst_65509 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65508);
var _ = (function (){var statearr_65537 = state_65514;
(statearr_65537[(4)] = cljs.core.rest.call(null,(state_65514[(4)])));

return statearr_65537;
})();
var state_65514__$1 = (function (){var statearr_65538 = state_65514;
(statearr_65538[(9)] = inst_65509);

return statearr_65538;
})();
var statearr_65539_65566 = state_65514__$1;
(statearr_65539_65566[(2)] = inst_65497);

(statearr_65539_65566[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65515 === (10))){
var state_65514__$1 = state_65514;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65514__$1,(13),path);
} else {
if((state_val_65515 === (18))){
var inst_65476 = (state_65514[(7)]);
var state_65514__$1 = state_65514;
var statearr_65540_65567 = state_65514__$1;
(statearr_65540_65567[(2)] = inst_65476);

(statearr_65540_65567[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65515 === (8))){
var inst_65476 = (state_65514[(2)]);
var inst_65477 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_65514__$1 = (function (){var statearr_65541 = state_65514;
(statearr_65541[(7)] = inst_65476);

return statearr_65541;
})();
if(inst_65477){
var statearr_65542_65568 = state_65514__$1;
(statearr_65542_65568[(1)] = (10));

} else {
var statearr_65543_65569 = state_65514__$1;
(statearr_65543_65569[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__10945__auto____0 = (function (){
var statearr_65544 = [null,null,null,null,null,null,null,null,null,null];
(statearr_65544[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__10945__auto__);

(statearr_65544[(1)] = (1));

return statearr_65544;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__10945__auto____1 = (function (state_65514){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_65514);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e65545){var ex__10948__auto__ = e65545;
var statearr_65546_65570 = state_65514;
(statearr_65546_65570[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_65514[(4)]))){
var statearr_65547_65571 = state_65514;
(statearr_65547_65571[(1)] = cljs.core.first.call(null,(state_65514[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65572 = state_65514;
state_65514 = G__65572;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__10945__auto__ = function(state_65514){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__10945__auto____1.call(this,state_65514);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_65548 = f__11019__auto__.call(null);
(statearr_65548[(6)] = c__11018__auto__);

return statearr_65548;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_65611){
var state_val_65612 = (state_65611[(1)]);
if((state_val_65612 === (7))){
var state_65611__$1 = state_65611;
var statearr_65613_65637 = state_65611__$1;
(statearr_65613_65637[(2)] = subject);

(statearr_65613_65637[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65612 === (1))){
var state_65611__$1 = state_65611;
var statearr_65614_65638 = state_65611__$1;
(statearr_65614_65638[(2)] = null);

(statearr_65614_65638[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65612 === (4))){
var inst_65573 = (state_65611[(2)]);
var state_65611__$1 = state_65611;
var statearr_65615_65639 = state_65611__$1;
(statearr_65615_65639[(2)] = inst_65573);

(statearr_65615_65639[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65612 === (13))){
var inst_65590 = (state_65611[(2)]);
var inst_65591 = fluree.db.util.async.throw_err.call(null,inst_65590);
var state_65611__$1 = state_65611;
var statearr_65616_65640 = state_65611__$1;
(statearr_65616_65640[(2)] = inst_65591);

(statearr_65616_65640[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65612 === (6))){
var state_65611__$1 = state_65611;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65611__$1,(9),subject);
} else {
if((state_val_65612 === (3))){
var inst_65609 = (state_65611[(2)]);
var state_65611__$1 = state_65611;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65611__$1,inst_65609);
} else {
if((state_val_65612 === (12))){
var inst_65586 = (state_65611[(7)]);
var inst_65594 = (state_65611[(2)]);
var inst_65595 = fluree.db.dbfunctions.internal.get_in.call(null,inst_65586,inst_65594);
var inst_65596 = cljs.core.count.call(null,inst_65594);
var inst_65597 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65598 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65599 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65600 = [inst_65586,inst_65594];
var inst_65601 = (new cljs.core.PersistentVector(null,2,(5),inst_65599,inst_65600,null));
var inst_65602 = ["get-in",inst_65601,inst_65595];
var inst_65603 = cljs.core.PersistentHashMap.fromArrays(inst_65598,inst_65602);
var inst_65604 = [inst_65603,inst_65596];
var inst_65605 = (new cljs.core.PersistentVector(null,2,(5),inst_65597,inst_65604,null));
var inst_65606 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65605);
var _ = (function (){var statearr_65617 = state_65611;
(statearr_65617[(4)] = cljs.core.rest.call(null,(state_65611[(4)])));

return statearr_65617;
})();
var state_65611__$1 = (function (){var statearr_65618 = state_65611;
(statearr_65618[(8)] = inst_65606);

return statearr_65618;
})();
var statearr_65619_65641 = state_65611__$1;
(statearr_65619_65641[(2)] = inst_65595);

(statearr_65619_65641[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65612 === (2))){
var _ = (function (){var statearr_65620 = state_65611;
(statearr_65620[(4)] = cljs.core.cons.call(null,(5),(state_65611[(4)])));

return statearr_65620;
})();
var inst_65579 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_65611__$1 = state_65611;
if(inst_65579){
var statearr_65621_65642 = state_65611__$1;
(statearr_65621_65642[(1)] = (6));

} else {
var statearr_65622_65643 = state_65611__$1;
(statearr_65622_65643[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65612 === (11))){
var state_65611__$1 = state_65611;
var statearr_65624_65644 = state_65611__$1;
(statearr_65624_65644[(2)] = path);

(statearr_65624_65644[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65612 === (9))){
var inst_65582 = (state_65611[(2)]);
var inst_65583 = fluree.db.util.async.throw_err.call(null,inst_65582);
var state_65611__$1 = state_65611;
var statearr_65625_65645 = state_65611__$1;
(statearr_65625_65645[(2)] = inst_65583);

(statearr_65625_65645[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65612 === (5))){
var _ = (function (){var statearr_65626 = state_65611;
(statearr_65626[(4)] = cljs.core.rest.call(null,(state_65611[(4)])));

return statearr_65626;
})();
var state_65611__$1 = state_65611;
var ex65623 = (state_65611__$1[(2)]);
var statearr_65627_65646 = state_65611__$1;
(statearr_65627_65646[(5)] = ex65623);


if((ex65623 instanceof Error)){
var statearr_65628_65647 = state_65611__$1;
(statearr_65628_65647[(1)] = (4));

(statearr_65628_65647[(5)] = null);

} else {
throw ex65623;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65612 === (10))){
var state_65611__$1 = state_65611;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65611__$1,(13),path);
} else {
if((state_val_65612 === (8))){
var inst_65586 = (state_65611[(2)]);
var inst_65587 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_65611__$1 = (function (){var statearr_65629 = state_65611;
(statearr_65629[(7)] = inst_65586);

return statearr_65629;
})();
if(inst_65587){
var statearr_65630_65648 = state_65611__$1;
(statearr_65630_65648[(1)] = (10));

} else {
var statearr_65631_65649 = state_65611__$1;
(statearr_65631_65649[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__10945__auto____0 = (function (){
var statearr_65632 = [null,null,null,null,null,null,null,null,null];
(statearr_65632[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__10945__auto__);

(statearr_65632[(1)] = (1));

return statearr_65632;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__10945__auto____1 = (function (state_65611){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_65611);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e65633){var ex__10948__auto__ = e65633;
var statearr_65634_65650 = state_65611;
(statearr_65634_65650[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_65611[(4)]))){
var statearr_65635_65651 = state_65611;
(statearr_65635_65651[(1)] = cljs.core.first.call(null,(state_65611[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65652 = state_65611;
state_65611 = G__65652;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__10945__auto__ = function(state_65611){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__10945__auto____1.call(this,state_65611);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_65636 = f__11019__auto__.call(null);
(statearr_65636[(6)] = c__11018__auto__);

return statearr_65636;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_65697){
var state_val_65698 = (state_65697[(1)]);
if((state_val_65698 === (7))){
var state_65697__$1 = state_65697;
var statearr_65699_65728 = state_65697__$1;
(statearr_65699_65728[(2)] = coll);

(statearr_65699_65728[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65698 === (1))){
var state_65697__$1 = state_65697;
var statearr_65700_65729 = state_65697__$1;
(statearr_65700_65729[(2)] = null);

(statearr_65700_65729[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65698 === (4))){
var inst_65653 = (state_65697[(2)]);
var state_65697__$1 = state_65697;
var statearr_65701_65730 = state_65697__$1;
(statearr_65701_65730[(2)] = inst_65653);

(statearr_65701_65730[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65698 === (15))){
var inst_65673 = (state_65697[(7)]);
var inst_65681 = (state_65697[(2)]);
var inst_65682 = fluree.db.dbfunctions.internal.contains_QMARK_.call(null,inst_65673,inst_65681);
var inst_65683 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65684 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65685 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65686 = [inst_65673,inst_65681];
var inst_65687 = (new cljs.core.PersistentVector(null,2,(5),inst_65685,inst_65686,null));
var inst_65688 = ["contains?",inst_65687,inst_65682];
var inst_65689 = cljs.core.PersistentHashMap.fromArrays(inst_65684,inst_65688);
var inst_65690 = [inst_65689,(10)];
var inst_65691 = (new cljs.core.PersistentVector(null,2,(5),inst_65683,inst_65690,null));
var inst_65692 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65691);
var _ = (function (){var statearr_65702 = state_65697;
(statearr_65702[(4)] = cljs.core.rest.call(null,(state_65697[(4)])));

return statearr_65702;
})();
var state_65697__$1 = (function (){var statearr_65703 = state_65697;
(statearr_65703[(8)] = inst_65692);

return statearr_65703;
})();
var statearr_65704_65731 = state_65697__$1;
(statearr_65704_65731[(2)] = inst_65682);

(statearr_65704_65731[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65698 === (13))){
var state_65697__$1 = state_65697;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65697__$1,(16),key);
} else {
if((state_val_65698 === (6))){
var state_65697__$1 = state_65697;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65697__$1,(9),coll);
} else {
if((state_val_65698 === (3))){
var inst_65695 = (state_65697[(2)]);
var state_65697__$1 = state_65697;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65697__$1,inst_65695);
} else {
if((state_val_65698 === (12))){
var inst_65673 = (state_65697[(2)]);
var inst_65674 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_65697__$1 = (function (){var statearr_65705 = state_65697;
(statearr_65705[(7)] = inst_65673);

return statearr_65705;
})();
if(inst_65674){
var statearr_65706_65732 = state_65697__$1;
(statearr_65706_65732[(1)] = (13));

} else {
var statearr_65707_65733 = state_65697__$1;
(statearr_65707_65733[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65698 === (2))){
var _ = (function (){var statearr_65708 = state_65697;
(statearr_65708[(4)] = cljs.core.cons.call(null,(5),(state_65697[(4)])));

return statearr_65708;
})();
var inst_65659 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_65697__$1 = state_65697;
if(inst_65659){
var statearr_65709_65734 = state_65697__$1;
(statearr_65709_65734[(1)] = (6));

} else {
var statearr_65710_65735 = state_65697__$1;
(statearr_65710_65735[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65698 === (11))){
var inst_65666 = (state_65697[(9)]);
var inst_65670 = cljs.core.flatten.call(null,inst_65666);
var inst_65671 = cljs.core.set.call(null,inst_65670);
var state_65697__$1 = state_65697;
var statearr_65712_65736 = state_65697__$1;
(statearr_65712_65736[(2)] = inst_65671);

(statearr_65712_65736[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65698 === (9))){
var inst_65662 = (state_65697[(2)]);
var inst_65663 = fluree.db.util.async.throw_err.call(null,inst_65662);
var state_65697__$1 = state_65697;
var statearr_65713_65737 = state_65697__$1;
(statearr_65713_65737[(2)] = inst_65663);

(statearr_65713_65737[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65698 === (5))){
var _ = (function (){var statearr_65714 = state_65697;
(statearr_65714[(4)] = cljs.core.rest.call(null,(state_65697[(4)])));

return statearr_65714;
})();
var state_65697__$1 = state_65697;
var ex65711 = (state_65697__$1[(2)]);
var statearr_65715_65738 = state_65697__$1;
(statearr_65715_65738[(5)] = ex65711);


if((ex65711 instanceof Error)){
var statearr_65716_65739 = state_65697__$1;
(statearr_65716_65739[(1)] = (4));

(statearr_65716_65739[(5)] = null);

} else {
throw ex65711;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65698 === (14))){
var state_65697__$1 = state_65697;
var statearr_65717_65740 = state_65697__$1;
(statearr_65717_65740[(2)] = key);

(statearr_65717_65740[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65698 === (16))){
var inst_65677 = (state_65697[(2)]);
var inst_65678 = fluree.db.util.async.throw_err.call(null,inst_65677);
var state_65697__$1 = state_65697;
var statearr_65718_65741 = state_65697__$1;
(statearr_65718_65741[(2)] = inst_65678);

(statearr_65718_65741[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65698 === (10))){
var inst_65666 = (state_65697[(9)]);
var state_65697__$1 = state_65697;
var statearr_65719_65742 = state_65697__$1;
(statearr_65719_65742[(2)] = inst_65666);

(statearr_65719_65742[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65698 === (8))){
var inst_65666 = (state_65697[(9)]);
var inst_65666__$1 = (state_65697[(2)]);
var inst_65667 = cljs.core.set_QMARK_.call(null,inst_65666__$1);
var state_65697__$1 = (function (){var statearr_65720 = state_65697;
(statearr_65720[(9)] = inst_65666__$1);

return statearr_65720;
})();
if(inst_65667){
var statearr_65721_65743 = state_65697__$1;
(statearr_65721_65743[(1)] = (10));

} else {
var statearr_65722_65744 = state_65697__$1;
(statearr_65722_65744[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10945__auto____0 = (function (){
var statearr_65723 = [null,null,null,null,null,null,null,null,null,null];
(statearr_65723[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10945__auto__);

(statearr_65723[(1)] = (1));

return statearr_65723;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10945__auto____1 = (function (state_65697){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_65697);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e65724){var ex__10948__auto__ = e65724;
var statearr_65725_65745 = state_65697;
(statearr_65725_65745[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_65697[(4)]))){
var statearr_65726_65746 = state_65697;
(statearr_65726_65746[(1)] = cljs.core.first.call(null,(state_65697[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65747 = state_65697;
state_65697 = G__65747;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10945__auto__ = function(state_65697){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10945__auto____1.call(this,state_65697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_65727 = f__11019__auto__.call(null);
(statearr_65727[(6)] = c__11018__auto__);

return statearr_65727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__5774__auto__ = [];
var len__5768__auto___65819 = arguments.length;
var i__5769__auto___65820 = (0);
while(true){
if((i__5769__auto___65820 < len__5768__auto___65819)){
args__5774__auto__.push((arguments[i__5769__auto___65820]));

var G__65821 = (i__5769__auto___65820 + (1));
i__5769__auto___65820 = G__65821;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_65793){
var state_val_65794 = (state_65793[(1)]);
if((state_val_65794 === (7))){
var inst_65759 = (state_65793[(7)]);
var inst_65763 = cljs.core.first.call(null,inst_65759);
var inst_65764 = cljs.core.coll_QMARK_.call(null,inst_65763);
var state_65793__$1 = state_65793;
var statearr_65795_65822 = state_65793__$1;
(statearr_65795_65822[(2)] = inst_65764);

(statearr_65795_65822[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65794 === (1))){
var state_65793__$1 = state_65793;
var statearr_65796_65823 = state_65793__$1;
(statearr_65796_65823[(2)] = null);

(statearr_65796_65823[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65794 === (4))){
var inst_65750 = (state_65793[(2)]);
var state_65793__$1 = state_65793;
var statearr_65797_65824 = state_65793__$1;
(statearr_65797_65824[(2)] = inst_65750);

(statearr_65797_65824[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65794 === (6))){
var inst_65761 = (state_65793[(8)]);
var inst_65759 = (state_65793[(7)]);
var inst_65758 = (state_65793[(2)]);
var inst_65759__$1 = fluree.db.util.async.throw_err.call(null,inst_65758);
var inst_65760 = cljs.core.count.call(null,inst_65759__$1);
var inst_65761__$1 = cljs.core._EQ_.call(null,(1),inst_65760);
var state_65793__$1 = (function (){var statearr_65798 = state_65793;
(statearr_65798[(8)] = inst_65761__$1);

(statearr_65798[(7)] = inst_65759__$1);

return statearr_65798;
})();
if(inst_65761__$1){
var statearr_65799_65825 = state_65793__$1;
(statearr_65799_65825[(1)] = (7));

} else {
var statearr_65800_65826 = state_65793__$1;
(statearr_65800_65826[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65794 === (3))){
var inst_65791 = (state_65793[(2)]);
var state_65793__$1 = state_65793;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65793__$1,inst_65791);
} else {
if((state_val_65794 === (12))){
var inst_65772 = (state_65793[(2)]);
var inst_65773 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.hash_set,inst_65772);
var inst_65774 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65775 = [inst_65772];
var inst_65776 = (new cljs.core.PersistentVector(null,1,(5),inst_65774,inst_65775,null));
var inst_65777 = cljs.core.count.call(null,inst_65776);
var inst_65778 = ((9) + inst_65777);
var inst_65779 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65780 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65781 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65782 = [inst_65772];
var inst_65783 = (new cljs.core.PersistentVector(null,1,(5),inst_65781,inst_65782,null));
var inst_65784 = ["hash-set",inst_65783,inst_65773];
var inst_65785 = cljs.core.PersistentHashMap.fromArrays(inst_65780,inst_65784);
var inst_65786 = [inst_65785,inst_65778];
var inst_65787 = (new cljs.core.PersistentVector(null,2,(5),inst_65779,inst_65786,null));
var inst_65788 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65787);
var _ = (function (){var statearr_65801 = state_65793;
(statearr_65801[(4)] = cljs.core.rest.call(null,(state_65793[(4)])));

return statearr_65801;
})();
var state_65793__$1 = (function (){var statearr_65802 = state_65793;
(statearr_65802[(9)] = inst_65788);

return statearr_65802;
})();
var statearr_65803_65827 = state_65793__$1;
(statearr_65803_65827[(2)] = inst_65773);

(statearr_65803_65827[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65794 === (2))){
var _ = (function (){var statearr_65804 = state_65793;
(statearr_65804[(4)] = cljs.core.cons.call(null,(5),(state_65793[(4)])));

return statearr_65804;
})();
var inst_65756 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_65793__$1 = state_65793;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65793__$1,(6),inst_65756);
} else {
if((state_val_65794 === (11))){
var inst_65759 = (state_65793[(7)]);
var state_65793__$1 = state_65793;
var statearr_65806_65828 = state_65793__$1;
(statearr_65806_65828[(2)] = inst_65759);

(statearr_65806_65828[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65794 === (9))){
var inst_65767 = (state_65793[(2)]);
var state_65793__$1 = state_65793;
if(cljs.core.truth_(inst_65767)){
var statearr_65807_65829 = state_65793__$1;
(statearr_65807_65829[(1)] = (10));

} else {
var statearr_65808_65830 = state_65793__$1;
(statearr_65808_65830[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65794 === (5))){
var _ = (function (){var statearr_65809 = state_65793;
(statearr_65809[(4)] = cljs.core.rest.call(null,(state_65793[(4)])));

return statearr_65809;
})();
var state_65793__$1 = state_65793;
var ex65805 = (state_65793__$1[(2)]);
var statearr_65810_65831 = state_65793__$1;
(statearr_65810_65831[(5)] = ex65805);


if((ex65805 instanceof Error)){
var statearr_65811_65832 = state_65793__$1;
(statearr_65811_65832[(1)] = (4));

(statearr_65811_65832[(5)] = null);

} else {
throw ex65805;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65794 === (10))){
var inst_65759 = (state_65793[(7)]);
var inst_65769 = cljs.core.first.call(null,inst_65759);
var state_65793__$1 = state_65793;
var statearr_65812_65833 = state_65793__$1;
(statearr_65812_65833[(2)] = inst_65769);

(statearr_65812_65833[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65794 === (8))){
var inst_65761 = (state_65793[(8)]);
var state_65793__$1 = state_65793;
var statearr_65813_65834 = state_65793__$1;
(statearr_65813_65834[(2)] = inst_65761);

(statearr_65813_65834[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10945__auto____0 = (function (){
var statearr_65814 = [null,null,null,null,null,null,null,null,null,null];
(statearr_65814[(0)] = fluree$db$dbfunctions$fns$state_machine__10945__auto__);

(statearr_65814[(1)] = (1));

return statearr_65814;
});
var fluree$db$dbfunctions$fns$state_machine__10945__auto____1 = (function (state_65793){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_65793);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e65815){var ex__10948__auto__ = e65815;
var statearr_65816_65835 = state_65793;
(statearr_65816_65835[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_65793[(4)]))){
var statearr_65817_65836 = state_65793;
(statearr_65817_65836[(1)] = cljs.core.first.call(null,(state_65793[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65837 = state_65793;
state_65793 = G__65837;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10945__auto__ = function(state_65793){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____1.call(this,state_65793);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_65818 = f__11019__auto__.call(null);
(statearr_65818[(6)] = c__11018__auto__);

return statearr_65818;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq65748){
var G__65749 = cljs.core.first.call(null,seq65748);
var seq65748__$1 = cljs.core.next.call(null,seq65748);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65749,seq65748__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___65887 = arguments.length;
var i__5769__auto___65888 = (0);
while(true){
if((i__5769__auto___65888 < len__5768__auto___65887)){
args__5774__auto__.push((arguments[i__5769__auto___65888]));

var G__65889 = (i__5769__auto___65888 + (1));
i__5769__auto___65888 = G__65889;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_65870){
var state_val_65871 = (state_65870[(1)]);
if((state_val_65871 === (1))){
var state_65870__$1 = state_65870;
var statearr_65872_65890 = state_65870__$1;
(statearr_65872_65890[(2)] = null);

(statearr_65872_65890[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65871 === (2))){
var _ = (function (){var statearr_65873 = state_65870;
(statearr_65873[(4)] = cljs.core.cons.call(null,(5),(state_65870[(4)])));

return statearr_65873;
})();
var inst_65846 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_65870__$1 = state_65870;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65870__$1,(6),inst_65846);
} else {
if((state_val_65871 === (3))){
var inst_65868 = (state_65870[(2)]);
var state_65870__$1 = state_65870;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65870__$1,inst_65868);
} else {
if((state_val_65871 === (4))){
var inst_65840 = (state_65870[(2)]);
var state_65870__$1 = state_65870;
var statearr_65875_65891 = state_65870__$1;
(statearr_65875_65891[(2)] = inst_65840);

(statearr_65875_65891[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65871 === (5))){
var _ = (function (){var statearr_65876 = state_65870;
(statearr_65876[(4)] = cljs.core.rest.call(null,(state_65870[(4)])));

return statearr_65876;
})();
var state_65870__$1 = state_65870;
var ex65874 = (state_65870__$1[(2)]);
var statearr_65877_65892 = state_65870__$1;
(statearr_65877_65892[(5)] = ex65874);


if((ex65874 instanceof Error)){
var statearr_65878_65893 = state_65870__$1;
(statearr_65878_65893[(1)] = (4));

(statearr_65878_65893[(5)] = null);

} else {
throw ex65874;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65871 === (6))){
var inst_65848 = (state_65870[(2)]);
var inst_65849 = fluree.db.util.async.throw_err.call(null,inst_65848);
var inst_65850 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._EQ__EQ_,inst_65849);
var inst_65851 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65852 = [inst_65849];
var inst_65853 = (new cljs.core.PersistentVector(null,1,(5),inst_65851,inst_65852,null));
var inst_65854 = cljs.core.count.call(null,inst_65853);
var inst_65855 = ((9) + inst_65854);
var inst_65856 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65857 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65858 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65859 = [inst_65849];
var inst_65860 = (new cljs.core.PersistentVector(null,1,(5),inst_65858,inst_65859,null));
var inst_65861 = ["==",inst_65860,inst_65850];
var inst_65862 = cljs.core.PersistentHashMap.fromArrays(inst_65857,inst_65861);
var inst_65863 = [inst_65862,inst_65855];
var inst_65864 = (new cljs.core.PersistentVector(null,2,(5),inst_65856,inst_65863,null));
var inst_65865 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65864);
var _ = (function (){var statearr_65879 = state_65870;
(statearr_65879[(4)] = cljs.core.rest.call(null,(state_65870[(4)])));

return statearr_65879;
})();
var state_65870__$1 = (function (){var statearr_65880 = state_65870;
(statearr_65880[(7)] = inst_65865);

return statearr_65880;
})();
var statearr_65881_65894 = state_65870__$1;
(statearr_65881_65894[(2)] = inst_65850);

(statearr_65881_65894[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10945__auto____0 = (function (){
var statearr_65882 = [null,null,null,null,null,null,null,null];
(statearr_65882[(0)] = fluree$db$dbfunctions$fns$state_machine__10945__auto__);

(statearr_65882[(1)] = (1));

return statearr_65882;
});
var fluree$db$dbfunctions$fns$state_machine__10945__auto____1 = (function (state_65870){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_65870);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e65883){var ex__10948__auto__ = e65883;
var statearr_65884_65895 = state_65870;
(statearr_65884_65895[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_65870[(4)]))){
var statearr_65885_65896 = state_65870;
(statearr_65885_65896[(1)] = cljs.core.first.call(null,(state_65870[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65897 = state_65870;
state_65870 = G__65897;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10945__auto__ = function(state_65870){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____1.call(this,state_65870);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_65886 = f__11019__auto__.call(null);
(statearr_65886[(6)] = c__11018__auto__);

return statearr_65886;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq65838){
var G__65839 = cljs.core.first.call(null,seq65838);
var seq65838__$1 = cljs.core.next.call(null,seq65838);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65839,seq65838__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___65947 = arguments.length;
var i__5769__auto___65948 = (0);
while(true){
if((i__5769__auto___65948 < len__5768__auto___65947)){
args__5774__auto__.push((arguments[i__5769__auto___65948]));

var G__65949 = (i__5769__auto___65948 + (1));
i__5769__auto___65948 = G__65949;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_65930){
var state_val_65931 = (state_65930[(1)]);
if((state_val_65931 === (1))){
var state_65930__$1 = state_65930;
var statearr_65932_65950 = state_65930__$1;
(statearr_65932_65950[(2)] = null);

(statearr_65932_65950[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65931 === (2))){
var _ = (function (){var statearr_65933 = state_65930;
(statearr_65933[(4)] = cljs.core.cons.call(null,(5),(state_65930[(4)])));

return statearr_65933;
})();
var inst_65906 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_65930__$1 = state_65930;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65930__$1,(6),inst_65906);
} else {
if((state_val_65931 === (3))){
var inst_65928 = (state_65930[(2)]);
var state_65930__$1 = state_65930;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65930__$1,inst_65928);
} else {
if((state_val_65931 === (4))){
var inst_65900 = (state_65930[(2)]);
var state_65930__$1 = state_65930;
var statearr_65935_65951 = state_65930__$1;
(statearr_65935_65951[(2)] = inst_65900);

(statearr_65935_65951[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65931 === (5))){
var _ = (function (){var statearr_65936 = state_65930;
(statearr_65936[(4)] = cljs.core.rest.call(null,(state_65930[(4)])));

return statearr_65936;
})();
var state_65930__$1 = state_65930;
var ex65934 = (state_65930__$1[(2)]);
var statearr_65937_65952 = state_65930__$1;
(statearr_65937_65952[(5)] = ex65934);


if((ex65934 instanceof Error)){
var statearr_65938_65953 = state_65930__$1;
(statearr_65938_65953[(1)] = (4));

(statearr_65938_65953[(5)] = null);

} else {
throw ex65934;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65931 === (6))){
var inst_65908 = (state_65930[(2)]);
var inst_65909 = fluree.db.util.async.throw_err.call(null,inst_65908);
var inst_65910 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT_,inst_65909);
var inst_65911 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65912 = [inst_65909];
var inst_65913 = (new cljs.core.PersistentVector(null,1,(5),inst_65911,inst_65912,null));
var inst_65914 = cljs.core.count.call(null,inst_65913);
var inst_65915 = ((9) + inst_65914);
var inst_65916 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65917 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65918 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65919 = [inst_65909];
var inst_65920 = (new cljs.core.PersistentVector(null,1,(5),inst_65918,inst_65919,null));
var inst_65921 = [">",inst_65920,inst_65910];
var inst_65922 = cljs.core.PersistentHashMap.fromArrays(inst_65917,inst_65921);
var inst_65923 = [inst_65922,inst_65915];
var inst_65924 = (new cljs.core.PersistentVector(null,2,(5),inst_65916,inst_65923,null));
var inst_65925 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65924);
var _ = (function (){var statearr_65939 = state_65930;
(statearr_65939[(4)] = cljs.core.rest.call(null,(state_65930[(4)])));

return statearr_65939;
})();
var state_65930__$1 = (function (){var statearr_65940 = state_65930;
(statearr_65940[(7)] = inst_65925);

return statearr_65940;
})();
var statearr_65941_65954 = state_65930__$1;
(statearr_65941_65954[(2)] = inst_65910);

(statearr_65941_65954[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10945__auto____0 = (function (){
var statearr_65942 = [null,null,null,null,null,null,null,null];
(statearr_65942[(0)] = fluree$db$dbfunctions$fns$state_machine__10945__auto__);

(statearr_65942[(1)] = (1));

return statearr_65942;
});
var fluree$db$dbfunctions$fns$state_machine__10945__auto____1 = (function (state_65930){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_65930);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e65943){var ex__10948__auto__ = e65943;
var statearr_65944_65955 = state_65930;
(statearr_65944_65955[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_65930[(4)]))){
var statearr_65945_65956 = state_65930;
(statearr_65945_65956[(1)] = cljs.core.first.call(null,(state_65930[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65957 = state_65930;
state_65930 = G__65957;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10945__auto__ = function(state_65930){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____1.call(this,state_65930);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_65946 = f__11019__auto__.call(null);
(statearr_65946[(6)] = c__11018__auto__);

return statearr_65946;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq65898){
var G__65899 = cljs.core.first.call(null,seq65898);
var seq65898__$1 = cljs.core.next.call(null,seq65898);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65899,seq65898__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___66007 = arguments.length;
var i__5769__auto___66008 = (0);
while(true){
if((i__5769__auto___66008 < len__5768__auto___66007)){
args__5774__auto__.push((arguments[i__5769__auto___66008]));

var G__66009 = (i__5769__auto___66008 + (1));
i__5769__auto___66008 = G__66009;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_65990){
var state_val_65991 = (state_65990[(1)]);
if((state_val_65991 === (1))){
var state_65990__$1 = state_65990;
var statearr_65992_66010 = state_65990__$1;
(statearr_65992_66010[(2)] = null);

(statearr_65992_66010[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65991 === (2))){
var _ = (function (){var statearr_65993 = state_65990;
(statearr_65993[(4)] = cljs.core.cons.call(null,(5),(state_65990[(4)])));

return statearr_65993;
})();
var inst_65966 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_65990__$1 = state_65990;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65990__$1,(6),inst_65966);
} else {
if((state_val_65991 === (3))){
var inst_65988 = (state_65990[(2)]);
var state_65990__$1 = state_65990;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65990__$1,inst_65988);
} else {
if((state_val_65991 === (4))){
var inst_65960 = (state_65990[(2)]);
var state_65990__$1 = state_65990;
var statearr_65995_66011 = state_65990__$1;
(statearr_65995_66011[(2)] = inst_65960);

(statearr_65995_66011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65991 === (5))){
var _ = (function (){var statearr_65996 = state_65990;
(statearr_65996[(4)] = cljs.core.rest.call(null,(state_65990[(4)])));

return statearr_65996;
})();
var state_65990__$1 = state_65990;
var ex65994 = (state_65990__$1[(2)]);
var statearr_65997_66012 = state_65990__$1;
(statearr_65997_66012[(5)] = ex65994);


if((ex65994 instanceof Error)){
var statearr_65998_66013 = state_65990__$1;
(statearr_65998_66013[(1)] = (4));

(statearr_65998_66013[(5)] = null);

} else {
throw ex65994;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65991 === (6))){
var inst_65968 = (state_65990[(2)]);
var inst_65969 = fluree.db.util.async.throw_err.call(null,inst_65968);
var inst_65970 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT_,inst_65969);
var inst_65971 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65972 = [inst_65969];
var inst_65973 = (new cljs.core.PersistentVector(null,1,(5),inst_65971,inst_65972,null));
var inst_65974 = cljs.core.count.call(null,inst_65973);
var inst_65975 = ((9) + inst_65974);
var inst_65976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65977 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65978 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65979 = [inst_65969];
var inst_65980 = (new cljs.core.PersistentVector(null,1,(5),inst_65978,inst_65979,null));
var inst_65981 = ["<",inst_65980,inst_65970];
var inst_65982 = cljs.core.PersistentHashMap.fromArrays(inst_65977,inst_65981);
var inst_65983 = [inst_65982,inst_65975];
var inst_65984 = (new cljs.core.PersistentVector(null,2,(5),inst_65976,inst_65983,null));
var inst_65985 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65984);
var _ = (function (){var statearr_65999 = state_65990;
(statearr_65999[(4)] = cljs.core.rest.call(null,(state_65990[(4)])));

return statearr_65999;
})();
var state_65990__$1 = (function (){var statearr_66000 = state_65990;
(statearr_66000[(7)] = inst_65985);

return statearr_66000;
})();
var statearr_66001_66014 = state_65990__$1;
(statearr_66001_66014[(2)] = inst_65970);

(statearr_66001_66014[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10945__auto____0 = (function (){
var statearr_66002 = [null,null,null,null,null,null,null,null];
(statearr_66002[(0)] = fluree$db$dbfunctions$fns$state_machine__10945__auto__);

(statearr_66002[(1)] = (1));

return statearr_66002;
});
var fluree$db$dbfunctions$fns$state_machine__10945__auto____1 = (function (state_65990){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_65990);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e66003){var ex__10948__auto__ = e66003;
var statearr_66004_66015 = state_65990;
(statearr_66004_66015[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_65990[(4)]))){
var statearr_66005_66016 = state_65990;
(statearr_66005_66016[(1)] = cljs.core.first.call(null,(state_65990[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66017 = state_65990;
state_65990 = G__66017;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10945__auto__ = function(state_65990){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____1.call(this,state_65990);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_66006 = f__11019__auto__.call(null);
(statearr_66006[(6)] = c__11018__auto__);

return statearr_66006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq65958){
var G__65959 = cljs.core.first.call(null,seq65958);
var seq65958__$1 = cljs.core.next.call(null,seq65958);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65959,seq65958__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___66067 = arguments.length;
var i__5769__auto___66068 = (0);
while(true){
if((i__5769__auto___66068 < len__5768__auto___66067)){
args__5774__auto__.push((arguments[i__5769__auto___66068]));

var G__66069 = (i__5769__auto___66068 + (1));
i__5769__auto___66068 = G__66069;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_66050){
var state_val_66051 = (state_66050[(1)]);
if((state_val_66051 === (1))){
var state_66050__$1 = state_66050;
var statearr_66052_66070 = state_66050__$1;
(statearr_66052_66070[(2)] = null);

(statearr_66052_66070[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66051 === (2))){
var _ = (function (){var statearr_66053 = state_66050;
(statearr_66053[(4)] = cljs.core.cons.call(null,(5),(state_66050[(4)])));

return statearr_66053;
})();
var inst_66026 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_66050__$1 = state_66050;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66050__$1,(6),inst_66026);
} else {
if((state_val_66051 === (3))){
var inst_66048 = (state_66050[(2)]);
var state_66050__$1 = state_66050;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66050__$1,inst_66048);
} else {
if((state_val_66051 === (4))){
var inst_66020 = (state_66050[(2)]);
var state_66050__$1 = state_66050;
var statearr_66055_66071 = state_66050__$1;
(statearr_66055_66071[(2)] = inst_66020);

(statearr_66055_66071[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66051 === (5))){
var _ = (function (){var statearr_66056 = state_66050;
(statearr_66056[(4)] = cljs.core.rest.call(null,(state_66050[(4)])));

return statearr_66056;
})();
var state_66050__$1 = state_66050;
var ex66054 = (state_66050__$1[(2)]);
var statearr_66057_66072 = state_66050__$1;
(statearr_66057_66072[(5)] = ex66054);


if((ex66054 instanceof Error)){
var statearr_66058_66073 = state_66050__$1;
(statearr_66058_66073[(1)] = (4));

(statearr_66058_66073[(5)] = null);

} else {
throw ex66054;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66051 === (6))){
var inst_66028 = (state_66050[(2)]);
var inst_66029 = fluree.db.util.async.throw_err.call(null,inst_66028);
var inst_66030 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT__EQ_,inst_66029);
var inst_66031 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66032 = [inst_66029];
var inst_66033 = (new cljs.core.PersistentVector(null,1,(5),inst_66031,inst_66032,null));
var inst_66034 = cljs.core.count.call(null,inst_66033);
var inst_66035 = ((9) + inst_66034);
var inst_66036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66037 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66038 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66039 = [inst_66029];
var inst_66040 = (new cljs.core.PersistentVector(null,1,(5),inst_66038,inst_66039,null));
var inst_66041 = ["<=",inst_66040,inst_66030];
var inst_66042 = cljs.core.PersistentHashMap.fromArrays(inst_66037,inst_66041);
var inst_66043 = [inst_66042,inst_66035];
var inst_66044 = (new cljs.core.PersistentVector(null,2,(5),inst_66036,inst_66043,null));
var inst_66045 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66044);
var _ = (function (){var statearr_66059 = state_66050;
(statearr_66059[(4)] = cljs.core.rest.call(null,(state_66050[(4)])));

return statearr_66059;
})();
var state_66050__$1 = (function (){var statearr_66060 = state_66050;
(statearr_66060[(7)] = inst_66045);

return statearr_66060;
})();
var statearr_66061_66074 = state_66050__$1;
(statearr_66061_66074[(2)] = inst_66030);

(statearr_66061_66074[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10945__auto____0 = (function (){
var statearr_66062 = [null,null,null,null,null,null,null,null];
(statearr_66062[(0)] = fluree$db$dbfunctions$fns$state_machine__10945__auto__);

(statearr_66062[(1)] = (1));

return statearr_66062;
});
var fluree$db$dbfunctions$fns$state_machine__10945__auto____1 = (function (state_66050){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_66050);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e66063){var ex__10948__auto__ = e66063;
var statearr_66064_66075 = state_66050;
(statearr_66064_66075[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_66050[(4)]))){
var statearr_66065_66076 = state_66050;
(statearr_66065_66076[(1)] = cljs.core.first.call(null,(state_66050[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66077 = state_66050;
state_66050 = G__66077;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10945__auto__ = function(state_66050){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____1.call(this,state_66050);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_66066 = f__11019__auto__.call(null);
(statearr_66066[(6)] = c__11018__auto__);

return statearr_66066;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq66018){
var G__66019 = cljs.core.first.call(null,seq66018);
var seq66018__$1 = cljs.core.next.call(null,seq66018);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66019,seq66018__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___66127 = arguments.length;
var i__5769__auto___66128 = (0);
while(true){
if((i__5769__auto___66128 < len__5768__auto___66127)){
args__5774__auto__.push((arguments[i__5769__auto___66128]));

var G__66129 = (i__5769__auto___66128 + (1));
i__5769__auto___66128 = G__66129;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_66110){
var state_val_66111 = (state_66110[(1)]);
if((state_val_66111 === (1))){
var state_66110__$1 = state_66110;
var statearr_66112_66130 = state_66110__$1;
(statearr_66112_66130[(2)] = null);

(statearr_66112_66130[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66111 === (2))){
var _ = (function (){var statearr_66113 = state_66110;
(statearr_66113[(4)] = cljs.core.cons.call(null,(5),(state_66110[(4)])));

return statearr_66113;
})();
var inst_66086 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_66110__$1 = state_66110;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66110__$1,(6),inst_66086);
} else {
if((state_val_66111 === (3))){
var inst_66108 = (state_66110[(2)]);
var state_66110__$1 = state_66110;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66110__$1,inst_66108);
} else {
if((state_val_66111 === (4))){
var inst_66080 = (state_66110[(2)]);
var state_66110__$1 = state_66110;
var statearr_66115_66131 = state_66110__$1;
(statearr_66115_66131[(2)] = inst_66080);

(statearr_66115_66131[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66111 === (5))){
var _ = (function (){var statearr_66116 = state_66110;
(statearr_66116[(4)] = cljs.core.rest.call(null,(state_66110[(4)])));

return statearr_66116;
})();
var state_66110__$1 = state_66110;
var ex66114 = (state_66110__$1[(2)]);
var statearr_66117_66132 = state_66110__$1;
(statearr_66117_66132[(5)] = ex66114);


if((ex66114 instanceof Error)){
var statearr_66118_66133 = state_66110__$1;
(statearr_66118_66133[(1)] = (4));

(statearr_66118_66133[(5)] = null);

} else {
throw ex66114;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66111 === (6))){
var inst_66088 = (state_66110[(2)]);
var inst_66089 = fluree.db.util.async.throw_err.call(null,inst_66088);
var inst_66090 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT__EQ_,inst_66089);
var inst_66091 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66092 = [inst_66089];
var inst_66093 = (new cljs.core.PersistentVector(null,1,(5),inst_66091,inst_66092,null));
var inst_66094 = cljs.core.count.call(null,inst_66093);
var inst_66095 = ((9) + inst_66094);
var inst_66096 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66097 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66098 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66099 = [inst_66089];
var inst_66100 = (new cljs.core.PersistentVector(null,1,(5),inst_66098,inst_66099,null));
var inst_66101 = [">=",inst_66100,inst_66090];
var inst_66102 = cljs.core.PersistentHashMap.fromArrays(inst_66097,inst_66101);
var inst_66103 = [inst_66102,inst_66095];
var inst_66104 = (new cljs.core.PersistentVector(null,2,(5),inst_66096,inst_66103,null));
var inst_66105 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66104);
var _ = (function (){var statearr_66119 = state_66110;
(statearr_66119[(4)] = cljs.core.rest.call(null,(state_66110[(4)])));

return statearr_66119;
})();
var state_66110__$1 = (function (){var statearr_66120 = state_66110;
(statearr_66120[(7)] = inst_66105);

return statearr_66120;
})();
var statearr_66121_66134 = state_66110__$1;
(statearr_66121_66134[(2)] = inst_66090);

(statearr_66121_66134[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10945__auto____0 = (function (){
var statearr_66122 = [null,null,null,null,null,null,null,null];
(statearr_66122[(0)] = fluree$db$dbfunctions$fns$state_machine__10945__auto__);

(statearr_66122[(1)] = (1));

return statearr_66122;
});
var fluree$db$dbfunctions$fns$state_machine__10945__auto____1 = (function (state_66110){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_66110);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e66123){var ex__10948__auto__ = e66123;
var statearr_66124_66135 = state_66110;
(statearr_66124_66135[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_66110[(4)]))){
var statearr_66125_66136 = state_66110;
(statearr_66125_66136[(1)] = cljs.core.first.call(null,(state_66110[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66137 = state_66110;
state_66110 = G__66137;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10945__auto__ = function(state_66110){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____1.call(this,state_66110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_66126 = f__11019__auto__.call(null);
(statearr_66126[(6)] = c__11018__auto__);

return statearr_66126;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq66078){
var G__66079 = cljs.core.first.call(null,seq66078);
var seq66078__$1 = cljs.core.next.call(null,seq66078);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66079,seq66078__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___66187 = arguments.length;
var i__5769__auto___66188 = (0);
while(true){
if((i__5769__auto___66188 < len__5768__auto___66187)){
args__5774__auto__.push((arguments[i__5769__auto___66188]));

var G__66189 = (i__5769__auto___66188 + (1));
i__5769__auto___66188 = G__66189;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_66170){
var state_val_66171 = (state_66170[(1)]);
if((state_val_66171 === (1))){
var state_66170__$1 = state_66170;
var statearr_66172_66190 = state_66170__$1;
(statearr_66172_66190[(2)] = null);

(statearr_66172_66190[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (2))){
var _ = (function (){var statearr_66173 = state_66170;
(statearr_66173[(4)] = cljs.core.cons.call(null,(5),(state_66170[(4)])));

return statearr_66173;
})();
var inst_66146 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_66170__$1 = state_66170;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66170__$1,(6),inst_66146);
} else {
if((state_val_66171 === (3))){
var inst_66168 = (state_66170[(2)]);
var state_66170__$1 = state_66170;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66170__$1,inst_66168);
} else {
if((state_val_66171 === (4))){
var inst_66140 = (state_66170[(2)]);
var state_66170__$1 = state_66170;
var statearr_66175_66191 = state_66170__$1;
(statearr_66175_66191[(2)] = inst_66140);

(statearr_66175_66191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (5))){
var _ = (function (){var statearr_66176 = state_66170;
(statearr_66176[(4)] = cljs.core.rest.call(null,(state_66170[(4)])));

return statearr_66176;
})();
var state_66170__$1 = state_66170;
var ex66174 = (state_66170__$1[(2)]);
var statearr_66177_66192 = state_66170__$1;
(statearr_66177_66192[(5)] = ex66174);


if((ex66174 instanceof Error)){
var statearr_66178_66193 = state_66170__$1;
(statearr_66178_66193[(1)] = (4));

(statearr_66178_66193[(5)] = null);

} else {
throw ex66174;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66171 === (6))){
var inst_66148 = (state_66170[(2)]);
var inst_66149 = fluree.db.util.async.throw_err.call(null,inst_66148);
var inst_66150 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.not_EQ_,inst_66149);
var inst_66151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66152 = [inst_66149];
var inst_66153 = (new cljs.core.PersistentVector(null,1,(5),inst_66151,inst_66152,null));
var inst_66154 = cljs.core.count.call(null,inst_66153);
var inst_66155 = ((9) + inst_66154);
var inst_66156 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66157 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66158 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66159 = [inst_66149];
var inst_66160 = (new cljs.core.PersistentVector(null,1,(5),inst_66158,inst_66159,null));
var inst_66161 = ["not=",inst_66160,inst_66150];
var inst_66162 = cljs.core.PersistentHashMap.fromArrays(inst_66157,inst_66161);
var inst_66163 = [inst_66162,inst_66155];
var inst_66164 = (new cljs.core.PersistentVector(null,2,(5),inst_66156,inst_66163,null));
var inst_66165 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66164);
var _ = (function (){var statearr_66179 = state_66170;
(statearr_66179[(4)] = cljs.core.rest.call(null,(state_66170[(4)])));

return statearr_66179;
})();
var state_66170__$1 = (function (){var statearr_66180 = state_66170;
(statearr_66180[(7)] = inst_66165);

return statearr_66180;
})();
var statearr_66181_66194 = state_66170__$1;
(statearr_66181_66194[(2)] = inst_66150);

(statearr_66181_66194[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10945__auto____0 = (function (){
var statearr_66182 = [null,null,null,null,null,null,null,null];
(statearr_66182[(0)] = fluree$db$dbfunctions$fns$state_machine__10945__auto__);

(statearr_66182[(1)] = (1));

return statearr_66182;
});
var fluree$db$dbfunctions$fns$state_machine__10945__auto____1 = (function (state_66170){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_66170);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e66183){var ex__10948__auto__ = e66183;
var statearr_66184_66195 = state_66170;
(statearr_66184_66195[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_66170[(4)]))){
var statearr_66185_66196 = state_66170;
(statearr_66185_66196[(1)] = cljs.core.first.call(null,(state_66170[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66197 = state_66170;
state_66170 = G__66197;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10945__auto__ = function(state_66170){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____1.call(this,state_66170);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_66186 = f__11019__auto__.call(null);
(statearr_66186[(6)] = c__11018__auto__);

return statearr_66186;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq66138){
var G__66139 = cljs.core.first.call(null,seq66138);
var seq66138__$1 = cljs.core.next.call(null,seq66138);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66139,seq66138__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__5774__auto__ = [];
var len__5768__auto___66247 = arguments.length;
var i__5769__auto___66248 = (0);
while(true){
if((i__5769__auto___66248 < len__5768__auto___66247)){
args__5774__auto__.push((arguments[i__5769__auto___66248]));

var G__66249 = (i__5769__auto___66248 + (1));
i__5769__auto___66248 = G__66249;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_66230){
var state_val_66231 = (state_66230[(1)]);
if((state_val_66231 === (1))){
var state_66230__$1 = state_66230;
var statearr_66232_66250 = state_66230__$1;
(statearr_66232_66250[(2)] = null);

(statearr_66232_66250[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66231 === (2))){
var _ = (function (){var statearr_66233 = state_66230;
(statearr_66233[(4)] = cljs.core.cons.call(null,(5),(state_66230[(4)])));

return statearr_66233;
})();
var inst_66206 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_66230__$1 = state_66230;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66230__$1,(6),inst_66206);
} else {
if((state_val_66231 === (3))){
var inst_66228 = (state_66230[(2)]);
var state_66230__$1 = state_66230;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66230__$1,inst_66228);
} else {
if((state_val_66231 === (4))){
var inst_66200 = (state_66230[(2)]);
var state_66230__$1 = state_66230;
var statearr_66235_66251 = state_66230__$1;
(statearr_66235_66251[(2)] = inst_66200);

(statearr_66235_66251[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66231 === (5))){
var _ = (function (){var statearr_66236 = state_66230;
(statearr_66236[(4)] = cljs.core.rest.call(null,(state_66230[(4)])));

return statearr_66236;
})();
var state_66230__$1 = state_66230;
var ex66234 = (state_66230__$1[(2)]);
var statearr_66237_66252 = state_66230__$1;
(statearr_66237_66252[(5)] = ex66234);


if((ex66234 instanceof Error)){
var statearr_66238_66253 = state_66230__$1;
(statearr_66238_66253[(1)] = (4));

(statearr_66238_66253[(5)] = null);

} else {
throw ex66234;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66231 === (6))){
var inst_66208 = (state_66230[(2)]);
var inst_66209 = fluree.db.util.async.throw_err.call(null,inst_66208);
var inst_66210 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_66209);
var inst_66211 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66212 = [inst_66209];
var inst_66213 = (new cljs.core.PersistentVector(null,1,(5),inst_66211,inst_66212,null));
var inst_66214 = cljs.core.count.call(null,inst_66213);
var inst_66215 = ((9) + inst_66214);
var inst_66216 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66217 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66218 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66219 = [inst_66209];
var inst_66220 = (new cljs.core.PersistentVector(null,1,(5),inst_66218,inst_66219,null));
var inst_66221 = ["max",inst_66220,inst_66210];
var inst_66222 = cljs.core.PersistentHashMap.fromArrays(inst_66217,inst_66221);
var inst_66223 = [inst_66222,inst_66215];
var inst_66224 = (new cljs.core.PersistentVector(null,2,(5),inst_66216,inst_66223,null));
var inst_66225 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66224);
var _ = (function (){var statearr_66239 = state_66230;
(statearr_66239[(4)] = cljs.core.rest.call(null,(state_66230[(4)])));

return statearr_66239;
})();
var state_66230__$1 = (function (){var statearr_66240 = state_66230;
(statearr_66240[(7)] = inst_66225);

return statearr_66240;
})();
var statearr_66241_66254 = state_66230__$1;
(statearr_66241_66254[(2)] = inst_66210);

(statearr_66241_66254[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10945__auto____0 = (function (){
var statearr_66242 = [null,null,null,null,null,null,null,null];
(statearr_66242[(0)] = fluree$db$dbfunctions$fns$state_machine__10945__auto__);

(statearr_66242[(1)] = (1));

return statearr_66242;
});
var fluree$db$dbfunctions$fns$state_machine__10945__auto____1 = (function (state_66230){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_66230);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e66243){var ex__10948__auto__ = e66243;
var statearr_66244_66255 = state_66230;
(statearr_66244_66255[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_66230[(4)]))){
var statearr_66245_66256 = state_66230;
(statearr_66245_66256[(1)] = cljs.core.first.call(null,(state_66230[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66257 = state_66230;
state_66230 = G__66257;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10945__auto__ = function(state_66230){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____1.call(this,state_66230);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_66246 = f__11019__auto__.call(null);
(statearr_66246[(6)] = c__11018__auto__);

return statearr_66246;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq66198){
var G__66199 = cljs.core.first.call(null,seq66198);
var seq66198__$1 = cljs.core.next.call(null,seq66198);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66199,seq66198__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__5774__auto__ = [];
var len__5768__auto___66307 = arguments.length;
var i__5769__auto___66308 = (0);
while(true){
if((i__5769__auto___66308 < len__5768__auto___66307)){
args__5774__auto__.push((arguments[i__5769__auto___66308]));

var G__66309 = (i__5769__auto___66308 + (1));
i__5769__auto___66308 = G__66309;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_66290){
var state_val_66291 = (state_66290[(1)]);
if((state_val_66291 === (1))){
var state_66290__$1 = state_66290;
var statearr_66292_66310 = state_66290__$1;
(statearr_66292_66310[(2)] = null);

(statearr_66292_66310[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66291 === (2))){
var _ = (function (){var statearr_66293 = state_66290;
(statearr_66293[(4)] = cljs.core.cons.call(null,(5),(state_66290[(4)])));

return statearr_66293;
})();
var inst_66266 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_66290__$1 = state_66290;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66290__$1,(6),inst_66266);
} else {
if((state_val_66291 === (3))){
var inst_66288 = (state_66290[(2)]);
var state_66290__$1 = state_66290;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66290__$1,inst_66288);
} else {
if((state_val_66291 === (4))){
var inst_66260 = (state_66290[(2)]);
var state_66290__$1 = state_66290;
var statearr_66295_66311 = state_66290__$1;
(statearr_66295_66311[(2)] = inst_66260);

(statearr_66295_66311[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66291 === (5))){
var _ = (function (){var statearr_66296 = state_66290;
(statearr_66296[(4)] = cljs.core.rest.call(null,(state_66290[(4)])));

return statearr_66296;
})();
var state_66290__$1 = state_66290;
var ex66294 = (state_66290__$1[(2)]);
var statearr_66297_66312 = state_66290__$1;
(statearr_66297_66312[(5)] = ex66294);


if((ex66294 instanceof Error)){
var statearr_66298_66313 = state_66290__$1;
(statearr_66298_66313[(1)] = (4));

(statearr_66298_66313[(5)] = null);

} else {
throw ex66294;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66291 === (6))){
var inst_66268 = (state_66290[(2)]);
var inst_66269 = fluree.db.util.async.throw_err.call(null,inst_66268);
var inst_66270 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.min,inst_66269);
var inst_66271 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66272 = [inst_66269];
var inst_66273 = (new cljs.core.PersistentVector(null,1,(5),inst_66271,inst_66272,null));
var inst_66274 = cljs.core.count.call(null,inst_66273);
var inst_66275 = ((9) + inst_66274);
var inst_66276 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66277 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66278 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66279 = [inst_66269];
var inst_66280 = (new cljs.core.PersistentVector(null,1,(5),inst_66278,inst_66279,null));
var inst_66281 = ["min",inst_66280,inst_66270];
var inst_66282 = cljs.core.PersistentHashMap.fromArrays(inst_66277,inst_66281);
var inst_66283 = [inst_66282,inst_66275];
var inst_66284 = (new cljs.core.PersistentVector(null,2,(5),inst_66276,inst_66283,null));
var inst_66285 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66284);
var _ = (function (){var statearr_66299 = state_66290;
(statearr_66299[(4)] = cljs.core.rest.call(null,(state_66290[(4)])));

return statearr_66299;
})();
var state_66290__$1 = (function (){var statearr_66300 = state_66290;
(statearr_66300[(7)] = inst_66285);

return statearr_66300;
})();
var statearr_66301_66314 = state_66290__$1;
(statearr_66301_66314[(2)] = inst_66270);

(statearr_66301_66314[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10945__auto____0 = (function (){
var statearr_66302 = [null,null,null,null,null,null,null,null];
(statearr_66302[(0)] = fluree$db$dbfunctions$fns$state_machine__10945__auto__);

(statearr_66302[(1)] = (1));

return statearr_66302;
});
var fluree$db$dbfunctions$fns$state_machine__10945__auto____1 = (function (state_66290){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_66290);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e66303){var ex__10948__auto__ = e66303;
var statearr_66304_66315 = state_66290;
(statearr_66304_66315[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_66290[(4)]))){
var statearr_66305_66316 = state_66290;
(statearr_66305_66316[(1)] = cljs.core.first.call(null,(state_66290[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66317 = state_66290;
state_66290 = G__66317;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10945__auto__ = function(state_66290){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____1.call(this,state_66290);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_66306 = f__11019__auto__.call(null);
(statearr_66306[(6)] = c__11018__auto__);

return statearr_66306;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq66258){
var G__66259 = cljs.core.first.call(null,seq66258);
var seq66258__$1 = cljs.core.next.call(null,seq66258);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66259,seq66258__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__66319 = arguments.length;
switch (G__66319) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_66364){
var state_val_66365 = (state_66364[(1)]);
if((state_val_66365 === (7))){
var state_66364__$1 = state_66364;
var statearr_66366_66503 = state_66364__$1;
(statearr_66366_66503[(2)] = query_map);

(statearr_66366_66503[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66365 === (1))){
var state_66364__$1 = state_66364;
var statearr_66367_66504 = state_66364__$1;
(statearr_66367_66504[(2)] = null);

(statearr_66367_66504[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66365 === (4))){
var inst_66320 = (state_66364[(2)]);
var state_66364__$1 = state_66364;
var statearr_66368_66505 = state_66364__$1;
(statearr_66368_66505[(2)] = inst_66320);

(statearr_66368_66505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66365 === (13))){
var inst_66342 = (state_66364[(7)]);
var inst_66346 = (state_66364[(2)]);
var inst_66347 = fluree.db.util.async.throw_err.call(null,inst_66346);
var inst_66348 = cljs.core.nth.call(null,inst_66347,(0),null);
var inst_66349 = cljs.core.nth.call(null,inst_66347,(1),null);
var inst_66350 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66351 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66352 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66353 = [inst_66342];
var inst_66354 = (new cljs.core.PersistentVector(null,1,(5),inst_66352,inst_66353,null));
var inst_66355 = ["query",inst_66354,inst_66348];
var inst_66356 = cljs.core.PersistentHashMap.fromArrays(inst_66351,inst_66355);
var inst_66357 = [inst_66356,inst_66349];
var inst_66358 = (new cljs.core.PersistentVector(null,2,(5),inst_66350,inst_66357,null));
var inst_66359 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66358);
var _ = (function (){var statearr_66369 = state_66364;
(statearr_66369[(4)] = cljs.core.rest.call(null,(state_66364[(4)])));

return statearr_66369;
})();
var state_66364__$1 = (function (){var statearr_66370 = state_66364;
(statearr_66370[(8)] = inst_66359);

return statearr_66370;
})();
var statearr_66371_66506 = state_66364__$1;
(statearr_66371_66506[(2)] = inst_66348);

(statearr_66371_66506[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66365 === (6))){
var state_66364__$1 = state_66364;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66364__$1,(9),query_map);
} else {
if((state_val_66365 === (3))){
var inst_66362 = (state_66364[(2)]);
var state_66364__$1 = state_66364;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66364__$1,inst_66362);
} else {
if((state_val_66365 === (12))){
var inst_66342 = (state_66364[(7)]);
var inst_66342__$1 = (state_66364[(2)]);
var inst_66343 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_66344 = fluree.db.dbfunctions.internal.query.call(null,inst_66343,inst_66342__$1);
var state_66364__$1 = (function (){var statearr_66372 = state_66364;
(statearr_66372[(7)] = inst_66342__$1);

return statearr_66372;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66364__$1,(13),inst_66344);
} else {
if((state_val_66365 === (2))){
var _ = (function (){var statearr_66373 = state_66364;
(statearr_66373[(4)] = cljs.core.cons.call(null,(5),(state_66364[(4)])));

return statearr_66373;
})();
var inst_66329 = fluree.db.util.async.channel_QMARK_.call(null,query_map);
var state_66364__$1 = state_66364;
if(inst_66329){
var statearr_66374_66507 = state_66364__$1;
(statearr_66374_66507[(1)] = (6));

} else {
var statearr_66375_66508 = state_66364__$1;
(statearr_66375_66508[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66365 === (11))){
var inst_66336 = (state_66364[(9)]);
var state_66364__$1 = state_66364;
var statearr_66377_66509 = state_66364__$1;
(statearr_66377_66509[(2)] = inst_66336);

(statearr_66377_66509[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66365 === (9))){
var inst_66332 = (state_66364[(2)]);
var inst_66333 = fluree.db.util.async.throw_err.call(null,inst_66332);
var state_66364__$1 = state_66364;
var statearr_66378_66510 = state_66364__$1;
(statearr_66378_66510[(2)] = inst_66333);

(statearr_66378_66510[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66365 === (5))){
var _ = (function (){var statearr_66379 = state_66364;
(statearr_66379[(4)] = cljs.core.rest.call(null,(state_66364[(4)])));

return statearr_66379;
})();
var state_66364__$1 = state_66364;
var ex66376 = (state_66364__$1[(2)]);
var statearr_66380_66511 = state_66364__$1;
(statearr_66380_66511[(5)] = ex66376);


if((ex66376 instanceof Error)){
var statearr_66381_66512 = state_66364__$1;
(statearr_66381_66512[(1)] = (4));

(statearr_66381_66512[(5)] = null);

} else {
throw ex66376;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66365 === (10))){
var inst_66336 = (state_66364[(9)]);
var inst_66339 = fluree.db.util.json.parse.call(null,inst_66336);
var state_66364__$1 = state_66364;
var statearr_66382_66513 = state_66364__$1;
(statearr_66382_66513[(2)] = inst_66339);

(statearr_66382_66513[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66365 === (8))){
var inst_66336 = (state_66364[(9)]);
var inst_66336__$1 = (state_66364[(2)]);
var inst_66337 = typeof inst_66336__$1 === 'string';
var state_66364__$1 = (function (){var statearr_66383 = state_66364;
(statearr_66383[(9)] = inst_66336__$1);

return statearr_66383;
})();
if(cljs.core.truth_(inst_66337)){
var statearr_66384_66514 = state_66364__$1;
(statearr_66384_66514[(1)] = (10));

} else {
var statearr_66385_66515 = state_66364__$1;
(statearr_66385_66515[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10945__auto____0 = (function (){
var statearr_66386 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66386[(0)] = fluree$db$dbfunctions$fns$state_machine__10945__auto__);

(statearr_66386[(1)] = (1));

return statearr_66386;
});
var fluree$db$dbfunctions$fns$state_machine__10945__auto____1 = (function (state_66364){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_66364);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e66387){var ex__10948__auto__ = e66387;
var statearr_66388_66516 = state_66364;
(statearr_66388_66516[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_66364[(4)]))){
var statearr_66389_66517 = state_66364;
(statearr_66389_66517[(1)] = cljs.core.first.call(null,(state_66364[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66518 = state_66364;
state_66364 = G__66518;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10945__auto__ = function(state_66364){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____1.call(this,state_66364);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_66390 = f__11019__auto__.call(null);
(statearr_66390[(6)] = c__11018__auto__);

return statearr_66390;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_66461){
var state_val_66462 = (state_66461[(1)]);
if((state_val_66462 === (7))){
var state_66461__$1 = state_66461;
var statearr_66463_66519 = state_66461__$1;
(statearr_66463_66519[(2)] = select);

(statearr_66463_66519[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66462 === (20))){
var inst_66431 = (state_66461[(2)]);
var inst_66432 = fluree.db.util.async.channel_QMARK_.call(null,limit);
var state_66461__$1 = (function (){var statearr_66464 = state_66461;
(statearr_66464[(7)] = inst_66431);

return statearr_66464;
})();
if(inst_66432){
var statearr_66465_66520 = state_66461__$1;
(statearr_66465_66520[(1)] = (22));

} else {
var statearr_66466_66521 = state_66461__$1;
(statearr_66466_66521[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66462 === (1))){
var state_66461__$1 = state_66461;
var statearr_66467_66522 = state_66461__$1;
(statearr_66467_66522[(2)] = null);

(statearr_66467_66522[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66462 === (24))){
var inst_66407 = (state_66461[(8)]);
var inst_66423 = (state_66461[(9)]);
var inst_66415 = (state_66461[(10)]);
var inst_66431 = (state_66461[(7)]);
var inst_66439 = (state_66461[(2)]);
var inst_66440 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_66441 = fluree.db.dbfunctions.internal.query.call(null,inst_66440,inst_66407,inst_66415,inst_66423,inst_66431,inst_66439);
var state_66461__$1 = state_66461;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66461__$1,(26),inst_66441);
} else {
if((state_val_66462 === (4))){
var inst_66391 = (state_66461[(2)]);
var state_66461__$1 = state_66461;
var statearr_66468_66523 = state_66461__$1;
(statearr_66468_66523[(2)] = inst_66391);

(statearr_66468_66523[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66462 === (15))){
var state_66461__$1 = state_66461;
var statearr_66469_66524 = state_66461__$1;
(statearr_66469_66524[(2)] = where);

(statearr_66469_66524[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66462 === (21))){
var inst_66427 = (state_66461[(2)]);
var inst_66428 = fluree.db.util.async.throw_err.call(null,inst_66427);
var state_66461__$1 = state_66461;
var statearr_66470_66525 = state_66461__$1;
(statearr_66470_66525[(2)] = inst_66428);

(statearr_66470_66525[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66462 === (13))){
var inst_66411 = (state_66461[(2)]);
var inst_66412 = fluree.db.util.async.throw_err.call(null,inst_66411);
var state_66461__$1 = state_66461;
var statearr_66471_66526 = state_66461__$1;
(statearr_66471_66526[(2)] = inst_66412);

(statearr_66471_66526[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66462 === (22))){
var state_66461__$1 = state_66461;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66461__$1,(25),limit);
} else {
if((state_val_66462 === (6))){
var state_66461__$1 = state_66461;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66461__$1,(9),select);
} else {
if((state_val_66462 === (25))){
var inst_66435 = (state_66461[(2)]);
var inst_66436 = fluree.db.util.async.throw_err.call(null,inst_66435);
var state_66461__$1 = state_66461;
var statearr_66472_66527 = state_66461__$1;
(statearr_66472_66527[(2)] = inst_66436);

(statearr_66472_66527[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66462 === (17))){
var inst_66419 = (state_66461[(2)]);
var inst_66420 = fluree.db.util.async.throw_err.call(null,inst_66419);
var state_66461__$1 = state_66461;
var statearr_66473_66528 = state_66461__$1;
(statearr_66473_66528[(2)] = inst_66420);

(statearr_66473_66528[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66462 === (3))){
var inst_66459 = (state_66461[(2)]);
var state_66461__$1 = state_66461;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66461__$1,inst_66459);
} else {
if((state_val_66462 === (12))){
var inst_66415 = (state_66461[(2)]);
var inst_66416 = fluree.db.util.async.channel_QMARK_.call(null,where);
var state_66461__$1 = (function (){var statearr_66474 = state_66461;
(statearr_66474[(10)] = inst_66415);

return statearr_66474;
})();
if(inst_66416){
var statearr_66475_66529 = state_66461__$1;
(statearr_66475_66529[(1)] = (14));

} else {
var statearr_66476_66530 = state_66461__$1;
(statearr_66476_66530[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66462 === (2))){
var _ = (function (){var statearr_66477 = state_66461;
(statearr_66477[(4)] = cljs.core.cons.call(null,(5),(state_66461[(4)])));

return statearr_66477;
})();
var inst_66400 = fluree.db.util.async.channel_QMARK_.call(null,select);
var state_66461__$1 = state_66461;
if(inst_66400){
var statearr_66478_66531 = state_66461__$1;
(statearr_66478_66531[(1)] = (6));

} else {
var statearr_66479_66532 = state_66461__$1;
(statearr_66479_66532[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66462 === (23))){
var state_66461__$1 = state_66461;
var statearr_66480_66533 = state_66461__$1;
(statearr_66480_66533[(2)] = limit);

(statearr_66480_66533[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66462 === (19))){
var state_66461__$1 = state_66461;
var statearr_66481_66534 = state_66461__$1;
(statearr_66481_66534[(2)] = block);

(statearr_66481_66534[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66462 === (11))){
var state_66461__$1 = state_66461;
var statearr_66483_66535 = state_66461__$1;
(statearr_66483_66535[(2)] = from);

(statearr_66483_66535[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66462 === (9))){
var inst_66403 = (state_66461[(2)]);
var inst_66404 = fluree.db.util.async.throw_err.call(null,inst_66403);
var state_66461__$1 = state_66461;
var statearr_66484_66536 = state_66461__$1;
(statearr_66484_66536[(2)] = inst_66404);

(statearr_66484_66536[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66462 === (5))){
var _ = (function (){var statearr_66485 = state_66461;
(statearr_66485[(4)] = cljs.core.rest.call(null,(state_66461[(4)])));

return statearr_66485;
})();
var state_66461__$1 = state_66461;
var ex66482 = (state_66461__$1[(2)]);
var statearr_66486_66537 = state_66461__$1;
(statearr_66486_66537[(5)] = ex66482);


if((ex66482 instanceof Error)){
var statearr_66487_66538 = state_66461__$1;
(statearr_66487_66538[(1)] = (4));

(statearr_66487_66538[(5)] = null);

} else {
throw ex66482;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66462 === (14))){
var state_66461__$1 = state_66461;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66461__$1,(17),where);
} else {
if((state_val_66462 === (26))){
var inst_66407 = (state_66461[(8)]);
var inst_66423 = (state_66461[(9)]);
var inst_66415 = (state_66461[(10)]);
var inst_66431 = (state_66461[(7)]);
var inst_66443 = (state_66461[(2)]);
var inst_66444 = fluree.db.util.async.throw_err.call(null,inst_66443);
var inst_66445 = cljs.core.nth.call(null,inst_66444,(0),null);
var inst_66446 = cljs.core.nth.call(null,inst_66444,(1),null);
var inst_66447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66448 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66449 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66450 = [inst_66407,inst_66415,inst_66423,inst_66431];
var inst_66451 = (new cljs.core.PersistentVector(null,4,(5),inst_66449,inst_66450,null));
var inst_66452 = ["query",inst_66451,inst_66445];
var inst_66453 = cljs.core.PersistentHashMap.fromArrays(inst_66448,inst_66452);
var inst_66454 = [inst_66453,inst_66446];
var inst_66455 = (new cljs.core.PersistentVector(null,2,(5),inst_66447,inst_66454,null));
var inst_66456 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66455);
var _ = (function (){var statearr_66488 = state_66461;
(statearr_66488[(4)] = cljs.core.rest.call(null,(state_66461[(4)])));

return statearr_66488;
})();
var state_66461__$1 = (function (){var statearr_66489 = state_66461;
(statearr_66489[(11)] = inst_66456);

return statearr_66489;
})();
var statearr_66490_66539 = state_66461__$1;
(statearr_66490_66539[(2)] = inst_66445);

(statearr_66490_66539[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66462 === (16))){
var inst_66423 = (state_66461[(2)]);
var inst_66424 = fluree.db.util.async.channel_QMARK_.call(null,block);
var state_66461__$1 = (function (){var statearr_66491 = state_66461;
(statearr_66491[(9)] = inst_66423);

return statearr_66491;
})();
if(inst_66424){
var statearr_66492_66540 = state_66461__$1;
(statearr_66492_66540[(1)] = (18));

} else {
var statearr_66493_66541 = state_66461__$1;
(statearr_66493_66541[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66462 === (10))){
var state_66461__$1 = state_66461;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66461__$1,(13),from);
} else {
if((state_val_66462 === (18))){
var state_66461__$1 = state_66461;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66461__$1,(21),block);
} else {
if((state_val_66462 === (8))){
var inst_66407 = (state_66461[(2)]);
var inst_66408 = fluree.db.util.async.channel_QMARK_.call(null,from);
var state_66461__$1 = (function (){var statearr_66494 = state_66461;
(statearr_66494[(8)] = inst_66407);

return statearr_66494;
})();
if(inst_66408){
var statearr_66495_66542 = state_66461__$1;
(statearr_66495_66542[(1)] = (10));

} else {
var statearr_66496_66543 = state_66461__$1;
(statearr_66496_66543[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10945__auto____0 = (function (){
var statearr_66497 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66497[(0)] = fluree$db$dbfunctions$fns$state_machine__10945__auto__);

(statearr_66497[(1)] = (1));

return statearr_66497;
});
var fluree$db$dbfunctions$fns$state_machine__10945__auto____1 = (function (state_66461){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_66461);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e66498){var ex__10948__auto__ = e66498;
var statearr_66499_66544 = state_66461;
(statearr_66499_66544[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_66461[(4)]))){
var statearr_66500_66545 = state_66461;
(statearr_66500_66545[(1)] = cljs.core.first.call(null,(state_66461[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66546 = state_66461;
state_66461 = G__66546;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10945__auto__ = function(state_66461){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____1.call(this,state_66461);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_66501 = f__11019__auto__.call(null);
(statearr_66501[(6)] = c__11018__auto__);

return statearr_66501;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_66602){
var state_val_66603 = (state_66602[(1)]);
if((state_val_66603 === (7))){
var state_66602__$1 = state_66602;
var statearr_66604_66635 = state_66602__$1;
(statearr_66604_66635[(2)] = startSubject);

(statearr_66604_66635[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66603 === (1))){
var state_66602__$1 = state_66602;
var statearr_66605_66636 = state_66602__$1;
(statearr_66605_66636[(2)] = null);

(statearr_66605_66636[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66603 === (4))){
var inst_66547 = (state_66602[(2)]);
var state_66602__$1 = state_66602;
var statearr_66606_66637 = state_66602__$1;
(statearr_66606_66637[(2)] = inst_66547);

(statearr_66606_66637[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66603 === (15))){
var inst_66579 = (state_66602[(2)]);
var inst_66580 = fluree.db.util.async.throw_err.call(null,inst_66579);
var inst_66581 = cljs.core.nth.call(null,inst_66580,(0),null);
var inst_66582 = cljs.core.nth.call(null,inst_66580,(1),null);
var inst_66583 = cljs.core.empty_QMARK_.call(null,inst_66581);
var state_66602__$1 = (function (){var statearr_66607 = state_66602;
(statearr_66607[(7)] = inst_66582);

return statearr_66607;
})();
if(inst_66583){
var statearr_66608_66638 = state_66602__$1;
(statearr_66608_66638[(1)] = (16));

} else {
var statearr_66609_66639 = state_66602__$1;
(statearr_66609_66639[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66603 === (13))){
var inst_66575 = (state_66602[(8)]);
var inst_66567 = (state_66602[(9)]);
var inst_66563 = (state_66602[(10)]);
var inst_66575__$1 = (state_66602[(2)]);
var inst_66576 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_66577 = fluree.db.dbfunctions.internal.relationship_QMARK_.call(null,inst_66576,inst_66563,inst_66567,inst_66575__$1);
var state_66602__$1 = (function (){var statearr_66610 = state_66602;
(statearr_66610[(8)] = inst_66575__$1);

return statearr_66610;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66602__$1,(15),inst_66577);
} else {
if((state_val_66603 === (6))){
var state_66602__$1 = state_66602;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66602__$1,(9),startSubject);
} else {
if((state_val_66603 === (17))){
var state_66602__$1 = state_66602;
var statearr_66611_66640 = state_66602__$1;
(statearr_66611_66640[(2)] = true);

(statearr_66611_66640[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66603 === (3))){
var inst_66600 = (state_66602[(2)]);
var state_66602__$1 = state_66602;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66602__$1,inst_66600);
} else {
if((state_val_66603 === (12))){
var state_66602__$1 = state_66602;
var statearr_66612_66641 = state_66602__$1;
(statearr_66612_66641[(2)] = endSubject);

(statearr_66612_66641[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66603 === (2))){
var _ = (function (){var statearr_66613 = state_66602;
(statearr_66613[(4)] = cljs.core.cons.call(null,(5),(state_66602[(4)])));

return statearr_66613;
})();
var inst_66556 = fluree.db.util.async.channel_QMARK_.call(null,startSubject);
var state_66602__$1 = state_66602;
if(inst_66556){
var statearr_66614_66642 = state_66602__$1;
(statearr_66614_66642[(1)] = (6));

} else {
var statearr_66615_66643 = state_66602__$1;
(statearr_66615_66643[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66603 === (11))){
var state_66602__$1 = state_66602;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66602__$1,(14),endSubject);
} else {
if((state_val_66603 === (9))){
var inst_66559 = (state_66602[(2)]);
var inst_66560 = fluree.db.util.async.throw_err.call(null,inst_66559);
var state_66602__$1 = state_66602;
var statearr_66617_66644 = state_66602__$1;
(statearr_66617_66644[(2)] = inst_66560);

(statearr_66617_66644[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66603 === (5))){
var _ = (function (){var statearr_66618 = state_66602;
(statearr_66618[(4)] = cljs.core.rest.call(null,(state_66602[(4)])));

return statearr_66618;
})();
var state_66602__$1 = state_66602;
var ex66616 = (state_66602__$1[(2)]);
var statearr_66619_66645 = state_66602__$1;
(statearr_66619_66645[(5)] = ex66616);


if((ex66616 instanceof Error)){
var statearr_66620_66646 = state_66602__$1;
(statearr_66620_66646[(1)] = (4));

(statearr_66620_66646[(5)] = null);

} else {
throw ex66616;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66603 === (14))){
var inst_66571 = (state_66602[(2)]);
var inst_66572 = fluree.db.util.async.throw_err.call(null,inst_66571);
var state_66602__$1 = state_66602;
var statearr_66621_66647 = state_66602__$1;
(statearr_66621_66647[(2)] = inst_66572);

(statearr_66621_66647[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66603 === (16))){
var state_66602__$1 = state_66602;
var statearr_66622_66648 = state_66602__$1;
(statearr_66622_66648[(2)] = false);

(statearr_66622_66648[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66603 === (10))){
var inst_66566 = (state_66602[(2)]);
var inst_66567 = fluree.db.util.async.throw_err.call(null,inst_66566);
var inst_66568 = fluree.db.util.async.channel_QMARK_.call(null,endSubject);
var state_66602__$1 = (function (){var statearr_66623 = state_66602;
(statearr_66623[(9)] = inst_66567);

return statearr_66623;
})();
if(inst_66568){
var statearr_66624_66649 = state_66602__$1;
(statearr_66624_66649[(1)] = (11));

} else {
var statearr_66625_66650 = state_66602__$1;
(statearr_66625_66650[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66603 === (18))){
var inst_66575 = (state_66602[(8)]);
var inst_66582 = (state_66602[(7)]);
var inst_66567 = (state_66602[(9)]);
var inst_66563 = (state_66602[(10)]);
var inst_66587 = (state_66602[(2)]);
var inst_66588 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66589 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66590 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66591 = [inst_66563,inst_66567,inst_66575];
var inst_66592 = (new cljs.core.PersistentVector(null,3,(5),inst_66590,inst_66591,null));
var inst_66593 = ["relationship?",inst_66592,inst_66587];
var inst_66594 = cljs.core.PersistentHashMap.fromArrays(inst_66589,inst_66593);
var inst_66595 = [inst_66594,inst_66582];
var inst_66596 = (new cljs.core.PersistentVector(null,2,(5),inst_66588,inst_66595,null));
var inst_66597 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66596);
var _ = (function (){var statearr_66626 = state_66602;
(statearr_66626[(4)] = cljs.core.rest.call(null,(state_66602[(4)])));

return statearr_66626;
})();
var state_66602__$1 = (function (){var statearr_66627 = state_66602;
(statearr_66627[(11)] = inst_66597);

return statearr_66627;
})();
var statearr_66628_66651 = state_66602__$1;
(statearr_66628_66651[(2)] = inst_66587);

(statearr_66628_66651[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66603 === (8))){
var inst_66563 = (state_66602[(2)]);
var inst_66564 = fluree.db.dbfunctions.fns.coerce_args.call(null,path);
var state_66602__$1 = (function (){var statearr_66629 = state_66602;
(statearr_66629[(10)] = inst_66563);

return statearr_66629;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66602__$1,(10),inst_66564);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10945__auto____0 = (function (){
var statearr_66630 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66630[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10945__auto__);

(statearr_66630[(1)] = (1));

return statearr_66630;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10945__auto____1 = (function (state_66602){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_66602);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e66631){var ex__10948__auto__ = e66631;
var statearr_66632_66652 = state_66602;
(statearr_66632_66652[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_66602[(4)]))){
var statearr_66633_66653 = state_66602;
(statearr_66633_66653[(1)] = cljs.core.first.call(null,(state_66602[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66654 = state_66602;
state_66602 = G__66654;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10945__auto__ = function(state_66602){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10945__auto____1.call(this,state_66602);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_66634 = f__11019__auto__.call(null);
(statearr_66634[(6)] = c__11018__auto__);

return statearr_66634;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_66691){
var state_val_66692 = (state_66691[(1)]);
if((state_val_66692 === (7))){
var state_66691__$1 = state_66691;
var statearr_66693_66713 = state_66691__$1;
(statearr_66693_66713[(2)] = pred_name);

(statearr_66693_66713[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66692 === (1))){
var state_66691__$1 = state_66691;
var statearr_66694_66714 = state_66691__$1;
(statearr_66694_66714[(2)] = null);

(statearr_66694_66714[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66692 === (4))){
var inst_66655 = (state_66691[(2)]);
var state_66691__$1 = state_66691;
var statearr_66695_66715 = state_66691__$1;
(statearr_66695_66715[(2)] = inst_66655);

(statearr_66695_66715[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66692 === (6))){
var state_66691__$1 = state_66691;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66691__$1,(9),pred_name);
} else {
if((state_val_66692 === (3))){
var inst_66689 = (state_66691[(2)]);
var state_66691__$1 = state_66691;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66691__$1,inst_66689);
} else {
if((state_val_66692 === (2))){
var _ = (function (){var statearr_66697 = state_66691;
(statearr_66697[(4)] = cljs.core.cons.call(null,(5),(state_66691[(4)])));

return statearr_66697;
})();
var inst_66664 = fluree.db.util.async.channel_QMARK_.call(null,pred_name);
var state_66691__$1 = state_66691;
if(inst_66664){
var statearr_66698_66716 = state_66691__$1;
(statearr_66698_66716[(1)] = (6));

} else {
var statearr_66699_66717 = state_66691__$1;
(statearr_66699_66717[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66692 === (9))){
var inst_66667 = (state_66691[(2)]);
var inst_66668 = fluree.db.util.async.throw_err.call(null,inst_66667);
var state_66691__$1 = state_66691;
var statearr_66700_66718 = state_66691__$1;
(statearr_66700_66718[(2)] = inst_66668);

(statearr_66700_66718[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66692 === (5))){
var _ = (function (){var statearr_66701 = state_66691;
(statearr_66701[(4)] = cljs.core.rest.call(null,(state_66691[(4)])));

return statearr_66701;
})();
var state_66691__$1 = state_66691;
var ex66696 = (state_66691__$1[(2)]);
var statearr_66702_66719 = state_66691__$1;
(statearr_66702_66719[(5)] = ex66696);


if((ex66696 instanceof Error)){
var statearr_66703_66720 = state_66691__$1;
(statearr_66703_66720[(1)] = (4));

(statearr_66703_66720[(5)] = null);

} else {
throw ex66696;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66692 === (10))){
var inst_66671 = (state_66691[(7)]);
var inst_66675 = (state_66691[(2)]);
var inst_66676 = fluree.db.util.async.throw_err.call(null,inst_66675);
var inst_66677 = cljs.core.nth.call(null,inst_66676,(0),null);
var inst_66678 = cljs.core.nth.call(null,inst_66676,(1),null);
var inst_66679 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66680 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66681 = ["max-pred-val",inst_66671,inst_66677];
var inst_66682 = cljs.core.PersistentHashMap.fromArrays(inst_66680,inst_66681);
var inst_66683 = (inst_66678 + (10));
var inst_66684 = [inst_66682,inst_66683];
var inst_66685 = (new cljs.core.PersistentVector(null,2,(5),inst_66679,inst_66684,null));
var inst_66686 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66685);
var _ = (function (){var statearr_66704 = state_66691;
(statearr_66704[(4)] = cljs.core.rest.call(null,(state_66691[(4)])));

return statearr_66704;
})();
var state_66691__$1 = (function (){var statearr_66705 = state_66691;
(statearr_66705[(8)] = inst_66686);

return statearr_66705;
})();
var statearr_66706_66721 = state_66691__$1;
(statearr_66706_66721[(2)] = inst_66677);

(statearr_66706_66721[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66692 === (8))){
var inst_66671 = (state_66691[(7)]);
var inst_66671__$1 = (state_66691[(2)]);
var inst_66672 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_66673 = fluree.db.dbfunctions.internal.max_pred_val.call(null,inst_66672,inst_66671__$1,null);
var state_66691__$1 = (function (){var statearr_66707 = state_66691;
(statearr_66707[(7)] = inst_66671__$1);

return statearr_66707;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66691__$1,(10),inst_66673);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10945__auto____0 = (function (){
var statearr_66708 = [null,null,null,null,null,null,null,null,null];
(statearr_66708[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10945__auto__);

(statearr_66708[(1)] = (1));

return statearr_66708;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10945__auto____1 = (function (state_66691){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_66691);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e66709){var ex__10948__auto__ = e66709;
var statearr_66710_66722 = state_66691;
(statearr_66710_66722[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_66691[(4)]))){
var statearr_66711_66723 = state_66691;
(statearr_66711_66723[(1)] = cljs.core.first.call(null,(state_66691[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66724 = state_66691;
state_66691 = G__66724;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10945__auto__ = function(state_66691){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10945__auto____1.call(this,state_66691);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_66712 = f__11019__auto__.call(null);
(statearr_66712[(6)] = c__11018__auto__);

return statearr_66712;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_66751){
var state_val_66752 = (state_66751[(1)]);
if((state_val_66752 === (7))){
var state_66751__$1 = state_66751;
var statearr_66753_66772 = state_66751__$1;
(statearr_66753_66772[(2)] = n);

(statearr_66753_66772[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66752 === (1))){
var state_66751__$1 = state_66751;
var statearr_66754_66773 = state_66751__$1;
(statearr_66754_66773[(2)] = null);

(statearr_66754_66773[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66752 === (4))){
var inst_66725 = (state_66751[(2)]);
var state_66751__$1 = state_66751;
var statearr_66755_66774 = state_66751__$1;
(statearr_66755_66774[(2)] = inst_66725);

(statearr_66755_66774[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66752 === (6))){
var state_66751__$1 = state_66751;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66751__$1,(9),n);
} else {
if((state_val_66752 === (3))){
var inst_66749 = (state_66751[(2)]);
var state_66751__$1 = state_66751;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66751__$1,inst_66749);
} else {
if((state_val_66752 === (2))){
var _ = (function (){var statearr_66757 = state_66751;
(statearr_66757[(4)] = cljs.core.cons.call(null,(5),(state_66751[(4)])));

return statearr_66757;
})();
var inst_66731 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_66751__$1 = state_66751;
if(inst_66731){
var statearr_66758_66775 = state_66751__$1;
(statearr_66758_66775[(1)] = (6));

} else {
var statearr_66759_66776 = state_66751__$1;
(statearr_66759_66776[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66752 === (9))){
var inst_66734 = (state_66751[(2)]);
var inst_66735 = fluree.db.util.async.throw_err.call(null,inst_66734);
var state_66751__$1 = state_66751;
var statearr_66760_66777 = state_66751__$1;
(statearr_66760_66777[(2)] = inst_66735);

(statearr_66760_66777[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66752 === (5))){
var _ = (function (){var statearr_66761 = state_66751;
(statearr_66761[(4)] = cljs.core.rest.call(null,(state_66751[(4)])));

return statearr_66761;
})();
var state_66751__$1 = state_66751;
var ex66756 = (state_66751__$1[(2)]);
var statearr_66762_66778 = state_66751__$1;
(statearr_66762_66778[(5)] = ex66756);


if((ex66756 instanceof Error)){
var statearr_66763_66779 = state_66751__$1;
(statearr_66763_66779[(1)] = (4));

(statearr_66763_66779[(5)] = null);

} else {
throw ex66756;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66752 === (8))){
var inst_66738 = (state_66751[(2)]);
var inst_66739 = fluree.db.dbfunctions.internal.inc.call(null,inst_66738);
var inst_66740 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66741 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66742 = ["inc",inst_66738,inst_66739];
var inst_66743 = cljs.core.PersistentHashMap.fromArrays(inst_66741,inst_66742);
var inst_66744 = [inst_66743,(10)];
var inst_66745 = (new cljs.core.PersistentVector(null,2,(5),inst_66740,inst_66744,null));
var inst_66746 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66745);
var _ = (function (){var statearr_66764 = state_66751;
(statearr_66764[(4)] = cljs.core.rest.call(null,(state_66751[(4)])));

return statearr_66764;
})();
var state_66751__$1 = (function (){var statearr_66765 = state_66751;
(statearr_66765[(7)] = inst_66746);

return statearr_66765;
})();
var statearr_66766_66780 = state_66751__$1;
(statearr_66766_66780[(2)] = inst_66739);

(statearr_66766_66780[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__10945__auto____0 = (function (){
var statearr_66767 = [null,null,null,null,null,null,null,null];
(statearr_66767[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__10945__auto__);

(statearr_66767[(1)] = (1));

return statearr_66767;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__10945__auto____1 = (function (state_66751){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_66751);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e66768){var ex__10948__auto__ = e66768;
var statearr_66769_66781 = state_66751;
(statearr_66769_66781[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_66751[(4)]))){
var statearr_66770_66782 = state_66751;
(statearr_66770_66782[(1)] = cljs.core.first.call(null,(state_66751[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66783 = state_66751;
state_66751 = G__66783;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__10945__auto__ = function(state_66751){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__10945__auto____1.call(this,state_66751);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_66771 = f__11019__auto__.call(null);
(statearr_66771[(6)] = c__11018__auto__);

return statearr_66771;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_66810){
var state_val_66811 = (state_66810[(1)]);
if((state_val_66811 === (7))){
var state_66810__$1 = state_66810;
var statearr_66812_66831 = state_66810__$1;
(statearr_66812_66831[(2)] = n);

(statearr_66812_66831[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66811 === (1))){
var state_66810__$1 = state_66810;
var statearr_66813_66832 = state_66810__$1;
(statearr_66813_66832[(2)] = null);

(statearr_66813_66832[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66811 === (4))){
var inst_66784 = (state_66810[(2)]);
var state_66810__$1 = state_66810;
var statearr_66814_66833 = state_66810__$1;
(statearr_66814_66833[(2)] = inst_66784);

(statearr_66814_66833[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66811 === (6))){
var state_66810__$1 = state_66810;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66810__$1,(9),n);
} else {
if((state_val_66811 === (3))){
var inst_66808 = (state_66810[(2)]);
var state_66810__$1 = state_66810;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66810__$1,inst_66808);
} else {
if((state_val_66811 === (2))){
var _ = (function (){var statearr_66816 = state_66810;
(statearr_66816[(4)] = cljs.core.cons.call(null,(5),(state_66810[(4)])));

return statearr_66816;
})();
var inst_66790 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_66810__$1 = state_66810;
if(inst_66790){
var statearr_66817_66834 = state_66810__$1;
(statearr_66817_66834[(1)] = (6));

} else {
var statearr_66818_66835 = state_66810__$1;
(statearr_66818_66835[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66811 === (9))){
var inst_66793 = (state_66810[(2)]);
var inst_66794 = fluree.db.util.async.throw_err.call(null,inst_66793);
var state_66810__$1 = state_66810;
var statearr_66819_66836 = state_66810__$1;
(statearr_66819_66836[(2)] = inst_66794);

(statearr_66819_66836[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66811 === (5))){
var _ = (function (){var statearr_66820 = state_66810;
(statearr_66820[(4)] = cljs.core.rest.call(null,(state_66810[(4)])));

return statearr_66820;
})();
var state_66810__$1 = state_66810;
var ex66815 = (state_66810__$1[(2)]);
var statearr_66821_66837 = state_66810__$1;
(statearr_66821_66837[(5)] = ex66815);


if((ex66815 instanceof Error)){
var statearr_66822_66838 = state_66810__$1;
(statearr_66822_66838[(1)] = (4));

(statearr_66822_66838[(5)] = null);

} else {
throw ex66815;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66811 === (8))){
var inst_66797 = (state_66810[(2)]);
var inst_66798 = fluree.db.dbfunctions.internal.dec.call(null,inst_66797);
var inst_66799 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66800 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66801 = ["dec",inst_66797,inst_66798];
var inst_66802 = cljs.core.PersistentHashMap.fromArrays(inst_66800,inst_66801);
var inst_66803 = [inst_66802,(10)];
var inst_66804 = (new cljs.core.PersistentVector(null,2,(5),inst_66799,inst_66803,null));
var inst_66805 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66804);
var _ = (function (){var statearr_66823 = state_66810;
(statearr_66823[(4)] = cljs.core.rest.call(null,(state_66810[(4)])));

return statearr_66823;
})();
var state_66810__$1 = (function (){var statearr_66824 = state_66810;
(statearr_66824[(7)] = inst_66805);

return statearr_66824;
})();
var statearr_66825_66839 = state_66810__$1;
(statearr_66825_66839[(2)] = inst_66798);

(statearr_66825_66839[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__10945__auto____0 = (function (){
var statearr_66826 = [null,null,null,null,null,null,null,null];
(statearr_66826[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__10945__auto__);

(statearr_66826[(1)] = (1));

return statearr_66826;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__10945__auto____1 = (function (state_66810){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_66810);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e66827){var ex__10948__auto__ = e66827;
var statearr_66828_66840 = state_66810;
(statearr_66828_66840[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_66810[(4)]))){
var statearr_66829_66841 = state_66810;
(statearr_66829_66841[(1)] = cljs.core.first.call(null,(state_66810[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66842 = state_66810;
state_66810 = G__66842;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__10945__auto__ = function(state_66810){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__10945__auto____1.call(this,state_66810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_66830 = f__11019__auto__.call(null);
(statearr_66830[(6)] = c__11018__auto__);

return statearr_66830;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___66892 = arguments.length;
var i__5769__auto___66893 = (0);
while(true){
if((i__5769__auto___66893 < len__5768__auto___66892)){
args__5774__auto__.push((arguments[i__5769__auto___66893]));

var G__66894 = (i__5769__auto___66893 + (1));
i__5769__auto___66893 = G__66894;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_66875){
var state_val_66876 = (state_66875[(1)]);
if((state_val_66876 === (1))){
var state_66875__$1 = state_66875;
var statearr_66877_66895 = state_66875__$1;
(statearr_66877_66895[(2)] = null);

(statearr_66877_66895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66876 === (2))){
var _ = (function (){var statearr_66878 = state_66875;
(statearr_66878[(4)] = cljs.core.cons.call(null,(5),(state_66875[(4)])));

return statearr_66878;
})();
var inst_66851 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_66875__$1 = state_66875;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66875__$1,(6),inst_66851);
} else {
if((state_val_66876 === (3))){
var inst_66873 = (state_66875[(2)]);
var state_66875__$1 = state_66875;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66875__$1,inst_66873);
} else {
if((state_val_66876 === (4))){
var inst_66845 = (state_66875[(2)]);
var state_66875__$1 = state_66875;
var statearr_66880_66896 = state_66875__$1;
(statearr_66880_66896[(2)] = inst_66845);

(statearr_66880_66896[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66876 === (5))){
var _ = (function (){var statearr_66881 = state_66875;
(statearr_66881[(4)] = cljs.core.rest.call(null,(state_66875[(4)])));

return statearr_66881;
})();
var state_66875__$1 = state_66875;
var ex66879 = (state_66875__$1[(2)]);
var statearr_66882_66897 = state_66875__$1;
(statearr_66882_66897[(5)] = ex66879);


if((ex66879 instanceof Error)){
var statearr_66883_66898 = state_66875__$1;
(statearr_66883_66898[(1)] = (4));

(statearr_66883_66898[(5)] = null);

} else {
throw ex66879;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66876 === (6))){
var inst_66853 = (state_66875[(2)]);
var inst_66854 = fluree.db.util.async.throw_err.call(null,inst_66853);
var inst_66855 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._PLUS_,inst_66854);
var inst_66856 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66857 = [inst_66854];
var inst_66858 = (new cljs.core.PersistentVector(null,1,(5),inst_66856,inst_66857,null));
var inst_66859 = cljs.core.count.call(null,inst_66858);
var inst_66860 = ((9) + inst_66859);
var inst_66861 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66862 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66863 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66864 = [inst_66854];
var inst_66865 = (new cljs.core.PersistentVector(null,1,(5),inst_66863,inst_66864,null));
var inst_66866 = ["+",inst_66865,inst_66855];
var inst_66867 = cljs.core.PersistentHashMap.fromArrays(inst_66862,inst_66866);
var inst_66868 = [inst_66867,inst_66860];
var inst_66869 = (new cljs.core.PersistentVector(null,2,(5),inst_66861,inst_66868,null));
var inst_66870 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66869);
var _ = (function (){var statearr_66884 = state_66875;
(statearr_66884[(4)] = cljs.core.rest.call(null,(state_66875[(4)])));

return statearr_66884;
})();
var state_66875__$1 = (function (){var statearr_66885 = state_66875;
(statearr_66885[(7)] = inst_66870);

return statearr_66885;
})();
var statearr_66886_66899 = state_66875__$1;
(statearr_66886_66899[(2)] = inst_66855);

(statearr_66886_66899[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10945__auto____0 = (function (){
var statearr_66887 = [null,null,null,null,null,null,null,null];
(statearr_66887[(0)] = fluree$db$dbfunctions$fns$state_machine__10945__auto__);

(statearr_66887[(1)] = (1));

return statearr_66887;
});
var fluree$db$dbfunctions$fns$state_machine__10945__auto____1 = (function (state_66875){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_66875);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e66888){var ex__10948__auto__ = e66888;
var statearr_66889_66900 = state_66875;
(statearr_66889_66900[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_66875[(4)]))){
var statearr_66890_66901 = state_66875;
(statearr_66890_66901[(1)] = cljs.core.first.call(null,(state_66875[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66902 = state_66875;
state_66875 = G__66902;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10945__auto__ = function(state_66875){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____1.call(this,state_66875);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_66891 = f__11019__auto__.call(null);
(statearr_66891[(6)] = c__11018__auto__);

return statearr_66891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq66843){
var G__66844 = cljs.core.first.call(null,seq66843);
var seq66843__$1 = cljs.core.next.call(null,seq66843);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66844,seq66843__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___66952 = arguments.length;
var i__5769__auto___66953 = (0);
while(true){
if((i__5769__auto___66953 < len__5768__auto___66952)){
args__5774__auto__.push((arguments[i__5769__auto___66953]));

var G__66954 = (i__5769__auto___66953 + (1));
i__5769__auto___66953 = G__66954;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_66935){
var state_val_66936 = (state_66935[(1)]);
if((state_val_66936 === (1))){
var state_66935__$1 = state_66935;
var statearr_66937_66955 = state_66935__$1;
(statearr_66937_66955[(2)] = null);

(statearr_66937_66955[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66936 === (2))){
var _ = (function (){var statearr_66938 = state_66935;
(statearr_66938[(4)] = cljs.core.cons.call(null,(5),(state_66935[(4)])));

return statearr_66938;
})();
var inst_66911 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_66935__$1 = state_66935;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66935__$1,(6),inst_66911);
} else {
if((state_val_66936 === (3))){
var inst_66933 = (state_66935[(2)]);
var state_66935__$1 = state_66935;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66935__$1,inst_66933);
} else {
if((state_val_66936 === (4))){
var inst_66905 = (state_66935[(2)]);
var state_66935__$1 = state_66935;
var statearr_66940_66956 = state_66935__$1;
(statearr_66940_66956[(2)] = inst_66905);

(statearr_66940_66956[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66936 === (5))){
var _ = (function (){var statearr_66941 = state_66935;
(statearr_66941[(4)] = cljs.core.rest.call(null,(state_66935[(4)])));

return statearr_66941;
})();
var state_66935__$1 = state_66935;
var ex66939 = (state_66935__$1[(2)]);
var statearr_66942_66957 = state_66935__$1;
(statearr_66942_66957[(5)] = ex66939);


if((ex66939 instanceof Error)){
var statearr_66943_66958 = state_66935__$1;
(statearr_66943_66958[(1)] = (4));

(statearr_66943_66958[(5)] = null);

} else {
throw ex66939;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66936 === (6))){
var inst_66913 = (state_66935[(2)]);
var inst_66914 = fluree.db.util.async.throw_err.call(null,inst_66913);
var inst_66915 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._,inst_66914);
var inst_66916 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66917 = [inst_66914];
var inst_66918 = (new cljs.core.PersistentVector(null,1,(5),inst_66916,inst_66917,null));
var inst_66919 = cljs.core.count.call(null,inst_66918);
var inst_66920 = ((9) + inst_66919);
var inst_66921 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66922 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66923 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66924 = [inst_66914];
var inst_66925 = (new cljs.core.PersistentVector(null,1,(5),inst_66923,inst_66924,null));
var inst_66926 = ["-",inst_66925,inst_66915];
var inst_66927 = cljs.core.PersistentHashMap.fromArrays(inst_66922,inst_66926);
var inst_66928 = [inst_66927,inst_66920];
var inst_66929 = (new cljs.core.PersistentVector(null,2,(5),inst_66921,inst_66928,null));
var inst_66930 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66929);
var _ = (function (){var statearr_66944 = state_66935;
(statearr_66944[(4)] = cljs.core.rest.call(null,(state_66935[(4)])));

return statearr_66944;
})();
var state_66935__$1 = (function (){var statearr_66945 = state_66935;
(statearr_66945[(7)] = inst_66930);

return statearr_66945;
})();
var statearr_66946_66959 = state_66935__$1;
(statearr_66946_66959[(2)] = inst_66915);

(statearr_66946_66959[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10945__auto____0 = (function (){
var statearr_66947 = [null,null,null,null,null,null,null,null];
(statearr_66947[(0)] = fluree$db$dbfunctions$fns$state_machine__10945__auto__);

(statearr_66947[(1)] = (1));

return statearr_66947;
});
var fluree$db$dbfunctions$fns$state_machine__10945__auto____1 = (function (state_66935){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_66935);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e66948){var ex__10948__auto__ = e66948;
var statearr_66949_66960 = state_66935;
(statearr_66949_66960[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_66935[(4)]))){
var statearr_66950_66961 = state_66935;
(statearr_66950_66961[(1)] = cljs.core.first.call(null,(state_66935[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66962 = state_66935;
state_66935 = G__66962;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10945__auto__ = function(state_66935){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____1.call(this,state_66935);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_66951 = f__11019__auto__.call(null);
(statearr_66951[(6)] = c__11018__auto__);

return statearr_66951;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq66903){
var G__66904 = cljs.core.first.call(null,seq66903);
var seq66903__$1 = cljs.core.next.call(null,seq66903);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66904,seq66903__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___67012 = arguments.length;
var i__5769__auto___67013 = (0);
while(true){
if((i__5769__auto___67013 < len__5768__auto___67012)){
args__5774__auto__.push((arguments[i__5769__auto___67013]));

var G__67014 = (i__5769__auto___67013 + (1));
i__5769__auto___67013 = G__67014;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_66995){
var state_val_66996 = (state_66995[(1)]);
if((state_val_66996 === (1))){
var state_66995__$1 = state_66995;
var statearr_66997_67015 = state_66995__$1;
(statearr_66997_67015[(2)] = null);

(statearr_66997_67015[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66996 === (2))){
var _ = (function (){var statearr_66998 = state_66995;
(statearr_66998[(4)] = cljs.core.cons.call(null,(5),(state_66995[(4)])));

return statearr_66998;
})();
var inst_66971 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_66995__$1 = state_66995;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66995__$1,(6),inst_66971);
} else {
if((state_val_66996 === (3))){
var inst_66993 = (state_66995[(2)]);
var state_66995__$1 = state_66995;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66995__$1,inst_66993);
} else {
if((state_val_66996 === (4))){
var inst_66965 = (state_66995[(2)]);
var state_66995__$1 = state_66995;
var statearr_67000_67016 = state_66995__$1;
(statearr_67000_67016[(2)] = inst_66965);

(statearr_67000_67016[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66996 === (5))){
var _ = (function (){var statearr_67001 = state_66995;
(statearr_67001[(4)] = cljs.core.rest.call(null,(state_66995[(4)])));

return statearr_67001;
})();
var state_66995__$1 = state_66995;
var ex66999 = (state_66995__$1[(2)]);
var statearr_67002_67017 = state_66995__$1;
(statearr_67002_67017[(5)] = ex66999);


if((ex66999 instanceof Error)){
var statearr_67003_67018 = state_66995__$1;
(statearr_67003_67018[(1)] = (4));

(statearr_67003_67018[(5)] = null);

} else {
throw ex66999;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66996 === (6))){
var inst_66973 = (state_66995[(2)]);
var inst_66974 = fluree.db.util.async.throw_err.call(null,inst_66973);
var inst_66975 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._STAR_,inst_66974);
var inst_66976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66977 = [inst_66974];
var inst_66978 = (new cljs.core.PersistentVector(null,1,(5),inst_66976,inst_66977,null));
var inst_66979 = cljs.core.count.call(null,inst_66978);
var inst_66980 = ((9) + inst_66979);
var inst_66981 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66982 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66983 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66984 = [inst_66974];
var inst_66985 = (new cljs.core.PersistentVector(null,1,(5),inst_66983,inst_66984,null));
var inst_66986 = ["*",inst_66985,inst_66975];
var inst_66987 = cljs.core.PersistentHashMap.fromArrays(inst_66982,inst_66986);
var inst_66988 = [inst_66987,inst_66980];
var inst_66989 = (new cljs.core.PersistentVector(null,2,(5),inst_66981,inst_66988,null));
var inst_66990 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66989);
var _ = (function (){var statearr_67004 = state_66995;
(statearr_67004[(4)] = cljs.core.rest.call(null,(state_66995[(4)])));

return statearr_67004;
})();
var state_66995__$1 = (function (){var statearr_67005 = state_66995;
(statearr_67005[(7)] = inst_66990);

return statearr_67005;
})();
var statearr_67006_67019 = state_66995__$1;
(statearr_67006_67019[(2)] = inst_66975);

(statearr_67006_67019[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10945__auto____0 = (function (){
var statearr_67007 = [null,null,null,null,null,null,null,null];
(statearr_67007[(0)] = fluree$db$dbfunctions$fns$state_machine__10945__auto__);

(statearr_67007[(1)] = (1));

return statearr_67007;
});
var fluree$db$dbfunctions$fns$state_machine__10945__auto____1 = (function (state_66995){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_66995);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e67008){var ex__10948__auto__ = e67008;
var statearr_67009_67020 = state_66995;
(statearr_67009_67020[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_66995[(4)]))){
var statearr_67010_67021 = state_66995;
(statearr_67010_67021[(1)] = cljs.core.first.call(null,(state_66995[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67022 = state_66995;
state_66995 = G__67022;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10945__auto__ = function(state_66995){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____1.call(this,state_66995);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_67011 = f__11019__auto__.call(null);
(statearr_67011[(6)] = c__11018__auto__);

return statearr_67011;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq66963){
var G__66964 = cljs.core.first.call(null,seq66963);
var seq66963__$1 = cljs.core.next.call(null,seq66963);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66964,seq66963__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___67072 = arguments.length;
var i__5769__auto___67073 = (0);
while(true){
if((i__5769__auto___67073 < len__5768__auto___67072)){
args__5774__auto__.push((arguments[i__5769__auto___67073]));

var G__67074 = (i__5769__auto___67073 + (1));
i__5769__auto___67073 = G__67074;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_67055){
var state_val_67056 = (state_67055[(1)]);
if((state_val_67056 === (1))){
var state_67055__$1 = state_67055;
var statearr_67057_67075 = state_67055__$1;
(statearr_67057_67075[(2)] = null);

(statearr_67057_67075[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67056 === (2))){
var _ = (function (){var statearr_67058 = state_67055;
(statearr_67058[(4)] = cljs.core.cons.call(null,(5),(state_67055[(4)])));

return statearr_67058;
})();
var inst_67031 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_67055__$1 = state_67055;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67055__$1,(6),inst_67031);
} else {
if((state_val_67056 === (3))){
var inst_67053 = (state_67055[(2)]);
var state_67055__$1 = state_67055;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67055__$1,inst_67053);
} else {
if((state_val_67056 === (4))){
var inst_67025 = (state_67055[(2)]);
var state_67055__$1 = state_67055;
var statearr_67060_67076 = state_67055__$1;
(statearr_67060_67076[(2)] = inst_67025);

(statearr_67060_67076[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67056 === (5))){
var _ = (function (){var statearr_67061 = state_67055;
(statearr_67061[(4)] = cljs.core.rest.call(null,(state_67055[(4)])));

return statearr_67061;
})();
var state_67055__$1 = state_67055;
var ex67059 = (state_67055__$1[(2)]);
var statearr_67062_67077 = state_67055__$1;
(statearr_67062_67077[(5)] = ex67059);


if((ex67059 instanceof Error)){
var statearr_67063_67078 = state_67055__$1;
(statearr_67063_67078[(1)] = (4));

(statearr_67063_67078[(5)] = null);

} else {
throw ex67059;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67056 === (6))){
var inst_67033 = (state_67055[(2)]);
var inst_67034 = fluree.db.util.async.throw_err.call(null,inst_67033);
var inst_67035 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._SLASH_,inst_67034);
var inst_67036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67037 = [inst_67034];
var inst_67038 = (new cljs.core.PersistentVector(null,1,(5),inst_67036,inst_67037,null));
var inst_67039 = cljs.core.count.call(null,inst_67038);
var inst_67040 = ((9) + inst_67039);
var inst_67041 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67042 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67044 = [inst_67034];
var inst_67045 = (new cljs.core.PersistentVector(null,1,(5),inst_67043,inst_67044,null));
var inst_67046 = ["/",inst_67045,inst_67035];
var inst_67047 = cljs.core.PersistentHashMap.fromArrays(inst_67042,inst_67046);
var inst_67048 = [inst_67047,inst_67040];
var inst_67049 = (new cljs.core.PersistentVector(null,2,(5),inst_67041,inst_67048,null));
var inst_67050 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67049);
var _ = (function (){var statearr_67064 = state_67055;
(statearr_67064[(4)] = cljs.core.rest.call(null,(state_67055[(4)])));

return statearr_67064;
})();
var state_67055__$1 = (function (){var statearr_67065 = state_67055;
(statearr_67065[(7)] = inst_67050);

return statearr_67065;
})();
var statearr_67066_67079 = state_67055__$1;
(statearr_67066_67079[(2)] = inst_67035);

(statearr_67066_67079[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10945__auto____0 = (function (){
var statearr_67067 = [null,null,null,null,null,null,null,null];
(statearr_67067[(0)] = fluree$db$dbfunctions$fns$state_machine__10945__auto__);

(statearr_67067[(1)] = (1));

return statearr_67067;
});
var fluree$db$dbfunctions$fns$state_machine__10945__auto____1 = (function (state_67055){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_67055);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e67068){var ex__10948__auto__ = e67068;
var statearr_67069_67080 = state_67055;
(statearr_67069_67080[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_67055[(4)]))){
var statearr_67070_67081 = state_67055;
(statearr_67070_67081[(1)] = cljs.core.first.call(null,(state_67055[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67082 = state_67055;
state_67055 = G__67082;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10945__auto__ = function(state_67055){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____1.call(this,state_67055);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_67071 = f__11019__auto__.call(null);
(statearr_67071[(6)] = c__11018__auto__);

return statearr_67071;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq67023){
var G__67024 = cljs.core.first.call(null,seq67023);
var seq67023__$1 = cljs.core.next.call(null,seq67023);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67024,seq67023__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_67120){
var state_val_67121 = (state_67120[(1)]);
if((state_val_67121 === (7))){
var state_67120__$1 = state_67120;
var statearr_67122_67146 = state_67120__$1;
(statearr_67122_67146[(2)] = n);

(statearr_67122_67146[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67121 === (1))){
var state_67120__$1 = state_67120;
var statearr_67123_67147 = state_67120__$1;
(statearr_67123_67147[(2)] = null);

(statearr_67123_67147[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67121 === (4))){
var inst_67083 = (state_67120[(2)]);
var state_67120__$1 = state_67120;
var statearr_67124_67148 = state_67120__$1;
(statearr_67124_67148[(2)] = inst_67083);

(statearr_67124_67148[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67121 === (13))){
var inst_67100 = (state_67120[(2)]);
var inst_67101 = fluree.db.util.async.throw_err.call(null,inst_67100);
var state_67120__$1 = state_67120;
var statearr_67125_67149 = state_67120__$1;
(statearr_67125_67149[(2)] = inst_67101);

(statearr_67125_67149[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67121 === (6))){
var state_67120__$1 = state_67120;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67120__$1,(9),n);
} else {
if((state_val_67121 === (3))){
var inst_67118 = (state_67120[(2)]);
var state_67120__$1 = state_67120;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67120__$1,inst_67118);
} else {
if((state_val_67121 === (12))){
var inst_67096 = (state_67120[(7)]);
var inst_67104 = (state_67120[(2)]);
var inst_67105 = fluree.db.dbfunctions.internal.quot.call(null,inst_67096,inst_67104);
var inst_67106 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67107 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67108 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67109 = [inst_67096,inst_67104];
var inst_67110 = (new cljs.core.PersistentVector(null,2,(5),inst_67108,inst_67109,null));
var inst_67111 = ["quot",inst_67110,inst_67105];
var inst_67112 = cljs.core.PersistentHashMap.fromArrays(inst_67107,inst_67111);
var inst_67113 = [inst_67112,(2)];
var inst_67114 = (new cljs.core.PersistentVector(null,2,(5),inst_67106,inst_67113,null));
var inst_67115 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67114);
var _ = (function (){var statearr_67126 = state_67120;
(statearr_67126[(4)] = cljs.core.rest.call(null,(state_67120[(4)])));

return statearr_67126;
})();
var state_67120__$1 = (function (){var statearr_67127 = state_67120;
(statearr_67127[(8)] = inst_67115);

return statearr_67127;
})();
var statearr_67128_67150 = state_67120__$1;
(statearr_67128_67150[(2)] = inst_67105);

(statearr_67128_67150[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67121 === (2))){
var _ = (function (){var statearr_67129 = state_67120;
(statearr_67129[(4)] = cljs.core.cons.call(null,(5),(state_67120[(4)])));

return statearr_67129;
})();
var inst_67089 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_67120__$1 = state_67120;
if(inst_67089){
var statearr_67130_67151 = state_67120__$1;
(statearr_67130_67151[(1)] = (6));

} else {
var statearr_67131_67152 = state_67120__$1;
(statearr_67131_67152[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67121 === (11))){
var state_67120__$1 = state_67120;
var statearr_67133_67153 = state_67120__$1;
(statearr_67133_67153[(2)] = d);

(statearr_67133_67153[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67121 === (9))){
var inst_67092 = (state_67120[(2)]);
var inst_67093 = fluree.db.util.async.throw_err.call(null,inst_67092);
var state_67120__$1 = state_67120;
var statearr_67134_67154 = state_67120__$1;
(statearr_67134_67154[(2)] = inst_67093);

(statearr_67134_67154[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67121 === (5))){
var _ = (function (){var statearr_67135 = state_67120;
(statearr_67135[(4)] = cljs.core.rest.call(null,(state_67120[(4)])));

return statearr_67135;
})();
var state_67120__$1 = state_67120;
var ex67132 = (state_67120__$1[(2)]);
var statearr_67136_67155 = state_67120__$1;
(statearr_67136_67155[(5)] = ex67132);


if((ex67132 instanceof Error)){
var statearr_67137_67156 = state_67120__$1;
(statearr_67137_67156[(1)] = (4));

(statearr_67137_67156[(5)] = null);

} else {
throw ex67132;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67121 === (10))){
var state_67120__$1 = state_67120;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67120__$1,(13),d);
} else {
if((state_val_67121 === (8))){
var inst_67096 = (state_67120[(2)]);
var inst_67097 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_67120__$1 = (function (){var statearr_67138 = state_67120;
(statearr_67138[(7)] = inst_67096);

return statearr_67138;
})();
if(inst_67097){
var statearr_67139_67157 = state_67120__$1;
(statearr_67139_67157[(1)] = (10));

} else {
var statearr_67140_67158 = state_67120__$1;
(statearr_67140_67158[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__10945__auto____0 = (function (){
var statearr_67141 = [null,null,null,null,null,null,null,null,null];
(statearr_67141[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__10945__auto__);

(statearr_67141[(1)] = (1));

return statearr_67141;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__10945__auto____1 = (function (state_67120){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_67120);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e67142){var ex__10948__auto__ = e67142;
var statearr_67143_67159 = state_67120;
(statearr_67143_67159[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_67120[(4)]))){
var statearr_67144_67160 = state_67120;
(statearr_67144_67160[(1)] = cljs.core.first.call(null,(state_67120[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67161 = state_67120;
state_67120 = G__67161;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__10945__auto__ = function(state_67120){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__10945__auto____1.call(this,state_67120);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_67145 = f__11019__auto__.call(null);
(statearr_67145[(6)] = c__11018__auto__);

return statearr_67145;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_67199){
var state_val_67200 = (state_67199[(1)]);
if((state_val_67200 === (7))){
var state_67199__$1 = state_67199;
var statearr_67201_67225 = state_67199__$1;
(statearr_67201_67225[(2)] = n);

(statearr_67201_67225[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67200 === (1))){
var state_67199__$1 = state_67199;
var statearr_67202_67226 = state_67199__$1;
(statearr_67202_67226[(2)] = null);

(statearr_67202_67226[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67200 === (4))){
var inst_67162 = (state_67199[(2)]);
var state_67199__$1 = state_67199;
var statearr_67203_67227 = state_67199__$1;
(statearr_67203_67227[(2)] = inst_67162);

(statearr_67203_67227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67200 === (13))){
var inst_67179 = (state_67199[(2)]);
var inst_67180 = fluree.db.util.async.throw_err.call(null,inst_67179);
var state_67199__$1 = state_67199;
var statearr_67204_67228 = state_67199__$1;
(statearr_67204_67228[(2)] = inst_67180);

(statearr_67204_67228[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67200 === (6))){
var state_67199__$1 = state_67199;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67199__$1,(9),n);
} else {
if((state_val_67200 === (3))){
var inst_67197 = (state_67199[(2)]);
var state_67199__$1 = state_67199;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67199__$1,inst_67197);
} else {
if((state_val_67200 === (12))){
var inst_67175 = (state_67199[(7)]);
var inst_67183 = (state_67199[(2)]);
var inst_67184 = fluree.db.dbfunctions.internal.mod.call(null,inst_67175,inst_67183);
var inst_67185 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67186 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67187 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67188 = [inst_67175,inst_67183];
var inst_67189 = (new cljs.core.PersistentVector(null,2,(5),inst_67187,inst_67188,null));
var inst_67190 = ["mod",inst_67189,inst_67184];
var inst_67191 = cljs.core.PersistentHashMap.fromArrays(inst_67186,inst_67190);
var inst_67192 = [inst_67191,(2)];
var inst_67193 = (new cljs.core.PersistentVector(null,2,(5),inst_67185,inst_67192,null));
var inst_67194 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67193);
var _ = (function (){var statearr_67205 = state_67199;
(statearr_67205[(4)] = cljs.core.rest.call(null,(state_67199[(4)])));

return statearr_67205;
})();
var state_67199__$1 = (function (){var statearr_67206 = state_67199;
(statearr_67206[(8)] = inst_67194);

return statearr_67206;
})();
var statearr_67207_67229 = state_67199__$1;
(statearr_67207_67229[(2)] = inst_67184);

(statearr_67207_67229[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67200 === (2))){
var _ = (function (){var statearr_67208 = state_67199;
(statearr_67208[(4)] = cljs.core.cons.call(null,(5),(state_67199[(4)])));

return statearr_67208;
})();
var inst_67168 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_67199__$1 = state_67199;
if(inst_67168){
var statearr_67209_67230 = state_67199__$1;
(statearr_67209_67230[(1)] = (6));

} else {
var statearr_67210_67231 = state_67199__$1;
(statearr_67210_67231[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67200 === (11))){
var state_67199__$1 = state_67199;
var statearr_67212_67232 = state_67199__$1;
(statearr_67212_67232[(2)] = d);

(statearr_67212_67232[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67200 === (9))){
var inst_67171 = (state_67199[(2)]);
var inst_67172 = fluree.db.util.async.throw_err.call(null,inst_67171);
var state_67199__$1 = state_67199;
var statearr_67213_67233 = state_67199__$1;
(statearr_67213_67233[(2)] = inst_67172);

(statearr_67213_67233[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67200 === (5))){
var _ = (function (){var statearr_67214 = state_67199;
(statearr_67214[(4)] = cljs.core.rest.call(null,(state_67199[(4)])));

return statearr_67214;
})();
var state_67199__$1 = state_67199;
var ex67211 = (state_67199__$1[(2)]);
var statearr_67215_67234 = state_67199__$1;
(statearr_67215_67234[(5)] = ex67211);


if((ex67211 instanceof Error)){
var statearr_67216_67235 = state_67199__$1;
(statearr_67216_67235[(1)] = (4));

(statearr_67216_67235[(5)] = null);

} else {
throw ex67211;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67200 === (10))){
var state_67199__$1 = state_67199;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67199__$1,(13),d);
} else {
if((state_val_67200 === (8))){
var inst_67175 = (state_67199[(2)]);
var inst_67176 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_67199__$1 = (function (){var statearr_67217 = state_67199;
(statearr_67217[(7)] = inst_67175);

return statearr_67217;
})();
if(inst_67176){
var statearr_67218_67236 = state_67199__$1;
(statearr_67218_67236[(1)] = (10));

} else {
var statearr_67219_67237 = state_67199__$1;
(statearr_67219_67237[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__10945__auto____0 = (function (){
var statearr_67220 = [null,null,null,null,null,null,null,null,null];
(statearr_67220[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__10945__auto__);

(statearr_67220[(1)] = (1));

return statearr_67220;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__10945__auto____1 = (function (state_67199){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_67199);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e67221){var ex__10948__auto__ = e67221;
var statearr_67222_67238 = state_67199;
(statearr_67222_67238[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_67199[(4)]))){
var statearr_67223_67239 = state_67199;
(statearr_67223_67239[(1)] = cljs.core.first.call(null,(state_67199[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67240 = state_67199;
state_67199 = G__67240;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__10945__auto__ = function(state_67199){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__10945__auto____1.call(this,state_67199);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_67224 = f__11019__auto__.call(null);
(statearr_67224[(6)] = c__11018__auto__);

return statearr_67224;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_67278){
var state_val_67279 = (state_67278[(1)]);
if((state_val_67279 === (7))){
var state_67278__$1 = state_67278;
var statearr_67280_67304 = state_67278__$1;
(statearr_67280_67304[(2)] = n);

(statearr_67280_67304[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67279 === (1))){
var state_67278__$1 = state_67278;
var statearr_67281_67305 = state_67278__$1;
(statearr_67281_67305[(2)] = null);

(statearr_67281_67305[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67279 === (4))){
var inst_67241 = (state_67278[(2)]);
var state_67278__$1 = state_67278;
var statearr_67282_67306 = state_67278__$1;
(statearr_67282_67306[(2)] = inst_67241);

(statearr_67282_67306[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67279 === (13))){
var inst_67258 = (state_67278[(2)]);
var inst_67259 = fluree.db.util.async.throw_err.call(null,inst_67258);
var state_67278__$1 = state_67278;
var statearr_67283_67307 = state_67278__$1;
(statearr_67283_67307[(2)] = inst_67259);

(statearr_67283_67307[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67279 === (6))){
var state_67278__$1 = state_67278;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67278__$1,(9),n);
} else {
if((state_val_67279 === (3))){
var inst_67276 = (state_67278[(2)]);
var state_67278__$1 = state_67278;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67278__$1,inst_67276);
} else {
if((state_val_67279 === (12))){
var inst_67254 = (state_67278[(7)]);
var inst_67262 = (state_67278[(2)]);
var inst_67263 = fluree.db.dbfunctions.internal.rem.call(null,inst_67254,inst_67262);
var inst_67264 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67265 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67266 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67267 = [inst_67254,inst_67262];
var inst_67268 = (new cljs.core.PersistentVector(null,2,(5),inst_67266,inst_67267,null));
var inst_67269 = ["rem",inst_67268,inst_67263];
var inst_67270 = cljs.core.PersistentHashMap.fromArrays(inst_67265,inst_67269);
var inst_67271 = [inst_67270,(2)];
var inst_67272 = (new cljs.core.PersistentVector(null,2,(5),inst_67264,inst_67271,null));
var inst_67273 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67272);
var _ = (function (){var statearr_67284 = state_67278;
(statearr_67284[(4)] = cljs.core.rest.call(null,(state_67278[(4)])));

return statearr_67284;
})();
var state_67278__$1 = (function (){var statearr_67285 = state_67278;
(statearr_67285[(8)] = inst_67273);

return statearr_67285;
})();
var statearr_67286_67308 = state_67278__$1;
(statearr_67286_67308[(2)] = inst_67263);

(statearr_67286_67308[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67279 === (2))){
var _ = (function (){var statearr_67287 = state_67278;
(statearr_67287[(4)] = cljs.core.cons.call(null,(5),(state_67278[(4)])));

return statearr_67287;
})();
var inst_67247 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_67278__$1 = state_67278;
if(inst_67247){
var statearr_67288_67309 = state_67278__$1;
(statearr_67288_67309[(1)] = (6));

} else {
var statearr_67289_67310 = state_67278__$1;
(statearr_67289_67310[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67279 === (11))){
var state_67278__$1 = state_67278;
var statearr_67291_67311 = state_67278__$1;
(statearr_67291_67311[(2)] = d);

(statearr_67291_67311[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67279 === (9))){
var inst_67250 = (state_67278[(2)]);
var inst_67251 = fluree.db.util.async.throw_err.call(null,inst_67250);
var state_67278__$1 = state_67278;
var statearr_67292_67312 = state_67278__$1;
(statearr_67292_67312[(2)] = inst_67251);

(statearr_67292_67312[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67279 === (5))){
var _ = (function (){var statearr_67293 = state_67278;
(statearr_67293[(4)] = cljs.core.rest.call(null,(state_67278[(4)])));

return statearr_67293;
})();
var state_67278__$1 = state_67278;
var ex67290 = (state_67278__$1[(2)]);
var statearr_67294_67313 = state_67278__$1;
(statearr_67294_67313[(5)] = ex67290);


if((ex67290 instanceof Error)){
var statearr_67295_67314 = state_67278__$1;
(statearr_67295_67314[(1)] = (4));

(statearr_67295_67314[(5)] = null);

} else {
throw ex67290;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67279 === (10))){
var state_67278__$1 = state_67278;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67278__$1,(13),d);
} else {
if((state_val_67279 === (8))){
var inst_67254 = (state_67278[(2)]);
var inst_67255 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_67278__$1 = (function (){var statearr_67296 = state_67278;
(statearr_67296[(7)] = inst_67254);

return statearr_67296;
})();
if(inst_67255){
var statearr_67297_67315 = state_67278__$1;
(statearr_67297_67315[(1)] = (10));

} else {
var statearr_67298_67316 = state_67278__$1;
(statearr_67298_67316[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__10945__auto____0 = (function (){
var statearr_67299 = [null,null,null,null,null,null,null,null,null];
(statearr_67299[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__10945__auto__);

(statearr_67299[(1)] = (1));

return statearr_67299;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__10945__auto____1 = (function (state_67278){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_67278);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e67300){var ex__10948__auto__ = e67300;
var statearr_67301_67317 = state_67278;
(statearr_67301_67317[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_67278[(4)]))){
var statearr_67302_67318 = state_67278;
(statearr_67302_67318[(1)] = cljs.core.first.call(null,(state_67278[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67319 = state_67278;
state_67278 = G__67319;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__10945__auto__ = function(state_67278){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__10945__auto____1.call(this,state_67278);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_67303 = f__11019__auto__.call(null);
(statearr_67303[(6)] = c__11018__auto__);

return statearr_67303;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_67346){
var state_val_67347 = (state_67346[(1)]);
if((state_val_67347 === (7))){
var state_67346__$1 = state_67346;
var statearr_67348_67367 = state_67346__$1;
(statearr_67348_67367[(2)] = x);

(statearr_67348_67367[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67347 === (1))){
var state_67346__$1 = state_67346;
var statearr_67349_67368 = state_67346__$1;
(statearr_67349_67368[(2)] = null);

(statearr_67349_67368[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67347 === (4))){
var inst_67320 = (state_67346[(2)]);
var state_67346__$1 = state_67346;
var statearr_67350_67369 = state_67346__$1;
(statearr_67350_67369[(2)] = inst_67320);

(statearr_67350_67369[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67347 === (6))){
var state_67346__$1 = state_67346;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67346__$1,(9),x);
} else {
if((state_val_67347 === (3))){
var inst_67344 = (state_67346[(2)]);
var state_67346__$1 = state_67346;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67346__$1,inst_67344);
} else {
if((state_val_67347 === (2))){
var _ = (function (){var statearr_67352 = state_67346;
(statearr_67352[(4)] = cljs.core.cons.call(null,(5),(state_67346[(4)])));

return statearr_67352;
})();
var inst_67326 = fluree.db.util.async.channel_QMARK_.call(null,x);
var state_67346__$1 = state_67346;
if(inst_67326){
var statearr_67353_67370 = state_67346__$1;
(statearr_67353_67370[(1)] = (6));

} else {
var statearr_67354_67371 = state_67346__$1;
(statearr_67354_67371[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67347 === (9))){
var inst_67329 = (state_67346[(2)]);
var inst_67330 = fluree.db.util.async.throw_err.call(null,inst_67329);
var state_67346__$1 = state_67346;
var statearr_67355_67372 = state_67346__$1;
(statearr_67355_67372[(2)] = inst_67330);

(statearr_67355_67372[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67347 === (5))){
var _ = (function (){var statearr_67356 = state_67346;
(statearr_67356[(4)] = cljs.core.rest.call(null,(state_67346[(4)])));

return statearr_67356;
})();
var state_67346__$1 = state_67346;
var ex67351 = (state_67346__$1[(2)]);
var statearr_67357_67373 = state_67346__$1;
(statearr_67357_67373[(5)] = ex67351);


if((ex67351 instanceof Error)){
var statearr_67358_67374 = state_67346__$1;
(statearr_67358_67374[(1)] = (4));

(statearr_67358_67374[(5)] = null);

} else {
throw ex67351;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67347 === (8))){
var inst_67333 = (state_67346[(2)]);
var inst_67334 = fluree.db.dbfunctions.internal.boolean$.call(null,inst_67333);
var inst_67335 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67336 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67337 = ["boolean",inst_67333,inst_67334];
var inst_67338 = cljs.core.PersistentHashMap.fromArrays(inst_67336,inst_67337);
var inst_67339 = [inst_67338,(10)];
var inst_67340 = (new cljs.core.PersistentVector(null,2,(5),inst_67335,inst_67339,null));
var inst_67341 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67340);
var _ = (function (){var statearr_67359 = state_67346;
(statearr_67359[(4)] = cljs.core.rest.call(null,(state_67346[(4)])));

return statearr_67359;
})();
var state_67346__$1 = (function (){var statearr_67360 = state_67346;
(statearr_67360[(7)] = inst_67341);

return statearr_67360;
})();
var statearr_67361_67375 = state_67346__$1;
(statearr_67361_67375[(2)] = inst_67334);

(statearr_67361_67375[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__10945__auto____0 = (function (){
var statearr_67362 = [null,null,null,null,null,null,null,null];
(statearr_67362[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__10945__auto__);

(statearr_67362[(1)] = (1));

return statearr_67362;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__10945__auto____1 = (function (state_67346){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_67346);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e67363){var ex__10948__auto__ = e67363;
var statearr_67364_67376 = state_67346;
(statearr_67364_67376[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_67346[(4)]))){
var statearr_67365_67377 = state_67346;
(statearr_67365_67377[(1)] = cljs.core.first.call(null,(state_67346[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67378 = state_67346;
state_67346 = G__67378;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__10945__auto__ = function(state_67346){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__10945__auto____1.call(this,state_67346);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_67366 = f__11019__auto__.call(null);
(statearr_67366[(6)] = c__11018__auto__);

return statearr_67366;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_67416){
var state_val_67417 = (state_67416[(1)]);
if((state_val_67417 === (7))){
var state_67416__$1 = state_67416;
var statearr_67418_67442 = state_67416__$1;
(statearr_67418_67442[(2)] = pattern);

(statearr_67418_67442[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67417 === (1))){
var state_67416__$1 = state_67416;
var statearr_67419_67443 = state_67416__$1;
(statearr_67419_67443[(2)] = null);

(statearr_67419_67443[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67417 === (4))){
var inst_67379 = (state_67416[(2)]);
var state_67416__$1 = state_67416;
var statearr_67420_67444 = state_67416__$1;
(statearr_67420_67444[(2)] = inst_67379);

(statearr_67420_67444[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67417 === (13))){
var inst_67396 = (state_67416[(2)]);
var inst_67397 = fluree.db.util.async.throw_err.call(null,inst_67396);
var state_67416__$1 = state_67416;
var statearr_67421_67445 = state_67416__$1;
(statearr_67421_67445[(2)] = inst_67397);

(statearr_67421_67445[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67417 === (6))){
var state_67416__$1 = state_67416;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67416__$1,(9),pattern);
} else {
if((state_val_67417 === (3))){
var inst_67414 = (state_67416[(2)]);
var state_67416__$1 = state_67416;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67416__$1,inst_67414);
} else {
if((state_val_67417 === (12))){
var inst_67392 = (state_67416[(7)]);
var inst_67400 = (state_67416[(2)]);
var inst_67401 = fluree.db.dbfunctions.internal.re_find.call(null,inst_67392,inst_67400);
var inst_67402 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67403 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67404 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67405 = [inst_67392,inst_67400];
var inst_67406 = (new cljs.core.PersistentVector(null,2,(5),inst_67404,inst_67405,null));
var inst_67407 = ["re-find",inst_67406,inst_67401];
var inst_67408 = cljs.core.PersistentHashMap.fromArrays(inst_67403,inst_67407);
var inst_67409 = [inst_67408,(10)];
var inst_67410 = (new cljs.core.PersistentVector(null,2,(5),inst_67402,inst_67409,null));
var inst_67411 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67410);
var _ = (function (){var statearr_67422 = state_67416;
(statearr_67422[(4)] = cljs.core.rest.call(null,(state_67416[(4)])));

return statearr_67422;
})();
var state_67416__$1 = (function (){var statearr_67423 = state_67416;
(statearr_67423[(8)] = inst_67411);

return statearr_67423;
})();
var statearr_67424_67446 = state_67416__$1;
(statearr_67424_67446[(2)] = inst_67401);

(statearr_67424_67446[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67417 === (2))){
var _ = (function (){var statearr_67425 = state_67416;
(statearr_67425[(4)] = cljs.core.cons.call(null,(5),(state_67416[(4)])));

return statearr_67425;
})();
var inst_67385 = fluree.db.util.async.channel_QMARK_.call(null,pattern);
var state_67416__$1 = state_67416;
if(inst_67385){
var statearr_67426_67447 = state_67416__$1;
(statearr_67426_67447[(1)] = (6));

} else {
var statearr_67427_67448 = state_67416__$1;
(statearr_67427_67448[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67417 === (11))){
var state_67416__$1 = state_67416;
var statearr_67429_67449 = state_67416__$1;
(statearr_67429_67449[(2)] = string);

(statearr_67429_67449[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67417 === (9))){
var inst_67388 = (state_67416[(2)]);
var inst_67389 = fluree.db.util.async.throw_err.call(null,inst_67388);
var state_67416__$1 = state_67416;
var statearr_67430_67450 = state_67416__$1;
(statearr_67430_67450[(2)] = inst_67389);

(statearr_67430_67450[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67417 === (5))){
var _ = (function (){var statearr_67431 = state_67416;
(statearr_67431[(4)] = cljs.core.rest.call(null,(state_67416[(4)])));

return statearr_67431;
})();
var state_67416__$1 = state_67416;
var ex67428 = (state_67416__$1[(2)]);
var statearr_67432_67451 = state_67416__$1;
(statearr_67432_67451[(5)] = ex67428);


if((ex67428 instanceof Error)){
var statearr_67433_67452 = state_67416__$1;
(statearr_67433_67452[(1)] = (4));

(statearr_67433_67452[(5)] = null);

} else {
throw ex67428;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67417 === (10))){
var state_67416__$1 = state_67416;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67416__$1,(13),string);
} else {
if((state_val_67417 === (8))){
var inst_67392 = (state_67416[(2)]);
var inst_67393 = fluree.db.util.async.channel_QMARK_.call(null,string);
var state_67416__$1 = (function (){var statearr_67434 = state_67416;
(statearr_67434[(7)] = inst_67392);

return statearr_67434;
})();
if(inst_67393){
var statearr_67435_67453 = state_67416__$1;
(statearr_67435_67453[(1)] = (10));

} else {
var statearr_67436_67454 = state_67416__$1;
(statearr_67436_67454[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__10945__auto____0 = (function (){
var statearr_67437 = [null,null,null,null,null,null,null,null,null];
(statearr_67437[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__10945__auto__);

(statearr_67437[(1)] = (1));

return statearr_67437;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__10945__auto____1 = (function (state_67416){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_67416);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e67438){var ex__10948__auto__ = e67438;
var statearr_67439_67455 = state_67416;
(statearr_67439_67455[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_67416[(4)]))){
var statearr_67440_67456 = state_67416;
(statearr_67440_67456[(1)] = cljs.core.first.call(null,(state_67416[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67457 = state_67416;
state_67416 = G__67457;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__10945__auto__ = function(state_67416){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__10945__auto____1.call(this,state_67416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_67441 = f__11019__auto__.call(null);
(statearr_67441[(6)] = c__11018__auto__);

return statearr_67441;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_67484){
var state_val_67485 = (state_67484[(1)]);
if((state_val_67485 === (7))){
var state_67484__$1 = state_67484;
var statearr_67486_67505 = state_67484__$1;
(statearr_67486_67505[(2)] = email);

(statearr_67486_67505[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67485 === (1))){
var state_67484__$1 = state_67484;
var statearr_67487_67506 = state_67484__$1;
(statearr_67487_67506[(2)] = null);

(statearr_67487_67506[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67485 === (4))){
var inst_67458 = (state_67484[(2)]);
var state_67484__$1 = state_67484;
var statearr_67488_67507 = state_67484__$1;
(statearr_67488_67507[(2)] = inst_67458);

(statearr_67488_67507[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67485 === (6))){
var state_67484__$1 = state_67484;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67484__$1,(9),email);
} else {
if((state_val_67485 === (3))){
var inst_67482 = (state_67484[(2)]);
var state_67484__$1 = state_67484;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67484__$1,inst_67482);
} else {
if((state_val_67485 === (2))){
var _ = (function (){var statearr_67490 = state_67484;
(statearr_67490[(4)] = cljs.core.cons.call(null,(5),(state_67484[(4)])));

return statearr_67490;
})();
var inst_67464 = fluree.db.util.async.channel_QMARK_.call(null,email);
var state_67484__$1 = state_67484;
if(inst_67464){
var statearr_67491_67508 = state_67484__$1;
(statearr_67491_67508[(1)] = (6));

} else {
var statearr_67492_67509 = state_67484__$1;
(statearr_67492_67509[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67485 === (9))){
var inst_67467 = (state_67484[(2)]);
var inst_67468 = fluree.db.util.async.throw_err.call(null,inst_67467);
var state_67484__$1 = state_67484;
var statearr_67493_67510 = state_67484__$1;
(statearr_67493_67510[(2)] = inst_67468);

(statearr_67493_67510[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67485 === (5))){
var _ = (function (){var statearr_67494 = state_67484;
(statearr_67494[(4)] = cljs.core.rest.call(null,(state_67484[(4)])));

return statearr_67494;
})();
var state_67484__$1 = state_67484;
var ex67489 = (state_67484__$1[(2)]);
var statearr_67495_67511 = state_67484__$1;
(statearr_67495_67511[(5)] = ex67489);


if((ex67489 instanceof Error)){
var statearr_67496_67512 = state_67484__$1;
(statearr_67496_67512[(1)] = (4));

(statearr_67496_67512[(5)] = null);

} else {
throw ex67489;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67485 === (8))){
var inst_67471 = (state_67484[(2)]);
var inst_67472 = fluree.db.dbfunctions.internal.valid_email_QMARK_.call(null,inst_67471);
var inst_67473 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67474 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67475 = ["re-find",inst_67471,inst_67472];
var inst_67476 = cljs.core.PersistentHashMap.fromArrays(inst_67474,inst_67475);
var inst_67477 = [inst_67476,(10)];
var inst_67478 = (new cljs.core.PersistentVector(null,2,(5),inst_67473,inst_67477,null));
var inst_67479 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67478);
var _ = (function (){var statearr_67497 = state_67484;
(statearr_67497[(4)] = cljs.core.rest.call(null,(state_67484[(4)])));

return statearr_67497;
})();
var state_67484__$1 = (function (){var statearr_67498 = state_67484;
(statearr_67498[(7)] = inst_67479);

return statearr_67498;
})();
var statearr_67499_67513 = state_67484__$1;
(statearr_67499_67513[(2)] = inst_67472);

(statearr_67499_67513[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10945__auto____0 = (function (){
var statearr_67500 = [null,null,null,null,null,null,null,null];
(statearr_67500[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10945__auto__);

(statearr_67500[(1)] = (1));

return statearr_67500;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10945__auto____1 = (function (state_67484){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_67484);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e67501){var ex__10948__auto__ = e67501;
var statearr_67502_67514 = state_67484;
(statearr_67502_67514[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_67484[(4)]))){
var statearr_67503_67515 = state_67484;
(statearr_67503_67515[(1)] = cljs.core.first.call(null,(state_67484[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67516 = state_67484;
state_67484 = G__67516;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10945__auto__ = function(state_67484){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10945__auto____1.call(this,state_67484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_67504 = f__11019__auto__.call(null);
(statearr_67504[(6)] = c__11018__auto__);

return statearr_67504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_67563){
var state_val_67564 = (state_67563[(1)]);
if((state_val_67564 === (7))){
var inst_67533 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_67563__$1 = state_67563;
if(cljs.core.truth_(inst_67533)){
var statearr_67565_67592 = state_67563__$1;
(statearr_67565_67592[(1)] = (9));

} else {
var statearr_67566_67593 = state_67563__$1;
(statearr_67566_67593[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67564 === (1))){
var state_67563__$1 = state_67563;
var statearr_67567_67594 = state_67563__$1;
(statearr_67567_67594[(2)] = null);

(statearr_67567_67594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67564 === (4))){
var inst_67517 = (state_67563[(2)]);
var state_67563__$1 = state_67563;
var statearr_67568_67595 = state_67563__$1;
(statearr_67568_67595[(2)] = inst_67517);

(statearr_67568_67595[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67564 === (15))){
var inst_67544 = (state_67563[(2)]);
var state_67563__$1 = state_67563;
var statearr_67569_67596 = state_67563__$1;
(statearr_67569_67596[(2)] = inst_67544);

(statearr_67569_67596[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67564 === (13))){
var inst_67541 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_67563__$1 = state_67563;
var statearr_67570_67597 = state_67563__$1;
(statearr_67570_67597[(2)] = inst_67541);

(statearr_67570_67597[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67564 === (6))){
var inst_67528 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67529 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_67530 = [inst_67529,(0)];
var inst_67531 = (new cljs.core.PersistentVector(null,2,(5),inst_67528,inst_67530,null));
var state_67563__$1 = state_67563;
var statearr_67571_67598 = state_67563__$1;
(statearr_67571_67598[(2)] = inst_67531);

(statearr_67571_67598[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67564 === (3))){
var inst_67561 = (state_67563[(2)]);
var state_67563__$1 = state_67563;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67563__$1,inst_67561);
} else {
if((state_val_67564 === (12))){
var inst_67537 = (state_67563[(2)]);
var inst_67538 = fluree.db.util.async.throw_err.call(null,inst_67537);
var state_67563__$1 = state_67563;
var statearr_67572_67599 = state_67563__$1;
(statearr_67572_67599[(2)] = inst_67538);

(statearr_67572_67599[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67564 === (2))){
var _ = (function (){var statearr_67573 = state_67563;
(statearr_67573[(4)] = cljs.core.cons.call(null,(5),(state_67563[(4)])));

return statearr_67573;
})();
var inst_67526 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_67563__$1 = state_67563;
if(cljs.core.truth_(inst_67526)){
var statearr_67574_67600 = state_67563__$1;
(statearr_67574_67600[(1)] = (6));

} else {
var statearr_67575_67601 = state_67563__$1;
(statearr_67575_67601[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67564 === (11))){
var inst_67546 = (state_67563[(2)]);
var state_67563__$1 = state_67563;
var statearr_67577_67602 = state_67563__$1;
(statearr_67577_67602[(2)] = inst_67546);

(statearr_67577_67602[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67564 === (9))){
var inst_67535 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth.call(null,_QMARK_ctx);
var state_67563__$1 = state_67563;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67563__$1,(12),inst_67535);
} else {
if((state_val_67564 === (5))){
var _ = (function (){var statearr_67578 = state_67563;
(statearr_67578[(4)] = cljs.core.rest.call(null,(state_67563[(4)])));

return statearr_67578;
})();
var state_67563__$1 = state_67563;
var ex67576 = (state_67563__$1[(2)]);
var statearr_67579_67603 = state_67563__$1;
(statearr_67579_67603[(5)] = ex67576);


if((ex67576 instanceof Error)){
var statearr_67580_67604 = state_67563__$1;
(statearr_67580_67604[(1)] = (4));

(statearr_67580_67604[(5)] = null);

} else {
throw ex67576;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67564 === (14))){
var state_67563__$1 = state_67563;
var statearr_67581_67605 = state_67563__$1;
(statearr_67581_67605[(2)] = null);

(statearr_67581_67605[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67564 === (10))){
var state_67563__$1 = state_67563;
var statearr_67582_67606 = state_67563__$1;
(statearr_67582_67606[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67564 === (8))){
var inst_67548 = (state_67563[(2)]);
var inst_67549 = cljs.core.nth.call(null,inst_67548,(0),null);
var inst_67550 = cljs.core.nth.call(null,inst_67548,(1),null);
var inst_67551 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67552 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67553 = ["?user_id","?ctx",inst_67549];
var inst_67554 = cljs.core.PersistentHashMap.fromArrays(inst_67552,inst_67553);
var inst_67555 = ((10) + inst_67550);
var inst_67556 = [inst_67554,inst_67555];
var inst_67557 = (new cljs.core.PersistentVector(null,2,(5),inst_67551,inst_67556,null));
var inst_67558 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67557);
var _ = (function (){var statearr_67584 = state_67563;
(statearr_67584[(4)] = cljs.core.rest.call(null,(state_67563[(4)])));

return statearr_67584;
})();
var state_67563__$1 = (function (){var statearr_67585 = state_67563;
(statearr_67585[(7)] = inst_67558);

return statearr_67585;
})();
var statearr_67586_67607 = state_67563__$1;
(statearr_67586_67607[(2)] = inst_67549);

(statearr_67586_67607[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10945__auto____0 = (function (){
var statearr_67587 = [null,null,null,null,null,null,null,null];
(statearr_67587[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10945__auto__);

(statearr_67587[(1)] = (1));

return statearr_67587;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10945__auto____1 = (function (state_67563){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_67563);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e67588){var ex__10948__auto__ = e67588;
var statearr_67589_67608 = state_67563;
(statearr_67589_67608[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_67563[(4)]))){
var statearr_67590_67609 = state_67563;
(statearr_67590_67609[(1)] = cljs.core.first.call(null,(state_67563[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67610 = state_67563;
state_67563 = G__67610;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10945__auto__ = function(state_67563){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10945__auto____1.call(this,state_67563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_67591 = f__11019__auto__.call(null);
(statearr_67591[(6)] = c__11018__auto__);

return statearr_67591;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_67638){
var state_val_67639 = (state_67638[(1)]);
if((state_val_67639 === (7))){
var inst_67631 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_67638__$1 = state_67638;
var statearr_67640_67659 = state_67638__$1;
(statearr_67640_67659[(2)] = inst_67631);

(statearr_67640_67659[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67639 === (1))){
var state_67638__$1 = state_67638;
var statearr_67641_67660 = state_67638__$1;
(statearr_67641_67660[(2)] = null);

(statearr_67641_67660[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67639 === (4))){
var inst_67611 = (state_67638[(2)]);
var state_67638__$1 = state_67638;
var statearr_67642_67661 = state_67638__$1;
(statearr_67642_67661[(2)] = inst_67611);

(statearr_67642_67661[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67639 === (6))){
var inst_67619 = fluree.db.dbfunctions.internal._QMARK_auth_id.call(null,_QMARK_ctx);
var state_67638__$1 = state_67638;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67638__$1,(9),inst_67619);
} else {
if((state_val_67639 === (3))){
var inst_67636 = (state_67638[(2)]);
var state_67638__$1 = state_67638;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67638__$1,inst_67636);
} else {
if((state_val_67639 === (2))){
var _ = (function (){var statearr_67644 = state_67638;
(statearr_67644[(4)] = cljs.core.cons.call(null,(5),(state_67638[(4)])));

return statearr_67644;
})();
var inst_67617 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_67638__$1 = state_67638;
if(cljs.core.truth_(inst_67617)){
var statearr_67645_67662 = state_67638__$1;
(statearr_67645_67662[(1)] = (6));

} else {
var statearr_67646_67663 = state_67638__$1;
(statearr_67646_67663[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67639 === (9))){
var inst_67621 = (state_67638[(2)]);
var inst_67622 = fluree.db.util.async.throw_err.call(null,inst_67621);
var inst_67623 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67624 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67625 = ["?auth_id","?ctx",inst_67622];
var inst_67626 = cljs.core.PersistentHashMap.fromArrays(inst_67624,inst_67625);
var inst_67627 = [inst_67626,(10)];
var inst_67628 = (new cljs.core.PersistentVector(null,2,(5),inst_67623,inst_67627,null));
var inst_67629 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67628);
var state_67638__$1 = (function (){var statearr_67647 = state_67638;
(statearr_67647[(7)] = inst_67629);

return statearr_67647;
})();
var statearr_67648_67664 = state_67638__$1;
(statearr_67648_67664[(2)] = inst_67622);

(statearr_67648_67664[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67639 === (5))){
var _ = (function (){var statearr_67649 = state_67638;
(statearr_67649[(4)] = cljs.core.rest.call(null,(state_67638[(4)])));

return statearr_67649;
})();
var state_67638__$1 = state_67638;
var ex67643 = (state_67638__$1[(2)]);
var statearr_67650_67665 = state_67638__$1;
(statearr_67650_67665[(5)] = ex67643);


if((ex67643 instanceof Error)){
var statearr_67651_67666 = state_67638__$1;
(statearr_67651_67666[(1)] = (4));

(statearr_67651_67666[(5)] = null);

} else {
throw ex67643;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67639 === (8))){
var inst_67633 = (state_67638[(2)]);
var _ = (function (){var statearr_67652 = state_67638;
(statearr_67652[(4)] = cljs.core.rest.call(null,(state_67638[(4)])));

return statearr_67652;
})();
var state_67638__$1 = state_67638;
var statearr_67653_67667 = state_67638__$1;
(statearr_67653_67667[(2)] = inst_67633);

(statearr_67653_67667[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10945__auto____0 = (function (){
var statearr_67654 = [null,null,null,null,null,null,null,null];
(statearr_67654[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10945__auto__);

(statearr_67654[(1)] = (1));

return statearr_67654;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10945__auto____1 = (function (state_67638){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_67638);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e67655){var ex__10948__auto__ = e67655;
var statearr_67656_67668 = state_67638;
(statearr_67656_67668[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_67638[(4)]))){
var statearr_67657_67669 = state_67638;
(statearr_67657_67669[(1)] = cljs.core.first.call(null,(state_67638[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67670 = state_67638;
state_67638 = G__67670;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10945__auto__ = function(state_67638){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10945__auto____1.call(this,state_67638);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_67658 = f__11019__auto__.call(null);
(statearr_67658[(6)] = c__11018__auto__);

return statearr_67658;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__67672 = arguments.length;
switch (G__67672) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.call(null,_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_67714){
var state_val_67715 = (state_67714[(1)]);
if((state_val_67715 === (7))){
var state_67714__$1 = state_67714;
var statearr_67716_67746 = state_67714__$1;
(statearr_67716_67746[(2)] = seed);

(statearr_67716_67746[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67715 === (1))){
var state_67714__$1 = state_67714;
var statearr_67717_67747 = state_67714__$1;
(statearr_67717_67747[(2)] = null);

(statearr_67717_67747[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67715 === (4))){
var inst_67673 = (state_67714[(2)]);
var state_67714__$1 = state_67714;
var statearr_67718_67748 = state_67714__$1;
(statearr_67718_67748[(2)] = inst_67673);

(statearr_67718_67748[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67715 === (15))){
var state_67714__$1 = state_67714;
var statearr_67719_67749 = state_67714__$1;
(statearr_67719_67749[(2)] = (10));

(statearr_67719_67749[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67715 === (13))){
var inst_67690 = (state_67714[(2)]);
var inst_67691 = fluree.db.util.async.throw_err.call(null,inst_67690);
var state_67714__$1 = state_67714;
var statearr_67720_67750 = state_67714__$1;
(statearr_67720_67750[(2)] = inst_67691);

(statearr_67720_67750[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67715 === (6))){
var state_67714__$1 = state_67714;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67714__$1,(9),seed);
} else {
if((state_val_67715 === (3))){
var inst_67712 = (state_67714[(2)]);
var state_67714__$1 = state_67714;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67714__$1,inst_67712);
} else {
if((state_val_67715 === (12))){
var inst_67694 = (state_67714[(7)]);
var inst_67694__$1 = (state_67714[(2)]);
var state_67714__$1 = (function (){var statearr_67721 = state_67714;
(statearr_67721[(7)] = inst_67694__$1);

return statearr_67721;
})();
if(cljs.core.truth_(inst_67694__$1)){
var statearr_67722_67751 = state_67714__$1;
(statearr_67722_67751[(1)] = (14));

} else {
var statearr_67723_67752 = state_67714__$1;
(statearr_67723_67752[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67715 === (2))){
var _ = (function (){var statearr_67724 = state_67714;
(statearr_67724[(4)] = cljs.core.cons.call(null,(5),(state_67714[(4)])));

return statearr_67724;
})();
var inst_67679 = fluree.db.util.async.channel_QMARK_.call(null,seed);
var state_67714__$1 = state_67714;
if(inst_67679){
var statearr_67725_67753 = state_67714__$1;
(statearr_67725_67753[(1)] = (6));

} else {
var statearr_67726_67754 = state_67714__$1;
(statearr_67726_67754[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67715 === (11))){
var state_67714__$1 = state_67714;
var statearr_67728_67755 = state_67714__$1;
(statearr_67728_67755[(2)] = max);

(statearr_67728_67755[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67715 === (9))){
var inst_67682 = (state_67714[(2)]);
var inst_67683 = fluree.db.util.async.throw_err.call(null,inst_67682);
var state_67714__$1 = state_67714;
var statearr_67729_67756 = state_67714__$1;
(statearr_67729_67756[(2)] = inst_67683);

(statearr_67729_67756[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67715 === (5))){
var _ = (function (){var statearr_67730 = state_67714;
(statearr_67730[(4)] = cljs.core.rest.call(null,(state_67714[(4)])));

return statearr_67730;
})();
var state_67714__$1 = state_67714;
var ex67727 = (state_67714__$1[(2)]);
var statearr_67731_67757 = state_67714__$1;
(statearr_67731_67757[(5)] = ex67727);


if((ex67727 instanceof Error)){
var statearr_67732_67758 = state_67714__$1;
(statearr_67732_67758[(1)] = (4));

(statearr_67732_67758[(5)] = null);

} else {
throw ex67727;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67715 === (14))){
var inst_67694 = (state_67714[(7)]);
var state_67714__$1 = state_67714;
var statearr_67733_67759 = state_67714__$1;
(statearr_67733_67759[(2)] = inst_67694);

(statearr_67733_67759[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67715 === (16))){
var inst_67686 = (state_67714[(8)]);
var inst_67698 = (state_67714[(2)]);
var inst_67699 = fluree.db.dbfunctions.internal.rand.call(null,inst_67686,inst_67698);
var inst_67700 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67701 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67702 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67703 = [max,seed];
var inst_67704 = (new cljs.core.PersistentVector(null,2,(5),inst_67702,inst_67703,null));
var inst_67705 = ["rand",inst_67704,inst_67699];
var inst_67706 = cljs.core.PersistentHashMap.fromArrays(inst_67701,inst_67705);
var inst_67707 = [inst_67706,(10)];
var inst_67708 = (new cljs.core.PersistentVector(null,2,(5),inst_67700,inst_67707,null));
var inst_67709 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67708);
var _ = (function (){var statearr_67734 = state_67714;
(statearr_67734[(4)] = cljs.core.rest.call(null,(state_67714[(4)])));

return statearr_67734;
})();
var state_67714__$1 = (function (){var statearr_67735 = state_67714;
(statearr_67735[(9)] = inst_67709);

return statearr_67735;
})();
var statearr_67736_67760 = state_67714__$1;
(statearr_67736_67760[(2)] = inst_67699);

(statearr_67736_67760[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67715 === (10))){
var state_67714__$1 = state_67714;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67714__$1,(13),max);
} else {
if((state_val_67715 === (8))){
var inst_67686 = (state_67714[(2)]);
var inst_67687 = fluree.db.util.async.channel_QMARK_.call(null,max);
var state_67714__$1 = (function (){var statearr_67737 = state_67714;
(statearr_67737[(8)] = inst_67686);

return statearr_67737;
})();
if(inst_67687){
var statearr_67738_67761 = state_67714__$1;
(statearr_67738_67761[(1)] = (10));

} else {
var statearr_67739_67762 = state_67714__$1;
(statearr_67739_67762[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10945__auto____0 = (function (){
var statearr_67740 = [null,null,null,null,null,null,null,null,null,null];
(statearr_67740[(0)] = fluree$db$dbfunctions$fns$state_machine__10945__auto__);

(statearr_67740[(1)] = (1));

return statearr_67740;
});
var fluree$db$dbfunctions$fns$state_machine__10945__auto____1 = (function (state_67714){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_67714);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e67741){var ex__10948__auto__ = e67741;
var statearr_67742_67763 = state_67714;
(statearr_67742_67763[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_67714[(4)]))){
var statearr_67743_67764 = state_67714;
(statearr_67743_67764[(1)] = cljs.core.first.call(null,(state_67714[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67765 = state_67714;
state_67714 = G__67765;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10945__auto__ = function(state_67714){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10945__auto____1.call(this,state_67714);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_67744 = f__11019__auto__.call(null);
(statearr_67744[(6)] = c__11018__auto__);

return statearr_67744;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_67786){
var state_val_67787 = (state_67786[(1)]);
if((state_val_67787 === (1))){
var state_67786__$1 = state_67786;
var statearr_67788_67803 = state_67786__$1;
(statearr_67788_67803[(2)] = null);

(statearr_67788_67803[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67787 === (2))){
var _ = (function (){var statearr_67789 = state_67786;
(statearr_67789[(4)] = cljs.core.cons.call(null,(5),(state_67786[(4)])));

return statearr_67789;
})();
var inst_67772 = fluree.db.util.core.random_uuid.call(null);
var inst_67773 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_67772);
var inst_67774 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67775 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67776 = cljs.core.PersistentVector.EMPTY;
var inst_67777 = ["uuid",inst_67776,inst_67773];
var inst_67778 = cljs.core.PersistentHashMap.fromArrays(inst_67775,inst_67777);
var inst_67779 = [inst_67778,(10)];
var inst_67780 = (new cljs.core.PersistentVector(null,2,(5),inst_67774,inst_67779,null));
var inst_67781 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67780);
var ___$1 = (function (){var statearr_67790 = state_67786;
(statearr_67790[(4)] = cljs.core.rest.call(null,(state_67786[(4)])));

return statearr_67790;
})();
var state_67786__$1 = (function (){var statearr_67791 = state_67786;
(statearr_67791[(7)] = inst_67781);

return statearr_67791;
})();
var statearr_67792_67804 = state_67786__$1;
(statearr_67792_67804[(2)] = inst_67773);

(statearr_67792_67804[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67787 === (3))){
var inst_67784 = (state_67786[(2)]);
var state_67786__$1 = state_67786;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67786__$1,inst_67784);
} else {
if((state_val_67787 === (4))){
var inst_67766 = (state_67786[(2)]);
var state_67786__$1 = state_67786;
var statearr_67794_67805 = state_67786__$1;
(statearr_67794_67805[(2)] = inst_67766);

(statearr_67794_67805[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67787 === (5))){
var _ = (function (){var statearr_67795 = state_67786;
(statearr_67795[(4)] = cljs.core.rest.call(null,(state_67786[(4)])));

return statearr_67795;
})();
var state_67786__$1 = state_67786;
var ex67793 = (state_67786__$1[(2)]);
var statearr_67796_67806 = state_67786__$1;
(statearr_67796_67806[(5)] = ex67793);


if((ex67793 instanceof Error)){
var statearr_67797_67807 = state_67786__$1;
(statearr_67797_67807[(1)] = (4));

(statearr_67797_67807[(5)] = null);

} else {
throw ex67793;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__10945__auto____0 = (function (){
var statearr_67798 = [null,null,null,null,null,null,null,null];
(statearr_67798[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__10945__auto__);

(statearr_67798[(1)] = (1));

return statearr_67798;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__10945__auto____1 = (function (state_67786){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_67786);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e67799){var ex__10948__auto__ = e67799;
var statearr_67800_67808 = state_67786;
(statearr_67800_67808[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_67786[(4)]))){
var statearr_67801_67809 = state_67786;
(statearr_67801_67809[(1)] = cljs.core.first.call(null,(state_67786[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67810 = state_67786;
state_67786 = G__67810;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__10945__auto__ = function(state_67786){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__10945__auto____1.call(this,state_67786);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_67802 = f__11019__auto__.call(null);
(statearr_67802[(6)] = c__11018__auto__);

return statearr_67802;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_67840){
var state_val_67841 = (state_67840[(1)]);
if((state_val_67841 === (7))){
var state_67840__$1 = state_67840;
var statearr_67842_67861 = state_67840__$1;
(statearr_67842_67861[(2)] = num);

(statearr_67842_67861[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67841 === (1))){
var state_67840__$1 = state_67840;
var statearr_67843_67862 = state_67840__$1;
(statearr_67843_67862[(2)] = null);

(statearr_67843_67862[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67841 === (4))){
var inst_67811 = (state_67840[(2)]);
var state_67840__$1 = state_67840;
var statearr_67844_67863 = state_67840__$1;
(statearr_67844_67863[(2)] = inst_67811);

(statearr_67844_67863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67841 === (6))){
var state_67840__$1 = state_67840;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67840__$1,(9),num);
} else {
if((state_val_67841 === (3))){
var inst_67838 = (state_67840[(2)]);
var state_67840__$1 = state_67840;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67840__$1,inst_67838);
} else {
if((state_val_67841 === (2))){
var _ = (function (){var statearr_67846 = state_67840;
(statearr_67846[(4)] = cljs.core.cons.call(null,(5),(state_67840[(4)])));

return statearr_67846;
})();
var inst_67817 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_67840__$1 = state_67840;
if(inst_67817){
var statearr_67847_67864 = state_67840__$1;
(statearr_67847_67864[(1)] = (6));

} else {
var statearr_67848_67865 = state_67840__$1;
(statearr_67848_67865[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67841 === (9))){
var inst_67820 = (state_67840[(2)]);
var inst_67821 = fluree.db.util.async.throw_err.call(null,inst_67820);
var state_67840__$1 = state_67840;
var statearr_67849_67866 = state_67840__$1;
(statearr_67849_67866[(2)] = inst_67821);

(statearr_67849_67866[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67841 === (5))){
var _ = (function (){var statearr_67850 = state_67840;
(statearr_67850[(4)] = cljs.core.rest.call(null,(state_67840[(4)])));

return statearr_67850;
})();
var state_67840__$1 = state_67840;
var ex67845 = (state_67840__$1[(2)]);
var statearr_67851_67867 = state_67840__$1;
(statearr_67851_67867[(5)] = ex67845);


if((ex67845 instanceof Error)){
var statearr_67852_67868 = state_67840__$1;
(statearr_67852_67868[(1)] = (4));

(statearr_67852_67868[(5)] = null);

} else {
throw ex67845;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67841 === (8))){
var inst_67824 = (state_67840[(2)]);
var inst_67825 = fluree.db.dbfunctions.internal.ceil.call(null,inst_67824);
var inst_67826 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67827 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67828 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67829 = [fluree.db.dbfunctions.fns.ceil];
var inst_67830 = (new cljs.core.PersistentVector(null,1,(5),inst_67828,inst_67829,null));
var inst_67831 = ["",inst_67830,inst_67825];
var inst_67832 = cljs.core.PersistentHashMap.fromArrays(inst_67827,inst_67831);
var inst_67833 = [inst_67832,(10)];
var inst_67834 = (new cljs.core.PersistentVector(null,2,(5),inst_67826,inst_67833,null));
var inst_67835 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67834);
var _ = (function (){var statearr_67853 = state_67840;
(statearr_67853[(4)] = cljs.core.rest.call(null,(state_67840[(4)])));

return statearr_67853;
})();
var state_67840__$1 = (function (){var statearr_67854 = state_67840;
(statearr_67854[(7)] = inst_67835);

return statearr_67854;
})();
var statearr_67855_67869 = state_67840__$1;
(statearr_67855_67869[(2)] = inst_67825);

(statearr_67855_67869[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__10945__auto____0 = (function (){
var statearr_67856 = [null,null,null,null,null,null,null,null];
(statearr_67856[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__10945__auto__);

(statearr_67856[(1)] = (1));

return statearr_67856;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__10945__auto____1 = (function (state_67840){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_67840);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e67857){var ex__10948__auto__ = e67857;
var statearr_67858_67870 = state_67840;
(statearr_67858_67870[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_67840[(4)]))){
var statearr_67859_67871 = state_67840;
(statearr_67859_67871[(1)] = cljs.core.first.call(null,(state_67840[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67872 = state_67840;
state_67840 = G__67872;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__10945__auto__ = function(state_67840){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__10945__auto____1.call(this,state_67840);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_67860 = f__11019__auto__.call(null);
(statearr_67860[(6)] = c__11018__auto__);

return statearr_67860;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_67902){
var state_val_67903 = (state_67902[(1)]);
if((state_val_67903 === (7))){
var state_67902__$1 = state_67902;
var statearr_67904_67923 = state_67902__$1;
(statearr_67904_67923[(2)] = num);

(statearr_67904_67923[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67903 === (1))){
var state_67902__$1 = state_67902;
var statearr_67905_67924 = state_67902__$1;
(statearr_67905_67924[(2)] = null);

(statearr_67905_67924[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67903 === (4))){
var inst_67873 = (state_67902[(2)]);
var state_67902__$1 = state_67902;
var statearr_67906_67925 = state_67902__$1;
(statearr_67906_67925[(2)] = inst_67873);

(statearr_67906_67925[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67903 === (6))){
var state_67902__$1 = state_67902;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67902__$1,(9),num);
} else {
if((state_val_67903 === (3))){
var inst_67900 = (state_67902[(2)]);
var state_67902__$1 = state_67902;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67902__$1,inst_67900);
} else {
if((state_val_67903 === (2))){
var _ = (function (){var statearr_67908 = state_67902;
(statearr_67908[(4)] = cljs.core.cons.call(null,(5),(state_67902[(4)])));

return statearr_67908;
})();
var inst_67879 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_67902__$1 = state_67902;
if(inst_67879){
var statearr_67909_67926 = state_67902__$1;
(statearr_67909_67926[(1)] = (6));

} else {
var statearr_67910_67927 = state_67902__$1;
(statearr_67910_67927[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67903 === (9))){
var inst_67882 = (state_67902[(2)]);
var inst_67883 = fluree.db.util.async.throw_err.call(null,inst_67882);
var state_67902__$1 = state_67902;
var statearr_67911_67928 = state_67902__$1;
(statearr_67911_67928[(2)] = inst_67883);

(statearr_67911_67928[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67903 === (5))){
var _ = (function (){var statearr_67912 = state_67902;
(statearr_67912[(4)] = cljs.core.rest.call(null,(state_67902[(4)])));

return statearr_67912;
})();
var state_67902__$1 = state_67902;
var ex67907 = (state_67902__$1[(2)]);
var statearr_67913_67929 = state_67902__$1;
(statearr_67913_67929[(5)] = ex67907);


if((ex67907 instanceof Error)){
var statearr_67914_67930 = state_67902__$1;
(statearr_67914_67930[(1)] = (4));

(statearr_67914_67930[(5)] = null);

} else {
throw ex67907;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67903 === (8))){
var inst_67886 = (state_67902[(2)]);
var inst_67887 = fluree.db.dbfunctions.internal.floor.call(null,inst_67886);
var inst_67888 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67889 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67890 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67891 = [fluree.db.dbfunctions.fns.floor];
var inst_67892 = (new cljs.core.PersistentVector(null,1,(5),inst_67890,inst_67891,null));
var inst_67893 = ["",inst_67892,inst_67887];
var inst_67894 = cljs.core.PersistentHashMap.fromArrays(inst_67889,inst_67893);
var inst_67895 = [inst_67894,(10)];
var inst_67896 = (new cljs.core.PersistentVector(null,2,(5),inst_67888,inst_67895,null));
var inst_67897 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67896);
var _ = (function (){var statearr_67915 = state_67902;
(statearr_67915[(4)] = cljs.core.rest.call(null,(state_67902[(4)])));

return statearr_67915;
})();
var state_67902__$1 = (function (){var statearr_67916 = state_67902;
(statearr_67916[(7)] = inst_67897);

return statearr_67916;
})();
var statearr_67917_67931 = state_67902__$1;
(statearr_67917_67931[(2)] = inst_67887);

(statearr_67917_67931[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__10945__auto____0 = (function (){
var statearr_67918 = [null,null,null,null,null,null,null,null];
(statearr_67918[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__10945__auto__);

(statearr_67918[(1)] = (1));

return statearr_67918;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__10945__auto____1 = (function (state_67902){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_67902);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e67919){var ex__10948__auto__ = e67919;
var statearr_67920_67932 = state_67902;
(statearr_67920_67932[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_67902[(4)]))){
var statearr_67921_67933 = state_67902;
(statearr_67921_67933[(1)] = cljs.core.first.call(null,(state_67902[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67934 = state_67902;
state_67902 = G__67934;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__10945__auto__ = function(state_67902){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__10945__auto____1.call(this,state_67902);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_67922 = f__11019__auto__.call(null);
(statearr_67922[(6)] = c__11018__auto__);

return statearr_67922;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_67959){
var state_val_67960 = (state_67959[(1)]);
if((state_val_67960 === (1))){
var state_67959__$1 = state_67959;
var statearr_67961_67976 = state_67959__$1;
(statearr_67961_67976[(2)] = null);

(statearr_67961_67976[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67960 === (2))){
var _ = (function (){var statearr_67962 = state_67959;
(statearr_67962[(4)] = cljs.core.cons.call(null,(5),(state_67959[(4)])));

return statearr_67962;
})();
var inst_67941 = fluree.db.dbfunctions.internal.cas.call(null,_QMARK_ctx,compare_val,new_val);
var state_67959__$1 = state_67959;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67959__$1,(6),inst_67941);
} else {
if((state_val_67960 === (3))){
var inst_67957 = (state_67959[(2)]);
var state_67959__$1 = state_67959;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67959__$1,inst_67957);
} else {
if((state_val_67960 === (4))){
var inst_67935 = (state_67959[(2)]);
var state_67959__$1 = state_67959;
var statearr_67964_67977 = state_67959__$1;
(statearr_67964_67977[(2)] = inst_67935);

(statearr_67964_67977[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67960 === (5))){
var _ = (function (){var statearr_67965 = state_67959;
(statearr_67965[(4)] = cljs.core.rest.call(null,(state_67959[(4)])));

return statearr_67965;
})();
var state_67959__$1 = state_67959;
var ex67963 = (state_67959__$1[(2)]);
var statearr_67966_67978 = state_67959__$1;
(statearr_67966_67978[(5)] = ex67963);


if((ex67963 instanceof Error)){
var statearr_67967_67979 = state_67959__$1;
(statearr_67967_67979[(1)] = (4));

(statearr_67967_67979[(5)] = null);

} else {
throw ex67963;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67960 === (6))){
var inst_67943 = (state_67959[(2)]);
var inst_67944 = fluree.db.util.async.throw_err.call(null,inst_67943);
var inst_67945 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67946 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67947 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67948 = [compare_val,new_val];
var inst_67949 = (new cljs.core.PersistentVector(null,2,(5),inst_67947,inst_67948,null));
var inst_67950 = ["",inst_67949,inst_67944];
var inst_67951 = cljs.core.PersistentHashMap.fromArrays(inst_67946,inst_67950);
var inst_67952 = [inst_67951,(10)];
var inst_67953 = (new cljs.core.PersistentVector(null,2,(5),inst_67945,inst_67952,null));
var inst_67954 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67953);
var _ = (function (){var statearr_67968 = state_67959;
(statearr_67968[(4)] = cljs.core.rest.call(null,(state_67959[(4)])));

return statearr_67968;
})();
var state_67959__$1 = (function (){var statearr_67969 = state_67959;
(statearr_67969[(7)] = inst_67954);

return statearr_67969;
})();
var statearr_67970_67980 = state_67959__$1;
(statearr_67970_67980[(2)] = inst_67944);

(statearr_67970_67980[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__10945__auto____0 = (function (){
var statearr_67971 = [null,null,null,null,null,null,null,null];
(statearr_67971[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__10945__auto__);

(statearr_67971[(1)] = (1));

return statearr_67971;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__10945__auto____1 = (function (state_67959){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_67959);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e67972){var ex__10948__auto__ = e67972;
var statearr_67973_67981 = state_67959;
(statearr_67973_67981[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_67959[(4)]))){
var statearr_67974_67982 = state_67959;
(statearr_67974_67982[(1)] = cljs.core.first.call(null,(state_67959[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67983 = state_67959;
state_67959 = G__67983;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__10945__auto__ = function(state_67959){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__10945__auto____1.call(this,state_67959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_67975 = f__11019__auto__.call(null);
(statearr_67975[(6)] = c__11018__auto__);

return statearr_67975;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
