// Compiled by ClojureScript 1.11.57 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.call(null,param_str):param_str);
if(cljs.core.map_QMARK_.call(null,parsed_param)){
var key = cljs.core.first.call(null,cljs.core.keys.call(null,parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace.call(null,key) == null))?cljs.core.name.call(null,key):[cljs.core.namespace.call(null,key),"/",cljs.core.name.call(null,key)].join('')));
var value = cljs.core.first.call(null,cljs.core.vals.call(null,parsed_param));
var value_SINGLEQUOTE_ = fluree.db.dbfunctions.internal.parse_select_map.call(null,value);
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,value_SINGLEQUOTE_))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.call(null,cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_.call(null,parsed_param)))){
if((cljs.core.namespace.call(null,parsed_param) == null)){
return cljs.core.name.call(null,parsed_param);
} else {
return [cljs.core.namespace.call(null,parsed_param),"/",cljs.core.name.call(null,parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_.call(null,parsed_param)){
return cljs.core.mapv.call(null,fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.call(null,["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__5774__auto__ = [];
var len__5768__auto___39835 = arguments.length;
var i__5769__auto___39836 = (0);
while(true){
if((i__5769__auto___39836 < len__5768__auto___39835)){
args__5774__auto__.push((arguments[i__5769__auto___39836]));

var G__39837 = (i__5769__auto___39836 + (1));
i__5769__auto___39836 = G__39837;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((2) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.call(null,e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.call(null,args));

throw cljs.core.ex_info.call(null,(function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,args))?clojure.string.join.call(null," ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq39832){
var G__39833 = cljs.core.first.call(null,seq39832);
var seq39832__$1 = cljs.core.next.call(null,seq39832);
var G__39834 = cljs.core.first.call(null,seq39832__$1);
var seq39832__$2 = cljs.core.next.call(null,seq39832__$1);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__39833,G__39834,seq39832__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$.call(null,x);
}catch (e39838){var e = e39838;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"boolean",x);
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e39839){var e = e39839;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nil?",arg);
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not.call(null,arg);
}catch (e39840){var e = e39840;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not",arg);
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_.call(null,arg)) || (cljs.core._EQ_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e39841){var e = e39841;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"empty?",arg);
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e39842){var e = e39842;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"if-else",test,true_res,false_res);
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__5774__auto__ = [];
var len__5768__auto___39845 = arguments.length;
var i__5769__auto___39846 = (0);
while(true){
if((i__5769__auto___39846 < len__5768__auto___39845)){
args__5774__auto__.push((arguments[i__5769__auto___39846]));

var G__39847 = (i__5769__auto___39846 + (1));
i__5769__auto___39846 = G__39847;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e39844){var e = e39844;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"and",args);
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq39843){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq39843));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__5774__auto__ = [];
var len__5768__auto___39850 = arguments.length;
var i__5769__auto___39851 = (0);
while(true){
if((i__5769__auto___39851 < len__5768__auto___39850)){
args__5774__auto__.push((arguments[i__5769__auto___39851]));

var G__39852 = (i__5769__auto___39851 + (1));
i__5769__auto___39851 = G__39852;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.some.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e39849){var e = e39849;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"or",args);
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq39848){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq39848));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count.call(null,coll);
}catch (e39853){var e = e39853;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"count",coll);
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__5774__auto__ = [];
var len__5768__auto___39856 = arguments.length;
var i__5769__auto___39857 = (0);
while(true){
if((i__5769__auto___39857 < len__5768__auto___39856)){
args__5774__auto__.push((arguments[i__5769__auto___39857]));

var G__39858 = (i__5769__auto___39857 + (1));
i__5769__auto___39857 = G__39858;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.str,args);
}catch (e39855){var e = e39855;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"str",args);
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq39854){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq39854));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__5774__auto__ = [];
var len__5768__auto___39861 = arguments.length;
var i__5769__auto___39862 = (0);
while(true){
if((i__5769__auto___39862 < len__5768__auto___39861)){
args__5774__auto__.push((arguments[i__5769__auto___39862]));

var G__39863 = (i__5769__auto___39862 + (1));
i__5769__auto___39862 = G__39863;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.subs,args);
}catch (e39860){var e = e39860;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"subs",args);
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq39859){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq39859));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case.call(null,str);
}catch (e39864){var e = e39864;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"lower-case",str);
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case.call(null,str);
}catch (e39865){var e = e39865;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"upper-case",str);
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__5774__auto__ = [];
var len__5768__auto___39868 = arguments.length;
var i__5769__auto___39869 = (0);
while(true){
if((i__5769__auto___39869 < len__5768__auto___39868)){
args__5774__auto__.push((arguments[i__5769__auto___39869]));

var G__39870 = (i__5769__auto___39869 + (1));
i__5769__auto___39869 = G__39870;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.max,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e39867){var e = e39867;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"max",args);
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq39866){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq39866));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__5774__auto__ = [];
var len__5768__auto___39873 = arguments.length;
var i__5769__auto___39874 = (0);
while(true){
if((i__5769__auto___39874 < len__5768__auto___39873)){
args__5774__auto__.push((arguments[i__5769__auto___39874]));

var G__39875 = (i__5769__auto___39874 + (1));
i__5769__auto___39874 = G__39875;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e39872){var e = e39872;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"min",args);
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq39871){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq39871));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___39878 = arguments.length;
var i__5769__auto___39879 = (0);
while(true){
if((i__5769__auto___39879 < len__5768__auto___39878)){
args__5774__auto__.push((arguments[i__5769__auto___39879]));

var G__39880 = (i__5769__auto___39879 + (1));
i__5769__auto___39879 = G__39880;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT_,args);
}catch (e39877){var e = e39877;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">",args);
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq39876){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq39876));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___39883 = arguments.length;
var i__5769__auto___39884 = (0);
while(true){
if((i__5769__auto___39884 < len__5768__auto___39883)){
args__5774__auto__.push((arguments[i__5769__auto___39884]));

var G__39885 = (i__5769__auto___39884 + (1));
i__5769__auto___39884 = G__39885;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT__EQ_,args);
}catch (e39882){var e = e39882;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">=",args);
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq39881){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq39881));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___39888 = arguments.length;
var i__5769__auto___39889 = (0);
while(true){
if((i__5769__auto___39889 < len__5768__auto___39888)){
args__5774__auto__.push((arguments[i__5769__auto___39889]));

var G__39890 = (i__5769__auto___39889 + (1));
i__5769__auto___39889 = G__39890;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT_,args);
}catch (e39887){var e = e39887;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<",args);
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq39886){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq39886));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___39893 = arguments.length;
var i__5769__auto___39894 = (0);
while(true){
if((i__5769__auto___39894 < len__5768__auto___39893)){
args__5774__auto__.push((arguments[i__5769__auto___39894]));

var G__39895 = (i__5769__auto___39894 + (1));
i__5769__auto___39894 = G__39895;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT__EQ_,args);
}catch (e39892){var e = e39892;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<=",args);
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq39891){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq39891));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___39898 = arguments.length;
var i__5769__auto___39899 = (0);
while(true){
if((i__5769__auto___39899 < len__5768__auto___39898)){
args__5774__auto__.push((arguments[i__5769__auto___39899]));

var G__39900 = (i__5769__auto___39899 + (1));
i__5769__auto___39899 = G__39900;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.not_EQ_,args);
}catch (e39897){var e = e39897;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not=",args);
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq39896){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq39896));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__39902 = arguments.length;
switch (G__39902) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_39930){
var state_val_39931 = (state_39930[(1)]);
if((state_val_39931 === (7))){
var inst_39915 = (state_39930[(7)]);
var inst_39918 = fluree.db.dbfunctions.internal.function_error.call(null,inst_39915,"query",query_map);
var state_39930__$1 = state_39930;
var statearr_39932_40018 = state_39930__$1;
(statearr_39932_40018[(2)] = inst_39918);

(statearr_39932_40018[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39931 === (1))){
var state_39930__$1 = state_39930;
var statearr_39933_40019 = state_39930__$1;
(statearr_39933_40019[(2)] = null);

(statearr_39933_40019[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39931 === (4))){
var inst_39903 = (state_39930[(2)]);
var state_39930__$1 = state_39930;
var statearr_39934_40020 = state_39930__$1;
(statearr_39934_40020[(2)] = inst_39903);

(statearr_39934_40020[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39931 === (6))){
var inst_39915 = (state_39930[(7)]);
var inst_39915__$1 = (state_39930[(2)]);
var inst_39916 = fluree.db.util.core.exception_QMARK_.call(null,inst_39915__$1);
var state_39930__$1 = (function (){var statearr_39935 = state_39930;
(statearr_39935[(7)] = inst_39915__$1);

return statearr_39935;
})();
if(inst_39916){
var statearr_39936_40021 = state_39930__$1;
(statearr_39936_40021[(1)] = (7));

} else {
var statearr_39937_40022 = state_39930__$1;
(statearr_39937_40022[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39931 === (3))){
var inst_39928 = (state_39930[(2)]);
var state_39930__$1 = state_39930;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39930__$1,inst_39928);
} else {
if((state_val_39931 === (2))){
var inst_39909 = (state_39930[(8)]);
var _ = (function (){var statearr_39939 = state_39930;
(statearr_39939[(4)] = cljs.core.cons.call(null,(5),(state_39930[(4)])));

return statearr_39939;
})();
var inst_39909__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_39910 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_39911 = cljs.core.assoc.call(null,inst_39910,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_39909__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000));
var inst_39912 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_39911);
var inst_39913 = fluree.db.query.fql.query.call(null,db,inst_39912);
var state_39930__$1 = (function (){var statearr_39940 = state_39930;
(statearr_39940[(8)] = inst_39909__$1);

return statearr_39940;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39930__$1,(6),inst_39913);
} else {
if((state_val_39931 === (9))){
var inst_39925 = (state_39930[(2)]);
var _ = (function (){var statearr_39941 = state_39930;
(statearr_39941[(4)] = cljs.core.rest.call(null,(state_39930[(4)])));

return statearr_39941;
})();
var state_39930__$1 = state_39930;
var statearr_39942_40023 = state_39930__$1;
(statearr_39942_40023[(2)] = inst_39925);

(statearr_39942_40023[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39931 === (5))){
var _ = (function (){var statearr_39943 = state_39930;
(statearr_39943[(4)] = cljs.core.rest.call(null,(state_39930[(4)])));

return statearr_39943;
})();
var state_39930__$1 = state_39930;
var ex39938 = (state_39930__$1[(2)]);
var statearr_39944_40024 = state_39930__$1;
(statearr_39944_40024[(5)] = ex39938);


if((ex39938 instanceof Error)){
var statearr_39945_40025 = state_39930__$1;
(statearr_39945_40025[(1)] = (4));

(statearr_39945_40025[(5)] = null);

} else {
throw ex39938;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39931 === (8))){
var inst_39909 = (state_39930[(8)]);
var inst_39915 = (state_39930[(7)]);
var inst_39920 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39921 = cljs.core.deref.call(null,inst_39909);
var inst_39922 = [inst_39915,inst_39921];
var inst_39923 = (new cljs.core.PersistentVector(null,2,(5),inst_39920,inst_39922,null));
var state_39930__$1 = state_39930;
var statearr_39946_40026 = state_39930__$1;
(statearr_39946_40026[(2)] = inst_39923);

(statearr_39946_40026[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__10945__auto____0 = (function (){
var statearr_39947 = [null,null,null,null,null,null,null,null,null];
(statearr_39947[(0)] = fluree$db$dbfunctions$internal$state_machine__10945__auto__);

(statearr_39947[(1)] = (1));

return statearr_39947;
});
var fluree$db$dbfunctions$internal$state_machine__10945__auto____1 = (function (state_39930){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_39930);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e39948){var ex__10948__auto__ = e39948;
var statearr_39949_40027 = state_39930;
(statearr_39949_40027[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_39930[(4)]))){
var statearr_39950_40028 = state_39930;
(statearr_39950_40028[(1)] = cljs.core.first.call(null,(state_39930[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40029 = state_39930;
state_39930 = G__40029;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__10945__auto__ = function(state_39930){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__10945__auto____1.call(this,state_39930);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__10945__auto____0;
fluree$db$dbfunctions$internal$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__10945__auto____1;
return fluree$db$dbfunctions$internal$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_39951 = f__11019__auto__.call(null);
(statearr_39951[(6)] = c__11018__auto__);

return statearr_39951;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_39996){
var state_val_39997 = (state_39996[(1)]);
if((state_val_39997 === (7))){
var inst_39982 = (state_39996[(2)]);
var inst_39983 = fluree.db.query.fql.query.call(null,db,inst_39982);
var state_39996__$1 = state_39996;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39996__$1,(8),inst_39983);
} else {
if((state_val_39997 === (1))){
var inst_39952 = typeof select === 'string';
var state_39996__$1 = state_39996;
if(cljs.core.truth_(inst_39952)){
var statearr_39998_40030 = state_39996__$1;
(statearr_39998_40030[(1)] = (2));

} else {
var statearr_39999_40031 = state_39996__$1;
(statearr_39999_40031[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39997 === (4))){
var inst_39958 = (state_39996[(7)]);
var inst_39965 = (state_39996[(8)]);
var inst_39957 = (state_39996[(2)]);
var inst_39958__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_39959 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_39960 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_39961 = [inst_39958__$1,(100000)];
var inst_39962 = cljs.core.PersistentHashMap.fromArrays(inst_39960,inst_39961);
var inst_39963 = [inst_39957,from,where,block,limit,inst_39962];
var inst_39964 = cljs.core.PersistentHashMap.fromArrays(inst_39959,inst_39963);
var inst_39965__$1 = fluree.db.util.core.without_nils.call(null,inst_39964);
var inst_39966 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_39965__$1);
var inst_39967 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_39965__$1);
var inst_39968 = cljs.core.first.call(null,inst_39967);
var inst_39969 = fluree.db.dbfunctions.internal.str.call(null,inst_39968);
var inst_39970 = cljs.core._EQ_.call(null,"[",inst_39969);
var inst_39971 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_39965__$1);
var inst_39972 = cljs.core.last.call(null,inst_39971);
var inst_39973 = fluree.db.dbfunctions.internal.str.call(null,inst_39972);
var inst_39974 = cljs.core._EQ_.call(null,"]",inst_39973);
var inst_39975 = fluree.db.dbfunctions.internal.and.call(null,inst_39966,inst_39970,inst_39974);
var state_39996__$1 = (function (){var statearr_40000 = state_39996;
(statearr_40000[(7)] = inst_39958__$1);

(statearr_40000[(8)] = inst_39965__$1);

return statearr_40000;
})();
if(cljs.core.truth_(inst_39975)){
var statearr_40001_40032 = state_39996__$1;
(statearr_40001_40032[(1)] = (5));

} else {
var statearr_40002_40033 = state_39996__$1;
(statearr_40002_40033[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39997 === (6))){
var inst_39965 = (state_39996[(8)]);
var state_39996__$1 = state_39996;
var statearr_40003_40034 = state_39996__$1;
(statearr_40003_40034[(2)] = inst_39965);

(statearr_40003_40034[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39997 === (3))){
var state_39996__$1 = state_39996;
var statearr_40004_40035 = state_39996__$1;
(statearr_40004_40035[(2)] = select);

(statearr_40004_40035[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39997 === (2))){
var inst_39954 = fluree.db.dbfunctions.internal.parse_select_map.call(null,select);
var state_39996__$1 = state_39996;
var statearr_40005_40036 = state_39996__$1;
(statearr_40005_40036[(2)] = inst_39954);

(statearr_40005_40036[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39997 === (11))){
var inst_39994 = (state_39996[(2)]);
var state_39996__$1 = state_39996;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39996__$1,inst_39994);
} else {
if((state_val_39997 === (9))){
var inst_39985 = (state_39996[(9)]);
var state_39996__$1 = state_39996;
var statearr_40006_40037 = state_39996__$1;
(statearr_40006_40037[(2)] = inst_39985);

(statearr_40006_40037[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39997 === (5))){
var inst_39965 = (state_39996[(8)]);
var inst_39977 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_39965);
var inst_39978 = cljs.reader.read_string.call(null,inst_39977);
var inst_39979 = cljs.core.assoc.call(null,inst_39965,new cljs.core.Keyword(null,"where","where",-2044795965),inst_39978);
var state_39996__$1 = state_39996;
var statearr_40007_40038 = state_39996__$1;
(statearr_40007_40038[(2)] = inst_39979);

(statearr_40007_40038[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39997 === (10))){
var inst_39985 = (state_39996[(9)]);
var inst_39958 = (state_39996[(7)]);
var inst_39989 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39990 = cljs.core.deref.call(null,inst_39958);
var inst_39991 = [inst_39985,inst_39990];
var inst_39992 = (new cljs.core.PersistentVector(null,2,(5),inst_39989,inst_39991,null));
var state_39996__$1 = state_39996;
var statearr_40008_40039 = state_39996__$1;
(statearr_40008_40039[(2)] = inst_39992);

(statearr_40008_40039[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39997 === (8))){
var inst_39985 = (state_39996[(9)]);
var inst_39985__$1 = (state_39996[(2)]);
var inst_39986 = fluree.db.util.core.exception_QMARK_.call(null,inst_39985__$1);
var state_39996__$1 = (function (){var statearr_40009 = state_39996;
(statearr_40009[(9)] = inst_39985__$1);

return statearr_40009;
})();
if(inst_39986){
var statearr_40010_40040 = state_39996__$1;
(statearr_40010_40040[(1)] = (9));

} else {
var statearr_40011_40041 = state_39996__$1;
(statearr_40011_40041[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__10945__auto____0 = (function (){
var statearr_40012 = [null,null,null,null,null,null,null,null,null,null];
(statearr_40012[(0)] = fluree$db$dbfunctions$internal$state_machine__10945__auto__);

(statearr_40012[(1)] = (1));

return statearr_40012;
});
var fluree$db$dbfunctions$internal$state_machine__10945__auto____1 = (function (state_39996){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_39996);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e40013){var ex__10948__auto__ = e40013;
var statearr_40014_40042 = state_39996;
(statearr_40014_40042[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_39996[(4)]))){
var statearr_40015_40043 = state_39996;
(statearr_40015_40043[(1)] = cljs.core.first.call(null,(state_39996[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40044 = state_39996;
state_39996 = G__40044;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__10945__auto__ = function(state_39996){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__10945__auto____1.call(this,state_39996);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__10945__auto____0;
fluree$db$dbfunctions$internal$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__10945__auto____1;
return fluree$db$dbfunctions$internal$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_40016 = f__11019__auto__.call(null);
(statearr_40016[(6)] = c__11018__auto__);

return statearr_40016;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.call(null,fluree.db.dbfunctions.internal.str.call(null,"Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace.call(null,pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__40048 = path;
var vec__40049 = G__40048;
var seq__40050 = cljs.core.seq.call(null,vec__40049);
var first__40051 = cljs.core.first.call(null,seq__40050);
var seq__40050__$1 = cljs.core.next.call(null,seq__40050);
var var$ = first__40051;
var r = seq__40050__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__40048__$1 = G__40048;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__40055 = G__40048__$1;
var seq__40056 = cljs.core.seq.call(null,vec__40055);
var first__40057 = cljs.core.first.call(null,seq__40056);
var seq__40056__$1 = cljs.core.next.call(null,seq__40056);
var var$__$1 = first__40057;
var r__$1 = seq__40056__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.call(null,fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_.call(null,r__$1)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null)], null));
var G__40058 = r__$1;
var G__40059 = n__$2;
var G__40060 = next_clauses;
G__40048__$1 = G__40058;
n__$1 = G__40059;
where_clauses__$1 = G__40060;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",next_n),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",next_n)], null));
var G__40061 = r__$1;
var G__40062 = next_n;
var G__40063 = cljs.core.conj.call(null,where_clauses__$2,next_clause);
G__40048__$1 = G__40061;
n__$1 = G__40062;
where_clauses__$1 = G__40063;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,endSubject], null));
return cljs.core.conj.call(null,where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_40100){
var state_val_40101 = (state_40100[(1)]);
if((state_val_40101 === (7))){
var inst_40073 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40074 = [path];
var inst_40075 = (new cljs.core.PersistentVector(null,1,(5),inst_40073,inst_40074,null));
var state_40100__$1 = state_40100;
var statearr_40102_40130 = state_40100__$1;
(statearr_40102_40130[(2)] = inst_40075);

(statearr_40102_40130[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40101 === (1))){
var state_40100__$1 = state_40100;
var statearr_40103_40131 = state_40100__$1;
(statearr_40103_40131[(2)] = null);

(statearr_40103_40131[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40101 === (4))){
var inst_40064 = (state_40100[(2)]);
var state_40100__$1 = state_40100;
var statearr_40104_40132 = state_40100__$1;
(statearr_40104_40132[(2)] = inst_40064);

(statearr_40104_40132[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40101 === (13))){
var inst_40091 = (state_40100[(2)]);
var inst_40092 = fluree.db.util.async.throw_err.call(null,inst_40091);
var _ = (function (){var statearr_40105 = state_40100;
(statearr_40105[(4)] = cljs.core.rest.call(null,(state_40100[(4)])));

return statearr_40105;
})();
var state_40100__$1 = state_40100;
var statearr_40106_40133 = state_40100__$1;
(statearr_40106_40133[(2)] = inst_40092);

(statearr_40106_40133[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40101 === (6))){
var state_40100__$1 = state_40100;
var statearr_40108_40134 = state_40100__$1;
(statearr_40108_40134[(2)] = path);

(statearr_40108_40134[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40101 === (3))){
var inst_40098 = (state_40100[(2)]);
var state_40100__$1 = state_40100;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40100__$1,inst_40098);
} else {
if((state_val_40101 === (12))){
var _ = (function (){var statearr_40109 = state_40100;
(statearr_40109[(4)] = cljs.core.rest.call(null,(state_40100[(4)])));

return statearr_40109;
})();
var state_40100__$1 = state_40100;
var ex40107 = (state_40100__$1[(2)]);
var statearr_40110_40135 = state_40100__$1;
(statearr_40110_40135[(5)] = ex40107);


var statearr_40111_40136 = state_40100__$1;
(statearr_40111_40136[(1)] = (11));

(statearr_40111_40136[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40101 === (2))){
var _ = (function (){var statearr_40112 = state_40100;
(statearr_40112[(4)] = cljs.core.cons.call(null,(5),(state_40100[(4)])));

return statearr_40112;
})();
var inst_40070 = cljs.core.vector_QMARK_.call(null,path);
var state_40100__$1 = state_40100;
if(inst_40070){
var statearr_40113_40137 = state_40100__$1;
(statearr_40113_40137[(1)] = (6));

} else {
var statearr_40114_40138 = state_40100__$1;
(statearr_40114_40138[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40101 === (11))){
var inst_40077 = (state_40100[(7)]);
var inst_40082 = (state_40100[(2)]);
var inst_40083 = fluree.db.dbfunctions.internal.function_error.call(null,inst_40082,"relationship?",startSubject,inst_40077,endSubject);
var state_40100__$1 = state_40100;
var statearr_40116_40139 = state_40100__$1;
(statearr_40116_40139[(2)] = inst_40083);

(statearr_40116_40139[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40101 === (9))){
var inst_40081 = (state_40100[(8)]);
var _ = (function (){var statearr_40117 = state_40100;
(statearr_40117[(4)] = cljs.core.cons.call(null,(12),(state_40100[(4)])));

return statearr_40117;
})();
var inst_40089 = fluree.db.dbfunctions.internal.query.call(null,db,inst_40081);
var state_40100__$1 = state_40100;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40100__$1,(13),inst_40089);
} else {
if((state_val_40101 === (5))){
var _ = (function (){var statearr_40118 = state_40100;
(statearr_40118[(4)] = cljs.core.rest.call(null,(state_40100[(4)])));

return statearr_40118;
})();
var state_40100__$1 = state_40100;
var ex40115 = (state_40100__$1[(2)]);
var statearr_40119_40140 = state_40100__$1;
(statearr_40119_40140[(5)] = ex40115);


if((ex40115 instanceof Error)){
var statearr_40120_40141 = state_40100__$1;
(statearr_40120_40141[(1)] = (4));

(statearr_40120_40141[(5)] = null);

} else {
throw ex40115;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40101 === (10))){
var inst_40095 = (state_40100[(2)]);
var _ = (function (){var statearr_40121 = state_40100;
(statearr_40121[(4)] = cljs.core.rest.call(null,(state_40100[(4)])));

return statearr_40121;
})();
var state_40100__$1 = state_40100;
var statearr_40122_40142 = state_40100__$1;
(statearr_40122_40142[(2)] = inst_40095);

(statearr_40122_40142[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40101 === (8))){
var inst_40077 = (state_40100[(7)]);
var inst_40077__$1 = (state_40100[(2)]);
var inst_40078 = fluree.db.dbfunctions.internal.build_where_clause.call(null,startSubject,inst_40077__$1,endSubject);
var inst_40079 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_40080 = ["?var1",inst_40078];
var inst_40081 = cljs.core.PersistentHashMap.fromArrays(inst_40079,inst_40080);
var state_40100__$1 = (function (){var statearr_40123 = state_40100;
(statearr_40123[(8)] = inst_40081);

(statearr_40123[(7)] = inst_40077__$1);

return statearr_40123;
})();
var statearr_40124_40143 = state_40100__$1;
(statearr_40124_40143[(2)] = null);

(statearr_40124_40143[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10945__auto____0 = (function (){
var statearr_40125 = [null,null,null,null,null,null,null,null,null];
(statearr_40125[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10945__auto__);

(statearr_40125[(1)] = (1));

return statearr_40125;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10945__auto____1 = (function (state_40100){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_40100);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e40126){var ex__10948__auto__ = e40126;
var statearr_40127_40144 = state_40100;
(statearr_40127_40144[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_40100[(4)]))){
var statearr_40128_40145 = state_40100;
(statearr_40128_40145[(1)] = cljs.core.first.call(null,(state_40100[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40146 = state_40100;
state_40100 = G__40146;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10945__auto__ = function(state_40100){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10945__auto____1.call(this,state_40100);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10945__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_40129 = f__11019__auto__.call(null);
(statearr_40129[(6)] = c__11018__auto__);

return statearr_40129;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (1);
} else {
return (n + (1));
}
}catch (e40147){var e = e40147;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"inc",n);
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (-1);
} else {
return (n - (1));
}
}catch (e40148){var e = e40148;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"dec",n);
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__5045__auto__ = cljs.core.get.call(null,m,k);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,m,cljs.core.keyword.call(null,k));
}
}catch (e40149){var e = e40149;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get",m,k);
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis.call(null);
}catch (e40150){var e = e40150;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___40153 = arguments.length;
var i__5769__auto___40154 = (0);
while(true){
if((i__5769__auto___40154 < len__5768__auto___40153)){
args__5774__auto__.push((arguments[i__5769__auto___40154]));

var G__40155 = (i__5769__auto___40154 + (1));
i__5769__auto___40154 = G__40155;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._PLUS_,args);
}catch (e40152){var e = e40152;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"+",args);
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq40151){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq40151));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___40158 = arguments.length;
var i__5769__auto___40159 = (0);
while(true){
if((i__5769__auto___40159 < len__5768__auto___40158)){
args__5774__auto__.push((arguments[i__5769__auto___40159]));

var G__40160 = (i__5769__auto___40159 + (1));
i__5769__auto___40159 = G__40160;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._,args);
}catch (e40157){var e = e40157;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"-",args);
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq40156){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq40156));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___40163 = arguments.length;
var i__5769__auto___40164 = (0);
while(true){
if((i__5769__auto___40164 < len__5768__auto___40163)){
args__5774__auto__.push((arguments[i__5769__auto___40164]));

var G__40165 = (i__5769__auto___40164 + (1));
i__5769__auto___40164 = G__40165;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__5045__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_.call(null,args);
}
})())){
return (1);
} else {
return cljs.core.apply.call(null,cljs.core._STAR_,args);
}
}catch (e40162){var e = e40162;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"*",args);
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq40161){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq40161));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___40168 = arguments.length;
var i__5769__auto___40169 = (0);
while(true){
if((i__5769__auto___40169 < len__5768__auto___40168)){
args__5774__auto__.push((arguments[i__5769__auto___40169]));

var G__40170 = (i__5769__auto___40169 + (1));
i__5769__auto___40169 = G__40170;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
throw cljs.core.ex_info.call(null,"Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.call(null,cljs.core._SLASH_,args);
}
}catch (e40167){var e = e40167;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"/",args);
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq40166){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq40166));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot.call(null,n,d);
}catch (e40171){var e = e40171;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"quot",n,d);
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod.call(null,n,d);
}catch (e40172){var e = e40172;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"mod",n,d);
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem.call(null,n,d);
}catch (e40173){var e = e40173;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rem",n,d);
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e40174){var e = e40174;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"ceil",num);
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e40175){var e = e40175;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"floor",num);
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__40181 = path;
var vec__40182 = G__40181;
var seq__40183 = cljs.core.seq.call(null,vec__40182);
var first__40184 = cljs.core.first.call(null,seq__40183);
var seq__40183__$1 = cljs.core.next.call(null,seq__40183);
var pred = first__40184;
var r = seq__40183__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__40181__$1 = G__40181;
var subjects__$1 = subjects;
while(true){
var vec__40188 = G__40181__$1;
var seq__40189 = cljs.core.seq.call(null,vec__40188);
var first__40190 = cljs.core.first.call(null,seq__40189);
var seq__40189__$1 = cljs.core.next.call(null,seq__40189);
var pred__$1 = first__40190;
var r__$1 = seq__40189__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.call(null,((function (G__40181__$1,subjects__$1,vec__40188,seq__40189,first__40190,seq__40189__$1,pred__$1,r__$1,subjects__$2,G__40181,vec__40182,seq__40183,first__40184,seq__40183__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_.call(null,subject))?cljs.core.mapv.call(null,((function (G__40181__$1,subjects__$1,vec__40188,seq__40189,first__40190,seq__40189__$1,pred__$1,r__$1,subjects__$2,G__40181,vec__40182,seq__40183,first__40184,seq__40183__$1,pred,r,subjects){
return (function (p1__40176_SHARP_){
return fluree.db.dbfunctions.internal.get.call(null,p1__40176_SHARP_,pred__$1);
});})(G__40181__$1,subjects__$1,vec__40188,seq__40189,first__40190,seq__40189__$1,pred__$1,r__$1,subjects__$2,G__40181,vec__40182,seq__40183,first__40184,seq__40183__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get.call(null,subject,pred__$1));
if(((cljs.core.vector_QMARK_.call(null,sub_subjects)) || (cljs.core.set_QMARK_.call(null,sub_subjects)))){
return cljs.core.into.call(null,acc,sub_subjects);
} else {
return cljs.core.conj.call(null,acc,sub_subjects);
}
});})(G__40181__$1,subjects__$1,vec__40188,seq__40189,first__40190,seq__40189__$1,pred__$1,r__$1,subjects__$2,G__40181,vec__40182,seq__40183,first__40184,seq__40183__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__5043__auto__ = r__$1;
if(and__5043__auto__){
return cljs.core.not_empty.call(null,next_subjects);
} else {
return and__5043__auto__;
}
})())){
var G__40191 = r__$1;
var G__40192 = next_subjects;
G__40181__$1 = G__40191;
subjects__$1 = G__40192;
continue;
} else {
return cljs.core.set.call(null,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e40177){var e = e40177;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-all",start_subject,path);
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all.call(null,m,ks);
}catch (e40193){var e = e40193;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-in",m,ks);
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_.call(null,coll,key);
}catch (e40194){var e = e40194;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"contains?",coll,key);
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__5774__auto__ = [];
var len__5768__auto___40197 = arguments.length;
var i__5769__auto___40198 = (0);
while(true){
if((i__5769__auto___40198 < len__5768__auto___40197)){
args__5774__auto__.push((arguments[i__5769__auto___40198]));

var G__40199 = (i__5769__auto___40198 + (1));
i__5769__auto___40198 = G__40199;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.hash_set,args);
}catch (e40196){var e = e40196;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"hash-set",args);
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq40195){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq40195));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_.call(null,coll))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.call(null,coll_SINGLEQUOTE_,key);
}catch (e40200){var e = e40200;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nth",coll,key);
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___40203 = arguments.length;
var i__5769__auto___40204 = (0);
while(true){
if((i__5769__auto___40204 < len__5768__auto___40203)){
args__5774__auto__.push((arguments[i__5769__auto___40204]));

var G__40205 = (i__5769__auto___40204 + (1));
i__5769__auto___40204 = G__40205;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._EQ_,args);
}catch (e40202){var e = e40202;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"==",args);
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq40201){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq40201));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,pattern),string);
}catch (e40206){var e = e40206;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"re-find",pattern,string);
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_40263){
var state_val_40264 = (state_40263[(1)]);
if((state_val_40264 === (7))){
var inst_40209 = (state_40263[(2)]);
var state_40263__$1 = state_40263;
var statearr_40265_40299 = state_40263__$1;
(statearr_40265_40299[(2)] = inst_40209);

(statearr_40265_40299[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40264 === (1))){
var state_40263__$1 = state_40263;
var statearr_40266_40300 = state_40263__$1;
(statearr_40266_40300[(2)] = null);

(statearr_40266_40300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40264 === (4))){
var inst_40208 = (state_40263[(2)]);
var state_40263__$1 = (function (){var statearr_40267 = state_40263;
(statearr_40267[(7)] = inst_40208);

return statearr_40267;
})();
var statearr_40268_40301 = state_40263__$1;
(statearr_40268_40301[(2)] = null);

(statearr_40268_40301[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40264 === (15))){
var inst_40244 = (state_40263[(8)]);
var inst_40233 = (state_40263[(9)]);
var inst_40231 = (state_40263[(10)]);
var inst_40243 = (state_40263[(11)]);
var inst_40246 = (state_40263[(12)]);
var inst_40234 = (state_40263[(13)]);
var inst_40250 = (function (){var db = inst_40231;
var prevT = inst_40233;
var db_SINGLEQUOTE_ = inst_40234;
var prev_vals = inst_40243;
var fuel = inst_40244;
var G__40245 = inst_40246;
return (function (p1__40207_SHARP_){
var f = p1__40207_SHARP_;
return f.o;
});
})();
var inst_40251 = inst_40250.call(null,inst_40246);
var state_40263__$1 = state_40263;
var statearr_40269_40302 = state_40263__$1;
(statearr_40269_40302[(2)] = inst_40251);

(statearr_40269_40302[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40264 === (13))){
var inst_40243 = (state_40263[(11)]);
var inst_40246 = (state_40263[(12)]);
var inst_40242 = (state_40263[(2)]);
var inst_40243__$1 = fluree.db.util.async.throw_err.call(null,inst_40242);
var inst_40244 = fluree.db.dbfunctions.internal.count.call(null,inst_40243__$1);
var inst_40246__$1 = cljs.core.first.call(null,inst_40243__$1);
var inst_40247 = (inst_40246__$1 == null);
var state_40263__$1 = (function (){var statearr_40270 = state_40263;
(statearr_40270[(8)] = inst_40244);

(statearr_40270[(11)] = inst_40243__$1);

(statearr_40270[(12)] = inst_40246__$1);

return statearr_40270;
})();
if(cljs.core.truth_(inst_40247)){
var statearr_40271_40303 = state_40263__$1;
(statearr_40271_40303[(1)] = (14));

} else {
var statearr_40272_40304 = state_40263__$1;
(statearr_40272_40304[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40264 === (6))){
var inst_40218 = (state_40263[(2)]);
var state_40263__$1 = state_40263;
var statearr_40273_40305 = state_40263__$1;
(statearr_40273_40305[(2)] = inst_40218);

(statearr_40273_40305[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40264 === (3))){
var inst_40261 = (state_40263[(2)]);
var state_40263__$1 = state_40263;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40263__$1,inst_40261);
} else {
if((state_val_40264 === (12))){
var inst_40258 = (state_40263[(2)]);
var _ = (function (){var statearr_40274 = state_40263;
(statearr_40274[(4)] = cljs.core.rest.call(null,(state_40263[(4)])));

return statearr_40274;
})();
var state_40263__$1 = state_40263;
var statearr_40275_40306 = state_40263__$1;
(statearr_40275_40306[(2)] = inst_40258);

(statearr_40275_40306[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40264 === (2))){
var _ = (function (){var statearr_40277 = state_40263;
(statearr_40277[(4)] = cljs.core.cons.call(null,(9),(state_40263[(4)])));

return statearr_40277;
})();
var inst_40224 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40225 = typeof inst_40224 === 'string';
var state_40263__$1 = state_40263;
if(cljs.core.truth_(inst_40225)){
var statearr_40278_40307 = state_40263__$1;
(statearr_40278_40307[(1)] = (10));

} else {
var statearr_40279_40308 = state_40263__$1;
(statearr_40279_40308[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40264 === (11))){
var inst_40233 = (state_40263[(9)]);
var inst_40231 = (state_40263[(10)]);
var inst_40234 = (state_40263[(13)]);
var inst_40231__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40232 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_40231__$1);
var inst_40233__$1 = fluree.db.dbfunctions.internal.inc.call(null,inst_40232);
var inst_40234__$1 = cljs.core.assoc.call(null,inst_40231__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_40233__$1);
var inst_40235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40236 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40237 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40238 = [inst_40236,inst_40237];
var inst_40239 = (new cljs.core.PersistentVector(null,2,(5),inst_40235,inst_40238,null));
var inst_40240 = fluree.db.dbproto._search.call(null,inst_40234__$1,inst_40239);
var state_40263__$1 = (function (){var statearr_40280 = state_40263;
(statearr_40280[(9)] = inst_40233__$1);

(statearr_40280[(10)] = inst_40231__$1);

(statearr_40280[(13)] = inst_40234__$1);

return statearr_40280;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40263__$1,(13),inst_40240);
} else {
if((state_val_40264 === (9))){
var _ = (function (){var statearr_40281 = state_40263;
(statearr_40281[(4)] = cljs.core.rest.call(null,(state_40263[(4)])));

return statearr_40281;
})();
var state_40263__$1 = state_40263;
var ex40276 = (state_40263__$1[(2)]);
var statearr_40282_40309 = state_40263__$1;
(statearr_40282_40309[(5)] = ex40276);


var statearr_40283_40310 = state_40263__$1;
(statearr_40283_40310[(1)] = (4));

(statearr_40283_40310[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40264 === (5))){
var inst_40208 = (state_40263[(7)]);
var _ = (function (){var statearr_40284 = state_40263;
(statearr_40284[(4)] = cljs.core.cons.call(null,(8),(state_40263[(4)])));

return statearr_40284;
})();
var inst_40215 = fluree.db.dbfunctions.internal.function_error.call(null,inst_40208,"?pO","Context Object");
var ___$1 = (function (){var statearr_40285 = state_40263;
(statearr_40285[(4)] = cljs.core.rest.call(null,(state_40263[(4)])));

return statearr_40285;
})();
var state_40263__$1 = state_40263;
var statearr_40286_40311 = state_40263__$1;
(statearr_40286_40311[(2)] = inst_40215);

(statearr_40286_40311[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40264 === (14))){
var state_40263__$1 = state_40263;
var statearr_40287_40312 = state_40263__$1;
(statearr_40287_40312[(2)] = null);

(statearr_40287_40312[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40264 === (16))){
var inst_40244 = (state_40263[(8)]);
var inst_40253 = (state_40263[(2)]);
var inst_40254 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40255 = [inst_40253,inst_40244];
var inst_40256 = (new cljs.core.PersistentVector(null,2,(5),inst_40254,inst_40255,null));
var state_40263__$1 = state_40263;
var statearr_40289_40313 = state_40263__$1;
(statearr_40289_40313[(2)] = inst_40256);

(statearr_40289_40313[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40264 === (10))){
var inst_40227 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40228 = [null,(0)];
var inst_40229 = (new cljs.core.PersistentVector(null,2,(5),inst_40227,inst_40228,null));
var state_40263__$1 = state_40263;
var statearr_40290_40314 = state_40263__$1;
(statearr_40290_40314[(2)] = inst_40229);

(statearr_40290_40314[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40264 === (8))){
var _ = (function (){var statearr_40291 = state_40263;
(statearr_40291[(4)] = cljs.core.rest.call(null,(state_40263[(4)])));

return statearr_40291;
})();
var state_40263__$1 = state_40263;
var ex40288 = (state_40263__$1[(2)]);
var statearr_40292_40315 = state_40263__$1;
(statearr_40292_40315[(5)] = ex40288);


var statearr_40293_40316 = state_40263__$1;
(statearr_40293_40316[(1)] = (7));

(statearr_40293_40316[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10945__auto____0 = (function (){
var statearr_40294 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40294[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10945__auto__);

(statearr_40294[(1)] = (1));

return statearr_40294;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10945__auto____1 = (function (state_40263){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_40263);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e40295){var ex__10948__auto__ = e40295;
var statearr_40296_40317 = state_40263;
(statearr_40296_40317[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_40263[(4)]))){
var statearr_40297_40318 = state_40263;
(statearr_40297_40318[(1)] = cljs.core.first.call(null,(state_40263[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40319 = state_40263;
state_40263 = G__40319;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10945__auto__ = function(state_40263){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10945__auto____1.call(this,state_40263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_40298 = f__11019__auto__.call(null);
(statearr_40298[(6)] = c__11018__auto__);

return statearr_40298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_40371){
var state_val_40372 = (state_40371[(1)]);
if((state_val_40372 === (7))){
var inst_40321 = (state_40371[(2)]);
var state_40371__$1 = state_40371;
var statearr_40373_40402 = state_40371__$1;
(statearr_40373_40402[(2)] = inst_40321);

(statearr_40373_40402[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40372 === (1))){
var state_40371__$1 = state_40371;
var statearr_40374_40403 = state_40371__$1;
(statearr_40374_40403[(2)] = null);

(statearr_40374_40403[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40372 === (4))){
var inst_40320 = (state_40371[(2)]);
var state_40371__$1 = (function (){var statearr_40375 = state_40371;
(statearr_40375[(7)] = inst_40320);

return statearr_40375;
})();
var statearr_40376_40404 = state_40371__$1;
(statearr_40376_40404[(2)] = null);

(statearr_40376_40404[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40372 === (13))){
var inst_40366 = (state_40371[(2)]);
var _ = (function (){var statearr_40377 = state_40371;
(statearr_40377[(4)] = cljs.core.rest.call(null,(state_40371[(4)])));

return statearr_40377;
})();
var state_40371__$1 = state_40371;
var statearr_40378_40405 = state_40371__$1;
(statearr_40378_40405[(2)] = inst_40366);

(statearr_40378_40405[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40372 === (6))){
var inst_40330 = (state_40371[(2)]);
var state_40371__$1 = state_40371;
var statearr_40379_40406 = state_40371__$1;
(statearr_40379_40406[(2)] = inst_40330);

(statearr_40379_40406[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40372 === (3))){
var inst_40369 = (state_40371[(2)]);
var state_40371__$1 = state_40371;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40371__$1,inst_40369);
} else {
if((state_val_40372 === (12))){
var inst_40353 = (state_40371[(8)]);
var inst_40362 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40363 = [null,inst_40353];
var inst_40364 = (new cljs.core.PersistentVector(null,2,(5),inst_40362,inst_40363,null));
var state_40371__$1 = state_40371;
var statearr_40380_40407 = state_40371__$1;
(statearr_40380_40407[(2)] = inst_40364);

(statearr_40380_40407[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40372 === (2))){
var _ = (function (){var statearr_40382 = state_40371;
(statearr_40382[(4)] = cljs.core.cons.call(null,(9),(state_40371[(4)])));

return statearr_40382;
})();
var inst_40339 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_40340 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40341 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40342 = [null,pred_name,"?o"];
var inst_40343 = (new cljs.core.PersistentVector(null,3,(5),inst_40341,inst_40342,null));
var inst_40344 = [inst_40343];
var inst_40345 = (new cljs.core.PersistentVector(null,1,(5),inst_40340,inst_40344,null));
var inst_40346 = ["?o",inst_40345,opts];
var inst_40347 = cljs.core.PersistentHashMap.fromArrays(inst_40339,inst_40346);
var inst_40348 = fluree.db.dbfunctions.internal.query.call(null,db,inst_40347);
var state_40371__$1 = state_40371;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40371__$1,(10),inst_40348);
} else {
if((state_val_40372 === (11))){
var inst_40353 = (state_40371[(8)]);
var inst_40352 = (state_40371[(9)]);
var inst_40357 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40358 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_40352);
var inst_40359 = [inst_40358,inst_40353];
var inst_40360 = (new cljs.core.PersistentVector(null,2,(5),inst_40357,inst_40359,null));
var state_40371__$1 = state_40371;
var statearr_40383_40408 = state_40371__$1;
(statearr_40383_40408[(2)] = inst_40360);

(statearr_40383_40408[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40372 === (9))){
var _ = (function (){var statearr_40384 = state_40371;
(statearr_40384[(4)] = cljs.core.rest.call(null,(state_40371[(4)])));

return statearr_40384;
})();
var state_40371__$1 = state_40371;
var ex40381 = (state_40371__$1[(2)]);
var statearr_40385_40409 = state_40371__$1;
(statearr_40385_40409[(5)] = ex40381);


var statearr_40386_40410 = state_40371__$1;
(statearr_40386_40410[(1)] = (4));

(statearr_40386_40410[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40372 === (5))){
var inst_40320 = (state_40371[(7)]);
var _ = (function (){var statearr_40388 = state_40371;
(statearr_40388[(4)] = cljs.core.cons.call(null,(8),(state_40371[(4)])));

return statearr_40388;
})();
var inst_40327 = fluree.db.dbfunctions.internal.function_error.call(null,inst_40320,"max-pred-val",pred_name);
var ___$1 = (function (){var statearr_40389 = state_40371;
(statearr_40389[(4)] = cljs.core.rest.call(null,(state_40371[(4)])));

return statearr_40389;
})();
var state_40371__$1 = state_40371;
var statearr_40390_40411 = state_40371__$1;
(statearr_40390_40411[(2)] = inst_40327);

(statearr_40390_40411[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40372 === (10))){
var inst_40352 = (state_40371[(9)]);
var inst_40350 = (state_40371[(2)]);
var inst_40351 = fluree.db.util.async.throw_err.call(null,inst_40350);
var inst_40352__$1 = cljs.core.nth.call(null,inst_40351,(0),null);
var inst_40353 = cljs.core.nth.call(null,inst_40351,(1),null);
var inst_40354 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_40352__$1);
var inst_40355 = cljs.core.not.call(null,inst_40354);
var state_40371__$1 = (function (){var statearr_40391 = state_40371;
(statearr_40391[(8)] = inst_40353);

(statearr_40391[(9)] = inst_40352__$1);

return statearr_40391;
})();
if(inst_40355){
var statearr_40392_40412 = state_40371__$1;
(statearr_40392_40412[(1)] = (11));

} else {
var statearr_40393_40413 = state_40371__$1;
(statearr_40393_40413[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40372 === (8))){
var _ = (function (){var statearr_40394 = state_40371;
(statearr_40394[(4)] = cljs.core.rest.call(null,(state_40371[(4)])));

return statearr_40394;
})();
var state_40371__$1 = state_40371;
var ex40387 = (state_40371__$1[(2)]);
var statearr_40395_40414 = state_40371__$1;
(statearr_40395_40414[(5)] = ex40387);


var statearr_40396_40415 = state_40371__$1;
(statearr_40396_40415[(1)] = (7));

(statearr_40396_40415[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10945__auto____0 = (function (){
var statearr_40397 = [null,null,null,null,null,null,null,null,null,null];
(statearr_40397[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10945__auto__);

(statearr_40397[(1)] = (1));

return statearr_40397;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10945__auto____1 = (function (state_40371){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_40371);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e40398){var ex__10948__auto__ = e40398;
var statearr_40399_40416 = state_40371;
(statearr_40399_40416[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_40371[(4)]))){
var statearr_40400_40417 = state_40371;
(statearr_40400_40417[(1)] = cljs.core.first.call(null,(state_40371[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40418 = state_40371;
state_40371 = G__40418;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10945__auto__ = function(state_40371){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10945__auto____1.call(this,state_40371);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_40401 = f__11019__auto__.call(null);
(statearr_40401[(6)] = c__11018__auto__);

return statearr_40401;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$.call(null,(function (){var and__5043__auto__ = typeof email === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,pattern,email);
} else {
return and__5043__auto__;
}
})());
}catch (e40419){var e = e40419;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"valid-email?",email);
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__40421 = arguments.length;
switch (G__40421) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_40491){
var state_val_40492 = (state_40491[(1)]);
if((state_val_40492 === (7))){
var inst_40423 = (state_40491[(2)]);
var state_40491__$1 = state_40491;
var statearr_40493_40537 = state_40491__$1;
(statearr_40493_40537[(2)] = inst_40423);

(statearr_40493_40537[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (20))){
var inst_40467 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40468 = ["*"];
var inst_40469 = (new cljs.core.PersistentVector(null,1,(5),inst_40467,inst_40468,null));
var state_40491__$1 = state_40491;
var statearr_40494_40538 = state_40491__$1;
(statearr_40494_40538[(2)] = inst_40469);

(statearr_40494_40538[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (1))){
var state_40491__$1 = state_40491;
var statearr_40495_40539 = state_40491__$1;
(statearr_40495_40539[(2)] = null);

(statearr_40495_40539[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (4))){
var inst_40422 = (state_40491[(2)]);
var state_40491__$1 = (function (){var statearr_40496 = state_40491;
(statearr_40496[(7)] = inst_40422);

return statearr_40496;
})();
var statearr_40497_40540 = state_40491__$1;
(statearr_40497_40540[(2)] = null);

(statearr_40497_40540[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (15))){
var inst_40486 = (state_40491[(2)]);
var _ = (function (){var statearr_40498 = state_40491;
(statearr_40498[(4)] = cljs.core.rest.call(null,(state_40491[(4)])));

return statearr_40498;
})();
var state_40491__$1 = state_40491;
var statearr_40499_40541 = state_40491__$1;
(statearr_40499_40541[(2)] = inst_40486);

(statearr_40499_40541[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (21))){
var inst_40457 = (state_40491[(8)]);
var inst_40450 = (state_40491[(9)]);
var inst_40471 = (state_40491[(2)]);
var inst_40472 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_40473 = cljs.core.PersistentHashMap.EMPTY;
var inst_40474 = [inst_40471,inst_40457,inst_40473];
var inst_40475 = cljs.core.PersistentHashMap.fromArrays(inst_40472,inst_40474);
var inst_40476 = fluree.db.dbfunctions.internal.query.call(null,inst_40450,inst_40475);
var state_40491__$1 = state_40491;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40491__$1,(22),inst_40476);
} else {
if((state_val_40492 === (13))){
var inst_40445 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_40491__$1 = state_40491;
var statearr_40500_40542 = state_40491__$1;
(statearr_40500_40542[(2)] = inst_40445);

(statearr_40500_40542[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (22))){
var inst_40478 = (state_40491[(2)]);
var inst_40479 = fluree.db.util.async.throw_err.call(null,inst_40478);
var inst_40480 = cljs.core.nth.call(null,inst_40479,(0),null);
var inst_40481 = cljs.core.nth.call(null,inst_40479,(1),null);
var inst_40482 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40483 = [inst_40480,inst_40481];
var inst_40484 = (new cljs.core.PersistentVector(null,2,(5),inst_40482,inst_40483,null));
var state_40491__$1 = state_40491;
var statearr_40501_40543 = state_40491__$1;
(statearr_40501_40543[(2)] = inst_40484);

(statearr_40501_40543[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (6))){
var inst_40432 = (state_40491[(2)]);
var state_40491__$1 = state_40491;
var statearr_40502_40544 = state_40491__$1;
(statearr_40502_40544[(2)] = inst_40432);

(statearr_40502_40544[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (17))){
var inst_40454 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40455 = fluree.db.dbfunctions.internal.get.call(null,inst_40454,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_40491__$1 = state_40491;
var statearr_40503_40545 = state_40491__$1;
(statearr_40503_40545[(2)] = inst_40455);

(statearr_40503_40545[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (3))){
var inst_40489 = (state_40491[(2)]);
var state_40491__$1 = state_40491;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40491__$1,inst_40489);
} else {
if((state_val_40492 === (12))){
var inst_40443 = (state_40491[(2)]);
var state_40491__$1 = state_40491;
if(cljs.core.truth_(inst_40443)){
var statearr_40504_40546 = state_40491__$1;
(statearr_40504_40546[(1)] = (13));

} else {
var statearr_40505_40547 = state_40491__$1;
(statearr_40505_40547[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (2))){
var inst_40438 = (state_40491[(10)]);
var _ = (function (){var statearr_40506 = state_40491;
(statearr_40506[(4)] = cljs.core.cons.call(null,(9),(state_40491[(4)])));

return statearr_40506;
})();
var inst_40438__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_40491__$1 = (function (){var statearr_40507 = state_40491;
(statearr_40507[(10)] = inst_40438__$1);

return statearr_40507;
})();
if(cljs.core.truth_(inst_40438__$1)){
var statearr_40508_40548 = state_40491__$1;
(statearr_40508_40548[(1)] = (10));

} else {
var statearr_40509_40549 = state_40491__$1;
(statearr_40509_40549[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (19))){
var inst_40459 = cljs.core.PersistentVector.EMPTY;
var inst_40460 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40461 = ["*"];
var inst_40462 = (new cljs.core.PersistentVector(null,1,(5),inst_40460,inst_40461,null));
var inst_40463 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_40464 = cljs.core.concat.call(null,inst_40462,inst_40463);
var inst_40465 = cljs.core.into.call(null,inst_40459,inst_40464);
var state_40491__$1 = state_40491;
var statearr_40511_40550 = state_40491__$1;
(statearr_40511_40550[(2)] = inst_40465);

(statearr_40511_40550[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (11))){
var inst_40438 = (state_40491[(10)]);
var state_40491__$1 = state_40491;
var statearr_40512_40551 = state_40491__$1;
(statearr_40512_40551[(2)] = inst_40438);

(statearr_40512_40551[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (9))){
var _ = (function (){var statearr_40513 = state_40491;
(statearr_40513[(4)] = cljs.core.rest.call(null,(state_40491[(4)])));

return statearr_40513;
})();
var state_40491__$1 = state_40491;
var ex40510 = (state_40491__$1[(2)]);
var statearr_40514_40552 = state_40491__$1;
(statearr_40514_40552[(5)] = ex40510);


var statearr_40515_40553 = state_40491__$1;
(statearr_40515_40553[(1)] = (4));

(statearr_40515_40553[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (5))){
var inst_40422 = (state_40491[(7)]);
var _ = (function (){var statearr_40516 = state_40491;
(statearr_40516[(4)] = cljs.core.cons.call(null,(8),(state_40491[(4)])));

return statearr_40516;
})();
var inst_40429 = fluree.db.dbfunctions.internal.function_error.call(null,inst_40422,"?s","Context Object",additional_params);
var ___$1 = (function (){var statearr_40517 = state_40491;
(statearr_40517[(4)] = cljs.core.rest.call(null,(state_40491[(4)])));

return statearr_40517;
})();
var state_40491__$1 = state_40491;
var statearr_40518_40554 = state_40491__$1;
(statearr_40518_40554[(2)] = inst_40429);

(statearr_40518_40554[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (14))){
var inst_40451 = (state_40491[(11)]);
var inst_40450 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40451__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_40491__$1 = (function (){var statearr_40519 = state_40491;
(statearr_40519[(11)] = inst_40451__$1);

(statearr_40519[(9)] = inst_40450);

return statearr_40519;
})();
if(cljs.core.truth_(inst_40451__$1)){
var statearr_40520_40555 = state_40491__$1;
(statearr_40520_40555[(1)] = (16));

} else {
var statearr_40521_40556 = state_40491__$1;
(statearr_40521_40556[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (16))){
var inst_40451 = (state_40491[(11)]);
var state_40491__$1 = state_40491;
var statearr_40522_40557 = state_40491__$1;
(statearr_40522_40557[(2)] = inst_40451);

(statearr_40522_40557[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (10))){
var inst_40440 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,additional_params);
var state_40491__$1 = state_40491;
var statearr_40524_40558 = state_40491__$1;
(statearr_40524_40558[(2)] = inst_40440);

(statearr_40524_40558[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (18))){
var inst_40457 = (state_40491[(2)]);
var state_40491__$1 = (function (){var statearr_40525 = state_40491;
(statearr_40525[(8)] = inst_40457);

return statearr_40525;
})();
if(cljs.core.truth_(additional_params)){
var statearr_40526_40559 = state_40491__$1;
(statearr_40526_40559[(1)] = (19));

} else {
var statearr_40527_40560 = state_40491__$1;
(statearr_40527_40560[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (8))){
var _ = (function (){var statearr_40528 = state_40491;
(statearr_40528[(4)] = cljs.core.rest.call(null,(state_40491[(4)])));

return statearr_40528;
})();
var state_40491__$1 = state_40491;
var ex40523 = (state_40491__$1[(2)]);
var statearr_40529_40561 = state_40491__$1;
(statearr_40529_40561[(5)] = ex40523);


var statearr_40530_40562 = state_40491__$1;
(statearr_40530_40562[(1)] = (7));

(statearr_40530_40562[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__10945__auto____0 = (function (){
var statearr_40531 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40531[(0)] = fluree$db$dbfunctions$internal$state_machine__10945__auto__);

(statearr_40531[(1)] = (1));

return statearr_40531;
});
var fluree$db$dbfunctions$internal$state_machine__10945__auto____1 = (function (state_40491){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_40491);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e40532){var ex__10948__auto__ = e40532;
var statearr_40533_40563 = state_40491;
(statearr_40533_40563[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_40491[(4)]))){
var statearr_40534_40564 = state_40491;
(statearr_40534_40564[(1)] = cljs.core.first.call(null,(state_40491[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40565 = state_40491;
state_40491 = G__40565;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__10945__auto__ = function(state_40491){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__10945__auto____1.call(this,state_40491);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__10945__auto____0;
fluree$db$dbfunctions$internal$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__10945__auto____1;
return fluree$db$dbfunctions$internal$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_40535 = f__11019__auto__.call(null);
(statearr_40535[(6)] = c__11018__auto__);

return statearr_40535;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__40567 = arguments.length;
switch (G__40567) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_40611){
var state_val_40612 = (state_40611[(1)]);
if((state_val_40612 === (7))){
var inst_40589 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40590 = ["*"];
var inst_40591 = (new cljs.core.PersistentVector(null,1,(5),inst_40589,inst_40590,null));
var state_40611__$1 = state_40611;
var statearr_40613_40633 = state_40611__$1;
(statearr_40613_40633[(2)] = inst_40591);

(statearr_40613_40633[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40612 === (1))){
var state_40611__$1 = state_40611;
var statearr_40614_40634 = state_40611__$1;
(statearr_40614_40634[(2)] = null);

(statearr_40614_40634[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40612 === (4))){
var inst_40568 = (state_40611[(2)]);
var inst_40569 = fluree.db.dbfunctions.internal.function_error.call(null,inst_40568,"?p","Context Object",additional_params);
var state_40611__$1 = state_40611;
var statearr_40615_40635 = state_40611__$1;
(statearr_40615_40635[(2)] = inst_40569);

(statearr_40615_40635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40612 === (6))){
var inst_40581 = cljs.core.PersistentVector.EMPTY;
var inst_40582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40583 = ["*"];
var inst_40584 = (new cljs.core.PersistentVector(null,1,(5),inst_40582,inst_40583,null));
var inst_40585 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_40586 = cljs.core.concat.call(null,inst_40584,inst_40585);
var inst_40587 = cljs.core.into.call(null,inst_40581,inst_40586);
var state_40611__$1 = state_40611;
var statearr_40616_40636 = state_40611__$1;
(statearr_40616_40636[(2)] = inst_40587);

(statearr_40616_40636[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40612 === (3))){
var inst_40609 = (state_40611[(2)]);
var state_40611__$1 = state_40611;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40611__$1,inst_40609);
} else {
if((state_val_40612 === (2))){
var _ = (function (){var statearr_40618 = state_40611;
(statearr_40618[(4)] = cljs.core.cons.call(null,(5),(state_40611[(4)])));

return statearr_40618;
})();
var inst_40578 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40579 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_40611__$1 = (function (){var statearr_40619 = state_40611;
(statearr_40619[(7)] = inst_40578);

(statearr_40619[(8)] = inst_40579);

return statearr_40619;
})();
if(cljs.core.truth_(additional_params)){
var statearr_40620_40637 = state_40611__$1;
(statearr_40620_40637[(1)] = (6));

} else {
var statearr_40621_40638 = state_40611__$1;
(statearr_40621_40638[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40612 === (9))){
var inst_40600 = (state_40611[(2)]);
var inst_40601 = fluree.db.util.async.throw_err.call(null,inst_40600);
var inst_40602 = cljs.core.nth.call(null,inst_40601,(0),null);
var inst_40603 = cljs.core.nth.call(null,inst_40601,(1),null);
var inst_40604 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40605 = [inst_40602,inst_40603];
var inst_40606 = (new cljs.core.PersistentVector(null,2,(5),inst_40604,inst_40605,null));
var _ = (function (){var statearr_40622 = state_40611;
(statearr_40622[(4)] = cljs.core.rest.call(null,(state_40611[(4)])));

return statearr_40622;
})();
var state_40611__$1 = state_40611;
var statearr_40623_40639 = state_40611__$1;
(statearr_40623_40639[(2)] = inst_40606);

(statearr_40623_40639[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40612 === (5))){
var _ = (function (){var statearr_40624 = state_40611;
(statearr_40624[(4)] = cljs.core.rest.call(null,(state_40611[(4)])));

return statearr_40624;
})();
var state_40611__$1 = state_40611;
var ex40617 = (state_40611__$1[(2)]);
var statearr_40625_40640 = state_40611__$1;
(statearr_40625_40640[(5)] = ex40617);


var statearr_40626_40641 = state_40611__$1;
(statearr_40626_40641[(1)] = (4));

(statearr_40626_40641[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40612 === (8))){
var inst_40578 = (state_40611[(7)]);
var inst_40579 = (state_40611[(8)]);
var inst_40593 = (state_40611[(2)]);
var inst_40594 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_40595 = cljs.core.PersistentHashMap.EMPTY;
var inst_40596 = [inst_40593,inst_40579,inst_40595];
var inst_40597 = cljs.core.PersistentHashMap.fromArrays(inst_40594,inst_40596);
var inst_40598 = fluree.db.dbfunctions.internal.query.call(null,inst_40578,inst_40597);
var state_40611__$1 = state_40611;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40611__$1,(9),inst_40598);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__10945__auto____0 = (function (){
var statearr_40627 = [null,null,null,null,null,null,null,null,null];
(statearr_40627[(0)] = fluree$db$dbfunctions$internal$state_machine__10945__auto__);

(statearr_40627[(1)] = (1));

return statearr_40627;
});
var fluree$db$dbfunctions$internal$state_machine__10945__auto____1 = (function (state_40611){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_40611);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e40628){var ex__10948__auto__ = e40628;
var statearr_40629_40642 = state_40611;
(statearr_40629_40642[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_40611[(4)]))){
var statearr_40630_40643 = state_40611;
(statearr_40630_40643[(1)] = cljs.core.first.call(null,(state_40611[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40644 = state_40611;
state_40611 = G__40644;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__10945__auto__ = function(state_40611){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__10945__auto____1.call(this,state_40611);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__10945__auto____0;
fluree$db$dbfunctions$internal$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__10945__auto____1;
return fluree$db$dbfunctions$internal$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_40631 = f__11019__auto__.call(null);
(statearr_40631[(6)] = c__11018__auto__);

return statearr_40631;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_40688){
var state_val_40689 = (state_40688[(1)]);
if((state_val_40689 === (1))){
var state_40688__$1 = state_40688;
var statearr_40690_40704 = state_40688__$1;
(statearr_40690_40704[(2)] = null);

(statearr_40690_40704[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40689 === (2))){
var _ = (function (){var statearr_40691 = state_40688;
(statearr_40691[(4)] = cljs.core.cons.call(null,(5),(state_40688[(4)])));

return statearr_40691;
})();
var inst_40655 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_40656 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40657 = ["_user/_auth"];
var inst_40658 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40659 = ["*"];
var inst_40660 = (new cljs.core.PersistentVector(null,1,(5),inst_40658,inst_40659,null));
var inst_40661 = [inst_40660];
var inst_40662 = cljs.core.PersistentHashMap.fromArrays(inst_40657,inst_40661);
var inst_40663 = [inst_40662];
var inst_40664 = (new cljs.core.PersistentVector(null,1,(5),inst_40656,inst_40663,null));
var inst_40665 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40666 = cljs.core.PersistentHashMap.EMPTY;
var inst_40667 = [inst_40664,inst_40665,inst_40666];
var inst_40668 = cljs.core.PersistentHashMap.fromArrays(inst_40655,inst_40667);
var inst_40669 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40670 = fluree.db.dbfunctions.internal.query.call(null,inst_40669,inst_40668);
var state_40688__$1 = state_40688;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40688__$1,(6),inst_40670);
} else {
if((state_val_40689 === (3))){
var inst_40686 = (state_40688[(2)]);
var state_40688__$1 = state_40688;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40688__$1,inst_40686);
} else {
if((state_val_40689 === (4))){
var inst_40645 = (state_40688[(2)]);
var inst_40646 = fluree.db.dbfunctions.internal.function_error.call(null,inst_40645,"?user_id-from-auth","Context Object");
var state_40688__$1 = state_40688;
var statearr_40693_40705 = state_40688__$1;
(statearr_40693_40705[(2)] = inst_40646);

(statearr_40693_40705[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40689 === (5))){
var _ = (function (){var statearr_40694 = state_40688;
(statearr_40694[(4)] = cljs.core.rest.call(null,(state_40688[(4)])));

return statearr_40694;
})();
var state_40688__$1 = state_40688;
var ex40692 = (state_40688__$1[(2)]);
var statearr_40695_40706 = state_40688__$1;
(statearr_40695_40706[(5)] = ex40692);


var statearr_40696_40707 = state_40688__$1;
(statearr_40696_40707[(1)] = (4));

(statearr_40696_40707[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40689 === (6))){
var inst_40672 = (state_40688[(2)]);
var inst_40673 = fluree.db.util.async.throw_err.call(null,inst_40672);
var inst_40674 = cljs.core.nth.call(null,inst_40673,(0),null);
var inst_40675 = cljs.core.nth.call(null,inst_40673,(1),null);
var inst_40676 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40677 = ["_user/_auth","_id"];
var inst_40678 = (new cljs.core.PersistentVector(null,2,(5),inst_40676,inst_40677,null));
var inst_40679 = fluree.db.dbfunctions.internal.get_in.call(null,inst_40674,inst_40678);
var inst_40680 = cljs.core.first.call(null,inst_40679);
var inst_40681 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40682 = [inst_40680,inst_40675];
var inst_40683 = (new cljs.core.PersistentVector(null,2,(5),inst_40681,inst_40682,null));
var _ = (function (){var statearr_40697 = state_40688;
(statearr_40697[(4)] = cljs.core.rest.call(null,(state_40688[(4)])));

return statearr_40697;
})();
var state_40688__$1 = state_40688;
var statearr_40698_40708 = state_40688__$1;
(statearr_40698_40708[(2)] = inst_40683);

(statearr_40698_40708[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10945__auto____0 = (function (){
var statearr_40699 = [null,null,null,null,null,null,null];
(statearr_40699[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10945__auto__);

(statearr_40699[(1)] = (1));

return statearr_40699;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10945__auto____1 = (function (state_40688){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_40688);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e40700){var ex__10948__auto__ = e40700;
var statearr_40701_40709 = state_40688;
(statearr_40701_40709[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_40688[(4)]))){
var statearr_40702_40710 = state_40688;
(statearr_40702_40710[(1)] = cljs.core.first.call(null,(state_40688[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40711 = state_40688;
state_40688 = G__40711;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10945__auto__ = function(state_40688){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10945__auto____1.call(this,state_40688);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_40703 = f__11019__auto__.call(null);
(statearr_40703[(6)] = c__11018__auto__);

return statearr_40703;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_40728){
var state_val_40729 = (state_40728[(1)]);
if((state_val_40729 === (1))){
var state_40728__$1 = state_40728;
var statearr_40730_40744 = state_40728__$1;
(statearr_40730_40744[(2)] = null);

(statearr_40730_40744[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40729 === (2))){
var _ = (function (){var statearr_40731 = state_40728;
(statearr_40731[(4)] = cljs.core.cons.call(null,(5),(state_40728[(4)])));

return statearr_40731;
})();
var inst_40718 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40719 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40720 = fluree.db.dbproto._subid.call(null,inst_40719,inst_40718);
var state_40728__$1 = state_40728;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40728__$1,(6),inst_40720);
} else {
if((state_val_40729 === (3))){
var inst_40726 = (state_40728[(2)]);
var state_40728__$1 = state_40728;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40728__$1,inst_40726);
} else {
if((state_val_40729 === (4))){
var inst_40712 = (state_40728[(2)]);
var state_40728__$1 = state_40728;
var statearr_40733_40745 = state_40728__$1;
(statearr_40733_40745[(2)] = inst_40712);

(statearr_40733_40745[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40729 === (5))){
var _ = (function (){var statearr_40734 = state_40728;
(statearr_40734[(4)] = cljs.core.rest.call(null,(state_40728[(4)])));

return statearr_40734;
})();
var state_40728__$1 = state_40728;
var ex40732 = (state_40728__$1[(2)]);
var statearr_40735_40746 = state_40728__$1;
(statearr_40735_40746[(5)] = ex40732);


if((ex40732 instanceof Error)){
var statearr_40736_40747 = state_40728__$1;
(statearr_40736_40747[(1)] = (4));

(statearr_40736_40747[(5)] = null);

} else {
throw ex40732;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40729 === (6))){
var inst_40722 = (state_40728[(2)]);
var inst_40723 = fluree.db.util.async.throw_err.call(null,inst_40722);
var _ = (function (){var statearr_40737 = state_40728;
(statearr_40737[(4)] = cljs.core.rest.call(null,(state_40728[(4)])));

return statearr_40737;
})();
var state_40728__$1 = state_40728;
var statearr_40738_40748 = state_40728__$1;
(statearr_40738_40748[(2)] = inst_40723);

(statearr_40738_40748[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10945__auto____0 = (function (){
var statearr_40739 = [null,null,null,null,null,null,null];
(statearr_40739[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10945__auto__);

(statearr_40739[(1)] = (1));

return statearr_40739;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10945__auto____1 = (function (state_40728){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_40728);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e40740){var ex__10948__auto__ = e40740;
var statearr_40741_40749 = state_40728;
(statearr_40741_40749[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_40728[(4)]))){
var statearr_40742_40750 = state_40728;
(statearr_40742_40750[(1)] = cljs.core.first.call(null,(state_40728[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40751 = state_40728;
state_40728 = G__40751;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10945__auto__ = function(state_40728){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10945__auto____1.call(this,state_40728);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_40743 = f__11019__auto__.call(null);
(statearr_40743[(6)] = c__11018__auto__);

return statearr_40743;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv.call(null,(function (p1__40752_SHARP_){
return p1__40752_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__40753_SHARP_){
return p1__40753_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e40754){var e = e40754;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objT",flakes);
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv.call(null,(function (p1__40755_SHARP_){
return p1__40755_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__40756_SHARP_){
return p1__40756_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e40757){var e = e40757;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objF",flakes);
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = (Math.floor(fluree.db.dbfunctions.internal._STAR_.call(null,base,max_SINGLEQUOTE_)) | (0));
return num;
}catch (e40758){var e = e40758;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rand",instant,max_SINGLEQUOTE_);
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_40838){
var state_val_40839 = (state_40838[(1)]);
if((state_val_40839 === (7))){
var inst_40777 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val);
var inst_40778 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_40779 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_40780 = cljs.core.PersistentHashMap.fromArrays(inst_40778,inst_40779);
var inst_40781 = cljs.core.ex_info.call(null,inst_40777,inst_40780);
var inst_40782 = (function(){throw inst_40781})();
var state_40838__$1 = state_40838;
var statearr_40840_40875 = state_40838__$1;
(statearr_40840_40875[(2)] = inst_40782);

(statearr_40840_40875[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40839 === (1))){
var state_40838__$1 = state_40838;
var statearr_40841_40876 = state_40838__$1;
(statearr_40841_40876[(2)] = null);

(statearr_40841_40876[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40839 === (4))){
var inst_40759 = (state_40838[(2)]);
var state_40838__$1 = state_40838;
var statearr_40842_40877 = state_40838__$1;
(statearr_40842_40877[(2)] = inst_40759);

(statearr_40842_40877[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40839 === (15))){
var inst_40822 = (state_40838[(7)]);
var inst_40818 = (state_40838[(2)]);
var inst_40819 = fluree.db.util.async.throw_err.call(null,inst_40818);
var inst_40820 = cljs.core.nth.call(null,inst_40819,(0),null);
var inst_40821 = cljs.core.nth.call(null,inst_40819,(1),null);
var inst_40822__$1 = cljs.core.first.call(null,inst_40820);
var inst_40823 = cljs.core._EQ_.call(null,inst_40822__$1,compare_val);
var state_40838__$1 = (function (){var statearr_40843 = state_40838;
(statearr_40843[(8)] = inst_40821);

(statearr_40843[(7)] = inst_40822__$1);

return statearr_40843;
})();
if(inst_40823){
var statearr_40844_40878 = state_40838__$1;
(statearr_40844_40878[(1)] = (16));

} else {
var statearr_40845_40879 = state_40838__$1;
(statearr_40845_40879[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40839 === (13))){
var state_40838__$1 = state_40838;
var statearr_40846_40880 = state_40838__$1;
(statearr_40846_40880[(2)] = null);

(statearr_40846_40880[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40839 === (6))){
var state_40838__$1 = state_40838;
var statearr_40847_40881 = state_40838__$1;
(statearr_40847_40881[(2)] = null);

(statearr_40847_40881[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40839 === (17))){
var inst_40822 = (state_40838[(7)]);
var inst_40826 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40822)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_40827 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_40828 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_40829 = cljs.core.PersistentHashMap.fromArrays(inst_40827,inst_40828);
var inst_40830 = cljs.core.ex_info.call(null,inst_40826,inst_40829);
var inst_40831 = (function(){throw inst_40830})();
var state_40838__$1 = state_40838;
var statearr_40848_40882 = state_40838__$1;
(statearr_40848_40882[(2)] = inst_40831);

(statearr_40848_40882[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40839 === (3))){
var inst_40836 = (state_40838[(2)]);
var state_40838__$1 = state_40838;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40838__$1,inst_40836);
} else {
if((state_val_40839 === (12))){
var inst_40774 = (state_40838[(9)]);
var inst_40797 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas on a multi-cardinality predicate: ",inst_40774);
var inst_40798 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_40799 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_40800 = cljs.core.PersistentHashMap.fromArrays(inst_40798,inst_40799);
var inst_40801 = cljs.core.ex_info.call(null,inst_40797,inst_40800);
var inst_40802 = (function(){throw inst_40801})();
var state_40838__$1 = state_40838;
var statearr_40849_40883 = state_40838__$1;
(statearr_40849_40883[(2)] = inst_40802);

(statearr_40849_40883[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40839 === (2))){
var inst_40773 = (state_40838[(10)]);
var inst_40771 = (state_40838[(11)]);
var inst_40772 = (state_40838[(12)]);
var _ = (function (){var statearr_40850 = state_40838;
(statearr_40850[(4)] = cljs.core.cons.call(null,(5),(state_40838[(4)])));

return statearr_40850;
})();
var inst_40769 = _QMARK_ctx;
var inst_40770 = cljs.core.__destructure_map.call(null,inst_40769);
var inst_40771__$1 = cljs.core.get.call(null,inst_40770,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_40772__$1 = cljs.core.get.call(null,inst_40770,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_40773__$1 = cljs.core.get.call(null,inst_40770,new cljs.core.Keyword(null,"db","db",993250759));
var inst_40774 = fluree.db.dbproto._p_prop.call(null,inst_40773__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_40772__$1);
var state_40838__$1 = (function (){var statearr_40851 = state_40838;
(statearr_40851[(10)] = inst_40773__$1);

(statearr_40851[(9)] = inst_40774);

(statearr_40851[(11)] = inst_40771__$1);

(statearr_40851[(12)] = inst_40772__$1);

return statearr_40851;
})();
if(cljs.core.truth_(inst_40771__$1)){
var statearr_40852_40884 = state_40838__$1;
(statearr_40852_40884[(1)] = (6));

} else {
var statearr_40853_40885 = state_40838__$1;
(statearr_40853_40885[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40839 === (11))){
var inst_40773 = (state_40838[(10)]);
var inst_40772 = (state_40838[(12)]);
var inst_40794 = (state_40838[(2)]);
var inst_40795 = fluree.db.dbproto._p_prop.call(null,inst_40773,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_40772);
var state_40838__$1 = (function (){var statearr_40855 = state_40838;
(statearr_40855[(13)] = inst_40794);

return statearr_40855;
})();
if(cljs.core.truth_(inst_40795)){
var statearr_40856_40886 = state_40838__$1;
(statearr_40856_40886[(1)] = (12));

} else {
var statearr_40857_40887 = state_40838__$1;
(statearr_40857_40887[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40839 === (9))){
var state_40838__$1 = state_40838;
var statearr_40858_40888 = state_40838__$1;
(statearr_40858_40888[(2)] = null);

(statearr_40858_40888[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40839 === (5))){
var _ = (function (){var statearr_40859 = state_40838;
(statearr_40859[(4)] = cljs.core.rest.call(null,(state_40838[(4)])));

return statearr_40859;
})();
var state_40838__$1 = state_40838;
var ex40854 = (state_40838__$1[(2)]);
var statearr_40860_40889 = state_40838__$1;
(statearr_40860_40889[(5)] = ex40854);


if((ex40854 instanceof Error)){
var statearr_40861_40890 = state_40838__$1;
(statearr_40861_40890[(1)] = (4));

(statearr_40861_40890[(5)] = null);

} else {
throw ex40854;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40839 === (14))){
var inst_40773 = (state_40838[(10)]);
var inst_40774 = (state_40838[(9)]);
var inst_40771 = (state_40838[(11)]);
var inst_40805 = (state_40838[(2)]);
var inst_40806 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_40807 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40809 = [inst_40771,inst_40774,"?current-val"];
var inst_40810 = (new cljs.core.PersistentVector(null,3,(5),inst_40808,inst_40809,null));
var inst_40811 = [inst_40810];
var inst_40812 = (new cljs.core.PersistentVector(null,1,(5),inst_40807,inst_40811,null));
var inst_40813 = cljs.core.PersistentHashMap.EMPTY;
var inst_40814 = ["?current-val",inst_40812,inst_40813];
var inst_40815 = cljs.core.PersistentHashMap.fromArrays(inst_40806,inst_40814);
var inst_40816 = fluree.db.dbfunctions.internal.query.call(null,inst_40773,inst_40815);
var state_40838__$1 = (function (){var statearr_40862 = state_40838;
(statearr_40862[(14)] = inst_40805);

return statearr_40862;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40838__$1,(15),inst_40816);
} else {
if((state_val_40839 === (16))){
var state_40838__$1 = state_40838;
var statearr_40863_40891 = state_40838__$1;
(statearr_40863_40891[(2)] = new_val);

(statearr_40863_40891[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40839 === (10))){
var inst_40787 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val);
var inst_40788 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_40789 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_40790 = cljs.core.PersistentHashMap.fromArrays(inst_40788,inst_40789);
var inst_40791 = cljs.core.ex_info.call(null,inst_40787,inst_40790);
var inst_40792 = (function(){throw inst_40791})();
var state_40838__$1 = state_40838;
var statearr_40864_40892 = state_40838__$1;
(statearr_40864_40892[(2)] = inst_40792);

(statearr_40864_40892[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40839 === (18))){
var inst_40833 = (state_40838[(2)]);
var _ = (function (){var statearr_40865 = state_40838;
(statearr_40865[(4)] = cljs.core.rest.call(null,(state_40838[(4)])));

return statearr_40865;
})();
var state_40838__$1 = state_40838;
var statearr_40866_40893 = state_40838__$1;
(statearr_40866_40893[(2)] = inst_40833);

(statearr_40866_40893[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40839 === (8))){
var inst_40774 = (state_40838[(9)]);
var inst_40784 = (state_40838[(2)]);
var state_40838__$1 = (function (){var statearr_40867 = state_40838;
(statearr_40867[(15)] = inst_40784);

return statearr_40867;
})();
if(cljs.core.truth_(inst_40774)){
var statearr_40868_40894 = state_40838__$1;
(statearr_40868_40894[(1)] = (9));

} else {
var statearr_40869_40895 = state_40838__$1;
(statearr_40869_40895[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__10945__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__10945__auto____0 = (function (){
var statearr_40870 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40870[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__10945__auto__);

(statearr_40870[(1)] = (1));

return statearr_40870;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__10945__auto____1 = (function (state_40838){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_40838);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e40871){var ex__10948__auto__ = e40871;
var statearr_40872_40896 = state_40838;
(statearr_40872_40896[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_40838[(4)]))){
var statearr_40873_40897 = state_40838;
(statearr_40873_40897[(1)] = cljs.core.first.call(null,(state_40838[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40898 = state_40838;
state_40838 = G__40898;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__10945__auto__ = function(state_40838){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__10945__auto____1.call(this,state_40838);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__10945__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__10945__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_40874 = f__11019__auto__.call(null);
(statearr_40874[(6)] = c__11018__auto__);

return statearr_40874;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
