// Compiled by ClojureScript 1.11.57 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.call(null,["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__37469 = cljs.core.re_find.call(null,/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str.call(null,ledger));
var _ = cljs.core.nth.call(null,vec__37469,(0),null);
var network = cljs.core.nth.call(null,vec__37469,(1),null);
var maybe_alias = cljs.core.nth.call(null,vec__37469,(2),null);
if(cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__37472){
var map__37473 = p__37472;
var map__37473__$1 = cljs.core.__destructure_map.call(null,map__37473);
var opts = map__37473__$1;
var reindex_QMARK_ = cljs.core.get.call(null,map__37473__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_37533){
var state_val_37534 = (state_37533[(1)]);
if((state_val_37534 === (7))){
var inst_37504 = cljs.core.not.call(null,reindex_QMARK_);
var state_37533__$1 = state_37533;
var statearr_37535_37559 = state_37533__$1;
(statearr_37535_37559[(2)] = inst_37504);

(statearr_37535_37559[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37534 === (1))){
var state_37533__$1 = state_37533;
var statearr_37536_37560 = state_37533__$1;
(statearr_37536_37560[(2)] = null);

(statearr_37536_37560[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37534 === (4))){
var inst_37474 = (state_37533[(2)]);
var state_37533__$1 = state_37533;
var statearr_37537_37561 = state_37533__$1;
(statearr_37537_37561[(2)] = inst_37474);

(statearr_37537_37561[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37534 === (6))){
var inst_37488 = (state_37533[(7)]);
var inst_37502 = (state_37533[(8)]);
var inst_37494 = (state_37533[(9)]);
var inst_37487 = (state_37533[(2)]);
var inst_37488__$1 = fluree.db.util.async.throw_err.call(null,inst_37487);
var inst_37489 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_37490 = cljs.core.__destructure_map.call(null,inst_37489);
var inst_37491 = cljs.core.get.call(null,inst_37490,new cljs.core.Keyword(null,"post","post",269697687));
var inst_37492 = cljs.core.get.call(null,inst_37490,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_37493 = fluree.db.flake.size_bytes.call(null,inst_37488__$1);
var inst_37494__$1 = (inst_37492 + inst_37493);
var inst_37495 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37496 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_37497 = (new cljs.core.PersistentVector(null,2,(5),inst_37495,inst_37496,null));
var inst_37498 = cljs.core.get_in.call(null,db,inst_37497);
var inst_37499 = cljs.core.__destructure_map.call(null,inst_37498);
var inst_37500 = cljs.core.get.call(null,inst_37499,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_37501 = cljs.core.get.call(null,inst_37499,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_37502__$1 = (inst_37494__$1 > inst_37501);
var state_37533__$1 = (function (){var statearr_37538 = state_37533;
(statearr_37538[(10)] = inst_37500);

(statearr_37538[(7)] = inst_37488__$1);

(statearr_37538[(8)] = inst_37502__$1);

(statearr_37538[(11)] = inst_37491);

(statearr_37538[(9)] = inst_37494__$1);

return statearr_37538;
})();
if(cljs.core.truth_(inst_37502__$1)){
var statearr_37539_37562 = state_37533__$1;
(statearr_37539_37562[(1)] = (7));

} else {
var statearr_37540_37563 = state_37533__$1;
(statearr_37540_37563[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37534 === (3))){
var inst_37531 = (state_37533[(2)]);
var state_37533__$1 = state_37533;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37533__$1,inst_37531);
} else {
if((state_val_37534 === (12))){
var inst_37488 = (state_37533[(7)]);
var inst_37491 = (state_37533[(11)]);
var inst_37494 = (state_37533[(9)]);
var inst_37517 = (state_37533[(2)]);
var inst_37518 = cljs.core.into.call(null,inst_37491,inst_37488);
var inst_37519 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_37520 = cljs.core.swap_BANG_.call(null,inst_37519,cljs.core.empty);
var inst_37521 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37522 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_37523 = (new cljs.core.PersistentVector(null,2,(5),inst_37521,inst_37522,null));
var inst_37524 = cljs.core.assoc_in.call(null,db,inst_37523,inst_37518);
var inst_37525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37526 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_37527 = (new cljs.core.PersistentVector(null,2,(5),inst_37525,inst_37526,null));
var inst_37528 = cljs.core.assoc_in.call(null,inst_37524,inst_37527,inst_37494);
var _ = (function (){var statearr_37541 = state_37533;
(statearr_37541[(4)] = cljs.core.rest.call(null,(state_37533[(4)])));

return statearr_37541;
})();
var state_37533__$1 = (function (){var statearr_37542 = state_37533;
(statearr_37542[(12)] = inst_37520);

(statearr_37542[(13)] = inst_37517);

return statearr_37542;
})();
var statearr_37543_37564 = state_37533__$1;
(statearr_37543_37564[(2)] = inst_37528);

(statearr_37543_37564[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37534 === (2))){
var _ = (function (){var statearr_37544 = state_37533;
(statearr_37544[(4)] = cljs.core.cons.call(null,(5),(state_37533[(4)])));

return statearr_37544;
})();
var inst_37482 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37483 = [pred_id];
var inst_37484 = (new cljs.core.PersistentVector(null,1,(5),inst_37482,inst_37483,null));
var inst_37485 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_37484);
var state_37533__$1 = state_37533;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37533__$1,(6),inst_37485);
} else {
if((state_val_37534 === (11))){
var state_37533__$1 = state_37533;
var statearr_37546_37565 = state_37533__$1;
(statearr_37546_37565[(2)] = null);

(statearr_37546_37565[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37534 === (9))){
var inst_37507 = (state_37533[(2)]);
var state_37533__$1 = state_37533;
if(cljs.core.truth_(inst_37507)){
var statearr_37547_37566 = state_37533__$1;
(statearr_37547_37566[(1)] = (10));

} else {
var statearr_37548_37567 = state_37533__$1;
(statearr_37548_37567[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37534 === (5))){
var _ = (function (){var statearr_37549 = state_37533;
(statearr_37549[(4)] = cljs.core.rest.call(null,(state_37533[(4)])));

return statearr_37549;
})();
var state_37533__$1 = state_37533;
var ex37545 = (state_37533__$1[(2)]);
var statearr_37550_37568 = state_37533__$1;
(statearr_37550_37568[(5)] = ex37545);


if((ex37545 instanceof Error)){
var statearr_37551_37569 = state_37533__$1;
(statearr_37551_37569[(1)] = (4));

(statearr_37551_37569[(5)] = null);

} else {
throw ex37545;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37534 === (10))){
var inst_37509 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_37510 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_37511 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_37512 = cljs.core.PersistentHashMap.fromArrays(inst_37510,inst_37511);
var inst_37513 = cljs.core.ex_info.call(null,inst_37509,inst_37512);
var inst_37514 = (function(){throw inst_37513})();
var state_37533__$1 = state_37533;
var statearr_37552_37570 = state_37533__$1;
(statearr_37552_37570[(2)] = inst_37514);

(statearr_37552_37570[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37534 === (8))){
var inst_37502 = (state_37533[(8)]);
var state_37533__$1 = state_37533;
var statearr_37553_37571 = state_37533__$1;
(statearr_37553_37571[(2)] = inst_37502);

(statearr_37553_37571[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10945__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10945__auto____0 = (function (){
var statearr_37554 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37554[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10945__auto__);

(statearr_37554[(1)] = (1));

return statearr_37554;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10945__auto____1 = (function (state_37533){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_37533);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e37555){var ex__10948__auto__ = e37555;
var statearr_37556_37572 = state_37533;
(statearr_37556_37572[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_37533[(4)]))){
var statearr_37557_37573 = state_37533;
(statearr_37557_37573[(1)] = cljs.core.first.call(null,(state_37533[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37574 = state_37533;
state_37533 = G__37574;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10945__auto__ = function(state_37533){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10945__auto____1.call(this,state_37533);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10945__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10945__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_37558 = f__11019__auto__.call(null);
(statearr_37558[(6)] = c__11018__auto__);

return statearr_37558;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__37579 = arguments.length;
switch (G__37579) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.call(null,db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_37775){
var state_val_37776 = (state_37775[(1)]);
if((state_val_37776 === (7))){
var state_37775__$1 = state_37775;
var statearr_37777_37844 = state_37775__$1;
(statearr_37777_37844[(2)] = null);

(statearr_37777_37844[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (20))){
var inst_37618 = (state_37775[(7)]);
var inst_37699 = (state_37775[(8)]);
var inst_37701 = (state_37775[(9)]);
var inst_37617 = (state_37775[(10)]);
var inst_37668 = (state_37775[(11)]);
var inst_37698 = (state_37775[(12)]);
var inst_37700 = (state_37775[(13)]);
var inst_37697 = (state_37775[(14)]);
var inst_37711 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_37712 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37713 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_37714 = (new cljs.core.PersistentVector(null,2,(5),inst_37712,inst_37713,null));
var inst_37715 = cljs.core.get_in.call(null,inst_37668,inst_37714);
var inst_37716 = (inst_37617 + inst_37715);
var inst_37717 = [inst_37697,inst_37698,inst_37699,inst_37700,inst_37716];
var inst_37718 = cljs.core.PersistentHashMap.fromArrays(inst_37711,inst_37717);
var inst_37719 = cljs.core.assoc.call(null,inst_37668,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_37701,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_37718);
var state_37775__$1 = (function (){var statearr_37778 = state_37775;
(statearr_37778[(15)] = inst_37719);

return statearr_37778;
})();
if(cljs.core.truth_(inst_37618)){
var statearr_37779_37845 = state_37775__$1;
(statearr_37779_37845[(1)] = (23));

} else {
var statearr_37780_37846 = state_37775__$1;
(statearr_37780_37846[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (27))){
var inst_37719 = (state_37775[(15)]);
var state_37775__$1 = state_37775;
var statearr_37781_37847 = state_37775__$1;
(statearr_37781_37847[(2)] = inst_37719);

(statearr_37781_37847[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (1))){
var state_37775__$1 = state_37775;
var statearr_37782_37848 = state_37775__$1;
(statearr_37782_37848[(2)] = null);

(statearr_37782_37848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (24))){
var inst_37719 = (state_37775[(15)]);
var inst_37722 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_37719);
var inst_37723 = (inst_37722 == null);
var state_37775__$1 = state_37775;
var statearr_37783_37849 = state_37775__$1;
(statearr_37783_37849[(2)] = inst_37723);

(statearr_37783_37849[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (39))){
var inst_37758 = (state_37775[(16)]);
var inst_37750 = (state_37775[(17)]);
var inst_37708 = (state_37775[(18)]);
var inst_37751 = (state_37775[(19)]);
var inst_37749 = (state_37775[(20)]);
var inst_37765 = (state_37775[(2)]);
var inst_37696 = inst_37708;
var inst_37697 = inst_37750;
var inst_37698 = inst_37751;
var inst_37699 = inst_37758;
var inst_37700 = inst_37765;
var inst_37701 = inst_37749;
var state_37775__$1 = (function (){var statearr_37784 = state_37775;
(statearr_37784[(21)] = inst_37696);

(statearr_37784[(8)] = inst_37699);

(statearr_37784[(9)] = inst_37701);

(statearr_37784[(12)] = inst_37698);

(statearr_37784[(13)] = inst_37700);

(statearr_37784[(14)] = inst_37697);

return statearr_37784;
})();
var statearr_37785_37850 = state_37775__$1;
(statearr_37785_37850[(2)] = null);

(statearr_37785_37850[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (4))){
var inst_37580 = (state_37775[(2)]);
var state_37775__$1 = state_37775;
var statearr_37786_37851 = state_37775__$1;
(statearr_37786_37851[(2)] = inst_37580);

(statearr_37786_37851[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (15))){
var inst_37640 = (state_37775[(22)]);
var state_37775__$1 = state_37775;
var statearr_37787_37852 = state_37775__$1;
(statearr_37787_37852[(2)] = inst_37640);

(statearr_37787_37852[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (21))){
var inst_37696 = (state_37775[(21)]);
var inst_37587 = (state_37775[(23)]);
var inst_37608 = (state_37775[(24)]);
var inst_37618 = (state_37775[(7)]);
var inst_37708 = (state_37775[(18)]);
var inst_37678 = (state_37775[(25)]);
var inst_37621 = (state_37775[(26)]);
var inst_37602 = (state_37775[(27)]);
var inst_37612 = (state_37775[(28)]);
var inst_37699 = (state_37775[(8)]);
var inst_37701 = (state_37775[(9)]);
var inst_37627 = (state_37775[(29)]);
var inst_37617 = (state_37775[(10)]);
var inst_37619 = (state_37775[(30)]);
var inst_37707 = (state_37775[(31)]);
var inst_37616 = (state_37775[(32)]);
var inst_37604 = (state_37775[(33)]);
var inst_37668 = (state_37775[(11)]);
var inst_37698 = (state_37775[(12)]);
var inst_37700 = (state_37775[(13)]);
var inst_37677 = (state_37775[(34)]);
var inst_37697 = (state_37775[(14)]);
var inst_37746 = inst_37707.s;
var inst_37747 = fluree.db.flake.sid__GT_cid.call(null,inst_37746);
var inst_37748 = (function (){var flakes_bytes = inst_37617;
var t = inst_37587;
var vec__37673 = inst_37604;
var spot = inst_37697;
var add_flakes = inst_37604;
var root_setting_change_QMARK_ = inst_37619;
var first__37705 = inst_37707;
var ref_QMARK__map = inst_37616;
var r = inst_37708;
var psot = inst_37698;
var vec__37703 = inst_37696;
var add_pred_to_idx_QMARK_ = inst_37627;
var _ = inst_37602;
var cid = inst_37747;
var ecount = inst_37701;
var pred_ecount = inst_37621;
var seq__37674 = inst_37678;
var db_STAR_ = inst_37668;
var schema_change_QMARK_ = inst_37618;
var seq__37704 = inst_37708;
var add_preds = inst_37608;
var G__37672 = inst_37696;
var opst = inst_37700;
var first__37675 = inst_37677;
var idx_QMARK__map = inst_37612;
var post = inst_37699;
var f = inst_37707;
return (function (p1__37577_SHARP_){
if(cljs.core.truth_(p1__37577_SHARP_)){
var x__5130__auto__ = p1__37577_SHARP_;
var y__5131__auto__ = f.s;
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
} else {
return f.s;
}
});
})();
var inst_37749 = cljs.core.update.call(null,inst_37701,inst_37747,inst_37748);
var inst_37750 = cljs.core.conj.call(null,inst_37697,inst_37707);
var inst_37751 = cljs.core.conj.call(null,inst_37698,inst_37707);
var inst_37752 = inst_37707.p;
var inst_37753 = cljs.core.get.call(null,inst_37612,inst_37752);
var state_37775__$1 = (function (){var statearr_37788 = state_37775;
(statearr_37788[(17)] = inst_37750);

(statearr_37788[(19)] = inst_37751);

(statearr_37788[(20)] = inst_37749);

return statearr_37788;
})();
if(cljs.core.truth_(inst_37753)){
var statearr_37789_37853 = state_37775__$1;
(statearr_37789_37853[(1)] = (34));

} else {
var statearr_37790_37854 = state_37775__$1;
(statearr_37790_37854[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (31))){
var inst_37734 = (state_37775[(35)]);
var state_37775__$1 = state_37775;
var statearr_37791_37855 = state_37775__$1;
(statearr_37791_37855[(2)] = inst_37734);

(statearr_37791_37855[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (32))){
var inst_37744 = (state_37775[(2)]);
var state_37775__$1 = state_37775;
var statearr_37792_37856 = state_37775__$1;
(statearr_37792_37856[(2)] = inst_37744);

(statearr_37792_37856[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (33))){
var inst_37734 = (state_37775[(35)]);
var inst_37739 = (state_37775[(2)]);
var inst_37740 = fluree.db.util.async.throw_err.call(null,inst_37739);
var inst_37741 = cljs.core.assoc.call(null,inst_37734,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_37740);
var state_37775__$1 = state_37775;
var statearr_37793_37857 = state_37775__$1;
(statearr_37793_37857[(2)] = inst_37741);

(statearr_37793_37857[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (13))){
var inst_37587 = (state_37775[(23)]);
var inst_37617 = (state_37775[(10)]);
var inst_37604 = (state_37775[(33)]);
var inst_37668 = (state_37775[(11)]);
var inst_37658 = (state_37775[(2)]);
var inst_37659 = cljs.core.assoc.call(null,inst_37658,new cljs.core.Keyword(null,"t","t",-1397832519),inst_37587);
var inst_37660 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37661 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_37662 = (new cljs.core.PersistentVector(null,2,(5),inst_37660,inst_37661,null));
var inst_37663 = cljs.core.update_in.call(null,inst_37659,inst_37662,cljs.core._PLUS_,inst_37617);
var inst_37664 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37665 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_37666 = (new cljs.core.PersistentVector(null,2,(5),inst_37664,inst_37665,null));
var inst_37667 = cljs.core.count.call(null,inst_37604);
var inst_37668__$1 = cljs.core.update_in.call(null,inst_37663,inst_37666,cljs.core._PLUS_,inst_37667);
var inst_37676 = cljs.core.seq.call(null,inst_37604);
var inst_37677 = cljs.core.first.call(null,inst_37676);
var inst_37678 = cljs.core.next.call(null,inst_37676);
var inst_37679 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37680 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_37681 = (new cljs.core.PersistentVector(null,2,(5),inst_37679,inst_37680,null));
var inst_37682 = cljs.core.get_in.call(null,inst_37668__$1,inst_37681);
var inst_37683 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37684 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_37685 = (new cljs.core.PersistentVector(null,2,(5),inst_37683,inst_37684,null));
var inst_37686 = cljs.core.get_in.call(null,inst_37668__$1,inst_37685);
var inst_37687 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37688 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_37689 = (new cljs.core.PersistentVector(null,2,(5),inst_37687,inst_37688,null));
var inst_37690 = cljs.core.get_in.call(null,inst_37668__$1,inst_37689);
var inst_37691 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37692 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_37693 = (new cljs.core.PersistentVector(null,2,(5),inst_37691,inst_37692,null));
var inst_37694 = cljs.core.get_in.call(null,inst_37668__$1,inst_37693);
var inst_37695 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_37696 = inst_37604;
var inst_37697 = inst_37682;
var inst_37698 = inst_37686;
var inst_37699 = inst_37690;
var inst_37700 = inst_37694;
var inst_37701 = inst_37695;
var state_37775__$1 = (function (){var statearr_37794 = state_37775;
(statearr_37794[(21)] = inst_37696);

(statearr_37794[(25)] = inst_37678);

(statearr_37794[(8)] = inst_37699);

(statearr_37794[(9)] = inst_37701);

(statearr_37794[(11)] = inst_37668__$1);

(statearr_37794[(12)] = inst_37698);

(statearr_37794[(13)] = inst_37700);

(statearr_37794[(34)] = inst_37677);

(statearr_37794[(14)] = inst_37697);

return statearr_37794;
})();
var statearr_37795_37858 = state_37775__$1;
(statearr_37795_37858[(2)] = null);

(statearr_37795_37858[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (22))){
var inst_37768 = (state_37775[(2)]);
var state_37775__$1 = state_37775;
var statearr_37796_37859 = state_37775__$1;
(statearr_37796_37859[(2)] = inst_37768);

(statearr_37796_37859[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (36))){
var inst_37707 = (state_37775[(31)]);
var inst_37616 = (state_37775[(32)]);
var inst_37758 = (state_37775[(2)]);
var inst_37759 = inst_37707.p;
var inst_37760 = cljs.core.get.call(null,inst_37616,inst_37759);
var state_37775__$1 = (function (){var statearr_37797 = state_37775;
(statearr_37797[(16)] = inst_37758);

return statearr_37797;
})();
if(cljs.core.truth_(inst_37760)){
var statearr_37798_37860 = state_37775__$1;
(statearr_37798_37860[(1)] = (37));

} else {
var statearr_37799_37861 = state_37775__$1;
(statearr_37799_37861[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (29))){
var inst_37719 = (state_37775[(15)]);
var inst_37729 = (state_37775[(2)]);
var inst_37730 = fluree.db.util.async.throw_err.call(null,inst_37729);
var inst_37731 = cljs.core.assoc.call(null,inst_37719,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_37730);
var state_37775__$1 = state_37775;
var statearr_37800_37862 = state_37775__$1;
(statearr_37800_37862[(2)] = inst_37731);

(statearr_37800_37862[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (6))){
var inst_37587 = (state_37775[(23)]);
var inst_37592 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_37593 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_37594 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37592)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37593)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37587),"."].join('');
var inst_37595 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37596 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_37597 = cljs.core.PersistentHashMap.fromArrays(inst_37595,inst_37596);
var inst_37598 = cljs.core.ex_info.call(null,inst_37594,inst_37597);
var inst_37599 = (function(){throw inst_37598})();
var state_37775__$1 = state_37775;
var statearr_37801_37863 = state_37775__$1;
(statearr_37801_37863[(2)] = inst_37599);

(statearr_37801_37863[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (28))){
var inst_37619 = (state_37775[(30)]);
var inst_37734 = (state_37775[(2)]);
var state_37775__$1 = (function (){var statearr_37802 = state_37775;
(statearr_37802[(35)] = inst_37734);

return statearr_37802;
})();
if(cljs.core.truth_(inst_37619)){
var statearr_37803_37864 = state_37775__$1;
(statearr_37803_37864[(1)] = (30));

} else {
var statearr_37804_37865 = state_37775__$1;
(statearr_37804_37865[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (25))){
var inst_37725 = (state_37775[(2)]);
var state_37775__$1 = state_37775;
if(cljs.core.truth_(inst_37725)){
var statearr_37805_37866 = state_37775__$1;
(statearr_37805_37866[(1)] = (26));

} else {
var statearr_37806_37867 = state_37775__$1;
(statearr_37806_37867[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (34))){
var inst_37699 = (state_37775[(8)]);
var inst_37707 = (state_37775[(31)]);
var inst_37755 = cljs.core.conj.call(null,inst_37699,inst_37707);
var state_37775__$1 = state_37775;
var statearr_37807_37868 = state_37775__$1;
(statearr_37807_37868[(2)] = inst_37755);

(statearr_37807_37868[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (17))){
var inst_37647 = (state_37775[(36)]);
var inst_37651 = (state_37775[(2)]);
var inst_37652 = fluree.db.util.async.throw_err.call(null,inst_37651);
var inst_37639 = inst_37647;
var inst_37640 = inst_37652;
var state_37775__$1 = (function (){var statearr_37808 = state_37775;
(statearr_37808[(37)] = inst_37639);

(statearr_37808[(22)] = inst_37640);

return statearr_37808;
})();
var statearr_37809_37869 = state_37775__$1;
(statearr_37809_37869[(2)] = null);

(statearr_37809_37869[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (3))){
var inst_37773 = (state_37775[(2)]);
var state_37775__$1 = state_37775;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37775__$1,inst_37773);
} else {
if((state_val_37776 === (12))){
var inst_37646 = (state_37775[(38)]);
var inst_37639 = (state_37775[(37)]);
var inst_37645 = cljs.core.seq.call(null,inst_37639);
var inst_37646__$1 = cljs.core.first.call(null,inst_37645);
var inst_37647 = cljs.core.next.call(null,inst_37645);
var state_37775__$1 = (function (){var statearr_37810 = state_37775;
(statearr_37810[(38)] = inst_37646__$1);

(statearr_37810[(36)] = inst_37647);

return statearr_37810;
})();
if(cljs.core.truth_(inst_37646__$1)){
var statearr_37811_37870 = state_37775__$1;
(statearr_37811_37870[(1)] = (14));

} else {
var statearr_37812_37871 = state_37775__$1;
(statearr_37812_37871[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (2))){
var inst_37587 = (state_37775[(23)]);
var _ = (function (){var statearr_37813 = state_37775;
(statearr_37813[(4)] = cljs.core.cons.call(null,(5),(state_37775[(4)])));

return statearr_37813;
})();
var inst_37586 = cljs.core.first.call(null,flakes);
var inst_37587__$1 = inst_37586.t;
var inst_37588 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_37589 = (inst_37588 - (1));
var inst_37590 = cljs.core.not_EQ_.call(null,inst_37587__$1,inst_37589);
var state_37775__$1 = (function (){var statearr_37814 = state_37775;
(statearr_37814[(23)] = inst_37587__$1);

return statearr_37814;
})();
if(inst_37590){
var statearr_37815_37872 = state_37775__$1;
(statearr_37815_37872[(1)] = (6));

} else {
var statearr_37816_37873 = state_37775__$1;
(statearr_37816_37873[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (23))){
var inst_37618 = (state_37775[(7)]);
var state_37775__$1 = state_37775;
var statearr_37817_37874 = state_37775__$1;
(statearr_37817_37874[(2)] = inst_37618);

(statearr_37817_37874[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (35))){
var inst_37699 = (state_37775[(8)]);
var state_37775__$1 = state_37775;
var statearr_37818_37875 = state_37775__$1;
(statearr_37818_37875[(2)] = inst_37699);

(statearr_37818_37875[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (19))){
var inst_37770 = (state_37775[(2)]);
var _ = (function (){var statearr_37819 = state_37775;
(statearr_37819[(4)] = cljs.core.rest.call(null,(state_37775[(4)])));

return statearr_37819;
})();
var state_37775__$1 = state_37775;
var statearr_37820_37876 = state_37775__$1;
(statearr_37820_37876[(2)] = inst_37770);

(statearr_37820_37876[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (11))){
var inst_37627 = (state_37775[(29)]);
var inst_37627__$1 = (state_37775[(2)]);
var inst_37635 = cljs.core.seq.call(null,inst_37627__$1);
var inst_37636 = cljs.core.first.call(null,inst_37635);
var inst_37637 = cljs.core.next.call(null,inst_37635);
var inst_37638 = db;
var inst_37639 = inst_37627__$1;
var inst_37640 = inst_37638;
var state_37775__$1 = (function (){var statearr_37822 = state_37775;
(statearr_37822[(29)] = inst_37627__$1);

(statearr_37822[(39)] = inst_37637);

(statearr_37822[(37)] = inst_37639);

(statearr_37822[(40)] = inst_37636);

(statearr_37822[(22)] = inst_37640);

return statearr_37822;
})();
var statearr_37823_37877 = state_37775__$1;
(statearr_37823_37877[(2)] = null);

(statearr_37823_37877[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (9))){
var inst_37621 = (state_37775[(26)]);
var inst_37604 = (state_37775[(33)]);
var inst_37623 = fluree.db.util.schema.add_to_post_preds_QMARK_.call(null,inst_37604,inst_37621);
var state_37775__$1 = state_37775;
var statearr_37824_37878 = state_37775__$1;
(statearr_37824_37878[(2)] = inst_37623);

(statearr_37824_37878[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (5))){
var _ = (function (){var statearr_37825 = state_37775;
(statearr_37825[(4)] = cljs.core.rest.call(null,(state_37775[(4)])));

return statearr_37825;
})();
var state_37775__$1 = state_37775;
var ex37821 = (state_37775__$1[(2)]);
var statearr_37826_37879 = state_37775__$1;
(statearr_37826_37879[(5)] = ex37821);


if((ex37821 instanceof Error)){
var statearr_37827_37880 = state_37775__$1;
(statearr_37827_37880[(1)] = (4));

(statearr_37827_37880[(5)] = null);

} else {
throw ex37821;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (14))){
var inst_37646 = (state_37775[(38)]);
var inst_37640 = (state_37775[(22)]);
var inst_37649 = fluree.db.graphdb.add_predicate_to_idx.call(null,inst_37640,inst_37646,opts);
var state_37775__$1 = state_37775;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37775__$1,(17),inst_37649);
} else {
if((state_val_37776 === (26))){
var inst_37719 = (state_37775[(15)]);
var inst_37727 = fluree.db.query.schema.schema_map.call(null,inst_37719);
var state_37775__$1 = state_37775;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37775__$1,(29),inst_37727);
} else {
if((state_val_37776 === (16))){
var inst_37656 = (state_37775[(2)]);
var state_37775__$1 = state_37775;
var statearr_37828_37881 = state_37775__$1;
(statearr_37828_37881[(2)] = inst_37656);

(statearr_37828_37881[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (38))){
var inst_37700 = (state_37775[(13)]);
var state_37775__$1 = state_37775;
var statearr_37829_37882 = state_37775__$1;
(statearr_37829_37882[(2)] = inst_37700);

(statearr_37829_37882[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (30))){
var inst_37734 = (state_37775[(35)]);
var inst_37737 = fluree.db.query.schema.setting_map.call(null,inst_37734);
var state_37775__$1 = state_37775;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37775__$1,(33),inst_37737);
} else {
if((state_val_37776 === (10))){
var inst_37625 = cljs.core.PersistentVector.EMPTY;
var state_37775__$1 = state_37775;
var statearr_37830_37883 = state_37775__$1;
(statearr_37830_37883[(2)] = inst_37625);

(statearr_37830_37883[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (18))){
var inst_37696 = (state_37775[(21)]);
var inst_37707 = (state_37775[(31)]);
var inst_37706 = cljs.core.seq.call(null,inst_37696);
var inst_37707__$1 = cljs.core.first.call(null,inst_37706);
var inst_37708 = cljs.core.next.call(null,inst_37706);
var inst_37709 = cljs.core.not.call(null,inst_37707__$1);
var state_37775__$1 = (function (){var statearr_37831 = state_37775;
(statearr_37831[(18)] = inst_37708);

(statearr_37831[(31)] = inst_37707__$1);

return statearr_37831;
})();
if(inst_37709){
var statearr_37832_37884 = state_37775__$1;
(statearr_37832_37884[(1)] = (20));

} else {
var statearr_37833_37885 = state_37775__$1;
(statearr_37833_37885[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (37))){
var inst_37707 = (state_37775[(31)]);
var inst_37700 = (state_37775[(13)]);
var inst_37762 = cljs.core.conj.call(null,inst_37700,inst_37707);
var state_37775__$1 = state_37775;
var statearr_37834_37886 = state_37775__$1;
(statearr_37834_37886[(2)] = inst_37762);

(statearr_37834_37886[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37776 === (8))){
var inst_37587 = (state_37775[(23)]);
var inst_37608 = (state_37775[(24)]);
var inst_37618 = (state_37775[(7)]);
var inst_37602 = (state_37775[(27)]);
var inst_37612 = (state_37775[(28)]);
var inst_37604 = (state_37775[(33)]);
var inst_37602__$1 = (state_37775[(2)]);
var inst_37603 = (function (){var t = inst_37587;
var _ = inst_37602__$1;
return (function (p1__37575_SHARP_){
return cljs.core.not.call(null,fluree.db.graphdb.exclude_predicates.call(null,p1__37575_SHARP_.p));
});
})();
var inst_37604__$1 = cljs.core.filter.call(null,inst_37603,flakes);
var inst_37605 = cljs.core.PersistentHashSet.EMPTY;
var inst_37606 = (function (){var t = inst_37587;
var _ = inst_37602__$1;
var add_flakes = inst_37604__$1;
return (function (p1__37576_SHARP_){
return p1__37576_SHARP_.p;
});
})();
var inst_37607 = cljs.core.map.call(null,inst_37606,inst_37604__$1);
var inst_37608__$1 = cljs.core.into.call(null,inst_37605,inst_37607);
var inst_37609 = cljs.core.PersistentHashMap.EMPTY;
var inst_37610 = (function (){var t = inst_37587;
var _ = inst_37602__$1;
var add_flakes = inst_37604__$1;
var add_preds = inst_37608__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_37611 = cljs.core.map.call(null,inst_37610,inst_37608__$1);
var inst_37612__$1 = cljs.core.into.call(null,inst_37609,inst_37611);
var inst_37613 = cljs.core.PersistentHashMap.EMPTY;
var inst_37614 = (function (){var t = inst_37587;
var _ = inst_37602__$1;
var add_flakes = inst_37604__$1;
var add_preds = inst_37608__$1;
var idx_QMARK__map = inst_37612__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_37615 = cljs.core.map.call(null,inst_37614,inst_37608__$1);
var inst_37616 = cljs.core.into.call(null,inst_37613,inst_37615);
var inst_37617 = fluree.db.flake.size_bytes.call(null,inst_37604__$1);
var inst_37618__$1 = fluree.db.util.schema.schema_change_QMARK_.call(null,inst_37604__$1);
var inst_37619 = fluree.db.util.schema.setting_change_QMARK_.call(null,inst_37604__$1);
var inst_37620 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_37621 = cljs.core.get.call(null,inst_37620,(0));
var state_37775__$1 = (function (){var statearr_37835 = state_37775;
(statearr_37835[(24)] = inst_37608__$1);

(statearr_37835[(7)] = inst_37618__$1);

(statearr_37835[(26)] = inst_37621);

(statearr_37835[(27)] = inst_37602__$1);

(statearr_37835[(28)] = inst_37612__$1);

(statearr_37835[(10)] = inst_37617);

(statearr_37835[(30)] = inst_37619);

(statearr_37835[(32)] = inst_37616);

(statearr_37835[(33)] = inst_37604__$1);

return statearr_37835;
})();
if(cljs.core.truth_(inst_37618__$1)){
var statearr_37836_37887 = state_37775__$1;
(statearr_37836_37887[(1)] = (9));

} else {
var statearr_37837_37888 = state_37775__$1;
(statearr_37837_37888[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10945__auto__ = null;
var fluree$db$graphdb$state_machine__10945__auto____0 = (function (){
var statearr_37838 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37838[(0)] = fluree$db$graphdb$state_machine__10945__auto__);

(statearr_37838[(1)] = (1));

return statearr_37838;
});
var fluree$db$graphdb$state_machine__10945__auto____1 = (function (state_37775){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_37775);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e37839){var ex__10948__auto__ = e37839;
var statearr_37840_37889 = state_37775;
(statearr_37840_37889[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_37775[(4)]))){
var statearr_37841_37890 = state_37775;
(statearr_37841_37890[(1)] = cljs.core.first.call(null,(state_37775[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37891 = state_37775;
state_37775 = G__37891;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10945__auto__ = function(state_37775){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10945__auto____1.call(this,state_37775);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10945__auto____0;
fluree$db$graphdb$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10945__auto____1;
return fluree$db$graphdb$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_37842 = f__11019__auto__.call(null);
(statearr_37842[(6)] = c__11018__auto__);

return statearr_37842;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__37893 = arguments.length;
switch (G__37893) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.call(null,db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.call(null);
var c__11018__auto___38040 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_37989){
var state_val_37990 = (state_37989[(1)]);
if((state_val_37990 === (7))){
var state_37989__$1 = state_37989;
var statearr_37991_38041 = state_37989__$1;
(statearr_37991_38041[(2)] = null);

(statearr_37991_38041[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37990 === (20))){
var inst_37939 = (state_37989[(7)]);
var inst_37938 = (state_37989[(8)]);
var inst_37937 = (state_37989[(9)]);
var inst_37958 = (inst_37937 + (1));
var inst_37959 = cljs.core.assoc.call(null,inst_37939,new cljs.core.Keyword(null,"t","t",-1397832519),inst_37958);
var inst_37960 = fluree.db.graphdb.with_t.call(null,inst_37959,inst_37938,opts);
var state_37989__$1 = state_37989;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37989__$1,(23),inst_37960);
} else {
if((state_val_37990 === (1))){
var state_37989__$1 = state_37989;
var statearr_37992_38042 = state_37989__$1;
(statearr_37992_38042[(2)] = null);

(statearr_37992_38042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37990 === (24))){
var inst_37963 = (state_37989[(10)]);
var inst_37966 = cljs.core.assoc.call(null,inst_37963,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_37989__$1 = state_37989;
var statearr_37993_38043 = state_37989__$1;
(statearr_37993_38043[(2)] = inst_37966);

(statearr_37993_38043[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37990 === (4))){
var inst_37894 = (state_37989[(2)]);
var inst_37895 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_37894);
var state_37989__$1 = state_37989;
var statearr_37994_38044 = state_37989__$1;
(statearr_37994_38044[(2)] = inst_37895);

(statearr_37994_38044[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37990 === (15))){
var inst_37945 = (state_37989[(11)]);
var state_37989__$1 = state_37989;
var statearr_37995_38045 = state_37989__$1;
(statearr_37995_38045[(2)] = inst_37945);

(statearr_37995_38045[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37990 === (21))){
var state_37989__$1 = state_37989;
var statearr_37996_38046 = state_37989__$1;
(statearr_37996_38046[(2)] = null);

(statearr_37996_38046[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37990 === (13))){
var inst_37981 = (state_37989[(2)]);
var inst_37982 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_37981);
var state_37989__$1 = state_37989;
var statearr_37997_38047 = state_37989__$1;
(statearr_37997_38047[(2)] = inst_37982);

(statearr_37997_38047[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37990 === (22))){
var inst_37977 = (state_37989[(2)]);
var state_37989__$1 = state_37989;
var statearr_37998_38048 = state_37989__$1;
(statearr_37998_38048[(2)] = inst_37977);

(statearr_37998_38048[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37990 === (6))){
var inst_37905 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_37906 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_37907 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37905)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37906)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_37908 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37909 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_37910 = cljs.core.PersistentHashMap.fromArrays(inst_37908,inst_37909);
var inst_37911 = cljs.core.ex_info.call(null,inst_37907,inst_37910);
var inst_37912 = (function(){throw inst_37911})();
var state_37989__$1 = state_37989;
var statearr_38001_38049 = state_37989__$1;
(statearr_38001_38049[(2)] = inst_37912);

(statearr_38001_38049[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37990 === (25))){
var inst_37963 = (state_37989[(10)]);
var inst_37945 = (state_37989[(11)]);
var inst_37946 = (state_37989[(12)]);
var inst_37968 = inst_37945.t;
var inst_37969 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37970 = [inst_37945];
var inst_37971 = (new cljs.core.PersistentVector(null,1,(5),inst_37969,inst_37970,null));
var inst_37936 = inst_37946;
var inst_37937 = inst_37968;
var inst_37938 = inst_37971;
var inst_37939 = inst_37963;
var state_37989__$1 = (function (){var statearr_38002 = state_37989;
(statearr_38002[(13)] = inst_37936);

(statearr_38002[(7)] = inst_37939);

(statearr_38002[(8)] = inst_37938);

(statearr_38002[(9)] = inst_37937);

return statearr_38002;
})();
var statearr_38003_38050 = state_37989__$1;
(statearr_38003_38050[(2)] = null);

(statearr_38003_38050[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37990 === (17))){
var inst_37945 = (state_37989[(11)]);
var inst_37939 = (state_37989[(7)]);
var inst_37938 = (state_37989[(8)]);
var inst_37937 = (state_37989[(9)]);
var inst_37946 = (state_37989[(12)]);
var inst_37954 = cljs.core.conj.call(null,inst_37938,inst_37945);
var tmp37999 = inst_37939;
var tmp38000 = inst_37937;
var inst_37936 = inst_37946;
var inst_37937__$1 = tmp38000;
var inst_37938__$1 = inst_37954;
var inst_37939__$1 = tmp37999;
var state_37989__$1 = (function (){var statearr_38004 = state_37989;
(statearr_38004[(13)] = inst_37936);

(statearr_38004[(7)] = inst_37939__$1);

(statearr_38004[(8)] = inst_37938__$1);

(statearr_38004[(9)] = inst_37937__$1);

return statearr_38004;
})();
var statearr_38005_38051 = state_37989__$1;
(statearr_38005_38051[(2)] = null);

(statearr_38005_38051[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37990 === (3))){
var inst_37987 = (state_37989[(2)]);
var state_37989__$1 = state_37989;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37989__$1,inst_37987);
} else {
if((state_val_37990 === (12))){
var inst_37936 = (state_37989[(13)]);
var inst_37945 = (state_37989[(11)]);
var inst_37944 = cljs.core.seq.call(null,inst_37936);
var inst_37945__$1 = cljs.core.first.call(null,inst_37944);
var inst_37946 = cljs.core.next.call(null,inst_37944);
var state_37989__$1 = (function (){var statearr_38006 = state_37989;
(statearr_38006[(11)] = inst_37945__$1);

(statearr_38006[(12)] = inst_37946);

return statearr_38006;
})();
if(cljs.core.truth_(inst_37945__$1)){
var statearr_38007_38052 = state_37989__$1;
(statearr_38007_38052[(1)] = (14));

} else {
var statearr_38008_38053 = state_37989__$1;
(statearr_38008_38053[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37990 === (2))){
var _ = (function (){var statearr_38009 = state_37989;
(statearr_38009[(4)] = cljs.core.cons.call(null,(5),(state_37989[(4)])));

return statearr_38009;
})();
var inst_37901 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_37902 = (inst_37901 + (1));
var inst_37903 = cljs.core.not_EQ_.call(null,block,inst_37902);
var state_37989__$1 = state_37989;
if(inst_37903){
var statearr_38010_38054 = state_37989__$1;
(statearr_38010_38054[(1)] = (6));

} else {
var statearr_38011_38055 = state_37989__$1;
(statearr_38011_38055[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37990 === (23))){
var inst_37945 = (state_37989[(11)]);
var inst_37962 = (state_37989[(2)]);
var inst_37963 = fluree.db.util.async.throw_err.call(null,inst_37962);
var inst_37964 = (inst_37945 == null);
var state_37989__$1 = (function (){var statearr_38012 = state_37989;
(statearr_38012[(10)] = inst_37963);

return statearr_38012;
})();
if(cljs.core.truth_(inst_37964)){
var statearr_38013_38056 = state_37989__$1;
(statearr_38013_38056[(1)] = (24));

} else {
var statearr_38014_38057 = state_37989__$1;
(statearr_38014_38057[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37990 === (19))){
var inst_37979 = (state_37989[(2)]);
var state_37989__$1 = state_37989;
var statearr_38015_38058 = state_37989__$1;
(statearr_38015_38058[(2)] = inst_37979);

(statearr_38015_38058[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37990 === (11))){
var inst_37984 = (state_37989[(2)]);
var _ = (function (){var statearr_38017 = state_37989;
(statearr_38017[(4)] = cljs.core.rest.call(null,(state_37989[(4)])));

return statearr_38017;
})();
var state_37989__$1 = state_37989;
var statearr_38018_38059 = state_37989__$1;
(statearr_38018_38059[(2)] = inst_37984);

(statearr_38018_38059[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37990 === (9))){
var inst_37918 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_37919 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_37918);
var state_37989__$1 = state_37989;
var statearr_38019_38060 = state_37989__$1;
(statearr_38019_38060[(2)] = inst_37919);

(statearr_38019_38060[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37990 === (5))){
var _ = (function (){var statearr_38020 = state_37989;
(statearr_38020[(4)] = cljs.core.rest.call(null,(state_37989[(4)])));

return statearr_38020;
})();
var state_37989__$1 = state_37989;
var ex38016 = (state_37989__$1[(2)]);
var statearr_38021_38061 = state_37989__$1;
(statearr_38021_38061[(5)] = ex38016);


var statearr_38022_38062 = state_37989__$1;
(statearr_38022_38062[(1)] = (4));

(statearr_38022_38062[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37990 === (14))){
var inst_37945 = (state_37989[(11)]);
var inst_37937 = (state_37989[(9)]);
var inst_37948 = inst_37945.t;
var inst_37949 = cljs.core._EQ_.call(null,inst_37937,inst_37948);
var state_37989__$1 = state_37989;
var statearr_38023_38063 = state_37989__$1;
(statearr_38023_38063[(2)] = inst_37949);

(statearr_38023_38063[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37990 === (26))){
var inst_37974 = (state_37989[(2)]);
var state_37989__$1 = state_37989;
var statearr_38024_38064 = state_37989__$1;
(statearr_38024_38064[(2)] = inst_37974);

(statearr_38024_38064[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37990 === (16))){
var inst_37952 = (state_37989[(2)]);
var state_37989__$1 = state_37989;
if(cljs.core.truth_(inst_37952)){
var statearr_38025_38065 = state_37989__$1;
(statearr_38025_38065[(1)] = (17));

} else {
var statearr_38026_38066 = state_37989__$1;
(statearr_38026_38066[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37990 === (10))){
var inst_37921 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_block,flakes);
var inst_37922 = cljs.core.first.call(null,inst_37921);
var inst_37930 = cljs.core.seq.call(null,inst_37921);
var inst_37931 = cljs.core.first.call(null,inst_37930);
var inst_37932 = cljs.core.next.call(null,inst_37930);
var inst_37933 = inst_37922.t;
var inst_37934 = cljs.core.PersistentVector.EMPTY;
var inst_37935 = db;
var inst_37936 = inst_37921;
var inst_37937 = inst_37933;
var inst_37938 = inst_37934;
var inst_37939 = inst_37935;
var state_37989__$1 = (function (){var statearr_38027 = state_37989;
(statearr_38027[(14)] = inst_37931);

(statearr_38027[(13)] = inst_37936);

(statearr_38027[(7)] = inst_37939);

(statearr_38027[(8)] = inst_37938);

(statearr_38027[(9)] = inst_37937);

(statearr_38027[(15)] = inst_37932);

return statearr_38027;
})();
var statearr_38028_38067 = state_37989__$1;
(statearr_38028_38067[(2)] = null);

(statearr_38028_38067[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37990 === (18))){
var state_37989__$1 = state_37989;
var statearr_38029_38068 = state_37989__$1;
(statearr_38029_38068[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37990 === (8))){
var inst_37915 = (state_37989[(2)]);
var inst_37916 = cljs.core.empty_QMARK_.call(null,flakes);
var state_37989__$1 = (function (){var statearr_38031 = state_37989;
(statearr_38031[(16)] = inst_37915);

return statearr_38031;
})();
if(inst_37916){
var statearr_38032_38069 = state_37989__$1;
(statearr_38032_38069[(1)] = (9));

} else {
var statearr_38033_38070 = state_37989__$1;
(statearr_38033_38070[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10945__auto__ = null;
var fluree$db$graphdb$state_machine__10945__auto____0 = (function (){
var statearr_38034 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38034[(0)] = fluree$db$graphdb$state_machine__10945__auto__);

(statearr_38034[(1)] = (1));

return statearr_38034;
});
var fluree$db$graphdb$state_machine__10945__auto____1 = (function (state_37989){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_37989);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e38035){var ex__10948__auto__ = e38035;
var statearr_38036_38071 = state_37989;
(statearr_38036_38071[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_37989[(4)]))){
var statearr_38037_38072 = state_37989;
(statearr_38037_38072[(1)] = cljs.core.first.call(null,(state_37989[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38073 = state_37989;
state_37989 = G__38073;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10945__auto__ = function(state_37989){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10945__auto____1.call(this,state_37989);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10945__auto____0;
fluree$db$graphdb$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10945__auto____1;
return fluree$db$graphdb$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_38038 = f__11019__auto__.call(null);
(statearr_38038[(6)] = c__11018__auto___38040);

return statearr_38038;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_38129){
var state_val_38130 = (state_38129[(1)]);
if((state_val_38130 === (7))){
var state_38129__$1 = state_38129;
var statearr_38131_38158 = state_38129__$1;
(statearr_38131_38158[(2)] = tt_id);

(statearr_38131_38158[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38130 === (1))){
var state_38129__$1 = state_38129;
var statearr_38132_38159 = state_38129__$1;
(statearr_38132_38159[(2)] = null);

(statearr_38132_38159[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38130 === (4))){
var inst_38074 = (state_38129[(2)]);
var state_38129__$1 = state_38129;
var statearr_38133_38160 = state_38129__$1;
(statearr_38133_38160[(2)] = inst_38074);

(statearr_38133_38160[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38130 === (13))){
var inst_38122 = (state_38129[(2)]);
var state_38129__$1 = state_38129;
var statearr_38134_38161 = state_38129__$1;
(statearr_38134_38161[(2)] = inst_38122);

(statearr_38134_38161[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38130 === (6))){
var inst_38082 = fluree.db.util.core.random_uuid.call(null);
var state_38129__$1 = state_38129;
var statearr_38135_38162 = state_38129__$1;
(statearr_38135_38162[(2)] = inst_38082);

(statearr_38135_38162[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38130 === (3))){
var inst_38127 = (state_38129[(2)]);
var state_38129__$1 = state_38129;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38129__$1,inst_38127);
} else {
if((state_val_38130 === (12))){
var inst_38105 = (state_38129[(7)]);
var state_38129__$1 = state_38129;
var statearr_38136_38163 = state_38129__$1;
(statearr_38136_38163[(2)] = inst_38105);

(statearr_38136_38163[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38130 === (2))){
var _ = (function (){var statearr_38137 = state_38129;
(statearr_38137[(4)] = cljs.core.cons.call(null,(5),(state_38129[(4)])));

return statearr_38137;
})();
var inst_38080 = (tt_id == null);
var state_38129__$1 = state_38129;
if(cljs.core.truth_(inst_38080)){
var statearr_38138_38164 = state_38129__$1;
(statearr_38138_38164[(1)] = (6));

} else {
var statearr_38139_38165 = state_38129__$1;
(statearr_38139_38165[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38130 === (11))){
var inst_38112 = (state_38129[(8)]);
var inst_38105 = (state_38129[(7)]);
var inst_38115 = fluree.db.graphdb.with_t.call(null,inst_38105,inst_38112);
var state_38129__$1 = state_38129;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38129__$1,(14),inst_38115);
} else {
if((state_val_38130 === (9))){
var inst_38112 = (state_38129[(8)]);
var inst_38106 = (state_38129[(9)]);
var inst_38111 = cljs.core.seq.call(null,inst_38106);
var inst_38112__$1 = cljs.core.first.call(null,inst_38111);
var inst_38113 = cljs.core.next.call(null,inst_38111);
var state_38129__$1 = (function (){var statearr_38141 = state_38129;
(statearr_38141[(10)] = inst_38113);

(statearr_38141[(8)] = inst_38112__$1);

return statearr_38141;
})();
if(cljs.core.truth_(inst_38112__$1)){
var statearr_38142_38166 = state_38129__$1;
(statearr_38142_38166[(1)] = (11));

} else {
var statearr_38143_38167 = state_38129__$1;
(statearr_38143_38167[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38130 === (5))){
var _ = (function (){var statearr_38144 = state_38129;
(statearr_38144[(4)] = cljs.core.rest.call(null,(state_38129[(4)])));

return statearr_38144;
})();
var state_38129__$1 = state_38129;
var ex38140 = (state_38129__$1[(2)]);
var statearr_38145_38168 = state_38129__$1;
(statearr_38145_38168[(5)] = ex38140);


if((ex38140 instanceof Error)){
var statearr_38146_38169 = state_38129__$1;
(statearr_38146_38169[(1)] = (4));

(statearr_38146_38169[(5)] = null);

} else {
throw ex38140;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38130 === (14))){
var inst_38113 = (state_38129[(10)]);
var inst_38117 = (state_38129[(2)]);
var inst_38118 = fluree.db.util.async.throw_err.call(null,inst_38117);
var inst_38105 = inst_38118;
var inst_38106 = inst_38113;
var state_38129__$1 = (function (){var statearr_38147 = state_38129;
(statearr_38147[(9)] = inst_38106);

(statearr_38147[(7)] = inst_38105);

return statearr_38147;
})();
var statearr_38148_38170 = state_38129__$1;
(statearr_38148_38170[(2)] = null);

(statearr_38148_38170[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38130 === (10))){
var inst_38124 = (state_38129[(2)]);
var _ = (function (){var statearr_38149 = state_38129;
(statearr_38149[(4)] = cljs.core.rest.call(null,(state_38129[(4)])));

return statearr_38149;
})();
var state_38129__$1 = state_38129;
var statearr_38150_38171 = state_38129__$1;
(statearr_38150_38171[(2)] = inst_38124);

(statearr_38150_38171[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38130 === (8))){
var inst_38085 = (state_38129[(2)]);
var inst_38086 = (function (){var tt_id_SINGLEQUOTE_ = inst_38085;
return (function (db_STAR_,idx){
return cljs.core.assoc.call(null,db_STAR_,idx,cljs.core.assoc.call(null,cljs.core.get.call(null,db_STAR_,idx),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id_SINGLEQUOTE_));
});
})();
var inst_38087 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_38085);
var inst_38088 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38089 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_38090 = (new cljs.core.PersistentVector(null,4,(5),inst_38088,inst_38089,null));
var inst_38091 = cljs.core.reduce.call(null,inst_38086,inst_38087,inst_38090);
var inst_38092 = cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),flakes);
var inst_38093 = cljs.core.reverse.call(null,inst_38092);
var inst_38094 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),inst_38093);
var inst_38102 = cljs.core.seq.call(null,inst_38094);
var inst_38103 = cljs.core.first.call(null,inst_38102);
var inst_38104 = cljs.core.next.call(null,inst_38102);
var inst_38105 = inst_38091;
var inst_38106 = inst_38094;
var state_38129__$1 = (function (){var statearr_38151 = state_38129;
(statearr_38151[(11)] = inst_38104);

(statearr_38151[(12)] = inst_38103);

(statearr_38151[(9)] = inst_38106);

(statearr_38151[(7)] = inst_38105);

return statearr_38151;
})();
var statearr_38152_38172 = state_38129__$1;
(statearr_38152_38172[(2)] = null);

(statearr_38152_38172[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__10945__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__10945__auto____0 = (function (){
var statearr_38153 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38153[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__10945__auto__);

(statearr_38153[(1)] = (1));

return statearr_38153;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__10945__auto____1 = (function (state_38129){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_38129);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e38154){var ex__10948__auto__ = e38154;
var statearr_38155_38173 = state_38129;
(statearr_38155_38173[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_38129[(4)]))){
var statearr_38156_38174 = state_38129;
(statearr_38156_38174[(1)] = cljs.core.first.call(null,(state_38129[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38175 = state_38129;
state_38129 = G__38175;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__10945__auto__ = function(state_38129){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__10945__auto____1.call(this,state_38129);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__10945__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__10945__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_38157 = f__11019__auto__.call(null);
(statearr_38157[(6)] = c__11018__auto__);

return statearr_38157;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.call(null);
var c__11018__auto___38362 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_38293){
var state_val_38294 = (state_38293[(1)]);
if((state_val_38294 === (7))){
var inst_38203 = (state_38293[(7)]);
var inst_38203__$1 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_38293__$1 = (function (){var statearr_38295 = state_38293;
(statearr_38295[(7)] = inst_38203__$1);

return statearr_38295;
})();
if(inst_38203__$1){
var statearr_38296_38363 = state_38293__$1;
(statearr_38296_38363[(1)] = (13));

} else {
var statearr_38297_38364 = state_38293__$1;
(statearr_38297_38364[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (20))){
var state_38293__$1 = state_38293;
var statearr_38298_38365 = state_38293__$1;
(statearr_38298_38365[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (27))){
var inst_38239 = (state_38293[(8)]);
var inst_38243 = inst_38239.s;
var state_38293__$1 = state_38293;
var statearr_38300_38366 = state_38293__$1;
(statearr_38300_38366[(2)] = inst_38243);

(statearr_38300_38366[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (1))){
var state_38293__$1 = state_38293;
var statearr_38301_38367 = state_38293__$1;
(statearr_38301_38367[(2)] = null);

(statearr_38301_38367[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (24))){
var inst_38233 = (state_38293[(9)]);
var inst_38237 = cljs.core.first.call(null,inst_38233);
var state_38293__$1 = state_38293;
var statearr_38302_38368 = state_38293__$1;
(statearr_38302_38368[(2)] = inst_38237);

(statearr_38302_38368[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (39))){
var state_38293__$1 = state_38293;
var statearr_38303_38369 = state_38293__$1;
(statearr_38303_38369[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (4))){
var inst_38176 = (state_38293[(2)]);
var inst_38177 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_38178 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38179 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_38180 = cljs.core.PersistentHashMap.fromArrays(inst_38178,inst_38179);
var inst_38181 = cljs.core.ex_info.call(null,inst_38177,inst_38180,inst_38176);
var inst_38182 = cljs.core.async.put_BANG_.call(null,return_chan,inst_38181);
var state_38293__$1 = state_38293;
var statearr_38305_38370 = state_38293__$1;
(statearr_38305_38370[(2)] = inst_38182);

(statearr_38305_38370[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (15))){
var inst_38210 = (state_38293[(2)]);
var state_38293__$1 = state_38293;
if(cljs.core.truth_(inst_38210)){
var statearr_38306_38371 = state_38293__$1;
(statearr_38306_38371[(1)] = (16));

} else {
var statearr_38307_38372 = state_38293__$1;
(statearr_38307_38372[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (21))){
var inst_38259 = (state_38293[(2)]);
var state_38293__$1 = state_38293;
var statearr_38308_38373 = state_38293__$1;
(statearr_38308_38373[(2)] = inst_38259);

(statearr_38308_38373[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (31))){
var inst_38257 = (state_38293[(2)]);
var state_38293__$1 = state_38293;
var statearr_38309_38374 = state_38293__$1;
(statearr_38309_38374[(2)] = inst_38257);

(statearr_38309_38374[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (32))){
var inst_38263 = (state_38293[(10)]);
var inst_38265 = cljs.core.async.put_BANG_.call(null,return_chan,inst_38263);
var state_38293__$1 = state_38293;
var statearr_38310_38375 = state_38293__$1;
(statearr_38310_38375[(2)] = inst_38265);

(statearr_38310_38375[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (40))){
var inst_38286 = (state_38293[(2)]);
var state_38293__$1 = state_38293;
var statearr_38311_38376 = state_38293__$1;
(statearr_38311_38376[(2)] = inst_38286);

(statearr_38311_38376[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (33))){
var inst_38263 = (state_38293[(10)]);
var inst_38267 = (state_38293[(11)]);
var inst_38267__$1 = (inst_38263 == null);
var state_38293__$1 = (function (){var statearr_38312 = state_38293;
(statearr_38312[(11)] = inst_38267__$1);

return statearr_38312;
})();
if(cljs.core.truth_(inst_38267__$1)){
var statearr_38313_38377 = state_38293__$1;
(statearr_38313_38377[(1)] = (35));

} else {
var statearr_38314_38378 = state_38293__$1;
(statearr_38314_38378[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (13))){
var inst_38205 = cljs.core.first.call(null,ident);
var inst_38206 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_38205);
var inst_38207 = (inst_38206 == null);
var state_38293__$1 = state_38293;
var statearr_38315_38379 = state_38293__$1;
(statearr_38315_38379[(2)] = inst_38207);

(statearr_38315_38379[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (22))){
var inst_38233 = (state_38293[(9)]);
var inst_38232 = (state_38293[(2)]);
var inst_38233__$1 = fluree.db.util.async.throw_err.call(null,inst_38232);
var inst_38234 = (inst_38233__$1 == null);
var state_38293__$1 = (function (){var statearr_38316 = state_38293;
(statearr_38316[(9)] = inst_38233__$1);

return statearr_38316;
})();
if(cljs.core.truth_(inst_38234)){
var statearr_38317_38380 = state_38293__$1;
(statearr_38317_38380[(1)] = (23));

} else {
var statearr_38318_38381 = state_38293__$1;
(statearr_38318_38381[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (36))){
var inst_38267 = (state_38293[(11)]);
var state_38293__$1 = state_38293;
var statearr_38319_38382 = state_38293__$1;
(statearr_38319_38382[(2)] = inst_38267);

(statearr_38319_38382[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (41))){
var inst_38281 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_38293__$1 = state_38293;
var statearr_38320_38383 = state_38293__$1;
(statearr_38320_38383[(2)] = inst_38281);

(statearr_38320_38383[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (43))){
var inst_38284 = (state_38293[(2)]);
var state_38293__$1 = state_38293;
var statearr_38321_38384 = state_38293__$1;
(statearr_38321_38384[(2)] = inst_38284);

(statearr_38321_38384[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (29))){
var inst_38248 = cljs.core.pr_str.call(null,ident);
var inst_38249 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_38248].join('');
var inst_38250 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38251 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_38252 = cljs.core.PersistentHashMap.fromArrays(inst_38250,inst_38251);
var inst_38253 = cljs.core.ex_info.call(null,inst_38249,inst_38252);
var inst_38254 = (function(){throw inst_38253})();
var state_38293__$1 = state_38293;
var statearr_38322_38385 = state_38293__$1;
(statearr_38322_38385[(2)] = inst_38254);

(statearr_38322_38385[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (6))){
var inst_38190 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38191 = [ident];
var inst_38192 = (new cljs.core.PersistentVector(null,1,(5),inst_38190,inst_38191,null));
var inst_38193 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_38192);
var state_38293__$1 = state_38293;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38293__$1,(9),inst_38193);
} else {
if((state_val_38294 === (28))){
var inst_38245 = (state_38293[(2)]);
var state_38293__$1 = state_38293;
var statearr_38323_38386 = state_38293__$1;
(statearr_38323_38386[(2)] = inst_38245);

(statearr_38323_38386[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (25))){
var inst_38239 = (state_38293[(8)]);
var inst_38239__$1 = (state_38293[(2)]);
var inst_38240 = (inst_38239__$1 == null);
var state_38293__$1 = (function (){var statearr_38324 = state_38293;
(statearr_38324[(8)] = inst_38239__$1);

return statearr_38324;
})();
if(cljs.core.truth_(inst_38240)){
var statearr_38325_38387 = state_38293__$1;
(statearr_38325_38387[(1)] = (26));

} else {
var statearr_38326_38388 = state_38293__$1;
(statearr_38326_38388[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (34))){
var inst_38288 = (state_38293[(2)]);
var _ = (function (){var statearr_38327 = state_38293;
(statearr_38327[(4)] = cljs.core.rest.call(null,(state_38293[(4)])));

return statearr_38327;
})();
var state_38293__$1 = state_38293;
var statearr_38328_38389 = state_38293__$1;
(statearr_38328_38389[(2)] = inst_38288);

(statearr_38328_38389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (17))){
var inst_38221 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_38293__$1 = state_38293;
if(inst_38221){
var statearr_38329_38390 = state_38293__$1;
(statearr_38329_38390[(1)] = (19));

} else {
var statearr_38330_38391 = state_38293__$1;
(statearr_38330_38391[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (3))){
var inst_38291 = (state_38293[(2)]);
var state_38293__$1 = state_38293;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38293__$1,inst_38291);
} else {
if((state_val_38294 === (12))){
var inst_38201 = (state_38293[(2)]);
var state_38293__$1 = state_38293;
var statearr_38331_38392 = state_38293__$1;
(statearr_38331_38392[(2)] = inst_38201);

(statearr_38331_38392[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (2))){
var _ = (function (){var statearr_38332 = state_38293;
(statearr_38332[(4)] = cljs.core.cons.call(null,(5),(state_38293[(4)])));

return statearr_38332;
})();
var inst_38188 = typeof ident === 'number';
var state_38293__$1 = state_38293;
if(cljs.core.truth_(inst_38188)){
var statearr_38333_38393 = state_38293__$1;
(statearr_38333_38393[(1)] = (6));

} else {
var statearr_38334_38394 = state_38293__$1;
(statearr_38334_38394[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (23))){
var state_38293__$1 = state_38293;
var statearr_38335_38395 = state_38293__$1;
(statearr_38335_38395[(2)] = null);

(statearr_38335_38395[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (35))){
var state_38293__$1 = state_38293;
var statearr_38336_38396 = state_38293__$1;
(statearr_38336_38396[(2)] = strict_QMARK_);

(statearr_38336_38396[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (19))){
var inst_38224 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38225 = cljs.core.first.call(null,ident);
var inst_38226 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_38225);
var inst_38227 = cljs.core.second.call(null,ident);
var inst_38228 = [inst_38226,inst_38227];
var inst_38229 = (new cljs.core.PersistentVector(null,2,(5),inst_38224,inst_38228,null));
var inst_38230 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_38229);
var state_38293__$1 = state_38293;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38293__$1,(22),inst_38230);
} else {
if((state_val_38294 === (11))){
var state_38293__$1 = state_38293;
var statearr_38338_38397 = state_38293__$1;
(statearr_38338_38397[(2)] = null);

(statearr_38338_38397[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (9))){
var inst_38195 = (state_38293[(2)]);
var inst_38196 = fluree.db.util.async.throw_err.call(null,inst_38195);
var inst_38197 = cljs.core.not_empty.call(null,inst_38196);
var state_38293__$1 = state_38293;
if(cljs.core.truth_(inst_38197)){
var statearr_38339_38398 = state_38293__$1;
(statearr_38339_38398[(1)] = (10));

} else {
var statearr_38340_38399 = state_38293__$1;
(statearr_38340_38399[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (5))){
var _ = (function (){var statearr_38341 = state_38293;
(statearr_38341[(4)] = cljs.core.rest.call(null,(state_38293[(4)])));

return statearr_38341;
})();
var state_38293__$1 = state_38293;
var ex38337 = (state_38293__$1[(2)]);
var statearr_38342_38400 = state_38293__$1;
(statearr_38342_38400[(5)] = ex38337);


var statearr_38343_38401 = state_38293__$1;
(statearr_38343_38401[(1)] = (4));

(statearr_38343_38401[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (14))){
var inst_38203 = (state_38293[(7)]);
var state_38293__$1 = state_38293;
var statearr_38344_38402 = state_38293__$1;
(statearr_38344_38402[(2)] = inst_38203);

(statearr_38344_38402[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (26))){
var state_38293__$1 = state_38293;
var statearr_38345_38403 = state_38293__$1;
(statearr_38345_38403[(2)] = null);

(statearr_38345_38403[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (16))){
var inst_38212 = cljs.core.first.call(null,ident);
var inst_38213 = cljs.core.pr_str.call(null,inst_38212);
var inst_38214 = ["Subject ID lookup failed. The predicate ",inst_38213," does not exist."].join('');
var inst_38215 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38216 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_38217 = cljs.core.PersistentHashMap.fromArrays(inst_38215,inst_38216);
var inst_38218 = cljs.core.ex_info.call(null,inst_38214,inst_38217);
var inst_38219 = (function(){throw inst_38218})();
var state_38293__$1 = state_38293;
var statearr_38346_38404 = state_38293__$1;
(statearr_38346_38404[(2)] = inst_38219);

(statearr_38346_38404[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (38))){
var inst_38273 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_38274 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38275 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_38276 = cljs.core.PersistentHashMap.fromArrays(inst_38274,inst_38275);
var inst_38277 = cljs.core.ex_info.call(null,inst_38273,inst_38276);
var inst_38278 = cljs.core.async.put_BANG_.call(null,return_chan,inst_38277);
var state_38293__$1 = state_38293;
var statearr_38347_38405 = state_38293__$1;
(statearr_38347_38405[(2)] = inst_38278);

(statearr_38347_38405[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (30))){
var state_38293__$1 = state_38293;
var statearr_38348_38406 = state_38293__$1;
(statearr_38348_38406[(2)] = null);

(statearr_38348_38406[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (10))){
var state_38293__$1 = state_38293;
var statearr_38349_38407 = state_38293__$1;
(statearr_38349_38407[(2)] = ident);

(statearr_38349_38407[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (18))){
var inst_38261 = (state_38293[(2)]);
var state_38293__$1 = state_38293;
var statearr_38350_38408 = state_38293__$1;
(statearr_38350_38408[(2)] = inst_38261);

(statearr_38350_38408[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (42))){
var state_38293__$1 = state_38293;
var statearr_38351_38409 = state_38293__$1;
(statearr_38351_38409[(2)] = null);

(statearr_38351_38409[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (37))){
var inst_38271 = (state_38293[(2)]);
var state_38293__$1 = state_38293;
if(cljs.core.truth_(inst_38271)){
var statearr_38352_38410 = state_38293__$1;
(statearr_38352_38410[(1)] = (38));

} else {
var statearr_38353_38411 = state_38293__$1;
(statearr_38353_38411[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38294 === (8))){
var inst_38263 = (state_38293[(10)]);
var inst_38263__$1 = (state_38293[(2)]);
var state_38293__$1 = (function (){var statearr_38354 = state_38293;
(statearr_38354[(10)] = inst_38263__$1);

return statearr_38354;
})();
if(cljs.core.truth_(inst_38263__$1)){
var statearr_38355_38412 = state_38293__$1;
(statearr_38355_38412[(1)] = (32));

} else {
var statearr_38356_38413 = state_38293__$1;
(statearr_38356_38413[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__10945__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__10945__auto____0 = (function (){
var statearr_38357 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38357[(0)] = fluree$db$graphdb$subid_$_state_machine__10945__auto__);

(statearr_38357[(1)] = (1));

return statearr_38357;
});
var fluree$db$graphdb$subid_$_state_machine__10945__auto____1 = (function (state_38293){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_38293);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e38358){var ex__10948__auto__ = e38358;
var statearr_38359_38414 = state_38293;
(statearr_38359_38414[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_38293[(4)]))){
var statearr_38360_38415 = state_38293;
(statearr_38360_38415[(1)] = cljs.core.first.call(null,(state_38293[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38416 = state_38293;
state_38293 = G__38416;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__10945__auto__ = function(state_38293){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__10945__auto____1.call(this,state_38293);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__10945__auto____0;
fluree$db$graphdb$subid_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__10945__auto____1;
return fluree$db$graphdb$subid_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_38361 = f__11019__auto__.call(null);
(statearr_38361[(6)] = c__11018__auto___38362);

return statearr_38361;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__38417){
var map__38418 = p__38417;
var map__38418__$1 = cljs.core.__destructure_map.call(null,map__38418);
var db = map__38418__$1;
var current_db_fn = cljs.core.get.call(null,map__38418__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.call(null,map__38418__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_38434){
var state_val_38435 = (state_38434[(1)]);
if((state_val_38435 === (1))){
var state_38434__$1 = state_38434;
var statearr_38436_38450 = state_38434__$1;
(statearr_38436_38450[(2)] = null);

(statearr_38436_38450[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38435 === (2))){
var _ = (function (){var statearr_38437 = state_38434;
(statearr_38437[(4)] = cljs.core.cons.call(null,(5),(state_38434[(4)])));

return statearr_38437;
})();
var inst_38425 = current_db_fn.call(null,db);
var state_38434__$1 = state_38434;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38434__$1,(6),inst_38425);
} else {
if((state_val_38435 === (3))){
var inst_38432 = (state_38434[(2)]);
var state_38434__$1 = state_38434;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38434__$1,inst_38432);
} else {
if((state_val_38435 === (4))){
var inst_38419 = (state_38434[(2)]);
var state_38434__$1 = state_38434;
var statearr_38439_38451 = state_38434__$1;
(statearr_38439_38451[(2)] = inst_38419);

(statearr_38439_38451[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38435 === (5))){
var _ = (function (){var statearr_38440 = state_38434;
(statearr_38440[(4)] = cljs.core.rest.call(null,(state_38434[(4)])));

return statearr_38440;
})();
var state_38434__$1 = state_38434;
var ex38438 = (state_38434__$1[(2)]);
var statearr_38441_38452 = state_38434__$1;
(statearr_38441_38452[(5)] = ex38438);


if((ex38438 instanceof Error)){
var statearr_38442_38453 = state_38434__$1;
(statearr_38442_38453[(1)] = (4));

(statearr_38442_38453[(5)] = null);

} else {
throw ex38438;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38435 === (6))){
var inst_38427 = (state_38434[(2)]);
var inst_38428 = fluree.db.util.async.throw_err.call(null,inst_38427);
var inst_38429 = cljs.core.assoc.call(null,inst_38428,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_38443 = state_38434;
(statearr_38443[(4)] = cljs.core.rest.call(null,(state_38434[(4)])));

return statearr_38443;
})();
var state_38434__$1 = state_38434;
var statearr_38444_38454 = state_38434__$1;
(statearr_38444_38454[(2)] = inst_38429);

(statearr_38444_38454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__10945__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__10945__auto____0 = (function (){
var statearr_38445 = [null,null,null,null,null,null,null];
(statearr_38445[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__10945__auto__);

(statearr_38445[(1)] = (1));

return statearr_38445;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__10945__auto____1 = (function (state_38434){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_38434);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e38446){var ex__10948__auto__ = e38446;
var statearr_38447_38455 = state_38434;
(statearr_38447_38455[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_38434[(4)]))){
var statearr_38448_38456 = state_38434;
(statearr_38448_38456[(1)] = cljs.core.first.call(null,(state_38434[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38457 = state_38434;
state_38434 = G__38457;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__10945__auto__ = function(state_38434){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__10945__auto____1.call(this,state_38434);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__10945__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__10945__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_38449 = f__11019__auto__.call(null);
(statearr_38449[(6)] = c__11018__auto__);

return statearr_38449;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.call(null,this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__38458,property,collection){
var map__38459 = p__38458;
var map__38459__$1 = cljs.core.__destructure_map.call(null,map__38459);
var schema = cljs.core.get.call(null,map__38459__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_.call(null,collection)){
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__38460,property,predicate){
var map__38461 = p__38460;
var map__38461__$1 = cljs.core.__destructure_map.call(null,map__38461);
var this$ = map__38461__$1;
var schema = cljs.core.get.call(null,map__38461__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__38462 = cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop.call(null,this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__38462);
} else {
return G__38462;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__38464 = arguments.length;
switch (G__38464) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_38496){
var state_val_38497 = (state_38496[(1)]);
if((state_val_38497 === (7))){
var state_38496__$1 = state_38496;
var statearr_38498_38592 = state_38496__$1;
(statearr_38498_38592[(2)] = null);

(statearr_38498_38592[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38497 === (1))){
var state_38496__$1 = state_38496;
var statearr_38499_38593 = state_38496__$1;
(statearr_38499_38593[(2)] = null);

(statearr_38499_38593[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38497 === (4))){
var inst_38465 = (state_38496[(2)]);
var state_38496__$1 = state_38496;
var statearr_38500_38594 = state_38496__$1;
(statearr_38500_38594[(2)] = inst_38465);

(statearr_38500_38594[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38497 === (6))){
var inst_38479 = (state_38496[(7)]);
var inst_38478 = (state_38496[(2)]);
var inst_38479__$1 = fluree.db.util.async.throw_err.call(null,inst_38478);
var inst_38480 = (inst_38479__$1 == null);
var state_38496__$1 = (function (){var statearr_38501 = state_38496;
(statearr_38501[(7)] = inst_38479__$1);

return statearr_38501;
})();
if(cljs.core.truth_(inst_38480)){
var statearr_38502_38595 = state_38496__$1;
(statearr_38502_38595[(1)] = (7));

} else {
var statearr_38503_38596 = state_38496__$1;
(statearr_38503_38596[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38497 === (3))){
var inst_38494 = (state_38496[(2)]);
var state_38496__$1 = state_38496;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38496__$1,inst_38494);
} else {
if((state_val_38497 === (12))){
var inst_38491 = (state_38496[(2)]);
var _ = (function (){var statearr_38504 = state_38496;
(statearr_38504[(4)] = cljs.core.rest.call(null,(state_38496[(4)])));

return statearr_38504;
})();
var state_38496__$1 = state_38496;
var statearr_38505_38597 = state_38496__$1;
(statearr_38505_38597[(2)] = inst_38491);

(statearr_38505_38597[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38497 === (2))){
var _ = (function (){var statearr_38506 = state_38496;
(statearr_38506[(4)] = cljs.core.cons.call(null,(5),(state_38496[(4)])));

return statearr_38506;
})();
var inst_38472 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_38473 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38474 = [tag_id,(30)];
var inst_38475 = (new cljs.core.PersistentVector(null,2,(5),inst_38473,inst_38474,null));
var inst_38476 = fluree.db.query.range.index_range.call(null,inst_38472,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_38475);
var state_38496__$1 = state_38496;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38496__$1,(6),inst_38476);
} else {
if((state_val_38497 === (11))){
var inst_38485 = (state_38496[(8)]);
var inst_38489 = inst_38485.o;
var state_38496__$1 = state_38496;
var statearr_38508_38598 = state_38496__$1;
(statearr_38508_38598[(2)] = inst_38489);

(statearr_38508_38598[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38497 === (9))){
var inst_38485 = (state_38496[(8)]);
var inst_38485__$1 = (state_38496[(2)]);
var inst_38486 = (inst_38485__$1 == null);
var state_38496__$1 = (function (){var statearr_38509 = state_38496;
(statearr_38509[(8)] = inst_38485__$1);

return statearr_38509;
})();
if(cljs.core.truth_(inst_38486)){
var statearr_38510_38599 = state_38496__$1;
(statearr_38510_38599[(1)] = (10));

} else {
var statearr_38511_38600 = state_38496__$1;
(statearr_38511_38600[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38497 === (5))){
var _ = (function (){var statearr_38512 = state_38496;
(statearr_38512[(4)] = cljs.core.rest.call(null,(state_38496[(4)])));

return statearr_38512;
})();
var state_38496__$1 = state_38496;
var ex38507 = (state_38496__$1[(2)]);
var statearr_38513_38601 = state_38496__$1;
(statearr_38513_38601[(5)] = ex38507);


if((ex38507 instanceof Error)){
var statearr_38514_38602 = state_38496__$1;
(statearr_38514_38602[(1)] = (4));

(statearr_38514_38602[(5)] = null);

} else {
throw ex38507;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38497 === (10))){
var state_38496__$1 = state_38496;
var statearr_38515_38603 = state_38496__$1;
(statearr_38515_38603[(2)] = null);

(statearr_38515_38603[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38497 === (8))){
var inst_38479 = (state_38496[(7)]);
var inst_38483 = cljs.core.first.call(null,inst_38479);
var state_38496__$1 = state_38496;
var statearr_38516_38604 = state_38496__$1;
(statearr_38516_38604[(2)] = inst_38483);

(statearr_38516_38604[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10945__auto__ = null;
var fluree$db$graphdb$state_machine__10945__auto____0 = (function (){
var statearr_38517 = [null,null,null,null,null,null,null,null,null];
(statearr_38517[(0)] = fluree$db$graphdb$state_machine__10945__auto__);

(statearr_38517[(1)] = (1));

return statearr_38517;
});
var fluree$db$graphdb$state_machine__10945__auto____1 = (function (state_38496){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_38496);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e38518){var ex__10948__auto__ = e38518;
var statearr_38519_38605 = state_38496;
(statearr_38519_38605[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_38496[(4)]))){
var statearr_38520_38606 = state_38496;
(statearr_38520_38606[(1)] = cljs.core.first.call(null,(state_38496[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38607 = state_38496;
state_38496 = G__38607;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10945__auto__ = function(state_38496){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10945__auto____1.call(this,state_38496);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10945__auto____0;
fluree$db$graphdb$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10945__auto____1;
return fluree$db$graphdb$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_38521 = f__11019__auto__.call(null);
(statearr_38521[(6)] = c__11018__auto__);

return statearr_38521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_38557){
var state_val_38558 = (state_38557[(1)]);
if((state_val_38558 === (7))){
var inst_38531 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_38557__$1 = state_38557;
var statearr_38559_38608 = state_38557__$1;
(statearr_38559_38608[(2)] = inst_38531);

(statearr_38559_38608[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38558 === (1))){
var state_38557__$1 = state_38557;
var statearr_38560_38609 = state_38557__$1;
(statearr_38560_38609[(2)] = null);

(statearr_38560_38609[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38558 === (4))){
var inst_38522 = (state_38557[(2)]);
var state_38557__$1 = state_38557;
var statearr_38561_38610 = state_38557__$1;
(statearr_38561_38610[(2)] = inst_38522);

(statearr_38561_38610[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38558 === (15))){
var inst_38552 = (state_38557[(2)]);
var _ = (function (){var statearr_38562 = state_38557;
(statearr_38562[(4)] = cljs.core.rest.call(null,(state_38557[(4)])));

return statearr_38562;
})();
var state_38557__$1 = state_38557;
var statearr_38563_38611 = state_38557__$1;
(statearr_38563_38611[(2)] = inst_38552);

(statearr_38563_38611[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38558 === (13))){
var inst_38537 = (state_38557[(7)]);
var inst_38543 = clojure.string.includes_QMARK_.call(null,inst_38537,":");
var state_38557__$1 = state_38557;
if(inst_38543){
var statearr_38564_38612 = state_38557__$1;
(statearr_38564_38612[(1)] = (16));

} else {
var statearr_38565_38613 = state_38557__$1;
(statearr_38565_38613[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38558 === (6))){
var state_38557__$1 = state_38557;
var statearr_38566_38614 = state_38557__$1;
(statearr_38566_38614[(2)] = pred);

(statearr_38566_38614[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38558 === (17))){
var inst_38537 = (state_38557[(7)]);
var state_38557__$1 = state_38557;
var statearr_38567_38615 = state_38557__$1;
(statearr_38567_38615[(2)] = inst_38537);

(statearr_38567_38615[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38558 === (3))){
var inst_38555 = (state_38557[(2)]);
var state_38557__$1 = state_38557;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38557__$1,inst_38555);
} else {
if((state_val_38558 === (12))){
var inst_38541 = (state_38557[(2)]);
var state_38557__$1 = state_38557;
if(cljs.core.truth_(inst_38541)){
var statearr_38568_38616 = state_38557__$1;
(statearr_38568_38616[(1)] = (13));

} else {
var statearr_38569_38617 = state_38557__$1;
(statearr_38569_38617[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38558 === (2))){
var _ = (function (){var statearr_38570 = state_38557;
(statearr_38570[(4)] = cljs.core.cons.call(null,(5),(state_38557[(4)])));

return statearr_38570;
})();
var inst_38528 = typeof pred === 'string';
var state_38557__$1 = state_38557;
if(cljs.core.truth_(inst_38528)){
var statearr_38571_38618 = state_38557__$1;
(statearr_38571_38618[(1)] = (6));

} else {
var statearr_38572_38619 = state_38557__$1;
(statearr_38572_38619[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38558 === (11))){
var inst_38533 = (state_38557[(8)]);
var state_38557__$1 = state_38557;
var statearr_38574_38620 = state_38557__$1;
(statearr_38574_38620[(2)] = inst_38533);

(statearr_38574_38620[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38558 === (9))){
var inst_38533 = (state_38557[(8)]);
var inst_38536 = (state_38557[(2)]);
var inst_38537 = fluree.db.util.async.throw_err.call(null,inst_38536);
var state_38557__$1 = (function (){var statearr_38575 = state_38557;
(statearr_38575[(7)] = inst_38537);

return statearr_38575;
})();
if(cljs.core.truth_(inst_38533)){
var statearr_38576_38621 = state_38557__$1;
(statearr_38576_38621[(1)] = (10));

} else {
var statearr_38577_38622 = state_38557__$1;
(statearr_38577_38622[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38558 === (5))){
var _ = (function (){var statearr_38578 = state_38557;
(statearr_38578[(4)] = cljs.core.rest.call(null,(state_38557[(4)])));

return statearr_38578;
})();
var state_38557__$1 = state_38557;
var ex38573 = (state_38557__$1[(2)]);
var statearr_38579_38623 = state_38557__$1;
(statearr_38579_38623[(5)] = ex38573);


if((ex38573 instanceof Error)){
var statearr_38580_38624 = state_38557__$1;
(statearr_38580_38624[(1)] = (4));

(statearr_38580_38624[(5)] = null);

} else {
throw ex38573;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38558 === (14))){
var state_38557__$1 = state_38557;
var statearr_38581_38625 = state_38557__$1;
(statearr_38581_38625[(2)] = null);

(statearr_38581_38625[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38558 === (16))){
var inst_38537 = (state_38557[(7)]);
var inst_38545 = clojure.string.split.call(null,inst_38537,/:/);
var inst_38546 = cljs.core.second.call(null,inst_38545);
var state_38557__$1 = state_38557;
var statearr_38582_38626 = state_38557__$1;
(statearr_38582_38626[(2)] = inst_38546);

(statearr_38582_38626[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38558 === (10))){
var inst_38537 = (state_38557[(7)]);
var state_38557__$1 = state_38557;
var statearr_38583_38627 = state_38557__$1;
(statearr_38583_38627[(2)] = inst_38537);

(statearr_38583_38627[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38558 === (18))){
var inst_38549 = (state_38557[(2)]);
var state_38557__$1 = state_38557;
var statearr_38584_38628 = state_38557__$1;
(statearr_38584_38628[(2)] = inst_38549);

(statearr_38584_38628[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38558 === (8))){
var inst_38533 = (state_38557[(2)]);
var inst_38534 = fluree.db.dbproto._tag.call(null,this$,tag_id);
var state_38557__$1 = (function (){var statearr_38585 = state_38557;
(statearr_38585[(8)] = inst_38533);

return statearr_38585;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38557__$1,(9),inst_38534);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10945__auto__ = null;
var fluree$db$graphdb$state_machine__10945__auto____0 = (function (){
var statearr_38586 = [null,null,null,null,null,null,null,null,null];
(statearr_38586[(0)] = fluree$db$graphdb$state_machine__10945__auto__);

(statearr_38586[(1)] = (1));

return statearr_38586;
});
var fluree$db$graphdb$state_machine__10945__auto____1 = (function (state_38557){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_38557);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e38587){var ex__10948__auto__ = e38587;
var statearr_38588_38629 = state_38557;
(statearr_38588_38629[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_38557[(4)]))){
var statearr_38589_38630 = state_38557;
(statearr_38589_38630[(1)] = cljs.core.first.call(null,(state_38557[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38631 = state_38557;
state_38557 = G__38631;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10945__auto__ = function(state_38557){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10945__auto____1.call(this,state_38557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10945__auto____0;
fluree$db$graphdb$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10945__auto____1;
return fluree$db$graphdb$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_38590 = f__11019__auto__.call(null);
(statearr_38590[(6)] = c__11018__auto__);

return statearr_38590;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__38633 = arguments.length;
switch (G__38633) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_38666){
var state_val_38667 = (state_38666[(1)]);
if((state_val_38667 === (7))){
var state_38666__$1 = state_38666;
var statearr_38668_38756 = state_38666__$1;
(statearr_38668_38756[(2)] = null);

(statearr_38668_38756[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38667 === (1))){
var state_38666__$1 = state_38666;
var statearr_38669_38757 = state_38666__$1;
(statearr_38669_38757[(2)] = null);

(statearr_38669_38757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38667 === (4))){
var inst_38634 = (state_38666[(2)]);
var state_38666__$1 = state_38666;
var statearr_38670_38758 = state_38666__$1;
(statearr_38670_38758[(2)] = inst_38634);

(statearr_38670_38758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38667 === (6))){
var inst_38649 = (state_38666[(7)]);
var inst_38648 = (state_38666[(2)]);
var inst_38649__$1 = fluree.db.util.async.throw_err.call(null,inst_38648);
var inst_38650 = (inst_38649__$1 == null);
var state_38666__$1 = (function (){var statearr_38671 = state_38666;
(statearr_38671[(7)] = inst_38649__$1);

return statearr_38671;
})();
if(cljs.core.truth_(inst_38650)){
var statearr_38672_38759 = state_38666__$1;
(statearr_38672_38759[(1)] = (7));

} else {
var statearr_38673_38760 = state_38666__$1;
(statearr_38673_38760[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38667 === (3))){
var inst_38664 = (state_38666[(2)]);
var state_38666__$1 = state_38666;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38666__$1,inst_38664);
} else {
if((state_val_38667 === (12))){
var inst_38661 = (state_38666[(2)]);
var _ = (function (){var statearr_38674 = state_38666;
(statearr_38674[(4)] = cljs.core.rest.call(null,(state_38666[(4)])));

return statearr_38674;
})();
var state_38666__$1 = state_38666;
var statearr_38675_38761 = state_38666__$1;
(statearr_38675_38761[(2)] = inst_38661);

(statearr_38675_38761[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38667 === (2))){
var _ = (function (){var statearr_38676 = state_38666;
(statearr_38676[(4)] = cljs.core.cons.call(null,(5),(state_38666[(4)])));

return statearr_38676;
})();
var inst_38640 = (30);
var inst_38642 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_38643 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38644 = [inst_38640,tag_name];
var inst_38645 = (new cljs.core.PersistentVector(null,2,(5),inst_38643,inst_38644,null));
var inst_38646 = fluree.db.query.range.index_range.call(null,inst_38642,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_38645);
var state_38666__$1 = state_38666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38666__$1,(6),inst_38646);
} else {
if((state_val_38667 === (11))){
var inst_38655 = (state_38666[(8)]);
var inst_38659 = inst_38655.s;
var state_38666__$1 = state_38666;
var statearr_38678_38762 = state_38666__$1;
(statearr_38678_38762[(2)] = inst_38659);

(statearr_38678_38762[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38667 === (9))){
var inst_38655 = (state_38666[(8)]);
var inst_38655__$1 = (state_38666[(2)]);
var inst_38656 = (inst_38655__$1 == null);
var state_38666__$1 = (function (){var statearr_38679 = state_38666;
(statearr_38679[(8)] = inst_38655__$1);

return statearr_38679;
})();
if(cljs.core.truth_(inst_38656)){
var statearr_38680_38763 = state_38666__$1;
(statearr_38680_38763[(1)] = (10));

} else {
var statearr_38681_38764 = state_38666__$1;
(statearr_38681_38764[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38667 === (5))){
var _ = (function (){var statearr_38682 = state_38666;
(statearr_38682[(4)] = cljs.core.rest.call(null,(state_38666[(4)])));

return statearr_38682;
})();
var state_38666__$1 = state_38666;
var ex38677 = (state_38666__$1[(2)]);
var statearr_38683_38765 = state_38666__$1;
(statearr_38683_38765[(5)] = ex38677);


if((ex38677 instanceof Error)){
var statearr_38684_38766 = state_38666__$1;
(statearr_38684_38766[(1)] = (4));

(statearr_38684_38766[(5)] = null);

} else {
throw ex38677;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38667 === (10))){
var state_38666__$1 = state_38666;
var statearr_38685_38767 = state_38666__$1;
(statearr_38685_38767[(2)] = null);

(statearr_38685_38767[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38667 === (8))){
var inst_38649 = (state_38666[(7)]);
var inst_38653 = cljs.core.first.call(null,inst_38649);
var state_38666__$1 = state_38666;
var statearr_38686_38768 = state_38666__$1;
(statearr_38686_38768[(2)] = inst_38653);

(statearr_38686_38768[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10945__auto__ = null;
var fluree$db$graphdb$state_machine__10945__auto____0 = (function (){
var statearr_38687 = [null,null,null,null,null,null,null,null,null];
(statearr_38687[(0)] = fluree$db$graphdb$state_machine__10945__auto__);

(statearr_38687[(1)] = (1));

return statearr_38687;
});
var fluree$db$graphdb$state_machine__10945__auto____1 = (function (state_38666){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_38666);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e38688){var ex__10948__auto__ = e38688;
var statearr_38689_38769 = state_38666;
(statearr_38689_38769[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_38666[(4)]))){
var statearr_38690_38770 = state_38666;
(statearr_38690_38770[(1)] = cljs.core.first.call(null,(state_38666[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38771 = state_38666;
state_38666 = G__38771;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10945__auto__ = function(state_38666){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10945__auto____1.call(this,state_38666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10945__auto____0;
fluree$db$graphdb$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10945__auto____1;
return fluree$db$graphdb$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_38691 = f__11019__auto__.call(null);
(statearr_38691[(6)] = c__11018__auto__);

return statearr_38691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_38726){
var state_val_38727 = (state_38726[(1)]);
if((state_val_38727 === (7))){
var inst_38705 = typeof pred === 'string';
var state_38726__$1 = state_38726;
if(cljs.core.truth_(inst_38705)){
var statearr_38728_38772 = state_38726__$1;
(statearr_38728_38772[(1)] = (10));

} else {
var statearr_38729_38773 = state_38726__$1;
(statearr_38729_38773[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38727 === (1))){
var state_38726__$1 = state_38726;
var statearr_38730_38774 = state_38726__$1;
(statearr_38730_38774[(2)] = null);

(statearr_38730_38774[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38727 === (4))){
var inst_38692 = (state_38726[(2)]);
var state_38726__$1 = state_38726;
var statearr_38731_38775 = state_38726__$1;
(statearr_38731_38775[(2)] = inst_38692);

(statearr_38731_38775[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38727 === (15))){
var inst_38719 = (state_38726[(2)]);
var state_38726__$1 = state_38726;
var statearr_38732_38776 = state_38726__$1;
(statearr_38732_38776[(2)] = inst_38719);

(statearr_38732_38776[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38727 === (13))){
var inst_38710 = (state_38726[(7)]);
var inst_38712 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38710),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_38713 = fluree.db.dbproto._tag_id.call(null,this$,inst_38712);
var state_38726__$1 = state_38726;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38726__$1,(16),inst_38713);
} else {
if((state_val_38727 === (6))){
var inst_38700 = fluree.db.dbproto._tag_id.call(null,this$,tag_name);
var state_38726__$1 = state_38726;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38726__$1,(9),inst_38700);
} else {
if((state_val_38727 === (3))){
var inst_38724 = (state_38726[(2)]);
var state_38726__$1 = state_38726;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38726__$1,inst_38724);
} else {
if((state_val_38727 === (12))){
var inst_38710 = (state_38726[(7)]);
var inst_38710__$1 = (state_38726[(2)]);
var state_38726__$1 = (function (){var statearr_38733 = state_38726;
(statearr_38733[(7)] = inst_38710__$1);

return statearr_38733;
})();
if(cljs.core.truth_(inst_38710__$1)){
var statearr_38734_38777 = state_38726__$1;
(statearr_38734_38777[(1)] = (13));

} else {
var statearr_38735_38778 = state_38726__$1;
(statearr_38735_38778[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38727 === (2))){
var _ = (function (){var statearr_38736 = state_38726;
(statearr_38736[(4)] = cljs.core.cons.call(null,(5),(state_38726[(4)])));

return statearr_38736;
})();
var inst_38698 = clojure.string.includes_QMARK_.call(null,tag_name,"/");
var state_38726__$1 = state_38726;
if(inst_38698){
var statearr_38737_38779 = state_38726__$1;
(statearr_38737_38779[(1)] = (6));

} else {
var statearr_38738_38780 = state_38726__$1;
(statearr_38738_38780[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38727 === (11))){
var inst_38708 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_38726__$1 = state_38726;
var statearr_38740_38781 = state_38726__$1;
(statearr_38740_38781[(2)] = inst_38708);

(statearr_38740_38781[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38727 === (9))){
var inst_38702 = (state_38726[(2)]);
var inst_38703 = fluree.db.util.async.throw_err.call(null,inst_38702);
var state_38726__$1 = state_38726;
var statearr_38741_38782 = state_38726__$1;
(statearr_38741_38782[(2)] = inst_38703);

(statearr_38741_38782[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38727 === (5))){
var _ = (function (){var statearr_38742 = state_38726;
(statearr_38742[(4)] = cljs.core.rest.call(null,(state_38726[(4)])));

return statearr_38742;
})();
var state_38726__$1 = state_38726;
var ex38739 = (state_38726__$1[(2)]);
var statearr_38743_38783 = state_38726__$1;
(statearr_38743_38783[(5)] = ex38739);


if((ex38739 instanceof Error)){
var statearr_38744_38784 = state_38726__$1;
(statearr_38744_38784[(1)] = (4));

(statearr_38744_38784[(5)] = null);

} else {
throw ex38739;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38727 === (14))){
var state_38726__$1 = state_38726;
var statearr_38745_38785 = state_38726__$1;
(statearr_38745_38785[(2)] = null);

(statearr_38745_38785[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38727 === (16))){
var inst_38715 = (state_38726[(2)]);
var inst_38716 = fluree.db.util.async.throw_err.call(null,inst_38715);
var state_38726__$1 = state_38726;
var statearr_38746_38786 = state_38726__$1;
(statearr_38746_38786[(2)] = inst_38716);

(statearr_38746_38786[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38727 === (10))){
var state_38726__$1 = state_38726;
var statearr_38747_38787 = state_38726__$1;
(statearr_38747_38787[(2)] = pred);

(statearr_38747_38787[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38727 === (8))){
var inst_38721 = (state_38726[(2)]);
var _ = (function (){var statearr_38748 = state_38726;
(statearr_38748[(4)] = cljs.core.rest.call(null,(state_38726[(4)])));

return statearr_38748;
})();
var state_38726__$1 = state_38726;
var statearr_38749_38788 = state_38726__$1;
(statearr_38749_38788[(2)] = inst_38721);

(statearr_38749_38788[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10945__auto__ = null;
var fluree$db$graphdb$state_machine__10945__auto____0 = (function (){
var statearr_38750 = [null,null,null,null,null,null,null,null];
(statearr_38750[(0)] = fluree$db$graphdb$state_machine__10945__auto__);

(statearr_38750[(1)] = (1));

return statearr_38750;
});
var fluree$db$graphdb$state_machine__10945__auto____1 = (function (state_38726){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_38726);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e38751){var ex__10948__auto__ = e38751;
var statearr_38752_38789 = state_38726;
(statearr_38752_38789[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_38726[(4)]))){
var statearr_38753_38790 = state_38726;
(statearr_38753_38790[(1)] = cljs.core.first.call(null,(state_38726[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38791 = state_38726;
state_38726 = G__38791;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10945__auto__ = function(state_38726){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10945__auto____1.call(this,state_38726);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10945__auto____0;
fluree$db$graphdb$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10945__auto____1;
return fluree$db$graphdb$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_38754 = f__11019__auto__.call(null);
(statearr_38754[(6)] = c__11018__auto__);

return statearr_38754;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5342__auto__,k__5343__auto__){
var self__ = this;
var this__5342__auto____$1 = this;
return this__5342__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5343__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5344__auto__,k38793,else__5345__auto__){
var self__ = this;
var this__5344__auto____$1 = this;
var G__38797 = k38793;
var G__38797__$1 = (((G__38797 instanceof cljs.core.Keyword))?G__38797.fqn:null);
switch (G__38797__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k38793,else__5345__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5362__auto__,f__5363__auto__,init__5364__auto__){
var self__ = this;
var this__5362__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5365__auto__,p__38798){
var vec__38799 = p__38798;
var k__5366__auto__ = cljs.core.nth.call(null,vec__38799,(0),null);
var v__5367__auto__ = cljs.core.nth.call(null,vec__38799,(1),null);
return f__5363__auto__.call(null,ret__5365__auto__,k__5366__auto__,v__5367__auto__);
}),init__5364__auto__,this__5362__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5357__auto__,writer__5358__auto__,opts__5359__auto__){
var self__ = this;
var this__5357__auto____$1 = this;
var pr_pair__5360__auto__ = (function (keyval__5361__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5358__auto__,cljs.core.pr_writer,""," ","",opts__5359__auto__,keyval__5361__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5358__auto__,pr_pair__5360__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__5359__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__38792){
var self__ = this;
var G__38792__$1 = this;
return (new cljs.core.RecordIter((0),G__38792__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5340__auto__){
var self__ = this;
var this__5340__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5337__auto__){
var self__ = this;
var this__5337__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5346__auto__){
var self__ = this;
var this__5346__auto____$1 = this;
return (20 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5339__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll.call(null,coll__5339__auto__));
}).call(null,this__5338__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this38794,other38795){
var self__ = this;
var this38794__$1 = this;
return (((!((other38795 == null)))) && ((((this38794__$1.constructor === other38795.constructor)) && (((cljs.core._EQ_.call(null,this38794__$1.conn,other38795.conn)) && (((cljs.core._EQ_.call(null,this38794__$1.network,other38795.network)) && (((cljs.core._EQ_.call(null,this38794__$1.dbid,other38795.dbid)) && (((cljs.core._EQ_.call(null,this38794__$1.block,other38795.block)) && (((cljs.core._EQ_.call(null,this38794__$1.t,other38795.t)) && (((cljs.core._EQ_.call(null,this38794__$1.tt_id,other38795.tt_id)) && (((cljs.core._EQ_.call(null,this38794__$1.stats,other38795.stats)) && (((cljs.core._EQ_.call(null,this38794__$1.spot,other38795.spot)) && (((cljs.core._EQ_.call(null,this38794__$1.psot,other38795.psot)) && (((cljs.core._EQ_.call(null,this38794__$1.post,other38795.post)) && (((cljs.core._EQ_.call(null,this38794__$1.opst,other38795.opst)) && (((cljs.core._EQ_.call(null,this38794__$1.schema,other38795.schema)) && (((cljs.core._EQ_.call(null,this38794__$1.settings,other38795.settings)) && (((cljs.core._EQ_.call(null,this38794__$1.index_configs,other38795.index_configs)) && (((cljs.core._EQ_.call(null,this38794__$1.schema_cache,other38795.schema_cache)) && (((cljs.core._EQ_.call(null,this38794__$1.novelty,other38795.novelty)) && (((cljs.core._EQ_.call(null,this38794__$1.permissions,other38795.permissions)) && (((cljs.core._EQ_.call(null,this38794__$1.fork,other38795.fork)) && (((cljs.core._EQ_.call(null,this38794__$1.fork_block,other38795.fork_block)) && (((cljs.core._EQ_.call(null,this38794__$1.current_db_fn,other38795.current_db_fn)) && (cljs.core._EQ_.call(null,this38794__$1.__extmap,other38795.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5352__auto__,k__5353__auto__){
var self__ = this;
var this__5352__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5353__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5352__auto____$1),self__.__meta),k__5353__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5353__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5349__auto__,k38793){
var self__ = this;
var this__5349__auto____$1 = this;
var G__38802 = k38793;
var G__38802__$1 = (((G__38802 instanceof cljs.core.Keyword))?G__38802.fqn:null);
switch (G__38802__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k38793);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5350__auto__,k__5351__auto__,G__38792){
var self__ = this;
var this__5350__auto____$1 = this;
var pred__38803 = cljs.core.keyword_identical_QMARK_;
var expr__38804 = k__5351__auto__;
if(cljs.core.truth_(pred__38803.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__38804))){
return (new fluree.db.graphdb.GraphDb(G__38792,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38803.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__38804))){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__38792,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38803.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__38804))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__38792,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38803.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__38804))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__38792,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38803.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__38804))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__38792,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38803.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__38804))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__38792,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38803.call(null,new cljs.core.Keyword(null,"stats","stats",-85643011),expr__38804))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__38792,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38803.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),expr__38804))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__38792,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38803.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),expr__38804))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__38792,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38803.call(null,new cljs.core.Keyword(null,"post","post",269697687),expr__38804))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__38792,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38803.call(null,new cljs.core.Keyword(null,"opst","opst",1213963058),expr__38804))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__38792,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38803.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__38804))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__38792,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38803.call(null,new cljs.core.Keyword(null,"settings","settings",1556144875),expr__38804))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__38792,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38803.call(null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),expr__38804))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__38792,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38803.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__38804))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__38792,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38803.call(null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),expr__38804))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__38792,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38803.call(null,new cljs.core.Keyword(null,"permissions","permissions",67803075),expr__38804))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__38792,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38803.call(null,new cljs.core.Keyword(null,"fork","fork",1062974235),expr__38804))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__38792,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38803.call(null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),expr__38804))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__38792,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38803.call(null,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),expr__38804))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__38792,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5351__auto__,G__38792),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5355__auto__){
var self__ = this;
var this__5355__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5341__auto__,G__38792){
var self__ = this;
var this__5341__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__38792,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5347__auto__,entry__5348__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5348__auto__)){
return this__5347__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5348__auto__,(0)),cljs.core._nth.call(null,entry__5348__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5347__auto____$1,entry__5348__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx.call(null,this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop.call(null,this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop.call(null,this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.call(null,this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query.call(null,this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"index-configs","index-configs",-1600476489,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__5388__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__5388__auto__,writer__5389__auto__){
return cljs.core._write.call(null,writer__5389__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__38796){
var extmap__5384__auto__ = (function (){var G__38806 = cljs.core.dissoc.call(null,G__38796,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
if(cljs.core.record_QMARK_.call(null,G__38796)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__38806);
} else {
return G__38806;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__38796),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__38796),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__38796),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__38796),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__38796),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__38796),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__38796),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__38796),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__38796),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__38796),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__38796),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__38796),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__38796),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280).cljs$core$IFn$_invoke$arity$1(G__38796),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__38796),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__38796),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__38796),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__38796),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__38796),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__38796),null,cljs.core.not_empty.call(null,extmap__5384__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write.call(null,w,"#FlureeGraphDB ");

return cljs.core._write.call(null,w,cljs.core.pr.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),db__$1.dbid,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.call(null,(function (m,idx){
var ss = clojure.data.avl.sorted_set_by.call(null,cljs.core.get_in.call(null,index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null)));
return cljs.core.assoc.call(null,m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.call(null,index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake.call(null,fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"conn","conn",278309663)],[(0),dbid,index_config,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.call(null,comparator,first_flake,child_node);
var idx_node = fluree.db.index.__GT_IndexNode.call(null,(0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_spot_novelty], null)),new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_psot_novelty], null)),new cljs.core.Keyword(null,"post","post",269697687),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_post_novelty], null)),new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map.call(null,fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var spot = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"post","post",269697687));
var opst = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"opst","opst",1213963058));
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb.call(null,conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
