// Compiled by ClojureScript 1.11.57 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__29675 = arguments.length;
switch (G__29675) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.call(null,operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null));
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__29678 = arguments.length;
switch (G__29678) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.call(null,conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__11018__auto___29731 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_29709){
var state_val_29710 = (state_29709[(1)]);
if((state_val_29710 === (1))){
var state_29709__$1 = state_29709;
var statearr_29711_29732 = state_29709__$1;
(statearr_29711_29732[(2)] = null);

(statearr_29711_29732[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29710 === (2))){
var _ = (function (){var statearr_29712 = state_29709;
(statearr_29712[(4)] = cljs.core.cons.call(null,(5),(state_29709[(4)])));

return statearr_29712;
})();
var inst_29686 = fluree.db.operations.conn_closed_QMARK_.call(null,conn);
var state_29709__$1 = state_29709;
if(cljs.core.truth_(inst_29686)){
var statearr_29713_29733 = state_29709__$1;
(statearr_29713_29733[(1)] = (6));

} else {
var statearr_29714_29734 = state_29709__$1;
(statearr_29714_29734[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29710 === (3))){
var inst_29707 = (state_29709[(2)]);
var state_29709__$1 = state_29709;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29709__$1,inst_29707);
} else {
if((state_val_29710 === (4))){
var inst_29679 = (state_29709[(2)]);
var inst_29680 = cljs.core.async.put_BANG_.call(null,pc,inst_29679);
var state_29709__$1 = state_29709;
var statearr_29716_29735 = state_29709__$1;
(statearr_29716_29735[(2)] = inst_29680);

(statearr_29716_29735[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29710 === (5))){
var _ = (function (){var statearr_29717 = state_29709;
(statearr_29717[(4)] = cljs.core.rest.call(null,(state_29709[(4)])));

return statearr_29717;
})();
var state_29709__$1 = state_29709;
var ex29715 = (state_29709__$1[(2)]);
var statearr_29718_29736 = state_29709__$1;
(statearr_29718_29736[(5)] = ex29715);


var statearr_29719_29737 = state_29709__$1;
(statearr_29719_29737[(1)] = (4));

(statearr_29719_29737[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29710 === (6))){
var inst_29688 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29689 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_29690 = cljs.core.PersistentHashMap.fromArrays(inst_29688,inst_29689);
var inst_29691 = cljs.core.ex_info.call(null,"Connection was closed.",inst_29690);
var inst_29692 = (function(){throw inst_29691})();
var state_29709__$1 = state_29709;
var statearr_29720_29738 = state_29709__$1;
(statearr_29720_29738[(2)] = inst_29692);

(statearr_29720_29738[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29710 === (7))){
var inst_29694 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_29695 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29696 = [operation,data,pc,opts];
var inst_29697 = (new cljs.core.PersistentVector(null,4,(5),inst_29695,inst_29696,null));
var inst_29698 = cljs.core.async.put_BANG_.call(null,inst_29694,inst_29697);
var inst_29699 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29700 = [operation,data,pc,opts];
var inst_29701 = (new cljs.core.PersistentVector(null,4,(5),inst_29699,inst_29700,null));
var inst_29702 = fluree.db.util.log.trace.call(null,"Put operation on connection req-chan: ",inst_29701);
var state_29709__$1 = (function (){var statearr_29721 = state_29709;
(statearr_29721[(7)] = inst_29698);

return statearr_29721;
})();
var statearr_29722_29739 = state_29709__$1;
(statearr_29722_29739[(2)] = inst_29702);

(statearr_29722_29739[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29710 === (8))){
var inst_29704 = (state_29709[(2)]);
var _ = (function (){var statearr_29723 = state_29709;
(statearr_29723[(4)] = cljs.core.rest.call(null,(state_29709[(4)])));

return statearr_29723;
})();
var state_29709__$1 = state_29709;
var statearr_29724_29740 = state_29709__$1;
(statearr_29724_29740[(2)] = inst_29704);

(statearr_29724_29740[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__10945__auto__ = null;
var fluree$db$operations$state_machine__10945__auto____0 = (function (){
var statearr_29725 = [null,null,null,null,null,null,null,null];
(statearr_29725[(0)] = fluree$db$operations$state_machine__10945__auto__);

(statearr_29725[(1)] = (1));

return statearr_29725;
});
var fluree$db$operations$state_machine__10945__auto____1 = (function (state_29709){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_29709);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e29726){var ex__10948__auto__ = e29726;
var statearr_29727_29741 = state_29709;
(statearr_29727_29741[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_29709[(4)]))){
var statearr_29728_29742 = state_29709;
(statearr_29728_29742[(1)] = cljs.core.first.call(null,(state_29709[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29743 = state_29709;
state_29709 = G__29743;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$operations$state_machine__10945__auto__ = function(state_29709){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__10945__auto____1.call(this,state_29709);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__10945__auto____0;
fluree$db$operations$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__10945__auto____1;
return fluree$db$operations$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_29729 = f__11019__auto__.call(null);
(statearr_29729[(6)] = c__11018__auto___29731);

return statearr_29729;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__29745 = arguments.length;
switch (G__29745) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.call(null,session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__29746){
var map__29747 = p__29746;
var map__29747__$1 = cljs.core.__destructure_map.call(null,map__29747);
var opts = map__29747__$1;
var snapshot_QMARK_ = cljs.core.get.call(null,map__29747__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__29748 = session;
var map__29748__$1 = cljs.core.__destructure_map.call(null,map__29748);
var dbid = cljs.core.get.call(null,map__29748__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var network = cljs.core.get.call(null,map__29748__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__29748__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),dbid,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__5774__auto__ = [];
var len__5768__auto___29775 = arguments.length;
var i__5769__auto___29776 = (0);
while(true){
if((i__5769__auto___29776 < len__5768__auto___29775)){
args__5774__auto__.push((arguments[i__5769__auto___29776]));

var G__29777 = (i__5769__auto___29776 + (1));
i__5769__auto___29776 = G__29777;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__29752){
var vec__29753 = p__29752;
var map__29756 = cljs.core.nth.call(null,vec__29753,(0),null);
var map__29756__$1 = cljs.core.__destructure_map.call(null,map__29756);
var toBlock = cljs.core.get.call(null,map__29756__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.call(null,map__29756__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__29753;
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_29768){
var state_val_29769 = (state_29768[(1)]);
if((state_val_29769 === (1))){
var inst_29758 = session;
var inst_29759 = cljs.core.__destructure_map.call(null,inst_29758);
var inst_29760 = cljs.core.get.call(null,inst_29759,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_29761 = cljs.core.get.call(null,inst_29759,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_29762 = cljs.core.get.call(null,inst_29759,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_29763 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_29764 = [inst_29760,inst_29761,toBlock,toTime];
var inst_29765 = cljs.core.PersistentHashMap.fromArrays(inst_29763,inst_29764);
var inst_29766 = fluree.db.operations.send_operation.call(null,inst_29762,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_29765);
var state_29768__$1 = state_29768;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29768__$1,inst_29766);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__10945__auto__ = null;
var fluree$db$operations$state_machine__10945__auto____0 = (function (){
var statearr_29770 = [null,null,null,null,null,null,null];
(statearr_29770[(0)] = fluree$db$operations$state_machine__10945__auto__);

(statearr_29770[(1)] = (1));

return statearr_29770;
});
var fluree$db$operations$state_machine__10945__auto____1 = (function (state_29768){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_29768);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e29771){var ex__10948__auto__ = e29771;
var statearr_29772_29778 = state_29768;
(statearr_29772_29778[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_29768[(4)]))){
var statearr_29773_29779 = state_29768;
(statearr_29773_29779[(1)] = cljs.core.first.call(null,(state_29768[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29780 = state_29768;
state_29768 = G__29780;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$operations$state_machine__10945__auto__ = function(state_29768){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__10945__auto____1.call(this,state_29768);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__10945__auto____0;
fluree$db$operations$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__10945__auto____1;
return fluree$db$operations$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_29774 = f__11019__auto__.call(null);
(statearr_29774[(6)] = c__11018__auto__);

return statearr_29774;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq29750){
var G__29751 = cljs.core.first.call(null,seq29750);
var seq29750__$1 = cljs.core.next.call(null,seq29750);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29751,seq29750__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__29781 = session;
var map__29781__$1 = cljs.core.__destructure_map.call(null,map__29781);
var network = cljs.core.get.call(null,map__29781__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__29781__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var conn = cljs.core.get.call(null,map__29781__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"snapshot-ledger","snapshot-ledger",-1972847996),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-list","ledger-list",-945136952),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.call(null,"Sending transaction async: ",tx_map);

return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__29783 = arguments.length;
switch (G__29783) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.call(null,session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__29784 = opts;
var map__29784__$1 = cljs.core.__destructure_map.call(null,map__29784);
var auth = cljs.core.get.call(null,map__29784__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__29784__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__5045__auto__ = auth;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.call(null,"Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsbuscribe","unsbuscribe",888593047),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null));
});
