// Compiled by ClojureScript 1.11.57 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (((cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"#")) && (cljs.core._EQ_.call(null,cljs.core.second.call(null,cljs.core.name.call(null,form)),"(")))))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"\"")) && (cljs.core._EQ_.call(null,cljs.core.last.call(null,cljs.core.name.call(null,form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.call(null,string);
}catch (e31051){var e = e31051;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some.call(null,(function (p1__31052_SHARP_){
var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,p1__31052_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.coll_QMARK_.call(null,p1__31052_SHARP_)){
return fluree.db.query.analytical.get_vars.call(null,p1__31052_SHARP_);
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv.call(null,(function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_.call(null,key);
var static_value = cljs.core.get.call(null,interm_vars,key_as_var);
if(((cljs.core._EQ_.call(null,idx,(1))) && (((cljs.core.not.call(null,key_as_var)) && (((cljs.core.not_EQ_.call(null,"_id",key)) && (cljs.core.not.call(null,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find.call(null,/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.call(null,["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__31053_SHARP_){
return cljs.core.conj.call(null,p1__31053_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__31054_SHARP_){
return cljs.core.conj.call(null,p1__31054_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.query.analytical.internal_filter_QMARK_.call(null,key);
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.call(null,idx,(2));
} else {
return and__5043__auto__;
}
})())){
var filter_code = cljs.reader.read_string.call(null,cljs.core.subs.call(null,key,(1)));
var var$ = (function (){var or__5045__auto__ = fluree.db.query.analytical.get_vars.call(null,filter_code);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__31059 = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.call(null,vec__31059,(0),null);
var _ = cljs.core.nth.call(null,vec__31059,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn.call(null,var$,fun);
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__31055_SHARP_){
return cljs.core.conj.call(null,p1__31055_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.call(null,idx,(1));
if(and__5043__auto__){
return cljs.core.re_find.call(null,/\+/,key);
} else {
return and__5043__auto__;
}
})())){
var vec__31062 = clojure.string.split.call(null,key,/\+/);
var pred = cljs.core.nth.call(null,vec__31062,(0),null);
var recur_amt = cljs.core.nth.call(null,vec__31062,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__5045__auto__ = fluree.db.query.analytical.safe_read_string.call(null,recur_amt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__31056_SHARP_){
return cljs.core.conj.call(null,p1__31056_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_.call(null,key)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__31057_SHARP_){
return cljs.core.conj.call(null,p1__31057_SHARP_,fluree.db.query.analytical.safe_read_string.call(null,key));
}));
} else {
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__31058_SHARP_){
return cljs.core.conj.call(null,p1__31058_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.call(null,(function (array){
return cljs.core.map.call(null,(function (p1__31065_SHARP_){
return cljs.core.nth.call(null,array,p1__31065_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.call(null,(function (acc,var$){
var temp__5802__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var$);
if(cljs.core.truth_(temp__5802__auto__)){
var var$__$1 = temp__5802__auto__;
return cljs.core.conj.call(null,acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys.call(null,clause);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(rel_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(a_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.call(null,(function (acc,var_smt){
var temp__5802__auto__ = (function (){var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var_smt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var var$ = temp__5802__auto__;
return cljs.core.conj.call(null,acc,fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays.call(null,ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (add_amount > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fuel;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.volatile_QMARK_.call(null,fuel);
} else {
return and__5043__auto__;
}
})())){
return cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.call(null,(function (clause){
return cljs.core.mapv.call(null,(function (clause_item){
var temp__5802__auto__ = intersecting_vars.call(null,cljs.core.symbol.call(null,clause_item));
if(cljs.core.truth_(temp__5802__auto__)){
var key_replace = temp__5802__auto__;
var replacement = cljs.core.get.call(null,vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.call(null,replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__31068,optional_QMARK_,fuel,max_fuel){
var map__31069 = p__31068;
var map__31069__$1 = cljs.core.__destructure_map.call(null,map__31069);
var res = map__31069__$1;
var vars = cljs.core.get.call(null,map__31069__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_31135){
var state_val_31136 = (state_31135[(1)]);
if((state_val_31136 === (7))){
var inst_31124 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31125 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses.call(null,r);
var inst_31126 = cljs.core.conj.call(null,inst_31125,clause);
var inst_31127 = [null,inst_31126];
var inst_31128 = (new cljs.core.PersistentVector(null,2,(5),inst_31124,inst_31127,null));
var state_31135__$1 = state_31135;
var statearr_31137_31165 = state_31135__$1;
(statearr_31137_31165[(2)] = inst_31128);

(statearr_31137_31165[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31136 === (1))){
var state_31135__$1 = state_31135;
var statearr_31138_31166 = state_31135__$1;
(statearr_31138_31166[(2)] = null);

(statearr_31138_31166[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31136 === (4))){
var inst_31070 = (state_31135[(2)]);
var state_31135__$1 = state_31135;
var statearr_31139_31167 = state_31135__$1;
(statearr_31139_31167[(2)] = inst_31070);

(statearr_31139_31167[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31136 === (15))){
var inst_31113 = (state_31135[(2)]);
var inst_31114 = fluree.db.util.async.throw_err.call(null,inst_31113);
var inst_31115 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_31114);
var inst_31116 = cljs.core.count.call(null,inst_31115);
var inst_31117 = fluree.db.query.analytical.add_fuel.call(null,inst_31116,fuel,max_fuel);
var inst_31118 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31119 = [inst_31114,r];
var inst_31120 = (new cljs.core.PersistentVector(null,2,(5),inst_31118,inst_31119,null));
var state_31135__$1 = (function (){var statearr_31140 = state_31135;
(statearr_31140[(7)] = inst_31117);

return statearr_31140;
})();
var statearr_31141_31168 = state_31135__$1;
(statearr_31141_31168[(2)] = inst_31120);

(statearr_31141_31168[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31136 === (13))){
var inst_31079 = (state_31135[(8)]);
var inst_31092 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_31093 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses.call(null,inst_31092);
var inst_31094 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_31079);
var inst_31095 = cljs.core.apply.call(null,cljs.core.concat,inst_31094);
var inst_31096 = cljs.core.set.call(null,inst_31095);
var inst_31097 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_31093);
var inst_31098 = cljs.core.apply.call(null,cljs.core.concat,inst_31097);
var inst_31099 = cljs.core.into.call(null,inst_31096,inst_31098);
var inst_31100 = (function (){var all_wd = inst_31079;
var optional = inst_31093;
var all_wd_vars = inst_31096;
var all_vars = inst_31099;
return (function (p1__31066_SHARP_){
return all_vars.call(null,p1__31066_SHARP_);
});
})();
var inst_31101 = cljs.core.keys.call(null,vars);
var inst_31102 = cljs.core.map.call(null,inst_31100,inst_31101);
var inst_31103 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_31102);
var inst_31104 = cljs.core.set.call(null,inst_31103);
var inst_31105 = (function (){var all_wd = inst_31079;
var optional = inst_31093;
var all_wd_vars = inst_31096;
var all_vars = inst_31099;
var intersecting_vars = inst_31104;
return (function (p1__31067_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,p1__31067_SHARP_);
});
})();
var inst_31106 = cljs.core.map.call(null,inst_31105,inst_31079);
var inst_31107 = cljs.core.apply.call(null,cljs.core.concat,inst_31106);
var inst_31108 = fluree.db.query.analytical.select_from_tuples.call(null,inst_31107,res);
var inst_31109 = fluree.db.query.analytical.replace_vars_wikidata.call(null,inst_31079,inst_31104,vars);
var inst_31110 = cljs.core.remove.call(null,inst_31104,inst_31099);
var inst_31111 = fluree.db.query.analytical_wikidata.get_wikidata_tuples.call(null,q_map,inst_31109,inst_31107,inst_31108,inst_31110,inst_31093);
var state_31135__$1 = state_31135;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31135__$1,(15),inst_31111);
} else {
if((state_val_31136 === (6))){
var inst_31080 = (state_31135[(9)]);
var inst_31078 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_31079 = fluree.db.query.analytical_wikidata.get_all_wd_clauses.call(null,inst_31078);
var inst_31080__$1 = optional_QMARK_;
var state_31135__$1 = (function (){var statearr_31142 = state_31135;
(statearr_31142[(8)] = inst_31079);

(statearr_31142[(9)] = inst_31080__$1);

return statearr_31142;
})();
if(cljs.core.truth_(inst_31080__$1)){
var statearr_31143_31169 = state_31135__$1;
(statearr_31143_31169[(1)] = (9));

} else {
var statearr_31144_31170 = state_31135__$1;
(statearr_31144_31170[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31136 === (3))){
var inst_31133 = (state_31135[(2)]);
var state_31135__$1 = state_31135;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31135__$1,inst_31133);
} else {
if((state_val_31136 === (12))){
var inst_31088 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31089 = [null,r];
var inst_31090 = (new cljs.core.PersistentVector(null,2,(5),inst_31088,inst_31089,null));
var state_31135__$1 = state_31135;
var statearr_31145_31171 = state_31135__$1;
(statearr_31145_31171[(2)] = inst_31090);

(statearr_31145_31171[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31136 === (2))){
var _ = (function (){var statearr_31146 = state_31135;
(statearr_31146[(4)] = cljs.core.cons.call(null,(5),(state_31135[(4)])));

return statearr_31146;
})();
var inst_31076 = (r == null);
var state_31135__$1 = state_31135;
if(cljs.core.truth_(inst_31076)){
var statearr_31147_31172 = state_31135__$1;
(statearr_31147_31172[(1)] = (6));

} else {
var statearr_31148_31173 = state_31135__$1;
(statearr_31148_31173[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31136 === (11))){
var inst_31086 = (state_31135[(2)]);
var state_31135__$1 = state_31135;
if(cljs.core.truth_(inst_31086)){
var statearr_31150_31174 = state_31135__$1;
(statearr_31150_31174[(1)] = (12));

} else {
var statearr_31151_31175 = state_31135__$1;
(statearr_31151_31175[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31136 === (9))){
var inst_31079 = (state_31135[(8)]);
var inst_31082 = cljs.core.empty_QMARK_.call(null,inst_31079);
var inst_31083 = (!(inst_31082));
var state_31135__$1 = state_31135;
var statearr_31152_31176 = state_31135__$1;
(statearr_31152_31176[(2)] = inst_31083);

(statearr_31152_31176[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31136 === (5))){
var _ = (function (){var statearr_31153 = state_31135;
(statearr_31153[(4)] = cljs.core.rest.call(null,(state_31135[(4)])));

return statearr_31153;
})();
var state_31135__$1 = state_31135;
var ex31149 = (state_31135__$1[(2)]);
var statearr_31154_31177 = state_31135__$1;
(statearr_31154_31177[(5)] = ex31149);


if((ex31149 instanceof Error)){
var statearr_31155_31178 = state_31135__$1;
(statearr_31155_31178[(1)] = (4));

(statearr_31155_31178[(5)] = null);

} else {
throw ex31149;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31136 === (14))){
var inst_31122 = (state_31135[(2)]);
var state_31135__$1 = state_31135;
var statearr_31156_31179 = state_31135__$1;
(statearr_31156_31179[(2)] = inst_31122);

(statearr_31156_31179[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31136 === (10))){
var inst_31080 = (state_31135[(9)]);
var state_31135__$1 = state_31135;
var statearr_31157_31180 = state_31135__$1;
(statearr_31157_31180[(2)] = inst_31080);

(statearr_31157_31180[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31136 === (8))){
var inst_31130 = (state_31135[(2)]);
var _ = (function (){var statearr_31158 = state_31135;
(statearr_31158[(4)] = cljs.core.rest.call(null,(state_31135[(4)])));

return statearr_31158;
})();
var state_31135__$1 = state_31135;
var statearr_31159_31181 = state_31135__$1;
(statearr_31159_31181[(2)] = inst_31130);

(statearr_31159_31181[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10945__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10945__auto____0 = (function (){
var statearr_31160 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31160[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10945__auto__);

(statearr_31160[(1)] = (1));

return statearr_31160;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10945__auto____1 = (function (state_31135){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_31135);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e31161){var ex__10948__auto__ = e31161;
var statearr_31162_31182 = state_31135;
(statearr_31162_31182[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_31135[(4)]))){
var statearr_31163_31183 = state_31135;
(statearr_31163_31183[(1)] = cljs.core.first.call(null,(state_31135[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31184 = state_31135;
state_31135 = G__31184;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10945__auto__ = function(state_31135){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10945__auto____1.call(this,state_31135);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10945__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10945__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_31164 = f__11019__auto__.call(null);
(statearr_31164[(6)] = c__11018__auto__);

return statearr_31164;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string.call(null,block);
if(cljs.core.int_QMARK_.call(null,block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find.call(null,/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find.call(null,/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__31186 = arguments.length;
switch (G__31186) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.call(null,db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_31280){
var state_val_31281 = (state_31280[(1)]);
if((state_val_31281 === (7))){
var inst_31193 = (state_31280[(7)]);
var inst_31203 = clojure.string.starts_with_QMARK_.call(null,inst_31193,"$fdb");
var state_31280__$1 = state_31280;
if(inst_31203){
var statearr_31282_31331 = state_31280__$1;
(statearr_31282_31331[(1)] = (9));

} else {
var statearr_31283_31332 = state_31280__$1;
(statearr_31283_31332[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31281 === (20))){
var state_31280__$1 = state_31280;
var statearr_31284_31333 = state_31280__$1;
(statearr_31284_31333[(2)] = null);

(statearr_31284_31333[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31281 === (27))){
var inst_31243 = (state_31280[(8)]);
var state_31280__$1 = state_31280;
var statearr_31285_31334 = state_31280__$1;
(statearr_31285_31334[(2)] = inst_31243);

(statearr_31285_31334[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31281 === (1))){
var state_31280__$1 = state_31280;
var statearr_31286_31335 = state_31280__$1;
(statearr_31286_31335[(2)] = null);

(statearr_31286_31335[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31281 === (24))){
var inst_31266 = (state_31280[(2)]);
var state_31280__$1 = state_31280;
var statearr_31287_31336 = state_31280__$1;
(statearr_31287_31336[(2)] = inst_31266);

(statearr_31287_31336[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31281 === (4))){
var inst_31187 = (state_31280[(2)]);
var state_31280__$1 = state_31280;
var statearr_31288_31337 = state_31280__$1;
(statearr_31288_31337[(2)] = inst_31187);

(statearr_31288_31337[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31281 === (15))){
var inst_31210 = (state_31280[(9)]);
var inst_31216 = (state_31280[(2)]);
var inst_31217 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31218 = cljs.core.PersistentVector.EMPTY;
var inst_31219 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_31220 = cljs.core.into.call(null,inst_31218,inst_31219);
var inst_31221 = [inst_31210,inst_31220];
var inst_31222 = (new cljs.core.PersistentVector(null,2,(5),inst_31217,inst_31221,null));
var state_31280__$1 = (function (){var statearr_31289 = state_31280;
(statearr_31289[(10)] = inst_31216);

return statearr_31289;
})();
var statearr_31290_31338 = state_31280__$1;
(statearr_31290_31338[(2)] = inst_31222);

(statearr_31290_31338[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31281 === (21))){
var inst_31269 = (state_31280[(2)]);
var state_31280__$1 = state_31280;
var statearr_31291_31339 = state_31280__$1;
(statearr_31291_31339[(2)] = inst_31269);

(statearr_31291_31339[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31281 === (13))){
var inst_31210 = (state_31280[(9)]);
var inst_31213 = (function(){throw inst_31210})();
var state_31280__$1 = state_31280;
var statearr_31292_31340 = state_31280__$1;
(statearr_31292_31340[(2)] = inst_31213);

(statearr_31292_31340[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31281 === (22))){
var inst_31232 = (state_31280[(11)]);
var inst_31234 = (state_31280[(12)]);
var inst_31236 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_31232);
var inst_31237 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31238 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_31234];
var inst_31239 = (new cljs.core.PersistentVector(null,2,(5),inst_31237,inst_31238,null));
var inst_31240 = cljs.core.get_in.call(null,opts,inst_31239);
var state_31280__$1 = (function (){var statearr_31293 = state_31280;
(statearr_31293[(13)] = inst_31236);

return statearr_31293;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31280__$1,(25),inst_31240);
} else {
if((state_val_31281 === (29))){
var inst_31247 = (state_31280[(2)]);
var inst_31248 = fluree.db.util.async.throw_err.call(null,inst_31247);
var state_31280__$1 = state_31280;
var statearr_31294_31341 = state_31280__$1;
(statearr_31294_31341[(2)] = inst_31248);

(statearr_31294_31341[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31281 === (6))){
var inst_31196 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31197 = cljs.core.PersistentVector.EMPTY;
var inst_31198 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_31199 = cljs.core.into.call(null,inst_31197,inst_31198);
var inst_31200 = [db,inst_31199];
var inst_31201 = (new cljs.core.PersistentVector(null,2,(5),inst_31196,inst_31200,null));
var state_31280__$1 = state_31280;
var statearr_31295_31342 = state_31280__$1;
(statearr_31295_31342[(2)] = inst_31201);

(statearr_31295_31342[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31281 === (28))){
var inst_31251 = (state_31280[(2)]);
var inst_31252 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31253 = cljs.core.PersistentVector.EMPTY;
var inst_31254 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_31255 = cljs.core.into.call(null,inst_31253,inst_31254);
var inst_31256 = [inst_31251,inst_31255];
var inst_31257 = (new cljs.core.PersistentVector(null,2,(5),inst_31252,inst_31256,null));
var state_31280__$1 = state_31280;
var statearr_31296_31343 = state_31280__$1;
(statearr_31296_31343[(2)] = inst_31257);

(statearr_31296_31343[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31281 === (25))){
var inst_31236 = (state_31280[(13)]);
var inst_31242 = (state_31280[(2)]);
var inst_31243 = fluree.db.util.async.throw_err.call(null,inst_31242);
var state_31280__$1 = (function (){var statearr_31297 = state_31280;
(statearr_31297[(8)] = inst_31243);

return statearr_31297;
})();
if(cljs.core.truth_(inst_31236)){
var statearr_31298_31344 = state_31280__$1;
(statearr_31298_31344[(1)] = (26));

} else {
var statearr_31299_31345 = state_31280__$1;
(statearr_31299_31345[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31281 === (17))){
var state_31280__$1 = state_31280;
var statearr_31300_31346 = state_31280__$1;
(statearr_31300_31346[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31281 === (3))){
var inst_31278 = (state_31280[(2)]);
var state_31280__$1 = state_31280;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31280__$1,inst_31278);
} else {
if((state_val_31281 === (12))){
var inst_31210 = (state_31280[(9)]);
var inst_31209 = (state_31280[(2)]);
var inst_31210__$1 = fluree.db.util.async.throw_err.call(null,inst_31209);
var inst_31211 = fluree.db.util.core.exception_QMARK_.call(null,inst_31210__$1);
var state_31280__$1 = (function (){var statearr_31302 = state_31280;
(statearr_31302[(9)] = inst_31210__$1);

return statearr_31302;
})();
if(inst_31211){
var statearr_31303_31347 = state_31280__$1;
(statearr_31303_31347[(1)] = (13));

} else {
var statearr_31304_31348 = state_31280__$1;
(statearr_31304_31348[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31281 === (2))){
var inst_31193 = (state_31280[(7)]);
var _ = (function (){var statearr_31305 = state_31280;
(statearr_31305[(4)] = cljs.core.cons.call(null,(5),(state_31280[(4)])));

return statearr_31305;
})();
var inst_31193__$1 = cljs.core.first.call(null,clause);
var inst_31194 = cljs.core._EQ_.call(null,"$fdb",inst_31193__$1);
var state_31280__$1 = (function (){var statearr_31306 = state_31280;
(statearr_31306[(7)] = inst_31193__$1);

return statearr_31306;
})();
if(inst_31194){
var statearr_31307_31349 = state_31280__$1;
(statearr_31307_31349[(1)] = (6));

} else {
var statearr_31308_31350 = state_31280__$1;
(statearr_31308_31350[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31281 === (23))){
var inst_31193 = (state_31280[(7)]);
var inst_31259 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31193)," is not supported in Fluree"].join('');
var inst_31260 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_31261 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_31262 = cljs.core.PersistentHashMap.fromArrays(inst_31260,inst_31261);
var inst_31263 = cljs.core.ex_info.call(null,inst_31259,inst_31262);
var inst_31264 = (function(){throw inst_31263})();
var state_31280__$1 = state_31280;
var statearr_31309_31351 = state_31280__$1;
(statearr_31309_31351[(2)] = inst_31264);

(statearr_31309_31351[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31281 === (19))){
var inst_31234 = (state_31280[(12)]);
var inst_31193 = (state_31280[(7)]);
var inst_31231 = fluree.db.query.analytical.isolate_source_name.call(null,inst_31193);
var inst_31232 = fluree.db.query.analytical.isolate_source_block.call(null,inst_31193);
var inst_31233 = cljs.core.keyword.call(null,inst_31231);
var inst_31234__$1 = cljs.core.get.call(null,prefixes,inst_31233);
var state_31280__$1 = (function (){var statearr_31310 = state_31280;
(statearr_31310[(11)] = inst_31232);

(statearr_31310[(12)] = inst_31234__$1);

return statearr_31310;
})();
if(cljs.core.truth_(inst_31234__$1)){
var statearr_31311_31352 = state_31280__$1;
(statearr_31311_31352[(1)] = (22));

} else {
var statearr_31312_31353 = state_31280__$1;
(statearr_31312_31353[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31281 === (11))){
var inst_31273 = (state_31280[(2)]);
var state_31280__$1 = state_31280;
var statearr_31314_31354 = state_31280__$1;
(statearr_31314_31354[(2)] = inst_31273);

(statearr_31314_31354[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31281 === (9))){
var inst_31193 = (state_31280[(7)]);
var inst_31205 = cljs.core.subs.call(null,inst_31193,(4));
var inst_31206 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_31205);
var inst_31207 = fluree.db.time_travel.as_of_block.call(null,db,inst_31206);
var state_31280__$1 = state_31280;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31280__$1,(12),inst_31207);
} else {
if((state_val_31281 === (5))){
var _ = (function (){var statearr_31315 = state_31280;
(statearr_31315[(4)] = cljs.core.rest.call(null,(state_31280[(4)])));

return statearr_31315;
})();
var state_31280__$1 = state_31280;
var ex31313 = (state_31280__$1[(2)]);
var statearr_31316_31355 = state_31280__$1;
(statearr_31316_31355[(5)] = ex31313);


if((ex31313 instanceof Error)){
var statearr_31317_31356 = state_31280__$1;
(statearr_31317_31356[(1)] = (4));

(statearr_31317_31356[(5)] = null);

} else {
throw ex31313;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31281 === (14))){
var state_31280__$1 = state_31280;
var statearr_31318_31357 = state_31280__$1;
(statearr_31318_31357[(2)] = null);

(statearr_31318_31357[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31281 === (26))){
var inst_31236 = (state_31280[(13)]);
var inst_31243 = (state_31280[(8)]);
var inst_31245 = fluree.db.time_travel.as_of_block.call(null,inst_31243,inst_31236);
var state_31280__$1 = state_31280;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31280__$1,(29),inst_31245);
} else {
if((state_val_31281 === (16))){
var inst_31226 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31227 = ["$wd",clause];
var inst_31228 = (new cljs.core.PersistentVector(null,2,(5),inst_31226,inst_31227,null));
var state_31280__$1 = state_31280;
var statearr_31319_31358 = state_31280__$1;
(statearr_31319_31358[(2)] = inst_31228);

(statearr_31319_31358[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31281 === (10))){
var inst_31193 = (state_31280[(7)]);
var inst_31224 = cljs.core._EQ_.call(null,"$wd",inst_31193);
var state_31280__$1 = state_31280;
if(inst_31224){
var statearr_31320_31359 = state_31280__$1;
(statearr_31320_31359[(1)] = (16));

} else {
var statearr_31321_31360 = state_31280__$1;
(statearr_31321_31360[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31281 === (18))){
var inst_31271 = (state_31280[(2)]);
var state_31280__$1 = state_31280;
var statearr_31322_31361 = state_31280__$1;
(statearr_31322_31361[(2)] = inst_31271);

(statearr_31322_31361[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31281 === (8))){
var inst_31275 = (state_31280[(2)]);
var _ = (function (){var statearr_31323 = state_31280;
(statearr_31323[(4)] = cljs.core.rest.call(null,(state_31280[(4)])));

return statearr_31323;
})();
var state_31280__$1 = state_31280;
var statearr_31324_31362 = state_31280__$1;
(statearr_31324_31362[(2)] = inst_31275);

(statearr_31324_31362[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__10945__auto__ = null;
var fluree$db$query$analytical$state_machine__10945__auto____0 = (function (){
var statearr_31325 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31325[(0)] = fluree$db$query$analytical$state_machine__10945__auto__);

(statearr_31325[(1)] = (1));

return statearr_31325;
});
var fluree$db$query$analytical$state_machine__10945__auto____1 = (function (state_31280){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_31280);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e31326){var ex__10948__auto__ = e31326;
var statearr_31327_31363 = state_31280;
(statearr_31327_31363[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_31280[(4)]))){
var statearr_31328_31364 = state_31280;
(statearr_31328_31364[(1)] = cljs.core.first.call(null,(state_31280[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31365 = state_31280;
state_31280 = G__31365;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__10945__auto__ = function(state_31280){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__10945__auto____1.call(this,state_31280);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__10945__auto____0;
fluree$db$query$analytical$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__10945__auto____1;
return fluree$db$query$analytical$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_31329 = f__11019__auto__.call(null);
(statearr_31329[(6)] = c__11018__auto__);

return statearr_31329;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.call(null,(function (acc,p__31366){
var vec__31367 = p__31366;
var sub = cljs.core.nth.call(null,vec__31367,(0),null);
var obj = cljs.core.nth.call(null,vec__31367,(1),null);
return cljs.core.update.call(null,acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap.call(null,cljs.core.keys.call(null,tuple_map),cljs.core.map.call(null,(function (p1__31370_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set.call(null,p1__31370_SHARP_)]);
}),cljs.core.vals.call(null,tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map.call(null,tuple_map);
var G__31374 = subjects;
var vec__31375 = G__31374;
var seq__31376 = cljs.core.seq.call(null,vec__31375);
var first__31377 = cljs.core.first.call(null,seq__31376);
var seq__31376__$1 = cljs.core.next.call(null,seq__31376);
var subject = first__31377;
var r = seq__31376__$1;
var acc = expanded_map;
var G__31374__$1 = G__31374;
var acc__$1 = acc;
while(true){
var vec__31381 = G__31374__$1;
var seq__31382 = cljs.core.seq.call(null,vec__31381);
var first__31383 = cljs.core.first.call(null,seq__31382);
var seq__31382__$1 = cljs.core.next.call(null,seq__31382);
var subject__$1 = first__31383;
var r__$1 = seq__31382__$1;
var acc__$2 = acc__$1;
if(cljs.core.not.call(null,subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__31384 = r__$1;
var G__31385 = acc__$2;
G__31374__$1 = G__31384;
acc__$1 = G__31385;
continue;
} else {
var subject_all = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.call(null,subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.call(null,((function (G__31374__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__31381,seq__31382,first__31383,seq__31382__$1,subject__$1,r__$1,acc__$2,G__31374,vec__31375,seq__31376,first__31377,seq__31376__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.call(null,subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:all_followed.call(null,subject_to_follow));
var acc_SINGLEQUOTE_ = cljs.core.update_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__5045__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__31374__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__31381,seq__31382,first__31383,seq__31382__$1,subject__$1,r__$1,acc__$2,G__31374,vec__31375,seq__31376,first__31377,seq__31376__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__31374__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__31381,seq__31382,first__31383,seq__31382__$1,subject__$1,r__$1,acc__$2,G__31374,vec__31375,seq__31376,first__31377,seq__31376__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__31374__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__31381,seq__31382,first__31383,seq__31382__$1,subject__$1,r__$1,acc__$2,G__31374,vec__31375,seq__31376,first__31377,seq__31376__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__31374__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__31381,seq__31382,first__31383,seq__31382__$1,subject__$1,r__$1,acc__$2,G__31374,vec__31375,seq__31376,first__31377,seq__31376__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__31374__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__31381,seq__31382,first__31383,seq__31382__$1,subject__$1,r__$1,acc__$2,G__31374,vec__31375,seq__31376,first__31377,seq__31376__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.call(null,subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__31386 = r__$1;
var G__31387 = cljs.core.assoc_in.call(null,acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__31374__$1 = G__31386;
acc__$1 = G__31387;
continue;
} else {
var G__31388 = subjects;
var G__31389 = acc_STAR_;
G__31374__$1 = G__31388;
acc__$1 = G__31389;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.call(null,(function (acc,subject){
var subject_vals = cljs.core.get_in.call(null,recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.call(null,acc,cljs.core.map.call(null,(function (p1__31390_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__31390_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_31481){
var state_val_31482 = (state_31481[(1)]);
if((state_val_31482 === (7))){
var state_31481__$1 = state_31481;
var statearr_31483_31529 = state_31481__$1;
(statearr_31483_31529[(2)] = (100));

(statearr_31483_31529[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31482 === (20))){
var inst_31430 = (state_31481[(7)]);
var state_31481__$1 = state_31481;
var statearr_31484_31530 = state_31481__$1;
(statearr_31484_31530[(2)] = inst_31430);

(statearr_31484_31530[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31482 === (1))){
var state_31481__$1 = state_31481;
var statearr_31485_31531 = state_31481__$1;
(statearr_31485_31531[(2)] = null);

(statearr_31485_31531[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31482 === (24))){
var inst_31469 = (state_31481[(8)]);
var inst_31402 = (state_31481[(9)]);
var inst_31468 = (state_31481[(10)]);
var inst_31467 = (state_31481[(11)]);
var inst_31472 = (function (){var max_depth = inst_31402;
var recur_map__$1 = inst_31468;
var subjects = inst_31467;
var tuples = inst_31469;
return (function (p1__31391_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second.call(null,p1__31391_SHARP_)],null));
});
})();
var inst_31473 = cljs.core.map.call(null,inst_31472,inst_31469);
var inst_31474 = cljs.core.distinct.call(null,inst_31473);
var state_31481__$1 = state_31481;
var statearr_31486_31532 = state_31481__$1;
(statearr_31486_31532[(2)] = inst_31474);

(statearr_31486_31532[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31482 === (4))){
var inst_31392 = (state_31481[(2)]);
var state_31481__$1 = state_31481;
var statearr_31487_31533 = state_31481__$1;
(statearr_31487_31533[(2)] = inst_31392);

(statearr_31487_31533[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31482 === (15))){
var inst_31415 = (state_31481[(12)]);
var inst_31426 = cljs.core.PersistentVector.EMPTY;
var inst_31427 = cljs.core.seq.call(null,inst_31415);
var inst_31428 = cljs.core.first.call(null,inst_31427);
var inst_31429 = cljs.core.next.call(null,inst_31427);
var inst_31430 = inst_31426;
var inst_31431 = inst_31415;
var state_31481__$1 = (function (){var statearr_31488 = state_31481;
(statearr_31488[(13)] = inst_31429);

(statearr_31488[(14)] = inst_31431);

(statearr_31488[(7)] = inst_31430);

(statearr_31488[(15)] = inst_31428);

return statearr_31488;
})();
var statearr_31489_31534 = state_31481__$1;
(statearr_31489_31534[(2)] = null);

(statearr_31489_31534[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31482 === (21))){
var inst_31451 = (state_31481[(2)]);
var state_31481__$1 = state_31481;
var statearr_31490_31535 = state_31481__$1;
(statearr_31490_31535[(2)] = inst_31451);

(statearr_31490_31535[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31482 === (13))){
var inst_31464 = (state_31481[(2)]);
var state_31481__$1 = state_31481;
var statearr_31491_31536 = state_31481__$1;
(statearr_31491_31536[(2)] = inst_31464);

(statearr_31491_31536[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31482 === (22))){
var inst_31430 = (state_31481[(7)]);
var inst_31438 = (state_31481[(16)]);
var inst_31445 = (state_31481[(2)]);
var inst_31446 = fluree.db.util.async.throw_err.call(null,inst_31445);
var inst_31447 = cljs.core.concat.call(null,inst_31430,inst_31446);
var inst_31430__$1 = inst_31447;
var inst_31431 = inst_31438;
var state_31481__$1 = (function (){var statearr_31492 = state_31481;
(statearr_31492[(14)] = inst_31431);

(statearr_31492[(7)] = inst_31430__$1);

return statearr_31492;
})();
var statearr_31493_31537 = state_31481__$1;
(statearr_31493_31537[(2)] = null);

(statearr_31493_31537[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31482 === (6))){
var inst_31398 = (state_31481[(17)]);
var state_31481__$1 = state_31481;
var statearr_31494_31538 = state_31481__$1;
(statearr_31494_31538[(2)] = inst_31398);

(statearr_31494_31538[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31482 === (25))){
var inst_31476 = (state_31481[(2)]);
var _ = (function (){var statearr_31495 = state_31481;
(statearr_31495[(4)] = cljs.core.rest.call(null,(state_31481[(4)])));

return statearr_31495;
})();
var state_31481__$1 = state_31481;
var statearr_31496_31539 = state_31481__$1;
(statearr_31496_31539[(2)] = inst_31476);

(statearr_31496_31539[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31482 === (17))){
var inst_31437 = (state_31481[(18)]);
var inst_31431 = (state_31481[(14)]);
var inst_31436 = cljs.core.seq.call(null,inst_31431);
var inst_31437__$1 = cljs.core.first.call(null,inst_31436);
var inst_31438 = cljs.core.next.call(null,inst_31436);
var state_31481__$1 = (function (){var statearr_31497 = state_31481;
(statearr_31497[(18)] = inst_31437__$1);

(statearr_31497[(16)] = inst_31438);

return statearr_31497;
})();
if(cljs.core.truth_(inst_31437__$1)){
var statearr_31498_31540 = state_31481__$1;
(statearr_31498_31540[(1)] = (19));

} else {
var statearr_31499_31541 = state_31481__$1;
(statearr_31499_31541[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31482 === (3))){
var inst_31479 = (state_31481[(2)]);
var state_31481__$1 = state_31481;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31481__$1,inst_31479);
} else {
if((state_val_31482 === (12))){
var inst_31404 = (state_31481[(19)]);
var inst_31415 = (state_31481[(12)]);
var inst_31410 = cljs.core.vals.call(null,inst_31404);
var inst_31411 = cljs.core.flatten.call(null,inst_31410);
var inst_31412 = cljs.core.set.call(null,inst_31411);
var inst_31413 = cljs.core.keys.call(null,inst_31404);
var inst_31414 = cljs.core.set.call(null,inst_31413);
var inst_31415__$1 = clojure.set.difference.call(null,inst_31412,inst_31414);
var inst_31416 = cljs.core.empty_QMARK_.call(null,inst_31415__$1);
var state_31481__$1 = (function (){var statearr_31500 = state_31481;
(statearr_31500[(12)] = inst_31415__$1);

return statearr_31500;
})();
if(inst_31416){
var statearr_31501_31542 = state_31481__$1;
(statearr_31501_31542[(1)] = (14));

} else {
var statearr_31502_31543 = state_31481__$1;
(statearr_31502_31543[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31482 === (2))){
var inst_31398 = (state_31481[(17)]);
var _ = (function (){var statearr_31503 = state_31481;
(statearr_31503[(4)] = cljs.core.cons.call(null,(5),(state_31481[(4)])));

return statearr_31503;
})();
var inst_31398__$1 = depth;
var state_31481__$1 = (function (){var statearr_31504 = state_31481;
(statearr_31504[(17)] = inst_31398__$1);

return statearr_31504;
})();
if(cljs.core.truth_(inst_31398__$1)){
var statearr_31505_31544 = state_31481__$1;
(statearr_31505_31544[(1)] = (6));

} else {
var statearr_31506_31545 = state_31481__$1;
(statearr_31506_31545[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31482 === (23))){
var inst_31469 = (state_31481[(8)]);
var state_31481__$1 = state_31481;
var statearr_31507_31546 = state_31481__$1;
(statearr_31507_31546[(2)] = inst_31469);

(statearr_31507_31546[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31482 === (19))){
var inst_31437 = (state_31481[(18)]);
var inst_31440 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31441 = [inst_31437,predicate];
var inst_31442 = (new cljs.core.PersistentVector(null,2,(5),inst_31440,inst_31441,null));
var inst_31443 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_31442);
var state_31481__$1 = state_31481;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31481__$1,(22),inst_31443);
} else {
if((state_val_31482 === (11))){
var inst_31404 = (state_31481[(19)]);
var state_31481__$1 = state_31481;
var statearr_31509_31547 = state_31481__$1;
(statearr_31509_31547[(2)] = inst_31404);

(statearr_31509_31547[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31482 === (9))){
var inst_31402 = (state_31481[(9)]);
var inst_31405 = (state_31481[(20)]);
var inst_31407 = (inst_31405 >= inst_31402);
var state_31481__$1 = state_31481;
if(cljs.core.truth_(inst_31407)){
var statearr_31510_31548 = state_31481__$1;
(statearr_31510_31548[(1)] = (11));

} else {
var statearr_31511_31549 = state_31481__$1;
(statearr_31511_31549[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31482 === (5))){
var _ = (function (){var statearr_31512 = state_31481;
(statearr_31512[(4)] = cljs.core.rest.call(null,(state_31481[(4)])));

return statearr_31512;
})();
var state_31481__$1 = state_31481;
var ex31508 = (state_31481__$1[(2)]);
var statearr_31513_31550 = state_31481__$1;
(statearr_31513_31550[(5)] = ex31508);


if((ex31508 instanceof Error)){
var statearr_31514_31551 = state_31481__$1;
(statearr_31514_31551[(1)] = (4));

(statearr_31514_31551[(5)] = null);

} else {
throw ex31508;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31482 === (14))){
var inst_31404 = (state_31481[(19)]);
var state_31481__$1 = state_31481;
var statearr_31515_31552 = state_31481__$1;
(statearr_31515_31552[(2)] = inst_31404);

(statearr_31515_31552[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31482 === (16))){
var inst_31462 = (state_31481[(2)]);
var state_31481__$1 = state_31481;
var statearr_31516_31553 = state_31481__$1;
(statearr_31516_31553[(2)] = inst_31462);

(statearr_31516_31553[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31482 === (10))){
var inst_31468 = (state_31481[(10)]);
var inst_31467 = (state_31481[(11)]);
var inst_31466 = (state_31481[(2)]);
var inst_31467__$1 = cljs.core.keys.call(null,inst_31466);
var inst_31468__$1 = fluree.db.query.analytical.follow_all_original_subject_paths.call(null,inst_31467__$1,inst_31466);
var inst_31469 = fluree.db.query.analytical.recur_map__GT_tuples.call(null,inst_31467__$1,inst_31468__$1);
var state_31481__$1 = (function (){var statearr_31517 = state_31481;
(statearr_31517[(8)] = inst_31469);

(statearr_31517[(10)] = inst_31468__$1);

(statearr_31517[(11)] = inst_31467__$1);

return statearr_31517;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_31518_31554 = state_31481__$1;
(statearr_31518_31554[(1)] = (23));

} else {
var statearr_31519_31555 = state_31481__$1;
(statearr_31519_31555[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31482 === (18))){
var inst_31404 = (state_31481[(19)]);
var inst_31405 = (state_31481[(20)]);
var inst_31453 = (state_31481[(2)]);
var inst_31454 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31455 = [(0),(2)];
var inst_31456 = (new cljs.core.PersistentVector(null,2,(5),inst_31454,inst_31455,null));
var inst_31457 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_31456,inst_31453);
var inst_31458 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_31404,inst_31457);
var inst_31459 = (inst_31405 + (1));
var inst_31404__$1 = inst_31458;
var inst_31405__$1 = inst_31459;
var state_31481__$1 = (function (){var statearr_31520 = state_31481;
(statearr_31520[(19)] = inst_31404__$1);

(statearr_31520[(20)] = inst_31405__$1);

return statearr_31520;
})();
var statearr_31521_31556 = state_31481__$1;
(statearr_31521_31556[(2)] = null);

(statearr_31521_31556[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31482 === (8))){
var inst_31402 = (state_31481[(2)]);
var inst_31403 = recur_map;
var inst_31404 = inst_31403;
var inst_31405 = (1);
var state_31481__$1 = (function (){var statearr_31522 = state_31481;
(statearr_31522[(9)] = inst_31402);

(statearr_31522[(19)] = inst_31404);

(statearr_31522[(20)] = inst_31405);

return statearr_31522;
})();
var statearr_31523_31557 = state_31481__$1;
(statearr_31523_31557[(2)] = null);

(statearr_31523_31557[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10945__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10945__auto____0 = (function (){
var statearr_31524 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31524[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10945__auto__);

(statearr_31524[(1)] = (1));

return statearr_31524;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10945__auto____1 = (function (state_31481){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_31481);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e31525){var ex__10948__auto__ = e31525;
var statearr_31526_31558 = state_31481;
(statearr_31526_31558[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_31481[(4)]))){
var statearr_31527_31559 = state_31481;
(statearr_31527_31559[(1)] = cljs.core.first.call(null,(state_31481[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31560 = state_31481;
state_31481 = G__31560;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10945__auto__ = function(state_31481){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10945__auto____1.call(this,state_31481);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10945__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10945__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_31528 = f__11019__auto__.call(null);
(statearr_31528[(6)] = c__11018__auto__);

return statearr_31528;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__31561,clause,fuel,max_fuel){
var map__31562 = p__31561;
var map__31562__$1 = cljs.core.__destructure_map.call(null,map__31562);
var res = map__31562__$1;
var headers = cljs.core.get.call(null,map__31562__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__31562__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.call(null,map__31562__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_31673){
var state_val_31674 = (state_31673[(1)]);
if((state_val_31674 === (7))){
var inst_31579 = (state_31673[(7)]);
var state_31673__$1 = state_31673;
var statearr_31675_31728 = state_31673__$1;
(statearr_31675_31728[(2)] = inst_31579);

(statearr_31675_31728[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31674 === (20))){
var inst_31607 = (state_31673[(8)]);
var inst_31638 = typeof inst_31607 === 'number';
var state_31673__$1 = state_31673;
if(cljs.core.truth_(inst_31638)){
var statearr_31676_31729 = state_31673__$1;
(statearr_31676_31729[(1)] = (22));

} else {
var statearr_31677_31730 = state_31673__$1;
(statearr_31677_31730[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31674 === (27))){
var inst_31653 = (state_31673[(2)]);
var state_31673__$1 = state_31673;
var statearr_31678_31731 = state_31673__$1;
(statearr_31678_31731[(2)] = inst_31653);

(statearr_31678_31731[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31674 === (1))){
var state_31673__$1 = state_31673;
var statearr_31679_31732 = state_31673__$1;
(statearr_31679_31732[(2)] = null);

(statearr_31679_31732[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31674 === (24))){
var inst_31655 = (state_31673[(2)]);
var state_31673__$1 = state_31673;
var statearr_31680_31733 = state_31673__$1;
(statearr_31680_31733[(2)] = inst_31655);

(statearr_31680_31733[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31674 === (4))){
var inst_31563 = (state_31673[(2)]);
var state_31673__$1 = state_31673;
var statearr_31681_31734 = state_31673__$1;
(statearr_31681_31734[(2)] = inst_31563);

(statearr_31681_31734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31674 === (15))){
var inst_31621 = (state_31673[(2)]);
var inst_31622 = cljs.core.nth.call(null,clause,(2));
var inst_31623 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_31622);
var state_31673__$1 = (function (){var statearr_31682 = state_31673;
(statearr_31682[(9)] = inst_31621);

return statearr_31682;
})();
if(cljs.core.truth_(inst_31623)){
var statearr_31683_31735 = state_31673__$1;
(statearr_31683_31735[(1)] = (16));

} else {
var statearr_31684_31736 = state_31673__$1;
(statearr_31684_31736[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31674 === (21))){
var inst_31610 = (state_31673[(10)]);
var inst_31580 = (state_31673[(11)]);
var inst_31609 = (state_31673[(12)]);
var inst_31657 = (state_31673[(2)]);
var inst_31658 = fluree.db.query.analytical.tuples__GT_recur.call(null,db,inst_31610,inst_31657,inst_31580,inst_31609);
var state_31673__$1 = state_31673;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31673__$1,(28),inst_31658);
} else {
if((state_val_31674 === (13))){
var inst_31589 = (state_31673[(13)]);
var inst_31613 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31589)].join('');
var inst_31614 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_31615 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_31616 = cljs.core.PersistentHashMap.fromArrays(inst_31614,inst_31615);
var inst_31617 = cljs.core.ex_info.call(null,inst_31613,inst_31616);
var inst_31618 = (function(){throw inst_31617})();
var state_31673__$1 = state_31673;
var statearr_31685_31737 = state_31673__$1;
(statearr_31685_31737[(2)] = inst_31618);

(statearr_31685_31737[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31674 === (22))){
var inst_31605 = (state_31673[(14)]);
var inst_31607 = (state_31673[(8)]);
var inst_31640 = cljs.core.PersistentHashMap.EMPTY;
var inst_31641 = cljs.core.flatten.call(null,inst_31605);
var inst_31642 = cljs.core.assoc.call(null,inst_31640,inst_31607,inst_31641);
var state_31673__$1 = state_31673;
var statearr_31686_31738 = state_31673__$1;
(statearr_31686_31738[(2)] = inst_31642);

(statearr_31686_31738[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31674 === (6))){
var inst_31591 = (state_31673[(15)]);
var state_31673__$1 = state_31673;
var statearr_31687_31739 = state_31673__$1;
(statearr_31687_31739[(2)] = inst_31591);

(statearr_31687_31739[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31674 === (28))){
var inst_31660 = (state_31673[(2)]);
var inst_31661 = fluree.db.util.async.throw_err.call(null,inst_31660);
var state_31673__$1 = state_31673;
var statearr_31688_31740 = state_31673__$1;
(statearr_31688_31740[(2)] = inst_31661);

(statearr_31688_31740[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31674 === (25))){
var inst_31601 = (state_31673[(16)]);
var inst_31605 = (state_31673[(14)]);
var inst_31646 = cljs.core.PersistentHashMap.EMPTY;
var inst_31647 = cljs.core.first.call(null,inst_31601);
var inst_31648 = cljs.core.first.call(null,inst_31647);
var inst_31649 = cljs.core.flatten.call(null,inst_31605);
var inst_31650 = cljs.core.assoc.call(null,inst_31646,inst_31648,inst_31649);
var state_31673__$1 = state_31673;
var statearr_31689_31741 = state_31673__$1;
(statearr_31689_31741[(2)] = inst_31650);

(statearr_31689_31741[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31674 === (17))){
var inst_31589 = (state_31673[(13)]);
var inst_31626 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31589)].join('');
var inst_31627 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_31628 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_31629 = cljs.core.PersistentHashMap.fromArrays(inst_31627,inst_31628);
var inst_31630 = cljs.core.ex_info.call(null,inst_31626,inst_31629);
var inst_31631 = (function(){throw inst_31630})();
var state_31673__$1 = state_31673;
var statearr_31690_31742 = state_31673__$1;
(statearr_31690_31742[(2)] = inst_31631);

(statearr_31690_31742[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31674 === (3))){
var inst_31671 = (state_31673[(2)]);
var state_31673__$1 = state_31673;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31673__$1,inst_31671);
} else {
if((state_val_31674 === (12))){
var inst_31576 = (state_31673[(17)]);
var inst_31664 = (state_31673[(2)]);
var inst_31665 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_31666 = cljs.core.keys.call(null,inst_31576);
var inst_31667 = [inst_31666,vars,inst_31664];
var inst_31668 = cljs.core.PersistentHashMap.fromArrays(inst_31665,inst_31667);
var _ = (function (){var statearr_31691 = state_31673;
(statearr_31691[(4)] = cljs.core.rest.call(null,(state_31673[(4)])));

return statearr_31691;
})();
var state_31673__$1 = state_31673;
var statearr_31692_31743 = state_31673__$1;
(statearr_31692_31743[(2)] = inst_31668);

(statearr_31692_31743[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31674 === (2))){
var inst_31576 = (state_31673[(17)]);
var inst_31591 = (state_31673[(15)]);
var inst_31580 = (state_31673[(11)]);
var inst_31579 = (state_31673[(7)]);
var _ = (function (){var statearr_31693 = state_31673;
(statearr_31693[(4)] = cljs.core.cons.call(null,(5),(state_31673[(4)])));

return statearr_31693;
})();
var inst_31573 = fluree.db.query.analytical.clause__GT_rel.call(null,db,vars,clause);
var inst_31574 = cljs.core.__destructure_map.call(null,inst_31573);
var inst_31575 = cljs.core.get.call(null,inst_31574,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_31576__$1 = cljs.core.get.call(null,inst_31574,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_31577 = cljs.core.get.call(null,inst_31574,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_31578 = fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,clause);
var inst_31579__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_31577);
var inst_31580__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_31577);
var inst_31582 = (function (){var map__31569 = inst_31574;
var search = inst_31575;
var rel = inst_31576__$1;
var opts = inst_31577;
var common_keys = inst_31578;
var object_fn = inst_31579__$1;
var recur_depth = inst_31580__$1;
return (function (p__31581,common_key){
var vec__31694 = p__31581;
var acc = cljs.core.nth.call(null,vec__31694,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__31694,(1),null);
var idx_of = fluree.db.util.core.index_of.call(null,clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__31697 = cljs.core._EQ_;
var expr__31698 = idx_of;
if(cljs.core.truth_(pred__31697.call(null,(0),expr__31698))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_(pred__31697.call(null,(1),expr__31698))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_(pred__31697.call(null,(2),expr__31698))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__31698)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of.call(null,headers,common_key);
var v = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,cljs.core.first,fluree.db.query.analytical.get_ns_arrays.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,v));
var v__$1 = (cljs.core.truth_((function (){var and__5043__auto__ = (!(single_v_QMARK_));
if(and__5043__auto__){
var and__5043__auto____$1 = object_fn;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.call(null,k,object_fn);
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())?cljs.core.comp.call(null,v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.call(null,clause_SINGLEQUOTE_,idx_of,cljs.core.first.call(null,v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_31583 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31584 = cljs.core.PersistentHashMap.EMPTY;
var inst_31585 = [inst_31584,inst_31575];
var inst_31586 = (new cljs.core.PersistentVector(null,2,(5),inst_31583,inst_31585,null));
var inst_31587 = cljs.core.reduce.call(null,inst_31582,inst_31586,inst_31578);
var inst_31588 = cljs.core.nth.call(null,inst_31587,(0),null);
var inst_31589 = cljs.core.nth.call(null,inst_31587,(1),null);
var inst_31590 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_31591__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_31588);
var state_31673__$1 = (function (){var statearr_31700 = state_31673;
(statearr_31700[(17)] = inst_31576__$1);

(statearr_31700[(18)] = inst_31590);

(statearr_31700[(15)] = inst_31591__$1);

(statearr_31700[(11)] = inst_31580__$1);

(statearr_31700[(13)] = inst_31589);

(statearr_31700[(7)] = inst_31579__$1);

return statearr_31700;
})();
if(cljs.core.truth_(inst_31591__$1)){
var statearr_31701_31744 = state_31673__$1;
(statearr_31701_31744[(1)] = (6));

} else {
var statearr_31702_31745 = state_31673__$1;
(statearr_31702_31745[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31674 === (23))){
var inst_31607 = (state_31673[(8)]);
var inst_31644 = cljs.core.coll_QMARK_.call(null,inst_31607);
var state_31673__$1 = state_31673;
if(inst_31644){
var statearr_31703_31746 = state_31673__$1;
(statearr_31703_31746[(1)] = (25));

} else {
var statearr_31704_31747 = state_31673__$1;
(statearr_31704_31747[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31674 === (19))){
var inst_31605 = (state_31673[(14)]);
var inst_31635 = cljs.core.PersistentHashMap.EMPTY;
var inst_31636 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_31635,inst_31605);
var state_31673__$1 = state_31673;
var statearr_31705_31748 = state_31673__$1;
(statearr_31705_31748[(2)] = inst_31636);

(statearr_31705_31748[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31674 === (11))){
var inst_31605 = (state_31673[(14)]);
var state_31673__$1 = state_31673;
var statearr_31707_31749 = state_31673__$1;
(statearr_31707_31749[(2)] = inst_31605);

(statearr_31707_31749[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31674 === (9))){
var inst_31576 = (state_31673[(17)]);
var inst_31601 = (state_31673[(16)]);
var inst_31580 = (state_31673[(11)]);
var inst_31600 = (state_31673[(2)]);
var inst_31601__$1 = fluree.db.util.async.throw_err.call(null,inst_31600);
var inst_31602 = cljs.core.count.call(null,inst_31601__$1);
var inst_31603 = fluree.db.query.analytical.add_fuel.call(null,inst_31602,fuel,max_fuel);
var inst_31604 = cljs.core.vals.call(null,inst_31576);
var inst_31605 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_31604,inst_31601__$1);
var state_31673__$1 = (function (){var statearr_31708 = state_31673;
(statearr_31708[(16)] = inst_31601__$1);

(statearr_31708[(14)] = inst_31605);

(statearr_31708[(19)] = inst_31603);

return statearr_31708;
})();
if(cljs.core.truth_(inst_31580)){
var statearr_31709_31750 = state_31673__$1;
(statearr_31709_31750[(1)] = (10));

} else {
var statearr_31710_31751 = state_31673__$1;
(statearr_31710_31751[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31674 === (5))){
var _ = (function (){var statearr_31711 = state_31673;
(statearr_31711[(4)] = cljs.core.rest.call(null,(state_31673[(4)])));

return statearr_31711;
})();
var state_31673__$1 = state_31673;
var ex31706 = (state_31673__$1[(2)]);
var statearr_31712_31752 = state_31673__$1;
(statearr_31712_31752[(5)] = ex31706);


if((ex31706 instanceof Error)){
var statearr_31713_31753 = state_31673__$1;
(statearr_31713_31753[(1)] = (4));

(statearr_31713_31753[(5)] = null);

} else {
throw ex31706;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31674 === (14))){
var state_31673__$1 = state_31673;
var statearr_31714_31754 = state_31673__$1;
(statearr_31714_31754[(2)] = null);

(statearr_31714_31754[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31674 === (26))){
var state_31673__$1 = state_31673;
var statearr_31715_31755 = state_31673__$1;
(statearr_31715_31755[(2)] = null);

(statearr_31715_31755[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31674 === (16))){
var state_31673__$1 = state_31673;
var statearr_31716_31756 = state_31673__$1;
(statearr_31716_31756[(2)] = null);

(statearr_31716_31756[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31674 === (10))){
var inst_31610 = (state_31673[(10)]);
var inst_31589 = (state_31673[(13)]);
var inst_31607 = cljs.core.first.call(null,inst_31589);
var inst_31608 = cljs.core.first.call(null,clause);
var inst_31609 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_31608);
var inst_31610__$1 = cljs.core.nth.call(null,inst_31589,(1));
var inst_31611 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_31610__$1);
var state_31673__$1 = (function (){var statearr_31717 = state_31673;
(statearr_31717[(10)] = inst_31610__$1);

(statearr_31717[(8)] = inst_31607);

(statearr_31717[(12)] = inst_31609);

return statearr_31717;
})();
if(cljs.core.truth_(inst_31611)){
var statearr_31718_31757 = state_31673__$1;
(statearr_31718_31757[(1)] = (13));

} else {
var statearr_31719_31758 = state_31673__$1;
(statearr_31719_31758[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31674 === (18))){
var inst_31609 = (state_31673[(12)]);
var inst_31633 = (state_31673[(2)]);
var state_31673__$1 = (function (){var statearr_31720 = state_31673;
(statearr_31720[(20)] = inst_31633);

return statearr_31720;
})();
if(cljs.core.truth_(inst_31609)){
var statearr_31721_31759 = state_31673__$1;
(statearr_31721_31759[(1)] = (19));

} else {
var statearr_31722_31760 = state_31673__$1;
(statearr_31722_31760[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31674 === (8))){
var inst_31590 = (state_31673[(18)]);
var inst_31589 = (state_31673[(13)]);
var inst_31595 = (state_31673[(2)]);
var inst_31596 = [inst_31595];
var inst_31597 = cljs.core.PersistentHashMap.fromArrays(inst_31590,inst_31596);
var inst_31598 = fluree.db.query.range.search.call(null,db,inst_31589,inst_31597);
var state_31673__$1 = state_31673;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31673__$1,(9),inst_31598);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10945__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10945__auto____0 = (function (){
var statearr_31723 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31723[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10945__auto__);

(statearr_31723[(1)] = (1));

return statearr_31723;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10945__auto____1 = (function (state_31673){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_31673);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e31724){var ex__10948__auto__ = e31724;
var statearr_31725_31761 = state_31673;
(statearr_31725_31761[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_31673[(4)]))){
var statearr_31726_31762 = state_31673;
(statearr_31726_31762[(1)] = cljs.core.first.call(null,(state_31673[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31763 = state_31673;
state_31673 = G__31763;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10945__auto__ = function(state_31673){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10945__auto____1.call(this,state_31673);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10945__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10945__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_31727 = f__11019__auto__.call(null);
(statearr_31727[(6)] = c__11018__auto__);

return statearr_31727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__31764,res,clause){
var map__31765 = p__31764;
var map__31765__$1 = cljs.core.__destructure_map.call(null,map__31765);
var db = map__31765__$1;
var conn = cljs.core.get.call(null,map__31765__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__31765__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__31765__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
throw cljs.core.ex_info.call(null,"Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_31874){
var state_val_31875 = (state_31874[(1)]);
if((state_val_31875 === (7))){
var inst_31774 = (state_31874[(7)]);
var state_31874__$1 = state_31874;
var statearr_31876_31917 = state_31874__$1;
(statearr_31876_31917[(2)] = inst_31774);

(statearr_31876_31917[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (20))){
var state_31874__$1 = state_31874;
var statearr_31877_31918 = state_31874__$1;
(statearr_31877_31918[(2)] = null);

(statearr_31877_31918[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (1))){
var state_31874__$1 = state_31874;
var statearr_31878_31919 = state_31874__$1;
(statearr_31878_31919[(2)] = null);

(statearr_31878_31919[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (24))){
var inst_31776 = (state_31874[(8)]);
var inst_31847 = (state_31874[(2)]);
var inst_31848 = fluree.db.flake.sid__GT_cid.call(null,inst_31847);
var inst_31849 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_31848);
var inst_31850 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_31851 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31852 = [inst_31776];
var inst_31853 = (new cljs.core.PersistentVector(null,1,(5),inst_31851,inst_31852,null));
var inst_31854 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31855 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31856 = [inst_31849];
var inst_31857 = (new cljs.core.PersistentVector(null,1,(5),inst_31855,inst_31856,null));
var inst_31858 = [inst_31857];
var inst_31859 = (new cljs.core.PersistentVector(null,1,(5),inst_31854,inst_31858,null));
var inst_31860 = cljs.core.PersistentHashMap.EMPTY;
var inst_31861 = [inst_31853,inst_31859,inst_31860];
var inst_31862 = cljs.core.PersistentHashMap.fromArrays(inst_31850,inst_31861);
var state_31874__$1 = state_31874;
var statearr_31879_31920 = state_31874__$1;
(statearr_31879_31920[(2)] = inst_31862);

(statearr_31879_31920[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (4))){
var inst_31767 = (state_31874[(2)]);
var state_31874__$1 = state_31874;
var statearr_31880_31921 = state_31874__$1;
(statearr_31880_31921[(2)] = inst_31767);

(statearr_31880_31921[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (15))){
var inst_31774 = (state_31874[(7)]);
var inst_31776 = (state_31874[(8)]);
var inst_31795 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_31796 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_31797 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31798 = [inst_31774];
var inst_31799 = (new cljs.core.PersistentVector(null,1,(5),inst_31797,inst_31798,null));
var inst_31800 = (function (){var subject_var = inst_31774;
var object_var = inst_31776;
var min_sid = inst_31795;
var max_sid = (0);
return (function (p1__31766_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__31766_SHARP_);
});
})();
var inst_31801 = cljs.core.range.call(null,inst_31795,(0));
var inst_31802 = cljs.core.map.call(null,inst_31800,inst_31801);
var inst_31803 = cljs.core.PersistentHashMap.EMPTY;
var inst_31804 = [inst_31799,inst_31802,inst_31803];
var inst_31805 = cljs.core.PersistentHashMap.fromArrays(inst_31796,inst_31804);
var state_31874__$1 = state_31874;
var statearr_31881_31922 = state_31874__$1;
(statearr_31881_31922[(2)] = inst_31805);

(statearr_31881_31922[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (21))){
var inst_31865 = (state_31874[(2)]);
var state_31874__$1 = state_31874;
var statearr_31882_31923 = state_31874__$1;
(statearr_31882_31923[(2)] = inst_31865);

(statearr_31882_31923[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (13))){
var inst_31776 = (state_31874[(8)]);
var state_31874__$1 = state_31874;
if(cljs.core.truth_(inst_31776)){
var statearr_31883_31924 = state_31874__$1;
(statearr_31883_31924[(1)] = (19));

} else {
var statearr_31884_31925 = state_31874__$1;
(statearr_31884_31925[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (22))){
var inst_31838 = (state_31874[(9)]);
var state_31874__$1 = state_31874;
var statearr_31885_31926 = state_31874__$1;
(statearr_31885_31926[(2)] = inst_31838);

(statearr_31885_31926[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (6))){
var inst_31776 = (state_31874[(8)]);
var state_31874__$1 = state_31874;
var statearr_31886_31927 = state_31874__$1;
(statearr_31886_31927[(2)] = inst_31776);

(statearr_31886_31927[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (25))){
var inst_31844 = (state_31874[(2)]);
var inst_31845 = fluree.db.util.async.throw_err.call(null,inst_31844);
var state_31874__$1 = state_31874;
var statearr_31887_31928 = state_31874__$1;
(statearr_31887_31928[(2)] = inst_31845);

(statearr_31887_31928[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (17))){
var inst_31835 = (state_31874[(2)]);
var state_31874__$1 = state_31874;
var statearr_31888_31929 = state_31874__$1;
(statearr_31888_31929[(2)] = inst_31835);

(statearr_31888_31929[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (3))){
var inst_31872 = (state_31874[(2)]);
var state_31874__$1 = state_31874;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31874__$1,inst_31872);
} else {
if((state_val_31875 === (12))){
var inst_31789 = ["_tx",null,"_block",null];
var inst_31790 = (new cljs.core.PersistentArrayMap(null,2,inst_31789,null));
var inst_31791 = (new cljs.core.PersistentHashSet(null,inst_31790,null));
var inst_31792 = cljs.core.last.call(null,clause);
var inst_31793 = inst_31791.call(null,inst_31792);
var state_31874__$1 = state_31874;
if(cljs.core.truth_(inst_31793)){
var statearr_31889_31930 = state_31874__$1;
(statearr_31889_31930[(1)] = (15));

} else {
var statearr_31890_31931 = state_31874__$1;
(statearr_31890_31931[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (2))){
var inst_31774 = (state_31874[(7)]);
var _ = (function (){var statearr_31891 = state_31874;
(statearr_31891[(4)] = cljs.core.cons.call(null,(5),(state_31874[(4)])));

return statearr_31891;
})();
var inst_31773 = cljs.core.first.call(null,clause);
var inst_31774__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_31773);
var inst_31775 = cljs.core.last.call(null,clause);
var inst_31776 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_31775);
var state_31874__$1 = (function (){var statearr_31892 = state_31874;
(statearr_31892[(7)] = inst_31774__$1);

(statearr_31892[(8)] = inst_31776);

return statearr_31892;
})();
if(cljs.core.truth_(inst_31774__$1)){
var statearr_31893_31932 = state_31874__$1;
(statearr_31893_31932[(1)] = (6));

} else {
var statearr_31894_31933 = state_31874__$1;
(statearr_31894_31933[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (23))){
var inst_31838 = (state_31874[(9)]);
var inst_31842 = fluree.db.dbproto._subid.call(null,db,inst_31838);
var state_31874__$1 = state_31874;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31874__$1,(25),inst_31842);
} else {
if((state_val_31875 === (19))){
var inst_31838 = (state_31874[(9)]);
var inst_31838__$1 = cljs.core.first.call(null,clause);
var inst_31839 = typeof inst_31838__$1 === 'number';
var state_31874__$1 = (function (){var statearr_31895 = state_31874;
(statearr_31895[(9)] = inst_31838__$1);

return statearr_31895;
})();
if(cljs.core.truth_(inst_31839)){
var statearr_31896_31934 = state_31874__$1;
(statearr_31896_31934[(1)] = (22));

} else {
var statearr_31897_31935 = state_31874__$1;
(statearr_31897_31935[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (11))){
var inst_31869 = (state_31874[(2)]);
var _ = (function (){var statearr_31899 = state_31874;
(statearr_31899[(4)] = cljs.core.rest.call(null,(state_31874[(4)])));

return statearr_31899;
})();
var state_31874__$1 = state_31874;
var statearr_31900_31936 = state_31874__$1;
(statearr_31900_31936[(2)] = inst_31869);

(statearr_31900_31936[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (9))){
var inst_31782 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_31783 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_31784 = cljs.core.PersistentHashMap.fromArrays(inst_31782,inst_31783);
var inst_31785 = cljs.core.ex_info.call(null,"When using rdf:type, either a subject or a type (collection) must be specified.",inst_31784);
var inst_31786 = (function(){throw inst_31785})();
var state_31874__$1 = state_31874;
var statearr_31901_31937 = state_31874__$1;
(statearr_31901_31937[(2)] = inst_31786);

(statearr_31901_31937[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (5))){
var _ = (function (){var statearr_31902 = state_31874;
(statearr_31902[(4)] = cljs.core.rest.call(null,(state_31874[(4)])));

return statearr_31902;
})();
var state_31874__$1 = state_31874;
var ex31898 = (state_31874__$1[(2)]);
var statearr_31903_31938 = state_31874__$1;
(statearr_31903_31938[(5)] = ex31898);


if((ex31898 instanceof Error)){
var statearr_31904_31939 = state_31874__$1;
(statearr_31904_31939[(1)] = (4));

(statearr_31904_31939[(5)] = null);

} else {
throw ex31898;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (14))){
var inst_31867 = (state_31874[(2)]);
var state_31874__$1 = state_31874;
var statearr_31905_31940 = state_31874__$1;
(statearr_31905_31940[(2)] = inst_31867);

(statearr_31905_31940[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (16))){
var inst_31810 = (state_31874[(10)]);
var inst_31811 = (state_31874[(11)]);
var inst_31808 = (state_31874[(12)]);
var inst_31807 = cljs.core.last.call(null,clause);
var inst_31808__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_31807);
var inst_31809 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_31810__$1 = cljs.core.get.call(null,inst_31809,inst_31808__$1);
var inst_31811__$1 = fluree.db.flake.min_subject_id.call(null,inst_31808__$1);
var inst_31812 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31813 = [inst_31810__$1];
var inst_31814 = (new cljs.core.PersistentVector(null,1,(5),inst_31812,inst_31813,null));
var inst_31815 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31816 = [inst_31811__$1];
var inst_31817 = (new cljs.core.PersistentVector(null,1,(5),inst_31815,inst_31816,null));
var inst_31818 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_31814,cljs.core._LT__EQ_,inst_31817);
var state_31874__$1 = (function (){var statearr_31906 = state_31874;
(statearr_31906[(10)] = inst_31810__$1);

(statearr_31906[(11)] = inst_31811__$1);

(statearr_31906[(12)] = inst_31808__$1);

return statearr_31906;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31874__$1,(18),inst_31818);
} else {
if((state_val_31875 === (10))){
var inst_31774 = (state_31874[(7)]);
var state_31874__$1 = state_31874;
if(cljs.core.truth_(inst_31774)){
var statearr_31907_31941 = state_31874__$1;
(statearr_31907_31941[(1)] = (12));

} else {
var statearr_31908_31942 = state_31874__$1;
(statearr_31908_31942[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (18))){
var inst_31810 = (state_31874[(10)]);
var inst_31811 = (state_31874[(11)]);
var inst_31808 = (state_31874[(12)]);
var inst_31774 = (state_31874[(7)]);
var inst_31776 = (state_31874[(8)]);
var inst_31820 = (state_31874[(2)]);
var inst_31821 = fluree.db.util.async.throw_err.call(null,inst_31820);
var inst_31822 = (function (){var subject_var = inst_31774;
var object_var = inst_31776;
var partition = inst_31808;
var max_sid = inst_31810;
var min_sid = inst_31811;
var flakes = inst_31821;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_31823 = cljs.core.map.call(null,inst_31822);
var inst_31824 = cljs.core.distinct.call(null);
var inst_31825 = cljs.core.comp.call(null,inst_31823,inst_31824);
var inst_31826 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_31827 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31828 = [inst_31774];
var inst_31829 = (new cljs.core.PersistentVector(null,1,(5),inst_31827,inst_31828,null));
var inst_31830 = cljs.core.sequence.call(null,inst_31825,inst_31821);
var inst_31831 = cljs.core.PersistentHashMap.EMPTY;
var inst_31832 = [inst_31829,inst_31830,inst_31831];
var inst_31833 = cljs.core.PersistentHashMap.fromArrays(inst_31826,inst_31832);
var state_31874__$1 = state_31874;
var statearr_31909_31943 = state_31874__$1;
(statearr_31909_31943[(2)] = inst_31833);

(statearr_31909_31943[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31875 === (8))){
var inst_31780 = (state_31874[(2)]);
var state_31874__$1 = state_31874;
if(cljs.core.truth_(inst_31780)){
var statearr_31910_31944 = state_31874__$1;
(statearr_31910_31944[(1)] = (9));

} else {
var statearr_31911_31945 = state_31874__$1;
(statearr_31911_31945[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10945__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10945__auto____0 = (function (){
var statearr_31912 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31912[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10945__auto__);

(statearr_31912[(1)] = (1));

return statearr_31912;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10945__auto____1 = (function (state_31874){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_31874);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e31913){var ex__10948__auto__ = e31913;
var statearr_31914_31946 = state_31874;
(statearr_31914_31946[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_31874[(4)]))){
var statearr_31915_31947 = state_31874;
(statearr_31915_31947[(1)] = cljs.core.first.call(null,(state_31874[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31948 = state_31874;
state_31874 = G__31948;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10945__auto__ = function(state_31874){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10945__auto____1.call(this,state_31874);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10945__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10945__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_31916 = f__11019__auto__.call(null);
(statearr_31916[(6)] = c__11018__auto__);

return statearr_31916;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.call(null,cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum.call(null,coll) / cljs.core.count.call(null,coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.call(null,coll);
var size = cljs.core.count.call(null,coll);
var med = (size >> (1));
var G__31954 = cljs.core.nth.call(null,terms,med);
if(cljs.core.even_QMARK_.call(null,size)){
return ((G__31954 + cljs.core.nth.call(null,terms,(med - (1)))) / (2));
} else {
return G__31954;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg.call(null,coll);
var sum__$1 = sum.call(null,(function (){var iter__5522__auto__ = (function fluree$db$query$analytical$variance_$_iter__31955(s__31956){
return (new cljs.core.LazySeq(null,(function (){
var s__31956__$1 = s__31956;
while(true){
var temp__5804__auto__ = cljs.core.seq.call(null,s__31956__$1);
if(temp__5804__auto__){
var s__31956__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__31956__$2)){
var c__5520__auto__ = cljs.core.chunk_first.call(null,s__31956__$2);
var size__5521__auto__ = cljs.core.count.call(null,c__5520__auto__);
var b__31958 = cljs.core.chunk_buffer.call(null,size__5521__auto__);
if((function (){var i__31957 = (0);
while(true){
if((i__31957 < size__5521__auto__)){
var x = cljs.core._nth.call(null,c__5520__auto__,i__31957);
var delta = (x - mean);
cljs.core.chunk_append.call(null,b__31958,(delta * delta));

var G__31959 = (i__31957 + (1));
i__31957 = G__31959;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__31958),fluree$db$query$analytical$variance_$_iter__31955.call(null,cljs.core.chunk_rest.call(null,s__31956__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__31958),null);
}
} else {
var x = cljs.core.first.call(null,s__31956__$2);
var delta = (x - mean);
return cljs.core.cons.call(null,(delta * delta),fluree$db$query$analytical$variance_$_iter__31955.call(null,cljs.core.rest.call(null,s__31956__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5522__auto__.call(null,coll);
})());
return (sum__$1 / cljs.core.count.call(null,coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
return Math.sqrt(variance.call(null,coll));
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__5130__auto__ = n;
var y__5131__auto__ = (- n);
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
}),(function() {
var G__31960 = null;
var G__31960__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__31960__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.last.call(null,acc)) < (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.butlast.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__31960 = function(n,coll){
switch(arguments.length){
case 1:
return G__31960__1.call(this,n);
case 2:
return G__31960__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__31960.cljs$core$IFn$_invoke$arity$1 = G__31960__1;
G__31960.cljs$core$IFn$_invoke$arity$2 = G__31960__2;
return G__31960;
})()
,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__31961 = null;
var G__31961__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__31961__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.first.call(null,acc)) > (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.next.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__31961 = function(n,coll){
switch(arguments.length){
case 1:
return G__31961__1.call(this,n);
case 2:
return G__31961__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__31961.cljs$core$IFn$_invoke$arity$1 = G__31961__1;
G__31961.cljs$core$IFn$_invoke$arity$2 = G__31961__2;
return G__31961;
})()
,(function (coll){
return cljs.core.count.call(null,cljs.core.distinct.call(null,coll));
}),avg,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__31962 = null;
var G__31962__1 = (function (coll){
return cljs.core.rand_nth.call(null,coll);
});
var G__31962__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.repeatedly.call(null,n,(function (){
return cljs.core.rand_nth.call(null,coll);
})));
});
G__31962 = function(n,coll){
switch(arguments.length){
case 1:
return G__31962__1.call(this,n);
case 2:
return G__31962__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__31962.cljs$core$IFn$_invoke$arity$1 = G__31962__1;
G__31962.cljs$core$IFn$_invoke$arity$2 = G__31962__2;
return G__31962;
})()
,(function (n,coll){
return cljs.core.vec.call(null,cljs.core.take.call(null,n,cljs.core.shuffle.call(null,coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,/^\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,/^#\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.call(null,x);
var as_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first.call(null,list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,list_agg))].join('')):cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second.call(null,list_agg);
if(cljs.core.coll_QMARK_.call(null,func_list)){
return func_list;
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count.call(null,func_list);
var vec__31963 = ((cljs.core._EQ_.call(null,(3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),cljs.core.second.call(null,func_list),cljs.core.last.call(null,func_list)], null):((((cljs.core._EQ_.call(null,(2),list_count)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first.call(null,func_list)))))?(function(){throw cljs.core.ex_info.call(null,["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.call(null,(2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),null,cljs.core.last.call(null,func_list)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.call(null,vec__31963,(0),null);
var arg = cljs.core.nth.call(null,vec__31963,(1),null);
var var$ = cljs.core.nth.call(null,vec__31963,(2),null);
var agg_fn = (function (){var temp__5802__auto__ = fluree.db.query.analytical.built_in_aggregates.call(null,fun);
if(cljs.core.truth_(temp__5802__auto__)){
var agg_fn = temp__5802__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return agg_fn.call(null,arg,coll);
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__31966 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_.call(null,var$)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second.call(null,var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
return agg_fn.call(null,cljs.core.distinct.call(null,coll));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.call(null,vec__31966,(0),null);
var variable = cljs.core.nth.call(null,vec__31966,(1),null);
var _ = (cljs.core.truth_(valid_var.call(null,variable))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__31969 = agg;
var map__31969__$1 = cljs.core.__destructure_map.call(null,map__31969);
var variable = cljs.core.get.call(null,map__31969__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.call(null,map__31969__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var code = cljs.core.get.call(null,map__31969__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var agg_params = cljs.core.flatten.call(null,fluree.db.query.analytical.select_from_tuples.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = code.call(null,agg_params);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.call(null,(function (res__$1,agg){
var vec__31971 = fluree.db.query.analytical.calculate_aggregate.call(null,res__$1,agg);
var as = cljs.core.nth.call(null,vec__31971,(0),null);
var agg_result = cljs.core.nth.call(null,vec__31971,(1),null);
var map__31974 = res__$1;
var map__31974__$1 = cljs.core.__destructure_map.call(null,map__31974);
var headers = cljs.core.get.call(null,map__31974__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__31974__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__31970_SHARP_){
return cljs.core.conj.call(null,cljs.core.vec.call(null,p1__31970_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,cljs.core.vec.call(null,headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.call(null,cljs.core.symbol,cljs.core.keys.call(null,q_map));
var vals = cljs.core.vals.call(null,q_map);
return cljs.core.zipmap.call(null,keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.call(null,(function (acc,tuple){
var b_compare = cljs.core.map.call(null,(function (p1__31975_SHARP_){
return cljs.core.nth.call(null,tuple,p1__31975_SHARP_);
}),b_idxs);
return cljs.core.update.call(null,acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq.call(null,cljs.core.reduce.call(null,(function (acc,a_tuple){
var a_compare = cljs.core.map.call(null,(function (p1__31976_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__31976_SHARP_);
}),a_idxs);
var temp__5802__auto__ = cljs.core.get.call(null,b_map,a_compare);
if(cljs.core.truth_(temp__5802__auto__)){
var b_matched = temp__5802__auto__;
return cljs.core.reduce.call(null,(function (p1__31977_SHARP_,p2__31978_SHARP_){
return cljs.core.conj.call(null,p1__31977_SHARP_,cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (idx){
return cljs.core.nth.call(null,p2__31978_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.call(null,acc,cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.call(null,(function (p1__31979_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__31979_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv.call(null,(function (p__31982,row,b_tuple){
var vec__31983 = p__31982;
var acc = cljs.core.nth.call(null,vec__31983,(0),null);
var b_rows = cljs.core.nth.call(null,vec__31983,(1),null);
if(cljs.core._EQ_.call(null,a_tuple_part,cljs.core.map.call(null,(function (p1__31980_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__31980_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,(function (){var or__5045__auto__ = acc;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (p1__31981_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__31981_SHARP_);
}),b_not_idxs))),cljs.core.conj.call(null,b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_res,b_res);
var a_idxs = cljs.core.map.call(null,(function (p1__31986_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__31986_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__31987_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__31987_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__31989_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__31989_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__31988_SHARP_){
return cljs.core.range.call(null,(0),p1__31988_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.call(null,(function (p1__31990_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__31990_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__31991_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__31991_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__31992_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__31992_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__31994_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__31994_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__31993_SHARP_){
return cljs.core.range.call(null,(0),p1__31993_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__31995_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__31995_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.call(null," ",filter_code_req),")"].join('');
var vec__31997 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.call(null,vec__31997,(0),null);
var _ = cljs.core.nth.call(null,vec__31997,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.call(null,(function (p1__31996_SHARP_){
return fluree.db.query.analytical_filter.filter_row.call(null,headers,p1__31996_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.call(null,(function (tuples__$1,filt){
var var_atom = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);
var vec__32002 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filt,valid_vars,var_atom);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.call(null,vec__32002,(0),null);
var filt_vars = cljs.core.nth.call(null,vec__32002,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.call(null,(function (p1__32000_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__32000_SHARP_);
}),cljs.core.deref.call(null,filt_vars));
var filtered_tuples = cljs.core.reduce.call(null,(function (acc,clause){
if(cljs.core.every_QMARK_.call(null,(function (p1__32001_SHARP_){
return cljs.core.nth.call(null,clause,p1__32001_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row.call(null,headers,clause,filt_str))){
return cljs.core.conj.call(null,acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.call(null,acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__32005,filters,optional_QMARK_){
var map__32006 = p__32005;
var map__32006__$1 = cljs.core.__destructure_map.call(null,map__32006);
var tuple_map = map__32006__$1;
var headers = cljs.core.get.call(null,map__32006__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__32006__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.call(null,map__32006__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set.call(null,headers);
var header_vec = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.call(null,["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters.call(null,filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required.call(null,header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters.call(null,filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__32007 = clause;
var k = cljs.core.nth.call(null,vec__32007,(0),null);
var v = cljs.core.nth.call(null,vec__32007,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.call(null,["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__32010 = res;
var map__32010__$1 = cljs.core.__destructure_map.call(null,map__32010);
var headers = cljs.core.get.call(null,map__32010__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__32010__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_.call(null,v))?cljs.core.second.call(null,fluree.db.query.analytical.calculate_aggregate.call(null,res,fluree.db.query.analytical.parse_aggregate.call(null,cljs.core.subs.call(null,v,(1)),cljs.core.set.call(null,(function (){var temp__5802__auto__ = cljs.core.keys.call(null,vars);
if(cljs.core.truth_(temp__5802__auto__)){
var valid_var = temp__5802__auto__;
return cljs.core.conj.call(null,headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_32066){
var state_val_32067 = (state_32066[(1)]);
if((state_val_32067 === (7))){
var inst_32040 = (state_32066[(7)]);
var inst_32038 = (state_32066[(2)]);
var inst_32039 = fluree.db.util.async.throw_err.call(null,inst_32038);
var inst_32040__$1 = cljs.core.nth.call(null,inst_32039,(0),null);
var inst_32041 = cljs.core.nth.call(null,inst_32039,(1),null);
var inst_32042 = (inst_32040__$1 == null);
var state_32066__$1 = (function (){var statearr_32068 = state_32066;
(statearr_32068[(8)] = inst_32041);

(statearr_32068[(7)] = inst_32040__$1);

return statearr_32068;
})();
if(cljs.core.truth_(inst_32042)){
var statearr_32069_32098 = state_32066__$1;
(statearr_32069_32098[(1)] = (8));

} else {
var statearr_32070_32099 = state_32066__$1;
(statearr_32070_32099[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32067 === (1))){
var inst_32018 = optional_clauses;
var inst_32019 = cljs.core.seq.call(null,inst_32018);
var inst_32020 = cljs.core.first.call(null,inst_32019);
var inst_32021 = cljs.core.next.call(null,inst_32019);
var inst_32022 = where_tuples;
var inst_32023 = inst_32018;
var inst_32024 = inst_32022;
var state_32066__$1 = (function (){var statearr_32071 = state_32066;
(statearr_32071[(9)] = inst_32024);

(statearr_32071[(10)] = inst_32020);

(statearr_32071[(11)] = inst_32021);

(statearr_32071[(12)] = inst_32023);

return statearr_32071;
})();
var statearr_32072_32100 = state_32066__$1;
(statearr_32072_32100[(2)] = null);

(statearr_32072_32100[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32067 === (4))){
var inst_32024 = (state_32066[(9)]);
var inst_32030 = (state_32066[(13)]);
var inst_32031 = (state_32066[(14)]);
var inst_32036 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_32024,inst_32030,inst_32031,true,fuel,max_fuel,opts);
var state_32066__$1 = state_32066;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32066__$1,(7),inst_32036);
} else {
if((state_val_32067 === (15))){
var state_32066__$1 = state_32066;
var statearr_32073_32101 = state_32066__$1;
(statearr_32073_32101[(2)] = null);

(statearr_32073_32101[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32067 === (13))){
var inst_32057 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32074_32102 = state_32066__$1;
(statearr_32074_32102[(2)] = inst_32057);

(statearr_32074_32102[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32067 === (6))){
var inst_32062 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32075_32103 = state_32066__$1;
(statearr_32075_32103[(2)] = inst_32062);

(statearr_32075_32103[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32067 === (3))){
var inst_32064 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32066__$1,inst_32064);
} else {
if((state_val_32067 === (12))){
var state_32066__$1 = state_32066;
var statearr_32076_32104 = state_32066__$1;
(statearr_32076_32104[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32067 === (2))){
var inst_32030 = (state_32066[(13)]);
var inst_32023 = (state_32066[(12)]);
var inst_32029 = cljs.core.seq.call(null,inst_32023);
var inst_32030__$1 = cljs.core.first.call(null,inst_32029);
var inst_32031 = cljs.core.next.call(null,inst_32029);
var state_32066__$1 = (function (){var statearr_32078 = state_32066;
(statearr_32078[(13)] = inst_32030__$1);

(statearr_32078[(14)] = inst_32031);

return statearr_32078;
})();
if(cljs.core.truth_(inst_32030__$1)){
var statearr_32079_32105 = state_32066__$1;
(statearr_32079_32105[(1)] = (4));

} else {
var statearr_32080_32106 = state_32066__$1;
(statearr_32080_32106[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32067 === (11))){
var inst_32041 = (state_32066[(8)]);
var inst_32040 = (state_32066[(7)]);
var inst_32023 = inst_32041;
var inst_32024 = inst_32040;
var state_32066__$1 = (function (){var statearr_32081 = state_32066;
(statearr_32081[(9)] = inst_32024);

(statearr_32081[(12)] = inst_32023);

return statearr_32081;
})();
var statearr_32082_32107 = state_32066__$1;
(statearr_32082_32107[(2)] = null);

(statearr_32082_32107[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32067 === (9))){
var inst_32030 = (state_32066[(13)]);
var inst_32046 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_32030);
var state_32066__$1 = state_32066;
if(cljs.core.truth_(inst_32046)){
var statearr_32083_32108 = state_32066__$1;
(statearr_32083_32108[(1)] = (11));

} else {
var statearr_32084_32109 = state_32066__$1;
(statearr_32084_32109[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32067 === (5))){
var inst_32024 = (state_32066[(9)]);
var state_32066__$1 = state_32066;
var statearr_32085_32110 = state_32066__$1;
(statearr_32085_32110[(2)] = inst_32024);

(statearr_32085_32110[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32067 === (14))){
var inst_32024 = (state_32066[(9)]);
var inst_32041 = (state_32066[(8)]);
var inst_32040 = (state_32066[(7)]);
var inst_32051 = fluree.db.query.analytical.left_outer_join.call(null,inst_32024,inst_32040);
var inst_32023 = inst_32041;
var inst_32024__$1 = inst_32051;
var state_32066__$1 = (function (){var statearr_32086 = state_32066;
(statearr_32086[(9)] = inst_32024__$1);

(statearr_32086[(12)] = inst_32023);

return statearr_32086;
})();
var statearr_32087_32111 = state_32066__$1;
(statearr_32087_32111[(2)] = null);

(statearr_32087_32111[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32067 === (16))){
var inst_32055 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32089_32112 = state_32066__$1;
(statearr_32089_32112[(2)] = inst_32055);

(statearr_32089_32112[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32067 === (10))){
var inst_32059 = (state_32066[(2)]);
var state_32066__$1 = state_32066;
var statearr_32090_32113 = state_32066__$1;
(statearr_32090_32113[(2)] = inst_32059);

(statearr_32090_32113[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32067 === (8))){
var inst_32024 = (state_32066[(9)]);
var inst_32041 = (state_32066[(8)]);
var tmp32088 = inst_32024;
var inst_32023 = inst_32041;
var inst_32024__$1 = tmp32088;
var state_32066__$1 = (function (){var statearr_32091 = state_32066;
(statearr_32091[(9)] = inst_32024__$1);

(statearr_32091[(12)] = inst_32023);

return statearr_32091;
})();
var statearr_32092_32114 = state_32066__$1;
(statearr_32092_32114[(2)] = null);

(statearr_32092_32114[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10945__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10945__auto____0 = (function (){
var statearr_32093 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32093[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10945__auto__);

(statearr_32093[(1)] = (1));

return statearr_32093;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10945__auto____1 = (function (state_32066){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_32066);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e32094){var ex__10948__auto__ = e32094;
var statearr_32095_32115 = state_32066;
(statearr_32095_32115[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_32066[(4)]))){
var statearr_32096_32116 = state_32066;
(statearr_32096_32116[(1)] = cljs.core.first.call(null,(state_32066[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32117 = state_32066;
state_32066 = G__32117;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10945__auto__ = function(state_32066){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10945__auto____1.call(this,state_32066);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10945__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10945__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_32097 = f__11019__auto__.call(null);
(statearr_32097[(6)] = c__11018__auto__);

return statearr_32097;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.call(null,(function (acc,p__32119){
var vec__32120 = p__32119;
var var_name = cljs.core.nth.call(null,vec__32120,(0),null);
var var_val = cljs.core.nth.call(null,vec__32120,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__32118_SHARP_){
return cljs.core.conj.call(null,p1__32118_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__32124,p__32125,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__32126 = p__32124;
var map__32126__$1 = cljs.core.__destructure_map.call(null,map__32126);
var q_map = map__32126__$1;
var prefixes = cljs.core.get.call(null,map__32126__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__32127 = p__32125;
var map__32127__$1 = cljs.core.__destructure_map.call(null,map__32127);
var res = map__32127__$1;
var vars = cljs.core.get.call(null,map__32127__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_32364){
var state_val_32365 = (state_32364[(1)]);
if((state_val_32365 === (65))){
var inst_32313 = (state_32364[(7)]);
var inst_32314 = (state_32364[(8)]);
var inst_32325 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32326 = fluree.db.query.analytical.full_text__GT_tuples.call(null,inst_32313,res,inst_32314);
var inst_32327 = [inst_32326,r];
var inst_32328 = (new cljs.core.PersistentVector(null,2,(5),inst_32325,inst_32327,null));
var state_32364__$1 = state_32364;
var statearr_32366_32471 = state_32364__$1;
(statearr_32366_32471[(2)] = inst_32328);

(statearr_32366_32471[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (70))){
var inst_32340 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
var statearr_32367_32472 = state_32364__$1;
(statearr_32367_32472[(2)] = inst_32340);

(statearr_32367_32472[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (62))){
var inst_32314 = (state_32364[(8)]);
var inst_32322 = cljs.core.second.call(null,inst_32314);
var inst_32323 = clojure.string.starts_with_QMARK_.call(null,inst_32322,"fullText:");
var state_32364__$1 = state_32364;
if(inst_32323){
var statearr_32368_32473 = state_32364__$1;
(statearr_32368_32473[(1)] = (65));

} else {
var statearr_32369_32474 = state_32364__$1;
(statearr_32369_32474[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (7))){
var inst_32233 = (state_32364[(9)]);
var inst_32232 = cljs.core.count.call(null,clause);
var inst_32233__$1 = cljs.core._EQ_.call(null,(3),inst_32232);
var state_32364__$1 = (function (){var statearr_32370 = state_32364;
(statearr_32370[(9)] = inst_32233__$1);

return statearr_32370;
})();
if(inst_32233__$1){
var statearr_32371_32475 = state_32364__$1;
(statearr_32371_32475[(1)] = (31));

} else {
var statearr_32372_32476 = state_32364__$1;
(statearr_32372_32476[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (59))){
var inst_32347 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
var statearr_32373_32477 = state_32364__$1;
(statearr_32373_32477[(2)] = inst_32347);

(statearr_32373_32477[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (20))){
var inst_32196 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
var statearr_32374_32478 = state_32364__$1;
(statearr_32374_32478[(2)] = inst_32196);

(statearr_32374_32478[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (58))){
var state_32364__$1 = state_32364;
var statearr_32375_32479 = state_32364__$1;
(statearr_32375_32479[(2)] = null);

(statearr_32375_32479[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (60))){
var inst_32313 = (state_32364[(7)]);
var inst_32311 = (state_32364[(2)]);
var inst_32312 = fluree.db.util.async.throw_err.call(null,inst_32311);
var inst_32313__$1 = cljs.core.nth.call(null,inst_32312,(0),null);
var inst_32314 = cljs.core.nth.call(null,inst_32312,(1),null);
var inst_32315 = cljs.core._EQ_.call(null,"$wd",inst_32313__$1);
var state_32364__$1 = (function (){var statearr_32376 = state_32364;
(statearr_32376[(7)] = inst_32313__$1);

(statearr_32376[(8)] = inst_32314);

return statearr_32376;
})();
if(inst_32315){
var statearr_32377_32480 = state_32364__$1;
(statearr_32377_32480[(1)] = (61));

} else {
var statearr_32378_32481 = state_32364__$1;
(statearr_32378_32481[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (27))){
var inst_32226 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
var statearr_32379_32482 = state_32364__$1;
(statearr_32379_32482[(2)] = inst_32226);

(statearr_32379_32482[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (1))){
var state_32364__$1 = state_32364;
var statearr_32380_32483 = state_32364__$1;
(statearr_32380_32483[(2)] = null);

(statearr_32380_32483[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (69))){
var state_32364__$1 = state_32364;
var statearr_32381_32484 = state_32364__$1;
(statearr_32381_32484[(2)] = null);

(statearr_32381_32484[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (24))){
var inst_32190 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
var statearr_32382_32485 = state_32364__$1;
(statearr_32382_32485[(2)] = inst_32190);

(statearr_32382_32485[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (55))){
var inst_32296 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_32297 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_32298 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_32299 = cljs.core.PersistentHashMap.fromArrays(inst_32297,inst_32298);
var inst_32300 = cljs.core.ex_info.call(null,inst_32296,inst_32299);
var inst_32301 = (function(){throw inst_32300})();
var state_32364__$1 = state_32364;
var statearr_32383_32486 = state_32364__$1;
(statearr_32383_32486[(2)] = inst_32301);

(statearr_32383_32486[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (39))){
var inst_32253 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
if(cljs.core.truth_(inst_32253)){
var statearr_32384_32487 = state_32364__$1;
(statearr_32384_32487[(1)] = (40));

} else {
var statearr_32385_32488 = state_32364__$1;
(statearr_32385_32488[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (46))){
var inst_32353 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
var statearr_32386_32489 = state_32364__$1;
(statearr_32386_32489[(2)] = inst_32353);

(statearr_32386_32489[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (4))){
var inst_32128 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
var statearr_32387_32490 = state_32364__$1;
(statearr_32387_32490[(2)] = inst_32128);

(statearr_32387_32490[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (54))){
var inst_32289 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_32290 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_32291 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_32292 = cljs.core.PersistentHashMap.fromArrays(inst_32290,inst_32291);
var inst_32293 = cljs.core.ex_info.call(null,inst_32289,inst_32292);
var inst_32294 = (function(){throw inst_32293})();
var state_32364__$1 = state_32364;
var statearr_32388_32491 = state_32364__$1;
(statearr_32388_32491[(2)] = inst_32294);

(statearr_32388_32491[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (15))){
var inst_32228 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
var statearr_32389_32492 = state_32364__$1;
(statearr_32389_32492[(2)] = inst_32228);

(statearr_32389_32492[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (48))){
var inst_32277 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32278 = fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,clause);
var inst_32279 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_32278);
var inst_32280 = [inst_32279,r];
var inst_32281 = (new cljs.core.PersistentVector(null,2,(5),inst_32277,inst_32280,null));
var state_32364__$1 = state_32364;
var statearr_32390_32493 = state_32364__$1;
(statearr_32390_32493[(2)] = inst_32281);

(statearr_32390_32493[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (50))){
var inst_32351 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
var statearr_32391_32494 = state_32364__$1;
(statearr_32391_32494[(2)] = inst_32351);

(statearr_32391_32494[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (21))){
var inst_32173 = (state_32364[(10)]);
var inst_32137 = (state_32364[(11)]);
var inst_32164 = (state_32364[(12)]);
var inst_32162 = (state_32364[(13)]);
var inst_32166 = (state_32364[(14)]);
var inst_32141 = (state_32364[(15)]);
var inst_32167 = (state_32364[(16)]);
var inst_32174 = (state_32364[(17)]);
var inst_32165 = (state_32364[(18)]);
var inst_32178 = (state_32364[(2)]);
var inst_32179 = fluree.db.util.async.throw_err.call(null,inst_32178);
var inst_32180 = (function (){var first__32171 = inst_32173;
var new_res = inst_32179;
var rest = inst_32174;
var tuples = inst_32167;
var vec__32169 = inst_32166;
var expr__32139 = inst_32137;
var pred__32138 = inst_32141;
var vec__32159 = inst_32162;
var segment_type = inst_32137;
var seq__32170 = inst_32174;
var first__32161 = inst_32164;
var clause_group = inst_32173;
var seq__32160 = inst_32165;
var G__32158 = inst_32166;
return (function (res__$1,var$){
return cljs.core.update.call(null,new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_32181 = cljs.core.keys.call(null,vars);
var inst_32182 = cljs.core.reduce.call(null,inst_32180,inst_32179,inst_32181);
var inst_32183 = fluree.db.query.analytical.res_absorb_vars.call(null,inst_32182);
var state_32364__$1 = (function (){var statearr_32392 = state_32364;
(statearr_32392[(19)] = inst_32183);

return statearr_32392;
})();
if(cljs.core.truth_(inst_32167)){
var statearr_32393_32495 = state_32364__$1;
(statearr_32393_32495[(1)] = (22));

} else {
var statearr_32394_32496 = state_32364__$1;
(statearr_32394_32496[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (31))){
var inst_32235 = cljs.core.second.call(null,clause);
var inst_32236 = clojure.string.starts_with_QMARK_.call(null,inst_32235,"fullText:");
var state_32364__$1 = state_32364;
var statearr_32395_32497 = state_32364__$1;
(statearr_32395_32497[(2)] = inst_32236);

(statearr_32395_32497[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (32))){
var inst_32233 = (state_32364[(9)]);
var state_32364__$1 = state_32364;
var statearr_32396_32498 = state_32364__$1;
(statearr_32396_32498[(2)] = inst_32233);

(statearr_32396_32498[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (40))){
var inst_32255 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32256 = fluree.db.query.analytical.collection__GT_tuples.call(null,db,res,clause);
var state_32364__$1 = (function (){var statearr_32397 = state_32364;
(statearr_32397[(20)] = inst_32255);

return statearr_32397;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32364__$1,(43),inst_32256);
} else {
if((state_val_32365 === (56))){
var inst_32303 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
var statearr_32398_32499 = state_32364__$1;
(statearr_32398_32499[(2)] = inst_32303);

(statearr_32398_32499[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (33))){
var inst_32239 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
if(cljs.core.truth_(inst_32239)){
var statearr_32399_32500 = state_32364__$1;
(statearr_32399_32500[(1)] = (34));

} else {
var statearr_32400_32501 = state_32364__$1;
(statearr_32400_32501[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (13))){
var inst_32162 = (state_32364[(13)]);
var inst_32162__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_32163 = cljs.core.seq.call(null,inst_32162__$1);
var inst_32164 = cljs.core.first.call(null,inst_32163);
var inst_32165 = cljs.core.next.call(null,inst_32163);
var inst_32166 = inst_32162__$1;
var inst_32167 = null;
var state_32364__$1 = (function (){var statearr_32401 = state_32364;
(statearr_32401[(12)] = inst_32164);

(statearr_32401[(13)] = inst_32162__$1);

(statearr_32401[(14)] = inst_32166);

(statearr_32401[(16)] = inst_32167);

(statearr_32401[(18)] = inst_32165);

return statearr_32401;
})();
var statearr_32402_32502 = state_32364__$1;
(statearr_32402_32502[(2)] = null);

(statearr_32402_32502[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (22))){
var inst_32183 = (state_32364[(19)]);
var inst_32167 = (state_32364[(16)]);
var inst_32174 = (state_32364[(17)]);
var inst_32185 = fluree.db.query.union.results.call(null,inst_32167,inst_32183);
var inst_32166 = inst_32174;
var inst_32167__$1 = inst_32185;
var state_32364__$1 = (function (){var statearr_32403 = state_32364;
(statearr_32403[(14)] = inst_32166);

(statearr_32403[(16)] = inst_32167__$1);

return statearr_32403;
})();
var statearr_32404_32503 = state_32364__$1;
(statearr_32404_32503[(2)] = null);

(statearr_32404_32503[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (36))){
var inst_32357 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
var statearr_32405_32504 = state_32364__$1;
(statearr_32405_32504[(2)] = inst_32357);

(statearr_32405_32504[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (41))){
var inst_32263 = cljs.core.count.call(null,clause);
var inst_32264 = cljs.core._EQ_.call(null,(3),inst_32263);
var state_32364__$1 = state_32364;
if(inst_32264){
var statearr_32406_32505 = state_32364__$1;
(statearr_32406_32505[(1)] = (44));

} else {
var statearr_32407_32506 = state_32364__$1;
(statearr_32407_32506[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (43))){
var inst_32255 = (state_32364[(20)]);
var inst_32258 = (state_32364[(2)]);
var inst_32259 = fluree.db.util.async.throw_err.call(null,inst_32258);
var inst_32260 = [inst_32259,r];
var inst_32261 = (new cljs.core.PersistentVector(null,2,(5),inst_32255,inst_32260,null));
var state_32364__$1 = state_32364;
var statearr_32408_32507 = state_32364__$1;
(statearr_32408_32507[(2)] = inst_32261);

(statearr_32408_32507[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (61))){
var inst_32314 = (state_32364[(8)]);
var inst_32317 = fluree.db.query.analytical.wikidata__GT_tuples.call(null,q_map,inst_32314,r,res,optional_QMARK_,fuel,max_fuel);
var state_32364__$1 = state_32364;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32364__$1,(64),inst_32317);
} else {
if((state_val_32365 === (29))){
var inst_32137 = (state_32364[(11)]);
var inst_32220 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32137)].join('');
var inst_32221 = (new Error(inst_32220));
var inst_32222 = (function(){throw inst_32221})();
var state_32364__$1 = state_32364;
var statearr_32409_32508 = state_32364__$1;
(statearr_32409_32508[(2)] = inst_32222);

(statearr_32409_32508[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (44))){
var inst_32266 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32267 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,db,res,clause,fuel,max_fuel);
var state_32364__$1 = (function (){var statearr_32410 = state_32364;
(statearr_32410[(21)] = inst_32266);

return statearr_32410;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32364__$1,(47),inst_32267);
} else {
if((state_val_32365 === (6))){
var inst_32137 = (state_32364[(11)]);
var inst_32141 = (state_32364[(15)]);
var inst_32136 = cljs.core.keys.call(null,clause);
var inst_32137__$1 = cljs.core.first.call(null,inst_32136);
var inst_32141__$1 = cljs.core._EQ_;
var inst_32142 = inst_32141__$1.call(null,new cljs.core.Keyword(null,"optional","optional",2053951509),inst_32137__$1);
var state_32364__$1 = (function (){var statearr_32411 = state_32364;
(statearr_32411[(11)] = inst_32137__$1);

(statearr_32411[(15)] = inst_32141__$1);

return statearr_32411;
})();
if(cljs.core.truth_(inst_32142)){
var statearr_32412_32509 = state_32364__$1;
(statearr_32412_32509[(1)] = (9));

} else {
var statearr_32413_32510 = state_32364__$1;
(statearr_32413_32510[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (28))){
var inst_32214 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32215 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_32216 = fluree.db.query.analytical.tuples__GT_filtered.call(null,res,inst_32215,optional_QMARK_);
var inst_32217 = [inst_32216,r];
var inst_32218 = (new cljs.core.PersistentVector(null,2,(5),inst_32214,inst_32217,null));
var state_32364__$1 = state_32364;
var statearr_32414_32511 = state_32364__$1;
(statearr_32414_32511[(2)] = inst_32218);

(statearr_32414_32511[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (64))){
var inst_32319 = (state_32364[(2)]);
var inst_32320 = fluree.db.util.async.throw_err.call(null,inst_32319);
var state_32364__$1 = state_32364;
var statearr_32415_32512 = state_32364__$1;
(statearr_32415_32512[(2)] = inst_32320);

(statearr_32415_32512[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (51))){
var inst_32286 = cljs.core.first.call(null,clause);
var inst_32287 = cljs.core.sequential_QMARK_.call(null,inst_32286);
var state_32364__$1 = state_32364;
if(inst_32287){
var statearr_32416_32513 = state_32364__$1;
(statearr_32416_32513[(1)] = (54));

} else {
var statearr_32417_32514 = state_32364__$1;
(statearr_32417_32514[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (25))){
var inst_32137 = (state_32364[(11)]);
var inst_32141 = (state_32364[(15)]);
var inst_32202 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_32203 = (function (){var segment_type = inst_32137;
var pred__32138 = inst_32141;
var expr__32139 = inst_32137;
var bindings = inst_32202;
return (function (p1__32123_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,p1__32123_SHARP_);
});
})();
var inst_32204 = cljs.core.map.call(null,inst_32203,inst_32202);
var inst_32205 = cljs.core.PersistentHashMap.EMPTY;
var inst_32206 = cljs.core.into.call(null,inst_32205,inst_32204);
var inst_32207 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32208 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_32206);
var inst_32209 = [inst_32208,r];
var inst_32210 = (new cljs.core.PersistentVector(null,2,(5),inst_32207,inst_32209,null));
var state_32364__$1 = state_32364;
var statearr_32418_32515 = state_32364__$1;
(statearr_32418_32515[(2)] = inst_32210);

(statearr_32418_32515[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (34))){
var inst_32241 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32242 = fluree.db.query.analytical.full_text__GT_tuples.call(null,db,res,clause);
var inst_32243 = [inst_32242,r];
var inst_32244 = (new cljs.core.PersistentVector(null,2,(5),inst_32241,inst_32243,null));
var state_32364__$1 = state_32364;
var statearr_32419_32516 = state_32364__$1;
(statearr_32419_32516[(2)] = inst_32244);

(statearr_32419_32516[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (17))){
var inst_32198 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
var statearr_32420_32517 = state_32364__$1;
(statearr_32420_32517[(2)] = inst_32198);

(statearr_32420_32517[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (3))){
var inst_32362 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32364__$1,inst_32362);
} else {
if((state_val_32365 === (12))){
var inst_32144 = (state_32364[(22)]);
var inst_32148 = (state_32364[(2)]);
var inst_32149 = fluree.db.util.async.throw_err.call(null,inst_32148);
var inst_32150 = [inst_32149,r];
var inst_32151 = (new cljs.core.PersistentVector(null,2,(5),inst_32144,inst_32150,null));
var state_32364__$1 = state_32364;
var statearr_32421_32518 = state_32364__$1;
(statearr_32421_32518[(2)] = inst_32151);

(statearr_32421_32518[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (2))){
var _ = (function (){var statearr_32422 = state_32364;
(statearr_32422[(4)] = cljs.core.cons.call(null,(5),(state_32364[(4)])));

return statearr_32422;
})();
var inst_32134 = cljs.core.map_QMARK_.call(null,clause);
var state_32364__$1 = state_32364;
if(inst_32134){
var statearr_32423_32519 = state_32364__$1;
(statearr_32423_32519[(1)] = (6));

} else {
var statearr_32424_32520 = state_32364__$1;
(statearr_32424_32520[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (66))){
var state_32364__$1 = state_32364;
var statearr_32425_32521 = state_32364__$1;
(statearr_32425_32521[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (23))){
var inst_32183 = (state_32364[(19)]);
var inst_32174 = (state_32364[(17)]);
var inst_32166 = inst_32174;
var inst_32167 = inst_32183;
var state_32364__$1 = (function (){var statearr_32427 = state_32364;
(statearr_32427[(14)] = inst_32166);

(statearr_32427[(16)] = inst_32167);

return statearr_32427;
})();
var statearr_32428_32522 = state_32364__$1;
(statearr_32428_32522[(2)] = null);

(statearr_32428_32522[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (47))){
var inst_32266 = (state_32364[(21)]);
var inst_32269 = (state_32364[(2)]);
var inst_32270 = fluree.db.util.async.throw_err.call(null,inst_32269);
var inst_32271 = [inst_32270,r];
var inst_32272 = (new cljs.core.PersistentVector(null,2,(5),inst_32266,inst_32271,null));
var state_32364__$1 = state_32364;
var statearr_32429_32523 = state_32364__$1;
(statearr_32429_32523[(2)] = inst_32272);

(statearr_32429_32523[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (35))){
var inst_32247 = (state_32364[(23)]);
var inst_32246 = cljs.core.count.call(null,clause);
var inst_32247__$1 = cljs.core._EQ_.call(null,(3),inst_32246);
var state_32364__$1 = (function (){var statearr_32430 = state_32364;
(statearr_32430[(23)] = inst_32247__$1);

return statearr_32430;
})();
if(inst_32247__$1){
var statearr_32431_32524 = state_32364__$1;
(statearr_32431_32524[(1)] = (37));

} else {
var statearr_32432_32525 = state_32364__$1;
(statearr_32432_32525[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (19))){
var inst_32167 = (state_32364[(16)]);
var inst_32192 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32193 = [inst_32167,r];
var inst_32194 = (new cljs.core.PersistentVector(null,2,(5),inst_32192,inst_32193,null));
var state_32364__$1 = state_32364;
var statearr_32433_32526 = state_32364__$1;
(statearr_32433_32526[(2)] = inst_32194);

(statearr_32433_32526[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (57))){
var inst_32309 = fluree.db.query.analytical.get_source_clause.call(null,db,clause,prefixes,opts);
var state_32364__$1 = state_32364;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32364__$1,(60),inst_32309);
} else {
if((state_val_32365 === (68))){
var inst_32313 = (state_32364[(7)]);
var inst_32314 = (state_32364[(8)]);
var inst_32331 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32332 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,inst_32313,res,inst_32314,fuel,max_fuel);
var state_32364__$1 = (function (){var statearr_32434 = state_32364;
(statearr_32434[(24)] = inst_32331);

return statearr_32434;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32364__$1,(71),inst_32332);
} else {
if((state_val_32365 === (11))){
var inst_32230 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
var statearr_32436_32527 = state_32364__$1;
(statearr_32436_32527[(2)] = inst_32230);

(statearr_32436_32527[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (9))){
var inst_32144 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32145 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_32146 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_32145,res,fuel,max_fuel,opts);
var state_32364__$1 = (function (){var statearr_32437 = state_32364;
(statearr_32437[(22)] = inst_32144);

return statearr_32437;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32364__$1,(12),inst_32146);
} else {
if((state_val_32365 === (5))){
var _ = (function (){var statearr_32438 = state_32364;
(statearr_32438[(4)] = cljs.core.rest.call(null,(state_32364[(4)])));

return statearr_32438;
})();
var state_32364__$1 = state_32364;
var ex32435 = (state_32364__$1[(2)]);
var statearr_32439_32528 = state_32364__$1;
(statearr_32439_32528[(5)] = ex32435);


if((ex32435 instanceof Error)){
var statearr_32440_32529 = state_32364__$1;
(statearr_32440_32529[(1)] = (4));

(statearr_32440_32529[(5)] = null);

} else {
throw ex32435;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (14))){
var inst_32137 = (state_32364[(11)]);
var inst_32141 = (state_32364[(15)]);
var inst_32200 = inst_32141.call(null,new cljs.core.Keyword(null,"bind","bind",-113428417),inst_32137);
var state_32364__$1 = state_32364;
if(cljs.core.truth_(inst_32200)){
var statearr_32441_32530 = state_32364__$1;
(statearr_32441_32530[(1)] = (25));

} else {
var statearr_32442_32531 = state_32364__$1;
(statearr_32442_32531[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (45))){
var inst_32274 = cljs.core.count.call(null,clause);
var inst_32275 = cljs.core._EQ_.call(null,(2),inst_32274);
var state_32364__$1 = state_32364;
if(inst_32275){
var statearr_32443_32532 = state_32364__$1;
(statearr_32443_32532[(1)] = (48));

} else {
var statearr_32444_32533 = state_32364__$1;
(statearr_32444_32533[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (53))){
var inst_32349 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
var statearr_32445_32534 = state_32364__$1;
(statearr_32445_32534[(2)] = inst_32349);

(statearr_32445_32534[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (26))){
var inst_32137 = (state_32364[(11)]);
var inst_32141 = (state_32364[(15)]);
var inst_32212 = inst_32141.call(null,new cljs.core.Keyword(null,"filter","filter",-948537934),inst_32137);
var state_32364__$1 = state_32364;
if(cljs.core.truth_(inst_32212)){
var statearr_32446_32535 = state_32364__$1;
(statearr_32446_32535[(1)] = (28));

} else {
var statearr_32447_32536 = state_32364__$1;
(statearr_32447_32536[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (16))){
var inst_32173 = (state_32364[(10)]);
var inst_32166 = (state_32364[(14)]);
var inst_32172 = cljs.core.seq.call(null,inst_32166);
var inst_32173__$1 = cljs.core.first.call(null,inst_32172);
var inst_32174 = cljs.core.next.call(null,inst_32172);
var state_32364__$1 = (function (){var statearr_32448 = state_32364;
(statearr_32448[(10)] = inst_32173__$1);

(statearr_32448[(17)] = inst_32174);

return statearr_32448;
})();
if(cljs.core.truth_(inst_32173__$1)){
var statearr_32449_32537 = state_32364__$1;
(statearr_32449_32537[(1)] = (18));

} else {
var statearr_32450_32538 = state_32364__$1;
(statearr_32450_32538[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (38))){
var inst_32247 = (state_32364[(23)]);
var state_32364__$1 = state_32364;
var statearr_32451_32539 = state_32364__$1;
(statearr_32451_32539[(2)] = inst_32247);

(statearr_32451_32539[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (30))){
var inst_32224 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
var statearr_32452_32540 = state_32364__$1;
(statearr_32452_32540[(2)] = inst_32224);

(statearr_32452_32540[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (10))){
var inst_32137 = (state_32364[(11)]);
var inst_32141 = (state_32364[(15)]);
var inst_32153 = inst_32141.call(null,new cljs.core.Keyword(null,"union","union",2142937499),inst_32137);
var state_32364__$1 = state_32364;
if(cljs.core.truth_(inst_32153)){
var statearr_32453_32541 = state_32364__$1;
(statearr_32453_32541[(1)] = (13));

} else {
var statearr_32454_32542 = state_32364__$1;
(statearr_32454_32542[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (18))){
var inst_32173 = (state_32364[(10)]);
var inst_32176 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_32173,q_map,vars,fuel,max_fuel,opts);
var state_32364__$1 = state_32364;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32364__$1,(21),inst_32176);
} else {
if((state_val_32365 === (52))){
var state_32364__$1 = state_32364;
var statearr_32455_32543 = state_32364__$1;
(statearr_32455_32543[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (67))){
var inst_32342 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
var statearr_32457_32544 = state_32364__$1;
(statearr_32457_32544[(2)] = inst_32342);

(statearr_32457_32544[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (71))){
var inst_32331 = (state_32364[(24)]);
var inst_32334 = (state_32364[(2)]);
var inst_32335 = fluree.db.util.async.throw_err.call(null,inst_32334);
var inst_32336 = [inst_32335,r];
var inst_32337 = (new cljs.core.PersistentVector(null,2,(5),inst_32331,inst_32336,null));
var state_32364__$1 = state_32364;
var statearr_32458_32545 = state_32364__$1;
(statearr_32458_32545[(2)] = inst_32337);

(statearr_32458_32545[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (42))){
var inst_32355 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
var statearr_32459_32546 = state_32364__$1;
(statearr_32459_32546[(2)] = inst_32355);

(statearr_32459_32546[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (37))){
var inst_32249 = cljs.core.second.call(null,clause);
var inst_32250 = cljs.core._EQ_.call(null,inst_32249,"rdf:type");
var state_32364__$1 = state_32364;
var statearr_32460_32547 = state_32364__$1;
(statearr_32460_32547[(2)] = inst_32250);

(statearr_32460_32547[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (63))){
var inst_32344 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
var statearr_32461_32548 = state_32364__$1;
(statearr_32461_32548[(2)] = inst_32344);

(statearr_32461_32548[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (8))){
var inst_32359 = (state_32364[(2)]);
var _ = (function (){var statearr_32462 = state_32364;
(statearr_32462[(4)] = cljs.core.rest.call(null,(state_32364[(4)])));

return statearr_32462;
})();
var state_32364__$1 = state_32364;
var statearr_32463_32549 = state_32364__$1;
(statearr_32463_32549[(2)] = inst_32359);

(statearr_32463_32549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32365 === (49))){
var inst_32283 = cljs.core.count.call(null,clause);
var inst_32284 = cljs.core._EQ_.call(null,(1),inst_32283);
var state_32364__$1 = state_32364;
if(inst_32284){
var statearr_32464_32550 = state_32364__$1;
(statearr_32464_32550[(1)] = (51));

} else {
var statearr_32465_32551 = state_32364__$1;
(statearr_32465_32551[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10945__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10945__auto____0 = (function (){
var statearr_32466 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32466[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10945__auto__);

(statearr_32466[(1)] = (1));

return statearr_32466;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10945__auto____1 = (function (state_32364){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_32364);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e32467){var ex__10948__auto__ = e32467;
var statearr_32468_32552 = state_32364;
(statearr_32468_32552[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_32364[(4)]))){
var statearr_32469_32553 = state_32364;
(statearr_32469_32553[(1)] = cljs.core.first.call(null,(state_32364[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32554 = state_32364;
state_32364 = G__32554;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10945__auto__ = function(state_32364){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10945__auto____1.call(this,state_32364);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10945__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10945__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_32470 = f__11019__auto__.call(null);
(statearr_32470[(6)] = c__11018__auto__);

return statearr_32470;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__32556 = arguments.length;
switch (G__32556) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.call(null,db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_32636){
var state_val_32637 = (state_32636[(1)]);
if((state_val_32637 === (7))){
var inst_32631 = (state_32636[(2)]);
var _ = (function (){var statearr_32638 = state_32636;
(statearr_32638[(4)] = cljs.core.rest.call(null,(state_32636[(4)])));

return statearr_32638;
})();
var state_32636__$1 = state_32636;
var statearr_32639_32687 = state_32636__$1;
(statearr_32639_32687[(2)] = inst_32631);

(statearr_32639_32687[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32637 === (20))){
var inst_32596 = (state_32636[(7)]);
var inst_32608 = (state_32636[(2)]);
var inst_32578 = inst_32596;
var inst_32579 = inst_32608;
var state_32636__$1 = (function (){var statearr_32640 = state_32636;
(statearr_32640[(8)] = inst_32579);

(statearr_32640[(9)] = inst_32578);

return statearr_32640;
})();
var statearr_32641_32688 = state_32636__$1;
(statearr_32641_32688[(2)] = null);

(statearr_32641_32688[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32637 === (1))){
var state_32636__$1 = state_32636;
var statearr_32642_32689 = state_32636__$1;
(statearr_32642_32689[(2)] = null);

(statearr_32642_32689[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32637 === (24))){
var inst_32579 = (state_32636[(8)]);
var inst_32595 = (state_32636[(10)]);
var inst_32596 = (state_32636[(7)]);
var inst_32616 = fluree.db.query.analytical.inner_join.call(null,inst_32579,inst_32595);
var inst_32578 = inst_32596;
var inst_32579__$1 = inst_32616;
var state_32636__$1 = (function (){var statearr_32643 = state_32636;
(statearr_32643[(8)] = inst_32579__$1);

(statearr_32643[(9)] = inst_32578);

return statearr_32643;
})();
var statearr_32644_32690 = state_32636__$1;
(statearr_32644_32690[(2)] = null);

(statearr_32644_32690[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32637 === (4))){
var inst_32557 = (state_32636[(2)]);
var state_32636__$1 = state_32636;
var statearr_32646_32691 = state_32636__$1;
(statearr_32646_32691[(2)] = inst_32557);

(statearr_32646_32691[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32637 === (15))){
var inst_32595 = (state_32636[(10)]);
var state_32636__$1 = state_32636;
if(cljs.core.truth_(inst_32595)){
var statearr_32647_32692 = state_32636__$1;
(statearr_32647_32692[(1)] = (18));

} else {
var statearr_32648_32693 = state_32636__$1;
(statearr_32648_32693[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32637 === (21))){
var inst_32579 = (state_32636[(8)]);
var inst_32596 = (state_32636[(7)]);
var tmp32645 = inst_32579;
var inst_32578 = inst_32596;
var inst_32579__$1 = tmp32645;
var state_32636__$1 = (function (){var statearr_32649 = state_32636;
(statearr_32649[(8)] = inst_32579__$1);

(statearr_32649[(9)] = inst_32578);

return statearr_32649;
})();
var statearr_32650_32694 = state_32636__$1;
(statearr_32650_32694[(2)] = null);

(statearr_32650_32694[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32637 === (13))){
var inst_32579 = (state_32636[(8)]);
var inst_32602 = cljs.core.dissoc.call(null,inst_32579,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_32603 = cljs.core.empty_QMARK_.call(null,inst_32602);
var state_32636__$1 = state_32636;
if(inst_32603){
var statearr_32651_32695 = state_32636__$1;
(statearr_32651_32695[(1)] = (15));

} else {
var statearr_32652_32696 = state_32636__$1;
(statearr_32652_32696[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32637 === (22))){
var state_32636__$1 = state_32636;
var statearr_32653_32697 = state_32636__$1;
(statearr_32653_32697[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32637 === (6))){
var inst_32578 = (state_32636[(9)]);
var inst_32585 = (state_32636[(11)]);
var inst_32584 = cljs.core.seq.call(null,inst_32578);
var inst_32585__$1 = cljs.core.first.call(null,inst_32584);
var inst_32586 = cljs.core.next.call(null,inst_32584);
var state_32636__$1 = (function (){var statearr_32655 = state_32636;
(statearr_32655[(12)] = inst_32586);

(statearr_32655[(11)] = inst_32585__$1);

return statearr_32655;
})();
if(cljs.core.truth_(inst_32585__$1)){
var statearr_32656_32698 = state_32636__$1;
(statearr_32656_32698[(1)] = (8));

} else {
var statearr_32657_32699 = state_32636__$1;
(statearr_32657_32699[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32637 === (25))){
var state_32636__$1 = state_32636;
var statearr_32658_32700 = state_32636__$1;
(statearr_32658_32700[(2)] = null);

(statearr_32658_32700[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32637 === (17))){
var inst_32624 = (state_32636[(2)]);
var state_32636__$1 = state_32636;
var statearr_32659_32701 = state_32636__$1;
(statearr_32659_32701[(2)] = inst_32624);

(statearr_32659_32701[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32637 === (3))){
var inst_32634 = (state_32636[(2)]);
var state_32636__$1 = state_32636;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32636__$1,inst_32634);
} else {
if((state_val_32637 === (12))){
var inst_32595 = (state_32636[(10)]);
var inst_32596 = (state_32636[(7)]);
var inst_32578 = inst_32596;
var inst_32579 = inst_32595;
var state_32636__$1 = (function (){var statearr_32660 = state_32636;
(statearr_32660[(8)] = inst_32579);

(statearr_32660[(9)] = inst_32578);

return statearr_32660;
})();
var statearr_32661_32702 = state_32636__$1;
(statearr_32661_32702[(2)] = null);

(statearr_32661_32702[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32637 === (2))){
var _ = (function (){var statearr_32662 = state_32636;
(statearr_32662[(4)] = cljs.core.cons.call(null,(5),(state_32636[(4)])));

return statearr_32662;
})();
var inst_32570 = where;
var inst_32571 = cljs.core.seq.call(null,inst_32570);
var inst_32572 = cljs.core.first.call(null,inst_32571);
var inst_32573 = cljs.core.next.call(null,inst_32571);
var inst_32574 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_32575 = fluree.db.query.analytical.symbolize_keys.call(null,vars);
var inst_32576 = [inst_32575];
var inst_32577 = cljs.core.PersistentHashMap.fromArrays(inst_32574,inst_32576);
var inst_32578 = inst_32570;
var inst_32579 = inst_32577;
var state_32636__$1 = (function (){var statearr_32663 = state_32636;
(statearr_32663[(8)] = inst_32579);

(statearr_32663[(9)] = inst_32578);

(statearr_32663[(13)] = inst_32572);

(statearr_32663[(14)] = inst_32573);

return statearr_32663;
})();
var statearr_32664_32703 = state_32636__$1;
(statearr_32664_32703[(2)] = null);

(statearr_32664_32703[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32637 === (23))){
var inst_32622 = (state_32636[(2)]);
var state_32636__$1 = state_32636;
var statearr_32665_32704 = state_32636__$1;
(statearr_32665_32704[(2)] = inst_32622);

(statearr_32665_32704[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32637 === (19))){
var inst_32579 = (state_32636[(8)]);
var state_32636__$1 = state_32636;
var statearr_32666_32705 = state_32636__$1;
(statearr_32666_32705[(2)] = inst_32579);

(statearr_32666_32705[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32637 === (11))){
var inst_32585 = (state_32636[(11)]);
var inst_32593 = (state_32636[(2)]);
var inst_32594 = fluree.db.util.async.throw_err.call(null,inst_32593);
var inst_32595 = cljs.core.nth.call(null,inst_32594,(0),null);
var inst_32596 = cljs.core.nth.call(null,inst_32594,(1),null);
var inst_32597 = cljs.core.count.call(null,inst_32585);
var inst_32598 = cljs.core._EQ_.call(null,(2),inst_32597);
var state_32636__$1 = (function (){var statearr_32668 = state_32636;
(statearr_32668[(10)] = inst_32595);

(statearr_32668[(7)] = inst_32596);

return statearr_32668;
})();
if(inst_32598){
var statearr_32669_32706 = state_32636__$1;
(statearr_32669_32706[(1)] = (12));

} else {
var statearr_32670_32707 = state_32636__$1;
(statearr_32670_32707[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32637 === (9))){
var inst_32579 = (state_32636[(8)]);
var state_32636__$1 = state_32636;
var statearr_32671_32708 = state_32636__$1;
(statearr_32671_32708[(2)] = inst_32579);

(statearr_32671_32708[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32637 === (5))){
var _ = (function (){var statearr_32672 = state_32636;
(statearr_32672[(4)] = cljs.core.rest.call(null,(state_32636[(4)])));

return statearr_32672;
})();
var state_32636__$1 = state_32636;
var ex32667 = (state_32636__$1[(2)]);
var statearr_32673_32709 = state_32636__$1;
(statearr_32673_32709[(5)] = ex32667);


if((ex32667 instanceof Error)){
var statearr_32674_32710 = state_32636__$1;
(statearr_32674_32710[(1)] = (4));

(statearr_32674_32710[(5)] = null);

} else {
throw ex32667;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32637 === (14))){
var inst_32626 = (state_32636[(2)]);
var state_32636__$1 = state_32636;
var statearr_32675_32711 = state_32636__$1;
(statearr_32675_32711[(2)] = inst_32626);

(statearr_32675_32711[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32637 === (26))){
var inst_32620 = (state_32636[(2)]);
var state_32636__$1 = state_32636;
var statearr_32676_32712 = state_32636__$1;
(statearr_32676_32712[(2)] = inst_32620);

(statearr_32676_32712[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32637 === (16))){
var inst_32595 = (state_32636[(10)]);
var inst_32611 = (inst_32595 == null);
var state_32636__$1 = state_32636;
if(cljs.core.truth_(inst_32611)){
var statearr_32677_32713 = state_32636__$1;
(statearr_32677_32713[(1)] = (21));

} else {
var statearr_32678_32714 = state_32636__$1;
(statearr_32678_32714[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32637 === (10))){
var inst_32629 = (state_32636[(2)]);
var state_32636__$1 = state_32636;
var statearr_32679_32715 = state_32636__$1;
(statearr_32679_32715[(2)] = inst_32629);

(statearr_32679_32715[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32637 === (18))){
var inst_32595 = (state_32636[(10)]);
var state_32636__$1 = state_32636;
var statearr_32680_32716 = state_32636__$1;
(statearr_32680_32716[(2)] = inst_32595);

(statearr_32680_32716[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32637 === (8))){
var inst_32579 = (state_32636[(8)]);
var inst_32586 = (state_32636[(12)]);
var inst_32585 = (state_32636[(11)]);
var inst_32591 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_32579,inst_32585,inst_32586,false,fuel,max_fuel,opts);
var state_32636__$1 = state_32636;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32636__$1,(11),inst_32591);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__10945__auto__ = null;
var fluree$db$query$analytical$state_machine__10945__auto____0 = (function (){
var statearr_32681 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32681[(0)] = fluree$db$query$analytical$state_machine__10945__auto__);

(statearr_32681[(1)] = (1));

return statearr_32681;
});
var fluree$db$query$analytical$state_machine__10945__auto____1 = (function (state_32636){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_32636);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e32682){var ex__10948__auto__ = e32682;
var statearr_32683_32717 = state_32636;
(statearr_32683_32717[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_32636[(4)]))){
var statearr_32684_32718 = state_32636;
(statearr_32684_32718[(1)] = cljs.core.first.call(null,(state_32636[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32719 = state_32636;
state_32636 = G__32719;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__10945__auto__ = function(state_32636){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__10945__auto____1.call(this,state_32636);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__10945__auto____0;
fluree$db$query$analytical$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__10945__auto____1;
return fluree$db$query$analytical$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_32685 = f__11019__auto__.call(null);
(statearr_32685[(6)] = c__11018__auto__);

return statearr_32685;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_32754){
var state_val_32755 = (state_32754[(1)]);
if((state_val_32755 === (7))){
var inst_32731 = (state_32754[(7)]);
var inst_32736 = (state_32754[(8)]);
var inst_32738 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_32731,inst_32736,fuel,max_fuel,opts);
var state_32754__$1 = state_32754;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32754__$1,(10),inst_32738);
} else {
if((state_val_32755 === (1))){
var state_32754__$1 = state_32754;
var statearr_32756_32781 = state_32754__$1;
(statearr_32756_32781[(2)] = null);

(statearr_32756_32781[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32755 === (4))){
var inst_32720 = (state_32754[(2)]);
var state_32754__$1 = state_32754;
var statearr_32757_32782 = state_32754__$1;
(statearr_32757_32782[(2)] = inst_32720);

(statearr_32757_32782[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32755 === (13))){
var inst_32749 = (state_32754[(2)]);
var _ = (function (){var statearr_32758 = state_32754;
(statearr_32758[(4)] = cljs.core.rest.call(null,(state_32754[(4)])));

return statearr_32758;
})();
var state_32754__$1 = state_32754;
var statearr_32759_32783 = state_32754__$1;
(statearr_32759_32783[(2)] = inst_32749);

(statearr_32759_32783[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32755 === (6))){
var inst_32731 = (state_32754[(7)]);
var inst_32735 = (state_32754[(2)]);
var inst_32736 = fluree.db.util.async.throw_err.call(null,inst_32735);
var state_32754__$1 = (function (){var statearr_32760 = state_32754;
(statearr_32760[(8)] = inst_32736);

return statearr_32760;
})();
if(cljs.core.truth_(inst_32731)){
var statearr_32761_32784 = state_32754__$1;
(statearr_32761_32784[(1)] = (7));

} else {
var statearr_32762_32785 = state_32754__$1;
(statearr_32762_32785[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32755 === (3))){
var inst_32752 = (state_32754[(2)]);
var state_32754__$1 = state_32754;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32754__$1,inst_32752);
} else {
if((state_val_32755 === (12))){
var inst_32744 = (state_32754[(9)]);
var state_32754__$1 = state_32754;
var statearr_32763_32786 = state_32754__$1;
(statearr_32763_32786[(2)] = inst_32744);

(statearr_32763_32786[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32755 === (2))){
var _ = (function (){var statearr_32764 = state_32754;
(statearr_32764[(4)] = cljs.core.cons.call(null,(5),(state_32754[(4)])));

return statearr_32764;
})();
var inst_32727 = q_map;
var inst_32728 = cljs.core.__destructure_map.call(null,inst_32727);
var inst_32729 = cljs.core.get.call(null,inst_32728,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_32730 = cljs.core.get.call(null,inst_32728,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_32731 = cljs.core.get.call(null,inst_32728,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_32732 = cljs.core.get.call(null,inst_32728,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_32733 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_32730,q_map,inst_32729,fuel,max_fuel,opts);
var state_32754__$1 = (function (){var statearr_32765 = state_32754;
(statearr_32765[(7)] = inst_32731);

(statearr_32765[(10)] = inst_32732);

return statearr_32765;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32754__$1,(6),inst_32733);
} else {
if((state_val_32755 === (11))){
var inst_32732 = (state_32754[(10)]);
var inst_32744 = (state_32754[(9)]);
var inst_32746 = fluree.db.query.analytical.tuples__GT_filtered.call(null,inst_32744,inst_32732,null);
var state_32754__$1 = state_32754;
var statearr_32767_32787 = state_32754__$1;
(statearr_32767_32787[(2)] = inst_32746);

(statearr_32767_32787[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32755 === (9))){
var inst_32732 = (state_32754[(10)]);
var inst_32744 = (state_32754[(2)]);
var state_32754__$1 = (function (){var statearr_32768 = state_32754;
(statearr_32768[(9)] = inst_32744);

return statearr_32768;
})();
if(cljs.core.truth_(inst_32732)){
var statearr_32769_32788 = state_32754__$1;
(statearr_32769_32788[(1)] = (11));

} else {
var statearr_32770_32789 = state_32754__$1;
(statearr_32770_32789[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32755 === (5))){
var _ = (function (){var statearr_32771 = state_32754;
(statearr_32771[(4)] = cljs.core.rest.call(null,(state_32754[(4)])));

return statearr_32771;
})();
var state_32754__$1 = state_32754;
var ex32766 = (state_32754__$1[(2)]);
var statearr_32772_32790 = state_32754__$1;
(statearr_32772_32790[(5)] = ex32766);


if((ex32766 instanceof Error)){
var statearr_32773_32791 = state_32754__$1;
(statearr_32773_32791[(1)] = (4));

(statearr_32773_32791[(5)] = null);

} else {
throw ex32766;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32755 === (10))){
var inst_32740 = (state_32754[(2)]);
var inst_32741 = fluree.db.util.async.throw_err.call(null,inst_32740);
var state_32754__$1 = state_32754;
var statearr_32774_32792 = state_32754__$1;
(statearr_32774_32792[(2)] = inst_32741);

(statearr_32774_32792[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32755 === (8))){
var inst_32736 = (state_32754[(8)]);
var state_32754__$1 = state_32754;
var statearr_32775_32793 = state_32754__$1;
(statearr_32775_32793[(2)] = inst_32736);

(statearr_32775_32793[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__10945__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__10945__auto____0 = (function (){
var statearr_32776 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32776[(0)] = fluree$db$query$analytical$q_$_state_machine__10945__auto__);

(statearr_32776[(1)] = (1));

return statearr_32776;
});
var fluree$db$query$analytical$q_$_state_machine__10945__auto____1 = (function (state_32754){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_32754);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e32777){var ex__10948__auto__ = e32777;
var statearr_32778_32794 = state_32754;
(statearr_32778_32794[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_32754[(4)]))){
var statearr_32779_32795 = state_32754;
(statearr_32779_32795[(1)] = cljs.core.first.call(null,(state_32754[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32796 = state_32754;
state_32754 = G__32796;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__10945__auto__ = function(state_32754){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__10945__auto____1.call(this,state_32754);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__10945__auto____0;
fluree$db$query$analytical$q_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__10945__auto____1;
return fluree$db$query$analytical$q_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_32780 = f__11019__auto__.call(null);
(statearr_32780[(6)] = c__11018__auto__);

return statearr_32780;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
