// Compiled by ClojureScript 1.11.57 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.call(null,(function (value_group){
var stringified = cljs.core.map.call(null,(function (p1__30833_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__30833_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.call(null," ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.call(null," ",value_groups);
return ["VALUES ( ",clojure.string.join.call(null," ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__30837 = coll;
var vec__30838 = G__30837;
var seq__30839 = cljs.core.seq.call(null,vec__30838);
var first__30840 = cljs.core.first.call(null,seq__30839);
var seq__30839__$1 = cljs.core.next.call(null,seq__30839);
var clause = first__30840;
var r = seq__30839__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__30837__$1 = G__30837;
var res__$1 = res;
while(true){
var vec__30844 = G__30837__$1;
var seq__30845 = cljs.core.seq.call(null,vec__30844);
var first__30846 = cljs.core.first.call(null,seq__30845);
var seq__30845__$1 = cljs.core.next.call(null,seq__30845);
var clause__$1 = first__30846;
var r__$1 = seq__30845__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__30847 = r__$1;
var G__30848 = cljs.core.conj.call(null,res__$2,clause__$1);
G__30837__$1 = G__30847;
res__$1 = G__30848;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.call(null,(function (res,p__30849){
var map__30850 = p__30849;
var map__30850__$1 = cljs.core.__destructure_map.call(null,map__30850);
var optional = cljs.core.get.call(null,map__30850__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.call(null,res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__30854 = coll;
var vec__30855 = G__30854;
var seq__30856 = cljs.core.seq.call(null,vec__30855);
var first__30857 = cljs.core.first.call(null,seq__30856);
var seq__30856__$1 = cljs.core.next.call(null,seq__30856);
var clause = first__30857;
var r = seq__30856__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__30854__$1 = G__30854;
var res__$1 = res;
while(true){
var vec__30861 = G__30854__$1;
var seq__30862 = cljs.core.seq.call(null,vec__30861);
var first__30863 = cljs.core.first.call(null,seq__30862);
var seq__30862__$1 = cljs.core.next.call(null,seq__30862);
var clause__$1 = first__30863;
var r__$1 = seq__30862__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__30864 = r__$1;
var G__30865 = cljs.core.conj.call(null,res__$2,cljs.core.rest.call(null,clause__$1));
G__30854__$1 = G__30864;
res__$1 = G__30865;
continue;
} else {
var G__30866 = r__$1;
var G__30867 = res__$2;
G__30854__$1 = G__30866;
res__$1 = G__30867;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__30871 = coll;
var vec__30872 = G__30871;
var seq__30873 = cljs.core.seq.call(null,vec__30872);
var first__30874 = cljs.core.first.call(null,seq__30873);
var seq__30873__$1 = cljs.core.next.call(null,seq__30873);
var clause = first__30874;
var r = seq__30873__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__30871__$1 = G__30871;
var res__$1 = res;
while(true){
var vec__30878 = G__30871__$1;
var seq__30879 = cljs.core.seq.call(null,vec__30878);
var first__30880 = cljs.core.first.call(null,seq__30879);
var seq__30879__$1 = cljs.core.next.call(null,seq__30879);
var clause__$1 = first__30880;
var r__$1 = seq__30879__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__30881 = r__$1;
var G__30882 = res__$2;
G__30871__$1 = G__30881;
res__$1 = G__30882;
continue;
} else {
var G__30883 = r__$1;
var G__30884 = cljs.core.conj.call(null,res__$2,clause__$1);
G__30871__$1 = G__30883;
res__$1 = G__30884;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__30887 = clause;
var G__30887__$1 = ((cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause)))?cljs.core.drop.call(null,(1),G__30887):G__30887);
var G__30887__$2 = clojure.string.join.call(null," ",G__30887__$1)
;
var G__30887__$3 = (function (p1__30885_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__30885_SHARP_)," ."].join('');
}).call(null,G__30887__$2)
;
if(cljs.core.truth_(optional_QMARK_)){
return (function (p1__30886_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__30886_SHARP_),"}"].join('');
}).call(null,G__30887__$3);
} else {
return G__30887__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.call(null,(function (acc_str,prefix){
var pfx = cljs.core.symbol.call(null,[fluree.db.util.core.keyword__GT_str.call(null,cljs.core.key.call(null,prefix)),":"].join(''));
var source = cljs.core.symbol.call(null,cljs.core.val.call(null,prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map));
var map__30891 = opts;
var map__30891__$1 = cljs.core.__destructure_map.call(null,map__30891);
var limit = cljs.core.get.call(null,map__30891__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__30891__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.call(null,map__30891__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.call(null,map__30891__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.call(null,map__30891__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes.call(null,prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.call(null," ",cljs.core.map.call(null,(function (p1__30888_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__30888_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.call(null," ",select_vars)].join('');
var where_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__30889_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__30889_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__30890_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__30890_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = language;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_30905){
var state_val_30906 = (state_30905[(1)]);
if((state_val_30906 === (1))){
var inst_30892 = fluree.db.util.core.url_encode.call(null,query);
var inst_30893 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_30892)].join('');
var inst_30894 = ["User-Agent","Accept"];
var inst_30895 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_30896 = cljs.core.PersistentHashMap.fromArrays(inst_30894,inst_30895);
var inst_30897 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_30898 = [inst_30896,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_30899 = cljs.core.PersistentHashMap.fromArrays(inst_30897,inst_30898);
var inst_30900 = fluree.db.util.xhttp.get.call(null,inst_30893,inst_30899);
var state_30905__$1 = state_30905;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30905__$1,(2),inst_30900);
} else {
if((state_val_30906 === (2))){
var inst_30902 = (state_30905[(2)]);
var inst_30903 = fluree.db.util.async.throw_err.call(null,inst_30902);
var state_30905__$1 = state_30905;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30905__$1,inst_30903);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10945__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10945__auto____0 = (function (){
var statearr_30907 = [null,null,null,null,null,null,null];
(statearr_30907[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10945__auto__);

(statearr_30907[(1)] = (1));

return statearr_30907;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10945__auto____1 = (function (state_30905){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_30905);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e30908){var ex__10948__auto__ = e30908;
var statearr_30909_30912 = state_30905;
(statearr_30909_30912[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_30905[(4)]))){
var statearr_30910_30913 = state_30905;
(statearr_30910_30913[(1)] = cljs.core.first.call(null,(state_30905[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30914 = state_30905;
state_30905 = G__30914;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10945__auto__ = function(state_30905){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10945__auto____1.call(this,state_30905);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10945__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10945__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_30911 = f__11019__auto__.call(null);
(statearr_30911[(6)] = c__11018__auto__);

return statearr_30911;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_30932){
var state_val_30933 = (state_30932[(1)]);
if((state_val_30933 === (1))){
var inst_30915 = fluree.db.query.analytical_wikidata.submit_wikidata_query.call(null,query);
var state_30932__$1 = state_30932;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30932__$1,(2),inst_30915);
} else {
if((state_val_30933 === (2))){
var inst_30918 = (state_30932[(7)]);
var inst_30917 = (state_30932[(2)]);
var inst_30918__$1 = fluree.db.util.async.throw_err.call(null,inst_30917);
var inst_30919 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_30918__$1);
var inst_30920 = cljs.core.not_EQ_.call(null,(200),inst_30919);
var state_30932__$1 = (function (){var statearr_30934 = state_30932;
(statearr_30934[(7)] = inst_30918__$1);

return statearr_30934;
})();
if(inst_30920){
var statearr_30935_30944 = state_30932__$1;
(statearr_30935_30944[(1)] = (3));

} else {
var statearr_30936_30945 = state_30932__$1;
(statearr_30936_30945[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30933 === (3))){
var inst_30918 = (state_30932[(7)]);
var state_30932__$1 = state_30932;
var statearr_30937_30946 = state_30932__$1;
(statearr_30937_30946[(2)] = inst_30918);

(statearr_30937_30946[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30933 === (4))){
var inst_30918 = (state_30932[(7)]);
var inst_30923 = (function (){var body = inst_30918;
return (function (item){
return cljs.core.reduce.call(null,(function (acc,k_v){
return cljs.core.assoc.call(null,acc,cljs.core.key.call(null,k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_30924 = cljs.core.second.call(null,inst_30918);
var inst_30925 = cljs.core.second.call(null,inst_30924);
var inst_30926 = cljs.core.first.call(null,inst_30925);
var inst_30927 = cljs.core.second.call(null,inst_30926);
var inst_30928 = cljs.core.mapv.call(null,inst_30923,inst_30927);
var state_30932__$1 = state_30932;
var statearr_30938_30947 = state_30932__$1;
(statearr_30938_30947[(2)] = inst_30928);

(statearr_30938_30947[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30933 === (5))){
var inst_30930 = (state_30932[(2)]);
var state_30932__$1 = state_30932;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30932__$1,inst_30930);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10945__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10945__auto____0 = (function (){
var statearr_30939 = [null,null,null,null,null,null,null,null];
(statearr_30939[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10945__auto__);

(statearr_30939[(1)] = (1));

return statearr_30939;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10945__auto____1 = (function (state_30932){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_30932);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e30940){var ex__10948__auto__ = e30940;
var statearr_30941_30948 = state_30932;
(statearr_30941_30948[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_30932[(4)]))){
var statearr_30942_30949 = state_30932;
(statearr_30942_30949[(1)] = cljs.core.first.call(null,(state_30932[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30950 = state_30932;
state_30932 = G__30950;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10945__auto__ = function(state_30932){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10945__auto____1.call(this,state_30932);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10945__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10945__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_30943 = f__11019__auto__.call(null);
(statearr_30943[(6)] = c__11018__auto__);

return statearr_30943;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.call(null,(function (p1__30951_SHARP_){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__30951_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.call(null,(function (p1__30952_SHARP_){
return fluree.db.util.core.str__GT_keyword.call(null,cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__30952_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.call(null,(function (res){
return cljs.core.map.call(null,(function (p1__30953_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(p1__30953_SHARP_.call(null,res));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_30999){
var state_val_31000 = (state_30999[(1)]);
if((state_val_31000 === (7))){
var inst_30964 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt.call(null,matching_vars,matching_vals);
var state_30999__$1 = state_30999;
var statearr_31001_31029 = state_30999__$1;
(statearr_31001_31029[(2)] = inst_30964);

(statearr_31001_31029[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31000 === (1))){
var state_30999__$1 = state_30999;
var statearr_31002_31030 = state_30999__$1;
(statearr_31002_31030[(2)] = null);

(statearr_31002_31030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31000 === (4))){
var inst_30954 = (state_30999[(2)]);
var state_30999__$1 = state_30999;
var statearr_31003_31031 = state_30999__$1;
(statearr_31003_31031[(2)] = inst_30954);

(statearr_31003_31031[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31000 === (15))){
var inst_30978 = (state_30999[(7)]);
var inst_30972 = (state_30999[(8)]);
var inst_30973 = (state_30999[(9)]);
var inst_30983 = (state_30999[(2)]);
var inst_30984 = cljs.core.subs.call(null,inst_30978,(0),inst_30983);
var inst_30985 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30986 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_30972);
var inst_30987 = [inst_30973,inst_30986];
var inst_30988 = cljs.core.PersistentHashMap.fromArrays(inst_30985,inst_30987);
var inst_30989 = cljs.core.ex_info.call(null,inst_30984,inst_30988);
var inst_30990 = (function(){throw inst_30989})();
var state_30999__$1 = state_30999;
var statearr_31004_31032 = state_30999__$1;
(statearr_31004_31032[(2)] = inst_30990);

(statearr_31004_31032[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31000 === (13))){
var inst_30977 = (state_30999[(10)]);
var state_30999__$1 = state_30999;
var statearr_31005_31033 = state_30999__$1;
(statearr_31005_31033[(2)] = inst_30977);

(statearr_31005_31033[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31000 === (6))){
var state_30999__$1 = state_30999;
var statearr_31006_31034 = state_30999__$1;
(statearr_31006_31034[(2)] = null);

(statearr_31006_31034[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31000 === (3))){
var inst_30997 = (state_30999[(2)]);
var state_30999__$1 = state_30999;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30999__$1,inst_30997);
} else {
if((state_val_31000 === (12))){
var inst_30994 = (state_30999[(2)]);
var _ = (function (){var statearr_31007 = state_30999;
(statearr_31007[(4)] = cljs.core.rest.call(null,(state_30999[(4)])));

return statearr_31007;
})();
var state_30999__$1 = state_30999;
var statearr_31008_31035 = state_30999__$1;
(statearr_31008_31035[(2)] = inst_30994);

(statearr_31008_31035[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31000 === (2))){
var _ = (function (){var statearr_31009 = state_30999;
(statearr_31009[(4)] = cljs.core.cons.call(null,(5),(state_30999[(4)])));

return statearr_31009;
})();
var inst_30961 = cljs.core.empty_QMARK_.call(null,matching_vars);
var state_30999__$1 = state_30999;
if(inst_30961){
var statearr_31010_31036 = state_30999__$1;
(statearr_31010_31036[(1)] = (6));

} else {
var statearr_31011_31037 = state_30999__$1;
(statearr_31011_31037[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31000 === (11))){
var inst_30972 = (state_30999[(8)]);
var inst_30992 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples.call(null,inst_30972,all_vars);
var state_30999__$1 = state_30999;
var statearr_31013_31038 = state_30999__$1;
(statearr_31013_31038[(2)] = inst_30992);

(statearr_31013_31038[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31000 === (9))){
var inst_30972 = (state_30999[(8)]);
var inst_30973 = (state_30999[(9)]);
var inst_30970 = (state_30999[(2)]);
var inst_30971 = fluree.db.util.async.throw_err.call(null,inst_30970);
var inst_30972__$1 = cljs.core.__destructure_map.call(null,inst_30971);
var inst_30973__$1 = cljs.core.get.call(null,inst_30972__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_30974 = cljs.core.get.call(null,inst_30972__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_30975 = cljs.core._EQ_.call(null,(400),inst_30973__$1);
var state_30999__$1 = (function (){var statearr_31014 = state_30999;
(statearr_31014[(8)] = inst_30972__$1);

(statearr_31014[(9)] = inst_30973__$1);

(statearr_31014[(11)] = inst_30974);

return statearr_31014;
})();
if(inst_30975){
var statearr_31015_31039 = state_30999__$1;
(statearr_31015_31039[(1)] = (10));

} else {
var statearr_31016_31040 = state_30999__$1;
(statearr_31016_31040[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31000 === (5))){
var _ = (function (){var statearr_31017 = state_30999;
(statearr_31017[(4)] = cljs.core.rest.call(null,(state_30999[(4)])));

return statearr_31017;
})();
var state_30999__$1 = state_30999;
var ex31012 = (state_30999__$1[(2)]);
var statearr_31018_31041 = state_30999__$1;
(statearr_31018_31041[(5)] = ex31012);


if((ex31012 instanceof Error)){
var statearr_31019_31042 = state_30999__$1;
(statearr_31019_31042[(1)] = (4));

(statearr_31019_31042[(5)] = null);

} else {
throw ex31012;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31000 === (14))){
var state_30999__$1 = state_30999;
var statearr_31020_31043 = state_30999__$1;
(statearr_31020_31043[(2)] = (1000));

(statearr_31020_31043[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31000 === (10))){
var inst_30977 = (state_30999[(10)]);
var inst_30972 = (state_30999[(8)]);
var inst_30974 = (state_30999[(11)]);
var inst_30977__$1 = cljs.core.count.call(null,inst_30974);
var inst_30978 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_30972);
var inst_30979 = (inst_30977__$1 < (1000));
var state_30999__$1 = (function (){var statearr_31021 = state_30999;
(statearr_31021[(7)] = inst_30978);

(statearr_31021[(10)] = inst_30977__$1);

return statearr_31021;
})();
if(cljs.core.truth_(inst_30979)){
var statearr_31022_31044 = state_30999__$1;
(statearr_31022_31044[(1)] = (13));

} else {
var statearr_31023_31045 = state_30999__$1;
(statearr_31023_31045[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31000 === (8))){
var inst_30966 = (state_30999[(2)]);
var inst_30967 = fluree.db.query.analytical_wikidata.generateWikiDataQuery.call(null,q_map,clauses,all_vars,inst_30966,optional_clauses);
var inst_30968 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query.call(null,inst_30967);
var state_30999__$1 = state_30999;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30999__$1,(9),inst_30968);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10945__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10945__auto____0 = (function (){
var statearr_31024 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31024[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10945__auto__);

(statearr_31024[(1)] = (1));

return statearr_31024;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10945__auto____1 = (function (state_30999){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_30999);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e31025){var ex__10948__auto__ = e31025;
var statearr_31026_31046 = state_30999;
(statearr_31026_31046[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_30999[(4)]))){
var statearr_31027_31047 = state_30999;
(statearr_31027_31047[(1)] = cljs.core.first.call(null,(state_30999[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31048 = state_30999;
state_30999 = G__31048;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10945__auto__ = function(state_30999){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10945__auto____1.call(this,state_30999);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10945__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10945__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_31028 = f__11019__auto__.call(null);
(statearr_31028[(6)] = c__11018__auto__);

return statearr_31028;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
