// Compiled by ClojureScript 1.11.57 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__33041 = arguments.length;
switch (G__33041) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol)));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2,arg3));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__33044 = arguments.length;
switch (G__33044) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__33046 = null;
var G__33046__0 = (function (){
return xf.call(null);
});
var G__33046__1 = (function (result){
return xf.call(null,result);
});
var G__33046__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__33046 = function(result,flake){
switch(arguments.length){
case 0:
return G__33046__0.call(this);
case 1:
return G__33046__1.call(this,result);
case 2:
return G__33046__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__33046.cljs$core$IFn$_invoke$arity$0 = G__33046__0;
G__33046.cljs$core$IFn$_invoke$arity$1 = G__33046__1;
G__33046.cljs$core$IFn$_invoke$arity$2 = G__33046__2;
return G__33046;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__33047 = null;
var G__33047__0 = (function (){
return xf.call(null);
});
var G__33047__1 = (function (result){
return xf.call(null,result);
});
var G__33047__2 = (function (result,flakes){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,cljs.core.count.call(null,flakes));

return xf.call(null,result,flakes);
});
G__33047 = function(result,flakes){
switch(arguments.length){
case 0:
return G__33047__0.call(this);
case 1:
return G__33047__1.call(this,result);
case 2:
return G__33047__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__33047.cljs$core$IFn$_invoke$arity$0 = G__33047__0;
G__33047.cljs$core$IFn$_invoke$arity$1 = G__33047__1;
G__33047.cljs$core$IFn$_invoke$arity$2 = G__33047__2;
return G__33047;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__5045__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config.call(null,db,p,compact_QMARK_);
fluree.db.query.fql.vswap_BANG_.call(null,cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_.call(null,res)){
var G__33049 = res;
var G__33049__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.call(null,(function (p1__33048_SHARP_){
return cljs.core.get.call(null,p1__33048_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__33049):G__33049);
var G__33049__$2 = ((cljs.core._EQ_.call(null,"DESC",sortOrder))?cljs.core.reverse.call(null,G__33049__$1):G__33049__$1);
var G__33049__$3 = (cljs.core.truth_(offset)?cljs.core.drop.call(null,offset,G__33049__$2):G__33049__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.call(null,limit,G__33049__$3);
} else {
return G__33049__$3;
}
} else {
return res;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__33053 = arguments.length;
switch (G__33053) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_33492){
var state_val_33493 = (state_33492[(1)]);
if((state_val_33493 === (121))){
var inst_33415 = (state_33492[(2)]);
var inst_33416 = fluree.db.util.async.throw_err.call(null,inst_33415);
var inst_33417 = cljs.core.seq.call(null,inst_33416);
var state_33492__$1 = state_33492;
if(inst_33417){
var statearr_33494_33708 = state_33492__$1;
(statearr_33494_33708[(1)] = (122));

} else {
var statearr_33495_33709 = state_33492__$1;
(statearr_33495_33709[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (65))){
var inst_33208 = (state_33492[(7)]);
var inst_33207 = (state_33492[(2)]);
var inst_33208__$1 = fluree.db.util.async.throw_err.call(null,inst_33207);
var inst_33209 = cljs.core.seq.call(null,inst_33208__$1);
var state_33492__$1 = (function (){var statearr_33496 = state_33492;
(statearr_33496[(7)] = inst_33208__$1);

return statearr_33496;
})();
if(inst_33209){
var statearr_33497_33710 = state_33492__$1;
(statearr_33497_33710[(1)] = (66));

} else {
var statearr_33498_33711 = state_33492__$1;
(statearr_33498_33711[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (70))){
var inst_33208 = (state_33492[(7)]);
var inst_33219 = cljs.core.count.call(null,inst_33208);
var inst_33220 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_33219);
var state_33492__$1 = state_33492;
var statearr_33499_33712 = state_33492__$1;
(statearr_33499_33712[(2)] = inst_33220);

(statearr_33499_33712[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (62))){
var inst_33198 = (state_33492[(8)]);
var inst_33201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33202 = inst_33198.o;
var inst_33203 = [inst_33202];
var inst_33204 = (new cljs.core.PersistentVector(null,1,(5),inst_33201,inst_33203,null));
var inst_33205 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_33204);
var state_33492__$1 = state_33492;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33492__$1,(65),inst_33205);
} else {
if((state_val_33493 === (74))){
var inst_33192 = (state_33492[(9)]);
var state_33492__$1 = state_33492;
var statearr_33500_33713 = state_33492__$1;
(statearr_33500_33713[(2)] = inst_33192);

(statearr_33500_33713[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (110))){
var inst_33377 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_33378 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_33377);
var inst_33379 = inst_33378 === true;
var state_33492__$1 = state_33492;
if(cljs.core.truth_(inst_33379)){
var statearr_33501_33714 = state_33492__$1;
(statearr_33501_33714[(1)] = (113));

} else {
var statearr_33502_33715 = state_33492__$1;
(statearr_33502_33715[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (130))){
var inst_33487 = (state_33492[(2)]);
var _ = (function (){var statearr_33503 = state_33492;
(statearr_33503[(4)] = cljs.core.rest.call(null,(state_33492[(4)])));

return statearr_33503;
})();
var state_33492__$1 = state_33492;
var statearr_33504_33716 = state_33492__$1;
(statearr_33504_33716[(2)] = inst_33487);

(statearr_33504_33716[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (128))){
var inst_33462 = (state_33492[(10)]);
var inst_33465 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33466 = [acc,inst_33462];
var inst_33467 = (new cljs.core.PersistentVector(null,2,(5),inst_33465,inst_33466,null));
var state_33492__$1 = state_33492;
var statearr_33505_33717 = state_33492__$1;
(statearr_33505_33717[(2)] = inst_33467);

(statearr_33505_33717[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (7))){
var inst_33065 = (state_33492[(11)]);
var state_33492__$1 = state_33492;
var statearr_33506_33718 = state_33492__$1;
(statearr_33506_33718[(2)] = inst_33065);

(statearr_33506_33718[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (59))){
var inst_33456 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
var statearr_33507_33719 = state_33492__$1;
(statearr_33507_33719[(2)] = inst_33456);

(statearr_33507_33719[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (86))){
var inst_33286 = (state_33492[(12)]);
var inst_33286__$1 = (state_33492[(2)]);
var state_33492__$1 = (function (){var statearr_33508 = state_33492;
(statearr_33508[(12)] = inst_33286__$1);

return statearr_33508;
})();
if(cljs.core.truth_(inst_33286__$1)){
var statearr_33509_33720 = state_33492__$1;
(statearr_33509_33720[(1)] = (88));

} else {
var statearr_33510_33721 = state_33492__$1;
(statearr_33510_33721[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (20))){
var inst_33106 = (state_33492[(13)]);
var inst_33107 = (state_33492[(14)]);
var inst_33094 = (state_33492[(15)]);
var inst_33105 = (state_33492[(2)]);
var inst_33106__$1 = cljs.core.__destructure_map.call(null,inst_33094);
var inst_33107__$1 = cljs.core.get.call(null,inst_33106__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_33108 = cljs.core.get.call(null,inst_33106__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_33109 = cljs.core.get.call(null,inst_33106__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_33110 = cljs.core.get.call(null,inst_33106__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_33111 = cljs.core.get.call(null,inst_33106__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_33112 = cljs.core.get.call(null,inst_33106__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_33492__$1 = (function (){var statearr_33511 = state_33492;
(statearr_33511[(16)] = inst_33109);

(statearr_33511[(17)] = inst_33112);

(statearr_33511[(18)] = inst_33111);

(statearr_33511[(13)] = inst_33106__$1);

(statearr_33511[(14)] = inst_33107__$1);

(statearr_33511[(19)] = inst_33108);

(statearr_33511[(20)] = inst_33110);

(statearr_33511[(21)] = inst_33105);

return statearr_33511;
})();
if(cljs.core.truth_(inst_33107__$1)){
var statearr_33512_33722 = state_33492__$1;
(statearr_33512_33722[(1)] = (24));

} else {
var statearr_33513_33723 = state_33492__$1;
(statearr_33513_33723[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (72))){
var inst_33217 = (state_33492[(22)]);
var inst_33223 = (state_33492[(2)]);
var inst_33224 = cljs.core.seq.call(null,inst_33217);
var state_33492__$1 = (function (){var statearr_33514 = state_33492;
(statearr_33514[(23)] = inst_33223);

return statearr_33514;
})();
if(inst_33224){
var statearr_33515_33724 = state_33492__$1;
(statearr_33515_33724[(1)] = (73));

} else {
var statearr_33516_33725 = state_33492__$1;
(statearr_33516_33725[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (58))){
var inst_33094 = (state_33492[(15)]);
var inst_33239 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_33094);
var state_33492__$1 = state_33492;
if(cljs.core.truth_(inst_33239)){
var statearr_33517_33726 = state_33492__$1;
(statearr_33517_33726[(1)] = (76));

} else {
var statearr_33518_33727 = state_33492__$1;
(statearr_33518_33727[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (60))){
var inst_33198 = (state_33492[(8)]);
var inst_33191 = (state_33492[(24)]);
var inst_33197 = cljs.core.seq.call(null,inst_33191);
var inst_33198__$1 = cljs.core.first.call(null,inst_33197);
var inst_33199 = cljs.core.next.call(null,inst_33197);
var state_33492__$1 = (function (){var statearr_33519 = state_33492;
(statearr_33519[(8)] = inst_33198__$1);

(statearr_33519[(25)] = inst_33199);

return statearr_33519;
})();
if(cljs.core.truth_(inst_33198__$1)){
var statearr_33520_33728 = state_33492__$1;
(statearr_33520_33728[(1)] = (62));

} else {
var statearr_33521_33729 = state_33492__$1;
(statearr_33521_33729[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (27))){
var inst_33115 = (state_33492[(26)]);
var inst_33111 = (state_33492[(18)]);
var inst_33115__$1 = cljs.core.not_EQ_.call(null,(0),inst_33111);
var state_33492__$1 = (function (){var statearr_33522 = state_33492;
(statearr_33522[(26)] = inst_33115__$1);

return statearr_33522;
})();
if(inst_33115__$1){
var statearr_33523_33730 = state_33492__$1;
(statearr_33523_33730[(1)] = (30));

} else {
var statearr_33524_33731 = state_33492__$1;
(statearr_33524_33731[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (1))){
var state_33492__$1 = state_33492;
var statearr_33525_33732 = state_33492__$1;
(statearr_33525_33732[(2)] = null);

(statearr_33525_33732[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (69))){
var inst_33213 = (state_33492[(2)]);
var inst_33214 = fluree.db.util.async.throw_err.call(null,inst_33213);
var state_33492__$1 = state_33492;
var statearr_33526_33733 = state_33492__$1;
(statearr_33526_33733[(2)] = inst_33214);

(statearr_33526_33733[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (101))){
var inst_33370 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
var statearr_33527_33734 = state_33492__$1;
(statearr_33527_33734[(2)] = inst_33370);

(statearr_33527_33734[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (24))){
var inst_33111 = (state_33492[(18)]);
var state_33492__$1 = state_33492;
if(cljs.core.truth_(inst_33111)){
var statearr_33528_33735 = state_33492__$1;
(statearr_33528_33735[(1)] = (27));

} else {
var statearr_33529_33736 = state_33492__$1;
(statearr_33529_33736[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (102))){
var inst_33342 = (state_33492[(27)]);
var inst_33341 = (state_33492[(2)]);
var inst_33342__$1 = fluree.db.util.async.throw_err.call(null,inst_33341);
var inst_33343 = cljs.core.empty_QMARK_.call(null,inst_33342__$1);
var state_33492__$1 = (function (){var statearr_33530 = state_33492;
(statearr_33530[(27)] = inst_33342__$1);

return statearr_33530;
})();
if(inst_33343){
var statearr_33531_33737 = state_33492__$1;
(statearr_33531_33737[(1)] = (103));

} else {
var statearr_33532_33738 = state_33492__$1;
(statearr_33532_33738[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (135))){
var state_33492__$1 = state_33492;
var statearr_33533_33739 = state_33492__$1;
(statearr_33533_33739[(2)] = null);

(statearr_33533_33739[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (55))){
var inst_33094 = (state_33492[(15)]);
var inst_33167 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_33094);
var state_33492__$1 = state_33492;
var statearr_33534_33740 = state_33492__$1;
(statearr_33534_33740[(2)] = inst_33167);

(statearr_33534_33740[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (85))){
var inst_33094 = (state_33492[(15)]);
var inst_33261 = (state_33492[(28)]);
var inst_33273 = inst_33261.o;
var inst_33274 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_33094);
var inst_33275 = fluree.db.dbproto._tag.call(null,db,inst_33273,inst_33274);
var state_33492__$1 = state_33492;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33492__$1,(87),inst_33275);
} else {
if((state_val_33493 === (39))){
var inst_33142 = (state_33492[(29)]);
var inst_33110 = (state_33492[(20)]);
var inst_33142__$1 = cljs.core.not.call(null,inst_33110);
var state_33492__$1 = (function (){var statearr_33535 = state_33492;
(statearr_33535[(29)] = inst_33142__$1);

return statearr_33535;
})();
if(inst_33142__$1){
var statearr_33536_33741 = state_33492__$1;
(statearr_33536_33741[(1)] = (42));

} else {
var statearr_33537_33742 = state_33492__$1;
(statearr_33537_33742[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (88))){
var inst_33255 = (state_33492[(30)]);
var inst_33286 = (state_33492[(12)]);
var inst_33288 = cljs.core.conj.call(null,inst_33255,inst_33286);
var state_33492__$1 = state_33492;
var statearr_33538_33743 = state_33492__$1;
(statearr_33538_33743[(2)] = inst_33288);

(statearr_33538_33743[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (46))){
var inst_33109 = (state_33492[(16)]);
var state_33492__$1 = state_33492;
var statearr_33539_33744 = state_33492__$1;
(statearr_33539_33744[(2)] = inst_33109);

(statearr_33539_33744[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (4))){
var inst_33054 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
var statearr_33540_33745 = state_33492__$1;
(statearr_33540_33745[(2)] = inst_33054);

(statearr_33540_33745[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (77))){
var inst_33301 = (state_33492[(31)]);
var inst_33301__$1 = componentFollow_QMARK_;
var state_33492__$1 = (function (){var statearr_33541 = state_33492;
(statearr_33541[(31)] = inst_33301__$1);

return statearr_33541;
})();
if(cljs.core.truth_(inst_33301__$1)){
var statearr_33542_33746 = state_33492__$1;
(statearr_33542_33746[(1)] = (91));

} else {
var statearr_33543_33747 = state_33492__$1;
(statearr_33543_33747[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (106))){
var inst_33322 = (state_33492[(32)]);
var inst_33356 = (state_33492[(2)]);
var inst_33357 = fluree.db.util.async.throw_err.call(null,inst_33356);
var inst_33358 = cljs.core.conj.call(null,inst_33322,inst_33357);
var state_33492__$1 = state_33492;
var statearr_33544_33748 = state_33492__$1;
(statearr_33544_33748[(2)] = inst_33358);

(statearr_33544_33748[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (119))){
var inst_33400 = (state_33492[(33)]);
var inst_33430 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33431 = [inst_33400,offset_map];
var inst_33432 = (new cljs.core.PersistentVector(null,2,(5),inst_33430,inst_33431,null));
var state_33492__$1 = state_33492;
var statearr_33545_33749 = state_33492__$1;
(statearr_33545_33749[(2)] = inst_33432);

(statearr_33545_33749[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (95))){
var inst_33108 = (state_33492[(19)]);
var state_33492__$1 = state_33492;
if(cljs.core.truth_(inst_33108)){
var statearr_33546_33750 = state_33492__$1;
(statearr_33546_33750[(1)] = (110));

} else {
var statearr_33547_33751 = state_33492__$1;
(statearr_33547_33751[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (54))){
var inst_33164 = (state_33492[(34)]);
var state_33492__$1 = state_33492;
var statearr_33548_33752 = state_33492__$1;
(statearr_33548_33752[(2)] = inst_33164);

(statearr_33548_33752[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (92))){
var inst_33301 = (state_33492[(31)]);
var state_33492__$1 = state_33492;
var statearr_33549_33753 = state_33492__$1;
(statearr_33549_33753[(2)] = inst_33301);

(statearr_33549_33753[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (104))){
var inst_33342 = (state_33492[(27)]);
var inst_33064 = (state_33492[(35)]);
var inst_33351 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_33352 = [true,inst_33064];
var inst_33353 = cljs.core.PersistentHashMap.fromArrays(inst_33351,inst_33352);
var inst_33354 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_33353,inst_33342);
var state_33492__$1 = state_33492;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33492__$1,(106),inst_33354);
} else {
if((state_val_33493 === (15))){
var inst_33087 = (state_33492[(36)]);
var inst_33064 = (state_33492[(35)]);
var inst_33091 = cljs.core.assoc.call(null,inst_33087,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_33064);
var state_33492__$1 = state_33492;
var statearr_33550_33754 = state_33492__$1;
(statearr_33550_33754[(2)] = inst_33091);

(statearr_33550_33754[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (48))){
var inst_33158 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33159 = [null,offset_map];
var inst_33160 = (new cljs.core.PersistentVector(null,2,(5),inst_33158,inst_33159,null));
var state_33492__$1 = state_33492;
var statearr_33551_33755 = state_33492__$1;
(statearr_33551_33755[(2)] = inst_33160);

(statearr_33551_33755[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (50))){
var inst_33458 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
var statearr_33552_33756 = state_33492__$1;
(statearr_33552_33756[(2)] = inst_33458);

(statearr_33552_33756[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (116))){
var inst_33406 = (state_33492[(37)]);
var inst_33399 = (state_33492[(38)]);
var inst_33405 = cljs.core.seq.call(null,inst_33399);
var inst_33406__$1 = cljs.core.first.call(null,inst_33405);
var inst_33407 = cljs.core.next.call(null,inst_33405);
var state_33492__$1 = (function (){var statearr_33553 = state_33492;
(statearr_33553[(37)] = inst_33406__$1);

(statearr_33553[(39)] = inst_33407);

return statearr_33553;
})();
if(cljs.core.truth_(inst_33406__$1)){
var statearr_33554_33757 = state_33492__$1;
(statearr_33554_33757[(1)] = (118));

} else {
var statearr_33555_33758 = state_33492__$1;
(statearr_33555_33758[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (75))){
var inst_33199 = (state_33492[(25)]);
var inst_33229 = (state_33492[(2)]);
var inst_33191 = inst_33199;
var inst_33192 = inst_33229;
var state_33492__$1 = (function (){var statearr_33556 = state_33492;
(statearr_33556[(9)] = inst_33192);

(statearr_33556[(24)] = inst_33191);

return statearr_33556;
})();
var statearr_33557_33759 = state_33492__$1;
(statearr_33557_33759[(2)] = null);

(statearr_33557_33759[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (99))){
var inst_33328 = (state_33492[(40)]);
var inst_33094 = (state_33492[(15)]);
var inst_33331 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33332 = inst_33328.o;
var inst_33333 = [inst_33332];
var inst_33334 = (new cljs.core.PersistentVector(null,1,(5),inst_33331,inst_33333,null));
var inst_33335 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_33336 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_33094);
var inst_33337 = [inst_33336];
var inst_33338 = cljs.core.PersistentHashMap.fromArrays(inst_33335,inst_33337);
var inst_33339 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_33334,inst_33338);
var state_33492__$1 = state_33492;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33492__$1,(102),inst_33339);
} else {
if((state_val_33493 === (21))){
var inst_33098 = (state_33492[(41)]);
var state_33492__$1 = state_33492;
var statearr_33558_33760 = state_33492__$1;
(statearr_33558_33760[(2)] = inst_33098);

(statearr_33558_33760[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (31))){
var inst_33115 = (state_33492[(26)]);
var state_33492__$1 = state_33492;
var statearr_33559_33761 = state_33492__$1;
(statearr_33559_33761[(2)] = inst_33115);

(statearr_33559_33761[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (113))){
var inst_33109 = (state_33492[(16)]);
var inst_33112 = (state_33492[(17)]);
var inst_33111 = (state_33492[(18)]);
var inst_33106 = (state_33492[(13)]);
var inst_33107 = (state_33492[(14)]);
var inst_33064 = (state_33492[(35)]);
var inst_33108 = (state_33492[(19)]);
var inst_33094 = (state_33492[(15)]);
var inst_33110 = (state_33492[(20)]);
var inst_33105 = (state_33492[(21)]);
var inst_33079 = (state_33492[(42)]);
var inst_33381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33382 = (function (){var map__33060 = inst_33106;
var p = inst_33112;
var pred_spec__$1 = inst_33079;
var orderBy = inst_33110;
var multi_QMARK_ = inst_33107;
var limit = inst_33109;
var offset = inst_33111;
var k = inst_33105;
var compact_QMARK_ = inst_33064;
var pred_spec_SINGLEQUOTE_ = inst_33094;
var ref_QMARK_ = inst_33108;
return (function (p1__33050_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[p1__33050_SHARP_.o]);
});
})();
var inst_33383 = cljs.core.mapv.call(null,inst_33382,flakes);
var inst_33384 = [inst_33383,offset_map];
var inst_33385 = (new cljs.core.PersistentVector(null,2,(5),inst_33381,inst_33384,null));
var state_33492__$1 = state_33492;
var statearr_33560_33762 = state_33492__$1;
(statearr_33560_33762[(2)] = inst_33385);

(statearr_33560_33762[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (32))){
var inst_33121 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
var statearr_33561_33763 = state_33492__$1;
(statearr_33561_33763[(2)] = inst_33121);

(statearr_33561_33763[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (136))){
var inst_33483 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
var statearr_33562_33764 = state_33492__$1;
(statearr_33562_33764[(2)] = inst_33483);

(statearr_33562_33764[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (40))){
var inst_33107 = (state_33492[(14)]);
var state_33492__$1 = state_33492;
var statearr_33563_33765 = state_33492__$1;
(statearr_33563_33765[(2)] = inst_33107);

(statearr_33563_33765[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (129))){
var inst_33107 = (state_33492[(14)]);
var state_33492__$1 = state_33492;
if(cljs.core.truth_(inst_33107)){
var statearr_33564_33766 = state_33492__$1;
(statearr_33564_33766[(1)] = (131));

} else {
var statearr_33565_33767 = state_33492__$1;
(statearr_33565_33767[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (91))){
var inst_33094 = (state_33492[(15)]);
var inst_33303 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_33094);
var state_33492__$1 = state_33492;
var statearr_33566_33768 = state_33492__$1;
(statearr_33566_33768[(2)] = inst_33303);

(statearr_33566_33768[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (117))){
var inst_33436 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
var statearr_33567_33769 = state_33492__$1;
(statearr_33567_33769[(2)] = inst_33436);

(statearr_33567_33769[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (108))){
var state_33492__$1 = state_33492;
var statearr_33568_33770 = state_33492__$1;
(statearr_33568_33770[(2)] = null);

(statearr_33568_33770[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (56))){
var inst_33169 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
var statearr_33569_33771 = state_33492__$1;
(statearr_33569_33771[(2)] = inst_33169);

(statearr_33569_33771[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (33))){
var inst_33112 = (state_33492[(17)]);
var inst_33129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33130 = cljs.core.get.call(null,offset_map,inst_33112);
var state_33492__$1 = (function (){var statearr_33570 = state_33492;
(statearr_33570[(43)] = inst_33129);

return statearr_33570;
})();
if(cljs.core.truth_(inst_33130)){
var statearr_33571_33772 = state_33492__$1;
(statearr_33571_33772[(1)] = (36));

} else {
var statearr_33572_33773 = state_33492__$1;
(statearr_33572_33773[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (13))){
var inst_33079 = (state_33492[(42)]);
var state_33492__$1 = state_33492;
var statearr_33573_33774 = state_33492__$1;
(statearr_33573_33774[(2)] = inst_33079);

(statearr_33573_33774[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (22))){
var inst_33094 = (state_33492[(15)]);
var inst_33101 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_33094);
var state_33492__$1 = state_33492;
var statearr_33574_33775 = state_33492__$1;
(statearr_33574_33775[(2)] = inst_33101);

(statearr_33574_33775[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (90))){
var inst_33262 = (state_33492[(44)]);
var inst_33291 = (state_33492[(2)]);
var inst_33254 = inst_33262;
var inst_33255 = inst_33291;
var state_33492__$1 = (function (){var statearr_33575 = state_33492;
(statearr_33575[(30)] = inst_33255);

(statearr_33575[(45)] = inst_33254);

return statearr_33575;
})();
var statearr_33576_33776 = state_33492__$1;
(statearr_33576_33776[(2)] = null);

(statearr_33576_33776[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (109))){
var inst_33360 = (state_33492[(46)]);
var inst_33329 = (state_33492[(47)]);
var inst_33366 = (state_33492[(2)]);
var inst_33321 = inst_33329;
var inst_33322 = inst_33360;
var state_33492__$1 = (function (){var statearr_33577 = state_33492;
(statearr_33577[(48)] = inst_33366);

(statearr_33577[(49)] = inst_33321);

(statearr_33577[(32)] = inst_33322);

return statearr_33577;
})();
var statearr_33578_33777 = state_33492__$1;
(statearr_33578_33777[(2)] = null);

(statearr_33578_33777[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (36))){
var inst_33112 = (state_33492[(17)]);
var inst_33132 = cljs.core.update.call(null,offset_map,inst_33112,cljs.core.dec);
var state_33492__$1 = state_33492;
var statearr_33579_33778 = state_33492__$1;
(statearr_33579_33778[(2)] = inst_33132);

(statearr_33579_33778[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (41))){
var inst_33156 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
if(cljs.core.truth_(inst_33156)){
var statearr_33580_33779 = state_33492__$1;
(statearr_33580_33779[(1)] = (48));

} else {
var statearr_33581_33780 = state_33492__$1;
(statearr_33581_33780[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (118))){
var inst_33406 = (state_33492[(37)]);
var inst_33409 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33410 = inst_33406.o;
var inst_33411 = [inst_33410];
var inst_33412 = (new cljs.core.PersistentVector(null,1,(5),inst_33409,inst_33411,null));
var inst_33413 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_33412);
var state_33492__$1 = state_33492;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33492__$1,(121),inst_33413);
} else {
if((state_val_33493 === (89))){
var inst_33255 = (state_33492[(30)]);
var state_33492__$1 = state_33492;
var statearr_33582_33781 = state_33492__$1;
(statearr_33582_33781[(2)] = inst_33255);

(statearr_33582_33781[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (100))){
var inst_33322 = (state_33492[(32)]);
var state_33492__$1 = state_33492;
var statearr_33583_33782 = state_33492__$1;
(statearr_33583_33782[(2)] = inst_33322);

(statearr_33583_33782[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (131))){
var inst_33461 = (state_33492[(50)]);
var inst_33462 = (state_33492[(10)]);
var inst_33105 = (state_33492[(21)]);
var inst_33470 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33471 = cljs.core.assoc.call(null,acc,inst_33105,inst_33461);
var inst_33472 = [inst_33471,inst_33462];
var inst_33473 = (new cljs.core.PersistentVector(null,2,(5),inst_33470,inst_33472,null));
var state_33492__$1 = state_33492;
var statearr_33584_33783 = state_33492__$1;
(statearr_33584_33783[(2)] = inst_33473);

(statearr_33584_33783[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (122))){
var inst_33406 = (state_33492[(37)]);
var inst_33407 = (state_33492[(39)]);
var inst_33400 = (state_33492[(33)]);
var inst_33419 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_33420 = inst_33406.o;
var inst_33421 = [inst_33420];
var inst_33422 = cljs.core.PersistentHashMap.fromArrays(inst_33419,inst_33421);
var inst_33423 = cljs.core.conj.call(null,inst_33400,inst_33422);
var inst_33399 = inst_33407;
var inst_33400__$1 = inst_33423;
var state_33492__$1 = (function (){var statearr_33585 = state_33492;
(statearr_33585[(38)] = inst_33399);

(statearr_33585[(33)] = inst_33400__$1);

return statearr_33585;
})();
var statearr_33586_33784 = state_33492__$1;
(statearr_33586_33784[(2)] = null);

(statearr_33586_33784[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (43))){
var inst_33142 = (state_33492[(29)]);
var state_33492__$1 = state_33492;
var statearr_33587_33785 = state_33492__$1;
(statearr_33587_33785[(2)] = inst_33142);

(statearr_33587_33785[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (61))){
var inst_33178 = (state_33492[(51)]);
var inst_33235 = (state_33492[(2)]);
var inst_33236 = [inst_33235,offset_map];
var inst_33237 = (new cljs.core.PersistentVector(null,2,(5),inst_33178,inst_33236,null));
var state_33492__$1 = state_33492;
var statearr_33588_33786 = state_33492__$1;
(statearr_33588_33786[(2)] = inst_33237);

(statearr_33588_33786[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (29))){
var inst_33124 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
var statearr_33589_33787 = state_33492__$1;
(statearr_33589_33787[(2)] = inst_33124);

(statearr_33589_33787[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (44))){
var inst_33153 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
var statearr_33590_33788 = state_33492__$1;
(statearr_33590_33788[(2)] = inst_33153);

(statearr_33590_33788[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (93))){
var inst_33306 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
if(cljs.core.truth_(inst_33306)){
var statearr_33591_33789 = state_33492__$1;
(statearr_33591_33789[(1)] = (94));

} else {
var statearr_33592_33790 = state_33492__$1;
(statearr_33592_33790[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (6))){
var inst_33067 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_33068 = (inst_33067 == null);
var state_33492__$1 = state_33492;
var statearr_33593_33791 = state_33492__$1;
(statearr_33593_33791[(2)] = inst_33068);

(statearr_33593_33791[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (111))){
var state_33492__$1 = state_33492;
var statearr_33594_33792 = state_33492__$1;
(statearr_33594_33792[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (28))){
var inst_33111 = (state_33492[(18)]);
var state_33492__$1 = state_33492;
var statearr_33596_33793 = state_33492__$1;
(statearr_33596_33793[(2)] = inst_33111);

(statearr_33596_33793[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (134))){
var inst_33461 = (state_33492[(50)]);
var inst_33462 = (state_33492[(10)]);
var inst_33105 = (state_33492[(21)]);
var inst_33476 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33477 = cljs.core.first.call(null,inst_33461);
var inst_33478 = cljs.core.assoc.call(null,acc,inst_33105,inst_33477);
var inst_33479 = [inst_33478,inst_33462];
var inst_33480 = (new cljs.core.PersistentVector(null,2,(5),inst_33476,inst_33479,null));
var state_33492__$1 = state_33492;
var statearr_33597_33794 = state_33492__$1;
(statearr_33597_33794[(2)] = inst_33480);

(statearr_33597_33794[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (64))){
var inst_33233 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
var statearr_33598_33795 = state_33492__$1;
(statearr_33598_33795[(2)] = inst_33233);

(statearr_33598_33795[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (103))){
var inst_33328 = (state_33492[(40)]);
var inst_33322 = (state_33492[(32)]);
var inst_33345 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_33346 = inst_33328.o;
var inst_33347 = [inst_33346];
var inst_33348 = cljs.core.PersistentHashMap.fromArrays(inst_33345,inst_33347);
var inst_33349 = cljs.core.conj.call(null,inst_33322,inst_33348);
var state_33492__$1 = state_33492;
var statearr_33599_33796 = state_33492__$1;
(statearr_33599_33796[(2)] = inst_33349);

(statearr_33599_33796[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (51))){
var inst_33164 = (state_33492[(34)]);
var inst_33094 = (state_33492[(15)]);
var inst_33164__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_33094);
var state_33492__$1 = (function (){var statearr_33600 = state_33492;
(statearr_33600[(34)] = inst_33164__$1);

return statearr_33600;
})();
if(cljs.core.truth_(inst_33164__$1)){
var statearr_33601_33797 = state_33492__$1;
(statearr_33601_33797[(1)] = (54));

} else {
var statearr_33602_33798 = state_33492__$1;
(statearr_33602_33798[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (25))){
var inst_33107 = (state_33492[(14)]);
var state_33492__$1 = state_33492;
var statearr_33603_33799 = state_33492__$1;
(statearr_33603_33799[(2)] = inst_33107);

(statearr_33603_33799[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (34))){
var inst_33107 = (state_33492[(14)]);
var state_33492__$1 = state_33492;
if(cljs.core.truth_(inst_33107)){
var statearr_33604_33800 = state_33492__$1;
(statearr_33604_33800[(1)] = (39));

} else {
var statearr_33605_33801 = state_33492__$1;
(statearr_33605_33801[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (125))){
var inst_33109 = (state_33492[(16)]);
var inst_33112 = (state_33492[(17)]);
var inst_33111 = (state_33492[(18)]);
var inst_33106 = (state_33492[(13)]);
var inst_33107 = (state_33492[(14)]);
var inst_33064 = (state_33492[(35)]);
var inst_33108 = (state_33492[(19)]);
var inst_33094 = (state_33492[(15)]);
var inst_33110 = (state_33492[(20)]);
var inst_33105 = (state_33492[(21)]);
var inst_33079 = (state_33492[(42)]);
var inst_33441 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33442 = (function (){var map__33060 = inst_33106;
var p = inst_33112;
var pred_spec__$1 = inst_33079;
var orderBy = inst_33110;
var multi_QMARK_ = inst_33107;
var limit = inst_33109;
var offset = inst_33111;
var k = inst_33105;
var compact_QMARK_ = inst_33064;
var pred_spec_SINGLEQUOTE_ = inst_33094;
var ref_QMARK_ = inst_33108;
return (function (p1__33051_SHARP_){
return p1__33051_SHARP_.o;
});
})();
var inst_33443 = cljs.core.mapv.call(null,inst_33442,flakes);
var inst_33444 = [inst_33443,offset_map];
var inst_33445 = (new cljs.core.PersistentVector(null,2,(5),inst_33441,inst_33444,null));
var state_33492__$1 = state_33492;
var statearr_33606_33802 = state_33492__$1;
(statearr_33606_33802[(2)] = inst_33445);

(statearr_33606_33802[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (17))){
var inst_33095 = (state_33492[(52)]);
var inst_33094 = (state_33492[(15)]);
var inst_33094__$1 = (state_33492[(2)]);
var inst_33095__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_33094__$1);
var state_33492__$1 = (function (){var statearr_33607 = state_33492;
(statearr_33607[(52)] = inst_33095__$1);

(statearr_33607[(15)] = inst_33094__$1);

return statearr_33607;
})();
if(cljs.core.truth_(inst_33095__$1)){
var statearr_33608_33803 = state_33492__$1;
(statearr_33608_33803[(1)] = (18));

} else {
var statearr_33609_33804 = state_33492__$1;
(statearr_33609_33804[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (3))){
var inst_33490 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33492__$1,inst_33490);
} else {
if((state_val_33493 === (12))){
var inst_33079 = (state_33492[(42)]);
var inst_33084 = cljs.core.assoc.call(null,inst_33079,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_33492__$1 = state_33492;
var statearr_33610_33805 = state_33492__$1;
(statearr_33610_33805[(2)] = inst_33084);

(statearr_33610_33805[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (2))){
var inst_33065 = (state_33492[(11)]);
var _ = (function (){var statearr_33611 = state_33492;
(statearr_33611[(4)] = cljs.core.cons.call(null,(5),(state_33492[(4)])));

return statearr_33611;
})();
var inst_33064 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_33065__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_33492__$1 = (function (){var statearr_33612 = state_33492;
(statearr_33612[(11)] = inst_33065__$1);

(statearr_33612[(35)] = inst_33064);

return statearr_33612;
})();
if(cljs.core.truth_(inst_33065__$1)){
var statearr_33613_33806 = state_33492__$1;
(statearr_33613_33806[(1)] = (6));

} else {
var statearr_33614_33807 = state_33492__$1;
(statearr_33614_33807[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (66))){
var inst_33177 = (state_33492[(53)]);
var inst_33208 = (state_33492[(7)]);
var inst_33211 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_33177,inst_33208);
var state_33492__$1 = state_33492;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33492__$1,(69),inst_33211);
} else {
if((state_val_33493 === (107))){
var inst_33342 = (state_33492[(27)]);
var inst_33362 = cljs.core.count.call(null,inst_33342);
var inst_33363 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_33362);
var state_33492__$1 = state_33492;
var statearr_33615_33808 = state_33492__$1;
(statearr_33615_33808[(2)] = inst_33363);

(statearr_33615_33808[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (23))){
var inst_33103 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
var statearr_33616_33809 = state_33492__$1;
(statearr_33616_33809[(2)] = inst_33103);

(statearr_33616_33809[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (47))){
var inst_33150 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
var statearr_33617_33810 = state_33492__$1;
(statearr_33617_33810[(2)] = inst_33150);

(statearr_33617_33810[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (35))){
var inst_33461 = (state_33492[(50)]);
var inst_33460 = (state_33492[(2)]);
var inst_33461__$1 = cljs.core.nth.call(null,inst_33460,(0),null);
var inst_33462 = cljs.core.nth.call(null,inst_33460,(1),null);
var inst_33463 = cljs.core.empty_QMARK_.call(null,inst_33461__$1);
var state_33492__$1 = (function (){var statearr_33618 = state_33492;
(statearr_33618[(50)] = inst_33461__$1);

(statearr_33618[(10)] = inst_33462);

return statearr_33618;
})();
if(inst_33463){
var statearr_33619_33811 = state_33492__$1;
(statearr_33619_33811[(1)] = (128));

} else {
var statearr_33620_33812 = state_33492__$1;
(statearr_33620_33812[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (127))){
var inst_33448 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
var statearr_33621_33813 = state_33492__$1;
(statearr_33621_33813[(2)] = inst_33448);

(statearr_33621_33813[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (82))){
var inst_33255 = (state_33492[(30)]);
var state_33492__$1 = state_33492;
var statearr_33622_33814 = state_33492__$1;
(statearr_33622_33814[(2)] = inst_33255);

(statearr_33622_33814[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (76))){
var inst_33241 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33249 = flakes;
var inst_33250 = cljs.core.seq.call(null,inst_33249);
var inst_33251 = cljs.core.first.call(null,inst_33250);
var inst_33252 = cljs.core.next.call(null,inst_33250);
var inst_33253 = cljs.core.PersistentVector.EMPTY;
var inst_33254 = inst_33249;
var inst_33255 = inst_33253;
var state_33492__$1 = (function (){var statearr_33623 = state_33492;
(statearr_33623[(30)] = inst_33255);

(statearr_33623[(54)] = inst_33251);

(statearr_33623[(45)] = inst_33254);

(statearr_33623[(55)] = inst_33252);

(statearr_33623[(56)] = inst_33241);

return statearr_33623;
})();
var statearr_33624_33815 = state_33492__$1;
(statearr_33624_33815[(2)] = null);

(statearr_33624_33815[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (97))){
var inst_33328 = (state_33492[(40)]);
var inst_33321 = (state_33492[(49)]);
var inst_33327 = cljs.core.seq.call(null,inst_33321);
var inst_33328__$1 = cljs.core.first.call(null,inst_33327);
var inst_33329 = cljs.core.next.call(null,inst_33327);
var state_33492__$1 = (function (){var statearr_33625 = state_33492;
(statearr_33625[(40)] = inst_33328__$1);

(statearr_33625[(47)] = inst_33329);

return statearr_33625;
})();
if(cljs.core.truth_(inst_33328__$1)){
var statearr_33626_33816 = state_33492__$1;
(statearr_33626_33816[(1)] = (99));

} else {
var statearr_33627_33817 = state_33492__$1;
(statearr_33627_33817[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (19))){
var inst_33094 = (state_33492[(15)]);
var inst_33098 = (state_33492[(41)]);
var inst_33098__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_33094);
var state_33492__$1 = (function (){var statearr_33628 = state_33492;
(statearr_33628[(41)] = inst_33098__$1);

return statearr_33628;
})();
if(cljs.core.truth_(inst_33098__$1)){
var statearr_33629_33818 = state_33492__$1;
(statearr_33629_33818[(1)] = (21));

} else {
var statearr_33630_33819 = state_33492__$1;
(statearr_33630_33819[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (57))){
var inst_33094 = (state_33492[(15)]);
var inst_33174 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33175 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_33176 = (new cljs.core.PersistentVector(null,3,(5),inst_33174,inst_33175,null));
var inst_33177 = cljs.core.select_keys.call(null,inst_33094,inst_33176);
var inst_33178 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33186 = flakes;
var inst_33187 = cljs.core.seq.call(null,inst_33186);
var inst_33188 = cljs.core.first.call(null,inst_33187);
var inst_33189 = cljs.core.next.call(null,inst_33187);
var inst_33190 = cljs.core.PersistentVector.EMPTY;
var inst_33191 = inst_33186;
var inst_33192 = inst_33190;
var state_33492__$1 = (function (){var statearr_33631 = state_33492;
(statearr_33631[(53)] = inst_33177);

(statearr_33631[(9)] = inst_33192);

(statearr_33631[(57)] = inst_33189);

(statearr_33631[(51)] = inst_33178);

(statearr_33631[(24)] = inst_33191);

(statearr_33631[(58)] = inst_33188);

return statearr_33631;
})();
var statearr_33632_33820 = state_33492__$1;
(statearr_33632_33820[(2)] = null);

(statearr_33632_33820[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (68))){
var inst_33217 = (state_33492[(2)]);
var state_33492__$1 = (function (){var statearr_33633 = state_33492;
(statearr_33633[(22)] = inst_33217);

return statearr_33633;
})();
if(cljs.core.truth_(fuel)){
var statearr_33634_33821 = state_33492__$1;
(statearr_33634_33821[(1)] = (70));

} else {
var statearr_33635_33822 = state_33492__$1;
(statearr_33635_33822[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (11))){
var inst_33079 = (state_33492[(42)]);
var inst_33079__$1 = (state_33492[(2)]);
var inst_33081 = cljs.core.contains_QMARK_.call(null,inst_33079__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_33082 = (!(inst_33081));
var state_33492__$1 = (function (){var statearr_33636 = state_33492;
(statearr_33636[(42)] = inst_33079__$1);

return statearr_33636;
})();
if(inst_33082){
var statearr_33637_33823 = state_33492__$1;
(statearr_33637_33823[(1)] = (12));

} else {
var statearr_33638_33824 = state_33492__$1;
(statearr_33638_33824[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (115))){
var inst_33438 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
var statearr_33640_33825 = state_33492__$1;
(statearr_33640_33825[(2)] = inst_33438);

(statearr_33640_33825[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (9))){
var inst_33073 = cljs.core.first.call(null,flakes);
var inst_33074 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_33073);
var inst_33075 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_33076 = fluree.db.query.fql.wildcard_pred_spec.call(null,db,cache,inst_33074,inst_33075);
var state_33492__$1 = state_33492;
var statearr_33641_33826 = state_33492__$1;
(statearr_33641_33826[(2)] = inst_33076);

(statearr_33641_33826[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (5))){
var _ = (function (){var statearr_33642 = state_33492;
(statearr_33642[(4)] = cljs.core.rest.call(null,(state_33492[(4)])));

return statearr_33642;
})();
var state_33492__$1 = state_33492;
var ex33639 = (state_33492__$1[(2)]);
var statearr_33643_33827 = state_33492__$1;
(statearr_33643_33827[(5)] = ex33639);


if((ex33639 instanceof Error)){
var statearr_33644_33828 = state_33492__$1;
(statearr_33644_33828[(1)] = (4));

(statearr_33644_33828[(5)] = null);

} else {
throw ex33639;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (112))){
var inst_33450 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
var statearr_33645_33829 = state_33492__$1;
(statearr_33645_33829[(2)] = inst_33450);

(statearr_33645_33829[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (83))){
var inst_33295 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
var statearr_33646_33830 = state_33492__$1;
(statearr_33646_33830[(2)] = inst_33295);

(statearr_33646_33830[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (14))){
var inst_33079 = (state_33492[(42)]);
var inst_33087 = (state_33492[(2)]);
var inst_33088 = cljs.core.contains_QMARK_.call(null,inst_33079,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_33089 = (!(inst_33088));
var state_33492__$1 = (function (){var statearr_33647 = state_33492;
(statearr_33647[(36)] = inst_33087);

return statearr_33647;
})();
if(inst_33089){
var statearr_33648_33831 = state_33492__$1;
(statearr_33648_33831[(1)] = (15));

} else {
var statearr_33649_33832 = state_33492__$1;
(statearr_33649_33832[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (45))){
var inst_33109 = (state_33492[(16)]);
var inst_33105 = (state_33492[(21)]);
var inst_33145 = cljs.core.get.call(null,acc,inst_33105);
var inst_33146 = cljs.core.count.call(null,inst_33145);
var inst_33147 = (inst_33146 >= inst_33109);
var state_33492__$1 = state_33492;
var statearr_33650_33833 = state_33492__$1;
(statearr_33650_33833[(2)] = inst_33147);

(statearr_33650_33833[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (53))){
var inst_33172 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
if(cljs.core.truth_(inst_33172)){
var statearr_33651_33834 = state_33492__$1;
(statearr_33651_33834[(1)] = (57));

} else {
var statearr_33652_33835 = state_33492__$1;
(statearr_33652_33835[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (78))){
var inst_33454 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
var statearr_33653_33836 = state_33492__$1;
(statearr_33653_33836[(2)] = inst_33454);

(statearr_33653_33836[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (132))){
var state_33492__$1 = state_33492;
var statearr_33655_33837 = state_33492__$1;
(statearr_33655_33837[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (26))){
var inst_33127 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
if(cljs.core.truth_(inst_33127)){
var statearr_33657_33838 = state_33492__$1;
(statearr_33657_33838[(1)] = (33));

} else {
var statearr_33658_33839 = state_33492__$1;
(statearr_33658_33839[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (123))){
var inst_33407 = (state_33492[(39)]);
var inst_33400 = (state_33492[(33)]);
var tmp33654 = inst_33400;
var inst_33399 = inst_33407;
var inst_33400__$1 = tmp33654;
var state_33492__$1 = (function (){var statearr_33659 = state_33492;
(statearr_33659[(38)] = inst_33399);

(statearr_33659[(33)] = inst_33400__$1);

return statearr_33659;
})();
var statearr_33660_33840 = state_33492__$1;
(statearr_33660_33840[(2)] = null);

(statearr_33660_33840[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (16))){
var inst_33087 = (state_33492[(36)]);
var state_33492__$1 = state_33492;
var statearr_33661_33841 = state_33492__$1;
(statearr_33661_33841[(2)] = inst_33087);

(statearr_33661_33841[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (133))){
var inst_33485 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
var statearr_33662_33842 = state_33492__$1;
(statearr_33662_33842[(2)] = inst_33485);

(statearr_33662_33842[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (81))){
var inst_33270 = (state_33492[(59)]);
var inst_33094 = (state_33492[(15)]);
var inst_33261 = (state_33492[(28)]);
var inst_33264 = cljs.core.deref.call(null,cache);
var inst_33265 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33266 = inst_33261.o;
var inst_33267 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_33094);
var inst_33268 = [inst_33266,inst_33267];
var inst_33269 = (new cljs.core.PersistentVector(null,2,(5),inst_33265,inst_33268,null));
var inst_33270__$1 = cljs.core.get.call(null,inst_33264,inst_33269);
var state_33492__$1 = (function (){var statearr_33663 = state_33492;
(statearr_33663[(59)] = inst_33270__$1);

return statearr_33663;
})();
if(cljs.core.truth_(inst_33270__$1)){
var statearr_33664_33843 = state_33492__$1;
(statearr_33664_33843[(1)] = (84));

} else {
var statearr_33665_33844 = state_33492__$1;
(statearr_33665_33844[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (120))){
var inst_33434 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
var statearr_33666_33845 = state_33492__$1;
(statearr_33666_33845[(2)] = inst_33434);

(statearr_33666_33845[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (79))){
var inst_33254 = (state_33492[(45)]);
var inst_33261 = (state_33492[(28)]);
var inst_33260 = cljs.core.seq.call(null,inst_33254);
var inst_33261__$1 = cljs.core.first.call(null,inst_33260);
var inst_33262 = cljs.core.next.call(null,inst_33260);
var state_33492__$1 = (function (){var statearr_33667 = state_33492;
(statearr_33667[(44)] = inst_33262);

(statearr_33667[(28)] = inst_33261__$1);

return statearr_33667;
})();
if(cljs.core.truth_(inst_33261__$1)){
var statearr_33668_33846 = state_33492__$1;
(statearr_33668_33846[(1)] = (81));

} else {
var statearr_33669_33847 = state_33492__$1;
(statearr_33669_33847[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (38))){
var inst_33129 = (state_33492[(43)]);
var inst_33137 = (state_33492[(2)]);
var inst_33138 = [null,inst_33137];
var inst_33139 = (new cljs.core.PersistentVector(null,2,(5),inst_33129,inst_33138,null));
var state_33492__$1 = state_33492;
var statearr_33670_33848 = state_33492__$1;
(statearr_33670_33848[(2)] = inst_33139);

(statearr_33670_33848[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (126))){
var state_33492__$1 = state_33492;
var statearr_33671_33849 = state_33492__$1;
(statearr_33671_33849[(2)] = null);

(statearr_33671_33849[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (98))){
var inst_33308 = (state_33492[(60)]);
var inst_33372 = (state_33492[(2)]);
var inst_33373 = [inst_33372,offset_map];
var inst_33374 = (new cljs.core.PersistentVector(null,2,(5),inst_33308,inst_33373,null));
var state_33492__$1 = state_33492;
var statearr_33672_33850 = state_33492__$1;
(statearr_33672_33850[(2)] = inst_33374);

(statearr_33672_33850[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (124))){
var inst_33428 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
var statearr_33673_33851 = state_33492__$1;
(statearr_33673_33851[(2)] = inst_33428);

(statearr_33673_33851[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (87))){
var inst_33094 = (state_33492[(15)]);
var inst_33261 = (state_33492[(28)]);
var inst_33277 = (state_33492[(2)]);
var inst_33278 = fluree.db.util.async.throw_err.call(null,inst_33277);
var inst_33279 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33280 = inst_33261.o;
var inst_33281 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_33094);
var inst_33282 = [inst_33280,inst_33281];
var inst_33283 = (new cljs.core.PersistentVector(null,2,(5),inst_33279,inst_33282,null));
var inst_33284 = fluree.db.query.fql.vswap_BANG_.call(null,cache,cljs.core.assoc,inst_33283,inst_33278);
var state_33492__$1 = (function (){var statearr_33674 = state_33492;
(statearr_33674[(61)] = inst_33284);

return statearr_33674;
})();
var statearr_33675_33852 = state_33492__$1;
(statearr_33675_33852[(2)] = inst_33278);

(statearr_33675_33852[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (30))){
var inst_33112 = (state_33492[(17)]);
var inst_33117 = cljs.core.get.call(null,offset_map,inst_33112);
var inst_33118 = cljs.core.not_EQ_.call(null,(0),inst_33117);
var state_33492__$1 = state_33492;
var statearr_33676_33853 = state_33492__$1;
(statearr_33676_33853[(2)] = inst_33118);

(statearr_33676_33853[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (73))){
var inst_33192 = (state_33492[(9)]);
var inst_33217 = (state_33492[(22)]);
var inst_33226 = cljs.core.conj.call(null,inst_33192,inst_33217);
var state_33492__$1 = state_33492;
var statearr_33677_33854 = state_33492__$1;
(statearr_33677_33854[(2)] = inst_33226);

(statearr_33677_33854[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (96))){
var inst_33452 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
var statearr_33678_33855 = state_33492__$1;
(statearr_33678_33855[(2)] = inst_33452);

(statearr_33678_33855[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (10))){
var state_33492__$1 = state_33492;
var statearr_33679_33856 = state_33492__$1;
(statearr_33679_33856[(2)] = pred_spec);

(statearr_33679_33856[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (18))){
var inst_33095 = (state_33492[(52)]);
var state_33492__$1 = state_33492;
var statearr_33680_33857 = state_33492__$1;
(statearr_33680_33857[(2)] = inst_33095);

(statearr_33680_33857[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (105))){
var inst_33360 = (state_33492[(2)]);
var state_33492__$1 = (function (){var statearr_33681 = state_33492;
(statearr_33681[(46)] = inst_33360);

return statearr_33681;
})();
if(cljs.core.truth_(fuel)){
var statearr_33682_33858 = state_33492__$1;
(statearr_33682_33858[(1)] = (107));

} else {
var statearr_33683_33859 = state_33492__$1;
(statearr_33683_33859[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (52))){
var inst_33162 = (state_33492[(62)]);
var state_33492__$1 = state_33492;
var statearr_33684_33860 = state_33492__$1;
(statearr_33684_33860[(2)] = inst_33162);

(statearr_33684_33860[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (114))){
var inst_33394 = flakes;
var inst_33395 = cljs.core.seq.call(null,inst_33394);
var inst_33396 = cljs.core.first.call(null,inst_33395);
var inst_33397 = cljs.core.next.call(null,inst_33395);
var inst_33398 = cljs.core.PersistentVector.EMPTY;
var inst_33399 = inst_33394;
var inst_33400 = inst_33398;
var state_33492__$1 = (function (){var statearr_33685 = state_33492;
(statearr_33685[(63)] = inst_33396);

(statearr_33685[(38)] = inst_33399);

(statearr_33685[(33)] = inst_33400);

(statearr_33685[(64)] = inst_33397);

return statearr_33685;
})();
var statearr_33686_33861 = state_33492__$1;
(statearr_33686_33861[(2)] = null);

(statearr_33686_33861[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (67))){
var state_33492__$1 = state_33492;
var statearr_33687_33862 = state_33492__$1;
(statearr_33687_33862[(2)] = null);

(statearr_33687_33862[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (71))){
var state_33492__$1 = state_33492;
var statearr_33688_33863 = state_33492__$1;
(statearr_33688_33863[(2)] = null);

(statearr_33688_33863[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (42))){
var inst_33109 = (state_33492[(16)]);
var state_33492__$1 = state_33492;
if(cljs.core.truth_(inst_33109)){
var statearr_33689_33864 = state_33492__$1;
(statearr_33689_33864[(1)] = (45));

} else {
var statearr_33690_33865 = state_33492__$1;
(statearr_33690_33865[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (80))){
var inst_33241 = (state_33492[(56)]);
var inst_33297 = (state_33492[(2)]);
var inst_33298 = [inst_33297,offset_map];
var inst_33299 = (new cljs.core.PersistentVector(null,2,(5),inst_33241,inst_33298,null));
var state_33492__$1 = state_33492;
var statearr_33691_33866 = state_33492__$1;
(statearr_33691_33866[(2)] = inst_33299);

(statearr_33691_33866[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (37))){
var inst_33112 = (state_33492[(17)]);
var inst_33111 = (state_33492[(18)]);
var inst_33134 = (inst_33111 - (1));
var inst_33135 = cljs.core.assoc.call(null,offset_map,inst_33112,inst_33134);
var state_33492__$1 = state_33492;
var statearr_33692_33867 = state_33492__$1;
(statearr_33692_33867[(2)] = inst_33135);

(statearr_33692_33867[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (63))){
var inst_33192 = (state_33492[(9)]);
var state_33492__$1 = state_33492;
var statearr_33693_33868 = state_33492__$1;
(statearr_33693_33868[(2)] = inst_33192);

(statearr_33693_33868[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (94))){
var inst_33308 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33316 = flakes;
var inst_33317 = cljs.core.seq.call(null,inst_33316);
var inst_33318 = cljs.core.first.call(null,inst_33317);
var inst_33319 = cljs.core.next.call(null,inst_33317);
var inst_33320 = cljs.core.PersistentVector.EMPTY;
var inst_33321 = inst_33316;
var inst_33322 = inst_33320;
var state_33492__$1 = (function (){var statearr_33694 = state_33492;
(statearr_33694[(60)] = inst_33308);

(statearr_33694[(65)] = inst_33318);

(statearr_33694[(66)] = inst_33319);

(statearr_33694[(49)] = inst_33321);

(statearr_33694[(32)] = inst_33322);

return statearr_33694;
})();
var statearr_33695_33869 = state_33492__$1;
(statearr_33695_33869[(2)] = null);

(statearr_33695_33869[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (8))){
var inst_33071 = (state_33492[(2)]);
var state_33492__$1 = state_33492;
if(cljs.core.truth_(inst_33071)){
var statearr_33696_33870 = state_33492__$1;
(statearr_33696_33870[(1)] = (9));

} else {
var statearr_33697_33871 = state_33492__$1;
(statearr_33697_33871[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (49))){
var inst_33162 = (state_33492[(62)]);
var inst_33162__$1 = cljs.core.not.call(null,recur_QMARK_);
var state_33492__$1 = (function (){var statearr_33698 = state_33492;
(statearr_33698[(62)] = inst_33162__$1);

return statearr_33698;
})();
if(inst_33162__$1){
var statearr_33699_33872 = state_33492__$1;
(statearr_33699_33872[(1)] = (51));

} else {
var statearr_33700_33873 = state_33492__$1;
(statearr_33700_33873[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33493 === (84))){
var inst_33270 = (state_33492[(59)]);
var state_33492__$1 = state_33492;
var statearr_33701_33874 = state_33492__$1;
(statearr_33701_33874[(2)] = inst_33270);

(statearr_33701_33874[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__10945__auto__ = null;
var fluree$db$query$fql$state_machine__10945__auto____0 = (function (){
var statearr_33702 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33702[(0)] = fluree$db$query$fql$state_machine__10945__auto__);

(statearr_33702[(1)] = (1));

return statearr_33702;
});
var fluree$db$query$fql$state_machine__10945__auto____1 = (function (state_33492){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_33492);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e33703){var ex__10948__auto__ = e33703;
var statearr_33704_33875 = state_33492;
(statearr_33704_33875[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_33492[(4)]))){
var statearr_33705_33876 = state_33492;
(statearr_33705_33876[(1)] = cljs.core.first.call(null,(state_33492[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33877 = state_33492;
state_33492 = G__33877;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__10945__auto__ = function(state_33492){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__10945__auto____1.call(this,state_33492);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__10945__auto____0;
fluree$db$query$fql$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__10945__auto____1;
return fluree$db$query$fql$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_33706 = f__11019__auto__.call(null);
(statearr_33706[(6)] = c__11018__auto__);

return statearr_33706;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid.call(null,subject_id);
var or__5045__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec.call(null,db,coll_id,cljs.core.get_in.call(null,base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.call(null,base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.call(null,lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql.vswap_BANG_.call(null,cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_34037){
var state_val_34038 = (state_34037[(1)]);
if((state_val_34038 === (7))){
var inst_34032 = (state_34037[(2)]);
var _ = (function (){var statearr_34039 = state_34037;
(statearr_34039[(4)] = cljs.core.rest.call(null,(state_34037[(4)])));

return statearr_34039;
})();
var state_34037__$1 = state_34037;
var statearr_34040_34122 = state_34037__$1;
(statearr_34040_34122[(2)] = inst_34032);

(statearr_34040_34122[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (20))){
var inst_33959 = (state_34037[(7)]);
var state_34037__$1 = state_34037;
var statearr_34041_34123 = state_34037__$1;
(statearr_34041_34123[(2)] = inst_33959);

(statearr_34041_34123[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (27))){
var inst_33914 = (state_34037[(8)]);
var state_34037__$1 = state_34037;
if(cljs.core.truth_(inst_33914)){
var statearr_34042_34124 = state_34037__$1;
(statearr_34042_34124[(1)] = (29));

} else {
var statearr_34043_34125 = state_34037__$1;
(statearr_34043_34125[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (1))){
var state_34037__$1 = state_34037;
var statearr_34044_34126 = state_34037__$1;
(statearr_34044_34126[(2)] = null);

(statearr_34044_34126[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (24))){
var inst_33915 = (state_34037[(9)]);
var state_34037__$1 = state_34037;
var statearr_34045_34127 = state_34037__$1;
(statearr_34045_34127[(2)] = inst_33915);

(statearr_34045_34127[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (39))){
var inst_33951 = (state_34037[(10)]);
var state_34037__$1 = state_34037;
var statearr_34046_34128 = state_34037__$1;
(statearr_34046_34128[(2)] = inst_33951);

(statearr_34046_34128[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (46))){
var inst_33916 = (state_34037[(11)]);
var state_34037__$1 = state_34037;
var statearr_34047_34129 = state_34037__$1;
(statearr_34047_34129[(2)] = inst_33916);

(statearr_34047_34129[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (4))){
var inst_33878 = (state_34037[(2)]);
var state_34037__$1 = state_34037;
var statearr_34048_34130 = state_34037__$1;
(statearr_34048_34130[(2)] = inst_33878);

(statearr_34048_34130[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (15))){
var inst_33927 = (state_34037[(12)]);
var inst_33933 = cljs.core.count.call(null,inst_33927);
var inst_33934 = fluree.db.query.fql.add_fuel.call(null,fuel,inst_33933,max_fuel);
var state_34037__$1 = state_34037;
var statearr_34049_34131 = state_34037__$1;
(statearr_34049_34131[(2)] = inst_33934);

(statearr_34049_34131[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (48))){
var inst_34018 = (state_34037[(13)]);
var inst_33896 = (state_34037[(14)]);
var inst_33903 = (state_34037[(15)]);
var inst_34026 = (state_34037[(2)]);
var inst_34027 = cljs.core.assoc.call(null,inst_33896,inst_34026,inst_34018);
var inst_33895 = inst_33903;
var inst_33896__$1 = inst_34027;
var state_34037__$1 = (function (){var statearr_34050 = state_34037;
(statearr_34050[(16)] = inst_33895);

(statearr_34050[(14)] = inst_33896__$1);

return statearr_34050;
})();
var statearr_34051_34132 = state_34037__$1;
(statearr_34051_34132[(2)] = null);

(statearr_34051_34132[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (50))){
var inst_33918 = (state_34037[(17)]);
var state_34037__$1 = state_34037;
var statearr_34052_34133 = state_34037__$1;
(statearr_34052_34133[(2)] = inst_33918);

(statearr_34052_34133[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (21))){
var inst_33915 = (state_34037[(9)]);
var state_34037__$1 = state_34037;
if(cljs.core.truth_(inst_33915)){
var statearr_34054_34134 = state_34037__$1;
(statearr_34054_34134[(1)] = (23));

} else {
var statearr_34055_34135 = state_34037__$1;
(statearr_34055_34135[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (31))){
var inst_33975 = (state_34037[(2)]);
var state_34037__$1 = state_34037;
if(cljs.core.truth_(inst_33975)){
var statearr_34056_34136 = state_34037__$1;
(statearr_34056_34136[(1)] = (32));

} else {
var statearr_34057_34137 = state_34037__$1;
(statearr_34057_34137[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (32))){
var inst_33950 = (state_34037[(18)]);
var inst_33958 = (state_34037[(19)]);
var inst_33951 = (state_34037[(10)]);
var inst_33977 = (inst_33950 + (1));
var tmp34053 = inst_33951;
var inst_33949 = inst_33958;
var inst_33950__$1 = inst_33977;
var inst_33951__$1 = tmp34053;
var state_34037__$1 = (function (){var statearr_34058 = state_34037;
(statearr_34058[(18)] = inst_33950__$1);

(statearr_34058[(10)] = inst_33951__$1);

(statearr_34058[(20)] = inst_33949);

return statearr_34058;
})();
var statearr_34059_34138 = state_34037__$1;
(statearr_34059_34138[(2)] = null);

(statearr_34059_34138[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (40))){
var state_34037__$1 = state_34037;
if(cljs.core.truth_(fuel)){
var statearr_34060_34139 = state_34037__$1;
(statearr_34060_34139[(1)] = (42));

} else {
var statearr_34061_34140 = state_34037__$1;
(statearr_34061_34140[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (33))){
var state_34037__$1 = state_34037;
var statearr_34062_34141 = state_34037__$1;
(statearr_34062_34141[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (13))){
var inst_33927 = (state_34037[(12)]);
var state_34037__$1 = state_34037;
var statearr_34064_34142 = state_34037__$1;
(statearr_34064_34142[(2)] = inst_33927);

(statearr_34064_34142[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (22))){
var inst_33968 = (state_34037[(2)]);
var state_34037__$1 = state_34037;
if(cljs.core.truth_(inst_33968)){
var statearr_34065_34143 = state_34037__$1;
(statearr_34065_34143[(1)] = (26));

} else {
var statearr_34066_34144 = state_34037__$1;
(statearr_34066_34144[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (36))){
var state_34037__$1 = state_34037;
var statearr_34067_34145 = state_34037__$1;
(statearr_34067_34145[(2)] = null);

(statearr_34067_34145[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (41))){
var inst_33950 = (state_34037[(18)]);
var inst_33958 = (state_34037[(19)]);
var inst_34007 = (state_34037[(2)]);
var inst_34008 = (inst_33950 + (1));
var inst_33949 = inst_33958;
var inst_33950__$1 = inst_34008;
var inst_33951 = inst_34007;
var state_34037__$1 = (function (){var statearr_34068 = state_34037;
(statearr_34068[(18)] = inst_33950__$1);

(statearr_34068[(10)] = inst_33951);

(statearr_34068[(20)] = inst_33949);

return statearr_34068;
})();
var statearr_34069_34146 = state_34037__$1;
(statearr_34069_34146[(2)] = null);

(statearr_34069_34146[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (43))){
var state_34037__$1 = state_34037;
var statearr_34070_34147 = state_34037__$1;
(statearr_34070_34147[(2)] = null);

(statearr_34070_34147[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (29))){
var inst_33950 = (state_34037[(18)]);
var inst_33914 = (state_34037[(8)]);
var inst_33972 = (inst_33950 < inst_33914);
var state_34037__$1 = state_34037;
var statearr_34071_34148 = state_34037__$1;
(statearr_34071_34148[(2)] = inst_33972);

(statearr_34071_34148[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (44))){
var inst_33987 = (state_34037[(21)]);
var inst_33991 = (state_34037[(22)]);
var inst_34000 = (state_34037[(2)]);
var inst_34001 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_33991,inst_33987);
var state_34037__$1 = (function (){var statearr_34072 = state_34037;
(statearr_34072[(23)] = inst_34000);

return statearr_34072;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34037__$1,(45),inst_34001);
} else {
if((state_val_34038 === (6))){
var inst_33902 = (state_34037[(24)]);
var inst_33895 = (state_34037[(16)]);
var inst_33901 = cljs.core.seq.call(null,inst_33895);
var inst_33902__$1 = cljs.core.first.call(null,inst_33901);
var inst_33903 = cljs.core.next.call(null,inst_33901);
var inst_33904 = cljs.core.not.call(null,inst_33902__$1);
var state_34037__$1 = (function (){var statearr_34073 = state_34037;
(statearr_34073[(24)] = inst_33902__$1);

(statearr_34073[(15)] = inst_33903);

return statearr_34073;
})();
if(inst_33904){
var statearr_34074_34149 = state_34037__$1;
(statearr_34074_34149[(1)] = (8));

} else {
var statearr_34075_34150 = state_34037__$1;
(statearr_34075_34150[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (28))){
var inst_34016 = (state_34037[(2)]);
var state_34037__$1 = state_34037;
var statearr_34076_34151 = state_34037__$1;
(statearr_34076_34151[(2)] = inst_34016);

(statearr_34076_34151[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (51))){
var inst_34024 = (state_34037[(2)]);
var state_34037__$1 = state_34037;
var statearr_34077_34152 = state_34037__$1;
(statearr_34077_34152[(2)] = inst_34024);

(statearr_34077_34152[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (25))){
var inst_33966 = (state_34037[(2)]);
var state_34037__$1 = state_34037;
var statearr_34078_34153 = state_34037__$1;
(statearr_34078_34153[(2)] = inst_33966);

(statearr_34078_34153[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (34))){
var inst_34014 = (state_34037[(2)]);
var state_34037__$1 = state_34037;
var statearr_34079_34154 = state_34037__$1;
(statearr_34079_34154[(2)] = inst_34014);

(statearr_34079_34154[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (17))){
var inst_33927 = (state_34037[(12)]);
var inst_33937 = (state_34037[(2)]);
var inst_33945 = cljs.core.seq.call(null,inst_33927);
var inst_33946 = cljs.core.first.call(null,inst_33945);
var inst_33947 = cljs.core.next.call(null,inst_33945);
var inst_33948 = cljs.core.PersistentVector.EMPTY;
var inst_33949 = inst_33927;
var inst_33950 = (0);
var inst_33951 = inst_33948;
var state_34037__$1 = (function (){var statearr_34080 = state_34037;
(statearr_34080[(18)] = inst_33950);

(statearr_34080[(25)] = inst_33937);

(statearr_34080[(10)] = inst_33951);

(statearr_34080[(26)] = inst_33946);

(statearr_34080[(20)] = inst_33949);

(statearr_34080[(27)] = inst_33947);

return statearr_34080;
})();
var statearr_34081_34155 = state_34037__$1;
(statearr_34081_34155[(2)] = null);

(statearr_34081_34155[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (3))){
var inst_34035 = (state_34037[(2)]);
var state_34037__$1 = state_34037;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34037__$1,inst_34035);
} else {
if((state_val_34038 === (12))){
var state_34037__$1 = state_34037;
var statearr_34082_34156 = state_34037__$1;
(statearr_34082_34156[(2)] = fuel);

(statearr_34082_34156[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (2))){
var _ = (function (){var statearr_34083 = state_34037;
(statearr_34083[(4)] = cljs.core.cons.call(null,(5),(state_34037[(4)])));

return statearr_34083;
})();
var inst_33891 = reverse_refs_specs;
var inst_33892 = cljs.core.seq.call(null,inst_33891);
var inst_33893 = cljs.core.first.call(null,inst_33892);
var inst_33894 = cljs.core.next.call(null,inst_33892);
var inst_33895 = inst_33891;
var inst_33896 = null;
var state_34037__$1 = (function (){var statearr_34084 = state_34037;
(statearr_34084[(28)] = inst_33893);

(statearr_34084[(29)] = inst_33894);

(statearr_34084[(16)] = inst_33895);

(statearr_34084[(14)] = inst_33896);

return statearr_34084;
})();
var statearr_34085_34157 = state_34037__$1;
(statearr_34085_34157[(2)] = null);

(statearr_34085_34157[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (23))){
var inst_33950 = (state_34037[(18)]);
var inst_33915 = (state_34037[(9)]);
var inst_33963 = (inst_33950 >= inst_33915);
var state_34037__$1 = state_34037;
var statearr_34086_34158 = state_34037__$1;
(statearr_34086_34158[(2)] = inst_33963);

(statearr_34086_34158[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (47))){
var inst_33917 = (state_34037[(30)]);
var state_34037__$1 = state_34037;
if(cljs.core.truth_(inst_33917)){
var statearr_34087_34159 = state_34037__$1;
(statearr_34087_34159[(1)] = (49));

} else {
var statearr_34088_34160 = state_34037__$1;
(statearr_34088_34160[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (35))){
var inst_33957 = (state_34037[(31)]);
var inst_33981 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33982 = [inst_33957];
var inst_33983 = (new cljs.core.PersistentVector(null,1,(5),inst_33981,inst_33982,null));
var inst_33984 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_33983);
var state_34037__$1 = state_34037;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34037__$1,(38),inst_33984);
} else {
if((state_val_34038 === (19))){
var inst_33916 = (state_34037[(11)]);
var inst_34018 = (state_34037[(2)]);
var state_34037__$1 = (function (){var statearr_34089 = state_34037;
(statearr_34089[(13)] = inst_34018);

return statearr_34089;
})();
if(cljs.core.truth_(inst_33916)){
var statearr_34090_34161 = state_34037__$1;
(statearr_34090_34161[(1)] = (46));

} else {
var statearr_34091_34162 = state_34037__$1;
(statearr_34091_34162[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (11))){
var inst_33927 = (state_34037[(12)]);
var inst_33924 = (state_34037[(2)]);
var inst_33925 = fluree.db.util.async.throw_err.call(null,inst_33924);
var inst_33926 = cljs.core.map.call(null,fluree.db.query.fql.s,inst_33925);
var inst_33927__$1 = cljs.core.not_empty.call(null,inst_33926);
var state_34037__$1 = (function (){var statearr_34093 = state_34037;
(statearr_34093[(12)] = inst_33927__$1);

return statearr_34093;
})();
if(cljs.core.truth_(inst_33927__$1)){
var statearr_34094_34163 = state_34037__$1;
(statearr_34094_34163[(1)] = (12));

} else {
var statearr_34095_34164 = state_34037__$1;
(statearr_34095_34164[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (9))){
var inst_33902 = (state_34037[(24)]);
var inst_33912 = (state_34037[(32)]);
var inst_33911 = cljs.core.nth.call(null,inst_33902,(0),null);
var inst_33912__$1 = cljs.core.nth.call(null,inst_33902,(1),null);
var inst_33913 = cljs.core.__destructure_map.call(null,inst_33912__$1);
var inst_33914 = cljs.core.get.call(null,inst_33913,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_33915 = cljs.core.get.call(null,inst_33913,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_33916 = cljs.core.get.call(null,inst_33913,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_33917 = cljs.core.get.call(null,inst_33913,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_33918 = cljs.core.get.call(null,inst_33913,new cljs.core.Keyword(null,"p","p",151049309));
var inst_33919 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33920 = [subject_id,inst_33911];
var inst_33921 = (new cljs.core.PersistentVector(null,2,(5),inst_33919,inst_33920,null));
var inst_33922 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_33921);
var state_34037__$1 = (function (){var statearr_34096 = state_34037;
(statearr_34096[(17)] = inst_33918);

(statearr_34096[(8)] = inst_33914);

(statearr_34096[(30)] = inst_33917);

(statearr_34096[(11)] = inst_33916);

(statearr_34096[(9)] = inst_33915);

(statearr_34096[(32)] = inst_33912__$1);

return statearr_34096;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34037__$1,(11),inst_33922);
} else {
if((state_val_34038 === (5))){
var _ = (function (){var statearr_34097 = state_34037;
(statearr_34097[(4)] = cljs.core.rest.call(null,(state_34037[(4)])));

return statearr_34097;
})();
var state_34037__$1 = state_34037;
var ex34092 = (state_34037__$1[(2)]);
var statearr_34098_34165 = state_34037__$1;
(statearr_34098_34165[(5)] = ex34092);


if((ex34092 instanceof Error)){
var statearr_34099_34166 = state_34037__$1;
(statearr_34099_34166[(1)] = (4));

(statearr_34099_34166[(5)] = null);

} else {
throw ex34092;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (14))){
var inst_33931 = (state_34037[(2)]);
var state_34037__$1 = state_34037;
if(cljs.core.truth_(inst_33931)){
var statearr_34100_34167 = state_34037__$1;
(statearr_34100_34167[(1)] = (15));

} else {
var statearr_34101_34168 = state_34037__$1;
(statearr_34101_34168[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (45))){
var inst_33951 = (state_34037[(10)]);
var inst_34003 = (state_34037[(2)]);
var inst_34004 = fluree.db.util.async.throw_err.call(null,inst_34003);
var inst_34005 = cljs.core.conj.call(null,inst_33951,inst_34004);
var state_34037__$1 = state_34037;
var statearr_34102_34169 = state_34037__$1;
(statearr_34102_34169[(2)] = inst_34005);

(statearr_34102_34169[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (26))){
var inst_33951 = (state_34037[(10)]);
var state_34037__$1 = state_34037;
var statearr_34103_34170 = state_34037__$1;
(statearr_34103_34170[(2)] = inst_33951);

(statearr_34103_34170[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (16))){
var state_34037__$1 = state_34037;
var statearr_34104_34171 = state_34037__$1;
(statearr_34104_34171[(2)] = null);

(statearr_34104_34171[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (38))){
var inst_33987 = (state_34037[(21)]);
var inst_33912 = (state_34037[(32)]);
var inst_33986 = (state_34037[(2)]);
var inst_33987__$1 = fluree.db.util.async.throw_err.call(null,inst_33986);
var inst_33988 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33989 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_33990 = (new cljs.core.PersistentVector(null,4,(5),inst_33988,inst_33989,null));
var inst_33991 = cljs.core.select_keys.call(null,inst_33912,inst_33990);
var inst_33992 = cljs.core.empty_QMARK_.call(null,inst_33987__$1);
var state_34037__$1 = (function (){var statearr_34105 = state_34037;
(statearr_34105[(21)] = inst_33987__$1);

(statearr_34105[(22)] = inst_33991);

return statearr_34105;
})();
if(inst_33992){
var statearr_34106_34172 = state_34037__$1;
(statearr_34106_34172[(1)] = (39));

} else {
var statearr_34107_34173 = state_34037__$1;
(statearr_34107_34173[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (30))){
var inst_33914 = (state_34037[(8)]);
var state_34037__$1 = state_34037;
var statearr_34108_34174 = state_34037__$1;
(statearr_34108_34174[(2)] = inst_33914);

(statearr_34108_34174[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (10))){
var inst_34030 = (state_34037[(2)]);
var state_34037__$1 = state_34037;
var statearr_34109_34175 = state_34037__$1;
(statearr_34109_34175[(2)] = inst_34030);

(statearr_34109_34175[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (18))){
var inst_33957 = (state_34037[(31)]);
var inst_33959 = (state_34037[(7)]);
var inst_33949 = (state_34037[(20)]);
var inst_33956 = cljs.core.seq.call(null,inst_33949);
var inst_33957__$1 = cljs.core.first.call(null,inst_33956);
var inst_33958 = cljs.core.next.call(null,inst_33956);
var inst_33959__$1 = cljs.core.not.call(null,inst_33957__$1);
var state_34037__$1 = (function (){var statearr_34110 = state_34037;
(statearr_34110[(31)] = inst_33957__$1);

(statearr_34110[(19)] = inst_33958);

(statearr_34110[(7)] = inst_33959__$1);

return statearr_34110;
})();
if(inst_33959__$1){
var statearr_34111_34176 = state_34037__$1;
(statearr_34111_34176[(1)] = (20));

} else {
var statearr_34112_34177 = state_34037__$1;
(statearr_34112_34177[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (42))){
var inst_33987 = (state_34037[(21)]);
var inst_33996 = cljs.core.count.call(null,inst_33987);
var inst_33997 = fluree.db.query.fql.add_fuel.call(null,fuel,inst_33996,max_fuel);
var state_34037__$1 = state_34037;
var statearr_34113_34178 = state_34037__$1;
(statearr_34113_34178[(2)] = inst_33997);

(statearr_34113_34178[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (37))){
var inst_34012 = (state_34037[(2)]);
var state_34037__$1 = state_34037;
var statearr_34114_34179 = state_34037__$1;
(statearr_34114_34179[(2)] = inst_34012);

(statearr_34114_34179[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (8))){
var inst_33896 = (state_34037[(14)]);
var state_34037__$1 = state_34037;
var statearr_34115_34180 = state_34037__$1;
(statearr_34115_34180[(2)] = inst_33896);

(statearr_34115_34180[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34038 === (49))){
var inst_33917 = (state_34037[(30)]);
var state_34037__$1 = state_34037;
var statearr_34116_34181 = state_34037__$1;
(statearr_34116_34181[(2)] = inst_33917);

(statearr_34116_34181[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10945__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10945__auto____0 = (function (){
var statearr_34117 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34117[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10945__auto__);

(statearr_34117[(1)] = (1));

return statearr_34117;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10945__auto____1 = (function (state_34037){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_34037);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e34118){var ex__10948__auto__ = e34118;
var statearr_34119_34182 = state_34037;
(statearr_34119_34182[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_34037[(4)]))){
var statearr_34120_34183 = state_34037;
(statearr_34120_34183[(1)] = cljs.core.first.call(null,(state_34037[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34184 = state_34037;
state_34037 = G__34184;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10945__auto__ = function(state_34037){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10945__auto____1.call(this,state_34037);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10945__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10945__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_34121 = f__11019__auto__.call(null);
(statearr_34121[(6)] = c__11018__auto__);

return statearr_34121;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_.call(null,pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.call(null,(function (acc,spec){
var key_spec = cljs.core.key.call(null,spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,spec)) == null))?cljs.core.assoc.call(null,cljs.core.val.call(null,spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val.call(null,spec));
return cljs.core.assoc.call(null,acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.call(null,coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__34185 = select_spec;
var map__34185__$1 = cljs.core.__destructure_map.call(null,map__34185);
var recur_seen = cljs.core.get.call(null,map__34185__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.call(null,map__34185__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.call(null,recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_34299){
var state_val_34300 = (state_34299[(1)]);
if((state_val_34300 === (7))){
var inst_34211 = flakes;
var inst_34212 = cljs.core.seq.call(null,inst_34211);
var inst_34213 = cljs.core.first.call(null,inst_34212);
var inst_34214 = cljs.core.next.call(null,inst_34212);
var inst_34215 = cljs.core.PersistentVector.EMPTY;
var inst_34216 = inst_34211;
var inst_34217 = (0);
var inst_34218 = inst_34215;
var state_34299__$1 = (function (){var statearr_34301 = state_34299;
(statearr_34301[(7)] = inst_34218);

(statearr_34301[(8)] = inst_34213);

(statearr_34301[(9)] = inst_34216);

(statearr_34301[(10)] = inst_34217);

(statearr_34301[(11)] = inst_34214);

return statearr_34301;
})();
var statearr_34302_34368 = state_34299__$1;
(statearr_34302_34368[(2)] = null);

(statearr_34302_34368[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (20))){
var state_34299__$1 = state_34299;
var statearr_34303_34369 = state_34299__$1;
(statearr_34303_34369[(2)] = results);

(statearr_34303_34369[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (27))){
var state_34299__$1 = state_34299;
var statearr_34304_34370 = state_34299__$1;
(statearr_34304_34370[(2)] = null);

(statearr_34304_34370[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (1))){
var state_34299__$1 = state_34299;
var statearr_34305_34371 = state_34299__$1;
(statearr_34305_34371[(2)] = null);

(statearr_34305_34371[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (24))){
var state_34299__$1 = state_34299;
var statearr_34306_34372 = state_34299__$1;
(statearr_34306_34372[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (39))){
var inst_34218 = (state_34299[(7)]);
var inst_34280 = (state_34299[(12)]);
var inst_34225 = (state_34299[(13)]);
var inst_34283 = (state_34299[(2)]);
var inst_34284 = fluree.db.util.async.throw_err.call(null,inst_34283);
var inst_34285 = cljs.core.conj.call(null,inst_34218,inst_34284);
var inst_34216 = inst_34225;
var inst_34217 = inst_34280;
var inst_34218__$1 = inst_34285;
var state_34299__$1 = (function (){var statearr_34308 = state_34299;
(statearr_34308[(7)] = inst_34218__$1);

(statearr_34308[(9)] = inst_34216);

(statearr_34308[(10)] = inst_34217);

return statearr_34308;
})();
var statearr_34309_34373 = state_34299__$1;
(statearr_34309_34373[(2)] = null);

(statearr_34309_34373[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (4))){
var inst_34186 = (state_34299[(2)]);
var state_34299__$1 = state_34299;
var statearr_34310_34374 = state_34299__$1;
(statearr_34310_34374[(2)] = inst_34186);

(statearr_34310_34374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (15))){
var inst_34199 = (state_34299[(14)]);
var state_34299__$1 = state_34299;
var statearr_34311_34375 = state_34299__$1;
(statearr_34311_34375[(2)] = inst_34199);

(statearr_34311_34375[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (21))){
var inst_34195 = (state_34299[(15)]);
var state_34299__$1 = state_34299;
if(cljs.core.truth_(inst_34195)){
var statearr_34312_34376 = state_34299__$1;
(statearr_34312_34376[(1)] = (23));

} else {
var statearr_34313_34377 = state_34299__$1;
(statearr_34313_34377[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (31))){
var inst_34263 = (state_34299[(16)]);
var state_34299__$1 = state_34299;
var statearr_34314_34378 = state_34299__$1;
(statearr_34314_34378[(2)] = inst_34263);

(statearr_34314_34378[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (32))){
var inst_34255 = (state_34299[(17)]);
var inst_34269 = (state_34299[(2)]);
var state_34299__$1 = (function (){var statearr_34315 = state_34299;
(statearr_34315[(18)] = inst_34269);

return statearr_34315;
})();
if(cljs.core.truth_(inst_34255)){
var statearr_34316_34379 = state_34299__$1;
(statearr_34316_34379[(1)] = (33));

} else {
var statearr_34317_34380 = state_34299__$1;
(statearr_34317_34380[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (33))){
var inst_34255 = (state_34299[(17)]);
var state_34299__$1 = state_34299;
var statearr_34318_34381 = state_34299__$1;
(statearr_34318_34381[(2)] = inst_34255);

(statearr_34318_34381[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (13))){
var inst_34235 = (state_34299[(2)]);
var state_34299__$1 = state_34299;
if(cljs.core.truth_(inst_34235)){
var statearr_34320_34382 = state_34299__$1;
(statearr_34320_34382[(1)] = (17));

} else {
var statearr_34321_34383 = state_34299__$1;
(statearr_34321_34383[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (22))){
var inst_34252 = (state_34299[(2)]);
var state_34299__$1 = state_34299;
var statearr_34322_34384 = state_34299__$1;
(statearr_34322_34384[(2)] = inst_34252);

(statearr_34322_34384[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (36))){
var inst_34218 = (state_34299[(7)]);
var inst_34217 = (state_34299[(10)]);
var inst_34225 = (state_34299[(13)]);
var inst_34277 = (inst_34217 + (1));
var tmp34319 = inst_34218;
var inst_34216 = inst_34225;
var inst_34217__$1 = inst_34277;
var inst_34218__$1 = tmp34319;
var state_34299__$1 = (function (){var statearr_34323 = state_34299;
(statearr_34323[(7)] = inst_34218__$1);

(statearr_34323[(9)] = inst_34216);

(statearr_34323[(10)] = inst_34217__$1);

return statearr_34323;
})();
var statearr_34324_34385 = state_34299__$1;
(statearr_34324_34385[(2)] = null);

(statearr_34324_34385[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (29))){
var inst_34262 = (state_34299[(2)]);
var inst_34263 = fluree.db.util.async.throw_err.call(null,inst_34262);
var state_34299__$1 = (function (){var statearr_34325 = state_34299;
(statearr_34325[(16)] = inst_34263);

return statearr_34325;
})();
if(cljs.core.truth_(fuel)){
var statearr_34326_34386 = state_34299__$1;
(statearr_34326_34386[(1)] = (30));

} else {
var statearr_34327_34387 = state_34299__$1;
(statearr_34327_34387[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (6))){
var state_34299__$1 = state_34299;
var statearr_34328_34388 = state_34299__$1;
(statearr_34328_34388[(2)] = results);

(statearr_34328_34388[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (28))){
var inst_34248 = (state_34299[(2)]);
var state_34299__$1 = state_34299;
var statearr_34329_34389 = state_34299__$1;
(statearr_34329_34389[(2)] = inst_34248);

(statearr_34329_34389[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (25))){
var inst_34250 = (state_34299[(2)]);
var state_34299__$1 = state_34299;
var statearr_34330_34390 = state_34299__$1;
(statearr_34330_34390[(2)] = inst_34250);

(statearr_34330_34390[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (34))){
var inst_34269 = (state_34299[(18)]);
var inst_34272 = cljs.core.empty_QMARK_.call(null,inst_34269);
var state_34299__$1 = state_34299;
var statearr_34331_34391 = state_34299__$1;
(statearr_34331_34391[(2)] = inst_34272);

(statearr_34331_34391[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (17))){
var inst_34218 = (state_34299[(7)]);
var inst_34237 = cljs.core.empty_QMARK_.call(null,inst_34218);
var state_34299__$1 = state_34299;
if(inst_34237){
var statearr_34332_34392 = state_34299__$1;
(statearr_34332_34392[(1)] = (20));

} else {
var statearr_34333_34393 = state_34299__$1;
(statearr_34333_34393[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (3))){
var inst_34297 = (state_34299[(2)]);
var state_34299__$1 = state_34299;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34299__$1,inst_34297);
} else {
if((state_val_34300 === (12))){
var inst_34199 = (state_34299[(14)]);
var state_34299__$1 = state_34299;
if(cljs.core.truth_(inst_34199)){
var statearr_34334_34394 = state_34299__$1;
(statearr_34334_34394[(1)] = (14));

} else {
var statearr_34335_34395 = state_34299__$1;
(statearr_34335_34395[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (2))){
var _ = (function (){var statearr_34336 = state_34299;
(statearr_34336[(4)] = cljs.core.cons.call(null,(5),(state_34299[(4)])));

return statearr_34336;
})();
var inst_34193 = select_spec;
var inst_34194 = cljs.core.__destructure_map.call(null,inst_34193);
var inst_34195 = cljs.core.get.call(null,inst_34194,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_34196 = cljs.core.get.call(null,inst_34194,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_34197 = cljs.core.get.call(null,inst_34194,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_34198 = cljs.core.get.call(null,inst_34194,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_34199 = cljs.core.get.call(null,inst_34194,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_34200 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_34201 = (inst_34198 > inst_34200);
var state_34299__$1 = (function (){var statearr_34337 = state_34299;
(statearr_34337[(14)] = inst_34199);

(statearr_34337[(19)] = inst_34196);

(statearr_34337[(15)] = inst_34195);

(statearr_34337[(20)] = inst_34197);

return statearr_34337;
})();
if(cljs.core.truth_(inst_34201)){
var statearr_34338_34396 = state_34299__$1;
(statearr_34338_34396[(1)] = (6));

} else {
var statearr_34339_34397 = state_34299__$1;
(statearr_34339_34397[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (23))){
var inst_34196 = (state_34299[(19)]);
var inst_34218 = (state_34299[(7)]);
var inst_34241 = cljs.core.assoc.call(null,results,inst_34196,inst_34218);
var state_34299__$1 = state_34299;
var statearr_34340_34398 = state_34299__$1;
(statearr_34340_34398[(2)] = inst_34241);

(statearr_34340_34398[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (35))){
var inst_34224 = (state_34299[(21)]);
var inst_34274 = (state_34299[(2)]);
var inst_34275 = fluree.db.query.fql.recur_select_spec.call(null,select_spec,inst_34224);
var state_34299__$1 = (function (){var statearr_34341 = state_34299;
(statearr_34341[(22)] = inst_34275);

return statearr_34341;
})();
if(cljs.core.truth_(inst_34274)){
var statearr_34342_34399 = state_34299__$1;
(statearr_34342_34399[(1)] = (36));

} else {
var statearr_34343_34400 = state_34299__$1;
(statearr_34343_34400[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (19))){
var inst_34290 = (state_34299[(2)]);
var state_34299__$1 = state_34299;
var statearr_34344_34401 = state_34299__$1;
(statearr_34344_34401[(2)] = inst_34290);

(statearr_34344_34401[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (11))){
var inst_34226 = (state_34299[(23)]);
var state_34299__$1 = state_34299;
var statearr_34346_34402 = state_34299__$1;
(statearr_34346_34402[(2)] = inst_34226);

(statearr_34346_34402[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (9))){
var inst_34216 = (state_34299[(9)]);
var inst_34224 = (state_34299[(21)]);
var inst_34226 = (state_34299[(23)]);
var inst_34223 = cljs.core.seq.call(null,inst_34216);
var inst_34224__$1 = cljs.core.first.call(null,inst_34223);
var inst_34225 = cljs.core.next.call(null,inst_34223);
var inst_34226__$1 = cljs.core.not.call(null,inst_34224__$1);
var state_34299__$1 = (function (){var statearr_34347 = state_34299;
(statearr_34347[(21)] = inst_34224__$1);

(statearr_34347[(13)] = inst_34225);

(statearr_34347[(23)] = inst_34226__$1);

return statearr_34347;
})();
if(inst_34226__$1){
var statearr_34348_34403 = state_34299__$1;
(statearr_34348_34403[(1)] = (11));

} else {
var statearr_34349_34404 = state_34299__$1;
(statearr_34349_34404[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (5))){
var _ = (function (){var statearr_34350 = state_34299;
(statearr_34350[(4)] = cljs.core.rest.call(null,(state_34299[(4)])));

return statearr_34350;
})();
var state_34299__$1 = state_34299;
var ex34345 = (state_34299__$1[(2)]);
var statearr_34351_34405 = state_34299__$1;
(statearr_34351_34405[(5)] = ex34345);


if((ex34345 instanceof Error)){
var statearr_34352_34406 = state_34299__$1;
(statearr_34352_34406[(1)] = (4));

(statearr_34352_34406[(5)] = null);

} else {
throw ex34345;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (14))){
var inst_34199 = (state_34299[(14)]);
var inst_34217 = (state_34299[(10)]);
var inst_34230 = (inst_34217 < inst_34199);
var state_34299__$1 = state_34299;
var statearr_34353_34407 = state_34299__$1;
(statearr_34353_34407[(2)] = inst_34230);

(statearr_34353_34407[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (26))){
var inst_34196 = (state_34299[(19)]);
var inst_34218 = (state_34299[(7)]);
var inst_34244 = cljs.core.first.call(null,inst_34218);
var inst_34245 = cljs.core.assoc.call(null,results,inst_34196,inst_34244);
var state_34299__$1 = state_34299;
var statearr_34354_34408 = state_34299__$1;
(statearr_34354_34408[(2)] = inst_34245);

(statearr_34354_34408[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (16))){
var inst_34233 = (state_34299[(2)]);
var state_34299__$1 = state_34299;
var statearr_34355_34409 = state_34299__$1;
(statearr_34355_34409[(2)] = inst_34233);

(statearr_34355_34409[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (38))){
var inst_34288 = (state_34299[(2)]);
var state_34299__$1 = state_34299;
var statearr_34356_34410 = state_34299__$1;
(statearr_34356_34410[(2)] = inst_34288);

(statearr_34356_34410[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (30))){
var inst_34263 = (state_34299[(16)]);
var inst_34265 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_34266 = cljs.core.sequence.call(null,inst_34265,inst_34263);
var state_34299__$1 = state_34299;
var statearr_34357_34411 = state_34299__$1;
(statearr_34357_34411[(2)] = inst_34266);

(statearr_34357_34411[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (10))){
var inst_34292 = (state_34299[(2)]);
var state_34299__$1 = state_34299;
var statearr_34358_34412 = state_34299__$1;
(statearr_34358_34412[(2)] = inst_34292);

(statearr_34358_34412[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (18))){
var inst_34224 = (state_34299[(21)]);
var inst_34197 = (state_34299[(20)]);
var inst_34254 = inst_34224.o;
var inst_34255 = cljs.core.contains_QMARK_.call(null,inst_34197,inst_34254);
var inst_34257 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34258 = [inst_34254];
var inst_34259 = (new cljs.core.PersistentVector(null,1,(5),inst_34257,inst_34258,null));
var inst_34260 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_34259);
var state_34299__$1 = (function (){var statearr_34359 = state_34299;
(statearr_34359[(17)] = inst_34255);

return statearr_34359;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34299__$1,(29),inst_34260);
} else {
if((state_val_34300 === (37))){
var inst_34275 = (state_34299[(22)]);
var inst_34269 = (state_34299[(18)]);
var inst_34217 = (state_34299[(10)]);
var inst_34280 = (inst_34217 + (1));
var inst_34281 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_34275,inst_34269);
var state_34299__$1 = (function (){var statearr_34360 = state_34299;
(statearr_34360[(12)] = inst_34280);

return statearr_34360;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34299__$1,(39),inst_34281);
} else {
if((state_val_34300 === (8))){
var inst_34294 = (state_34299[(2)]);
var _ = (function (){var statearr_34361 = state_34299;
(statearr_34361[(4)] = cljs.core.rest.call(null,(state_34299[(4)])));

return statearr_34361;
})();
var state_34299__$1 = state_34299;
var statearr_34362_34413 = state_34299__$1;
(statearr_34362_34413[(2)] = inst_34294);

(statearr_34362_34413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__10945__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__10945__auto____0 = (function (){
var statearr_34363 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34363[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__10945__auto__);

(statearr_34363[(1)] = (1));

return statearr_34363;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__10945__auto____1 = (function (state_34299){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_34299);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e34364){var ex__10948__auto__ = e34364;
var statearr_34365_34414 = state_34299;
(statearr_34365_34414[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_34299[(4)]))){
var statearr_34366_34415 = state_34299;
(statearr_34366_34415[(1)] = cljs.core.first.call(null,(state_34299[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34416 = state_34299;
state_34299 = G__34416;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__10945__auto__ = function(state_34299){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__10945__auto____1.call(this,state_34299);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__10945__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__10945__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_34367 = f__11019__auto__.call(null);
(statearr_34367[(6)] = c__11018__auto__);

return statearr_34367;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_34597){
var state_val_34598 = (state_34597[(1)]);
if((state_val_34598 === (7))){
var state_34597__$1 = state_34597;
var statearr_34599_34685 = state_34597__$1;
(statearr_34599_34685[(2)] = null);

(statearr_34599_34685[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (20))){
var inst_34455 = cljs.core.PersistentHashMap.EMPTY;
var state_34597__$1 = state_34597;
var statearr_34600_34686 = state_34597__$1;
(statearr_34600_34686[(2)] = inst_34455);

(statearr_34600_34686[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (27))){
var inst_34443 = (state_34597[(7)]);
var inst_34457 = (state_34597[(8)]);
var inst_34473 = (state_34597[(9)]);
var inst_34437 = (state_34597[(10)]);
var inst_34576 = (state_34597[(2)]);
var inst_34577 = (function (){var top_level_subject = inst_34437;
var select_spec = inst_34443;
var base_acc = inst_34457;
var acc_PLUS_refs = inst_34473;
var result = inst_34576;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__5045__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
}
})())){
return cljs.core.conj.call(null,acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_34578 = cljs.core.PersistentVector.EMPTY;
var inst_34579 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_34443);
var inst_34580 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_34579);
var inst_34581 = cljs.core.vals.call(null,inst_34580);
var inst_34582 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_34443);
var inst_34583 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_34582);
var inst_34584 = cljs.core.vals.call(null,inst_34583);
var inst_34585 = cljs.core.concat.call(null,inst_34581,inst_34584);
var inst_34586 = cljs.core.reduce.call(null,inst_34577,inst_34578,inst_34585);
var inst_34588 = (function (){var top_level_subject = inst_34437;
var select_spec = inst_34443;
var base_acc = inst_34457;
var acc_PLUS_refs = inst_34473;
var result = inst_34576;
var sort_preds = inst_34586;
return (function (acc,p__34587){
var vec__34601 = p__34587;
var selectPred = cljs.core.nth.call(null,vec__34601,(0),null);
var sortOrder = cljs.core.nth.call(null,vec__34601,(1),null);
var sortPred = cljs.core.nth.call(null,vec__34601,(2),null);
var limit = cljs.core.nth.call(null,vec__34601,(3),null);
return cljs.core.assoc.call(null,acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res.call(null,sortPred,sortOrder,(0),limit,cljs.core.get.call(null,acc,selectPred)));
});
})();
var inst_34589 = cljs.core.reduce.call(null,inst_34588,inst_34576,inst_34586);
var state_34597__$1 = state_34597;
var statearr_34604_34687 = state_34597__$1;
(statearr_34604_34687[(2)] = inst_34589);

(statearr_34604_34687[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (1))){
var state_34597__$1 = state_34597;
var statearr_34605_34688 = state_34597__$1;
(statearr_34605_34688[(2)] = null);

(statearr_34605_34688[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (24))){
var inst_34473 = (state_34597[(9)]);
var inst_34473__$1 = (state_34597[(2)]);
var inst_34474 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_34475 = cljs.core.PersistentHashMap.EMPTY;
var inst_34476 = inst_34474;
var inst_34477 = inst_34473__$1;
var inst_34478 = inst_34475;
var state_34597__$1 = (function (){var statearr_34606 = state_34597;
(statearr_34606[(9)] = inst_34473__$1);

(statearr_34606[(11)] = inst_34478);

(statearr_34606[(12)] = inst_34476);

(statearr_34606[(13)] = inst_34477);

return statearr_34606;
})();
var statearr_34607_34689 = state_34597__$1;
(statearr_34607_34689[(2)] = null);

(statearr_34607_34689[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (39))){
var inst_34443 = (state_34597[(7)]);
var inst_34493 = (state_34597[(14)]);
var inst_34477 = (state_34597[(13)]);
var inst_34486 = (state_34597[(15)]);
var inst_34522 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34523 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_34477,inst_34443,inst_34486,inst_34493,false);
var state_34597__$1 = (function (){var statearr_34608 = state_34597;
(statearr_34608[(16)] = inst_34522);

return statearr_34608;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34597__$1,(42),inst_34523);
} else {
if((state_val_34598 === (46))){
var inst_34478 = (state_34597[(11)]);
var inst_34476 = (state_34597[(12)]);
var inst_34486 = (state_34597[(15)]);
var inst_34540 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34541 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_34542 = cljs.core.first.call(null,inst_34486);
var inst_34543 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_34542);
var inst_34544 = [inst_34543];
var inst_34545 = cljs.core.PersistentHashMap.fromArrays(inst_34541,inst_34544);
var inst_34546 = cljs.core.rest.call(null,inst_34476);
var inst_34547 = [inst_34545,inst_34546,inst_34478];
var inst_34548 = (new cljs.core.PersistentVector(null,3,(5),inst_34540,inst_34547,null));
var state_34597__$1 = state_34597;
var statearr_34609_34690 = state_34597__$1;
(statearr_34609_34690[(2)] = inst_34548);

(statearr_34609_34690[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (4))){
var inst_34417 = (state_34597[(2)]);
var state_34597__$1 = state_34597;
var statearr_34610_34691 = state_34597__$1;
(statearr_34610_34691[(2)] = inst_34417);

(statearr_34610_34691[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (15))){
var inst_34443 = (state_34597[(7)]);
var inst_34444 = (state_34597[(17)]);
var inst_34443__$1 = (state_34597[(2)]);
var inst_34444__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_34443__$1);
var state_34597__$1 = (function (){var statearr_34611 = state_34597;
(statearr_34611[(7)] = inst_34443__$1);

(statearr_34611[(17)] = inst_34444__$1);

return statearr_34611;
})();
if(cljs.core.truth_(inst_34444__$1)){
var statearr_34612_34692 = state_34597__$1;
(statearr_34612_34692[(1)] = (16));

} else {
var statearr_34613_34693 = state_34597__$1;
(statearr_34613_34693[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (48))){
var inst_34559 = (state_34597[(2)]);
var state_34597__$1 = state_34597;
var statearr_34614_34694 = state_34597__$1;
(statearr_34614_34694[(2)] = inst_34559);

(statearr_34614_34694[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (50))){
var state_34597__$1 = state_34597;
var statearr_34615_34695 = state_34597__$1;
(statearr_34615_34695[(2)] = null);

(statearr_34615_34695[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (21))){
var inst_34443 = (state_34597[(7)]);
var inst_34457 = (state_34597[(2)]);
var inst_34458 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34459 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_34460 = (new cljs.core.PersistentVector(null,2,(5),inst_34458,inst_34459,null));
var inst_34461 = cljs.core.get_in.call(null,inst_34443,inst_34460);
var state_34597__$1 = (function (){var statearr_34616 = state_34597;
(statearr_34616[(8)] = inst_34457);

return statearr_34616;
})();
if(cljs.core.truth_(inst_34461)){
var statearr_34617_34696 = state_34597__$1;
(statearr_34617_34696[(1)] = (22));

} else {
var statearr_34618_34697 = state_34597__$1;
(statearr_34618_34697[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (31))){
var inst_34477 = (state_34597[(13)]);
var inst_34486 = (state_34597[(15)]);
var inst_34492 = (state_34597[(18)]);
var inst_34496 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34497 = fluree.db.query.fql.flake__GT_recur.call(null,db,inst_34486,inst_34492,inst_34477,fuel,max_fuel,cache);
var state_34597__$1 = (function (){var statearr_34619 = state_34597;
(statearr_34619[(19)] = inst_34496);

return statearr_34619;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34597__$1,(34),inst_34497);
} else {
if((state_val_34598 === (32))){
var inst_34492 = (state_34597[(18)]);
var state_34597__$1 = state_34597;
if(cljs.core.truth_(inst_34492)){
var statearr_34620_34698 = state_34597__$1;
(statearr_34620_34698[(1)] = (35));

} else {
var statearr_34621_34699 = state_34597__$1;
(statearr_34621_34699[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (40))){
var inst_34443 = (state_34597[(7)]);
var inst_34533 = (state_34597[(20)]);
var inst_34532 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_34443);
var inst_34533__$1 = cljs.core.empty_QMARK_.call(null,inst_34532);
var state_34597__$1 = (function (){var statearr_34622 = state_34597;
(statearr_34622[(20)] = inst_34533__$1);

return statearr_34622;
})();
if(inst_34533__$1){
var statearr_34623_34700 = state_34597__$1;
(statearr_34623_34700[(1)] = (43));

} else {
var statearr_34624_34701 = state_34597__$1;
(statearr_34624_34701[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (33))){
var inst_34486 = (state_34597[(15)]);
var inst_34565 = (state_34597[(2)]);
var inst_34566 = cljs.core.nth.call(null,inst_34565,(0),null);
var inst_34567 = cljs.core.nth.call(null,inst_34565,(1),null);
var inst_34568 = cljs.core.nth.call(null,inst_34565,(2),null);
var inst_34569 = cljs.core.first.call(null,inst_34486);
var inst_34570 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_34569);
var inst_34571 = cljs.core.assoc.call(null,inst_34566,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_34570);
var inst_34476 = inst_34567;
var inst_34477 = inst_34571;
var inst_34478 = inst_34568;
var state_34597__$1 = (function (){var statearr_34625 = state_34597;
(statearr_34625[(11)] = inst_34478);

(statearr_34625[(12)] = inst_34476);

(statearr_34625[(13)] = inst_34477);

return statearr_34625;
})();
var statearr_34626_34702 = state_34597__$1;
(statearr_34626_34702[(2)] = null);

(statearr_34626_34702[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (13))){
var inst_34437 = (state_34597[(10)]);
var inst_34440 = fluree.db.query.fql.full_select_spec.call(null,db,cache,base_select_spec,inst_34437);
var state_34597__$1 = state_34597;
var statearr_34627_34703 = state_34597__$1;
(statearr_34627_34703[(2)] = inst_34440);

(statearr_34627_34703[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (22))){
var inst_34443 = (state_34597[(7)]);
var inst_34463 = cljs.core.first.call(null,flakes);
var inst_34464 = fluree.db.query.fql.s.call(null,inst_34463);
var inst_34465 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs.call(null,inst_34443);
var inst_34466 = fluree.db.query.fql.resolve_reverse_refs.call(null,db,cache,fuel,max_fuel,inst_34464,inst_34465);
var state_34597__$1 = state_34597;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34597__$1,(25),inst_34466);
} else {
if((state_val_34598 === (36))){
var inst_34443 = (state_34597[(7)]);
var inst_34520 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_34443);
var state_34597__$1 = state_34597;
if(cljs.core.truth_(inst_34520)){
var statearr_34628_34704 = state_34597__$1;
(statearr_34628_34704[(1)] = (39));

} else {
var statearr_34629_34705 = state_34597__$1;
(statearr_34629_34705[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (41))){
var inst_34561 = (state_34597[(2)]);
var state_34597__$1 = state_34597;
var statearr_34630_34706 = state_34597__$1;
(statearr_34630_34706[(2)] = inst_34561);

(statearr_34630_34706[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (43))){
var inst_34443 = (state_34597[(7)]);
var inst_34535 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_34443);
var state_34597__$1 = state_34597;
var statearr_34631_34707 = state_34597__$1;
(statearr_34631_34707[(2)] = inst_34535);

(statearr_34631_34707[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (29))){
var inst_34443 = (state_34597[(7)]);
var inst_34476 = (state_34597[(12)]);
var inst_34486 = (state_34597[(15)]);
var inst_34492 = (state_34597[(18)]);
var inst_34486__$1 = cljs.core.first.call(null,inst_34476);
var inst_34487 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34488 = cljs.core.first.call(null,inst_34486__$1);
var inst_34489 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_34488);
var inst_34490 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_34489];
var inst_34491 = (new cljs.core.PersistentVector(null,3,(5),inst_34487,inst_34490,null));
var inst_34492__$1 = cljs.core.get_in.call(null,inst_34443,inst_34491);
var inst_34493 = fluree.db.query.fql.component_follow_QMARK_.call(null,inst_34492__$1,inst_34443);
var inst_34494 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_34492__$1);
var state_34597__$1 = (function (){var statearr_34632 = state_34597;
(statearr_34632[(14)] = inst_34493);

(statearr_34632[(15)] = inst_34486__$1);

(statearr_34632[(18)] = inst_34492__$1);

return statearr_34632;
})();
if(cljs.core.truth_(inst_34494)){
var statearr_34633_34708 = state_34597__$1;
(statearr_34633_34708[(1)] = (31));

} else {
var statearr_34634_34709 = state_34597__$1;
(statearr_34634_34709[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (44))){
var inst_34533 = (state_34597[(20)]);
var state_34597__$1 = state_34597;
var statearr_34635_34710 = state_34597__$1;
(statearr_34635_34710[(2)] = inst_34533);

(statearr_34635_34710[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (6))){
var state_34597__$1 = state_34597;
var statearr_34636_34711 = state_34597__$1;
(statearr_34636_34711[(2)] = null);

(statearr_34636_34711[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (28))){
var inst_34477 = (state_34597[(13)]);
var state_34597__$1 = state_34597;
var statearr_34637_34712 = state_34597__$1;
(statearr_34637_34712[(2)] = inst_34477);

(statearr_34637_34712[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (51))){
var inst_34557 = (state_34597[(2)]);
var state_34597__$1 = state_34597;
var statearr_34638_34713 = state_34597__$1;
(statearr_34638_34713[(2)] = inst_34557);

(statearr_34638_34713[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (25))){
var inst_34457 = (state_34597[(8)]);
var inst_34468 = (state_34597[(2)]);
var inst_34469 = fluree.db.util.async.throw_err.call(null,inst_34468);
var inst_34470 = cljs.core.merge.call(null,inst_34457,inst_34469);
var state_34597__$1 = state_34597;
var statearr_34639_34714 = state_34597__$1;
(statearr_34639_34714[(2)] = inst_34470);

(statearr_34639_34714[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (34))){
var inst_34478 = (state_34597[(11)]);
var inst_34476 = (state_34597[(12)]);
var inst_34496 = (state_34597[(19)]);
var inst_34499 = (state_34597[(2)]);
var inst_34500 = fluree.db.util.async.throw_err.call(null,inst_34499);
var inst_34501 = cljs.core.rest.call(null,inst_34476);
var inst_34502 = [inst_34500,inst_34501,inst_34478];
var inst_34503 = (new cljs.core.PersistentVector(null,3,(5),inst_34496,inst_34502,null));
var state_34597__$1 = state_34597;
var statearr_34640_34715 = state_34597__$1;
(statearr_34640_34715[(2)] = inst_34503);

(statearr_34640_34715[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (17))){
var inst_34443 = (state_34597[(7)]);
var inst_34447 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_34443);
var state_34597__$1 = state_34597;
var statearr_34642_34716 = state_34597__$1;
(statearr_34642_34716[(2)] = inst_34447);

(statearr_34642_34716[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (3))){
var inst_34595 = (state_34597[(2)]);
var state_34597__$1 = state_34597;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34597__$1,inst_34595);
} else {
if((state_val_34598 === (12))){
var _ = (function (){var statearr_34643 = state_34597;
(statearr_34643[(4)] = cljs.core.rest.call(null,(state_34597[(4)])));

return statearr_34643;
})();
var state_34597__$1 = state_34597;
var ex34641 = (state_34597__$1[(2)]);
var statearr_34644_34717 = state_34597__$1;
(statearr_34644_34717[(5)] = ex34641);


var statearr_34645_34718 = state_34597__$1;
(statearr_34645_34718[(1)] = (11));

(statearr_34645_34718[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (2))){
var _ = (function (){var statearr_34646 = state_34597;
(statearr_34646[(4)] = cljs.core.cons.call(null,(5),(state_34597[(4)])));

return statearr_34646;
})();
var inst_34423 = cljs.core.not_empty.call(null,flakes);
var state_34597__$1 = state_34597;
if(cljs.core.truth_(inst_34423)){
var statearr_34647_34719 = state_34597__$1;
(statearr_34647_34719[(1)] = (6));

} else {
var statearr_34648_34720 = state_34597__$1;
(statearr_34648_34720[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (23))){
var inst_34457 = (state_34597[(8)]);
var state_34597__$1 = state_34597;
var statearr_34649_34721 = state_34597__$1;
(statearr_34649_34721[(2)] = inst_34457);

(statearr_34649_34721[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (47))){
var state_34597__$1 = state_34597;
var statearr_34650_34722 = state_34597__$1;
(statearr_34650_34722[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (35))){
var inst_34493 = (state_34597[(14)]);
var inst_34478 = (state_34597[(11)]);
var inst_34477 = (state_34597[(13)]);
var inst_34486 = (state_34597[(15)]);
var inst_34492 = (state_34597[(18)]);
var inst_34509 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_34477,inst_34492,inst_34486,inst_34493,false,inst_34478);
var state_34597__$1 = state_34597;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34597__$1,(38),inst_34509);
} else {
if((state_val_34598 === (19))){
var inst_34437 = (state_34597[(10)]);
var inst_34451 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_34452 = [inst_34437];
var inst_34453 = cljs.core.PersistentHashMap.fromArrays(inst_34451,inst_34452);
var state_34597__$1 = state_34597;
var statearr_34652_34723 = state_34597__$1;
(statearr_34652_34723[(2)] = inst_34453);

(statearr_34652_34723[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (11))){
var inst_34425 = (state_34597[(2)]);
var inst_34426 = fluree.db.util.log.error.call(null,inst_34425);
var inst_34427 = (function(){throw inst_34425})();
var state_34597__$1 = (function (){var statearr_34654 = state_34597;
(statearr_34654[(21)] = inst_34426);

return statearr_34654;
})();
var statearr_34655_34724 = state_34597__$1;
(statearr_34655_34724[(2)] = inst_34427);

(statearr_34655_34724[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (9))){
var _ = (function (){var statearr_34656 = state_34597;
(statearr_34656[(4)] = cljs.core.cons.call(null,(12),(state_34597[(4)])));

return statearr_34656;
})();
var inst_34433 = cljs.core.first.call(null,flakes);
var inst_34434 = fluree.db.query.fql.s.call(null,inst_34433);
var ___$1 = (function (){var statearr_34657 = state_34597;
(statearr_34657[(4)] = cljs.core.rest.call(null,(state_34597[(4)])));

return statearr_34657;
})();
var state_34597__$1 = state_34597;
var statearr_34658_34725 = state_34597__$1;
(statearr_34658_34725[(2)] = inst_34434);

(statearr_34658_34725[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (5))){
var _ = (function (){var statearr_34659 = state_34597;
(statearr_34659[(4)] = cljs.core.rest.call(null,(state_34597[(4)])));

return statearr_34659;
})();
var state_34597__$1 = state_34597;
var ex34653 = (state_34597__$1[(2)]);
var statearr_34660_34726 = state_34597__$1;
(statearr_34660_34726[(5)] = ex34653);


if((ex34653 instanceof Error)){
var statearr_34661_34727 = state_34597__$1;
(statearr_34661_34727[(1)] = (4));

(statearr_34661_34727[(5)] = null);

} else {
throw ex34653;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (14))){
var state_34597__$1 = state_34597;
var statearr_34662_34728 = state_34597__$1;
(statearr_34662_34728[(2)] = base_select_spec);

(statearr_34662_34728[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (45))){
var inst_34538 = (state_34597[(2)]);
var state_34597__$1 = state_34597;
if(cljs.core.truth_(inst_34538)){
var statearr_34663_34729 = state_34597__$1;
(statearr_34663_34729[(1)] = (46));

} else {
var statearr_34664_34730 = state_34597__$1;
(statearr_34664_34730[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (26))){
var inst_34476 = (state_34597[(12)]);
var inst_34480 = cljs.core.empty_QMARK_.call(null,inst_34476);
var state_34597__$1 = state_34597;
if(inst_34480){
var statearr_34665_34731 = state_34597__$1;
(statearr_34665_34731[(1)] = (28));

} else {
var statearr_34666_34732 = state_34597__$1;
(statearr_34666_34732[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (16))){
var inst_34444 = (state_34597[(17)]);
var state_34597__$1 = state_34597;
var statearr_34667_34733 = state_34597__$1;
(statearr_34667_34733[(2)] = inst_34444);

(statearr_34667_34733[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (38))){
var inst_34476 = (state_34597[(12)]);
var inst_34511 = (state_34597[(2)]);
var inst_34512 = fluree.db.util.async.throw_err.call(null,inst_34511);
var inst_34513 = cljs.core.nth.call(null,inst_34512,(0),null);
var inst_34514 = cljs.core.nth.call(null,inst_34512,(1),null);
var inst_34515 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34516 = cljs.core.rest.call(null,inst_34476);
var inst_34517 = [inst_34513,inst_34516,inst_34514];
var inst_34518 = (new cljs.core.PersistentVector(null,3,(5),inst_34515,inst_34517,null));
var state_34597__$1 = state_34597;
var statearr_34668_34734 = state_34597__$1;
(statearr_34668_34734[(2)] = inst_34518);

(statearr_34668_34734[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (30))){
var inst_34574 = (state_34597[(2)]);
var state_34597__$1 = state_34597;
var statearr_34669_34735 = state_34597__$1;
(statearr_34669_34735[(2)] = inst_34574);

(statearr_34669_34735[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (10))){
var inst_34437 = (state_34597[(2)]);
var inst_34438 = fluree.db.query.fql.has_ns_lookups_QMARK_.call(null,base_select_spec);
var state_34597__$1 = (function (){var statearr_34670 = state_34597;
(statearr_34670[(10)] = inst_34437);

return statearr_34670;
})();
if(cljs.core.truth_(inst_34438)){
var statearr_34671_34736 = state_34597__$1;
(statearr_34671_34736[(1)] = (13));

} else {
var statearr_34672_34737 = state_34597__$1;
(statearr_34672_34737[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (18))){
var inst_34449 = (state_34597[(2)]);
var state_34597__$1 = state_34597;
if(cljs.core.truth_(inst_34449)){
var statearr_34673_34738 = state_34597__$1;
(statearr_34673_34738[(1)] = (19));

} else {
var statearr_34674_34739 = state_34597__$1;
(statearr_34674_34739[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (42))){
var inst_34478 = (state_34597[(11)]);
var inst_34476 = (state_34597[(12)]);
var inst_34522 = (state_34597[(16)]);
var inst_34525 = (state_34597[(2)]);
var inst_34526 = fluree.db.util.async.throw_err.call(null,inst_34525);
var inst_34527 = cljs.core.first.call(null,inst_34526);
var inst_34528 = cljs.core.rest.call(null,inst_34476);
var inst_34529 = [inst_34527,inst_34528,inst_34478];
var inst_34530 = (new cljs.core.PersistentVector(null,3,(5),inst_34522,inst_34529,null));
var state_34597__$1 = state_34597;
var statearr_34675_34740 = state_34597__$1;
(statearr_34675_34740[(2)] = inst_34530);

(statearr_34675_34740[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (37))){
var inst_34563 = (state_34597[(2)]);
var state_34597__$1 = state_34597;
var statearr_34676_34741 = state_34597__$1;
(statearr_34676_34741[(2)] = inst_34563);

(statearr_34676_34741[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (8))){
var inst_34592 = (state_34597[(2)]);
var _ = (function (){var statearr_34677 = state_34597;
(statearr_34677[(4)] = cljs.core.rest.call(null,(state_34597[(4)])));

return statearr_34677;
})();
var state_34597__$1 = state_34597;
var statearr_34678_34742 = state_34597__$1;
(statearr_34678_34742[(2)] = inst_34592);

(statearr_34678_34742[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34598 === (49))){
var inst_34478 = (state_34597[(11)]);
var inst_34476 = (state_34597[(12)]);
var inst_34477 = (state_34597[(13)]);
var inst_34551 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34552 = cljs.core.rest.call(null,inst_34476);
var inst_34553 = [inst_34477,inst_34552,inst_34478];
var inst_34554 = (new cljs.core.PersistentVector(null,3,(5),inst_34551,inst_34553,null));
var state_34597__$1 = state_34597;
var statearr_34679_34743 = state_34597__$1;
(statearr_34679_34743[(2)] = inst_34554);

(statearr_34679_34743[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__10945__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__10945__auto____0 = (function (){
var statearr_34680 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34680[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__10945__auto__);

(statearr_34680[(1)] = (1));

return statearr_34680;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__10945__auto____1 = (function (state_34597){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_34597);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e34681){var ex__10948__auto__ = e34681;
var statearr_34682_34744 = state_34597;
(statearr_34682_34744[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_34597[(4)]))){
var statearr_34683_34745 = state_34597;
(statearr_34683_34745[(1)] = cljs.core.first.call(null,(state_34597[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34746 = state_34597;
state_34597 = G__34746;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__10945__auto__ = function(state_34597){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__10945__auto____1.call(this,state_34597);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__10945__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__10945__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_34684 = f__11019__auto__.call(null);
(statearr_34684[(6)] = c__11018__auto__);

return statearr_34684;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__34749 = arguments.length;
switch (G__34749) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.call(null,db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.call(null,db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_34791){
var state_val_34792 = (state_34791[(1)]);
if((state_val_34792 === (7))){
var inst_34757 = (state_34791[(7)]);
var state_34791__$1 = state_34791;
var statearr_34793_34823 = state_34791__$1;
(statearr_34793_34823[(2)] = inst_34757);

(statearr_34793_34823[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34792 === (1))){
var state_34791__$1 = state_34791;
var statearr_34794_34824 = state_34791__$1;
(statearr_34794_34824[(2)] = null);

(statearr_34794_34824[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34792 === (4))){
var inst_34750 = (state_34791[(2)]);
var state_34791__$1 = state_34791;
var statearr_34795_34825 = state_34791__$1;
(statearr_34795_34825[(2)] = inst_34750);

(statearr_34795_34825[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34792 === (15))){
var inst_34785 = (state_34791[(2)]);
var inst_34786 = fluree.db.util.async.throw_err.call(null,inst_34785);
var _ = (function (){var statearr_34796 = state_34791;
(statearr_34796[(4)] = cljs.core.rest.call(null,(state_34791[(4)])));

return statearr_34796;
})();
var state_34791__$1 = state_34791;
var statearr_34797_34826 = state_34791__$1;
(statearr_34797_34826[(2)] = inst_34786);

(statearr_34797_34826[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34792 === (13))){
var inst_34769 = (state_34791[(8)]);
var state_34791__$1 = state_34791;
var statearr_34798_34827 = state_34791__$1;
(statearr_34798_34827[(2)] = inst_34769);

(statearr_34798_34827[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34792 === (6))){
var inst_34757 = (state_34791[(7)]);
var inst_34759 = fluree.db.query.fql.fuel_flakes_transducer.call(null,fuel,max_fuel);
var inst_34760 = cljs.core.comp.call(null,inst_34757,inst_34759);
var state_34791__$1 = state_34791;
var statearr_34799_34828 = state_34791__$1;
(statearr_34799_34828[(2)] = inst_34760);

(statearr_34799_34828[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34792 === (3))){
var inst_34789 = (state_34791[(2)]);
var state_34791__$1 = state_34791;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34791__$1,inst_34789);
} else {
if((state_val_34792 === (12))){
var inst_34769 = (state_34791[(8)]);
var inst_34771 = cljs.core.take.call(null,limit);
var inst_34772 = cljs.core.comp.call(null,inst_34769,inst_34771);
var state_34791__$1 = state_34791;
var statearr_34800_34829 = state_34791__$1;
(statearr_34800_34829[(2)] = inst_34772);

(statearr_34800_34829[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34792 === (2))){
var _ = (function (){var statearr_34801 = state_34791;
(statearr_34801[(4)] = cljs.core.cons.call(null,(5),(state_34791[(4)])));

return statearr_34801;
})();
var inst_34757 = cljs.core.partition_by.call(null,fluree.db.query.fql.s);
var state_34791__$1 = (function (){var statearr_34802 = state_34791;
(statearr_34802[(7)] = inst_34757);

return statearr_34802;
})();
if(cljs.core.truth_(fuel)){
var statearr_34803_34830 = state_34791__$1;
(statearr_34803_34830[(1)] = (6));

} else {
var statearr_34804_34831 = state_34791__$1;
(statearr_34804_34831[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34792 === (11))){
var inst_34769 = (state_34791[(2)]);
var state_34791__$1 = (function (){var statearr_34806 = state_34791;
(statearr_34806[(8)] = inst_34769);

return statearr_34806;
})();
if(cljs.core.truth_(limit)){
var statearr_34807_34832 = state_34791__$1;
(statearr_34807_34832[(1)] = (12));

} else {
var statearr_34808_34833 = state_34791__$1;
(statearr_34808_34833[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34792 === (9))){
var inst_34763 = (state_34791[(9)]);
var inst_34765 = cljs.core.drop.call(null,offset);
var inst_34766 = cljs.core.comp.call(null,inst_34763,inst_34765);
var state_34791__$1 = state_34791;
var statearr_34809_34834 = state_34791__$1;
(statearr_34809_34834[(2)] = inst_34766);

(statearr_34809_34834[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34792 === (5))){
var _ = (function (){var statearr_34810 = state_34791;
(statearr_34810[(4)] = cljs.core.rest.call(null,(state_34791[(4)])));

return statearr_34810;
})();
var state_34791__$1 = state_34791;
var ex34805 = (state_34791__$1[(2)]);
var statearr_34811_34835 = state_34791__$1;
(statearr_34811_34835[(5)] = ex34805);


if((ex34805 instanceof Error)){
var statearr_34812_34836 = state_34791__$1;
(statearr_34812_34836[(1)] = (4));

(statearr_34812_34836[(5)] = null);

} else {
throw ex34805;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34792 === (14))){
var inst_34775 = (state_34791[(2)]);
var inst_34776 = (function (){return (function (x){
var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref.call(null,fuel) >= max_fuel);
} else {
return and__5043__auto__;
}
});
})();
var inst_34777 = cljs.core.halt_when.call(null,inst_34776);
var inst_34778 = cljs.core.comp.call(null,inst_34775,inst_34777);
var inst_34779 = cljs.core.sequence.call(null,inst_34778,flakes);
var inst_34780 = cljs.core.PersistentVector.EMPTY;
var inst_34781 = (function (){var xf = inst_34778;
var flakes_by_sub = inst_34779;
return (function (p1__34747_SHARP_){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,select_spec,p1__34747_SHARP_);
});
})();
var inst_34782 = cljs.core.map.call(null,inst_34781,inst_34779);
var inst_34783 = fluree.db.util.async.merge_into_QMARK_.call(null,inst_34780,inst_34782);
var state_34791__$1 = state_34791;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34791__$1,(15),inst_34783);
} else {
if((state_val_34792 === (10))){
var inst_34763 = (state_34791[(9)]);
var state_34791__$1 = state_34791;
var statearr_34813_34837 = state_34791__$1;
(statearr_34813_34837[(2)] = inst_34763);

(statearr_34813_34837[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34792 === (8))){
var inst_34763 = (state_34791[(2)]);
var state_34791__$1 = (function (){var statearr_34814 = state_34791;
(statearr_34814[(9)] = inst_34763);

return statearr_34814;
})();
if(cljs.core.truth_(offset)){
var statearr_34815_34838 = state_34791__$1;
(statearr_34815_34838[(1)] = (9));

} else {
var statearr_34816_34839 = state_34791__$1;
(statearr_34816_34839[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__10945__auto__ = null;
var fluree$db$query$fql$state_machine__10945__auto____0 = (function (){
var statearr_34817 = [null,null,null,null,null,null,null,null,null,null];
(statearr_34817[(0)] = fluree$db$query$fql$state_machine__10945__auto__);

(statearr_34817[(1)] = (1));

return statearr_34817;
});
var fluree$db$query$fql$state_machine__10945__auto____1 = (function (state_34791){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_34791);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e34818){var ex__10948__auto__ = e34818;
var statearr_34819_34840 = state_34791;
(statearr_34819_34840[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_34791[(4)]))){
var statearr_34820_34841 = state_34791;
(statearr_34820_34841[(1)] = cljs.core.first.call(null,(state_34791[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34842 = state_34791;
state_34791 = G__34842;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__10945__auto__ = function(state_34791){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__10945__auto____1.call(this,state_34791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__10945__auto____0;
fluree$db$query$fql$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__10945__auto____1;
return fluree$db$query$fql$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_34821 = f__11019__auto__.call(null);
(statearr_34821[(6)] = c__11018__auto__);

return statearr_34821;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__34844 = arguments.length;
switch (G__34844) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.call(null,db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.call(null,db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_34930){
var state_val_34931 = (state_34930[(1)]);
if((state_val_34931 === (7))){
var inst_34925 = (state_34930[(2)]);
var _ = (function (){var statearr_34933 = state_34930;
(statearr_34933[(4)] = cljs.core.rest.call(null,(state_34930[(4)])));

return statearr_34933;
})();
var state_34930__$1 = state_34930;
var statearr_34934_34986 = state_34930__$1;
(statearr_34934_34986[(2)] = inst_34925);

(statearr_34934_34986[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34931 === (20))){
var inst_34865 = (state_34930[(7)]);
var inst_34872 = (state_34930[(8)]);
var inst_34864 = (state_34930[(9)]);
var inst_34893 = (inst_34864 + (1));
var tmp34932 = inst_34865;
var inst_34863 = inst_34872;
var inst_34864__$1 = inst_34893;
var inst_34865__$1 = tmp34932;
var state_34930__$1 = (function (){var statearr_34935 = state_34930;
(statearr_34935[(10)] = inst_34863);

(statearr_34935[(7)] = inst_34865__$1);

(statearr_34935[(9)] = inst_34864__$1);

return statearr_34935;
})();
var statearr_34936_34987 = state_34930__$1;
(statearr_34936_34987[(2)] = null);

(statearr_34936_34987[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34931 === (27))){
var inst_34903 = (state_34930[(11)]);
var inst_34905 = cljs.core.count.call(null,inst_34903);
var inst_34906 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_34905);
var state_34930__$1 = state_34930;
var statearr_34937_34988 = state_34930__$1;
(statearr_34937_34988[(2)] = inst_34906);

(statearr_34937_34988[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34931 === (1))){
var state_34930__$1 = state_34930;
var statearr_34938_34989 = state_34930__$1;
(statearr_34938_34989[(2)] = null);

(statearr_34938_34989[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34931 === (24))){
var state_34930__$1 = state_34930;
var statearr_34939_34990 = state_34930__$1;
(statearr_34939_34990[(2)] = null);

(statearr_34939_34990[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34931 === (4))){
var inst_34845 = (state_34930[(2)]);
var state_34930__$1 = state_34930;
var statearr_34940_34991 = state_34930__$1;
(statearr_34940_34991[(2)] = inst_34845);

(statearr_34940_34991[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34931 === (15))){
var inst_34886 = (state_34930[(12)]);
var inst_34886__$1 = offset;
var state_34930__$1 = (function (){var statearr_34941 = state_34930;
(statearr_34941[(12)] = inst_34886__$1);

return statearr_34941;
})();
if(cljs.core.truth_(inst_34886__$1)){
var statearr_34942_34992 = state_34930__$1;
(statearr_34942_34992[(1)] = (17));

} else {
var statearr_34943_34993 = state_34930__$1;
(statearr_34943_34993[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34931 === (21))){
var state_34930__$1 = state_34930;
var statearr_34944_34994 = state_34930__$1;
(statearr_34944_34994[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34931 === (13))){
var inst_34881 = (state_34930[(2)]);
var state_34930__$1 = state_34930;
var statearr_34946_34995 = state_34930__$1;
(statearr_34946_34995[(2)] = inst_34881);

(statearr_34946_34995[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34931 === (22))){
var inst_34921 = (state_34930[(2)]);
var state_34930__$1 = state_34930;
var statearr_34947_34996 = state_34930__$1;
(statearr_34947_34996[(2)] = inst_34921);

(statearr_34947_34996[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34931 === (29))){
var inst_34864 = (state_34930[(9)]);
var inst_34903 = (state_34930[(11)]);
var inst_34909 = (state_34930[(2)]);
var inst_34910 = (inst_34864 + (1));
var inst_34911 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,select_spec,inst_34903);
var state_34930__$1 = (function (){var statearr_34948 = state_34930;
(statearr_34948[(13)] = inst_34910);

(statearr_34948[(14)] = inst_34909);

return statearr_34948;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34930__$1,(30),inst_34911);
} else {
if((state_val_34931 === (6))){
var inst_34863 = (state_34930[(10)]);
var inst_34873 = (state_34930[(15)]);
var inst_34871 = (state_34930[(16)]);
var inst_34870 = cljs.core.seq.call(null,inst_34863);
var inst_34871__$1 = cljs.core.first.call(null,inst_34870);
var inst_34872 = cljs.core.next.call(null,inst_34870);
var inst_34873__$1 = (inst_34871__$1 == null);
var state_34930__$1 = (function (){var statearr_34949 = state_34930;
(statearr_34949[(15)] = inst_34873__$1);

(statearr_34949[(16)] = inst_34871__$1);

(statearr_34949[(8)] = inst_34872);

return statearr_34949;
})();
if(cljs.core.truth_(inst_34873__$1)){
var statearr_34950_34997 = state_34930__$1;
(statearr_34950_34997[(1)] = (8));

} else {
var statearr_34951_34998 = state_34930__$1;
(statearr_34951_34998[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34931 === (28))){
var state_34930__$1 = state_34930;
var statearr_34952_34999 = state_34930__$1;
(statearr_34952_34999[(2)] = null);

(statearr_34952_34999[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34931 === (25))){
var inst_34919 = (state_34930[(2)]);
var state_34930__$1 = state_34930;
var statearr_34953_35000 = state_34930__$1;
(statearr_34953_35000[(2)] = inst_34919);

(statearr_34953_35000[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34931 === (17))){
var inst_34864 = (state_34930[(9)]);
var inst_34888 = (inst_34864 < offset);
var state_34930__$1 = state_34930;
var statearr_34954_35001 = state_34930__$1;
(statearr_34954_35001[(2)] = inst_34888);

(statearr_34954_35001[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34931 === (3))){
var inst_34928 = (state_34930[(2)]);
var state_34930__$1 = state_34930;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34930__$1,inst_34928);
} else {
if((state_val_34931 === (12))){
var inst_34876 = (state_34930[(17)]);
var state_34930__$1 = state_34930;
var statearr_34955_35002 = state_34930__$1;
(statearr_34955_35002[(2)] = inst_34876);

(statearr_34955_35002[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34931 === (2))){
var _ = (function (){var statearr_34956 = state_34930;
(statearr_34956[(4)] = cljs.core.cons.call(null,(5),(state_34930[(4)])));

return statearr_34956;
})();
var inst_34858 = subjects;
var inst_34859 = cljs.core.seq.call(null,inst_34858);
var inst_34860 = cljs.core.first.call(null,inst_34859);
var inst_34861 = cljs.core.next.call(null,inst_34859);
var inst_34862 = cljs.core.PersistentVector.EMPTY;
var inst_34863 = inst_34858;
var inst_34864 = (0);
var inst_34865 = inst_34862;
var state_34930__$1 = (function (){var statearr_34957 = state_34930;
(statearr_34957[(10)] = inst_34863);

(statearr_34957[(7)] = inst_34865);

(statearr_34957[(9)] = inst_34864);

(statearr_34957[(18)] = inst_34861);

(statearr_34957[(19)] = inst_34860);

return statearr_34957;
})();
var statearr_34958_35003 = state_34930__$1;
(statearr_34958_35003[(2)] = null);

(statearr_34958_35003[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34931 === (23))){
var inst_34871 = (state_34930[(16)]);
var inst_34897 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34898 = [inst_34871];
var inst_34899 = (new cljs.core.PersistentVector(null,1,(5),inst_34897,inst_34898,null));
var inst_34900 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_34899);
var state_34930__$1 = state_34930;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34930__$1,(26),inst_34900);
} else {
if((state_val_34931 === (19))){
var inst_34891 = (state_34930[(2)]);
var state_34930__$1 = state_34930;
if(cljs.core.truth_(inst_34891)){
var statearr_34959_35004 = state_34930__$1;
(statearr_34959_35004[(1)] = (20));

} else {
var statearr_34960_35005 = state_34930__$1;
(statearr_34960_35005[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34931 === (11))){
var inst_34864 = (state_34930[(9)]);
var inst_34878 = (inst_34864 > limit);
var state_34930__$1 = state_34930;
var statearr_34962_35006 = state_34930__$1;
(statearr_34962_35006[(2)] = inst_34878);

(statearr_34962_35006[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34931 === (9))){
var inst_34876 = (state_34930[(17)]);
var inst_34876__$1 = limit;
var state_34930__$1 = (function (){var statearr_34963 = state_34930;
(statearr_34963[(17)] = inst_34876__$1);

return statearr_34963;
})();
if(cljs.core.truth_(inst_34876__$1)){
var statearr_34964_35007 = state_34930__$1;
(statearr_34964_35007[(1)] = (11));

} else {
var statearr_34965_35008 = state_34930__$1;
(statearr_34965_35008[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34931 === (5))){
var _ = (function (){var statearr_34966 = state_34930;
(statearr_34966[(4)] = cljs.core.rest.call(null,(state_34930[(4)])));

return statearr_34966;
})();
var state_34930__$1 = state_34930;
var ex34961 = (state_34930__$1[(2)]);
var statearr_34967_35009 = state_34930__$1;
(statearr_34967_35009[(5)] = ex34961);


if((ex34961 instanceof Error)){
var statearr_34968_35010 = state_34930__$1;
(statearr_34968_35010[(1)] = (4));

(statearr_34968_35010[(5)] = null);

} else {
throw ex34961;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34931 === (14))){
var inst_34865 = (state_34930[(7)]);
var state_34930__$1 = state_34930;
var statearr_34969_35011 = state_34930__$1;
(statearr_34969_35011[(2)] = inst_34865);

(statearr_34969_35011[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34931 === (26))){
var inst_34902 = (state_34930[(2)]);
var inst_34903 = fluree.db.util.async.throw_err.call(null,inst_34902);
var state_34930__$1 = (function (){var statearr_34970 = state_34930;
(statearr_34970[(11)] = inst_34903);

return statearr_34970;
})();
if(cljs.core.truth_(fuel)){
var statearr_34971_35012 = state_34930__$1;
(statearr_34971_35012[(1)] = (27));

} else {
var statearr_34972_35013 = state_34930__$1;
(statearr_34972_35013[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34931 === (16))){
var inst_34923 = (state_34930[(2)]);
var state_34930__$1 = state_34930;
var statearr_34973_35014 = state_34930__$1;
(statearr_34973_35014[(2)] = inst_34923);

(statearr_34973_35014[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34931 === (30))){
var inst_34865 = (state_34930[(7)]);
var inst_34872 = (state_34930[(8)]);
var inst_34910 = (state_34930[(13)]);
var inst_34913 = (state_34930[(2)]);
var inst_34914 = fluree.db.util.async.throw_err.call(null,inst_34913);
var inst_34915 = cljs.core.conj.call(null,inst_34865,inst_34914);
var inst_34863 = inst_34872;
var inst_34864 = inst_34910;
var inst_34865__$1 = inst_34915;
var state_34930__$1 = (function (){var statearr_34974 = state_34930;
(statearr_34974[(10)] = inst_34863);

(statearr_34974[(7)] = inst_34865__$1);

(statearr_34974[(9)] = inst_34864);

return statearr_34974;
})();
var statearr_34975_35015 = state_34930__$1;
(statearr_34975_35015[(2)] = null);

(statearr_34975_35015[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34931 === (10))){
var inst_34883 = (state_34930[(2)]);
var state_34930__$1 = state_34930;
if(cljs.core.truth_(inst_34883)){
var statearr_34976_35016 = state_34930__$1;
(statearr_34976_35016[(1)] = (14));

} else {
var statearr_34977_35017 = state_34930__$1;
(statearr_34977_35017[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34931 === (18))){
var inst_34886 = (state_34930[(12)]);
var state_34930__$1 = state_34930;
var statearr_34978_35018 = state_34930__$1;
(statearr_34978_35018[(2)] = inst_34886);

(statearr_34978_35018[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34931 === (8))){
var inst_34873 = (state_34930[(15)]);
var state_34930__$1 = state_34930;
var statearr_34979_35019 = state_34930__$1;
(statearr_34979_35019[(2)] = inst_34873);

(statearr_34979_35019[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__10945__auto__ = null;
var fluree$db$query$fql$state_machine__10945__auto____0 = (function (){
var statearr_34980 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34980[(0)] = fluree$db$query$fql$state_machine__10945__auto__);

(statearr_34980[(1)] = (1));

return statearr_34980;
});
var fluree$db$query$fql$state_machine__10945__auto____1 = (function (state_34930){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_34930);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e34981){var ex__10948__auto__ = e34981;
var statearr_34982_35020 = state_34930;
(statearr_34982_35020[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_34930[(4)]))){
var statearr_34983_35021 = state_34930;
(statearr_34983_35021[(1)] = cljs.core.first.call(null,(state_34930[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35022 = state_34930;
state_34930 = G__35022;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__10945__auto__ = function(state_34930){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__10945__auto____1.call(this,state_34930);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__10945__auto____0;
fluree$db$query$fql$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__10945__auto____1;
return fluree$db$query$fql$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_34984 = f__11019__auto__.call(null);
(statearr_34984[(6)] = c__11018__auto__);

return statearr_34984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__5045__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__35024 = arguments.length;
switch (G__35024) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.call(null,db,where_clause,null,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4 = (function (db,where_clause,default_collection,p__35025){
var map__35026 = p__35025;
var map__35026__$1 = cljs.core.__destructure_map.call(null,map__35026);
var limit = cljs.core.get.call(null,map__35026__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__35026__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_35290){
var state_val_35291 = (state_35290[(1)]);
if((state_val_35291 === (65))){
var inst_35253 = (state_35290[(7)]);
var inst_35253__$1 = (state_35290[(2)]);
var state_35290__$1 = (function (){var statearr_35292 = state_35290;
(statearr_35292[(7)] = inst_35253__$1);

return statearr_35292;
})();
if(cljs.core.truth_(inst_35253__$1)){
var statearr_35293_35411 = state_35290__$1;
(statearr_35293_35411[(1)] = (66));

} else {
var statearr_35294_35412 = state_35290__$1;
(statearr_35294_35412[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (70))){
var inst_35256 = (state_35290[(8)]);
var state_35290__$1 = state_35290;
var statearr_35295_35413 = state_35290__$1;
(statearr_35295_35413[(2)] = inst_35256);

(statearr_35295_35413[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (62))){
var inst_35244 = (state_35290[(2)]);
var state_35290__$1 = state_35290;
var statearr_35296_35414 = state_35290__$1;
(statearr_35296_35414[(2)] = inst_35244);

(statearr_35296_35414[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (74))){
var inst_35263 = (state_35290[(2)]);
var state_35290__$1 = state_35290;
var statearr_35297_35415 = state_35290__$1;
(statearr_35297_35415[(2)] = inst_35263);

(statearr_35297_35415[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (7))){
var inst_35039 = (state_35290[(9)]);
var state_35290__$1 = state_35290;
var statearr_35298_35416 = state_35290__$1;
(statearr_35298_35416[(2)] = inst_35039);

(statearr_35298_35416[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (59))){
var inst_35068 = (state_35290[(10)]);
var inst_35236 = cljs.core.empty_QMARK_.call(null,inst_35068);
var state_35290__$1 = state_35290;
if(inst_35236){
var statearr_35299_35417 = state_35290__$1;
(statearr_35299_35417[(1)] = (60));

} else {
var statearr_35300_35418 = state_35290__$1;
(statearr_35300_35418[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (20))){
var state_35290__$1 = state_35290;
if(cljs.core.truth_(offset)){
var statearr_35301_35419 = state_35290__$1;
(statearr_35301_35419[(1)] = (23));

} else {
var statearr_35302_35420 = state_35290__$1;
(statearr_35302_35420[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (72))){
var inst_35233 = (state_35290[(11)]);
var inst_35053 = (state_35290[(12)]);
var inst_35259 = cljs.core.count.call(null,inst_35233);
var inst_35260 = (inst_35259 > inst_35053);
var state_35290__$1 = state_35290;
var statearr_35303_35421 = state_35290__$1;
(statearr_35303_35421[(2)] = inst_35260);

(statearr_35303_35421[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (58))){
var inst_35233 = (state_35290[(11)]);
var inst_35068 = (state_35290[(10)]);
var inst_35234 = cljs.core.into.call(null,inst_35068,inst_35233);
var state_35290__$1 = state_35290;
var statearr_35304_35422 = state_35290__$1;
(statearr_35304_35422[(2)] = inst_35234);

(statearr_35304_35422[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (60))){
var inst_35233 = (state_35290[(11)]);
var inst_35068 = (state_35290[(10)]);
var inst_35238 = cljs.core.into.call(null,inst_35068,inst_35233);
var state_35290__$1 = state_35290;
var statearr_35305_35423 = state_35290__$1;
(statearr_35305_35423[(2)] = inst_35238);

(statearr_35305_35423[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (27))){
var inst_35083 = (state_35290[(13)]);
var state_35290__$1 = state_35290;
var statearr_35306_35424 = state_35290__$1;
(statearr_35306_35424[(2)] = inst_35083);

(statearr_35306_35424[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (1))){
var state_35290__$1 = state_35290;
var statearr_35307_35425 = state_35290__$1;
(statearr_35307_35425[(2)] = null);

(statearr_35307_35425[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (69))){
var inst_35053 = (state_35290[(12)]);
var state_35290__$1 = state_35290;
if(cljs.core.truth_(inst_35053)){
var statearr_35308_35426 = state_35290__$1;
(statearr_35308_35426[(1)] = (72));

} else {
var statearr_35309_35427 = state_35290__$1;
(statearr_35309_35427[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (24))){
var inst_35068 = (state_35290[(10)]);
var state_35290__$1 = state_35290;
var statearr_35310_35428 = state_35290__$1;
(statearr_35310_35428[(2)] = inst_35068);

(statearr_35310_35428[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (55))){
var inst_35222 = (state_35290[(2)]);
var state_35290__$1 = state_35290;
var statearr_35311_35429 = state_35290__$1;
(statearr_35311_35429[(2)] = inst_35222);

(statearr_35311_35429[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (39))){
var inst_35230 = (state_35290[(2)]);
var state_35290__$1 = state_35290;
var statearr_35312_35430 = state_35290__$1;
(statearr_35312_35430[(2)] = inst_35230);

(statearr_35312_35430[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (46))){
var inst_35112 = (state_35290[(14)]);
var inst_35094 = (state_35290[(15)]);
var inst_35188 = inst_35112.call(null,cljs.core._LT_,inst_35094);
var state_35290__$1 = state_35290;
if(cljs.core.truth_(inst_35188)){
var statearr_35313_35431 = state_35290__$1;
(statearr_35313_35431[(1)] = (49));

} else {
var statearr_35314_35432 = state_35290__$1;
(statearr_35314_35432[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (4))){
var inst_35027 = (state_35290[(2)]);
var state_35290__$1 = state_35290;
var statearr_35315_35433 = state_35290__$1;
(statearr_35315_35433[(2)] = inst_35027);

(statearr_35315_35433[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (77))){
var inst_35278 = (state_35290[(2)]);
var state_35290__$1 = state_35290;
var statearr_35316_35434 = state_35290__$1;
(statearr_35316_35434[(2)] = inst_35278);

(statearr_35316_35434[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (54))){
var inst_35220 = cljs.core.PersistentVector.EMPTY;
var state_35290__$1 = state_35290;
var statearr_35317_35435 = state_35290__$1;
(statearr_35317_35435[(2)] = inst_35220);

(statearr_35317_35435[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (15))){
var inst_35038 = (state_35290[(16)]);
var inst_35063 = cljs.core.seq.call(null,inst_35038);
var inst_35064 = cljs.core.first.call(null,inst_35063);
var inst_35065 = cljs.core.next.call(null,inst_35063);
var inst_35066 = cljs.core.PersistentHashSet.EMPTY;
var inst_35067 = inst_35038;
var inst_35068 = inst_35066;
var state_35290__$1 = (function (){var statearr_35318 = state_35290;
(statearr_35318[(17)] = inst_35064);

(statearr_35318[(18)] = inst_35067);

(statearr_35318[(10)] = inst_35068);

(statearr_35318[(19)] = inst_35065);

return statearr_35318;
})();
var statearr_35319_35436 = state_35290__$1;
(statearr_35319_35436[(2)] = null);

(statearr_35319_35436[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (48))){
var inst_35185 = (state_35290[(2)]);
var inst_35186 = fluree.db.util.async.throw_err.call(null,inst_35185);
var state_35290__$1 = state_35290;
var statearr_35320_35437 = state_35290__$1;
(statearr_35320_35437[(2)] = inst_35186);

(statearr_35320_35437[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (50))){
var inst_35112 = (state_35290[(14)]);
var inst_35094 = (state_35290[(15)]);
var inst_35204 = inst_35112.call(null,cljs.core._LT__EQ_,inst_35094);
var state_35290__$1 = state_35290;
if(cljs.core.truth_(inst_35204)){
var statearr_35321_35438 = state_35290__$1;
(statearr_35321_35438[(1)] = (53));

} else {
var statearr_35322_35439 = state_35290__$1;
(statearr_35322_35439[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (75))){
var state_35290__$1 = state_35290;
if(cljs.core.truth_(offset)){
var statearr_35323_35440 = state_35290__$1;
(statearr_35323_35440[(1)] = (78));

} else {
var statearr_35324_35441 = state_35290__$1;
(statearr_35324_35441[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (21))){
var inst_35074 = (state_35290[(20)]);
var inst_35093 = (state_35290[(21)]);
var inst_35093__$1 = cljs.core.nth.call(null,inst_35074,(0),null);
var inst_35094 = cljs.core.nth.call(null,inst_35074,(1),null);
var inst_35095 = cljs.core.nth.call(null,inst_35074,(2),null);
var inst_35096 = fluree.db.query.fql.valid_where_predicate_QMARK_.call(null,db,inst_35093__$1);
var inst_35097 = cljs.core.not.call(null,inst_35096);
var state_35290__$1 = (function (){var statearr_35325 = state_35290;
(statearr_35325[(22)] = inst_35095);

(statearr_35325[(21)] = inst_35093__$1);

(statearr_35325[(15)] = inst_35094);

return statearr_35325;
})();
if(inst_35097){
var statearr_35326_35442 = state_35290__$1;
(statearr_35326_35442[(1)] = (29));

} else {
var statearr_35327_35443 = state_35290__$1;
(statearr_35327_35443[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (31))){
var inst_35112 = (state_35290[(14)]);
var inst_35094 = (state_35290[(15)]);
var inst_35108 = (state_35290[(2)]);
var inst_35112__$1 = cljs.core.identical_QMARK_;
var inst_35113 = inst_35112__$1.call(null,cljs.core.not_EQ_,inst_35094);
var state_35290__$1 = (function (){var statearr_35328 = state_35290;
(statearr_35328[(23)] = inst_35108);

(statearr_35328[(14)] = inst_35112__$1);

return statearr_35328;
})();
if(cljs.core.truth_(inst_35113)){
var statearr_35329_35444 = state_35290__$1;
(statearr_35329_35444[(1)] = (32));

} else {
var statearr_35330_35445 = state_35290__$1;
(statearr_35330_35445[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (32))){
var inst_35095 = (state_35290[(22)]);
var inst_35093 = (state_35290[(21)]);
var inst_35053 = (state_35290[(12)]);
var inst_35115 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35116 = [inst_35093,inst_35095];
var inst_35117 = (new cljs.core.PersistentVector(null,2,(5),inst_35115,inst_35116,null));
var inst_35118 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35119 = [inst_35093];
var inst_35120 = (new cljs.core.PersistentVector(null,1,(5),inst_35118,inst_35119,null));
var inst_35121 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_35122 = [inst_35053];
var inst_35123 = cljs.core.PersistentHashMap.fromArrays(inst_35121,inst_35122);
var inst_35124 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_35117,cljs.core._LT__EQ_,inst_35120,inst_35123);
var state_35290__$1 = state_35290;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35290__$1,(35),inst_35124);
} else {
if((state_val_35291 === (40))){
var inst_35153 = (state_35290[(2)]);
var inst_35154 = fluree.db.util.async.throw_err.call(null,inst_35153);
var state_35290__$1 = state_35290;
var statearr_35331_35446 = state_35290__$1;
(statearr_35331_35446[(2)] = inst_35154);

(statearr_35331_35446[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (56))){
var inst_35217 = (state_35290[(2)]);
var inst_35218 = fluree.db.util.async.throw_err.call(null,inst_35217);
var state_35290__$1 = state_35290;
var statearr_35332_35447 = state_35290__$1;
(statearr_35332_35447[(2)] = inst_35218);

(statearr_35332_35447[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (33))){
var inst_35112 = (state_35290[(14)]);
var inst_35094 = (state_35290[(15)]);
var inst_35143 = inst_35112.call(null,cljs.core._EQ_,inst_35094);
var state_35290__$1 = state_35290;
if(cljs.core.truth_(inst_35143)){
var statearr_35333_35448 = state_35290__$1;
(statearr_35333_35448[(1)] = (37));

} else {
var statearr_35334_35449 = state_35290__$1;
(statearr_35334_35449[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (13))){
var state_35290__$1 = state_35290;
var statearr_35335_35450 = state_35290__$1;
(statearr_35335_35450[(2)] = limit);

(statearr_35335_35450[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (22))){
var inst_35280 = (state_35290[(2)]);
var state_35290__$1 = state_35290;
var statearr_35336_35451 = state_35290__$1;
(statearr_35336_35451[(2)] = inst_35280);

(statearr_35336_35451[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (36))){
var inst_35127 = (state_35290[(24)]);
var inst_35139 = (state_35290[(2)]);
var inst_35140 = fluree.db.util.async.throw_err.call(null,inst_35139);
var inst_35141 = cljs.core.concat.call(null,inst_35127,inst_35140);
var state_35290__$1 = state_35290;
var statearr_35337_35452 = state_35290__$1;
(statearr_35337_35452[(2)] = inst_35141);

(statearr_35337_35452[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (41))){
var inst_35095 = (state_35290[(22)]);
var inst_35093 = (state_35290[(21)]);
var inst_35053 = (state_35290[(12)]);
var inst_35158 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35159 = [inst_35093,inst_35095];
var inst_35160 = (new cljs.core.PersistentVector(null,2,(5),inst_35158,inst_35159,null));
var inst_35161 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35162 = [inst_35093];
var inst_35163 = (new cljs.core.PersistentVector(null,1,(5),inst_35161,inst_35162,null));
var inst_35164 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_35165 = [inst_35053];
var inst_35166 = cljs.core.PersistentHashMap.fromArrays(inst_35164,inst_35165);
var inst_35167 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_35160,cljs.core._LT__EQ_,inst_35163,inst_35166);
var state_35290__$1 = state_35290;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35290__$1,(44),inst_35167);
} else {
if((state_val_35291 === (43))){
var inst_35228 = (state_35290[(2)]);
var state_35290__$1 = state_35290;
var statearr_35338_35453 = state_35290__$1;
(statearr_35338_35453[(2)] = inst_35228);

(statearr_35338_35453[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (61))){
var inst_35233 = (state_35290[(11)]);
var inst_35068 = (state_35290[(10)]);
var inst_35240 = cljs.core.PersistentHashSet.EMPTY;
var inst_35241 = cljs.core.into.call(null,inst_35240,inst_35233);
var inst_35242 = clojure.set.intersection.call(null,inst_35068,inst_35241);
var state_35290__$1 = state_35290;
var statearr_35339_35454 = state_35290__$1;
(statearr_35339_35454[(2)] = inst_35242);

(statearr_35339_35454[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (29))){
var inst_35093 = (state_35290[(21)]);
var inst_35099 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_35093);
var inst_35100 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35099)].join('');
var inst_35101 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_35102 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_35103 = cljs.core.PersistentHashMap.fromArrays(inst_35101,inst_35102);
var inst_35104 = cljs.core.ex_info.call(null,inst_35100,inst_35103);
var inst_35105 = (function(){throw inst_35104})();
var state_35290__$1 = state_35290;
var statearr_35340_35455 = state_35290__$1;
(statearr_35340_35455[(2)] = inst_35105);

(statearr_35340_35455[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (44))){
var inst_35169 = (state_35290[(2)]);
var inst_35170 = fluree.db.util.async.throw_err.call(null,inst_35169);
var state_35290__$1 = state_35290;
var statearr_35341_35456 = state_35290__$1;
(statearr_35341_35456[(2)] = inst_35170);

(statearr_35341_35456[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (6))){
var inst_35037 = (state_35290[(25)]);
var inst_35041 = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_35037);
var state_35290__$1 = state_35290;
var statearr_35342_35457 = state_35290__$1;
(statearr_35342_35457[(2)] = inst_35041);

(statearr_35342_35457[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (28))){
var inst_35088 = (state_35290[(2)]);
var state_35290__$1 = state_35290;
var statearr_35343_35458 = state_35290__$1;
(statearr_35343_35458[(2)] = inst_35088);

(statearr_35343_35458[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (64))){
var inst_35248 = (state_35290[(26)]);
var state_35290__$1 = state_35290;
var statearr_35344_35459 = state_35290__$1;
(statearr_35344_35459[(2)] = inst_35248);

(statearr_35344_35459[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (51))){
var inst_35224 = (state_35290[(2)]);
var state_35290__$1 = state_35290;
var statearr_35345_35460 = state_35290__$1;
(statearr_35345_35460[(2)] = inst_35224);

(statearr_35345_35460[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (25))){
var inst_35083 = (state_35290[(2)]);
var state_35290__$1 = (function (){var statearr_35346 = state_35290;
(statearr_35346[(13)] = inst_35083);

return statearr_35346;
})();
if(cljs.core.truth_(limit)){
var statearr_35347_35461 = state_35290__$1;
(statearr_35347_35461[(1)] = (26));

} else {
var statearr_35348_35462 = state_35290__$1;
(statearr_35348_35462[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (34))){
var inst_35037 = (state_35290[(25)]);
var inst_35232 = (state_35290[(2)]);
var inst_35233 = cljs.core.map.call(null,fluree.db.query.fql.s,inst_35232);
var state_35290__$1 = (function (){var statearr_35349 = state_35290;
(statearr_35349[(11)] = inst_35233);

return statearr_35349;
})();
var G__35350_35463 = inst_35037;
var G__35350_35464__$1 = (((G__35350_35463 instanceof cljs.core.Keyword))?G__35350_35463.fqn:null);
switch (G__35350_35464__$1) {
case "or":
var statearr_35351_35466 = state_35290__$1;
(statearr_35351_35466[(1)] = (58));


break;
case "and":
var statearr_35352_35467 = state_35290__$1;
(statearr_35352_35467[(1)] = (59));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__35350_35464__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (17))){
var inst_35285 = (state_35290[(2)]);
var _ = (function (){var statearr_35353 = state_35290;
(statearr_35353[(4)] = cljs.core.rest.call(null,(state_35290[(4)])));

return statearr_35353;
})();
var state_35290__$1 = state_35290;
var statearr_35354_35468 = state_35290__$1;
(statearr_35354_35468[(2)] = inst_35285);

(statearr_35354_35468[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (3))){
var inst_35288 = (state_35290[(2)]);
var state_35290__$1 = state_35290;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35290__$1,inst_35288);
} else {
if((state_val_35291 === (12))){
var inst_35047 = (offset + limit);
var state_35290__$1 = state_35290;
var statearr_35355_35469 = state_35290__$1;
(statearr_35355_35469[(2)] = inst_35047);

(statearr_35355_35469[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (2))){
var inst_35039 = (state_35290[(9)]);
var _ = (function (){var statearr_35356 = state_35290;
(statearr_35356[(4)] = cljs.core.cons.call(null,(5),(state_35290[(4)])));

return statearr_35356;
})();
var inst_35036 = fluree.db.query.fql_parser.parse_where.call(null,db,where_clause,default_collection);
var inst_35037 = cljs.core.nth.call(null,inst_35036,(0),null);
var inst_35038 = cljs.core.nth.call(null,inst_35036,(1),null);
var inst_35039__$1 = limit;
var state_35290__$1 = (function (){var statearr_35357 = state_35290;
(statearr_35357[(9)] = inst_35039__$1);

(statearr_35357[(25)] = inst_35037);

(statearr_35357[(16)] = inst_35038);

return statearr_35357;
})();
if(cljs.core.truth_(inst_35039__$1)){
var statearr_35358_35470 = state_35290__$1;
(statearr_35358_35470[(1)] = (6));

} else {
var statearr_35359_35471 = state_35290__$1;
(statearr_35359_35471[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (66))){
var inst_35253 = (state_35290[(7)]);
var state_35290__$1 = state_35290;
var statearr_35360_35472 = state_35290__$1;
(statearr_35360_35472[(2)] = inst_35253);

(statearr_35360_35472[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (23))){
var inst_35068 = (state_35290[(10)]);
var inst_35080 = cljs.core.drop.call(null,offset,inst_35068);
var state_35290__$1 = state_35290;
var statearr_35361_35473 = state_35290__$1;
(statearr_35361_35473[(2)] = inst_35080);

(statearr_35361_35473[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (47))){
var inst_35226 = (state_35290[(2)]);
var state_35290__$1 = state_35290;
var statearr_35362_35474 = state_35290__$1;
(statearr_35362_35474[(2)] = inst_35226);

(statearr_35362_35474[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (35))){
var inst_35095 = (state_35290[(22)]);
var inst_35093 = (state_35290[(21)]);
var inst_35053 = (state_35290[(12)]);
var inst_35126 = (state_35290[(2)]);
var inst_35127 = fluree.db.util.async.throw_err.call(null,inst_35126);
var inst_35128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35129 = [inst_35093];
var inst_35130 = (new cljs.core.PersistentVector(null,1,(5),inst_35128,inst_35129,null));
var inst_35131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35132 = [inst_35093,inst_35095];
var inst_35133 = (new cljs.core.PersistentVector(null,2,(5),inst_35131,inst_35132,null));
var inst_35134 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_35135 = [inst_35053];
var inst_35136 = cljs.core.PersistentHashMap.fromArrays(inst_35134,inst_35135);
var inst_35137 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_35130,cljs.core._LT_,inst_35133,inst_35136);
var state_35290__$1 = (function (){var statearr_35363 = state_35290;
(statearr_35363[(24)] = inst_35127);

return statearr_35363;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35290__$1,(36),inst_35137);
} else {
if((state_val_35291 === (76))){
var inst_35247 = (state_35290[(27)]);
var inst_35075 = (state_35290[(28)]);
var inst_35067 = inst_35075;
var inst_35068 = inst_35247;
var state_35290__$1 = (function (){var statearr_35364 = state_35290;
(statearr_35364[(18)] = inst_35067);

(statearr_35364[(10)] = inst_35068);

return statearr_35364;
})();
var statearr_35365_35475 = state_35290__$1;
(statearr_35365_35475[(2)] = null);

(statearr_35365_35475[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (19))){
var inst_35282 = (state_35290[(2)]);
var state_35290__$1 = state_35290;
var statearr_35366_35476 = state_35290__$1;
(statearr_35366_35476[(2)] = inst_35282);

(statearr_35366_35476[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (57))){
var inst_35037 = (state_35290[(25)]);
var inst_35248 = (state_35290[(26)]);
var inst_35247 = (state_35290[(2)]);
var inst_35248__$1 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_35037);
var state_35290__$1 = (function (){var statearr_35367 = state_35290;
(statearr_35367[(27)] = inst_35247);

(statearr_35367[(26)] = inst_35248__$1);

return statearr_35367;
})();
if(inst_35248__$1){
var statearr_35368_35477 = state_35290__$1;
(statearr_35368_35477[(1)] = (63));

} else {
var statearr_35369_35478 = state_35290__$1;
(statearr_35369_35478[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (68))){
var inst_35268 = (state_35290[(2)]);
var state_35290__$1 = state_35290;
if(cljs.core.truth_(inst_35268)){
var statearr_35370_35479 = state_35290__$1;
(statearr_35370_35479[(1)] = (75));

} else {
var statearr_35371_35480 = state_35290__$1;
(statearr_35371_35480[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (11))){
var inst_35038 = (state_35290[(16)]);
var inst_35053 = (state_35290[(2)]);
var inst_35054 = cljs.core.not_empty.call(null,inst_35038);
var state_35290__$1 = (function (){var statearr_35373 = state_35290;
(statearr_35373[(12)] = inst_35053);

return statearr_35373;
})();
if(cljs.core.truth_(inst_35054)){
var statearr_35374_35481 = state_35290__$1;
(statearr_35374_35481[(1)] = (15));

} else {
var statearr_35375_35482 = state_35290__$1;
(statearr_35375_35482[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (9))){
var state_35290__$1 = state_35290;
if(cljs.core.truth_(offset)){
var statearr_35376_35483 = state_35290__$1;
(statearr_35376_35483[(1)] = (12));

} else {
var statearr_35377_35484 = state_35290__$1;
(statearr_35377_35484[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (5))){
var _ = (function (){var statearr_35378 = state_35290;
(statearr_35378[(4)] = cljs.core.rest.call(null,(state_35290[(4)])));

return statearr_35378;
})();
var state_35290__$1 = state_35290;
var ex35372 = (state_35290__$1[(2)]);
var statearr_35379_35485 = state_35290__$1;
(statearr_35379_35485[(5)] = ex35372);


if((ex35372 instanceof Error)){
var statearr_35380_35486 = state_35290__$1;
(statearr_35380_35486[(1)] = (4));

(statearr_35380_35486[(5)] = null);

} else {
throw ex35372;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (14))){
var inst_35050 = (state_35290[(2)]);
var state_35290__$1 = state_35290;
var statearr_35381_35487 = state_35290__$1;
(statearr_35381_35487[(2)] = inst_35050);

(statearr_35381_35487[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (45))){
var inst_35095 = (state_35290[(22)]);
var inst_35093 = (state_35290[(21)]);
var inst_35053 = (state_35290[(12)]);
var inst_35174 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35175 = [inst_35093,inst_35095];
var inst_35176 = (new cljs.core.PersistentVector(null,2,(5),inst_35174,inst_35175,null));
var inst_35177 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35178 = [inst_35093];
var inst_35179 = (new cljs.core.PersistentVector(null,1,(5),inst_35177,inst_35178,null));
var inst_35180 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_35181 = [inst_35053];
var inst_35182 = cljs.core.PersistentHashMap.fromArrays(inst_35180,inst_35181);
var inst_35183 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_35176,cljs.core._LT__EQ_,inst_35179,inst_35182);
var state_35290__$1 = state_35290;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35290__$1,(48),inst_35183);
} else {
if((state_val_35291 === (53))){
var inst_35095 = (state_35290[(22)]);
var inst_35093 = (state_35290[(21)]);
var inst_35053 = (state_35290[(12)]);
var inst_35206 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35207 = [inst_35093];
var inst_35208 = (new cljs.core.PersistentVector(null,1,(5),inst_35206,inst_35207,null));
var inst_35209 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35210 = [inst_35093,inst_35095];
var inst_35211 = (new cljs.core.PersistentVector(null,2,(5),inst_35209,inst_35210,null));
var inst_35212 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_35213 = [inst_35053];
var inst_35214 = cljs.core.PersistentHashMap.fromArrays(inst_35212,inst_35213);
var inst_35215 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_35208,cljs.core._LT__EQ_,inst_35211,inst_35214);
var state_35290__$1 = state_35290;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35290__$1,(56),inst_35215);
} else {
if((state_val_35291 === (78))){
var inst_35247 = (state_35290[(27)]);
var inst_35271 = cljs.core.drop.call(null,offset,inst_35247);
var state_35290__$1 = state_35290;
var statearr_35382_35488 = state_35290__$1;
(statearr_35382_35488[(2)] = inst_35271);

(statearr_35382_35488[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (26))){
var inst_35083 = (state_35290[(13)]);
var inst_35085 = cljs.core.take.call(null,limit,inst_35083);
var state_35290__$1 = state_35290;
var statearr_35383_35489 = state_35290__$1;
(statearr_35383_35489[(2)] = inst_35085);

(statearr_35383_35489[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (16))){
var state_35290__$1 = state_35290;
var statearr_35384_35490 = state_35290__$1;
(statearr_35384_35490[(2)] = null);

(statearr_35384_35490[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (79))){
var inst_35247 = (state_35290[(27)]);
var state_35290__$1 = state_35290;
var statearr_35385_35491 = state_35290__$1;
(statearr_35385_35491[(2)] = inst_35247);

(statearr_35385_35491[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (38))){
var inst_35112 = (state_35290[(14)]);
var inst_35094 = (state_35290[(15)]);
var inst_35156 = inst_35112.call(null,cljs.core._GT_,inst_35094);
var state_35290__$1 = state_35290;
if(cljs.core.truth_(inst_35156)){
var statearr_35386_35492 = state_35290__$1;
(statearr_35386_35492[(1)] = (41));

} else {
var statearr_35387_35493 = state_35290__$1;
(statearr_35387_35493[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (30))){
var state_35290__$1 = state_35290;
var statearr_35388_35494 = state_35290__$1;
(statearr_35388_35494[(2)] = null);

(statearr_35388_35494[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (73))){
var inst_35053 = (state_35290[(12)]);
var state_35290__$1 = state_35290;
var statearr_35389_35495 = state_35290__$1;
(statearr_35389_35495[(2)] = inst_35053);

(statearr_35389_35495[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (10))){
var state_35290__$1 = state_35290;
var statearr_35390_35496 = state_35290__$1;
(statearr_35390_35496[(2)] = null);

(statearr_35390_35496[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (18))){
var inst_35067 = (state_35290[(18)]);
var inst_35074 = (state_35290[(20)]);
var inst_35073 = cljs.core.seq.call(null,inst_35067);
var inst_35074__$1 = cljs.core.first.call(null,inst_35073);
var inst_35075 = cljs.core.next.call(null,inst_35073);
var inst_35076 = cljs.core.not.call(null,inst_35074__$1);
var state_35290__$1 = (function (){var statearr_35391 = state_35290;
(statearr_35391[(20)] = inst_35074__$1);

(statearr_35391[(28)] = inst_35075);

return statearr_35391;
})();
if(inst_35076){
var statearr_35392_35497 = state_35290__$1;
(statearr_35392_35497[(1)] = (20));

} else {
var statearr_35393_35498 = state_35290__$1;
(statearr_35393_35498[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (52))){
var inst_35201 = (state_35290[(2)]);
var inst_35202 = fluree.db.util.async.throw_err.call(null,inst_35201);
var state_35290__$1 = state_35290;
var statearr_35394_35499 = state_35290__$1;
(statearr_35394_35499[(2)] = inst_35202);

(statearr_35394_35499[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (67))){
var inst_35037 = (state_35290[(25)]);
var inst_35256 = (state_35290[(8)]);
var inst_35256__$1 = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_35037);
var state_35290__$1 = (function (){var statearr_35395 = state_35290;
(statearr_35395[(8)] = inst_35256__$1);

return statearr_35395;
})();
if(inst_35256__$1){
var statearr_35396_35500 = state_35290__$1;
(statearr_35396_35500[(1)] = (69));

} else {
var statearr_35397_35501 = state_35290__$1;
(statearr_35397_35501[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (71))){
var inst_35266 = (state_35290[(2)]);
var state_35290__$1 = state_35290;
var statearr_35398_35502 = state_35290__$1;
(statearr_35398_35502[(2)] = inst_35266);

(statearr_35398_35502[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (42))){
var inst_35112 = (state_35290[(14)]);
var inst_35094 = (state_35290[(15)]);
var inst_35172 = inst_35112.call(null,cljs.core._GT__EQ_,inst_35094);
var state_35290__$1 = state_35290;
if(cljs.core.truth_(inst_35172)){
var statearr_35399_35503 = state_35290__$1;
(statearr_35399_35503[(1)] = (45));

} else {
var statearr_35400_35504 = state_35290__$1;
(statearr_35400_35504[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (80))){
var inst_35274 = (state_35290[(2)]);
var state_35290__$1 = state_35290;
var statearr_35401_35505 = state_35290__$1;
(statearr_35401_35505[(2)] = inst_35274);

(statearr_35401_35505[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (37))){
var inst_35095 = (state_35290[(22)]);
var inst_35093 = (state_35290[(21)]);
var inst_35053 = (state_35290[(12)]);
var inst_35145 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35146 = [inst_35093,inst_35095];
var inst_35147 = (new cljs.core.PersistentVector(null,2,(5),inst_35145,inst_35146,null));
var inst_35148 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_35149 = [inst_35053];
var inst_35150 = cljs.core.PersistentHashMap.fromArrays(inst_35148,inst_35149);
var inst_35151 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_35147,inst_35150);
var state_35290__$1 = state_35290;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35290__$1,(40),inst_35151);
} else {
if((state_val_35291 === (63))){
var inst_35247 = (state_35290[(27)]);
var inst_35250 = cljs.core.empty_QMARK_.call(null,inst_35247);
var state_35290__$1 = state_35290;
var statearr_35402_35506 = state_35290__$1;
(statearr_35402_35506[(2)] = inst_35250);

(statearr_35402_35506[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (8))){
var inst_35044 = (state_35290[(2)]);
var state_35290__$1 = state_35290;
if(cljs.core.truth_(inst_35044)){
var statearr_35403_35507 = state_35290__$1;
(statearr_35403_35507[(1)] = (9));

} else {
var statearr_35404_35508 = state_35290__$1;
(statearr_35404_35508[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (49))){
var inst_35095 = (state_35290[(22)]);
var inst_35093 = (state_35290[(21)]);
var inst_35053 = (state_35290[(12)]);
var inst_35190 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35191 = [inst_35093];
var inst_35192 = (new cljs.core.PersistentVector(null,1,(5),inst_35190,inst_35191,null));
var inst_35193 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35194 = [inst_35093,inst_35095];
var inst_35195 = (new cljs.core.PersistentVector(null,2,(5),inst_35193,inst_35194,null));
var inst_35196 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_35197 = [inst_35053];
var inst_35198 = cljs.core.PersistentHashMap.fromArrays(inst_35196,inst_35197);
var inst_35199 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_35192,cljs.core._LT_,inst_35195,inst_35198);
var state_35290__$1 = state_35290;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35290__$1,(52),inst_35199);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__10945__auto__ = null;
var fluree$db$query$fql$state_machine__10945__auto____0 = (function (){
var statearr_35405 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35405[(0)] = fluree$db$query$fql$state_machine__10945__auto__);

(statearr_35405[(1)] = (1));

return statearr_35405;
});
var fluree$db$query$fql$state_machine__10945__auto____1 = (function (state_35290){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_35290);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e35406){var ex__10948__auto__ = e35406;
var statearr_35407_35509 = state_35290;
(statearr_35407_35509[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_35290[(4)]))){
var statearr_35408_35510 = state_35290;
(statearr_35408_35510[(1)] = cljs.core.first.call(null,(state_35290[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35511 = state_35290;
state_35290 = G__35511;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__10945__auto__ = function(state_35290){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__10945__auto____1.call(this,state_35290);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__10945__auto____0;
fluree$db$query$fql$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__10945__auto____1;
return fluree$db$query$fql$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_35409 = f__11019__auto__.call(null);
(statearr_35409[(6)] = c__11018__auto__);

return statearr_35409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 4);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,cljs.core.keys.call(null,x))))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var var_as_symbol = cljs.core.symbol.call(null,cljs.core.first.call(null,cljs.core.keys.call(null,x)));
var ___$1 = (cljs.core.truth_(valid_var.call(null,var_as_symbol))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),cljs.core.first.call(null,cljs.core.vals.call(null,x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__5045__auto__ = cljs.core.every_QMARK_.call(null,(function (p1__35512_SHARP_){
return ((typeof p1__35512_SHARP_ === 'string') || (cljs.core.map_QMARK_.call(null,p1__35512_SHARP_)));
}),select_smt);
if(or__5045__auto__){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vars__$1 = cljs.core.set.call(null,vars);
var all_vars = cljs.core.set.call(null,cljs.core.concat.call(null,vars__$1,cljs.core.keys.call(null,interim_vars)));
return cljs.core.map.call(null,(function (select){
var var_symbol = ((cljs.core.map_QMARK_.call(null,select))?null:cljs.core.symbol.call(null,select));
if(cljs.core.truth_(vars__$1.call(null,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_.call(null,select))){
return fluree.db.query.analytical.parse_aggregate.call(null,select,vars__$1);
} else {
if(cljs.core.map_QMARK_.call(null,select)){
return fluree.db.query.fql.parse_map.call(null,select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.call(null,interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.call(null,interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.call(null,(function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies.call(null,vars);
if(cljs.core.every_QMARK_.call(null,(function (p1__35513_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__35513_SHARP_);
}),cljs.core.vals.call(null,freqs))){
return vars;
} else {
var G__35517 = vars;
var vec__35518 = G__35517;
var seq__35519 = cljs.core.seq.call(null,vec__35518);
var first__35520 = cljs.core.first.call(null,seq__35519);
var seq__35519__$1 = cljs.core.next.call(null,seq__35519);
var var$ = first__35520;
var r = seq__35519__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__35517__$1 = G__35517;
var all_vars__$1 = all_vars;
while(true){
var vec__35524 = G__35517__$1;
var seq__35525 = cljs.core.seq.call(null,vec__35524);
var first__35526 = cljs.core.first.call(null,seq__35525);
var seq__35525__$1 = cljs.core.next.call(null,seq__35525);
var var$__$1 = first__35526;
var r__$1 = seq__35525__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not.call(null,var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_(cljs.core.set.call(null,all_vars__$2).call(null,var$__$1))){
var G__35527 = r__$1;
var G__35528 = cljs.core.conj.call(null,all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,all_vars__$2))].join(''));
G__35517__$1 = G__35527;
all_vars__$1 = G__35528;
continue;
} else {
var G__35529 = r__$1;
var G__35530 = cljs.core.conj.call(null,all_vars__$2,var$__$1);
G__35517__$1 = G__35529;
all_vars__$1 = G__35530;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_35565){
var state_val_35566 = (state_35565[(1)]);
if((state_val_35566 === (1))){
var inst_35538 = functionArray;
var inst_35539 = cljs.core.seq.call(null,inst_35538);
var inst_35540 = cljs.core.first.call(null,inst_35539);
var inst_35541 = cljs.core.next.call(null,inst_35539);
var inst_35542 = cljs.core.PersistentVector.EMPTY;
var inst_35543 = inst_35538;
var inst_35544 = inst_35542;
var state_35565__$1 = (function (){var statearr_35567 = state_35565;
(statearr_35567[(7)] = inst_35544);

(statearr_35567[(8)] = inst_35543);

(statearr_35567[(9)] = inst_35540);

(statearr_35567[(10)] = inst_35541);

return statearr_35567;
})();
var statearr_35568_35581 = state_35565__$1;
(statearr_35568_35581[(2)] = null);

(statearr_35568_35581[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35566 === (2))){
var inst_35543 = (state_35565[(8)]);
var inst_35550 = (state_35565[(11)]);
var inst_35549 = cljs.core.seq.call(null,inst_35543);
var inst_35550__$1 = cljs.core.first.call(null,inst_35549);
var inst_35551 = cljs.core.next.call(null,inst_35549);
var state_35565__$1 = (function (){var statearr_35569 = state_35565;
(statearr_35569[(11)] = inst_35550__$1);

(statearr_35569[(12)] = inst_35551);

return statearr_35569;
})();
if(cljs.core.truth_(inst_35550__$1)){
var statearr_35570_35582 = state_35565__$1;
(statearr_35570_35582[(1)] = (4));

} else {
var statearr_35571_35583 = state_35565__$1;
(statearr_35571_35583[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35566 === (3))){
var inst_35563 = (state_35565[(2)]);
var state_35565__$1 = state_35565;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35565__$1,inst_35563);
} else {
if((state_val_35566 === (4))){
var inst_35550 = (state_35565[(11)]);
var inst_35553 = inst_35550.call(null,tuple);
var state_35565__$1 = state_35565;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35565__$1,(7),inst_35553);
} else {
if((state_val_35566 === (5))){
var inst_35544 = (state_35565[(7)]);
var state_35565__$1 = state_35565;
var statearr_35572_35584 = state_35565__$1;
(statearr_35572_35584[(2)] = inst_35544);

(statearr_35572_35584[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35566 === (6))){
var inst_35561 = (state_35565[(2)]);
var state_35565__$1 = state_35565;
var statearr_35573_35585 = state_35565__$1;
(statearr_35573_35585[(2)] = inst_35561);

(statearr_35573_35585[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35566 === (7))){
var inst_35544 = (state_35565[(7)]);
var inst_35551 = (state_35565[(12)]);
var inst_35555 = (state_35565[(2)]);
var inst_35556 = fluree.db.util.async.throw_err.call(null,inst_35555);
var inst_35557 = cljs.core.conj.call(null,inst_35544,inst_35556);
var inst_35543 = inst_35551;
var inst_35544__$1 = inst_35557;
var state_35565__$1 = (function (){var statearr_35574 = state_35565;
(statearr_35574[(7)] = inst_35544__$1);

(statearr_35574[(8)] = inst_35543);

return statearr_35574;
})();
var statearr_35575_35586 = state_35565__$1;
(statearr_35575_35586[(2)] = null);

(statearr_35575_35586[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__10945__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__10945__auto____0 = (function (){
var statearr_35576 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35576[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__10945__auto__);

(statearr_35576[(1)] = (1));

return statearr_35576;
});
var fluree$db$query$fql$format_tuple_$_state_machine__10945__auto____1 = (function (state_35565){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_35565);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e35577){var ex__10948__auto__ = e35577;
var statearr_35578_35587 = state_35565;
(statearr_35578_35587[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_35565[(4)]))){
var statearr_35579_35588 = state_35565;
(statearr_35579_35588[(1)] = cljs.core.first.call(null,(state_35565[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35589 = state_35565;
state_35565 = G__35589;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__10945__auto__ = function(state_35565){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__10945__auto____1.call(this,state_35565);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__10945__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__10945__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_35580 = f__11019__auto__.call(null);
(statearr_35580[(6)] = c__11018__auto__);

return statearr_35580;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,cljs.core.map.call(null,cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.call(null,(function (idx,select_item){
var temp__5804__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5804__auto__)){
var query_map = temp__5804__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.call(null,pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__35590){
var vec__35591 = p__35590;
var tuple_index = cljs.core.nth.call(null,vec__35591,(0),null);
var query_map = cljs.core.nth.call(null,vec__35591,(1),null);
var temp__5804__auto__ = cljs.core.get.call(null,tuple_result,tuple_index);
if(cljs.core.truth_(temp__5804__auto__)){
var _id = temp__5804__auto__;
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_35605){
var state_val_35606 = (state_35605[(1)]);
if((state_val_35606 === (1))){
var inst_35594 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35595 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_35596 = [query_map,_id,query_opts];
var inst_35597 = cljs.core.PersistentHashMap.fromArrays(inst_35595,inst_35596);
var inst_35598 = fluree.db.query.fql.query.call(null,db,inst_35597);
var state_35605__$1 = (function (){var statearr_35607 = state_35605;
(statearr_35607[(7)] = inst_35594);

return statearr_35607;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35605__$1,(2),inst_35598);
} else {
if((state_val_35606 === (2))){
var inst_35594 = (state_35605[(7)]);
var inst_35600 = (state_35605[(2)]);
var inst_35601 = fluree.db.util.async.throw_err.call(null,inst_35600);
var inst_35602 = [tuple_index,inst_35601];
var inst_35603 = (new cljs.core.PersistentVector(null,2,(5),inst_35594,inst_35602,null));
var state_35605__$1 = state_35605;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35605__$1,inst_35603);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__10945__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__10945__auto____0 = (function (){
var statearr_35608 = [null,null,null,null,null,null,null,null];
(statearr_35608[(0)] = fluree$db$query$fql$expand_map_$_state_machine__10945__auto__);

(statearr_35608[(1)] = (1));

return statearr_35608;
});
var fluree$db$query$fql$expand_map_$_state_machine__10945__auto____1 = (function (state_35605){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_35605);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e35609){var ex__10948__auto__ = e35609;
var statearr_35610_35613 = state_35605;
(statearr_35610_35613[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_35605[(4)]))){
var statearr_35611_35614 = state_35605;
(statearr_35611_35614[(1)] = cljs.core.first.call(null,(state_35605[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35615 = state_35605;
state_35605 = G__35615;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__10945__auto__ = function(state_35605){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__10945__auto____1.call(this,state_35605);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__10945__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__10945__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_35612 = f__11019__auto__.call(null);
(statearr_35612[(6)] = c__11018__auto__);

return statearr_35612;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_.call(null,expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__35616 = expand_map_tuple;
var tuple_index = cljs.core.nth.call(null,vec__35616,(0),null);
var query_map_result = cljs.core.nth.call(null,vec__35616,(1),null);
return cljs.core.assoc.call(null,tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_35679){
var state_val_35680 = (state_35679[(1)]);
if((state_val_35680 === (7))){
var inst_35674 = (state_35679[(2)]);
var _ = (function (){var statearr_35681 = state_35679;
(statearr_35681[(4)] = cljs.core.rest.call(null,(state_35679[(4)])));

return statearr_35681;
})();
var state_35679__$1 = state_35679;
var statearr_35682_35773 = state_35679__$1;
(statearr_35682_35773[(2)] = inst_35674);

(statearr_35682_35773[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35680 === (20))){
var inst_35665 = (state_35679[(2)]);
var state_35679__$1 = state_35679;
var statearr_35683_35774 = state_35679__$1;
(statearr_35683_35774[(2)] = inst_35665);

(statearr_35683_35774[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35680 === (1))){
var state_35679__$1 = state_35679;
var statearr_35684_35775 = state_35679__$1;
(statearr_35684_35775[(2)] = null);

(statearr_35684_35775[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35680 === (4))){
var inst_35621 = (state_35679[(2)]);
var state_35679__$1 = state_35679;
var statearr_35685_35776 = state_35679__$1;
(statearr_35685_35776[(2)] = inst_35621);

(statearr_35685_35776[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35680 === (15))){
var inst_35641 = (state_35679[(7)]);
var inst_35650 = cljs.core.second.call(null,inst_35641);
var inst_35651 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_35650);
var inst_35652 = (inst_35651 > max_fuel);
var state_35679__$1 = state_35679;
if(cljs.core.truth_(inst_35652)){
var statearr_35686_35777 = state_35679__$1;
(statearr_35686_35777[(1)] = (18));

} else {
var statearr_35687_35778 = state_35679__$1;
(statearr_35687_35778[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35680 === (13))){
var state_35679__$1 = state_35679;
var statearr_35688_35779 = state_35679__$1;
(statearr_35688_35779[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35680 === (6))){
var inst_35629 = (state_35679[(8)]);
var state_35679__$1 = state_35679;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35679__$1,(8),inst_35629);
} else {
if((state_val_35680 === (17))){
var inst_35668 = (state_35679[(2)]);
var state_35679__$1 = state_35679;
var statearr_35690_35780 = state_35679__$1;
(statearr_35690_35780[(2)] = inst_35668);

(statearr_35690_35780[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35680 === (3))){
var inst_35677 = (state_35679[(2)]);
var state_35679__$1 = state_35679;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35679__$1,inst_35677);
} else {
if((state_val_35680 === (12))){
var inst_35641 = (state_35679[(7)]);
var inst_35630 = (state_35679[(9)]);
var inst_35647 = inst_35630.call(null);
var state_35679__$1 = (function (){var statearr_35691 = state_35679;
(statearr_35691[(10)] = inst_35647);

return statearr_35691;
})();
var statearr_35692_35781 = state_35679__$1;
(statearr_35692_35781[(2)] = inst_35641);

(statearr_35692_35781[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35680 === (2))){
var inst_35629 = (state_35679[(8)]);
var inst_35630 = (state_35679[(9)]);
var _ = (function (){var statearr_35693 = state_35679;
(statearr_35693[(4)] = cljs.core.cons.call(null,(5),(state_35679[(4)])));

return statearr_35693;
})();
var inst_35627 = fluree.db.query.fql.build_expand_map.call(null,select,pp_keys);
var inst_35628 = cljs.core.async.chan.call(null);
var inst_35629__$1 = cljs.core.async.chan.call(null);
var inst_35630__$1 = (function (){var expandMaps = inst_35627;
var queue_ch = inst_35628;
var res_ch = inst_35629__$1;
return (function (){
cljs.core.async.close_BANG_.call(null,queue_ch);

return cljs.core.async.close_BANG_.call(null,res_ch);
});
})();
var inst_35631 = cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_35632 = cljs.core.volatile_BANG_.call(null,(0));
var inst_35633 = cljs.core.assoc.call(null,inst_35631,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_35632);
var inst_35634 = (function (){var expandMaps = inst_35627;
var queue_ch = inst_35628;
var res_ch = inst_35629__$1;
var stop_BANG_ = inst_35630__$1;
var opts_STAR_ = inst_35633;
return (function (tuple_res,port){
var c__11018__auto____$1 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_35726){
var state_val_35727 = (state_35726[(1)]);
if((state_val_35727 === (7))){
var state_35726__$1 = state_35726;
var statearr_35728_35782 = state_35726__$1;
(statearr_35728_35782[(2)] = tuple_res);

(statearr_35728_35782[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35727 === (1))){
var state_35726__$1 = state_35726;
var statearr_35729_35783 = state_35726__$1;
(statearr_35729_35783[(2)] = null);

(statearr_35729_35783[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35727 === (4))){
var inst_35694 = (state_35726[(2)]);
var inst_35695 = cljs.core.async.put_BANG_.call(null,port,inst_35694);
var inst_35696 = cljs.core.async.close_BANG_.call(null,port);
var state_35726__$1 = (function (){var statearr_35730 = state_35726;
(statearr_35730[(7)] = inst_35695);

return statearr_35730;
})();
var statearr_35731_35784 = state_35726__$1;
(statearr_35731_35784[(2)] = inst_35696);

(statearr_35731_35784[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35727 === (6))){
var inst_35703 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35704 = [tuple_res];
var inst_35705 = (new cljs.core.PersistentVector(null,1,(5),inst_35703,inst_35704,null));
var state_35726__$1 = state_35726;
var statearr_35732_35785 = state_35726__$1;
(statearr_35732_35785[(2)] = inst_35705);

(statearr_35732_35785[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35727 === (3))){
var inst_35724 = (state_35726[(2)]);
var state_35726__$1 = state_35726;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35726__$1,inst_35724);
} else {
if((state_val_35727 === (2))){
var ___$1 = (function (){var statearr_35734 = state_35726;
(statearr_35734[(4)] = cljs.core.cons.call(null,(5),(state_35726[(4)])));

return statearr_35734;
})();
var state_35726__$1 = state_35726;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_35735_35786 = state_35726__$1;
(statearr_35735_35786[(1)] = (6));

} else {
var statearr_35736_35787 = state_35726__$1;
(statearr_35736_35787[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35727 === (9))){
var inst_35710 = (state_35726[(8)]);
var inst_35708 = (state_35726[(9)]);
var inst_35717 = (state_35726[(2)]);
var inst_35718 = cljs.core.reduce.call(null,fluree.db.query.fql.replace_expand_maps,inst_35708,inst_35717);
var inst_35719 = inst_35710.call(null,inst_35718);
var inst_35720 = cljs.core.async.put_BANG_.call(null,port,inst_35719);
var inst_35721 = cljs.core.async.close_BANG_.call(null,port);
var ___$1 = (function (){var statearr_35737 = state_35726;
(statearr_35737[(4)] = cljs.core.rest.call(null,(state_35726[(4)])));

return statearr_35737;
})();
var state_35726__$1 = (function (){var statearr_35738 = state_35726;
(statearr_35738[(10)] = inst_35720);

return statearr_35738;
})();
var statearr_35739_35788 = state_35726__$1;
(statearr_35739_35788[(2)] = inst_35721);

(statearr_35739_35788[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35727 === (5))){
var ___$1 = (function (){var statearr_35740 = state_35726;
(statearr_35740[(4)] = cljs.core.rest.call(null,(state_35726[(4)])));

return statearr_35740;
})();
var state_35726__$1 = state_35726;
var ex35733 = (state_35726__$1[(2)]);
var statearr_35741_35789 = state_35726__$1;
(statearr_35741_35789[(5)] = ex35733);


var statearr_35742_35790 = state_35726__$1;
(statearr_35742_35790[(1)] = (4));

(statearr_35742_35790[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35727 === (8))){
var inst_35708 = (state_35726[(9)]);
var inst_35708__$1 = (state_35726[(2)]);
var inst_35709 = cljs.core.volatile_BANG_.call(null,(0));
var inst_35710 = (function (){var tuple_res_SINGLEQUOTE_ = inst_35708__$1;
var query_fuel = inst_35709;
return (function (p1__35620_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,p1__35620_SHARP_),cljs.core.deref.call(null,query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__35620_SHARP_,cljs.core.deref.call(null,query_fuel)], null);
}
});
})();
var inst_35711 = cljs.core.PersistentVector.EMPTY;
var inst_35712 = (function (){var tuple_res_SINGLEQUOTE_ = inst_35708__$1;
var query_fuel = inst_35709;
return (function (p1__35619_SHARP_){
return fluree.db.query.fql.expand_map.call(null,db,cljs.core.assoc.call(null,opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__35619_SHARP_);
});
})();
var inst_35713 = cljs.core.keep.call(null,inst_35712,expandMaps);
var inst_35714 = cljs.core.async.merge.call(null,inst_35713);
var inst_35715 = cljs.core.async.into.call(null,inst_35711,inst_35714);
var state_35726__$1 = (function (){var statearr_35743 = state_35726;
(statearr_35743[(8)] = inst_35710);

(statearr_35743[(9)] = inst_35708__$1);

return statearr_35743;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35726__$1,(9),inst_35715);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10945__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10945__auto____0 = (function (){
var statearr_35744 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_35744[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10945__auto__);

(statearr_35744[(1)] = (1));

return statearr_35744;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10945__auto____1 = (function (state_35726){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_35726);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e35745){var ex__10948__auto__ = e35745;
var statearr_35746_35791 = state_35726;
(statearr_35746_35791[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_35726[(4)]))){
var statearr_35747_35792 = state_35726;
(statearr_35747_35792[(1)] = cljs.core.first.call(null,(state_35726[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35793 = state_35726;
state_35726 = G__35793;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10945__auto__ = function(state_35726){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10945__auto____1.call(this,state_35726);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10945__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10945__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_35748 = f__11019__auto__.call(null);
(statearr_35748[(6)] = c__11018__auto____$1);

return statearr_35748;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto____$1;
});
})();
var inst_35635 = cljs.core.async.onto_chan_BANG_.call(null,inst_35628,tuples_res);
var inst_35636 = cljs.core.async.pipeline_async.call(null,parallelism,inst_35629__$1,inst_35634,inst_35628);
var inst_35637 = cljs.core.PersistentVector.EMPTY;
var inst_35638 = inst_35637;
var state_35679__$1 = (function (){var statearr_35749 = state_35679;
(statearr_35749[(8)] = inst_35629__$1);

(statearr_35749[(11)] = inst_35636);

(statearr_35749[(12)] = inst_35635);

(statearr_35749[(13)] = inst_35638);

(statearr_35749[(9)] = inst_35630__$1);

return statearr_35749;
})();
var statearr_35750_35794 = state_35679__$1;
(statearr_35750_35794[(2)] = null);

(statearr_35750_35794[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35680 === (19))){
var inst_35641 = (state_35679[(7)]);
var inst_35638 = (state_35679[(13)]);
var inst_35661 = cljs.core.first.call(null,inst_35641);
var inst_35662 = cljs.core.conj.call(null,inst_35638,inst_35661);
var inst_35638__$1 = inst_35662;
var state_35679__$1 = (function (){var statearr_35751 = state_35679;
(statearr_35751[(13)] = inst_35638__$1);

return statearr_35751;
})();
var statearr_35752_35795 = state_35679__$1;
(statearr_35752_35795[(2)] = null);

(statearr_35752_35795[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35680 === (11))){
var inst_35672 = (state_35679[(2)]);
var state_35679__$1 = state_35679;
var statearr_35754_35796 = state_35679__$1;
(statearr_35754_35796[(2)] = inst_35672);

(statearr_35754_35796[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35680 === (9))){
var inst_35638 = (state_35679[(13)]);
var state_35679__$1 = state_35679;
var statearr_35755_35797 = state_35679__$1;
(statearr_35755_35797[(2)] = inst_35638);

(statearr_35755_35797[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35680 === (5))){
var _ = (function (){var statearr_35756 = state_35679;
(statearr_35756[(4)] = cljs.core.rest.call(null,(state_35679[(4)])));

return statearr_35756;
})();
var state_35679__$1 = state_35679;
var ex35753 = (state_35679__$1[(2)]);
var statearr_35757_35798 = state_35679__$1;
(statearr_35757_35798[(5)] = ex35753);


if((ex35753 instanceof Error)){
var statearr_35758_35799 = state_35679__$1;
(statearr_35758_35799[(1)] = (4));

(statearr_35758_35799[(5)] = null);

} else {
throw ex35753;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35680 === (14))){
var inst_35670 = (state_35679[(2)]);
var state_35679__$1 = state_35679;
var statearr_35759_35800 = state_35679__$1;
(statearr_35759_35800[(2)] = inst_35670);

(statearr_35759_35800[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35680 === (16))){
var state_35679__$1 = state_35679;
var statearr_35760_35801 = state_35679__$1;
(statearr_35760_35801[(2)] = null);

(statearr_35760_35801[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35680 === (10))){
var inst_35641 = (state_35679[(7)]);
var inst_35645 = fluree.db.util.core.exception_QMARK_.call(null,inst_35641);
var state_35679__$1 = state_35679;
if(inst_35645){
var statearr_35761_35802 = state_35679__$1;
(statearr_35761_35802[(1)] = (12));

} else {
var statearr_35762_35803 = state_35679__$1;
(statearr_35762_35803[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35680 === (18))){
var inst_35630 = (state_35679[(9)]);
var inst_35654 = inst_35630.call(null);
var inst_35655 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_35656 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_35657 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_35658 = cljs.core.PersistentHashMap.fromArrays(inst_35656,inst_35657);
var inst_35659 = cljs.core.ex_info.call(null,inst_35655,inst_35658);
var state_35679__$1 = (function (){var statearr_35763 = state_35679;
(statearr_35763[(14)] = inst_35654);

return statearr_35763;
})();
var statearr_35764_35804 = state_35679__$1;
(statearr_35764_35804[(2)] = inst_35659);

(statearr_35764_35804[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35680 === (8))){
var inst_35641 = (state_35679[(7)]);
var inst_35641__$1 = (state_35679[(2)]);
var inst_35642 = (inst_35641__$1 == null);
var state_35679__$1 = (function (){var statearr_35765 = state_35679;
(statearr_35765[(7)] = inst_35641__$1);

return statearr_35765;
})();
if(cljs.core.truth_(inst_35642)){
var statearr_35766_35805 = state_35679__$1;
(statearr_35766_35805[(1)] = (9));

} else {
var statearr_35767_35806 = state_35679__$1;
(statearr_35767_35806[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10945__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10945__auto____0 = (function (){
var statearr_35768 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35768[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10945__auto__);

(statearr_35768[(1)] = (1));

return statearr_35768;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10945__auto____1 = (function (state_35679){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_35679);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e35769){var ex__10948__auto__ = e35769;
var statearr_35770_35807 = state_35679;
(statearr_35770_35807[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_35679[(4)]))){
var statearr_35771_35808 = state_35679;
(statearr_35771_35808[(1)] = cljs.core.first.call(null,(state_35679[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35809 = state_35679;
state_35679 = G__35809;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10945__auto__ = function(state_35679){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10945__auto____1.call(this,state_35679);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10945__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10945__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_35772 = f__11019__auto__.call(null);
(statearr_35772[(6)] = c__11018__auto__);

return statearr_35772;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__35810 = select;
var map__35810__$1 = cljs.core.__destructure_map.call(null,map__35810);
var as = cljs.core.get.call(null,map__35810__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.call(null,map__35810__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.call(null,map__35810__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__5045__auto__ = as;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx.call(null,headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly.call(null,value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.call(null,tuple,idx);
}):(cljs.core.truth_(cljs.core.get.call(null,vars,select_val))?cljs.core.constantly.call(null,cljs.core.get.call(null,vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.call(null,cljs.core.juxt,cljs.core.map.call(null,cljs.core.partial.call(null,fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__35813 = orderBy;
var order = cljs.core.nth.call(null,vec__35813,(0),null);
var var$ = cljs.core.nth.call(null,vec__35813,(1),null);
var option = cljs.core.nth.call(null,vec__35813,(2),null);
var comparator = ((cljs.core._EQ_.call(null,"DESC",order))?(function (a,b){
return cljs.core.compare.call(null,b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.call(null,"NOCASE",clojure.string.upper_case.call(null,option))));
var keyfn = ((no_case_QMARK_)?(function (p1__35811_SHARP_){
return clojure.string.upper_case.call(null,cljs.core.nth.call(null,p1__35811_SHARP_,compare_idx));
}):(function (p1__35812_SHARP_){
return cljs.core.nth.call(null,p1__35812_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count.call(null,tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.call(null,keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__35818 = arguments.length;
switch (G__35818) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__35819,p__35820,group_limit,opts){
var map__35821 = p__35819;
var map__35821__$1 = cljs.core.__destructure_map.call(null,map__35821);
var res = map__35821__$1;
var vars = cljs.core.get.call(null,map__35821__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__35822 = p__35820;
var map__35822__$1 = cljs.core.__destructure_map.call(null,map__35822);
var select_spec = map__35822__$1;
var inVector_QMARK_ = cljs.core.get.call(null,map__35822__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.call(null,map__35822__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__35822__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.call(null,map__35822__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.call(null,map__35822__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__35822__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.call(null,map__35822__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.call(null,map__35822__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__35822__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.call(null,map__35822__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_35959){
var state_val_35960 = (state_35959[(1)]);
if((state_val_35960 === (7))){
var inst_35829 = (state_35959[(7)]);
var state_35959__$1 = state_35959;
var statearr_35961_36063 = state_35959__$1;
(statearr_35961_36063[(2)] = inst_35829);

(statearr_35961_36063[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (59))){
var inst_35952 = (state_35959[(2)]);
var state_35959__$1 = state_35959;
var statearr_35962_36064 = state_35959__$1;
(statearr_35962_36064[(2)] = inst_35952);

(statearr_35962_36064[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (20))){
var inst_35865 = (state_35959[(8)]);
var inst_35868 = (state_35959[(9)]);
var inst_35864 = (state_35959[(2)]);
var inst_35865__$1 = cljs.core.__destructure_map.call(null,inst_35864);
var inst_35866 = cljs.core.get.call(null,inst_35865__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_35867 = cljs.core.get.call(null,inst_35865__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_35868__$1 = offset;
var state_35959__$1 = (function (){var statearr_35963 = state_35959;
(statearr_35963[(10)] = inst_35867);

(statearr_35963[(8)] = inst_35865__$1);

(statearr_35963[(9)] = inst_35868__$1);

(statearr_35963[(11)] = inst_35866);

return statearr_35963;
})();
if(cljs.core.truth_(inst_35868__$1)){
var statearr_35964_36065 = state_35959__$1;
(statearr_35964_36065[(1)] = (21));

} else {
var statearr_35965_36066 = state_35959__$1;
(statearr_35965_36066[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (58))){
var inst_35944 = (state_35959[(12)]);
var state_35959__$1 = state_35959;
var statearr_35966_36067 = state_35959__$1;
(statearr_35966_36067[(2)] = inst_35944);

(statearr_35966_36067[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (60))){
var inst_35948 = (state_35959[(2)]);
var inst_35949 = fluree.db.util.async.throw_err.call(null,inst_35948);
var state_35959__$1 = state_35959;
var statearr_35967_36068 = state_35959__$1;
(statearr_35967_36068[(2)] = inst_35949);

(statearr_35967_36068[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (27))){
var inst_35880 = cljs.core.not.call(null,inVector_QMARK_);
var state_35959__$1 = state_35959;
var statearr_35968_36069 = state_35959__$1;
(statearr_35968_36069[(2)] = inst_35880);

(statearr_35968_36069[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (1))){
var state_35959__$1 = state_35959;
var statearr_35969_36070 = state_35959__$1;
(statearr_35969_36070[(2)] = null);

(statearr_35969_36070[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (24))){
var state_35959__$1 = state_35959;
var statearr_35970_36071 = state_35959__$1;
(statearr_35970_36071[(2)] = offset);

(statearr_35970_36071[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (55))){
var inst_35938 = (state_35959[(13)]);
var state_35959__$1 = state_35959;
var statearr_35971_36072 = state_35959__$1;
(statearr_35971_36072[(2)] = inst_35938);

(statearr_35971_36072[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (39))){
var inst_35906 = (state_35959[(14)]);
var inst_35908 = cljs.core.distinct.call(null);
var inst_35909 = cljs.core.conj.call(null,inst_35906,inst_35908);
var state_35959__$1 = state_35959;
var statearr_35972_36073 = state_35959__$1;
(statearr_35972_36073[(2)] = inst_35909);

(statearr_35972_36073[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (46))){
var inst_35918 = (state_35959[(15)]);
var state_35959__$1 = state_35959;
var statearr_35973_36074 = state_35959__$1;
(statearr_35973_36074[(2)] = inst_35918);

(statearr_35973_36074[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (4))){
var inst_35823 = (state_35959[(2)]);
var state_35959__$1 = state_35959;
var statearr_35974_36075 = state_35959__$1;
(statearr_35974_36075[(2)] = inst_35823);

(statearr_35974_36075[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (54))){
var inst_35938 = (state_35959[(13)]);
var inst_35932 = (state_35959[(16)]);
var inst_35940 = cljs.core.PersistentVector.EMPTY;
var inst_35941 = cljs.core.into.call(null,inst_35940,inst_35932,inst_35938);
var state_35959__$1 = state_35959;
var statearr_35975_36076 = state_35959__$1;
(statearr_35975_36076[(2)] = inst_35941);

(statearr_35975_36076[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (15))){
var inst_35850 = (state_35959[(17)]);
var inst_35852 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35853 = [inst_35850];
var inst_35854 = (new cljs.core.PersistentVector(null,1,(5),inst_35852,inst_35853,null));
var state_35959__$1 = state_35959;
var statearr_35976_36077 = state_35959__$1;
(statearr_35976_36077[(2)] = inst_35854);

(statearr_35976_36077[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (48))){
var inst_35888 = (state_35959[(18)]);
var inst_35867 = (state_35959[(10)]);
var inst_35883 = (state_35959[(19)]);
var inst_35865 = (state_35959[(8)]);
var inst_35924 = (state_35959[(20)]);
var inst_35866 = (state_35959[(11)]);
var inst_35877 = (state_35959[(21)]);
var inst_35926 = (function (){var map__35859 = inst_35865;
var headers = inst_35866;
var tuples = inst_35867;
var offset_SINGLEQUOTE_ = inst_35877;
var single_result_QMARK_ = inst_35883;
var pp_keys = inst_35888;
var G__35889 = inst_35924;
return (function (p1__35816_SHARP_){
return cljs.core.zipmap.call(null,fluree.db.query.fql.get_pretty_print_keys.call(null,select),p1__35816_SHARP_);
});
})();
var inst_35927 = cljs.core.map.call(null,inst_35926);
var inst_35928 = cljs.core.conj.call(null,inst_35924,inst_35927);
var state_35959__$1 = state_35959;
var statearr_35977_36078 = state_35959__$1;
(statearr_35977_36078[(2)] = inst_35928);

(statearr_35977_36078[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (50))){
var inst_35931 = (state_35959[(2)]);
var inst_35932 = cljs.core.apply.call(null,cljs.core.comp,inst_35931);
var state_35959__$1 = (function (){var statearr_35978 = state_35959;
(statearr_35978[(16)] = inst_35932);

return statearr_35978;
})();
if(cljs.core.truth_(orderBy)){
var statearr_35979_36079 = state_35959__$1;
(statearr_35979_36079[(1)] = (51));

} else {
var statearr_35980_36080 = state_35959__$1;
(statearr_35980_36080[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (21))){
var inst_35870 = cljs.core.not.call(null,groupBy);
var state_35959__$1 = state_35959;
var statearr_35981_36081 = state_35959__$1;
(statearr_35981_36081[(2)] = inst_35870);

(statearr_35981_36081[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (31))){
var state_35959__$1 = state_35959;
var statearr_35982_36082 = state_35959__$1;
(statearr_35982_36082[(2)] = null);

(statearr_35982_36082[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (32))){
var inst_35883 = (state_35959[(19)]);
var inst_35866 = (state_35959[(11)]);
var inst_35888 = (state_35959[(2)]);
var inst_35890 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35891 = fluree.db.query.fql.select_tuples_fn.call(null,inst_35866,vars,select);
var inst_35892 = cljs.core.map.call(null,inst_35891);
var inst_35893 = [inst_35892];
var inst_35894 = (new cljs.core.PersistentVector(null,1,(5),inst_35890,inst_35893,null));
var state_35959__$1 = (function (){var statearr_35983 = state_35959;
(statearr_35983[(18)] = inst_35888);

(statearr_35983[(22)] = inst_35894);

return statearr_35983;
})();
if(cljs.core.truth_(inst_35883)){
var statearr_35984_36083 = state_35959__$1;
(statearr_35984_36083[(1)] = (33));

} else {
var statearr_35985_36084 = state_35959__$1;
(statearr_35985_36084[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (40))){
var inst_35906 = (state_35959[(14)]);
var state_35959__$1 = state_35959;
var statearr_35986_36085 = state_35959__$1;
(statearr_35986_36085[(2)] = inst_35906);

(statearr_35986_36085[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (56))){
var inst_35944 = (state_35959[(2)]);
var state_35959__$1 = (function (){var statearr_35987 = state_35959;
(statearr_35987[(12)] = inst_35944);

return statearr_35987;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_35988_36086 = state_35959__$1;
(statearr_35988_36086[(1)] = (57));

} else {
var statearr_35989_36087 = state_35959__$1;
(statearr_35989_36087[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (33))){
var inst_35894 = (state_35959[(22)]);
var inst_35896 = cljs.core.map.call(null,cljs.core.first);
var inst_35897 = cljs.core.conj.call(null,inst_35894,inst_35896);
var state_35959__$1 = state_35959;
var statearr_35990_36088 = state_35959__$1;
(statearr_35990_36088[(2)] = inst_35897);

(statearr_35990_36088[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (13))){
var inst_35839 = (state_35959[(23)]);
var state_35959__$1 = state_35959;
var statearr_35991_36089 = state_35959__$1;
(statearr_35991_36089[(2)] = inst_35839);

(statearr_35991_36089[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (22))){
var inst_35868 = (state_35959[(9)]);
var state_35959__$1 = state_35959;
var statearr_35992_36090 = state_35959__$1;
(statearr_35992_36090[(2)] = inst_35868);

(statearr_35992_36090[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (36))){
var inst_35900 = (state_35959[(24)]);
var inst_35902 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(5));
var inst_35903 = cljs.core.conj.call(null,inst_35900,inst_35902);
var state_35959__$1 = state_35959;
var statearr_35993_36091 = state_35959__$1;
(statearr_35993_36091[(2)] = inst_35903);

(statearr_35993_36091[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (41))){
var inst_35877 = (state_35959[(21)]);
var inst_35912 = (state_35959[(2)]);
var state_35959__$1 = (function (){var statearr_35994 = state_35959;
(statearr_35994[(25)] = inst_35912);

return statearr_35994;
})();
if(cljs.core.truth_(inst_35877)){
var statearr_35995_36092 = state_35959__$1;
(statearr_35995_36092[(1)] = (42));

} else {
var statearr_35996_36093 = state_35959__$1;
(statearr_35996_36093[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (43))){
var inst_35912 = (state_35959[(25)]);
var state_35959__$1 = state_35959;
var statearr_35997_36094 = state_35959__$1;
(statearr_35997_36094[(2)] = inst_35912);

(statearr_35997_36094[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (29))){
var inst_35883 = (state_35959[(2)]);
var state_35959__$1 = (function (){var statearr_35998 = state_35959;
(statearr_35998[(19)] = inst_35883);

return statearr_35998;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_35999_36095 = state_35959__$1;
(statearr_35999_36095[(1)] = (30));

} else {
var statearr_36000_36096 = state_35959__$1;
(statearr_36000_36096[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (44))){
var inst_35918 = (state_35959[(2)]);
var state_35959__$1 = (function (){var statearr_36001 = state_35959;
(statearr_36001[(15)] = inst_35918);

return statearr_36001;
})();
if(cljs.core.truth_(group_limit)){
var statearr_36002_36097 = state_35959__$1;
(statearr_36002_36097[(1)] = (45));

} else {
var statearr_36003_36098 = state_35959__$1;
(statearr_36003_36098[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (6))){
var inst_35831 = cljs.core.count.call(null,select);
var inst_35832 = cljs.core._EQ_.call(null,(1),inst_35831);
var state_35959__$1 = state_35959;
var statearr_36004_36099 = state_35959__$1;
(statearr_36004_36099[(2)] = inst_35832);

(statearr_36004_36099[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (28))){
var inst_35878 = (state_35959[(26)]);
var state_35959__$1 = state_35959;
var statearr_36005_36100 = state_35959__$1;
(statearr_36005_36100[(2)] = inst_35878);

(statearr_36005_36100[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (51))){
var inst_35867 = (state_35959[(10)]);
var inst_35866 = (state_35959[(11)]);
var inst_35935 = fluree.db.query.fql.order_result_tuples.call(null,fuel,max_fuel,inst_35866,orderBy,inst_35867);
var state_35959__$1 = state_35959;
var statearr_36006_36101 = state_35959__$1;
(statearr_36006_36101[(2)] = inst_35935);

(statearr_36006_36101[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (25))){
var state_35959__$1 = state_35959;
var statearr_36007_36102 = state_35959__$1;
(statearr_36007_36102[(2)] = null);

(statearr_36007_36102[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (34))){
var inst_35894 = (state_35959[(22)]);
var state_35959__$1 = state_35959;
var statearr_36008_36103 = state_35959__$1;
(statearr_36008_36103[(2)] = inst_35894);

(statearr_36008_36103[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (17))){
var inst_35857 = (state_35959[(2)]);
var state_35959__$1 = state_35959;
var statearr_36009_36104 = state_35959__$1;
(statearr_36009_36104[(2)] = inst_35857);

(statearr_36009_36104[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (3))){
var inst_35957 = (state_35959[(2)]);
var state_35959__$1 = state_35959;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35959__$1,inst_35957);
} else {
if((state_val_35960 === (12))){
var inst_35839 = (state_35959[(23)]);
var inst_35841 = cljs.core.first.call(null,select);
var inst_35842 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_35841);
var inst_35843 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35842);
var inst_35844 = cljs.core.subs.call(null,inst_35843,(1));
var inst_35845 = [inst_35844];
var inst_35846 = [inst_35839];
var inst_35847 = cljs.core.PersistentHashMap.fromArrays(inst_35845,inst_35846);
var state_35959__$1 = state_35959;
var statearr_36010_36105 = state_35959__$1;
(statearr_36010_36105[(2)] = inst_35847);

(statearr_36010_36105[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (2))){
var inst_35829 = (state_35959[(7)]);
var _ = (function (){var statearr_36011 = state_35959;
(statearr_36011[(4)] = cljs.core.cons.call(null,(5),(state_35959[(4)])));

return statearr_36011;
})();
var inst_35829__$1 = aggregates;
var state_35959__$1 = (function (){var statearr_36012 = state_35959;
(statearr_36012[(7)] = inst_35829__$1);

return statearr_36012;
})();
if(cljs.core.truth_(inst_35829__$1)){
var statearr_36013_36106 = state_35959__$1;
(statearr_36013_36106[(1)] = (6));

} else {
var statearr_36014_36107 = state_35959__$1;
(statearr_36014_36107[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (23))){
var inst_35873 = (state_35959[(2)]);
var state_35959__$1 = state_35959;
if(cljs.core.truth_(inst_35873)){
var statearr_36015_36108 = state_35959__$1;
(statearr_36015_36108[(1)] = (24));

} else {
var statearr_36016_36109 = state_35959__$1;
(statearr_36016_36109[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (47))){
var inst_35924 = (state_35959[(2)]);
var state_35959__$1 = (function (){var statearr_36017 = state_35959;
(statearr_36017[(20)] = inst_35924);

return statearr_36017;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_36018_36110 = state_35959__$1;
(statearr_36018_36110[(1)] = (48));

} else {
var statearr_36019_36111 = state_35959__$1;
(statearr_36019_36111[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (35))){
var inst_35900 = (state_35959[(2)]);
var state_35959__$1 = (function (){var statearr_36020 = state_35959;
(statearr_36020[(24)] = inst_35900);

return statearr_36020;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_36021_36112 = state_35959__$1;
(statearr_36021_36112[(1)] = (36));

} else {
var statearr_36022_36113 = state_35959__$1;
(statearr_36022_36113[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (19))){
var state_35959__$1 = state_35959;
var statearr_36023_36114 = state_35959__$1;
(statearr_36023_36114[(2)] = res);

(statearr_36023_36114[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (57))){
var inst_35888 = (state_35959[(18)]);
var inst_35944 = (state_35959[(12)]);
var inst_35883 = (state_35959[(19)]);
var inst_35946 = fluree.db.query.fql.pipeline_expandmaps_result.call(null,select,inst_35888,inst_35883,db,fuel,max_fuel,opts,(8),inst_35944);
var state_35959__$1 = state_35959;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35959__$1,(60),inst_35946);
} else {
if((state_val_35960 === (11))){
var inst_35954 = (state_35959[(2)]);
var _ = (function (){var statearr_36025 = state_35959;
(statearr_36025[(4)] = cljs.core.rest.call(null,(state_35959[(4)])));

return statearr_36025;
})();
var state_35959__$1 = state_35959;
var statearr_36026_36115 = state_35959__$1;
(statearr_36026_36115[(2)] = inst_35954);

(statearr_36026_36115[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (9))){
var inst_35837 = cljs.core.first.call(null,aggregates);
var inst_35838 = fluree.db.query.analytical.calculate_aggregate.call(null,res,inst_35837);
var inst_35839 = cljs.core.second.call(null,inst_35838);
var state_35959__$1 = (function (){var statearr_36027 = state_35959;
(statearr_36027[(23)] = inst_35839);

return statearr_36027;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_36028_36116 = state_35959__$1;
(statearr_36028_36116[(1)] = (12));

} else {
var statearr_36029_36117 = state_35959__$1;
(statearr_36029_36117[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (5))){
var _ = (function (){var statearr_36030 = state_35959;
(statearr_36030[(4)] = cljs.core.rest.call(null,(state_35959[(4)])));

return statearr_36030;
})();
var state_35959__$1 = state_35959;
var ex36024 = (state_35959__$1[(2)]);
var statearr_36031_36118 = state_35959__$1;
(statearr_36031_36118[(5)] = ex36024);


if((ex36024 instanceof Error)){
var statearr_36032_36119 = state_35959__$1;
(statearr_36032_36119[(1)] = (4));

(statearr_36032_36119[(5)] = null);

} else {
throw ex36024;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (14))){
var inst_35850 = (state_35959[(2)]);
var state_35959__$1 = (function (){var statearr_36033 = state_35959;
(statearr_36033[(17)] = inst_35850);

return statearr_36033;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_36034_36120 = state_35959__$1;
(statearr_36034_36120[(1)] = (15));

} else {
var statearr_36035_36121 = state_35959__$1;
(statearr_36035_36121[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (45))){
var inst_35918 = (state_35959[(15)]);
var inst_35920 = cljs.core.take.call(null,group_limit);
var inst_35921 = cljs.core.conj.call(null,inst_35918,inst_35920);
var state_35959__$1 = state_35959;
var statearr_36036_36122 = state_35959__$1;
(statearr_36036_36122[(2)] = inst_35921);

(statearr_36036_36122[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (53))){
var inst_35938 = (state_35959[(2)]);
var state_35959__$1 = (function (){var statearr_36037 = state_35959;
(statearr_36037[(13)] = inst_35938);

return statearr_36037;
})();
var statearr_36038_36123 = state_35959__$1;
(statearr_36038_36123[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (26))){
var inst_35878 = (state_35959[(26)]);
var inst_35877 = (state_35959[(2)]);
var inst_35878__$1 = cljs.core.not.call(null,prettyPrint);
var state_35959__$1 = (function (){var statearr_36040 = state_35959;
(statearr_36040[(21)] = inst_35877);

(statearr_36040[(26)] = inst_35878__$1);

return statearr_36040;
})();
if(inst_35878__$1){
var statearr_36041_36124 = state_35959__$1;
(statearr_36041_36124[(1)] = (27));

} else {
var statearr_36042_36125 = state_35959__$1;
(statearr_36042_36125[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (16))){
var inst_35850 = (state_35959[(17)]);
var state_35959__$1 = state_35959;
var statearr_36043_36126 = state_35959__$1;
(statearr_36043_36126[(2)] = inst_35850);

(statearr_36043_36126[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (38))){
var inst_35906 = (state_35959[(2)]);
var state_35959__$1 = (function (){var statearr_36044 = state_35959;
(statearr_36044[(14)] = inst_35906);

return statearr_36044;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_36045_36127 = state_35959__$1;
(statearr_36045_36127[(1)] = (39));

} else {
var statearr_36046_36128 = state_35959__$1;
(statearr_36046_36128[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (30))){
var inst_35885 = fluree.db.query.fql.get_pretty_print_keys.call(null,select);
var state_35959__$1 = state_35959;
var statearr_36047_36129 = state_35959__$1;
(statearr_36047_36129[(2)] = inst_35885);

(statearr_36047_36129[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (10))){
var state_35959__$1 = state_35959;
if(cljs.core.truth_(aggregates)){
var statearr_36048_36130 = state_35959__$1;
(statearr_36048_36130[(1)] = (18));

} else {
var statearr_36049_36131 = state_35959__$1;
(statearr_36049_36131[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (18))){
var inst_35861 = fluree.db.query.analytical.add_aggregate_cols.call(null,res,aggregates);
var state_35959__$1 = state_35959;
var statearr_36050_36132 = state_35959__$1;
(statearr_36050_36132[(2)] = inst_35861);

(statearr_36050_36132[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (52))){
var inst_35867 = (state_35959[(10)]);
var state_35959__$1 = state_35959;
var statearr_36051_36133 = state_35959__$1;
(statearr_36051_36133[(2)] = inst_35867);

(statearr_36051_36133[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (42))){
var inst_35912 = (state_35959[(25)]);
var inst_35877 = (state_35959[(21)]);
var inst_35914 = cljs.core.drop.call(null,inst_35877);
var inst_35915 = cljs.core.conj.call(null,inst_35912,inst_35914);
var state_35959__$1 = state_35959;
var statearr_36052_36134 = state_35959__$1;
(statearr_36052_36134[(2)] = inst_35915);

(statearr_36052_36134[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (37))){
var inst_35900 = (state_35959[(24)]);
var state_35959__$1 = state_35959;
var statearr_36053_36135 = state_35959__$1;
(statearr_36053_36135[(2)] = inst_35900);

(statearr_36053_36135[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (8))){
var inst_35835 = (state_35959[(2)]);
var state_35959__$1 = state_35959;
if(cljs.core.truth_(inst_35835)){
var statearr_36054_36136 = state_35959__$1;
(statearr_36054_36136[(1)] = (9));

} else {
var statearr_36055_36137 = state_35959__$1;
(statearr_36055_36137[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35960 === (49))){
var inst_35924 = (state_35959[(20)]);
var state_35959__$1 = state_35959;
var statearr_36056_36138 = state_35959__$1;
(statearr_36056_36138[(2)] = inst_35924);

(statearr_36056_36138[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__10945__auto__ = null;
var fluree$db$query$fql$state_machine__10945__auto____0 = (function (){
var statearr_36057 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36057[(0)] = fluree$db$query$fql$state_machine__10945__auto__);

(statearr_36057[(1)] = (1));

return statearr_36057;
});
var fluree$db$query$fql$state_machine__10945__auto____1 = (function (state_35959){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_35959);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e36058){var ex__10948__auto__ = e36058;
var statearr_36059_36139 = state_35959;
(statearr_36059_36139[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_35959[(4)]))){
var statearr_36060_36140 = state_35959;
(statearr_36060_36140[(1)] = cljs.core.first.call(null,(state_35959[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36141 = state_35959;
state_35959 = G__36141;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__10945__auto__ = function(state_35959){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__10945__auto____1.call(this,state_35959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__10945__auto____0;
fluree$db$query$fql$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__10945__auto____1;
return fluree$db$query$fql$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_36061 = f__11019__auto__.call(null);
(statearr_36061[(6)] = c__11018__auto__);

return statearr_36061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__36144,groupBy){
var map__36145 = p__36144;
var map__36145__$1 = cljs.core.__destructure_map.call(null,map__36145);
var res = map__36145__$1;
var headers = cljs.core.get.call(null,map__36145__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__36145__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__36146 = ((cljs.core.vector_QMARK_.call(null,groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.call(null,cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,groupBy)], null)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.call(null,vec__36146,(0),null);
var groupBy__$1 = cljs.core.nth.call(null,vec__36146,(1),null);
var group_idxs = cljs.core.map.call(null,(function (p1__36142_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__36142_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some.call(null,cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.call(null,(function (res__$1,tuple){
var k = cljs.core.map.call(null,(function (p1__36143_SHARP_){
return cljs.core.nth.call(null,tuple,p1__36143_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,k):cljs.core.first.call(null,k));
var v = tuple;
return cljs.core.assoc.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.conj.call(null,cljs.core.get.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__36149 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.call(null,vec__36149,(0),null);
var sortCriteria = cljs.core.nth.call(null,vec__36149,(1),null);
if(cljs.core._EQ_.call(null,sortCriteria,groupBy)){
if(cljs.core._EQ_.call(null,sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_.call(null,groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of.call(null,groupBy,sortCriteria);
if(cljs.core._EQ_.call(null,"DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__36152,p__36153,opts){
var map__36154 = p__36152;
var map__36154__$1 = cljs.core.__destructure_map.call(null,map__36154);
var res = map__36154__$1;
var headers = cljs.core.get.call(null,map__36154__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__36154__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__36155 = p__36153;
var map__36155__$1 = cljs.core.__destructure_map.call(null,map__36155);
var select_spec = map__36155__$1;
var groupBy = cljs.core.get.call(null,map__36155__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.call(null,map__36155__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.call(null,map__36155__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.call(null,map__36155__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__36155__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.call(null,map__36155__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.call(null,map__36155__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_36397){
var state_val_36398 = (state_36397[(1)]);
if((state_val_36398 === (65))){
var state_36397__$1 = state_36397;
var statearr_36399_36550 = state_36397__$1;
(statearr_36399_36550[(1)] = (67));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (70))){
var inst_36318 = (state_36397[(7)]);
var state_36397__$1 = state_36397;
var statearr_36401_36551 = state_36397__$1;
(statearr_36401_36551[(2)] = inst_36318);

(statearr_36401_36551[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (62))){
var state_36397__$1 = state_36397;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_36402_36552 = state_36397__$1;
(statearr_36402_36552[(1)] = (64));

} else {
var statearr_36403_36553 = state_36397__$1;
(statearr_36403_36553[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (74))){
var inst_36293 = (state_36397[(8)]);
var inst_36234 = (state_36397[(9)]);
var inst_36225 = (state_36397[(10)]);
var inst_36326 = cljs.core.assoc.call(null,inst_36225,inst_36234,inst_36293);
var state_36397__$1 = state_36397;
var statearr_36404_36554 = state_36397__$1;
(statearr_36404_36554[(2)] = inst_36326);

(statearr_36404_36554[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (7))){
var state_36397__$1 = state_36397;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_36405_36555 = state_36397__$1;
(statearr_36405_36555[(1)] = (82));

} else {
var statearr_36406_36556 = state_36397__$1;
(statearr_36406_36556[(1)] = (83));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (59))){
var inst_36293 = (state_36397[(8)]);
var inst_36223 = (state_36397[(11)]);
var inst_36297 = cljs.core.count.call(null,inst_36293);
var inst_36298 = (inst_36223 - inst_36297);
var state_36397__$1 = state_36397;
var statearr_36407_36557 = state_36397__$1;
(statearr_36407_36557[(2)] = inst_36298);

(statearr_36407_36557[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (86))){
var state_36397__$1 = state_36397;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_36408_36558 = state_36397__$1;
(statearr_36408_36558[(1)] = (89));

} else {
var statearr_36409_36559 = state_36397__$1;
(statearr_36409_36559[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (20))){
var state_36397__$1 = state_36397;
var statearr_36410_36560 = state_36397__$1;
(statearr_36410_36560[(2)] = (0));

(statearr_36410_36560[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (72))){
var inst_36323 = (state_36397[(2)]);
var state_36397__$1 = state_36397;
if(cljs.core.truth_(inst_36323)){
var statearr_36411_36561 = state_36397__$1;
(statearr_36411_36561[(1)] = (73));

} else {
var statearr_36412_36562 = state_36397__$1;
(statearr_36412_36562[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (58))){
var state_36397__$1 = state_36397;
var statearr_36413_36563 = state_36397__$1;
(statearr_36413_36563[(2)] = null);

(statearr_36413_36563[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (60))){
var inst_36224 = (state_36397[(12)]);
var inst_36300 = (state_36397[(2)]);
var inst_36301 = (inst_36224 <= (0));
var state_36397__$1 = (function (){var statearr_36414 = state_36397;
(statearr_36414[(13)] = inst_36300);

return statearr_36414;
})();
if(cljs.core.truth_(inst_36301)){
var statearr_36415_36564 = state_36397__$1;
(statearr_36415_36564[(1)] = (61));

} else {
var statearr_36416_36565 = state_36397__$1;
(statearr_36416_36565[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (27))){
var inst_36223 = (state_36397[(11)]);
var inst_36247 = (inst_36223 < (1));
var state_36397__$1 = state_36397;
var statearr_36417_36566 = state_36397__$1;
(statearr_36417_36566[(2)] = inst_36247);

(statearr_36417_36566[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (1))){
var state_36397__$1 = state_36397;
var statearr_36418_36567 = state_36397__$1;
(statearr_36418_36567[(2)] = null);

(statearr_36418_36567[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (69))){
var inst_36313 = (state_36397[(2)]);
var state_36397__$1 = state_36397;
var statearr_36419_36568 = state_36397__$1;
(statearr_36419_36568[(2)] = inst_36313);

(statearr_36419_36568[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (24))){
var inst_36225 = (state_36397[(10)]);
var state_36397__$1 = state_36397;
var statearr_36420_36569 = state_36397__$1;
(statearr_36420_36569[(2)] = inst_36225);

(statearr_36420_36569[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (55))){
var inst_36223 = (state_36397[(11)]);
var inst_36283 = (state_36397[(14)]);
var inst_36290 = cljs.core.take.call(null,inst_36223,inst_36283);
var state_36397__$1 = state_36397;
var statearr_36421_36570 = state_36397__$1;
(statearr_36421_36570[(2)] = inst_36290);

(statearr_36421_36570[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (85))){
var inst_36368 = (state_36397[(15)]);
var inst_36367 = (state_36397[(2)]);
var inst_36368__$1 = fluree.db.util.async.throw_err.call(null,inst_36367);
var inst_36369 = cljs.core.coll_QMARK_.call(null,inst_36368__$1);
var inst_36370 = (!(inst_36369));
var state_36397__$1 = (function (){var statearr_36422 = state_36397;
(statearr_36422[(15)] = inst_36368__$1);

return statearr_36422;
})();
if(inst_36370){
var statearr_36423_36571 = state_36397__$1;
(statearr_36423_36571[(1)] = (86));

} else {
var statearr_36424_36572 = state_36397__$1;
(statearr_36424_36572[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (39))){
var inst_36242 = (state_36397[(16)]);
var inst_36264 = cljs.core.assoc.call(null,select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_36265 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_36266 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,inst_36242,inst_36264,inst_36265);
var state_36397__$1 = state_36397;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36397__$1,(42),inst_36266);
} else {
if((state_val_36398 === (88))){
var inst_36390 = (state_36397[(2)]);
var state_36397__$1 = state_36397;
var statearr_36425_36573 = state_36397__$1;
(statearr_36425_36573[(2)] = inst_36390);

(statearr_36425_36573[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (46))){
var inst_36224 = (state_36397[(12)]);
var inst_36278 = ((0) < inst_36224);
var state_36397__$1 = state_36397;
if(cljs.core.truth_(inst_36278)){
var statearr_36426_36574 = state_36397__$1;
(statearr_36426_36574[(1)] = (49));

} else {
var statearr_36427_36575 = state_36397__$1;
(statearr_36427_36575[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (4))){
var inst_36156 = (state_36397[(2)]);
var state_36397__$1 = state_36397;
var statearr_36428_36576 = state_36397__$1;
(statearr_36428_36576[(2)] = inst_36156);

(statearr_36428_36576[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (77))){
var inst_36223 = (state_36397[(11)]);
var inst_36334 = (inst_36223 - (1));
var state_36397__$1 = state_36397;
var statearr_36429_36577 = state_36397__$1;
(statearr_36429_36577[(2)] = inst_36334);

(statearr_36429_36577[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (95))){
var inst_36368 = (state_36397[(15)]);
var state_36397__$1 = state_36397;
var statearr_36430_36578 = state_36397__$1;
(statearr_36430_36578[(2)] = inst_36368);

(statearr_36430_36578[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (54))){
var inst_36288 = (state_36397[(2)]);
var state_36397__$1 = state_36397;
if(cljs.core.truth_(inst_36288)){
var statearr_36431_36579 = state_36397__$1;
(statearr_36431_36579[(1)] = (55));

} else {
var statearr_36432_36580 = state_36397__$1;
(statearr_36432_36580[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (92))){
var inst_36368 = (state_36397[(15)]);
var inst_36381 = cljs.core.first.call(null,inst_36368);
var state_36397__$1 = state_36397;
var statearr_36433_36581 = state_36397__$1;
(statearr_36433_36581[(2)] = inst_36381);

(statearr_36433_36581[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (15))){
var inst_36174 = (state_36397[(17)]);
var inst_36182 = (state_36397[(2)]);
var inst_36183 = fluree.db.util.async.throw_err.call(null,inst_36182);
var inst_36184 = [inst_36174];
var inst_36185 = [inst_36183];
var inst_36186 = cljs.core.PersistentHashMap.fromArrays(inst_36184,inst_36185);
var state_36397__$1 = state_36397;
var statearr_36434_36582 = state_36397__$1;
(statearr_36434_36582[(2)] = inst_36186);

(statearr_36434_36582[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (48))){
var inst_36346 = (state_36397[(2)]);
var state_36397__$1 = state_36397;
var statearr_36435_36583 = state_36397__$1;
(statearr_36435_36583[(2)] = inst_36346);

(statearr_36435_36583[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (50))){
var inst_36269 = (state_36397[(18)]);
var state_36397__$1 = state_36397;
var statearr_36436_36584 = state_36397__$1;
(statearr_36436_36584[(2)] = inst_36269);

(statearr_36436_36584[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (75))){
var inst_36235 = (state_36397[(19)]);
var inst_36238 = (state_36397[(20)]);
var inst_36317 = (state_36397[(21)]);
var inst_36300 = (state_36397[(13)]);
var inst_36328 = (state_36397[(2)]);
var inst_36221 = inst_36235;
var inst_36222 = inst_36238;
var inst_36223 = inst_36300;
var inst_36224 = inst_36317;
var inst_36225 = inst_36328;
var state_36397__$1 = (function (){var statearr_36437 = state_36397;
(statearr_36437[(12)] = inst_36224);

(statearr_36437[(22)] = inst_36222);

(statearr_36437[(23)] = inst_36221);

(statearr_36437[(11)] = inst_36223);

(statearr_36437[(10)] = inst_36225);

return statearr_36437;
})();
var statearr_36438_36585 = state_36397__$1;
(statearr_36438_36585[(2)] = null);

(statearr_36438_36585[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (21))){
var inst_36206 = (state_36397[(24)]);
var inst_36202 = (state_36397[(25)]);
var inst_36214 = (state_36397[(26)]);
var inst_36219 = (state_36397[(2)]);
var inst_36220 = cljs.core.PersistentHashMap.EMPTY;
var inst_36221 = inst_36202;
var inst_36222 = inst_36206;
var inst_36223 = inst_36214;
var inst_36224 = inst_36219;
var inst_36225 = inst_36220;
var state_36397__$1 = (function (){var statearr_36439 = state_36397;
(statearr_36439[(12)] = inst_36224);

(statearr_36439[(22)] = inst_36222);

(statearr_36439[(23)] = inst_36221);

(statearr_36439[(11)] = inst_36223);

(statearr_36439[(10)] = inst_36225);

return statearr_36439;
})();
var statearr_36440_36586 = state_36397__$1;
(statearr_36440_36586[(2)] = null);

(statearr_36440_36586[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (31))){
var inst_36224 = (state_36397[(12)]);
var inst_36239 = (state_36397[(27)]);
var inst_36253 = (inst_36224 >= inst_36239);
var state_36397__$1 = state_36397;
if(cljs.core.truth_(inst_36253)){
var statearr_36441_36587 = state_36397__$1;
(statearr_36441_36587[(1)] = (33));

} else {
var statearr_36442_36588 = state_36397__$1;
(statearr_36442_36588[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (32))){
var inst_36353 = (state_36397[(2)]);
var state_36397__$1 = state_36397;
var statearr_36443_36589 = state_36397__$1;
(statearr_36443_36589[(2)] = inst_36353);

(statearr_36443_36589[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (40))){
var state_36397__$1 = state_36397;
var statearr_36444_36590 = state_36397__$1;
(statearr_36444_36590[(2)] = null);

(statearr_36444_36590[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (91))){
var inst_36378 = (state_36397[(2)]);
var state_36397__$1 = state_36397;
var statearr_36445_36591 = state_36397__$1;
(statearr_36445_36591[(2)] = inst_36378);

(statearr_36445_36591[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (56))){
var inst_36283 = (state_36397[(14)]);
var state_36397__$1 = state_36397;
var statearr_36446_36592 = state_36397__$1;
(statearr_36446_36592[(2)] = inst_36283);

(statearr_36446_36592[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (33))){
var state_36397__$1 = state_36397;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_36447_36593 = state_36397__$1;
(statearr_36447_36593[(1)] = (36));

} else {
var statearr_36448_36594 = state_36397__$1;
(statearr_36448_36594[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (13))){
var inst_36206 = (state_36397[(24)]);
var inst_36171 = (state_36397[(28)]);
var inst_36202 = (state_36397[(25)]);
var inst_36202__$1 = cljs.core.keys.call(null,inst_36171);
var inst_36203 = cljs.core.seq.call(null,inst_36202__$1);
var inst_36204 = cljs.core.first.call(null,inst_36203);
var inst_36205 = cljs.core.next.call(null,inst_36203);
var inst_36206__$1 = cljs.core.vals.call(null,inst_36171);
var inst_36207 = cljs.core.seq.call(null,inst_36206__$1);
var inst_36208 = cljs.core.first.call(null,inst_36207);
var inst_36209 = cljs.core.next.call(null,inst_36207);
var inst_36210 = cljs.core._EQ_.call(null,(0),limit);
var state_36397__$1 = (function (){var statearr_36449 = state_36397;
(statearr_36449[(24)] = inst_36206__$1);

(statearr_36449[(29)] = inst_36208);

(statearr_36449[(30)] = inst_36205);

(statearr_36449[(31)] = inst_36209);

(statearr_36449[(25)] = inst_36202__$1);

(statearr_36449[(32)] = inst_36204);

return statearr_36449;
})();
if(inst_36210){
var statearr_36450_36595 = state_36397__$1;
(statearr_36450_36595[(1)] = (16));

} else {
var statearr_36451_36596 = state_36397__$1;
(statearr_36451_36596[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (22))){
var inst_36222 = (state_36397[(22)]);
var inst_36221 = (state_36397[(23)]);
var inst_36233 = cljs.core.seq.call(null,inst_36221);
var inst_36234 = cljs.core.first.call(null,inst_36233);
var inst_36235 = cljs.core.next.call(null,inst_36233);
var inst_36236 = cljs.core.seq.call(null,inst_36222);
var inst_36237 = cljs.core.first.call(null,inst_36236);
var inst_36238 = cljs.core.next.call(null,inst_36236);
var inst_36239 = cljs.core.count.call(null,inst_36237);
var inst_36240 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_36241 = [headers,vars,inst_36237];
var inst_36242 = cljs.core.PersistentHashMap.fromArrays(inst_36240,inst_36241);
var inst_36243 = (inst_36237 == null);
var state_36397__$1 = (function (){var statearr_36452 = state_36397;
(statearr_36452[(9)] = inst_36234);

(statearr_36452[(19)] = inst_36235);

(statearr_36452[(20)] = inst_36238);

(statearr_36452[(27)] = inst_36239);

(statearr_36452[(16)] = inst_36242);

return statearr_36452;
})();
if(cljs.core.truth_(inst_36243)){
var statearr_36453_36597 = state_36397__$1;
(statearr_36453_36597[(1)] = (24));

} else {
var statearr_36454_36598 = state_36397__$1;
(statearr_36454_36598[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (90))){
var inst_36368 = (state_36397[(15)]);
var state_36397__$1 = state_36397;
var statearr_36455_36599 = state_36397__$1;
(statearr_36455_36599[(2)] = inst_36368);

(statearr_36455_36599[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (36))){
var inst_36224 = (state_36397[(12)]);
var inst_36256 = (inst_36224 - (1));
var state_36397__$1 = state_36397;
var statearr_36456_36600 = state_36397__$1;
(statearr_36456_36600[(2)] = inst_36256);

(statearr_36456_36600[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (41))){
var inst_36349 = (state_36397[(2)]);
var state_36397__$1 = state_36397;
var statearr_36457_36601 = state_36397__$1;
(statearr_36457_36601[(2)] = inst_36349);

(statearr_36457_36601[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (89))){
var inst_36368 = (state_36397[(15)]);
var inst_36373 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36374 = [inst_36368];
var inst_36375 = (new cljs.core.PersistentVector(null,1,(5),inst_36373,inst_36374,null));
var state_36397__$1 = state_36397;
var statearr_36458_36602 = state_36397__$1;
(statearr_36458_36602[(2)] = inst_36375);

(statearr_36458_36602[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (43))){
var inst_36269 = (state_36397[(18)]);
var inst_36272 = cljs.core.seq.call(null,inst_36269);
var state_36397__$1 = state_36397;
var statearr_36459_36603 = state_36397__$1;
(statearr_36459_36603[(2)] = inst_36272);

(statearr_36459_36603[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (61))){
var state_36397__$1 = state_36397;
var statearr_36460_36604 = state_36397__$1;
(statearr_36460_36604[(2)] = (0));

(statearr_36460_36604[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (29))){
var inst_36250 = (state_36397[(2)]);
var state_36397__$1 = state_36397;
if(cljs.core.truth_(inst_36250)){
var statearr_36461_36605 = state_36397__$1;
(statearr_36461_36605[(1)] = (30));

} else {
var statearr_36462_36606 = state_36397__$1;
(statearr_36462_36606[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (44))){
var inst_36270 = (state_36397[(33)]);
var state_36397__$1 = state_36397;
var statearr_36463_36607 = state_36397__$1;
(statearr_36463_36607[(2)] = inst_36270);

(statearr_36463_36607[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (93))){
var state_36397__$1 = state_36397;
var statearr_36464_36608 = state_36397__$1;
(statearr_36464_36608[(1)] = (95));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (6))){
var inst_36163 = (state_36397[(34)]);
var inst_36163__$1 = fluree.db.query.fql.build_order_fn.call(null,orderBy,groupBy);
var inst_36165 = fluree.db.query.fql.ad_hoc_group_by.call(null,res,groupBy);
var state_36397__$1 = (function (){var statearr_36466 = state_36397;
(statearr_36466[(35)] = inst_36165);

(statearr_36466[(34)] = inst_36163__$1);

return statearr_36466;
})();
if(cljs.core.truth_(inst_36163__$1)){
var statearr_36467_36609 = state_36397__$1;
(statearr_36467_36609[(1)] = (9));

} else {
var statearr_36468_36610 = state_36397__$1;
(statearr_36468_36610[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (28))){
var inst_36223 = (state_36397[(11)]);
var state_36397__$1 = state_36397;
var statearr_36469_36611 = state_36397__$1;
(statearr_36469_36611[(2)] = inst_36223);

(statearr_36469_36611[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (64))){
var inst_36224 = (state_36397[(12)]);
var inst_36305 = (inst_36224 - (1));
var state_36397__$1 = state_36397;
var statearr_36470_36612 = state_36397__$1;
(statearr_36470_36612[(2)] = inst_36305);

(statearr_36470_36612[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (51))){
var inst_36223 = (state_36397[(11)]);
var inst_36283 = (state_36397[(2)]);
var state_36397__$1 = (function (){var statearr_36471 = state_36397;
(statearr_36471[(14)] = inst_36283);

return statearr_36471;
})();
if(cljs.core.truth_(inst_36223)){
var statearr_36472_36613 = state_36397__$1;
(statearr_36472_36613[(1)] = (52));

} else {
var statearr_36473_36614 = state_36397__$1;
(statearr_36473_36614[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (25))){
var inst_36223 = (state_36397[(11)]);
var state_36397__$1 = state_36397;
if(cljs.core.truth_(inst_36223)){
var statearr_36474_36615 = state_36397__$1;
(statearr_36474_36615[(1)] = (27));

} else {
var statearr_36475_36616 = state_36397__$1;
(statearr_36475_36616[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (34))){
var state_36397__$1 = state_36397;
var statearr_36476_36617 = state_36397__$1;
(statearr_36476_36617[(1)] = (39));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (17))){
var state_36397__$1 = state_36397;
var statearr_36478_36618 = state_36397__$1;
(statearr_36478_36618[(2)] = limit);

(statearr_36478_36618[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (3))){
var inst_36395 = (state_36397[(2)]);
var state_36397__$1 = state_36397;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36397__$1,inst_36395);
} else {
if((state_val_36398 === (12))){
var inst_36171 = (state_36397[(28)]);
var inst_36173 = cljs.core.keys.call(null,inst_36171);
var inst_36174 = cljs.core.first.call(null,inst_36173);
var inst_36175 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_36176 = cljs.core.vals.call(null,inst_36171);
var inst_36177 = cljs.core.first.call(null,inst_36176);
var inst_36178 = [headers,vars,inst_36177];
var inst_36179 = cljs.core.PersistentHashMap.fromArrays(inst_36175,inst_36178);
var inst_36180 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,inst_36179,select_spec,limit,opts);
var state_36397__$1 = (function (){var statearr_36479 = state_36397;
(statearr_36479[(17)] = inst_36174);

return statearr_36479;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36397__$1,(15),inst_36180);
} else {
if((state_val_36398 === (2))){
var _ = (function (){var statearr_36480 = state_36397;
(statearr_36480[(4)] = cljs.core.cons.call(null,(5),(state_36397[(4)])));

return statearr_36480;
})();
var state_36397__$1 = state_36397;
if(cljs.core.truth_(groupBy)){
var statearr_36481_36619 = state_36397__$1;
(statearr_36481_36619[(1)] = (6));

} else {
var statearr_36482_36620 = state_36397__$1;
(statearr_36482_36620[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (66))){
var inst_36315 = (state_36397[(2)]);
var state_36397__$1 = state_36397;
var statearr_36483_36621 = state_36397__$1;
(statearr_36483_36621[(2)] = inst_36315);

(statearr_36483_36621[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (23))){
var inst_36357 = (state_36397[(2)]);
var state_36397__$1 = state_36397;
var statearr_36484_36622 = state_36397__$1;
(statearr_36484_36622[(2)] = inst_36357);

(statearr_36484_36622[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (47))){
var inst_36223 = (state_36397[(11)]);
var inst_36331 = (inst_36223 == null);
var state_36397__$1 = state_36397;
if(cljs.core.truth_(inst_36331)){
var statearr_36485_36623 = state_36397__$1;
(statearr_36485_36623[(1)] = (76));

} else {
var statearr_36486_36624 = state_36397__$1;
(statearr_36486_36624[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (35))){
var inst_36351 = (state_36397[(2)]);
var state_36397__$1 = state_36397;
var statearr_36487_36625 = state_36397__$1;
(statearr_36487_36625[(2)] = inst_36351);

(statearr_36487_36625[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (82))){
var state_36397__$1 = state_36397;
var statearr_36488_36626 = state_36397__$1;
(statearr_36488_36626[(2)] = (1));

(statearr_36488_36626[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (76))){
var state_36397__$1 = state_36397;
var statearr_36489_36627 = state_36397__$1;
(statearr_36489_36627[(2)] = null);

(statearr_36489_36627[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (97))){
var inst_36386 = (state_36397[(2)]);
var state_36397__$1 = state_36397;
var statearr_36490_36628 = state_36397__$1;
(statearr_36490_36628[(2)] = inst_36386);

(statearr_36490_36628[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (19))){
var inst_36215 = (state_36397[(36)]);
var state_36397__$1 = state_36397;
var statearr_36491_36629 = state_36397__$1;
(statearr_36491_36629[(2)] = inst_36215);

(statearr_36491_36629[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (57))){
var inst_36223 = (state_36397[(11)]);
var inst_36293 = (state_36397[(2)]);
var inst_36294 = (inst_36223 == null);
var state_36397__$1 = (function (){var statearr_36492 = state_36397;
(statearr_36492[(8)] = inst_36293);

return statearr_36492;
})();
if(cljs.core.truth_(inst_36294)){
var statearr_36493_36630 = state_36397__$1;
(statearr_36493_36630[(1)] = (58));

} else {
var statearr_36494_36631 = state_36397__$1;
(statearr_36494_36631[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (68))){
var state_36397__$1 = state_36397;
var statearr_36495_36632 = state_36397__$1;
(statearr_36495_36632[(2)] = null);

(statearr_36495_36632[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (11))){
var inst_36171 = (state_36397[(2)]);
var state_36397__$1 = (function (){var statearr_36497 = state_36397;
(statearr_36497[(28)] = inst_36171);

return statearr_36497;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_36498_36633 = state_36397__$1;
(statearr_36498_36633[(1)] = (12));

} else {
var statearr_36499_36634 = state_36397__$1;
(statearr_36499_36634[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (9))){
var inst_36165 = (state_36397[(35)]);
var inst_36163 = (state_36397[(34)]);
var inst_36167 = cljs.core.sorted_map_by.call(null,inst_36163);
var inst_36168 = cljs.core.into.call(null,inst_36167,inst_36165);
var state_36397__$1 = state_36397;
var statearr_36500_36635 = state_36397__$1;
(statearr_36500_36635[(2)] = inst_36168);

(statearr_36500_36635[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (5))){
var _ = (function (){var statearr_36501 = state_36397;
(statearr_36501[(4)] = cljs.core.rest.call(null,(state_36397[(4)])));

return statearr_36501;
})();
var state_36397__$1 = state_36397;
var ex36496 = (state_36397__$1[(2)]);
var statearr_36502_36636 = state_36397__$1;
(statearr_36502_36636[(5)] = ex36496);


if((ex36496 instanceof Error)){
var statearr_36503_36637 = state_36397__$1;
(statearr_36503_36637[(1)] = (4));

(statearr_36503_36637[(5)] = null);

} else {
throw ex36496;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (83))){
var state_36397__$1 = state_36397;
var statearr_36504_36638 = state_36397__$1;
(statearr_36504_36638[(2)] = limit);

(statearr_36504_36638[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (14))){
var inst_36359 = (state_36397[(2)]);
var state_36397__$1 = state_36397;
var statearr_36505_36639 = state_36397__$1;
(statearr_36505_36639[(2)] = inst_36359);

(statearr_36505_36639[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (45))){
var inst_36275 = (state_36397[(2)]);
var state_36397__$1 = state_36397;
if(cljs.core.truth_(inst_36275)){
var statearr_36506_36640 = state_36397__$1;
(statearr_36506_36640[(1)] = (46));

} else {
var statearr_36507_36641 = state_36397__$1;
(statearr_36507_36641[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (53))){
var inst_36223 = (state_36397[(11)]);
var state_36397__$1 = state_36397;
var statearr_36508_36642 = state_36397__$1;
(statearr_36508_36642[(2)] = inst_36223);

(statearr_36508_36642[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (78))){
var inst_36224 = (state_36397[(12)]);
var inst_36336 = (state_36397[(2)]);
var inst_36337 = (inst_36224 <= (0));
var state_36397__$1 = (function (){var statearr_36509 = state_36397;
(statearr_36509[(37)] = inst_36336);

return statearr_36509;
})();
if(cljs.core.truth_(inst_36337)){
var statearr_36510_36643 = state_36397__$1;
(statearr_36510_36643[(1)] = (79));

} else {
var statearr_36511_36644 = state_36397__$1;
(statearr_36511_36644[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (26))){
var inst_36355 = (state_36397[(2)]);
var state_36397__$1 = state_36397;
var statearr_36512_36645 = state_36397__$1;
(statearr_36512_36645[(2)] = inst_36355);

(statearr_36512_36645[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (16))){
var state_36397__$1 = state_36397;
var statearr_36513_36646 = state_36397__$1;
(statearr_36513_36646[(2)] = null);

(statearr_36513_36646[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (81))){
var inst_36234 = (state_36397[(9)]);
var inst_36235 = (state_36397[(19)]);
var inst_36269 = (state_36397[(18)]);
var inst_36336 = (state_36397[(37)]);
var inst_36238 = (state_36397[(20)]);
var inst_36225 = (state_36397[(10)]);
var inst_36342 = (state_36397[(2)]);
var inst_36343 = cljs.core.assoc.call(null,inst_36225,inst_36234,inst_36269);
var inst_36221 = inst_36235;
var inst_36222 = inst_36238;
var inst_36223 = inst_36336;
var inst_36224 = inst_36342;
var inst_36225__$1 = inst_36343;
var state_36397__$1 = (function (){var statearr_36516 = state_36397;
(statearr_36516[(12)] = inst_36224);

(statearr_36516[(22)] = inst_36222);

(statearr_36516[(23)] = inst_36221);

(statearr_36516[(11)] = inst_36223);

(statearr_36516[(10)] = inst_36225__$1);

return statearr_36516;
})();
var statearr_36517_36647 = state_36397__$1;
(statearr_36517_36647[(2)] = null);

(statearr_36517_36647[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (79))){
var state_36397__$1 = state_36397;
var statearr_36518_36648 = state_36397__$1;
(statearr_36518_36648[(2)] = (0));

(statearr_36518_36648[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (38))){
var inst_36235 = (state_36397[(19)]);
var inst_36223 = (state_36397[(11)]);
var inst_36238 = (state_36397[(20)]);
var inst_36225 = (state_36397[(10)]);
var inst_36260 = (state_36397[(2)]);
var tmp36514 = inst_36223;
var tmp36515 = inst_36225;
var inst_36221 = inst_36235;
var inst_36222 = inst_36238;
var inst_36223__$1 = tmp36514;
var inst_36224 = inst_36260;
var inst_36225__$1 = tmp36515;
var state_36397__$1 = (function (){var statearr_36519 = state_36397;
(statearr_36519[(12)] = inst_36224);

(statearr_36519[(22)] = inst_36222);

(statearr_36519[(23)] = inst_36221);

(statearr_36519[(11)] = inst_36223__$1);

(statearr_36519[(10)] = inst_36225__$1);

return statearr_36519;
})();
var statearr_36520_36649 = state_36397__$1;
(statearr_36520_36649[(2)] = null);

(statearr_36520_36649[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (87))){
var state_36397__$1 = state_36397;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_36521_36650 = state_36397__$1;
(statearr_36521_36650[(1)] = (92));

} else {
var statearr_36522_36651 = state_36397__$1;
(statearr_36522_36651[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (30))){
var inst_36225 = (state_36397[(10)]);
var state_36397__$1 = state_36397;
var statearr_36523_36652 = state_36397__$1;
(statearr_36523_36652[(2)] = inst_36225);

(statearr_36523_36652[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (73))){
var inst_36225 = (state_36397[(10)]);
var state_36397__$1 = state_36397;
var statearr_36524_36653 = state_36397__$1;
(statearr_36524_36653[(2)] = inst_36225);

(statearr_36524_36653[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (96))){
var state_36397__$1 = state_36397;
var statearr_36525_36654 = state_36397__$1;
(statearr_36525_36654[(2)] = null);

(statearr_36525_36654[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (10))){
var inst_36165 = (state_36397[(35)]);
var state_36397__$1 = state_36397;
var statearr_36526_36655 = state_36397__$1;
(statearr_36526_36655[(2)] = inst_36165);

(statearr_36526_36655[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (18))){
var inst_36215 = (state_36397[(36)]);
var inst_36214 = (state_36397[(2)]);
var inst_36215__$1 = offset;
var state_36397__$1 = (function (){var statearr_36527 = state_36397;
(statearr_36527[(36)] = inst_36215__$1);

(statearr_36527[(26)] = inst_36214);

return statearr_36527;
})();
if(cljs.core.truth_(inst_36215__$1)){
var statearr_36528_36656 = state_36397__$1;
(statearr_36528_36656[(1)] = (19));

} else {
var statearr_36529_36657 = state_36397__$1;
(statearr_36529_36657[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (52))){
var inst_36223 = (state_36397[(11)]);
var inst_36285 = ((0) < inst_36223);
var state_36397__$1 = state_36397;
var statearr_36530_36658 = state_36397__$1;
(statearr_36530_36658[(2)] = inst_36285);

(statearr_36530_36658[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (67))){
var inst_36224 = (state_36397[(12)]);
var inst_36293 = (state_36397[(8)]);
var inst_36239 = (state_36397[(27)]);
var inst_36308 = cljs.core.count.call(null,inst_36293);
var inst_36309 = (inst_36239 - inst_36308);
var inst_36310 = (inst_36224 - inst_36309);
var state_36397__$1 = state_36397;
var statearr_36531_36659 = state_36397__$1;
(statearr_36531_36659[(2)] = inst_36310);

(statearr_36531_36659[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (71))){
var inst_36293 = (state_36397[(8)]);
var inst_36321 = cljs.core.empty_QMARK_.call(null,inst_36293);
var state_36397__$1 = state_36397;
var statearr_36532_36660 = state_36397__$1;
(statearr_36532_36660[(2)] = inst_36321);

(statearr_36532_36660[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (42))){
var inst_36269 = (state_36397[(18)]);
var inst_36270 = (state_36397[(33)]);
var inst_36268 = (state_36397[(2)]);
var inst_36269__$1 = fluree.db.util.async.throw_err.call(null,inst_36268);
var inst_36270__$1 = cljs.core.coll_QMARK_.call(null,inst_36269__$1);
var state_36397__$1 = (function (){var statearr_36533 = state_36397;
(statearr_36533[(18)] = inst_36269__$1);

(statearr_36533[(33)] = inst_36270__$1);

return statearr_36533;
})();
if(inst_36270__$1){
var statearr_36534_36661 = state_36397__$1;
(statearr_36534_36661[(1)] = (43));

} else {
var statearr_36535_36662 = state_36397__$1;
(statearr_36535_36662[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (80))){
var inst_36224 = (state_36397[(12)]);
var inst_36340 = (inst_36224 - (1));
var state_36397__$1 = state_36397;
var statearr_36536_36663 = state_36397__$1;
(statearr_36536_36663[(2)] = inst_36340);

(statearr_36536_36663[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (37))){
var inst_36224 = (state_36397[(12)]);
var inst_36239 = (state_36397[(27)]);
var inst_36258 = (inst_36224 - inst_36239);
var state_36397__$1 = state_36397;
var statearr_36537_36664 = state_36397__$1;
(statearr_36537_36664[(2)] = inst_36258);

(statearr_36537_36664[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (63))){
var inst_36318 = (state_36397[(7)]);
var inst_36293 = (state_36397[(8)]);
var inst_36317 = (state_36397[(2)]);
var inst_36318__$1 = (inst_36293 == null);
var state_36397__$1 = (function (){var statearr_36538 = state_36397;
(statearr_36538[(7)] = inst_36318__$1);

(statearr_36538[(21)] = inst_36317);

return statearr_36538;
})();
if(cljs.core.truth_(inst_36318__$1)){
var statearr_36539_36665 = state_36397__$1;
(statearr_36539_36665[(1)] = (70));

} else {
var statearr_36540_36666 = state_36397__$1;
(statearr_36540_36666[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (94))){
var inst_36388 = (state_36397[(2)]);
var state_36397__$1 = state_36397;
var statearr_36541_36667 = state_36397__$1;
(statearr_36541_36667[(2)] = inst_36388);

(statearr_36541_36667[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (8))){
var inst_36392 = (state_36397[(2)]);
var _ = (function (){var statearr_36542 = state_36397;
(statearr_36542[(4)] = cljs.core.rest.call(null,(state_36397[(4)])));

return statearr_36542;
})();
var state_36397__$1 = state_36397;
var statearr_36543_36668 = state_36397__$1;
(statearr_36543_36668[(2)] = inst_36392);

(statearr_36543_36668[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (49))){
var inst_36224 = (state_36397[(12)]);
var inst_36269 = (state_36397[(18)]);
var inst_36280 = cljs.core.drop.call(null,inst_36224,inst_36269);
var state_36397__$1 = state_36397;
var statearr_36544_36669 = state_36397__$1;
(statearr_36544_36669[(2)] = inst_36280);

(statearr_36544_36669[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36398 === (84))){
var inst_36364 = (state_36397[(2)]);
var inst_36365 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,inst_36364,opts);
var state_36397__$1 = state_36397;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36397__$1,(85),inst_36365);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10945__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10945__auto____0 = (function (){
var statearr_36545 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36545[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10945__auto__);

(statearr_36545[(1)] = (1));

return statearr_36545;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10945__auto____1 = (function (state_36397){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_36397);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e36546){var ex__10948__auto__ = e36546;
var statearr_36547_36670 = state_36397;
(statearr_36547_36670[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_36397[(4)]))){
var statearr_36548_36671 = state_36397;
(statearr_36548_36671[(1)] = cljs.core.first.call(null,(state_36397[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36672 = state_36397;
state_36397 = G__36672;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10945__auto__ = function(state_36397){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10945__auto____1.call(this,state_36397);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10945__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10945__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_36549 = f__11019__auto__.call(null);
(statearr_36549[(6)] = c__11018__auto__);

return statearr_36549;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__36675,opts){
var map__36676 = p__36675;
var map__36676__$1 = cljs.core.__destructure_map.call(null,map__36676);
var selectOne = cljs.core.get.call(null,map__36676__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.call(null,map__36676__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.call(null,map__36676__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.call(null,map__36676__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var select_smt = (function (){var or__5045__auto__ = selectOne;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = select;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
var or__5045__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__5045__auto____$2)){
return or__5045__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_.call(null,select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select.call(null,headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.call(null,(function (p1__36673_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__36673_SHARP_,new cljs.core.Keyword(null,"code","code",1586293142));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some.call(null,(function (p1__36674_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__36674_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_.call(null,aggregates))?null:aggregates);
var orderBy = (function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5804__auto__)){
var orderBy = temp__5804__auto__;
if(cljs.core.truth_((function (){var or__5045__auto__ = typeof orderBy === 'string';
if(or__5045__auto__){
return or__5045__auto__;
} else {
var and__5043__auto__ = cljs.core.vector_QMARK_.call(null,orderBy);
if(and__5043__auto__){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null).call(null,cljs.core.first.call(null,orderBy));
} else {
return and__5043__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_.call(null,orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.call(null,["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (100);
}
})(),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$.call(null,selectOne),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return false;
}
})(),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$.call(null,(function (){var or__5045__auto__ = selectDistinct;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__36677,p__36678){
var map__36679 = p__36677;
var map__36679__$1 = cljs.core.__destructure_map.call(null,map__36679);
var query_map = map__36679__$1;
var construct = cljs.core.get.call(null,map__36679__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var map__36680 = p__36678;
var map__36680__$1 = cljs.core.__destructure_map.call(null,map__36680);
var where_result = map__36680__$1;
var headers = cljs.core.get.call(null,map__36680__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__36680__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__36681 = cljs.core.map.call(null,(function (construct_item){
var temp__5802__auto__ = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,construct_item));
if(cljs.core.truth_(temp__5802__auto__)){
var index_of = temp__5802__auto__;
return (function (row){
return cljs.core.nth.call(null,row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.call(null,vec__36681,(0),null);
var fn2 = cljs.core.nth.call(null,vec__36681,(1),null);
var fn3 = cljs.core.nth.call(null,vec__36681,(2),null);
return cljs.core.map.call(null,(function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fn1.call(null,res),fn2.call(null,res),fn3.call(null,res)], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_36714){
var state_val_36715 = (state_36714[(1)]);
if((state_val_36715 === (7))){
var inst_36693 = (state_36714[(7)]);
var state_36714__$1 = state_36714;
var statearr_36716_36739 = state_36714__$1;
(statearr_36716_36739[(2)] = inst_36693);

(statearr_36716_36739[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36715 === (1))){
var state_36714__$1 = state_36714;
var statearr_36717_36740 = state_36714__$1;
(statearr_36717_36740[(2)] = null);

(statearr_36717_36740[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36715 === (4))){
var inst_36684 = (state_36714[(2)]);
var state_36714__$1 = state_36714;
var statearr_36718_36741 = state_36714__$1;
(statearr_36718_36741[(2)] = inst_36684);

(statearr_36718_36741[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36715 === (13))){
var inst_36703 = (state_36714[(2)]);
var inst_36704 = fluree.db.util.async.throw_err.call(null,inst_36703);
var state_36714__$1 = state_36714;
var statearr_36719_36742 = state_36714__$1;
(statearr_36719_36742[(2)] = inst_36704);

(statearr_36719_36742[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36715 === (6))){
var inst_36693 = (state_36714[(7)]);
var inst_36692 = (state_36714[(2)]);
var inst_36693__$1 = fluree.db.util.async.throw_err.call(null,inst_36692);
var inst_36694 = fluree.db.util.core.exception_QMARK_.call(null,inst_36693__$1);
var state_36714__$1 = (function (){var statearr_36720 = state_36714;
(statearr_36720[(7)] = inst_36693__$1);

return statearr_36720;
})();
if(inst_36694){
var statearr_36721_36743 = state_36714__$1;
(statearr_36721_36743[(1)] = (7));

} else {
var statearr_36722_36744 = state_36714__$1;
(statearr_36722_36744[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36715 === (3))){
var inst_36712 = (state_36714[(2)]);
var state_36714__$1 = state_36714;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36714__$1,inst_36712);
} else {
if((state_val_36715 === (12))){
var inst_36707 = (state_36714[(2)]);
var state_36714__$1 = state_36714;
var statearr_36723_36745 = state_36714__$1;
(statearr_36723_36745[(2)] = inst_36707);

(statearr_36723_36745[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36715 === (2))){
var _ = (function (){var statearr_36724 = state_36714;
(statearr_36724[(4)] = cljs.core.cons.call(null,(5),(state_36714[(4)])));

return statearr_36724;
})();
var inst_36690 = fluree.db.query.analytical.q.call(null,query_map,fuel,max_fuel,db,opts);
var state_36714__$1 = state_36714;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36714__$1,(6),inst_36690);
} else {
if((state_val_36715 === (11))){
var state_36714__$1 = state_36714;
var statearr_36726_36746 = state_36714__$1;
(statearr_36726_36746[(2)] = null);

(statearr_36726_36746[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36715 === (9))){
var inst_36709 = (state_36714[(2)]);
var _ = (function (){var statearr_36727 = state_36714;
(statearr_36727[(4)] = cljs.core.rest.call(null,(state_36714[(4)])));

return statearr_36727;
})();
var state_36714__$1 = state_36714;
var statearr_36728_36747 = state_36714__$1;
(statearr_36728_36747[(2)] = inst_36709);

(statearr_36728_36747[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36715 === (5))){
var _ = (function (){var statearr_36729 = state_36714;
(statearr_36729[(4)] = cljs.core.rest.call(null,(state_36714[(4)])));

return statearr_36729;
})();
var state_36714__$1 = state_36714;
var ex36725 = (state_36714__$1[(2)]);
var statearr_36730_36748 = state_36714__$1;
(statearr_36730_36748[(5)] = ex36725);


if((ex36725 instanceof Error)){
var statearr_36731_36749 = state_36714__$1;
(statearr_36731_36749[(1)] = (4));

(statearr_36731_36749[(5)] = null);

} else {
throw ex36725;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36715 === (10))){
var inst_36693 = (state_36714[(7)]);
var inst_36698 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_36693);
var inst_36699 = new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(inst_36693);
var inst_36700 = fluree.db.query.fql.get_ad_hoc_select_spec.call(null,inst_36698,inst_36699,query_map,opts);
var inst_36701 = fluree.db.query.fql.process_ad_hoc_res.call(null,db,fuel,max_fuel,inst_36693,inst_36700,opts);
var state_36714__$1 = state_36714;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36714__$1,(13),inst_36701);
} else {
if((state_val_36715 === (8))){
var state_36714__$1 = state_36714;
var statearr_36732_36750 = state_36714__$1;
(statearr_36732_36750[(1)] = (10));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__10945__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__10945__auto____0 = (function (){
var statearr_36734 = [null,null,null,null,null,null,null,null];
(statearr_36734[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__10945__auto__);

(statearr_36734[(1)] = (1));

return statearr_36734;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__10945__auto____1 = (function (state_36714){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_36714);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e36735){var ex__10948__auto__ = e36735;
var statearr_36736_36751 = state_36714;
(statearr_36736_36751[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_36714[(4)]))){
var statearr_36737_36752 = state_36714;
(statearr_36737_36752[(1)] = cljs.core.first.call(null,(state_36714[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36753 = state_36714;
state_36714 = G__36753;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__10945__auto__ = function(state_36714){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__10945__auto____1.call(this,state_36714);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__10945__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__10945__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_36738 = f__11019__auto__.call(null);
(statearr_36738[(6)] = c__11018__auto__);

return statearr_36738;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.call(null,"Running query:",cljs.core.pr_str.call(null,query_map));

var map__36754 = query_map;
var map__36754__$1 = cljs.core.__destructure_map.call(null,map__36754);
var select = cljs.core.get.call(null,map__36754__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__36754__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var where = cljs.core.get.call(null,map__36754__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.call(null,map__36754__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__36754__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.call(null,map__36754__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.call(null,map__36754__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.call(null,map__36754__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.call(null,map__36754__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.call(null,map__36754__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var opts = cljs.core.get.call(null,map__36754__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var groupBy = cljs.core.get.call(null,map__36754__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var opts_SINGLEQUOTE_ = (function (){var G__36755 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__5045__auto__ = offset;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts);
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.call(null,G__36755,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
} else {
return G__36755;
}
})();
var max_fuel = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.truth_((function (){var or__5045__auto____$1 = max_fuel;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_.call(null,(0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_.call(null,where)){
return fluree.db.query.fql.ad_hoc_query.call(null,db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_37111){
var state_val_37112 = (state_37111[(1)]);
if((state_val_37112 === (121))){
var inst_37072 = (state_37111[(2)]);
var state_37111__$1 = state_37111;
var statearr_37113_37308 = state_37111__$1;
(statearr_37113_37308[(2)] = inst_37072);

(statearr_37113_37308[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (65))){
var inst_36949 = typeof from === 'string';
var state_37111__$1 = state_37111;
if(cljs.core.truth_(inst_36949)){
var statearr_37114_37309 = state_37111__$1;
(statearr_37114_37309[(1)] = (72));

} else {
var statearr_37115_37310 = state_37111__$1;
(statearr_37115_37310[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (70))){
var inst_36815 = (state_37111[(7)]);
var inst_36817 = (state_37111[(8)]);
var inst_36942 = (state_37111[(2)]);
var inst_36943 = fluree.db.util.async.throw_err.call(null,inst_36942);
var inst_36944 = fluree.db.query.fql.flake_select.call(null,db,inst_36817,fuel,max_fuel,inst_36815,inst_36943);
var state_37111__$1 = state_37111;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37111__$1,(71),inst_36944);
} else {
if((state_val_37112 === (62))){
var inst_36922 = (state_37111[(9)]);
var state_37111__$1 = state_37111;
var statearr_37116_37311 = state_37111__$1;
(statearr_37116_37311[(2)] = inst_36922);

(statearr_37116_37311[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (74))){
var inst_37078 = (state_37111[(2)]);
var state_37111__$1 = state_37111;
var statearr_37117_37312 = state_37111__$1;
(statearr_37117_37312[(2)] = inst_37078);

(statearr_37117_37312[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (110))){
var inst_37013 = (state_37111[(10)]);
var state_37111__$1 = state_37111;
var statearr_37118_37313 = state_37111__$1;
(statearr_37118_37313[(2)] = inst_37013);

(statearr_37118_37313[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (130))){
var inst_37098 = (state_37111[(2)]);
var state_37111__$1 = state_37111;
var statearr_37119_37314 = state_37111__$1;
(statearr_37119_37314[(2)] = inst_37098);

(statearr_37119_37314[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (128))){
var inst_37089 = (state_37111[(11)]);
var inst_37094 = fluree.db.util.core.exception_QMARK_.call(null,inst_37089);
var inst_37095 = (!(inst_37094));
var state_37111__$1 = state_37111;
var statearr_37120_37315 = state_37111__$1;
(statearr_37120_37315[(2)] = inst_37095);

(statearr_37120_37315[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (7))){
var inst_36785 = (state_37111[(12)]);
var inst_36785__$1 = selectOne;
var state_37111__$1 = (function (){var statearr_37121 = state_37111;
(statearr_37121[(12)] = inst_36785__$1);

return statearr_37121;
})();
if(cljs.core.truth_(inst_36785__$1)){
var statearr_37122_37316 = state_37111__$1;
(statearr_37122_37316[(1)] = (9));

} else {
var statearr_37123_37317 = state_37111__$1;
(statearr_37123_37317[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (59))){
var inst_36900 = (state_37111[(13)]);
var inst_36805 = (state_37111[(14)]);
var inst_36815 = (state_37111[(7)]);
var inst_36817 = (state_37111[(8)]);
var inst_36914 = (state_37111[(2)]);
var inst_36915 = fluree.db.util.async.throw_err.call(null,inst_36914);
var inst_36916 = cljs.core.sequence.call(null,inst_36900,inst_36915);
var inst_36917 = fluree.db.query.fql.subject_select.call(null,db,inst_36817,fuel,max_fuel,inst_36815,inst_36916,inst_36805);
var state_37111__$1 = state_37111;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37111__$1,(60),inst_36917);
} else {
if((state_val_37112 === (86))){
var inst_36805 = (state_37111[(14)]);
var inst_36815 = (state_37111[(7)]);
var inst_36807 = (state_37111[(15)]);
var inst_36817 = (state_37111[(8)]);
var inst_36982 = (state_37111[(2)]);
var inst_36983 = fluree.db.query.fql.subject_select.call(null,db,inst_36817,fuel,max_fuel,inst_36815,inst_36982,inst_36805,inst_36807);
var state_37111__$1 = state_37111;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37111__$1,(87),inst_36983);
} else {
if((state_val_37112 === (20))){
var inst_36849 = (state_37111[(2)]);
var inst_36850 = cljs.core.nth.call(null,inst_36849,(0),null);
var inst_36851 = cljs.core.nth.call(null,inst_36849,(1),null);
var inst_36852 = typeof where === 'string';
var state_37111__$1 = (function (){var statearr_37124 = state_37111;
(statearr_37124[(16)] = inst_36851);

(statearr_37124[(17)] = inst_36850);

return statearr_37124;
})();
if(cljs.core.truth_(inst_36852)){
var statearr_37125_37318 = state_37111__$1;
(statearr_37125_37318[(1)] = (30));

} else {
var statearr_37126_37319 = state_37111__$1;
(statearr_37126_37319[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (72))){
var inst_36804 = (state_37111[(18)]);
var state_37111__$1 = state_37111;
if(cljs.core.truth_(inst_36804)){
var statearr_37127_37320 = state_37111__$1;
(statearr_37127_37320[(1)] = (75));

} else {
var statearr_37128_37321 = state_37111__$1;
(statearr_37128_37321[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (58))){
var inst_36908 = (state_37111[(2)]);
var inst_36909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36910 = [from];
var inst_36911 = (new cljs.core.PersistentVector(null,1,(5),inst_36909,inst_36910,null));
var inst_36912 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_36911,inst_36908);
var state_37111__$1 = state_37111;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37111__$1,(59),inst_36912);
} else {
if((state_val_37112 === (60))){
var inst_36919 = (state_37111[(2)]);
var inst_36920 = fluree.db.util.async.throw_err.call(null,inst_36919);
var state_37111__$1 = state_37111;
var statearr_37129_37322 = state_37111__$1;
(statearr_37129_37322[(2)] = inst_36920);

(statearr_37129_37322[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (27))){
var inst_36834 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36835 = [null,null];
var inst_36836 = (new cljs.core.PersistentVector(null,2,(5),inst_36834,inst_36835,null));
var state_37111__$1 = state_37111;
var statearr_37130_37323 = state_37111__$1;
(statearr_37130_37323[(2)] = inst_36836);

(statearr_37130_37323[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (1))){
var state_37111__$1 = state_37111;
var statearr_37131_37324 = state_37111__$1;
(statearr_37131_37324[(2)] = null);

(statearr_37131_37324[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (69))){
var inst_36939 = (state_37111[(2)]);
var inst_36940 = fluree.db.query.range._block_or_tx_collection.call(null,db,inst_36939);
var state_37111__$1 = state_37111;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37111__$1,(70),inst_36940);
} else {
if((state_val_37112 === (101))){
var inst_37045 = (state_37111[(2)]);
var state_37111__$1 = state_37111;
var statearr_37132_37325 = state_37111__$1;
(statearr_37132_37325[(2)] = inst_37045);

(statearr_37132_37325[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (24))){
var inst_36804 = (state_37111[(18)]);
var inst_36829 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36830 = [inst_36804,"ASC"];
var inst_36831 = (new cljs.core.PersistentVector(null,2,(5),inst_36829,inst_36830,null));
var state_37111__$1 = state_37111;
var statearr_37133_37326 = state_37111__$1;
(statearr_37133_37326[(2)] = inst_36831);

(statearr_37133_37326[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (102))){
var inst_37019 = (state_37111[(19)]);
var state_37111__$1 = state_37111;
var statearr_37134_37327 = state_37111__$1;
(statearr_37134_37327[(2)] = inst_37019);

(statearr_37134_37327[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (55))){
var inst_36804 = (state_37111[(18)]);
var inst_36900 = (state_37111[(2)]);
var state_37111__$1 = (function (){var statearr_37135 = state_37111;
(statearr_37135[(13)] = inst_36900);

return statearr_37135;
})();
if(cljs.core.truth_(inst_36804)){
var statearr_37136_37328 = state_37111__$1;
(statearr_37136_37328[(1)] = (56));

} else {
var statearr_37137_37329 = state_37111__$1;
(statearr_37137_37329[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (85))){
var inst_36974 = (state_37111[(20)]);
var inst_36978 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36979 = [inst_36974];
var inst_36980 = (new cljs.core.PersistentVector(null,1,(5),inst_36978,inst_36979,null));
var state_37111__$1 = state_37111;
var statearr_37138_37330 = state_37111__$1;
(statearr_37138_37330[(2)] = inst_36980);

(statearr_37138_37330[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (39))){
var inst_36805 = (state_37111[(14)]);
var state_37111__$1 = state_37111;
var statearr_37139_37331 = state_37111__$1;
(statearr_37139_37331[(2)] = inst_36805);

(statearr_37139_37331[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (88))){
var inst_36988 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core.inc);
var state_37111__$1 = state_37111;
var statearr_37140_37332 = state_37111__$1;
(statearr_37140_37332[(2)] = inst_36988);

(statearr_37140_37332[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (46))){
var inst_36885 = (state_37111[(2)]);
var state_37111__$1 = state_37111;
if(cljs.core.truth_(inst_36885)){
var statearr_37141_37333 = state_37111__$1;
(statearr_37141_37333[(1)] = (47));

} else {
var statearr_37142_37334 = state_37111__$1;
(statearr_37142_37334[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (4))){
var inst_36772 = (state_37111[(2)]);
var state_37111__$1 = state_37111;
var statearr_37143_37335 = state_37111__$1;
(statearr_37143_37335[(2)] = inst_36772);

(statearr_37143_37335[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (77))){
var inst_36958 = (state_37111[(2)]);
var inst_36959 = fluree.db.query.range.collection.call(null,db,from,inst_36958);
var state_37111__$1 = state_37111;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37111__$1,(78),inst_36959);
} else {
if((state_val_37112 === (106))){
var state_37111__$1 = state_37111;
var statearr_37144_37336 = state_37111__$1;
(statearr_37144_37336[(2)] = null);

(statearr_37144_37336[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (119))){
var inst_37064 = cljs.core.pr_str.call(null,query_map);
var inst_37065 = ["Invalid 'from' in query:",inst_37064].join('');
var inst_37066 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37067 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_37068 = cljs.core.PersistentHashMap.fromArrays(inst_37066,inst_37067);
var inst_37069 = cljs.core.ex_info.call(null,inst_37065,inst_37068);
var state_37111__$1 = state_37111;
var statearr_37145_37337 = state_37111__$1;
(statearr_37145_37337[(2)] = inst_37069);

(statearr_37145_37337[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (95))){
var state_37111__$1 = state_37111;
var statearr_37146_37338 = state_37111__$1;
(statearr_37146_37338[(1)] = (119));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (54))){
var inst_36894 = (state_37111[(21)]);
var state_37111__$1 = state_37111;
var statearr_37148_37339 = state_37111__$1;
(statearr_37148_37339[(2)] = inst_36894);

(statearr_37148_37339[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (92))){
var inst_36993 = (state_37111[(22)]);
var state_37111__$1 = state_37111;
var statearr_37149_37340 = state_37111__$1;
(statearr_37149_37340[(2)] = inst_36993);

(statearr_37149_37340[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (104))){
var inst_37037 = (state_37111[(23)]);
var inst_37037__$1 = (state_37111[(2)]);
var state_37111__$1 = (function (){var statearr_37150 = state_37111;
(statearr_37150[(23)] = inst_37037__$1);

return statearr_37150;
})();
if(cljs.core.truth_(inst_37037__$1)){
var statearr_37151_37341 = state_37111__$1;
(statearr_37151_37341[(1)] = (109));

} else {
var statearr_37152_37342 = state_37111__$1;
(statearr_37152_37342[(1)] = (110));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (15))){
var inst_36806 = (state_37111[(24)]);
var inst_36808 = (state_37111[(25)]);
var inst_36812 = cljs.core.assoc.call(null,inst_36808,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),inst_36806);
var state_37111__$1 = state_37111;
var statearr_37153_37343 = state_37111__$1;
(statearr_37153_37343[(2)] = inst_36812);

(statearr_37153_37343[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (48))){
var inst_36922 = (state_37111[(9)]);
var inst_36922__$1 = typeof from === 'string';
var state_37111__$1 = (function (){var statearr_37154 = state_37111;
(statearr_37154[(9)] = inst_36922__$1);

return statearr_37154;
})();
if(cljs.core.truth_(inst_36922__$1)){
var statearr_37155_37344 = state_37111__$1;
(statearr_37155_37344[(1)] = (61));

} else {
var statearr_37156_37345 = state_37111__$1;
(statearr_37156_37345[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (50))){
var inst_36888 = (state_37111[(26)]);
var inst_36890 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_36891 = cljs.core.comp.call(null,inst_36888,inst_36890);
var state_37111__$1 = state_37111;
var statearr_37157_37346 = state_37111__$1;
(statearr_37157_37346[(2)] = inst_36891);

(statearr_37157_37346[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (116))){
var state_37111__$1 = state_37111;
var statearr_37158_37347 = state_37111__$1;
(statearr_37158_37347[(2)] = null);

(statearr_37158_37347[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (75))){
var inst_36952 = cljs.core.PersistentHashMap.EMPTY;
var state_37111__$1 = state_37111;
var statearr_37159_37348 = state_37111__$1;
(statearr_37159_37348[(2)] = inst_36952);

(statearr_37159_37348[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (99))){
var inst_37013 = (state_37111[(10)]);
var state_37111__$1 = state_37111;
var statearr_37160_37349 = state_37111__$1;
(statearr_37160_37349[(2)] = inst_37013);

(statearr_37160_37349[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (21))){
var inst_36804 = (state_37111[(18)]);
var inst_36821 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36822 = cljs.core.second.call(null,inst_36804);
var inst_36823 = cljs.core.first.call(null,inst_36804);
var inst_36824 = [inst_36822,inst_36823];
var inst_36825 = (new cljs.core.PersistentVector(null,2,(5),inst_36821,inst_36824,null));
var state_37111__$1 = state_37111;
var statearr_37161_37350 = state_37111__$1;
(statearr_37161_37350[(2)] = inst_36825);

(statearr_37161_37350[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (31))){
var inst_36879 = (state_37111[(27)]);
var inst_36879__$1 = typeof from === 'string';
var state_37111__$1 = (function (){var statearr_37162 = state_37111;
(statearr_37162[(27)] = inst_36879__$1);

return statearr_37162;
})();
if(cljs.core.truth_(inst_36879__$1)){
var statearr_37163_37351 = state_37111__$1;
(statearr_37163_37351[(1)] = (44));

} else {
var statearr_37164_37352 = state_37111__$1;
(statearr_37164_37352[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (113))){
var state_37111__$1 = state_37111;
var statearr_37165_37353 = state_37111__$1;
(statearr_37165_37353[(2)] = null);

(statearr_37165_37353[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (32))){
var inst_36850 = (state_37111[(17)]);
var inst_37084 = (state_37111[(2)]);
var state_37111__$1 = (function (){var statearr_37166 = state_37111;
(statearr_37166[(28)] = inst_37084);

return statearr_37166;
})();
if(cljs.core.truth_(inst_36850)){
var statearr_37167_37354 = state_37111__$1;
(statearr_37167_37354[(1)] = (122));

} else {
var statearr_37168_37355 = state_37111__$1;
(statearr_37168_37355[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (40))){
var inst_36804 = (state_37111[(18)]);
var inst_36869 = (state_37111[(2)]);
var state_37111__$1 = (function (){var statearr_37169 = state_37111;
(statearr_37169[(29)] = inst_36869);

return statearr_37169;
})();
if(cljs.core.truth_(inst_36804)){
var statearr_37170_37356 = state_37111__$1;
(statearr_37170_37356[(1)] = (41));

} else {
var statearr_37171_37357 = state_37111__$1;
(statearr_37171_37357[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (129))){
var inst_37092 = (state_37111[(30)]);
var state_37111__$1 = state_37111;
var statearr_37172_37358 = state_37111__$1;
(statearr_37172_37358[(2)] = inst_37092);

(statearr_37172_37358[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (91))){
var inst_36995 = cljs.core.every_QMARK_.call(null,fluree.db.util.core.subj_ident_QMARK_,from);
var state_37111__$1 = state_37111;
var statearr_37173_37359 = state_37111__$1;
(statearr_37173_37359[(2)] = inst_36995);

(statearr_37173_37359[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (117))){
var inst_36807 = (state_37111[(15)]);
var state_37111__$1 = state_37111;
var statearr_37174_37360 = state_37111__$1;
(statearr_37174_37360[(2)] = inst_36807);

(statearr_37174_37360[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (108))){
var inst_37034 = (state_37111[(2)]);
var inst_37035 = fluree.db.util.async.throw_err.call(null,inst_37034);
var state_37111__$1 = state_37111;
var statearr_37175_37361 = state_37111__$1;
(statearr_37175_37361[(2)] = inst_37035);

(statearr_37175_37361[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (56))){
var inst_36902 = cljs.core.PersistentHashMap.EMPTY;
var state_37111__$1 = state_37111;
var statearr_37176_37362 = state_37111__$1;
(statearr_37176_37362[(2)] = inst_36902);

(statearr_37176_37362[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (33))){
var state_37111__$1 = state_37111;
var statearr_37177_37363 = state_37111__$1;
(statearr_37177_37363[(2)] = from);

(statearr_37177_37363[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (13))){
var inst_36791 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_36792 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_36793 = cljs.core.PersistentHashMap.fromArrays(inst_36791,inst_36792);
var inst_36794 = cljs.core.ex_info.call(null,"Query missing :select or :selectOne.",inst_36793);
var inst_36795 = (function(){throw inst_36794})();
var state_37111__$1 = state_37111;
var statearr_37178_37364 = state_37111__$1;
(statearr_37178_37364[(2)] = inst_36795);

(statearr_37178_37364[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (22))){
var inst_36804 = (state_37111[(18)]);
var inst_36827 = typeof inst_36804 === 'string';
var state_37111__$1 = state_37111;
if(cljs.core.truth_(inst_36827)){
var statearr_37179_37365 = state_37111__$1;
(statearr_37179_37365[(1)] = (24));

} else {
var statearr_37180_37366 = state_37111__$1;
(statearr_37180_37366[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (90))){
var inst_36986 = (state_37111[(31)]);
var inst_36991 = (state_37111[(2)]);
var state_37111__$1 = (function (){var statearr_37181 = state_37111;
(statearr_37181[(32)] = inst_36991);

return statearr_37181;
})();
var statearr_37182_37367 = state_37111__$1;
(statearr_37182_37367[(2)] = inst_36986);

(statearr_37182_37367[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (109))){
var inst_37013 = (state_37111[(10)]);
var inst_37037 = (state_37111[(23)]);
var inst_37039 = cljs.core.conj.call(null,inst_37013,inst_37037);
var state_37111__$1 = state_37111;
var statearr_37183_37368 = state_37111__$1;
(statearr_37183_37368[(2)] = inst_37039);

(statearr_37183_37368[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (36))){
var inst_36804 = (state_37111[(18)]);
var inst_36864 = (state_37111[(2)]);
var inst_36865 = fluree.db.util.async.throw_err.call(null,inst_36864);
var state_37111__$1 = (function (){var statearr_37184 = state_37111;
(statearr_37184[(33)] = inst_36865);

return statearr_37184;
})();
if(cljs.core.truth_(inst_36804)){
var statearr_37185_37369 = state_37111__$1;
(statearr_37185_37369[(1)] = (38));

} else {
var statearr_37186_37370 = state_37111__$1;
(statearr_37186_37370[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (41))){
var state_37111__$1 = state_37111;
var statearr_37187_37371 = state_37111__$1;
(statearr_37187_37371[(2)] = null);

(statearr_37187_37371[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (118))){
var inst_37049 = (state_37111[(34)]);
var inst_36815 = (state_37111[(7)]);
var inst_37053 = (state_37111[(35)]);
var inst_36817 = (state_37111[(8)]);
var inst_37057 = (state_37111[(2)]);
var inst_37058 = fluree.db.query.fql.subject_select.call(null,db,inst_36817,fuel,max_fuel,inst_36815,inst_37049,inst_37053,inst_37057);
var state_37111__$1 = state_37111;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37111__$1,(112),inst_37058);
} else {
if((state_val_37112 === (89))){
var state_37111__$1 = state_37111;
var statearr_37188_37372 = state_37111__$1;
(statearr_37188_37372[(2)] = null);

(statearr_37188_37372[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (100))){
var inst_37019 = (state_37111[(19)]);
var inst_37024 = cljs.core.int_QMARK_.call(null,inst_37019);
var state_37111__$1 = state_37111;
if(inst_37024){
var statearr_37189_37373 = state_37111__$1;
(statearr_37189_37373[(1)] = (102));

} else {
var statearr_37190_37374 = state_37111__$1;
(statearr_37190_37374[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (131))){
var inst_37089 = (state_37111[(11)]);
var inst_37103 = cljs.core.first.call(null,inst_37089);
var state_37111__$1 = state_37111;
var statearr_37191_37375 = state_37111__$1;
(statearr_37191_37375[(2)] = inst_37103);

(statearr_37191_37375[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (122))){
var inst_36805 = (state_37111[(14)]);
var inst_36807 = (state_37111[(15)]);
var inst_36851 = (state_37111[(16)]);
var inst_36850 = (state_37111[(17)]);
var inst_37084 = (state_37111[(28)]);
var inst_37086 = fluree.db.query.fql.sort_offset_and_limit_res.call(null,inst_36850,inst_36851,inst_36807,inst_36805,inst_37084);
var state_37111__$1 = state_37111;
var statearr_37192_37376 = state_37111__$1;
(statearr_37192_37376[(2)] = inst_37086);

(statearr_37192_37376[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (43))){
var inst_36869 = (state_37111[(29)]);
var inst_36815 = (state_37111[(7)]);
var inst_36865 = (state_37111[(33)]);
var inst_36817 = (state_37111[(8)]);
var inst_36873 = (state_37111[(2)]);
var inst_36874 = fluree.db.query.fql.subject_select.call(null,db,inst_36817,fuel,max_fuel,inst_36815,inst_36865,inst_36869,inst_36873);
var state_37111__$1 = state_37111;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37111__$1,(37),inst_36874);
} else {
if((state_val_37112 === (61))){
var inst_36924 = ["_tx",null,"_block",null];
var inst_36925 = (new cljs.core.PersistentArrayMap(null,2,inst_36924,null));
var inst_36926 = (new cljs.core.PersistentHashSet(null,inst_36925,null));
var inst_36927 = inst_36926.call(null,from);
var state_37111__$1 = state_37111;
var statearr_37193_37377 = state_37111__$1;
(statearr_37193_37377[(2)] = inst_36927);

(statearr_37193_37377[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (29))){
var inst_36839 = (state_37111[(2)]);
var state_37111__$1 = state_37111;
var statearr_37194_37378 = state_37111__$1;
(statearr_37194_37378[(2)] = inst_36839);

(statearr_37194_37378[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (44))){
var inst_36881 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_36882 = clojure.string.includes_QMARK_.call(null,inst_36881,"/");
var state_37111__$1 = state_37111;
var statearr_37195_37379 = state_37111__$1;
(statearr_37195_37379[(2)] = inst_36882);

(statearr_37195_37379[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (93))){
var inst_36998 = (state_37111[(2)]);
var state_37111__$1 = state_37111;
if(cljs.core.truth_(inst_36998)){
var statearr_37196_37380 = state_37111__$1;
(statearr_37196_37380[(1)] = (94));

} else {
var statearr_37197_37381 = state_37111__$1;
(statearr_37197_37381[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (6))){
var inst_36782 = (state_37111[(36)]);
var state_37111__$1 = state_37111;
var statearr_37198_37382 = state_37111__$1;
(statearr_37198_37382[(2)] = inst_36782);

(statearr_37198_37382[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (111))){
var inst_37020 = (state_37111[(37)]);
var inst_37042 = (state_37111[(2)]);
var inst_37012 = inst_37020;
var inst_37013 = inst_37042;
var state_37111__$1 = (function (){var statearr_37199 = state_37111;
(statearr_37199[(10)] = inst_37013);

(statearr_37199[(38)] = inst_37012);

return statearr_37199;
})();
var statearr_37200_37383 = state_37111__$1;
(statearr_37200_37383[(2)] = null);

(statearr_37200_37383[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (28))){
var state_37111__$1 = state_37111;
var statearr_37201_37384 = state_37111__$1;
(statearr_37201_37384[(2)] = null);

(statearr_37201_37384[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (64))){
var inst_36804 = (state_37111[(18)]);
var state_37111__$1 = state_37111;
if(cljs.core.truth_(inst_36804)){
var statearr_37202_37385 = state_37111__$1;
(statearr_37202_37385[(1)] = (67));

} else {
var statearr_37203_37386 = state_37111__$1;
(statearr_37203_37386[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (103))){
var state_37111__$1 = state_37111;
if(cljs.core.truth_(fuel)){
var statearr_37204_37387 = state_37111__$1;
(statearr_37204_37387[(1)] = (105));

} else {
var statearr_37205_37388 = state_37111__$1;
(statearr_37205_37388[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (51))){
var inst_36888 = (state_37111[(26)]);
var state_37111__$1 = state_37111;
var statearr_37206_37389 = state_37111__$1;
(statearr_37206_37389[(2)] = inst_36888);

(statearr_37206_37389[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (25))){
var state_37111__$1 = state_37111;
var statearr_37207_37390 = state_37111__$1;
(statearr_37207_37390[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (34))){
var state_37111__$1 = state_37111;
var statearr_37209_37391 = state_37111__$1;
(statearr_37209_37391[(2)] = null);

(statearr_37209_37391[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (125))){
var inst_37089 = (state_37111[(11)]);
var inst_37092 = (state_37111[(30)]);
var inst_37092__$1 = cljs.core.coll_QMARK_.call(null,inst_37089);
var state_37111__$1 = (function (){var statearr_37210 = state_37111;
(statearr_37210[(30)] = inst_37092__$1);

return statearr_37210;
})();
if(inst_37092__$1){
var statearr_37211_37392 = state_37111__$1;
(statearr_37211_37392[(1)] = (128));

} else {
var statearr_37212_37393 = state_37111__$1;
(statearr_37212_37393[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (17))){
var inst_36804 = (state_37111[(18)]);
var inst_36815 = (state_37111[(2)]);
var inst_36816 = cljs.core.PersistentHashMap.EMPTY;
var inst_36817 = cljs.core.volatile_BANG_.call(null,inst_36816);
var state_37111__$1 = (function (){var statearr_37213 = state_37111;
(statearr_37213[(7)] = inst_36815);

(statearr_37213[(8)] = inst_36817);

return statearr_37213;
})();
if(cljs.core.truth_(inst_36804)){
var statearr_37214_37394 = state_37111__$1;
(statearr_37214_37394[(1)] = (18));

} else {
var statearr_37215_37395 = state_37111__$1;
(statearr_37215_37395[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (3))){
var inst_37109 = (state_37111[(2)]);
var state_37111__$1 = state_37111;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37111__$1,inst_37109);
} else {
if((state_val_37112 === (12))){
var inst_36788 = (state_37111[(39)]);
var state_37111__$1 = state_37111;
var statearr_37216_37396 = state_37111__$1;
(statearr_37216_37396[(2)] = inst_36788);

(statearr_37216_37396[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (2))){
var inst_36782 = (state_37111[(36)]);
var _ = (function (){var statearr_37217 = state_37111;
(statearr_37217[(4)] = cljs.core.cons.call(null,(5),(state_37111[(4)])));

return statearr_37217;
})();
var inst_36782__$1 = select;
var state_37111__$1 = (function (){var statearr_37218 = state_37111;
(statearr_37218[(36)] = inst_36782__$1);

return statearr_37218;
})();
if(cljs.core.truth_(inst_36782__$1)){
var statearr_37219_37397 = state_37111__$1;
(statearr_37219_37397[(1)] = (6));

} else {
var statearr_37220_37398 = state_37111__$1;
(statearr_37220_37398[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (66))){
var inst_37080 = (state_37111[(2)]);
var state_37111__$1 = state_37111;
var statearr_37221_37399 = state_37111__$1;
(statearr_37221_37399[(2)] = inst_37080);

(statearr_37221_37399[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (107))){
var inst_37019 = (state_37111[(19)]);
var inst_37031 = (state_37111[(2)]);
var inst_37032 = fluree.db.dbproto._subid.call(null,db,inst_37019,false);
var state_37111__$1 = (function (){var statearr_37222 = state_37111;
(statearr_37222[(40)] = inst_37031);

return statearr_37222;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37111__$1,(108),inst_37032);
} else {
if((state_val_37112 === (23))){
var inst_36843 = (state_37111[(2)]);
var state_37111__$1 = state_37111;
var statearr_37223_37400 = state_37111__$1;
(statearr_37223_37400[(2)] = inst_36843);

(statearr_37223_37400[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (47))){
var inst_36888 = cljs.core.map.call(null,fluree.db.query.fql.s);
var state_37111__$1 = (function (){var statearr_37224 = state_37111;
(statearr_37224[(26)] = inst_36888);

return statearr_37224;
})();
if(cljs.core.truth_(fuel)){
var statearr_37225_37401 = state_37111__$1;
(statearr_37225_37401[(1)] = (50));

} else {
var statearr_37226_37402 = state_37111__$1;
(statearr_37226_37402[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (35))){
var inst_36805 = (state_37111[(14)]);
var inst_36807 = (state_37111[(15)]);
var inst_36858 = (state_37111[(2)]);
var inst_36859 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_36860 = [inst_36805,inst_36807];
var inst_36861 = cljs.core.PersistentHashMap.fromArrays(inst_36859,inst_36860);
var inst_36862 = fluree.db.query.fql.where_filter.call(null,db,where,inst_36858,inst_36861);
var state_37111__$1 = state_37111;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37111__$1,(36),inst_36862);
} else {
if((state_val_37112 === (127))){
var inst_37101 = (state_37111[(2)]);
var state_37111__$1 = state_37111;
if(cljs.core.truth_(inst_37101)){
var statearr_37227_37403 = state_37111__$1;
(statearr_37227_37403[(1)] = (131));

} else {
var statearr_37228_37404 = state_37111__$1;
(statearr_37228_37404[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (82))){
var inst_37076 = (state_37111[(2)]);
var state_37111__$1 = state_37111;
var statearr_37229_37405 = state_37111__$1;
(statearr_37229_37405[(2)] = inst_37076);

(statearr_37229_37405[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (76))){
var inst_36805 = (state_37111[(14)]);
var inst_36807 = (state_37111[(15)]);
var inst_36954 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_36955 = [inst_36805,inst_36807];
var inst_36956 = cljs.core.PersistentHashMap.fromArrays(inst_36954,inst_36955);
var state_37111__$1 = state_37111;
var statearr_37230_37406 = state_37111__$1;
(statearr_37230_37406[(2)] = inst_36956);

(statearr_37230_37406[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (97))){
var inst_37012 = (state_37111[(38)]);
var inst_37019 = (state_37111[(19)]);
var inst_37018 = cljs.core.seq.call(null,inst_37012);
var inst_37019__$1 = cljs.core.first.call(null,inst_37018);
var inst_37020 = cljs.core.next.call(null,inst_37018);
var inst_37021 = cljs.core.not.call(null,inst_37019__$1);
var state_37111__$1 = (function (){var statearr_37231 = state_37111;
(statearr_37231[(37)] = inst_37020);

(statearr_37231[(19)] = inst_37019__$1);

return statearr_37231;
})();
if(inst_37021){
var statearr_37232_37407 = state_37111__$1;
(statearr_37232_37407[(1)] = (99));

} else {
var statearr_37233_37408 = state_37111__$1;
(statearr_37233_37408[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (19))){
var inst_36845 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36846 = [null,null];
var inst_36847 = (new cljs.core.PersistentVector(null,2,(5),inst_36845,inst_36846,null));
var state_37111__$1 = state_37111;
var statearr_37234_37409 = state_37111__$1;
(statearr_37234_37409[(2)] = inst_36847);

(statearr_37234_37409[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (57))){
var inst_36805 = (state_37111[(14)]);
var inst_36807 = (state_37111[(15)]);
var inst_36904 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_36905 = [inst_36805,inst_36807];
var inst_36906 = cljs.core.PersistentHashMap.fromArrays(inst_36904,inst_36905);
var state_37111__$1 = state_37111;
var statearr_37235_37410 = state_37111__$1;
(statearr_37235_37410[(2)] = inst_36906);

(statearr_37235_37410[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (68))){
var inst_36805 = (state_37111[(14)]);
var inst_36807 = (state_37111[(15)]);
var inst_36935 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_36936 = [inst_36805,inst_36807];
var inst_36937 = cljs.core.PersistentHashMap.fromArrays(inst_36935,inst_36936);
var state_37111__$1 = state_37111;
var statearr_37236_37411 = state_37111__$1;
(statearr_37236_37411[(2)] = inst_36937);

(statearr_37236_37411[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (11))){
var inst_36799 = (state_37111[(2)]);
var state_37111__$1 = state_37111;
var statearr_37237_37412 = state_37111__$1;
(statearr_37237_37412[(2)] = inst_36799);

(statearr_37237_37412[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (115))){
var inst_36804 = (state_37111[(18)]);
var inst_37053 = (state_37111[(2)]);
var state_37111__$1 = (function (){var statearr_37239 = state_37111;
(statearr_37239[(35)] = inst_37053);

return statearr_37239;
})();
if(cljs.core.truth_(inst_36804)){
var statearr_37240_37413 = state_37111__$1;
(statearr_37240_37413[(1)] = (116));

} else {
var statearr_37241_37414 = state_37111__$1;
(statearr_37241_37414[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (9))){
var inst_36785 = (state_37111[(12)]);
var state_37111__$1 = state_37111;
var statearr_37242_37415 = state_37111__$1;
(statearr_37242_37415[(2)] = inst_36785);

(statearr_37242_37415[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (5))){
var _ = (function (){var statearr_37243 = state_37111;
(statearr_37243[(4)] = cljs.core.rest.call(null,(state_37111[(4)])));

return statearr_37243;
})();
var state_37111__$1 = state_37111;
var ex37238 = (state_37111__$1[(2)]);
var statearr_37244_37416 = state_37111__$1;
(statearr_37244_37416[(5)] = ex37238);


if((ex37238 instanceof Error)){
var statearr_37245_37417 = state_37111__$1;
(statearr_37245_37417[(1)] = (4));

(statearr_37245_37417[(5)] = null);

} else {
throw ex37238;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (112))){
var inst_37060 = (state_37111[(2)]);
var inst_37061 = fluree.db.util.async.throw_err.call(null,inst_37060);
var state_37111__$1 = state_37111;
var statearr_37246_37418 = state_37111__$1;
(statearr_37246_37418[(2)] = inst_37061);

(statearr_37246_37418[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (83))){
var inst_36974 = (state_37111[(20)]);
var inst_36973 = (state_37111[(2)]);
var inst_36974__$1 = fluree.db.util.async.throw_err.call(null,inst_36973);
var inst_36975 = (inst_36974__$1 == null);
var state_37111__$1 = (function (){var statearr_37247 = state_37111;
(statearr_37247[(20)] = inst_36974__$1);

return statearr_37247;
})();
if(cljs.core.truth_(inst_36975)){
var statearr_37248_37419 = state_37111__$1;
(statearr_37248_37419[(1)] = (84));

} else {
var statearr_37249_37420 = state_37111__$1;
(statearr_37249_37420[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (14))){
var inst_36797 = (state_37111[(2)]);
var state_37111__$1 = state_37111;
var statearr_37250_37421 = state_37111__$1;
(statearr_37250_37421[(2)] = inst_36797);

(statearr_37250_37421[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (45))){
var inst_36879 = (state_37111[(27)]);
var state_37111__$1 = state_37111;
var statearr_37251_37422 = state_37111__$1;
(statearr_37251_37422[(2)] = inst_36879);

(statearr_37251_37422[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (53))){
var inst_36894 = (state_37111[(21)]);
var inst_36896 = cljs.core.distinct.call(null);
var inst_36897 = cljs.core.comp.call(null,inst_36894,inst_36896);
var state_37111__$1 = state_37111;
var statearr_37252_37423 = state_37111__$1;
(statearr_37252_37423[(2)] = inst_36897);

(statearr_37252_37423[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (78))){
var inst_36815 = (state_37111[(7)]);
var inst_36817 = (state_37111[(8)]);
var inst_36961 = (state_37111[(2)]);
var inst_36962 = fluree.db.util.async.throw_err.call(null,inst_36961);
var inst_36963 = fluree.db.query.fql.flake_select.call(null,db,inst_36817,fuel,max_fuel,inst_36815,inst_36962);
var state_37111__$1 = state_37111;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37111__$1,(79),inst_36963);
} else {
if((state_val_37112 === (132))){
var inst_37089 = (state_37111[(11)]);
var state_37111__$1 = state_37111;
var statearr_37253_37424 = state_37111__$1;
(statearr_37253_37424[(2)] = inst_37089);

(statearr_37253_37424[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (26))){
var inst_36841 = (state_37111[(2)]);
var state_37111__$1 = state_37111;
var statearr_37254_37425 = state_37111__$1;
(statearr_37254_37425[(2)] = inst_36841);

(statearr_37254_37425[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (123))){
var inst_37084 = (state_37111[(28)]);
var state_37111__$1 = state_37111;
var statearr_37255_37426 = state_37111__$1;
(statearr_37255_37426[(2)] = inst_37084);

(statearr_37255_37426[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (16))){
var inst_36808 = (state_37111[(25)]);
var state_37111__$1 = state_37111;
var statearr_37256_37427 = state_37111__$1;
(statearr_37256_37427[(2)] = inst_36808);

(statearr_37256_37427[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (133))){
var inst_37106 = (state_37111[(2)]);
var _ = (function (){var statearr_37257 = state_37111;
(statearr_37257[(4)] = cljs.core.rest.call(null,(state_37111[(4)])));

return statearr_37257;
})();
var state_37111__$1 = state_37111;
var statearr_37258_37428 = state_37111__$1;
(statearr_37258_37428[(2)] = inst_37106);

(statearr_37258_37428[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (81))){
var inst_36993 = (state_37111[(22)]);
var inst_36993__$1 = cljs.core.sequential_QMARK_.call(null,from);
var state_37111__$1 = (function (){var statearr_37259 = state_37111;
(statearr_37259[(22)] = inst_36993__$1);

return statearr_37259;
})();
if(inst_36993__$1){
var statearr_37260_37429 = state_37111__$1;
(statearr_37260_37429[(1)] = (91));

} else {
var statearr_37261_37430 = state_37111__$1;
(statearr_37261_37430[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (120))){
var state_37111__$1 = state_37111;
var statearr_37262_37431 = state_37111__$1;
(statearr_37262_37431[(2)] = null);

(statearr_37262_37431[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (79))){
var inst_36965 = (state_37111[(2)]);
var inst_36966 = fluree.db.util.async.throw_err.call(null,inst_36965);
var state_37111__$1 = state_37111;
var statearr_37263_37432 = state_37111__$1;
(statearr_37263_37432[(2)] = inst_36966);

(statearr_37263_37432[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (38))){
var state_37111__$1 = state_37111;
var statearr_37264_37433 = state_37111__$1;
(statearr_37264_37433[(2)] = null);

(statearr_37264_37433[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (126))){
var inst_37090 = (state_37111[(41)]);
var state_37111__$1 = state_37111;
var statearr_37265_37434 = state_37111__$1;
(statearr_37265_37434[(2)] = inst_37090);

(statearr_37265_37434[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (98))){
var inst_36804 = (state_37111[(18)]);
var inst_37047 = (state_37111[(2)]);
var inst_37048 = cljs.core.PersistentVector.EMPTY;
var inst_37049 = cljs.core.into.call(null,inst_37048,inst_37047);
var state_37111__$1 = (function (){var statearr_37266 = state_37111;
(statearr_37266[(34)] = inst_37049);

return statearr_37266;
})();
if(cljs.core.truth_(inst_36804)){
var statearr_37267_37435 = state_37111__$1;
(statearr_37267_37435[(1)] = (113));

} else {
var statearr_37268_37436 = state_37111__$1;
(statearr_37268_37436[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (124))){
var inst_37090 = (state_37111[(41)]);
var inst_37089 = (state_37111[(2)]);
var inst_37090__$1 = selectOne;
var state_37111__$1 = (function (){var statearr_37269 = state_37111;
(statearr_37269[(41)] = inst_37090__$1);

(statearr_37269[(11)] = inst_37089);

return statearr_37269;
})();
if(cljs.core.truth_(inst_37090__$1)){
var statearr_37270_37437 = state_37111__$1;
(statearr_37270_37437[(1)] = (125));

} else {
var statearr_37271_37438 = state_37111__$1;
(statearr_37271_37438[(1)] = (126));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (87))){
var inst_36985 = (state_37111[(2)]);
var inst_36986 = fluree.db.util.async.throw_err.call(null,inst_36985);
var state_37111__$1 = (function (){var statearr_37272 = state_37111;
(statearr_37272[(31)] = inst_36986);

return statearr_37272;
})();
if(cljs.core.truth_(fuel)){
var statearr_37273_37439 = state_37111__$1;
(statearr_37273_37439[(1)] = (88));

} else {
var statearr_37274_37440 = state_37111__$1;
(statearr_37274_37440[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (30))){
var inst_36854 = typeof from === 'string';
var state_37111__$1 = state_37111;
if(cljs.core.truth_(inst_36854)){
var statearr_37275_37441 = state_37111__$1;
(statearr_37275_37441[(1)] = (33));

} else {
var statearr_37276_37442 = state_37111__$1;
(statearr_37276_37442[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (73))){
var inst_36968 = fluree.db.util.core.subj_ident_QMARK_.call(null,from);
var state_37111__$1 = state_37111;
if(inst_36968){
var statearr_37277_37443 = state_37111__$1;
(statearr_37277_37443[(1)] = (80));

} else {
var statearr_37278_37444 = state_37111__$1;
(statearr_37278_37444[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (96))){
var inst_37074 = (state_37111[(2)]);
var state_37111__$1 = state_37111;
var statearr_37279_37445 = state_37111__$1;
(statearr_37279_37445[(2)] = inst_37074);

(statearr_37279_37445[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (10))){
var inst_36788 = (state_37111[(39)]);
var inst_36788__$1 = selectDistinct;
var state_37111__$1 = (function (){var statearr_37280 = state_37111;
(statearr_37280[(39)] = inst_36788__$1);

return statearr_37280;
})();
if(cljs.core.truth_(inst_36788__$1)){
var statearr_37281_37446 = state_37111__$1;
(statearr_37281_37446[(1)] = (12));

} else {
var statearr_37282_37447 = state_37111__$1;
(statearr_37282_37447[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (18))){
var inst_36804 = (state_37111[(18)]);
var inst_36819 = cljs.core.vector_QMARK_.call(null,inst_36804);
var state_37111__$1 = state_37111;
if(inst_36819){
var statearr_37283_37448 = state_37111__$1;
(statearr_37283_37448[(1)] = (21));

} else {
var statearr_37284_37449 = state_37111__$1;
(statearr_37284_37449[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (105))){
var inst_37028 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core.inc);
var state_37111__$1 = state_37111;
var statearr_37285_37450 = state_37111__$1;
(statearr_37285_37450[(2)] = inst_37028);

(statearr_37285_37450[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (52))){
var inst_36894 = (state_37111[(2)]);
var state_37111__$1 = (function (){var statearr_37286 = state_37111;
(statearr_37286[(21)] = inst_36894);

return statearr_37286;
})();
var statearr_37287_37451 = state_37111__$1;
(statearr_37287_37451[(1)] = (53));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (114))){
var inst_36805 = (state_37111[(14)]);
var state_37111__$1 = state_37111;
var statearr_37289_37452 = state_37111__$1;
(statearr_37289_37452[(2)] = inst_36805);

(statearr_37289_37452[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (67))){
var inst_36933 = cljs.core.PersistentHashMap.EMPTY;
var state_37111__$1 = state_37111;
var statearr_37290_37453 = state_37111__$1;
(statearr_37290_37453[(2)] = inst_36933);

(statearr_37290_37453[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (71))){
var inst_36946 = (state_37111[(2)]);
var inst_36947 = fluree.db.util.async.throw_err.call(null,inst_36946);
var state_37111__$1 = state_37111;
var statearr_37291_37454 = state_37111__$1;
(statearr_37291_37454[(2)] = inst_36947);

(statearr_37291_37454[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (42))){
var inst_36807 = (state_37111[(15)]);
var state_37111__$1 = state_37111;
var statearr_37292_37455 = state_37111__$1;
(statearr_37292_37455[(2)] = inst_36807);

(statearr_37292_37455[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (80))){
var inst_36971 = fluree.db.dbproto._subid.call(null,db,from,false);
var state_37111__$1 = state_37111;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37111__$1,(83),inst_36971);
} else {
if((state_val_37112 === (37))){
var inst_36876 = (state_37111[(2)]);
var inst_36877 = fluree.db.util.async.throw_err.call(null,inst_36876);
var state_37111__$1 = state_37111;
var statearr_37293_37456 = state_37111__$1;
(statearr_37293_37456[(2)] = inst_36877);

(statearr_37293_37456[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (63))){
var inst_36930 = (state_37111[(2)]);
var state_37111__$1 = state_37111;
if(cljs.core.truth_(inst_36930)){
var statearr_37294_37457 = state_37111__$1;
(statearr_37294_37457[(1)] = (64));

} else {
var statearr_37295_37458 = state_37111__$1;
(statearr_37295_37458[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (94))){
var inst_37007 = from;
var inst_37008 = cljs.core.seq.call(null,inst_37007);
var inst_37009 = cljs.core.first.call(null,inst_37008);
var inst_37010 = cljs.core.next.call(null,inst_37008);
var inst_37011 = cljs.core.PersistentVector.EMPTY;
var inst_37012 = inst_37007;
var inst_37013 = inst_37011;
var state_37111__$1 = (function (){var statearr_37296 = state_37111;
(statearr_37296[(42)] = inst_37010);

(statearr_37296[(43)] = inst_37009);

(statearr_37296[(10)] = inst_37013);

(statearr_37296[(38)] = inst_37012);

return statearr_37296;
})();
var statearr_37297_37459 = state_37111__$1;
(statearr_37297_37459[(2)] = null);

(statearr_37297_37459[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (8))){
var inst_36806 = (state_37111[(24)]);
var inst_36801 = (state_37111[(2)]);
var inst_36802 = opts_SINGLEQUOTE_;
var inst_36803 = cljs.core.__destructure_map.call(null,inst_36802);
var inst_36804 = cljs.core.get.call(null,inst_36803,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_36805 = cljs.core.get.call(null,inst_36803,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_36806__$1 = cljs.core.get.call(null,inst_36803,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_36807 = cljs.core.get.call(null,inst_36803,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_36808 = fluree.db.query.fql_parser.parse_db.call(null,db,inst_36801,opts_SINGLEQUOTE_);
var inst_36809 = (inst_36806__$1 == null);
var inst_36810 = cljs.core.not.call(null,inst_36809);
var state_37111__$1 = (function (){var statearr_37298 = state_37111;
(statearr_37298[(14)] = inst_36805);

(statearr_37298[(18)] = inst_36804);

(statearr_37298[(15)] = inst_36807);

(statearr_37298[(24)] = inst_36806__$1);

(statearr_37298[(25)] = inst_36808);

return statearr_37298;
})();
if(inst_36810){
var statearr_37299_37460 = state_37111__$1;
(statearr_37299_37460[(1)] = (15));

} else {
var statearr_37300_37461 = state_37111__$1;
(statearr_37300_37461[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (49))){
var inst_37082 = (state_37111[(2)]);
var state_37111__$1 = state_37111;
var statearr_37301_37462 = state_37111__$1;
(statearr_37301_37462[(2)] = inst_37082);

(statearr_37301_37462[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37112 === (84))){
var state_37111__$1 = state_37111;
var statearr_37302_37463 = state_37111__$1;
(statearr_37302_37463[(2)] = null);

(statearr_37302_37463[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__10945__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__10945__auto____0 = (function (){
var statearr_37303 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37303[(0)] = fluree$db$query$fql$query_$_state_machine__10945__auto__);

(statearr_37303[(1)] = (1));

return statearr_37303;
});
var fluree$db$query$fql$query_$_state_machine__10945__auto____1 = (function (state_37111){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_37111);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e37304){var ex__10948__auto__ = e37304;
var statearr_37305_37464 = state_37111;
(statearr_37305_37464[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_37111[(4)]))){
var statearr_37306_37465 = state_37111;
(statearr_37306_37465[(1)] = cljs.core.first.call(null,(state_37111[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37466 = state_37111;
state_37111 = G__37466;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__10945__auto__ = function(state_37111){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__10945__auto____1.call(this,state_37111);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__10945__auto____0;
fluree$db$query$fql$query_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__10945__auto____1;
return fluree$db$query$fql$query_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_37307 = f__11019__auto__.call(null);
(statearr_37307[(6)] = c__11018__auto__);

return statearr_37307;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}

});
