// Compiled by ClojureScript 1.11.57 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),idx)) && ((((!((start_flake.o == null)))) && (((cljs.core._EQ_.call(null,start_flake.o,end_flake.o)) && (((cljs.core._EQ_.call(null,(-1),start_flake.p)) && (cljs.core._EQ_.call(null,fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)))))))));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__5045__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__24725 = match;
var p1 = cljs.core.nth.call(null,vec__24725,(0),null);
var p2 = cljs.core.nth.call(null,vec__24725,(1),null);
var p3 = cljs.core.nth.call(null,vec__24725,(2),null);
var t = cljs.core.nth.call(null,vec__24725,(3),null);
var op = cljs.core.nth.call(null,vec__24725,(4),null);
var m = cljs.core.nth.call(null,vec__24725,(5),null);
var G__24728 = idx;
var G__24728__$1 = (((G__24728 instanceof cljs.core.Keyword))?G__24728.fqn:null);
switch (G__24728__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__24728__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__24730 = idx;
var G__24730__$1 = (((G__24730 instanceof cljs.core.Keyword))?G__24730.fqn:null);
switch (G__24730__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__24730__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__24732 = idx;
var G__24732__$1 = (((G__24732 instanceof cljs.core.Keyword))?G__24732.fqn:null);
switch (G__24732__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__24732__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__24735 = arguments.length;
switch (G__24735) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__24736 = (function (){var pred__24739 = cljs.core.identical_QMARK_;
var expr__24740 = test;
if(cljs.core.truth_(pred__24739.call(null,cljs.core._EQ_,expr__24740))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__24739.call(null,cljs.core._LT_,expr__24740))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__24739.call(null,cljs.core._LT__EQ_,expr__24740))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__24739.call(null,cljs.core._GT_,expr__24740))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__24739.call(null,cljs.core._GT__EQ_,expr__24740))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__24740)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__24736,(0),null);
var start_match = cljs.core.nth.call(null,vec__24736,(1),null);
var end_test = cljs.core.nth.call(null,vec__24736,(2),null);
var end_match = cljs.core.nth.call(null,vec__24736,(3),null);
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_24979){
var state_val_24980 = (state_24979[(1)]);
if((state_val_24980 === (65))){
var inst_24894 = (state_24979[(7)]);
var inst_24950 = (state_24979[(8)]);
var inst_24950__$1 = (state_24979[(2)]);
var inst_24951 = cljs.core.count.call(null,inst_24950__$1);
var state_24979__$1 = (function (){var statearr_24981 = state_24979;
(statearr_24981[(9)] = inst_24951);

(statearr_24981[(8)] = inst_24950__$1);

return statearr_24981;
})();
if(cljs.core.truth_(inst_24894)){
var statearr_24982_25119 = state_24979__$1;
(statearr_24982_25119[(1)] = (81));

} else {
var statearr_24983_25120 = state_24979__$1;
(statearr_24983_25120[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (70))){
var inst_24925 = (state_24979[(2)]);
var state_24979__$1 = state_24979;
if(cljs.core.truth_(inst_24925)){
var statearr_24984_25121 = state_24979__$1;
(statearr_24984_25121[(1)] = (71));

} else {
var statearr_24985_25122 = state_24979__$1;
(statearr_24985_25122[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (62))){
var inst_24864 = (state_24979[(10)]);
var inst_24878 = (state_24979[(11)]);
var inst_24893 = (state_24979[(2)]);
var inst_24894 = fluree.db.dbproto._rhs.call(null,inst_24878);
var state_24979__$1 = (function (){var statearr_24986 = state_24979;
(statearr_24986[(7)] = inst_24894);

(statearr_24986[(12)] = inst_24893);

return statearr_24986;
})();
if(cljs.core.truth_(inst_24864)){
var statearr_24987_25123 = state_24979__$1;
(statearr_24987_25123[(1)] = (63));

} else {
var statearr_24988_25124 = state_24979__$1;
(statearr_24988_25124[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (74))){
var inst_24918 = (state_24979[(13)]);
var inst_24932 = fluree.db.permissions_validate.allow_flake_QMARK_.call(null,db,inst_24918);
var state_24979__$1 = state_24979;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24979__$1,(77),inst_24932);
} else {
if((state_val_24980 === (7))){
var inst_24755 = (state_24979[(14)]);
var state_24979__$1 = state_24979;
var statearr_24989_25125 = state_24979__$1;
(statearr_24989_25125[(2)] = inst_24755);

(statearr_24989_25125[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (59))){
var inst_24885 = (state_24979[(15)]);
var inst_24840 = (state_24979[(16)]);
var inst_24841 = (state_24979[(17)]);
var inst_24884 = (state_24979[(2)]);
var inst_24885__$1 = fluree.db.util.async.throw_err.call(null,inst_24884);
var inst_24886 = fluree.db.flake.subrange.call(null,inst_24885__$1,start_test,inst_24840,end_test,inst_24841);
var inst_24887 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_24840,inst_24841);
var state_24979__$1 = (function (){var statearr_24990 = state_24979;
(statearr_24990[(15)] = inst_24885__$1);

(statearr_24990[(18)] = inst_24886);

return statearr_24990;
})();
if(inst_24887){
var statearr_24991_25126 = state_24979__$1;
(statearr_24991_25126[(1)] = (60));

} else {
var statearr_24992_25127 = state_24979__$1;
(statearr_24992_25127[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (86))){
var inst_24959 = (state_24979[(2)]);
var state_24979__$1 = state_24979;
var statearr_24993_25128 = state_24979__$1;
(statearr_24993_25128[(2)] = inst_24959);

(statearr_24993_25128[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (20))){
var inst_24756 = (state_24979[(19)]);
var inst_24804 = (state_24979[(20)]);
var inst_24803 = (state_24979[(2)]);
var inst_24804__$1 = (inst_24756 == null);
var state_24979__$1 = (function (){var statearr_24994 = state_24979;
(statearr_24994[(20)] = inst_24804__$1);

(statearr_24994[(21)] = inst_24803);

return statearr_24994;
})();
if(cljs.core.truth_(inst_24804__$1)){
var statearr_24995_25129 = state_24979__$1;
(statearr_24995_25129[(1)] = (22));

} else {
var statearr_24996_25130 = state_24979__$1;
(statearr_24996_25130[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (72))){
var inst_24911 = (state_24979[(22)]);
var inst_24929 = (inst_24911 + (1));
var inst_24930 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_24979__$1 = (function (){var statearr_24997 = state_24979;
(statearr_24997[(23)] = inst_24929);

return statearr_24997;
})();
if(cljs.core.truth_(inst_24930)){
var statearr_24998_25131 = state_24979__$1;
(statearr_24998_25131[(1)] = (74));

} else {
var statearr_24999_25132 = state_24979__$1;
(statearr_24999_25132[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (58))){
var inst_24974 = (state_24979[(2)]);
var _ = (function (){var statearr_25000 = state_24979;
(statearr_25000[(4)] = cljs.core.rest.call(null,(state_24979[(4)])));

return statearr_25000;
})();
var state_24979__$1 = state_24979;
var statearr_25001_25133 = state_24979__$1;
(statearr_25001_25133[(2)] = inst_24974);

(statearr_25001_25133[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (60))){
var inst_24839 = (state_24979[(24)]);
var inst_24812 = (state_24979[(25)]);
var inst_24851 = (state_24979[(26)]);
var inst_24758 = (state_24979[(27)]);
var inst_24759 = (state_24979[(28)]);
var inst_24873 = (state_24979[(29)]);
var inst_24885 = (state_24979[(15)]);
var inst_24858 = (state_24979[(30)]);
var inst_24840 = (state_24979[(16)]);
var inst_24879 = (state_24979[(31)]);
var inst_24880 = (state_24979[(32)]);
var inst_24785 = (state_24979[(33)]);
var inst_24821 = (state_24979[(34)]);
var inst_24766 = (state_24979[(35)]);
var inst_24847 = (state_24979[(36)]);
var inst_24754 = (state_24979[(37)]);
var inst_24864 = (state_24979[(10)]);
var inst_24765 = (state_24979[(38)]);
var inst_24878 = (state_24979[(11)]);
var inst_24803 = (state_24979[(21)]);
var inst_24846 = (state_24979[(39)]);
var inst_24776 = (state_24979[(40)]);
var inst_24857 = (state_24979[(41)]);
var inst_24886 = (state_24979[(18)]);
var inst_24841 = (state_24979[(17)]);
var inst_24794 = (state_24979[(42)]);
var inst_24830 = (state_24979[(43)]);
var inst_24761 = (state_24979[(44)]);
var inst_24868 = (state_24979[(45)]);
var inst_24889 = (function (){var no_filter_QMARK_ = inst_24864;
var next_node = inst_24878;
var flakes = inst_24885;
var s1 = inst_24776;
var o2 = inst_24803;
var t1 = inst_24758;
var i = inst_24879;
var m1 = inst_24830;
var root_node = inst_24873;
var to_t = inst_24858;
var s2 = inst_24785;
var p2 = inst_24821;
var permissions = inst_24847;
var limit = inst_24846;
var start_flake = inst_24840;
var vec__24751 = inst_24761;
var acc = inst_24880;
var t2 = inst_24765;
var op1 = inst_24759;
var o1 = inst_24794;
var end_flake = inst_24841;
var base_result = inst_24886;
var p1 = inst_24812;
var vec__24748 = inst_24754;
var idx_compare = inst_24851;
var op2 = inst_24766;
var from_t = inst_24857;
var m2 = inst_24839;
var novelty = inst_24868;
return (function (filtered_result,f){
if(cljs.core._EQ_.call(null,f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.call(null,filtered_result,f);
}
});
})();
var inst_24890 = cljs.core.reduce.call(null,inst_24889,inst_24886,inst_24886);
var state_24979__$1 = state_24979;
var statearr_25002_25134 = state_24979__$1;
(statearr_25002_25134[(2)] = inst_24890);

(statearr_25002_25134[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (27))){
var inst_24763 = (state_24979[(46)]);
var inst_24813 = (state_24979[(47)]);
var inst_24812 = (state_24979[(2)]);
var inst_24813__$1 = (inst_24763 == null);
var state_24979__$1 = (function (){var statearr_25003 = state_24979;
(statearr_25003[(25)] = inst_24812);

(statearr_25003[(47)] = inst_24813__$1);

return statearr_25003;
})();
if(cljs.core.truth_(inst_24813__$1)){
var statearr_25004_25135 = state_24979__$1;
(statearr_25004_25135[(1)] = (28));

} else {
var statearr_25005_25136 = state_24979__$1;
(statearr_25005_25136[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (1))){
var state_24979__$1 = state_24979;
var statearr_25006_25137 = state_24979__$1;
(statearr_25006_25137[(2)] = null);

(statearr_25006_25137[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (69))){
var inst_24846 = (state_24979[(39)]);
var inst_24911 = (state_24979[(22)]);
var inst_24923 = (inst_24911 > inst_24846);
var state_24979__$1 = state_24979;
var statearr_25007_25138 = state_24979__$1;
(statearr_25007_25138[(2)] = inst_24923);

(statearr_25007_25138[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (24))){
var inst_24808 = (state_24979[(2)]);
var state_24979__$1 = state_24979;
if(cljs.core.truth_(inst_24808)){
var statearr_25008_25139 = state_24979__$1;
(statearr_25008_25139[(1)] = (25));

} else {
var statearr_25009_25140 = state_24979__$1;
(statearr_25009_25140[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (55))){
var inst_24873 = (state_24979[(29)]);
var inst_24840 = (state_24979[(16)]);
var inst_24872 = (state_24979[(2)]);
var inst_24873__$1 = fluree.db.util.async.throw_err.call(null,inst_24872);
var inst_24874 = fluree.db.dbproto._lookup_leaf.call(null,inst_24873__$1,inst_24840);
var state_24979__$1 = (function (){var statearr_25010 = state_24979;
(statearr_25010[(29)] = inst_24873__$1);

return statearr_25010;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24979__$1,(56),inst_24874);
} else {
if((state_val_24980 === (85))){
var inst_24954 = (state_24979[(48)]);
var state_24979__$1 = state_24979;
var statearr_25011_25141 = state_24979__$1;
(statearr_25011_25141[(2)] = inst_24954);

(statearr_25011_25141[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (39))){
var inst_24828 = (state_24979[(2)]);
var state_24979__$1 = state_24979;
var statearr_25012_25142 = state_24979__$1;
(statearr_25012_25142[(2)] = inst_24828);

(statearr_25012_25142[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (88))){
var inst_24894 = (state_24979[(7)]);
var inst_24873 = (state_24979[(29)]);
var inst_24966 = fluree.db.dbproto._lookup_leaf.call(null,inst_24873,inst_24894);
var state_24979__$1 = state_24979;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24979__$1,(90),inst_24966);
} else {
if((state_val_24980 === (46))){
var inst_24842 = (state_24979[(49)]);
var state_24979__$1 = state_24979;
var statearr_25013_25143 = state_24979__$1;
(statearr_25013_25143[(2)] = inst_24842);

(statearr_25013_25143[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (4))){
var inst_24742 = (state_24979[(2)]);
var state_24979__$1 = state_24979;
var statearr_25014_25144 = state_24979__$1;
(statearr_25014_25144[(2)] = inst_24742);

(statearr_25014_25144[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (77))){
var inst_24934 = (state_24979[(2)]);
var inst_24935 = fluree.db.util.async.throw_err.call(null,inst_24934);
var state_24979__$1 = state_24979;
if(cljs.core.truth_(inst_24935)){
var statearr_25015_25145 = state_24979__$1;
(statearr_25015_25145[(1)] = (78));

} else {
var statearr_25016_25146 = state_24979__$1;
(statearr_25016_25146[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (54))){
var inst_24864 = (state_24979[(2)]);
var inst_24865 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24866 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_24867 = (new cljs.core.PersistentVector(null,2,(5),inst_24865,inst_24866,null));
var inst_24868 = cljs.core.get_in.call(null,db,inst_24867);
var inst_24869 = cljs.core.get.call(null,db,idx);
var inst_24870 = fluree.db.dbproto._resolve.call(null,inst_24869);
var state_24979__$1 = (function (){var statearr_25017 = state_24979;
(statearr_25017[(10)] = inst_24864);

(statearr_25017[(45)] = inst_24868);

return statearr_25017;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24979__$1,(55),inst_24870);
} else {
if((state_val_24980 === (15))){
var inst_24757 = (state_24979[(50)]);
var state_24979__$1 = state_24979;
var statearr_25018_25147 = state_24979__$1;
(statearr_25018_25147[(2)] = inst_24757);

(statearr_25018_25147[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (48))){
var inst_24852 = (state_24979[(51)]);
var inst_24846 = (state_24979[(2)]);
var inst_24847 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_24848 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24849 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_24850 = (new cljs.core.PersistentVector(null,3,(5),inst_24848,inst_24849,null));
var inst_24851 = cljs.core.get_in.call(null,db,inst_24850);
var inst_24852__$1 = new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(opts);
var state_24979__$1 = (function (){var statearr_25019 = state_24979;
(statearr_25019[(26)] = inst_24851);

(statearr_25019[(36)] = inst_24847);

(statearr_25019[(39)] = inst_24846);

(statearr_25019[(51)] = inst_24852__$1);

return statearr_25019;
})();
if(cljs.core.truth_(inst_24852__$1)){
var statearr_25020_25148 = state_24979__$1;
(statearr_25020_25148[(1)] = (49));

} else {
var statearr_25021_25149 = state_24979__$1;
(statearr_25021_25149[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (50))){
var inst_24855 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var state_24979__$1 = state_24979;
var statearr_25022_25150 = state_24979__$1;
(statearr_25022_25150[(2)] = inst_24855);

(statearr_25022_25150[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (75))){
var inst_24912 = (state_24979[(52)]);
var state_24979__$1 = state_24979;
var statearr_25023_25151 = state_24979__$1;
(statearr_25023_25151[(2)] = inst_24912);

(statearr_25023_25151[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (21))){
var inst_24799 = (state_24979[(2)]);
var inst_24800 = fluree.db.util.async.throw_err.call(null,inst_24799);
var state_24979__$1 = state_24979;
var statearr_25024_25152 = state_24979__$1;
(statearr_25024_25152[(2)] = inst_24800);

(statearr_25024_25152[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (31))){
var state_24979__$1 = state_24979;
var statearr_25025_25153 = state_24979__$1;
(statearr_25025_25153[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_25025_25153[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (32))){
var inst_24763 = (state_24979[(46)]);
var state_24979__$1 = state_24979;
var statearr_25026_25154 = state_24979__$1;
(statearr_25026_25154[(2)] = inst_24763);

(statearr_25026_25154[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (40))){
var inst_24767 = (state_24979[(53)]);
var state_24979__$1 = state_24979;
var statearr_25027_25155 = state_24979__$1;
(statearr_25027_25155[(2)] = inst_24767);

(statearr_25027_25155[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (56))){
var inst_24876 = (state_24979[(2)]);
var inst_24877 = fluree.db.util.async.throw_err.call(null,inst_24876);
var inst_24878 = inst_24877;
var inst_24879 = (0);
var inst_24880 = null;
var state_24979__$1 = (function (){var statearr_25028 = state_24979;
(statearr_25028[(31)] = inst_24879);

(statearr_25028[(32)] = inst_24880);

(statearr_25028[(11)] = inst_24878);

return statearr_25028;
})();
var statearr_25029_25156 = state_24979__$1;
(statearr_25029_25156[(2)] = null);

(statearr_25029_25156[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (33))){
var inst_24760 = (state_24979[(54)]);
var inst_24821 = (state_24979[(2)]);
var state_24979__$1 = (function (){var statearr_25030 = state_24979;
(statearr_25030[(34)] = inst_24821);

return statearr_25030;
})();
if(cljs.core.truth_(inst_24760)){
var statearr_25031_25157 = state_24979__$1;
(statearr_25031_25157[(1)] = (34));

} else {
var statearr_25032_25158 = state_24979__$1;
(statearr_25032_25158[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (13))){
var inst_24781 = (state_24979[(2)]);
var inst_24782 = fluree.db.util.async.throw_err.call(null,inst_24781);
var state_24979__$1 = state_24979;
var statearr_25033_25159 = state_24979__$1;
(statearr_25033_25159[(2)] = inst_24782);

(statearr_25033_25159[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (22))){
var inst_24794 = (state_24979[(42)]);
var state_24979__$1 = state_24979;
var statearr_25034_25160 = state_24979__$1;
(statearr_25034_25160[(2)] = inst_24794);

(statearr_25034_25160[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (90))){
var inst_24951 = (state_24979[(9)]);
var inst_24950 = (state_24979[(8)]);
var inst_24968 = (state_24979[(2)]);
var inst_24969 = fluree.db.util.async.throw_err.call(null,inst_24968);
var inst_24878 = inst_24969;
var inst_24879 = inst_24951;
var inst_24880 = inst_24950;
var state_24979__$1 = (function (){var statearr_25035 = state_24979;
(statearr_25035[(31)] = inst_24879);

(statearr_25035[(32)] = inst_24880);

(statearr_25035[(11)] = inst_24878);

return statearr_25035;
})();
var statearr_25036_25161 = state_24979__$1;
(statearr_25036_25161[(2)] = null);

(statearr_25036_25161[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (36))){
var inst_24767 = (state_24979[(53)]);
var inst_24830 = (state_24979[(2)]);
var state_24979__$1 = (function (){var statearr_25037 = state_24979;
(statearr_25037[(43)] = inst_24830);

return statearr_25037;
})();
if(cljs.core.truth_(inst_24767)){
var statearr_25038_25162 = state_24979__$1;
(statearr_25038_25162[(1)] = (40));

} else {
var statearr_25039_25163 = state_24979__$1;
(statearr_25039_25163[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (41))){
var inst_24833 = (cljs.core._LT__EQ_ === end_test);
var state_24979__$1 = state_24979;
if(cljs.core.truth_(inst_24833)){
var statearr_25040_25164 = state_24979__$1;
(statearr_25040_25164[(1)] = (43));

} else {
var statearr_25041_25165 = state_24979__$1;
(statearr_25041_25165[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (89))){
var inst_24972 = (state_24979[(2)]);
var state_24979__$1 = state_24979;
var statearr_25042_25166 = state_24979__$1;
(statearr_25042_25166[(2)] = inst_24972);

(statearr_25042_25166[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (43))){
var state_24979__$1 = state_24979;
var statearr_25043_25167 = state_24979__$1;
(statearr_25043_25167[(2)] = (2147483647));

(statearr_25043_25167[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (61))){
var inst_24886 = (state_24979[(18)]);
var state_24979__$1 = state_24979;
var statearr_25044_25168 = state_24979__$1;
(statearr_25044_25168[(2)] = inst_24886);

(statearr_25044_25168[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (29))){
var inst_24813 = (state_24979[(47)]);
var state_24979__$1 = state_24979;
var statearr_25045_25169 = state_24979__$1;
(statearr_25045_25169[(2)] = inst_24813);

(statearr_25045_25169[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (44))){
var state_24979__$1 = state_24979;
var statearr_25046_25170 = state_24979__$1;
(statearr_25046_25170[(2)] = fluree.db.util.core.min_integer);

(statearr_25046_25170[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (6))){
var inst_24755 = (state_24979[(14)]);
var inst_24770 = fluree.db.dbproto._subid.call(null,db,inst_24755);
var state_24979__$1 = state_24979;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24979__$1,(9),inst_24770);
} else {
if((state_val_24980 === (28))){
var inst_24803 = (state_24979[(21)]);
var state_24979__$1 = state_24979;
var statearr_25047_25171 = state_24979__$1;
(statearr_25047_25171[(2)] = inst_24803);

(statearr_25047_25171[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (64))){
var inst_24893 = (state_24979[(12)]);
var inst_24879 = (state_24979[(31)]);
var inst_24907 = cljs.core.seq.call(null,inst_24893);
var inst_24908 = cljs.core.first.call(null,inst_24907);
var inst_24909 = cljs.core.next.call(null,inst_24907);
var inst_24910 = inst_24893;
var inst_24911 = inst_24879;
var inst_24912 = inst_24893;
var state_24979__$1 = (function (){var statearr_25048 = state_24979;
(statearr_25048[(52)] = inst_24912);

(statearr_25048[(55)] = inst_24908);

(statearr_25048[(56)] = inst_24909);

(statearr_25048[(57)] = inst_24910);

(statearr_25048[(22)] = inst_24911);

return statearr_25048;
})();
var statearr_25049_25172 = state_24979__$1;
(statearr_25049_25172[(2)] = null);

(statearr_25049_25172[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (51))){
var inst_24857 = (state_24979[(2)]);
var inst_24858 = new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(opts);
var inst_24859 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_24979__$1 = (function (){var statearr_25050 = state_24979;
(statearr_25050[(30)] = inst_24858);

(statearr_25050[(41)] = inst_24857);

return statearr_25050;
})();
if(cljs.core.truth_(inst_24859)){
var statearr_25051_25173 = state_24979__$1;
(statearr_25051_25173[(1)] = (52));

} else {
var statearr_25052_25174 = state_24979__$1;
(statearr_25052_25174[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (25))){
var state_24979__$1 = state_24979;
var statearr_25053_25175 = state_24979__$1;
(statearr_25053_25175[(2)] = (-1));

(statearr_25053_25175[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (34))){
var inst_24760 = (state_24979[(54)]);
var state_24979__$1 = state_24979;
var statearr_25054_25176 = state_24979__$1;
(statearr_25054_25176[(2)] = inst_24760);

(statearr_25054_25176[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (17))){
var inst_24790 = (state_24979[(2)]);
var inst_24791 = fluree.db.util.async.throw_err.call(null,inst_24790);
var state_24979__$1 = state_24979;
var statearr_25055_25177 = state_24979__$1;
(statearr_25055_25177[(2)] = inst_24791);

(statearr_25055_25177[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (3))){
var inst_24977 = (state_24979[(2)]);
var state_24979__$1 = state_24979;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24979__$1,inst_24977);
} else {
if((state_val_24980 === (12))){
var inst_24757 = (state_24979[(50)]);
var inst_24785 = (state_24979[(2)]);
var inst_24786 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_24757);
var state_24979__$1 = (function (){var statearr_25056 = state_24979;
(statearr_25056[(33)] = inst_24785);

return statearr_25056;
})();
if(inst_24786){
var statearr_25057_25178 = state_24979__$1;
(statearr_25057_25178[(1)] = (14));

} else {
var statearr_25058_25179 = state_24979__$1;
(statearr_25058_25179[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (2))){
var inst_24755 = (state_24979[(14)]);
var inst_24754 = (state_24979[(37)]);
var inst_24761 = (state_24979[(44)]);
var _ = (function (){var statearr_25059 = state_24979;
(statearr_25059[(4)] = cljs.core.cons.call(null,(5),(state_24979[(4)])));

return statearr_25059;
})();
var inst_24754__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_24755__$1 = cljs.core.nth.call(null,inst_24754__$1,(0),null);
var inst_24756 = cljs.core.nth.call(null,inst_24754__$1,(1),null);
var inst_24757 = cljs.core.nth.call(null,inst_24754__$1,(2),null);
var inst_24758 = cljs.core.nth.call(null,inst_24754__$1,(3),null);
var inst_24759 = cljs.core.nth.call(null,inst_24754__$1,(4),null);
var inst_24760 = cljs.core.nth.call(null,inst_24754__$1,(5),null);
var inst_24761__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_24762 = cljs.core.nth.call(null,inst_24761__$1,(0),null);
var inst_24763 = cljs.core.nth.call(null,inst_24761__$1,(1),null);
var inst_24764 = cljs.core.nth.call(null,inst_24761__$1,(2),null);
var inst_24765 = cljs.core.nth.call(null,inst_24761__$1,(3),null);
var inst_24766 = cljs.core.nth.call(null,inst_24761__$1,(4),null);
var inst_24767 = cljs.core.nth.call(null,inst_24761__$1,(5),null);
var inst_24768 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_24755__$1);
var state_24979__$1 = (function (){var statearr_25060 = state_24979;
(statearr_25060[(27)] = inst_24758);

(statearr_25060[(28)] = inst_24759);

(statearr_25060[(14)] = inst_24755__$1);

(statearr_25060[(58)] = inst_24762);

(statearr_25060[(46)] = inst_24763);

(statearr_25060[(19)] = inst_24756);

(statearr_25060[(59)] = inst_24764);

(statearr_25060[(35)] = inst_24766);

(statearr_25060[(37)] = inst_24754__$1);

(statearr_25060[(38)] = inst_24765);

(statearr_25060[(50)] = inst_24757);

(statearr_25060[(54)] = inst_24760);

(statearr_25060[(53)] = inst_24767);

(statearr_25060[(44)] = inst_24761__$1);

return statearr_25060;
})();
if(inst_24768){
var statearr_25061_25180 = state_24979__$1;
(statearr_25061_25180[(1)] = (6));

} else {
var statearr_25062_25181 = state_24979__$1;
(statearr_25062_25181[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (66))){
var inst_24918 = (state_24979[(13)]);
var inst_24910 = (state_24979[(57)]);
var inst_24920 = (state_24979[(60)]);
var inst_24917 = cljs.core.seq.call(null,inst_24910);
var inst_24918__$1 = cljs.core.first.call(null,inst_24917);
var inst_24919 = cljs.core.next.call(null,inst_24917);
var inst_24920__$1 = (inst_24918__$1 == null);
var state_24979__$1 = (function (){var statearr_25063 = state_24979;
(statearr_25063[(13)] = inst_24918__$1);

(statearr_25063[(61)] = inst_24919);

(statearr_25063[(60)] = inst_24920__$1);

return statearr_25063;
})();
if(cljs.core.truth_(inst_24920__$1)){
var statearr_25064_25182 = state_24979__$1;
(statearr_25064_25182[(1)] = (68));

} else {
var statearr_25065_25183 = state_24979__$1;
(statearr_25065_25183[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (23))){
var inst_24804 = (state_24979[(20)]);
var state_24979__$1 = state_24979;
var statearr_25066_25184 = state_24979__$1;
(statearr_25066_25184[(2)] = inst_24804);

(statearr_25066_25184[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (47))){
var state_24979__$1 = state_24979;
var statearr_25067_25185 = state_24979__$1;
(statearr_25067_25185[(2)] = fluree.db.util.core.max_long);

(statearr_25067_25185[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (35))){
var inst_24824 = (cljs.core._GT__EQ_ === start_test);
var state_24979__$1 = state_24979;
if(cljs.core.truth_(inst_24824)){
var statearr_25068_25186 = state_24979__$1;
(statearr_25068_25186[(1)] = (37));

} else {
var statearr_25069_25187 = state_24979__$1;
(statearr_25069_25187[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (82))){
var inst_24894 = (state_24979[(7)]);
var state_24979__$1 = state_24979;
var statearr_25070_25188 = state_24979__$1;
(statearr_25070_25188[(2)] = inst_24894);

(statearr_25070_25188[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (76))){
var inst_24929 = (state_24979[(23)]);
var inst_24919 = (state_24979[(61)]);
var inst_24943 = (state_24979[(2)]);
var inst_24910 = inst_24919;
var inst_24911 = inst_24929;
var inst_24912 = inst_24943;
var state_24979__$1 = (function (){var statearr_25071 = state_24979;
(statearr_25071[(52)] = inst_24912);

(statearr_25071[(57)] = inst_24910);

(statearr_25071[(22)] = inst_24911);

return statearr_25071;
})();
var statearr_25072_25189 = state_24979__$1;
(statearr_25072_25189[(2)] = null);

(statearr_25072_25189[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (19))){
var inst_24764 = (state_24979[(59)]);
var state_24979__$1 = state_24979;
var statearr_25073_25190 = state_24979__$1;
(statearr_25073_25190[(2)] = inst_24764);

(statearr_25073_25190[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (57))){
var inst_24858 = (state_24979[(30)]);
var inst_24878 = (state_24979[(11)]);
var inst_24857 = (state_24979[(41)]);
var inst_24868 = (state_24979[(45)]);
var inst_24882 = fluree.db.dbproto._resolve_history_range.call(null,inst_24878,inst_24857,inst_24858,inst_24868);
var state_24979__$1 = state_24979;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24979__$1,(59),inst_24882);
} else {
if((state_val_24980 === (68))){
var inst_24920 = (state_24979[(60)]);
var state_24979__$1 = state_24979;
var statearr_25074_25191 = state_24979__$1;
(statearr_25074_25191[(2)] = inst_24920);

(statearr_25074_25191[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (11))){
var inst_24762 = (state_24979[(58)]);
var state_24979__$1 = state_24979;
var statearr_25076_25192 = state_24979__$1;
(statearr_25076_25192[(2)] = inst_24762);

(statearr_25076_25192[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (9))){
var inst_24772 = (state_24979[(2)]);
var inst_24773 = fluree.db.util.async.throw_err.call(null,inst_24772);
var state_24979__$1 = state_24979;
var statearr_25077_25193 = state_24979__$1;
(statearr_25077_25193[(2)] = inst_24773);

(statearr_25077_25193[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (5))){
var _ = (function (){var statearr_25078 = state_24979;
(statearr_25078[(4)] = cljs.core.rest.call(null,(state_24979[(4)])));

return statearr_25078;
})();
var state_24979__$1 = state_24979;
var ex25075 = (state_24979__$1[(2)]);
var statearr_25079_25194 = state_24979__$1;
(statearr_25079_25194[(5)] = ex25075);


if((ex25075 instanceof Error)){
var statearr_25080_25195 = state_24979__$1;
(statearr_25080_25195[(1)] = (4));

(statearr_25080_25195[(5)] = null);

} else {
throw ex25075;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (83))){
var inst_24962 = (state_24979[(2)]);
var inst_24963 = cljs.core.not.call(null,inst_24962);
var state_24979__$1 = state_24979;
if(inst_24963){
var statearr_25081_25196 = state_24979__$1;
(statearr_25081_25196[(1)] = (87));

} else {
var statearr_25082_25197 = state_24979__$1;
(statearr_25082_25197[(1)] = (88));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (14))){
var inst_24757 = (state_24979[(50)]);
var inst_24788 = fluree.db.dbproto._subid.call(null,db,inst_24757);
var state_24979__$1 = state_24979;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24979__$1,(17),inst_24788);
} else {
if((state_val_24980 === (45))){
var inst_24837 = (state_24979[(2)]);
var state_24979__$1 = state_24979;
var statearr_25083_25198 = state_24979__$1;
(statearr_25083_25198[(2)] = inst_24837);

(statearr_25083_25198[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (53))){
var state_24979__$1 = state_24979;
var statearr_25084_25199 = state_24979__$1;
(statearr_25084_25199[(2)] = true);

(statearr_25084_25199[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (78))){
var inst_24912 = (state_24979[(52)]);
var state_24979__$1 = state_24979;
var statearr_25085_25200 = state_24979__$1;
(statearr_25085_25200[(2)] = inst_24912);

(statearr_25085_25200[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (26))){
var inst_24756 = (state_24979[(19)]);
var state_24979__$1 = state_24979;
var statearr_25086_25201 = state_24979__$1;
(statearr_25086_25201[(2)] = inst_24756);

(statearr_25086_25201[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (16))){
var inst_24764 = (state_24979[(59)]);
var inst_24794 = (state_24979[(2)]);
var inst_24795 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_24764);
var state_24979__$1 = (function (){var statearr_25087 = state_24979;
(statearr_25087[(42)] = inst_24794);

return statearr_25087;
})();
if(inst_24795){
var statearr_25088_25202 = state_24979__$1;
(statearr_25088_25202[(1)] = (18));

} else {
var statearr_25089_25203 = state_24979__$1;
(statearr_25089_25203[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (81))){
var inst_24894 = (state_24979[(7)]);
var inst_24851 = (state_24979[(26)]);
var inst_24954 = (state_24979[(48)]);
var inst_24841 = (state_24979[(17)]);
var inst_24953 = inst_24851.call(null,inst_24894,inst_24841);
var inst_24954__$1 = (inst_24953 < (0));
var state_24979__$1 = (function (){var statearr_25090 = state_24979;
(statearr_25090[(48)] = inst_24954__$1);

return statearr_25090;
})();
if(cljs.core.truth_(inst_24954__$1)){
var statearr_25091_25204 = state_24979__$1;
(statearr_25091_25204[(1)] = (84));

} else {
var statearr_25092_25205 = state_24979__$1;
(statearr_25092_25205[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (79))){
var inst_24912 = (state_24979[(52)]);
var inst_24918 = (state_24979[(13)]);
var inst_24938 = cljs.core.disj.call(null,inst_24912,inst_24918);
var state_24979__$1 = state_24979;
var statearr_25093_25206 = state_24979__$1;
(statearr_25093_25206[(2)] = inst_24938);

(statearr_25093_25206[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (38))){
var state_24979__$1 = state_24979;
var statearr_25094_25207 = state_24979__$1;
(statearr_25094_25207[(2)] = (2147483647));

(statearr_25094_25207[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (87))){
var inst_24950 = (state_24979[(8)]);
var state_24979__$1 = state_24979;
var statearr_25095_25208 = state_24979__$1;
(statearr_25095_25208[(2)] = inst_24950);

(statearr_25095_25208[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (30))){
var inst_24817 = (state_24979[(2)]);
var state_24979__$1 = state_24979;
if(cljs.core.truth_(inst_24817)){
var statearr_25096_25209 = state_24979__$1;
(statearr_25096_25209[(1)] = (31));

} else {
var statearr_25097_25210 = state_24979__$1;
(statearr_25097_25210[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (73))){
var inst_24946 = (state_24979[(2)]);
var state_24979__$1 = state_24979;
var statearr_25098_25211 = state_24979__$1;
(statearr_25098_25211[(2)] = inst_24946);

(statearr_25098_25211[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (10))){
var inst_24762 = (state_24979[(58)]);
var inst_24779 = fluree.db.dbproto._subid.call(null,db,inst_24762);
var state_24979__$1 = state_24979;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24979__$1,(13),inst_24779);
} else {
if((state_val_24980 === (18))){
var inst_24764 = (state_24979[(59)]);
var inst_24797 = fluree.db.dbproto._subid.call(null,db,inst_24764);
var state_24979__$1 = state_24979;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24979__$1,(21),inst_24797);
} else {
if((state_val_24980 === (52))){
var inst_24812 = (state_24979[(25)]);
var inst_24785 = (state_24979[(33)]);
var inst_24821 = (state_24979[(34)]);
var inst_24847 = (state_24979[(36)]);
var inst_24776 = (state_24979[(40)]);
var inst_24861 = fluree.db.permissions_validate.no_filter_QMARK_.call(null,inst_24847,inst_24776,inst_24785,inst_24812,inst_24821);
var state_24979__$1 = state_24979;
var statearr_25099_25212 = state_24979__$1;
(statearr_25099_25212[(2)] = inst_24861);

(statearr_25099_25212[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (67))){
var inst_24948 = (state_24979[(2)]);
var state_24979__$1 = state_24979;
var statearr_25100_25213 = state_24979__$1;
(statearr_25100_25213[(2)] = inst_24948);

(statearr_25100_25213[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (71))){
var inst_24912 = (state_24979[(52)]);
var inst_24880 = (state_24979[(32)]);
var inst_24927 = cljs.core.into.call(null,inst_24912,inst_24880);
var state_24979__$1 = state_24979;
var statearr_25101_25214 = state_24979__$1;
(statearr_25101_25214[(2)] = inst_24927);

(statearr_25101_25214[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (42))){
var inst_24839 = (state_24979[(24)]);
var inst_24812 = (state_24979[(25)]);
var inst_24758 = (state_24979[(27)]);
var inst_24759 = (state_24979[(28)]);
var inst_24842 = (state_24979[(49)]);
var inst_24785 = (state_24979[(33)]);
var inst_24821 = (state_24979[(34)]);
var inst_24766 = (state_24979[(35)]);
var inst_24765 = (state_24979[(38)]);
var inst_24803 = (state_24979[(21)]);
var inst_24776 = (state_24979[(40)]);
var inst_24794 = (state_24979[(42)]);
var inst_24830 = (state_24979[(43)]);
var inst_24839__$1 = (state_24979[(2)]);
var inst_24840 = fluree.db.flake.__GT_Flake.call(null,inst_24776,inst_24812,inst_24794,inst_24758,inst_24759,inst_24830);
var inst_24841 = fluree.db.flake.__GT_Flake.call(null,inst_24785,inst_24821,inst_24803,inst_24765,inst_24766,inst_24839__$1);
var inst_24842__$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
var state_24979__$1 = (function (){var statearr_25102 = state_24979;
(statearr_25102[(24)] = inst_24839__$1);

(statearr_25102[(49)] = inst_24842__$1);

(statearr_25102[(16)] = inst_24840);

(statearr_25102[(17)] = inst_24841);

return statearr_25102;
})();
if(cljs.core.truth_(inst_24842__$1)){
var statearr_25103_25215 = state_24979__$1;
(statearr_25103_25215[(1)] = (46));

} else {
var statearr_25104_25216 = state_24979__$1;
(statearr_25104_25216[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (80))){
var inst_24940 = (state_24979[(2)]);
var state_24979__$1 = state_24979;
var statearr_25105_25217 = state_24979__$1;
(statearr_25105_25217[(2)] = inst_24940);

(statearr_25105_25217[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (37))){
var state_24979__$1 = state_24979;
var statearr_25106_25218 = state_24979__$1;
(statearr_25106_25218[(2)] = fluree.db.util.core.min_integer);

(statearr_25106_25218[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (63))){
var inst_24893 = (state_24979[(12)]);
var inst_24879 = (state_24979[(31)]);
var inst_24880 = (state_24979[(32)]);
var inst_24846 = (state_24979[(39)]);
var inst_24896 = (inst_24846 - inst_24879);
var inst_24897 = fluree.db.flake.take.call(null,inst_24896,inst_24893);
var inst_24898 = cljs.core.into.call(null,inst_24897,inst_24880);
var state_24979__$1 = state_24979;
var statearr_25107_25219 = state_24979__$1;
(statearr_25107_25219[(2)] = inst_24898);

(statearr_25107_25219[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (8))){
var inst_24762 = (state_24979[(58)]);
var inst_24776 = (state_24979[(2)]);
var inst_24777 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_24762);
var state_24979__$1 = (function (){var statearr_25108 = state_24979;
(statearr_25108[(40)] = inst_24776);

return statearr_25108;
})();
if(inst_24777){
var statearr_25109_25220 = state_24979__$1;
(statearr_25109_25220[(1)] = (10));

} else {
var statearr_25110_25221 = state_24979__$1;
(statearr_25110_25221[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (49))){
var inst_24852 = (state_24979[(51)]);
var state_24979__$1 = state_24979;
var statearr_25111_25222 = state_24979__$1;
(statearr_25111_25222[(2)] = inst_24852);

(statearr_25111_25222[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24980 === (84))){
var inst_24951 = (state_24979[(9)]);
var inst_24846 = (state_24979[(39)]);
var inst_24956 = (inst_24951 < inst_24846);
var state_24979__$1 = state_24979;
var statearr_25112_25223 = state_24979__$1;
(statearr_25112_25223[(2)] = inst_24956);

(statearr_25112_25223[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__10945__auto__ = null;
var fluree$db$query$range$state_machine__10945__auto____0 = (function (){
var statearr_25113 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25113[(0)] = fluree$db$query$range$state_machine__10945__auto__);

(statearr_25113[(1)] = (1));

return statearr_25113;
});
var fluree$db$query$range$state_machine__10945__auto____1 = (function (state_24979){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_24979);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e25114){var ex__10948__auto__ = e25114;
var statearr_25115_25224 = state_24979;
(statearr_25115_25224[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_24979[(4)]))){
var statearr_25116_25225 = state_24979;
(statearr_25116_25225[(1)] = cljs.core.first.call(null,(state_24979[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25226 = state_24979;
state_24979 = G__25226;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__10945__auto__ = function(state_24979){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__10945__auto____1.call(this,state_24979);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__10945__auto____0;
fluree$db$query$range$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__10945__auto____1;
return fluree$db$query$range$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_25117 = f__11019__auto__.call(null);
(statearr_25117[(6)] = c__11018__auto__);

return statearr_25117;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_25301){
var state_val_25302 = (state_25301[(1)]);
if((state_val_25302 === (7))){
var inst_25296 = (state_25301[(2)]);
var _ = (function (){var statearr_25303 = state_25301;
(statearr_25303[(4)] = cljs.core.rest.call(null,(state_25301[(4)])));

return statearr_25303;
})();
var state_25301__$1 = state_25301;
var statearr_25304_25344 = state_25301__$1;
(statearr_25304_25344[(2)] = inst_25296);

(statearr_25304_25344[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25302 === (20))){
var inst_25278 = (state_25301[(2)]);
var inst_25279 = fluree.db.util.async.throw_err.call(null,inst_25278);
var state_25301__$1 = state_25301;
var statearr_25305_25345 = state_25301__$1;
(statearr_25305_25345[(2)] = inst_25279);

(statearr_25305_25345[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25302 === (1))){
var state_25301__$1 = state_25301;
var statearr_25306_25346 = state_25301__$1;
(statearr_25306_25346[(2)] = null);

(statearr_25306_25346[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25302 === (4))){
var inst_25227 = (state_25301[(2)]);
var state_25301__$1 = state_25301;
var statearr_25307_25347 = state_25301__$1;
(statearr_25307_25347[(2)] = inst_25227);

(statearr_25307_25347[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25302 === (15))){
var inst_25274 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_25301__$1 = state_25301;
if(cljs.core.truth_(inst_25274)){
var statearr_25308_25348 = state_25301__$1;
(statearr_25308_25348[(1)] = (17));

} else {
var statearr_25309_25349 = state_25301__$1;
(statearr_25309_25349[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25302 === (21))){
var state_25301__$1 = state_25301;
var statearr_25310_25350 = state_25301__$1;
(statearr_25310_25350[(2)] = (0));

(statearr_25310_25350[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25302 === (13))){
var inst_25266 = (state_25301[(2)]);
var state_25301__$1 = state_25301;
var statearr_25311_25351 = state_25301__$1;
(statearr_25311_25351[(2)] = inst_25266);

(statearr_25311_25351[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25302 === (22))){
var state_25301__$1 = state_25301;
var statearr_25312_25352 = state_25301__$1;
(statearr_25312_25352[(2)] = (1));

(statearr_25312_25352[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25302 === (6))){
var inst_25258 = (state_25301[(7)]);
var inst_25256 = (state_25301[(8)]);
var inst_25247 = (state_25301[(9)]);
var inst_25255 = cljs.core.seq.call(null,inst_25247);
var inst_25256__$1 = cljs.core.first.call(null,inst_25255);
var inst_25257 = cljs.core.next.call(null,inst_25255);
var inst_25258__$1 = (inst_25256__$1 == null);
var state_25301__$1 = (function (){var statearr_25313 = state_25301;
(statearr_25313[(10)] = inst_25257);

(statearr_25313[(7)] = inst_25258__$1);

(statearr_25313[(8)] = inst_25256__$1);

return statearr_25313;
})();
if(cljs.core.truth_(inst_25258__$1)){
var statearr_25314_25353 = state_25301__$1;
(statearr_25314_25353[(1)] = (8));

} else {
var statearr_25315_25354 = state_25301__$1;
(statearr_25315_25354[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25302 === (17))){
var inst_25256 = (state_25301[(8)]);
var inst_25276 = fluree.db.permissions_validate.allow_flakes_QMARK_.call(null,db,inst_25256);
var state_25301__$1 = state_25301;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25301__$1,(20),inst_25276);
} else {
if((state_val_25302 === (3))){
var inst_25299 = (state_25301[(2)]);
var state_25301__$1 = state_25301;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25301__$1,inst_25299);
} else {
if((state_val_25302 === (12))){
var inst_25249 = (state_25301[(11)]);
var inst_25264 = (inst_25249 >= subject_limit);
var state_25301__$1 = state_25301;
var statearr_25316_25355 = state_25301__$1;
(statearr_25316_25355[(2)] = inst_25264);

(statearr_25316_25355[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25302 === (2))){
var _ = (function (){var statearr_25317 = state_25301;
(statearr_25317[(4)] = cljs.core.cons.call(null,(5),(state_25301[(4)])));

return statearr_25317;
})();
var inst_25240 = subject_groups;
var inst_25241 = cljs.core.seq.call(null,inst_25240);
var inst_25242 = cljs.core.first.call(null,inst_25241);
var inst_25243 = cljs.core.next.call(null,inst_25241);
var inst_25244 = flake_start;
var inst_25245 = subject_start;
var inst_25246 = cljs.core.PersistentVector.EMPTY;
var inst_25247 = inst_25240;
var inst_25248 = inst_25244;
var inst_25249 = inst_25245;
var inst_25250 = inst_25246;
var state_25301__$1 = (function (){var statearr_25318 = state_25301;
(statearr_25318[(12)] = inst_25242);

(statearr_25318[(13)] = inst_25243);

(statearr_25318[(14)] = inst_25250);

(statearr_25318[(9)] = inst_25247);

(statearr_25318[(15)] = inst_25248);

(statearr_25318[(11)] = inst_25249);

return statearr_25318;
})();
var statearr_25319_25356 = state_25301__$1;
(statearr_25319_25356[(2)] = null);

(statearr_25319_25356[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25302 === (23))){
var inst_25257 = (state_25301[(10)]);
var inst_25250 = (state_25301[(14)]);
var inst_25282 = (state_25301[(16)]);
var inst_25248 = (state_25301[(15)]);
var inst_25283 = (state_25301[(17)]);
var inst_25249 = (state_25301[(11)]);
var inst_25288 = (state_25301[(2)]);
var inst_25289 = (inst_25248 + inst_25283);
var inst_25290 = (inst_25249 + inst_25288);
var inst_25291 = cljs.core.into.call(null,inst_25250,inst_25282);
var inst_25247 = inst_25257;
var inst_25248__$1 = inst_25289;
var inst_25249__$1 = inst_25290;
var inst_25250__$1 = inst_25291;
var state_25301__$1 = (function (){var statearr_25320 = state_25301;
(statearr_25320[(14)] = inst_25250__$1);

(statearr_25320[(9)] = inst_25247);

(statearr_25320[(15)] = inst_25248__$1);

(statearr_25320[(11)] = inst_25249__$1);

return statearr_25320;
})();
var statearr_25321_25357 = state_25301__$1;
(statearr_25321_25357[(2)] = null);

(statearr_25321_25357[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25302 === (19))){
var inst_25282 = (state_25301[(16)]);
var inst_25283 = (state_25301[(17)]);
var inst_25282__$1 = (state_25301[(2)]);
var inst_25283__$1 = cljs.core.count.call(null,inst_25282__$1);
var inst_25284 = cljs.core._EQ_.call(null,(0),inst_25283__$1);
var state_25301__$1 = (function (){var statearr_25322 = state_25301;
(statearr_25322[(16)] = inst_25282__$1);

(statearr_25322[(17)] = inst_25283__$1);

return statearr_25322;
})();
if(inst_25284){
var statearr_25323_25358 = state_25301__$1;
(statearr_25323_25358[(1)] = (21));

} else {
var statearr_25324_25359 = state_25301__$1;
(statearr_25324_25359[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25302 === (11))){
var inst_25261 = (state_25301[(18)]);
var state_25301__$1 = state_25301;
var statearr_25326_25360 = state_25301__$1;
(statearr_25326_25360[(2)] = inst_25261);

(statearr_25326_25360[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25302 === (9))){
var inst_25261 = (state_25301[(18)]);
var inst_25248 = (state_25301[(15)]);
var inst_25261__$1 = (inst_25248 >= flake_limit);
var state_25301__$1 = (function (){var statearr_25327 = state_25301;
(statearr_25327[(18)] = inst_25261__$1);

return statearr_25327;
})();
if(cljs.core.truth_(inst_25261__$1)){
var statearr_25328_25361 = state_25301__$1;
(statearr_25328_25361[(1)] = (11));

} else {
var statearr_25329_25362 = state_25301__$1;
(statearr_25329_25362[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25302 === (5))){
var _ = (function (){var statearr_25330 = state_25301;
(statearr_25330[(4)] = cljs.core.rest.call(null,(state_25301[(4)])));

return statearr_25330;
})();
var state_25301__$1 = state_25301;
var ex25325 = (state_25301__$1[(2)]);
var statearr_25331_25363 = state_25301__$1;
(statearr_25331_25363[(5)] = ex25325);


if((ex25325 instanceof Error)){
var statearr_25332_25364 = state_25301__$1;
(statearr_25332_25364[(1)] = (4));

(statearr_25332_25364[(5)] = null);

} else {
throw ex25325;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25302 === (14))){
var inst_25250 = (state_25301[(14)]);
var inst_25248 = (state_25301[(15)]);
var inst_25249 = (state_25301[(11)]);
var inst_25270 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25271 = [inst_25248,inst_25249,inst_25250];
var inst_25272 = (new cljs.core.PersistentVector(null,3,(5),inst_25270,inst_25271,null));
var state_25301__$1 = state_25301;
var statearr_25333_25365 = state_25301__$1;
(statearr_25333_25365[(2)] = inst_25272);

(statearr_25333_25365[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25302 === (16))){
var inst_25294 = (state_25301[(2)]);
var state_25301__$1 = state_25301;
var statearr_25334_25366 = state_25301__$1;
(statearr_25334_25366[(2)] = inst_25294);

(statearr_25334_25366[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25302 === (10))){
var inst_25268 = (state_25301[(2)]);
var state_25301__$1 = state_25301;
if(cljs.core.truth_(inst_25268)){
var statearr_25335_25367 = state_25301__$1;
(statearr_25335_25367[(1)] = (14));

} else {
var statearr_25336_25368 = state_25301__$1;
(statearr_25336_25368[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25302 === (18))){
var inst_25256 = (state_25301[(8)]);
var state_25301__$1 = state_25301;
var statearr_25337_25369 = state_25301__$1;
(statearr_25337_25369[(2)] = inst_25256);

(statearr_25337_25369[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25302 === (8))){
var inst_25258 = (state_25301[(7)]);
var state_25301__$1 = state_25301;
var statearr_25338_25370 = state_25301__$1;
(statearr_25338_25370[(2)] = inst_25258);

(statearr_25338_25370[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10945__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10945__auto____0 = (function (){
var statearr_25339 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25339[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10945__auto__);

(statearr_25339[(1)] = (1));

return statearr_25339;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10945__auto____1 = (function (state_25301){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_25301);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e25340){var ex__10948__auto__ = e25340;
var statearr_25341_25371 = state_25301;
(statearr_25341_25371[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_25301[(4)]))){
var statearr_25342_25372 = state_25301;
(statearr_25342_25372[(1)] = cljs.core.first.call(null,(state_25301[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25373 = state_25301;
state_25301 = G__25373;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10945__auto__ = function(state_25301){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10945__auto____1.call(this,state_25301);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10945__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10945__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_25343 = f__11019__auto__.call(null);
(statearr_25343[(6)] = c__11018__auto__);

return statearr_25343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_25419){
var state_val_25420 = (state_25419[(1)]);
if((state_val_25420 === (7))){
var state_25419__$1 = state_25419;
var statearr_25421_25459 = state_25419__$1;
(statearr_25421_25459[(2)] = null);

(statearr_25421_25459[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25420 === (20))){
var inst_25405 = (state_25419[(2)]);
var inst_25406 = fluree.db.util.async.throw_err.call(null,inst_25405);
var inst_25384 = inst_25406;
var state_25419__$1 = (function (){var statearr_25422 = state_25419;
(statearr_25422[(7)] = inst_25384);

return statearr_25422;
})();
var statearr_25423_25460 = state_25419__$1;
(statearr_25423_25460[(2)] = null);

(statearr_25423_25460[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25420 === (1))){
var state_25419__$1 = state_25419;
var statearr_25424_25461 = state_25419__$1;
(statearr_25424_25461[(2)] = null);

(statearr_25424_25461[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25420 === (4))){
var inst_25374 = (state_25419[(2)]);
var state_25419__$1 = state_25419;
var statearr_25425_25462 = state_25419__$1;
(statearr_25425_25462[(2)] = inst_25374);

(statearr_25425_25462[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25420 === (15))){
var inst_25384 = (state_25419[(7)]);
var inst_25401 = (state_25419[(8)]);
var inst_25401__$1 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_25384);
var state_25419__$1 = (function (){var statearr_25426 = state_25419;
(statearr_25426[(8)] = inst_25401__$1);

return statearr_25426;
})();
if(cljs.core.truth_(inst_25401__$1)){
var statearr_25427_25463 = state_25419__$1;
(statearr_25427_25463[(1)] = (17));

} else {
var statearr_25428_25464 = state_25419__$1;
(statearr_25428_25464[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25420 === (13))){
var inst_25394 = (state_25419[(2)]);
var inst_25395 = fluree.db.util.async.throw_err.call(null,inst_25394);
var _ = (function (){var statearr_25429 = state_25419;
(statearr_25429[(4)] = cljs.core.rest.call(null,(state_25419[(4)])));

return statearr_25429;
})();
var state_25419__$1 = state_25419;
var statearr_25430_25465 = state_25419__$1;
(statearr_25430_25465[(2)] = inst_25395);

(statearr_25430_25465[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25420 === (6))){
var inst_25382 = (state_25419[(2)]);
var inst_25383 = fluree.db.util.async.throw_err.call(null,inst_25382);
var inst_25384 = inst_25383;
var state_25419__$1 = (function (){var statearr_25431 = state_25419;
(statearr_25431[(7)] = inst_25384);

return statearr_25431;
})();
var statearr_25432_25466 = state_25419__$1;
(statearr_25432_25466[(2)] = null);

(statearr_25432_25466[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25420 === (17))){
var inst_25401 = (state_25419[(8)]);
var inst_25403 = fluree.db.dbproto._lookup_leaf.call(null,root_node,inst_25401);
var state_25419__$1 = state_25419;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25419__$1,(20),inst_25403);
} else {
if((state_val_25420 === (3))){
var inst_25417 = (state_25419[(2)]);
var state_25419__$1 = state_25419;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25419__$1,inst_25417);
} else {
if((state_val_25420 === (12))){
var _ = (function (){var statearr_25434 = state_25419;
(statearr_25434[(4)] = cljs.core.rest.call(null,(state_25419[(4)])));

return statearr_25434;
})();
var state_25419__$1 = state_25419;
var ex25433 = (state_25419__$1[(2)]);
var statearr_25435_25467 = state_25419__$1;
(statearr_25435_25467[(5)] = ex25433);


var statearr_25436_25468 = state_25419__$1;
(statearr_25436_25468[(1)] = (11));

(statearr_25436_25468[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25420 === (2))){
var _ = (function (){var statearr_25437 = state_25419;
(statearr_25437[(4)] = cljs.core.cons.call(null,(5),(state_25419[(4)])));

return statearr_25437;
})();
var inst_25380 = fluree.db.dbproto._lookup_leaf.call(null,root_node,rhs);
var state_25419__$1 = state_25419;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25419__$1,(6),inst_25380);
} else {
if((state_val_25420 === (19))){
var inst_25410 = (state_25419[(2)]);
var state_25419__$1 = state_25419;
var statearr_25438_25469 = state_25419__$1;
(statearr_25438_25469[(2)] = inst_25410);

(statearr_25438_25469[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25420 === (11))){
var inst_25386 = (state_25419[(2)]);
var state_25419__$1 = (function (){var statearr_25440 = state_25419;
(statearr_25440[(9)] = inst_25386);

return statearr_25440;
})();
var statearr_25441_25470 = state_25419__$1;
(statearr_25441_25470[(2)] = null);

(statearr_25441_25470[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25420 === (9))){
var inst_25384 = (state_25419[(7)]);
var _ = (function (){var statearr_25442 = state_25419;
(statearr_25442[(4)] = cljs.core.cons.call(null,(12),(state_25419[(4)])));

return statearr_25442;
})();
var inst_25392 = fluree.db.dbproto._resolve_to_t.call(null,inst_25384,t,novelty,fast_forward_db_QMARK_);
var state_25419__$1 = state_25419;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25419__$1,(13),inst_25392);
} else {
if((state_val_25420 === (5))){
var _ = (function (){var statearr_25443 = state_25419;
(statearr_25443[(4)] = cljs.core.rest.call(null,(state_25419[(4)])));

return statearr_25443;
})();
var state_25419__$1 = state_25419;
var ex25439 = (state_25419__$1[(2)]);
var statearr_25444_25471 = state_25419__$1;
(statearr_25444_25471[(5)] = ex25439);


if((ex25439 instanceof Error)){
var statearr_25445_25472 = state_25419__$1;
(statearr_25445_25472[(1)] = (4));

(statearr_25445_25472[(5)] = null);

} else {
throw ex25439;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25420 === (14))){
var inst_25398 = (state_25419[(10)]);
var state_25419__$1 = state_25419;
var statearr_25446_25473 = state_25419__$1;
(statearr_25446_25473[(2)] = inst_25398);

(statearr_25446_25473[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25420 === (16))){
var inst_25412 = (state_25419[(2)]);
var state_25419__$1 = state_25419;
var statearr_25447_25474 = state_25419__$1;
(statearr_25447_25474[(2)] = inst_25412);

(statearr_25447_25474[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25420 === (10))){
var inst_25398 = (state_25419[(10)]);
var inst_25398__$1 = (state_25419[(2)]);
var state_25419__$1 = (function (){var statearr_25448 = state_25419;
(statearr_25448[(10)] = inst_25398__$1);

return statearr_25448;
})();
if(cljs.core.truth_(inst_25398__$1)){
var statearr_25449_25475 = state_25419__$1;
(statearr_25449_25475[(1)] = (14));

} else {
var statearr_25450_25476 = state_25419__$1;
(statearr_25450_25476[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25420 === (18))){
var state_25419__$1 = state_25419;
var statearr_25451_25477 = state_25419__$1;
(statearr_25451_25477[(2)] = null);

(statearr_25451_25477[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25420 === (8))){
var inst_25414 = (state_25419[(2)]);
var _ = (function (){var statearr_25452 = state_25419;
(statearr_25452[(4)] = cljs.core.rest.call(null,(state_25419[(4)])));

return statearr_25452;
})();
var state_25419__$1 = state_25419;
var statearr_25453_25478 = state_25419__$1;
(statearr_25453_25478[(2)] = inst_25414);

(statearr_25453_25478[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__10945__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__10945__auto____0 = (function (){
var statearr_25454 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25454[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__10945__auto__);

(statearr_25454[(1)] = (1));

return statearr_25454;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__10945__auto____1 = (function (state_25419){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_25419);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e25455){var ex__10948__auto__ = e25455;
var statearr_25456_25479 = state_25419;
(statearr_25456_25479[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_25419[(4)]))){
var statearr_25457_25480 = state_25419;
(statearr_25457_25480[(1)] = cljs.core.first.call(null,(state_25419[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25481 = state_25419;
state_25419 = G__25481;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__10945__auto__ = function(state_25419){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__10945__auto____1.call(this,state_25419);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__10945__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__10945__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_25458 = f__11019__auto__.call(null);
(statearr_25458[(6)] = c__11018__auto__);

return statearr_25458;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__25488 = arguments.length;
switch (G__25488) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__25489 = (function (){var pred__25492 = cljs.core.identical_QMARK_;
var expr__25493 = test;
if(cljs.core.truth_(pred__25492.call(null,cljs.core._EQ_,expr__25493))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__25492.call(null,cljs.core._LT_,expr__25493))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__25492.call(null,cljs.core._LT__EQ_,expr__25493))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__25492.call(null,cljs.core._GT_,expr__25493))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__25492.call(null,cljs.core._GT__EQ_,expr__25493))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__25493)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__25489,(0),null);
var start_match = cljs.core.nth.call(null,vec__25489,(1),null);
var end_test = cljs.core.nth.call(null,vec__25489,(2),null);
var end_match = cljs.core.nth.call(null,vec__25489,(3),null);
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_25865){
var state_val_25866 = (state_25865[(1)]);
if((state_val_25866 === (121))){
var inst_25821 = (state_25865[(7)]);
var state_25865__$1 = state_25865;
var statearr_25867_26060 = state_25865__$1;
(statearr_25867_26060[(2)] = inst_25821);

(statearr_25867_26060[(1)] = (123));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (65))){
var inst_25673 = (state_25865[(8)]);
var inst_25679 = (state_25865[(2)]);
var state_25865__$1 = (function (){var statearr_25868 = state_25865;
(statearr_25868[(9)] = inst_25679);

return statearr_25868;
})();
if(cljs.core.truth_(inst_25673)){
var statearr_25869_26061 = state_25865__$1;
(statearr_25869_26061[(1)] = (66));

} else {
var statearr_25870_26062 = state_25865__$1;
(statearr_25870_26062[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (70))){
var inst_25857 = (state_25865[(2)]);
var state_25865__$1 = state_25865;
var statearr_25871_26063 = state_25865__$1;
(statearr_25871_26063[(2)] = inst_25857);

(statearr_25871_26063[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (62))){
var inst_25672 = (state_25865[(2)]);
var inst_25673 = fluree.db.util.async.throw_err.call(null,inst_25672);
var inst_25674 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_25865__$1 = (function (){var statearr_25872 = state_25865;
(statearr_25872[(8)] = inst_25673);

return statearr_25872;
})();
if(cljs.core.truth_(inst_25674)){
var statearr_25873_26064 = state_25865__$1;
(statearr_25873_26064[(1)] = (63));

} else {
var statearr_25874_26065 = state_25865__$1;
(statearr_25874_26065[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (74))){
var inst_25532 = (state_25865[(10)]);
var inst_25530 = (state_25865[(11)]);
var inst_25531 = (state_25865[(12)]);
var inst_25653 = (state_25865[(13)]);
var inst_25692 = (state_25865[(14)]);
var inst_25685 = (state_25865[(15)]);
var inst_25684 = (state_25865[(16)]);
var inst_25584 = (state_25865[(17)]);
var inst_25658 = (state_25865[(18)]);
var inst_25663 = (state_25865[(19)]);
var inst_25542 = (state_25865[(20)]);
var inst_25587 = (state_25865[(21)]);
var inst_25643 = (state_25865[(22)]);
var inst_25520 = (state_25865[(23)]);
var inst_25686 = (state_25865[(24)]);
var inst_25551 = (state_25865[(25)]);
var inst_25673 = (state_25865[(8)]);
var inst_25526 = (state_25865[(26)]);
var inst_25664 = (state_25865[(27)]);
var inst_25679 = (state_25865[(9)]);
var inst_25652 = (state_25865[(28)]);
var inst_25632 = (state_25865[(29)]);
var inst_25669 = (state_25865[(30)]);
var inst_25605 = (state_25865[(31)]);
var inst_25642 = (state_25865[(32)]);
var inst_25519 = (state_25865[(33)]);
var inst_25646 = (state_25865[(34)]);
var inst_25522 = (state_25865[(35)]);
var inst_25645 = (state_25865[(36)]);
var inst_25614 = (state_25865[(37)]);
var inst_25659 = (state_25865[(38)]);
var inst_25623 = (state_25865[(39)]);
var inst_25515 = (state_25865[(40)]);
var inst_25700 = (state_25865[(41)]);
var inst_25641 = (state_25865[(42)]);
var inst_25654 = (state_25865[(43)]);
var inst_25583 = (state_25865[(44)]);
var inst_25596 = (state_25865[(45)]);
var inst_25682 = (state_25865[(46)]);
var inst_25527 = (state_25865[(47)]);
var inst_25683 = (state_25865[(48)]);
var inst_25702 = (function (){var no_filter_QMARK_ = inst_25679;
var G__25693 = inst_25700;
var t = inst_25659;
var max_limit_QMARK_ = inst_25653;
var next_node = inst_25682;
var fast_forward_db_QMARK_ = inst_25664;
var s1 = inst_25542;
var o2 = inst_25605;
var t1 = inst_25519;
var predicate_fn = inst_25532;
var i = inst_25684;
var m1 = inst_25632;
var root_node = inst_25669;
var map__25514 = inst_25645;
var s2 = inst_25551;
var p2 = inst_25623;
var permissions = inst_25654;
var vec__25501 = inst_25515;
var limit = inst_25652;
var start_flake = inst_25642;
var flake_limit = inst_25646;
var offset = inst_25683;
var map__25507 = inst_25530;
var acc = inst_25686;
var t2 = inst_25526;
var op1 = inst_25520;
var o1 = inst_25596;
var end_flake = inst_25643;
var base_result = inst_25692;
var vec__25508 = inst_25583;
var s = inst_25685;
var node_start = inst_25673;
var p1 = inst_25614;
var subject_fn = inst_25531;
var vec__25504 = inst_25522;
var object_fn = inst_25587;
var idx_compare = inst_25658;
var op2 = inst_25527;
var m2 = inst_25641;
var vec__25511 = inst_25584;
var novelty = inst_25663;
return (function (p1__25483_SHARP_){
return subject_fn.call(null,p1__25483_SHARP_.s);
});
})();
var inst_25703 = cljs.core.filter.call(null,inst_25702,inst_25700);
var state_25865__$1 = state_25865;
var statearr_25875_26066 = state_25865__$1;
(statearr_25875_26066[(2)] = inst_25703);

(statearr_25875_26066[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (110))){
var inst_25834 = (state_25865[(2)]);
var state_25865__$1 = state_25865;
var statearr_25876_26067 = state_25865__$1;
(statearr_25876_26067[(2)] = inst_25834);

(statearr_25876_26067[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (7))){
var inst_25516 = (state_25865[(49)]);
var state_25865__$1 = state_25865;
var statearr_25877_26068 = state_25865__$1;
(statearr_25877_26068[(2)] = inst_25516);

(statearr_25877_26068[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (59))){
var state_25865__$1 = state_25865;
var statearr_25878_26069 = state_25865__$1;
(statearr_25878_26069[(2)] = fluree.db.util.core.max_long);

(statearr_25878_26069[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (86))){
var inst_25679 = (state_25865[(9)]);
var state_25865__$1 = state_25865;
var statearr_25879_26070 = state_25865__$1;
(statearr_25879_26070[(2)] = inst_25679);

(statearr_25879_26070[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (20))){
var state_25865__$1 = state_25865;
var statearr_25880_26071 = state_25865__$1;
(statearr_25880_26071[(2)] = null);

(statearr_25880_26071[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (72))){
var inst_25692 = (state_25865[(14)]);
var state_25865__$1 = state_25865;
var statearr_25881_26072 = state_25865__$1;
(statearr_25881_26072[(2)] = inst_25692);

(statearr_25881_26072[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (58))){
var inst_25647 = (state_25865[(50)]);
var state_25865__$1 = state_25865;
var statearr_25882_26073 = state_25865__$1;
(statearr_25882_26073[(2)] = inst_25647);

(statearr_25882_26073[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (60))){
var inst_25652 = (state_25865[(28)]);
var inst_25652__$1 = (state_25865[(2)]);
var inst_25653 = cljs.core._EQ_.call(null,inst_25652__$1,fluree.db.util.core.max_long);
var inst_25654 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_25655 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25656 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_25657 = (new cljs.core.PersistentVector(null,3,(5),inst_25655,inst_25656,null));
var inst_25658 = cljs.core.get_in.call(null,db,inst_25657);
var inst_25659 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25660 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25661 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_25662 = (new cljs.core.PersistentVector(null,2,(5),inst_25660,inst_25661,null));
var inst_25663 = cljs.core.get_in.call(null,db,inst_25662);
var inst_25664 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var inst_25665 = cljs.core.get.call(null,db,idx);
var inst_25666 = fluree.db.dbproto._resolve.call(null,inst_25665);
var state_25865__$1 = (function (){var statearr_25883 = state_25865;
(statearr_25883[(13)] = inst_25653);

(statearr_25883[(18)] = inst_25658);

(statearr_25883[(19)] = inst_25663);

(statearr_25883[(27)] = inst_25664);

(statearr_25883[(28)] = inst_25652__$1);

(statearr_25883[(38)] = inst_25659);

(statearr_25883[(43)] = inst_25654);

return statearr_25883;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25865__$1,(61),inst_25666);
} else {
if((state_val_25866 === (27))){
var inst_25585 = (state_25865[(51)]);
var state_25865__$1 = state_25865;
var statearr_25884_26074 = state_25865__$1;
(statearr_25884_26074[(2)] = inst_25585);

(statearr_25884_26074[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (1))){
var state_25865__$1 = state_25865;
var statearr_25885_26075 = state_25865__$1;
(statearr_25885_26075[(2)] = null);

(statearr_25885_26075[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (69))){
var inst_25643 = (state_25865[(22)]);
var inst_25642 = (state_25865[(32)]);
var inst_25682 = (state_25865[(46)]);
var inst_25691 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_25682);
var inst_25692 = fluree.db.flake.subrange.call(null,inst_25691,start_test,inst_25642,end_test,inst_25643);
var inst_25694 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_25642,inst_25643);
var state_25865__$1 = (function (){var statearr_25886 = state_25865;
(statearr_25886[(14)] = inst_25692);

return statearr_25886;
})();
if(inst_25694){
var statearr_25887_26076 = state_25865__$1;
(statearr_25887_26076[(1)] = (71));

} else {
var statearr_25888_26077 = state_25865__$1;
(statearr_25888_26077[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (101))){
var inst_25780 = (state_25865[(52)]);
var inst_25646 = (state_25865[(34)]);
var inst_25778 = (state_25865[(53)]);
var inst_25779 = (state_25865[(54)]);
var inst_25783 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25784 = (inst_25780 - inst_25646);
var inst_25785 = (inst_25779 - inst_25784);
var inst_25786 = cljs.core.take.call(null,inst_25785,inst_25778);
var inst_25787 = [inst_25646,inst_25786];
var inst_25788 = (new cljs.core.PersistentVector(null,2,(5),inst_25783,inst_25787,null));
var state_25865__$1 = state_25865;
var statearr_25889_26078 = state_25865__$1;
(statearr_25889_26078[(2)] = inst_25788);

(statearr_25889_26078[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (24))){
var inst_25532 = (state_25865[(10)]);
var inst_25530 = (state_25865[(11)]);
var inst_25531 = (state_25865[(12)]);
var inst_25533 = (state_25865[(55)]);
var inst_25525 = (state_25865[(56)]);
var inst_25518 = (state_25865[(57)]);
var inst_25542 = (state_25865[(20)]);
var inst_25521 = (state_25865[(58)]);
var inst_25520 = (state_25865[(23)]);
var inst_25551 = (state_25865[(25)]);
var inst_25526 = (state_25865[(26)]);
var inst_25524 = (state_25865[(59)]);
var inst_25519 = (state_25865[(33)]);
var inst_25522 = (state_25865[(35)]);
var inst_25565 = (state_25865[(60)]);
var inst_25528 = (state_25865[(61)]);
var inst_25515 = (state_25865[(40)]);
var inst_25527 = (state_25865[(47)]);
var inst_25517 = (state_25865[(62)]);
var inst_25575 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25576 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25577 = [null,null];
var inst_25578 = (new cljs.core.PersistentVector(null,2,(5),inst_25576,inst_25577,null));
var inst_25579 = (function (){var bool = inst_25565;
var s1 = inst_25542;
var o2 = inst_25525;
var t1 = inst_25519;
var predicate_fn = inst_25532;
var m1 = inst_25521;
var s2 = inst_25551;
var p2 = inst_25524;
var vec__25501 = inst_25515;
var map__25507 = inst_25530;
var t2 = inst_25526;
var op1 = inst_25520;
var o1 = inst_25518;
var p1 = inst_25517;
var subject_fn = inst_25531;
var vec__25504 = inst_25522;
var temp__5806__auto__ = inst_25565;
var object_fn = inst_25533;
var op2 = inst_25527;
var m2 = inst_25528;
return (function (o){
return cljs.core._EQ_.call(null,o,bool);
});
})();
var inst_25580 = [inst_25578,inst_25579];
var inst_25581 = (new cljs.core.PersistentVector(null,2,(5),inst_25575,inst_25580,null));
var state_25865__$1 = state_25865;
var statearr_25890_26079 = state_25865__$1;
(statearr_25890_26079[(2)] = inst_25581);

(statearr_25890_26079[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (102))){
var inst_25780 = (state_25865[(52)]);
var inst_25778 = (state_25865[(53)]);
var inst_25790 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25791 = [inst_25780,inst_25778];
var inst_25792 = (new cljs.core.PersistentVector(null,2,(5),inst_25790,inst_25791,null));
var state_25865__$1 = state_25865;
var statearr_25891_26080 = state_25865__$1;
(statearr_25891_26080[(2)] = inst_25792);

(statearr_25891_26080[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (55))){
var state_25865__$1 = state_25865;
var statearr_25892_26081 = state_25865__$1;
(statearr_25892_26081[(2)] = (2147483647));

(statearr_25892_26081[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (85))){
var inst_25728 = (state_25865[(2)]);
var state_25865__$1 = state_25865;
if(cljs.core.truth_(inst_25728)){
var statearr_25893_26082 = state_25865__$1;
(statearr_25893_26082[(1)] = (89));

} else {
var statearr_25894_26083 = state_25865__$1;
(statearr_25894_26083[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (39))){
var inst_25615 = (state_25865[(63)]);
var inst_25524 = (state_25865[(59)]);
var inst_25614 = (state_25865[(2)]);
var inst_25615__$1 = (inst_25524 == null);
var state_25865__$1 = (function (){var statearr_25895 = state_25865;
(statearr_25895[(63)] = inst_25615__$1);

(statearr_25895[(37)] = inst_25614);

return statearr_25895;
})();
if(cljs.core.truth_(inst_25615__$1)){
var statearr_25896_26084 = state_25865__$1;
(statearr_25896_26084[(1)] = (40));

} else {
var statearr_25897_26085 = state_25865__$1;
(statearr_25897_26085[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (88))){
var inst_25725 = (state_25865[(2)]);
var state_25865__$1 = state_25865;
var statearr_25898_26086 = state_25865__$1;
(statearr_25898_26086[(2)] = inst_25725);

(statearr_25898_26086[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (46))){
var inst_25521 = (state_25865[(58)]);
var state_25865__$1 = state_25865;
var statearr_25899_26087 = state_25865__$1;
(statearr_25899_26087[(2)] = inst_25521);

(statearr_25899_26087[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (4))){
var inst_25495 = (state_25865[(2)]);
var state_25865__$1 = state_25865;
var statearr_25900_26088 = state_25865__$1;
(statearr_25900_26088[(2)] = inst_25495);

(statearr_25900_26088[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (77))){
var inst_25532 = (state_25865[(10)]);
var inst_25530 = (state_25865[(11)]);
var inst_25531 = (state_25865[(12)]);
var inst_25653 = (state_25865[(13)]);
var inst_25692 = (state_25865[(14)]);
var inst_25685 = (state_25865[(15)]);
var inst_25684 = (state_25865[(16)]);
var inst_25584 = (state_25865[(17)]);
var inst_25658 = (state_25865[(18)]);
var inst_25663 = (state_25865[(19)]);
var inst_25542 = (state_25865[(20)]);
var inst_25587 = (state_25865[(21)]);
var inst_25643 = (state_25865[(22)]);
var inst_25520 = (state_25865[(23)]);
var inst_25686 = (state_25865[(24)]);
var inst_25551 = (state_25865[(25)]);
var inst_25673 = (state_25865[(8)]);
var inst_25526 = (state_25865[(26)]);
var inst_25664 = (state_25865[(27)]);
var inst_25679 = (state_25865[(9)]);
var inst_25652 = (state_25865[(28)]);
var inst_25632 = (state_25865[(29)]);
var inst_25669 = (state_25865[(30)]);
var inst_25605 = (state_25865[(31)]);
var inst_25642 = (state_25865[(32)]);
var inst_25519 = (state_25865[(33)]);
var inst_25646 = (state_25865[(34)]);
var inst_25522 = (state_25865[(35)]);
var inst_25706 = (state_25865[(64)]);
var inst_25645 = (state_25865[(36)]);
var inst_25614 = (state_25865[(37)]);
var inst_25659 = (state_25865[(38)]);
var inst_25623 = (state_25865[(39)]);
var inst_25515 = (state_25865[(40)]);
var inst_25641 = (state_25865[(42)]);
var inst_25654 = (state_25865[(43)]);
var inst_25583 = (state_25865[(44)]);
var inst_25596 = (state_25865[(45)]);
var inst_25682 = (state_25865[(46)]);
var inst_25527 = (state_25865[(47)]);
var inst_25683 = (state_25865[(48)]);
var inst_25708 = (function (){var no_filter_QMARK_ = inst_25679;
var G__25693 = inst_25706;
var t = inst_25659;
var max_limit_QMARK_ = inst_25653;
var next_node = inst_25682;
var fast_forward_db_QMARK_ = inst_25664;
var s1 = inst_25542;
var o2 = inst_25605;
var t1 = inst_25519;
var predicate_fn = inst_25532;
var i = inst_25684;
var m1 = inst_25632;
var root_node = inst_25669;
var map__25514 = inst_25645;
var s2 = inst_25551;
var p2 = inst_25623;
var permissions = inst_25654;
var vec__25501 = inst_25515;
var limit = inst_25652;
var start_flake = inst_25642;
var flake_limit = inst_25646;
var offset = inst_25683;
var map__25507 = inst_25530;
var acc = inst_25686;
var t2 = inst_25526;
var op1 = inst_25520;
var o1 = inst_25596;
var end_flake = inst_25643;
var base_result = inst_25692;
var vec__25508 = inst_25583;
var s = inst_25685;
var node_start = inst_25673;
var p1 = inst_25614;
var subject_fn = inst_25531;
var vec__25504 = inst_25522;
var object_fn = inst_25587;
var idx_compare = inst_25658;
var op2 = inst_25527;
var m2 = inst_25641;
var vec__25511 = inst_25584;
var novelty = inst_25663;
return (function (p1__25484_SHARP_){
return predicate_fn.call(null,p1__25484_SHARP_.p);
});
})();
var inst_25709 = cljs.core.filter.call(null,inst_25708,inst_25706);
var state_25865__$1 = state_25865;
var statearr_25901_26089 = state_25865__$1;
(statearr_25901_26089[(2)] = inst_25709);

(statearr_25901_26089[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (106))){
var inst_25719 = (state_25865[(65)]);
var state_25865__$1 = state_25865;
var statearr_25902_26090 = state_25865__$1;
(statearr_25902_26090[(2)] = inst_25719);

(statearr_25902_26090[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (119))){
var inst_25837 = (state_25865[(66)]);
var state_25865__$1 = state_25865;
var statearr_25903_26091 = state_25865__$1;
(statearr_25903_26091[(2)] = inst_25837);

(statearr_25903_26091[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (95))){
var inst_25685 = (state_25865[(15)]);
var inst_25761 = (state_25865[(67)]);
var inst_25752 = (state_25865[(68)]);
var inst_25762 = (state_25865[(69)]);
var inst_25652 = (state_25865[(28)]);
var inst_25760 = (state_25865[(70)]);
var inst_25760__$1 = cljs.core.count.call(null,inst_25752);
var inst_25761__$1 = (inst_25685 + inst_25760__$1);
var inst_25762__$1 = (inst_25761__$1 - inst_25652);
var inst_25763 = cljs.core.pos_int_QMARK_.call(null,inst_25762__$1);
var state_25865__$1 = (function (){var statearr_25904 = state_25865;
(statearr_25904[(67)] = inst_25761__$1);

(statearr_25904[(69)] = inst_25762__$1);

(statearr_25904[(70)] = inst_25760__$1);

return statearr_25904;
})();
if(inst_25763){
var statearr_25905_26092 = state_25865__$1;
(statearr_25905_26092[(1)] = (98));

} else {
var statearr_25906_26093 = state_25865__$1;
(statearr_25906_26093[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (54))){
var inst_25647 = (state_25865[(50)]);
var inst_25542 = (state_25865[(20)]);
var inst_25520 = (state_25865[(23)]);
var inst_25551 = (state_25865[(25)]);
var inst_25526 = (state_25865[(26)]);
var inst_25632 = (state_25865[(29)]);
var inst_25605 = (state_25865[(31)]);
var inst_25519 = (state_25865[(33)]);
var inst_25645 = (state_25865[(36)]);
var inst_25614 = (state_25865[(37)]);
var inst_25623 = (state_25865[(39)]);
var inst_25641 = (state_25865[(42)]);
var inst_25596 = (state_25865[(45)]);
var inst_25527 = (state_25865[(47)]);
var inst_25641__$1 = (state_25865[(2)]);
var inst_25642 = fluree.db.flake.__GT_Flake.call(null,inst_25542,inst_25614,inst_25596,inst_25519,inst_25520,inst_25632);
var inst_25643 = fluree.db.flake.__GT_Flake.call(null,inst_25551,inst_25623,inst_25605,inst_25526,inst_25527,inst_25641__$1);
var inst_25644 = opts;
var inst_25645__$1 = cljs.core.__destructure_map.call(null,inst_25644);
var inst_25646 = cljs.core.get.call(null,inst_25645__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961),fluree.db.util.core.max_long);
var inst_25647__$1 = cljs.core.get.call(null,inst_25645__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_25648 = cljs.core.get.call(null,inst_25645__$1,new cljs.core.Keyword(null,"offset","offset",296498311),(0));
var state_25865__$1 = (function (){var statearr_25907 = state_25865;
(statearr_25907[(50)] = inst_25647__$1);

(statearr_25907[(22)] = inst_25643);

(statearr_25907[(71)] = inst_25648);

(statearr_25907[(32)] = inst_25642);

(statearr_25907[(34)] = inst_25646);

(statearr_25907[(36)] = inst_25645__$1);

(statearr_25907[(42)] = inst_25641__$1);

return statearr_25907;
})();
if(cljs.core.truth_(inst_25647__$1)){
var statearr_25908_26094 = state_25865__$1;
(statearr_25908_26094[(1)] = (58));

} else {
var statearr_25909_26095 = state_25865__$1;
(statearr_25909_26095[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (92))){
var inst_25685 = (state_25865[(15)]);
var inst_25684 = (state_25865[(16)]);
var inst_25686 = (state_25865[(24)]);
var inst_25741 = (state_25865[(72)]);
var inst_25683 = (state_25865[(48)]);
var inst_25744 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25745 = (inst_25683 - inst_25741);
var inst_25746 = [inst_25745,inst_25684,inst_25685,inst_25686];
var inst_25747 = (new cljs.core.PersistentVector(null,4,(5),inst_25744,inst_25746,null));
var state_25865__$1 = state_25865;
var statearr_25910_26096 = state_25865__$1;
(statearr_25910_26096[(2)] = inst_25747);

(statearr_25910_26096[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (104))){
var inst_25803 = (state_25865[(2)]);
var inst_25804 = fluree.db.util.async.throw_err.call(null,inst_25803);
var state_25865__$1 = state_25865;
var statearr_25911_26097 = state_25865__$1;
(statearr_25911_26097[(2)] = inst_25804);

(statearr_25911_26097[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (15))){
var inst_25525 = (state_25865[(56)]);
var inst_25555 = cljs.core.boolean_QMARK_.call(null,inst_25525);
var state_25865__$1 = state_25865;
if(inst_25555){
var statearr_25912_26098 = state_25865__$1;
(statearr_25912_26098[(1)] = (17));

} else {
var statearr_25913_26099 = state_25865__$1;
(statearr_25913_26099[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (48))){
var inst_25528 = (state_25865[(61)]);
var inst_25632 = (state_25865[(2)]);
var state_25865__$1 = (function (){var statearr_25914 = state_25865;
(statearr_25914[(29)] = inst_25632);

return statearr_25914;
})();
if(cljs.core.truth_(inst_25528)){
var statearr_25915_26100 = state_25865__$1;
(statearr_25915_26100[(1)] = (52));

} else {
var statearr_25916_26101 = state_25865__$1;
(statearr_25916_26101[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (50))){
var state_25865__$1 = state_25865;
var statearr_25917_26102 = state_25865__$1;
(statearr_25917_26102[(2)] = (2147483647));

(statearr_25917_26102[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (116))){
var inst_25837 = (state_25865[(66)]);
var inst_25845 = (state_25865[(2)]);
var state_25865__$1 = (function (){var statearr_25918 = state_25865;
(statearr_25918[(73)] = inst_25845);

return statearr_25918;
})();
if(cljs.core.truth_(inst_25837)){
var statearr_25919_26103 = state_25865__$1;
(statearr_25919_26103[(1)] = (118));

} else {
var statearr_25920_26104 = state_25865__$1;
(statearr_25920_26104[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (75))){
var inst_25700 = (state_25865[(41)]);
var state_25865__$1 = state_25865;
var statearr_25921_26105 = state_25865__$1;
(statearr_25921_26105[(2)] = inst_25700);

(statearr_25921_26105[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (99))){
var inst_25761 = (state_25865[(67)]);
var inst_25770 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25771 = [inst_25761,inst_25761];
var inst_25772 = (new cljs.core.PersistentVector(null,2,(5),inst_25770,inst_25771,null));
var state_25865__$1 = state_25865;
var statearr_25922_26106 = state_25865__$1;
(statearr_25922_26106[(2)] = inst_25772);

(statearr_25922_26106[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (21))){
var state_25865__$1 = state_25865;
var statearr_25923_26107 = state_25865__$1;
(statearr_25923_26107[(2)] = null);

(statearr_25923_26107[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (31))){
var inst_25586 = (state_25865[(74)]);
var state_25865__$1 = state_25865;
var statearr_25924_26108 = state_25865__$1;
(statearr_25924_26108[(2)] = inst_25586);

(statearr_25924_26108[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (113))){
var inst_25831 = (state_25865[(2)]);
var state_25865__$1 = state_25865;
var statearr_25925_26109 = state_25865__$1;
(statearr_25925_26109[(2)] = inst_25831);

(statearr_25925_26109[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (32))){
var inst_25606 = (state_25865[(75)]);
var inst_25517 = (state_25865[(62)]);
var inst_25605 = (state_25865[(2)]);
var inst_25606__$1 = (inst_25517 == null);
var state_25865__$1 = (function (){var statearr_25926 = state_25865;
(statearr_25926[(31)] = inst_25605);

(statearr_25926[(75)] = inst_25606__$1);

return statearr_25926;
})();
if(cljs.core.truth_(inst_25606__$1)){
var statearr_25927_26110 = state_25865__$1;
(statearr_25927_26110[(1)] = (34));

} else {
var statearr_25928_26111 = state_25865__$1;
(statearr_25928_26111[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (40))){
var inst_25605 = (state_25865[(31)]);
var state_25865__$1 = state_25865;
var statearr_25929_26112 = state_25865__$1;
(statearr_25929_26112[(2)] = inst_25605);

(statearr_25929_26112[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (91))){
var inst_25719 = (state_25865[(65)]);
var inst_25817 = (state_25865[(2)]);
var inst_25818 = cljs.core.nth.call(null,inst_25817,(0),null);
var inst_25819 = cljs.core.nth.call(null,inst_25817,(1),null);
var inst_25820 = cljs.core.nth.call(null,inst_25817,(2),null);
var inst_25821 = cljs.core.nth.call(null,inst_25817,(3),null);
var state_25865__$1 = (function (){var statearr_25930 = state_25865;
(statearr_25930[(7)] = inst_25821);

(statearr_25930[(76)] = inst_25819);

(statearr_25930[(77)] = inst_25818);

(statearr_25930[(78)] = inst_25820);

return statearr_25930;
})();
if(cljs.core.truth_(inst_25719)){
var statearr_25931_26113 = state_25865__$1;
(statearr_25931_26113[(1)] = (105));

} else {
var statearr_25932_26114 = state_25865__$1;
(statearr_25932_26114[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (117))){
var inst_25841 = (state_25865[(2)]);
var inst_25842 = fluree.db.util.async.throw_err.call(null,inst_25841);
var state_25865__$1 = state_25865;
var statearr_25933_26115 = state_25865__$1;
(statearr_25933_26115[(2)] = inst_25842);

(statearr_25933_26115[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (108))){
var inst_25819 = (state_25865[(76)]);
var inst_25826 = (state_25865[(79)]);
var inst_25646 = (state_25865[(34)]);
var inst_25826__$1 = (inst_25819 < inst_25646);
var state_25865__$1 = (function (){var statearr_25934 = state_25865;
(statearr_25934[(79)] = inst_25826__$1);

return statearr_25934;
})();
if(cljs.core.truth_(inst_25826__$1)){
var statearr_25935_26116 = state_25865__$1;
(statearr_25935_26116[(1)] = (111));

} else {
var statearr_25936_26117 = state_25865__$1;
(statearr_25936_26117[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (56))){
var state_25865__$1 = state_25865;
var statearr_25937_26118 = state_25865__$1;
(statearr_25937_26118[(2)] = fluree.db.util.core.min_integer);

(statearr_25937_26118[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (33))){
var inst_25601 = (state_25865[(2)]);
var inst_25602 = fluree.db.util.async.throw_err.call(null,inst_25601);
var state_25865__$1 = state_25865;
var statearr_25938_26119 = state_25865__$1;
(statearr_25938_26119[(2)] = inst_25602);

(statearr_25938_26119[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (13))){
var inst_25547 = (state_25865[(2)]);
var inst_25548 = fluree.db.util.async.throw_err.call(null,inst_25547);
var state_25865__$1 = state_25865;
var statearr_25939_26120 = state_25865__$1;
(statearr_25939_26120[(2)] = inst_25548);

(statearr_25939_26120[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (22))){
var inst_25561 = (state_25865[(2)]);
var state_25865__$1 = state_25865;
var statearr_25940_26121 = state_25865__$1;
(statearr_25940_26121[(2)] = inst_25561);

(statearr_25940_26121[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (90))){
var inst_25532 = (state_25865[(10)]);
var inst_25530 = (state_25865[(11)]);
var inst_25531 = (state_25865[(12)]);
var inst_25740 = (state_25865[(80)]);
var inst_25653 = (state_25865[(13)]);
var inst_25692 = (state_25865[(14)]);
var inst_25685 = (state_25865[(15)]);
var inst_25684 = (state_25865[(16)]);
var inst_25718 = (state_25865[(81)]);
var inst_25584 = (state_25865[(17)]);
var inst_25658 = (state_25865[(18)]);
var inst_25663 = (state_25865[(19)]);
var inst_25542 = (state_25865[(20)]);
var inst_25587 = (state_25865[(21)]);
var inst_25643 = (state_25865[(22)]);
var inst_25520 = (state_25865[(23)]);
var inst_25686 = (state_25865[(24)]);
var inst_25551 = (state_25865[(25)]);
var inst_25673 = (state_25865[(8)]);
var inst_25719 = (state_25865[(65)]);
var inst_25526 = (state_25865[(26)]);
var inst_25664 = (state_25865[(27)]);
var inst_25679 = (state_25865[(9)]);
var inst_25652 = (state_25865[(28)]);
var inst_25632 = (state_25865[(29)]);
var inst_25669 = (state_25865[(30)]);
var inst_25605 = (state_25865[(31)]);
var inst_25741 = (state_25865[(72)]);
var inst_25642 = (state_25865[(32)]);
var inst_25519 = (state_25865[(33)]);
var inst_25646 = (state_25865[(34)]);
var inst_25522 = (state_25865[(35)]);
var inst_25645 = (state_25865[(36)]);
var inst_25614 = (state_25865[(37)]);
var inst_25659 = (state_25865[(38)]);
var inst_25623 = (state_25865[(39)]);
var inst_25515 = (state_25865[(40)]);
var inst_25641 = (state_25865[(42)]);
var inst_25654 = (state_25865[(43)]);
var inst_25583 = (state_25865[(44)]);
var inst_25596 = (state_25865[(45)]);
var inst_25682 = (state_25865[(46)]);
var inst_25527 = (state_25865[(47)]);
var inst_25683 = (state_25865[(48)]);
var inst_25739 = (function (){var no_filter_QMARK_ = inst_25679;
var base_result_SINGLEQUOTE_ = inst_25718;
var t = inst_25659;
var max_limit_QMARK_ = inst_25653;
var next_node = inst_25682;
var fast_forward_db_QMARK_ = inst_25664;
var s1 = inst_25542;
var o2 = inst_25605;
var t1 = inst_25519;
var predicate_fn = inst_25532;
var i = inst_25684;
var rhs = inst_25719;
var m1 = inst_25632;
var root_node = inst_25669;
var map__25514 = inst_25645;
var s2 = inst_25551;
var p2 = inst_25623;
var permissions = inst_25654;
var vec__25501 = inst_25515;
var limit = inst_25652;
var start_flake = inst_25642;
var flake_limit = inst_25646;
var offset = inst_25683;
var map__25507 = inst_25530;
var acc = inst_25686;
var t2 = inst_25526;
var op1 = inst_25520;
var o1 = inst_25596;
var end_flake = inst_25643;
var base_result = inst_25692;
var vec__25508 = inst_25583;
var s = inst_25685;
var node_start = inst_25673;
var p1 = inst_25614;
var subject_fn = inst_25531;
var vec__25504 = inst_25522;
var object_fn = inst_25587;
var idx_compare = inst_25658;
var op2 = inst_25527;
var m2 = inst_25641;
var vec__25511 = inst_25584;
var novelty = inst_25663;
return (function (p1__25486_SHARP_){
return p1__25486_SHARP_.s;
});
})();
var inst_25740__$1 = cljs.core.partition_by.call(null,inst_25739,inst_25718);
var inst_25741__$1 = cljs.core.count.call(null,inst_25740__$1);
var inst_25742 = (inst_25683 > inst_25741__$1);
var state_25865__$1 = (function (){var statearr_25941 = state_25865;
(statearr_25941[(80)] = inst_25740__$1);

(statearr_25941[(72)] = inst_25741__$1);

return statearr_25941;
})();
if(cljs.core.truth_(inst_25742)){
var statearr_25942_26122 = state_25865__$1;
(statearr_25942_26122[(1)] = (92));

} else {
var statearr_25943_26123 = state_25865__$1;
(statearr_25943_26123[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (109))){
var inst_25824 = (state_25865[(82)]);
var state_25865__$1 = state_25865;
var statearr_25944_26124 = state_25865__$1;
(statearr_25944_26124[(2)] = inst_25824);

(statearr_25944_26124[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (36))){
var inst_25610 = (state_25865[(2)]);
var state_25865__$1 = state_25865;
if(cljs.core.truth_(inst_25610)){
var statearr_25945_26125 = state_25865__$1;
(statearr_25945_26125[(1)] = (37));

} else {
var statearr_25946_26126 = state_25865__$1;
(statearr_25946_26126[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (41))){
var inst_25615 = (state_25865[(63)]);
var state_25865__$1 = state_25865;
var statearr_25947_26127 = state_25865__$1;
(statearr_25947_26127[(2)] = inst_25615);

(statearr_25947_26127[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (118))){
var inst_25845 = (state_25865[(73)]);
var state_25865__$1 = state_25865;
var statearr_25948_26128 = state_25865__$1;
(statearr_25948_26128[(2)] = inst_25845);

(statearr_25948_26128[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (89))){
var inst_25685 = (state_25865[(15)]);
var inst_25684 = (state_25865[(16)]);
var inst_25718 = (state_25865[(81)]);
var inst_25686 = (state_25865[(24)]);
var inst_25646 = (state_25865[(34)]);
var inst_25730 = cljs.core.count.call(null,inst_25718);
var inst_25731 = (inst_25646 - inst_25684);
var inst_25732 = cljs.core.take.call(null,inst_25731,inst_25718);
var inst_25733 = cljs.core.into.call(null,inst_25686,inst_25732);
var inst_25734 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25735 = (inst_25684 + inst_25730);
var inst_25736 = [(0),inst_25735,inst_25685,inst_25733];
var inst_25737 = (new cljs.core.PersistentVector(null,4,(5),inst_25734,inst_25736,null));
var state_25865__$1 = state_25865;
var statearr_25949_26129 = state_25865__$1;
(statearr_25949_26129[(2)] = inst_25737);

(statearr_25949_26129[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (100))){
var inst_25780 = (state_25865[(52)]);
var inst_25684 = (state_25865[(16)]);
var inst_25752 = (state_25865[(68)]);
var inst_25646 = (state_25865[(34)]);
var inst_25778 = (state_25865[(53)]);
var inst_25779 = (state_25865[(54)]);
var inst_25774 = (state_25865[(2)]);
var inst_25775 = cljs.core.nth.call(null,inst_25774,(0),null);
var inst_25776 = cljs.core.nth.call(null,inst_25774,(1),null);
var inst_25777 = cljs.core.take.call(null,inst_25776,inst_25752);
var inst_25778__$1 = cljs.core.apply.call(null,cljs.core.concat,inst_25777);
var inst_25779__$1 = cljs.core.count.call(null,inst_25778__$1);
var inst_25780__$1 = (inst_25684 + inst_25779__$1);
var inst_25781 = (inst_25780__$1 > inst_25646);
var state_25865__$1 = (function (){var statearr_25950 = state_25865;
(statearr_25950[(52)] = inst_25780__$1);

(statearr_25950[(83)] = inst_25775);

(statearr_25950[(53)] = inst_25778__$1);

(statearr_25950[(54)] = inst_25779__$1);

return statearr_25950;
})();
if(cljs.core.truth_(inst_25781)){
var statearr_25951_26130 = state_25865__$1;
(statearr_25951_26130[(1)] = (101));

} else {
var statearr_25952_26131 = state_25865__$1;
(statearr_25952_26131[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (122))){
var inst_25821 = (state_25865[(7)]);
var inst_25819 = (state_25865[(76)]);
var inst_25818 = (state_25865[(77)]);
var inst_25820 = (state_25865[(78)]);
var inst_25845 = (state_25865[(73)]);
var inst_25682 = inst_25845;
var inst_25683 = inst_25818;
var inst_25684 = inst_25819;
var inst_25685 = inst_25820;
var inst_25686 = inst_25821;
var state_25865__$1 = (function (){var statearr_25953 = state_25865;
(statearr_25953[(15)] = inst_25685);

(statearr_25953[(16)] = inst_25684);

(statearr_25953[(24)] = inst_25686);

(statearr_25953[(46)] = inst_25682);

(statearr_25953[(48)] = inst_25683);

return statearr_25953;
})();
var statearr_25954_26132 = state_25865__$1;
(statearr_25954_26132[(2)] = null);

(statearr_25954_26132[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (43))){
var state_25865__$1 = state_25865;
var statearr_25955_26133 = state_25865__$1;
(statearr_25955_26133[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_25955_26133[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (61))){
var inst_25663 = (state_25865[(19)]);
var inst_25664 = (state_25865[(27)]);
var inst_25669 = (state_25865[(30)]);
var inst_25642 = (state_25865[(32)]);
var inst_25659 = (state_25865[(38)]);
var inst_25668 = (state_25865[(2)]);
var inst_25669__$1 = fluree.db.util.async.throw_err.call(null,inst_25668);
var inst_25670 = fluree.db.query.range.find_next_valid_node.call(null,inst_25669__$1,inst_25642,inst_25659,inst_25663,inst_25664);
var state_25865__$1 = (function (){var statearr_25956 = state_25865;
(statearr_25956[(30)] = inst_25669__$1);

return statearr_25956;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25865__$1,(62),inst_25670);
} else {
if((state_val_25866 === (29))){
var inst_25592 = (state_25865[(2)]);
var inst_25593 = fluree.db.util.async.throw_err.call(null,inst_25592);
var state_25865__$1 = state_25865;
var statearr_25957_26134 = state_25865__$1;
(statearr_25957_26134[(2)] = inst_25593);

(statearr_25957_26134[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (44))){
var inst_25524 = (state_25865[(59)]);
var state_25865__$1 = state_25865;
var statearr_25958_26135 = state_25865__$1;
(statearr_25958_26135[(2)] = inst_25524);

(statearr_25958_26135[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (93))){
var inst_25740 = (state_25865[(80)]);
var inst_25679 = (state_25865[(9)]);
var inst_25683 = (state_25865[(48)]);
var inst_25752 = cljs.core.drop.call(null,inst_25683,inst_25740);
var state_25865__$1 = (function (){var statearr_25959 = state_25865;
(statearr_25959[(68)] = inst_25752);

return statearr_25959;
})();
if(cljs.core.truth_(inst_25679)){
var statearr_25960_26136 = state_25865__$1;
(statearr_25960_26136[(1)] = (95));

} else {
var statearr_25961_26137 = state_25865__$1;
(statearr_25961_26137[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (6))){
var inst_25516 = (state_25865[(49)]);
var inst_25536 = fluree.db.dbproto._subid.call(null,db,inst_25516);
var state_25865__$1 = state_25865;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25865__$1,(9),inst_25536);
} else {
if((state_val_25866 === (111))){
var inst_25652 = (state_25865[(28)]);
var inst_25820 = (state_25865[(78)]);
var inst_25828 = (inst_25820 < inst_25652);
var state_25865__$1 = state_25865;
var statearr_25962_26138 = state_25865__$1;
(statearr_25962_26138[(2)] = inst_25828);

(statearr_25962_26138[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (28))){
var inst_25586 = (state_25865[(74)]);
var inst_25596 = (state_25865[(2)]);
var inst_25597 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_25586);
var state_25865__$1 = (function (){var statearr_25963 = state_25865;
(statearr_25963[(45)] = inst_25596);

return statearr_25963;
})();
if(inst_25597){
var statearr_25964_26139 = state_25865__$1;
(statearr_25964_26139[(1)] = (30));

} else {
var statearr_25965_26140 = state_25865__$1;
(statearr_25965_26140[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (64))){
var state_25865__$1 = state_25865;
var statearr_25966_26141 = state_25865__$1;
(statearr_25966_26141[(2)] = true);

(statearr_25966_26141[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (103))){
var inst_25775 = (state_25865[(83)]);
var inst_25794 = (state_25865[(2)]);
var inst_25795 = cljs.core.nth.call(null,inst_25794,(0),null);
var inst_25796 = cljs.core.nth.call(null,inst_25794,(1),null);
var inst_25797 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25798 = [inst_25795,inst_25775,inst_25796];
var inst_25799 = (new cljs.core.PersistentVector(null,3,(5),inst_25797,inst_25798,null));
var state_25865__$1 = state_25865;
var statearr_25967_26142 = state_25865__$1;
(statearr_25967_26142[(2)] = inst_25799);

(statearr_25967_26142[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (51))){
var inst_25630 = (state_25865[(2)]);
var state_25865__$1 = state_25865;
var statearr_25968_26143 = state_25865__$1;
(statearr_25968_26143[(2)] = inst_25630);

(statearr_25968_26143[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (25))){
var inst_25584 = (state_25865[(17)]);
var inst_25585 = (state_25865[(51)]);
var inst_25583 = (state_25865[(44)]);
var inst_25583__$1 = (state_25865[(2)]);
var inst_25584__$1 = cljs.core.nth.call(null,inst_25583__$1,(0),null);
var inst_25585__$1 = cljs.core.nth.call(null,inst_25584__$1,(0),null);
var inst_25586 = cljs.core.nth.call(null,inst_25584__$1,(1),null);
var inst_25587 = cljs.core.nth.call(null,inst_25583__$1,(1),null);
var inst_25588 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_25585__$1);
var state_25865__$1 = (function (){var statearr_25969 = state_25865;
(statearr_25969[(17)] = inst_25584__$1);

(statearr_25969[(21)] = inst_25587);

(statearr_25969[(74)] = inst_25586);

(statearr_25969[(51)] = inst_25585__$1);

(statearr_25969[(44)] = inst_25583__$1);

return statearr_25969;
})();
if(inst_25588){
var statearr_25970_26144 = state_25865__$1;
(statearr_25970_26144[(1)] = (26));

} else {
var statearr_25971_26145 = state_25865__$1;
(statearr_25971_26145[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (34))){
var inst_25596 = (state_25865[(45)]);
var state_25865__$1 = state_25865;
var statearr_25972_26146 = state_25865__$1;
(statearr_25972_26146[(2)] = inst_25596);

(statearr_25972_26146[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (17))){
var inst_25525 = (state_25865[(56)]);
var state_25865__$1 = state_25865;
var statearr_25973_26147 = state_25865__$1;
(statearr_25973_26147[(2)] = inst_25525);

(statearr_25973_26147[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (3))){
var inst_25863 = (state_25865[(2)]);
var state_25865__$1 = state_25865;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25865__$1,inst_25863);
} else {
if((state_val_25866 === (12))){
var inst_25518 = (state_25865[(57)]);
var inst_25551 = (state_25865[(2)]);
var inst_25552 = cljs.core.boolean_QMARK_.call(null,inst_25518);
var state_25865__$1 = (function (){var statearr_25974 = state_25865;
(statearr_25974[(25)] = inst_25551);

return statearr_25974;
})();
if(inst_25552){
var statearr_25975_26148 = state_25865__$1;
(statearr_25975_26148[(1)] = (14));

} else {
var statearr_25976_26149 = state_25865__$1;
(statearr_25976_26149[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (2))){
var inst_25530 = (state_25865[(11)]);
var inst_25516 = (state_25865[(49)]);
var inst_25522 = (state_25865[(35)]);
var inst_25515 = (state_25865[(40)]);
var _ = (function (){var statearr_25977 = state_25865;
(statearr_25977[(4)] = cljs.core.cons.call(null,(5),(state_25865[(4)])));

return statearr_25977;
})();
var inst_25515__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_25516__$1 = cljs.core.nth.call(null,inst_25515__$1,(0),null);
var inst_25517 = cljs.core.nth.call(null,inst_25515__$1,(1),null);
var inst_25518 = cljs.core.nth.call(null,inst_25515__$1,(2),null);
var inst_25519 = cljs.core.nth.call(null,inst_25515__$1,(3),null);
var inst_25520 = cljs.core.nth.call(null,inst_25515__$1,(4),null);
var inst_25521 = cljs.core.nth.call(null,inst_25515__$1,(5),null);
var inst_25522__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_25523 = cljs.core.nth.call(null,inst_25522__$1,(0),null);
var inst_25524 = cljs.core.nth.call(null,inst_25522__$1,(1),null);
var inst_25525 = cljs.core.nth.call(null,inst_25522__$1,(2),null);
var inst_25526 = cljs.core.nth.call(null,inst_25522__$1,(3),null);
var inst_25527 = cljs.core.nth.call(null,inst_25522__$1,(4),null);
var inst_25528 = cljs.core.nth.call(null,inst_25522__$1,(5),null);
var inst_25529 = opts;
var inst_25530__$1 = cljs.core.__destructure_map.call(null,inst_25529);
var inst_25531 = cljs.core.get.call(null,inst_25530__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var inst_25532 = cljs.core.get.call(null,inst_25530__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var inst_25533 = cljs.core.get.call(null,inst_25530__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var inst_25534 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_25516__$1);
var state_25865__$1 = (function (){var statearr_25978 = state_25865;
(statearr_25978[(10)] = inst_25532);

(statearr_25978[(11)] = inst_25530__$1);

(statearr_25978[(12)] = inst_25531);

(statearr_25978[(55)] = inst_25533);

(statearr_25978[(49)] = inst_25516__$1);

(statearr_25978[(56)] = inst_25525);

(statearr_25978[(57)] = inst_25518);

(statearr_25978[(58)] = inst_25521);

(statearr_25978[(84)] = inst_25523);

(statearr_25978[(23)] = inst_25520);

(statearr_25978[(26)] = inst_25526);

(statearr_25978[(59)] = inst_25524);

(statearr_25978[(33)] = inst_25519);

(statearr_25978[(35)] = inst_25522__$1);

(statearr_25978[(61)] = inst_25528);

(statearr_25978[(40)] = inst_25515__$1);

(statearr_25978[(47)] = inst_25527);

(statearr_25978[(62)] = inst_25517);

return statearr_25978;
})();
if(inst_25534){
var statearr_25979_26150 = state_25865__$1;
(statearr_25979_26150[(1)] = (6));

} else {
var statearr_25980_26151 = state_25865__$1;
(statearr_25980_26151[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (66))){
var inst_25648 = (state_25865[(71)]);
var inst_25673 = (state_25865[(8)]);
var inst_25681 = cljs.core.PersistentVector.EMPTY;
var inst_25682 = inst_25673;
var inst_25683 = inst_25648;
var inst_25684 = (0);
var inst_25685 = (0);
var inst_25686 = inst_25681;
var state_25865__$1 = (function (){var statearr_25981 = state_25865;
(statearr_25981[(15)] = inst_25685);

(statearr_25981[(16)] = inst_25684);

(statearr_25981[(24)] = inst_25686);

(statearr_25981[(46)] = inst_25682);

(statearr_25981[(48)] = inst_25683);

return statearr_25981;
})();
var statearr_25982_26152 = state_25865__$1;
(statearr_25982_26152[(2)] = null);

(statearr_25982_26152[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (107))){
var inst_25837 = (state_25865[(66)]);
var inst_25837__$1 = (state_25865[(2)]);
var state_25865__$1 = (function (){var statearr_25983 = state_25865;
(statearr_25983[(66)] = inst_25837__$1);

return statearr_25983;
})();
if(cljs.core.truth_(inst_25837__$1)){
var statearr_25984_26153 = state_25865__$1;
(statearr_25984_26153[(1)] = (114));

} else {
var statearr_25985_26154 = state_25865__$1;
(statearr_25985_26154[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (23))){
var inst_25533 = (state_25865[(55)]);
var inst_25525 = (state_25865[(56)]);
var inst_25518 = (state_25865[(57)]);
var inst_25568 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25569 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25570 = [inst_25518,inst_25525];
var inst_25571 = (new cljs.core.PersistentVector(null,2,(5),inst_25569,inst_25570,null));
var inst_25572 = [inst_25571,inst_25533];
var inst_25573 = (new cljs.core.PersistentVector(null,2,(5),inst_25568,inst_25572,null));
var state_25865__$1 = state_25865;
var statearr_25986_26155 = state_25865__$1;
(statearr_25986_26155[(2)] = inst_25573);

(statearr_25986_26155[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (47))){
var inst_25626 = (cljs.core._GT__EQ_ === start_test);
var state_25865__$1 = state_25865;
if(cljs.core.truth_(inst_25626)){
var statearr_25987_26156 = state_25865__$1;
(statearr_25987_26156[(1)] = (49));

} else {
var statearr_25988_26157 = state_25865__$1;
(statearr_25988_26157[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (35))){
var inst_25606 = (state_25865[(75)]);
var state_25865__$1 = state_25865;
var statearr_25989_26158 = state_25865__$1;
(statearr_25989_26158[(2)] = inst_25606);

(statearr_25989_26158[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (82))){
var inst_25653 = (state_25865[(13)]);
var inst_25682 = (state_25865[(46)]);
var inst_25718 = (state_25865[(2)]);
var inst_25719 = fluree.db.dbproto._rhs.call(null,inst_25682);
var state_25865__$1 = (function (){var statearr_25990 = state_25865;
(statearr_25990[(81)] = inst_25718);

(statearr_25990[(65)] = inst_25719);

return statearr_25990;
})();
if(cljs.core.truth_(inst_25653)){
var statearr_25991_26159 = state_25865__$1;
(statearr_25991_26159[(1)] = (83));

} else {
var statearr_25992_26160 = state_25865__$1;
(statearr_25992_26160[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (76))){
var inst_25532 = (state_25865[(10)]);
var inst_25706 = (state_25865[(2)]);
var state_25865__$1 = (function (){var statearr_25993 = state_25865;
(statearr_25993[(64)] = inst_25706);

return statearr_25993;
})();
if(cljs.core.truth_(inst_25532)){
var statearr_25994_26161 = state_25865__$1;
(statearr_25994_26161[(1)] = (77));

} else {
var statearr_25995_26162 = state_25865__$1;
(statearr_25995_26162[(1)] = (78));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (97))){
var inst_25686 = (state_25865[(24)]);
var inst_25806 = (state_25865[(2)]);
var inst_25807 = cljs.core.nth.call(null,inst_25806,(0),null);
var inst_25808 = cljs.core.nth.call(null,inst_25806,(1),null);
var inst_25809 = cljs.core.nth.call(null,inst_25806,(2),null);
var inst_25810 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25811 = cljs.core.into.call(null,inst_25686,inst_25809);
var inst_25812 = [(0),inst_25807,inst_25808,inst_25811];
var inst_25813 = (new cljs.core.PersistentVector(null,4,(5),inst_25810,inst_25812,null));
var state_25865__$1 = state_25865;
var statearr_25996_26163 = state_25865__$1;
(statearr_25996_26163[(2)] = inst_25813);

(statearr_25996_26163[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (19))){
var inst_25563 = (state_25865[(2)]);
var state_25865__$1 = state_25865;
var statearr_25997_26164 = state_25865__$1;
(statearr_25997_26164[(2)] = inst_25563);

(statearr_25997_26164[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (57))){
var inst_25639 = (state_25865[(2)]);
var state_25865__$1 = state_25865;
var statearr_25998_26165 = state_25865__$1;
(statearr_25998_26165[(2)] = inst_25639);

(statearr_25998_26165[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (68))){
var inst_25860 = (state_25865[(2)]);
var _ = (function (){var statearr_25999 = state_25865;
(statearr_25999[(4)] = cljs.core.rest.call(null,(state_25865[(4)])));

return statearr_25999;
})();
var state_25865__$1 = state_25865;
var statearr_26000_26166 = state_25865__$1;
(statearr_26000_26166[(2)] = inst_25860);

(statearr_26000_26166[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (11))){
var inst_25523 = (state_25865[(84)]);
var state_25865__$1 = state_25865;
var statearr_26001_26167 = state_25865__$1;
(statearr_26001_26167[(2)] = inst_25523);

(statearr_26001_26167[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (115))){
var state_25865__$1 = state_25865;
var statearr_26003_26168 = state_25865__$1;
(statearr_26003_26168[(2)] = null);

(statearr_26003_26168[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (9))){
var inst_25538 = (state_25865[(2)]);
var inst_25539 = fluree.db.util.async.throw_err.call(null,inst_25538);
var state_25865__$1 = state_25865;
var statearr_26004_26169 = state_25865__$1;
(statearr_26004_26169[(2)] = inst_25539);

(statearr_26004_26169[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (5))){
var _ = (function (){var statearr_26005 = state_25865;
(statearr_26005[(4)] = cljs.core.rest.call(null,(state_25865[(4)])));

return statearr_26005;
})();
var state_25865__$1 = state_25865;
var ex26002 = (state_25865__$1[(2)]);
var statearr_26006_26170 = state_25865__$1;
(statearr_26006_26170[(5)] = ex26002);


if((ex26002 instanceof Error)){
var statearr_26007_26171 = state_25865__$1;
(statearr_26007_26171[(1)] = (4));

(statearr_26007_26171[(5)] = null);

} else {
throw ex26002;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (112))){
var inst_25826 = (state_25865[(79)]);
var state_25865__$1 = state_25865;
var statearr_26008_26172 = state_25865__$1;
(statearr_26008_26172[(2)] = inst_25826);

(statearr_26008_26172[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (83))){
var inst_25721 = (state_25865[(85)]);
var inst_25683 = (state_25865[(48)]);
var inst_25721__$1 = cljs.core._EQ_.call(null,(0),inst_25683);
var state_25865__$1 = (function (){var statearr_26009 = state_25865;
(statearr_26009[(85)] = inst_25721__$1);

return statearr_26009;
})();
if(inst_25721__$1){
var statearr_26010_26173 = state_25865__$1;
(statearr_26010_26173[(1)] = (86));

} else {
var statearr_26011_26174 = state_25865__$1;
(statearr_26011_26174[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (14))){
var inst_25518 = (state_25865[(57)]);
var state_25865__$1 = state_25865;
var statearr_26012_26175 = state_25865__$1;
(statearr_26012_26175[(2)] = inst_25518);

(statearr_26012_26175[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (45))){
var inst_25521 = (state_25865[(58)]);
var inst_25623 = (state_25865[(2)]);
var state_25865__$1 = (function (){var statearr_26013 = state_25865;
(statearr_26013[(39)] = inst_25623);

return statearr_26013;
})();
if(cljs.core.truth_(inst_25521)){
var statearr_26014_26176 = state_25865__$1;
(statearr_26014_26176[(1)] = (46));

} else {
var statearr_26015_26177 = state_25865__$1;
(statearr_26015_26177[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (53))){
var inst_25635 = (cljs.core._LT__EQ_ === end_test);
var state_25865__$1 = state_25865;
if(cljs.core.truth_(inst_25635)){
var statearr_26016_26178 = state_25865__$1;
(statearr_26016_26178[(1)] = (55));

} else {
var statearr_26017_26179 = state_25865__$1;
(statearr_26017_26179[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (78))){
var inst_25706 = (state_25865[(64)]);
var state_25865__$1 = state_25865;
var statearr_26018_26180 = state_25865__$1;
(statearr_26018_26180[(2)] = inst_25706);

(statearr_26018_26180[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (26))){
var inst_25585 = (state_25865[(51)]);
var inst_25590 = fluree.db.dbproto._subid.call(null,db,inst_25585);
var state_25865__$1 = state_25865;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25865__$1,(29),inst_25590);
} else {
if((state_val_25866 === (123))){
var inst_25855 = (state_25865[(2)]);
var state_25865__$1 = state_25865;
var statearr_26019_26181 = state_25865__$1;
(statearr_26019_26181[(2)] = inst_25855);

(statearr_26019_26181[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (16))){
var inst_25565 = (state_25865[(60)]);
var inst_25565__$1 = (state_25865[(2)]);
var inst_25566 = (inst_25565__$1 == null);
var state_25865__$1 = (function (){var statearr_26020 = state_25865;
(statearr_26020[(60)] = inst_25565__$1);

return statearr_26020;
})();
if(cljs.core.truth_(inst_25566)){
var statearr_26021_26182 = state_25865__$1;
(statearr_26021_26182[(1)] = (23));

} else {
var statearr_26022_26183 = state_25865__$1;
(statearr_26022_26183[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (81))){
var inst_25712 = (state_25865[(86)]);
var state_25865__$1 = state_25865;
var statearr_26023_26184 = state_25865__$1;
(statearr_26023_26184[(2)] = inst_25712);

(statearr_26023_26184[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (120))){
var inst_25849 = (state_25865[(2)]);
var inst_25850 = cljs.core.not.call(null,inst_25849);
var state_25865__$1 = state_25865;
if(inst_25850){
var statearr_26024_26185 = state_25865__$1;
(statearr_26024_26185[(1)] = (121));

} else {
var statearr_26025_26186 = state_25865__$1;
(statearr_26025_26186[(1)] = (122));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (79))){
var inst_25587 = (state_25865[(21)]);
var inst_25712 = (state_25865[(2)]);
var state_25865__$1 = (function (){var statearr_26026 = state_25865;
(statearr_26026[(86)] = inst_25712);

return statearr_26026;
})();
if(cljs.core.truth_(inst_25587)){
var statearr_26027_26187 = state_25865__$1;
(statearr_26027_26187[(1)] = (80));

} else {
var statearr_26028_26188 = state_25865__$1;
(statearr_26028_26188[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (38))){
var inst_25517 = (state_25865[(62)]);
var state_25865__$1 = state_25865;
var statearr_26029_26189 = state_25865__$1;
(statearr_26029_26189[(2)] = inst_25517);

(statearr_26029_26189[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (98))){
var inst_25762 = (state_25865[(69)]);
var inst_25652 = (state_25865[(28)]);
var inst_25760 = (state_25865[(70)]);
var inst_25765 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25766 = (inst_25760 - inst_25762);
var inst_25767 = [inst_25652,inst_25766];
var inst_25768 = (new cljs.core.PersistentVector(null,2,(5),inst_25765,inst_25767,null));
var state_25865__$1 = state_25865;
var statearr_26030_26190 = state_25865__$1;
(statearr_26030_26190[(2)] = inst_25768);

(statearr_26030_26190[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (87))){
var inst_25721 = (state_25865[(85)]);
var state_25865__$1 = state_25865;
var statearr_26031_26191 = state_25865__$1;
(statearr_26031_26191[(2)] = inst_25721);

(statearr_26031_26191[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (30))){
var inst_25586 = (state_25865[(74)]);
var inst_25599 = fluree.db.dbproto._subid.call(null,db,inst_25586);
var state_25865__$1 = state_25865;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25865__$1,(33),inst_25599);
} else {
if((state_val_25866 === (73))){
var inst_25531 = (state_25865[(12)]);
var inst_25700 = (state_25865[(2)]);
var state_25865__$1 = (function (){var statearr_26032 = state_25865;
(statearr_26032[(41)] = inst_25700);

return statearr_26032;
})();
if(cljs.core.truth_(inst_25531)){
var statearr_26033_26192 = state_25865__$1;
(statearr_26033_26192[(1)] = (74));

} else {
var statearr_26034_26193 = state_25865__$1;
(statearr_26034_26193[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (96))){
var inst_25685 = (state_25865[(15)]);
var inst_25684 = (state_25865[(16)]);
var inst_25752 = (state_25865[(68)]);
var inst_25652 = (state_25865[(28)]);
var inst_25646 = (state_25865[(34)]);
var inst_25801 = fluree.db.query.range.subject_groups__GT_allow_flakes.call(null,db,inst_25752,inst_25684,inst_25685,inst_25646,inst_25652);
var state_25865__$1 = state_25865;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25865__$1,(104),inst_25801);
} else {
if((state_val_25866 === (10))){
var inst_25523 = (state_25865[(84)]);
var inst_25545 = fluree.db.dbproto._subid.call(null,db,inst_25523);
var state_25865__$1 = state_25865;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25865__$1,(13),inst_25545);
} else {
if((state_val_25866 === (18))){
var state_25865__$1 = state_25865;
var statearr_26035_26194 = state_25865__$1;
(statearr_26035_26194[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (105))){
var inst_25658 = (state_25865[(18)]);
var inst_25643 = (state_25865[(22)]);
var inst_25824 = (state_25865[(82)]);
var inst_25719 = (state_25865[(65)]);
var inst_25823 = inst_25658.call(null,inst_25719,inst_25643);
var inst_25824__$1 = (inst_25823 < (0));
var state_25865__$1 = (function (){var statearr_26037 = state_25865;
(statearr_26037[(82)] = inst_25824__$1);

return statearr_26037;
})();
if(cljs.core.truth_(inst_25824__$1)){
var statearr_26038_26195 = state_25865__$1;
(statearr_26038_26195[(1)] = (108));

} else {
var statearr_26039_26196 = state_25865__$1;
(statearr_26039_26196[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (52))){
var inst_25528 = (state_25865[(61)]);
var state_25865__$1 = state_25865;
var statearr_26040_26197 = state_25865__$1;
(statearr_26040_26197[(2)] = inst_25528);

(statearr_26040_26197[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (114))){
var inst_25663 = (state_25865[(19)]);
var inst_25719 = (state_25865[(65)]);
var inst_25664 = (state_25865[(27)]);
var inst_25669 = (state_25865[(30)]);
var inst_25659 = (state_25865[(38)]);
var inst_25839 = fluree.db.query.range.find_next_valid_node.call(null,inst_25669,inst_25719,inst_25659,inst_25663,inst_25664);
var state_25865__$1 = state_25865;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25865__$1,(117),inst_25839);
} else {
if((state_val_25866 === (67))){
var state_25865__$1 = state_25865;
var statearr_26041_26198 = state_25865__$1;
(statearr_26041_26198[(2)] = null);

(statearr_26041_26198[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (71))){
var inst_25532 = (state_25865[(10)]);
var inst_25530 = (state_25865[(11)]);
var inst_25531 = (state_25865[(12)]);
var inst_25653 = (state_25865[(13)]);
var inst_25692 = (state_25865[(14)]);
var inst_25685 = (state_25865[(15)]);
var inst_25684 = (state_25865[(16)]);
var inst_25584 = (state_25865[(17)]);
var inst_25658 = (state_25865[(18)]);
var inst_25663 = (state_25865[(19)]);
var inst_25542 = (state_25865[(20)]);
var inst_25587 = (state_25865[(21)]);
var inst_25643 = (state_25865[(22)]);
var inst_25520 = (state_25865[(23)]);
var inst_25686 = (state_25865[(24)]);
var inst_25551 = (state_25865[(25)]);
var inst_25673 = (state_25865[(8)]);
var inst_25526 = (state_25865[(26)]);
var inst_25664 = (state_25865[(27)]);
var inst_25679 = (state_25865[(9)]);
var inst_25652 = (state_25865[(28)]);
var inst_25632 = (state_25865[(29)]);
var inst_25669 = (state_25865[(30)]);
var inst_25605 = (state_25865[(31)]);
var inst_25642 = (state_25865[(32)]);
var inst_25519 = (state_25865[(33)]);
var inst_25646 = (state_25865[(34)]);
var inst_25522 = (state_25865[(35)]);
var inst_25645 = (state_25865[(36)]);
var inst_25614 = (state_25865[(37)]);
var inst_25659 = (state_25865[(38)]);
var inst_25623 = (state_25865[(39)]);
var inst_25515 = (state_25865[(40)]);
var inst_25641 = (state_25865[(42)]);
var inst_25654 = (state_25865[(43)]);
var inst_25583 = (state_25865[(44)]);
var inst_25596 = (state_25865[(45)]);
var inst_25682 = (state_25865[(46)]);
var inst_25527 = (state_25865[(47)]);
var inst_25683 = (state_25865[(48)]);
var inst_25696 = (function (){var no_filter_QMARK_ = inst_25679;
var G__25693 = inst_25692;
var t = inst_25659;
var max_limit_QMARK_ = inst_25653;
var next_node = inst_25682;
var fast_forward_db_QMARK_ = inst_25664;
var s1 = inst_25542;
var o2 = inst_25605;
var t1 = inst_25519;
var predicate_fn = inst_25532;
var i = inst_25684;
var m1 = inst_25632;
var root_node = inst_25669;
var map__25514 = inst_25645;
var s2 = inst_25551;
var p2 = inst_25623;
var permissions = inst_25654;
var vec__25501 = inst_25515;
var limit = inst_25652;
var start_flake = inst_25642;
var flake_limit = inst_25646;
var offset = inst_25683;
var map__25507 = inst_25530;
var acc = inst_25686;
var t2 = inst_25526;
var op1 = inst_25520;
var o1 = inst_25596;
var end_flake = inst_25643;
var base_result = inst_25692;
var vec__25508 = inst_25583;
var s = inst_25685;
var node_start = inst_25673;
var p1 = inst_25614;
var subject_fn = inst_25531;
var vec__25504 = inst_25522;
var object_fn = inst_25587;
var idx_compare = inst_25658;
var op2 = inst_25527;
var m2 = inst_25641;
var vec__25511 = inst_25584;
var novelty = inst_25663;
return (function (p1__25482_SHARP_){
return cljs.core._EQ_.call(null,p1__25482_SHARP_.o,start_flake.o);
});
})();
var inst_25697 = cljs.core.filter.call(null,inst_25696,inst_25692);
var state_25865__$1 = state_25865;
var statearr_26042_26199 = state_25865__$1;
(statearr_26042_26199[(2)] = inst_25697);

(statearr_26042_26199[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (42))){
var inst_25619 = (state_25865[(2)]);
var state_25865__$1 = state_25865;
if(cljs.core.truth_(inst_25619)){
var statearr_26043_26200 = state_25865__$1;
(statearr_26043_26200[(1)] = (43));

} else {
var statearr_26044_26201 = state_25865__$1;
(statearr_26044_26201[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (80))){
var inst_25532 = (state_25865[(10)]);
var inst_25530 = (state_25865[(11)]);
var inst_25531 = (state_25865[(12)]);
var inst_25653 = (state_25865[(13)]);
var inst_25692 = (state_25865[(14)]);
var inst_25685 = (state_25865[(15)]);
var inst_25684 = (state_25865[(16)]);
var inst_25584 = (state_25865[(17)]);
var inst_25658 = (state_25865[(18)]);
var inst_25663 = (state_25865[(19)]);
var inst_25542 = (state_25865[(20)]);
var inst_25587 = (state_25865[(21)]);
var inst_25712 = (state_25865[(86)]);
var inst_25643 = (state_25865[(22)]);
var inst_25520 = (state_25865[(23)]);
var inst_25686 = (state_25865[(24)]);
var inst_25551 = (state_25865[(25)]);
var inst_25673 = (state_25865[(8)]);
var inst_25526 = (state_25865[(26)]);
var inst_25664 = (state_25865[(27)]);
var inst_25679 = (state_25865[(9)]);
var inst_25652 = (state_25865[(28)]);
var inst_25632 = (state_25865[(29)]);
var inst_25669 = (state_25865[(30)]);
var inst_25605 = (state_25865[(31)]);
var inst_25642 = (state_25865[(32)]);
var inst_25519 = (state_25865[(33)]);
var inst_25646 = (state_25865[(34)]);
var inst_25522 = (state_25865[(35)]);
var inst_25645 = (state_25865[(36)]);
var inst_25614 = (state_25865[(37)]);
var inst_25659 = (state_25865[(38)]);
var inst_25623 = (state_25865[(39)]);
var inst_25515 = (state_25865[(40)]);
var inst_25641 = (state_25865[(42)]);
var inst_25654 = (state_25865[(43)]);
var inst_25583 = (state_25865[(44)]);
var inst_25596 = (state_25865[(45)]);
var inst_25682 = (state_25865[(46)]);
var inst_25527 = (state_25865[(47)]);
var inst_25683 = (state_25865[(48)]);
var inst_25714 = (function (){var no_filter_QMARK_ = inst_25679;
var G__25693 = inst_25712;
var t = inst_25659;
var max_limit_QMARK_ = inst_25653;
var next_node = inst_25682;
var fast_forward_db_QMARK_ = inst_25664;
var s1 = inst_25542;
var o2 = inst_25605;
var t1 = inst_25519;
var predicate_fn = inst_25532;
var i = inst_25684;
var m1 = inst_25632;
var root_node = inst_25669;
var map__25514 = inst_25645;
var s2 = inst_25551;
var p2 = inst_25623;
var permissions = inst_25654;
var vec__25501 = inst_25515;
var limit = inst_25652;
var start_flake = inst_25642;
var flake_limit = inst_25646;
var offset = inst_25683;
var map__25507 = inst_25530;
var acc = inst_25686;
var t2 = inst_25526;
var op1 = inst_25520;
var o1 = inst_25596;
var end_flake = inst_25643;
var base_result = inst_25692;
var vec__25508 = inst_25583;
var s = inst_25685;
var node_start = inst_25673;
var p1 = inst_25614;
var subject_fn = inst_25531;
var vec__25504 = inst_25522;
var object_fn = inst_25587;
var idx_compare = inst_25658;
var op2 = inst_25527;
var m2 = inst_25641;
var vec__25511 = inst_25584;
var novelty = inst_25663;
return (function (p1__25485_SHARP_){
return object_fn.call(null,p1__25485_SHARP_.o);
});
})();
var inst_25715 = cljs.core.filter.call(null,inst_25714,inst_25712);
var state_25865__$1 = state_25865;
var statearr_26045_26202 = state_25865__$1;
(statearr_26045_26202[(2)] = inst_25715);

(statearr_26045_26202[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (37))){
var state_25865__$1 = state_25865;
var statearr_26046_26203 = state_25865__$1;
(statearr_26046_26203[(2)] = (-1));

(statearr_26046_26203[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (63))){
var inst_25542 = (state_25865[(20)]);
var inst_25551 = (state_25865[(25)]);
var inst_25614 = (state_25865[(37)]);
var inst_25623 = (state_25865[(39)]);
var inst_25654 = (state_25865[(43)]);
var inst_25676 = fluree.db.permissions_validate.no_filter_QMARK_.call(null,inst_25654,inst_25542,inst_25551,inst_25614,inst_25623);
var state_25865__$1 = state_25865;
var statearr_26047_26204 = state_25865__$1;
(statearr_26047_26204[(2)] = inst_25676);

(statearr_26047_26204[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (94))){
var inst_25815 = (state_25865[(2)]);
var state_25865__$1 = state_25865;
var statearr_26048_26205 = state_25865__$1;
(statearr_26048_26205[(2)] = inst_25815);

(statearr_26048_26205[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (8))){
var inst_25523 = (state_25865[(84)]);
var inst_25542 = (state_25865[(2)]);
var inst_25543 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_25523);
var state_25865__$1 = (function (){var statearr_26049 = state_25865;
(statearr_26049[(20)] = inst_25542);

return statearr_26049;
})();
if(inst_25543){
var statearr_26050_26206 = state_25865__$1;
(statearr_26050_26206[(1)] = (10));

} else {
var statearr_26051_26207 = state_25865__$1;
(statearr_26051_26207[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (49))){
var state_25865__$1 = state_25865;
var statearr_26052_26208 = state_25865__$1;
(statearr_26052_26208[(2)] = fluree.db.util.core.min_integer);

(statearr_26052_26208[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25866 === (84))){
var inst_25653 = (state_25865[(13)]);
var state_25865__$1 = state_25865;
var statearr_26053_26209 = state_25865__$1;
(statearr_26053_26209[(2)] = inst_25653);

(statearr_26053_26209[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__10945__auto__ = null;
var fluree$db$query$range$state_machine__10945__auto____0 = (function (){
var statearr_26054 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26054[(0)] = fluree$db$query$range$state_machine__10945__auto__);

(statearr_26054[(1)] = (1));

return statearr_26054;
});
var fluree$db$query$range$state_machine__10945__auto____1 = (function (state_25865){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_25865);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e26055){var ex__10948__auto__ = e26055;
var statearr_26056_26210 = state_25865;
(statearr_26056_26210[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_25865[(4)]))){
var statearr_26057_26211 = state_25865;
(statearr_26057_26211[(1)] = cljs.core.first.call(null,(state_25865[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26212 = state_25865;
state_25865 = G__26212;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__10945__auto__ = function(state_25865){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__10945__auto____1.call(this,state_25865);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__10945__auto____0;
fluree$db$query$range$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__10945__auto____1;
return fluree$db$query$range$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_26058 = f__11019__auto__.call(null);
(statearr_26058[(6)] = c__11018__auto__);

return statearr_26058;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_.call(null,o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find.call(null,/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id.call(null,(3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id.call(null,(3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_26268){
var state_val_26269 = (state_26268[(1)]);
if((state_val_26269 === (7))){
var inst_26232 = (state_26268[(7)]);
var inst_26242 = (state_26268[(8)]);
var inst_26240 = fluree.db.flake.Flake__GT_parts.call(null,inst_26232);
var inst_26241 = cljs.core.nth.call(null,inst_26240,(0),null);
var inst_26242__$1 = cljs.core.nth.call(null,inst_26240,(1),null);
var inst_26243 = cljs.core.nth.call(null,inst_26240,(2),null);
var inst_26244 = cljs.core.nth.call(null,inst_26240,(3),null);
var inst_26245 = cljs.core.nth.call(null,inst_26240,(4),null);
var inst_26246 = cljs.core.nth.call(null,inst_26240,(5),null);
var inst_26247 = fluree.db.dbproto._tag.call(null,db,inst_26243,inst_26242__$1);
var state_26268__$1 = (function (){var statearr_26270 = state_26268;
(statearr_26270[(9)] = inst_26245);

(statearr_26270[(10)] = inst_26244);

(statearr_26270[(11)] = inst_26246);

(statearr_26270[(8)] = inst_26242__$1);

(statearr_26270[(12)] = inst_26241);

return statearr_26270;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26268__$1,(10),inst_26247);
} else {
if((state_val_26269 === (1))){
var inst_26220 = flakes;
var inst_26221 = cljs.core.seq.call(null,inst_26220);
var inst_26222 = cljs.core.first.call(null,inst_26221);
var inst_26223 = cljs.core.next.call(null,inst_26221);
var inst_26224 = cljs.core.PersistentVector.EMPTY;
var inst_26225 = inst_26220;
var inst_26226 = inst_26224;
var state_26268__$1 = (function (){var statearr_26271 = state_26268;
(statearr_26271[(13)] = inst_26223);

(statearr_26271[(14)] = inst_26225);

(statearr_26271[(15)] = inst_26222);

(statearr_26271[(16)] = inst_26226);

return statearr_26271;
})();
var statearr_26272_26290 = state_26268__$1;
(statearr_26272_26290[(2)] = null);

(statearr_26272_26290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26269 === (4))){
var inst_26232 = (state_26268[(7)]);
var inst_26235 = fluree.db.query.range.is_tag_flake_QMARK_.call(null,inst_26232);
var state_26268__$1 = state_26268;
if(inst_26235){
var statearr_26273_26291 = state_26268__$1;
(statearr_26273_26291[(1)] = (7));

} else {
var statearr_26274_26292 = state_26268__$1;
(statearr_26274_26292[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26269 === (6))){
var inst_26264 = (state_26268[(2)]);
var state_26268__$1 = state_26268;
var statearr_26275_26293 = state_26268__$1;
(statearr_26275_26293[(2)] = inst_26264);

(statearr_26275_26293[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26269 === (3))){
var inst_26266 = (state_26268[(2)]);
var state_26268__$1 = state_26268;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26268__$1,inst_26266);
} else {
if((state_val_26269 === (2))){
var inst_26225 = (state_26268[(14)]);
var inst_26232 = (state_26268[(7)]);
var inst_26231 = cljs.core.seq.call(null,inst_26225);
var inst_26232__$1 = cljs.core.first.call(null,inst_26231);
var inst_26233 = cljs.core.next.call(null,inst_26231);
var state_26268__$1 = (function (){var statearr_26276 = state_26268;
(statearr_26276[(7)] = inst_26232__$1);

(statearr_26276[(17)] = inst_26233);

return statearr_26276;
})();
if(cljs.core.truth_(inst_26232__$1)){
var statearr_26277_26294 = state_26268__$1;
(statearr_26277_26294[(1)] = (4));

} else {
var statearr_26278_26295 = state_26268__$1;
(statearr_26278_26295[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26269 === (9))){
var inst_26261 = (state_26268[(2)]);
var state_26268__$1 = state_26268;
var statearr_26279_26296 = state_26268__$1;
(statearr_26279_26296[(2)] = inst_26261);

(statearr_26279_26296[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26269 === (5))){
var inst_26226 = (state_26268[(16)]);
var state_26268__$1 = state_26268;
var statearr_26280_26297 = state_26268__$1;
(statearr_26280_26297[(2)] = inst_26226);

(statearr_26280_26297[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26269 === (10))){
var inst_26245 = (state_26268[(9)]);
var inst_26244 = (state_26268[(10)]);
var inst_26246 = (state_26268[(11)]);
var inst_26242 = (state_26268[(8)]);
var inst_26241 = (state_26268[(12)]);
var inst_26226 = (state_26268[(16)]);
var inst_26233 = (state_26268[(17)]);
var inst_26249 = (state_26268[(2)]);
var inst_26250 = fluree.db.util.async.throw_err.call(null,inst_26249);
var inst_26251 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26252 = [inst_26241,inst_26242,inst_26250,inst_26244,inst_26245,inst_26246];
var inst_26253 = (new cljs.core.PersistentVector(null,6,(5),inst_26251,inst_26252,null));
var inst_26254 = fluree.db.flake.parts__GT_Flake.call(null,inst_26253);
var inst_26255 = cljs.core.conj.call(null,inst_26226,inst_26254);
var inst_26225 = inst_26233;
var inst_26226__$1 = inst_26255;
var state_26268__$1 = (function (){var statearr_26281 = state_26268;
(statearr_26281[(14)] = inst_26225);

(statearr_26281[(16)] = inst_26226__$1);

return statearr_26281;
})();
var statearr_26282_26298 = state_26268__$1;
(statearr_26282_26298[(2)] = null);

(statearr_26282_26298[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26269 === (8))){
var inst_26232 = (state_26268[(7)]);
var inst_26226 = (state_26268[(16)]);
var inst_26233 = (state_26268[(17)]);
var inst_26258 = cljs.core.conj.call(null,inst_26226,inst_26232);
var inst_26225 = inst_26233;
var inst_26226__$1 = inst_26258;
var state_26268__$1 = (function (){var statearr_26283 = state_26268;
(statearr_26283[(14)] = inst_26225);

(statearr_26283[(16)] = inst_26226__$1);

return statearr_26283;
})();
var statearr_26284_26299 = state_26268__$1;
(statearr_26284_26299[(2)] = null);

(statearr_26284_26299[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__10945__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__10945__auto____0 = (function (){
var statearr_26285 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26285[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__10945__auto__);

(statearr_26285[(1)] = (1));

return statearr_26285;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__10945__auto____1 = (function (state_26268){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_26268);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e26286){var ex__10948__auto__ = e26286;
var statearr_26287_26300 = state_26268;
(statearr_26287_26300[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_26268[(4)]))){
var statearr_26288_26301 = state_26268;
(statearr_26288_26301[(1)] = cljs.core.first.call(null,(state_26268[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26302 = state_26268;
state_26268 = G__26302;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__10945__auto__ = function(state_26268){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__10945__auto____1.call(this,state_26268);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__10945__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__10945__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_26289 = f__11019__auto__.call(null);
(statearr_26289[(6)] = c__11018__auto__);

return statearr_26289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__26304 = arguments.length;
switch (G__26304) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.call(null,db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_26474){
var state_val_26475 = (state_26474[(1)]);
if((state_val_26475 === (65))){
var state_26474__$1 = state_26474;
var statearr_26476_26576 = state_26474__$1;
(statearr_26476_26576[(2)] = null);

(statearr_26476_26576[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (70))){
var inst_26469 = (state_26474[(2)]);
var _ = (function (){var statearr_26477 = state_26474;
(statearr_26477[(4)] = cljs.core.rest.call(null,(state_26474[(4)])));

return statearr_26477;
})();
var state_26474__$1 = state_26474;
var statearr_26478_26577 = state_26474__$1;
(statearr_26478_26577[(2)] = inst_26469);

(statearr_26478_26577[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (62))){
var inst_26455 = (state_26474[(2)]);
var state_26474__$1 = state_26474;
var statearr_26479_26578 = state_26474__$1;
(statearr_26479_26578[(2)] = inst_26455);

(statearr_26479_26578[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (7))){
var state_26474__$1 = state_26474;
var statearr_26480_26579 = state_26474__$1;
(statearr_26480_26579[(2)] = false);

(statearr_26480_26579[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (59))){
var inst_26429 = (state_26474[(2)]);
var inst_26430 = fluree.db.util.async.throw_err.call(null,inst_26429);
var state_26474__$1 = state_26474;
var statearr_26481_26580 = state_26474__$1;
(statearr_26481_26580[(2)] = inst_26430);

(statearr_26481_26580[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (20))){
var state_26474__$1 = state_26474;
var statearr_26482_26581 = state_26474__$1;
(statearr_26482_26581[(2)] = null);

(statearr_26482_26581[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (58))){
var inst_26419 = (state_26474[(2)]);
var inst_26420 = fluree.db.util.async.throw_err.call(null,inst_26419);
var inst_26421 = cljs.core.take.call(null,(1),inst_26420);
var state_26474__$1 = state_26474;
var statearr_26483_26582 = state_26474__$1;
(statearr_26483_26582[(2)] = inst_26421);

(statearr_26483_26582[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (60))){
var inst_26315 = (state_26474[(7)]);
var inst_26318 = (state_26474[(8)]);
var inst_26316 = (state_26474[(9)]);
var inst_26355 = (state_26474[(10)]);
var inst_26435 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26436 = [inst_26316,inst_26315,inst_26355,inst_26318];
var inst_26437 = (new cljs.core.PersistentVector(null,4,(5),inst_26435,inst_26436,null));
var inst_26438 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_26437,opts);
var state_26474__$1 = state_26474;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26474__$1,(63),inst_26438);
} else {
if((state_val_26475 === (27))){
var inst_26366 = (state_26474[(11)]);
var inst_26355 = (state_26474[(10)]);
var inst_26366__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_.call(null,inst_26355);
var state_26474__$1 = (function (){var statearr_26484 = state_26474;
(statearr_26484[(11)] = inst_26366__$1);

return statearr_26484;
})();
if(inst_26366__$1){
var statearr_26485_26583 = state_26474__$1;
(statearr_26485_26583[(1)] = (30));

} else {
var statearr_26486_26584 = state_26474__$1;
(statearr_26486_26584[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (1))){
var state_26474__$1 = state_26474;
var statearr_26487_26585 = state_26474__$1;
(statearr_26487_26585[(2)] = null);

(statearr_26487_26585[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (69))){
var inst_26461 = (state_26474[(12)]);
var state_26474__$1 = state_26474;
var statearr_26488_26586 = state_26474__$1;
(statearr_26488_26586[(2)] = inst_26461);

(statearr_26488_26586[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (24))){
var inst_26316 = (state_26474[(9)]);
var state_26474__$1 = state_26474;
if(cljs.core.truth_(inst_26316)){
var statearr_26489_26587 = state_26474__$1;
(statearr_26489_26587[(1)] = (27));

} else {
var statearr_26490_26588 = state_26474__$1;
(statearr_26490_26588[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (55))){
var inst_26355 = (state_26474[(10)]);
var inst_26413 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26414 = [inst_26355];
var inst_26415 = (new cljs.core.PersistentVector(null,1,(5),inst_26413,inst_26414,null));
var inst_26416 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_26417 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26415,inst_26416);
var state_26474__$1 = state_26474;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26474__$1,(58),inst_26417);
} else {
if((state_val_26475 === (39))){
var inst_26386 = (state_26474[(2)]);
var inst_26387 = fluree.db.util.async.throw_err.call(null,inst_26386);
var state_26474__$1 = state_26474;
var statearr_26491_26589 = state_26474__$1;
(statearr_26491_26589[(2)] = inst_26387);

(statearr_26491_26589[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (46))){
var inst_26399 = (state_26474[(13)]);
var inst_26399__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_26474__$1 = (function (){var statearr_26492 = state_26474;
(statearr_26492[(13)] = inst_26399__$1);

return statearr_26492;
})();
if(cljs.core.truth_(inst_26399__$1)){
var statearr_26493_26590 = state_26474__$1;
(statearr_26493_26590[(1)] = (49));

} else {
var statearr_26494_26591 = state_26474__$1;
(statearr_26494_26591[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (4))){
var inst_26305 = (state_26474[(2)]);
var state_26474__$1 = state_26474;
var statearr_26495_26592 = state_26474__$1;
(statearr_26495_26592[(2)] = inst_26305);

(statearr_26495_26592[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (54))){
var inst_26411 = (state_26474[(2)]);
var state_26474__$1 = state_26474;
if(cljs.core.truth_(inst_26411)){
var statearr_26496_26593 = state_26474__$1;
(statearr_26496_26593[(1)] = (55));

} else {
var statearr_26497_26594 = state_26474__$1;
(statearr_26497_26594[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (15))){
var inst_26317 = (state_26474[(14)]);
var inst_26336 = fluree.db.dbproto._tag_id.call(null,db,inst_26317);
var state_26474__$1 = state_26474;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26474__$1,(18),inst_26336);
} else {
if((state_val_26475 === (48))){
var inst_26457 = (state_26474[(2)]);
var state_26474__$1 = state_26474;
var statearr_26498_26595 = state_26474__$1;
(statearr_26498_26595[(2)] = inst_26457);

(statearr_26498_26595[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (50))){
var inst_26314 = (state_26474[(15)]);
var inst_26315 = (state_26474[(7)]);
var inst_26318 = (state_26474[(8)]);
var inst_26319 = (state_26474[(16)]);
var inst_26316 = (state_26474[(9)]);
var inst_26399 = (state_26474[(13)]);
var inst_26330 = (state_26474[(17)]);
var inst_26325 = (state_26474[(18)]);
var inst_26355 = (state_26474[(10)]);
var inst_26403 = (function (){var t = inst_26318;
var temp__5802__auto__ = inst_26399;
var p = inst_26316;
var idx_predicate_QMARK_ = inst_26319;
var vec__26311 = inst_26314;
var o = inst_26355;
var tag_predicate_QMARK_ = inst_26325;
var s = inst_26315;
var o_coerce_QMARK_ = inst_26330;
return (function (x){
return cljs.core._EQ_.call(null,x,o);
});
})();
var state_26474__$1 = state_26474;
var statearr_26499_26596 = state_26474__$1;
(statearr_26499_26596[(2)] = inst_26403);

(statearr_26499_26596[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (21))){
var inst_26351 = (state_26474[(2)]);
var state_26474__$1 = state_26474;
var statearr_26500_26597 = state_26474__$1;
(statearr_26500_26597[(2)] = inst_26351);

(statearr_26500_26597[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (31))){
var inst_26366 = (state_26474[(11)]);
var state_26474__$1 = state_26474;
var statearr_26501_26598 = state_26474__$1;
(statearr_26501_26598[(2)] = inst_26366);

(statearr_26501_26598[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (32))){
var inst_26376 = (state_26474[(2)]);
var state_26474__$1 = state_26474;
var statearr_26502_26599 = state_26474__$1;
(statearr_26502_26599[(2)] = inst_26376);

(statearr_26502_26599[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (40))){
var inst_26390 = (state_26474[(19)]);
var inst_26319 = (state_26474[(16)]);
var inst_26390__$1 = cljs.core.not.call(null,inst_26319);
var state_26474__$1 = (function (){var statearr_26503 = state_26474;
(statearr_26503[(19)] = inst_26390__$1);

return statearr_26503;
})();
if(inst_26390__$1){
var statearr_26504_26600 = state_26474__$1;
(statearr_26504_26600[(1)] = (43));

} else {
var statearr_26505_26601 = state_26474__$1;
(statearr_26505_26601[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (56))){
var inst_26315 = (state_26474[(7)]);
var inst_26318 = (state_26474[(8)]);
var inst_26316 = (state_26474[(9)]);
var inst_26405 = (state_26474[(20)]);
var inst_26423 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26424 = [inst_26316,inst_26315,null,inst_26318];
var inst_26425 = (new cljs.core.PersistentVector(null,4,(5),inst_26423,inst_26424,null));
var inst_26426 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_26405);
var inst_26427 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_26425,inst_26426);
var state_26474__$1 = state_26474;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26474__$1,(59),inst_26427);
} else {
if((state_val_26475 === (33))){
var inst_26355 = (state_26474[(10)]);
var inst_26369 = cljs.core.fn_QMARK_.call(null,inst_26355);
var inst_26370 = (!(inst_26369));
var state_26474__$1 = state_26474;
var statearr_26506_26602 = state_26474__$1;
(statearr_26506_26602[(2)] = inst_26370);

(statearr_26506_26602[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (13))){
var inst_26317 = (state_26474[(14)]);
var inst_26334 = fluree.db.query.range.tag_string_QMARK_.call(null,inst_26317);
var state_26474__$1 = state_26474;
if(cljs.core.truth_(inst_26334)){
var statearr_26507_26603 = state_26474__$1;
(statearr_26507_26603[(1)] = (15));

} else {
var statearr_26508_26604 = state_26474__$1;
(statearr_26508_26604[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (22))){
var inst_26347 = (state_26474[(2)]);
var inst_26348 = fluree.db.util.async.throw_err.call(null,inst_26347);
var state_26474__$1 = state_26474;
var statearr_26509_26605 = state_26474__$1;
(statearr_26509_26605[(2)] = inst_26348);

(statearr_26509_26605[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (36))){
var inst_26315 = (state_26474[(7)]);
var inst_26318 = (state_26474[(8)]);
var inst_26316 = (state_26474[(9)]);
var inst_26355 = (state_26474[(10)]);
var inst_26381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26382 = [inst_26316,inst_26355,inst_26315,inst_26318];
var inst_26383 = (new cljs.core.PersistentVector(null,4,(5),inst_26381,inst_26382,null));
var inst_26384 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26383,opts);
var state_26474__$1 = state_26474;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26474__$1,(39),inst_26384);
} else {
if((state_val_26475 === (41))){
var inst_26316 = (state_26474[(9)]);
var state_26474__$1 = state_26474;
var statearr_26510_26606 = state_26474__$1;
(statearr_26510_26606[(2)] = inst_26316);

(statearr_26510_26606[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (43))){
var inst_26355 = (state_26474[(10)]);
var state_26474__$1 = state_26474;
var statearr_26511_26607 = state_26474__$1;
(statearr_26511_26607[(2)] = inst_26355);

(statearr_26511_26607[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (61))){
var inst_26355 = (state_26474[(10)]);
var state_26474__$1 = state_26474;
if(cljs.core.truth_(inst_26355)){
var statearr_26512_26608 = state_26474__$1;
(statearr_26512_26608[(1)] = (64));

} else {
var statearr_26513_26609 = state_26474__$1;
(statearr_26513_26609[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (29))){
var inst_26379 = (state_26474[(2)]);
var state_26474__$1 = state_26474;
if(cljs.core.truth_(inst_26379)){
var statearr_26514_26610 = state_26474__$1;
(statearr_26514_26610[(1)] = (36));

} else {
var statearr_26515_26611 = state_26474__$1;
(statearr_26515_26611[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (44))){
var inst_26390 = (state_26474[(19)]);
var state_26474__$1 = state_26474;
var statearr_26516_26612 = state_26474__$1;
(statearr_26516_26612[(2)] = inst_26390);

(statearr_26516_26612[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (6))){
var inst_26316 = (state_26474[(9)]);
var inst_26321 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),inst_26316);
var inst_26322 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_26321);
var state_26474__$1 = state_26474;
var statearr_26517_26613 = state_26474__$1;
(statearr_26517_26613[(2)] = inst_26322);

(statearr_26517_26613[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (28))){
var inst_26316 = (state_26474[(9)]);
var state_26474__$1 = state_26474;
var statearr_26518_26614 = state_26474__$1;
(statearr_26518_26614[(2)] = inst_26316);

(statearr_26518_26614[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (64))){
var inst_26315 = (state_26474[(7)]);
var inst_26318 = (state_26474[(8)]);
var inst_26316 = (state_26474[(9)]);
var inst_26355 = (state_26474[(10)]);
var inst_26444 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26445 = [inst_26355,inst_26316,inst_26315,inst_26318];
var inst_26446 = (new cljs.core.PersistentVector(null,4,(5),inst_26444,inst_26445,null));
var inst_26447 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_26446,opts);
var state_26474__$1 = state_26474;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26474__$1,(67),inst_26447);
} else {
if((state_val_26475 === (51))){
var inst_26406 = (state_26474[(21)]);
var inst_26316 = (state_26474[(9)]);
var inst_26405 = (state_26474[(2)]);
var inst_26406__$1 = cljs.core._EQ_.call(null,"_id",inst_26316);
var state_26474__$1 = (function (){var statearr_26519 = state_26474;
(statearr_26519[(21)] = inst_26406__$1);

(statearr_26519[(20)] = inst_26405);

return statearr_26519;
})();
if(inst_26406__$1){
var statearr_26520_26615 = state_26474__$1;
(statearr_26520_26615[(1)] = (52));

} else {
var statearr_26521_26616 = state_26474__$1;
(statearr_26521_26616[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (25))){
var inst_26325 = (state_26474[(18)]);
var inst_26461 = (state_26474[(2)]);
var state_26474__$1 = (function (){var statearr_26522 = state_26474;
(statearr_26522[(12)] = inst_26461);

return statearr_26522;
})();
if(cljs.core.truth_(inst_26325)){
var statearr_26523_26617 = state_26474__$1;
(statearr_26523_26617[(1)] = (68));

} else {
var statearr_26524_26618 = state_26474__$1;
(statearr_26524_26618[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (34))){
var inst_26319 = (state_26474[(16)]);
var state_26474__$1 = state_26474;
var statearr_26525_26619 = state_26474__$1;
(statearr_26525_26619[(2)] = inst_26319);

(statearr_26525_26619[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (17))){
var inst_26353 = (state_26474[(2)]);
var state_26474__$1 = state_26474;
var statearr_26526_26620 = state_26474__$1;
(statearr_26526_26620[(2)] = inst_26353);

(statearr_26526_26620[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (3))){
var inst_26472 = (state_26474[(2)]);
var state_26474__$1 = state_26474;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26474__$1,inst_26472);
} else {
if((state_val_26475 === (12))){
var inst_26317 = (state_26474[(14)]);
var state_26474__$1 = state_26474;
var statearr_26527_26621 = state_26474__$1;
(statearr_26527_26621[(2)] = inst_26317);

(statearr_26527_26621[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (2))){
var inst_26314 = (state_26474[(15)]);
var inst_26316 = (state_26474[(9)]);
var _ = (function (){var statearr_26528 = state_26474;
(statearr_26528[(4)] = cljs.core.cons.call(null,(5),(state_26474[(4)])));

return statearr_26528;
})();
var inst_26314__$1 = fparts;
var inst_26315 = cljs.core.nth.call(null,inst_26314__$1,(0),null);
var inst_26316__$1 = cljs.core.nth.call(null,inst_26314__$1,(1),null);
var inst_26317 = cljs.core.nth.call(null,inst_26314__$1,(2),null);
var inst_26318 = cljs.core.nth.call(null,inst_26314__$1,(3),null);
var inst_26319 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_26316__$1);
var state_26474__$1 = (function (){var statearr_26529 = state_26474;
(statearr_26529[(15)] = inst_26314__$1);

(statearr_26529[(7)] = inst_26315);

(statearr_26529[(8)] = inst_26318);

(statearr_26529[(16)] = inst_26319);

(statearr_26529[(9)] = inst_26316__$1);

(statearr_26529[(14)] = inst_26317);

return statearr_26529;
})();
if(cljs.core.truth_(inst_26316__$1)){
var statearr_26530_26622 = state_26474__$1;
(statearr_26530_26622[(1)] = (6));

} else {
var statearr_26531_26623 = state_26474__$1;
(statearr_26531_26623[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (66))){
var inst_26453 = (state_26474[(2)]);
var state_26474__$1 = state_26474;
var statearr_26532_26624 = state_26474__$1;
(statearr_26532_26624[(2)] = inst_26453);

(statearr_26532_26624[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (23))){
var inst_26315 = (state_26474[(7)]);
var inst_26318 = (state_26474[(8)]);
var inst_26316 = (state_26474[(9)]);
var inst_26355 = (state_26474[(10)]);
var inst_26357 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26358 = [inst_26315,inst_26316,inst_26355,inst_26318];
var inst_26359 = (new cljs.core.PersistentVector(null,4,(5),inst_26357,inst_26358,null));
var inst_26360 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26359,opts);
var state_26474__$1 = state_26474;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26474__$1,(26),inst_26360);
} else {
if((state_val_26475 === (47))){
var inst_26316 = (state_26474[(9)]);
var state_26474__$1 = state_26474;
if(cljs.core.truth_(inst_26316)){
var statearr_26533_26625 = state_26474__$1;
(statearr_26533_26625[(1)] = (60));

} else {
var statearr_26534_26626 = state_26474__$1;
(statearr_26534_26626[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (35))){
var inst_26373 = (state_26474[(2)]);
var state_26474__$1 = state_26474;
var statearr_26535_26627 = state_26474__$1;
(statearr_26535_26627[(2)] = inst_26373);

(statearr_26535_26627[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (19))){
var inst_26316 = (state_26474[(9)]);
var inst_26317 = (state_26474[(14)]);
var inst_26343 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_26316);
var inst_26344 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26343),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26317)].join('');
var inst_26345 = fluree.db.dbproto._tag_id.call(null,db,inst_26344);
var state_26474__$1 = state_26474;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26474__$1,(22),inst_26345);
} else {
if((state_val_26475 === (57))){
var inst_26432 = (state_26474[(2)]);
var state_26474__$1 = state_26474;
var statearr_26536_26628 = state_26474__$1;
(statearr_26536_26628[(2)] = inst_26432);

(statearr_26536_26628[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (68))){
var inst_26461 = (state_26474[(12)]);
var inst_26463 = fluree.db.query.range.coerce_tag_flakes.call(null,db,inst_26461);
var state_26474__$1 = state_26474;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26474__$1,(71),inst_26463);
} else {
if((state_val_26475 === (11))){
var inst_26330 = (state_26474[(17)]);
var inst_26330__$1 = (state_26474[(2)]);
var inst_26331 = cljs.core.not.call(null,inst_26330__$1);
var state_26474__$1 = (function (){var statearr_26538 = state_26474;
(statearr_26538[(17)] = inst_26330__$1);

return statearr_26538;
})();
if(inst_26331){
var statearr_26539_26629 = state_26474__$1;
(statearr_26539_26629[(1)] = (12));

} else {
var statearr_26540_26630 = state_26474__$1;
(statearr_26540_26630[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (9))){
var inst_26317 = (state_26474[(14)]);
var inst_26327 = typeof inst_26317 === 'string';
var state_26474__$1 = state_26474;
var statearr_26541_26631 = state_26474__$1;
(statearr_26541_26631[(2)] = inst_26327);

(statearr_26541_26631[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (5))){
var _ = (function (){var statearr_26542 = state_26474;
(statearr_26542[(4)] = cljs.core.rest.call(null,(state_26474[(4)])));

return statearr_26542;
})();
var state_26474__$1 = state_26474;
var ex26537 = (state_26474__$1[(2)]);
var statearr_26543_26632 = state_26474__$1;
(statearr_26543_26632[(5)] = ex26537);


if((ex26537 instanceof Error)){
var statearr_26544_26633 = state_26474__$1;
(statearr_26544_26633[(1)] = (4));

(statearr_26544_26633[(5)] = null);

} else {
throw ex26537;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (14))){
var inst_26315 = (state_26474[(7)]);
var inst_26355 = (state_26474[(2)]);
var state_26474__$1 = (function (){var statearr_26545 = state_26474;
(statearr_26545[(10)] = inst_26355);

return statearr_26545;
})();
if(cljs.core.truth_(inst_26315)){
var statearr_26546_26634 = state_26474__$1;
(statearr_26546_26634[(1)] = (23));

} else {
var statearr_26547_26635 = state_26474__$1;
(statearr_26547_26635[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (45))){
var inst_26394 = (state_26474[(2)]);
var state_26474__$1 = state_26474;
var statearr_26548_26636 = state_26474__$1;
(statearr_26548_26636[(2)] = inst_26394);

(statearr_26548_26636[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (53))){
var inst_26406 = (state_26474[(21)]);
var state_26474__$1 = state_26474;
var statearr_26549_26637 = state_26474__$1;
(statearr_26549_26637[(2)] = inst_26406);

(statearr_26549_26637[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (26))){
var inst_26362 = (state_26474[(2)]);
var inst_26363 = fluree.db.util.async.throw_err.call(null,inst_26362);
var state_26474__$1 = state_26474;
var statearr_26550_26638 = state_26474__$1;
(statearr_26550_26638[(2)] = inst_26363);

(statearr_26550_26638[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (16))){
var inst_26317 = (state_26474[(14)]);
var inst_26341 = typeof inst_26317 === 'string';
var state_26474__$1 = state_26474;
if(cljs.core.truth_(inst_26341)){
var statearr_26551_26639 = state_26474__$1;
(statearr_26551_26639[(1)] = (19));

} else {
var statearr_26552_26640 = state_26474__$1;
(statearr_26552_26640[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (38))){
var inst_26459 = (state_26474[(2)]);
var state_26474__$1 = state_26474;
var statearr_26553_26641 = state_26474__$1;
(statearr_26553_26641[(2)] = inst_26459);

(statearr_26553_26641[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (30))){
var inst_26319 = (state_26474[(16)]);
var state_26474__$1 = state_26474;
if(cljs.core.truth_(inst_26319)){
var statearr_26554_26642 = state_26474__$1;
(statearr_26554_26642[(1)] = (33));

} else {
var statearr_26555_26643 = state_26474__$1;
(statearr_26555_26643[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (10))){
var inst_26325 = (state_26474[(18)]);
var state_26474__$1 = state_26474;
var statearr_26556_26644 = state_26474__$1;
(statearr_26556_26644[(2)] = inst_26325);

(statearr_26556_26644[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (18))){
var inst_26338 = (state_26474[(2)]);
var inst_26339 = fluree.db.util.async.throw_err.call(null,inst_26338);
var state_26474__$1 = state_26474;
var statearr_26557_26645 = state_26474__$1;
(statearr_26557_26645[(2)] = inst_26339);

(statearr_26557_26645[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (52))){
var inst_26355 = (state_26474[(10)]);
var inst_26408 = cljs.core.int_QMARK_.call(null,inst_26355);
var state_26474__$1 = state_26474;
var statearr_26558_26646 = state_26474__$1;
(statearr_26558_26646[(2)] = inst_26408);

(statearr_26558_26646[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (67))){
var inst_26449 = (state_26474[(2)]);
var inst_26450 = fluree.db.util.async.throw_err.call(null,inst_26449);
var state_26474__$1 = state_26474;
var statearr_26559_26647 = state_26474__$1;
(statearr_26559_26647[(2)] = inst_26450);

(statearr_26559_26647[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (71))){
var inst_26465 = (state_26474[(2)]);
var inst_26466 = fluree.db.util.async.throw_err.call(null,inst_26465);
var state_26474__$1 = state_26474;
var statearr_26560_26648 = state_26474__$1;
(statearr_26560_26648[(2)] = inst_26466);

(statearr_26560_26648[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (42))){
var inst_26397 = (state_26474[(2)]);
var state_26474__$1 = state_26474;
if(cljs.core.truth_(inst_26397)){
var statearr_26561_26649 = state_26474__$1;
(statearr_26561_26649[(1)] = (46));

} else {
var statearr_26562_26650 = state_26474__$1;
(statearr_26562_26650[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (37))){
var inst_26316 = (state_26474[(9)]);
var state_26474__$1 = state_26474;
if(cljs.core.truth_(inst_26316)){
var statearr_26563_26651 = state_26474__$1;
(statearr_26563_26651[(1)] = (40));

} else {
var statearr_26564_26652 = state_26474__$1;
(statearr_26564_26652[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (63))){
var inst_26440 = (state_26474[(2)]);
var inst_26441 = fluree.db.util.async.throw_err.call(null,inst_26440);
var state_26474__$1 = state_26474;
var statearr_26565_26653 = state_26474__$1;
(statearr_26565_26653[(2)] = inst_26441);

(statearr_26565_26653[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (8))){
var inst_26325 = (state_26474[(18)]);
var inst_26325__$1 = (state_26474[(2)]);
var state_26474__$1 = (function (){var statearr_26566 = state_26474;
(statearr_26566[(18)] = inst_26325__$1);

return statearr_26566;
})();
if(cljs.core.truth_(inst_26325__$1)){
var statearr_26567_26654 = state_26474__$1;
(statearr_26567_26654[(1)] = (9));

} else {
var statearr_26568_26655 = state_26474__$1;
(statearr_26568_26655[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26475 === (49))){
var inst_26314 = (state_26474[(15)]);
var inst_26315 = (state_26474[(7)]);
var inst_26318 = (state_26474[(8)]);
var inst_26319 = (state_26474[(16)]);
var inst_26316 = (state_26474[(9)]);
var inst_26399 = (state_26474[(13)]);
var inst_26330 = (state_26474[(17)]);
var inst_26325 = (state_26474[(18)]);
var inst_26355 = (state_26474[(10)]);
var inst_26401 = (function (){var obj_fn = inst_26399;
var t = inst_26318;
var temp__5802__auto__ = inst_26399;
var p = inst_26316;
var idx_predicate_QMARK_ = inst_26319;
var vec__26311 = inst_26314;
var o = inst_26355;
var tag_predicate_QMARK_ = inst_26325;
var s = inst_26315;
var o_coerce_QMARK_ = inst_26330;
return (function (x){
var and__5043__auto__ = obj_fn.call(null,x);
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.call(null,x,o);
} else {
return and__5043__auto__;
}
});
})();
var state_26474__$1 = state_26474;
var statearr_26569_26656 = state_26474__$1;
(statearr_26569_26656[(2)] = inst_26401);

(statearr_26569_26656[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__10945__auto__ = null;
var fluree$db$query$range$state_machine__10945__auto____0 = (function (){
var statearr_26570 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26570[(0)] = fluree$db$query$range$state_machine__10945__auto__);

(statearr_26570[(1)] = (1));

return statearr_26570;
});
var fluree$db$query$range$state_machine__10945__auto____1 = (function (state_26474){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_26474);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e26571){var ex__10948__auto__ = e26571;
var statearr_26572_26657 = state_26474;
(statearr_26572_26657[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_26474[(4)]))){
var statearr_26573_26658 = state_26474;
(statearr_26573_26658[(1)] = cljs.core.first.call(null,(state_26474[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26659 = state_26474;
state_26474 = G__26659;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__10945__auto__ = function(state_26474){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__10945__auto____1.call(this,state_26474);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__10945__auto____0;
fluree$db$query$range$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__10945__auto____1;
return fluree$db$query$range$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_26574 = f__11019__auto__.call(null);
(statearr_26574[(6)] = c__11018__auto__);

return statearr_26574;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__26661 = arguments.length;
switch (G__26661) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.call(null,db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_26696){
var state_val_26697 = (state_26696[(1)]);
if((state_val_26697 === (7))){
var inst_26683 = cljs.core.pr_str.call(null,name);
var inst_26684 = ["Invalid collection name: ",inst_26683].join('');
var inst_26685 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26686 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_26687 = cljs.core.PersistentHashMap.fromArrays(inst_26685,inst_26686);
var inst_26688 = cljs.core.ex_info.call(null,inst_26684,inst_26687);
var inst_26689 = (function(){throw inst_26688})();
var state_26696__$1 = state_26696;
var statearr_26698_26718 = state_26696__$1;
(statearr_26698_26718[(2)] = inst_26689);

(statearr_26698_26718[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26697 === (1))){
var state_26696__$1 = state_26696;
var statearr_26699_26719 = state_26696__$1;
(statearr_26699_26719[(2)] = null);

(statearr_26699_26719[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26697 === (4))){
var inst_26662 = (state_26696[(2)]);
var state_26696__$1 = state_26696;
var statearr_26700_26720 = state_26696__$1;
(statearr_26700_26720[(2)] = inst_26662);

(statearr_26700_26720[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26697 === (6))){
var inst_26668 = (state_26696[(7)]);
var inst_26670 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26671 = fluree.db.flake.max_subject_id.call(null,inst_26668);
var inst_26672 = [inst_26671];
var inst_26673 = (new cljs.core.PersistentVector(null,1,(5),inst_26670,inst_26672,null));
var inst_26674 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26675 = fluree.db.flake.min_subject_id.call(null,inst_26668);
var inst_26676 = [inst_26675];
var inst_26677 = (new cljs.core.PersistentVector(null,1,(5),inst_26674,inst_26676,null));
var inst_26678 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_26673,cljs.core._LT__EQ_,inst_26677,opts);
var state_26696__$1 = state_26696;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26696__$1,(9),inst_26678);
} else {
if((state_val_26697 === (3))){
var inst_26694 = (state_26696[(2)]);
var state_26696__$1 = state_26696;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26696__$1,inst_26694);
} else {
if((state_val_26697 === (2))){
var inst_26668 = (state_26696[(7)]);
var _ = (function (){var statearr_26702 = state_26696;
(statearr_26702[(4)] = cljs.core.cons.call(null,(5),(state_26696[(4)])));

return statearr_26702;
})();
var inst_26668__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"partition","partition",1174740751),name);
var state_26696__$1 = (function (){var statearr_26703 = state_26696;
(statearr_26703[(7)] = inst_26668__$1);

return statearr_26703;
})();
if(cljs.core.truth_(inst_26668__$1)){
var statearr_26704_26721 = state_26696__$1;
(statearr_26704_26721[(1)] = (6));

} else {
var statearr_26705_26722 = state_26696__$1;
(statearr_26705_26722[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26697 === (9))){
var inst_26680 = (state_26696[(2)]);
var inst_26681 = fluree.db.util.async.throw_err.call(null,inst_26680);
var state_26696__$1 = state_26696;
var statearr_26706_26723 = state_26696__$1;
(statearr_26706_26723[(2)] = inst_26681);

(statearr_26706_26723[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26697 === (5))){
var _ = (function (){var statearr_26707 = state_26696;
(statearr_26707[(4)] = cljs.core.rest.call(null,(state_26696[(4)])));

return statearr_26707;
})();
var state_26696__$1 = state_26696;
var ex26701 = (state_26696__$1[(2)]);
var statearr_26708_26724 = state_26696__$1;
(statearr_26708_26724[(5)] = ex26701);


var statearr_26709_26725 = state_26696__$1;
(statearr_26709_26725[(1)] = (4));

(statearr_26709_26725[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26697 === (8))){
var inst_26691 = (state_26696[(2)]);
var _ = (function (){var statearr_26710 = state_26696;
(statearr_26710[(4)] = cljs.core.rest.call(null,(state_26696[(4)])));

return statearr_26710;
})();
var state_26696__$1 = state_26696;
var statearr_26711_26726 = state_26696__$1;
(statearr_26711_26726[(2)] = inst_26691);

(statearr_26711_26726[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__10945__auto__ = null;
var fluree$db$query$range$state_machine__10945__auto____0 = (function (){
var statearr_26712 = [null,null,null,null,null,null,null,null];
(statearr_26712[(0)] = fluree$db$query$range$state_machine__10945__auto__);

(statearr_26712[(1)] = (1));

return statearr_26712;
});
var fluree$db$query$range$state_machine__10945__auto____1 = (function (state_26696){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_26696);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e26713){var ex__10948__auto__ = e26713;
var statearr_26714_26727 = state_26696;
(statearr_26714_26727[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_26696[(4)]))){
var statearr_26715_26728 = state_26696;
(statearr_26715_26728[(1)] = cljs.core.first.call(null,(state_26696[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26729 = state_26696;
state_26696 = G__26729;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__10945__auto__ = function(state_26696){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__10945__auto____1.call(this,state_26696);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__10945__auto____0;
fluree$db$query$range$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__10945__auto____1;
return fluree$db$query$range$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_26716 = f__11019__auto__.call(null);
(statearr_26716[(6)] = c__11018__auto__);

return statearr_26716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__26733 = flakes;
var vec__26734 = G__26733;
var seq__26735 = cljs.core.seq.call(null,vec__26734);
var first__26736 = cljs.core.first.call(null,seq__26735);
var seq__26735__$1 = cljs.core.next.call(null,seq__26735);
var flake_SINGLEQUOTE_ = first__26736;
var r = seq__26735__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__26733__$1 = G__26733;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__26742 = G__26733__$1;
var seq__26743 = cljs.core.seq.call(null,vec__26742);
var first__26744 = cljs.core.first.call(null,seq__26743);
var seq__26743__$1 = cljs.core.next.call(null,seq__26743);
var flake_SINGLEQUOTE___$1 = first__26744;
var r__$1 = seq__26743__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse.call(null,obj);
}catch (e26746){var e = e26746;
return null;
}})();
var map__26745 = cmd_map;
var map__26745__$1 = cljs.core.__destructure_map.call(null,map__26745);
var type = cljs.core.get.call(null,map__26745__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.call(null,map__26745__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.call(null,map__26745__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.call(null,map__26745__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.call(null,map__26745__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__26745__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__26747 = r__$1;
var G__26748 = ((cljs.core._EQ_.call(null,type,"tx"))?cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__26733__$1 = G__26747;
result_STAR___$1 = G__26748;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__26757 = blocks;
var vec__26758 = G__26757;
var seq__26759 = cljs.core.seq.call(null,vec__26758);
var first__26760 = cljs.core.first.call(null,seq__26759);
var seq__26759__$1 = cljs.core.next.call(null,seq__26759);
var block_SINGLEQUOTE_ = first__26760;
var r = seq__26759__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__26757__$1 = G__26757;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__26765 = G__26757__$1;
var seq__26766 = cljs.core.seq.call(null,vec__26765);
var first__26767 = cljs.core.first.call(null,seq__26766);
var seq__26766__$1 = cljs.core.next.call(null,seq__26766);
var block_SINGLEQUOTE___$1 = first__26767;
var r__$1 = seq__26766__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__26768 = block_SINGLEQUOTE___$1;
var map__26768__$1 = cljs.core.__destructure_map.call(null,map__26768);
var block = cljs.core.get.call(null,map__26768__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__26768__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__26768__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some.call(null,((function (G__26757__$1,result_STAR___$1,map__26768,map__26768__$1,block,t,flakes,vec__26765,seq__26766,first__26767,seq__26766__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26757,vec__26758,seq__26759,first__26760,seq__26759__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__26749_SHARP_){
var f = p1__26749_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(2))){
return f.o;
} else {
return null;
}
});})(G__26757__$1,result_STAR___$1,map__26768,map__26768__$1,block,t,flakes,vec__26765,seq__26766,first__26767,seq__26766__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26757,vec__26758,seq__26759,first__26760,seq__26759__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some.call(null,((function (G__26757__$1,result_STAR___$1,map__26768,map__26768__$1,block,t,flakes,prev_hash,vec__26765,seq__26766,first__26767,seq__26766__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26757,vec__26758,seq__26759,first__26760,seq__26759__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__26750_SHARP_){
var f = p1__26750_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(1))){
return f.o;
} else {
return null;
}
});})(G__26757__$1,result_STAR___$1,map__26768,map__26768__$1,block,t,flakes,prev_hash,vec__26765,seq__26766,first__26767,seq__26766__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26757,vec__26758,seq__26759,first__26760,seq__26759__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some.call(null,((function (G__26757__$1,result_STAR___$1,map__26768,map__26768__$1,block,t,flakes,prev_hash,hash,vec__26765,seq__26766,first__26767,seq__26766__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26757,vec__26758,seq__26759,first__26760,seq__26759__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__26751_SHARP_){
var f = p1__26751_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(5))){
return f.o;
} else {
return null;
}
});})(G__26757__$1,result_STAR___$1,map__26768,map__26768__$1,block,t,flakes,prev_hash,hash,vec__26765,seq__26766,first__26767,seq__26766__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26757,vec__26758,seq__26759,first__26760,seq__26759__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some.call(null,((function (G__26757__$1,result_STAR___$1,map__26768,map__26768__$1,block,t,flakes,prev_hash,hash,instant,vec__26765,seq__26766,first__26767,seq__26766__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26757,vec__26758,seq__26759,first__26760,seq__26759__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__26752_SHARP_){
var f = p1__26752_SHARP_;
if(cljs.core._EQ_.call(null,f.p,(7))){
return f.o;
} else {
return null;
}
});})(G__26757__$1,result_STAR___$1,map__26768,map__26768__$1,block,t,flakes,prev_hash,hash,instant,vec__26765,seq__26766,first__26767,seq__26766__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26757,vec__26758,seq__26759,first__26760,seq__26759__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.call(null,((function (G__26757__$1,result_STAR___$1,map__26768,map__26768__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__26765,seq__26766,first__26767,seq__26766__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26757,vec__26758,seq__26759,first__26760,seq__26759__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__26753_SHARP_){
return cljs.core._EQ_.call(null,p1__26753_SHARP_.p,(106));
});})(G__26757__$1,result_STAR___$1,map__26768,map__26768__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__26765,seq__26766,first__26767,seq__26766__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__26757,vec__26758,seq__26759,first__26760,seq__26759__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes.call(null,txn_flakes);
var G__26769 = r__$1;
var G__26770 = cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__26757__$1 = G__26769;
result_STAR___$1 = G__26770;
continue;
}
break;
}
});
