// Compiled by ClojureScript 1.11.57 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.call(null,cljs.core.re_find.call(null,/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_26788){
var state_val_26789 = (state_26788[(1)]);
if((state_val_26789 === (1))){
var state_26788__$1 = state_26788;
var statearr_26790_26804 = state_26788__$1;
(statearr_26790_26804[(2)] = null);

(statearr_26790_26804[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26789 === (2))){
var _ = (function (){var statearr_26791 = state_26788;
(statearr_26791[(4)] = cljs.core.cons.call(null,(5),(state_26788[(4)])));

return statearr_26791;
})();
var inst_26779 = fluree.db.dbproto._tag.call(null,db,type_tag_sid,"_predicate/type");
var state_26788__$1 = state_26788;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26788__$1,(6),inst_26779);
} else {
if((state_val_26789 === (3))){
var inst_26786 = (state_26788[(2)]);
var state_26788__$1 = state_26788;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26788__$1,inst_26786);
} else {
if((state_val_26789 === (4))){
var inst_26773 = (state_26788[(2)]);
var state_26788__$1 = state_26788;
var statearr_26793_26805 = state_26788__$1;
(statearr_26793_26805[(2)] = inst_26773);

(statearr_26793_26805[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26789 === (5))){
var _ = (function (){var statearr_26794 = state_26788;
(statearr_26794[(4)] = cljs.core.rest.call(null,(state_26788[(4)])));

return statearr_26794;
})();
var state_26788__$1 = state_26788;
var ex26792 = (state_26788__$1[(2)]);
var statearr_26795_26806 = state_26788__$1;
(statearr_26795_26806[(5)] = ex26792);


if((ex26792 instanceof Error)){
var statearr_26796_26807 = state_26788__$1;
(statearr_26796_26807[(1)] = (4));

(statearr_26796_26807[(5)] = null);

} else {
throw ex26792;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26789 === (6))){
var inst_26781 = (state_26788[(2)]);
var inst_26782 = fluree.db.util.async.throw_err.call(null,inst_26781);
var inst_26783 = cljs.core.keyword.call(null,inst_26782);
var _ = (function (){var statearr_26797 = state_26788;
(statearr_26797[(4)] = cljs.core.rest.call(null,(state_26788[(4)])));

return statearr_26797;
})();
var state_26788__$1 = state_26788;
var statearr_26798_26808 = state_26788__$1;
(statearr_26798_26808[(2)] = inst_26783);

(statearr_26798_26808[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__10945__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__10945__auto____0 = (function (){
var statearr_26799 = [null,null,null,null,null,null,null];
(statearr_26799[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__10945__auto__);

(statearr_26799[(1)] = (1));

return statearr_26799;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__10945__auto____1 = (function (state_26788){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_26788);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e26800){var ex__10948__auto__ = e26800;
var statearr_26801_26809 = state_26788;
(statearr_26801_26809[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_26788[(4)]))){
var statearr_26802_26810 = state_26788;
(statearr_26802_26810[(1)] = cljs.core.first.call(null,(state_26788[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26811 = state_26788;
state_26788 = G__26811;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__10945__auto__ = function(state_26788){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__10945__auto____1.call(this,state_26788);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__10945__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__10945__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_26803 = f__11019__auto__.call(null);
(statearr_26803[(6)] = c__11018__auto__);

return statearr_26803;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_26843){
var state_val_26844 = (state_26843[(1)]);
if((state_val_26844 === (7))){
var inst_26827 = (state_26843[(7)]);
var inst_26829 = cljs.core.empty_QMARK_.call(null,inst_26827);
var inst_26830 = (!(inst_26829));
var state_26843__$1 = state_26843;
var statearr_26845_26869 = state_26843__$1;
(statearr_26845_26869[(2)] = inst_26830);

(statearr_26845_26869[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26844 === (1))){
var state_26843__$1 = state_26843;
var statearr_26846_26870 = state_26843__$1;
(statearr_26846_26870[(2)] = null);

(statearr_26846_26870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26844 === (4))){
var inst_26813 = (state_26843[(2)]);
var state_26843__$1 = state_26843;
var statearr_26847_26871 = state_26843__$1;
(statearr_26847_26871[(2)] = inst_26813);

(statearr_26847_26871[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26844 === (6))){
var inst_26827 = (state_26843[(7)]);
var inst_26819 = (state_26843[(8)]);
var inst_26825 = (state_26843[(2)]);
var inst_26826 = fluree.db.util.async.throw_err.call(null,inst_26825);
var inst_26827__$1 = cljs.core.map.call(null,inst_26819,inst_26826);
var state_26843__$1 = (function (){var statearr_26848 = state_26843;
(statearr_26848[(7)] = inst_26827__$1);

return statearr_26848;
})();
if(cljs.core.truth_(inst_26827__$1)){
var statearr_26849_26872 = state_26843__$1;
(statearr_26849_26872[(1)] = (7));

} else {
var statearr_26850_26873 = state_26843__$1;
(statearr_26850_26873[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26844 === (3))){
var inst_26841 = (state_26843[(2)]);
var state_26843__$1 = state_26843;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26843__$1,inst_26841);
} else {
if((state_val_26844 === (12))){
var inst_26838 = (state_26843[(2)]);
var _ = (function (){var statearr_26851 = state_26843;
(statearr_26851[(4)] = cljs.core.rest.call(null,(state_26843[(4)])));

return statearr_26851;
})();
var state_26843__$1 = state_26843;
var statearr_26852_26874 = state_26843__$1;
(statearr_26852_26874[(2)] = inst_26838);

(statearr_26852_26874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26844 === (2))){
var _ = (function (){var statearr_26853 = state_26843;
(statearr_26853[(4)] = cljs.core.cons.call(null,(5),(state_26843[(4)])));

return statearr_26853;
})();
var inst_26819 = (function (){return (function (p1__26812_SHARP_){
return p1__26812_SHARP_.o;
});
})();
var inst_26820 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26821 = [pred_id];
var inst_26822 = (new cljs.core.PersistentVector(null,1,(5),inst_26820,inst_26821,null));
var inst_26823 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_26822);
var state_26843__$1 = (function (){var statearr_26854 = state_26843;
(statearr_26854[(8)] = inst_26819);

return statearr_26854;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26843__$1,(6),inst_26823);
} else {
if((state_val_26844 === (11))){
var state_26843__$1 = state_26843;
var statearr_26856_26875 = state_26843__$1;
(statearr_26856_26875[(2)] = true);

(statearr_26856_26875[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26844 === (9))){
var inst_26833 = (state_26843[(2)]);
var state_26843__$1 = state_26843;
if(cljs.core.truth_(inst_26833)){
var statearr_26857_26876 = state_26843__$1;
(statearr_26857_26876[(1)] = (10));

} else {
var statearr_26858_26877 = state_26843__$1;
(statearr_26858_26877[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26844 === (5))){
var _ = (function (){var statearr_26859 = state_26843;
(statearr_26859[(4)] = cljs.core.rest.call(null,(state_26843[(4)])));

return statearr_26859;
})();
var state_26843__$1 = state_26843;
var ex26855 = (state_26843__$1[(2)]);
var statearr_26860_26878 = state_26843__$1;
(statearr_26860_26878[(5)] = ex26855);


if((ex26855 instanceof Error)){
var statearr_26861_26879 = state_26843__$1;
(statearr_26861_26879[(1)] = (4));

(statearr_26861_26879[(5)] = null);

} else {
throw ex26855;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26844 === (10))){
var inst_26827 = (state_26843[(7)]);
var inst_26835 = cljs.core.apply.call(null,cljs.core.distinct_QMARK_,inst_26827);
var state_26843__$1 = state_26843;
var statearr_26862_26880 = state_26843__$1;
(statearr_26862_26880[(2)] = inst_26835);

(statearr_26862_26880[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26844 === (8))){
var inst_26827 = (state_26843[(7)]);
var state_26843__$1 = state_26843;
var statearr_26863_26881 = state_26843__$1;
(statearr_26863_26881[(2)] = inst_26827);

(statearr_26863_26881[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10945__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10945__auto____0 = (function (){
var statearr_26864 = [null,null,null,null,null,null,null,null,null];
(statearr_26864[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10945__auto__);

(statearr_26864[(1)] = (1));

return statearr_26864;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10945__auto____1 = (function (state_26843){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_26843);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e26865){var ex__10948__auto__ = e26865;
var statearr_26866_26882 = state_26843;
(statearr_26866_26882[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_26843[(4)]))){
var statearr_26867_26883 = state_26843;
(statearr_26867_26883[(1)] = cljs.core.first.call(null,(state_26843[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26884 = state_26843;
state_26843 = G__26884;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10945__auto__ = function(state_26843){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10945__auto____1.call(this,state_26843);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10945__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10945__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_26868 = f__11019__auto__.call(null);
(statearr_26868[(6)] = c__11018__auto__);

return statearr_26868;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_26965){
var state_val_26966 = (state_26965[(1)]);
if((state_val_26966 === (7))){
var state_26965__$1 = state_26965;
var statearr_26967_27004 = state_26965__$1;
(statearr_26967_27004[(2)] = flakes);

(statearr_26967_27004[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26966 === (20))){
var inst_26922 = (state_26965[(7)]);
var inst_26955 = (state_26965[(2)]);
var inst_26914 = inst_26922;
var inst_26915 = inst_26955;
var state_26965__$1 = (function (){var statearr_26968 = state_26965;
(statearr_26968[(8)] = inst_26914);

(statearr_26968[(9)] = inst_26915);

return statearr_26968;
})();
var statearr_26969_27005 = state_26965__$1;
(statearr_26969_27005[(2)] = null);

(statearr_26969_27005[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26966 === (1))){
var state_26965__$1 = state_26965;
var statearr_26970_27006 = state_26965__$1;
(statearr_26970_27006[(2)] = null);

(statearr_26970_27006[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26966 === (4))){
var inst_26887 = (state_26965[(2)]);
var state_26965__$1 = state_26965;
var statearr_26971_27007 = state_26965__$1;
(statearr_26971_27007[(2)] = inst_26887);

(statearr_26971_27007[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26966 === (15))){
var inst_26921 = (state_26965[(10)]);
var inst_26939 = inst_26921.o;
var state_26965__$1 = state_26965;
var statearr_26972_27008 = state_26965__$1;
(statearr_26972_27008[(2)] = inst_26939);

(statearr_26972_27008[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26966 === (13))){
var inst_26958 = (state_26965[(2)]);
var state_26965__$1 = state_26965;
var statearr_26973_27009 = state_26965__$1;
(statearr_26973_27009[(2)] = inst_26958);

(statearr_26973_27009[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26966 === (6))){
var inst_26894 = cljs.core.filter.call(null,fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_26965__$1 = state_26965;
var statearr_26974_27010 = state_26965__$1;
(statearr_26974_27010[(2)] = inst_26894);

(statearr_26974_27010[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26966 === (17))){
var inst_26936 = (state_26965[(2)]);
var inst_26937 = fluree.db.util.async.throw_err.call(null,inst_26936);
var state_26965__$1 = state_26965;
var statearr_26975_27011 = state_26965__$1;
(statearr_26975_27011[(2)] = inst_26937);

(statearr_26975_27011[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26966 === (3))){
var inst_26963 = (state_26965[(2)]);
var state_26965__$1 = state_26965;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26965__$1,inst_26963);
} else {
if((state_val_26966 === (12))){
var inst_26928 = (state_26965[(11)]);
var inst_26921 = (state_26965[(10)]);
var inst_26926 = inst_26921.p;
var inst_26927 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_26926);
var inst_26928__$1 = fluree.db.query.schema.pred_name__GT_keyword.call(null,inst_26927);
var inst_26929 = inst_26921.op;
var inst_26930 = inst_26929 === false;
var inst_26931 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348),inst_26928__$1);
var state_26965__$1 = (function (){var statearr_26976 = state_26965;
(statearr_26976[(11)] = inst_26928__$1);

(statearr_26976[(12)] = inst_26930);

return statearr_26976;
})();
if(inst_26931){
var statearr_26977_27012 = state_26965__$1;
(statearr_26977_27012[(1)] = (14));

} else {
var statearr_26978_27013 = state_26965__$1;
(statearr_26978_27013[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26966 === (2))){
var _ = (function (){var statearr_26979 = state_26965;
(statearr_26979[(4)] = cljs.core.cons.call(null,(5),(state_26965[(4)])));

return statearr_26979;
})();
var state_26965__$1 = state_26965;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_26980_27014 = state_26965__$1;
(statearr_26980_27014[(1)] = (6));

} else {
var statearr_26981_27015 = state_26965__$1;
(statearr_26981_27015[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26966 === (19))){
var inst_26928 = (state_26965[(11)]);
var inst_26941 = (state_26965[(13)]);
var inst_26921 = (state_26965[(10)]);
var inst_26915 = (state_26965[(9)]);
var inst_26949 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26950 = inst_26921.s;
var inst_26951 = [inst_26950,inst_26928,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_26952 = (new cljs.core.PersistentVector(null,3,(5),inst_26949,inst_26951,null));
var inst_26953 = cljs.core.assoc_in.call(null,inst_26915,inst_26952,inst_26941);
var state_26965__$1 = state_26965;
var statearr_26982_27016 = state_26965__$1;
(statearr_26982_27016[(2)] = inst_26953);

(statearr_26982_27016[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26966 === (11))){
var inst_26915 = (state_26965[(9)]);
var state_26965__$1 = state_26965;
var statearr_26984_27017 = state_26965__$1;
(statearr_26984_27017[(2)] = inst_26915);

(statearr_26984_27017[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26966 === (9))){
var inst_26914 = (state_26965[(8)]);
var inst_26921 = (state_26965[(10)]);
var inst_26920 = cljs.core.seq.call(null,inst_26914);
var inst_26921__$1 = cljs.core.first.call(null,inst_26920);
var inst_26922 = cljs.core.next.call(null,inst_26920);
var inst_26923 = cljs.core.not.call(null,inst_26921__$1);
var state_26965__$1 = (function (){var statearr_26985 = state_26965;
(statearr_26985[(7)] = inst_26922);

(statearr_26985[(10)] = inst_26921__$1);

return statearr_26985;
})();
if(inst_26923){
var statearr_26986_27018 = state_26965__$1;
(statearr_26986_27018[(1)] = (11));

} else {
var statearr_26987_27019 = state_26965__$1;
(statearr_26987_27019[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26966 === (5))){
var _ = (function (){var statearr_26988 = state_26965;
(statearr_26988[(4)] = cljs.core.rest.call(null,(state_26965[(4)])));

return statearr_26988;
})();
var state_26965__$1 = state_26965;
var ex26983 = (state_26965__$1[(2)]);
var statearr_26989_27020 = state_26965__$1;
(statearr_26989_27020[(5)] = ex26983);


if((ex26983 instanceof Error)){
var statearr_26990_27021 = state_26965__$1;
(statearr_26990_27021[(1)] = (4));

(statearr_26990_27021[(5)] = null);

} else {
throw ex26983;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26966 === (14))){
var inst_26921 = (state_26965[(10)]);
var inst_26933 = inst_26921.o;
var inst_26934 = fluree.db.query.schema.convert_type_to_kw.call(null,inst_26933,db);
var state_26965__$1 = state_26965;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26965__$1,(17),inst_26934);
} else {
if((state_val_26966 === (16))){
var inst_26930 = (state_26965[(12)]);
var inst_26941 = (state_26965[(2)]);
var state_26965__$1 = (function (){var statearr_26991 = state_26965;
(statearr_26991[(13)] = inst_26941);

return statearr_26991;
})();
if(cljs.core.truth_(inst_26930)){
var statearr_26992_27022 = state_26965__$1;
(statearr_26992_27022[(1)] = (18));

} else {
var statearr_26993_27023 = state_26965__$1;
(statearr_26993_27023[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26966 === (10))){
var inst_26960 = (state_26965[(2)]);
var _ = (function (){var statearr_26994 = state_26965;
(statearr_26994[(4)] = cljs.core.rest.call(null,(state_26965[(4)])));

return statearr_26994;
})();
var state_26965__$1 = state_26965;
var statearr_26995_27024 = state_26965__$1;
(statearr_26995_27024[(2)] = inst_26960);

(statearr_26995_27024[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26966 === (18))){
var inst_26928 = (state_26965[(11)]);
var inst_26941 = (state_26965[(13)]);
var inst_26921 = (state_26965[(10)]);
var inst_26915 = (state_26965[(9)]);
var inst_26943 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26944 = inst_26921.s;
var inst_26945 = [inst_26944,inst_26928,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_26946 = (new cljs.core.PersistentVector(null,3,(5),inst_26943,inst_26945,null));
var inst_26947 = cljs.core.assoc_in.call(null,inst_26915,inst_26946,inst_26941);
var state_26965__$1 = state_26965;
var statearr_26996_27025 = state_26965__$1;
(statearr_26996_27025[(2)] = inst_26947);

(statearr_26996_27025[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26966 === (8))){
var inst_26897 = (state_26965[(2)]);
var inst_26898 = cljs.core.PersistentHashSet.EMPTY;
var inst_26899 = cljs.core.vals.call(null,tempids);
var inst_26900 = cljs.core.into.call(null,inst_26898,inst_26899);
var inst_26901 = (function (){var pred_flakes = inst_26897;
var is_new_QMARK_ = inst_26900;
return (function (p1__26886_SHARP_,p2__26885_SHARP_){
var f = p2__26885_SHARP_;
return cljs.core.assoc_in.call(null,p1__26886_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s,new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$.call(null,is_new_QMARK_.call(null,f.s)));
});
})();
var inst_26902 = cljs.core.PersistentHashMap.EMPTY;
var inst_26903 = cljs.core.reduce.call(null,inst_26901,inst_26902,inst_26897);
var inst_26911 = cljs.core.seq.call(null,inst_26897);
var inst_26912 = cljs.core.first.call(null,inst_26911);
var inst_26913 = cljs.core.next.call(null,inst_26911);
var inst_26914 = inst_26897;
var inst_26915 = inst_26903;
var state_26965__$1 = (function (){var statearr_26997 = state_26965;
(statearr_26997[(8)] = inst_26914);

(statearr_26997[(14)] = inst_26912);

(statearr_26997[(15)] = inst_26913);

(statearr_26997[(9)] = inst_26915);

return statearr_26997;
})();
var statearr_26998_27026 = state_26965__$1;
(statearr_26998_27026[(2)] = null);

(statearr_26998_27026[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__10945__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__10945__auto____0 = (function (){
var statearr_26999 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26999[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__10945__auto__);

(statearr_26999[(1)] = (1));

return statearr_26999;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__10945__auto____1 = (function (state_26965){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_26965);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e27000){var ex__10948__auto__ = e27000;
var statearr_27001_27027 = state_26965;
(statearr_27001_27027[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_26965[(4)]))){
var statearr_27002_27028 = state_26965;
(statearr_27002_27028[(1)] = cljs.core.first.call(null,(state_26965[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27029 = state_26965;
state_26965 = G__27029;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__10945__auto__ = function(state_26965){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__10945__auto____1.call(this,state_26965);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__10945__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__10945__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_27003 = f__11019__auto__.call(null);
(statearr_27003[(6)] = c__11018__auto__);

return statearr_27003;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__27031 = arguments.length;
switch (G__27031) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.call(null,null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name.call(null,current_type)," to ",cljs.core.name.call(null,new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__27034 = arguments.length;
switch (G__27034) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.call(null,pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_27346){
var state_val_27347 = (state_27346[(1)]);
if((state_val_27347 === (121))){
var inst_27301 = (state_27346[(7)]);
var state_27346__$1 = state_27346;
var statearr_27348_27541 = state_27346__$1;
(statearr_27348_27541[(2)] = inst_27301);

(statearr_27348_27541[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (65))){
var inst_27200 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
if(cljs.core.truth_(inst_27200)){
var statearr_27349_27542 = state_27346__$1;
(statearr_27349_27542[(1)] = (66));

} else {
var statearr_27350_27543 = state_27346__$1;
(statearr_27350_27543[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (70))){
var inst_27206 = (state_27346[(8)]);
var inst_27205 = (state_27346[(9)]);
var inst_27210 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_27211 = inst_27206.call(null,cljs.core.PersistentArrayMap,null,3,inst_27210,null);
var inst_27212 = inst_27206.call(null,cljs.core.PersistentHashSet,null,inst_27211,null);
var inst_27213 = inst_27212.call(null,inst_27205);
var state_27346__$1 = state_27346;
if(cljs.core.truth_(inst_27213)){
var statearr_27351_27544 = state_27346__$1;
(statearr_27351_27544[(1)] = (72));

} else {
var statearr_27352_27545 = state_27346__$1;
(statearr_27352_27545[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (62))){
var inst_27190 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
var statearr_27353_27546 = state_27346__$1;
(statearr_27353_27546[(2)] = inst_27190);

(statearr_27353_27546[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (74))){
var inst_27296 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
var statearr_27354_27547 = state_27346__$1;
(statearr_27354_27547[(2)] = inst_27296);

(statearr_27354_27547[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (110))){
var inst_27323 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
if(cljs.core.truth_(inst_27323)){
var statearr_27355_27548 = state_27346__$1;
(statearr_27355_27548[(1)] = (117));

} else {
var statearr_27356_27549 = state_27346__$1;
(statearr_27356_27549[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (7))){
var inst_27341 = (state_27346[(2)]);
var _ = (function (){var statearr_27357 = state_27346;
(statearr_27357[(4)] = cljs.core.rest.call(null,(state_27346[(4)])));

return statearr_27357;
})();
var state_27346__$1 = state_27346;
var statearr_27358_27550 = state_27346__$1;
(statearr_27358_27550[(2)] = inst_27341);

(statearr_27358_27550[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (59))){
var inst_27074 = (state_27346[(10)]);
var inst_27194 = (state_27346[(11)]);
var inst_27193 = (state_27346[(2)]);
var inst_27194__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_27074);
var state_27346__$1 = (function (){var statearr_27359 = state_27346;
(statearr_27359[(12)] = inst_27193);

(statearr_27359[(11)] = inst_27194__$1);

return statearr_27359;
})();
if(cljs.core.truth_(inst_27194__$1)){
var statearr_27360_27551 = state_27346__$1;
(statearr_27360_27551[(1)] = (63));

} else {
var statearr_27361_27552 = state_27346__$1;
(statearr_27361_27552[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (86))){
var inst_27236 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
var statearr_27362_27553 = state_27346__$1;
(statearr_27362_27553[(2)] = inst_27236);

(statearr_27362_27553[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (20))){
var inst_27074 = (state_27346[(10)]);
var inst_27100 = (state_27346[(13)]);
var inst_27100__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_27074);
var state_27346__$1 = (function (){var statearr_27363 = state_27346;
(statearr_27363[(13)] = inst_27100__$1);

return statearr_27363;
})();
if(cljs.core.truth_(inst_27100__$1)){
var statearr_27364_27554 = state_27346__$1;
(statearr_27364_27554[(1)] = (23));

} else {
var statearr_27365_27555 = state_27346__$1;
(statearr_27365_27555[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (72))){
var inst_27206 = (state_27346[(8)]);
var inst_27205 = (state_27346[(9)]);
var inst_27215 = fluree.db.query.schema.type_error.call(null,inst_27205,inst_27206,throw_QMARK_);
var state_27346__$1 = state_27346;
var statearr_27366_27556 = state_27346__$1;
(statearr_27366_27556[(2)] = inst_27215);

(statearr_27366_27556[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (58))){
var inst_27155 = (state_27346[(14)]);
var state_27346__$1 = state_27346;
var statearr_27367_27557 = state_27346__$1;
(statearr_27367_27557[(2)] = inst_27155);

(statearr_27367_27557[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (60))){
var inst_27062 = (state_27346[(15)]);
var inst_27073 = (state_27346[(16)]);
var inst_27181 = fluree.db.dbproto._p_prop.call(null,inst_27062,new cljs.core.Keyword(null,"name","name",1843675177),inst_27073);
var inst_27182 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27181)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_27183 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27184 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_27185 = cljs.core.PersistentHashMap.fromArrays(inst_27183,inst_27184);
var inst_27186 = cljs.core.ex_info.call(null,inst_27182,inst_27185);
var inst_27187 = (function(){throw inst_27186})();
var state_27346__$1 = state_27346;
var statearr_27368_27558 = state_27346__$1;
(statearr_27368_27558[(2)] = inst_27187);

(statearr_27368_27558[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (27))){
var inst_27103 = (state_27346[(17)]);
var state_27346__$1 = state_27346;
var statearr_27369_27559 = state_27346__$1;
(statearr_27369_27559[(2)] = inst_27103);

(statearr_27369_27559[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (1))){
var state_27346__$1 = state_27346;
var statearr_27370_27560 = state_27346__$1;
(statearr_27370_27560[(2)] = null);

(statearr_27370_27560[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (69))){
var inst_27193 = (state_27346[(12)]);
var state_27346__$1 = state_27346;
var statearr_27371_27561 = state_27346__$1;
(statearr_27371_27561[(2)] = inst_27193);

(statearr_27371_27561[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (101))){
var inst_27206 = (state_27346[(8)]);
var inst_27205 = (state_27346[(9)]);
var inst_27274 = fluree.db.query.schema.type_error.call(null,inst_27205,inst_27206,throw_QMARK_);
var state_27346__$1 = state_27346;
var statearr_27372_27562 = state_27346__$1;
(statearr_27372_27562[(2)] = inst_27274);

(statearr_27372_27562[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (24))){
var inst_27100 = (state_27346[(13)]);
var state_27346__$1 = state_27346;
var statearr_27373_27563 = state_27346__$1;
(statearr_27373_27563[(2)] = inst_27100);

(statearr_27373_27563[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (102))){
var inst_27276 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
var statearr_27374_27564 = state_27346__$1;
(statearr_27374_27564[(2)] = inst_27276);

(statearr_27374_27564[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (55))){
var inst_27172 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
var statearr_27375_27565 = state_27346__$1;
(statearr_27375_27565[(2)] = inst_27172);

(statearr_27375_27565[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (85))){
var inst_27206 = (state_27346[(8)]);
var inst_27205 = (state_27346[(9)]);
var inst_27234 = fluree.db.query.schema.type_error.call(null,inst_27205,inst_27206,throw_QMARK_);
var state_27346__$1 = state_27346;
var statearr_27376_27566 = state_27346__$1;
(statearr_27376_27566[(2)] = inst_27234);

(statearr_27376_27566[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (39))){
var inst_27137 = (state_27346[(18)]);
var state_27346__$1 = state_27346;
var statearr_27377_27567 = state_27346__$1;
(statearr_27377_27567[(2)] = inst_27137);

(statearr_27377_27567[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (88))){
var inst_27193 = (state_27346[(12)]);
var state_27346__$1 = state_27346;
var statearr_27378_27568 = state_27346__$1;
(statearr_27378_27568[(2)] = inst_27193);

(statearr_27378_27568[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (46))){
var inst_27074 = (state_27346[(10)]);
var inst_27156 = (state_27346[(19)]);
var inst_27155 = (state_27346[(2)]);
var inst_27156__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_27074);
var state_27346__$1 = (function (){var statearr_27379 = state_27346;
(statearr_27379[(14)] = inst_27155);

(statearr_27379[(19)] = inst_27156__$1);

return statearr_27379;
})();
if(cljs.core.truth_(inst_27156__$1)){
var statearr_27380_27569 = state_27346__$1;
(statearr_27380_27569[(1)] = (47));

} else {
var statearr_27381_27570 = state_27346__$1;
(statearr_27381_27570[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (4))){
var inst_27035 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
var statearr_27382_27571 = state_27346__$1;
(statearr_27382_27571[(2)] = inst_27035);

(statearr_27382_27571[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (77))){
var inst_27294 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
var statearr_27383_27572 = state_27346__$1;
(statearr_27383_27572[(2)] = inst_27294);

(statearr_27383_27572[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (106))){
var inst_27286 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
var statearr_27384_27573 = state_27346__$1;
(statearr_27384_27573[(2)] = inst_27286);

(statearr_27384_27573[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (119))){
var inst_27072 = (state_27346[(20)]);
var inst_27336 = (state_27346[(2)]);
var inst_27061 = inst_27072;
var inst_27062 = inst_27336;
var state_27346__$1 = (function (){var statearr_27385 = state_27346;
(statearr_27385[(15)] = inst_27062);

(statearr_27385[(21)] = inst_27061);

return statearr_27385;
})();
var statearr_27386_27574 = state_27346__$1;
(statearr_27386_27574[(2)] = null);

(statearr_27386_27574[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (95))){
var inst_27206 = (state_27346[(8)]);
var inst_27205 = (state_27346[(9)]);
var inst_27258 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_27259 = inst_27206.call(null,cljs.core.PersistentArrayMap,null,5,inst_27258,null);
var inst_27260 = inst_27206.call(null,cljs.core.PersistentHashSet,null,inst_27259,null);
var inst_27261 = inst_27260.call(null,inst_27205);
var state_27346__$1 = state_27346;
if(cljs.core.truth_(inst_27261)){
var statearr_27387_27575 = state_27346__$1;
(statearr_27387_27575[(1)] = (96));

} else {
var statearr_27388_27576 = state_27346__$1;
(statearr_27388_27576[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (54))){
var inst_27163 = (state_27346[(22)]);
var state_27346__$1 = state_27346;
var statearr_27389_27577 = state_27346__$1;
(statearr_27389_27577[(2)] = inst_27163);

(statearr_27389_27577[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (92))){
var inst_27193 = (state_27346[(12)]);
var state_27346__$1 = state_27346;
var statearr_27390_27578 = state_27346__$1;
(statearr_27390_27578[(2)] = inst_27193);

(statearr_27390_27578[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (104))){
var inst_27193 = (state_27346[(12)]);
var state_27346__$1 = state_27346;
var statearr_27391_27579 = state_27346__$1;
(statearr_27391_27579[(2)] = inst_27193);

(statearr_27391_27579[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (15))){
var inst_27082 = (state_27346[(23)]);
var state_27346__$1 = state_27346;
var statearr_27392_27580 = state_27346__$1;
(statearr_27392_27580[(2)] = inst_27082);

(statearr_27392_27580[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (48))){
var inst_27156 = (state_27346[(19)]);
var state_27346__$1 = state_27346;
var statearr_27393_27581 = state_27346__$1;
(statearr_27393_27581[(2)] = inst_27156);

(statearr_27393_27581[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (50))){
var inst_27163 = (state_27346[(22)]);
var inst_27074 = (state_27346[(10)]);
var inst_27161 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_27074);
var inst_27162 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_27161);
var inst_27163__$1 = inst_27162 === true;
var state_27346__$1 = (function (){var statearr_27394 = state_27346;
(statearr_27394[(22)] = inst_27163__$1);

return statearr_27394;
})();
if(cljs.core.truth_(inst_27163__$1)){
var statearr_27395_27582 = state_27346__$1;
(statearr_27395_27582[(1)] = (53));

} else {
var statearr_27396_27583 = state_27346__$1;
(statearr_27396_27583[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (116))){
var inst_27317 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
var statearr_27397_27584 = state_27346__$1;
(statearr_27397_27584[(2)] = inst_27317);

(statearr_27397_27584[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (75))){
var inst_27206 = (state_27346[(8)]);
var state_27346__$1 = state_27346;
var G__27398_27585 = inst_27206;
var G__27398_27586__$1 = (((G__27398_27585 instanceof cljs.core.Keyword))?G__27398_27585.fqn:null);
switch (G__27398_27586__$1) {
case "long":
var statearr_27399_27588 = state_27346__$1;
(statearr_27399_27588[(1)] = (79));


break;
case "bigint":
var statearr_27400_27589 = state_27346__$1;
(statearr_27400_27589[(1)] = (83));


break;
case "double":
var statearr_27401_27590 = state_27346__$1;
(statearr_27401_27590[(1)] = (87));


break;
case "float":
var statearr_27402_27591 = state_27346__$1;
(statearr_27402_27591[(1)] = (91));


break;
case "bigdec":
var statearr_27403_27592 = state_27346__$1;
(statearr_27403_27592[(1)] = (95));


break;
case "string":
var statearr_27404_27593 = state_27346__$1;
(statearr_27404_27593[(1)] = (99));


break;
case "instant":
var statearr_27405_27594 = state_27346__$1;
(statearr_27405_27594[(1)] = (103));


break;
default:
var statearr_27406_27595 = state_27346__$1;
(statearr_27406_27595[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (99))){
var inst_27206 = (state_27346[(8)]);
var inst_27205 = (state_27346[(9)]);
var inst_27268 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_27269 = inst_27206.call(null,cljs.core.PersistentArrayMap,null,5,inst_27268,null);
var inst_27270 = inst_27206.call(null,cljs.core.PersistentHashSet,null,inst_27269,null);
var inst_27271 = inst_27270.call(null,inst_27205);
var state_27346__$1 = state_27346;
if(cljs.core.truth_(inst_27271)){
var statearr_27407_27596 = state_27346__$1;
(statearr_27407_27596[(1)] = (100));

} else {
var statearr_27408_27597 = state_27346__$1;
(statearr_27408_27597[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (21))){
var inst_27098 = (state_27346[(24)]);
var state_27346__$1 = state_27346;
var statearr_27409_27598 = state_27346__$1;
(statearr_27409_27598[(2)] = inst_27098);

(statearr_27409_27598[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (31))){
var inst_27114 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
var statearr_27410_27599 = state_27346__$1;
(statearr_27410_27599[(2)] = inst_27114);

(statearr_27410_27599[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (113))){
var inst_27320 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
var statearr_27411_27600 = state_27346__$1;
(statearr_27411_27600[(2)] = inst_27320);

(statearr_27411_27600[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (32))){
var state_27346__$1 = state_27346;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_27412_27601 = state_27346__$1;
(statearr_27412_27601[(1)] = (35));

} else {
var statearr_27413_27602 = state_27346__$1;
(statearr_27413_27602[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (40))){
var inst_27150 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
if(cljs.core.truth_(inst_27150)){
var statearr_27414_27603 = state_27346__$1;
(statearr_27414_27603[(1)] = (44));

} else {
var statearr_27415_27604 = state_27346__$1;
(statearr_27415_27604[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (91))){
var inst_27206 = (state_27346[(8)]);
var inst_27205 = (state_27346[(9)]);
var inst_27248 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_27249 = inst_27206.call(null,cljs.core.PersistentArrayMap,null,3,inst_27248,null);
var inst_27250 = inst_27206.call(null,cljs.core.PersistentHashSet,null,inst_27249,null);
var inst_27251 = inst_27250.call(null,inst_27205);
var state_27346__$1 = state_27346;
if(cljs.core.truth_(inst_27251)){
var statearr_27416_27605 = state_27346__$1;
(statearr_27416_27605[(1)] = (92));

} else {
var statearr_27417_27606 = state_27346__$1;
(statearr_27417_27606[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (117))){
var state_27346__$1 = state_27346;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_27418_27607 = state_27346__$1;
(statearr_27418_27607[(1)] = (120));

} else {
var statearr_27419_27608 = state_27346__$1;
(statearr_27419_27608[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (108))){
var inst_27074 = (state_27346[(10)]);
var inst_27305 = (state_27346[(25)]);
var inst_27305__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_27074);
var state_27346__$1 = (function (){var statearr_27420 = state_27346;
(statearr_27420[(25)] = inst_27305__$1);

return statearr_27420;
})();
if(cljs.core.truth_(inst_27305__$1)){
var statearr_27421_27609 = state_27346__$1;
(statearr_27421_27609[(1)] = (111));

} else {
var statearr_27422_27610 = state_27346__$1;
(statearr_27422_27610[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (56))){
var inst_27167 = (state_27346[(2)]);
var inst_27168 = fluree.db.util.async.throw_err.call(null,inst_27167);
var inst_27169 = cljs.core.not.call(null,inst_27168);
var state_27346__$1 = state_27346;
var statearr_27423_27611 = state_27346__$1;
(statearr_27423_27611[(2)] = inst_27169);

(statearr_27423_27611[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (33))){
var inst_27097 = (state_27346[(26)]);
var state_27346__$1 = state_27346;
var statearr_27424_27612 = state_27346__$1;
(statearr_27424_27612[(2)] = inst_27097);

(statearr_27424_27612[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (13))){
var inst_27092 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
if(cljs.core.truth_(inst_27092)){
var statearr_27425_27613 = state_27346__$1;
(statearr_27425_27613[(1)] = (17));

} else {
var statearr_27426_27614 = state_27346__$1;
(statearr_27426_27614[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (22))){
var inst_27123 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
if(cljs.core.truth_(inst_27123)){
var statearr_27427_27615 = state_27346__$1;
(statearr_27427_27615[(1)] = (32));

} else {
var statearr_27428_27616 = state_27346__$1;
(statearr_27428_27616[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (90))){
var inst_27246 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
var statearr_27429_27617 = state_27346__$1;
(statearr_27429_27617[(2)] = inst_27246);

(statearr_27429_27617[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (109))){
var inst_27303 = (state_27346[(27)]);
var state_27346__$1 = state_27346;
var statearr_27430_27618 = state_27346__$1;
(statearr_27430_27618[(2)] = inst_27303);

(statearr_27430_27618[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (36))){
var inst_27097 = (state_27346[(26)]);
var state_27346__$1 = state_27346;
var statearr_27431_27619 = state_27346__$1;
(statearr_27431_27619[(2)] = inst_27097);

(statearr_27431_27619[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (41))){
var inst_27074 = (state_27346[(10)]);
var inst_27142 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_27074);
var inst_27143 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_27142);
var inst_27144 = inst_27143 === true;
var state_27346__$1 = state_27346;
var statearr_27432_27620 = state_27346__$1;
(statearr_27432_27620[(2)] = inst_27144);

(statearr_27432_27620[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (118))){
var inst_27301 = (state_27346[(7)]);
var state_27346__$1 = state_27346;
var statearr_27433_27621 = state_27346__$1;
(statearr_27433_27621[(2)] = inst_27301);

(statearr_27433_27621[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (89))){
var inst_27206 = (state_27346[(8)]);
var inst_27205 = (state_27346[(9)]);
var inst_27244 = fluree.db.query.schema.type_error.call(null,inst_27205,inst_27206,throw_QMARK_);
var state_27346__$1 = state_27346;
var statearr_27434_27622 = state_27346__$1;
(statearr_27434_27622[(2)] = inst_27244);

(statearr_27434_27622[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (100))){
var inst_27193 = (state_27346[(12)]);
var state_27346__$1 = state_27346;
var statearr_27435_27623 = state_27346__$1;
(statearr_27435_27623[(2)] = inst_27193);

(statearr_27435_27623[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (122))){
var inst_27333 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
var statearr_27436_27624 = state_27346__$1;
(statearr_27436_27624[(2)] = inst_27333);

(statearr_27436_27624[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (43))){
var inst_27147 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
var statearr_27437_27625 = state_27346__$1;
(statearr_27437_27625[(2)] = inst_27147);

(statearr_27437_27625[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (61))){
var inst_27155 = (state_27346[(14)]);
var state_27346__$1 = state_27346;
var statearr_27438_27626 = state_27346__$1;
(statearr_27438_27626[(2)] = inst_27155);

(statearr_27438_27626[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (29))){
var inst_27074 = (state_27346[(10)]);
var inst_27109 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_27074);
var inst_27110 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_27109);
var inst_27111 = inst_27110 === true;
var state_27346__$1 = state_27346;
var statearr_27439_27627 = state_27346__$1;
(statearr_27439_27627[(2)] = inst_27111);

(statearr_27439_27627[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (44))){
var inst_27136 = (state_27346[(28)]);
var inst_27152 = fluree.db.query.schema.type_error.call(null,inst_27136,"a component","a non-component",throw_QMARK_);
var state_27346__$1 = state_27346;
var statearr_27440_27628 = state_27346__$1;
(statearr_27440_27628[(2)] = inst_27152);

(statearr_27440_27628[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (93))){
var inst_27206 = (state_27346[(8)]);
var inst_27205 = (state_27346[(9)]);
var inst_27254 = fluree.db.query.schema.type_error.call(null,inst_27205,inst_27206,throw_QMARK_);
var state_27346__$1 = state_27346;
var statearr_27441_27629 = state_27346__$1;
(statearr_27441_27629[(2)] = inst_27254);

(statearr_27441_27629[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (6))){
var inst_27073 = (state_27346[(16)]);
var inst_27061 = (state_27346[(21)]);
var inst_27070 = cljs.core.seq.call(null,inst_27061);
var inst_27071 = cljs.core.first.call(null,inst_27070);
var inst_27072 = cljs.core.next.call(null,inst_27070);
var inst_27073__$1 = cljs.core.nth.call(null,inst_27071,(0),null);
var inst_27074 = cljs.core.nth.call(null,inst_27071,(1),null);
var inst_27075 = cljs.core.not.call(null,inst_27073__$1);
var state_27346__$1 = (function (){var statearr_27442 = state_27346;
(statearr_27442[(16)] = inst_27073__$1);

(statearr_27442[(10)] = inst_27074);

(statearr_27442[(20)] = inst_27072);

return statearr_27442;
})();
if(inst_27075){
var statearr_27443_27630 = state_27346__$1;
(statearr_27443_27630[(1)] = (8));

} else {
var statearr_27444_27631 = state_27346__$1;
(statearr_27444_27631[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (111))){
var inst_27074 = (state_27346[(10)]);
var inst_27309 = (state_27346[(29)]);
var inst_27307 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_27074);
var inst_27308 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_27307);
var inst_27309__$1 = inst_27308 === true;
var state_27346__$1 = (function (){var statearr_27445 = state_27346;
(statearr_27445[(29)] = inst_27309__$1);

return statearr_27445;
})();
if(cljs.core.truth_(inst_27309__$1)){
var statearr_27446_27632 = state_27346__$1;
(statearr_27446_27632[(1)] = (114));

} else {
var statearr_27447_27633 = state_27346__$1;
(statearr_27447_27633[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (28))){
var inst_27117 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
var statearr_27448_27634 = state_27346__$1;
(statearr_27448_27634[(2)] = inst_27117);

(statearr_27448_27634[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (64))){
var inst_27194 = (state_27346[(11)]);
var state_27346__$1 = state_27346;
var statearr_27449_27635 = state_27346__$1;
(statearr_27449_27635[(2)] = inst_27194);

(statearr_27449_27635[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (103))){
var inst_27206 = (state_27346[(8)]);
var inst_27205 = (state_27346[(9)]);
var inst_27278 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_27279 = inst_27206.call(null,cljs.core.PersistentArrayMap,null,2,inst_27278,null);
var inst_27280 = inst_27206.call(null,cljs.core.PersistentHashSet,null,inst_27279,null);
var inst_27281 = inst_27280.call(null,inst_27205);
var state_27346__$1 = state_27346;
if(cljs.core.truth_(inst_27281)){
var statearr_27450_27636 = state_27346__$1;
(statearr_27450_27636[(1)] = (104));

} else {
var statearr_27451_27637 = state_27346__$1;
(statearr_27451_27637[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (51))){
var inst_27159 = (state_27346[(30)]);
var state_27346__$1 = state_27346;
var statearr_27452_27638 = state_27346__$1;
(statearr_27452_27638[(2)] = inst_27159);

(statearr_27452_27638[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (25))){
var inst_27120 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
var statearr_27453_27639 = state_27346__$1;
(statearr_27453_27639[(2)] = inst_27120);

(statearr_27453_27639[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (34))){
var inst_27074 = (state_27346[(10)]);
var inst_27137 = (state_27346[(18)]);
var inst_27136 = (state_27346[(2)]);
var inst_27137__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_27074);
var state_27346__$1 = (function (){var statearr_27454 = state_27346;
(statearr_27454[(28)] = inst_27136);

(statearr_27454[(18)] = inst_27137__$1);

return statearr_27454;
})();
if(cljs.core.truth_(inst_27137__$1)){
var statearr_27455_27640 = state_27346__$1;
(statearr_27455_27640[(1)] = (38));

} else {
var statearr_27456_27641 = state_27346__$1;
(statearr_27456_27641[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (17))){
var inst_27062 = (state_27346[(15)]);
var inst_27094 = fluree.db.query.schema.type_error.call(null,inst_27062,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_27346__$1 = state_27346;
var statearr_27457_27642 = state_27346__$1;
(statearr_27457_27642[(2)] = inst_27094);

(statearr_27457_27642[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (3))){
var inst_27344 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27346__$1,inst_27344);
} else {
if((state_val_27347 === (12))){
var inst_27078 = (state_27346[(31)]);
var state_27346__$1 = state_27346;
var statearr_27458_27643 = state_27346__$1;
(statearr_27458_27643[(2)] = inst_27078);

(statearr_27458_27643[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (2))){
var _ = (function (){var statearr_27459 = state_27346;
(statearr_27459[(4)] = cljs.core.cons.call(null,(5),(state_27346[(4)])));

return statearr_27459;
})();
var inst_27054 = pred_changes;
var inst_27055 = cljs.core.seq.call(null,inst_27054);
var inst_27056 = cljs.core.first.call(null,inst_27055);
var inst_27057 = cljs.core.next.call(null,inst_27055);
var inst_27058 = cljs.core.nth.call(null,inst_27056,(0),null);
var inst_27059 = cljs.core.nth.call(null,inst_27056,(1),null);
var inst_27060 = db;
var inst_27061 = inst_27054;
var inst_27062 = inst_27060;
var state_27346__$1 = (function (){var statearr_27460 = state_27346;
(statearr_27460[(15)] = inst_27062);

(statearr_27460[(32)] = inst_27058);

(statearr_27460[(21)] = inst_27061);

(statearr_27460[(33)] = inst_27059);

(statearr_27460[(34)] = inst_27057);

return statearr_27460;
})();
var statearr_27461_27644 = state_27346__$1;
(statearr_27461_27644[(2)] = null);

(statearr_27461_27644[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (66))){
var inst_27074 = (state_27346[(10)]);
var inst_27206 = (state_27346[(8)]);
var inst_27205 = (state_27346[(9)]);
var inst_27203 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_27074);
var inst_27204 = cljs.core.__destructure_map.call(null,inst_27203);
var inst_27205__$1 = cljs.core.get.call(null,inst_27204,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_27206__$1 = cljs.core.get.call(null,inst_27204,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_27207 = cljs.core._EQ_.call(null,inst_27206__$1,inst_27205__$1);
var state_27346__$1 = (function (){var statearr_27462 = state_27346;
(statearr_27462[(8)] = inst_27206__$1);

(statearr_27462[(9)] = inst_27205__$1);

return statearr_27462;
})();
if(inst_27207){
var statearr_27463_27645 = state_27346__$1;
(statearr_27463_27645[(1)] = (69));

} else {
var statearr_27464_27646 = state_27346__$1;
(statearr_27464_27646[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (107))){
var inst_27206 = (state_27346[(8)]);
var inst_27205 = (state_27346[(9)]);
var inst_27288 = fluree.db.query.schema.type_error.call(null,inst_27205,inst_27206,throw_QMARK_);
var state_27346__$1 = state_27346;
var statearr_27465_27647 = state_27346__$1;
(statearr_27465_27647[(2)] = inst_27288);

(statearr_27465_27647[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (23))){
var inst_27074 = (state_27346[(10)]);
var inst_27103 = (state_27346[(17)]);
var inst_27102 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_27074);
var inst_27103__$1 = inst_27102 === true;
var state_27346__$1 = (function (){var statearr_27466 = state_27346;
(statearr_27466[(17)] = inst_27103__$1);

return statearr_27466;
})();
if(cljs.core.truth_(inst_27103__$1)){
var statearr_27467_27648 = state_27346__$1;
(statearr_27467_27648[(1)] = (26));

} else {
var statearr_27468_27649 = state_27346__$1;
(statearr_27468_27649[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (47))){
var inst_27074 = (state_27346[(10)]);
var inst_27159 = (state_27346[(30)]);
var inst_27158 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_27074);
var inst_27159__$1 = cljs.core.not.call(null,inst_27158);
var state_27346__$1 = (function (){var statearr_27469 = state_27346;
(statearr_27469[(30)] = inst_27159__$1);

return statearr_27469;
})();
if(inst_27159__$1){
var statearr_27470_27650 = state_27346__$1;
(statearr_27470_27650[(1)] = (50));

} else {
var statearr_27471_27651 = state_27346__$1;
(statearr_27471_27651[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (35))){
var inst_27126 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27127 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_27128 = cljs.core.PersistentHashMap.fromArrays(inst_27126,inst_27127);
var inst_27129 = cljs.core.ex_info.call(null,"A boolean _predicate cannot be unique.",inst_27128);
var inst_27130 = (function(){throw inst_27129})();
var state_27346__$1 = state_27346;
var statearr_27472_27652 = state_27346__$1;
(statearr_27472_27652[(2)] = inst_27130);

(statearr_27472_27652[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (82))){
var inst_27226 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
var statearr_27473_27653 = state_27346__$1;
(statearr_27473_27653[(2)] = inst_27226);

(statearr_27473_27653[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (76))){
var state_27346__$1 = state_27346;
var statearr_27474_27654 = state_27346__$1;
(statearr_27474_27654[(2)] = null);

(statearr_27474_27654[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (97))){
var inst_27206 = (state_27346[(8)]);
var inst_27205 = (state_27346[(9)]);
var inst_27264 = fluree.db.query.schema.type_error.call(null,inst_27205,inst_27206,throw_QMARK_);
var state_27346__$1 = state_27346;
var statearr_27475_27655 = state_27346__$1;
(statearr_27475_27655[(2)] = inst_27264);

(statearr_27475_27655[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (19))){
var inst_27074 = (state_27346[(10)]);
var inst_27098 = (state_27346[(24)]);
var inst_27097 = (state_27346[(2)]);
var inst_27098__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_27074);
var state_27346__$1 = (function (){var statearr_27476 = state_27346;
(statearr_27476[(26)] = inst_27097);

(statearr_27476[(24)] = inst_27098__$1);

return statearr_27476;
})();
if(cljs.core.truth_(inst_27098__$1)){
var statearr_27477_27656 = state_27346__$1;
(statearr_27477_27656[(1)] = (20));

} else {
var statearr_27478_27657 = state_27346__$1;
(statearr_27478_27657[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (57))){
var state_27346__$1 = state_27346;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_27479_27658 = state_27346__$1;
(statearr_27479_27658[(1)] = (60));

} else {
var statearr_27480_27659 = state_27346__$1;
(statearr_27480_27659[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (68))){
var inst_27074 = (state_27346[(10)]);
var inst_27303 = (state_27346[(27)]);
var inst_27301 = (state_27346[(2)]);
var inst_27302 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_27074);
var inst_27303__$1 = inst_27302 === true;
var state_27346__$1 = (function (){var statearr_27481 = state_27346;
(statearr_27481[(7)] = inst_27301);

(statearr_27481[(27)] = inst_27303__$1);

return statearr_27481;
})();
if(cljs.core.truth_(inst_27303__$1)){
var statearr_27482_27660 = state_27346__$1;
(statearr_27482_27660[(1)] = (108));

} else {
var statearr_27483_27661 = state_27346__$1;
(statearr_27483_27661[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (11))){
var inst_27082 = (state_27346[(23)]);
var inst_27074 = (state_27346[(10)]);
var inst_27080 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_27074);
var inst_27081 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_27080);
var inst_27082__$1 = inst_27081 === false;
var state_27346__$1 = (function (){var statearr_27484 = state_27346;
(statearr_27484[(23)] = inst_27082__$1);

return statearr_27484;
})();
if(cljs.core.truth_(inst_27082__$1)){
var statearr_27485_27662 = state_27346__$1;
(statearr_27485_27662[(1)] = (14));

} else {
var statearr_27486_27663 = state_27346__$1;
(statearr_27486_27663[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (115))){
var inst_27309 = (state_27346[(29)]);
var state_27346__$1 = state_27346;
var statearr_27488_27664 = state_27346__$1;
(statearr_27488_27664[(2)] = inst_27309);

(statearr_27488_27664[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (9))){
var inst_27074 = (state_27346[(10)]);
var inst_27078 = (state_27346[(31)]);
var inst_27078__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_27074);
var state_27346__$1 = (function (){var statearr_27489 = state_27346;
(statearr_27489[(31)] = inst_27078__$1);

return statearr_27489;
})();
if(cljs.core.truth_(inst_27078__$1)){
var statearr_27490_27665 = state_27346__$1;
(statearr_27490_27665[(1)] = (11));

} else {
var statearr_27491_27666 = state_27346__$1;
(statearr_27491_27666[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (5))){
var _ = (function (){var statearr_27492 = state_27346;
(statearr_27492[(4)] = cljs.core.rest.call(null,(state_27346[(4)])));

return statearr_27492;
})();
var state_27346__$1 = state_27346;
var ex27487 = (state_27346__$1[(2)]);
var statearr_27493_27667 = state_27346__$1;
(statearr_27493_27667[(5)] = ex27487);


if((ex27487 instanceof Error)){
var statearr_27494_27668 = state_27346__$1;
(statearr_27494_27668[(1)] = (4));

(statearr_27494_27668[(5)] = null);

} else {
throw ex27487;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (112))){
var inst_27305 = (state_27346[(25)]);
var state_27346__$1 = state_27346;
var statearr_27495_27669 = state_27346__$1;
(statearr_27495_27669[(2)] = inst_27305);

(statearr_27495_27669[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (83))){
var inst_27206 = (state_27346[(8)]);
var inst_27205 = (state_27346[(9)]);
var inst_27228 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_27229 = inst_27206.call(null,cljs.core.PersistentArrayMap,null,3,inst_27228,null);
var inst_27230 = inst_27206.call(null,cljs.core.PersistentHashSet,null,inst_27229,null);
var inst_27231 = inst_27230.call(null,inst_27205);
var state_27346__$1 = state_27346;
if(cljs.core.truth_(inst_27231)){
var statearr_27496_27670 = state_27346__$1;
(statearr_27496_27670[(1)] = (84));

} else {
var statearr_27497_27671 = state_27346__$1;
(statearr_27497_27671[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (14))){
var inst_27074 = (state_27346[(10)]);
var inst_27084 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_27074);
var inst_27085 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_27084);
var inst_27086 = inst_27085 === true;
var state_27346__$1 = state_27346;
var statearr_27498_27672 = state_27346__$1;
(statearr_27498_27672[(2)] = inst_27086);

(statearr_27498_27672[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (45))){
var inst_27136 = (state_27346[(28)]);
var state_27346__$1 = state_27346;
var statearr_27499_27673 = state_27346__$1;
(statearr_27499_27673[(2)] = inst_27136);

(statearr_27499_27673[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (53))){
var inst_27062 = (state_27346[(15)]);
var inst_27073 = (state_27346[(16)]);
var inst_27165 = fluree.db.query.schema.pred_objects_unique_QMARK_.call(null,inst_27062,inst_27073);
var state_27346__$1 = state_27346;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27346__$1,(56),inst_27165);
} else {
if((state_val_27347 === (78))){
var inst_27291 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
var statearr_27500_27674 = state_27346__$1;
(statearr_27500_27674[(2)] = inst_27291);

(statearr_27500_27674[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (26))){
var inst_27074 = (state_27346[(10)]);
var inst_27107 = (state_27346[(35)]);
var inst_27105 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_27074);
var inst_27106 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_27105);
var inst_27107__$1 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_27106);
var state_27346__$1 = (function (){var statearr_27501 = state_27346;
(statearr_27501[(35)] = inst_27107__$1);

return statearr_27501;
})();
if(inst_27107__$1){
var statearr_27502_27675 = state_27346__$1;
(statearr_27502_27675[(1)] = (29));

} else {
var statearr_27503_27676 = state_27346__$1;
(statearr_27503_27676[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (16))){
var inst_27089 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
var statearr_27504_27677 = state_27346__$1;
(statearr_27504_27677[(2)] = inst_27089);

(statearr_27504_27677[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (81))){
var inst_27206 = (state_27346[(8)]);
var inst_27205 = (state_27346[(9)]);
var inst_27224 = fluree.db.query.schema.type_error.call(null,inst_27205,inst_27206,throw_QMARK_);
var state_27346__$1 = state_27346;
var statearr_27505_27678 = state_27346__$1;
(statearr_27505_27678[(2)] = inst_27224);

(statearr_27505_27678[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (120))){
var inst_27326 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27327 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_27328 = cljs.core.PersistentHashMap.fromArrays(inst_27326,inst_27327);
var inst_27329 = cljs.core.ex_info.call(null,"A component _predicate must be of type \"ref.\"",inst_27328);
var inst_27330 = (function(){throw inst_27329})();
var state_27346__$1 = state_27346;
var statearr_27506_27679 = state_27346__$1;
(statearr_27506_27679[(2)] = inst_27330);

(statearr_27506_27679[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (79))){
var inst_27206 = (state_27346[(8)]);
var inst_27205 = (state_27346[(9)]);
var inst_27218 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_27219 = inst_27206.call(null,cljs.core.PersistentArrayMap,null,2,inst_27218,null);
var inst_27220 = inst_27206.call(null,cljs.core.PersistentHashSet,null,inst_27219,null);
var inst_27221 = inst_27220.call(null,inst_27205);
var state_27346__$1 = state_27346;
if(cljs.core.truth_(inst_27221)){
var statearr_27507_27680 = state_27346__$1;
(statearr_27507_27680[(1)] = (80));

} else {
var statearr_27508_27681 = state_27346__$1;
(statearr_27508_27681[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (38))){
var inst_27140 = (state_27346[(36)]);
var inst_27074 = (state_27346[(10)]);
var inst_27139 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_27074);
var inst_27140__$1 = cljs.core.not.call(null,inst_27139);
var state_27346__$1 = (function (){var statearr_27509 = state_27346;
(statearr_27509[(36)] = inst_27140__$1);

return statearr_27509;
})();
if(inst_27140__$1){
var statearr_27510_27682 = state_27346__$1;
(statearr_27510_27682[(1)] = (41));

} else {
var statearr_27511_27683 = state_27346__$1;
(statearr_27511_27683[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (98))){
var inst_27266 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
var statearr_27512_27684 = state_27346__$1;
(statearr_27512_27684[(2)] = inst_27266);

(statearr_27512_27684[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (87))){
var inst_27206 = (state_27346[(8)]);
var inst_27205 = (state_27346[(9)]);
var inst_27238 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_27239 = inst_27206.call(null,cljs.core.PersistentArrayMap,null,3,inst_27238,null);
var inst_27240 = inst_27206.call(null,cljs.core.PersistentHashSet,null,inst_27239,null);
var inst_27241 = inst_27240.call(null,inst_27205);
var state_27346__$1 = state_27346;
if(cljs.core.truth_(inst_27241)){
var statearr_27513_27685 = state_27346__$1;
(statearr_27513_27685[(1)] = (88));

} else {
var statearr_27514_27686 = state_27346__$1;
(statearr_27514_27686[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (30))){
var inst_27107 = (state_27346[(35)]);
var state_27346__$1 = state_27346;
var statearr_27515_27687 = state_27346__$1;
(statearr_27515_27687[(2)] = inst_27107);

(statearr_27515_27687[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (73))){
var state_27346__$1 = state_27346;
var statearr_27516_27688 = state_27346__$1;
(statearr_27516_27688[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (96))){
var inst_27193 = (state_27346[(12)]);
var state_27346__$1 = state_27346;
var statearr_27518_27689 = state_27346__$1;
(statearr_27518_27689[(2)] = inst_27193);

(statearr_27518_27689[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (10))){
var inst_27339 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
var statearr_27519_27690 = state_27346__$1;
(statearr_27519_27690[(2)] = inst_27339);

(statearr_27519_27690[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (18))){
var inst_27062 = (state_27346[(15)]);
var state_27346__$1 = state_27346;
var statearr_27520_27691 = state_27346__$1;
(statearr_27520_27691[(2)] = inst_27062);

(statearr_27520_27691[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (105))){
var inst_27206 = (state_27346[(8)]);
var inst_27205 = (state_27346[(9)]);
var inst_27284 = fluree.db.query.schema.type_error.call(null,inst_27205,inst_27206,throw_QMARK_);
var state_27346__$1 = state_27346;
var statearr_27521_27692 = state_27346__$1;
(statearr_27521_27692[(2)] = inst_27284);

(statearr_27521_27692[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (52))){
var inst_27175 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
var statearr_27522_27693 = state_27346__$1;
(statearr_27522_27693[(2)] = inst_27175);

(statearr_27522_27693[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (114))){
var inst_27074 = (state_27346[(10)]);
var inst_27311 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_27074);
var inst_27312 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_27311);
var inst_27313 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ref","ref",1289896967),inst_27312);
var inst_27314 = (!(inst_27313));
var state_27346__$1 = state_27346;
var statearr_27523_27694 = state_27346__$1;
(statearr_27523_27694[(2)] = inst_27314);

(statearr_27523_27694[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (67))){
var inst_27193 = (state_27346[(12)]);
var state_27346__$1 = state_27346;
var statearr_27524_27695 = state_27346__$1;
(statearr_27524_27695[(2)] = inst_27193);

(statearr_27524_27695[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (71))){
var inst_27298 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
var statearr_27525_27696 = state_27346__$1;
(statearr_27525_27696[(2)] = inst_27298);

(statearr_27525_27696[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (42))){
var inst_27140 = (state_27346[(36)]);
var state_27346__$1 = state_27346;
var statearr_27526_27697 = state_27346__$1;
(statearr_27526_27697[(2)] = inst_27140);

(statearr_27526_27697[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (80))){
var inst_27193 = (state_27346[(12)]);
var state_27346__$1 = state_27346;
var statearr_27527_27698 = state_27346__$1;
(statearr_27527_27698[(2)] = inst_27193);

(statearr_27527_27698[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (37))){
var inst_27133 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
var statearr_27528_27699 = state_27346__$1;
(statearr_27528_27699[(2)] = inst_27133);

(statearr_27528_27699[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (63))){
var inst_27074 = (state_27346[(10)]);
var inst_27196 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_27074);
var inst_27197 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_27196);
var state_27346__$1 = state_27346;
var statearr_27529_27700 = state_27346__$1;
(statearr_27529_27700[(2)] = inst_27197);

(statearr_27529_27700[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (94))){
var inst_27256 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
var statearr_27530_27701 = state_27346__$1;
(statearr_27530_27701[(2)] = inst_27256);

(statearr_27530_27701[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (8))){
var inst_27062 = (state_27346[(15)]);
var state_27346__$1 = state_27346;
var statearr_27531_27702 = state_27346__$1;
(statearr_27531_27702[(2)] = inst_27062);

(statearr_27531_27702[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (49))){
var inst_27178 = (state_27346[(2)]);
var state_27346__$1 = state_27346;
if(cljs.core.truth_(inst_27178)){
var statearr_27532_27703 = state_27346__$1;
(statearr_27532_27703[(1)] = (57));

} else {
var statearr_27533_27704 = state_27346__$1;
(statearr_27533_27704[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27347 === (84))){
var inst_27193 = (state_27346[(12)]);
var state_27346__$1 = state_27346;
var statearr_27534_27705 = state_27346__$1;
(statearr_27534_27705[(2)] = inst_27193);

(statearr_27534_27705[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__10945__auto__ = null;
var fluree$db$query$schema$state_machine__10945__auto____0 = (function (){
var statearr_27535 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27535[(0)] = fluree$db$query$schema$state_machine__10945__auto__);

(statearr_27535[(1)] = (1));

return statearr_27535;
});
var fluree$db$query$schema$state_machine__10945__auto____1 = (function (state_27346){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_27346);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e27536){var ex__10948__auto__ = e27536;
var statearr_27537_27706 = state_27346;
(statearr_27537_27706[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_27346[(4)]))){
var statearr_27538_27707 = state_27346;
(statearr_27538_27707[(1)] = cljs.core.first.call(null,(state_27346[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27708 = state_27346;
state_27346 = G__27708;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__10945__auto__ = function(state_27346){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__10945__auto____1.call(this,state_27346);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__10945__auto____0;
fluree$db$query$schema$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__10945__auto____1;
return fluree$db$query$schema$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_27539 = f__11019__auto__.call(null);
(statearr_27539[(6)] = c__11018__auto__);

return statearr_27539;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__27710 = arguments.length;
switch (G__27710) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.call(null,db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_27734){
var state_val_27735 = (state_27734[(1)]);
if((state_val_27735 === (7))){
var state_27734__$1 = state_27734;
var statearr_27736_27756 = state_27734__$1;
(statearr_27736_27756[(2)] = db);

(statearr_27736_27756[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27735 === (1))){
var state_27734__$1 = state_27734;
var statearr_27737_27757 = state_27734__$1;
(statearr_27737_27757[(2)] = null);

(statearr_27737_27757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27735 === (4))){
var inst_27711 = (state_27734[(2)]);
var state_27734__$1 = state_27734;
var statearr_27738_27758 = state_27734__$1;
(statearr_27738_27758[(2)] = inst_27711);

(statearr_27738_27758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27735 === (6))){
var inst_27720 = (state_27734[(7)]);
var inst_27719 = (state_27734[(2)]);
var inst_27720__$1 = fluree.db.util.async.throw_err.call(null,inst_27719);
var inst_27721 = cljs.core.empty_QMARK_.call(null,inst_27720__$1);
var state_27734__$1 = (function (){var statearr_27739 = state_27734;
(statearr_27739[(7)] = inst_27720__$1);

return statearr_27739;
})();
if(inst_27721){
var statearr_27740_27759 = state_27734__$1;
(statearr_27740_27759[(1)] = (7));

} else {
var statearr_27741_27760 = state_27734__$1;
(statearr_27741_27760[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27735 === (3))){
var inst_27732 = (state_27734[(2)]);
var state_27734__$1 = state_27734;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27734__$1,inst_27732);
} else {
if((state_val_27735 === (2))){
var _ = (function (){var statearr_27743 = state_27734;
(statearr_27743[(4)] = cljs.core.cons.call(null,(5),(state_27734[(4)])));

return statearr_27743;
})();
var inst_27717 = fluree.db.query.schema.new_pred_changes.call(null,db,tempids,flakes,filter_QMARK_);
var state_27734__$1 = state_27734;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27734__$1,(6),inst_27717);
} else {
if((state_val_27735 === (9))){
var inst_27729 = (state_27734[(2)]);
var _ = (function (){var statearr_27744 = state_27734;
(statearr_27744[(4)] = cljs.core.rest.call(null,(state_27734[(4)])));

return statearr_27744;
})();
var state_27734__$1 = state_27734;
var statearr_27745_27761 = state_27734__$1;
(statearr_27745_27761[(2)] = inst_27729);

(statearr_27745_27761[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27735 === (5))){
var _ = (function (){var statearr_27746 = state_27734;
(statearr_27746[(4)] = cljs.core.rest.call(null,(state_27734[(4)])));

return statearr_27746;
})();
var state_27734__$1 = state_27734;
var ex27742 = (state_27734__$1[(2)]);
var statearr_27747_27762 = state_27734__$1;
(statearr_27747_27762[(5)] = ex27742);


if((ex27742 instanceof Error)){
var statearr_27748_27763 = state_27734__$1;
(statearr_27748_27763[(1)] = (4));

(statearr_27748_27763[(5)] = null);

} else {
throw ex27742;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27735 === (10))){
var inst_27726 = (state_27734[(2)]);
var inst_27727 = fluree.db.util.async.throw_err.call(null,inst_27726);
var state_27734__$1 = state_27734;
var statearr_27749_27764 = state_27734__$1;
(statearr_27749_27764[(2)] = inst_27727);

(statearr_27749_27764[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27735 === (8))){
var inst_27720 = (state_27734[(7)]);
var inst_27724 = fluree.db.query.schema.predicate_change_error.call(null,inst_27720,db,true);
var state_27734__$1 = state_27734;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27734__$1,(10),inst_27724);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__10945__auto__ = null;
var fluree$db$query$schema$state_machine__10945__auto____0 = (function (){
var statearr_27750 = [null,null,null,null,null,null,null,null];
(statearr_27750[(0)] = fluree$db$query$schema$state_machine__10945__auto__);

(statearr_27750[(1)] = (1));

return statearr_27750;
});
var fluree$db$query$schema$state_machine__10945__auto____1 = (function (state_27734){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_27734);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e27751){var ex__10948__auto__ = e27751;
var statearr_27752_27765 = state_27734;
(statearr_27752_27765[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_27734[(4)]))){
var statearr_27753_27766 = state_27734;
(statearr_27753_27766[(1)] = cljs.core.first.call(null,(state_27734[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27767 = state_27734;
state_27734 = G__27767;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__10945__auto__ = function(state_27734){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__10945__auto____1.call(this,state_27734);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__10945__auto____0;
fluree$db$query$schema$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__10945__auto____1;
return fluree$db$query$schema$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_27754 = f__11019__auto__.call(null);
(statearr_27754[(6)] = c__11018__auto__);

return statearr_27754;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__27769 = arguments.length;
switch (G__27769) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.call(null,predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__27771 = cljs.core.re_matches.call(null,/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.call(null,vec__27771,(0),null);
var ns = cljs.core.nth.call(null,vec__27771,(1),null);
var name = cljs.core.nth.call(null,vec__27771,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.call(null,"_",cljs.core.nth.call(null,name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.call(null,name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(2)),fluree.db.flake.__GT_sid.call(null,(3),(9)),fluree.db.flake.__GT_sid.call(null,(3),(14)),fluree.db.flake.__GT_sid.call(null,(3),(16)),fluree.db.flake.__GT_sid.call(null,(3),(8)),fluree.db.flake.__GT_sid.call(null,(3),(4)),fluree.db.flake.__GT_sid.call(null,(3),(5)),fluree.db.flake.__GT_sid.call(null,(3),(15)),fluree.db.flake.__GT_sid.call(null,(3),(17)),fluree.db.flake.__GT_sid.call(null,(3),(11)),fluree.db.flake.__GT_sid.call(null,(3),(12)),fluree.db.flake.__GT_sid.call(null,(3),(1)),fluree.db.flake.__GT_sid.call(null,(3),(10)),fluree.db.flake.__GT_sid.call(null,(3),(6)),fluree.db.flake.__GT_sid.call(null,(3),(7)),fluree.db.flake.__GT_sid.call(null,(3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(62)),fluree.db.flake.__GT_sid.call(null,(3),(68)),fluree.db.flake.__GT_sid.call(null,(3),(67)),fluree.db.flake.__GT_sid.call(null,(3),(69)),fluree.db.flake.__GT_sid.call(null,(3),(63)),fluree.db.flake.__GT_sid.call(null,(3),(70)),fluree.db.flake.__GT_sid.call(null,(3),(65)),fluree.db.flake.__GT_sid.call(null,(3),(66)),fluree.db.flake.__GT_sid.call(null,(3),(64)),fluree.db.flake.__GT_sid.call(null,(3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.call(null,(function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.call(null,acc,p);
if(cljs.core.truth_((function (){var and__5043__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.vector_QMARK_.call(null,existing_QMARK_);
} else {
return and__5043__auto__;
}
})())){
return cljs.core.update.call(null,acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.call(null,acc,p,(function (p1__27774_SHARP_,p2__27775_SHARP_){
return cljs.core.vec.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__27774_SHARP_,p2__27775_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.call(null,acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec.call(null,cljs.core.keep.call(null,(function (p1__27776_SHARP_){
var f = p1__27776_SHARP_;
if(cljs.core._EQ_.call(null,spec_pid,f.p)){
return f.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_27842){
var state_val_27843 = (state_27842[(1)]);
if((state_val_27843 === (1))){
var state_27842__$1 = state_27842;
var statearr_27844_27861 = state_27842__$1;
(statearr_27844_27861[(2)] = null);

(statearr_27844_27861[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27843 === (2))){
var _ = (function (){var statearr_27845 = state_27842;
(statearr_27845[(4)] = cljs.core.cons.call(null,(5),(state_27842[(4)])));

return statearr_27845;
})();
var inst_27794 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27795 = fluree.db.flake.max_subject_id.call(null,(1));
var inst_27796 = [inst_27795];
var inst_27797 = (new cljs.core.PersistentVector(null,1,(5),inst_27794,inst_27796,null));
var inst_27798 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27799 = [(0)];
var inst_27800 = (new cljs.core.PersistentVector(null,1,(5),inst_27798,inst_27799,null));
var inst_27801 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_27797,cljs.core._LT__EQ_,inst_27800);
var state_27842__$1 = state_27842;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27842__$1,(6),inst_27801);
} else {
if((state_val_27843 === (3))){
var inst_27840 = (state_27842[(2)]);
var state_27842__$1 = state_27842;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27842__$1,inst_27840);
} else {
if((state_val_27843 === (4))){
var inst_27782 = (state_27842[(2)]);
var state_27842__$1 = state_27842;
var statearr_27847_27862 = state_27842__$1;
(statearr_27847_27862[(2)] = inst_27782);

(statearr_27847_27862[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27843 === (5))){
var _ = (function (){var statearr_27848 = state_27842;
(statearr_27848[(4)] = cljs.core.rest.call(null,(state_27842[(4)])));

return statearr_27848;
})();
var state_27842__$1 = state_27842;
var ex27846 = (state_27842__$1[(2)]);
var statearr_27849_27863 = state_27842__$1;
(statearr_27849_27863[(5)] = ex27846);


if((ex27846 instanceof Error)){
var statearr_27850_27864 = state_27842__$1;
(statearr_27850_27864[(1)] = (4));

(statearr_27850_27864[(5)] = null);

} else {
throw ex27846;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27843 === (6))){
var inst_27803 = (state_27842[(2)]);
var inst_27804 = fluree.db.util.async.throw_err.call(null,inst_27803);
var inst_27805 = (function (){var schema_flakes = inst_27804;
return (function (p1__27777_SHARP_){
return (p1__27777_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_27806 = cljs.core.partition_by.call(null,inst_27805,inst_27804);
var inst_27807 = cljs.core.nth.call(null,inst_27806,(0),null);
var inst_27808 = cljs.core.nth.call(null,inst_27806,(1),null);
var inst_27809 = (function (){var schema_flakes = inst_27804;
var vec__27788 = inst_27806;
var collection_flakes = inst_27807;
var predicate_flakes = inst_27808;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first.call(null,coll_flakes);
var sid = first_flake.s;
var p__GT_v = cljs.core.reduce.call(null,(function (p1__27780_SHARP_,p2__27779_SHARP_){
var f = p2__27779_SHARP_;
return cljs.core.assoc.call(null,p1__27780_SHARP_,f.p,f.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__5045__auto__ = cljs.core.get.call(null,p__GT_v,(47));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.sid__GT_i.call(null,sid);
}
})();
var c_name = cljs.core.get.call(null,p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids.call(null,(43),coll_flakes):null);
var specDoc = cljs.core.get.call(null,p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.call(null,acc,partition,c_props,c_name,c_props);
});
})();
var inst_27810 = [(-1),"_tx"];
var inst_27811 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_27812 = ["_tx",(-1),(-1),(-1),null,null];
var inst_27813 = cljs.core.PersistentHashMap.fromArrays(inst_27811,inst_27812);
var inst_27814 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_27815 = ["_tx",(-1),(-1),(-1),null,null];
var inst_27816 = cljs.core.PersistentHashMap.fromArrays(inst_27814,inst_27815);
var inst_27817 = [inst_27813,inst_27816];
var inst_27818 = cljs.core.PersistentHashMap.fromArrays(inst_27810,inst_27817);
var inst_27819 = (function (){var schema_flakes = inst_27804;
var vec__27788 = inst_27806;
var collection_flakes = inst_27807;
var predicate_flakes = inst_27808;
return (function (p1__27778_SHARP_){
return p1__27778_SHARP_.s;
});
})();
var inst_27820 = cljs.core.partition_by.call(null,inst_27819,inst_27807);
var inst_27821 = cljs.core.reduce.call(null,inst_27809,inst_27818,inst_27820);
var inst_27823 = (function (){var schema_flakes = inst_27804;
var vec__27788 = inst_27806;
var collection_flakes = inst_27807;
var predicate_flakes = inst_27808;
var coll = inst_27821;
return (function (p__27822,pred_flakes){
var vec__27851 = p__27822;
var pred = cljs.core.nth.call(null,vec__27851,(0),null);
var fullText = cljs.core.nth.call(null,vec__27851,(1),null);
var first_flake = cljs.core.first.call(null,pred_flakes);
var id = first_flake.s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map.call(null,pred_flakes);
var p_name = cljs.core.get.call(null,p__GT_v,(10));
var p_type = cljs.core.get.call(null,fluree.db.query.schema.type_sid__GT_type,cljs.core.get.call(null,p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null).call(null,p_type));
var idx_QMARK_ = cljs.core.boolean$.call(null,(function (){var or__5045__auto__ = ref_QMARK_;
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core.get.call(null,p__GT_v,(15));
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.get.call(null,p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.call(null,p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(13))),cljs.core.get.call(null,p__GT_v,(19)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(15))),p_name,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids.call(null,(24),pred_flakes):null),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(17))),cljs.core.get.call(null,p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids.call(null,(20),pred_flakes):null),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(14))),id,cljs.core.get.call(null,p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(16))),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(29))),cljs.core.get.call(null,p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,pred,id,p_props,p_name,p_props),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.call(null,fullText,id):fullText)], null);
});
})();
var inst_27824 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27825 = cljs.core.PersistentHashMap.EMPTY;
var inst_27826 = cljs.core.PersistentHashSet.EMPTY;
var inst_27827 = [inst_27825,inst_27826];
var inst_27828 = (new cljs.core.PersistentVector(null,2,(5),inst_27824,inst_27827,null));
var inst_27829 = (function (){var schema_flakes = inst_27804;
var vec__27788 = inst_27806;
var collection_flakes = inst_27807;
var predicate_flakes = inst_27808;
var coll = inst_27821;
return (function (p1__27781_SHARP_){
return p1__27781_SHARP_.s;
});
})();
var inst_27830 = cljs.core.partition_by.call(null,inst_27829,inst_27808);
var inst_27831 = cljs.core.reduce.call(null,inst_27823,inst_27828,inst_27830);
var inst_27832 = cljs.core.nth.call(null,inst_27831,(0),null);
var inst_27833 = cljs.core.nth.call(null,inst_27831,(1),null);
var inst_27834 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_27835 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_27836 = [inst_27835,inst_27821,inst_27832,inst_27833];
var inst_27837 = cljs.core.PersistentHashMap.fromArrays(inst_27834,inst_27836);
var _ = (function (){var statearr_27854 = state_27842;
(statearr_27854[(4)] = cljs.core.rest.call(null,(state_27842[(4)])));

return statearr_27854;
})();
var state_27842__$1 = state_27842;
var statearr_27855_27865 = state_27842__$1;
(statearr_27855_27865[(2)] = inst_27837);

(statearr_27855_27865[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__10945__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__10945__auto____0 = (function (){
var statearr_27856 = [null,null,null,null,null,null,null];
(statearr_27856[(0)] = fluree$db$query$schema$schema_map_$_state_machine__10945__auto__);

(statearr_27856[(1)] = (1));

return statearr_27856;
});
var fluree$db$query$schema$schema_map_$_state_machine__10945__auto____1 = (function (state_27842){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_27842);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e27857){var ex__10948__auto__ = e27857;
var statearr_27858_27866 = state_27842;
(statearr_27858_27866[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_27842[(4)]))){
var statearr_27859_27867 = state_27842;
(statearr_27859_27867[(1)] = cljs.core.first.call(null,(state_27842[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27868 = state_27842;
state_27842 = G__27868;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__10945__auto__ = function(state_27842){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__10945__auto____1.call(this,state_27842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__10945__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__10945__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_27860 = f__11019__auto__.call(null);
(statearr_27860[(6)] = c__11018__auto__);

return statearr_27860;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_27910){
var state_val_27911 = (state_27910[(1)]);
if((state_val_27911 === (7))){
var inst_27893 = (state_27910[(2)]);
var inst_27894 = fluree.db.query.schema.flake__GT_pred_map.call(null,inst_27893);
var inst_27895 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_27896 = cljs.core.get.call(null,inst_27894,(114));
var inst_27897 = cljs.core.boolean$.call(null,inst_27896);
var inst_27898 = cljs.core.get.call(null,inst_27894,(110));
var inst_27899 = cljs.core.get.call(null,inst_27894,(117));
var inst_27900 = cljs.core.get.call(null,fluree.db.query.schema.lang_sid__GT_lang,inst_27899);
var inst_27901 = cljs.core.get.call(null,inst_27894,(111));
var inst_27902 = cljs.core.get.call(null,inst_27894,(115));
var inst_27903 = cljs.core.get.call(null,inst_27894,(112));
var inst_27904 = [inst_27897,inst_27898,inst_27900,inst_27901,inst_27902,inst_27903];
var inst_27905 = cljs.core.PersistentHashMap.fromArrays(inst_27895,inst_27904);
var _ = (function (){var statearr_27912 = state_27910;
(statearr_27912[(4)] = cljs.core.rest.call(null,(state_27910[(4)])));

return statearr_27912;
})();
var state_27910__$1 = state_27910;
var statearr_27913_27936 = state_27910__$1;
(statearr_27913_27936[(2)] = inst_27905);

(statearr_27913_27936[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (1))){
var state_27910__$1 = state_27910;
var statearr_27914_27937 = state_27910__$1;
(statearr_27914_27937[(2)] = null);

(statearr_27914_27937[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (4))){
var inst_27869 = (state_27910[(2)]);
var state_27910__$1 = state_27910;
var statearr_27915_27938 = state_27910__$1;
(statearr_27915_27938[(2)] = inst_27869);

(statearr_27915_27938[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (6))){
var _ = (function (){var statearr_27916 = state_27910;
(statearr_27916[(4)] = cljs.core.cons.call(null,(9),(state_27910[(4)])));

return statearr_27916;
})();
var inst_27881 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27882 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27883 = ["_setting/id","root"];
var inst_27884 = (new cljs.core.PersistentVector(null,2,(5),inst_27882,inst_27883,null));
var inst_27885 = [inst_27884];
var inst_27886 = (new cljs.core.PersistentVector(null,1,(5),inst_27881,inst_27885,null));
var inst_27887 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27886);
var state_27910__$1 = state_27910;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27910__$1,(10),inst_27887);
} else {
if((state_val_27911 === (3))){
var inst_27908 = (state_27910[(2)]);
var state_27910__$1 = state_27910;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27910__$1,inst_27908);
} else {
if((state_val_27911 === (2))){
var _ = (function (){var statearr_27919 = state_27910;
(statearr_27919[(4)] = cljs.core.cons.call(null,(5),(state_27910[(4)])));

return statearr_27919;
})();
var state_27910__$1 = state_27910;
var statearr_27920_27939 = state_27910__$1;
(statearr_27920_27939[(2)] = null);

(statearr_27920_27939[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (9))){
var _ = (function (){var statearr_27921 = state_27910;
(statearr_27921[(4)] = cljs.core.rest.call(null,(state_27910[(4)])));

return statearr_27921;
})();
var state_27910__$1 = state_27910;
var ex27917 = (state_27910__$1[(2)]);
var statearr_27922_27940 = state_27910__$1;
(statearr_27922_27940[(5)] = ex27917);


var statearr_27923_27941 = state_27910__$1;
(statearr_27923_27941[(1)] = (8));

(statearr_27923_27941[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (5))){
var _ = (function (){var statearr_27924 = state_27910;
(statearr_27924[(4)] = cljs.core.rest.call(null,(state_27910[(4)])));

return statearr_27924;
})();
var state_27910__$1 = state_27910;
var ex27918 = (state_27910__$1[(2)]);
var statearr_27925_27942 = state_27910__$1;
(statearr_27925_27942[(5)] = ex27918);


if((ex27918 instanceof Error)){
var statearr_27926_27943 = state_27910__$1;
(statearr_27926_27943[(1)] = (4));

(statearr_27926_27943[(5)] = null);

} else {
throw ex27918;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (10))){
var inst_27889 = (state_27910[(2)]);
var inst_27890 = fluree.db.util.async.throw_err.call(null,inst_27889);
var _ = (function (){var statearr_27927 = state_27910;
(statearr_27927[(4)] = cljs.core.rest.call(null,(state_27910[(4)])));

return statearr_27927;
})();
var state_27910__$1 = state_27910;
var statearr_27928_27944 = state_27910__$1;
(statearr_27928_27944[(2)] = inst_27890);

(statearr_27928_27944[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (8))){
var inst_27875 = (state_27910[(2)]);
var state_27910__$1 = (function (){var statearr_27929 = state_27910;
(statearr_27929[(7)] = inst_27875);

return statearr_27929;
})();
var statearr_27930_27945 = state_27910__$1;
(statearr_27930_27945[(2)] = null);

(statearr_27930_27945[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__10945__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__10945__auto____0 = (function (){
var statearr_27931 = [null,null,null,null,null,null,null,null];
(statearr_27931[(0)] = fluree$db$query$schema$setting_map_$_state_machine__10945__auto__);

(statearr_27931[(1)] = (1));

return statearr_27931;
});
var fluree$db$query$schema$setting_map_$_state_machine__10945__auto____1 = (function (state_27910){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_27910);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e27932){var ex__10948__auto__ = e27932;
var statearr_27933_27946 = state_27910;
(statearr_27933_27946[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_27910[(4)]))){
var statearr_27934_27947 = state_27910;
(statearr_27934_27947[(1)] = cljs.core.first.call(null,(state_27910[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27948 = state_27910;
state_27910 = G__27948;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__10945__auto__ = function(state_27910){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__10945__auto____1.call(this,state_27910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__10945__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__10945__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_27935 = f__11019__auto__.call(null);
(statearr_27935[(6)] = c__11018__auto__);

return statearr_27935;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
