// Compiled by ClojureScript 1.11.57 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5342__auto__,k__5343__auto__){
var self__ = this;
var this__5342__auto____$1 = this;
return this__5342__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5343__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5344__auto__,k38995,else__5345__auto__){
var self__ = this;
var this__5344__auto____$1 = this;
var G__38999 = k38995;
var G__38999__$1 = (((G__38999 instanceof cljs.core.Keyword))?G__38999.fqn:null);
switch (G__38999__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k38995,else__5345__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5362__auto__,f__5363__auto__,init__5364__auto__){
var self__ = this;
var this__5362__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5365__auto__,p__39000){
var vec__39001 = p__39000;
var k__5366__auto__ = cljs.core.nth.call(null,vec__39001,(0),null);
var v__5367__auto__ = cljs.core.nth.call(null,vec__39001,(1),null);
return f__5363__auto__.call(null,ret__5365__auto__,k__5366__auto__,v__5367__auto__);
}),init__5364__auto__,this__5362__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5357__auto__,writer__5358__auto__,opts__5359__auto__){
var self__ = this;
var this__5357__auto____$1 = this;
var pr_pair__5360__auto__ = (function (keyval__5361__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5358__auto__,cljs.core.pr_writer,""," ","",opts__5359__auto__,keyval__5361__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5358__auto__,pr_pair__5360__auto__,"#fluree.db.session.DbSession{",", ","}",opts__5359__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__38994){
var self__ = this;
var G__38994__$1 = this;
return (new cljs.core.RecordIter((0),G__38994__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5340__auto__){
var self__ = this;
var this__5340__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5337__auto__){
var self__ = this;
var this__5337__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5346__auto__){
var self__ = this;
var this__5346__auto____$1 = this;
return (11 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5339__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll.call(null,coll__5339__auto__));
}).call(null,this__5338__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this38996,other38997){
var self__ = this;
var this38996__$1 = this;
return (((!((other38997 == null)))) && ((((this38996__$1.constructor === other38997.constructor)) && (((cljs.core._EQ_.call(null,this38996__$1.conn,other38997.conn)) && (((cljs.core._EQ_.call(null,this38996__$1.network,other38997.network)) && (((cljs.core._EQ_.call(null,this38996__$1.dbid,other38997.dbid)) && (((cljs.core._EQ_.call(null,this38996__$1.db_name,other38997.db_name)) && (((cljs.core._EQ_.call(null,this38996__$1.update_chan,other38997.update_chan)) && (((cljs.core._EQ_.call(null,this38996__$1.transact_chan,other38997.transact_chan)) && (((cljs.core._EQ_.call(null,this38996__$1.state,other38997.state)) && (((cljs.core._EQ_.call(null,this38996__$1.schema_cache,other38997.schema_cache)) && (((cljs.core._EQ_.call(null,this38996__$1.blank_db,other38997.blank_db)) && (((cljs.core._EQ_.call(null,this38996__$1.close,other38997.close)) && (((cljs.core._EQ_.call(null,this38996__$1.id,other38997.id)) && (cljs.core._EQ_.call(null,this38996__$1.__extmap,other38997.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5352__auto__,k__5353__auto__){
var self__ = this;
var this__5352__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5353__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5352__auto____$1),self__.__meta),k__5353__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5353__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5349__auto__,k38995){
var self__ = this;
var this__5349__auto____$1 = this;
var G__39004 = k38995;
var G__39004__$1 = (((G__39004 instanceof cljs.core.Keyword))?G__39004.fqn:null);
switch (G__39004__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k38995);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5350__auto__,k__5351__auto__,G__38994){
var self__ = this;
var this__5350__auto____$1 = this;
var pred__39005 = cljs.core.keyword_identical_QMARK_;
var expr__39006 = k__5351__auto__;
if(cljs.core.truth_(pred__39005.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__39006))){
return (new fluree.db.session.DbSession(G__38994,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__39005.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__39006))){
return (new fluree.db.session.DbSession(self__.conn,G__38994,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__39005.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__39006))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__38994,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__39005.call(null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),expr__39006))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__38994,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__39005.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),expr__39006))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__38994,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__39005.call(null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),expr__39006))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__38994,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__39005.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__39006))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__38994,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__39005.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__39006))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__38994,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__39005.call(null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),expr__39006))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__38994,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__39005.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__39006))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__38994,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__39005.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__39006))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__38994,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5351__auto__,G__38994),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5355__auto__){
var self__ = this;
var this__5355__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5341__auto__,G__38994){
var self__ = this;
var this__5341__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__38994,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5347__auto__,entry__5348__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5348__auto__)){
return this__5347__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5348__auto__,(0)),cljs.core._nth.call(null,entry__5348__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5347__auto____$1,entry__5348__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__5388__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__5388__auto__,writer__5389__auto__){
return cljs.core._write.call(null,writer__5389__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__38998){
var extmap__5384__auto__ = (function (){var G__39008 = cljs.core.dissoc.call(null,G__38998,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.record_QMARK_.call(null,G__38998)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__39008);
} else {
return G__39008;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__38998),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__38998),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__38998),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__38998),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__38998),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__38998),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__38998),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__38998),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__38998),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__38998),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__38998),null,cljs.core.not_empty.call(null,extmap__5384__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.call(null,fluree.db.session.cache_factory.call(null));
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__39011 = session;
var map__39011__$1 = cljs.core.__destructure_map.call(null,map__39011);
var network = cljs.core.get.call(null,map__39011__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__39011__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.call(null,c,cache_key))){
return c;
} else {
return cljs.core.assoc.call(null,c,cache_key,session);
}
}));

return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_.call(null,fluree.db.session.session_cache,fluree.db.session.cache_factory.call(null));
});
fluree.db.session.ready_QMARK_ = (function fluree$db$session$ready_QMARK_(db_info){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ready","ready",1086465795),cljs.core.keyword.call(null,new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(db_info)));
});
fluree.db.session.load_ledger_info = (function fluree$db$session$load_ledger_info(conn,network,dbid){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_39053){
var state_val_39054 = (state_39053[(1)]);
if((state_val_39054 === (7))){
var inst_39027 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," is not found on this ledger group."].join('');
var inst_39028 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_39029 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_39030 = cljs.core.PersistentHashMap.fromArrays(inst_39028,inst_39029);
var inst_39031 = cljs.core.ex_info.call(null,inst_39027,inst_39030);
var inst_39032 = (function(){throw inst_39031})();
var state_39053__$1 = state_39053;
var statearr_39055_39078 = state_39053__$1;
(statearr_39055_39078[(2)] = inst_39032);

(statearr_39055_39078[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39054 === (1))){
var state_39053__$1 = state_39053;
var statearr_39056_39079 = state_39053__$1;
(statearr_39056_39079[(2)] = null);

(statearr_39056_39079[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39054 === (4))){
var inst_39012 = (state_39053[(2)]);
var state_39053__$1 = state_39053;
var statearr_39057_39080 = state_39053__$1;
(statearr_39057_39080[(2)] = inst_39012);

(statearr_39057_39080[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39054 === (6))){
var inst_39024 = (state_39053[(7)]);
var inst_39023 = (state_39053[(2)]);
var inst_39024__$1 = fluree.db.util.async.throw_err.call(null,inst_39023);
var inst_39025 = cljs.core.empty_QMARK_.call(null,inst_39024__$1);
var state_39053__$1 = (function (){var statearr_39058 = state_39053;
(statearr_39058[(7)] = inst_39024__$1);

return statearr_39058;
})();
if(inst_39025){
var statearr_39059_39081 = state_39053__$1;
(statearr_39059_39081[(1)] = (7));

} else {
var statearr_39060_39082 = state_39053__$1;
(statearr_39060_39082[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39054 === (3))){
var inst_39051 = (state_39053[(2)]);
var state_39053__$1 = state_39053;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39053__$1,inst_39051);
} else {
if((state_val_39054 === (12))){
var inst_39046 = (state_39053[(2)]);
var state_39053__$1 = state_39053;
var statearr_39061_39083 = state_39053__$1;
(statearr_39061_39083[(2)] = inst_39046);

(statearr_39061_39083[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39054 === (2))){
var _ = (function (){var statearr_39062 = state_39053;
(statearr_39062[(4)] = cljs.core.cons.call(null,(5),(state_39053[(4)])));

return statearr_39062;
})();
var inst_39018 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39019 = [network,dbid];
var inst_39020 = (new cljs.core.PersistentVector(null,2,(5),inst_39018,inst_39019,null));
var inst_39021 = fluree.db.operations.ledger_info_async.call(null,conn,inst_39020);
var state_39053__$1 = state_39053;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39053__$1,(6),inst_39021);
} else {
if((state_val_39054 === (11))){
var inst_39024 = (state_39053[(7)]);
var state_39053__$1 = state_39053;
var statearr_39064_39084 = state_39053__$1;
(statearr_39064_39084[(2)] = inst_39024);

(statearr_39064_39084[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39054 === (9))){
var inst_39048 = (state_39053[(2)]);
var _ = (function (){var statearr_39065 = state_39053;
(statearr_39065[(4)] = cljs.core.rest.call(null,(state_39053[(4)])));

return statearr_39065;
})();
var state_39053__$1 = state_39053;
var statearr_39066_39085 = state_39053__$1;
(statearr_39066_39085[(2)] = inst_39048);

(statearr_39066_39085[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39054 === (5))){
var _ = (function (){var statearr_39067 = state_39053;
(statearr_39067[(4)] = cljs.core.rest.call(null,(state_39053[(4)])));

return statearr_39067;
})();
var state_39053__$1 = state_39053;
var ex39063 = (state_39053__$1[(2)]);
var statearr_39068_39086 = state_39053__$1;
(statearr_39068_39086[(5)] = ex39063);


if((ex39063 instanceof Error)){
var statearr_39069_39087 = state_39053__$1;
(statearr_39069_39087[(1)] = (4));

(statearr_39069_39087[(5)] = null);

} else {
throw ex39063;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39054 === (10))){
var inst_39024 = (state_39053[(7)]);
var inst_39037 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_39024);
var inst_39038 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39037),"."].join('');
var inst_39039 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_39040 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_39041 = cljs.core.PersistentHashMap.fromArrays(inst_39039,inst_39040);
var inst_39042 = cljs.core.ex_info.call(null,inst_39038,inst_39041);
var inst_39043 = (function(){throw inst_39042})();
var state_39053__$1 = state_39053;
var statearr_39070_39088 = state_39053__$1;
(statearr_39070_39088[(2)] = inst_39043);

(statearr_39070_39088[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39054 === (8))){
var inst_39024 = (state_39053[(7)]);
var inst_39034 = fluree.db.session.ready_QMARK_.call(null,inst_39024);
var inst_39035 = (!(inst_39034));
var state_39053__$1 = state_39053;
if(inst_39035){
var statearr_39071_39089 = state_39053__$1;
(statearr_39071_39089[(1)] = (10));

} else {
var statearr_39072_39090 = state_39053__$1;
(statearr_39072_39090[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_ledger_info_$_state_machine__10945__auto__ = null;
var fluree$db$session$load_ledger_info_$_state_machine__10945__auto____0 = (function (){
var statearr_39073 = [null,null,null,null,null,null,null,null];
(statearr_39073[(0)] = fluree$db$session$load_ledger_info_$_state_machine__10945__auto__);

(statearr_39073[(1)] = (1));

return statearr_39073;
});
var fluree$db$session$load_ledger_info_$_state_machine__10945__auto____1 = (function (state_39053){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_39053);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e39074){var ex__10948__auto__ = e39074;
var statearr_39075_39091 = state_39053;
(statearr_39075_39091[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_39053[(4)]))){
var statearr_39076_39092 = state_39053;
(statearr_39076_39092[(1)] = cljs.core.first.call(null,(state_39053[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39093 = state_39053;
state_39053 = G__39093;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$session$load_ledger_info_$_state_machine__10945__auto__ = function(state_39053){
switch(arguments.length){
case 0:
return fluree$db$session$load_ledger_info_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$session$load_ledger_info_$_state_machine__10945__auto____1.call(this,state_39053);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_ledger_info_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_ledger_info_$_state_machine__10945__auto____0;
fluree$db$session$load_ledger_info_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_ledger_info_$_state_machine__10945__auto____1;
return fluree$db$session$load_ledger_info_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_39077 = f__11019__auto__.call(null);
(statearr_39077[(6)] = c__11018__auto__);

return statearr_39077;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.session.load_current_db = (function fluree$db$session$load_current_db(conn,p__39094){
var map__39095 = p__39094;
var map__39095__$1 = cljs.core.__destructure_map.call(null,map__39095);
var blank_db = map__39095__$1;
var network = cljs.core.get.call(null,map__39095__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__39095__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_39170){
var state_val_39171 = (state_39170[(1)]);
if((state_val_39171 === (7))){
var inst_39113 = (state_39170[(7)]);
var inst_39112 = (state_39170[(2)]);
var inst_39113__$1 = fluree.db.util.async.throw_err.call(null,inst_39112);
var state_39170__$1 = (function (){var statearr_39172 = state_39170;
(statearr_39172[(7)] = inst_39113__$1);

return statearr_39172;
})();
if(cljs.core.truth_(inst_39113__$1)){
var statearr_39173_39208 = state_39170__$1;
(statearr_39173_39208[(1)] = (8));

} else {
var statearr_39174_39209 = state_39170__$1;
(statearr_39174_39209[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39171 === (20))){
var inst_39118 = (state_39170[(8)]);
var inst_39151 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39118)," for ledger: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid),"."].join('');
var inst_39152 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_39153 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_39154 = cljs.core.PersistentHashMap.fromArrays(inst_39152,inst_39153);
var inst_39155 = cljs.core.ex_info.call(null,inst_39151,inst_39154);
var inst_39156 = (function(){throw inst_39155})();
var state_39170__$1 = state_39170;
var statearr_39175_39210 = state_39170__$1;
(statearr_39175_39210[(2)] = inst_39156);

(statearr_39175_39210[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39171 === (1))){
var state_39170__$1 = state_39170;
var statearr_39176_39211 = state_39170__$1;
(statearr_39176_39211[(2)] = null);

(statearr_39176_39211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39171 === (4))){
var inst_39096 = (state_39170[(2)]);
var state_39170__$1 = state_39170;
var statearr_39177_39212 = state_39170__$1;
(statearr_39177_39212[(2)] = inst_39096);

(statearr_39177_39212[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39171 === (15))){
var inst_39160 = (state_39170[(2)]);
var state_39170__$1 = state_39170;
var statearr_39178_39213 = state_39170__$1;
(statearr_39178_39213[(2)] = inst_39160);

(statearr_39178_39213[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39171 === (21))){
var inst_39158 = (state_39170[(2)]);
var state_39170__$1 = state_39170;
var statearr_39179_39214 = state_39170__$1;
(statearr_39179_39214[(2)] = inst_39158);

(statearr_39179_39214[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39171 === (13))){
var inst_39117 = (state_39170[(9)]);
var inst_39122 = fluree.db.query.schema.schema_map.call(null,inst_39117);
var inst_39123 = fluree.db.query.schema.setting_map.call(null,inst_39117);
var inst_39124 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(inst_39117);
var inst_39125 = cljs.core.swap_BANG_.call(null,inst_39124,cljs.core.empty);
var state_39170__$1 = (function (){var statearr_39180 = state_39170;
(statearr_39180[(10)] = inst_39123);

(statearr_39180[(11)] = inst_39125);

return statearr_39180;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39170__$1,(16),inst_39122);
} else {
if((state_val_39171 === (22))){
var inst_39118 = (state_39170[(8)]);
var inst_39146 = (state_39170[(2)]);
var inst_39147 = fluree.db.util.async.throw_err.call(null,inst_39146);
var inst_39148 = (inst_39118 + (1));
var inst_39117 = inst_39147;
var inst_39118__$1 = inst_39148;
var state_39170__$1 = (function (){var statearr_39181 = state_39170;
(statearr_39181[(9)] = inst_39117);

(statearr_39181[(8)] = inst_39118__$1);

return statearr_39181;
})();
var statearr_39182_39215 = state_39170__$1;
(statearr_39182_39215[(2)] = null);

(statearr_39182_39215[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39171 === (6))){
var inst_39105 = (state_39170[(2)]);
var inst_39106 = fluree.db.util.async.throw_err.call(null,inst_39105);
var inst_39107 = cljs.core.__destructure_map.call(null,inst_39106);
var inst_39108 = cljs.core.get.call(null,inst_39107,new cljs.core.Keyword(null,"block","block",664686210));
var inst_39109 = cljs.core.get.call(null,inst_39107,new cljs.core.Keyword(null,"index","index",-1531685915));
var inst_39110 = fluree.db.storage.core.reify_db.call(null,conn,network,dbid,blank_db,inst_39109);
var state_39170__$1 = (function (){var statearr_39183 = state_39170;
(statearr_39183[(12)] = inst_39108);

return statearr_39183;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39170__$1,(7),inst_39110);
} else {
if((state_val_39171 === (17))){
var inst_39117 = (state_39170[(9)]);
var inst_39128 = (state_39170[(13)]);
var inst_39130 = (state_39170[(2)]);
var inst_39131 = fluree.db.util.async.throw_err.call(null,inst_39130);
var inst_39132 = cljs.core.assoc.call(null,inst_39117,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_39128,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_39131);
var state_39170__$1 = state_39170;
var statearr_39184_39216 = state_39170__$1;
(statearr_39184_39216[(2)] = inst_39132);

(statearr_39184_39216[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39171 === (3))){
var inst_39168 = (state_39170[(2)]);
var state_39170__$1 = state_39170;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39170__$1,inst_39168);
} else {
if((state_val_39171 === (12))){
var inst_39162 = (state_39170[(2)]);
var state_39170__$1 = state_39170;
var statearr_39185_39217 = state_39170__$1;
(statearr_39185_39217[(2)] = inst_39162);

(statearr_39185_39217[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39171 === (2))){
var _ = (function (){var statearr_39186 = state_39170;
(statearr_39186[(4)] = cljs.core.cons.call(null,(5),(state_39170[(4)])));

return statearr_39186;
})();
var inst_39103 = fluree.db.session.load_ledger_info.call(null,conn,network,dbid);
var state_39170__$1 = state_39170;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39170__$1,(6),inst_39103);
} else {
if((state_val_39171 === (19))){
var inst_39117 = (state_39170[(9)]);
var inst_39137 = (state_39170[(14)]);
var inst_39140 = cljs.core.__destructure_map.call(null,inst_39137);
var inst_39141 = cljs.core.get.call(null,inst_39140,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_39142 = cljs.core.get.call(null,inst_39140,new cljs.core.Keyword(null,"block","block",664686210));
var inst_39143 = cljs.core.get.call(null,inst_39140,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_39144 = fluree.db.dbproto._with.call(null,inst_39117,inst_39142,inst_39141);
var state_39170__$1 = (function (){var statearr_39187 = state_39170;
(statearr_39187[(15)] = inst_39143);

return statearr_39187;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39170__$1,(22),inst_39144);
} else {
if((state_val_39171 === (11))){
var inst_39108 = (state_39170[(12)]);
var inst_39118 = (state_39170[(8)]);
var inst_39120 = (inst_39118 > inst_39108);
var state_39170__$1 = state_39170;
if(cljs.core.truth_(inst_39120)){
var statearr_39189_39218 = state_39170__$1;
(statearr_39189_39218[(1)] = (13));

} else {
var statearr_39190_39219 = state_39170__$1;
(statearr_39190_39219[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39171 === (9))){
var state_39170__$1 = state_39170;
var statearr_39191_39220 = state_39170__$1;
(statearr_39191_39220[(2)] = null);

(statearr_39191_39220[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39171 === (5))){
var _ = (function (){var statearr_39192 = state_39170;
(statearr_39192[(4)] = cljs.core.rest.call(null,(state_39170[(4)])));

return statearr_39192;
})();
var state_39170__$1 = state_39170;
var ex39188 = (state_39170__$1[(2)]);
var statearr_39193_39221 = state_39170__$1;
(statearr_39193_39221[(5)] = ex39188);


if((ex39188 instanceof Error)){
var statearr_39194_39222 = state_39170__$1;
(statearr_39194_39222[(1)] = (4));

(statearr_39194_39222[(5)] = null);

} else {
throw ex39188;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39171 === (14))){
var inst_39118 = (state_39170[(8)]);
var inst_39134 = fluree.db.storage.core.read_block.call(null,conn,network,dbid,inst_39118);
var state_39170__$1 = state_39170;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39170__$1,(18),inst_39134);
} else {
if((state_val_39171 === (16))){
var inst_39123 = (state_39170[(10)]);
var inst_39127 = (state_39170[(2)]);
var inst_39128 = fluree.db.util.async.throw_err.call(null,inst_39127);
var state_39170__$1 = (function (){var statearr_39195 = state_39170;
(statearr_39195[(13)] = inst_39128);

return statearr_39195;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39170__$1,(17),inst_39123);
} else {
if((state_val_39171 === (10))){
var inst_39165 = (state_39170[(2)]);
var _ = (function (){var statearr_39196 = state_39170;
(statearr_39196[(4)] = cljs.core.rest.call(null,(state_39170[(4)])));

return statearr_39196;
})();
var state_39170__$1 = state_39170;
var statearr_39197_39223 = state_39170__$1;
(statearr_39197_39223[(2)] = inst_39165);

(statearr_39197_39223[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39171 === (18))){
var inst_39137 = (state_39170[(14)]);
var inst_39136 = (state_39170[(2)]);
var inst_39137__$1 = fluree.db.util.async.throw_err.call(null,inst_39136);
var state_39170__$1 = (function (){var statearr_39198 = state_39170;
(statearr_39198[(14)] = inst_39137__$1);

return statearr_39198;
})();
if(cljs.core.truth_(inst_39137__$1)){
var statearr_39199_39224 = state_39170__$1;
(statearr_39199_39224[(1)] = (19));

} else {
var statearr_39200_39225 = state_39170__$1;
(statearr_39200_39225[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39171 === (8))){
var inst_39113 = (state_39170[(7)]);
var inst_39115 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_39113);
var inst_39116 = (inst_39115 + (1));
var inst_39117 = inst_39113;
var inst_39118 = inst_39116;
var state_39170__$1 = (function (){var statearr_39201 = state_39170;
(statearr_39201[(9)] = inst_39117);

(statearr_39201[(8)] = inst_39118);

return statearr_39201;
})();
var statearr_39202_39226 = state_39170__$1;
(statearr_39202_39226[(2)] = null);

(statearr_39202_39226[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_current_db_$_state_machine__10945__auto__ = null;
var fluree$db$session$load_current_db_$_state_machine__10945__auto____0 = (function (){
var statearr_39203 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39203[(0)] = fluree$db$session$load_current_db_$_state_machine__10945__auto__);

(statearr_39203[(1)] = (1));

return statearr_39203;
});
var fluree$db$session$load_current_db_$_state_machine__10945__auto____1 = (function (state_39170){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_39170);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e39204){var ex__10948__auto__ = e39204;
var statearr_39205_39227 = state_39170;
(statearr_39205_39227[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_39170[(4)]))){
var statearr_39206_39228 = state_39170;
(statearr_39206_39228[(1)] = cljs.core.first.call(null,(state_39170[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39229 = state_39170;
state_39170 = G__39229;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$session$load_current_db_$_state_machine__10945__auto__ = function(state_39170){
switch(arguments.length){
case 0:
return fluree$db$session$load_current_db_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$session$load_current_db_$_state_machine__10945__auto____1.call(this,state_39170);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_current_db_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_current_db_$_state_machine__10945__auto____0;
fluree$db$session$load_current_db_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_current_db_$_state_machine__10945__auto____1;
return fluree$db$session$load_current_db_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_39207 = f__11019__auto__.call(null);
(statearr_39207[(6)] = c__11018__auto__);

return statearr_39207;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Perform a compare and set operation to update the db stored in the session
 *   argument's state atom. Update the cache to `new-db-ch`, but only if the
 *   previously stored db channel is the same as the `old-db-ch`. Returns a boolean
 *   indicating whether the cache was updated.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(p__39230,old_db_ch,new_db_ch){
var map__39231 = p__39230;
var map__39231__$1 = cljs.core.__destructure_map.call(null,map__39231);
var state = cljs.core.get.call(null,map__39231__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core._EQ_.call(null,new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.call(null,state,(function (p__39232){
var map__39233 = p__39232;
var map__39233__$1 = cljs.core.__destructure_map.call(null,map__39233);
var s = map__39233__$1;
var current = cljs.core.get.call(null,map__39233__$1,new cljs.core.Keyword("db","current","db/current",-1088041545));
if(cljs.core._EQ_.call(null,current,old_db_ch)){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","current","db/current",-1088041545),new_db_ch);
} else {
return s;
}
}))),new_db_ch);
});
/**
 * Clears db channel from session state, forcing a new full load next time db
 *   channel is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(p__39234){
var map__39235 = p__39234;
var map__39235__$1 = cljs.core.__destructure_map.call(null,map__39235);
var state = cljs.core.get.call(null,map__39235__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
});
/**
 * Clears any cached database channels and forces an immediate reload. Returns a
 *   channel that will contain the newly loaded database
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(p__39236){
var map__39237 = p__39236;
var map__39237__$1 = cljs.core.__destructure_map.call(null,map__39237);
var conn = cljs.core.get.call(null,map__39237__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var blank_db = cljs.core.get.call(null,map__39237__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
var state = cljs.core.get.call(null,map__39237__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var db_ch = cljs.core.async.promise_chan.call(null);
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),db_ch);

var c__11018__auto___39274 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_39257){
var state_val_39258 = (state_39257[(1)]);
if((state_val_39258 === (1))){
var state_39257__$1 = state_39257;
var statearr_39259_39275 = state_39257__$1;
(statearr_39259_39275[(2)] = null);

(statearr_39259_39275[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39258 === (2))){
var _ = (function (){var statearr_39260 = state_39257;
(statearr_39260[(4)] = cljs.core.cons.call(null,(5),(state_39257[(4)])));

return statearr_39260;
})();
var inst_39247 = fluree.db.session.load_current_db.call(null,conn,blank_db);
var state_39257__$1 = state_39257;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39257__$1,(6),inst_39247);
} else {
if((state_val_39258 === (3))){
var inst_39255 = (state_39257[(2)]);
var state_39257__$1 = state_39257;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39257__$1,inst_39255);
} else {
if((state_val_39258 === (4))){
var inst_39238 = (state_39257[(2)]);
var inst_39239 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_39240 = fluree.db.util.log.error.call(null,inst_39238,"Error reloading db");
var inst_39241 = cljs.core.async.put_BANG_.call(null,db_ch,inst_39238);
var state_39257__$1 = (function (){var statearr_39262 = state_39257;
(statearr_39262[(7)] = inst_39240);

(statearr_39262[(8)] = inst_39239);

return statearr_39262;
})();
var statearr_39263_39276 = state_39257__$1;
(statearr_39263_39276[(2)] = inst_39241);

(statearr_39263_39276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39258 === (5))){
var _ = (function (){var statearr_39264 = state_39257;
(statearr_39264[(4)] = cljs.core.rest.call(null,(state_39257[(4)])));

return statearr_39264;
})();
var state_39257__$1 = state_39257;
var ex39261 = (state_39257__$1[(2)]);
var statearr_39265_39277 = state_39257__$1;
(statearr_39265_39277[(5)] = ex39261);


var statearr_39266_39278 = state_39257__$1;
(statearr_39266_39278[(1)] = (4));

(statearr_39266_39278[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39258 === (6))){
var inst_39249 = (state_39257[(2)]);
var inst_39250 = fluree.db.util.async.throw_err.call(null,inst_39249);
var state_39257__$1 = state_39257;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_39257__$1,(7),db_ch,inst_39250);
} else {
if((state_val_39258 === (7))){
var inst_39252 = (state_39257[(2)]);
var _ = (function (){var statearr_39267 = state_39257;
(statearr_39267[(4)] = cljs.core.rest.call(null,(state_39257[(4)])));

return statearr_39267;
})();
var state_39257__$1 = state_39257;
var statearr_39268_39279 = state_39257__$1;
(statearr_39268_39279[(2)] = inst_39252);

(statearr_39268_39279[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$reload_db_BANG__$_state_machine__10945__auto__ = null;
var fluree$db$session$reload_db_BANG__$_state_machine__10945__auto____0 = (function (){
var statearr_39269 = [null,null,null,null,null,null,null,null,null];
(statearr_39269[(0)] = fluree$db$session$reload_db_BANG__$_state_machine__10945__auto__);

(statearr_39269[(1)] = (1));

return statearr_39269;
});
var fluree$db$session$reload_db_BANG__$_state_machine__10945__auto____1 = (function (state_39257){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_39257);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e39270){var ex__10948__auto__ = e39270;
var statearr_39271_39280 = state_39257;
(statearr_39271_39280[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_39257[(4)]))){
var statearr_39272_39281 = state_39257;
(statearr_39272_39281[(1)] = cljs.core.first.call(null,(state_39257[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39282 = state_39257;
state_39257 = G__39282;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$session$reload_db_BANG__$_state_machine__10945__auto__ = function(state_39257){
switch(arguments.length){
case 0:
return fluree$db$session$reload_db_BANG__$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$session$reload_db_BANG__$_state_machine__10945__auto____1.call(this,state_39257);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$reload_db_BANG__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$reload_db_BANG__$_state_machine__10945__auto____0;
fluree$db$session$reload_db_BANG__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$reload_db_BANG__$_state_machine__10945__auto____1;
return fluree$db$session$reload_db_BANG__$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_39273 = f__11019__auto__.call(null);
(statearr_39273[(6)] = c__11018__auto___39274);

return statearr_39273;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


return db_ch;
});
/**
 * Gets the channel containing the current database from the session's state. If
 *   no database channel is cached then the current database is loaded form storage
 *   and a new channel containing it is cached. Returns the cached channel that
 *   will contain the current database
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(var_args){
var G__39284 = arguments.length;
switch (G__39284) {
case 1:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 = (function (p__39285){
var map__39286 = p__39285;
var map__39286__$1 = cljs.core.__destructure_map.call(null,map__39286);
var session = map__39286__$1;
var blank_db = cljs.core.get.call(null,map__39286__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
return fluree.db.session.current_db.call(null,session,blank_db);
}));

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2 = (function (p__39287,blank_db){
var map__39288 = p__39287;
var map__39288__$1 = cljs.core.__destructure_map.call(null,map__39288);
var session = map__39288__$1;
var conn = cljs.core.get.call(null,map__39288__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var state = cljs.core.get.call(null,map__39288__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
cljs.core.swap_BANG_.call(null,state,(function (s){
return cljs.core.update.call(null,cljs.core.assoc.call(null,s,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis.call(null)),new cljs.core.Keyword("req","count","req/count",2145574363),cljs.core.inc);
}));

var or__5045__auto__ = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var cur_ch = cljs.core.async.promise_chan.call(null);
var state_ch = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.call(null,state,(function (s){
if(cljs.core.not.call(null,new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(s))){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_ch);
} else {
return s;
}
})));
if(cljs.core._EQ_.call(null,cur_ch,state_ch)){
var c__11018__auto___39326 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_39308){
var state_val_39309 = (state_39308[(1)]);
if((state_val_39309 === (1))){
var state_39308__$1 = state_39308;
var statearr_39310_39327 = state_39308__$1;
(statearr_39310_39327[(2)] = null);

(statearr_39310_39327[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39309 === (2))){
var _ = (function (){var statearr_39311 = state_39308;
(statearr_39311[(4)] = cljs.core.cons.call(null,(5),(state_39308[(4)])));

return statearr_39311;
})();
var inst_39298 = fluree.db.session.load_current_db.call(null,conn,blank_db);
var state_39308__$1 = state_39308;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39308__$1,(6),inst_39298);
} else {
if((state_val_39309 === (3))){
var inst_39306 = (state_39308[(2)]);
var state_39308__$1 = state_39308;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39308__$1,inst_39306);
} else {
if((state_val_39309 === (4))){
var inst_39289 = (state_39308[(2)]);
var inst_39290 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_39291 = fluree.db.util.log.error.call(null,inst_39289,"Error loading current db");
var inst_39292 = cljs.core.async.put_BANG_.call(null,cur_ch,inst_39289);
var state_39308__$1 = (function (){var statearr_39313 = state_39308;
(statearr_39313[(7)] = inst_39291);

(statearr_39313[(8)] = inst_39290);

return statearr_39313;
})();
var statearr_39314_39328 = state_39308__$1;
(statearr_39314_39328[(2)] = inst_39292);

(statearr_39314_39328[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39309 === (5))){
var _ = (function (){var statearr_39315 = state_39308;
(statearr_39315[(4)] = cljs.core.rest.call(null,(state_39308[(4)])));

return statearr_39315;
})();
var state_39308__$1 = state_39308;
var ex39312 = (state_39308__$1[(2)]);
var statearr_39316_39329 = state_39308__$1;
(statearr_39316_39329[(5)] = ex39312);


var statearr_39317_39330 = state_39308__$1;
(statearr_39317_39330[(1)] = (4));

(statearr_39317_39330[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39309 === (6))){
var inst_39300 = (state_39308[(2)]);
var inst_39301 = fluree.db.util.async.throw_err.call(null,inst_39300);
var state_39308__$1 = state_39308;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_39308__$1,(7),cur_ch,inst_39301);
} else {
if((state_val_39309 === (7))){
var inst_39303 = (state_39308[(2)]);
var _ = (function (){var statearr_39318 = state_39308;
(statearr_39318[(4)] = cljs.core.rest.call(null,(state_39308[(4)])));

return statearr_39318;
})();
var state_39308__$1 = state_39308;
var statearr_39319_39331 = state_39308__$1;
(statearr_39319_39331[(2)] = inst_39303);

(statearr_39319_39331[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__10945__auto__ = null;
var fluree$db$session$state_machine__10945__auto____0 = (function (){
var statearr_39320 = [null,null,null,null,null,null,null,null,null];
(statearr_39320[(0)] = fluree$db$session$state_machine__10945__auto__);

(statearr_39320[(1)] = (1));

return statearr_39320;
});
var fluree$db$session$state_machine__10945__auto____1 = (function (state_39308){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_39308);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e39321){var ex__10948__auto__ = e39321;
var statearr_39322_39332 = state_39308;
(statearr_39322_39332[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_39308[(4)]))){
var statearr_39323_39333 = state_39308;
(statearr_39323_39333[(1)] = cljs.core.first.call(null,(state_39308[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39334 = state_39308;
state_39308 = G__39334;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$session$state_machine__10945__auto__ = function(state_39308){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__10945__auto____1.call(this,state_39308);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__10945__auto____0;
fluree$db$session$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__10945__auto____1;
return fluree$db$session$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_39324 = f__11019__auto__.call(null);
(statearr_39324[(6)] = c__11018__auto___39326);

return statearr_39324;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


return cur_ch;
} else {
return state_ch;
}
}
}));

(fluree.db.session.current_db.cljs$lang$maxFixedArity = 2);

/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),pc);
} else {
return s;
}
}));
var res_pc = new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.call(null,pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword("db","indexed","db/indexed",390759770),block);
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.call(null,cljs.cache.lru_cache_factory.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__5045__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.call(null,fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_.call(null,ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.call(null,ledger);
var network = cljs.core.namespace.call(null,ledger__$1);
var maybe_alias = cljs.core.name.call(null,ledger__$1);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.pr_str.call(null,ledger__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_.call(null,maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.call(null,maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id.call(null,network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__5641__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5642__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5643__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5644__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5645__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5645__auto__,method_table__5641__auto__,prefer_table__5642__auto__,method_cache__5643__auto__,cached_hierarchy__5644__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_39336){
var state_val_39337 = (state_39336[(1)]);
if((state_val_39337 === (1))){
var state_39336__$1 = state_39336;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39336__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__10945__auto__ = null;
var fluree$db$session$state_machine__10945__auto____0 = (function (){
var statearr_39338 = [null,null,null,null,null,null,null];
(statearr_39338[(0)] = fluree$db$session$state_machine__10945__auto__);

(statearr_39338[(1)] = (1));

return statearr_39338;
});
var fluree$db$session$state_machine__10945__auto____1 = (function (state_39336){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_39336);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e39339){var ex__10948__auto__ = e39339;
var statearr_39340_39343 = state_39336;
(statearr_39340_39343[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_39336[(4)]))){
var statearr_39341_39344 = state_39336;
(statearr_39341_39344[(1)] = cljs.core.first.call(null,(state_39336[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39345 = state_39336;
state_39336 = G__39345;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$session$state_machine__10945__auto__ = function(state_39336){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__10945__auto____1.call(this,state_39336);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__10945__auto____0;
fluree$db$session$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__10945__auto____1;
return fluree$db$session$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_39342 = f__11019__auto__.call(null);
(statearr_39342[(6)] = c__11018__auto__);

return statearr_39342;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__39346){
var map__39347 = p__39346;
var map__39347__$1 = cljs.core.__destructure_map.call(null,map__39347);
var data = map__39347__$1;
var block = cljs.core.get.call(null,map__39347__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__39347__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__39347__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_39406){
var state_val_39407 = (state_39406[(1)]);
if((state_val_39407 === (7))){
var inst_39358 = (state_39406[(7)]);
var inst_39361 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_39362 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_39363 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39361),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39362),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39358),". No-op."].join('');
var inst_39364 = fluree.db.util.log.info.call(null,inst_39363);
var state_39406__$1 = state_39406;
var statearr_39408_39442 = state_39406__$1;
(statearr_39408_39442[(2)] = inst_39364);

(statearr_39408_39442[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39407 === (1))){
var state_39406__$1 = state_39406;
var statearr_39409_39443 = state_39406__$1;
(statearr_39409_39443[(2)] = null);

(statearr_39409_39443[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39407 === (4))){
var inst_39348 = (state_39406[(2)]);
var state_39406__$1 = state_39406;
var statearr_39410_39444 = state_39406__$1;
(statearr_39410_39444[(2)] = inst_39348);

(statearr_39410_39444[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39407 === (15))){
var inst_39387 = (state_39406[(2)]);
var state_39406__$1 = state_39406;
var statearr_39411_39445 = state_39406__$1;
(statearr_39411_39445[(2)] = inst_39387);

(statearr_39411_39445[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39407 === (13))){
var inst_39378 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_39379 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39380 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_39381 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_39382 = [inst_39380,inst_39381];
var inst_39383 = (new cljs.core.PersistentVector(null,2,(5),inst_39379,inst_39382,null));
var inst_39384 = fluree.db.conn_events.process_event.call(null,inst_39378,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),inst_39383,data);
var state_39406__$1 = state_39406;
var statearr_39412_39446 = state_39406__$1;
(statearr_39412_39446[(2)] = inst_39384);

(statearr_39412_39446[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39407 === (6))){
var inst_39357 = (state_39406[(8)]);
var inst_39358 = (state_39406[(7)]);
var inst_39356 = (state_39406[(2)]);
var inst_39357__$1 = fluree.db.util.async.throw_err.call(null,inst_39356);
var inst_39358__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_39357__$1);
var inst_39359 = (block <= inst_39358__$1);
var state_39406__$1 = (function (){var statearr_39413 = state_39406;
(statearr_39413[(8)] = inst_39357__$1);

(statearr_39413[(7)] = inst_39358__$1);

return statearr_39413;
})();
if(cljs.core.truth_(inst_39359)){
var statearr_39414_39447 = state_39406__$1;
(statearr_39414_39447[(1)] = (7));

} else {
var statearr_39415_39448 = state_39406__$1;
(statearr_39415_39448[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39407 === (17))){
var state_39406__$1 = state_39406;
var statearr_39416_39449 = state_39406__$1;
(statearr_39416_39449[(2)] = null);

(statearr_39416_39449[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39407 === (3))){
var inst_39404 = (state_39406[(2)]);
var state_39406__$1 = state_39406;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39406__$1,inst_39404);
} else {
if((state_val_39407 === (12))){
var inst_39399 = (state_39406[(2)]);
var state_39406__$1 = state_39406;
var statearr_39417_39450 = state_39406__$1;
(statearr_39417_39450[(2)] = inst_39399);

(statearr_39417_39450[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39407 === (2))){
var inst_39354 = (state_39406[(9)]);
var _ = (function (){var statearr_39418 = state_39406;
(statearr_39418[(4)] = cljs.core.cons.call(null,(5),(state_39406[(4)])));

return statearr_39418;
})();
var inst_39354__$1 = fluree.db.session.current_db.call(null,session);
var state_39406__$1 = (function (){var statearr_39419 = state_39406;
(statearr_39419[(9)] = inst_39354__$1);

return statearr_39419;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39406__$1,(6),inst_39354__$1);
} else {
if((state_val_39407 === (11))){
var state_39406__$1 = state_39406;
var statearr_39421_39451 = state_39406__$1;
(statearr_39421_39451[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39407 === (9))){
var inst_39401 = (state_39406[(2)]);
var _ = (function (){var statearr_39423 = state_39406;
(statearr_39423[(4)] = cljs.core.rest.call(null,(state_39406[(4)])));

return statearr_39423;
})();
var state_39406__$1 = state_39406;
var statearr_39424_39452 = state_39406__$1;
(statearr_39424_39452[(2)] = inst_39401);

(statearr_39424_39452[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39407 === (5))){
var _ = (function (){var statearr_39425 = state_39406;
(statearr_39425[(4)] = cljs.core.rest.call(null,(state_39406[(4)])));

return statearr_39425;
})();
var state_39406__$1 = state_39406;
var ex39420 = (state_39406__$1[(2)]);
var statearr_39426_39453 = state_39406__$1;
(statearr_39426_39453[(5)] = ex39420);


if((ex39420 instanceof Error)){
var statearr_39427_39454 = state_39406__$1;
(statearr_39427_39454[(1)] = (4));

(statearr_39427_39454[(5)] = null);

} else {
throw ex39420;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39407 === (14))){
var state_39406__$1 = state_39406;
var statearr_39428_39455 = state_39406__$1;
(statearr_39428_39455[(2)] = null);

(statearr_39428_39455[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39407 === (16))){
var inst_39358 = (state_39406[(7)]);
var inst_39390 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_39391 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_39392 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39390),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39391),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39358),". Forcing a db reload."].join('');
var inst_39393 = fluree.db.util.log.info.call(null,inst_39392);
var inst_39394 = fluree.db.session.reload_db_BANG_.call(null,session);
var state_39406__$1 = (function (){var statearr_39429 = state_39406;
(statearr_39429[(10)] = inst_39393);

return statearr_39429;
})();
var statearr_39430_39456 = state_39406__$1;
(statearr_39430_39456[(2)] = inst_39394);

(statearr_39430_39456[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39407 === (10))){
var inst_39357 = (state_39406[(8)]);
var inst_39358 = (state_39406[(7)]);
var inst_39354 = (state_39406[(9)]);
var inst_39369 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_39370 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_39371 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39369),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39370),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_39372 = fluree.db.util.log.trace.call(null,inst_39371);
var inst_39373 = (function (){var current_db_ch = inst_39354;
var current_db = inst_39357;
var current_block = inst_39358;
return (function (f){
if((f instanceof fluree.db.flake.Flake)){
return f;
} else {
return fluree.db.flake.parts__GT_Flake.call(null,f);
}
});
})();
var inst_39374 = cljs.core.map.call(null,inst_39373,flakes);
var inst_39375 = fluree.db.dbproto._with.call(null,inst_39357,block,inst_39374);
var inst_39376 = fluree.db.session.cas_db_BANG_.call(null,session,inst_39354,inst_39375);
var state_39406__$1 = (function (){var statearr_39431 = state_39406;
(statearr_39431[(11)] = inst_39372);

return statearr_39431;
})();
if(inst_39376){
var statearr_39432_39457 = state_39406__$1;
(statearr_39432_39457[(1)] = (13));

} else {
var statearr_39433_39458 = state_39406__$1;
(statearr_39433_39458[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39407 === (18))){
var inst_39397 = (state_39406[(2)]);
var state_39406__$1 = state_39406;
var statearr_39434_39459 = state_39406__$1;
(statearr_39434_39459[(2)] = inst_39397);

(statearr_39434_39459[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39407 === (8))){
var inst_39358 = (state_39406[(7)]);
var inst_39366 = ((1) + inst_39358);
var inst_39367 = cljs.core._EQ_.call(null,block,inst_39366);
var state_39406__$1 = state_39406;
if(inst_39367){
var statearr_39435_39460 = state_39406__$1;
(statearr_39435_39460[(1)] = (10));

} else {
var statearr_39436_39461 = state_39406__$1;
(statearr_39436_39461[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__10945__auto__ = null;
var fluree$db$session$state_machine__10945__auto____0 = (function (){
var statearr_39437 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39437[(0)] = fluree$db$session$state_machine__10945__auto__);

(statearr_39437[(1)] = (1));

return statearr_39437;
});
var fluree$db$session$state_machine__10945__auto____1 = (function (state_39406){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_39406);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e39438){var ex__10948__auto__ = e39438;
var statearr_39439_39462 = state_39406;
(statearr_39439_39462[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_39406[(4)]))){
var statearr_39440_39463 = state_39406;
(statearr_39440_39463[(1)] = cljs.core.first.call(null,(state_39406[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39464 = state_39406;
state_39406 = G__39464;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$session$state_machine__10945__auto__ = function(state_39406){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__10945__auto____1.call(this,state_39406);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__10945__auto____0;
fluree$db$session$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__10945__auto____1;
return fluree$db$session$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_39441 = f__11019__auto__.call(null);
(statearr_39441[(6)] = c__11018__auto__);

return statearr_39441;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_39471){
var state_val_39472 = (state_39471[(1)]);
if((state_val_39472 === (1))){
var inst_39465 = fluree.db.session.clear_db_BANG_.call(null,session);
var inst_39466 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_39467 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_39468 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39466),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39467)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_39469 = fluree.db.util.log.debug.call(null,inst_39468);
var state_39471__$1 = (function (){var statearr_39473 = state_39471;
(statearr_39473[(7)] = inst_39465);

(statearr_39473[(8)] = inst_39469);

return statearr_39473;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39471__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__10945__auto__ = null;
var fluree$db$session$state_machine__10945__auto____0 = (function (){
var statearr_39474 = [null,null,null,null,null,null,null,null,null];
(statearr_39474[(0)] = fluree$db$session$state_machine__10945__auto__);

(statearr_39474[(1)] = (1));

return statearr_39474;
});
var fluree$db$session$state_machine__10945__auto____1 = (function (state_39471){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_39471);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e39475){var ex__10948__auto__ = e39475;
var statearr_39476_39479 = state_39471;
(statearr_39476_39479[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_39471[(4)]))){
var statearr_39477_39480 = state_39471;
(statearr_39477_39480[(1)] = cljs.core.first.call(null,(state_39471[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39481 = state_39471;
state_39471 = G__39481;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$session$state_machine__10945__auto__ = function(state_39471){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__10945__auto____1.call(this,state_39471);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__10945__auto____0;
fluree$db$session$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__10945__auto____1;
return fluree$db$session$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_39478 = f__11019__auto__.call(null);
(statearr_39478[(6)] = c__11018__auto__);

return statearr_39478;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__39483 = arguments.length;
switch (G__39483) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (p__39484){
var map__39485 = p__39484;
var map__39485__$1 = cljs.core.__destructure_map.call(null,map__39485);
var session = map__39485__$1;
var conn = cljs.core.get.call(null,map__39485__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.call(null,map__39485__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.call(null,map__39485__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.call(null,map__39485__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.call(null,map__39485__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__39485__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var id = cljs.core.get.call(null,map__39485__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.truth_(fluree.db.session.closed_QMARK_.call(null,session))){
fluree.db.session.remove_cache_BANG_.call(null,network,dbid);

return false;
} else {
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,dbid,id);

cljs.core.async.close_BANG_.call(null,update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_.call(null,transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_.call(null,network,dbid);

if(cljs.core.fn_QMARK_.call(null,new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session).call(null);
} else {
}

return true;
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5802__auto__ = fluree.db.session.from_cache.call(null,network,dbid);
if(cljs.core.truth_(temp__5802__auto__)){
var session = temp__5802__auto__;
return fluree.db.session.close.call(null,session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_39539){
var state_val_39540 = (state_39539[(1)]);
if((state_val_39540 === (7))){
var inst_39535 = (state_39539[(2)]);
var state_39539__$1 = state_39539;
var statearr_39541_39572 = state_39539__$1;
(statearr_39541_39572[(2)] = inst_39535);

(statearr_39541_39572[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39540 === (1))){
var state_39539__$1 = state_39539;
var statearr_39542_39573 = state_39539__$1;
(statearr_39542_39573[(2)] = null);

(statearr_39542_39573[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39540 === (4))){
var inst_39490 = (state_39539[(7)]);
var inst_39489 = (state_39539[(2)]);
var inst_39490__$1 = fluree.db.util.async.throw_err.call(null,inst_39489);
var inst_39491 = fluree.db.session.from_cache.call(null,network,ledger_id);
var inst_39492 = (inst_39490__$1 == null);
var state_39539__$1 = (function (){var statearr_39543 = state_39539;
(statearr_39543[(7)] = inst_39490__$1);

(statearr_39543[(8)] = inst_39491);

return statearr_39543;
})();
if(cljs.core.truth_(inst_39492)){
var statearr_39544_39574 = state_39539__$1;
(statearr_39544_39574[(1)] = (5));

} else {
var statearr_39545_39575 = state_39539__$1;
(statearr_39545_39575[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39540 === (15))){
var inst_39527 = (state_39539[(2)]);
var state_39539__$1 = (function (){var statearr_39546 = state_39539;
(statearr_39546[(9)] = inst_39527);

return statearr_39546;
})();
var statearr_39547_39576 = state_39539__$1;
(statearr_39547_39576[(2)] = null);

(statearr_39547_39576[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39540 === (13))){
var inst_39531 = (state_39539[(2)]);
var state_39539__$1 = state_39539;
var statearr_39549_39577 = state_39539__$1;
(statearr_39549_39577[(2)] = inst_39531);

(statearr_39549_39577[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39540 === (6))){
var inst_39491 = (state_39539[(8)]);
var inst_39497 = (inst_39491 == null);
var state_39539__$1 = state_39539;
if(cljs.core.truth_(inst_39497)){
var statearr_39550_39578 = state_39539__$1;
(statearr_39550_39578[(1)] = (8));

} else {
var statearr_39551_39579 = state_39539__$1;
(statearr_39551_39579[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39540 === (17))){
var _ = (function (){var statearr_39552 = state_39539;
(statearr_39552[(4)] = cljs.core.rest.call(null,(state_39539[(4)])));

return statearr_39552;
})();
var state_39539__$1 = state_39539;
var ex39548 = (state_39539__$1[(2)]);
var statearr_39553_39580 = state_39539__$1;
(statearr_39553_39580[(5)] = ex39548);


var statearr_39554_39581 = state_39539__$1;
(statearr_39554_39581[(1)] = (16));

(statearr_39554_39581[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39540 === (3))){
var inst_39537 = (state_39539[(2)]);
var state_39539__$1 = state_39539;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39539__$1,inst_39537);
} else {
if((state_val_39540 === (12))){
var state_39539__$1 = state_39539;
var statearr_39555_39582 = state_39539__$1;
(statearr_39555_39582[(2)] = null);

(statearr_39555_39582[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39540 === (2))){
var state_39539__$1 = state_39539;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39539__$1,(4),update_chan);
} else {
if((state_val_39540 === (11))){
var state_39539__$1 = state_39539;
var statearr_39556_39583 = state_39539__$1;
(statearr_39556_39583[(2)] = null);

(statearr_39556_39583[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39540 === (9))){
var state_39539__$1 = state_39539;
var statearr_39557_39584 = state_39539__$1;
(statearr_39557_39584[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39540 === (5))){
var inst_39494 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_39495 = fluree.db.util.log.info.call(null,inst_39494);
var state_39539__$1 = state_39539;
var statearr_39559_39585 = state_39539__$1;
(statearr_39559_39585[(2)] = inst_39495);

(statearr_39559_39585[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39540 === (14))){
var inst_39490 = (state_39539[(7)]);
var inst_39491 = (state_39539[(8)]);
var _ = (function (){var statearr_39560 = state_39539;
(statearr_39560[(4)] = cljs.core.cons.call(null,(17),(state_39539[(4)])));

return statearr_39560;
})();
var inst_39515 = cljs.core.nth.call(null,inst_39490,(0),null);
var inst_39516 = cljs.core.nth.call(null,inst_39490,(1),null);
var inst_39517 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_39518 = cljs.core.pr_str.call(null,inst_39490);
var inst_39519 = fluree.db.util.core.trunc.call(null,inst_39518,(200));
var inst_39520 = fluree.db.util.log.trace.call(null,inst_39517,inst_39519);
var inst_39521 = fluree.db.session.process_ledger_update.call(null,inst_39491,inst_39515,inst_39516);
var state_39539__$1 = (function (){var statearr_39561 = state_39539;
(statearr_39561[(10)] = inst_39520);

return statearr_39561;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39539__$1,(18),inst_39521);
} else {
if((state_val_39540 === (16))){
var inst_39490 = (state_39539[(7)]);
var inst_39505 = (state_39539[(2)]);
var inst_39506 = fluree.db.util.log.error.call(null,inst_39505,"Exception processing ledger updates for message: ",inst_39490);
var state_39539__$1 = state_39539;
var statearr_39562_39586 = state_39539__$1;
(statearr_39562_39586[(2)] = inst_39506);

(statearr_39562_39586[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39540 === (10))){
var inst_39533 = (state_39539[(2)]);
var state_39539__$1 = state_39539;
var statearr_39563_39587 = state_39539__$1;
(statearr_39563_39587[(2)] = inst_39533);

(statearr_39563_39587[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39540 === (18))){
var inst_39523 = (state_39539[(2)]);
var inst_39524 = fluree.db.util.async.throw_err.call(null,inst_39523);
var _ = (function (){var statearr_39564 = state_39539;
(statearr_39564[(4)] = cljs.core.rest.call(null,(state_39539[(4)])));

return statearr_39564;
})();
var state_39539__$1 = state_39539;
var statearr_39565_39588 = state_39539__$1;
(statearr_39565_39588[(2)] = inst_39524);

(statearr_39565_39588[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39540 === (8))){
var inst_39490 = (state_39539[(7)]);
var inst_39499 = cljs.core.first.call(null,inst_39490);
var inst_39500 = cljs.core.pr_str.call(null,inst_39499);
var inst_39501 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_39500].join('');
var inst_39502 = fluree.db.util.log.warn.call(null,inst_39501);
var state_39539__$1 = state_39539;
var statearr_39566_39589 = state_39539__$1;
(statearr_39566_39589[(2)] = inst_39502);

(statearr_39566_39589[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__10945__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__10945__auto____0 = (function (){
var statearr_39567 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_39567[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__10945__auto__);

(statearr_39567[(1)] = (1));

return statearr_39567;
});
var fluree$db$session$process_ledger_updates_$_state_machine__10945__auto____1 = (function (state_39539){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_39539);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e39568){var ex__10948__auto__ = e39568;
var statearr_39569_39590 = state_39539;
(statearr_39569_39590[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_39539[(4)]))){
var statearr_39570_39591 = state_39539;
(statearr_39570_39591[(1)] = cljs.core.first.call(null,(state_39539[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39592 = state_39539;
state_39539 = G__39592;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__10945__auto__ = function(state_39539){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__10945__auto____1.call(this,state_39539);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__10945__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__10945__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_39571 = f__11019__auto__.call(null);
(statearr_39571[(6)] = c__11018__auto__);

return statearr_39571;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Creates a connection without first checking if one already exists. Only useful
 *   if reloading and replacing an existing session.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__39593){
var map__39594 = p__39593;
var map__39594__$1 = cljs.core.__destructure_map.call(null,map__39594);
var network = cljs.core.get.call(null,map__39594__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__39594__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var dbid = cljs.core.get.call(null,map__39594__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var db = cljs.core.get.call(null,map__39594__$1,new cljs.core.Keyword(null,"db","db",993250759));
var transactor_QMARK_ = cljs.core.get.call(null,map__39594__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.call(null,map__39594__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.call(null,map__39594__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.call(null,map__39594__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.call(null,map__39594__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cur_db = (cljs.core.truth_(db)?cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null);
var state__$1 = cljs.core.atom.call(null,cljs.core.merge.call(null,state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_db,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)));
var session = fluree.db.session.map__GT_DbSession.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[dbid,cljs.core.async.chan.call(null),db_name,state__$1,close,id,schema_cache,(cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.call(null):null),network,null,conn]));
var current_db_fn = cljs.core.partial.call(null,fluree.db.session.current_db,session);
var blank_db = fluree.db.graphdb.blank_db.call(null,conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.call(null,session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__39598 = block_result;
var map__39598__$1 = cljs.core.__destructure_map.call(null,map__39598);
var block = cljs.core.get.call(null,map__39598__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.call(null,map__39598__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.call(null,map__39598__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.call(null,map__39598__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.call(null,map__39598__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__5045__auto__ = cljs.core.get.call(null,txns,cljs.core.keyword.call(null,txid));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.call(null,["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.call(null,block_result)], null))})());
var map__39599 = tx_result;
var map__39599__$1 = cljs.core.__destructure_map.call(null,map__39599);
var t = cljs.core.get.call(null,map__39599__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.call(null,map__39599__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first.call(null,flakes) instanceof fluree.db.flake.Flake))?(function (p1__39595_SHARP_){
return cljs.core._EQ_.call(null,t,p1__39595_SHARP_.t);
}):(function (p1__39596_SHARP_){
return cljs.core._EQ_.call(null,t,cljs.core.nth.call(null,p1__39596_SHARP_,(3)));
}));
var response = cljs.core.assoc.call(null,tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.call(null,t_filter,flakes));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some.call(null,(function (p1__39597_SHARP_){
if(cljs.core._EQ_.call(null,(109),cljs.core.second.call(null,p1__39597_SHARP_))){
return cljs.core.nth.call(null,p1__39597_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__39600 = (cljs.core.truth_(error_msg)?cljs.core.re_find.call(null,/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.call(null,vec__39600,(0),null);
var status__$1 = cljs.core.nth.call(null,vec__39600,(1),null);
var error = cljs.core.nth.call(null,vec__39600,(2),null);
var message = cljs.core.nth.call(null,vec__39600,(3),null);
return cljs.core.ex_info.call(null,(function (){var or__5045__auto__ = message;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.call(null,error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
fluree.db.util.log.trace.call(null,"Create and cache session. Opt keys: ",cljs.core.keys.call(null,opts));

var id = cljs.core.keyword.call(null,"session",cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null)),(0),(7)));
var session = fluree.db.session.session_factory.call(null,cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_.call(null,session);
var new_QMARK_ = cljs.core._EQ_.call(null,id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.call(null,session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__39604 = arguments.length;
switch (G__39604) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.call(null,conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__39605){
var map__39606 = p__39605;
var map__39606__$1 = cljs.core.__destructure_map.call(null,map__39606);
var state = cljs.core.get.call(null,map__39606__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.call(null,map__39606__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.call(null,map__39606__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__39606__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__39607 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__39607,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__39607,(1),null);
var ledger_alias = cljs.core.nth.call(null,vec__39607,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__5045__auto__ = fluree.db.session.from_cache.call(null,network,ledger_id);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var session = fluree.db.session.create_and_cache_session.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__5045__auto____$1 = state;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.call(null,session,opts);

new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,ledger_id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session),(function (event_type,event_data){
cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5804__auto__ = cljs.core.not_empty.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5804__auto__)){
var tx_callbacks = temp__5804__auto__;
var tids = cljs.core.keys.call(null,new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__39610 = cljs.core.seq.call(null,tids);
var chunk__39611 = null;
var count__39612 = (0);
var i__39613 = (0);
while(true){
if((i__39613 < count__39612)){
var tid = cljs.core._nth.call(null,chunk__39611,i__39613);
var temp__5804__auto___39726__$1 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5804__auto___39726__$1)){
var keyed_callbacks_39727 = temp__5804__auto___39726__$1;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_39728 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__39654_39729 = cljs.core.seq.call(null,keyed_callbacks_39727);
var chunk__39655_39730 = null;
var count__39656_39731 = (0);
var i__39657_39732 = (0);
while(true){
if((i__39657_39732 < count__39656_39731)){
var vec__39666_39733 = cljs.core._nth.call(null,chunk__39655_39730,i__39657_39732);
var k_39734 = cljs.core.nth.call(null,vec__39666_39733,(0),null);
var f_39735 = cljs.core.nth.call(null,vec__39666_39733,(1),null);
try{f_39735.call(null,tx_response_39728);
}catch (e39669){var e_39736 = e39669;
fluree.db.util.log.error.call(null,e_39736,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__39737 = seq__39654_39729;
var G__39738 = chunk__39655_39730;
var G__39739 = count__39656_39731;
var G__39740 = (i__39657_39732 + (1));
seq__39654_39729 = G__39737;
chunk__39655_39730 = G__39738;
count__39656_39731 = G__39739;
i__39657_39732 = G__39740;
continue;
} else {
var temp__5804__auto___39741__$2 = cljs.core.seq.call(null,seq__39654_39729);
if(temp__5804__auto___39741__$2){
var seq__39654_39742__$1 = temp__5804__auto___39741__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__39654_39742__$1)){
var c__5567__auto___39743 = cljs.core.chunk_first.call(null,seq__39654_39742__$1);
var G__39744 = cljs.core.chunk_rest.call(null,seq__39654_39742__$1);
var G__39745 = c__5567__auto___39743;
var G__39746 = cljs.core.count.call(null,c__5567__auto___39743);
var G__39747 = (0);
seq__39654_39729 = G__39744;
chunk__39655_39730 = G__39745;
count__39656_39731 = G__39746;
i__39657_39732 = G__39747;
continue;
} else {
var vec__39670_39748 = cljs.core.first.call(null,seq__39654_39742__$1);
var k_39749 = cljs.core.nth.call(null,vec__39670_39748,(0),null);
var f_39750 = cljs.core.nth.call(null,vec__39670_39748,(1),null);
try{f_39750.call(null,tx_response_39728);
}catch (e39673){var e_39751 = e39673;
fluree.db.util.log.error.call(null,e_39751,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__39752 = cljs.core.next.call(null,seq__39654_39742__$1);
var G__39753 = null;
var G__39754 = (0);
var G__39755 = (0);
seq__39654_39729 = G__39752;
chunk__39655_39730 = G__39753;
count__39656_39731 = G__39754;
i__39657_39732 = G__39755;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__39756 = seq__39610;
var G__39757 = chunk__39611;
var G__39758 = count__39612;
var G__39759 = (i__39613 + (1));
seq__39610 = G__39756;
chunk__39611 = G__39757;
count__39612 = G__39758;
i__39613 = G__39759;
continue;
} else {
var temp__5804__auto____$1 = cljs.core.seq.call(null,seq__39610);
if(temp__5804__auto____$1){
var seq__39610__$1 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__39610__$1)){
var c__5567__auto__ = cljs.core.chunk_first.call(null,seq__39610__$1);
var G__39760 = cljs.core.chunk_rest.call(null,seq__39610__$1);
var G__39761 = c__5567__auto__;
var G__39762 = cljs.core.count.call(null,c__5567__auto__);
var G__39763 = (0);
seq__39610 = G__39760;
chunk__39611 = G__39761;
count__39612 = G__39762;
i__39613 = G__39763;
continue;
} else {
var tid = cljs.core.first.call(null,seq__39610__$1);
var temp__5804__auto___39764__$2 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5804__auto___39764__$2)){
var keyed_callbacks_39765 = temp__5804__auto___39764__$2;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_39766 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__39674_39767 = cljs.core.seq.call(null,keyed_callbacks_39765);
var chunk__39675_39768 = null;
var count__39676_39769 = (0);
var i__39677_39770 = (0);
while(true){
if((i__39677_39770 < count__39676_39769)){
var vec__39686_39771 = cljs.core._nth.call(null,chunk__39675_39768,i__39677_39770);
var k_39772 = cljs.core.nth.call(null,vec__39686_39771,(0),null);
var f_39773 = cljs.core.nth.call(null,vec__39686_39771,(1),null);
try{f_39773.call(null,tx_response_39766);
}catch (e39689){var e_39774 = e39689;
fluree.db.util.log.error.call(null,e_39774,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__39775 = seq__39674_39767;
var G__39776 = chunk__39675_39768;
var G__39777 = count__39676_39769;
var G__39778 = (i__39677_39770 + (1));
seq__39674_39767 = G__39775;
chunk__39675_39768 = G__39776;
count__39676_39769 = G__39777;
i__39677_39770 = G__39778;
continue;
} else {
var temp__5804__auto___39779__$3 = cljs.core.seq.call(null,seq__39674_39767);
if(temp__5804__auto___39779__$3){
var seq__39674_39780__$1 = temp__5804__auto___39779__$3;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__39674_39780__$1)){
var c__5567__auto___39781 = cljs.core.chunk_first.call(null,seq__39674_39780__$1);
var G__39782 = cljs.core.chunk_rest.call(null,seq__39674_39780__$1);
var G__39783 = c__5567__auto___39781;
var G__39784 = cljs.core.count.call(null,c__5567__auto___39781);
var G__39785 = (0);
seq__39674_39767 = G__39782;
chunk__39675_39768 = G__39783;
count__39676_39769 = G__39784;
i__39677_39770 = G__39785;
continue;
} else {
var vec__39690_39786 = cljs.core.first.call(null,seq__39674_39780__$1);
var k_39787 = cljs.core.nth.call(null,vec__39690_39786,(0),null);
var f_39788 = cljs.core.nth.call(null,vec__39690_39786,(1),null);
try{f_39788.call(null,tx_response_39766);
}catch (e39693){var e_39789 = e39693;
fluree.db.util.log.error.call(null,e_39789,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__39790 = cljs.core.next.call(null,seq__39674_39780__$1);
var G__39791 = null;
var G__39792 = (0);
var G__39793 = (0);
seq__39674_39767 = G__39790;
chunk__39675_39768 = G__39791;
count__39676_39769 = G__39792;
i__39677_39770 = G__39793;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__39794 = cljs.core.next.call(null,seq__39610__$1);
var G__39795 = null;
var G__39796 = (0);
var G__39797 = (0);
seq__39610 = G__39794;
chunk__39611 = G__39795;
count__39612 = G__39796;
i__39613 = G__39797;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}));

fluree.db.session.process_ledger_updates.call(null,conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_39798 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__11018__auto___39799 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_39710){
var state_val_39711 = (state_39710[(1)]);
if((state_val_39711 === (1))){
var state_39710__$1 = state_39710;
var statearr_39712_39800 = state_39710__$1;
(statearr_39712_39800[(2)] = null);

(statearr_39712_39800[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39711 === (2))){
var inst_39695 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_39710__$1 = state_39710;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39710__$1,(4),inst_39695);
} else {
if((state_val_39711 === (3))){
var inst_39708 = (state_39710[(2)]);
var state_39710__$1 = state_39710;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39710__$1,inst_39708);
} else {
if((state_val_39711 === (4))){
var inst_39697 = (state_39710[(7)]);
var inst_39697__$1 = (state_39710[(2)]);
var inst_39698 = (inst_39697__$1 == null);
var state_39710__$1 = (function (){var statearr_39713 = state_39710;
(statearr_39713[(7)] = inst_39697__$1);

return statearr_39713;
})();
if(cljs.core.truth_(inst_39698)){
var statearr_39714_39801 = state_39710__$1;
(statearr_39714_39801[(1)] = (5));

} else {
var statearr_39715_39802 = state_39710__$1;
(statearr_39715_39802[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39711 === (5))){
var inst_39700 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_39701 = fluree.db.util.log.info.call(null,inst_39700);
var state_39710__$1 = state_39710;
var statearr_39716_39803 = state_39710__$1;
(statearr_39716_39803[(2)] = inst_39701);

(statearr_39716_39803[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39711 === (6))){
var inst_39697 = (state_39710[(7)]);
var inst_39703 = transact_handler_39798.call(null,conn,inst_39697);
var state_39710__$1 = (function (){var statearr_39717 = state_39710;
(statearr_39717[(8)] = inst_39703);

return statearr_39717;
})();
var statearr_39718_39804 = state_39710__$1;
(statearr_39718_39804[(2)] = null);

(statearr_39718_39804[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39711 === (7))){
var inst_39706 = (state_39710[(2)]);
var state_39710__$1 = state_39710;
var statearr_39719_39805 = state_39710__$1;
(statearr_39719_39805[(2)] = inst_39706);

(statearr_39719_39805[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__10945__auto__ = null;
var fluree$db$session$state_machine__10945__auto____0 = (function (){
var statearr_39720 = [null,null,null,null,null,null,null,null,null];
(statearr_39720[(0)] = fluree$db$session$state_machine__10945__auto__);

(statearr_39720[(1)] = (1));

return statearr_39720;
});
var fluree$db$session$state_machine__10945__auto____1 = (function (state_39710){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_39710);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e39721){var ex__10948__auto__ = e39721;
var statearr_39722_39806 = state_39710;
(statearr_39722_39806[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_39710[(4)]))){
var statearr_39723_39807 = state_39710;
(statearr_39723_39807[(1)] = cljs.core.first.call(null,(state_39710[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39808 = state_39710;
state_39710 = G__39808;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$session$state_machine__10945__auto__ = function(state_39710){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__10945__auto____1.call(this,state_39710);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__10945__auto____0;
fluree$db$session$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__10945__auto____1;
return fluree$db$session$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_39724 = f__11019__auto__.call(null);
(statearr_39724[(6)] = c__11018__auto___39799);

return statearr_39724;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.call(null,conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.call(null,conn,ledger,opts);
return fluree.db.session.current_db.call(null,session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__39811 = arguments.length;
switch (G__39811) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.call(null,null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__39812 = cljs.core.vals.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.call(null,(function (p1__39809_SHARP_){
return cljs.core._EQ_.call(null,conn_id,cljs.core.get_in.call(null,p1__39809_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__39812);
} else {
return G__39812;
}
})();
var seq__39813 = cljs.core.seq.call(null,sessions);
var chunk__39814 = null;
var count__39815 = (0);
var i__39816 = (0);
while(true){
if((i__39816 < count__39815)){
var session = cljs.core._nth.call(null,chunk__39814,i__39816);
fluree.db.session.close.call(null,session);


var G__39818 = seq__39813;
var G__39819 = chunk__39814;
var G__39820 = count__39815;
var G__39821 = (i__39816 + (1));
seq__39813 = G__39818;
chunk__39814 = G__39819;
count__39815 = G__39820;
i__39816 = G__39821;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__39813);
if(temp__5804__auto__){
var seq__39813__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__39813__$1)){
var c__5567__auto__ = cljs.core.chunk_first.call(null,seq__39813__$1);
var G__39822 = cljs.core.chunk_rest.call(null,seq__39813__$1);
var G__39823 = c__5567__auto__;
var G__39824 = cljs.core.count.call(null,c__5567__auto__);
var G__39825 = (0);
seq__39813 = G__39822;
chunk__39814 = G__39823;
count__39815 = G__39824;
i__39816 = G__39825;
continue;
} else {
var session = cljs.core.first.call(null,seq__39813__$1);
fluree.db.session.close.call(null,session);


var G__39826 = cljs.core.next.call(null,seq__39813__$1);
var G__39827 = null;
var G__39828 = (0);
var G__39829 = (0);
seq__39813 = G__39826;
chunk__39814 = G__39827;
count__39815 = G__39828;
i__39816 = G__39829;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.call(null,"Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.call(null,pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_.call(null,cljs.core.get.call(null,updated,tid))){
return cljs.core.dissoc.call(null,updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
