// Compiled by ClojureScript 1.11.57 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return storage_exists_fn.call(null,key);
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return storage_read_fn.call(null,key);
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return storage_write_fn.call(null,key,val);
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name.call(null,idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_28190){
var state_val_28191 = (state_28190[(1)]);
if((state_val_28191 === (7))){
var inst_28179 = (state_28190[(7)]);
var inst_28181 = fluree.db.storage.core.serde.call(null,conn);
var inst_28182 = fluree.db.serde.protocol._deserialize_block.call(null,inst_28181,inst_28179);
var state_28190__$1 = state_28190;
var statearr_28192_28211 = state_28190__$1;
(statearr_28192_28211[(2)] = inst_28182);

(statearr_28192_28211[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28191 === (1))){
var state_28190__$1 = state_28190;
var statearr_28193_28212 = state_28190__$1;
(statearr_28193_28212[(2)] = null);

(statearr_28193_28212[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28191 === (4))){
var inst_28169 = (state_28190[(2)]);
var state_28190__$1 = state_28190;
var statearr_28194_28213 = state_28190__$1;
(statearr_28194_28213[(2)] = inst_28169);

(statearr_28194_28213[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28191 === (6))){
var inst_28179 = (state_28190[(7)]);
var inst_28178 = (state_28190[(2)]);
var inst_28179__$1 = fluree.db.util.async.throw_err.call(null,inst_28178);
var state_28190__$1 = (function (){var statearr_28195 = state_28190;
(statearr_28195[(7)] = inst_28179__$1);

return statearr_28195;
})();
if(cljs.core.truth_(inst_28179__$1)){
var statearr_28196_28214 = state_28190__$1;
(statearr_28196_28214[(1)] = (7));

} else {
var statearr_28197_28215 = state_28190__$1;
(statearr_28197_28215[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28191 === (3))){
var inst_28188 = (state_28190[(2)]);
var state_28190__$1 = state_28190;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28190__$1,inst_28188);
} else {
if((state_val_28191 === (2))){
var _ = (function (){var statearr_28199 = state_28190;
(statearr_28199[(4)] = cljs.core.cons.call(null,(5),(state_28190[(4)])));

return statearr_28199;
})();
var inst_28175 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_28176 = fluree.db.storage.core.storage_read.call(null,conn,inst_28175);
var state_28190__$1 = state_28190;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28190__$1,(6),inst_28176);
} else {
if((state_val_28191 === (9))){
var inst_28185 = (state_28190[(2)]);
var _ = (function (){var statearr_28200 = state_28190;
(statearr_28200[(4)] = cljs.core.rest.call(null,(state_28190[(4)])));

return statearr_28200;
})();
var state_28190__$1 = state_28190;
var statearr_28201_28216 = state_28190__$1;
(statearr_28201_28216[(2)] = inst_28185);

(statearr_28201_28216[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28191 === (5))){
var _ = (function (){var statearr_28202 = state_28190;
(statearr_28202[(4)] = cljs.core.rest.call(null,(state_28190[(4)])));

return statearr_28202;
})();
var state_28190__$1 = state_28190;
var ex28198 = (state_28190__$1[(2)]);
var statearr_28203_28217 = state_28190__$1;
(statearr_28203_28217[(5)] = ex28198);


if((ex28198 instanceof Error)){
var statearr_28204_28218 = state_28190__$1;
(statearr_28204_28218[(1)] = (4));

(statearr_28204_28218[(5)] = null);

} else {
throw ex28198;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28191 === (8))){
var state_28190__$1 = state_28190;
var statearr_28205_28219 = state_28190__$1;
(statearr_28205_28219[(2)] = null);

(statearr_28205_28219[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__10945__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__10945__auto____0 = (function (){
var statearr_28206 = [null,null,null,null,null,null,null,null];
(statearr_28206[(0)] = fluree$db$storage$core$read_block_$_state_machine__10945__auto__);

(statearr_28206[(1)] = (1));

return statearr_28206;
});
var fluree$db$storage$core$read_block_$_state_machine__10945__auto____1 = (function (state_28190){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_28190);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e28207){var ex__10948__auto__ = e28207;
var statearr_28208_28220 = state_28190;
(statearr_28208_28220[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_28190[(4)]))){
var statearr_28209_28221 = state_28190;
(statearr_28209_28221[(1)] = cljs.core.first.call(null,(state_28190[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28222 = state_28190;
state_28190 = G__28222;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__10945__auto__ = function(state_28190){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__10945__auto____1.call(this,state_28190);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__10945__auto____0;
fluree$db$storage$core$read_block_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__10945__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_28210 = f__11019__auto__.call(null);
(statearr_28210[(6)] = c__11018__auto__);

return statearr_28210;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_28245){
var state_val_28246 = (state_28245[(1)]);
if((state_val_28246 === (7))){
var inst_28234 = (state_28245[(7)]);
var inst_28236 = fluree.db.storage.core.serde.call(null,conn);
var inst_28237 = fluree.db.serde.protocol._deserialize_block.call(null,inst_28236,inst_28234);
var state_28245__$1 = state_28245;
var statearr_28247_28266 = state_28245__$1;
(statearr_28247_28266[(2)] = inst_28237);

(statearr_28247_28266[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28246 === (1))){
var state_28245__$1 = state_28245;
var statearr_28248_28267 = state_28245__$1;
(statearr_28248_28267[(2)] = null);

(statearr_28248_28267[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28246 === (4))){
var inst_28223 = (state_28245[(2)]);
var state_28245__$1 = state_28245;
var statearr_28249_28268 = state_28245__$1;
(statearr_28249_28268[(2)] = inst_28223);

(statearr_28249_28268[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28246 === (6))){
var inst_28234 = (state_28245[(7)]);
var inst_28233 = (state_28245[(2)]);
var inst_28234__$1 = fluree.db.util.async.throw_err.call(null,inst_28233);
var state_28245__$1 = (function (){var statearr_28250 = state_28245;
(statearr_28250[(7)] = inst_28234__$1);

return statearr_28250;
})();
if(cljs.core.truth_(inst_28234__$1)){
var statearr_28251_28269 = state_28245__$1;
(statearr_28251_28269[(1)] = (7));

} else {
var statearr_28252_28270 = state_28245__$1;
(statearr_28252_28270[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28246 === (3))){
var inst_28243 = (state_28245[(2)]);
var state_28245__$1 = state_28245;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28245__$1,inst_28243);
} else {
if((state_val_28246 === (2))){
var _ = (function (){var statearr_28254 = state_28245;
(statearr_28254[(4)] = cljs.core.cons.call(null,(5),(state_28245[(4)])));

return statearr_28254;
})();
var inst_28229 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_28230 = [inst_28229,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_28231 = fluree.db.storage.core.storage_read.call(null,conn,inst_28230);
var state_28245__$1 = state_28245;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28245__$1,(6),inst_28231);
} else {
if((state_val_28246 === (9))){
var inst_28240 = (state_28245[(2)]);
var _ = (function (){var statearr_28255 = state_28245;
(statearr_28255[(4)] = cljs.core.rest.call(null,(state_28245[(4)])));

return statearr_28255;
})();
var state_28245__$1 = state_28245;
var statearr_28256_28271 = state_28245__$1;
(statearr_28256_28271[(2)] = inst_28240);

(statearr_28256_28271[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28246 === (5))){
var _ = (function (){var statearr_28257 = state_28245;
(statearr_28257[(4)] = cljs.core.rest.call(null,(state_28245[(4)])));

return statearr_28257;
})();
var state_28245__$1 = state_28245;
var ex28253 = (state_28245__$1[(2)]);
var statearr_28258_28272 = state_28245__$1;
(statearr_28258_28272[(5)] = ex28253);


if((ex28253 instanceof Error)){
var statearr_28259_28273 = state_28245__$1;
(statearr_28259_28273[(1)] = (4));

(statearr_28259_28273[(5)] = null);

} else {
throw ex28253;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28246 === (8))){
var state_28245__$1 = state_28245;
var statearr_28260_28274 = state_28245__$1;
(statearr_28260_28274[(2)] = null);

(statearr_28260_28274[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__10945__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__10945__auto____0 = (function (){
var statearr_28261 = [null,null,null,null,null,null,null,null];
(statearr_28261[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__10945__auto__);

(statearr_28261[(1)] = (1));

return statearr_28261;
});
var fluree$db$storage$core$read_block_version_$_state_machine__10945__auto____1 = (function (state_28245){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_28245);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e28262){var ex__10948__auto__ = e28262;
var statearr_28263_28275 = state_28245;
(statearr_28263_28275[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_28245[(4)]))){
var statearr_28264_28276 = state_28245;
(statearr_28264_28276[(1)] = cljs.core.first.call(null,(state_28245[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28277 = state_28245;
state_28245 = G__28277;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__10945__auto__ = function(state_28245){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__10945__auto____1.call(this,state_28245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__10945__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__10945__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_28265 = f__11019__auto__.call(null);
(statearr_28265[(6)] = c__11018__auto__);

return statearr_28265;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_28301){
var state_val_28302 = (state_28301[(1)]);
if((state_val_28302 === (1))){
var state_28301__$1 = state_28301;
var statearr_28303_28317 = state_28301__$1;
(statearr_28303_28317[(2)] = null);

(statearr_28303_28317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28302 === (2))){
var _ = (function (){var statearr_28304 = state_28301;
(statearr_28304[(4)] = cljs.core.cons.call(null,(5),(state_28301[(4)])));

return statearr_28304;
})();
var inst_28284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28285 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_28286 = (new cljs.core.PersistentVector(null,3,(5),inst_28284,inst_28285,null));
var inst_28287 = cljs.core.select_keys.call(null,block_data,inst_28286);
var inst_28288 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_28287);
var inst_28289 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_28288);
var inst_28290 = [inst_28289,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_28291 = fluree.db.storage.core.serde.call(null,conn);
var inst_28292 = fluree.db.serde.protocol._serialize_block.call(null,inst_28291,inst_28287);
var inst_28293 = fluree.db.storage.core.storage_write.call(null,conn,inst_28290,inst_28292);
var state_28301__$1 = state_28301;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28301__$1,(6),inst_28293);
} else {
if((state_val_28302 === (3))){
var inst_28299 = (state_28301[(2)]);
var state_28301__$1 = state_28301;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28301__$1,inst_28299);
} else {
if((state_val_28302 === (4))){
var inst_28278 = (state_28301[(2)]);
var state_28301__$1 = state_28301;
var statearr_28306_28318 = state_28301__$1;
(statearr_28306_28318[(2)] = inst_28278);

(statearr_28306_28318[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28302 === (5))){
var _ = (function (){var statearr_28307 = state_28301;
(statearr_28307[(4)] = cljs.core.rest.call(null,(state_28301[(4)])));

return statearr_28307;
})();
var state_28301__$1 = state_28301;
var ex28305 = (state_28301__$1[(2)]);
var statearr_28308_28319 = state_28301__$1;
(statearr_28308_28319[(5)] = ex28305);


if((ex28305 instanceof Error)){
var statearr_28309_28320 = state_28301__$1;
(statearr_28309_28320[(1)] = (4));

(statearr_28309_28320[(5)] = null);

} else {
throw ex28305;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28302 === (6))){
var inst_28295 = (state_28301[(2)]);
var inst_28296 = fluree.db.util.async.throw_err.call(null,inst_28295);
var _ = (function (){var statearr_28310 = state_28301;
(statearr_28310[(4)] = cljs.core.rest.call(null,(state_28301[(4)])));

return statearr_28310;
})();
var state_28301__$1 = state_28301;
var statearr_28311_28321 = state_28301__$1;
(statearr_28311_28321[(2)] = inst_28296);

(statearr_28311_28321[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__10945__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__10945__auto____0 = (function (){
var statearr_28312 = [null,null,null,null,null,null,null];
(statearr_28312[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__10945__auto__);

(statearr_28312[(1)] = (1));

return statearr_28312;
});
var fluree$db$storage$core$write_block_version_$_state_machine__10945__auto____1 = (function (state_28301){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_28301);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e28313){var ex__10948__auto__ = e28313;
var statearr_28314_28322 = state_28301;
(statearr_28314_28322[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_28301[(4)]))){
var statearr_28315_28323 = state_28301;
(statearr_28315_28323[(1)] = cljs.core.first.call(null,(state_28301[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28324 = state_28301;
state_28301 = G__28324;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__10945__auto__ = function(state_28301){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__10945__auto____1.call(this,state_28301);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__10945__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__10945__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_28316 = f__11019__auto__.call(null);
(statearr_28316[(6)] = c__11018__auto__);

return statearr_28316;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_28347){
var state_val_28348 = (state_28347[(1)]);
if((state_val_28348 === (1))){
var state_28347__$1 = state_28347;
var statearr_28349_28363 = state_28347__$1;
(statearr_28349_28363[(2)] = null);

(statearr_28349_28363[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28348 === (2))){
var _ = (function (){var statearr_28350 = state_28347;
(statearr_28350[(4)] = cljs.core.cons.call(null,(5),(state_28347[(4)])));

return statearr_28350;
})();
var inst_28331 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28332 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_28333 = (new cljs.core.PersistentVector(null,3,(5),inst_28331,inst_28332,null));
var inst_28334 = cljs.core.select_keys.call(null,block_data,inst_28333);
var inst_28335 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_28334);
var inst_28336 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_28335);
var inst_28337 = fluree.db.storage.core.serde.call(null,conn);
var inst_28338 = fluree.db.serde.protocol._serialize_block.call(null,inst_28337,inst_28334);
var inst_28339 = fluree.db.storage.core.storage_write.call(null,conn,inst_28336,inst_28338);
var state_28347__$1 = state_28347;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28347__$1,(6),inst_28339);
} else {
if((state_val_28348 === (3))){
var inst_28345 = (state_28347[(2)]);
var state_28347__$1 = state_28347;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28347__$1,inst_28345);
} else {
if((state_val_28348 === (4))){
var inst_28325 = (state_28347[(2)]);
var state_28347__$1 = state_28347;
var statearr_28352_28364 = state_28347__$1;
(statearr_28352_28364[(2)] = inst_28325);

(statearr_28352_28364[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28348 === (5))){
var _ = (function (){var statearr_28353 = state_28347;
(statearr_28353[(4)] = cljs.core.rest.call(null,(state_28347[(4)])));

return statearr_28353;
})();
var state_28347__$1 = state_28347;
var ex28351 = (state_28347__$1[(2)]);
var statearr_28354_28365 = state_28347__$1;
(statearr_28354_28365[(5)] = ex28351);


if((ex28351 instanceof Error)){
var statearr_28355_28366 = state_28347__$1;
(statearr_28355_28366[(1)] = (4));

(statearr_28355_28366[(5)] = null);

} else {
throw ex28351;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28348 === (6))){
var inst_28341 = (state_28347[(2)]);
var inst_28342 = fluree.db.util.async.throw_err.call(null,inst_28341);
var _ = (function (){var statearr_28356 = state_28347;
(statearr_28356[(4)] = cljs.core.rest.call(null,(state_28347[(4)])));

return statearr_28356;
})();
var state_28347__$1 = state_28347;
var statearr_28357_28367 = state_28347__$1;
(statearr_28357_28367[(2)] = inst_28342);

(statearr_28357_28367[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__10945__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__10945__auto____0 = (function (){
var statearr_28358 = [null,null,null,null,null,null,null];
(statearr_28358[(0)] = fluree$db$storage$core$write_block_$_state_machine__10945__auto__);

(statearr_28358[(1)] = (1));

return statearr_28358;
});
var fluree$db$storage$core$write_block_$_state_machine__10945__auto____1 = (function (state_28347){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_28347);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e28359){var ex__10948__auto__ = e28359;
var statearr_28360_28368 = state_28347;
(statearr_28360_28368[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_28347[(4)]))){
var statearr_28361_28369 = state_28347;
(statearr_28361_28369[(1)] = cljs.core.first.call(null,(state_28347[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28370 = state_28347;
state_28347 = G__28370;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__10945__auto__ = function(state_28347){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__10945__auto____1.call(this,state_28347);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__10945__auto____0;
fluree$db$storage$core$write_block_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__10945__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_28362 = f__11019__auto__.call(null);
(statearr_28362[(6)] = c__11018__auto__);

return statearr_28362;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys.call(null,child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_28390){
var state_val_28391 = (state_28390[(1)]);
if((state_val_28391 === (1))){
var state_28390__$1 = state_28390;
var statearr_28392_28406 = state_28390__$1;
(statearr_28392_28406[(2)] = null);

(statearr_28392_28406[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28391 === (2))){
var _ = (function (){var statearr_28393 = state_28390;
(statearr_28393[(4)] = cljs.core.cons.call(null,(5),(state_28390[(4)])));

return statearr_28393;
})();
var inst_28377 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_28378 = [history,next_his_key];
var inst_28379 = cljs.core.PersistentHashMap.fromArrays(inst_28377,inst_28378);
var inst_28380 = fluree.db.storage.core.serde.call(null,conn);
var inst_28381 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_28380,inst_28379);
var inst_28382 = fluree.db.storage.core.storage_write.call(null,conn,his_key,inst_28381);
var state_28390__$1 = state_28390;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28390__$1,(6),inst_28382);
} else {
if((state_val_28391 === (3))){
var inst_28388 = (state_28390[(2)]);
var state_28390__$1 = state_28390;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28390__$1,inst_28388);
} else {
if((state_val_28391 === (4))){
var inst_28371 = (state_28390[(2)]);
var state_28390__$1 = state_28390;
var statearr_28395_28407 = state_28390__$1;
(statearr_28395_28407[(2)] = inst_28371);

(statearr_28395_28407[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28391 === (5))){
var _ = (function (){var statearr_28396 = state_28390;
(statearr_28396[(4)] = cljs.core.rest.call(null,(state_28390[(4)])));

return statearr_28396;
})();
var state_28390__$1 = state_28390;
var ex28394 = (state_28390__$1[(2)]);
var statearr_28397_28408 = state_28390__$1;
(statearr_28397_28408[(5)] = ex28394);


if((ex28394 instanceof Error)){
var statearr_28398_28409 = state_28390__$1;
(statearr_28398_28409[(1)] = (4));

(statearr_28398_28409[(5)] = null);

} else {
throw ex28394;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28391 === (6))){
var inst_28384 = (state_28390[(2)]);
var inst_28385 = fluree.db.util.async.throw_err.call(null,inst_28384);
var _ = (function (){var statearr_28399 = state_28390;
(statearr_28399[(4)] = cljs.core.rest.call(null,(state_28390[(4)])));

return statearr_28399;
})();
var state_28390__$1 = state_28390;
var statearr_28400_28410 = state_28390__$1;
(statearr_28400_28410[(2)] = inst_28385);

(statearr_28400_28410[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__10945__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__10945__auto____0 = (function (){
var statearr_28401 = [null,null,null,null,null,null,null];
(statearr_28401[(0)] = fluree$db$storage$core$write_history_$_state_machine__10945__auto__);

(statearr_28401[(1)] = (1));

return statearr_28401;
});
var fluree$db$storage$core$write_history_$_state_machine__10945__auto____1 = (function (state_28390){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_28390);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e28402){var ex__10948__auto__ = e28402;
var statearr_28403_28411 = state_28390;
(statearr_28403_28411[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_28390[(4)]))){
var statearr_28404_28412 = state_28390;
(statearr_28404_28412[(1)] = cljs.core.first.call(null,(state_28390[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28413 = state_28390;
state_28390 = G__28413;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__10945__auto__ = function(state_28390){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__10945__auto____1.call(this,state_28390);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__10945__auto____0;
fluree$db$storage$core$write_history_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__10945__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_28405 = f__11019__auto__.call(null);
(statearr_28405[(6)] = c__11018__auto__);

return statearr_28405;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_28439){
var state_val_28440 = (state_28439[(1)]);
if((state_val_28440 === (1))){
var state_28439__$1 = state_28439;
var statearr_28441_28458 = state_28439__$1;
(statearr_28441_28458[(2)] = null);

(statearr_28441_28458[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28440 === (2))){
var inst_28420 = (state_28439[(7)]);
var _ = (function (){var statearr_28442 = state_28439;
(statearr_28442[(4)] = cljs.core.cons.call(null,(5),(state_28439[(4)])));

return statearr_28442;
})();
var inst_28420__$1 = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"l");
var inst_28421 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28420__$1),"-his"].join('');
var inst_28422 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_28423 = [flakes,inst_28421];
var inst_28424 = cljs.core.PersistentHashMap.fromArrays(inst_28422,inst_28423);
var inst_28425 = fluree.db.storage.core.serde.call(null,conn);
var inst_28426 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_28425,inst_28424);
var inst_28427 = fluree.db.storage.core.write_history.call(null,conn,history,inst_28421,null);
var inst_28428 = fluree.db.storage.core.storage_write.call(null,conn,inst_28420__$1,inst_28426);
var state_28439__$1 = (function (){var statearr_28443 = state_28439;
(statearr_28443[(8)] = inst_28428);

(statearr_28443[(7)] = inst_28420__$1);

return statearr_28443;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28439__$1,(6),inst_28427);
} else {
if((state_val_28440 === (3))){
var inst_28437 = (state_28439[(2)]);
var state_28439__$1 = state_28439;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28439__$1,inst_28437);
} else {
if((state_val_28440 === (4))){
var inst_28414 = (state_28439[(2)]);
var state_28439__$1 = state_28439;
var statearr_28445_28459 = state_28439__$1;
(statearr_28445_28459[(2)] = inst_28414);

(statearr_28445_28459[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28440 === (5))){
var _ = (function (){var statearr_28446 = state_28439;
(statearr_28446[(4)] = cljs.core.rest.call(null,(state_28439[(4)])));

return statearr_28446;
})();
var state_28439__$1 = state_28439;
var ex28444 = (state_28439__$1[(2)]);
var statearr_28447_28460 = state_28439__$1;
(statearr_28447_28460[(5)] = ex28444);


if((ex28444 instanceof Error)){
var statearr_28448_28461 = state_28439__$1;
(statearr_28448_28461[(1)] = (4));

(statearr_28448_28461[(5)] = null);

} else {
throw ex28444;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28440 === (6))){
var inst_28428 = (state_28439[(8)]);
var inst_28430 = (state_28439[(2)]);
var inst_28431 = fluree.db.util.async.throw_err.call(null,inst_28430);
var state_28439__$1 = (function (){var statearr_28449 = state_28439;
(statearr_28449[(9)] = inst_28431);

return statearr_28449;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28439__$1,(7),inst_28428);
} else {
if((state_val_28440 === (7))){
var inst_28420 = (state_28439[(7)]);
var inst_28433 = (state_28439[(2)]);
var inst_28434 = fluree.db.util.async.throw_err.call(null,inst_28433);
var _ = (function (){var statearr_28450 = state_28439;
(statearr_28450[(4)] = cljs.core.rest.call(null,(state_28439[(4)])));

return statearr_28450;
})();
var state_28439__$1 = (function (){var statearr_28451 = state_28439;
(statearr_28451[(10)] = inst_28434);

return statearr_28451;
})();
var statearr_28452_28462 = state_28439__$1;
(statearr_28452_28462[(2)] = inst_28420);

(statearr_28452_28462[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__10945__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__10945__auto____0 = (function (){
var statearr_28453 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28453[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__10945__auto__);

(statearr_28453[(1)] = (1));

return statearr_28453;
});
var fluree$db$storage$core$write_leaf_$_state_machine__10945__auto____1 = (function (state_28439){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_28439);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e28454){var ex__10948__auto__ = e28454;
var statearr_28455_28463 = state_28439;
(statearr_28455_28463[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_28439[(4)]))){
var statearr_28456_28464 = state_28439;
(statearr_28456_28464[(1)] = cljs.core.first.call(null,(state_28439[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28465 = state_28439;
state_28439 = G__28465;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__10945__auto__ = function(state_28439){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__10945__auto____1.call(this,state_28439);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__10945__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__10945__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_28457 = f__11019__auto__.call(null);
(statearr_28457[(6)] = c__11018__auto__);

return statearr_28457;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_28482){
var state_val_28483 = (state_28482[(1)]);
if((state_val_28483 === (1))){
var state_28482__$1 = state_28482;
var statearr_28484_28499 = state_28482__$1;
(statearr_28484_28499[(2)] = null);

(statearr_28484_28499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28483 === (2))){
var _ = (function (){var statearr_28485 = state_28482;
(statearr_28485[(4)] = cljs.core.cons.call(null,(5),(state_28482[(4)])));

return statearr_28485;
})();
var inst_28472 = fluree.db.storage.core.serde.call(null,conn);
var inst_28473 = fluree.db.serde.protocol._serialize_branch.call(null,inst_28472,data);
var inst_28474 = fluree.db.storage.core.storage_write.call(null,conn,key,inst_28473);
var state_28482__$1 = state_28482;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28482__$1,(6),inst_28474);
} else {
if((state_val_28483 === (3))){
var inst_28480 = (state_28482[(2)]);
var state_28482__$1 = state_28482;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28482__$1,inst_28480);
} else {
if((state_val_28483 === (4))){
var inst_28466 = (state_28482[(2)]);
var state_28482__$1 = state_28482;
var statearr_28487_28500 = state_28482__$1;
(statearr_28487_28500[(2)] = inst_28466);

(statearr_28487_28500[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28483 === (5))){
var _ = (function (){var statearr_28488 = state_28482;
(statearr_28488[(4)] = cljs.core.rest.call(null,(state_28482[(4)])));

return statearr_28488;
})();
var state_28482__$1 = state_28482;
var ex28486 = (state_28482__$1[(2)]);
var statearr_28489_28501 = state_28482__$1;
(statearr_28489_28501[(5)] = ex28486);


if((ex28486 instanceof Error)){
var statearr_28490_28502 = state_28482__$1;
(statearr_28490_28502[(1)] = (4));

(statearr_28490_28502[(5)] = null);

} else {
throw ex28486;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28483 === (6))){
var inst_28476 = (state_28482[(2)]);
var inst_28477 = fluree.db.util.async.throw_err.call(null,inst_28476);
var _ = (function (){var statearr_28491 = state_28482;
(statearr_28491[(4)] = cljs.core.rest.call(null,(state_28482[(4)])));

return statearr_28491;
})();
var state_28482__$1 = (function (){var statearr_28492 = state_28482;
(statearr_28492[(7)] = inst_28477);

return statearr_28492;
})();
var statearr_28493_28503 = state_28482__$1;
(statearr_28493_28503[(2)] = key);

(statearr_28493_28503[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__10945__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__10945__auto____0 = (function (){
var statearr_28494 = [null,null,null,null,null,null,null,null];
(statearr_28494[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__10945__auto__);

(statearr_28494[(1)] = (1));

return statearr_28494;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__10945__auto____1 = (function (state_28482){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_28482);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e28495){var ex__10948__auto__ = e28495;
var statearr_28496_28504 = state_28482;
(statearr_28496_28504[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_28482[(4)]))){
var statearr_28497_28505 = state_28482;
(statearr_28497_28505[(1)] = cljs.core.first.call(null,(state_28482[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28506 = state_28482;
state_28482 = G__28506;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__10945__auto__ = function(state_28482){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__10945__auto____1.call(this,state_28482);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__10945__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__10945__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_28498 = f__11019__auto__.call(null);
(statearr_28498[(6)] = c__11018__auto__);

return statearr_28498;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.call(null,(function (p1__28507_SHARP_){
return fluree.db.storage.core.child_data.call(null,cljs.core.val.call(null,p1__28507_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data.call(null,conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__28508){
var map__28509 = p__28508;
var map__28509__$1 = cljs.core.__destructure_map.call(null,map__28509);
var progress = map__28509__$1;
var garbage = cljs.core.get.call(null,map__28509__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_28537){
var state_val_28538 = (state_28537[(1)]);
if((state_val_28538 === (1))){
var state_28537__$1 = state_28537;
var statearr_28539_28555 = state_28537__$1;
(statearr_28539_28555[(2)] = null);

(statearr_28539_28555[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28538 === (2))){
var inst_28523 = (state_28537[(7)]);
var _ = (function (){var statearr_28540 = state_28537;
(statearr_28540[(4)] = cljs.core.cons.call(null,(5),(state_28537[(4)])));

return statearr_28540;
})();
var inst_28517 = db;
var inst_28518 = cljs.core.__destructure_map.call(null,inst_28517);
var inst_28519 = cljs.core.get.call(null,inst_28518,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_28520 = cljs.core.get.call(null,inst_28518,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_28521 = cljs.core.get.call(null,inst_28518,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_28522 = cljs.core.get.call(null,inst_28518,new cljs.core.Keyword(null,"block","block",664686210));
var inst_28523__$1 = fluree.db.storage.core.ledger_garbage_key.call(null,inst_28520,inst_28521,inst_28522);
var inst_28524 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_28525 = [inst_28521,inst_28522,garbage];
var inst_28526 = cljs.core.PersistentHashMap.fromArrays(inst_28524,inst_28525);
var inst_28527 = fluree.db.storage.core.serde.call(null,inst_28519);
var inst_28528 = fluree.db.serde.protocol._serialize_garbage.call(null,inst_28527,inst_28526);
var inst_28529 = fluree.db.storage.core.storage_write.call(null,inst_28519,inst_28523__$1,inst_28528);
var state_28537__$1 = (function (){var statearr_28541 = state_28537;
(statearr_28541[(7)] = inst_28523__$1);

return statearr_28541;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28537__$1,(6),inst_28529);
} else {
if((state_val_28538 === (3))){
var inst_28535 = (state_28537[(2)]);
var state_28537__$1 = state_28537;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28537__$1,inst_28535);
} else {
if((state_val_28538 === (4))){
var inst_28510 = (state_28537[(2)]);
var state_28537__$1 = state_28537;
var statearr_28543_28556 = state_28537__$1;
(statearr_28543_28556[(2)] = inst_28510);

(statearr_28543_28556[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28538 === (5))){
var _ = (function (){var statearr_28544 = state_28537;
(statearr_28544[(4)] = cljs.core.rest.call(null,(state_28537[(4)])));

return statearr_28544;
})();
var state_28537__$1 = state_28537;
var ex28542 = (state_28537__$1[(2)]);
var statearr_28545_28557 = state_28537__$1;
(statearr_28545_28557[(5)] = ex28542);


if((ex28542 instanceof Error)){
var statearr_28546_28558 = state_28537__$1;
(statearr_28546_28558[(1)] = (4));

(statearr_28546_28558[(5)] = null);

} else {
throw ex28542;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28538 === (6))){
var inst_28523 = (state_28537[(7)]);
var inst_28531 = (state_28537[(2)]);
var inst_28532 = fluree.db.util.async.throw_err.call(null,inst_28531);
var _ = (function (){var statearr_28547 = state_28537;
(statearr_28547[(4)] = cljs.core.rest.call(null,(state_28537[(4)])));

return statearr_28547;
})();
var state_28537__$1 = (function (){var statearr_28548 = state_28537;
(statearr_28548[(8)] = inst_28532);

return statearr_28548;
})();
var statearr_28549_28559 = state_28537__$1;
(statearr_28549_28559[(2)] = inst_28523);

(statearr_28549_28559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__10945__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__10945__auto____0 = (function (){
var statearr_28550 = [null,null,null,null,null,null,null,null,null];
(statearr_28550[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__10945__auto__);

(statearr_28550[(1)] = (1));

return statearr_28550;
});
var fluree$db$storage$core$write_garbage_$_state_machine__10945__auto____1 = (function (state_28537){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_28537);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e28551){var ex__10948__auto__ = e28551;
var statearr_28552_28560 = state_28537;
(statearr_28552_28560[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_28537[(4)]))){
var statearr_28553_28561 = state_28537;
(statearr_28553_28561[(1)] = cljs.core.first.call(null,(state_28537[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28562 = state_28537;
state_28537 = G__28562;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__10945__auto__ = function(state_28537){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__10945__auto____1.call(this,state_28537);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__10945__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__10945__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_28554 = f__11019__auto__.call(null);
(statearr_28554[(6)] = c__11018__auto__);

return statearr_28554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__28564 = arguments.length;
switch (G__28564) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.call(null,db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_28620){
var state_val_28621 = (state_28620[(1)]);
if((state_val_28621 === (7))){
var state_28620__$1 = state_28620;
var statearr_28622_28648 = state_28620__$1;
(statearr_28622_28648[(2)] = (0));

(statearr_28622_28648[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28621 === (1))){
var state_28620__$1 = state_28620;
var statearr_28623_28649 = state_28620__$1;
(statearr_28623_28649[(2)] = null);

(statearr_28623_28649[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28621 === (4))){
var inst_28565 = (state_28620[(2)]);
var state_28620__$1 = state_28620;
var statearr_28624_28650 = state_28620__$1;
(statearr_28624_28650[(2)] = inst_28565);

(statearr_28624_28650[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28621 === (6))){
var inst_28590 = (state_28620[(7)]);
var state_28620__$1 = state_28620;
var statearr_28625_28651 = state_28620__$1;
(statearr_28625_28651[(2)] = inst_28590);

(statearr_28625_28651[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28621 === (3))){
var inst_28618 = (state_28620[(2)]);
var state_28620__$1 = state_28620;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28620__$1,inst_28618);
} else {
if((state_val_28621 === (12))){
var inst_28587 = (state_28620[(8)]);
var inst_28614 = (state_28620[(2)]);
var inst_28615 = fluree.db.util.async.throw_err.call(null,inst_28614);
var _ = (function (){var statearr_28626 = state_28620;
(statearr_28626[(4)] = cljs.core.rest.call(null,(state_28620[(4)])));

return statearr_28626;
})();
var state_28620__$1 = (function (){var statearr_28627 = state_28620;
(statearr_28627[(9)] = inst_28615);

return statearr_28627;
})();
var statearr_28628_28652 = state_28620__$1;
(statearr_28628_28652[(2)] = inst_28587);

(statearr_28628_28652[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28621 === (2))){
var inst_28582 = (state_28620[(10)]);
var inst_28590 = (state_28620[(7)]);
var inst_28578 = (state_28620[(11)]);
var inst_28580 = (state_28620[(12)]);
var _ = (function (){var statearr_28629 = state_28620;
(statearr_28629[(4)] = cljs.core.cons.call(null,(5),(state_28620[(4)])));

return statearr_28629;
})();
var inst_28572 = db;
var inst_28573 = cljs.core.__destructure_map.call(null,inst_28572);
var inst_28574 = cljs.core.get.call(null,inst_28573,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_28575 = cljs.core.get.call(null,inst_28573,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_28576 = cljs.core.get.call(null,inst_28573,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_28577 = cljs.core.get.call(null,inst_28573,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_28578__$1 = cljs.core.get.call(null,inst_28573,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_28579 = cljs.core.get.call(null,inst_28573,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_28580__$1 = cljs.core.get.call(null,inst_28573,new cljs.core.Keyword(null,"block","block",664686210));
var inst_28581 = cljs.core.get.call(null,inst_28573,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_28582__$1 = cljs.core.get.call(null,inst_28573,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_28583 = cljs.core.get.call(null,inst_28573,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_28584 = cljs.core.get.call(null,inst_28573,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_28585 = cljs.core.get.call(null,inst_28573,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_28586 = cljs.core.get.call(null,inst_28573,new cljs.core.Keyword(null,"post","post",269697687));
var inst_28587 = fluree.db.storage.core.ledger_root_key.call(null,inst_28574,inst_28582__$1,inst_28580__$1);
var inst_28588 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_28589 = fluree.db.storage.core.child_data.call(null,inst_28581);
var inst_28590__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_28578__$1);
var state_28620__$1 = (function (){var statearr_28630 = state_28620;
(statearr_28630[(13)] = inst_28586);

(statearr_28630[(14)] = inst_28576);

(statearr_28630[(15)] = inst_28588);

(statearr_28630[(10)] = inst_28582__$1);

(statearr_28630[(7)] = inst_28590__$1);

(statearr_28630[(16)] = inst_28589);

(statearr_28630[(17)] = inst_28585);

(statearr_28630[(11)] = inst_28578__$1);

(statearr_28630[(18)] = inst_28579);

(statearr_28630[(19)] = inst_28577);

(statearr_28630[(20)] = inst_28575);

(statearr_28630[(21)] = inst_28584);

(statearr_28630[(12)] = inst_28580__$1);

(statearr_28630[(8)] = inst_28587);

(statearr_28630[(22)] = inst_28583);

return statearr_28630;
})();
if(cljs.core.truth_(inst_28590__$1)){
var statearr_28631_28653 = state_28620__$1;
(statearr_28631_28653[(1)] = (6));

} else {
var statearr_28632_28654 = state_28620__$1;
(statearr_28632_28654[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28621 === (11))){
var inst_28586 = (state_28620[(13)]);
var inst_28576 = (state_28620[(14)]);
var inst_28588 = (state_28620[(15)]);
var inst_28582 = (state_28620[(10)]);
var inst_28589 = (state_28620[(16)]);
var inst_28585 = (state_28620[(17)]);
var inst_28578 = (state_28620[(11)]);
var inst_28579 = (state_28620[(18)]);
var inst_28577 = (state_28620[(19)]);
var inst_28575 = (state_28620[(20)]);
var inst_28584 = (state_28620[(21)]);
var inst_28580 = (state_28620[(12)]);
var inst_28587 = (state_28620[(8)]);
var inst_28594 = (state_28620[(23)]);
var inst_28599 = (state_28620[(2)]);
var inst_28600 = fluree.db.storage.core.child_data.call(null,inst_28584);
var inst_28601 = fluree.db.storage.core.child_data.call(null,inst_28586);
var inst_28602 = fluree.db.util.core.current_time_millis.call(null);
var inst_28603 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28604 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_28605 = (new cljs.core.PersistentVector(null,2,(5),inst_28603,inst_28604,null));
var inst_28606 = cljs.core.select_keys.call(null,inst_28578,inst_28605);
var inst_28607 = fluree.db.storage.core.child_data.call(null,inst_28577);
var inst_28608 = [inst_28580,inst_28589,inst_28582,inst_28594,inst_28599,inst_28600,inst_28601,inst_28575,inst_28602,inst_28576,inst_28585,inst_28606,inst_28607];
var inst_28609 = cljs.core.PersistentHashMap.fromArrays(inst_28588,inst_28608);
var inst_28610 = fluree.db.storage.core.serde.call(null,inst_28579);
var inst_28611 = fluree.db.serde.protocol._serialize_db_root.call(null,inst_28610,inst_28609);
var inst_28612 = fluree.db.storage.core.storage_write.call(null,inst_28579,inst_28587,inst_28611);
var state_28620__$1 = state_28620;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28620__$1,(12),inst_28612);
} else {
if((state_val_28621 === (9))){
var inst_28595 = (state_28620[(24)]);
var state_28620__$1 = state_28620;
var statearr_28634_28655 = state_28620__$1;
(statearr_28634_28655[(2)] = inst_28595);

(statearr_28634_28655[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28621 === (5))){
var _ = (function (){var statearr_28635 = state_28620;
(statearr_28635[(4)] = cljs.core.rest.call(null,(state_28620[(4)])));

return statearr_28635;
})();
var state_28620__$1 = state_28620;
var ex28633 = (state_28620__$1[(2)]);
var statearr_28636_28656 = state_28620__$1;
(statearr_28636_28656[(5)] = ex28633);


if((ex28633 instanceof Error)){
var statearr_28637_28657 = state_28620__$1;
(statearr_28637_28657[(1)] = (4));

(statearr_28637_28657[(5)] = null);

} else {
throw ex28633;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28621 === (10))){
var inst_28583 = (state_28620[(22)]);
var state_28620__$1 = state_28620;
var statearr_28638_28658 = state_28620__$1;
(statearr_28638_28658[(2)] = inst_28583);

(statearr_28638_28658[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28621 === (8))){
var inst_28595 = (state_28620[(24)]);
var inst_28594 = (state_28620[(2)]);
var inst_28595__$1 = custom_ecount;
var state_28620__$1 = (function (){var statearr_28639 = state_28620;
(statearr_28639[(24)] = inst_28595__$1);

(statearr_28639[(23)] = inst_28594);

return statearr_28639;
})();
if(cljs.core.truth_(inst_28595__$1)){
var statearr_28640_28659 = state_28620__$1;
(statearr_28640_28659[(1)] = (9));

} else {
var statearr_28641_28660 = state_28620__$1;
(statearr_28641_28660[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__10945__auto__ = null;
var fluree$db$storage$core$state_machine__10945__auto____0 = (function (){
var statearr_28642 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28642[(0)] = fluree$db$storage$core$state_machine__10945__auto__);

(statearr_28642[(1)] = (1));

return statearr_28642;
});
var fluree$db$storage$core$state_machine__10945__auto____1 = (function (state_28620){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_28620);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e28643){var ex__10948__auto__ = e28643;
var statearr_28644_28661 = state_28620;
(statearr_28644_28661[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_28620[(4)]))){
var statearr_28645_28662 = state_28620;
(statearr_28645_28662[(1)] = cljs.core.first.call(null,(state_28620[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28663 = state_28620;
state_28620 = G__28663;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__10945__auto__ = function(state_28620){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__10945__auto____1.call(this,state_28620);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__10945__auto____0;
fluree$db$storage$core$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__10945__auto____1;
return fluree$db$storage$core$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_28646 = f__11019__auto__.call(null);
(statearr_28646[(6)] = c__11018__auto__);

return statearr_28646;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__11018__auto___28722 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_28696){
var state_val_28697 = (state_28696[(1)]);
if((state_val_28697 === (7))){
var inst_28676 = (state_28696[(7)]);
var state_28696__$1 = state_28696;
var statearr_28698_28723 = state_28696__$1;
(statearr_28698_28723[(2)] = inst_28676);

(statearr_28698_28723[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28697 === (1))){
var state_28696__$1 = state_28696;
var statearr_28699_28724 = state_28696__$1;
(statearr_28699_28724[(2)] = null);

(statearr_28699_28724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28697 === (4))){
var inst_28664 = (state_28696[(2)]);
var inst_28665 = error_fn.call(null);
var inst_28666 = cljs.core.async.put_BANG_.call(null,return_ch,inst_28664);
var inst_28667 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_28696__$1 = (function (){var statearr_28700 = state_28696;
(statearr_28700[(8)] = inst_28665);

(statearr_28700[(9)] = inst_28666);

return statearr_28700;
})();
var statearr_28701_28725 = state_28696__$1;
(statearr_28701_28725[(2)] = inst_28667);

(statearr_28701_28725[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28697 === (6))){
var inst_28675 = (state_28696[(10)]);
var inst_28676 = (state_28696[(7)]);
var inst_28675__$1 = (state_28696[(2)]);
var inst_28676__$1 = (inst_28675__$1 == null);
var state_28696__$1 = (function (){var statearr_28702 = state_28696;
(statearr_28702[(10)] = inst_28675__$1);

(statearr_28702[(7)] = inst_28676__$1);

return statearr_28702;
})();
if(cljs.core.truth_(inst_28676__$1)){
var statearr_28703_28726 = state_28696__$1;
(statearr_28703_28726[(1)] = (7));

} else {
var statearr_28704_28727 = state_28696__$1;
(statearr_28704_28727[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28697 === (3))){
var inst_28694 = (state_28696[(2)]);
var state_28696__$1 = state_28696;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28696__$1,inst_28694);
} else {
if((state_val_28697 === (12))){
var inst_28691 = (state_28696[(2)]);
var _ = (function (){var statearr_28705 = state_28696;
(statearr_28705[(4)] = cljs.core.rest.call(null,(state_28696[(4)])));

return statearr_28705;
})();
var state_28696__$1 = state_28696;
var statearr_28706_28728 = state_28696__$1;
(statearr_28706_28728[(2)] = inst_28691);

(statearr_28706_28728[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28697 === (2))){
var _ = (function (){var statearr_28707 = state_28696;
(statearr_28707[(4)] = cljs.core.cons.call(null,(5),(state_28696[(4)])));

return statearr_28707;
})();
var inst_28673 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_28696__$1 = state_28696;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28696__$1,(6),inst_28673);
} else {
if((state_val_28697 === (11))){
var inst_28675 = (state_28696[(10)]);
var inst_28685 = fluree.db.storage.core.serde.call(null,conn);
var inst_28686 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_28685,inst_28675);
var inst_28687 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_28686);
var inst_28688 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_history,inst_28687);
var inst_28689 = cljs.core.async.put_BANG_.call(null,return_ch,inst_28688);
var state_28696__$1 = state_28696;
var statearr_28709_28729 = state_28696__$1;
(statearr_28709_28729[(2)] = inst_28689);

(statearr_28709_28729[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28697 === (9))){
var inst_28681 = (state_28696[(2)]);
var state_28696__$1 = state_28696;
if(cljs.core.truth_(inst_28681)){
var statearr_28710_28730 = state_28696__$1;
(statearr_28710_28730[(1)] = (10));

} else {
var statearr_28711_28731 = state_28696__$1;
(statearr_28711_28731[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28697 === (5))){
var _ = (function (){var statearr_28712 = state_28696;
(statearr_28712[(4)] = cljs.core.rest.call(null,(state_28696[(4)])));

return statearr_28712;
})();
var state_28696__$1 = state_28696;
var ex28708 = (state_28696__$1[(2)]);
var statearr_28713_28732 = state_28696__$1;
(statearr_28713_28732[(5)] = ex28708);


var statearr_28714_28733 = state_28696__$1;
(statearr_28714_28733[(1)] = (4));

(statearr_28714_28733[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28697 === (10))){
var inst_28683 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_28696__$1 = state_28696;
var statearr_28715_28734 = state_28696__$1;
(statearr_28715_28734[(2)] = inst_28683);

(statearr_28715_28734[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28697 === (8))){
var inst_28675 = (state_28696[(10)]);
var inst_28679 = (inst_28675 instanceof Error);
var state_28696__$1 = state_28696;
var statearr_28716_28735 = state_28696__$1;
(statearr_28716_28735[(2)] = inst_28679);

(statearr_28716_28735[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__10945__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__10945__auto____0 = (function (){
var statearr_28717 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28717[(0)] = fluree$db$storage$core$reify_history_$_state_machine__10945__auto__);

(statearr_28717[(1)] = (1));

return statearr_28717;
});
var fluree$db$storage$core$reify_history_$_state_machine__10945__auto____1 = (function (state_28696){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_28696);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e28718){var ex__10948__auto__ = e28718;
var statearr_28719_28736 = state_28696;
(statearr_28719_28736[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_28696[(4)]))){
var statearr_28720_28737 = state_28696;
(statearr_28720_28737[(1)] = cljs.core.first.call(null,(state_28696[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28738 = state_28696;
state_28696 = G__28738;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__10945__auto__ = function(state_28696){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__10945__auto____1.call(this,state_28696);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__10945__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__10945__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_28721 = f__11019__auto__.call(null);
(statearr_28721[(6)] = c__11018__auto___28722);

return statearr_28721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__28740 = arguments.length;
switch (G__28740) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.call(null,novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__5043__auto__ = rhs;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not.call(null,leftmost_QMARK_);
} else {
return and__5043__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__5043__auto__ = rhs;
if(cljs.core.truth_(and__5043__auto__)){
return leftmost_QMARK_;
} else {
return and__5043__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not.call(null,leftmost_QMARK_))))?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__5043__auto__ = (rhs == null);
if(and__5043__auto__){
return leftmost_QMARK_;
} else {
return and__5043__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.call(null,(function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.call(null,novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.call(null);
var c__11018__auto___28850 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_28803){
var state_val_28804 = (state_28803[(1)]);
if((state_val_28804 === (7))){
var state_28803__$1 = state_28803;
var statearr_28805_28851 = state_28803__$1;
(statearr_28805_28851[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_28805_28851[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28804 === (20))){
var inst_28782 = cljs.core.PersistentVector.EMPTY;
var state_28803__$1 = state_28803;
var statearr_28806_28852 = state_28803__$1;
(statearr_28806_28852[(2)] = inst_28782);

(statearr_28806_28852[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28804 === (1))){
var state_28803__$1 = state_28803;
var statearr_28807_28853 = state_28803__$1;
(statearr_28807_28853[(2)] = null);

(statearr_28807_28853[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28804 === (24))){
var state_28803__$1 = state_28803;
var statearr_28808_28854 = state_28803__$1;
(statearr_28808_28854[(2)] = null);

(statearr_28808_28854[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28804 === (4))){
var inst_28743 = (state_28803[(2)]);
var inst_28744 = error_fn.call(null);
var inst_28745 = cljs.core.async.put_BANG_.call(null,result_ch,inst_28743);
var inst_28746 = cljs.core.async.close_BANG_.call(null,result_ch);
var state_28803__$1 = (function (){var statearr_28809 = state_28803;
(statearr_28809[(7)] = inst_28744);

(statearr_28809[(8)] = inst_28745);

return statearr_28809;
})();
var statearr_28810_28855 = state_28803__$1;
(statearr_28810_28855[(2)] = inst_28746);

(statearr_28810_28855[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28804 === (15))){
var inst_28768 = (state_28803[(2)]);
var state_28803__$1 = state_28803;
var statearr_28811_28856 = state_28803__$1;
(statearr_28811_28856[(2)] = inst_28768);

(statearr_28811_28856[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28804 === (21))){
var inst_28757 = (state_28803[(9)]);
var inst_28756 = (state_28803[(10)]);
var inst_28772 = (state_28803[(11)]);
var inst_28785 = (state_28803[(12)]);
var inst_28755 = (state_28803[(13)]);
var inst_28792 = (state_28803[(2)]);
var inst_28793 = (function (){var base_node = inst_28755;
var first_flake = inst_28756;
var node_t = inst_28757;
var source = inst_28772;
var coll = inst_28785;
var conj_QMARK_ = inst_28792;
return (function (acc,f){
if(cljs.core.truth_((function (){var or__5045__auto__ = remove_preds;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})().call(null,f.p))){
return cljs.core.disj.call(null,acc,f);
} else {
if(cljs.core.truth_(conj_QMARK_.call(null,f))){
return cljs.core.conj.call(null,acc,f);
} else {
return cljs.core.disj.call(null,acc,f);

}
}
});
})();
var inst_28794 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_28755);
var inst_28795 = cljs.core.reduce.call(null,inst_28793,inst_28794,inst_28785);
var inst_28796 = cljs.core.doall.call(null,inst_28795);
var inst_28797 = cljs.core.assoc.call(null,inst_28755,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_28796);
var inst_28798 = cljs.core.async.put_BANG_.call(null,result_ch,inst_28797);
var _ = (function (){var statearr_28812 = state_28803;
(statearr_28812[(4)] = cljs.core.rest.call(null,(state_28803[(4)])));

return statearr_28812;
})();
var state_28803__$1 = state_28803;
var statearr_28813_28857 = state_28803__$1;
(statearr_28813_28857[(2)] = inst_28798);

(statearr_28813_28857[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28804 === (13))){
var state_28803__$1 = state_28803;
var statearr_28814_28858 = state_28803__$1;
(statearr_28814_28858[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_28814_28858[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28804 === (22))){
var inst_28757 = (state_28803[(9)]);
var inst_28756 = (state_28803[(10)]);
var inst_28772 = (state_28803[(11)]);
var inst_28785 = (state_28803[(12)]);
var inst_28755 = (state_28803[(13)]);
var inst_28786 = (function (){var base_node = inst_28755;
var first_flake = inst_28756;
var node_t = inst_28757;
var source = inst_28772;
var coll = inst_28785;
return (function (f){
return f.op === true;
});
})();
var state_28803__$1 = state_28803;
var statearr_28815_28859 = state_28803__$1;
(statearr_28815_28859[(2)] = inst_28786);

(statearr_28815_28859[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28804 === (6))){
var inst_28757 = (state_28803[(9)]);
var inst_28755 = (state_28803[(13)]);
var inst_28754 = (state_28803[(2)]);
var inst_28755__$1 = fluree.db.util.async.throw_err.call(null,inst_28754);
var inst_28756 = fluree.db.dbproto._first_flake.call(null,inst_28755__$1);
var inst_28757__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_28755__$1);
var inst_28758 = (inst_28757__$1 > t);
var state_28803__$1 = (function (){var statearr_28816 = state_28803;
(statearr_28816[(9)] = inst_28757__$1);

(statearr_28816[(10)] = inst_28756);

(statearr_28816[(13)] = inst_28755__$1);

return statearr_28816;
})();
if(cljs.core.truth_(inst_28758)){
var statearr_28817_28860 = state_28803__$1;
(statearr_28817_28860[(1)] = (7));

} else {
var statearr_28818_28861 = state_28803__$1;
(statearr_28818_28861[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28804 === (17))){
var inst_28756 = (state_28803[(10)]);
var inst_28773 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_28756,rhs,leftmost_QMARK_,t);
var state_28803__$1 = state_28803;
var statearr_28819_28862 = state_28803__$1;
(statearr_28819_28862[(2)] = inst_28773);

(statearr_28819_28862[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28804 === (3))){
var inst_28801 = (state_28803[(2)]);
var state_28803__$1 = state_28803;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28803__$1,inst_28801);
} else {
if((state_val_28804 === (12))){
var inst_28770 = (state_28803[(2)]);
var state_28803__$1 = state_28803;
var statearr_28820_28863 = state_28803__$1;
(statearr_28820_28863[(2)] = inst_28770);

(statearr_28820_28863[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28804 === (2))){
var _ = (function (){var statearr_28821 = state_28803;
(statearr_28821[(4)] = cljs.core.cons.call(null,(5),(state_28803[(4)])));

return statearr_28821;
})();
var inst_28752 = fluree.db.dbproto._resolve.call(null,node);
var state_28803__$1 = state_28803;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28803__$1,(6),inst_28752);
} else {
if((state_val_28804 === (23))){
var inst_28757 = (state_28803[(9)]);
var inst_28756 = (state_28803[(10)]);
var inst_28772 = (state_28803[(11)]);
var inst_28785 = (state_28803[(12)]);
var inst_28755 = (state_28803[(13)]);
var inst_28788 = (function (){var base_node = inst_28755;
var first_flake = inst_28756;
var node_t = inst_28757;
var source = inst_28772;
var coll = inst_28785;
return (function (f){
return f.op === false;
});
})();
var state_28803__$1 = state_28803;
var statearr_28822_28864 = state_28803__$1;
(statearr_28822_28864[(2)] = inst_28788);

(statearr_28822_28864[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28804 === (19))){
var inst_28775 = (state_28803[(14)]);
var inst_28778 = (state_28803[(2)]);
var inst_28779 = fluree.db.util.async.throw_err.call(null,inst_28778);
var inst_28780 = cljs.core.take_while.call(null,inst_28775,inst_28779);
var state_28803__$1 = state_28803;
var statearr_28823_28865 = state_28803__$1;
(statearr_28823_28865[(2)] = inst_28780);

(statearr_28823_28865[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28804 === (11))){
var inst_28757 = (state_28803[(9)]);
var inst_28764 = cljs.core._EQ_.call(null,inst_28757,t);
var state_28803__$1 = state_28803;
if(inst_28764){
var statearr_28825_28866 = state_28803__$1;
(statearr_28825_28866[(1)] = (13));

} else {
var statearr_28826_28867 = state_28803__$1;
(statearr_28826_28867[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28804 === (9))){
var inst_28772 = (state_28803[(11)]);
var inst_28772__$1 = (state_28803[(2)]);
var state_28803__$1 = (function (){var statearr_28827 = state_28803;
(statearr_28827[(11)] = inst_28772__$1);

return statearr_28827;
})();
var G__28828_28868 = inst_28772__$1;
var G__28828_28869__$1 = (((G__28828_28868 instanceof cljs.core.Keyword))?G__28828_28868.fqn:null);
switch (G__28828_28869__$1) {
case "novelty":
var statearr_28829_28871 = state_28803__$1;
(statearr_28829_28871[(1)] = (17));


break;
case "history":
var statearr_28830_28872 = state_28803__$1;
(statearr_28830_28872[(1)] = (18));


break;
case "none":
var statearr_28831_28873 = state_28803__$1;
(statearr_28831_28873[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28828_28869__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28804 === (5))){
var _ = (function (){var statearr_28832 = state_28803;
(statearr_28832[(4)] = cljs.core.rest.call(null,(state_28803[(4)])));

return statearr_28832;
})();
var state_28803__$1 = state_28803;
var ex28824 = (state_28803__$1[(2)]);
var statearr_28833_28874 = state_28803__$1;
(statearr_28833_28874[(5)] = ex28824);


var statearr_28834_28875 = state_28803__$1;
(statearr_28834_28875[(1)] = (4));

(statearr_28834_28875[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28804 === (14))){
var state_28803__$1 = state_28803;
var statearr_28835_28876 = state_28803__$1;
(statearr_28835_28876[(2)] = null);

(statearr_28835_28876[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28804 === (16))){
var inst_28772 = (state_28803[(11)]);
var inst_28785 = (state_28803[(2)]);
var state_28803__$1 = (function (){var statearr_28836 = state_28803;
(statearr_28836[(12)] = inst_28785);

return statearr_28836;
})();
var G__28837_28877 = inst_28772;
var G__28837_28878__$1 = (((G__28837_28877 instanceof cljs.core.Keyword))?G__28837_28877.fqn:null);
switch (G__28837_28878__$1) {
case "novelty":
var statearr_28838_28880 = state_28803__$1;
(statearr_28838_28880[(1)] = (22));


break;
case "history":
var statearr_28839_28881 = state_28803__$1;
(statearr_28839_28881[(1)] = (23));


break;
case "none":
var statearr_28840_28882 = state_28803__$1;
(statearr_28840_28882[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28837_28878__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28804 === (10))){
var state_28803__$1 = state_28803;
var statearr_28841_28883 = state_28803__$1;
(statearr_28841_28883[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_28841_28883[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28804 === (18))){
var inst_28757 = (state_28803[(9)]);
var inst_28756 = (state_28803[(10)]);
var inst_28772 = (state_28803[(11)]);
var inst_28755 = (state_28803[(13)]);
var inst_28775 = (function (){var base_node = inst_28755;
var first_flake = inst_28756;
var node_t = inst_28757;
var source = inst_28772;
return (function (p1__28742_SHARP_){
return (p1__28742_SHARP_.t <= t);
});
})();
var inst_28776 = fluree.db.dbproto._resolve_history.call(null,node);
var state_28803__$1 = (function (){var statearr_28842 = state_28803;
(statearr_28842[(14)] = inst_28775);

return statearr_28842;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28803__$1,(19),inst_28776);
} else {
if((state_val_28804 === (8))){
var inst_28757 = (state_28803[(9)]);
var inst_28761 = (inst_28757 < t);
var state_28803__$1 = state_28803;
if(cljs.core.truth_(inst_28761)){
var statearr_28843_28884 = state_28803__$1;
(statearr_28843_28884[(1)] = (10));

} else {
var statearr_28844_28885 = state_28803__$1;
(statearr_28844_28885[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__10945__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__10945__auto____0 = (function (){
var statearr_28845 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28845[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__10945__auto__);

(statearr_28845[(1)] = (1));

return statearr_28845;
});
var fluree$db$storage$core$resolve_t_$_state_machine__10945__auto____1 = (function (state_28803){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_28803);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e28846){var ex__10948__auto__ = e28846;
var statearr_28847_28886 = state_28803;
(statearr_28847_28886[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_28803[(4)]))){
var statearr_28848_28887 = state_28803;
(statearr_28848_28887[(1)] = cljs.core.first.call(null,(state_28803[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28888 = state_28803;
state_28803 = G__28888;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__10945__auto__ = function(state_28803){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__10945__auto____1.call(this,state_28803);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__10945__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__10945__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_28849 = f__11019__auto__.call(null);
(statearr_28849[(6)] = c__11018__auto___28850);

return statearr_28849;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_28948){
var state_val_28949 = (state_28948[(1)]);
if((state_val_28949 === (7))){
var inst_28899 = (state_28948[(7)]);
var inst_28903 = (inst_28899 <= from_t);
var state_28948__$1 = state_28948;
var statearr_28950_28990 = state_28948__$1;
(statearr_28950_28990[(2)] = inst_28903);

(statearr_28950_28990[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28949 === (20))){
var inst_28933 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_28934 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28933)].join('');
var inst_28935 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28936 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_28937 = cljs.core.PersistentHashMap.fromArrays(inst_28935,inst_28936);
var inst_28938 = cljs.core.ex_info.call(null,inst_28934,inst_28937);
var inst_28939 = (function(){throw inst_28938})();
var state_28948__$1 = state_28948;
var statearr_28951_28991 = state_28948__$1;
(statearr_28951_28991[(2)] = inst_28939);

(statearr_28951_28991[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28949 === (1))){
var state_28948__$1 = state_28948;
var statearr_28952_28992 = state_28948__$1;
(statearr_28952_28992[(2)] = null);

(statearr_28952_28992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28949 === (4))){
var inst_28891 = (state_28948[(2)]);
var inst_28892 = fluree.db.util.log.error.call(null,inst_28891);
var inst_28893 = (function(){throw inst_28891})();
var state_28948__$1 = (function (){var statearr_28953 = state_28948;
(statearr_28953[(8)] = inst_28892);

return statearr_28953;
})();
var statearr_28954_28993 = state_28948__$1;
(statearr_28954_28993[(2)] = inst_28893);

(statearr_28954_28993[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28949 === (15))){
var inst_28918 = (state_28948[(2)]);
var state_28948__$1 = (function (){var statearr_28955 = state_28948;
(statearr_28955[(9)] = inst_28918);

return statearr_28955;
})();
if(cljs.core.truth_(from_t)){
var statearr_28956_28994 = state_28948__$1;
(statearr_28956_28994[(1)] = (16));

} else {
var statearr_28957_28995 = state_28948__$1;
(statearr_28957_28995[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28949 === (21))){
var inst_28929 = (state_28948[(10)]);
var inst_28928 = (state_28948[(11)]);
var inst_28927 = (state_28948[(12)]);
var inst_28941 = (state_28948[(2)]);
var inst_28942 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_28928,inst_28929,leftmost_QMARK_,to_t);
var inst_28943 = cljs.core.into.call(null,inst_28942,inst_28927);
var _ = (function (){var statearr_28958 = state_28948;
(statearr_28958[(4)] = cljs.core.rest.call(null,(state_28948[(4)])));

return statearr_28958;
})();
var state_28948__$1 = (function (){var statearr_28959 = state_28948;
(statearr_28959[(13)] = inst_28941);

return statearr_28959;
})();
var statearr_28960_28996 = state_28948__$1;
(statearr_28960_28996[(2)] = inst_28943);

(statearr_28960_28996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28949 === (13))){
var inst_28911 = (state_28948[(14)]);
var inst_28899 = (state_28948[(7)]);
var inst_28914 = (function (){var node_t = inst_28899;
var G__28907 = inst_28911;
return (function (p1__28889_SHARP_){
return (p1__28889_SHARP_.t < to_t);
});
})();
var inst_28915 = cljs.core.drop_while.call(null,inst_28914,inst_28911);
var state_28948__$1 = state_28948;
var statearr_28961_28997 = state_28948__$1;
(statearr_28961_28997[(2)] = inst_28915);

(statearr_28961_28997[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28949 === (6))){
var inst_28900 = (state_28948[(15)]);
var state_28948__$1 = state_28948;
var statearr_28962_28998 = state_28948__$1;
(statearr_28962_28998[(2)] = inst_28900);

(statearr_28962_28998[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28949 === (17))){
var inst_28918 = (state_28948[(9)]);
var state_28948__$1 = state_28948;
var statearr_28963_28999 = state_28948__$1;
(statearr_28963_28999[(2)] = inst_28918);

(statearr_28963_28999[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28949 === (3))){
var inst_28946 = (state_28948[(2)]);
var state_28948__$1 = state_28948;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28948__$1,inst_28946);
} else {
if((state_val_28949 === (12))){
var inst_28899 = (state_28948[(7)]);
var inst_28910 = (state_28948[(2)]);
var inst_28911 = fluree.db.util.async.throw_err.call(null,inst_28910);
var inst_28912 = (to_t > inst_28899);
var state_28948__$1 = (function (){var statearr_28964 = state_28948;
(statearr_28964[(14)] = inst_28911);

return statearr_28964;
})();
if(cljs.core.truth_(inst_28912)){
var statearr_28965_29000 = state_28948__$1;
(statearr_28965_29000[(1)] = (13));

} else {
var statearr_28966_29001 = state_28948__$1;
(statearr_28966_29001[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28949 === (2))){
var inst_28900 = (state_28948[(15)]);
var _ = (function (){var statearr_28967 = state_28948;
(statearr_28967[(4)] = cljs.core.cons.call(null,(5),(state_28948[(4)])));

return statearr_28967;
})();
var inst_28899 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_28900__$1 = (from_t == null);
var state_28948__$1 = (function (){var statearr_28968 = state_28948;
(statearr_28968[(15)] = inst_28900__$1);

(statearr_28968[(7)] = inst_28899);

return statearr_28968;
})();
if(cljs.core.truth_(inst_28900__$1)){
var statearr_28969_29002 = state_28948__$1;
(statearr_28969_29002[(1)] = (6));

} else {
var statearr_28970_29003 = state_28948__$1;
(statearr_28970_29003[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28949 === (19))){
var state_28948__$1 = state_28948;
var statearr_28971_29004 = state_28948__$1;
(statearr_28971_29004[(2)] = null);

(statearr_28971_29004[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28949 === (11))){
var inst_28927 = (state_28948[(2)]);
var inst_28928 = fluree.db.dbproto._first_flake.call(null,node);
var inst_28929 = fluree.db.dbproto._rhs.call(null,node);
var inst_28930 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_28948__$1 = (function (){var statearr_28973 = state_28948;
(statearr_28973[(10)] = inst_28929);

(statearr_28973[(11)] = inst_28928);

(statearr_28973[(12)] = inst_28927);

return statearr_28973;
})();
if(cljs.core.truth_(inst_28930)){
var statearr_28974_29005 = state_28948__$1;
(statearr_28974_29005[(1)] = (19));

} else {
var statearr_28975_29006 = state_28948__$1;
(statearr_28975_29006[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28949 === (9))){
var inst_28908 = fluree.db.dbproto._resolve_history.call(null,node);
var state_28948__$1 = state_28948;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28948__$1,(12),inst_28908);
} else {
if((state_val_28949 === (5))){
var _ = (function (){var statearr_28976 = state_28948;
(statearr_28976[(4)] = cljs.core.rest.call(null,(state_28948[(4)])));

return statearr_28976;
})();
var state_28948__$1 = state_28948;
var ex28972 = (state_28948__$1[(2)]);
var statearr_28977_29007 = state_28948__$1;
(statearr_28977_29007[(5)] = ex28972);


var statearr_28978_29008 = state_28948__$1;
(statearr_28978_29008[(1)] = (4));

(statearr_28978_29008[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28949 === (14))){
var inst_28911 = (state_28948[(14)]);
var state_28948__$1 = state_28948;
var statearr_28979_29009 = state_28948__$1;
(statearr_28979_29009[(2)] = inst_28911);

(statearr_28979_29009[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28949 === (16))){
var inst_28899 = (state_28948[(7)]);
var inst_28918 = (state_28948[(9)]);
var inst_28920 = (function (){var node_t = inst_28899;
var G__28907 = inst_28918;
return (function (p1__28890_SHARP_){
return (p1__28890_SHARP_.t <= from_t);
});
})();
var inst_28921 = cljs.core.take_while.call(null,inst_28920,inst_28918);
var state_28948__$1 = state_28948;
var statearr_28980_29010 = state_28948__$1;
(statearr_28980_29010[(2)] = inst_28921);

(statearr_28980_29010[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28949 === (10))){
var state_28948__$1 = state_28948;
var statearr_28981_29011 = state_28948__$1;
(statearr_28981_29011[(2)] = null);

(statearr_28981_29011[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28949 === (18))){
var inst_28924 = (state_28948[(2)]);
var state_28948__$1 = state_28948;
var statearr_28982_29012 = state_28948__$1;
(statearr_28982_29012[(2)] = inst_28924);

(statearr_28982_29012[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28949 === (8))){
var inst_28905 = (state_28948[(2)]);
var state_28948__$1 = state_28948;
if(cljs.core.truth_(inst_28905)){
var statearr_28983_29013 = state_28948__$1;
(statearr_28983_29013[(1)] = (9));

} else {
var statearr_28984_29014 = state_28948__$1;
(statearr_28984_29014[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__10945__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__10945__auto____0 = (function (){
var statearr_28985 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28985[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__10945__auto__);

(statearr_28985[(1)] = (1));

return statearr_28985;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__10945__auto____1 = (function (state_28948){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_28948);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e28986){var ex__10948__auto__ = e28986;
var statearr_28987_29015 = state_28948;
(statearr_28987_29015[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_28948[(4)]))){
var statearr_28988_29016 = state_28948;
(statearr_28988_29016[(1)] = cljs.core.first.call(null,(state_28948[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29017 = state_28948;
state_28948 = G__29017;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__10945__auto__ = function(state_28948){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__10945__auto____1.call(this,state_28948);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__10945__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__10945__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_28989 = f__11019__auto__.call(null);
(statearr_28989[(6)] = c__11018__auto__);

return statearr_28989;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__5045__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_.call(null,remove_preds)))){
object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);

return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
} else {
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_29038){
var state_val_29039 = (state_29038[(1)]);
if((state_val_29039 === (7))){
var inst_29027 = (state_29038[(7)]);
var inst_29029 = fluree.db.storage.core.serde.call(null,conn);
var inst_29030 = fluree.db.serde.protocol._deserialize_branch.call(null,inst_29029,inst_29027);
var state_29038__$1 = state_29038;
var statearr_29040_29059 = state_29038__$1;
(statearr_29040_29059[(2)] = inst_29030);

(statearr_29040_29059[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29039 === (1))){
var state_29038__$1 = state_29038;
var statearr_29041_29060 = state_29038__$1;
(statearr_29041_29060[(2)] = null);

(statearr_29041_29060[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29039 === (4))){
var inst_29018 = (state_29038[(2)]);
var state_29038__$1 = state_29038;
var statearr_29042_29061 = state_29038__$1;
(statearr_29042_29061[(2)] = inst_29018);

(statearr_29042_29061[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29039 === (6))){
var inst_29027 = (state_29038[(7)]);
var inst_29026 = (state_29038[(2)]);
var inst_29027__$1 = fluree.db.util.async.throw_err.call(null,inst_29026);
var state_29038__$1 = (function (){var statearr_29043 = state_29038;
(statearr_29043[(7)] = inst_29027__$1);

return statearr_29043;
})();
if(cljs.core.truth_(inst_29027__$1)){
var statearr_29044_29062 = state_29038__$1;
(statearr_29044_29062[(1)] = (7));

} else {
var statearr_29045_29063 = state_29038__$1;
(statearr_29045_29063[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29039 === (3))){
var inst_29036 = (state_29038[(2)]);
var state_29038__$1 = state_29038;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29038__$1,inst_29036);
} else {
if((state_val_29039 === (2))){
var _ = (function (){var statearr_29047 = state_29038;
(statearr_29047[(4)] = cljs.core.cons.call(null,(5),(state_29038[(4)])));

return statearr_29047;
})();
var inst_29024 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_29038__$1 = state_29038;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29038__$1,(6),inst_29024);
} else {
if((state_val_29039 === (9))){
var inst_29033 = (state_29038[(2)]);
var _ = (function (){var statearr_29048 = state_29038;
(statearr_29048[(4)] = cljs.core.rest.call(null,(state_29038[(4)])));

return statearr_29048;
})();
var state_29038__$1 = state_29038;
var statearr_29049_29064 = state_29038__$1;
(statearr_29049_29064[(2)] = inst_29033);

(statearr_29049_29064[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29039 === (5))){
var _ = (function (){var statearr_29050 = state_29038;
(statearr_29050[(4)] = cljs.core.rest.call(null,(state_29038[(4)])));

return statearr_29050;
})();
var state_29038__$1 = state_29038;
var ex29046 = (state_29038__$1[(2)]);
var statearr_29051_29065 = state_29038__$1;
(statearr_29051_29065[(5)] = ex29046);


if((ex29046 instanceof Error)){
var statearr_29052_29066 = state_29038__$1;
(statearr_29052_29066[(1)] = (4));

(statearr_29052_29066[(5)] = null);

} else {
throw ex29046;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29039 === (8))){
var state_29038__$1 = state_29038;
var statearr_29053_29067 = state_29038__$1;
(statearr_29053_29067[(2)] = null);

(statearr_29053_29067[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__10945__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__10945__auto____0 = (function (){
var statearr_29054 = [null,null,null,null,null,null,null,null];
(statearr_29054[(0)] = fluree$db$storage$core$read_branch_$_state_machine__10945__auto__);

(statearr_29054[(1)] = (1));

return statearr_29054;
});
var fluree$db$storage$core$read_branch_$_state_machine__10945__auto____1 = (function (state_29038){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_29038);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e29055){var ex__10948__auto__ = e29055;
var statearr_29056_29068 = state_29038;
(statearr_29056_29068[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_29038[(4)]))){
var statearr_29057_29069 = state_29038;
(statearr_29057_29069[(1)] = cljs.core.first.call(null,(state_29038[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29070 = state_29038;
state_29038 = G__29070;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__10945__auto__ = function(state_29038){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__10945__auto____1.call(this,state_29038);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__10945__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__10945__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_29058 = f__11019__auto__.call(null);
(statearr_29058[(6)] = c__11018__auto__);

return statearr_29058;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__11018__auto___29149 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_29121){
var state_val_29122 = (state_29121[(1)]);
if((state_val_29122 === (7))){
var inst_29088 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_29089 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29090 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_29091 = cljs.core.PersistentHashMap.fromArrays(inst_29089,inst_29090);
var inst_29092 = cljs.core.ex_info.call(null,inst_29088,inst_29091);
var inst_29093 = (function(){throw inst_29092})();
var state_29121__$1 = state_29121;
var statearr_29123_29150 = state_29121__$1;
(statearr_29123_29150[(2)] = inst_29093);

(statearr_29123_29150[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29122 === (1))){
var state_29121__$1 = state_29121;
var statearr_29124_29151 = state_29121__$1;
(statearr_29124_29151[(2)] = null);

(statearr_29124_29151[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29122 === (4))){
var inst_29071 = (state_29121[(2)]);
var inst_29072 = error_fn.call(null);
var inst_29073 = cljs.core.async.put_BANG_.call(null,return_ch,inst_29071);
var inst_29074 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_29121__$1 = (function (){var statearr_29125 = state_29121;
(statearr_29125[(7)] = inst_29073);

(statearr_29125[(8)] = inst_29072);

return statearr_29125;
})();
var statearr_29126_29152 = state_29121__$1;
(statearr_29126_29152[(2)] = inst_29074);

(statearr_29126_29152[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29122 === (6))){
var inst_29085 = (state_29121[(9)]);
var inst_29084 = (state_29121[(2)]);
var inst_29085__$1 = fluree.db.util.async.throw_err.call(null,inst_29084);
var inst_29086 = (inst_29085__$1 == null);
var state_29121__$1 = (function (){var statearr_29127 = state_29121;
(statearr_29127[(9)] = inst_29085__$1);

return statearr_29127;
})();
if(cljs.core.truth_(inst_29086)){
var statearr_29128_29153 = state_29121__$1;
(statearr_29128_29153[(1)] = (7));

} else {
var statearr_29129_29154 = state_29121__$1;
(statearr_29129_29154[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29122 === (3))){
var inst_29119 = (state_29121[(2)]);
var state_29121__$1 = state_29121;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29121__$1,inst_29119);
} else {
if((state_val_29122 === (12))){
var inst_29085 = (state_29121[(9)]);
var inst_29102 = (state_29121[(2)]);
var inst_29103 = cljs.core.__destructure_map.call(null,inst_29085);
var inst_29104 = cljs.core.get.call(null,inst_29103,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_29105 = cljs.core.get.call(null,inst_29103,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_29106 = config;
var inst_29107 = cljs.core.__destructure_map.call(null,inst_29106);
var inst_29108 = cljs.core.get.call(null,inst_29107,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_29110 = (function (){var data = inst_29085;
var _ = inst_29102;
var map__29080 = inst_29103;
var children = inst_29104;
var rhs = inst_29105;
var map__29081 = inst_29107;
var comparator = inst_29108;
return (function (idx,p__29109){
var map__29130 = p__29109;
var map__29130__$1 = cljs.core.__destructure_map.call(null,map__29130);
var child = map__29130__$1;
var id = cljs.core.get.call(null,map__29130__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.call(null,map__29130__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.call(null,map__29130__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.call(null,map__29130__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.call(null,map__29130__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__5043__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return (idx === (0));
} else {
return and__5043__auto__;
}
})();
return fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid);
});
})();
var inst_29111 = cljs.core.map_indexed.call(null,inst_29110,inst_29104);
var inst_29112 = cljs.core.map.call(null,new cljs.core.Keyword(null,"first","first",-644103046),inst_29111);
var inst_29113 = cljs.core.interleave.call(null,inst_29112,inst_29111);
var inst_29114 = cljs.core.apply.call(null,clojure.data.avl.sorted_map_by,inst_29108,inst_29113);
var inst_29115 = fluree.db.index.__GT_IndexNode.call(null,block,t,inst_29105,inst_29114,config,leftmost_QMARK_);
var inst_29116 = cljs.core.async.put_BANG_.call(null,return_ch,inst_29115);
var _ = (function (){var statearr_29131 = state_29121;
(statearr_29131[(4)] = cljs.core.rest.call(null,(state_29121[(4)])));

return statearr_29131;
})();
var state_29121__$1 = state_29121;
var statearr_29132_29155 = state_29121__$1;
(statearr_29132_29155[(2)] = inst_29116);

(statearr_29132_29155[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29122 === (2))){
var _ = (function (){var statearr_29133 = state_29121;
(statearr_29133[(4)] = cljs.core.cons.call(null,(5),(state_29121[(4)])));

return statearr_29133;
})();
var inst_29082 = fluree.db.storage.core.read_branch.call(null,conn,key);
var state_29121__$1 = state_29121;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29121__$1,(6),inst_29082);
} else {
if((state_val_29122 === (11))){
var state_29121__$1 = state_29121;
var statearr_29135_29156 = state_29121__$1;
(statearr_29135_29156[(2)] = null);

(statearr_29135_29156[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29122 === (9))){
var inst_29085 = (state_29121[(9)]);
var inst_29096 = (state_29121[(2)]);
var inst_29097 = fluree.db.util.core.exception_QMARK_.call(null,inst_29085);
var state_29121__$1 = (function (){var statearr_29136 = state_29121;
(statearr_29136[(10)] = inst_29096);

return statearr_29136;
})();
if(inst_29097){
var statearr_29137_29157 = state_29121__$1;
(statearr_29137_29157[(1)] = (10));

} else {
var statearr_29138_29158 = state_29121__$1;
(statearr_29138_29158[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29122 === (5))){
var _ = (function (){var statearr_29139 = state_29121;
(statearr_29139[(4)] = cljs.core.rest.call(null,(state_29121[(4)])));

return statearr_29139;
})();
var state_29121__$1 = state_29121;
var ex29134 = (state_29121__$1[(2)]);
var statearr_29140_29159 = state_29121__$1;
(statearr_29140_29159[(5)] = ex29134);


var statearr_29141_29160 = state_29121__$1;
(statearr_29141_29160[(1)] = (4));

(statearr_29141_29160[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29122 === (10))){
var inst_29085 = (state_29121[(9)]);
var inst_29099 = (function(){throw inst_29085})();
var state_29121__$1 = state_29121;
var statearr_29142_29161 = state_29121__$1;
(statearr_29142_29161[(2)] = inst_29099);

(statearr_29142_29161[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29122 === (8))){
var state_29121__$1 = state_29121;
var statearr_29143_29162 = state_29121__$1;
(statearr_29143_29162[(2)] = null);

(statearr_29143_29162[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__10945__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__10945__auto____0 = (function (){
var statearr_29144 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29144[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__10945__auto__);

(statearr_29144[(1)] = (1));

return statearr_29144;
});
var fluree$db$storage$core$reify_branch_$_state_machine__10945__auto____1 = (function (state_29121){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_29121);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e29145){var ex__10948__auto__ = e29145;
var statearr_29146_29163 = state_29121;
(statearr_29146_29163[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_29121[(4)]))){
var statearr_29147_29164 = state_29121;
(statearr_29147_29164[(1)] = cljs.core.first.call(null,(state_29121[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29165 = state_29121;
state_29121 = G__29165;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__10945__auto__ = function(state_29121){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__10945__auto____1.call(this,state_29121);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__10945__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__10945__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_29148 = f__11019__auto__.call(null);
(statearr_29148[(6)] = c__11018__auto___29149);

return statearr_29148;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_29186){
var state_val_29187 = (state_29186[(1)]);
if((state_val_29187 === (7))){
var state_29186__$1 = state_29186;
var statearr_29188_29208 = state_29186__$1;
(statearr_29188_29208[(2)] = null);

(statearr_29188_29208[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (1))){
var state_29186__$1 = state_29186;
var statearr_29189_29209 = state_29186__$1;
(statearr_29189_29209[(2)] = null);

(statearr_29189_29209[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (4))){
var inst_29166 = (state_29186[(2)]);
var state_29186__$1 = state_29186;
var statearr_29190_29210 = state_29186__$1;
(statearr_29190_29210[(2)] = inst_29166);

(statearr_29190_29210[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (6))){
var inst_29172 = (state_29186[(7)]);
var inst_29174 = fluree.db.storage.core.serde.call(null,conn);
var state_29186__$1 = (function (){var statearr_29191 = state_29186;
(statearr_29191[(8)] = inst_29174);

return statearr_29191;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29186__$1,(9),inst_29172);
} else {
if((state_val_29187 === (3))){
var inst_29184 = (state_29186[(2)]);
var state_29186__$1 = state_29186;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29186__$1,inst_29184);
} else {
if((state_val_29187 === (2))){
var inst_29172 = (state_29186[(7)]);
var _ = (function (){var statearr_29193 = state_29186;
(statearr_29193[(4)] = cljs.core.cons.call(null,(5),(state_29186[(4)])));

return statearr_29193;
})();
var inst_29172__$1 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_29186__$1 = (function (){var statearr_29194 = state_29186;
(statearr_29194[(7)] = inst_29172__$1);

return statearr_29194;
})();
if(cljs.core.truth_(inst_29172__$1)){
var statearr_29195_29211 = state_29186__$1;
(statearr_29195_29211[(1)] = (6));

} else {
var statearr_29196_29212 = state_29186__$1;
(statearr_29196_29212[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (9))){
var inst_29174 = (state_29186[(8)]);
var inst_29176 = (state_29186[(2)]);
var inst_29177 = fluree.db.util.async.throw_err.call(null,inst_29176);
var inst_29178 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_29174,inst_29177);
var state_29186__$1 = state_29186;
var statearr_29197_29213 = state_29186__$1;
(statearr_29197_29213[(2)] = inst_29178);

(statearr_29197_29213[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (5))){
var _ = (function (){var statearr_29198 = state_29186;
(statearr_29198[(4)] = cljs.core.rest.call(null,(state_29186[(4)])));

return statearr_29198;
})();
var state_29186__$1 = state_29186;
var ex29192 = (state_29186__$1[(2)]);
var statearr_29199_29214 = state_29186__$1;
(statearr_29199_29214[(5)] = ex29192);


if((ex29192 instanceof Error)){
var statearr_29200_29215 = state_29186__$1;
(statearr_29200_29215[(1)] = (4));

(statearr_29200_29215[(5)] = null);

} else {
throw ex29192;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (8))){
var inst_29181 = (state_29186[(2)]);
var _ = (function (){var statearr_29201 = state_29186;
(statearr_29201[(4)] = cljs.core.rest.call(null,(state_29186[(4)])));

return statearr_29201;
})();
var state_29186__$1 = state_29186;
var statearr_29202_29216 = state_29186__$1;
(statearr_29202_29216[(2)] = inst_29181);

(statearr_29202_29216[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__10945__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__10945__auto____0 = (function (){
var statearr_29203 = [null,null,null,null,null,null,null,null,null];
(statearr_29203[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__10945__auto__);

(statearr_29203[(1)] = (1));

return statearr_29203;
});
var fluree$db$storage$core$read_leaf_$_state_machine__10945__auto____1 = (function (state_29186){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_29186);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e29204){var ex__10948__auto__ = e29204;
var statearr_29205_29217 = state_29186;
(statearr_29205_29217[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_29186[(4)]))){
var statearr_29206_29218 = state_29186;
(statearr_29206_29218[(1)] = cljs.core.first.call(null,(state_29186[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29219 = state_29186;
state_29186 = G__29219;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__10945__auto__ = function(state_29186){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__10945__auto____1.call(this,state_29186);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__10945__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__10945__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_29207 = f__11019__auto__.call(null);
(statearr_29207[(6)] = c__11018__auto__);

return statearr_29207;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.call(null,config)].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.call(null);
var c__11018__auto___29292 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_29264){
var state_val_29265 = (state_29264[(1)]);
if((state_val_29265 === (7))){
var inst_29236 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_29237 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29238 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_29239 = cljs.core.PersistentHashMap.fromArrays(inst_29237,inst_29238);
var inst_29240 = cljs.core.ex_info.call(null,inst_29236,inst_29239);
var inst_29241 = (function(){throw inst_29240})();
var state_29264__$1 = state_29264;
var statearr_29266_29293 = state_29264__$1;
(statearr_29266_29293[(2)] = inst_29241);

(statearr_29266_29293[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29265 === (1))){
var state_29264__$1 = state_29264;
var statearr_29267_29294 = state_29264__$1;
(statearr_29267_29294[(2)] = null);

(statearr_29267_29294[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29265 === (4))){
var inst_29220 = (state_29264[(2)]);
var inst_29221 = error_fn.call(null);
var inst_29222 = cljs.core.async.put_BANG_.call(null,return_ch,inst_29220);
var inst_29223 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_29264__$1 = (function (){var statearr_29268 = state_29264;
(statearr_29268[(7)] = inst_29222);

(statearr_29268[(8)] = inst_29221);

return statearr_29268;
})();
var statearr_29269_29295 = state_29264__$1;
(statearr_29269_29295[(2)] = inst_29223);

(statearr_29269_29295[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29265 === (6))){
var inst_29233 = (state_29264[(9)]);
var inst_29233__$1 = (state_29264[(2)]);
var inst_29234 = (inst_29233__$1 == null);
var state_29264__$1 = (function (){var statearr_29270 = state_29264;
(statearr_29270[(9)] = inst_29233__$1);

return statearr_29270;
})();
if(cljs.core.truth_(inst_29234)){
var statearr_29271_29296 = state_29264__$1;
(statearr_29271_29296[(1)] = (7));

} else {
var statearr_29272_29297 = state_29264__$1;
(statearr_29272_29297[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29265 === (3))){
var inst_29262 = (state_29264[(2)]);
var state_29264__$1 = state_29264;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29264__$1,inst_29262);
} else {
if((state_val_29265 === (12))){
var inst_29233 = (state_29264[(9)]);
var inst_29250 = (state_29264[(2)]);
var inst_29251 = cljs.core.__destructure_map.call(null,inst_29233);
var inst_29252 = cljs.core.get.call(null,inst_29251,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_29253 = cljs.core.get.call(null,inst_29251,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_29254 = config;
var inst_29255 = cljs.core.__destructure_map.call(null,inst_29254);
var inst_29256 = cljs.core.get.call(null,inst_29255,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_29257 = cljs.core.apply.call(null,fluree.db.flake.sorted_set_by,inst_29256,inst_29252);
var inst_29258 = fluree.db.index.data_node.call(null,block,t,inst_29257,rhs,config);
var inst_29259 = cljs.core.async.put_BANG_.call(null,return_ch,inst_29258);
var _ = (function (){var statearr_29273 = state_29264;
(statearr_29273[(4)] = cljs.core.rest.call(null,(state_29264[(4)])));

return statearr_29273;
})();
var state_29264__$1 = (function (){var statearr_29274 = state_29264;
(statearr_29274[(10)] = inst_29250);

(statearr_29274[(11)] = inst_29253);

return statearr_29274;
})();
var statearr_29275_29298 = state_29264__$1;
(statearr_29275_29298[(2)] = inst_29259);

(statearr_29275_29298[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29265 === (2))){
var _ = (function (){var statearr_29276 = state_29264;
(statearr_29276[(4)] = cljs.core.cons.call(null,(5),(state_29264[(4)])));

return statearr_29276;
})();
var inst_29231 = fluree.db.storage.core.read_leaf.call(null,conn,key);
var state_29264__$1 = state_29264;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29264__$1,(6),inst_29231);
} else {
if((state_val_29265 === (11))){
var state_29264__$1 = state_29264;
var statearr_29278_29299 = state_29264__$1;
(statearr_29278_29299[(2)] = null);

(statearr_29278_29299[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29265 === (9))){
var inst_29233 = (state_29264[(9)]);
var inst_29244 = (state_29264[(2)]);
var inst_29245 = fluree.db.util.core.exception_QMARK_.call(null,inst_29233);
var state_29264__$1 = (function (){var statearr_29279 = state_29264;
(statearr_29279[(12)] = inst_29244);

return statearr_29279;
})();
if(inst_29245){
var statearr_29280_29300 = state_29264__$1;
(statearr_29280_29300[(1)] = (10));

} else {
var statearr_29281_29301 = state_29264__$1;
(statearr_29281_29301[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29265 === (5))){
var _ = (function (){var statearr_29282 = state_29264;
(statearr_29282[(4)] = cljs.core.rest.call(null,(state_29264[(4)])));

return statearr_29282;
})();
var state_29264__$1 = state_29264;
var ex29277 = (state_29264__$1[(2)]);
var statearr_29283_29302 = state_29264__$1;
(statearr_29283_29302[(5)] = ex29277);


var statearr_29284_29303 = state_29264__$1;
(statearr_29284_29303[(1)] = (4));

(statearr_29284_29303[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29265 === (10))){
var inst_29233 = (state_29264[(9)]);
var inst_29247 = (function(){throw inst_29233})();
var state_29264__$1 = state_29264;
var statearr_29285_29304 = state_29264__$1;
(statearr_29285_29304[(2)] = inst_29247);

(statearr_29285_29304[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29265 === (8))){
var state_29264__$1 = state_29264;
var statearr_29286_29305 = state_29264__$1;
(statearr_29286_29305[(2)] = null);

(statearr_29286_29305[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__10945__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__10945__auto____0 = (function (){
var statearr_29287 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29287[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__10945__auto__);

(statearr_29287[(1)] = (1));

return statearr_29287;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__10945__auto____1 = (function (state_29264){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_29264);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e29288){var ex__10948__auto__ = e29288;
var statearr_29289_29306 = state_29264;
(statearr_29289_29306[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_29264[(4)]))){
var statearr_29290_29307 = state_29264;
(statearr_29290_29307[(1)] = cljs.core.first.call(null,(state_29264[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29308 = state_29264;
state_29264 = G__29308;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__10945__auto__ = function(state_29264){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__10945__auto____1.call(this,state_29264);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__10945__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__10945__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_29291 = f__11019__auto__.call(null);
(statearr_29291[(6)] = c__11018__auto___29292);

return statearr_29291;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5342__auto__,k__5343__auto__){
var self__ = this;
var this__5342__auto____$1 = this;
return this__5342__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5343__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5344__auto__,k29310,else__5345__auto__){
var self__ = this;
var this__5344__auto____$1 = this;
var G__29314 = k29310;
var G__29314__$1 = (((G__29314 instanceof cljs.core.Keyword))?G__29314.fqn:null);
switch (G__29314__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k29310,else__5345__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5362__auto__,f__5363__auto__,init__5364__auto__){
var self__ = this;
var this__5362__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5365__auto__,p__29315){
var vec__29316 = p__29315;
var k__5366__auto__ = cljs.core.nth.call(null,vec__29316,(0),null);
var v__5367__auto__ = cljs.core.nth.call(null,vec__29316,(1),null);
return f__5363__auto__.call(null,ret__5365__auto__,k__5366__auto__,v__5367__auto__);
}),init__5364__auto__,this__5362__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5357__auto__,writer__5358__auto__,opts__5359__auto__){
var self__ = this;
var this__5357__auto____$1 = this;
var pr_pair__5360__auto__ = (function (keyval__5361__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5358__auto__,cljs.core.pr_writer,""," ","",opts__5359__auto__,keyval__5361__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5358__auto__,pr_pair__5360__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__5359__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__29309){
var self__ = this;
var G__29309__$1 = this;
return (new cljs.core.RecordIter((0),G__29309__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.call(null);
cljs.core.async.put_BANG_.call(null,pc,fluree.db.index.data_node.call(null,(0),(0),fluree.db.flake.sorted_set_by.call(null,new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),(function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf.call(null,self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
} else {
return fluree.db.storage.core.reify_branch.call(null,self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
}
}));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return object_cache.call(null,history_id,null);
});
return object_cache.call(null,history_id,(function (___$2){
return fluree.db.storage.core.reify_history.call(null,self__.conn,history_id,error_fn);
}));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5340__auto__){
var self__ = this;
var this__5340__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5337__auto__){
var self__ = this;
var this__5337__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5346__auto__){
var self__ = this;
var this__5346__auto____$1 = this;
return (14 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5339__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll.call(null,coll__5339__auto__));
}).call(null,this__5338__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this29311,other29312){
var self__ = this;
var this29311__$1 = this;
return (((!((other29312 == null)))) && ((((this29311__$1.constructor === other29312.constructor)) && (((cljs.core._EQ_.call(null,this29311__$1.conn,other29312.conn)) && (((cljs.core._EQ_.call(null,this29311__$1.config,other29312.config)) && (((cljs.core._EQ_.call(null,this29311__$1.network,other29312.network)) && (((cljs.core._EQ_.call(null,this29311__$1.dbid,other29312.dbid)) && (((cljs.core._EQ_.call(null,this29311__$1.id,other29312.id)) && (((cljs.core._EQ_.call(null,this29311__$1.leaf,other29312.leaf)) && (((cljs.core._EQ_.call(null,this29311__$1.first,other29312.first)) && (((cljs.core._EQ_.call(null,this29311__$1.rhs,other29312.rhs)) && (((cljs.core._EQ_.call(null,this29311__$1.size,other29312.size)) && (((cljs.core._EQ_.call(null,this29311__$1.block,other29312.block)) && (((cljs.core._EQ_.call(null,this29311__$1.t,other29312.t)) && (((cljs.core._EQ_.call(null,this29311__$1.tt_id,other29312.tt_id)) && (((cljs.core._EQ_.call(null,this29311__$1.leftmost_QMARK_,other29312.leftmost_QMARK_)) && (((cljs.core._EQ_.call(null,this29311__$1.tempid,other29312.tempid)) && (cljs.core._EQ_.call(null,this29311__$1.__extmap,other29312.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5352__auto__,k__5353__auto__){
var self__ = this;
var this__5352__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5353__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5352__auto____$1),self__.__meta),k__5353__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5353__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5349__auto__,k29310){
var self__ = this;
var this__5349__auto____$1 = this;
var G__29319 = k29310;
var G__29319__$1 = (((G__29319 instanceof cljs.core.Keyword))?G__29319.fqn:null);
switch (G__29319__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k29310);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5350__auto__,k__5351__auto__,G__29309){
var self__ = this;
var this__5350__auto____$1 = this;
var pred__29320 = cljs.core.keyword_identical_QMARK_;
var expr__29321 = k__5351__auto__;
if(cljs.core.truth_(pred__29320.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__29321))){
return (new fluree.db.storage.core.UnresolvedNode(G__29309,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__29320.call(null,new cljs.core.Keyword(null,"config","config",994861415),expr__29321))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__29309,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__29320.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__29321))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__29309,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__29320.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__29321))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__29309,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__29320.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__29321))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__29309,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__29320.call(null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),expr__29321))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__29309,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__29320.call(null,new cljs.core.Keyword(null,"first","first",-644103046),expr__29321))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__29309,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__29320.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),expr__29321))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__29309,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__29320.call(null,new cljs.core.Keyword(null,"size","size",1098693007),expr__29321))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__29309,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__29320.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__29321))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__29309,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__29320.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__29321))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__29309,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__29320.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__29321))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__29309,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__29320.call(null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),expr__29321))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__29309,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__29320.call(null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),expr__29321))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__29309,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5351__auto__,G__29309),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5355__auto__){
var self__ = this;
var this__5355__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5341__auto__,G__29309){
var self__ = this;
var this__5341__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__29309,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5347__auto__,entry__5348__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5348__auto__)){
return this__5347__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5348__auto__,(0)),cljs.core._nth.call(null,entry__5348__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5347__auto____$1,entry__5348__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__5388__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__5388__auto__,writer__5389__auto__){
return cljs.core._write.call(null,writer__5389__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__29313){
var extmap__5384__auto__ = (function (){var G__29323 = cljs.core.dissoc.call(null,G__29313,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222));
if(cljs.core.record_QMARK_.call(null,G__29313)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__29323);
} else {
return G__29323;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__29313),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__29313),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__29313),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__29313),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__29313),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__29313),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__29313),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__29313),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__29313),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__29313),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__29313),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__29313),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__29313),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__29313),null,cljs.core.not_empty.call(null,extmap__5384__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__5045__auto__ = cljs.core.get.call(null,index_configs,index);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Internal error reifying db root index: ",cljs.core.pr_str.call(null,index)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.assoc.call(null,index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__29326 = blank_db;
var map__29326__$1 = cljs.core.__destructure_map.call(null,map__29326);
var network = cljs.core.get.call(null,map__29326__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__29326__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.call(null,map__29326__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__29327 = root_data;
var map__29327__$1 = cljs.core.__destructure_map.call(null,map__29327);
var block = cljs.core.get.call(null,map__29327__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__29327__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.call(null,map__29327__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.call(null,map__29327__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.call(null,blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.call(null,stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block));
return cljs.core.reduce.call(null,(function (db,idx){
return cljs.core.assoc.call(null,db,idx,fluree.db.storage.core.reify_index_root.call(null,conn,index_configs,network,dbid,idx,cljs.core.get.call(null,root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_29349){
var state_val_29350 = (state_29349[(1)]);
if((state_val_29350 === (7))){
var state_29349__$1 = state_29349;
var statearr_29351_29371 = state_29349__$1;
(statearr_29351_29371[(2)] = null);

(statearr_29351_29371[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29350 === (1))){
var state_29349__$1 = state_29349;
var statearr_29352_29372 = state_29349__$1;
(statearr_29352_29372[(2)] = null);

(statearr_29352_29372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29350 === (4))){
var inst_29328 = (state_29349[(2)]);
var state_29349__$1 = state_29349;
var statearr_29353_29373 = state_29349__$1;
(statearr_29353_29373[(2)] = inst_29328);

(statearr_29353_29373[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29350 === (6))){
var inst_29335 = (state_29349[(7)]);
var inst_29337 = fluree.db.storage.core.serde.call(null,conn);
var state_29349__$1 = (function (){var statearr_29354 = state_29349;
(statearr_29354[(8)] = inst_29337);

return statearr_29354;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29349__$1,(9),inst_29335);
} else {
if((state_val_29350 === (3))){
var inst_29347 = (state_29349[(2)]);
var state_29349__$1 = state_29349;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29349__$1,inst_29347);
} else {
if((state_val_29350 === (2))){
var inst_29335 = (state_29349[(7)]);
var _ = (function (){var statearr_29356 = state_29349;
(statearr_29356[(4)] = cljs.core.cons.call(null,(5),(state_29349[(4)])));

return statearr_29356;
})();
var inst_29334 = fluree.db.storage.core.ledger_garbage_key.call(null,network,dbid,block);
var inst_29335__$1 = fluree.db.storage.core.storage_read.call(null,conn,inst_29334);
var state_29349__$1 = (function (){var statearr_29357 = state_29349;
(statearr_29357[(7)] = inst_29335__$1);

return statearr_29357;
})();
if(cljs.core.truth_(inst_29335__$1)){
var statearr_29358_29374 = state_29349__$1;
(statearr_29358_29374[(1)] = (6));

} else {
var statearr_29359_29375 = state_29349__$1;
(statearr_29359_29375[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29350 === (9))){
var inst_29337 = (state_29349[(8)]);
var inst_29339 = (state_29349[(2)]);
var inst_29340 = fluree.db.util.async.throw_err.call(null,inst_29339);
var inst_29341 = fluree.db.serde.protocol._deserialize_garbage.call(null,inst_29337,inst_29340);
var state_29349__$1 = state_29349;
var statearr_29360_29376 = state_29349__$1;
(statearr_29360_29376[(2)] = inst_29341);

(statearr_29360_29376[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29350 === (5))){
var _ = (function (){var statearr_29361 = state_29349;
(statearr_29361[(4)] = cljs.core.rest.call(null,(state_29349[(4)])));

return statearr_29361;
})();
var state_29349__$1 = state_29349;
var ex29355 = (state_29349__$1[(2)]);
var statearr_29362_29377 = state_29349__$1;
(statearr_29362_29377[(5)] = ex29355);


if((ex29355 instanceof Error)){
var statearr_29363_29378 = state_29349__$1;
(statearr_29363_29378[(1)] = (4));

(statearr_29363_29378[(5)] = null);

} else {
throw ex29355;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29350 === (8))){
var inst_29344 = (state_29349[(2)]);
var _ = (function (){var statearr_29364 = state_29349;
(statearr_29364[(4)] = cljs.core.rest.call(null,(state_29349[(4)])));

return statearr_29364;
})();
var state_29349__$1 = state_29349;
var statearr_29365_29379 = state_29349__$1;
(statearr_29365_29379[(2)] = inst_29344);

(statearr_29365_29379[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__10945__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__10945__auto____0 = (function (){
var statearr_29366 = [null,null,null,null,null,null,null,null,null];
(statearr_29366[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__10945__auto__);

(statearr_29366[(1)] = (1));

return statearr_29366;
});
var fluree$db$storage$core$read_garbage_$_state_machine__10945__auto____1 = (function (state_29349){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_29349);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e29367){var ex__10948__auto__ = e29367;
var statearr_29368_29380 = state_29349;
(statearr_29368_29380[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_29349[(4)]))){
var statearr_29369_29381 = state_29349;
(statearr_29369_29381[(1)] = cljs.core.first.call(null,(state_29349[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29382 = state_29349;
state_29349 = G__29382;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__10945__auto__ = function(state_29349){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__10945__auto____1.call(this,state_29349);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__10945__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__10945__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_29370 = f__11019__auto__.call(null);
(statearr_29370[(6)] = c__11018__auto__);

return statearr_29370;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_29404){
var state_val_29405 = (state_29404[(1)]);
if((state_val_29405 === (7))){
var inst_29393 = (state_29404[(7)]);
var inst_29395 = fluree.db.storage.core.serde.call(null,conn);
var inst_29396 = fluree.db.serde.protocol._deserialize_db_root.call(null,inst_29395,inst_29393);
var state_29404__$1 = state_29404;
var statearr_29406_29425 = state_29404__$1;
(statearr_29406_29425[(2)] = inst_29396);

(statearr_29406_29425[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29405 === (1))){
var state_29404__$1 = state_29404;
var statearr_29407_29426 = state_29404__$1;
(statearr_29407_29426[(2)] = null);

(statearr_29407_29426[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29405 === (4))){
var inst_29383 = (state_29404[(2)]);
var state_29404__$1 = state_29404;
var statearr_29408_29427 = state_29404__$1;
(statearr_29408_29427[(2)] = inst_29383);

(statearr_29408_29427[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29405 === (6))){
var inst_29393 = (state_29404[(7)]);
var inst_29392 = (state_29404[(2)]);
var inst_29393__$1 = fluree.db.util.async.throw_err.call(null,inst_29392);
var state_29404__$1 = (function (){var statearr_29409 = state_29404;
(statearr_29409[(7)] = inst_29393__$1);

return statearr_29409;
})();
if(cljs.core.truth_(inst_29393__$1)){
var statearr_29410_29428 = state_29404__$1;
(statearr_29410_29428[(1)] = (7));

} else {
var statearr_29411_29429 = state_29404__$1;
(statearr_29411_29429[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29405 === (3))){
var inst_29402 = (state_29404[(2)]);
var state_29404__$1 = state_29404;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29404__$1,inst_29402);
} else {
if((state_val_29405 === (2))){
var _ = (function (){var statearr_29413 = state_29404;
(statearr_29413[(4)] = cljs.core.cons.call(null,(5),(state_29404[(4)])));

return statearr_29413;
})();
var inst_29389 = fluree.db.storage.core.ledger_root_key.call(null,network,dbid,block);
var inst_29390 = fluree.db.storage.core.storage_read.call(null,conn,inst_29389);
var state_29404__$1 = state_29404;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29404__$1,(6),inst_29390);
} else {
if((state_val_29405 === (9))){
var inst_29399 = (state_29404[(2)]);
var _ = (function (){var statearr_29414 = state_29404;
(statearr_29414[(4)] = cljs.core.rest.call(null,(state_29404[(4)])));

return statearr_29414;
})();
var state_29404__$1 = state_29404;
var statearr_29415_29430 = state_29404__$1;
(statearr_29415_29430[(2)] = inst_29399);

(statearr_29415_29430[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29405 === (5))){
var _ = (function (){var statearr_29416 = state_29404;
(statearr_29416[(4)] = cljs.core.rest.call(null,(state_29404[(4)])));

return statearr_29416;
})();
var state_29404__$1 = state_29404;
var ex29412 = (state_29404__$1[(2)]);
var statearr_29417_29431 = state_29404__$1;
(statearr_29417_29431[(5)] = ex29412);


if((ex29412 instanceof Error)){
var statearr_29418_29432 = state_29404__$1;
(statearr_29418_29432[(1)] = (4));

(statearr_29418_29432[(5)] = null);

} else {
throw ex29412;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29405 === (8))){
var state_29404__$1 = state_29404;
var statearr_29419_29433 = state_29404__$1;
(statearr_29419_29433[(2)] = null);

(statearr_29419_29433[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__10945__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__10945__auto____0 = (function (){
var statearr_29420 = [null,null,null,null,null,null,null,null];
(statearr_29420[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__10945__auto__);

(statearr_29420[(1)] = (1));

return statearr_29420;
});
var fluree$db$storage$core$read_db_root_$_state_machine__10945__auto____1 = (function (state_29404){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_29404);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e29421){var ex__10948__auto__ = e29421;
var statearr_29422_29434 = state_29404;
(statearr_29422_29434[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_29404[(4)]))){
var statearr_29423_29435 = state_29404;
(statearr_29423_29435[(1)] = cljs.core.first.call(null,(state_29404[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29436 = state_29404;
state_29404 = G__29436;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__10945__auto__ = function(state_29404){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__10945__auto____1.call(this,state_29404);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__10945__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__10945__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_29424 = f__11019__auto__.call(null);
(statearr_29424[(6)] = c__11018__auto__);

return statearr_29424;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_29472){
var state_val_29473 = (state_29472[(1)]);
if((state_val_29473 === (7))){
var inst_29446 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_29447 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29448 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_29449 = cljs.core.PersistentHashMap.fromArrays(inst_29447,inst_29448);
var inst_29450 = cljs.core.ex_info.call(null,inst_29446,inst_29449);
var inst_29451 = (function(){throw inst_29450})();
var state_29472__$1 = state_29472;
var statearr_29474_29496 = state_29472__$1;
(statearr_29474_29496[(2)] = inst_29451);

(statearr_29474_29496[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29473 === (1))){
var state_29472__$1 = state_29472;
var statearr_29475_29497 = state_29472__$1;
(statearr_29475_29497[(2)] = null);

(statearr_29475_29497[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29473 === (4))){
var inst_29437 = (state_29472[(2)]);
var state_29472__$1 = state_29472;
var statearr_29476_29498 = state_29472__$1;
(statearr_29476_29498[(2)] = inst_29437);

(statearr_29476_29498[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29473 === (6))){
var state_29472__$1 = state_29472;
var statearr_29477_29499 = state_29472__$1;
(statearr_29477_29499[(2)] = null);

(statearr_29477_29499[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29473 === (3))){
var inst_29470 = (state_29472[(2)]);
var state_29472__$1 = state_29472;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29472__$1,inst_29470);
} else {
if((state_val_29473 === (2))){
var inst_29443 = (state_29472[(7)]);
var _ = (function (){var statearr_29478 = state_29472;
(statearr_29478[(4)] = cljs.core.cons.call(null,(5),(state_29472[(4)])));

return statearr_29478;
})();
var inst_29443__$1 = fluree.db.storage.core.read_db_root.call(null,conn,network,dbid,index);
var state_29472__$1 = (function (){var statearr_29479 = state_29472;
(statearr_29479[(7)] = inst_29443__$1);

return statearr_29479;
})();
if(cljs.core.truth_(inst_29443__$1)){
var statearr_29480_29500 = state_29472__$1;
(statearr_29480_29500[(1)] = (6));

} else {
var statearr_29481_29501 = state_29472__$1;
(statearr_29481_29501[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29473 === (11))){
var inst_29462 = (state_29472[(8)]);
var inst_29465 = (state_29472[(2)]);
var inst_29466 = fluree.db.util.async.throw_err.call(null,inst_29465);
var inst_29467 = cljs.core.assoc.call(null,inst_29462,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_29466);
var _ = (function (){var statearr_29483 = state_29472;
(statearr_29483[(4)] = cljs.core.rest.call(null,(state_29472[(4)])));

return statearr_29483;
})();
var state_29472__$1 = state_29472;
var statearr_29484_29502 = state_29472__$1;
(statearr_29484_29502[(2)] = inst_29467);

(statearr_29484_29502[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29473 === (9))){
var inst_29457 = (state_29472[(9)]);
var inst_29455 = (state_29472[(2)]);
var inst_29456 = fluree.db.util.async.throw_err.call(null,inst_29455);
var inst_29457__$1 = fluree.db.storage.core.reify_db_root.call(null,conn,blank_db,inst_29456);
var inst_29458 = fluree.db.query.schema.schema_map.call(null,inst_29457__$1);
var state_29472__$1 = (function (){var statearr_29485 = state_29472;
(statearr_29485[(9)] = inst_29457__$1);

return statearr_29485;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29472__$1,(10),inst_29458);
} else {
if((state_val_29473 === (5))){
var _ = (function (){var statearr_29486 = state_29472;
(statearr_29486[(4)] = cljs.core.rest.call(null,(state_29472[(4)])));

return statearr_29486;
})();
var state_29472__$1 = state_29472;
var ex29482 = (state_29472__$1[(2)]);
var statearr_29487_29503 = state_29472__$1;
(statearr_29487_29503[(5)] = ex29482);


if((ex29482 instanceof Error)){
var statearr_29488_29504 = state_29472__$1;
(statearr_29488_29504[(1)] = (4));

(statearr_29488_29504[(5)] = null);

} else {
throw ex29482;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29473 === (10))){
var inst_29462 = (state_29472[(8)]);
var inst_29457 = (state_29472[(9)]);
var inst_29460 = (state_29472[(2)]);
var inst_29461 = fluree.db.util.async.throw_err.call(null,inst_29460);
var inst_29462__$1 = cljs.core.assoc.call(null,inst_29457,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_29461);
var inst_29463 = fluree.db.query.schema.setting_map.call(null,inst_29462__$1);
var state_29472__$1 = (function (){var statearr_29489 = state_29472;
(statearr_29489[(8)] = inst_29462__$1);

return statearr_29489;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29472__$1,(11),inst_29463);
} else {
if((state_val_29473 === (8))){
var inst_29443 = (state_29472[(7)]);
var inst_29453 = (state_29472[(2)]);
var state_29472__$1 = (function (){var statearr_29490 = state_29472;
(statearr_29490[(10)] = inst_29453);

return statearr_29490;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29472__$1,(9),inst_29443);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__10945__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__10945__auto____0 = (function (){
var statearr_29491 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29491[(0)] = fluree$db$storage$core$reify_db_$_state_machine__10945__auto__);

(statearr_29491[(1)] = (1));

return statearr_29491;
});
var fluree$db$storage$core$reify_db_$_state_machine__10945__auto____1 = (function (state_29472){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_29472);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e29492){var ex__10948__auto__ = e29492;
var statearr_29493_29505 = state_29472;
(statearr_29493_29505[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_29472[(4)]))){
var statearr_29494_29506 = state_29472;
(statearr_29494_29506[(1)] = cljs.core.first.call(null,(state_29472[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29507 = state_29472;
state_29472 = G__29507;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__10945__auto__ = function(state_29472){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__10945__auto____1.call(this,state_29472);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__10945__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__10945__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_29495 = f__11019__auto__.call(null);
(statearr_29495[(6)] = c__11018__auto__);

return statearr_29495;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__29509 = arguments.length;
switch (G__29509) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.call(null,conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.call(null,"Block-range request: ",network,dbid,start,end);

var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_29562){
var state_val_29563 = (state_29562[(1)]);
if((state_val_29563 === (7))){
var inst_29519 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_29520 = (new Error(inst_29519));
var inst_29521 = (function(){throw inst_29520})();
var state_29562__$1 = state_29562;
var statearr_29564_29604 = state_29562__$1;
(statearr_29564_29604[(2)] = inst_29521);

(statearr_29564_29604[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29563 === (20))){
var inst_29553 = (state_29562[(2)]);
var state_29562__$1 = state_29562;
var statearr_29565_29605 = state_29562__$1;
(statearr_29565_29605[(2)] = inst_29553);

(statearr_29565_29605[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29563 === (1))){
var state_29562__$1 = state_29562;
var statearr_29566_29606 = state_29562__$1;
(statearr_29566_29606[(2)] = null);

(statearr_29566_29606[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29563 === (4))){
var inst_29510 = (state_29562[(2)]);
var state_29562__$1 = state_29562;
var statearr_29567_29607 = state_29562__$1;
(statearr_29567_29607[(2)] = inst_29510);

(statearr_29567_29607[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29563 === (15))){
var inst_29528 = (state_29562[(7)]);
var state_29562__$1 = state_29562;
var statearr_29568_29608 = state_29562__$1;
(statearr_29568_29608[(2)] = inst_29528);

(statearr_29568_29608[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29563 === (21))){
var inst_29528 = (state_29562[(7)]);
var inst_29532 = (state_29562[(8)]);
var inst_29527 = (state_29562[(9)]);
var inst_29546 = (inst_29527 + (1));
var inst_29547 = cljs.core.conj.call(null,inst_29528,inst_29532);
var inst_29527__$1 = inst_29546;
var inst_29528__$1 = inst_29547;
var state_29562__$1 = (function (){var statearr_29569 = state_29562;
(statearr_29569[(7)] = inst_29528__$1);

(statearr_29569[(9)] = inst_29527__$1);

return statearr_29569;
})();
var statearr_29570_29609 = state_29562__$1;
(statearr_29570_29609[(2)] = null);

(statearr_29570_29609[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29563 === (13))){
var inst_29532 = (state_29562[(8)]);
var inst_29536 = (inst_29532 instanceof Error);
var state_29562__$1 = state_29562;
var statearr_29571_29610 = state_29562__$1;
(statearr_29571_29610[(2)] = inst_29536);

(statearr_29571_29610[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29563 === (22))){
var state_29562__$1 = state_29562;
var statearr_29572_29611 = state_29562__$1;
(statearr_29572_29611[(2)] = null);

(statearr_29572_29611[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29563 === (6))){
var state_29562__$1 = state_29562;
var statearr_29573_29612 = state_29562__$1;
(statearr_29573_29612[(2)] = null);

(statearr_29573_29612[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29563 === (17))){
var inst_29555 = (state_29562[(2)]);
var state_29562__$1 = state_29562;
var statearr_29574_29613 = state_29562__$1;
(statearr_29574_29613[(2)] = inst_29555);

(statearr_29574_29613[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29563 === (3))){
var inst_29560 = (state_29562[(2)]);
var state_29562__$1 = state_29562;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29562__$1,inst_29560);
} else {
if((state_val_29563 === (12))){
var inst_29533 = (state_29562[(10)]);
var state_29562__$1 = state_29562;
var statearr_29575_29614 = state_29562__$1;
(statearr_29575_29614[(2)] = inst_29533);

(statearr_29575_29614[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29563 === (2))){
var _ = (function (){var statearr_29576 = state_29562;
(statearr_29576[(4)] = cljs.core.cons.call(null,(5),(state_29562[(4)])));

return statearr_29576;
})();
var inst_29516 = (end >= start);
var state_29562__$1 = state_29562;
if(cljs.core.truth_(inst_29516)){
var statearr_29577_29615 = state_29562__$1;
(statearr_29577_29615[(1)] = (6));

} else {
var statearr_29578_29616 = state_29562__$1;
(statearr_29578_29616[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29563 === (23))){
var inst_29551 = (state_29562[(2)]);
var state_29562__$1 = state_29562;
var statearr_29579_29617 = state_29562__$1;
(statearr_29579_29617[(2)] = inst_29551);

(statearr_29579_29617[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29563 === (19))){
var state_29562__$1 = state_29562;
var statearr_29580_29618 = state_29562__$1;
(statearr_29580_29618[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29563 === (11))){
var inst_29532 = (state_29562[(8)]);
var inst_29533 = (state_29562[(10)]);
var inst_29532__$1 = (state_29562[(2)]);
var inst_29533__$1 = (inst_29532__$1 == null);
var state_29562__$1 = (function (){var statearr_29583 = state_29562;
(statearr_29583[(8)] = inst_29532__$1);

(statearr_29583[(10)] = inst_29533__$1);

return statearr_29583;
})();
if(cljs.core.truth_(inst_29533__$1)){
var statearr_29584_29619 = state_29562__$1;
(statearr_29584_29619[(1)] = (12));

} else {
var statearr_29585_29620 = state_29562__$1;
(statearr_29585_29620[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29563 === (9))){
var inst_29527 = (state_29562[(9)]);
var inst_29530 = fluree.db.storage.core.read_block.call(null,conn,network,dbid,inst_29527);
var state_29562__$1 = state_29562;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29562__$1,(11),inst_29530);
} else {
if((state_val_29563 === (5))){
var _ = (function (){var statearr_29586 = state_29562;
(statearr_29586[(4)] = cljs.core.rest.call(null,(state_29562[(4)])));

return statearr_29586;
})();
var state_29562__$1 = state_29562;
var ex29582 = (state_29562__$1[(2)]);
var statearr_29587_29621 = state_29562__$1;
(statearr_29587_29621[(5)] = ex29582);


if((ex29582 instanceof Error)){
var statearr_29588_29622 = state_29562__$1;
(statearr_29588_29622[(1)] = (4));

(statearr_29588_29622[(5)] = null);

} else {
throw ex29582;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29563 === (14))){
var inst_29538 = (state_29562[(2)]);
var state_29562__$1 = state_29562;
if(cljs.core.truth_(inst_29538)){
var statearr_29589_29623 = state_29562__$1;
(statearr_29589_29623[(1)] = (15));

} else {
var statearr_29590_29624 = state_29562__$1;
(statearr_29590_29624[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29563 === (16))){
var inst_29527 = (state_29562[(9)]);
var inst_29541 = cljs.core._EQ_.call(null,inst_29527,end);
var state_29562__$1 = state_29562;
if(inst_29541){
var statearr_29591_29625 = state_29562__$1;
(statearr_29591_29625[(1)] = (18));

} else {
var statearr_29592_29626 = state_29562__$1;
(statearr_29592_29626[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29563 === (10))){
var inst_29557 = (state_29562[(2)]);
var _ = (function (){var statearr_29593 = state_29562;
(statearr_29593[(4)] = cljs.core.rest.call(null,(state_29562[(4)])));

return statearr_29593;
})();
var state_29562__$1 = state_29562;
var statearr_29594_29627 = state_29562__$1;
(statearr_29594_29627[(2)] = inst_29557);

(statearr_29594_29627[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29563 === (18))){
var inst_29528 = (state_29562[(7)]);
var inst_29532 = (state_29562[(8)]);
var inst_29543 = cljs.core.conj.call(null,inst_29528,inst_29532);
var state_29562__$1 = state_29562;
var statearr_29595_29628 = state_29562__$1;
(statearr_29595_29628[(2)] = inst_29543);

(statearr_29595_29628[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29563 === (8))){
var inst_29523 = (state_29562[(2)]);
var inst_29524 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_29525 = start;
var inst_29526 = cljs.core.PersistentVector.EMPTY;
var inst_29527 = inst_29525;
var inst_29528 = inst_29526;
var state_29562__$1 = (function (){var statearr_29596 = state_29562;
(statearr_29596[(11)] = inst_29524);

(statearr_29596[(7)] = inst_29528);

(statearr_29596[(9)] = inst_29527);

(statearr_29596[(12)] = inst_29523);

return statearr_29596;
})();
var statearr_29597_29629 = state_29562__$1;
(statearr_29597_29629[(2)] = null);

(statearr_29597_29629[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__10945__auto__ = null;
var fluree$db$storage$core$state_machine__10945__auto____0 = (function (){
var statearr_29598 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29598[(0)] = fluree$db$storage$core$state_machine__10945__auto__);

(statearr_29598[(1)] = (1));

return statearr_29598;
});
var fluree$db$storage$core$state_machine__10945__auto____1 = (function (state_29562){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_29562);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e29599){var ex__10948__auto__ = e29599;
var statearr_29600_29630 = state_29562;
(statearr_29600_29630[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_29562[(4)]))){
var statearr_29601_29631 = state_29562;
(statearr_29601_29631[(1)] = cljs.core.first.call(null,(state_29562[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29632 = state_29562;
state_29562 = G__29632;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__10945__auto__ = function(state_29562){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__10945__auto____1.call(this,state_29562);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__10945__auto____0;
fluree$db$storage$core$state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__10945__auto____1;
return fluree$db$storage$core$state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_29602 = f__11019__auto__.call(null);
(statearr_29602[(6)] = c__11018__auto__);

return statearr_29602;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_29648){
var state_val_29649 = (state_29648[(1)]);
if((state_val_29649 === (1))){
var state_29648__$1 = state_29648;
var statearr_29650_29664 = state_29648__$1;
(statearr_29650_29664[(2)] = null);

(statearr_29650_29664[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29649 === (2))){
var _ = (function (){var statearr_29651 = state_29648;
(statearr_29651[(4)] = cljs.core.cons.call(null,(5),(state_29648[(4)])));

return statearr_29651;
})();
var inst_29639 = fluree.db.storage.core.block_range.call(null,conn,network,dbid,block,block);
var state_29648__$1 = state_29648;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29648__$1,(6),inst_29639);
} else {
if((state_val_29649 === (3))){
var inst_29646 = (state_29648[(2)]);
var state_29648__$1 = state_29648;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29648__$1,inst_29646);
} else {
if((state_val_29649 === (4))){
var inst_29633 = (state_29648[(2)]);
var state_29648__$1 = state_29648;
var statearr_29653_29665 = state_29648__$1;
(statearr_29653_29665[(2)] = inst_29633);

(statearr_29653_29665[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29649 === (5))){
var _ = (function (){var statearr_29654 = state_29648;
(statearr_29654[(4)] = cljs.core.rest.call(null,(state_29648[(4)])));

return statearr_29654;
})();
var state_29648__$1 = state_29648;
var ex29652 = (state_29648__$1[(2)]);
var statearr_29655_29666 = state_29648__$1;
(statearr_29655_29666[(5)] = ex29652);


if((ex29652 instanceof Error)){
var statearr_29656_29667 = state_29648__$1;
(statearr_29656_29667[(1)] = (4));

(statearr_29656_29667[(5)] = null);

} else {
throw ex29652;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29649 === (6))){
var inst_29641 = (state_29648[(2)]);
var inst_29642 = fluree.db.util.async.throw_err.call(null,inst_29641);
var inst_29643 = cljs.core.first.call(null,inst_29642);
var _ = (function (){var statearr_29657 = state_29648;
(statearr_29657[(4)] = cljs.core.rest.call(null,(state_29648[(4)])));

return statearr_29657;
})();
var state_29648__$1 = state_29648;
var statearr_29658_29668 = state_29648__$1;
(statearr_29658_29668[(2)] = inst_29643);

(statearr_29658_29668[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__10945__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__10945__auto____0 = (function (){
var statearr_29659 = [null,null,null,null,null,null,null];
(statearr_29659[(0)] = fluree$db$storage$core$block_$_state_machine__10945__auto__);

(statearr_29659[(1)] = (1));

return statearr_29659;
});
var fluree$db$storage$core$block_$_state_machine__10945__auto____1 = (function (state_29648){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_29648);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e29660){var ex__10948__auto__ = e29660;
var statearr_29661_29669 = state_29648;
(statearr_29661_29669[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_29648[(4)]))){
var statearr_29662_29670 = state_29648;
(statearr_29662_29670[(1)] = cljs.core.first.call(null,(state_29648[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29671 = state_29648;
state_29648 = G__29671;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__10945__auto__ = function(state_29648){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__10945__auto____1.call(this,state_29648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__10945__auto____0;
fluree$db$storage$core$block_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__10945__auto____1;
return fluree$db$storage$core$block_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_29663 = f__11019__auto__.call(null);
(statearr_29663[(6)] = c__11018__auto__);

return statearr_29663;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
