// Compiled by ClojureScript 1.11.57 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__5045__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_22340){
var state_val_22341 = (state_22340[(1)]);
if((state_val_22341 === (7))){
var inst_22335 = (state_22340[(2)]);
var _ = (function (){var statearr_22342 = state_22340;
(statearr_22342[(4)] = cljs.core.rest.call(null,(state_22340[(4)])));

return statearr_22342;
})();
var state_22340__$1 = state_22340;
var statearr_22343_22365 = state_22340__$1;
(statearr_22343_22365[(2)] = inst_22335);

(statearr_22343_22365[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (1))){
var state_22340__$1 = state_22340;
var statearr_22344_22366 = state_22340__$1;
(statearr_22344_22366[(2)] = null);

(statearr_22344_22366[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (4))){
var inst_22297 = (state_22340[(2)]);
var state_22340__$1 = state_22340;
var statearr_22345_22367 = state_22340__$1;
(statearr_22345_22367[(2)] = inst_22297);

(statearr_22345_22367[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (6))){
var inst_22322 = (state_22340[(7)]);
var inst_22315 = (state_22340[(8)]);
var inst_22321 = cljs.core.seq.call(null,inst_22315);
var inst_22322__$1 = cljs.core.first.call(null,inst_22321);
var inst_22323 = cljs.core.next.call(null,inst_22321);
var inst_22324 = cljs.core.not.call(null,inst_22322__$1);
var state_22340__$1 = (function (){var statearr_22346 = state_22340;
(statearr_22346[(7)] = inst_22322__$1);

(statearr_22346[(9)] = inst_22323);

return statearr_22346;
})();
if(inst_22324){
var statearr_22347_22368 = state_22340__$1;
(statearr_22347_22368[(1)] = (8));

} else {
var statearr_22348_22369 = state_22340__$1;
(statearr_22348_22369[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (3))){
var inst_22338 = (state_22340[(2)]);
var state_22340__$1 = state_22340;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22340__$1,inst_22338);
} else {
if((state_val_22341 === (2))){
var _ = (function (){var statearr_22349 = state_22340;
(statearr_22349[(4)] = cljs.core.cons.call(null,(5),(state_22340[(4)])));

return statearr_22349;
})();
var inst_22310 = chs;
var inst_22311 = cljs.core.seq.call(null,inst_22310);
var inst_22312 = cljs.core.first.call(null,inst_22311);
var inst_22313 = cljs.core.next.call(null,inst_22311);
var inst_22314 = coll;
var inst_22315 = inst_22310;
var inst_22316 = inst_22314;
var state_22340__$1 = (function (){var statearr_22350 = state_22340;
(statearr_22350[(10)] = inst_22316);

(statearr_22350[(11)] = inst_22312);

(statearr_22350[(12)] = inst_22313);

(statearr_22350[(8)] = inst_22315);

return statearr_22350;
})();
var statearr_22351_22370 = state_22340__$1;
(statearr_22351_22370[(2)] = null);

(statearr_22351_22370[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (11))){
var inst_22316 = (state_22340[(10)]);
var inst_22323 = (state_22340[(9)]);
var inst_22328 = (state_22340[(2)]);
var inst_22329 = fluree.db.util.async.throw_err.call(null,inst_22328);
var inst_22330 = cljs.core.conj.call(null,inst_22316,inst_22329);
var inst_22315 = inst_22323;
var inst_22316__$1 = inst_22330;
var state_22340__$1 = (function (){var statearr_22353 = state_22340;
(statearr_22353[(10)] = inst_22316__$1);

(statearr_22353[(8)] = inst_22315);

return statearr_22353;
})();
var statearr_22354_22371 = state_22340__$1;
(statearr_22354_22371[(2)] = null);

(statearr_22354_22371[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (9))){
var inst_22322 = (state_22340[(7)]);
var state_22340__$1 = state_22340;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22340__$1,(11),inst_22322);
} else {
if((state_val_22341 === (5))){
var _ = (function (){var statearr_22355 = state_22340;
(statearr_22355[(4)] = cljs.core.rest.call(null,(state_22340[(4)])));

return statearr_22355;
})();
var state_22340__$1 = state_22340;
var ex22352 = (state_22340__$1[(2)]);
var statearr_22356_22372 = state_22340__$1;
(statearr_22356_22372[(5)] = ex22352);


var statearr_22357_22373 = state_22340__$1;
(statearr_22357_22373[(1)] = (4));

(statearr_22357_22373[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (10))){
var inst_22333 = (state_22340[(2)]);
var state_22340__$1 = state_22340;
var statearr_22358_22374 = state_22340__$1;
(statearr_22358_22374[(2)] = inst_22333);

(statearr_22358_22374[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22341 === (8))){
var inst_22316 = (state_22340[(10)]);
var state_22340__$1 = state_22340;
var statearr_22359_22375 = state_22340__$1;
(statearr_22359_22375[(2)] = inst_22316);

(statearr_22359_22375[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__10945__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__10945__auto____0 = (function (){
var statearr_22360 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22360[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__10945__auto__);

(statearr_22360[(1)] = (1));

return statearr_22360;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__10945__auto____1 = (function (state_22340){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_22340);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e22361){var ex__10948__auto__ = e22361;
var statearr_22362_22376 = state_22340;
(statearr_22362_22376[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_22340[(4)]))){
var statearr_22363_22377 = state_22340;
(statearr_22363_22377[(1)] = cljs.core.first.call(null,(state_22340[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22378 = state_22340;
state_22340 = G__22378;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__10945__auto__ = function(state_22340){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__10945__auto____1.call(this,state_22340);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__10945__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__10945__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_22364 = f__11019__auto__.call(null);
(statearr_22364[(6)] = c__11018__auto__);

return statearr_22364;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_22404){
var state_val_22405 = (state_22404[(1)]);
if((state_val_22405 === (7))){
var inst_22399 = (state_22404[(2)]);
var _ = (function (){var statearr_22406 = state_22404;
(statearr_22406[(4)] = cljs.core.rest.call(null,(state_22404[(4)])));

return statearr_22406;
})();
var state_22404__$1 = state_22404;
var statearr_22407_22429 = state_22404__$1;
(statearr_22407_22429[(2)] = inst_22399);

(statearr_22407_22429[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22405 === (1))){
var state_22404__$1 = state_22404;
var statearr_22408_22430 = state_22404__$1;
(statearr_22408_22430[(2)] = null);

(statearr_22408_22430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22405 === (4))){
var inst_22379 = (state_22404[(2)]);
var state_22404__$1 = state_22404;
var statearr_22409_22431 = state_22404__$1;
(statearr_22409_22431[(2)] = inst_22379);

(statearr_22409_22431[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22405 === (6))){
var state_22404__$1 = state_22404;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22404__$1,(8),chan);
} else {
if((state_val_22405 === (3))){
var inst_22402 = (state_22404[(2)]);
var state_22404__$1 = state_22404;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22404__$1,inst_22402);
} else {
if((state_val_22405 === (2))){
var _ = (function (){var statearr_22410 = state_22404;
(statearr_22410[(4)] = cljs.core.cons.call(null,(5),(state_22404[(4)])));

return statearr_22410;
})();
var inst_22385 = coll;
var inst_22386 = inst_22385;
var state_22404__$1 = (function (){var statearr_22411 = state_22404;
(statearr_22411[(7)] = inst_22386);

return statearr_22411;
})();
var statearr_22412_22432 = state_22404__$1;
(statearr_22412_22432[(2)] = null);

(statearr_22412_22432[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22405 === (11))){
var inst_22397 = (state_22404[(2)]);
var state_22404__$1 = state_22404;
var statearr_22414_22433 = state_22404__$1;
(statearr_22414_22433[(2)] = inst_22397);

(statearr_22414_22433[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22405 === (9))){
var inst_22386 = (state_22404[(7)]);
var state_22404__$1 = state_22404;
var statearr_22415_22434 = state_22404__$1;
(statearr_22415_22434[(2)] = inst_22386);

(statearr_22415_22434[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22405 === (5))){
var _ = (function (){var statearr_22416 = state_22404;
(statearr_22416[(4)] = cljs.core.rest.call(null,(state_22404[(4)])));

return statearr_22416;
})();
var state_22404__$1 = state_22404;
var ex22413 = (state_22404__$1[(2)]);
var statearr_22417_22435 = state_22404__$1;
(statearr_22417_22435[(5)] = ex22413);


var statearr_22418_22436 = state_22404__$1;
(statearr_22418_22436[(1)] = (4));

(statearr_22418_22436[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22405 === (10))){
var inst_22386 = (state_22404[(7)]);
var inst_22390 = (state_22404[(8)]);
var inst_22394 = cljs.core.conj.call(null,inst_22386,inst_22390);
var inst_22386__$1 = inst_22394;
var state_22404__$1 = (function (){var statearr_22419 = state_22404;
(statearr_22419[(7)] = inst_22386__$1);

return statearr_22419;
})();
var statearr_22420_22437 = state_22404__$1;
(statearr_22420_22437[(2)] = null);

(statearr_22420_22437[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22405 === (8))){
var inst_22390 = (state_22404[(8)]);
var inst_22389 = (state_22404[(2)]);
var inst_22390__$1 = fluree.db.util.async.throw_err.call(null,inst_22389);
var inst_22391 = (inst_22390__$1 == null);
var state_22404__$1 = (function (){var statearr_22421 = state_22404;
(statearr_22421[(8)] = inst_22390__$1);

return statearr_22421;
})();
if(cljs.core.truth_(inst_22391)){
var statearr_22422_22438 = state_22404__$1;
(statearr_22422_22438[(1)] = (9));

} else {
var statearr_22423_22439 = state_22404__$1;
(statearr_22423_22439[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__10945__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__10945__auto____0 = (function (){
var statearr_22424 = [null,null,null,null,null,null,null,null,null];
(statearr_22424[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__10945__auto__);

(statearr_22424[(1)] = (1));

return statearr_22424;
});
var fluree$db$util$async$into_QMARK__$_state_machine__10945__auto____1 = (function (state_22404){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_22404);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e22425){var ex__10948__auto__ = e22425;
var statearr_22426_22440 = state_22404;
(statearr_22426_22440[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_22404[(4)]))){
var statearr_22427_22441 = state_22404;
(statearr_22427_22441[(1)] = cljs.core.first.call(null,(state_22404[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22442 = state_22404;
state_22404 = G__22442;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__10945__auto__ = function(state_22404){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__10945__auto____1.call(this,state_22404);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__10945__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__10945__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_22428 = f__11019__auto__.call(null);
(statearr_22428[(6)] = c__11018__auto__);

return statearr_22428;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
}
});
