// Compiled by ClojureScript 1.11.57 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
fluree.db.util.xhttp.node$module$axios = require('axios');
fluree.db.util.xhttp.node$module$ws = require('ws');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5804__auto__ = e.response;
if(cljs.core.truth_(temp__5804__auto__)){
var resp = temp__5804__auto__;
var temp__5804__auto____$1 = resp.status;
if(cljs.core.truth_(temp__5804__auto____$1)){
var st = temp__5804__auto____$1;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
})();
var error = ((clojure.string.starts_with_QMARK_.call(null,e.message,"timeout"))?new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562):(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return ((((300) <= status)) && ((status <= (499))));
} else {
return and__5043__auto__;
}
})())?new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305):(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return (status >= (500));
} else {
return and__5043__auto__;
}
})())?new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040):(function (){
fluree.db.util.log.error.call(null,"XHTTP Request Error:",e.request);

return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
})()

)));
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return (status > (0));
} else {
return and__5043__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.call(null,message,(function (){var G__30706 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.call(null,G__30706,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__30706;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__30707 = opts;
var map__30707__$1 = cljs.core.__destructure_map.call(null,map__30707);
var request_timeout = cljs.core.get.call(null,map__30707__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__30707__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__30707__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__30708 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__30708__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__30708,headers):G__30708);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__30708__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__30708__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"post",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1,new cljs.core.Keyword(null,"data","data",-232669377),message], null))).then((function (resp){
return cljs.core.async.put_BANG_.call(null,response_chan,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.call(null,resp,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true)));
})).catch((function (err){
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,err));
}));

return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__30709 = opts;
var map__30709__$1 = cljs.core.__destructure_map.call(null,map__30709);
var request_timeout = cljs.core.get.call(null,map__30709__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__30709__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__30709__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.call(null,map__30709__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.call(null,map__30709__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__30710 = cljs.core.PersistentArrayMap.EMPTY;
var G__30710__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__30710,headers):G__30710);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__30710__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__30710__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"get",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1], null))).then((function (resp){
var data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.call(null,resp,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true));
return cljs.core.async.put_BANG_.call(null,response_chan,(function (){var G__30711 = output_format;
var G__30711__$1 = (((G__30711 instanceof cljs.core.Keyword))?G__30711.fqn:null);
switch (G__30711__$1) {
case "text":
return data;

break;
case "json":
return fluree.db.util.json.stringify.call(null,data);

break;
default:
throw cljs.core.ex_info.call(null,"http get only supports output formats of json and text.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
})).catch((function (err){
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,err));
}));

return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__30713 = cljs.core.assoc.call(null,cljs.core.assoc_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.call(null,G__30713,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__30713;
}
})();
return fluree.db.util.xhttp.get.call(null,url,opts_STAR_);
});
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__11018__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_30745){
var state_val_30746 = (state_30745[(1)]);
if((state_val_30746 === (7))){
var inst_30741 = (state_30745[(2)]);
var state_30745__$1 = state_30745;
var statearr_30747_30772 = state_30745__$1;
(statearr_30747_30772[(2)] = inst_30741);

(statearr_30747_30772[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30746 === (1))){
var state_30745__$1 = state_30745;
var statearr_30748_30773 = state_30745__$1;
(statearr_30748_30773[(2)] = null);

(statearr_30748_30773[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30746 === (4))){
var inst_30716 = (state_30745[(7)]);
var inst_30716__$1 = (state_30745[(2)]);
var inst_30717 = (inst_30716__$1 == null);
var state_30745__$1 = (function (){var statearr_30749 = state_30745;
(statearr_30749[(7)] = inst_30716__$1);

return statearr_30749;
})();
if(cljs.core.truth_(inst_30717)){
var statearr_30750_30774 = state_30745__$1;
(statearr_30750_30774[(1)] = (5));

} else {
var statearr_30751_30775 = state_30745__$1;
(statearr_30751_30775[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30746 === (6))){
var inst_30716 = (state_30745[(7)]);
var inst_30724 = cljs.core.nth.call(null,inst_30716,(0),null);
var inst_30725 = cljs.core.nth.call(null,inst_30716,(1),null);
var state_30745__$1 = (function (){var statearr_30752 = state_30745;
(statearr_30752[(8)] = inst_30724);

(statearr_30752[(9)] = inst_30725);

return statearr_30752;
})();
var statearr_30753_30776 = state_30745__$1;
(statearr_30753_30776[(2)] = null);

(statearr_30753_30776[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30746 === (3))){
var inst_30743 = (state_30745[(2)]);
var state_30745__$1 = state_30745;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30745__$1,inst_30743);
} else {
if((state_val_30746 === (2))){
var state_30745__$1 = state_30745;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30745__$1,(4),pub_chan);
} else {
if((state_val_30746 === (11))){
var _ = (function (){var statearr_30755 = state_30745;
(statearr_30755[(4)] = cljs.core.rest.call(null,(state_30745[(4)])));

return statearr_30755;
})();
var state_30745__$1 = state_30745;
var ex30754 = (state_30745__$1[(2)]);
var statearr_30756_30777 = state_30745__$1;
(statearr_30756_30777[(5)] = ex30754);


var statearr_30757_30778 = state_30745__$1;
(statearr_30757_30778[(1)] = (10));

(statearr_30757_30778[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30746 === (9))){
var inst_30738 = (state_30745[(2)]);
var state_30745__$1 = (function (){var statearr_30758 = state_30745;
(statearr_30758[(10)] = inst_30738);

return statearr_30758;
})();
var statearr_30759_30779 = state_30745__$1;
(statearr_30759_30779[(2)] = null);

(statearr_30759_30779[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30746 === (5))){
var inst_30719 = fluree.db.util.log.info.call(null,"Web socket pub/producer channel closed.");
var state_30745__$1 = state_30745;
var statearr_30760_30780 = state_30745__$1;
(statearr_30760_30780[(2)] = inst_30719);

(statearr_30760_30780[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30746 === (10))){
var inst_30724 = (state_30745[(8)]);
var inst_30725 = (state_30745[(9)]);
var inst_30726 = (state_30745[(2)]);
var inst_30727 = fluree.db.util.log.error.call(null,inst_30726,"Error sending websocket message:",inst_30724);
var inst_30728 = cljs.core.async.put_BANG_.call(null,inst_30725,false);
var state_30745__$1 = (function (){var statearr_30761 = state_30745;
(statearr_30761[(11)] = inst_30727);

return statearr_30761;
})();
var statearr_30762_30781 = state_30745__$1;
(statearr_30762_30781[(2)] = inst_30728);

(statearr_30762_30781[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30746 === (8))){
var inst_30724 = (state_30745[(8)]);
var inst_30725 = (state_30745[(9)]);
var _ = (function (){var statearr_30763 = state_30745;
(statearr_30763[(4)] = cljs.core.cons.call(null,(11),(state_30745[(4)])));

return statearr_30763;
})();
var inst_30734 = ws.send(inst_30724);
var inst_30735 = cljs.core.async.put_BANG_.call(null,inst_30725,true);
var ___$1 = (function (){var statearr_30764 = state_30745;
(statearr_30764[(4)] = cljs.core.rest.call(null,(state_30745[(4)])));

return statearr_30764;
})();
var state_30745__$1 = (function (){var statearr_30765 = state_30745;
(statearr_30765[(12)] = inst_30734);

return statearr_30765;
})();
var statearr_30766_30782 = state_30745__$1;
(statearr_30766_30782[(2)] = inst_30735);

(statearr_30766_30782[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10945__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10945__auto____0 = (function (){
var statearr_30767 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30767[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10945__auto__);

(statearr_30767[(1)] = (1));

return statearr_30767;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10945__auto____1 = (function (state_30745){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_30745);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e30768){var ex__10948__auto__ = e30768;
var statearr_30769_30783 = state_30745;
(statearr_30769_30783[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_30745[(4)]))){
var statearr_30770_30784 = state_30745;
(statearr_30770_30784[(1)] = cljs.core.first.call(null,(state_30745[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30785 = state_30745;
state_30745 = G__30785;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10945__auto__ = function(state_30745){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10945__auto____1.call(this,state_30745);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10945__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10945__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_30771 = f__11019__auto__.call(null);
(statearr_30771[(6)] = c__11018__auto__);

return statearr_30771;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));

return c__11018__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (((cljs.core._STAR_target_STAR_ === "nodejs"))?(new fluree.db.util.xhttp.node$module$ws(url)):(new WebSocket(url)));
var open_QMARK_ = cljs.core.async.promise_chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.call(null,open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.call(null,sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.call(null,"Websocket closed: ",e.reason,"Code: ",e.code);

return close_fn.call(null);
}));

var c__11018__auto___30823 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11019__auto__ = (function (){var switch__10944__auto__ = (function (state_30810){
var state_val_30811 = (state_30810[(1)]);
if((state_val_30811 === (1))){
var inst_30789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30790 = [open_QMARK_,timeout_chan];
var inst_30791 = (new cljs.core.PersistentVector(null,2,(5),inst_30789,inst_30790,null));
var state_30810__$1 = state_30810;
return cljs.core.async.ioc_alts_BANG_.call(null,state_30810__$1,(2),inst_30791,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_30811 === (2))){
var inst_30793 = (state_30810[(2)]);
var inst_30794 = cljs.core.nth.call(null,inst_30793,(0),null);
var inst_30795 = cljs.core.nth.call(null,inst_30793,(1),null);
var inst_30796 = cljs.core._EQ_.call(null,inst_30795,timeout_chan);
var state_30810__$1 = (function (){var statearr_30812 = state_30810;
(statearr_30812[(7)] = inst_30794);

return statearr_30812;
})();
if(inst_30796){
var statearr_30813_30824 = state_30810__$1;
(statearr_30813_30824[(1)] = (3));

} else {
var statearr_30814_30825 = state_30810__$1;
(statearr_30814_30825[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30811 === (3))){
var inst_30798 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_30799 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30800 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_30801 = cljs.core.PersistentHashMap.fromArrays(inst_30799,inst_30800);
var inst_30802 = cljs.core.ex_info.call(null,inst_30798,inst_30801);
var inst_30803 = cljs.core.async.put_BANG_.call(null,resp_chan,inst_30802);
var inst_30804 = fluree.db.util.xhttp.close_websocket.call(null,ws);
var state_30810__$1 = (function (){var statearr_30815 = state_30810;
(statearr_30815[(8)] = inst_30803);

return statearr_30815;
})();
var statearr_30816_30826 = state_30810__$1;
(statearr_30816_30826[(2)] = inst_30804);

(statearr_30816_30826[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30811 === (4))){
var inst_30806 = fluree.db.util.xhttp.socket_publish_loop.call(null,ws,pub_chan);
var state_30810__$1 = state_30810;
var statearr_30817_30827 = state_30810__$1;
(statearr_30817_30827[(2)] = inst_30806);

(statearr_30817_30827[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30811 === (5))){
var inst_30808 = (state_30810[(2)]);
var state_30810__$1 = state_30810;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30810__$1,inst_30808);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__10945__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__10945__auto____0 = (function (){
var statearr_30818 = [null,null,null,null,null,null,null,null,null];
(statearr_30818[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__10945__auto__);

(statearr_30818[(1)] = (1));

return statearr_30818;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__10945__auto____1 = (function (state_30810){
while(true){
var ret_value__10946__auto__ = (function (){try{while(true){
var result__10947__auto__ = switch__10944__auto__.call(null,state_30810);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10947__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10947__auto__;
}
break;
}
}catch (e30819){var ex__10948__auto__ = e30819;
var statearr_30820_30828 = state_30810;
(statearr_30820_30828[(2)] = ex__10948__auto__);


if(cljs.core.seq.call(null,(state_30810[(4)]))){
var statearr_30821_30829 = state_30810;
(statearr_30821_30829[(1)] = cljs.core.first.call(null,(state_30810[(4)])));

} else {
throw ex__10948__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10946__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30830 = state_30810;
state_30810 = G__30830;
continue;
} else {
return ret_value__10946__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__10945__auto__ = function(state_30810){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__10945__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__10945__auto____1.call(this,state_30810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__10945__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__10945__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__10945__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__10945__auto__;
})()
})();
var state__11020__auto__ = (function (){var statearr_30822 = f__11019__auto__.call(null);
(statearr_30822[(6)] = c__11018__auto___30823);

return statearr_30822;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11020__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
