// Compiled by ClojureScript 1.11.57 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.call(null,index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"column","column",2078222095),col], null);
} else {
if(cljs.core._EQ_.call(null,"\n",cljs.core.get.call(null,text,counter))){
var G__78496 = (line + (1));
var G__78497 = (1);
var G__78498 = (counter + (1));
line = G__78496;
col = G__78497;
counter = G__78498;
continue;
} else {
var G__78499 = line;
var G__78500 = (col + (1));
var G__78501 = (counter + (1));
line = G__78499;
col = G__78500;
counter = G__78501;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq.call(null,clojure.string.replace.call(null,text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_.call(null,chars)){
return "";
} else {
if(cljs.core._EQ_.call(null,n__$1,(1))){
return cljs.core.apply.call(null,cljs.core.str,cljs.core.take_while.call(null,cljs.core.complement.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.call(null,"\n",cljs.core.first.call(null,chars))){
var G__78502 = cljs.core.next.call(null,chars);
var G__78503 = (n__$1 - (1));
chars = G__78502;
n__$1 = G__78503;
continue;
} else {
var G__78504 = cljs.core.next.call(null,chars);
var G__78505 = n__$1;
chars = G__78504;
n__$1 = G__78505;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 * and accounts for horizontal tabs which might change
 * the alignment of the '^' to the error location.
 */
instaparse.failure.marker = (function instaparse$failure$marker(text,n){
if(cljs.core.truth_((function (){var and__5043__auto__ = text;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.integer_QMARK_.call(null,n);
} else {
return and__5043__auto__;
}
})())){
var marker_text = clojure.string.replace.call(null,text,/[^\s]/," ");
if((n <= (1))){
return "^";
} else {
return [cljs.core.subs.call(null,marker_text,(0),(n - (1))),"^"].join('');
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column.call(null,new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.call(null,failure,lc,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"text","text",-1790561697),instaparse.failure.get_line.call(null,new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(lc),text)], null));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.call(null,"NOT ");

return cljs.core.print.call(null,new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"char-range","char-range",1443391389).cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.call(null,instaparse.print.char_range__GT_str.call(null,r));
} else {
if((r instanceof RegExp)){
return cljs.core.print.call(null,instaparse.print.regexp__GT_str.call(null,r));
} else {
return cljs.core.pr.call(null,r);

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__78506){
var map__78507 = p__78506;
var map__78507__$1 = cljs.core.__destructure_map.call(null,map__78507);
var line = cljs.core.get.call(null,map__78507__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__78507__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var text = cljs.core.get.call(null,map__78507__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var reason = cljs.core.get.call(null,map__78507__$1,new cljs.core.Keyword(null,"reason","reason",-2070751759));
cljs.core.println.call(null,["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join(''));

cljs.core.println.call(null,text);

cljs.core.println.call(null,instaparse.failure.marker.call(null,text,column));

var full_reasons = cljs.core.distinct.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.call(null,new cljs.core.Keyword(null,"full","full",436801220),reason)));
var partial_reasons = cljs.core.distinct.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.call(null,cljs.core.complement.call(null,new cljs.core.Keyword(null,"full","full",436801220)),reason)));
var total = (cljs.core.count.call(null,full_reasons) + cljs.core.count.call(null,partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.call(null,(1),total)){
cljs.core.println.call(null,"Expected:");
} else {
cljs.core.println.call(null,"Expected one of:");

}
}

var seq__78508_78516 = cljs.core.seq.call(null,full_reasons);
var chunk__78509_78517 = null;
var count__78510_78518 = (0);
var i__78511_78519 = (0);
while(true){
if((i__78511_78519 < count__78510_78518)){
var r_78520 = cljs.core._nth.call(null,chunk__78509_78517,i__78511_78519);
instaparse.failure.print_reason.call(null,r_78520);

cljs.core.println.call(null," (followed by end-of-string)");


var G__78521 = seq__78508_78516;
var G__78522 = chunk__78509_78517;
var G__78523 = count__78510_78518;
var G__78524 = (i__78511_78519 + (1));
seq__78508_78516 = G__78521;
chunk__78509_78517 = G__78522;
count__78510_78518 = G__78523;
i__78511_78519 = G__78524;
continue;
} else {
var temp__5804__auto___78525 = cljs.core.seq.call(null,seq__78508_78516);
if(temp__5804__auto___78525){
var seq__78508_78526__$1 = temp__5804__auto___78525;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__78508_78526__$1)){
var c__5567__auto___78527 = cljs.core.chunk_first.call(null,seq__78508_78526__$1);
var G__78528 = cljs.core.chunk_rest.call(null,seq__78508_78526__$1);
var G__78529 = c__5567__auto___78527;
var G__78530 = cljs.core.count.call(null,c__5567__auto___78527);
var G__78531 = (0);
seq__78508_78516 = G__78528;
chunk__78509_78517 = G__78529;
count__78510_78518 = G__78530;
i__78511_78519 = G__78531;
continue;
} else {
var r_78532 = cljs.core.first.call(null,seq__78508_78526__$1);
instaparse.failure.print_reason.call(null,r_78532);

cljs.core.println.call(null," (followed by end-of-string)");


var G__78533 = cljs.core.next.call(null,seq__78508_78526__$1);
var G__78534 = null;
var G__78535 = (0);
var G__78536 = (0);
seq__78508_78516 = G__78533;
chunk__78509_78517 = G__78534;
count__78510_78518 = G__78535;
i__78511_78519 = G__78536;
continue;
}
} else {
}
}
break;
}

var seq__78512 = cljs.core.seq.call(null,partial_reasons);
var chunk__78513 = null;
var count__78514 = (0);
var i__78515 = (0);
while(true){
if((i__78515 < count__78514)){
var r = cljs.core._nth.call(null,chunk__78513,i__78515);
instaparse.failure.print_reason.call(null,r);

cljs.core.println.call(null);


var G__78537 = seq__78512;
var G__78538 = chunk__78513;
var G__78539 = count__78514;
var G__78540 = (i__78515 + (1));
seq__78512 = G__78537;
chunk__78513 = G__78538;
count__78514 = G__78539;
i__78515 = G__78540;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__78512);
if(temp__5804__auto__){
var seq__78512__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__78512__$1)){
var c__5567__auto__ = cljs.core.chunk_first.call(null,seq__78512__$1);
var G__78541 = cljs.core.chunk_rest.call(null,seq__78512__$1);
var G__78542 = c__5567__auto__;
var G__78543 = cljs.core.count.call(null,c__5567__auto__);
var G__78544 = (0);
seq__78512 = G__78541;
chunk__78513 = G__78542;
count__78514 = G__78543;
i__78515 = G__78544;
continue;
} else {
var r = cljs.core.first.call(null,seq__78512__$1);
instaparse.failure.print_reason.call(null,r);

cljs.core.println.call(null);


var G__78545 = cljs.core.next.call(null,seq__78512__$1);
var G__78546 = null;
var G__78547 = (0);
var G__78548 = (0);
seq__78512 = G__78545;
chunk__78513 = G__78546;
count__78514 = G__78547;
i__78515 = G__78548;
continue;
}
} else {
return null;
}
}
break;
}
});
