// Compiled by ClojureScript 1.11.57 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('tailrecursion.priority_map');
goog.require('cljs.core');
goog.require('cljs.core');
goog.require('cljs.reader');

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
tailrecursion.priority_map.PersistentPriorityMap = (function (priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
this.priority__GT_set_of_items = priority__GT_set_of_items;
this.item__GT_priority = item__GT_priority;
this.meta = meta;
this.keyfn = keyfn;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2565220111;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.get.call(null,self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,item,not_found){
var self__ = this;
var coll__$1 = this;
return cljs.core.get.call(null,self__.item__GT_priority,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var self__ = this;
var coll__$1 = this;
var pr_pair = (function (keyval){
return cljs.core.pr_sequential_writer.call(null,writer,cljs.core.pr_writer,""," ","",opts,keyval);
});
return cljs.core.pr_sequential_writer.call(null,writer,pr_pair,"#tailrecursion.priority-map {",", ","}",opts,coll__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.count.call(null,self__.item__GT_priority);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_peek$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count.call(null,self__.item__GT_priority) === (0))){
return null;
} else {
var f = cljs.core.first.call(null,self__.priority__GT_set_of_items);
var item = cljs.core.first.call(null,cljs.core.val.call(null,f));
if(cljs.core.truth_(self__.keyfn)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,cljs.core.key.call(null,f)], null);
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_pop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count.call(null,self__.item__GT_priority) === (0))){
throw (new Error("Can't pop empty priority map"));
} else {
var f = cljs.core.first.call(null,self__.priority__GT_set_of_items);
var item_set = cljs.core.val.call(null,f);
var item = cljs.core.first.call(null,item_set);
var priority_key = cljs.core.key.call(null,f);
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.call(null,self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.disj.call(null,item_set,item)),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq.call(null,(function (){var iter__5522__auto__ = (function tailrecursion$priority_map$iter__38812(s__38813){
return (new cljs.core.LazySeq(null,(function (){
var s__38813__$1 = s__38813;
while(true){
var temp__5804__auto__ = cljs.core.seq.call(null,s__38813__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var vec__38818 = cljs.core.first.call(null,xs__6360__auto__);
var priority = cljs.core.nth.call(null,vec__38818,(0),null);
var item_set = cljs.core.nth.call(null,vec__38818,(1),null);
var iterys__5518__auto__ = ((function (s__38813__$1,vec__38818,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__38812_$_iter__38814(s__38815){
return (new cljs.core.LazySeq(null,((function (s__38813__$1,vec__38818,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1){
return (function (){
var s__38815__$1 = s__38815;
while(true){
var temp__5804__auto____$1 = cljs.core.seq.call(null,s__38815__$1);
if(temp__5804__auto____$1){
var s__38815__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__38815__$2)){
var c__5520__auto__ = cljs.core.chunk_first.call(null,s__38815__$2);
var size__5521__auto__ = cljs.core.count.call(null,c__5520__auto__);
var b__38817 = cljs.core.chunk_buffer.call(null,size__5521__auto__);
if((function (){var i__38816 = (0);
while(true){
if((i__38816 < size__5521__auto__)){
var item = cljs.core._nth.call(null,c__5520__auto__,i__38816);
cljs.core.chunk_append.call(null,b__38817,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null));

var G__38867 = (i__38816 + (1));
i__38816 = G__38867;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__38817),tailrecursion$priority_map$iter__38812_$_iter__38814.call(null,cljs.core.chunk_rest.call(null,s__38815__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__38817),null);
}
} else {
var item = cljs.core.first.call(null,s__38815__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null),tailrecursion$priority_map$iter__38812_$_iter__38814.call(null,cljs.core.rest.call(null,s__38815__$2)));
}
} else {
return null;
}
break;
}
});})(s__38813__$1,vec__38818,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1))
,null,null));
});})(s__38813__$1,vec__38818,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1))
;
var fs__5519__auto__ = cljs.core.seq.call(null,iterys__5518__auto__.call(null,item_set));
if(fs__5519__auto__){
return cljs.core.concat.call(null,fs__5519__auto__,tailrecursion$priority_map$iter__38812.call(null,cljs.core.rest.call(null,s__38813__$1)));
} else {
var G__38868 = cljs.core.rest.call(null,s__38813__$1);
s__38813__$1 = G__38868;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5522__auto__.call(null,cljs.core.rseq.call(null,self__.priority__GT_set_of_items));
})());
} else {
return cljs.core.seq.call(null,(function (){var iter__5522__auto__ = (function tailrecursion$priority_map$iter__38821(s__38822){
return (new cljs.core.LazySeq(null,(function (){
var s__38822__$1 = s__38822;
while(true){
var temp__5804__auto__ = cljs.core.seq.call(null,s__38822__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var vec__38827 = cljs.core.first.call(null,xs__6360__auto__);
var priority = cljs.core.nth.call(null,vec__38827,(0),null);
var item_set = cljs.core.nth.call(null,vec__38827,(1),null);
var iterys__5518__auto__ = ((function (s__38822__$1,vec__38827,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__38821_$_iter__38823(s__38824){
return (new cljs.core.LazySeq(null,((function (s__38822__$1,vec__38827,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1){
return (function (){
var s__38824__$1 = s__38824;
while(true){
var temp__5804__auto____$1 = cljs.core.seq.call(null,s__38824__$1);
if(temp__5804__auto____$1){
var s__38824__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__38824__$2)){
var c__5520__auto__ = cljs.core.chunk_first.call(null,s__38824__$2);
var size__5521__auto__ = cljs.core.count.call(null,c__5520__auto__);
var b__38826 = cljs.core.chunk_buffer.call(null,size__5521__auto__);
if((function (){var i__38825 = (0);
while(true){
if((i__38825 < size__5521__auto__)){
var item = cljs.core._nth.call(null,c__5520__auto__,i__38825);
cljs.core.chunk_append.call(null,b__38826,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__38869 = (i__38825 + (1));
i__38825 = G__38869;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__38826),tailrecursion$priority_map$iter__38821_$_iter__38823.call(null,cljs.core.chunk_rest.call(null,s__38824__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__38826),null);
}
} else {
var item = cljs.core.first.call(null,s__38824__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__38821_$_iter__38823.call(null,cljs.core.rest.call(null,s__38824__$2)));
}
} else {
return null;
}
break;
}
});})(s__38822__$1,vec__38827,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1))
,null,null));
});})(s__38822__$1,vec__38827,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1))
;
var fs__5519__auto__ = cljs.core.seq.call(null,iterys__5518__auto__.call(null,item_set));
if(fs__5519__auto__){
return cljs.core.concat.call(null,fs__5519__auto__,tailrecursion$priority_map$iter__38821.call(null,cljs.core.rest.call(null,s__38822__$1)));
} else {
var G__38870 = cljs.core.rest.call(null,s__38822__$1);
s__38822__$1 = G__38870;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5522__auto__.call(null,cljs.core.rseq.call(null,self__.priority__GT_set_of_items));
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = cljs.core.hash_unordered_coll.call(null,this$__$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return cljs.core._equiv.call(null,self__.item__GT_priority,other);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.with_meta.call(null,tailrecursion.priority_map.PersistentPriorityMap.EMPTY,self__.meta);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var priority = self__.item__GT_priority.call(null,item,new cljs.core.Keyword("tailrecursion.priority-map","not-found","tailrecursion.priority-map/not-found",-436727517));
if(cljs.core._EQ_.call(null,priority,new cljs.core.Keyword("tailrecursion.priority-map","not-found","tailrecursion.priority-map/not-found",-436727517))){
return this$__$1;
} else {
var priority_key = self__.keyfn.call(null,priority);
var item_set = self__.priority__GT_set_of_items.call(null,priority_key);
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.call(null,self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.disj.call(null,item_set,item)),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,item,priority){
var self__ = this;
var this$__$1 = this;
var temp__5802__auto__ = cljs.core.get.call(null,self__.item__GT_priority,item,null);
if(cljs.core.truth_(temp__5802__auto__)){
var current_priority = temp__5802__auto__;
if(cljs.core._EQ_.call(null,current_priority,priority)){
return this$__$1;
} else {
var priority_key = self__.keyfn.call(null,priority);
var current_priority_key = self__.keyfn.call(null,current_priority);
var item_set = cljs.core.get.call(null,self__.priority__GT_set_of_items,current_priority_key);
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,cljs.core.dissoc.call(null,self__.priority__GT_set_of_items,current_priority_key),priority_key,cljs.core.conj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.call(null,self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,current_priority_key,cljs.core.disj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,current_priority_key),item),priority_key,cljs.core.conj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.call(null,self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}
} else {
var priority_key = self__.keyfn.call(null,priority);
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.conj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.call(null,self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.contains_QMARK_.call(null,self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq.call(null,(function (){var iter__5522__auto__ = (function tailrecursion$priority_map$iter__38830(s__38831){
return (new cljs.core.LazySeq(null,(function (){
var s__38831__$1 = s__38831;
while(true){
var temp__5804__auto__ = cljs.core.seq.call(null,s__38831__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var vec__38836 = cljs.core.first.call(null,xs__6360__auto__);
var priority = cljs.core.nth.call(null,vec__38836,(0),null);
var item_set = cljs.core.nth.call(null,vec__38836,(1),null);
var iterys__5518__auto__ = ((function (s__38831__$1,vec__38836,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__38830_$_iter__38832(s__38833){
return (new cljs.core.LazySeq(null,((function (s__38831__$1,vec__38836,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1){
return (function (){
var s__38833__$1 = s__38833;
while(true){
var temp__5804__auto____$1 = cljs.core.seq.call(null,s__38833__$1);
if(temp__5804__auto____$1){
var s__38833__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__38833__$2)){
var c__5520__auto__ = cljs.core.chunk_first.call(null,s__38833__$2);
var size__5521__auto__ = cljs.core.count.call(null,c__5520__auto__);
var b__38835 = cljs.core.chunk_buffer.call(null,size__5521__auto__);
if((function (){var i__38834 = (0);
while(true){
if((i__38834 < size__5521__auto__)){
var item = cljs.core._nth.call(null,c__5520__auto__,i__38834);
cljs.core.chunk_append.call(null,b__38835,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null));

var G__38871 = (i__38834 + (1));
i__38834 = G__38871;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__38835),tailrecursion$priority_map$iter__38830_$_iter__38832.call(null,cljs.core.chunk_rest.call(null,s__38833__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__38835),null);
}
} else {
var item = cljs.core.first.call(null,s__38833__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null),tailrecursion$priority_map$iter__38830_$_iter__38832.call(null,cljs.core.rest.call(null,s__38833__$2)));
}
} else {
return null;
}
break;
}
});})(s__38831__$1,vec__38836,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1))
,null,null));
});})(s__38831__$1,vec__38836,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1))
;
var fs__5519__auto__ = cljs.core.seq.call(null,iterys__5518__auto__.call(null,item_set));
if(fs__5519__auto__){
return cljs.core.concat.call(null,fs__5519__auto__,tailrecursion$priority_map$iter__38830.call(null,cljs.core.rest.call(null,s__38831__$1)));
} else {
var G__38872 = cljs.core.rest.call(null,s__38831__$1);
s__38831__$1 = G__38872;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5522__auto__.call(null,self__.priority__GT_set_of_items);
})());
} else {
return cljs.core.seq.call(null,(function (){var iter__5522__auto__ = (function tailrecursion$priority_map$iter__38839(s__38840){
return (new cljs.core.LazySeq(null,(function (){
var s__38840__$1 = s__38840;
while(true){
var temp__5804__auto__ = cljs.core.seq.call(null,s__38840__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var vec__38845 = cljs.core.first.call(null,xs__6360__auto__);
var priority = cljs.core.nth.call(null,vec__38845,(0),null);
var item_set = cljs.core.nth.call(null,vec__38845,(1),null);
var iterys__5518__auto__ = ((function (s__38840__$1,vec__38845,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__38839_$_iter__38841(s__38842){
return (new cljs.core.LazySeq(null,((function (s__38840__$1,vec__38845,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1){
return (function (){
var s__38842__$1 = s__38842;
while(true){
var temp__5804__auto____$1 = cljs.core.seq.call(null,s__38842__$1);
if(temp__5804__auto____$1){
var s__38842__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__38842__$2)){
var c__5520__auto__ = cljs.core.chunk_first.call(null,s__38842__$2);
var size__5521__auto__ = cljs.core.count.call(null,c__5520__auto__);
var b__38844 = cljs.core.chunk_buffer.call(null,size__5521__auto__);
if((function (){var i__38843 = (0);
while(true){
if((i__38843 < size__5521__auto__)){
var item = cljs.core._nth.call(null,c__5520__auto__,i__38843);
cljs.core.chunk_append.call(null,b__38844,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__38873 = (i__38843 + (1));
i__38843 = G__38873;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__38844),tailrecursion$priority_map$iter__38839_$_iter__38841.call(null,cljs.core.chunk_rest.call(null,s__38842__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__38844),null);
}
} else {
var item = cljs.core.first.call(null,s__38842__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__38839_$_iter__38841.call(null,cljs.core.rest.call(null,s__38842__$2)));
}
} else {
return null;
}
break;
}
});})(s__38840__$1,vec__38845,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1))
,null,null));
});})(s__38840__$1,vec__38845,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1))
;
var fs__5519__auto__ = cljs.core.seq.call(null,iterys__5518__auto__.call(null,item_set));
if(fs__5519__auto__){
return cljs.core.concat.call(null,fs__5519__auto__,tailrecursion$priority_map$iter__38839.call(null,cljs.core.rest.call(null,s__38840__$1)));
} else {
var G__38874 = cljs.core.rest.call(null,s__38840__$1);
s__38840__$1 = G__38874;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5522__auto__.call(null,self__.priority__GT_set_of_items);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta__$1){
var self__ = this;
var this$__$1 = this;
return (new tailrecursion.priority_map.PersistentPriorityMap(self__.priority__GT_set_of_items,self__.item__GT_priority,meta__$1,self__.keyfn,self__.__hash));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry)){
return cljs.core._assoc.call(null,this$__$1,cljs.core._nth.call(null,entry,(0)),cljs.core._nth.call(null,entry,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this$__$1,entry);
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.call = (function() {
var G__38875 = null;
var G__38875__2 = (function (self__,item){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return cljs.core._lookup.call(null,this$,item);
});
var G__38875__3 = (function (self__,item,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return cljs.core._lookup.call(null,this$,item,not_found);
});
G__38875 = function(self__,item,not_found){
switch(arguments.length){
case 2:
return G__38875__2.call(this,self__,item);
case 3:
return G__38875__3.call(this,self__,item,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__38875.cljs$core$IFn$_invoke$arity$2 = G__38875__2;
G__38875.cljs$core$IFn$_invoke$arity$3 = G__38875__3;
return G__38875;
})()
);

(tailrecursion.priority_map.PersistentPriorityMap.prototype.apply = (function (self__,args38811){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat((((args38811.length > (20)))?(function (){var G__38848 = args38811.slice((0),(20));
G__38848.push(args38811.slice((20)));

return G__38848;
})():args38811)));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (item){
var self__ = this;
var this$ = this;
return cljs.core._lookup.call(null,this$,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (item,not_found){
var self__ = this;
var this$ = this;
return cljs.core._lookup.call(null,this$,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
return (cljs.core.truth_(ascending_QMARK_)?cljs.core.seq:cljs.core.rseq).call(null,this$__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var sets = (cljs.core.truth_(ascending_QMARK_)?cljs.core.subseq.call(null,self__.priority__GT_set_of_items,cljs.core._GT__EQ_,k):cljs.core.rsubseq.call(null,self__.priority__GT_set_of_items,cljs.core._LT__EQ_,k));
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq.call(null,(function (){var iter__5522__auto__ = (function tailrecursion$priority_map$iter__38849(s__38850){
return (new cljs.core.LazySeq(null,(function (){
var s__38850__$1 = s__38850;
while(true){
var temp__5804__auto__ = cljs.core.seq.call(null,s__38850__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var vec__38855 = cljs.core.first.call(null,xs__6360__auto__);
var priority = cljs.core.nth.call(null,vec__38855,(0),null);
var item_set = cljs.core.nth.call(null,vec__38855,(1),null);
var iterys__5518__auto__ = ((function (s__38850__$1,vec__38855,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__38849_$_iter__38851(s__38852){
return (new cljs.core.LazySeq(null,((function (s__38850__$1,vec__38855,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1){
return (function (){
var s__38852__$1 = s__38852;
while(true){
var temp__5804__auto____$1 = cljs.core.seq.call(null,s__38852__$1);
if(temp__5804__auto____$1){
var s__38852__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__38852__$2)){
var c__5520__auto__ = cljs.core.chunk_first.call(null,s__38852__$2);
var size__5521__auto__ = cljs.core.count.call(null,c__5520__auto__);
var b__38854 = cljs.core.chunk_buffer.call(null,size__5521__auto__);
if((function (){var i__38853 = (0);
while(true){
if((i__38853 < size__5521__auto__)){
var item = cljs.core._nth.call(null,c__5520__auto__,i__38853);
cljs.core.chunk_append.call(null,b__38854,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null));

var G__38876 = (i__38853 + (1));
i__38853 = G__38876;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__38854),tailrecursion$priority_map$iter__38849_$_iter__38851.call(null,cljs.core.chunk_rest.call(null,s__38852__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__38854),null);
}
} else {
var item = cljs.core.first.call(null,s__38852__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null),tailrecursion$priority_map$iter__38849_$_iter__38851.call(null,cljs.core.rest.call(null,s__38852__$2)));
}
} else {
return null;
}
break;
}
});})(s__38850__$1,vec__38855,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1))
,null,null));
});})(s__38850__$1,vec__38855,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1))
;
var fs__5519__auto__ = cljs.core.seq.call(null,iterys__5518__auto__.call(null,item_set));
if(fs__5519__auto__){
return cljs.core.concat.call(null,fs__5519__auto__,tailrecursion$priority_map$iter__38849.call(null,cljs.core.rest.call(null,s__38850__$1)));
} else {
var G__38877 = cljs.core.rest.call(null,s__38850__$1);
s__38850__$1 = G__38877;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5522__auto__.call(null,sets);
})());
} else {
return cljs.core.seq.call(null,(function (){var iter__5522__auto__ = (function tailrecursion$priority_map$iter__38858(s__38859){
return (new cljs.core.LazySeq(null,(function (){
var s__38859__$1 = s__38859;
while(true){
var temp__5804__auto__ = cljs.core.seq.call(null,s__38859__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var vec__38864 = cljs.core.first.call(null,xs__6360__auto__);
var priority = cljs.core.nth.call(null,vec__38864,(0),null);
var item_set = cljs.core.nth.call(null,vec__38864,(1),null);
var iterys__5518__auto__ = ((function (s__38859__$1,vec__38864,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__38858_$_iter__38860(s__38861){
return (new cljs.core.LazySeq(null,((function (s__38859__$1,vec__38864,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1){
return (function (){
var s__38861__$1 = s__38861;
while(true){
var temp__5804__auto____$1 = cljs.core.seq.call(null,s__38861__$1);
if(temp__5804__auto____$1){
var s__38861__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__38861__$2)){
var c__5520__auto__ = cljs.core.chunk_first.call(null,s__38861__$2);
var size__5521__auto__ = cljs.core.count.call(null,c__5520__auto__);
var b__38863 = cljs.core.chunk_buffer.call(null,size__5521__auto__);
if((function (){var i__38862 = (0);
while(true){
if((i__38862 < size__5521__auto__)){
var item = cljs.core._nth.call(null,c__5520__auto__,i__38862);
cljs.core.chunk_append.call(null,b__38863,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__38878 = (i__38862 + (1));
i__38862 = G__38878;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__38863),tailrecursion$priority_map$iter__38858_$_iter__38860.call(null,cljs.core.chunk_rest.call(null,s__38861__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__38863),null);
}
} else {
var item = cljs.core.first.call(null,s__38861__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__38858_$_iter__38860.call(null,cljs.core.rest.call(null,s__38861__$2)));
}
} else {
return null;
}
break;
}
});})(s__38859__$1,vec__38864,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1))
,null,null));
});})(s__38859__$1,vec__38864,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1))
;
var fs__5519__auto__ = cljs.core.seq.call(null,iterys__5518__auto__.call(null,item_set));
if(fs__5519__auto__){
return cljs.core.concat.call(null,fs__5519__auto__,tailrecursion$priority_map$iter__38858.call(null,cljs.core.rest.call(null,s__38859__$1)));
} else {
var G__38879 = cljs.core.rest.call(null,s__38859__$1);
s__38859__$1 = G__38879;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5522__auto__.call(null,sets);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
return self__.keyfn.call(null,cljs.core.val.call(null,entry));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.compare;
}));

(tailrecursion.priority_map.PersistentPriorityMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"priority->set-of-items","priority->set-of-items",-1256537211,null),new cljs.core.Symbol(null,"item->priority","item->priority",-899999435,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$type = true);

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorStr = "tailrecursion.priority-map/PersistentPriorityMap");

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write.call(null,writer__5330__auto__,"tailrecursion.priority-map/PersistentPriorityMap");
}));

/**
 * Positional factory function for tailrecursion.priority-map/PersistentPriorityMap.
 */
tailrecursion.priority_map.__GT_PersistentPriorityMap = (function tailrecursion$priority_map$__GT_PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
return (new tailrecursion.priority_map.PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash));
});

(tailrecursion.priority_map.PersistentPriorityMap.EMPTY = (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map.call(null),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null)));
tailrecursion.priority_map.pm_empty_by = (function tailrecursion$priority_map$pm_empty_by(comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by.call(null,comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null));
});
tailrecursion.priority_map.pm_empty_keyfn = (function tailrecursion$priority_map$pm_empty_keyfn(var_args){
var G__38881 = arguments.length;
switch (G__38881) {
case 1:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map.call(null),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by.call(null,comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$lang$maxFixedArity = 2);

tailrecursion.priority_map.read_priority_map = (function tailrecursion$priority_map$read_priority_map(elems){
if(cljs.core.map_QMARK_.call(null,elems)){
return cljs.core.into.call(null,tailrecursion.priority_map.PersistentPriorityMap.EMPTY,elems);
} else {
throw Error("Priority map literal expects a map for its elements.");
}
});
cljs.reader.register_tag_parser_BANG_.call(null,"tailrecursion.priority-map",tailrecursion.priority_map.read_priority_map);
/**
 * keyval => key val
 *   Returns a new priority map with supplied mappings.
 */
tailrecursion.priority_map.priority_map = (function tailrecursion$priority_map$priority_map(var_args){
var args__5774__auto__ = [];
var len__5768__auto___38884 = arguments.length;
var i__5769__auto___38885 = (0);
while(true){
if((i__5769__auto___38885 < len__5768__auto___38884)){
args__5774__auto__.push((arguments[i__5769__auto___38885]));

var G__38886 = (i__5769__auto___38885 + (1));
i__5769__auto___38885 = G__38886;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.PersistentPriorityMap.EMPTY;
while(true){
if(in$){
var G__38887 = cljs.core.nnext.call(null,in$);
var G__38888 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__38887;
out = G__38888;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(tailrecursion.priority_map.priority_map.cljs$lang$applyTo = (function (seq38883){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38883));
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied comparator.
 */
tailrecursion.priority_map.priority_map_by = (function tailrecursion$priority_map$priority_map_by(var_args){
var args__5774__auto__ = [];
var len__5768__auto___38891 = arguments.length;
var i__5769__auto___38892 = (0);
while(true){
if((i__5769__auto___38892 < len__5768__auto___38891)){
args__5774__auto__.push((arguments[i__5769__auto___38892]));

var G__38893 = (i__5769__auto___38892 + (1));
i__5769__auto___38892 = G__38893;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.pm_empty_by.call(null,comparator);
while(true){
if(in$){
var G__38894 = cljs.core.nnext.call(null,in$);
var G__38895 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__38894;
out = G__38895;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_by.cljs$lang$applyTo = (function (seq38889){
var G__38890 = cljs.core.first.call(null,seq38889);
var seq38889__$1 = cljs.core.next.call(null,seq38889);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38890,seq38889__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn.
 */
tailrecursion.priority_map.priority_map_keyfn = (function tailrecursion$priority_map$priority_map_keyfn(var_args){
var args__5774__auto__ = [];
var len__5768__auto___38898 = arguments.length;
var i__5769__auto___38899 = (0);
while(true){
if((i__5769__auto___38899 < len__5768__auto___38898)){
args__5774__auto__.push((arguments[i__5769__auto___38899]));

var G__38900 = (i__5769__auto___38899 + (1));
i__5769__auto___38899 = G__38900;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.call(null,keyfn);
while(true){
if(in$){
var G__38901 = cljs.core.nnext.call(null,in$);
var G__38902 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__38901;
out = G__38902;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$applyTo = (function (seq38896){
var G__38897 = cljs.core.first.call(null,seq38896);
var seq38896__$1 = cljs.core.next.call(null,seq38896);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38897,seq38896__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn and comparator.
 */
tailrecursion.priority_map.priority_map_keyfn_by = (function tailrecursion$priority_map$priority_map_keyfn_by(var_args){
var args__5774__auto__ = [];
var len__5768__auto___38906 = arguments.length;
var i__5769__auto___38907 = (0);
while(true){
if((i__5769__auto___38907 < len__5768__auto___38906)){
args__5774__auto__.push((arguments[i__5769__auto___38907]));

var G__38908 = (i__5769__auto___38907 + (1));
i__5769__auto___38907 = G__38908;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((2) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((2)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5775__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,comparator,keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.call(null,keyfn,comparator);
while(true){
if(in$){
var G__38909 = cljs.core.nnext.call(null,in$);
var G__38910 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__38909;
out = G__38910;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$applyTo = (function (seq38903){
var G__38904 = cljs.core.first.call(null,seq38903);
var seq38903__$1 = cljs.core.next.call(null,seq38903);
var G__38905 = cljs.core.first.call(null,seq38903__$1);
var seq38903__$2 = cljs.core.next.call(null,seq38903__$1);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38904,G__38905,seq38903__$2);
}));

