// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.analyzer.impl.namespaces');
goog.require('cljs.core');
goog.require('cljs.core.constants');
/**
 * Given a libspec return a map of :as-alias alias, if was present. Return the
 * libspec with :as-alias elided. If the libspec was *only* :as-alias do not
 * return it.
 */
cljs.analyzer.impl.namespaces.check_and_remove_as_alias = (function cljs$analyzer$impl$namespaces$check_and_remove_as_alias(libspec){
if((((libspec instanceof cljs.core.Symbol)) || ((libspec instanceof cljs.core.Keyword)))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$libspec,libspec], null);
} else {
var vec__7118 = libspec;
var seq__7119 = cljs.core.seq(vec__7118);
var first__7120 = cljs.core.first(seq__7119);
var seq__7119__$1 = cljs.core.next(seq__7119);
var lib = first__7120;
var spec = seq__7119__$1;
var libspec__$1 = vec__7118;
var vec__7121 = cljs.core.split_with(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$as_DASH_alias,null], null), null)),spec);
var pre_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7121,(0),null);
var vec__7124 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7121,(1),null);
var seq__7125 = cljs.core.seq(vec__7124);
var first__7126 = cljs.core.first(seq__7125);
var seq__7125__$1 = cljs.core.next(seq__7125);
var _ = first__7126;
var first__7126__$1 = cljs.core.first(seq__7125__$1);
var seq__7125__$2 = cljs.core.next(seq__7125__$1);
var alias = first__7126__$1;
var post_spec = seq__7125__$2;
var post = vec__7124;
if(cljs.core.seq(post)){
var libspec_SINGLEQUOTE_ = cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [lib], null),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(pre_spec,post_spec));
if((alias instanceof cljs.core.Symbol)){
} else {
throw (new Error(["Assert failed: ",[":as-alias must be followed by a symbol, got: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(alias)].join(''),"\n","(symbol? alias)"].join('')));
}

var G__7127 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$as_DASH_alias,cljs.core.PersistentArrayMap.createAsIfByAssoc([alias,lib])], null);
if((cljs.core.count(libspec_SINGLEQUOTE_) > (1))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__7127,cljs.core.cst$kw$libspec,libspec_SINGLEQUOTE_);
} else {
return G__7127;
}
} else {
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$libspec,libspec__$1], null);
}
}
});
cljs.analyzer.impl.namespaces.check_as_alias_duplicates = (function cljs$analyzer$impl$namespaces$check_as_alias_duplicates(as_aliases,new_as_aliases){
var seq__7128 = cljs.core.seq(new_as_aliases);
var chunk__7129 = null;
var count__7130 = (0);
var i__7131 = (0);
while(true){
if((i__7131 < count__7130)){
var vec__7138 = chunk__7129.cljs$core$IIndexed$_nth$arity$2(null,i__7131);
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7138,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7138,(1),null);
if((!(cljs.core.contains_QMARK_(as_aliases,alias)))){
} else {
throw (new Error(["Assert failed: ",["Duplicate :as-alias ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(alias),", already in use for lib ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(as_aliases,alias))].join(''),"\n","(not (contains? as-aliases alias))"].join('')));
}


var G__7144 = seq__7128;
var G__7145 = chunk__7129;
var G__7146 = count__7130;
var G__7147 = (i__7131 + (1));
seq__7128 = G__7144;
chunk__7129 = G__7145;
count__7130 = G__7146;
i__7131 = G__7147;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__7128);
if(temp__5804__auto__){
var seq__7128__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__7128__$1)){
var c__5567__auto__ = cljs.core.chunk_first(seq__7128__$1);
var G__7148 = cljs.core.chunk_rest(seq__7128__$1);
var G__7149 = c__5567__auto__;
var G__7150 = cljs.core.count(c__5567__auto__);
var G__7151 = (0);
seq__7128 = G__7148;
chunk__7129 = G__7149;
count__7130 = G__7150;
i__7131 = G__7151;
continue;
} else {
var vec__7141 = cljs.core.first(seq__7128__$1);
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7141,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7141,(1),null);
if((!(cljs.core.contains_QMARK_(as_aliases,alias)))){
} else {
throw (new Error(["Assert failed: ",["Duplicate :as-alias ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(alias),", already in use for lib ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(as_aliases,alias))].join(''),"\n","(not (contains? as-aliases alias))"].join('')));
}


var G__7152 = cljs.core.next(seq__7128__$1);
var G__7153 = null;
var G__7154 = (0);
var G__7155 = (0);
seq__7128 = G__7152;
chunk__7129 = G__7153;
count__7130 = G__7154;
i__7131 = G__7155;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Given libspecs, elide all :as-alias. Return a map of :libspecs (filtered)
 * and :as-aliases.
 */
cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs = (function cljs$analyzer$impl$namespaces$elide_aliases_from_libspecs(var_args){
var G__7157 = arguments.length;
switch (G__7157) {
case 1:
return cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$1 = (function (libspecs){
return cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2(libspecs,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2 = (function (libspecs,as_aliases){
var ret = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$as_DASH_aliases,as_aliases,cljs.core.cst$kw$libspecs,cljs.core.PersistentVector.EMPTY], null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__$1,libspec){
var map__7158 = cljs.analyzer.impl.namespaces.check_and_remove_as_alias(libspec);
var map__7158__$1 = cljs.core.__destructure_map(map__7158);
var as_alias = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7158__$1,cljs.core.cst$kw$as_DASH_alias);
var libspec__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7158__$1,cljs.core.cst$kw$libspec);
cljs.analyzer.impl.namespaces.check_as_alias_duplicates(cljs.core.cst$kw$as_DASH_aliases.cljs$core$IFn$_invoke$arity$1(ret__$1),as_alias);

var G__7159 = ret__$1;
var G__7159__$1 = (cljs.core.truth_(libspec__$1)?cljs.core.update.cljs$core$IFn$_invoke$arity$4(G__7159,cljs.core.cst$kw$libspecs,cljs.core.conj,libspec__$1):G__7159);
if(cljs.core.truth_(as_alias)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(G__7159__$1,cljs.core.cst$kw$as_DASH_aliases,cljs.core.merge,as_alias);
} else {
return G__7159__$1;
}
}),ret,libspecs);
}));

(cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$lang$maxFixedArity = 2);

cljs.analyzer.impl.namespaces.elide_aliases_from_ns_specs = (function cljs$analyzer$impl$namespaces$elide_aliases_from_ns_specs(ns_specs){

var ret = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$as_DASH_aliases,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$libspecs,cljs.core.PersistentVector.EMPTY], null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__7161,p__7162){
var map__7163 = p__7161;
var map__7163__$1 = cljs.core.__destructure_map(map__7163);
var ret__$1 = map__7163__$1;
var as_aliases = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7163__$1,cljs.core.cst$kw$as_DASH_aliases);
var vec__7164 = p__7162;
var seq__7165 = cljs.core.seq(vec__7164);
var first__7166 = cljs.core.first(seq__7165);
var seq__7165__$1 = cljs.core.next(seq__7165);
var spec_key = first__7166;
var libspecs = seq__7165__$1;
if((!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$refer_DASH_clojure,spec_key)))){
var map__7167 = cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2(libspecs,as_aliases);
var map__7167__$1 = cljs.core.__destructure_map(map__7167);
var as_aliases__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7167__$1,cljs.core.cst$kw$as_DASH_aliases);
var libspecs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7167__$1,cljs.core.cst$kw$libspecs);
var G__7168 = ret__$1;
var G__7168__$1 = (((!(cljs.core.empty_QMARK_(as_aliases__$1))))?cljs.core.update.cljs$core$IFn$_invoke$arity$4(G__7168,cljs.core.cst$kw$as_DASH_aliases,cljs.core.merge,as_aliases__$1):G__7168);
if((!(cljs.core.empty_QMARK_(libspecs__$1)))){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(G__7168__$1,cljs.core.cst$kw$libspecs,cljs.core.conj,cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(spec_key,libspecs__$1));
} else {
return G__7168__$1;
}
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(ret__$1,cljs.core.cst$kw$libspecs,cljs.core.conj,cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(spec_key,libspecs));
}
}),ret,ns_specs);
});
