// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.analyzer');
goog.require('cljs.analyzer.impl');
goog.require('cljs.env');
goog.require('cljs.source_map');
goog.require('cljs.tools.reader');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ecmascript5,cljs.core.cst$kw$ecmascript5_DASH_strict,cljs.core.cst$kw$ecmascript6,cljs.core.cst$kw$ecmascript6_DASH_strict,cljs.core.cst$kw$ecmascript_DASH_2015,cljs.core.cst$kw$ecmascript6_DASH_typed,cljs.core.cst$kw$ecmascript_DASH_2016,cljs.core.cst$kw$ecmascript_DASH_2017,cljs.core.cst$kw$ecmascript_DASH_next], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__10140 = s;
var map__10140__$1 = cljs.core.__destructure_map(map__10140);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10140__$1,cljs.core.cst$kw$name);
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10140__$1,cljs.core.cst$kw$info);
var d = (0);
var G__10142 = info;
var map__10143 = G__10142;
var map__10143__$1 = cljs.core.__destructure_map(map__10143);
var shadow = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10143__$1,cljs.core.cst$kw$shadow);
var d__$1 = d;
var G__10142__$1 = G__10142;
while(true){
var d__$2 = d__$1;
var map__10145 = G__10142__$1;
var map__10145__$1 = cljs.core.__destructure_map(map__10145);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10145__$1,cljs.core.cst$kw$shadow);
if(cljs.core.truth_(shadow__$1)){
var G__10146 = (d__$2 + (1));
var G__10147 = shadow__$1;
d__$1 = G__10146;
G__10142__$1 = G__10147;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__10148){
var map__10149 = p__10148;
var map__10149__$1 = cljs.core.__destructure_map(map__10149);
var name_var = map__10149__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10149__$1,cljs.core.cst$kw$name);
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10149__$1,cljs.core.cst$kw$info);
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__10150 = info;
var map__10150__$1 = cljs.core.__destructure_map(map__10150);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10150__$1,cljs.core.cst$kw$ns);
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10150__$1,cljs.core.cst$kw$fn_DASH_scope);
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.cst$kw$name),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__10151 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__10151) : cljs.compiler.munge.call(null,G__10151));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__10153 = arguments.length;
switch (G__10153) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.impl.cljs_map_QMARK_(s)){
var name_var = s;
var name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(name_var);
var field = cljs.core.cst$kw$field.cljs$core$IFn$_invoke$arity$1(name_var);
var info = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(name_var);
if((!((cljs.core.cst$kw$fn_DASH_self_DASH_name.cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__10154 = new cljs.core.Var(function(){return cljs.core.munge_str;},cljs.core.cst$sym$cljs$core_SLASH_munge_DASH_str,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$private,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[true,cljs.core.cst$sym$cljs$core,cljs.core.cst$sym$munge_DASH_str,"cljs/core.cljs",25,1,11790,11790,cljs.core.cst$sym$string,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__10154.cljs$core$IFn$_invoke$arity$1 ? fexpr__10154.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__10154.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__10156 = cp;
switch (G__10156) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__10158_10162 = cljs.core.seq(s);
var chunk__10159_10163 = null;
var count__10160_10164 = (0);
var i__10161_10165 = (0);
while(true){
if((i__10161_10165 < count__10160_10164)){
var c_10166 = chunk__10159_10163.cljs$core$IIndexed$_nth$arity$2(null,i__10161_10165);
sb.append(cljs.compiler.escape_char(c_10166));


var G__10167 = seq__10158_10162;
var G__10168 = chunk__10159_10163;
var G__10169 = count__10160_10164;
var G__10170 = (i__10161_10165 + (1));
seq__10158_10162 = G__10167;
chunk__10159_10163 = G__10168;
count__10160_10164 = G__10169;
i__10161_10165 = G__10170;
continue;
} else {
var temp__5804__auto___10171 = cljs.core.seq(seq__10158_10162);
if(temp__5804__auto___10171){
var seq__10158_10172__$1 = temp__5804__auto___10171;
if(cljs.core.chunked_seq_QMARK_(seq__10158_10172__$1)){
var c__5567__auto___10173 = cljs.core.chunk_first(seq__10158_10172__$1);
var G__10174 = cljs.core.chunk_rest(seq__10158_10172__$1);
var G__10175 = c__5567__auto___10173;
var G__10176 = cljs.core.count(c__5567__auto___10173);
var G__10177 = (0);
seq__10158_10162 = G__10174;
chunk__10159_10163 = G__10175;
count__10160_10164 = G__10176;
i__10161_10165 = G__10177;
continue;
} else {
var c_10178 = cljs.core.first(seq__10158_10172__$1);
sb.append(cljs.compiler.escape_char(c_10178));


var G__10179 = cljs.core.next(seq__10158_10172__$1);
var G__10180 = null;
var G__10181 = (0);
var G__10182 = (0);
seq__10158_10162 = G__10179;
chunk__10159_10163 = G__10180;
count__10160_10164 = G__10181;
i__10161_10165 = G__10182;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__5641__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5645__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__10183 = cljs.core.get_global_hierarchy;
return (fexpr__10183.cljs$core$IFn$_invoke$arity$0 ? fexpr__10183.cljs$core$IFn$_invoke$arity$0() : fexpr__10183.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),cljs.core.cst$kw$op,cljs.core.cst$kw$default,hierarchy__5645__auto__,method_table__5641__auto__,prefer_table__5642__auto__,method_cache__5643__auto__,cached_hierarchy__5644__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__10184_10189 = ast;
var map__10184_10190__$1 = cljs.core.__destructure_map(map__10184_10189);
var env_10191 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10184_10190__$1,cljs.core.cst$kw$env);
if(cljs.core.truth_(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(env_10191))){
var map__10185_10192 = env_10191;
var map__10185_10193__$1 = cljs.core.__destructure_map(map__10185_10192);
var line_10194 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10185_10193__$1,cljs.core.cst$kw$line);
var column_10195 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10185_10193__$1,cljs.core.cst$kw$column);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__10186 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$gcol,cljs.core.cst$kw$gen_DASH_col.cljs$core$IFn$_invoke$arity$1(m),cljs.core.cst$kw$gline,cljs.core.cst$kw$gen_DASH_line.cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__10188 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__10187 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$binding,null,cljs.core.cst$kw$var,null,cljs.core.cst$kw$js_DASH_var,null,cljs.core.cst$kw$local,null], null), null);
return (fexpr__10187.cljs$core$IFn$_invoke$arity$1 ? fexpr__10187.cljs$core$IFn$_invoke$arity$1(G__10188) : fexpr__10187.call(null,G__10188));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__10186,cljs.core.cst$kw$name,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__10186;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$source_DASH_map,(line_10194 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_10195)?(column_10195 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__10204 = arguments.length;
switch (G__10204) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__5793__auto__ = [];
var len__5768__auto___10211 = arguments.length;
var i__5769__auto___10212 = (0);
while(true){
if((i__5769__auto___10212 < len__5768__auto___10211)){
args_arr__5793__auto__.push((arguments[i__5769__auto___10212]));

var G__10213 = (i__5769__auto___10212 + (1));
i__5769__auto___10212 = G__10213;
continue;
} else {
}
break;
}

var argseq__5794__auto__ = (new cljs.core.IndexedSeq(args_arr__5793__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__5794__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.impl.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(typeof a === 'function'){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_10214 = (function (){var G__10205 = a;
if((!(typeof a === 'string'))){
return G__10205.toString();
} else {
return G__10205;
}
})();
var temp__5808__auto___10215 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5808__auto___10215 == null)){
} else {
var sm_data_10216 = temp__5808__auto___10215;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_10216,cljs.core.update,cljs.core.cst$kw$gen_DASH_col,(function (p1__10196_SHARP_){
return (p1__10196_SHARP_ + s_10214.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_10214], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__10206 = cljs.core.seq(xs);
var chunk__10207 = null;
var count__10208 = (0);
var i__10209 = (0);
while(true){
if((i__10209 < count__10208)){
var x = chunk__10207.cljs$core$IIndexed$_nth$arity$2(null,i__10209);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__10217 = seq__10206;
var G__10218 = chunk__10207;
var G__10219 = count__10208;
var G__10220 = (i__10209 + (1));
seq__10206 = G__10217;
chunk__10207 = G__10218;
count__10208 = G__10219;
i__10209 = G__10220;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__10206);
if(temp__5804__auto__){
var seq__10206__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10206__$1)){
var c__5567__auto__ = cljs.core.chunk_first(seq__10206__$1);
var G__10221 = cljs.core.chunk_rest(seq__10206__$1);
var G__10222 = c__5567__auto__;
var G__10223 = cljs.core.count(c__5567__auto__);
var G__10224 = (0);
seq__10206 = G__10221;
chunk__10207 = G__10222;
count__10208 = G__10223;
i__10209 = G__10224;
continue;
} else {
var x = cljs.core.first(seq__10206__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__10225 = cljs.core.next(seq__10206__$1);
var G__10226 = null;
var G__10227 = (0);
var G__10228 = (0);
seq__10206 = G__10225;
chunk__10207 = G__10226;
count__10208 = G__10227;
i__10209 = G__10228;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq10198){
var G__10199 = cljs.core.first(seq10198);
var seq10198__$1 = cljs.core.next(seq10198);
var G__10200 = cljs.core.first(seq10198__$1);
var seq10198__$2 = cljs.core.next(seq10198__$1);
var G__10201 = cljs.core.first(seq10198__$2);
var seq10198__$3 = cljs.core.next(seq10198__$2);
var G__10202 = cljs.core.first(seq10198__$3);
var seq10198__$4 = cljs.core.next(seq10198__$3);
var G__10203 = cljs.core.first(seq10198__$4);
var seq10198__$5 = cljs.core.next(seq10198__$4);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__10199,G__10200,G__10201,G__10202,G__10203,seq10198__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__10229){
var map__10230 = p__10229;
var map__10230__$1 = cljs.core.__destructure_map(map__10230);
var m = map__10230__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10230__$1,cljs.core.cst$kw$gen_DASH_line);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,cljs.core.cst$kw$gen_DASH_line,(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$gen_DASH_col,(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__10238 = arguments.length;
switch (G__10238) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__5793__auto__ = [];
var len__5768__auto___10244 = arguments.length;
var i__5769__auto___10245 = (0);
while(true){
if((i__5769__auto___10245 < len__5768__auto___10244)){
args_arr__5793__auto__.push((arguments[i__5769__auto___10245]));

var G__10246 = (i__5769__auto___10245 + (1));
i__5769__auto___10245 = G__10246;
continue;
} else {
}
break;
}

var argseq__5794__auto__ = (new cljs.core.IndexedSeq(args_arr__5793__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__5794__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__10239_10247 = cljs.core.seq(xs);
var chunk__10240_10248 = null;
var count__10241_10249 = (0);
var i__10242_10250 = (0);
while(true){
if((i__10242_10250 < count__10241_10249)){
var x_10251 = chunk__10240_10248.cljs$core$IIndexed$_nth$arity$2(null,i__10242_10250);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_10251);


var G__10252 = seq__10239_10247;
var G__10253 = chunk__10240_10248;
var G__10254 = count__10241_10249;
var G__10255 = (i__10242_10250 + (1));
seq__10239_10247 = G__10252;
chunk__10240_10248 = G__10253;
count__10241_10249 = G__10254;
i__10242_10250 = G__10255;
continue;
} else {
var temp__5804__auto___10256 = cljs.core.seq(seq__10239_10247);
if(temp__5804__auto___10256){
var seq__10239_10257__$1 = temp__5804__auto___10256;
if(cljs.core.chunked_seq_QMARK_(seq__10239_10257__$1)){
var c__5567__auto___10258 = cljs.core.chunk_first(seq__10239_10257__$1);
var G__10259 = cljs.core.chunk_rest(seq__10239_10257__$1);
var G__10260 = c__5567__auto___10258;
var G__10261 = cljs.core.count(c__5567__auto___10258);
var G__10262 = (0);
seq__10239_10247 = G__10259;
chunk__10240_10248 = G__10260;
count__10241_10249 = G__10261;
i__10242_10250 = G__10262;
continue;
} else {
var x_10263 = cljs.core.first(seq__10239_10257__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_10263);


var G__10264 = cljs.core.next(seq__10239_10257__$1);
var G__10265 = null;
var G__10266 = (0);
var G__10267 = (0);
seq__10239_10247 = G__10264;
chunk__10240_10248 = G__10265;
count__10241_10249 = G__10266;
i__10242_10250 = G__10267;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq10232){
var G__10233 = cljs.core.first(seq10232);
var seq10232__$1 = cljs.core.next(seq10232);
var G__10234 = cljs.core.first(seq10232__$1);
var seq10232__$2 = cljs.core.next(seq10232__$1);
var G__10235 = cljs.core.first(seq10232__$2);
var seq10232__$3 = cljs.core.next(seq10232__$2);
var G__10236 = cljs.core.first(seq10232__$3);
var seq10232__$4 = cljs.core.next(seq10232__$3);
var G__10237 = cljs.core.first(seq10232__$4);
var seq10232__$5 = cljs.core.next(seq10232__$4);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__10233,G__10234,G__10235,G__10236,G__10237,seq10232__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__5689__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__10268_10272 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__10269_10273 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__10270_10274 = true;
var _STAR_print_fn_STAR__temp_val__10271_10275 = (function (x__5690__auto__){
return sb__5689__auto__.append(x__5690__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__10270_10274);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__10271_10275);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__10269_10273);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__10268_10272);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__5689__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__5641__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5645__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__10276 = cljs.core.get_global_hierarchy;
return (fexpr__10276.cljs$core$IFn$_invoke$arity$0 ? fexpr__10276.cljs$core$IFn$_invoke$arity$0() : fexpr__10276.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,cljs.core.cst$kw$default,hierarchy__5645__auto__,method_table__5641__auto__,prefer_table__5642__auto__,method_cache__5643__auto__,cached_hierarchy__5644__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.impl.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__10277 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10277,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10277,(1),null);
var G__10280 = ns;
var G__10281 = name;
var G__10282 = (function (){
var G__10283 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__10283) : cljs.compiler.emit_constant.call(null,G__10283));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__10280,G__10281,G__10282) : cljs.compiler.emit_record_value.call(null,G__10280,G__10281,G__10282));
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(x)){
var G__10284 = cljs.core.keys(x);
var G__10285 = cljs.core.vals(x);
var G__10286 = cljs.compiler.emit_constants_comma_sep;
var G__10287 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__10284,G__10285,G__10286,G__10287) : cljs.compiler.emit_map.call(null,G__10284,G__10285,G__10286,G__10287));
} else {
if(cljs.analyzer.impl.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.impl.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__10288 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__10289 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__10288,G__10289) : cljs.compiler.emit_with_meta.call(null,G__10288,G__10289));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$constant,x,cljs.core.cst$kw$type,cljs.core.type(x),cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
if((((x === (0))) && ((((1) / x) < (0))))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(-0)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__10290 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10290,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10290,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10290,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5802__auto__ = (function (){var and__5043__auto__ = cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__5043__auto__)){
var G__10293 = cljs.core.cst$kw$cljs$analyzer_SLASH_constant_DASH_table.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__10293) : x.call(null,G__10293));
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var value = temp__5802__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5802__auto__ = (function (){var and__5043__auto__ = cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__5043__auto__)){
var G__10294 = cljs.core.cst$kw$cljs$analyzer_SLASH_constant_DASH_table.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__10294) : x.call(null,G__10294));
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var value = temp__5802__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_inst = (function cljs$compiler$emit_inst(inst_ms){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",inst_ms,")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emit_inst(date.getTime());
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__10296 = items;
var G__10297 = (function (p1__10295_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__10295_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__10296,G__10297) : cljs.compiler.emit_js_object.call(null,G__10296,G__10297));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$no_DASH_op,(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__10299){
var map__10300 = p__10299;
var map__10300__$1 = cljs.core.__destructure_map(map__10300);
var ast = map__10300__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10300__$1,cljs.core.cst$kw$info);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10300__$1,cljs.core.cst$kw$env);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10300__$1,cljs.core.cst$kw$form);
var temp__5802__auto__ = cljs.core.cst$kw$const_DASH_expr.cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5802__auto__)){
var const_expr = temp__5802__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,cljs.core.cst$kw$env,env));
} else {
var map__10301 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__10301__$1 = cljs.core.__destructure_map(map__10301);
var cenv = map__10301__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10301__$1,cljs.core.cst$kw$options);
var var_name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$js_DASH_module_DASH_index,cljs.core.name(var_name),cljs.core.cst$kw$name], null));
var or__5045__auto__ = js_module_name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(cljs.core.cst$kw$binding_DASH_form_QMARK_.cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__10302 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__5043__auto__ = (function (){var G__10303 = cljs.core.cst$kw$language_DASH_out.cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__10303) : cljs.compiler.es5_GT__EQ_.call(null,G__10303));
})();
if(cljs.core.truth_(and__5043__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__5043__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__10302,cljs.analyzer.es5_allowed);
} else {
return G__10302;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$js_DASH_namespaces,(function (){var or__5045__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__10304 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,cljs.core.cst$sym$js_SLASH__DASH_Infinity)){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__10304,reserved);
} else {
return G__10304;
}
})();
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__10305_10306 = cljs.core.cst$kw$module_DASH_type.cljs$core$IFn$_invoke$arity$1(js_module);
var G__10305_10307__$1 = (((G__10305_10306 instanceof cljs.core.Keyword))?G__10305_10306.fqn:null);
switch (G__10305_10307__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__5043__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$var,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$binding,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_var,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$local,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$the_DASH_var,(function (p__10309){
var map__10310 = p__10309;
var map__10310__$1 = cljs.core.__destructure_map(map__10310);
var arg = map__10310__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10310__$1,cljs.core.cst$kw$env);
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10310__$1,cljs.core.cst$kw$var);
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10310__$1,cljs.core.cst$kw$sym);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10310__$1,cljs.core.cst$kw$meta);
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__10311 = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(var$);
var map__10311__$1 = cljs.core.__destructure_map(map__10311);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10311__$1,cljs.core.cst$kw$name);
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$with_DASH_meta,(function (p__10312){
var map__10313 = p__10312;
var map__10313__$1 = cljs.core.__destructure_map(map__10313);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10313__$1,cljs.core.cst$kw$expr);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10313__$1,cljs.core.cst$kw$meta);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10313__$1,cljs.core.cst$kw$env);
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__10314_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__10314_SHARP_),cljs.core.cst$kw$const);
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__10315 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__10315) : comma_sep.call(null,G__10315));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__10316 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__10316) : comma_sep.call(null,G__10316));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$map,(function (p__10317){
var map__10318 = p__10317;
var map__10318__$1 = cljs.core.__destructure_map(map__10318);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10318__$1,cljs.core.cst$kw$env);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10318__$1,cljs.core.cst$kw$keys);
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10318__$1,cljs.core.cst$kw$vals);
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$vector,(function (p__10319){
var map__10320 = p__10319;
var map__10320__$1 = cljs.core.__destructure_map(map__10320);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10320__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10320__$1,cljs.core.cst$kw$env);
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__10321_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__10321_SHARP_),cljs.core.cst$kw$const);
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__10322 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__10322) : comma_sep.call(null,G__10322));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set,(function (p__10323){
var map__10324 = p__10323;
var map__10324__$1 = cljs.core.__destructure_map(map__10324);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10324__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10324__$1,cljs.core.cst$kw$env);
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5804__auto___10347 = cljs.core.seq(items);
if(temp__5804__auto___10347){
var items_10348__$1 = temp__5804__auto___10347;
var vec__10325_10349 = items_10348__$1;
var seq__10326_10350 = cljs.core.seq(vec__10325_10349);
var first__10327_10351 = cljs.core.first(seq__10326_10350);
var seq__10326_10352__$1 = cljs.core.next(seq__10326_10350);
var vec__10328_10353 = first__10327_10351;
var k_10354 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10328_10353,(0),null);
var v_10355 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10328_10353,(1),null);
var r_10356 = seq__10326_10352__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_10354),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_10355) : emit_js_object_val.call(null,v_10355)));

var seq__10331_10357 = cljs.core.seq(r_10356);
var chunk__10332_10358 = null;
var count__10333_10359 = (0);
var i__10334_10360 = (0);
while(true){
if((i__10334_10360 < count__10333_10359)){
var vec__10341_10361 = chunk__10332_10358.cljs$core$IIndexed$_nth$arity$2(null,i__10334_10360);
var k_10362__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10341_10361,(0),null);
var v_10363__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10341_10361,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_10362__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_10363__$1) : emit_js_object_val.call(null,v_10363__$1)));


var G__10364 = seq__10331_10357;
var G__10365 = chunk__10332_10358;
var G__10366 = count__10333_10359;
var G__10367 = (i__10334_10360 + (1));
seq__10331_10357 = G__10364;
chunk__10332_10358 = G__10365;
count__10333_10359 = G__10366;
i__10334_10360 = G__10367;
continue;
} else {
var temp__5804__auto___10368__$1 = cljs.core.seq(seq__10331_10357);
if(temp__5804__auto___10368__$1){
var seq__10331_10369__$1 = temp__5804__auto___10368__$1;
if(cljs.core.chunked_seq_QMARK_(seq__10331_10369__$1)){
var c__5567__auto___10370 = cljs.core.chunk_first(seq__10331_10369__$1);
var G__10371 = cljs.core.chunk_rest(seq__10331_10369__$1);
var G__10372 = c__5567__auto___10370;
var G__10373 = cljs.core.count(c__5567__auto___10370);
var G__10374 = (0);
seq__10331_10357 = G__10371;
chunk__10332_10358 = G__10372;
count__10333_10359 = G__10373;
i__10334_10360 = G__10374;
continue;
} else {
var vec__10344_10375 = cljs.core.first(seq__10331_10369__$1);
var k_10376__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10344_10375,(0),null);
var v_10377__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10344_10375,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_10376__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_10377__$1) : emit_js_object_val.call(null,v_10377__$1)));


var G__10378 = cljs.core.next(seq__10331_10369__$1);
var G__10379 = null;
var G__10380 = (0);
var G__10381 = (0);
seq__10331_10357 = G__10378;
chunk__10332_10358 = G__10379;
count__10333_10359 = G__10380;
i__10334_10360 = G__10381;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_object,(function (p__10382){
var map__10383 = p__10382;
var map__10383__$1 = cljs.core.__destructure_map(map__10383);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10383__$1,cljs.core.cst$kw$keys);
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10383__$1,cljs.core.cst$kw$vals);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10383__$1,cljs.core.cst$kw$env);
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_array,(function (p__10384){
var map__10385 = p__10384;
var map__10385__$1 = cljs.core.__destructure_map(map__10385);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10385__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10385__$1,cljs.core.cst$kw$env);
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$quote,(function (p__10386){
var map__10387 = p__10386;
var map__10387__$1 = cljs.core.__destructure_map(map__10387);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10387__$1,cljs.core.cst$kw$expr);
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$const,(function (p__10388){
var map__10389 = p__10388;
var map__10389__$1 = cljs.core.__destructure_map(map__10389);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10389__$1,cljs.core.cst$kw$form);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10389__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__10390 = cljs.analyzer.unwrap_quote(expr);
var map__10390__$1 = cljs.core.__destructure_map(map__10390);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10390__$1,cljs.core.cst$kw$op);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10390__$1,cljs.core.cst$kw$form);
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10390__$1,cljs.core.cst$kw$const_DASH_expr);
var or__5045__auto__ = (function (){var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$const);
if(and__5043__auto__){
var and__5043__auto____$1 = form;
if(cljs.core.truth_(and__5043__auto____$1)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto__ = (!((const_expr == null)));
if(and__5043__auto__){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return and__5043__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__10391 = cljs.analyzer.unwrap_quote(expr);
var map__10391__$1 = cljs.core.__destructure_map(map__10391);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10391__$1,cljs.core.cst$kw$op);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10391__$1,cljs.core.cst$kw$form);
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10391__$1,cljs.core.cst$kw$const_DASH_expr);
var or__5045__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$const)) && (((form === false) || ((form == null)))));
if(or__5045__auto__){
return or__5045__auto__;
} else {
var and__5043__auto__ = (!((const_expr == null)));
if(and__5043__auto__){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return and__5043__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__5045__auto__ = (function (){var fexpr__10392 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$seq,null,cljs.core.cst$sym$boolean,null], null), null);
return (fexpr__10392.cljs$core$IFn$_invoke$arity$1 ? fexpr__10392.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__10392.call(null,tag));
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$if,(function (p__10393){
var map__10394 = p__10393;
var map__10394__$1 = cljs.core.__destructure_map(map__10394);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10394__$1,cljs.core.cst$kw$test);
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10394__$1,cljs.core.cst$kw$then);
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10394__$1,cljs.core.cst$kw$else);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10394__$1,cljs.core.cst$kw$env);
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10394__$1,cljs.core.cst$kw$unchecked);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__5045__auto__ = unchecked;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$case,(function (p__10395){
var map__10396 = p__10395;
var map__10396__$1 = cljs.core.__destructure_map(map__10396);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10396__$1,cljs.core.cst$kw$test);
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10396__$1,cljs.core.cst$kw$nodes);
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10396__$1,cljs.core.cst$kw$default);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10396__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env),cljs.core.cst$kw$expr)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__10397_10425 = cljs.core.seq(nodes);
var chunk__10398_10426 = null;
var count__10399_10427 = (0);
var i__10400_10428 = (0);
while(true){
if((i__10400_10428 < count__10399_10427)){
var map__10413_10429 = chunk__10398_10426.cljs$core$IIndexed$_nth$arity$2(null,i__10400_10428);
var map__10413_10430__$1 = cljs.core.__destructure_map(map__10413_10429);
var ts_10431 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10413_10430__$1,cljs.core.cst$kw$tests);
var map__10414_10432 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10413_10430__$1,cljs.core.cst$kw$then);
var map__10414_10433__$1 = cljs.core.__destructure_map(map__10414_10432);
var then_10434 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10414_10433__$1,cljs.core.cst$kw$then);
var seq__10415_10435 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$test,ts_10431));
var chunk__10416_10436 = null;
var count__10417_10437 = (0);
var i__10418_10438 = (0);
while(true){
if((i__10418_10438 < count__10417_10437)){
var test_10439 = chunk__10416_10436.cljs$core$IIndexed$_nth$arity$2(null,i__10418_10438);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_10439,":");


var G__10440 = seq__10415_10435;
var G__10441 = chunk__10416_10436;
var G__10442 = count__10417_10437;
var G__10443 = (i__10418_10438 + (1));
seq__10415_10435 = G__10440;
chunk__10416_10436 = G__10441;
count__10417_10437 = G__10442;
i__10418_10438 = G__10443;
continue;
} else {
var temp__5804__auto___10444 = cljs.core.seq(seq__10415_10435);
if(temp__5804__auto___10444){
var seq__10415_10445__$1 = temp__5804__auto___10444;
if(cljs.core.chunked_seq_QMARK_(seq__10415_10445__$1)){
var c__5567__auto___10446 = cljs.core.chunk_first(seq__10415_10445__$1);
var G__10447 = cljs.core.chunk_rest(seq__10415_10445__$1);
var G__10448 = c__5567__auto___10446;
var G__10449 = cljs.core.count(c__5567__auto___10446);
var G__10450 = (0);
seq__10415_10435 = G__10447;
chunk__10416_10436 = G__10448;
count__10417_10437 = G__10449;
i__10418_10438 = G__10450;
continue;
} else {
var test_10451 = cljs.core.first(seq__10415_10445__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_10451,":");


var G__10452 = cljs.core.next(seq__10415_10445__$1);
var G__10453 = null;
var G__10454 = (0);
var G__10455 = (0);
seq__10415_10435 = G__10452;
chunk__10416_10436 = G__10453;
count__10417_10437 = G__10454;
i__10418_10438 = G__10455;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_10434);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_10434);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__10456 = seq__10397_10425;
var G__10457 = chunk__10398_10426;
var G__10458 = count__10399_10427;
var G__10459 = (i__10400_10428 + (1));
seq__10397_10425 = G__10456;
chunk__10398_10426 = G__10457;
count__10399_10427 = G__10458;
i__10400_10428 = G__10459;
continue;
} else {
var temp__5804__auto___10460 = cljs.core.seq(seq__10397_10425);
if(temp__5804__auto___10460){
var seq__10397_10461__$1 = temp__5804__auto___10460;
if(cljs.core.chunked_seq_QMARK_(seq__10397_10461__$1)){
var c__5567__auto___10462 = cljs.core.chunk_first(seq__10397_10461__$1);
var G__10463 = cljs.core.chunk_rest(seq__10397_10461__$1);
var G__10464 = c__5567__auto___10462;
var G__10465 = cljs.core.count(c__5567__auto___10462);
var G__10466 = (0);
seq__10397_10425 = G__10463;
chunk__10398_10426 = G__10464;
count__10399_10427 = G__10465;
i__10400_10428 = G__10466;
continue;
} else {
var map__10419_10467 = cljs.core.first(seq__10397_10461__$1);
var map__10419_10468__$1 = cljs.core.__destructure_map(map__10419_10467);
var ts_10469 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10419_10468__$1,cljs.core.cst$kw$tests);
var map__10420_10470 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10419_10468__$1,cljs.core.cst$kw$then);
var map__10420_10471__$1 = cljs.core.__destructure_map(map__10420_10470);
var then_10472 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10420_10471__$1,cljs.core.cst$kw$then);
var seq__10421_10473 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$test,ts_10469));
var chunk__10422_10474 = null;
var count__10423_10475 = (0);
var i__10424_10476 = (0);
while(true){
if((i__10424_10476 < count__10423_10475)){
var test_10477 = chunk__10422_10474.cljs$core$IIndexed$_nth$arity$2(null,i__10424_10476);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_10477,":");


var G__10478 = seq__10421_10473;
var G__10479 = chunk__10422_10474;
var G__10480 = count__10423_10475;
var G__10481 = (i__10424_10476 + (1));
seq__10421_10473 = G__10478;
chunk__10422_10474 = G__10479;
count__10423_10475 = G__10480;
i__10424_10476 = G__10481;
continue;
} else {
var temp__5804__auto___10482__$1 = cljs.core.seq(seq__10421_10473);
if(temp__5804__auto___10482__$1){
var seq__10421_10483__$1 = temp__5804__auto___10482__$1;
if(cljs.core.chunked_seq_QMARK_(seq__10421_10483__$1)){
var c__5567__auto___10484 = cljs.core.chunk_first(seq__10421_10483__$1);
var G__10485 = cljs.core.chunk_rest(seq__10421_10483__$1);
var G__10486 = c__5567__auto___10484;
var G__10487 = cljs.core.count(c__5567__auto___10484);
var G__10488 = (0);
seq__10421_10473 = G__10485;
chunk__10422_10474 = G__10486;
count__10423_10475 = G__10487;
i__10424_10476 = G__10488;
continue;
} else {
var test_10489 = cljs.core.first(seq__10421_10483__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_10489,":");


var G__10490 = cljs.core.next(seq__10421_10483__$1);
var G__10491 = null;
var G__10492 = (0);
var G__10493 = (0);
seq__10421_10473 = G__10490;
chunk__10422_10474 = G__10491;
count__10423_10475 = G__10492;
i__10424_10476 = G__10493;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_10472);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_10472);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__10494 = cljs.core.next(seq__10397_10461__$1);
var G__10495 = null;
var G__10496 = (0);
var G__10497 = (0);
seq__10397_10425 = G__10494;
chunk__10398_10426 = G__10495;
count__10399_10427 = G__10496;
i__10400_10428 = G__10497;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$throw,(function (p__10498){
var map__10499 = p__10498;
var map__10499__$1 = cljs.core.__destructure_map(map__10499);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10499__$1,cljs.core.cst$kw$exception);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10499__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__10503 = env;
var G__10504 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__10503,G__10504) : cljs.compiler.resolve_type.call(null,G__10503,G__10504));
})())].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__10505 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10505,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10505,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__10500_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__10500_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__10500_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__10508 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__10508,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__10508;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__10511 = env;
var G__10512 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__10511,G__10512) : cljs.compiler.resolve_type.call(null,G__10511,G__10512));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__10513_SHARP_){
return cljs.compiler.resolve_type(env,p1__10513_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__10514 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__10515 = cljs.core.seq(vec__10514);
var first__10516 = cljs.core.first(seq__10515);
var seq__10515__$1 = cljs.core.next(seq__10515);
var p = first__10516;
var first__10516__$1 = cljs.core.first(seq__10515__$1);
var seq__10515__$2 = cljs.core.next(seq__10515__$1);
var ts = first__10516__$1;
var first__10516__$2 = cljs.core.first(seq__10515__$2);
var seq__10515__$3 = cljs.core.next(seq__10515__$2);
var n = first__10516__$2;
var xs = seq__10515__$3;
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p);
if(and__5043__auto__){
var and__5043__auto____$1 = ts;
if(cljs.core.truth_(and__5043__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__10517 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__10518 = cljs.core.seq(vec__10517);
var first__10519 = cljs.core.first(seq__10518);
var seq__10518__$1 = cljs.core.next(seq__10518);
var p = first__10519;
var first__10519__$1 = cljs.core.first(seq__10518__$1);
var seq__10518__$2 = cljs.core.next(seq__10518__$1);
var ts = first__10519__$1;
var xs = seq__10518__$2;
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p);
if(and__5043__auto__){
var and__5043__auto____$1 = ts;
if(cljs.core.truth_(and__5043__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__10521 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$options,cljs.core.cst$kw$closure_DASH_warnings,cljs.core.cst$kw$check_DASH_types], null));
var fexpr__10520 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$warning,null,cljs.core.cst$kw$error,null], null), null);
return (fexpr__10520.cljs$core$IFn$_invoke$arity$1 ? fexpr__10520.cljs$core$IFn$_invoke$arity$1(G__10521) : fexpr__10520.call(null,G__10521));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__10524 = arguments.length;
switch (G__10524) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__10532 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__10522_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__10522_SHARP_);
} else {
return p1__10522_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__10533 = cljs.core.seq(vec__10532);
var first__10534 = cljs.core.first(seq__10533);
var seq__10533__$1 = cljs.core.next(seq__10533);
var x = first__10534;
var ys = seq__10533__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__10535 = cljs.core.seq(ys);
var chunk__10536 = null;
var count__10537 = (0);
var i__10538 = (0);
while(true){
if((i__10538 < count__10537)){
var next_line = chunk__10536.cljs$core$IIndexed$_nth$arity$2(null,i__10538);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__10544 = seq__10535;
var G__10545 = chunk__10536;
var G__10546 = count__10537;
var G__10547 = (i__10538 + (1));
seq__10535 = G__10544;
chunk__10536 = G__10545;
count__10537 = G__10546;
i__10538 = G__10547;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__10535);
if(temp__5804__auto__){
var seq__10535__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10535__$1)){
var c__5567__auto__ = cljs.core.chunk_first(seq__10535__$1);
var G__10548 = cljs.core.chunk_rest(seq__10535__$1);
var G__10549 = c__5567__auto__;
var G__10550 = cljs.core.count(c__5567__auto__);
var G__10551 = (0);
seq__10535 = G__10548;
chunk__10536 = G__10549;
count__10537 = G__10550;
i__10538 = G__10551;
continue;
} else {
var next_line = cljs.core.first(seq__10535__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__10552 = cljs.core.next(seq__10535__$1);
var G__10553 = null;
var G__10554 = (0);
var G__10555 = (0);
seq__10535 = G__10552;
chunk__10536 = G__10553;
count__10537 = G__10554;
i__10538 = G__10555;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__10539_10556 = cljs.core.seq(docs__$2);
var chunk__10540_10557 = null;
var count__10541_10558 = (0);
var i__10542_10559 = (0);
while(true){
if((i__10542_10559 < count__10541_10558)){
var e_10560 = chunk__10540_10557.cljs$core$IIndexed$_nth$arity$2(null,i__10542_10559);
if(cljs.core.truth_(e_10560)){
print_comment_lines(e_10560);
} else {
}


var G__10561 = seq__10539_10556;
var G__10562 = chunk__10540_10557;
var G__10563 = count__10541_10558;
var G__10564 = (i__10542_10559 + (1));
seq__10539_10556 = G__10561;
chunk__10540_10557 = G__10562;
count__10541_10558 = G__10563;
i__10542_10559 = G__10564;
continue;
} else {
var temp__5804__auto___10565 = cljs.core.seq(seq__10539_10556);
if(temp__5804__auto___10565){
var seq__10539_10566__$1 = temp__5804__auto___10565;
if(cljs.core.chunked_seq_QMARK_(seq__10539_10566__$1)){
var c__5567__auto___10567 = cljs.core.chunk_first(seq__10539_10566__$1);
var G__10568 = cljs.core.chunk_rest(seq__10539_10566__$1);
var G__10569 = c__5567__auto___10567;
var G__10570 = cljs.core.count(c__5567__auto___10567);
var G__10571 = (0);
seq__10539_10556 = G__10568;
chunk__10540_10557 = G__10569;
count__10541_10558 = G__10570;
i__10542_10559 = G__10571;
continue;
} else {
var e_10572 = cljs.core.first(seq__10539_10566__$1);
if(cljs.core.truth_(e_10572)){
print_comment_lines(e_10572);
} else {
}


var G__10573 = cljs.core.next(seq__10539_10566__$1);
var G__10574 = null;
var G__10575 = (0);
var G__10576 = (0);
seq__10539_10556 = G__10573;
chunk__10540_10557 = G__10574;
count__10541_10558 = G__10575;
i__10542_10559 = G__10576;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (((x === true) || (((x === false) || (typeof x === 'number'))))));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),cljs.core.cst$kw$options);
var and__5043__auto__ = cljs.core.some((function (p1__10578_SHARP_){
return goog.string.startsWith(p1__10578_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__5043__auto__)){
var and__5043__auto____$1 = opts;
if(cljs.core.truth_(and__5043__auto____$1)){
var and__5043__auto____$2 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$optimizations.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$none);
if(and__5043__auto____$2){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$closure_DASH_defines,cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return and__5043__auto____$2;
}
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$def,(function (p__10579){
var map__10580 = p__10579;
var map__10580__$1 = cljs.core.__destructure_map(map__10580);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10580__$1,cljs.core.cst$kw$doc);
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10580__$1,cljs.core.cst$kw$jsdoc);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10580__$1,cljs.core.cst$kw$test);
var goog_define = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10580__$1,cljs.core.cst$kw$goog_DASH_define);
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10580__$1,cljs.core.cst$kw$init);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10580__$1,cljs.core.cst$kw$name);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10580__$1,cljs.core.cst$kw$env);
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10580__$1,cljs.core.cst$kw$export);
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10580__$1,cljs.core.cst$kw$var);
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10580__$1,cljs.core.cst$kw$var_DASH_ast);
if(cljs.core.truth_((function (){var or__5045__auto__ = init;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$jsdoc.cljs$core$IFn$_invoke$arity$1(init)], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5802__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5802__auto__)){
var define = temp__5802__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$the_DASH_var,cljs.core.cst$kw$env,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,cljs.core.cst$kw$context,cljs.core.cst$kw$expr)], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
return test;
} else {
return and__5043__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__10581){
var map__10582 = p__10581;
var map__10582__$1 = cljs.core.__destructure_map(map__10582);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10582__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10582__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10582__$1,cljs.core.cst$kw$env);
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__10583_10607 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__10584_10608 = null;
var count__10585_10609 = (0);
var i__10586_10610 = (0);
while(true){
if((i__10586_10610 < count__10585_10609)){
var vec__10593_10611 = chunk__10584_10608.cljs$core$IIndexed$_nth$arity$2(null,i__10586_10610);
var i_10612 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10593_10611,(0),null);
var param_10613 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10593_10611,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_10613);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__10614 = seq__10583_10607;
var G__10615 = chunk__10584_10608;
var G__10616 = count__10585_10609;
var G__10617 = (i__10586_10610 + (1));
seq__10583_10607 = G__10614;
chunk__10584_10608 = G__10615;
count__10585_10609 = G__10616;
i__10586_10610 = G__10617;
continue;
} else {
var temp__5804__auto___10618 = cljs.core.seq(seq__10583_10607);
if(temp__5804__auto___10618){
var seq__10583_10619__$1 = temp__5804__auto___10618;
if(cljs.core.chunked_seq_QMARK_(seq__10583_10619__$1)){
var c__5567__auto___10620 = cljs.core.chunk_first(seq__10583_10619__$1);
var G__10621 = cljs.core.chunk_rest(seq__10583_10619__$1);
var G__10622 = c__5567__auto___10620;
var G__10623 = cljs.core.count(c__5567__auto___10620);
var G__10624 = (0);
seq__10583_10607 = G__10621;
chunk__10584_10608 = G__10622;
count__10585_10609 = G__10623;
i__10586_10610 = G__10624;
continue;
} else {
var vec__10596_10625 = cljs.core.first(seq__10583_10619__$1);
var i_10626 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10596_10625,(0),null);
var param_10627 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10596_10625,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_10627);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__10628 = cljs.core.next(seq__10583_10619__$1);
var G__10629 = null;
var G__10630 = (0);
var G__10631 = (0);
seq__10583_10607 = G__10628;
chunk__10584_10608 = G__10629;
count__10585_10609 = G__10630;
i__10586_10610 = G__10631;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__10599_10632 = cljs.core.seq(params);
var chunk__10600_10633 = null;
var count__10601_10634 = (0);
var i__10602_10635 = (0);
while(true){
if((i__10602_10635 < count__10601_10634)){
var param_10636 = chunk__10600_10633.cljs$core$IIndexed$_nth$arity$2(null,i__10602_10635);
cljs.compiler.emit(param_10636);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10636,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10637 = seq__10599_10632;
var G__10638 = chunk__10600_10633;
var G__10639 = count__10601_10634;
var G__10640 = (i__10602_10635 + (1));
seq__10599_10632 = G__10637;
chunk__10600_10633 = G__10638;
count__10601_10634 = G__10639;
i__10602_10635 = G__10640;
continue;
} else {
var temp__5804__auto___10641 = cljs.core.seq(seq__10599_10632);
if(temp__5804__auto___10641){
var seq__10599_10642__$1 = temp__5804__auto___10641;
if(cljs.core.chunked_seq_QMARK_(seq__10599_10642__$1)){
var c__5567__auto___10643 = cljs.core.chunk_first(seq__10599_10642__$1);
var G__10644 = cljs.core.chunk_rest(seq__10599_10642__$1);
var G__10645 = c__5567__auto___10643;
var G__10646 = cljs.core.count(c__5567__auto___10643);
var G__10647 = (0);
seq__10599_10632 = G__10644;
chunk__10600_10633 = G__10645;
count__10601_10634 = G__10646;
i__10602_10635 = G__10647;
continue;
} else {
var param_10648 = cljs.core.first(seq__10599_10642__$1);
cljs.compiler.emit(param_10648);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10648,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10649 = cljs.core.next(seq__10599_10642__$1);
var G__10650 = null;
var G__10651 = (0);
var G__10652 = (0);
seq__10599_10632 = G__10649;
chunk__10600_10633 = G__10650;
count__10601_10634 = G__10651;
i__10602_10635 = G__10652;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__10603_10653 = cljs.core.seq(params);
var chunk__10604_10654 = null;
var count__10605_10655 = (0);
var i__10606_10656 = (0);
while(true){
if((i__10606_10656 < count__10605_10655)){
var param_10657 = chunk__10604_10654.cljs$core$IIndexed$_nth$arity$2(null,i__10606_10656);
cljs.compiler.emit(param_10657);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10657,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10658 = seq__10603_10653;
var G__10659 = chunk__10604_10654;
var G__10660 = count__10605_10655;
var G__10661 = (i__10606_10656 + (1));
seq__10603_10653 = G__10658;
chunk__10604_10654 = G__10659;
count__10605_10655 = G__10660;
i__10606_10656 = G__10661;
continue;
} else {
var temp__5804__auto___10662 = cljs.core.seq(seq__10603_10653);
if(temp__5804__auto___10662){
var seq__10603_10663__$1 = temp__5804__auto___10662;
if(cljs.core.chunked_seq_QMARK_(seq__10603_10663__$1)){
var c__5567__auto___10664 = cljs.core.chunk_first(seq__10603_10663__$1);
var G__10665 = cljs.core.chunk_rest(seq__10603_10663__$1);
var G__10666 = c__5567__auto___10664;
var G__10667 = cljs.core.count(c__5567__auto___10664);
var G__10668 = (0);
seq__10603_10653 = G__10665;
chunk__10604_10654 = G__10666;
count__10605_10655 = G__10667;
i__10606_10656 = G__10668;
continue;
} else {
var param_10669 = cljs.core.first(seq__10603_10663__$1);
cljs.compiler.emit(param_10669);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10669,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10670 = cljs.core.next(seq__10603_10663__$1);
var G__10671 = null;
var G__10672 = (0);
var G__10673 = (0);
seq__10603_10653 = G__10670;
chunk__10604_10654 = G__10671;
count__10605_10655 = G__10672;
i__10606_10656 = G__10673;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__10674 = cljs.core.seq(params);
var chunk__10675 = null;
var count__10676 = (0);
var i__10677 = (0);
while(true){
if((i__10677 < count__10676)){
var param = chunk__10675.cljs$core$IIndexed$_nth$arity$2(null,i__10677);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10678 = seq__10674;
var G__10679 = chunk__10675;
var G__10680 = count__10676;
var G__10681 = (i__10677 + (1));
seq__10674 = G__10678;
chunk__10675 = G__10679;
count__10676 = G__10680;
i__10677 = G__10681;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__10674);
if(temp__5804__auto__){
var seq__10674__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10674__$1)){
var c__5567__auto__ = cljs.core.chunk_first(seq__10674__$1);
var G__10682 = cljs.core.chunk_rest(seq__10674__$1);
var G__10683 = c__5567__auto__;
var G__10684 = cljs.core.count(c__5567__auto__);
var G__10685 = (0);
seq__10674 = G__10682;
chunk__10675 = G__10683;
count__10676 = G__10684;
i__10677 = G__10685;
continue;
} else {
var param = cljs.core.first(seq__10674__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10686 = cljs.core.next(seq__10674__$1);
var G__10687 = null;
var G__10688 = (0);
var G__10689 = (0);
seq__10674 = G__10686;
chunk__10675 = G__10687;
count__10676 = G__10688;
i__10677 = G__10689;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__10690){
var map__10691 = p__10690;
var map__10691__$1 = cljs.core.__destructure_map(map__10691);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10691__$1,cljs.core.cst$kw$body);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10691__$1,cljs.core.cst$kw$type);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10691__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10691__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10691__$1,cljs.core.cst$kw$env);
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10691__$1,cljs.core.cst$kw$recurs);
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__10692){
var map__10693 = p__10692;
var map__10693__$1 = cljs.core.__destructure_map(map__10693);
var f = map__10693__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10693__$1,cljs.core.cst$kw$body);
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10693__$1,cljs.core.cst$kw$fixed_DASH_arity);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10693__$1,cljs.core.cst$kw$variadic_QMARK_);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10693__$1,cljs.core.cst$kw$type);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10693__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10693__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10693__$1,cljs.core.cst$kw$env);
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10693__$1,cljs.core.cst$kw$recurs);
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_10702__$1 = (function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_10703 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_10702__$1);
var delegate_name_10704 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_10703),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_10704," = function (");

var seq__10694_10705 = cljs.core.seq(params);
var chunk__10695_10706 = null;
var count__10696_10707 = (0);
var i__10697_10708 = (0);
while(true){
if((i__10697_10708 < count__10696_10707)){
var param_10709 = chunk__10695_10706.cljs$core$IIndexed$_nth$arity$2(null,i__10697_10708);
cljs.compiler.emit(param_10709);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10709,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10710 = seq__10694_10705;
var G__10711 = chunk__10695_10706;
var G__10712 = count__10696_10707;
var G__10713 = (i__10697_10708 + (1));
seq__10694_10705 = G__10710;
chunk__10695_10706 = G__10711;
count__10696_10707 = G__10712;
i__10697_10708 = G__10713;
continue;
} else {
var temp__5804__auto___10714 = cljs.core.seq(seq__10694_10705);
if(temp__5804__auto___10714){
var seq__10694_10715__$1 = temp__5804__auto___10714;
if(cljs.core.chunked_seq_QMARK_(seq__10694_10715__$1)){
var c__5567__auto___10716 = cljs.core.chunk_first(seq__10694_10715__$1);
var G__10717 = cljs.core.chunk_rest(seq__10694_10715__$1);
var G__10718 = c__5567__auto___10716;
var G__10719 = cljs.core.count(c__5567__auto___10716);
var G__10720 = (0);
seq__10694_10705 = G__10717;
chunk__10695_10706 = G__10718;
count__10696_10707 = G__10719;
i__10697_10708 = G__10720;
continue;
} else {
var param_10721 = cljs.core.first(seq__10694_10715__$1);
cljs.compiler.emit(param_10721);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10721,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10722 = cljs.core.next(seq__10694_10715__$1);
var G__10723 = null;
var G__10724 = (0);
var G__10725 = (0);
seq__10694_10705 = G__10722;
chunk__10695_10706 = G__10723;
count__10696_10707 = G__10724;
i__10697_10708 = G__10725;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_10703," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_args], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_10726 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_10726,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_10704,".call(this,");

var seq__10698_10727 = cljs.core.seq(params);
var chunk__10699_10728 = null;
var count__10700_10729 = (0);
var i__10701_10730 = (0);
while(true){
if((i__10701_10730 < count__10700_10729)){
var param_10731 = chunk__10699_10728.cljs$core$IIndexed$_nth$arity$2(null,i__10701_10730);
cljs.compiler.emit(param_10731);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10731,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10732 = seq__10698_10727;
var G__10733 = chunk__10699_10728;
var G__10734 = count__10700_10729;
var G__10735 = (i__10701_10730 + (1));
seq__10698_10727 = G__10732;
chunk__10699_10728 = G__10733;
count__10700_10729 = G__10734;
i__10701_10730 = G__10735;
continue;
} else {
var temp__5804__auto___10736 = cljs.core.seq(seq__10698_10727);
if(temp__5804__auto___10736){
var seq__10698_10737__$1 = temp__5804__auto___10736;
if(cljs.core.chunked_seq_QMARK_(seq__10698_10737__$1)){
var c__5567__auto___10738 = cljs.core.chunk_first(seq__10698_10737__$1);
var G__10739 = cljs.core.chunk_rest(seq__10698_10737__$1);
var G__10740 = c__5567__auto___10738;
var G__10741 = cljs.core.count(c__5567__auto___10738);
var G__10742 = (0);
seq__10698_10727 = G__10739;
chunk__10699_10728 = G__10740;
count__10700_10729 = G__10741;
i__10701_10730 = G__10742;
continue;
} else {
var param_10743 = cljs.core.first(seq__10698_10737__$1);
cljs.compiler.emit(param_10743);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10743,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10744 = cljs.core.next(seq__10698_10737__$1);
var G__10745 = null;
var G__10746 = (0);
var G__10747 = (0);
seq__10698_10727 = G__10744;
chunk__10699_10728 = G__10745;
count__10700_10729 = G__10746;
i__10701_10730 = G__10747;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10703,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_10703,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,cljs.core.cst$kw$name,name_10702__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10703,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_10704,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_10703,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$fn,(function (p__10751){
var map__10752 = p__10751;
var map__10752__$1 = cljs.core.__destructure_map(map__10752);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10752__$1,cljs.core.cst$kw$variadic_QMARK_);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10752__$1,cljs.core.cst$kw$name);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10752__$1,cljs.core.cst$kw$env);
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10752__$1,cljs.core.cst$kw$methods);
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10752__$1,cljs.core.cst$kw$max_DASH_fixed_DASH_arity);
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10752__$1,cljs.core.cst$kw$recur_DASH_frames);
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10752__$1,cljs.core.cst$kw$in_DASH_loop);
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10752__$1,cljs.core.cst$kw$loop_DASH_lets);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__10748_SHARP_){
var and__5043__auto__ = p1__10748_SHARP_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.deref(cljs.core.cst$kw$flag.cljs$core$IFn$_invoke$arity$1(p1__10748_SHARP_));
} else {
return and__5043__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__5045__auto__ = in_loop;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),cljs.core.cst$kw$name,name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),cljs.core.cst$kw$name,name));
}
} else {
var name_10804__$1 = (function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_10805 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_10804__$1);
var maxparams_10806 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$params,methods$));
var mmap_10807 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_10805),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_10808 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__10749_SHARP_){
return cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__10749_SHARP_)));
}),cljs.core.seq(mmap_10807));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_10805," = null;");

var seq__10753_10809 = cljs.core.seq(ms_10808);
var chunk__10754_10810 = null;
var count__10755_10811 = (0);
var i__10756_10812 = (0);
while(true){
if((i__10756_10812 < count__10755_10811)){
var vec__10763_10813 = chunk__10754_10810.cljs$core$IIndexed$_nth$arity$2(null,i__10756_10812);
var n_10814 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10763_10813,(0),null);
var meth_10815 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10763_10813,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_10814," = ");

if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_10815))){
cljs.compiler.emit_variadic_fn_method(meth_10815);
} else {
cljs.compiler.emit_fn_method(meth_10815);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__10816 = seq__10753_10809;
var G__10817 = chunk__10754_10810;
var G__10818 = count__10755_10811;
var G__10819 = (i__10756_10812 + (1));
seq__10753_10809 = G__10816;
chunk__10754_10810 = G__10817;
count__10755_10811 = G__10818;
i__10756_10812 = G__10819;
continue;
} else {
var temp__5804__auto___10820 = cljs.core.seq(seq__10753_10809);
if(temp__5804__auto___10820){
var seq__10753_10821__$1 = temp__5804__auto___10820;
if(cljs.core.chunked_seq_QMARK_(seq__10753_10821__$1)){
var c__5567__auto___10822 = cljs.core.chunk_first(seq__10753_10821__$1);
var G__10823 = cljs.core.chunk_rest(seq__10753_10821__$1);
var G__10824 = c__5567__auto___10822;
var G__10825 = cljs.core.count(c__5567__auto___10822);
var G__10826 = (0);
seq__10753_10809 = G__10823;
chunk__10754_10810 = G__10824;
count__10755_10811 = G__10825;
i__10756_10812 = G__10826;
continue;
} else {
var vec__10766_10827 = cljs.core.first(seq__10753_10821__$1);
var n_10828 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10766_10827,(0),null);
var meth_10829 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10766_10827,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_10828," = ");

if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_10829))){
cljs.compiler.emit_variadic_fn_method(meth_10829);
} else {
cljs.compiler.emit_fn_method(meth_10829);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__10830 = cljs.core.next(seq__10753_10821__$1);
var G__10831 = null;
var G__10832 = (0);
var G__10833 = (0);
seq__10753_10809 = G__10830;
chunk__10754_10810 = G__10831;
count__10755_10811 = G__10832;
i__10756_10812 = G__10833;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10805," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_10806),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_args], null)):maxparams_10806)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_10806));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__10769_10834 = cljs.core.seq(ms_10808);
var chunk__10770_10835 = null;
var count__10771_10836 = (0);
var i__10772_10837 = (0);
while(true){
if((i__10772_10837 < count__10771_10836)){
var vec__10779_10838 = chunk__10770_10835.cljs$core$IIndexed$_nth$arity$2(null,i__10772_10837);
var n_10839 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10779_10838,(0),null);
var meth_10840 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10779_10838,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_10840))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_10841 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_10841," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_10842 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_10841," = new cljs.core.IndexedSeq(",a_10842,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_10839,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_10806)),(((cljs.core.count(maxparams_10806) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_10841,");"], 0));
} else {
var pcnt_10843 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_10840));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_10843,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_10839,".call(this",(((pcnt_10843 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_10843,maxparams_10806)),null,(1),null)),(2),null))),");");
}


var G__10844 = seq__10769_10834;
var G__10845 = chunk__10770_10835;
var G__10846 = count__10771_10836;
var G__10847 = (i__10772_10837 + (1));
seq__10769_10834 = G__10844;
chunk__10770_10835 = G__10845;
count__10771_10836 = G__10846;
i__10772_10837 = G__10847;
continue;
} else {
var temp__5804__auto___10848 = cljs.core.seq(seq__10769_10834);
if(temp__5804__auto___10848){
var seq__10769_10849__$1 = temp__5804__auto___10848;
if(cljs.core.chunked_seq_QMARK_(seq__10769_10849__$1)){
var c__5567__auto___10850 = cljs.core.chunk_first(seq__10769_10849__$1);
var G__10851 = cljs.core.chunk_rest(seq__10769_10849__$1);
var G__10852 = c__5567__auto___10850;
var G__10853 = cljs.core.count(c__5567__auto___10850);
var G__10854 = (0);
seq__10769_10834 = G__10851;
chunk__10770_10835 = G__10852;
count__10771_10836 = G__10853;
i__10772_10837 = G__10854;
continue;
} else {
var vec__10782_10855 = cljs.core.first(seq__10769_10849__$1);
var n_10856 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10782_10855,(0),null);
var meth_10857 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10782_10855,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_10857))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_10858 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_10858," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_10859 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_10858," = new cljs.core.IndexedSeq(",a_10859,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_10856,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_10806)),(((cljs.core.count(maxparams_10806) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_10858,");"], 0));
} else {
var pcnt_10860 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_10857));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_10860,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_10856,".call(this",(((pcnt_10860 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_10860,maxparams_10806)),null,(1),null)),(2),null))),");");
}


var G__10861 = cljs.core.next(seq__10769_10849__$1);
var G__10862 = null;
var G__10863 = (0);
var G__10864 = (0);
seq__10769_10834 = G__10861;
chunk__10770_10835 = G__10862;
count__10771_10836 = G__10863;
i__10772_10837 = G__10864;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_10865 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$self__,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_10808)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_10865,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10805,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10805,".cljs$lang$applyTo = ",cljs.core.some((function (p1__10750_SHARP_){
var vec__10785 = p1__10750_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10785,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10785,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_10808),".cljs$lang$applyTo;");
} else {
}

var seq__10788_10866 = cljs.core.seq(ms_10808);
var chunk__10789_10867 = null;
var count__10790_10868 = (0);
var i__10791_10869 = (0);
while(true){
if((i__10791_10869 < count__10790_10868)){
var vec__10798_10870 = chunk__10789_10867.cljs$core$IIndexed$_nth$arity$2(null,i__10791_10869);
var n_10871 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10798_10870,(0),null);
var meth_10872 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10798_10870,(1),null);
var c_10873 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_10872));
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_10872))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10805,".cljs$core$IFn$_invoke$arity$variadic = ",n_10871,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_10805,".cljs$core$IFn$_invoke$arity$",c_10873," = ",n_10871,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__10874 = seq__10788_10866;
var G__10875 = chunk__10789_10867;
var G__10876 = count__10790_10868;
var G__10877 = (i__10791_10869 + (1));
seq__10788_10866 = G__10874;
chunk__10789_10867 = G__10875;
count__10790_10868 = G__10876;
i__10791_10869 = G__10877;
continue;
} else {
var temp__5804__auto___10878 = cljs.core.seq(seq__10788_10866);
if(temp__5804__auto___10878){
var seq__10788_10879__$1 = temp__5804__auto___10878;
if(cljs.core.chunked_seq_QMARK_(seq__10788_10879__$1)){
var c__5567__auto___10880 = cljs.core.chunk_first(seq__10788_10879__$1);
var G__10881 = cljs.core.chunk_rest(seq__10788_10879__$1);
var G__10882 = c__5567__auto___10880;
var G__10883 = cljs.core.count(c__5567__auto___10880);
var G__10884 = (0);
seq__10788_10866 = G__10881;
chunk__10789_10867 = G__10882;
count__10790_10868 = G__10883;
i__10791_10869 = G__10884;
continue;
} else {
var vec__10801_10885 = cljs.core.first(seq__10788_10879__$1);
var n_10886 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10801_10885,(0),null);
var meth_10887 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10801_10885,(1),null);
var c_10888 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_10887));
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_10887))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10805,".cljs$core$IFn$_invoke$arity$variadic = ",n_10886,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_10805,".cljs$core$IFn$_invoke$arity$",c_10888," = ",n_10886,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__10889 = cljs.core.next(seq__10788_10879__$1);
var G__10890 = null;
var G__10891 = (0);
var G__10892 = (0);
seq__10788_10866 = G__10889;
chunk__10789_10867 = G__10890;
count__10790_10868 = G__10891;
i__10791_10869 = G__10892;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_10805,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$do,(function (p__10893){
var map__10894 = p__10893;
var map__10894__$1 = cljs.core.__destructure_map(map__10894);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10894__$1,cljs.core.cst$kw$statements);
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10894__$1,cljs.core.cst$kw$ret);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10894__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__10895_10899 = cljs.core.seq(statements);
var chunk__10896_10900 = null;
var count__10897_10901 = (0);
var i__10898_10902 = (0);
while(true){
if((i__10898_10902 < count__10897_10901)){
var s_10903 = chunk__10896_10900.cljs$core$IIndexed$_nth$arity$2(null,i__10898_10902);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_10903);


var G__10904 = seq__10895_10899;
var G__10905 = chunk__10896_10900;
var G__10906 = count__10897_10901;
var G__10907 = (i__10898_10902 + (1));
seq__10895_10899 = G__10904;
chunk__10896_10900 = G__10905;
count__10897_10901 = G__10906;
i__10898_10902 = G__10907;
continue;
} else {
var temp__5804__auto___10908 = cljs.core.seq(seq__10895_10899);
if(temp__5804__auto___10908){
var seq__10895_10909__$1 = temp__5804__auto___10908;
if(cljs.core.chunked_seq_QMARK_(seq__10895_10909__$1)){
var c__5567__auto___10910 = cljs.core.chunk_first(seq__10895_10909__$1);
var G__10911 = cljs.core.chunk_rest(seq__10895_10909__$1);
var G__10912 = c__5567__auto___10910;
var G__10913 = cljs.core.count(c__5567__auto___10910);
var G__10914 = (0);
seq__10895_10899 = G__10911;
chunk__10896_10900 = G__10912;
count__10897_10901 = G__10913;
i__10898_10902 = G__10914;
continue;
} else {
var s_10915 = cljs.core.first(seq__10895_10909__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_10915);


var G__10916 = cljs.core.next(seq__10895_10909__$1);
var G__10917 = null;
var G__10918 = (0);
var G__10919 = (0);
seq__10895_10899 = G__10916;
chunk__10896_10900 = G__10917;
count__10897_10901 = G__10918;
i__10898_10902 = G__10919;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$try,(function (p__10920){
var map__10921 = p__10920;
var map__10921__$1 = cljs.core.__destructure_map(map__10921);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10921__$1,cljs.core.cst$kw$body);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10921__$1,cljs.core.cst$kw$env);
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10921__$1,cljs.core.cst$kw$catch);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10921__$1,cljs.core.cst$kw$name);
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10921__$1,cljs.core.cst$kw$finally);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$const,cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__10922,is_loop){
var map__10923 = p__10922;
var map__10923__$1 = cljs.core.__destructure_map(map__10923);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10923__$1,cljs.core.cst$kw$body);
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10923__$1,cljs.core.cst$kw$bindings);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10923__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__10924_10934 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__10925_10935 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__10925_10935);

try{var seq__10926_10936 = cljs.core.seq(bindings);
var chunk__10927_10937 = null;
var count__10928_10938 = (0);
var i__10929_10939 = (0);
while(true){
if((i__10929_10939 < count__10928_10938)){
var map__10932_10940 = chunk__10927_10937.cljs$core$IIndexed$_nth$arity$2(null,i__10929_10939);
var map__10932_10941__$1 = cljs.core.__destructure_map(map__10932_10940);
var binding_10942 = map__10932_10941__$1;
var init_10943 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10932_10941__$1,cljs.core.cst$kw$init);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_10942);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_10943,";");


var G__10944 = seq__10926_10936;
var G__10945 = chunk__10927_10937;
var G__10946 = count__10928_10938;
var G__10947 = (i__10929_10939 + (1));
seq__10926_10936 = G__10944;
chunk__10927_10937 = G__10945;
count__10928_10938 = G__10946;
i__10929_10939 = G__10947;
continue;
} else {
var temp__5804__auto___10948 = cljs.core.seq(seq__10926_10936);
if(temp__5804__auto___10948){
var seq__10926_10949__$1 = temp__5804__auto___10948;
if(cljs.core.chunked_seq_QMARK_(seq__10926_10949__$1)){
var c__5567__auto___10950 = cljs.core.chunk_first(seq__10926_10949__$1);
var G__10951 = cljs.core.chunk_rest(seq__10926_10949__$1);
var G__10952 = c__5567__auto___10950;
var G__10953 = cljs.core.count(c__5567__auto___10950);
var G__10954 = (0);
seq__10926_10936 = G__10951;
chunk__10927_10937 = G__10952;
count__10928_10938 = G__10953;
i__10929_10939 = G__10954;
continue;
} else {
var map__10933_10955 = cljs.core.first(seq__10926_10949__$1);
var map__10933_10956__$1 = cljs.core.__destructure_map(map__10933_10955);
var binding_10957 = map__10933_10956__$1;
var init_10958 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10933_10956__$1,cljs.core.cst$kw$init);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_10957);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_10958,";");


var G__10959 = cljs.core.next(seq__10926_10949__$1);
var G__10960 = null;
var G__10961 = (0);
var G__10962 = (0);
seq__10926_10936 = G__10959;
chunk__10927_10937 = G__10960;
count__10928_10938 = G__10961;
i__10929_10939 = G__10962;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__10924_10934);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$let,(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$loop,(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$recur,(function (p__10963){
var map__10964 = p__10963;
var map__10964__$1 = cljs.core.__destructure_map(map__10964);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10964__$1,cljs.core.cst$kw$frame);
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10964__$1,cljs.core.cst$kw$exprs);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10964__$1,cljs.core.cst$kw$env);
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(frame);
var n__5635__auto___10965 = cljs.core.count(exprs);
var i_10966 = (0);
while(true){
if((i_10966 < n__5635__auto___10965)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_10966) : temps.call(null,i_10966))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_10966) : exprs.call(null,i_10966)),";");

var G__10967 = (i_10966 + (1));
i_10966 = G__10967;
continue;
} else {
}
break;
}

var n__5635__auto___10968 = cljs.core.count(exprs);
var i_10969 = (0);
while(true){
if((i_10969 < n__5635__auto___10968)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_10969) : params.call(null,i_10969)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_10969) : temps.call(null,i_10969)),";");

var G__10970 = (i_10969 + (1));
i_10969 = G__10970;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$letfn,(function (p__10971){
var map__10972 = p__10971;
var map__10972__$1 = cljs.core.__destructure_map(map__10972);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10972__$1,cljs.core.cst$kw$body);
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10972__$1,cljs.core.cst$kw$bindings);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10972__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__10973_10981 = cljs.core.seq(bindings);
var chunk__10974_10982 = null;
var count__10975_10983 = (0);
var i__10976_10984 = (0);
while(true){
if((i__10976_10984 < count__10975_10983)){
var map__10979_10985 = chunk__10974_10982.cljs$core$IIndexed$_nth$arity$2(null,i__10976_10984);
var map__10979_10986__$1 = cljs.core.__destructure_map(map__10979_10985);
var binding_10987 = map__10979_10986__$1;
var init_10988 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10979_10986__$1,cljs.core.cst$kw$init);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_10987)," = ",init_10988,";");


var G__10989 = seq__10973_10981;
var G__10990 = chunk__10974_10982;
var G__10991 = count__10975_10983;
var G__10992 = (i__10976_10984 + (1));
seq__10973_10981 = G__10989;
chunk__10974_10982 = G__10990;
count__10975_10983 = G__10991;
i__10976_10984 = G__10992;
continue;
} else {
var temp__5804__auto___10993 = cljs.core.seq(seq__10973_10981);
if(temp__5804__auto___10993){
var seq__10973_10994__$1 = temp__5804__auto___10993;
if(cljs.core.chunked_seq_QMARK_(seq__10973_10994__$1)){
var c__5567__auto___10995 = cljs.core.chunk_first(seq__10973_10994__$1);
var G__10996 = cljs.core.chunk_rest(seq__10973_10994__$1);
var G__10997 = c__5567__auto___10995;
var G__10998 = cljs.core.count(c__5567__auto___10995);
var G__10999 = (0);
seq__10973_10981 = G__10996;
chunk__10974_10982 = G__10997;
count__10975_10983 = G__10998;
i__10976_10984 = G__10999;
continue;
} else {
var map__10980_11000 = cljs.core.first(seq__10973_10994__$1);
var map__10980_11001__$1 = cljs.core.__destructure_map(map__10980_11000);
var binding_11002 = map__10980_11001__$1;
var init_11003 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10980_11001__$1,cljs.core.cst$kw$init);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_11002)," = ",init_11003,";");


var G__11004 = cljs.core.next(seq__10973_10994__$1);
var G__11005 = null;
var G__11006 = (0);
var G__11007 = (0);
seq__10973_10981 = G__11004;
chunk__10974_10982 = G__11005;
count__10975_10983 = G__11006;
i__10976_10984 = G__11007;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$invoke,(function (p__11010){
var map__11011 = p__11010;
var map__11011__$1 = cljs.core.__destructure_map(map__11011);
var expr = map__11011__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11011__$1,cljs.core.cst$kw$fn);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11011__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11011__$1,cljs.core.cst$kw$env);
var info = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__5043__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
var and__5043__auto____$1 = cljs.core.not(cljs.core.cst$kw$dynamic.cljs$core$IFn$_invoke$arity$1(info));
if(and__5043__auto____$1){
return cljs.core.cst$kw$fn_DASH_var.cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})();
var protocol = cljs.core.cst$kw$protocol.cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(cljs.core.cst$kw$args.cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__5043__auto__ = protocol;
if(cljs.core.truth_(and__5043__auto__)){
var and__5043__auto____$1 = tag;
if(cljs.core.truth_(and__5043__auto____$1)){
var or__5045__auto__ = (function (){var and__5043__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__5043__auto____$2)){
var and__5043__auto____$3 = protocol;
if(cljs.core.truth_(and__5043__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,cljs.core.cst$sym$not_DASH_native);
} else {
return and__5043__auto____$3;
}
} else {
return and__5043__auto____$2;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto____$2 = (function (){var or__5045__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.cst$kw$protocol_DASH_inline.cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__5043__auto____$2)){
var or__5045__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__5045__auto____$1){
return or__5045__auto____$1;
} else {
var and__5043__auto____$3 = (!(cljs.core.set_QMARK_(tag)));
if(and__5043__auto____$3){
var and__5043__auto____$4 = cljs.core.not((function (){var fexpr__11015 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$boolean,"null",cljs.core.cst$sym$object,"null",cljs.core.cst$sym$any,"null",cljs.core.cst$sym$js,"null",cljs.core.cst$sym$number,"null",cljs.core.cst$sym$clj_DASH_or_DASH_nil,"null",cljs.core.cst$sym$array,"null",cljs.core.cst$sym$string,"null",cljs.core.cst$sym$function,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null);
return (fexpr__11015.cljs$core$IFn$_invoke$arity$1 ? fexpr__11015.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__11015.call(null,tag));
})());
if(and__5043__auto____$4){
var temp__5804__auto__ = cljs.core.cst$kw$protocols.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(tag,cljs.core.assoc,cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true)));
if(cljs.core.truth_(temp__5804__auto__)){
var ps = temp__5804__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return and__5043__auto____$4;
}
} else {
return and__5043__auto____$3;
}
}
} else {
return and__5043__auto____$2;
}
}
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(cljs.core.cst$kw$args.cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info),cljs.core.cst$sym$cljs$core_SLASH_not)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,cljs.core.cst$sym$boolean)));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info),cljs.core.cst$sym$cljs$core_SLASH_count)) && (cljs.core.boolean$((function (){var fexpr__11016 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$array,"null",cljs.core.cst$sym$string,"null"], null), null);
return (fexpr__11016.cljs$core$IFn$_invoke$arity$1 ? fexpr__11016.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__11016.call(null,first_arg_tag));
})())));
var ns = cljs.core.cst$kw$ns.cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__5045__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$js);
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$Math);
if(or__5045__auto____$1){
return or__5045__auto____$1;
} else {
return cljs.core.cst$kw$foreign.cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__5045__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$goog);
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = (function (){var temp__5804__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5804__auto__)){
var ns_str = temp__5804__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__5045__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$cljs$core_SLASH_Keyword,ftag);
if(or__5045__auto__){
return or__5045__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(f__$1),cljs.core.cst$kw$const)) && ((cljs.core.cst$kw$form.cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__11012 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(info);
var mps = cljs.core.cst$kw$method_DASH_params.cljs$core$IFn$_invoke$arity$1(info);
var mfa = cljs.core.cst$kw$max_DASH_fixed_DASH_arity.cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return (arity > mfa);
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,cljs.core.cst$kw$name,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (p1__11008_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__11008_SHARP_,cljs.core.cst$kw$shadow),cljs.core.cst$kw$fn_DASH_self_DASH_name);
}));
})),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$max_DASH_fixed_DASH_arity,mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,cljs.core.cst$kw$name,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (p1__11009_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__11009_SHARP_,cljs.core.cst$kw$shadow),cljs.core.cst$kw$fn_DASH_self_DASH_name);
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11012,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11012,(1),null);
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_11019 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_11019,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_11020 = cljs.core.cst$kw$max_DASH_fixed_DASH_arity.cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_11020,args)),(((mfa_11020 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_11020,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
var G__11018 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__11017 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$var,null,cljs.core.cst$kw$js_DASH_var,null,cljs.core.cst$kw$local,null], null), null);
return (fexpr__11017.cljs$core$IFn$_invoke$arity$1 ? fexpr__11017.cljs$core$IFn$_invoke$arity$1(G__11018) : fexpr__11017.call(null,G__11018));
} else {
return and__5043__auto__;
}
})())){
var fprop_11021 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_11021," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_11021,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_11021," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_11021,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new,(function (p__11022){
var map__11023 = p__11022;
var map__11023__$1 = cljs.core.__destructure_map(map__11023);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11023__$1,cljs.core.cst$kw$class);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11023__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11023__$1,cljs.core.cst$kw$env);
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set_BANG_,(function (p__11024){
var map__11025 = p__11024;
var map__11025__$1 = cljs.core.__destructure_map(map__11025);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11025__$1,cljs.core.cst$kw$target);
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11025__$1,cljs.core.cst$kw$val);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11025__$1,cljs.core.cst$kw$env);
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.sublib_select = (function cljs$compiler$sublib_select(sublib){
if(cljs.core.truth_(sublib)){
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(sublib,/\./);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__11026_SHARP_){
return ["['",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__11026_SHARP_),"']"].join('');
}),xs));
} else {
return null;
}
});
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
var vec__11027 = cljs.analyzer.lib_AMPERSAND_sublib(lib);
var lib_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11027,(0),null);
var sublib = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11027,(1),null);
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib_SINGLEQUOTE_));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib_SINGLEQUOTE_));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.sublib_select(sublib),";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__11030 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__11030__$1 = cljs.core.__destructure_map(map__11030);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11030__$1,cljs.core.cst$kw$options);
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11030__$1,cljs.core.cst$kw$js_DASH_dependency_DASH_index);
var map__11031 = options;
var map__11031__$1 = cljs.core.__destructure_map(map__11031);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11031__$1,cljs.core.cst$kw$target);
var nodejs_rt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11031__$1,cljs.core.cst$kw$nodejs_DASH_rt);
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11031__$1,cljs.core.cst$kw$optimizations);
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$sym$cljs$core$_STAR_loaded_DASH_libs_STAR_);
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$sym$cljs$core$_STAR_loaded_DASH_libs_STAR_));
var vec__11032 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$nodejs,target)){
var map__11038 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__11038__$1 = cljs.core.__destructure_map(map__11038);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11038__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11038__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11032,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11032,(1),null);
var vec__11035 = (function (){var map__11039 = cljs.core.group_by(cljs.analyzer.goog_module_dep_QMARK_,libs_to_load);
var map__11039__$1 = cljs.core.__destructure_map(map__11039);
var goog_modules = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11039__$1,true);
var libs_to_load__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11039__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [goog_modules,libs_to_load__$1], null);
})();
var goog_modules = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11035,(0),null);
var libs_to_load__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11035,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load__$1);
if(cljs.core.truth_(cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__11040_11084 = cljs.core.seq(libs_to_load__$1);
var chunk__11041_11085 = null;
var count__11042_11086 = (0);
var i__11043_11087 = (0);
while(true){
if((i__11043_11087 < count__11042_11086)){
var lib_11088 = chunk__11041_11085.cljs$core$IIndexed$_nth$arity$2(null,i__11043_11087);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_11088)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,cljs.core.cst$kw$none)))))){
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = cljs.core.cst$kw$reload.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_11088),cljs.core.cst$kw$reload);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_11088),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_11088),cljs.core.cst$kw$reload_DASH_all);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_11088),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_11088,cljs.core.cst$sym$goog)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_11088),"');");
}

}
}
}


var G__11089 = seq__11040_11084;
var G__11090 = chunk__11041_11085;
var G__11091 = count__11042_11086;
var G__11092 = (i__11043_11087 + (1));
seq__11040_11084 = G__11089;
chunk__11041_11085 = G__11090;
count__11042_11086 = G__11091;
i__11043_11087 = G__11092;
continue;
} else {
var temp__5804__auto___11093 = cljs.core.seq(seq__11040_11084);
if(temp__5804__auto___11093){
var seq__11040_11094__$1 = temp__5804__auto___11093;
if(cljs.core.chunked_seq_QMARK_(seq__11040_11094__$1)){
var c__5567__auto___11095 = cljs.core.chunk_first(seq__11040_11094__$1);
var G__11096 = cljs.core.chunk_rest(seq__11040_11094__$1);
var G__11097 = c__5567__auto___11095;
var G__11098 = cljs.core.count(c__5567__auto___11095);
var G__11099 = (0);
seq__11040_11084 = G__11096;
chunk__11041_11085 = G__11097;
count__11042_11086 = G__11098;
i__11043_11087 = G__11099;
continue;
} else {
var lib_11100 = cljs.core.first(seq__11040_11094__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_11100)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,cljs.core.cst$kw$none)))))){
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = cljs.core.cst$kw$reload.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_11100),cljs.core.cst$kw$reload);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_11100),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_11100),cljs.core.cst$kw$reload_DASH_all);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_11100),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_11100,cljs.core.cst$sym$goog)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_11100),"');");
}

}
}
}


var G__11101 = cljs.core.next(seq__11040_11094__$1);
var G__11102 = null;
var G__11103 = (0);
var G__11104 = (0);
seq__11040_11084 = G__11101;
chunk__11041_11085 = G__11102;
count__11042_11086 = G__11103;
i__11043_11087 = G__11104;
continue;
}
} else {
}
}
break;
}

var seq__11044_11105 = cljs.core.seq(node_libs);
var chunk__11045_11106 = null;
var count__11046_11107 = (0);
var i__11047_11108 = (0);
while(true){
if((i__11047_11108 < count__11046_11107)){
var lib_11109 = chunk__11045_11106.cljs$core$IIndexed$_nth$arity$2(null,i__11047_11108);
var vec__11054_11110 = cljs.analyzer.lib_AMPERSAND_sublib(lib_11109);
var lib_SINGLEQUOTE__11111 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11054_11110,(0),null);
var sublib_11112 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11054_11110,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_11109)," = require('",lib_SINGLEQUOTE__11111,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_11112),";"], 0));


var G__11113 = seq__11044_11105;
var G__11114 = chunk__11045_11106;
var G__11115 = count__11046_11107;
var G__11116 = (i__11047_11108 + (1));
seq__11044_11105 = G__11113;
chunk__11045_11106 = G__11114;
count__11046_11107 = G__11115;
i__11047_11108 = G__11116;
continue;
} else {
var temp__5804__auto___11117 = cljs.core.seq(seq__11044_11105);
if(temp__5804__auto___11117){
var seq__11044_11118__$1 = temp__5804__auto___11117;
if(cljs.core.chunked_seq_QMARK_(seq__11044_11118__$1)){
var c__5567__auto___11119 = cljs.core.chunk_first(seq__11044_11118__$1);
var G__11120 = cljs.core.chunk_rest(seq__11044_11118__$1);
var G__11121 = c__5567__auto___11119;
var G__11122 = cljs.core.count(c__5567__auto___11119);
var G__11123 = (0);
seq__11044_11105 = G__11120;
chunk__11045_11106 = G__11121;
count__11046_11107 = G__11122;
i__11047_11108 = G__11123;
continue;
} else {
var lib_11124 = cljs.core.first(seq__11044_11118__$1);
var vec__11057_11125 = cljs.analyzer.lib_AMPERSAND_sublib(lib_11124);
var lib_SINGLEQUOTE__11126 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11057_11125,(0),null);
var sublib_11127 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11057_11125,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_11124)," = require('",lib_SINGLEQUOTE__11126,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_11127),";"], 0));


var G__11128 = cljs.core.next(seq__11044_11118__$1);
var G__11129 = null;
var G__11130 = (0);
var G__11131 = (0);
seq__11044_11105 = G__11128;
chunk__11045_11106 = G__11129;
count__11046_11107 = G__11130;
i__11047_11108 = G__11131;
continue;
}
} else {
}
}
break;
}

var seq__11060_11132 = cljs.core.seq(goog_modules);
var chunk__11061_11133 = null;
var count__11062_11134 = (0);
var i__11063_11135 = (0);
while(true){
if((i__11063_11135 < count__11062_11134)){
var lib_11136 = chunk__11061_11133.cljs$core$IIndexed$_nth$arity$2(null,i__11063_11135);
var vec__11070_11137 = cljs.analyzer.lib_AMPERSAND_sublib(lib_11136);
var lib_SINGLEQUOTE__11138 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11070_11137,(0),null);
var sublib_11139 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11070_11137,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",lib_SINGLEQUOTE__11138,"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.scope(function(){");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_goog_module_lib.cljs$core$IFn$_invoke$arity$1(lib_11136)," = goog.module.get('",lib_SINGLEQUOTE__11138,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_11139),";"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");


var G__11140 = seq__11060_11132;
var G__11141 = chunk__11061_11133;
var G__11142 = count__11062_11134;
var G__11143 = (i__11063_11135 + (1));
seq__11060_11132 = G__11140;
chunk__11061_11133 = G__11141;
count__11062_11134 = G__11142;
i__11063_11135 = G__11143;
continue;
} else {
var temp__5804__auto___11144 = cljs.core.seq(seq__11060_11132);
if(temp__5804__auto___11144){
var seq__11060_11145__$1 = temp__5804__auto___11144;
if(cljs.core.chunked_seq_QMARK_(seq__11060_11145__$1)){
var c__5567__auto___11146 = cljs.core.chunk_first(seq__11060_11145__$1);
var G__11147 = cljs.core.chunk_rest(seq__11060_11145__$1);
var G__11148 = c__5567__auto___11146;
var G__11149 = cljs.core.count(c__5567__auto___11146);
var G__11150 = (0);
seq__11060_11132 = G__11147;
chunk__11061_11133 = G__11148;
count__11062_11134 = G__11149;
i__11063_11135 = G__11150;
continue;
} else {
var lib_11151 = cljs.core.first(seq__11060_11145__$1);
var vec__11073_11152 = cljs.analyzer.lib_AMPERSAND_sublib(lib_11151);
var lib_SINGLEQUOTE__11153 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11073_11152,(0),null);
var sublib_11154 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11073_11152,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",lib_SINGLEQUOTE__11153,"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.scope(function(){");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_goog_module_lib.cljs$core$IFn$_invoke$arity$1(lib_11151)," = goog.module.get('",lib_SINGLEQUOTE__11153,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_11154),";"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");


var G__11155 = cljs.core.next(seq__11060_11145__$1);
var G__11156 = null;
var G__11157 = (0);
var G__11158 = (0);
seq__11060_11132 = G__11155;
chunk__11061_11133 = G__11156;
count__11062_11134 = G__11157;
i__11063_11135 = G__11158;
continue;
}
} else {
}
}
break;
}

var seq__11076_11159 = cljs.core.seq(global_exports_libs);
var chunk__11077_11160 = null;
var count__11078_11161 = (0);
var i__11079_11162 = (0);
while(true){
if((i__11079_11162 < count__11078_11161)){
var lib_11163 = chunk__11077_11160.cljs$core$IIndexed$_nth$arity$2(null,i__11079_11162);
var map__11082_11164 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_11163))));
var map__11082_11165__$1 = cljs.core.__destructure_map(map__11082_11164);
var global_exports_11166 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11082_11165__$1,cljs.core.cst$kw$global_DASH_exports);
cljs.compiler.emit_global_export(ns_name,global_exports_11166,lib_11163);


var G__11167 = seq__11076_11159;
var G__11168 = chunk__11077_11160;
var G__11169 = count__11078_11161;
var G__11170 = (i__11079_11162 + (1));
seq__11076_11159 = G__11167;
chunk__11077_11160 = G__11168;
count__11078_11161 = G__11169;
i__11079_11162 = G__11170;
continue;
} else {
var temp__5804__auto___11171 = cljs.core.seq(seq__11076_11159);
if(temp__5804__auto___11171){
var seq__11076_11172__$1 = temp__5804__auto___11171;
if(cljs.core.chunked_seq_QMARK_(seq__11076_11172__$1)){
var c__5567__auto___11173 = cljs.core.chunk_first(seq__11076_11172__$1);
var G__11174 = cljs.core.chunk_rest(seq__11076_11172__$1);
var G__11175 = c__5567__auto___11173;
var G__11176 = cljs.core.count(c__5567__auto___11173);
var G__11177 = (0);
seq__11076_11159 = G__11174;
chunk__11077_11160 = G__11175;
count__11078_11161 = G__11176;
i__11079_11162 = G__11177;
continue;
} else {
var lib_11178 = cljs.core.first(seq__11076_11172__$1);
var map__11083_11179 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_11178))));
var map__11083_11180__$1 = cljs.core.__destructure_map(map__11083_11179);
var global_exports_11181 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11083_11180__$1,cljs.core.cst$kw$global_DASH_exports);
cljs.compiler.emit_global_export(ns_name,global_exports_11181,lib_11178);


var G__11182 = cljs.core.next(seq__11076_11172__$1);
var G__11183 = null;
var G__11184 = (0);
var G__11185 = (0);
seq__11076_11159 = G__11182;
chunk__11077_11160 = G__11183;
count__11078_11161 = G__11184;
i__11079_11162 = G__11185;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$ns_STAR_,(function (p__11186){
var map__11187 = p__11186;
var map__11187__$1 = cljs.core.__destructure_map(map__11187);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11187__$1,cljs.core.cst$kw$name);
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11187__$1,cljs.core.cst$kw$requires);
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11187__$1,cljs.core.cst$kw$uses);
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11187__$1,cljs.core.cst$kw$require_DASH_macros);
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11187__$1,cljs.core.cst$kw$reloads);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11187__$1,cljs.core.cst$kw$env);
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11187__$1,cljs.core.cst$kw$deps);
cljs.compiler.load_libs(requires,null,cljs.core.cst$kw$require.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,cljs.core.cst$kw$use.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(cljs.core.cst$kw$repl_DASH_env.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$ns,(function (p__11188){
var map__11189 = p__11188;
var map__11189__$1 = cljs.core.__destructure_map(map__11189);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11189__$1,cljs.core.cst$kw$name);
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11189__$1,cljs.core.cst$kw$requires);
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11189__$1,cljs.core.cst$kw$uses);
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11189__$1,cljs.core.cst$kw$require_DASH_macros);
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11189__$1,cljs.core.cst$kw$reloads);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11189__$1,cljs.core.cst$kw$env);
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11189__$1,cljs.core.cst$kw$deps);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,cljs.core.cst$sym$cljs$core)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,cljs.core.cst$kw$require.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,cljs.core.cst$kw$use.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$deftype,(function (p__11190){
var map__11191 = p__11190;
var map__11191__$1 = cljs.core.__destructure_map(map__11191);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11191__$1,cljs.core.cst$kw$t);
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11191__$1,cljs.core.cst$kw$fields);
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11191__$1,cljs.core.cst$kw$pmasks);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11191__$1,cljs.core.cst$kw$body);
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11191__$1,cljs.core.cst$kw$protocols);
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__11192_11216 = cljs.core.seq(protocols);
var chunk__11193_11217 = null;
var count__11194_11218 = (0);
var i__11195_11219 = (0);
while(true){
if((i__11195_11219 < count__11194_11218)){
var protocol_11220 = chunk__11193_11217.cljs$core$IIndexed$_nth$arity$2(null,i__11195_11219);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_11220)),"}");


var G__11221 = seq__11192_11216;
var G__11222 = chunk__11193_11217;
var G__11223 = count__11194_11218;
var G__11224 = (i__11195_11219 + (1));
seq__11192_11216 = G__11221;
chunk__11193_11217 = G__11222;
count__11194_11218 = G__11223;
i__11195_11219 = G__11224;
continue;
} else {
var temp__5804__auto___11225 = cljs.core.seq(seq__11192_11216);
if(temp__5804__auto___11225){
var seq__11192_11226__$1 = temp__5804__auto___11225;
if(cljs.core.chunked_seq_QMARK_(seq__11192_11226__$1)){
var c__5567__auto___11227 = cljs.core.chunk_first(seq__11192_11226__$1);
var G__11228 = cljs.core.chunk_rest(seq__11192_11226__$1);
var G__11229 = c__5567__auto___11227;
var G__11230 = cljs.core.count(c__5567__auto___11227);
var G__11231 = (0);
seq__11192_11216 = G__11228;
chunk__11193_11217 = G__11229;
count__11194_11218 = G__11230;
i__11195_11219 = G__11231;
continue;
} else {
var protocol_11232 = cljs.core.first(seq__11192_11226__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_11232)),"}");


var G__11233 = cljs.core.next(seq__11192_11226__$1);
var G__11234 = null;
var G__11235 = (0);
var G__11236 = (0);
seq__11192_11216 = G__11233;
chunk__11193_11217 = G__11234;
count__11194_11218 = G__11235;
i__11195_11219 = G__11236;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__11196_11237 = cljs.core.seq(fields__$1);
var chunk__11197_11238 = null;
var count__11198_11239 = (0);
var i__11199_11240 = (0);
while(true){
if((i__11199_11240 < count__11198_11239)){
var fld_11241 = chunk__11197_11238.cljs$core$IIndexed$_nth$arity$2(null,i__11199_11240);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_11241," = ",fld_11241,";");


var G__11242 = seq__11196_11237;
var G__11243 = chunk__11197_11238;
var G__11244 = count__11198_11239;
var G__11245 = (i__11199_11240 + (1));
seq__11196_11237 = G__11242;
chunk__11197_11238 = G__11243;
count__11198_11239 = G__11244;
i__11199_11240 = G__11245;
continue;
} else {
var temp__5804__auto___11246 = cljs.core.seq(seq__11196_11237);
if(temp__5804__auto___11246){
var seq__11196_11247__$1 = temp__5804__auto___11246;
if(cljs.core.chunked_seq_QMARK_(seq__11196_11247__$1)){
var c__5567__auto___11248 = cljs.core.chunk_first(seq__11196_11247__$1);
var G__11249 = cljs.core.chunk_rest(seq__11196_11247__$1);
var G__11250 = c__5567__auto___11248;
var G__11251 = cljs.core.count(c__5567__auto___11248);
var G__11252 = (0);
seq__11196_11237 = G__11249;
chunk__11197_11238 = G__11250;
count__11198_11239 = G__11251;
i__11199_11240 = G__11252;
continue;
} else {
var fld_11253 = cljs.core.first(seq__11196_11247__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_11253," = ",fld_11253,";");


var G__11254 = cljs.core.next(seq__11196_11247__$1);
var G__11255 = null;
var G__11256 = (0);
var G__11257 = (0);
seq__11196_11237 = G__11254;
chunk__11197_11238 = G__11255;
count__11198_11239 = G__11256;
i__11199_11240 = G__11257;
continue;
}
} else {
}
}
break;
}

var seq__11200_11258 = cljs.core.seq(pmasks);
var chunk__11201_11259 = null;
var count__11202_11260 = (0);
var i__11203_11261 = (0);
while(true){
if((i__11203_11261 < count__11202_11260)){
var vec__11210_11262 = chunk__11201_11259.cljs$core$IIndexed$_nth$arity$2(null,i__11203_11261);
var pno_11263 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11210_11262,(0),null);
var pmask_11264 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11210_11262,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_11263,"$ = ",pmask_11264,";");


var G__11265 = seq__11200_11258;
var G__11266 = chunk__11201_11259;
var G__11267 = count__11202_11260;
var G__11268 = (i__11203_11261 + (1));
seq__11200_11258 = G__11265;
chunk__11201_11259 = G__11266;
count__11202_11260 = G__11267;
i__11203_11261 = G__11268;
continue;
} else {
var temp__5804__auto___11269 = cljs.core.seq(seq__11200_11258);
if(temp__5804__auto___11269){
var seq__11200_11270__$1 = temp__5804__auto___11269;
if(cljs.core.chunked_seq_QMARK_(seq__11200_11270__$1)){
var c__5567__auto___11271 = cljs.core.chunk_first(seq__11200_11270__$1);
var G__11272 = cljs.core.chunk_rest(seq__11200_11270__$1);
var G__11273 = c__5567__auto___11271;
var G__11274 = cljs.core.count(c__5567__auto___11271);
var G__11275 = (0);
seq__11200_11258 = G__11272;
chunk__11201_11259 = G__11273;
count__11202_11260 = G__11274;
i__11203_11261 = G__11275;
continue;
} else {
var vec__11213_11276 = cljs.core.first(seq__11200_11270__$1);
var pno_11277 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11213_11276,(0),null);
var pmask_11278 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11213_11276,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_11277,"$ = ",pmask_11278,";");


var G__11279 = cljs.core.next(seq__11200_11270__$1);
var G__11280 = null;
var G__11281 = (0);
var G__11282 = (0);
seq__11200_11258 = G__11279;
chunk__11201_11259 = G__11280;
count__11202_11260 = G__11281;
i__11203_11261 = G__11282;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$defrecord,(function (p__11283){
var map__11284 = p__11283;
var map__11284__$1 = cljs.core.__destructure_map(map__11284);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11284__$1,cljs.core.cst$kw$t);
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11284__$1,cljs.core.cst$kw$fields);
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11284__$1,cljs.core.cst$kw$pmasks);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11284__$1,cljs.core.cst$kw$body);
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11284__$1,cljs.core.cst$kw$protocols);
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$__meta,cljs.core.cst$sym$__extmap,cljs.core.cst$sym$__hash], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__11285_11309 = cljs.core.seq(protocols);
var chunk__11286_11310 = null;
var count__11287_11311 = (0);
var i__11288_11312 = (0);
while(true){
if((i__11288_11312 < count__11287_11311)){
var protocol_11313 = chunk__11286_11310.cljs$core$IIndexed$_nth$arity$2(null,i__11288_11312);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_11313)),"}");


var G__11314 = seq__11285_11309;
var G__11315 = chunk__11286_11310;
var G__11316 = count__11287_11311;
var G__11317 = (i__11288_11312 + (1));
seq__11285_11309 = G__11314;
chunk__11286_11310 = G__11315;
count__11287_11311 = G__11316;
i__11288_11312 = G__11317;
continue;
} else {
var temp__5804__auto___11318 = cljs.core.seq(seq__11285_11309);
if(temp__5804__auto___11318){
var seq__11285_11319__$1 = temp__5804__auto___11318;
if(cljs.core.chunked_seq_QMARK_(seq__11285_11319__$1)){
var c__5567__auto___11320 = cljs.core.chunk_first(seq__11285_11319__$1);
var G__11321 = cljs.core.chunk_rest(seq__11285_11319__$1);
var G__11322 = c__5567__auto___11320;
var G__11323 = cljs.core.count(c__5567__auto___11320);
var G__11324 = (0);
seq__11285_11309 = G__11321;
chunk__11286_11310 = G__11322;
count__11287_11311 = G__11323;
i__11288_11312 = G__11324;
continue;
} else {
var protocol_11325 = cljs.core.first(seq__11285_11319__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_11325)),"}");


var G__11326 = cljs.core.next(seq__11285_11319__$1);
var G__11327 = null;
var G__11328 = (0);
var G__11329 = (0);
seq__11285_11309 = G__11326;
chunk__11286_11310 = G__11327;
count__11287_11311 = G__11328;
i__11288_11312 = G__11329;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__11289_11330 = cljs.core.seq(fields__$1);
var chunk__11290_11331 = null;
var count__11291_11332 = (0);
var i__11292_11333 = (0);
while(true){
if((i__11292_11333 < count__11291_11332)){
var fld_11334 = chunk__11290_11331.cljs$core$IIndexed$_nth$arity$2(null,i__11292_11333);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_11334," = ",fld_11334,";");


var G__11335 = seq__11289_11330;
var G__11336 = chunk__11290_11331;
var G__11337 = count__11291_11332;
var G__11338 = (i__11292_11333 + (1));
seq__11289_11330 = G__11335;
chunk__11290_11331 = G__11336;
count__11291_11332 = G__11337;
i__11292_11333 = G__11338;
continue;
} else {
var temp__5804__auto___11339 = cljs.core.seq(seq__11289_11330);
if(temp__5804__auto___11339){
var seq__11289_11340__$1 = temp__5804__auto___11339;
if(cljs.core.chunked_seq_QMARK_(seq__11289_11340__$1)){
var c__5567__auto___11341 = cljs.core.chunk_first(seq__11289_11340__$1);
var G__11342 = cljs.core.chunk_rest(seq__11289_11340__$1);
var G__11343 = c__5567__auto___11341;
var G__11344 = cljs.core.count(c__5567__auto___11341);
var G__11345 = (0);
seq__11289_11330 = G__11342;
chunk__11290_11331 = G__11343;
count__11291_11332 = G__11344;
i__11292_11333 = G__11345;
continue;
} else {
var fld_11346 = cljs.core.first(seq__11289_11340__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_11346," = ",fld_11346,";");


var G__11347 = cljs.core.next(seq__11289_11340__$1);
var G__11348 = null;
var G__11349 = (0);
var G__11350 = (0);
seq__11289_11330 = G__11347;
chunk__11290_11331 = G__11348;
count__11291_11332 = G__11349;
i__11292_11333 = G__11350;
continue;
}
} else {
}
}
break;
}

var seq__11293_11351 = cljs.core.seq(pmasks);
var chunk__11294_11352 = null;
var count__11295_11353 = (0);
var i__11296_11354 = (0);
while(true){
if((i__11296_11354 < count__11295_11353)){
var vec__11303_11355 = chunk__11294_11352.cljs$core$IIndexed$_nth$arity$2(null,i__11296_11354);
var pno_11356 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11303_11355,(0),null);
var pmask_11357 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11303_11355,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_11356,"$ = ",pmask_11357,";");


var G__11358 = seq__11293_11351;
var G__11359 = chunk__11294_11352;
var G__11360 = count__11295_11353;
var G__11361 = (i__11296_11354 + (1));
seq__11293_11351 = G__11358;
chunk__11294_11352 = G__11359;
count__11295_11353 = G__11360;
i__11296_11354 = G__11361;
continue;
} else {
var temp__5804__auto___11362 = cljs.core.seq(seq__11293_11351);
if(temp__5804__auto___11362){
var seq__11293_11363__$1 = temp__5804__auto___11362;
if(cljs.core.chunked_seq_QMARK_(seq__11293_11363__$1)){
var c__5567__auto___11364 = cljs.core.chunk_first(seq__11293_11363__$1);
var G__11365 = cljs.core.chunk_rest(seq__11293_11363__$1);
var G__11366 = c__5567__auto___11364;
var G__11367 = cljs.core.count(c__5567__auto___11364);
var G__11368 = (0);
seq__11293_11351 = G__11365;
chunk__11294_11352 = G__11366;
count__11295_11353 = G__11367;
i__11296_11354 = G__11368;
continue;
} else {
var vec__11306_11369 = cljs.core.first(seq__11293_11363__$1);
var pno_11370 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11306_11369,(0),null);
var pmask_11371 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11306_11369,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_11370,"$ = ",pmask_11371,";");


var G__11372 = cljs.core.next(seq__11293_11363__$1);
var G__11373 = null;
var G__11374 = (0);
var G__11375 = (0);
seq__11293_11351 = G__11372;
chunk__11294_11352 = G__11373;
count__11295_11353 = G__11374;
i__11296_11354 = G__11375;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__11376){
var map__11377 = p__11376;
var map__11377__$1 = cljs.core.__destructure_map(map__11377);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11377__$1,cljs.core.cst$kw$target);
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11377__$1,cljs.core.cst$kw$field);
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11377__$1,cljs.core.cst$kw$method);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11377__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11377__$1,cljs.core.cst$kw$env);
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$host_DASH_field,(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$host_DASH_call,(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js,(function (p__11378){
var map__11379 = p__11378;
var map__11379__$1 = cljs.core.__destructure_map(map__11379);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11379__$1,cljs.core.cst$kw$op);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11379__$1,cljs.core.cst$kw$env);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11379__$1,cljs.core.cst$kw$code);
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11379__$1,cljs.core.cst$kw$segs);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11379__$1,cljs.core.cst$kw$args);
if(cljs.core.truth_((function (){var and__5043__auto__ = code;
if(cljs.core.truth_(and__5043__auto__)){
return goog.string.startsWith(clojure.string.trim(code),"/*");
} else {
return and__5043__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__9255__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9255__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__11384 = cljs.core.seq(table);
var chunk__11385 = null;
var count__11386 = (0);
var i__11387 = (0);
while(true){
if((i__11387 < count__11386)){
var vec__11394 = chunk__11385.cljs$core$IIndexed$_nth$arity$2(null,i__11387);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11394,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11394,(1),null);
var ns_11400 = cljs.core.namespace(sym);
var name_11401 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,cljs.core.cst$kw$invalid_DASH_constant_DASH_type,cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__11402 = seq__11384;
var G__11403 = chunk__11385;
var G__11404 = count__11386;
var G__11405 = (i__11387 + (1));
seq__11384 = G__11402;
chunk__11385 = G__11403;
count__11386 = G__11404;
i__11387 = G__11405;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__11384);
if(temp__5804__auto__){
var seq__11384__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11384__$1)){
var c__5567__auto__ = cljs.core.chunk_first(seq__11384__$1);
var G__11406 = cljs.core.chunk_rest(seq__11384__$1);
var G__11407 = c__5567__auto__;
var G__11408 = cljs.core.count(c__5567__auto__);
var G__11409 = (0);
seq__11384 = G__11406;
chunk__11385 = G__11407;
count__11386 = G__11408;
i__11387 = G__11409;
continue;
} else {
var vec__11397 = cljs.core.first(seq__11384__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11397,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11397,(1),null);
var ns_11410 = cljs.core.namespace(sym);
var name_11411 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,cljs.core.cst$kw$invalid_DASH_constant_DASH_type,cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__11412 = cljs.core.next(seq__11384__$1);
var G__11413 = null;
var G__11414 = (0);
var G__11415 = (0);
seq__11384 = G__11412;
chunk__11385 = G__11413;
count__11386 = G__11414;
i__11387 = G__11415;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__11417 = arguments.length;
switch (G__11417) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs():null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_11422 = cljs.core.first(ks);
var vec__11418_11423 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_11422);
var top_11424 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11418_11423,(0),null);
var prefix_SINGLEQUOTE__11425 = vec__11418_11423;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$prototype,k_11422)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__11425) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_11424)) || (cljs.core.contains_QMARK_(known_externs,top_11424)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__11425)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_11424);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__11425)),";");
}
} else {
}

var m_11426 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_11422);
if(cljs.core.empty_QMARK_(m_11426)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__11425,m_11426,top_level,known_externs);
}

var G__11427 = cljs.core.next(ks);
ks = G__11427;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

