// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
goog.scope(function(){
cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__15225 = arguments.length;
switch (G__15225) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async15226 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15226 = (function (f,blockable,meta15227){
this.f = f;
this.blockable = blockable;
this.meta15227 = meta15227;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async15226.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15228,meta15227__$1){
var self__ = this;
var _15228__$1 = this;
return (new cljs.core.async.t_cljs$core$async15226(self__.f,self__.blockable,meta15227__$1));
}));

(cljs.core.async.t_cljs$core$async15226.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15228){
var self__ = this;
var _15228__$1 = this;
return self__.meta15227;
}));

(cljs.core.async.t_cljs$core$async15226.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15226.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async15226.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async15226.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async15226.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta15227], null);
}));

(cljs.core.async.t_cljs$core$async15226.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async15226.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15226");

(cljs.core.async.t_cljs$core$async15226.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async15226");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async15226.
 */
cljs.core.async.__GT_t_cljs$core$async15226 = (function cljs$core$async$__GT_t_cljs$core$async15226(f__$1,blockable__$1,meta15227){
return (new cljs.core.async.t_cljs$core$async15226(f__$1,blockable__$1,meta15227));
});

}

return (new cljs.core.async.t_cljs$core$async15226(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__15232 = arguments.length;
switch (G__15232) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__15235 = arguments.length;
switch (G__15235) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__15238 = arguments.length;
switch (G__15238) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_15240 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_15240) : fn1.call(null,val_15240));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_15240) : fn1.call(null,val_15240));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__15242 = arguments.length;
switch (G__15242) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5635__auto___15244 = n;
var x_15245 = (0);
while(true){
if((x_15245 < n__5635__auto___15244)){
(a[x_15245] = x_15245);

var G__15246 = (x_15245 + (1));
x_15245 = G__15246;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle.call(null,a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async15247 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15247 = (function (flag,meta15248){
this.flag = flag;
this.meta15248 = meta15248;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async15247.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15249,meta15248__$1){
var self__ = this;
var _15249__$1 = this;
return (new cljs.core.async.t_cljs$core$async15247(self__.flag,meta15248__$1));
}));

(cljs.core.async.t_cljs$core$async15247.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15249){
var self__ = this;
var _15249__$1 = this;
return self__.meta15248;
}));

(cljs.core.async.t_cljs$core$async15247.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15247.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async15247.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async15247.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async15247.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta15248], null);
}));

(cljs.core.async.t_cljs$core$async15247.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async15247.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15247");

(cljs.core.async.t_cljs$core$async15247.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async15247");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async15247.
 */
cljs.core.async.__GT_t_cljs$core$async15247 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async15247(flag__$1,meta15248){
return (new cljs.core.async.t_cljs$core$async15247(flag__$1,meta15248));
});

}

return (new cljs.core.async.t_cljs$core$async15247(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async15250 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15250 = (function (flag,cb,meta15251){
this.flag = flag;
this.cb = cb;
this.meta15251 = meta15251;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async15250.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15252,meta15251__$1){
var self__ = this;
var _15252__$1 = this;
return (new cljs.core.async.t_cljs$core$async15250(self__.flag,self__.cb,meta15251__$1));
}));

(cljs.core.async.t_cljs$core$async15250.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15252){
var self__ = this;
var _15252__$1 = this;
return self__.meta15251;
}));

(cljs.core.async.t_cljs$core$async15250.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15250.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async15250.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async15250.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async15250.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta15251], null);
}));

(cljs.core.async.t_cljs$core$async15250.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async15250.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15250");

(cljs.core.async.t_cljs$core$async15250.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async15250");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async15250.
 */
cljs.core.async.__GT_t_cljs$core$async15250 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async15250(flag__$1,cb__$1,meta15251){
return (new cljs.core.async.t_cljs$core$async15250(flag__$1,cb__$1,meta15251));
});

}

return (new cljs.core.async.t_cljs$core$async15250(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__15253_SHARP_){
var G__15255 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__15253_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__15255) : fret.call(null,G__15255));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__15254_SHARP_){
var G__15256 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__15254_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__15256) : fret.call(null,G__15256));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5045__auto__ = wport;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return port;
}
})()], null));
} else {
var G__15257 = (i + (1));
i = G__15257;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5045__auto__ = ret;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5804__auto__ = (function (){var and__5043__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__5043__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___15262 = arguments.length;
var i__5769__auto___15263 = (0);
while(true){
if((i__5769__auto___15263 < len__5768__auto___15262)){
args__5774__auto__.push((arguments[i__5769__auto___15263]));

var G__15264 = (i__5769__auto___15263 + (1));
i__5769__auto___15263 = G__15264;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__15260){
var map__15261 = p__15260;
var map__15261__$1 = cljs.core.__destructure_map(map__15261);
var opts = map__15261__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq15258){
var G__15259 = cljs.core.first(seq15258);
var seq15258__$1 = cljs.core.next(seq15258);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15259,seq15258__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__15266 = arguments.length;
switch (G__15266) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__15165__auto___15313 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_15290){
var state_val_15291 = (state_15290[(1)]);
if((state_val_15291 === (7))){
var inst_15286 = (state_15290[(2)]);
var state_15290__$1 = state_15290;
var statearr_15292_15314 = state_15290__$1;
(statearr_15292_15314[(2)] = inst_15286);

(statearr_15292_15314[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15291 === (1))){
var state_15290__$1 = state_15290;
var statearr_15293_15315 = state_15290__$1;
(statearr_15293_15315[(2)] = null);

(statearr_15293_15315[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15291 === (4))){
var inst_15269 = (state_15290[(7)]);
var inst_15269__$1 = (state_15290[(2)]);
var inst_15270 = (inst_15269__$1 == null);
var state_15290__$1 = (function (){var statearr_15294 = state_15290;
(statearr_15294[(7)] = inst_15269__$1);

return statearr_15294;
})();
if(cljs.core.truth_(inst_15270)){
var statearr_15295_15316 = state_15290__$1;
(statearr_15295_15316[(1)] = (5));

} else {
var statearr_15296_15317 = state_15290__$1;
(statearr_15296_15317[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15291 === (13))){
var state_15290__$1 = state_15290;
var statearr_15297_15318 = state_15290__$1;
(statearr_15297_15318[(2)] = null);

(statearr_15297_15318[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15291 === (6))){
var inst_15269 = (state_15290[(7)]);
var state_15290__$1 = state_15290;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15290__$1,(11),to,inst_15269);
} else {
if((state_val_15291 === (3))){
var inst_15288 = (state_15290[(2)]);
var state_15290__$1 = state_15290;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15290__$1,inst_15288);
} else {
if((state_val_15291 === (12))){
var state_15290__$1 = state_15290;
var statearr_15298_15319 = state_15290__$1;
(statearr_15298_15319[(2)] = null);

(statearr_15298_15319[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15291 === (2))){
var state_15290__$1 = state_15290;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15290__$1,(4),from);
} else {
if((state_val_15291 === (11))){
var inst_15279 = (state_15290[(2)]);
var state_15290__$1 = state_15290;
if(cljs.core.truth_(inst_15279)){
var statearr_15299_15320 = state_15290__$1;
(statearr_15299_15320[(1)] = (12));

} else {
var statearr_15300_15321 = state_15290__$1;
(statearr_15300_15321[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15291 === (9))){
var state_15290__$1 = state_15290;
var statearr_15301_15322 = state_15290__$1;
(statearr_15301_15322[(2)] = null);

(statearr_15301_15322[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15291 === (5))){
var state_15290__$1 = state_15290;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15302_15323 = state_15290__$1;
(statearr_15302_15323[(1)] = (8));

} else {
var statearr_15303_15324 = state_15290__$1;
(statearr_15303_15324[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15291 === (14))){
var inst_15284 = (state_15290[(2)]);
var state_15290__$1 = state_15290;
var statearr_15304_15325 = state_15290__$1;
(statearr_15304_15325[(2)] = inst_15284);

(statearr_15304_15325[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15291 === (10))){
var inst_15276 = (state_15290[(2)]);
var state_15290__$1 = state_15290;
var statearr_15305_15326 = state_15290__$1;
(statearr_15305_15326[(2)] = inst_15276);

(statearr_15305_15326[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15291 === (8))){
var inst_15273 = cljs.core.async.close_BANG_(to);
var state_15290__$1 = state_15290;
var statearr_15306_15327 = state_15290__$1;
(statearr_15306_15327[(2)] = inst_15273);

(statearr_15306_15327[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__15091__auto__ = null;
var cljs$core$async$state_machine__15091__auto____0 = (function (){
var statearr_15307 = [null,null,null,null,null,null,null,null];
(statearr_15307[(0)] = cljs$core$async$state_machine__15091__auto__);

(statearr_15307[(1)] = (1));

return statearr_15307;
});
var cljs$core$async$state_machine__15091__auto____1 = (function (state_15290){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_15290);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e15308){var ex__15094__auto__ = e15308;
var statearr_15309_15328 = state_15290;
(statearr_15309_15328[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_15290[(4)]))){
var statearr_15310_15329 = state_15290;
(statearr_15310_15329[(1)] = cljs.core.first((state_15290[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__15330 = state_15290;
state_15290 = G__15330;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
cljs$core$async$state_machine__15091__auto__ = function(state_15290){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__15091__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__15091__auto____1.call(this,state_15290);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__15091__auto____0;
cljs$core$async$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__15091__auto____1;
return cljs$core$async$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_15311 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_15311[(6)] = c__15165__auto___15313);

return statearr_15311;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__15331){
var vec__15332 = p__15331;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15332,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15332,(1),null);
var job = vec__15332;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__15165__auto___15508 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_15339){
var state_val_15340 = (state_15339[(1)]);
if((state_val_15340 === (1))){
var state_15339__$1 = state_15339;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15339__$1,(2),res,v);
} else {
if((state_val_15340 === (2))){
var inst_15336 = (state_15339[(2)]);
var inst_15337 = cljs.core.async.close_BANG_(res);
var state_15339__$1 = (function (){var statearr_15341 = state_15339;
(statearr_15341[(7)] = inst_15336);

return statearr_15341;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_15339__$1,inst_15337);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____0 = (function (){
var statearr_15342 = [null,null,null,null,null,null,null,null];
(statearr_15342[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__);

(statearr_15342[(1)] = (1));

return statearr_15342;
});
var cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____1 = (function (state_15339){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_15339);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e15343){var ex__15094__auto__ = e15343;
var statearr_15344_15509 = state_15339;
(statearr_15344_15509[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_15339[(4)]))){
var statearr_15345_15510 = state_15339;
(statearr_15345_15510[(1)] = cljs.core.first((state_15339[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__15511 = state_15339;
state_15339 = G__15511;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__ = function(state_15339){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____1.call(this,state_15339);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_15346 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_15346[(6)] = c__15165__auto___15508);

return statearr_15346;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__15347){
var vec__15348 = p__15347;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15348,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15348,(1),null);
var job = vec__15348;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5635__auto___15512 = n;
var __15513 = (0);
while(true){
if((__15513 < n__5635__auto___15512)){
var G__15351_15514 = type;
var G__15351_15515__$1 = (((G__15351_15514 instanceof cljs.core.Keyword))?G__15351_15514.fqn:null);
switch (G__15351_15515__$1) {
case "compute":
var c__15165__auto___15517 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__15513,c__15165__auto___15517,G__15351_15514,G__15351_15515__$1,n__5635__auto___15512,jobs,results,process__$1,async){
return (function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = ((function (__15513,c__15165__auto___15517,G__15351_15514,G__15351_15515__$1,n__5635__auto___15512,jobs,results,process__$1,async){
return (function (state_15364){
var state_val_15365 = (state_15364[(1)]);
if((state_val_15365 === (1))){
var state_15364__$1 = state_15364;
var statearr_15366_15518 = state_15364__$1;
(statearr_15366_15518[(2)] = null);

(statearr_15366_15518[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15365 === (2))){
var state_15364__$1 = state_15364;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15364__$1,(4),jobs);
} else {
if((state_val_15365 === (3))){
var inst_15362 = (state_15364[(2)]);
var state_15364__$1 = state_15364;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15364__$1,inst_15362);
} else {
if((state_val_15365 === (4))){
var inst_15354 = (state_15364[(2)]);
var inst_15355 = process__$1(inst_15354);
var state_15364__$1 = state_15364;
if(cljs.core.truth_(inst_15355)){
var statearr_15367_15519 = state_15364__$1;
(statearr_15367_15519[(1)] = (5));

} else {
var statearr_15368_15520 = state_15364__$1;
(statearr_15368_15520[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15365 === (5))){
var state_15364__$1 = state_15364;
var statearr_15369_15521 = state_15364__$1;
(statearr_15369_15521[(2)] = null);

(statearr_15369_15521[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15365 === (6))){
var state_15364__$1 = state_15364;
var statearr_15370_15522 = state_15364__$1;
(statearr_15370_15522[(2)] = null);

(statearr_15370_15522[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15365 === (7))){
var inst_15360 = (state_15364[(2)]);
var state_15364__$1 = state_15364;
var statearr_15371_15523 = state_15364__$1;
(statearr_15371_15523[(2)] = inst_15360);

(statearr_15371_15523[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__15513,c__15165__auto___15517,G__15351_15514,G__15351_15515__$1,n__5635__auto___15512,jobs,results,process__$1,async))
;
return ((function (__15513,switch__15090__auto__,c__15165__auto___15517,G__15351_15514,G__15351_15515__$1,n__5635__auto___15512,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____0 = (function (){
var statearr_15372 = [null,null,null,null,null,null,null];
(statearr_15372[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__);

(statearr_15372[(1)] = (1));

return statearr_15372;
});
var cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____1 = (function (state_15364){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_15364);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e15373){var ex__15094__auto__ = e15373;
var statearr_15374_15524 = state_15364;
(statearr_15374_15524[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_15364[(4)]))){
var statearr_15375_15525 = state_15364;
(statearr_15375_15525[(1)] = cljs.core.first((state_15364[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__15526 = state_15364;
state_15364 = G__15526;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__ = function(state_15364){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____1.call(this,state_15364);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__;
})()
;})(__15513,switch__15090__auto__,c__15165__auto___15517,G__15351_15514,G__15351_15515__$1,n__5635__auto___15512,jobs,results,process__$1,async))
})();
var state__15167__auto__ = (function (){var statearr_15376 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_15376[(6)] = c__15165__auto___15517);

return statearr_15376;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
});})(__15513,c__15165__auto___15517,G__15351_15514,G__15351_15515__$1,n__5635__auto___15512,jobs,results,process__$1,async))
);


break;
case "async":
var c__15165__auto___15527 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__15513,c__15165__auto___15527,G__15351_15514,G__15351_15515__$1,n__5635__auto___15512,jobs,results,process__$1,async){
return (function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = ((function (__15513,c__15165__auto___15527,G__15351_15514,G__15351_15515__$1,n__5635__auto___15512,jobs,results,process__$1,async){
return (function (state_15389){
var state_val_15390 = (state_15389[(1)]);
if((state_val_15390 === (1))){
var state_15389__$1 = state_15389;
var statearr_15391_15528 = state_15389__$1;
(statearr_15391_15528[(2)] = null);

(statearr_15391_15528[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15390 === (2))){
var state_15389__$1 = state_15389;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15389__$1,(4),jobs);
} else {
if((state_val_15390 === (3))){
var inst_15387 = (state_15389[(2)]);
var state_15389__$1 = state_15389;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15389__$1,inst_15387);
} else {
if((state_val_15390 === (4))){
var inst_15379 = (state_15389[(2)]);
var inst_15380 = async(inst_15379);
var state_15389__$1 = state_15389;
if(cljs.core.truth_(inst_15380)){
var statearr_15392_15529 = state_15389__$1;
(statearr_15392_15529[(1)] = (5));

} else {
var statearr_15393_15530 = state_15389__$1;
(statearr_15393_15530[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15390 === (5))){
var state_15389__$1 = state_15389;
var statearr_15394_15531 = state_15389__$1;
(statearr_15394_15531[(2)] = null);

(statearr_15394_15531[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15390 === (6))){
var state_15389__$1 = state_15389;
var statearr_15395_15532 = state_15389__$1;
(statearr_15395_15532[(2)] = null);

(statearr_15395_15532[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15390 === (7))){
var inst_15385 = (state_15389[(2)]);
var state_15389__$1 = state_15389;
var statearr_15396_15533 = state_15389__$1;
(statearr_15396_15533[(2)] = inst_15385);

(statearr_15396_15533[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__15513,c__15165__auto___15527,G__15351_15514,G__15351_15515__$1,n__5635__auto___15512,jobs,results,process__$1,async))
;
return ((function (__15513,switch__15090__auto__,c__15165__auto___15527,G__15351_15514,G__15351_15515__$1,n__5635__auto___15512,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____0 = (function (){
var statearr_15397 = [null,null,null,null,null,null,null];
(statearr_15397[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__);

(statearr_15397[(1)] = (1));

return statearr_15397;
});
var cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____1 = (function (state_15389){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_15389);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e15398){var ex__15094__auto__ = e15398;
var statearr_15399_15534 = state_15389;
(statearr_15399_15534[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_15389[(4)]))){
var statearr_15400_15535 = state_15389;
(statearr_15400_15535[(1)] = cljs.core.first((state_15389[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__15536 = state_15389;
state_15389 = G__15536;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__ = function(state_15389){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____1.call(this,state_15389);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__;
})()
;})(__15513,switch__15090__auto__,c__15165__auto___15527,G__15351_15514,G__15351_15515__$1,n__5635__auto___15512,jobs,results,process__$1,async))
})();
var state__15167__auto__ = (function (){var statearr_15401 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_15401[(6)] = c__15165__auto___15527);

return statearr_15401;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
});})(__15513,c__15165__auto___15527,G__15351_15514,G__15351_15515__$1,n__5635__auto___15512,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__15351_15515__$1)].join('')));

}

var G__15537 = (__15513 + (1));
__15513 = G__15537;
continue;
} else {
}
break;
}

var c__15165__auto___15538 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_15423){
var state_val_15424 = (state_15423[(1)]);
if((state_val_15424 === (7))){
var inst_15419 = (state_15423[(2)]);
var state_15423__$1 = state_15423;
var statearr_15425_15539 = state_15423__$1;
(statearr_15425_15539[(2)] = inst_15419);

(statearr_15425_15539[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15424 === (1))){
var state_15423__$1 = state_15423;
var statearr_15426_15540 = state_15423__$1;
(statearr_15426_15540[(2)] = null);

(statearr_15426_15540[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15424 === (4))){
var inst_15404 = (state_15423[(7)]);
var inst_15404__$1 = (state_15423[(2)]);
var inst_15405 = (inst_15404__$1 == null);
var state_15423__$1 = (function (){var statearr_15427 = state_15423;
(statearr_15427[(7)] = inst_15404__$1);

return statearr_15427;
})();
if(cljs.core.truth_(inst_15405)){
var statearr_15428_15541 = state_15423__$1;
(statearr_15428_15541[(1)] = (5));

} else {
var statearr_15429_15542 = state_15423__$1;
(statearr_15429_15542[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15424 === (6))){
var inst_15409 = (state_15423[(8)]);
var inst_15404 = (state_15423[(7)]);
var inst_15409__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_15410 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15411 = [inst_15404,inst_15409__$1];
var inst_15412 = (new cljs.core.PersistentVector(null,2,(5),inst_15410,inst_15411,null));
var state_15423__$1 = (function (){var statearr_15430 = state_15423;
(statearr_15430[(8)] = inst_15409__$1);

return statearr_15430;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15423__$1,(8),jobs,inst_15412);
} else {
if((state_val_15424 === (3))){
var inst_15421 = (state_15423[(2)]);
var state_15423__$1 = state_15423;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15423__$1,inst_15421);
} else {
if((state_val_15424 === (2))){
var state_15423__$1 = state_15423;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15423__$1,(4),from);
} else {
if((state_val_15424 === (9))){
var inst_15416 = (state_15423[(2)]);
var state_15423__$1 = (function (){var statearr_15431 = state_15423;
(statearr_15431[(9)] = inst_15416);

return statearr_15431;
})();
var statearr_15432_15543 = state_15423__$1;
(statearr_15432_15543[(2)] = null);

(statearr_15432_15543[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15424 === (5))){
var inst_15407 = cljs.core.async.close_BANG_(jobs);
var state_15423__$1 = state_15423;
var statearr_15433_15544 = state_15423__$1;
(statearr_15433_15544[(2)] = inst_15407);

(statearr_15433_15544[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15424 === (8))){
var inst_15409 = (state_15423[(8)]);
var inst_15414 = (state_15423[(2)]);
var state_15423__$1 = (function (){var statearr_15434 = state_15423;
(statearr_15434[(10)] = inst_15414);

return statearr_15434;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15423__$1,(9),results,inst_15409);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____0 = (function (){
var statearr_15435 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_15435[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__);

(statearr_15435[(1)] = (1));

return statearr_15435;
});
var cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____1 = (function (state_15423){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_15423);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e15436){var ex__15094__auto__ = e15436;
var statearr_15437_15545 = state_15423;
(statearr_15437_15545[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_15423[(4)]))){
var statearr_15438_15546 = state_15423;
(statearr_15438_15546[(1)] = cljs.core.first((state_15423[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__15547 = state_15423;
state_15423 = G__15547;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__ = function(state_15423){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____1.call(this,state_15423);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_15439 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_15439[(6)] = c__15165__auto___15538);

return statearr_15439;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));


var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_15477){
var state_val_15478 = (state_15477[(1)]);
if((state_val_15478 === (7))){
var inst_15473 = (state_15477[(2)]);
var state_15477__$1 = state_15477;
var statearr_15479_15548 = state_15477__$1;
(statearr_15479_15548[(2)] = inst_15473);

(statearr_15479_15548[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15478 === (20))){
var state_15477__$1 = state_15477;
var statearr_15480_15549 = state_15477__$1;
(statearr_15480_15549[(2)] = null);

(statearr_15480_15549[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15478 === (1))){
var state_15477__$1 = state_15477;
var statearr_15481_15550 = state_15477__$1;
(statearr_15481_15550[(2)] = null);

(statearr_15481_15550[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15478 === (4))){
var inst_15442 = (state_15477[(7)]);
var inst_15442__$1 = (state_15477[(2)]);
var inst_15443 = (inst_15442__$1 == null);
var state_15477__$1 = (function (){var statearr_15482 = state_15477;
(statearr_15482[(7)] = inst_15442__$1);

return statearr_15482;
})();
if(cljs.core.truth_(inst_15443)){
var statearr_15483_15551 = state_15477__$1;
(statearr_15483_15551[(1)] = (5));

} else {
var statearr_15484_15552 = state_15477__$1;
(statearr_15484_15552[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15478 === (15))){
var inst_15455 = (state_15477[(8)]);
var state_15477__$1 = state_15477;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15477__$1,(18),to,inst_15455);
} else {
if((state_val_15478 === (21))){
var inst_15468 = (state_15477[(2)]);
var state_15477__$1 = state_15477;
var statearr_15485_15553 = state_15477__$1;
(statearr_15485_15553[(2)] = inst_15468);

(statearr_15485_15553[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15478 === (13))){
var inst_15470 = (state_15477[(2)]);
var state_15477__$1 = (function (){var statearr_15486 = state_15477;
(statearr_15486[(9)] = inst_15470);

return statearr_15486;
})();
var statearr_15487_15554 = state_15477__$1;
(statearr_15487_15554[(2)] = null);

(statearr_15487_15554[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15478 === (6))){
var inst_15442 = (state_15477[(7)]);
var state_15477__$1 = state_15477;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15477__$1,(11),inst_15442);
} else {
if((state_val_15478 === (17))){
var inst_15463 = (state_15477[(2)]);
var state_15477__$1 = state_15477;
if(cljs.core.truth_(inst_15463)){
var statearr_15488_15555 = state_15477__$1;
(statearr_15488_15555[(1)] = (19));

} else {
var statearr_15489_15556 = state_15477__$1;
(statearr_15489_15556[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15478 === (3))){
var inst_15475 = (state_15477[(2)]);
var state_15477__$1 = state_15477;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15477__$1,inst_15475);
} else {
if((state_val_15478 === (12))){
var inst_15452 = (state_15477[(10)]);
var state_15477__$1 = state_15477;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15477__$1,(14),inst_15452);
} else {
if((state_val_15478 === (2))){
var state_15477__$1 = state_15477;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15477__$1,(4),results);
} else {
if((state_val_15478 === (19))){
var state_15477__$1 = state_15477;
var statearr_15490_15557 = state_15477__$1;
(statearr_15490_15557[(2)] = null);

(statearr_15490_15557[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15478 === (11))){
var inst_15452 = (state_15477[(2)]);
var state_15477__$1 = (function (){var statearr_15491 = state_15477;
(statearr_15491[(10)] = inst_15452);

return statearr_15491;
})();
var statearr_15492_15558 = state_15477__$1;
(statearr_15492_15558[(2)] = null);

(statearr_15492_15558[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15478 === (9))){
var state_15477__$1 = state_15477;
var statearr_15493_15559 = state_15477__$1;
(statearr_15493_15559[(2)] = null);

(statearr_15493_15559[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15478 === (5))){
var state_15477__$1 = state_15477;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15494_15560 = state_15477__$1;
(statearr_15494_15560[(1)] = (8));

} else {
var statearr_15495_15561 = state_15477__$1;
(statearr_15495_15561[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15478 === (14))){
var inst_15457 = (state_15477[(11)]);
var inst_15455 = (state_15477[(8)]);
var inst_15455__$1 = (state_15477[(2)]);
var inst_15456 = (inst_15455__$1 == null);
var inst_15457__$1 = cljs.core.not(inst_15456);
var state_15477__$1 = (function (){var statearr_15496 = state_15477;
(statearr_15496[(11)] = inst_15457__$1);

(statearr_15496[(8)] = inst_15455__$1);

return statearr_15496;
})();
if(inst_15457__$1){
var statearr_15497_15562 = state_15477__$1;
(statearr_15497_15562[(1)] = (15));

} else {
var statearr_15498_15563 = state_15477__$1;
(statearr_15498_15563[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15478 === (16))){
var inst_15457 = (state_15477[(11)]);
var state_15477__$1 = state_15477;
var statearr_15499_15564 = state_15477__$1;
(statearr_15499_15564[(2)] = inst_15457);

(statearr_15499_15564[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15478 === (10))){
var inst_15449 = (state_15477[(2)]);
var state_15477__$1 = state_15477;
var statearr_15500_15565 = state_15477__$1;
(statearr_15500_15565[(2)] = inst_15449);

(statearr_15500_15565[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15478 === (18))){
var inst_15460 = (state_15477[(2)]);
var state_15477__$1 = state_15477;
var statearr_15501_15566 = state_15477__$1;
(statearr_15501_15566[(2)] = inst_15460);

(statearr_15501_15566[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15478 === (8))){
var inst_15446 = cljs.core.async.close_BANG_(to);
var state_15477__$1 = state_15477;
var statearr_15502_15567 = state_15477__$1;
(statearr_15502_15567[(2)] = inst_15446);

(statearr_15502_15567[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____0 = (function (){
var statearr_15503 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15503[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__);

(statearr_15503[(1)] = (1));

return statearr_15503;
});
var cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____1 = (function (state_15477){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_15477);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e15504){var ex__15094__auto__ = e15504;
var statearr_15505_15568 = state_15477;
(statearr_15505_15568[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_15477[(4)]))){
var statearr_15506_15569 = state_15477;
(statearr_15506_15569[(1)] = cljs.core.first((state_15477[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__15570 = state_15477;
state_15477 = G__15570;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__ = function(state_15477){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____1.call(this,state_15477);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__15091__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_15507 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_15507[(6)] = c__15165__auto__);

return statearr_15507;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__15572 = arguments.length;
switch (G__15572) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__15575 = arguments.length;
switch (G__15575) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__15578 = arguments.length;
switch (G__15578) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__15165__auto___15628 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_15604){
var state_val_15605 = (state_15604[(1)]);
if((state_val_15605 === (7))){
var inst_15600 = (state_15604[(2)]);
var state_15604__$1 = state_15604;
var statearr_15606_15629 = state_15604__$1;
(statearr_15606_15629[(2)] = inst_15600);

(statearr_15606_15629[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15605 === (1))){
var state_15604__$1 = state_15604;
var statearr_15607_15630 = state_15604__$1;
(statearr_15607_15630[(2)] = null);

(statearr_15607_15630[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15605 === (4))){
var inst_15581 = (state_15604[(7)]);
var inst_15581__$1 = (state_15604[(2)]);
var inst_15582 = (inst_15581__$1 == null);
var state_15604__$1 = (function (){var statearr_15608 = state_15604;
(statearr_15608[(7)] = inst_15581__$1);

return statearr_15608;
})();
if(cljs.core.truth_(inst_15582)){
var statearr_15609_15631 = state_15604__$1;
(statearr_15609_15631[(1)] = (5));

} else {
var statearr_15610_15632 = state_15604__$1;
(statearr_15610_15632[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15605 === (13))){
var state_15604__$1 = state_15604;
var statearr_15611_15633 = state_15604__$1;
(statearr_15611_15633[(2)] = null);

(statearr_15611_15633[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15605 === (6))){
var inst_15581 = (state_15604[(7)]);
var inst_15587 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_15581) : p.call(null,inst_15581));
var state_15604__$1 = state_15604;
if(cljs.core.truth_(inst_15587)){
var statearr_15612_15634 = state_15604__$1;
(statearr_15612_15634[(1)] = (9));

} else {
var statearr_15613_15635 = state_15604__$1;
(statearr_15613_15635[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15605 === (3))){
var inst_15602 = (state_15604[(2)]);
var state_15604__$1 = state_15604;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15604__$1,inst_15602);
} else {
if((state_val_15605 === (12))){
var state_15604__$1 = state_15604;
var statearr_15614_15636 = state_15604__$1;
(statearr_15614_15636[(2)] = null);

(statearr_15614_15636[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15605 === (2))){
var state_15604__$1 = state_15604;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15604__$1,(4),ch);
} else {
if((state_val_15605 === (11))){
var inst_15581 = (state_15604[(7)]);
var inst_15591 = (state_15604[(2)]);
var state_15604__$1 = state_15604;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15604__$1,(8),inst_15591,inst_15581);
} else {
if((state_val_15605 === (9))){
var state_15604__$1 = state_15604;
var statearr_15615_15637 = state_15604__$1;
(statearr_15615_15637[(2)] = tc);

(statearr_15615_15637[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15605 === (5))){
var inst_15584 = cljs.core.async.close_BANG_(tc);
var inst_15585 = cljs.core.async.close_BANG_(fc);
var state_15604__$1 = (function (){var statearr_15616 = state_15604;
(statearr_15616[(8)] = inst_15584);

return statearr_15616;
})();
var statearr_15617_15638 = state_15604__$1;
(statearr_15617_15638[(2)] = inst_15585);

(statearr_15617_15638[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15605 === (14))){
var inst_15598 = (state_15604[(2)]);
var state_15604__$1 = state_15604;
var statearr_15618_15639 = state_15604__$1;
(statearr_15618_15639[(2)] = inst_15598);

(statearr_15618_15639[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15605 === (10))){
var state_15604__$1 = state_15604;
var statearr_15619_15640 = state_15604__$1;
(statearr_15619_15640[(2)] = fc);

(statearr_15619_15640[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15605 === (8))){
var inst_15593 = (state_15604[(2)]);
var state_15604__$1 = state_15604;
if(cljs.core.truth_(inst_15593)){
var statearr_15620_15641 = state_15604__$1;
(statearr_15620_15641[(1)] = (12));

} else {
var statearr_15621_15642 = state_15604__$1;
(statearr_15621_15642[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__15091__auto__ = null;
var cljs$core$async$state_machine__15091__auto____0 = (function (){
var statearr_15622 = [null,null,null,null,null,null,null,null,null];
(statearr_15622[(0)] = cljs$core$async$state_machine__15091__auto__);

(statearr_15622[(1)] = (1));

return statearr_15622;
});
var cljs$core$async$state_machine__15091__auto____1 = (function (state_15604){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_15604);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e15623){var ex__15094__auto__ = e15623;
var statearr_15624_15643 = state_15604;
(statearr_15624_15643[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_15604[(4)]))){
var statearr_15625_15644 = state_15604;
(statearr_15625_15644[(1)] = cljs.core.first((state_15604[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__15645 = state_15604;
state_15604 = G__15645;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
cljs$core$async$state_machine__15091__auto__ = function(state_15604){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__15091__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__15091__auto____1.call(this,state_15604);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__15091__auto____0;
cljs$core$async$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__15091__auto____1;
return cljs$core$async$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_15626 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_15626[(6)] = c__15165__auto___15628);

return statearr_15626;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_15667){
var state_val_15668 = (state_15667[(1)]);
if((state_val_15668 === (7))){
var inst_15663 = (state_15667[(2)]);
var state_15667__$1 = state_15667;
var statearr_15669_15688 = state_15667__$1;
(statearr_15669_15688[(2)] = inst_15663);

(statearr_15669_15688[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15668 === (1))){
var inst_15646 = init;
var inst_15647 = inst_15646;
var state_15667__$1 = (function (){var statearr_15670 = state_15667;
(statearr_15670[(7)] = inst_15647);

return statearr_15670;
})();
var statearr_15671_15689 = state_15667__$1;
(statearr_15671_15689[(2)] = null);

(statearr_15671_15689[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15668 === (4))){
var inst_15650 = (state_15667[(8)]);
var inst_15650__$1 = (state_15667[(2)]);
var inst_15651 = (inst_15650__$1 == null);
var state_15667__$1 = (function (){var statearr_15672 = state_15667;
(statearr_15672[(8)] = inst_15650__$1);

return statearr_15672;
})();
if(cljs.core.truth_(inst_15651)){
var statearr_15673_15690 = state_15667__$1;
(statearr_15673_15690[(1)] = (5));

} else {
var statearr_15674_15691 = state_15667__$1;
(statearr_15674_15691[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15668 === (6))){
var inst_15654 = (state_15667[(9)]);
var inst_15647 = (state_15667[(7)]);
var inst_15650 = (state_15667[(8)]);
var inst_15654__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_15647,inst_15650) : f.call(null,inst_15647,inst_15650));
var inst_15655 = cljs.core.reduced_QMARK_(inst_15654__$1);
var state_15667__$1 = (function (){var statearr_15675 = state_15667;
(statearr_15675[(9)] = inst_15654__$1);

return statearr_15675;
})();
if(inst_15655){
var statearr_15676_15692 = state_15667__$1;
(statearr_15676_15692[(1)] = (8));

} else {
var statearr_15677_15693 = state_15667__$1;
(statearr_15677_15693[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15668 === (3))){
var inst_15665 = (state_15667[(2)]);
var state_15667__$1 = state_15667;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15667__$1,inst_15665);
} else {
if((state_val_15668 === (2))){
var state_15667__$1 = state_15667;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15667__$1,(4),ch);
} else {
if((state_val_15668 === (9))){
var inst_15654 = (state_15667[(9)]);
var inst_15647 = inst_15654;
var state_15667__$1 = (function (){var statearr_15678 = state_15667;
(statearr_15678[(7)] = inst_15647);

return statearr_15678;
})();
var statearr_15679_15694 = state_15667__$1;
(statearr_15679_15694[(2)] = null);

(statearr_15679_15694[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15668 === (5))){
var inst_15647 = (state_15667[(7)]);
var state_15667__$1 = state_15667;
var statearr_15680_15695 = state_15667__$1;
(statearr_15680_15695[(2)] = inst_15647);

(statearr_15680_15695[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15668 === (10))){
var inst_15661 = (state_15667[(2)]);
var state_15667__$1 = state_15667;
var statearr_15681_15696 = state_15667__$1;
(statearr_15681_15696[(2)] = inst_15661);

(statearr_15681_15696[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15668 === (8))){
var inst_15654 = (state_15667[(9)]);
var inst_15657 = cljs.core.deref(inst_15654);
var state_15667__$1 = state_15667;
var statearr_15682_15697 = state_15667__$1;
(statearr_15682_15697[(2)] = inst_15657);

(statearr_15682_15697[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__15091__auto__ = null;
var cljs$core$async$reduce_$_state_machine__15091__auto____0 = (function (){
var statearr_15683 = [null,null,null,null,null,null,null,null,null,null];
(statearr_15683[(0)] = cljs$core$async$reduce_$_state_machine__15091__auto__);

(statearr_15683[(1)] = (1));

return statearr_15683;
});
var cljs$core$async$reduce_$_state_machine__15091__auto____1 = (function (state_15667){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_15667);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e15684){var ex__15094__auto__ = e15684;
var statearr_15685_15698 = state_15667;
(statearr_15685_15698[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_15667[(4)]))){
var statearr_15686_15699 = state_15667;
(statearr_15686_15699[(1)] = cljs.core.first((state_15667[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__15700 = state_15667;
state_15667 = G__15700;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__15091__auto__ = function(state_15667){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__15091__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__15091__auto____1.call(this,state_15667);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__15091__auto____0;
cljs$core$async$reduce_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__15091__auto____1;
return cljs$core$async$reduce_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_15687 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_15687[(6)] = c__15165__auto__);

return statearr_15687;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_15706){
var state_val_15707 = (state_15706[(1)]);
if((state_val_15707 === (1))){
var inst_15701 = cljs.core.async.reduce(f__$1,init,ch);
var state_15706__$1 = state_15706;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15706__$1,(2),inst_15701);
} else {
if((state_val_15707 === (2))){
var inst_15703 = (state_15706[(2)]);
var inst_15704 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_15703) : f__$1.call(null,inst_15703));
var state_15706__$1 = state_15706;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15706__$1,inst_15704);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__15091__auto__ = null;
var cljs$core$async$transduce_$_state_machine__15091__auto____0 = (function (){
var statearr_15708 = [null,null,null,null,null,null,null];
(statearr_15708[(0)] = cljs$core$async$transduce_$_state_machine__15091__auto__);

(statearr_15708[(1)] = (1));

return statearr_15708;
});
var cljs$core$async$transduce_$_state_machine__15091__auto____1 = (function (state_15706){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_15706);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e15709){var ex__15094__auto__ = e15709;
var statearr_15710_15713 = state_15706;
(statearr_15710_15713[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_15706[(4)]))){
var statearr_15711_15714 = state_15706;
(statearr_15711_15714[(1)] = cljs.core.first((state_15706[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__15715 = state_15706;
state_15706 = G__15715;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__15091__auto__ = function(state_15706){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__15091__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__15091__auto____1.call(this,state_15706);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__15091__auto____0;
cljs$core$async$transduce_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__15091__auto____1;
return cljs$core$async$transduce_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_15712 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_15712[(6)] = c__15165__auto__);

return statearr_15712;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__15717 = arguments.length;
switch (G__15717) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_15742){
var state_val_15743 = (state_15742[(1)]);
if((state_val_15743 === (7))){
var inst_15724 = (state_15742[(2)]);
var state_15742__$1 = state_15742;
var statearr_15744_15766 = state_15742__$1;
(statearr_15744_15766[(2)] = inst_15724);

(statearr_15744_15766[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15743 === (1))){
var inst_15718 = cljs.core.seq(coll);
var inst_15719 = inst_15718;
var state_15742__$1 = (function (){var statearr_15745 = state_15742;
(statearr_15745[(7)] = inst_15719);

return statearr_15745;
})();
var statearr_15746_15767 = state_15742__$1;
(statearr_15746_15767[(2)] = null);

(statearr_15746_15767[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15743 === (4))){
var inst_15719 = (state_15742[(7)]);
var inst_15722 = cljs.core.first(inst_15719);
var state_15742__$1 = state_15742;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15742__$1,(7),ch,inst_15722);
} else {
if((state_val_15743 === (13))){
var inst_15736 = (state_15742[(2)]);
var state_15742__$1 = state_15742;
var statearr_15747_15768 = state_15742__$1;
(statearr_15747_15768[(2)] = inst_15736);

(statearr_15747_15768[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15743 === (6))){
var inst_15727 = (state_15742[(2)]);
var state_15742__$1 = state_15742;
if(cljs.core.truth_(inst_15727)){
var statearr_15748_15769 = state_15742__$1;
(statearr_15748_15769[(1)] = (8));

} else {
var statearr_15749_15770 = state_15742__$1;
(statearr_15749_15770[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15743 === (3))){
var inst_15740 = (state_15742[(2)]);
var state_15742__$1 = state_15742;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15742__$1,inst_15740);
} else {
if((state_val_15743 === (12))){
var state_15742__$1 = state_15742;
var statearr_15750_15771 = state_15742__$1;
(statearr_15750_15771[(2)] = null);

(statearr_15750_15771[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15743 === (2))){
var inst_15719 = (state_15742[(7)]);
var state_15742__$1 = state_15742;
if(cljs.core.truth_(inst_15719)){
var statearr_15751_15772 = state_15742__$1;
(statearr_15751_15772[(1)] = (4));

} else {
var statearr_15752_15773 = state_15742__$1;
(statearr_15752_15773[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15743 === (11))){
var inst_15733 = cljs.core.async.close_BANG_(ch);
var state_15742__$1 = state_15742;
var statearr_15753_15774 = state_15742__$1;
(statearr_15753_15774[(2)] = inst_15733);

(statearr_15753_15774[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15743 === (9))){
var state_15742__$1 = state_15742;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15754_15775 = state_15742__$1;
(statearr_15754_15775[(1)] = (11));

} else {
var statearr_15755_15776 = state_15742__$1;
(statearr_15755_15776[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15743 === (5))){
var inst_15719 = (state_15742[(7)]);
var state_15742__$1 = state_15742;
var statearr_15756_15777 = state_15742__$1;
(statearr_15756_15777[(2)] = inst_15719);

(statearr_15756_15777[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15743 === (10))){
var inst_15738 = (state_15742[(2)]);
var state_15742__$1 = state_15742;
var statearr_15757_15778 = state_15742__$1;
(statearr_15757_15778[(2)] = inst_15738);

(statearr_15757_15778[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15743 === (8))){
var inst_15719 = (state_15742[(7)]);
var inst_15729 = cljs.core.next(inst_15719);
var inst_15719__$1 = inst_15729;
var state_15742__$1 = (function (){var statearr_15758 = state_15742;
(statearr_15758[(7)] = inst_15719__$1);

return statearr_15758;
})();
var statearr_15759_15779 = state_15742__$1;
(statearr_15759_15779[(2)] = null);

(statearr_15759_15779[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__15091__auto__ = null;
var cljs$core$async$state_machine__15091__auto____0 = (function (){
var statearr_15760 = [null,null,null,null,null,null,null,null];
(statearr_15760[(0)] = cljs$core$async$state_machine__15091__auto__);

(statearr_15760[(1)] = (1));

return statearr_15760;
});
var cljs$core$async$state_machine__15091__auto____1 = (function (state_15742){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_15742);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e15761){var ex__15094__auto__ = e15761;
var statearr_15762_15780 = state_15742;
(statearr_15762_15780[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_15742[(4)]))){
var statearr_15763_15781 = state_15742;
(statearr_15763_15781[(1)] = cljs.core.first((state_15742[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__15782 = state_15742;
state_15742 = G__15782;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
cljs$core$async$state_machine__15091__auto__ = function(state_15742){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__15091__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__15091__auto____1.call(this,state_15742);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__15091__auto____0;
cljs$core$async$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__15091__auto____1;
return cljs$core$async$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_15764 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_15764[(6)] = c__15165__auto__);

return statearr_15764;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__15784 = arguments.length;
switch (G__15784) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_15786 = (function (_){
var x__5392__auto__ = (((_ == null))?null:_);
var m__5393__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5393__auto__.call(null,_));
} else {
var m__5391__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5391__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_15786(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_15787 = (function (m,ch,close_QMARK_){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5393__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5391__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5391__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_15787(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_15788 = (function (m,ch){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5393__auto__.call(null,m,ch));
} else {
var m__5391__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5391__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_15788(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_15789 = (function (m){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5393__auto__.call(null,m));
} else {
var m__5391__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5391__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_15789(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async15790 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15790 = (function (ch,cs,meta15791){
this.ch = ch;
this.cs = cs;
this.meta15791 = meta15791;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async15790.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15792,meta15791__$1){
var self__ = this;
var _15792__$1 = this;
return (new cljs.core.async.t_cljs$core$async15790(self__.ch,self__.cs,meta15791__$1));
}));

(cljs.core.async.t_cljs$core$async15790.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15792){
var self__ = this;
var _15792__$1 = this;
return self__.meta15791;
}));

(cljs.core.async.t_cljs$core$async15790.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15790.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async15790.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15790.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async15790.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async15790.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async15790.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta15791], null);
}));

(cljs.core.async.t_cljs$core$async15790.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async15790.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15790");

(cljs.core.async.t_cljs$core$async15790.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async15790");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async15790.
 */
cljs.core.async.__GT_t_cljs$core$async15790 = (function cljs$core$async$mult_$___GT_t_cljs$core$async15790(ch__$1,cs__$1,meta15791){
return (new cljs.core.async.t_cljs$core$async15790(ch__$1,cs__$1,meta15791));
});

}

return (new cljs.core.async.t_cljs$core$async15790(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__15165__auto___16009 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_15925){
var state_val_15926 = (state_15925[(1)]);
if((state_val_15926 === (7))){
var inst_15921 = (state_15925[(2)]);
var state_15925__$1 = state_15925;
var statearr_15927_16010 = state_15925__$1;
(statearr_15927_16010[(2)] = inst_15921);

(statearr_15927_16010[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (20))){
var inst_15826 = (state_15925[(7)]);
var inst_15838 = cljs.core.first(inst_15826);
var inst_15839 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15838,(0),null);
var inst_15840 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15838,(1),null);
var state_15925__$1 = (function (){var statearr_15928 = state_15925;
(statearr_15928[(8)] = inst_15839);

return statearr_15928;
})();
if(cljs.core.truth_(inst_15840)){
var statearr_15929_16011 = state_15925__$1;
(statearr_15929_16011[(1)] = (22));

} else {
var statearr_15930_16012 = state_15925__$1;
(statearr_15930_16012[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (27))){
var inst_15795 = (state_15925[(9)]);
var inst_15875 = (state_15925[(10)]);
var inst_15870 = (state_15925[(11)]);
var inst_15868 = (state_15925[(12)]);
var inst_15875__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_15868,inst_15870);
var inst_15876 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_15875__$1,inst_15795,done);
var state_15925__$1 = (function (){var statearr_15931 = state_15925;
(statearr_15931[(10)] = inst_15875__$1);

return statearr_15931;
})();
if(cljs.core.truth_(inst_15876)){
var statearr_15932_16013 = state_15925__$1;
(statearr_15932_16013[(1)] = (30));

} else {
var statearr_15933_16014 = state_15925__$1;
(statearr_15933_16014[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (1))){
var state_15925__$1 = state_15925;
var statearr_15934_16015 = state_15925__$1;
(statearr_15934_16015[(2)] = null);

(statearr_15934_16015[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (24))){
var inst_15826 = (state_15925[(7)]);
var inst_15845 = (state_15925[(2)]);
var inst_15846 = cljs.core.next(inst_15826);
var inst_15804 = inst_15846;
var inst_15805 = null;
var inst_15806 = (0);
var inst_15807 = (0);
var state_15925__$1 = (function (){var statearr_15935 = state_15925;
(statearr_15935[(13)] = inst_15806);

(statearr_15935[(14)] = inst_15804);

(statearr_15935[(15)] = inst_15807);

(statearr_15935[(16)] = inst_15845);

(statearr_15935[(17)] = inst_15805);

return statearr_15935;
})();
var statearr_15936_16016 = state_15925__$1;
(statearr_15936_16016[(2)] = null);

(statearr_15936_16016[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (39))){
var state_15925__$1 = state_15925;
var statearr_15940_16017 = state_15925__$1;
(statearr_15940_16017[(2)] = null);

(statearr_15940_16017[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (4))){
var inst_15795 = (state_15925[(9)]);
var inst_15795__$1 = (state_15925[(2)]);
var inst_15796 = (inst_15795__$1 == null);
var state_15925__$1 = (function (){var statearr_15941 = state_15925;
(statearr_15941[(9)] = inst_15795__$1);

return statearr_15941;
})();
if(cljs.core.truth_(inst_15796)){
var statearr_15942_16018 = state_15925__$1;
(statearr_15942_16018[(1)] = (5));

} else {
var statearr_15943_16019 = state_15925__$1;
(statearr_15943_16019[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (15))){
var inst_15806 = (state_15925[(13)]);
var inst_15804 = (state_15925[(14)]);
var inst_15807 = (state_15925[(15)]);
var inst_15805 = (state_15925[(17)]);
var inst_15822 = (state_15925[(2)]);
var inst_15823 = (inst_15807 + (1));
var tmp15937 = inst_15806;
var tmp15938 = inst_15804;
var tmp15939 = inst_15805;
var inst_15804__$1 = tmp15938;
var inst_15805__$1 = tmp15939;
var inst_15806__$1 = tmp15937;
var inst_15807__$1 = inst_15823;
var state_15925__$1 = (function (){var statearr_15944 = state_15925;
(statearr_15944[(13)] = inst_15806__$1);

(statearr_15944[(14)] = inst_15804__$1);

(statearr_15944[(15)] = inst_15807__$1);

(statearr_15944[(18)] = inst_15822);

(statearr_15944[(17)] = inst_15805__$1);

return statearr_15944;
})();
var statearr_15945_16020 = state_15925__$1;
(statearr_15945_16020[(2)] = null);

(statearr_15945_16020[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (21))){
var inst_15849 = (state_15925[(2)]);
var state_15925__$1 = state_15925;
var statearr_15949_16021 = state_15925__$1;
(statearr_15949_16021[(2)] = inst_15849);

(statearr_15949_16021[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (31))){
var inst_15875 = (state_15925[(10)]);
var inst_15879 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_15875);
var state_15925__$1 = state_15925;
var statearr_15950_16022 = state_15925__$1;
(statearr_15950_16022[(2)] = inst_15879);

(statearr_15950_16022[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (32))){
var inst_15867 = (state_15925[(19)]);
var inst_15869 = (state_15925[(20)]);
var inst_15870 = (state_15925[(11)]);
var inst_15868 = (state_15925[(12)]);
var inst_15881 = (state_15925[(2)]);
var inst_15882 = (inst_15870 + (1));
var tmp15946 = inst_15867;
var tmp15947 = inst_15869;
var tmp15948 = inst_15868;
var inst_15867__$1 = tmp15946;
var inst_15868__$1 = tmp15948;
var inst_15869__$1 = tmp15947;
var inst_15870__$1 = inst_15882;
var state_15925__$1 = (function (){var statearr_15951 = state_15925;
(statearr_15951[(21)] = inst_15881);

(statearr_15951[(19)] = inst_15867__$1);

(statearr_15951[(20)] = inst_15869__$1);

(statearr_15951[(11)] = inst_15870__$1);

(statearr_15951[(12)] = inst_15868__$1);

return statearr_15951;
})();
var statearr_15952_16023 = state_15925__$1;
(statearr_15952_16023[(2)] = null);

(statearr_15952_16023[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (40))){
var inst_15894 = (state_15925[(22)]);
var inst_15898 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_15894);
var state_15925__$1 = state_15925;
var statearr_15953_16024 = state_15925__$1;
(statearr_15953_16024[(2)] = inst_15898);

(statearr_15953_16024[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (33))){
var inst_15885 = (state_15925[(23)]);
var inst_15887 = cljs.core.chunked_seq_QMARK_(inst_15885);
var state_15925__$1 = state_15925;
if(inst_15887){
var statearr_15954_16025 = state_15925__$1;
(statearr_15954_16025[(1)] = (36));

} else {
var statearr_15955_16026 = state_15925__$1;
(statearr_15955_16026[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (13))){
var inst_15816 = (state_15925[(24)]);
var inst_15819 = cljs.core.async.close_BANG_(inst_15816);
var state_15925__$1 = state_15925;
var statearr_15956_16027 = state_15925__$1;
(statearr_15956_16027[(2)] = inst_15819);

(statearr_15956_16027[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (22))){
var inst_15839 = (state_15925[(8)]);
var inst_15842 = cljs.core.async.close_BANG_(inst_15839);
var state_15925__$1 = state_15925;
var statearr_15957_16028 = state_15925__$1;
(statearr_15957_16028[(2)] = inst_15842);

(statearr_15957_16028[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (36))){
var inst_15885 = (state_15925[(23)]);
var inst_15889 = cljs.core.chunk_first(inst_15885);
var inst_15890 = cljs.core.chunk_rest(inst_15885);
var inst_15891 = cljs.core.count(inst_15889);
var inst_15867 = inst_15890;
var inst_15868 = inst_15889;
var inst_15869 = inst_15891;
var inst_15870 = (0);
var state_15925__$1 = (function (){var statearr_15958 = state_15925;
(statearr_15958[(19)] = inst_15867);

(statearr_15958[(20)] = inst_15869);

(statearr_15958[(11)] = inst_15870);

(statearr_15958[(12)] = inst_15868);

return statearr_15958;
})();
var statearr_15959_16029 = state_15925__$1;
(statearr_15959_16029[(2)] = null);

(statearr_15959_16029[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (41))){
var inst_15885 = (state_15925[(23)]);
var inst_15900 = (state_15925[(2)]);
var inst_15901 = cljs.core.next(inst_15885);
var inst_15867 = inst_15901;
var inst_15868 = null;
var inst_15869 = (0);
var inst_15870 = (0);
var state_15925__$1 = (function (){var statearr_15960 = state_15925;
(statearr_15960[(19)] = inst_15867);

(statearr_15960[(20)] = inst_15869);

(statearr_15960[(11)] = inst_15870);

(statearr_15960[(25)] = inst_15900);

(statearr_15960[(12)] = inst_15868);

return statearr_15960;
})();
var statearr_15961_16030 = state_15925__$1;
(statearr_15961_16030[(2)] = null);

(statearr_15961_16030[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (43))){
var state_15925__$1 = state_15925;
var statearr_15962_16031 = state_15925__$1;
(statearr_15962_16031[(2)] = null);

(statearr_15962_16031[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (29))){
var inst_15909 = (state_15925[(2)]);
var state_15925__$1 = state_15925;
var statearr_15963_16032 = state_15925__$1;
(statearr_15963_16032[(2)] = inst_15909);

(statearr_15963_16032[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (44))){
var inst_15918 = (state_15925[(2)]);
var state_15925__$1 = (function (){var statearr_15964 = state_15925;
(statearr_15964[(26)] = inst_15918);

return statearr_15964;
})();
var statearr_15965_16033 = state_15925__$1;
(statearr_15965_16033[(2)] = null);

(statearr_15965_16033[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (6))){
var inst_15859 = (state_15925[(27)]);
var inst_15858 = cljs.core.deref(cs);
var inst_15859__$1 = cljs.core.keys(inst_15858);
var inst_15860 = cljs.core.count(inst_15859__$1);
var inst_15861 = cljs.core.reset_BANG_(dctr,inst_15860);
var inst_15866 = cljs.core.seq(inst_15859__$1);
var inst_15867 = inst_15866;
var inst_15868 = null;
var inst_15869 = (0);
var inst_15870 = (0);
var state_15925__$1 = (function (){var statearr_15966 = state_15925;
(statearr_15966[(28)] = inst_15861);

(statearr_15966[(27)] = inst_15859__$1);

(statearr_15966[(19)] = inst_15867);

(statearr_15966[(20)] = inst_15869);

(statearr_15966[(11)] = inst_15870);

(statearr_15966[(12)] = inst_15868);

return statearr_15966;
})();
var statearr_15967_16034 = state_15925__$1;
(statearr_15967_16034[(2)] = null);

(statearr_15967_16034[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (28))){
var inst_15867 = (state_15925[(19)]);
var inst_15885 = (state_15925[(23)]);
var inst_15885__$1 = cljs.core.seq(inst_15867);
var state_15925__$1 = (function (){var statearr_15968 = state_15925;
(statearr_15968[(23)] = inst_15885__$1);

return statearr_15968;
})();
if(inst_15885__$1){
var statearr_15969_16035 = state_15925__$1;
(statearr_15969_16035[(1)] = (33));

} else {
var statearr_15970_16036 = state_15925__$1;
(statearr_15970_16036[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (25))){
var inst_15869 = (state_15925[(20)]);
var inst_15870 = (state_15925[(11)]);
var inst_15872 = (inst_15870 < inst_15869);
var inst_15873 = inst_15872;
var state_15925__$1 = state_15925;
if(cljs.core.truth_(inst_15873)){
var statearr_15971_16037 = state_15925__$1;
(statearr_15971_16037[(1)] = (27));

} else {
var statearr_15972_16038 = state_15925__$1;
(statearr_15972_16038[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (34))){
var state_15925__$1 = state_15925;
var statearr_15973_16039 = state_15925__$1;
(statearr_15973_16039[(2)] = null);

(statearr_15973_16039[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (17))){
var state_15925__$1 = state_15925;
var statearr_15974_16040 = state_15925__$1;
(statearr_15974_16040[(2)] = null);

(statearr_15974_16040[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (3))){
var inst_15923 = (state_15925[(2)]);
var state_15925__$1 = state_15925;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15925__$1,inst_15923);
} else {
if((state_val_15926 === (12))){
var inst_15854 = (state_15925[(2)]);
var state_15925__$1 = state_15925;
var statearr_15975_16041 = state_15925__$1;
(statearr_15975_16041[(2)] = inst_15854);

(statearr_15975_16041[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (2))){
var state_15925__$1 = state_15925;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15925__$1,(4),ch);
} else {
if((state_val_15926 === (23))){
var state_15925__$1 = state_15925;
var statearr_15976_16042 = state_15925__$1;
(statearr_15976_16042[(2)] = null);

(statearr_15976_16042[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (35))){
var inst_15907 = (state_15925[(2)]);
var state_15925__$1 = state_15925;
var statearr_15977_16043 = state_15925__$1;
(statearr_15977_16043[(2)] = inst_15907);

(statearr_15977_16043[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (19))){
var inst_15826 = (state_15925[(7)]);
var inst_15830 = cljs.core.chunk_first(inst_15826);
var inst_15831 = cljs.core.chunk_rest(inst_15826);
var inst_15832 = cljs.core.count(inst_15830);
var inst_15804 = inst_15831;
var inst_15805 = inst_15830;
var inst_15806 = inst_15832;
var inst_15807 = (0);
var state_15925__$1 = (function (){var statearr_15978 = state_15925;
(statearr_15978[(13)] = inst_15806);

(statearr_15978[(14)] = inst_15804);

(statearr_15978[(15)] = inst_15807);

(statearr_15978[(17)] = inst_15805);

return statearr_15978;
})();
var statearr_15979_16044 = state_15925__$1;
(statearr_15979_16044[(2)] = null);

(statearr_15979_16044[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (11))){
var inst_15804 = (state_15925[(14)]);
var inst_15826 = (state_15925[(7)]);
var inst_15826__$1 = cljs.core.seq(inst_15804);
var state_15925__$1 = (function (){var statearr_15980 = state_15925;
(statearr_15980[(7)] = inst_15826__$1);

return statearr_15980;
})();
if(inst_15826__$1){
var statearr_15981_16045 = state_15925__$1;
(statearr_15981_16045[(1)] = (16));

} else {
var statearr_15982_16046 = state_15925__$1;
(statearr_15982_16046[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (9))){
var inst_15856 = (state_15925[(2)]);
var state_15925__$1 = state_15925;
var statearr_15983_16047 = state_15925__$1;
(statearr_15983_16047[(2)] = inst_15856);

(statearr_15983_16047[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (5))){
var inst_15802 = cljs.core.deref(cs);
var inst_15803 = cljs.core.seq(inst_15802);
var inst_15804 = inst_15803;
var inst_15805 = null;
var inst_15806 = (0);
var inst_15807 = (0);
var state_15925__$1 = (function (){var statearr_15984 = state_15925;
(statearr_15984[(13)] = inst_15806);

(statearr_15984[(14)] = inst_15804);

(statearr_15984[(15)] = inst_15807);

(statearr_15984[(17)] = inst_15805);

return statearr_15984;
})();
var statearr_15985_16048 = state_15925__$1;
(statearr_15985_16048[(2)] = null);

(statearr_15985_16048[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (14))){
var state_15925__$1 = state_15925;
var statearr_15986_16049 = state_15925__$1;
(statearr_15986_16049[(2)] = null);

(statearr_15986_16049[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (45))){
var inst_15915 = (state_15925[(2)]);
var state_15925__$1 = state_15925;
var statearr_15987_16050 = state_15925__$1;
(statearr_15987_16050[(2)] = inst_15915);

(statearr_15987_16050[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (26))){
var inst_15859 = (state_15925[(27)]);
var inst_15911 = (state_15925[(2)]);
var inst_15912 = cljs.core.seq(inst_15859);
var state_15925__$1 = (function (){var statearr_15988 = state_15925;
(statearr_15988[(29)] = inst_15911);

return statearr_15988;
})();
if(inst_15912){
var statearr_15989_16051 = state_15925__$1;
(statearr_15989_16051[(1)] = (42));

} else {
var statearr_15990_16052 = state_15925__$1;
(statearr_15990_16052[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (16))){
var inst_15826 = (state_15925[(7)]);
var inst_15828 = cljs.core.chunked_seq_QMARK_(inst_15826);
var state_15925__$1 = state_15925;
if(inst_15828){
var statearr_15991_16053 = state_15925__$1;
(statearr_15991_16053[(1)] = (19));

} else {
var statearr_15992_16054 = state_15925__$1;
(statearr_15992_16054[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (38))){
var inst_15904 = (state_15925[(2)]);
var state_15925__$1 = state_15925;
var statearr_15993_16055 = state_15925__$1;
(statearr_15993_16055[(2)] = inst_15904);

(statearr_15993_16055[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (30))){
var state_15925__$1 = state_15925;
var statearr_15994_16056 = state_15925__$1;
(statearr_15994_16056[(2)] = null);

(statearr_15994_16056[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (10))){
var inst_15807 = (state_15925[(15)]);
var inst_15805 = (state_15925[(17)]);
var inst_15815 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_15805,inst_15807);
var inst_15816 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15815,(0),null);
var inst_15817 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15815,(1),null);
var state_15925__$1 = (function (){var statearr_15995 = state_15925;
(statearr_15995[(24)] = inst_15816);

return statearr_15995;
})();
if(cljs.core.truth_(inst_15817)){
var statearr_15996_16057 = state_15925__$1;
(statearr_15996_16057[(1)] = (13));

} else {
var statearr_15997_16058 = state_15925__$1;
(statearr_15997_16058[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (18))){
var inst_15852 = (state_15925[(2)]);
var state_15925__$1 = state_15925;
var statearr_15998_16059 = state_15925__$1;
(statearr_15998_16059[(2)] = inst_15852);

(statearr_15998_16059[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (42))){
var state_15925__$1 = state_15925;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15925__$1,(45),dchan);
} else {
if((state_val_15926 === (37))){
var inst_15795 = (state_15925[(9)]);
var inst_15894 = (state_15925[(22)]);
var inst_15885 = (state_15925[(23)]);
var inst_15894__$1 = cljs.core.first(inst_15885);
var inst_15895 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_15894__$1,inst_15795,done);
var state_15925__$1 = (function (){var statearr_15999 = state_15925;
(statearr_15999[(22)] = inst_15894__$1);

return statearr_15999;
})();
if(cljs.core.truth_(inst_15895)){
var statearr_16000_16060 = state_15925__$1;
(statearr_16000_16060[(1)] = (39));

} else {
var statearr_16001_16061 = state_15925__$1;
(statearr_16001_16061[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15926 === (8))){
var inst_15806 = (state_15925[(13)]);
var inst_15807 = (state_15925[(15)]);
var inst_15809 = (inst_15807 < inst_15806);
var inst_15810 = inst_15809;
var state_15925__$1 = state_15925;
if(cljs.core.truth_(inst_15810)){
var statearr_16002_16062 = state_15925__$1;
(statearr_16002_16062[(1)] = (10));

} else {
var statearr_16003_16063 = state_15925__$1;
(statearr_16003_16063[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__15091__auto__ = null;
var cljs$core$async$mult_$_state_machine__15091__auto____0 = (function (){
var statearr_16004 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16004[(0)] = cljs$core$async$mult_$_state_machine__15091__auto__);

(statearr_16004[(1)] = (1));

return statearr_16004;
});
var cljs$core$async$mult_$_state_machine__15091__auto____1 = (function (state_15925){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_15925);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e16005){var ex__15094__auto__ = e16005;
var statearr_16006_16064 = state_15925;
(statearr_16006_16064[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_15925[(4)]))){
var statearr_16007_16065 = state_15925;
(statearr_16007_16065[(1)] = cljs.core.first((state_15925[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__16066 = state_15925;
state_15925 = G__16066;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__15091__auto__ = function(state_15925){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__15091__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__15091__auto____1.call(this,state_15925);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__15091__auto____0;
cljs$core$async$mult_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__15091__auto____1;
return cljs$core$async$mult_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_16008 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_16008[(6)] = c__15165__auto___16009);

return statearr_16008;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__16068 = arguments.length;
switch (G__16068) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_16070 = (function (m,ch){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5393__auto__.call(null,m,ch));
} else {
var m__5391__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5391__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_16070(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_16071 = (function (m,ch){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5393__auto__.call(null,m,ch));
} else {
var m__5391__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5391__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_16071(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_16072 = (function (m){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5393__auto__.call(null,m));
} else {
var m__5391__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5391__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_16072(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_16073 = (function (m,state_map){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5393__auto__.call(null,m,state_map));
} else {
var m__5391__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5391__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_16073(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_16074 = (function (m,mode){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5393__auto__.call(null,m,mode));
} else {
var m__5391__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5391__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_16074(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___16084 = arguments.length;
var i__5769__auto___16085 = (0);
while(true){
if((i__5769__auto___16085 < len__5768__auto___16084)){
args__5774__auto__.push((arguments[i__5769__auto___16085]));

var G__16086 = (i__5769__auto___16085 + (1));
i__5769__auto___16085 = G__16086;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((3) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5775__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__16079){
var map__16080 = p__16079;
var map__16080__$1 = cljs.core.__destructure_map(map__16080);
var opts = map__16080__$1;
var statearr_16081_16087 = state;
(statearr_16081_16087[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts((function (val){
var statearr_16082_16088 = state;
(statearr_16082_16088[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_16083_16089 = state;
(statearr_16083_16089[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq16075){
var G__16076 = cljs.core.first(seq16075);
var seq16075__$1 = cljs.core.next(seq16075);
var G__16077 = cljs.core.first(seq16075__$1);
var seq16075__$2 = cljs.core.next(seq16075__$1);
var G__16078 = cljs.core.first(seq16075__$2);
var seq16075__$3 = cljs.core.next(seq16075__$2);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16076,G__16077,G__16078,seq16075__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async16090 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16090 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta16091){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta16091 = meta16091;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16090.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16092,meta16091__$1){
var self__ = this;
var _16092__$1 = this;
return (new cljs.core.async.t_cljs$core$async16090(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta16091__$1));
}));

(cljs.core.async.t_cljs$core$async16090.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16092){
var self__ = this;
var _16092__$1 = this;
return self__.meta16091;
}));

(cljs.core.async.t_cljs$core$async16090.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16090.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async16090.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16090.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async16090.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async16090.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async16090.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async16090.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async16090.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta16091], null);
}));

(cljs.core.async.t_cljs$core$async16090.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16090.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16090");

(cljs.core.async.t_cljs$core$async16090.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async16090");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16090.
 */
cljs.core.async.__GT_t_cljs$core$async16090 = (function cljs$core$async$mix_$___GT_t_cljs$core$async16090(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta16091){
return (new cljs.core.async.t_cljs$core$async16090(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta16091));
});

}

return (new cljs.core.async.t_cljs$core$async16090(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__15165__auto___16205 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_16160){
var state_val_16161 = (state_16160[(1)]);
if((state_val_16161 === (7))){
var inst_16120 = (state_16160[(2)]);
var state_16160__$1 = state_16160;
if(cljs.core.truth_(inst_16120)){
var statearr_16162_16206 = state_16160__$1;
(statearr_16162_16206[(1)] = (8));

} else {
var statearr_16163_16207 = state_16160__$1;
(statearr_16163_16207[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16161 === (20))){
var inst_16113 = (state_16160[(7)]);
var state_16160__$1 = state_16160;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16160__$1,(23),out,inst_16113);
} else {
if((state_val_16161 === (1))){
var inst_16096 = calc_state();
var inst_16097 = cljs.core.__destructure_map(inst_16096);
var inst_16098 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16097,cljs.core.cst$kw$solos);
var inst_16099 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16097,cljs.core.cst$kw$mutes);
var inst_16100 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16097,cljs.core.cst$kw$reads);
var inst_16101 = inst_16096;
var state_16160__$1 = (function (){var statearr_16164 = state_16160;
(statearr_16164[(8)] = inst_16099);

(statearr_16164[(9)] = inst_16101);

(statearr_16164[(10)] = inst_16100);

(statearr_16164[(11)] = inst_16098);

return statearr_16164;
})();
var statearr_16165_16208 = state_16160__$1;
(statearr_16165_16208[(2)] = null);

(statearr_16165_16208[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16161 === (24))){
var inst_16104 = (state_16160[(12)]);
var inst_16101 = inst_16104;
var state_16160__$1 = (function (){var statearr_16166 = state_16160;
(statearr_16166[(9)] = inst_16101);

return statearr_16166;
})();
var statearr_16167_16209 = state_16160__$1;
(statearr_16167_16209[(2)] = null);

(statearr_16167_16209[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16161 === (4))){
var inst_16115 = (state_16160[(13)]);
var inst_16113 = (state_16160[(7)]);
var inst_16112 = (state_16160[(2)]);
var inst_16113__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16112,(0),null);
var inst_16114 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16112,(1),null);
var inst_16115__$1 = (inst_16113__$1 == null);
var state_16160__$1 = (function (){var statearr_16168 = state_16160;
(statearr_16168[(13)] = inst_16115__$1);

(statearr_16168[(7)] = inst_16113__$1);

(statearr_16168[(14)] = inst_16114);

return statearr_16168;
})();
if(cljs.core.truth_(inst_16115__$1)){
var statearr_16169_16210 = state_16160__$1;
(statearr_16169_16210[(1)] = (5));

} else {
var statearr_16170_16211 = state_16160__$1;
(statearr_16170_16211[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16161 === (15))){
var inst_16134 = (state_16160[(15)]);
var inst_16105 = (state_16160[(16)]);
var inst_16134__$1 = cljs.core.empty_QMARK_(inst_16105);
var state_16160__$1 = (function (){var statearr_16171 = state_16160;
(statearr_16171[(15)] = inst_16134__$1);

return statearr_16171;
})();
if(inst_16134__$1){
var statearr_16172_16212 = state_16160__$1;
(statearr_16172_16212[(1)] = (17));

} else {
var statearr_16173_16213 = state_16160__$1;
(statearr_16173_16213[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16161 === (21))){
var inst_16104 = (state_16160[(12)]);
var inst_16101 = inst_16104;
var state_16160__$1 = (function (){var statearr_16174 = state_16160;
(statearr_16174[(9)] = inst_16101);

return statearr_16174;
})();
var statearr_16175_16214 = state_16160__$1;
(statearr_16175_16214[(2)] = null);

(statearr_16175_16214[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16161 === (13))){
var inst_16127 = (state_16160[(2)]);
var inst_16128 = calc_state();
var inst_16101 = inst_16128;
var state_16160__$1 = (function (){var statearr_16176 = state_16160;
(statearr_16176[(9)] = inst_16101);

(statearr_16176[(17)] = inst_16127);

return statearr_16176;
})();
var statearr_16177_16215 = state_16160__$1;
(statearr_16177_16215[(2)] = null);

(statearr_16177_16215[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16161 === (22))){
var inst_16154 = (state_16160[(2)]);
var state_16160__$1 = state_16160;
var statearr_16178_16216 = state_16160__$1;
(statearr_16178_16216[(2)] = inst_16154);

(statearr_16178_16216[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16161 === (6))){
var inst_16114 = (state_16160[(14)]);
var inst_16118 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_16114,change);
var state_16160__$1 = state_16160;
var statearr_16179_16217 = state_16160__$1;
(statearr_16179_16217[(2)] = inst_16118);

(statearr_16179_16217[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16161 === (25))){
var state_16160__$1 = state_16160;
var statearr_16180_16218 = state_16160__$1;
(statearr_16180_16218[(2)] = null);

(statearr_16180_16218[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16161 === (17))){
var inst_16106 = (state_16160[(18)]);
var inst_16114 = (state_16160[(14)]);
var inst_16136 = (inst_16106.cljs$core$IFn$_invoke$arity$1 ? inst_16106.cljs$core$IFn$_invoke$arity$1(inst_16114) : inst_16106.call(null,inst_16114));
var inst_16137 = cljs.core.not(inst_16136);
var state_16160__$1 = state_16160;
var statearr_16181_16219 = state_16160__$1;
(statearr_16181_16219[(2)] = inst_16137);

(statearr_16181_16219[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16161 === (3))){
var inst_16158 = (state_16160[(2)]);
var state_16160__$1 = state_16160;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16160__$1,inst_16158);
} else {
if((state_val_16161 === (12))){
var state_16160__$1 = state_16160;
var statearr_16182_16220 = state_16160__$1;
(statearr_16182_16220[(2)] = null);

(statearr_16182_16220[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16161 === (2))){
var inst_16104 = (state_16160[(12)]);
var inst_16101 = (state_16160[(9)]);
var inst_16104__$1 = cljs.core.__destructure_map(inst_16101);
var inst_16105 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16104__$1,cljs.core.cst$kw$solos);
var inst_16106 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16104__$1,cljs.core.cst$kw$mutes);
var inst_16107 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16104__$1,cljs.core.cst$kw$reads);
var state_16160__$1 = (function (){var statearr_16183 = state_16160;
(statearr_16183[(12)] = inst_16104__$1);

(statearr_16183[(18)] = inst_16106);

(statearr_16183[(16)] = inst_16105);

return statearr_16183;
})();
return cljs.core.async.ioc_alts_BANG_(state_16160__$1,(4),inst_16107);
} else {
if((state_val_16161 === (23))){
var inst_16145 = (state_16160[(2)]);
var state_16160__$1 = state_16160;
if(cljs.core.truth_(inst_16145)){
var statearr_16184_16221 = state_16160__$1;
(statearr_16184_16221[(1)] = (24));

} else {
var statearr_16185_16222 = state_16160__$1;
(statearr_16185_16222[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16161 === (19))){
var inst_16140 = (state_16160[(2)]);
var state_16160__$1 = state_16160;
var statearr_16186_16223 = state_16160__$1;
(statearr_16186_16223[(2)] = inst_16140);

(statearr_16186_16223[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16161 === (11))){
var inst_16114 = (state_16160[(14)]);
var inst_16124 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_16114);
var state_16160__$1 = state_16160;
var statearr_16187_16224 = state_16160__$1;
(statearr_16187_16224[(2)] = inst_16124);

(statearr_16187_16224[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16161 === (9))){
var inst_16131 = (state_16160[(19)]);
var inst_16105 = (state_16160[(16)]);
var inst_16114 = (state_16160[(14)]);
var inst_16131__$1 = (inst_16105.cljs$core$IFn$_invoke$arity$1 ? inst_16105.cljs$core$IFn$_invoke$arity$1(inst_16114) : inst_16105.call(null,inst_16114));
var state_16160__$1 = (function (){var statearr_16188 = state_16160;
(statearr_16188[(19)] = inst_16131__$1);

return statearr_16188;
})();
if(cljs.core.truth_(inst_16131__$1)){
var statearr_16189_16225 = state_16160__$1;
(statearr_16189_16225[(1)] = (14));

} else {
var statearr_16190_16226 = state_16160__$1;
(statearr_16190_16226[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16161 === (5))){
var inst_16115 = (state_16160[(13)]);
var state_16160__$1 = state_16160;
var statearr_16191_16227 = state_16160__$1;
(statearr_16191_16227[(2)] = inst_16115);

(statearr_16191_16227[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16161 === (14))){
var inst_16131 = (state_16160[(19)]);
var state_16160__$1 = state_16160;
var statearr_16192_16228 = state_16160__$1;
(statearr_16192_16228[(2)] = inst_16131);

(statearr_16192_16228[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16161 === (26))){
var inst_16150 = (state_16160[(2)]);
var state_16160__$1 = state_16160;
var statearr_16193_16229 = state_16160__$1;
(statearr_16193_16229[(2)] = inst_16150);

(statearr_16193_16229[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16161 === (16))){
var inst_16142 = (state_16160[(2)]);
var state_16160__$1 = state_16160;
if(cljs.core.truth_(inst_16142)){
var statearr_16194_16230 = state_16160__$1;
(statearr_16194_16230[(1)] = (20));

} else {
var statearr_16195_16231 = state_16160__$1;
(statearr_16195_16231[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16161 === (10))){
var inst_16156 = (state_16160[(2)]);
var state_16160__$1 = state_16160;
var statearr_16196_16232 = state_16160__$1;
(statearr_16196_16232[(2)] = inst_16156);

(statearr_16196_16232[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16161 === (18))){
var inst_16134 = (state_16160[(15)]);
var state_16160__$1 = state_16160;
var statearr_16197_16233 = state_16160__$1;
(statearr_16197_16233[(2)] = inst_16134);

(statearr_16197_16233[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16161 === (8))){
var inst_16113 = (state_16160[(7)]);
var inst_16122 = (inst_16113 == null);
var state_16160__$1 = state_16160;
if(cljs.core.truth_(inst_16122)){
var statearr_16198_16234 = state_16160__$1;
(statearr_16198_16234[(1)] = (11));

} else {
var statearr_16199_16235 = state_16160__$1;
(statearr_16199_16235[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__15091__auto__ = null;
var cljs$core$async$mix_$_state_machine__15091__auto____0 = (function (){
var statearr_16200 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16200[(0)] = cljs$core$async$mix_$_state_machine__15091__auto__);

(statearr_16200[(1)] = (1));

return statearr_16200;
});
var cljs$core$async$mix_$_state_machine__15091__auto____1 = (function (state_16160){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_16160);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e16201){var ex__15094__auto__ = e16201;
var statearr_16202_16236 = state_16160;
(statearr_16202_16236[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_16160[(4)]))){
var statearr_16203_16237 = state_16160;
(statearr_16203_16237[(1)] = cljs.core.first((state_16160[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__16238 = state_16160;
state_16160 = G__16238;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__15091__auto__ = function(state_16160){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__15091__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__15091__auto____1.call(this,state_16160);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__15091__auto____0;
cljs$core$async$mix_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__15091__auto____1;
return cljs$core$async$mix_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_16204 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_16204[(6)] = c__15165__auto___16205);

return statearr_16204;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_16241 = (function (p,v,ch,close_QMARK_){
var x__5392__auto__ = (((p == null))?null:p);
var m__5393__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5393__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5391__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5391__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_16241(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_16242 = (function (p,v,ch){
var x__5392__auto__ = (((p == null))?null:p);
var m__5393__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5393__auto__.call(null,p,v,ch));
} else {
var m__5391__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5391__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_16242(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_16243 = (function() {
var G__16244 = null;
var G__16244__1 = (function (p){
var x__5392__auto__ = (((p == null))?null:p);
var m__5393__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5393__auto__.call(null,p));
} else {
var m__5391__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5391__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__16244__2 = (function (p,v){
var x__5392__auto__ = (((p == null))?null:p);
var m__5393__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5393__auto__.call(null,p,v));
} else {
var m__5391__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5391__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__16244 = function(p,v){
switch(arguments.length){
case 1:
return G__16244__1.call(this,p);
case 2:
return G__16244__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__16244.cljs$core$IFn$_invoke$arity$1 = G__16244__1;
G__16244.cljs$core$IFn$_invoke$arity$2 = G__16244__2;
return G__16244;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__16240 = arguments.length;
switch (G__16240) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_16243.cljs$core$IFn$_invoke$arity$1(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_16243.cljs$core$IFn$_invoke$arity$2(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__16248 = arguments.length;
switch (G__16248) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__16246_SHARP_){
if(cljs.core.truth_((p1__16246_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16246_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__16246_SHARP_.call(null,topic)))){
return p1__16246_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__16246_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async16249 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16249 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta16250){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta16250 = meta16250;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16249.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16251,meta16250__$1){
var self__ = this;
var _16251__$1 = this;
return (new cljs.core.async.t_cljs$core$async16249(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta16250__$1));
}));

(cljs.core.async.t_cljs$core$async16249.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16251){
var self__ = this;
var _16251__$1 = this;
return self__.meta16250;
}));

(cljs.core.async.t_cljs$core$async16249.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16249.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async16249.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16249.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async16249.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async16249.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async16249.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async16249.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta16250], null);
}));

(cljs.core.async.t_cljs$core$async16249.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16249.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16249");

(cljs.core.async.t_cljs$core$async16249.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async16249");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16249.
 */
cljs.core.async.__GT_t_cljs$core$async16249 = (function cljs$core$async$__GT_t_cljs$core$async16249(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16250){
return (new cljs.core.async.t_cljs$core$async16249(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16250));
});

}

return (new cljs.core.async.t_cljs$core$async16249(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__15165__auto___16370 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_16323){
var state_val_16324 = (state_16323[(1)]);
if((state_val_16324 === (7))){
var inst_16319 = (state_16323[(2)]);
var state_16323__$1 = state_16323;
var statearr_16325_16371 = state_16323__$1;
(statearr_16325_16371[(2)] = inst_16319);

(statearr_16325_16371[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16324 === (20))){
var state_16323__$1 = state_16323;
var statearr_16326_16372 = state_16323__$1;
(statearr_16326_16372[(2)] = null);

(statearr_16326_16372[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16324 === (1))){
var state_16323__$1 = state_16323;
var statearr_16327_16373 = state_16323__$1;
(statearr_16327_16373[(2)] = null);

(statearr_16327_16373[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16324 === (24))){
var inst_16302 = (state_16323[(7)]);
var inst_16311 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_16302);
var state_16323__$1 = state_16323;
var statearr_16328_16374 = state_16323__$1;
(statearr_16328_16374[(2)] = inst_16311);

(statearr_16328_16374[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16324 === (4))){
var inst_16254 = (state_16323[(8)]);
var inst_16254__$1 = (state_16323[(2)]);
var inst_16255 = (inst_16254__$1 == null);
var state_16323__$1 = (function (){var statearr_16329 = state_16323;
(statearr_16329[(8)] = inst_16254__$1);

return statearr_16329;
})();
if(cljs.core.truth_(inst_16255)){
var statearr_16330_16375 = state_16323__$1;
(statearr_16330_16375[(1)] = (5));

} else {
var statearr_16331_16376 = state_16323__$1;
(statearr_16331_16376[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16324 === (15))){
var inst_16296 = (state_16323[(2)]);
var state_16323__$1 = state_16323;
var statearr_16332_16377 = state_16323__$1;
(statearr_16332_16377[(2)] = inst_16296);

(statearr_16332_16377[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16324 === (21))){
var inst_16316 = (state_16323[(2)]);
var state_16323__$1 = (function (){var statearr_16333 = state_16323;
(statearr_16333[(9)] = inst_16316);

return statearr_16333;
})();
var statearr_16334_16378 = state_16323__$1;
(statearr_16334_16378[(2)] = null);

(statearr_16334_16378[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16324 === (13))){
var inst_16278 = (state_16323[(10)]);
var inst_16280 = cljs.core.chunked_seq_QMARK_(inst_16278);
var state_16323__$1 = state_16323;
if(inst_16280){
var statearr_16335_16379 = state_16323__$1;
(statearr_16335_16379[(1)] = (16));

} else {
var statearr_16336_16380 = state_16323__$1;
(statearr_16336_16380[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16324 === (22))){
var inst_16308 = (state_16323[(2)]);
var state_16323__$1 = state_16323;
if(cljs.core.truth_(inst_16308)){
var statearr_16337_16381 = state_16323__$1;
(statearr_16337_16381[(1)] = (23));

} else {
var statearr_16338_16382 = state_16323__$1;
(statearr_16338_16382[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16324 === (6))){
var inst_16254 = (state_16323[(8)]);
var inst_16302 = (state_16323[(7)]);
var inst_16304 = (state_16323[(11)]);
var inst_16302__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_16254) : topic_fn.call(null,inst_16254));
var inst_16303 = cljs.core.deref(mults);
var inst_16304__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16303,inst_16302__$1);
var state_16323__$1 = (function (){var statearr_16339 = state_16323;
(statearr_16339[(7)] = inst_16302__$1);

(statearr_16339[(11)] = inst_16304__$1);

return statearr_16339;
})();
if(cljs.core.truth_(inst_16304__$1)){
var statearr_16340_16383 = state_16323__$1;
(statearr_16340_16383[(1)] = (19));

} else {
var statearr_16341_16384 = state_16323__$1;
(statearr_16341_16384[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16324 === (25))){
var inst_16313 = (state_16323[(2)]);
var state_16323__$1 = state_16323;
var statearr_16342_16385 = state_16323__$1;
(statearr_16342_16385[(2)] = inst_16313);

(statearr_16342_16385[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16324 === (17))){
var inst_16278 = (state_16323[(10)]);
var inst_16287 = cljs.core.first(inst_16278);
var inst_16288 = cljs.core.async.muxch_STAR_(inst_16287);
var inst_16289 = cljs.core.async.close_BANG_(inst_16288);
var inst_16290 = cljs.core.next(inst_16278);
var inst_16264 = inst_16290;
var inst_16265 = null;
var inst_16266 = (0);
var inst_16267 = (0);
var state_16323__$1 = (function (){var statearr_16343 = state_16323;
(statearr_16343[(12)] = inst_16267);

(statearr_16343[(13)] = inst_16265);

(statearr_16343[(14)] = inst_16289);

(statearr_16343[(15)] = inst_16264);

(statearr_16343[(16)] = inst_16266);

return statearr_16343;
})();
var statearr_16344_16386 = state_16323__$1;
(statearr_16344_16386[(2)] = null);

(statearr_16344_16386[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16324 === (3))){
var inst_16321 = (state_16323[(2)]);
var state_16323__$1 = state_16323;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16323__$1,inst_16321);
} else {
if((state_val_16324 === (12))){
var inst_16298 = (state_16323[(2)]);
var state_16323__$1 = state_16323;
var statearr_16345_16387 = state_16323__$1;
(statearr_16345_16387[(2)] = inst_16298);

(statearr_16345_16387[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16324 === (2))){
var state_16323__$1 = state_16323;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16323__$1,(4),ch);
} else {
if((state_val_16324 === (23))){
var state_16323__$1 = state_16323;
var statearr_16346_16388 = state_16323__$1;
(statearr_16346_16388[(2)] = null);

(statearr_16346_16388[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16324 === (19))){
var inst_16254 = (state_16323[(8)]);
var inst_16304 = (state_16323[(11)]);
var inst_16306 = cljs.core.async.muxch_STAR_(inst_16304);
var state_16323__$1 = state_16323;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16323__$1,(22),inst_16306,inst_16254);
} else {
if((state_val_16324 === (11))){
var inst_16264 = (state_16323[(15)]);
var inst_16278 = (state_16323[(10)]);
var inst_16278__$1 = cljs.core.seq(inst_16264);
var state_16323__$1 = (function (){var statearr_16347 = state_16323;
(statearr_16347[(10)] = inst_16278__$1);

return statearr_16347;
})();
if(inst_16278__$1){
var statearr_16348_16389 = state_16323__$1;
(statearr_16348_16389[(1)] = (13));

} else {
var statearr_16349_16390 = state_16323__$1;
(statearr_16349_16390[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16324 === (9))){
var inst_16300 = (state_16323[(2)]);
var state_16323__$1 = state_16323;
var statearr_16350_16391 = state_16323__$1;
(statearr_16350_16391[(2)] = inst_16300);

(statearr_16350_16391[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16324 === (5))){
var inst_16261 = cljs.core.deref(mults);
var inst_16262 = cljs.core.vals(inst_16261);
var inst_16263 = cljs.core.seq(inst_16262);
var inst_16264 = inst_16263;
var inst_16265 = null;
var inst_16266 = (0);
var inst_16267 = (0);
var state_16323__$1 = (function (){var statearr_16351 = state_16323;
(statearr_16351[(12)] = inst_16267);

(statearr_16351[(13)] = inst_16265);

(statearr_16351[(15)] = inst_16264);

(statearr_16351[(16)] = inst_16266);

return statearr_16351;
})();
var statearr_16352_16392 = state_16323__$1;
(statearr_16352_16392[(2)] = null);

(statearr_16352_16392[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16324 === (14))){
var state_16323__$1 = state_16323;
var statearr_16356_16393 = state_16323__$1;
(statearr_16356_16393[(2)] = null);

(statearr_16356_16393[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16324 === (16))){
var inst_16278 = (state_16323[(10)]);
var inst_16282 = cljs.core.chunk_first(inst_16278);
var inst_16283 = cljs.core.chunk_rest(inst_16278);
var inst_16284 = cljs.core.count(inst_16282);
var inst_16264 = inst_16283;
var inst_16265 = inst_16282;
var inst_16266 = inst_16284;
var inst_16267 = (0);
var state_16323__$1 = (function (){var statearr_16357 = state_16323;
(statearr_16357[(12)] = inst_16267);

(statearr_16357[(13)] = inst_16265);

(statearr_16357[(15)] = inst_16264);

(statearr_16357[(16)] = inst_16266);

return statearr_16357;
})();
var statearr_16358_16394 = state_16323__$1;
(statearr_16358_16394[(2)] = null);

(statearr_16358_16394[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16324 === (10))){
var inst_16267 = (state_16323[(12)]);
var inst_16265 = (state_16323[(13)]);
var inst_16264 = (state_16323[(15)]);
var inst_16266 = (state_16323[(16)]);
var inst_16272 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_16265,inst_16267);
var inst_16273 = cljs.core.async.muxch_STAR_(inst_16272);
var inst_16274 = cljs.core.async.close_BANG_(inst_16273);
var inst_16275 = (inst_16267 + (1));
var tmp16353 = inst_16265;
var tmp16354 = inst_16264;
var tmp16355 = inst_16266;
var inst_16264__$1 = tmp16354;
var inst_16265__$1 = tmp16353;
var inst_16266__$1 = tmp16355;
var inst_16267__$1 = inst_16275;
var state_16323__$1 = (function (){var statearr_16359 = state_16323;
(statearr_16359[(12)] = inst_16267__$1);

(statearr_16359[(13)] = inst_16265__$1);

(statearr_16359[(17)] = inst_16274);

(statearr_16359[(15)] = inst_16264__$1);

(statearr_16359[(16)] = inst_16266__$1);

return statearr_16359;
})();
var statearr_16360_16395 = state_16323__$1;
(statearr_16360_16395[(2)] = null);

(statearr_16360_16395[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16324 === (18))){
var inst_16293 = (state_16323[(2)]);
var state_16323__$1 = state_16323;
var statearr_16361_16396 = state_16323__$1;
(statearr_16361_16396[(2)] = inst_16293);

(statearr_16361_16396[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16324 === (8))){
var inst_16267 = (state_16323[(12)]);
var inst_16266 = (state_16323[(16)]);
var inst_16269 = (inst_16267 < inst_16266);
var inst_16270 = inst_16269;
var state_16323__$1 = state_16323;
if(cljs.core.truth_(inst_16270)){
var statearr_16362_16397 = state_16323__$1;
(statearr_16362_16397[(1)] = (10));

} else {
var statearr_16363_16398 = state_16323__$1;
(statearr_16363_16398[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__15091__auto__ = null;
var cljs$core$async$state_machine__15091__auto____0 = (function (){
var statearr_16364 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16364[(0)] = cljs$core$async$state_machine__15091__auto__);

(statearr_16364[(1)] = (1));

return statearr_16364;
});
var cljs$core$async$state_machine__15091__auto____1 = (function (state_16323){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_16323);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e16365){var ex__15094__auto__ = e16365;
var statearr_16366_16399 = state_16323;
(statearr_16366_16399[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_16323[(4)]))){
var statearr_16367_16400 = state_16323;
(statearr_16367_16400[(1)] = cljs.core.first((state_16323[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__16401 = state_16323;
state_16323 = G__16401;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
cljs$core$async$state_machine__15091__auto__ = function(state_16323){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__15091__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__15091__auto____1.call(this,state_16323);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__15091__auto____0;
cljs$core$async$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__15091__auto____1;
return cljs$core$async$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_16368 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_16368[(6)] = c__15165__auto___16370);

return statearr_16368;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__16403 = arguments.length;
switch (G__16403) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__16406 = arguments.length;
switch (G__16406) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__16409 = arguments.length;
switch (G__16409) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__15165__auto___16487 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_16452){
var state_val_16453 = (state_16452[(1)]);
if((state_val_16453 === (7))){
var state_16452__$1 = state_16452;
var statearr_16454_16488 = state_16452__$1;
(statearr_16454_16488[(2)] = null);

(statearr_16454_16488[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16453 === (1))){
var state_16452__$1 = state_16452;
var statearr_16455_16489 = state_16452__$1;
(statearr_16455_16489[(2)] = null);

(statearr_16455_16489[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16453 === (4))){
var inst_16412 = (state_16452[(7)]);
var inst_16413 = (state_16452[(8)]);
var inst_16415 = (inst_16413 < inst_16412);
var state_16452__$1 = state_16452;
if(cljs.core.truth_(inst_16415)){
var statearr_16456_16490 = state_16452__$1;
(statearr_16456_16490[(1)] = (6));

} else {
var statearr_16457_16491 = state_16452__$1;
(statearr_16457_16491[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16453 === (15))){
var inst_16438 = (state_16452[(9)]);
var inst_16443 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_16438);
var state_16452__$1 = state_16452;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16452__$1,(17),out,inst_16443);
} else {
if((state_val_16453 === (13))){
var inst_16438 = (state_16452[(9)]);
var inst_16438__$1 = (state_16452[(2)]);
var inst_16439 = cljs.core.some(cljs.core.nil_QMARK_,inst_16438__$1);
var state_16452__$1 = (function (){var statearr_16458 = state_16452;
(statearr_16458[(9)] = inst_16438__$1);

return statearr_16458;
})();
if(cljs.core.truth_(inst_16439)){
var statearr_16459_16492 = state_16452__$1;
(statearr_16459_16492[(1)] = (14));

} else {
var statearr_16460_16493 = state_16452__$1;
(statearr_16460_16493[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16453 === (6))){
var state_16452__$1 = state_16452;
var statearr_16461_16494 = state_16452__$1;
(statearr_16461_16494[(2)] = null);

(statearr_16461_16494[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16453 === (17))){
var inst_16445 = (state_16452[(2)]);
var state_16452__$1 = (function (){var statearr_16463 = state_16452;
(statearr_16463[(10)] = inst_16445);

return statearr_16463;
})();
var statearr_16464_16495 = state_16452__$1;
(statearr_16464_16495[(2)] = null);

(statearr_16464_16495[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16453 === (3))){
var inst_16450 = (state_16452[(2)]);
var state_16452__$1 = state_16452;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16452__$1,inst_16450);
} else {
if((state_val_16453 === (12))){
var _ = (function (){var statearr_16465 = state_16452;
(statearr_16465[(4)] = cljs.core.rest((state_16452[(4)])));

return statearr_16465;
})();
var state_16452__$1 = state_16452;
var ex16462 = (state_16452__$1[(2)]);
var statearr_16466_16496 = state_16452__$1;
(statearr_16466_16496[(5)] = ex16462);


if((ex16462 instanceof Object)){
var statearr_16467_16497 = state_16452__$1;
(statearr_16467_16497[(1)] = (11));

(statearr_16467_16497[(5)] = null);

} else {
throw ex16462;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16453 === (2))){
var inst_16411 = cljs.core.reset_BANG_(dctr,cnt);
var inst_16412 = cnt;
var inst_16413 = (0);
var state_16452__$1 = (function (){var statearr_16468 = state_16452;
(statearr_16468[(7)] = inst_16412);

(statearr_16468[(8)] = inst_16413);

(statearr_16468[(11)] = inst_16411);

return statearr_16468;
})();
var statearr_16469_16498 = state_16452__$1;
(statearr_16469_16498[(2)] = null);

(statearr_16469_16498[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16453 === (11))){
var inst_16417 = (state_16452[(2)]);
var inst_16418 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_16452__$1 = (function (){var statearr_16470 = state_16452;
(statearr_16470[(12)] = inst_16417);

return statearr_16470;
})();
var statearr_16471_16499 = state_16452__$1;
(statearr_16471_16499[(2)] = inst_16418);

(statearr_16471_16499[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16453 === (9))){
var inst_16413 = (state_16452[(8)]);
var _ = (function (){var statearr_16472 = state_16452;
(statearr_16472[(4)] = cljs.core.cons((12),(state_16452[(4)])));

return statearr_16472;
})();
var inst_16424 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_16413) : chs__$1.call(null,inst_16413));
var inst_16425 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_16413) : done.call(null,inst_16413));
var inst_16426 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_16424,inst_16425);
var ___$1 = (function (){var statearr_16473 = state_16452;
(statearr_16473[(4)] = cljs.core.rest((state_16452[(4)])));

return statearr_16473;
})();
var state_16452__$1 = state_16452;
var statearr_16474_16500 = state_16452__$1;
(statearr_16474_16500[(2)] = inst_16426);

(statearr_16474_16500[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16453 === (5))){
var inst_16436 = (state_16452[(2)]);
var state_16452__$1 = (function (){var statearr_16475 = state_16452;
(statearr_16475[(13)] = inst_16436);

return statearr_16475;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16452__$1,(13),dchan);
} else {
if((state_val_16453 === (14))){
var inst_16441 = cljs.core.async.close_BANG_(out);
var state_16452__$1 = state_16452;
var statearr_16476_16501 = state_16452__$1;
(statearr_16476_16501[(2)] = inst_16441);

(statearr_16476_16501[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16453 === (16))){
var inst_16448 = (state_16452[(2)]);
var state_16452__$1 = state_16452;
var statearr_16477_16502 = state_16452__$1;
(statearr_16477_16502[(2)] = inst_16448);

(statearr_16477_16502[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16453 === (10))){
var inst_16413 = (state_16452[(8)]);
var inst_16429 = (state_16452[(2)]);
var inst_16430 = (inst_16413 + (1));
var inst_16413__$1 = inst_16430;
var state_16452__$1 = (function (){var statearr_16478 = state_16452;
(statearr_16478[(8)] = inst_16413__$1);

(statearr_16478[(14)] = inst_16429);

return statearr_16478;
})();
var statearr_16479_16503 = state_16452__$1;
(statearr_16479_16503[(2)] = null);

(statearr_16479_16503[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16453 === (8))){
var inst_16434 = (state_16452[(2)]);
var state_16452__$1 = state_16452;
var statearr_16480_16504 = state_16452__$1;
(statearr_16480_16504[(2)] = inst_16434);

(statearr_16480_16504[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__15091__auto__ = null;
var cljs$core$async$state_machine__15091__auto____0 = (function (){
var statearr_16481 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16481[(0)] = cljs$core$async$state_machine__15091__auto__);

(statearr_16481[(1)] = (1));

return statearr_16481;
});
var cljs$core$async$state_machine__15091__auto____1 = (function (state_16452){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_16452);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e16482){var ex__15094__auto__ = e16482;
var statearr_16483_16505 = state_16452;
(statearr_16483_16505[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_16452[(4)]))){
var statearr_16484_16506 = state_16452;
(statearr_16484_16506[(1)] = cljs.core.first((state_16452[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__16507 = state_16452;
state_16452 = G__16507;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
cljs$core$async$state_machine__15091__auto__ = function(state_16452){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__15091__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__15091__auto____1.call(this,state_16452);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__15091__auto____0;
cljs$core$async$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__15091__auto____1;
return cljs$core$async$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_16485 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_16485[(6)] = c__15165__auto___16487);

return statearr_16485;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__16510 = arguments.length;
switch (G__16510) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__15165__auto___16565 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_16542){
var state_val_16543 = (state_16542[(1)]);
if((state_val_16543 === (7))){
var inst_16521 = (state_16542[(7)]);
var inst_16522 = (state_16542[(8)]);
var inst_16521__$1 = (state_16542[(2)]);
var inst_16522__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16521__$1,(0),null);
var inst_16523 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16521__$1,(1),null);
var inst_16524 = (inst_16522__$1 == null);
var state_16542__$1 = (function (){var statearr_16544 = state_16542;
(statearr_16544[(7)] = inst_16521__$1);

(statearr_16544[(9)] = inst_16523);

(statearr_16544[(8)] = inst_16522__$1);

return statearr_16544;
})();
if(cljs.core.truth_(inst_16524)){
var statearr_16545_16566 = state_16542__$1;
(statearr_16545_16566[(1)] = (8));

} else {
var statearr_16546_16567 = state_16542__$1;
(statearr_16546_16567[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16543 === (1))){
var inst_16511 = cljs.core.vec(chs);
var inst_16512 = inst_16511;
var state_16542__$1 = (function (){var statearr_16547 = state_16542;
(statearr_16547[(10)] = inst_16512);

return statearr_16547;
})();
var statearr_16548_16568 = state_16542__$1;
(statearr_16548_16568[(2)] = null);

(statearr_16548_16568[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16543 === (4))){
var inst_16512 = (state_16542[(10)]);
var state_16542__$1 = state_16542;
return cljs.core.async.ioc_alts_BANG_(state_16542__$1,(7),inst_16512);
} else {
if((state_val_16543 === (6))){
var inst_16538 = (state_16542[(2)]);
var state_16542__$1 = state_16542;
var statearr_16549_16569 = state_16542__$1;
(statearr_16549_16569[(2)] = inst_16538);

(statearr_16549_16569[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16543 === (3))){
var inst_16540 = (state_16542[(2)]);
var state_16542__$1 = state_16542;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16542__$1,inst_16540);
} else {
if((state_val_16543 === (2))){
var inst_16512 = (state_16542[(10)]);
var inst_16514 = cljs.core.count(inst_16512);
var inst_16515 = (inst_16514 > (0));
var state_16542__$1 = state_16542;
if(cljs.core.truth_(inst_16515)){
var statearr_16551_16570 = state_16542__$1;
(statearr_16551_16570[(1)] = (4));

} else {
var statearr_16552_16571 = state_16542__$1;
(statearr_16552_16571[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16543 === (11))){
var inst_16512 = (state_16542[(10)]);
var inst_16531 = (state_16542[(2)]);
var tmp16550 = inst_16512;
var inst_16512__$1 = tmp16550;
var state_16542__$1 = (function (){var statearr_16553 = state_16542;
(statearr_16553[(10)] = inst_16512__$1);

(statearr_16553[(11)] = inst_16531);

return statearr_16553;
})();
var statearr_16554_16572 = state_16542__$1;
(statearr_16554_16572[(2)] = null);

(statearr_16554_16572[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16543 === (9))){
var inst_16522 = (state_16542[(8)]);
var state_16542__$1 = state_16542;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16542__$1,(11),out,inst_16522);
} else {
if((state_val_16543 === (5))){
var inst_16536 = cljs.core.async.close_BANG_(out);
var state_16542__$1 = state_16542;
var statearr_16555_16573 = state_16542__$1;
(statearr_16555_16573[(2)] = inst_16536);

(statearr_16555_16573[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16543 === (10))){
var inst_16534 = (state_16542[(2)]);
var state_16542__$1 = state_16542;
var statearr_16556_16574 = state_16542__$1;
(statearr_16556_16574[(2)] = inst_16534);

(statearr_16556_16574[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16543 === (8))){
var inst_16512 = (state_16542[(10)]);
var inst_16521 = (state_16542[(7)]);
var inst_16523 = (state_16542[(9)]);
var inst_16522 = (state_16542[(8)]);
var inst_16526 = (function (){var cs = inst_16512;
var vec__16517 = inst_16521;
var v = inst_16522;
var c = inst_16523;
return (function (p1__16508_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__16508_SHARP_);
});
})();
var inst_16527 = cljs.core.filterv(inst_16526,inst_16512);
var inst_16512__$1 = inst_16527;
var state_16542__$1 = (function (){var statearr_16557 = state_16542;
(statearr_16557[(10)] = inst_16512__$1);

return statearr_16557;
})();
var statearr_16558_16575 = state_16542__$1;
(statearr_16558_16575[(2)] = null);

(statearr_16558_16575[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__15091__auto__ = null;
var cljs$core$async$state_machine__15091__auto____0 = (function (){
var statearr_16559 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16559[(0)] = cljs$core$async$state_machine__15091__auto__);

(statearr_16559[(1)] = (1));

return statearr_16559;
});
var cljs$core$async$state_machine__15091__auto____1 = (function (state_16542){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_16542);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e16560){var ex__15094__auto__ = e16560;
var statearr_16561_16576 = state_16542;
(statearr_16561_16576[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_16542[(4)]))){
var statearr_16562_16577 = state_16542;
(statearr_16562_16577[(1)] = cljs.core.first((state_16542[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__16578 = state_16542;
state_16542 = G__16578;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
cljs$core$async$state_machine__15091__auto__ = function(state_16542){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__15091__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__15091__auto____1.call(this,state_16542);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__15091__auto____0;
cljs$core$async$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__15091__auto____1;
return cljs$core$async$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_16563 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_16563[(6)] = c__15165__auto___16565);

return statearr_16563;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__16580 = arguments.length;
switch (G__16580) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__15165__auto___16626 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_16604){
var state_val_16605 = (state_16604[(1)]);
if((state_val_16605 === (7))){
var inst_16586 = (state_16604[(7)]);
var inst_16586__$1 = (state_16604[(2)]);
var inst_16587 = (inst_16586__$1 == null);
var inst_16588 = cljs.core.not(inst_16587);
var state_16604__$1 = (function (){var statearr_16606 = state_16604;
(statearr_16606[(7)] = inst_16586__$1);

return statearr_16606;
})();
if(inst_16588){
var statearr_16607_16627 = state_16604__$1;
(statearr_16607_16627[(1)] = (8));

} else {
var statearr_16608_16628 = state_16604__$1;
(statearr_16608_16628[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16605 === (1))){
var inst_16581 = (0);
var state_16604__$1 = (function (){var statearr_16609 = state_16604;
(statearr_16609[(8)] = inst_16581);

return statearr_16609;
})();
var statearr_16610_16629 = state_16604__$1;
(statearr_16610_16629[(2)] = null);

(statearr_16610_16629[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16605 === (4))){
var state_16604__$1 = state_16604;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16604__$1,(7),ch);
} else {
if((state_val_16605 === (6))){
var inst_16599 = (state_16604[(2)]);
var state_16604__$1 = state_16604;
var statearr_16611_16630 = state_16604__$1;
(statearr_16611_16630[(2)] = inst_16599);

(statearr_16611_16630[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16605 === (3))){
var inst_16601 = (state_16604[(2)]);
var inst_16602 = cljs.core.async.close_BANG_(out);
var state_16604__$1 = (function (){var statearr_16612 = state_16604;
(statearr_16612[(9)] = inst_16601);

return statearr_16612;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_16604__$1,inst_16602);
} else {
if((state_val_16605 === (2))){
var inst_16581 = (state_16604[(8)]);
var inst_16583 = (inst_16581 < n);
var state_16604__$1 = state_16604;
if(cljs.core.truth_(inst_16583)){
var statearr_16613_16631 = state_16604__$1;
(statearr_16613_16631[(1)] = (4));

} else {
var statearr_16614_16632 = state_16604__$1;
(statearr_16614_16632[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16605 === (11))){
var inst_16581 = (state_16604[(8)]);
var inst_16591 = (state_16604[(2)]);
var inst_16592 = (inst_16581 + (1));
var inst_16581__$1 = inst_16592;
var state_16604__$1 = (function (){var statearr_16615 = state_16604;
(statearr_16615[(8)] = inst_16581__$1);

(statearr_16615[(10)] = inst_16591);

return statearr_16615;
})();
var statearr_16616_16633 = state_16604__$1;
(statearr_16616_16633[(2)] = null);

(statearr_16616_16633[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16605 === (9))){
var state_16604__$1 = state_16604;
var statearr_16617_16634 = state_16604__$1;
(statearr_16617_16634[(2)] = null);

(statearr_16617_16634[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16605 === (5))){
var state_16604__$1 = state_16604;
var statearr_16618_16635 = state_16604__$1;
(statearr_16618_16635[(2)] = null);

(statearr_16618_16635[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16605 === (10))){
var inst_16596 = (state_16604[(2)]);
var state_16604__$1 = state_16604;
var statearr_16619_16636 = state_16604__$1;
(statearr_16619_16636[(2)] = inst_16596);

(statearr_16619_16636[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16605 === (8))){
var inst_16586 = (state_16604[(7)]);
var state_16604__$1 = state_16604;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16604__$1,(11),out,inst_16586);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__15091__auto__ = null;
var cljs$core$async$state_machine__15091__auto____0 = (function (){
var statearr_16620 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16620[(0)] = cljs$core$async$state_machine__15091__auto__);

(statearr_16620[(1)] = (1));

return statearr_16620;
});
var cljs$core$async$state_machine__15091__auto____1 = (function (state_16604){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_16604);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e16621){var ex__15094__auto__ = e16621;
var statearr_16622_16637 = state_16604;
(statearr_16622_16637[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_16604[(4)]))){
var statearr_16623_16638 = state_16604;
(statearr_16623_16638[(1)] = cljs.core.first((state_16604[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__16639 = state_16604;
state_16604 = G__16639;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
cljs$core$async$state_machine__15091__auto__ = function(state_16604){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__15091__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__15091__auto____1.call(this,state_16604);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__15091__auto____0;
cljs$core$async$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__15091__auto____1;
return cljs$core$async$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_16624 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_16624[(6)] = c__15165__auto___16626);

return statearr_16624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async16641 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16641 = (function (f,ch,meta16642){
this.f = f;
this.ch = ch;
this.meta16642 = meta16642;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16641.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16643,meta16642__$1){
var self__ = this;
var _16643__$1 = this;
return (new cljs.core.async.t_cljs$core$async16641(self__.f,self__.ch,meta16642__$1));
}));

(cljs.core.async.t_cljs$core$async16641.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16643){
var self__ = this;
var _16643__$1 = this;
return self__.meta16642;
}));

(cljs.core.async.t_cljs$core$async16641.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16641.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async16641.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async16641.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16641.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async16644 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16644 = (function (f,ch,meta16642,_,fn1,meta16645){
this.f = f;
this.ch = ch;
this.meta16642 = meta16642;
this._ = _;
this.fn1 = fn1;
this.meta16645 = meta16645;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16644.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16646,meta16645__$1){
var self__ = this;
var _16646__$1 = this;
return (new cljs.core.async.t_cljs$core$async16644(self__.f,self__.ch,self__.meta16642,self__._,self__.fn1,meta16645__$1));
}));

(cljs.core.async.t_cljs$core$async16644.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16646){
var self__ = this;
var _16646__$1 = this;
return self__.meta16645;
}));

(cljs.core.async.t_cljs$core$async16644.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16644.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async16644.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async16644.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__16640_SHARP_){
var G__16647 = (((p1__16640_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__16640_SHARP_) : self__.f.call(null,p1__16640_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__16647) : f1.call(null,G__16647));
});
}));

(cljs.core.async.t_cljs$core$async16644.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta16642,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async16641], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta16645], null);
}));

(cljs.core.async.t_cljs$core$async16644.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16644.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16644");

(cljs.core.async.t_cljs$core$async16644.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async16644");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16644.
 */
cljs.core.async.__GT_t_cljs$core$async16644 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16644(f__$1,ch__$1,meta16642__$1,___$2,fn1__$1,meta16645){
return (new cljs.core.async.t_cljs$core$async16644(f__$1,ch__$1,meta16642__$1,___$2,fn1__$1,meta16645));
});

}

return (new cljs.core.async.t_cljs$core$async16644(self__.f,self__.ch,self__.meta16642,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__5043__auto__ = ret;
if(cljs.core.truth_(and__5043__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5043__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__16648 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__16648) : self__.f.call(null,G__16648));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async16641.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16641.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async16641.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta16642], null);
}));

(cljs.core.async.t_cljs$core$async16641.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16641.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16641");

(cljs.core.async.t_cljs$core$async16641.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async16641");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16641.
 */
cljs.core.async.__GT_t_cljs$core$async16641 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16641(f__$1,ch__$1,meta16642){
return (new cljs.core.async.t_cljs$core$async16641(f__$1,ch__$1,meta16642));
});

}

return (new cljs.core.async.t_cljs$core$async16641(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async16649 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16649 = (function (f,ch,meta16650){
this.f = f;
this.ch = ch;
this.meta16650 = meta16650;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16649.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16651,meta16650__$1){
var self__ = this;
var _16651__$1 = this;
return (new cljs.core.async.t_cljs$core$async16649(self__.f,self__.ch,meta16650__$1));
}));

(cljs.core.async.t_cljs$core$async16649.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16651){
var self__ = this;
var _16651__$1 = this;
return self__.meta16650;
}));

(cljs.core.async.t_cljs$core$async16649.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16649.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async16649.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16649.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async16649.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16649.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async16649.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta16650], null);
}));

(cljs.core.async.t_cljs$core$async16649.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16649.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16649");

(cljs.core.async.t_cljs$core$async16649.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async16649");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16649.
 */
cljs.core.async.__GT_t_cljs$core$async16649 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async16649(f__$1,ch__$1,meta16650){
return (new cljs.core.async.t_cljs$core$async16649(f__$1,ch__$1,meta16650));
});

}

return (new cljs.core.async.t_cljs$core$async16649(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async16652 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16652 = (function (p,ch,meta16653){
this.p = p;
this.ch = ch;
this.meta16653 = meta16653;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16652.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16654,meta16653__$1){
var self__ = this;
var _16654__$1 = this;
return (new cljs.core.async.t_cljs$core$async16652(self__.p,self__.ch,meta16653__$1));
}));

(cljs.core.async.t_cljs$core$async16652.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16654){
var self__ = this;
var _16654__$1 = this;
return self__.meta16653;
}));

(cljs.core.async.t_cljs$core$async16652.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16652.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async16652.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async16652.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16652.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async16652.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16652.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async16652.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta16653], null);
}));

(cljs.core.async.t_cljs$core$async16652.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16652.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16652");

(cljs.core.async.t_cljs$core$async16652.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async16652");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16652.
 */
cljs.core.async.__GT_t_cljs$core$async16652 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async16652(p__$1,ch__$1,meta16653){
return (new cljs.core.async.t_cljs$core$async16652(p__$1,ch__$1,meta16653));
});

}

return (new cljs.core.async.t_cljs$core$async16652(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__16656 = arguments.length;
switch (G__16656) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__15165__auto___16697 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_16677){
var state_val_16678 = (state_16677[(1)]);
if((state_val_16678 === (7))){
var inst_16673 = (state_16677[(2)]);
var state_16677__$1 = state_16677;
var statearr_16679_16698 = state_16677__$1;
(statearr_16679_16698[(2)] = inst_16673);

(statearr_16679_16698[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16678 === (1))){
var state_16677__$1 = state_16677;
var statearr_16680_16699 = state_16677__$1;
(statearr_16680_16699[(2)] = null);

(statearr_16680_16699[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16678 === (4))){
var inst_16659 = (state_16677[(7)]);
var inst_16659__$1 = (state_16677[(2)]);
var inst_16660 = (inst_16659__$1 == null);
var state_16677__$1 = (function (){var statearr_16681 = state_16677;
(statearr_16681[(7)] = inst_16659__$1);

return statearr_16681;
})();
if(cljs.core.truth_(inst_16660)){
var statearr_16682_16700 = state_16677__$1;
(statearr_16682_16700[(1)] = (5));

} else {
var statearr_16683_16701 = state_16677__$1;
(statearr_16683_16701[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16678 === (6))){
var inst_16659 = (state_16677[(7)]);
var inst_16664 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_16659) : p.call(null,inst_16659));
var state_16677__$1 = state_16677;
if(cljs.core.truth_(inst_16664)){
var statearr_16684_16702 = state_16677__$1;
(statearr_16684_16702[(1)] = (8));

} else {
var statearr_16685_16703 = state_16677__$1;
(statearr_16685_16703[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16678 === (3))){
var inst_16675 = (state_16677[(2)]);
var state_16677__$1 = state_16677;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16677__$1,inst_16675);
} else {
if((state_val_16678 === (2))){
var state_16677__$1 = state_16677;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16677__$1,(4),ch);
} else {
if((state_val_16678 === (11))){
var inst_16667 = (state_16677[(2)]);
var state_16677__$1 = state_16677;
var statearr_16686_16704 = state_16677__$1;
(statearr_16686_16704[(2)] = inst_16667);

(statearr_16686_16704[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16678 === (9))){
var state_16677__$1 = state_16677;
var statearr_16687_16705 = state_16677__$1;
(statearr_16687_16705[(2)] = null);

(statearr_16687_16705[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16678 === (5))){
var inst_16662 = cljs.core.async.close_BANG_(out);
var state_16677__$1 = state_16677;
var statearr_16688_16706 = state_16677__$1;
(statearr_16688_16706[(2)] = inst_16662);

(statearr_16688_16706[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16678 === (10))){
var inst_16670 = (state_16677[(2)]);
var state_16677__$1 = (function (){var statearr_16689 = state_16677;
(statearr_16689[(8)] = inst_16670);

return statearr_16689;
})();
var statearr_16690_16707 = state_16677__$1;
(statearr_16690_16707[(2)] = null);

(statearr_16690_16707[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16678 === (8))){
var inst_16659 = (state_16677[(7)]);
var state_16677__$1 = state_16677;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16677__$1,(11),out,inst_16659);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__15091__auto__ = null;
var cljs$core$async$state_machine__15091__auto____0 = (function (){
var statearr_16691 = [null,null,null,null,null,null,null,null,null];
(statearr_16691[(0)] = cljs$core$async$state_machine__15091__auto__);

(statearr_16691[(1)] = (1));

return statearr_16691;
});
var cljs$core$async$state_machine__15091__auto____1 = (function (state_16677){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_16677);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e16692){var ex__15094__auto__ = e16692;
var statearr_16693_16708 = state_16677;
(statearr_16693_16708[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_16677[(4)]))){
var statearr_16694_16709 = state_16677;
(statearr_16694_16709[(1)] = cljs.core.first((state_16677[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__16710 = state_16677;
state_16677 = G__16710;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
cljs$core$async$state_machine__15091__auto__ = function(state_16677){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__15091__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__15091__auto____1.call(this,state_16677);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__15091__auto____0;
cljs$core$async$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__15091__auto____1;
return cljs$core$async$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_16695 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_16695[(6)] = c__15165__auto___16697);

return statearr_16695;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__16712 = arguments.length;
switch (G__16712) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_16775){
var state_val_16776 = (state_16775[(1)]);
if((state_val_16776 === (7))){
var inst_16771 = (state_16775[(2)]);
var state_16775__$1 = state_16775;
var statearr_16777_16816 = state_16775__$1;
(statearr_16777_16816[(2)] = inst_16771);

(statearr_16777_16816[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16776 === (20))){
var inst_16741 = (state_16775[(7)]);
var inst_16752 = (state_16775[(2)]);
var inst_16753 = cljs.core.next(inst_16741);
var inst_16727 = inst_16753;
var inst_16728 = null;
var inst_16729 = (0);
var inst_16730 = (0);
var state_16775__$1 = (function (){var statearr_16778 = state_16775;
(statearr_16778[(8)] = inst_16729);

(statearr_16778[(9)] = inst_16727);

(statearr_16778[(10)] = inst_16728);

(statearr_16778[(11)] = inst_16752);

(statearr_16778[(12)] = inst_16730);

return statearr_16778;
})();
var statearr_16779_16817 = state_16775__$1;
(statearr_16779_16817[(2)] = null);

(statearr_16779_16817[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16776 === (1))){
var state_16775__$1 = state_16775;
var statearr_16780_16818 = state_16775__$1;
(statearr_16780_16818[(2)] = null);

(statearr_16780_16818[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16776 === (4))){
var inst_16716 = (state_16775[(13)]);
var inst_16716__$1 = (state_16775[(2)]);
var inst_16717 = (inst_16716__$1 == null);
var state_16775__$1 = (function (){var statearr_16781 = state_16775;
(statearr_16781[(13)] = inst_16716__$1);

return statearr_16781;
})();
if(cljs.core.truth_(inst_16717)){
var statearr_16782_16819 = state_16775__$1;
(statearr_16782_16819[(1)] = (5));

} else {
var statearr_16783_16820 = state_16775__$1;
(statearr_16783_16820[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16776 === (15))){
var state_16775__$1 = state_16775;
var statearr_16787_16821 = state_16775__$1;
(statearr_16787_16821[(2)] = null);

(statearr_16787_16821[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16776 === (21))){
var state_16775__$1 = state_16775;
var statearr_16788_16822 = state_16775__$1;
(statearr_16788_16822[(2)] = null);

(statearr_16788_16822[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16776 === (13))){
var inst_16729 = (state_16775[(8)]);
var inst_16727 = (state_16775[(9)]);
var inst_16728 = (state_16775[(10)]);
var inst_16730 = (state_16775[(12)]);
var inst_16737 = (state_16775[(2)]);
var inst_16738 = (inst_16730 + (1));
var tmp16784 = inst_16729;
var tmp16785 = inst_16727;
var tmp16786 = inst_16728;
var inst_16727__$1 = tmp16785;
var inst_16728__$1 = tmp16786;
var inst_16729__$1 = tmp16784;
var inst_16730__$1 = inst_16738;
var state_16775__$1 = (function (){var statearr_16789 = state_16775;
(statearr_16789[(14)] = inst_16737);

(statearr_16789[(8)] = inst_16729__$1);

(statearr_16789[(9)] = inst_16727__$1);

(statearr_16789[(10)] = inst_16728__$1);

(statearr_16789[(12)] = inst_16730__$1);

return statearr_16789;
})();
var statearr_16790_16823 = state_16775__$1;
(statearr_16790_16823[(2)] = null);

(statearr_16790_16823[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16776 === (22))){
var state_16775__$1 = state_16775;
var statearr_16791_16824 = state_16775__$1;
(statearr_16791_16824[(2)] = null);

(statearr_16791_16824[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16776 === (6))){
var inst_16716 = (state_16775[(13)]);
var inst_16725 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_16716) : f.call(null,inst_16716));
var inst_16726 = cljs.core.seq(inst_16725);
var inst_16727 = inst_16726;
var inst_16728 = null;
var inst_16729 = (0);
var inst_16730 = (0);
var state_16775__$1 = (function (){var statearr_16792 = state_16775;
(statearr_16792[(8)] = inst_16729);

(statearr_16792[(9)] = inst_16727);

(statearr_16792[(10)] = inst_16728);

(statearr_16792[(12)] = inst_16730);

return statearr_16792;
})();
var statearr_16793_16825 = state_16775__$1;
(statearr_16793_16825[(2)] = null);

(statearr_16793_16825[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16776 === (17))){
var inst_16741 = (state_16775[(7)]);
var inst_16745 = cljs.core.chunk_first(inst_16741);
var inst_16746 = cljs.core.chunk_rest(inst_16741);
var inst_16747 = cljs.core.count(inst_16745);
var inst_16727 = inst_16746;
var inst_16728 = inst_16745;
var inst_16729 = inst_16747;
var inst_16730 = (0);
var state_16775__$1 = (function (){var statearr_16794 = state_16775;
(statearr_16794[(8)] = inst_16729);

(statearr_16794[(9)] = inst_16727);

(statearr_16794[(10)] = inst_16728);

(statearr_16794[(12)] = inst_16730);

return statearr_16794;
})();
var statearr_16795_16826 = state_16775__$1;
(statearr_16795_16826[(2)] = null);

(statearr_16795_16826[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16776 === (3))){
var inst_16773 = (state_16775[(2)]);
var state_16775__$1 = state_16775;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16775__$1,inst_16773);
} else {
if((state_val_16776 === (12))){
var inst_16761 = (state_16775[(2)]);
var state_16775__$1 = state_16775;
var statearr_16796_16827 = state_16775__$1;
(statearr_16796_16827[(2)] = inst_16761);

(statearr_16796_16827[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16776 === (2))){
var state_16775__$1 = state_16775;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16775__$1,(4),in$);
} else {
if((state_val_16776 === (23))){
var inst_16769 = (state_16775[(2)]);
var state_16775__$1 = state_16775;
var statearr_16797_16828 = state_16775__$1;
(statearr_16797_16828[(2)] = inst_16769);

(statearr_16797_16828[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16776 === (19))){
var inst_16756 = (state_16775[(2)]);
var state_16775__$1 = state_16775;
var statearr_16798_16829 = state_16775__$1;
(statearr_16798_16829[(2)] = inst_16756);

(statearr_16798_16829[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16776 === (11))){
var inst_16741 = (state_16775[(7)]);
var inst_16727 = (state_16775[(9)]);
var inst_16741__$1 = cljs.core.seq(inst_16727);
var state_16775__$1 = (function (){var statearr_16799 = state_16775;
(statearr_16799[(7)] = inst_16741__$1);

return statearr_16799;
})();
if(inst_16741__$1){
var statearr_16800_16830 = state_16775__$1;
(statearr_16800_16830[(1)] = (14));

} else {
var statearr_16801_16831 = state_16775__$1;
(statearr_16801_16831[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16776 === (9))){
var inst_16763 = (state_16775[(2)]);
var inst_16764 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_16775__$1 = (function (){var statearr_16802 = state_16775;
(statearr_16802[(15)] = inst_16763);

return statearr_16802;
})();
if(cljs.core.truth_(inst_16764)){
var statearr_16803_16832 = state_16775__$1;
(statearr_16803_16832[(1)] = (21));

} else {
var statearr_16804_16833 = state_16775__$1;
(statearr_16804_16833[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16776 === (5))){
var inst_16719 = cljs.core.async.close_BANG_(out);
var state_16775__$1 = state_16775;
var statearr_16805_16834 = state_16775__$1;
(statearr_16805_16834[(2)] = inst_16719);

(statearr_16805_16834[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16776 === (14))){
var inst_16741 = (state_16775[(7)]);
var inst_16743 = cljs.core.chunked_seq_QMARK_(inst_16741);
var state_16775__$1 = state_16775;
if(inst_16743){
var statearr_16806_16835 = state_16775__$1;
(statearr_16806_16835[(1)] = (17));

} else {
var statearr_16807_16836 = state_16775__$1;
(statearr_16807_16836[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16776 === (16))){
var inst_16759 = (state_16775[(2)]);
var state_16775__$1 = state_16775;
var statearr_16808_16837 = state_16775__$1;
(statearr_16808_16837[(2)] = inst_16759);

(statearr_16808_16837[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16776 === (10))){
var inst_16728 = (state_16775[(10)]);
var inst_16730 = (state_16775[(12)]);
var inst_16735 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_16728,inst_16730);
var state_16775__$1 = state_16775;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16775__$1,(13),out,inst_16735);
} else {
if((state_val_16776 === (18))){
var inst_16741 = (state_16775[(7)]);
var inst_16750 = cljs.core.first(inst_16741);
var state_16775__$1 = state_16775;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16775__$1,(20),out,inst_16750);
} else {
if((state_val_16776 === (8))){
var inst_16729 = (state_16775[(8)]);
var inst_16730 = (state_16775[(12)]);
var inst_16732 = (inst_16730 < inst_16729);
var inst_16733 = inst_16732;
var state_16775__$1 = state_16775;
if(cljs.core.truth_(inst_16733)){
var statearr_16809_16838 = state_16775__$1;
(statearr_16809_16838[(1)] = (10));

} else {
var statearr_16810_16839 = state_16775__$1;
(statearr_16810_16839[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__15091__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__15091__auto____0 = (function (){
var statearr_16811 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16811[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__15091__auto__);

(statearr_16811[(1)] = (1));

return statearr_16811;
});
var cljs$core$async$mapcat_STAR__$_state_machine__15091__auto____1 = (function (state_16775){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_16775);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e16812){var ex__15094__auto__ = e16812;
var statearr_16813_16840 = state_16775;
(statearr_16813_16840[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_16775[(4)]))){
var statearr_16814_16841 = state_16775;
(statearr_16814_16841[(1)] = cljs.core.first((state_16775[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__16842 = state_16775;
state_16775 = G__16842;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__15091__auto__ = function(state_16775){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__15091__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__15091__auto____1.call(this,state_16775);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__15091__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__15091__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_16815 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_16815[(6)] = c__15165__auto__);

return statearr_16815;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__16844 = arguments.length;
switch (G__16844) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__16847 = arguments.length;
switch (G__16847) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__16850 = arguments.length;
switch (G__16850) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__15165__auto___16898 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_16874){
var state_val_16875 = (state_16874[(1)]);
if((state_val_16875 === (7))){
var inst_16869 = (state_16874[(2)]);
var state_16874__$1 = state_16874;
var statearr_16876_16899 = state_16874__$1;
(statearr_16876_16899[(2)] = inst_16869);

(statearr_16876_16899[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16875 === (1))){
var inst_16851 = null;
var state_16874__$1 = (function (){var statearr_16877 = state_16874;
(statearr_16877[(7)] = inst_16851);

return statearr_16877;
})();
var statearr_16878_16900 = state_16874__$1;
(statearr_16878_16900[(2)] = null);

(statearr_16878_16900[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16875 === (4))){
var inst_16854 = (state_16874[(8)]);
var inst_16854__$1 = (state_16874[(2)]);
var inst_16855 = (inst_16854__$1 == null);
var inst_16856 = cljs.core.not(inst_16855);
var state_16874__$1 = (function (){var statearr_16879 = state_16874;
(statearr_16879[(8)] = inst_16854__$1);

return statearr_16879;
})();
if(inst_16856){
var statearr_16880_16901 = state_16874__$1;
(statearr_16880_16901[(1)] = (5));

} else {
var statearr_16881_16902 = state_16874__$1;
(statearr_16881_16902[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16875 === (6))){
var state_16874__$1 = state_16874;
var statearr_16882_16903 = state_16874__$1;
(statearr_16882_16903[(2)] = null);

(statearr_16882_16903[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16875 === (3))){
var inst_16871 = (state_16874[(2)]);
var inst_16872 = cljs.core.async.close_BANG_(out);
var state_16874__$1 = (function (){var statearr_16883 = state_16874;
(statearr_16883[(9)] = inst_16871);

return statearr_16883;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_16874__$1,inst_16872);
} else {
if((state_val_16875 === (2))){
var state_16874__$1 = state_16874;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16874__$1,(4),ch);
} else {
if((state_val_16875 === (11))){
var inst_16854 = (state_16874[(8)]);
var inst_16863 = (state_16874[(2)]);
var inst_16851 = inst_16854;
var state_16874__$1 = (function (){var statearr_16884 = state_16874;
(statearr_16884[(7)] = inst_16851);

(statearr_16884[(10)] = inst_16863);

return statearr_16884;
})();
var statearr_16885_16904 = state_16874__$1;
(statearr_16885_16904[(2)] = null);

(statearr_16885_16904[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16875 === (9))){
var inst_16854 = (state_16874[(8)]);
var state_16874__$1 = state_16874;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16874__$1,(11),out,inst_16854);
} else {
if((state_val_16875 === (5))){
var inst_16851 = (state_16874[(7)]);
var inst_16854 = (state_16874[(8)]);
var inst_16858 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_16854,inst_16851);
var state_16874__$1 = state_16874;
if(inst_16858){
var statearr_16887_16905 = state_16874__$1;
(statearr_16887_16905[(1)] = (8));

} else {
var statearr_16888_16906 = state_16874__$1;
(statearr_16888_16906[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16875 === (10))){
var inst_16866 = (state_16874[(2)]);
var state_16874__$1 = state_16874;
var statearr_16889_16907 = state_16874__$1;
(statearr_16889_16907[(2)] = inst_16866);

(statearr_16889_16907[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16875 === (8))){
var inst_16851 = (state_16874[(7)]);
var tmp16886 = inst_16851;
var inst_16851__$1 = tmp16886;
var state_16874__$1 = (function (){var statearr_16890 = state_16874;
(statearr_16890[(7)] = inst_16851__$1);

return statearr_16890;
})();
var statearr_16891_16908 = state_16874__$1;
(statearr_16891_16908[(2)] = null);

(statearr_16891_16908[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__15091__auto__ = null;
var cljs$core$async$state_machine__15091__auto____0 = (function (){
var statearr_16892 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16892[(0)] = cljs$core$async$state_machine__15091__auto__);

(statearr_16892[(1)] = (1));

return statearr_16892;
});
var cljs$core$async$state_machine__15091__auto____1 = (function (state_16874){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_16874);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e16893){var ex__15094__auto__ = e16893;
var statearr_16894_16909 = state_16874;
(statearr_16894_16909[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_16874[(4)]))){
var statearr_16895_16910 = state_16874;
(statearr_16895_16910[(1)] = cljs.core.first((state_16874[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__16911 = state_16874;
state_16874 = G__16911;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
cljs$core$async$state_machine__15091__auto__ = function(state_16874){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__15091__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__15091__auto____1.call(this,state_16874);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__15091__auto____0;
cljs$core$async$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__15091__auto____1;
return cljs$core$async$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_16896 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_16896[(6)] = c__15165__auto___16898);

return statearr_16896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__16913 = arguments.length;
switch (G__16913) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__15165__auto___16980 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_16951){
var state_val_16952 = (state_16951[(1)]);
if((state_val_16952 === (7))){
var inst_16947 = (state_16951[(2)]);
var state_16951__$1 = state_16951;
var statearr_16953_16981 = state_16951__$1;
(statearr_16953_16981[(2)] = inst_16947);

(statearr_16953_16981[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16952 === (1))){
var inst_16914 = (new Array(n));
var inst_16915 = inst_16914;
var inst_16916 = (0);
var state_16951__$1 = (function (){var statearr_16954 = state_16951;
(statearr_16954[(7)] = inst_16916);

(statearr_16954[(8)] = inst_16915);

return statearr_16954;
})();
var statearr_16955_16982 = state_16951__$1;
(statearr_16955_16982[(2)] = null);

(statearr_16955_16982[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16952 === (4))){
var inst_16919 = (state_16951[(9)]);
var inst_16919__$1 = (state_16951[(2)]);
var inst_16920 = (inst_16919__$1 == null);
var inst_16921 = cljs.core.not(inst_16920);
var state_16951__$1 = (function (){var statearr_16956 = state_16951;
(statearr_16956[(9)] = inst_16919__$1);

return statearr_16956;
})();
if(inst_16921){
var statearr_16957_16983 = state_16951__$1;
(statearr_16957_16983[(1)] = (5));

} else {
var statearr_16958_16984 = state_16951__$1;
(statearr_16958_16984[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16952 === (15))){
var inst_16941 = (state_16951[(2)]);
var state_16951__$1 = state_16951;
var statearr_16959_16985 = state_16951__$1;
(statearr_16959_16985[(2)] = inst_16941);

(statearr_16959_16985[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16952 === (13))){
var state_16951__$1 = state_16951;
var statearr_16960_16986 = state_16951__$1;
(statearr_16960_16986[(2)] = null);

(statearr_16960_16986[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16952 === (6))){
var inst_16916 = (state_16951[(7)]);
var inst_16937 = (inst_16916 > (0));
var state_16951__$1 = state_16951;
if(cljs.core.truth_(inst_16937)){
var statearr_16961_16987 = state_16951__$1;
(statearr_16961_16987[(1)] = (12));

} else {
var statearr_16962_16988 = state_16951__$1;
(statearr_16962_16988[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16952 === (3))){
var inst_16949 = (state_16951[(2)]);
var state_16951__$1 = state_16951;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16951__$1,inst_16949);
} else {
if((state_val_16952 === (12))){
var inst_16915 = (state_16951[(8)]);
var inst_16939 = cljs.core.vec(inst_16915);
var state_16951__$1 = state_16951;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16951__$1,(15),out,inst_16939);
} else {
if((state_val_16952 === (2))){
var state_16951__$1 = state_16951;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16951__$1,(4),ch);
} else {
if((state_val_16952 === (11))){
var inst_16931 = (state_16951[(2)]);
var inst_16932 = (new Array(n));
var inst_16915 = inst_16932;
var inst_16916 = (0);
var state_16951__$1 = (function (){var statearr_16963 = state_16951;
(statearr_16963[(7)] = inst_16916);

(statearr_16963[(10)] = inst_16931);

(statearr_16963[(8)] = inst_16915);

return statearr_16963;
})();
var statearr_16964_16989 = state_16951__$1;
(statearr_16964_16989[(2)] = null);

(statearr_16964_16989[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16952 === (9))){
var inst_16915 = (state_16951[(8)]);
var inst_16929 = cljs.core.vec(inst_16915);
var state_16951__$1 = state_16951;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16951__$1,(11),out,inst_16929);
} else {
if((state_val_16952 === (5))){
var inst_16924 = (state_16951[(11)]);
var inst_16916 = (state_16951[(7)]);
var inst_16919 = (state_16951[(9)]);
var inst_16915 = (state_16951[(8)]);
var inst_16923 = (inst_16915[inst_16916] = inst_16919);
var inst_16924__$1 = (inst_16916 + (1));
var inst_16925 = (inst_16924__$1 < n);
var state_16951__$1 = (function (){var statearr_16965 = state_16951;
(statearr_16965[(11)] = inst_16924__$1);

(statearr_16965[(12)] = inst_16923);

return statearr_16965;
})();
if(cljs.core.truth_(inst_16925)){
var statearr_16966_16990 = state_16951__$1;
(statearr_16966_16990[(1)] = (8));

} else {
var statearr_16967_16991 = state_16951__$1;
(statearr_16967_16991[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16952 === (14))){
var inst_16944 = (state_16951[(2)]);
var inst_16945 = cljs.core.async.close_BANG_(out);
var state_16951__$1 = (function (){var statearr_16969 = state_16951;
(statearr_16969[(13)] = inst_16944);

return statearr_16969;
})();
var statearr_16970_16992 = state_16951__$1;
(statearr_16970_16992[(2)] = inst_16945);

(statearr_16970_16992[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16952 === (10))){
var inst_16935 = (state_16951[(2)]);
var state_16951__$1 = state_16951;
var statearr_16971_16993 = state_16951__$1;
(statearr_16971_16993[(2)] = inst_16935);

(statearr_16971_16993[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16952 === (8))){
var inst_16924 = (state_16951[(11)]);
var inst_16915 = (state_16951[(8)]);
var tmp16968 = inst_16915;
var inst_16915__$1 = tmp16968;
var inst_16916 = inst_16924;
var state_16951__$1 = (function (){var statearr_16972 = state_16951;
(statearr_16972[(7)] = inst_16916);

(statearr_16972[(8)] = inst_16915__$1);

return statearr_16972;
})();
var statearr_16973_16994 = state_16951__$1;
(statearr_16973_16994[(2)] = null);

(statearr_16973_16994[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__15091__auto__ = null;
var cljs$core$async$state_machine__15091__auto____0 = (function (){
var statearr_16974 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16974[(0)] = cljs$core$async$state_machine__15091__auto__);

(statearr_16974[(1)] = (1));

return statearr_16974;
});
var cljs$core$async$state_machine__15091__auto____1 = (function (state_16951){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_16951);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e16975){var ex__15094__auto__ = e16975;
var statearr_16976_16995 = state_16951;
(statearr_16976_16995[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_16951[(4)]))){
var statearr_16977_16996 = state_16951;
(statearr_16977_16996[(1)] = cljs.core.first((state_16951[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__16997 = state_16951;
state_16951 = G__16997;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
cljs$core$async$state_machine__15091__auto__ = function(state_16951){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__15091__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__15091__auto____1.call(this,state_16951);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__15091__auto____0;
cljs$core$async$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__15091__auto____1;
return cljs$core$async$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_16978 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_16978[(6)] = c__15165__auto___16980);

return statearr_16978;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__16999 = arguments.length;
switch (G__16999) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__15165__auto___17077 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_17044){
var state_val_17045 = (state_17044[(1)]);
if((state_val_17045 === (7))){
var inst_17040 = (state_17044[(2)]);
var state_17044__$1 = state_17044;
var statearr_17046_17078 = state_17044__$1;
(statearr_17046_17078[(2)] = inst_17040);

(statearr_17046_17078[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17045 === (1))){
var inst_17000 = [];
var inst_17001 = inst_17000;
var inst_17002 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_17044__$1 = (function (){var statearr_17047 = state_17044;
(statearr_17047[(7)] = inst_17001);

(statearr_17047[(8)] = inst_17002);

return statearr_17047;
})();
var statearr_17048_17079 = state_17044__$1;
(statearr_17048_17079[(2)] = null);

(statearr_17048_17079[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17045 === (4))){
var inst_17005 = (state_17044[(9)]);
var inst_17005__$1 = (state_17044[(2)]);
var inst_17006 = (inst_17005__$1 == null);
var inst_17007 = cljs.core.not(inst_17006);
var state_17044__$1 = (function (){var statearr_17049 = state_17044;
(statearr_17049[(9)] = inst_17005__$1);

return statearr_17049;
})();
if(inst_17007){
var statearr_17050_17080 = state_17044__$1;
(statearr_17050_17080[(1)] = (5));

} else {
var statearr_17051_17081 = state_17044__$1;
(statearr_17051_17081[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17045 === (15))){
var inst_17001 = (state_17044[(7)]);
var inst_17032 = cljs.core.vec(inst_17001);
var state_17044__$1 = state_17044;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17044__$1,(18),out,inst_17032);
} else {
if((state_val_17045 === (13))){
var inst_17027 = (state_17044[(2)]);
var state_17044__$1 = state_17044;
var statearr_17052_17082 = state_17044__$1;
(statearr_17052_17082[(2)] = inst_17027);

(statearr_17052_17082[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17045 === (6))){
var inst_17001 = (state_17044[(7)]);
var inst_17029 = inst_17001.length;
var inst_17030 = (inst_17029 > (0));
var state_17044__$1 = state_17044;
if(cljs.core.truth_(inst_17030)){
var statearr_17053_17083 = state_17044__$1;
(statearr_17053_17083[(1)] = (15));

} else {
var statearr_17054_17084 = state_17044__$1;
(statearr_17054_17084[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17045 === (17))){
var inst_17037 = (state_17044[(2)]);
var inst_17038 = cljs.core.async.close_BANG_(out);
var state_17044__$1 = (function (){var statearr_17055 = state_17044;
(statearr_17055[(10)] = inst_17037);

return statearr_17055;
})();
var statearr_17056_17085 = state_17044__$1;
(statearr_17056_17085[(2)] = inst_17038);

(statearr_17056_17085[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17045 === (3))){
var inst_17042 = (state_17044[(2)]);
var state_17044__$1 = state_17044;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17044__$1,inst_17042);
} else {
if((state_val_17045 === (12))){
var inst_17001 = (state_17044[(7)]);
var inst_17020 = cljs.core.vec(inst_17001);
var state_17044__$1 = state_17044;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17044__$1,(14),out,inst_17020);
} else {
if((state_val_17045 === (2))){
var state_17044__$1 = state_17044;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17044__$1,(4),ch);
} else {
if((state_val_17045 === (11))){
var inst_17001 = (state_17044[(7)]);
var inst_17009 = (state_17044[(11)]);
var inst_17005 = (state_17044[(9)]);
var inst_17017 = inst_17001.push(inst_17005);
var tmp17057 = inst_17001;
var inst_17001__$1 = tmp17057;
var inst_17002 = inst_17009;
var state_17044__$1 = (function (){var statearr_17058 = state_17044;
(statearr_17058[(7)] = inst_17001__$1);

(statearr_17058[(12)] = inst_17017);

(statearr_17058[(8)] = inst_17002);

return statearr_17058;
})();
var statearr_17059_17086 = state_17044__$1;
(statearr_17059_17086[(2)] = null);

(statearr_17059_17086[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17045 === (9))){
var inst_17002 = (state_17044[(8)]);
var inst_17013 = cljs.core.keyword_identical_QMARK_(inst_17002,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var state_17044__$1 = state_17044;
var statearr_17060_17087 = state_17044__$1;
(statearr_17060_17087[(2)] = inst_17013);

(statearr_17060_17087[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17045 === (5))){
var inst_17002 = (state_17044[(8)]);
var inst_17009 = (state_17044[(11)]);
var inst_17010 = (state_17044[(13)]);
var inst_17005 = (state_17044[(9)]);
var inst_17009__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_17005) : f.call(null,inst_17005));
var inst_17010__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17009__$1,inst_17002);
var state_17044__$1 = (function (){var statearr_17061 = state_17044;
(statearr_17061[(11)] = inst_17009__$1);

(statearr_17061[(13)] = inst_17010__$1);

return statearr_17061;
})();
if(inst_17010__$1){
var statearr_17062_17088 = state_17044__$1;
(statearr_17062_17088[(1)] = (8));

} else {
var statearr_17063_17089 = state_17044__$1;
(statearr_17063_17089[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17045 === (14))){
var inst_17009 = (state_17044[(11)]);
var inst_17005 = (state_17044[(9)]);
var inst_17022 = (state_17044[(2)]);
var inst_17023 = [];
var inst_17024 = inst_17023.push(inst_17005);
var inst_17001 = inst_17023;
var inst_17002 = inst_17009;
var state_17044__$1 = (function (){var statearr_17064 = state_17044;
(statearr_17064[(7)] = inst_17001);

(statearr_17064[(14)] = inst_17022);

(statearr_17064[(8)] = inst_17002);

(statearr_17064[(15)] = inst_17024);

return statearr_17064;
})();
var statearr_17065_17090 = state_17044__$1;
(statearr_17065_17090[(2)] = null);

(statearr_17065_17090[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17045 === (16))){
var state_17044__$1 = state_17044;
var statearr_17066_17091 = state_17044__$1;
(statearr_17066_17091[(2)] = null);

(statearr_17066_17091[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17045 === (10))){
var inst_17015 = (state_17044[(2)]);
var state_17044__$1 = state_17044;
if(cljs.core.truth_(inst_17015)){
var statearr_17067_17092 = state_17044__$1;
(statearr_17067_17092[(1)] = (11));

} else {
var statearr_17068_17093 = state_17044__$1;
(statearr_17068_17093[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17045 === (18))){
var inst_17034 = (state_17044[(2)]);
var state_17044__$1 = state_17044;
var statearr_17069_17094 = state_17044__$1;
(statearr_17069_17094[(2)] = inst_17034);

(statearr_17069_17094[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17045 === (8))){
var inst_17010 = (state_17044[(13)]);
var state_17044__$1 = state_17044;
var statearr_17070_17095 = state_17044__$1;
(statearr_17070_17095[(2)] = inst_17010);

(statearr_17070_17095[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__15091__auto__ = null;
var cljs$core$async$state_machine__15091__auto____0 = (function (){
var statearr_17071 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17071[(0)] = cljs$core$async$state_machine__15091__auto__);

(statearr_17071[(1)] = (1));

return statearr_17071;
});
var cljs$core$async$state_machine__15091__auto____1 = (function (state_17044){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_17044);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e17072){var ex__15094__auto__ = e17072;
var statearr_17073_17096 = state_17044;
(statearr_17073_17096[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_17044[(4)]))){
var statearr_17074_17097 = state_17044;
(statearr_17074_17097[(1)] = cljs.core.first((state_17044[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__17098 = state_17044;
state_17044 = G__17098;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
cljs$core$async$state_machine__15091__auto__ = function(state_17044){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__15091__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__15091__auto____1.call(this,state_17044);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__15091__auto____0;
cljs$core$async$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__15091__auto____1;
return cljs$core$async$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_17075 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_17075[(6)] = c__15165__auto___17077);

return statearr_17075;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

