// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
goog.require('goog.object');
goog.scope(function(){
cljs.source_map.goog$module$goog$object = goog.module.get('goog.object');
});
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__9107){
var vec__9108 = p__9107;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9108,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9108,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__9111 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9111,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9111,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9111,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9111,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9111,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$gcol,gcol,cljs.core.cst$kw$source,(cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources")[source]),cljs.core.cst$kw$line,line,cljs.core.cst$kw$col,col,cljs.core.cst$kw$name,(function (){var temp__5804__auto__ = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5804__auto__)){
var name__$1 = temp__5804__auto__;
return (cljs.source_map.goog$module$goog$object.get.call(null,source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__9114 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9114,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9114,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9114,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9114,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9114,(4),null);
var vec__9117 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9117,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9117,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9117,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9117,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9117,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__5045__auto__ = source;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__5045__auto__ = line;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__5045__auto__ = col;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name,(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__9120 = segmap;
var map__9120__$1 = cljs.core.__destructure_map(map__9120);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9120__$1,cljs.core.cst$kw$gcol);
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9120__$1,cljs.core.cst$kw$source);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9120__$1,cljs.core.cst$kw$line);
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9120__$1,cljs.core.cst$kw$col);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9120__$1,cljs.core.cst$kw$name);
var d = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$gline,gline,cljs.core.cst$kw$gcol,gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$name,name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__9122 = arguments.length;
switch (G__9122) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(cljs.source_map.goog$module$goog$object.get.call(null,source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__9126 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__9130 = cljs.core.next(segs__$1);
var G__9131 = nrelseg;
var G__9132 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__9130;
relseg__$1 = G__9131;
result__$1 = G__9132;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9126,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9126,(1),null);
var G__9133 = (gline + (1));
var G__9134 = cljs.core.next(lines__$1);
var G__9135 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__9136 = result__$1;
gline = G__9133;
lines__$1 = G__9134;
relseg = G__9135;
result = G__9136;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__9138 = segmap;
var map__9138__$1 = cljs.core.__destructure_map(map__9138);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9138__$1,cljs.core.cst$kw$gcol);
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9138__$1,cljs.core.cst$kw$source);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9138__$1,cljs.core.cst$kw$line);
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9138__$1,cljs.core.cst$kw$col);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9138__$1,cljs.core.cst$kw$name);
var d = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$col,col,cljs.core.cst$kw$source,source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$name,name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__9137_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__9137_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__9140 = arguments.length;
switch (G__9140) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(cljs.source_map.goog$module$goog$object.get.call(null,source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__9144 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__9148 = cljs.core.next(segs__$1);
var G__9149 = nrelseg;
var G__9150 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__9148;
relseg__$1 = G__9149;
result__$1 = G__9150;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9144,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9144,(1),null);
var G__9151 = (gline + (1));
var G__9152 = cljs.core.next(lines__$1);
var G__9153 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__9154 = result__$1;
gline = G__9151;
lines__$1 = G__9152;
relseg = G__9153;
result = G__9154;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__9155){
var vec__9156 = p__9155;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9156,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9156,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9156,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9156,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9156,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__9159){
var vec__9160 = p__9159;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9160,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9160,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9160,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9160,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9160,(4),null);
var seg = vec__9160;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__9163){
var vec__9164 = p__9163;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9164,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9164,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9164,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9164,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9164,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__5045__auto__ = cljs.core.cst$kw$preamble_DASH_line_DASH_count.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$gcol.cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5802__auto__ = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5802__auto__)){
var name = temp__5802__auto__;
var idx = (function (){var temp__5802__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5802__auto____$1)){
var idx = temp__5802__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__9170 = cljs.core.seq(infos);
var chunk__9171 = null;
var count__9172 = (0);
var i__9173 = (0);
while(true){
if((i__9173 < count__9172)){
var info = chunk__9171.cljs$core$IIndexed$_nth$arity$2(null,i__9173);
var segv_9527 = info__GT_segv(info,source_idx,line,col);
var gline_9528 = cljs.core.cst$kw$gline.cljs$core$IFn$_invoke$arity$1(info);
var lc_9529 = cljs.core.count(cljs.core.deref(lines));
if((gline_9528 > (lc_9529 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__9170,chunk__9171,count__9172,i__9173,segv_9527,gline_9528,lc_9529,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_9528 - (lc_9529 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_9527], null));
});})(seq__9170,chunk__9171,count__9172,i__9173,segv_9527,gline_9528,lc_9529,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__9170,chunk__9171,count__9172,i__9173,segv_9527,gline_9528,lc_9529,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9528], null),cljs.core.conj,segv_9527);
});})(seq__9170,chunk__9171,count__9172,i__9173,segv_9527,gline_9528,lc_9529,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__9530 = seq__9170;
var G__9531 = chunk__9171;
var G__9532 = count__9172;
var G__9533 = (i__9173 + (1));
seq__9170 = G__9530;
chunk__9171 = G__9531;
count__9172 = G__9532;
i__9173 = G__9533;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__9170);
if(temp__5804__auto__){
var seq__9170__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9170__$1)){
var c__5567__auto__ = cljs.core.chunk_first(seq__9170__$1);
var G__9534 = cljs.core.chunk_rest(seq__9170__$1);
var G__9535 = c__5567__auto__;
var G__9536 = cljs.core.count(c__5567__auto__);
var G__9537 = (0);
seq__9170 = G__9534;
chunk__9171 = G__9535;
count__9172 = G__9536;
i__9173 = G__9537;
continue;
} else {
var info = cljs.core.first(seq__9170__$1);
var segv_9538 = info__GT_segv(info,source_idx,line,col);
var gline_9539 = cljs.core.cst$kw$gline.cljs$core$IFn$_invoke$arity$1(info);
var lc_9540 = cljs.core.count(cljs.core.deref(lines));
if((gline_9539 > (lc_9540 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__9170,chunk__9171,count__9172,i__9173,segv_9538,gline_9539,lc_9540,info,seq__9170__$1,temp__5804__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_9539 - (lc_9540 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_9538], null));
});})(seq__9170,chunk__9171,count__9172,i__9173,segv_9538,gline_9539,lc_9540,info,seq__9170__$1,temp__5804__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__9170,chunk__9171,count__9172,i__9173,segv_9538,gline_9539,lc_9540,info,seq__9170__$1,temp__5804__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9539], null),cljs.core.conj,segv_9538);
});})(seq__9170,chunk__9171,count__9172,i__9173,segv_9538,gline_9539,lc_9540,info,seq__9170__$1,temp__5804__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__9541 = cljs.core.next(seq__9170__$1);
var G__9542 = null;
var G__9543 = (0);
var G__9544 = (0);
seq__9170 = G__9541;
chunk__9171 = G__9542;
count__9172 = G__9543;
i__9173 = G__9544;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__9174_9545 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__9175_9546 = null;
var count__9176_9547 = (0);
var i__9177_9548 = (0);
while(true){
if((i__9177_9548 < count__9176_9547)){
var vec__9350_9549 = chunk__9175_9546.cljs$core$IIndexed$_nth$arity$2(null,i__9177_9548);
var source_idx_9550 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9350_9549,(0),null);
var vec__9353_9551 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9350_9549,(1),null);
var __9552 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9353_9551,(0),null);
var lines_9553__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9353_9551,(1),null);
var seq__9356_9554 = cljs.core.seq(lines_9553__$1);
var chunk__9357_9555 = null;
var count__9358_9556 = (0);
var i__9359_9557 = (0);
while(true){
if((i__9359_9557 < count__9358_9556)){
var vec__9398_9558 = chunk__9357_9555.cljs$core$IIndexed$_nth$arity$2(null,i__9359_9557);
var line_9559 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9398_9558,(0),null);
var cols_9560 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9398_9558,(1),null);
var seq__9401_9561 = cljs.core.seq(cols_9560);
var chunk__9402_9562 = null;
var count__9403_9563 = (0);
var i__9404_9564 = (0);
while(true){
if((i__9404_9564 < count__9403_9563)){
var vec__9411_9565 = chunk__9402_9562.cljs$core$IIndexed$_nth$arity$2(null,i__9404_9564);
var col_9566 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9411_9565,(0),null);
var infos_9567 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9411_9565,(1),null);
encode_cols(infos_9567,source_idx_9550,line_9559,col_9566);


var G__9568 = seq__9401_9561;
var G__9569 = chunk__9402_9562;
var G__9570 = count__9403_9563;
var G__9571 = (i__9404_9564 + (1));
seq__9401_9561 = G__9568;
chunk__9402_9562 = G__9569;
count__9403_9563 = G__9570;
i__9404_9564 = G__9571;
continue;
} else {
var temp__5804__auto___9572 = cljs.core.seq(seq__9401_9561);
if(temp__5804__auto___9572){
var seq__9401_9573__$1 = temp__5804__auto___9572;
if(cljs.core.chunked_seq_QMARK_(seq__9401_9573__$1)){
var c__5567__auto___9574 = cljs.core.chunk_first(seq__9401_9573__$1);
var G__9575 = cljs.core.chunk_rest(seq__9401_9573__$1);
var G__9576 = c__5567__auto___9574;
var G__9577 = cljs.core.count(c__5567__auto___9574);
var G__9578 = (0);
seq__9401_9561 = G__9575;
chunk__9402_9562 = G__9576;
count__9403_9563 = G__9577;
i__9404_9564 = G__9578;
continue;
} else {
var vec__9414_9579 = cljs.core.first(seq__9401_9573__$1);
var col_9580 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9414_9579,(0),null);
var infos_9581 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9414_9579,(1),null);
encode_cols(infos_9581,source_idx_9550,line_9559,col_9580);


var G__9582 = cljs.core.next(seq__9401_9573__$1);
var G__9583 = null;
var G__9584 = (0);
var G__9585 = (0);
seq__9401_9561 = G__9582;
chunk__9402_9562 = G__9583;
count__9403_9563 = G__9584;
i__9404_9564 = G__9585;
continue;
}
} else {
}
}
break;
}


var G__9586 = seq__9356_9554;
var G__9587 = chunk__9357_9555;
var G__9588 = count__9358_9556;
var G__9589 = (i__9359_9557 + (1));
seq__9356_9554 = G__9586;
chunk__9357_9555 = G__9587;
count__9358_9556 = G__9588;
i__9359_9557 = G__9589;
continue;
} else {
var temp__5804__auto___9590 = cljs.core.seq(seq__9356_9554);
if(temp__5804__auto___9590){
var seq__9356_9591__$1 = temp__5804__auto___9590;
if(cljs.core.chunked_seq_QMARK_(seq__9356_9591__$1)){
var c__5567__auto___9592 = cljs.core.chunk_first(seq__9356_9591__$1);
var G__9593 = cljs.core.chunk_rest(seq__9356_9591__$1);
var G__9594 = c__5567__auto___9592;
var G__9595 = cljs.core.count(c__5567__auto___9592);
var G__9596 = (0);
seq__9356_9554 = G__9593;
chunk__9357_9555 = G__9594;
count__9358_9556 = G__9595;
i__9359_9557 = G__9596;
continue;
} else {
var vec__9417_9597 = cljs.core.first(seq__9356_9591__$1);
var line_9598 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9417_9597,(0),null);
var cols_9599 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9417_9597,(1),null);
var seq__9420_9600 = cljs.core.seq(cols_9599);
var chunk__9421_9601 = null;
var count__9422_9602 = (0);
var i__9423_9603 = (0);
while(true){
if((i__9423_9603 < count__9422_9602)){
var vec__9430_9604 = chunk__9421_9601.cljs$core$IIndexed$_nth$arity$2(null,i__9423_9603);
var col_9605 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9430_9604,(0),null);
var infos_9606 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9430_9604,(1),null);
encode_cols(infos_9606,source_idx_9550,line_9598,col_9605);


var G__9607 = seq__9420_9600;
var G__9608 = chunk__9421_9601;
var G__9609 = count__9422_9602;
var G__9610 = (i__9423_9603 + (1));
seq__9420_9600 = G__9607;
chunk__9421_9601 = G__9608;
count__9422_9602 = G__9609;
i__9423_9603 = G__9610;
continue;
} else {
var temp__5804__auto___9611__$1 = cljs.core.seq(seq__9420_9600);
if(temp__5804__auto___9611__$1){
var seq__9420_9612__$1 = temp__5804__auto___9611__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9420_9612__$1)){
var c__5567__auto___9613 = cljs.core.chunk_first(seq__9420_9612__$1);
var G__9614 = cljs.core.chunk_rest(seq__9420_9612__$1);
var G__9615 = c__5567__auto___9613;
var G__9616 = cljs.core.count(c__5567__auto___9613);
var G__9617 = (0);
seq__9420_9600 = G__9614;
chunk__9421_9601 = G__9615;
count__9422_9602 = G__9616;
i__9423_9603 = G__9617;
continue;
} else {
var vec__9433_9618 = cljs.core.first(seq__9420_9612__$1);
var col_9619 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9433_9618,(0),null);
var infos_9620 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9433_9618,(1),null);
encode_cols(infos_9620,source_idx_9550,line_9598,col_9619);


var G__9621 = cljs.core.next(seq__9420_9612__$1);
var G__9622 = null;
var G__9623 = (0);
var G__9624 = (0);
seq__9420_9600 = G__9621;
chunk__9421_9601 = G__9622;
count__9422_9602 = G__9623;
i__9423_9603 = G__9624;
continue;
}
} else {
}
}
break;
}


var G__9625 = cljs.core.next(seq__9356_9591__$1);
var G__9626 = null;
var G__9627 = (0);
var G__9628 = (0);
seq__9356_9554 = G__9625;
chunk__9357_9555 = G__9626;
count__9358_9556 = G__9627;
i__9359_9557 = G__9628;
continue;
}
} else {
}
}
break;
}


var G__9629 = seq__9174_9545;
var G__9630 = chunk__9175_9546;
var G__9631 = count__9176_9547;
var G__9632 = (i__9177_9548 + (1));
seq__9174_9545 = G__9629;
chunk__9175_9546 = G__9630;
count__9176_9547 = G__9631;
i__9177_9548 = G__9632;
continue;
} else {
var temp__5804__auto___9633 = cljs.core.seq(seq__9174_9545);
if(temp__5804__auto___9633){
var seq__9174_9634__$1 = temp__5804__auto___9633;
if(cljs.core.chunked_seq_QMARK_(seq__9174_9634__$1)){
var c__5567__auto___9635 = cljs.core.chunk_first(seq__9174_9634__$1);
var G__9636 = cljs.core.chunk_rest(seq__9174_9634__$1);
var G__9637 = c__5567__auto___9635;
var G__9638 = cljs.core.count(c__5567__auto___9635);
var G__9639 = (0);
seq__9174_9545 = G__9636;
chunk__9175_9546 = G__9637;
count__9176_9547 = G__9638;
i__9177_9548 = G__9639;
continue;
} else {
var vec__9436_9640 = cljs.core.first(seq__9174_9634__$1);
var source_idx_9641 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9436_9640,(0),null);
var vec__9439_9642 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9436_9640,(1),null);
var __9643 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9439_9642,(0),null);
var lines_9644__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9439_9642,(1),null);
var seq__9442_9645 = cljs.core.seq(lines_9644__$1);
var chunk__9443_9646 = null;
var count__9444_9647 = (0);
var i__9445_9648 = (0);
while(true){
if((i__9445_9648 < count__9444_9647)){
var vec__9484_9649 = chunk__9443_9646.cljs$core$IIndexed$_nth$arity$2(null,i__9445_9648);
var line_9650 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9484_9649,(0),null);
var cols_9651 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9484_9649,(1),null);
var seq__9487_9652 = cljs.core.seq(cols_9651);
var chunk__9488_9653 = null;
var count__9489_9654 = (0);
var i__9490_9655 = (0);
while(true){
if((i__9490_9655 < count__9489_9654)){
var vec__9497_9656 = chunk__9488_9653.cljs$core$IIndexed$_nth$arity$2(null,i__9490_9655);
var col_9657 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9497_9656,(0),null);
var infos_9658 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9497_9656,(1),null);
encode_cols(infos_9658,source_idx_9641,line_9650,col_9657);


var G__9659 = seq__9487_9652;
var G__9660 = chunk__9488_9653;
var G__9661 = count__9489_9654;
var G__9662 = (i__9490_9655 + (1));
seq__9487_9652 = G__9659;
chunk__9488_9653 = G__9660;
count__9489_9654 = G__9661;
i__9490_9655 = G__9662;
continue;
} else {
var temp__5804__auto___9663__$1 = cljs.core.seq(seq__9487_9652);
if(temp__5804__auto___9663__$1){
var seq__9487_9664__$1 = temp__5804__auto___9663__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9487_9664__$1)){
var c__5567__auto___9665 = cljs.core.chunk_first(seq__9487_9664__$1);
var G__9666 = cljs.core.chunk_rest(seq__9487_9664__$1);
var G__9667 = c__5567__auto___9665;
var G__9668 = cljs.core.count(c__5567__auto___9665);
var G__9669 = (0);
seq__9487_9652 = G__9666;
chunk__9488_9653 = G__9667;
count__9489_9654 = G__9668;
i__9490_9655 = G__9669;
continue;
} else {
var vec__9500_9670 = cljs.core.first(seq__9487_9664__$1);
var col_9671 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9500_9670,(0),null);
var infos_9672 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9500_9670,(1),null);
encode_cols(infos_9672,source_idx_9641,line_9650,col_9671);


var G__9673 = cljs.core.next(seq__9487_9664__$1);
var G__9674 = null;
var G__9675 = (0);
var G__9676 = (0);
seq__9487_9652 = G__9673;
chunk__9488_9653 = G__9674;
count__9489_9654 = G__9675;
i__9490_9655 = G__9676;
continue;
}
} else {
}
}
break;
}


var G__9677 = seq__9442_9645;
var G__9678 = chunk__9443_9646;
var G__9679 = count__9444_9647;
var G__9680 = (i__9445_9648 + (1));
seq__9442_9645 = G__9677;
chunk__9443_9646 = G__9678;
count__9444_9647 = G__9679;
i__9445_9648 = G__9680;
continue;
} else {
var temp__5804__auto___9681__$1 = cljs.core.seq(seq__9442_9645);
if(temp__5804__auto___9681__$1){
var seq__9442_9682__$1 = temp__5804__auto___9681__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9442_9682__$1)){
var c__5567__auto___9683 = cljs.core.chunk_first(seq__9442_9682__$1);
var G__9684 = cljs.core.chunk_rest(seq__9442_9682__$1);
var G__9685 = c__5567__auto___9683;
var G__9686 = cljs.core.count(c__5567__auto___9683);
var G__9687 = (0);
seq__9442_9645 = G__9684;
chunk__9443_9646 = G__9685;
count__9444_9647 = G__9686;
i__9445_9648 = G__9687;
continue;
} else {
var vec__9503_9688 = cljs.core.first(seq__9442_9682__$1);
var line_9689 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9503_9688,(0),null);
var cols_9690 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9503_9688,(1),null);
var seq__9506_9691 = cljs.core.seq(cols_9690);
var chunk__9507_9692 = null;
var count__9508_9693 = (0);
var i__9509_9694 = (0);
while(true){
if((i__9509_9694 < count__9508_9693)){
var vec__9516_9695 = chunk__9507_9692.cljs$core$IIndexed$_nth$arity$2(null,i__9509_9694);
var col_9696 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9516_9695,(0),null);
var infos_9697 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9516_9695,(1),null);
encode_cols(infos_9697,source_idx_9641,line_9689,col_9696);


var G__9698 = seq__9506_9691;
var G__9699 = chunk__9507_9692;
var G__9700 = count__9508_9693;
var G__9701 = (i__9509_9694 + (1));
seq__9506_9691 = G__9698;
chunk__9507_9692 = G__9699;
count__9508_9693 = G__9700;
i__9509_9694 = G__9701;
continue;
} else {
var temp__5804__auto___9702__$2 = cljs.core.seq(seq__9506_9691);
if(temp__5804__auto___9702__$2){
var seq__9506_9703__$1 = temp__5804__auto___9702__$2;
if(cljs.core.chunked_seq_QMARK_(seq__9506_9703__$1)){
var c__5567__auto___9704 = cljs.core.chunk_first(seq__9506_9703__$1);
var G__9705 = cljs.core.chunk_rest(seq__9506_9703__$1);
var G__9706 = c__5567__auto___9704;
var G__9707 = cljs.core.count(c__5567__auto___9704);
var G__9708 = (0);
seq__9506_9691 = G__9705;
chunk__9507_9692 = G__9706;
count__9508_9693 = G__9707;
i__9509_9694 = G__9708;
continue;
} else {
var vec__9519_9709 = cljs.core.first(seq__9506_9703__$1);
var col_9710 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9519_9709,(0),null);
var infos_9711 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9519_9709,(1),null);
encode_cols(infos_9711,source_idx_9641,line_9689,col_9710);


var G__9712 = cljs.core.next(seq__9506_9703__$1);
var G__9713 = null;
var G__9714 = (0);
var G__9715 = (0);
seq__9506_9691 = G__9712;
chunk__9507_9692 = G__9713;
count__9508_9693 = G__9714;
i__9509_9694 = G__9715;
continue;
}
} else {
}
}
break;
}


var G__9716 = cljs.core.next(seq__9442_9682__$1);
var G__9717 = null;
var G__9718 = (0);
var G__9719 = (0);
seq__9442_9645 = G__9716;
chunk__9443_9646 = G__9717;
count__9444_9647 = G__9718;
i__9445_9648 = G__9719;
continue;
}
} else {
}
}
break;
}


var G__9720 = cljs.core.next(seq__9174_9634__$1);
var G__9721 = null;
var G__9722 = (0);
var G__9723 = (0);
seq__9174_9545 = G__9720;
chunk__9175_9546 = G__9721;
count__9176_9547 = G__9722;
i__9177_9548 = G__9723;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__9522 = ({"version": (3), "file": cljs.core.cst$kw$file.cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((cljs.core.cst$kw$source_DASH_map_DASH_timestamp.cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__9167_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__9167_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__9168_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__9168_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": cljs.core.cst$kw$lines.cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__9169_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__9169_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(cljs.core.cst$kw$sources_DASH_content.cljs$core$IFn$_invoke$arity$1(opts))){
var G__9523 = G__9522;
var G__9524_9724 = G__9523;
var G__9525_9725 = "sourcesContent";
var G__9526_9726 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$sources_DASH_content.cljs$core$IFn$_invoke$arity$1(opts));
cljs.source_map.goog$module$goog$object.set.call(null,G__9524_9724,G__9525_9725,G__9526_9726);

return G__9523;
} else {
return G__9522;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__9727 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9727,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9727,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__9730 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9730,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9730,(1),null);
var G__9735 = cljs.core.next(col_map_seq);
var G__9736 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__9730,col,infos,vec__9727,line,col_map){
return (function (v,p__9733){
var map__9734 = p__9733;
var map__9734__$1 = cljs.core.__destructure_map(map__9734);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9734__$1,cljs.core.cst$kw$gline);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9734__$1,cljs.core.cst$kw$gcol);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__9730,col,infos,vec__9727,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__9735;
new_cols = G__9736;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__9737 = cljs.core.next(line_map_seq);
var G__9738 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__9737;
new_lines = G__9738;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__9739_9947 = cljs.core.seq(reverse_map);
var chunk__9740_9948 = null;
var count__9741_9949 = (0);
var i__9742_9950 = (0);
while(true){
if((i__9742_9950 < count__9741_9949)){
var vec__9845_9951 = chunk__9740_9948.cljs$core$IIndexed$_nth$arity$2(null,i__9742_9950);
var line_9952 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9845_9951,(0),null);
var columns_9953 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9845_9951,(1),null);
var seq__9848_9954 = cljs.core.seq(columns_9953);
var chunk__9849_9955 = null;
var count__9850_9956 = (0);
var i__9851_9957 = (0);
while(true){
if((i__9851_9957 < count__9850_9956)){
var vec__9874_9958 = chunk__9849_9955.cljs$core$IIndexed$_nth$arity$2(null,i__9851_9957);
var column_9959 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9874_9958,(0),null);
var column_info_9960 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9874_9958,(1),null);
var seq__9877_9961 = cljs.core.seq(column_info_9960);
var chunk__9878_9962 = null;
var count__9879_9963 = (0);
var i__9880_9964 = (0);
while(true){
if((i__9880_9964 < count__9879_9963)){
var map__9883_9965 = chunk__9878_9962.cljs$core$IIndexed$_nth$arity$2(null,i__9880_9964);
var map__9883_9966__$1 = cljs.core.__destructure_map(map__9883_9965);
var gline_9967 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9883_9966__$1,cljs.core.cst$kw$gline);
var gcol_9968 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9883_9966__$1,cljs.core.cst$kw$gcol);
var name_9969 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9883_9966__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9967], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9877_9961,chunk__9878_9962,count__9879_9963,i__9880_9964,seq__9848_9954,chunk__9849_9955,count__9850_9956,i__9851_9957,seq__9739_9947,chunk__9740_9948,count__9741_9949,i__9742_9950,map__9883_9965,map__9883_9966__$1,gline_9967,gcol_9968,name_9969,vec__9874_9958,column_9959,column_info_9960,vec__9845_9951,line_9952,columns_9953,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9968], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_9952,cljs.core.cst$kw$col,column_9959,cljs.core.cst$kw$name,name_9969], null));
});})(seq__9877_9961,chunk__9878_9962,count__9879_9963,i__9880_9964,seq__9848_9954,chunk__9849_9955,count__9850_9956,i__9851_9957,seq__9739_9947,chunk__9740_9948,count__9741_9949,i__9742_9950,map__9883_9965,map__9883_9966__$1,gline_9967,gcol_9968,name_9969,vec__9874_9958,column_9959,column_info_9960,vec__9845_9951,line_9952,columns_9953,inverted))
,cljs.core.sorted_map()));


var G__9970 = seq__9877_9961;
var G__9971 = chunk__9878_9962;
var G__9972 = count__9879_9963;
var G__9973 = (i__9880_9964 + (1));
seq__9877_9961 = G__9970;
chunk__9878_9962 = G__9971;
count__9879_9963 = G__9972;
i__9880_9964 = G__9973;
continue;
} else {
var temp__5804__auto___9974 = cljs.core.seq(seq__9877_9961);
if(temp__5804__auto___9974){
var seq__9877_9975__$1 = temp__5804__auto___9974;
if(cljs.core.chunked_seq_QMARK_(seq__9877_9975__$1)){
var c__5567__auto___9976 = cljs.core.chunk_first(seq__9877_9975__$1);
var G__9977 = cljs.core.chunk_rest(seq__9877_9975__$1);
var G__9978 = c__5567__auto___9976;
var G__9979 = cljs.core.count(c__5567__auto___9976);
var G__9980 = (0);
seq__9877_9961 = G__9977;
chunk__9878_9962 = G__9978;
count__9879_9963 = G__9979;
i__9880_9964 = G__9980;
continue;
} else {
var map__9884_9981 = cljs.core.first(seq__9877_9975__$1);
var map__9884_9982__$1 = cljs.core.__destructure_map(map__9884_9981);
var gline_9983 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9884_9982__$1,cljs.core.cst$kw$gline);
var gcol_9984 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9884_9982__$1,cljs.core.cst$kw$gcol);
var name_9985 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9884_9982__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9983], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9877_9961,chunk__9878_9962,count__9879_9963,i__9880_9964,seq__9848_9954,chunk__9849_9955,count__9850_9956,i__9851_9957,seq__9739_9947,chunk__9740_9948,count__9741_9949,i__9742_9950,map__9884_9981,map__9884_9982__$1,gline_9983,gcol_9984,name_9985,seq__9877_9975__$1,temp__5804__auto___9974,vec__9874_9958,column_9959,column_info_9960,vec__9845_9951,line_9952,columns_9953,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9984], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_9952,cljs.core.cst$kw$col,column_9959,cljs.core.cst$kw$name,name_9985], null));
});})(seq__9877_9961,chunk__9878_9962,count__9879_9963,i__9880_9964,seq__9848_9954,chunk__9849_9955,count__9850_9956,i__9851_9957,seq__9739_9947,chunk__9740_9948,count__9741_9949,i__9742_9950,map__9884_9981,map__9884_9982__$1,gline_9983,gcol_9984,name_9985,seq__9877_9975__$1,temp__5804__auto___9974,vec__9874_9958,column_9959,column_info_9960,vec__9845_9951,line_9952,columns_9953,inverted))
,cljs.core.sorted_map()));


var G__9986 = cljs.core.next(seq__9877_9975__$1);
var G__9987 = null;
var G__9988 = (0);
var G__9989 = (0);
seq__9877_9961 = G__9986;
chunk__9878_9962 = G__9987;
count__9879_9963 = G__9988;
i__9880_9964 = G__9989;
continue;
}
} else {
}
}
break;
}


var G__9990 = seq__9848_9954;
var G__9991 = chunk__9849_9955;
var G__9992 = count__9850_9956;
var G__9993 = (i__9851_9957 + (1));
seq__9848_9954 = G__9990;
chunk__9849_9955 = G__9991;
count__9850_9956 = G__9992;
i__9851_9957 = G__9993;
continue;
} else {
var temp__5804__auto___9994 = cljs.core.seq(seq__9848_9954);
if(temp__5804__auto___9994){
var seq__9848_9995__$1 = temp__5804__auto___9994;
if(cljs.core.chunked_seq_QMARK_(seq__9848_9995__$1)){
var c__5567__auto___9996 = cljs.core.chunk_first(seq__9848_9995__$1);
var G__9997 = cljs.core.chunk_rest(seq__9848_9995__$1);
var G__9998 = c__5567__auto___9996;
var G__9999 = cljs.core.count(c__5567__auto___9996);
var G__10000 = (0);
seq__9848_9954 = G__9997;
chunk__9849_9955 = G__9998;
count__9850_9956 = G__9999;
i__9851_9957 = G__10000;
continue;
} else {
var vec__9885_10001 = cljs.core.first(seq__9848_9995__$1);
var column_10002 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9885_10001,(0),null);
var column_info_10003 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9885_10001,(1),null);
var seq__9888_10004 = cljs.core.seq(column_info_10003);
var chunk__9889_10005 = null;
var count__9890_10006 = (0);
var i__9891_10007 = (0);
while(true){
if((i__9891_10007 < count__9890_10006)){
var map__9894_10008 = chunk__9889_10005.cljs$core$IIndexed$_nth$arity$2(null,i__9891_10007);
var map__9894_10009__$1 = cljs.core.__destructure_map(map__9894_10008);
var gline_10010 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9894_10009__$1,cljs.core.cst$kw$gline);
var gcol_10011 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9894_10009__$1,cljs.core.cst$kw$gcol);
var name_10012 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9894_10009__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_10010], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9888_10004,chunk__9889_10005,count__9890_10006,i__9891_10007,seq__9848_9954,chunk__9849_9955,count__9850_9956,i__9851_9957,seq__9739_9947,chunk__9740_9948,count__9741_9949,i__9742_9950,map__9894_10008,map__9894_10009__$1,gline_10010,gcol_10011,name_10012,vec__9885_10001,column_10002,column_info_10003,seq__9848_9995__$1,temp__5804__auto___9994,vec__9845_9951,line_9952,columns_9953,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_10011], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_9952,cljs.core.cst$kw$col,column_10002,cljs.core.cst$kw$name,name_10012], null));
});})(seq__9888_10004,chunk__9889_10005,count__9890_10006,i__9891_10007,seq__9848_9954,chunk__9849_9955,count__9850_9956,i__9851_9957,seq__9739_9947,chunk__9740_9948,count__9741_9949,i__9742_9950,map__9894_10008,map__9894_10009__$1,gline_10010,gcol_10011,name_10012,vec__9885_10001,column_10002,column_info_10003,seq__9848_9995__$1,temp__5804__auto___9994,vec__9845_9951,line_9952,columns_9953,inverted))
,cljs.core.sorted_map()));


var G__10013 = seq__9888_10004;
var G__10014 = chunk__9889_10005;
var G__10015 = count__9890_10006;
var G__10016 = (i__9891_10007 + (1));
seq__9888_10004 = G__10013;
chunk__9889_10005 = G__10014;
count__9890_10006 = G__10015;
i__9891_10007 = G__10016;
continue;
} else {
var temp__5804__auto___10017__$1 = cljs.core.seq(seq__9888_10004);
if(temp__5804__auto___10017__$1){
var seq__9888_10018__$1 = temp__5804__auto___10017__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9888_10018__$1)){
var c__5567__auto___10019 = cljs.core.chunk_first(seq__9888_10018__$1);
var G__10020 = cljs.core.chunk_rest(seq__9888_10018__$1);
var G__10021 = c__5567__auto___10019;
var G__10022 = cljs.core.count(c__5567__auto___10019);
var G__10023 = (0);
seq__9888_10004 = G__10020;
chunk__9889_10005 = G__10021;
count__9890_10006 = G__10022;
i__9891_10007 = G__10023;
continue;
} else {
var map__9895_10024 = cljs.core.first(seq__9888_10018__$1);
var map__9895_10025__$1 = cljs.core.__destructure_map(map__9895_10024);
var gline_10026 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9895_10025__$1,cljs.core.cst$kw$gline);
var gcol_10027 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9895_10025__$1,cljs.core.cst$kw$gcol);
var name_10028 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9895_10025__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_10026], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9888_10004,chunk__9889_10005,count__9890_10006,i__9891_10007,seq__9848_9954,chunk__9849_9955,count__9850_9956,i__9851_9957,seq__9739_9947,chunk__9740_9948,count__9741_9949,i__9742_9950,map__9895_10024,map__9895_10025__$1,gline_10026,gcol_10027,name_10028,seq__9888_10018__$1,temp__5804__auto___10017__$1,vec__9885_10001,column_10002,column_info_10003,seq__9848_9995__$1,temp__5804__auto___9994,vec__9845_9951,line_9952,columns_9953,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_10027], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_9952,cljs.core.cst$kw$col,column_10002,cljs.core.cst$kw$name,name_10028], null));
});})(seq__9888_10004,chunk__9889_10005,count__9890_10006,i__9891_10007,seq__9848_9954,chunk__9849_9955,count__9850_9956,i__9851_9957,seq__9739_9947,chunk__9740_9948,count__9741_9949,i__9742_9950,map__9895_10024,map__9895_10025__$1,gline_10026,gcol_10027,name_10028,seq__9888_10018__$1,temp__5804__auto___10017__$1,vec__9885_10001,column_10002,column_info_10003,seq__9848_9995__$1,temp__5804__auto___9994,vec__9845_9951,line_9952,columns_9953,inverted))
,cljs.core.sorted_map()));


var G__10029 = cljs.core.next(seq__9888_10018__$1);
var G__10030 = null;
var G__10031 = (0);
var G__10032 = (0);
seq__9888_10004 = G__10029;
chunk__9889_10005 = G__10030;
count__9890_10006 = G__10031;
i__9891_10007 = G__10032;
continue;
}
} else {
}
}
break;
}


var G__10033 = cljs.core.next(seq__9848_9995__$1);
var G__10034 = null;
var G__10035 = (0);
var G__10036 = (0);
seq__9848_9954 = G__10033;
chunk__9849_9955 = G__10034;
count__9850_9956 = G__10035;
i__9851_9957 = G__10036;
continue;
}
} else {
}
}
break;
}


var G__10037 = seq__9739_9947;
var G__10038 = chunk__9740_9948;
var G__10039 = count__9741_9949;
var G__10040 = (i__9742_9950 + (1));
seq__9739_9947 = G__10037;
chunk__9740_9948 = G__10038;
count__9741_9949 = G__10039;
i__9742_9950 = G__10040;
continue;
} else {
var temp__5804__auto___10041 = cljs.core.seq(seq__9739_9947);
if(temp__5804__auto___10041){
var seq__9739_10042__$1 = temp__5804__auto___10041;
if(cljs.core.chunked_seq_QMARK_(seq__9739_10042__$1)){
var c__5567__auto___10043 = cljs.core.chunk_first(seq__9739_10042__$1);
var G__10044 = cljs.core.chunk_rest(seq__9739_10042__$1);
var G__10045 = c__5567__auto___10043;
var G__10046 = cljs.core.count(c__5567__auto___10043);
var G__10047 = (0);
seq__9739_9947 = G__10044;
chunk__9740_9948 = G__10045;
count__9741_9949 = G__10046;
i__9742_9950 = G__10047;
continue;
} else {
var vec__9896_10048 = cljs.core.first(seq__9739_10042__$1);
var line_10049 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9896_10048,(0),null);
var columns_10050 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9896_10048,(1),null);
var seq__9899_10051 = cljs.core.seq(columns_10050);
var chunk__9900_10052 = null;
var count__9901_10053 = (0);
var i__9902_10054 = (0);
while(true){
if((i__9902_10054 < count__9901_10053)){
var vec__9925_10055 = chunk__9900_10052.cljs$core$IIndexed$_nth$arity$2(null,i__9902_10054);
var column_10056 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9925_10055,(0),null);
var column_info_10057 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9925_10055,(1),null);
var seq__9928_10058 = cljs.core.seq(column_info_10057);
var chunk__9929_10059 = null;
var count__9930_10060 = (0);
var i__9931_10061 = (0);
while(true){
if((i__9931_10061 < count__9930_10060)){
var map__9934_10062 = chunk__9929_10059.cljs$core$IIndexed$_nth$arity$2(null,i__9931_10061);
var map__9934_10063__$1 = cljs.core.__destructure_map(map__9934_10062);
var gline_10064 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9934_10063__$1,cljs.core.cst$kw$gline);
var gcol_10065 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9934_10063__$1,cljs.core.cst$kw$gcol);
var name_10066 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9934_10063__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_10064], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9928_10058,chunk__9929_10059,count__9930_10060,i__9931_10061,seq__9899_10051,chunk__9900_10052,count__9901_10053,i__9902_10054,seq__9739_9947,chunk__9740_9948,count__9741_9949,i__9742_9950,map__9934_10062,map__9934_10063__$1,gline_10064,gcol_10065,name_10066,vec__9925_10055,column_10056,column_info_10057,vec__9896_10048,line_10049,columns_10050,seq__9739_10042__$1,temp__5804__auto___10041,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_10065], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_10049,cljs.core.cst$kw$col,column_10056,cljs.core.cst$kw$name,name_10066], null));
});})(seq__9928_10058,chunk__9929_10059,count__9930_10060,i__9931_10061,seq__9899_10051,chunk__9900_10052,count__9901_10053,i__9902_10054,seq__9739_9947,chunk__9740_9948,count__9741_9949,i__9742_9950,map__9934_10062,map__9934_10063__$1,gline_10064,gcol_10065,name_10066,vec__9925_10055,column_10056,column_info_10057,vec__9896_10048,line_10049,columns_10050,seq__9739_10042__$1,temp__5804__auto___10041,inverted))
,cljs.core.sorted_map()));


var G__10067 = seq__9928_10058;
var G__10068 = chunk__9929_10059;
var G__10069 = count__9930_10060;
var G__10070 = (i__9931_10061 + (1));
seq__9928_10058 = G__10067;
chunk__9929_10059 = G__10068;
count__9930_10060 = G__10069;
i__9931_10061 = G__10070;
continue;
} else {
var temp__5804__auto___10071__$1 = cljs.core.seq(seq__9928_10058);
if(temp__5804__auto___10071__$1){
var seq__9928_10072__$1 = temp__5804__auto___10071__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9928_10072__$1)){
var c__5567__auto___10073 = cljs.core.chunk_first(seq__9928_10072__$1);
var G__10074 = cljs.core.chunk_rest(seq__9928_10072__$1);
var G__10075 = c__5567__auto___10073;
var G__10076 = cljs.core.count(c__5567__auto___10073);
var G__10077 = (0);
seq__9928_10058 = G__10074;
chunk__9929_10059 = G__10075;
count__9930_10060 = G__10076;
i__9931_10061 = G__10077;
continue;
} else {
var map__9935_10078 = cljs.core.first(seq__9928_10072__$1);
var map__9935_10079__$1 = cljs.core.__destructure_map(map__9935_10078);
var gline_10080 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9935_10079__$1,cljs.core.cst$kw$gline);
var gcol_10081 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9935_10079__$1,cljs.core.cst$kw$gcol);
var name_10082 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9935_10079__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_10080], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9928_10058,chunk__9929_10059,count__9930_10060,i__9931_10061,seq__9899_10051,chunk__9900_10052,count__9901_10053,i__9902_10054,seq__9739_9947,chunk__9740_9948,count__9741_9949,i__9742_9950,map__9935_10078,map__9935_10079__$1,gline_10080,gcol_10081,name_10082,seq__9928_10072__$1,temp__5804__auto___10071__$1,vec__9925_10055,column_10056,column_info_10057,vec__9896_10048,line_10049,columns_10050,seq__9739_10042__$1,temp__5804__auto___10041,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_10081], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_10049,cljs.core.cst$kw$col,column_10056,cljs.core.cst$kw$name,name_10082], null));
});})(seq__9928_10058,chunk__9929_10059,count__9930_10060,i__9931_10061,seq__9899_10051,chunk__9900_10052,count__9901_10053,i__9902_10054,seq__9739_9947,chunk__9740_9948,count__9741_9949,i__9742_9950,map__9935_10078,map__9935_10079__$1,gline_10080,gcol_10081,name_10082,seq__9928_10072__$1,temp__5804__auto___10071__$1,vec__9925_10055,column_10056,column_info_10057,vec__9896_10048,line_10049,columns_10050,seq__9739_10042__$1,temp__5804__auto___10041,inverted))
,cljs.core.sorted_map()));


var G__10083 = cljs.core.next(seq__9928_10072__$1);
var G__10084 = null;
var G__10085 = (0);
var G__10086 = (0);
seq__9928_10058 = G__10083;
chunk__9929_10059 = G__10084;
count__9930_10060 = G__10085;
i__9931_10061 = G__10086;
continue;
}
} else {
}
}
break;
}


var G__10087 = seq__9899_10051;
var G__10088 = chunk__9900_10052;
var G__10089 = count__9901_10053;
var G__10090 = (i__9902_10054 + (1));
seq__9899_10051 = G__10087;
chunk__9900_10052 = G__10088;
count__9901_10053 = G__10089;
i__9902_10054 = G__10090;
continue;
} else {
var temp__5804__auto___10091__$1 = cljs.core.seq(seq__9899_10051);
if(temp__5804__auto___10091__$1){
var seq__9899_10092__$1 = temp__5804__auto___10091__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9899_10092__$1)){
var c__5567__auto___10093 = cljs.core.chunk_first(seq__9899_10092__$1);
var G__10094 = cljs.core.chunk_rest(seq__9899_10092__$1);
var G__10095 = c__5567__auto___10093;
var G__10096 = cljs.core.count(c__5567__auto___10093);
var G__10097 = (0);
seq__9899_10051 = G__10094;
chunk__9900_10052 = G__10095;
count__9901_10053 = G__10096;
i__9902_10054 = G__10097;
continue;
} else {
var vec__9936_10098 = cljs.core.first(seq__9899_10092__$1);
var column_10099 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9936_10098,(0),null);
var column_info_10100 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9936_10098,(1),null);
var seq__9939_10101 = cljs.core.seq(column_info_10100);
var chunk__9940_10102 = null;
var count__9941_10103 = (0);
var i__9942_10104 = (0);
while(true){
if((i__9942_10104 < count__9941_10103)){
var map__9945_10105 = chunk__9940_10102.cljs$core$IIndexed$_nth$arity$2(null,i__9942_10104);
var map__9945_10106__$1 = cljs.core.__destructure_map(map__9945_10105);
var gline_10107 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9945_10106__$1,cljs.core.cst$kw$gline);
var gcol_10108 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9945_10106__$1,cljs.core.cst$kw$gcol);
var name_10109 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9945_10106__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_10107], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9939_10101,chunk__9940_10102,count__9941_10103,i__9942_10104,seq__9899_10051,chunk__9900_10052,count__9901_10053,i__9902_10054,seq__9739_9947,chunk__9740_9948,count__9741_9949,i__9742_9950,map__9945_10105,map__9945_10106__$1,gline_10107,gcol_10108,name_10109,vec__9936_10098,column_10099,column_info_10100,seq__9899_10092__$1,temp__5804__auto___10091__$1,vec__9896_10048,line_10049,columns_10050,seq__9739_10042__$1,temp__5804__auto___10041,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_10108], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_10049,cljs.core.cst$kw$col,column_10099,cljs.core.cst$kw$name,name_10109], null));
});})(seq__9939_10101,chunk__9940_10102,count__9941_10103,i__9942_10104,seq__9899_10051,chunk__9900_10052,count__9901_10053,i__9902_10054,seq__9739_9947,chunk__9740_9948,count__9741_9949,i__9742_9950,map__9945_10105,map__9945_10106__$1,gline_10107,gcol_10108,name_10109,vec__9936_10098,column_10099,column_info_10100,seq__9899_10092__$1,temp__5804__auto___10091__$1,vec__9896_10048,line_10049,columns_10050,seq__9739_10042__$1,temp__5804__auto___10041,inverted))
,cljs.core.sorted_map()));


var G__10110 = seq__9939_10101;
var G__10111 = chunk__9940_10102;
var G__10112 = count__9941_10103;
var G__10113 = (i__9942_10104 + (1));
seq__9939_10101 = G__10110;
chunk__9940_10102 = G__10111;
count__9941_10103 = G__10112;
i__9942_10104 = G__10113;
continue;
} else {
var temp__5804__auto___10114__$2 = cljs.core.seq(seq__9939_10101);
if(temp__5804__auto___10114__$2){
var seq__9939_10115__$1 = temp__5804__auto___10114__$2;
if(cljs.core.chunked_seq_QMARK_(seq__9939_10115__$1)){
var c__5567__auto___10116 = cljs.core.chunk_first(seq__9939_10115__$1);
var G__10117 = cljs.core.chunk_rest(seq__9939_10115__$1);
var G__10118 = c__5567__auto___10116;
var G__10119 = cljs.core.count(c__5567__auto___10116);
var G__10120 = (0);
seq__9939_10101 = G__10117;
chunk__9940_10102 = G__10118;
count__9941_10103 = G__10119;
i__9942_10104 = G__10120;
continue;
} else {
var map__9946_10121 = cljs.core.first(seq__9939_10115__$1);
var map__9946_10122__$1 = cljs.core.__destructure_map(map__9946_10121);
var gline_10123 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9946_10122__$1,cljs.core.cst$kw$gline);
var gcol_10124 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9946_10122__$1,cljs.core.cst$kw$gcol);
var name_10125 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9946_10122__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_10123], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9939_10101,chunk__9940_10102,count__9941_10103,i__9942_10104,seq__9899_10051,chunk__9900_10052,count__9901_10053,i__9902_10054,seq__9739_9947,chunk__9740_9948,count__9741_9949,i__9742_9950,map__9946_10121,map__9946_10122__$1,gline_10123,gcol_10124,name_10125,seq__9939_10115__$1,temp__5804__auto___10114__$2,vec__9936_10098,column_10099,column_info_10100,seq__9899_10092__$1,temp__5804__auto___10091__$1,vec__9896_10048,line_10049,columns_10050,seq__9739_10042__$1,temp__5804__auto___10041,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_10124], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_10049,cljs.core.cst$kw$col,column_10099,cljs.core.cst$kw$name,name_10125], null));
});})(seq__9939_10101,chunk__9940_10102,count__9941_10103,i__9942_10104,seq__9899_10051,chunk__9900_10052,count__9901_10053,i__9902_10054,seq__9739_9947,chunk__9740_9948,count__9741_9949,i__9742_9950,map__9946_10121,map__9946_10122__$1,gline_10123,gcol_10124,name_10125,seq__9939_10115__$1,temp__5804__auto___10114__$2,vec__9936_10098,column_10099,column_info_10100,seq__9899_10092__$1,temp__5804__auto___10091__$1,vec__9896_10048,line_10049,columns_10050,seq__9739_10042__$1,temp__5804__auto___10041,inverted))
,cljs.core.sorted_map()));


var G__10126 = cljs.core.next(seq__9939_10115__$1);
var G__10127 = null;
var G__10128 = (0);
var G__10129 = (0);
seq__9939_10101 = G__10126;
chunk__9940_10102 = G__10127;
count__9941_10103 = G__10128;
i__9942_10104 = G__10129;
continue;
}
} else {
}
}
break;
}


var G__10130 = cljs.core.next(seq__9899_10092__$1);
var G__10131 = null;
var G__10132 = (0);
var G__10133 = (0);
seq__9899_10051 = G__10130;
chunk__9900_10052 = G__10131;
count__9901_10053 = G__10132;
i__9902_10054 = G__10133;
continue;
}
} else {
}
}
break;
}


var G__10134 = cljs.core.next(seq__9739_10042__$1);
var G__10135 = null;
var G__10136 = (0);
var G__10137 = (0);
seq__9739_9947 = G__10134;
chunk__9740_9948 = G__10135;
count__9741_9949 = G__10136;
i__9742_9950 = G__10137;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
