// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.crypto');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.crypto.sha2');
goog.require('fluree.crypto.sha3');
goog.require('fluree.crypto.aes');
goog.require('fluree.crypto.scrypt');
goog.require('fluree.crypto.ripemd');
goog.require('fluree.crypto.secp256k1');
goog.require('goog.crypt');
goog.require('alphabase.core');
goog.require('goog.object');
goog.scope(function(){
fluree.crypto.goog$module$goog$object = goog.module.get('goog.object');
});
/**
 * Normalizes string for consistent hashing.
 */
fluree.crypto.normalize_string = (function fluree$crypto$normalize_string(s){
return s.normalize("NFKC");
});
goog.exportSymbol('fluree.crypto.normalize_string', fluree.crypto.normalize_string);
/**
 * Does simple check when input format not specified.
 *   Assumes either string or bytes
 */
fluree.crypto.coerce_input_format = (function fluree$crypto$coerce_input_format(x){
if(typeof x === 'string'){
return cljs.core.cst$kw$string;
} else {
return cljs.core.cst$kw$bytes;
}
});
/**
 * Normalizes string then converts to a byte-array.
 *   If value is already a byte-array, returns original value.
 */
fluree.crypto.string__GT_byte_array = (function fluree$crypto$string__GT_byte_array(s){
return alphabase.core.string__GT_bytes(fluree.crypto.normalize_string(s));
});
goog.exportSymbol('fluree.crypto.string__GT_byte_array', fluree.crypto.string__GT_byte_array);
fluree.crypto.byte_array__GT_string = (function fluree$crypto$byte_array__GT_string(s){
return alphabase.core.bytes__GT_string(s);
});
goog.exportSymbol('fluree.crypto.byte_array__GT_string', fluree.crypto.byte_array__GT_string);
fluree.crypto.sha2_256 = (function fluree$crypto$sha2_256(var_args){
var G__46386 = arguments.length;
switch (G__46386) {
case 1:
return fluree.crypto.sha2_256.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.crypto.sha2_256.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.crypto.sha2_256.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('fluree.crypto.sha2_256', fluree.crypto.sha2_256);

(fluree.crypto.sha2_256.cljs$core$IFn$_invoke$arity$1 = (function (x){
return fluree.crypto.sha2_256.cljs$core$IFn$_invoke$arity$2(x,cljs.core.cst$kw$hex);
}));

(fluree.crypto.sha2_256.cljs$core$IFn$_invoke$arity$2 = (function (x,output_format){
return fluree.crypto.sha2_256.cljs$core$IFn$_invoke$arity$3(x,output_format,fluree.crypto.coerce_input_format(x));
}));

(fluree.crypto.sha2_256.cljs$core$IFn$_invoke$arity$3 = (function (x,output_format,input_format){
return alphabase.core.byte_array_to_base(fluree.crypto.sha2.sha2_256(alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(x,input_format)),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format));
}));

(fluree.crypto.sha2_256.cljs$lang$maxFixedArity = 3);

/**
 * sha2-256 hash of provided string after normalizing string.
 */
fluree.crypto.sha2_256_normalize = (function fluree$crypto$sha2_256_normalize(var_args){
var G__46389 = arguments.length;
switch (G__46389) {
case 1:
return fluree.crypto.sha2_256_normalize.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.crypto.sha2_256_normalize.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('fluree.crypto.sha2_256_normalize', fluree.crypto.sha2_256_normalize);

(fluree.crypto.sha2_256_normalize.cljs$core$IFn$_invoke$arity$1 = (function (s){
return fluree.crypto.sha2_256_normalize.cljs$core$IFn$_invoke$arity$2(s,cljs.core.cst$kw$hex);
}));

(fluree.crypto.sha2_256_normalize.cljs$core$IFn$_invoke$arity$2 = (function (s,output_format){
return fluree.crypto.sha2_256.cljs$core$IFn$_invoke$arity$3(fluree.crypto.normalize_string(s),output_format,cljs.core.cst$kw$string);
}));

(fluree.crypto.sha2_256_normalize.cljs$lang$maxFixedArity = 2);

fluree.crypto.sha2_512 = (function fluree$crypto$sha2_512(var_args){
var G__46392 = arguments.length;
switch (G__46392) {
case 1:
return fluree.crypto.sha2_512.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.crypto.sha2_512.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.crypto.sha2_512.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('fluree.crypto.sha2_512', fluree.crypto.sha2_512);

(fluree.crypto.sha2_512.cljs$core$IFn$_invoke$arity$1 = (function (x){
return fluree.crypto.sha2_512.cljs$core$IFn$_invoke$arity$2(x,cljs.core.cst$kw$hex);
}));

(fluree.crypto.sha2_512.cljs$core$IFn$_invoke$arity$2 = (function (x,output_format){
return fluree.crypto.sha2_512.cljs$core$IFn$_invoke$arity$3(x,output_format,fluree.crypto.coerce_input_format(x));
}));

(fluree.crypto.sha2_512.cljs$core$IFn$_invoke$arity$3 = (function (x,output_format,input_format){
return alphabase.core.byte_array_to_base(fluree.crypto.sha2.sha2_512(alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(x,input_format)),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format));
}));

(fluree.crypto.sha2_512.cljs$lang$maxFixedArity = 3);

/**
 * sha2-512 hash of provided string after normalizing string.
 */
fluree.crypto.sha2_512_normalize = (function fluree$crypto$sha2_512_normalize(var_args){
var G__46395 = arguments.length;
switch (G__46395) {
case 1:
return fluree.crypto.sha2_512_normalize.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.crypto.sha2_512_normalize.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('fluree.crypto.sha2_512_normalize', fluree.crypto.sha2_512_normalize);

(fluree.crypto.sha2_512_normalize.cljs$core$IFn$_invoke$arity$1 = (function (s){
return fluree.crypto.sha2_512_normalize.cljs$core$IFn$_invoke$arity$2(s,cljs.core.cst$kw$hex);
}));

(fluree.crypto.sha2_512_normalize.cljs$core$IFn$_invoke$arity$2 = (function (s,output_format){
return fluree.crypto.sha2_512.cljs$core$IFn$_invoke$arity$3(fluree.crypto.normalize_string(s),output_format,cljs.core.cst$kw$string);
}));

(fluree.crypto.sha2_512_normalize.cljs$lang$maxFixedArity = 2);

fluree.crypto.sha3_256 = (function fluree$crypto$sha3_256(var_args){
var G__46398 = arguments.length;
switch (G__46398) {
case 1:
return fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('fluree.crypto.sha3_256', fluree.crypto.sha3_256);

(fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1 = (function (x){
return fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$2(x,cljs.core.cst$kw$hex);
}));

(fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$2 = (function (x,output_format){
return fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$3(x,output_format,fluree.crypto.coerce_input_format(x));
}));

(fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$3 = (function (x,output_format,input_format){
return alphabase.core.byte_array_to_base(fluree.crypto.sha3.sha3_256(alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(x,input_format)),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format));
}));

(fluree.crypto.sha3_256.cljs$lang$maxFixedArity = 3);

/**
 * sha3-256 hash of provided string after normalizing string.
 */
fluree.crypto.sha3_256_normalize = (function fluree$crypto$sha3_256_normalize(var_args){
var G__46401 = arguments.length;
switch (G__46401) {
case 1:
return fluree.crypto.sha3_256_normalize.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.crypto.sha3_256_normalize.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('fluree.crypto.sha3_256_normalize', fluree.crypto.sha3_256_normalize);

(fluree.crypto.sha3_256_normalize.cljs$core$IFn$_invoke$arity$1 = (function (s){
return fluree.crypto.sha3_256_normalize.cljs$core$IFn$_invoke$arity$2(s,cljs.core.cst$kw$hex);
}));

(fluree.crypto.sha3_256_normalize.cljs$core$IFn$_invoke$arity$2 = (function (s,output_format){
return fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$3(fluree.crypto.normalize_string(s),output_format,cljs.core.cst$kw$string);
}));

(fluree.crypto.sha3_256_normalize.cljs$lang$maxFixedArity = 2);

fluree.crypto.sha3_512 = (function fluree$crypto$sha3_512(var_args){
var G__46404 = arguments.length;
switch (G__46404) {
case 1:
return fluree.crypto.sha3_512.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.crypto.sha3_512.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.crypto.sha3_512.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('fluree.crypto.sha3_512', fluree.crypto.sha3_512);

(fluree.crypto.sha3_512.cljs$core$IFn$_invoke$arity$1 = (function (x){
return fluree.crypto.sha3_512.cljs$core$IFn$_invoke$arity$2(x,cljs.core.cst$kw$hex);
}));

(fluree.crypto.sha3_512.cljs$core$IFn$_invoke$arity$2 = (function (x,output_format){
return fluree.crypto.sha3_512.cljs$core$IFn$_invoke$arity$3(x,output_format,fluree.crypto.coerce_input_format(x));
}));

(fluree.crypto.sha3_512.cljs$core$IFn$_invoke$arity$3 = (function (x,output_format,input_format){
return alphabase.core.byte_array_to_base(fluree.crypto.sha3.sha3_512(alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(x,input_format)),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format));
}));

(fluree.crypto.sha3_512.cljs$lang$maxFixedArity = 3);

/**
 * sha3-512 hash of provided string after normalizing string.
 */
fluree.crypto.sha3_512_normalize = (function fluree$crypto$sha3_512_normalize(var_args){
var G__46407 = arguments.length;
switch (G__46407) {
case 1:
return fluree.crypto.sha3_512_normalize.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.crypto.sha3_512_normalize.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('fluree.crypto.sha3_512_normalize', fluree.crypto.sha3_512_normalize);

(fluree.crypto.sha3_512_normalize.cljs$core$IFn$_invoke$arity$1 = (function (s){
return fluree.crypto.sha3_512_normalize.cljs$core$IFn$_invoke$arity$2(s,cljs.core.cst$kw$hex);
}));

(fluree.crypto.sha3_512_normalize.cljs$core$IFn$_invoke$arity$2 = (function (s,output_format){
return fluree.crypto.sha3_512.cljs$core$IFn$_invoke$arity$3(fluree.crypto.normalize_string(s),output_format,cljs.core.cst$kw$string);
}));

(fluree.crypto.sha3_512_normalize.cljs$lang$maxFixedArity = 2);

fluree.crypto.ripemd_160 = (function fluree$crypto$ripemd_160(var_args){
var G__46410 = arguments.length;
switch (G__46410) {
case 1:
return fluree.crypto.ripemd_160.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.crypto.ripemd_160.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.crypto.ripemd_160.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('fluree.crypto.ripemd_160', fluree.crypto.ripemd_160);

(fluree.crypto.ripemd_160.cljs$core$IFn$_invoke$arity$1 = (function (x){
return fluree.crypto.ripemd_160.cljs$core$IFn$_invoke$arity$2(x,cljs.core.cst$kw$hex);
}));

(fluree.crypto.ripemd_160.cljs$core$IFn$_invoke$arity$2 = (function (x,output_format){
return fluree.crypto.ripemd_160.cljs$core$IFn$_invoke$arity$3(x,output_format,fluree.crypto.coerce_input_format(x));
}));

(fluree.crypto.ripemd_160.cljs$core$IFn$_invoke$arity$3 = (function (x,output_format,input_format){
return alphabase.core.byte_array_to_base(fluree.crypto.ripemd.ripemd_160(alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(x,input_format)),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format));
}));

(fluree.crypto.ripemd_160.cljs$lang$maxFixedArity = 3);

fluree.crypto.aes_encrypt = (function fluree$crypto$aes_encrypt(var_args){
var G__46413 = arguments.length;
switch (G__46413) {
case 3:
return fluree.crypto.aes_encrypt.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.crypto.aes_encrypt.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('fluree.crypto.aes_encrypt', fluree.crypto.aes_encrypt);

(fluree.crypto.aes_encrypt.cljs$core$IFn$_invoke$arity$3 = (function (x,iv,key){
return fluree.crypto.aes_encrypt.cljs$core$IFn$_invoke$arity$4(x,iv,key,cljs.core.cst$kw$hex);
}));

(fluree.crypto.aes_encrypt.cljs$core$IFn$_invoke$arity$4 = (function (x,iv,key,output_format){
return fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic(x,key,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$iv,iv,cljs.core.cst$kw$output_DASH_format,output_format], null)], 0));
}));

(fluree.crypto.aes_encrypt.cljs$lang$maxFixedArity = 4);

fluree.crypto.aes_decrypt = (function fluree$crypto$aes_decrypt(var_args){
var G__46416 = arguments.length;
switch (G__46416) {
case 3:
return fluree.crypto.aes_decrypt.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.crypto.aes_decrypt.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.crypto.aes_decrypt.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('fluree.crypto.aes_decrypt', fluree.crypto.aes_decrypt);

(fluree.crypto.aes_decrypt.cljs$core$IFn$_invoke$arity$3 = (function (x,iv,key){
return fluree.crypto.aes_decrypt.cljs$core$IFn$_invoke$arity$5(x,iv,key,cljs.core.cst$kw$string,cljs.core.cst$kw$hex);
}));

(fluree.crypto.aes_decrypt.cljs$core$IFn$_invoke$arity$4 = (function (x,iv,key,output_format){
return fluree.crypto.aes_decrypt.cljs$core$IFn$_invoke$arity$5(x,iv,key,output_format,cljs.core.cst$kw$hex);
}));

(fluree.crypto.aes_decrypt.cljs$core$IFn$_invoke$arity$5 = (function (x,iv,key,output_format,input_format){
return fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic(x,key,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$iv,iv,cljs.core.cst$kw$input_DASH_format,input_format,cljs.core.cst$kw$output_DASH_format,output_format], null)], 0));
}));

(fluree.crypto.aes_decrypt.cljs$lang$maxFixedArity = 5);

fluree.crypto.generate_key_pair = (function fluree$crypto$generate_key_pair(var_args){
var G__46419 = arguments.length;
switch (G__46419) {
case 0:
return fluree.crypto.generate_key_pair.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.crypto.generate_key_pair.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('fluree.crypto.generate_key_pair', fluree.crypto.generate_key_pair);

(fluree.crypto.generate_key_pair.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.crypto.secp256k1.generate_key_pair.cljs$core$IFn$_invoke$arity$0();
}));

(fluree.crypto.generate_key_pair.cljs$core$IFn$_invoke$arity$1 = (function (private$){
return fluree.crypto.secp256k1.generate_key_pair.cljs$core$IFn$_invoke$arity$1(private$);
}));

(fluree.crypto.generate_key_pair.cljs$lang$maxFixedArity = 1);

/**
 * Take a private key as either a hex string or BigInteger (clj) bignumber (cljs), returns as a hex string.
 */
fluree.crypto.pub_key_from_private = (function fluree$crypto$pub_key_from_private(private_key){
var G__46421 = fluree.crypto.secp256k1.format_key_pair(fluree.crypto.secp256k1.public_key_from_private(private_key));
var G__46422 = "public";
return fluree.crypto.goog$module$goog$object.get.call(null,G__46421,G__46422);
});
goog.exportSymbol('fluree.crypto.pub_key_from_private', fluree.crypto.pub_key_from_private);
fluree.crypto.account_id_from_public = (function fluree$crypto$account_id_from_public(public_key){
return fluree.crypto.secp256k1.get_sin_from_public_key(public_key);
});
goog.exportSymbol('fluree.crypto.account_id_from_public', fluree.crypto.account_id_from_public);
fluree.crypto.account_id_from_private = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(fluree.crypto.account_id_from_public,fluree.crypto.pub_key_from_private);
goog.exportSymbol('fluree.crypto.account_id_from_private', fluree.crypto.account_id_from_private);
/**
 * Sign some message with provided private key.
 *   Message must be a byte-array or string.
 *   Private key must be hex-encoded or a BigInteger(clj)/bignumber(cljs).
 */
fluree.crypto.sign_message = (function fluree$crypto$sign_message(message,private_key){
return fluree.crypto.secp256k1.sign(message,private_key);
});
goog.exportSymbol('fluree.crypto.sign_message', fluree.crypto.sign_message);
/**
 * Verifies signature of message is valid.
 */
fluree.crypto.verify_signature = (function fluree$crypto$verify_signature(pub_key,message,signature){
return fluree.crypto.secp256k1.verify(pub_key,message,signature);
});
goog.exportSymbol('fluree.crypto.verify_signature', fluree.crypto.verify_signature);
/**
 * Returns public key, and verifies message is correctly signed.
 *   If not correctly signed, throws exception.
 */
fluree.crypto.pub_key_from_message = (function fluree$crypto$pub_key_from_message(message,signature){
return fluree.crypto.secp256k1.recover_public_key(message,signature);
});
goog.exportSymbol('fluree.crypto.pub_key_from_message', fluree.crypto.pub_key_from_message);
/**
 * Given a message and signature, returns the corresponding account id
 *   only if the signature is valid. If invalid, will throw exception.
 */
fluree.crypto.account_id_from_message = (function fluree$crypto$account_id_from_message(message,signature){
return fluree.crypto.account_id_from_public(fluree.crypto.pub_key_from_message(message,signature));
});
goog.exportSymbol('fluree.crypto.account_id_from_message', fluree.crypto.account_id_from_message);
/**
 * Encrypts a message (string) using a salt (bytes). Returns the encrypted message in hex.
 */
fluree.crypto.scrypt_encrypt = (function fluree$crypto$scrypt_encrypt(var_args){
var args__5774__auto__ = [];
var len__5768__auto___46425 = arguments.length;
var i__5769__auto___46426 = (0);
while(true){
if((i__5769__auto___46426 < len__5768__auto___46425)){
args__5774__auto__.push((arguments[i__5769__auto___46426]));

var G__46427 = (i__5769__auto___46426 + (1));
i__5769__auto___46426 = G__46427;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.crypto.scrypt_encrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});
goog.exportSymbol('fluree.crypto.scrypt_encrypt', fluree.crypto.scrypt_encrypt);

(fluree.crypto.scrypt_encrypt.cljs$core$IFn$_invoke$arity$variadic = (function (message,args){
var byte_msg = fluree.crypto.string__GT_byte_array(message);
return alphabase.core.byte_array_to_base(cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.crypto.scrypt.encrypt,byte_msg,args),cljs.core.cst$kw$hex);
}));

(fluree.crypto.scrypt_encrypt.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.crypto.scrypt_encrypt.cljs$lang$applyTo = (function (seq46423){
var G__46424 = cljs.core.first(seq46423);
var seq46423__$1 = cljs.core.next(seq46423);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46424,seq46423__$1);
}));

/**
 * Compares a message (string) with previously encrypted message (hex). 
 */
fluree.crypto.scrypt_check = (function fluree$crypto$scrypt_check(var_args){
var args__5774__auto__ = [];
var len__5768__auto___46431 = arguments.length;
var i__5769__auto___46432 = (0);
while(true){
if((i__5769__auto___46432 < len__5768__auto___46431)){
args__5774__auto__.push((arguments[i__5769__auto___46432]));

var G__46433 = (i__5769__auto___46432 + (1));
i__5769__auto___46432 = G__46433;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((2) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((2)),(0),null)):null);
return fluree.crypto.scrypt_check.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5775__auto__);
});
goog.exportSymbol('fluree.crypto.scrypt_check', fluree.crypto.scrypt_check);

(fluree.crypto.scrypt_check.cljs$core$IFn$_invoke$arity$variadic = (function (message,encrypted,args){
var byte_msg = fluree.crypto.string__GT_byte_array(message);
var byte_encryped = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(encrypted,cljs.core.cst$kw$hex);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(fluree.crypto.scrypt.check,byte_msg,byte_encryped,args);
}));

(fluree.crypto.scrypt_check.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.crypto.scrypt_check.cljs$lang$applyTo = (function (seq46428){
var G__46429 = cljs.core.first(seq46428);
var seq46428__$1 = cljs.core.next(seq46428);
var G__46430 = cljs.core.first(seq46428__$1);
var seq46428__$2 = cljs.core.next(seq46428__$1);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46429,G__46430,seq46428__$2);
}));

/**
 * Generates n random bytes.
 */
fluree.crypto.random_bytes = (function fluree$crypto$random_bytes(n){
return fluree.crypto.scrypt.random_bytes(n);
});
goog.exportSymbol('fluree.crypto.random_bytes', fluree.crypto.random_bytes);
