// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.conn_events');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.conn_events !== 'undefined') && (typeof fluree.db.conn_events.process_event !== 'undefined')){
} else {
fluree.db.conn_events.process_event = (function (){var method_table__5641__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5645__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__27439 = cljs.core.get_global_hierarchy;
return (fexpr__27439.cljs$core$IFn$_invoke$arity$0 ? fexpr__27439.cljs$core$IFn$_invoke$arity$0() : fexpr__27439.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.conn-events","process-event"),(function (_,event_type,___$1,___$2){
return event_type;
}),cljs.core.cst$kw$default,hierarchy__5645__auto__,method_table__5641__auto__,prefer_table__5642__auto__,method_cache__5643__auto__,cached_hierarchy__5644__auto__));
})();
}
fluree.db.conn_events.process_event.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set_DASH_ws_DASH_id,(function (conn,_,___$1,ws_id){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["set websocket id:",ws_id], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc,cljs.core.cst$kw$socket_DASH_id,ws_id);
}));
fluree.db.conn_events.process_event.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (conn,event_type,subject,event_data){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["process event:",event_type,event_data], 0));

var callbacks = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,subject], null));
var seq__27440 = cljs.core.seq(callbacks);
var chunk__27441 = null;
var count__27442 = (0);
var i__27443 = (0);
while(true){
if((i__27443 < count__27442)){
var vec__27452 = chunk__27441.cljs$core$IIndexed$_nth$arity$2(null,i__27443);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27452,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27452,(1),null);
try{(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(event_type,event_data) : f.call(null,event_type,event_data));
}catch (e27455){var e_27460 = e27455;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_27460,["Error calling registered callback: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k], 0))," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([event_data], 0)),"."].join('')], 0));
}

var G__27461 = seq__27440;
var G__27462 = chunk__27441;
var G__27463 = count__27442;
var G__27464 = (i__27443 + (1));
seq__27440 = G__27461;
chunk__27441 = G__27462;
count__27442 = G__27463;
i__27443 = G__27464;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__27440);
if(temp__5804__auto__){
var seq__27440__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__27440__$1)){
var c__5567__auto__ = cljs.core.chunk_first(seq__27440__$1);
var G__27465 = cljs.core.chunk_rest(seq__27440__$1);
var G__27466 = c__5567__auto__;
var G__27467 = cljs.core.count(c__5567__auto__);
var G__27468 = (0);
seq__27440 = G__27465;
chunk__27441 = G__27466;
count__27442 = G__27467;
i__27443 = G__27468;
continue;
} else {
var vec__27456 = cljs.core.first(seq__27440__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27456,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27456,(1),null);
try{(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(event_type,event_data) : f.call(null,event_type,event_data));
}catch (e27459){var e_27469 = e27459;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_27469,["Error calling registered callback: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k], 0))," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([event_data], 0)),"."].join('')], 0));
}

var G__27470 = cljs.core.next(seq__27440__$1);
var G__27471 = null;
var G__27472 = (0);
var G__27473 = (0);
seq__27440 = G__27470;
chunk__27441 = G__27471;
count__27442 = G__27472;
i__27443 = G__27473;
continue;
}
} else {
return null;
}
}
break;
}
}));
/**
 * Processes incoming events from the ledger.
 * 
 *   Requests that carry a :req-id in the header will attempt to lookup a
 *   corresponding return channel and send the message along on it.
 * 
 *   Otherwise looks for database events and updates local state accordingly.
 */
fluree.db.conn_events.process_events = (function fluree$db$conn_events$process_events(conn,msg){
try{var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Process events: ",msg], 0));
var vec__27476 = msg;
var event_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27476,(0),null);
var subject = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27476,(1),null);
var event_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27476,(2),null);
var error_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27476,(3),null);
var event_type__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(event_type);
var map__27479 = conn;
var map__27479__$1 = cljs.core.__destructure_map(map__27479);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27479__$1,cljs.core.cst$kw$state);
var G__27480 = event_type__$1;
var G__27480__$1 = (((G__27480 instanceof cljs.core.Keyword))?G__27480.fqn:null);
switch (G__27480__$1) {
case "response":
var temp__5804__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(state),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pending_DASH_req,subject], null));
if(cljs.core.truth_(temp__5804__auto__)){
var res_chan = temp__5804__auto__;
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Found response channel for subject",subject], 0));

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,cljs.core.cst$kw$pending_DASH_req,(function (p1__27474_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__27474_SHARP_,subject);
}));

if(cljs.core.truth_(error_data)){
var map__27481 = error_data;
var map__27481__$1 = cljs.core.__destructure_map(map__27481);
var message = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27481__$1,cljs.core.cst$kw$message);
var exception = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__5045__auto__ = message;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error_data], 0));
}
})(),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(error_data,cljs.core.cst$kw$message));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(res_chan,exception);
} else {
if(cljs.core.truth_(event_data)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(res_chan,event_data);
} else {
return cljs.core.async.close_BANG_(res_chan);

}
}
} else {
return null;
}

break;
case "pong":
return null;

break;
default:
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(conn,event_type__$1,subject,event_data) : fluree.db.conn_events.process_event.call(null,conn,event_type__$1,subject,event_data));

}
}catch (e27475){var e = e27475;
return fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0));
}});
