// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__75694_75863 = cljs.core.seq(servers);
var chunk__75695_75864 = null;
var count__75696_75865 = (0);
var i__75697_75866 = (0);
while(true){
if((i__75697_75866 < count__75696_75865)){
var server_75867 = chunk__75695_75864.cljs$core$IIndexed$_nth$arity$2(null,i__75697_75866);
var healthcheck_uri_75868 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_75867),"/fdb/health"].join('');
var resp_chan_75869 = fluree.db.util.xhttp.post_json(healthcheck_uri_75868,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_timeout,(5000)], null));
var c__15165__auto___75870 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__75694_75863,chunk__75695_75864,count__75696_75865,i__75697_75866,c__15165__auto___75870,healthcheck_uri_75868,resp_chan_75869,server_75867){
return (function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = ((function (seq__75694_75863,chunk__75695_75864,count__75696_75865,i__75697_75866,c__15165__auto___75870,healthcheck_uri_75868,resp_chan_75869,server_75867){
return (function (state_75758){
var state_val_75759 = (state_75758[(1)]);
if((state_val_75759 === (1))){
var state_75758__$1 = state_75758;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75758__$1,(2),resp_chan_75869);
} else {
if((state_val_75759 === (2))){
var inst_75747 = (state_75758[(7)]);
var inst_75747__$1 = (state_75758[(2)]);
var inst_75748 = fluree.db.util.core.exception_QMARK_(inst_75747__$1);
var state_75758__$1 = (function (){var statearr_75760 = state_75758;
(statearr_75760[(7)] = inst_75747__$1);

return statearr_75760;
})();
if(inst_75748){
var statearr_75761_75871 = state_75758__$1;
(statearr_75761_75871[(1)] = (3));

} else {
var statearr_75762_75872 = state_75758__$1;
(statearr_75762_75872[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75759 === (3))){
var inst_75747 = (state_75758[(7)]);
var inst_75750 = cljs.core.ex_message(inst_75747);
var inst_75751 = cljs.core.ex_data(inst_75747);
var inst_75752 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_75750,inst_75751], 0));
var state_75758__$1 = state_75758;
var statearr_75763_75873 = state_75758__$1;
(statearr_75763_75873[(2)] = inst_75752);

(statearr_75763_75873[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75759 === (4))){
var inst_75754 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_75867);
var state_75758__$1 = state_75758;
var statearr_75764_75874 = state_75758__$1;
(statearr_75764_75874[(2)] = inst_75754);

(statearr_75764_75874[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75759 === (5))){
var inst_75756 = (state_75758[(2)]);
var state_75758__$1 = state_75758;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75758__$1,inst_75756);
} else {
return null;
}
}
}
}
}
});})(seq__75694_75863,chunk__75695_75864,count__75696_75865,i__75697_75866,c__15165__auto___75870,healthcheck_uri_75868,resp_chan_75869,server_75867))
;
return ((function (seq__75694_75863,chunk__75695_75864,count__75696_75865,i__75697_75866,switch__15090__auto__,c__15165__auto___75870,healthcheck_uri_75868,resp_chan_75869,server_75867){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto____0 = (function (){
var statearr_75765 = [null,null,null,null,null,null,null,null];
(statearr_75765[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto__);

(statearr_75765[(1)] = (1));

return statearr_75765;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto____1 = (function (state_75758){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_75758);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e75766){var ex__15094__auto__ = e75766;
var statearr_75767_75875 = state_75758;
(statearr_75767_75875[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_75758[(4)]))){
var statearr_75768_75876 = state_75758;
(statearr_75768_75876[(1)] = cljs.core.first((state_75758[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__75877 = state_75758;
state_75758 = G__75877;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto__ = function(state_75758){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto____1.call(this,state_75758);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto__;
})()
;})(seq__75694_75863,chunk__75695_75864,count__75696_75865,i__75697_75866,switch__15090__auto__,c__15165__auto___75870,healthcheck_uri_75868,resp_chan_75869,server_75867))
})();
var state__15167__auto__ = (function (){var statearr_75769 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_75769[(6)] = c__15165__auto___75870);

return statearr_75769;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
});})(seq__75694_75863,chunk__75695_75864,count__75696_75865,i__75697_75866,c__15165__auto___75870,healthcheck_uri_75868,resp_chan_75869,server_75867))
);



var G__75878 = seq__75694_75863;
var G__75879 = chunk__75695_75864;
var G__75880 = count__75696_75865;
var G__75881 = (i__75697_75866 + (1));
seq__75694_75863 = G__75878;
chunk__75695_75864 = G__75879;
count__75696_75865 = G__75880;
i__75697_75866 = G__75881;
continue;
} else {
var temp__5804__auto___75882 = cljs.core.seq(seq__75694_75863);
if(temp__5804__auto___75882){
var seq__75694_75883__$1 = temp__5804__auto___75882;
if(cljs.core.chunked_seq_QMARK_(seq__75694_75883__$1)){
var c__5567__auto___75884 = cljs.core.chunk_first(seq__75694_75883__$1);
var G__75885 = cljs.core.chunk_rest(seq__75694_75883__$1);
var G__75886 = c__5567__auto___75884;
var G__75887 = cljs.core.count(c__5567__auto___75884);
var G__75888 = (0);
seq__75694_75863 = G__75885;
chunk__75695_75864 = G__75886;
count__75696_75865 = G__75887;
i__75697_75866 = G__75888;
continue;
} else {
var server_75889 = cljs.core.first(seq__75694_75883__$1);
var healthcheck_uri_75890 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_75889),"/fdb/health"].join('');
var resp_chan_75891 = fluree.db.util.xhttp.post_json(healthcheck_uri_75890,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_timeout,(5000)], null));
var c__15165__auto___75892 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__75694_75863,chunk__75695_75864,count__75696_75865,i__75697_75866,c__15165__auto___75892,healthcheck_uri_75890,resp_chan_75891,server_75889,seq__75694_75883__$1,temp__5804__auto___75882){
return (function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = ((function (seq__75694_75863,chunk__75695_75864,count__75696_75865,i__75697_75866,c__15165__auto___75892,healthcheck_uri_75890,resp_chan_75891,server_75889,seq__75694_75883__$1,temp__5804__auto___75882){
return (function (state_75782){
var state_val_75783 = (state_75782[(1)]);
if((state_val_75783 === (1))){
var state_75782__$1 = state_75782;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75782__$1,(2),resp_chan_75891);
} else {
if((state_val_75783 === (2))){
var inst_75771 = (state_75782[(7)]);
var inst_75771__$1 = (state_75782[(2)]);
var inst_75772 = fluree.db.util.core.exception_QMARK_(inst_75771__$1);
var state_75782__$1 = (function (){var statearr_75784 = state_75782;
(statearr_75784[(7)] = inst_75771__$1);

return statearr_75784;
})();
if(inst_75772){
var statearr_75785_75893 = state_75782__$1;
(statearr_75785_75893[(1)] = (3));

} else {
var statearr_75786_75894 = state_75782__$1;
(statearr_75786_75894[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75783 === (3))){
var inst_75771 = (state_75782[(7)]);
var inst_75774 = cljs.core.ex_message(inst_75771);
var inst_75775 = cljs.core.ex_data(inst_75771);
var inst_75776 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_75774,inst_75775], 0));
var state_75782__$1 = state_75782;
var statearr_75787_75895 = state_75782__$1;
(statearr_75787_75895[(2)] = inst_75776);

(statearr_75787_75895[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75783 === (4))){
var inst_75778 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_75889);
var state_75782__$1 = state_75782;
var statearr_75788_75896 = state_75782__$1;
(statearr_75788_75896[(2)] = inst_75778);

(statearr_75788_75896[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75783 === (5))){
var inst_75780 = (state_75782[(2)]);
var state_75782__$1 = state_75782;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75782__$1,inst_75780);
} else {
return null;
}
}
}
}
}
});})(seq__75694_75863,chunk__75695_75864,count__75696_75865,i__75697_75866,c__15165__auto___75892,healthcheck_uri_75890,resp_chan_75891,server_75889,seq__75694_75883__$1,temp__5804__auto___75882))
;
return ((function (seq__75694_75863,chunk__75695_75864,count__75696_75865,i__75697_75866,switch__15090__auto__,c__15165__auto___75892,healthcheck_uri_75890,resp_chan_75891,server_75889,seq__75694_75883__$1,temp__5804__auto___75882){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto____0 = (function (){
var statearr_75789 = [null,null,null,null,null,null,null,null];
(statearr_75789[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto__);

(statearr_75789[(1)] = (1));

return statearr_75789;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto____1 = (function (state_75782){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_75782);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e75790){var ex__15094__auto__ = e75790;
var statearr_75791_75897 = state_75782;
(statearr_75791_75897[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_75782[(4)]))){
var statearr_75792_75898 = state_75782;
(statearr_75792_75898[(1)] = cljs.core.first((state_75782[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__75899 = state_75782;
state_75782 = G__75899;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto__ = function(state_75782){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto____1.call(this,state_75782);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto__;
})()
;})(seq__75694_75863,chunk__75695_75864,count__75696_75865,i__75697_75866,switch__15090__auto__,c__15165__auto___75892,healthcheck_uri_75890,resp_chan_75891,server_75889,seq__75694_75883__$1,temp__5804__auto___75882))
})();
var state__15167__auto__ = (function (){var statearr_75793 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_75793[(6)] = c__15165__auto___75892);

return statearr_75793;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
});})(seq__75694_75863,chunk__75695_75864,count__75696_75865,i__75697_75866,c__15165__auto___75892,healthcheck_uri_75890,resp_chan_75891,server_75889,seq__75694_75883__$1,temp__5804__auto___75882))
);



var G__75900 = cljs.core.next(seq__75694_75883__$1);
var G__75901 = null;
var G__75902 = (0);
var G__75903 = (0);
seq__75694_75863 = G__75900;
chunk__75695_75864 = G__75901;
count__75696_75865 = G__75902;
i__75697_75866 = G__75903;
continue;
}
} else {
}
}
break;
}

var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_75837){
var state_val_75838 = (state_75837[(1)]);
if((state_val_75838 === (7))){
var inst_75809 = (state_75837[(7)]);
var inst_75816 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75809,cljs.core.cst$kw$default);
var state_75837__$1 = state_75837;
if(inst_75816){
var statearr_75839_75904 = state_75837__$1;
(statearr_75839_75904[(1)] = (9));

} else {
var statearr_75840_75905 = state_75837__$1;
(statearr_75840_75905[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75838 === (1))){
var inst_75802 = (state_75837[(8)]);
var inst_75801 = (state_75837[(9)]);
var inst_75801__$1 = promise_chan;
var inst_75802__$1 = cljs.core.async.timeout((60000));
var inst_75803 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75804 = [inst_75801__$1,inst_75802__$1];
var inst_75805 = (new cljs.core.PersistentVector(null,2,(5),inst_75803,inst_75804,null));
var state_75837__$1 = (function (){var statearr_75841 = state_75837;
(statearr_75841[(8)] = inst_75802__$1);

(statearr_75841[(9)] = inst_75801__$1);

return statearr_75841;
})();
return cljs.core.async.ioc_alts_BANG_(state_75837__$1,(2),inst_75805);
} else {
if((state_val_75838 === (4))){
var inst_75802 = (state_75837[(8)]);
var inst_75809 = (state_75837[(7)]);
var inst_75813 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75809,inst_75802);
var state_75837__$1 = state_75837;
if(inst_75813){
var statearr_75842_75906 = state_75837__$1;
(statearr_75842_75906[(1)] = (6));

} else {
var statearr_75843_75907 = state_75837__$1;
(statearr_75843_75907[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75838 === (13))){
var state_75837__$1 = state_75837;
var statearr_75844_75908 = state_75837__$1;
(statearr_75844_75908[(2)] = null);

(statearr_75844_75908[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75838 === (6))){
var state_75837__$1 = state_75837;
var statearr_75845_75909 = state_75837__$1;
(statearr_75845_75909[(2)] = cljs.core.cst$kw$fluree$db$connection_SLASH_timeout);

(statearr_75845_75909[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75838 === (3))){
var state_75837__$1 = state_75837;
var statearr_75846_75910 = state_75837__$1;
(statearr_75846_75910[(2)] = cljs.core.cst$kw$fluree$db$connection_SLASH_server_DASH_found);

(statearr_75846_75910[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75838 === (12))){
var inst_75827 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$server], 0));
var inst_75828 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_75829 = [(500),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_75830 = cljs.core.PersistentHashMap.fromArrays(inst_75828,inst_75829);
var inst_75831 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_75830);
var inst_75832 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_75831);
var state_75837__$1 = (function (){var statearr_75847 = state_75837;
(statearr_75847[(10)] = inst_75827);

return statearr_75847;
})();
var statearr_75848_75911 = state_75837__$1;
(statearr_75848_75911[(2)] = inst_75832);

(statearr_75848_75911[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75838 === (2))){
var inst_75809 = (state_75837[(7)]);
var inst_75801 = (state_75837[(9)]);
var inst_75807 = (state_75837[(2)]);
var inst_75808 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75807,(0),null);
var inst_75809__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75807,(1),null);
var inst_75810 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75809__$1,inst_75801);
var state_75837__$1 = (function (){var statearr_75849 = state_75837;
(statearr_75849[(7)] = inst_75809__$1);

(statearr_75849[(11)] = inst_75808);

return statearr_75849;
})();
if(inst_75810){
var statearr_75850_75912 = state_75837__$1;
(statearr_75850_75912[(1)] = (3));

} else {
var statearr_75851_75913 = state_75837__$1;
(statearr_75851_75913[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75838 === (11))){
var inst_75820 = (state_75837[(2)]);
var state_75837__$1 = state_75837;
var statearr_75852_75914 = state_75837__$1;
(statearr_75852_75914[(2)] = inst_75820);

(statearr_75852_75914[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75838 === (9))){
var inst_75808 = (state_75837[(11)]);
var state_75837__$1 = state_75837;
var statearr_75853_75915 = state_75837__$1;
(statearr_75853_75915[(2)] = inst_75808);

(statearr_75853_75915[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75838 === (5))){
var inst_75824 = (state_75837[(2)]);
var inst_75825 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$fluree$db$connection_SLASH_timeout,inst_75824);
var state_75837__$1 = state_75837;
if(inst_75825){
var statearr_75854_75916 = state_75837__$1;
(statearr_75854_75916[(1)] = (12));

} else {
var statearr_75855_75917 = state_75837__$1;
(statearr_75855_75917[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75838 === (14))){
var inst_75835 = (state_75837[(2)]);
var state_75837__$1 = state_75837;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75837__$1,inst_75835);
} else {
if((state_val_75838 === (10))){
var state_75837__$1 = state_75837;
var statearr_75856_75918 = state_75837__$1;
(statearr_75856_75918[(2)] = null);

(statearr_75856_75918[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75838 === (8))){
var inst_75822 = (state_75837[(2)]);
var state_75837__$1 = state_75837;
var statearr_75857_75919 = state_75837__$1;
(statearr_75857_75919[(2)] = inst_75822);

(statearr_75857_75919[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto____0 = (function (){
var statearr_75858 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75858[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto__);

(statearr_75858[(1)] = (1));

return statearr_75858;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto____1 = (function (state_75837){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_75837);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e75859){var ex__15094__auto__ = e75859;
var statearr_75860_75920 = state_75837;
(statearr_75860_75920[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_75837[(4)]))){
var statearr_75861_75921 = state_75837;
(statearr_75861_75921[(1)] = cljs.core.first((state_75837[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__75922 = state_75837;
state_75837 = G__75922;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto__ = function(state_75837){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto____1.call(this,state_75837);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_75862 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_75862[(6)] = c__15165__auto__);

return statearr_75862;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$lock_DASH_id,lock_id,cljs.core.cst$kw$chan,cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$lock_DASH_id], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$chan], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_75966){
var state_val_75967 = (state_75966[(1)]);
if((state_val_75967 === (7))){
var state_75966__$1 = state_75966;
var statearr_75968_75994 = state_75966__$1;
(statearr_75968_75994[(2)] = null);

(statearr_75968_75994[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75967 === (1))){
var state_75966__$1 = state_75966;
var statearr_75969_75995 = state_75966__$1;
(statearr_75969_75995[(2)] = null);

(statearr_75969_75995[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75967 === (4))){
var inst_75923 = (state_75966[(2)]);
var state_75966__$1 = state_75966;
var statearr_75970_75996 = state_75966__$1;
(statearr_75970_75996[(2)] = inst_75923);

(statearr_75970_75996[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75967 === (6))){
var inst_75945 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_75966__$1 = state_75966;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75966__$1,(9),inst_75945);
} else {
if((state_val_75967 === (3))){
var inst_75964 = (state_75966[(2)]);
var state_75966__$1 = state_75966;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75966__$1,inst_75964);
} else {
if((state_val_75967 === (12))){
var inst_75958 = (state_75966[(2)]);
var state_75966__$1 = state_75966;
var statearr_75971_75997 = state_75966__$1;
(statearr_75971_75997[(2)] = inst_75958);

(statearr_75971_75997[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75967 === (2))){
var inst_75929 = (state_75966[(7)]);
var inst_75939 = (state_75966[(8)]);
var inst_75934 = (state_75966[(9)]);
var _ = (function (){var statearr_75972 = state_75966;
(statearr_75972[(4)] = cljs.core.cons((5),(state_75966[(4)])));

return statearr_75972;
})();
var inst_75929__$1 = fluree.db.util.core.random_uuid();
var inst_75930 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75931 = [conn_id,cljs.core.cst$kw$ws];
var inst_75932 = (new cljs.core.PersistentVector(null,2,(5),inst_75930,inst_75931,null));
var inst_75933 = (function (){var lock_id = inst_75929__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$lock_DASH_id,lock_id,cljs.core.cst$kw$socket,cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_75934__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_75932,inst_75933);
var inst_75935 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75936 = [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$lock_DASH_id];
var inst_75937 = (new cljs.core.PersistentVector(null,3,(5),inst_75935,inst_75936,null));
var inst_75938 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_75934__$1,inst_75937);
var inst_75939__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75929__$1,inst_75938);
var inst_75940 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75941 = [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket];
var inst_75942 = (new cljs.core.PersistentVector(null,3,(5),inst_75940,inst_75941,null));
var inst_75943 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_75934__$1,inst_75942);
var state_75966__$1 = (function (){var statearr_75973 = state_75966;
(statearr_75973[(10)] = inst_75943);

(statearr_75973[(7)] = inst_75929__$1);

(statearr_75973[(8)] = inst_75939__$1);

(statearr_75973[(9)] = inst_75934__$1);

return statearr_75973;
})();
if(inst_75939__$1){
var statearr_75974_75998 = state_75966__$1;
(statearr_75974_75998[(1)] = (6));

} else {
var statearr_75975_75999 = state_75966__$1;
(statearr_75975_75999[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75967 === (11))){
var inst_75943 = (state_75966[(10)]);
var inst_75950 = (state_75966[(11)]);
var inst_75949 = (state_75966[(12)]);
var inst_75956 = fluree.db.util.xhttp.try_socket(inst_75949,sub_chan,pub_chan,inst_75943,(60000),inst_75950);
var state_75966__$1 = state_75966;
var statearr_75977_76000 = state_75966__$1;
(statearr_75977_76000[(2)] = inst_75956);

(statearr_75977_76000[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75967 === (9))){
var inst_75943 = (state_75966[(10)]);
var inst_75947 = (state_75966[(13)]);
var inst_75929 = (state_75966[(7)]);
var inst_75949 = (state_75966[(12)]);
var inst_75939 = (state_75966[(8)]);
var inst_75934 = (state_75966[(9)]);
var inst_75947__$1 = (state_75966[(2)]);
var inst_75948 = clojure.string.replace(inst_75947__$1,"http","ws");
var inst_75949__$1 = [inst_75948,"/fdb/ws"].join('');
var inst_75950 = (function (){var lock_id = inst_75929;
var state = inst_75934;
var have_lock_QMARK_ = inst_75939;
var resp_chan = inst_75943;
var healthy_server = inst_75947__$1;
var ws_url = inst_75949__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_75951 = fluree.db.util.core.exception_QMARK_(inst_75947__$1);
var state_75966__$1 = (function (){var statearr_75978 = state_75966;
(statearr_75978[(13)] = inst_75947__$1);

(statearr_75978[(11)] = inst_75950);

(statearr_75978[(12)] = inst_75949__$1);

return statearr_75978;
})();
if(inst_75951){
var statearr_75979_76001 = state_75966__$1;
(statearr_75979_76001[(1)] = (10));

} else {
var statearr_75980_76002 = state_75966__$1;
(statearr_75980_76002[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75967 === (5))){
var _ = (function (){var statearr_75981 = state_75966;
(statearr_75981[(4)] = cljs.core.rest((state_75966[(4)])));

return statearr_75981;
})();
var state_75966__$1 = state_75966;
var ex75976 = (state_75966__$1[(2)]);
var statearr_75982_76003 = state_75966__$1;
(statearr_75982_76003[(5)] = ex75976);


if((ex75976 instanceof Error)){
var statearr_75983_76004 = state_75966__$1;
(statearr_75983_76004[(1)] = (4));

(statearr_75983_76004[(5)] = null);

} else {
throw ex75976;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75967 === (10))){
var inst_75943 = (state_75966[(10)]);
var inst_75947 = (state_75966[(13)]);
var inst_75953 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$ws], 0));
var inst_75954 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_75943,inst_75947);
var state_75966__$1 = (function (){var statearr_75984 = state_75966;
(statearr_75984[(14)] = inst_75953);

return statearr_75984;
})();
var statearr_75985_76005 = state_75966__$1;
(statearr_75985_76005[(2)] = inst_75954);

(statearr_75985_76005[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75967 === (8))){
var inst_75943 = (state_75966[(10)]);
var inst_75961 = (state_75966[(2)]);
var _ = (function (){var statearr_75986 = state_75966;
(statearr_75986[(4)] = cljs.core.rest((state_75966[(4)])));

return statearr_75986;
})();
var state_75966__$1 = (function (){var statearr_75987 = state_75966;
(statearr_75987[(15)] = inst_75961);

return statearr_75987;
})();
var statearr_75988_76006 = state_75966__$1;
(statearr_75988_76006[(2)] = inst_75943);

(statearr_75988_76006[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__15091__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__15091__auto____0 = (function (){
var statearr_75989 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75989[(0)] = fluree$db$connection$establish_socket_$_state_machine__15091__auto__);

(statearr_75989[(1)] = (1));

return statearr_75989;
});
var fluree$db$connection$establish_socket_$_state_machine__15091__auto____1 = (function (state_75966){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_75966);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e75990){var ex__15094__auto__ = e75990;
var statearr_75991_76007 = state_75966;
(statearr_75991_76007[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_75966[(4)]))){
var statearr_75992_76008 = state_75966;
(statearr_75992_76008[(1)] = cljs.core.first((state_75966[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__76009 = state_75966;
state_75966 = G__76009;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__15091__auto__ = function(state_75966){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__15091__auto____1.call(this,state_75966);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__15091__auto____0;
fluree$db$connection$establish_socket_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__15091__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_75993 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_75993[(6)] = c__15165__auto__);

return statearr_75993;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5342__auto__,k__5343__auto__){
var self__ = this;
var this__5342__auto____$1 = this;
return this__5342__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5343__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5344__auto__,k76011,else__5345__auto__){
var self__ = this;
var this__5344__auto____$1 = this;
var G__76015 = k76011;
var G__76015__$1 = (((G__76015 instanceof cljs.core.Keyword))?G__76015.fqn:null);
switch (G__76015__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k76011,else__5345__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5362__auto__,f__5363__auto__,init__5364__auto__){
var self__ = this;
var this__5362__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5365__auto__,p__76016){
var vec__76017 = p__76016;
var k__5366__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__76017,(0),null);
var v__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__76017,(1),null);
return (f__5363__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5363__auto__.cljs$core$IFn$_invoke$arity$3(ret__5365__auto__,k__5366__auto__,v__5367__auto__) : f__5363__auto__.call(null,ret__5365__auto__,k__5366__auto__,v__5367__auto__));
}),init__5364__auto__,this__5362__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5357__auto__,writer__5358__auto__,opts__5359__auto__){
var self__ = this;
var this__5357__auto____$1 = this;
var pr_pair__5360__auto__ = (function (keyval__5361__auto__){
return cljs.core.pr_sequential_writer(writer__5358__auto__,cljs.core.pr_writer,""," ","",opts__5359__auto__,keyval__5361__auto__);
});
return cljs.core.pr_sequential_writer(writer__5358__auto__,pr_pair__5360__auto__,"#fluree.db.connection.Connection{",", ","}",opts__5359__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$servers,self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$req_DASH_chan,self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$sub_DASH_chan,self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$pub_DASH_chan,self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$group,self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$storage_DASH_read,self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$storage_DASH_write,self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$object_DASH_cache,self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$parallelism,self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$serializer,self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$default_DASH_network,self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transactor_QMARK_,self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$publish,self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_handler,self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tx_DASH_private_DASH_key,self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tx_DASH_key_DASH_id,self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$meta,self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$add_DASH_listener,self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$remove_DASH_listener,self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__76010){
var self__ = this;
var G__76010__$1 = this;
return (new cljs.core.RecordIter((0),G__76010__$1,22,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$servers,cljs.core.cst$kw$state,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$group,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$serializer,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$publish,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$meta,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$close], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5340__auto__){
var self__ = this;
var this__5340__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5337__auto__){
var self__ = this;
var this__5337__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5346__auto__){
var self__ = this;
var this__5346__auto____$1 = this;
return (22 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__76020 = (function (coll__5339__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__5339__auto__));
});
return fexpr__76020(this__5338__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this76012,other76013){
var self__ = this;
var this76012__$1 = this;
return (((!((other76013 == null)))) && ((((this76012__$1.constructor === other76013.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76012__$1.id,other76013.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76012__$1.servers,other76013.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76012__$1.state,other76013.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76012__$1.req_chan,other76013.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76012__$1.sub_chan,other76013.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76012__$1.pub_chan,other76013.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76012__$1.group,other76013.group)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76012__$1.storage_read,other76013.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76012__$1.storage_write,other76013.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76012__$1.object_cache,other76013.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76012__$1.parallelism,other76013.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76012__$1.serializer,other76013.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76012__$1.default_network,other76013.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76012__$1.transactor_QMARK_,other76013.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76012__$1.publish,other76013.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76012__$1.transact_handler,other76013.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76012__$1.tx_private_key,other76013.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76012__$1.tx_key_id,other76013.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76012__$1.meta,other76013.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76012__$1.add_listener,other76013.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76012__$1.remove_listener,other76013.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76012__$1.close,other76013.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76012__$1.__extmap,other76013.__extmap)))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5352__auto__,k__5353__auto__){
var self__ = this;
var this__5352__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, [cljs.core.cst$kw$object_DASH_cache,null,cljs.core.cst$kw$default_DASH_network,null,cljs.core.cst$kw$parallelism,null,cljs.core.cst$kw$transact_DASH_handler,null,cljs.core.cst$kw$add_DASH_listener,null,cljs.core.cst$kw$group,null,cljs.core.cst$kw$meta,null,cljs.core.cst$kw$tx_DASH_private_DASH_key,null,cljs.core.cst$kw$remove_DASH_listener,null,cljs.core.cst$kw$transactor_QMARK_,null,cljs.core.cst$kw$storage_DASH_read,null,cljs.core.cst$kw$serializer,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$tx_DASH_key_DASH_id,null,cljs.core.cst$kw$storage_DASH_write,null,cljs.core.cst$kw$req_DASH_chan,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$servers,null,cljs.core.cst$kw$pub_DASH_chan,null,cljs.core.cst$kw$sub_DASH_chan,null,cljs.core.cst$kw$publish,null], null), null),k__5353__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5352__auto____$1),self__.__meta),k__5353__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5353__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5349__auto__,k76011){
var self__ = this;
var this__5349__auto____$1 = this;
var G__76021 = k76011;
var G__76021__$1 = (((G__76021 instanceof cljs.core.Keyword))?G__76021.fqn:null);
switch (G__76021__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k76011);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5350__auto__,k__5351__auto__,G__76010){
var self__ = this;
var this__5350__auto____$1 = this;
var pred__76022 = cljs.core.keyword_identical_QMARK_;
var expr__76023 = k__5351__auto__;
if(cljs.core.truth_((function (){var G__76025 = cljs.core.cst$kw$id;
var G__76026 = expr__76023;
return (pred__76022.cljs$core$IFn$_invoke$arity$2 ? pred__76022.cljs$core$IFn$_invoke$arity$2(G__76025,G__76026) : pred__76022.call(null,G__76025,G__76026));
})())){
return (new fluree.db.connection.Connection(G__76010,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76027 = cljs.core.cst$kw$servers;
var G__76028 = expr__76023;
return (pred__76022.cljs$core$IFn$_invoke$arity$2 ? pred__76022.cljs$core$IFn$_invoke$arity$2(G__76027,G__76028) : pred__76022.call(null,G__76027,G__76028));
})())){
return (new fluree.db.connection.Connection(self__.id,G__76010,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76029 = cljs.core.cst$kw$state;
var G__76030 = expr__76023;
return (pred__76022.cljs$core$IFn$_invoke$arity$2 ? pred__76022.cljs$core$IFn$_invoke$arity$2(G__76029,G__76030) : pred__76022.call(null,G__76029,G__76030));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__76010,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76031 = cljs.core.cst$kw$req_DASH_chan;
var G__76032 = expr__76023;
return (pred__76022.cljs$core$IFn$_invoke$arity$2 ? pred__76022.cljs$core$IFn$_invoke$arity$2(G__76031,G__76032) : pred__76022.call(null,G__76031,G__76032));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__76010,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76033 = cljs.core.cst$kw$sub_DASH_chan;
var G__76034 = expr__76023;
return (pred__76022.cljs$core$IFn$_invoke$arity$2 ? pred__76022.cljs$core$IFn$_invoke$arity$2(G__76033,G__76034) : pred__76022.call(null,G__76033,G__76034));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__76010,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76035 = cljs.core.cst$kw$pub_DASH_chan;
var G__76036 = expr__76023;
return (pred__76022.cljs$core$IFn$_invoke$arity$2 ? pred__76022.cljs$core$IFn$_invoke$arity$2(G__76035,G__76036) : pred__76022.call(null,G__76035,G__76036));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__76010,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76037 = cljs.core.cst$kw$group;
var G__76038 = expr__76023;
return (pred__76022.cljs$core$IFn$_invoke$arity$2 ? pred__76022.cljs$core$IFn$_invoke$arity$2(G__76037,G__76038) : pred__76022.call(null,G__76037,G__76038));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__76010,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76039 = cljs.core.cst$kw$storage_DASH_read;
var G__76040 = expr__76023;
return (pred__76022.cljs$core$IFn$_invoke$arity$2 ? pred__76022.cljs$core$IFn$_invoke$arity$2(G__76039,G__76040) : pred__76022.call(null,G__76039,G__76040));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__76010,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76041 = cljs.core.cst$kw$storage_DASH_write;
var G__76042 = expr__76023;
return (pred__76022.cljs$core$IFn$_invoke$arity$2 ? pred__76022.cljs$core$IFn$_invoke$arity$2(G__76041,G__76042) : pred__76022.call(null,G__76041,G__76042));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__76010,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76043 = cljs.core.cst$kw$object_DASH_cache;
var G__76044 = expr__76023;
return (pred__76022.cljs$core$IFn$_invoke$arity$2 ? pred__76022.cljs$core$IFn$_invoke$arity$2(G__76043,G__76044) : pred__76022.call(null,G__76043,G__76044));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,G__76010,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76045 = cljs.core.cst$kw$parallelism;
var G__76046 = expr__76023;
return (pred__76022.cljs$core$IFn$_invoke$arity$2 ? pred__76022.cljs$core$IFn$_invoke$arity$2(G__76045,G__76046) : pred__76022.call(null,G__76045,G__76046));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,G__76010,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76047 = cljs.core.cst$kw$serializer;
var G__76048 = expr__76023;
return (pred__76022.cljs$core$IFn$_invoke$arity$2 ? pred__76022.cljs$core$IFn$_invoke$arity$2(G__76047,G__76048) : pred__76022.call(null,G__76047,G__76048));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__76010,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76049 = cljs.core.cst$kw$default_DASH_network;
var G__76050 = expr__76023;
return (pred__76022.cljs$core$IFn$_invoke$arity$2 ? pred__76022.cljs$core$IFn$_invoke$arity$2(G__76049,G__76050) : pred__76022.call(null,G__76049,G__76050));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__76010,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76051 = cljs.core.cst$kw$transactor_QMARK_;
var G__76052 = expr__76023;
return (pred__76022.cljs$core$IFn$_invoke$arity$2 ? pred__76022.cljs$core$IFn$_invoke$arity$2(G__76051,G__76052) : pred__76022.call(null,G__76051,G__76052));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__76010,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76053 = cljs.core.cst$kw$publish;
var G__76054 = expr__76023;
return (pred__76022.cljs$core$IFn$_invoke$arity$2 ? pred__76022.cljs$core$IFn$_invoke$arity$2(G__76053,G__76054) : pred__76022.call(null,G__76053,G__76054));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__76010,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76055 = cljs.core.cst$kw$transact_DASH_handler;
var G__76056 = expr__76023;
return (pred__76022.cljs$core$IFn$_invoke$arity$2 ? pred__76022.cljs$core$IFn$_invoke$arity$2(G__76055,G__76056) : pred__76022.call(null,G__76055,G__76056));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__76010,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76057 = cljs.core.cst$kw$tx_DASH_private_DASH_key;
var G__76058 = expr__76023;
return (pred__76022.cljs$core$IFn$_invoke$arity$2 ? pred__76022.cljs$core$IFn$_invoke$arity$2(G__76057,G__76058) : pred__76022.call(null,G__76057,G__76058));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__76010,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76059 = cljs.core.cst$kw$tx_DASH_key_DASH_id;
var G__76060 = expr__76023;
return (pred__76022.cljs$core$IFn$_invoke$arity$2 ? pred__76022.cljs$core$IFn$_invoke$arity$2(G__76059,G__76060) : pred__76022.call(null,G__76059,G__76060));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__76010,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76061 = cljs.core.cst$kw$meta;
var G__76062 = expr__76023;
return (pred__76022.cljs$core$IFn$_invoke$arity$2 ? pred__76022.cljs$core$IFn$_invoke$arity$2(G__76061,G__76062) : pred__76022.call(null,G__76061,G__76062));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__76010,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76063 = cljs.core.cst$kw$add_DASH_listener;
var G__76064 = expr__76023;
return (pred__76022.cljs$core$IFn$_invoke$arity$2 ? pred__76022.cljs$core$IFn$_invoke$arity$2(G__76063,G__76064) : pred__76022.call(null,G__76063,G__76064));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__76010,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76065 = cljs.core.cst$kw$remove_DASH_listener;
var G__76066 = expr__76023;
return (pred__76022.cljs$core$IFn$_invoke$arity$2 ? pred__76022.cljs$core$IFn$_invoke$arity$2(G__76065,G__76066) : pred__76022.call(null,G__76065,G__76066));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__76010,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76067 = cljs.core.cst$kw$close;
var G__76068 = expr__76023;
return (pred__76022.cljs$core$IFn$_invoke$arity$2 ? pred__76022.cljs$core$IFn$_invoke$arity$2(G__76067,G__76068) : pred__76022.call(null,G__76067,G__76068));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__76010,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5351__auto__,G__76010),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5355__auto__){
var self__ = this;
var this__5355__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$servers,self__.servers,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$req_DASH_chan,self__.req_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$sub_DASH_chan,self__.sub_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$pub_DASH_chan,self__.pub_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$group,self__.group,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$storage_DASH_read,self__.storage_read,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$storage_DASH_write,self__.storage_write,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$object_DASH_cache,self__.object_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$parallelism,self__.parallelism,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$serializer,self__.serializer,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$default_DASH_network,self__.default_network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transactor_QMARK_,self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$publish,self__.publish,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_handler,self__.transact_handler,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tx_DASH_private_DASH_key,self__.tx_private_key,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tx_DASH_key_DASH_id,self__.tx_key_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$meta,self__.meta,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$add_DASH_listener,self__.add_listener,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$remove_DASH_listener,self__.remove_listener,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5341__auto__,G__76010){
var self__ = this;
var this__5341__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__76010,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5347__auto__,entry__5348__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5348__auto__)){
return this__5347__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5347__auto____$1,entry__5348__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$id,cljs.core.cst$sym$servers,cljs.core.cst$sym$state,cljs.core.cst$sym$req_DASH_chan,cljs.core.cst$sym$sub_DASH_chan,cljs.core.cst$sym$pub_DASH_chan,cljs.core.cst$sym$group,cljs.core.cst$sym$storage_DASH_read,cljs.core.cst$sym$storage_DASH_write,cljs.core.cst$sym$object_DASH_cache,cljs.core.cst$sym$parallelism,cljs.core.cst$sym$serializer,cljs.core.cst$sym$default_DASH_network,cljs.core.cst$sym$transactor_QMARK_,cljs.core.cst$sym$publish,cljs.core.cst$sym$transact_DASH_handler,cljs.core.cst$sym$tx_DASH_private_DASH_key,cljs.core.cst$sym$tx_DASH_key_DASH_id,cljs.core.cst$sym$meta,cljs.core.cst$sym$add_DASH_listener,cljs.core.cst$sym$remove_DASH_listener,cljs.core.cst$sym$close], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__5388__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__5388__auto__,writer__5389__auto__){
return cljs.core._write(writer__5389__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__76014){
var extmap__5384__auto__ = (function (){var G__76069 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__76014,cljs.core.cst$kw$id,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$servers,cljs.core.cst$kw$state,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$group,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$serializer,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$publish,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$meta,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$close], 0));
if(cljs.core.record_QMARK_(G__76014)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__76069);
} else {
return G__76069;
}
})();
return (new fluree.db.connection.Connection(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__76014),cljs.core.cst$kw$servers.cljs$core$IFn$_invoke$arity$1(G__76014),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__76014),cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__76014),cljs.core.cst$kw$sub_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__76014),cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__76014),cljs.core.cst$kw$group.cljs$core$IFn$_invoke$arity$1(G__76014),cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(G__76014),cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(G__76014),cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__76014),cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(G__76014),cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(G__76014),cljs.core.cst$kw$default_DASH_network.cljs$core$IFn$_invoke$arity$1(G__76014),cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(G__76014),cljs.core.cst$kw$publish.cljs$core$IFn$_invoke$arity$1(G__76014),cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(G__76014),cljs.core.cst$kw$tx_DASH_private_DASH_key.cljs$core$IFn$_invoke$arity$1(G__76014),cljs.core.cst$kw$tx_DASH_key_DASH_id.cljs$core$IFn$_invoke$arity$1(G__76014),cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(G__76014),cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(G__76014),cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(G__76014),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__76014),null,cljs.core.not_empty(extmap__5384__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__76075 = servers_STAR_;
var vec__76076 = G__76075;
var seq__76077 = cljs.core.seq(vec__76076);
var first__76078 = cljs.core.first(seq__76077);
var seq__76077__$1 = cljs.core.next(seq__76077);
var server = first__76078;
var r = seq__76077__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__76075__$1 = G__76075;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__76082 = G__76075__$1;
var seq__76083 = cljs.core.seq(vec__76082);
var first__76084 = cljs.core.first(seq__76083);
var seq__76083__$1 = cljs.core.next(seq__76083);
var server__$1 = first__76084;
var r__$1 = seq__76083__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__76085 = r__$1;
var G__76086 = is_https_QMARK_;
var G__76087 = result_STAR_;
G__76075__$1 = G__76085;
https_QMARK___$1 = G__76086;
result__$1 = G__76087;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__76088 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket], null));
if((G__76088 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__76088);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_76117){
var state_val_76118 = (state_76117[(1)]);
if((state_val_76118 === (7))){
var inst_76103 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_76104 = cljs.core.cst$kw$sub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_76105 = cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_76106 = cljs.core.cst$kw$servers.cljs$core$IFn$_invoke$arity$1(conn);
var inst_76107 = fluree.db.connection.establish_socket(inst_76103,inst_76104,inst_76105,inst_76106);
var state_76117__$1 = state_76117;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76117__$1,(9),inst_76107);
} else {
if((state_val_76118 === (1))){
var state_76117__$1 = state_76117;
var statearr_76119_76138 = state_76117__$1;
(statearr_76119_76138[(2)] = null);

(statearr_76119_76138[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76118 === (4))){
var inst_76089 = (state_76117[(2)]);
var state_76117__$1 = state_76117;
var statearr_76120_76139 = state_76117__$1;
(statearr_76120_76139[(2)] = inst_76089);

(statearr_76120_76139[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76118 === (6))){
var inst_76100 = (state_76117[(7)]);
var state_76117__$1 = state_76117;
var statearr_76121_76140 = state_76117__$1;
(statearr_76121_76140[(2)] = inst_76100);

(statearr_76121_76140[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76118 === (3))){
var inst_76115 = (state_76117[(2)]);
var state_76117__$1 = state_76117;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76117__$1,inst_76115);
} else {
if((state_val_76118 === (2))){
var inst_76100 = (state_76117[(7)]);
var _ = (function (){var statearr_76123 = state_76117;
(statearr_76123[(4)] = cljs.core.cons((5),(state_76117[(4)])));

return statearr_76123;
})();
var inst_76095 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_76096 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76097 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_76098 = [inst_76097,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket];
var inst_76099 = (new cljs.core.PersistentVector(null,3,(5),inst_76096,inst_76098,null));
var inst_76100__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_76095,inst_76099);
var state_76117__$1 = (function (){var statearr_76124 = state_76117;
(statearr_76124[(7)] = inst_76100__$1);

return statearr_76124;
})();
if(cljs.core.truth_(inst_76100__$1)){
var statearr_76125_76141 = state_76117__$1;
(statearr_76125_76141[(1)] = (6));

} else {
var statearr_76126_76142 = state_76117__$1;
(statearr_76126_76142[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76118 === (9))){
var inst_76109 = (state_76117[(2)]);
var inst_76110 = fluree.db.util.async.throw_err(inst_76109);
var state_76117__$1 = state_76117;
var statearr_76127_76143 = state_76117__$1;
(statearr_76127_76143[(2)] = inst_76110);

(statearr_76127_76143[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76118 === (5))){
var _ = (function (){var statearr_76128 = state_76117;
(statearr_76128[(4)] = cljs.core.rest((state_76117[(4)])));

return statearr_76128;
})();
var state_76117__$1 = state_76117;
var ex76122 = (state_76117__$1[(2)]);
var statearr_76129_76144 = state_76117__$1;
(statearr_76129_76144[(5)] = ex76122);


if((ex76122 instanceof Error)){
var statearr_76130_76145 = state_76117__$1;
(statearr_76130_76145[(1)] = (4));

(statearr_76130_76145[(5)] = null);

} else {
throw ex76122;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76118 === (8))){
var inst_76112 = (state_76117[(2)]);
var _ = (function (){var statearr_76131 = state_76117;
(statearr_76131[(4)] = cljs.core.rest((state_76117[(4)])));

return statearr_76131;
})();
var state_76117__$1 = state_76117;
var statearr_76132_76146 = state_76117__$1;
(statearr_76132_76146[(2)] = inst_76112);

(statearr_76132_76146[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__15091__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__15091__auto____0 = (function (){
var statearr_76133 = [null,null,null,null,null,null,null,null];
(statearr_76133[(0)] = fluree$db$connection$get_socket_$_state_machine__15091__auto__);

(statearr_76133[(1)] = (1));

return statearr_76133;
});
var fluree$db$connection$get_socket_$_state_machine__15091__auto____1 = (function (state_76117){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_76117);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e76134){var ex__15094__auto__ = e76134;
var statearr_76135_76147 = state_76117;
(statearr_76135_76147[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_76117[(4)]))){
var statearr_76136_76148 = state_76117;
(statearr_76136_76148[(1)] = cljs.core.first((state_76117[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__76149 = state_76117;
state_76117 = G__76149;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__15091__auto__ = function(state_76117){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__15091__auto____1.call(this,state_76117);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__15091__auto____0;
fluree$db$connection$get_socket_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__15091__auto____1;
return fluree$db$connection$get_socket_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_76137 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_76137[(6)] = c__15165__auto__);

return statearr_76137;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$chan], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e76150){var e = e76150;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__5045__auto__ = cljs.core.cst$kw$publish.cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_76277){
var state_val_76278 = (state_76277[(1)]);
if((state_val_76278 === (7))){
var inst_76273 = (state_76277[(2)]);
var state_76277__$1 = state_76277;
var statearr_76280_76350 = state_76277__$1;
(statearr_76280_76350[(2)] = inst_76273);

(statearr_76280_76350[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (20))){
var _ = (function (){var statearr_76281 = state_76277;
(statearr_76281[(4)] = cljs.core.rest((state_76277[(4)])));

return statearr_76281;
})();
var state_76277__$1 = state_76277;
var ex76279 = (state_76277__$1[(2)]);
var statearr_76282_76351 = state_76277__$1;
(statearr_76282_76351[(5)] = ex76279);


var statearr_76283_76352 = state_76277__$1;
(statearr_76283_76352[(1)] = (10));

(statearr_76283_76352[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (27))){
var inst_76265 = (state_76277[(2)]);
var _ = (function (){var statearr_76284 = state_76277;
(statearr_76284[(4)] = cljs.core.rest((state_76277[(4)])));

return statearr_76284;
})();
var state_76277__$1 = state_76277;
var statearr_76285_76353 = state_76277__$1;
(statearr_76285_76353[(2)] = inst_76265);

(statearr_76285_76353[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (1))){
var inst_76152 = (0);
var state_76277__$1 = (function (){var statearr_76286 = state_76277;
(statearr_76286[(7)] = inst_76152);

return statearr_76286;
})();
var statearr_76287_76354 = state_76277__$1;
(statearr_76287_76354[(2)] = null);

(statearr_76287_76354[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (24))){
var inst_76243 = (state_76277[(8)]);
var inst_76243__$1 = (state_76277[(2)]);
var inst_76244 = inst_76243__$1 === true;
var state_76277__$1 = (function (){var statearr_76288 = state_76277;
(statearr_76288[(8)] = inst_76243__$1);

return statearr_76288;
})();
if(cljs.core.truth_(inst_76244)){
var statearr_76289_76355 = state_76277__$1;
(statearr_76289_76355[(1)] = (25));

} else {
var statearr_76290_76356 = state_76277__$1;
(statearr_76290_76356[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (4))){
var inst_76155 = (state_76277[(9)]);
var inst_76155__$1 = (state_76277[(2)]);
var state_76277__$1 = (function (){var statearr_76291 = state_76277;
(statearr_76291[(9)] = inst_76155__$1);

return statearr_76291;
})();
if(cljs.core.truth_(inst_76155__$1)){
var statearr_76292_76357 = state_76277__$1;
(statearr_76292_76357[(1)] = (5));

} else {
var statearr_76293_76358 = state_76277__$1;
(statearr_76293_76358[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (15))){
var inst_76168 = (state_76277[(10)]);
var state_76277__$1 = state_76277;
var statearr_76294_76359 = state_76277__$1;
(statearr_76294_76359[(2)] = inst_76168);

(statearr_76294_76359[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (21))){
var inst_76152 = (state_76277[(7)]);
var inst_76196 = (state_76277[(11)]);
var inst_76194 = (state_76277[(12)]);
var inst_76192 = (state_76277[(13)]);
var inst_76193 = (state_76277[(14)]);
var inst_76195 = (state_76277[(15)]);
var inst_76155 = (state_76277[(9)]);
var inst_76199 = (state_76277[(16)]);
var inst_76200 = (state_76277[(17)]);
var inst_76191 = (state_76277[(18)]);
var inst_76202 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76203 = [cljs.core.cst$kw$pending_DASH_req,inst_76199];
var inst_76204 = (new cljs.core.PersistentVector(null,2,(5),inst_76202,inst_76203,null));
var inst_76205 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_76204,inst_76194);
var inst_76232 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_76233 = (function (){var resp_chan = inst_76194;
var timeout = inst_76200;
var i = inst_76152;
var data = inst_76193;
var vec__76187 = inst_76155;
var _ = inst_76191;
var req_id = inst_76199;
var operation = inst_76192;
var msg = inst_76155;
var c__15165__auto____$1 = inst_76232;
var map__76190 = inst_76196;
var opts = inst_76195;
return (function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_76230){
var state_val_76231 = (state_76230[(1)]);
if((state_val_76231 === (1))){
var inst_76209 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76210 = cljs.core.async.timeout(timeout);
var inst_76211 = [resp_chan,inst_76210];
var inst_76212 = (new cljs.core.PersistentVector(null,2,(5),inst_76209,inst_76211,null));
var state_76230__$1 = state_76230;
return cljs.core.async.ioc_alts_BANG_(state_76230__$1,(2),inst_76212);
} else {
if((state_val_76231 === (2))){
var inst_76215 = (state_76230[(7)]);
var inst_76214 = (state_76230[(2)]);
var inst_76215__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76214,(0),null);
var inst_76216 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76214,(1),null);
var inst_76217 = (function (){var vec__76206 = inst_76214;
var resp = inst_76215__$1;
var c = inst_76216;
return (function (p1__76151_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__76151_SHARP_,req_id);
});
})();
var inst_76218 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,cljs.core.cst$kw$pending_DASH_req,inst_76217);
var inst_76219 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_76216,resp_chan);
var state_76230__$1 = (function (){var statearr_76295 = state_76230;
(statearr_76295[(7)] = inst_76215__$1);

(statearr_76295[(8)] = inst_76218);

return statearr_76295;
})();
if(inst_76219){
var statearr_76296_76360 = state_76230__$1;
(statearr_76296_76360[(1)] = (3));

} else {
var statearr_76297_76361 = state_76230__$1;
(statearr_76297_76361[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76231 === (3))){
var inst_76215 = (state_76230[(7)]);
var state_76230__$1 = state_76230;
var statearr_76298_76362 = state_76230__$1;
(statearr_76298_76362[(2)] = inst_76215);

(statearr_76298_76362[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76231 === (4))){
var inst_76222 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_76223 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_76224 = [(408),cljs.core.cst$kw$db_SLASH_timeout];
var inst_76225 = cljs.core.PersistentHashMap.fromArrays(inst_76223,inst_76224);
var inst_76226 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_76222,inst_76225);
var state_76230__$1 = state_76230;
var statearr_76299_76363 = state_76230__$1;
(statearr_76299_76363[(2)] = inst_76226);

(statearr_76299_76363[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76231 === (5))){
var inst_76228 = (state_76230[(2)]);
var state_76230__$1 = state_76230;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76230__$1,inst_76228);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__15091__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__15091__auto____0 = (function (){
var statearr_76300 = [null,null,null,null,null,null,null,null,null];
(statearr_76300[(0)] = fluree$db$connection$msg_producer_$_state_machine__15091__auto__);

(statearr_76300[(1)] = (1));

return statearr_76300;
});
var fluree$db$connection$msg_producer_$_state_machine__15091__auto____1 = (function (state_76230){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_76230);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e76301){var ex__15094__auto__ = e76301;
var statearr_76302_76364 = state_76230;
(statearr_76302_76364[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_76230[(4)]))){
var statearr_76303_76365 = state_76230;
(statearr_76303_76365[(1)] = cljs.core.first((state_76230[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__76366 = state_76230;
state_76230 = G__76366;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__15091__auto__ = function(state_76230){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__15091__auto____1.call(this,state_76230);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__15091__auto____0;
fluree$db$connection$msg_producer_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__15091__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_76304 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_76304[(6)] = c__15165__auto____$1);

return statearr_76304;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
});
})();
var inst_76234 = cljs.core.async.impl.dispatch.run(inst_76233);
var state_76277__$1 = (function (){var statearr_76305 = state_76277;
(statearr_76305[(19)] = inst_76234);

(statearr_76305[(20)] = inst_76205);

return statearr_76305;
})();
var statearr_76306_76367 = state_76277__$1;
(statearr_76306_76367[(2)] = inst_76232);

(statearr_76306_76367[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (31))){
var inst_76253 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_76277__$1 = state_76277;
var statearr_76307_76368 = state_76277__$1;
(statearr_76307_76368[(2)] = inst_76253);

(statearr_76307_76368[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (32))){
var state_76277__$1 = state_76277;
var statearr_76308_76369 = state_76277__$1;
(statearr_76308_76369[(1)] = (34));



return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (33))){
var inst_76261 = (state_76277[(2)]);
var state_76277__$1 = state_76277;
var statearr_76310_76370 = state_76277__$1;
(statearr_76310_76370[(2)] = inst_76261);

(statearr_76310_76370[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (13))){
var inst_76168 = (state_76277[(10)]);
var inst_76165 = (state_76277[(2)]);
var inst_76166 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76165,(0),null);
var inst_76167 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76165,(1),null);
var inst_76168__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76165,(2),null);
var state_76277__$1 = (function (){var statearr_76311 = state_76277;
(statearr_76311[(10)] = inst_76168__$1);

(statearr_76311[(21)] = inst_76166);

(statearr_76311[(22)] = inst_76167);

return statearr_76311;
})();
if(cljs.core.truth_(inst_76168__$1)){
var statearr_76312_76371 = state_76277__$1;
(statearr_76312_76371[(1)] = (14));

} else {
var statearr_76313_76372 = state_76277__$1;
(statearr_76313_76372[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (22))){
var state_76277__$1 = state_76277;
var statearr_76314_76373 = state_76277__$1;
(statearr_76314_76373[(2)] = null);

(statearr_76314_76373[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (36))){
var inst_76259 = (state_76277[(2)]);
var state_76277__$1 = state_76277;
var statearr_76315_76374 = state_76277__$1;
(statearr_76315_76374[(2)] = inst_76259);

(statearr_76315_76374[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (29))){
var inst_76243 = (state_76277[(8)]);
var inst_76251 = (inst_76243 == null);
var state_76277__$1 = state_76277;
if(cljs.core.truth_(inst_76251)){
var statearr_76316_76375 = state_76277__$1;
(statearr_76316_76375[(1)] = (31));

} else {
var statearr_76317_76376 = state_76277__$1;
(statearr_76317_76376[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (6))){
var state_76277__$1 = state_76277;
var statearr_76318_76377 = state_76277__$1;
(statearr_76318_76377[(2)] = null);

(statearr_76318_76377[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (28))){
var inst_76243 = (state_76277[(8)]);
var inst_76249 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76243,"Error processing message in producer."], 0));
var state_76277__$1 = state_76277;
var statearr_76319_76378 = state_76277__$1;
(statearr_76319_76378[(2)] = inst_76249);

(statearr_76319_76378[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (25))){
var state_76277__$1 = state_76277;
var statearr_76320_76379 = state_76277__$1;
(statearr_76320_76379[(2)] = null);

(statearr_76320_76379[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (34))){
var inst_76243 = (state_76277[(8)]);
var inst_76256 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_76243], 0));
var state_76277__$1 = state_76277;
var statearr_76321_76380 = state_76277__$1;
(statearr_76321_76380[(2)] = inst_76256);

(statearr_76321_76380[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (17))){
var inst_76157 = (state_76277[(23)]);
var inst_76168 = (state_76277[(10)]);
var inst_76175 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_76168,inst_76157);
var state_76277__$1 = state_76277;
var statearr_76322_76381 = state_76277__$1;
(statearr_76322_76381[(2)] = inst_76175);

(statearr_76322_76381[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (3))){
var inst_76275 = (state_76277[(2)]);
var state_76277__$1 = state_76277;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76277__$1,inst_76275);
} else {
if((state_val_76278 === (12))){
var state_76277__$1 = state_76277;
var statearr_76323_76382 = state_76277__$1;
(statearr_76323_76382[(2)] = null);

(statearr_76323_76382[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (2))){
var state_76277__$1 = state_76277;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76277__$1,(4),req_chan);
} else {
if((state_val_76278 === (23))){
var inst_76192 = (state_76277[(13)]);
var inst_76193 = (state_76277[(14)]);
var inst_76199 = (state_76277[(16)]);
var inst_76237 = (state_76277[(2)]);
var inst_76238 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76239 = [inst_76192,inst_76199,inst_76193];
var inst_76240 = (new cljs.core.PersistentVector(null,3,(5),inst_76238,inst_76239,null));
var inst_76241 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_76240) : publish_fn.call(null,conn,inst_76240));
var state_76277__$1 = (function (){var statearr_76324 = state_76277;
(statearr_76324[(24)] = inst_76237);

return statearr_76324;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76277__$1,(24),inst_76241);
} else {
if((state_val_76278 === (35))){
var state_76277__$1 = state_76277;
var statearr_76325_76383 = state_76277__$1;
(statearr_76325_76383[(2)] = null);

(statearr_76325_76383[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (19))){
var inst_76181 = (state_76277[(2)]);
var state_76277__$1 = state_76277;
var statearr_76326_76384 = state_76277__$1;
(statearr_76326_76384[(2)] = inst_76181);

(statearr_76326_76384[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (11))){
var inst_76155 = (state_76277[(9)]);
var state_76277__$1 = state_76277;
var statearr_76327_76385 = state_76277__$1;
(statearr_76327_76385[(2)] = inst_76155);

(statearr_76327_76385[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (9))){
var inst_76152 = (state_76277[(7)]);
var inst_76268 = (state_76277[(2)]);
var inst_76269 = (inst_76152 + (1));
var inst_76152__$1 = inst_76269;
var state_76277__$1 = (function (){var statearr_76328 = state_76277;
(statearr_76328[(7)] = inst_76152__$1);

(statearr_76328[(25)] = inst_76268);

return statearr_76328;
})();
var statearr_76329_76386 = state_76277__$1;
(statearr_76329_76386[(2)] = null);

(statearr_76329_76386[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (5))){
var state_76277__$1 = state_76277;
var statearr_76330_76387 = state_76277__$1;
(statearr_76330_76387[(2)] = null);

(statearr_76330_76387[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (14))){
var inst_76168 = (state_76277[(10)]);
var inst_76170 = fluree.db.util.async.channel_QMARK_(inst_76168);
var state_76277__$1 = state_76277;
var statearr_76331_76388 = state_76277__$1;
(statearr_76331_76388[(2)] = inst_76170);

(statearr_76331_76388[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (26))){
var inst_76243 = (state_76277[(8)]);
var inst_76247 = fluree.db.util.core.exception_QMARK_(inst_76243);
var state_76277__$1 = state_76277;
if(inst_76247){
var statearr_76332_76389 = state_76277__$1;
(statearr_76332_76389[(1)] = (28));

} else {
var statearr_76333_76390 = state_76277__$1;
(statearr_76333_76390[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (16))){
var inst_76173 = (state_76277[(2)]);
var state_76277__$1 = state_76277;
if(cljs.core.truth_(inst_76173)){
var statearr_76334_76391 = state_76277__$1;
(statearr_76334_76391[(1)] = (17));

} else {
var statearr_76335_76392 = state_76277__$1;
(statearr_76335_76392[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (30))){
var inst_76263 = (state_76277[(2)]);
var state_76277__$1 = state_76277;
var statearr_76336_76393 = state_76277__$1;
(statearr_76336_76393[(2)] = inst_76263);

(statearr_76336_76393[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (10))){
var inst_76155 = (state_76277[(9)]);
var inst_76157 = (state_76277[(2)]);
var inst_76161 = cljs.core.sequential_QMARK_(inst_76155);
var state_76277__$1 = (function (){var statearr_76337 = state_76277;
(statearr_76337[(23)] = inst_76157);

return statearr_76337;
})();
if(inst_76161){
var statearr_76338_76394 = state_76277__$1;
(statearr_76338_76394[(1)] = (11));

} else {
var statearr_76339_76395 = state_76277__$1;
(statearr_76339_76395[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (18))){
var inst_76157 = (state_76277[(23)]);
var inst_76155 = (state_76277[(9)]);
var inst_76177 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76155], 0));
var inst_76178 = ["Error processing ledger request, no valid return channel: ",inst_76177].join('');
var inst_76179 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76157,inst_76178], 0));
var state_76277__$1 = state_76277;
var statearr_76340_76396 = state_76277__$1;
(statearr_76340_76396[(2)] = inst_76179);

(statearr_76340_76396[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76278 === (8))){
var inst_76196 = (state_76277[(11)]);
var inst_76194 = (state_76277[(12)]);
var inst_76195 = (state_76277[(15)]);
var inst_76155 = (state_76277[(9)]);
var _ = (function (){var statearr_76341 = state_76277;
(statearr_76341[(4)] = cljs.core.cons((20),(state_76277[(4)])));

return statearr_76341;
})();
var inst_76191 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_76155], 0));
var inst_76192 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76155,(0),null);
var inst_76193 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76155,(1),null);
var inst_76194__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76155,(2),null);
var inst_76195__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76155,(3),null);
var inst_76196__$1 = cljs.core.__destructure_map(inst_76195__$1);
var inst_76197 = fluree.db.util.core.random_uuid();
var inst_76198 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76197);
var inst_76199 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_76196__$1,cljs.core.cst$kw$req_DASH_id,inst_76198);
var inst_76200 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_76196__$1,cljs.core.cst$kw$timeout,(60000));
var state_76277__$1 = (function (){var statearr_76342 = state_76277;
(statearr_76342[(11)] = inst_76196__$1);

(statearr_76342[(12)] = inst_76194__$1);

(statearr_76342[(13)] = inst_76192);

(statearr_76342[(14)] = inst_76193);

(statearr_76342[(15)] = inst_76195__$1);

(statearr_76342[(16)] = inst_76199);

(statearr_76342[(17)] = inst_76200);

(statearr_76342[(18)] = inst_76191);

return statearr_76342;
})();
if(cljs.core.truth_(inst_76194__$1)){
var statearr_76343_76397 = state_76277__$1;
(statearr_76343_76397[(1)] = (21));

} else {
var statearr_76344_76398 = state_76277__$1;
(statearr_76344_76398[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__15091__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__15091__auto____0 = (function (){
var statearr_76345 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76345[(0)] = fluree$db$connection$msg_producer_$_state_machine__15091__auto__);

(statearr_76345[(1)] = (1));

return statearr_76345;
});
var fluree$db$connection$msg_producer_$_state_machine__15091__auto____1 = (function (state_76277){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_76277);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e76346){var ex__15094__auto__ = e76346;
var statearr_76347_76399 = state_76277;
(statearr_76347_76399[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_76277[(4)]))){
var statearr_76348_76400 = state_76277;
(statearr_76348_76400[(1)] = cljs.core.first((state_76277[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__76401 = state_76277;
state_76277 = G__76401;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__15091__auto__ = function(state_76277){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__15091__auto____1.call(this,state_76277);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__15091__auto____0;
fluree$db$connection$msg_producer_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__15091__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_76349 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_76349[(6)] = c__15165__auto__);

return statearr_76349;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ping,true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__76402 = conn;
var map__76402__$1 = cljs.core.__destructure_map(map__76402);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76402__$1,cljs.core.cst$kw$sub_DASH_chan);
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_76487){
var state_val_76488 = (state_76487[(1)]);
if((state_val_76488 === (7))){
var inst_76483 = (state_76487[(2)]);
var state_76487__$1 = state_76487;
var statearr_76489_76540 = state_76487__$1;
(statearr_76489_76540[(2)] = inst_76483);

(statearr_76489_76540[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (20))){
var inst_76421 = (state_76487[(7)]);
var inst_76435 = [cljs.core.cst$kw$keep_DASH_alive_DASH_fn];
var inst_76436 = [inst_76421];
var inst_76437 = cljs.core.PersistentHashMap.fromArrays(inst_76435,inst_76436);
var inst_76438 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_76437], 0));
var state_76487__$1 = state_76487;
var statearr_76490_76541 = state_76487__$1;
(statearr_76490_76541[(2)] = inst_76438);

(statearr_76490_76541[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (27))){
var state_76487__$1 = state_76487;
var statearr_76491_76542 = state_76487__$1;
(statearr_76491_76542[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (1))){
var inst_76403 = (0);
var state_76487__$1 = (function (){var statearr_76493 = state_76487;
(statearr_76493[(8)] = inst_76403);

return statearr_76493;
})();
var statearr_76494_76543 = state_76487__$1;
(statearr_76494_76543[(2)] = null);

(statearr_76494_76543[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (24))){
var inst_76414 = (state_76487[(9)]);
var inst_76463 = fluree.db.util.core.exception_QMARK_(inst_76414);
var state_76487__$1 = state_76487;
if(inst_76463){
var statearr_76495_76544 = state_76487__$1;
(statearr_76495_76544[(1)] = (26));

} else {
var statearr_76496_76545 = state_76487__$1;
(statearr_76496_76545[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (4))){
var inst_76408 = (state_76487[(10)]);
var inst_76413 = (state_76487[(2)]);
var inst_76414 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76413,(0),null);
var inst_76415 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76413,(1),null);
var inst_76416 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_76415,inst_76408);
var state_76487__$1 = (function (){var statearr_76497 = state_76487;
(statearr_76497[(9)] = inst_76414);

return statearr_76497;
})();
if(inst_76416){
var statearr_76498_76546 = state_76487__$1;
(statearr_76498_76546[(1)] = (5));

} else {
var statearr_76499_76547 = state_76487__$1;
(statearr_76499_76547[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (15))){
var inst_76421 = (state_76487[(7)]);
var inst_76430 = typeof inst_76421 === 'string';
var state_76487__$1 = state_76487;
if(cljs.core.truth_(inst_76430)){
var statearr_76500_76548 = state_76487__$1;
(statearr_76500_76548[(1)] = (17));

} else {
var statearr_76501_76549 = state_76487__$1;
(statearr_76501_76549[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (21))){
var state_76487__$1 = state_76487;
var statearr_76502_76550 = state_76487__$1;
(statearr_76502_76550[(2)] = null);

(statearr_76502_76550[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (31))){
var inst_76477 = (state_76487[(2)]);
var state_76487__$1 = state_76487;
var statearr_76503_76551 = state_76487__$1;
(statearr_76503_76551[(2)] = inst_76477);

(statearr_76503_76551[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (13))){
var inst_76447 = (state_76487[(2)]);
var inst_76448 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_76449 = fluree.db.connection.close_websocket(inst_76448);
var inst_76450 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_76451 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_76450);
var state_76487__$1 = (function (){var statearr_76504 = state_76487;
(statearr_76504[(11)] = inst_76449);

(statearr_76504[(12)] = inst_76447);

return statearr_76504;
})();
var statearr_76505_76552 = state_76487__$1;
(statearr_76505_76552[(2)] = inst_76451);

(statearr_76505_76552[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (22))){
var inst_76441 = (state_76487[(2)]);
var state_76487__$1 = state_76487;
var statearr_76506_76553 = state_76487__$1;
(statearr_76506_76553[(2)] = inst_76441);

(statearr_76506_76553[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (29))){
var inst_76414 = (state_76487[(9)]);
var inst_76469 = fluree.db.util.json.parse(inst_76414);
var inst_76470 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76469], 0));
var inst_76471 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Received message:",inst_76470], 0));
var inst_76472 = fluree.db.util.json.parse(inst_76414);
var inst_76473 = fluree.db.conn_events.process_events(conn,inst_76472);
var inst_76403 = (0);
var state_76487__$1 = (function (){var statearr_76507 = state_76487;
(statearr_76507[(8)] = inst_76403);

(statearr_76507[(13)] = inst_76473);

(statearr_76507[(14)] = inst_76471);

return statearr_76507;
})();
var statearr_76508_76554 = state_76487__$1;
(statearr_76508_76554[(2)] = null);

(statearr_76508_76554[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (6))){
var inst_76414 = (state_76487[(9)]);
var inst_76459 = (inst_76414 == null);
var state_76487__$1 = state_76487;
if(cljs.core.truth_(inst_76459)){
var statearr_76509_76555 = state_76487__$1;
(statearr_76509_76555[(1)] = (23));

} else {
var statearr_76510_76556 = state_76487__$1;
(statearr_76510_76556[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (28))){
var inst_76479 = (state_76487[(2)]);
var state_76487__$1 = state_76487;
var statearr_76511_76557 = state_76487__$1;
(statearr_76511_76557[(2)] = inst_76479);

(statearr_76511_76557[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (25))){
var inst_76481 = (state_76487[(2)]);
var state_76487__$1 = state_76487;
var statearr_76512_76558 = state_76487__$1;
(statearr_76512_76558[(2)] = inst_76481);

(statearr_76512_76558[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (17))){
var inst_76421 = (state_76487[(7)]);
var inst_76432 = cljs.core.eval(inst_76421);
var state_76487__$1 = state_76487;
var statearr_76513_76559 = state_76487__$1;
(statearr_76513_76559[(2)] = inst_76432);

(statearr_76513_76559[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (3))){
var inst_76485 = (state_76487[(2)]);
var state_76487__$1 = state_76487;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76487__$1,inst_76485);
} else {
if((state_val_76488 === (12))){
var inst_76421 = (state_76487[(7)]);
var inst_76426 = cljs.core.fn_QMARK_(inst_76421);
var state_76487__$1 = state_76487;
if(inst_76426){
var statearr_76514_76560 = state_76487__$1;
(statearr_76514_76560[(1)] = (14));

} else {
var statearr_76515_76561 = state_76487__$1;
(statearr_76515_76561[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (2))){
var inst_76408 = (state_76487[(10)]);
var inst_76408__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_76409 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76410 = [sub_chan,inst_76408__$1];
var inst_76411 = (new cljs.core.PersistentVector(null,2,(5),inst_76409,inst_76410,null));
var state_76487__$1 = (function (){var statearr_76516 = state_76487;
(statearr_76516[(10)] = inst_76408__$1);

return statearr_76516;
})();
return cljs.core.async.ioc_alts_BANG_(state_76487__$1,(4),inst_76411);
} else {
if((state_val_76488 === (23))){
var inst_76461 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_76487__$1 = state_76487;
var statearr_76517_76562 = state_76487__$1;
(statearr_76517_76562[(2)] = inst_76461);

(statearr_76517_76562[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (19))){
var inst_76443 = (state_76487[(2)]);
var state_76487__$1 = state_76487;
var statearr_76518_76563 = state_76487__$1;
(statearr_76518_76563[(2)] = inst_76443);

(statearr_76518_76563[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (11))){
var inst_76424 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_76487__$1 = state_76487;
var statearr_76519_76564 = state_76487__$1;
(statearr_76519_76564[(2)] = inst_76424);

(statearr_76519_76564[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (9))){
var inst_76403 = (state_76487[(8)]);
var inst_76453 = fluree.db.connection.ping_transactor(conn);
var inst_76454 = (inst_76403 + (1));
var inst_76403__$1 = inst_76454;
var state_76487__$1 = (function (){var statearr_76520 = state_76487;
(statearr_76520[(8)] = inst_76403__$1);

(statearr_76520[(15)] = inst_76453);

return statearr_76520;
})();
var statearr_76521_76565 = state_76487__$1;
(statearr_76521_76565[(2)] = null);

(statearr_76521_76565[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (5))){
var inst_76403 = (state_76487[(8)]);
var inst_76418 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_76403);
var state_76487__$1 = state_76487;
if(inst_76418){
var statearr_76522_76566 = state_76487__$1;
(statearr_76522_76566[(1)] = (8));

} else {
var statearr_76523_76567 = state_76487__$1;
(statearr_76523_76567[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (14))){
var inst_76421 = (state_76487[(7)]);
var inst_76428 = (inst_76421.cljs$core$IFn$_invoke$arity$0 ? inst_76421.cljs$core$IFn$_invoke$arity$0() : inst_76421.call(null));
var state_76487__$1 = state_76487;
var statearr_76524_76568 = state_76487__$1;
(statearr_76524_76568[(2)] = inst_76428);

(statearr_76524_76568[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (26))){
var inst_76414 = (state_76487[(9)]);
var inst_76465 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76414], 0));
var inst_76403 = (0);
var state_76487__$1 = (function (){var statearr_76525 = state_76487;
(statearr_76525[(8)] = inst_76403);

(statearr_76525[(16)] = inst_76465);

return statearr_76525;
})();
var statearr_76526_76569 = state_76487__$1;
(statearr_76526_76569[(2)] = null);

(statearr_76526_76569[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (16))){
var inst_76445 = (state_76487[(2)]);
var state_76487__$1 = state_76487;
var statearr_76527_76570 = state_76487__$1;
(statearr_76527_76570[(2)] = inst_76445);

(statearr_76527_76570[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (30))){
var state_76487__$1 = state_76487;
var statearr_76528_76571 = state_76487__$1;
(statearr_76528_76571[(2)] = null);

(statearr_76528_76571[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (10))){
var inst_76457 = (state_76487[(2)]);
var state_76487__$1 = state_76487;
var statearr_76529_76572 = state_76487__$1;
(statearr_76529_76572[(2)] = inst_76457);

(statearr_76529_76572[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (18))){
var state_76487__$1 = state_76487;
var statearr_76530_76573 = state_76487__$1;
(statearr_76530_76573[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_76488 === (8))){
var inst_76421 = (state_76487[(7)]);
var inst_76420 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_76421__$1 = cljs.core.cst$kw$keep_DASH_alive_DASH_fn.cljs$core$IFn$_invoke$arity$1(conn);
var inst_76422 = (inst_76421__$1 == null);
var state_76487__$1 = (function (){var statearr_76532 = state_76487;
(statearr_76532[(17)] = inst_76420);

(statearr_76532[(7)] = inst_76421__$1);

return statearr_76532;
})();
if(cljs.core.truth_(inst_76422)){
var statearr_76533_76574 = state_76487__$1;
(statearr_76533_76574[(1)] = (11));

} else {
var statearr_76534_76575 = state_76487__$1;
(statearr_76534_76575[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__15091__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__15091__auto____0 = (function (){
var statearr_76535 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76535[(0)] = fluree$db$connection$msg_consumer_$_state_machine__15091__auto__);

(statearr_76535[(1)] = (1));

return statearr_76535;
});
var fluree$db$connection$msg_consumer_$_state_machine__15091__auto____1 = (function (state_76487){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_76487);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e76536){var ex__15094__auto__ = e76536;
var statearr_76537_76576 = state_76487;
(statearr_76537_76576[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_76487[(4)]))){
var statearr_76538_76577 = state_76487;
(statearr_76538_76577[(1)] = cljs.core.first((state_76487[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__76578 = state_76487;
state_76487 = G__76578;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__15091__auto__ = function(state_76487){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__15091__auto____1.call(this,state_76487);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__15091__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__15091__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_76539 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_76539[(6)] = c__15165__auto__);

return statearr_76539;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__76580 = arguments.length;
switch (G__76580) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__76581 = opts;
var map__76581__$1 = cljs.core.__destructure_map(map__76581);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76581__$1,cljs.core.cst$kw$private);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76581__$1,cljs.core.cst$kw$jwt);
return (function (k){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_76633){
var state_val_76634 = (state_76633[(1)]);
if((state_val_76634 === (7))){
var inst_76591 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_76592 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76593 = [conn_id,cljs.core.cst$kw$token];
var inst_76594 = (new cljs.core.PersistentVector(null,2,(5),inst_76592,inst_76593,null));
var inst_76595 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_76591,inst_76594);
var state_76633__$1 = state_76633;
var statearr_76635_76666 = state_76633__$1;
(statearr_76635_76666[(2)] = inst_76595);

(statearr_76635_76666[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76634 === (1))){
var state_76633__$1 = state_76633;
var statearr_76636_76667 = state_76633__$1;
(statearr_76636_76667[(2)] = null);

(statearr_76636_76667[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76634 === (4))){
var inst_76582 = (state_76633[(2)]);
var state_76633__$1 = state_76633;
var statearr_76637_76668 = state_76633__$1;
(statearr_76637_76668[(2)] = inst_76582);

(statearr_76637_76668[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76634 === (15))){
var inst_76602 = (state_76633[(7)]);
var inst_76621 = (state_76633[(2)]);
var inst_76622 = [cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$headers,cljs.core.cst$kw$output_DASH_format];
var inst_76623 = [(5000),inst_76621,cljs.core.cst$kw$json];
var inst_76624 = cljs.core.PersistentHashMap.fromArrays(inst_76622,inst_76623);
var inst_76625 = fluree.db.util.xhttp.get(inst_76602,inst_76624);
var state_76633__$1 = state_76633;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76633__$1,(16),inst_76625);
} else {
if((state_val_76634 === (13))){
var inst_76602 = (state_76633[(7)]);
var inst_76612 = (state_76633[(8)]);
var inst_76614 = [cljs.core.cst$kw$headers];
var inst_76615 = [inst_76612];
var inst_76616 = cljs.core.PersistentHashMap.fromArrays(inst_76614,inst_76615);
var inst_76617 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_76602,inst_76616,private$);
var inst_76618 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_76617);
var state_76633__$1 = state_76633;
var statearr_76638_76669 = state_76633__$1;
(statearr_76638_76669[(2)] = inst_76618);

(statearr_76638_76669[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76634 === (6))){
var inst_76588 = (state_76633[(9)]);
var state_76633__$1 = state_76633;
var statearr_76639_76670 = state_76633__$1;
(statearr_76639_76670[(2)] = inst_76588);

(statearr_76639_76670[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76634 === (3))){
var inst_76631 = (state_76633[(2)]);
var state_76633__$1 = state_76633;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76633__$1,inst_76631);
} else {
if((state_val_76634 === (12))){
var inst_76612 = (state_76633[(2)]);
var state_76633__$1 = (function (){var statearr_76640 = state_76633;
(statearr_76640[(8)] = inst_76612);

return statearr_76640;
})();
if(cljs.core.truth_(private$)){
var statearr_76641_76671 = state_76633__$1;
(statearr_76641_76671[(1)] = (13));

} else {
var statearr_76642_76672 = state_76633__$1;
(statearr_76642_76672[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76634 === (2))){
var inst_76588 = (state_76633[(9)]);
var _ = (function (){var statearr_76643 = state_76633;
(statearr_76643[(4)] = cljs.core.cons((5),(state_76633[(4)])));

return statearr_76643;
})();
var inst_76588__$1 = jwt;
var state_76633__$1 = (function (){var statearr_76644 = state_76633;
(statearr_76644[(9)] = inst_76588__$1);

return statearr_76644;
})();
if(cljs.core.truth_(inst_76588__$1)){
var statearr_76645_76673 = state_76633__$1;
(statearr_76645_76673[(1)] = (6));

} else {
var statearr_76646_76674 = state_76633__$1;
(statearr_76646_76674[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76634 === (11))){
var inst_76606 = (state_76633[(10)]);
var state_76633__$1 = state_76633;
var statearr_76648_76675 = state_76633__$1;
(statearr_76648_76675[(2)] = inst_76606);

(statearr_76648_76675[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76634 === (9))){
var inst_76598 = (state_76633[(11)]);
var inst_76597 = (state_76633[(12)]);
var inst_76601 = (state_76633[(2)]);
var inst_76602 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76601),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76598)].join('');
var inst_76604 = ["Accept"];
var inst_76605 = ["application/json"];
var inst_76606 = cljs.core.PersistentHashMap.fromArrays(inst_76604,inst_76605);
var state_76633__$1 = (function (){var statearr_76649 = state_76633;
(statearr_76649[(7)] = inst_76602);

(statearr_76649[(10)] = inst_76606);

return statearr_76649;
})();
if(cljs.core.truth_(inst_76597)){
var statearr_76650_76676 = state_76633__$1;
(statearr_76650_76676[(1)] = (10));

} else {
var statearr_76651_76677 = state_76633__$1;
(statearr_76651_76677[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76634 === (5))){
var _ = (function (){var statearr_76652 = state_76633;
(statearr_76652[(4)] = cljs.core.rest((state_76633[(4)])));

return statearr_76652;
})();
var state_76633__$1 = state_76633;
var ex76647 = (state_76633__$1[(2)]);
var statearr_76653_76678 = state_76633__$1;
(statearr_76653_76678[(5)] = ex76647);


if((ex76647 instanceof Error)){
var statearr_76654_76679 = state_76633__$1;
(statearr_76654_76679[(1)] = (4));

(statearr_76654_76679[(5)] = null);

} else {
throw ex76647;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76634 === (14))){
var inst_76612 = (state_76633[(8)]);
var state_76633__$1 = state_76633;
var statearr_76655_76680 = state_76633__$1;
(statearr_76655_76680[(2)] = inst_76612);

(statearr_76655_76680[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76634 === (16))){
var inst_76627 = (state_76633[(2)]);
var inst_76628 = fluree.db.util.async.throw_err(inst_76627);
var _ = (function (){var statearr_76656 = state_76633;
(statearr_76656[(4)] = cljs.core.rest((state_76633[(4)])));

return statearr_76656;
})();
var state_76633__$1 = state_76633;
var statearr_76657_76681 = state_76633__$1;
(statearr_76657_76681[(2)] = inst_76628);

(statearr_76657_76681[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76634 === (10))){
var inst_76597 = (state_76633[(12)]);
var inst_76606 = (state_76633[(10)]);
var inst_76608 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76597)].join('');
var inst_76609 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_76606,"Authorization",inst_76608);
var state_76633__$1 = state_76633;
var statearr_76658_76682 = state_76633__$1;
(statearr_76658_76682[(2)] = inst_76609);

(statearr_76658_76682[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76634 === (8))){
var inst_76597 = (state_76633[(2)]);
var inst_76598 = clojure.string.replace(k,"_","/");
var inst_76599 = fluree.db.connection.get_server(conn_id,servers);
var state_76633__$1 = (function (){var statearr_76659 = state_76633;
(statearr_76659[(11)] = inst_76598);

(statearr_76659[(12)] = inst_76597);

return statearr_76659;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76633__$1,(9),inst_76599);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__15091__auto__ = null;
var fluree$db$connection$state_machine__15091__auto____0 = (function (){
var statearr_76660 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76660[(0)] = fluree$db$connection$state_machine__15091__auto__);

(statearr_76660[(1)] = (1));

return statearr_76660;
});
var fluree$db$connection$state_machine__15091__auto____1 = (function (state_76633){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_76633);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e76661){var ex__15094__auto__ = e76661;
var statearr_76662_76683 = state_76633;
(statearr_76662_76683[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_76633[(4)]))){
var statearr_76663_76684 = state_76633;
(statearr_76663_76684[(1)] = cljs.core.first((state_76633[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__76685 = state_76633;
state_76633 = G__76685;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$connection$state_machine__15091__auto__ = function(state_76633){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__15091__auto____1.call(this,state_76633);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__15091__auto____0;
fluree$db$connection$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__15091__auto____1;
return fluree$db$connection$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_76664 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_76664[(6)] = c__15165__auto__);

return statearr_76664;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5802__auto__)){
var v = temp__5802__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return cljs.core.cst$kw$listeners.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__76686_SHARP_){
if(cljs.core.truth_(p1__76686_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$token], null),(function (p1__76687_SHARP_){
var or__5045__auto__ = p1__76687_SHARP_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return token;
}
}));

return true;
}catch (e76688){var e = e76688;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$close_QMARK_,false,cljs.core.cst$kw$health,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$connected_DASH_to,null,cljs.core.cst$kw$socket,null,cljs.core.cst$kw$socket_DASH_id,null,cljs.core.cst$kw$pending_DASH_req,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$listeners,cljs.core.PersistentArrayMap.EMPTY], null));
var map__76689 = opts;
var map__76689__$1 = cljs.core.__destructure_map(map__76689);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__76689__$1,cljs.core.cst$kw$sub_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76689__$1,cljs.core.cst$kw$storage_DASH_rename);
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76689__$1,cljs.core.cst$kw$keep_DASH_alive_DASH_fn);
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76689__$1,cljs.core.cst$kw$publish);
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76689__$1,cljs.core.cst$kw$close_DASH_fn);
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76689__$1,cljs.core.cst$kw$default_DASH_network);
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76689__$1,cljs.core.cst$kw$object_DASH_cache);
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76689__$1,cljs.core.cst$kw$transact_DASH_handler);
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__76689__$1,cljs.core.cst$kw$parallelism,(4));
var group = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76689__$1,cljs.core.cst$kw$group);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76689__$1,cljs.core.cst$kw$meta);
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76689__$1,cljs.core.cst$kw$tx_DASH_private_DASH_key);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76689__$1,cljs.core.cst$kw$private);
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76689__$1,cljs.core.cst$kw$storage_DASH_read);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__76689__$1,cljs.core.cst$kw$transactor_QMARK_,false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__76689__$1,cljs.core.cst$kw$serializer,fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__76689__$1,cljs.core.cst$kw$memory,(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76689__$1,cljs.core.cst$kw$storage_DASH_exists);
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__76689__$1,cljs.core.cst$kw$storage_DASH_write,(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__76689__$1,cljs.core.cst$kw$memory_QMARK_,false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__76689__$1,cljs.core.cst$kw$req_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__76689__$1,cljs.core.cst$kw$pub_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__76689__$1,cljs.core.cst$kw$private_DASH_key_DASH_file,"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76689__$1,cljs.core.cst$kw$storage_DASH_list);
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_configuration], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__5045__auto__ = object_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,cljs.core.cst$kw$close_QMARK_,true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache();
} else {
}

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$conn_DASH_closed], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__5045__auto__ = storage_read;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__5045__auto__ = storage_exists;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = storage_read;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__5043__auto__ = storage_write;
if(cljs.core.truth_(and__5043__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$group,cljs.core.cst$kw$meta,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$serializer,cljs.core.cst$kw$memory,cljs.core.cst$kw$storage_DASH_exists,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$id,cljs.core.cst$kw$servers,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_list,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$storage_DASH_rename,cljs.core.cst$kw$keep_DASH_alive_DASH_fn,cljs.core.cst$kw$publish],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__76690_76691 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__76690_76691.cljs$core$IFn$_invoke$arity$0 ? fexpr__76690_76691.cljs$core$IFn$_invoke$arity$0() : fexpr__76690_76691.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__5774__auto__ = [];
var len__5768__auto___76732 = arguments.length;
var i__5769__auto___76733 = (0);
while(true){
if((i__5769__auto___76733 < len__5768__auto___76732)){
args__5774__auto__.push((arguments[i__5769__auto___76733]));

var G__76734 = (i__5769__auto___76733 + (1));
i__5769__auto___76733 = G__76734;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__76694){
var vec__76695 = p__76694;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__76695,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__15165__auto___76735 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_76715){
var state_val_76716 = (state_76715[(1)]);
if((state_val_76716 === (1))){
var inst_76698 = fluree.db.connection.get_socket(conn);
var state_76715__$1 = state_76715;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76715__$1,(2),inst_76698);
} else {
if((state_val_76716 === (2))){
var inst_76700 = (state_76715[(7)]);
var inst_76701 = (state_76715[(8)]);
var inst_76700__$1 = (state_76715[(2)]);
var inst_76701__$1 = (inst_76700__$1 == null);
var state_76715__$1 = (function (){var statearr_76717 = state_76715;
(statearr_76717[(7)] = inst_76700__$1);

(statearr_76717[(8)] = inst_76701__$1);

return statearr_76717;
})();
if(cljs.core.truth_(inst_76701__$1)){
var statearr_76718_76736 = state_76715__$1;
(statearr_76718_76736[(1)] = (3));

} else {
var statearr_76719_76737 = state_76715__$1;
(statearr_76719_76737[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76716 === (3))){
var inst_76701 = (state_76715[(8)]);
var state_76715__$1 = state_76715;
var statearr_76720_76738 = state_76715__$1;
(statearr_76720_76738[(2)] = inst_76701);

(statearr_76720_76738[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76716 === (4))){
var inst_76700 = (state_76715[(7)]);
var inst_76704 = fluree.db.util.core.exception_QMARK_(inst_76700);
var state_76715__$1 = state_76715;
var statearr_76721_76739 = state_76715__$1;
(statearr_76721_76739[(2)] = inst_76704);

(statearr_76721_76739[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76716 === (5))){
var inst_76706 = (state_76715[(2)]);
var state_76715__$1 = state_76715;
if(cljs.core.truth_(inst_76706)){
var statearr_76722_76740 = state_76715__$1;
(statearr_76722_76740[(1)] = (6));

} else {
var statearr_76723_76741 = state_76715__$1;
(statearr_76723_76741[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76716 === (6))){
var inst_76700 = (state_76715[(7)]);
var inst_76708 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76700,"Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_76709 = cljs.core.async.close_BANG_(conn);
var state_76715__$1 = (function (){var statearr_76724 = state_76715;
(statearr_76724[(9)] = inst_76708);

return statearr_76724;
})();
var statearr_76725_76742 = state_76715__$1;
(statearr_76725_76742[(2)] = inst_76709);

(statearr_76725_76742[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76716 === (7))){
var inst_76711 = fluree.db.connection.msg_consumer(conn);
var state_76715__$1 = state_76715;
var statearr_76726_76743 = state_76715__$1;
(statearr_76726_76743[(2)] = inst_76711);

(statearr_76726_76743[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76716 === (8))){
var inst_76713 = (state_76715[(2)]);
var state_76715__$1 = state_76715;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76715__$1,inst_76713);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__15091__auto__ = null;
var fluree$db$connection$state_machine__15091__auto____0 = (function (){
var statearr_76727 = [null,null,null,null,null,null,null,null,null,null];
(statearr_76727[(0)] = fluree$db$connection$state_machine__15091__auto__);

(statearr_76727[(1)] = (1));

return statearr_76727;
});
var fluree$db$connection$state_machine__15091__auto____1 = (function (state_76715){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_76715);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e76728){var ex__15094__auto__ = e76728;
var statearr_76729_76744 = state_76715;
(statearr_76729_76744[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_76715[(4)]))){
var statearr_76730_76745 = state_76715;
(statearr_76730_76745[(1)] = cljs.core.first((state_76715[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__76746 = state_76715;
state_76715 = G__76746;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$connection$state_machine__15091__auto__ = function(state_76715){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__15091__auto____1.call(this,state_76715);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__15091__auto____0;
fluree$db$connection$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__15091__auto____1;
return fluree$db$connection$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_76731 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_76731[(6)] = c__15165__auto___76735);

return statearr_76731;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq76692){
var G__76693 = cljs.core.first(seq76692);
var seq76692__$1 = cljs.core.next(seq76692);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__76693,seq76692__$1);
}));

