// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.reader');
goog.require('cljs.cache');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbfunctions.fns');
goog.require('clojure.string');
/**
 * Returns an empty TTL cache for db-function caching.
 *   Implication of this caching strategy is changes to db functions that get
 *   update will take 5 seconds to recompile, benefit is that the same function
 *   call for a ledger will not have to recompile every time.
 */
fluree.db.dbfunctions.core.db_fn_cache_factory = (function fluree$db$dbfunctions$core$db_fn_cache_factory(){
return cljs.cache.ttl_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$ttl,(5000)], 0));
});
fluree.db.dbfunctions.core.db_fn_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.dbfunctions.core.db_fn_cache_factory());
fluree.db.dbfunctions.core.clear_db_fn_cache = (function fluree$db$dbfunctions$core$clear_db_fn_cache(){
return cljs.core.reset_BANG_(fluree.db.dbfunctions.core.db_fn_cache,fluree.db.dbfunctions.core.db_fn_cache_factory());
});
/**
 * Returns true if this value is a transaction function.
 */
fluree.db.dbfunctions.core.tx_fn_QMARK_ = (function fluree$db$dbfunctions$core$tx_fn_QMARK_(value){
var and__5043__auto__ = typeof value === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,value);
} else {
return and__5043__auto__;
}
});
fluree.db.dbfunctions.core.default_fn_map = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$_QMARK_pO,cljs.core.cst$sym$_QMARK_auth_id,cljs.core.cst$sym$and,cljs.core.cst$sym$upper_DASH_case,cljs.core.cst$sym$cas,cljs.core.cst$sym$max_DASH_pred_DASH_val,cljs.core.cst$sym$_GT__EQ_,cljs.core.cst$sym$lower_DASH_case,cljs.core.cst$sym$_GT_,cljs.core.cst$sym$count,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$objT,cljs.core.cst$sym$inc,cljs.core.cst$sym$_SLASH_,cljs.core.cst$sym$quot,cljs.core.cst$sym$flakes,cljs.core.cst$sym$not,cljs.core.cst$sym$_QMARK_sid,cljs.core.cst$sym$uuid,cljs.core.cst$sym$_QMARK_user_id,cljs.core.cst$sym$_LT__EQ_,cljs.core.cst$sym$_EQ_,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$if_DASH_else,cljs.core.cst$sym$_QMARK_pid,cljs.core.cst$sym$_PLUS_,cljs.core.cst$sym$_EQ__EQ_,cljs.core.cst$sym$boolean,cljs.core.cst$sym$max,cljs.core.cst$sym$empty_QMARK_,cljs.core.cst$sym$_STAR_,cljs.core.cst$sym$relationship_QMARK_,cljs.core.cst$sym$get_DASH_in,cljs.core.cst$sym$now,cljs.core.cst$sym$dec,cljs.core.cst$sym$get_DASH_all,cljs.core.cst$sym$floor,cljs.core.cst$sym$not_EQ_,cljs.core.cst$sym$get,cljs.core.cst$sym$str,cljs.core.cst$sym$_LT_,cljs.core.cst$sym$_DASH_,cljs.core.cst$sym$rand,cljs.core.cst$sym$contains_QMARK_,cljs.core.cst$sym$hash_DASH_set,cljs.core.cst$sym$valid_DASH_email_QMARK_,cljs.core.cst$sym$_QMARK_p,cljs.core.cst$sym$nth,cljs.core.cst$sym$subs,cljs.core.cst$sym$mod,cljs.core.cst$sym$_QMARK_s,cljs.core.cst$sym$rem,cljs.core.cst$sym$query,cljs.core.cst$sym$_QMARK_o,cljs.core.cst$sym$objF,cljs.core.cst$sym$follow,cljs.core.cst$sym$or,cljs.core.cst$sym$re_DASH_find],[(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pO !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pO;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pO,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pO,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",10,1,302,null,302,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the most recent object of an predicate, as of the previous block",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pO)?fluree.db.dbfunctions.fns._QMARK_pO.cljs$lang$test:null),"10 plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_auth_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_auth_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_auth_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_auth_id,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",15,1,715,null,715,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current auth _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_auth_id)?fluree.db.dbfunctions.fns._QMARK_auth_id.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.and !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.and;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_and,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$and,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,232,null,232,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if all in a sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.and)?fluree.db.dbfunctions.fns.and.cljs$lang$test:null),"Count of objects in and"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.upper_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.upper_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_upper_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$upper_DASH_case,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",17,1,159,null,159,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string upper-case",(cljs.core.truth_(fluree.db.dbfunctions.fns.upper_case)?fluree.db.dbfunctions.fns.upper_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.cas !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.cas;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_cas,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$cas,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",10,1,813,null,813,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$compare_DASH_val,cljs.core.cst$sym$new_DASH_val], null)),"Does a compare and set/swap operation as a transaction function.",(cljs.core.truth_(fluree.db.dbfunctions.fns.cas)?fluree.db.dbfunctions.fns.cas.cljs$lang$test:null),(20)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max_pred_val !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max_pred_val;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max_DASH_pred_DASH_val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max_DASH_pred_DASH_val,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",19,1,522,null,522,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pred_DASH_name], null)),"Finds the maximum predicate value.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max_pred_val)?fluree.db.dbfunctions.fns.max_pred_val.cljs$lang$test:null),"10, plus fuel cost."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT__EQ_,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,428,null,428,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT__EQ_)?fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.lower_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.lower_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_lower_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$lower_DASH_case,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",17,1,147,null,147,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string lower case",(cljs.core.truth_(fluree.db.dbfunctions.fns.lower_case)?fluree.db.dbfunctions.fns.lower_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT_,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,389,null,389,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT_)?fluree.db.dbfunctions.fns._GT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.count !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.count;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_count,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$count,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",12,1,258,null,258,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll], null)),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",(cljs.core.truth_(fluree.db.dbfunctions.fns.count)?fluree.db.dbfunctions.fns.count.cljs$lang$test:null),"9 + count of objects in count"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nil_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nil_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nil_QMARK_,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",11,1,88,null,88,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if nil, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.nil_QMARK_)?fluree.db.dbfunctions.fns.nil_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objT !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objT;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objT,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objT,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",11,1,727,null,727,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all true flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objT)?fluree.db.dbfunctions.fns.objT.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.inc !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.inc;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_inc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$inc,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",10,1,534,null,534,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Increments any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.inc)?fluree.db.dbfunctions.fns.inc.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._SLASH_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._SLASH_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__SLASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_SLASH_,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,608,null,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",(cljs.core.truth_(fluree.db.dbfunctions.fns._SLASH_)?fluree.db.dbfunctions.fns._SLASH_.cljs$lang$test:null),"9 + count of numbers in /"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.quot !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.quot;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_quot,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$quot,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",11,1,621,null,621,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Quot[ient] of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.quot)?fluree.db.dbfunctions.fns.quot.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.flakes !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.flakes;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_flakes,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$flakes,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",13,1,751,null,751,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the flakes from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.flakes)?fluree.db.dbfunctions.fns.flakes.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_not,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$not,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",10,1,100,null,100,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"Takes a boolean, true returns false, false returns true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not)?fluree.db.dbfunctions.fns.not.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_sid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_sid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_sid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_sid,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",11,1,171,null,171,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current subject id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_sid)?fluree.db.dbfunctions.fns._QMARK_sid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.uuid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.uuid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_uuid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$uuid,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",11,1,779,null,779,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.uuid)?fluree.db.dbfunctions.fns.uuid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_user_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_user_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_user_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_user_id,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",15,1,697,null,697,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current user _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_user_id)?fluree.db.dbfunctions.fns._QMARK_user_id.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT__EQ_,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,415,null,415,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT__EQ_)?fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__EQ__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_EQ__EQ_,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,376,null,376,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.min !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.min;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_min,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$min,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,467,null,467,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets min value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.min)?fluree.db.dbfunctions.fns.min.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.ceil !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.ceil;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_ceil,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$ceil,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",11,1,789,null,789,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the ceiling of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.ceil)?fluree.db.dbfunctions.fns.ceil.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.if_else !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.if_else;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_if_DASH_else,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$if_DASH_else,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",14,1,75,null,75,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$test,cljs.core.cst$sym$t,cljs.core.cst$sym$f], null)),"Evaluates test.",(cljs.core.truth_(fluree.db.dbfunctions.fns.if_else)?fluree.db.dbfunctions.fns.if_else.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pid,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",11,1,190,null,190,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current predicate id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pid)?fluree.db.dbfunctions.fns._QMARK_pid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._PLUS_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._PLUS_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__PLUS_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_PLUS_,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,569,null,569,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns sum of each argument.",(cljs.core.truth_(fluree.db.dbfunctions.fns._PLUS_)?fluree.db.dbfunctions.fns._PLUS_.cljs$lang$test:null),"9 + count of numbers in +"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__EQ__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_EQ__EQ_,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,376,null,376,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.boolean$ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.boolean$;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_boolean,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$boolean,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",14,1,660,null,660,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$x], null)),"Coerce to boolean. Everything except false and nil is true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.boolean$)?fluree.db.dbfunctions.fns.boolean$.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,454,null,454,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets max value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max)?fluree.db.dbfunctions.fns.max.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.empty_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.empty_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_empty_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$empty_QMARK_,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",13,1,111,null,111,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if empty or #{nil}, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.empty_QMARK_)?fluree.db.dbfunctions.fns.empty_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._STAR_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._STAR_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__STAR_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_STAR_,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,595,null,595,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns product of all the numbers in the sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns._STAR_)?fluree.db.dbfunctions.fns._STAR_.cljs$lang$test:null),"9 + count of numbers in *"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.relationship_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.relationship_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_relationship_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$relationship_QMARK_,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",20,1,507,null,507,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$startSubject,cljs.core.cst$sym$path,cljs.core.cst$sym$endSubject], null)),"Determines whether there is a relationship between two subjects",(cljs.core.truth_(fluree.db.dbfunctions.fns.relationship_QMARK_)?fluree.db.dbfunctions.fns.relationship_QMARK_.cljs$lang$test:null),"10, plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_in !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_in;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_in,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_in,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",13,1,334,null,334,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Returns the value of a nested structure",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_in)?fluree.db.dbfunctions.fns.get_in.cljs$lang$test:null),"Length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.now !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.now;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_now,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$now,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",10,1,559,null,559,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns current epoch milliseconds on the executing machine.",(cljs.core.truth_(fluree.db.dbfunctions.fns.now)?fluree.db.dbfunctions.fns.now.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.dec !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.dec;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_dec,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$dec,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",10,1,546,null,546,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Decrements any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.dec)?fluree.db.dbfunctions.fns.dec.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",14,1,315,null,315,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.floor !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.floor;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_floor,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$floor,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",12,1,801,null,801,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the floor of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.floor)?fluree.db.dbfunctions.fns.floor.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not_EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not_EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_not_EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$not_EQ_,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,441,null,441,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if two (or more) values are not equal.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not_EQ_)?fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",10,1,272,null,272,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$pred], null)),"Gets a value from an subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get)?fluree.db.dbfunctions.fns.get.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.str !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.str;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_str,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$str,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,123,null,123,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Concatenates all in sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.str)?fluree.db.dbfunctions.fns.str.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT_,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,402,null,402,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT_)?fluree.db.dbfunctions.fns._LT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__DASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_DASH_,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,582,null,582,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.",(cljs.core.truth_(fluree.db.dbfunctions.fns._)?fluree.db.dbfunctions.fns._.cljs$lang$test:null),"9 + count of numbers in -"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rand !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rand;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rand,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rand,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,763,null,763,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.rand)?fluree.db.dbfunctions.fns.rand.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.contains_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.contains_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_contains_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$contains_QMARK_,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",16,1,348,null,348,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),"Returns true if key is present.",(cljs.core.truth_(fluree.db.dbfunctions.fns.contains_QMARK_)?fluree.db.dbfunctions.fns.contains_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.hash_set !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.hash_set;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_hash_DASH_set,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$hash_DASH_set,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,362,null,362,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns a hash-set of values",(cljs.core.truth_(fluree.db.dbfunctions.fns.hash_set)?fluree.db.dbfunctions.fns.hash_set.cljs$lang$test:null),"9 + count of items in hash-set"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.valid_email_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.valid_email_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_valid_DASH_email_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$valid_DASH_email_QMARK_,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",19,1,685,null,685,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$email], null)),"Determines whether an email is valid, based on its pattern",(cljs.core.truth_(fluree.db.dbfunctions.fns.valid_email_QMARK_)?fluree.db.dbfunctions.fns.valid_email_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_p !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_p;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_p,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_p,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,216,null,216,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current predicate predicates",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_p)?fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nth !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nth;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nth,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nth,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",10,1,60,null,60,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),"Returns the nth item in a collection",(cljs.core.truth_(fluree.db.dbfunctions.fns.nth)?fluree.db.dbfunctions.fns.nth.cljs$lang$test:null),"9 + count of objects in collection"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.subs !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.subs;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_subs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$subs,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",11,1,135,null,135,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args], null)),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(cljs.core.truth_(fluree.db.dbfunctions.fns.subs)?fluree.db.dbfunctions.fns.subs.cljs$lang$test:null),(30)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.mod !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.mod;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_mod,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$mod,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",10,1,634,null,634,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Modulus of num and div. Truncates toward negative infinity.",(cljs.core.truth_(fluree.db.dbfunctions.fns.mod)?fluree.db.dbfunctions.fns.mod.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_s !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_s;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_s,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,203,null,203,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_s)?fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rem !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rem;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rem,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rem,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",10,1,647,null,647,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Remainder of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.rem)?fluree.db.dbfunctions.fns.rem.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.query !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.query;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_query,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$query,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,6,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,6,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,480,null,480,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),"Executes a query",(cljs.core.truth_(fluree.db.dbfunctions.fns.query)?fluree.db.dbfunctions.fns.query.cljs$lang$test:null),"Fuel required for query"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_o !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_o;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_o,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_o,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",9,1,290,null,290,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the object of an predicate from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_o)?fluree.db.dbfunctions.fns._QMARK_o.cljs$lang$test:null),(1)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objF !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objF;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objF,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objF,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",11,1,739,null,739,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all false flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objF)?fluree.db.dbfunctions.fns.objF.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",14,1,315,null,315,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.or !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.or;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_or,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$or,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,245,null,245,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if any in the sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.or)?fluree.db.dbfunctions.fns.or.cljs$lang$test:null),"Count of objects in or"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.re_find !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.re_find;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_re_DASH_find,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$re_DASH_find,"/home/dan/projects/db/src/fluree/db/dbfunctions/fns.cljc",14,1,672,null,672,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pattern,cljs.core.cst$sym$string], null)),"Execute a re-find operation of regex pattern on provided string.",(cljs.core.truth_(fluree.db.dbfunctions.fns.re_find)?fluree.db.dbfunctions.fns.re_find.cljs$lang$test:null),(10)]))):null)]);
fluree.db.dbfunctions.core.resolve_local_fn = (function fluree$db$dbfunctions$core$resolve_local_fn(f){
var map__74668 = cljs.core.meta(f);
var map__74668__$1 = cljs.core.__destructure_map(map__74668);
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74668__$1,cljs.core.cst$kw$fdb_SLASH_spec);
var arglists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74668__$1,cljs.core.cst$kw$arglists);
var arglist = cljs.core.first(arglists);
var _AMPERSAND_args_QMARK_ = (function (){var and__5043__auto__ = (function (){var G__74670 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("&");
var fexpr__74669 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__74669.cljs$core$IFn$_invoke$arity$1 ? fexpr__74669.cljs$core$IFn$_invoke$arity$1(G__74670) : fexpr__74669.call(null,G__74670));
})();
if(cljs.core.truth_(and__5043__auto__)){
var G__74672 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("args");
var fexpr__74671 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__74671.cljs$core$IFn$_invoke$arity$1 ? fexpr__74671.cljs$core$IFn$_invoke$arity$1(G__74672) : fexpr__74671.call(null,G__74672));
} else {
return and__5043__auto__;
}
})();
var arity = ((cljs.core.not(_AMPERSAND_args_QMARK_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__74667_SHARP_){
return (cljs.core.count(p1__74667_SHARP_) - (1));
}),arglists)):null);
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$f,f,cljs.core.cst$kw$params,arglists,cljs.core.cst$kw$arity,arity,cljs.core.cst$kw$_AMPERSAND_args_QMARK_,_AMPERSAND_args_QMARK_,cljs.core.cst$kw$spec,spec,cljs.core.cst$kw$code,null], null);
});
fluree.db.dbfunctions.core.build_fn = (function fluree$db$dbfunctions$core$build_fn(var$,fun){
return cljs.core.eval(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$cljs$core_SLASH_fn,null,(1),null)),(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$1((new cljs.core.List(null,var$,null,(1),null)))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,fun,null,(1),null))], 0)))));
});
fluree.db.dbfunctions.core.find_fn_STAR_ = (function fluree$db$dbfunctions$core$find_fn_STAR_(db,fn_name,funType){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_74757){
var state_val_74758 = (state_74757[(1)]);
if((state_val_74758 === (7))){
var inst_74682 = cljs.core.deref(fluree.db.dbfunctions.core.db_fn_cache);
var inst_74683 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74684 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_74685 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_74686 = [fn_name,inst_74684,inst_74685];
var inst_74687 = (new cljs.core.PersistentVector(null,3,(5),inst_74683,inst_74686,null));
var inst_74688 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74682,inst_74687);
var state_74757__$1 = state_74757;
var statearr_74759_74796 = state_74757__$1;
(statearr_74759_74796[(2)] = inst_74688);

(statearr_74759_74796[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74758 === (1))){
var state_74757__$1 = state_74757;
var statearr_74760_74797 = state_74757__$1;
(statearr_74760_74797[(2)] = null);

(statearr_74760_74797[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74758 === (4))){
var inst_74673 = (state_74757[(2)]);
var state_74757__$1 = state_74757;
var statearr_74761_74798 = state_74757__$1;
(statearr_74761_74798[(2)] = inst_74673);

(statearr_74761_74798[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74758 === (15))){
var inst_74706 = (state_74757[(7)]);
var inst_74720 = (state_74757[(8)]);
var inst_74718 = (state_74757[(2)]);
var inst_74719 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74706,"_fn/params");
var inst_74720__$1 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_74719);
var inst_74721 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74706,"_fn/code");
var inst_74722 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_74721);
var inst_74723 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_74722,funType,inst_74720__$1) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_74722,funType,inst_74720__$1));
var state_74757__$1 = (function (){var statearr_74762 = state_74757;
(statearr_74762[(9)] = inst_74718);

(statearr_74762[(8)] = inst_74720__$1);

return statearr_74762;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74757__$1,(16),inst_74723);
} else {
if((state_val_74758 === (13))){
var inst_74709 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fn_name], 0));
var inst_74710 = ["Unknown function: ",inst_74709].join('');
var inst_74711 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_74712 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_74713 = cljs.core.PersistentHashMap.fromArrays(inst_74711,inst_74712);
var inst_74714 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74710,inst_74713);
var inst_74715 = (function(){throw inst_74714})();
var state_74757__$1 = state_74757;
var statearr_74763_74799 = state_74757__$1;
(statearr_74763_74799[(2)] = inst_74715);

(statearr_74763_74799[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74758 === (6))){
var state_74757__$1 = state_74757;
var statearr_74764_74800 = state_74757__$1;
(statearr_74764_74800[(2)] = null);

(statearr_74764_74800[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74758 === (17))){
var state_74757__$1 = state_74757;
var statearr_74765_74801 = state_74757__$1;
(statearr_74765_74801[(2)] = null);

(statearr_74765_74801[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74758 === (3))){
var inst_74755 = (state_74757[(2)]);
var state_74757__$1 = state_74757;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74757__$1,inst_74755);
} else {
if((state_val_74758 === (12))){
var inst_74706 = (state_74757[(7)]);
var inst_74705 = (state_74757[(2)]);
var inst_74706__$1 = fluree.db.util.async.throw_err(inst_74705);
var inst_74707 = cljs.core.empty_QMARK_(inst_74706__$1);
var state_74757__$1 = (function (){var statearr_74766 = state_74757;
(statearr_74766[(7)] = inst_74706__$1);

return statearr_74766;
})();
if(inst_74707){
var statearr_74767_74802 = state_74757__$1;
(statearr_74767_74802[(1)] = (13));

} else {
var statearr_74768_74803 = state_74757__$1;
(statearr_74768_74803[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74758 === (2))){
var inst_74679 = (state_74757[(10)]);
var _ = (function (){var statearr_74769 = state_74757;
(statearr_74769[(4)] = cljs.core.cons((5),(state_74757[(4)])));

return statearr_74769;
})();
var inst_74679__$1 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var state_74757__$1 = (function (){var statearr_74770 = state_74757;
(statearr_74770[(10)] = inst_74679__$1);

return statearr_74770;
})();
if(cljs.core.truth_(inst_74679__$1)){
var statearr_74771_74804 = state_74757__$1;
(statearr_74771_74804[(1)] = (6));

} else {
var statearr_74772_74805 = state_74757__$1;
(statearr_74772_74805[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74758 === (19))){
var inst_74740 = (state_74757[(11)]);
var inst_74750 = (state_74757[(2)]);
var state_74757__$1 = (function (){var statearr_74773 = state_74757;
(statearr_74773[(12)] = inst_74750);

return statearr_74773;
})();
var statearr_74774_74806 = state_74757__$1;
(statearr_74774_74806[(2)] = inst_74740);

(statearr_74774_74806[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74758 === (11))){
var inst_74752 = (state_74757[(2)]);
var _ = (function (){var statearr_74776 = state_74757;
(statearr_74776[(4)] = cljs.core.rest((state_74757[(4)])));

return statearr_74776;
})();
var state_74757__$1 = state_74757;
var statearr_74777_74807 = state_74757__$1;
(statearr_74777_74807[(2)] = inst_74752);

(statearr_74777_74807[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74758 === (9))){
var inst_74690 = (state_74757[(13)]);
var state_74757__$1 = state_74757;
var statearr_74778_74808 = state_74757__$1;
(statearr_74778_74808[(2)] = inst_74690);

(statearr_74778_74808[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74758 === (5))){
var _ = (function (){var statearr_74779 = state_74757;
(statearr_74779[(4)] = cljs.core.rest((state_74757[(4)])));

return statearr_74779;
})();
var state_74757__$1 = state_74757;
var ex74775 = (state_74757__$1[(2)]);
var statearr_74780_74809 = state_74757__$1;
(statearr_74780_74809[(5)] = ex74775);


if((ex74775 instanceof Error)){
var statearr_74781_74810 = state_74757__$1;
(statearr_74781_74810[(1)] = (4));

(statearr_74781_74810[(5)] = null);

} else {
throw ex74775;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74758 === (14))){
var state_74757__$1 = state_74757;
var statearr_74782_74811 = state_74757__$1;
(statearr_74782_74811[(2)] = null);

(statearr_74782_74811[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74758 === (16))){
var inst_74702 = (state_74757[(14)]);
var inst_74706 = (state_74757[(7)]);
var inst_74718 = (state_74757[(9)]);
var inst_74720 = (state_74757[(8)]);
var inst_74679 = (state_74757[(10)]);
var inst_74690 = (state_74757[(13)]);
var inst_74725 = (state_74757[(2)]);
var inst_74726 = fluree.db.util.async.throw_err(inst_74725);
var inst_74727 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74706,"_fn/spec");
var inst_74728 = cljs.core.PersistentVector.EMPTY;
var inst_74729 = cljs.core.cst$sym$_QMARK_ctx;
var inst_74730 = (function (){var forward_time_travel_db_QMARK_ = inst_74679;
var or__5045__auto__ = inst_74690;
var query = inst_74702;
var res = inst_74706;
var _ = inst_74718;
var params = inst_74720;
var code = inst_74726;
var spec = inst_74727;
return (function (x){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(x);
});
})();
var inst_74731 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_74730,inst_74720);
var inst_74732 = cljs.core.cons(inst_74729,inst_74731);
var inst_74733 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_74728,inst_74732);
var inst_74734 = fluree.db.dbfunctions.core.build_fn(inst_74733,inst_74726);
var inst_74735 = [cljs.core.cst$kw$f,cljs.core.cst$kw$params,cljs.core.cst$kw$arity,cljs.core.cst$kw$_AMPERSAND_args_QMARK_,cljs.core.cst$kw$spec,cljs.core.cst$kw$code];
var inst_74736 = cljs.core.count(inst_74720);
var inst_74737 = [inst_74736];
var inst_74738 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_74737);
var inst_74739 = [inst_74734,inst_74720,inst_74738,false,inst_74727,null];
var inst_74740 = cljs.core.PersistentHashMap.fromArrays(inst_74735,inst_74739);
var state_74757__$1 = (function (){var statearr_74783 = state_74757;
(statearr_74783[(11)] = inst_74740);

return statearr_74783;
})();
if(cljs.core.truth_(inst_74679)){
var statearr_74784_74812 = state_74757__$1;
(statearr_74784_74812[(1)] = (17));

} else {
var statearr_74785_74813 = state_74757__$1;
(statearr_74785_74813[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74758 === (10))){
var inst_74702 = (state_74757[(14)]);
var inst_74693 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from];
var inst_74694 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74695 = ["_fn/params","_fn/code","_fn/spec"];
var inst_74696 = (new cljs.core.PersistentVector(null,3,(5),inst_74694,inst_74695,null));
var inst_74697 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74698 = cljs.core.name(fn_name);
var inst_74699 = ["_fn/name",inst_74698];
var inst_74700 = (new cljs.core.PersistentVector(null,2,(5),inst_74697,inst_74699,null));
var inst_74701 = [inst_74696,inst_74700];
var inst_74702__$1 = cljs.core.PersistentHashMap.fromArrays(inst_74693,inst_74701);
var inst_74703 = fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2(db,inst_74702__$1);
var state_74757__$1 = (function (){var statearr_74786 = state_74757;
(statearr_74786[(14)] = inst_74702__$1);

return statearr_74786;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74757__$1,(12),inst_74703);
} else {
if((state_val_74758 === (18))){
var inst_74740 = (state_74757[(11)]);
var inst_74743 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74744 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_74745 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_74746 = [fn_name,inst_74744,inst_74745];
var inst_74747 = (new cljs.core.PersistentVector(null,3,(5),inst_74743,inst_74746,null));
var inst_74748 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.dbfunctions.core.db_fn_cache,cljs.core.assoc,inst_74747,inst_74740);
var state_74757__$1 = state_74757;
var statearr_74787_74814 = state_74757__$1;
(statearr_74787_74814[(2)] = inst_74748);

(statearr_74787_74814[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74758 === (8))){
var inst_74690 = (state_74757[(13)]);
var inst_74690__$1 = (state_74757[(2)]);
var state_74757__$1 = (function (){var statearr_74788 = state_74757;
(statearr_74788[(13)] = inst_74690__$1);

return statearr_74788;
})();
if(cljs.core.truth_(inst_74690__$1)){
var statearr_74789_74815 = state_74757__$1;
(statearr_74789_74815[(1)] = (9));

} else {
var statearr_74790_74816 = state_74757__$1;
(statearr_74790_74816[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__15091__auto____0 = (function (){
var statearr_74791 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74791[(0)] = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__15091__auto__);

(statearr_74791[(1)] = (1));

return statearr_74791;
});
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__15091__auto____1 = (function (state_74757){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_74757);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e74792){var ex__15094__auto__ = e74792;
var statearr_74793_74817 = state_74757;
(statearr_74793_74817[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_74757[(4)]))){
var statearr_74794_74818 = state_74757;
(statearr_74794_74818[(1)] = cljs.core.first((state_74757[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__74819 = state_74757;
state_74757 = G__74819;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__15091__auto__ = function(state_74757){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__15091__auto____1.call(this,state_74757);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__15091__auto____0;
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_74795 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_74795[(6)] = c__15165__auto__);

return statearr_74795;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
fluree.db.dbfunctions.core.find_fn = (function fluree$db$dbfunctions$core$find_fn(var_args){
var G__74821 = arguments.length;
switch (G__74821) {
case 2:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,fn_name){
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,fn_name,null);
}));

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_name,funType){
if(("nodejs" === cljs.core._STAR_target_STAR_)){
return fluree.db.dbfunctions.core.find_fn_STAR_(db,fn_name,funType);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("DB functions not yet supported in javascript!",cljs.core.PersistentArrayMap.EMPTY);

}
}));

(fluree.db.dbfunctions.core.find_fn.cljs$lang$maxFixedArity = 3);

/**
 * Given a collection of function strings, returns a combined function using the and function
 */
fluree.db.dbfunctions.core.combine_fns = (function fluree$db$dbfunctions$core$combine_fns(fn_str_coll){
if((cljs.core.count(fn_str_coll) > (1))){
return ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",fn_str_coll),")"].join('');
} else {
return cljs.core.first(fn_str_coll);
}
});
fluree.db.dbfunctions.core.symbol_whitelist = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [cljs.core.cst$sym$_QMARK_pO,null,cljs.core.cst$sym$_QMARK_auth_id,null,cljs.core.cst$sym$sid,null,cljs.core.cst$sym$_QMARK_user_id,null,cljs.core.cst$sym$_QMARK_pid,null,cljs.core.cst$sym$_QMARK_a,null,cljs.core.cst$sym$_QMARK_db,null,cljs.core.cst$sym$_QMARK_s,null,cljs.core.cst$sym$_QMARK_o,null], null), null);
/**
 * Ensures contents of vector are allowed
 */
fluree.db.dbfunctions.core.parse_vector = (function fluree$db$dbfunctions$core$parse_vector(var_args){
var G__74825 = arguments.length;
switch (G__74825) {
case 2:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2 = (function (db,vec){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,null,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3 = (function (db,vec,funType){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,funType,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4 = (function (db,vec,funType,params){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_74955){
var state_val_74956 = (state_74955[(1)]);
if((state_val_74956 === (7))){
var inst_74950 = (state_74955[(2)]);
var _ = (function (){var statearr_74957 = state_74955;
(statearr_74957[(4)] = cljs.core.rest((state_74955[(4)])));

return statearr_74957;
})();
var state_74955__$1 = state_74955;
var statearr_74958_75038 = state_74955__$1;
(statearr_74958_75038[(2)] = inst_74950);

(statearr_74958_75038[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (20))){
var inst_74864 = (state_74955[(7)]);
var state_74955__$1 = state_74955;
var statearr_74959_75039 = state_74955__$1;
(statearr_74959_75039[(2)] = inst_74864);

(statearr_74959_75039[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (27))){
var inst_74851 = (state_74955[(8)]);
var inst_74877 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_74878 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74851)," used in function.",inst_74877].join('');
var inst_74879 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_74880 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_74881 = cljs.core.PersistentHashMap.fromArrays(inst_74879,inst_74880);
var inst_74882 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74878,inst_74881);
var inst_74883 = (function(){throw inst_74882})();
var state_74955__$1 = state_74955;
var statearr_74960_75040 = state_74955__$1;
(statearr_74960_75040[(2)] = inst_74883);

(statearr_74960_75040[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (1))){
var state_74955__$1 = state_74955;
var statearr_74961_75041 = state_74955__$1;
(statearr_74961_75041[(2)] = null);

(statearr_74961_75041[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (24))){
var inst_74874 = (state_74955[(9)]);
var inst_74874__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(funType,"functionDec");
var state_74955__$1 = (function (){var statearr_74962 = state_74955;
(statearr_74962[(9)] = inst_74874__$1);

return statearr_74962;
})();
if(inst_74874__$1){
var statearr_74963_75042 = state_74955__$1;
(statearr_74963_75042[(1)] = (26));

} else {
var statearr_74964_75043 = state_74955__$1;
(statearr_74964_75043[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (39))){
var inst_74851 = (state_74955[(8)]);
var inst_74911 = (inst_74851 == null);
var state_74955__$1 = state_74955;
if(cljs.core.truth_(inst_74911)){
var statearr_74965_75044 = state_74955__$1;
(statearr_74965_75044[(1)] = (42));

} else {
var statearr_74966_75045 = state_74955__$1;
(statearr_74966_75045[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (46))){
var state_74955__$1 = state_74955;
var statearr_74967_75046 = state_74955__$1;
(statearr_74967_75046[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (4))){
var inst_74826 = (state_74955[(2)]);
var state_74955__$1 = state_74955;
var statearr_74969_75047 = state_74955__$1;
(statearr_74969_75047[(2)] = inst_74826);

(statearr_74969_75047[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (15))){
var inst_74851 = (state_74955[(8)]);
var inst_74862 = (inst_74851 instanceof cljs.core.Symbol);
var state_74955__$1 = state_74955;
if(cljs.core.truth_(inst_74862)){
var statearr_74970_75048 = state_74955__$1;
(statearr_74970_75048[(1)] = (17));

} else {
var statearr_74971_75049 = state_74955__$1;
(statearr_74971_75049[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (48))){
var inst_74918 = (state_74955[(2)]);
var inst_74919 = fluree.db.util.async.throw_err(inst_74918);
var state_74955__$1 = state_74955;
var statearr_74972_75050 = state_74955__$1;
(statearr_74972_75050[(2)] = inst_74919);

(statearr_74972_75050[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (50))){
var state_74955__$1 = state_74955;
var statearr_74973_75051 = state_74955__$1;
(statearr_74973_75051[(2)] = null);

(statearr_74973_75051[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (21))){
var inst_74842 = (state_74955[(10)]);
var inst_74844 = (state_74955[(11)]);
var inst_74841 = (state_74955[(12)]);
var inst_74851 = (state_74955[(8)]);
var inst_74852 = (state_74955[(13)]);
var inst_74845 = (state_74955[(14)]);
var inst_74864 = (state_74955[(7)]);
var inst_74839 = (state_74955[(15)]);
var inst_74871 = (state_74955[(16)]);
var inst_74867 = [inst_74851];
var inst_74868 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_74867);
var inst_74869 = (function (){var vec__74847 = inst_74844;
var x = inst_74851;
var seq__74837 = inst_74842;
var or__5045__auto__ = inst_74864;
var r = inst_74852;
var first__74838 = inst_74841;
var G__74835 = inst_74844;
var acc = inst_74845;
var vec__74836 = inst_74839;
var seq__74848 = inst_74852;
var first__74849 = inst_74851;
return (function (p1__74823_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__74823_SHARP_);
});
})();
var inst_74870 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_74869,params);
var inst_74871__$1 = cljs.core.some(inst_74868,inst_74870);
var state_74955__$1 = (function (){var statearr_74974 = state_74955;
(statearr_74974[(16)] = inst_74871__$1);

return statearr_74974;
})();
if(cljs.core.truth_(inst_74871__$1)){
var statearr_74975_75052 = state_74955__$1;
(statearr_74975_75052[(1)] = (23));

} else {
var statearr_74976_75053 = state_74955__$1;
(statearr_74976_75053[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (31))){
var inst_74901 = (state_74955[(2)]);
var state_74955__$1 = state_74955;
if(cljs.core.truth_(inst_74901)){
var statearr_74977_75054 = state_74955__$1;
(statearr_74977_75054[(1)] = (35));

} else {
var statearr_74978_75055 = state_74955__$1;
(statearr_74978_75055[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (32))){
var inst_74894 = (state_74955[(17)]);
var state_74955__$1 = state_74955;
var statearr_74979_75056 = state_74955__$1;
(statearr_74979_75056[(2)] = inst_74894);

(statearr_74979_75056[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (40))){
var inst_74936 = (state_74955[(2)]);
var state_74955__$1 = state_74955;
var statearr_74980_75057 = state_74955__$1;
(statearr_74980_75057[(2)] = inst_74936);

(statearr_74980_75057[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (33))){
var inst_74851 = (state_74955[(8)]);
var inst_74897 = (inst_74851 == null);
var state_74955__$1 = state_74955;
var statearr_74981_75058 = state_74955__$1;
(statearr_74981_75058[(2)] = inst_74897);

(statearr_74981_75058[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (13))){
var inst_74852 = (state_74955[(13)]);
var inst_74845 = (state_74955[(14)]);
var inst_74944 = (state_74955[(2)]);
var inst_74945 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_74845,inst_74944);
var inst_74844 = inst_74852;
var inst_74845__$1 = inst_74945;
var state_74955__$1 = (function (){var statearr_74982 = state_74955;
(statearr_74982[(11)] = inst_74844);

(statearr_74982[(14)] = inst_74845__$1);

return statearr_74982;
})();
var statearr_74983_75059 = state_74955__$1;
(statearr_74983_75059[(2)] = null);

(statearr_74983_75059[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (22))){
var inst_74889 = (state_74955[(2)]);
var state_74955__$1 = state_74955;
var statearr_74984_75060 = state_74955__$1;
(statearr_74984_75060[(2)] = inst_74889);

(statearr_74984_75060[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (36))){
var inst_74851 = (state_74955[(8)]);
var inst_74904 = cljs.core.vector_QMARK_(inst_74851);
var state_74955__$1 = state_74955;
if(inst_74904){
var statearr_74985_75061 = state_74955__$1;
(statearr_74985_75061[(1)] = (38));

} else {
var statearr_74986_75062 = state_74955__$1;
(statearr_74986_75062[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (41))){
var inst_74908 = (state_74955[(2)]);
var inst_74909 = fluree.db.util.async.throw_err(inst_74908);
var state_74955__$1 = state_74955;
var statearr_74987_75063 = state_74955__$1;
(statearr_74987_75063[(2)] = inst_74909);

(statearr_74987_75063[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (43))){
var inst_74851 = (state_74955[(8)]);
var inst_74914 = cljs.core.list_QMARK_(inst_74851);
var state_74955__$1 = state_74955;
if(inst_74914){
var statearr_74988_75064 = state_74955__$1;
(statearr_74988_75064[(1)] = (45));

} else {
var statearr_74989_75065 = state_74955__$1;
(statearr_74989_75065[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (29))){
var inst_74891 = (state_74955[(18)]);
var state_74955__$1 = state_74955;
var statearr_74990_75066 = state_74955__$1;
(statearr_74990_75066[(2)] = inst_74891);

(statearr_74990_75066[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (44))){
var inst_74934 = (state_74955[(2)]);
var state_74955__$1 = state_74955;
var statearr_74991_75067 = state_74955__$1;
(statearr_74991_75067[(2)] = inst_74934);

(statearr_74991_75067[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (6))){
var inst_74844 = (state_74955[(11)]);
var inst_74851 = (state_74955[(8)]);
var inst_74850 = cljs.core.seq(inst_74844);
var inst_74851__$1 = cljs.core.first(inst_74850);
var inst_74852 = cljs.core.next(inst_74850);
var inst_74853 = (inst_74851__$1 == null);
var state_74955__$1 = (function (){var statearr_74992 = state_74955;
(statearr_74992[(8)] = inst_74851__$1);

(statearr_74992[(13)] = inst_74852);

return statearr_74992;
})();
if(cljs.core.truth_(inst_74853)){
var statearr_74993_75068 = state_74955__$1;
(statearr_74993_75068[(1)] = (8));

} else {
var statearr_74994_75069 = state_74955__$1;
(statearr_74994_75069[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (28))){
var inst_74885 = (state_74955[(2)]);
var state_74955__$1 = state_74955;
var statearr_74995_75070 = state_74955__$1;
(statearr_74995_75070[(2)] = inst_74885);

(statearr_74995_75070[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (51))){
var inst_74930 = (state_74955[(2)]);
var state_74955__$1 = state_74955;
var statearr_74996_75071 = state_74955__$1;
(statearr_74996_75071[(2)] = inst_74930);

(statearr_74996_75071[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (25))){
var inst_74887 = (state_74955[(2)]);
var state_74955__$1 = state_74955;
var statearr_74997_75072 = state_74955__$1;
(statearr_74997_75072[(2)] = inst_74887);

(statearr_74997_75072[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (34))){
var inst_74899 = (state_74955[(2)]);
var state_74955__$1 = state_74955;
var statearr_74998_75073 = state_74955__$1;
(statearr_74998_75073[(2)] = inst_74899);

(statearr_74998_75073[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (17))){
var inst_74851 = (state_74955[(8)]);
var inst_74864 = (state_74955[(7)]);
var inst_74864__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_74851) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_74851));
var state_74955__$1 = (function (){var statearr_74999 = state_74955;
(statearr_74999[(7)] = inst_74864__$1);

return statearr_74999;
})();
if(cljs.core.truth_(inst_74864__$1)){
var statearr_75000_75074 = state_74955__$1;
(statearr_75000_75074[(1)] = (20));

} else {
var statearr_75001_75075 = state_74955__$1;
(statearr_75001_75075[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (3))){
var inst_74953 = (state_74955[(2)]);
var state_74955__$1 = state_74955;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74955__$1,inst_74953);
} else {
if((state_val_74956 === (12))){
var inst_74851 = (state_74955[(8)]);
var inst_74859 = typeof inst_74851 === 'number';
var state_74955__$1 = state_74955;
if(cljs.core.truth_(inst_74859)){
var statearr_75002_75076 = state_74955__$1;
(statearr_75002_75076[(1)] = (14));

} else {
var statearr_75003_75077 = state_74955__$1;
(statearr_75003_75077[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (2))){
var inst_74839 = (state_74955[(15)]);
var _ = (function (){var statearr_75004 = state_74955;
(statearr_75004[(4)] = cljs.core.cons((5),(state_74955[(4)])));

return statearr_75004;
})();
var inst_74839__$1 = vec;
var inst_74840 = cljs.core.seq(inst_74839__$1);
var inst_74841 = cljs.core.first(inst_74840);
var inst_74842 = cljs.core.next(inst_74840);
var inst_74843 = cljs.core.PersistentVector.EMPTY;
var inst_74844 = inst_74839__$1;
var inst_74845 = inst_74843;
var state_74955__$1 = (function (){var statearr_75005 = state_74955;
(statearr_75005[(10)] = inst_74842);

(statearr_75005[(11)] = inst_74844);

(statearr_75005[(12)] = inst_74841);

(statearr_75005[(14)] = inst_74845);

(statearr_75005[(15)] = inst_74839__$1);

return statearr_75005;
})();
var statearr_75006_75078 = state_74955__$1;
(statearr_75006_75078[(2)] = null);

(statearr_75006_75078[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (23))){
var inst_74871 = (state_74955[(16)]);
var state_74955__$1 = state_74955;
var statearr_75007_75079 = state_74955__$1;
(statearr_75007_75079[(2)] = inst_74871);

(statearr_75007_75079[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (47))){
var inst_74932 = (state_74955[(2)]);
var state_74955__$1 = state_74955;
var statearr_75008_75080 = state_74955__$1;
(statearr_75008_75080[(2)] = inst_74932);

(statearr_75008_75080[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (35))){
var inst_74851 = (state_74955[(8)]);
var state_74955__$1 = state_74955;
var statearr_75009_75081 = state_74955__$1;
(statearr_75009_75081[(2)] = inst_74851);

(statearr_75009_75081[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (19))){
var inst_74940 = (state_74955[(2)]);
var state_74955__$1 = state_74955;
var statearr_75010_75082 = state_74955__$1;
(statearr_75010_75082[(2)] = inst_74940);

(statearr_75010_75082[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (11))){
var inst_74851 = (state_74955[(8)]);
var state_74955__$1 = state_74955;
var statearr_75012_75083 = state_74955__$1;
(statearr_75012_75083[(2)] = inst_74851);

(statearr_75012_75083[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (9))){
var inst_74851 = (state_74955[(8)]);
var inst_74856 = typeof inst_74851 === 'string';
var state_74955__$1 = state_74955;
if(cljs.core.truth_(inst_74856)){
var statearr_75013_75084 = state_74955__$1;
(statearr_75013_75084[(1)] = (11));

} else {
var statearr_75014_75085 = state_74955__$1;
(statearr_75014_75085[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (5))){
var _ = (function (){var statearr_75015 = state_74955;
(statearr_75015[(4)] = cljs.core.rest((state_74955[(4)])));

return statearr_75015;
})();
var state_74955__$1 = state_74955;
var ex75011 = (state_74955__$1[(2)]);
var statearr_75016_75086 = state_74955__$1;
(statearr_75016_75086[(5)] = ex75011);


if((ex75011 instanceof Error)){
var statearr_75017_75087 = state_74955__$1;
(statearr_75017_75087[(1)] = (4));

(statearr_75017_75087[(5)] = null);

} else {
throw ex75011;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (14))){
var inst_74851 = (state_74955[(8)]);
var state_74955__$1 = state_74955;
var statearr_75018_75088 = state_74955__$1;
(statearr_75018_75088[(2)] = inst_74851);

(statearr_75018_75088[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (45))){
var inst_74851 = (state_74955[(8)]);
var inst_74916 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_74851,funType,params) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_74851,funType,params));
var state_74955__$1 = state_74955;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74955__$1,(48),inst_74916);
} else {
if((state_val_74956 === (26))){
var inst_74874 = (state_74955[(9)]);
var state_74955__$1 = state_74955;
var statearr_75019_75089 = state_74955__$1;
(statearr_75019_75089[(2)] = inst_74874);

(statearr_75019_75089[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (16))){
var inst_74942 = (state_74955[(2)]);
var state_74955__$1 = state_74955;
var statearr_75020_75090 = state_74955__$1;
(statearr_75020_75090[(2)] = inst_74942);

(statearr_75020_75090[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (38))){
var inst_74851 = (state_74955[(8)]);
var inst_74906 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_74851,funType,params);
var state_74955__$1 = state_74955;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74955__$1,(41),inst_74906);
} else {
if((state_val_74956 === (30))){
var inst_74851 = (state_74955[(8)]);
var inst_74894 = (state_74955[(17)]);
var inst_74894__$1 = inst_74851 === false;
var state_74955__$1 = (function (){var statearr_75021 = state_74955;
(statearr_75021[(17)] = inst_74894__$1);

return statearr_75021;
})();
if(cljs.core.truth_(inst_74894__$1)){
var statearr_75022_75091 = state_74955__$1;
(statearr_75022_75091[(1)] = (32));

} else {
var statearr_75023_75092 = state_74955__$1;
(statearr_75023_75092[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (10))){
var inst_74948 = (state_74955[(2)]);
var state_74955__$1 = state_74955;
var statearr_75024_75093 = state_74955__$1;
(statearr_75024_75093[(2)] = inst_74948);

(statearr_75024_75093[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (18))){
var inst_74891 = (state_74955[(18)]);
var inst_74851 = (state_74955[(8)]);
var inst_74891__$1 = inst_74851 === true;
var state_74955__$1 = (function (){var statearr_75025 = state_74955;
(statearr_75025[(18)] = inst_74891__$1);

return statearr_75025;
})();
if(cljs.core.truth_(inst_74891__$1)){
var statearr_75026_75094 = state_74955__$1;
(statearr_75026_75094[(1)] = (29));

} else {
var statearr_75027_75095 = state_74955__$1;
(statearr_75027_75095[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (42))){
var inst_74851 = (state_74955[(8)]);
var state_74955__$1 = state_74955;
var statearr_75028_75096 = state_74955__$1;
(statearr_75028_75096[(2)] = inst_74851);

(statearr_75028_75096[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (37))){
var inst_74938 = (state_74955[(2)]);
var state_74955__$1 = state_74955;
var statearr_75029_75097 = state_74955__$1;
(statearr_75029_75097[(2)] = inst_74938);

(statearr_75029_75097[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (8))){
var inst_74845 = (state_74955[(14)]);
var state_74955__$1 = state_74955;
var statearr_75030_75098 = state_74955__$1;
(statearr_75030_75098[(2)] = inst_74845);

(statearr_75030_75098[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74956 === (49))){
var inst_74851 = (state_74955[(8)]);
var inst_74922 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74851], 0));
var inst_74923 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_74924 = ["Illegal element (",inst_74922,") in vector: ",inst_74923,"."].join('');
var inst_74925 = cljs.core.PersistentHashMap.EMPTY;
var inst_74926 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74924,inst_74925);
var inst_74927 = (function(){throw inst_74926})();
var state_74955__$1 = state_74955;
var statearr_75031_75099 = state_74955__$1;
(statearr_75031_75099[(2)] = inst_74927);

(statearr_75031_75099[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__15091__auto____0 = (function (){
var statearr_75032 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75032[(0)] = fluree$db$dbfunctions$core$state_machine__15091__auto__);

(statearr_75032[(1)] = (1));

return statearr_75032;
});
var fluree$db$dbfunctions$core$state_machine__15091__auto____1 = (function (state_74955){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_74955);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e75033){var ex__15094__auto__ = e75033;
var statearr_75034_75100 = state_74955;
(statearr_75034_75100[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_74955[(4)]))){
var statearr_75035_75101 = state_74955;
(statearr_75035_75101[(1)] = cljs.core.first((state_74955[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__75102 = state_74955;
state_74955 = G__75102;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__15091__auto__ = function(state_74955){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__15091__auto____1.call(this,state_74955);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__15091__auto____0;
fluree$db$dbfunctions$core$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__15091__auto____1;
return fluree$db$dbfunctions$core$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_75036 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_75036[(6)] = c__15165__auto__);

return statearr_75036;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$lang$maxFixedArity = 4);

/**
 * Looks up function in local-function map. If exists returns map of function details,
 *   if doesn't exist returns nil.
 */
fluree.db.dbfunctions.core.find_local_fn_STAR_ = (function fluree$db$dbfunctions$core$find_local_fn_STAR_(fn_name){
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.core.default_fn_map,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(fn_name));
if(cljs.core.truth_(temp__5804__auto__)){
var local_fn = temp__5804__auto__;
return fluree.db.dbfunctions.core.resolve_local_fn(local_fn);
} else {
return null;
}
});
fluree.db.dbfunctions.core.find_local_fn = cljs.core.memoize(fluree.db.dbfunctions.core.find_local_fn_STAR_);
/**
 * Resolves a full code form expression.
 */
fluree.db.dbfunctions.core.resolve_fn = (function fluree$db$dbfunctions$core$resolve_fn(var_args){
var G__75105 = arguments.length;
switch (G__75105) {
case 2:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,form){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,null,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,form,type){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,type,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,form,type,params){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_75269){
var state_val_75270 = (state_75269[(1)]);
if((state_val_75270 === (7))){
var inst_75113 = (state_75269[(7)]);
var inst_75119 = fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,inst_75113,type);
var state_75269__$1 = state_75269;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75269__$1,(9),inst_75119);
} else {
if((state_val_75270 === (59))){
var inst_75162 = (state_75269[(8)]);
var inst_75233 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_75162], 0));
var inst_75234 = (type.cljs$core$IFn$_invoke$arity$1 ? type.cljs$core$IFn$_invoke$arity$1(inst_75162) : type.call(null,inst_75162));
var inst_75235 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_75236 = ["Illegal element (",inst_75233,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75234),") in function argument: ",inst_75235,"."].join('');
var inst_75237 = cljs.core.PersistentHashMap.EMPTY;
var inst_75238 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75236,inst_75237);
var inst_75239 = (function(){throw inst_75238})();
var state_75269__$1 = state_75269;
var statearr_75271_75366 = state_75269__$1;
(statearr_75271_75366[(2)] = inst_75239);

(statearr_75271_75366[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (20))){
var inst_75168 = (state_75269[(2)]);
var state_75269__$1 = state_75269;
if(cljs.core.truth_(inst_75168)){
var statearr_75272_75367 = state_75269__$1;
(statearr_75272_75367[(1)] = (21));

} else {
var statearr_75273_75368 = state_75269__$1;
(statearr_75273_75368[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (58))){
var inst_75229 = (state_75269[(2)]);
var inst_75230 = fluree.db.util.async.throw_err(inst_75229);
var state_75269__$1 = state_75269;
var statearr_75274_75369 = state_75269__$1;
(statearr_75274_75369[(2)] = inst_75230);

(statearr_75274_75369[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (60))){
var state_75269__$1 = state_75269;
var statearr_75275_75370 = state_75269__$1;
(statearr_75275_75370[(2)] = null);

(statearr_75275_75370[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (27))){
var inst_75174 = (state_75269[(2)]);
var inst_75175 = fluree.db.util.async.throw_err(inst_75174);
var state_75269__$1 = state_75269;
var statearr_75276_75371 = state_75269__$1;
(statearr_75276_75371[(2)] = inst_75175);

(statearr_75276_75371[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (1))){
var state_75269__$1 = state_75269;
var statearr_75277_75372 = state_75269__$1;
(statearr_75277_75372[(2)] = null);

(statearr_75277_75372[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (24))){
var inst_75162 = (state_75269[(8)]);
var inst_75172 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_75162,type,params);
var state_75269__$1 = state_75269;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75269__$1,(27),inst_75172);
} else {
if((state_val_75270 === (55))){
var inst_75162 = (state_75269[(8)]);
var inst_75227 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_75162,type,params);
var state_75269__$1 = state_75269;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75269__$1,(58),inst_75227);
} else {
if((state_val_75270 === (39))){
var inst_75210 = (state_75269[(2)]);
var state_75269__$1 = state_75269;
var statearr_75278_75373 = state_75269__$1;
(statearr_75278_75373[(2)] = inst_75210);

(statearr_75278_75373[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (46))){
var inst_75212 = (state_75269[(9)]);
var state_75269__$1 = state_75269;
var statearr_75279_75374 = state_75269__$1;
(statearr_75279_75374[(2)] = inst_75212);

(statearr_75279_75374[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (4))){
var inst_75106 = (state_75269[(2)]);
var state_75269__$1 = state_75269;
var statearr_75280_75375 = state_75269__$1;
(statearr_75280_75375[(2)] = inst_75106);

(statearr_75280_75375[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (54))){
var inst_75246 = (state_75269[(2)]);
var state_75269__$1 = state_75269;
var statearr_75281_75376 = state_75269__$1;
(statearr_75281_75376[(2)] = inst_75246);

(statearr_75281_75376[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (15))){
var inst_75114 = (state_75269[(10)]);
var inst_75143 = (state_75269[(2)]);
var inst_75151 = cljs.core.seq(inst_75114);
var inst_75152 = cljs.core.first(inst_75151);
var inst_75153 = cljs.core.next(inst_75151);
var inst_75154 = cljs.core.PersistentVector.EMPTY;
var inst_75155 = inst_75114;
var inst_75156 = inst_75154;
var state_75269__$1 = (function (){var statearr_75282 = state_75269;
(statearr_75282[(11)] = inst_75156);

(statearr_75282[(12)] = inst_75143);

(statearr_75282[(13)] = inst_75152);

(statearr_75282[(14)] = inst_75155);

(statearr_75282[(15)] = inst_75153);

return statearr_75282;
})();
var statearr_75283_75377 = state_75269__$1;
(statearr_75283_75377[(2)] = null);

(statearr_75283_75377[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (48))){
var inst_75222 = (state_75269[(2)]);
var state_75269__$1 = state_75269;
if(cljs.core.truth_(inst_75222)){
var statearr_75284_75378 = state_75269__$1;
(statearr_75284_75378[(1)] = (52));

} else {
var statearr_75285_75379 = state_75269__$1;
(statearr_75285_75379[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (50))){
var inst_75162 = (state_75269[(8)]);
var inst_75218 = (inst_75162 == null);
var state_75269__$1 = state_75269;
var statearr_75286_75380 = state_75269__$1;
(statearr_75286_75380[(2)] = inst_75218);

(statearr_75286_75380[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (21))){
var inst_75162 = (state_75269[(8)]);
var inst_75170 = cljs.core.list_QMARK_(inst_75162);
var state_75269__$1 = state_75269;
if(inst_75170){
var statearr_75287_75381 = state_75269__$1;
(statearr_75287_75381[(1)] = (24));

} else {
var statearr_75288_75382 = state_75269__$1;
(statearr_75288_75382[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (31))){
var inst_75162 = (state_75269[(8)]);
var state_75269__$1 = state_75269;
var statearr_75289_75383 = state_75269__$1;
(statearr_75289_75383[(2)] = inst_75162);

(statearr_75289_75383[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (32))){
var inst_75162 = (state_75269[(8)]);
var inst_75183 = (inst_75162 instanceof cljs.core.Symbol);
var state_75269__$1 = state_75269;
if(cljs.core.truth_(inst_75183)){
var statearr_75290_75384 = state_75269__$1;
(statearr_75290_75384[(1)] = (34));

} else {
var statearr_75291_75385 = state_75269__$1;
(statearr_75291_75385[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (40))){
var inst_75192 = (state_75269[(16)]);
var state_75269__$1 = state_75269;
var statearr_75292_75386 = state_75269__$1;
(statearr_75292_75386[(2)] = inst_75192);

(statearr_75292_75386[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (56))){
var state_75269__$1 = state_75269;
var statearr_75293_75387 = state_75269__$1;
(statearr_75293_75387[(1)] = (59));



return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (33))){
var inst_75250 = (state_75269[(2)]);
var state_75269__$1 = state_75269;
var statearr_75295_75388 = state_75269__$1;
(statearr_75295_75388[(2)] = inst_75250);

(statearr_75295_75388[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (13))){
var inst_75115 = (state_75269[(17)]);
var inst_75127 = (state_75269[(18)]);
var inst_75113 = (state_75269[(7)]);
var inst_75137 = ["Incorrect arity for function ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75113),". Expected ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75127),", provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75115),"."].join('');
var inst_75138 = cljs.core.PersistentHashMap.EMPTY;
var inst_75139 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75137,inst_75138);
var inst_75140 = (function(){throw inst_75139})();
var state_75269__$1 = state_75269;
var statearr_75296_75389 = state_75269__$1;
(statearr_75296_75389[(2)] = inst_75140);

(statearr_75296_75389[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (22))){
var inst_75156 = (state_75269[(11)]);
var state_75269__$1 = state_75269;
var statearr_75297_75390 = state_75269__$1;
(statearr_75297_75390[(2)] = inst_75156);

(statearr_75297_75390[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (36))){
var inst_75248 = (state_75269[(2)]);
var state_75269__$1 = state_75269;
var statearr_75298_75391 = state_75269__$1;
(statearr_75298_75391[(2)] = inst_75248);

(statearr_75298_75391[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (41))){
var inst_75195 = (state_75269[(19)]);
var inst_75195__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_75269__$1 = (function (){var statearr_75299 = state_75269;
(statearr_75299[(19)] = inst_75195__$1);

return statearr_75299;
})();
if(inst_75195__$1){
var statearr_75300_75392 = state_75269__$1;
(statearr_75300_75392[(1)] = (43));

} else {
var statearr_75301_75393 = state_75269__$1;
(statearr_75301_75393[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (43))){
var inst_75195 = (state_75269[(19)]);
var state_75269__$1 = state_75269;
var statearr_75302_75394 = state_75269__$1;
(statearr_75302_75394[(2)] = inst_75195);

(statearr_75302_75394[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (61))){
var inst_75242 = (state_75269[(2)]);
var state_75269__$1 = state_75269;
var statearr_75303_75395 = state_75269__$1;
(statearr_75303_75395[(2)] = inst_75242);

(statearr_75303_75395[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (29))){
var inst_75162 = (state_75269[(8)]);
var inst_75180 = typeof inst_75162 === 'number';
var state_75269__$1 = state_75269;
if(cljs.core.truth_(inst_75180)){
var statearr_75304_75396 = state_75269__$1;
(statearr_75304_75396[(1)] = (31));

} else {
var statearr_75305_75397 = state_75269__$1;
(statearr_75305_75397[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (44))){
var inst_75162 = (state_75269[(8)]);
var inst_75198 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_75199 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75162)," used in function argument: ",inst_75198].join('');
var inst_75200 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_75201 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_75202 = cljs.core.PersistentHashMap.fromArrays(inst_75200,inst_75201);
var inst_75203 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75199,inst_75202);
var inst_75204 = (function(){throw inst_75203})();
var state_75269__$1 = state_75269;
var statearr_75306_75398 = state_75269__$1;
(statearr_75306_75398[(2)] = inst_75204);

(statearr_75306_75398[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (6))){
var inst_75116 = (state_75269[(20)]);
var state_75269__$1 = state_75269;
var statearr_75307_75399 = state_75269__$1;
(statearr_75307_75399[(2)] = inst_75116);

(statearr_75307_75399[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (28))){
var inst_75162 = (state_75269[(8)]);
var state_75269__$1 = state_75269;
var statearr_75308_75400 = state_75269__$1;
(statearr_75308_75400[(2)] = inst_75162);

(statearr_75308_75400[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (51))){
var inst_75220 = (state_75269[(2)]);
var state_75269__$1 = state_75269;
var statearr_75309_75401 = state_75269__$1;
(statearr_75309_75401[(2)] = inst_75220);

(statearr_75309_75401[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (25))){
var inst_75162 = (state_75269[(8)]);
var inst_75177 = typeof inst_75162 === 'string';
var state_75269__$1 = state_75269;
if(cljs.core.truth_(inst_75177)){
var statearr_75310_75402 = state_75269__$1;
(statearr_75310_75402[(1)] = (28));

} else {
var statearr_75311_75403 = state_75269__$1;
(statearr_75311_75403[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (34))){
var inst_75185 = (state_75269[(21)]);
var inst_75162 = (state_75269[(8)]);
var inst_75185__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_75162) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_75162));
var state_75269__$1 = (function (){var statearr_75312 = state_75269;
(statearr_75312[(21)] = inst_75185__$1);

return statearr_75312;
})();
if(cljs.core.truth_(inst_75185__$1)){
var statearr_75313_75404 = state_75269__$1;
(statearr_75313_75404[(1)] = (37));

} else {
var statearr_75314_75405 = state_75269__$1;
(statearr_75314_75405[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (17))){
var inst_75126 = (state_75269[(22)]);
var inst_75261 = (state_75269[(2)]);
var inst_75262 = cljs.core.cst$sym$_QMARK_ctx;
var inst_75263 = cljs.core.cons(inst_75262,inst_75261);
var inst_75264 = cljs.core.cons(inst_75126,inst_75263);
var _ = (function (){var statearr_75315 = state_75269;
(statearr_75315[(4)] = cljs.core.rest((state_75269[(4)])));

return statearr_75315;
})();
var state_75269__$1 = state_75269;
var statearr_75316_75406 = state_75269__$1;
(statearr_75316_75406[(2)] = inst_75264);

(statearr_75316_75406[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (3))){
var inst_75267 = (state_75269[(2)]);
var state_75269__$1 = state_75269;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75269__$1,inst_75267);
} else {
if((state_val_75270 === (12))){
var inst_75134 = (state_75269[(2)]);
var inst_75135 = cljs.core.not(inst_75134);
var state_75269__$1 = state_75269;
if(inst_75135){
var statearr_75317_75407 = state_75269__$1;
(statearr_75317_75407[(1)] = (13));

} else {
var statearr_75318_75408 = state_75269__$1;
(statearr_75318_75408[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (2))){
var inst_75114 = (state_75269[(10)]);
var inst_75113 = (state_75269[(7)]);
var inst_75116 = (state_75269[(20)]);
var _ = (function (){var statearr_75319 = state_75269;
(statearr_75319[(4)] = cljs.core.cons((5),(state_75269[(4)])));

return statearr_75319;
})();
var inst_75113__$1 = cljs.core.first(form);
var inst_75114__$1 = cljs.core.rest(form);
var inst_75115 = cljs.core.count(inst_75114__$1);
var inst_75116__$1 = (fluree.db.dbfunctions.core.find_local_fn.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.find_local_fn.cljs$core$IFn$_invoke$arity$1(inst_75113__$1) : fluree.db.dbfunctions.core.find_local_fn.call(null,inst_75113__$1));
var state_75269__$1 = (function (){var statearr_75320 = state_75269;
(statearr_75320[(17)] = inst_75115);

(statearr_75320[(10)] = inst_75114__$1);

(statearr_75320[(7)] = inst_75113__$1);

(statearr_75320[(20)] = inst_75116__$1);

return statearr_75320;
})();
if(cljs.core.truth_(inst_75116__$1)){
var statearr_75321_75409 = state_75269__$1;
(statearr_75321_75409[(1)] = (6));

} else {
var statearr_75322_75410 = state_75269__$1;
(statearr_75322_75410[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (23))){
var inst_75259 = (state_75269[(2)]);
var state_75269__$1 = state_75269;
var statearr_75323_75411 = state_75269__$1;
(statearr_75323_75411[(2)] = inst_75259);

(statearr_75323_75411[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (47))){
var inst_75215 = (state_75269[(23)]);
var inst_75162 = (state_75269[(8)]);
var inst_75215__$1 = inst_75162 === false;
var state_75269__$1 = (function (){var statearr_75324 = state_75269;
(statearr_75324[(23)] = inst_75215__$1);

return statearr_75324;
})();
if(cljs.core.truth_(inst_75215__$1)){
var statearr_75325_75412 = state_75269__$1;
(statearr_75325_75412[(1)] = (49));

} else {
var statearr_75326_75413 = state_75269__$1;
(statearr_75326_75413[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (35))){
var inst_75212 = (state_75269[(9)]);
var inst_75162 = (state_75269[(8)]);
var inst_75212__$1 = inst_75162 === true;
var state_75269__$1 = (function (){var statearr_75327 = state_75269;
(statearr_75327[(9)] = inst_75212__$1);

return statearr_75327;
})();
if(cljs.core.truth_(inst_75212__$1)){
var statearr_75328_75414 = state_75269__$1;
(statearr_75328_75414[(1)] = (46));

} else {
var statearr_75329_75415 = state_75269__$1;
(statearr_75329_75415[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (19))){
var inst_75162 = (state_75269[(8)]);
var inst_75166 = inst_75162 === false;
var state_75269__$1 = state_75269;
var statearr_75330_75416 = state_75269__$1;
(statearr_75330_75416[(2)] = inst_75166);

(statearr_75330_75416[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (57))){
var inst_75244 = (state_75269[(2)]);
var state_75269__$1 = state_75269;
var statearr_75331_75417 = state_75269__$1;
(statearr_75331_75417[(2)] = inst_75244);

(statearr_75331_75417[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (11))){
var inst_75115 = (state_75269[(17)]);
var inst_75127 = (state_75269[(18)]);
var inst_75132 = (inst_75127.cljs$core$IFn$_invoke$arity$1 ? inst_75127.cljs$core$IFn$_invoke$arity$1(inst_75115) : inst_75127.call(null,inst_75115));
var state_75269__$1 = state_75269;
var statearr_75333_75418 = state_75269__$1;
(statearr_75333_75418[(2)] = inst_75132);

(statearr_75333_75418[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (9))){
var inst_75121 = (state_75269[(2)]);
var inst_75122 = fluree.db.util.async.throw_err(inst_75121);
var state_75269__$1 = state_75269;
var statearr_75334_75419 = state_75269__$1;
(statearr_75334_75419[(2)] = inst_75122);

(statearr_75334_75419[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (5))){
var _ = (function (){var statearr_75335 = state_75269;
(statearr_75335[(4)] = cljs.core.rest((state_75269[(4)])));

return statearr_75335;
})();
var state_75269__$1 = state_75269;
var ex75332 = (state_75269__$1[(2)]);
var statearr_75336_75420 = state_75269__$1;
(statearr_75336_75420[(5)] = ex75332);


if((ex75332 instanceof Error)){
var statearr_75337_75421 = state_75269__$1;
(statearr_75337_75421[(1)] = (4));

(statearr_75337_75421[(5)] = null);

} else {
throw ex75332;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (14))){
var state_75269__$1 = state_75269;
var statearr_75338_75422 = state_75269__$1;
(statearr_75338_75422[(2)] = null);

(statearr_75338_75422[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (45))){
var inst_75206 = (state_75269[(2)]);
var state_75269__$1 = state_75269;
var statearr_75339_75423 = state_75269__$1;
(statearr_75339_75423[(2)] = inst_75206);

(statearr_75339_75423[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (53))){
var inst_75162 = (state_75269[(8)]);
var inst_75225 = cljs.core.vector_QMARK_(inst_75162);
var state_75269__$1 = state_75269;
if(inst_75225){
var statearr_75340_75424 = state_75269__$1;
(statearr_75340_75424[(1)] = (55));

} else {
var statearr_75341_75425 = state_75269__$1;
(statearr_75341_75425[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (26))){
var inst_75156 = (state_75269[(11)]);
var inst_75163 = (state_75269[(24)]);
var inst_75254 = (state_75269[(2)]);
var inst_75255 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_75156,inst_75254);
var inst_75155 = inst_75163;
var inst_75156__$1 = inst_75255;
var state_75269__$1 = (function (){var statearr_75342 = state_75269;
(statearr_75342[(11)] = inst_75156__$1);

(statearr_75342[(14)] = inst_75155);

return statearr_75342;
})();
var statearr_75343_75426 = state_75269__$1;
(statearr_75343_75426[(2)] = null);

(statearr_75343_75426[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (16))){
var inst_75155 = (state_75269[(14)]);
var inst_75162 = (state_75269[(8)]);
var inst_75161 = cljs.core.seq(inst_75155);
var inst_75162__$1 = cljs.core.first(inst_75161);
var inst_75163 = cljs.core.next(inst_75161);
var state_75269__$1 = (function (){var statearr_75344 = state_75269;
(statearr_75344[(24)] = inst_75163);

(statearr_75344[(8)] = inst_75162__$1);

return statearr_75344;
})();
if(cljs.core.truth_(inst_75162__$1)){
var statearr_75345_75427 = state_75269__$1;
(statearr_75345_75427[(1)] = (18));

} else {
var statearr_75346_75428 = state_75269__$1;
(statearr_75346_75428[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (38))){
var inst_75156 = (state_75269[(11)]);
var inst_75126 = (state_75269[(22)]);
var inst_75192 = (state_75269[(16)]);
var inst_75125 = (state_75269[(25)]);
var inst_75115 = (state_75269[(17)]);
var inst_75143 = (state_75269[(12)]);
var inst_75114 = (state_75269[(10)]);
var inst_75127 = (state_75269[(18)]);
var inst_75113 = (state_75269[(7)]);
var inst_75129 = (state_75269[(26)]);
var inst_75185 = (state_75269[(21)]);
var inst_75124 = (state_75269[(27)]);
var inst_75128 = (state_75269[(28)]);
var inst_75152 = (state_75269[(13)]);
var inst_75155 = (state_75269[(14)]);
var inst_75163 = (state_75269[(24)]);
var inst_75153 = (state_75269[(15)]);
var inst_75162 = (state_75269[(8)]);
var inst_75188 = [inst_75162];
var inst_75189 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_75188);
var inst_75190 = (function (){var arity = inst_75127;
var args_n = inst_75115;
var vec__75148 = inst_75114;
var fn_map = inst_75124;
var or__5045__auto__ = inst_75185;
var args = inst_75114;
var r = inst_75163;
var map__75112 = inst_75125;
var seq__75149 = inst_75153;
var G__75147 = inst_75155;
var _ = inst_75143;
var acc = inst_75156;
var arglist = inst_75128;
var fn_name = inst_75113;
var seq__75159 = inst_75163;
var _AMPERSAND_args_QMARK_ = inst_75129;
var arg = inst_75162;
var first__75150 = inst_75152;
var first__75160 = inst_75162;
var vec__75158 = inst_75155;
var f = inst_75126;
return (function (p1__75103_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__75103_SHARP_);
});
})();
var inst_75191 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_75190,params);
var inst_75192__$1 = cljs.core.some(inst_75189,inst_75191);
var state_75269__$1 = (function (){var statearr_75347 = state_75269;
(statearr_75347[(16)] = inst_75192__$1);

return statearr_75347;
})();
if(cljs.core.truth_(inst_75192__$1)){
var statearr_75348_75429 = state_75269__$1;
(statearr_75348_75429[(1)] = (40));

} else {
var statearr_75349_75430 = state_75269__$1;
(statearr_75349_75430[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (30))){
var inst_75252 = (state_75269[(2)]);
var state_75269__$1 = state_75269;
var statearr_75350_75431 = state_75269__$1;
(statearr_75350_75431[(2)] = inst_75252);

(statearr_75350_75431[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (10))){
var inst_75129 = (state_75269[(26)]);
var state_75269__$1 = state_75269;
var statearr_75351_75432 = state_75269__$1;
(statearr_75351_75432[(2)] = inst_75129);

(statearr_75351_75432[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (18))){
var inst_75162 = (state_75269[(8)]);
var state_75269__$1 = state_75269;
var statearr_75352_75433 = state_75269__$1;
(statearr_75352_75433[(2)] = inst_75162);

(statearr_75352_75433[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (52))){
var inst_75162 = (state_75269[(8)]);
var state_75269__$1 = state_75269;
var statearr_75353_75434 = state_75269__$1;
(statearr_75353_75434[(2)] = inst_75162);

(statearr_75353_75434[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (42))){
var inst_75208 = (state_75269[(2)]);
var state_75269__$1 = state_75269;
var statearr_75354_75435 = state_75269__$1;
(statearr_75354_75435[(2)] = inst_75208);

(statearr_75354_75435[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (37))){
var inst_75185 = (state_75269[(21)]);
var state_75269__$1 = state_75269;
var statearr_75355_75436 = state_75269__$1;
(statearr_75355_75436[(2)] = inst_75185);

(statearr_75355_75436[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (8))){
var inst_75125 = (state_75269[(25)]);
var inst_75129 = (state_75269[(26)]);
var inst_75124 = (state_75269[(27)]);
var inst_75124__$1 = (state_75269[(2)]);
var inst_75125__$1 = cljs.core.__destructure_map(inst_75124__$1);
var inst_75126 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75125__$1,cljs.core.cst$kw$f);
var inst_75127 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75125__$1,cljs.core.cst$kw$arity);
var inst_75128 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75125__$1,cljs.core.cst$kw$arglist);
var inst_75129__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75125__$1,cljs.core.cst$kw$_AMPERSAND_args_QMARK_);
var state_75269__$1 = (function (){var statearr_75356 = state_75269;
(statearr_75356[(22)] = inst_75126);

(statearr_75356[(25)] = inst_75125__$1);

(statearr_75356[(18)] = inst_75127);

(statearr_75356[(26)] = inst_75129__$1);

(statearr_75356[(27)] = inst_75124__$1);

(statearr_75356[(28)] = inst_75128);

return statearr_75356;
})();
if(cljs.core.truth_(inst_75129__$1)){
var statearr_75357_75437 = state_75269__$1;
(statearr_75357_75437[(1)] = (10));

} else {
var statearr_75358_75438 = state_75269__$1;
(statearr_75358_75438[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75270 === (49))){
var inst_75215 = (state_75269[(23)]);
var state_75269__$1 = state_75269;
var statearr_75359_75439 = state_75269__$1;
(statearr_75359_75439[(2)] = inst_75215);

(statearr_75359_75439[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__15091__auto____0 = (function (){
var statearr_75360 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75360[(0)] = fluree$db$dbfunctions$core$state_machine__15091__auto__);

(statearr_75360[(1)] = (1));

return statearr_75360;
});
var fluree$db$dbfunctions$core$state_machine__15091__auto____1 = (function (state_75269){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_75269);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e75361){var ex__15094__auto__ = e75361;
var statearr_75362_75440 = state_75269;
(statearr_75362_75440[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_75269[(4)]))){
var statearr_75363_75441 = state_75269;
(statearr_75363_75441[(1)] = cljs.core.first((state_75269[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__75442 = state_75269;
state_75269 = G__75442;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__15091__auto__ = function(state_75269){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__15091__auto____1.call(this,state_75269);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__15091__auto____0;
fluree$db$dbfunctions$core$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__15091__auto____1;
return fluree$db$dbfunctions$core$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_75364 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_75364[(6)] = c__15165__auto__);

return statearr_75364;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$lang$maxFixedArity = 4);

fluree.db.dbfunctions.core.parse_fn = (function fluree$db$dbfunctions$core$parse_fn(var_args){
var G__75444 = arguments.length;
switch (G__75444) {
case 3:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_str,type){
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,fn_str,type,null);
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,fn_str,type,params){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_75526){
var state_val_75527 = (state_75526[(1)]);
if((state_val_75527 === (7))){
var inst_75454 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"false");
var state_75526__$1 = state_75526;
var statearr_75528_75576 = state_75526__$1;
(statearr_75528_75576[(2)] = inst_75454);

(statearr_75528_75576[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75527 === (20))){
var inst_75504 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_75526__$1 = state_75526;
var statearr_75529_75577 = state_75526__$1;
(statearr_75529_75577[(2)] = inst_75504);

(statearr_75529_75577[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75527 === (1))){
var state_75526__$1 = state_75526;
var statearr_75530_75578 = state_75526__$1;
(statearr_75530_75578[(2)] = null);

(statearr_75530_75578[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75527 === (24))){
var inst_75501 = (state_75526[(7)]);
var inst_75510 = cljs.core.eval(inst_75501);
var state_75526__$1 = state_75526;
var statearr_75532_75579 = state_75526__$1;
(statearr_75532_75579[(2)] = inst_75510);

(statearr_75532_75579[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75527 === (4))){
var inst_75445 = (state_75526[(2)]);
var state_75526__$1 = state_75526;
var statearr_75533_75580 = state_75526__$1;
(statearr_75533_75580[(2)] = inst_75445);

(statearr_75533_75580[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75527 === (15))){
var _ = (function (){var statearr_75534 = state_75526;
(statearr_75534[(4)] = cljs.core.rest((state_75526[(4)])));

return statearr_75534;
})();
var state_75526__$1 = state_75526;
var ex75531 = (state_75526__$1[(2)]);
var statearr_75535_75581 = state_75526__$1;
(statearr_75535_75581[(5)] = ex75531);


var statearr_75536_75582 = state_75526__$1;
(statearr_75536_75582[(1)] = (14));

(statearr_75536_75582[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_75527 === (21))){
var inst_75502 = (state_75526[(8)]);
var state_75526__$1 = state_75526;
var statearr_75537_75583 = state_75526__$1;
(statearr_75537_75583[(2)] = inst_75502);

(statearr_75537_75583[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75527 === (13))){
var inst_75519 = (state_75526[(2)]);
var state_75526__$1 = state_75526;
var statearr_75538_75584 = state_75526__$1;
(statearr_75538_75584[(2)] = inst_75519);

(statearr_75538_75584[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75527 === (22))){
var inst_75507 = (state_75526[(2)]);
var state_75526__$1 = state_75526;
if(cljs.core.truth_(inst_75507)){
var statearr_75539_75585 = state_75526__$1;
(statearr_75539_75585[(1)] = (23));

} else {
var statearr_75540_75586 = state_75526__$1;
(statearr_75540_75586[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75527 === (6))){
var inst_75451 = (state_75526[(9)]);
var state_75526__$1 = state_75526;
var statearr_75541_75587 = state_75526__$1;
(statearr_75541_75587[(2)] = inst_75451);

(statearr_75541_75587[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75527 === (25))){
var inst_75512 = (state_75526[(2)]);
var inst_75513 = [cljs.core.cst$kw$fnstr];
var inst_75514 = [fn_str];
var inst_75515 = cljs.core.PersistentHashMap.fromArrays(inst_75513,inst_75514);
var inst_75516 = cljs.core.with_meta(inst_75512,inst_75515);
var _ = (function (){var statearr_75542 = state_75526;
(statearr_75542[(4)] = cljs.core.rest((state_75526[(4)])));

return statearr_75542;
})();
var state_75526__$1 = state_75526;
var statearr_75543_75588 = state_75526__$1;
(statearr_75543_75588[(2)] = inst_75516);

(statearr_75543_75588[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75527 === (17))){
var inst_75477 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_75478 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_75479 = cljs.core.PersistentHashMap.fromArrays(inst_75477,inst_75478);
var inst_75480 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Bad function",inst_75479);
var inst_75481 = (function(){throw inst_75480})();
var state_75526__$1 = state_75526;
var statearr_75544_75589 = state_75526__$1;
(statearr_75544_75589[(2)] = inst_75481);

(statearr_75544_75589[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75527 === (3))){
var inst_75524 = (state_75526[(2)]);
var state_75526__$1 = state_75526;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75526__$1,inst_75524);
} else {
if((state_val_75527 === (12))){
var _ = (function (){var statearr_75545 = state_75526;
(statearr_75545[(4)] = cljs.core.cons((15),(state_75526[(4)])));

return statearr_75545;
})();
var inst_75474 = cljs.core.re_matches(/(^\(.+\)$)/,fn_str);
var state_75526__$1 = state_75526;
if(cljs.core.truth_(inst_75474)){
var statearr_75546_75590 = state_75526__$1;
(statearr_75546_75590[(1)] = (16));

} else {
var statearr_75547_75591 = state_75526__$1;
(statearr_75547_75591[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75527 === (2))){
var inst_75451 = (state_75526[(9)]);
var _ = (function (){var statearr_75548 = state_75526;
(statearr_75548[(4)] = cljs.core.cons((5),(state_75526[(4)])));

return statearr_75548;
})();
var inst_75451__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"true");
var state_75526__$1 = (function (){var statearr_75549 = state_75526;
(statearr_75549[(9)] = inst_75451__$1);

return statearr_75549;
})();
if(inst_75451__$1){
var statearr_75550_75592 = state_75526__$1;
(statearr_75550_75592[(1)] = (6));

} else {
var statearr_75551_75593 = state_75526__$1;
(statearr_75551_75593[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75527 === (23))){
var inst_75501 = (state_75526[(7)]);
var state_75526__$1 = state_75526;
var statearr_75552_75594 = state_75526__$1;
(statearr_75552_75594[(2)] = inst_75501);

(statearr_75552_75594[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75527 === (19))){
var inst_75502 = (state_75526[(8)]);
var inst_75487 = (state_75526[(2)]);
var inst_75488 = fluree.db.util.async.throw_err(inst_75487);
var inst_75489 = cljs.core.cst$sym$cljs$core_SLASH_fn;
var inst_75490 = (new cljs.core.List(null,inst_75489,null,(1),null));
var inst_75491 = cljs.core.cst$sym$_QMARK_ctx;
var inst_75492 = (new cljs.core.List(null,inst_75491,null,(1),null));
var inst_75493 = cljs.core.concat.cljs$core$IFn$_invoke$arity$1(inst_75492);
var inst_75494 = cljs.core.seq(inst_75493);
var inst_75495 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_75494);
var inst_75496 = cljs.core.vec(inst_75495);
var inst_75497 = (new cljs.core.List(null,inst_75496,null,(1),null));
var inst_75498 = (new cljs.core.List(null,inst_75488,null,(1),null));
var inst_75499 = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(inst_75490,inst_75497,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_75498], 0));
var inst_75500 = cljs.core.seq(inst_75499);
var inst_75501 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_75500);
var inst_75502__$1 = params;
var state_75526__$1 = (function (){var statearr_75553 = state_75526;
(statearr_75553[(7)] = inst_75501);

(statearr_75553[(8)] = inst_75502__$1);

return statearr_75553;
})();
if(cljs.core.truth_(inst_75502__$1)){
var statearr_75554_75595 = state_75526__$1;
(statearr_75554_75595[(1)] = (20));

} else {
var statearr_75555_75596 = state_75526__$1;
(statearr_75555_75596[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75527 === (11))){
var inst_75521 = (state_75526[(2)]);
var _ = (function (){var statearr_75557 = state_75526;
(statearr_75557[(4)] = cljs.core.rest((state_75526[(4)])));

return statearr_75557;
})();
var state_75526__$1 = state_75526;
var statearr_75558_75597 = state_75526__$1;
(statearr_75558_75597[(2)] = inst_75521);

(statearr_75558_75597[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75527 === (9))){
var inst_75458 = (function (){return (function (n){
return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
});
})();
var inst_75459 = fluree.db.dbfunctions.core.true_or_false = inst_75458;
var state_75526__$1 = state_75526;
var statearr_75559_75598 = state_75526__$1;
(statearr_75559_75598[(2)] = inst_75459);

(statearr_75559_75598[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75527 === (5))){
var _ = (function (){var statearr_75560 = state_75526;
(statearr_75560[(4)] = cljs.core.rest((state_75526[(4)])));

return statearr_75560;
})();
var state_75526__$1 = state_75526;
var ex75556 = (state_75526__$1[(2)]);
var statearr_75561_75599 = state_75526__$1;
(statearr_75561_75599[(5)] = ex75556);


if((ex75556 instanceof Error)){
var statearr_75562_75600 = state_75526__$1;
(statearr_75562_75600[(1)] = (4));

(statearr_75562_75600[(5)] = null);

} else {
throw ex75556;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75527 === (14))){
var inst_75461 = (state_75526[(2)]);
var inst_75462 = (function(){throw inst_75461})();
var inst_75463 = ["Error parsing function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str)].join('');
var inst_75464 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_75465 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_75466 = cljs.core.PersistentHashMap.fromArrays(inst_75464,inst_75465);
var inst_75467 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75463,inst_75466);
var inst_75468 = (function(){throw inst_75467})();
var state_75526__$1 = (function (){var statearr_75563 = state_75526;
(statearr_75563[(10)] = inst_75462);

return statearr_75563;
})();
var statearr_75564_75601 = state_75526__$1;
(statearr_75564_75601[(2)] = inst_75468);

(statearr_75564_75601[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75527 === (16))){
var state_75526__$1 = state_75526;
var statearr_75565_75602 = state_75526__$1;
(statearr_75565_75602[(2)] = null);

(statearr_75565_75602[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75527 === (10))){
var state_75526__$1 = state_75526;
var statearr_75566_75603 = state_75526__$1;
(statearr_75566_75603[(2)] = null);

(statearr_75566_75603[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75527 === (18))){
var inst_75483 = (state_75526[(2)]);
var inst_75484 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
var inst_75485 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_75484,type,params);
var state_75526__$1 = (function (){var statearr_75567 = state_75526;
(statearr_75567[(11)] = inst_75483);

return statearr_75567;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75526__$1,(19),inst_75485);
} else {
if((state_val_75527 === (8))){
var inst_75456 = (state_75526[(2)]);
var state_75526__$1 = state_75526;
if(cljs.core.truth_(inst_75456)){
var statearr_75568_75604 = state_75526__$1;
(statearr_75568_75604[(1)] = (9));

} else {
var statearr_75569_75605 = state_75526__$1;
(statearr_75569_75605[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__15091__auto____0 = (function (){
var statearr_75570 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75570[(0)] = fluree$db$dbfunctions$core$state_machine__15091__auto__);

(statearr_75570[(1)] = (1));

return statearr_75570;
});
var fluree$db$dbfunctions$core$state_machine__15091__auto____1 = (function (state_75526){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_75526);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e75571){var ex__15094__auto__ = e75571;
var statearr_75572_75606 = state_75526;
(statearr_75572_75606[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_75526[(4)]))){
var statearr_75573_75607 = state_75526;
(statearr_75573_75607[(1)] = cljs.core.first((state_75526[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__75608 = state_75526;
state_75526 = G__75608;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__15091__auto__ = function(state_75526){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__15091__auto____1.call(this,state_75526);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__15091__auto____0;
fluree$db$dbfunctions$core$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__15091__auto____1;
return fluree$db$dbfunctions$core$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_75574 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_75574[(6)] = c__15165__auto__);

return statearr_75574;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$lang$maxFixedArity = 4);

/**
 * Executes a transaction function
 */
fluree.db.dbfunctions.core.execute_tx_fn = (function fluree$db$dbfunctions$core$execute_tx_fn(db,auth_id,credits,s,p,o,fuel,block_instant){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_75636){
var state_val_75637 = (state_75636[(1)]);
if((state_val_75637 === (7))){
var inst_75623 = (state_75636[(7)]);
var state_75636__$1 = state_75636;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75636__$1,(10),inst_75623);
} else {
if((state_val_75637 === (1))){
var state_75636__$1 = state_75636;
var statearr_75638_75658 = state_75636__$1;
(statearr_75638_75658[(2)] = null);

(statearr_75638_75658[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75637 === (4))){
var inst_75609 = (state_75636[(2)]);
var state_75636__$1 = state_75636;
var statearr_75639_75659 = state_75636__$1;
(statearr_75639_75659[(2)] = inst_75609);

(statearr_75639_75659[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75637 === (6))){
var inst_75623 = (state_75636[(7)]);
var inst_75618 = (state_75636[(8)]);
var inst_75621 = (state_75636[(2)]);
var inst_75622 = fluree.db.util.async.throw_err(inst_75621);
var inst_75623__$1 = (inst_75622.cljs$core$IFn$_invoke$arity$1 ? inst_75622.cljs$core$IFn$_invoke$arity$1(inst_75618) : inst_75622.call(null,inst_75618));
var inst_75624 = fluree.db.util.async.channel_QMARK_(inst_75623__$1);
var state_75636__$1 = (function (){var statearr_75640 = state_75636;
(statearr_75640[(7)] = inst_75623__$1);

return statearr_75640;
})();
if(inst_75624){
var statearr_75641_75660 = state_75636__$1;
(statearr_75641_75660[(1)] = (7));

} else {
var statearr_75642_75661 = state_75636__$1;
(statearr_75642_75661[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75637 === (3))){
var inst_75634 = (state_75636[(2)]);
var state_75636__$1 = state_75636;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75636__$1,inst_75634);
} else {
if((state_val_75637 === (2))){
var _ = (function (){var statearr_75644 = state_75636;
(statearr_75644[(4)] = cljs.core.cons((5),(state_75636[(4)])));

return statearr_75644;
})();
var inst_75615 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(o,(1));
var inst_75616 = [cljs.core.cst$kw$db,cljs.core.cst$kw$instant,cljs.core.cst$kw$sid,cljs.core.cst$kw$pid,cljs.core.cst$kw$auth_id,cljs.core.cst$kw$state];
var inst_75617 = [db,block_instant,s,p,auth_id,fuel];
var inst_75618 = cljs.core.PersistentHashMap.fromArrays(inst_75616,inst_75617);
var inst_75619 = fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,inst_75615,"txn",null);
var state_75636__$1 = (function (){var statearr_75645 = state_75636;
(statearr_75645[(8)] = inst_75618);

return statearr_75645;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75636__$1,(6),inst_75619);
} else {
if((state_val_75637 === (9))){
var inst_75631 = (state_75636[(2)]);
var _ = (function (){var statearr_75646 = state_75636;
(statearr_75646[(4)] = cljs.core.rest((state_75636[(4)])));

return statearr_75646;
})();
var state_75636__$1 = state_75636;
var statearr_75647_75662 = state_75636__$1;
(statearr_75647_75662[(2)] = inst_75631);

(statearr_75647_75662[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75637 === (5))){
var _ = (function (){var statearr_75648 = state_75636;
(statearr_75648[(4)] = cljs.core.rest((state_75636[(4)])));

return statearr_75648;
})();
var state_75636__$1 = state_75636;
var ex75643 = (state_75636__$1[(2)]);
var statearr_75649_75663 = state_75636__$1;
(statearr_75649_75663[(5)] = ex75643);


if((ex75643 instanceof Error)){
var statearr_75650_75664 = state_75636__$1;
(statearr_75650_75664[(1)] = (4));

(statearr_75650_75664[(5)] = null);

} else {
throw ex75643;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75637 === (10))){
var inst_75627 = (state_75636[(2)]);
var inst_75628 = fluree.db.util.async.throw_err(inst_75627);
var state_75636__$1 = state_75636;
var statearr_75651_75665 = state_75636__$1;
(statearr_75651_75665[(2)] = inst_75628);

(statearr_75651_75665[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75637 === (8))){
var inst_75623 = (state_75636[(7)]);
var state_75636__$1 = state_75636;
var statearr_75652_75666 = state_75636__$1;
(statearr_75652_75666[(2)] = inst_75623);

(statearr_75652_75666[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__15091__auto____0 = (function (){
var statearr_75653 = [null,null,null,null,null,null,null,null,null];
(statearr_75653[(0)] = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__15091__auto__);

(statearr_75653[(1)] = (1));

return statearr_75653;
});
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__15091__auto____1 = (function (state_75636){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_75636);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e75654){var ex__15094__auto__ = e75654;
var statearr_75655_75667 = state_75636;
(statearr_75655_75667[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_75636[(4)]))){
var statearr_75656_75668 = state_75636;
(statearr_75656_75668[(1)] = cljs.core.first((state_75636[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__75669 = state_75636;
state_75636 = G__75669;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__15091__auto__ = function(state_75636){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__15091__auto____1.call(this,state_75636);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_75657 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_75657[(6)] = c__15165__auto__);

return statearr_75657;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
