// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__5823__auto___70899 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$if,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$util$async_SLASH_channel_QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_70950){
var state_val_70951 = (state_70950[(1)]);
if((state_val_70951 === (7))){
var inst_70945 = (state_70950[(2)]);
var _ = (function (){var statearr_70952 = state_70950;
(statearr_70952[(4)] = cljs.core.rest((state_70950[(4)])));

return statearr_70952;
})();
var state_70950__$1 = state_70950;
var statearr_70953_70980 = state_70950__$1;
(statearr_70953_70980[(2)] = inst_70945);

(statearr_70953_70980[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70951 === (1))){
var state_70950__$1 = state_70950;
var statearr_70954_70981 = state_70950__$1;
(statearr_70954_70981[(2)] = null);

(statearr_70954_70981[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70951 === (4))){
var inst_70900 = (state_70950[(2)]);
var state_70950__$1 = state_70950;
var statearr_70955_70982 = state_70950__$1;
(statearr_70955_70982[(2)] = inst_70900);

(statearr_70955_70982[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70951 === (13))){
var inst_70941 = (state_70950[(2)]);
var state_70950__$1 = state_70950;
var statearr_70956_70983 = state_70950__$1;
(statearr_70956_70983[(2)] = inst_70941);

(statearr_70956_70983[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70951 === (6))){
var inst_70925 = (state_70950[(7)]);
var inst_70918 = (state_70950[(8)]);
var inst_70924 = cljs.core.seq(inst_70918);
var inst_70925__$1 = cljs.core.first(inst_70924);
var inst_70926 = cljs.core.next(inst_70924);
var inst_70927 = cljs.core.not(inst_70925__$1);
var state_70950__$1 = (function (){var statearr_70957 = state_70950;
(statearr_70957[(7)] = inst_70925__$1);

(statearr_70957[(9)] = inst_70926);

return statearr_70957;
})();
if(inst_70927){
var statearr_70958_70984 = state_70950__$1;
(statearr_70958_70984[(1)] = (8));

} else {
var statearr_70959_70985 = state_70950__$1;
(statearr_70959_70985[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70951 === (3))){
var inst_70948 = (state_70950[(2)]);
var state_70950__$1 = state_70950;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70950__$1,inst_70948);
} else {
if((state_val_70951 === (12))){
var inst_70925 = (state_70950[(7)]);
var inst_70919 = (state_70950[(10)]);
var inst_70926 = (state_70950[(9)]);
var inst_70938 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_70919,inst_70925);
var inst_70918 = inst_70926;
var inst_70919__$1 = inst_70938;
var state_70950__$1 = (function (){var statearr_70960 = state_70950;
(statearr_70960[(8)] = inst_70918);

(statearr_70960[(10)] = inst_70919__$1);

return statearr_70960;
})();
var statearr_70961_70986 = state_70950__$1;
(statearr_70961_70986[(2)] = null);

(statearr_70961_70986[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70951 === (2))){
var _ = (function (){var statearr_70962 = state_70950;
(statearr_70962[(4)] = cljs.core.cons((5),(state_70950[(4)])));

return statearr_70962;
})();
var inst_70913 = args;
var inst_70914 = cljs.core.seq(inst_70913);
var inst_70915 = cljs.core.first(inst_70914);
var inst_70916 = cljs.core.next(inst_70914);
var inst_70917 = cljs.core.PersistentVector.EMPTY;
var inst_70918 = inst_70913;
var inst_70919 = inst_70917;
var state_70950__$1 = (function (){var statearr_70963 = state_70950;
(statearr_70963[(8)] = inst_70918);

(statearr_70963[(11)] = inst_70916);

(statearr_70963[(12)] = inst_70915);

(statearr_70963[(10)] = inst_70919);

return statearr_70963;
})();
var statearr_70964_70987 = state_70950__$1;
(statearr_70964_70987[(2)] = null);

(statearr_70964_70987[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70951 === (11))){
var inst_70925 = (state_70950[(7)]);
var state_70950__$1 = state_70950;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70950__$1,(14),inst_70925);
} else {
if((state_val_70951 === (9))){
var inst_70925 = (state_70950[(7)]);
var inst_70930 = fluree.db.util.async.channel_QMARK_(inst_70925);
var state_70950__$1 = state_70950;
if(inst_70930){
var statearr_70966_70988 = state_70950__$1;
(statearr_70966_70988[(1)] = (11));

} else {
var statearr_70967_70989 = state_70950__$1;
(statearr_70967_70989[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70951 === (5))){
var _ = (function (){var statearr_70968 = state_70950;
(statearr_70968[(4)] = cljs.core.rest((state_70950[(4)])));

return statearr_70968;
})();
var state_70950__$1 = state_70950;
var ex70965 = (state_70950__$1[(2)]);
var statearr_70969_70990 = state_70950__$1;
(statearr_70969_70990[(5)] = ex70965);


if((ex70965 instanceof Error)){
var statearr_70970_70991 = state_70950__$1;
(statearr_70970_70991[(1)] = (4));

(statearr_70970_70991[(5)] = null);

} else {
throw ex70965;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70951 === (14))){
var inst_70919 = (state_70950[(10)]);
var inst_70926 = (state_70950[(9)]);
var inst_70933 = (state_70950[(2)]);
var inst_70934 = fluree.db.util.async.throw_err(inst_70933);
var inst_70935 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_70919,inst_70934);
var inst_70918 = inst_70926;
var inst_70919__$1 = inst_70935;
var state_70950__$1 = (function (){var statearr_70971 = state_70950;
(statearr_70971[(8)] = inst_70918);

(statearr_70971[(10)] = inst_70919__$1);

return statearr_70971;
})();
var statearr_70972_70992 = state_70950__$1;
(statearr_70972_70992[(2)] = null);

(statearr_70972_70992[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70951 === (10))){
var inst_70943 = (state_70950[(2)]);
var state_70950__$1 = state_70950;
var statearr_70973_70993 = state_70950__$1;
(statearr_70973_70993[(2)] = inst_70943);

(statearr_70973_70993[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70951 === (8))){
var inst_70919 = (state_70950[(10)]);
var state_70950__$1 = state_70950;
var statearr_70974_70994 = state_70950__$1;
(statearr_70974_70994[(2)] = inst_70919);

(statearr_70974_70994[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__15091__auto____0 = (function (){
var statearr_70975 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70975[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__15091__auto__);

(statearr_70975[(1)] = (1));

return statearr_70975;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__15091__auto____1 = (function (state_70950){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_70950);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e70976){var ex__15094__auto__ = e70976;
var statearr_70977_70995 = state_70950;
(statearr_70977_70995[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_70950[(4)]))){
var statearr_70978_70996 = state_70950;
(statearr_70978_70996[(1)] = cljs.core.first((state_70950[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__70997 = state_70950;
state_70950 = G__70997;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__15091__auto__ = function(state_70950){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__15091__auto____1.call(this,state_70950);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_70979 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_70979[(6)] = c__15165__auto__);

return statearr_70979;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__70998 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70998,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70998,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,cljs.core.cst$kw$stack,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits,fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits.cljs$core$IFn$_invoke$arity$1(s),cost], 0)),cljs.core.cst$kw$spent,fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$spent.cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn,cljs.core.cst$kw$stack,fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_71046){
var state_val_71047 = (state_71046[(1)]);
if((state_val_71047 === (7))){
var state_71046__$1 = state_71046;
var statearr_71048_71077 = state_71046__$1;
(statearr_71048_71077[(2)] = coll);

(statearr_71048_71077[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71047 === (1))){
var state_71046__$1 = state_71046;
var statearr_71049_71078 = state_71046__$1;
(statearr_71049_71078[(2)] = null);

(statearr_71049_71078[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71047 === (4))){
var inst_71001 = (state_71046[(2)]);
var state_71046__$1 = state_71046;
var statearr_71050_71079 = state_71046__$1;
(statearr_71050_71079[(2)] = inst_71001);

(statearr_71050_71079[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71047 === (15))){
var inst_71020 = (state_71046[(7)]);
var inst_71028 = (state_71046[(2)]);
var inst_71029 = fluree.db.dbfunctions.internal.nth(inst_71020,inst_71028);
var inst_71030 = cljs.core.count(inst_71020);
var inst_71031 = ((9) + inst_71030);
var inst_71032 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71033 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71034 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71035 = [inst_71020,inst_71028];
var inst_71036 = (new cljs.core.PersistentVector(null,2,(5),inst_71034,inst_71035,null));
var inst_71037 = ["nth",inst_71036,inst_71029];
var inst_71038 = cljs.core.PersistentHashMap.fromArrays(inst_71033,inst_71037);
var inst_71039 = [inst_71038,inst_71031];
var inst_71040 = (new cljs.core.PersistentVector(null,2,(5),inst_71032,inst_71039,null));
var inst_71041 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71040);
var _ = (function (){var statearr_71051 = state_71046;
(statearr_71051[(4)] = cljs.core.rest((state_71046[(4)])));

return statearr_71051;
})();
var state_71046__$1 = (function (){var statearr_71052 = state_71046;
(statearr_71052[(8)] = inst_71041);

return statearr_71052;
})();
var statearr_71053_71080 = state_71046__$1;
(statearr_71053_71080[(2)] = inst_71029);

(statearr_71053_71080[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71047 === (13))){
var state_71046__$1 = state_71046;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71046__$1,(16),key);
} else {
if((state_val_71047 === (6))){
var state_71046__$1 = state_71046;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71046__$1,(9),coll);
} else {
if((state_val_71047 === (3))){
var inst_71044 = (state_71046[(2)]);
var state_71046__$1 = state_71046;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71046__$1,inst_71044);
} else {
if((state_val_71047 === (12))){
var inst_71020 = (state_71046[(2)]);
var inst_71021 = fluree.db.util.async.channel_QMARK_(key);
var state_71046__$1 = (function (){var statearr_71054 = state_71046;
(statearr_71054[(7)] = inst_71020);

return statearr_71054;
})();
if(inst_71021){
var statearr_71055_71081 = state_71046__$1;
(statearr_71055_71081[(1)] = (13));

} else {
var statearr_71056_71082 = state_71046__$1;
(statearr_71056_71082[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71047 === (2))){
var _ = (function (){var statearr_71057 = state_71046;
(statearr_71057[(4)] = cljs.core.cons((5),(state_71046[(4)])));

return statearr_71057;
})();
var inst_71007 = fluree.db.util.async.channel_QMARK_(coll);
var state_71046__$1 = state_71046;
if(inst_71007){
var statearr_71058_71083 = state_71046__$1;
(statearr_71058_71083[(1)] = (6));

} else {
var statearr_71059_71084 = state_71046__$1;
(statearr_71059_71084[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71047 === (11))){
var inst_71014 = (state_71046[(9)]);
var state_71046__$1 = state_71046;
var statearr_71061_71085 = state_71046__$1;
(statearr_71061_71085[(2)] = inst_71014);

(statearr_71061_71085[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71047 === (9))){
var inst_71010 = (state_71046[(2)]);
var inst_71011 = fluree.db.util.async.throw_err(inst_71010);
var state_71046__$1 = state_71046;
var statearr_71062_71086 = state_71046__$1;
(statearr_71062_71086[(2)] = inst_71011);

(statearr_71062_71086[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71047 === (5))){
var _ = (function (){var statearr_71063 = state_71046;
(statearr_71063[(4)] = cljs.core.rest((state_71046[(4)])));

return statearr_71063;
})();
var state_71046__$1 = state_71046;
var ex71060 = (state_71046__$1[(2)]);
var statearr_71064_71087 = state_71046__$1;
(statearr_71064_71087[(5)] = ex71060);


if((ex71060 instanceof Error)){
var statearr_71065_71088 = state_71046__$1;
(statearr_71065_71088[(1)] = (4));

(statearr_71065_71088[(5)] = null);

} else {
throw ex71060;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71047 === (14))){
var state_71046__$1 = state_71046;
var statearr_71066_71089 = state_71046__$1;
(statearr_71066_71089[(2)] = key);

(statearr_71066_71089[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71047 === (16))){
var inst_71024 = (state_71046[(2)]);
var inst_71025 = fluree.db.util.async.throw_err(inst_71024);
var state_71046__$1 = state_71046;
var statearr_71067_71090 = state_71046__$1;
(statearr_71067_71090[(2)] = inst_71025);

(statearr_71067_71090[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71047 === (10))){
var inst_71014 = (state_71046[(9)]);
var inst_71017 = cljs.core.vec(inst_71014);
var state_71046__$1 = state_71046;
var statearr_71068_71091 = state_71046__$1;
(statearr_71068_71091[(2)] = inst_71017);

(statearr_71068_71091[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71047 === (8))){
var inst_71014 = (state_71046[(9)]);
var inst_71014__$1 = (state_71046[(2)]);
var inst_71015 = cljs.core.set_QMARK_(inst_71014__$1);
var state_71046__$1 = (function (){var statearr_71069 = state_71046;
(statearr_71069[(9)] = inst_71014__$1);

return statearr_71069;
})();
if(inst_71015){
var statearr_71070_71092 = state_71046__$1;
(statearr_71070_71092[(1)] = (10));

} else {
var statearr_71071_71093 = state_71046__$1;
(statearr_71071_71093[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__15091__auto____0 = (function (){
var statearr_71072 = [null,null,null,null,null,null,null,null,null,null];
(statearr_71072[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__15091__auto__);

(statearr_71072[(1)] = (1));

return statearr_71072;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__15091__auto____1 = (function (state_71046){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_71046);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e71073){var ex__15094__auto__ = e71073;
var statearr_71074_71094 = state_71046;
(statearr_71074_71094[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_71046[(4)]))){
var statearr_71075_71095 = state_71046;
(statearr_71075_71095[(1)] = cljs.core.first((state_71046[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__71096 = state_71046;
state_71046 = G__71096;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__15091__auto__ = function(state_71046){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__15091__auto____1.call(this,state_71046);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_71076 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_71076[(6)] = c__15165__auto__);

return statearr_71076;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_71157){
var state_val_71158 = (state_71157[(1)]);
if((state_val_71158 === (7))){
var state_71157__$1 = state_71157;
var statearr_71159_71193 = state_71157__$1;
(statearr_71159_71193[(2)] = test);

(statearr_71159_71193[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71158 === (20))){
var inst_71131 = (state_71157[(2)]);
var inst_71132 = fluree.db.util.async.throw_err(inst_71131);
var state_71157__$1 = state_71157;
var statearr_71160_71194 = state_71157__$1;
(statearr_71160_71194[(2)] = inst_71132);

(statearr_71160_71194[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71158 === (1))){
var state_71157__$1 = state_71157;
var statearr_71161_71195 = state_71157__$1;
(statearr_71161_71195[(2)] = null);

(statearr_71161_71195[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71158 === (4))){
var inst_71097 = (state_71157[(2)]);
var state_71157__$1 = state_71157;
var statearr_71162_71196 = state_71157__$1;
(statearr_71162_71196[(2)] = inst_71097);

(statearr_71162_71196[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71158 === (15))){
var inst_71115 = (state_71157[(7)]);
var inst_71123 = (state_71157[(2)]);
var inst_71124 = [inst_71123,f];
var inst_71125 = (new cljs.core.PersistentVector(null,2,(5),inst_71115,inst_71124,null));
var state_71157__$1 = state_71157;
var statearr_71163_71197 = state_71157__$1;
(statearr_71163_71197[(2)] = inst_71125);

(statearr_71163_71197[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71158 === (13))){
var state_71157__$1 = state_71157;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71157__$1,(16),t);
} else {
if((state_val_71158 === (6))){
var state_71157__$1 = state_71157;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71157__$1,(9),test);
} else {
if((state_val_71158 === (17))){
var state_71157__$1 = state_71157;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71157__$1,(20),f);
} else {
if((state_val_71158 === (3))){
var inst_71155 = (state_71157[(2)]);
var state_71157__$1 = state_71157;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71157__$1,inst_71155);
} else {
if((state_val_71158 === (12))){
var inst_71113 = (state_71157[(8)]);
var inst_71139 = (state_71157[(2)]);
var inst_71140 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71139,(0),null);
var inst_71141 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71139,(1),null);
var inst_71142 = fluree.db.dbfunctions.internal.if_else(inst_71113,inst_71140,inst_71141);
var inst_71143 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71144 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71145 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71146 = [inst_71113,inst_71140,inst_71141];
var inst_71147 = (new cljs.core.PersistentVector(null,3,(5),inst_71145,inst_71146,null));
var inst_71148 = ["if-else",inst_71147,inst_71142];
var inst_71149 = cljs.core.PersistentHashMap.fromArrays(inst_71144,inst_71148);
var inst_71150 = [inst_71149,(10)];
var inst_71151 = (new cljs.core.PersistentVector(null,2,(5),inst_71143,inst_71150,null));
var inst_71152 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71151);
var _ = (function (){var statearr_71164 = state_71157;
(statearr_71164[(4)] = cljs.core.rest((state_71157[(4)])));

return statearr_71164;
})();
var state_71157__$1 = (function (){var statearr_71165 = state_71157;
(statearr_71165[(9)] = inst_71152);

return statearr_71165;
})();
var statearr_71166_71198 = state_71157__$1;
(statearr_71166_71198[(2)] = inst_71142);

(statearr_71166_71198[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71158 === (2))){
var _ = (function (){var statearr_71167 = state_71157;
(statearr_71167[(4)] = cljs.core.cons((5),(state_71157[(4)])));

return statearr_71167;
})();
var inst_71106 = fluree.db.util.async.channel_QMARK_(test);
var state_71157__$1 = state_71157;
if(inst_71106){
var statearr_71168_71199 = state_71157__$1;
(statearr_71168_71199[(1)] = (6));

} else {
var statearr_71169_71200 = state_71157__$1;
(statearr_71169_71200[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71158 === (19))){
var inst_71127 = (state_71157[(10)]);
var inst_71135 = (state_71157[(2)]);
var inst_71136 = [f,inst_71135];
var inst_71137 = (new cljs.core.PersistentVector(null,2,(5),inst_71127,inst_71136,null));
var state_71157__$1 = state_71157;
var statearr_71170_71201 = state_71157__$1;
(statearr_71170_71201[(2)] = inst_71137);

(statearr_71170_71201[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71158 === (11))){
var inst_71127 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71128 = fluree.db.util.async.channel_QMARK_(f);
var state_71157__$1 = (function (){var statearr_71172 = state_71157;
(statearr_71172[(10)] = inst_71127);

return statearr_71172;
})();
if(inst_71128){
var statearr_71173_71202 = state_71157__$1;
(statearr_71173_71202[(1)] = (17));

} else {
var statearr_71174_71203 = state_71157__$1;
(statearr_71174_71203[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71158 === (9))){
var inst_71109 = (state_71157[(2)]);
var inst_71110 = fluree.db.util.async.throw_err(inst_71109);
var state_71157__$1 = state_71157;
var statearr_71175_71204 = state_71157__$1;
(statearr_71175_71204[(2)] = inst_71110);

(statearr_71175_71204[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71158 === (5))){
var _ = (function (){var statearr_71176 = state_71157;
(statearr_71176[(4)] = cljs.core.rest((state_71157[(4)])));

return statearr_71176;
})();
var state_71157__$1 = state_71157;
var ex71171 = (state_71157__$1[(2)]);
var statearr_71177_71205 = state_71157__$1;
(statearr_71177_71205[(5)] = ex71171);


if((ex71171 instanceof Error)){
var statearr_71178_71206 = state_71157__$1;
(statearr_71178_71206[(1)] = (4));

(statearr_71178_71206[(5)] = null);

} else {
throw ex71171;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71158 === (14))){
var state_71157__$1 = state_71157;
var statearr_71179_71207 = state_71157__$1;
(statearr_71179_71207[(2)] = t);

(statearr_71179_71207[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71158 === (16))){
var inst_71119 = (state_71157[(2)]);
var inst_71120 = fluree.db.util.async.throw_err(inst_71119);
var state_71157__$1 = state_71157;
var statearr_71180_71208 = state_71157__$1;
(statearr_71180_71208[(2)] = inst_71120);

(statearr_71180_71208[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71158 === (10))){
var inst_71115 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71116 = fluree.db.util.async.channel_QMARK_(t);
var state_71157__$1 = (function (){var statearr_71181 = state_71157;
(statearr_71181[(7)] = inst_71115);

return statearr_71181;
})();
if(inst_71116){
var statearr_71182_71209 = state_71157__$1;
(statearr_71182_71209[(1)] = (13));

} else {
var statearr_71183_71210 = state_71157__$1;
(statearr_71183_71210[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71158 === (18))){
var state_71157__$1 = state_71157;
var statearr_71184_71211 = state_71157__$1;
(statearr_71184_71211[(2)] = f);

(statearr_71184_71211[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71158 === (8))){
var inst_71113 = (state_71157[(8)]);
var inst_71113__$1 = (state_71157[(2)]);
var state_71157__$1 = (function (){var statearr_71185 = state_71157;
(statearr_71185[(8)] = inst_71113__$1);

return statearr_71185;
})();
if(cljs.core.truth_(inst_71113__$1)){
var statearr_71186_71212 = state_71157__$1;
(statearr_71186_71212[(1)] = (10));

} else {
var statearr_71187_71213 = state_71157__$1;
(statearr_71187_71213[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__15091__auto____0 = (function (){
var statearr_71188 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_71188[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__15091__auto__);

(statearr_71188[(1)] = (1));

return statearr_71188;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__15091__auto____1 = (function (state_71157){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_71157);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e71189){var ex__15094__auto__ = e71189;
var statearr_71190_71214 = state_71157;
(statearr_71190_71214[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_71157[(4)]))){
var statearr_71191_71215 = state_71157;
(statearr_71191_71215[(1)] = cljs.core.first((state_71157[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__71216 = state_71157;
state_71157 = G__71216;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__15091__auto__ = function(state_71157){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__15091__auto____1.call(this,state_71157);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_71192 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_71192[(6)] = c__15165__auto__);

return statearr_71192;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_71246){
var state_val_71247 = (state_71246[(1)]);
if((state_val_71247 === (7))){
var state_71246__$1 = state_71246;
var statearr_71248_71267 = state_71246__$1;
(statearr_71248_71267[(2)] = arg);

(statearr_71248_71267[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71247 === (1))){
var state_71246__$1 = state_71246;
var statearr_71249_71268 = state_71246__$1;
(statearr_71249_71268[(2)] = null);

(statearr_71249_71268[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71247 === (4))){
var inst_71217 = (state_71246[(2)]);
var state_71246__$1 = state_71246;
var statearr_71250_71269 = state_71246__$1;
(statearr_71250_71269[(2)] = inst_71217);

(statearr_71250_71269[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71247 === (6))){
var state_71246__$1 = state_71246;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71246__$1,(9),arg);
} else {
if((state_val_71247 === (3))){
var inst_71244 = (state_71246[(2)]);
var state_71246__$1 = state_71246;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71246__$1,inst_71244);
} else {
if((state_val_71247 === (2))){
var _ = (function (){var statearr_71252 = state_71246;
(statearr_71252[(4)] = cljs.core.cons((5),(state_71246[(4)])));

return statearr_71252;
})();
var inst_71223 = fluree.db.util.async.channel_QMARK_(arg);
var state_71246__$1 = state_71246;
if(inst_71223){
var statearr_71253_71270 = state_71246__$1;
(statearr_71253_71270[(1)] = (6));

} else {
var statearr_71254_71271 = state_71246__$1;
(statearr_71254_71271[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71247 === (9))){
var inst_71226 = (state_71246[(2)]);
var inst_71227 = fluree.db.util.async.throw_err(inst_71226);
var state_71246__$1 = state_71246;
var statearr_71255_71272 = state_71246__$1;
(statearr_71255_71272[(2)] = inst_71227);

(statearr_71255_71272[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71247 === (5))){
var _ = (function (){var statearr_71256 = state_71246;
(statearr_71256[(4)] = cljs.core.rest((state_71246[(4)])));

return statearr_71256;
})();
var state_71246__$1 = state_71246;
var ex71251 = (state_71246__$1[(2)]);
var statearr_71257_71273 = state_71246__$1;
(statearr_71257_71273[(5)] = ex71251);


if((ex71251 instanceof Error)){
var statearr_71258_71274 = state_71246__$1;
(statearr_71258_71274[(1)] = (4));

(statearr_71258_71274[(5)] = null);

} else {
throw ex71251;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71247 === (8))){
var inst_71230 = (state_71246[(2)]);
var inst_71231 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_71230);
var inst_71232 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71233 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71234 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71235 = [inst_71230];
var inst_71236 = (new cljs.core.PersistentVector(null,1,(5),inst_71234,inst_71235,null));
var inst_71237 = ["nil?",inst_71236,inst_71231];
var inst_71238 = cljs.core.PersistentHashMap.fromArrays(inst_71233,inst_71237);
var inst_71239 = [inst_71238,(10)];
var inst_71240 = (new cljs.core.PersistentVector(null,2,(5),inst_71232,inst_71239,null));
var inst_71241 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71240);
var _ = (function (){var statearr_71259 = state_71246;
(statearr_71259[(4)] = cljs.core.rest((state_71246[(4)])));

return statearr_71259;
})();
var state_71246__$1 = (function (){var statearr_71260 = state_71246;
(statearr_71260[(7)] = inst_71241);

return statearr_71260;
})();
var statearr_71261_71275 = state_71246__$1;
(statearr_71261_71275[(2)] = inst_71231);

(statearr_71261_71275[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__15091__auto____0 = (function (){
var statearr_71262 = [null,null,null,null,null,null,null,null];
(statearr_71262[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__15091__auto__);

(statearr_71262[(1)] = (1));

return statearr_71262;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__15091__auto____1 = (function (state_71246){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_71246);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e71263){var ex__15094__auto__ = e71263;
var statearr_71264_71276 = state_71246;
(statearr_71264_71276[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_71246[(4)]))){
var statearr_71265_71277 = state_71246;
(statearr_71265_71277[(1)] = cljs.core.first((state_71246[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__71278 = state_71246;
state_71246 = G__71278;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__15091__auto__ = function(state_71246){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__15091__auto____1.call(this,state_71246);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_71266 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_71266[(6)] = c__15165__auto__);

return statearr_71266;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_71308){
var state_val_71309 = (state_71308[(1)]);
if((state_val_71309 === (7))){
var state_71308__$1 = state_71308;
var statearr_71310_71329 = state_71308__$1;
(statearr_71310_71329[(2)] = arg);

(statearr_71310_71329[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71309 === (1))){
var state_71308__$1 = state_71308;
var statearr_71311_71330 = state_71308__$1;
(statearr_71311_71330[(2)] = null);

(statearr_71311_71330[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71309 === (4))){
var inst_71279 = (state_71308[(2)]);
var state_71308__$1 = state_71308;
var statearr_71312_71331 = state_71308__$1;
(statearr_71312_71331[(2)] = inst_71279);

(statearr_71312_71331[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71309 === (6))){
var state_71308__$1 = state_71308;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71308__$1,(9),arg);
} else {
if((state_val_71309 === (3))){
var inst_71306 = (state_71308[(2)]);
var state_71308__$1 = state_71308;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71308__$1,inst_71306);
} else {
if((state_val_71309 === (2))){
var _ = (function (){var statearr_71314 = state_71308;
(statearr_71314[(4)] = cljs.core.cons((5),(state_71308[(4)])));

return statearr_71314;
})();
var inst_71285 = fluree.db.util.async.channel_QMARK_(arg);
var state_71308__$1 = state_71308;
if(inst_71285){
var statearr_71315_71332 = state_71308__$1;
(statearr_71315_71332[(1)] = (6));

} else {
var statearr_71316_71333 = state_71308__$1;
(statearr_71316_71333[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71309 === (9))){
var inst_71288 = (state_71308[(2)]);
var inst_71289 = fluree.db.util.async.throw_err(inst_71288);
var state_71308__$1 = state_71308;
var statearr_71317_71334 = state_71308__$1;
(statearr_71317_71334[(2)] = inst_71289);

(statearr_71317_71334[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71309 === (5))){
var _ = (function (){var statearr_71318 = state_71308;
(statearr_71318[(4)] = cljs.core.rest((state_71308[(4)])));

return statearr_71318;
})();
var state_71308__$1 = state_71308;
var ex71313 = (state_71308__$1[(2)]);
var statearr_71319_71335 = state_71308__$1;
(statearr_71319_71335[(5)] = ex71313);


if((ex71313 instanceof Error)){
var statearr_71320_71336 = state_71308__$1;
(statearr_71320_71336[(1)] = (4));

(statearr_71320_71336[(5)] = null);

} else {
throw ex71313;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71309 === (8))){
var inst_71292 = (state_71308[(2)]);
var inst_71293 = fluree.db.dbfunctions.internal.not(inst_71292);
var inst_71294 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71295 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71296 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71297 = [inst_71292];
var inst_71298 = (new cljs.core.PersistentVector(null,1,(5),inst_71296,inst_71297,null));
var inst_71299 = ["not?",inst_71298,inst_71293];
var inst_71300 = cljs.core.PersistentHashMap.fromArrays(inst_71295,inst_71299);
var inst_71301 = [inst_71300,(10)];
var inst_71302 = (new cljs.core.PersistentVector(null,2,(5),inst_71294,inst_71301,null));
var inst_71303 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71302);
var _ = (function (){var statearr_71321 = state_71308;
(statearr_71321[(4)] = cljs.core.rest((state_71308[(4)])));

return statearr_71321;
})();
var state_71308__$1 = (function (){var statearr_71322 = state_71308;
(statearr_71322[(7)] = inst_71303);

return statearr_71322;
})();
var statearr_71323_71337 = state_71308__$1;
(statearr_71323_71337[(2)] = inst_71293);

(statearr_71323_71337[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__15091__auto____0 = (function (){
var statearr_71324 = [null,null,null,null,null,null,null,null];
(statearr_71324[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__15091__auto__);

(statearr_71324[(1)] = (1));

return statearr_71324;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__15091__auto____1 = (function (state_71308){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_71308);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e71325){var ex__15094__auto__ = e71325;
var statearr_71326_71338 = state_71308;
(statearr_71326_71338[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_71308[(4)]))){
var statearr_71327_71339 = state_71308;
(statearr_71327_71339[(1)] = cljs.core.first((state_71308[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__71340 = state_71308;
state_71308 = G__71340;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__15091__auto__ = function(state_71308){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__15091__auto____1.call(this,state_71308);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_71328 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_71328[(6)] = c__15165__auto__);

return statearr_71328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_71370){
var state_val_71371 = (state_71370[(1)]);
if((state_val_71371 === (7))){
var state_71370__$1 = state_71370;
var statearr_71372_71391 = state_71370__$1;
(statearr_71372_71391[(2)] = arg);

(statearr_71372_71391[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71371 === (1))){
var state_71370__$1 = state_71370;
var statearr_71373_71392 = state_71370__$1;
(statearr_71373_71392[(2)] = null);

(statearr_71373_71392[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71371 === (4))){
var inst_71341 = (state_71370[(2)]);
var state_71370__$1 = state_71370;
var statearr_71374_71393 = state_71370__$1;
(statearr_71374_71393[(2)] = inst_71341);

(statearr_71374_71393[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71371 === (6))){
var state_71370__$1 = state_71370;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71370__$1,(9),arg);
} else {
if((state_val_71371 === (3))){
var inst_71368 = (state_71370[(2)]);
var state_71370__$1 = state_71370;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71370__$1,inst_71368);
} else {
if((state_val_71371 === (2))){
var _ = (function (){var statearr_71376 = state_71370;
(statearr_71376[(4)] = cljs.core.cons((5),(state_71370[(4)])));

return statearr_71376;
})();
var inst_71347 = fluree.db.util.async.channel_QMARK_(arg);
var state_71370__$1 = state_71370;
if(inst_71347){
var statearr_71377_71394 = state_71370__$1;
(statearr_71377_71394[(1)] = (6));

} else {
var statearr_71378_71395 = state_71370__$1;
(statearr_71378_71395[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71371 === (9))){
var inst_71350 = (state_71370[(2)]);
var inst_71351 = fluree.db.util.async.throw_err(inst_71350);
var state_71370__$1 = state_71370;
var statearr_71379_71396 = state_71370__$1;
(statearr_71379_71396[(2)] = inst_71351);

(statearr_71379_71396[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71371 === (5))){
var _ = (function (){var statearr_71380 = state_71370;
(statearr_71380[(4)] = cljs.core.rest((state_71370[(4)])));

return statearr_71380;
})();
var state_71370__$1 = state_71370;
var ex71375 = (state_71370__$1[(2)]);
var statearr_71381_71397 = state_71370__$1;
(statearr_71381_71397[(5)] = ex71375);


if((ex71375 instanceof Error)){
var statearr_71382_71398 = state_71370__$1;
(statearr_71382_71398[(1)] = (4));

(statearr_71382_71398[(5)] = null);

} else {
throw ex71375;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71371 === (8))){
var inst_71354 = (state_71370[(2)]);
var inst_71355 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_71354);
var inst_71356 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71357 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71358 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71359 = [inst_71354];
var inst_71360 = (new cljs.core.PersistentVector(null,1,(5),inst_71358,inst_71359,null));
var inst_71361 = ["empty?",inst_71360,inst_71355];
var inst_71362 = cljs.core.PersistentHashMap.fromArrays(inst_71357,inst_71361);
var inst_71363 = [inst_71362,(10)];
var inst_71364 = (new cljs.core.PersistentVector(null,2,(5),inst_71356,inst_71363,null));
var inst_71365 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71364);
var _ = (function (){var statearr_71383 = state_71370;
(statearr_71383[(4)] = cljs.core.rest((state_71370[(4)])));

return statearr_71383;
})();
var state_71370__$1 = (function (){var statearr_71384 = state_71370;
(statearr_71384[(7)] = inst_71365);

return statearr_71384;
})();
var statearr_71385_71399 = state_71370__$1;
(statearr_71385_71399[(2)] = inst_71355);

(statearr_71385_71399[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__15091__auto____0 = (function (){
var statearr_71386 = [null,null,null,null,null,null,null,null];
(statearr_71386[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__15091__auto__);

(statearr_71386[(1)] = (1));

return statearr_71386;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__15091__auto____1 = (function (state_71370){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_71370);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e71387){var ex__15094__auto__ = e71387;
var statearr_71388_71400 = state_71370;
(statearr_71388_71400[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_71370[(4)]))){
var statearr_71389_71401 = state_71370;
(statearr_71389_71401[(1)] = cljs.core.first((state_71370[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__71402 = state_71370;
state_71370 = G__71402;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__15091__auto__ = function(state_71370){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__15091__auto____1.call(this,state_71370);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_71390 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_71390[(6)] = c__15165__auto__);

return statearr_71390;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__5774__auto__ = [];
var len__5768__auto___71447 = arguments.length;
var i__5769__auto___71448 = (0);
while(true){
if((i__5769__auto___71448 < len__5768__auto___71447)){
args__5774__auto__.push((arguments[i__5769__auto___71448]));

var G__71449 = (i__5769__auto___71448 + (1));
i__5769__auto___71448 = G__71449;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_71430){
var state_val_71431 = (state_71430[(1)]);
if((state_val_71431 === (1))){
var state_71430__$1 = state_71430;
var statearr_71432_71450 = state_71430__$1;
(statearr_71432_71450[(2)] = null);

(statearr_71432_71450[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71431 === (2))){
var _ = (function (){var statearr_71433 = state_71430;
(statearr_71433[(4)] = cljs.core.cons((5),(state_71430[(4)])));

return statearr_71433;
})();
var inst_71411 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71430__$1 = state_71430;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71430__$1,(6),inst_71411);
} else {
if((state_val_71431 === (3))){
var inst_71428 = (state_71430[(2)]);
var state_71430__$1 = state_71430;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71430__$1,inst_71428);
} else {
if((state_val_71431 === (4))){
var inst_71405 = (state_71430[(2)]);
var state_71430__$1 = state_71430;
var statearr_71435_71451 = state_71430__$1;
(statearr_71435_71451[(2)] = inst_71405);

(statearr_71435_71451[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71431 === (5))){
var _ = (function (){var statearr_71436 = state_71430;
(statearr_71436[(4)] = cljs.core.rest((state_71430[(4)])));

return statearr_71436;
})();
var state_71430__$1 = state_71430;
var ex71434 = (state_71430__$1[(2)]);
var statearr_71437_71452 = state_71430__$1;
(statearr_71437_71452[(5)] = ex71434);


if((ex71434 instanceof Error)){
var statearr_71438_71453 = state_71430__$1;
(statearr_71438_71453[(1)] = (4));

(statearr_71438_71453[(5)] = null);

} else {
throw ex71434;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71431 === (6))){
var inst_71413 = (state_71430[(2)]);
var inst_71414 = fluree.db.util.async.throw_err(inst_71413);
var inst_71415 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_71414);
var inst_71416 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71417 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71418 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71419 = [inst_71414];
var inst_71420 = (new cljs.core.PersistentVector(null,1,(5),inst_71418,inst_71419,null));
var inst_71421 = ["str",inst_71420,inst_71415];
var inst_71422 = cljs.core.PersistentHashMap.fromArrays(inst_71417,inst_71421);
var inst_71423 = [inst_71422,(10)];
var inst_71424 = (new cljs.core.PersistentVector(null,2,(5),inst_71416,inst_71423,null));
var inst_71425 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71424);
var _ = (function (){var statearr_71439 = state_71430;
(statearr_71439[(4)] = cljs.core.rest((state_71430[(4)])));

return statearr_71439;
})();
var state_71430__$1 = (function (){var statearr_71440 = state_71430;
(statearr_71440[(7)] = inst_71425);

return statearr_71440;
})();
var statearr_71441_71454 = state_71430__$1;
(statearr_71441_71454[(2)] = inst_71415);

(statearr_71441_71454[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__15091__auto____0 = (function (){
var statearr_71442 = [null,null,null,null,null,null,null,null];
(statearr_71442[(0)] = fluree$db$dbfunctions$fns$state_machine__15091__auto__);

(statearr_71442[(1)] = (1));

return statearr_71442;
});
var fluree$db$dbfunctions$fns$state_machine__15091__auto____1 = (function (state_71430){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_71430);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e71443){var ex__15094__auto__ = e71443;
var statearr_71444_71455 = state_71430;
(statearr_71444_71455[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_71430[(4)]))){
var statearr_71445_71456 = state_71430;
(statearr_71445_71456[(1)] = cljs.core.first((state_71430[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__71457 = state_71430;
state_71430 = G__71457;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__15091__auto__ = function(state_71430){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____1.call(this,state_71430);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_71446 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_71446[(6)] = c__15165__auto__);

return statearr_71446;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq71403){
var G__71404 = cljs.core.first(seq71403);
var seq71403__$1 = cljs.core.next(seq71403);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71404,seq71403__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_71483){
var state_val_71484 = (state_71483[(1)]);
if((state_val_71484 === (1))){
var state_71483__$1 = state_71483;
var statearr_71485_71500 = state_71483__$1;
(statearr_71485_71500[(2)] = null);

(statearr_71485_71500[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71484 === (2))){
var _ = (function (){var statearr_71486 = state_71483;
(statearr_71486[(4)] = cljs.core.cons((5),(state_71483[(4)])));

return statearr_71486;
})();
var inst_71464 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71483__$1 = state_71483;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71483__$1,(6),inst_71464);
} else {
if((state_val_71484 === (3))){
var inst_71481 = (state_71483[(2)]);
var state_71483__$1 = state_71483;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71483__$1,inst_71481);
} else {
if((state_val_71484 === (4))){
var inst_71458 = (state_71483[(2)]);
var state_71483__$1 = state_71483;
var statearr_71488_71501 = state_71483__$1;
(statearr_71488_71501[(2)] = inst_71458);

(statearr_71488_71501[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71484 === (5))){
var _ = (function (){var statearr_71489 = state_71483;
(statearr_71489[(4)] = cljs.core.rest((state_71483[(4)])));

return statearr_71489;
})();
var state_71483__$1 = state_71483;
var ex71487 = (state_71483__$1[(2)]);
var statearr_71490_71502 = state_71483__$1;
(statearr_71490_71502[(5)] = ex71487);


if((ex71487 instanceof Error)){
var statearr_71491_71503 = state_71483__$1;
(statearr_71491_71503[(1)] = (4));

(statearr_71491_71503[(5)] = null);

} else {
throw ex71487;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71484 === (6))){
var inst_71466 = (state_71483[(2)]);
var inst_71467 = fluree.db.util.async.throw_err(inst_71466);
var inst_71468 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_71467);
var inst_71469 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71470 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71471 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71472 = [inst_71467];
var inst_71473 = (new cljs.core.PersistentVector(null,1,(5),inst_71471,inst_71472,null));
var inst_71474 = ["subs",inst_71473,inst_71468];
var inst_71475 = cljs.core.PersistentHashMap.fromArrays(inst_71470,inst_71474);
var inst_71476 = [inst_71475,(30)];
var inst_71477 = (new cljs.core.PersistentVector(null,2,(5),inst_71469,inst_71476,null));
var inst_71478 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71477);
var _ = (function (){var statearr_71492 = state_71483;
(statearr_71492[(4)] = cljs.core.rest((state_71483[(4)])));

return statearr_71492;
})();
var state_71483__$1 = (function (){var statearr_71493 = state_71483;
(statearr_71493[(7)] = inst_71478);

return statearr_71493;
})();
var statearr_71494_71504 = state_71483__$1;
(statearr_71494_71504[(2)] = inst_71468);

(statearr_71494_71504[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__15091__auto____0 = (function (){
var statearr_71495 = [null,null,null,null,null,null,null,null];
(statearr_71495[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__15091__auto__);

(statearr_71495[(1)] = (1));

return statearr_71495;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__15091__auto____1 = (function (state_71483){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_71483);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e71496){var ex__15094__auto__ = e71496;
var statearr_71497_71505 = state_71483;
(statearr_71497_71505[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_71483[(4)]))){
var statearr_71498_71506 = state_71483;
(statearr_71498_71506[(1)] = cljs.core.first((state_71483[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__71507 = state_71483;
state_71483 = G__71507;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__15091__auto__ = function(state_71483){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__15091__auto____1.call(this,state_71483);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_71499 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_71499[(6)] = c__15165__auto__);

return statearr_71499;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_71537){
var state_val_71538 = (state_71537[(1)]);
if((state_val_71538 === (7))){
var state_71537__$1 = state_71537;
var statearr_71539_71558 = state_71537__$1;
(statearr_71539_71558[(2)] = str);

(statearr_71539_71558[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71538 === (1))){
var state_71537__$1 = state_71537;
var statearr_71540_71559 = state_71537__$1;
(statearr_71540_71559[(2)] = null);

(statearr_71540_71559[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71538 === (4))){
var inst_71508 = (state_71537[(2)]);
var state_71537__$1 = state_71537;
var statearr_71541_71560 = state_71537__$1;
(statearr_71541_71560[(2)] = inst_71508);

(statearr_71541_71560[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71538 === (6))){
var state_71537__$1 = state_71537;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71537__$1,(9),str);
} else {
if((state_val_71538 === (3))){
var inst_71535 = (state_71537[(2)]);
var state_71537__$1 = state_71537;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71537__$1,inst_71535);
} else {
if((state_val_71538 === (2))){
var _ = (function (){var statearr_71543 = state_71537;
(statearr_71543[(4)] = cljs.core.cons((5),(state_71537[(4)])));

return statearr_71543;
})();
var inst_71514 = fluree.db.util.async.channel_QMARK_(str);
var state_71537__$1 = state_71537;
if(inst_71514){
var statearr_71544_71561 = state_71537__$1;
(statearr_71544_71561[(1)] = (6));

} else {
var statearr_71545_71562 = state_71537__$1;
(statearr_71545_71562[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71538 === (9))){
var inst_71517 = (state_71537[(2)]);
var inst_71518 = fluree.db.util.async.throw_err(inst_71517);
var state_71537__$1 = state_71537;
var statearr_71546_71563 = state_71537__$1;
(statearr_71546_71563[(2)] = inst_71518);

(statearr_71546_71563[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71538 === (5))){
var _ = (function (){var statearr_71547 = state_71537;
(statearr_71547[(4)] = cljs.core.rest((state_71537[(4)])));

return statearr_71547;
})();
var state_71537__$1 = state_71537;
var ex71542 = (state_71537__$1[(2)]);
var statearr_71548_71564 = state_71537__$1;
(statearr_71548_71564[(5)] = ex71542);


if((ex71542 instanceof Error)){
var statearr_71549_71565 = state_71537__$1;
(statearr_71549_71565[(1)] = (4));

(statearr_71549_71565[(5)] = null);

} else {
throw ex71542;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71538 === (8))){
var inst_71521 = (state_71537[(2)]);
var inst_71522 = fluree.db.dbfunctions.internal.lower_case(inst_71521);
var inst_71523 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71524 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71526 = [inst_71521];
var inst_71527 = (new cljs.core.PersistentVector(null,1,(5),inst_71525,inst_71526,null));
var inst_71528 = ["lower-case",inst_71527,inst_71522];
var inst_71529 = cljs.core.PersistentHashMap.fromArrays(inst_71524,inst_71528);
var inst_71530 = [inst_71529,(10)];
var inst_71531 = (new cljs.core.PersistentVector(null,2,(5),inst_71523,inst_71530,null));
var inst_71532 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71531);
var _ = (function (){var statearr_71550 = state_71537;
(statearr_71550[(4)] = cljs.core.rest((state_71537[(4)])));

return statearr_71550;
})();
var state_71537__$1 = (function (){var statearr_71551 = state_71537;
(statearr_71551[(7)] = inst_71532);

return statearr_71551;
})();
var statearr_71552_71566 = state_71537__$1;
(statearr_71552_71566[(2)] = inst_71522);

(statearr_71552_71566[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__15091__auto____0 = (function (){
var statearr_71553 = [null,null,null,null,null,null,null,null];
(statearr_71553[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__15091__auto__);

(statearr_71553[(1)] = (1));

return statearr_71553;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__15091__auto____1 = (function (state_71537){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_71537);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e71554){var ex__15094__auto__ = e71554;
var statearr_71555_71567 = state_71537;
(statearr_71555_71567[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_71537[(4)]))){
var statearr_71556_71568 = state_71537;
(statearr_71556_71568[(1)] = cljs.core.first((state_71537[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__71569 = state_71537;
state_71537 = G__71569;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__15091__auto__ = function(state_71537){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__15091__auto____1.call(this,state_71537);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_71557 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_71557[(6)] = c__15165__auto__);

return statearr_71557;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_71599){
var state_val_71600 = (state_71599[(1)]);
if((state_val_71600 === (7))){
var state_71599__$1 = state_71599;
var statearr_71601_71620 = state_71599__$1;
(statearr_71601_71620[(2)] = str);

(statearr_71601_71620[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71600 === (1))){
var state_71599__$1 = state_71599;
var statearr_71602_71621 = state_71599__$1;
(statearr_71602_71621[(2)] = null);

(statearr_71602_71621[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71600 === (4))){
var inst_71570 = (state_71599[(2)]);
var state_71599__$1 = state_71599;
var statearr_71603_71622 = state_71599__$1;
(statearr_71603_71622[(2)] = inst_71570);

(statearr_71603_71622[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71600 === (6))){
var state_71599__$1 = state_71599;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71599__$1,(9),str);
} else {
if((state_val_71600 === (3))){
var inst_71597 = (state_71599[(2)]);
var state_71599__$1 = state_71599;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71599__$1,inst_71597);
} else {
if((state_val_71600 === (2))){
var _ = (function (){var statearr_71605 = state_71599;
(statearr_71605[(4)] = cljs.core.cons((5),(state_71599[(4)])));

return statearr_71605;
})();
var inst_71576 = fluree.db.util.async.channel_QMARK_(str);
var state_71599__$1 = state_71599;
if(inst_71576){
var statearr_71606_71623 = state_71599__$1;
(statearr_71606_71623[(1)] = (6));

} else {
var statearr_71607_71624 = state_71599__$1;
(statearr_71607_71624[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71600 === (9))){
var inst_71579 = (state_71599[(2)]);
var inst_71580 = fluree.db.util.async.throw_err(inst_71579);
var state_71599__$1 = state_71599;
var statearr_71608_71625 = state_71599__$1;
(statearr_71608_71625[(2)] = inst_71580);

(statearr_71608_71625[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71600 === (5))){
var _ = (function (){var statearr_71609 = state_71599;
(statearr_71609[(4)] = cljs.core.rest((state_71599[(4)])));

return statearr_71609;
})();
var state_71599__$1 = state_71599;
var ex71604 = (state_71599__$1[(2)]);
var statearr_71610_71626 = state_71599__$1;
(statearr_71610_71626[(5)] = ex71604);


if((ex71604 instanceof Error)){
var statearr_71611_71627 = state_71599__$1;
(statearr_71611_71627[(1)] = (4));

(statearr_71611_71627[(5)] = null);

} else {
throw ex71604;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71600 === (8))){
var inst_71583 = (state_71599[(2)]);
var inst_71584 = fluree.db.dbfunctions.internal.upper_case(inst_71583);
var inst_71585 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71586 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71587 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71588 = [inst_71583];
var inst_71589 = (new cljs.core.PersistentVector(null,1,(5),inst_71587,inst_71588,null));
var inst_71590 = ["upper-case",inst_71589,inst_71584];
var inst_71591 = cljs.core.PersistentHashMap.fromArrays(inst_71586,inst_71590);
var inst_71592 = [inst_71591,(10)];
var inst_71593 = (new cljs.core.PersistentVector(null,2,(5),inst_71585,inst_71592,null));
var inst_71594 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71593);
var _ = (function (){var statearr_71612 = state_71599;
(statearr_71612[(4)] = cljs.core.rest((state_71599[(4)])));

return statearr_71612;
})();
var state_71599__$1 = (function (){var statearr_71613 = state_71599;
(statearr_71613[(7)] = inst_71594);

return statearr_71613;
})();
var statearr_71614_71628 = state_71599__$1;
(statearr_71614_71628[(2)] = inst_71584);

(statearr_71614_71628[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__15091__auto____0 = (function (){
var statearr_71615 = [null,null,null,null,null,null,null,null];
(statearr_71615[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__15091__auto__);

(statearr_71615[(1)] = (1));

return statearr_71615;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__15091__auto____1 = (function (state_71599){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_71599);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e71616){var ex__15094__auto__ = e71616;
var statearr_71617_71629 = state_71599;
(statearr_71617_71629[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_71599[(4)]))){
var statearr_71618_71630 = state_71599;
(statearr_71618_71630[(1)] = cljs.core.first((state_71599[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__71631 = state_71599;
state_71599 = G__71631;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__15091__auto__ = function(state_71599){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__15091__auto____1.call(this,state_71599);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_71619 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_71619[(6)] = c__15165__auto__);

return statearr_71619;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__5043__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null)) === 'string'));
} else {
return and__5043__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?pid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__71633 = arguments.length;
switch (G__71633) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_71661){
var state_val_71662 = (state_71661[(1)]);
if((state_val_71662 === (1))){
var state_71661__$1 = state_71661;
var statearr_71663_71679 = state_71661__$1;
(statearr_71663_71679[(2)] = null);

(statearr_71663_71679[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71662 === (2))){
var _ = (function (){var statearr_71664 = state_71661;
(statearr_71664[(4)] = cljs.core.cons((5),(state_71661[(4)])));

return statearr_71664;
})();
var inst_71643 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_71661__$1 = state_71661;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71661__$1,(6),inst_71643);
} else {
if((state_val_71662 === (3))){
var inst_71659 = (state_71661[(2)]);
var state_71661__$1 = state_71661;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71661__$1,inst_71659);
} else {
if((state_val_71662 === (4))){
var inst_71634 = (state_71661[(2)]);
var state_71661__$1 = state_71661;
var statearr_71666_71680 = state_71661__$1;
(statearr_71666_71680[(2)] = inst_71634);

(statearr_71666_71680[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71662 === (5))){
var _ = (function (){var statearr_71667 = state_71661;
(statearr_71667[(4)] = cljs.core.rest((state_71661[(4)])));

return statearr_71667;
})();
var state_71661__$1 = state_71661;
var ex71665 = (state_71661__$1[(2)]);
var statearr_71668_71681 = state_71661__$1;
(statearr_71668_71681[(5)] = ex71665);


if((ex71665 instanceof Error)){
var statearr_71669_71682 = state_71661__$1;
(statearr_71669_71682[(1)] = (4));

(statearr_71669_71682[(5)] = null);

} else {
throw ex71665;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71662 === (6))){
var inst_71645 = (state_71661[(2)]);
var inst_71646 = fluree.db.util.async.throw_err(inst_71645);
var inst_71647 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71646,(0),null);
var inst_71648 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71646,(1),null);
var inst_71649 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71650 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71651 = ["?s","?ctx",inst_71647];
var inst_71652 = cljs.core.PersistentHashMap.fromArrays(inst_71650,inst_71651);
var inst_71653 = ((10) + inst_71648);
var inst_71654 = [inst_71652,inst_71653];
var inst_71655 = (new cljs.core.PersistentVector(null,2,(5),inst_71649,inst_71654,null));
var inst_71656 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71655);
var _ = (function (){var statearr_71670 = state_71661;
(statearr_71670[(4)] = cljs.core.rest((state_71661[(4)])));

return statearr_71670;
})();
var state_71661__$1 = (function (){var statearr_71671 = state_71661;
(statearr_71671[(7)] = inst_71656);

return statearr_71671;
})();
var statearr_71672_71683 = state_71661__$1;
(statearr_71672_71683[(2)] = inst_71647);

(statearr_71672_71683[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__15091__auto____0 = (function (){
var statearr_71673 = [null,null,null,null,null,null,null,null];
(statearr_71673[(0)] = fluree$db$dbfunctions$fns$state_machine__15091__auto__);

(statearr_71673[(1)] = (1));

return statearr_71673;
});
var fluree$db$dbfunctions$fns$state_machine__15091__auto____1 = (function (state_71661){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_71661);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e71674){var ex__15094__auto__ = e71674;
var statearr_71675_71684 = state_71661;
(statearr_71675_71684[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_71661[(4)]))){
var statearr_71676_71685 = state_71661;
(statearr_71676_71685[(1)] = cljs.core.first((state_71661[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__71686 = state_71661;
state_71661 = G__71686;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__15091__auto__ = function(state_71661){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____1.call(this,state_71661);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_71677 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_71677[(6)] = c__15165__auto__);

return statearr_71677;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__71688 = arguments.length;
switch (G__71688) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_71726){
var state_val_71727 = (state_71726[(1)]);
if((state_val_71727 === (7))){
var inst_71719 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_71726__$1 = state_71726;
var statearr_71728_71748 = state_71726__$1;
(statearr_71728_71748[(2)] = inst_71719);

(statearr_71728_71748[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71727 === (1))){
var state_71726__$1 = state_71726;
var statearr_71729_71749 = state_71726__$1;
(statearr_71729_71749[(2)] = null);

(statearr_71729_71749[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71727 === (4))){
var inst_71689 = (state_71726[(2)]);
var state_71726__$1 = state_71726;
var statearr_71730_71750 = state_71726__$1;
(statearr_71730_71750[(2)] = inst_71689);

(statearr_71730_71750[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71727 === (6))){
var inst_71700 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_71726__$1 = state_71726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71726__$1,(10),inst_71700);
} else {
if((state_val_71727 === (3))){
var inst_71724 = (state_71726[(2)]);
var state_71726__$1 = state_71726;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71726__$1,inst_71724);
} else {
if((state_val_71727 === (2))){
var _ = (function (){var statearr_71732 = state_71726;
(statearr_71732[(4)] = cljs.core.cons((5),(state_71726[(4)])));

return statearr_71732;
})();
var inst_71695 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_71726__$1 = state_71726;
if(cljs.core.truth_(inst_71695)){
var statearr_71733_71751 = state_71726__$1;
(statearr_71733_71751[(1)] = (6));

} else {
var statearr_71734_71752 = state_71726__$1;
(statearr_71734_71752[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71727 === (9))){
var inst_71706 = (state_71726[(2)]);
var inst_71707 = fluree.db.util.async.throw_err(inst_71706);
var inst_71708 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71707,(0),null);
var inst_71709 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71707,(1),null);
var inst_71710 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71711 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71712 = ["?p","?ctx",inst_71708];
var inst_71713 = cljs.core.PersistentHashMap.fromArrays(inst_71711,inst_71712);
var inst_71714 = ((10) + inst_71709);
var inst_71715 = [inst_71713,inst_71714];
var inst_71716 = (new cljs.core.PersistentVector(null,2,(5),inst_71710,inst_71715,null));
var inst_71717 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71716);
var state_71726__$1 = (function (){var statearr_71735 = state_71726;
(statearr_71735[(7)] = inst_71717);

return statearr_71735;
})();
var statearr_71736_71753 = state_71726__$1;
(statearr_71736_71753[(2)] = inst_71708);

(statearr_71736_71753[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71727 === (5))){
var _ = (function (){var statearr_71737 = state_71726;
(statearr_71737[(4)] = cljs.core.rest((state_71726[(4)])));

return statearr_71737;
})();
var state_71726__$1 = state_71726;
var ex71731 = (state_71726__$1[(2)]);
var statearr_71738_71754 = state_71726__$1;
(statearr_71738_71754[(5)] = ex71731);


if((ex71731 instanceof Error)){
var statearr_71739_71755 = state_71726__$1;
(statearr_71739_71755[(1)] = (4));

(statearr_71739_71755[(5)] = null);

} else {
throw ex71731;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71727 === (10))){
var inst_71702 = (state_71726[(2)]);
var inst_71703 = fluree.db.util.async.throw_err(inst_71702);
var inst_71704 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_71703);
var state_71726__$1 = state_71726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71726__$1,(9),inst_71704);
} else {
if((state_val_71727 === (8))){
var inst_71721 = (state_71726[(2)]);
var _ = (function (){var statearr_71740 = state_71726;
(statearr_71740[(4)] = cljs.core.rest((state_71726[(4)])));

return statearr_71740;
})();
var state_71726__$1 = state_71726;
var statearr_71741_71756 = state_71726__$1;
(statearr_71741_71756[(2)] = inst_71721);

(statearr_71741_71756[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__15091__auto____0 = (function (){
var statearr_71742 = [null,null,null,null,null,null,null,null];
(statearr_71742[(0)] = fluree$db$dbfunctions$fns$state_machine__15091__auto__);

(statearr_71742[(1)] = (1));

return statearr_71742;
});
var fluree$db$dbfunctions$fns$state_machine__15091__auto____1 = (function (state_71726){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_71726);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e71743){var ex__15094__auto__ = e71743;
var statearr_71744_71757 = state_71726;
(statearr_71744_71757[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_71726[(4)]))){
var statearr_71745_71758 = state_71726;
(statearr_71745_71758[(1)] = cljs.core.first((state_71726[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__71759 = state_71726;
state_71726 = G__71759;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__15091__auto__ = function(state_71726){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____1.call(this,state_71726);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_71746 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_71746[(6)] = c__15165__auto__);

return statearr_71746;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__5774__auto__ = [];
var len__5768__auto___71808 = arguments.length;
var i__5769__auto___71809 = (0);
while(true){
if((i__5769__auto___71809 < len__5768__auto___71808)){
args__5774__auto__.push((arguments[i__5769__auto___71809]));

var G__71810 = (i__5769__auto___71809 + (1));
i__5769__auto___71809 = G__71810;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_71791){
var state_val_71792 = (state_71791[(1)]);
if((state_val_71792 === (1))){
var state_71791__$1 = state_71791;
var statearr_71793_71811 = state_71791__$1;
(statearr_71793_71811[(2)] = null);

(statearr_71793_71811[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71792 === (2))){
var _ = (function (){var statearr_71794 = state_71791;
(statearr_71794[(4)] = cljs.core.cons((5),(state_71791[(4)])));

return statearr_71794;
})();
var inst_71768 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71791__$1 = state_71791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71791__$1,(6),inst_71768);
} else {
if((state_val_71792 === (3))){
var inst_71789 = (state_71791[(2)]);
var state_71791__$1 = state_71791;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71791__$1,inst_71789);
} else {
if((state_val_71792 === (4))){
var inst_71762 = (state_71791[(2)]);
var state_71791__$1 = state_71791;
var statearr_71796_71812 = state_71791__$1;
(statearr_71796_71812[(2)] = inst_71762);

(statearr_71796_71812[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71792 === (5))){
var _ = (function (){var statearr_71797 = state_71791;
(statearr_71797[(4)] = cljs.core.rest((state_71791[(4)])));

return statearr_71797;
})();
var state_71791__$1 = state_71791;
var ex71795 = (state_71791__$1[(2)]);
var statearr_71798_71813 = state_71791__$1;
(statearr_71798_71813[(5)] = ex71795);


if((ex71795 instanceof Error)){
var statearr_71799_71814 = state_71791__$1;
(statearr_71799_71814[(1)] = (4));

(statearr_71799_71814[(5)] = null);

} else {
throw ex71795;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71792 === (6))){
var inst_71770 = (state_71791[(2)]);
var inst_71771 = fluree.db.util.async.throw_err(inst_71770);
var inst_71772 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_71771);
var inst_71773 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71774 = [inst_71771];
var inst_71775 = (new cljs.core.PersistentVector(null,1,(5),inst_71773,inst_71774,null));
var inst_71776 = cljs.core.count(inst_71775);
var inst_71777 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71778 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71779 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71780 = [inst_71771];
var inst_71781 = (new cljs.core.PersistentVector(null,1,(5),inst_71779,inst_71780,null));
var inst_71782 = ["and",inst_71781,inst_71772];
var inst_71783 = cljs.core.PersistentHashMap.fromArrays(inst_71778,inst_71782);
var inst_71784 = [inst_71783,inst_71776];
var inst_71785 = (new cljs.core.PersistentVector(null,2,(5),inst_71777,inst_71784,null));
var inst_71786 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71785);
var _ = (function (){var statearr_71800 = state_71791;
(statearr_71800[(4)] = cljs.core.rest((state_71791[(4)])));

return statearr_71800;
})();
var state_71791__$1 = (function (){var statearr_71801 = state_71791;
(statearr_71801[(7)] = inst_71786);

return statearr_71801;
})();
var statearr_71802_71815 = state_71791__$1;
(statearr_71802_71815[(2)] = inst_71772);

(statearr_71802_71815[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__15091__auto____0 = (function (){
var statearr_71803 = [null,null,null,null,null,null,null,null];
(statearr_71803[(0)] = fluree$db$dbfunctions$fns$state_machine__15091__auto__);

(statearr_71803[(1)] = (1));

return statearr_71803;
});
var fluree$db$dbfunctions$fns$state_machine__15091__auto____1 = (function (state_71791){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_71791);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e71804){var ex__15094__auto__ = e71804;
var statearr_71805_71816 = state_71791;
(statearr_71805_71816[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_71791[(4)]))){
var statearr_71806_71817 = state_71791;
(statearr_71806_71817[(1)] = cljs.core.first((state_71791[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__71818 = state_71791;
state_71791 = G__71818;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__15091__auto__ = function(state_71791){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____1.call(this,state_71791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_71807 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_71807[(6)] = c__15165__auto__);

return statearr_71807;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq71760){
var G__71761 = cljs.core.first(seq71760);
var seq71760__$1 = cljs.core.next(seq71760);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71761,seq71760__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__5774__auto__ = [];
var len__5768__auto___71867 = arguments.length;
var i__5769__auto___71868 = (0);
while(true){
if((i__5769__auto___71868 < len__5768__auto___71867)){
args__5774__auto__.push((arguments[i__5769__auto___71868]));

var G__71869 = (i__5769__auto___71868 + (1));
i__5769__auto___71868 = G__71869;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_71850){
var state_val_71851 = (state_71850[(1)]);
if((state_val_71851 === (1))){
var state_71850__$1 = state_71850;
var statearr_71852_71870 = state_71850__$1;
(statearr_71852_71870[(2)] = null);

(statearr_71852_71870[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71851 === (2))){
var _ = (function (){var statearr_71853 = state_71850;
(statearr_71853[(4)] = cljs.core.cons((5),(state_71850[(4)])));

return statearr_71853;
})();
var inst_71827 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71850__$1 = state_71850;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71850__$1,(6),inst_71827);
} else {
if((state_val_71851 === (3))){
var inst_71848 = (state_71850[(2)]);
var state_71850__$1 = state_71850;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71850__$1,inst_71848);
} else {
if((state_val_71851 === (4))){
var inst_71821 = (state_71850[(2)]);
var state_71850__$1 = state_71850;
var statearr_71855_71871 = state_71850__$1;
(statearr_71855_71871[(2)] = inst_71821);

(statearr_71855_71871[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71851 === (5))){
var _ = (function (){var statearr_71856 = state_71850;
(statearr_71856[(4)] = cljs.core.rest((state_71850[(4)])));

return statearr_71856;
})();
var state_71850__$1 = state_71850;
var ex71854 = (state_71850__$1[(2)]);
var statearr_71857_71872 = state_71850__$1;
(statearr_71857_71872[(5)] = ex71854);


if((ex71854 instanceof Error)){
var statearr_71858_71873 = state_71850__$1;
(statearr_71858_71873[(1)] = (4));

(statearr_71858_71873[(5)] = null);

} else {
throw ex71854;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71851 === (6))){
var inst_71829 = (state_71850[(2)]);
var inst_71830 = fluree.db.util.async.throw_err(inst_71829);
var inst_71831 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_71830);
var inst_71832 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71833 = [inst_71830];
var inst_71834 = (new cljs.core.PersistentVector(null,1,(5),inst_71832,inst_71833,null));
var inst_71835 = cljs.core.count(inst_71834);
var inst_71836 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71837 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71838 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71839 = [inst_71830];
var inst_71840 = (new cljs.core.PersistentVector(null,1,(5),inst_71838,inst_71839,null));
var inst_71841 = ["or",inst_71840,inst_71831];
var inst_71842 = cljs.core.PersistentHashMap.fromArrays(inst_71837,inst_71841);
var inst_71843 = [inst_71842,inst_71835];
var inst_71844 = (new cljs.core.PersistentVector(null,2,(5),inst_71836,inst_71843,null));
var inst_71845 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71844);
var _ = (function (){var statearr_71859 = state_71850;
(statearr_71859[(4)] = cljs.core.rest((state_71850[(4)])));

return statearr_71859;
})();
var state_71850__$1 = (function (){var statearr_71860 = state_71850;
(statearr_71860[(7)] = inst_71845);

return statearr_71860;
})();
var statearr_71861_71874 = state_71850__$1;
(statearr_71861_71874[(2)] = inst_71831);

(statearr_71861_71874[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__15091__auto____0 = (function (){
var statearr_71862 = [null,null,null,null,null,null,null,null];
(statearr_71862[(0)] = fluree$db$dbfunctions$fns$state_machine__15091__auto__);

(statearr_71862[(1)] = (1));

return statearr_71862;
});
var fluree$db$dbfunctions$fns$state_machine__15091__auto____1 = (function (state_71850){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_71850);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e71863){var ex__15094__auto__ = e71863;
var statearr_71864_71875 = state_71850;
(statearr_71864_71875[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_71850[(4)]))){
var statearr_71865_71876 = state_71850;
(statearr_71865_71876[(1)] = cljs.core.first((state_71850[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__71877 = state_71850;
state_71850 = G__71877;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__15091__auto__ = function(state_71850){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____1.call(this,state_71850);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_71866 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_71866[(6)] = c__15165__auto__);

return statearr_71866;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq71819){
var G__71820 = cljs.core.first(seq71819);
var seq71819__$1 = cljs.core.next(seq71819);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71820,seq71819__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_71915){
var state_val_71916 = (state_71915[(1)]);
if((state_val_71916 === (7))){
var inst_71891 = fluree.db.util.async.channel_QMARK_(coll);
var state_71915__$1 = state_71915;
if(inst_71891){
var statearr_71917_71940 = state_71915__$1;
(statearr_71917_71940[(1)] = (10));

} else {
var statearr_71918_71941 = state_71915__$1;
(statearr_71918_71941[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71916 === (1))){
var state_71915__$1 = state_71915;
var statearr_71919_71942 = state_71915__$1;
(statearr_71919_71942[(2)] = null);

(statearr_71919_71942[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71916 === (4))){
var inst_71878 = (state_71915[(2)]);
var state_71915__$1 = state_71915;
var statearr_71920_71943 = state_71915__$1;
(statearr_71920_71943[(2)] = inst_71878);

(statearr_71920_71943[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71916 === (13))){
var inst_71894 = (state_71915[(2)]);
var inst_71895 = fluree.db.util.async.throw_err(inst_71894);
var state_71915__$1 = state_71915;
var statearr_71921_71944 = state_71915__$1;
(statearr_71921_71944[(2)] = inst_71895);

(statearr_71921_71944[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71916 === (6))){
var inst_71886 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_71915__$1 = state_71915;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71915__$1,(9),inst_71886);
} else {
if((state_val_71916 === (3))){
var inst_71913 = (state_71915[(2)]);
var state_71915__$1 = state_71915;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71915__$1,inst_71913);
} else {
if((state_val_71916 === (12))){
var inst_71898 = (state_71915[(2)]);
var state_71915__$1 = state_71915;
var statearr_71922_71945 = state_71915__$1;
(statearr_71922_71945[(2)] = inst_71898);

(statearr_71922_71945[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71916 === (2))){
var _ = (function (){var statearr_71923 = state_71915;
(statearr_71923[(4)] = cljs.core.cons((5),(state_71915[(4)])));

return statearr_71923;
})();
var inst_71884 = cljs.core.vector_QMARK_(coll);
var state_71915__$1 = state_71915;
if(inst_71884){
var statearr_71924_71946 = state_71915__$1;
(statearr_71924_71946[(1)] = (6));

} else {
var statearr_71925_71947 = state_71915__$1;
(statearr_71925_71947[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71916 === (11))){
var state_71915__$1 = state_71915;
var statearr_71927_71948 = state_71915__$1;
(statearr_71927_71948[(2)] = coll);

(statearr_71927_71948[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71916 === (9))){
var inst_71888 = (state_71915[(2)]);
var inst_71889 = fluree.db.util.async.throw_err(inst_71888);
var state_71915__$1 = state_71915;
var statearr_71928_71949 = state_71915__$1;
(statearr_71928_71949[(2)] = inst_71889);

(statearr_71928_71949[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71916 === (5))){
var _ = (function (){var statearr_71929 = state_71915;
(statearr_71929[(4)] = cljs.core.rest((state_71915[(4)])));

return statearr_71929;
})();
var state_71915__$1 = state_71915;
var ex71926 = (state_71915__$1[(2)]);
var statearr_71930_71950 = state_71915__$1;
(statearr_71930_71950[(5)] = ex71926);


if((ex71926 instanceof Error)){
var statearr_71931_71951 = state_71915__$1;
(statearr_71931_71951[(1)] = (4));

(statearr_71931_71951[(5)] = null);

} else {
throw ex71926;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71916 === (10))){
var state_71915__$1 = state_71915;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71915__$1,(13),coll);
} else {
if((state_val_71916 === (8))){
var inst_71900 = (state_71915[(2)]);
var inst_71901 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_71900);
var inst_71902 = cljs.core.count(inst_71901);
var inst_71903 = ((9) + inst_71902);
var inst_71904 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71905 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71906 = ["count",inst_71900,inst_71902];
var inst_71907 = cljs.core.PersistentHashMap.fromArrays(inst_71905,inst_71906);
var inst_71908 = [inst_71907,inst_71903];
var inst_71909 = (new cljs.core.PersistentVector(null,2,(5),inst_71904,inst_71908,null));
var inst_71910 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71909);
var _ = (function (){var statearr_71932 = state_71915;
(statearr_71932[(4)] = cljs.core.rest((state_71915[(4)])));

return statearr_71932;
})();
var state_71915__$1 = (function (){var statearr_71933 = state_71915;
(statearr_71933[(7)] = inst_71910);

return statearr_71933;
})();
var statearr_71934_71952 = state_71915__$1;
(statearr_71934_71952[(2)] = inst_71902);

(statearr_71934_71952[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__15091__auto____0 = (function (){
var statearr_71935 = [null,null,null,null,null,null,null,null];
(statearr_71935[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__15091__auto__);

(statearr_71935[(1)] = (1));

return statearr_71935;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__15091__auto____1 = (function (state_71915){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_71915);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e71936){var ex__15094__auto__ = e71936;
var statearr_71937_71953 = state_71915;
(statearr_71937_71953[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_71915[(4)]))){
var statearr_71938_71954 = state_71915;
(statearr_71938_71954[(1)] = cljs.core.first((state_71915[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__71955 = state_71915;
state_71915 = G__71955;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__15091__auto__ = function(state_71915){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__15091__auto____1.call(this,state_71915);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_71939 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_71939[(6)] = c__15165__auto__);

return statearr_71939;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_72005){
var state_val_72006 = (state_72005[(1)]);
if((state_val_72006 === (7))){
var state_72005__$1 = state_72005;
var statearr_72007_72040 = state_72005__$1;
(statearr_72007_72040[(2)] = subject);

(statearr_72007_72040[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72006 === (1))){
var state_72005__$1 = state_72005;
var statearr_72008_72041 = state_72005__$1;
(statearr_72008_72041[(2)] = null);

(statearr_72008_72041[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72006 === (4))){
var inst_71956 = (state_72005[(2)]);
var state_72005__$1 = state_72005;
var statearr_72009_72042 = state_72005__$1;
(statearr_72009_72042[(2)] = inst_71956);

(statearr_72009_72042[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72006 === (15))){
var inst_71969 = (state_72005[(7)]);
var state_72005__$1 = state_72005;
var statearr_72010_72043 = state_72005__$1;
(statearr_72010_72043[(2)] = inst_71969);

(statearr_72010_72043[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72006 === (13))){
var inst_71973 = (state_72005[(2)]);
var inst_71974 = fluree.db.util.async.throw_err(inst_71973);
var state_72005__$1 = state_72005;
var statearr_72011_72044 = state_72005__$1;
(statearr_72011_72044[(2)] = inst_71974);

(statearr_72011_72044[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72006 === (6))){
var state_72005__$1 = state_72005;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72005__$1,(9),subject);
} else {
if((state_val_72006 === (17))){
var inst_71969 = (state_72005[(7)]);
var inst_71983 = cljs.core.first(inst_71969);
var state_72005__$1 = state_72005;
var statearr_72012_72045 = state_72005__$1;
(statearr_72012_72045[(2)] = inst_71983);

(statearr_72012_72045[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72006 === (3))){
var inst_72003 = (state_72005[(2)]);
var state_72005__$1 = state_72005;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72005__$1,inst_72003);
} else {
if((state_val_72006 === (12))){
var inst_71969 = (state_72005[(7)]);
var inst_71977 = (state_72005[(2)]);
var inst_71978 = cljs.core.vector_QMARK_(inst_71969);
var state_72005__$1 = (function (){var statearr_72013 = state_72005;
(statearr_72013[(8)] = inst_71977);

return statearr_72013;
})();
if(inst_71978){
var statearr_72014_72046 = state_72005__$1;
(statearr_72014_72046[(1)] = (14));

} else {
var statearr_72015_72047 = state_72005__$1;
(statearr_72015_72047[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72006 === (2))){
var _ = (function (){var statearr_72016 = state_72005;
(statearr_72016[(4)] = cljs.core.cons((5),(state_72005[(4)])));

return statearr_72016;
})();
var inst_71962 = fluree.db.util.async.channel_QMARK_(subject);
var state_72005__$1 = state_72005;
if(inst_71962){
var statearr_72017_72048 = state_72005__$1;
(statearr_72017_72048[(1)] = (6));

} else {
var statearr_72018_72049 = state_72005__$1;
(statearr_72018_72049[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72006 === (19))){
var inst_71986 = (state_72005[(2)]);
var state_72005__$1 = state_72005;
var statearr_72019_72050 = state_72005__$1;
(statearr_72019_72050[(2)] = inst_71986);

(statearr_72019_72050[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72006 === (11))){
var state_72005__$1 = state_72005;
var statearr_72021_72051 = state_72005__$1;
(statearr_72021_72051[(2)] = pred);

(statearr_72021_72051[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72006 === (9))){
var inst_71965 = (state_72005[(2)]);
var inst_71966 = fluree.db.util.async.throw_err(inst_71965);
var state_72005__$1 = state_72005;
var statearr_72022_72052 = state_72005__$1;
(statearr_72022_72052[(2)] = inst_71966);

(statearr_72022_72052[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72006 === (5))){
var _ = (function (){var statearr_72023 = state_72005;
(statearr_72023[(4)] = cljs.core.rest((state_72005[(4)])));

return statearr_72023;
})();
var state_72005__$1 = state_72005;
var ex72020 = (state_72005__$1[(2)]);
var statearr_72024_72053 = state_72005__$1;
(statearr_72024_72053[(5)] = ex72020);


if((ex72020 instanceof Error)){
var statearr_72025_72054 = state_72005__$1;
(statearr_72025_72054[(1)] = (4));

(statearr_72025_72054[(5)] = null);

} else {
throw ex72020;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72006 === (14))){
var inst_71969 = (state_72005[(7)]);
var inst_71980 = cljs.core.count(inst_71969);
var inst_71981 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_71980);
var state_72005__$1 = state_72005;
if(inst_71981){
var statearr_72026_72055 = state_72005__$1;
(statearr_72026_72055[(1)] = (17));

} else {
var statearr_72027_72056 = state_72005__$1;
(statearr_72027_72056[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72006 === (16))){
var inst_71977 = (state_72005[(8)]);
var inst_71969 = (state_72005[(7)]);
var inst_71989 = (state_72005[(2)]);
var inst_71990 = fluree.db.dbfunctions.internal.get(inst_71989,inst_71977);
var inst_71991 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71992 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71993 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71994 = [inst_71969,inst_71977];
var inst_71995 = (new cljs.core.PersistentVector(null,2,(5),inst_71993,inst_71994,null));
var inst_71996 = ["get",inst_71995,inst_71990];
var inst_71997 = cljs.core.PersistentHashMap.fromArrays(inst_71992,inst_71996);
var inst_71998 = [inst_71997,(10)];
var inst_71999 = (new cljs.core.PersistentVector(null,2,(5),inst_71991,inst_71998,null));
var inst_72000 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71999);
var _ = (function (){var statearr_72028 = state_72005;
(statearr_72028[(4)] = cljs.core.rest((state_72005[(4)])));

return statearr_72028;
})();
var state_72005__$1 = (function (){var statearr_72029 = state_72005;
(statearr_72029[(9)] = inst_72000);

return statearr_72029;
})();
var statearr_72030_72057 = state_72005__$1;
(statearr_72030_72057[(2)] = inst_71990);

(statearr_72030_72057[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72006 === (10))){
var state_72005__$1 = state_72005;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72005__$1,(13),pred);
} else {
if((state_val_72006 === (18))){
var inst_71969 = (state_72005[(7)]);
var state_72005__$1 = state_72005;
var statearr_72031_72058 = state_72005__$1;
(statearr_72031_72058[(2)] = inst_71969);

(statearr_72031_72058[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72006 === (8))){
var inst_71969 = (state_72005[(2)]);
var inst_71970 = fluree.db.util.async.channel_QMARK_(pred);
var state_72005__$1 = (function (){var statearr_72032 = state_72005;
(statearr_72032[(7)] = inst_71969);

return statearr_72032;
})();
if(inst_71970){
var statearr_72033_72059 = state_72005__$1;
(statearr_72033_72059[(1)] = (10));

} else {
var statearr_72034_72060 = state_72005__$1;
(statearr_72034_72060[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__15091__auto____0 = (function (){
var statearr_72035 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72035[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__15091__auto__);

(statearr_72035[(1)] = (1));

return statearr_72035;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__15091__auto____1 = (function (state_72005){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_72005);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e72036){var ex__15094__auto__ = e72036;
var statearr_72037_72061 = state_72005;
(statearr_72037_72061[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_72005[(4)]))){
var statearr_72038_72062 = state_72005;
(statearr_72038_72062[(1)] = cljs.core.first((state_72005[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__72063 = state_72005;
state_72005 = G__72063;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__15091__auto__ = function(state_72005){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__15091__auto____1.call(this,state_72005);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_72039 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_72039[(6)] = c__15165__auto__);

return statearr_72039;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?o",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_72102){
var state_val_72103 = (state_72102[(1)]);
if((state_val_72103 === (7))){
var inst_72070 = (state_72102[(7)]);
var state_72102__$1 = state_72102;
var statearr_72104_72128 = state_72102__$1;
(statearr_72104_72128[(2)] = inst_72070);

(statearr_72104_72128[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72103 === (1))){
var state_72102__$1 = state_72102;
var statearr_72105_72129 = state_72102__$1;
(statearr_72105_72129[(2)] = null);

(statearr_72105_72129[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72103 === (4))){
var inst_72064 = (state_72102[(2)]);
var state_72102__$1 = state_72102;
var statearr_72106_72130 = state_72102__$1;
(statearr_72106_72130[(2)] = inst_72064);

(statearr_72106_72130[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72103 === (6))){
var inst_72072 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_72102__$1 = state_72102;
var statearr_72107_72131 = state_72102__$1;
(statearr_72107_72131[(2)] = inst_72072);

(statearr_72107_72131[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72103 === (3))){
var inst_72100 = (state_72102[(2)]);
var state_72102__$1 = state_72102;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72102__$1,inst_72100);
} else {
if((state_val_72103 === (12))){
var inst_72082 = (state_72102[(2)]);
var inst_72083 = fluree.db.util.async.throw_err(inst_72082);
var inst_72084 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72083,(0),null);
var inst_72085 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72083,(1),null);
var inst_72086 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72087 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72088 = ["?pO","?ctx",inst_72084];
var inst_72089 = cljs.core.PersistentHashMap.fromArrays(inst_72087,inst_72088);
var inst_72090 = ((10) + inst_72085);
var inst_72091 = [inst_72089,inst_72090];
var inst_72092 = (new cljs.core.PersistentVector(null,2,(5),inst_72086,inst_72091,null));
var inst_72093 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72092);
var state_72102__$1 = (function (){var statearr_72108 = state_72102;
(statearr_72108[(8)] = inst_72093);

return statearr_72108;
})();
var statearr_72109_72132 = state_72102__$1;
(statearr_72109_72132[(2)] = inst_72084);

(statearr_72109_72132[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72103 === (2))){
var inst_72070 = (state_72102[(7)]);
var _ = (function (){var statearr_72110 = state_72102;
(statearr_72110[(4)] = cljs.core.cons((5),(state_72102[(4)])));

return statearr_72110;
})();
var inst_72070__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_72102__$1 = (function (){var statearr_72111 = state_72102;
(statearr_72111[(7)] = inst_72070__$1);

return statearr_72111;
})();
if(cljs.core.truth_(inst_72070__$1)){
var statearr_72112_72133 = state_72102__$1;
(statearr_72112_72133[(1)] = (6));

} else {
var statearr_72113_72134 = state_72102__$1;
(statearr_72113_72134[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72103 === (11))){
var inst_72097 = (state_72102[(2)]);
var _ = (function (){var statearr_72115 = state_72102;
(statearr_72115[(4)] = cljs.core.rest((state_72102[(4)])));

return statearr_72115;
})();
var state_72102__$1 = state_72102;
var statearr_72116_72135 = state_72102__$1;
(statearr_72116_72135[(2)] = inst_72097);

(statearr_72116_72135[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72103 === (9))){
var inst_72080 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_72102__$1 = state_72102;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72102__$1,(12),inst_72080);
} else {
if((state_val_72103 === (5))){
var _ = (function (){var statearr_72117 = state_72102;
(statearr_72117[(4)] = cljs.core.rest((state_72102[(4)])));

return statearr_72117;
})();
var state_72102__$1 = state_72102;
var ex72114 = (state_72102__$1[(2)]);
var statearr_72118_72136 = state_72102__$1;
(statearr_72118_72136[(5)] = ex72114);


if((ex72114 instanceof Error)){
var statearr_72119_72137 = state_72102__$1;
(statearr_72119_72137[(1)] = (4));

(statearr_72119_72137[(5)] = null);

} else {
throw ex72114;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72103 === (10))){
var inst_72095 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_72102__$1 = state_72102;
var statearr_72120_72138 = state_72102__$1;
(statearr_72120_72138[(2)] = inst_72095);

(statearr_72120_72138[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72103 === (8))){
var inst_72075 = (state_72102[(2)]);
var state_72102__$1 = state_72102;
if(cljs.core.truth_(inst_72075)){
var statearr_72121_72139 = state_72102__$1;
(statearr_72121_72139[(1)] = (9));

} else {
var statearr_72122_72140 = state_72102__$1;
(statearr_72122_72140[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__15091__auto____0 = (function (){
var statearr_72123 = [null,null,null,null,null,null,null,null,null];
(statearr_72123[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__15091__auto__);

(statearr_72123[(1)] = (1));

return statearr_72123;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__15091__auto____1 = (function (state_72102){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_72102);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e72124){var ex__15094__auto__ = e72124;
var statearr_72125_72141 = state_72102;
(statearr_72125_72141[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_72102[(4)]))){
var statearr_72126_72142 = state_72102;
(statearr_72126_72142[(1)] = cljs.core.first((state_72102[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__72143 = state_72102;
state_72102 = G__72143;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__15091__auto__ = function(state_72102){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__15091__auto____1.call(this,state_72102);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_72127 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_72127[(6)] = c__15165__auto__);

return statearr_72127;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_72195){
var state_val_72196 = (state_72195[(1)]);
if((state_val_72196 === (7))){
var state_72195__$1 = state_72195;
var statearr_72197_72230 = state_72195__$1;
(statearr_72197_72230[(2)] = subject);

(statearr_72197_72230[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72196 === (1))){
var state_72195__$1 = state_72195;
var statearr_72198_72231 = state_72195__$1;
(statearr_72198_72231[(2)] = null);

(statearr_72198_72231[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72196 === (4))){
var inst_72144 = (state_72195[(2)]);
var state_72195__$1 = state_72195;
var statearr_72199_72232 = state_72195__$1;
(statearr_72199_72232[(2)] = inst_72144);

(statearr_72199_72232[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72196 === (15))){
var inst_72157 = (state_72195[(7)]);
var state_72195__$1 = state_72195;
var statearr_72200_72233 = state_72195__$1;
(statearr_72200_72233[(2)] = inst_72157);

(statearr_72200_72233[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72196 === (13))){
var inst_72161 = (state_72195[(2)]);
var inst_72162 = fluree.db.util.async.throw_err(inst_72161);
var state_72195__$1 = state_72195;
var statearr_72201_72234 = state_72195__$1;
(statearr_72201_72234[(2)] = inst_72162);

(statearr_72201_72234[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72196 === (6))){
var state_72195__$1 = state_72195;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72195__$1,(9),subject);
} else {
if((state_val_72196 === (17))){
var inst_72157 = (state_72195[(7)]);
var inst_72171 = cljs.core.first(inst_72157);
var state_72195__$1 = state_72195;
var statearr_72202_72235 = state_72195__$1;
(statearr_72202_72235[(2)] = inst_72171);

(statearr_72202_72235[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72196 === (3))){
var inst_72193 = (state_72195[(2)]);
var state_72195__$1 = state_72195;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72195__$1,inst_72193);
} else {
if((state_val_72196 === (12))){
var inst_72157 = (state_72195[(7)]);
var inst_72165 = (state_72195[(2)]);
var inst_72166 = cljs.core.vector_QMARK_(inst_72157);
var state_72195__$1 = (function (){var statearr_72203 = state_72195;
(statearr_72203[(8)] = inst_72165);

return statearr_72203;
})();
if(inst_72166){
var statearr_72204_72236 = state_72195__$1;
(statearr_72204_72236[(1)] = (14));

} else {
var statearr_72205_72237 = state_72195__$1;
(statearr_72205_72237[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72196 === (2))){
var _ = (function (){var statearr_72206 = state_72195;
(statearr_72206[(4)] = cljs.core.cons((5),(state_72195[(4)])));

return statearr_72206;
})();
var inst_72150 = fluree.db.util.async.channel_QMARK_(subject);
var state_72195__$1 = state_72195;
if(inst_72150){
var statearr_72207_72238 = state_72195__$1;
(statearr_72207_72238[(1)] = (6));

} else {
var statearr_72208_72239 = state_72195__$1;
(statearr_72208_72239[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72196 === (19))){
var inst_72174 = (state_72195[(2)]);
var state_72195__$1 = state_72195;
var statearr_72209_72240 = state_72195__$1;
(statearr_72209_72240[(2)] = inst_72174);

(statearr_72209_72240[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72196 === (11))){
var state_72195__$1 = state_72195;
var statearr_72211_72241 = state_72195__$1;
(statearr_72211_72241[(2)] = path);

(statearr_72211_72241[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72196 === (9))){
var inst_72153 = (state_72195[(2)]);
var inst_72154 = fluree.db.util.async.throw_err(inst_72153);
var state_72195__$1 = state_72195;
var statearr_72212_72242 = state_72195__$1;
(statearr_72212_72242[(2)] = inst_72154);

(statearr_72212_72242[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72196 === (5))){
var _ = (function (){var statearr_72213 = state_72195;
(statearr_72213[(4)] = cljs.core.rest((state_72195[(4)])));

return statearr_72213;
})();
var state_72195__$1 = state_72195;
var ex72210 = (state_72195__$1[(2)]);
var statearr_72214_72243 = state_72195__$1;
(statearr_72214_72243[(5)] = ex72210);


if((ex72210 instanceof Error)){
var statearr_72215_72244 = state_72195__$1;
(statearr_72215_72244[(1)] = (4));

(statearr_72215_72244[(5)] = null);

} else {
throw ex72210;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72196 === (14))){
var inst_72157 = (state_72195[(7)]);
var inst_72168 = cljs.core.count(inst_72157);
var inst_72169 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_72168);
var state_72195__$1 = state_72195;
if(inst_72169){
var statearr_72216_72245 = state_72195__$1;
(statearr_72216_72245[(1)] = (17));

} else {
var statearr_72217_72246 = state_72195__$1;
(statearr_72217_72246[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72196 === (16))){
var inst_72165 = (state_72195[(8)]);
var inst_72157 = (state_72195[(7)]);
var inst_72177 = (state_72195[(2)]);
var inst_72178 = fluree.db.dbfunctions.internal.get_all(inst_72177,inst_72165);
var inst_72179 = cljs.core.count(inst_72165);
var inst_72180 = ((9) + inst_72179);
var inst_72181 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72182 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72183 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72184 = [inst_72157,inst_72165];
var inst_72185 = (new cljs.core.PersistentVector(null,2,(5),inst_72183,inst_72184,null));
var inst_72186 = ["get-all",inst_72185,inst_72178];
var inst_72187 = cljs.core.PersistentHashMap.fromArrays(inst_72182,inst_72186);
var inst_72188 = [inst_72187,inst_72180];
var inst_72189 = (new cljs.core.PersistentVector(null,2,(5),inst_72181,inst_72188,null));
var inst_72190 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72189);
var _ = (function (){var statearr_72218 = state_72195;
(statearr_72218[(4)] = cljs.core.rest((state_72195[(4)])));

return statearr_72218;
})();
var state_72195__$1 = (function (){var statearr_72219 = state_72195;
(statearr_72219[(9)] = inst_72190);

return statearr_72219;
})();
var statearr_72220_72247 = state_72195__$1;
(statearr_72220_72247[(2)] = inst_72178);

(statearr_72220_72247[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72196 === (10))){
var state_72195__$1 = state_72195;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72195__$1,(13),path);
} else {
if((state_val_72196 === (18))){
var inst_72157 = (state_72195[(7)]);
var state_72195__$1 = state_72195;
var statearr_72221_72248 = state_72195__$1;
(statearr_72221_72248[(2)] = inst_72157);

(statearr_72221_72248[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72196 === (8))){
var inst_72157 = (state_72195[(2)]);
var inst_72158 = fluree.db.util.async.channel_QMARK_(path);
var state_72195__$1 = (function (){var statearr_72222 = state_72195;
(statearr_72222[(7)] = inst_72157);

return statearr_72222;
})();
if(inst_72158){
var statearr_72223_72249 = state_72195__$1;
(statearr_72223_72249[(1)] = (10));

} else {
var statearr_72224_72250 = state_72195__$1;
(statearr_72224_72250[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__15091__auto____0 = (function (){
var statearr_72225 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72225[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__15091__auto__);

(statearr_72225[(1)] = (1));

return statearr_72225;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__15091__auto____1 = (function (state_72195){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_72195);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e72226){var ex__15094__auto__ = e72226;
var statearr_72227_72251 = state_72195;
(statearr_72227_72251[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_72195[(4)]))){
var statearr_72228_72252 = state_72195;
(statearr_72228_72252[(1)] = cljs.core.first((state_72195[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__72253 = state_72195;
state_72195 = G__72253;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__15091__auto__ = function(state_72195){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__15091__auto____1.call(this,state_72195);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_72229 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_72229[(6)] = c__15165__auto__);

return statearr_72229;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_72292){
var state_val_72293 = (state_72292[(1)]);
if((state_val_72293 === (7))){
var state_72292__$1 = state_72292;
var statearr_72294_72318 = state_72292__$1;
(statearr_72294_72318[(2)] = subject);

(statearr_72294_72318[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72293 === (1))){
var state_72292__$1 = state_72292;
var statearr_72295_72319 = state_72292__$1;
(statearr_72295_72319[(2)] = null);

(statearr_72295_72319[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72293 === (4))){
var inst_72254 = (state_72292[(2)]);
var state_72292__$1 = state_72292;
var statearr_72296_72320 = state_72292__$1;
(statearr_72296_72320[(2)] = inst_72254);

(statearr_72296_72320[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72293 === (13))){
var inst_72271 = (state_72292[(2)]);
var inst_72272 = fluree.db.util.async.throw_err(inst_72271);
var state_72292__$1 = state_72292;
var statearr_72297_72321 = state_72292__$1;
(statearr_72297_72321[(2)] = inst_72272);

(statearr_72297_72321[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72293 === (6))){
var state_72292__$1 = state_72292;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72292__$1,(9),subject);
} else {
if((state_val_72293 === (3))){
var inst_72290 = (state_72292[(2)]);
var state_72292__$1 = state_72292;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72292__$1,inst_72290);
} else {
if((state_val_72293 === (12))){
var inst_72267 = (state_72292[(7)]);
var inst_72275 = (state_72292[(2)]);
var inst_72276 = fluree.db.dbfunctions.internal.get_in(inst_72267,inst_72275);
var inst_72277 = cljs.core.count(inst_72275);
var inst_72278 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72279 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72280 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72281 = [inst_72267,inst_72275];
var inst_72282 = (new cljs.core.PersistentVector(null,2,(5),inst_72280,inst_72281,null));
var inst_72283 = ["get-in",inst_72282,inst_72276];
var inst_72284 = cljs.core.PersistentHashMap.fromArrays(inst_72279,inst_72283);
var inst_72285 = [inst_72284,inst_72277];
var inst_72286 = (new cljs.core.PersistentVector(null,2,(5),inst_72278,inst_72285,null));
var inst_72287 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72286);
var _ = (function (){var statearr_72298 = state_72292;
(statearr_72298[(4)] = cljs.core.rest((state_72292[(4)])));

return statearr_72298;
})();
var state_72292__$1 = (function (){var statearr_72299 = state_72292;
(statearr_72299[(8)] = inst_72287);

return statearr_72299;
})();
var statearr_72300_72322 = state_72292__$1;
(statearr_72300_72322[(2)] = inst_72276);

(statearr_72300_72322[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72293 === (2))){
var _ = (function (){var statearr_72301 = state_72292;
(statearr_72301[(4)] = cljs.core.cons((5),(state_72292[(4)])));

return statearr_72301;
})();
var inst_72260 = fluree.db.util.async.channel_QMARK_(subject);
var state_72292__$1 = state_72292;
if(inst_72260){
var statearr_72302_72323 = state_72292__$1;
(statearr_72302_72323[(1)] = (6));

} else {
var statearr_72303_72324 = state_72292__$1;
(statearr_72303_72324[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72293 === (11))){
var state_72292__$1 = state_72292;
var statearr_72305_72325 = state_72292__$1;
(statearr_72305_72325[(2)] = path);

(statearr_72305_72325[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72293 === (9))){
var inst_72263 = (state_72292[(2)]);
var inst_72264 = fluree.db.util.async.throw_err(inst_72263);
var state_72292__$1 = state_72292;
var statearr_72306_72326 = state_72292__$1;
(statearr_72306_72326[(2)] = inst_72264);

(statearr_72306_72326[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72293 === (5))){
var _ = (function (){var statearr_72307 = state_72292;
(statearr_72307[(4)] = cljs.core.rest((state_72292[(4)])));

return statearr_72307;
})();
var state_72292__$1 = state_72292;
var ex72304 = (state_72292__$1[(2)]);
var statearr_72308_72327 = state_72292__$1;
(statearr_72308_72327[(5)] = ex72304);


if((ex72304 instanceof Error)){
var statearr_72309_72328 = state_72292__$1;
(statearr_72309_72328[(1)] = (4));

(statearr_72309_72328[(5)] = null);

} else {
throw ex72304;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72293 === (10))){
var state_72292__$1 = state_72292;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72292__$1,(13),path);
} else {
if((state_val_72293 === (8))){
var inst_72267 = (state_72292[(2)]);
var inst_72268 = fluree.db.util.async.channel_QMARK_(path);
var state_72292__$1 = (function (){var statearr_72310 = state_72292;
(statearr_72310[(7)] = inst_72267);

return statearr_72310;
})();
if(inst_72268){
var statearr_72311_72329 = state_72292__$1;
(statearr_72311_72329[(1)] = (10));

} else {
var statearr_72312_72330 = state_72292__$1;
(statearr_72312_72330[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__15091__auto____0 = (function (){
var statearr_72313 = [null,null,null,null,null,null,null,null,null];
(statearr_72313[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__15091__auto__);

(statearr_72313[(1)] = (1));

return statearr_72313;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__15091__auto____1 = (function (state_72292){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_72292);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e72314){var ex__15094__auto__ = e72314;
var statearr_72315_72331 = state_72292;
(statearr_72315_72331[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_72292[(4)]))){
var statearr_72316_72332 = state_72292;
(statearr_72316_72332[(1)] = cljs.core.first((state_72292[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__72333 = state_72292;
state_72292 = G__72333;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__15091__auto__ = function(state_72292){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__15091__auto____1.call(this,state_72292);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_72317 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_72317[(6)] = c__15165__auto__);

return statearr_72317;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_72378){
var state_val_72379 = (state_72378[(1)]);
if((state_val_72379 === (7))){
var state_72378__$1 = state_72378;
var statearr_72380_72409 = state_72378__$1;
(statearr_72380_72409[(2)] = coll);

(statearr_72380_72409[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72379 === (1))){
var state_72378__$1 = state_72378;
var statearr_72381_72410 = state_72378__$1;
(statearr_72381_72410[(2)] = null);

(statearr_72381_72410[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72379 === (4))){
var inst_72334 = (state_72378[(2)]);
var state_72378__$1 = state_72378;
var statearr_72382_72411 = state_72378__$1;
(statearr_72382_72411[(2)] = inst_72334);

(statearr_72382_72411[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72379 === (15))){
var inst_72354 = (state_72378[(7)]);
var inst_72362 = (state_72378[(2)]);
var inst_72363 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_72354,inst_72362);
var inst_72364 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72365 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72366 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72367 = [inst_72354,inst_72362];
var inst_72368 = (new cljs.core.PersistentVector(null,2,(5),inst_72366,inst_72367,null));
var inst_72369 = ["contains?",inst_72368,inst_72363];
var inst_72370 = cljs.core.PersistentHashMap.fromArrays(inst_72365,inst_72369);
var inst_72371 = [inst_72370,(10)];
var inst_72372 = (new cljs.core.PersistentVector(null,2,(5),inst_72364,inst_72371,null));
var inst_72373 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72372);
var _ = (function (){var statearr_72383 = state_72378;
(statearr_72383[(4)] = cljs.core.rest((state_72378[(4)])));

return statearr_72383;
})();
var state_72378__$1 = (function (){var statearr_72384 = state_72378;
(statearr_72384[(8)] = inst_72373);

return statearr_72384;
})();
var statearr_72385_72412 = state_72378__$1;
(statearr_72385_72412[(2)] = inst_72363);

(statearr_72385_72412[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72379 === (13))){
var state_72378__$1 = state_72378;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72378__$1,(16),key);
} else {
if((state_val_72379 === (6))){
var state_72378__$1 = state_72378;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72378__$1,(9),coll);
} else {
if((state_val_72379 === (3))){
var inst_72376 = (state_72378[(2)]);
var state_72378__$1 = state_72378;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72378__$1,inst_72376);
} else {
if((state_val_72379 === (12))){
var inst_72354 = (state_72378[(2)]);
var inst_72355 = fluree.db.util.async.channel_QMARK_(key);
var state_72378__$1 = (function (){var statearr_72386 = state_72378;
(statearr_72386[(7)] = inst_72354);

return statearr_72386;
})();
if(inst_72355){
var statearr_72387_72413 = state_72378__$1;
(statearr_72387_72413[(1)] = (13));

} else {
var statearr_72388_72414 = state_72378__$1;
(statearr_72388_72414[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72379 === (2))){
var _ = (function (){var statearr_72389 = state_72378;
(statearr_72389[(4)] = cljs.core.cons((5),(state_72378[(4)])));

return statearr_72389;
})();
var inst_72340 = fluree.db.util.async.channel_QMARK_(coll);
var state_72378__$1 = state_72378;
if(inst_72340){
var statearr_72390_72415 = state_72378__$1;
(statearr_72390_72415[(1)] = (6));

} else {
var statearr_72391_72416 = state_72378__$1;
(statearr_72391_72416[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72379 === (11))){
var inst_72347 = (state_72378[(9)]);
var inst_72351 = cljs.core.flatten(inst_72347);
var inst_72352 = cljs.core.set(inst_72351);
var state_72378__$1 = state_72378;
var statearr_72393_72417 = state_72378__$1;
(statearr_72393_72417[(2)] = inst_72352);

(statearr_72393_72417[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72379 === (9))){
var inst_72343 = (state_72378[(2)]);
var inst_72344 = fluree.db.util.async.throw_err(inst_72343);
var state_72378__$1 = state_72378;
var statearr_72394_72418 = state_72378__$1;
(statearr_72394_72418[(2)] = inst_72344);

(statearr_72394_72418[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72379 === (5))){
var _ = (function (){var statearr_72395 = state_72378;
(statearr_72395[(4)] = cljs.core.rest((state_72378[(4)])));

return statearr_72395;
})();
var state_72378__$1 = state_72378;
var ex72392 = (state_72378__$1[(2)]);
var statearr_72396_72419 = state_72378__$1;
(statearr_72396_72419[(5)] = ex72392);


if((ex72392 instanceof Error)){
var statearr_72397_72420 = state_72378__$1;
(statearr_72397_72420[(1)] = (4));

(statearr_72397_72420[(5)] = null);

} else {
throw ex72392;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72379 === (14))){
var state_72378__$1 = state_72378;
var statearr_72398_72421 = state_72378__$1;
(statearr_72398_72421[(2)] = key);

(statearr_72398_72421[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72379 === (16))){
var inst_72358 = (state_72378[(2)]);
var inst_72359 = fluree.db.util.async.throw_err(inst_72358);
var state_72378__$1 = state_72378;
var statearr_72399_72422 = state_72378__$1;
(statearr_72399_72422[(2)] = inst_72359);

(statearr_72399_72422[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72379 === (10))){
var inst_72347 = (state_72378[(9)]);
var state_72378__$1 = state_72378;
var statearr_72400_72423 = state_72378__$1;
(statearr_72400_72423[(2)] = inst_72347);

(statearr_72400_72423[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72379 === (8))){
var inst_72347 = (state_72378[(9)]);
var inst_72347__$1 = (state_72378[(2)]);
var inst_72348 = cljs.core.set_QMARK_(inst_72347__$1);
var state_72378__$1 = (function (){var statearr_72401 = state_72378;
(statearr_72401[(9)] = inst_72347__$1);

return statearr_72401;
})();
if(inst_72348){
var statearr_72402_72424 = state_72378__$1;
(statearr_72402_72424[(1)] = (10));

} else {
var statearr_72403_72425 = state_72378__$1;
(statearr_72403_72425[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__15091__auto____0 = (function (){
var statearr_72404 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72404[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__15091__auto__);

(statearr_72404[(1)] = (1));

return statearr_72404;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__15091__auto____1 = (function (state_72378){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_72378);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e72405){var ex__15094__auto__ = e72405;
var statearr_72406_72426 = state_72378;
(statearr_72406_72426[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_72378[(4)]))){
var statearr_72407_72427 = state_72378;
(statearr_72407_72427[(1)] = cljs.core.first((state_72378[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__72428 = state_72378;
state_72378 = G__72428;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__15091__auto__ = function(state_72378){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__15091__auto____1.call(this,state_72378);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_72408 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_72408[(6)] = c__15165__auto__);

return statearr_72408;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__5774__auto__ = [];
var len__5768__auto___72500 = arguments.length;
var i__5769__auto___72501 = (0);
while(true){
if((i__5769__auto___72501 < len__5768__auto___72500)){
args__5774__auto__.push((arguments[i__5769__auto___72501]));

var G__72502 = (i__5769__auto___72501 + (1));
i__5769__auto___72501 = G__72502;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_72474){
var state_val_72475 = (state_72474[(1)]);
if((state_val_72475 === (7))){
var inst_72440 = (state_72474[(7)]);
var inst_72444 = cljs.core.first(inst_72440);
var inst_72445 = cljs.core.coll_QMARK_(inst_72444);
var state_72474__$1 = state_72474;
var statearr_72476_72503 = state_72474__$1;
(statearr_72476_72503[(2)] = inst_72445);

(statearr_72476_72503[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72475 === (1))){
var state_72474__$1 = state_72474;
var statearr_72477_72504 = state_72474__$1;
(statearr_72477_72504[(2)] = null);

(statearr_72477_72504[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72475 === (4))){
var inst_72431 = (state_72474[(2)]);
var state_72474__$1 = state_72474;
var statearr_72478_72505 = state_72474__$1;
(statearr_72478_72505[(2)] = inst_72431);

(statearr_72478_72505[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72475 === (6))){
var inst_72440 = (state_72474[(7)]);
var inst_72442 = (state_72474[(8)]);
var inst_72439 = (state_72474[(2)]);
var inst_72440__$1 = fluree.db.util.async.throw_err(inst_72439);
var inst_72441 = cljs.core.count(inst_72440__$1);
var inst_72442__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_72441);
var state_72474__$1 = (function (){var statearr_72479 = state_72474;
(statearr_72479[(7)] = inst_72440__$1);

(statearr_72479[(8)] = inst_72442__$1);

return statearr_72479;
})();
if(inst_72442__$1){
var statearr_72480_72506 = state_72474__$1;
(statearr_72480_72506[(1)] = (7));

} else {
var statearr_72481_72507 = state_72474__$1;
(statearr_72481_72507[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72475 === (3))){
var inst_72472 = (state_72474[(2)]);
var state_72474__$1 = state_72474;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72474__$1,inst_72472);
} else {
if((state_val_72475 === (12))){
var inst_72453 = (state_72474[(2)]);
var inst_72454 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_72453);
var inst_72455 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72456 = [inst_72453];
var inst_72457 = (new cljs.core.PersistentVector(null,1,(5),inst_72455,inst_72456,null));
var inst_72458 = cljs.core.count(inst_72457);
var inst_72459 = ((9) + inst_72458);
var inst_72460 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72461 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72462 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72463 = [inst_72453];
var inst_72464 = (new cljs.core.PersistentVector(null,1,(5),inst_72462,inst_72463,null));
var inst_72465 = ["hash-set",inst_72464,inst_72454];
var inst_72466 = cljs.core.PersistentHashMap.fromArrays(inst_72461,inst_72465);
var inst_72467 = [inst_72466,inst_72459];
var inst_72468 = (new cljs.core.PersistentVector(null,2,(5),inst_72460,inst_72467,null));
var inst_72469 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72468);
var _ = (function (){var statearr_72482 = state_72474;
(statearr_72482[(4)] = cljs.core.rest((state_72474[(4)])));

return statearr_72482;
})();
var state_72474__$1 = (function (){var statearr_72483 = state_72474;
(statearr_72483[(9)] = inst_72469);

return statearr_72483;
})();
var statearr_72484_72508 = state_72474__$1;
(statearr_72484_72508[(2)] = inst_72454);

(statearr_72484_72508[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72475 === (2))){
var _ = (function (){var statearr_72485 = state_72474;
(statearr_72485[(4)] = cljs.core.cons((5),(state_72474[(4)])));

return statearr_72485;
})();
var inst_72437 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72474__$1 = state_72474;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72474__$1,(6),inst_72437);
} else {
if((state_val_72475 === (11))){
var inst_72440 = (state_72474[(7)]);
var state_72474__$1 = state_72474;
var statearr_72487_72509 = state_72474__$1;
(statearr_72487_72509[(2)] = inst_72440);

(statearr_72487_72509[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72475 === (9))){
var inst_72448 = (state_72474[(2)]);
var state_72474__$1 = state_72474;
if(cljs.core.truth_(inst_72448)){
var statearr_72488_72510 = state_72474__$1;
(statearr_72488_72510[(1)] = (10));

} else {
var statearr_72489_72511 = state_72474__$1;
(statearr_72489_72511[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72475 === (5))){
var _ = (function (){var statearr_72490 = state_72474;
(statearr_72490[(4)] = cljs.core.rest((state_72474[(4)])));

return statearr_72490;
})();
var state_72474__$1 = state_72474;
var ex72486 = (state_72474__$1[(2)]);
var statearr_72491_72512 = state_72474__$1;
(statearr_72491_72512[(5)] = ex72486);


if((ex72486 instanceof Error)){
var statearr_72492_72513 = state_72474__$1;
(statearr_72492_72513[(1)] = (4));

(statearr_72492_72513[(5)] = null);

} else {
throw ex72486;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72475 === (10))){
var inst_72440 = (state_72474[(7)]);
var inst_72450 = cljs.core.first(inst_72440);
var state_72474__$1 = state_72474;
var statearr_72493_72514 = state_72474__$1;
(statearr_72493_72514[(2)] = inst_72450);

(statearr_72493_72514[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72475 === (8))){
var inst_72442 = (state_72474[(8)]);
var state_72474__$1 = state_72474;
var statearr_72494_72515 = state_72474__$1;
(statearr_72494_72515[(2)] = inst_72442);

(statearr_72494_72515[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__15091__auto____0 = (function (){
var statearr_72495 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72495[(0)] = fluree$db$dbfunctions$fns$state_machine__15091__auto__);

(statearr_72495[(1)] = (1));

return statearr_72495;
});
var fluree$db$dbfunctions$fns$state_machine__15091__auto____1 = (function (state_72474){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_72474);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e72496){var ex__15094__auto__ = e72496;
var statearr_72497_72516 = state_72474;
(statearr_72497_72516[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_72474[(4)]))){
var statearr_72498_72517 = state_72474;
(statearr_72498_72517[(1)] = cljs.core.first((state_72474[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__72518 = state_72474;
state_72474 = G__72518;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__15091__auto__ = function(state_72474){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____1.call(this,state_72474);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_72499 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_72499[(6)] = c__15165__auto__);

return statearr_72499;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq72429){
var G__72430 = cljs.core.first(seq72429);
var seq72429__$1 = cljs.core.next(seq72429);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72430,seq72429__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___72568 = arguments.length;
var i__5769__auto___72569 = (0);
while(true){
if((i__5769__auto___72569 < len__5768__auto___72568)){
args__5774__auto__.push((arguments[i__5769__auto___72569]));

var G__72570 = (i__5769__auto___72569 + (1));
i__5769__auto___72569 = G__72570;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_72551){
var state_val_72552 = (state_72551[(1)]);
if((state_val_72552 === (1))){
var state_72551__$1 = state_72551;
var statearr_72553_72571 = state_72551__$1;
(statearr_72553_72571[(2)] = null);

(statearr_72553_72571[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72552 === (2))){
var _ = (function (){var statearr_72554 = state_72551;
(statearr_72554[(4)] = cljs.core.cons((5),(state_72551[(4)])));

return statearr_72554;
})();
var inst_72527 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72551__$1 = state_72551;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72551__$1,(6),inst_72527);
} else {
if((state_val_72552 === (3))){
var inst_72549 = (state_72551[(2)]);
var state_72551__$1 = state_72551;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72551__$1,inst_72549);
} else {
if((state_val_72552 === (4))){
var inst_72521 = (state_72551[(2)]);
var state_72551__$1 = state_72551;
var statearr_72556_72572 = state_72551__$1;
(statearr_72556_72572[(2)] = inst_72521);

(statearr_72556_72572[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72552 === (5))){
var _ = (function (){var statearr_72557 = state_72551;
(statearr_72557[(4)] = cljs.core.rest((state_72551[(4)])));

return statearr_72557;
})();
var state_72551__$1 = state_72551;
var ex72555 = (state_72551__$1[(2)]);
var statearr_72558_72573 = state_72551__$1;
(statearr_72558_72573[(5)] = ex72555);


if((ex72555 instanceof Error)){
var statearr_72559_72574 = state_72551__$1;
(statearr_72559_72574[(1)] = (4));

(statearr_72559_72574[(5)] = null);

} else {
throw ex72555;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72552 === (6))){
var inst_72529 = (state_72551[(2)]);
var inst_72530 = fluree.db.util.async.throw_err(inst_72529);
var inst_72531 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_72530);
var inst_72532 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72533 = [inst_72530];
var inst_72534 = (new cljs.core.PersistentVector(null,1,(5),inst_72532,inst_72533,null));
var inst_72535 = cljs.core.count(inst_72534);
var inst_72536 = ((9) + inst_72535);
var inst_72537 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72538 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72539 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72540 = [inst_72530];
var inst_72541 = (new cljs.core.PersistentVector(null,1,(5),inst_72539,inst_72540,null));
var inst_72542 = ["==",inst_72541,inst_72531];
var inst_72543 = cljs.core.PersistentHashMap.fromArrays(inst_72538,inst_72542);
var inst_72544 = [inst_72543,inst_72536];
var inst_72545 = (new cljs.core.PersistentVector(null,2,(5),inst_72537,inst_72544,null));
var inst_72546 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72545);
var _ = (function (){var statearr_72560 = state_72551;
(statearr_72560[(4)] = cljs.core.rest((state_72551[(4)])));

return statearr_72560;
})();
var state_72551__$1 = (function (){var statearr_72561 = state_72551;
(statearr_72561[(7)] = inst_72546);

return statearr_72561;
})();
var statearr_72562_72575 = state_72551__$1;
(statearr_72562_72575[(2)] = inst_72531);

(statearr_72562_72575[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__15091__auto____0 = (function (){
var statearr_72563 = [null,null,null,null,null,null,null,null];
(statearr_72563[(0)] = fluree$db$dbfunctions$fns$state_machine__15091__auto__);

(statearr_72563[(1)] = (1));

return statearr_72563;
});
var fluree$db$dbfunctions$fns$state_machine__15091__auto____1 = (function (state_72551){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_72551);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e72564){var ex__15094__auto__ = e72564;
var statearr_72565_72576 = state_72551;
(statearr_72565_72576[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_72551[(4)]))){
var statearr_72566_72577 = state_72551;
(statearr_72566_72577[(1)] = cljs.core.first((state_72551[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__72578 = state_72551;
state_72551 = G__72578;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__15091__auto__ = function(state_72551){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____1.call(this,state_72551);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_72567 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_72567[(6)] = c__15165__auto__);

return statearr_72567;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq72519){
var G__72520 = cljs.core.first(seq72519);
var seq72519__$1 = cljs.core.next(seq72519);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72520,seq72519__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___72628 = arguments.length;
var i__5769__auto___72629 = (0);
while(true){
if((i__5769__auto___72629 < len__5768__auto___72628)){
args__5774__auto__.push((arguments[i__5769__auto___72629]));

var G__72630 = (i__5769__auto___72629 + (1));
i__5769__auto___72629 = G__72630;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_72611){
var state_val_72612 = (state_72611[(1)]);
if((state_val_72612 === (1))){
var state_72611__$1 = state_72611;
var statearr_72613_72631 = state_72611__$1;
(statearr_72613_72631[(2)] = null);

(statearr_72613_72631[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72612 === (2))){
var _ = (function (){var statearr_72614 = state_72611;
(statearr_72614[(4)] = cljs.core.cons((5),(state_72611[(4)])));

return statearr_72614;
})();
var inst_72587 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72611__$1 = state_72611;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72611__$1,(6),inst_72587);
} else {
if((state_val_72612 === (3))){
var inst_72609 = (state_72611[(2)]);
var state_72611__$1 = state_72611;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72611__$1,inst_72609);
} else {
if((state_val_72612 === (4))){
var inst_72581 = (state_72611[(2)]);
var state_72611__$1 = state_72611;
var statearr_72616_72632 = state_72611__$1;
(statearr_72616_72632[(2)] = inst_72581);

(statearr_72616_72632[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72612 === (5))){
var _ = (function (){var statearr_72617 = state_72611;
(statearr_72617[(4)] = cljs.core.rest((state_72611[(4)])));

return statearr_72617;
})();
var state_72611__$1 = state_72611;
var ex72615 = (state_72611__$1[(2)]);
var statearr_72618_72633 = state_72611__$1;
(statearr_72618_72633[(5)] = ex72615);


if((ex72615 instanceof Error)){
var statearr_72619_72634 = state_72611__$1;
(statearr_72619_72634[(1)] = (4));

(statearr_72619_72634[(5)] = null);

} else {
throw ex72615;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72612 === (6))){
var inst_72589 = (state_72611[(2)]);
var inst_72590 = fluree.db.util.async.throw_err(inst_72589);
var inst_72591 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_72590);
var inst_72592 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72593 = [inst_72590];
var inst_72594 = (new cljs.core.PersistentVector(null,1,(5),inst_72592,inst_72593,null));
var inst_72595 = cljs.core.count(inst_72594);
var inst_72596 = ((9) + inst_72595);
var inst_72597 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72598 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72599 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72600 = [inst_72590];
var inst_72601 = (new cljs.core.PersistentVector(null,1,(5),inst_72599,inst_72600,null));
var inst_72602 = [">",inst_72601,inst_72591];
var inst_72603 = cljs.core.PersistentHashMap.fromArrays(inst_72598,inst_72602);
var inst_72604 = [inst_72603,inst_72596];
var inst_72605 = (new cljs.core.PersistentVector(null,2,(5),inst_72597,inst_72604,null));
var inst_72606 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72605);
var _ = (function (){var statearr_72620 = state_72611;
(statearr_72620[(4)] = cljs.core.rest((state_72611[(4)])));

return statearr_72620;
})();
var state_72611__$1 = (function (){var statearr_72621 = state_72611;
(statearr_72621[(7)] = inst_72606);

return statearr_72621;
})();
var statearr_72622_72635 = state_72611__$1;
(statearr_72622_72635[(2)] = inst_72591);

(statearr_72622_72635[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__15091__auto____0 = (function (){
var statearr_72623 = [null,null,null,null,null,null,null,null];
(statearr_72623[(0)] = fluree$db$dbfunctions$fns$state_machine__15091__auto__);

(statearr_72623[(1)] = (1));

return statearr_72623;
});
var fluree$db$dbfunctions$fns$state_machine__15091__auto____1 = (function (state_72611){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_72611);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e72624){var ex__15094__auto__ = e72624;
var statearr_72625_72636 = state_72611;
(statearr_72625_72636[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_72611[(4)]))){
var statearr_72626_72637 = state_72611;
(statearr_72626_72637[(1)] = cljs.core.first((state_72611[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__72638 = state_72611;
state_72611 = G__72638;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__15091__auto__ = function(state_72611){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____1.call(this,state_72611);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_72627 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_72627[(6)] = c__15165__auto__);

return statearr_72627;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq72579){
var G__72580 = cljs.core.first(seq72579);
var seq72579__$1 = cljs.core.next(seq72579);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72580,seq72579__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___72688 = arguments.length;
var i__5769__auto___72689 = (0);
while(true){
if((i__5769__auto___72689 < len__5768__auto___72688)){
args__5774__auto__.push((arguments[i__5769__auto___72689]));

var G__72690 = (i__5769__auto___72689 + (1));
i__5769__auto___72689 = G__72690;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_72671){
var state_val_72672 = (state_72671[(1)]);
if((state_val_72672 === (1))){
var state_72671__$1 = state_72671;
var statearr_72673_72691 = state_72671__$1;
(statearr_72673_72691[(2)] = null);

(statearr_72673_72691[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72672 === (2))){
var _ = (function (){var statearr_72674 = state_72671;
(statearr_72674[(4)] = cljs.core.cons((5),(state_72671[(4)])));

return statearr_72674;
})();
var inst_72647 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72671__$1 = state_72671;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72671__$1,(6),inst_72647);
} else {
if((state_val_72672 === (3))){
var inst_72669 = (state_72671[(2)]);
var state_72671__$1 = state_72671;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72671__$1,inst_72669);
} else {
if((state_val_72672 === (4))){
var inst_72641 = (state_72671[(2)]);
var state_72671__$1 = state_72671;
var statearr_72676_72692 = state_72671__$1;
(statearr_72676_72692[(2)] = inst_72641);

(statearr_72676_72692[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72672 === (5))){
var _ = (function (){var statearr_72677 = state_72671;
(statearr_72677[(4)] = cljs.core.rest((state_72671[(4)])));

return statearr_72677;
})();
var state_72671__$1 = state_72671;
var ex72675 = (state_72671__$1[(2)]);
var statearr_72678_72693 = state_72671__$1;
(statearr_72678_72693[(5)] = ex72675);


if((ex72675 instanceof Error)){
var statearr_72679_72694 = state_72671__$1;
(statearr_72679_72694[(1)] = (4));

(statearr_72679_72694[(5)] = null);

} else {
throw ex72675;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72672 === (6))){
var inst_72649 = (state_72671[(2)]);
var inst_72650 = fluree.db.util.async.throw_err(inst_72649);
var inst_72651 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_72650);
var inst_72652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72653 = [inst_72650];
var inst_72654 = (new cljs.core.PersistentVector(null,1,(5),inst_72652,inst_72653,null));
var inst_72655 = cljs.core.count(inst_72654);
var inst_72656 = ((9) + inst_72655);
var inst_72657 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72658 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72659 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72660 = [inst_72650];
var inst_72661 = (new cljs.core.PersistentVector(null,1,(5),inst_72659,inst_72660,null));
var inst_72662 = ["<",inst_72661,inst_72651];
var inst_72663 = cljs.core.PersistentHashMap.fromArrays(inst_72658,inst_72662);
var inst_72664 = [inst_72663,inst_72656];
var inst_72665 = (new cljs.core.PersistentVector(null,2,(5),inst_72657,inst_72664,null));
var inst_72666 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72665);
var _ = (function (){var statearr_72680 = state_72671;
(statearr_72680[(4)] = cljs.core.rest((state_72671[(4)])));

return statearr_72680;
})();
var state_72671__$1 = (function (){var statearr_72681 = state_72671;
(statearr_72681[(7)] = inst_72666);

return statearr_72681;
})();
var statearr_72682_72695 = state_72671__$1;
(statearr_72682_72695[(2)] = inst_72651);

(statearr_72682_72695[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__15091__auto____0 = (function (){
var statearr_72683 = [null,null,null,null,null,null,null,null];
(statearr_72683[(0)] = fluree$db$dbfunctions$fns$state_machine__15091__auto__);

(statearr_72683[(1)] = (1));

return statearr_72683;
});
var fluree$db$dbfunctions$fns$state_machine__15091__auto____1 = (function (state_72671){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_72671);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e72684){var ex__15094__auto__ = e72684;
var statearr_72685_72696 = state_72671;
(statearr_72685_72696[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_72671[(4)]))){
var statearr_72686_72697 = state_72671;
(statearr_72686_72697[(1)] = cljs.core.first((state_72671[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__72698 = state_72671;
state_72671 = G__72698;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__15091__auto__ = function(state_72671){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____1.call(this,state_72671);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_72687 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_72687[(6)] = c__15165__auto__);

return statearr_72687;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq72639){
var G__72640 = cljs.core.first(seq72639);
var seq72639__$1 = cljs.core.next(seq72639);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72640,seq72639__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___72748 = arguments.length;
var i__5769__auto___72749 = (0);
while(true){
if((i__5769__auto___72749 < len__5768__auto___72748)){
args__5774__auto__.push((arguments[i__5769__auto___72749]));

var G__72750 = (i__5769__auto___72749 + (1));
i__5769__auto___72749 = G__72750;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_72731){
var state_val_72732 = (state_72731[(1)]);
if((state_val_72732 === (1))){
var state_72731__$1 = state_72731;
var statearr_72733_72751 = state_72731__$1;
(statearr_72733_72751[(2)] = null);

(statearr_72733_72751[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72732 === (2))){
var _ = (function (){var statearr_72734 = state_72731;
(statearr_72734[(4)] = cljs.core.cons((5),(state_72731[(4)])));

return statearr_72734;
})();
var inst_72707 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72731__$1 = state_72731;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72731__$1,(6),inst_72707);
} else {
if((state_val_72732 === (3))){
var inst_72729 = (state_72731[(2)]);
var state_72731__$1 = state_72731;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72731__$1,inst_72729);
} else {
if((state_val_72732 === (4))){
var inst_72701 = (state_72731[(2)]);
var state_72731__$1 = state_72731;
var statearr_72736_72752 = state_72731__$1;
(statearr_72736_72752[(2)] = inst_72701);

(statearr_72736_72752[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72732 === (5))){
var _ = (function (){var statearr_72737 = state_72731;
(statearr_72737[(4)] = cljs.core.rest((state_72731[(4)])));

return statearr_72737;
})();
var state_72731__$1 = state_72731;
var ex72735 = (state_72731__$1[(2)]);
var statearr_72738_72753 = state_72731__$1;
(statearr_72738_72753[(5)] = ex72735);


if((ex72735 instanceof Error)){
var statearr_72739_72754 = state_72731__$1;
(statearr_72739_72754[(1)] = (4));

(statearr_72739_72754[(5)] = null);

} else {
throw ex72735;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72732 === (6))){
var inst_72709 = (state_72731[(2)]);
var inst_72710 = fluree.db.util.async.throw_err(inst_72709);
var inst_72711 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_72710);
var inst_72712 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72713 = [inst_72710];
var inst_72714 = (new cljs.core.PersistentVector(null,1,(5),inst_72712,inst_72713,null));
var inst_72715 = cljs.core.count(inst_72714);
var inst_72716 = ((9) + inst_72715);
var inst_72717 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72718 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72719 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72720 = [inst_72710];
var inst_72721 = (new cljs.core.PersistentVector(null,1,(5),inst_72719,inst_72720,null));
var inst_72722 = ["<=",inst_72721,inst_72711];
var inst_72723 = cljs.core.PersistentHashMap.fromArrays(inst_72718,inst_72722);
var inst_72724 = [inst_72723,inst_72716];
var inst_72725 = (new cljs.core.PersistentVector(null,2,(5),inst_72717,inst_72724,null));
var inst_72726 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72725);
var _ = (function (){var statearr_72740 = state_72731;
(statearr_72740[(4)] = cljs.core.rest((state_72731[(4)])));

return statearr_72740;
})();
var state_72731__$1 = (function (){var statearr_72741 = state_72731;
(statearr_72741[(7)] = inst_72726);

return statearr_72741;
})();
var statearr_72742_72755 = state_72731__$1;
(statearr_72742_72755[(2)] = inst_72711);

(statearr_72742_72755[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__15091__auto____0 = (function (){
var statearr_72743 = [null,null,null,null,null,null,null,null];
(statearr_72743[(0)] = fluree$db$dbfunctions$fns$state_machine__15091__auto__);

(statearr_72743[(1)] = (1));

return statearr_72743;
});
var fluree$db$dbfunctions$fns$state_machine__15091__auto____1 = (function (state_72731){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_72731);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e72744){var ex__15094__auto__ = e72744;
var statearr_72745_72756 = state_72731;
(statearr_72745_72756[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_72731[(4)]))){
var statearr_72746_72757 = state_72731;
(statearr_72746_72757[(1)] = cljs.core.first((state_72731[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__72758 = state_72731;
state_72731 = G__72758;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__15091__auto__ = function(state_72731){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____1.call(this,state_72731);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_72747 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_72747[(6)] = c__15165__auto__);

return statearr_72747;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq72699){
var G__72700 = cljs.core.first(seq72699);
var seq72699__$1 = cljs.core.next(seq72699);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72700,seq72699__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___72808 = arguments.length;
var i__5769__auto___72809 = (0);
while(true){
if((i__5769__auto___72809 < len__5768__auto___72808)){
args__5774__auto__.push((arguments[i__5769__auto___72809]));

var G__72810 = (i__5769__auto___72809 + (1));
i__5769__auto___72809 = G__72810;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_72791){
var state_val_72792 = (state_72791[(1)]);
if((state_val_72792 === (1))){
var state_72791__$1 = state_72791;
var statearr_72793_72811 = state_72791__$1;
(statearr_72793_72811[(2)] = null);

(statearr_72793_72811[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72792 === (2))){
var _ = (function (){var statearr_72794 = state_72791;
(statearr_72794[(4)] = cljs.core.cons((5),(state_72791[(4)])));

return statearr_72794;
})();
var inst_72767 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72791__$1 = state_72791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72791__$1,(6),inst_72767);
} else {
if((state_val_72792 === (3))){
var inst_72789 = (state_72791[(2)]);
var state_72791__$1 = state_72791;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72791__$1,inst_72789);
} else {
if((state_val_72792 === (4))){
var inst_72761 = (state_72791[(2)]);
var state_72791__$1 = state_72791;
var statearr_72796_72812 = state_72791__$1;
(statearr_72796_72812[(2)] = inst_72761);

(statearr_72796_72812[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72792 === (5))){
var _ = (function (){var statearr_72797 = state_72791;
(statearr_72797[(4)] = cljs.core.rest((state_72791[(4)])));

return statearr_72797;
})();
var state_72791__$1 = state_72791;
var ex72795 = (state_72791__$1[(2)]);
var statearr_72798_72813 = state_72791__$1;
(statearr_72798_72813[(5)] = ex72795);


if((ex72795 instanceof Error)){
var statearr_72799_72814 = state_72791__$1;
(statearr_72799_72814[(1)] = (4));

(statearr_72799_72814[(5)] = null);

} else {
throw ex72795;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72792 === (6))){
var inst_72769 = (state_72791[(2)]);
var inst_72770 = fluree.db.util.async.throw_err(inst_72769);
var inst_72771 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_72770);
var inst_72772 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72773 = [inst_72770];
var inst_72774 = (new cljs.core.PersistentVector(null,1,(5),inst_72772,inst_72773,null));
var inst_72775 = cljs.core.count(inst_72774);
var inst_72776 = ((9) + inst_72775);
var inst_72777 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72778 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72779 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72780 = [inst_72770];
var inst_72781 = (new cljs.core.PersistentVector(null,1,(5),inst_72779,inst_72780,null));
var inst_72782 = [">=",inst_72781,inst_72771];
var inst_72783 = cljs.core.PersistentHashMap.fromArrays(inst_72778,inst_72782);
var inst_72784 = [inst_72783,inst_72776];
var inst_72785 = (new cljs.core.PersistentVector(null,2,(5),inst_72777,inst_72784,null));
var inst_72786 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72785);
var _ = (function (){var statearr_72800 = state_72791;
(statearr_72800[(4)] = cljs.core.rest((state_72791[(4)])));

return statearr_72800;
})();
var state_72791__$1 = (function (){var statearr_72801 = state_72791;
(statearr_72801[(7)] = inst_72786);

return statearr_72801;
})();
var statearr_72802_72815 = state_72791__$1;
(statearr_72802_72815[(2)] = inst_72771);

(statearr_72802_72815[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__15091__auto____0 = (function (){
var statearr_72803 = [null,null,null,null,null,null,null,null];
(statearr_72803[(0)] = fluree$db$dbfunctions$fns$state_machine__15091__auto__);

(statearr_72803[(1)] = (1));

return statearr_72803;
});
var fluree$db$dbfunctions$fns$state_machine__15091__auto____1 = (function (state_72791){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_72791);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e72804){var ex__15094__auto__ = e72804;
var statearr_72805_72816 = state_72791;
(statearr_72805_72816[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_72791[(4)]))){
var statearr_72806_72817 = state_72791;
(statearr_72806_72817[(1)] = cljs.core.first((state_72791[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__72818 = state_72791;
state_72791 = G__72818;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__15091__auto__ = function(state_72791){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____1.call(this,state_72791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_72807 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_72807[(6)] = c__15165__auto__);

return statearr_72807;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq72759){
var G__72760 = cljs.core.first(seq72759);
var seq72759__$1 = cljs.core.next(seq72759);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72760,seq72759__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___72868 = arguments.length;
var i__5769__auto___72869 = (0);
while(true){
if((i__5769__auto___72869 < len__5768__auto___72868)){
args__5774__auto__.push((arguments[i__5769__auto___72869]));

var G__72870 = (i__5769__auto___72869 + (1));
i__5769__auto___72869 = G__72870;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_72851){
var state_val_72852 = (state_72851[(1)]);
if((state_val_72852 === (1))){
var state_72851__$1 = state_72851;
var statearr_72853_72871 = state_72851__$1;
(statearr_72853_72871[(2)] = null);

(statearr_72853_72871[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72852 === (2))){
var _ = (function (){var statearr_72854 = state_72851;
(statearr_72854[(4)] = cljs.core.cons((5),(state_72851[(4)])));

return statearr_72854;
})();
var inst_72827 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72851__$1 = state_72851;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72851__$1,(6),inst_72827);
} else {
if((state_val_72852 === (3))){
var inst_72849 = (state_72851[(2)]);
var state_72851__$1 = state_72851;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72851__$1,inst_72849);
} else {
if((state_val_72852 === (4))){
var inst_72821 = (state_72851[(2)]);
var state_72851__$1 = state_72851;
var statearr_72856_72872 = state_72851__$1;
(statearr_72856_72872[(2)] = inst_72821);

(statearr_72856_72872[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72852 === (5))){
var _ = (function (){var statearr_72857 = state_72851;
(statearr_72857[(4)] = cljs.core.rest((state_72851[(4)])));

return statearr_72857;
})();
var state_72851__$1 = state_72851;
var ex72855 = (state_72851__$1[(2)]);
var statearr_72858_72873 = state_72851__$1;
(statearr_72858_72873[(5)] = ex72855);


if((ex72855 instanceof Error)){
var statearr_72859_72874 = state_72851__$1;
(statearr_72859_72874[(1)] = (4));

(statearr_72859_72874[(5)] = null);

} else {
throw ex72855;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72852 === (6))){
var inst_72829 = (state_72851[(2)]);
var inst_72830 = fluree.db.util.async.throw_err(inst_72829);
var inst_72831 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_72830);
var inst_72832 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72833 = [inst_72830];
var inst_72834 = (new cljs.core.PersistentVector(null,1,(5),inst_72832,inst_72833,null));
var inst_72835 = cljs.core.count(inst_72834);
var inst_72836 = ((9) + inst_72835);
var inst_72837 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72838 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72839 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72840 = [inst_72830];
var inst_72841 = (new cljs.core.PersistentVector(null,1,(5),inst_72839,inst_72840,null));
var inst_72842 = ["not=",inst_72841,inst_72831];
var inst_72843 = cljs.core.PersistentHashMap.fromArrays(inst_72838,inst_72842);
var inst_72844 = [inst_72843,inst_72836];
var inst_72845 = (new cljs.core.PersistentVector(null,2,(5),inst_72837,inst_72844,null));
var inst_72846 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72845);
var _ = (function (){var statearr_72860 = state_72851;
(statearr_72860[(4)] = cljs.core.rest((state_72851[(4)])));

return statearr_72860;
})();
var state_72851__$1 = (function (){var statearr_72861 = state_72851;
(statearr_72861[(7)] = inst_72846);

return statearr_72861;
})();
var statearr_72862_72875 = state_72851__$1;
(statearr_72862_72875[(2)] = inst_72831);

(statearr_72862_72875[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__15091__auto____0 = (function (){
var statearr_72863 = [null,null,null,null,null,null,null,null];
(statearr_72863[(0)] = fluree$db$dbfunctions$fns$state_machine__15091__auto__);

(statearr_72863[(1)] = (1));

return statearr_72863;
});
var fluree$db$dbfunctions$fns$state_machine__15091__auto____1 = (function (state_72851){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_72851);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e72864){var ex__15094__auto__ = e72864;
var statearr_72865_72876 = state_72851;
(statearr_72865_72876[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_72851[(4)]))){
var statearr_72866_72877 = state_72851;
(statearr_72866_72877[(1)] = cljs.core.first((state_72851[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__72878 = state_72851;
state_72851 = G__72878;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__15091__auto__ = function(state_72851){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____1.call(this,state_72851);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_72867 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_72867[(6)] = c__15165__auto__);

return statearr_72867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq72819){
var G__72820 = cljs.core.first(seq72819);
var seq72819__$1 = cljs.core.next(seq72819);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72820,seq72819__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__5774__auto__ = [];
var len__5768__auto___72928 = arguments.length;
var i__5769__auto___72929 = (0);
while(true){
if((i__5769__auto___72929 < len__5768__auto___72928)){
args__5774__auto__.push((arguments[i__5769__auto___72929]));

var G__72930 = (i__5769__auto___72929 + (1));
i__5769__auto___72929 = G__72930;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_72911){
var state_val_72912 = (state_72911[(1)]);
if((state_val_72912 === (1))){
var state_72911__$1 = state_72911;
var statearr_72913_72931 = state_72911__$1;
(statearr_72913_72931[(2)] = null);

(statearr_72913_72931[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72912 === (2))){
var _ = (function (){var statearr_72914 = state_72911;
(statearr_72914[(4)] = cljs.core.cons((5),(state_72911[(4)])));

return statearr_72914;
})();
var inst_72887 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72911__$1 = state_72911;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72911__$1,(6),inst_72887);
} else {
if((state_val_72912 === (3))){
var inst_72909 = (state_72911[(2)]);
var state_72911__$1 = state_72911;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72911__$1,inst_72909);
} else {
if((state_val_72912 === (4))){
var inst_72881 = (state_72911[(2)]);
var state_72911__$1 = state_72911;
var statearr_72916_72932 = state_72911__$1;
(statearr_72916_72932[(2)] = inst_72881);

(statearr_72916_72932[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72912 === (5))){
var _ = (function (){var statearr_72917 = state_72911;
(statearr_72917[(4)] = cljs.core.rest((state_72911[(4)])));

return statearr_72917;
})();
var state_72911__$1 = state_72911;
var ex72915 = (state_72911__$1[(2)]);
var statearr_72918_72933 = state_72911__$1;
(statearr_72918_72933[(5)] = ex72915);


if((ex72915 instanceof Error)){
var statearr_72919_72934 = state_72911__$1;
(statearr_72919_72934[(1)] = (4));

(statearr_72919_72934[(5)] = null);

} else {
throw ex72915;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72912 === (6))){
var inst_72889 = (state_72911[(2)]);
var inst_72890 = fluree.db.util.async.throw_err(inst_72889);
var inst_72891 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_72890);
var inst_72892 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72893 = [inst_72890];
var inst_72894 = (new cljs.core.PersistentVector(null,1,(5),inst_72892,inst_72893,null));
var inst_72895 = cljs.core.count(inst_72894);
var inst_72896 = ((9) + inst_72895);
var inst_72897 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72898 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72899 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72900 = [inst_72890];
var inst_72901 = (new cljs.core.PersistentVector(null,1,(5),inst_72899,inst_72900,null));
var inst_72902 = ["max",inst_72901,inst_72891];
var inst_72903 = cljs.core.PersistentHashMap.fromArrays(inst_72898,inst_72902);
var inst_72904 = [inst_72903,inst_72896];
var inst_72905 = (new cljs.core.PersistentVector(null,2,(5),inst_72897,inst_72904,null));
var inst_72906 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72905);
var _ = (function (){var statearr_72920 = state_72911;
(statearr_72920[(4)] = cljs.core.rest((state_72911[(4)])));

return statearr_72920;
})();
var state_72911__$1 = (function (){var statearr_72921 = state_72911;
(statearr_72921[(7)] = inst_72906);

return statearr_72921;
})();
var statearr_72922_72935 = state_72911__$1;
(statearr_72922_72935[(2)] = inst_72891);

(statearr_72922_72935[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__15091__auto____0 = (function (){
var statearr_72923 = [null,null,null,null,null,null,null,null];
(statearr_72923[(0)] = fluree$db$dbfunctions$fns$state_machine__15091__auto__);

(statearr_72923[(1)] = (1));

return statearr_72923;
});
var fluree$db$dbfunctions$fns$state_machine__15091__auto____1 = (function (state_72911){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_72911);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e72924){var ex__15094__auto__ = e72924;
var statearr_72925_72936 = state_72911;
(statearr_72925_72936[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_72911[(4)]))){
var statearr_72926_72937 = state_72911;
(statearr_72926_72937[(1)] = cljs.core.first((state_72911[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__72938 = state_72911;
state_72911 = G__72938;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__15091__auto__ = function(state_72911){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____1.call(this,state_72911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_72927 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_72927[(6)] = c__15165__auto__);

return statearr_72927;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq72879){
var G__72880 = cljs.core.first(seq72879);
var seq72879__$1 = cljs.core.next(seq72879);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72880,seq72879__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__5774__auto__ = [];
var len__5768__auto___72988 = arguments.length;
var i__5769__auto___72989 = (0);
while(true){
if((i__5769__auto___72989 < len__5768__auto___72988)){
args__5774__auto__.push((arguments[i__5769__auto___72989]));

var G__72990 = (i__5769__auto___72989 + (1));
i__5769__auto___72989 = G__72990;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_72971){
var state_val_72972 = (state_72971[(1)]);
if((state_val_72972 === (1))){
var state_72971__$1 = state_72971;
var statearr_72973_72991 = state_72971__$1;
(statearr_72973_72991[(2)] = null);

(statearr_72973_72991[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72972 === (2))){
var _ = (function (){var statearr_72974 = state_72971;
(statearr_72974[(4)] = cljs.core.cons((5),(state_72971[(4)])));

return statearr_72974;
})();
var inst_72947 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72971__$1 = state_72971;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72971__$1,(6),inst_72947);
} else {
if((state_val_72972 === (3))){
var inst_72969 = (state_72971[(2)]);
var state_72971__$1 = state_72971;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72971__$1,inst_72969);
} else {
if((state_val_72972 === (4))){
var inst_72941 = (state_72971[(2)]);
var state_72971__$1 = state_72971;
var statearr_72976_72992 = state_72971__$1;
(statearr_72976_72992[(2)] = inst_72941);

(statearr_72976_72992[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72972 === (5))){
var _ = (function (){var statearr_72977 = state_72971;
(statearr_72977[(4)] = cljs.core.rest((state_72971[(4)])));

return statearr_72977;
})();
var state_72971__$1 = state_72971;
var ex72975 = (state_72971__$1[(2)]);
var statearr_72978_72993 = state_72971__$1;
(statearr_72978_72993[(5)] = ex72975);


if((ex72975 instanceof Error)){
var statearr_72979_72994 = state_72971__$1;
(statearr_72979_72994[(1)] = (4));

(statearr_72979_72994[(5)] = null);

} else {
throw ex72975;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72972 === (6))){
var inst_72949 = (state_72971[(2)]);
var inst_72950 = fluree.db.util.async.throw_err(inst_72949);
var inst_72951 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_72950);
var inst_72952 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72953 = [inst_72950];
var inst_72954 = (new cljs.core.PersistentVector(null,1,(5),inst_72952,inst_72953,null));
var inst_72955 = cljs.core.count(inst_72954);
var inst_72956 = ((9) + inst_72955);
var inst_72957 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72958 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72959 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72960 = [inst_72950];
var inst_72961 = (new cljs.core.PersistentVector(null,1,(5),inst_72959,inst_72960,null));
var inst_72962 = ["min",inst_72961,inst_72951];
var inst_72963 = cljs.core.PersistentHashMap.fromArrays(inst_72958,inst_72962);
var inst_72964 = [inst_72963,inst_72956];
var inst_72965 = (new cljs.core.PersistentVector(null,2,(5),inst_72957,inst_72964,null));
var inst_72966 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72965);
var _ = (function (){var statearr_72980 = state_72971;
(statearr_72980[(4)] = cljs.core.rest((state_72971[(4)])));

return statearr_72980;
})();
var state_72971__$1 = (function (){var statearr_72981 = state_72971;
(statearr_72981[(7)] = inst_72966);

return statearr_72981;
})();
var statearr_72982_72995 = state_72971__$1;
(statearr_72982_72995[(2)] = inst_72951);

(statearr_72982_72995[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__15091__auto____0 = (function (){
var statearr_72983 = [null,null,null,null,null,null,null,null];
(statearr_72983[(0)] = fluree$db$dbfunctions$fns$state_machine__15091__auto__);

(statearr_72983[(1)] = (1));

return statearr_72983;
});
var fluree$db$dbfunctions$fns$state_machine__15091__auto____1 = (function (state_72971){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_72971);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e72984){var ex__15094__auto__ = e72984;
var statearr_72985_72996 = state_72971;
(statearr_72985_72996[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_72971[(4)]))){
var statearr_72986_72997 = state_72971;
(statearr_72986_72997[(1)] = cljs.core.first((state_72971[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__72998 = state_72971;
state_72971 = G__72998;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__15091__auto__ = function(state_72971){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____1.call(this,state_72971);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_72987 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_72987[(6)] = c__15165__auto__);

return statearr_72987;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq72939){
var G__72940 = cljs.core.first(seq72939);
var seq72939__$1 = cljs.core.next(seq72939);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72940,seq72939__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__73000 = arguments.length;
switch (G__73000) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_73045){
var state_val_73046 = (state_73045[(1)]);
if((state_val_73046 === (7))){
var state_73045__$1 = state_73045;
var statearr_73047_73184 = state_73045__$1;
(statearr_73047_73184[(2)] = query_map);

(statearr_73047_73184[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73046 === (1))){
var state_73045__$1 = state_73045;
var statearr_73048_73185 = state_73045__$1;
(statearr_73048_73185[(2)] = null);

(statearr_73048_73185[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73046 === (4))){
var inst_73001 = (state_73045[(2)]);
var state_73045__$1 = state_73045;
var statearr_73049_73186 = state_73045__$1;
(statearr_73049_73186[(2)] = inst_73001);

(statearr_73049_73186[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73046 === (13))){
var inst_73023 = (state_73045[(7)]);
var inst_73027 = (state_73045[(2)]);
var inst_73028 = fluree.db.util.async.throw_err(inst_73027);
var inst_73029 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73028,(0),null);
var inst_73030 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73028,(1),null);
var inst_73031 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73032 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73033 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73034 = [inst_73023];
var inst_73035 = (new cljs.core.PersistentVector(null,1,(5),inst_73033,inst_73034,null));
var inst_73036 = ["query",inst_73035,inst_73029];
var inst_73037 = cljs.core.PersistentHashMap.fromArrays(inst_73032,inst_73036);
var inst_73038 = [inst_73037,inst_73030];
var inst_73039 = (new cljs.core.PersistentVector(null,2,(5),inst_73031,inst_73038,null));
var inst_73040 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73039);
var _ = (function (){var statearr_73050 = state_73045;
(statearr_73050[(4)] = cljs.core.rest((state_73045[(4)])));

return statearr_73050;
})();
var state_73045__$1 = (function (){var statearr_73051 = state_73045;
(statearr_73051[(8)] = inst_73040);

return statearr_73051;
})();
var statearr_73052_73187 = state_73045__$1;
(statearr_73052_73187[(2)] = inst_73029);

(statearr_73052_73187[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73046 === (6))){
var state_73045__$1 = state_73045;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73045__$1,(9),query_map);
} else {
if((state_val_73046 === (3))){
var inst_73043 = (state_73045[(2)]);
var state_73045__$1 = state_73045;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73045__$1,inst_73043);
} else {
if((state_val_73046 === (12))){
var inst_73023 = (state_73045[(7)]);
var inst_73023__$1 = (state_73045[(2)]);
var inst_73024 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_73025 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_73024,inst_73023__$1);
var state_73045__$1 = (function (){var statearr_73053 = state_73045;
(statearr_73053[(7)] = inst_73023__$1);

return statearr_73053;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73045__$1,(13),inst_73025);
} else {
if((state_val_73046 === (2))){
var _ = (function (){var statearr_73054 = state_73045;
(statearr_73054[(4)] = cljs.core.cons((5),(state_73045[(4)])));

return statearr_73054;
})();
var inst_73010 = fluree.db.util.async.channel_QMARK_(query_map);
var state_73045__$1 = state_73045;
if(inst_73010){
var statearr_73055_73188 = state_73045__$1;
(statearr_73055_73188[(1)] = (6));

} else {
var statearr_73056_73189 = state_73045__$1;
(statearr_73056_73189[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73046 === (11))){
var inst_73017 = (state_73045[(9)]);
var state_73045__$1 = state_73045;
var statearr_73058_73190 = state_73045__$1;
(statearr_73058_73190[(2)] = inst_73017);

(statearr_73058_73190[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73046 === (9))){
var inst_73013 = (state_73045[(2)]);
var inst_73014 = fluree.db.util.async.throw_err(inst_73013);
var state_73045__$1 = state_73045;
var statearr_73059_73191 = state_73045__$1;
(statearr_73059_73191[(2)] = inst_73014);

(statearr_73059_73191[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73046 === (5))){
var _ = (function (){var statearr_73060 = state_73045;
(statearr_73060[(4)] = cljs.core.rest((state_73045[(4)])));

return statearr_73060;
})();
var state_73045__$1 = state_73045;
var ex73057 = (state_73045__$1[(2)]);
var statearr_73061_73192 = state_73045__$1;
(statearr_73061_73192[(5)] = ex73057);


if((ex73057 instanceof Error)){
var statearr_73062_73193 = state_73045__$1;
(statearr_73062_73193[(1)] = (4));

(statearr_73062_73193[(5)] = null);

} else {
throw ex73057;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73046 === (10))){
var inst_73017 = (state_73045[(9)]);
var inst_73020 = fluree.db.util.json.parse(inst_73017);
var state_73045__$1 = state_73045;
var statearr_73063_73194 = state_73045__$1;
(statearr_73063_73194[(2)] = inst_73020);

(statearr_73063_73194[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73046 === (8))){
var inst_73017 = (state_73045[(9)]);
var inst_73017__$1 = (state_73045[(2)]);
var inst_73018 = typeof inst_73017__$1 === 'string';
var state_73045__$1 = (function (){var statearr_73064 = state_73045;
(statearr_73064[(9)] = inst_73017__$1);

return statearr_73064;
})();
if(cljs.core.truth_(inst_73018)){
var statearr_73065_73195 = state_73045__$1;
(statearr_73065_73195[(1)] = (10));

} else {
var statearr_73066_73196 = state_73045__$1;
(statearr_73066_73196[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__15091__auto____0 = (function (){
var statearr_73067 = [null,null,null,null,null,null,null,null,null,null];
(statearr_73067[(0)] = fluree$db$dbfunctions$fns$state_machine__15091__auto__);

(statearr_73067[(1)] = (1));

return statearr_73067;
});
var fluree$db$dbfunctions$fns$state_machine__15091__auto____1 = (function (state_73045){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_73045);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e73068){var ex__15094__auto__ = e73068;
var statearr_73069_73197 = state_73045;
(statearr_73069_73197[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_73045[(4)]))){
var statearr_73070_73198 = state_73045;
(statearr_73070_73198[(1)] = cljs.core.first((state_73045[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__73199 = state_73045;
state_73045 = G__73199;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__15091__auto__ = function(state_73045){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____1.call(this,state_73045);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_73071 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_73071[(6)] = c__15165__auto__);

return statearr_73071;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_73142){
var state_val_73143 = (state_73142[(1)]);
if((state_val_73143 === (7))){
var state_73142__$1 = state_73142;
var statearr_73144_73200 = state_73142__$1;
(statearr_73144_73200[(2)] = select);

(statearr_73144_73200[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73143 === (20))){
var inst_73112 = (state_73142[(2)]);
var inst_73113 = fluree.db.util.async.channel_QMARK_(limit);
var state_73142__$1 = (function (){var statearr_73145 = state_73142;
(statearr_73145[(7)] = inst_73112);

return statearr_73145;
})();
if(inst_73113){
var statearr_73146_73201 = state_73142__$1;
(statearr_73146_73201[(1)] = (22));

} else {
var statearr_73147_73202 = state_73142__$1;
(statearr_73147_73202[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73143 === (1))){
var state_73142__$1 = state_73142;
var statearr_73148_73203 = state_73142__$1;
(statearr_73148_73203[(2)] = null);

(statearr_73148_73203[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73143 === (24))){
var inst_73112 = (state_73142[(7)]);
var inst_73096 = (state_73142[(8)]);
var inst_73088 = (state_73142[(9)]);
var inst_73104 = (state_73142[(10)]);
var inst_73120 = (state_73142[(2)]);
var inst_73121 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_73122 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_73121,inst_73088,inst_73096,inst_73104,inst_73112,inst_73120);
var state_73142__$1 = state_73142;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73142__$1,(26),inst_73122);
} else {
if((state_val_73143 === (4))){
var inst_73072 = (state_73142[(2)]);
var state_73142__$1 = state_73142;
var statearr_73149_73204 = state_73142__$1;
(statearr_73149_73204[(2)] = inst_73072);

(statearr_73149_73204[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73143 === (15))){
var state_73142__$1 = state_73142;
var statearr_73150_73205 = state_73142__$1;
(statearr_73150_73205[(2)] = where);

(statearr_73150_73205[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73143 === (21))){
var inst_73108 = (state_73142[(2)]);
var inst_73109 = fluree.db.util.async.throw_err(inst_73108);
var state_73142__$1 = state_73142;
var statearr_73151_73206 = state_73142__$1;
(statearr_73151_73206[(2)] = inst_73109);

(statearr_73151_73206[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73143 === (13))){
var inst_73092 = (state_73142[(2)]);
var inst_73093 = fluree.db.util.async.throw_err(inst_73092);
var state_73142__$1 = state_73142;
var statearr_73152_73207 = state_73142__$1;
(statearr_73152_73207[(2)] = inst_73093);

(statearr_73152_73207[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73143 === (22))){
var state_73142__$1 = state_73142;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73142__$1,(25),limit);
} else {
if((state_val_73143 === (6))){
var state_73142__$1 = state_73142;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73142__$1,(9),select);
} else {
if((state_val_73143 === (25))){
var inst_73116 = (state_73142[(2)]);
var inst_73117 = fluree.db.util.async.throw_err(inst_73116);
var state_73142__$1 = state_73142;
var statearr_73153_73208 = state_73142__$1;
(statearr_73153_73208[(2)] = inst_73117);

(statearr_73153_73208[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73143 === (17))){
var inst_73100 = (state_73142[(2)]);
var inst_73101 = fluree.db.util.async.throw_err(inst_73100);
var state_73142__$1 = state_73142;
var statearr_73154_73209 = state_73142__$1;
(statearr_73154_73209[(2)] = inst_73101);

(statearr_73154_73209[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73143 === (3))){
var inst_73140 = (state_73142[(2)]);
var state_73142__$1 = state_73142;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73142__$1,inst_73140);
} else {
if((state_val_73143 === (12))){
var inst_73096 = (state_73142[(2)]);
var inst_73097 = fluree.db.util.async.channel_QMARK_(where);
var state_73142__$1 = (function (){var statearr_73155 = state_73142;
(statearr_73155[(8)] = inst_73096);

return statearr_73155;
})();
if(inst_73097){
var statearr_73156_73210 = state_73142__$1;
(statearr_73156_73210[(1)] = (14));

} else {
var statearr_73157_73211 = state_73142__$1;
(statearr_73157_73211[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73143 === (2))){
var _ = (function (){var statearr_73158 = state_73142;
(statearr_73158[(4)] = cljs.core.cons((5),(state_73142[(4)])));

return statearr_73158;
})();
var inst_73081 = fluree.db.util.async.channel_QMARK_(select);
var state_73142__$1 = state_73142;
if(inst_73081){
var statearr_73159_73212 = state_73142__$1;
(statearr_73159_73212[(1)] = (6));

} else {
var statearr_73160_73213 = state_73142__$1;
(statearr_73160_73213[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73143 === (23))){
var state_73142__$1 = state_73142;
var statearr_73161_73214 = state_73142__$1;
(statearr_73161_73214[(2)] = limit);

(statearr_73161_73214[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73143 === (19))){
var state_73142__$1 = state_73142;
var statearr_73162_73215 = state_73142__$1;
(statearr_73162_73215[(2)] = block);

(statearr_73162_73215[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73143 === (11))){
var state_73142__$1 = state_73142;
var statearr_73164_73216 = state_73142__$1;
(statearr_73164_73216[(2)] = from);

(statearr_73164_73216[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73143 === (9))){
var inst_73084 = (state_73142[(2)]);
var inst_73085 = fluree.db.util.async.throw_err(inst_73084);
var state_73142__$1 = state_73142;
var statearr_73165_73217 = state_73142__$1;
(statearr_73165_73217[(2)] = inst_73085);

(statearr_73165_73217[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73143 === (5))){
var _ = (function (){var statearr_73166 = state_73142;
(statearr_73166[(4)] = cljs.core.rest((state_73142[(4)])));

return statearr_73166;
})();
var state_73142__$1 = state_73142;
var ex73163 = (state_73142__$1[(2)]);
var statearr_73167_73218 = state_73142__$1;
(statearr_73167_73218[(5)] = ex73163);


if((ex73163 instanceof Error)){
var statearr_73168_73219 = state_73142__$1;
(statearr_73168_73219[(1)] = (4));

(statearr_73168_73219[(5)] = null);

} else {
throw ex73163;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73143 === (14))){
var state_73142__$1 = state_73142;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73142__$1,(17),where);
} else {
if((state_val_73143 === (26))){
var inst_73112 = (state_73142[(7)]);
var inst_73096 = (state_73142[(8)]);
var inst_73088 = (state_73142[(9)]);
var inst_73104 = (state_73142[(10)]);
var inst_73124 = (state_73142[(2)]);
var inst_73125 = fluree.db.util.async.throw_err(inst_73124);
var inst_73126 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73125,(0),null);
var inst_73127 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73125,(1),null);
var inst_73128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73129 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73131 = [inst_73088,inst_73096,inst_73104,inst_73112];
var inst_73132 = (new cljs.core.PersistentVector(null,4,(5),inst_73130,inst_73131,null));
var inst_73133 = ["query",inst_73132,inst_73126];
var inst_73134 = cljs.core.PersistentHashMap.fromArrays(inst_73129,inst_73133);
var inst_73135 = [inst_73134,inst_73127];
var inst_73136 = (new cljs.core.PersistentVector(null,2,(5),inst_73128,inst_73135,null));
var inst_73137 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73136);
var _ = (function (){var statearr_73169 = state_73142;
(statearr_73169[(4)] = cljs.core.rest((state_73142[(4)])));

return statearr_73169;
})();
var state_73142__$1 = (function (){var statearr_73170 = state_73142;
(statearr_73170[(11)] = inst_73137);

return statearr_73170;
})();
var statearr_73171_73220 = state_73142__$1;
(statearr_73171_73220[(2)] = inst_73126);

(statearr_73171_73220[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73143 === (16))){
var inst_73104 = (state_73142[(2)]);
var inst_73105 = fluree.db.util.async.channel_QMARK_(block);
var state_73142__$1 = (function (){var statearr_73172 = state_73142;
(statearr_73172[(10)] = inst_73104);

return statearr_73172;
})();
if(inst_73105){
var statearr_73173_73221 = state_73142__$1;
(statearr_73173_73221[(1)] = (18));

} else {
var statearr_73174_73222 = state_73142__$1;
(statearr_73174_73222[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73143 === (10))){
var state_73142__$1 = state_73142;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73142__$1,(13),from);
} else {
if((state_val_73143 === (18))){
var state_73142__$1 = state_73142;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73142__$1,(21),block);
} else {
if((state_val_73143 === (8))){
var inst_73088 = (state_73142[(2)]);
var inst_73089 = fluree.db.util.async.channel_QMARK_(from);
var state_73142__$1 = (function (){var statearr_73175 = state_73142;
(statearr_73175[(9)] = inst_73088);

return statearr_73175;
})();
if(inst_73089){
var statearr_73176_73223 = state_73142__$1;
(statearr_73176_73223[(1)] = (10));

} else {
var statearr_73177_73224 = state_73142__$1;
(statearr_73177_73224[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__15091__auto____0 = (function (){
var statearr_73178 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73178[(0)] = fluree$db$dbfunctions$fns$state_machine__15091__auto__);

(statearr_73178[(1)] = (1));

return statearr_73178;
});
var fluree$db$dbfunctions$fns$state_machine__15091__auto____1 = (function (state_73142){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_73142);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e73179){var ex__15094__auto__ = e73179;
var statearr_73180_73225 = state_73142;
(statearr_73180_73225[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_73142[(4)]))){
var statearr_73181_73226 = state_73142;
(statearr_73181_73226[(1)] = cljs.core.first((state_73142[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__73227 = state_73142;
state_73142 = G__73227;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__15091__auto__ = function(state_73142){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____1.call(this,state_73142);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_73182 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_73182[(6)] = c__15165__auto__);

return statearr_73182;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_73283){
var state_val_73284 = (state_73283[(1)]);
if((state_val_73284 === (7))){
var state_73283__$1 = state_73283;
var statearr_73285_73316 = state_73283__$1;
(statearr_73285_73316[(2)] = startSubject);

(statearr_73285_73316[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73284 === (1))){
var state_73283__$1 = state_73283;
var statearr_73286_73317 = state_73283__$1;
(statearr_73286_73317[(2)] = null);

(statearr_73286_73317[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73284 === (4))){
var inst_73228 = (state_73283[(2)]);
var state_73283__$1 = state_73283;
var statearr_73287_73318 = state_73283__$1;
(statearr_73287_73318[(2)] = inst_73228);

(statearr_73287_73318[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73284 === (15))){
var inst_73260 = (state_73283[(2)]);
var inst_73261 = fluree.db.util.async.throw_err(inst_73260);
var inst_73262 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73261,(0),null);
var inst_73263 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73261,(1),null);
var inst_73264 = cljs.core.empty_QMARK_(inst_73262);
var state_73283__$1 = (function (){var statearr_73288 = state_73283;
(statearr_73288[(7)] = inst_73263);

return statearr_73288;
})();
if(inst_73264){
var statearr_73289_73319 = state_73283__$1;
(statearr_73289_73319[(1)] = (16));

} else {
var statearr_73290_73320 = state_73283__$1;
(statearr_73290_73320[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73284 === (13))){
var inst_73244 = (state_73283[(8)]);
var inst_73256 = (state_73283[(9)]);
var inst_73248 = (state_73283[(10)]);
var inst_73256__$1 = (state_73283[(2)]);
var inst_73257 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_73258 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_73257,inst_73244,inst_73248,inst_73256__$1);
var state_73283__$1 = (function (){var statearr_73291 = state_73283;
(statearr_73291[(9)] = inst_73256__$1);

return statearr_73291;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73283__$1,(15),inst_73258);
} else {
if((state_val_73284 === (6))){
var state_73283__$1 = state_73283;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73283__$1,(9),startSubject);
} else {
if((state_val_73284 === (17))){
var state_73283__$1 = state_73283;
var statearr_73292_73321 = state_73283__$1;
(statearr_73292_73321[(2)] = true);

(statearr_73292_73321[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73284 === (3))){
var inst_73281 = (state_73283[(2)]);
var state_73283__$1 = state_73283;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73283__$1,inst_73281);
} else {
if((state_val_73284 === (12))){
var state_73283__$1 = state_73283;
var statearr_73293_73322 = state_73283__$1;
(statearr_73293_73322[(2)] = endSubject);

(statearr_73293_73322[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73284 === (2))){
var _ = (function (){var statearr_73294 = state_73283;
(statearr_73294[(4)] = cljs.core.cons((5),(state_73283[(4)])));

return statearr_73294;
})();
var inst_73237 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_73283__$1 = state_73283;
if(inst_73237){
var statearr_73295_73323 = state_73283__$1;
(statearr_73295_73323[(1)] = (6));

} else {
var statearr_73296_73324 = state_73283__$1;
(statearr_73296_73324[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73284 === (11))){
var state_73283__$1 = state_73283;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73283__$1,(14),endSubject);
} else {
if((state_val_73284 === (9))){
var inst_73240 = (state_73283[(2)]);
var inst_73241 = fluree.db.util.async.throw_err(inst_73240);
var state_73283__$1 = state_73283;
var statearr_73298_73325 = state_73283__$1;
(statearr_73298_73325[(2)] = inst_73241);

(statearr_73298_73325[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73284 === (5))){
var _ = (function (){var statearr_73299 = state_73283;
(statearr_73299[(4)] = cljs.core.rest((state_73283[(4)])));

return statearr_73299;
})();
var state_73283__$1 = state_73283;
var ex73297 = (state_73283__$1[(2)]);
var statearr_73300_73326 = state_73283__$1;
(statearr_73300_73326[(5)] = ex73297);


if((ex73297 instanceof Error)){
var statearr_73301_73327 = state_73283__$1;
(statearr_73301_73327[(1)] = (4));

(statearr_73301_73327[(5)] = null);

} else {
throw ex73297;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73284 === (14))){
var inst_73252 = (state_73283[(2)]);
var inst_73253 = fluree.db.util.async.throw_err(inst_73252);
var state_73283__$1 = state_73283;
var statearr_73302_73328 = state_73283__$1;
(statearr_73302_73328[(2)] = inst_73253);

(statearr_73302_73328[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73284 === (16))){
var state_73283__$1 = state_73283;
var statearr_73303_73329 = state_73283__$1;
(statearr_73303_73329[(2)] = false);

(statearr_73303_73329[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73284 === (10))){
var inst_73247 = (state_73283[(2)]);
var inst_73248 = fluree.db.util.async.throw_err(inst_73247);
var inst_73249 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_73283__$1 = (function (){var statearr_73304 = state_73283;
(statearr_73304[(10)] = inst_73248);

return statearr_73304;
})();
if(inst_73249){
var statearr_73305_73330 = state_73283__$1;
(statearr_73305_73330[(1)] = (11));

} else {
var statearr_73306_73331 = state_73283__$1;
(statearr_73306_73331[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73284 === (18))){
var inst_73244 = (state_73283[(8)]);
var inst_73256 = (state_73283[(9)]);
var inst_73248 = (state_73283[(10)]);
var inst_73263 = (state_73283[(7)]);
var inst_73268 = (state_73283[(2)]);
var inst_73269 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73270 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73271 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73272 = [inst_73244,inst_73248,inst_73256];
var inst_73273 = (new cljs.core.PersistentVector(null,3,(5),inst_73271,inst_73272,null));
var inst_73274 = ["relationship?",inst_73273,inst_73268];
var inst_73275 = cljs.core.PersistentHashMap.fromArrays(inst_73270,inst_73274);
var inst_73276 = [inst_73275,inst_73263];
var inst_73277 = (new cljs.core.PersistentVector(null,2,(5),inst_73269,inst_73276,null));
var inst_73278 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73277);
var _ = (function (){var statearr_73307 = state_73283;
(statearr_73307[(4)] = cljs.core.rest((state_73283[(4)])));

return statearr_73307;
})();
var state_73283__$1 = (function (){var statearr_73308 = state_73283;
(statearr_73308[(11)] = inst_73278);

return statearr_73308;
})();
var statearr_73309_73332 = state_73283__$1;
(statearr_73309_73332[(2)] = inst_73268);

(statearr_73309_73332[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73284 === (8))){
var inst_73244 = (state_73283[(2)]);
var inst_73245 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_73283__$1 = (function (){var statearr_73310 = state_73283;
(statearr_73310[(8)] = inst_73244);

return statearr_73310;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73283__$1,(10),inst_73245);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__15091__auto____0 = (function (){
var statearr_73311 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73311[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__15091__auto__);

(statearr_73311[(1)] = (1));

return statearr_73311;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__15091__auto____1 = (function (state_73283){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_73283);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e73312){var ex__15094__auto__ = e73312;
var statearr_73313_73333 = state_73283;
(statearr_73313_73333[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_73283[(4)]))){
var statearr_73314_73334 = state_73283;
(statearr_73314_73334[(1)] = cljs.core.first((state_73283[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__73335 = state_73283;
state_73283 = G__73335;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__15091__auto__ = function(state_73283){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__15091__auto____1.call(this,state_73283);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_73315 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_73315[(6)] = c__15165__auto__);

return statearr_73315;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_73372){
var state_val_73373 = (state_73372[(1)]);
if((state_val_73373 === (7))){
var state_73372__$1 = state_73372;
var statearr_73374_73394 = state_73372__$1;
(statearr_73374_73394[(2)] = pred_name);

(statearr_73374_73394[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73373 === (1))){
var state_73372__$1 = state_73372;
var statearr_73375_73395 = state_73372__$1;
(statearr_73375_73395[(2)] = null);

(statearr_73375_73395[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73373 === (4))){
var inst_73336 = (state_73372[(2)]);
var state_73372__$1 = state_73372;
var statearr_73376_73396 = state_73372__$1;
(statearr_73376_73396[(2)] = inst_73336);

(statearr_73376_73396[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73373 === (6))){
var state_73372__$1 = state_73372;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73372__$1,(9),pred_name);
} else {
if((state_val_73373 === (3))){
var inst_73370 = (state_73372[(2)]);
var state_73372__$1 = state_73372;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73372__$1,inst_73370);
} else {
if((state_val_73373 === (2))){
var _ = (function (){var statearr_73378 = state_73372;
(statearr_73378[(4)] = cljs.core.cons((5),(state_73372[(4)])));

return statearr_73378;
})();
var inst_73345 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_73372__$1 = state_73372;
if(inst_73345){
var statearr_73379_73397 = state_73372__$1;
(statearr_73379_73397[(1)] = (6));

} else {
var statearr_73380_73398 = state_73372__$1;
(statearr_73380_73398[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73373 === (9))){
var inst_73348 = (state_73372[(2)]);
var inst_73349 = fluree.db.util.async.throw_err(inst_73348);
var state_73372__$1 = state_73372;
var statearr_73381_73399 = state_73372__$1;
(statearr_73381_73399[(2)] = inst_73349);

(statearr_73381_73399[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73373 === (5))){
var _ = (function (){var statearr_73382 = state_73372;
(statearr_73382[(4)] = cljs.core.rest((state_73372[(4)])));

return statearr_73382;
})();
var state_73372__$1 = state_73372;
var ex73377 = (state_73372__$1[(2)]);
var statearr_73383_73400 = state_73372__$1;
(statearr_73383_73400[(5)] = ex73377);


if((ex73377 instanceof Error)){
var statearr_73384_73401 = state_73372__$1;
(statearr_73384_73401[(1)] = (4));

(statearr_73384_73401[(5)] = null);

} else {
throw ex73377;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73373 === (10))){
var inst_73352 = (state_73372[(7)]);
var inst_73356 = (state_73372[(2)]);
var inst_73357 = fluree.db.util.async.throw_err(inst_73356);
var inst_73358 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73357,(0),null);
var inst_73359 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73357,(1),null);
var inst_73360 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73361 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73362 = ["max-pred-val",inst_73352,inst_73358];
var inst_73363 = cljs.core.PersistentHashMap.fromArrays(inst_73361,inst_73362);
var inst_73364 = (inst_73359 + (10));
var inst_73365 = [inst_73363,inst_73364];
var inst_73366 = (new cljs.core.PersistentVector(null,2,(5),inst_73360,inst_73365,null));
var inst_73367 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73366);
var _ = (function (){var statearr_73385 = state_73372;
(statearr_73385[(4)] = cljs.core.rest((state_73372[(4)])));

return statearr_73385;
})();
var state_73372__$1 = (function (){var statearr_73386 = state_73372;
(statearr_73386[(8)] = inst_73367);

return statearr_73386;
})();
var statearr_73387_73402 = state_73372__$1;
(statearr_73387_73402[(2)] = inst_73358);

(statearr_73387_73402[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73373 === (8))){
var inst_73352 = (state_73372[(7)]);
var inst_73352__$1 = (state_73372[(2)]);
var inst_73353 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_73354 = fluree.db.dbfunctions.internal.max_pred_val(inst_73353,inst_73352__$1,null);
var state_73372__$1 = (function (){var statearr_73388 = state_73372;
(statearr_73388[(7)] = inst_73352__$1);

return statearr_73388;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73372__$1,(10),inst_73354);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__15091__auto____0 = (function (){
var statearr_73389 = [null,null,null,null,null,null,null,null,null];
(statearr_73389[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__15091__auto__);

(statearr_73389[(1)] = (1));

return statearr_73389;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__15091__auto____1 = (function (state_73372){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_73372);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e73390){var ex__15094__auto__ = e73390;
var statearr_73391_73403 = state_73372;
(statearr_73391_73403[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_73372[(4)]))){
var statearr_73392_73404 = state_73372;
(statearr_73392_73404[(1)] = cljs.core.first((state_73372[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__73405 = state_73372;
state_73372 = G__73405;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__15091__auto__ = function(state_73372){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__15091__auto____1.call(this,state_73372);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_73393 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_73393[(6)] = c__15165__auto__);

return statearr_73393;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_73432){
var state_val_73433 = (state_73432[(1)]);
if((state_val_73433 === (7))){
var state_73432__$1 = state_73432;
var statearr_73434_73453 = state_73432__$1;
(statearr_73434_73453[(2)] = n);

(statearr_73434_73453[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73433 === (1))){
var state_73432__$1 = state_73432;
var statearr_73435_73454 = state_73432__$1;
(statearr_73435_73454[(2)] = null);

(statearr_73435_73454[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73433 === (4))){
var inst_73406 = (state_73432[(2)]);
var state_73432__$1 = state_73432;
var statearr_73436_73455 = state_73432__$1;
(statearr_73436_73455[(2)] = inst_73406);

(statearr_73436_73455[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73433 === (6))){
var state_73432__$1 = state_73432;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73432__$1,(9),n);
} else {
if((state_val_73433 === (3))){
var inst_73430 = (state_73432[(2)]);
var state_73432__$1 = state_73432;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73432__$1,inst_73430);
} else {
if((state_val_73433 === (2))){
var _ = (function (){var statearr_73438 = state_73432;
(statearr_73438[(4)] = cljs.core.cons((5),(state_73432[(4)])));

return statearr_73438;
})();
var inst_73412 = fluree.db.util.async.channel_QMARK_(n);
var state_73432__$1 = state_73432;
if(inst_73412){
var statearr_73439_73456 = state_73432__$1;
(statearr_73439_73456[(1)] = (6));

} else {
var statearr_73440_73457 = state_73432__$1;
(statearr_73440_73457[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73433 === (9))){
var inst_73415 = (state_73432[(2)]);
var inst_73416 = fluree.db.util.async.throw_err(inst_73415);
var state_73432__$1 = state_73432;
var statearr_73441_73458 = state_73432__$1;
(statearr_73441_73458[(2)] = inst_73416);

(statearr_73441_73458[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73433 === (5))){
var _ = (function (){var statearr_73442 = state_73432;
(statearr_73442[(4)] = cljs.core.rest((state_73432[(4)])));

return statearr_73442;
})();
var state_73432__$1 = state_73432;
var ex73437 = (state_73432__$1[(2)]);
var statearr_73443_73459 = state_73432__$1;
(statearr_73443_73459[(5)] = ex73437);


if((ex73437 instanceof Error)){
var statearr_73444_73460 = state_73432__$1;
(statearr_73444_73460[(1)] = (4));

(statearr_73444_73460[(5)] = null);

} else {
throw ex73437;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73433 === (8))){
var inst_73419 = (state_73432[(2)]);
var inst_73420 = fluree.db.dbfunctions.internal.inc(inst_73419);
var inst_73421 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73422 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73423 = ["inc",inst_73419,inst_73420];
var inst_73424 = cljs.core.PersistentHashMap.fromArrays(inst_73422,inst_73423);
var inst_73425 = [inst_73424,(10)];
var inst_73426 = (new cljs.core.PersistentVector(null,2,(5),inst_73421,inst_73425,null));
var inst_73427 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73426);
var _ = (function (){var statearr_73445 = state_73432;
(statearr_73445[(4)] = cljs.core.rest((state_73432[(4)])));

return statearr_73445;
})();
var state_73432__$1 = (function (){var statearr_73446 = state_73432;
(statearr_73446[(7)] = inst_73427);

return statearr_73446;
})();
var statearr_73447_73461 = state_73432__$1;
(statearr_73447_73461[(2)] = inst_73420);

(statearr_73447_73461[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__15091__auto____0 = (function (){
var statearr_73448 = [null,null,null,null,null,null,null,null];
(statearr_73448[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__15091__auto__);

(statearr_73448[(1)] = (1));

return statearr_73448;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__15091__auto____1 = (function (state_73432){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_73432);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e73449){var ex__15094__auto__ = e73449;
var statearr_73450_73462 = state_73432;
(statearr_73450_73462[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_73432[(4)]))){
var statearr_73451_73463 = state_73432;
(statearr_73451_73463[(1)] = cljs.core.first((state_73432[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__73464 = state_73432;
state_73432 = G__73464;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__15091__auto__ = function(state_73432){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__15091__auto____1.call(this,state_73432);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_73452 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_73452[(6)] = c__15165__auto__);

return statearr_73452;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_73491){
var state_val_73492 = (state_73491[(1)]);
if((state_val_73492 === (7))){
var state_73491__$1 = state_73491;
var statearr_73493_73512 = state_73491__$1;
(statearr_73493_73512[(2)] = n);

(statearr_73493_73512[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73492 === (1))){
var state_73491__$1 = state_73491;
var statearr_73494_73513 = state_73491__$1;
(statearr_73494_73513[(2)] = null);

(statearr_73494_73513[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73492 === (4))){
var inst_73465 = (state_73491[(2)]);
var state_73491__$1 = state_73491;
var statearr_73495_73514 = state_73491__$1;
(statearr_73495_73514[(2)] = inst_73465);

(statearr_73495_73514[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73492 === (6))){
var state_73491__$1 = state_73491;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73491__$1,(9),n);
} else {
if((state_val_73492 === (3))){
var inst_73489 = (state_73491[(2)]);
var state_73491__$1 = state_73491;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73491__$1,inst_73489);
} else {
if((state_val_73492 === (2))){
var _ = (function (){var statearr_73497 = state_73491;
(statearr_73497[(4)] = cljs.core.cons((5),(state_73491[(4)])));

return statearr_73497;
})();
var inst_73471 = fluree.db.util.async.channel_QMARK_(n);
var state_73491__$1 = state_73491;
if(inst_73471){
var statearr_73498_73515 = state_73491__$1;
(statearr_73498_73515[(1)] = (6));

} else {
var statearr_73499_73516 = state_73491__$1;
(statearr_73499_73516[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73492 === (9))){
var inst_73474 = (state_73491[(2)]);
var inst_73475 = fluree.db.util.async.throw_err(inst_73474);
var state_73491__$1 = state_73491;
var statearr_73500_73517 = state_73491__$1;
(statearr_73500_73517[(2)] = inst_73475);

(statearr_73500_73517[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73492 === (5))){
var _ = (function (){var statearr_73501 = state_73491;
(statearr_73501[(4)] = cljs.core.rest((state_73491[(4)])));

return statearr_73501;
})();
var state_73491__$1 = state_73491;
var ex73496 = (state_73491__$1[(2)]);
var statearr_73502_73518 = state_73491__$1;
(statearr_73502_73518[(5)] = ex73496);


if((ex73496 instanceof Error)){
var statearr_73503_73519 = state_73491__$1;
(statearr_73503_73519[(1)] = (4));

(statearr_73503_73519[(5)] = null);

} else {
throw ex73496;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73492 === (8))){
var inst_73478 = (state_73491[(2)]);
var inst_73479 = fluree.db.dbfunctions.internal.dec(inst_73478);
var inst_73480 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73481 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73482 = ["dec",inst_73478,inst_73479];
var inst_73483 = cljs.core.PersistentHashMap.fromArrays(inst_73481,inst_73482);
var inst_73484 = [inst_73483,(10)];
var inst_73485 = (new cljs.core.PersistentVector(null,2,(5),inst_73480,inst_73484,null));
var inst_73486 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73485);
var _ = (function (){var statearr_73504 = state_73491;
(statearr_73504[(4)] = cljs.core.rest((state_73491[(4)])));

return statearr_73504;
})();
var state_73491__$1 = (function (){var statearr_73505 = state_73491;
(statearr_73505[(7)] = inst_73486);

return statearr_73505;
})();
var statearr_73506_73520 = state_73491__$1;
(statearr_73506_73520[(2)] = inst_73479);

(statearr_73506_73520[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__15091__auto____0 = (function (){
var statearr_73507 = [null,null,null,null,null,null,null,null];
(statearr_73507[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__15091__auto__);

(statearr_73507[(1)] = (1));

return statearr_73507;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__15091__auto____1 = (function (state_73491){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_73491);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e73508){var ex__15094__auto__ = e73508;
var statearr_73509_73521 = state_73491;
(statearr_73509_73521[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_73491[(4)]))){
var statearr_73510_73522 = state_73491;
(statearr_73510_73522[(1)] = cljs.core.first((state_73491[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__73523 = state_73491;
state_73491 = G__73523;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__15091__auto__ = function(state_73491){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__15091__auto____1.call(this,state_73491);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_73511 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_73511[(6)] = c__15165__auto__);

return statearr_73511;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"now",cljs.core.cst$kw$arguments,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___73573 = arguments.length;
var i__5769__auto___73574 = (0);
while(true){
if((i__5769__auto___73574 < len__5768__auto___73573)){
args__5774__auto__.push((arguments[i__5769__auto___73574]));

var G__73575 = (i__5769__auto___73574 + (1));
i__5769__auto___73574 = G__73575;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_73556){
var state_val_73557 = (state_73556[(1)]);
if((state_val_73557 === (1))){
var state_73556__$1 = state_73556;
var statearr_73558_73576 = state_73556__$1;
(statearr_73558_73576[(2)] = null);

(statearr_73558_73576[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73557 === (2))){
var _ = (function (){var statearr_73559 = state_73556;
(statearr_73559[(4)] = cljs.core.cons((5),(state_73556[(4)])));

return statearr_73559;
})();
var inst_73532 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_73556__$1 = state_73556;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73556__$1,(6),inst_73532);
} else {
if((state_val_73557 === (3))){
var inst_73554 = (state_73556[(2)]);
var state_73556__$1 = state_73556;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73556__$1,inst_73554);
} else {
if((state_val_73557 === (4))){
var inst_73526 = (state_73556[(2)]);
var state_73556__$1 = state_73556;
var statearr_73561_73577 = state_73556__$1;
(statearr_73561_73577[(2)] = inst_73526);

(statearr_73561_73577[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73557 === (5))){
var _ = (function (){var statearr_73562 = state_73556;
(statearr_73562[(4)] = cljs.core.rest((state_73556[(4)])));

return statearr_73562;
})();
var state_73556__$1 = state_73556;
var ex73560 = (state_73556__$1[(2)]);
var statearr_73563_73578 = state_73556__$1;
(statearr_73563_73578[(5)] = ex73560);


if((ex73560 instanceof Error)){
var statearr_73564_73579 = state_73556__$1;
(statearr_73564_73579[(1)] = (4));

(statearr_73564_73579[(5)] = null);

} else {
throw ex73560;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73557 === (6))){
var inst_73534 = (state_73556[(2)]);
var inst_73535 = fluree.db.util.async.throw_err(inst_73534);
var inst_73536 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_73535);
var inst_73537 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73538 = [inst_73535];
var inst_73539 = (new cljs.core.PersistentVector(null,1,(5),inst_73537,inst_73538,null));
var inst_73540 = cljs.core.count(inst_73539);
var inst_73541 = ((9) + inst_73540);
var inst_73542 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73543 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73544 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73545 = [inst_73535];
var inst_73546 = (new cljs.core.PersistentVector(null,1,(5),inst_73544,inst_73545,null));
var inst_73547 = ["+",inst_73546,inst_73536];
var inst_73548 = cljs.core.PersistentHashMap.fromArrays(inst_73543,inst_73547);
var inst_73549 = [inst_73548,inst_73541];
var inst_73550 = (new cljs.core.PersistentVector(null,2,(5),inst_73542,inst_73549,null));
var inst_73551 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73550);
var _ = (function (){var statearr_73565 = state_73556;
(statearr_73565[(4)] = cljs.core.rest((state_73556[(4)])));

return statearr_73565;
})();
var state_73556__$1 = (function (){var statearr_73566 = state_73556;
(statearr_73566[(7)] = inst_73551);

return statearr_73566;
})();
var statearr_73567_73580 = state_73556__$1;
(statearr_73567_73580[(2)] = inst_73536);

(statearr_73567_73580[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__15091__auto____0 = (function (){
var statearr_73568 = [null,null,null,null,null,null,null,null];
(statearr_73568[(0)] = fluree$db$dbfunctions$fns$state_machine__15091__auto__);

(statearr_73568[(1)] = (1));

return statearr_73568;
});
var fluree$db$dbfunctions$fns$state_machine__15091__auto____1 = (function (state_73556){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_73556);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e73569){var ex__15094__auto__ = e73569;
var statearr_73570_73581 = state_73556;
(statearr_73570_73581[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_73556[(4)]))){
var statearr_73571_73582 = state_73556;
(statearr_73571_73582[(1)] = cljs.core.first((state_73556[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__73583 = state_73556;
state_73556 = G__73583;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__15091__auto__ = function(state_73556){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____1.call(this,state_73556);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_73572 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_73572[(6)] = c__15165__auto__);

return statearr_73572;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq73524){
var G__73525 = cljs.core.first(seq73524);
var seq73524__$1 = cljs.core.next(seq73524);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73525,seq73524__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___73633 = arguments.length;
var i__5769__auto___73634 = (0);
while(true){
if((i__5769__auto___73634 < len__5768__auto___73633)){
args__5774__auto__.push((arguments[i__5769__auto___73634]));

var G__73635 = (i__5769__auto___73634 + (1));
i__5769__auto___73634 = G__73635;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_73616){
var state_val_73617 = (state_73616[(1)]);
if((state_val_73617 === (1))){
var state_73616__$1 = state_73616;
var statearr_73618_73636 = state_73616__$1;
(statearr_73618_73636[(2)] = null);

(statearr_73618_73636[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73617 === (2))){
var _ = (function (){var statearr_73619 = state_73616;
(statearr_73619[(4)] = cljs.core.cons((5),(state_73616[(4)])));

return statearr_73619;
})();
var inst_73592 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_73616__$1 = state_73616;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73616__$1,(6),inst_73592);
} else {
if((state_val_73617 === (3))){
var inst_73614 = (state_73616[(2)]);
var state_73616__$1 = state_73616;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73616__$1,inst_73614);
} else {
if((state_val_73617 === (4))){
var inst_73586 = (state_73616[(2)]);
var state_73616__$1 = state_73616;
var statearr_73621_73637 = state_73616__$1;
(statearr_73621_73637[(2)] = inst_73586);

(statearr_73621_73637[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73617 === (5))){
var _ = (function (){var statearr_73622 = state_73616;
(statearr_73622[(4)] = cljs.core.rest((state_73616[(4)])));

return statearr_73622;
})();
var state_73616__$1 = state_73616;
var ex73620 = (state_73616__$1[(2)]);
var statearr_73623_73638 = state_73616__$1;
(statearr_73623_73638[(5)] = ex73620);


if((ex73620 instanceof Error)){
var statearr_73624_73639 = state_73616__$1;
(statearr_73624_73639[(1)] = (4));

(statearr_73624_73639[(5)] = null);

} else {
throw ex73620;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73617 === (6))){
var inst_73594 = (state_73616[(2)]);
var inst_73595 = fluree.db.util.async.throw_err(inst_73594);
var inst_73596 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_73595);
var inst_73597 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73598 = [inst_73595];
var inst_73599 = (new cljs.core.PersistentVector(null,1,(5),inst_73597,inst_73598,null));
var inst_73600 = cljs.core.count(inst_73599);
var inst_73601 = ((9) + inst_73600);
var inst_73602 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73603 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73604 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73605 = [inst_73595];
var inst_73606 = (new cljs.core.PersistentVector(null,1,(5),inst_73604,inst_73605,null));
var inst_73607 = ["-",inst_73606,inst_73596];
var inst_73608 = cljs.core.PersistentHashMap.fromArrays(inst_73603,inst_73607);
var inst_73609 = [inst_73608,inst_73601];
var inst_73610 = (new cljs.core.PersistentVector(null,2,(5),inst_73602,inst_73609,null));
var inst_73611 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73610);
var _ = (function (){var statearr_73625 = state_73616;
(statearr_73625[(4)] = cljs.core.rest((state_73616[(4)])));

return statearr_73625;
})();
var state_73616__$1 = (function (){var statearr_73626 = state_73616;
(statearr_73626[(7)] = inst_73611);

return statearr_73626;
})();
var statearr_73627_73640 = state_73616__$1;
(statearr_73627_73640[(2)] = inst_73596);

(statearr_73627_73640[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__15091__auto____0 = (function (){
var statearr_73628 = [null,null,null,null,null,null,null,null];
(statearr_73628[(0)] = fluree$db$dbfunctions$fns$state_machine__15091__auto__);

(statearr_73628[(1)] = (1));

return statearr_73628;
});
var fluree$db$dbfunctions$fns$state_machine__15091__auto____1 = (function (state_73616){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_73616);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e73629){var ex__15094__auto__ = e73629;
var statearr_73630_73641 = state_73616;
(statearr_73630_73641[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_73616[(4)]))){
var statearr_73631_73642 = state_73616;
(statearr_73631_73642[(1)] = cljs.core.first((state_73616[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__73643 = state_73616;
state_73616 = G__73643;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__15091__auto__ = function(state_73616){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____1.call(this,state_73616);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_73632 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_73632[(6)] = c__15165__auto__);

return statearr_73632;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq73584){
var G__73585 = cljs.core.first(seq73584);
var seq73584__$1 = cljs.core.next(seq73584);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73585,seq73584__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___73693 = arguments.length;
var i__5769__auto___73694 = (0);
while(true){
if((i__5769__auto___73694 < len__5768__auto___73693)){
args__5774__auto__.push((arguments[i__5769__auto___73694]));

var G__73695 = (i__5769__auto___73694 + (1));
i__5769__auto___73694 = G__73695;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_73676){
var state_val_73677 = (state_73676[(1)]);
if((state_val_73677 === (1))){
var state_73676__$1 = state_73676;
var statearr_73678_73696 = state_73676__$1;
(statearr_73678_73696[(2)] = null);

(statearr_73678_73696[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73677 === (2))){
var _ = (function (){var statearr_73679 = state_73676;
(statearr_73679[(4)] = cljs.core.cons((5),(state_73676[(4)])));

return statearr_73679;
})();
var inst_73652 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_73676__$1 = state_73676;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73676__$1,(6),inst_73652);
} else {
if((state_val_73677 === (3))){
var inst_73674 = (state_73676[(2)]);
var state_73676__$1 = state_73676;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73676__$1,inst_73674);
} else {
if((state_val_73677 === (4))){
var inst_73646 = (state_73676[(2)]);
var state_73676__$1 = state_73676;
var statearr_73681_73697 = state_73676__$1;
(statearr_73681_73697[(2)] = inst_73646);

(statearr_73681_73697[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73677 === (5))){
var _ = (function (){var statearr_73682 = state_73676;
(statearr_73682[(4)] = cljs.core.rest((state_73676[(4)])));

return statearr_73682;
})();
var state_73676__$1 = state_73676;
var ex73680 = (state_73676__$1[(2)]);
var statearr_73683_73698 = state_73676__$1;
(statearr_73683_73698[(5)] = ex73680);


if((ex73680 instanceof Error)){
var statearr_73684_73699 = state_73676__$1;
(statearr_73684_73699[(1)] = (4));

(statearr_73684_73699[(5)] = null);

} else {
throw ex73680;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73677 === (6))){
var inst_73654 = (state_73676[(2)]);
var inst_73655 = fluree.db.util.async.throw_err(inst_73654);
var inst_73656 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_73655);
var inst_73657 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73658 = [inst_73655];
var inst_73659 = (new cljs.core.PersistentVector(null,1,(5),inst_73657,inst_73658,null));
var inst_73660 = cljs.core.count(inst_73659);
var inst_73661 = ((9) + inst_73660);
var inst_73662 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73663 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73664 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73665 = [inst_73655];
var inst_73666 = (new cljs.core.PersistentVector(null,1,(5),inst_73664,inst_73665,null));
var inst_73667 = ["*",inst_73666,inst_73656];
var inst_73668 = cljs.core.PersistentHashMap.fromArrays(inst_73663,inst_73667);
var inst_73669 = [inst_73668,inst_73661];
var inst_73670 = (new cljs.core.PersistentVector(null,2,(5),inst_73662,inst_73669,null));
var inst_73671 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73670);
var _ = (function (){var statearr_73685 = state_73676;
(statearr_73685[(4)] = cljs.core.rest((state_73676[(4)])));

return statearr_73685;
})();
var state_73676__$1 = (function (){var statearr_73686 = state_73676;
(statearr_73686[(7)] = inst_73671);

return statearr_73686;
})();
var statearr_73687_73700 = state_73676__$1;
(statearr_73687_73700[(2)] = inst_73656);

(statearr_73687_73700[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__15091__auto____0 = (function (){
var statearr_73688 = [null,null,null,null,null,null,null,null];
(statearr_73688[(0)] = fluree$db$dbfunctions$fns$state_machine__15091__auto__);

(statearr_73688[(1)] = (1));

return statearr_73688;
});
var fluree$db$dbfunctions$fns$state_machine__15091__auto____1 = (function (state_73676){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_73676);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e73689){var ex__15094__auto__ = e73689;
var statearr_73690_73701 = state_73676;
(statearr_73690_73701[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_73676[(4)]))){
var statearr_73691_73702 = state_73676;
(statearr_73691_73702[(1)] = cljs.core.first((state_73676[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__73703 = state_73676;
state_73676 = G__73703;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__15091__auto__ = function(state_73676){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____1.call(this,state_73676);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_73692 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_73692[(6)] = c__15165__auto__);

return statearr_73692;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq73644){
var G__73645 = cljs.core.first(seq73644);
var seq73644__$1 = cljs.core.next(seq73644);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73645,seq73644__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___73753 = arguments.length;
var i__5769__auto___73754 = (0);
while(true){
if((i__5769__auto___73754 < len__5768__auto___73753)){
args__5774__auto__.push((arguments[i__5769__auto___73754]));

var G__73755 = (i__5769__auto___73754 + (1));
i__5769__auto___73754 = G__73755;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_73736){
var state_val_73737 = (state_73736[(1)]);
if((state_val_73737 === (1))){
var state_73736__$1 = state_73736;
var statearr_73738_73756 = state_73736__$1;
(statearr_73738_73756[(2)] = null);

(statearr_73738_73756[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73737 === (2))){
var _ = (function (){var statearr_73739 = state_73736;
(statearr_73739[(4)] = cljs.core.cons((5),(state_73736[(4)])));

return statearr_73739;
})();
var inst_73712 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_73736__$1 = state_73736;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73736__$1,(6),inst_73712);
} else {
if((state_val_73737 === (3))){
var inst_73734 = (state_73736[(2)]);
var state_73736__$1 = state_73736;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73736__$1,inst_73734);
} else {
if((state_val_73737 === (4))){
var inst_73706 = (state_73736[(2)]);
var state_73736__$1 = state_73736;
var statearr_73741_73757 = state_73736__$1;
(statearr_73741_73757[(2)] = inst_73706);

(statearr_73741_73757[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73737 === (5))){
var _ = (function (){var statearr_73742 = state_73736;
(statearr_73742[(4)] = cljs.core.rest((state_73736[(4)])));

return statearr_73742;
})();
var state_73736__$1 = state_73736;
var ex73740 = (state_73736__$1[(2)]);
var statearr_73743_73758 = state_73736__$1;
(statearr_73743_73758[(5)] = ex73740);


if((ex73740 instanceof Error)){
var statearr_73744_73759 = state_73736__$1;
(statearr_73744_73759[(1)] = (4));

(statearr_73744_73759[(5)] = null);

} else {
throw ex73740;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73737 === (6))){
var inst_73714 = (state_73736[(2)]);
var inst_73715 = fluree.db.util.async.throw_err(inst_73714);
var inst_73716 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_73715);
var inst_73717 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73718 = [inst_73715];
var inst_73719 = (new cljs.core.PersistentVector(null,1,(5),inst_73717,inst_73718,null));
var inst_73720 = cljs.core.count(inst_73719);
var inst_73721 = ((9) + inst_73720);
var inst_73722 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73723 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73724 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73725 = [inst_73715];
var inst_73726 = (new cljs.core.PersistentVector(null,1,(5),inst_73724,inst_73725,null));
var inst_73727 = ["/",inst_73726,inst_73716];
var inst_73728 = cljs.core.PersistentHashMap.fromArrays(inst_73723,inst_73727);
var inst_73729 = [inst_73728,inst_73721];
var inst_73730 = (new cljs.core.PersistentVector(null,2,(5),inst_73722,inst_73729,null));
var inst_73731 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73730);
var _ = (function (){var statearr_73745 = state_73736;
(statearr_73745[(4)] = cljs.core.rest((state_73736[(4)])));

return statearr_73745;
})();
var state_73736__$1 = (function (){var statearr_73746 = state_73736;
(statearr_73746[(7)] = inst_73731);

return statearr_73746;
})();
var statearr_73747_73760 = state_73736__$1;
(statearr_73747_73760[(2)] = inst_73716);

(statearr_73747_73760[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__15091__auto____0 = (function (){
var statearr_73748 = [null,null,null,null,null,null,null,null];
(statearr_73748[(0)] = fluree$db$dbfunctions$fns$state_machine__15091__auto__);

(statearr_73748[(1)] = (1));

return statearr_73748;
});
var fluree$db$dbfunctions$fns$state_machine__15091__auto____1 = (function (state_73736){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_73736);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e73749){var ex__15094__auto__ = e73749;
var statearr_73750_73761 = state_73736;
(statearr_73750_73761[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_73736[(4)]))){
var statearr_73751_73762 = state_73736;
(statearr_73751_73762[(1)] = cljs.core.first((state_73736[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__73763 = state_73736;
state_73736 = G__73763;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__15091__auto__ = function(state_73736){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____1.call(this,state_73736);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_73752 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_73752[(6)] = c__15165__auto__);

return statearr_73752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq73704){
var G__73705 = cljs.core.first(seq73704);
var seq73704__$1 = cljs.core.next(seq73704);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73705,seq73704__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_73801){
var state_val_73802 = (state_73801[(1)]);
if((state_val_73802 === (7))){
var state_73801__$1 = state_73801;
var statearr_73803_73827 = state_73801__$1;
(statearr_73803_73827[(2)] = n);

(statearr_73803_73827[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73802 === (1))){
var state_73801__$1 = state_73801;
var statearr_73804_73828 = state_73801__$1;
(statearr_73804_73828[(2)] = null);

(statearr_73804_73828[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73802 === (4))){
var inst_73764 = (state_73801[(2)]);
var state_73801__$1 = state_73801;
var statearr_73805_73829 = state_73801__$1;
(statearr_73805_73829[(2)] = inst_73764);

(statearr_73805_73829[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73802 === (13))){
var inst_73781 = (state_73801[(2)]);
var inst_73782 = fluree.db.util.async.throw_err(inst_73781);
var state_73801__$1 = state_73801;
var statearr_73806_73830 = state_73801__$1;
(statearr_73806_73830[(2)] = inst_73782);

(statearr_73806_73830[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73802 === (6))){
var state_73801__$1 = state_73801;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73801__$1,(9),n);
} else {
if((state_val_73802 === (3))){
var inst_73799 = (state_73801[(2)]);
var state_73801__$1 = state_73801;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73801__$1,inst_73799);
} else {
if((state_val_73802 === (12))){
var inst_73777 = (state_73801[(7)]);
var inst_73785 = (state_73801[(2)]);
var inst_73786 = fluree.db.dbfunctions.internal.quot(inst_73777,inst_73785);
var inst_73787 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73788 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73790 = [inst_73777,inst_73785];
var inst_73791 = (new cljs.core.PersistentVector(null,2,(5),inst_73789,inst_73790,null));
var inst_73792 = ["quot",inst_73791,inst_73786];
var inst_73793 = cljs.core.PersistentHashMap.fromArrays(inst_73788,inst_73792);
var inst_73794 = [inst_73793,(2)];
var inst_73795 = (new cljs.core.PersistentVector(null,2,(5),inst_73787,inst_73794,null));
var inst_73796 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73795);
var _ = (function (){var statearr_73807 = state_73801;
(statearr_73807[(4)] = cljs.core.rest((state_73801[(4)])));

return statearr_73807;
})();
var state_73801__$1 = (function (){var statearr_73808 = state_73801;
(statearr_73808[(8)] = inst_73796);

return statearr_73808;
})();
var statearr_73809_73831 = state_73801__$1;
(statearr_73809_73831[(2)] = inst_73786);

(statearr_73809_73831[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73802 === (2))){
var _ = (function (){var statearr_73810 = state_73801;
(statearr_73810[(4)] = cljs.core.cons((5),(state_73801[(4)])));

return statearr_73810;
})();
var inst_73770 = fluree.db.util.async.channel_QMARK_(n);
var state_73801__$1 = state_73801;
if(inst_73770){
var statearr_73811_73832 = state_73801__$1;
(statearr_73811_73832[(1)] = (6));

} else {
var statearr_73812_73833 = state_73801__$1;
(statearr_73812_73833[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73802 === (11))){
var state_73801__$1 = state_73801;
var statearr_73814_73834 = state_73801__$1;
(statearr_73814_73834[(2)] = d);

(statearr_73814_73834[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73802 === (9))){
var inst_73773 = (state_73801[(2)]);
var inst_73774 = fluree.db.util.async.throw_err(inst_73773);
var state_73801__$1 = state_73801;
var statearr_73815_73835 = state_73801__$1;
(statearr_73815_73835[(2)] = inst_73774);

(statearr_73815_73835[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73802 === (5))){
var _ = (function (){var statearr_73816 = state_73801;
(statearr_73816[(4)] = cljs.core.rest((state_73801[(4)])));

return statearr_73816;
})();
var state_73801__$1 = state_73801;
var ex73813 = (state_73801__$1[(2)]);
var statearr_73817_73836 = state_73801__$1;
(statearr_73817_73836[(5)] = ex73813);


if((ex73813 instanceof Error)){
var statearr_73818_73837 = state_73801__$1;
(statearr_73818_73837[(1)] = (4));

(statearr_73818_73837[(5)] = null);

} else {
throw ex73813;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73802 === (10))){
var state_73801__$1 = state_73801;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73801__$1,(13),d);
} else {
if((state_val_73802 === (8))){
var inst_73777 = (state_73801[(2)]);
var inst_73778 = fluree.db.util.async.channel_QMARK_(d);
var state_73801__$1 = (function (){var statearr_73819 = state_73801;
(statearr_73819[(7)] = inst_73777);

return statearr_73819;
})();
if(inst_73778){
var statearr_73820_73838 = state_73801__$1;
(statearr_73820_73838[(1)] = (10));

} else {
var statearr_73821_73839 = state_73801__$1;
(statearr_73821_73839[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__15091__auto____0 = (function (){
var statearr_73822 = [null,null,null,null,null,null,null,null,null];
(statearr_73822[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__15091__auto__);

(statearr_73822[(1)] = (1));

return statearr_73822;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__15091__auto____1 = (function (state_73801){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_73801);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e73823){var ex__15094__auto__ = e73823;
var statearr_73824_73840 = state_73801;
(statearr_73824_73840[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_73801[(4)]))){
var statearr_73825_73841 = state_73801;
(statearr_73825_73841[(1)] = cljs.core.first((state_73801[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__73842 = state_73801;
state_73801 = G__73842;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__15091__auto__ = function(state_73801){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__15091__auto____1.call(this,state_73801);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_73826 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_73826[(6)] = c__15165__auto__);

return statearr_73826;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_73880){
var state_val_73881 = (state_73880[(1)]);
if((state_val_73881 === (7))){
var state_73880__$1 = state_73880;
var statearr_73882_73906 = state_73880__$1;
(statearr_73882_73906[(2)] = n);

(statearr_73882_73906[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73881 === (1))){
var state_73880__$1 = state_73880;
var statearr_73883_73907 = state_73880__$1;
(statearr_73883_73907[(2)] = null);

(statearr_73883_73907[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73881 === (4))){
var inst_73843 = (state_73880[(2)]);
var state_73880__$1 = state_73880;
var statearr_73884_73908 = state_73880__$1;
(statearr_73884_73908[(2)] = inst_73843);

(statearr_73884_73908[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73881 === (13))){
var inst_73860 = (state_73880[(2)]);
var inst_73861 = fluree.db.util.async.throw_err(inst_73860);
var state_73880__$1 = state_73880;
var statearr_73885_73909 = state_73880__$1;
(statearr_73885_73909[(2)] = inst_73861);

(statearr_73885_73909[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73881 === (6))){
var state_73880__$1 = state_73880;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73880__$1,(9),n);
} else {
if((state_val_73881 === (3))){
var inst_73878 = (state_73880[(2)]);
var state_73880__$1 = state_73880;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73880__$1,inst_73878);
} else {
if((state_val_73881 === (12))){
var inst_73856 = (state_73880[(7)]);
var inst_73864 = (state_73880[(2)]);
var inst_73865 = fluree.db.dbfunctions.internal.mod(inst_73856,inst_73864);
var inst_73866 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73867 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73868 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73869 = [inst_73856,inst_73864];
var inst_73870 = (new cljs.core.PersistentVector(null,2,(5),inst_73868,inst_73869,null));
var inst_73871 = ["mod",inst_73870,inst_73865];
var inst_73872 = cljs.core.PersistentHashMap.fromArrays(inst_73867,inst_73871);
var inst_73873 = [inst_73872,(2)];
var inst_73874 = (new cljs.core.PersistentVector(null,2,(5),inst_73866,inst_73873,null));
var inst_73875 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73874);
var _ = (function (){var statearr_73886 = state_73880;
(statearr_73886[(4)] = cljs.core.rest((state_73880[(4)])));

return statearr_73886;
})();
var state_73880__$1 = (function (){var statearr_73887 = state_73880;
(statearr_73887[(8)] = inst_73875);

return statearr_73887;
})();
var statearr_73888_73910 = state_73880__$1;
(statearr_73888_73910[(2)] = inst_73865);

(statearr_73888_73910[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73881 === (2))){
var _ = (function (){var statearr_73889 = state_73880;
(statearr_73889[(4)] = cljs.core.cons((5),(state_73880[(4)])));

return statearr_73889;
})();
var inst_73849 = fluree.db.util.async.channel_QMARK_(n);
var state_73880__$1 = state_73880;
if(inst_73849){
var statearr_73890_73911 = state_73880__$1;
(statearr_73890_73911[(1)] = (6));

} else {
var statearr_73891_73912 = state_73880__$1;
(statearr_73891_73912[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73881 === (11))){
var state_73880__$1 = state_73880;
var statearr_73893_73913 = state_73880__$1;
(statearr_73893_73913[(2)] = d);

(statearr_73893_73913[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73881 === (9))){
var inst_73852 = (state_73880[(2)]);
var inst_73853 = fluree.db.util.async.throw_err(inst_73852);
var state_73880__$1 = state_73880;
var statearr_73894_73914 = state_73880__$1;
(statearr_73894_73914[(2)] = inst_73853);

(statearr_73894_73914[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73881 === (5))){
var _ = (function (){var statearr_73895 = state_73880;
(statearr_73895[(4)] = cljs.core.rest((state_73880[(4)])));

return statearr_73895;
})();
var state_73880__$1 = state_73880;
var ex73892 = (state_73880__$1[(2)]);
var statearr_73896_73915 = state_73880__$1;
(statearr_73896_73915[(5)] = ex73892);


if((ex73892 instanceof Error)){
var statearr_73897_73916 = state_73880__$1;
(statearr_73897_73916[(1)] = (4));

(statearr_73897_73916[(5)] = null);

} else {
throw ex73892;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73881 === (10))){
var state_73880__$1 = state_73880;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73880__$1,(13),d);
} else {
if((state_val_73881 === (8))){
var inst_73856 = (state_73880[(2)]);
var inst_73857 = fluree.db.util.async.channel_QMARK_(d);
var state_73880__$1 = (function (){var statearr_73898 = state_73880;
(statearr_73898[(7)] = inst_73856);

return statearr_73898;
})();
if(inst_73857){
var statearr_73899_73917 = state_73880__$1;
(statearr_73899_73917[(1)] = (10));

} else {
var statearr_73900_73918 = state_73880__$1;
(statearr_73900_73918[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__15091__auto____0 = (function (){
var statearr_73901 = [null,null,null,null,null,null,null,null,null];
(statearr_73901[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__15091__auto__);

(statearr_73901[(1)] = (1));

return statearr_73901;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__15091__auto____1 = (function (state_73880){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_73880);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e73902){var ex__15094__auto__ = e73902;
var statearr_73903_73919 = state_73880;
(statearr_73903_73919[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_73880[(4)]))){
var statearr_73904_73920 = state_73880;
(statearr_73904_73920[(1)] = cljs.core.first((state_73880[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__73921 = state_73880;
state_73880 = G__73921;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__15091__auto__ = function(state_73880){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__15091__auto____1.call(this,state_73880);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_73905 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_73905[(6)] = c__15165__auto__);

return statearr_73905;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_73959){
var state_val_73960 = (state_73959[(1)]);
if((state_val_73960 === (7))){
var state_73959__$1 = state_73959;
var statearr_73961_73985 = state_73959__$1;
(statearr_73961_73985[(2)] = n);

(statearr_73961_73985[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73960 === (1))){
var state_73959__$1 = state_73959;
var statearr_73962_73986 = state_73959__$1;
(statearr_73962_73986[(2)] = null);

(statearr_73962_73986[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73960 === (4))){
var inst_73922 = (state_73959[(2)]);
var state_73959__$1 = state_73959;
var statearr_73963_73987 = state_73959__$1;
(statearr_73963_73987[(2)] = inst_73922);

(statearr_73963_73987[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73960 === (13))){
var inst_73939 = (state_73959[(2)]);
var inst_73940 = fluree.db.util.async.throw_err(inst_73939);
var state_73959__$1 = state_73959;
var statearr_73964_73988 = state_73959__$1;
(statearr_73964_73988[(2)] = inst_73940);

(statearr_73964_73988[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73960 === (6))){
var state_73959__$1 = state_73959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73959__$1,(9),n);
} else {
if((state_val_73960 === (3))){
var inst_73957 = (state_73959[(2)]);
var state_73959__$1 = state_73959;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73959__$1,inst_73957);
} else {
if((state_val_73960 === (12))){
var inst_73935 = (state_73959[(7)]);
var inst_73943 = (state_73959[(2)]);
var inst_73944 = fluree.db.dbfunctions.internal.rem(inst_73935,inst_73943);
var inst_73945 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73946 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73947 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73948 = [inst_73935,inst_73943];
var inst_73949 = (new cljs.core.PersistentVector(null,2,(5),inst_73947,inst_73948,null));
var inst_73950 = ["rem",inst_73949,inst_73944];
var inst_73951 = cljs.core.PersistentHashMap.fromArrays(inst_73946,inst_73950);
var inst_73952 = [inst_73951,(2)];
var inst_73953 = (new cljs.core.PersistentVector(null,2,(5),inst_73945,inst_73952,null));
var inst_73954 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73953);
var _ = (function (){var statearr_73965 = state_73959;
(statearr_73965[(4)] = cljs.core.rest((state_73959[(4)])));

return statearr_73965;
})();
var state_73959__$1 = (function (){var statearr_73966 = state_73959;
(statearr_73966[(8)] = inst_73954);

return statearr_73966;
})();
var statearr_73967_73989 = state_73959__$1;
(statearr_73967_73989[(2)] = inst_73944);

(statearr_73967_73989[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73960 === (2))){
var _ = (function (){var statearr_73968 = state_73959;
(statearr_73968[(4)] = cljs.core.cons((5),(state_73959[(4)])));

return statearr_73968;
})();
var inst_73928 = fluree.db.util.async.channel_QMARK_(n);
var state_73959__$1 = state_73959;
if(inst_73928){
var statearr_73969_73990 = state_73959__$1;
(statearr_73969_73990[(1)] = (6));

} else {
var statearr_73970_73991 = state_73959__$1;
(statearr_73970_73991[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73960 === (11))){
var state_73959__$1 = state_73959;
var statearr_73972_73992 = state_73959__$1;
(statearr_73972_73992[(2)] = d);

(statearr_73972_73992[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73960 === (9))){
var inst_73931 = (state_73959[(2)]);
var inst_73932 = fluree.db.util.async.throw_err(inst_73931);
var state_73959__$1 = state_73959;
var statearr_73973_73993 = state_73959__$1;
(statearr_73973_73993[(2)] = inst_73932);

(statearr_73973_73993[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73960 === (5))){
var _ = (function (){var statearr_73974 = state_73959;
(statearr_73974[(4)] = cljs.core.rest((state_73959[(4)])));

return statearr_73974;
})();
var state_73959__$1 = state_73959;
var ex73971 = (state_73959__$1[(2)]);
var statearr_73975_73994 = state_73959__$1;
(statearr_73975_73994[(5)] = ex73971);


if((ex73971 instanceof Error)){
var statearr_73976_73995 = state_73959__$1;
(statearr_73976_73995[(1)] = (4));

(statearr_73976_73995[(5)] = null);

} else {
throw ex73971;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73960 === (10))){
var state_73959__$1 = state_73959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73959__$1,(13),d);
} else {
if((state_val_73960 === (8))){
var inst_73935 = (state_73959[(2)]);
var inst_73936 = fluree.db.util.async.channel_QMARK_(d);
var state_73959__$1 = (function (){var statearr_73977 = state_73959;
(statearr_73977[(7)] = inst_73935);

return statearr_73977;
})();
if(inst_73936){
var statearr_73978_73996 = state_73959__$1;
(statearr_73978_73996[(1)] = (10));

} else {
var statearr_73979_73997 = state_73959__$1;
(statearr_73979_73997[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__15091__auto____0 = (function (){
var statearr_73980 = [null,null,null,null,null,null,null,null,null];
(statearr_73980[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__15091__auto__);

(statearr_73980[(1)] = (1));

return statearr_73980;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__15091__auto____1 = (function (state_73959){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_73959);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e73981){var ex__15094__auto__ = e73981;
var statearr_73982_73998 = state_73959;
(statearr_73982_73998[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_73959[(4)]))){
var statearr_73983_73999 = state_73959;
(statearr_73983_73999[(1)] = cljs.core.first((state_73959[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__74000 = state_73959;
state_73959 = G__74000;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__15091__auto__ = function(state_73959){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__15091__auto____1.call(this,state_73959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_73984 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_73984[(6)] = c__15165__auto__);

return statearr_73984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_74027){
var state_val_74028 = (state_74027[(1)]);
if((state_val_74028 === (7))){
var state_74027__$1 = state_74027;
var statearr_74029_74048 = state_74027__$1;
(statearr_74029_74048[(2)] = x);

(statearr_74029_74048[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74028 === (1))){
var state_74027__$1 = state_74027;
var statearr_74030_74049 = state_74027__$1;
(statearr_74030_74049[(2)] = null);

(statearr_74030_74049[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74028 === (4))){
var inst_74001 = (state_74027[(2)]);
var state_74027__$1 = state_74027;
var statearr_74031_74050 = state_74027__$1;
(statearr_74031_74050[(2)] = inst_74001);

(statearr_74031_74050[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74028 === (6))){
var state_74027__$1 = state_74027;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74027__$1,(9),x);
} else {
if((state_val_74028 === (3))){
var inst_74025 = (state_74027[(2)]);
var state_74027__$1 = state_74027;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74027__$1,inst_74025);
} else {
if((state_val_74028 === (2))){
var _ = (function (){var statearr_74033 = state_74027;
(statearr_74033[(4)] = cljs.core.cons((5),(state_74027[(4)])));

return statearr_74033;
})();
var inst_74007 = fluree.db.util.async.channel_QMARK_(x);
var state_74027__$1 = state_74027;
if(inst_74007){
var statearr_74034_74051 = state_74027__$1;
(statearr_74034_74051[(1)] = (6));

} else {
var statearr_74035_74052 = state_74027__$1;
(statearr_74035_74052[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74028 === (9))){
var inst_74010 = (state_74027[(2)]);
var inst_74011 = fluree.db.util.async.throw_err(inst_74010);
var state_74027__$1 = state_74027;
var statearr_74036_74053 = state_74027__$1;
(statearr_74036_74053[(2)] = inst_74011);

(statearr_74036_74053[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74028 === (5))){
var _ = (function (){var statearr_74037 = state_74027;
(statearr_74037[(4)] = cljs.core.rest((state_74027[(4)])));

return statearr_74037;
})();
var state_74027__$1 = state_74027;
var ex74032 = (state_74027__$1[(2)]);
var statearr_74038_74054 = state_74027__$1;
(statearr_74038_74054[(5)] = ex74032);


if((ex74032 instanceof Error)){
var statearr_74039_74055 = state_74027__$1;
(statearr_74039_74055[(1)] = (4));

(statearr_74039_74055[(5)] = null);

} else {
throw ex74032;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74028 === (8))){
var inst_74014 = (state_74027[(2)]);
var inst_74015 = fluree.db.dbfunctions.internal.boolean$(inst_74014);
var inst_74016 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74017 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74018 = ["boolean",inst_74014,inst_74015];
var inst_74019 = cljs.core.PersistentHashMap.fromArrays(inst_74017,inst_74018);
var inst_74020 = [inst_74019,(10)];
var inst_74021 = (new cljs.core.PersistentVector(null,2,(5),inst_74016,inst_74020,null));
var inst_74022 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74021);
var _ = (function (){var statearr_74040 = state_74027;
(statearr_74040[(4)] = cljs.core.rest((state_74027[(4)])));

return statearr_74040;
})();
var state_74027__$1 = (function (){var statearr_74041 = state_74027;
(statearr_74041[(7)] = inst_74022);

return statearr_74041;
})();
var statearr_74042_74056 = state_74027__$1;
(statearr_74042_74056[(2)] = inst_74015);

(statearr_74042_74056[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__15091__auto____0 = (function (){
var statearr_74043 = [null,null,null,null,null,null,null,null];
(statearr_74043[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__15091__auto__);

(statearr_74043[(1)] = (1));

return statearr_74043;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__15091__auto____1 = (function (state_74027){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_74027);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e74044){var ex__15094__auto__ = e74044;
var statearr_74045_74057 = state_74027;
(statearr_74045_74057[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_74027[(4)]))){
var statearr_74046_74058 = state_74027;
(statearr_74046_74058[(1)] = cljs.core.first((state_74027[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__74059 = state_74027;
state_74027 = G__74059;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__15091__auto__ = function(state_74027){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__15091__auto____1.call(this,state_74027);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_74047 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_74047[(6)] = c__15165__auto__);

return statearr_74047;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_74097){
var state_val_74098 = (state_74097[(1)]);
if((state_val_74098 === (7))){
var state_74097__$1 = state_74097;
var statearr_74099_74123 = state_74097__$1;
(statearr_74099_74123[(2)] = pattern);

(statearr_74099_74123[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74098 === (1))){
var state_74097__$1 = state_74097;
var statearr_74100_74124 = state_74097__$1;
(statearr_74100_74124[(2)] = null);

(statearr_74100_74124[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74098 === (4))){
var inst_74060 = (state_74097[(2)]);
var state_74097__$1 = state_74097;
var statearr_74101_74125 = state_74097__$1;
(statearr_74101_74125[(2)] = inst_74060);

(statearr_74101_74125[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74098 === (13))){
var inst_74077 = (state_74097[(2)]);
var inst_74078 = fluree.db.util.async.throw_err(inst_74077);
var state_74097__$1 = state_74097;
var statearr_74102_74126 = state_74097__$1;
(statearr_74102_74126[(2)] = inst_74078);

(statearr_74102_74126[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74098 === (6))){
var state_74097__$1 = state_74097;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74097__$1,(9),pattern);
} else {
if((state_val_74098 === (3))){
var inst_74095 = (state_74097[(2)]);
var state_74097__$1 = state_74097;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74097__$1,inst_74095);
} else {
if((state_val_74098 === (12))){
var inst_74073 = (state_74097[(7)]);
var inst_74081 = (state_74097[(2)]);
var inst_74082 = fluree.db.dbfunctions.internal.re_find(inst_74073,inst_74081);
var inst_74083 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74084 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74085 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74086 = [inst_74073,inst_74081];
var inst_74087 = (new cljs.core.PersistentVector(null,2,(5),inst_74085,inst_74086,null));
var inst_74088 = ["re-find",inst_74087,inst_74082];
var inst_74089 = cljs.core.PersistentHashMap.fromArrays(inst_74084,inst_74088);
var inst_74090 = [inst_74089,(10)];
var inst_74091 = (new cljs.core.PersistentVector(null,2,(5),inst_74083,inst_74090,null));
var inst_74092 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74091);
var _ = (function (){var statearr_74103 = state_74097;
(statearr_74103[(4)] = cljs.core.rest((state_74097[(4)])));

return statearr_74103;
})();
var state_74097__$1 = (function (){var statearr_74104 = state_74097;
(statearr_74104[(8)] = inst_74092);

return statearr_74104;
})();
var statearr_74105_74127 = state_74097__$1;
(statearr_74105_74127[(2)] = inst_74082);

(statearr_74105_74127[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74098 === (2))){
var _ = (function (){var statearr_74106 = state_74097;
(statearr_74106[(4)] = cljs.core.cons((5),(state_74097[(4)])));

return statearr_74106;
})();
var inst_74066 = fluree.db.util.async.channel_QMARK_(pattern);
var state_74097__$1 = state_74097;
if(inst_74066){
var statearr_74107_74128 = state_74097__$1;
(statearr_74107_74128[(1)] = (6));

} else {
var statearr_74108_74129 = state_74097__$1;
(statearr_74108_74129[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74098 === (11))){
var state_74097__$1 = state_74097;
var statearr_74110_74130 = state_74097__$1;
(statearr_74110_74130[(2)] = string);

(statearr_74110_74130[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74098 === (9))){
var inst_74069 = (state_74097[(2)]);
var inst_74070 = fluree.db.util.async.throw_err(inst_74069);
var state_74097__$1 = state_74097;
var statearr_74111_74131 = state_74097__$1;
(statearr_74111_74131[(2)] = inst_74070);

(statearr_74111_74131[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74098 === (5))){
var _ = (function (){var statearr_74112 = state_74097;
(statearr_74112[(4)] = cljs.core.rest((state_74097[(4)])));

return statearr_74112;
})();
var state_74097__$1 = state_74097;
var ex74109 = (state_74097__$1[(2)]);
var statearr_74113_74132 = state_74097__$1;
(statearr_74113_74132[(5)] = ex74109);


if((ex74109 instanceof Error)){
var statearr_74114_74133 = state_74097__$1;
(statearr_74114_74133[(1)] = (4));

(statearr_74114_74133[(5)] = null);

} else {
throw ex74109;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74098 === (10))){
var state_74097__$1 = state_74097;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74097__$1,(13),string);
} else {
if((state_val_74098 === (8))){
var inst_74073 = (state_74097[(2)]);
var inst_74074 = fluree.db.util.async.channel_QMARK_(string);
var state_74097__$1 = (function (){var statearr_74115 = state_74097;
(statearr_74115[(7)] = inst_74073);

return statearr_74115;
})();
if(inst_74074){
var statearr_74116_74134 = state_74097__$1;
(statearr_74116_74134[(1)] = (10));

} else {
var statearr_74117_74135 = state_74097__$1;
(statearr_74117_74135[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__15091__auto____0 = (function (){
var statearr_74118 = [null,null,null,null,null,null,null,null,null];
(statearr_74118[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__15091__auto__);

(statearr_74118[(1)] = (1));

return statearr_74118;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__15091__auto____1 = (function (state_74097){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_74097);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e74119){var ex__15094__auto__ = e74119;
var statearr_74120_74136 = state_74097;
(statearr_74120_74136[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_74097[(4)]))){
var statearr_74121_74137 = state_74097;
(statearr_74121_74137[(1)] = cljs.core.first((state_74097[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__74138 = state_74097;
state_74097 = G__74138;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__15091__auto__ = function(state_74097){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__15091__auto____1.call(this,state_74097);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_74122 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_74122[(6)] = c__15165__auto__);

return statearr_74122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_74165){
var state_val_74166 = (state_74165[(1)]);
if((state_val_74166 === (7))){
var state_74165__$1 = state_74165;
var statearr_74167_74186 = state_74165__$1;
(statearr_74167_74186[(2)] = email);

(statearr_74167_74186[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74166 === (1))){
var state_74165__$1 = state_74165;
var statearr_74168_74187 = state_74165__$1;
(statearr_74168_74187[(2)] = null);

(statearr_74168_74187[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74166 === (4))){
var inst_74139 = (state_74165[(2)]);
var state_74165__$1 = state_74165;
var statearr_74169_74188 = state_74165__$1;
(statearr_74169_74188[(2)] = inst_74139);

(statearr_74169_74188[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74166 === (6))){
var state_74165__$1 = state_74165;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74165__$1,(9),email);
} else {
if((state_val_74166 === (3))){
var inst_74163 = (state_74165[(2)]);
var state_74165__$1 = state_74165;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74165__$1,inst_74163);
} else {
if((state_val_74166 === (2))){
var _ = (function (){var statearr_74171 = state_74165;
(statearr_74171[(4)] = cljs.core.cons((5),(state_74165[(4)])));

return statearr_74171;
})();
var inst_74145 = fluree.db.util.async.channel_QMARK_(email);
var state_74165__$1 = state_74165;
if(inst_74145){
var statearr_74172_74189 = state_74165__$1;
(statearr_74172_74189[(1)] = (6));

} else {
var statearr_74173_74190 = state_74165__$1;
(statearr_74173_74190[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74166 === (9))){
var inst_74148 = (state_74165[(2)]);
var inst_74149 = fluree.db.util.async.throw_err(inst_74148);
var state_74165__$1 = state_74165;
var statearr_74174_74191 = state_74165__$1;
(statearr_74174_74191[(2)] = inst_74149);

(statearr_74174_74191[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74166 === (5))){
var _ = (function (){var statearr_74175 = state_74165;
(statearr_74175[(4)] = cljs.core.rest((state_74165[(4)])));

return statearr_74175;
})();
var state_74165__$1 = state_74165;
var ex74170 = (state_74165__$1[(2)]);
var statearr_74176_74192 = state_74165__$1;
(statearr_74176_74192[(5)] = ex74170);


if((ex74170 instanceof Error)){
var statearr_74177_74193 = state_74165__$1;
(statearr_74177_74193[(1)] = (4));

(statearr_74177_74193[(5)] = null);

} else {
throw ex74170;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74166 === (8))){
var inst_74152 = (state_74165[(2)]);
var inst_74153 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_74152);
var inst_74154 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74155 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74156 = ["re-find",inst_74152,inst_74153];
var inst_74157 = cljs.core.PersistentHashMap.fromArrays(inst_74155,inst_74156);
var inst_74158 = [inst_74157,(10)];
var inst_74159 = (new cljs.core.PersistentVector(null,2,(5),inst_74154,inst_74158,null));
var inst_74160 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74159);
var _ = (function (){var statearr_74178 = state_74165;
(statearr_74178[(4)] = cljs.core.rest((state_74165[(4)])));

return statearr_74178;
})();
var state_74165__$1 = (function (){var statearr_74179 = state_74165;
(statearr_74179[(7)] = inst_74160);

return statearr_74179;
})();
var statearr_74180_74194 = state_74165__$1;
(statearr_74180_74194[(2)] = inst_74153);

(statearr_74180_74194[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__15091__auto____0 = (function (){
var statearr_74181 = [null,null,null,null,null,null,null,null];
(statearr_74181[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__15091__auto__);

(statearr_74181[(1)] = (1));

return statearr_74181;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__15091__auto____1 = (function (state_74165){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_74165);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e74182){var ex__15094__auto__ = e74182;
var statearr_74183_74195 = state_74165;
(statearr_74183_74195[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_74165[(4)]))){
var statearr_74184_74196 = state_74165;
(statearr_74184_74196[(1)] = cljs.core.first((state_74165[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__74197 = state_74165;
state_74165 = G__74197;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__15091__auto__ = function(state_74165){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__15091__auto____1.call(this,state_74165);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_74185 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_74185[(6)] = c__15165__auto__);

return statearr_74185;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_74244){
var state_val_74245 = (state_74244[(1)]);
if((state_val_74245 === (7))){
var inst_74214 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_74244__$1 = state_74244;
if(cljs.core.truth_(inst_74214)){
var statearr_74246_74273 = state_74244__$1;
(statearr_74246_74273[(1)] = (9));

} else {
var statearr_74247_74274 = state_74244__$1;
(statearr_74247_74274[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74245 === (1))){
var state_74244__$1 = state_74244;
var statearr_74248_74275 = state_74244__$1;
(statearr_74248_74275[(2)] = null);

(statearr_74248_74275[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74245 === (4))){
var inst_74198 = (state_74244[(2)]);
var state_74244__$1 = state_74244;
var statearr_74249_74276 = state_74244__$1;
(statearr_74249_74276[(2)] = inst_74198);

(statearr_74249_74276[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74245 === (15))){
var inst_74225 = (state_74244[(2)]);
var state_74244__$1 = state_74244;
var statearr_74250_74277 = state_74244__$1;
(statearr_74250_74277[(2)] = inst_74225);

(statearr_74250_74277[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74245 === (13))){
var inst_74222 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_74244__$1 = state_74244;
var statearr_74251_74278 = state_74244__$1;
(statearr_74251_74278[(2)] = inst_74222);

(statearr_74251_74278[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74245 === (6))){
var inst_74209 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74210 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_74211 = [inst_74210,(0)];
var inst_74212 = (new cljs.core.PersistentVector(null,2,(5),inst_74209,inst_74211,null));
var state_74244__$1 = state_74244;
var statearr_74252_74279 = state_74244__$1;
(statearr_74252_74279[(2)] = inst_74212);

(statearr_74252_74279[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74245 === (3))){
var inst_74242 = (state_74244[(2)]);
var state_74244__$1 = state_74244;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74244__$1,inst_74242);
} else {
if((state_val_74245 === (12))){
var inst_74218 = (state_74244[(2)]);
var inst_74219 = fluree.db.util.async.throw_err(inst_74218);
var state_74244__$1 = state_74244;
var statearr_74253_74280 = state_74244__$1;
(statearr_74253_74280[(2)] = inst_74219);

(statearr_74253_74280[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74245 === (2))){
var _ = (function (){var statearr_74254 = state_74244;
(statearr_74254[(4)] = cljs.core.cons((5),(state_74244[(4)])));

return statearr_74254;
})();
var inst_74207 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_74244__$1 = state_74244;
if(cljs.core.truth_(inst_74207)){
var statearr_74255_74281 = state_74244__$1;
(statearr_74255_74281[(1)] = (6));

} else {
var statearr_74256_74282 = state_74244__$1;
(statearr_74256_74282[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74245 === (11))){
var inst_74227 = (state_74244[(2)]);
var state_74244__$1 = state_74244;
var statearr_74258_74283 = state_74244__$1;
(statearr_74258_74283[(2)] = inst_74227);

(statearr_74258_74283[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74245 === (9))){
var inst_74216 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_74244__$1 = state_74244;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74244__$1,(12),inst_74216);
} else {
if((state_val_74245 === (5))){
var _ = (function (){var statearr_74259 = state_74244;
(statearr_74259[(4)] = cljs.core.rest((state_74244[(4)])));

return statearr_74259;
})();
var state_74244__$1 = state_74244;
var ex74257 = (state_74244__$1[(2)]);
var statearr_74260_74284 = state_74244__$1;
(statearr_74260_74284[(5)] = ex74257);


if((ex74257 instanceof Error)){
var statearr_74261_74285 = state_74244__$1;
(statearr_74261_74285[(1)] = (4));

(statearr_74261_74285[(5)] = null);

} else {
throw ex74257;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74245 === (14))){
var state_74244__$1 = state_74244;
var statearr_74262_74286 = state_74244__$1;
(statearr_74262_74286[(2)] = null);

(statearr_74262_74286[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74245 === (10))){
var state_74244__$1 = state_74244;
var statearr_74263_74287 = state_74244__$1;
(statearr_74263_74287[(1)] = (13));



return cljs.core.cst$kw$recur;
} else {
if((state_val_74245 === (8))){
var inst_74229 = (state_74244[(2)]);
var inst_74230 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74229,(0),null);
var inst_74231 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74229,(1),null);
var inst_74232 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74233 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74234 = ["?user_id","?ctx",inst_74230];
var inst_74235 = cljs.core.PersistentHashMap.fromArrays(inst_74233,inst_74234);
var inst_74236 = ((10) + inst_74231);
var inst_74237 = [inst_74235,inst_74236];
var inst_74238 = (new cljs.core.PersistentVector(null,2,(5),inst_74232,inst_74237,null));
var inst_74239 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74238);
var _ = (function (){var statearr_74265 = state_74244;
(statearr_74265[(4)] = cljs.core.rest((state_74244[(4)])));

return statearr_74265;
})();
var state_74244__$1 = (function (){var statearr_74266 = state_74244;
(statearr_74266[(7)] = inst_74239);

return statearr_74266;
})();
var statearr_74267_74288 = state_74244__$1;
(statearr_74267_74288[(2)] = inst_74230);

(statearr_74267_74288[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__15091__auto____0 = (function (){
var statearr_74268 = [null,null,null,null,null,null,null,null];
(statearr_74268[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__15091__auto__);

(statearr_74268[(1)] = (1));

return statearr_74268;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__15091__auto____1 = (function (state_74244){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_74244);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e74269){var ex__15094__auto__ = e74269;
var statearr_74270_74289 = state_74244;
(statearr_74270_74289[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_74244[(4)]))){
var statearr_74271_74290 = state_74244;
(statearr_74271_74290[(1)] = cljs.core.first((state_74244[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__74291 = state_74244;
state_74244 = G__74291;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__15091__auto__ = function(state_74244){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__15091__auto____1.call(this,state_74244);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_74272 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_74272[(6)] = c__15165__auto__);

return statearr_74272;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_74319){
var state_val_74320 = (state_74319[(1)]);
if((state_val_74320 === (7))){
var inst_74312 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_74319__$1 = state_74319;
var statearr_74321_74340 = state_74319__$1;
(statearr_74321_74340[(2)] = inst_74312);

(statearr_74321_74340[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74320 === (1))){
var state_74319__$1 = state_74319;
var statearr_74322_74341 = state_74319__$1;
(statearr_74322_74341[(2)] = null);

(statearr_74322_74341[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74320 === (4))){
var inst_74292 = (state_74319[(2)]);
var state_74319__$1 = state_74319;
var statearr_74323_74342 = state_74319__$1;
(statearr_74323_74342[(2)] = inst_74292);

(statearr_74323_74342[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74320 === (6))){
var inst_74300 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_74319__$1 = state_74319;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74319__$1,(9),inst_74300);
} else {
if((state_val_74320 === (3))){
var inst_74317 = (state_74319[(2)]);
var state_74319__$1 = state_74319;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74319__$1,inst_74317);
} else {
if((state_val_74320 === (2))){
var _ = (function (){var statearr_74325 = state_74319;
(statearr_74325[(4)] = cljs.core.cons((5),(state_74319[(4)])));

return statearr_74325;
})();
var inst_74298 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_74319__$1 = state_74319;
if(cljs.core.truth_(inst_74298)){
var statearr_74326_74343 = state_74319__$1;
(statearr_74326_74343[(1)] = (6));

} else {
var statearr_74327_74344 = state_74319__$1;
(statearr_74327_74344[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74320 === (9))){
var inst_74302 = (state_74319[(2)]);
var inst_74303 = fluree.db.util.async.throw_err(inst_74302);
var inst_74304 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74305 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74306 = ["?auth_id","?ctx",inst_74303];
var inst_74307 = cljs.core.PersistentHashMap.fromArrays(inst_74305,inst_74306);
var inst_74308 = [inst_74307,(10)];
var inst_74309 = (new cljs.core.PersistentVector(null,2,(5),inst_74304,inst_74308,null));
var inst_74310 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74309);
var state_74319__$1 = (function (){var statearr_74328 = state_74319;
(statearr_74328[(7)] = inst_74310);

return statearr_74328;
})();
var statearr_74329_74345 = state_74319__$1;
(statearr_74329_74345[(2)] = inst_74303);

(statearr_74329_74345[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74320 === (5))){
var _ = (function (){var statearr_74330 = state_74319;
(statearr_74330[(4)] = cljs.core.rest((state_74319[(4)])));

return statearr_74330;
})();
var state_74319__$1 = state_74319;
var ex74324 = (state_74319__$1[(2)]);
var statearr_74331_74346 = state_74319__$1;
(statearr_74331_74346[(5)] = ex74324);


if((ex74324 instanceof Error)){
var statearr_74332_74347 = state_74319__$1;
(statearr_74332_74347[(1)] = (4));

(statearr_74332_74347[(5)] = null);

} else {
throw ex74324;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74320 === (8))){
var inst_74314 = (state_74319[(2)]);
var _ = (function (){var statearr_74333 = state_74319;
(statearr_74333[(4)] = cljs.core.rest((state_74319[(4)])));

return statearr_74333;
})();
var state_74319__$1 = state_74319;
var statearr_74334_74348 = state_74319__$1;
(statearr_74334_74348[(2)] = inst_74314);

(statearr_74334_74348[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__15091__auto____0 = (function (){
var statearr_74335 = [null,null,null,null,null,null,null,null];
(statearr_74335[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__15091__auto__);

(statearr_74335[(1)] = (1));

return statearr_74335;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__15091__auto____1 = (function (state_74319){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_74319);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e74336){var ex__15094__auto__ = e74336;
var statearr_74337_74349 = state_74319;
(statearr_74337_74349[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_74319[(4)]))){
var statearr_74338_74350 = state_74319;
(statearr_74338_74350[(1)] = cljs.core.first((state_74319[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__74351 = state_74319;
state_74319 = G__74351;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__15091__auto__ = function(state_74319){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__15091__auto____1.call(this,state_74319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_74339 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_74339[(6)] = c__15165__auto__);

return statearr_74339;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objT",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objF",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"flakes",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__74353 = arguments.length;
switch (G__74353) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_74395){
var state_val_74396 = (state_74395[(1)]);
if((state_val_74396 === (7))){
var state_74395__$1 = state_74395;
var statearr_74397_74427 = state_74395__$1;
(statearr_74397_74427[(2)] = seed);

(statearr_74397_74427[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74396 === (1))){
var state_74395__$1 = state_74395;
var statearr_74398_74428 = state_74395__$1;
(statearr_74398_74428[(2)] = null);

(statearr_74398_74428[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74396 === (4))){
var inst_74354 = (state_74395[(2)]);
var state_74395__$1 = state_74395;
var statearr_74399_74429 = state_74395__$1;
(statearr_74399_74429[(2)] = inst_74354);

(statearr_74399_74429[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74396 === (15))){
var state_74395__$1 = state_74395;
var statearr_74400_74430 = state_74395__$1;
(statearr_74400_74430[(2)] = (10));

(statearr_74400_74430[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74396 === (13))){
var inst_74371 = (state_74395[(2)]);
var inst_74372 = fluree.db.util.async.throw_err(inst_74371);
var state_74395__$1 = state_74395;
var statearr_74401_74431 = state_74395__$1;
(statearr_74401_74431[(2)] = inst_74372);

(statearr_74401_74431[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74396 === (6))){
var state_74395__$1 = state_74395;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74395__$1,(9),seed);
} else {
if((state_val_74396 === (3))){
var inst_74393 = (state_74395[(2)]);
var state_74395__$1 = state_74395;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74395__$1,inst_74393);
} else {
if((state_val_74396 === (12))){
var inst_74375 = (state_74395[(7)]);
var inst_74375__$1 = (state_74395[(2)]);
var state_74395__$1 = (function (){var statearr_74402 = state_74395;
(statearr_74402[(7)] = inst_74375__$1);

return statearr_74402;
})();
if(cljs.core.truth_(inst_74375__$1)){
var statearr_74403_74432 = state_74395__$1;
(statearr_74403_74432[(1)] = (14));

} else {
var statearr_74404_74433 = state_74395__$1;
(statearr_74404_74433[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74396 === (2))){
var _ = (function (){var statearr_74405 = state_74395;
(statearr_74405[(4)] = cljs.core.cons((5),(state_74395[(4)])));

return statearr_74405;
})();
var inst_74360 = fluree.db.util.async.channel_QMARK_(seed);
var state_74395__$1 = state_74395;
if(inst_74360){
var statearr_74406_74434 = state_74395__$1;
(statearr_74406_74434[(1)] = (6));

} else {
var statearr_74407_74435 = state_74395__$1;
(statearr_74407_74435[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74396 === (11))){
var state_74395__$1 = state_74395;
var statearr_74409_74436 = state_74395__$1;
(statearr_74409_74436[(2)] = max);

(statearr_74409_74436[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74396 === (9))){
var inst_74363 = (state_74395[(2)]);
var inst_74364 = fluree.db.util.async.throw_err(inst_74363);
var state_74395__$1 = state_74395;
var statearr_74410_74437 = state_74395__$1;
(statearr_74410_74437[(2)] = inst_74364);

(statearr_74410_74437[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74396 === (5))){
var _ = (function (){var statearr_74411 = state_74395;
(statearr_74411[(4)] = cljs.core.rest((state_74395[(4)])));

return statearr_74411;
})();
var state_74395__$1 = state_74395;
var ex74408 = (state_74395__$1[(2)]);
var statearr_74412_74438 = state_74395__$1;
(statearr_74412_74438[(5)] = ex74408);


if((ex74408 instanceof Error)){
var statearr_74413_74439 = state_74395__$1;
(statearr_74413_74439[(1)] = (4));

(statearr_74413_74439[(5)] = null);

} else {
throw ex74408;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74396 === (14))){
var inst_74375 = (state_74395[(7)]);
var state_74395__$1 = state_74395;
var statearr_74414_74440 = state_74395__$1;
(statearr_74414_74440[(2)] = inst_74375);

(statearr_74414_74440[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74396 === (16))){
var inst_74367 = (state_74395[(8)]);
var inst_74379 = (state_74395[(2)]);
var inst_74380 = fluree.db.dbfunctions.internal.rand(inst_74367,inst_74379);
var inst_74381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74382 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74383 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74384 = [max,seed];
var inst_74385 = (new cljs.core.PersistentVector(null,2,(5),inst_74383,inst_74384,null));
var inst_74386 = ["rand",inst_74385,inst_74380];
var inst_74387 = cljs.core.PersistentHashMap.fromArrays(inst_74382,inst_74386);
var inst_74388 = [inst_74387,(10)];
var inst_74389 = (new cljs.core.PersistentVector(null,2,(5),inst_74381,inst_74388,null));
var inst_74390 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74389);
var _ = (function (){var statearr_74415 = state_74395;
(statearr_74415[(4)] = cljs.core.rest((state_74395[(4)])));

return statearr_74415;
})();
var state_74395__$1 = (function (){var statearr_74416 = state_74395;
(statearr_74416[(9)] = inst_74390);

return statearr_74416;
})();
var statearr_74417_74441 = state_74395__$1;
(statearr_74417_74441[(2)] = inst_74380);

(statearr_74417_74441[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74396 === (10))){
var state_74395__$1 = state_74395;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74395__$1,(13),max);
} else {
if((state_val_74396 === (8))){
var inst_74367 = (state_74395[(2)]);
var inst_74368 = fluree.db.util.async.channel_QMARK_(max);
var state_74395__$1 = (function (){var statearr_74418 = state_74395;
(statearr_74418[(8)] = inst_74367);

return statearr_74418;
})();
if(inst_74368){
var statearr_74419_74442 = state_74395__$1;
(statearr_74419_74442[(1)] = (10));

} else {
var statearr_74420_74443 = state_74395__$1;
(statearr_74420_74443[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__15091__auto____0 = (function (){
var statearr_74421 = [null,null,null,null,null,null,null,null,null,null];
(statearr_74421[(0)] = fluree$db$dbfunctions$fns$state_machine__15091__auto__);

(statearr_74421[(1)] = (1));

return statearr_74421;
});
var fluree$db$dbfunctions$fns$state_machine__15091__auto____1 = (function (state_74395){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_74395);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e74422){var ex__15094__auto__ = e74422;
var statearr_74423_74444 = state_74395;
(statearr_74423_74444[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_74395[(4)]))){
var statearr_74424_74445 = state_74395;
(statearr_74424_74445[(1)] = cljs.core.first((state_74395[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__74446 = state_74395;
state_74395 = G__74446;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__15091__auto__ = function(state_74395){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__15091__auto____1.call(this,state_74395);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_74425 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_74425[(6)] = c__15165__auto__);

return statearr_74425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_74467){
var state_val_74468 = (state_74467[(1)]);
if((state_val_74468 === (1))){
var state_74467__$1 = state_74467;
var statearr_74469_74484 = state_74467__$1;
(statearr_74469_74484[(2)] = null);

(statearr_74469_74484[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74468 === (2))){
var _ = (function (){var statearr_74470 = state_74467;
(statearr_74470[(4)] = cljs.core.cons((5),(state_74467[(4)])));

return statearr_74470;
})();
var inst_74453 = fluree.db.util.core.random_uuid();
var inst_74454 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74453);
var inst_74455 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74456 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74457 = cljs.core.PersistentVector.EMPTY;
var inst_74458 = ["uuid",inst_74457,inst_74454];
var inst_74459 = cljs.core.PersistentHashMap.fromArrays(inst_74456,inst_74458);
var inst_74460 = [inst_74459,(10)];
var inst_74461 = (new cljs.core.PersistentVector(null,2,(5),inst_74455,inst_74460,null));
var inst_74462 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74461);
var ___$1 = (function (){var statearr_74471 = state_74467;
(statearr_74471[(4)] = cljs.core.rest((state_74467[(4)])));

return statearr_74471;
})();
var state_74467__$1 = (function (){var statearr_74472 = state_74467;
(statearr_74472[(7)] = inst_74462);

return statearr_74472;
})();
var statearr_74473_74485 = state_74467__$1;
(statearr_74473_74485[(2)] = inst_74454);

(statearr_74473_74485[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74468 === (3))){
var inst_74465 = (state_74467[(2)]);
var state_74467__$1 = state_74467;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74467__$1,inst_74465);
} else {
if((state_val_74468 === (4))){
var inst_74447 = (state_74467[(2)]);
var state_74467__$1 = state_74467;
var statearr_74475_74486 = state_74467__$1;
(statearr_74475_74486[(2)] = inst_74447);

(statearr_74475_74486[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74468 === (5))){
var _ = (function (){var statearr_74476 = state_74467;
(statearr_74476[(4)] = cljs.core.rest((state_74467[(4)])));

return statearr_74476;
})();
var state_74467__$1 = state_74467;
var ex74474 = (state_74467__$1[(2)]);
var statearr_74477_74487 = state_74467__$1;
(statearr_74477_74487[(5)] = ex74474);


if((ex74474 instanceof Error)){
var statearr_74478_74488 = state_74467__$1;
(statearr_74478_74488[(1)] = (4));

(statearr_74478_74488[(5)] = null);

} else {
throw ex74474;

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__15091__auto____0 = (function (){
var statearr_74479 = [null,null,null,null,null,null,null,null];
(statearr_74479[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__15091__auto__);

(statearr_74479[(1)] = (1));

return statearr_74479;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__15091__auto____1 = (function (state_74467){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_74467);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e74480){var ex__15094__auto__ = e74480;
var statearr_74481_74489 = state_74467;
(statearr_74481_74489[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_74467[(4)]))){
var statearr_74482_74490 = state_74467;
(statearr_74482_74490[(1)] = cljs.core.first((state_74467[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__74491 = state_74467;
state_74467 = G__74491;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__15091__auto__ = function(state_74467){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__15091__auto____1.call(this,state_74467);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_74483 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_74483[(6)] = c__15165__auto__);

return statearr_74483;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_74521){
var state_val_74522 = (state_74521[(1)]);
if((state_val_74522 === (7))){
var state_74521__$1 = state_74521;
var statearr_74523_74542 = state_74521__$1;
(statearr_74523_74542[(2)] = num);

(statearr_74523_74542[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74522 === (1))){
var state_74521__$1 = state_74521;
var statearr_74524_74543 = state_74521__$1;
(statearr_74524_74543[(2)] = null);

(statearr_74524_74543[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74522 === (4))){
var inst_74492 = (state_74521[(2)]);
var state_74521__$1 = state_74521;
var statearr_74525_74544 = state_74521__$1;
(statearr_74525_74544[(2)] = inst_74492);

(statearr_74525_74544[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74522 === (6))){
var state_74521__$1 = state_74521;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74521__$1,(9),num);
} else {
if((state_val_74522 === (3))){
var inst_74519 = (state_74521[(2)]);
var state_74521__$1 = state_74521;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74521__$1,inst_74519);
} else {
if((state_val_74522 === (2))){
var _ = (function (){var statearr_74527 = state_74521;
(statearr_74527[(4)] = cljs.core.cons((5),(state_74521[(4)])));

return statearr_74527;
})();
var inst_74498 = fluree.db.util.async.channel_QMARK_(num);
var state_74521__$1 = state_74521;
if(inst_74498){
var statearr_74528_74545 = state_74521__$1;
(statearr_74528_74545[(1)] = (6));

} else {
var statearr_74529_74546 = state_74521__$1;
(statearr_74529_74546[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74522 === (9))){
var inst_74501 = (state_74521[(2)]);
var inst_74502 = fluree.db.util.async.throw_err(inst_74501);
var state_74521__$1 = state_74521;
var statearr_74530_74547 = state_74521__$1;
(statearr_74530_74547[(2)] = inst_74502);

(statearr_74530_74547[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74522 === (5))){
var _ = (function (){var statearr_74531 = state_74521;
(statearr_74531[(4)] = cljs.core.rest((state_74521[(4)])));

return statearr_74531;
})();
var state_74521__$1 = state_74521;
var ex74526 = (state_74521__$1[(2)]);
var statearr_74532_74548 = state_74521__$1;
(statearr_74532_74548[(5)] = ex74526);


if((ex74526 instanceof Error)){
var statearr_74533_74549 = state_74521__$1;
(statearr_74533_74549[(1)] = (4));

(statearr_74533_74549[(5)] = null);

} else {
throw ex74526;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74522 === (8))){
var inst_74505 = (state_74521[(2)]);
var inst_74506 = fluree.db.dbfunctions.internal.ceil(inst_74505);
var inst_74507 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74508 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74510 = [fluree.db.dbfunctions.fns.ceil];
var inst_74511 = (new cljs.core.PersistentVector(null,1,(5),inst_74509,inst_74510,null));
var inst_74512 = ["",inst_74511,inst_74506];
var inst_74513 = cljs.core.PersistentHashMap.fromArrays(inst_74508,inst_74512);
var inst_74514 = [inst_74513,(10)];
var inst_74515 = (new cljs.core.PersistentVector(null,2,(5),inst_74507,inst_74514,null));
var inst_74516 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74515);
var _ = (function (){var statearr_74534 = state_74521;
(statearr_74534[(4)] = cljs.core.rest((state_74521[(4)])));

return statearr_74534;
})();
var state_74521__$1 = (function (){var statearr_74535 = state_74521;
(statearr_74535[(7)] = inst_74516);

return statearr_74535;
})();
var statearr_74536_74550 = state_74521__$1;
(statearr_74536_74550[(2)] = inst_74506);

(statearr_74536_74550[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__15091__auto____0 = (function (){
var statearr_74537 = [null,null,null,null,null,null,null,null];
(statearr_74537[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__15091__auto__);

(statearr_74537[(1)] = (1));

return statearr_74537;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__15091__auto____1 = (function (state_74521){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_74521);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e74538){var ex__15094__auto__ = e74538;
var statearr_74539_74551 = state_74521;
(statearr_74539_74551[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_74521[(4)]))){
var statearr_74540_74552 = state_74521;
(statearr_74540_74552[(1)] = cljs.core.first((state_74521[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__74553 = state_74521;
state_74521 = G__74553;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__15091__auto__ = function(state_74521){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__15091__auto____1.call(this,state_74521);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_74541 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_74541[(6)] = c__15165__auto__);

return statearr_74541;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_74583){
var state_val_74584 = (state_74583[(1)]);
if((state_val_74584 === (7))){
var state_74583__$1 = state_74583;
var statearr_74585_74604 = state_74583__$1;
(statearr_74585_74604[(2)] = num);

(statearr_74585_74604[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74584 === (1))){
var state_74583__$1 = state_74583;
var statearr_74586_74605 = state_74583__$1;
(statearr_74586_74605[(2)] = null);

(statearr_74586_74605[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74584 === (4))){
var inst_74554 = (state_74583[(2)]);
var state_74583__$1 = state_74583;
var statearr_74587_74606 = state_74583__$1;
(statearr_74587_74606[(2)] = inst_74554);

(statearr_74587_74606[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74584 === (6))){
var state_74583__$1 = state_74583;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74583__$1,(9),num);
} else {
if((state_val_74584 === (3))){
var inst_74581 = (state_74583[(2)]);
var state_74583__$1 = state_74583;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74583__$1,inst_74581);
} else {
if((state_val_74584 === (2))){
var _ = (function (){var statearr_74589 = state_74583;
(statearr_74589[(4)] = cljs.core.cons((5),(state_74583[(4)])));

return statearr_74589;
})();
var inst_74560 = fluree.db.util.async.channel_QMARK_(num);
var state_74583__$1 = state_74583;
if(inst_74560){
var statearr_74590_74607 = state_74583__$1;
(statearr_74590_74607[(1)] = (6));

} else {
var statearr_74591_74608 = state_74583__$1;
(statearr_74591_74608[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74584 === (9))){
var inst_74563 = (state_74583[(2)]);
var inst_74564 = fluree.db.util.async.throw_err(inst_74563);
var state_74583__$1 = state_74583;
var statearr_74592_74609 = state_74583__$1;
(statearr_74592_74609[(2)] = inst_74564);

(statearr_74592_74609[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74584 === (5))){
var _ = (function (){var statearr_74593 = state_74583;
(statearr_74593[(4)] = cljs.core.rest((state_74583[(4)])));

return statearr_74593;
})();
var state_74583__$1 = state_74583;
var ex74588 = (state_74583__$1[(2)]);
var statearr_74594_74610 = state_74583__$1;
(statearr_74594_74610[(5)] = ex74588);


if((ex74588 instanceof Error)){
var statearr_74595_74611 = state_74583__$1;
(statearr_74595_74611[(1)] = (4));

(statearr_74595_74611[(5)] = null);

} else {
throw ex74588;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74584 === (8))){
var inst_74567 = (state_74583[(2)]);
var inst_74568 = fluree.db.dbfunctions.internal.floor(inst_74567);
var inst_74569 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74570 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74571 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74572 = [fluree.db.dbfunctions.fns.floor];
var inst_74573 = (new cljs.core.PersistentVector(null,1,(5),inst_74571,inst_74572,null));
var inst_74574 = ["",inst_74573,inst_74568];
var inst_74575 = cljs.core.PersistentHashMap.fromArrays(inst_74570,inst_74574);
var inst_74576 = [inst_74575,(10)];
var inst_74577 = (new cljs.core.PersistentVector(null,2,(5),inst_74569,inst_74576,null));
var inst_74578 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74577);
var _ = (function (){var statearr_74596 = state_74583;
(statearr_74596[(4)] = cljs.core.rest((state_74583[(4)])));

return statearr_74596;
})();
var state_74583__$1 = (function (){var statearr_74597 = state_74583;
(statearr_74597[(7)] = inst_74578);

return statearr_74597;
})();
var statearr_74598_74612 = state_74583__$1;
(statearr_74598_74612[(2)] = inst_74568);

(statearr_74598_74612[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__15091__auto____0 = (function (){
var statearr_74599 = [null,null,null,null,null,null,null,null];
(statearr_74599[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__15091__auto__);

(statearr_74599[(1)] = (1));

return statearr_74599;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__15091__auto____1 = (function (state_74583){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_74583);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e74600){var ex__15094__auto__ = e74600;
var statearr_74601_74613 = state_74583;
(statearr_74601_74613[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_74583[(4)]))){
var statearr_74602_74614 = state_74583;
(statearr_74602_74614[(1)] = cljs.core.first((state_74583[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__74615 = state_74583;
state_74583 = G__74615;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__15091__auto__ = function(state_74583){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__15091__auto____1.call(this,state_74583);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_74603 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_74603[(6)] = c__15165__auto__);

return statearr_74603;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_74640){
var state_val_74641 = (state_74640[(1)]);
if((state_val_74641 === (1))){
var state_74640__$1 = state_74640;
var statearr_74642_74657 = state_74640__$1;
(statearr_74642_74657[(2)] = null);

(statearr_74642_74657[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74641 === (2))){
var _ = (function (){var statearr_74643 = state_74640;
(statearr_74643[(4)] = cljs.core.cons((5),(state_74640[(4)])));

return statearr_74643;
})();
var inst_74622 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_74640__$1 = state_74640;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74640__$1,(6),inst_74622);
} else {
if((state_val_74641 === (3))){
var inst_74638 = (state_74640[(2)]);
var state_74640__$1 = state_74640;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74640__$1,inst_74638);
} else {
if((state_val_74641 === (4))){
var inst_74616 = (state_74640[(2)]);
var state_74640__$1 = state_74640;
var statearr_74645_74658 = state_74640__$1;
(statearr_74645_74658[(2)] = inst_74616);

(statearr_74645_74658[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74641 === (5))){
var _ = (function (){var statearr_74646 = state_74640;
(statearr_74646[(4)] = cljs.core.rest((state_74640[(4)])));

return statearr_74646;
})();
var state_74640__$1 = state_74640;
var ex74644 = (state_74640__$1[(2)]);
var statearr_74647_74659 = state_74640__$1;
(statearr_74647_74659[(5)] = ex74644);


if((ex74644 instanceof Error)){
var statearr_74648_74660 = state_74640__$1;
(statearr_74648_74660[(1)] = (4));

(statearr_74648_74660[(5)] = null);

} else {
throw ex74644;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74641 === (6))){
var inst_74624 = (state_74640[(2)]);
var inst_74625 = fluree.db.util.async.throw_err(inst_74624);
var inst_74626 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74627 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74628 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74629 = [compare_val,new_val];
var inst_74630 = (new cljs.core.PersistentVector(null,2,(5),inst_74628,inst_74629,null));
var inst_74631 = ["",inst_74630,inst_74625];
var inst_74632 = cljs.core.PersistentHashMap.fromArrays(inst_74627,inst_74631);
var inst_74633 = [inst_74632,(10)];
var inst_74634 = (new cljs.core.PersistentVector(null,2,(5),inst_74626,inst_74633,null));
var inst_74635 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74634);
var _ = (function (){var statearr_74649 = state_74640;
(statearr_74649[(4)] = cljs.core.rest((state_74640[(4)])));

return statearr_74649;
})();
var state_74640__$1 = (function (){var statearr_74650 = state_74640;
(statearr_74650[(7)] = inst_74635);

return statearr_74650;
})();
var statearr_74651_74661 = state_74640__$1;
(statearr_74651_74661[(2)] = inst_74625);

(statearr_74651_74661[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__15091__auto____0 = (function (){
var statearr_74652 = [null,null,null,null,null,null,null,null];
(statearr_74652[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__15091__auto__);

(statearr_74652[(1)] = (1));

return statearr_74652;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__15091__auto____1 = (function (state_74640){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_74640);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e74653){var ex__15094__auto__ = e74653;
var statearr_74654_74662 = state_74640;
(statearr_74654_74662[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_74640[(4)]))){
var statearr_74655_74663 = state_74640;
(statearr_74655_74663[(1)] = cljs.core.first((state_74640[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__74664 = state_74640;
state_74640 = G__74664;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__15091__auto__ = function(state_74640){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__15091__auto____1.call(this,state_74640);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_74656 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_74656[(6)] = c__15165__auto__);

return statearr_74656;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
