// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__5774__auto__ = [];
var len__5768__auto___46461 = arguments.length;
var i__5769__auto___46462 = (0);
while(true){
if((i__5769__auto___46462 < len__5768__auto___46461)){
args__5774__auto__.push((arguments[i__5769__auto___46462]));

var G__46463 = (i__5769__auto___46462 + (1));
i__5769__auto___46462 = G__46463;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((2) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq46458){
var G__46459 = cljs.core.first(seq46458);
var seq46458__$1 = cljs.core.next(seq46458);
var G__46460 = cljs.core.first(seq46458__$1);
var seq46458__$2 = cljs.core.next(seq46458__$1);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46459,G__46460,seq46458__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e46464){var e = e46464;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e46465){var e = e46465;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e46466){var e = e46466;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e46467){var e = e46467;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e46468){var e = e46468;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__5774__auto__ = [];
var len__5768__auto___46471 = arguments.length;
var i__5769__auto___46472 = (0);
while(true){
if((i__5769__auto___46472 < len__5768__auto___46471)){
args__5774__auto__.push((arguments[i__5769__auto___46472]));

var G__46473 = (i__5769__auto___46472 + (1));
i__5769__auto___46472 = G__46473;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e46470){var e = e46470;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq46469){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46469));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__5774__auto__ = [];
var len__5768__auto___46476 = arguments.length;
var i__5769__auto___46477 = (0);
while(true){
if((i__5769__auto___46477 < len__5768__auto___46476)){
args__5774__auto__.push((arguments[i__5769__auto___46477]));

var G__46478 = (i__5769__auto___46477 + (1));
i__5769__auto___46477 = G__46478;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e46475){var e = e46475;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq46474){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46474));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e46479){var e = e46479;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__5774__auto__ = [];
var len__5768__auto___46482 = arguments.length;
var i__5769__auto___46483 = (0);
while(true){
if((i__5769__auto___46483 < len__5768__auto___46482)){
args__5774__auto__.push((arguments[i__5769__auto___46483]));

var G__46484 = (i__5769__auto___46483 + (1));
i__5769__auto___46483 = G__46484;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e46481){var e = e46481;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq46480){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46480));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__5774__auto__ = [];
var len__5768__auto___46487 = arguments.length;
var i__5769__auto___46488 = (0);
while(true){
if((i__5769__auto___46488 < len__5768__auto___46487)){
args__5774__auto__.push((arguments[i__5769__auto___46488]));

var G__46489 = (i__5769__auto___46488 + (1));
i__5769__auto___46488 = G__46489;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e46486){var e = e46486;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq46485){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46485));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e46490){var e = e46490;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e46491){var e = e46491;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__5774__auto__ = [];
var len__5768__auto___46494 = arguments.length;
var i__5769__auto___46495 = (0);
while(true){
if((i__5769__auto___46495 < len__5768__auto___46494)){
args__5774__auto__.push((arguments[i__5769__auto___46495]));

var G__46496 = (i__5769__auto___46495 + (1));
i__5769__auto___46495 = G__46496;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e46493){var e = e46493;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq46492){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46492));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__5774__auto__ = [];
var len__5768__auto___46499 = arguments.length;
var i__5769__auto___46500 = (0);
while(true){
if((i__5769__auto___46500 < len__5768__auto___46499)){
args__5774__auto__.push((arguments[i__5769__auto___46500]));

var G__46501 = (i__5769__auto___46500 + (1));
i__5769__auto___46500 = G__46501;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e46498){var e = e46498;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq46497){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46497));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___46504 = arguments.length;
var i__5769__auto___46505 = (0);
while(true){
if((i__5769__auto___46505 < len__5768__auto___46504)){
args__5774__auto__.push((arguments[i__5769__auto___46505]));

var G__46506 = (i__5769__auto___46505 + (1));
i__5769__auto___46505 = G__46506;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e46503){var e = e46503;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq46502){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46502));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___46509 = arguments.length;
var i__5769__auto___46510 = (0);
while(true){
if((i__5769__auto___46510 < len__5768__auto___46509)){
args__5774__auto__.push((arguments[i__5769__auto___46510]));

var G__46511 = (i__5769__auto___46510 + (1));
i__5769__auto___46510 = G__46511;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e46508){var e = e46508;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq46507){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46507));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___46514 = arguments.length;
var i__5769__auto___46515 = (0);
while(true){
if((i__5769__auto___46515 < len__5768__auto___46514)){
args__5774__auto__.push((arguments[i__5769__auto___46515]));

var G__46516 = (i__5769__auto___46515 + (1));
i__5769__auto___46515 = G__46516;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e46513){var e = e46513;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq46512){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46512));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___46519 = arguments.length;
var i__5769__auto___46520 = (0);
while(true){
if((i__5769__auto___46520 < len__5768__auto___46519)){
args__5774__auto__.push((arguments[i__5769__auto___46520]));

var G__46521 = (i__5769__auto___46520 + (1));
i__5769__auto___46520 = G__46521;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e46518){var e = e46518;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq46517){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46517));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___46524 = arguments.length;
var i__5769__auto___46525 = (0);
while(true){
if((i__5769__auto___46525 < len__5768__auto___46524)){
args__5774__auto__.push((arguments[i__5769__auto___46525]));

var G__46526 = (i__5769__auto___46525 + (1));
i__5769__auto___46525 = G__46526;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e46523){var e = e46523;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq46522){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46522));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__46528 = arguments.length;
switch (G__46528) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_46556){
var state_val_46557 = (state_46556[(1)]);
if((state_val_46557 === (7))){
var inst_46541 = (state_46556[(7)]);
var inst_46544 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_46541,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_46556__$1 = state_46556;
var statearr_46558_46644 = state_46556__$1;
(statearr_46558_46644[(2)] = inst_46544);

(statearr_46558_46644[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46557 === (1))){
var state_46556__$1 = state_46556;
var statearr_46559_46645 = state_46556__$1;
(statearr_46559_46645[(2)] = null);

(statearr_46559_46645[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46557 === (4))){
var inst_46529 = (state_46556[(2)]);
var state_46556__$1 = state_46556;
var statearr_46560_46646 = state_46556__$1;
(statearr_46560_46646[(2)] = inst_46529);

(statearr_46560_46646[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46557 === (6))){
var inst_46541 = (state_46556[(7)]);
var inst_46541__$1 = (state_46556[(2)]);
var inst_46542 = fluree.db.util.core.exception_QMARK_(inst_46541__$1);
var state_46556__$1 = (function (){var statearr_46561 = state_46556;
(statearr_46561[(7)] = inst_46541__$1);

return statearr_46561;
})();
if(inst_46542){
var statearr_46562_46647 = state_46556__$1;
(statearr_46562_46647[(1)] = (7));

} else {
var statearr_46563_46648 = state_46556__$1;
(statearr_46563_46648[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46557 === (3))){
var inst_46554 = (state_46556[(2)]);
var state_46556__$1 = state_46556;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46556__$1,inst_46554);
} else {
if((state_val_46557 === (2))){
var inst_46535 = (state_46556[(8)]);
var _ = (function (){var statearr_46565 = state_46556;
(statearr_46565[(4)] = cljs.core.cons((5),(state_46556[(4)])));

return statearr_46565;
})();
var inst_46535__$1 = cljs.core.volatile_BANG_((0));
var inst_46536 = cljs.core.cst$kw$opts.cljs$core$IFn$_invoke$arity$1(query_map);
var inst_46537 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_46536,cljs.core.cst$kw$fuel,inst_46535__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$max_DASH_fuel,(100000)], 0));
var inst_46538 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,cljs.core.cst$kw$opts,inst_46537);
var inst_46539 = fluree.db.query.fql.query(db,inst_46538);
var state_46556__$1 = (function (){var statearr_46566 = state_46556;
(statearr_46566[(8)] = inst_46535__$1);

return statearr_46566;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46556__$1,(6),inst_46539);
} else {
if((state_val_46557 === (9))){
var inst_46551 = (state_46556[(2)]);
var _ = (function (){var statearr_46567 = state_46556;
(statearr_46567[(4)] = cljs.core.rest((state_46556[(4)])));

return statearr_46567;
})();
var state_46556__$1 = state_46556;
var statearr_46568_46649 = state_46556__$1;
(statearr_46568_46649[(2)] = inst_46551);

(statearr_46568_46649[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46557 === (5))){
var _ = (function (){var statearr_46569 = state_46556;
(statearr_46569[(4)] = cljs.core.rest((state_46556[(4)])));

return statearr_46569;
})();
var state_46556__$1 = state_46556;
var ex46564 = (state_46556__$1[(2)]);
var statearr_46570_46650 = state_46556__$1;
(statearr_46570_46650[(5)] = ex46564);


if((ex46564 instanceof Error)){
var statearr_46571_46651 = state_46556__$1;
(statearr_46571_46651[(1)] = (4));

(statearr_46571_46651[(5)] = null);

} else {
throw ex46564;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46557 === (8))){
var inst_46541 = (state_46556[(7)]);
var inst_46535 = (state_46556[(8)]);
var inst_46546 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46547 = cljs.core.deref(inst_46535);
var inst_46548 = [inst_46541,inst_46547];
var inst_46549 = (new cljs.core.PersistentVector(null,2,(5),inst_46546,inst_46548,null));
var state_46556__$1 = state_46556;
var statearr_46572_46652 = state_46556__$1;
(statearr_46572_46652[(2)] = inst_46549);

(statearr_46572_46652[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__15091__auto____0 = (function (){
var statearr_46573 = [null,null,null,null,null,null,null,null,null];
(statearr_46573[(0)] = fluree$db$dbfunctions$internal$state_machine__15091__auto__);

(statearr_46573[(1)] = (1));

return statearr_46573;
});
var fluree$db$dbfunctions$internal$state_machine__15091__auto____1 = (function (state_46556){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_46556);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e46574){var ex__15094__auto__ = e46574;
var statearr_46575_46653 = state_46556;
(statearr_46575_46653[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_46556[(4)]))){
var statearr_46576_46654 = state_46556;
(statearr_46576_46654[(1)] = cljs.core.first((state_46556[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__46655 = state_46556;
state_46556 = G__46655;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__15091__auto__ = function(state_46556){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__15091__auto____1.call(this,state_46556);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__15091__auto____0;
fluree$db$dbfunctions$internal$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__15091__auto____1;
return fluree$db$dbfunctions$internal$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_46577 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_46577[(6)] = c__15165__auto__);

return statearr_46577;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_46622){
var state_val_46623 = (state_46622[(1)]);
if((state_val_46623 === (7))){
var inst_46608 = (state_46622[(2)]);
var inst_46609 = fluree.db.query.fql.query(db,inst_46608);
var state_46622__$1 = state_46622;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46622__$1,(8),inst_46609);
} else {
if((state_val_46623 === (1))){
var inst_46578 = typeof select === 'string';
var state_46622__$1 = state_46622;
if(cljs.core.truth_(inst_46578)){
var statearr_46624_46656 = state_46622__$1;
(statearr_46624_46656[(1)] = (2));

} else {
var statearr_46625_46657 = state_46622__$1;
(statearr_46625_46657[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46623 === (4))){
var inst_46591 = (state_46622[(7)]);
var inst_46584 = (state_46622[(8)]);
var inst_46583 = (state_46622[(2)]);
var inst_46584__$1 = cljs.core.volatile_BANG_((0));
var inst_46585 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$where,cljs.core.cst$kw$block,cljs.core.cst$kw$limit,cljs.core.cst$kw$opts];
var inst_46586 = [cljs.core.cst$kw$fuel,cljs.core.cst$kw$max_DASH_fuel];
var inst_46587 = [inst_46584__$1,(100000)];
var inst_46588 = cljs.core.PersistentHashMap.fromArrays(inst_46586,inst_46587);
var inst_46589 = [inst_46583,from,where,block,limit,inst_46588];
var inst_46590 = cljs.core.PersistentHashMap.fromArrays(inst_46585,inst_46589);
var inst_46591__$1 = fluree.db.util.core.without_nils(inst_46590);
var inst_46592 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_46591__$1);
var inst_46593 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_46591__$1);
var inst_46594 = cljs.core.first(inst_46593);
var inst_46595 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_46594], 0));
var inst_46596 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_46595);
var inst_46597 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_46591__$1);
var inst_46598 = cljs.core.last(inst_46597);
var inst_46599 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_46598], 0));
var inst_46600 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_46599);
var inst_46601 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_46592,inst_46596,inst_46600], 0));
var state_46622__$1 = (function (){var statearr_46626 = state_46622;
(statearr_46626[(7)] = inst_46591__$1);

(statearr_46626[(8)] = inst_46584__$1);

return statearr_46626;
})();
if(cljs.core.truth_(inst_46601)){
var statearr_46627_46658 = state_46622__$1;
(statearr_46627_46658[(1)] = (5));

} else {
var statearr_46628_46659 = state_46622__$1;
(statearr_46628_46659[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46623 === (6))){
var inst_46591 = (state_46622[(7)]);
var state_46622__$1 = state_46622;
var statearr_46629_46660 = state_46622__$1;
(statearr_46629_46660[(2)] = inst_46591);

(statearr_46629_46660[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46623 === (3))){
var state_46622__$1 = state_46622;
var statearr_46630_46661 = state_46622__$1;
(statearr_46630_46661[(2)] = select);

(statearr_46630_46661[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46623 === (2))){
var inst_46580 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_46622__$1 = state_46622;
var statearr_46631_46662 = state_46622__$1;
(statearr_46631_46662[(2)] = inst_46580);

(statearr_46631_46662[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46623 === (11))){
var inst_46620 = (state_46622[(2)]);
var state_46622__$1 = state_46622;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46622__$1,inst_46620);
} else {
if((state_val_46623 === (9))){
var inst_46611 = (state_46622[(9)]);
var state_46622__$1 = state_46622;
var statearr_46632_46663 = state_46622__$1;
(statearr_46632_46663[(2)] = inst_46611);

(statearr_46632_46663[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46623 === (5))){
var inst_46591 = (state_46622[(7)]);
var inst_46603 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_46591);
var inst_46604 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_46603);
var inst_46605 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_46591,cljs.core.cst$kw$where,inst_46604);
var state_46622__$1 = state_46622;
var statearr_46633_46664 = state_46622__$1;
(statearr_46633_46664[(2)] = inst_46605);

(statearr_46633_46664[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46623 === (10))){
var inst_46584 = (state_46622[(8)]);
var inst_46611 = (state_46622[(9)]);
var inst_46615 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46616 = cljs.core.deref(inst_46584);
var inst_46617 = [inst_46611,inst_46616];
var inst_46618 = (new cljs.core.PersistentVector(null,2,(5),inst_46615,inst_46617,null));
var state_46622__$1 = state_46622;
var statearr_46634_46665 = state_46622__$1;
(statearr_46634_46665[(2)] = inst_46618);

(statearr_46634_46665[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46623 === (8))){
var inst_46611 = (state_46622[(9)]);
var inst_46611__$1 = (state_46622[(2)]);
var inst_46612 = fluree.db.util.core.exception_QMARK_(inst_46611__$1);
var state_46622__$1 = (function (){var statearr_46635 = state_46622;
(statearr_46635[(9)] = inst_46611__$1);

return statearr_46635;
})();
if(inst_46612){
var statearr_46636_46666 = state_46622__$1;
(statearr_46636_46666[(1)] = (9));

} else {
var statearr_46637_46667 = state_46622__$1;
(statearr_46637_46667[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__15091__auto____0 = (function (){
var statearr_46638 = [null,null,null,null,null,null,null,null,null,null];
(statearr_46638[(0)] = fluree$db$dbfunctions$internal$state_machine__15091__auto__);

(statearr_46638[(1)] = (1));

return statearr_46638;
});
var fluree$db$dbfunctions$internal$state_machine__15091__auto____1 = (function (state_46622){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_46622);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e46639){var ex__15094__auto__ = e46639;
var statearr_46640_46668 = state_46622;
(statearr_46640_46668[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_46622[(4)]))){
var statearr_46641_46669 = state_46622;
(statearr_46641_46669[(1)] = cljs.core.first((state_46622[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__46670 = state_46622;
state_46622 = G__46670;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__15091__auto__ = function(state_46622){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__15091__auto____1.call(this,state_46622);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__15091__auto____0;
fluree$db$dbfunctions$internal$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__15091__auto____1;
return fluree$db$dbfunctions$internal$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_46642 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_46642[(6)] = c__15165__auto__);

return statearr_46642;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__46674 = path;
var vec__46675 = G__46674;
var seq__46676 = cljs.core.seq(vec__46675);
var first__46677 = cljs.core.first(seq__46676);
var seq__46676__$1 = cljs.core.next(seq__46676);
var var$ = first__46677;
var r = seq__46676__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__46674__$1 = G__46674;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__46681 = G__46674__$1;
var seq__46682 = cljs.core.seq(vec__46681);
var first__46683 = cljs.core.first(seq__46682);
var seq__46682__$1 = cljs.core.next(seq__46682);
var var$__$1 = first__46683;
var r__$1 = seq__46682__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__46684 = r__$1;
var G__46685 = n__$2;
var G__46686 = next_clauses;
G__46674__$1 = G__46684;
n__$1 = G__46685;
where_clauses__$1 = G__46686;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__46687 = r__$1;
var G__46688 = next_n;
var G__46689 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__46674__$1 = G__46687;
n__$1 = G__46688;
where_clauses__$1 = G__46689;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_46726){
var state_val_46727 = (state_46726[(1)]);
if((state_val_46727 === (7))){
var inst_46699 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46700 = [path];
var inst_46701 = (new cljs.core.PersistentVector(null,1,(5),inst_46699,inst_46700,null));
var state_46726__$1 = state_46726;
var statearr_46728_46756 = state_46726__$1;
(statearr_46728_46756[(2)] = inst_46701);

(statearr_46728_46756[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46727 === (1))){
var state_46726__$1 = state_46726;
var statearr_46729_46757 = state_46726__$1;
(statearr_46729_46757[(2)] = null);

(statearr_46729_46757[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46727 === (4))){
var inst_46690 = (state_46726[(2)]);
var state_46726__$1 = state_46726;
var statearr_46730_46758 = state_46726__$1;
(statearr_46730_46758[(2)] = inst_46690);

(statearr_46730_46758[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46727 === (13))){
var inst_46717 = (state_46726[(2)]);
var inst_46718 = fluree.db.util.async.throw_err(inst_46717);
var _ = (function (){var statearr_46731 = state_46726;
(statearr_46731[(4)] = cljs.core.rest((state_46726[(4)])));

return statearr_46731;
})();
var state_46726__$1 = state_46726;
var statearr_46732_46759 = state_46726__$1;
(statearr_46732_46759[(2)] = inst_46718);

(statearr_46732_46759[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46727 === (6))){
var state_46726__$1 = state_46726;
var statearr_46734_46760 = state_46726__$1;
(statearr_46734_46760[(2)] = path);

(statearr_46734_46760[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46727 === (3))){
var inst_46724 = (state_46726[(2)]);
var state_46726__$1 = state_46726;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46726__$1,inst_46724);
} else {
if((state_val_46727 === (12))){
var _ = (function (){var statearr_46735 = state_46726;
(statearr_46735[(4)] = cljs.core.rest((state_46726[(4)])));

return statearr_46735;
})();
var state_46726__$1 = state_46726;
var ex46733 = (state_46726__$1[(2)]);
var statearr_46736_46761 = state_46726__$1;
(statearr_46736_46761[(5)] = ex46733);


var statearr_46737_46762 = state_46726__$1;
(statearr_46737_46762[(1)] = (11));

(statearr_46737_46762[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_46727 === (2))){
var _ = (function (){var statearr_46738 = state_46726;
(statearr_46738[(4)] = cljs.core.cons((5),(state_46726[(4)])));

return statearr_46738;
})();
var inst_46696 = cljs.core.vector_QMARK_(path);
var state_46726__$1 = state_46726;
if(inst_46696){
var statearr_46739_46763 = state_46726__$1;
(statearr_46739_46763[(1)] = (6));

} else {
var statearr_46740_46764 = state_46726__$1;
(statearr_46740_46764[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46727 === (11))){
var inst_46703 = (state_46726[(7)]);
var inst_46708 = (state_46726[(2)]);
var inst_46709 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_46708,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_46703,endSubject], 0));
var state_46726__$1 = state_46726;
var statearr_46742_46765 = state_46726__$1;
(statearr_46742_46765[(2)] = inst_46709);

(statearr_46742_46765[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46727 === (9))){
var inst_46707 = (state_46726[(8)]);
var _ = (function (){var statearr_46743 = state_46726;
(statearr_46743[(4)] = cljs.core.cons((12),(state_46726[(4)])));

return statearr_46743;
})();
var inst_46715 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_46707);
var state_46726__$1 = state_46726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46726__$1,(13),inst_46715);
} else {
if((state_val_46727 === (5))){
var _ = (function (){var statearr_46744 = state_46726;
(statearr_46744[(4)] = cljs.core.rest((state_46726[(4)])));

return statearr_46744;
})();
var state_46726__$1 = state_46726;
var ex46741 = (state_46726__$1[(2)]);
var statearr_46745_46766 = state_46726__$1;
(statearr_46745_46766[(5)] = ex46741);


if((ex46741 instanceof Error)){
var statearr_46746_46767 = state_46726__$1;
(statearr_46746_46767[(1)] = (4));

(statearr_46746_46767[(5)] = null);

} else {
throw ex46741;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46727 === (10))){
var inst_46721 = (state_46726[(2)]);
var _ = (function (){var statearr_46747 = state_46726;
(statearr_46747[(4)] = cljs.core.rest((state_46726[(4)])));

return statearr_46747;
})();
var state_46726__$1 = state_46726;
var statearr_46748_46768 = state_46726__$1;
(statearr_46748_46768[(2)] = inst_46721);

(statearr_46748_46768[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46727 === (8))){
var inst_46703 = (state_46726[(7)]);
var inst_46703__$1 = (state_46726[(2)]);
var inst_46704 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_46703__$1,endSubject);
var inst_46705 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_46706 = ["?var1",inst_46704];
var inst_46707 = cljs.core.PersistentHashMap.fromArrays(inst_46705,inst_46706);
var state_46726__$1 = (function (){var statearr_46749 = state_46726;
(statearr_46749[(7)] = inst_46703__$1);

(statearr_46749[(8)] = inst_46707);

return statearr_46749;
})();
var statearr_46750_46769 = state_46726__$1;
(statearr_46750_46769[(2)] = null);

(statearr_46750_46769[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__15091__auto____0 = (function (){
var statearr_46751 = [null,null,null,null,null,null,null,null,null];
(statearr_46751[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__15091__auto__);

(statearr_46751[(1)] = (1));

return statearr_46751;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__15091__auto____1 = (function (state_46726){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_46726);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e46752){var ex__15094__auto__ = e46752;
var statearr_46753_46770 = state_46726;
(statearr_46753_46770[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_46726[(4)]))){
var statearr_46754_46771 = state_46726;
(statearr_46754_46771[(1)] = cljs.core.first((state_46726[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__46772 = state_46726;
state_46726 = G__46772;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__15091__auto__ = function(state_46726){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__15091__auto____1.call(this,state_46726);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__15091__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_46755 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_46755[(6)] = c__15165__auto__);

return statearr_46755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e46773){var e = e46773;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e46774){var e = e46774;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e46775){var e = e46775;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e46776){var e = e46776;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___46779 = arguments.length;
var i__5769__auto___46780 = (0);
while(true){
if((i__5769__auto___46780 < len__5768__auto___46779)){
args__5774__auto__.push((arguments[i__5769__auto___46780]));

var G__46781 = (i__5769__auto___46780 + (1));
i__5769__auto___46780 = G__46781;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e46778){var e = e46778;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq46777){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46777));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___46784 = arguments.length;
var i__5769__auto___46785 = (0);
while(true){
if((i__5769__auto___46785 < len__5768__auto___46784)){
args__5774__auto__.push((arguments[i__5769__auto___46785]));

var G__46786 = (i__5769__auto___46785 + (1));
i__5769__auto___46785 = G__46786;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e46783){var e = e46783;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq46782){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46782));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___46789 = arguments.length;
var i__5769__auto___46790 = (0);
while(true){
if((i__5769__auto___46790 < len__5768__auto___46789)){
args__5774__auto__.push((arguments[i__5769__auto___46790]));

var G__46791 = (i__5769__auto___46790 + (1));
i__5769__auto___46790 = G__46791;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__5045__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e46788){var e = e46788;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq46787){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46787));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___46794 = arguments.length;
var i__5769__auto___46795 = (0);
while(true){
if((i__5769__auto___46795 < len__5768__auto___46794)){
args__5774__auto__.push((arguments[i__5769__auto___46795]));

var G__46796 = (i__5769__auto___46795 + (1));
i__5769__auto___46795 = G__46796;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e46793){var e = e46793;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq46792){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46792));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e46797){var e = e46797;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e46798){var e = e46798;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e46799){var e = e46799;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e46800){var e = e46800;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e46801){var e = e46801;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__46807 = path;
var vec__46808 = G__46807;
var seq__46809 = cljs.core.seq(vec__46808);
var first__46810 = cljs.core.first(seq__46809);
var seq__46809__$1 = cljs.core.next(seq__46809);
var pred = first__46810;
var r = seq__46809__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__46807__$1 = G__46807;
var subjects__$1 = subjects;
while(true){
var vec__46814 = G__46807__$1;
var seq__46815 = cljs.core.seq(vec__46814);
var first__46816 = cljs.core.first(seq__46815);
var seq__46815__$1 = cljs.core.next(seq__46815);
var pred__$1 = first__46816;
var r__$1 = seq__46815__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__46807__$1,subjects__$1,vec__46814,seq__46815,first__46816,seq__46815__$1,pred__$1,r__$1,subjects__$2,G__46807,vec__46808,seq__46809,first__46810,seq__46809__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__46807__$1,subjects__$1,vec__46814,seq__46815,first__46816,seq__46815__$1,pred__$1,r__$1,subjects__$2,G__46807,vec__46808,seq__46809,first__46810,seq__46809__$1,pred,r,subjects){
return (function (p1__46802_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__46802_SHARP_,pred__$1);
});})(G__46807__$1,subjects__$1,vec__46814,seq__46815,first__46816,seq__46815__$1,pred__$1,r__$1,subjects__$2,G__46807,vec__46808,seq__46809,first__46810,seq__46809__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__46807__$1,subjects__$1,vec__46814,seq__46815,first__46816,seq__46815__$1,pred__$1,r__$1,subjects__$2,G__46807,vec__46808,seq__46809,first__46810,seq__46809__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__5043__auto__ = r__$1;
if(and__5043__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__5043__auto__;
}
})())){
var G__46817 = r__$1;
var G__46818 = next_subjects;
G__46807__$1 = G__46817;
subjects__$1 = G__46818;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e46803){var e = e46803;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e46819){var e = e46819;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e46820){var e = e46820;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__5774__auto__ = [];
var len__5768__auto___46823 = arguments.length;
var i__5769__auto___46824 = (0);
while(true){
if((i__5769__auto___46824 < len__5768__auto___46823)){
args__5774__auto__.push((arguments[i__5769__auto___46824]));

var G__46825 = (i__5769__auto___46824 + (1));
i__5769__auto___46824 = G__46825;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e46822){var e = e46822;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq46821){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46821));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e46826){var e = e46826;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___46829 = arguments.length;
var i__5769__auto___46830 = (0);
while(true){
if((i__5769__auto___46830 < len__5768__auto___46829)){
args__5774__auto__.push((arguments[i__5769__auto___46830]));

var G__46831 = (i__5769__auto___46830 + (1));
i__5769__auto___46830 = G__46831;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e46828){var e = e46828;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq46827){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46827));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e46832){var e = e46832;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_46889){
var state_val_46890 = (state_46889[(1)]);
if((state_val_46890 === (7))){
var inst_46835 = (state_46889[(2)]);
var state_46889__$1 = state_46889;
var statearr_46891_46925 = state_46889__$1;
(statearr_46891_46925[(2)] = inst_46835);

(statearr_46891_46925[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46890 === (1))){
var state_46889__$1 = state_46889;
var statearr_46892_46926 = state_46889__$1;
(statearr_46892_46926[(2)] = null);

(statearr_46892_46926[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46890 === (4))){
var inst_46834 = (state_46889[(2)]);
var state_46889__$1 = (function (){var statearr_46893 = state_46889;
(statearr_46893[(7)] = inst_46834);

return statearr_46893;
})();
var statearr_46894_46927 = state_46889__$1;
(statearr_46894_46927[(2)] = null);

(statearr_46894_46927[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46890 === (15))){
var inst_46857 = (state_46889[(8)]);
var inst_46869 = (state_46889[(9)]);
var inst_46860 = (state_46889[(10)]);
var inst_46870 = (state_46889[(11)]);
var inst_46859 = (state_46889[(12)]);
var inst_46872 = (state_46889[(13)]);
var inst_46876 = (function (){var db = inst_46857;
var prevT = inst_46859;
var db_SINGLEQUOTE_ = inst_46860;
var prev_vals = inst_46869;
var fuel = inst_46870;
var G__46871 = inst_46872;
return (function (p1__46833_SHARP_){
var f = p1__46833_SHARP_;
return f.o;
});
})();
var inst_46877 = (inst_46876.cljs$core$IFn$_invoke$arity$1 ? inst_46876.cljs$core$IFn$_invoke$arity$1(inst_46872) : inst_46876.call(null,inst_46872));
var state_46889__$1 = state_46889;
var statearr_46895_46928 = state_46889__$1;
(statearr_46895_46928[(2)] = inst_46877);

(statearr_46895_46928[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46890 === (13))){
var inst_46869 = (state_46889[(9)]);
var inst_46872 = (state_46889[(13)]);
var inst_46868 = (state_46889[(2)]);
var inst_46869__$1 = fluree.db.util.async.throw_err(inst_46868);
var inst_46870 = fluree.db.dbfunctions.internal.count(inst_46869__$1);
var inst_46872__$1 = cljs.core.first(inst_46869__$1);
var inst_46873 = (inst_46872__$1 == null);
var state_46889__$1 = (function (){var statearr_46896 = state_46889;
(statearr_46896[(9)] = inst_46869__$1);

(statearr_46896[(11)] = inst_46870);

(statearr_46896[(13)] = inst_46872__$1);

return statearr_46896;
})();
if(cljs.core.truth_(inst_46873)){
var statearr_46897_46929 = state_46889__$1;
(statearr_46897_46929[(1)] = (14));

} else {
var statearr_46898_46930 = state_46889__$1;
(statearr_46898_46930[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46890 === (6))){
var inst_46844 = (state_46889[(2)]);
var state_46889__$1 = state_46889;
var statearr_46899_46931 = state_46889__$1;
(statearr_46899_46931[(2)] = inst_46844);

(statearr_46899_46931[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46890 === (3))){
var inst_46887 = (state_46889[(2)]);
var state_46889__$1 = state_46889;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46889__$1,inst_46887);
} else {
if((state_val_46890 === (12))){
var inst_46884 = (state_46889[(2)]);
var _ = (function (){var statearr_46900 = state_46889;
(statearr_46900[(4)] = cljs.core.rest((state_46889[(4)])));

return statearr_46900;
})();
var state_46889__$1 = state_46889;
var statearr_46901_46932 = state_46889__$1;
(statearr_46901_46932[(2)] = inst_46884);

(statearr_46901_46932[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46890 === (2))){
var _ = (function (){var statearr_46903 = state_46889;
(statearr_46903[(4)] = cljs.core.cons((9),(state_46889[(4)])));

return statearr_46903;
})();
var inst_46850 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_46851 = typeof inst_46850 === 'string';
var state_46889__$1 = state_46889;
if(cljs.core.truth_(inst_46851)){
var statearr_46904_46933 = state_46889__$1;
(statearr_46904_46933[(1)] = (10));

} else {
var statearr_46905_46934 = state_46889__$1;
(statearr_46905_46934[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46890 === (11))){
var inst_46857 = (state_46889[(8)]);
var inst_46860 = (state_46889[(10)]);
var inst_46859 = (state_46889[(12)]);
var inst_46857__$1 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_46858 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_46857__$1);
var inst_46859__$1 = fluree.db.dbfunctions.internal.inc(inst_46858);
var inst_46860__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_46857__$1,cljs.core.cst$kw$t,inst_46859__$1);
var inst_46861 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46862 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_46863 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_46864 = [inst_46862,inst_46863];
var inst_46865 = (new cljs.core.PersistentVector(null,2,(5),inst_46861,inst_46864,null));
var inst_46866 = fluree.db.dbproto._search(inst_46860__$1,inst_46865);
var state_46889__$1 = (function (){var statearr_46906 = state_46889;
(statearr_46906[(8)] = inst_46857__$1);

(statearr_46906[(10)] = inst_46860__$1);

(statearr_46906[(12)] = inst_46859__$1);

return statearr_46906;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46889__$1,(13),inst_46866);
} else {
if((state_val_46890 === (9))){
var _ = (function (){var statearr_46907 = state_46889;
(statearr_46907[(4)] = cljs.core.rest((state_46889[(4)])));

return statearr_46907;
})();
var state_46889__$1 = state_46889;
var ex46902 = (state_46889__$1[(2)]);
var statearr_46908_46935 = state_46889__$1;
(statearr_46908_46935[(5)] = ex46902);


var statearr_46909_46936 = state_46889__$1;
(statearr_46909_46936[(1)] = (4));

(statearr_46909_46936[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_46890 === (5))){
var inst_46834 = (state_46889[(7)]);
var _ = (function (){var statearr_46910 = state_46889;
(statearr_46910[(4)] = cljs.core.cons((8),(state_46889[(4)])));

return statearr_46910;
})();
var inst_46841 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_46834,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_46911 = state_46889;
(statearr_46911[(4)] = cljs.core.rest((state_46889[(4)])));

return statearr_46911;
})();
var state_46889__$1 = state_46889;
var statearr_46912_46937 = state_46889__$1;
(statearr_46912_46937[(2)] = inst_46841);

(statearr_46912_46937[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46890 === (14))){
var state_46889__$1 = state_46889;
var statearr_46913_46938 = state_46889__$1;
(statearr_46913_46938[(2)] = null);

(statearr_46913_46938[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46890 === (16))){
var inst_46870 = (state_46889[(11)]);
var inst_46879 = (state_46889[(2)]);
var inst_46880 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46881 = [inst_46879,inst_46870];
var inst_46882 = (new cljs.core.PersistentVector(null,2,(5),inst_46880,inst_46881,null));
var state_46889__$1 = state_46889;
var statearr_46915_46939 = state_46889__$1;
(statearr_46915_46939[(2)] = inst_46882);

(statearr_46915_46939[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46890 === (10))){
var inst_46853 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46854 = [null,(0)];
var inst_46855 = (new cljs.core.PersistentVector(null,2,(5),inst_46853,inst_46854,null));
var state_46889__$1 = state_46889;
var statearr_46916_46940 = state_46889__$1;
(statearr_46916_46940[(2)] = inst_46855);

(statearr_46916_46940[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46890 === (8))){
var _ = (function (){var statearr_46917 = state_46889;
(statearr_46917[(4)] = cljs.core.rest((state_46889[(4)])));

return statearr_46917;
})();
var state_46889__$1 = state_46889;
var ex46914 = (state_46889__$1[(2)]);
var statearr_46918_46941 = state_46889__$1;
(statearr_46918_46941[(5)] = ex46914);


var statearr_46919_46942 = state_46889__$1;
(statearr_46919_46942[(1)] = (7));

(statearr_46919_46942[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__15091__auto____0 = (function (){
var statearr_46920 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46920[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__15091__auto__);

(statearr_46920[(1)] = (1));

return statearr_46920;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__15091__auto____1 = (function (state_46889){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_46889);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e46921){var ex__15094__auto__ = e46921;
var statearr_46922_46943 = state_46889;
(statearr_46922_46943[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_46889[(4)]))){
var statearr_46923_46944 = state_46889;
(statearr_46923_46944[(1)] = cljs.core.first((state_46889[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__46945 = state_46889;
state_46889 = G__46945;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__15091__auto__ = function(state_46889){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__15091__auto____1.call(this,state_46889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_46924 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_46924[(6)] = c__15165__auto__);

return statearr_46924;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_46997){
var state_val_46998 = (state_46997[(1)]);
if((state_val_46998 === (7))){
var inst_46947 = (state_46997[(2)]);
var state_46997__$1 = state_46997;
var statearr_46999_47028 = state_46997__$1;
(statearr_46999_47028[(2)] = inst_46947);

(statearr_46999_47028[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46998 === (1))){
var state_46997__$1 = state_46997;
var statearr_47000_47029 = state_46997__$1;
(statearr_47000_47029[(2)] = null);

(statearr_47000_47029[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46998 === (4))){
var inst_46946 = (state_46997[(2)]);
var state_46997__$1 = (function (){var statearr_47001 = state_46997;
(statearr_47001[(7)] = inst_46946);

return statearr_47001;
})();
var statearr_47002_47030 = state_46997__$1;
(statearr_47002_47030[(2)] = null);

(statearr_47002_47030[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46998 === (13))){
var inst_46992 = (state_46997[(2)]);
var _ = (function (){var statearr_47003 = state_46997;
(statearr_47003[(4)] = cljs.core.rest((state_46997[(4)])));

return statearr_47003;
})();
var state_46997__$1 = state_46997;
var statearr_47004_47031 = state_46997__$1;
(statearr_47004_47031[(2)] = inst_46992);

(statearr_47004_47031[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46998 === (6))){
var inst_46956 = (state_46997[(2)]);
var state_46997__$1 = state_46997;
var statearr_47005_47032 = state_46997__$1;
(statearr_47005_47032[(2)] = inst_46956);

(statearr_47005_47032[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46998 === (3))){
var inst_46995 = (state_46997[(2)]);
var state_46997__$1 = state_46997;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46997__$1,inst_46995);
} else {
if((state_val_46998 === (12))){
var inst_46979 = (state_46997[(8)]);
var inst_46988 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46989 = [null,inst_46979];
var inst_46990 = (new cljs.core.PersistentVector(null,2,(5),inst_46988,inst_46989,null));
var state_46997__$1 = state_46997;
var statearr_47006_47033 = state_46997__$1;
(statearr_47006_47033[(2)] = inst_46990);

(statearr_47006_47033[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46998 === (2))){
var _ = (function (){var statearr_47008 = state_46997;
(statearr_47008[(4)] = cljs.core.cons((9),(state_46997[(4)])));

return statearr_47008;
})();
var inst_46965 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_46966 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46967 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46968 = [null,pred_name,"?o"];
var inst_46969 = (new cljs.core.PersistentVector(null,3,(5),inst_46967,inst_46968,null));
var inst_46970 = [inst_46969];
var inst_46971 = (new cljs.core.PersistentVector(null,1,(5),inst_46966,inst_46970,null));
var inst_46972 = ["?o",inst_46971,opts];
var inst_46973 = cljs.core.PersistentHashMap.fromArrays(inst_46965,inst_46972);
var inst_46974 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_46973);
var state_46997__$1 = state_46997;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46997__$1,(10),inst_46974);
} else {
if((state_val_46998 === (11))){
var inst_46978 = (state_46997[(9)]);
var inst_46979 = (state_46997[(8)]);
var inst_46983 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46984 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_46978);
var inst_46985 = [inst_46984,inst_46979];
var inst_46986 = (new cljs.core.PersistentVector(null,2,(5),inst_46983,inst_46985,null));
var state_46997__$1 = state_46997;
var statearr_47009_47034 = state_46997__$1;
(statearr_47009_47034[(2)] = inst_46986);

(statearr_47009_47034[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46998 === (9))){
var _ = (function (){var statearr_47010 = state_46997;
(statearr_47010[(4)] = cljs.core.rest((state_46997[(4)])));

return statearr_47010;
})();
var state_46997__$1 = state_46997;
var ex47007 = (state_46997__$1[(2)]);
var statearr_47011_47035 = state_46997__$1;
(statearr_47011_47035[(5)] = ex47007);


var statearr_47012_47036 = state_46997__$1;
(statearr_47012_47036[(1)] = (4));

(statearr_47012_47036[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_46998 === (5))){
var inst_46946 = (state_46997[(7)]);
var _ = (function (){var statearr_47014 = state_46997;
(statearr_47014[(4)] = cljs.core.cons((8),(state_46997[(4)])));

return statearr_47014;
})();
var inst_46953 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_46946,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_47015 = state_46997;
(statearr_47015[(4)] = cljs.core.rest((state_46997[(4)])));

return statearr_47015;
})();
var state_46997__$1 = state_46997;
var statearr_47016_47037 = state_46997__$1;
(statearr_47016_47037[(2)] = inst_46953);

(statearr_47016_47037[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46998 === (10))){
var inst_46978 = (state_46997[(9)]);
var inst_46976 = (state_46997[(2)]);
var inst_46977 = fluree.db.util.async.throw_err(inst_46976);
var inst_46978__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46977,(0),null);
var inst_46979 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46977,(1),null);
var inst_46980 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_46978__$1);
var inst_46981 = cljs.core.not(inst_46980);
var state_46997__$1 = (function (){var statearr_47017 = state_46997;
(statearr_47017[(9)] = inst_46978__$1);

(statearr_47017[(8)] = inst_46979);

return statearr_47017;
})();
if(inst_46981){
var statearr_47018_47038 = state_46997__$1;
(statearr_47018_47038[(1)] = (11));

} else {
var statearr_47019_47039 = state_46997__$1;
(statearr_47019_47039[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46998 === (8))){
var _ = (function (){var statearr_47020 = state_46997;
(statearr_47020[(4)] = cljs.core.rest((state_46997[(4)])));

return statearr_47020;
})();
var state_46997__$1 = state_46997;
var ex47013 = (state_46997__$1[(2)]);
var statearr_47021_47040 = state_46997__$1;
(statearr_47021_47040[(5)] = ex47013);


var statearr_47022_47041 = state_46997__$1;
(statearr_47022_47041[(1)] = (7));

(statearr_47022_47041[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__15091__auto____0 = (function (){
var statearr_47023 = [null,null,null,null,null,null,null,null,null,null];
(statearr_47023[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__15091__auto__);

(statearr_47023[(1)] = (1));

return statearr_47023;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__15091__auto____1 = (function (state_46997){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_46997);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e47024){var ex__15094__auto__ = e47024;
var statearr_47025_47042 = state_46997;
(statearr_47025_47042[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_46997[(4)]))){
var statearr_47026_47043 = state_46997;
(statearr_47026_47043[(1)] = cljs.core.first((state_46997[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__47044 = state_46997;
state_46997 = G__47044;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__15091__auto__ = function(state_46997){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__15091__auto____1.call(this,state_46997);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_47027 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_47027[(6)] = c__15165__auto__);

return statearr_47027;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__5043__auto__ = typeof email === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__5043__auto__;
}
})());
}catch (e47045){var e = e47045;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__47047 = arguments.length;
switch (G__47047) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_47117){
var state_val_47118 = (state_47117[(1)]);
if((state_val_47118 === (7))){
var inst_47049 = (state_47117[(2)]);
var state_47117__$1 = state_47117;
var statearr_47119_47163 = state_47117__$1;
(statearr_47119_47163[(2)] = inst_47049);

(statearr_47119_47163[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47118 === (20))){
var inst_47093 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47094 = ["*"];
var inst_47095 = (new cljs.core.PersistentVector(null,1,(5),inst_47093,inst_47094,null));
var state_47117__$1 = state_47117;
var statearr_47120_47164 = state_47117__$1;
(statearr_47120_47164[(2)] = inst_47095);

(statearr_47120_47164[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47118 === (1))){
var state_47117__$1 = state_47117;
var statearr_47121_47165 = state_47117__$1;
(statearr_47121_47165[(2)] = null);

(statearr_47121_47165[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47118 === (4))){
var inst_47048 = (state_47117[(2)]);
var state_47117__$1 = (function (){var statearr_47122 = state_47117;
(statearr_47122[(7)] = inst_47048);

return statearr_47122;
})();
var statearr_47123_47166 = state_47117__$1;
(statearr_47123_47166[(2)] = null);

(statearr_47123_47166[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47118 === (15))){
var inst_47112 = (state_47117[(2)]);
var _ = (function (){var statearr_47124 = state_47117;
(statearr_47124[(4)] = cljs.core.rest((state_47117[(4)])));

return statearr_47124;
})();
var state_47117__$1 = state_47117;
var statearr_47125_47167 = state_47117__$1;
(statearr_47125_47167[(2)] = inst_47112);

(statearr_47125_47167[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47118 === (21))){
var inst_47083 = (state_47117[(8)]);
var inst_47076 = (state_47117[(9)]);
var inst_47097 = (state_47117[(2)]);
var inst_47098 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_47099 = cljs.core.PersistentHashMap.EMPTY;
var inst_47100 = [inst_47097,inst_47083,inst_47099];
var inst_47101 = cljs.core.PersistentHashMap.fromArrays(inst_47098,inst_47100);
var inst_47102 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_47076,inst_47101);
var state_47117__$1 = state_47117;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47117__$1,(22),inst_47102);
} else {
if((state_val_47118 === (13))){
var inst_47071 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_47117__$1 = state_47117;
var statearr_47126_47168 = state_47117__$1;
(statearr_47126_47168[(2)] = inst_47071);

(statearr_47126_47168[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47118 === (22))){
var inst_47104 = (state_47117[(2)]);
var inst_47105 = fluree.db.util.async.throw_err(inst_47104);
var inst_47106 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47105,(0),null);
var inst_47107 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47105,(1),null);
var inst_47108 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47109 = [inst_47106,inst_47107];
var inst_47110 = (new cljs.core.PersistentVector(null,2,(5),inst_47108,inst_47109,null));
var state_47117__$1 = state_47117;
var statearr_47127_47169 = state_47117__$1;
(statearr_47127_47169[(2)] = inst_47110);

(statearr_47127_47169[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47118 === (6))){
var inst_47058 = (state_47117[(2)]);
var state_47117__$1 = state_47117;
var statearr_47128_47170 = state_47117__$1;
(statearr_47128_47170[(2)] = inst_47058);

(statearr_47128_47170[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47118 === (17))){
var inst_47080 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_47081 = fluree.db.dbfunctions.internal.get(inst_47080,cljs.core.cst$kw$_id);
var state_47117__$1 = state_47117;
var statearr_47129_47171 = state_47117__$1;
(statearr_47129_47171[(2)] = inst_47081);

(statearr_47129_47171[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47118 === (3))){
var inst_47115 = (state_47117[(2)]);
var state_47117__$1 = state_47117;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47117__$1,inst_47115);
} else {
if((state_val_47118 === (12))){
var inst_47069 = (state_47117[(2)]);
var state_47117__$1 = state_47117;
if(cljs.core.truth_(inst_47069)){
var statearr_47130_47172 = state_47117__$1;
(statearr_47130_47172[(1)] = (13));

} else {
var statearr_47131_47173 = state_47117__$1;
(statearr_47131_47173[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47118 === (2))){
var inst_47064 = (state_47117[(10)]);
var _ = (function (){var statearr_47132 = state_47117;
(statearr_47132[(4)] = cljs.core.cons((9),(state_47117[(4)])));

return statearr_47132;
})();
var inst_47064__$1 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_47117__$1 = (function (){var statearr_47133 = state_47117;
(statearr_47133[(10)] = inst_47064__$1);

return statearr_47133;
})();
if(cljs.core.truth_(inst_47064__$1)){
var statearr_47134_47174 = state_47117__$1;
(statearr_47134_47174[(1)] = (10));

} else {
var statearr_47135_47175 = state_47117__$1;
(statearr_47135_47175[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47118 === (19))){
var inst_47085 = cljs.core.PersistentVector.EMPTY;
var inst_47086 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47087 = ["*"];
var inst_47088 = (new cljs.core.PersistentVector(null,1,(5),inst_47086,inst_47087,null));
var inst_47089 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_47090 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_47088,inst_47089);
var inst_47091 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_47085,inst_47090);
var state_47117__$1 = state_47117;
var statearr_47137_47176 = state_47117__$1;
(statearr_47137_47176[(2)] = inst_47091);

(statearr_47137_47176[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47118 === (11))){
var inst_47064 = (state_47117[(10)]);
var state_47117__$1 = state_47117;
var statearr_47138_47177 = state_47117__$1;
(statearr_47138_47177[(2)] = inst_47064);

(statearr_47138_47177[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47118 === (9))){
var _ = (function (){var statearr_47139 = state_47117;
(statearr_47139[(4)] = cljs.core.rest((state_47117[(4)])));

return statearr_47139;
})();
var state_47117__$1 = state_47117;
var ex47136 = (state_47117__$1[(2)]);
var statearr_47140_47178 = state_47117__$1;
(statearr_47140_47178[(5)] = ex47136);


var statearr_47141_47179 = state_47117__$1;
(statearr_47141_47179[(1)] = (4));

(statearr_47141_47179[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_47118 === (5))){
var inst_47048 = (state_47117[(7)]);
var _ = (function (){var statearr_47142 = state_47117;
(statearr_47142[(4)] = cljs.core.cons((8),(state_47117[(4)])));

return statearr_47142;
})();
var inst_47055 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_47048,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_47143 = state_47117;
(statearr_47143[(4)] = cljs.core.rest((state_47117[(4)])));

return statearr_47143;
})();
var state_47117__$1 = state_47117;
var statearr_47144_47180 = state_47117__$1;
(statearr_47144_47180[(2)] = inst_47055);

(statearr_47144_47180[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47118 === (14))){
var inst_47077 = (state_47117[(11)]);
var inst_47076 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_47077__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_47117__$1 = (function (){var statearr_47145 = state_47117;
(statearr_47145[(9)] = inst_47076);

(statearr_47145[(11)] = inst_47077__$1);

return statearr_47145;
})();
if(cljs.core.truth_(inst_47077__$1)){
var statearr_47146_47181 = state_47117__$1;
(statearr_47146_47181[(1)] = (16));

} else {
var statearr_47147_47182 = state_47117__$1;
(statearr_47147_47182[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47118 === (16))){
var inst_47077 = (state_47117[(11)]);
var state_47117__$1 = state_47117;
var statearr_47148_47183 = state_47117__$1;
(statearr_47148_47183[(2)] = inst_47077);

(statearr_47148_47183[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47118 === (10))){
var inst_47066 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_47117__$1 = state_47117;
var statearr_47150_47184 = state_47117__$1;
(statearr_47150_47184[(2)] = inst_47066);

(statearr_47150_47184[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47118 === (18))){
var inst_47083 = (state_47117[(2)]);
var state_47117__$1 = (function (){var statearr_47151 = state_47117;
(statearr_47151[(8)] = inst_47083);

return statearr_47151;
})();
if(cljs.core.truth_(additional_params)){
var statearr_47152_47185 = state_47117__$1;
(statearr_47152_47185[(1)] = (19));

} else {
var statearr_47153_47186 = state_47117__$1;
(statearr_47153_47186[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47118 === (8))){
var _ = (function (){var statearr_47154 = state_47117;
(statearr_47154[(4)] = cljs.core.rest((state_47117[(4)])));

return statearr_47154;
})();
var state_47117__$1 = state_47117;
var ex47149 = (state_47117__$1[(2)]);
var statearr_47155_47187 = state_47117__$1;
(statearr_47155_47187[(5)] = ex47149);


var statearr_47156_47188 = state_47117__$1;
(statearr_47156_47188[(1)] = (7));

(statearr_47156_47188[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__15091__auto____0 = (function (){
var statearr_47157 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47157[(0)] = fluree$db$dbfunctions$internal$state_machine__15091__auto__);

(statearr_47157[(1)] = (1));

return statearr_47157;
});
var fluree$db$dbfunctions$internal$state_machine__15091__auto____1 = (function (state_47117){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_47117);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e47158){var ex__15094__auto__ = e47158;
var statearr_47159_47189 = state_47117;
(statearr_47159_47189[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_47117[(4)]))){
var statearr_47160_47190 = state_47117;
(statearr_47160_47190[(1)] = cljs.core.first((state_47117[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__47191 = state_47117;
state_47117 = G__47191;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__15091__auto__ = function(state_47117){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__15091__auto____1.call(this,state_47117);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__15091__auto____0;
fluree$db$dbfunctions$internal$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__15091__auto____1;
return fluree$db$dbfunctions$internal$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_47161 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_47161[(6)] = c__15165__auto__);

return statearr_47161;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__47193 = arguments.length;
switch (G__47193) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_47237){
var state_val_47238 = (state_47237[(1)]);
if((state_val_47238 === (7))){
var inst_47215 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47216 = ["*"];
var inst_47217 = (new cljs.core.PersistentVector(null,1,(5),inst_47215,inst_47216,null));
var state_47237__$1 = state_47237;
var statearr_47239_47259 = state_47237__$1;
(statearr_47239_47259[(2)] = inst_47217);

(statearr_47239_47259[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47238 === (1))){
var state_47237__$1 = state_47237;
var statearr_47240_47260 = state_47237__$1;
(statearr_47240_47260[(2)] = null);

(statearr_47240_47260[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47238 === (4))){
var inst_47194 = (state_47237[(2)]);
var inst_47195 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_47194,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_47237__$1 = state_47237;
var statearr_47241_47261 = state_47237__$1;
(statearr_47241_47261[(2)] = inst_47195);

(statearr_47241_47261[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47238 === (6))){
var inst_47207 = cljs.core.PersistentVector.EMPTY;
var inst_47208 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47209 = ["*"];
var inst_47210 = (new cljs.core.PersistentVector(null,1,(5),inst_47208,inst_47209,null));
var inst_47211 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_47212 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_47210,inst_47211);
var inst_47213 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_47207,inst_47212);
var state_47237__$1 = state_47237;
var statearr_47242_47262 = state_47237__$1;
(statearr_47242_47262[(2)] = inst_47213);

(statearr_47242_47262[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47238 === (3))){
var inst_47235 = (state_47237[(2)]);
var state_47237__$1 = state_47237;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47237__$1,inst_47235);
} else {
if((state_val_47238 === (2))){
var _ = (function (){var statearr_47244 = state_47237;
(statearr_47244[(4)] = cljs.core.cons((5),(state_47237[(4)])));

return statearr_47244;
})();
var inst_47204 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_47205 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_47237__$1 = (function (){var statearr_47245 = state_47237;
(statearr_47245[(7)] = inst_47205);

(statearr_47245[(8)] = inst_47204);

return statearr_47245;
})();
if(cljs.core.truth_(additional_params)){
var statearr_47246_47263 = state_47237__$1;
(statearr_47246_47263[(1)] = (6));

} else {
var statearr_47247_47264 = state_47237__$1;
(statearr_47247_47264[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47238 === (9))){
var inst_47226 = (state_47237[(2)]);
var inst_47227 = fluree.db.util.async.throw_err(inst_47226);
var inst_47228 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47227,(0),null);
var inst_47229 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47227,(1),null);
var inst_47230 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47231 = [inst_47228,inst_47229];
var inst_47232 = (new cljs.core.PersistentVector(null,2,(5),inst_47230,inst_47231,null));
var _ = (function (){var statearr_47248 = state_47237;
(statearr_47248[(4)] = cljs.core.rest((state_47237[(4)])));

return statearr_47248;
})();
var state_47237__$1 = state_47237;
var statearr_47249_47265 = state_47237__$1;
(statearr_47249_47265[(2)] = inst_47232);

(statearr_47249_47265[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47238 === (5))){
var _ = (function (){var statearr_47250 = state_47237;
(statearr_47250[(4)] = cljs.core.rest((state_47237[(4)])));

return statearr_47250;
})();
var state_47237__$1 = state_47237;
var ex47243 = (state_47237__$1[(2)]);
var statearr_47251_47266 = state_47237__$1;
(statearr_47251_47266[(5)] = ex47243);


var statearr_47252_47267 = state_47237__$1;
(statearr_47252_47267[(1)] = (4));

(statearr_47252_47267[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_47238 === (8))){
var inst_47205 = (state_47237[(7)]);
var inst_47204 = (state_47237[(8)]);
var inst_47219 = (state_47237[(2)]);
var inst_47220 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_47221 = cljs.core.PersistentHashMap.EMPTY;
var inst_47222 = [inst_47219,inst_47205,inst_47221];
var inst_47223 = cljs.core.PersistentHashMap.fromArrays(inst_47220,inst_47222);
var inst_47224 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_47204,inst_47223);
var state_47237__$1 = state_47237;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47237__$1,(9),inst_47224);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__15091__auto____0 = (function (){
var statearr_47253 = [null,null,null,null,null,null,null,null,null];
(statearr_47253[(0)] = fluree$db$dbfunctions$internal$state_machine__15091__auto__);

(statearr_47253[(1)] = (1));

return statearr_47253;
});
var fluree$db$dbfunctions$internal$state_machine__15091__auto____1 = (function (state_47237){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_47237);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e47254){var ex__15094__auto__ = e47254;
var statearr_47255_47268 = state_47237;
(statearr_47255_47268[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_47237[(4)]))){
var statearr_47256_47269 = state_47237;
(statearr_47256_47269[(1)] = cljs.core.first((state_47237[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__47270 = state_47237;
state_47237 = G__47270;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__15091__auto__ = function(state_47237){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__15091__auto____1.call(this,state_47237);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__15091__auto____0;
fluree$db$dbfunctions$internal$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__15091__auto____1;
return fluree$db$dbfunctions$internal$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_47257 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_47257[(6)] = c__15165__auto__);

return statearr_47257;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_47314){
var state_val_47315 = (state_47314[(1)]);
if((state_val_47315 === (1))){
var state_47314__$1 = state_47314;
var statearr_47316_47330 = state_47314__$1;
(statearr_47316_47330[(2)] = null);

(statearr_47316_47330[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47315 === (2))){
var _ = (function (){var statearr_47317 = state_47314;
(statearr_47317[(4)] = cljs.core.cons((5),(state_47314[(4)])));

return statearr_47317;
})();
var inst_47281 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_47282 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47283 = ["_user/_auth"];
var inst_47284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47285 = ["*"];
var inst_47286 = (new cljs.core.PersistentVector(null,1,(5),inst_47284,inst_47285,null));
var inst_47287 = [inst_47286];
var inst_47288 = cljs.core.PersistentHashMap.fromArrays(inst_47283,inst_47287);
var inst_47289 = [inst_47288];
var inst_47290 = (new cljs.core.PersistentVector(null,1,(5),inst_47282,inst_47289,null));
var inst_47291 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_47292 = cljs.core.PersistentHashMap.EMPTY;
var inst_47293 = [inst_47290,inst_47291,inst_47292];
var inst_47294 = cljs.core.PersistentHashMap.fromArrays(inst_47281,inst_47293);
var inst_47295 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_47296 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_47295,inst_47294);
var state_47314__$1 = state_47314;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47314__$1,(6),inst_47296);
} else {
if((state_val_47315 === (3))){
var inst_47312 = (state_47314[(2)]);
var state_47314__$1 = state_47314;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47314__$1,inst_47312);
} else {
if((state_val_47315 === (4))){
var inst_47271 = (state_47314[(2)]);
var inst_47272 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_47271,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_47314__$1 = state_47314;
var statearr_47319_47331 = state_47314__$1;
(statearr_47319_47331[(2)] = inst_47272);

(statearr_47319_47331[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47315 === (5))){
var _ = (function (){var statearr_47320 = state_47314;
(statearr_47320[(4)] = cljs.core.rest((state_47314[(4)])));

return statearr_47320;
})();
var state_47314__$1 = state_47314;
var ex47318 = (state_47314__$1[(2)]);
var statearr_47321_47332 = state_47314__$1;
(statearr_47321_47332[(5)] = ex47318);


var statearr_47322_47333 = state_47314__$1;
(statearr_47322_47333[(1)] = (4));

(statearr_47322_47333[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_47315 === (6))){
var inst_47298 = (state_47314[(2)]);
var inst_47299 = fluree.db.util.async.throw_err(inst_47298);
var inst_47300 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47299,(0),null);
var inst_47301 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47299,(1),null);
var inst_47302 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47303 = ["_user/_auth","_id"];
var inst_47304 = (new cljs.core.PersistentVector(null,2,(5),inst_47302,inst_47303,null));
var inst_47305 = fluree.db.dbfunctions.internal.get_in(inst_47300,inst_47304);
var inst_47306 = cljs.core.first(inst_47305);
var inst_47307 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47308 = [inst_47306,inst_47301];
var inst_47309 = (new cljs.core.PersistentVector(null,2,(5),inst_47307,inst_47308,null));
var _ = (function (){var statearr_47323 = state_47314;
(statearr_47323[(4)] = cljs.core.rest((state_47314[(4)])));

return statearr_47323;
})();
var state_47314__$1 = state_47314;
var statearr_47324_47334 = state_47314__$1;
(statearr_47324_47334[(2)] = inst_47309);

(statearr_47324_47334[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__15091__auto____0 = (function (){
var statearr_47325 = [null,null,null,null,null,null,null];
(statearr_47325[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__15091__auto__);

(statearr_47325[(1)] = (1));

return statearr_47325;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__15091__auto____1 = (function (state_47314){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_47314);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e47326){var ex__15094__auto__ = e47326;
var statearr_47327_47335 = state_47314;
(statearr_47327_47335[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_47314[(4)]))){
var statearr_47328_47336 = state_47314;
(statearr_47328_47336[(1)] = cljs.core.first((state_47314[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__47337 = state_47314;
state_47314 = G__47337;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__15091__auto__ = function(state_47314){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__15091__auto____1.call(this,state_47314);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_47329 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_47329[(6)] = c__15165__auto__);

return statearr_47329;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_47354){
var state_val_47355 = (state_47354[(1)]);
if((state_val_47355 === (1))){
var state_47354__$1 = state_47354;
var statearr_47356_47370 = state_47354__$1;
(statearr_47356_47370[(2)] = null);

(statearr_47356_47370[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47355 === (2))){
var _ = (function (){var statearr_47357 = state_47354;
(statearr_47357[(4)] = cljs.core.cons((5),(state_47354[(4)])));

return statearr_47357;
})();
var inst_47344 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_47345 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_47346 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_47345,inst_47344);
var state_47354__$1 = state_47354;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47354__$1,(6),inst_47346);
} else {
if((state_val_47355 === (3))){
var inst_47352 = (state_47354[(2)]);
var state_47354__$1 = state_47354;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47354__$1,inst_47352);
} else {
if((state_val_47355 === (4))){
var inst_47338 = (state_47354[(2)]);
var state_47354__$1 = state_47354;
var statearr_47359_47371 = state_47354__$1;
(statearr_47359_47371[(2)] = inst_47338);

(statearr_47359_47371[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47355 === (5))){
var _ = (function (){var statearr_47360 = state_47354;
(statearr_47360[(4)] = cljs.core.rest((state_47354[(4)])));

return statearr_47360;
})();
var state_47354__$1 = state_47354;
var ex47358 = (state_47354__$1[(2)]);
var statearr_47361_47372 = state_47354__$1;
(statearr_47361_47372[(5)] = ex47358);


if((ex47358 instanceof Error)){
var statearr_47362_47373 = state_47354__$1;
(statearr_47362_47373[(1)] = (4));

(statearr_47362_47373[(5)] = null);

} else {
throw ex47358;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47355 === (6))){
var inst_47348 = (state_47354[(2)]);
var inst_47349 = fluree.db.util.async.throw_err(inst_47348);
var _ = (function (){var statearr_47363 = state_47354;
(statearr_47363[(4)] = cljs.core.rest((state_47354[(4)])));

return statearr_47363;
})();
var state_47354__$1 = state_47354;
var statearr_47364_47374 = state_47354__$1;
(statearr_47364_47374[(2)] = inst_47349);

(statearr_47364_47374[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__15091__auto____0 = (function (){
var statearr_47365 = [null,null,null,null,null,null,null];
(statearr_47365[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__15091__auto__);

(statearr_47365[(1)] = (1));

return statearr_47365;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__15091__auto____1 = (function (state_47354){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_47354);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e47366){var ex__15094__auto__ = e47366;
var statearr_47367_47375 = state_47354;
(statearr_47367_47375[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_47354[(4)]))){
var statearr_47368_47376 = state_47354;
(statearr_47368_47376[(1)] = cljs.core.first((state_47354[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__47377 = state_47354;
state_47354 = G__47377;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__15091__auto__ = function(state_47354){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__15091__auto____1.call(this,state_47354);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_47369 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_47369[(6)] = c__15165__auto__);

return statearr_47369;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__47378_SHARP_){
return p1__47378_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__47379_SHARP_){
return p1__47379_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e47380){var e = e47380;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__47381_SHARP_){
return p1__47381_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__47382_SHARP_){
return p1__47382_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e47383){var e = e47383;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__47385 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__47385);
})() | (0));
return num;
}catch (e47384){var e = e47384;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_47465){
var state_val_47466 = (state_47465[(1)]);
if((state_val_47466 === (7))){
var inst_47404 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_47405 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_47406 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_47407 = cljs.core.PersistentHashMap.fromArrays(inst_47405,inst_47406);
var inst_47408 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_47404,inst_47407);
var inst_47409 = (function(){throw inst_47408})();
var state_47465__$1 = state_47465;
var statearr_47467_47502 = state_47465__$1;
(statearr_47467_47502[(2)] = inst_47409);

(statearr_47467_47502[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47466 === (1))){
var state_47465__$1 = state_47465;
var statearr_47468_47503 = state_47465__$1;
(statearr_47468_47503[(2)] = null);

(statearr_47468_47503[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47466 === (4))){
var inst_47386 = (state_47465[(2)]);
var state_47465__$1 = state_47465;
var statearr_47469_47504 = state_47465__$1;
(statearr_47469_47504[(2)] = inst_47386);

(statearr_47469_47504[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47466 === (15))){
var inst_47449 = (state_47465[(7)]);
var inst_47445 = (state_47465[(2)]);
var inst_47446 = fluree.db.util.async.throw_err(inst_47445);
var inst_47447 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47446,(0),null);
var inst_47448 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47446,(1),null);
var inst_47449__$1 = cljs.core.first(inst_47447);
var inst_47450 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_47449__$1,compare_val);
var state_47465__$1 = (function (){var statearr_47470 = state_47465;
(statearr_47470[(7)] = inst_47449__$1);

(statearr_47470[(8)] = inst_47448);

return statearr_47470;
})();
if(inst_47450){
var statearr_47471_47505 = state_47465__$1;
(statearr_47471_47505[(1)] = (16));

} else {
var statearr_47472_47506 = state_47465__$1;
(statearr_47472_47506[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47466 === (13))){
var state_47465__$1 = state_47465;
var statearr_47473_47507 = state_47465__$1;
(statearr_47473_47507[(2)] = null);

(statearr_47473_47507[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47466 === (6))){
var state_47465__$1 = state_47465;
var statearr_47474_47508 = state_47465__$1;
(statearr_47474_47508[(2)] = null);

(statearr_47474_47508[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47466 === (17))){
var inst_47449 = (state_47465[(7)]);
var inst_47453 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_47449)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_47454 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_47455 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_47456 = cljs.core.PersistentHashMap.fromArrays(inst_47454,inst_47455);
var inst_47457 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_47453,inst_47456);
var inst_47458 = (function(){throw inst_47457})();
var state_47465__$1 = state_47465;
var statearr_47475_47509 = state_47465__$1;
(statearr_47475_47509[(2)] = inst_47458);

(statearr_47475_47509[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47466 === (3))){
var inst_47463 = (state_47465[(2)]);
var state_47465__$1 = state_47465;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47465__$1,inst_47463);
} else {
if((state_val_47466 === (12))){
var inst_47401 = (state_47465[(9)]);
var inst_47424 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_47401], 0));
var inst_47425 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_47426 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_47427 = cljs.core.PersistentHashMap.fromArrays(inst_47425,inst_47426);
var inst_47428 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_47424,inst_47427);
var inst_47429 = (function(){throw inst_47428})();
var state_47465__$1 = state_47465;
var statearr_47476_47510 = state_47465__$1;
(statearr_47476_47510[(2)] = inst_47429);

(statearr_47476_47510[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47466 === (2))){
var inst_47400 = (state_47465[(10)]);
var inst_47398 = (state_47465[(11)]);
var inst_47399 = (state_47465[(12)]);
var _ = (function (){var statearr_47477 = state_47465;
(statearr_47477[(4)] = cljs.core.cons((5),(state_47465[(4)])));

return statearr_47477;
})();
var inst_47396 = _QMARK_ctx;
var inst_47397 = cljs.core.__destructure_map(inst_47396);
var inst_47398__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47397,cljs.core.cst$kw$sid);
var inst_47399__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47397,cljs.core.cst$kw$pid);
var inst_47400__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47397,cljs.core.cst$kw$db);
var inst_47401 = fluree.db.dbproto._p_prop(inst_47400__$1,cljs.core.cst$kw$name,inst_47399__$1);
var state_47465__$1 = (function (){var statearr_47478 = state_47465;
(statearr_47478[(9)] = inst_47401);

(statearr_47478[(10)] = inst_47400__$1);

(statearr_47478[(11)] = inst_47398__$1);

(statearr_47478[(12)] = inst_47399__$1);

return statearr_47478;
})();
if(cljs.core.truth_(inst_47398__$1)){
var statearr_47479_47511 = state_47465__$1;
(statearr_47479_47511[(1)] = (6));

} else {
var statearr_47480_47512 = state_47465__$1;
(statearr_47480_47512[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47466 === (11))){
var inst_47400 = (state_47465[(10)]);
var inst_47399 = (state_47465[(12)]);
var inst_47421 = (state_47465[(2)]);
var inst_47422 = fluree.db.dbproto._p_prop(inst_47400,cljs.core.cst$kw$multi,inst_47399);
var state_47465__$1 = (function (){var statearr_47482 = state_47465;
(statearr_47482[(13)] = inst_47421);

return statearr_47482;
})();
if(cljs.core.truth_(inst_47422)){
var statearr_47483_47513 = state_47465__$1;
(statearr_47483_47513[(1)] = (12));

} else {
var statearr_47484_47514 = state_47465__$1;
(statearr_47484_47514[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47466 === (9))){
var state_47465__$1 = state_47465;
var statearr_47485_47515 = state_47465__$1;
(statearr_47485_47515[(2)] = null);

(statearr_47485_47515[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47466 === (5))){
var _ = (function (){var statearr_47486 = state_47465;
(statearr_47486[(4)] = cljs.core.rest((state_47465[(4)])));

return statearr_47486;
})();
var state_47465__$1 = state_47465;
var ex47481 = (state_47465__$1[(2)]);
var statearr_47487_47516 = state_47465__$1;
(statearr_47487_47516[(5)] = ex47481);


if((ex47481 instanceof Error)){
var statearr_47488_47517 = state_47465__$1;
(statearr_47488_47517[(1)] = (4));

(statearr_47488_47517[(5)] = null);

} else {
throw ex47481;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47466 === (14))){
var inst_47401 = (state_47465[(9)]);
var inst_47400 = (state_47465[(10)]);
var inst_47398 = (state_47465[(11)]);
var inst_47432 = (state_47465[(2)]);
var inst_47433 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_47434 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47435 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47436 = [inst_47398,inst_47401,"?current-val"];
var inst_47437 = (new cljs.core.PersistentVector(null,3,(5),inst_47435,inst_47436,null));
var inst_47438 = [inst_47437];
var inst_47439 = (new cljs.core.PersistentVector(null,1,(5),inst_47434,inst_47438,null));
var inst_47440 = cljs.core.PersistentHashMap.EMPTY;
var inst_47441 = ["?current-val",inst_47439,inst_47440];
var inst_47442 = cljs.core.PersistentHashMap.fromArrays(inst_47433,inst_47441);
var inst_47443 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_47400,inst_47442);
var state_47465__$1 = (function (){var statearr_47489 = state_47465;
(statearr_47489[(14)] = inst_47432);

return statearr_47489;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47465__$1,(15),inst_47443);
} else {
if((state_val_47466 === (16))){
var state_47465__$1 = state_47465;
var statearr_47490_47518 = state_47465__$1;
(statearr_47490_47518[(2)] = new_val);

(statearr_47490_47518[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47466 === (10))){
var inst_47414 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_47415 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_47416 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_47417 = cljs.core.PersistentHashMap.fromArrays(inst_47415,inst_47416);
var inst_47418 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_47414,inst_47417);
var inst_47419 = (function(){throw inst_47418})();
var state_47465__$1 = state_47465;
var statearr_47491_47519 = state_47465__$1;
(statearr_47491_47519[(2)] = inst_47419);

(statearr_47491_47519[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47466 === (18))){
var inst_47460 = (state_47465[(2)]);
var _ = (function (){var statearr_47492 = state_47465;
(statearr_47492[(4)] = cljs.core.rest((state_47465[(4)])));

return statearr_47492;
})();
var state_47465__$1 = state_47465;
var statearr_47493_47520 = state_47465__$1;
(statearr_47493_47520[(2)] = inst_47460);

(statearr_47493_47520[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47466 === (8))){
var inst_47401 = (state_47465[(9)]);
var inst_47411 = (state_47465[(2)]);
var state_47465__$1 = (function (){var statearr_47494 = state_47465;
(statearr_47494[(15)] = inst_47411);

return statearr_47494;
})();
if(cljs.core.truth_(inst_47401)){
var statearr_47495_47521 = state_47465__$1;
(statearr_47495_47521[(1)] = (9));

} else {
var statearr_47496_47522 = state_47465__$1;
(statearr_47496_47522[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__15091__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__15091__auto____0 = (function (){
var statearr_47497 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47497[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__15091__auto__);

(statearr_47497[(1)] = (1));

return statearr_47497;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__15091__auto____1 = (function (state_47465){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_47465);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e47498){var ex__15094__auto__ = e47498;
var statearr_47499_47523 = state_47465;
(statearr_47499_47523[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_47465[(4)]))){
var statearr_47500_47524 = state_47465;
(statearr_47500_47524[(1)] = cljs.core.first((state_47465[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__47525 = state_47465;
state_47465 = G__47525;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__15091__auto__ = function(state_47465){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__15091__auto____1.call(this,state_47465);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__15091__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__15091__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_47501 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_47501[(6)] = c__15165__auto__);

return statearr_47501;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
