// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__41081 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41081,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41081,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41081,(2),null);
if(cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_ledger_DASH_name], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__41084){
var map__41085 = p__41084;
var map__41085__$1 = cljs.core.__destructure_map(map__41085);
var opts = map__41085__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41085__$1,cljs.core.cst$kw$reindex_QMARK_);
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_41145){
var state_val_41146 = (state_41145[(1)]);
if((state_val_41146 === (7))){
var inst_41116 = cljs.core.not(reindex_QMARK_);
var state_41145__$1 = state_41145;
var statearr_41147_41171 = state_41145__$1;
(statearr_41147_41171[(2)] = inst_41116);

(statearr_41147_41171[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41146 === (1))){
var state_41145__$1 = state_41145;
var statearr_41148_41172 = state_41145__$1;
(statearr_41148_41172[(2)] = null);

(statearr_41148_41172[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41146 === (4))){
var inst_41086 = (state_41145[(2)]);
var state_41145__$1 = state_41145;
var statearr_41149_41173 = state_41145__$1;
(statearr_41149_41173[(2)] = inst_41086);

(statearr_41149_41173[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41146 === (6))){
var inst_41114 = (state_41145[(7)]);
var inst_41106 = (state_41145[(8)]);
var inst_41100 = (state_41145[(9)]);
var inst_41099 = (state_41145[(2)]);
var inst_41100__$1 = fluree.db.util.async.throw_err(inst_41099);
var inst_41101 = cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(db);
var inst_41102 = cljs.core.__destructure_map(inst_41101);
var inst_41103 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41102,cljs.core.cst$kw$post);
var inst_41104 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41102,cljs.core.cst$kw$size);
var inst_41105 = fluree.db.flake.size_bytes(inst_41100__$1);
var inst_41106__$1 = (inst_41104 + inst_41105);
var inst_41107 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41108 = [cljs.core.cst$kw$conn,cljs.core.cst$kw$meta];
var inst_41109 = (new cljs.core.PersistentVector(null,2,(5),inst_41107,inst_41108,null));
var inst_41110 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_41109);
var inst_41111 = cljs.core.__destructure_map(inst_41110);
var inst_41112 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41111,cljs.core.cst$kw$novelty_DASH_min);
var inst_41113 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41111,cljs.core.cst$kw$novelty_DASH_max);
var inst_41114__$1 = (inst_41106__$1 > inst_41113);
var state_41145__$1 = (function (){var statearr_41150 = state_41145;
(statearr_41150[(7)] = inst_41114__$1);

(statearr_41150[(10)] = inst_41103);

(statearr_41150[(8)] = inst_41106__$1);

(statearr_41150[(9)] = inst_41100__$1);

(statearr_41150[(11)] = inst_41112);

return statearr_41150;
})();
if(cljs.core.truth_(inst_41114__$1)){
var statearr_41151_41174 = state_41145__$1;
(statearr_41151_41174[(1)] = (7));

} else {
var statearr_41152_41175 = state_41145__$1;
(statearr_41152_41175[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41146 === (3))){
var inst_41143 = (state_41145[(2)]);
var state_41145__$1 = state_41145;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41145__$1,inst_41143);
} else {
if((state_val_41146 === (12))){
var inst_41103 = (state_41145[(10)]);
var inst_41106 = (state_41145[(8)]);
var inst_41100 = (state_41145[(9)]);
var inst_41129 = (state_41145[(2)]);
var inst_41130 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_41103,inst_41100);
var inst_41131 = cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(db);
var inst_41132 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_41131,cljs.core.empty);
var inst_41133 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41134 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_41135 = (new cljs.core.PersistentVector(null,2,(5),inst_41133,inst_41134,null));
var inst_41136 = cljs.core.assoc_in(db,inst_41135,inst_41130);
var inst_41137 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41138 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_41139 = (new cljs.core.PersistentVector(null,2,(5),inst_41137,inst_41138,null));
var inst_41140 = cljs.core.assoc_in(inst_41136,inst_41139,inst_41106);
var _ = (function (){var statearr_41153 = state_41145;
(statearr_41153[(4)] = cljs.core.rest((state_41145[(4)])));

return statearr_41153;
})();
var state_41145__$1 = (function (){var statearr_41154 = state_41145;
(statearr_41154[(12)] = inst_41129);

(statearr_41154[(13)] = inst_41132);

return statearr_41154;
})();
var statearr_41155_41176 = state_41145__$1;
(statearr_41155_41176[(2)] = inst_41140);

(statearr_41155_41176[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41146 === (2))){
var _ = (function (){var statearr_41156 = state_41145;
(statearr_41156[(4)] = cljs.core.cons((5),(state_41145[(4)])));

return statearr_41156;
})();
var inst_41094 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41095 = [pred_id];
var inst_41096 = (new cljs.core.PersistentVector(null,1,(5),inst_41094,inst_41095,null));
var inst_41097 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_41096);
var state_41145__$1 = state_41145;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41145__$1,(6),inst_41097);
} else {
if((state_val_41146 === (11))){
var state_41145__$1 = state_41145;
var statearr_41158_41177 = state_41145__$1;
(statearr_41158_41177[(2)] = null);

(statearr_41158_41177[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41146 === (9))){
var inst_41119 = (state_41145[(2)]);
var state_41145__$1 = state_41145;
if(cljs.core.truth_(inst_41119)){
var statearr_41159_41178 = state_41145__$1;
(statearr_41159_41178[(1)] = (10));

} else {
var statearr_41160_41179 = state_41145__$1;
(statearr_41160_41179[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41146 === (5))){
var _ = (function (){var statearr_41161 = state_41145;
(statearr_41161[(4)] = cljs.core.rest((state_41145[(4)])));

return statearr_41161;
})();
var state_41145__$1 = state_41145;
var ex41157 = (state_41145__$1[(2)]);
var statearr_41162_41180 = state_41145__$1;
(statearr_41162_41180[(5)] = ex41157);


if((ex41157 instanceof Error)){
var statearr_41163_41181 = state_41145__$1;
(statearr_41163_41181[(1)] = (4));

(statearr_41163_41181[(5)] = null);

} else {
throw ex41157;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41146 === (10))){
var inst_41121 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_41122 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_41123 = [cljs.core.cst$kw$db_SLASH_max_DASH_novelty_DASH_size,(400)];
var inst_41124 = cljs.core.PersistentHashMap.fromArrays(inst_41122,inst_41123);
var inst_41125 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41121,inst_41124);
var inst_41126 = (function(){throw inst_41125})();
var state_41145__$1 = state_41145;
var statearr_41164_41182 = state_41145__$1;
(statearr_41164_41182[(2)] = inst_41126);

(statearr_41164_41182[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41146 === (8))){
var inst_41114 = (state_41145[(7)]);
var state_41145__$1 = state_41145;
var statearr_41165_41183 = state_41145__$1;
(statearr_41165_41183[(2)] = inst_41114);

(statearr_41165_41183[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__15091__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__15091__auto____0 = (function (){
var statearr_41166 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41166[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__15091__auto__);

(statearr_41166[(1)] = (1));

return statearr_41166;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__15091__auto____1 = (function (state_41145){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_41145);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e41167){var ex__15094__auto__ = e41167;
var statearr_41168_41184 = state_41145;
(statearr_41168_41184[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_41145[(4)]))){
var statearr_41169_41185 = state_41145;
(statearr_41169_41185[(1)] = cljs.core.first((state_41145[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__41186 = state_41145;
state_41145 = G__41186;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__15091__auto__ = function(state_41145){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__15091__auto____1.call(this,state_41145);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__15091__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__15091__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_41170 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_41170[(6)] = c__15165__auto__);

return statearr_41170;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__41191 = arguments.length;
switch (G__41191) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_41387){
var state_val_41388 = (state_41387[(1)]);
if((state_val_41388 === (7))){
var state_41387__$1 = state_41387;
var statearr_41389_41457 = state_41387__$1;
(statearr_41389_41457[(2)] = null);

(statearr_41389_41457[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (20))){
var inst_41310 = (state_41387[(7)]);
var inst_41312 = (state_41387[(8)]);
var inst_41280 = (state_41387[(9)]);
var inst_41229 = (state_41387[(10)]);
var inst_41311 = (state_41387[(11)]);
var inst_41230 = (state_41387[(12)]);
var inst_41313 = (state_41387[(13)]);
var inst_41309 = (state_41387[(14)]);
var inst_41323 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$size];
var inst_41324 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41325 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_41326 = (new cljs.core.PersistentVector(null,2,(5),inst_41324,inst_41325,null));
var inst_41327 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_41280,inst_41326);
var inst_41328 = (inst_41229 + inst_41327);
var inst_41329 = [inst_41309,inst_41310,inst_41311,inst_41312,inst_41328];
var inst_41330 = cljs.core.PersistentHashMap.fromArrays(inst_41323,inst_41329);
var inst_41331 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_41280,cljs.core.cst$kw$ecount,inst_41313,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$novelty,inst_41330], 0));
var state_41387__$1 = (function (){var statearr_41390 = state_41387;
(statearr_41390[(15)] = inst_41331);

return statearr_41390;
})();
if(cljs.core.truth_(inst_41230)){
var statearr_41391_41458 = state_41387__$1;
(statearr_41391_41458[(1)] = (23));

} else {
var statearr_41392_41459 = state_41387__$1;
(statearr_41392_41459[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (27))){
var inst_41331 = (state_41387[(15)]);
var state_41387__$1 = state_41387;
var statearr_41393_41460 = state_41387__$1;
(statearr_41393_41460[(2)] = inst_41331);

(statearr_41393_41460[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (1))){
var state_41387__$1 = state_41387;
var statearr_41394_41461 = state_41387__$1;
(statearr_41394_41461[(2)] = null);

(statearr_41394_41461[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (24))){
var inst_41331 = (state_41387[(15)]);
var inst_41334 = cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(inst_41331);
var inst_41335 = (inst_41334 == null);
var state_41387__$1 = state_41387;
var statearr_41395_41462 = state_41387__$1;
(statearr_41395_41462[(2)] = inst_41335);

(statearr_41395_41462[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (39))){
var inst_41363 = (state_41387[(16)]);
var inst_41362 = (state_41387[(17)]);
var inst_41361 = (state_41387[(18)]);
var inst_41370 = (state_41387[(19)]);
var inst_41320 = (state_41387[(20)]);
var inst_41377 = (state_41387[(2)]);
var inst_41308 = inst_41320;
var inst_41309 = inst_41362;
var inst_41310 = inst_41363;
var inst_41311 = inst_41370;
var inst_41312 = inst_41377;
var inst_41313 = inst_41361;
var state_41387__$1 = (function (){var statearr_41396 = state_41387;
(statearr_41396[(21)] = inst_41308);

(statearr_41396[(7)] = inst_41310);

(statearr_41396[(8)] = inst_41312);

(statearr_41396[(11)] = inst_41311);

(statearr_41396[(13)] = inst_41313);

(statearr_41396[(14)] = inst_41309);

return statearr_41396;
})();
var statearr_41397_41463 = state_41387__$1;
(statearr_41397_41463[(2)] = null);

(statearr_41397_41463[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (4))){
var inst_41192 = (state_41387[(2)]);
var state_41387__$1 = state_41387;
var statearr_41398_41464 = state_41387__$1;
(statearr_41398_41464[(2)] = inst_41192);

(statearr_41398_41464[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (15))){
var inst_41252 = (state_41387[(22)]);
var state_41387__$1 = state_41387;
var statearr_41399_41465 = state_41387__$1;
(statearr_41399_41465[(2)] = inst_41252);

(statearr_41399_41465[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (21))){
var inst_41224 = (state_41387[(23)]);
var inst_41231 = (state_41387[(24)]);
var inst_41239 = (state_41387[(25)]);
var inst_41228 = (state_41387[(26)]);
var inst_41319 = (state_41387[(27)]);
var inst_41308 = (state_41387[(21)]);
var inst_41216 = (state_41387[(28)]);
var inst_41290 = (state_41387[(29)]);
var inst_41310 = (state_41387[(7)]);
var inst_41312 = (state_41387[(8)]);
var inst_41280 = (state_41387[(9)]);
var inst_41229 = (state_41387[(10)]);
var inst_41311 = (state_41387[(11)]);
var inst_41220 = (state_41387[(30)]);
var inst_41214 = (state_41387[(31)]);
var inst_41320 = (state_41387[(20)]);
var inst_41199 = (state_41387[(32)]);
var inst_41230 = (state_41387[(12)]);
var inst_41313 = (state_41387[(13)]);
var inst_41233 = (state_41387[(33)]);
var inst_41289 = (state_41387[(34)]);
var inst_41309 = (state_41387[(14)]);
var inst_41358 = inst_41319.s;
var inst_41359 = fluree.db.flake.sid__GT_cid(inst_41358);
var inst_41360 = (function (){var flakes_bytes = inst_41229;
var seq__41316 = inst_41320;
var t = inst_41199;
var spot = inst_41309;
var add_flakes = inst_41216;
var first__41287 = inst_41289;
var root_setting_change_QMARK_ = inst_41231;
var ref_QMARK__map = inst_41228;
var r = inst_41320;
var seq__41286 = inst_41290;
var psot = inst_41310;
var add_pred_to_idx_QMARK_ = inst_41239;
var _ = inst_41214;
var cid = inst_41359;
var G__41284 = inst_41308;
var ecount = inst_41313;
var pred_ecount = inst_41233;
var vec__41315 = inst_41308;
var db_STAR_ = inst_41280;
var schema_change_QMARK_ = inst_41230;
var vec__41285 = inst_41216;
var first__41317 = inst_41319;
var add_preds = inst_41220;
var opst = inst_41312;
var idx_QMARK__map = inst_41224;
var post = inst_41311;
var f = inst_41319;
return (function (p1__41189_SHARP_){
if(cljs.core.truth_(p1__41189_SHARP_)){
var x__5130__auto__ = p1__41189_SHARP_;
var y__5131__auto__ = f.s;
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
} else {
return f.s;
}
});
})();
var inst_41361 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_41313,inst_41359,inst_41360);
var inst_41362 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_41309,inst_41319);
var inst_41363 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_41310,inst_41319);
var inst_41364 = inst_41319.p;
var inst_41365 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41224,inst_41364);
var state_41387__$1 = (function (){var statearr_41400 = state_41387;
(statearr_41400[(16)] = inst_41363);

(statearr_41400[(17)] = inst_41362);

(statearr_41400[(18)] = inst_41361);

return statearr_41400;
})();
if(cljs.core.truth_(inst_41365)){
var statearr_41401_41466 = state_41387__$1;
(statearr_41401_41466[(1)] = (34));

} else {
var statearr_41402_41467 = state_41387__$1;
(statearr_41402_41467[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (31))){
var inst_41346 = (state_41387[(35)]);
var state_41387__$1 = state_41387;
var statearr_41403_41468 = state_41387__$1;
(statearr_41403_41468[(2)] = inst_41346);

(statearr_41403_41468[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (32))){
var inst_41356 = (state_41387[(2)]);
var state_41387__$1 = state_41387;
var statearr_41404_41469 = state_41387__$1;
(statearr_41404_41469[(2)] = inst_41356);

(statearr_41404_41469[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (33))){
var inst_41346 = (state_41387[(35)]);
var inst_41351 = (state_41387[(2)]);
var inst_41352 = fluree.db.util.async.throw_err(inst_41351);
var inst_41353 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_41346,cljs.core.cst$kw$settings,inst_41352);
var state_41387__$1 = state_41387;
var statearr_41405_41470 = state_41387__$1;
(statearr_41405_41470[(2)] = inst_41353);

(statearr_41405_41470[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (13))){
var inst_41216 = (state_41387[(28)]);
var inst_41280 = (state_41387[(9)]);
var inst_41229 = (state_41387[(10)]);
var inst_41199 = (state_41387[(32)]);
var inst_41270 = (state_41387[(2)]);
var inst_41271 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_41270,cljs.core.cst$kw$t,inst_41199);
var inst_41272 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41273 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$size];
var inst_41274 = (new cljs.core.PersistentVector(null,2,(5),inst_41272,inst_41273,null));
var inst_41275 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_41271,inst_41274,cljs.core._PLUS_,inst_41229);
var inst_41276 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41277 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$flakes];
var inst_41278 = (new cljs.core.PersistentVector(null,2,(5),inst_41276,inst_41277,null));
var inst_41279 = cljs.core.count(inst_41216);
var inst_41280__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_41275,inst_41278,cljs.core._PLUS_,inst_41279);
var inst_41288 = cljs.core.seq(inst_41216);
var inst_41289 = cljs.core.first(inst_41288);
var inst_41290 = cljs.core.next(inst_41288);
var inst_41291 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41292 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$spot];
var inst_41293 = (new cljs.core.PersistentVector(null,2,(5),inst_41291,inst_41292,null));
var inst_41294 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_41280__$1,inst_41293);
var inst_41295 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41296 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$psot];
var inst_41297 = (new cljs.core.PersistentVector(null,2,(5),inst_41295,inst_41296,null));
var inst_41298 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_41280__$1,inst_41297);
var inst_41299 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41300 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_41301 = (new cljs.core.PersistentVector(null,2,(5),inst_41299,inst_41300,null));
var inst_41302 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_41280__$1,inst_41301);
var inst_41303 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41304 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$opst];
var inst_41305 = (new cljs.core.PersistentVector(null,2,(5),inst_41303,inst_41304,null));
var inst_41306 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_41280__$1,inst_41305);
var inst_41307 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_41308 = inst_41216;
var inst_41309 = inst_41294;
var inst_41310 = inst_41298;
var inst_41311 = inst_41302;
var inst_41312 = inst_41306;
var inst_41313 = inst_41307;
var state_41387__$1 = (function (){var statearr_41406 = state_41387;
(statearr_41406[(21)] = inst_41308);

(statearr_41406[(29)] = inst_41290);

(statearr_41406[(7)] = inst_41310);

(statearr_41406[(8)] = inst_41312);

(statearr_41406[(9)] = inst_41280__$1);

(statearr_41406[(11)] = inst_41311);

(statearr_41406[(13)] = inst_41313);

(statearr_41406[(34)] = inst_41289);

(statearr_41406[(14)] = inst_41309);

return statearr_41406;
})();
var statearr_41407_41471 = state_41387__$1;
(statearr_41407_41471[(2)] = null);

(statearr_41407_41471[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (22))){
var inst_41380 = (state_41387[(2)]);
var state_41387__$1 = state_41387;
var statearr_41408_41472 = state_41387__$1;
(statearr_41408_41472[(2)] = inst_41380);

(statearr_41408_41472[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (36))){
var inst_41228 = (state_41387[(26)]);
var inst_41319 = (state_41387[(27)]);
var inst_41370 = (state_41387[(2)]);
var inst_41371 = inst_41319.p;
var inst_41372 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41228,inst_41371);
var state_41387__$1 = (function (){var statearr_41409 = state_41387;
(statearr_41409[(19)] = inst_41370);

return statearr_41409;
})();
if(cljs.core.truth_(inst_41372)){
var statearr_41410_41473 = state_41387__$1;
(statearr_41410_41473[(1)] = (37));

} else {
var statearr_41411_41474 = state_41387__$1;
(statearr_41411_41474[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (29))){
var inst_41331 = (state_41387[(15)]);
var inst_41341 = (state_41387[(2)]);
var inst_41342 = fluree.db.util.async.throw_err(inst_41341);
var inst_41343 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_41331,cljs.core.cst$kw$schema,inst_41342);
var state_41387__$1 = state_41387;
var statearr_41412_41475 = state_41387__$1;
(statearr_41412_41475[(2)] = inst_41343);

(statearr_41412_41475[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (6))){
var inst_41199 = (state_41387[(32)]);
var inst_41204 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_41205 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_41206 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41204)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41205)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41199),"."].join('');
var inst_41207 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41208 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_41209 = cljs.core.PersistentHashMap.fromArrays(inst_41207,inst_41208);
var inst_41210 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41206,inst_41209);
var inst_41211 = (function(){throw inst_41210})();
var state_41387__$1 = state_41387;
var statearr_41413_41476 = state_41387__$1;
(statearr_41413_41476[(2)] = inst_41211);

(statearr_41413_41476[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (28))){
var inst_41231 = (state_41387[(24)]);
var inst_41346 = (state_41387[(2)]);
var state_41387__$1 = (function (){var statearr_41414 = state_41387;
(statearr_41414[(35)] = inst_41346);

return statearr_41414;
})();
if(cljs.core.truth_(inst_41231)){
var statearr_41415_41477 = state_41387__$1;
(statearr_41415_41477[(1)] = (30));

} else {
var statearr_41416_41478 = state_41387__$1;
(statearr_41416_41478[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (25))){
var inst_41337 = (state_41387[(2)]);
var state_41387__$1 = state_41387;
if(cljs.core.truth_(inst_41337)){
var statearr_41417_41479 = state_41387__$1;
(statearr_41417_41479[(1)] = (26));

} else {
var statearr_41418_41480 = state_41387__$1;
(statearr_41418_41480[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (34))){
var inst_41319 = (state_41387[(27)]);
var inst_41311 = (state_41387[(11)]);
var inst_41367 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_41311,inst_41319);
var state_41387__$1 = state_41387;
var statearr_41419_41481 = state_41387__$1;
(statearr_41419_41481[(2)] = inst_41367);

(statearr_41419_41481[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (17))){
var inst_41259 = (state_41387[(36)]);
var inst_41263 = (state_41387[(2)]);
var inst_41264 = fluree.db.util.async.throw_err(inst_41263);
var inst_41251 = inst_41259;
var inst_41252 = inst_41264;
var state_41387__$1 = (function (){var statearr_41420 = state_41387;
(statearr_41420[(22)] = inst_41252);

(statearr_41420[(37)] = inst_41251);

return statearr_41420;
})();
var statearr_41421_41482 = state_41387__$1;
(statearr_41421_41482[(2)] = null);

(statearr_41421_41482[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (3))){
var inst_41385 = (state_41387[(2)]);
var state_41387__$1 = state_41387;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41387__$1,inst_41385);
} else {
if((state_val_41388 === (12))){
var inst_41251 = (state_41387[(37)]);
var inst_41258 = (state_41387[(38)]);
var inst_41257 = cljs.core.seq(inst_41251);
var inst_41258__$1 = cljs.core.first(inst_41257);
var inst_41259 = cljs.core.next(inst_41257);
var state_41387__$1 = (function (){var statearr_41422 = state_41387;
(statearr_41422[(36)] = inst_41259);

(statearr_41422[(38)] = inst_41258__$1);

return statearr_41422;
})();
if(cljs.core.truth_(inst_41258__$1)){
var statearr_41423_41483 = state_41387__$1;
(statearr_41423_41483[(1)] = (14));

} else {
var statearr_41424_41484 = state_41387__$1;
(statearr_41424_41484[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (2))){
var inst_41199 = (state_41387[(32)]);
var _ = (function (){var statearr_41425 = state_41387;
(statearr_41425[(4)] = cljs.core.cons((5),(state_41387[(4)])));

return statearr_41425;
})();
var inst_41198 = cljs.core.first(flakes);
var inst_41199__$1 = inst_41198.t;
var inst_41200 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_41201 = (inst_41200 - (1));
var inst_41202 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_41199__$1,inst_41201);
var state_41387__$1 = (function (){var statearr_41426 = state_41387;
(statearr_41426[(32)] = inst_41199__$1);

return statearr_41426;
})();
if(inst_41202){
var statearr_41427_41485 = state_41387__$1;
(statearr_41427_41485[(1)] = (6));

} else {
var statearr_41428_41486 = state_41387__$1;
(statearr_41428_41486[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (23))){
var inst_41230 = (state_41387[(12)]);
var state_41387__$1 = state_41387;
var statearr_41429_41487 = state_41387__$1;
(statearr_41429_41487[(2)] = inst_41230);

(statearr_41429_41487[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (35))){
var inst_41311 = (state_41387[(11)]);
var state_41387__$1 = state_41387;
var statearr_41430_41488 = state_41387__$1;
(statearr_41430_41488[(2)] = inst_41311);

(statearr_41430_41488[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (19))){
var inst_41382 = (state_41387[(2)]);
var _ = (function (){var statearr_41431 = state_41387;
(statearr_41431[(4)] = cljs.core.rest((state_41387[(4)])));

return statearr_41431;
})();
var state_41387__$1 = state_41387;
var statearr_41432_41489 = state_41387__$1;
(statearr_41432_41489[(2)] = inst_41382);

(statearr_41432_41489[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (11))){
var inst_41239 = (state_41387[(25)]);
var inst_41239__$1 = (state_41387[(2)]);
var inst_41247 = cljs.core.seq(inst_41239__$1);
var inst_41248 = cljs.core.first(inst_41247);
var inst_41249 = cljs.core.next(inst_41247);
var inst_41250 = db;
var inst_41251 = inst_41239__$1;
var inst_41252 = inst_41250;
var state_41387__$1 = (function (){var statearr_41434 = state_41387;
(statearr_41434[(25)] = inst_41239__$1);

(statearr_41434[(22)] = inst_41252);

(statearr_41434[(37)] = inst_41251);

(statearr_41434[(39)] = inst_41249);

(statearr_41434[(40)] = inst_41248);

return statearr_41434;
})();
var statearr_41435_41490 = state_41387__$1;
(statearr_41435_41490[(2)] = null);

(statearr_41435_41490[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (9))){
var inst_41216 = (state_41387[(28)]);
var inst_41233 = (state_41387[(33)]);
var inst_41235 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_41216,inst_41233);
var state_41387__$1 = state_41387;
var statearr_41436_41491 = state_41387__$1;
(statearr_41436_41491[(2)] = inst_41235);

(statearr_41436_41491[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (5))){
var _ = (function (){var statearr_41437 = state_41387;
(statearr_41437[(4)] = cljs.core.rest((state_41387[(4)])));

return statearr_41437;
})();
var state_41387__$1 = state_41387;
var ex41433 = (state_41387__$1[(2)]);
var statearr_41438_41492 = state_41387__$1;
(statearr_41438_41492[(5)] = ex41433);


if((ex41433 instanceof Error)){
var statearr_41439_41493 = state_41387__$1;
(statearr_41439_41493[(1)] = (4));

(statearr_41439_41493[(5)] = null);

} else {
throw ex41433;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (14))){
var inst_41252 = (state_41387[(22)]);
var inst_41258 = (state_41387[(38)]);
var inst_41261 = fluree.db.graphdb.add_predicate_to_idx(inst_41252,inst_41258,opts);
var state_41387__$1 = state_41387;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41387__$1,(17),inst_41261);
} else {
if((state_val_41388 === (26))){
var inst_41331 = (state_41387[(15)]);
var inst_41339 = fluree.db.query.schema.schema_map(inst_41331);
var state_41387__$1 = state_41387;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41387__$1,(29),inst_41339);
} else {
if((state_val_41388 === (16))){
var inst_41268 = (state_41387[(2)]);
var state_41387__$1 = state_41387;
var statearr_41440_41494 = state_41387__$1;
(statearr_41440_41494[(2)] = inst_41268);

(statearr_41440_41494[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (38))){
var inst_41312 = (state_41387[(8)]);
var state_41387__$1 = state_41387;
var statearr_41441_41495 = state_41387__$1;
(statearr_41441_41495[(2)] = inst_41312);

(statearr_41441_41495[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (30))){
var inst_41346 = (state_41387[(35)]);
var inst_41349 = fluree.db.query.schema.setting_map(inst_41346);
var state_41387__$1 = state_41387;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41387__$1,(33),inst_41349);
} else {
if((state_val_41388 === (10))){
var inst_41237 = cljs.core.PersistentVector.EMPTY;
var state_41387__$1 = state_41387;
var statearr_41442_41496 = state_41387__$1;
(statearr_41442_41496[(2)] = inst_41237);

(statearr_41442_41496[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (18))){
var inst_41319 = (state_41387[(27)]);
var inst_41308 = (state_41387[(21)]);
var inst_41318 = cljs.core.seq(inst_41308);
var inst_41319__$1 = cljs.core.first(inst_41318);
var inst_41320 = cljs.core.next(inst_41318);
var inst_41321 = cljs.core.not(inst_41319__$1);
var state_41387__$1 = (function (){var statearr_41443 = state_41387;
(statearr_41443[(27)] = inst_41319__$1);

(statearr_41443[(20)] = inst_41320);

return statearr_41443;
})();
if(inst_41321){
var statearr_41444_41497 = state_41387__$1;
(statearr_41444_41497[(1)] = (20));

} else {
var statearr_41445_41498 = state_41387__$1;
(statearr_41445_41498[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (37))){
var inst_41319 = (state_41387[(27)]);
var inst_41312 = (state_41387[(8)]);
var inst_41374 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_41312,inst_41319);
var state_41387__$1 = state_41387;
var statearr_41446_41499 = state_41387__$1;
(statearr_41446_41499[(2)] = inst_41374);

(statearr_41446_41499[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41388 === (8))){
var inst_41224 = (state_41387[(23)]);
var inst_41216 = (state_41387[(28)]);
var inst_41220 = (state_41387[(30)]);
var inst_41214 = (state_41387[(31)]);
var inst_41199 = (state_41387[(32)]);
var inst_41230 = (state_41387[(12)]);
var inst_41214__$1 = (state_41387[(2)]);
var inst_41215 = (function (){var t = inst_41199;
var _ = inst_41214__$1;
return (function (p1__41187_SHARP_){
return cljs.core.not((function (){var G__41447 = p1__41187_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__41447) : fluree.db.graphdb.exclude_predicates.call(null,G__41447));
})());
});
})();
var inst_41216__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_41215,flakes);
var inst_41217 = cljs.core.PersistentHashSet.EMPTY;
var inst_41218 = (function (){var t = inst_41199;
var _ = inst_41214__$1;
var add_flakes = inst_41216__$1;
return (function (p1__41188_SHARP_){
return p1__41188_SHARP_.p;
});
})();
var inst_41219 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_41218,inst_41216__$1);
var inst_41220__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_41217,inst_41219);
var inst_41221 = cljs.core.PersistentHashMap.EMPTY;
var inst_41222 = (function (){var t = inst_41199;
var _ = inst_41214__$1;
var add_flakes = inst_41216__$1;
var add_preds = inst_41220__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p)], null);
});
})();
var inst_41223 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_41222,inst_41220__$1);
var inst_41224__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_41221,inst_41223);
var inst_41225 = cljs.core.PersistentHashMap.EMPTY;
var inst_41226 = (function (){var t = inst_41199;
var _ = inst_41214__$1;
var add_flakes = inst_41216__$1;
var add_preds = inst_41220__$1;
var idx_QMARK__map = inst_41224__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p)], null);
});
})();
var inst_41227 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_41226,inst_41220__$1);
var inst_41228 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_41225,inst_41227);
var inst_41229 = fluree.db.flake.size_bytes(inst_41216__$1);
var inst_41230__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_41216__$1);
var inst_41231 = fluree.db.util.schema.setting_change_QMARK_(inst_41216__$1);
var inst_41232 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_41233 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41232,(0));
var state_41387__$1 = (function (){var statearr_41448 = state_41387;
(statearr_41448[(23)] = inst_41224__$1);

(statearr_41448[(24)] = inst_41231);

(statearr_41448[(26)] = inst_41228);

(statearr_41448[(28)] = inst_41216__$1);

(statearr_41448[(10)] = inst_41229);

(statearr_41448[(30)] = inst_41220__$1);

(statearr_41448[(31)] = inst_41214__$1);

(statearr_41448[(12)] = inst_41230__$1);

(statearr_41448[(33)] = inst_41233);

return statearr_41448;
})();
if(cljs.core.truth_(inst_41230__$1)){
var statearr_41449_41500 = state_41387__$1;
(statearr_41449_41500[(1)] = (9));

} else {
var statearr_41450_41501 = state_41387__$1;
(statearr_41450_41501[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__15091__auto__ = null;
var fluree$db$graphdb$state_machine__15091__auto____0 = (function (){
var statearr_41451 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41451[(0)] = fluree$db$graphdb$state_machine__15091__auto__);

(statearr_41451[(1)] = (1));

return statearr_41451;
});
var fluree$db$graphdb$state_machine__15091__auto____1 = (function (state_41387){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_41387);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e41452){var ex__15094__auto__ = e41452;
var statearr_41453_41502 = state_41387;
(statearr_41453_41502[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_41387[(4)]))){
var statearr_41454_41503 = state_41387;
(statearr_41454_41503[(1)] = cljs.core.first((state_41387[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__41504 = state_41387;
state_41387 = G__41504;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__15091__auto__ = function(state_41387){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__15091__auto____1.call(this,state_41387);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__15091__auto____0;
fluree$db$graphdb$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__15091__auto____1;
return fluree$db$graphdb$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_41455 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_41455[(6)] = c__15165__auto__);

return statearr_41455;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__41506 = arguments.length;
switch (G__41506) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__15165__auto___41653 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_41602){
var state_val_41603 = (state_41602[(1)]);
if((state_val_41603 === (7))){
var state_41602__$1 = state_41602;
var statearr_41604_41654 = state_41602__$1;
(statearr_41604_41654[(2)] = null);

(statearr_41604_41654[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41603 === (20))){
var inst_41550 = (state_41602[(7)]);
var inst_41551 = (state_41602[(8)]);
var inst_41552 = (state_41602[(9)]);
var inst_41571 = (inst_41550 + (1));
var inst_41572 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_41552,cljs.core.cst$kw$t,inst_41571);
var inst_41573 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_41572,inst_41551,opts);
var state_41602__$1 = state_41602;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41602__$1,(23),inst_41573);
} else {
if((state_val_41603 === (1))){
var state_41602__$1 = state_41602;
var statearr_41605_41655 = state_41602__$1;
(statearr_41605_41655[(2)] = null);

(statearr_41605_41655[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41603 === (24))){
var inst_41576 = (state_41602[(10)]);
var inst_41579 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_41576,cljs.core.cst$kw$block,block);
var state_41602__$1 = state_41602;
var statearr_41606_41656 = state_41602__$1;
(statearr_41606_41656[(2)] = inst_41579);

(statearr_41606_41656[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41603 === (4))){
var inst_41507 = (state_41602[(2)]);
var inst_41508 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_41507);
var state_41602__$1 = state_41602;
var statearr_41607_41657 = state_41602__$1;
(statearr_41607_41657[(2)] = inst_41508);

(statearr_41607_41657[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41603 === (15))){
var inst_41558 = (state_41602[(11)]);
var state_41602__$1 = state_41602;
var statearr_41608_41658 = state_41602__$1;
(statearr_41608_41658[(2)] = inst_41558);

(statearr_41608_41658[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41603 === (21))){
var state_41602__$1 = state_41602;
var statearr_41609_41659 = state_41602__$1;
(statearr_41609_41659[(2)] = null);

(statearr_41609_41659[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41603 === (13))){
var inst_41594 = (state_41602[(2)]);
var inst_41595 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_41594);
var state_41602__$1 = state_41602;
var statearr_41610_41660 = state_41602__$1;
(statearr_41610_41660[(2)] = inst_41595);

(statearr_41610_41660[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41603 === (22))){
var inst_41590 = (state_41602[(2)]);
var state_41602__$1 = state_41602;
var statearr_41611_41661 = state_41602__$1;
(statearr_41611_41661[(2)] = inst_41590);

(statearr_41611_41661[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41603 === (6))){
var inst_41518 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_41519 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_41520 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41518)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41519)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_41521 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41522 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_41523 = cljs.core.PersistentHashMap.fromArrays(inst_41521,inst_41522);
var inst_41524 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41520,inst_41523);
var inst_41525 = (function(){throw inst_41524})();
var state_41602__$1 = state_41602;
var statearr_41614_41662 = state_41602__$1;
(statearr_41614_41662[(2)] = inst_41525);

(statearr_41614_41662[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41603 === (25))){
var inst_41558 = (state_41602[(11)]);
var inst_41559 = (state_41602[(12)]);
var inst_41576 = (state_41602[(10)]);
var inst_41581 = inst_41558.t;
var inst_41582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41583 = [inst_41558];
var inst_41584 = (new cljs.core.PersistentVector(null,1,(5),inst_41582,inst_41583,null));
var inst_41549 = inst_41559;
var inst_41550 = inst_41581;
var inst_41551 = inst_41584;
var inst_41552 = inst_41576;
var state_41602__$1 = (function (){var statearr_41615 = state_41602;
(statearr_41615[(7)] = inst_41550);

(statearr_41615[(13)] = inst_41549);

(statearr_41615[(8)] = inst_41551);

(statearr_41615[(9)] = inst_41552);

return statearr_41615;
})();
var statearr_41616_41663 = state_41602__$1;
(statearr_41616_41663[(2)] = null);

(statearr_41616_41663[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41603 === (17))){
var inst_41558 = (state_41602[(11)]);
var inst_41559 = (state_41602[(12)]);
var inst_41550 = (state_41602[(7)]);
var inst_41551 = (state_41602[(8)]);
var inst_41552 = (state_41602[(9)]);
var inst_41567 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_41551,inst_41558);
var tmp41612 = inst_41550;
var tmp41613 = inst_41552;
var inst_41549 = inst_41559;
var inst_41550__$1 = tmp41612;
var inst_41551__$1 = inst_41567;
var inst_41552__$1 = tmp41613;
var state_41602__$1 = (function (){var statearr_41617 = state_41602;
(statearr_41617[(7)] = inst_41550__$1);

(statearr_41617[(13)] = inst_41549);

(statearr_41617[(8)] = inst_41551__$1);

(statearr_41617[(9)] = inst_41552__$1);

return statearr_41617;
})();
var statearr_41618_41664 = state_41602__$1;
(statearr_41618_41664[(2)] = null);

(statearr_41618_41664[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41603 === (3))){
var inst_41600 = (state_41602[(2)]);
var state_41602__$1 = state_41602;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41602__$1,inst_41600);
} else {
if((state_val_41603 === (12))){
var inst_41558 = (state_41602[(11)]);
var inst_41549 = (state_41602[(13)]);
var inst_41557 = cljs.core.seq(inst_41549);
var inst_41558__$1 = cljs.core.first(inst_41557);
var inst_41559 = cljs.core.next(inst_41557);
var state_41602__$1 = (function (){var statearr_41619 = state_41602;
(statearr_41619[(11)] = inst_41558__$1);

(statearr_41619[(12)] = inst_41559);

return statearr_41619;
})();
if(cljs.core.truth_(inst_41558__$1)){
var statearr_41620_41665 = state_41602__$1;
(statearr_41620_41665[(1)] = (14));

} else {
var statearr_41621_41666 = state_41602__$1;
(statearr_41621_41666[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41603 === (2))){
var _ = (function (){var statearr_41622 = state_41602;
(statearr_41622[(4)] = cljs.core.cons((5),(state_41602[(4)])));

return statearr_41622;
})();
var inst_41514 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_41515 = (inst_41514 + (1));
var inst_41516 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_41515);
var state_41602__$1 = state_41602;
if(inst_41516){
var statearr_41623_41667 = state_41602__$1;
(statearr_41623_41667[(1)] = (6));

} else {
var statearr_41624_41668 = state_41602__$1;
(statearr_41624_41668[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41603 === (23))){
var inst_41558 = (state_41602[(11)]);
var inst_41575 = (state_41602[(2)]);
var inst_41576 = fluree.db.util.async.throw_err(inst_41575);
var inst_41577 = (inst_41558 == null);
var state_41602__$1 = (function (){var statearr_41625 = state_41602;
(statearr_41625[(10)] = inst_41576);

return statearr_41625;
})();
if(cljs.core.truth_(inst_41577)){
var statearr_41626_41669 = state_41602__$1;
(statearr_41626_41669[(1)] = (24));

} else {
var statearr_41627_41670 = state_41602__$1;
(statearr_41627_41670[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41603 === (19))){
var inst_41592 = (state_41602[(2)]);
var state_41602__$1 = state_41602;
var statearr_41628_41671 = state_41602__$1;
(statearr_41628_41671[(2)] = inst_41592);

(statearr_41628_41671[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41603 === (11))){
var inst_41597 = (state_41602[(2)]);
var _ = (function (){var statearr_41630 = state_41602;
(statearr_41630[(4)] = cljs.core.rest((state_41602[(4)])));

return statearr_41630;
})();
var state_41602__$1 = state_41602;
var statearr_41631_41672 = state_41602__$1;
(statearr_41631_41672[(2)] = inst_41597);

(statearr_41631_41672[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41603 === (9))){
var inst_41531 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$block,block);
var inst_41532 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_41531);
var state_41602__$1 = state_41602;
var statearr_41632_41673 = state_41602__$1;
(statearr_41632_41673[(2)] = inst_41532);

(statearr_41632_41673[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41603 === (5))){
var _ = (function (){var statearr_41633 = state_41602;
(statearr_41633[(4)] = cljs.core.rest((state_41602[(4)])));

return statearr_41633;
})();
var state_41602__$1 = state_41602;
var ex41629 = (state_41602__$1[(2)]);
var statearr_41634_41674 = state_41602__$1;
(statearr_41634_41674[(5)] = ex41629);


var statearr_41635_41675 = state_41602__$1;
(statearr_41635_41675[(1)] = (4));

(statearr_41635_41675[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41603 === (14))){
var inst_41558 = (state_41602[(11)]);
var inst_41550 = (state_41602[(7)]);
var inst_41561 = inst_41558.t;
var inst_41562 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_41550,inst_41561);
var state_41602__$1 = state_41602;
var statearr_41636_41676 = state_41602__$1;
(statearr_41636_41676[(2)] = inst_41562);

(statearr_41636_41676[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41603 === (26))){
var inst_41587 = (state_41602[(2)]);
var state_41602__$1 = state_41602;
var statearr_41637_41677 = state_41602__$1;
(statearr_41637_41677[(2)] = inst_41587);

(statearr_41637_41677[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41603 === (16))){
var inst_41565 = (state_41602[(2)]);
var state_41602__$1 = state_41602;
if(cljs.core.truth_(inst_41565)){
var statearr_41638_41678 = state_41602__$1;
(statearr_41638_41678[(1)] = (17));

} else {
var statearr_41639_41679 = state_41602__$1;
(statearr_41639_41679[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41603 === (10))){
var inst_41534 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_41535 = cljs.core.first(inst_41534);
var inst_41543 = cljs.core.seq(inst_41534);
var inst_41544 = cljs.core.first(inst_41543);
var inst_41545 = cljs.core.next(inst_41543);
var inst_41546 = inst_41535.t;
var inst_41547 = cljs.core.PersistentVector.EMPTY;
var inst_41548 = db;
var inst_41549 = inst_41534;
var inst_41550 = inst_41546;
var inst_41551 = inst_41547;
var inst_41552 = inst_41548;
var state_41602__$1 = (function (){var statearr_41640 = state_41602;
(statearr_41640[(14)] = inst_41544);

(statearr_41640[(15)] = inst_41545);

(statearr_41640[(7)] = inst_41550);

(statearr_41640[(13)] = inst_41549);

(statearr_41640[(8)] = inst_41551);

(statearr_41640[(9)] = inst_41552);

return statearr_41640;
})();
var statearr_41641_41680 = state_41602__$1;
(statearr_41641_41680[(2)] = null);

(statearr_41641_41680[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41603 === (18))){
var state_41602__$1 = state_41602;
var statearr_41642_41681 = state_41602__$1;
(statearr_41642_41681[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_41603 === (8))){
var inst_41528 = (state_41602[(2)]);
var inst_41529 = cljs.core.empty_QMARK_(flakes);
var state_41602__$1 = (function (){var statearr_41644 = state_41602;
(statearr_41644[(16)] = inst_41528);

return statearr_41644;
})();
if(inst_41529){
var statearr_41645_41682 = state_41602__$1;
(statearr_41645_41682[(1)] = (9));

} else {
var statearr_41646_41683 = state_41602__$1;
(statearr_41646_41683[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__15091__auto__ = null;
var fluree$db$graphdb$state_machine__15091__auto____0 = (function (){
var statearr_41647 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41647[(0)] = fluree$db$graphdb$state_machine__15091__auto__);

(statearr_41647[(1)] = (1));

return statearr_41647;
});
var fluree$db$graphdb$state_machine__15091__auto____1 = (function (state_41602){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_41602);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e41648){var ex__15094__auto__ = e41648;
var statearr_41649_41684 = state_41602;
(statearr_41649_41684[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_41602[(4)]))){
var statearr_41650_41685 = state_41602;
(statearr_41650_41685[(1)] = cljs.core.first((state_41602[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__41686 = state_41602;
state_41602 = G__41686;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__15091__auto__ = function(state_41602){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__15091__auto____1.call(this,state_41602);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__15091__auto____0;
fluree$db$graphdb$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__15091__auto____1;
return fluree$db$graphdb$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_41651 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_41651[(6)] = c__15165__auto___41653);

return statearr_41651;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_41742){
var state_val_41743 = (state_41742[(1)]);
if((state_val_41743 === (7))){
var state_41742__$1 = state_41742;
var statearr_41744_41771 = state_41742__$1;
(statearr_41744_41771[(2)] = tt_id);

(statearr_41744_41771[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (1))){
var state_41742__$1 = state_41742;
var statearr_41745_41772 = state_41742__$1;
(statearr_41745_41772[(2)] = null);

(statearr_41745_41772[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (4))){
var inst_41687 = (state_41742[(2)]);
var state_41742__$1 = state_41742;
var statearr_41746_41773 = state_41742__$1;
(statearr_41746_41773[(2)] = inst_41687);

(statearr_41746_41773[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (13))){
var inst_41735 = (state_41742[(2)]);
var state_41742__$1 = state_41742;
var statearr_41747_41774 = state_41742__$1;
(statearr_41747_41774[(2)] = inst_41735);

(statearr_41747_41774[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (6))){
var inst_41695 = fluree.db.util.core.random_uuid();
var state_41742__$1 = state_41742;
var statearr_41748_41775 = state_41742__$1;
(statearr_41748_41775[(2)] = inst_41695);

(statearr_41748_41775[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (3))){
var inst_41740 = (state_41742[(2)]);
var state_41742__$1 = state_41742;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41742__$1,inst_41740);
} else {
if((state_val_41743 === (12))){
var inst_41718 = (state_41742[(7)]);
var state_41742__$1 = state_41742;
var statearr_41749_41776 = state_41742__$1;
(statearr_41749_41776[(2)] = inst_41718);

(statearr_41749_41776[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (2))){
var _ = (function (){var statearr_41750 = state_41742;
(statearr_41750[(4)] = cljs.core.cons((5),(state_41742[(4)])));

return statearr_41750;
})();
var inst_41693 = (tt_id == null);
var state_41742__$1 = state_41742;
if(cljs.core.truth_(inst_41693)){
var statearr_41751_41777 = state_41742__$1;
(statearr_41751_41777[(1)] = (6));

} else {
var statearr_41752_41778 = state_41742__$1;
(statearr_41752_41778[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (11))){
var inst_41725 = (state_41742[(8)]);
var inst_41718 = (state_41742[(7)]);
var inst_41728 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_41718,inst_41725);
var state_41742__$1 = state_41742;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41742__$1,(14),inst_41728);
} else {
if((state_val_41743 === (9))){
var inst_41725 = (state_41742[(8)]);
var inst_41719 = (state_41742[(9)]);
var inst_41724 = cljs.core.seq(inst_41719);
var inst_41725__$1 = cljs.core.first(inst_41724);
var inst_41726 = cljs.core.next(inst_41724);
var state_41742__$1 = (function (){var statearr_41754 = state_41742;
(statearr_41754[(8)] = inst_41725__$1);

(statearr_41754[(10)] = inst_41726);

return statearr_41754;
})();
if(cljs.core.truth_(inst_41725__$1)){
var statearr_41755_41779 = state_41742__$1;
(statearr_41755_41779[(1)] = (11));

} else {
var statearr_41756_41780 = state_41742__$1;
(statearr_41756_41780[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (5))){
var _ = (function (){var statearr_41757 = state_41742;
(statearr_41757[(4)] = cljs.core.rest((state_41742[(4)])));

return statearr_41757;
})();
var state_41742__$1 = state_41742;
var ex41753 = (state_41742__$1[(2)]);
var statearr_41758_41781 = state_41742__$1;
(statearr_41758_41781[(5)] = ex41753);


if((ex41753 instanceof Error)){
var statearr_41759_41782 = state_41742__$1;
(statearr_41759_41782[(1)] = (4));

(statearr_41759_41782[(5)] = null);

} else {
throw ex41753;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (14))){
var inst_41726 = (state_41742[(10)]);
var inst_41730 = (state_41742[(2)]);
var inst_41731 = fluree.db.util.async.throw_err(inst_41730);
var inst_41718 = inst_41731;
var inst_41719 = inst_41726;
var state_41742__$1 = (function (){var statearr_41760 = state_41742;
(statearr_41760[(7)] = inst_41718);

(statearr_41760[(9)] = inst_41719);

return statearr_41760;
})();
var statearr_41761_41783 = state_41742__$1;
(statearr_41761_41783[(2)] = null);

(statearr_41761_41783[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (10))){
var inst_41737 = (state_41742[(2)]);
var _ = (function (){var statearr_41762 = state_41742;
(statearr_41762[(4)] = cljs.core.rest((state_41742[(4)])));

return statearr_41762;
})();
var state_41742__$1 = state_41742;
var statearr_41763_41784 = state_41742__$1;
(statearr_41763_41784[(2)] = inst_41737);

(statearr_41763_41784[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (8))){
var inst_41698 = (state_41742[(2)]);
var inst_41699 = (function (){var tt_id_SINGLEQUOTE_ = inst_41698;
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),cljs.core.cst$kw$tt_DASH_id,tt_id_SINGLEQUOTE_));
});
})();
var inst_41700 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$tt_DASH_id,inst_41698);
var inst_41701 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41702 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst];
var inst_41703 = (new cljs.core.PersistentVector(null,4,(5),inst_41701,inst_41702,null));
var inst_41704 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_41699,inst_41700,inst_41703);
var inst_41705 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,flakes);
var inst_41706 = cljs.core.reverse(inst_41705);
var inst_41707 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,inst_41706);
var inst_41715 = cljs.core.seq(inst_41707);
var inst_41716 = cljs.core.first(inst_41715);
var inst_41717 = cljs.core.next(inst_41715);
var inst_41718 = inst_41704;
var inst_41719 = inst_41707;
var state_41742__$1 = (function (){var statearr_41764 = state_41742;
(statearr_41764[(7)] = inst_41718);

(statearr_41764[(11)] = inst_41717);

(statearr_41764[(9)] = inst_41719);

(statearr_41764[(12)] = inst_41716);

return statearr_41764;
})();
var statearr_41765_41785 = state_41742__$1;
(statearr_41765_41785[(2)] = null);

(statearr_41765_41785[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__15091__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__15091__auto____0 = (function (){
var statearr_41766 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41766[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__15091__auto__);

(statearr_41766[(1)] = (1));

return statearr_41766;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__15091__auto____1 = (function (state_41742){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_41742);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e41767){var ex__15094__auto__ = e41767;
var statearr_41768_41786 = state_41742;
(statearr_41768_41786[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_41742[(4)]))){
var statearr_41769_41787 = state_41742;
(statearr_41769_41787[(1)] = cljs.core.first((state_41742[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__41788 = state_41742;
state_41742 = G__41788;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__15091__auto__ = function(state_41742){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__15091__auto____1.call(this,state_41742);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__15091__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__15091__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_41770 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_41770[(6)] = c__15165__auto__);

return statearr_41770;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__15165__auto___41975 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_41906){
var state_val_41907 = (state_41906[(1)]);
if((state_val_41907 === (7))){
var inst_41816 = (state_41906[(7)]);
var inst_41816__$1 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_41906__$1 = (function (){var statearr_41908 = state_41906;
(statearr_41908[(7)] = inst_41816__$1);

return statearr_41908;
})();
if(inst_41816__$1){
var statearr_41909_41976 = state_41906__$1;
(statearr_41909_41976[(1)] = (13));

} else {
var statearr_41910_41977 = state_41906__$1;
(statearr_41910_41977[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (20))){
var state_41906__$1 = state_41906;
var statearr_41911_41978 = state_41906__$1;
(statearr_41911_41978[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (27))){
var inst_41852 = (state_41906[(8)]);
var inst_41856 = inst_41852.s;
var state_41906__$1 = state_41906;
var statearr_41913_41979 = state_41906__$1;
(statearr_41913_41979[(2)] = inst_41856);

(statearr_41913_41979[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (1))){
var state_41906__$1 = state_41906;
var statearr_41914_41980 = state_41906__$1;
(statearr_41914_41980[(2)] = null);

(statearr_41914_41980[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (24))){
var inst_41846 = (state_41906[(9)]);
var inst_41850 = cljs.core.first(inst_41846);
var state_41906__$1 = state_41906;
var statearr_41915_41981 = state_41906__$1;
(statearr_41915_41981[(2)] = inst_41850);

(statearr_41915_41981[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (39))){
var state_41906__$1 = state_41906;
var statearr_41916_41982 = state_41906__$1;
(statearr_41916_41982[(1)] = (41));



return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (4))){
var inst_41789 = (state_41906[(2)]);
var inst_41790 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_41791 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41792 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_41793 = cljs.core.PersistentHashMap.fromArrays(inst_41791,inst_41792);
var inst_41794 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_41790,inst_41793,inst_41789);
var inst_41795 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_41794);
var state_41906__$1 = state_41906;
var statearr_41918_41983 = state_41906__$1;
(statearr_41918_41983[(2)] = inst_41795);

(statearr_41918_41983[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (15))){
var inst_41823 = (state_41906[(2)]);
var state_41906__$1 = state_41906;
if(cljs.core.truth_(inst_41823)){
var statearr_41919_41984 = state_41906__$1;
(statearr_41919_41984[(1)] = (16));

} else {
var statearr_41920_41985 = state_41906__$1;
(statearr_41920_41985[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (21))){
var inst_41872 = (state_41906[(2)]);
var state_41906__$1 = state_41906;
var statearr_41921_41986 = state_41906__$1;
(statearr_41921_41986[(2)] = inst_41872);

(statearr_41921_41986[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (31))){
var inst_41870 = (state_41906[(2)]);
var state_41906__$1 = state_41906;
var statearr_41922_41987 = state_41906__$1;
(statearr_41922_41987[(2)] = inst_41870);

(statearr_41922_41987[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (32))){
var inst_41876 = (state_41906[(10)]);
var inst_41878 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_41876);
var state_41906__$1 = state_41906;
var statearr_41923_41988 = state_41906__$1;
(statearr_41923_41988[(2)] = inst_41878);

(statearr_41923_41988[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (40))){
var inst_41899 = (state_41906[(2)]);
var state_41906__$1 = state_41906;
var statearr_41924_41989 = state_41906__$1;
(statearr_41924_41989[(2)] = inst_41899);

(statearr_41924_41989[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (33))){
var inst_41880 = (state_41906[(11)]);
var inst_41876 = (state_41906[(10)]);
var inst_41880__$1 = (inst_41876 == null);
var state_41906__$1 = (function (){var statearr_41925 = state_41906;
(statearr_41925[(11)] = inst_41880__$1);

return statearr_41925;
})();
if(cljs.core.truth_(inst_41880__$1)){
var statearr_41926_41990 = state_41906__$1;
(statearr_41926_41990[(1)] = (35));

} else {
var statearr_41927_41991 = state_41906__$1;
(statearr_41927_41991[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (13))){
var inst_41818 = cljs.core.first(ident);
var inst_41819 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_41818);
var inst_41820 = (inst_41819 == null);
var state_41906__$1 = state_41906;
var statearr_41928_41992 = state_41906__$1;
(statearr_41928_41992[(2)] = inst_41820);

(statearr_41928_41992[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (22))){
var inst_41846 = (state_41906[(9)]);
var inst_41845 = (state_41906[(2)]);
var inst_41846__$1 = fluree.db.util.async.throw_err(inst_41845);
var inst_41847 = (inst_41846__$1 == null);
var state_41906__$1 = (function (){var statearr_41929 = state_41906;
(statearr_41929[(9)] = inst_41846__$1);

return statearr_41929;
})();
if(cljs.core.truth_(inst_41847)){
var statearr_41930_41993 = state_41906__$1;
(statearr_41930_41993[(1)] = (23));

} else {
var statearr_41931_41994 = state_41906__$1;
(statearr_41931_41994[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (36))){
var inst_41880 = (state_41906[(11)]);
var state_41906__$1 = state_41906;
var statearr_41932_41995 = state_41906__$1;
(statearr_41932_41995[(2)] = inst_41880);

(statearr_41932_41995[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (41))){
var inst_41894 = cljs.core.async.close_BANG_(return_chan);
var state_41906__$1 = state_41906;
var statearr_41933_41996 = state_41906__$1;
(statearr_41933_41996[(2)] = inst_41894);

(statearr_41933_41996[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (43))){
var inst_41897 = (state_41906[(2)]);
var state_41906__$1 = state_41906;
var statearr_41934_41997 = state_41906__$1;
(statearr_41934_41997[(2)] = inst_41897);

(statearr_41934_41997[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (29))){
var inst_41861 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_41862 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_41861].join('');
var inst_41863 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41864 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_41865 = cljs.core.PersistentHashMap.fromArrays(inst_41863,inst_41864);
var inst_41866 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41862,inst_41865);
var inst_41867 = (function(){throw inst_41866})();
var state_41906__$1 = state_41906;
var statearr_41935_41998 = state_41906__$1;
(statearr_41935_41998[(2)] = inst_41867);

(statearr_41935_41998[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (6))){
var inst_41803 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41804 = [ident];
var inst_41805 = (new cljs.core.PersistentVector(null,1,(5),inst_41803,inst_41804,null));
var inst_41806 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_41805);
var state_41906__$1 = state_41906;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41906__$1,(9),inst_41806);
} else {
if((state_val_41907 === (28))){
var inst_41858 = (state_41906[(2)]);
var state_41906__$1 = state_41906;
var statearr_41936_41999 = state_41906__$1;
(statearr_41936_41999[(2)] = inst_41858);

(statearr_41936_41999[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (25))){
var inst_41852 = (state_41906[(8)]);
var inst_41852__$1 = (state_41906[(2)]);
var inst_41853 = (inst_41852__$1 == null);
var state_41906__$1 = (function (){var statearr_41937 = state_41906;
(statearr_41937[(8)] = inst_41852__$1);

return statearr_41937;
})();
if(cljs.core.truth_(inst_41853)){
var statearr_41938_42000 = state_41906__$1;
(statearr_41938_42000[(1)] = (26));

} else {
var statearr_41939_42001 = state_41906__$1;
(statearr_41939_42001[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (34))){
var inst_41901 = (state_41906[(2)]);
var _ = (function (){var statearr_41940 = state_41906;
(statearr_41940[(4)] = cljs.core.rest((state_41906[(4)])));

return statearr_41940;
})();
var state_41906__$1 = state_41906;
var statearr_41941_42002 = state_41906__$1;
(statearr_41941_42002[(2)] = inst_41901);

(statearr_41941_42002[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (17))){
var inst_41834 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_41906__$1 = state_41906;
if(inst_41834){
var statearr_41942_42003 = state_41906__$1;
(statearr_41942_42003[(1)] = (19));

} else {
var statearr_41943_42004 = state_41906__$1;
(statearr_41943_42004[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (3))){
var inst_41904 = (state_41906[(2)]);
var state_41906__$1 = state_41906;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41906__$1,inst_41904);
} else {
if((state_val_41907 === (12))){
var inst_41814 = (state_41906[(2)]);
var state_41906__$1 = state_41906;
var statearr_41944_42005 = state_41906__$1;
(statearr_41944_42005[(2)] = inst_41814);

(statearr_41944_42005[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (2))){
var _ = (function (){var statearr_41945 = state_41906;
(statearr_41945[(4)] = cljs.core.cons((5),(state_41906[(4)])));

return statearr_41945;
})();
var inst_41801 = typeof ident === 'number';
var state_41906__$1 = state_41906;
if(cljs.core.truth_(inst_41801)){
var statearr_41946_42006 = state_41906__$1;
(statearr_41946_42006[(1)] = (6));

} else {
var statearr_41947_42007 = state_41906__$1;
(statearr_41947_42007[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (23))){
var state_41906__$1 = state_41906;
var statearr_41948_42008 = state_41906__$1;
(statearr_41948_42008[(2)] = null);

(statearr_41948_42008[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (35))){
var state_41906__$1 = state_41906;
var statearr_41949_42009 = state_41906__$1;
(statearr_41949_42009[(2)] = strict_QMARK_);

(statearr_41949_42009[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (19))){
var inst_41837 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41838 = cljs.core.first(ident);
var inst_41839 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_41838);
var inst_41840 = cljs.core.second(ident);
var inst_41841 = [inst_41839,inst_41840];
var inst_41842 = (new cljs.core.PersistentVector(null,2,(5),inst_41837,inst_41841,null));
var inst_41843 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_41842);
var state_41906__$1 = state_41906;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41906__$1,(22),inst_41843);
} else {
if((state_val_41907 === (11))){
var state_41906__$1 = state_41906;
var statearr_41951_42010 = state_41906__$1;
(statearr_41951_42010[(2)] = null);

(statearr_41951_42010[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (9))){
var inst_41808 = (state_41906[(2)]);
var inst_41809 = fluree.db.util.async.throw_err(inst_41808);
var inst_41810 = cljs.core.not_empty(inst_41809);
var state_41906__$1 = state_41906;
if(cljs.core.truth_(inst_41810)){
var statearr_41952_42011 = state_41906__$1;
(statearr_41952_42011[(1)] = (10));

} else {
var statearr_41953_42012 = state_41906__$1;
(statearr_41953_42012[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (5))){
var _ = (function (){var statearr_41954 = state_41906;
(statearr_41954[(4)] = cljs.core.rest((state_41906[(4)])));

return statearr_41954;
})();
var state_41906__$1 = state_41906;
var ex41950 = (state_41906__$1[(2)]);
var statearr_41955_42013 = state_41906__$1;
(statearr_41955_42013[(5)] = ex41950);


var statearr_41956_42014 = state_41906__$1;
(statearr_41956_42014[(1)] = (4));

(statearr_41956_42014[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (14))){
var inst_41816 = (state_41906[(7)]);
var state_41906__$1 = state_41906;
var statearr_41957_42015 = state_41906__$1;
(statearr_41957_42015[(2)] = inst_41816);

(statearr_41957_42015[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (26))){
var state_41906__$1 = state_41906;
var statearr_41958_42016 = state_41906__$1;
(statearr_41958_42016[(2)] = null);

(statearr_41958_42016[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (16))){
var inst_41825 = cljs.core.first(ident);
var inst_41826 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_41825], 0));
var inst_41827 = ["Subject ID lookup failed. The predicate ",inst_41826," does not exist."].join('');
var inst_41828 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41829 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_41830 = cljs.core.PersistentHashMap.fromArrays(inst_41828,inst_41829);
var inst_41831 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41827,inst_41830);
var inst_41832 = (function(){throw inst_41831})();
var state_41906__$1 = state_41906;
var statearr_41959_42017 = state_41906__$1;
(statearr_41959_42017[(2)] = inst_41832);

(statearr_41959_42017[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (38))){
var inst_41886 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_41887 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41888 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_41889 = cljs.core.PersistentHashMap.fromArrays(inst_41887,inst_41888);
var inst_41890 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41886,inst_41889);
var inst_41891 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_41890);
var state_41906__$1 = state_41906;
var statearr_41960_42018 = state_41906__$1;
(statearr_41960_42018[(2)] = inst_41891);

(statearr_41960_42018[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (30))){
var state_41906__$1 = state_41906;
var statearr_41961_42019 = state_41906__$1;
(statearr_41961_42019[(2)] = null);

(statearr_41961_42019[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (10))){
var state_41906__$1 = state_41906;
var statearr_41962_42020 = state_41906__$1;
(statearr_41962_42020[(2)] = ident);

(statearr_41962_42020[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (18))){
var inst_41874 = (state_41906[(2)]);
var state_41906__$1 = state_41906;
var statearr_41963_42021 = state_41906__$1;
(statearr_41963_42021[(2)] = inst_41874);

(statearr_41963_42021[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (42))){
var state_41906__$1 = state_41906;
var statearr_41964_42022 = state_41906__$1;
(statearr_41964_42022[(2)] = null);

(statearr_41964_42022[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (37))){
var inst_41884 = (state_41906[(2)]);
var state_41906__$1 = state_41906;
if(cljs.core.truth_(inst_41884)){
var statearr_41965_42023 = state_41906__$1;
(statearr_41965_42023[(1)] = (38));

} else {
var statearr_41966_42024 = state_41906__$1;
(statearr_41966_42024[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41907 === (8))){
var inst_41876 = (state_41906[(10)]);
var inst_41876__$1 = (state_41906[(2)]);
var state_41906__$1 = (function (){var statearr_41967 = state_41906;
(statearr_41967[(10)] = inst_41876__$1);

return statearr_41967;
})();
if(cljs.core.truth_(inst_41876__$1)){
var statearr_41968_42025 = state_41906__$1;
(statearr_41968_42025[(1)] = (32));

} else {
var statearr_41969_42026 = state_41906__$1;
(statearr_41969_42026[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__15091__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__15091__auto____0 = (function (){
var statearr_41970 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41970[(0)] = fluree$db$graphdb$subid_$_state_machine__15091__auto__);

(statearr_41970[(1)] = (1));

return statearr_41970;
});
var fluree$db$graphdb$subid_$_state_machine__15091__auto____1 = (function (state_41906){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_41906);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e41971){var ex__15094__auto__ = e41971;
var statearr_41972_42027 = state_41906;
(statearr_41972_42027[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_41906[(4)]))){
var statearr_41973_42028 = state_41906;
(statearr_41973_42028[(1)] = cljs.core.first((state_41906[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__42029 = state_41906;
state_41906 = G__42029;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__15091__auto__ = function(state_41906){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__15091__auto____1.call(this,state_41906);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__15091__auto____0;
fluree$db$graphdb$subid_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__15091__auto____1;
return fluree$db$graphdb$subid_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_41974 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_41974[(6)] = c__15165__auto___41975);

return statearr_41974;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__42030){
var map__42031 = p__42030;
var map__42031__$1 = cljs.core.__destructure_map(map__42031);
var db = map__42031__$1;
var current_db_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42031__$1,cljs.core.cst$kw$current_DASH_db_DASH_fn);
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42031__$1,cljs.core.cst$kw$permissions);
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_42047){
var state_val_42048 = (state_42047[(1)]);
if((state_val_42048 === (1))){
var state_42047__$1 = state_42047;
var statearr_42049_42063 = state_42047__$1;
(statearr_42049_42063[(2)] = null);

(statearr_42049_42063[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42048 === (2))){
var _ = (function (){var statearr_42050 = state_42047;
(statearr_42050[(4)] = cljs.core.cons((5),(state_42047[(4)])));

return statearr_42050;
})();
var inst_42038 = (current_db_fn.cljs$core$IFn$_invoke$arity$1 ? current_db_fn.cljs$core$IFn$_invoke$arity$1(db) : current_db_fn.call(null,db));
var state_42047__$1 = state_42047;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42047__$1,(6),inst_42038);
} else {
if((state_val_42048 === (3))){
var inst_42045 = (state_42047[(2)]);
var state_42047__$1 = state_42047;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42047__$1,inst_42045);
} else {
if((state_val_42048 === (4))){
var inst_42032 = (state_42047[(2)]);
var state_42047__$1 = state_42047;
var statearr_42052_42064 = state_42047__$1;
(statearr_42052_42064[(2)] = inst_42032);

(statearr_42052_42064[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42048 === (5))){
var _ = (function (){var statearr_42053 = state_42047;
(statearr_42053[(4)] = cljs.core.rest((state_42047[(4)])));

return statearr_42053;
})();
var state_42047__$1 = state_42047;
var ex42051 = (state_42047__$1[(2)]);
var statearr_42054_42065 = state_42047__$1;
(statearr_42054_42065[(5)] = ex42051);


if((ex42051 instanceof Error)){
var statearr_42055_42066 = state_42047__$1;
(statearr_42055_42066[(1)] = (4));

(statearr_42055_42066[(5)] = null);

} else {
throw ex42051;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42048 === (6))){
var inst_42040 = (state_42047[(2)]);
var inst_42041 = fluree.db.util.async.throw_err(inst_42040);
var inst_42042 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_42041,cljs.core.cst$kw$permissions,permissions);
var _ = (function (){var statearr_42056 = state_42047;
(statearr_42056[(4)] = cljs.core.rest((state_42047[(4)])));

return statearr_42056;
})();
var state_42047__$1 = state_42047;
var statearr_42057_42067 = state_42047__$1;
(statearr_42057_42067[(2)] = inst_42042);

(statearr_42057_42067[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__15091__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__15091__auto____0 = (function (){
var statearr_42058 = [null,null,null,null,null,null,null];
(statearr_42058[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__15091__auto__);

(statearr_42058[(1)] = (1));

return statearr_42058;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__15091__auto____1 = (function (state_42047){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_42047);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e42059){var ex__15094__auto__ = e42059;
var statearr_42060_42068 = state_42047;
(statearr_42060_42068[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_42047[(4)]))){
var statearr_42061_42069 = state_42047;
(statearr_42061_42069[(1)] = cljs.core.first((state_42047[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__42070 = state_42047;
state_42047 = G__42070;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__15091__auto__ = function(state_42047){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__15091__auto____1.call(this,state_42047);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__15091__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__15091__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_42062 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_42062[(6)] = c__15165__auto__);

return statearr_42062;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$,cljs.core.cst$kw$permissions,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$root_QMARK_,true,cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__42071,property,collection){
var map__42072 = p__42071;
var map__42072__$1 = cljs.core.__destructure_map(map__42072);
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42072__$1,cljs.core.cst$kw$schema);
if(cljs.core.truth_((function (){var fexpr__42073 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$name,null,cljs.core.cst$kw$partition,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$specDoc,null,cljs.core.cst$kw$sid,null], null), null);
return (fexpr__42073.cljs$core$IFn$_invoke$arity$1 ? fexpr__42073.cljs$core$IFn$_invoke$arity$1(property) : fexpr__42073.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__42074,property,predicate){
var map__42075 = p__42074;
var map__42075__$1 = cljs.core.__destructure_map(map__42075);
var this$ = map__42075__$1;
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42075__$1,cljs.core.cst$kw$schema);
if(cljs.core.truth_((function (){var fexpr__42076 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [cljs.core.cst$kw$unique,null,cljs.core.cst$kw$restrictCollection,null,cljs.core.cst$kw$index,null,cljs.core.cst$kw$name,null,cljs.core.cst$kw$noHistory,null,cljs.core.cst$kw$type,null,cljs.core.cst$kw$txSpec,null,cljs.core.cst$kw$component,null,cljs.core.cst$kw$txSpecDoc,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$multi,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$specDoc,null,cljs.core.cst$kw$idx_QMARK_,null,cljs.core.cst$kw$ref_QMARK_,null,cljs.core.cst$kw$upsert,null,cljs.core.cst$kw$retractDuplicates,null,cljs.core.cst$kw$restrictTag,null], null), null);
return (fexpr__42076.cljs$core$IFn$_invoke$arity$1 ? fexpr__42076.cljs$core$IFn$_invoke$arity$1(property) : fexpr__42076.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__42077 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pred,predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$restrictCollection,property)){
return fluree.db.dbproto._c_prop(this$,cljs.core.cst$kw$partition,G__42077);
} else {
return G__42077;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return cljs.core.cst$kw$fluree$db$graphdb_SLASH_no_DASH_pred;
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop(this$,cljs.core.cst$kw$name,pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__42079 = arguments.length;
switch (G__42079) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_42111){
var state_val_42112 = (state_42111[(1)]);
if((state_val_42112 === (7))){
var state_42111__$1 = state_42111;
var statearr_42113_42207 = state_42111__$1;
(statearr_42113_42207[(2)] = null);

(statearr_42113_42207[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42112 === (1))){
var state_42111__$1 = state_42111;
var statearr_42114_42208 = state_42111__$1;
(statearr_42114_42208[(2)] = null);

(statearr_42114_42208[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42112 === (4))){
var inst_42080 = (state_42111[(2)]);
var state_42111__$1 = state_42111;
var statearr_42115_42209 = state_42111__$1;
(statearr_42115_42209[(2)] = inst_42080);

(statearr_42115_42209[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42112 === (6))){
var inst_42094 = (state_42111[(7)]);
var inst_42093 = (state_42111[(2)]);
var inst_42094__$1 = fluree.db.util.async.throw_err(inst_42093);
var inst_42095 = (inst_42094__$1 == null);
var state_42111__$1 = (function (){var statearr_42116 = state_42111;
(statearr_42116[(7)] = inst_42094__$1);

return statearr_42116;
})();
if(cljs.core.truth_(inst_42095)){
var statearr_42117_42210 = state_42111__$1;
(statearr_42117_42210[(1)] = (7));

} else {
var statearr_42118_42211 = state_42111__$1;
(statearr_42118_42211[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42112 === (3))){
var inst_42109 = (state_42111[(2)]);
var state_42111__$1 = state_42111;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42111__$1,inst_42109);
} else {
if((state_val_42112 === (12))){
var inst_42106 = (state_42111[(2)]);
var _ = (function (){var statearr_42119 = state_42111;
(statearr_42119[(4)] = cljs.core.rest((state_42111[(4)])));

return statearr_42119;
})();
var state_42111__$1 = state_42111;
var statearr_42120_42212 = state_42111__$1;
(statearr_42120_42212[(2)] = inst_42106);

(statearr_42120_42212[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42112 === (2))){
var _ = (function (){var statearr_42121 = state_42111;
(statearr_42121[(4)] = cljs.core.cons((5),(state_42111[(4)])));

return statearr_42121;
})();
var inst_42087 = fluree.db.dbproto._rootdb(this$);
var inst_42088 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42089 = [tag_id,(30)];
var inst_42090 = (new cljs.core.PersistentVector(null,2,(5),inst_42088,inst_42089,null));
var inst_42091 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_42087,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_42090);
var state_42111__$1 = state_42111;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42111__$1,(6),inst_42091);
} else {
if((state_val_42112 === (11))){
var inst_42100 = (state_42111[(8)]);
var inst_42104 = inst_42100.o;
var state_42111__$1 = state_42111;
var statearr_42123_42213 = state_42111__$1;
(statearr_42123_42213[(2)] = inst_42104);

(statearr_42123_42213[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42112 === (9))){
var inst_42100 = (state_42111[(8)]);
var inst_42100__$1 = (state_42111[(2)]);
var inst_42101 = (inst_42100__$1 == null);
var state_42111__$1 = (function (){var statearr_42124 = state_42111;
(statearr_42124[(8)] = inst_42100__$1);

return statearr_42124;
})();
if(cljs.core.truth_(inst_42101)){
var statearr_42125_42214 = state_42111__$1;
(statearr_42125_42214[(1)] = (10));

} else {
var statearr_42126_42215 = state_42111__$1;
(statearr_42126_42215[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42112 === (5))){
var _ = (function (){var statearr_42127 = state_42111;
(statearr_42127[(4)] = cljs.core.rest((state_42111[(4)])));

return statearr_42127;
})();
var state_42111__$1 = state_42111;
var ex42122 = (state_42111__$1[(2)]);
var statearr_42128_42216 = state_42111__$1;
(statearr_42128_42216[(5)] = ex42122);


if((ex42122 instanceof Error)){
var statearr_42129_42217 = state_42111__$1;
(statearr_42129_42217[(1)] = (4));

(statearr_42129_42217[(5)] = null);

} else {
throw ex42122;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42112 === (10))){
var state_42111__$1 = state_42111;
var statearr_42130_42218 = state_42111__$1;
(statearr_42130_42218[(2)] = null);

(statearr_42130_42218[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42112 === (8))){
var inst_42094 = (state_42111[(7)]);
var inst_42098 = cljs.core.first(inst_42094);
var state_42111__$1 = state_42111;
var statearr_42131_42219 = state_42111__$1;
(statearr_42131_42219[(2)] = inst_42098);

(statearr_42131_42219[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__15091__auto__ = null;
var fluree$db$graphdb$state_machine__15091__auto____0 = (function (){
var statearr_42132 = [null,null,null,null,null,null,null,null,null];
(statearr_42132[(0)] = fluree$db$graphdb$state_machine__15091__auto__);

(statearr_42132[(1)] = (1));

return statearr_42132;
});
var fluree$db$graphdb$state_machine__15091__auto____1 = (function (state_42111){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_42111);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e42133){var ex__15094__auto__ = e42133;
var statearr_42134_42220 = state_42111;
(statearr_42134_42220[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_42111[(4)]))){
var statearr_42135_42221 = state_42111;
(statearr_42135_42221[(1)] = cljs.core.first((state_42111[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__42222 = state_42111;
state_42111 = G__42222;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__15091__auto__ = function(state_42111){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__15091__auto____1.call(this,state_42111);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__15091__auto____0;
fluree$db$graphdb$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__15091__auto____1;
return fluree$db$graphdb$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_42136 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_42136[(6)] = c__15165__auto__);

return statearr_42136;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_42172){
var state_val_42173 = (state_42172[(1)]);
if((state_val_42173 === (7))){
var inst_42146 = fluree.db.dbproto._p_prop(this$,cljs.core.cst$kw$name,pred);
var state_42172__$1 = state_42172;
var statearr_42174_42223 = state_42172__$1;
(statearr_42174_42223[(2)] = inst_42146);

(statearr_42174_42223[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42173 === (1))){
var state_42172__$1 = state_42172;
var statearr_42175_42224 = state_42172__$1;
(statearr_42175_42224[(2)] = null);

(statearr_42175_42224[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42173 === (4))){
var inst_42137 = (state_42172[(2)]);
var state_42172__$1 = state_42172;
var statearr_42176_42225 = state_42172__$1;
(statearr_42176_42225[(2)] = inst_42137);

(statearr_42176_42225[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42173 === (15))){
var inst_42167 = (state_42172[(2)]);
var _ = (function (){var statearr_42177 = state_42172;
(statearr_42177[(4)] = cljs.core.rest((state_42172[(4)])));

return statearr_42177;
})();
var state_42172__$1 = state_42172;
var statearr_42178_42226 = state_42172__$1;
(statearr_42178_42226[(2)] = inst_42167);

(statearr_42178_42226[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42173 === (13))){
var inst_42152 = (state_42172[(7)]);
var inst_42158 = clojure.string.includes_QMARK_(inst_42152,":");
var state_42172__$1 = state_42172;
if(inst_42158){
var statearr_42179_42227 = state_42172__$1;
(statearr_42179_42227[(1)] = (16));

} else {
var statearr_42180_42228 = state_42172__$1;
(statearr_42180_42228[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42173 === (6))){
var state_42172__$1 = state_42172;
var statearr_42181_42229 = state_42172__$1;
(statearr_42181_42229[(2)] = pred);

(statearr_42181_42229[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42173 === (17))){
var inst_42152 = (state_42172[(7)]);
var state_42172__$1 = state_42172;
var statearr_42182_42230 = state_42172__$1;
(statearr_42182_42230[(2)] = inst_42152);

(statearr_42182_42230[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42173 === (3))){
var inst_42170 = (state_42172[(2)]);
var state_42172__$1 = state_42172;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42172__$1,inst_42170);
} else {
if((state_val_42173 === (12))){
var inst_42156 = (state_42172[(2)]);
var state_42172__$1 = state_42172;
if(cljs.core.truth_(inst_42156)){
var statearr_42183_42231 = state_42172__$1;
(statearr_42183_42231[(1)] = (13));

} else {
var statearr_42184_42232 = state_42172__$1;
(statearr_42184_42232[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42173 === (2))){
var _ = (function (){var statearr_42185 = state_42172;
(statearr_42185[(4)] = cljs.core.cons((5),(state_42172[(4)])));

return statearr_42185;
})();
var inst_42143 = typeof pred === 'string';
var state_42172__$1 = state_42172;
if(cljs.core.truth_(inst_42143)){
var statearr_42186_42233 = state_42172__$1;
(statearr_42186_42233[(1)] = (6));

} else {
var statearr_42187_42234 = state_42172__$1;
(statearr_42187_42234[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42173 === (11))){
var inst_42148 = (state_42172[(8)]);
var state_42172__$1 = state_42172;
var statearr_42189_42235 = state_42172__$1;
(statearr_42189_42235[(2)] = inst_42148);

(statearr_42189_42235[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42173 === (9))){
var inst_42148 = (state_42172[(8)]);
var inst_42151 = (state_42172[(2)]);
var inst_42152 = fluree.db.util.async.throw_err(inst_42151);
var state_42172__$1 = (function (){var statearr_42190 = state_42172;
(statearr_42190[(7)] = inst_42152);

return statearr_42190;
})();
if(cljs.core.truth_(inst_42148)){
var statearr_42191_42236 = state_42172__$1;
(statearr_42191_42236[(1)] = (10));

} else {
var statearr_42192_42237 = state_42172__$1;
(statearr_42192_42237[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42173 === (5))){
var _ = (function (){var statearr_42193 = state_42172;
(statearr_42193[(4)] = cljs.core.rest((state_42172[(4)])));

return statearr_42193;
})();
var state_42172__$1 = state_42172;
var ex42188 = (state_42172__$1[(2)]);
var statearr_42194_42238 = state_42172__$1;
(statearr_42194_42238[(5)] = ex42188);


if((ex42188 instanceof Error)){
var statearr_42195_42239 = state_42172__$1;
(statearr_42195_42239[(1)] = (4));

(statearr_42195_42239[(5)] = null);

} else {
throw ex42188;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42173 === (14))){
var state_42172__$1 = state_42172;
var statearr_42196_42240 = state_42172__$1;
(statearr_42196_42240[(2)] = null);

(statearr_42196_42240[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42173 === (16))){
var inst_42152 = (state_42172[(7)]);
var inst_42160 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_42152,/:/);
var inst_42161 = cljs.core.second(inst_42160);
var state_42172__$1 = state_42172;
var statearr_42197_42241 = state_42172__$1;
(statearr_42197_42241[(2)] = inst_42161);

(statearr_42197_42241[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42173 === (10))){
var inst_42152 = (state_42172[(7)]);
var state_42172__$1 = state_42172;
var statearr_42198_42242 = state_42172__$1;
(statearr_42198_42242[(2)] = inst_42152);

(statearr_42198_42242[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42173 === (18))){
var inst_42164 = (state_42172[(2)]);
var state_42172__$1 = state_42172;
var statearr_42199_42243 = state_42172__$1;
(statearr_42199_42243[(2)] = inst_42164);

(statearr_42199_42243[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42173 === (8))){
var inst_42148 = (state_42172[(2)]);
var inst_42149 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2(this$,tag_id);
var state_42172__$1 = (function (){var statearr_42200 = state_42172;
(statearr_42200[(8)] = inst_42148);

return statearr_42200;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42172__$1,(9),inst_42149);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__15091__auto__ = null;
var fluree$db$graphdb$state_machine__15091__auto____0 = (function (){
var statearr_42201 = [null,null,null,null,null,null,null,null,null];
(statearr_42201[(0)] = fluree$db$graphdb$state_machine__15091__auto__);

(statearr_42201[(1)] = (1));

return statearr_42201;
});
var fluree$db$graphdb$state_machine__15091__auto____1 = (function (state_42172){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_42172);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e42202){var ex__15094__auto__ = e42202;
var statearr_42203_42244 = state_42172;
(statearr_42203_42244[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_42172[(4)]))){
var statearr_42204_42245 = state_42172;
(statearr_42204_42245[(1)] = cljs.core.first((state_42172[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__42246 = state_42172;
state_42172 = G__42246;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__15091__auto__ = function(state_42172){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__15091__auto____1.call(this,state_42172);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__15091__auto____0;
fluree$db$graphdb$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__15091__auto____1;
return fluree$db$graphdb$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_42205 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_42205[(6)] = c__15165__auto__);

return statearr_42205;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__42248 = arguments.length;
switch (G__42248) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_42281){
var state_val_42282 = (state_42281[(1)]);
if((state_val_42282 === (7))){
var state_42281__$1 = state_42281;
var statearr_42283_42371 = state_42281__$1;
(statearr_42283_42371[(2)] = null);

(statearr_42283_42371[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42282 === (1))){
var state_42281__$1 = state_42281;
var statearr_42284_42372 = state_42281__$1;
(statearr_42284_42372[(2)] = null);

(statearr_42284_42372[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42282 === (4))){
var inst_42249 = (state_42281[(2)]);
var state_42281__$1 = state_42281;
var statearr_42285_42373 = state_42281__$1;
(statearr_42285_42373[(2)] = inst_42249);

(statearr_42285_42373[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42282 === (6))){
var inst_42264 = (state_42281[(7)]);
var inst_42263 = (state_42281[(2)]);
var inst_42264__$1 = fluree.db.util.async.throw_err(inst_42263);
var inst_42265 = (inst_42264__$1 == null);
var state_42281__$1 = (function (){var statearr_42286 = state_42281;
(statearr_42286[(7)] = inst_42264__$1);

return statearr_42286;
})();
if(cljs.core.truth_(inst_42265)){
var statearr_42287_42374 = state_42281__$1;
(statearr_42287_42374[(1)] = (7));

} else {
var statearr_42288_42375 = state_42281__$1;
(statearr_42288_42375[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42282 === (3))){
var inst_42279 = (state_42281[(2)]);
var state_42281__$1 = state_42281;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42281__$1,inst_42279);
} else {
if((state_val_42282 === (12))){
var inst_42276 = (state_42281[(2)]);
var _ = (function (){var statearr_42289 = state_42281;
(statearr_42289[(4)] = cljs.core.rest((state_42281[(4)])));

return statearr_42289;
})();
var state_42281__$1 = state_42281;
var statearr_42290_42376 = state_42281__$1;
(statearr_42290_42376[(2)] = inst_42276);

(statearr_42290_42376[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42282 === (2))){
var _ = (function (){var statearr_42291 = state_42281;
(statearr_42291[(4)] = cljs.core.cons((5),(state_42281[(4)])));

return statearr_42291;
})();
var inst_42255 = (30);
var inst_42257 = fluree.db.dbproto._rootdb(this$);
var inst_42258 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42259 = [inst_42255,tag_name];
var inst_42260 = (new cljs.core.PersistentVector(null,2,(5),inst_42258,inst_42259,null));
var inst_42261 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_42257,cljs.core.cst$kw$post,cljs.core._EQ_,inst_42260);
var state_42281__$1 = state_42281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42281__$1,(6),inst_42261);
} else {
if((state_val_42282 === (11))){
var inst_42270 = (state_42281[(8)]);
var inst_42274 = inst_42270.s;
var state_42281__$1 = state_42281;
var statearr_42293_42377 = state_42281__$1;
(statearr_42293_42377[(2)] = inst_42274);

(statearr_42293_42377[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42282 === (9))){
var inst_42270 = (state_42281[(8)]);
var inst_42270__$1 = (state_42281[(2)]);
var inst_42271 = (inst_42270__$1 == null);
var state_42281__$1 = (function (){var statearr_42294 = state_42281;
(statearr_42294[(8)] = inst_42270__$1);

return statearr_42294;
})();
if(cljs.core.truth_(inst_42271)){
var statearr_42295_42378 = state_42281__$1;
(statearr_42295_42378[(1)] = (10));

} else {
var statearr_42296_42379 = state_42281__$1;
(statearr_42296_42379[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42282 === (5))){
var _ = (function (){var statearr_42297 = state_42281;
(statearr_42297[(4)] = cljs.core.rest((state_42281[(4)])));

return statearr_42297;
})();
var state_42281__$1 = state_42281;
var ex42292 = (state_42281__$1[(2)]);
var statearr_42298_42380 = state_42281__$1;
(statearr_42298_42380[(5)] = ex42292);


if((ex42292 instanceof Error)){
var statearr_42299_42381 = state_42281__$1;
(statearr_42299_42381[(1)] = (4));

(statearr_42299_42381[(5)] = null);

} else {
throw ex42292;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42282 === (10))){
var state_42281__$1 = state_42281;
var statearr_42300_42382 = state_42281__$1;
(statearr_42300_42382[(2)] = null);

(statearr_42300_42382[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42282 === (8))){
var inst_42264 = (state_42281[(7)]);
var inst_42268 = cljs.core.first(inst_42264);
var state_42281__$1 = state_42281;
var statearr_42301_42383 = state_42281__$1;
(statearr_42301_42383[(2)] = inst_42268);

(statearr_42301_42383[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__15091__auto__ = null;
var fluree$db$graphdb$state_machine__15091__auto____0 = (function (){
var statearr_42302 = [null,null,null,null,null,null,null,null,null];
(statearr_42302[(0)] = fluree$db$graphdb$state_machine__15091__auto__);

(statearr_42302[(1)] = (1));

return statearr_42302;
});
var fluree$db$graphdb$state_machine__15091__auto____1 = (function (state_42281){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_42281);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e42303){var ex__15094__auto__ = e42303;
var statearr_42304_42384 = state_42281;
(statearr_42304_42384[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_42281[(4)]))){
var statearr_42305_42385 = state_42281;
(statearr_42305_42385[(1)] = cljs.core.first((state_42281[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__42386 = state_42281;
state_42281 = G__42386;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__15091__auto__ = function(state_42281){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__15091__auto____1.call(this,state_42281);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__15091__auto____0;
fluree$db$graphdb$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__15091__auto____1;
return fluree$db$graphdb$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_42306 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_42306[(6)] = c__15165__auto__);

return statearr_42306;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_42341){
var state_val_42342 = (state_42341[(1)]);
if((state_val_42342 === (7))){
var inst_42320 = typeof pred === 'string';
var state_42341__$1 = state_42341;
if(cljs.core.truth_(inst_42320)){
var statearr_42343_42387 = state_42341__$1;
(statearr_42343_42387[(1)] = (10));

} else {
var statearr_42344_42388 = state_42341__$1;
(statearr_42344_42388[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42342 === (1))){
var state_42341__$1 = state_42341;
var statearr_42345_42389 = state_42341__$1;
(statearr_42345_42389[(2)] = null);

(statearr_42345_42389[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42342 === (4))){
var inst_42307 = (state_42341[(2)]);
var state_42341__$1 = state_42341;
var statearr_42346_42390 = state_42341__$1;
(statearr_42346_42390[(2)] = inst_42307);

(statearr_42346_42390[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42342 === (15))){
var inst_42334 = (state_42341[(2)]);
var state_42341__$1 = state_42341;
var statearr_42347_42391 = state_42341__$1;
(statearr_42347_42391[(2)] = inst_42334);

(statearr_42347_42391[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42342 === (13))){
var inst_42325 = (state_42341[(7)]);
var inst_42327 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42325),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_42328 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,inst_42327);
var state_42341__$1 = state_42341;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42341__$1,(16),inst_42328);
} else {
if((state_val_42342 === (6))){
var inst_42315 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,tag_name);
var state_42341__$1 = state_42341;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42341__$1,(9),inst_42315);
} else {
if((state_val_42342 === (3))){
var inst_42339 = (state_42341[(2)]);
var state_42341__$1 = state_42341;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42341__$1,inst_42339);
} else {
if((state_val_42342 === (12))){
var inst_42325 = (state_42341[(7)]);
var inst_42325__$1 = (state_42341[(2)]);
var state_42341__$1 = (function (){var statearr_42348 = state_42341;
(statearr_42348[(7)] = inst_42325__$1);

return statearr_42348;
})();
if(cljs.core.truth_(inst_42325__$1)){
var statearr_42349_42392 = state_42341__$1;
(statearr_42349_42392[(1)] = (13));

} else {
var statearr_42350_42393 = state_42341__$1;
(statearr_42350_42393[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42342 === (2))){
var _ = (function (){var statearr_42351 = state_42341;
(statearr_42351[(4)] = cljs.core.cons((5),(state_42341[(4)])));

return statearr_42351;
})();
var inst_42313 = clojure.string.includes_QMARK_(tag_name,"/");
var state_42341__$1 = state_42341;
if(inst_42313){
var statearr_42352_42394 = state_42341__$1;
(statearr_42352_42394[(1)] = (6));

} else {
var statearr_42353_42395 = state_42341__$1;
(statearr_42353_42395[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42342 === (11))){
var inst_42323 = fluree.db.dbproto._p_prop(this$,cljs.core.cst$kw$name,pred);
var state_42341__$1 = state_42341;
var statearr_42355_42396 = state_42341__$1;
(statearr_42355_42396[(2)] = inst_42323);

(statearr_42355_42396[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42342 === (9))){
var inst_42317 = (state_42341[(2)]);
var inst_42318 = fluree.db.util.async.throw_err(inst_42317);
var state_42341__$1 = state_42341;
var statearr_42356_42397 = state_42341__$1;
(statearr_42356_42397[(2)] = inst_42318);

(statearr_42356_42397[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42342 === (5))){
var _ = (function (){var statearr_42357 = state_42341;
(statearr_42357[(4)] = cljs.core.rest((state_42341[(4)])));

return statearr_42357;
})();
var state_42341__$1 = state_42341;
var ex42354 = (state_42341__$1[(2)]);
var statearr_42358_42398 = state_42341__$1;
(statearr_42358_42398[(5)] = ex42354);


if((ex42354 instanceof Error)){
var statearr_42359_42399 = state_42341__$1;
(statearr_42359_42399[(1)] = (4));

(statearr_42359_42399[(5)] = null);

} else {
throw ex42354;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42342 === (14))){
var state_42341__$1 = state_42341;
var statearr_42360_42400 = state_42341__$1;
(statearr_42360_42400[(2)] = null);

(statearr_42360_42400[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42342 === (16))){
var inst_42330 = (state_42341[(2)]);
var inst_42331 = fluree.db.util.async.throw_err(inst_42330);
var state_42341__$1 = state_42341;
var statearr_42361_42401 = state_42341__$1;
(statearr_42361_42401[(2)] = inst_42331);

(statearr_42361_42401[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42342 === (10))){
var state_42341__$1 = state_42341;
var statearr_42362_42402 = state_42341__$1;
(statearr_42362_42402[(2)] = pred);

(statearr_42362_42402[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42342 === (8))){
var inst_42336 = (state_42341[(2)]);
var _ = (function (){var statearr_42363 = state_42341;
(statearr_42363[(4)] = cljs.core.rest((state_42341[(4)])));

return statearr_42363;
})();
var state_42341__$1 = state_42341;
var statearr_42364_42403 = state_42341__$1;
(statearr_42364_42403[(2)] = inst_42336);

(statearr_42364_42403[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__15091__auto__ = null;
var fluree$db$graphdb$state_machine__15091__auto____0 = (function (){
var statearr_42365 = [null,null,null,null,null,null,null,null];
(statearr_42365[(0)] = fluree$db$graphdb$state_machine__15091__auto__);

(statearr_42365[(1)] = (1));

return statearr_42365;
});
var fluree$db$graphdb$state_machine__15091__auto____1 = (function (state_42341){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_42341);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e42366){var ex__15094__auto__ = e42366;
var statearr_42367_42404 = state_42341;
(statearr_42367_42404[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_42341[(4)]))){
var statearr_42368_42405 = state_42341;
(statearr_42368_42405[(1)] = cljs.core.first((state_42341[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__42406 = state_42341;
state_42341 = G__42406;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__15091__auto__ = function(state_42341){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__15091__auto____1.call(this,state_42341);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__15091__auto____0;
fluree$db$graphdb$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__15091__auto____1;
return fluree$db$graphdb$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_42369 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_42369[(6)] = c__15165__auto__);

return statearr_42369;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5342__auto__,k__5343__auto__){
var self__ = this;
var this__5342__auto____$1 = this;
return this__5342__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5343__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5344__auto__,k42408,else__5345__auto__){
var self__ = this;
var this__5344__auto____$1 = this;
var G__42412 = k42408;
var G__42412__$1 = (((G__42412 instanceof cljs.core.Keyword))?G__42412.fqn:null);
switch (G__42412__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k42408,else__5345__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5362__auto__,f__5363__auto__,init__5364__auto__){
var self__ = this;
var this__5362__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5365__auto__,p__42413){
var vec__42414 = p__42413;
var k__5366__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42414,(0),null);
var v__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42414,(1),null);
return (f__5363__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5363__auto__.cljs$core$IFn$_invoke$arity$3(ret__5365__auto__,k__5366__auto__,v__5367__auto__) : f__5363__auto__.call(null,ret__5365__auto__,k__5366__auto__,v__5367__auto__));
}),init__5364__auto__,this__5362__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5357__auto__,writer__5358__auto__,opts__5359__auto__){
var self__ = this;
var this__5357__auto____$1 = this;
var pr_pair__5360__auto__ = (function (keyval__5361__auto__){
return cljs.core.pr_sequential_writer(writer__5358__auto__,cljs.core.pr_writer,""," ","",opts__5359__auto__,keyval__5361__auto__);
});
return cljs.core.pr_sequential_writer(writer__5358__auto__,pr_pair__5360__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__5359__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$stats,self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$spot,self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$psot,self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$post,self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$opst,self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema,self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$settings,self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_configs,self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$novelty,self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$permissions,self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork,self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork_DASH_block,self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__42407){
var self__ = this;
var G__42407__$1 = this;
return (new cljs.core.RecordIter((0),G__42407__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5340__auto__){
var self__ = this;
var this__5340__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5337__auto__){
var self__ = this;
var this__5337__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5346__auto__){
var self__ = this;
var this__5346__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__42417 = (function (coll__5339__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__5339__auto__));
});
return fexpr__42417(this__5338__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this42409,other42410){
var self__ = this;
var this42409__$1 = this;
return (((!((other42410 == null)))) && ((((this42409__$1.constructor === other42410.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42409__$1.conn,other42410.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42409__$1.network,other42410.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42409__$1.dbid,other42410.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42409__$1.block,other42410.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42409__$1.t,other42410.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42409__$1.tt_id,other42410.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42409__$1.stats,other42410.stats)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42409__$1.spot,other42410.spot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42409__$1.psot,other42410.psot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42409__$1.post,other42410.post)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42409__$1.opst,other42410.opst)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42409__$1.schema,other42410.schema)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42409__$1.settings,other42410.settings)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42409__$1.index_configs,other42410.index_configs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42409__$1.schema_cache,other42410.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42409__$1.novelty,other42410.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42409__$1.permissions,other42410.permissions)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42409__$1.fork,other42410.fork)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42409__$1.fork_block,other42410.fork_block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42409__$1.current_db_fn,other42410.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42409__$1.__extmap,other42410.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5352__auto__,k__5353__auto__){
var self__ = this;
var this__5352__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [cljs.core.cst$kw$current_DASH_db_DASH_fn,null,cljs.core.cst$kw$schema,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$psot,null,cljs.core.cst$kw$permissions,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$settings,null,cljs.core.cst$kw$index_DASH_configs,null,cljs.core.cst$kw$opst,null,cljs.core.cst$kw$fork_DASH_block,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$post,null,cljs.core.cst$kw$novelty,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$fork,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$stats,null,cljs.core.cst$kw$spot,null,cljs.core.cst$kw$conn,null], null), null),k__5353__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5352__auto____$1),self__.__meta),k__5353__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5353__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5349__auto__,k42408){
var self__ = this;
var this__5349__auto____$1 = this;
var G__42418 = k42408;
var G__42418__$1 = (((G__42418 instanceof cljs.core.Keyword))?G__42418.fqn:null);
switch (G__42418__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k42408);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5350__auto__,k__5351__auto__,G__42407){
var self__ = this;
var this__5350__auto____$1 = this;
var pred__42419 = cljs.core.keyword_identical_QMARK_;
var expr__42420 = k__5351__auto__;
if(cljs.core.truth_((function (){var G__42422 = cljs.core.cst$kw$conn;
var G__42423 = expr__42420;
return (pred__42419.cljs$core$IFn$_invoke$arity$2 ? pred__42419.cljs$core$IFn$_invoke$arity$2(G__42422,G__42423) : pred__42419.call(null,G__42422,G__42423));
})())){
return (new fluree.db.graphdb.GraphDb(G__42407,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42424 = cljs.core.cst$kw$network;
var G__42425 = expr__42420;
return (pred__42419.cljs$core$IFn$_invoke$arity$2 ? pred__42419.cljs$core$IFn$_invoke$arity$2(G__42424,G__42425) : pred__42419.call(null,G__42424,G__42425));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__42407,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42426 = cljs.core.cst$kw$dbid;
var G__42427 = expr__42420;
return (pred__42419.cljs$core$IFn$_invoke$arity$2 ? pred__42419.cljs$core$IFn$_invoke$arity$2(G__42426,G__42427) : pred__42419.call(null,G__42426,G__42427));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__42407,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42428 = cljs.core.cst$kw$block;
var G__42429 = expr__42420;
return (pred__42419.cljs$core$IFn$_invoke$arity$2 ? pred__42419.cljs$core$IFn$_invoke$arity$2(G__42428,G__42429) : pred__42419.call(null,G__42428,G__42429));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__42407,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42430 = cljs.core.cst$kw$t;
var G__42431 = expr__42420;
return (pred__42419.cljs$core$IFn$_invoke$arity$2 ? pred__42419.cljs$core$IFn$_invoke$arity$2(G__42430,G__42431) : pred__42419.call(null,G__42430,G__42431));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__42407,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42432 = cljs.core.cst$kw$tt_DASH_id;
var G__42433 = expr__42420;
return (pred__42419.cljs$core$IFn$_invoke$arity$2 ? pred__42419.cljs$core$IFn$_invoke$arity$2(G__42432,G__42433) : pred__42419.call(null,G__42432,G__42433));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__42407,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42434 = cljs.core.cst$kw$stats;
var G__42435 = expr__42420;
return (pred__42419.cljs$core$IFn$_invoke$arity$2 ? pred__42419.cljs$core$IFn$_invoke$arity$2(G__42434,G__42435) : pred__42419.call(null,G__42434,G__42435));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__42407,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42436 = cljs.core.cst$kw$spot;
var G__42437 = expr__42420;
return (pred__42419.cljs$core$IFn$_invoke$arity$2 ? pred__42419.cljs$core$IFn$_invoke$arity$2(G__42436,G__42437) : pred__42419.call(null,G__42436,G__42437));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__42407,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42438 = cljs.core.cst$kw$psot;
var G__42439 = expr__42420;
return (pred__42419.cljs$core$IFn$_invoke$arity$2 ? pred__42419.cljs$core$IFn$_invoke$arity$2(G__42438,G__42439) : pred__42419.call(null,G__42438,G__42439));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__42407,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42440 = cljs.core.cst$kw$post;
var G__42441 = expr__42420;
return (pred__42419.cljs$core$IFn$_invoke$arity$2 ? pred__42419.cljs$core$IFn$_invoke$arity$2(G__42440,G__42441) : pred__42419.call(null,G__42440,G__42441));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__42407,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42442 = cljs.core.cst$kw$opst;
var G__42443 = expr__42420;
return (pred__42419.cljs$core$IFn$_invoke$arity$2 ? pred__42419.cljs$core$IFn$_invoke$arity$2(G__42442,G__42443) : pred__42419.call(null,G__42442,G__42443));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__42407,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42444 = cljs.core.cst$kw$schema;
var G__42445 = expr__42420;
return (pred__42419.cljs$core$IFn$_invoke$arity$2 ? pred__42419.cljs$core$IFn$_invoke$arity$2(G__42444,G__42445) : pred__42419.call(null,G__42444,G__42445));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__42407,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42446 = cljs.core.cst$kw$settings;
var G__42447 = expr__42420;
return (pred__42419.cljs$core$IFn$_invoke$arity$2 ? pred__42419.cljs$core$IFn$_invoke$arity$2(G__42446,G__42447) : pred__42419.call(null,G__42446,G__42447));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__42407,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42448 = cljs.core.cst$kw$index_DASH_configs;
var G__42449 = expr__42420;
return (pred__42419.cljs$core$IFn$_invoke$arity$2 ? pred__42419.cljs$core$IFn$_invoke$arity$2(G__42448,G__42449) : pred__42419.call(null,G__42448,G__42449));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__42407,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42450 = cljs.core.cst$kw$schema_DASH_cache;
var G__42451 = expr__42420;
return (pred__42419.cljs$core$IFn$_invoke$arity$2 ? pred__42419.cljs$core$IFn$_invoke$arity$2(G__42450,G__42451) : pred__42419.call(null,G__42450,G__42451));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__42407,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42452 = cljs.core.cst$kw$novelty;
var G__42453 = expr__42420;
return (pred__42419.cljs$core$IFn$_invoke$arity$2 ? pred__42419.cljs$core$IFn$_invoke$arity$2(G__42452,G__42453) : pred__42419.call(null,G__42452,G__42453));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__42407,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42454 = cljs.core.cst$kw$permissions;
var G__42455 = expr__42420;
return (pred__42419.cljs$core$IFn$_invoke$arity$2 ? pred__42419.cljs$core$IFn$_invoke$arity$2(G__42454,G__42455) : pred__42419.call(null,G__42454,G__42455));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__42407,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42456 = cljs.core.cst$kw$fork;
var G__42457 = expr__42420;
return (pred__42419.cljs$core$IFn$_invoke$arity$2 ? pred__42419.cljs$core$IFn$_invoke$arity$2(G__42456,G__42457) : pred__42419.call(null,G__42456,G__42457));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__42407,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42458 = cljs.core.cst$kw$fork_DASH_block;
var G__42459 = expr__42420;
return (pred__42419.cljs$core$IFn$_invoke$arity$2 ? pred__42419.cljs$core$IFn$_invoke$arity$2(G__42458,G__42459) : pred__42419.call(null,G__42458,G__42459));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__42407,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42460 = cljs.core.cst$kw$current_DASH_db_DASH_fn;
var G__42461 = expr__42420;
return (pred__42419.cljs$core$IFn$_invoke$arity$2 ? pred__42419.cljs$core$IFn$_invoke$arity$2(G__42460,G__42461) : pred__42419.call(null,G__42460,G__42461));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__42407,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5351__auto__,G__42407),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5355__auto__){
var self__ = this;
var this__5355__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$stats,self__.stats,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$spot,self__.spot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$psot,self__.psot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$post,self__.post,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$opst,self__.opst,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema,self__.schema,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$settings,self__.settings,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_configs,self__.index_configs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$novelty,self__.novelty,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$permissions,self__.permissions,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork,self__.fork,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork_DASH_block,self__.fork_block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5341__auto__,G__42407){
var self__ = this;
var this__5341__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__42407,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5347__auto__,entry__5348__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5348__auto__)){
return this__5347__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5347__auto____$1,entry__5348__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop(this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop(this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$stats,cljs.core.cst$sym$spot,cljs.core.cst$sym$psot,cljs.core.cst$sym$post,cljs.core.cst$sym$opst,cljs.core.cst$sym$schema,cljs.core.cst$sym$settings,cljs.core.cst$sym$index_DASH_configs,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$novelty,cljs.core.cst$sym$permissions,cljs.core.cst$sym$fork,cljs.core.cst$sym$fork_DASH_block,cljs.core.cst$sym$current_DASH_db_DASH_fn], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__5388__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__5388__auto__,writer__5389__auto__){
return cljs.core._write(writer__5389__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__42411){
var extmap__5384__auto__ = (function (){var G__42462 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__42411,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], 0));
if(cljs.core.record_QMARK_(G__42411)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__42462);
} else {
return G__42462;
}
})();
return (new fluree.db.graphdb.GraphDb(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__42411),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__42411),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__42411),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__42411),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__42411),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__42411),cljs.core.cst$kw$stats.cljs$core$IFn$_invoke$arity$1(G__42411),cljs.core.cst$kw$spot.cljs$core$IFn$_invoke$arity$1(G__42411),cljs.core.cst$kw$psot.cljs$core$IFn$_invoke$arity$1(G__42411),cljs.core.cst$kw$post.cljs$core$IFn$_invoke$arity$1(G__42411),cljs.core.cst$kw$opst.cljs$core$IFn$_invoke$arity$1(G__42411),cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(G__42411),cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(G__42411),cljs.core.cst$kw$index_DASH_configs.cljs$core$IFn$_invoke$arity$1(G__42411),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__42411),cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(G__42411),cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(G__42411),cljs.core.cst$kw$fork.cljs$core$IFn$_invoke$arity$1(G__42411),cljs.core.cst$kw$fork_DASH_block.cljs$core$IFn$_invoke$arity$1(G__42411),cljs.core.cst$kw$current_DASH_db_DASH_fn.cljs$core$IFn$_invoke$arity$1(G__42411),null,cljs.core.not_empty(extmap__5384__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$network,db__$1.network,cljs.core.cst$kw$dbid,db__$1.dbid,cljs.core.cst$kw$block,db__$1.block,cljs.core.cst$kw$t,db__$1.t,cljs.core.cst$kw$stats,db__$1.stats,cljs.core.cst$kw$permissions,db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,cljs.core.cst$kw$historyComparator], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$size,(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$block,cljs.core.cst$kw$dbid,cljs.core.cst$kw$config,cljs.core.cst$kw$leaf,cljs.core.cst$kw$size,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$id,cljs.core.cst$kw$t,cljs.core.cst$kw$network,cljs.core.cst$kw$first,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$rhs,cljs.core.cst$kw$conn],[(0),dbid,index_config,true,(0),true,cljs.core.cst$kw$empty,(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$spot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$spot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_spot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_spot_novelty], null)),cljs.core.cst$kw$psot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$psot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_psot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_psot_novelty], null)),cljs.core.cst$kw$post,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$post,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_post,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_post_novelty], null)),cljs.core.cst$kw$opst,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$opst,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_opst,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,false], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$root_QMARK_,true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$spot);
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$psot);
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$post);
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$opst);
var stats = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$flakes,(0),cljs.core.cst$kw$size,(0),cljs.core.cst$kw$indexed,(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
