// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.data.avl');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexConfig = (function (index_type,comparator,historyComparator,__meta,__extmap,__hash){
this.index_type = index_type;
this.comparator = comparator;
this.historyComparator = historyComparator;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5342__auto__,k__5343__auto__){
var self__ = this;
var this__5342__auto____$1 = this;
return this__5342__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5343__auto__,null);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5344__auto__,k31446,else__5345__auto__){
var self__ = this;
var this__5344__auto____$1 = this;
var G__31450 = k31446;
var G__31450__$1 = (((G__31450 instanceof cljs.core.Keyword))?G__31450.fqn:null);
switch (G__31450__$1) {
case "index-type":
return self__.index_type;

break;
case "comparator":
return self__.comparator;

break;
case "historyComparator":
return self__.historyComparator;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31446,else__5345__auto__);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5362__auto__,f__5363__auto__,init__5364__auto__){
var self__ = this;
var this__5362__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5365__auto__,p__31451){
var vec__31452 = p__31451;
var k__5366__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31452,(0),null);
var v__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31452,(1),null);
return (f__5363__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5363__auto__.cljs$core$IFn$_invoke$arity$3(ret__5365__auto__,k__5366__auto__,v__5367__auto__) : f__5363__auto__.call(null,ret__5365__auto__,k__5366__auto__,v__5367__auto__));
}),init__5364__auto__,this__5362__auto____$1);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5357__auto__,writer__5358__auto__,opts__5359__auto__){
var self__ = this;
var this__5357__auto____$1 = this;
var pr_pair__5360__auto__ = (function (keyval__5361__auto__){
return cljs.core.pr_sequential_writer(writer__5358__auto__,cljs.core.pr_writer,""," ","",opts__5359__auto__,keyval__5361__auto__);
});
return cljs.core.pr_sequential_writer(writer__5358__auto__,pr_pair__5360__auto__,"#fluree.db.index.IndexConfig{",", ","}",opts__5359__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_type,self__.index_type],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$comparator,self__.comparator],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$historyComparator,self__.historyComparator],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31445){
var self__ = this;
var G__31445__$1 = this;
return (new cljs.core.RecordIter((0),G__31445__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5340__auto__){
var self__ = this;
var this__5340__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5337__auto__){
var self__ = this;
var this__5337__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5346__auto__){
var self__ = this;
var this__5346__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__31455 = (function (coll__5339__auto__){
return (1512230614 ^ cljs.core.hash_unordered_coll(coll__5339__auto__));
});
return fexpr__31455(this__5338__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this31447,other31448){
var self__ = this;
var this31447__$1 = this;
return (((!((other31448 == null)))) && ((((this31447__$1.constructor === other31448.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31447__$1.index_type,other31448.index_type)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31447__$1.comparator,other31448.comparator)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31447__$1.historyComparator,other31448.historyComparator)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31447__$1.__extmap,other31448.__extmap)))))))))));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5352__auto__,k__5353__auto__){
var self__ = this;
var this__5352__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$historyComparator,null,cljs.core.cst$kw$comparator,null,cljs.core.cst$kw$index_DASH_type,null], null), null),k__5353__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5352__auto____$1),self__.__meta),k__5353__auto__);
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5353__auto__)),null));
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5349__auto__,k31446){
var self__ = this;
var this__5349__auto____$1 = this;
var G__31456 = k31446;
var G__31456__$1 = (((G__31456 instanceof cljs.core.Keyword))?G__31456.fqn:null);
switch (G__31456__$1) {
case "index-type":
case "comparator":
case "historyComparator":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k31446);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5350__auto__,k__5351__auto__,G__31445){
var self__ = this;
var this__5350__auto____$1 = this;
var pred__31457 = cljs.core.keyword_identical_QMARK_;
var expr__31458 = k__5351__auto__;
if(cljs.core.truth_((function (){var G__31460 = cljs.core.cst$kw$index_DASH_type;
var G__31461 = expr__31458;
return (pred__31457.cljs$core$IFn$_invoke$arity$2 ? pred__31457.cljs$core$IFn$_invoke$arity$2(G__31460,G__31461) : pred__31457.call(null,G__31460,G__31461));
})())){
return (new fluree.db.index.IndexConfig(G__31445,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__31462 = cljs.core.cst$kw$comparator;
var G__31463 = expr__31458;
return (pred__31457.cljs$core$IFn$_invoke$arity$2 ? pred__31457.cljs$core$IFn$_invoke$arity$2(G__31462,G__31463) : pred__31457.call(null,G__31462,G__31463));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,G__31445,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__31464 = cljs.core.cst$kw$historyComparator;
var G__31465 = expr__31458;
return (pred__31457.cljs$core$IFn$_invoke$arity$2 ? pred__31457.cljs$core$IFn$_invoke$arity$2(G__31464,G__31465) : pred__31457.call(null,G__31464,G__31465));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,G__31445,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5351__auto__,G__31445),null));
}
}
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5355__auto__){
var self__ = this;
var this__5355__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_type,self__.index_type,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$comparator,self__.comparator,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$historyComparator,self__.historyComparator,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5341__auto__,G__31445){
var self__ = this;
var this__5341__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,G__31445,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5347__auto__,entry__5348__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5348__auto__)){
return this__5347__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5347__auto____$1,entry__5348__auto__);
}
}));

(fluree.db.index.IndexConfig.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$index_DASH_type,cljs.core.cst$sym$comparator,cljs.core.cst$sym$historyComparator], null);
}));

(fluree.db.index.IndexConfig.cljs$lang$type = true);

(fluree.db.index.IndexConfig.cljs$lang$ctorPrSeq = (function (this__5388__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexConfig",null,(1),null));
}));

(fluree.db.index.IndexConfig.cljs$lang$ctorPrWriter = (function (this__5388__auto__,writer__5389__auto__){
return cljs.core._write(writer__5389__auto__,"fluree.db.index/IndexConfig");
}));

/**
 * Positional factory function for fluree.db.index/IndexConfig.
 */
fluree.db.index.__GT_IndexConfig = (function fluree$db$index$__GT_IndexConfig(index_type,comparator,historyComparator){
return (new fluree.db.index.IndexConfig(index_type,comparator,historyComparator,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexConfig, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexConfig = (function fluree$db$index$map__GT_IndexConfig(G__31449){
var extmap__5384__auto__ = (function (){var G__31466 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__31449,cljs.core.cst$kw$index_DASH_type,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], 0));
if(cljs.core.record_QMARK_(G__31449)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__31466);
} else {
return G__31466;
}
})();
return (new fluree.db.index.IndexConfig(cljs.core.cst$kw$index_DASH_type.cljs$core$IFn$_invoke$arity$1(G__31449),cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(G__31449),cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(G__31449),null,cljs.core.not_empty(extmap__5384__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexNode = (function (block,t,rhs,children,config,leftmost_QMARK_,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.rhs = rhs;
this.children = children;
this.config = config;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5342__auto__,k__5343__auto__){
var self__ = this;
var this__5342__auto____$1 = this;
return this__5342__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5343__auto__,null);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5344__auto__,k31470,else__5345__auto__){
var self__ = this;
var this__5344__auto____$1 = this;
var G__31474 = k31470;
var G__31474__$1 = (((G__31474 instanceof cljs.core.Keyword))?G__31474.fqn:null);
switch (G__31474__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "rhs":
return self__.rhs;

break;
case "children":
return self__.children;

break;
case "config":
return self__.config;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31470,else__5345__auto__);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5362__auto__,f__5363__auto__,init__5364__auto__){
var self__ = this;
var this__5362__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5365__auto__,p__31475){
var vec__31476 = p__31475;
var k__5366__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31476,(0),null);
var v__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31476,(1),null);
return (f__5363__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5363__auto__.cljs$core$IFn$_invoke$arity$3(ret__5365__auto__,k__5366__auto__,v__5367__auto__) : f__5363__auto__.call(null,ret__5365__auto__,k__5366__auto__,v__5367__auto__));
}),init__5364__auto__,this__5362__auto____$1);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5357__auto__,writer__5358__auto__,opts__5359__auto__){
var self__ = this;
var this__5357__auto____$1 = this;
var pr_pair__5360__auto__ = (function (keyval__5361__auto__){
return cljs.core.pr_sequential_writer(writer__5358__auto__,cljs.core.pr_writer,""," ","",opts__5359__auto__,keyval__5361__auto__);
});
return cljs.core.pr_sequential_writer(writer__5358__auto__,pr_pair__5360__auto__,"#fluree.db.index.IndexNode{",", ","}",opts__5359__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$children,self__.children],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31469){
var self__ = this;
var G__31469__$1 = this;
return (new cljs.core.RecordIter((0),G__31469__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_31480){
var state_val_31481 = (state_31480[(1)]);
if((state_val_31481 === (1))){
var state_31480__$1 = state_31480;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31480__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__15091__auto__ = null;
var fluree$db$index$state_machine__15091__auto____0 = (function (){
var statearr_31482 = [null,null,null,null,null,null,null];
(statearr_31482[(0)] = fluree$db$index$state_machine__15091__auto__);

(statearr_31482[(1)] = (1));

return statearr_31482;
});
var fluree$db$index$state_machine__15091__auto____1 = (function (state_31480){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_31480);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e31483){var ex__15094__auto__ = e31483;
var statearr_31484_31596 = state_31480;
(statearr_31484_31596[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_31480[(4)]))){
var statearr_31485_31597 = state_31480;
(statearr_31485_31597[(1)] = cljs.core.first((state_31480[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__31598 = state_31480;
state_31480 = G__31598;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$index$state_machine__15091__auto__ = function(state_31480){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__15091__auto____1.call(this,state_31480);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__15091__auto____0;
fluree$db$index$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__15091__auto____1;
return fluree$db$index$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_31486 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_31486[(6)] = c__15165__auto__);

return statearr_31486;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.key(cljs.core.first(self__.children));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5340__auto__){
var self__ = this;
var this__5340__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5337__auto__){
var self__ = this;
var this__5337__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5346__auto__){
var self__ = this;
var this__5346__auto____$1 = this;
return (6 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
return cljs.core.val((function (){var or__5045__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.first(self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_after$arity$2 = (function (_,flake){
var self__ = this;
var ___$1 = this;
return cljs.core.val((function (){var or__5045__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._GT_,flake);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.last(self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_31511){
var state_val_31512 = (state_31511[(1)]);
if((state_val_31512 === (7))){
var inst_31493 = (state_31511[(7)]);
var inst_31497 = fluree.db.dbproto._resolve(inst_31493);
var state_31511__$1 = state_31511;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31511__$1,(10),inst_31497);
} else {
if((state_val_31512 === (1))){
var state_31511__$1 = state_31511;
var statearr_31513_31599 = state_31511__$1;
(statearr_31513_31599[(2)] = null);

(statearr_31513_31599[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31512 === (4))){
var inst_31487 = (state_31511[(2)]);
var state_31511__$1 = state_31511;
var statearr_31514_31600 = state_31511__$1;
(statearr_31514_31600[(2)] = inst_31487);

(statearr_31514_31600[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31512 === (6))){
var inst_31493 = (state_31511[(7)]);
var state_31511__$1 = state_31511;
var statearr_31515_31601 = state_31511__$1;
(statearr_31515_31601[(2)] = inst_31493);

(statearr_31515_31601[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31512 === (3))){
var inst_31509 = (state_31511[(2)]);
var state_31511__$1 = state_31511;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31511__$1,inst_31509);
} else {
if((state_val_31512 === (2))){
var inst_31493 = (state_31511[(7)]);
var _ = (function (){var statearr_31517 = state_31511;
(statearr_31517[(4)] = cljs.core.cons((5),(state_31511[(4)])));

return statearr_31517;
})();
var inst_31493__$1 = this$__$1.fluree$db$dbproto$INode$_lookup$arity$2(null,flake);
var inst_31494 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_31493__$1);
var state_31511__$1 = (function (){var statearr_31518 = state_31511;
(statearr_31518[(7)] = inst_31493__$1);

return statearr_31518;
})();
if(cljs.core.truth_(inst_31494)){
var statearr_31519_31602 = state_31511__$1;
(statearr_31519_31602[(1)] = (6));

} else {
var statearr_31520_31603 = state_31511__$1;
(statearr_31520_31603[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31512 === (9))){
var inst_31503 = (state_31511[(2)]);
var inst_31504 = fluree.db.util.async.throw_err(inst_31503);
var state_31511__$1 = state_31511;
var statearr_31521_31604 = state_31511__$1;
(statearr_31521_31604[(2)] = inst_31504);

(statearr_31521_31604[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31512 === (5))){
var _ = (function (){var statearr_31522 = state_31511;
(statearr_31522[(4)] = cljs.core.rest((state_31511[(4)])));

return statearr_31522;
})();
var state_31511__$1 = state_31511;
var ex31516 = (state_31511__$1[(2)]);
var statearr_31523_31605 = state_31511__$1;
(statearr_31523_31605[(5)] = ex31516);


if((ex31516 instanceof Error)){
var statearr_31524_31606 = state_31511__$1;
(statearr_31524_31606[(1)] = (4));

(statearr_31524_31606[(5)] = null);

} else {
throw ex31516;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31512 === (10))){
var inst_31499 = (state_31511[(2)]);
var inst_31500 = fluree.db.util.async.throw_err(inst_31499);
var inst_31501 = fluree.db.dbproto._lookup_leaf(inst_31500,flake);
var state_31511__$1 = state_31511;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31511__$1,(9),inst_31501);
} else {
if((state_val_31512 === (8))){
var inst_31506 = (state_31511[(2)]);
var _ = (function (){var statearr_31525 = state_31511;
(statearr_31525[(4)] = cljs.core.rest((state_31511[(4)])));

return statearr_31525;
})();
var state_31511__$1 = state_31511;
var statearr_31526_31607 = state_31511__$1;
(statearr_31526_31607[(2)] = inst_31506);

(statearr_31526_31607[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__15091__auto__ = null;
var fluree$db$index$state_machine__15091__auto____0 = (function (){
var statearr_31527 = [null,null,null,null,null,null,null,null];
(statearr_31527[(0)] = fluree$db$index$state_machine__15091__auto__);

(statearr_31527[(1)] = (1));

return statearr_31527;
});
var fluree$db$index$state_machine__15091__auto____1 = (function (state_31511){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_31511);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e31528){var ex__15094__auto__ = e31528;
var statearr_31529_31608 = state_31511;
(statearr_31529_31608[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_31511[(4)]))){
var statearr_31530_31609 = state_31511;
(statearr_31530_31609[(1)] = cljs.core.first((state_31511[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__31610 = state_31511;
state_31511 = G__31610;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$index$state_machine__15091__auto__ = function(state_31511){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__15091__auto____1.call(this,state_31511);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__15091__auto____0;
fluree$db$index$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__15091__auto____1;
return fluree$db$index$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_31531 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_31531[(6)] = c__15165__auto__);

return statearr_31531;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_31556){
var state_val_31557 = (state_31556[(1)]);
if((state_val_31557 === (7))){
var inst_31538 = (state_31556[(7)]);
var inst_31542 = fluree.db.dbproto._resolve(inst_31538);
var state_31556__$1 = state_31556;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31556__$1,(10),inst_31542);
} else {
if((state_val_31557 === (1))){
var state_31556__$1 = state_31556;
var statearr_31558_31611 = state_31556__$1;
(statearr_31558_31611[(2)] = null);

(statearr_31558_31611[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31557 === (4))){
var inst_31532 = (state_31556[(2)]);
var state_31556__$1 = state_31556;
var statearr_31559_31612 = state_31556__$1;
(statearr_31559_31612[(2)] = inst_31532);

(statearr_31559_31612[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31557 === (6))){
var inst_31538 = (state_31556[(7)]);
var state_31556__$1 = state_31556;
var statearr_31560_31613 = state_31556__$1;
(statearr_31560_31613[(2)] = inst_31538);

(statearr_31560_31613[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31557 === (3))){
var inst_31554 = (state_31556[(2)]);
var state_31556__$1 = state_31556;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31556__$1,inst_31554);
} else {
if((state_val_31557 === (2))){
var inst_31538 = (state_31556[(7)]);
var _ = (function (){var statearr_31562 = state_31556;
(statearr_31562[(4)] = cljs.core.cons((5),(state_31556[(4)])));

return statearr_31562;
})();
var inst_31538__$1 = this$__$1.fluree$db$dbproto$INode$_lookup_after$arity$2(null,flake);
var inst_31539 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_31538__$1);
var state_31556__$1 = (function (){var statearr_31563 = state_31556;
(statearr_31563[(7)] = inst_31538__$1);

return statearr_31563;
})();
if(cljs.core.truth_(inst_31539)){
var statearr_31564_31614 = state_31556__$1;
(statearr_31564_31614[(1)] = (6));

} else {
var statearr_31565_31615 = state_31556__$1;
(statearr_31565_31615[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31557 === (9))){
var inst_31548 = (state_31556[(2)]);
var inst_31549 = fluree.db.util.async.throw_err(inst_31548);
var state_31556__$1 = state_31556;
var statearr_31566_31616 = state_31556__$1;
(statearr_31566_31616[(2)] = inst_31549);

(statearr_31566_31616[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31557 === (5))){
var _ = (function (){var statearr_31567 = state_31556;
(statearr_31567[(4)] = cljs.core.rest((state_31556[(4)])));

return statearr_31567;
})();
var state_31556__$1 = state_31556;
var ex31561 = (state_31556__$1[(2)]);
var statearr_31568_31617 = state_31556__$1;
(statearr_31568_31617[(5)] = ex31561);


if((ex31561 instanceof Error)){
var statearr_31569_31618 = state_31556__$1;
(statearr_31569_31618[(1)] = (4));

(statearr_31569_31618[(5)] = null);

} else {
throw ex31561;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31557 === (10))){
var inst_31544 = (state_31556[(2)]);
var inst_31545 = fluree.db.util.async.throw_err(inst_31544);
var inst_31546 = fluree.db.dbproto._lookup_leaf_after(inst_31545,flake);
var state_31556__$1 = state_31556;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31556__$1,(9),inst_31546);
} else {
if((state_val_31557 === (8))){
var inst_31551 = (state_31556[(2)]);
var _ = (function (){var statearr_31570 = state_31556;
(statearr_31570[(4)] = cljs.core.rest((state_31556[(4)])));

return statearr_31570;
})();
var state_31556__$1 = state_31556;
var statearr_31571_31619 = state_31556__$1;
(statearr_31571_31619[(2)] = inst_31551);

(statearr_31571_31619[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__15091__auto__ = null;
var fluree$db$index$state_machine__15091__auto____0 = (function (){
var statearr_31572 = [null,null,null,null,null,null,null,null];
(statearr_31572[(0)] = fluree$db$index$state_machine__15091__auto__);

(statearr_31572[(1)] = (1));

return statearr_31572;
});
var fluree$db$index$state_machine__15091__auto____1 = (function (state_31556){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_31556);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e31573){var ex__15094__auto__ = e31573;
var statearr_31574_31620 = state_31556;
(statearr_31574_31620[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_31556[(4)]))){
var statearr_31575_31621 = state_31556;
(statearr_31575_31621[(1)] = cljs.core.first((state_31556[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__31622 = state_31556;
state_31556 = G__31622;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$index$state_machine__15091__auto__ = function(state_31556){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__15091__auto____1.call(this,state_31556);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__15091__auto____0;
fluree$db$index$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__15091__auto____1;
return fluree$db$index$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_31576 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_31576[(6)] = c__15165__auto__);

return statearr_31576;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__31577 = (function (coll__5339__auto__){
return (659789215 ^ cljs.core.hash_unordered_coll(coll__5339__auto__));
});
return fexpr__31577(this__5338__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this31471,other31472){
var self__ = this;
var this31471__$1 = this;
return (((!((other31472 == null)))) && ((((this31471__$1.constructor === other31472.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31471__$1.block,other31472.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31471__$1.t,other31472.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31471__$1.rhs,other31472.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31471__$1.children,other31472.children)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31471__$1.config,other31472.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31471__$1.leftmost_QMARK_,other31472.leftmost_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31471__$1.__extmap,other31472.__extmap)))))))))))))))));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5352__auto__,k__5353__auto__){
var self__ = this;
var this__5352__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$children,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$rhs,null], null), null),k__5353__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5352__auto____$1),self__.__meta),k__5353__auto__);
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5353__auto__)),null));
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5349__auto__,k31470){
var self__ = this;
var this__5349__auto____$1 = this;
var G__31578 = k31470;
var G__31578__$1 = (((G__31578 instanceof cljs.core.Keyword))?G__31578.fqn:null);
switch (G__31578__$1) {
case "block":
case "t":
case "rhs":
case "children":
case "config":
case "leftmost?":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k31470);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5350__auto__,k__5351__auto__,G__31469){
var self__ = this;
var this__5350__auto____$1 = this;
var pred__31579 = cljs.core.keyword_identical_QMARK_;
var expr__31580 = k__5351__auto__;
if(cljs.core.truth_((function (){var G__31582 = cljs.core.cst$kw$block;
var G__31583 = expr__31580;
return (pred__31579.cljs$core$IFn$_invoke$arity$2 ? pred__31579.cljs$core$IFn$_invoke$arity$2(G__31582,G__31583) : pred__31579.call(null,G__31582,G__31583));
})())){
return (new fluree.db.index.IndexNode(G__31469,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__31584 = cljs.core.cst$kw$t;
var G__31585 = expr__31580;
return (pred__31579.cljs$core$IFn$_invoke$arity$2 ? pred__31579.cljs$core$IFn$_invoke$arity$2(G__31584,G__31585) : pred__31579.call(null,G__31584,G__31585));
})())){
return (new fluree.db.index.IndexNode(self__.block,G__31469,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__31586 = cljs.core.cst$kw$rhs;
var G__31587 = expr__31580;
return (pred__31579.cljs$core$IFn$_invoke$arity$2 ? pred__31579.cljs$core$IFn$_invoke$arity$2(G__31586,G__31587) : pred__31579.call(null,G__31586,G__31587));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,G__31469,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__31588 = cljs.core.cst$kw$children;
var G__31589 = expr__31580;
return (pred__31579.cljs$core$IFn$_invoke$arity$2 ? pred__31579.cljs$core$IFn$_invoke$arity$2(G__31588,G__31589) : pred__31579.call(null,G__31588,G__31589));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,G__31469,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__31590 = cljs.core.cst$kw$config;
var G__31591 = expr__31580;
return (pred__31579.cljs$core$IFn$_invoke$arity$2 ? pred__31579.cljs$core$IFn$_invoke$arity$2(G__31590,G__31591) : pred__31579.call(null,G__31590,G__31591));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,G__31469,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__31592 = cljs.core.cst$kw$leftmost_QMARK_;
var G__31593 = expr__31580;
return (pred__31579.cljs$core$IFn$_invoke$arity$2 ? pred__31579.cljs$core$IFn$_invoke$arity$2(G__31592,G__31593) : pred__31579.call(null,G__31592,G__31593));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,G__31469,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5351__auto__,G__31469),null));
}
}
}
}
}
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5355__auto__){
var self__ = this;
var this__5355__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$children,self__.children,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5341__auto__,G__31469){
var self__ = this;
var this__5341__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,G__31469,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5347__auto__,entry__5348__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5348__auto__)){
return this__5347__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5347__auto____$1,entry__5348__auto__);
}
}));

(fluree.db.index.IndexNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$rhs,cljs.core.cst$sym$children,cljs.core.cst$sym$config,cljs.core.cst$sym$leftmost_QMARK_], null);
}));

(fluree.db.index.IndexNode.cljs$lang$type = true);

(fluree.db.index.IndexNode.cljs$lang$ctorPrSeq = (function (this__5388__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexNode",null,(1),null));
}));

(fluree.db.index.IndexNode.cljs$lang$ctorPrWriter = (function (this__5388__auto__,writer__5389__auto__){
return cljs.core._write(writer__5389__auto__,"fluree.db.index/IndexNode");
}));

/**
 * Positional factory function for fluree.db.index/IndexNode.
 */
fluree.db.index.__GT_IndexNode = (function fluree$db$index$__GT_IndexNode(block,t,rhs,children,config,leftmost_QMARK_){
return (new fluree.db.index.IndexNode(block,t,rhs,children,config,leftmost_QMARK_,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexNode = (function fluree$db$index$map__GT_IndexNode(G__31473){
var extmap__5384__auto__ = (function (){var G__31594 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__31473,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], 0));
if(cljs.core.record_QMARK_(G__31473)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__31594);
} else {
return G__31594;
}
})();
return (new fluree.db.index.IndexNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__31473),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__31473),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__31473),cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(G__31473),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__31473),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__31473),null,cljs.core.not_empty(extmap__5384__auto__),null));
});

fluree.db.index.index_node_QMARK_ = (function fluree$db$index$index_node_QMARK_(node){
return (node instanceof fluree.db.index.IndexNode);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.DataNode = (function (block,t,flakes,rhs,config,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.flakes = flakes;
this.rhs = rhs;
this.config = config;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5342__auto__,k__5343__auto__){
var self__ = this;
var this__5342__auto____$1 = this;
return this__5342__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5343__auto__,null);
}));

(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5344__auto__,k31625,else__5345__auto__){
var self__ = this;
var this__5344__auto____$1 = this;
var G__31629 = k31625;
var G__31629__$1 = (((G__31629 instanceof cljs.core.Keyword))?G__31629.fqn:null);
switch (G__31629__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "flakes":
return self__.flakes;

break;
case "rhs":
return self__.rhs;

break;
case "config":
return self__.config;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31625,else__5345__auto__);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5362__auto__,f__5363__auto__,init__5364__auto__){
var self__ = this;
var this__5362__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5365__auto__,p__31630){
var vec__31631 = p__31630;
var k__5366__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31631,(0),null);
var v__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31631,(1),null);
return (f__5363__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5363__auto__.cljs$core$IFn$_invoke$arity$3(ret__5365__auto__,k__5366__auto__,v__5367__auto__) : f__5363__auto__.call(null,ret__5365__auto__,k__5366__auto__,v__5367__auto__));
}),init__5364__auto__,this__5362__auto____$1);
}));

(fluree.db.index.DataNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5357__auto__,writer__5358__auto__,opts__5359__auto__){
var self__ = this;
var this__5357__auto____$1 = this;
var pr_pair__5360__auto__ = (function (keyval__5361__auto__){
return cljs.core.pr_sequential_writer(writer__5358__auto__,cljs.core.pr_writer,""," ","",opts__5359__auto__,keyval__5361__auto__);
});
return cljs.core.pr_sequential_writer(writer__5358__auto__,pr_pair__5360__auto__,"#fluree.db.index.DataNode{",", ","}",opts__5359__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$flakes,self__.flakes],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31624){
var self__ = this;
var G__31624__$1 = this;
return (new cljs.core.RecordIter((0),G__31624__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_31635){
var state_val_31636 = (state_31635[(1)]);
if((state_val_31636 === (1))){
var state_31635__$1 = state_31635;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31635__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__15091__auto__ = null;
var fluree$db$index$state_machine__15091__auto____0 = (function (){
var statearr_31637 = [null,null,null,null,null,null,null];
(statearr_31637[(0)] = fluree$db$index$state_machine__15091__auto__);

(statearr_31637[(1)] = (1));

return statearr_31637;
});
var fluree$db$index$state_machine__15091__auto____1 = (function (state_31635){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_31635);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e31638){var ex__15094__auto__ = e31638;
var statearr_31639_31671 = state_31635;
(statearr_31639_31671[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_31635[(4)]))){
var statearr_31640_31672 = state_31635;
(statearr_31640_31672[(1)] = cljs.core.first((state_31635[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__31673 = state_31635;
state_31635 = G__31673;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$index$state_machine__15091__auto__ = function(state_31635){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__15091__auto____1.call(this,state_31635);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__15091__auto____0;
fluree$db$index$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__15091__auto____1;
return fluree$db$index$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_31641 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_31641[(6)] = c__15165__auto__);

return statearr_31641;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-resolve-history called on DATA NODE!!!",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.first(self__.flakes);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5340__auto__){
var self__ = this;
var this__5340__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5337__auto__){
var self__ = this;
var this__5337__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5346__auto__){
var self__ = this;
var this__5346__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup was called on a data node, which shouldn't happen!",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["-lookup-leaf was called on a data node, which shouldn't happen!"], 0));

var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_31647){
var state_val_31648 = (state_31647[(1)]);
if((state_val_31648 === (1))){
var inst_31642 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_31643 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_31644 = cljs.core.PersistentHashMap.fromArrays(inst_31642,inst_31643);
var inst_31645 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup-leaf was called on a data node, which shouldn't happen!",inst_31644);
var state_31647__$1 = state_31647;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31647__$1,inst_31645);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__15091__auto__ = null;
var fluree$db$index$state_machine__15091__auto____0 = (function (){
var statearr_31649 = [null,null,null,null,null,null,null];
(statearr_31649[(0)] = fluree$db$index$state_machine__15091__auto__);

(statearr_31649[(1)] = (1));

return statearr_31649;
});
var fluree$db$index$state_machine__15091__auto____1 = (function (state_31647){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_31647);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e31650){var ex__15094__auto__ = e31650;
var statearr_31651_31674 = state_31647;
(statearr_31651_31674[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_31647[(4)]))){
var statearr_31652_31675 = state_31647;
(statearr_31652_31675[(1)] = cljs.core.first((state_31647[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__31676 = state_31647;
state_31647 = G__31676;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$index$state_machine__15091__auto__ = function(state_31647){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__15091__auto____1.call(this,state_31647);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__15091__auto____0;
fluree$db$index$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__15091__auto____1;
return fluree$db$index$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_31653 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_31653[(6)] = c__15165__auto__);

return statearr_31653;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__31654 = (function (coll__5339__auto__){
return (1312629141 ^ cljs.core.hash_unordered_coll(coll__5339__auto__));
});
return fexpr__31654(this__5338__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this31626,other31627){
var self__ = this;
var this31626__$1 = this;
return (((!((other31627 == null)))) && ((((this31626__$1.constructor === other31627.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31626__$1.block,other31627.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31626__$1.t,other31627.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31626__$1.flakes,other31627.flakes)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31626__$1.rhs,other31627.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31626__$1.config,other31627.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31626__$1.__extmap,other31627.__extmap)))))))))))))));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5352__auto__,k__5353__auto__){
var self__ = this;
var this__5352__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$flakes,null,cljs.core.cst$kw$rhs,null], null), null),k__5353__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5352__auto____$1),self__.__meta),k__5353__auto__);
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5353__auto__)),null));
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5349__auto__,k31625){
var self__ = this;
var this__5349__auto____$1 = this;
var G__31655 = k31625;
var G__31655__$1 = (((G__31655 instanceof cljs.core.Keyword))?G__31655.fqn:null);
switch (G__31655__$1) {
case "block":
case "t":
case "flakes":
case "rhs":
case "config":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k31625);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5350__auto__,k__5351__auto__,G__31624){
var self__ = this;
var this__5350__auto____$1 = this;
var pred__31656 = cljs.core.keyword_identical_QMARK_;
var expr__31657 = k__5351__auto__;
if(cljs.core.truth_((function (){var G__31659 = cljs.core.cst$kw$block;
var G__31660 = expr__31657;
return (pred__31656.cljs$core$IFn$_invoke$arity$2 ? pred__31656.cljs$core$IFn$_invoke$arity$2(G__31659,G__31660) : pred__31656.call(null,G__31659,G__31660));
})())){
return (new fluree.db.index.DataNode(G__31624,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__31661 = cljs.core.cst$kw$t;
var G__31662 = expr__31657;
return (pred__31656.cljs$core$IFn$_invoke$arity$2 ? pred__31656.cljs$core$IFn$_invoke$arity$2(G__31661,G__31662) : pred__31656.call(null,G__31661,G__31662));
})())){
return (new fluree.db.index.DataNode(self__.block,G__31624,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__31663 = cljs.core.cst$kw$flakes;
var G__31664 = expr__31657;
return (pred__31656.cljs$core$IFn$_invoke$arity$2 ? pred__31656.cljs$core$IFn$_invoke$arity$2(G__31663,G__31664) : pred__31656.call(null,G__31663,G__31664));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,G__31624,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__31665 = cljs.core.cst$kw$rhs;
var G__31666 = expr__31657;
return (pred__31656.cljs$core$IFn$_invoke$arity$2 ? pred__31656.cljs$core$IFn$_invoke$arity$2(G__31665,G__31666) : pred__31656.call(null,G__31665,G__31666));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,G__31624,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__31667 = cljs.core.cst$kw$config;
var G__31668 = expr__31657;
return (pred__31656.cljs$core$IFn$_invoke$arity$2 ? pred__31656.cljs$core$IFn$_invoke$arity$2(G__31667,G__31668) : pred__31656.call(null,G__31667,G__31668));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,G__31624,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5351__auto__,G__31624),null));
}
}
}
}
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5355__auto__){
var self__ = this;
var this__5355__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$flakes,self__.flakes,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5341__auto__,G__31624){
var self__ = this;
var this__5341__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,G__31624,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5347__auto__,entry__5348__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5348__auto__)){
return this__5347__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5347__auto____$1,entry__5348__auto__);
}
}));

(fluree.db.index.DataNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$flakes,cljs.core.cst$sym$rhs,cljs.core.cst$sym$config], null);
}));

(fluree.db.index.DataNode.cljs$lang$type = true);

(fluree.db.index.DataNode.cljs$lang$ctorPrSeq = (function (this__5388__auto__){
return (new cljs.core.List(null,"fluree.db.index/DataNode",null,(1),null));
}));

(fluree.db.index.DataNode.cljs$lang$ctorPrWriter = (function (this__5388__auto__,writer__5389__auto__){
return cljs.core._write(writer__5389__auto__,"fluree.db.index/DataNode");
}));

/**
 * Positional factory function for fluree.db.index/DataNode.
 */
fluree.db.index.__GT_DataNode = (function fluree$db$index$__GT_DataNode(block,t,flakes,rhs,config){
return (new fluree.db.index.DataNode(block,t,flakes,rhs,config,null,null,null));
});

/**
 * Factory function for fluree.db.index/DataNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_DataNode = (function fluree$db$index$map__GT_DataNode(G__31628){
var extmap__5384__auto__ = (function (){var G__31669 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__31628,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], 0));
if(cljs.core.record_QMARK_(G__31628)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__31669);
} else {
return G__31669;
}
})();
return (new fluree.db.index.DataNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__31628),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__31628),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(G__31628),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__31628),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__31628),null,cljs.core.not_empty(extmap__5384__auto__),null));
});

/**
 * Creates a new data node
 */
fluree.db.index.data_node = (function fluree$db$index$data_node(block_id,t,flakes,rhs,config){
return fluree.db.index.__GT_DataNode(block_id,t,flakes,rhs,config);
});
fluree.db.index.data_node_QMARK_ = (function fluree$db$index$data_node_QMARK_(node){
return (node instanceof fluree.db.index.DataNode);
});
