// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__33237 = arguments.length;
switch (G__33237) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$op,operation,cljs.core.cst$kw$req_DASH_id,req_id,cljs.core.cst$kw$timestamp,fluree.db.util.core.current_time_millis(),cljs.core.cst$kw$timeout,timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__33240 = arguments.length;
switch (G__33240) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__15165__auto___33293 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_33271){
var state_val_33272 = (state_33271[(1)]);
if((state_val_33272 === (1))){
var state_33271__$1 = state_33271;
var statearr_33273_33294 = state_33271__$1;
(statearr_33273_33294[(2)] = null);

(statearr_33273_33294[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33272 === (2))){
var _ = (function (){var statearr_33274 = state_33271;
(statearr_33274[(4)] = cljs.core.cons((5),(state_33271[(4)])));

return statearr_33274;
})();
var inst_33248 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_33271__$1 = state_33271;
if(cljs.core.truth_(inst_33248)){
var statearr_33275_33295 = state_33271__$1;
(statearr_33275_33295[(1)] = (6));

} else {
var statearr_33276_33296 = state_33271__$1;
(statearr_33276_33296[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33272 === (3))){
var inst_33269 = (state_33271[(2)]);
var state_33271__$1 = state_33271;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33271__$1,inst_33269);
} else {
if((state_val_33272 === (4))){
var inst_33241 = (state_33271[(2)]);
var inst_33242 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_33241);
var state_33271__$1 = state_33271;
var statearr_33278_33297 = state_33271__$1;
(statearr_33278_33297[(2)] = inst_33242);

(statearr_33278_33297[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33272 === (5))){
var _ = (function (){var statearr_33279 = state_33271;
(statearr_33279[(4)] = cljs.core.rest((state_33271[(4)])));

return statearr_33279;
})();
var state_33271__$1 = state_33271;
var ex33277 = (state_33271__$1[(2)]);
var statearr_33280_33298 = state_33271__$1;
(statearr_33280_33298[(5)] = ex33277);


var statearr_33281_33299 = state_33271__$1;
(statearr_33281_33299[(1)] = (4));

(statearr_33281_33299[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_33272 === (6))){
var inst_33250 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33251 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_connection];
var inst_33252 = cljs.core.PersistentHashMap.fromArrays(inst_33250,inst_33251);
var inst_33253 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_33252);
var inst_33254 = (function(){throw inst_33253})();
var state_33271__$1 = state_33271;
var statearr_33282_33300 = state_33271__$1;
(statearr_33282_33300[(2)] = inst_33254);

(statearr_33282_33300[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33272 === (7))){
var inst_33256 = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_33257 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33258 = [operation,data,pc,opts];
var inst_33259 = (new cljs.core.PersistentVector(null,4,(5),inst_33257,inst_33258,null));
var inst_33260 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_33256,inst_33259);
var inst_33261 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33262 = [operation,data,pc,opts];
var inst_33263 = (new cljs.core.PersistentVector(null,4,(5),inst_33261,inst_33262,null));
var inst_33264 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Put operation on connection req-chan: ",inst_33263], 0));
var state_33271__$1 = (function (){var statearr_33283 = state_33271;
(statearr_33283[(7)] = inst_33260);

return statearr_33283;
})();
var statearr_33284_33301 = state_33271__$1;
(statearr_33284_33301[(2)] = inst_33264);

(statearr_33284_33301[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33272 === (8))){
var inst_33266 = (state_33271[(2)]);
var _ = (function (){var statearr_33285 = state_33271;
(statearr_33285[(4)] = cljs.core.rest((state_33271[(4)])));

return statearr_33285;
})();
var state_33271__$1 = state_33271;
var statearr_33286_33302 = state_33271__$1;
(statearr_33286_33302[(2)] = inst_33266);

(statearr_33286_33302[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__15091__auto__ = null;
var fluree$db$operations$state_machine__15091__auto____0 = (function (){
var statearr_33287 = [null,null,null,null,null,null,null,null];
(statearr_33287[(0)] = fluree$db$operations$state_machine__15091__auto__);

(statearr_33287[(1)] = (1));

return statearr_33287;
});
var fluree$db$operations$state_machine__15091__auto____1 = (function (state_33271){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_33271);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e33288){var ex__15094__auto__ = e33288;
var statearr_33289_33303 = state_33271;
(statearr_33289_33303[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_33271[(4)]))){
var statearr_33290_33304 = state_33271;
(statearr_33290_33304[(1)] = cljs.core.first((state_33271[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__33305 = state_33271;
state_33271 = G__33305;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$operations$state_machine__15091__auto__ = function(state_33271){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__15091__auto____1.call(this,state_33271);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__15091__auto____0;
fluree$db$operations$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__15091__auto____1;
return fluree$db$operations$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_33291 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_33291[(6)] = c__15165__auto___33293);

return statearr_33291;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__33307 = arguments.length;
switch (G__33307) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__33308){
var map__33309 = p__33308;
var map__33309__$1 = cljs.core.__destructure_map(map__33309);
var opts = map__33309__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33309__$1,cljs.core.cst$kw$snapshot_QMARK_);
var map__33310 = session;
var map__33310__$1 = cljs.core.__destructure_map(map__33310);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33310__$1,cljs.core.cst$kw$dbid);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33310__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33310__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$delete_DASH_ledger,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$ledger_DASH_id,dbid,cljs.core.cst$kw$snapshot_QMARK_,snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__5774__auto__ = [];
var len__5768__auto___33337 = arguments.length;
var i__5769__auto___33338 = (0);
while(true){
if((i__5769__auto___33338 < len__5768__auto___33337)){
args__5774__auto__.push((arguments[i__5769__auto___33338]));

var G__33339 = (i__5769__auto___33338 + (1));
i__5769__auto___33338 = G__33339;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__33314){
var vec__33315 = p__33314;
var map__33318 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33315,(0),null);
var map__33318__$1 = cljs.core.__destructure_map(map__33318);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33318__$1,cljs.core.cst$kw$toBlock);
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33318__$1,cljs.core.cst$kw$toTime);
var opts = vec__33315;
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_33330){
var state_val_33331 = (state_33330[(1)]);
if((state_val_33331 === (1))){
var inst_33320 = session;
var inst_33321 = cljs.core.__destructure_map(inst_33320);
var inst_33322 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33321,cljs.core.cst$kw$network);
var inst_33323 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33321,cljs.core.cst$kw$dbid);
var inst_33324 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33321,cljs.core.cst$kw$conn);
var inst_33325 = [cljs.core.cst$kw$network,cljs.core.cst$kw$ledger_DASH_id,cljs.core.cst$kw$toBlock,cljs.core.cst$kw$toTime];
var inst_33326 = [inst_33322,inst_33323,toBlock,toTime];
var inst_33327 = cljs.core.PersistentHashMap.fromArrays(inst_33325,inst_33326);
var inst_33328 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_33324,cljs.core.cst$kw$garbage,inst_33327);
var state_33330__$1 = state_33330;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33330__$1,inst_33328);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__15091__auto__ = null;
var fluree$db$operations$state_machine__15091__auto____0 = (function (){
var statearr_33332 = [null,null,null,null,null,null,null];
(statearr_33332[(0)] = fluree$db$operations$state_machine__15091__auto__);

(statearr_33332[(1)] = (1));

return statearr_33332;
});
var fluree$db$operations$state_machine__15091__auto____1 = (function (state_33330){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_33330);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e33333){var ex__15094__auto__ = e33333;
var statearr_33334_33340 = state_33330;
(statearr_33334_33340[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_33330[(4)]))){
var statearr_33335_33341 = state_33330;
(statearr_33335_33341[(1)] = cljs.core.first((state_33330[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__33342 = state_33330;
state_33330 = G__33342;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$operations$state_machine__15091__auto__ = function(state_33330){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__15091__auto____1.call(this,state_33330);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__15091__auto____0;
fluree$db$operations$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__15091__auto____1;
return fluree$db$operations$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_33336 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_33336[(6)] = c__15165__auto__);

return statearr_33336;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq33312){
var G__33313 = cljs.core.first(seq33312);
var seq33312__$1 = cljs.core.next(seq33312);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33313,seq33312__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__33343 = session;
var map__33343__$1 = cljs.core.__destructure_map(map__33343);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33343__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33343__$1,cljs.core.cst$kw$dbid);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33343__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$snapshot_DASH_ledger,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$cmd,cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsigned_DASH_cmd,unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_stats,ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_list,null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Sending transaction async: ",tx_map], 0));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$tx,tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__33345 = arguments.length;
switch (G__33345) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__33346 = opts;
var map__33346__$1 = cljs.core.__destructure_map(map__33346);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33346__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33346__$1,cljs.core.cst$kw$jwt);
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__5045__auto__ = auth;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscribe to: ",cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt], 0));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$subscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsbuscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null));
});
