// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e34617){var e = e34617;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__34618_SHARP_){
var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__34618_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__34618_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__34618_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__34618_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (((cljs.core.not(key_as_var)) && (((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("_id",key)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__34619_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__34619_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__34620_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__34620_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__5043__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__5045__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__34625 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34625,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34625,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__34621_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__34621_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$object_DASH_fn], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__5043__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__5043__auto__;
}
})())){
var vec__34628 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34628,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34628,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__5045__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__34622_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__34622_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$recur], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__34623_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__34623_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__34624_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__34624_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$search,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$rel,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$opts,cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34631_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__34631_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5802__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5802__auto__)){
var var$__$1 = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5802__auto__ = (function (){var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var var$ = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (add_amount > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fuel;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__5043__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5802__auto__ = (function (){var G__34632 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__34632) : intersecting_vars.call(null,G__34632));
})();
if(cljs.core.truth_(temp__5802__auto__)){
var key_replace = temp__5802__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__34635,optional_QMARK_,fuel,max_fuel){
var map__34636 = p__34635;
var map__34636__$1 = cljs.core.__destructure_map(map__34636);
var res = map__34636__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34636__$1,cljs.core.cst$kw$vars);
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_34702){
var state_val_34703 = (state_34702[(1)]);
if((state_val_34703 === (7))){
var inst_34691 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34692 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_34693 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34692,clause);
var inst_34694 = [null,inst_34693];
var inst_34695 = (new cljs.core.PersistentVector(null,2,(5),inst_34691,inst_34694,null));
var state_34702__$1 = state_34702;
var statearr_34704_34732 = state_34702__$1;
(statearr_34704_34732[(2)] = inst_34695);

(statearr_34704_34732[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34703 === (1))){
var state_34702__$1 = state_34702;
var statearr_34705_34733 = state_34702__$1;
(statearr_34705_34733[(2)] = null);

(statearr_34705_34733[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34703 === (4))){
var inst_34637 = (state_34702[(2)]);
var state_34702__$1 = state_34702;
var statearr_34706_34734 = state_34702__$1;
(statearr_34706_34734[(2)] = inst_34637);

(statearr_34706_34734[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34703 === (15))){
var inst_34680 = (state_34702[(2)]);
var inst_34681 = fluree.db.util.async.throw_err(inst_34680);
var inst_34682 = cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(inst_34681);
var inst_34683 = cljs.core.count(inst_34682);
var inst_34684 = fluree.db.query.analytical.add_fuel(inst_34683,fuel,max_fuel);
var inst_34685 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34686 = [inst_34681,r];
var inst_34687 = (new cljs.core.PersistentVector(null,2,(5),inst_34685,inst_34686,null));
var state_34702__$1 = (function (){var statearr_34707 = state_34702;
(statearr_34707[(7)] = inst_34684);

return statearr_34707;
})();
var statearr_34708_34735 = state_34702__$1;
(statearr_34708_34735[(2)] = inst_34687);

(statearr_34708_34735[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34703 === (13))){
var inst_34646 = (state_34702[(8)]);
var inst_34659 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_34660 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_34659);
var inst_34661 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_34646);
var inst_34662 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_34661);
var inst_34663 = cljs.core.set(inst_34662);
var inst_34664 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_34660);
var inst_34665 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_34664);
var inst_34666 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34663,inst_34665);
var inst_34667 = (function (){var all_wd = inst_34646;
var optional = inst_34660;
var all_wd_vars = inst_34663;
var all_vars = inst_34666;
return (function (p1__34633_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__34633_SHARP_) : all_vars.call(null,p1__34633_SHARP_));
});
})();
var inst_34668 = cljs.core.keys(vars);
var inst_34669 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_34667,inst_34668);
var inst_34670 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_34669);
var inst_34671 = cljs.core.set(inst_34670);
var inst_34672 = (function (){var all_wd = inst_34646;
var optional = inst_34660;
var all_wd_vars = inst_34663;
var all_vars = inst_34666;
var intersecting_vars = inst_34671;
return (function (p1__34634_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__34634_SHARP_);
});
})();
var inst_34673 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_34672,inst_34646);
var inst_34674 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_34673);
var inst_34675 = fluree.db.query.analytical.select_from_tuples(inst_34674,res);
var inst_34676 = fluree.db.query.analytical.replace_vars_wikidata(inst_34646,inst_34671,vars);
var inst_34677 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_34671,inst_34666);
var inst_34678 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_34676,inst_34674,inst_34675,inst_34677,inst_34660);
var state_34702__$1 = state_34702;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34702__$1,(15),inst_34678);
} else {
if((state_val_34703 === (6))){
var inst_34647 = (state_34702[(9)]);
var inst_34645 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_34646 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_34645);
var inst_34647__$1 = optional_QMARK_;
var state_34702__$1 = (function (){var statearr_34709 = state_34702;
(statearr_34709[(9)] = inst_34647__$1);

(statearr_34709[(8)] = inst_34646);

return statearr_34709;
})();
if(cljs.core.truth_(inst_34647__$1)){
var statearr_34710_34736 = state_34702__$1;
(statearr_34710_34736[(1)] = (9));

} else {
var statearr_34711_34737 = state_34702__$1;
(statearr_34711_34737[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34703 === (3))){
var inst_34700 = (state_34702[(2)]);
var state_34702__$1 = state_34702;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34702__$1,inst_34700);
} else {
if((state_val_34703 === (12))){
var inst_34655 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34656 = [null,r];
var inst_34657 = (new cljs.core.PersistentVector(null,2,(5),inst_34655,inst_34656,null));
var state_34702__$1 = state_34702;
var statearr_34712_34738 = state_34702__$1;
(statearr_34712_34738[(2)] = inst_34657);

(statearr_34712_34738[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34703 === (2))){
var _ = (function (){var statearr_34713 = state_34702;
(statearr_34713[(4)] = cljs.core.cons((5),(state_34702[(4)])));

return statearr_34713;
})();
var inst_34643 = (r == null);
var state_34702__$1 = state_34702;
if(cljs.core.truth_(inst_34643)){
var statearr_34714_34739 = state_34702__$1;
(statearr_34714_34739[(1)] = (6));

} else {
var statearr_34715_34740 = state_34702__$1;
(statearr_34715_34740[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34703 === (11))){
var inst_34653 = (state_34702[(2)]);
var state_34702__$1 = state_34702;
if(cljs.core.truth_(inst_34653)){
var statearr_34717_34741 = state_34702__$1;
(statearr_34717_34741[(1)] = (12));

} else {
var statearr_34718_34742 = state_34702__$1;
(statearr_34718_34742[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34703 === (9))){
var inst_34646 = (state_34702[(8)]);
var inst_34649 = cljs.core.empty_QMARK_(inst_34646);
var inst_34650 = (!(inst_34649));
var state_34702__$1 = state_34702;
var statearr_34719_34743 = state_34702__$1;
(statearr_34719_34743[(2)] = inst_34650);

(statearr_34719_34743[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34703 === (5))){
var _ = (function (){var statearr_34720 = state_34702;
(statearr_34720[(4)] = cljs.core.rest((state_34702[(4)])));

return statearr_34720;
})();
var state_34702__$1 = state_34702;
var ex34716 = (state_34702__$1[(2)]);
var statearr_34721_34744 = state_34702__$1;
(statearr_34721_34744[(5)] = ex34716);


if((ex34716 instanceof Error)){
var statearr_34722_34745 = state_34702__$1;
(statearr_34722_34745[(1)] = (4));

(statearr_34722_34745[(5)] = null);

} else {
throw ex34716;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34703 === (14))){
var inst_34689 = (state_34702[(2)]);
var state_34702__$1 = state_34702;
var statearr_34723_34746 = state_34702__$1;
(statearr_34723_34746[(2)] = inst_34689);

(statearr_34723_34746[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34703 === (10))){
var inst_34647 = (state_34702[(9)]);
var state_34702__$1 = state_34702;
var statearr_34724_34747 = state_34702__$1;
(statearr_34724_34747[(2)] = inst_34647);

(statearr_34724_34747[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34703 === (8))){
var inst_34697 = (state_34702[(2)]);
var _ = (function (){var statearr_34725 = state_34702;
(statearr_34725[(4)] = cljs.core.rest((state_34702[(4)])));

return statearr_34725;
})();
var state_34702__$1 = state_34702;
var statearr_34726_34748 = state_34702__$1;
(statearr_34726_34748[(2)] = inst_34697);

(statearr_34726_34748[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__15091__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__15091__auto____0 = (function (){
var statearr_34727 = [null,null,null,null,null,null,null,null,null,null];
(statearr_34727[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__15091__auto__);

(statearr_34727[(1)] = (1));

return statearr_34727;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__15091__auto____1 = (function (state_34702){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_34702);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e34728){var ex__15094__auto__ = e34728;
var statearr_34729_34749 = state_34702;
(statearr_34729_34749[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_34702[(4)]))){
var statearr_34730_34750 = state_34702;
(statearr_34730_34750[(1)] = cljs.core.first((state_34702[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__34751 = state_34702;
state_34702 = G__34751;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__15091__auto__ = function(state_34702){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__15091__auto____1.call(this,state_34702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__15091__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__15091__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_34731 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_34731[(6)] = c__15165__auto__);

return statearr_34731;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__34753 = arguments.length;
switch (G__34753) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_34847){
var state_val_34848 = (state_34847[(1)]);
if((state_val_34848 === (7))){
var inst_34760 = (state_34847[(7)]);
var inst_34770 = clojure.string.starts_with_QMARK_(inst_34760,"$fdb");
var state_34847__$1 = state_34847;
if(inst_34770){
var statearr_34849_34898 = state_34847__$1;
(statearr_34849_34898[(1)] = (9));

} else {
var statearr_34850_34899 = state_34847__$1;
(statearr_34850_34899[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34848 === (20))){
var state_34847__$1 = state_34847;
var statearr_34851_34900 = state_34847__$1;
(statearr_34851_34900[(2)] = null);

(statearr_34851_34900[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34848 === (27))){
var inst_34810 = (state_34847[(8)]);
var state_34847__$1 = state_34847;
var statearr_34852_34901 = state_34847__$1;
(statearr_34852_34901[(2)] = inst_34810);

(statearr_34852_34901[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34848 === (1))){
var state_34847__$1 = state_34847;
var statearr_34853_34902 = state_34847__$1;
(statearr_34853_34902[(2)] = null);

(statearr_34853_34902[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34848 === (24))){
var inst_34833 = (state_34847[(2)]);
var state_34847__$1 = state_34847;
var statearr_34854_34903 = state_34847__$1;
(statearr_34854_34903[(2)] = inst_34833);

(statearr_34854_34903[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34848 === (4))){
var inst_34754 = (state_34847[(2)]);
var state_34847__$1 = state_34847;
var statearr_34855_34904 = state_34847__$1;
(statearr_34855_34904[(2)] = inst_34754);

(statearr_34855_34904[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34848 === (15))){
var inst_34777 = (state_34847[(9)]);
var inst_34783 = (state_34847[(2)]);
var inst_34784 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34785 = cljs.core.PersistentVector.EMPTY;
var inst_34786 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_34787 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34785,inst_34786);
var inst_34788 = [inst_34777,inst_34787];
var inst_34789 = (new cljs.core.PersistentVector(null,2,(5),inst_34784,inst_34788,null));
var state_34847__$1 = (function (){var statearr_34856 = state_34847;
(statearr_34856[(10)] = inst_34783);

return statearr_34856;
})();
var statearr_34857_34905 = state_34847__$1;
(statearr_34857_34905[(2)] = inst_34789);

(statearr_34857_34905[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34848 === (21))){
var inst_34836 = (state_34847[(2)]);
var state_34847__$1 = state_34847;
var statearr_34858_34906 = state_34847__$1;
(statearr_34858_34906[(2)] = inst_34836);

(statearr_34858_34906[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34848 === (13))){
var inst_34777 = (state_34847[(9)]);
var inst_34780 = (function(){throw inst_34777})();
var state_34847__$1 = state_34847;
var statearr_34859_34907 = state_34847__$1;
(statearr_34859_34907[(2)] = inst_34780);

(statearr_34859_34907[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34848 === (22))){
var inst_34801 = (state_34847[(11)]);
var inst_34799 = (state_34847[(12)]);
var inst_34803 = fluree.db.query.analytical.parse_block_from_source(inst_34799);
var inst_34804 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34805 = [cljs.core.cst$kw$sources,inst_34801];
var inst_34806 = (new cljs.core.PersistentVector(null,2,(5),inst_34804,inst_34805,null));
var inst_34807 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_34806);
var state_34847__$1 = (function (){var statearr_34860 = state_34847;
(statearr_34860[(13)] = inst_34803);

return statearr_34860;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34847__$1,(25),inst_34807);
} else {
if((state_val_34848 === (29))){
var inst_34814 = (state_34847[(2)]);
var inst_34815 = fluree.db.util.async.throw_err(inst_34814);
var state_34847__$1 = state_34847;
var statearr_34861_34908 = state_34847__$1;
(statearr_34861_34908[(2)] = inst_34815);

(statearr_34861_34908[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34848 === (6))){
var inst_34763 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34764 = cljs.core.PersistentVector.EMPTY;
var inst_34765 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_34766 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34764,inst_34765);
var inst_34767 = [db,inst_34766];
var inst_34768 = (new cljs.core.PersistentVector(null,2,(5),inst_34763,inst_34767,null));
var state_34847__$1 = state_34847;
var statearr_34862_34909 = state_34847__$1;
(statearr_34862_34909[(2)] = inst_34768);

(statearr_34862_34909[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34848 === (28))){
var inst_34818 = (state_34847[(2)]);
var inst_34819 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34820 = cljs.core.PersistentVector.EMPTY;
var inst_34821 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_34822 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34820,inst_34821);
var inst_34823 = [inst_34818,inst_34822];
var inst_34824 = (new cljs.core.PersistentVector(null,2,(5),inst_34819,inst_34823,null));
var state_34847__$1 = state_34847;
var statearr_34863_34910 = state_34847__$1;
(statearr_34863_34910[(2)] = inst_34824);

(statearr_34863_34910[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34848 === (25))){
var inst_34803 = (state_34847[(13)]);
var inst_34809 = (state_34847[(2)]);
var inst_34810 = fluree.db.util.async.throw_err(inst_34809);
var state_34847__$1 = (function (){var statearr_34864 = state_34847;
(statearr_34864[(8)] = inst_34810);

return statearr_34864;
})();
if(cljs.core.truth_(inst_34803)){
var statearr_34865_34911 = state_34847__$1;
(statearr_34865_34911[(1)] = (26));

} else {
var statearr_34866_34912 = state_34847__$1;
(statearr_34866_34912[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34848 === (17))){
var state_34847__$1 = state_34847;
var statearr_34867_34913 = state_34847__$1;
(statearr_34867_34913[(1)] = (19));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34848 === (3))){
var inst_34845 = (state_34847[(2)]);
var state_34847__$1 = state_34847;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34847__$1,inst_34845);
} else {
if((state_val_34848 === (12))){
var inst_34777 = (state_34847[(9)]);
var inst_34776 = (state_34847[(2)]);
var inst_34777__$1 = fluree.db.util.async.throw_err(inst_34776);
var inst_34778 = fluree.db.util.core.exception_QMARK_(inst_34777__$1);
var state_34847__$1 = (function (){var statearr_34869 = state_34847;
(statearr_34869[(9)] = inst_34777__$1);

return statearr_34869;
})();
if(inst_34778){
var statearr_34870_34914 = state_34847__$1;
(statearr_34870_34914[(1)] = (13));

} else {
var statearr_34871_34915 = state_34847__$1;
(statearr_34871_34915[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34848 === (2))){
var inst_34760 = (state_34847[(7)]);
var _ = (function (){var statearr_34872 = state_34847;
(statearr_34872[(4)] = cljs.core.cons((5),(state_34847[(4)])));

return statearr_34872;
})();
var inst_34760__$1 = cljs.core.first(clause);
var inst_34761 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_34760__$1);
var state_34847__$1 = (function (){var statearr_34873 = state_34847;
(statearr_34873[(7)] = inst_34760__$1);

return statearr_34873;
})();
if(inst_34761){
var statearr_34874_34916 = state_34847__$1;
(statearr_34874_34916[(1)] = (6));

} else {
var statearr_34875_34917 = state_34847__$1;
(statearr_34875_34917[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34848 === (23))){
var inst_34760 = (state_34847[(7)]);
var inst_34826 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34760)," is not supported in Fluree"].join('');
var inst_34827 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34828 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_34829 = cljs.core.PersistentHashMap.fromArrays(inst_34827,inst_34828);
var inst_34830 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34826,inst_34829);
var inst_34831 = (function(){throw inst_34830})();
var state_34847__$1 = state_34847;
var statearr_34876_34918 = state_34847__$1;
(statearr_34876_34918[(2)] = inst_34831);

(statearr_34876_34918[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34848 === (19))){
var inst_34760 = (state_34847[(7)]);
var inst_34801 = (state_34847[(11)]);
var inst_34798 = fluree.db.query.analytical.isolate_source_name(inst_34760);
var inst_34799 = fluree.db.query.analytical.isolate_source_block(inst_34760);
var inst_34800 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_34798);
var inst_34801__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_34800);
var state_34847__$1 = (function (){var statearr_34877 = state_34847;
(statearr_34877[(11)] = inst_34801__$1);

(statearr_34877[(12)] = inst_34799);

return statearr_34877;
})();
if(cljs.core.truth_(inst_34801__$1)){
var statearr_34878_34919 = state_34847__$1;
(statearr_34878_34919[(1)] = (22));

} else {
var statearr_34879_34920 = state_34847__$1;
(statearr_34879_34920[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34848 === (11))){
var inst_34840 = (state_34847[(2)]);
var state_34847__$1 = state_34847;
var statearr_34881_34921 = state_34847__$1;
(statearr_34881_34921[(2)] = inst_34840);

(statearr_34881_34921[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34848 === (9))){
var inst_34760 = (state_34847[(7)]);
var inst_34772 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_34760,(4));
var inst_34773 = fluree.db.query.analytical.parse_block_from_source(inst_34772);
var inst_34774 = fluree.db.time_travel.as_of_block(db,inst_34773);
var state_34847__$1 = state_34847;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34847__$1,(12),inst_34774);
} else {
if((state_val_34848 === (5))){
var _ = (function (){var statearr_34882 = state_34847;
(statearr_34882[(4)] = cljs.core.rest((state_34847[(4)])));

return statearr_34882;
})();
var state_34847__$1 = state_34847;
var ex34880 = (state_34847__$1[(2)]);
var statearr_34883_34922 = state_34847__$1;
(statearr_34883_34922[(5)] = ex34880);


if((ex34880 instanceof Error)){
var statearr_34884_34923 = state_34847__$1;
(statearr_34884_34923[(1)] = (4));

(statearr_34884_34923[(5)] = null);

} else {
throw ex34880;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34848 === (14))){
var state_34847__$1 = state_34847;
var statearr_34885_34924 = state_34847__$1;
(statearr_34885_34924[(2)] = null);

(statearr_34885_34924[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34848 === (26))){
var inst_34810 = (state_34847[(8)]);
var inst_34803 = (state_34847[(13)]);
var inst_34812 = fluree.db.time_travel.as_of_block(inst_34810,inst_34803);
var state_34847__$1 = state_34847;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34847__$1,(29),inst_34812);
} else {
if((state_val_34848 === (16))){
var inst_34793 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34794 = ["$wd",clause];
var inst_34795 = (new cljs.core.PersistentVector(null,2,(5),inst_34793,inst_34794,null));
var state_34847__$1 = state_34847;
var statearr_34886_34925 = state_34847__$1;
(statearr_34886_34925[(2)] = inst_34795);

(statearr_34886_34925[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34848 === (10))){
var inst_34760 = (state_34847[(7)]);
var inst_34791 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_34760);
var state_34847__$1 = state_34847;
if(inst_34791){
var statearr_34887_34926 = state_34847__$1;
(statearr_34887_34926[(1)] = (16));

} else {
var statearr_34888_34927 = state_34847__$1;
(statearr_34888_34927[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34848 === (18))){
var inst_34838 = (state_34847[(2)]);
var state_34847__$1 = state_34847;
var statearr_34889_34928 = state_34847__$1;
(statearr_34889_34928[(2)] = inst_34838);

(statearr_34889_34928[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34848 === (8))){
var inst_34842 = (state_34847[(2)]);
var _ = (function (){var statearr_34890 = state_34847;
(statearr_34890[(4)] = cljs.core.rest((state_34847[(4)])));

return statearr_34890;
})();
var state_34847__$1 = state_34847;
var statearr_34891_34929 = state_34847__$1;
(statearr_34891_34929[(2)] = inst_34842);

(statearr_34891_34929[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__15091__auto__ = null;
var fluree$db$query$analytical$state_machine__15091__auto____0 = (function (){
var statearr_34892 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34892[(0)] = fluree$db$query$analytical$state_machine__15091__auto__);

(statearr_34892[(1)] = (1));

return statearr_34892;
});
var fluree$db$query$analytical$state_machine__15091__auto____1 = (function (state_34847){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_34847);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e34893){var ex__15094__auto__ = e34893;
var statearr_34894_34930 = state_34847;
(statearr_34894_34930[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_34847[(4)]))){
var statearr_34895_34931 = state_34847;
(statearr_34895_34931[(1)] = cljs.core.first((state_34847[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__34932 = state_34847;
state_34847 = G__34932;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__15091__auto__ = function(state_34847){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__15091__auto____1.call(this,state_34847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__15091__auto____0;
fluree$db$query$analytical$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__15091__auto____1;
return fluree$db$query$analytical$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_34896 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_34896[(6)] = c__15165__auto__);

return statearr_34896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__34933){
var vec__34934 = p__34933;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34934,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34934,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34937_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$done,cljs.core.cst$kw$followed,cljs.core.cst$kw$all],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__34937_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__34941 = subjects;
var vec__34942 = G__34941;
var seq__34943 = cljs.core.seq(vec__34942);
var first__34944 = cljs.core.first(seq__34943);
var seq__34943__$1 = cljs.core.next(seq__34943);
var subject = first__34944;
var r = seq__34943__$1;
var acc = expanded_map;
var G__34941__$1 = G__34941;
var acc__$1 = acc;
while(true){
var vec__34948 = G__34941__$1;
var seq__34949 = cljs.core.seq(vec__34948);
var first__34950 = cljs.core.first(seq__34949);
var seq__34949__$1 = cljs.core.next(seq__34949);
var subject__$1 = first__34950;
var r__$1 = seq__34949__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null)))){
var G__34951 = r__$1;
var G__34952 = acc__$2;
G__34941__$1 = G__34951;
acc__$1 = G__34952;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__34941__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__34948,seq__34949,first__34950,seq__34949__$1,subject__$1,r__$1,acc__$2,G__34941,vec__34942,seq__34943,first__34944,seq__34943__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__5045__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$all], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null),((function (G__34941__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__34948,seq__34949,first__34950,seq__34949__$1,subject__$1,r__$1,acc__$2,G__34941,vec__34942,seq__34943,first__34944,seq__34943__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__34941__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__34948,seq__34949,first__34950,seq__34949__$1,subject__$1,r__$1,acc__$2,G__34941,vec__34942,seq__34943,first__34944,seq__34943__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$done], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),((function (G__34941__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__34948,seq__34949,first__34950,seq__34949__$1,subject__$1,r__$1,acc__$2,G__34941,vec__34942,seq__34943,first__34944,seq__34943__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__34941__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__34948,seq__34949,first__34950,seq__34949__$1,subject__$1,r__$1,acc__$2,G__34941,vec__34942,seq__34943,first__34944,seq__34943__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__34941__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__34948,seq__34949,first__34950,seq__34949__$1,subject__$1,r__$1,acc__$2,G__34941,vec__34942,seq__34943,first__34944,seq__34943__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__34953 = r__$1;
var G__34954 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null),true);
G__34941__$1 = G__34953;
acc__$1 = G__34954;
continue;
} else {
var G__34955 = subjects;
var G__34956 = acc_STAR_;
G__34941__$1 = G__34955;
acc__$1 = G__34956;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,cljs.core.cst$kw$followed], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34957_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__34957_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_35048){
var state_val_35049 = (state_35048[(1)]);
if((state_val_35049 === (7))){
var state_35048__$1 = state_35048;
var statearr_35050_35096 = state_35048__$1;
(statearr_35050_35096[(2)] = (100));

(statearr_35050_35096[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (20))){
var inst_34997 = (state_35048[(7)]);
var state_35048__$1 = state_35048;
var statearr_35051_35097 = state_35048__$1;
(statearr_35051_35097[(2)] = inst_34997);

(statearr_35051_35097[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (1))){
var state_35048__$1 = state_35048;
var statearr_35052_35098 = state_35048__$1;
(statearr_35052_35098[(2)] = null);

(statearr_35052_35098[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (24))){
var inst_34969 = (state_35048[(8)]);
var inst_35035 = (state_35048[(9)]);
var inst_35034 = (state_35048[(10)]);
var inst_35036 = (state_35048[(11)]);
var inst_35039 = (function (){var max_depth = inst_34969;
var recur_map__$1 = inst_35035;
var subjects = inst_35034;
var tuples = inst_35036;
return (function (p1__34958_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__34958_SHARP_)],null));
});
})();
var inst_35040 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_35039,inst_35036);
var inst_35041 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_35040);
var state_35048__$1 = state_35048;
var statearr_35053_35099 = state_35048__$1;
(statearr_35053_35099[(2)] = inst_35041);

(statearr_35053_35099[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (4))){
var inst_34959 = (state_35048[(2)]);
var state_35048__$1 = state_35048;
var statearr_35054_35100 = state_35048__$1;
(statearr_35054_35100[(2)] = inst_34959);

(statearr_35054_35100[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (15))){
var inst_34982 = (state_35048[(12)]);
var inst_34993 = cljs.core.PersistentVector.EMPTY;
var inst_34994 = cljs.core.seq(inst_34982);
var inst_34995 = cljs.core.first(inst_34994);
var inst_34996 = cljs.core.next(inst_34994);
var inst_34997 = inst_34993;
var inst_34998 = inst_34982;
var state_35048__$1 = (function (){var statearr_35055 = state_35048;
(statearr_35055[(7)] = inst_34997);

(statearr_35055[(13)] = inst_34995);

(statearr_35055[(14)] = inst_34996);

(statearr_35055[(15)] = inst_34998);

return statearr_35055;
})();
var statearr_35056_35101 = state_35048__$1;
(statearr_35056_35101[(2)] = null);

(statearr_35056_35101[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (21))){
var inst_35018 = (state_35048[(2)]);
var state_35048__$1 = state_35048;
var statearr_35057_35102 = state_35048__$1;
(statearr_35057_35102[(2)] = inst_35018);

(statearr_35057_35102[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (13))){
var inst_35031 = (state_35048[(2)]);
var state_35048__$1 = state_35048;
var statearr_35058_35103 = state_35048__$1;
(statearr_35058_35103[(2)] = inst_35031);

(statearr_35058_35103[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (22))){
var inst_34997 = (state_35048[(7)]);
var inst_35005 = (state_35048[(16)]);
var inst_35012 = (state_35048[(2)]);
var inst_35013 = fluree.db.util.async.throw_err(inst_35012);
var inst_35014 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_34997,inst_35013);
var inst_34997__$1 = inst_35014;
var inst_34998 = inst_35005;
var state_35048__$1 = (function (){var statearr_35059 = state_35048;
(statearr_35059[(7)] = inst_34997__$1);

(statearr_35059[(15)] = inst_34998);

return statearr_35059;
})();
var statearr_35060_35104 = state_35048__$1;
(statearr_35060_35104[(2)] = null);

(statearr_35060_35104[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (6))){
var inst_34965 = (state_35048[(17)]);
var state_35048__$1 = state_35048;
var statearr_35061_35105 = state_35048__$1;
(statearr_35061_35105[(2)] = inst_34965);

(statearr_35061_35105[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (25))){
var inst_35043 = (state_35048[(2)]);
var _ = (function (){var statearr_35062 = state_35048;
(statearr_35062[(4)] = cljs.core.rest((state_35048[(4)])));

return statearr_35062;
})();
var state_35048__$1 = state_35048;
var statearr_35063_35106 = state_35048__$1;
(statearr_35063_35106[(2)] = inst_35043);

(statearr_35063_35106[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (17))){
var inst_35004 = (state_35048[(18)]);
var inst_34998 = (state_35048[(15)]);
var inst_35003 = cljs.core.seq(inst_34998);
var inst_35004__$1 = cljs.core.first(inst_35003);
var inst_35005 = cljs.core.next(inst_35003);
var state_35048__$1 = (function (){var statearr_35064 = state_35048;
(statearr_35064[(18)] = inst_35004__$1);

(statearr_35064[(16)] = inst_35005);

return statearr_35064;
})();
if(cljs.core.truth_(inst_35004__$1)){
var statearr_35065_35107 = state_35048__$1;
(statearr_35065_35107[(1)] = (19));

} else {
var statearr_35066_35108 = state_35048__$1;
(statearr_35066_35108[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (3))){
var inst_35046 = (state_35048[(2)]);
var state_35048__$1 = state_35048;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35048__$1,inst_35046);
} else {
if((state_val_35049 === (12))){
var inst_34971 = (state_35048[(19)]);
var inst_34982 = (state_35048[(12)]);
var inst_34977 = cljs.core.vals(inst_34971);
var inst_34978 = cljs.core.flatten(inst_34977);
var inst_34979 = cljs.core.set(inst_34978);
var inst_34980 = cljs.core.keys(inst_34971);
var inst_34981 = cljs.core.set(inst_34980);
var inst_34982__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_34979,inst_34981);
var inst_34983 = cljs.core.empty_QMARK_(inst_34982__$1);
var state_35048__$1 = (function (){var statearr_35067 = state_35048;
(statearr_35067[(12)] = inst_34982__$1);

return statearr_35067;
})();
if(inst_34983){
var statearr_35068_35109 = state_35048__$1;
(statearr_35068_35109[(1)] = (14));

} else {
var statearr_35069_35110 = state_35048__$1;
(statearr_35069_35110[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (2))){
var inst_34965 = (state_35048[(17)]);
var _ = (function (){var statearr_35070 = state_35048;
(statearr_35070[(4)] = cljs.core.cons((5),(state_35048[(4)])));

return statearr_35070;
})();
var inst_34965__$1 = depth;
var state_35048__$1 = (function (){var statearr_35071 = state_35048;
(statearr_35071[(17)] = inst_34965__$1);

return statearr_35071;
})();
if(cljs.core.truth_(inst_34965__$1)){
var statearr_35072_35111 = state_35048__$1;
(statearr_35072_35111[(1)] = (6));

} else {
var statearr_35073_35112 = state_35048__$1;
(statearr_35073_35112[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (23))){
var inst_35036 = (state_35048[(11)]);
var state_35048__$1 = state_35048;
var statearr_35074_35113 = state_35048__$1;
(statearr_35074_35113[(2)] = inst_35036);

(statearr_35074_35113[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (19))){
var inst_35004 = (state_35048[(18)]);
var inst_35007 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35008 = [inst_35004,predicate];
var inst_35009 = (new cljs.core.PersistentVector(null,2,(5),inst_35007,inst_35008,null));
var inst_35010 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_35009);
var state_35048__$1 = state_35048;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35048__$1,(22),inst_35010);
} else {
if((state_val_35049 === (11))){
var inst_34971 = (state_35048[(19)]);
var state_35048__$1 = state_35048;
var statearr_35076_35114 = state_35048__$1;
(statearr_35076_35114[(2)] = inst_34971);

(statearr_35076_35114[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (9))){
var inst_34972 = (state_35048[(20)]);
var inst_34969 = (state_35048[(8)]);
var inst_34974 = (inst_34972 >= inst_34969);
var state_35048__$1 = state_35048;
if(cljs.core.truth_(inst_34974)){
var statearr_35077_35115 = state_35048__$1;
(statearr_35077_35115[(1)] = (11));

} else {
var statearr_35078_35116 = state_35048__$1;
(statearr_35078_35116[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (5))){
var _ = (function (){var statearr_35079 = state_35048;
(statearr_35079[(4)] = cljs.core.rest((state_35048[(4)])));

return statearr_35079;
})();
var state_35048__$1 = state_35048;
var ex35075 = (state_35048__$1[(2)]);
var statearr_35080_35117 = state_35048__$1;
(statearr_35080_35117[(5)] = ex35075);


if((ex35075 instanceof Error)){
var statearr_35081_35118 = state_35048__$1;
(statearr_35081_35118[(1)] = (4));

(statearr_35081_35118[(5)] = null);

} else {
throw ex35075;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (14))){
var inst_34971 = (state_35048[(19)]);
var state_35048__$1 = state_35048;
var statearr_35082_35119 = state_35048__$1;
(statearr_35082_35119[(2)] = inst_34971);

(statearr_35082_35119[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (16))){
var inst_35029 = (state_35048[(2)]);
var state_35048__$1 = state_35048;
var statearr_35083_35120 = state_35048__$1;
(statearr_35083_35120[(2)] = inst_35029);

(statearr_35083_35120[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (10))){
var inst_35035 = (state_35048[(9)]);
var inst_35034 = (state_35048[(10)]);
var inst_35033 = (state_35048[(2)]);
var inst_35034__$1 = cljs.core.keys(inst_35033);
var inst_35035__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_35034__$1,inst_35033);
var inst_35036 = fluree.db.query.analytical.recur_map__GT_tuples(inst_35034__$1,inst_35035__$1);
var state_35048__$1 = (function (){var statearr_35084 = state_35048;
(statearr_35084[(9)] = inst_35035__$1);

(statearr_35084[(10)] = inst_35034__$1);

(statearr_35084[(11)] = inst_35036);

return statearr_35084;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_35085_35121 = state_35048__$1;
(statearr_35085_35121[(1)] = (23));

} else {
var statearr_35086_35122 = state_35048__$1;
(statearr_35086_35122[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (18))){
var inst_34972 = (state_35048[(20)]);
var inst_34971 = (state_35048[(19)]);
var inst_35020 = (state_35048[(2)]);
var inst_35021 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35022 = [(0),(2)];
var inst_35023 = (new cljs.core.PersistentVector(null,2,(5),inst_35021,inst_35022,null));
var inst_35024 = fluree.db.query.analytical.get_ns_arrays(inst_35023,inst_35020);
var inst_35025 = fluree.db.query.analytical.tuples__GT_map(inst_34971,inst_35024);
var inst_35026 = (inst_34972 + (1));
var inst_34971__$1 = inst_35025;
var inst_34972__$1 = inst_35026;
var state_35048__$1 = (function (){var statearr_35087 = state_35048;
(statearr_35087[(20)] = inst_34972__$1);

(statearr_35087[(19)] = inst_34971__$1);

return statearr_35087;
})();
var statearr_35088_35123 = state_35048__$1;
(statearr_35088_35123[(2)] = null);

(statearr_35088_35123[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35049 === (8))){
var inst_34969 = (state_35048[(2)]);
var inst_34970 = recur_map;
var inst_34971 = inst_34970;
var inst_34972 = (1);
var state_35048__$1 = (function (){var statearr_35089 = state_35048;
(statearr_35089[(20)] = inst_34972);

(statearr_35089[(19)] = inst_34971);

(statearr_35089[(8)] = inst_34969);

return statearr_35089;
})();
var statearr_35090_35124 = state_35048__$1;
(statearr_35090_35124[(2)] = null);

(statearr_35090_35124[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__15091__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__15091__auto____0 = (function (){
var statearr_35091 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35091[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__15091__auto__);

(statearr_35091[(1)] = (1));

return statearr_35091;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__15091__auto____1 = (function (state_35048){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_35048);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e35092){var ex__15094__auto__ = e35092;
var statearr_35093_35125 = state_35048;
(statearr_35093_35125[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_35048[(4)]))){
var statearr_35094_35126 = state_35048;
(statearr_35094_35126[(1)] = cljs.core.first((state_35048[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__35127 = state_35048;
state_35048 = G__35127;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__15091__auto__ = function(state_35048){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__15091__auto____1.call(this,state_35048);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__15091__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__15091__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_35095 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_35095[(6)] = c__15165__auto__);

return statearr_35095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__35128,clause,fuel,max_fuel){
var map__35129 = p__35128;
var map__35129__$1 = cljs.core.__destructure_map(map__35129);
var res = map__35129__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35129__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35129__$1,cljs.core.cst$kw$tuples);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35129__$1,cljs.core.cst$kw$vars);
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_35240){
var state_val_35241 = (state_35240[(1)]);
if((state_val_35241 === (7))){
var inst_35146 = (state_35240[(7)]);
var state_35240__$1 = state_35240;
var statearr_35242_35295 = state_35240__$1;
(statearr_35242_35295[(2)] = inst_35146);

(statearr_35242_35295[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35241 === (20))){
var inst_35174 = (state_35240[(8)]);
var inst_35205 = typeof inst_35174 === 'number';
var state_35240__$1 = state_35240;
if(cljs.core.truth_(inst_35205)){
var statearr_35243_35296 = state_35240__$1;
(statearr_35243_35296[(1)] = (22));

} else {
var statearr_35244_35297 = state_35240__$1;
(statearr_35244_35297[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35241 === (27))){
var inst_35220 = (state_35240[(2)]);
var state_35240__$1 = state_35240;
var statearr_35245_35298 = state_35240__$1;
(statearr_35245_35298[(2)] = inst_35220);

(statearr_35245_35298[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35241 === (1))){
var state_35240__$1 = state_35240;
var statearr_35246_35299 = state_35240__$1;
(statearr_35246_35299[(2)] = null);

(statearr_35246_35299[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35241 === (24))){
var inst_35222 = (state_35240[(2)]);
var state_35240__$1 = state_35240;
var statearr_35247_35300 = state_35240__$1;
(statearr_35247_35300[(2)] = inst_35222);

(statearr_35247_35300[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35241 === (4))){
var inst_35130 = (state_35240[(2)]);
var state_35240__$1 = state_35240;
var statearr_35248_35301 = state_35240__$1;
(statearr_35248_35301[(2)] = inst_35130);

(statearr_35248_35301[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35241 === (15))){
var inst_35188 = (state_35240[(2)]);
var inst_35189 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_35190 = fluree.db.query.analytical.variable_QMARK_(inst_35189);
var state_35240__$1 = (function (){var statearr_35249 = state_35240;
(statearr_35249[(9)] = inst_35188);

return statearr_35249;
})();
if(cljs.core.truth_(inst_35190)){
var statearr_35250_35302 = state_35240__$1;
(statearr_35250_35302[(1)] = (16));

} else {
var statearr_35251_35303 = state_35240__$1;
(statearr_35251_35303[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35241 === (21))){
var inst_35177 = (state_35240[(10)]);
var inst_35176 = (state_35240[(11)]);
var inst_35147 = (state_35240[(12)]);
var inst_35224 = (state_35240[(2)]);
var inst_35225 = fluree.db.query.analytical.tuples__GT_recur(db,inst_35177,inst_35224,inst_35147,inst_35176);
var state_35240__$1 = state_35240;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35240__$1,(28),inst_35225);
} else {
if((state_val_35241 === (13))){
var inst_35156 = (state_35240[(13)]);
var inst_35180 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35156)].join('');
var inst_35181 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_35182 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_35183 = cljs.core.PersistentHashMap.fromArrays(inst_35181,inst_35182);
var inst_35184 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_35180,inst_35183);
var inst_35185 = (function(){throw inst_35184})();
var state_35240__$1 = state_35240;
var statearr_35252_35304 = state_35240__$1;
(statearr_35252_35304[(2)] = inst_35185);

(statearr_35252_35304[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35241 === (22))){
var inst_35172 = (state_35240[(14)]);
var inst_35174 = (state_35240[(8)]);
var inst_35207 = cljs.core.PersistentHashMap.EMPTY;
var inst_35208 = cljs.core.flatten(inst_35172);
var inst_35209 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_35207,inst_35174,inst_35208);
var state_35240__$1 = state_35240;
var statearr_35253_35305 = state_35240__$1;
(statearr_35253_35305[(2)] = inst_35209);

(statearr_35253_35305[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35241 === (6))){
var inst_35158 = (state_35240[(15)]);
var state_35240__$1 = state_35240;
var statearr_35254_35306 = state_35240__$1;
(statearr_35254_35306[(2)] = inst_35158);

(statearr_35254_35306[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35241 === (28))){
var inst_35227 = (state_35240[(2)]);
var inst_35228 = fluree.db.util.async.throw_err(inst_35227);
var state_35240__$1 = state_35240;
var statearr_35255_35307 = state_35240__$1;
(statearr_35255_35307[(2)] = inst_35228);

(statearr_35255_35307[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35241 === (25))){
var inst_35172 = (state_35240[(14)]);
var inst_35168 = (state_35240[(16)]);
var inst_35213 = cljs.core.PersistentHashMap.EMPTY;
var inst_35214 = cljs.core.first(inst_35168);
var inst_35215 = cljs.core.first(inst_35214);
var inst_35216 = cljs.core.flatten(inst_35172);
var inst_35217 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_35213,inst_35215,inst_35216);
var state_35240__$1 = state_35240;
var statearr_35256_35308 = state_35240__$1;
(statearr_35256_35308[(2)] = inst_35217);

(statearr_35256_35308[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35241 === (17))){
var inst_35156 = (state_35240[(13)]);
var inst_35193 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35156)].join('');
var inst_35194 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_35195 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_35196 = cljs.core.PersistentHashMap.fromArrays(inst_35194,inst_35195);
var inst_35197 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_35193,inst_35196);
var inst_35198 = (function(){throw inst_35197})();
var state_35240__$1 = state_35240;
var statearr_35257_35309 = state_35240__$1;
(statearr_35257_35309[(2)] = inst_35198);

(statearr_35257_35309[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35241 === (3))){
var inst_35238 = (state_35240[(2)]);
var state_35240__$1 = state_35240;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35240__$1,inst_35238);
} else {
if((state_val_35241 === (12))){
var inst_35143 = (state_35240[(17)]);
var inst_35231 = (state_35240[(2)]);
var inst_35232 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_35233 = cljs.core.keys(inst_35143);
var inst_35234 = [inst_35233,vars,inst_35231];
var inst_35235 = cljs.core.PersistentHashMap.fromArrays(inst_35232,inst_35234);
var _ = (function (){var statearr_35258 = state_35240;
(statearr_35258[(4)] = cljs.core.rest((state_35240[(4)])));

return statearr_35258;
})();
var state_35240__$1 = state_35240;
var statearr_35259_35310 = state_35240__$1;
(statearr_35259_35310[(2)] = inst_35235);

(statearr_35259_35310[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35241 === (2))){
var inst_35146 = (state_35240[(7)]);
var inst_35143 = (state_35240[(17)]);
var inst_35158 = (state_35240[(15)]);
var inst_35147 = (state_35240[(12)]);
var _ = (function (){var statearr_35260 = state_35240;
(statearr_35260[(4)] = cljs.core.cons((5),(state_35240[(4)])));

return statearr_35260;
})();
var inst_35140 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_35141 = cljs.core.__destructure_map(inst_35140);
var inst_35142 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35141,cljs.core.cst$kw$search);
var inst_35143__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35141,cljs.core.cst$kw$rel);
var inst_35144 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35141,cljs.core.cst$kw$opts);
var inst_35145 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_35146__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_35144);
var inst_35147__$1 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_35144);
var inst_35149 = (function (){var map__35136 = inst_35141;
var search = inst_35142;
var rel = inst_35143__$1;
var opts = inst_35144;
var common_keys = inst_35145;
var object_fn = inst_35146__$1;
var recur_depth = inst_35147__$1;
return (function (p__35148,common_key){
var vec__35261 = p__35148;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35261,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35261,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__35264 = cljs.core._EQ_;
var expr__35265 = idx_of;
if(cljs.core.truth_((pred__35264.cljs$core$IFn$_invoke$arity$2 ? pred__35264.cljs$core$IFn$_invoke$arity$2((0),expr__35265) : pred__35264.call(null,(0),expr__35265)))){
return cljs.core.cst$kw$subject_DASH_fn;
} else {
if(cljs.core.truth_((pred__35264.cljs$core$IFn$_invoke$arity$2 ? pred__35264.cljs$core$IFn$_invoke$arity$2((1),expr__35265) : pred__35264.call(null,(1),expr__35265)))){
return cljs.core.cst$kw$predicate_DASH_fn;
} else {
if(cljs.core.truth_((pred__35264.cljs$core$IFn$_invoke$arity$2 ? pred__35264.cljs$core$IFn$_invoke$arity$2((2),expr__35265) : pred__35264.call(null,(2),expr__35265)))){
return cljs.core.cst$kw$object_DASH_fn;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__35265)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__5043__auto__ = (!(single_v_QMARK_));
if(and__5043__auto__){
var and__5043__auto____$1 = object_fn;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_35150 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35151 = cljs.core.PersistentHashMap.EMPTY;
var inst_35152 = [inst_35151,inst_35142];
var inst_35153 = (new cljs.core.PersistentVector(null,2,(5),inst_35150,inst_35152,null));
var inst_35154 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_35149,inst_35153,inst_35145);
var inst_35155 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35154,(0),null);
var inst_35156 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35154,(1),null);
var inst_35157 = [cljs.core.cst$kw$object_DASH_fn];
var inst_35158__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_35155);
var state_35240__$1 = (function (){var statearr_35267 = state_35240;
(statearr_35267[(18)] = inst_35157);

(statearr_35267[(7)] = inst_35146__$1);

(statearr_35267[(13)] = inst_35156);

(statearr_35267[(17)] = inst_35143__$1);

(statearr_35267[(15)] = inst_35158__$1);

(statearr_35267[(12)] = inst_35147__$1);

return statearr_35267;
})();
if(cljs.core.truth_(inst_35158__$1)){
var statearr_35268_35311 = state_35240__$1;
(statearr_35268_35311[(1)] = (6));

} else {
var statearr_35269_35312 = state_35240__$1;
(statearr_35269_35312[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35241 === (23))){
var inst_35174 = (state_35240[(8)]);
var inst_35211 = cljs.core.coll_QMARK_(inst_35174);
var state_35240__$1 = state_35240;
if(inst_35211){
var statearr_35270_35313 = state_35240__$1;
(statearr_35270_35313[(1)] = (25));

} else {
var statearr_35271_35314 = state_35240__$1;
(statearr_35271_35314[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35241 === (19))){
var inst_35172 = (state_35240[(14)]);
var inst_35202 = cljs.core.PersistentHashMap.EMPTY;
var inst_35203 = fluree.db.query.analytical.tuples__GT_map(inst_35202,inst_35172);
var state_35240__$1 = state_35240;
var statearr_35272_35315 = state_35240__$1;
(statearr_35272_35315[(2)] = inst_35203);

(statearr_35272_35315[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35241 === (11))){
var inst_35172 = (state_35240[(14)]);
var state_35240__$1 = state_35240;
var statearr_35274_35316 = state_35240__$1;
(statearr_35274_35316[(2)] = inst_35172);

(statearr_35274_35316[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35241 === (9))){
var inst_35168 = (state_35240[(16)]);
var inst_35143 = (state_35240[(17)]);
var inst_35147 = (state_35240[(12)]);
var inst_35167 = (state_35240[(2)]);
var inst_35168__$1 = fluree.db.util.async.throw_err(inst_35167);
var inst_35169 = cljs.core.count(inst_35168__$1);
var inst_35170 = fluree.db.query.analytical.add_fuel(inst_35169,fuel,max_fuel);
var inst_35171 = cljs.core.vals(inst_35143);
var inst_35172 = fluree.db.query.analytical.get_ns_arrays(inst_35171,inst_35168__$1);
var state_35240__$1 = (function (){var statearr_35275 = state_35240;
(statearr_35275[(14)] = inst_35172);

(statearr_35275[(19)] = inst_35170);

(statearr_35275[(16)] = inst_35168__$1);

return statearr_35275;
})();
if(cljs.core.truth_(inst_35147)){
var statearr_35276_35317 = state_35240__$1;
(statearr_35276_35317[(1)] = (10));

} else {
var statearr_35277_35318 = state_35240__$1;
(statearr_35277_35318[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35241 === (5))){
var _ = (function (){var statearr_35278 = state_35240;
(statearr_35278[(4)] = cljs.core.rest((state_35240[(4)])));

return statearr_35278;
})();
var state_35240__$1 = state_35240;
var ex35273 = (state_35240__$1[(2)]);
var statearr_35279_35319 = state_35240__$1;
(statearr_35279_35319[(5)] = ex35273);


if((ex35273 instanceof Error)){
var statearr_35280_35320 = state_35240__$1;
(statearr_35280_35320[(1)] = (4));

(statearr_35280_35320[(5)] = null);

} else {
throw ex35273;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35241 === (14))){
var state_35240__$1 = state_35240;
var statearr_35281_35321 = state_35240__$1;
(statearr_35281_35321[(2)] = null);

(statearr_35281_35321[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35241 === (26))){
var state_35240__$1 = state_35240;
var statearr_35282_35322 = state_35240__$1;
(statearr_35282_35322[(2)] = null);

(statearr_35282_35322[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35241 === (16))){
var state_35240__$1 = state_35240;
var statearr_35283_35323 = state_35240__$1;
(statearr_35283_35323[(2)] = null);

(statearr_35283_35323[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35241 === (10))){
var inst_35177 = (state_35240[(10)]);
var inst_35156 = (state_35240[(13)]);
var inst_35174 = cljs.core.first(inst_35156);
var inst_35175 = cljs.core.first(clause);
var inst_35176 = fluree.db.query.analytical.variable_QMARK_(inst_35175);
var inst_35177__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_35156,(1));
var inst_35178 = fluree.db.query.analytical.variable_QMARK_(inst_35177__$1);
var state_35240__$1 = (function (){var statearr_35284 = state_35240;
(statearr_35284[(10)] = inst_35177__$1);

(statearr_35284[(8)] = inst_35174);

(statearr_35284[(11)] = inst_35176);

return statearr_35284;
})();
if(cljs.core.truth_(inst_35178)){
var statearr_35285_35324 = state_35240__$1;
(statearr_35285_35324[(1)] = (13));

} else {
var statearr_35286_35325 = state_35240__$1;
(statearr_35286_35325[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35241 === (18))){
var inst_35176 = (state_35240[(11)]);
var inst_35200 = (state_35240[(2)]);
var state_35240__$1 = (function (){var statearr_35287 = state_35240;
(statearr_35287[(20)] = inst_35200);

return statearr_35287;
})();
if(cljs.core.truth_(inst_35176)){
var statearr_35288_35326 = state_35240__$1;
(statearr_35288_35326[(1)] = (19));

} else {
var statearr_35289_35327 = state_35240__$1;
(statearr_35289_35327[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35241 === (8))){
var inst_35157 = (state_35240[(18)]);
var inst_35156 = (state_35240[(13)]);
var inst_35162 = (state_35240[(2)]);
var inst_35163 = [inst_35162];
var inst_35164 = cljs.core.PersistentHashMap.fromArrays(inst_35157,inst_35163);
var inst_35165 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_35156,inst_35164);
var state_35240__$1 = state_35240;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35240__$1,(9),inst_35165);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__15091__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__15091__auto____0 = (function (){
var statearr_35290 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35290[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__15091__auto__);

(statearr_35290[(1)] = (1));

return statearr_35290;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__15091__auto____1 = (function (state_35240){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_35240);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e35291){var ex__15094__auto__ = e35291;
var statearr_35292_35328 = state_35240;
(statearr_35292_35328[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_35240[(4)]))){
var statearr_35293_35329 = state_35240;
(statearr_35293_35329[(1)] = cljs.core.first((state_35240[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__35330 = state_35240;
state_35240 = G__35330;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__15091__auto__ = function(state_35240){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__15091__auto____1.call(this,state_35240);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__15091__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__15091__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_35294 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_35294[(6)] = c__15165__auto__);

return statearr_35294;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__35331,res,clause){
var map__35332 = p__35331;
var map__35332__$1 = cljs.core.__destructure_map(map__35332);
var db = map__35332__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35332__$1,cljs.core.cst$kw$conn);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35332__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35332__$1,cljs.core.cst$kw$dbid);
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_35441){
var state_val_35442 = (state_35441[(1)]);
if((state_val_35442 === (7))){
var inst_35341 = (state_35441[(7)]);
var state_35441__$1 = state_35441;
var statearr_35443_35484 = state_35441__$1;
(statearr_35443_35484[(2)] = inst_35341);

(statearr_35443_35484[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35442 === (20))){
var state_35441__$1 = state_35441;
var statearr_35444_35485 = state_35441__$1;
(statearr_35444_35485[(2)] = null);

(statearr_35444_35485[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35442 === (1))){
var state_35441__$1 = state_35441;
var statearr_35445_35486 = state_35441__$1;
(statearr_35445_35486[(2)] = null);

(statearr_35445_35486[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35442 === (24))){
var inst_35343 = (state_35441[(8)]);
var inst_35414 = (state_35441[(2)]);
var inst_35415 = fluree.db.flake.sid__GT_cid(inst_35414);
var inst_35416 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$name,inst_35415);
var inst_35417 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_35418 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35419 = [inst_35343];
var inst_35420 = (new cljs.core.PersistentVector(null,1,(5),inst_35418,inst_35419,null));
var inst_35421 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35422 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35423 = [inst_35416];
var inst_35424 = (new cljs.core.PersistentVector(null,1,(5),inst_35422,inst_35423,null));
var inst_35425 = [inst_35424];
var inst_35426 = (new cljs.core.PersistentVector(null,1,(5),inst_35421,inst_35425,null));
var inst_35427 = cljs.core.PersistentHashMap.EMPTY;
var inst_35428 = [inst_35420,inst_35426,inst_35427];
var inst_35429 = cljs.core.PersistentHashMap.fromArrays(inst_35417,inst_35428);
var state_35441__$1 = state_35441;
var statearr_35446_35487 = state_35441__$1;
(statearr_35446_35487[(2)] = inst_35429);

(statearr_35446_35487[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35442 === (4))){
var inst_35334 = (state_35441[(2)]);
var state_35441__$1 = state_35441;
var statearr_35447_35488 = state_35441__$1;
(statearr_35447_35488[(2)] = inst_35334);

(statearr_35447_35488[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35442 === (15))){
var inst_35343 = (state_35441[(8)]);
var inst_35341 = (state_35441[(7)]);
var inst_35362 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_35363 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_35364 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35365 = [inst_35341];
var inst_35366 = (new cljs.core.PersistentVector(null,1,(5),inst_35364,inst_35365,null));
var inst_35367 = (function (){var subject_var = inst_35341;
var object_var = inst_35343;
var min_sid = inst_35362;
var max_sid = (0);
return (function (p1__35333_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__35333_SHARP_);
});
})();
var inst_35368 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_35362,(0));
var inst_35369 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_35367,inst_35368);
var inst_35370 = cljs.core.PersistentHashMap.EMPTY;
var inst_35371 = [inst_35366,inst_35369,inst_35370];
var inst_35372 = cljs.core.PersistentHashMap.fromArrays(inst_35363,inst_35371);
var state_35441__$1 = state_35441;
var statearr_35448_35489 = state_35441__$1;
(statearr_35448_35489[(2)] = inst_35372);

(statearr_35448_35489[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35442 === (21))){
var inst_35432 = (state_35441[(2)]);
var state_35441__$1 = state_35441;
var statearr_35449_35490 = state_35441__$1;
(statearr_35449_35490[(2)] = inst_35432);

(statearr_35449_35490[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35442 === (13))){
var inst_35343 = (state_35441[(8)]);
var state_35441__$1 = state_35441;
if(cljs.core.truth_(inst_35343)){
var statearr_35450_35491 = state_35441__$1;
(statearr_35450_35491[(1)] = (19));

} else {
var statearr_35451_35492 = state_35441__$1;
(statearr_35451_35492[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35442 === (22))){
var inst_35405 = (state_35441[(9)]);
var state_35441__$1 = state_35441;
var statearr_35452_35493 = state_35441__$1;
(statearr_35452_35493[(2)] = inst_35405);

(statearr_35452_35493[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35442 === (6))){
var inst_35343 = (state_35441[(8)]);
var state_35441__$1 = state_35441;
var statearr_35453_35494 = state_35441__$1;
(statearr_35453_35494[(2)] = inst_35343);

(statearr_35453_35494[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35442 === (25))){
var inst_35411 = (state_35441[(2)]);
var inst_35412 = fluree.db.util.async.throw_err(inst_35411);
var state_35441__$1 = state_35441;
var statearr_35454_35495 = state_35441__$1;
(statearr_35454_35495[(2)] = inst_35412);

(statearr_35454_35495[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35442 === (17))){
var inst_35402 = (state_35441[(2)]);
var state_35441__$1 = state_35441;
var statearr_35455_35496 = state_35441__$1;
(statearr_35455_35496[(2)] = inst_35402);

(statearr_35455_35496[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35442 === (3))){
var inst_35439 = (state_35441[(2)]);
var state_35441__$1 = state_35441;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35441__$1,inst_35439);
} else {
if((state_val_35442 === (12))){
var inst_35356 = ["_tx",null,"_block",null];
var inst_35357 = (new cljs.core.PersistentArrayMap(null,2,inst_35356,null));
var inst_35358 = (new cljs.core.PersistentHashSet(null,inst_35357,null));
var inst_35359 = cljs.core.last(clause);
var inst_35360 = (inst_35358.cljs$core$IFn$_invoke$arity$1 ? inst_35358.cljs$core$IFn$_invoke$arity$1(inst_35359) : inst_35358.call(null,inst_35359));
var state_35441__$1 = state_35441;
if(cljs.core.truth_(inst_35360)){
var statearr_35456_35497 = state_35441__$1;
(statearr_35456_35497[(1)] = (15));

} else {
var statearr_35457_35498 = state_35441__$1;
(statearr_35457_35498[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35442 === (2))){
var inst_35341 = (state_35441[(7)]);
var _ = (function (){var statearr_35458 = state_35441;
(statearr_35458[(4)] = cljs.core.cons((5),(state_35441[(4)])));

return statearr_35458;
})();
var inst_35340 = cljs.core.first(clause);
var inst_35341__$1 = fluree.db.query.analytical.variable_QMARK_(inst_35340);
var inst_35342 = cljs.core.last(clause);
var inst_35343 = fluree.db.query.analytical.variable_QMARK_(inst_35342);
var state_35441__$1 = (function (){var statearr_35459 = state_35441;
(statearr_35459[(8)] = inst_35343);

(statearr_35459[(7)] = inst_35341__$1);

return statearr_35459;
})();
if(cljs.core.truth_(inst_35341__$1)){
var statearr_35460_35499 = state_35441__$1;
(statearr_35460_35499[(1)] = (6));

} else {
var statearr_35461_35500 = state_35441__$1;
(statearr_35461_35500[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35442 === (23))){
var inst_35405 = (state_35441[(9)]);
var inst_35409 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_35405);
var state_35441__$1 = state_35441;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35441__$1,(25),inst_35409);
} else {
if((state_val_35442 === (19))){
var inst_35405 = (state_35441[(9)]);
var inst_35405__$1 = cljs.core.first(clause);
var inst_35406 = typeof inst_35405__$1 === 'number';
var state_35441__$1 = (function (){var statearr_35462 = state_35441;
(statearr_35462[(9)] = inst_35405__$1);

return statearr_35462;
})();
if(cljs.core.truth_(inst_35406)){
var statearr_35463_35501 = state_35441__$1;
(statearr_35463_35501[(1)] = (22));

} else {
var statearr_35464_35502 = state_35441__$1;
(statearr_35464_35502[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35442 === (11))){
var inst_35436 = (state_35441[(2)]);
var _ = (function (){var statearr_35466 = state_35441;
(statearr_35466[(4)] = cljs.core.rest((state_35441[(4)])));

return statearr_35466;
})();
var state_35441__$1 = state_35441;
var statearr_35467_35503 = state_35441__$1;
(statearr_35467_35503[(2)] = inst_35436);

(statearr_35467_35503[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35442 === (9))){
var inst_35349 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_35350 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_35351 = cljs.core.PersistentHashMap.fromArrays(inst_35349,inst_35350);
var inst_35352 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_35351);
var inst_35353 = (function(){throw inst_35352})();
var state_35441__$1 = state_35441;
var statearr_35468_35504 = state_35441__$1;
(statearr_35468_35504[(2)] = inst_35353);

(statearr_35468_35504[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35442 === (5))){
var _ = (function (){var statearr_35469 = state_35441;
(statearr_35469[(4)] = cljs.core.rest((state_35441[(4)])));

return statearr_35469;
})();
var state_35441__$1 = state_35441;
var ex35465 = (state_35441__$1[(2)]);
var statearr_35470_35505 = state_35441__$1;
(statearr_35470_35505[(5)] = ex35465);


if((ex35465 instanceof Error)){
var statearr_35471_35506 = state_35441__$1;
(statearr_35471_35506[(1)] = (4));

(statearr_35471_35506[(5)] = null);

} else {
throw ex35465;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35442 === (14))){
var inst_35434 = (state_35441[(2)]);
var state_35441__$1 = state_35441;
var statearr_35472_35507 = state_35441__$1;
(statearr_35472_35507[(2)] = inst_35434);

(statearr_35472_35507[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35442 === (16))){
var inst_35375 = (state_35441[(10)]);
var inst_35378 = (state_35441[(11)]);
var inst_35377 = (state_35441[(12)]);
var inst_35374 = cljs.core.last(clause);
var inst_35375__$1 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$partition,inst_35374);
var inst_35376 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_35377__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35376,inst_35375__$1);
var inst_35378__$1 = fluree.db.flake.min_subject_id(inst_35375__$1);
var inst_35379 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35380 = [inst_35377__$1];
var inst_35381 = (new cljs.core.PersistentVector(null,1,(5),inst_35379,inst_35380,null));
var inst_35382 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35383 = [inst_35378__$1];
var inst_35384 = (new cljs.core.PersistentVector(null,1,(5),inst_35382,inst_35383,null));
var inst_35385 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_35381,cljs.core._LT__EQ_,inst_35384);
var state_35441__$1 = (function (){var statearr_35473 = state_35441;
(statearr_35473[(10)] = inst_35375__$1);

(statearr_35473[(11)] = inst_35378__$1);

(statearr_35473[(12)] = inst_35377__$1);

return statearr_35473;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35441__$1,(18),inst_35385);
} else {
if((state_val_35442 === (10))){
var inst_35341 = (state_35441[(7)]);
var state_35441__$1 = state_35441;
if(cljs.core.truth_(inst_35341)){
var statearr_35474_35508 = state_35441__$1;
(statearr_35474_35508[(1)] = (12));

} else {
var statearr_35475_35509 = state_35441__$1;
(statearr_35475_35509[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35442 === (18))){
var inst_35343 = (state_35441[(8)]);
var inst_35375 = (state_35441[(10)]);
var inst_35341 = (state_35441[(7)]);
var inst_35378 = (state_35441[(11)]);
var inst_35377 = (state_35441[(12)]);
var inst_35387 = (state_35441[(2)]);
var inst_35388 = fluree.db.util.async.throw_err(inst_35387);
var inst_35389 = (function (){var subject_var = inst_35341;
var object_var = inst_35343;
var partition = inst_35375;
var max_sid = inst_35377;
var min_sid = inst_35378;
var flakes = inst_35388;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_35390 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_35389);
var inst_35391 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_35392 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_35390,inst_35391);
var inst_35393 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_35394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35395 = [inst_35341];
var inst_35396 = (new cljs.core.PersistentVector(null,1,(5),inst_35394,inst_35395,null));
var inst_35397 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_35392,inst_35388);
var inst_35398 = cljs.core.PersistentHashMap.EMPTY;
var inst_35399 = [inst_35396,inst_35397,inst_35398];
var inst_35400 = cljs.core.PersistentHashMap.fromArrays(inst_35393,inst_35399);
var state_35441__$1 = state_35441;
var statearr_35476_35510 = state_35441__$1;
(statearr_35476_35510[(2)] = inst_35400);

(statearr_35476_35510[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35442 === (8))){
var inst_35347 = (state_35441[(2)]);
var state_35441__$1 = state_35441;
if(cljs.core.truth_(inst_35347)){
var statearr_35477_35511 = state_35441__$1;
(statearr_35477_35511[(1)] = (9));

} else {
var statearr_35478_35512 = state_35441__$1;
(statearr_35478_35512[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__15091__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__15091__auto____0 = (function (){
var statearr_35479 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35479[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__15091__auto__);

(statearr_35479[(1)] = (1));

return statearr_35479;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__15091__auto____1 = (function (state_35441){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_35441);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e35480){var ex__15094__auto__ = e35480;
var statearr_35481_35513 = state_35441;
(statearr_35481_35513[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_35441[(4)]))){
var statearr_35482_35514 = state_35441;
(statearr_35482_35514[(1)] = cljs.core.first((state_35441[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__35515 = state_35441;
state_35441 = G__35515;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__15091__auto__ = function(state_35441){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__15091__auto____1.call(this,state_35441);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__15091__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__15091__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_35483 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_35483[(6)] = c__15165__auto__);

return statearr_35483;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__35522 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__35522 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__35522;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__5522__auto__ = (function fluree$db$query$analytical$variance_$_iter__35523(s__35524){
return (new cljs.core.LazySeq(null,(function (){
var s__35524__$1 = s__35524;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__35524__$1);
if(temp__5804__auto__){
var s__35524__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35524__$2)){
var c__5520__auto__ = cljs.core.chunk_first(s__35524__$2);
var size__5521__auto__ = cljs.core.count(c__5520__auto__);
var b__35526 = cljs.core.chunk_buffer(size__5521__auto__);
if((function (){var i__35525 = (0);
while(true){
if((i__35525 < size__5521__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5520__auto__,i__35525);
var delta = (x - mean);
cljs.core.chunk_append(b__35526,(delta * delta));

var G__35528 = (i__35525 + (1));
i__35525 = G__35528;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35526),fluree$db$query$analytical$variance_$_iter__35523(cljs.core.chunk_rest(s__35524__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35526),null);
}
} else {
var x = cljs.core.first(s__35524__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__35523(cljs.core.rest(s__35524__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5522__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__35527 = variance(coll);
return Math.sqrt(G__35527);
});
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$variance,cljs.core.cst$sym$count,cljs.core.cst$sym$median,cljs.core.cst$sym$groupconcat,cljs.core.cst$sym$sum,cljs.core.cst$sym$abs,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$max,cljs.core.cst$sym$count_DASH_distinct,cljs.core.cst$sym$avg,cljs.core.cst$sym$floor,cljs.core.cst$sym$str,cljs.core.cst$sym$stddev,cljs.core.cst$sym$rand,cljs.core.cst$sym$sample],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__5130__auto__ = n;
var y__5131__auto__ = (- n);
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
}),(function() {
var G__35529 = null;
var G__35529__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__35529__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__35529 = function(n,coll){
switch(arguments.length){
case 1:
return G__35529__1.call(this,n);
case 2:
return G__35529__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35529.cljs$core$IFn$_invoke$arity$1 = G__35529__1;
G__35529.cljs$core$IFn$_invoke$arity$2 = G__35529__2;
return G__35529;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__35530 = null;
var G__35530__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__35530__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__35530 = function(n,coll){
switch(arguments.length){
case 1:
return G__35530__1.call(this,n);
case 2:
return G__35530__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35530.cljs$core$IFn$_invoke$arity$1 = G__35530__1;
G__35530.cljs$core$IFn$_invoke$arity$2 = G__35530__2;
return G__35530;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__35531 = null;
var G__35531__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__35531__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__35531 = function(n,coll){
switch(arguments.length){
case 1:
return G__35531__1.call(this,n);
case 2:
return G__35531__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35531.cljs$core$IFn$_invoke$arity$1 = G__35531__1;
G__35531.cljs$core$IFn$_invoke$arity$2 = G__35531__2;
return G__35531;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$as,cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__35532 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$sample,cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35532,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35532,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35532,(2),null);
var agg_fn = (function (){var temp__5802__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5802__auto__)){
var agg_fn = temp__5802__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__35535 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),cljs.core.cst$sym$distinct)));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__35538 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__35538) : agg_fn.call(null,G__35538));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35535,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35535,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$variable,variable,cljs.core.cst$kw$as,as,cljs.core.cst$kw$code,agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__35539 = agg;
var map__35539__$1 = cljs.core.__destructure_map(map__35539);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35539__$1,cljs.core.cst$kw$variable);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35539__$1,cljs.core.cst$kw$as);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35539__$1,cljs.core.cst$kw$code);
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__35541 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35541,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35541,(1),null);
var map__35544 = res__$1;
var map__35544__$1 = cljs.core.__destructure_map(map__35544);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35544__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35544__$1,cljs.core.cst$kw$tuples);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35540_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__35540_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$headers,headers_SINGLEQUOTE_,cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35545_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__35545_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35546_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__35546_SHARP_);
}),a_idxs);
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5802__auto__)){
var b_matched = temp__5802__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__35547_SHARP_,p2__35548_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35547_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__35548_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35549_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__35549_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__35552,row,b_tuple){
var vec__35553 = p__35552;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35553,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35553,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35550_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__35550_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__5045__auto__ = acc;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35551_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__35551_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35556_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),p1__35556_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35557_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__35557_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__35562 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__35564 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__35563 = (function (p1__35558_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__35558_SHARP_);
});
return fexpr__35563(G__35564);
})()),cljs.core.set(b_idxs));
var fexpr__35561 = (function (p1__35559_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__35559_SHARP_);
});
return fexpr__35561(G__35562);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35560_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__35560_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_res)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35565_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__35565_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35566_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__35566_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__35571 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__35573 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__35572 = (function (p1__35567_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__35567_SHARP_);
});
return fexpr__35572(G__35573);
})()),cljs.core.set(b_idxs));
var fexpr__35570 = (function (p1__35568_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__35568_SHARP_);
});
return fexpr__35570(G__35571);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35569_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__35569_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__35575 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35575,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35575,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__35574_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__35574_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__35580 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35580,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35580,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35578_SHARP_){
return fluree.db.util.core.index_of(headers,p1__35578_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__35579_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__35579_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__35583,filters,optional_QMARK_){
var map__35584 = p__35583;
var map__35584__$1 = cljs.core.__destructure_map(map__35584);
var tuple_map = map__35584__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35584__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35584__$1,cljs.core.cst$kw$vars);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35584__$1,cljs.core.cst$kw$tuples);
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__35585 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35585,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35585,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var map__35588 = res;
var map__35588__$1 = cljs.core.__destructure_map(map__35588);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35588__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35588__$1,cljs.core.cst$kw$vars);
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5802__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5802__auto__)){
var valid_var = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_35644){
var state_val_35645 = (state_35644[(1)]);
if((state_val_35645 === (7))){
var inst_35618 = (state_35644[(7)]);
var inst_35616 = (state_35644[(2)]);
var inst_35617 = fluree.db.util.async.throw_err(inst_35616);
var inst_35618__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35617,(0),null);
var inst_35619 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35617,(1),null);
var inst_35620 = (inst_35618__$1 == null);
var state_35644__$1 = (function (){var statearr_35646 = state_35644;
(statearr_35646[(7)] = inst_35618__$1);

(statearr_35646[(8)] = inst_35619);

return statearr_35646;
})();
if(cljs.core.truth_(inst_35620)){
var statearr_35647_35676 = state_35644__$1;
(statearr_35647_35676[(1)] = (8));

} else {
var statearr_35648_35677 = state_35644__$1;
(statearr_35648_35677[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35645 === (1))){
var inst_35596 = optional_clauses;
var inst_35597 = cljs.core.seq(inst_35596);
var inst_35598 = cljs.core.first(inst_35597);
var inst_35599 = cljs.core.next(inst_35597);
var inst_35600 = where_tuples;
var inst_35601 = inst_35596;
var inst_35602 = inst_35600;
var state_35644__$1 = (function (){var statearr_35649 = state_35644;
(statearr_35649[(9)] = inst_35598);

(statearr_35649[(10)] = inst_35602);

(statearr_35649[(11)] = inst_35601);

(statearr_35649[(12)] = inst_35599);

return statearr_35649;
})();
var statearr_35650_35678 = state_35644__$1;
(statearr_35650_35678[(2)] = null);

(statearr_35650_35678[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35645 === (4))){
var inst_35602 = (state_35644[(10)]);
var inst_35608 = (state_35644[(13)]);
var inst_35609 = (state_35644[(14)]);
var inst_35614 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_35602,inst_35608,inst_35609,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_35602,inst_35608,inst_35609,true,fuel,max_fuel,opts));
var state_35644__$1 = state_35644;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35644__$1,(7),inst_35614);
} else {
if((state_val_35645 === (15))){
var state_35644__$1 = state_35644;
var statearr_35651_35679 = state_35644__$1;
(statearr_35651_35679[(2)] = null);

(statearr_35651_35679[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35645 === (13))){
var inst_35635 = (state_35644[(2)]);
var state_35644__$1 = state_35644;
var statearr_35652_35680 = state_35644__$1;
(statearr_35652_35680[(2)] = inst_35635);

(statearr_35652_35680[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35645 === (6))){
var inst_35640 = (state_35644[(2)]);
var state_35644__$1 = state_35644;
var statearr_35653_35681 = state_35644__$1;
(statearr_35653_35681[(2)] = inst_35640);

(statearr_35653_35681[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35645 === (3))){
var inst_35642 = (state_35644[(2)]);
var state_35644__$1 = state_35644;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35644__$1,inst_35642);
} else {
if((state_val_35645 === (12))){
var state_35644__$1 = state_35644;
var statearr_35654_35682 = state_35644__$1;
(statearr_35654_35682[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35645 === (2))){
var inst_35608 = (state_35644[(13)]);
var inst_35601 = (state_35644[(11)]);
var inst_35607 = cljs.core.seq(inst_35601);
var inst_35608__$1 = cljs.core.first(inst_35607);
var inst_35609 = cljs.core.next(inst_35607);
var state_35644__$1 = (function (){var statearr_35656 = state_35644;
(statearr_35656[(13)] = inst_35608__$1);

(statearr_35656[(14)] = inst_35609);

return statearr_35656;
})();
if(cljs.core.truth_(inst_35608__$1)){
var statearr_35657_35683 = state_35644__$1;
(statearr_35657_35683[(1)] = (4));

} else {
var statearr_35658_35684 = state_35644__$1;
(statearr_35658_35684[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35645 === (11))){
var inst_35618 = (state_35644[(7)]);
var inst_35619 = (state_35644[(8)]);
var inst_35601 = inst_35619;
var inst_35602 = inst_35618;
var state_35644__$1 = (function (){var statearr_35659 = state_35644;
(statearr_35659[(10)] = inst_35602);

(statearr_35659[(11)] = inst_35601);

return statearr_35659;
})();
var statearr_35660_35685 = state_35644__$1;
(statearr_35660_35685[(2)] = null);

(statearr_35660_35685[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35645 === (9))){
var inst_35608 = (state_35644[(13)]);
var inst_35624 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(inst_35608);
var state_35644__$1 = state_35644;
if(cljs.core.truth_(inst_35624)){
var statearr_35661_35686 = state_35644__$1;
(statearr_35661_35686[(1)] = (11));

} else {
var statearr_35662_35687 = state_35644__$1;
(statearr_35662_35687[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35645 === (5))){
var inst_35602 = (state_35644[(10)]);
var state_35644__$1 = state_35644;
var statearr_35663_35688 = state_35644__$1;
(statearr_35663_35688[(2)] = inst_35602);

(statearr_35663_35688[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35645 === (14))){
var inst_35602 = (state_35644[(10)]);
var inst_35618 = (state_35644[(7)]);
var inst_35619 = (state_35644[(8)]);
var inst_35629 = fluree.db.query.analytical.left_outer_join(inst_35602,inst_35618);
var inst_35601 = inst_35619;
var inst_35602__$1 = inst_35629;
var state_35644__$1 = (function (){var statearr_35664 = state_35644;
(statearr_35664[(10)] = inst_35602__$1);

(statearr_35664[(11)] = inst_35601);

return statearr_35664;
})();
var statearr_35665_35689 = state_35644__$1;
(statearr_35665_35689[(2)] = null);

(statearr_35665_35689[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35645 === (16))){
var inst_35633 = (state_35644[(2)]);
var state_35644__$1 = state_35644;
var statearr_35667_35690 = state_35644__$1;
(statearr_35667_35690[(2)] = inst_35633);

(statearr_35667_35690[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35645 === (10))){
var inst_35637 = (state_35644[(2)]);
var state_35644__$1 = state_35644;
var statearr_35668_35691 = state_35644__$1;
(statearr_35668_35691[(2)] = inst_35637);

(statearr_35668_35691[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35645 === (8))){
var inst_35602 = (state_35644[(10)]);
var inst_35619 = (state_35644[(8)]);
var tmp35666 = inst_35602;
var inst_35601 = inst_35619;
var inst_35602__$1 = tmp35666;
var state_35644__$1 = (function (){var statearr_35669 = state_35644;
(statearr_35669[(10)] = inst_35602__$1);

(statearr_35669[(11)] = inst_35601);

return statearr_35669;
})();
var statearr_35670_35692 = state_35644__$1;
(statearr_35670_35692[(2)] = null);

(statearr_35670_35692[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__15091__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__15091__auto____0 = (function (){
var statearr_35671 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35671[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__15091__auto__);

(statearr_35671[(1)] = (1));

return statearr_35671;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__15091__auto____1 = (function (state_35644){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_35644);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e35672){var ex__15094__auto__ = e35672;
var statearr_35673_35693 = state_35644;
(statearr_35673_35693[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_35644[(4)]))){
var statearr_35674_35694 = state_35644;
(statearr_35674_35694[(1)] = cljs.core.first((state_35644[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__35695 = state_35644;
state_35644 = G__35695;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__15091__auto__ = function(state_35644){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__15091__auto____1.call(this,state_35644);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__15091__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__15091__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_35675 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_35675[(6)] = c__15165__auto__);

return statearr_35675;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__35697){
var vec__35698 = p__35697;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35698,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35698,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35696_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35696_SHARP_,var_val);
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_,cljs.core.cst$kw$headers,headers_SINGLEQUOTE_], null);
}),res,cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__35702,p__35703,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__35704 = p__35702;
var map__35704__$1 = cljs.core.__destructure_map(map__35704);
var q_map = map__35704__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35704__$1,cljs.core.cst$kw$prefixes);
var map__35705 = p__35703;
var map__35705__$1 = cljs.core.__destructure_map(map__35705);
var res = map__35705__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35705__$1,cljs.core.cst$kw$vars);
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_35942){
var state_val_35943 = (state_35942[(1)]);
if((state_val_35943 === (65))){
var inst_35892 = (state_35942[(7)]);
var inst_35891 = (state_35942[(8)]);
var inst_35903 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35904 = fluree.db.query.analytical.full_text__GT_tuples(inst_35891,res,inst_35892);
var inst_35905 = [inst_35904,r];
var inst_35906 = (new cljs.core.PersistentVector(null,2,(5),inst_35903,inst_35905,null));
var state_35942__$1 = state_35942;
var statearr_35944_36057 = state_35942__$1;
(statearr_35944_36057[(2)] = inst_35906);

(statearr_35944_36057[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (70))){
var inst_35918 = (state_35942[(2)]);
var state_35942__$1 = state_35942;
var statearr_35945_36058 = state_35942__$1;
(statearr_35945_36058[(2)] = inst_35918);

(statearr_35945_36058[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (62))){
var inst_35892 = (state_35942[(7)]);
var inst_35900 = cljs.core.second(inst_35892);
var inst_35901 = clojure.string.starts_with_QMARK_(inst_35900,"fullText:");
var state_35942__$1 = state_35942;
if(inst_35901){
var statearr_35946_36059 = state_35942__$1;
(statearr_35946_36059[(1)] = (65));

} else {
var statearr_35947_36060 = state_35942__$1;
(statearr_35947_36060[(1)] = (66));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (7))){
var inst_35811 = (state_35942[(9)]);
var inst_35810 = cljs.core.count(clause);
var inst_35811__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_35810);
var state_35942__$1 = (function (){var statearr_35948 = state_35942;
(statearr_35948[(9)] = inst_35811__$1);

return statearr_35948;
})();
if(inst_35811__$1){
var statearr_35949_36061 = state_35942__$1;
(statearr_35949_36061[(1)] = (31));

} else {
var statearr_35950_36062 = state_35942__$1;
(statearr_35950_36062[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (59))){
var inst_35925 = (state_35942[(2)]);
var state_35942__$1 = state_35942;
var statearr_35951_36063 = state_35942__$1;
(statearr_35951_36063[(2)] = inst_35925);

(statearr_35951_36063[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (20))){
var inst_35774 = (state_35942[(2)]);
var state_35942__$1 = state_35942;
var statearr_35952_36064 = state_35942__$1;
(statearr_35952_36064[(2)] = inst_35774);

(statearr_35952_36064[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (58))){
var state_35942__$1 = state_35942;
var statearr_35953_36065 = state_35942__$1;
(statearr_35953_36065[(2)] = null);

(statearr_35953_36065[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (60))){
var inst_35891 = (state_35942[(8)]);
var inst_35889 = (state_35942[(2)]);
var inst_35890 = fluree.db.util.async.throw_err(inst_35889);
var inst_35891__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35890,(0),null);
var inst_35892 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35890,(1),null);
var inst_35893 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_35891__$1);
var state_35942__$1 = (function (){var statearr_35954 = state_35942;
(statearr_35954[(7)] = inst_35892);

(statearr_35954[(8)] = inst_35891__$1);

return statearr_35954;
})();
if(inst_35893){
var statearr_35955_36066 = state_35942__$1;
(statearr_35955_36066[(1)] = (61));

} else {
var statearr_35956_36067 = state_35942__$1;
(statearr_35956_36067[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (27))){
var inst_35804 = (state_35942[(2)]);
var state_35942__$1 = state_35942;
var statearr_35957_36068 = state_35942__$1;
(statearr_35957_36068[(2)] = inst_35804);

(statearr_35957_36068[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (1))){
var state_35942__$1 = state_35942;
var statearr_35958_36069 = state_35942__$1;
(statearr_35958_36069[(2)] = null);

(statearr_35958_36069[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (69))){
var state_35942__$1 = state_35942;
var statearr_35959_36070 = state_35942__$1;
(statearr_35959_36070[(2)] = null);

(statearr_35959_36070[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (24))){
var inst_35768 = (state_35942[(2)]);
var state_35942__$1 = state_35942;
var statearr_35960_36071 = state_35942__$1;
(statearr_35960_36071[(2)] = inst_35768);

(statearr_35960_36071[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (55))){
var inst_35874 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_35875 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_35876 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_35877 = cljs.core.PersistentHashMap.fromArrays(inst_35875,inst_35876);
var inst_35878 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_35874,inst_35877);
var inst_35879 = (function(){throw inst_35878})();
var state_35942__$1 = state_35942;
var statearr_35961_36072 = state_35942__$1;
(statearr_35961_36072[(2)] = inst_35879);

(statearr_35961_36072[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (39))){
var inst_35831 = (state_35942[(2)]);
var state_35942__$1 = state_35942;
if(cljs.core.truth_(inst_35831)){
var statearr_35962_36073 = state_35942__$1;
(statearr_35962_36073[(1)] = (40));

} else {
var statearr_35963_36074 = state_35942__$1;
(statearr_35963_36074[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (46))){
var inst_35931 = (state_35942[(2)]);
var state_35942__$1 = state_35942;
var statearr_35964_36075 = state_35942__$1;
(statearr_35964_36075[(2)] = inst_35931);

(statearr_35964_36075[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (4))){
var inst_35706 = (state_35942[(2)]);
var state_35942__$1 = state_35942;
var statearr_35965_36076 = state_35942__$1;
(statearr_35965_36076[(2)] = inst_35706);

(statearr_35965_36076[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (54))){
var inst_35867 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_35868 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_35869 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_35870 = cljs.core.PersistentHashMap.fromArrays(inst_35868,inst_35869);
var inst_35871 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_35867,inst_35870);
var inst_35872 = (function(){throw inst_35871})();
var state_35942__$1 = state_35942;
var statearr_35966_36077 = state_35942__$1;
(statearr_35966_36077[(2)] = inst_35872);

(statearr_35966_36077[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (15))){
var inst_35806 = (state_35942[(2)]);
var state_35942__$1 = state_35942;
var statearr_35967_36078 = state_35942__$1;
(statearr_35967_36078[(2)] = inst_35806);

(statearr_35967_36078[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (48))){
var inst_35855 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35856 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_35857 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_35856);
var inst_35858 = [inst_35857,r];
var inst_35859 = (new cljs.core.PersistentVector(null,2,(5),inst_35855,inst_35858,null));
var state_35942__$1 = state_35942;
var statearr_35968_36079 = state_35942__$1;
(statearr_35968_36079[(2)] = inst_35859);

(statearr_35968_36079[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (50))){
var inst_35929 = (state_35942[(2)]);
var state_35942__$1 = state_35942;
var statearr_35969_36080 = state_35942__$1;
(statearr_35969_36080[(2)] = inst_35929);

(statearr_35969_36080[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (21))){
var inst_35745 = (state_35942[(10)]);
var inst_35743 = (state_35942[(11)]);
var inst_35742 = (state_35942[(12)]);
var inst_35719 = (state_35942[(13)]);
var inst_35744 = (state_35942[(14)]);
var inst_35752 = (state_35942[(15)]);
var inst_35751 = (state_35942[(16)]);
var inst_35740 = (state_35942[(17)]);
var inst_35715 = (state_35942[(18)]);
var inst_35756 = (state_35942[(2)]);
var inst_35757 = fluree.db.util.async.throw_err(inst_35756);
var inst_35758 = (function (){var expr__35717 = inst_35715;
var new_res = inst_35757;
var rest = inst_35752;
var pred__35716 = inst_35719;
var tuples = inst_35745;
var first__35739 = inst_35742;
var first__35749 = inst_35751;
var seq__35738 = inst_35743;
var seq__35748 = inst_35752;
var G__35736 = inst_35744;
var vec__35747 = inst_35744;
var segment_type = inst_35715;
var vec__35737 = inst_35740;
var clause_group = inst_35751;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,cljs.core.cst$kw$var,cljs.core.dissoc,var$);
});
})();
var inst_35759 = cljs.core.keys(vars);
var inst_35760 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_35758,inst_35757,inst_35759);
var inst_35761 = fluree.db.query.analytical.res_absorb_vars(inst_35760);
var state_35942__$1 = (function (){var statearr_35970 = state_35942;
(statearr_35970[(19)] = inst_35761);

return statearr_35970;
})();
if(cljs.core.truth_(inst_35745)){
var statearr_35971_36081 = state_35942__$1;
(statearr_35971_36081[(1)] = (22));

} else {
var statearr_35972_36082 = state_35942__$1;
(statearr_35972_36082[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (31))){
var inst_35813 = cljs.core.second(clause);
var inst_35814 = clojure.string.starts_with_QMARK_(inst_35813,"fullText:");
var state_35942__$1 = state_35942;
var statearr_35973_36083 = state_35942__$1;
(statearr_35973_36083[(2)] = inst_35814);

(statearr_35973_36083[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (32))){
var inst_35811 = (state_35942[(9)]);
var state_35942__$1 = state_35942;
var statearr_35974_36084 = state_35942__$1;
(statearr_35974_36084[(2)] = inst_35811);

(statearr_35974_36084[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (40))){
var inst_35833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35834 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_35942__$1 = (function (){var statearr_35975 = state_35942;
(statearr_35975[(20)] = inst_35833);

return statearr_35975;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35942__$1,(43),inst_35834);
} else {
if((state_val_35943 === (56))){
var inst_35881 = (state_35942[(2)]);
var state_35942__$1 = state_35942;
var statearr_35976_36085 = state_35942__$1;
(statearr_35976_36085[(2)] = inst_35881);

(statearr_35976_36085[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (33))){
var inst_35817 = (state_35942[(2)]);
var state_35942__$1 = state_35942;
if(cljs.core.truth_(inst_35817)){
var statearr_35977_36086 = state_35942__$1;
(statearr_35977_36086[(1)] = (34));

} else {
var statearr_35978_36087 = state_35942__$1;
(statearr_35978_36087[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (13))){
var inst_35740 = (state_35942[(17)]);
var inst_35740__$1 = cljs.core.cst$kw$union.cljs$core$IFn$_invoke$arity$1(clause);
var inst_35741 = cljs.core.seq(inst_35740__$1);
var inst_35742 = cljs.core.first(inst_35741);
var inst_35743 = cljs.core.next(inst_35741);
var inst_35744 = inst_35740__$1;
var inst_35745 = null;
var state_35942__$1 = (function (){var statearr_35979 = state_35942;
(statearr_35979[(10)] = inst_35745);

(statearr_35979[(11)] = inst_35743);

(statearr_35979[(12)] = inst_35742);

(statearr_35979[(14)] = inst_35744);

(statearr_35979[(17)] = inst_35740__$1);

return statearr_35979;
})();
var statearr_35980_36088 = state_35942__$1;
(statearr_35980_36088[(2)] = null);

(statearr_35980_36088[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (22))){
var inst_35745 = (state_35942[(10)]);
var inst_35761 = (state_35942[(19)]);
var inst_35752 = (state_35942[(15)]);
var inst_35763 = fluree.db.query.union.results(inst_35745,inst_35761);
var inst_35744 = inst_35752;
var inst_35745__$1 = inst_35763;
var state_35942__$1 = (function (){var statearr_35981 = state_35942;
(statearr_35981[(10)] = inst_35745__$1);

(statearr_35981[(14)] = inst_35744);

return statearr_35981;
})();
var statearr_35982_36089 = state_35942__$1;
(statearr_35982_36089[(2)] = null);

(statearr_35982_36089[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (36))){
var inst_35935 = (state_35942[(2)]);
var state_35942__$1 = state_35942;
var statearr_35983_36090 = state_35942__$1;
(statearr_35983_36090[(2)] = inst_35935);

(statearr_35983_36090[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (41))){
var inst_35841 = cljs.core.count(clause);
var inst_35842 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_35841);
var state_35942__$1 = state_35942;
if(inst_35842){
var statearr_35984_36091 = state_35942__$1;
(statearr_35984_36091[(1)] = (44));

} else {
var statearr_35985_36092 = state_35942__$1;
(statearr_35985_36092[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (43))){
var inst_35833 = (state_35942[(20)]);
var inst_35836 = (state_35942[(2)]);
var inst_35837 = fluree.db.util.async.throw_err(inst_35836);
var inst_35838 = [inst_35837,r];
var inst_35839 = (new cljs.core.PersistentVector(null,2,(5),inst_35833,inst_35838,null));
var state_35942__$1 = state_35942;
var statearr_35986_36093 = state_35942__$1;
(statearr_35986_36093[(2)] = inst_35839);

(statearr_35986_36093[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (61))){
var inst_35892 = (state_35942[(7)]);
var inst_35895 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_35892,r,res,optional_QMARK_,fuel,max_fuel);
var state_35942__$1 = state_35942;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35942__$1,(64),inst_35895);
} else {
if((state_val_35943 === (29))){
var inst_35715 = (state_35942[(18)]);
var inst_35798 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35715)].join('');
var inst_35799 = (new Error(inst_35798));
var inst_35800 = (function(){throw inst_35799})();
var state_35942__$1 = state_35942;
var statearr_35987_36094 = state_35942__$1;
(statearr_35987_36094[(2)] = inst_35800);

(statearr_35987_36094[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (44))){
var inst_35844 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35845 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_35942__$1 = (function (){var statearr_35988 = state_35942;
(statearr_35988[(21)] = inst_35844);

return statearr_35988;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35942__$1,(47),inst_35845);
} else {
if((state_val_35943 === (6))){
var inst_35719 = (state_35942[(13)]);
var inst_35715 = (state_35942[(18)]);
var inst_35714 = cljs.core.keys(clause);
var inst_35715__$1 = cljs.core.first(inst_35714);
var inst_35719__$1 = cljs.core._EQ_;
var inst_35720 = (function (){var G__35989 = cljs.core.cst$kw$optional;
var G__35990 = inst_35715__$1;
return (inst_35719__$1.cljs$core$IFn$_invoke$arity$2 ? inst_35719__$1.cljs$core$IFn$_invoke$arity$2(G__35989,G__35990) : inst_35719__$1.call(null,G__35989,G__35990));
})();
var state_35942__$1 = (function (){var statearr_35991 = state_35942;
(statearr_35991[(13)] = inst_35719__$1);

(statearr_35991[(18)] = inst_35715__$1);

return statearr_35991;
})();
if(cljs.core.truth_(inst_35720)){
var statearr_35992_36095 = state_35942__$1;
(statearr_35992_36095[(1)] = (9));

} else {
var statearr_35993_36096 = state_35942__$1;
(statearr_35993_36096[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (28))){
var inst_35792 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35793 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(clause);
var inst_35794 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_35793,optional_QMARK_);
var inst_35795 = [inst_35794,r];
var inst_35796 = (new cljs.core.PersistentVector(null,2,(5),inst_35792,inst_35795,null));
var state_35942__$1 = state_35942;
var statearr_35994_36097 = state_35942__$1;
(statearr_35994_36097[(2)] = inst_35796);

(statearr_35994_36097[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (64))){
var inst_35897 = (state_35942[(2)]);
var inst_35898 = fluree.db.util.async.throw_err(inst_35897);
var state_35942__$1 = state_35942;
var statearr_35995_36098 = state_35942__$1;
(statearr_35995_36098[(2)] = inst_35898);

(statearr_35995_36098[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (51))){
var inst_35864 = cljs.core.first(clause);
var inst_35865 = cljs.core.sequential_QMARK_(inst_35864);
var state_35942__$1 = state_35942;
if(inst_35865){
var statearr_35996_36099 = state_35942__$1;
(statearr_35996_36099[(1)] = (54));

} else {
var statearr_35997_36100 = state_35942__$1;
(statearr_35997_36100[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (25))){
var inst_35719 = (state_35942[(13)]);
var inst_35715 = (state_35942[(18)]);
var inst_35780 = cljs.core.cst$kw$bind.cljs$core$IFn$_invoke$arity$1(clause);
var inst_35781 = (function (){var segment_type = inst_35715;
var pred__35716 = inst_35719;
var expr__35717 = inst_35715;
var bindings = inst_35780;
return (function (p1__35701_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__35701_SHARP_);
});
})();
var inst_35782 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_35781,inst_35780);
var inst_35783 = cljs.core.PersistentHashMap.EMPTY;
var inst_35784 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_35783,inst_35782);
var inst_35785 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35786 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_35784);
var inst_35787 = [inst_35786,r];
var inst_35788 = (new cljs.core.PersistentVector(null,2,(5),inst_35785,inst_35787,null));
var state_35942__$1 = state_35942;
var statearr_35998_36101 = state_35942__$1;
(statearr_35998_36101[(2)] = inst_35788);

(statearr_35998_36101[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (34))){
var inst_35819 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35820 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_35821 = [inst_35820,r];
var inst_35822 = (new cljs.core.PersistentVector(null,2,(5),inst_35819,inst_35821,null));
var state_35942__$1 = state_35942;
var statearr_35999_36102 = state_35942__$1;
(statearr_35999_36102[(2)] = inst_35822);

(statearr_35999_36102[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (17))){
var inst_35776 = (state_35942[(2)]);
var state_35942__$1 = state_35942;
var statearr_36000_36103 = state_35942__$1;
(statearr_36000_36103[(2)] = inst_35776);

(statearr_36000_36103[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (3))){
var inst_35940 = (state_35942[(2)]);
var state_35942__$1 = state_35942;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35942__$1,inst_35940);
} else {
if((state_val_35943 === (12))){
var inst_35722 = (state_35942[(22)]);
var inst_35726 = (state_35942[(2)]);
var inst_35727 = fluree.db.util.async.throw_err(inst_35726);
var inst_35728 = [inst_35727,r];
var inst_35729 = (new cljs.core.PersistentVector(null,2,(5),inst_35722,inst_35728,null));
var state_35942__$1 = state_35942;
var statearr_36001_36104 = state_35942__$1;
(statearr_36001_36104[(2)] = inst_35729);

(statearr_36001_36104[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (2))){
var _ = (function (){var statearr_36002 = state_35942;
(statearr_36002[(4)] = cljs.core.cons((5),(state_35942[(4)])));

return statearr_36002;
})();
var inst_35712 = cljs.core.map_QMARK_(clause);
var state_35942__$1 = state_35942;
if(inst_35712){
var statearr_36003_36105 = state_35942__$1;
(statearr_36003_36105[(1)] = (6));

} else {
var statearr_36004_36106 = state_35942__$1;
(statearr_36004_36106[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (66))){
var state_35942__$1 = state_35942;
var statearr_36005_36107 = state_35942__$1;
(statearr_36005_36107[(1)] = (68));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (23))){
var inst_35761 = (state_35942[(19)]);
var inst_35752 = (state_35942[(15)]);
var inst_35744 = inst_35752;
var inst_35745 = inst_35761;
var state_35942__$1 = (function (){var statearr_36007 = state_35942;
(statearr_36007[(10)] = inst_35745);

(statearr_36007[(14)] = inst_35744);

return statearr_36007;
})();
var statearr_36008_36108 = state_35942__$1;
(statearr_36008_36108[(2)] = null);

(statearr_36008_36108[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (47))){
var inst_35844 = (state_35942[(21)]);
var inst_35847 = (state_35942[(2)]);
var inst_35848 = fluree.db.util.async.throw_err(inst_35847);
var inst_35849 = [inst_35848,r];
var inst_35850 = (new cljs.core.PersistentVector(null,2,(5),inst_35844,inst_35849,null));
var state_35942__$1 = state_35942;
var statearr_36009_36109 = state_35942__$1;
(statearr_36009_36109[(2)] = inst_35850);

(statearr_36009_36109[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (35))){
var inst_35825 = (state_35942[(23)]);
var inst_35824 = cljs.core.count(clause);
var inst_35825__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_35824);
var state_35942__$1 = (function (){var statearr_36010 = state_35942;
(statearr_36010[(23)] = inst_35825__$1);

return statearr_36010;
})();
if(inst_35825__$1){
var statearr_36011_36110 = state_35942__$1;
(statearr_36011_36110[(1)] = (37));

} else {
var statearr_36012_36111 = state_35942__$1;
(statearr_36012_36111[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (19))){
var inst_35745 = (state_35942[(10)]);
var inst_35770 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35771 = [inst_35745,r];
var inst_35772 = (new cljs.core.PersistentVector(null,2,(5),inst_35770,inst_35771,null));
var state_35942__$1 = state_35942;
var statearr_36013_36112 = state_35942__$1;
(statearr_36013_36112[(2)] = inst_35772);

(statearr_36013_36112[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (57))){
var inst_35887 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_35942__$1 = state_35942;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35942__$1,(60),inst_35887);
} else {
if((state_val_35943 === (68))){
var inst_35892 = (state_35942[(7)]);
var inst_35891 = (state_35942[(8)]);
var inst_35909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35910 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_35891,res,inst_35892,fuel,max_fuel);
var state_35942__$1 = (function (){var statearr_36014 = state_35942;
(statearr_36014[(24)] = inst_35909);

return statearr_36014;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35942__$1,(71),inst_35910);
} else {
if((state_val_35943 === (11))){
var inst_35808 = (state_35942[(2)]);
var state_35942__$1 = state_35942;
var statearr_36016_36113 = state_35942__$1;
(statearr_36016_36113[(2)] = inst_35808);

(statearr_36016_36113[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (9))){
var inst_35722 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35723 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(clause);
var inst_35724 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_35723,res,fuel,max_fuel,opts);
var state_35942__$1 = (function (){var statearr_36017 = state_35942;
(statearr_36017[(22)] = inst_35722);

return statearr_36017;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35942__$1,(12),inst_35724);
} else {
if((state_val_35943 === (5))){
var _ = (function (){var statearr_36018 = state_35942;
(statearr_36018[(4)] = cljs.core.rest((state_35942[(4)])));

return statearr_36018;
})();
var state_35942__$1 = state_35942;
var ex36015 = (state_35942__$1[(2)]);
var statearr_36019_36114 = state_35942__$1;
(statearr_36019_36114[(5)] = ex36015);


if((ex36015 instanceof Error)){
var statearr_36020_36115 = state_35942__$1;
(statearr_36020_36115[(1)] = (4));

(statearr_36020_36115[(5)] = null);

} else {
throw ex36015;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (14))){
var inst_35719 = (state_35942[(13)]);
var inst_35715 = (state_35942[(18)]);
var inst_35778 = (function (){var G__36021 = cljs.core.cst$kw$bind;
var G__36022 = inst_35715;
return (inst_35719.cljs$core$IFn$_invoke$arity$2 ? inst_35719.cljs$core$IFn$_invoke$arity$2(G__36021,G__36022) : inst_35719.call(null,G__36021,G__36022));
})();
var state_35942__$1 = state_35942;
if(cljs.core.truth_(inst_35778)){
var statearr_36023_36116 = state_35942__$1;
(statearr_36023_36116[(1)] = (25));

} else {
var statearr_36024_36117 = state_35942__$1;
(statearr_36024_36117[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (45))){
var inst_35852 = cljs.core.count(clause);
var inst_35853 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_35852);
var state_35942__$1 = state_35942;
if(inst_35853){
var statearr_36025_36118 = state_35942__$1;
(statearr_36025_36118[(1)] = (48));

} else {
var statearr_36026_36119 = state_35942__$1;
(statearr_36026_36119[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (53))){
var inst_35927 = (state_35942[(2)]);
var state_35942__$1 = state_35942;
var statearr_36027_36120 = state_35942__$1;
(statearr_36027_36120[(2)] = inst_35927);

(statearr_36027_36120[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (26))){
var inst_35719 = (state_35942[(13)]);
var inst_35715 = (state_35942[(18)]);
var inst_35790 = (function (){var G__36028 = cljs.core.cst$kw$filter;
var G__36029 = inst_35715;
return (inst_35719.cljs$core$IFn$_invoke$arity$2 ? inst_35719.cljs$core$IFn$_invoke$arity$2(G__36028,G__36029) : inst_35719.call(null,G__36028,G__36029));
})();
var state_35942__$1 = state_35942;
if(cljs.core.truth_(inst_35790)){
var statearr_36030_36121 = state_35942__$1;
(statearr_36030_36121[(1)] = (28));

} else {
var statearr_36031_36122 = state_35942__$1;
(statearr_36031_36122[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (16))){
var inst_35744 = (state_35942[(14)]);
var inst_35751 = (state_35942[(16)]);
var inst_35750 = cljs.core.seq(inst_35744);
var inst_35751__$1 = cljs.core.first(inst_35750);
var inst_35752 = cljs.core.next(inst_35750);
var state_35942__$1 = (function (){var statearr_36032 = state_35942;
(statearr_36032[(15)] = inst_35752);

(statearr_36032[(16)] = inst_35751__$1);

return statearr_36032;
})();
if(cljs.core.truth_(inst_35751__$1)){
var statearr_36033_36123 = state_35942__$1;
(statearr_36033_36123[(1)] = (18));

} else {
var statearr_36034_36124 = state_35942__$1;
(statearr_36034_36124[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (38))){
var inst_35825 = (state_35942[(23)]);
var state_35942__$1 = state_35942;
var statearr_36035_36125 = state_35942__$1;
(statearr_36035_36125[(2)] = inst_35825);

(statearr_36035_36125[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (30))){
var inst_35802 = (state_35942[(2)]);
var state_35942__$1 = state_35942;
var statearr_36036_36126 = state_35942__$1;
(statearr_36036_36126[(2)] = inst_35802);

(statearr_36036_36126[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (10))){
var inst_35719 = (state_35942[(13)]);
var inst_35715 = (state_35942[(18)]);
var inst_35731 = (function (){var G__36037 = cljs.core.cst$kw$union;
var G__36038 = inst_35715;
return (inst_35719.cljs$core$IFn$_invoke$arity$2 ? inst_35719.cljs$core$IFn$_invoke$arity$2(G__36037,G__36038) : inst_35719.call(null,G__36037,G__36038));
})();
var state_35942__$1 = state_35942;
if(cljs.core.truth_(inst_35731)){
var statearr_36039_36127 = state_35942__$1;
(statearr_36039_36127[(1)] = (13));

} else {
var statearr_36040_36128 = state_35942__$1;
(statearr_36040_36128[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (18))){
var inst_35751 = (state_35942[(16)]);
var inst_35754 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_35751,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_35751,q_map,vars,fuel,max_fuel,opts));
var state_35942__$1 = state_35942;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35942__$1,(21),inst_35754);
} else {
if((state_val_35943 === (52))){
var state_35942__$1 = state_35942;
var statearr_36041_36129 = state_35942__$1;
(statearr_36041_36129[(1)] = (57));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (67))){
var inst_35920 = (state_35942[(2)]);
var state_35942__$1 = state_35942;
var statearr_36043_36130 = state_35942__$1;
(statearr_36043_36130[(2)] = inst_35920);

(statearr_36043_36130[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (71))){
var inst_35909 = (state_35942[(24)]);
var inst_35912 = (state_35942[(2)]);
var inst_35913 = fluree.db.util.async.throw_err(inst_35912);
var inst_35914 = [inst_35913,r];
var inst_35915 = (new cljs.core.PersistentVector(null,2,(5),inst_35909,inst_35914,null));
var state_35942__$1 = state_35942;
var statearr_36044_36131 = state_35942__$1;
(statearr_36044_36131[(2)] = inst_35915);

(statearr_36044_36131[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (42))){
var inst_35933 = (state_35942[(2)]);
var state_35942__$1 = state_35942;
var statearr_36045_36132 = state_35942__$1;
(statearr_36045_36132[(2)] = inst_35933);

(statearr_36045_36132[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (37))){
var inst_35827 = cljs.core.second(clause);
var inst_35828 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_35827,"rdf:type");
var state_35942__$1 = state_35942;
var statearr_36046_36133 = state_35942__$1;
(statearr_36046_36133[(2)] = inst_35828);

(statearr_36046_36133[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (63))){
var inst_35922 = (state_35942[(2)]);
var state_35942__$1 = state_35942;
var statearr_36047_36134 = state_35942__$1;
(statearr_36047_36134[(2)] = inst_35922);

(statearr_36047_36134[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (8))){
var inst_35937 = (state_35942[(2)]);
var _ = (function (){var statearr_36048 = state_35942;
(statearr_36048[(4)] = cljs.core.rest((state_35942[(4)])));

return statearr_36048;
})();
var state_35942__$1 = state_35942;
var statearr_36049_36135 = state_35942__$1;
(statearr_36049_36135[(2)] = inst_35937);

(statearr_36049_36135[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35943 === (49))){
var inst_35861 = cljs.core.count(clause);
var inst_35862 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_35861);
var state_35942__$1 = state_35942;
if(inst_35862){
var statearr_36050_36136 = state_35942__$1;
(statearr_36050_36136[(1)] = (51));

} else {
var statearr_36051_36137 = state_35942__$1;
(statearr_36051_36137[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__15091__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__15091__auto____0 = (function (){
var statearr_36052 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36052[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__15091__auto__);

(statearr_36052[(1)] = (1));

return statearr_36052;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__15091__auto____1 = (function (state_35942){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_35942);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e36053){var ex__15094__auto__ = e36053;
var statearr_36054_36138 = state_35942;
(statearr_36054_36138[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_35942[(4)]))){
var statearr_36055_36139 = state_35942;
(statearr_36055_36139[(1)] = cljs.core.first((state_35942[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__36140 = state_35942;
state_35942 = G__36140;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__15091__auto__ = function(state_35942){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__15091__auto____1.call(this,state_35942);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__15091__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__15091__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_36056 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_36056[(6)] = c__15165__auto__);

return statearr_36056;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__36142 = arguments.length;
switch (G__36142) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_36222){
var state_val_36223 = (state_36222[(1)]);
if((state_val_36223 === (7))){
var inst_36217 = (state_36222[(2)]);
var _ = (function (){var statearr_36224 = state_36222;
(statearr_36224[(4)] = cljs.core.rest((state_36222[(4)])));

return statearr_36224;
})();
var state_36222__$1 = state_36222;
var statearr_36225_36273 = state_36222__$1;
(statearr_36225_36273[(2)] = inst_36217);

(statearr_36225_36273[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (20))){
var inst_36182 = (state_36222[(7)]);
var inst_36194 = (state_36222[(2)]);
var inst_36164 = inst_36182;
var inst_36165 = inst_36194;
var state_36222__$1 = (function (){var statearr_36226 = state_36222;
(statearr_36226[(8)] = inst_36165);

(statearr_36226[(9)] = inst_36164);

return statearr_36226;
})();
var statearr_36227_36274 = state_36222__$1;
(statearr_36227_36274[(2)] = null);

(statearr_36227_36274[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (1))){
var state_36222__$1 = state_36222;
var statearr_36228_36275 = state_36222__$1;
(statearr_36228_36275[(2)] = null);

(statearr_36228_36275[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (24))){
var inst_36182 = (state_36222[(7)]);
var inst_36181 = (state_36222[(10)]);
var inst_36165 = (state_36222[(8)]);
var inst_36202 = fluree.db.query.analytical.inner_join(inst_36165,inst_36181);
var inst_36164 = inst_36182;
var inst_36165__$1 = inst_36202;
var state_36222__$1 = (function (){var statearr_36229 = state_36222;
(statearr_36229[(8)] = inst_36165__$1);

(statearr_36229[(9)] = inst_36164);

return statearr_36229;
})();
var statearr_36230_36276 = state_36222__$1;
(statearr_36230_36276[(2)] = null);

(statearr_36230_36276[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (4))){
var inst_36143 = (state_36222[(2)]);
var state_36222__$1 = state_36222;
var statearr_36232_36277 = state_36222__$1;
(statearr_36232_36277[(2)] = inst_36143);

(statearr_36232_36277[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (15))){
var inst_36181 = (state_36222[(10)]);
var state_36222__$1 = state_36222;
if(cljs.core.truth_(inst_36181)){
var statearr_36233_36278 = state_36222__$1;
(statearr_36233_36278[(1)] = (18));

} else {
var statearr_36234_36279 = state_36222__$1;
(statearr_36234_36279[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (21))){
var inst_36182 = (state_36222[(7)]);
var inst_36165 = (state_36222[(8)]);
var tmp36231 = inst_36165;
var inst_36164 = inst_36182;
var inst_36165__$1 = tmp36231;
var state_36222__$1 = (function (){var statearr_36235 = state_36222;
(statearr_36235[(8)] = inst_36165__$1);

(statearr_36235[(9)] = inst_36164);

return statearr_36235;
})();
var statearr_36236_36280 = state_36222__$1;
(statearr_36236_36280[(2)] = null);

(statearr_36236_36280[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (13))){
var inst_36165 = (state_36222[(8)]);
var inst_36188 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_36165,cljs.core.cst$kw$vars);
var inst_36189 = cljs.core.empty_QMARK_(inst_36188);
var state_36222__$1 = state_36222;
if(inst_36189){
var statearr_36237_36281 = state_36222__$1;
(statearr_36237_36281[(1)] = (15));

} else {
var statearr_36238_36282 = state_36222__$1;
(statearr_36238_36282[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (22))){
var state_36222__$1 = state_36222;
var statearr_36239_36283 = state_36222__$1;
(statearr_36239_36283[(1)] = (24));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (6))){
var inst_36171 = (state_36222[(11)]);
var inst_36164 = (state_36222[(9)]);
var inst_36170 = cljs.core.seq(inst_36164);
var inst_36171__$1 = cljs.core.first(inst_36170);
var inst_36172 = cljs.core.next(inst_36170);
var state_36222__$1 = (function (){var statearr_36241 = state_36222;
(statearr_36241[(12)] = inst_36172);

(statearr_36241[(11)] = inst_36171__$1);

return statearr_36241;
})();
if(cljs.core.truth_(inst_36171__$1)){
var statearr_36242_36284 = state_36222__$1;
(statearr_36242_36284[(1)] = (8));

} else {
var statearr_36243_36285 = state_36222__$1;
(statearr_36243_36285[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (25))){
var state_36222__$1 = state_36222;
var statearr_36244_36286 = state_36222__$1;
(statearr_36244_36286[(2)] = null);

(statearr_36244_36286[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (17))){
var inst_36210 = (state_36222[(2)]);
var state_36222__$1 = state_36222;
var statearr_36245_36287 = state_36222__$1;
(statearr_36245_36287[(2)] = inst_36210);

(statearr_36245_36287[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (3))){
var inst_36220 = (state_36222[(2)]);
var state_36222__$1 = state_36222;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36222__$1,inst_36220);
} else {
if((state_val_36223 === (12))){
var inst_36182 = (state_36222[(7)]);
var inst_36181 = (state_36222[(10)]);
var inst_36164 = inst_36182;
var inst_36165 = inst_36181;
var state_36222__$1 = (function (){var statearr_36246 = state_36222;
(statearr_36246[(8)] = inst_36165);

(statearr_36246[(9)] = inst_36164);

return statearr_36246;
})();
var statearr_36247_36288 = state_36222__$1;
(statearr_36247_36288[(2)] = null);

(statearr_36247_36288[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (2))){
var _ = (function (){var statearr_36248 = state_36222;
(statearr_36248[(4)] = cljs.core.cons((5),(state_36222[(4)])));

return statearr_36248;
})();
var inst_36156 = where;
var inst_36157 = cljs.core.seq(inst_36156);
var inst_36158 = cljs.core.first(inst_36157);
var inst_36159 = cljs.core.next(inst_36157);
var inst_36160 = [cljs.core.cst$kw$vars];
var inst_36161 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_36162 = [inst_36161];
var inst_36163 = cljs.core.PersistentHashMap.fromArrays(inst_36160,inst_36162);
var inst_36164 = inst_36156;
var inst_36165 = inst_36163;
var state_36222__$1 = (function (){var statearr_36249 = state_36222;
(statearr_36249[(8)] = inst_36165);

(statearr_36249[(13)] = inst_36158);

(statearr_36249[(14)] = inst_36159);

(statearr_36249[(9)] = inst_36164);

return statearr_36249;
})();
var statearr_36250_36289 = state_36222__$1;
(statearr_36250_36289[(2)] = null);

(statearr_36250_36289[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (23))){
var inst_36208 = (state_36222[(2)]);
var state_36222__$1 = state_36222;
var statearr_36251_36290 = state_36222__$1;
(statearr_36251_36290[(2)] = inst_36208);

(statearr_36251_36290[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (19))){
var inst_36165 = (state_36222[(8)]);
var state_36222__$1 = state_36222;
var statearr_36252_36291 = state_36222__$1;
(statearr_36252_36291[(2)] = inst_36165);

(statearr_36252_36291[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (11))){
var inst_36171 = (state_36222[(11)]);
var inst_36179 = (state_36222[(2)]);
var inst_36180 = fluree.db.util.async.throw_err(inst_36179);
var inst_36181 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36180,(0),null);
var inst_36182 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36180,(1),null);
var inst_36183 = cljs.core.count(inst_36171);
var inst_36184 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_36183);
var state_36222__$1 = (function (){var statearr_36254 = state_36222;
(statearr_36254[(7)] = inst_36182);

(statearr_36254[(10)] = inst_36181);

return statearr_36254;
})();
if(inst_36184){
var statearr_36255_36292 = state_36222__$1;
(statearr_36255_36292[(1)] = (12));

} else {
var statearr_36256_36293 = state_36222__$1;
(statearr_36256_36293[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (9))){
var inst_36165 = (state_36222[(8)]);
var state_36222__$1 = state_36222;
var statearr_36257_36294 = state_36222__$1;
(statearr_36257_36294[(2)] = inst_36165);

(statearr_36257_36294[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (5))){
var _ = (function (){var statearr_36258 = state_36222;
(statearr_36258[(4)] = cljs.core.rest((state_36222[(4)])));

return statearr_36258;
})();
var state_36222__$1 = state_36222;
var ex36253 = (state_36222__$1[(2)]);
var statearr_36259_36295 = state_36222__$1;
(statearr_36259_36295[(5)] = ex36253);


if((ex36253 instanceof Error)){
var statearr_36260_36296 = state_36222__$1;
(statearr_36260_36296[(1)] = (4));

(statearr_36260_36296[(5)] = null);

} else {
throw ex36253;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (14))){
var inst_36212 = (state_36222[(2)]);
var state_36222__$1 = state_36222;
var statearr_36261_36297 = state_36222__$1;
(statearr_36261_36297[(2)] = inst_36212);

(statearr_36261_36297[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (26))){
var inst_36206 = (state_36222[(2)]);
var state_36222__$1 = state_36222;
var statearr_36262_36298 = state_36222__$1;
(statearr_36262_36298[(2)] = inst_36206);

(statearr_36262_36298[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (16))){
var inst_36181 = (state_36222[(10)]);
var inst_36197 = (inst_36181 == null);
var state_36222__$1 = state_36222;
if(cljs.core.truth_(inst_36197)){
var statearr_36263_36299 = state_36222__$1;
(statearr_36263_36299[(1)] = (21));

} else {
var statearr_36264_36300 = state_36222__$1;
(statearr_36264_36300[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (10))){
var inst_36215 = (state_36222[(2)]);
var state_36222__$1 = state_36222;
var statearr_36265_36301 = state_36222__$1;
(statearr_36265_36301[(2)] = inst_36215);

(statearr_36265_36301[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (18))){
var inst_36181 = (state_36222[(10)]);
var state_36222__$1 = state_36222;
var statearr_36266_36302 = state_36222__$1;
(statearr_36266_36302[(2)] = inst_36181);

(statearr_36266_36302[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36223 === (8))){
var inst_36165 = (state_36222[(8)]);
var inst_36172 = (state_36222[(12)]);
var inst_36171 = (state_36222[(11)]);
var inst_36177 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_36165,inst_36171,inst_36172,false,fuel,max_fuel,opts);
var state_36222__$1 = state_36222;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36222__$1,(11),inst_36177);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__15091__auto__ = null;
var fluree$db$query$analytical$state_machine__15091__auto____0 = (function (){
var statearr_36267 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36267[(0)] = fluree$db$query$analytical$state_machine__15091__auto__);

(statearr_36267[(1)] = (1));

return statearr_36267;
});
var fluree$db$query$analytical$state_machine__15091__auto____1 = (function (state_36222){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_36222);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e36268){var ex__15094__auto__ = e36268;
var statearr_36269_36303 = state_36222;
(statearr_36269_36303[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_36222[(4)]))){
var statearr_36270_36304 = state_36222;
(statearr_36270_36304[(1)] = cljs.core.first((state_36222[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__36305 = state_36222;
state_36222 = G__36305;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__15091__auto__ = function(state_36222){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__15091__auto____1.call(this,state_36222);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__15091__auto____0;
fluree$db$query$analytical$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__15091__auto____1;
return fluree$db$query$analytical$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_36271 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_36271[(6)] = c__15165__auto__);

return statearr_36271;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_36340){
var state_val_36341 = (state_36340[(1)]);
if((state_val_36341 === (7))){
var inst_36322 = (state_36340[(7)]);
var inst_36317 = (state_36340[(8)]);
var inst_36324 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_36317,inst_36322,fuel,max_fuel,opts);
var state_36340__$1 = state_36340;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36340__$1,(10),inst_36324);
} else {
if((state_val_36341 === (1))){
var state_36340__$1 = state_36340;
var statearr_36342_36367 = state_36340__$1;
(statearr_36342_36367[(2)] = null);

(statearr_36342_36367[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36341 === (4))){
var inst_36306 = (state_36340[(2)]);
var state_36340__$1 = state_36340;
var statearr_36343_36368 = state_36340__$1;
(statearr_36343_36368[(2)] = inst_36306);

(statearr_36343_36368[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36341 === (13))){
var inst_36335 = (state_36340[(2)]);
var _ = (function (){var statearr_36344 = state_36340;
(statearr_36344[(4)] = cljs.core.rest((state_36340[(4)])));

return statearr_36344;
})();
var state_36340__$1 = state_36340;
var statearr_36345_36369 = state_36340__$1;
(statearr_36345_36369[(2)] = inst_36335);

(statearr_36345_36369[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36341 === (6))){
var inst_36317 = (state_36340[(8)]);
var inst_36321 = (state_36340[(2)]);
var inst_36322 = fluree.db.util.async.throw_err(inst_36321);
var state_36340__$1 = (function (){var statearr_36346 = state_36340;
(statearr_36346[(7)] = inst_36322);

return statearr_36346;
})();
if(cljs.core.truth_(inst_36317)){
var statearr_36347_36370 = state_36340__$1;
(statearr_36347_36370[(1)] = (7));

} else {
var statearr_36348_36371 = state_36340__$1;
(statearr_36348_36371[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36341 === (3))){
var inst_36338 = (state_36340[(2)]);
var state_36340__$1 = state_36340;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36340__$1,inst_36338);
} else {
if((state_val_36341 === (12))){
var inst_36330 = (state_36340[(9)]);
var state_36340__$1 = state_36340;
var statearr_36349_36372 = state_36340__$1;
(statearr_36349_36372[(2)] = inst_36330);

(statearr_36349_36372[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36341 === (2))){
var _ = (function (){var statearr_36350 = state_36340;
(statearr_36350[(4)] = cljs.core.cons((5),(state_36340[(4)])));

return statearr_36350;
})();
var inst_36313 = q_map;
var inst_36314 = cljs.core.__destructure_map(inst_36313);
var inst_36315 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36314,cljs.core.cst$kw$vars);
var inst_36316 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36314,cljs.core.cst$kw$where);
var inst_36317 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36314,cljs.core.cst$kw$optional);
var inst_36318 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36314,cljs.core.cst$kw$filter);
var inst_36319 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_36316,q_map,inst_36315,fuel,max_fuel,opts);
var state_36340__$1 = (function (){var statearr_36351 = state_36340;
(statearr_36351[(10)] = inst_36318);

(statearr_36351[(8)] = inst_36317);

return statearr_36351;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36340__$1,(6),inst_36319);
} else {
if((state_val_36341 === (11))){
var inst_36318 = (state_36340[(10)]);
var inst_36330 = (state_36340[(9)]);
var inst_36332 = fluree.db.query.analytical.tuples__GT_filtered(inst_36330,inst_36318,null);
var state_36340__$1 = state_36340;
var statearr_36353_36373 = state_36340__$1;
(statearr_36353_36373[(2)] = inst_36332);

(statearr_36353_36373[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36341 === (9))){
var inst_36318 = (state_36340[(10)]);
var inst_36330 = (state_36340[(2)]);
var state_36340__$1 = (function (){var statearr_36354 = state_36340;
(statearr_36354[(9)] = inst_36330);

return statearr_36354;
})();
if(cljs.core.truth_(inst_36318)){
var statearr_36355_36374 = state_36340__$1;
(statearr_36355_36374[(1)] = (11));

} else {
var statearr_36356_36375 = state_36340__$1;
(statearr_36356_36375[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36341 === (5))){
var _ = (function (){var statearr_36357 = state_36340;
(statearr_36357[(4)] = cljs.core.rest((state_36340[(4)])));

return statearr_36357;
})();
var state_36340__$1 = state_36340;
var ex36352 = (state_36340__$1[(2)]);
var statearr_36358_36376 = state_36340__$1;
(statearr_36358_36376[(5)] = ex36352);


if((ex36352 instanceof Error)){
var statearr_36359_36377 = state_36340__$1;
(statearr_36359_36377[(1)] = (4));

(statearr_36359_36377[(5)] = null);

} else {
throw ex36352;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36341 === (10))){
var inst_36326 = (state_36340[(2)]);
var inst_36327 = fluree.db.util.async.throw_err(inst_36326);
var state_36340__$1 = state_36340;
var statearr_36360_36378 = state_36340__$1;
(statearr_36360_36378[(2)] = inst_36327);

(statearr_36360_36378[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36341 === (8))){
var inst_36322 = (state_36340[(7)]);
var state_36340__$1 = state_36340;
var statearr_36361_36379 = state_36340__$1;
(statearr_36361_36379[(2)] = inst_36322);

(statearr_36361_36379[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__15091__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__15091__auto____0 = (function (){
var statearr_36362 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_36362[(0)] = fluree$db$query$analytical$q_$_state_machine__15091__auto__);

(statearr_36362[(1)] = (1));

return statearr_36362;
});
var fluree$db$query$analytical$q_$_state_machine__15091__auto____1 = (function (state_36340){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_36340);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e36363){var ex__15094__auto__ = e36363;
var statearr_36364_36380 = state_36340;
(statearr_36364_36380[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_36340[(4)]))){
var statearr_36365_36381 = state_36340;
(statearr_36365_36381[(1)] = cljs.core.first((state_36340[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__36382 = state_36340;
state_36340 = G__36382;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__15091__auto__ = function(state_36340){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__15091__auto____1.call(this,state_36340);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__15091__auto____0;
fluree$db$query$analytical$q_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__15091__auto____1;
return fluree$db$query$analytical$q_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_36366 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_36366[(6)] = c__15165__auto__);

return statearr_36366;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
