// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34397_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__34397_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__34401 = coll;
var vec__34402 = G__34401;
var seq__34403 = cljs.core.seq(vec__34402);
var first__34404 = cljs.core.first(seq__34403);
var seq__34403__$1 = cljs.core.next(seq__34403);
var clause = first__34404;
var r = seq__34403__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__34401__$1 = G__34401;
var res__$1 = res;
while(true){
var vec__34408 = G__34401__$1;
var seq__34409 = cljs.core.seq(vec__34408);
var first__34410 = cljs.core.first(seq__34409);
var seq__34409__$1 = cljs.core.next(seq__34409);
var clause__$1 = first__34410;
var r__$1 = seq__34409__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__34411 = r__$1;
var G__34412 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__34401__$1 = G__34411;
res__$1 = G__34412;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,p__34413){
var map__34414 = p__34413;
var map__34414__$1 = cljs.core.__destructure_map(map__34414);
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34414__$1,cljs.core.cst$kw$optional);
if(cljs.core.truth_(optional)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__34418 = coll;
var vec__34419 = G__34418;
var seq__34420 = cljs.core.seq(vec__34419);
var first__34421 = cljs.core.first(seq__34420);
var seq__34420__$1 = cljs.core.next(seq__34420);
var clause = first__34421;
var r = seq__34420__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__34418__$1 = G__34418;
var res__$1 = res;
while(true){
var vec__34425 = G__34418__$1;
var seq__34426 = cljs.core.seq(vec__34425);
var first__34427 = cljs.core.first(seq__34426);
var seq__34426__$1 = cljs.core.next(seq__34426);
var clause__$1 = first__34427;
var r__$1 = seq__34426__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__34428 = r__$1;
var G__34429 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__34418__$1 = G__34428;
res__$1 = G__34429;
continue;
} else {
var G__34430 = r__$1;
var G__34431 = res__$2;
G__34418__$1 = G__34430;
res__$1 = G__34431;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__34435 = coll;
var vec__34436 = G__34435;
var seq__34437 = cljs.core.seq(vec__34436);
var first__34438 = cljs.core.first(seq__34437);
var seq__34437__$1 = cljs.core.next(seq__34437);
var clause = first__34438;
var r = seq__34437__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__34435__$1 = G__34435;
var res__$1 = res;
while(true){
var vec__34442 = G__34435__$1;
var seq__34443 = cljs.core.seq(vec__34442);
var first__34444 = cljs.core.first(seq__34443);
var seq__34443__$1 = cljs.core.next(seq__34443);
var clause__$1 = first__34444;
var r__$1 = seq__34443__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__34445 = r__$1;
var G__34446 = res__$2;
G__34435__$1 = G__34445;
res__$1 = G__34446;
continue;
} else {
var G__34447 = r__$1;
var G__34448 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__34435__$1 = G__34447;
res__$1 = G__34448;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__34451 = clause;
var G__34451__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause)))?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__34451):G__34451);
var G__34451__$2 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__34451__$1)
;
var G__34451__$3 = (function (){var fexpr__34452 = (function (p1__34449_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__34449_SHARP_)," ."].join('');
});
return fexpr__34452(G__34451__$2);
})()
;
if(cljs.core.truth_(optional_QMARK_)){
var fexpr__34453 = (function (p1__34450_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__34450_SHARP_),"}"].join('');
});
return fexpr__34453(G__34451__$3);
} else {
return G__34451__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$limit,(100),cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$distinct,false,cljs.core.cst$kw$language,"en"], null),cljs.core.cst$kw$wikidataOpts.cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$wikidataOpts], null),q_map)], 0));
var map__34457 = opts;
var map__34457__$1 = cljs.core.__destructure_map(map__34457);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34457__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34457__$1,cljs.core.cst$kw$offset);
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34457__$1,cljs.core.cst$kw$distinct);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34457__$1,cljs.core.cst$kw$language);
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34457__$1,cljs.core.cst$kw$prefixes);
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34454_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__34454_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__34455_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__34455_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__34456_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__34456_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = language;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_34471){
var state_val_34472 = (state_34471[(1)]);
if((state_val_34472 === (1))){
var inst_34458 = fluree.db.util.core.url_encode(query);
var inst_34459 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34458)].join('');
var inst_34460 = ["User-Agent","Accept"];
var inst_34461 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_34462 = cljs.core.PersistentHashMap.fromArrays(inst_34460,inst_34461);
var inst_34463 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$output_DASH_format];
var inst_34464 = [inst_34462,(30000),cljs.core.cst$kw$wikidata];
var inst_34465 = cljs.core.PersistentHashMap.fromArrays(inst_34463,inst_34464);
var inst_34466 = fluree.db.util.xhttp.get(inst_34459,inst_34465);
var state_34471__$1 = state_34471;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34471__$1,(2),inst_34466);
} else {
if((state_val_34472 === (2))){
var inst_34468 = (state_34471[(2)]);
var inst_34469 = fluree.db.util.async.throw_err(inst_34468);
var state_34471__$1 = state_34471;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34471__$1,inst_34469);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__15091__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__15091__auto____0 = (function (){
var statearr_34473 = [null,null,null,null,null,null,null];
(statearr_34473[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__15091__auto__);

(statearr_34473[(1)] = (1));

return statearr_34473;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__15091__auto____1 = (function (state_34471){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_34471);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e34474){var ex__15094__auto__ = e34474;
var statearr_34475_34478 = state_34471;
(statearr_34475_34478[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_34471[(4)]))){
var statearr_34476_34479 = state_34471;
(statearr_34476_34479[(1)] = cljs.core.first((state_34471[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__34480 = state_34471;
state_34471 = G__34480;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__15091__auto__ = function(state_34471){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__15091__auto____1.call(this,state_34471);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__15091__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__15091__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_34477 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_34477[(6)] = c__15165__auto__);

return statearr_34477;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_34498){
var state_val_34499 = (state_34498[(1)]);
if((state_val_34499 === (1))){
var inst_34481 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_34498__$1 = state_34498;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34498__$1,(2),inst_34481);
} else {
if((state_val_34499 === (2))){
var inst_34484 = (state_34498[(7)]);
var inst_34483 = (state_34498[(2)]);
var inst_34484__$1 = fluree.db.util.async.throw_err(inst_34483);
var inst_34485 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_34484__$1);
var inst_34486 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_34485);
var state_34498__$1 = (function (){var statearr_34500 = state_34498;
(statearr_34500[(7)] = inst_34484__$1);

return statearr_34500;
})();
if(inst_34486){
var statearr_34501_34510 = state_34498__$1;
(statearr_34501_34510[(1)] = (3));

} else {
var statearr_34502_34511 = state_34498__$1;
(statearr_34502_34511[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34499 === (3))){
var inst_34484 = (state_34498[(7)]);
var state_34498__$1 = state_34498;
var statearr_34503_34512 = state_34498__$1;
(statearr_34503_34512[(2)] = inst_34484);

(statearr_34503_34512[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34499 === (4))){
var inst_34484 = (state_34498[(7)]);
var inst_34489 = (function (){var body = inst_34484;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_34490 = cljs.core.second(inst_34484);
var inst_34491 = cljs.core.second(inst_34490);
var inst_34492 = cljs.core.first(inst_34491);
var inst_34493 = cljs.core.second(inst_34492);
var inst_34494 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_34489,inst_34493);
var state_34498__$1 = state_34498;
var statearr_34504_34513 = state_34498__$1;
(statearr_34504_34513[(2)] = inst_34494);

(statearr_34504_34513[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34499 === (5))){
var inst_34496 = (state_34498[(2)]);
var state_34498__$1 = state_34498;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34498__$1,inst_34496);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__15091__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__15091__auto____0 = (function (){
var statearr_34505 = [null,null,null,null,null,null,null,null];
(statearr_34505[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__15091__auto__);

(statearr_34505[(1)] = (1));

return statearr_34505;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__15091__auto____1 = (function (state_34498){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_34498);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e34506){var ex__15094__auto__ = e34506;
var statearr_34507_34514 = state_34498;
(statearr_34507_34514[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_34498[(4)]))){
var statearr_34508_34515 = state_34498;
(statearr_34508_34515[(1)] = cljs.core.first((state_34498[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__34516 = state_34498;
state_34498 = G__34516;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__15091__auto__ = function(state_34498){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__15091__auto____1.call(this,state_34498);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__15091__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__15091__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_34509 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_34509[(6)] = c__15165__auto__);

return statearr_34509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34517_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__34517_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34518_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__34518_SHARP_),(1)));
}),headers);
var results = cljs.core.cst$kw$bindings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34519_SHARP_){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1((p1__34519_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__34519_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__34519_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$tuples,tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_34565){
var state_val_34566 = (state_34565[(1)]);
if((state_val_34566 === (7))){
var inst_34530 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_34565__$1 = state_34565;
var statearr_34567_34595 = state_34565__$1;
(statearr_34567_34595[(2)] = inst_34530);

(statearr_34567_34595[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34566 === (1))){
var state_34565__$1 = state_34565;
var statearr_34568_34596 = state_34565__$1;
(statearr_34568_34596[(2)] = null);

(statearr_34568_34596[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34566 === (4))){
var inst_34520 = (state_34565[(2)]);
var state_34565__$1 = state_34565;
var statearr_34569_34597 = state_34565__$1;
(statearr_34569_34597[(2)] = inst_34520);

(statearr_34569_34597[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34566 === (15))){
var inst_34538 = (state_34565[(7)]);
var inst_34544 = (state_34565[(8)]);
var inst_34539 = (state_34565[(9)]);
var inst_34549 = (state_34565[(2)]);
var inst_34550 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_34544,(0),inst_34549);
var inst_34551 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34552 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(inst_34538);
var inst_34553 = [inst_34539,inst_34552];
var inst_34554 = cljs.core.PersistentHashMap.fromArrays(inst_34551,inst_34553);
var inst_34555 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34550,inst_34554);
var inst_34556 = (function(){throw inst_34555})();
var state_34565__$1 = state_34565;
var statearr_34570_34598 = state_34565__$1;
(statearr_34570_34598[(2)] = inst_34556);

(statearr_34570_34598[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34566 === (13))){
var inst_34543 = (state_34565[(10)]);
var state_34565__$1 = state_34565;
var statearr_34571_34599 = state_34565__$1;
(statearr_34571_34599[(2)] = inst_34543);

(statearr_34571_34599[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34566 === (6))){
var state_34565__$1 = state_34565;
var statearr_34572_34600 = state_34565__$1;
(statearr_34572_34600[(2)] = null);

(statearr_34572_34600[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34566 === (3))){
var inst_34563 = (state_34565[(2)]);
var state_34565__$1 = state_34565;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34565__$1,inst_34563);
} else {
if((state_val_34566 === (12))){
var inst_34560 = (state_34565[(2)]);
var _ = (function (){var statearr_34573 = state_34565;
(statearr_34573[(4)] = cljs.core.rest((state_34565[(4)])));

return statearr_34573;
})();
var state_34565__$1 = state_34565;
var statearr_34574_34601 = state_34565__$1;
(statearr_34574_34601[(2)] = inst_34560);

(statearr_34574_34601[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34566 === (2))){
var _ = (function (){var statearr_34575 = state_34565;
(statearr_34575[(4)] = cljs.core.cons((5),(state_34565[(4)])));

return statearr_34575;
})();
var inst_34527 = cljs.core.empty_QMARK_(matching_vars);
var state_34565__$1 = state_34565;
if(inst_34527){
var statearr_34576_34602 = state_34565__$1;
(statearr_34576_34602[(1)] = (6));

} else {
var statearr_34577_34603 = state_34565__$1;
(statearr_34577_34603[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34566 === (11))){
var inst_34538 = (state_34565[(7)]);
var inst_34558 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_34538,all_vars);
var state_34565__$1 = state_34565;
var statearr_34579_34604 = state_34565__$1;
(statearr_34579_34604[(2)] = inst_34558);

(statearr_34579_34604[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34566 === (9))){
var inst_34538 = (state_34565[(7)]);
var inst_34539 = (state_34565[(9)]);
var inst_34536 = (state_34565[(2)]);
var inst_34537 = fluree.db.util.async.throw_err(inst_34536);
var inst_34538__$1 = cljs.core.__destructure_map(inst_34537);
var inst_34539__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34538__$1,cljs.core.cst$kw$status);
var inst_34540 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34538__$1,cljs.core.cst$kw$message);
var inst_34541 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_34539__$1);
var state_34565__$1 = (function (){var statearr_34580 = state_34565;
(statearr_34580[(11)] = inst_34540);

(statearr_34580[(7)] = inst_34538__$1);

(statearr_34580[(9)] = inst_34539__$1);

return statearr_34580;
})();
if(inst_34541){
var statearr_34581_34605 = state_34565__$1;
(statearr_34581_34605[(1)] = (10));

} else {
var statearr_34582_34606 = state_34565__$1;
(statearr_34582_34606[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34566 === (5))){
var _ = (function (){var statearr_34583 = state_34565;
(statearr_34583[(4)] = cljs.core.rest((state_34565[(4)])));

return statearr_34583;
})();
var state_34565__$1 = state_34565;
var ex34578 = (state_34565__$1[(2)]);
var statearr_34584_34607 = state_34565__$1;
(statearr_34584_34607[(5)] = ex34578);


if((ex34578 instanceof Error)){
var statearr_34585_34608 = state_34565__$1;
(statearr_34585_34608[(1)] = (4));

(statearr_34585_34608[(5)] = null);

} else {
throw ex34578;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34566 === (14))){
var state_34565__$1 = state_34565;
var statearr_34586_34609 = state_34565__$1;
(statearr_34586_34609[(2)] = (1000));

(statearr_34586_34609[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34566 === (10))){
var inst_34540 = (state_34565[(11)]);
var inst_34543 = (state_34565[(10)]);
var inst_34538 = (state_34565[(7)]);
var inst_34543__$1 = cljs.core.count(inst_34540);
var inst_34544 = cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(inst_34538);
var inst_34545 = (inst_34543__$1 < (1000));
var state_34565__$1 = (function (){var statearr_34587 = state_34565;
(statearr_34587[(10)] = inst_34543__$1);

(statearr_34587[(8)] = inst_34544);

return statearr_34587;
})();
if(cljs.core.truth_(inst_34545)){
var statearr_34588_34610 = state_34565__$1;
(statearr_34588_34610[(1)] = (13));

} else {
var statearr_34589_34611 = state_34565__$1;
(statearr_34589_34611[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34566 === (8))){
var inst_34532 = (state_34565[(2)]);
var inst_34533 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_34532,optional_clauses);
var inst_34534 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_34533);
var state_34565__$1 = state_34565;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34565__$1,(9),inst_34534);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__15091__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__15091__auto____0 = (function (){
var statearr_34590 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34590[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__15091__auto__);

(statearr_34590[(1)] = (1));

return statearr_34590;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__15091__auto____1 = (function (state_34565){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_34565);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e34591){var ex__15094__auto__ = e34591;
var statearr_34592_34612 = state_34565;
(statearr_34592_34612[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_34565[(4)]))){
var statearr_34593_34613 = state_34565;
(statearr_34593_34613[(1)] = cljs.core.first((state_34565[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__34614 = state_34565;
state_34565 = G__34614;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__15091__auto__ = function(state_34565){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__15091__auto____1.call(this,state_34565);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__15091__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__15091__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_34594 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_34594[(6)] = c__15165__auto__);

return statearr_34594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
