// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__36637 = arguments.length;
switch (G__36637) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_(vol,(function (){var G__36638 = cljs.core._deref(vol);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__36638) : f.call(null,G__36638));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_(vol,(function (){var G__36639 = cljs.core._deref(vol);
var G__36640 = arg1;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__36639,G__36640) : f.call(null,G__36639,G__36640));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_(vol,(function (){var G__36641 = cljs.core._deref(vol);
var G__36642 = arg1;
var G__36643 = arg2;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__36641,G__36642,G__36643) : f.call(null,G__36641,G__36642,G__36643));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_(vol,(function (){var G__36644 = cljs.core._deref(vol);
var G__36645 = arg1;
var G__36646 = arg2;
var G__36647 = arg3;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__36644,G__36645,G__36646,G__36647) : f.call(null,G__36644,G__36645,G__36646,G__36647));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__36650 = arguments.length;
switch (G__36650) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__36652 = null;
var G__36652__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__36652__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__36652__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__36652 = function(result,flake){
switch(arguments.length){
case 0:
return G__36652__0.call(this);
case 1:
return G__36652__1.call(this,result);
case 2:
return G__36652__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36652.cljs$core$IFn$_invoke$arity$0 = G__36652__0;
G__36652.cljs$core$IFn$_invoke$arity$1 = G__36652__1;
G__36652.cljs$core$IFn$_invoke$arity$2 = G__36652__2;
return G__36652;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__36653 = null;
var G__36653__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__36653__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__36653__2 = (function (result,flakes){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,cljs.core.count(flakes));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__36653 = function(result,flakes){
switch(arguments.length){
case 0:
return G__36653__0.call(this);
case 1:
return G__36653__1.call(this,result);
case 2:
return G__36653__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36653.cljs$core$IFn$_invoke$arity$0 = G__36653__0;
G__36653.cljs$core$IFn$_invoke$arity$1 = G__36653__1;
G__36653.cljs$core$IFn$_invoke$arity$2 = G__36653__2;
return G__36653;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__36655 = res;
var G__36655__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__36654_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__36654_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__36655):G__36655);
var G__36655__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__36655__$1):G__36655__$1);
var G__36655__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__36655__$2):G__36655__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__36655__$3);
} else {
return G__36655__$3;
}
} else {
return res;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__36659 = arguments.length;
switch (G__36659) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_37098){
var state_val_37099 = (state_37098[(1)]);
if((state_val_37099 === (121))){
var inst_37021 = (state_37098[(2)]);
var inst_37022 = fluree.db.util.async.throw_err(inst_37021);
var inst_37023 = cljs.core.seq(inst_37022);
var state_37098__$1 = state_37098;
if(inst_37023){
var statearr_37100_37314 = state_37098__$1;
(statearr_37100_37314[(1)] = (122));

} else {
var statearr_37101_37315 = state_37098__$1;
(statearr_37101_37315[(1)] = (123));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (65))){
var inst_36814 = (state_37098[(7)]);
var inst_36813 = (state_37098[(2)]);
var inst_36814__$1 = fluree.db.util.async.throw_err(inst_36813);
var inst_36815 = cljs.core.seq(inst_36814__$1);
var state_37098__$1 = (function (){var statearr_37102 = state_37098;
(statearr_37102[(7)] = inst_36814__$1);

return statearr_37102;
})();
if(inst_36815){
var statearr_37103_37316 = state_37098__$1;
(statearr_37103_37316[(1)] = (66));

} else {
var statearr_37104_37317 = state_37098__$1;
(statearr_37104_37317[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (70))){
var inst_36814 = (state_37098[(7)]);
var inst_36825 = cljs.core.count(inst_36814);
var inst_36826 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_36825);
var state_37098__$1 = state_37098;
var statearr_37105_37318 = state_37098__$1;
(statearr_37105_37318[(2)] = inst_36826);

(statearr_37105_37318[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (62))){
var inst_36804 = (state_37098[(8)]);
var inst_36807 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36808 = inst_36804.o;
var inst_36809 = [inst_36808];
var inst_36810 = (new cljs.core.PersistentVector(null,1,(5),inst_36807,inst_36809,null));
var inst_36811 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_36810);
var state_37098__$1 = state_37098;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37098__$1,(65),inst_36811);
} else {
if((state_val_37099 === (74))){
var inst_36798 = (state_37098[(9)]);
var state_37098__$1 = state_37098;
var statearr_37106_37319 = state_37098__$1;
(statearr_37106_37319[(2)] = inst_36798);

(statearr_37106_37319[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (110))){
var inst_36983 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_36984 = cljs.core.cst$kw$root_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_36983);
var inst_36985 = inst_36984 === true;
var state_37098__$1 = state_37098;
if(cljs.core.truth_(inst_36985)){
var statearr_37107_37320 = state_37098__$1;
(statearr_37107_37320[(1)] = (113));

} else {
var statearr_37108_37321 = state_37098__$1;
(statearr_37108_37321[(1)] = (114));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (130))){
var inst_37093 = (state_37098[(2)]);
var _ = (function (){var statearr_37109 = state_37098;
(statearr_37109[(4)] = cljs.core.rest((state_37098[(4)])));

return statearr_37109;
})();
var state_37098__$1 = state_37098;
var statearr_37110_37322 = state_37098__$1;
(statearr_37110_37322[(2)] = inst_37093);

(statearr_37110_37322[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (128))){
var inst_37068 = (state_37098[(10)]);
var inst_37071 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37072 = [acc,inst_37068];
var inst_37073 = (new cljs.core.PersistentVector(null,2,(5),inst_37071,inst_37072,null));
var state_37098__$1 = state_37098;
var statearr_37111_37323 = state_37098__$1;
(statearr_37111_37323[(2)] = inst_37073);

(statearr_37111_37323[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (7))){
var inst_36671 = (state_37098[(11)]);
var state_37098__$1 = state_37098;
var statearr_37112_37324 = state_37098__$1;
(statearr_37112_37324[(2)] = inst_36671);

(statearr_37112_37324[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (59))){
var inst_37062 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
var statearr_37113_37325 = state_37098__$1;
(statearr_37113_37325[(2)] = inst_37062);

(statearr_37113_37325[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (86))){
var inst_36892 = (state_37098[(12)]);
var inst_36892__$1 = (state_37098[(2)]);
var state_37098__$1 = (function (){var statearr_37114 = state_37098;
(statearr_37114[(12)] = inst_36892__$1);

return statearr_37114;
})();
if(cljs.core.truth_(inst_36892__$1)){
var statearr_37115_37326 = state_37098__$1;
(statearr_37115_37326[(1)] = (88));

} else {
var statearr_37116_37327 = state_37098__$1;
(statearr_37116_37327[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (20))){
var inst_36700 = (state_37098[(13)]);
var inst_36712 = (state_37098[(14)]);
var inst_36713 = (state_37098[(15)]);
var inst_36711 = (state_37098[(2)]);
var inst_36712__$1 = cljs.core.__destructure_map(inst_36700);
var inst_36713__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36712__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_36714 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36712__$1,cljs.core.cst$kw$ref_QMARK_);
var inst_36715 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36712__$1,cljs.core.cst$kw$limit);
var inst_36716 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36712__$1,cljs.core.cst$kw$orderBy);
var inst_36717 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36712__$1,cljs.core.cst$kw$offset);
var inst_36718 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36712__$1,cljs.core.cst$kw$p);
var state_37098__$1 = (function (){var statearr_37117 = state_37098;
(statearr_37117[(16)] = inst_36714);

(statearr_37117[(17)] = inst_36718);

(statearr_37117[(18)] = inst_36711);

(statearr_37117[(19)] = inst_36716);

(statearr_37117[(20)] = inst_36717);

(statearr_37117[(14)] = inst_36712__$1);

(statearr_37117[(15)] = inst_36713__$1);

(statearr_37117[(21)] = inst_36715);

return statearr_37117;
})();
if(cljs.core.truth_(inst_36713__$1)){
var statearr_37118_37328 = state_37098__$1;
(statearr_37118_37328[(1)] = (24));

} else {
var statearr_37119_37329 = state_37098__$1;
(statearr_37119_37329[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (72))){
var inst_36823 = (state_37098[(22)]);
var inst_36829 = (state_37098[(2)]);
var inst_36830 = cljs.core.seq(inst_36823);
var state_37098__$1 = (function (){var statearr_37120 = state_37098;
(statearr_37120[(23)] = inst_36829);

return statearr_37120;
})();
if(inst_36830){
var statearr_37121_37330 = state_37098__$1;
(statearr_37121_37330[(1)] = (73));

} else {
var statearr_37122_37331 = state_37098__$1;
(statearr_37122_37331[(1)] = (74));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (58))){
var inst_36700 = (state_37098[(13)]);
var inst_36845 = cljs.core.cst$kw$tag_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_36700);
var state_37098__$1 = state_37098;
if(cljs.core.truth_(inst_36845)){
var statearr_37123_37332 = state_37098__$1;
(statearr_37123_37332[(1)] = (76));

} else {
var statearr_37124_37333 = state_37098__$1;
(statearr_37124_37333[(1)] = (77));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (60))){
var inst_36797 = (state_37098[(24)]);
var inst_36804 = (state_37098[(8)]);
var inst_36803 = cljs.core.seq(inst_36797);
var inst_36804__$1 = cljs.core.first(inst_36803);
var inst_36805 = cljs.core.next(inst_36803);
var state_37098__$1 = (function (){var statearr_37125 = state_37098;
(statearr_37125[(25)] = inst_36805);

(statearr_37125[(8)] = inst_36804__$1);

return statearr_37125;
})();
if(cljs.core.truth_(inst_36804__$1)){
var statearr_37126_37334 = state_37098__$1;
(statearr_37126_37334[(1)] = (62));

} else {
var statearr_37127_37335 = state_37098__$1;
(statearr_37127_37335[(1)] = (63));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (27))){
var inst_36721 = (state_37098[(26)]);
var inst_36717 = (state_37098[(20)]);
var inst_36721__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_36717);
var state_37098__$1 = (function (){var statearr_37128 = state_37098;
(statearr_37128[(26)] = inst_36721__$1);

return statearr_37128;
})();
if(inst_36721__$1){
var statearr_37129_37336 = state_37098__$1;
(statearr_37129_37336[(1)] = (30));

} else {
var statearr_37130_37337 = state_37098__$1;
(statearr_37130_37337[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (1))){
var state_37098__$1 = state_37098;
var statearr_37131_37338 = state_37098__$1;
(statearr_37131_37338[(2)] = null);

(statearr_37131_37338[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (69))){
var inst_36819 = (state_37098[(2)]);
var inst_36820 = fluree.db.util.async.throw_err(inst_36819);
var state_37098__$1 = state_37098;
var statearr_37132_37339 = state_37098__$1;
(statearr_37132_37339[(2)] = inst_36820);

(statearr_37132_37339[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (101))){
var inst_36976 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
var statearr_37133_37340 = state_37098__$1;
(statearr_37133_37340[(2)] = inst_36976);

(statearr_37133_37340[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (24))){
var inst_36717 = (state_37098[(20)]);
var state_37098__$1 = state_37098;
if(cljs.core.truth_(inst_36717)){
var statearr_37134_37341 = state_37098__$1;
(statearr_37134_37341[(1)] = (27));

} else {
var statearr_37135_37342 = state_37098__$1;
(statearr_37135_37342[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (102))){
var inst_36948 = (state_37098[(27)]);
var inst_36947 = (state_37098[(2)]);
var inst_36948__$1 = fluree.db.util.async.throw_err(inst_36947);
var inst_36949 = cljs.core.empty_QMARK_(inst_36948__$1);
var state_37098__$1 = (function (){var statearr_37136 = state_37098;
(statearr_37136[(27)] = inst_36948__$1);

return statearr_37136;
})();
if(inst_36949){
var statearr_37137_37343 = state_37098__$1;
(statearr_37137_37343[(1)] = (103));

} else {
var statearr_37138_37344 = state_37098__$1;
(statearr_37138_37344[(1)] = (104));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (135))){
var state_37098__$1 = state_37098;
var statearr_37139_37345 = state_37098__$1;
(statearr_37139_37345[(2)] = null);

(statearr_37139_37345[(1)] = (136));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (55))){
var inst_36700 = (state_37098[(13)]);
var inst_36773 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_36700);
var state_37098__$1 = state_37098;
var statearr_37140_37346 = state_37098__$1;
(statearr_37140_37346[(2)] = inst_36773);

(statearr_37140_37346[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (85))){
var inst_36867 = (state_37098[(28)]);
var inst_36700 = (state_37098[(13)]);
var inst_36879 = inst_36867.o;
var inst_36880 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_36700);
var inst_36881 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_36879,inst_36880);
var state_37098__$1 = state_37098;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37098__$1,(87),inst_36881);
} else {
if((state_val_37099 === (39))){
var inst_36748 = (state_37098[(29)]);
var inst_36716 = (state_37098[(19)]);
var inst_36748__$1 = cljs.core.not(inst_36716);
var state_37098__$1 = (function (){var statearr_37141 = state_37098;
(statearr_37141[(29)] = inst_36748__$1);

return statearr_37141;
})();
if(inst_36748__$1){
var statearr_37142_37347 = state_37098__$1;
(statearr_37142_37347[(1)] = (42));

} else {
var statearr_37143_37348 = state_37098__$1;
(statearr_37143_37348[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (88))){
var inst_36861 = (state_37098[(30)]);
var inst_36892 = (state_37098[(12)]);
var inst_36894 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36861,inst_36892);
var state_37098__$1 = state_37098;
var statearr_37144_37349 = state_37098__$1;
(statearr_37144_37349[(2)] = inst_36894);

(statearr_37144_37349[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (46))){
var inst_36715 = (state_37098[(21)]);
var state_37098__$1 = state_37098;
var statearr_37145_37350 = state_37098__$1;
(statearr_37145_37350[(2)] = inst_36715);

(statearr_37145_37350[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (4))){
var inst_36660 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
var statearr_37146_37351 = state_37098__$1;
(statearr_37146_37351[(2)] = inst_36660);

(statearr_37146_37351[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (77))){
var inst_36907 = (state_37098[(31)]);
var inst_36907__$1 = componentFollow_QMARK_;
var state_37098__$1 = (function (){var statearr_37147 = state_37098;
(statearr_37147[(31)] = inst_36907__$1);

return statearr_37147;
})();
if(cljs.core.truth_(inst_36907__$1)){
var statearr_37148_37352 = state_37098__$1;
(statearr_37148_37352[(1)] = (91));

} else {
var statearr_37149_37353 = state_37098__$1;
(statearr_37149_37353[(1)] = (92));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (106))){
var inst_36928 = (state_37098[(32)]);
var inst_36962 = (state_37098[(2)]);
var inst_36963 = fluree.db.util.async.throw_err(inst_36962);
var inst_36964 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36928,inst_36963);
var state_37098__$1 = state_37098;
var statearr_37150_37354 = state_37098__$1;
(statearr_37150_37354[(2)] = inst_36964);

(statearr_37150_37354[(1)] = (105));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (119))){
var inst_37006 = (state_37098[(33)]);
var inst_37036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37037 = [inst_37006,offset_map];
var inst_37038 = (new cljs.core.PersistentVector(null,2,(5),inst_37036,inst_37037,null));
var state_37098__$1 = state_37098;
var statearr_37151_37355 = state_37098__$1;
(statearr_37151_37355[(2)] = inst_37038);

(statearr_37151_37355[(1)] = (120));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (95))){
var inst_36714 = (state_37098[(16)]);
var state_37098__$1 = state_37098;
if(cljs.core.truth_(inst_36714)){
var statearr_37152_37356 = state_37098__$1;
(statearr_37152_37356[(1)] = (110));

} else {
var statearr_37153_37357 = state_37098__$1;
(statearr_37153_37357[(1)] = (111));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (54))){
var inst_36770 = (state_37098[(34)]);
var state_37098__$1 = state_37098;
var statearr_37154_37358 = state_37098__$1;
(statearr_37154_37358[(2)] = inst_36770);

(statearr_37154_37358[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (92))){
var inst_36907 = (state_37098[(31)]);
var state_37098__$1 = state_37098;
var statearr_37155_37359 = state_37098__$1;
(statearr_37155_37359[(2)] = inst_36907);

(statearr_37155_37359[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (104))){
var inst_36948 = (state_37098[(27)]);
var inst_36670 = (state_37098[(35)]);
var inst_36957 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_];
var inst_36958 = [true,inst_36670];
var inst_36959 = cljs.core.PersistentHashMap.fromArrays(inst_36957,inst_36958);
var inst_36960 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_36959,inst_36948) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_36959,inst_36948));
var state_37098__$1 = state_37098;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37098__$1,(106),inst_36960);
} else {
if((state_val_37099 === (15))){
var inst_36693 = (state_37098[(36)]);
var inst_36670 = (state_37098[(35)]);
var inst_36697 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36693,cljs.core.cst$kw$compact_QMARK_,inst_36670);
var state_37098__$1 = state_37098;
var statearr_37156_37360 = state_37098__$1;
(statearr_37156_37360[(2)] = inst_36697);

(statearr_37156_37360[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (48))){
var inst_36764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36765 = [null,offset_map];
var inst_36766 = (new cljs.core.PersistentVector(null,2,(5),inst_36764,inst_36765,null));
var state_37098__$1 = state_37098;
var statearr_37157_37361 = state_37098__$1;
(statearr_37157_37361[(2)] = inst_36766);

(statearr_37157_37361[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (50))){
var inst_37064 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
var statearr_37158_37362 = state_37098__$1;
(statearr_37158_37362[(2)] = inst_37064);

(statearr_37158_37362[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (116))){
var inst_37012 = (state_37098[(37)]);
var inst_37005 = (state_37098[(38)]);
var inst_37011 = cljs.core.seq(inst_37005);
var inst_37012__$1 = cljs.core.first(inst_37011);
var inst_37013 = cljs.core.next(inst_37011);
var state_37098__$1 = (function (){var statearr_37159 = state_37098;
(statearr_37159[(39)] = inst_37013);

(statearr_37159[(37)] = inst_37012__$1);

return statearr_37159;
})();
if(cljs.core.truth_(inst_37012__$1)){
var statearr_37160_37363 = state_37098__$1;
(statearr_37160_37363[(1)] = (118));

} else {
var statearr_37161_37364 = state_37098__$1;
(statearr_37161_37364[(1)] = (119));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (75))){
var inst_36805 = (state_37098[(25)]);
var inst_36835 = (state_37098[(2)]);
var inst_36797 = inst_36805;
var inst_36798 = inst_36835;
var state_37098__$1 = (function (){var statearr_37162 = state_37098;
(statearr_37162[(24)] = inst_36797);

(statearr_37162[(9)] = inst_36798);

return statearr_37162;
})();
var statearr_37163_37365 = state_37098__$1;
(statearr_37163_37365[(2)] = null);

(statearr_37163_37365[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (99))){
var inst_36700 = (state_37098[(13)]);
var inst_36934 = (state_37098[(40)]);
var inst_36937 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36938 = inst_36934.o;
var inst_36939 = [inst_36938];
var inst_36940 = (new cljs.core.PersistentVector(null,1,(5),inst_36937,inst_36939,null));
var inst_36941 = [cljs.core.cst$kw$limit];
var inst_36942 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(inst_36700);
var inst_36943 = [inst_36942];
var inst_36944 = cljs.core.PersistentHashMap.fromArrays(inst_36941,inst_36943);
var inst_36945 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_36940,inst_36944);
var state_37098__$1 = state_37098;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37098__$1,(102),inst_36945);
} else {
if((state_val_37099 === (21))){
var inst_36704 = (state_37098[(41)]);
var state_37098__$1 = state_37098;
var statearr_37164_37366 = state_37098__$1;
(statearr_37164_37366[(2)] = inst_36704);

(statearr_37164_37366[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (31))){
var inst_36721 = (state_37098[(26)]);
var state_37098__$1 = state_37098;
var statearr_37165_37367 = state_37098__$1;
(statearr_37165_37367[(2)] = inst_36721);

(statearr_37165_37367[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (113))){
var inst_36714 = (state_37098[(16)]);
var inst_36700 = (state_37098[(13)]);
var inst_36685 = (state_37098[(42)]);
var inst_36718 = (state_37098[(17)]);
var inst_36711 = (state_37098[(18)]);
var inst_36716 = (state_37098[(19)]);
var inst_36717 = (state_37098[(20)]);
var inst_36670 = (state_37098[(35)]);
var inst_36712 = (state_37098[(14)]);
var inst_36713 = (state_37098[(15)]);
var inst_36715 = (state_37098[(21)]);
var inst_36987 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36988 = (function (){var p = inst_36718;
var pred_spec__$1 = inst_36685;
var orderBy = inst_36716;
var multi_QMARK_ = inst_36713;
var limit = inst_36715;
var offset = inst_36717;
var map__36666 = inst_36712;
var k = inst_36711;
var compact_QMARK_ = inst_36670;
var pred_spec_SINGLEQUOTE_ = inst_36700;
var ref_QMARK_ = inst_36714;
return (function (p1__36656_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$_id],[p1__36656_SHARP_.o]);
});
})();
var inst_36989 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_36988,flakes);
var inst_36990 = [inst_36989,offset_map];
var inst_36991 = (new cljs.core.PersistentVector(null,2,(5),inst_36987,inst_36990,null));
var state_37098__$1 = state_37098;
var statearr_37166_37368 = state_37098__$1;
(statearr_37166_37368[(2)] = inst_36991);

(statearr_37166_37368[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (32))){
var inst_36727 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
var statearr_37167_37369 = state_37098__$1;
(statearr_37167_37369[(2)] = inst_36727);

(statearr_37167_37369[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (136))){
var inst_37089 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
var statearr_37168_37370 = state_37098__$1;
(statearr_37168_37370[(2)] = inst_37089);

(statearr_37168_37370[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (40))){
var inst_36713 = (state_37098[(15)]);
var state_37098__$1 = state_37098;
var statearr_37169_37371 = state_37098__$1;
(statearr_37169_37371[(2)] = inst_36713);

(statearr_37169_37371[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (129))){
var inst_36713 = (state_37098[(15)]);
var state_37098__$1 = state_37098;
if(cljs.core.truth_(inst_36713)){
var statearr_37170_37372 = state_37098__$1;
(statearr_37170_37372[(1)] = (131));

} else {
var statearr_37171_37373 = state_37098__$1;
(statearr_37171_37373[(1)] = (132));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (91))){
var inst_36700 = (state_37098[(13)]);
var inst_36909 = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_36700);
var state_37098__$1 = state_37098;
var statearr_37172_37374 = state_37098__$1;
(statearr_37172_37374[(2)] = inst_36909);

(statearr_37172_37374[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (117))){
var inst_37042 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
var statearr_37173_37375 = state_37098__$1;
(statearr_37173_37375[(2)] = inst_37042);

(statearr_37173_37375[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (108))){
var state_37098__$1 = state_37098;
var statearr_37174_37376 = state_37098__$1;
(statearr_37174_37376[(2)] = null);

(statearr_37174_37376[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (56))){
var inst_36775 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
var statearr_37175_37377 = state_37098__$1;
(statearr_37175_37377[(2)] = inst_36775);

(statearr_37175_37377[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (33))){
var inst_36718 = (state_37098[(17)]);
var inst_36735 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36736 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_36718);
var state_37098__$1 = (function (){var statearr_37176 = state_37098;
(statearr_37176[(43)] = inst_36735);

return statearr_37176;
})();
if(cljs.core.truth_(inst_36736)){
var statearr_37177_37378 = state_37098__$1;
(statearr_37177_37378[(1)] = (36));

} else {
var statearr_37178_37379 = state_37098__$1;
(statearr_37178_37379[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (13))){
var inst_36685 = (state_37098[(42)]);
var state_37098__$1 = state_37098;
var statearr_37179_37380 = state_37098__$1;
(statearr_37179_37380[(2)] = inst_36685);

(statearr_37179_37380[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (22))){
var inst_36700 = (state_37098[(13)]);
var inst_36707 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_36700);
var state_37098__$1 = state_37098;
var statearr_37180_37381 = state_37098__$1;
(statearr_37180_37381[(2)] = inst_36707);

(statearr_37180_37381[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (90))){
var inst_36868 = (state_37098[(44)]);
var inst_36897 = (state_37098[(2)]);
var inst_36860 = inst_36868;
var inst_36861 = inst_36897;
var state_37098__$1 = (function (){var statearr_37181 = state_37098;
(statearr_37181[(30)] = inst_36861);

(statearr_37181[(45)] = inst_36860);

return statearr_37181;
})();
var statearr_37182_37382 = state_37098__$1;
(statearr_37182_37382[(2)] = null);

(statearr_37182_37382[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (109))){
var inst_36966 = (state_37098[(46)]);
var inst_36935 = (state_37098[(47)]);
var inst_36972 = (state_37098[(2)]);
var inst_36927 = inst_36935;
var inst_36928 = inst_36966;
var state_37098__$1 = (function (){var statearr_37183 = state_37098;
(statearr_37183[(48)] = inst_36972);

(statearr_37183[(49)] = inst_36927);

(statearr_37183[(32)] = inst_36928);

return statearr_37183;
})();
var statearr_37184_37383 = state_37098__$1;
(statearr_37184_37383[(2)] = null);

(statearr_37184_37383[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (36))){
var inst_36718 = (state_37098[(17)]);
var inst_36738 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_36718,cljs.core.dec);
var state_37098__$1 = state_37098;
var statearr_37185_37384 = state_37098__$1;
(statearr_37185_37384[(2)] = inst_36738);

(statearr_37185_37384[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (41))){
var inst_36762 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
if(cljs.core.truth_(inst_36762)){
var statearr_37186_37385 = state_37098__$1;
(statearr_37186_37385[(1)] = (48));

} else {
var statearr_37187_37386 = state_37098__$1;
(statearr_37187_37386[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (118))){
var inst_37012 = (state_37098[(37)]);
var inst_37015 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37016 = inst_37012.o;
var inst_37017 = [inst_37016];
var inst_37018 = (new cljs.core.PersistentVector(null,1,(5),inst_37015,inst_37017,null));
var inst_37019 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_37018);
var state_37098__$1 = state_37098;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37098__$1,(121),inst_37019);
} else {
if((state_val_37099 === (89))){
var inst_36861 = (state_37098[(30)]);
var state_37098__$1 = state_37098;
var statearr_37188_37387 = state_37098__$1;
(statearr_37188_37387[(2)] = inst_36861);

(statearr_37188_37387[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (100))){
var inst_36928 = (state_37098[(32)]);
var state_37098__$1 = state_37098;
var statearr_37189_37388 = state_37098__$1;
(statearr_37189_37388[(2)] = inst_36928);

(statearr_37189_37388[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (131))){
var inst_37068 = (state_37098[(10)]);
var inst_36711 = (state_37098[(18)]);
var inst_37067 = (state_37098[(50)]);
var inst_37076 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37077 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_36711,inst_37067);
var inst_37078 = [inst_37077,inst_37068];
var inst_37079 = (new cljs.core.PersistentVector(null,2,(5),inst_37076,inst_37078,null));
var state_37098__$1 = state_37098;
var statearr_37190_37389 = state_37098__$1;
(statearr_37190_37389[(2)] = inst_37079);

(statearr_37190_37389[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (122))){
var inst_37006 = (state_37098[(33)]);
var inst_37013 = (state_37098[(39)]);
var inst_37012 = (state_37098[(37)]);
var inst_37025 = [cljs.core.cst$kw$_id];
var inst_37026 = inst_37012.o;
var inst_37027 = [inst_37026];
var inst_37028 = cljs.core.PersistentHashMap.fromArrays(inst_37025,inst_37027);
var inst_37029 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37006,inst_37028);
var inst_37005 = inst_37013;
var inst_37006__$1 = inst_37029;
var state_37098__$1 = (function (){var statearr_37191 = state_37098;
(statearr_37191[(33)] = inst_37006__$1);

(statearr_37191[(38)] = inst_37005);

return statearr_37191;
})();
var statearr_37192_37390 = state_37098__$1;
(statearr_37192_37390[(2)] = null);

(statearr_37192_37390[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (43))){
var inst_36748 = (state_37098[(29)]);
var state_37098__$1 = state_37098;
var statearr_37193_37391 = state_37098__$1;
(statearr_37193_37391[(2)] = inst_36748);

(statearr_37193_37391[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (61))){
var inst_36784 = (state_37098[(51)]);
var inst_36841 = (state_37098[(2)]);
var inst_36842 = [inst_36841,offset_map];
var inst_36843 = (new cljs.core.PersistentVector(null,2,(5),inst_36784,inst_36842,null));
var state_37098__$1 = state_37098;
var statearr_37194_37392 = state_37098__$1;
(statearr_37194_37392[(2)] = inst_36843);

(statearr_37194_37392[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (29))){
var inst_36730 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
var statearr_37195_37393 = state_37098__$1;
(statearr_37195_37393[(2)] = inst_36730);

(statearr_37195_37393[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (44))){
var inst_36759 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
var statearr_37196_37394 = state_37098__$1;
(statearr_37196_37394[(2)] = inst_36759);

(statearr_37196_37394[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (93))){
var inst_36912 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
if(cljs.core.truth_(inst_36912)){
var statearr_37197_37395 = state_37098__$1;
(statearr_37197_37395[(1)] = (94));

} else {
var statearr_37198_37396 = state_37098__$1;
(statearr_37198_37396[(1)] = (95));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (6))){
var inst_36673 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_36674 = (inst_36673 == null);
var state_37098__$1 = state_37098;
var statearr_37199_37397 = state_37098__$1;
(statearr_37199_37397[(2)] = inst_36674);

(statearr_37199_37397[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (111))){
var state_37098__$1 = state_37098;
var statearr_37200_37398 = state_37098__$1;
(statearr_37200_37398[(1)] = (125));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (28))){
var inst_36717 = (state_37098[(20)]);
var state_37098__$1 = state_37098;
var statearr_37202_37399 = state_37098__$1;
(statearr_37202_37399[(2)] = inst_36717);

(statearr_37202_37399[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (134))){
var inst_37068 = (state_37098[(10)]);
var inst_36711 = (state_37098[(18)]);
var inst_37067 = (state_37098[(50)]);
var inst_37082 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37083 = cljs.core.first(inst_37067);
var inst_37084 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_36711,inst_37083);
var inst_37085 = [inst_37084,inst_37068];
var inst_37086 = (new cljs.core.PersistentVector(null,2,(5),inst_37082,inst_37085,null));
var state_37098__$1 = state_37098;
var statearr_37203_37400 = state_37098__$1;
(statearr_37203_37400[(2)] = inst_37086);

(statearr_37203_37400[(1)] = (136));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (64))){
var inst_36839 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
var statearr_37204_37401 = state_37098__$1;
(statearr_37204_37401[(2)] = inst_36839);

(statearr_37204_37401[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (103))){
var inst_36928 = (state_37098[(32)]);
var inst_36934 = (state_37098[(40)]);
var inst_36951 = [cljs.core.cst$kw$_id];
var inst_36952 = inst_36934.o;
var inst_36953 = [inst_36952];
var inst_36954 = cljs.core.PersistentHashMap.fromArrays(inst_36951,inst_36953);
var inst_36955 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36928,inst_36954);
var state_37098__$1 = state_37098;
var statearr_37205_37402 = state_37098__$1;
(statearr_37205_37402[(2)] = inst_36955);

(statearr_37205_37402[(1)] = (105));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (51))){
var inst_36700 = (state_37098[(13)]);
var inst_36770 = (state_37098[(34)]);
var inst_36770__$1 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_36700);
var state_37098__$1 = (function (){var statearr_37206 = state_37098;
(statearr_37206[(34)] = inst_36770__$1);

return statearr_37206;
})();
if(cljs.core.truth_(inst_36770__$1)){
var statearr_37207_37403 = state_37098__$1;
(statearr_37207_37403[(1)] = (54));

} else {
var statearr_37208_37404 = state_37098__$1;
(statearr_37208_37404[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (25))){
var inst_36713 = (state_37098[(15)]);
var state_37098__$1 = state_37098;
var statearr_37209_37405 = state_37098__$1;
(statearr_37209_37405[(2)] = inst_36713);

(statearr_37209_37405[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (34))){
var inst_36713 = (state_37098[(15)]);
var state_37098__$1 = state_37098;
if(cljs.core.truth_(inst_36713)){
var statearr_37210_37406 = state_37098__$1;
(statearr_37210_37406[(1)] = (39));

} else {
var statearr_37211_37407 = state_37098__$1;
(statearr_37211_37407[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (125))){
var inst_36714 = (state_37098[(16)]);
var inst_36700 = (state_37098[(13)]);
var inst_36685 = (state_37098[(42)]);
var inst_36718 = (state_37098[(17)]);
var inst_36711 = (state_37098[(18)]);
var inst_36716 = (state_37098[(19)]);
var inst_36717 = (state_37098[(20)]);
var inst_36670 = (state_37098[(35)]);
var inst_36712 = (state_37098[(14)]);
var inst_36713 = (state_37098[(15)]);
var inst_36715 = (state_37098[(21)]);
var inst_37047 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37048 = (function (){var p = inst_36718;
var pred_spec__$1 = inst_36685;
var orderBy = inst_36716;
var multi_QMARK_ = inst_36713;
var limit = inst_36715;
var offset = inst_36717;
var map__36666 = inst_36712;
var k = inst_36711;
var compact_QMARK_ = inst_36670;
var pred_spec_SINGLEQUOTE_ = inst_36700;
var ref_QMARK_ = inst_36714;
return (function (p1__36657_SHARP_){
return p1__36657_SHARP_.o;
});
})();
var inst_37049 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_37048,flakes);
var inst_37050 = [inst_37049,offset_map];
var inst_37051 = (new cljs.core.PersistentVector(null,2,(5),inst_37047,inst_37050,null));
var state_37098__$1 = state_37098;
var statearr_37212_37408 = state_37098__$1;
(statearr_37212_37408[(2)] = inst_37051);

(statearr_37212_37408[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (17))){
var inst_36700 = (state_37098[(13)]);
var inst_36701 = (state_37098[(52)]);
var inst_36700__$1 = (state_37098[(2)]);
var inst_36701__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_36700__$1);
var state_37098__$1 = (function (){var statearr_37213 = state_37098;
(statearr_37213[(13)] = inst_36700__$1);

(statearr_37213[(52)] = inst_36701__$1);

return statearr_37213;
})();
if(cljs.core.truth_(inst_36701__$1)){
var statearr_37214_37409 = state_37098__$1;
(statearr_37214_37409[(1)] = (18));

} else {
var statearr_37215_37410 = state_37098__$1;
(statearr_37215_37410[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (3))){
var inst_37096 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37098__$1,inst_37096);
} else {
if((state_val_37099 === (12))){
var inst_36685 = (state_37098[(42)]);
var inst_36690 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36685,cljs.core.cst$kw$componentFollow_QMARK_,componentFollow_QMARK_);
var state_37098__$1 = state_37098;
var statearr_37216_37411 = state_37098__$1;
(statearr_37216_37411[(2)] = inst_36690);

(statearr_37216_37411[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (2))){
var inst_36671 = (state_37098[(11)]);
var _ = (function (){var statearr_37217 = state_37098;
(statearr_37217[(4)] = cljs.core.cons((5),(state_37098[(4)])));

return statearr_37217;
})();
var inst_36670 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_36671__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_37098__$1 = (function (){var statearr_37218 = state_37098;
(statearr_37218[(11)] = inst_36671__$1);

(statearr_37218[(35)] = inst_36670);

return statearr_37218;
})();
if(cljs.core.truth_(inst_36671__$1)){
var statearr_37219_37412 = state_37098__$1;
(statearr_37219_37412[(1)] = (6));

} else {
var statearr_37220_37413 = state_37098__$1;
(statearr_37220_37413[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (66))){
var inst_36814 = (state_37098[(7)]);
var inst_36783 = (state_37098[(53)]);
var inst_36817 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_36783,inst_36814) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_36783,inst_36814));
var state_37098__$1 = state_37098;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37098__$1,(69),inst_36817);
} else {
if((state_val_37099 === (107))){
var inst_36948 = (state_37098[(27)]);
var inst_36968 = cljs.core.count(inst_36948);
var inst_36969 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_36968);
var state_37098__$1 = state_37098;
var statearr_37221_37414 = state_37098__$1;
(statearr_37221_37414[(2)] = inst_36969);

(statearr_37221_37414[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (23))){
var inst_36709 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
var statearr_37222_37415 = state_37098__$1;
(statearr_37222_37415[(2)] = inst_36709);

(statearr_37222_37415[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (47))){
var inst_36756 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
var statearr_37223_37416 = state_37098__$1;
(statearr_37223_37416[(2)] = inst_36756);

(statearr_37223_37416[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (35))){
var inst_37067 = (state_37098[(50)]);
var inst_37066 = (state_37098[(2)]);
var inst_37067__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37066,(0),null);
var inst_37068 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37066,(1),null);
var inst_37069 = cljs.core.empty_QMARK_(inst_37067__$1);
var state_37098__$1 = (function (){var statearr_37224 = state_37098;
(statearr_37224[(10)] = inst_37068);

(statearr_37224[(50)] = inst_37067__$1);

return statearr_37224;
})();
if(inst_37069){
var statearr_37225_37417 = state_37098__$1;
(statearr_37225_37417[(1)] = (128));

} else {
var statearr_37226_37418 = state_37098__$1;
(statearr_37226_37418[(1)] = (129));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (127))){
var inst_37054 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
var statearr_37227_37419 = state_37098__$1;
(statearr_37227_37419[(2)] = inst_37054);

(statearr_37227_37419[(1)] = (112));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (82))){
var inst_36861 = (state_37098[(30)]);
var state_37098__$1 = state_37098;
var statearr_37228_37420 = state_37098__$1;
(statearr_37228_37420[(2)] = inst_36861);

(statearr_37228_37420[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (76))){
var inst_36847 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36855 = flakes;
var inst_36856 = cljs.core.seq(inst_36855);
var inst_36857 = cljs.core.first(inst_36856);
var inst_36858 = cljs.core.next(inst_36856);
var inst_36859 = cljs.core.PersistentVector.EMPTY;
var inst_36860 = inst_36855;
var inst_36861 = inst_36859;
var state_37098__$1 = (function (){var statearr_37229 = state_37098;
(statearr_37229[(30)] = inst_36861);

(statearr_37229[(54)] = inst_36847);

(statearr_37229[(55)] = inst_36858);

(statearr_37229[(56)] = inst_36857);

(statearr_37229[(45)] = inst_36860);

return statearr_37229;
})();
var statearr_37230_37421 = state_37098__$1;
(statearr_37230_37421[(2)] = null);

(statearr_37230_37421[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (97))){
var inst_36927 = (state_37098[(49)]);
var inst_36934 = (state_37098[(40)]);
var inst_36933 = cljs.core.seq(inst_36927);
var inst_36934__$1 = cljs.core.first(inst_36933);
var inst_36935 = cljs.core.next(inst_36933);
var state_37098__$1 = (function (){var statearr_37231 = state_37098;
(statearr_37231[(47)] = inst_36935);

(statearr_37231[(40)] = inst_36934__$1);

return statearr_37231;
})();
if(cljs.core.truth_(inst_36934__$1)){
var statearr_37232_37422 = state_37098__$1;
(statearr_37232_37422[(1)] = (99));

} else {
var statearr_37233_37423 = state_37098__$1;
(statearr_37233_37423[(1)] = (100));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (19))){
var inst_36700 = (state_37098[(13)]);
var inst_36704 = (state_37098[(41)]);
var inst_36704__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_36700);
var state_37098__$1 = (function (){var statearr_37234 = state_37098;
(statearr_37234[(41)] = inst_36704__$1);

return statearr_37234;
})();
if(cljs.core.truth_(inst_36704__$1)){
var statearr_37235_37424 = state_37098__$1;
(statearr_37235_37424[(1)] = (21));

} else {
var statearr_37236_37425 = state_37098__$1;
(statearr_37236_37425[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (57))){
var inst_36700 = (state_37098[(13)]);
var inst_36780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36781 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select];
var inst_36782 = (new cljs.core.PersistentVector(null,3,(5),inst_36780,inst_36781,null));
var inst_36783 = cljs.core.select_keys(inst_36700,inst_36782);
var inst_36784 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36792 = flakes;
var inst_36793 = cljs.core.seq(inst_36792);
var inst_36794 = cljs.core.first(inst_36793);
var inst_36795 = cljs.core.next(inst_36793);
var inst_36796 = cljs.core.PersistentVector.EMPTY;
var inst_36797 = inst_36792;
var inst_36798 = inst_36796;
var state_37098__$1 = (function (){var statearr_37237 = state_37098;
(statearr_37237[(57)] = inst_36794);

(statearr_37237[(51)] = inst_36784);

(statearr_37237[(24)] = inst_36797);

(statearr_37237[(9)] = inst_36798);

(statearr_37237[(53)] = inst_36783);

(statearr_37237[(58)] = inst_36795);

return statearr_37237;
})();
var statearr_37238_37426 = state_37098__$1;
(statearr_37238_37426[(2)] = null);

(statearr_37238_37426[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (68))){
var inst_36823 = (state_37098[(2)]);
var state_37098__$1 = (function (){var statearr_37239 = state_37098;
(statearr_37239[(22)] = inst_36823);

return statearr_37239;
})();
if(cljs.core.truth_(fuel)){
var statearr_37240_37427 = state_37098__$1;
(statearr_37240_37427[(1)] = (70));

} else {
var statearr_37241_37428 = state_37098__$1;
(statearr_37241_37428[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (11))){
var inst_36685 = (state_37098[(42)]);
var inst_36685__$1 = (state_37098[(2)]);
var inst_36687 = cljs.core.contains_QMARK_(inst_36685__$1,cljs.core.cst$kw$componentFollow_QMARK_);
var inst_36688 = (!(inst_36687));
var state_37098__$1 = (function (){var statearr_37242 = state_37098;
(statearr_37242[(42)] = inst_36685__$1);

return statearr_37242;
})();
if(inst_36688){
var statearr_37243_37429 = state_37098__$1;
(statearr_37243_37429[(1)] = (12));

} else {
var statearr_37244_37430 = state_37098__$1;
(statearr_37244_37430[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (115))){
var inst_37044 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
var statearr_37246_37431 = state_37098__$1;
(statearr_37246_37431[(2)] = inst_37044);

(statearr_37246_37431[(1)] = (112));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (9))){
var inst_36679 = cljs.core.first(flakes);
var inst_36680 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_36679);
var inst_36681 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_36682 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_36680,inst_36681);
var state_37098__$1 = state_37098;
var statearr_37247_37432 = state_37098__$1;
(statearr_37247_37432[(2)] = inst_36682);

(statearr_37247_37432[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (5))){
var _ = (function (){var statearr_37248 = state_37098;
(statearr_37248[(4)] = cljs.core.rest((state_37098[(4)])));

return statearr_37248;
})();
var state_37098__$1 = state_37098;
var ex37245 = (state_37098__$1[(2)]);
var statearr_37249_37433 = state_37098__$1;
(statearr_37249_37433[(5)] = ex37245);


if((ex37245 instanceof Error)){
var statearr_37250_37434 = state_37098__$1;
(statearr_37250_37434[(1)] = (4));

(statearr_37250_37434[(5)] = null);

} else {
throw ex37245;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (112))){
var inst_37056 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
var statearr_37251_37435 = state_37098__$1;
(statearr_37251_37435[(2)] = inst_37056);

(statearr_37251_37435[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (83))){
var inst_36901 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
var statearr_37252_37436 = state_37098__$1;
(statearr_37252_37436[(2)] = inst_36901);

(statearr_37252_37436[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (14))){
var inst_36685 = (state_37098[(42)]);
var inst_36693 = (state_37098[(2)]);
var inst_36694 = cljs.core.contains_QMARK_(inst_36685,cljs.core.cst$kw$compact_QMARK_);
var inst_36695 = (!(inst_36694));
var state_37098__$1 = (function (){var statearr_37253 = state_37098;
(statearr_37253[(36)] = inst_36693);

return statearr_37253;
})();
if(inst_36695){
var statearr_37254_37437 = state_37098__$1;
(statearr_37254_37437[(1)] = (15));

} else {
var statearr_37255_37438 = state_37098__$1;
(statearr_37255_37438[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (45))){
var inst_36711 = (state_37098[(18)]);
var inst_36715 = (state_37098[(21)]);
var inst_36751 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_36711);
var inst_36752 = cljs.core.count(inst_36751);
var inst_36753 = (inst_36752 >= inst_36715);
var state_37098__$1 = state_37098;
var statearr_37256_37439 = state_37098__$1;
(statearr_37256_37439[(2)] = inst_36753);

(statearr_37256_37439[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (53))){
var inst_36778 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
if(cljs.core.truth_(inst_36778)){
var statearr_37257_37440 = state_37098__$1;
(statearr_37257_37440[(1)] = (57));

} else {
var statearr_37258_37441 = state_37098__$1;
(statearr_37258_37441[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (78))){
var inst_37060 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
var statearr_37259_37442 = state_37098__$1;
(statearr_37259_37442[(2)] = inst_37060);

(statearr_37259_37442[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (132))){
var state_37098__$1 = state_37098;
var statearr_37261_37443 = state_37098__$1;
(statearr_37261_37443[(1)] = (134));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (26))){
var inst_36733 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
if(cljs.core.truth_(inst_36733)){
var statearr_37263_37444 = state_37098__$1;
(statearr_37263_37444[(1)] = (33));

} else {
var statearr_37264_37445 = state_37098__$1;
(statearr_37264_37445[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (123))){
var inst_37006 = (state_37098[(33)]);
var inst_37013 = (state_37098[(39)]);
var tmp37260 = inst_37006;
var inst_37005 = inst_37013;
var inst_37006__$1 = tmp37260;
var state_37098__$1 = (function (){var statearr_37265 = state_37098;
(statearr_37265[(33)] = inst_37006__$1);

(statearr_37265[(38)] = inst_37005);

return statearr_37265;
})();
var statearr_37266_37446 = state_37098__$1;
(statearr_37266_37446[(2)] = null);

(statearr_37266_37446[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (16))){
var inst_36693 = (state_37098[(36)]);
var state_37098__$1 = state_37098;
var statearr_37267_37447 = state_37098__$1;
(statearr_37267_37447[(2)] = inst_36693);

(statearr_37267_37447[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (133))){
var inst_37091 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
var statearr_37268_37448 = state_37098__$1;
(statearr_37268_37448[(2)] = inst_37091);

(statearr_37268_37448[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (81))){
var inst_36867 = (state_37098[(28)]);
var inst_36700 = (state_37098[(13)]);
var inst_36876 = (state_37098[(59)]);
var inst_36870 = cljs.core.deref(cache);
var inst_36871 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36872 = inst_36867.o;
var inst_36873 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_36700);
var inst_36874 = [inst_36872,inst_36873];
var inst_36875 = (new cljs.core.PersistentVector(null,2,(5),inst_36871,inst_36874,null));
var inst_36876__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36870,inst_36875);
var state_37098__$1 = (function (){var statearr_37269 = state_37098;
(statearr_37269[(59)] = inst_36876__$1);

return statearr_37269;
})();
if(cljs.core.truth_(inst_36876__$1)){
var statearr_37270_37449 = state_37098__$1;
(statearr_37270_37449[(1)] = (84));

} else {
var statearr_37271_37450 = state_37098__$1;
(statearr_37271_37450[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (120))){
var inst_37040 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
var statearr_37272_37451 = state_37098__$1;
(statearr_37272_37451[(2)] = inst_37040);

(statearr_37272_37451[(1)] = (117));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (79))){
var inst_36867 = (state_37098[(28)]);
var inst_36860 = (state_37098[(45)]);
var inst_36866 = cljs.core.seq(inst_36860);
var inst_36867__$1 = cljs.core.first(inst_36866);
var inst_36868 = cljs.core.next(inst_36866);
var state_37098__$1 = (function (){var statearr_37273 = state_37098;
(statearr_37273[(28)] = inst_36867__$1);

(statearr_37273[(44)] = inst_36868);

return statearr_37273;
})();
if(cljs.core.truth_(inst_36867__$1)){
var statearr_37274_37452 = state_37098__$1;
(statearr_37274_37452[(1)] = (81));

} else {
var statearr_37275_37453 = state_37098__$1;
(statearr_37275_37453[(1)] = (82));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (38))){
var inst_36735 = (state_37098[(43)]);
var inst_36743 = (state_37098[(2)]);
var inst_36744 = [null,inst_36743];
var inst_36745 = (new cljs.core.PersistentVector(null,2,(5),inst_36735,inst_36744,null));
var state_37098__$1 = state_37098;
var statearr_37276_37454 = state_37098__$1;
(statearr_37276_37454[(2)] = inst_36745);

(statearr_37276_37454[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (126))){
var state_37098__$1 = state_37098;
var statearr_37277_37455 = state_37098__$1;
(statearr_37277_37455[(2)] = null);

(statearr_37277_37455[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (98))){
var inst_36914 = (state_37098[(60)]);
var inst_36978 = (state_37098[(2)]);
var inst_36979 = [inst_36978,offset_map];
var inst_36980 = (new cljs.core.PersistentVector(null,2,(5),inst_36914,inst_36979,null));
var state_37098__$1 = state_37098;
var statearr_37278_37456 = state_37098__$1;
(statearr_37278_37456[(2)] = inst_36980);

(statearr_37278_37456[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (124))){
var inst_37034 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
var statearr_37279_37457 = state_37098__$1;
(statearr_37279_37457[(2)] = inst_37034);

(statearr_37279_37457[(1)] = (120));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (87))){
var inst_36867 = (state_37098[(28)]);
var inst_36700 = (state_37098[(13)]);
var inst_36883 = (state_37098[(2)]);
var inst_36884 = fluree.db.util.async.throw_err(inst_36883);
var inst_36885 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36886 = inst_36867.o;
var inst_36887 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_36700);
var inst_36888 = [inst_36886,inst_36887];
var inst_36889 = (new cljs.core.PersistentVector(null,2,(5),inst_36885,inst_36888,null));
var inst_36890 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,inst_36889,inst_36884);
var state_37098__$1 = (function (){var statearr_37280 = state_37098;
(statearr_37280[(61)] = inst_36890);

return statearr_37280;
})();
var statearr_37281_37458 = state_37098__$1;
(statearr_37281_37458[(2)] = inst_36884);

(statearr_37281_37458[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (30))){
var inst_36718 = (state_37098[(17)]);
var inst_36723 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_36718);
var inst_36724 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_36723);
var state_37098__$1 = state_37098;
var statearr_37282_37459 = state_37098__$1;
(statearr_37282_37459[(2)] = inst_36724);

(statearr_37282_37459[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (73))){
var inst_36798 = (state_37098[(9)]);
var inst_36823 = (state_37098[(22)]);
var inst_36832 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36798,inst_36823);
var state_37098__$1 = state_37098;
var statearr_37283_37460 = state_37098__$1;
(statearr_37283_37460[(2)] = inst_36832);

(statearr_37283_37460[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (96))){
var inst_37058 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
var statearr_37284_37461 = state_37098__$1;
(statearr_37284_37461[(2)] = inst_37058);

(statearr_37284_37461[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (10))){
var state_37098__$1 = state_37098;
var statearr_37285_37462 = state_37098__$1;
(statearr_37285_37462[(2)] = pred_spec);

(statearr_37285_37462[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (18))){
var inst_36701 = (state_37098[(52)]);
var state_37098__$1 = state_37098;
var statearr_37286_37463 = state_37098__$1;
(statearr_37286_37463[(2)] = inst_36701);

(statearr_37286_37463[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (105))){
var inst_36966 = (state_37098[(2)]);
var state_37098__$1 = (function (){var statearr_37287 = state_37098;
(statearr_37287[(46)] = inst_36966);

return statearr_37287;
})();
if(cljs.core.truth_(fuel)){
var statearr_37288_37464 = state_37098__$1;
(statearr_37288_37464[(1)] = (107));

} else {
var statearr_37289_37465 = state_37098__$1;
(statearr_37289_37465[(1)] = (108));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (52))){
var inst_36768 = (state_37098[(62)]);
var state_37098__$1 = state_37098;
var statearr_37290_37466 = state_37098__$1;
(statearr_37290_37466[(2)] = inst_36768);

(statearr_37290_37466[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (114))){
var inst_37000 = flakes;
var inst_37001 = cljs.core.seq(inst_37000);
var inst_37002 = cljs.core.first(inst_37001);
var inst_37003 = cljs.core.next(inst_37001);
var inst_37004 = cljs.core.PersistentVector.EMPTY;
var inst_37005 = inst_37000;
var inst_37006 = inst_37004;
var state_37098__$1 = (function (){var statearr_37291 = state_37098;
(statearr_37291[(33)] = inst_37006);

(statearr_37291[(63)] = inst_37002);

(statearr_37291[(38)] = inst_37005);

(statearr_37291[(64)] = inst_37003);

return statearr_37291;
})();
var statearr_37292_37467 = state_37098__$1;
(statearr_37292_37467[(2)] = null);

(statearr_37292_37467[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (67))){
var state_37098__$1 = state_37098;
var statearr_37293_37468 = state_37098__$1;
(statearr_37293_37468[(2)] = null);

(statearr_37293_37468[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (71))){
var state_37098__$1 = state_37098;
var statearr_37294_37469 = state_37098__$1;
(statearr_37294_37469[(2)] = null);

(statearr_37294_37469[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (42))){
var inst_36715 = (state_37098[(21)]);
var state_37098__$1 = state_37098;
if(cljs.core.truth_(inst_36715)){
var statearr_37295_37470 = state_37098__$1;
(statearr_37295_37470[(1)] = (45));

} else {
var statearr_37296_37471 = state_37098__$1;
(statearr_37296_37471[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (80))){
var inst_36847 = (state_37098[(54)]);
var inst_36903 = (state_37098[(2)]);
var inst_36904 = [inst_36903,offset_map];
var inst_36905 = (new cljs.core.PersistentVector(null,2,(5),inst_36847,inst_36904,null));
var state_37098__$1 = state_37098;
var statearr_37297_37472 = state_37098__$1;
(statearr_37297_37472[(2)] = inst_36905);

(statearr_37297_37472[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (37))){
var inst_36718 = (state_37098[(17)]);
var inst_36717 = (state_37098[(20)]);
var inst_36740 = (inst_36717 - (1));
var inst_36741 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_36718,inst_36740);
var state_37098__$1 = state_37098;
var statearr_37298_37473 = state_37098__$1;
(statearr_37298_37473[(2)] = inst_36741);

(statearr_37298_37473[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (63))){
var inst_36798 = (state_37098[(9)]);
var state_37098__$1 = state_37098;
var statearr_37299_37474 = state_37098__$1;
(statearr_37299_37474[(2)] = inst_36798);

(statearr_37299_37474[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (94))){
var inst_36914 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36922 = flakes;
var inst_36923 = cljs.core.seq(inst_36922);
var inst_36924 = cljs.core.first(inst_36923);
var inst_36925 = cljs.core.next(inst_36923);
var inst_36926 = cljs.core.PersistentVector.EMPTY;
var inst_36927 = inst_36922;
var inst_36928 = inst_36926;
var state_37098__$1 = (function (){var statearr_37300 = state_37098;
(statearr_37300[(60)] = inst_36914);

(statearr_37300[(65)] = inst_36925);

(statearr_37300[(49)] = inst_36927);

(statearr_37300[(32)] = inst_36928);

(statearr_37300[(66)] = inst_36924);

return statearr_37300;
})();
var statearr_37301_37475 = state_37098__$1;
(statearr_37301_37475[(2)] = null);

(statearr_37301_37475[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (8))){
var inst_36677 = (state_37098[(2)]);
var state_37098__$1 = state_37098;
if(cljs.core.truth_(inst_36677)){
var statearr_37302_37476 = state_37098__$1;
(statearr_37302_37476[(1)] = (9));

} else {
var statearr_37303_37477 = state_37098__$1;
(statearr_37303_37477[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (49))){
var inst_36768 = (state_37098[(62)]);
var inst_36768__$1 = cljs.core.not(recur_QMARK_);
var state_37098__$1 = (function (){var statearr_37304 = state_37098;
(statearr_37304[(62)] = inst_36768__$1);

return statearr_37304;
})();
if(inst_36768__$1){
var statearr_37305_37478 = state_37098__$1;
(statearr_37305_37478[(1)] = (51));

} else {
var statearr_37306_37479 = state_37098__$1;
(statearr_37306_37479[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37099 === (84))){
var inst_36876 = (state_37098[(59)]);
var state_37098__$1 = state_37098;
var statearr_37307_37480 = state_37098__$1;
(statearr_37307_37480[(2)] = inst_36876);

(statearr_37307_37480[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__15091__auto__ = null;
var fluree$db$query$fql$state_machine__15091__auto____0 = (function (){
var statearr_37308 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37308[(0)] = fluree$db$query$fql$state_machine__15091__auto__);

(statearr_37308[(1)] = (1));

return statearr_37308;
});
var fluree$db$query$fql$state_machine__15091__auto____1 = (function (state_37098){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_37098);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e37309){var ex__15094__auto__ = e37309;
var statearr_37310_37481 = state_37098;
(statearr_37310_37481[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_37098[(4)]))){
var statearr_37311_37482 = state_37098;
(statearr_37311_37482[(1)] = cljs.core.first((state_37098[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__37483 = state_37098;
state_37098 = G__37483;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__15091__auto__ = function(state_37098){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__15091__auto____1.call(this,state_37098);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__15091__auto____0;
fluree$db$query$fql$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__15091__auto____1;
return fluree$db$query$fql$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_37312 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_37312[(6)] = c__15165__auto__);

return statearr_37312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,cljs.core.cst$kw$select,(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,cljs.core.cst$kw$pred_DASH_id,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(sel)], 0))),cljs.core.cst$kw$ns_DASH_lookup);
}));
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_37643){
var state_val_37644 = (state_37643[(1)]);
if((state_val_37644 === (7))){
var inst_37638 = (state_37643[(2)]);
var _ = (function (){var statearr_37645 = state_37643;
(statearr_37645[(4)] = cljs.core.rest((state_37643[(4)])));

return statearr_37645;
})();
var state_37643__$1 = state_37643;
var statearr_37646_37728 = state_37643__$1;
(statearr_37646_37728[(2)] = inst_37638);

(statearr_37646_37728[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (20))){
var inst_37565 = (state_37643[(7)]);
var state_37643__$1 = state_37643;
var statearr_37647_37729 = state_37643__$1;
(statearr_37647_37729[(2)] = inst_37565);

(statearr_37647_37729[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (27))){
var inst_37520 = (state_37643[(8)]);
var state_37643__$1 = state_37643;
if(cljs.core.truth_(inst_37520)){
var statearr_37648_37730 = state_37643__$1;
(statearr_37648_37730[(1)] = (29));

} else {
var statearr_37649_37731 = state_37643__$1;
(statearr_37649_37731[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (1))){
var state_37643__$1 = state_37643;
var statearr_37650_37732 = state_37643__$1;
(statearr_37650_37732[(2)] = null);

(statearr_37650_37732[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (24))){
var inst_37521 = (state_37643[(9)]);
var state_37643__$1 = state_37643;
var statearr_37651_37733 = state_37643__$1;
(statearr_37651_37733[(2)] = inst_37521);

(statearr_37651_37733[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (39))){
var inst_37557 = (state_37643[(10)]);
var state_37643__$1 = state_37643;
var statearr_37652_37734 = state_37643__$1;
(statearr_37652_37734[(2)] = inst_37557);

(statearr_37652_37734[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (46))){
var inst_37522 = (state_37643[(11)]);
var state_37643__$1 = state_37643;
var statearr_37653_37735 = state_37643__$1;
(statearr_37653_37735[(2)] = inst_37522);

(statearr_37653_37735[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (4))){
var inst_37484 = (state_37643[(2)]);
var state_37643__$1 = state_37643;
var statearr_37654_37736 = state_37643__$1;
(statearr_37654_37736[(2)] = inst_37484);

(statearr_37654_37736[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (15))){
var inst_37533 = (state_37643[(12)]);
var inst_37539 = cljs.core.count(inst_37533);
var inst_37540 = fluree.db.query.fql.add_fuel(fuel,inst_37539,max_fuel);
var state_37643__$1 = state_37643;
var statearr_37655_37737 = state_37643__$1;
(statearr_37655_37737[(2)] = inst_37540);

(statearr_37655_37737[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (48))){
var inst_37502 = (state_37643[(13)]);
var inst_37624 = (state_37643[(14)]);
var inst_37509 = (state_37643[(15)]);
var inst_37632 = (state_37643[(2)]);
var inst_37633 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37502,inst_37632,inst_37624);
var inst_37501 = inst_37509;
var inst_37502__$1 = inst_37633;
var state_37643__$1 = (function (){var statearr_37656 = state_37643;
(statearr_37656[(16)] = inst_37501);

(statearr_37656[(13)] = inst_37502__$1);

return statearr_37656;
})();
var statearr_37657_37738 = state_37643__$1;
(statearr_37657_37738[(2)] = null);

(statearr_37657_37738[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (50))){
var inst_37524 = (state_37643[(17)]);
var state_37643__$1 = state_37643;
var statearr_37658_37739 = state_37643__$1;
(statearr_37658_37739[(2)] = inst_37524);

(statearr_37658_37739[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (21))){
var inst_37521 = (state_37643[(9)]);
var state_37643__$1 = state_37643;
if(cljs.core.truth_(inst_37521)){
var statearr_37660_37740 = state_37643__$1;
(statearr_37660_37740[(1)] = (23));

} else {
var statearr_37661_37741 = state_37643__$1;
(statearr_37661_37741[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (31))){
var inst_37581 = (state_37643[(2)]);
var state_37643__$1 = state_37643;
if(cljs.core.truth_(inst_37581)){
var statearr_37662_37742 = state_37643__$1;
(statearr_37662_37742[(1)] = (32));

} else {
var statearr_37663_37743 = state_37643__$1;
(statearr_37663_37743[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (32))){
var inst_37564 = (state_37643[(18)]);
var inst_37556 = (state_37643[(19)]);
var inst_37557 = (state_37643[(10)]);
var inst_37583 = (inst_37556 + (1));
var tmp37659 = inst_37557;
var inst_37555 = inst_37564;
var inst_37556__$1 = inst_37583;
var inst_37557__$1 = tmp37659;
var state_37643__$1 = (function (){var statearr_37664 = state_37643;
(statearr_37664[(20)] = inst_37555);

(statearr_37664[(19)] = inst_37556__$1);

(statearr_37664[(10)] = inst_37557__$1);

return statearr_37664;
})();
var statearr_37665_37744 = state_37643__$1;
(statearr_37665_37744[(2)] = null);

(statearr_37665_37744[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (40))){
var state_37643__$1 = state_37643;
if(cljs.core.truth_(fuel)){
var statearr_37666_37745 = state_37643__$1;
(statearr_37666_37745[(1)] = (42));

} else {
var statearr_37667_37746 = state_37643__$1;
(statearr_37667_37746[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (33))){
var state_37643__$1 = state_37643;
var statearr_37668_37747 = state_37643__$1;
(statearr_37668_37747[(1)] = (35));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (13))){
var inst_37533 = (state_37643[(12)]);
var state_37643__$1 = state_37643;
var statearr_37670_37748 = state_37643__$1;
(statearr_37670_37748[(2)] = inst_37533);

(statearr_37670_37748[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (22))){
var inst_37574 = (state_37643[(2)]);
var state_37643__$1 = state_37643;
if(cljs.core.truth_(inst_37574)){
var statearr_37671_37749 = state_37643__$1;
(statearr_37671_37749[(1)] = (26));

} else {
var statearr_37672_37750 = state_37643__$1;
(statearr_37672_37750[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (36))){
var state_37643__$1 = state_37643;
var statearr_37673_37751 = state_37643__$1;
(statearr_37673_37751[(2)] = null);

(statearr_37673_37751[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (41))){
var inst_37564 = (state_37643[(18)]);
var inst_37556 = (state_37643[(19)]);
var inst_37613 = (state_37643[(2)]);
var inst_37614 = (inst_37556 + (1));
var inst_37555 = inst_37564;
var inst_37556__$1 = inst_37614;
var inst_37557 = inst_37613;
var state_37643__$1 = (function (){var statearr_37674 = state_37643;
(statearr_37674[(20)] = inst_37555);

(statearr_37674[(19)] = inst_37556__$1);

(statearr_37674[(10)] = inst_37557);

return statearr_37674;
})();
var statearr_37675_37752 = state_37643__$1;
(statearr_37675_37752[(2)] = null);

(statearr_37675_37752[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (43))){
var state_37643__$1 = state_37643;
var statearr_37676_37753 = state_37643__$1;
(statearr_37676_37753[(2)] = null);

(statearr_37676_37753[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (29))){
var inst_37520 = (state_37643[(8)]);
var inst_37556 = (state_37643[(19)]);
var inst_37578 = (inst_37556 < inst_37520);
var state_37643__$1 = state_37643;
var statearr_37677_37754 = state_37643__$1;
(statearr_37677_37754[(2)] = inst_37578);

(statearr_37677_37754[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (44))){
var inst_37597 = (state_37643[(21)]);
var inst_37593 = (state_37643[(22)]);
var inst_37606 = (state_37643[(2)]);
var inst_37607 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_37597,inst_37593) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_37597,inst_37593));
var state_37643__$1 = (function (){var statearr_37678 = state_37643;
(statearr_37678[(23)] = inst_37606);

return statearr_37678;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37643__$1,(45),inst_37607);
} else {
if((state_val_37644 === (6))){
var inst_37501 = (state_37643[(16)]);
var inst_37508 = (state_37643[(24)]);
var inst_37507 = cljs.core.seq(inst_37501);
var inst_37508__$1 = cljs.core.first(inst_37507);
var inst_37509 = cljs.core.next(inst_37507);
var inst_37510 = cljs.core.not(inst_37508__$1);
var state_37643__$1 = (function (){var statearr_37679 = state_37643;
(statearr_37679[(24)] = inst_37508__$1);

(statearr_37679[(15)] = inst_37509);

return statearr_37679;
})();
if(inst_37510){
var statearr_37680_37755 = state_37643__$1;
(statearr_37680_37755[(1)] = (8));

} else {
var statearr_37681_37756 = state_37643__$1;
(statearr_37681_37756[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (28))){
var inst_37622 = (state_37643[(2)]);
var state_37643__$1 = state_37643;
var statearr_37682_37757 = state_37643__$1;
(statearr_37682_37757[(2)] = inst_37622);

(statearr_37682_37757[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (51))){
var inst_37630 = (state_37643[(2)]);
var state_37643__$1 = state_37643;
var statearr_37683_37758 = state_37643__$1;
(statearr_37683_37758[(2)] = inst_37630);

(statearr_37683_37758[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (25))){
var inst_37572 = (state_37643[(2)]);
var state_37643__$1 = state_37643;
var statearr_37684_37759 = state_37643__$1;
(statearr_37684_37759[(2)] = inst_37572);

(statearr_37684_37759[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (34))){
var inst_37620 = (state_37643[(2)]);
var state_37643__$1 = state_37643;
var statearr_37685_37760 = state_37643__$1;
(statearr_37685_37760[(2)] = inst_37620);

(statearr_37685_37760[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (17))){
var inst_37533 = (state_37643[(12)]);
var inst_37543 = (state_37643[(2)]);
var inst_37551 = cljs.core.seq(inst_37533);
var inst_37552 = cljs.core.first(inst_37551);
var inst_37553 = cljs.core.next(inst_37551);
var inst_37554 = cljs.core.PersistentVector.EMPTY;
var inst_37555 = inst_37533;
var inst_37556 = (0);
var inst_37557 = inst_37554;
var state_37643__$1 = (function (){var statearr_37686 = state_37643;
(statearr_37686[(20)] = inst_37555);

(statearr_37686[(25)] = inst_37552);

(statearr_37686[(19)] = inst_37556);

(statearr_37686[(10)] = inst_37557);

(statearr_37686[(26)] = inst_37553);

(statearr_37686[(27)] = inst_37543);

return statearr_37686;
})();
var statearr_37687_37761 = state_37643__$1;
(statearr_37687_37761[(2)] = null);

(statearr_37687_37761[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (3))){
var inst_37641 = (state_37643[(2)]);
var state_37643__$1 = state_37643;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37643__$1,inst_37641);
} else {
if((state_val_37644 === (12))){
var state_37643__$1 = state_37643;
var statearr_37688_37762 = state_37643__$1;
(statearr_37688_37762[(2)] = fuel);

(statearr_37688_37762[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (2))){
var _ = (function (){var statearr_37689 = state_37643;
(statearr_37689[(4)] = cljs.core.cons((5),(state_37643[(4)])));

return statearr_37689;
})();
var inst_37497 = reverse_refs_specs;
var inst_37498 = cljs.core.seq(inst_37497);
var inst_37499 = cljs.core.first(inst_37498);
var inst_37500 = cljs.core.next(inst_37498);
var inst_37501 = inst_37497;
var inst_37502 = null;
var state_37643__$1 = (function (){var statearr_37690 = state_37643;
(statearr_37690[(16)] = inst_37501);

(statearr_37690[(28)] = inst_37500);

(statearr_37690[(29)] = inst_37499);

(statearr_37690[(13)] = inst_37502);

return statearr_37690;
})();
var statearr_37691_37763 = state_37643__$1;
(statearr_37691_37763[(2)] = null);

(statearr_37691_37763[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (23))){
var inst_37556 = (state_37643[(19)]);
var inst_37521 = (state_37643[(9)]);
var inst_37569 = (inst_37556 >= inst_37521);
var state_37643__$1 = state_37643;
var statearr_37692_37764 = state_37643__$1;
(statearr_37692_37764[(2)] = inst_37569);

(statearr_37692_37764[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (47))){
var inst_37523 = (state_37643[(30)]);
var state_37643__$1 = state_37643;
if(cljs.core.truth_(inst_37523)){
var statearr_37693_37765 = state_37643__$1;
(statearr_37693_37765[(1)] = (49));

} else {
var statearr_37694_37766 = state_37643__$1;
(statearr_37694_37766[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (35))){
var inst_37563 = (state_37643[(31)]);
var inst_37587 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37588 = [inst_37563];
var inst_37589 = (new cljs.core.PersistentVector(null,1,(5),inst_37587,inst_37588,null));
var inst_37590 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_37589);
var state_37643__$1 = state_37643;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37643__$1,(38),inst_37590);
} else {
if((state_val_37644 === (19))){
var inst_37522 = (state_37643[(11)]);
var inst_37624 = (state_37643[(2)]);
var state_37643__$1 = (function (){var statearr_37695 = state_37643;
(statearr_37695[(14)] = inst_37624);

return statearr_37695;
})();
if(cljs.core.truth_(inst_37522)){
var statearr_37696_37767 = state_37643__$1;
(statearr_37696_37767[(1)] = (46));

} else {
var statearr_37697_37768 = state_37643__$1;
(statearr_37697_37768[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (11))){
var inst_37533 = (state_37643[(12)]);
var inst_37530 = (state_37643[(2)]);
var inst_37531 = fluree.db.util.async.throw_err(inst_37530);
var inst_37532 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_37531);
var inst_37533__$1 = cljs.core.not_empty(inst_37532);
var state_37643__$1 = (function (){var statearr_37699 = state_37643;
(statearr_37699[(12)] = inst_37533__$1);

return statearr_37699;
})();
if(cljs.core.truth_(inst_37533__$1)){
var statearr_37700_37769 = state_37643__$1;
(statearr_37700_37769[(1)] = (12));

} else {
var statearr_37701_37770 = state_37643__$1;
(statearr_37701_37770[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (9))){
var inst_37518 = (state_37643[(32)]);
var inst_37508 = (state_37643[(24)]);
var inst_37517 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37508,(0),null);
var inst_37518__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37508,(1),null);
var inst_37519 = cljs.core.__destructure_map(inst_37518__$1);
var inst_37520 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37519,cljs.core.cst$kw$offset);
var inst_37521 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37519,cljs.core.cst$kw$limit);
var inst_37522 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37519,cljs.core.cst$kw$as);
var inst_37523 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37519,cljs.core.cst$kw$name);
var inst_37524 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37519,cljs.core.cst$kw$p);
var inst_37525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37526 = [subject_id,inst_37517];
var inst_37527 = (new cljs.core.PersistentVector(null,2,(5),inst_37525,inst_37526,null));
var inst_37528 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_37527);
var state_37643__$1 = (function (){var statearr_37702 = state_37643;
(statearr_37702[(11)] = inst_37522);

(statearr_37702[(17)] = inst_37524);

(statearr_37702[(32)] = inst_37518__$1);

(statearr_37702[(8)] = inst_37520);

(statearr_37702[(30)] = inst_37523);

(statearr_37702[(9)] = inst_37521);

return statearr_37702;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37643__$1,(11),inst_37528);
} else {
if((state_val_37644 === (5))){
var _ = (function (){var statearr_37703 = state_37643;
(statearr_37703[(4)] = cljs.core.rest((state_37643[(4)])));

return statearr_37703;
})();
var state_37643__$1 = state_37643;
var ex37698 = (state_37643__$1[(2)]);
var statearr_37704_37771 = state_37643__$1;
(statearr_37704_37771[(5)] = ex37698);


if((ex37698 instanceof Error)){
var statearr_37705_37772 = state_37643__$1;
(statearr_37705_37772[(1)] = (4));

(statearr_37705_37772[(5)] = null);

} else {
throw ex37698;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (14))){
var inst_37537 = (state_37643[(2)]);
var state_37643__$1 = state_37643;
if(cljs.core.truth_(inst_37537)){
var statearr_37706_37773 = state_37643__$1;
(statearr_37706_37773[(1)] = (15));

} else {
var statearr_37707_37774 = state_37643__$1;
(statearr_37707_37774[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (45))){
var inst_37557 = (state_37643[(10)]);
var inst_37609 = (state_37643[(2)]);
var inst_37610 = fluree.db.util.async.throw_err(inst_37609);
var inst_37611 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37557,inst_37610);
var state_37643__$1 = state_37643;
var statearr_37708_37775 = state_37643__$1;
(statearr_37708_37775[(2)] = inst_37611);

(statearr_37708_37775[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (26))){
var inst_37557 = (state_37643[(10)]);
var state_37643__$1 = state_37643;
var statearr_37709_37776 = state_37643__$1;
(statearr_37709_37776[(2)] = inst_37557);

(statearr_37709_37776[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (16))){
var state_37643__$1 = state_37643;
var statearr_37710_37777 = state_37643__$1;
(statearr_37710_37777[(2)] = null);

(statearr_37710_37777[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (38))){
var inst_37518 = (state_37643[(32)]);
var inst_37593 = (state_37643[(22)]);
var inst_37592 = (state_37643[(2)]);
var inst_37593__$1 = fluree.db.util.async.throw_err(inst_37592);
var inst_37594 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37595 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$limit];
var inst_37596 = (new cljs.core.PersistentVector(null,4,(5),inst_37594,inst_37595,null));
var inst_37597 = cljs.core.select_keys(inst_37518,inst_37596);
var inst_37598 = cljs.core.empty_QMARK_(inst_37593__$1);
var state_37643__$1 = (function (){var statearr_37711 = state_37643;
(statearr_37711[(21)] = inst_37597);

(statearr_37711[(22)] = inst_37593__$1);

return statearr_37711;
})();
if(inst_37598){
var statearr_37712_37778 = state_37643__$1;
(statearr_37712_37778[(1)] = (39));

} else {
var statearr_37713_37779 = state_37643__$1;
(statearr_37713_37779[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (30))){
var inst_37520 = (state_37643[(8)]);
var state_37643__$1 = state_37643;
var statearr_37714_37780 = state_37643__$1;
(statearr_37714_37780[(2)] = inst_37520);

(statearr_37714_37780[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (10))){
var inst_37636 = (state_37643[(2)]);
var state_37643__$1 = state_37643;
var statearr_37715_37781 = state_37643__$1;
(statearr_37715_37781[(2)] = inst_37636);

(statearr_37715_37781[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (18))){
var inst_37555 = (state_37643[(20)]);
var inst_37565 = (state_37643[(7)]);
var inst_37563 = (state_37643[(31)]);
var inst_37562 = cljs.core.seq(inst_37555);
var inst_37563__$1 = cljs.core.first(inst_37562);
var inst_37564 = cljs.core.next(inst_37562);
var inst_37565__$1 = cljs.core.not(inst_37563__$1);
var state_37643__$1 = (function (){var statearr_37716 = state_37643;
(statearr_37716[(18)] = inst_37564);

(statearr_37716[(7)] = inst_37565__$1);

(statearr_37716[(31)] = inst_37563__$1);

return statearr_37716;
})();
if(inst_37565__$1){
var statearr_37717_37782 = state_37643__$1;
(statearr_37717_37782[(1)] = (20));

} else {
var statearr_37718_37783 = state_37643__$1;
(statearr_37718_37783[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (42))){
var inst_37593 = (state_37643[(22)]);
var inst_37602 = cljs.core.count(inst_37593);
var inst_37603 = fluree.db.query.fql.add_fuel(fuel,inst_37602,max_fuel);
var state_37643__$1 = state_37643;
var statearr_37719_37784 = state_37643__$1;
(statearr_37719_37784[(2)] = inst_37603);

(statearr_37719_37784[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (37))){
var inst_37618 = (state_37643[(2)]);
var state_37643__$1 = state_37643;
var statearr_37720_37785 = state_37643__$1;
(statearr_37720_37785[(2)] = inst_37618);

(statearr_37720_37785[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (8))){
var inst_37502 = (state_37643[(13)]);
var state_37643__$1 = state_37643;
var statearr_37721_37786 = state_37643__$1;
(statearr_37721_37786[(2)] = inst_37502);

(statearr_37721_37786[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37644 === (49))){
var inst_37523 = (state_37643[(30)]);
var state_37643__$1 = state_37643;
var statearr_37722_37787 = state_37643__$1;
(statearr_37722_37787[(2)] = inst_37523);

(statearr_37722_37787[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__15091__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__15091__auto____0 = (function (){
var statearr_37723 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37723[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__15091__auto__);

(statearr_37723[(1)] = (1));

return statearr_37723;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__15091__auto____1 = (function (state_37643){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_37643);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e37724){var ex__15094__auto__ = e37724;
var statearr_37725_37788 = state_37643;
(statearr_37725_37788[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_37643[(4)]))){
var statearr_37726_37789 = state_37643;
(statearr_37726_37789[(1)] = cljs.core.first((state_37643[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__37790 = state_37643;
state_37643 = G__37790;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__15091__auto__ = function(state_37643){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__15091__auto____1.call(this,state_37643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__15091__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__15091__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_37727 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_37727[(6)] = c__15165__auto__);

return statearr_37727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,cljs.core.cst$kw$componentFollow_QMARK_)){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__37791 = select_spec;
var map__37791__$1 = cljs.core.__destructure_map(map__37791);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37791__$1,cljs.core.cst$kw$recur_DASH_seen);
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37791__$1,cljs.core.cst$kw$recur_DASH_depth);
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_depth], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_seen], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$compact_QMARK_], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_37905){
var state_val_37906 = (state_37905[(1)]);
if((state_val_37906 === (7))){
var inst_37817 = flakes;
var inst_37818 = cljs.core.seq(inst_37817);
var inst_37819 = cljs.core.first(inst_37818);
var inst_37820 = cljs.core.next(inst_37818);
var inst_37821 = cljs.core.PersistentVector.EMPTY;
var inst_37822 = inst_37817;
var inst_37823 = (0);
var inst_37824 = inst_37821;
var state_37905__$1 = (function (){var statearr_37907 = state_37905;
(statearr_37907[(7)] = inst_37819);

(statearr_37907[(8)] = inst_37820);

(statearr_37907[(9)] = inst_37824);

(statearr_37907[(10)] = inst_37823);

(statearr_37907[(11)] = inst_37822);

return statearr_37907;
})();
var statearr_37908_37974 = state_37905__$1;
(statearr_37908_37974[(2)] = null);

(statearr_37908_37974[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (20))){
var state_37905__$1 = state_37905;
var statearr_37909_37975 = state_37905__$1;
(statearr_37909_37975[(2)] = results);

(statearr_37909_37975[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (27))){
var state_37905__$1 = state_37905;
var statearr_37910_37976 = state_37905__$1;
(statearr_37910_37976[(2)] = null);

(statearr_37910_37976[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (1))){
var state_37905__$1 = state_37905;
var statearr_37911_37977 = state_37905__$1;
(statearr_37911_37977[(2)] = null);

(statearr_37911_37977[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (24))){
var state_37905__$1 = state_37905;
var statearr_37912_37978 = state_37905__$1;
(statearr_37912_37978[(1)] = (26));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (39))){
var inst_37886 = (state_37905[(12)]);
var inst_37831 = (state_37905[(13)]);
var inst_37824 = (state_37905[(9)]);
var inst_37889 = (state_37905[(2)]);
var inst_37890 = fluree.db.util.async.throw_err(inst_37889);
var inst_37891 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37824,inst_37890);
var inst_37822 = inst_37831;
var inst_37823 = inst_37886;
var inst_37824__$1 = inst_37891;
var state_37905__$1 = (function (){var statearr_37914 = state_37905;
(statearr_37914[(9)] = inst_37824__$1);

(statearr_37914[(10)] = inst_37823);

(statearr_37914[(11)] = inst_37822);

return statearr_37914;
})();
var statearr_37915_37979 = state_37905__$1;
(statearr_37915_37979[(2)] = null);

(statearr_37915_37979[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (4))){
var inst_37792 = (state_37905[(2)]);
var state_37905__$1 = state_37905;
var statearr_37916_37980 = state_37905__$1;
(statearr_37916_37980[(2)] = inst_37792);

(statearr_37916_37980[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (15))){
var inst_37805 = (state_37905[(14)]);
var state_37905__$1 = state_37905;
var statearr_37917_37981 = state_37905__$1;
(statearr_37917_37981[(2)] = inst_37805);

(statearr_37917_37981[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (21))){
var inst_37801 = (state_37905[(15)]);
var state_37905__$1 = state_37905;
if(cljs.core.truth_(inst_37801)){
var statearr_37918_37982 = state_37905__$1;
(statearr_37918_37982[(1)] = (23));

} else {
var statearr_37919_37983 = state_37905__$1;
(statearr_37919_37983[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (31))){
var inst_37869 = (state_37905[(16)]);
var state_37905__$1 = state_37905;
var statearr_37920_37984 = state_37905__$1;
(statearr_37920_37984[(2)] = inst_37869);

(statearr_37920_37984[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (32))){
var inst_37861 = (state_37905[(17)]);
var inst_37875 = (state_37905[(2)]);
var state_37905__$1 = (function (){var statearr_37921 = state_37905;
(statearr_37921[(18)] = inst_37875);

return statearr_37921;
})();
if(cljs.core.truth_(inst_37861)){
var statearr_37922_37985 = state_37905__$1;
(statearr_37922_37985[(1)] = (33));

} else {
var statearr_37923_37986 = state_37905__$1;
(statearr_37923_37986[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (33))){
var inst_37861 = (state_37905[(17)]);
var state_37905__$1 = state_37905;
var statearr_37924_37987 = state_37905__$1;
(statearr_37924_37987[(2)] = inst_37861);

(statearr_37924_37987[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (13))){
var inst_37841 = (state_37905[(2)]);
var state_37905__$1 = state_37905;
if(cljs.core.truth_(inst_37841)){
var statearr_37926_37988 = state_37905__$1;
(statearr_37926_37988[(1)] = (17));

} else {
var statearr_37927_37989 = state_37905__$1;
(statearr_37927_37989[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (22))){
var inst_37858 = (state_37905[(2)]);
var state_37905__$1 = state_37905;
var statearr_37928_37990 = state_37905__$1;
(statearr_37928_37990[(2)] = inst_37858);

(statearr_37928_37990[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (36))){
var inst_37831 = (state_37905[(13)]);
var inst_37824 = (state_37905[(9)]);
var inst_37823 = (state_37905[(10)]);
var inst_37883 = (inst_37823 + (1));
var tmp37925 = inst_37824;
var inst_37822 = inst_37831;
var inst_37823__$1 = inst_37883;
var inst_37824__$1 = tmp37925;
var state_37905__$1 = (function (){var statearr_37929 = state_37905;
(statearr_37929[(9)] = inst_37824__$1);

(statearr_37929[(10)] = inst_37823__$1);

(statearr_37929[(11)] = inst_37822);

return statearr_37929;
})();
var statearr_37930_37991 = state_37905__$1;
(statearr_37930_37991[(2)] = null);

(statearr_37930_37991[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (29))){
var inst_37868 = (state_37905[(2)]);
var inst_37869 = fluree.db.util.async.throw_err(inst_37868);
var state_37905__$1 = (function (){var statearr_37931 = state_37905;
(statearr_37931[(16)] = inst_37869);

return statearr_37931;
})();
if(cljs.core.truth_(fuel)){
var statearr_37932_37992 = state_37905__$1;
(statearr_37932_37992[(1)] = (30));

} else {
var statearr_37933_37993 = state_37905__$1;
(statearr_37933_37993[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (6))){
var state_37905__$1 = state_37905;
var statearr_37934_37994 = state_37905__$1;
(statearr_37934_37994[(2)] = results);

(statearr_37934_37994[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (28))){
var inst_37854 = (state_37905[(2)]);
var state_37905__$1 = state_37905;
var statearr_37935_37995 = state_37905__$1;
(statearr_37935_37995[(2)] = inst_37854);

(statearr_37935_37995[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (25))){
var inst_37856 = (state_37905[(2)]);
var state_37905__$1 = state_37905;
var statearr_37936_37996 = state_37905__$1;
(statearr_37936_37996[(2)] = inst_37856);

(statearr_37936_37996[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (34))){
var inst_37875 = (state_37905[(18)]);
var inst_37878 = cljs.core.empty_QMARK_(inst_37875);
var state_37905__$1 = state_37905;
var statearr_37937_37997 = state_37905__$1;
(statearr_37937_37997[(2)] = inst_37878);

(statearr_37937_37997[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (17))){
var inst_37824 = (state_37905[(9)]);
var inst_37843 = cljs.core.empty_QMARK_(inst_37824);
var state_37905__$1 = state_37905;
if(inst_37843){
var statearr_37938_37998 = state_37905__$1;
(statearr_37938_37998[(1)] = (20));

} else {
var statearr_37939_37999 = state_37905__$1;
(statearr_37939_37999[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (3))){
var inst_37903 = (state_37905[(2)]);
var state_37905__$1 = state_37905;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37905__$1,inst_37903);
} else {
if((state_val_37906 === (12))){
var inst_37805 = (state_37905[(14)]);
var state_37905__$1 = state_37905;
if(cljs.core.truth_(inst_37805)){
var statearr_37940_38000 = state_37905__$1;
(statearr_37940_38000[(1)] = (14));

} else {
var statearr_37941_38001 = state_37905__$1;
(statearr_37941_38001[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (2))){
var _ = (function (){var statearr_37942 = state_37905;
(statearr_37942[(4)] = cljs.core.cons((5),(state_37905[(4)])));

return statearr_37942;
})();
var inst_37799 = select_spec;
var inst_37800 = cljs.core.__destructure_map(inst_37799);
var inst_37801 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37800,cljs.core.cst$kw$multi_QMARK_);
var inst_37802 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37800,cljs.core.cst$kw$as);
var inst_37803 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37800,cljs.core.cst$kw$recur_DASH_seen);
var inst_37804 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37800,cljs.core.cst$kw$recur_DASH_depth);
var inst_37805 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37800,cljs.core.cst$kw$limit);
var inst_37806 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_37807 = (inst_37804 > inst_37806);
var state_37905__$1 = (function (){var statearr_37943 = state_37905;
(statearr_37943[(15)] = inst_37801);

(statearr_37943[(19)] = inst_37802);

(statearr_37943[(20)] = inst_37803);

(statearr_37943[(14)] = inst_37805);

return statearr_37943;
})();
if(cljs.core.truth_(inst_37807)){
var statearr_37944_38002 = state_37905__$1;
(statearr_37944_38002[(1)] = (6));

} else {
var statearr_37945_38003 = state_37905__$1;
(statearr_37945_38003[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (23))){
var inst_37802 = (state_37905[(19)]);
var inst_37824 = (state_37905[(9)]);
var inst_37847 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_37802,inst_37824);
var state_37905__$1 = state_37905;
var statearr_37946_38004 = state_37905__$1;
(statearr_37946_38004[(2)] = inst_37847);

(statearr_37946_38004[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (35))){
var inst_37830 = (state_37905[(21)]);
var inst_37880 = (state_37905[(2)]);
var inst_37881 = fluree.db.query.fql.recur_select_spec(select_spec,inst_37830);
var state_37905__$1 = (function (){var statearr_37947 = state_37905;
(statearr_37947[(22)] = inst_37881);

return statearr_37947;
})();
if(cljs.core.truth_(inst_37880)){
var statearr_37948_38005 = state_37905__$1;
(statearr_37948_38005[(1)] = (36));

} else {
var statearr_37949_38006 = state_37905__$1;
(statearr_37949_38006[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (19))){
var inst_37896 = (state_37905[(2)]);
var state_37905__$1 = state_37905;
var statearr_37950_38007 = state_37905__$1;
(statearr_37950_38007[(2)] = inst_37896);

(statearr_37950_38007[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (11))){
var inst_37832 = (state_37905[(23)]);
var state_37905__$1 = state_37905;
var statearr_37952_38008 = state_37905__$1;
(statearr_37952_38008[(2)] = inst_37832);

(statearr_37952_38008[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (9))){
var inst_37830 = (state_37905[(21)]);
var inst_37822 = (state_37905[(11)]);
var inst_37832 = (state_37905[(23)]);
var inst_37829 = cljs.core.seq(inst_37822);
var inst_37830__$1 = cljs.core.first(inst_37829);
var inst_37831 = cljs.core.next(inst_37829);
var inst_37832__$1 = cljs.core.not(inst_37830__$1);
var state_37905__$1 = (function (){var statearr_37953 = state_37905;
(statearr_37953[(21)] = inst_37830__$1);

(statearr_37953[(13)] = inst_37831);

(statearr_37953[(23)] = inst_37832__$1);

return statearr_37953;
})();
if(inst_37832__$1){
var statearr_37954_38009 = state_37905__$1;
(statearr_37954_38009[(1)] = (11));

} else {
var statearr_37955_38010 = state_37905__$1;
(statearr_37955_38010[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (5))){
var _ = (function (){var statearr_37956 = state_37905;
(statearr_37956[(4)] = cljs.core.rest((state_37905[(4)])));

return statearr_37956;
})();
var state_37905__$1 = state_37905;
var ex37951 = (state_37905__$1[(2)]);
var statearr_37957_38011 = state_37905__$1;
(statearr_37957_38011[(5)] = ex37951);


if((ex37951 instanceof Error)){
var statearr_37958_38012 = state_37905__$1;
(statearr_37958_38012[(1)] = (4));

(statearr_37958_38012[(5)] = null);

} else {
throw ex37951;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (14))){
var inst_37823 = (state_37905[(10)]);
var inst_37805 = (state_37905[(14)]);
var inst_37836 = (inst_37823 < inst_37805);
var state_37905__$1 = state_37905;
var statearr_37959_38013 = state_37905__$1;
(statearr_37959_38013[(2)] = inst_37836);

(statearr_37959_38013[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (26))){
var inst_37802 = (state_37905[(19)]);
var inst_37824 = (state_37905[(9)]);
var inst_37850 = cljs.core.first(inst_37824);
var inst_37851 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_37802,inst_37850);
var state_37905__$1 = state_37905;
var statearr_37960_38014 = state_37905__$1;
(statearr_37960_38014[(2)] = inst_37851);

(statearr_37960_38014[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (16))){
var inst_37839 = (state_37905[(2)]);
var state_37905__$1 = state_37905;
var statearr_37961_38015 = state_37905__$1;
(statearr_37961_38015[(2)] = inst_37839);

(statearr_37961_38015[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (38))){
var inst_37894 = (state_37905[(2)]);
var state_37905__$1 = state_37905;
var statearr_37962_38016 = state_37905__$1;
(statearr_37962_38016[(2)] = inst_37894);

(statearr_37962_38016[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (30))){
var inst_37869 = (state_37905[(16)]);
var inst_37871 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_37872 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_37871,inst_37869);
var state_37905__$1 = state_37905;
var statearr_37963_38017 = state_37905__$1;
(statearr_37963_38017[(2)] = inst_37872);

(statearr_37963_38017[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (10))){
var inst_37898 = (state_37905[(2)]);
var state_37905__$1 = state_37905;
var statearr_37964_38018 = state_37905__$1;
(statearr_37964_38018[(2)] = inst_37898);

(statearr_37964_38018[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37906 === (18))){
var inst_37830 = (state_37905[(21)]);
var inst_37803 = (state_37905[(20)]);
var inst_37860 = inst_37830.o;
var inst_37861 = cljs.core.contains_QMARK_(inst_37803,inst_37860);
var inst_37863 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37864 = [inst_37860];
var inst_37865 = (new cljs.core.PersistentVector(null,1,(5),inst_37863,inst_37864,null));
var inst_37866 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_37865);
var state_37905__$1 = (function (){var statearr_37965 = state_37905;
(statearr_37965[(17)] = inst_37861);

return statearr_37965;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37905__$1,(29),inst_37866);
} else {
if((state_val_37906 === (37))){
var inst_37881 = (state_37905[(22)]);
var inst_37823 = (state_37905[(10)]);
var inst_37875 = (state_37905[(18)]);
var inst_37886 = (inst_37823 + (1));
var inst_37887 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_37881,inst_37875) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_37881,inst_37875));
var state_37905__$1 = (function (){var statearr_37966 = state_37905;
(statearr_37966[(12)] = inst_37886);

return statearr_37966;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37905__$1,(39),inst_37887);
} else {
if((state_val_37906 === (8))){
var inst_37900 = (state_37905[(2)]);
var _ = (function (){var statearr_37967 = state_37905;
(statearr_37967[(4)] = cljs.core.rest((state_37905[(4)])));

return statearr_37967;
})();
var state_37905__$1 = state_37905;
var statearr_37968_38019 = state_37905__$1;
(statearr_37968_38019[(2)] = inst_37900);

(statearr_37968_38019[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__15091__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__15091__auto____0 = (function (){
var statearr_37969 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37969[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__15091__auto__);

(statearr_37969[(1)] = (1));

return statearr_37969;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__15091__auto____1 = (function (state_37905){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_37905);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e37970){var ex__15094__auto__ = e37970;
var statearr_37971_38020 = state_37905;
(statearr_37971_38020[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_37905[(4)]))){
var statearr_37972_38021 = state_37905;
(statearr_37972_38021[(1)] = cljs.core.first((state_37905[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__38022 = state_37905;
state_37905 = G__38022;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__15091__auto__ = function(state_37905){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__15091__auto____1.call(this,state_37905);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__15091__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__15091__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_37973 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_37973[(6)] = c__15165__auto__);

return statearr_37973;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_38203){
var state_val_38204 = (state_38203[(1)]);
if((state_val_38204 === (7))){
var state_38203__$1 = state_38203;
var statearr_38205_38291 = state_38203__$1;
(statearr_38205_38291[(2)] = null);

(statearr_38205_38291[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (20))){
var inst_38061 = cljs.core.PersistentHashMap.EMPTY;
var state_38203__$1 = state_38203;
var statearr_38206_38292 = state_38203__$1;
(statearr_38206_38292[(2)] = inst_38061);

(statearr_38206_38292[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (27))){
var inst_38049 = (state_38203[(7)]);
var inst_38043 = (state_38203[(8)]);
var inst_38079 = (state_38203[(9)]);
var inst_38063 = (state_38203[(10)]);
var inst_38182 = (state_38203[(2)]);
var inst_38183 = (function (){var top_level_subject = inst_38043;
var select_spec = inst_38049;
var base_acc = inst_38063;
var acc_PLUS_refs = inst_38079;
var result = inst_38182;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__5045__auto__ = (function (){var and__5043__auto__ = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto__ = cljs.core.cst$kw$reverse_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(spec),cljs.core.cst$kw$order.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$predicate.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_38184 = cljs.core.PersistentVector.EMPTY;
var inst_38185 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_38049);
var inst_38186 = cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(inst_38185);
var inst_38187 = cljs.core.vals(inst_38186);
var inst_38188 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_38049);
var inst_38189 = cljs.core.cst$kw$reverse.cljs$core$IFn$_invoke$arity$1(inst_38188);
var inst_38190 = cljs.core.vals(inst_38189);
var inst_38191 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_38187,inst_38190);
var inst_38192 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_38183,inst_38184,inst_38191);
var inst_38194 = (function (){var top_level_subject = inst_38043;
var select_spec = inst_38049;
var base_acc = inst_38063;
var acc_PLUS_refs = inst_38079;
var result = inst_38182;
var sort_preds = inst_38192;
return (function (acc,p__38193){
var vec__38207 = p__38193;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38207,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38207,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38207,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38207,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_38195 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_38194,inst_38182,inst_38192);
var state_38203__$1 = state_38203;
var statearr_38210_38293 = state_38203__$1;
(statearr_38210_38293[(2)] = inst_38195);

(statearr_38210_38293[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (1))){
var state_38203__$1 = state_38203;
var statearr_38211_38294 = state_38203__$1;
(statearr_38211_38294[(2)] = null);

(statearr_38211_38294[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (24))){
var inst_38079 = (state_38203[(9)]);
var inst_38079__$1 = (state_38203[(2)]);
var inst_38080 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$p,flakes);
var inst_38081 = cljs.core.PersistentHashMap.EMPTY;
var inst_38082 = inst_38080;
var inst_38083 = inst_38079__$1;
var inst_38084 = inst_38081;
var state_38203__$1 = (function (){var statearr_38212 = state_38203;
(statearr_38212[(11)] = inst_38083);

(statearr_38212[(12)] = inst_38082);

(statearr_38212[(13)] = inst_38084);

(statearr_38212[(9)] = inst_38079__$1);

return statearr_38212;
})();
var statearr_38213_38295 = state_38203__$1;
(statearr_38213_38295[(2)] = null);

(statearr_38213_38295[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (39))){
var inst_38092 = (state_38203[(14)]);
var inst_38083 = (state_38203[(11)]);
var inst_38049 = (state_38203[(7)]);
var inst_38099 = (state_38203[(15)]);
var inst_38128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38129 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_38083,inst_38049,inst_38092,inst_38099,false);
var state_38203__$1 = (function (){var statearr_38214 = state_38203;
(statearr_38214[(16)] = inst_38128);

return statearr_38214;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38203__$1,(42),inst_38129);
} else {
if((state_val_38204 === (46))){
var inst_38092 = (state_38203[(14)]);
var inst_38082 = (state_38203[(12)]);
var inst_38084 = (state_38203[(13)]);
var inst_38146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38147 = [cljs.core.cst$kw$_id];
var inst_38148 = cljs.core.first(inst_38092);
var inst_38149 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(inst_38148);
var inst_38150 = [inst_38149];
var inst_38151 = cljs.core.PersistentHashMap.fromArrays(inst_38147,inst_38150);
var inst_38152 = cljs.core.rest(inst_38082);
var inst_38153 = [inst_38151,inst_38152,inst_38084];
var inst_38154 = (new cljs.core.PersistentVector(null,3,(5),inst_38146,inst_38153,null));
var state_38203__$1 = state_38203;
var statearr_38215_38296 = state_38203__$1;
(statearr_38215_38296[(2)] = inst_38154);

(statearr_38215_38296[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (4))){
var inst_38023 = (state_38203[(2)]);
var state_38203__$1 = state_38203;
var statearr_38216_38297 = state_38203__$1;
(statearr_38216_38297[(2)] = inst_38023);

(statearr_38216_38297[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (15))){
var inst_38049 = (state_38203[(7)]);
var inst_38050 = (state_38203[(17)]);
var inst_38049__$1 = (state_38203[(2)]);
var inst_38050__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_38049__$1);
var state_38203__$1 = (function (){var statearr_38217 = state_38203;
(statearr_38217[(7)] = inst_38049__$1);

(statearr_38217[(17)] = inst_38050__$1);

return statearr_38217;
})();
if(cljs.core.truth_(inst_38050__$1)){
var statearr_38218_38298 = state_38203__$1;
(statearr_38218_38298[(1)] = (16));

} else {
var statearr_38219_38299 = state_38203__$1;
(statearr_38219_38299[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (48))){
var inst_38165 = (state_38203[(2)]);
var state_38203__$1 = state_38203;
var statearr_38220_38300 = state_38203__$1;
(statearr_38220_38300[(2)] = inst_38165);

(statearr_38220_38300[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (50))){
var state_38203__$1 = state_38203;
var statearr_38221_38301 = state_38203__$1;
(statearr_38221_38301[(2)] = null);

(statearr_38221_38301[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (21))){
var inst_38049 = (state_38203[(7)]);
var inst_38063 = (state_38203[(2)]);
var inst_38064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38065 = [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse];
var inst_38066 = (new cljs.core.PersistentVector(null,2,(5),inst_38064,inst_38065,null));
var inst_38067 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38049,inst_38066);
var state_38203__$1 = (function (){var statearr_38222 = state_38203;
(statearr_38222[(10)] = inst_38063);

return statearr_38222;
})();
if(cljs.core.truth_(inst_38067)){
var statearr_38223_38302 = state_38203__$1;
(statearr_38223_38302[(1)] = (22));

} else {
var statearr_38224_38303 = state_38203__$1;
(statearr_38224_38303[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (31))){
var inst_38092 = (state_38203[(14)]);
var inst_38098 = (state_38203[(18)]);
var inst_38083 = (state_38203[(11)]);
var inst_38102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38103 = fluree.db.query.fql.flake__GT_recur(db,inst_38092,inst_38098,inst_38083,fuel,max_fuel,cache);
var state_38203__$1 = (function (){var statearr_38225 = state_38203;
(statearr_38225[(19)] = inst_38102);

return statearr_38225;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38203__$1,(34),inst_38103);
} else {
if((state_val_38204 === (32))){
var inst_38098 = (state_38203[(18)]);
var state_38203__$1 = state_38203;
if(cljs.core.truth_(inst_38098)){
var statearr_38226_38304 = state_38203__$1;
(statearr_38226_38304[(1)] = (35));

} else {
var statearr_38227_38305 = state_38203__$1;
(statearr_38227_38305[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (40))){
var inst_38049 = (state_38203[(7)]);
var inst_38139 = (state_38203[(20)]);
var inst_38138 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_38049);
var inst_38139__$1 = cljs.core.empty_QMARK_(inst_38138);
var state_38203__$1 = (function (){var statearr_38228 = state_38203;
(statearr_38228[(20)] = inst_38139__$1);

return statearr_38228;
})();
if(inst_38139__$1){
var statearr_38229_38306 = state_38203__$1;
(statearr_38229_38306[(1)] = (43));

} else {
var statearr_38230_38307 = state_38203__$1;
(statearr_38230_38307[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (33))){
var inst_38092 = (state_38203[(14)]);
var inst_38171 = (state_38203[(2)]);
var inst_38172 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38171,(0),null);
var inst_38173 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38171,(1),null);
var inst_38174 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38171,(2),null);
var inst_38175 = cljs.core.first(inst_38092);
var inst_38176 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(inst_38175);
var inst_38177 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38172,cljs.core.cst$kw$_id,inst_38176);
var inst_38082 = inst_38173;
var inst_38083 = inst_38177;
var inst_38084 = inst_38174;
var state_38203__$1 = (function (){var statearr_38231 = state_38203;
(statearr_38231[(11)] = inst_38083);

(statearr_38231[(12)] = inst_38082);

(statearr_38231[(13)] = inst_38084);

return statearr_38231;
})();
var statearr_38232_38308 = state_38203__$1;
(statearr_38232_38308[(2)] = null);

(statearr_38232_38308[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (13))){
var inst_38043 = (state_38203[(8)]);
var inst_38046 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_38043);
var state_38203__$1 = state_38203;
var statearr_38233_38309 = state_38203__$1;
(statearr_38233_38309[(2)] = inst_38046);

(statearr_38233_38309[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (22))){
var inst_38049 = (state_38203[(7)]);
var inst_38069 = cljs.core.first(flakes);
var inst_38070 = fluree.db.query.fql.s(inst_38069);
var inst_38071 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_38049);
var inst_38072 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_38070,inst_38071);
var state_38203__$1 = state_38203;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38203__$1,(25),inst_38072);
} else {
if((state_val_38204 === (36))){
var inst_38049 = (state_38203[(7)]);
var inst_38126 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_38049);
var state_38203__$1 = state_38203;
if(cljs.core.truth_(inst_38126)){
var statearr_38234_38310 = state_38203__$1;
(statearr_38234_38310[(1)] = (39));

} else {
var statearr_38235_38311 = state_38203__$1;
(statearr_38235_38311[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (41))){
var inst_38167 = (state_38203[(2)]);
var state_38203__$1 = state_38203;
var statearr_38236_38312 = state_38203__$1;
(statearr_38236_38312[(2)] = inst_38167);

(statearr_38236_38312[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (43))){
var inst_38049 = (state_38203[(7)]);
var inst_38141 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_38049);
var state_38203__$1 = state_38203;
var statearr_38237_38313 = state_38203__$1;
(statearr_38237_38313[(2)] = inst_38141);

(statearr_38237_38313[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (29))){
var inst_38092 = (state_38203[(14)]);
var inst_38098 = (state_38203[(18)]);
var inst_38049 = (state_38203[(7)]);
var inst_38082 = (state_38203[(12)]);
var inst_38092__$1 = cljs.core.first(inst_38082);
var inst_38093 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38094 = cljs.core.first(inst_38092__$1);
var inst_38095 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_38094);
var inst_38096 = [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,inst_38095];
var inst_38097 = (new cljs.core.PersistentVector(null,3,(5),inst_38093,inst_38096,null));
var inst_38098__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38049,inst_38097);
var inst_38099 = fluree.db.query.fql.component_follow_QMARK_(inst_38098__$1,inst_38049);
var inst_38100 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_38098__$1);
var state_38203__$1 = (function (){var statearr_38238 = state_38203;
(statearr_38238[(14)] = inst_38092__$1);

(statearr_38238[(18)] = inst_38098__$1);

(statearr_38238[(15)] = inst_38099);

return statearr_38238;
})();
if(cljs.core.truth_(inst_38100)){
var statearr_38239_38314 = state_38203__$1;
(statearr_38239_38314[(1)] = (31));

} else {
var statearr_38240_38315 = state_38203__$1;
(statearr_38240_38315[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (44))){
var inst_38139 = (state_38203[(20)]);
var state_38203__$1 = state_38203;
var statearr_38241_38316 = state_38203__$1;
(statearr_38241_38316[(2)] = inst_38139);

(statearr_38241_38316[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (6))){
var state_38203__$1 = state_38203;
var statearr_38242_38317 = state_38203__$1;
(statearr_38242_38317[(2)] = null);

(statearr_38242_38317[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (28))){
var inst_38083 = (state_38203[(11)]);
var state_38203__$1 = state_38203;
var statearr_38243_38318 = state_38203__$1;
(statearr_38243_38318[(2)] = inst_38083);

(statearr_38243_38318[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (51))){
var inst_38163 = (state_38203[(2)]);
var state_38203__$1 = state_38203;
var statearr_38244_38319 = state_38203__$1;
(statearr_38244_38319[(2)] = inst_38163);

(statearr_38244_38319[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (25))){
var inst_38063 = (state_38203[(10)]);
var inst_38074 = (state_38203[(2)]);
var inst_38075 = fluree.db.util.async.throw_err(inst_38074);
var inst_38076 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_38063,inst_38075], 0));
var state_38203__$1 = state_38203;
var statearr_38245_38320 = state_38203__$1;
(statearr_38245_38320[(2)] = inst_38076);

(statearr_38245_38320[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (34))){
var inst_38102 = (state_38203[(19)]);
var inst_38082 = (state_38203[(12)]);
var inst_38084 = (state_38203[(13)]);
var inst_38105 = (state_38203[(2)]);
var inst_38106 = fluree.db.util.async.throw_err(inst_38105);
var inst_38107 = cljs.core.rest(inst_38082);
var inst_38108 = [inst_38106,inst_38107,inst_38084];
var inst_38109 = (new cljs.core.PersistentVector(null,3,(5),inst_38102,inst_38108,null));
var state_38203__$1 = state_38203;
var statearr_38246_38321 = state_38203__$1;
(statearr_38246_38321[(2)] = inst_38109);

(statearr_38246_38321[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (17))){
var inst_38049 = (state_38203[(7)]);
var inst_38053 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_38049);
var state_38203__$1 = state_38203;
var statearr_38248_38322 = state_38203__$1;
(statearr_38248_38322[(2)] = inst_38053);

(statearr_38248_38322[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (3))){
var inst_38201 = (state_38203[(2)]);
var state_38203__$1 = state_38203;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38203__$1,inst_38201);
} else {
if((state_val_38204 === (12))){
var _ = (function (){var statearr_38249 = state_38203;
(statearr_38249[(4)] = cljs.core.rest((state_38203[(4)])));

return statearr_38249;
})();
var state_38203__$1 = state_38203;
var ex38247 = (state_38203__$1[(2)]);
var statearr_38250_38323 = state_38203__$1;
(statearr_38250_38323[(5)] = ex38247);


var statearr_38251_38324 = state_38203__$1;
(statearr_38251_38324[(1)] = (11));

(statearr_38251_38324[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (2))){
var _ = (function (){var statearr_38252 = state_38203;
(statearr_38252[(4)] = cljs.core.cons((5),(state_38203[(4)])));

return statearr_38252;
})();
var inst_38029 = cljs.core.not_empty(flakes);
var state_38203__$1 = state_38203;
if(cljs.core.truth_(inst_38029)){
var statearr_38253_38325 = state_38203__$1;
(statearr_38253_38325[(1)] = (6));

} else {
var statearr_38254_38326 = state_38203__$1;
(statearr_38254_38326[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (23))){
var inst_38063 = (state_38203[(10)]);
var state_38203__$1 = state_38203;
var statearr_38255_38327 = state_38203__$1;
(statearr_38255_38327[(2)] = inst_38063);

(statearr_38255_38327[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (47))){
var state_38203__$1 = state_38203;
var statearr_38256_38328 = state_38203__$1;
(statearr_38256_38328[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (35))){
var inst_38092 = (state_38203[(14)]);
var inst_38098 = (state_38203[(18)]);
var inst_38083 = (state_38203[(11)]);
var inst_38084 = (state_38203[(13)]);
var inst_38099 = (state_38203[(15)]);
var inst_38115 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_38083,inst_38098,inst_38092,inst_38099,false,inst_38084);
var state_38203__$1 = state_38203;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38203__$1,(38),inst_38115);
} else {
if((state_val_38204 === (19))){
var inst_38043 = (state_38203[(8)]);
var inst_38057 = [cljs.core.cst$kw$_id];
var inst_38058 = [inst_38043];
var inst_38059 = cljs.core.PersistentHashMap.fromArrays(inst_38057,inst_38058);
var state_38203__$1 = state_38203;
var statearr_38258_38329 = state_38203__$1;
(statearr_38258_38329[(2)] = inst_38059);

(statearr_38258_38329[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (11))){
var inst_38031 = (state_38203[(2)]);
var inst_38032 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_38031], 0));
var inst_38033 = (function(){throw inst_38031})();
var state_38203__$1 = (function (){var statearr_38260 = state_38203;
(statearr_38260[(21)] = inst_38032);

return statearr_38260;
})();
var statearr_38261_38330 = state_38203__$1;
(statearr_38261_38330[(2)] = inst_38033);

(statearr_38261_38330[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (9))){
var _ = (function (){var statearr_38262 = state_38203;
(statearr_38262[(4)] = cljs.core.cons((12),(state_38203[(4)])));

return statearr_38262;
})();
var inst_38039 = cljs.core.first(flakes);
var inst_38040 = fluree.db.query.fql.s(inst_38039);
var ___$1 = (function (){var statearr_38263 = state_38203;
(statearr_38263[(4)] = cljs.core.rest((state_38203[(4)])));

return statearr_38263;
})();
var state_38203__$1 = state_38203;
var statearr_38264_38331 = state_38203__$1;
(statearr_38264_38331[(2)] = inst_38040);

(statearr_38264_38331[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (5))){
var _ = (function (){var statearr_38265 = state_38203;
(statearr_38265[(4)] = cljs.core.rest((state_38203[(4)])));

return statearr_38265;
})();
var state_38203__$1 = state_38203;
var ex38259 = (state_38203__$1[(2)]);
var statearr_38266_38332 = state_38203__$1;
(statearr_38266_38332[(5)] = ex38259);


if((ex38259 instanceof Error)){
var statearr_38267_38333 = state_38203__$1;
(statearr_38267_38333[(1)] = (4));

(statearr_38267_38333[(5)] = null);

} else {
throw ex38259;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (14))){
var state_38203__$1 = state_38203;
var statearr_38268_38334 = state_38203__$1;
(statearr_38268_38334[(2)] = base_select_spec);

(statearr_38268_38334[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (45))){
var inst_38144 = (state_38203[(2)]);
var state_38203__$1 = state_38203;
if(cljs.core.truth_(inst_38144)){
var statearr_38269_38335 = state_38203__$1;
(statearr_38269_38335[(1)] = (46));

} else {
var statearr_38270_38336 = state_38203__$1;
(statearr_38270_38336[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (26))){
var inst_38082 = (state_38203[(12)]);
var inst_38086 = cljs.core.empty_QMARK_(inst_38082);
var state_38203__$1 = state_38203;
if(inst_38086){
var statearr_38271_38337 = state_38203__$1;
(statearr_38271_38337[(1)] = (28));

} else {
var statearr_38272_38338 = state_38203__$1;
(statearr_38272_38338[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (16))){
var inst_38050 = (state_38203[(17)]);
var state_38203__$1 = state_38203;
var statearr_38273_38339 = state_38203__$1;
(statearr_38273_38339[(2)] = inst_38050);

(statearr_38273_38339[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (38))){
var inst_38082 = (state_38203[(12)]);
var inst_38117 = (state_38203[(2)]);
var inst_38118 = fluree.db.util.async.throw_err(inst_38117);
var inst_38119 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38118,(0),null);
var inst_38120 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38118,(1),null);
var inst_38121 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38122 = cljs.core.rest(inst_38082);
var inst_38123 = [inst_38119,inst_38122,inst_38120];
var inst_38124 = (new cljs.core.PersistentVector(null,3,(5),inst_38121,inst_38123,null));
var state_38203__$1 = state_38203;
var statearr_38274_38340 = state_38203__$1;
(statearr_38274_38340[(2)] = inst_38124);

(statearr_38274_38340[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (30))){
var inst_38180 = (state_38203[(2)]);
var state_38203__$1 = state_38203;
var statearr_38275_38341 = state_38203__$1;
(statearr_38275_38341[(2)] = inst_38180);

(statearr_38275_38341[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (10))){
var inst_38043 = (state_38203[(2)]);
var inst_38044 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_38203__$1 = (function (){var statearr_38276 = state_38203;
(statearr_38276[(8)] = inst_38043);

return statearr_38276;
})();
if(cljs.core.truth_(inst_38044)){
var statearr_38277_38342 = state_38203__$1;
(statearr_38277_38342[(1)] = (13));

} else {
var statearr_38278_38343 = state_38203__$1;
(statearr_38278_38343[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (18))){
var inst_38055 = (state_38203[(2)]);
var state_38203__$1 = state_38203;
if(cljs.core.truth_(inst_38055)){
var statearr_38279_38344 = state_38203__$1;
(statearr_38279_38344[(1)] = (19));

} else {
var statearr_38280_38345 = state_38203__$1;
(statearr_38280_38345[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (42))){
var inst_38128 = (state_38203[(16)]);
var inst_38082 = (state_38203[(12)]);
var inst_38084 = (state_38203[(13)]);
var inst_38131 = (state_38203[(2)]);
var inst_38132 = fluree.db.util.async.throw_err(inst_38131);
var inst_38133 = cljs.core.first(inst_38132);
var inst_38134 = cljs.core.rest(inst_38082);
var inst_38135 = [inst_38133,inst_38134,inst_38084];
var inst_38136 = (new cljs.core.PersistentVector(null,3,(5),inst_38128,inst_38135,null));
var state_38203__$1 = state_38203;
var statearr_38281_38346 = state_38203__$1;
(statearr_38281_38346[(2)] = inst_38136);

(statearr_38281_38346[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (37))){
var inst_38169 = (state_38203[(2)]);
var state_38203__$1 = state_38203;
var statearr_38282_38347 = state_38203__$1;
(statearr_38282_38347[(2)] = inst_38169);

(statearr_38282_38347[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (8))){
var inst_38198 = (state_38203[(2)]);
var _ = (function (){var statearr_38283 = state_38203;
(statearr_38283[(4)] = cljs.core.rest((state_38203[(4)])));

return statearr_38283;
})();
var state_38203__$1 = state_38203;
var statearr_38284_38348 = state_38203__$1;
(statearr_38284_38348[(2)] = inst_38198);

(statearr_38284_38348[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38204 === (49))){
var inst_38083 = (state_38203[(11)]);
var inst_38082 = (state_38203[(12)]);
var inst_38084 = (state_38203[(13)]);
var inst_38157 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38158 = cljs.core.rest(inst_38082);
var inst_38159 = [inst_38083,inst_38158,inst_38084];
var inst_38160 = (new cljs.core.PersistentVector(null,3,(5),inst_38157,inst_38159,null));
var state_38203__$1 = state_38203;
var statearr_38285_38349 = state_38203__$1;
(statearr_38285_38349[(2)] = inst_38160);

(statearr_38285_38349[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__15091__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__15091__auto____0 = (function (){
var statearr_38286 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38286[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__15091__auto__);

(statearr_38286[(1)] = (1));

return statearr_38286;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__15091__auto____1 = (function (state_38203){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_38203);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e38287){var ex__15094__auto__ = e38287;
var statearr_38288_38350 = state_38203;
(statearr_38288_38350[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_38203[(4)]))){
var statearr_38289_38351 = state_38203;
(statearr_38289_38351[(1)] = cljs.core.first((state_38203[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__38352 = state_38203;
state_38203 = G__38352;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__15091__auto__ = function(state_38203){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__15091__auto____1.call(this,state_38203);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__15091__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__15091__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_38290 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_38290[(6)] = c__15165__auto__);

return statearr_38290;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__38355 = arguments.length;
switch (G__38355) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_38397){
var state_val_38398 = (state_38397[(1)]);
if((state_val_38398 === (7))){
var inst_38363 = (state_38397[(7)]);
var state_38397__$1 = state_38397;
var statearr_38399_38429 = state_38397__$1;
(statearr_38399_38429[(2)] = inst_38363);

(statearr_38399_38429[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38398 === (1))){
var state_38397__$1 = state_38397;
var statearr_38400_38430 = state_38397__$1;
(statearr_38400_38430[(2)] = null);

(statearr_38400_38430[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38398 === (4))){
var inst_38356 = (state_38397[(2)]);
var state_38397__$1 = state_38397;
var statearr_38401_38431 = state_38397__$1;
(statearr_38401_38431[(2)] = inst_38356);

(statearr_38401_38431[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38398 === (15))){
var inst_38391 = (state_38397[(2)]);
var inst_38392 = fluree.db.util.async.throw_err(inst_38391);
var _ = (function (){var statearr_38402 = state_38397;
(statearr_38402[(4)] = cljs.core.rest((state_38397[(4)])));

return statearr_38402;
})();
var state_38397__$1 = state_38397;
var statearr_38403_38432 = state_38397__$1;
(statearr_38403_38432[(2)] = inst_38392);

(statearr_38403_38432[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38398 === (13))){
var inst_38375 = (state_38397[(8)]);
var state_38397__$1 = state_38397;
var statearr_38404_38433 = state_38397__$1;
(statearr_38404_38433[(2)] = inst_38375);

(statearr_38404_38433[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38398 === (6))){
var inst_38363 = (state_38397[(7)]);
var inst_38365 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_38366 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_38363,inst_38365);
var state_38397__$1 = state_38397;
var statearr_38405_38434 = state_38397__$1;
(statearr_38405_38434[(2)] = inst_38366);

(statearr_38405_38434[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38398 === (3))){
var inst_38395 = (state_38397[(2)]);
var state_38397__$1 = state_38397;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38397__$1,inst_38395);
} else {
if((state_val_38398 === (12))){
var inst_38375 = (state_38397[(8)]);
var inst_38377 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_38378 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_38375,inst_38377);
var state_38397__$1 = state_38397;
var statearr_38406_38435 = state_38397__$1;
(statearr_38406_38435[(2)] = inst_38378);

(statearr_38406_38435[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38398 === (2))){
var _ = (function (){var statearr_38407 = state_38397;
(statearr_38407[(4)] = cljs.core.cons((5),(state_38397[(4)])));

return statearr_38407;
})();
var inst_38363 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_38397__$1 = (function (){var statearr_38408 = state_38397;
(statearr_38408[(7)] = inst_38363);

return statearr_38408;
})();
if(cljs.core.truth_(fuel)){
var statearr_38409_38436 = state_38397__$1;
(statearr_38409_38436[(1)] = (6));

} else {
var statearr_38410_38437 = state_38397__$1;
(statearr_38410_38437[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38398 === (11))){
var inst_38375 = (state_38397[(2)]);
var state_38397__$1 = (function (){var statearr_38412 = state_38397;
(statearr_38412[(8)] = inst_38375);

return statearr_38412;
})();
if(cljs.core.truth_(limit)){
var statearr_38413_38438 = state_38397__$1;
(statearr_38413_38438[(1)] = (12));

} else {
var statearr_38414_38439 = state_38397__$1;
(statearr_38414_38439[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38398 === (9))){
var inst_38369 = (state_38397[(9)]);
var inst_38371 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_38372 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_38369,inst_38371);
var state_38397__$1 = state_38397;
var statearr_38415_38440 = state_38397__$1;
(statearr_38415_38440[(2)] = inst_38372);

(statearr_38415_38440[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38398 === (5))){
var _ = (function (){var statearr_38416 = state_38397;
(statearr_38416[(4)] = cljs.core.rest((state_38397[(4)])));

return statearr_38416;
})();
var state_38397__$1 = state_38397;
var ex38411 = (state_38397__$1[(2)]);
var statearr_38417_38441 = state_38397__$1;
(statearr_38417_38441[(5)] = ex38411);


if((ex38411 instanceof Error)){
var statearr_38418_38442 = state_38397__$1;
(statearr_38418_38442[(1)] = (4));

(statearr_38418_38442[(5)] = null);

} else {
throw ex38411;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38398 === (14))){
var inst_38381 = (state_38397[(2)]);
var inst_38382 = (function (){return (function (x){
var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__5043__auto__;
}
});
})();
var inst_38383 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_38382);
var inst_38384 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_38381,inst_38383);
var inst_38385 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_38384,flakes);
var inst_38386 = cljs.core.PersistentVector.EMPTY;
var inst_38387 = (function (){var xf = inst_38384;
var flakes_by_sub = inst_38385;
return (function (p1__38353_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__38353_SHARP_);
});
})();
var inst_38388 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_38387,inst_38385);
var inst_38389 = fluree.db.util.async.merge_into_QMARK_(inst_38386,inst_38388);
var state_38397__$1 = state_38397;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38397__$1,(15),inst_38389);
} else {
if((state_val_38398 === (10))){
var inst_38369 = (state_38397[(9)]);
var state_38397__$1 = state_38397;
var statearr_38419_38443 = state_38397__$1;
(statearr_38419_38443[(2)] = inst_38369);

(statearr_38419_38443[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38398 === (8))){
var inst_38369 = (state_38397[(2)]);
var state_38397__$1 = (function (){var statearr_38420 = state_38397;
(statearr_38420[(9)] = inst_38369);

return statearr_38420;
})();
if(cljs.core.truth_(offset)){
var statearr_38421_38444 = state_38397__$1;
(statearr_38421_38444[(1)] = (9));

} else {
var statearr_38422_38445 = state_38397__$1;
(statearr_38422_38445[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__15091__auto__ = null;
var fluree$db$query$fql$state_machine__15091__auto____0 = (function (){
var statearr_38423 = [null,null,null,null,null,null,null,null,null,null];
(statearr_38423[(0)] = fluree$db$query$fql$state_machine__15091__auto__);

(statearr_38423[(1)] = (1));

return statearr_38423;
});
var fluree$db$query$fql$state_machine__15091__auto____1 = (function (state_38397){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_38397);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e38424){var ex__15094__auto__ = e38424;
var statearr_38425_38446 = state_38397;
(statearr_38425_38446[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_38397[(4)]))){
var statearr_38426_38447 = state_38397;
(statearr_38426_38447[(1)] = cljs.core.first((state_38397[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__38448 = state_38397;
state_38397 = G__38448;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__15091__auto__ = function(state_38397){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__15091__auto____1.call(this,state_38397);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__15091__auto____0;
fluree$db$query$fql$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__15091__auto____1;
return fluree$db$query$fql$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_38427 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_38427[(6)] = c__15165__auto__);

return statearr_38427;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__38450 = arguments.length;
switch (G__38450) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_38536){
var state_val_38537 = (state_38536[(1)]);
if((state_val_38537 === (7))){
var inst_38531 = (state_38536[(2)]);
var _ = (function (){var statearr_38539 = state_38536;
(statearr_38539[(4)] = cljs.core.rest((state_38536[(4)])));

return statearr_38539;
})();
var state_38536__$1 = state_38536;
var statearr_38540_38592 = state_38536__$1;
(statearr_38540_38592[(2)] = inst_38531);

(statearr_38540_38592[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38537 === (20))){
var inst_38478 = (state_38536[(7)]);
var inst_38470 = (state_38536[(8)]);
var inst_38471 = (state_38536[(9)]);
var inst_38499 = (inst_38470 + (1));
var tmp38538 = inst_38471;
var inst_38469 = inst_38478;
var inst_38470__$1 = inst_38499;
var inst_38471__$1 = tmp38538;
var state_38536__$1 = (function (){var statearr_38541 = state_38536;
(statearr_38541[(10)] = inst_38469);

(statearr_38541[(8)] = inst_38470__$1);

(statearr_38541[(9)] = inst_38471__$1);

return statearr_38541;
})();
var statearr_38542_38593 = state_38536__$1;
(statearr_38542_38593[(2)] = null);

(statearr_38542_38593[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38537 === (27))){
var inst_38509 = (state_38536[(11)]);
var inst_38511 = cljs.core.count(inst_38509);
var inst_38512 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_38511);
var state_38536__$1 = state_38536;
var statearr_38543_38594 = state_38536__$1;
(statearr_38543_38594[(2)] = inst_38512);

(statearr_38543_38594[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38537 === (1))){
var state_38536__$1 = state_38536;
var statearr_38544_38595 = state_38536__$1;
(statearr_38544_38595[(2)] = null);

(statearr_38544_38595[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38537 === (24))){
var state_38536__$1 = state_38536;
var statearr_38545_38596 = state_38536__$1;
(statearr_38545_38596[(2)] = null);

(statearr_38545_38596[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38537 === (4))){
var inst_38451 = (state_38536[(2)]);
var state_38536__$1 = state_38536;
var statearr_38546_38597 = state_38536__$1;
(statearr_38546_38597[(2)] = inst_38451);

(statearr_38546_38597[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38537 === (15))){
var inst_38492 = (state_38536[(12)]);
var inst_38492__$1 = offset;
var state_38536__$1 = (function (){var statearr_38547 = state_38536;
(statearr_38547[(12)] = inst_38492__$1);

return statearr_38547;
})();
if(cljs.core.truth_(inst_38492__$1)){
var statearr_38548_38598 = state_38536__$1;
(statearr_38548_38598[(1)] = (17));

} else {
var statearr_38549_38599 = state_38536__$1;
(statearr_38549_38599[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38537 === (21))){
var state_38536__$1 = state_38536;
var statearr_38550_38600 = state_38536__$1;
(statearr_38550_38600[(1)] = (23));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38537 === (13))){
var inst_38487 = (state_38536[(2)]);
var state_38536__$1 = state_38536;
var statearr_38552_38601 = state_38536__$1;
(statearr_38552_38601[(2)] = inst_38487);

(statearr_38552_38601[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38537 === (22))){
var inst_38527 = (state_38536[(2)]);
var state_38536__$1 = state_38536;
var statearr_38553_38602 = state_38536__$1;
(statearr_38553_38602[(2)] = inst_38527);

(statearr_38553_38602[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38537 === (29))){
var inst_38509 = (state_38536[(11)]);
var inst_38470 = (state_38536[(8)]);
var inst_38515 = (state_38536[(2)]);
var inst_38516 = (inst_38470 + (1));
var inst_38517 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,inst_38509);
var state_38536__$1 = (function (){var statearr_38554 = state_38536;
(statearr_38554[(13)] = inst_38515);

(statearr_38554[(14)] = inst_38516);

return statearr_38554;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38536__$1,(30),inst_38517);
} else {
if((state_val_38537 === (6))){
var inst_38469 = (state_38536[(10)]);
var inst_38477 = (state_38536[(15)]);
var inst_38479 = (state_38536[(16)]);
var inst_38476 = cljs.core.seq(inst_38469);
var inst_38477__$1 = cljs.core.first(inst_38476);
var inst_38478 = cljs.core.next(inst_38476);
var inst_38479__$1 = (inst_38477__$1 == null);
var state_38536__$1 = (function (){var statearr_38555 = state_38536;
(statearr_38555[(15)] = inst_38477__$1);

(statearr_38555[(7)] = inst_38478);

(statearr_38555[(16)] = inst_38479__$1);

return statearr_38555;
})();
if(cljs.core.truth_(inst_38479__$1)){
var statearr_38556_38603 = state_38536__$1;
(statearr_38556_38603[(1)] = (8));

} else {
var statearr_38557_38604 = state_38536__$1;
(statearr_38557_38604[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38537 === (28))){
var state_38536__$1 = state_38536;
var statearr_38558_38605 = state_38536__$1;
(statearr_38558_38605[(2)] = null);

(statearr_38558_38605[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38537 === (25))){
var inst_38525 = (state_38536[(2)]);
var state_38536__$1 = state_38536;
var statearr_38559_38606 = state_38536__$1;
(statearr_38559_38606[(2)] = inst_38525);

(statearr_38559_38606[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38537 === (17))){
var inst_38470 = (state_38536[(8)]);
var inst_38494 = (inst_38470 < offset);
var state_38536__$1 = state_38536;
var statearr_38560_38607 = state_38536__$1;
(statearr_38560_38607[(2)] = inst_38494);

(statearr_38560_38607[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38537 === (3))){
var inst_38534 = (state_38536[(2)]);
var state_38536__$1 = state_38536;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38536__$1,inst_38534);
} else {
if((state_val_38537 === (12))){
var inst_38482 = (state_38536[(17)]);
var state_38536__$1 = state_38536;
var statearr_38561_38608 = state_38536__$1;
(statearr_38561_38608[(2)] = inst_38482);

(statearr_38561_38608[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38537 === (2))){
var _ = (function (){var statearr_38562 = state_38536;
(statearr_38562[(4)] = cljs.core.cons((5),(state_38536[(4)])));

return statearr_38562;
})();
var inst_38464 = subjects;
var inst_38465 = cljs.core.seq(inst_38464);
var inst_38466 = cljs.core.first(inst_38465);
var inst_38467 = cljs.core.next(inst_38465);
var inst_38468 = cljs.core.PersistentVector.EMPTY;
var inst_38469 = inst_38464;
var inst_38470 = (0);
var inst_38471 = inst_38468;
var state_38536__$1 = (function (){var statearr_38563 = state_38536;
(statearr_38563[(10)] = inst_38469);

(statearr_38563[(18)] = inst_38466);

(statearr_38563[(19)] = inst_38467);

(statearr_38563[(8)] = inst_38470);

(statearr_38563[(9)] = inst_38471);

return statearr_38563;
})();
var statearr_38564_38609 = state_38536__$1;
(statearr_38564_38609[(2)] = null);

(statearr_38564_38609[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38537 === (23))){
var inst_38477 = (state_38536[(15)]);
var inst_38503 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38504 = [inst_38477];
var inst_38505 = (new cljs.core.PersistentVector(null,1,(5),inst_38503,inst_38504,null));
var inst_38506 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_38505);
var state_38536__$1 = state_38536;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38536__$1,(26),inst_38506);
} else {
if((state_val_38537 === (19))){
var inst_38497 = (state_38536[(2)]);
var state_38536__$1 = state_38536;
if(cljs.core.truth_(inst_38497)){
var statearr_38565_38610 = state_38536__$1;
(statearr_38565_38610[(1)] = (20));

} else {
var statearr_38566_38611 = state_38536__$1;
(statearr_38566_38611[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38537 === (11))){
var inst_38470 = (state_38536[(8)]);
var inst_38484 = (inst_38470 > limit);
var state_38536__$1 = state_38536;
var statearr_38568_38612 = state_38536__$1;
(statearr_38568_38612[(2)] = inst_38484);

(statearr_38568_38612[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38537 === (9))){
var inst_38482 = (state_38536[(17)]);
var inst_38482__$1 = limit;
var state_38536__$1 = (function (){var statearr_38569 = state_38536;
(statearr_38569[(17)] = inst_38482__$1);

return statearr_38569;
})();
if(cljs.core.truth_(inst_38482__$1)){
var statearr_38570_38613 = state_38536__$1;
(statearr_38570_38613[(1)] = (11));

} else {
var statearr_38571_38614 = state_38536__$1;
(statearr_38571_38614[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38537 === (5))){
var _ = (function (){var statearr_38572 = state_38536;
(statearr_38572[(4)] = cljs.core.rest((state_38536[(4)])));

return statearr_38572;
})();
var state_38536__$1 = state_38536;
var ex38567 = (state_38536__$1[(2)]);
var statearr_38573_38615 = state_38536__$1;
(statearr_38573_38615[(5)] = ex38567);


if((ex38567 instanceof Error)){
var statearr_38574_38616 = state_38536__$1;
(statearr_38574_38616[(1)] = (4));

(statearr_38574_38616[(5)] = null);

} else {
throw ex38567;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38537 === (14))){
var inst_38471 = (state_38536[(9)]);
var state_38536__$1 = state_38536;
var statearr_38575_38617 = state_38536__$1;
(statearr_38575_38617[(2)] = inst_38471);

(statearr_38575_38617[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38537 === (26))){
var inst_38508 = (state_38536[(2)]);
var inst_38509 = fluree.db.util.async.throw_err(inst_38508);
var state_38536__$1 = (function (){var statearr_38576 = state_38536;
(statearr_38576[(11)] = inst_38509);

return statearr_38576;
})();
if(cljs.core.truth_(fuel)){
var statearr_38577_38618 = state_38536__$1;
(statearr_38577_38618[(1)] = (27));

} else {
var statearr_38578_38619 = state_38536__$1;
(statearr_38578_38619[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38537 === (16))){
var inst_38529 = (state_38536[(2)]);
var state_38536__$1 = state_38536;
var statearr_38579_38620 = state_38536__$1;
(statearr_38579_38620[(2)] = inst_38529);

(statearr_38579_38620[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38537 === (30))){
var inst_38478 = (state_38536[(7)]);
var inst_38516 = (state_38536[(14)]);
var inst_38471 = (state_38536[(9)]);
var inst_38519 = (state_38536[(2)]);
var inst_38520 = fluree.db.util.async.throw_err(inst_38519);
var inst_38521 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38471,inst_38520);
var inst_38469 = inst_38478;
var inst_38470 = inst_38516;
var inst_38471__$1 = inst_38521;
var state_38536__$1 = (function (){var statearr_38580 = state_38536;
(statearr_38580[(10)] = inst_38469);

(statearr_38580[(8)] = inst_38470);

(statearr_38580[(9)] = inst_38471__$1);

return statearr_38580;
})();
var statearr_38581_38621 = state_38536__$1;
(statearr_38581_38621[(2)] = null);

(statearr_38581_38621[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38537 === (10))){
var inst_38489 = (state_38536[(2)]);
var state_38536__$1 = state_38536;
if(cljs.core.truth_(inst_38489)){
var statearr_38582_38622 = state_38536__$1;
(statearr_38582_38622[(1)] = (14));

} else {
var statearr_38583_38623 = state_38536__$1;
(statearr_38583_38623[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38537 === (18))){
var inst_38492 = (state_38536[(12)]);
var state_38536__$1 = state_38536;
var statearr_38584_38624 = state_38536__$1;
(statearr_38584_38624[(2)] = inst_38492);

(statearr_38584_38624[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38537 === (8))){
var inst_38479 = (state_38536[(16)]);
var state_38536__$1 = state_38536;
var statearr_38585_38625 = state_38536__$1;
(statearr_38585_38625[(2)] = inst_38479);

(statearr_38585_38625[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__15091__auto__ = null;
var fluree$db$query$fql$state_machine__15091__auto____0 = (function (){
var statearr_38586 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38586[(0)] = fluree$db$query$fql$state_machine__15091__auto__);

(statearr_38586[(1)] = (1));

return statearr_38586;
});
var fluree$db$query$fql$state_machine__15091__auto____1 = (function (state_38536){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_38536);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e38587){var ex__15094__auto__ = e38587;
var statearr_38588_38626 = state_38536;
(statearr_38588_38626[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_38536[(4)]))){
var statearr_38589_38627 = state_38536;
(statearr_38589_38627[(1)] = cljs.core.first((state_38536[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__38628 = state_38536;
state_38536 = G__38628;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__15091__auto__ = function(state_38536){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__15091__auto____1.call(this,state_38536);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__15091__auto____0;
fluree$db$query$fql$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__15091__auto____1;
return fluree$db$query$fql$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_38590 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_38590[(6)] = c__15165__auto__);

return statearr_38590;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__5045__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__38630 = arguments.length;
switch (G__38630) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4(db,where_clause,null,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4 = (function (db,where_clause,default_collection,p__38631){
var map__38632 = p__38631;
var map__38632__$1 = cljs.core.__destructure_map(map__38632);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38632__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38632__$1,cljs.core.cst$kw$offset);
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_38896){
var state_val_38897 = (state_38896[(1)]);
if((state_val_38897 === (65))){
var inst_38859 = (state_38896[(7)]);
var inst_38859__$1 = (state_38896[(2)]);
var state_38896__$1 = (function (){var statearr_38898 = state_38896;
(statearr_38898[(7)] = inst_38859__$1);

return statearr_38898;
})();
if(cljs.core.truth_(inst_38859__$1)){
var statearr_38899_39017 = state_38896__$1;
(statearr_38899_39017[(1)] = (66));

} else {
var statearr_38900_39018 = state_38896__$1;
(statearr_38900_39018[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (70))){
var inst_38862 = (state_38896[(8)]);
var state_38896__$1 = state_38896;
var statearr_38901_39019 = state_38896__$1;
(statearr_38901_39019[(2)] = inst_38862);

(statearr_38901_39019[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (62))){
var inst_38850 = (state_38896[(2)]);
var state_38896__$1 = state_38896;
var statearr_38902_39020 = state_38896__$1;
(statearr_38902_39020[(2)] = inst_38850);

(statearr_38902_39020[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (74))){
var inst_38869 = (state_38896[(2)]);
var state_38896__$1 = state_38896;
var statearr_38903_39021 = state_38896__$1;
(statearr_38903_39021[(2)] = inst_38869);

(statearr_38903_39021[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (7))){
var inst_38645 = (state_38896[(9)]);
var state_38896__$1 = state_38896;
var statearr_38904_39022 = state_38896__$1;
(statearr_38904_39022[(2)] = inst_38645);

(statearr_38904_39022[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (59))){
var inst_38674 = (state_38896[(10)]);
var inst_38842 = cljs.core.empty_QMARK_(inst_38674);
var state_38896__$1 = state_38896;
if(inst_38842){
var statearr_38905_39023 = state_38896__$1;
(statearr_38905_39023[(1)] = (60));

} else {
var statearr_38906_39024 = state_38896__$1;
(statearr_38906_39024[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (20))){
var state_38896__$1 = state_38896;
if(cljs.core.truth_(offset)){
var statearr_38907_39025 = state_38896__$1;
(statearr_38907_39025[(1)] = (23));

} else {
var statearr_38908_39026 = state_38896__$1;
(statearr_38908_39026[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (72))){
var inst_38659 = (state_38896[(11)]);
var inst_38839 = (state_38896[(12)]);
var inst_38865 = cljs.core.count(inst_38839);
var inst_38866 = (inst_38865 > inst_38659);
var state_38896__$1 = state_38896;
var statearr_38909_39027 = state_38896__$1;
(statearr_38909_39027[(2)] = inst_38866);

(statearr_38909_39027[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (58))){
var inst_38674 = (state_38896[(10)]);
var inst_38839 = (state_38896[(12)]);
var inst_38840 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38674,inst_38839);
var state_38896__$1 = state_38896;
var statearr_38910_39028 = state_38896__$1;
(statearr_38910_39028[(2)] = inst_38840);

(statearr_38910_39028[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (60))){
var inst_38674 = (state_38896[(10)]);
var inst_38839 = (state_38896[(12)]);
var inst_38844 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38674,inst_38839);
var state_38896__$1 = state_38896;
var statearr_38911_39029 = state_38896__$1;
(statearr_38911_39029[(2)] = inst_38844);

(statearr_38911_39029[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (27))){
var inst_38689 = (state_38896[(13)]);
var state_38896__$1 = state_38896;
var statearr_38912_39030 = state_38896__$1;
(statearr_38912_39030[(2)] = inst_38689);

(statearr_38912_39030[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (1))){
var state_38896__$1 = state_38896;
var statearr_38913_39031 = state_38896__$1;
(statearr_38913_39031[(2)] = null);

(statearr_38913_39031[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (69))){
var inst_38659 = (state_38896[(11)]);
var state_38896__$1 = state_38896;
if(cljs.core.truth_(inst_38659)){
var statearr_38914_39032 = state_38896__$1;
(statearr_38914_39032[(1)] = (72));

} else {
var statearr_38915_39033 = state_38896__$1;
(statearr_38915_39033[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (24))){
var inst_38674 = (state_38896[(10)]);
var state_38896__$1 = state_38896;
var statearr_38916_39034 = state_38896__$1;
(statearr_38916_39034[(2)] = inst_38674);

(statearr_38916_39034[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (55))){
var inst_38828 = (state_38896[(2)]);
var state_38896__$1 = state_38896;
var statearr_38917_39035 = state_38896__$1;
(statearr_38917_39035[(2)] = inst_38828);

(statearr_38917_39035[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (39))){
var inst_38836 = (state_38896[(2)]);
var state_38896__$1 = state_38896;
var statearr_38918_39036 = state_38896__$1;
(statearr_38918_39036[(2)] = inst_38836);

(statearr_38918_39036[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (46))){
var inst_38700 = (state_38896[(14)]);
var inst_38718 = (state_38896[(15)]);
var inst_38794 = (inst_38718.cljs$core$IFn$_invoke$arity$2 ? inst_38718.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_38700) : inst_38718.call(null,cljs.core._LT_,inst_38700));
var state_38896__$1 = state_38896;
if(cljs.core.truth_(inst_38794)){
var statearr_38919_39037 = state_38896__$1;
(statearr_38919_39037[(1)] = (49));

} else {
var statearr_38920_39038 = state_38896__$1;
(statearr_38920_39038[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (4))){
var inst_38633 = (state_38896[(2)]);
var state_38896__$1 = state_38896;
var statearr_38921_39039 = state_38896__$1;
(statearr_38921_39039[(2)] = inst_38633);

(statearr_38921_39039[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (77))){
var inst_38884 = (state_38896[(2)]);
var state_38896__$1 = state_38896;
var statearr_38922_39040 = state_38896__$1;
(statearr_38922_39040[(2)] = inst_38884);

(statearr_38922_39040[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (54))){
var inst_38826 = cljs.core.PersistentVector.EMPTY;
var state_38896__$1 = state_38896;
var statearr_38923_39041 = state_38896__$1;
(statearr_38923_39041[(2)] = inst_38826);

(statearr_38923_39041[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (15))){
var inst_38644 = (state_38896[(16)]);
var inst_38669 = cljs.core.seq(inst_38644);
var inst_38670 = cljs.core.first(inst_38669);
var inst_38671 = cljs.core.next(inst_38669);
var inst_38672 = cljs.core.PersistentHashSet.EMPTY;
var inst_38673 = inst_38644;
var inst_38674 = inst_38672;
var state_38896__$1 = (function (){var statearr_38924 = state_38896;
(statearr_38924[(10)] = inst_38674);

(statearr_38924[(17)] = inst_38671);

(statearr_38924[(18)] = inst_38673);

(statearr_38924[(19)] = inst_38670);

return statearr_38924;
})();
var statearr_38925_39042 = state_38896__$1;
(statearr_38925_39042[(2)] = null);

(statearr_38925_39042[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (48))){
var inst_38791 = (state_38896[(2)]);
var inst_38792 = fluree.db.util.async.throw_err(inst_38791);
var state_38896__$1 = state_38896;
var statearr_38926_39043 = state_38896__$1;
(statearr_38926_39043[(2)] = inst_38792);

(statearr_38926_39043[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (50))){
var inst_38700 = (state_38896[(14)]);
var inst_38718 = (state_38896[(15)]);
var inst_38810 = (inst_38718.cljs$core$IFn$_invoke$arity$2 ? inst_38718.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_38700) : inst_38718.call(null,cljs.core._LT__EQ_,inst_38700));
var state_38896__$1 = state_38896;
if(cljs.core.truth_(inst_38810)){
var statearr_38927_39044 = state_38896__$1;
(statearr_38927_39044[(1)] = (53));

} else {
var statearr_38928_39045 = state_38896__$1;
(statearr_38928_39045[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (75))){
var state_38896__$1 = state_38896;
if(cljs.core.truth_(offset)){
var statearr_38929_39046 = state_38896__$1;
(statearr_38929_39046[(1)] = (78));

} else {
var statearr_38930_39047 = state_38896__$1;
(statearr_38930_39047[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (21))){
var inst_38699 = (state_38896[(20)]);
var inst_38680 = (state_38896[(21)]);
var inst_38699__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38680,(0),null);
var inst_38700 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38680,(1),null);
var inst_38701 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38680,(2),null);
var inst_38702 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_38699__$1);
var inst_38703 = cljs.core.not(inst_38702);
var state_38896__$1 = (function (){var statearr_38931 = state_38896;
(statearr_38931[(14)] = inst_38700);

(statearr_38931[(20)] = inst_38699__$1);

(statearr_38931[(22)] = inst_38701);

return statearr_38931;
})();
if(inst_38703){
var statearr_38932_39048 = state_38896__$1;
(statearr_38932_39048[(1)] = (29));

} else {
var statearr_38933_39049 = state_38896__$1;
(statearr_38933_39049[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (31))){
var inst_38700 = (state_38896[(14)]);
var inst_38718 = (state_38896[(15)]);
var inst_38714 = (state_38896[(2)]);
var inst_38718__$1 = cljs.core.identical_QMARK_;
var inst_38719 = (inst_38718__$1.cljs$core$IFn$_invoke$arity$2 ? inst_38718__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_38700) : inst_38718__$1.call(null,cljs.core.not_EQ_,inst_38700));
var state_38896__$1 = (function (){var statearr_38934 = state_38896;
(statearr_38934[(23)] = inst_38714);

(statearr_38934[(15)] = inst_38718__$1);

return statearr_38934;
})();
if(cljs.core.truth_(inst_38719)){
var statearr_38935_39050 = state_38896__$1;
(statearr_38935_39050[(1)] = (32));

} else {
var statearr_38936_39051 = state_38896__$1;
(statearr_38936_39051[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (32))){
var inst_38699 = (state_38896[(20)]);
var inst_38659 = (state_38896[(11)]);
var inst_38701 = (state_38896[(22)]);
var inst_38721 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38722 = [inst_38699,inst_38701];
var inst_38723 = (new cljs.core.PersistentVector(null,2,(5),inst_38721,inst_38722,null));
var inst_38724 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38725 = [inst_38699];
var inst_38726 = (new cljs.core.PersistentVector(null,1,(5),inst_38724,inst_38725,null));
var inst_38727 = [cljs.core.cst$kw$limit];
var inst_38728 = [inst_38659];
var inst_38729 = cljs.core.PersistentHashMap.fromArrays(inst_38727,inst_38728);
var inst_38730 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_38723,cljs.core._LT__EQ_,inst_38726,inst_38729);
var state_38896__$1 = state_38896;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38896__$1,(35),inst_38730);
} else {
if((state_val_38897 === (40))){
var inst_38759 = (state_38896[(2)]);
var inst_38760 = fluree.db.util.async.throw_err(inst_38759);
var state_38896__$1 = state_38896;
var statearr_38937_39052 = state_38896__$1;
(statearr_38937_39052[(2)] = inst_38760);

(statearr_38937_39052[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (56))){
var inst_38823 = (state_38896[(2)]);
var inst_38824 = fluree.db.util.async.throw_err(inst_38823);
var state_38896__$1 = state_38896;
var statearr_38938_39053 = state_38896__$1;
(statearr_38938_39053[(2)] = inst_38824);

(statearr_38938_39053[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (33))){
var inst_38700 = (state_38896[(14)]);
var inst_38718 = (state_38896[(15)]);
var inst_38749 = (inst_38718.cljs$core$IFn$_invoke$arity$2 ? inst_38718.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_38700) : inst_38718.call(null,cljs.core._EQ_,inst_38700));
var state_38896__$1 = state_38896;
if(cljs.core.truth_(inst_38749)){
var statearr_38939_39054 = state_38896__$1;
(statearr_38939_39054[(1)] = (37));

} else {
var statearr_38940_39055 = state_38896__$1;
(statearr_38940_39055[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (13))){
var state_38896__$1 = state_38896;
var statearr_38941_39056 = state_38896__$1;
(statearr_38941_39056[(2)] = limit);

(statearr_38941_39056[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (22))){
var inst_38886 = (state_38896[(2)]);
var state_38896__$1 = state_38896;
var statearr_38942_39057 = state_38896__$1;
(statearr_38942_39057[(2)] = inst_38886);

(statearr_38942_39057[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (36))){
var inst_38733 = (state_38896[(24)]);
var inst_38745 = (state_38896[(2)]);
var inst_38746 = fluree.db.util.async.throw_err(inst_38745);
var inst_38747 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_38733,inst_38746);
var state_38896__$1 = state_38896;
var statearr_38943_39058 = state_38896__$1;
(statearr_38943_39058[(2)] = inst_38747);

(statearr_38943_39058[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (41))){
var inst_38699 = (state_38896[(20)]);
var inst_38659 = (state_38896[(11)]);
var inst_38701 = (state_38896[(22)]);
var inst_38764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38765 = [inst_38699,inst_38701];
var inst_38766 = (new cljs.core.PersistentVector(null,2,(5),inst_38764,inst_38765,null));
var inst_38767 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38768 = [inst_38699];
var inst_38769 = (new cljs.core.PersistentVector(null,1,(5),inst_38767,inst_38768,null));
var inst_38770 = [cljs.core.cst$kw$limit];
var inst_38771 = [inst_38659];
var inst_38772 = cljs.core.PersistentHashMap.fromArrays(inst_38770,inst_38771);
var inst_38773 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_38766,cljs.core._LT__EQ_,inst_38769,inst_38772);
var state_38896__$1 = state_38896;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38896__$1,(44),inst_38773);
} else {
if((state_val_38897 === (43))){
var inst_38834 = (state_38896[(2)]);
var state_38896__$1 = state_38896;
var statearr_38944_39059 = state_38896__$1;
(statearr_38944_39059[(2)] = inst_38834);

(statearr_38944_39059[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (61))){
var inst_38674 = (state_38896[(10)]);
var inst_38839 = (state_38896[(12)]);
var inst_38846 = cljs.core.PersistentHashSet.EMPTY;
var inst_38847 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38846,inst_38839);
var inst_38848 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_38674,inst_38847);
var state_38896__$1 = state_38896;
var statearr_38945_39060 = state_38896__$1;
(statearr_38945_39060[(2)] = inst_38848);

(statearr_38945_39060[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (29))){
var inst_38699 = (state_38896[(20)]);
var inst_38705 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_38699);
var inst_38706 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38705)].join('');
var inst_38707 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_38708 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_38709 = cljs.core.PersistentHashMap.fromArrays(inst_38707,inst_38708);
var inst_38710 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38706,inst_38709);
var inst_38711 = (function(){throw inst_38710})();
var state_38896__$1 = state_38896;
var statearr_38946_39061 = state_38896__$1;
(statearr_38946_39061[(2)] = inst_38711);

(statearr_38946_39061[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (44))){
var inst_38775 = (state_38896[(2)]);
var inst_38776 = fluree.db.util.async.throw_err(inst_38775);
var state_38896__$1 = state_38896;
var statearr_38947_39062 = state_38896__$1;
(statearr_38947_39062[(2)] = inst_38776);

(statearr_38947_39062[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (6))){
var inst_38643 = (state_38896[(25)]);
var inst_38647 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$and,inst_38643);
var state_38896__$1 = state_38896;
var statearr_38948_39063 = state_38896__$1;
(statearr_38948_39063[(2)] = inst_38647);

(statearr_38948_39063[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (28))){
var inst_38694 = (state_38896[(2)]);
var state_38896__$1 = state_38896;
var statearr_38949_39064 = state_38896__$1;
(statearr_38949_39064[(2)] = inst_38694);

(statearr_38949_39064[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (64))){
var inst_38854 = (state_38896[(26)]);
var state_38896__$1 = state_38896;
var statearr_38950_39065 = state_38896__$1;
(statearr_38950_39065[(2)] = inst_38854);

(statearr_38950_39065[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (51))){
var inst_38830 = (state_38896[(2)]);
var state_38896__$1 = state_38896;
var statearr_38951_39066 = state_38896__$1;
(statearr_38951_39066[(2)] = inst_38830);

(statearr_38951_39066[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (25))){
var inst_38689 = (state_38896[(2)]);
var state_38896__$1 = (function (){var statearr_38952 = state_38896;
(statearr_38952[(13)] = inst_38689);

return statearr_38952;
})();
if(cljs.core.truth_(limit)){
var statearr_38953_39067 = state_38896__$1;
(statearr_38953_39067[(1)] = (26));

} else {
var statearr_38954_39068 = state_38896__$1;
(statearr_38954_39068[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (34))){
var inst_38643 = (state_38896[(25)]);
var inst_38838 = (state_38896[(2)]);
var inst_38839 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_38838);
var state_38896__$1 = (function (){var statearr_38955 = state_38896;
(statearr_38955[(12)] = inst_38839);

return statearr_38955;
})();
var G__38956_39069 = inst_38643;
var G__38956_39070__$1 = (((G__38956_39069 instanceof cljs.core.Keyword))?G__38956_39069.fqn:null);
switch (G__38956_39070__$1) {
case "or":
var statearr_38957_39072 = state_38896__$1;
(statearr_38957_39072[(1)] = (58));


break;
case "and":
var statearr_38958_39073 = state_38896__$1;
(statearr_38958_39073[(1)] = (59));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__38956_39070__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (17))){
var inst_38891 = (state_38896[(2)]);
var _ = (function (){var statearr_38959 = state_38896;
(statearr_38959[(4)] = cljs.core.rest((state_38896[(4)])));

return statearr_38959;
})();
var state_38896__$1 = state_38896;
var statearr_38960_39074 = state_38896__$1;
(statearr_38960_39074[(2)] = inst_38891);

(statearr_38960_39074[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (3))){
var inst_38894 = (state_38896[(2)]);
var state_38896__$1 = state_38896;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38896__$1,inst_38894);
} else {
if((state_val_38897 === (12))){
var inst_38653 = (offset + limit);
var state_38896__$1 = state_38896;
var statearr_38961_39075 = state_38896__$1;
(statearr_38961_39075[(2)] = inst_38653);

(statearr_38961_39075[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (2))){
var inst_38645 = (state_38896[(9)]);
var _ = (function (){var statearr_38962 = state_38896;
(statearr_38962[(4)] = cljs.core.cons((5),(state_38896[(4)])));

return statearr_38962;
})();
var inst_38642 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_38643 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38642,(0),null);
var inst_38644 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38642,(1),null);
var inst_38645__$1 = limit;
var state_38896__$1 = (function (){var statearr_38963 = state_38896;
(statearr_38963[(16)] = inst_38644);

(statearr_38963[(9)] = inst_38645__$1);

(statearr_38963[(25)] = inst_38643);

return statearr_38963;
})();
if(cljs.core.truth_(inst_38645__$1)){
var statearr_38964_39076 = state_38896__$1;
(statearr_38964_39076[(1)] = (6));

} else {
var statearr_38965_39077 = state_38896__$1;
(statearr_38965_39077[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (66))){
var inst_38859 = (state_38896[(7)]);
var state_38896__$1 = state_38896;
var statearr_38966_39078 = state_38896__$1;
(statearr_38966_39078[(2)] = inst_38859);

(statearr_38966_39078[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (23))){
var inst_38674 = (state_38896[(10)]);
var inst_38686 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,inst_38674);
var state_38896__$1 = state_38896;
var statearr_38967_39079 = state_38896__$1;
(statearr_38967_39079[(2)] = inst_38686);

(statearr_38967_39079[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (47))){
var inst_38832 = (state_38896[(2)]);
var state_38896__$1 = state_38896;
var statearr_38968_39080 = state_38896__$1;
(statearr_38968_39080[(2)] = inst_38832);

(statearr_38968_39080[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (35))){
var inst_38699 = (state_38896[(20)]);
var inst_38659 = (state_38896[(11)]);
var inst_38701 = (state_38896[(22)]);
var inst_38732 = (state_38896[(2)]);
var inst_38733 = fluree.db.util.async.throw_err(inst_38732);
var inst_38734 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38735 = [inst_38699];
var inst_38736 = (new cljs.core.PersistentVector(null,1,(5),inst_38734,inst_38735,null));
var inst_38737 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38738 = [inst_38699,inst_38701];
var inst_38739 = (new cljs.core.PersistentVector(null,2,(5),inst_38737,inst_38738,null));
var inst_38740 = [cljs.core.cst$kw$limit];
var inst_38741 = [inst_38659];
var inst_38742 = cljs.core.PersistentHashMap.fromArrays(inst_38740,inst_38741);
var inst_38743 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_38736,cljs.core._LT_,inst_38739,inst_38742);
var state_38896__$1 = (function (){var statearr_38969 = state_38896;
(statearr_38969[(24)] = inst_38733);

return statearr_38969;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38896__$1,(36),inst_38743);
} else {
if((state_val_38897 === (76))){
var inst_38853 = (state_38896[(27)]);
var inst_38681 = (state_38896[(28)]);
var inst_38673 = inst_38681;
var inst_38674 = inst_38853;
var state_38896__$1 = (function (){var statearr_38970 = state_38896;
(statearr_38970[(10)] = inst_38674);

(statearr_38970[(18)] = inst_38673);

return statearr_38970;
})();
var statearr_38971_39081 = state_38896__$1;
(statearr_38971_39081[(2)] = null);

(statearr_38971_39081[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (19))){
var inst_38888 = (state_38896[(2)]);
var state_38896__$1 = state_38896;
var statearr_38972_39082 = state_38896__$1;
(statearr_38972_39082[(2)] = inst_38888);

(statearr_38972_39082[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (57))){
var inst_38854 = (state_38896[(26)]);
var inst_38643 = (state_38896[(25)]);
var inst_38853 = (state_38896[(2)]);
var inst_38854__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$and,inst_38643);
var state_38896__$1 = (function (){var statearr_38973 = state_38896;
(statearr_38973[(26)] = inst_38854__$1);

(statearr_38973[(27)] = inst_38853);

return statearr_38973;
})();
if(inst_38854__$1){
var statearr_38974_39083 = state_38896__$1;
(statearr_38974_39083[(1)] = (63));

} else {
var statearr_38975_39084 = state_38896__$1;
(statearr_38975_39084[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (68))){
var inst_38874 = (state_38896[(2)]);
var state_38896__$1 = state_38896;
if(cljs.core.truth_(inst_38874)){
var statearr_38976_39085 = state_38896__$1;
(statearr_38976_39085[(1)] = (75));

} else {
var statearr_38977_39086 = state_38896__$1;
(statearr_38977_39086[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (11))){
var inst_38644 = (state_38896[(16)]);
var inst_38659 = (state_38896[(2)]);
var inst_38660 = cljs.core.not_empty(inst_38644);
var state_38896__$1 = (function (){var statearr_38979 = state_38896;
(statearr_38979[(11)] = inst_38659);

return statearr_38979;
})();
if(cljs.core.truth_(inst_38660)){
var statearr_38980_39087 = state_38896__$1;
(statearr_38980_39087[(1)] = (15));

} else {
var statearr_38981_39088 = state_38896__$1;
(statearr_38981_39088[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (9))){
var state_38896__$1 = state_38896;
if(cljs.core.truth_(offset)){
var statearr_38982_39089 = state_38896__$1;
(statearr_38982_39089[(1)] = (12));

} else {
var statearr_38983_39090 = state_38896__$1;
(statearr_38983_39090[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (5))){
var _ = (function (){var statearr_38984 = state_38896;
(statearr_38984[(4)] = cljs.core.rest((state_38896[(4)])));

return statearr_38984;
})();
var state_38896__$1 = state_38896;
var ex38978 = (state_38896__$1[(2)]);
var statearr_38985_39091 = state_38896__$1;
(statearr_38985_39091[(5)] = ex38978);


if((ex38978 instanceof Error)){
var statearr_38986_39092 = state_38896__$1;
(statearr_38986_39092[(1)] = (4));

(statearr_38986_39092[(5)] = null);

} else {
throw ex38978;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (14))){
var inst_38656 = (state_38896[(2)]);
var state_38896__$1 = state_38896;
var statearr_38987_39093 = state_38896__$1;
(statearr_38987_39093[(2)] = inst_38656);

(statearr_38987_39093[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (45))){
var inst_38699 = (state_38896[(20)]);
var inst_38659 = (state_38896[(11)]);
var inst_38701 = (state_38896[(22)]);
var inst_38780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38781 = [inst_38699,inst_38701];
var inst_38782 = (new cljs.core.PersistentVector(null,2,(5),inst_38780,inst_38781,null));
var inst_38783 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38784 = [inst_38699];
var inst_38785 = (new cljs.core.PersistentVector(null,1,(5),inst_38783,inst_38784,null));
var inst_38786 = [cljs.core.cst$kw$limit];
var inst_38787 = [inst_38659];
var inst_38788 = cljs.core.PersistentHashMap.fromArrays(inst_38786,inst_38787);
var inst_38789 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_38782,cljs.core._LT__EQ_,inst_38785,inst_38788);
var state_38896__$1 = state_38896;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38896__$1,(48),inst_38789);
} else {
if((state_val_38897 === (53))){
var inst_38699 = (state_38896[(20)]);
var inst_38659 = (state_38896[(11)]);
var inst_38701 = (state_38896[(22)]);
var inst_38812 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38813 = [inst_38699];
var inst_38814 = (new cljs.core.PersistentVector(null,1,(5),inst_38812,inst_38813,null));
var inst_38815 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38816 = [inst_38699,inst_38701];
var inst_38817 = (new cljs.core.PersistentVector(null,2,(5),inst_38815,inst_38816,null));
var inst_38818 = [cljs.core.cst$kw$limit];
var inst_38819 = [inst_38659];
var inst_38820 = cljs.core.PersistentHashMap.fromArrays(inst_38818,inst_38819);
var inst_38821 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_38814,cljs.core._LT__EQ_,inst_38817,inst_38820);
var state_38896__$1 = state_38896;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38896__$1,(56),inst_38821);
} else {
if((state_val_38897 === (78))){
var inst_38853 = (state_38896[(27)]);
var inst_38877 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,inst_38853);
var state_38896__$1 = state_38896;
var statearr_38988_39094 = state_38896__$1;
(statearr_38988_39094[(2)] = inst_38877);

(statearr_38988_39094[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (26))){
var inst_38689 = (state_38896[(13)]);
var inst_38691 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,inst_38689);
var state_38896__$1 = state_38896;
var statearr_38989_39095 = state_38896__$1;
(statearr_38989_39095[(2)] = inst_38691);

(statearr_38989_39095[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (16))){
var state_38896__$1 = state_38896;
var statearr_38990_39096 = state_38896__$1;
(statearr_38990_39096[(2)] = null);

(statearr_38990_39096[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (79))){
var inst_38853 = (state_38896[(27)]);
var state_38896__$1 = state_38896;
var statearr_38991_39097 = state_38896__$1;
(statearr_38991_39097[(2)] = inst_38853);

(statearr_38991_39097[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (38))){
var inst_38700 = (state_38896[(14)]);
var inst_38718 = (state_38896[(15)]);
var inst_38762 = (inst_38718.cljs$core$IFn$_invoke$arity$2 ? inst_38718.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_38700) : inst_38718.call(null,cljs.core._GT_,inst_38700));
var state_38896__$1 = state_38896;
if(cljs.core.truth_(inst_38762)){
var statearr_38992_39098 = state_38896__$1;
(statearr_38992_39098[(1)] = (41));

} else {
var statearr_38993_39099 = state_38896__$1;
(statearr_38993_39099[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (30))){
var state_38896__$1 = state_38896;
var statearr_38994_39100 = state_38896__$1;
(statearr_38994_39100[(2)] = null);

(statearr_38994_39100[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (73))){
var inst_38659 = (state_38896[(11)]);
var state_38896__$1 = state_38896;
var statearr_38995_39101 = state_38896__$1;
(statearr_38995_39101[(2)] = inst_38659);

(statearr_38995_39101[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (10))){
var state_38896__$1 = state_38896;
var statearr_38996_39102 = state_38896__$1;
(statearr_38996_39102[(2)] = null);

(statearr_38996_39102[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (18))){
var inst_38673 = (state_38896[(18)]);
var inst_38680 = (state_38896[(21)]);
var inst_38679 = cljs.core.seq(inst_38673);
var inst_38680__$1 = cljs.core.first(inst_38679);
var inst_38681 = cljs.core.next(inst_38679);
var inst_38682 = cljs.core.not(inst_38680__$1);
var state_38896__$1 = (function (){var statearr_38997 = state_38896;
(statearr_38997[(21)] = inst_38680__$1);

(statearr_38997[(28)] = inst_38681);

return statearr_38997;
})();
if(inst_38682){
var statearr_38998_39103 = state_38896__$1;
(statearr_38998_39103[(1)] = (20));

} else {
var statearr_38999_39104 = state_38896__$1;
(statearr_38999_39104[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (52))){
var inst_38807 = (state_38896[(2)]);
var inst_38808 = fluree.db.util.async.throw_err(inst_38807);
var state_38896__$1 = state_38896;
var statearr_39000_39105 = state_38896__$1;
(statearr_39000_39105[(2)] = inst_38808);

(statearr_39000_39105[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (67))){
var inst_38862 = (state_38896[(8)]);
var inst_38643 = (state_38896[(25)]);
var inst_38862__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$and,inst_38643);
var state_38896__$1 = (function (){var statearr_39001 = state_38896;
(statearr_39001[(8)] = inst_38862__$1);

return statearr_39001;
})();
if(inst_38862__$1){
var statearr_39002_39106 = state_38896__$1;
(statearr_39002_39106[(1)] = (69));

} else {
var statearr_39003_39107 = state_38896__$1;
(statearr_39003_39107[(1)] = (70));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (71))){
var inst_38872 = (state_38896[(2)]);
var state_38896__$1 = state_38896;
var statearr_39004_39108 = state_38896__$1;
(statearr_39004_39108[(2)] = inst_38872);

(statearr_39004_39108[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (42))){
var inst_38700 = (state_38896[(14)]);
var inst_38718 = (state_38896[(15)]);
var inst_38778 = (inst_38718.cljs$core$IFn$_invoke$arity$2 ? inst_38718.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_38700) : inst_38718.call(null,cljs.core._GT__EQ_,inst_38700));
var state_38896__$1 = state_38896;
if(cljs.core.truth_(inst_38778)){
var statearr_39005_39109 = state_38896__$1;
(statearr_39005_39109[(1)] = (45));

} else {
var statearr_39006_39110 = state_38896__$1;
(statearr_39006_39110[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (80))){
var inst_38880 = (state_38896[(2)]);
var state_38896__$1 = state_38896;
var statearr_39007_39111 = state_38896__$1;
(statearr_39007_39111[(2)] = inst_38880);

(statearr_39007_39111[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (37))){
var inst_38699 = (state_38896[(20)]);
var inst_38659 = (state_38896[(11)]);
var inst_38701 = (state_38896[(22)]);
var inst_38751 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38752 = [inst_38699,inst_38701];
var inst_38753 = (new cljs.core.PersistentVector(null,2,(5),inst_38751,inst_38752,null));
var inst_38754 = [cljs.core.cst$kw$limit];
var inst_38755 = [inst_38659];
var inst_38756 = cljs.core.PersistentHashMap.fromArrays(inst_38754,inst_38755);
var inst_38757 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_38753,inst_38756);
var state_38896__$1 = state_38896;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38896__$1,(40),inst_38757);
} else {
if((state_val_38897 === (63))){
var inst_38853 = (state_38896[(27)]);
var inst_38856 = cljs.core.empty_QMARK_(inst_38853);
var state_38896__$1 = state_38896;
var statearr_39008_39112 = state_38896__$1;
(statearr_39008_39112[(2)] = inst_38856);

(statearr_39008_39112[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (8))){
var inst_38650 = (state_38896[(2)]);
var state_38896__$1 = state_38896;
if(cljs.core.truth_(inst_38650)){
var statearr_39009_39113 = state_38896__$1;
(statearr_39009_39113[(1)] = (9));

} else {
var statearr_39010_39114 = state_38896__$1;
(statearr_39010_39114[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38897 === (49))){
var inst_38699 = (state_38896[(20)]);
var inst_38659 = (state_38896[(11)]);
var inst_38701 = (state_38896[(22)]);
var inst_38796 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38797 = [inst_38699];
var inst_38798 = (new cljs.core.PersistentVector(null,1,(5),inst_38796,inst_38797,null));
var inst_38799 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38800 = [inst_38699,inst_38701];
var inst_38801 = (new cljs.core.PersistentVector(null,2,(5),inst_38799,inst_38800,null));
var inst_38802 = [cljs.core.cst$kw$limit];
var inst_38803 = [inst_38659];
var inst_38804 = cljs.core.PersistentHashMap.fromArrays(inst_38802,inst_38803);
var inst_38805 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_38798,cljs.core._LT_,inst_38801,inst_38804);
var state_38896__$1 = state_38896;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38896__$1,(52),inst_38805);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__15091__auto__ = null;
var fluree$db$query$fql$state_machine__15091__auto____0 = (function (){
var statearr_39011 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39011[(0)] = fluree$db$query$fql$state_machine__15091__auto__);

(statearr_39011[(1)] = (1));

return statearr_39011;
});
var fluree$db$query$fql$state_machine__15091__auto____1 = (function (state_38896){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_38896);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e39012){var ex__15094__auto__ = e39012;
var statearr_39013_39115 = state_38896;
(statearr_39013_39115[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_38896[(4)]))){
var statearr_39014_39116 = state_38896;
(statearr_39014_39116[(1)] = cljs.core.first((state_38896[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__39117 = state_38896;
state_38896 = G__39117;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__15091__auto__ = function(state_38896){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__15091__auto____1.call(this,state_38896);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__15091__auto____0;
fluree$db$query$fql$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__15091__auto____1;
return fluree$db$query$fql$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_39015 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_39015[(6)] = c__15165__auto__);

return statearr_39015;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 4);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$variable,var_as_symbol,cljs.core.cst$kw$selection,cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__5045__auto__ = cljs.core.every_QMARK_((function (p1__39118_SHARP_){
return ((typeof p1__39118_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__39118_SHARP_)));
}),select_smt);
if(or__5045__auto__){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$variable,var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__39119_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__39119_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__39123 = vars;
var vec__39124 = G__39123;
var seq__39125 = cljs.core.seq(vec__39124);
var first__39126 = cljs.core.first(seq__39125);
var seq__39125__$1 = cljs.core.next(seq__39125);
var var$ = first__39126;
var r = seq__39125__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__39123__$1 = G__39123;
var all_vars__$1 = all_vars;
while(true){
var vec__39131 = G__39123__$1;
var seq__39132 = cljs.core.seq(vec__39131);
var first__39133 = cljs.core.first(seq__39132);
var seq__39132__$1 = cljs.core.next(seq__39132);
var var$__$1 = first__39133;
var r__$1 = seq__39132__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__39134 = cljs.core.set(all_vars__$2);
return (fexpr__39134.cljs$core$IFn$_invoke$arity$1 ? fexpr__39134.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__39134.call(null,var$__$1));
})())){
var G__39135 = r__$1;
var G__39136 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__39123__$1 = G__39135;
all_vars__$1 = G__39136;
continue;
} else {
var G__39137 = r__$1;
var G__39138 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__39123__$1 = G__39137;
all_vars__$1 = G__39138;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_39173){
var state_val_39174 = (state_39173[(1)]);
if((state_val_39174 === (1))){
var inst_39146 = functionArray;
var inst_39147 = cljs.core.seq(inst_39146);
var inst_39148 = cljs.core.first(inst_39147);
var inst_39149 = cljs.core.next(inst_39147);
var inst_39150 = cljs.core.PersistentVector.EMPTY;
var inst_39151 = inst_39146;
var inst_39152 = inst_39150;
var state_39173__$1 = (function (){var statearr_39175 = state_39173;
(statearr_39175[(7)] = inst_39148);

(statearr_39175[(8)] = inst_39152);

(statearr_39175[(9)] = inst_39151);

(statearr_39175[(10)] = inst_39149);

return statearr_39175;
})();
var statearr_39176_39189 = state_39173__$1;
(statearr_39176_39189[(2)] = null);

(statearr_39176_39189[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39174 === (2))){
var inst_39158 = (state_39173[(11)]);
var inst_39151 = (state_39173[(9)]);
var inst_39157 = cljs.core.seq(inst_39151);
var inst_39158__$1 = cljs.core.first(inst_39157);
var inst_39159 = cljs.core.next(inst_39157);
var state_39173__$1 = (function (){var statearr_39177 = state_39173;
(statearr_39177[(12)] = inst_39159);

(statearr_39177[(11)] = inst_39158__$1);

return statearr_39177;
})();
if(cljs.core.truth_(inst_39158__$1)){
var statearr_39178_39190 = state_39173__$1;
(statearr_39178_39190[(1)] = (4));

} else {
var statearr_39179_39191 = state_39173__$1;
(statearr_39179_39191[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39174 === (3))){
var inst_39171 = (state_39173[(2)]);
var state_39173__$1 = state_39173;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39173__$1,inst_39171);
} else {
if((state_val_39174 === (4))){
var inst_39158 = (state_39173[(11)]);
var inst_39161 = (inst_39158.cljs$core$IFn$_invoke$arity$1 ? inst_39158.cljs$core$IFn$_invoke$arity$1(tuple) : inst_39158.call(null,tuple));
var state_39173__$1 = state_39173;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39173__$1,(7),inst_39161);
} else {
if((state_val_39174 === (5))){
var inst_39152 = (state_39173[(8)]);
var state_39173__$1 = state_39173;
var statearr_39180_39192 = state_39173__$1;
(statearr_39180_39192[(2)] = inst_39152);

(statearr_39180_39192[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39174 === (6))){
var inst_39169 = (state_39173[(2)]);
var state_39173__$1 = state_39173;
var statearr_39181_39193 = state_39173__$1;
(statearr_39181_39193[(2)] = inst_39169);

(statearr_39181_39193[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39174 === (7))){
var inst_39159 = (state_39173[(12)]);
var inst_39152 = (state_39173[(8)]);
var inst_39163 = (state_39173[(2)]);
var inst_39164 = fluree.db.util.async.throw_err(inst_39163);
var inst_39165 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39152,inst_39164);
var inst_39151 = inst_39159;
var inst_39152__$1 = inst_39165;
var state_39173__$1 = (function (){var statearr_39182 = state_39173;
(statearr_39182[(8)] = inst_39152__$1);

(statearr_39182[(9)] = inst_39151);

return statearr_39182;
})();
var statearr_39183_39194 = state_39173__$1;
(statearr_39183_39194[(2)] = null);

(statearr_39183_39194[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__15091__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__15091__auto____0 = (function (){
var statearr_39184 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39184[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__15091__auto__);

(statearr_39184[(1)] = (1));

return statearr_39184;
});
var fluree$db$query$fql$format_tuple_$_state_machine__15091__auto____1 = (function (state_39173){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_39173);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e39185){var ex__15094__auto__ = e39185;
var statearr_39186_39195 = state_39173;
(statearr_39186_39195[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_39173[(4)]))){
var statearr_39187_39196 = state_39173;
(statearr_39187_39196[(1)] = cljs.core.first((state_39173[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__39197 = state_39173;
state_39173 = G__39197;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__15091__auto__ = function(state_39173){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__15091__auto____1.call(this,state_39173);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__15091__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__15091__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_39188 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_39188[(6)] = c__15165__auto__);

return statearr_39188;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5804__auto__ = cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5804__auto__)){
var query_map = temp__5804__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__39198){
var vec__39199 = p__39198;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39199,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39199,(1),null);
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5804__auto__)){
var _id = temp__5804__auto__;
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_39213){
var state_val_39214 = (state_39213[(1)]);
if((state_val_39214 === (1))){
var inst_39202 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39203 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_39204 = [query_map,_id,query_opts];
var inst_39205 = cljs.core.PersistentHashMap.fromArrays(inst_39203,inst_39204);
var inst_39206 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_39205) : fluree.db.query.fql.query.call(null,db,inst_39205));
var state_39213__$1 = (function (){var statearr_39215 = state_39213;
(statearr_39215[(7)] = inst_39202);

return statearr_39215;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39213__$1,(2),inst_39206);
} else {
if((state_val_39214 === (2))){
var inst_39202 = (state_39213[(7)]);
var inst_39208 = (state_39213[(2)]);
var inst_39209 = fluree.db.util.async.throw_err(inst_39208);
var inst_39210 = [tuple_index,inst_39209];
var inst_39211 = (new cljs.core.PersistentVector(null,2,(5),inst_39202,inst_39210,null));
var state_39213__$1 = state_39213;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39213__$1,inst_39211);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__15091__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__15091__auto____0 = (function (){
var statearr_39216 = [null,null,null,null,null,null,null,null];
(statearr_39216[(0)] = fluree$db$query$fql$expand_map_$_state_machine__15091__auto__);

(statearr_39216[(1)] = (1));

return statearr_39216;
});
var fluree$db$query$fql$expand_map_$_state_machine__15091__auto____1 = (function (state_39213){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_39213);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e39217){var ex__15094__auto__ = e39217;
var statearr_39218_39221 = state_39213;
(statearr_39218_39221[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_39213[(4)]))){
var statearr_39219_39222 = state_39213;
(statearr_39219_39222[(1)] = cljs.core.first((state_39213[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__39223 = state_39213;
state_39213 = G__39223;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__15091__auto__ = function(state_39213){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__15091__auto____1.call(this,state_39213);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__15091__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__15091__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_39220 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_39220[(6)] = c__15165__auto__);

return statearr_39220;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__39224 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39224,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39224,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_39287){
var state_val_39288 = (state_39287[(1)]);
if((state_val_39288 === (7))){
var inst_39282 = (state_39287[(2)]);
var _ = (function (){var statearr_39289 = state_39287;
(statearr_39289[(4)] = cljs.core.rest((state_39287[(4)])));

return statearr_39289;
})();
var state_39287__$1 = state_39287;
var statearr_39290_39381 = state_39287__$1;
(statearr_39290_39381[(2)] = inst_39282);

(statearr_39290_39381[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39288 === (20))){
var inst_39273 = (state_39287[(2)]);
var state_39287__$1 = state_39287;
var statearr_39291_39382 = state_39287__$1;
(statearr_39291_39382[(2)] = inst_39273);

(statearr_39291_39382[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39288 === (1))){
var state_39287__$1 = state_39287;
var statearr_39292_39383 = state_39287__$1;
(statearr_39292_39383[(2)] = null);

(statearr_39292_39383[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39288 === (4))){
var inst_39229 = (state_39287[(2)]);
var state_39287__$1 = state_39287;
var statearr_39293_39384 = state_39287__$1;
(statearr_39293_39384[(2)] = inst_39229);

(statearr_39293_39384[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39288 === (15))){
var inst_39249 = (state_39287[(7)]);
var inst_39258 = cljs.core.second(inst_39249);
var inst_39259 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_39258);
var inst_39260 = (inst_39259 > max_fuel);
var state_39287__$1 = state_39287;
if(cljs.core.truth_(inst_39260)){
var statearr_39294_39385 = state_39287__$1;
(statearr_39294_39385[(1)] = (18));

} else {
var statearr_39295_39386 = state_39287__$1;
(statearr_39295_39386[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39288 === (13))){
var state_39287__$1 = state_39287;
var statearr_39296_39387 = state_39287__$1;
(statearr_39296_39387[(1)] = (15));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39288 === (6))){
var inst_39237 = (state_39287[(8)]);
var state_39287__$1 = state_39287;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39287__$1,(8),inst_39237);
} else {
if((state_val_39288 === (17))){
var inst_39276 = (state_39287[(2)]);
var state_39287__$1 = state_39287;
var statearr_39298_39388 = state_39287__$1;
(statearr_39298_39388[(2)] = inst_39276);

(statearr_39298_39388[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39288 === (3))){
var inst_39285 = (state_39287[(2)]);
var state_39287__$1 = state_39287;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39287__$1,inst_39285);
} else {
if((state_val_39288 === (12))){
var inst_39249 = (state_39287[(7)]);
var inst_39238 = (state_39287[(9)]);
var inst_39255 = (inst_39238.cljs$core$IFn$_invoke$arity$0 ? inst_39238.cljs$core$IFn$_invoke$arity$0() : inst_39238.call(null));
var state_39287__$1 = (function (){var statearr_39299 = state_39287;
(statearr_39299[(10)] = inst_39255);

return statearr_39299;
})();
var statearr_39300_39389 = state_39287__$1;
(statearr_39300_39389[(2)] = inst_39249);

(statearr_39300_39389[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39288 === (2))){
var inst_39237 = (state_39287[(8)]);
var inst_39238 = (state_39287[(9)]);
var _ = (function (){var statearr_39301 = state_39287;
(statearr_39301[(4)] = cljs.core.cons((5),(state_39287[(4)])));

return statearr_39301;
})();
var inst_39235 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_39236 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_39237__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_39238__$1 = (function (){var expandMaps = inst_39235;
var queue_ch = inst_39236;
var res_ch = inst_39237__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_39239 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$limit,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$groupBy], 0));
var inst_39240 = cljs.core.volatile_BANG_((0));
var inst_39241 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39239,cljs.core.cst$kw$fuel,inst_39240);
var inst_39242 = (function (){var expandMaps = inst_39235;
var queue_ch = inst_39236;
var res_ch = inst_39237__$1;
var stop_BANG_ = inst_39238__$1;
var opts_STAR_ = inst_39241;
return (function (tuple_res,port){
var c__15165__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_39334){
var state_val_39335 = (state_39334[(1)]);
if((state_val_39335 === (7))){
var state_39334__$1 = state_39334;
var statearr_39336_39390 = state_39334__$1;
(statearr_39336_39390[(2)] = tuple_res);

(statearr_39336_39390[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39335 === (1))){
var state_39334__$1 = state_39334;
var statearr_39337_39391 = state_39334__$1;
(statearr_39337_39391[(2)] = null);

(statearr_39337_39391[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39335 === (4))){
var inst_39302 = (state_39334[(2)]);
var inst_39303 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_39302);
var inst_39304 = cljs.core.async.close_BANG_(port);
var state_39334__$1 = (function (){var statearr_39338 = state_39334;
(statearr_39338[(7)] = inst_39303);

return statearr_39338;
})();
var statearr_39339_39392 = state_39334__$1;
(statearr_39339_39392[(2)] = inst_39304);

(statearr_39339_39392[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39335 === (6))){
var inst_39311 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39312 = [tuple_res];
var inst_39313 = (new cljs.core.PersistentVector(null,1,(5),inst_39311,inst_39312,null));
var state_39334__$1 = state_39334;
var statearr_39340_39393 = state_39334__$1;
(statearr_39340_39393[(2)] = inst_39313);

(statearr_39340_39393[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39335 === (3))){
var inst_39332 = (state_39334[(2)]);
var state_39334__$1 = state_39334;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39334__$1,inst_39332);
} else {
if((state_val_39335 === (2))){
var ___$1 = (function (){var statearr_39342 = state_39334;
(statearr_39342[(4)] = cljs.core.cons((5),(state_39334[(4)])));

return statearr_39342;
})();
var state_39334__$1 = state_39334;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_39343_39394 = state_39334__$1;
(statearr_39343_39394[(1)] = (6));

} else {
var statearr_39344_39395 = state_39334__$1;
(statearr_39344_39395[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39335 === (9))){
var inst_39316 = (state_39334[(8)]);
var inst_39318 = (state_39334[(9)]);
var inst_39325 = (state_39334[(2)]);
var inst_39326 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_39316,inst_39325);
var inst_39327 = (inst_39318.cljs$core$IFn$_invoke$arity$1 ? inst_39318.cljs$core$IFn$_invoke$arity$1(inst_39326) : inst_39318.call(null,inst_39326));
var inst_39328 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_39327);
var inst_39329 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_39345 = state_39334;
(statearr_39345[(4)] = cljs.core.rest((state_39334[(4)])));

return statearr_39345;
})();
var state_39334__$1 = (function (){var statearr_39346 = state_39334;
(statearr_39346[(10)] = inst_39328);

return statearr_39346;
})();
var statearr_39347_39396 = state_39334__$1;
(statearr_39347_39396[(2)] = inst_39329);

(statearr_39347_39396[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39335 === (5))){
var ___$1 = (function (){var statearr_39348 = state_39334;
(statearr_39348[(4)] = cljs.core.rest((state_39334[(4)])));

return statearr_39348;
})();
var state_39334__$1 = state_39334;
var ex39341 = (state_39334__$1[(2)]);
var statearr_39349_39397 = state_39334__$1;
(statearr_39349_39397[(5)] = ex39341);


var statearr_39350_39398 = state_39334__$1;
(statearr_39350_39398[(1)] = (4));

(statearr_39350_39398[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_39335 === (8))){
var inst_39316 = (state_39334[(8)]);
var inst_39316__$1 = (state_39334[(2)]);
var inst_39317 = cljs.core.volatile_BANG_((0));
var inst_39318 = (function (){var tuple_res_SINGLEQUOTE_ = inst_39316__$1;
var query_fuel = inst_39317;
return (function (p1__39228_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__39228_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__39228_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_39319 = cljs.core.PersistentVector.EMPTY;
var inst_39320 = (function (){var tuple_res_SINGLEQUOTE_ = inst_39316__$1;
var query_fuel = inst_39317;
return (function (p1__39227_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,cljs.core.cst$kw$fuel,fuel),tuple_res_SINGLEQUOTE_,p1__39227_SHARP_);
});
})();
var inst_39321 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_39320,expandMaps);
var inst_39322 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_39321);
var inst_39323 = cljs.core.async.into(inst_39319,inst_39322);
var state_39334__$1 = (function (){var statearr_39351 = state_39334;
(statearr_39351[(8)] = inst_39316__$1);

(statearr_39351[(9)] = inst_39318);

return statearr_39351;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39334__$1,(9),inst_39323);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__15091__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__15091__auto____0 = (function (){
var statearr_39352 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_39352[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__15091__auto__);

(statearr_39352[(1)] = (1));

return statearr_39352;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__15091__auto____1 = (function (state_39334){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_39334);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e39353){var ex__15094__auto__ = e39353;
var statearr_39354_39399 = state_39334;
(statearr_39354_39399[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_39334[(4)]))){
var statearr_39355_39400 = state_39334;
(statearr_39355_39400[(1)] = cljs.core.first((state_39334[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__39401 = state_39334;
state_39334 = G__39401;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__15091__auto__ = function(state_39334){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__15091__auto____1.call(this,state_39334);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__15091__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__15091__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_39356 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_39356[(6)] = c__15165__auto____$1);

return statearr_39356;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto____$1;
});
})();
var inst_39243 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_39236,tuples_res);
var inst_39244 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_39237__$1,inst_39242,inst_39236);
var inst_39245 = cljs.core.PersistentVector.EMPTY;
var inst_39246 = inst_39245;
var state_39287__$1 = (function (){var statearr_39357 = state_39287;
(statearr_39357[(11)] = inst_39244);

(statearr_39357[(8)] = inst_39237__$1);

(statearr_39357[(12)] = inst_39246);

(statearr_39357[(13)] = inst_39243);

(statearr_39357[(9)] = inst_39238__$1);

return statearr_39357;
})();
var statearr_39358_39402 = state_39287__$1;
(statearr_39358_39402[(2)] = null);

(statearr_39358_39402[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39288 === (19))){
var inst_39246 = (state_39287[(12)]);
var inst_39249 = (state_39287[(7)]);
var inst_39269 = cljs.core.first(inst_39249);
var inst_39270 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39246,inst_39269);
var inst_39246__$1 = inst_39270;
var state_39287__$1 = (function (){var statearr_39359 = state_39287;
(statearr_39359[(12)] = inst_39246__$1);

return statearr_39359;
})();
var statearr_39360_39403 = state_39287__$1;
(statearr_39360_39403[(2)] = null);

(statearr_39360_39403[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39288 === (11))){
var inst_39280 = (state_39287[(2)]);
var state_39287__$1 = state_39287;
var statearr_39362_39404 = state_39287__$1;
(statearr_39362_39404[(2)] = inst_39280);

(statearr_39362_39404[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39288 === (9))){
var inst_39246 = (state_39287[(12)]);
var state_39287__$1 = state_39287;
var statearr_39363_39405 = state_39287__$1;
(statearr_39363_39405[(2)] = inst_39246);

(statearr_39363_39405[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39288 === (5))){
var _ = (function (){var statearr_39364 = state_39287;
(statearr_39364[(4)] = cljs.core.rest((state_39287[(4)])));

return statearr_39364;
})();
var state_39287__$1 = state_39287;
var ex39361 = (state_39287__$1[(2)]);
var statearr_39365_39406 = state_39287__$1;
(statearr_39365_39406[(5)] = ex39361);


if((ex39361 instanceof Error)){
var statearr_39366_39407 = state_39287__$1;
(statearr_39366_39407[(1)] = (4));

(statearr_39366_39407[(5)] = null);

} else {
throw ex39361;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39288 === (14))){
var inst_39278 = (state_39287[(2)]);
var state_39287__$1 = state_39287;
var statearr_39367_39408 = state_39287__$1;
(statearr_39367_39408[(2)] = inst_39278);

(statearr_39367_39408[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39288 === (16))){
var state_39287__$1 = state_39287;
var statearr_39368_39409 = state_39287__$1;
(statearr_39368_39409[(2)] = null);

(statearr_39368_39409[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39288 === (10))){
var inst_39249 = (state_39287[(7)]);
var inst_39253 = fluree.db.util.core.exception_QMARK_(inst_39249);
var state_39287__$1 = state_39287;
if(inst_39253){
var statearr_39369_39410 = state_39287__$1;
(statearr_39369_39410[(1)] = (12));

} else {
var statearr_39370_39411 = state_39287__$1;
(statearr_39370_39411[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39288 === (18))){
var inst_39238 = (state_39287[(9)]);
var inst_39262 = (inst_39238.cljs$core$IFn$_invoke$arity$0 ? inst_39238.cljs$core$IFn$_invoke$arity$0() : inst_39238.call(null));
var inst_39263 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_39264 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_39265 = [cljs.core.cst$kw$db_SLASH_insufficient_DASH_fuel,(400)];
var inst_39266 = cljs.core.PersistentHashMap.fromArrays(inst_39264,inst_39265);
var inst_39267 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39263,inst_39266);
var state_39287__$1 = (function (){var statearr_39371 = state_39287;
(statearr_39371[(14)] = inst_39262);

return statearr_39371;
})();
var statearr_39372_39412 = state_39287__$1;
(statearr_39372_39412[(2)] = inst_39267);

(statearr_39372_39412[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39288 === (8))){
var inst_39249 = (state_39287[(7)]);
var inst_39249__$1 = (state_39287[(2)]);
var inst_39250 = (inst_39249__$1 == null);
var state_39287__$1 = (function (){var statearr_39373 = state_39287;
(statearr_39373[(7)] = inst_39249__$1);

return statearr_39373;
})();
if(cljs.core.truth_(inst_39250)){
var statearr_39374_39413 = state_39287__$1;
(statearr_39374_39413[(1)] = (9));

} else {
var statearr_39375_39414 = state_39287__$1;
(statearr_39375_39414[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__15091__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__15091__auto____0 = (function (){
var statearr_39376 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39376[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__15091__auto__);

(statearr_39376[(1)] = (1));

return statearr_39376;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__15091__auto____1 = (function (state_39287){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_39287);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e39377){var ex__15094__auto__ = e39377;
var statearr_39378_39415 = state_39287;
(statearr_39378_39415[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_39287[(4)]))){
var statearr_39379_39416 = state_39287;
(statearr_39379_39416[(1)] = cljs.core.first((state_39287[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__39417 = state_39287;
state_39287 = G__39417;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__15091__auto__ = function(state_39287){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__15091__auto____1.call(this,state_39287);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__15091__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__15091__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_39380 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_39380[(6)] = c__15165__auto__);

return statearr_39380;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__39418 = select;
var map__39418__$1 = cljs.core.__destructure_map(map__39418);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39418__$1,cljs.core.cst$kw$as);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39418__$1,cljs.core.cst$kw$variable);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39418__$1,cljs.core.cst$kw$value);
var select_val = (function (){var or__5045__auto__ = as;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__39421 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39421,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39421,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39421,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__39419_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__39419_SHARP_,compare_idx));
}):(function (p1__39420_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__39420_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__39426 = arguments.length;
switch (G__39426) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__39427,p__39428,group_limit,opts){
var map__39429 = p__39427;
var map__39429__$1 = cljs.core.__destructure_map(map__39429);
var res = map__39429__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39429__$1,cljs.core.cst$kw$vars);
var map__39430 = p__39428;
var map__39430__$1 = cljs.core.__destructure_map(map__39430);
var select_spec = map__39430__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39430__$1,cljs.core.cst$kw$inVector_QMARK_);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39430__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39430__$1,cljs.core.cst$kw$orderBy);
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39430__$1,cljs.core.cst$kw$expandMaps_QMARK_);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39430__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39430__$1,cljs.core.cst$kw$offset);
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39430__$1,cljs.core.cst$kw$aggregates);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39430__$1,cljs.core.cst$kw$prettyPrint);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39430__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39430__$1,cljs.core.cst$kw$groupBy);
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_39567){
var state_val_39568 = (state_39567[(1)]);
if((state_val_39568 === (7))){
var inst_39437 = (state_39567[(7)]);
var state_39567__$1 = state_39567;
var statearr_39569_39671 = state_39567__$1;
(statearr_39569_39671[(2)] = inst_39437);

(statearr_39569_39671[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (59))){
var inst_39560 = (state_39567[(2)]);
var state_39567__$1 = state_39567;
var statearr_39570_39672 = state_39567__$1;
(statearr_39570_39672[(2)] = inst_39560);

(statearr_39570_39672[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (20))){
var inst_39476 = (state_39567[(8)]);
var inst_39473 = (state_39567[(9)]);
var inst_39472 = (state_39567[(2)]);
var inst_39473__$1 = cljs.core.__destructure_map(inst_39472);
var inst_39474 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39473__$1,cljs.core.cst$kw$headers);
var inst_39475 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39473__$1,cljs.core.cst$kw$tuples);
var inst_39476__$1 = offset;
var state_39567__$1 = (function (){var statearr_39571 = state_39567;
(statearr_39571[(10)] = inst_39474);

(statearr_39571[(8)] = inst_39476__$1);

(statearr_39571[(11)] = inst_39475);

(statearr_39571[(9)] = inst_39473__$1);

return statearr_39571;
})();
if(cljs.core.truth_(inst_39476__$1)){
var statearr_39572_39673 = state_39567__$1;
(statearr_39572_39673[(1)] = (21));

} else {
var statearr_39573_39674 = state_39567__$1;
(statearr_39573_39674[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (58))){
var inst_39552 = (state_39567[(12)]);
var state_39567__$1 = state_39567;
var statearr_39574_39675 = state_39567__$1;
(statearr_39574_39675[(2)] = inst_39552);

(statearr_39574_39675[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (60))){
var inst_39556 = (state_39567[(2)]);
var inst_39557 = fluree.db.util.async.throw_err(inst_39556);
var state_39567__$1 = state_39567;
var statearr_39575_39676 = state_39567__$1;
(statearr_39575_39676[(2)] = inst_39557);

(statearr_39575_39676[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (27))){
var inst_39488 = cljs.core.not(inVector_QMARK_);
var state_39567__$1 = state_39567;
var statearr_39576_39677 = state_39567__$1;
(statearr_39576_39677[(2)] = inst_39488);

(statearr_39576_39677[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (1))){
var state_39567__$1 = state_39567;
var statearr_39577_39678 = state_39567__$1;
(statearr_39577_39678[(2)] = null);

(statearr_39577_39678[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (24))){
var state_39567__$1 = state_39567;
var statearr_39578_39679 = state_39567__$1;
(statearr_39578_39679[(2)] = offset);

(statearr_39578_39679[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (55))){
var inst_39546 = (state_39567[(13)]);
var state_39567__$1 = state_39567;
var statearr_39579_39680 = state_39567__$1;
(statearr_39579_39680[(2)] = inst_39546);

(statearr_39579_39680[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (39))){
var inst_39514 = (state_39567[(14)]);
var inst_39516 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_39517 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39514,inst_39516);
var state_39567__$1 = state_39567;
var statearr_39580_39681 = state_39567__$1;
(statearr_39580_39681[(2)] = inst_39517);

(statearr_39580_39681[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (46))){
var inst_39526 = (state_39567[(15)]);
var state_39567__$1 = state_39567;
var statearr_39581_39682 = state_39567__$1;
(statearr_39581_39682[(2)] = inst_39526);

(statearr_39581_39682[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (4))){
var inst_39431 = (state_39567[(2)]);
var state_39567__$1 = state_39567;
var statearr_39582_39683 = state_39567__$1;
(statearr_39582_39683[(2)] = inst_39431);

(statearr_39582_39683[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (54))){
var inst_39546 = (state_39567[(13)]);
var inst_39540 = (state_39567[(16)]);
var inst_39548 = cljs.core.PersistentVector.EMPTY;
var inst_39549 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_39548,inst_39540,inst_39546);
var state_39567__$1 = state_39567;
var statearr_39583_39684 = state_39567__$1;
(statearr_39583_39684[(2)] = inst_39549);

(statearr_39583_39684[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (15))){
var inst_39458 = (state_39567[(17)]);
var inst_39460 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39461 = [inst_39458];
var inst_39462 = (new cljs.core.PersistentVector(null,1,(5),inst_39460,inst_39461,null));
var state_39567__$1 = state_39567;
var statearr_39584_39685 = state_39567__$1;
(statearr_39584_39685[(2)] = inst_39462);

(statearr_39584_39685[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (48))){
var inst_39474 = (state_39567[(10)]);
var inst_39496 = (state_39567[(18)]);
var inst_39532 = (state_39567[(19)]);
var inst_39485 = (state_39567[(20)]);
var inst_39475 = (state_39567[(11)]);
var inst_39491 = (state_39567[(21)]);
var inst_39473 = (state_39567[(9)]);
var inst_39534 = (function (){var map__39467 = inst_39473;
var headers = inst_39474;
var tuples = inst_39475;
var offset_SINGLEQUOTE_ = inst_39485;
var single_result_QMARK_ = inst_39491;
var pp_keys = inst_39496;
var G__39497 = inst_39532;
return (function (p1__39424_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__39424_SHARP_);
});
})();
var inst_39535 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_39534);
var inst_39536 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39532,inst_39535);
var state_39567__$1 = state_39567;
var statearr_39585_39686 = state_39567__$1;
(statearr_39585_39686[(2)] = inst_39536);

(statearr_39585_39686[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (50))){
var inst_39539 = (state_39567[(2)]);
var inst_39540 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_39539);
var state_39567__$1 = (function (){var statearr_39586 = state_39567;
(statearr_39586[(16)] = inst_39540);

return statearr_39586;
})();
if(cljs.core.truth_(orderBy)){
var statearr_39587_39687 = state_39567__$1;
(statearr_39587_39687[(1)] = (51));

} else {
var statearr_39588_39688 = state_39567__$1;
(statearr_39588_39688[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (21))){
var inst_39478 = cljs.core.not(groupBy);
var state_39567__$1 = state_39567;
var statearr_39589_39689 = state_39567__$1;
(statearr_39589_39689[(2)] = inst_39478);

(statearr_39589_39689[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (31))){
var state_39567__$1 = state_39567;
var statearr_39590_39690 = state_39567__$1;
(statearr_39590_39690[(2)] = null);

(statearr_39590_39690[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (32))){
var inst_39474 = (state_39567[(10)]);
var inst_39491 = (state_39567[(21)]);
var inst_39496 = (state_39567[(2)]);
var inst_39498 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39499 = fluree.db.query.fql.select_tuples_fn(inst_39474,vars,select);
var inst_39500 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_39499);
var inst_39501 = [inst_39500];
var inst_39502 = (new cljs.core.PersistentVector(null,1,(5),inst_39498,inst_39501,null));
var state_39567__$1 = (function (){var statearr_39591 = state_39567;
(statearr_39591[(18)] = inst_39496);

(statearr_39591[(22)] = inst_39502);

return statearr_39591;
})();
if(cljs.core.truth_(inst_39491)){
var statearr_39592_39691 = state_39567__$1;
(statearr_39592_39691[(1)] = (33));

} else {
var statearr_39593_39692 = state_39567__$1;
(statearr_39593_39692[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (40))){
var inst_39514 = (state_39567[(14)]);
var state_39567__$1 = state_39567;
var statearr_39594_39693 = state_39567__$1;
(statearr_39594_39693[(2)] = inst_39514);

(statearr_39594_39693[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (56))){
var inst_39552 = (state_39567[(2)]);
var state_39567__$1 = (function (){var statearr_39595 = state_39567;
(statearr_39595[(12)] = inst_39552);

return statearr_39595;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_39596_39694 = state_39567__$1;
(statearr_39596_39694[(1)] = (57));

} else {
var statearr_39597_39695 = state_39567__$1;
(statearr_39597_39695[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (33))){
var inst_39502 = (state_39567[(22)]);
var inst_39504 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_39505 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39502,inst_39504);
var state_39567__$1 = state_39567;
var statearr_39598_39696 = state_39567__$1;
(statearr_39598_39696[(2)] = inst_39505);

(statearr_39598_39696[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (13))){
var inst_39447 = (state_39567[(23)]);
var state_39567__$1 = state_39567;
var statearr_39599_39697 = state_39567__$1;
(statearr_39599_39697[(2)] = inst_39447);

(statearr_39599_39697[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (22))){
var inst_39476 = (state_39567[(8)]);
var state_39567__$1 = state_39567;
var statearr_39600_39698 = state_39567__$1;
(statearr_39600_39698[(2)] = inst_39476);

(statearr_39600_39698[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (36))){
var inst_39508 = (state_39567[(24)]);
var inst_39510 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_39511 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39508,inst_39510);
var state_39567__$1 = state_39567;
var statearr_39601_39699 = state_39567__$1;
(statearr_39601_39699[(2)] = inst_39511);

(statearr_39601_39699[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (41))){
var inst_39485 = (state_39567[(20)]);
var inst_39520 = (state_39567[(2)]);
var state_39567__$1 = (function (){var statearr_39602 = state_39567;
(statearr_39602[(25)] = inst_39520);

return statearr_39602;
})();
if(cljs.core.truth_(inst_39485)){
var statearr_39603_39700 = state_39567__$1;
(statearr_39603_39700[(1)] = (42));

} else {
var statearr_39604_39701 = state_39567__$1;
(statearr_39604_39701[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (43))){
var inst_39520 = (state_39567[(25)]);
var state_39567__$1 = state_39567;
var statearr_39605_39702 = state_39567__$1;
(statearr_39605_39702[(2)] = inst_39520);

(statearr_39605_39702[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (29))){
var inst_39491 = (state_39567[(2)]);
var state_39567__$1 = (function (){var statearr_39606 = state_39567;
(statearr_39606[(21)] = inst_39491);

return statearr_39606;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_39607_39703 = state_39567__$1;
(statearr_39607_39703[(1)] = (30));

} else {
var statearr_39608_39704 = state_39567__$1;
(statearr_39608_39704[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (44))){
var inst_39526 = (state_39567[(2)]);
var state_39567__$1 = (function (){var statearr_39609 = state_39567;
(statearr_39609[(15)] = inst_39526);

return statearr_39609;
})();
if(cljs.core.truth_(group_limit)){
var statearr_39610_39705 = state_39567__$1;
(statearr_39610_39705[(1)] = (45));

} else {
var statearr_39611_39706 = state_39567__$1;
(statearr_39611_39706[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (6))){
var inst_39439 = cljs.core.count(select);
var inst_39440 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_39439);
var state_39567__$1 = state_39567;
var statearr_39612_39707 = state_39567__$1;
(statearr_39612_39707[(2)] = inst_39440);

(statearr_39612_39707[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (28))){
var inst_39486 = (state_39567[(26)]);
var state_39567__$1 = state_39567;
var statearr_39613_39708 = state_39567__$1;
(statearr_39613_39708[(2)] = inst_39486);

(statearr_39613_39708[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (51))){
var inst_39474 = (state_39567[(10)]);
var inst_39475 = (state_39567[(11)]);
var inst_39543 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_39474,orderBy,inst_39475);
var state_39567__$1 = state_39567;
var statearr_39614_39709 = state_39567__$1;
(statearr_39614_39709[(2)] = inst_39543);

(statearr_39614_39709[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (25))){
var state_39567__$1 = state_39567;
var statearr_39615_39710 = state_39567__$1;
(statearr_39615_39710[(2)] = null);

(statearr_39615_39710[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (34))){
var inst_39502 = (state_39567[(22)]);
var state_39567__$1 = state_39567;
var statearr_39616_39711 = state_39567__$1;
(statearr_39616_39711[(2)] = inst_39502);

(statearr_39616_39711[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (17))){
var inst_39465 = (state_39567[(2)]);
var state_39567__$1 = state_39567;
var statearr_39617_39712 = state_39567__$1;
(statearr_39617_39712[(2)] = inst_39465);

(statearr_39617_39712[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (3))){
var inst_39565 = (state_39567[(2)]);
var state_39567__$1 = state_39567;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39567__$1,inst_39565);
} else {
if((state_val_39568 === (12))){
var inst_39447 = (state_39567[(23)]);
var inst_39449 = cljs.core.first(select);
var inst_39450 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_39449);
var inst_39451 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39450);
var inst_39452 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_39451,(1));
var inst_39453 = [inst_39452];
var inst_39454 = [inst_39447];
var inst_39455 = cljs.core.PersistentHashMap.fromArrays(inst_39453,inst_39454);
var state_39567__$1 = state_39567;
var statearr_39618_39713 = state_39567__$1;
(statearr_39618_39713[(2)] = inst_39455);

(statearr_39618_39713[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (2))){
var inst_39437 = (state_39567[(7)]);
var _ = (function (){var statearr_39619 = state_39567;
(statearr_39619[(4)] = cljs.core.cons((5),(state_39567[(4)])));

return statearr_39619;
})();
var inst_39437__$1 = aggregates;
var state_39567__$1 = (function (){var statearr_39620 = state_39567;
(statearr_39620[(7)] = inst_39437__$1);

return statearr_39620;
})();
if(cljs.core.truth_(inst_39437__$1)){
var statearr_39621_39714 = state_39567__$1;
(statearr_39621_39714[(1)] = (6));

} else {
var statearr_39622_39715 = state_39567__$1;
(statearr_39622_39715[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (23))){
var inst_39481 = (state_39567[(2)]);
var state_39567__$1 = state_39567;
if(cljs.core.truth_(inst_39481)){
var statearr_39623_39716 = state_39567__$1;
(statearr_39623_39716[(1)] = (24));

} else {
var statearr_39624_39717 = state_39567__$1;
(statearr_39624_39717[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (47))){
var inst_39532 = (state_39567[(2)]);
var state_39567__$1 = (function (){var statearr_39625 = state_39567;
(statearr_39625[(19)] = inst_39532);

return statearr_39625;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_39626_39718 = state_39567__$1;
(statearr_39626_39718[(1)] = (48));

} else {
var statearr_39627_39719 = state_39567__$1;
(statearr_39627_39719[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (35))){
var inst_39508 = (state_39567[(2)]);
var state_39567__$1 = (function (){var statearr_39628 = state_39567;
(statearr_39628[(24)] = inst_39508);

return statearr_39628;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_39629_39720 = state_39567__$1;
(statearr_39629_39720[(1)] = (36));

} else {
var statearr_39630_39721 = state_39567__$1;
(statearr_39630_39721[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (19))){
var state_39567__$1 = state_39567;
var statearr_39631_39722 = state_39567__$1;
(statearr_39631_39722[(2)] = res);

(statearr_39631_39722[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (57))){
var inst_39496 = (state_39567[(18)]);
var inst_39491 = (state_39567[(21)]);
var inst_39552 = (state_39567[(12)]);
var inst_39554 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_39496,inst_39491,db,fuel,max_fuel,opts,(8),inst_39552);
var state_39567__$1 = state_39567;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39567__$1,(60),inst_39554);
} else {
if((state_val_39568 === (11))){
var inst_39562 = (state_39567[(2)]);
var _ = (function (){var statearr_39633 = state_39567;
(statearr_39633[(4)] = cljs.core.rest((state_39567[(4)])));

return statearr_39633;
})();
var state_39567__$1 = state_39567;
var statearr_39634_39723 = state_39567__$1;
(statearr_39634_39723[(2)] = inst_39562);

(statearr_39634_39723[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (9))){
var inst_39445 = cljs.core.first(aggregates);
var inst_39446 = fluree.db.query.analytical.calculate_aggregate(res,inst_39445);
var inst_39447 = cljs.core.second(inst_39446);
var state_39567__$1 = (function (){var statearr_39635 = state_39567;
(statearr_39635[(23)] = inst_39447);

return statearr_39635;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_39636_39724 = state_39567__$1;
(statearr_39636_39724[(1)] = (12));

} else {
var statearr_39637_39725 = state_39567__$1;
(statearr_39637_39725[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (5))){
var _ = (function (){var statearr_39638 = state_39567;
(statearr_39638[(4)] = cljs.core.rest((state_39567[(4)])));

return statearr_39638;
})();
var state_39567__$1 = state_39567;
var ex39632 = (state_39567__$1[(2)]);
var statearr_39639_39726 = state_39567__$1;
(statearr_39639_39726[(5)] = ex39632);


if((ex39632 instanceof Error)){
var statearr_39640_39727 = state_39567__$1;
(statearr_39640_39727[(1)] = (4));

(statearr_39640_39727[(5)] = null);

} else {
throw ex39632;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (14))){
var inst_39458 = (state_39567[(2)]);
var state_39567__$1 = (function (){var statearr_39641 = state_39567;
(statearr_39641[(17)] = inst_39458);

return statearr_39641;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_39642_39728 = state_39567__$1;
(statearr_39642_39728[(1)] = (15));

} else {
var statearr_39643_39729 = state_39567__$1;
(statearr_39643_39729[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (45))){
var inst_39526 = (state_39567[(15)]);
var inst_39528 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_39529 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39526,inst_39528);
var state_39567__$1 = state_39567;
var statearr_39644_39730 = state_39567__$1;
(statearr_39644_39730[(2)] = inst_39529);

(statearr_39644_39730[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (53))){
var inst_39546 = (state_39567[(2)]);
var state_39567__$1 = (function (){var statearr_39645 = state_39567;
(statearr_39645[(13)] = inst_39546);

return statearr_39645;
})();
var statearr_39646_39731 = state_39567__$1;
(statearr_39646_39731[(1)] = (54));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (26))){
var inst_39486 = (state_39567[(26)]);
var inst_39485 = (state_39567[(2)]);
var inst_39486__$1 = cljs.core.not(prettyPrint);
var state_39567__$1 = (function (){var statearr_39648 = state_39567;
(statearr_39648[(20)] = inst_39485);

(statearr_39648[(26)] = inst_39486__$1);

return statearr_39648;
})();
if(inst_39486__$1){
var statearr_39649_39732 = state_39567__$1;
(statearr_39649_39732[(1)] = (27));

} else {
var statearr_39650_39733 = state_39567__$1;
(statearr_39650_39733[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (16))){
var inst_39458 = (state_39567[(17)]);
var state_39567__$1 = state_39567;
var statearr_39651_39734 = state_39567__$1;
(statearr_39651_39734[(2)] = inst_39458);

(statearr_39651_39734[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (38))){
var inst_39514 = (state_39567[(2)]);
var state_39567__$1 = (function (){var statearr_39652 = state_39567;
(statearr_39652[(14)] = inst_39514);

return statearr_39652;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_39653_39735 = state_39567__$1;
(statearr_39653_39735[(1)] = (39));

} else {
var statearr_39654_39736 = state_39567__$1;
(statearr_39654_39736[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (30))){
var inst_39493 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_39567__$1 = state_39567;
var statearr_39655_39737 = state_39567__$1;
(statearr_39655_39737[(2)] = inst_39493);

(statearr_39655_39737[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (10))){
var state_39567__$1 = state_39567;
if(cljs.core.truth_(aggregates)){
var statearr_39656_39738 = state_39567__$1;
(statearr_39656_39738[(1)] = (18));

} else {
var statearr_39657_39739 = state_39567__$1;
(statearr_39657_39739[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (18))){
var inst_39469 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_39567__$1 = state_39567;
var statearr_39658_39740 = state_39567__$1;
(statearr_39658_39740[(2)] = inst_39469);

(statearr_39658_39740[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (52))){
var inst_39475 = (state_39567[(11)]);
var state_39567__$1 = state_39567;
var statearr_39659_39741 = state_39567__$1;
(statearr_39659_39741[(2)] = inst_39475);

(statearr_39659_39741[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (42))){
var inst_39520 = (state_39567[(25)]);
var inst_39485 = (state_39567[(20)]);
var inst_39522 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_39485);
var inst_39523 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39520,inst_39522);
var state_39567__$1 = state_39567;
var statearr_39660_39742 = state_39567__$1;
(statearr_39660_39742[(2)] = inst_39523);

(statearr_39660_39742[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (37))){
var inst_39508 = (state_39567[(24)]);
var state_39567__$1 = state_39567;
var statearr_39661_39743 = state_39567__$1;
(statearr_39661_39743[(2)] = inst_39508);

(statearr_39661_39743[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (8))){
var inst_39443 = (state_39567[(2)]);
var state_39567__$1 = state_39567;
if(cljs.core.truth_(inst_39443)){
var statearr_39662_39744 = state_39567__$1;
(statearr_39662_39744[(1)] = (9));

} else {
var statearr_39663_39745 = state_39567__$1;
(statearr_39663_39745[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39568 === (49))){
var inst_39532 = (state_39567[(19)]);
var state_39567__$1 = state_39567;
var statearr_39664_39746 = state_39567__$1;
(statearr_39664_39746[(2)] = inst_39532);

(statearr_39664_39746[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__15091__auto__ = null;
var fluree$db$query$fql$state_machine__15091__auto____0 = (function (){
var statearr_39665 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39665[(0)] = fluree$db$query$fql$state_machine__15091__auto__);

(statearr_39665[(1)] = (1));

return statearr_39665;
});
var fluree$db$query$fql$state_machine__15091__auto____1 = (function (state_39567){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_39567);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e39666){var ex__15094__auto__ = e39666;
var statearr_39667_39747 = state_39567;
(statearr_39667_39747[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_39567[(4)]))){
var statearr_39668_39748 = state_39567;
(statearr_39668_39748[(1)] = cljs.core.first((state_39567[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__39749 = state_39567;
state_39567 = G__39749;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__15091__auto__ = function(state_39567){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__15091__auto____1.call(this,state_39567);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__15091__auto____0;
fluree$db$query$fql$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__15091__auto____1;
return fluree$db$query$fql$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_39669 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_39669[(6)] = c__15165__auto__);

return statearr_39669;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__39752,groupBy){
var map__39753 = p__39752;
var map__39753__$1 = cljs.core.__destructure_map(map__39753);
var res = map__39753__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39753__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39753__$1,cljs.core.cst$kw$tuples);
var vec__39754 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39754,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39754,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39750_SHARP_){
return fluree.db.util.core.index_of(headers,p1__39750_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39751_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__39751_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__39757 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39757,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39757,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__39760,p__39761,opts){
var map__39762 = p__39760;
var map__39762__$1 = cljs.core.__destructure_map(map__39762);
var res = map__39762__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39762__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39762__$1,cljs.core.cst$kw$vars);
var map__39763 = p__39761;
var map__39763__$1 = cljs.core.__destructure_map(map__39763);
var select_spec = map__39763__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39763__$1,cljs.core.cst$kw$groupBy);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39763__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39763__$1,cljs.core.cst$kw$limit);
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39763__$1,cljs.core.cst$kw$selectOne_QMARK_);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39763__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39763__$1,cljs.core.cst$kw$inVector_QMARK_);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39763__$1,cljs.core.cst$kw$offset);
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_40005){
var state_val_40006 = (state_40005[(1)]);
if((state_val_40006 === (65))){
var state_40005__$1 = state_40005;
var statearr_40007_40158 = state_40005__$1;
(statearr_40007_40158[(1)] = (67));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (70))){
var inst_39926 = (state_40005[(7)]);
var state_40005__$1 = state_40005;
var statearr_40009_40159 = state_40005__$1;
(statearr_40009_40159[(2)] = inst_39926);

(statearr_40009_40159[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (62))){
var state_40005__$1 = state_40005;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_40010_40160 = state_40005__$1;
(statearr_40010_40160[(1)] = (64));

} else {
var statearr_40011_40161 = state_40005__$1;
(statearr_40011_40161[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (74))){
var inst_39842 = (state_40005[(8)]);
var inst_39833 = (state_40005[(9)]);
var inst_39901 = (state_40005[(10)]);
var inst_39934 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39833,inst_39842,inst_39901);
var state_40005__$1 = state_40005;
var statearr_40012_40162 = state_40005__$1;
(statearr_40012_40162[(2)] = inst_39934);

(statearr_40012_40162[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (7))){
var state_40005__$1 = state_40005;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_40013_40163 = state_40005__$1;
(statearr_40013_40163[(1)] = (82));

} else {
var statearr_40014_40164 = state_40005__$1;
(statearr_40014_40164[(1)] = (83));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (59))){
var inst_39831 = (state_40005[(11)]);
var inst_39901 = (state_40005[(10)]);
var inst_39905 = cljs.core.count(inst_39901);
var inst_39906 = (inst_39831 - inst_39905);
var state_40005__$1 = state_40005;
var statearr_40015_40165 = state_40005__$1;
(statearr_40015_40165[(2)] = inst_39906);

(statearr_40015_40165[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (86))){
var state_40005__$1 = state_40005;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_40016_40166 = state_40005__$1;
(statearr_40016_40166[(1)] = (89));

} else {
var statearr_40017_40167 = state_40005__$1;
(statearr_40017_40167[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (20))){
var state_40005__$1 = state_40005;
var statearr_40018_40168 = state_40005__$1;
(statearr_40018_40168[(2)] = (0));

(statearr_40018_40168[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (72))){
var inst_39931 = (state_40005[(2)]);
var state_40005__$1 = state_40005;
if(cljs.core.truth_(inst_39931)){
var statearr_40019_40169 = state_40005__$1;
(statearr_40019_40169[(1)] = (73));

} else {
var statearr_40020_40170 = state_40005__$1;
(statearr_40020_40170[(1)] = (74));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (58))){
var state_40005__$1 = state_40005;
var statearr_40021_40171 = state_40005__$1;
(statearr_40021_40171[(2)] = null);

(statearr_40021_40171[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (60))){
var inst_39832 = (state_40005[(12)]);
var inst_39908 = (state_40005[(2)]);
var inst_39909 = (inst_39832 <= (0));
var state_40005__$1 = (function (){var statearr_40022 = state_40005;
(statearr_40022[(13)] = inst_39908);

return statearr_40022;
})();
if(cljs.core.truth_(inst_39909)){
var statearr_40023_40172 = state_40005__$1;
(statearr_40023_40172[(1)] = (61));

} else {
var statearr_40024_40173 = state_40005__$1;
(statearr_40024_40173[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (27))){
var inst_39831 = (state_40005[(11)]);
var inst_39855 = (inst_39831 < (1));
var state_40005__$1 = state_40005;
var statearr_40025_40174 = state_40005__$1;
(statearr_40025_40174[(2)] = inst_39855);

(statearr_40025_40174[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (1))){
var state_40005__$1 = state_40005;
var statearr_40026_40175 = state_40005__$1;
(statearr_40026_40175[(2)] = null);

(statearr_40026_40175[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (69))){
var inst_39921 = (state_40005[(2)]);
var state_40005__$1 = state_40005;
var statearr_40027_40176 = state_40005__$1;
(statearr_40027_40176[(2)] = inst_39921);

(statearr_40027_40176[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (24))){
var inst_39833 = (state_40005[(9)]);
var state_40005__$1 = state_40005;
var statearr_40028_40177 = state_40005__$1;
(statearr_40028_40177[(2)] = inst_39833);

(statearr_40028_40177[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (55))){
var inst_39891 = (state_40005[(14)]);
var inst_39831 = (state_40005[(11)]);
var inst_39898 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_39831,inst_39891);
var state_40005__$1 = state_40005;
var statearr_40029_40178 = state_40005__$1;
(statearr_40029_40178[(2)] = inst_39898);

(statearr_40029_40178[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (85))){
var inst_39976 = (state_40005[(15)]);
var inst_39975 = (state_40005[(2)]);
var inst_39976__$1 = fluree.db.util.async.throw_err(inst_39975);
var inst_39977 = cljs.core.coll_QMARK_(inst_39976__$1);
var inst_39978 = (!(inst_39977));
var state_40005__$1 = (function (){var statearr_40030 = state_40005;
(statearr_40030[(15)] = inst_39976__$1);

return statearr_40030;
})();
if(inst_39978){
var statearr_40031_40179 = state_40005__$1;
(statearr_40031_40179[(1)] = (86));

} else {
var statearr_40032_40180 = state_40005__$1;
(statearr_40032_40180[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (39))){
var inst_39850 = (state_40005[(16)]);
var inst_39872 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,cljs.core.cst$kw$orderBy,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$limit,null], 0));
var inst_39873 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$offset,(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$limit,null], 0));
var inst_39874 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_39850,inst_39872,inst_39873);
var state_40005__$1 = state_40005;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40005__$1,(42),inst_39874);
} else {
if((state_val_40006 === (88))){
var inst_39998 = (state_40005[(2)]);
var state_40005__$1 = state_40005;
var statearr_40033_40181 = state_40005__$1;
(statearr_40033_40181[(2)] = inst_39998);

(statearr_40033_40181[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (46))){
var inst_39832 = (state_40005[(12)]);
var inst_39886 = ((0) < inst_39832);
var state_40005__$1 = state_40005;
if(cljs.core.truth_(inst_39886)){
var statearr_40034_40182 = state_40005__$1;
(statearr_40034_40182[(1)] = (49));

} else {
var statearr_40035_40183 = state_40005__$1;
(statearr_40035_40183[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (4))){
var inst_39764 = (state_40005[(2)]);
var state_40005__$1 = state_40005;
var statearr_40036_40184 = state_40005__$1;
(statearr_40036_40184[(2)] = inst_39764);

(statearr_40036_40184[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (77))){
var inst_39831 = (state_40005[(11)]);
var inst_39942 = (inst_39831 - (1));
var state_40005__$1 = state_40005;
var statearr_40037_40185 = state_40005__$1;
(statearr_40037_40185[(2)] = inst_39942);

(statearr_40037_40185[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (95))){
var inst_39976 = (state_40005[(15)]);
var state_40005__$1 = state_40005;
var statearr_40038_40186 = state_40005__$1;
(statearr_40038_40186[(2)] = inst_39976);

(statearr_40038_40186[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (54))){
var inst_39896 = (state_40005[(2)]);
var state_40005__$1 = state_40005;
if(cljs.core.truth_(inst_39896)){
var statearr_40039_40187 = state_40005__$1;
(statearr_40039_40187[(1)] = (55));

} else {
var statearr_40040_40188 = state_40005__$1;
(statearr_40040_40188[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (92))){
var inst_39976 = (state_40005[(15)]);
var inst_39989 = cljs.core.first(inst_39976);
var state_40005__$1 = state_40005;
var statearr_40041_40189 = state_40005__$1;
(statearr_40041_40189[(2)] = inst_39989);

(statearr_40041_40189[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (15))){
var inst_39782 = (state_40005[(17)]);
var inst_39790 = (state_40005[(2)]);
var inst_39791 = fluree.db.util.async.throw_err(inst_39790);
var inst_39792 = [inst_39782];
var inst_39793 = [inst_39791];
var inst_39794 = cljs.core.PersistentHashMap.fromArrays(inst_39792,inst_39793);
var state_40005__$1 = state_40005;
var statearr_40042_40190 = state_40005__$1;
(statearr_40042_40190[(2)] = inst_39794);

(statearr_40042_40190[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (48))){
var inst_39954 = (state_40005[(2)]);
var state_40005__$1 = state_40005;
var statearr_40043_40191 = state_40005__$1;
(statearr_40043_40191[(2)] = inst_39954);

(statearr_40043_40191[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (50))){
var inst_39877 = (state_40005[(18)]);
var state_40005__$1 = state_40005;
var statearr_40044_40192 = state_40005__$1;
(statearr_40044_40192[(2)] = inst_39877);

(statearr_40044_40192[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (75))){
var inst_39846 = (state_40005[(19)]);
var inst_39908 = (state_40005[(13)]);
var inst_39925 = (state_40005[(20)]);
var inst_39843 = (state_40005[(21)]);
var inst_39936 = (state_40005[(2)]);
var inst_39829 = inst_39843;
var inst_39830 = inst_39846;
var inst_39831 = inst_39908;
var inst_39832 = inst_39925;
var inst_39833 = inst_39936;
var state_40005__$1 = (function (){var statearr_40045 = state_40005;
(statearr_40045[(22)] = inst_39830);

(statearr_40045[(11)] = inst_39831);

(statearr_40045[(12)] = inst_39832);

(statearr_40045[(9)] = inst_39833);

(statearr_40045[(23)] = inst_39829);

return statearr_40045;
})();
var statearr_40046_40193 = state_40005__$1;
(statearr_40046_40193[(2)] = null);

(statearr_40046_40193[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (21))){
var inst_39822 = (state_40005[(24)]);
var inst_39814 = (state_40005[(25)]);
var inst_39810 = (state_40005[(26)]);
var inst_39827 = (state_40005[(2)]);
var inst_39828 = cljs.core.PersistentHashMap.EMPTY;
var inst_39829 = inst_39810;
var inst_39830 = inst_39814;
var inst_39831 = inst_39822;
var inst_39832 = inst_39827;
var inst_39833 = inst_39828;
var state_40005__$1 = (function (){var statearr_40047 = state_40005;
(statearr_40047[(22)] = inst_39830);

(statearr_40047[(11)] = inst_39831);

(statearr_40047[(12)] = inst_39832);

(statearr_40047[(9)] = inst_39833);

(statearr_40047[(23)] = inst_39829);

return statearr_40047;
})();
var statearr_40048_40194 = state_40005__$1;
(statearr_40048_40194[(2)] = null);

(statearr_40048_40194[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (31))){
var inst_39847 = (state_40005[(27)]);
var inst_39832 = (state_40005[(12)]);
var inst_39861 = (inst_39832 >= inst_39847);
var state_40005__$1 = state_40005;
if(cljs.core.truth_(inst_39861)){
var statearr_40049_40195 = state_40005__$1;
(statearr_40049_40195[(1)] = (33));

} else {
var statearr_40050_40196 = state_40005__$1;
(statearr_40050_40196[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (32))){
var inst_39961 = (state_40005[(2)]);
var state_40005__$1 = state_40005;
var statearr_40051_40197 = state_40005__$1;
(statearr_40051_40197[(2)] = inst_39961);

(statearr_40051_40197[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (40))){
var state_40005__$1 = state_40005;
var statearr_40052_40198 = state_40005__$1;
(statearr_40052_40198[(2)] = null);

(statearr_40052_40198[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (91))){
var inst_39986 = (state_40005[(2)]);
var state_40005__$1 = state_40005;
var statearr_40053_40199 = state_40005__$1;
(statearr_40053_40199[(2)] = inst_39986);

(statearr_40053_40199[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (56))){
var inst_39891 = (state_40005[(14)]);
var state_40005__$1 = state_40005;
var statearr_40054_40200 = state_40005__$1;
(statearr_40054_40200[(2)] = inst_39891);

(statearr_40054_40200[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (33))){
var state_40005__$1 = state_40005;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_40055_40201 = state_40005__$1;
(statearr_40055_40201[(1)] = (36));

} else {
var statearr_40056_40202 = state_40005__$1;
(statearr_40056_40202[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (13))){
var inst_39814 = (state_40005[(25)]);
var inst_39779 = (state_40005[(28)]);
var inst_39810 = (state_40005[(26)]);
var inst_39810__$1 = cljs.core.keys(inst_39779);
var inst_39811 = cljs.core.seq(inst_39810__$1);
var inst_39812 = cljs.core.first(inst_39811);
var inst_39813 = cljs.core.next(inst_39811);
var inst_39814__$1 = cljs.core.vals(inst_39779);
var inst_39815 = cljs.core.seq(inst_39814__$1);
var inst_39816 = cljs.core.first(inst_39815);
var inst_39817 = cljs.core.next(inst_39815);
var inst_39818 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_40005__$1 = (function (){var statearr_40057 = state_40005;
(statearr_40057[(29)] = inst_39812);

(statearr_40057[(30)] = inst_39813);

(statearr_40057[(25)] = inst_39814__$1);

(statearr_40057[(31)] = inst_39817);

(statearr_40057[(32)] = inst_39816);

(statearr_40057[(26)] = inst_39810__$1);

return statearr_40057;
})();
if(inst_39818){
var statearr_40058_40203 = state_40005__$1;
(statearr_40058_40203[(1)] = (16));

} else {
var statearr_40059_40204 = state_40005__$1;
(statearr_40059_40204[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (22))){
var inst_39830 = (state_40005[(22)]);
var inst_39829 = (state_40005[(23)]);
var inst_39841 = cljs.core.seq(inst_39829);
var inst_39842 = cljs.core.first(inst_39841);
var inst_39843 = cljs.core.next(inst_39841);
var inst_39844 = cljs.core.seq(inst_39830);
var inst_39845 = cljs.core.first(inst_39844);
var inst_39846 = cljs.core.next(inst_39844);
var inst_39847 = cljs.core.count(inst_39845);
var inst_39848 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_39849 = [headers,vars,inst_39845];
var inst_39850 = cljs.core.PersistentHashMap.fromArrays(inst_39848,inst_39849);
var inst_39851 = (inst_39845 == null);
var state_40005__$1 = (function (){var statearr_40060 = state_40005;
(statearr_40060[(27)] = inst_39847);

(statearr_40060[(19)] = inst_39846);

(statearr_40060[(8)] = inst_39842);

(statearr_40060[(16)] = inst_39850);

(statearr_40060[(21)] = inst_39843);

return statearr_40060;
})();
if(cljs.core.truth_(inst_39851)){
var statearr_40061_40205 = state_40005__$1;
(statearr_40061_40205[(1)] = (24));

} else {
var statearr_40062_40206 = state_40005__$1;
(statearr_40062_40206[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (90))){
var inst_39976 = (state_40005[(15)]);
var state_40005__$1 = state_40005;
var statearr_40063_40207 = state_40005__$1;
(statearr_40063_40207[(2)] = inst_39976);

(statearr_40063_40207[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (36))){
var inst_39832 = (state_40005[(12)]);
var inst_39864 = (inst_39832 - (1));
var state_40005__$1 = state_40005;
var statearr_40064_40208 = state_40005__$1;
(statearr_40064_40208[(2)] = inst_39864);

(statearr_40064_40208[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (41))){
var inst_39957 = (state_40005[(2)]);
var state_40005__$1 = state_40005;
var statearr_40065_40209 = state_40005__$1;
(statearr_40065_40209[(2)] = inst_39957);

(statearr_40065_40209[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (89))){
var inst_39976 = (state_40005[(15)]);
var inst_39981 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39982 = [inst_39976];
var inst_39983 = (new cljs.core.PersistentVector(null,1,(5),inst_39981,inst_39982,null));
var state_40005__$1 = state_40005;
var statearr_40066_40210 = state_40005__$1;
(statearr_40066_40210[(2)] = inst_39983);

(statearr_40066_40210[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (43))){
var inst_39877 = (state_40005[(18)]);
var inst_39880 = cljs.core.seq(inst_39877);
var state_40005__$1 = state_40005;
var statearr_40067_40211 = state_40005__$1;
(statearr_40067_40211[(2)] = inst_39880);

(statearr_40067_40211[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (61))){
var state_40005__$1 = state_40005;
var statearr_40068_40212 = state_40005__$1;
(statearr_40068_40212[(2)] = (0));

(statearr_40068_40212[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (29))){
var inst_39858 = (state_40005[(2)]);
var state_40005__$1 = state_40005;
if(cljs.core.truth_(inst_39858)){
var statearr_40069_40213 = state_40005__$1;
(statearr_40069_40213[(1)] = (30));

} else {
var statearr_40070_40214 = state_40005__$1;
(statearr_40070_40214[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (44))){
var inst_39878 = (state_40005[(33)]);
var state_40005__$1 = state_40005;
var statearr_40071_40215 = state_40005__$1;
(statearr_40071_40215[(2)] = inst_39878);

(statearr_40071_40215[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (93))){
var state_40005__$1 = state_40005;
var statearr_40072_40216 = state_40005__$1;
(statearr_40072_40216[(1)] = (95));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (6))){
var inst_39771 = (state_40005[(34)]);
var inst_39771__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_39773 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_40005__$1 = (function (){var statearr_40074 = state_40005;
(statearr_40074[(34)] = inst_39771__$1);

(statearr_40074[(35)] = inst_39773);

return statearr_40074;
})();
if(cljs.core.truth_(inst_39771__$1)){
var statearr_40075_40217 = state_40005__$1;
(statearr_40075_40217[(1)] = (9));

} else {
var statearr_40076_40218 = state_40005__$1;
(statearr_40076_40218[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (28))){
var inst_39831 = (state_40005[(11)]);
var state_40005__$1 = state_40005;
var statearr_40077_40219 = state_40005__$1;
(statearr_40077_40219[(2)] = inst_39831);

(statearr_40077_40219[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (64))){
var inst_39832 = (state_40005[(12)]);
var inst_39913 = (inst_39832 - (1));
var state_40005__$1 = state_40005;
var statearr_40078_40220 = state_40005__$1;
(statearr_40078_40220[(2)] = inst_39913);

(statearr_40078_40220[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (51))){
var inst_39831 = (state_40005[(11)]);
var inst_39891 = (state_40005[(2)]);
var state_40005__$1 = (function (){var statearr_40079 = state_40005;
(statearr_40079[(14)] = inst_39891);

return statearr_40079;
})();
if(cljs.core.truth_(inst_39831)){
var statearr_40080_40221 = state_40005__$1;
(statearr_40080_40221[(1)] = (52));

} else {
var statearr_40081_40222 = state_40005__$1;
(statearr_40081_40222[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (25))){
var inst_39831 = (state_40005[(11)]);
var state_40005__$1 = state_40005;
if(cljs.core.truth_(inst_39831)){
var statearr_40082_40223 = state_40005__$1;
(statearr_40082_40223[(1)] = (27));

} else {
var statearr_40083_40224 = state_40005__$1;
(statearr_40083_40224[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (34))){
var state_40005__$1 = state_40005;
var statearr_40084_40225 = state_40005__$1;
(statearr_40084_40225[(1)] = (39));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (17))){
var state_40005__$1 = state_40005;
var statearr_40086_40226 = state_40005__$1;
(statearr_40086_40226[(2)] = limit);

(statearr_40086_40226[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (3))){
var inst_40003 = (state_40005[(2)]);
var state_40005__$1 = state_40005;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40005__$1,inst_40003);
} else {
if((state_val_40006 === (12))){
var inst_39779 = (state_40005[(28)]);
var inst_39781 = cljs.core.keys(inst_39779);
var inst_39782 = cljs.core.first(inst_39781);
var inst_39783 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_39784 = cljs.core.vals(inst_39779);
var inst_39785 = cljs.core.first(inst_39784);
var inst_39786 = [headers,vars,inst_39785];
var inst_39787 = cljs.core.PersistentHashMap.fromArrays(inst_39783,inst_39786);
var inst_39788 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,inst_39787,select_spec,limit,opts);
var state_40005__$1 = (function (){var statearr_40087 = state_40005;
(statearr_40087[(17)] = inst_39782);

return statearr_40087;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40005__$1,(15),inst_39788);
} else {
if((state_val_40006 === (2))){
var _ = (function (){var statearr_40088 = state_40005;
(statearr_40088[(4)] = cljs.core.cons((5),(state_40005[(4)])));

return statearr_40088;
})();
var state_40005__$1 = state_40005;
if(cljs.core.truth_(groupBy)){
var statearr_40089_40227 = state_40005__$1;
(statearr_40089_40227[(1)] = (6));

} else {
var statearr_40090_40228 = state_40005__$1;
(statearr_40090_40228[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (66))){
var inst_39923 = (state_40005[(2)]);
var state_40005__$1 = state_40005;
var statearr_40091_40229 = state_40005__$1;
(statearr_40091_40229[(2)] = inst_39923);

(statearr_40091_40229[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (23))){
var inst_39965 = (state_40005[(2)]);
var state_40005__$1 = state_40005;
var statearr_40092_40230 = state_40005__$1;
(statearr_40092_40230[(2)] = inst_39965);

(statearr_40092_40230[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (47))){
var inst_39831 = (state_40005[(11)]);
var inst_39939 = (inst_39831 == null);
var state_40005__$1 = state_40005;
if(cljs.core.truth_(inst_39939)){
var statearr_40093_40231 = state_40005__$1;
(statearr_40093_40231[(1)] = (76));

} else {
var statearr_40094_40232 = state_40005__$1;
(statearr_40094_40232[(1)] = (77));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (35))){
var inst_39959 = (state_40005[(2)]);
var state_40005__$1 = state_40005;
var statearr_40095_40233 = state_40005__$1;
(statearr_40095_40233[(2)] = inst_39959);

(statearr_40095_40233[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (82))){
var state_40005__$1 = state_40005;
var statearr_40096_40234 = state_40005__$1;
(statearr_40096_40234[(2)] = (1));

(statearr_40096_40234[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (76))){
var state_40005__$1 = state_40005;
var statearr_40097_40235 = state_40005__$1;
(statearr_40097_40235[(2)] = null);

(statearr_40097_40235[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (97))){
var inst_39994 = (state_40005[(2)]);
var state_40005__$1 = state_40005;
var statearr_40098_40236 = state_40005__$1;
(statearr_40098_40236[(2)] = inst_39994);

(statearr_40098_40236[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (19))){
var inst_39823 = (state_40005[(36)]);
var state_40005__$1 = state_40005;
var statearr_40099_40237 = state_40005__$1;
(statearr_40099_40237[(2)] = inst_39823);

(statearr_40099_40237[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (57))){
var inst_39831 = (state_40005[(11)]);
var inst_39901 = (state_40005[(2)]);
var inst_39902 = (inst_39831 == null);
var state_40005__$1 = (function (){var statearr_40100 = state_40005;
(statearr_40100[(10)] = inst_39901);

return statearr_40100;
})();
if(cljs.core.truth_(inst_39902)){
var statearr_40101_40238 = state_40005__$1;
(statearr_40101_40238[(1)] = (58));

} else {
var statearr_40102_40239 = state_40005__$1;
(statearr_40102_40239[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (68))){
var state_40005__$1 = state_40005;
var statearr_40103_40240 = state_40005__$1;
(statearr_40103_40240[(2)] = null);

(statearr_40103_40240[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (11))){
var inst_39779 = (state_40005[(2)]);
var state_40005__$1 = (function (){var statearr_40105 = state_40005;
(statearr_40105[(28)] = inst_39779);

return statearr_40105;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_40106_40241 = state_40005__$1;
(statearr_40106_40241[(1)] = (12));

} else {
var statearr_40107_40242 = state_40005__$1;
(statearr_40107_40242[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (9))){
var inst_39771 = (state_40005[(34)]);
var inst_39773 = (state_40005[(35)]);
var inst_39775 = cljs.core.sorted_map_by(inst_39771);
var inst_39776 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39775,inst_39773);
var state_40005__$1 = state_40005;
var statearr_40108_40243 = state_40005__$1;
(statearr_40108_40243[(2)] = inst_39776);

(statearr_40108_40243[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (5))){
var _ = (function (){var statearr_40109 = state_40005;
(statearr_40109[(4)] = cljs.core.rest((state_40005[(4)])));

return statearr_40109;
})();
var state_40005__$1 = state_40005;
var ex40104 = (state_40005__$1[(2)]);
var statearr_40110_40244 = state_40005__$1;
(statearr_40110_40244[(5)] = ex40104);


if((ex40104 instanceof Error)){
var statearr_40111_40245 = state_40005__$1;
(statearr_40111_40245[(1)] = (4));

(statearr_40111_40245[(5)] = null);

} else {
throw ex40104;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (83))){
var state_40005__$1 = state_40005;
var statearr_40112_40246 = state_40005__$1;
(statearr_40112_40246[(2)] = limit);

(statearr_40112_40246[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (14))){
var inst_39967 = (state_40005[(2)]);
var state_40005__$1 = state_40005;
var statearr_40113_40247 = state_40005__$1;
(statearr_40113_40247[(2)] = inst_39967);

(statearr_40113_40247[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (45))){
var inst_39883 = (state_40005[(2)]);
var state_40005__$1 = state_40005;
if(cljs.core.truth_(inst_39883)){
var statearr_40114_40248 = state_40005__$1;
(statearr_40114_40248[(1)] = (46));

} else {
var statearr_40115_40249 = state_40005__$1;
(statearr_40115_40249[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (53))){
var inst_39831 = (state_40005[(11)]);
var state_40005__$1 = state_40005;
var statearr_40116_40250 = state_40005__$1;
(statearr_40116_40250[(2)] = inst_39831);

(statearr_40116_40250[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (78))){
var inst_39832 = (state_40005[(12)]);
var inst_39944 = (state_40005[(2)]);
var inst_39945 = (inst_39832 <= (0));
var state_40005__$1 = (function (){var statearr_40117 = state_40005;
(statearr_40117[(37)] = inst_39944);

return statearr_40117;
})();
if(cljs.core.truth_(inst_39945)){
var statearr_40118_40251 = state_40005__$1;
(statearr_40118_40251[(1)] = (79));

} else {
var statearr_40119_40252 = state_40005__$1;
(statearr_40119_40252[(1)] = (80));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (26))){
var inst_39963 = (state_40005[(2)]);
var state_40005__$1 = state_40005;
var statearr_40120_40253 = state_40005__$1;
(statearr_40120_40253[(2)] = inst_39963);

(statearr_40120_40253[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (16))){
var state_40005__$1 = state_40005;
var statearr_40121_40254 = state_40005__$1;
(statearr_40121_40254[(2)] = null);

(statearr_40121_40254[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (81))){
var inst_39846 = (state_40005[(19)]);
var inst_39842 = (state_40005[(8)]);
var inst_39944 = (state_40005[(37)]);
var inst_39877 = (state_40005[(18)]);
var inst_39833 = (state_40005[(9)]);
var inst_39843 = (state_40005[(21)]);
var inst_39950 = (state_40005[(2)]);
var inst_39951 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39833,inst_39842,inst_39877);
var inst_39829 = inst_39843;
var inst_39830 = inst_39846;
var inst_39831 = inst_39944;
var inst_39832 = inst_39950;
var inst_39833__$1 = inst_39951;
var state_40005__$1 = (function (){var statearr_40124 = state_40005;
(statearr_40124[(22)] = inst_39830);

(statearr_40124[(11)] = inst_39831);

(statearr_40124[(12)] = inst_39832);

(statearr_40124[(9)] = inst_39833__$1);

(statearr_40124[(23)] = inst_39829);

return statearr_40124;
})();
var statearr_40125_40255 = state_40005__$1;
(statearr_40125_40255[(2)] = null);

(statearr_40125_40255[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (79))){
var state_40005__$1 = state_40005;
var statearr_40126_40256 = state_40005__$1;
(statearr_40126_40256[(2)] = (0));

(statearr_40126_40256[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (38))){
var inst_39846 = (state_40005[(19)]);
var inst_39831 = (state_40005[(11)]);
var inst_39833 = (state_40005[(9)]);
var inst_39843 = (state_40005[(21)]);
var inst_39868 = (state_40005[(2)]);
var tmp40122 = inst_39831;
var tmp40123 = inst_39833;
var inst_39829 = inst_39843;
var inst_39830 = inst_39846;
var inst_39831__$1 = tmp40122;
var inst_39832 = inst_39868;
var inst_39833__$1 = tmp40123;
var state_40005__$1 = (function (){var statearr_40127 = state_40005;
(statearr_40127[(22)] = inst_39830);

(statearr_40127[(11)] = inst_39831__$1);

(statearr_40127[(12)] = inst_39832);

(statearr_40127[(9)] = inst_39833__$1);

(statearr_40127[(23)] = inst_39829);

return statearr_40127;
})();
var statearr_40128_40257 = state_40005__$1;
(statearr_40128_40257[(2)] = null);

(statearr_40128_40257[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (87))){
var state_40005__$1 = state_40005;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_40129_40258 = state_40005__$1;
(statearr_40129_40258[(1)] = (92));

} else {
var statearr_40130_40259 = state_40005__$1;
(statearr_40130_40259[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (30))){
var inst_39833 = (state_40005[(9)]);
var state_40005__$1 = state_40005;
var statearr_40131_40260 = state_40005__$1;
(statearr_40131_40260[(2)] = inst_39833);

(statearr_40131_40260[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (73))){
var inst_39833 = (state_40005[(9)]);
var state_40005__$1 = state_40005;
var statearr_40132_40261 = state_40005__$1;
(statearr_40132_40261[(2)] = inst_39833);

(statearr_40132_40261[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (96))){
var state_40005__$1 = state_40005;
var statearr_40133_40262 = state_40005__$1;
(statearr_40133_40262[(2)] = null);

(statearr_40133_40262[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (10))){
var inst_39773 = (state_40005[(35)]);
var state_40005__$1 = state_40005;
var statearr_40134_40263 = state_40005__$1;
(statearr_40134_40263[(2)] = inst_39773);

(statearr_40134_40263[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (18))){
var inst_39823 = (state_40005[(36)]);
var inst_39822 = (state_40005[(2)]);
var inst_39823__$1 = offset;
var state_40005__$1 = (function (){var statearr_40135 = state_40005;
(statearr_40135[(24)] = inst_39822);

(statearr_40135[(36)] = inst_39823__$1);

return statearr_40135;
})();
if(cljs.core.truth_(inst_39823__$1)){
var statearr_40136_40264 = state_40005__$1;
(statearr_40136_40264[(1)] = (19));

} else {
var statearr_40137_40265 = state_40005__$1;
(statearr_40137_40265[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (52))){
var inst_39831 = (state_40005[(11)]);
var inst_39893 = ((0) < inst_39831);
var state_40005__$1 = state_40005;
var statearr_40138_40266 = state_40005__$1;
(statearr_40138_40266[(2)] = inst_39893);

(statearr_40138_40266[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (67))){
var inst_39847 = (state_40005[(27)]);
var inst_39832 = (state_40005[(12)]);
var inst_39901 = (state_40005[(10)]);
var inst_39916 = cljs.core.count(inst_39901);
var inst_39917 = (inst_39847 - inst_39916);
var inst_39918 = (inst_39832 - inst_39917);
var state_40005__$1 = state_40005;
var statearr_40139_40267 = state_40005__$1;
(statearr_40139_40267[(2)] = inst_39918);

(statearr_40139_40267[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (71))){
var inst_39901 = (state_40005[(10)]);
var inst_39929 = cljs.core.empty_QMARK_(inst_39901);
var state_40005__$1 = state_40005;
var statearr_40140_40268 = state_40005__$1;
(statearr_40140_40268[(2)] = inst_39929);

(statearr_40140_40268[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (42))){
var inst_39877 = (state_40005[(18)]);
var inst_39878 = (state_40005[(33)]);
var inst_39876 = (state_40005[(2)]);
var inst_39877__$1 = fluree.db.util.async.throw_err(inst_39876);
var inst_39878__$1 = cljs.core.coll_QMARK_(inst_39877__$1);
var state_40005__$1 = (function (){var statearr_40141 = state_40005;
(statearr_40141[(18)] = inst_39877__$1);

(statearr_40141[(33)] = inst_39878__$1);

return statearr_40141;
})();
if(inst_39878__$1){
var statearr_40142_40269 = state_40005__$1;
(statearr_40142_40269[(1)] = (43));

} else {
var statearr_40143_40270 = state_40005__$1;
(statearr_40143_40270[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (80))){
var inst_39832 = (state_40005[(12)]);
var inst_39948 = (inst_39832 - (1));
var state_40005__$1 = state_40005;
var statearr_40144_40271 = state_40005__$1;
(statearr_40144_40271[(2)] = inst_39948);

(statearr_40144_40271[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (37))){
var inst_39847 = (state_40005[(27)]);
var inst_39832 = (state_40005[(12)]);
var inst_39866 = (inst_39832 - inst_39847);
var state_40005__$1 = state_40005;
var statearr_40145_40272 = state_40005__$1;
(statearr_40145_40272[(2)] = inst_39866);

(statearr_40145_40272[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (63))){
var inst_39926 = (state_40005[(7)]);
var inst_39901 = (state_40005[(10)]);
var inst_39925 = (state_40005[(2)]);
var inst_39926__$1 = (inst_39901 == null);
var state_40005__$1 = (function (){var statearr_40146 = state_40005;
(statearr_40146[(20)] = inst_39925);

(statearr_40146[(7)] = inst_39926__$1);

return statearr_40146;
})();
if(cljs.core.truth_(inst_39926__$1)){
var statearr_40147_40273 = state_40005__$1;
(statearr_40147_40273[(1)] = (70));

} else {
var statearr_40148_40274 = state_40005__$1;
(statearr_40148_40274[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (94))){
var inst_39996 = (state_40005[(2)]);
var state_40005__$1 = state_40005;
var statearr_40149_40275 = state_40005__$1;
(statearr_40149_40275[(2)] = inst_39996);

(statearr_40149_40275[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (8))){
var inst_40000 = (state_40005[(2)]);
var _ = (function (){var statearr_40150 = state_40005;
(statearr_40150[(4)] = cljs.core.rest((state_40005[(4)])));

return statearr_40150;
})();
var state_40005__$1 = state_40005;
var statearr_40151_40276 = state_40005__$1;
(statearr_40151_40276[(2)] = inst_40000);

(statearr_40151_40276[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (49))){
var inst_39877 = (state_40005[(18)]);
var inst_39832 = (state_40005[(12)]);
var inst_39888 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_39832,inst_39877);
var state_40005__$1 = state_40005;
var statearr_40152_40277 = state_40005__$1;
(statearr_40152_40277[(2)] = inst_39888);

(statearr_40152_40277[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40006 === (84))){
var inst_39972 = (state_40005[(2)]);
var inst_39973 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_39972,opts);
var state_40005__$1 = state_40005;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40005__$1,(85),inst_39973);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__15091__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__15091__auto____0 = (function (){
var statearr_40153 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40153[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__15091__auto__);

(statearr_40153[(1)] = (1));

return statearr_40153;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__15091__auto____1 = (function (state_40005){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_40005);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e40154){var ex__15094__auto__ = e40154;
var statearr_40155_40278 = state_40005;
(statearr_40155_40278[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_40005[(4)]))){
var statearr_40156_40279 = state_40005;
(statearr_40156_40279[(1)] = cljs.core.first((state_40005[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__40280 = state_40005;
state_40005 = G__40280;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__15091__auto__ = function(state_40005){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__15091__auto____1.call(this,state_40005);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__15091__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__15091__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_40157 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_40157[(6)] = c__15165__auto__);

return statearr_40157;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__40283,opts){
var map__40284 = p__40283;
var map__40284__$1 = cljs.core.__destructure_map(map__40284);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40284__$1,cljs.core.cst$kw$selectOne);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40284__$1,cljs.core.cst$kw$select);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40284__$1,cljs.core.cst$kw$selectDistinct);
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40284__$1,cljs.core.cst$kw$selectReduced);
var select_smt = (function (){var or__5045__auto__ = selectOne;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = select;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
var or__5045__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__5045__auto____$2)){
return or__5045__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__40281_SHARP_){
return cljs.core.contains_QMARK_(p1__40281_SHARP_,cljs.core.cst$kw$code);
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__40282_SHARP_){
return cljs.core.contains_QMARK_(p1__40282_SHARP_,cljs.core.cst$kw$selection);
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5804__auto__ = cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5804__auto__)){
var orderBy = temp__5804__auto__;
if(cljs.core.truth_((function (){var or__5045__auto__ = typeof orderBy === 'string';
if(or__5045__auto__){
return or__5045__auto__;
} else {
var and__5043__auto__ = cljs.core.vector_QMARK_(orderBy);
if(and__5043__auto__){
var G__40286 = cljs.core.first(orderBy);
var fexpr__40285 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__40285.cljs$core$IFn$_invoke$arity$1 ? fexpr__40285.cljs$core$IFn$_invoke$arity$1(G__40286) : fexpr__40285.call(null,G__40286));
} else {
return and__5043__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$expandMaps_QMARK_,cljs.core.cst$kw$limit,cljs.core.cst$kw$offset,cljs.core.cst$kw$aggregates,cljs.core.cst$kw$selectOne_QMARK_,cljs.core.cst$kw$prettyPrint,cljs.core.cst$kw$groupBy,cljs.core.cst$kw$selectDistinct_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$inVector_QMARK_],[expandMap_QMARK_,(function (){var or__5045__auto__ = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (100);
}
})(),(function (){var or__5045__auto__ = cljs.core.cst$kw$offset.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__5045__auto__ = cljs.core.cst$kw$prettyPrint.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return false;
}
})(),cljs.core.cst$kw$groupBy.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__5045__auto__ = selectDistinct;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__40287,p__40288){
var map__40289 = p__40287;
var map__40289__$1 = cljs.core.__destructure_map(map__40289);
var query_map = map__40289__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40289__$1,cljs.core.cst$kw$construct);
var map__40290 = p__40288;
var map__40290__$1 = cljs.core.__destructure_map(map__40290);
var where_result = map__40290__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40290__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40290__$1,cljs.core.cst$kw$tuples);
var vec__40291 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5802__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5802__auto__)){
var index_of = temp__5802__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40291,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40291,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40291,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_40324){
var state_val_40325 = (state_40324[(1)]);
if((state_val_40325 === (7))){
var inst_40303 = (state_40324[(7)]);
var state_40324__$1 = state_40324;
var statearr_40326_40349 = state_40324__$1;
(statearr_40326_40349[(2)] = inst_40303);

(statearr_40326_40349[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40325 === (1))){
var state_40324__$1 = state_40324;
var statearr_40327_40350 = state_40324__$1;
(statearr_40327_40350[(2)] = null);

(statearr_40327_40350[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40325 === (4))){
var inst_40294 = (state_40324[(2)]);
var state_40324__$1 = state_40324;
var statearr_40328_40351 = state_40324__$1;
(statearr_40328_40351[(2)] = inst_40294);

(statearr_40328_40351[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40325 === (13))){
var inst_40313 = (state_40324[(2)]);
var inst_40314 = fluree.db.util.async.throw_err(inst_40313);
var state_40324__$1 = state_40324;
var statearr_40329_40352 = state_40324__$1;
(statearr_40329_40352[(2)] = inst_40314);

(statearr_40329_40352[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40325 === (6))){
var inst_40303 = (state_40324[(7)]);
var inst_40302 = (state_40324[(2)]);
var inst_40303__$1 = fluree.db.util.async.throw_err(inst_40302);
var inst_40304 = fluree.db.util.core.exception_QMARK_(inst_40303__$1);
var state_40324__$1 = (function (){var statearr_40330 = state_40324;
(statearr_40330[(7)] = inst_40303__$1);

return statearr_40330;
})();
if(inst_40304){
var statearr_40331_40353 = state_40324__$1;
(statearr_40331_40353[(1)] = (7));

} else {
var statearr_40332_40354 = state_40324__$1;
(statearr_40332_40354[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40325 === (3))){
var inst_40322 = (state_40324[(2)]);
var state_40324__$1 = state_40324;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40324__$1,inst_40322);
} else {
if((state_val_40325 === (12))){
var inst_40317 = (state_40324[(2)]);
var state_40324__$1 = state_40324;
var statearr_40333_40355 = state_40324__$1;
(statearr_40333_40355[(2)] = inst_40317);

(statearr_40333_40355[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40325 === (2))){
var _ = (function (){var statearr_40334 = state_40324;
(statearr_40334[(4)] = cljs.core.cons((5),(state_40324[(4)])));

return statearr_40334;
})();
var inst_40300 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_40324__$1 = state_40324;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40324__$1,(6),inst_40300);
} else {
if((state_val_40325 === (11))){
var state_40324__$1 = state_40324;
var statearr_40336_40356 = state_40324__$1;
(statearr_40336_40356[(2)] = null);

(statearr_40336_40356[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40325 === (9))){
var inst_40319 = (state_40324[(2)]);
var _ = (function (){var statearr_40337 = state_40324;
(statearr_40337[(4)] = cljs.core.rest((state_40324[(4)])));

return statearr_40337;
})();
var state_40324__$1 = state_40324;
var statearr_40338_40357 = state_40324__$1;
(statearr_40338_40357[(2)] = inst_40319);

(statearr_40338_40357[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40325 === (5))){
var _ = (function (){var statearr_40339 = state_40324;
(statearr_40339[(4)] = cljs.core.rest((state_40324[(4)])));

return statearr_40339;
})();
var state_40324__$1 = state_40324;
var ex40335 = (state_40324__$1[(2)]);
var statearr_40340_40358 = state_40324__$1;
(statearr_40340_40358[(5)] = ex40335);


if((ex40335 instanceof Error)){
var statearr_40341_40359 = state_40324__$1;
(statearr_40341_40359[(1)] = (4));

(statearr_40341_40359[(5)] = null);

} else {
throw ex40335;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40325 === (10))){
var inst_40303 = (state_40324[(7)]);
var inst_40308 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_40303);
var inst_40309 = cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(inst_40303);
var inst_40310 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_40308,inst_40309,query_map,opts);
var inst_40311 = fluree.db.query.fql.process_ad_hoc_res(db,fuel,max_fuel,inst_40303,inst_40310,opts);
var state_40324__$1 = state_40324;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40324__$1,(13),inst_40311);
} else {
if((state_val_40325 === (8))){
var state_40324__$1 = state_40324;
var statearr_40342_40360 = state_40324__$1;
(statearr_40342_40360[(1)] = (10));



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__15091__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__15091__auto____0 = (function (){
var statearr_40344 = [null,null,null,null,null,null,null,null];
(statearr_40344[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__15091__auto__);

(statearr_40344[(1)] = (1));

return statearr_40344;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__15091__auto____1 = (function (state_40324){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_40324);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e40345){var ex__15094__auto__ = e40345;
var statearr_40346_40361 = state_40324;
(statearr_40346_40361[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_40324[(4)]))){
var statearr_40347_40362 = state_40324;
(statearr_40347_40362[(1)] = cljs.core.first((state_40324[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__40363 = state_40324;
state_40324 = G__40363;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__15091__auto__ = function(state_40324){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__15091__auto____1.call(this,state_40324);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__15091__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__15091__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_40348 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_40348[(6)] = c__15165__auto__);

return statearr_40348;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Running query:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0))], 0));

var map__40364 = query_map;
var map__40364__$1 = cljs.core.__destructure_map(map__40364);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40364__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40364__$1,cljs.core.cst$kw$orderBy);
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40364__$1,cljs.core.cst$kw$where);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40364__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40364__$1,cljs.core.cst$kw$offset);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40364__$1,cljs.core.cst$kw$component);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40364__$1,cljs.core.cst$kw$selectDistinct);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40364__$1,cljs.core.cst$kw$prettyPrint);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40364__$1,cljs.core.cst$kw$selectOne);
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40364__$1,cljs.core.cst$kw$from);
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40364__$1,cljs.core.cst$kw$opts);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40364__$1,cljs.core.cst$kw$groupBy);
var opts_SINGLEQUOTE_ = (function (){var G__40365 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$limit,limit,cljs.core.cst$kw$offset,(function (){var or__5045__auto__ = offset;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})(),cljs.core.cst$kw$component,component,cljs.core.cst$kw$orderBy,orderBy,cljs.core.cst$kw$groupBy,groupBy,cljs.core.cst$kw$prettyPrint,prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__40365,cljs.core.cst$kw$limit,(1));
} else {
return G__40365;
}
})();
var max_fuel = cljs.core.cst$kw$max_DASH_fuel.cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__5045__auto__ = cljs.core.cst$kw$fuel.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.truth_((function (){var or__5045__auto____$1 = max_fuel;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_40723){
var state_val_40724 = (state_40723[(1)]);
if((state_val_40724 === (121))){
var inst_40684 = (state_40723[(2)]);
var state_40723__$1 = state_40723;
var statearr_40725_40920 = state_40723__$1;
(statearr_40725_40920[(2)] = inst_40684);

(statearr_40725_40920[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (65))){
var inst_40561 = typeof from === 'string';
var state_40723__$1 = state_40723;
if(cljs.core.truth_(inst_40561)){
var statearr_40726_40921 = state_40723__$1;
(statearr_40726_40921[(1)] = (72));

} else {
var statearr_40727_40922 = state_40723__$1;
(statearr_40727_40922[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (70))){
var inst_40427 = (state_40723[(7)]);
var inst_40429 = (state_40723[(8)]);
var inst_40554 = (state_40723[(2)]);
var inst_40555 = fluree.db.util.async.throw_err(inst_40554);
var inst_40556 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_40429,fuel,max_fuel,inst_40427,inst_40555);
var state_40723__$1 = state_40723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40723__$1,(71),inst_40556);
} else {
if((state_val_40724 === (62))){
var inst_40534 = (state_40723[(9)]);
var state_40723__$1 = state_40723;
var statearr_40728_40923 = state_40723__$1;
(statearr_40728_40923[(2)] = inst_40534);

(statearr_40728_40923[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (74))){
var inst_40690 = (state_40723[(2)]);
var state_40723__$1 = state_40723;
var statearr_40729_40924 = state_40723__$1;
(statearr_40729_40924[(2)] = inst_40690);

(statearr_40729_40924[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (110))){
var inst_40625 = (state_40723[(10)]);
var state_40723__$1 = state_40723;
var statearr_40730_40925 = state_40723__$1;
(statearr_40730_40925[(2)] = inst_40625);

(statearr_40730_40925[(1)] = (111));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (130))){
var inst_40710 = (state_40723[(2)]);
var state_40723__$1 = state_40723;
var statearr_40731_40926 = state_40723__$1;
(statearr_40731_40926[(2)] = inst_40710);

(statearr_40731_40926[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (128))){
var inst_40701 = (state_40723[(11)]);
var inst_40706 = fluree.db.util.core.exception_QMARK_(inst_40701);
var inst_40707 = (!(inst_40706));
var state_40723__$1 = state_40723;
var statearr_40732_40927 = state_40723__$1;
(statearr_40732_40927[(2)] = inst_40707);

(statearr_40732_40927[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (7))){
var inst_40397 = (state_40723[(12)]);
var inst_40397__$1 = selectOne;
var state_40723__$1 = (function (){var statearr_40733 = state_40723;
(statearr_40733[(12)] = inst_40397__$1);

return statearr_40733;
})();
if(cljs.core.truth_(inst_40397__$1)){
var statearr_40734_40928 = state_40723__$1;
(statearr_40734_40928[(1)] = (9));

} else {
var statearr_40735_40929 = state_40723__$1;
(statearr_40735_40929[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (59))){
var inst_40427 = (state_40723[(7)]);
var inst_40417 = (state_40723[(13)]);
var inst_40429 = (state_40723[(8)]);
var inst_40512 = (state_40723[(14)]);
var inst_40526 = (state_40723[(2)]);
var inst_40527 = fluree.db.util.async.throw_err(inst_40526);
var inst_40528 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_40512,inst_40527);
var inst_40529 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_40429,fuel,max_fuel,inst_40427,inst_40528,inst_40417);
var state_40723__$1 = state_40723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40723__$1,(60),inst_40529);
} else {
if((state_val_40724 === (86))){
var inst_40427 = (state_40723[(7)]);
var inst_40417 = (state_40723[(13)]);
var inst_40429 = (state_40723[(8)]);
var inst_40419 = (state_40723[(15)]);
var inst_40594 = (state_40723[(2)]);
var inst_40595 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_40429,fuel,max_fuel,inst_40427,inst_40594,inst_40417,inst_40419);
var state_40723__$1 = state_40723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40723__$1,(87),inst_40595);
} else {
if((state_val_40724 === (20))){
var inst_40461 = (state_40723[(2)]);
var inst_40462 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40461,(0),null);
var inst_40463 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40461,(1),null);
var inst_40464 = typeof where === 'string';
var state_40723__$1 = (function (){var statearr_40736 = state_40723;
(statearr_40736[(16)] = inst_40462);

(statearr_40736[(17)] = inst_40463);

return statearr_40736;
})();
if(cljs.core.truth_(inst_40464)){
var statearr_40737_40930 = state_40723__$1;
(statearr_40737_40930[(1)] = (30));

} else {
var statearr_40738_40931 = state_40723__$1;
(statearr_40738_40931[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (72))){
var inst_40416 = (state_40723[(18)]);
var state_40723__$1 = state_40723;
if(cljs.core.truth_(inst_40416)){
var statearr_40739_40932 = state_40723__$1;
(statearr_40739_40932[(1)] = (75));

} else {
var statearr_40740_40933 = state_40723__$1;
(statearr_40740_40933[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (58))){
var inst_40520 = (state_40723[(2)]);
var inst_40521 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40522 = [from];
var inst_40523 = (new cljs.core.PersistentVector(null,1,(5),inst_40521,inst_40522,null));
var inst_40524 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_40523,inst_40520);
var state_40723__$1 = state_40723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40723__$1,(59),inst_40524);
} else {
if((state_val_40724 === (60))){
var inst_40531 = (state_40723[(2)]);
var inst_40532 = fluree.db.util.async.throw_err(inst_40531);
var state_40723__$1 = state_40723;
var statearr_40741_40934 = state_40723__$1;
(statearr_40741_40934[(2)] = inst_40532);

(statearr_40741_40934[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (27))){
var inst_40446 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40447 = [null,null];
var inst_40448 = (new cljs.core.PersistentVector(null,2,(5),inst_40446,inst_40447,null));
var state_40723__$1 = state_40723;
var statearr_40742_40935 = state_40723__$1;
(statearr_40742_40935[(2)] = inst_40448);

(statearr_40742_40935[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (1))){
var state_40723__$1 = state_40723;
var statearr_40743_40936 = state_40723__$1;
(statearr_40743_40936[(2)] = null);

(statearr_40743_40936[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (69))){
var inst_40551 = (state_40723[(2)]);
var inst_40552 = fluree.db.query.range._block_or_tx_collection(db,inst_40551);
var state_40723__$1 = state_40723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40723__$1,(70),inst_40552);
} else {
if((state_val_40724 === (101))){
var inst_40657 = (state_40723[(2)]);
var state_40723__$1 = state_40723;
var statearr_40744_40937 = state_40723__$1;
(statearr_40744_40937[(2)] = inst_40657);

(statearr_40744_40937[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (24))){
var inst_40416 = (state_40723[(18)]);
var inst_40441 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40442 = [inst_40416,"ASC"];
var inst_40443 = (new cljs.core.PersistentVector(null,2,(5),inst_40441,inst_40442,null));
var state_40723__$1 = state_40723;
var statearr_40745_40938 = state_40723__$1;
(statearr_40745_40938[(2)] = inst_40443);

(statearr_40745_40938[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (102))){
var inst_40631 = (state_40723[(19)]);
var state_40723__$1 = state_40723;
var statearr_40746_40939 = state_40723__$1;
(statearr_40746_40939[(2)] = inst_40631);

(statearr_40746_40939[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (55))){
var inst_40416 = (state_40723[(18)]);
var inst_40512 = (state_40723[(2)]);
var state_40723__$1 = (function (){var statearr_40747 = state_40723;
(statearr_40747[(14)] = inst_40512);

return statearr_40747;
})();
if(cljs.core.truth_(inst_40416)){
var statearr_40748_40940 = state_40723__$1;
(statearr_40748_40940[(1)] = (56));

} else {
var statearr_40749_40941 = state_40723__$1;
(statearr_40749_40941[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (85))){
var inst_40586 = (state_40723[(20)]);
var inst_40590 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40591 = [inst_40586];
var inst_40592 = (new cljs.core.PersistentVector(null,1,(5),inst_40590,inst_40591,null));
var state_40723__$1 = state_40723;
var statearr_40750_40942 = state_40723__$1;
(statearr_40750_40942[(2)] = inst_40592);

(statearr_40750_40942[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (39))){
var inst_40417 = (state_40723[(13)]);
var state_40723__$1 = state_40723;
var statearr_40751_40943 = state_40723__$1;
(statearr_40751_40943[(2)] = inst_40417);

(statearr_40751_40943[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (88))){
var inst_40600 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_40723__$1 = state_40723;
var statearr_40752_40944 = state_40723__$1;
(statearr_40752_40944[(2)] = inst_40600);

(statearr_40752_40944[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (46))){
var inst_40497 = (state_40723[(2)]);
var state_40723__$1 = state_40723;
if(cljs.core.truth_(inst_40497)){
var statearr_40753_40945 = state_40723__$1;
(statearr_40753_40945[(1)] = (47));

} else {
var statearr_40754_40946 = state_40723__$1;
(statearr_40754_40946[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (4))){
var inst_40384 = (state_40723[(2)]);
var state_40723__$1 = state_40723;
var statearr_40755_40947 = state_40723__$1;
(statearr_40755_40947[(2)] = inst_40384);

(statearr_40755_40947[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (77))){
var inst_40570 = (state_40723[(2)]);
var inst_40571 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_40570);
var state_40723__$1 = state_40723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40723__$1,(78),inst_40571);
} else {
if((state_val_40724 === (106))){
var state_40723__$1 = state_40723;
var statearr_40756_40948 = state_40723__$1;
(statearr_40756_40948[(2)] = null);

(statearr_40756_40948[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (119))){
var inst_40676 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_40677 = ["Invalid 'from' in query:",inst_40676].join('');
var inst_40678 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_40679 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_40680 = cljs.core.PersistentHashMap.fromArrays(inst_40678,inst_40679);
var inst_40681 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40677,inst_40680);
var state_40723__$1 = state_40723;
var statearr_40757_40949 = state_40723__$1;
(statearr_40757_40949[(2)] = inst_40681);

(statearr_40757_40949[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (95))){
var state_40723__$1 = state_40723;
var statearr_40758_40950 = state_40723__$1;
(statearr_40758_40950[(1)] = (119));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (54))){
var inst_40506 = (state_40723[(21)]);
var state_40723__$1 = state_40723;
var statearr_40760_40951 = state_40723__$1;
(statearr_40760_40951[(2)] = inst_40506);

(statearr_40760_40951[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (92))){
var inst_40605 = (state_40723[(22)]);
var state_40723__$1 = state_40723;
var statearr_40761_40952 = state_40723__$1;
(statearr_40761_40952[(2)] = inst_40605);

(statearr_40761_40952[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (104))){
var inst_40649 = (state_40723[(23)]);
var inst_40649__$1 = (state_40723[(2)]);
var state_40723__$1 = (function (){var statearr_40762 = state_40723;
(statearr_40762[(23)] = inst_40649__$1);

return statearr_40762;
})();
if(cljs.core.truth_(inst_40649__$1)){
var statearr_40763_40953 = state_40723__$1;
(statearr_40763_40953[(1)] = (109));

} else {
var statearr_40764_40954 = state_40723__$1;
(statearr_40764_40954[(1)] = (110));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (15))){
var inst_40420 = (state_40723[(24)]);
var inst_40418 = (state_40723[(25)]);
var inst_40424 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40420,cljs.core.cst$kw$componentFollow_QMARK_,inst_40418);
var state_40723__$1 = state_40723;
var statearr_40765_40955 = state_40723__$1;
(statearr_40765_40955[(2)] = inst_40424);

(statearr_40765_40955[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (48))){
var inst_40534 = (state_40723[(9)]);
var inst_40534__$1 = typeof from === 'string';
var state_40723__$1 = (function (){var statearr_40766 = state_40723;
(statearr_40766[(9)] = inst_40534__$1);

return statearr_40766;
})();
if(cljs.core.truth_(inst_40534__$1)){
var statearr_40767_40956 = state_40723__$1;
(statearr_40767_40956[(1)] = (61));

} else {
var statearr_40768_40957 = state_40723__$1;
(statearr_40768_40957[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (50))){
var inst_40500 = (state_40723[(26)]);
var inst_40502 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_40503 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_40500,inst_40502);
var state_40723__$1 = state_40723;
var statearr_40769_40958 = state_40723__$1;
(statearr_40769_40958[(2)] = inst_40503);

(statearr_40769_40958[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (116))){
var state_40723__$1 = state_40723;
var statearr_40770_40959 = state_40723__$1;
(statearr_40770_40959[(2)] = null);

(statearr_40770_40959[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (75))){
var inst_40564 = cljs.core.PersistentHashMap.EMPTY;
var state_40723__$1 = state_40723;
var statearr_40771_40960 = state_40723__$1;
(statearr_40771_40960[(2)] = inst_40564);

(statearr_40771_40960[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (99))){
var inst_40625 = (state_40723[(10)]);
var state_40723__$1 = state_40723;
var statearr_40772_40961 = state_40723__$1;
(statearr_40772_40961[(2)] = inst_40625);

(statearr_40772_40961[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (21))){
var inst_40416 = (state_40723[(18)]);
var inst_40433 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40434 = cljs.core.second(inst_40416);
var inst_40435 = cljs.core.first(inst_40416);
var inst_40436 = [inst_40434,inst_40435];
var inst_40437 = (new cljs.core.PersistentVector(null,2,(5),inst_40433,inst_40436,null));
var state_40723__$1 = state_40723;
var statearr_40773_40962 = state_40723__$1;
(statearr_40773_40962[(2)] = inst_40437);

(statearr_40773_40962[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (31))){
var inst_40491 = (state_40723[(27)]);
var inst_40491__$1 = typeof from === 'string';
var state_40723__$1 = (function (){var statearr_40774 = state_40723;
(statearr_40774[(27)] = inst_40491__$1);

return statearr_40774;
})();
if(cljs.core.truth_(inst_40491__$1)){
var statearr_40775_40963 = state_40723__$1;
(statearr_40775_40963[(1)] = (44));

} else {
var statearr_40776_40964 = state_40723__$1;
(statearr_40776_40964[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (113))){
var state_40723__$1 = state_40723;
var statearr_40777_40965 = state_40723__$1;
(statearr_40777_40965[(2)] = null);

(statearr_40777_40965[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (32))){
var inst_40462 = (state_40723[(16)]);
var inst_40696 = (state_40723[(2)]);
var state_40723__$1 = (function (){var statearr_40778 = state_40723;
(statearr_40778[(28)] = inst_40696);

return statearr_40778;
})();
if(cljs.core.truth_(inst_40462)){
var statearr_40779_40966 = state_40723__$1;
(statearr_40779_40966[(1)] = (122));

} else {
var statearr_40780_40967 = state_40723__$1;
(statearr_40780_40967[(1)] = (123));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (40))){
var inst_40416 = (state_40723[(18)]);
var inst_40481 = (state_40723[(2)]);
var state_40723__$1 = (function (){var statearr_40781 = state_40723;
(statearr_40781[(29)] = inst_40481);

return statearr_40781;
})();
if(cljs.core.truth_(inst_40416)){
var statearr_40782_40968 = state_40723__$1;
(statearr_40782_40968[(1)] = (41));

} else {
var statearr_40783_40969 = state_40723__$1;
(statearr_40783_40969[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (129))){
var inst_40704 = (state_40723[(30)]);
var state_40723__$1 = state_40723;
var statearr_40784_40970 = state_40723__$1;
(statearr_40784_40970[(2)] = inst_40704);

(statearr_40784_40970[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (91))){
var inst_40607 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var state_40723__$1 = state_40723;
var statearr_40785_40971 = state_40723__$1;
(statearr_40785_40971[(2)] = inst_40607);

(statearr_40785_40971[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (117))){
var inst_40419 = (state_40723[(15)]);
var state_40723__$1 = state_40723;
var statearr_40786_40972 = state_40723__$1;
(statearr_40786_40972[(2)] = inst_40419);

(statearr_40786_40972[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (108))){
var inst_40646 = (state_40723[(2)]);
var inst_40647 = fluree.db.util.async.throw_err(inst_40646);
var state_40723__$1 = state_40723;
var statearr_40787_40973 = state_40723__$1;
(statearr_40787_40973[(2)] = inst_40647);

(statearr_40787_40973[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (56))){
var inst_40514 = cljs.core.PersistentHashMap.EMPTY;
var state_40723__$1 = state_40723;
var statearr_40788_40974 = state_40723__$1;
(statearr_40788_40974[(2)] = inst_40514);

(statearr_40788_40974[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (33))){
var state_40723__$1 = state_40723;
var statearr_40789_40975 = state_40723__$1;
(statearr_40789_40975[(2)] = from);

(statearr_40789_40975[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (13))){
var inst_40403 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_40404 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_40405 = cljs.core.PersistentHashMap.fromArrays(inst_40403,inst_40404);
var inst_40406 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_40405);
var inst_40407 = (function(){throw inst_40406})();
var state_40723__$1 = state_40723;
var statearr_40790_40976 = state_40723__$1;
(statearr_40790_40976[(2)] = inst_40407);

(statearr_40790_40976[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (22))){
var inst_40416 = (state_40723[(18)]);
var inst_40439 = typeof inst_40416 === 'string';
var state_40723__$1 = state_40723;
if(cljs.core.truth_(inst_40439)){
var statearr_40791_40977 = state_40723__$1;
(statearr_40791_40977[(1)] = (24));

} else {
var statearr_40792_40978 = state_40723__$1;
(statearr_40792_40978[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (90))){
var inst_40598 = (state_40723[(31)]);
var inst_40603 = (state_40723[(2)]);
var state_40723__$1 = (function (){var statearr_40793 = state_40723;
(statearr_40793[(32)] = inst_40603);

return statearr_40793;
})();
var statearr_40794_40979 = state_40723__$1;
(statearr_40794_40979[(2)] = inst_40598);

(statearr_40794_40979[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (109))){
var inst_40649 = (state_40723[(23)]);
var inst_40625 = (state_40723[(10)]);
var inst_40651 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40625,inst_40649);
var state_40723__$1 = state_40723;
var statearr_40795_40980 = state_40723__$1;
(statearr_40795_40980[(2)] = inst_40651);

(statearr_40795_40980[(1)] = (111));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (36))){
var inst_40416 = (state_40723[(18)]);
var inst_40476 = (state_40723[(2)]);
var inst_40477 = fluree.db.util.async.throw_err(inst_40476);
var state_40723__$1 = (function (){var statearr_40796 = state_40723;
(statearr_40796[(33)] = inst_40477);

return statearr_40796;
})();
if(cljs.core.truth_(inst_40416)){
var statearr_40797_40981 = state_40723__$1;
(statearr_40797_40981[(1)] = (38));

} else {
var statearr_40798_40982 = state_40723__$1;
(statearr_40798_40982[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (41))){
var state_40723__$1 = state_40723;
var statearr_40799_40983 = state_40723__$1;
(statearr_40799_40983[(2)] = null);

(statearr_40799_40983[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (118))){
var inst_40427 = (state_40723[(7)]);
var inst_40661 = (state_40723[(34)]);
var inst_40665 = (state_40723[(35)]);
var inst_40429 = (state_40723[(8)]);
var inst_40669 = (state_40723[(2)]);
var inst_40670 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_40429,fuel,max_fuel,inst_40427,inst_40661,inst_40665,inst_40669);
var state_40723__$1 = state_40723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40723__$1,(112),inst_40670);
} else {
if((state_val_40724 === (89))){
var state_40723__$1 = state_40723;
var statearr_40800_40984 = state_40723__$1;
(statearr_40800_40984[(2)] = null);

(statearr_40800_40984[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (100))){
var inst_40631 = (state_40723[(19)]);
var inst_40636 = cljs.core.int_QMARK_(inst_40631);
var state_40723__$1 = state_40723;
if(inst_40636){
var statearr_40801_40985 = state_40723__$1;
(statearr_40801_40985[(1)] = (102));

} else {
var statearr_40802_40986 = state_40723__$1;
(statearr_40802_40986[(1)] = (103));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (131))){
var inst_40701 = (state_40723[(11)]);
var inst_40715 = cljs.core.first(inst_40701);
var state_40723__$1 = state_40723;
var statearr_40803_40987 = state_40723__$1;
(statearr_40803_40987[(2)] = inst_40715);

(statearr_40803_40987[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (122))){
var inst_40696 = (state_40723[(28)]);
var inst_40462 = (state_40723[(16)]);
var inst_40417 = (state_40723[(13)]);
var inst_40463 = (state_40723[(17)]);
var inst_40419 = (state_40723[(15)]);
var inst_40698 = fluree.db.query.fql.sort_offset_and_limit_res(inst_40462,inst_40463,inst_40419,inst_40417,inst_40696);
var state_40723__$1 = state_40723;
var statearr_40804_40988 = state_40723__$1;
(statearr_40804_40988[(2)] = inst_40698);

(statearr_40804_40988[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (43))){
var inst_40427 = (state_40723[(7)]);
var inst_40481 = (state_40723[(29)]);
var inst_40429 = (state_40723[(8)]);
var inst_40477 = (state_40723[(33)]);
var inst_40485 = (state_40723[(2)]);
var inst_40486 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_40429,fuel,max_fuel,inst_40427,inst_40477,inst_40481,inst_40485);
var state_40723__$1 = state_40723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40723__$1,(37),inst_40486);
} else {
if((state_val_40724 === (61))){
var inst_40536 = ["_tx",null,"_block",null];
var inst_40537 = (new cljs.core.PersistentArrayMap(null,2,inst_40536,null));
var inst_40538 = (new cljs.core.PersistentHashSet(null,inst_40537,null));
var inst_40539 = (inst_40538.cljs$core$IFn$_invoke$arity$1 ? inst_40538.cljs$core$IFn$_invoke$arity$1(from) : inst_40538.call(null,from));
var state_40723__$1 = state_40723;
var statearr_40805_40989 = state_40723__$1;
(statearr_40805_40989[(2)] = inst_40539);

(statearr_40805_40989[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (29))){
var inst_40451 = (state_40723[(2)]);
var state_40723__$1 = state_40723;
var statearr_40806_40990 = state_40723__$1;
(statearr_40806_40990[(2)] = inst_40451);

(statearr_40806_40990[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (44))){
var inst_40493 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_40494 = clojure.string.includes_QMARK_(inst_40493,"/");
var state_40723__$1 = state_40723;
var statearr_40807_40991 = state_40723__$1;
(statearr_40807_40991[(2)] = inst_40494);

(statearr_40807_40991[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (93))){
var inst_40610 = (state_40723[(2)]);
var state_40723__$1 = state_40723;
if(cljs.core.truth_(inst_40610)){
var statearr_40808_40992 = state_40723__$1;
(statearr_40808_40992[(1)] = (94));

} else {
var statearr_40809_40993 = state_40723__$1;
(statearr_40809_40993[(1)] = (95));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (6))){
var inst_40394 = (state_40723[(36)]);
var state_40723__$1 = state_40723;
var statearr_40810_40994 = state_40723__$1;
(statearr_40810_40994[(2)] = inst_40394);

(statearr_40810_40994[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (111))){
var inst_40632 = (state_40723[(37)]);
var inst_40654 = (state_40723[(2)]);
var inst_40624 = inst_40632;
var inst_40625 = inst_40654;
var state_40723__$1 = (function (){var statearr_40811 = state_40723;
(statearr_40811[(38)] = inst_40624);

(statearr_40811[(10)] = inst_40625);

return statearr_40811;
})();
var statearr_40812_40995 = state_40723__$1;
(statearr_40812_40995[(2)] = null);

(statearr_40812_40995[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (28))){
var state_40723__$1 = state_40723;
var statearr_40813_40996 = state_40723__$1;
(statearr_40813_40996[(2)] = null);

(statearr_40813_40996[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (64))){
var inst_40416 = (state_40723[(18)]);
var state_40723__$1 = state_40723;
if(cljs.core.truth_(inst_40416)){
var statearr_40814_40997 = state_40723__$1;
(statearr_40814_40997[(1)] = (67));

} else {
var statearr_40815_40998 = state_40723__$1;
(statearr_40815_40998[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (103))){
var state_40723__$1 = state_40723;
if(cljs.core.truth_(fuel)){
var statearr_40816_40999 = state_40723__$1;
(statearr_40816_40999[(1)] = (105));

} else {
var statearr_40817_41000 = state_40723__$1;
(statearr_40817_41000[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (51))){
var inst_40500 = (state_40723[(26)]);
var state_40723__$1 = state_40723;
var statearr_40818_41001 = state_40723__$1;
(statearr_40818_41001[(2)] = inst_40500);

(statearr_40818_41001[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (25))){
var state_40723__$1 = state_40723;
var statearr_40819_41002 = state_40723__$1;
(statearr_40819_41002[(1)] = (27));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (34))){
var state_40723__$1 = state_40723;
var statearr_40821_41003 = state_40723__$1;
(statearr_40821_41003[(2)] = null);

(statearr_40821_41003[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (125))){
var inst_40704 = (state_40723[(30)]);
var inst_40701 = (state_40723[(11)]);
var inst_40704__$1 = cljs.core.coll_QMARK_(inst_40701);
var state_40723__$1 = (function (){var statearr_40822 = state_40723;
(statearr_40822[(30)] = inst_40704__$1);

return statearr_40822;
})();
if(inst_40704__$1){
var statearr_40823_41004 = state_40723__$1;
(statearr_40823_41004[(1)] = (128));

} else {
var statearr_40824_41005 = state_40723__$1;
(statearr_40824_41005[(1)] = (129));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (17))){
var inst_40416 = (state_40723[(18)]);
var inst_40427 = (state_40723[(2)]);
var inst_40428 = cljs.core.PersistentHashMap.EMPTY;
var inst_40429 = cljs.core.volatile_BANG_(inst_40428);
var state_40723__$1 = (function (){var statearr_40825 = state_40723;
(statearr_40825[(7)] = inst_40427);

(statearr_40825[(8)] = inst_40429);

return statearr_40825;
})();
if(cljs.core.truth_(inst_40416)){
var statearr_40826_41006 = state_40723__$1;
(statearr_40826_41006[(1)] = (18));

} else {
var statearr_40827_41007 = state_40723__$1;
(statearr_40827_41007[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (3))){
var inst_40721 = (state_40723[(2)]);
var state_40723__$1 = state_40723;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40723__$1,inst_40721);
} else {
if((state_val_40724 === (12))){
var inst_40400 = (state_40723[(39)]);
var state_40723__$1 = state_40723;
var statearr_40828_41008 = state_40723__$1;
(statearr_40828_41008[(2)] = inst_40400);

(statearr_40828_41008[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (2))){
var inst_40394 = (state_40723[(36)]);
var _ = (function (){var statearr_40829 = state_40723;
(statearr_40829[(4)] = cljs.core.cons((5),(state_40723[(4)])));

return statearr_40829;
})();
var inst_40394__$1 = select;
var state_40723__$1 = (function (){var statearr_40830 = state_40723;
(statearr_40830[(36)] = inst_40394__$1);

return statearr_40830;
})();
if(cljs.core.truth_(inst_40394__$1)){
var statearr_40831_41009 = state_40723__$1;
(statearr_40831_41009[(1)] = (6));

} else {
var statearr_40832_41010 = state_40723__$1;
(statearr_40832_41010[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (66))){
var inst_40692 = (state_40723[(2)]);
var state_40723__$1 = state_40723;
var statearr_40833_41011 = state_40723__$1;
(statearr_40833_41011[(2)] = inst_40692);

(statearr_40833_41011[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (107))){
var inst_40631 = (state_40723[(19)]);
var inst_40643 = (state_40723[(2)]);
var inst_40644 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_40631,false);
var state_40723__$1 = (function (){var statearr_40834 = state_40723;
(statearr_40834[(40)] = inst_40643);

return statearr_40834;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40723__$1,(108),inst_40644);
} else {
if((state_val_40724 === (23))){
var inst_40455 = (state_40723[(2)]);
var state_40723__$1 = state_40723;
var statearr_40835_41012 = state_40723__$1;
(statearr_40835_41012[(2)] = inst_40455);

(statearr_40835_41012[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (47))){
var inst_40500 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_40723__$1 = (function (){var statearr_40836 = state_40723;
(statearr_40836[(26)] = inst_40500);

return statearr_40836;
})();
if(cljs.core.truth_(fuel)){
var statearr_40837_41013 = state_40723__$1;
(statearr_40837_41013[(1)] = (50));

} else {
var statearr_40838_41014 = state_40723__$1;
(statearr_40838_41014[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (35))){
var inst_40417 = (state_40723[(13)]);
var inst_40419 = (state_40723[(15)]);
var inst_40470 = (state_40723[(2)]);
var inst_40471 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_40472 = [inst_40417,inst_40419];
var inst_40473 = cljs.core.PersistentHashMap.fromArrays(inst_40471,inst_40472);
var inst_40474 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4(db,where,inst_40470,inst_40473);
var state_40723__$1 = state_40723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40723__$1,(36),inst_40474);
} else {
if((state_val_40724 === (127))){
var inst_40713 = (state_40723[(2)]);
var state_40723__$1 = state_40723;
if(cljs.core.truth_(inst_40713)){
var statearr_40839_41015 = state_40723__$1;
(statearr_40839_41015[(1)] = (131));

} else {
var statearr_40840_41016 = state_40723__$1;
(statearr_40840_41016[(1)] = (132));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (82))){
var inst_40688 = (state_40723[(2)]);
var state_40723__$1 = state_40723;
var statearr_40841_41017 = state_40723__$1;
(statearr_40841_41017[(2)] = inst_40688);

(statearr_40841_41017[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (76))){
var inst_40417 = (state_40723[(13)]);
var inst_40419 = (state_40723[(15)]);
var inst_40566 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_40567 = [inst_40417,inst_40419];
var inst_40568 = cljs.core.PersistentHashMap.fromArrays(inst_40566,inst_40567);
var state_40723__$1 = state_40723;
var statearr_40842_41018 = state_40723__$1;
(statearr_40842_41018[(2)] = inst_40568);

(statearr_40842_41018[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (97))){
var inst_40631 = (state_40723[(19)]);
var inst_40624 = (state_40723[(38)]);
var inst_40630 = cljs.core.seq(inst_40624);
var inst_40631__$1 = cljs.core.first(inst_40630);
var inst_40632 = cljs.core.next(inst_40630);
var inst_40633 = cljs.core.not(inst_40631__$1);
var state_40723__$1 = (function (){var statearr_40843 = state_40723;
(statearr_40843[(19)] = inst_40631__$1);

(statearr_40843[(37)] = inst_40632);

return statearr_40843;
})();
if(inst_40633){
var statearr_40844_41019 = state_40723__$1;
(statearr_40844_41019[(1)] = (99));

} else {
var statearr_40845_41020 = state_40723__$1;
(statearr_40845_41020[(1)] = (100));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (19))){
var inst_40457 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40458 = [null,null];
var inst_40459 = (new cljs.core.PersistentVector(null,2,(5),inst_40457,inst_40458,null));
var state_40723__$1 = state_40723;
var statearr_40846_41021 = state_40723__$1;
(statearr_40846_41021[(2)] = inst_40459);

(statearr_40846_41021[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (57))){
var inst_40417 = (state_40723[(13)]);
var inst_40419 = (state_40723[(15)]);
var inst_40516 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_40517 = [inst_40417,inst_40419];
var inst_40518 = cljs.core.PersistentHashMap.fromArrays(inst_40516,inst_40517);
var state_40723__$1 = state_40723;
var statearr_40847_41022 = state_40723__$1;
(statearr_40847_41022[(2)] = inst_40518);

(statearr_40847_41022[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (68))){
var inst_40417 = (state_40723[(13)]);
var inst_40419 = (state_40723[(15)]);
var inst_40547 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_40548 = [inst_40417,inst_40419];
var inst_40549 = cljs.core.PersistentHashMap.fromArrays(inst_40547,inst_40548);
var state_40723__$1 = state_40723;
var statearr_40848_41023 = state_40723__$1;
(statearr_40848_41023[(2)] = inst_40549);

(statearr_40848_41023[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (11))){
var inst_40411 = (state_40723[(2)]);
var state_40723__$1 = state_40723;
var statearr_40849_41024 = state_40723__$1;
(statearr_40849_41024[(2)] = inst_40411);

(statearr_40849_41024[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (115))){
var inst_40416 = (state_40723[(18)]);
var inst_40665 = (state_40723[(2)]);
var state_40723__$1 = (function (){var statearr_40851 = state_40723;
(statearr_40851[(35)] = inst_40665);

return statearr_40851;
})();
if(cljs.core.truth_(inst_40416)){
var statearr_40852_41025 = state_40723__$1;
(statearr_40852_41025[(1)] = (116));

} else {
var statearr_40853_41026 = state_40723__$1;
(statearr_40853_41026[(1)] = (117));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (9))){
var inst_40397 = (state_40723[(12)]);
var state_40723__$1 = state_40723;
var statearr_40854_41027 = state_40723__$1;
(statearr_40854_41027[(2)] = inst_40397);

(statearr_40854_41027[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (5))){
var _ = (function (){var statearr_40855 = state_40723;
(statearr_40855[(4)] = cljs.core.rest((state_40723[(4)])));

return statearr_40855;
})();
var state_40723__$1 = state_40723;
var ex40850 = (state_40723__$1[(2)]);
var statearr_40856_41028 = state_40723__$1;
(statearr_40856_41028[(5)] = ex40850);


if((ex40850 instanceof Error)){
var statearr_40857_41029 = state_40723__$1;
(statearr_40857_41029[(1)] = (4));

(statearr_40857_41029[(5)] = null);

} else {
throw ex40850;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (112))){
var inst_40672 = (state_40723[(2)]);
var inst_40673 = fluree.db.util.async.throw_err(inst_40672);
var state_40723__$1 = state_40723;
var statearr_40858_41030 = state_40723__$1;
(statearr_40858_41030[(2)] = inst_40673);

(statearr_40858_41030[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (83))){
var inst_40586 = (state_40723[(20)]);
var inst_40585 = (state_40723[(2)]);
var inst_40586__$1 = fluree.db.util.async.throw_err(inst_40585);
var inst_40587 = (inst_40586__$1 == null);
var state_40723__$1 = (function (){var statearr_40859 = state_40723;
(statearr_40859[(20)] = inst_40586__$1);

return statearr_40859;
})();
if(cljs.core.truth_(inst_40587)){
var statearr_40860_41031 = state_40723__$1;
(statearr_40860_41031[(1)] = (84));

} else {
var statearr_40861_41032 = state_40723__$1;
(statearr_40861_41032[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (14))){
var inst_40409 = (state_40723[(2)]);
var state_40723__$1 = state_40723;
var statearr_40862_41033 = state_40723__$1;
(statearr_40862_41033[(2)] = inst_40409);

(statearr_40862_41033[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (45))){
var inst_40491 = (state_40723[(27)]);
var state_40723__$1 = state_40723;
var statearr_40863_41034 = state_40723__$1;
(statearr_40863_41034[(2)] = inst_40491);

(statearr_40863_41034[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (53))){
var inst_40506 = (state_40723[(21)]);
var inst_40508 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_40509 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_40506,inst_40508);
var state_40723__$1 = state_40723;
var statearr_40864_41035 = state_40723__$1;
(statearr_40864_41035[(2)] = inst_40509);

(statearr_40864_41035[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (78))){
var inst_40427 = (state_40723[(7)]);
var inst_40429 = (state_40723[(8)]);
var inst_40573 = (state_40723[(2)]);
var inst_40574 = fluree.db.util.async.throw_err(inst_40573);
var inst_40575 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_40429,fuel,max_fuel,inst_40427,inst_40574);
var state_40723__$1 = state_40723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40723__$1,(79),inst_40575);
} else {
if((state_val_40724 === (132))){
var inst_40701 = (state_40723[(11)]);
var state_40723__$1 = state_40723;
var statearr_40865_41036 = state_40723__$1;
(statearr_40865_41036[(2)] = inst_40701);

(statearr_40865_41036[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (26))){
var inst_40453 = (state_40723[(2)]);
var state_40723__$1 = state_40723;
var statearr_40866_41037 = state_40723__$1;
(statearr_40866_41037[(2)] = inst_40453);

(statearr_40866_41037[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (123))){
var inst_40696 = (state_40723[(28)]);
var state_40723__$1 = state_40723;
var statearr_40867_41038 = state_40723__$1;
(statearr_40867_41038[(2)] = inst_40696);

(statearr_40867_41038[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (16))){
var inst_40420 = (state_40723[(24)]);
var state_40723__$1 = state_40723;
var statearr_40868_41039 = state_40723__$1;
(statearr_40868_41039[(2)] = inst_40420);

(statearr_40868_41039[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (133))){
var inst_40718 = (state_40723[(2)]);
var _ = (function (){var statearr_40869 = state_40723;
(statearr_40869[(4)] = cljs.core.rest((state_40723[(4)])));

return statearr_40869;
})();
var state_40723__$1 = state_40723;
var statearr_40870_41040 = state_40723__$1;
(statearr_40870_41040[(2)] = inst_40718);

(statearr_40870_41040[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (81))){
var inst_40605 = (state_40723[(22)]);
var inst_40605__$1 = cljs.core.sequential_QMARK_(from);
var state_40723__$1 = (function (){var statearr_40871 = state_40723;
(statearr_40871[(22)] = inst_40605__$1);

return statearr_40871;
})();
if(inst_40605__$1){
var statearr_40872_41041 = state_40723__$1;
(statearr_40872_41041[(1)] = (91));

} else {
var statearr_40873_41042 = state_40723__$1;
(statearr_40873_41042[(1)] = (92));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (120))){
var state_40723__$1 = state_40723;
var statearr_40874_41043 = state_40723__$1;
(statearr_40874_41043[(2)] = null);

(statearr_40874_41043[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (79))){
var inst_40577 = (state_40723[(2)]);
var inst_40578 = fluree.db.util.async.throw_err(inst_40577);
var state_40723__$1 = state_40723;
var statearr_40875_41044 = state_40723__$1;
(statearr_40875_41044[(2)] = inst_40578);

(statearr_40875_41044[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (38))){
var state_40723__$1 = state_40723;
var statearr_40876_41045 = state_40723__$1;
(statearr_40876_41045[(2)] = null);

(statearr_40876_41045[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (126))){
var inst_40702 = (state_40723[(41)]);
var state_40723__$1 = state_40723;
var statearr_40877_41046 = state_40723__$1;
(statearr_40877_41046[(2)] = inst_40702);

(statearr_40877_41046[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (98))){
var inst_40416 = (state_40723[(18)]);
var inst_40659 = (state_40723[(2)]);
var inst_40660 = cljs.core.PersistentVector.EMPTY;
var inst_40661 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_40660,inst_40659);
var state_40723__$1 = (function (){var statearr_40878 = state_40723;
(statearr_40878[(34)] = inst_40661);

return statearr_40878;
})();
if(cljs.core.truth_(inst_40416)){
var statearr_40879_41047 = state_40723__$1;
(statearr_40879_41047[(1)] = (113));

} else {
var statearr_40880_41048 = state_40723__$1;
(statearr_40880_41048[(1)] = (114));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (124))){
var inst_40702 = (state_40723[(41)]);
var inst_40701 = (state_40723[(2)]);
var inst_40702__$1 = selectOne;
var state_40723__$1 = (function (){var statearr_40881 = state_40723;
(statearr_40881[(41)] = inst_40702__$1);

(statearr_40881[(11)] = inst_40701);

return statearr_40881;
})();
if(cljs.core.truth_(inst_40702__$1)){
var statearr_40882_41049 = state_40723__$1;
(statearr_40882_41049[(1)] = (125));

} else {
var statearr_40883_41050 = state_40723__$1;
(statearr_40883_41050[(1)] = (126));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (87))){
var inst_40597 = (state_40723[(2)]);
var inst_40598 = fluree.db.util.async.throw_err(inst_40597);
var state_40723__$1 = (function (){var statearr_40884 = state_40723;
(statearr_40884[(31)] = inst_40598);

return statearr_40884;
})();
if(cljs.core.truth_(fuel)){
var statearr_40885_41051 = state_40723__$1;
(statearr_40885_41051[(1)] = (88));

} else {
var statearr_40886_41052 = state_40723__$1;
(statearr_40886_41052[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (30))){
var inst_40466 = typeof from === 'string';
var state_40723__$1 = state_40723;
if(cljs.core.truth_(inst_40466)){
var statearr_40887_41053 = state_40723__$1;
(statearr_40887_41053[(1)] = (33));

} else {
var statearr_40888_41054 = state_40723__$1;
(statearr_40888_41054[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (73))){
var inst_40580 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_40723__$1 = state_40723;
if(inst_40580){
var statearr_40889_41055 = state_40723__$1;
(statearr_40889_41055[(1)] = (80));

} else {
var statearr_40890_41056 = state_40723__$1;
(statearr_40890_41056[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (96))){
var inst_40686 = (state_40723[(2)]);
var state_40723__$1 = state_40723;
var statearr_40891_41057 = state_40723__$1;
(statearr_40891_41057[(2)] = inst_40686);

(statearr_40891_41057[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (10))){
var inst_40400 = (state_40723[(39)]);
var inst_40400__$1 = selectDistinct;
var state_40723__$1 = (function (){var statearr_40892 = state_40723;
(statearr_40892[(39)] = inst_40400__$1);

return statearr_40892;
})();
if(cljs.core.truth_(inst_40400__$1)){
var statearr_40893_41058 = state_40723__$1;
(statearr_40893_41058[(1)] = (12));

} else {
var statearr_40894_41059 = state_40723__$1;
(statearr_40894_41059[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (18))){
var inst_40416 = (state_40723[(18)]);
var inst_40431 = cljs.core.vector_QMARK_(inst_40416);
var state_40723__$1 = state_40723;
if(inst_40431){
var statearr_40895_41060 = state_40723__$1;
(statearr_40895_41060[(1)] = (21));

} else {
var statearr_40896_41061 = state_40723__$1;
(statearr_40896_41061[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (105))){
var inst_40640 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_40723__$1 = state_40723;
var statearr_40897_41062 = state_40723__$1;
(statearr_40897_41062[(2)] = inst_40640);

(statearr_40897_41062[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (52))){
var inst_40506 = (state_40723[(2)]);
var state_40723__$1 = (function (){var statearr_40898 = state_40723;
(statearr_40898[(21)] = inst_40506);

return statearr_40898;
})();
var statearr_40899_41063 = state_40723__$1;
(statearr_40899_41063[(1)] = (53));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (114))){
var inst_40417 = (state_40723[(13)]);
var state_40723__$1 = state_40723;
var statearr_40901_41064 = state_40723__$1;
(statearr_40901_41064[(2)] = inst_40417);

(statearr_40901_41064[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (67))){
var inst_40545 = cljs.core.PersistentHashMap.EMPTY;
var state_40723__$1 = state_40723;
var statearr_40902_41065 = state_40723__$1;
(statearr_40902_41065[(2)] = inst_40545);

(statearr_40902_41065[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (71))){
var inst_40558 = (state_40723[(2)]);
var inst_40559 = fluree.db.util.async.throw_err(inst_40558);
var state_40723__$1 = state_40723;
var statearr_40903_41066 = state_40723__$1;
(statearr_40903_41066[(2)] = inst_40559);

(statearr_40903_41066[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (42))){
var inst_40419 = (state_40723[(15)]);
var state_40723__$1 = state_40723;
var statearr_40904_41067 = state_40723__$1;
(statearr_40904_41067[(2)] = inst_40419);

(statearr_40904_41067[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (80))){
var inst_40583 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_40723__$1 = state_40723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40723__$1,(83),inst_40583);
} else {
if((state_val_40724 === (37))){
var inst_40488 = (state_40723[(2)]);
var inst_40489 = fluree.db.util.async.throw_err(inst_40488);
var state_40723__$1 = state_40723;
var statearr_40905_41068 = state_40723__$1;
(statearr_40905_41068[(2)] = inst_40489);

(statearr_40905_41068[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (63))){
var inst_40542 = (state_40723[(2)]);
var state_40723__$1 = state_40723;
if(cljs.core.truth_(inst_40542)){
var statearr_40906_41069 = state_40723__$1;
(statearr_40906_41069[(1)] = (64));

} else {
var statearr_40907_41070 = state_40723__$1;
(statearr_40907_41070[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (94))){
var inst_40619 = from;
var inst_40620 = cljs.core.seq(inst_40619);
var inst_40621 = cljs.core.first(inst_40620);
var inst_40622 = cljs.core.next(inst_40620);
var inst_40623 = cljs.core.PersistentVector.EMPTY;
var inst_40624 = inst_40619;
var inst_40625 = inst_40623;
var state_40723__$1 = (function (){var statearr_40908 = state_40723;
(statearr_40908[(42)] = inst_40622);

(statearr_40908[(38)] = inst_40624);

(statearr_40908[(43)] = inst_40621);

(statearr_40908[(10)] = inst_40625);

return statearr_40908;
})();
var statearr_40909_41071 = state_40723__$1;
(statearr_40909_41071[(2)] = null);

(statearr_40909_41071[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (8))){
var inst_40418 = (state_40723[(25)]);
var inst_40413 = (state_40723[(2)]);
var inst_40414 = opts_SINGLEQUOTE_;
var inst_40415 = cljs.core.__destructure_map(inst_40414);
var inst_40416 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40415,cljs.core.cst$kw$orderBy);
var inst_40417 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40415,cljs.core.cst$kw$limit);
var inst_40418__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40415,cljs.core.cst$kw$component);
var inst_40419 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40415,cljs.core.cst$kw$offset);
var inst_40420 = fluree.db.query.fql_parser.parse_db(db,inst_40413,opts_SINGLEQUOTE_);
var inst_40421 = (inst_40418__$1 == null);
var inst_40422 = cljs.core.not(inst_40421);
var state_40723__$1 = (function (){var statearr_40910 = state_40723;
(statearr_40910[(13)] = inst_40417);

(statearr_40910[(24)] = inst_40420);

(statearr_40910[(25)] = inst_40418__$1);

(statearr_40910[(15)] = inst_40419);

(statearr_40910[(18)] = inst_40416);

return statearr_40910;
})();
if(inst_40422){
var statearr_40911_41072 = state_40723__$1;
(statearr_40911_41072[(1)] = (15));

} else {
var statearr_40912_41073 = state_40723__$1;
(statearr_40912_41073[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (49))){
var inst_40694 = (state_40723[(2)]);
var state_40723__$1 = state_40723;
var statearr_40913_41074 = state_40723__$1;
(statearr_40913_41074[(2)] = inst_40694);

(statearr_40913_41074[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (84))){
var state_40723__$1 = state_40723;
var statearr_40914_41075 = state_40723__$1;
(statearr_40914_41075[(2)] = null);

(statearr_40914_41075[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__15091__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__15091__auto____0 = (function (){
var statearr_40915 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40915[(0)] = fluree$db$query$fql$query_$_state_machine__15091__auto__);

(statearr_40915[(1)] = (1));

return statearr_40915;
});
var fluree$db$query$fql$query_$_state_machine__15091__auto____1 = (function (state_40723){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_40723);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e40916){var ex__15094__auto__ = e40916;
var statearr_40917_41076 = state_40723;
(statearr_40917_41076[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_40723[(4)]))){
var statearr_40918_41077 = state_40723;
(statearr_40918_41077[(1)] = cljs.core.first((state_40723[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__41078 = state_40723;
state_40723 = G__41078;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__15091__auto__ = function(state_40723){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__15091__auto____1.call(this,state_40723);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__15091__auto____0;
fluree$db$query$fql$query_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__15091__auto____1;
return fluree$db$query$fql$query_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_40919 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_40919[(6)] = c__15165__auto__);

return statearr_40919;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}

});
