// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$spot,idx)) && ((((!((start_flake.o == null)))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)))))))));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__5045__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__28200 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28200,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28200,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28200,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28200,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28200,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28200,(5),null);
var G__28203 = idx;
var G__28203__$1 = (((G__28203 instanceof cljs.core.Keyword))?G__28203.fqn:null);
switch (G__28203__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28203__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__28205 = idx;
var G__28205__$1 = (((G__28205 instanceof cljs.core.Keyword))?G__28205.fqn:null);
switch (G__28205__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28205__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__28207 = idx;
var G__28207__$1 = (((G__28207 instanceof cljs.core.Keyword))?G__28207.fqn:null);
switch (G__28207__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28207__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__28210 = arguments.length;
switch (G__28210) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__28211 = (function (){var pred__28214 = cljs.core.identical_QMARK_;
var expr__28215 = test;
if(cljs.core.truth_((pred__28214.cljs$core$IFn$_invoke$arity$2 ? pred__28214.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__28215) : pred__28214.call(null,cljs.core._EQ_,expr__28215)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__28214.cljs$core$IFn$_invoke$arity$2 ? pred__28214.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__28215) : pred__28214.call(null,cljs.core._LT_,expr__28215)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__28214.cljs$core$IFn$_invoke$arity$2 ? pred__28214.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__28215) : pred__28214.call(null,cljs.core._LT__EQ_,expr__28215)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__28214.cljs$core$IFn$_invoke$arity$2 ? pred__28214.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__28215) : pred__28214.call(null,cljs.core._GT_,expr__28215)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__28214.cljs$core$IFn$_invoke$arity$2 ? pred__28214.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__28215) : pred__28214.call(null,cljs.core._GT__EQ_,expr__28215)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__28215)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28211,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28211,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28211,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28211,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_28454){
var state_val_28455 = (state_28454[(1)]);
if((state_val_28455 === (65))){
var inst_28425 = (state_28454[(7)]);
var inst_28369 = (state_28454[(8)]);
var inst_28425__$1 = (state_28454[(2)]);
var inst_28426 = cljs.core.count(inst_28425__$1);
var state_28454__$1 = (function (){var statearr_28456 = state_28454;
(statearr_28456[(7)] = inst_28425__$1);

(statearr_28456[(9)] = inst_28426);

return statearr_28456;
})();
if(cljs.core.truth_(inst_28369)){
var statearr_28457_28594 = state_28454__$1;
(statearr_28457_28594[(1)] = (81));

} else {
var statearr_28458_28595 = state_28454__$1;
(statearr_28458_28595[(1)] = (82));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (70))){
var inst_28400 = (state_28454[(2)]);
var state_28454__$1 = state_28454;
if(cljs.core.truth_(inst_28400)){
var statearr_28459_28596 = state_28454__$1;
(statearr_28459_28596[(1)] = (71));

} else {
var statearr_28460_28597 = state_28454__$1;
(statearr_28460_28597[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (62))){
var inst_28353 = (state_28454[(10)]);
var inst_28339 = (state_28454[(11)]);
var inst_28368 = (state_28454[(2)]);
var inst_28369 = fluree.db.dbproto._rhs(inst_28353);
var state_28454__$1 = (function (){var statearr_28461 = state_28454;
(statearr_28461[(12)] = inst_28368);

(statearr_28461[(8)] = inst_28369);

return statearr_28461;
})();
if(cljs.core.truth_(inst_28339)){
var statearr_28462_28598 = state_28454__$1;
(statearr_28462_28598[(1)] = (63));

} else {
var statearr_28463_28599 = state_28454__$1;
(statearr_28463_28599[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (74))){
var inst_28393 = (state_28454[(13)]);
var inst_28407 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,inst_28393);
var state_28454__$1 = state_28454;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28454__$1,(77),inst_28407);
} else {
if((state_val_28455 === (7))){
var inst_28230 = (state_28454[(14)]);
var state_28454__$1 = state_28454;
var statearr_28464_28600 = state_28454__$1;
(statearr_28464_28600[(2)] = inst_28230);

(statearr_28464_28600[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (59))){
var inst_28315 = (state_28454[(15)]);
var inst_28360 = (state_28454[(16)]);
var inst_28316 = (state_28454[(17)]);
var inst_28359 = (state_28454[(2)]);
var inst_28360__$1 = fluree.db.util.async.throw_err(inst_28359);
var inst_28361 = fluree.db.flake.subrange(inst_28360__$1,start_test,inst_28315,end_test,inst_28316);
var inst_28362 = fluree.db.query.range.value_with_nil_pred(idx,inst_28315,inst_28316);
var state_28454__$1 = (function (){var statearr_28465 = state_28454;
(statearr_28465[(18)] = inst_28361);

(statearr_28465[(16)] = inst_28360__$1);

return statearr_28465;
})();
if(inst_28362){
var statearr_28466_28601 = state_28454__$1;
(statearr_28466_28601[(1)] = (60));

} else {
var statearr_28467_28602 = state_28454__$1;
(statearr_28467_28602[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (86))){
var inst_28434 = (state_28454[(2)]);
var state_28454__$1 = state_28454;
var statearr_28468_28603 = state_28454__$1;
(statearr_28468_28603[(2)] = inst_28434);

(statearr_28468_28603[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (20))){
var inst_28279 = (state_28454[(19)]);
var inst_28231 = (state_28454[(20)]);
var inst_28278 = (state_28454[(2)]);
var inst_28279__$1 = (inst_28231 == null);
var state_28454__$1 = (function (){var statearr_28469 = state_28454;
(statearr_28469[(19)] = inst_28279__$1);

(statearr_28469[(21)] = inst_28278);

return statearr_28469;
})();
if(cljs.core.truth_(inst_28279__$1)){
var statearr_28470_28604 = state_28454__$1;
(statearr_28470_28604[(1)] = (22));

} else {
var statearr_28471_28605 = state_28454__$1;
(statearr_28471_28605[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (72))){
var inst_28386 = (state_28454[(22)]);
var inst_28404 = (inst_28386 + (1));
var inst_28405 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_28454__$1 = (function (){var statearr_28472 = state_28454;
(statearr_28472[(23)] = inst_28404);

return statearr_28472;
})();
if(cljs.core.truth_(inst_28405)){
var statearr_28473_28606 = state_28454__$1;
(statearr_28473_28606[(1)] = (74));

} else {
var statearr_28474_28607 = state_28454__$1;
(statearr_28474_28607[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (58))){
var inst_28449 = (state_28454[(2)]);
var _ = (function (){var statearr_28475 = state_28454;
(statearr_28475[(4)] = cljs.core.rest((state_28454[(4)])));

return statearr_28475;
})();
var state_28454__$1 = state_28454;
var statearr_28476_28608 = state_28454__$1;
(statearr_28476_28608[(2)] = inst_28449);

(statearr_28476_28608[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (60))){
var inst_28234 = (state_28454[(24)]);
var inst_28296 = (state_28454[(25)]);
var inst_28361 = (state_28454[(18)]);
var inst_28260 = (state_28454[(26)]);
var inst_28321 = (state_28454[(27)]);
var inst_28269 = (state_28454[(28)]);
var inst_28241 = (state_28454[(29)]);
var inst_28326 = (state_28454[(30)]);
var inst_28315 = (state_28454[(15)]);
var inst_28322 = (state_28454[(31)]);
var inst_28287 = (state_28454[(32)]);
var inst_28360 = (state_28454[(16)]);
var inst_28353 = (state_28454[(10)]);
var inst_28348 = (state_28454[(33)]);
var inst_28355 = (state_28454[(34)]);
var inst_28316 = (state_28454[(17)]);
var inst_28314 = (state_28454[(35)]);
var inst_28229 = (state_28454[(36)]);
var inst_28354 = (state_28454[(37)]);
var inst_28278 = (state_28454[(21)]);
var inst_28240 = (state_28454[(38)]);
var inst_28333 = (state_28454[(39)]);
var inst_28305 = (state_28454[(40)]);
var inst_28339 = (state_28454[(11)]);
var inst_28343 = (state_28454[(41)]);
var inst_28236 = (state_28454[(42)]);
var inst_28233 = (state_28454[(43)]);
var inst_28332 = (state_28454[(44)]);
var inst_28251 = (state_28454[(45)]);
var inst_28364 = (function (){var no_filter_QMARK_ = inst_28339;
var next_node = inst_28353;
var flakes = inst_28360;
var s1 = inst_28251;
var o2 = inst_28278;
var t1 = inst_28233;
var i = inst_28354;
var m1 = inst_28305;
var root_node = inst_28348;
var to_t = inst_28333;
var s2 = inst_28260;
var p2 = inst_28296;
var permissions = inst_28322;
var limit = inst_28321;
var start_flake = inst_28315;
var acc = inst_28355;
var t2 = inst_28240;
var op1 = inst_28234;
var o1 = inst_28269;
var end_flake = inst_28316;
var base_result = inst_28361;
var p1 = inst_28287;
var vec__28226 = inst_28236;
var idx_compare = inst_28326;
var op2 = inst_28241;
var from_t = inst_28332;
var m2 = inst_28314;
var vec__28223 = inst_28229;
var novelty = inst_28343;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_28365 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_28364,inst_28361,inst_28361);
var state_28454__$1 = state_28454;
var statearr_28477_28609 = state_28454__$1;
(statearr_28477_28609[(2)] = inst_28365);

(statearr_28477_28609[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (27))){
var inst_28238 = (state_28454[(46)]);
var inst_28288 = (state_28454[(47)]);
var inst_28287 = (state_28454[(2)]);
var inst_28288__$1 = (inst_28238 == null);
var state_28454__$1 = (function (){var statearr_28478 = state_28454;
(statearr_28478[(32)] = inst_28287);

(statearr_28478[(47)] = inst_28288__$1);

return statearr_28478;
})();
if(cljs.core.truth_(inst_28288__$1)){
var statearr_28479_28610 = state_28454__$1;
(statearr_28479_28610[(1)] = (28));

} else {
var statearr_28480_28611 = state_28454__$1;
(statearr_28480_28611[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (1))){
var state_28454__$1 = state_28454;
var statearr_28481_28612 = state_28454__$1;
(statearr_28481_28612[(2)] = null);

(statearr_28481_28612[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (69))){
var inst_28321 = (state_28454[(27)]);
var inst_28386 = (state_28454[(22)]);
var inst_28398 = (inst_28386 > inst_28321);
var state_28454__$1 = state_28454;
var statearr_28482_28613 = state_28454__$1;
(statearr_28482_28613[(2)] = inst_28398);

(statearr_28482_28613[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (24))){
var inst_28283 = (state_28454[(2)]);
var state_28454__$1 = state_28454;
if(cljs.core.truth_(inst_28283)){
var statearr_28483_28614 = state_28454__$1;
(statearr_28483_28614[(1)] = (25));

} else {
var statearr_28484_28615 = state_28454__$1;
(statearr_28484_28615[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (55))){
var inst_28315 = (state_28454[(15)]);
var inst_28348 = (state_28454[(33)]);
var inst_28347 = (state_28454[(2)]);
var inst_28348__$1 = fluree.db.util.async.throw_err(inst_28347);
var inst_28349 = fluree.db.dbproto._lookup_leaf(inst_28348__$1,inst_28315);
var state_28454__$1 = (function (){var statearr_28485 = state_28454;
(statearr_28485[(33)] = inst_28348__$1);

return statearr_28485;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28454__$1,(56),inst_28349);
} else {
if((state_val_28455 === (85))){
var inst_28429 = (state_28454[(48)]);
var state_28454__$1 = state_28454;
var statearr_28486_28616 = state_28454__$1;
(statearr_28486_28616[(2)] = inst_28429);

(statearr_28486_28616[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (39))){
var inst_28303 = (state_28454[(2)]);
var state_28454__$1 = state_28454;
var statearr_28487_28617 = state_28454__$1;
(statearr_28487_28617[(2)] = inst_28303);

(statearr_28487_28617[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (88))){
var inst_28348 = (state_28454[(33)]);
var inst_28369 = (state_28454[(8)]);
var inst_28441 = fluree.db.dbproto._lookup_leaf(inst_28348,inst_28369);
var state_28454__$1 = state_28454;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28454__$1,(90),inst_28441);
} else {
if((state_val_28455 === (46))){
var inst_28317 = (state_28454[(49)]);
var state_28454__$1 = state_28454;
var statearr_28488_28618 = state_28454__$1;
(statearr_28488_28618[(2)] = inst_28317);

(statearr_28488_28618[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (4))){
var inst_28217 = (state_28454[(2)]);
var state_28454__$1 = state_28454;
var statearr_28489_28619 = state_28454__$1;
(statearr_28489_28619[(2)] = inst_28217);

(statearr_28489_28619[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (77))){
var inst_28409 = (state_28454[(2)]);
var inst_28410 = fluree.db.util.async.throw_err(inst_28409);
var state_28454__$1 = state_28454;
if(cljs.core.truth_(inst_28410)){
var statearr_28490_28620 = state_28454__$1;
(statearr_28490_28620[(1)] = (78));

} else {
var statearr_28491_28621 = state_28454__$1;
(statearr_28491_28621[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (54))){
var inst_28339 = (state_28454[(2)]);
var inst_28340 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28341 = [cljs.core.cst$kw$novelty,idx];
var inst_28342 = (new cljs.core.PersistentVector(null,2,(5),inst_28340,inst_28341,null));
var inst_28343 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_28342);
var inst_28344 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_28345 = fluree.db.dbproto._resolve(inst_28344);
var state_28454__$1 = (function (){var statearr_28492 = state_28454;
(statearr_28492[(11)] = inst_28339);

(statearr_28492[(41)] = inst_28343);

return statearr_28492;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28454__$1,(55),inst_28345);
} else {
if((state_val_28455 === (15))){
var inst_28232 = (state_28454[(50)]);
var state_28454__$1 = state_28454;
var statearr_28493_28622 = state_28454__$1;
(statearr_28493_28622[(2)] = inst_28232);

(statearr_28493_28622[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (48))){
var inst_28327 = (state_28454[(51)]);
var inst_28321 = (state_28454[(2)]);
var inst_28322 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_28323 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28324 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_28325 = (new cljs.core.PersistentVector(null,3,(5),inst_28323,inst_28324,null));
var inst_28326 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_28325);
var inst_28327__$1 = cljs.core.cst$kw$from_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var state_28454__$1 = (function (){var statearr_28494 = state_28454;
(statearr_28494[(51)] = inst_28327__$1);

(statearr_28494[(27)] = inst_28321);

(statearr_28494[(30)] = inst_28326);

(statearr_28494[(31)] = inst_28322);

return statearr_28494;
})();
if(cljs.core.truth_(inst_28327__$1)){
var statearr_28495_28623 = state_28454__$1;
(statearr_28495_28623[(1)] = (49));

} else {
var statearr_28496_28624 = state_28454__$1;
(statearr_28496_28624[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (50))){
var inst_28330 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var state_28454__$1 = state_28454;
var statearr_28497_28625 = state_28454__$1;
(statearr_28497_28625[(2)] = inst_28330);

(statearr_28497_28625[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (75))){
var inst_28387 = (state_28454[(52)]);
var state_28454__$1 = state_28454;
var statearr_28498_28626 = state_28454__$1;
(statearr_28498_28626[(2)] = inst_28387);

(statearr_28498_28626[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (21))){
var inst_28274 = (state_28454[(2)]);
var inst_28275 = fluree.db.util.async.throw_err(inst_28274);
var state_28454__$1 = state_28454;
var statearr_28499_28627 = state_28454__$1;
(statearr_28499_28627[(2)] = inst_28275);

(statearr_28499_28627[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (31))){
var state_28454__$1 = state_28454;
var statearr_28500_28628 = state_28454__$1;
(statearr_28500_28628[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_28500_28628[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (32))){
var inst_28238 = (state_28454[(46)]);
var state_28454__$1 = state_28454;
var statearr_28501_28629 = state_28454__$1;
(statearr_28501_28629[(2)] = inst_28238);

(statearr_28501_28629[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (40))){
var inst_28242 = (state_28454[(53)]);
var state_28454__$1 = state_28454;
var statearr_28502_28630 = state_28454__$1;
(statearr_28502_28630[(2)] = inst_28242);

(statearr_28502_28630[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (56))){
var inst_28351 = (state_28454[(2)]);
var inst_28352 = fluree.db.util.async.throw_err(inst_28351);
var inst_28353 = inst_28352;
var inst_28354 = (0);
var inst_28355 = null;
var state_28454__$1 = (function (){var statearr_28503 = state_28454;
(statearr_28503[(10)] = inst_28353);

(statearr_28503[(34)] = inst_28355);

(statearr_28503[(37)] = inst_28354);

return statearr_28503;
})();
var statearr_28504_28631 = state_28454__$1;
(statearr_28504_28631[(2)] = null);

(statearr_28504_28631[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (33))){
var inst_28235 = (state_28454[(54)]);
var inst_28296 = (state_28454[(2)]);
var state_28454__$1 = (function (){var statearr_28505 = state_28454;
(statearr_28505[(25)] = inst_28296);

return statearr_28505;
})();
if(cljs.core.truth_(inst_28235)){
var statearr_28506_28632 = state_28454__$1;
(statearr_28506_28632[(1)] = (34));

} else {
var statearr_28507_28633 = state_28454__$1;
(statearr_28507_28633[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (13))){
var inst_28256 = (state_28454[(2)]);
var inst_28257 = fluree.db.util.async.throw_err(inst_28256);
var state_28454__$1 = state_28454;
var statearr_28508_28634 = state_28454__$1;
(statearr_28508_28634[(2)] = inst_28257);

(statearr_28508_28634[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (22))){
var inst_28269 = (state_28454[(28)]);
var state_28454__$1 = state_28454;
var statearr_28509_28635 = state_28454__$1;
(statearr_28509_28635[(2)] = inst_28269);

(statearr_28509_28635[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (90))){
var inst_28425 = (state_28454[(7)]);
var inst_28426 = (state_28454[(9)]);
var inst_28443 = (state_28454[(2)]);
var inst_28444 = fluree.db.util.async.throw_err(inst_28443);
var inst_28353 = inst_28444;
var inst_28354 = inst_28426;
var inst_28355 = inst_28425;
var state_28454__$1 = (function (){var statearr_28510 = state_28454;
(statearr_28510[(10)] = inst_28353);

(statearr_28510[(34)] = inst_28355);

(statearr_28510[(37)] = inst_28354);

return statearr_28510;
})();
var statearr_28511_28636 = state_28454__$1;
(statearr_28511_28636[(2)] = null);

(statearr_28511_28636[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (36))){
var inst_28242 = (state_28454[(53)]);
var inst_28305 = (state_28454[(2)]);
var state_28454__$1 = (function (){var statearr_28512 = state_28454;
(statearr_28512[(40)] = inst_28305);

return statearr_28512;
})();
if(cljs.core.truth_(inst_28242)){
var statearr_28513_28637 = state_28454__$1;
(statearr_28513_28637[(1)] = (40));

} else {
var statearr_28514_28638 = state_28454__$1;
(statearr_28514_28638[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (41))){
var inst_28308 = (cljs.core._LT__EQ_ === end_test);
var state_28454__$1 = state_28454;
if(cljs.core.truth_(inst_28308)){
var statearr_28515_28639 = state_28454__$1;
(statearr_28515_28639[(1)] = (43));

} else {
var statearr_28516_28640 = state_28454__$1;
(statearr_28516_28640[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (89))){
var inst_28447 = (state_28454[(2)]);
var state_28454__$1 = state_28454;
var statearr_28517_28641 = state_28454__$1;
(statearr_28517_28641[(2)] = inst_28447);

(statearr_28517_28641[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (43))){
var state_28454__$1 = state_28454;
var statearr_28518_28642 = state_28454__$1;
(statearr_28518_28642[(2)] = (2147483647));

(statearr_28518_28642[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (61))){
var inst_28361 = (state_28454[(18)]);
var state_28454__$1 = state_28454;
var statearr_28519_28643 = state_28454__$1;
(statearr_28519_28643[(2)] = inst_28361);

(statearr_28519_28643[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (29))){
var inst_28288 = (state_28454[(47)]);
var state_28454__$1 = state_28454;
var statearr_28520_28644 = state_28454__$1;
(statearr_28520_28644[(2)] = inst_28288);

(statearr_28520_28644[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (44))){
var state_28454__$1 = state_28454;
var statearr_28521_28645 = state_28454__$1;
(statearr_28521_28645[(2)] = fluree.db.util.core.min_integer);

(statearr_28521_28645[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (6))){
var inst_28230 = (state_28454[(14)]);
var inst_28245 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_28230);
var state_28454__$1 = state_28454;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28454__$1,(9),inst_28245);
} else {
if((state_val_28455 === (28))){
var inst_28278 = (state_28454[(21)]);
var state_28454__$1 = state_28454;
var statearr_28522_28646 = state_28454__$1;
(statearr_28522_28646[(2)] = inst_28278);

(statearr_28522_28646[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (64))){
var inst_28354 = (state_28454[(37)]);
var inst_28368 = (state_28454[(12)]);
var inst_28382 = cljs.core.seq(inst_28368);
var inst_28383 = cljs.core.first(inst_28382);
var inst_28384 = cljs.core.next(inst_28382);
var inst_28385 = inst_28368;
var inst_28386 = inst_28354;
var inst_28387 = inst_28368;
var state_28454__$1 = (function (){var statearr_28523 = state_28454;
(statearr_28523[(55)] = inst_28385);

(statearr_28523[(56)] = inst_28384);

(statearr_28523[(22)] = inst_28386);

(statearr_28523[(52)] = inst_28387);

(statearr_28523[(57)] = inst_28383);

return statearr_28523;
})();
var statearr_28524_28647 = state_28454__$1;
(statearr_28524_28647[(2)] = null);

(statearr_28524_28647[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (51))){
var inst_28332 = (state_28454[(2)]);
var inst_28333 = cljs.core.cst$kw$to_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var inst_28334 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_28454__$1 = (function (){var statearr_28525 = state_28454;
(statearr_28525[(39)] = inst_28333);

(statearr_28525[(44)] = inst_28332);

return statearr_28525;
})();
if(cljs.core.truth_(inst_28334)){
var statearr_28526_28648 = state_28454__$1;
(statearr_28526_28648[(1)] = (52));

} else {
var statearr_28527_28649 = state_28454__$1;
(statearr_28527_28649[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (25))){
var state_28454__$1 = state_28454;
var statearr_28528_28650 = state_28454__$1;
(statearr_28528_28650[(2)] = (-1));

(statearr_28528_28650[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (34))){
var inst_28235 = (state_28454[(54)]);
var state_28454__$1 = state_28454;
var statearr_28529_28651 = state_28454__$1;
(statearr_28529_28651[(2)] = inst_28235);

(statearr_28529_28651[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (17))){
var inst_28265 = (state_28454[(2)]);
var inst_28266 = fluree.db.util.async.throw_err(inst_28265);
var state_28454__$1 = state_28454;
var statearr_28530_28652 = state_28454__$1;
(statearr_28530_28652[(2)] = inst_28266);

(statearr_28530_28652[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (3))){
var inst_28452 = (state_28454[(2)]);
var state_28454__$1 = state_28454;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28454__$1,inst_28452);
} else {
if((state_val_28455 === (12))){
var inst_28232 = (state_28454[(50)]);
var inst_28260 = (state_28454[(2)]);
var inst_28261 = fluree.db.util.core.pred_ident_QMARK_(inst_28232);
var state_28454__$1 = (function (){var statearr_28531 = state_28454;
(statearr_28531[(26)] = inst_28260);

return statearr_28531;
})();
if(inst_28261){
var statearr_28532_28653 = state_28454__$1;
(statearr_28532_28653[(1)] = (14));

} else {
var statearr_28533_28654 = state_28454__$1;
(statearr_28533_28654[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (2))){
var inst_28230 = (state_28454[(14)]);
var inst_28229 = (state_28454[(36)]);
var inst_28236 = (state_28454[(42)]);
var _ = (function (){var statearr_28534 = state_28454;
(statearr_28534[(4)] = cljs.core.cons((5),(state_28454[(4)])));

return statearr_28534;
})();
var inst_28229__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_28230__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28229__$1,(0),null);
var inst_28231 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28229__$1,(1),null);
var inst_28232 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28229__$1,(2),null);
var inst_28233 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28229__$1,(3),null);
var inst_28234 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28229__$1,(4),null);
var inst_28235 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28229__$1,(5),null);
var inst_28236__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_28237 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28236__$1,(0),null);
var inst_28238 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28236__$1,(1),null);
var inst_28239 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28236__$1,(2),null);
var inst_28240 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28236__$1,(3),null);
var inst_28241 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28236__$1,(4),null);
var inst_28242 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28236__$1,(5),null);
var inst_28243 = fluree.db.util.core.pred_ident_QMARK_(inst_28230__$1);
var state_28454__$1 = (function (){var statearr_28535 = state_28454;
(statearr_28535[(46)] = inst_28238);

(statearr_28535[(24)] = inst_28234);

(statearr_28535[(58)] = inst_28239);

(statearr_28535[(29)] = inst_28241);

(statearr_28535[(14)] = inst_28230__$1);

(statearr_28535[(36)] = inst_28229__$1);

(statearr_28535[(59)] = inst_28237);

(statearr_28535[(38)] = inst_28240);

(statearr_28535[(54)] = inst_28235);

(statearr_28535[(50)] = inst_28232);

(statearr_28535[(53)] = inst_28242);

(statearr_28535[(42)] = inst_28236__$1);

(statearr_28535[(43)] = inst_28233);

(statearr_28535[(20)] = inst_28231);

return statearr_28535;
})();
if(inst_28243){
var statearr_28536_28655 = state_28454__$1;
(statearr_28536_28655[(1)] = (6));

} else {
var statearr_28537_28656 = state_28454__$1;
(statearr_28537_28656[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (66))){
var inst_28385 = (state_28454[(55)]);
var inst_28395 = (state_28454[(60)]);
var inst_28393 = (state_28454[(13)]);
var inst_28392 = cljs.core.seq(inst_28385);
var inst_28393__$1 = cljs.core.first(inst_28392);
var inst_28394 = cljs.core.next(inst_28392);
var inst_28395__$1 = (inst_28393__$1 == null);
var state_28454__$1 = (function (){var statearr_28538 = state_28454;
(statearr_28538[(61)] = inst_28394);

(statearr_28538[(60)] = inst_28395__$1);

(statearr_28538[(13)] = inst_28393__$1);

return statearr_28538;
})();
if(cljs.core.truth_(inst_28395__$1)){
var statearr_28539_28657 = state_28454__$1;
(statearr_28539_28657[(1)] = (68));

} else {
var statearr_28540_28658 = state_28454__$1;
(statearr_28540_28658[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (23))){
var inst_28279 = (state_28454[(19)]);
var state_28454__$1 = state_28454;
var statearr_28541_28659 = state_28454__$1;
(statearr_28541_28659[(2)] = inst_28279);

(statearr_28541_28659[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (47))){
var state_28454__$1 = state_28454;
var statearr_28542_28660 = state_28454__$1;
(statearr_28542_28660[(2)] = fluree.db.util.core.max_long);

(statearr_28542_28660[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (35))){
var inst_28299 = (cljs.core._GT__EQ_ === start_test);
var state_28454__$1 = state_28454;
if(cljs.core.truth_(inst_28299)){
var statearr_28543_28661 = state_28454__$1;
(statearr_28543_28661[(1)] = (37));

} else {
var statearr_28544_28662 = state_28454__$1;
(statearr_28544_28662[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (82))){
var inst_28369 = (state_28454[(8)]);
var state_28454__$1 = state_28454;
var statearr_28545_28663 = state_28454__$1;
(statearr_28545_28663[(2)] = inst_28369);

(statearr_28545_28663[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (76))){
var inst_28404 = (state_28454[(23)]);
var inst_28394 = (state_28454[(61)]);
var inst_28418 = (state_28454[(2)]);
var inst_28385 = inst_28394;
var inst_28386 = inst_28404;
var inst_28387 = inst_28418;
var state_28454__$1 = (function (){var statearr_28546 = state_28454;
(statearr_28546[(55)] = inst_28385);

(statearr_28546[(22)] = inst_28386);

(statearr_28546[(52)] = inst_28387);

return statearr_28546;
})();
var statearr_28547_28664 = state_28454__$1;
(statearr_28547_28664[(2)] = null);

(statearr_28547_28664[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (19))){
var inst_28239 = (state_28454[(58)]);
var state_28454__$1 = state_28454;
var statearr_28548_28665 = state_28454__$1;
(statearr_28548_28665[(2)] = inst_28239);

(statearr_28548_28665[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (57))){
var inst_28353 = (state_28454[(10)]);
var inst_28333 = (state_28454[(39)]);
var inst_28343 = (state_28454[(41)]);
var inst_28332 = (state_28454[(44)]);
var inst_28357 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_28353,inst_28332,inst_28333,inst_28343);
var state_28454__$1 = state_28454;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28454__$1,(59),inst_28357);
} else {
if((state_val_28455 === (68))){
var inst_28395 = (state_28454[(60)]);
var state_28454__$1 = state_28454;
var statearr_28549_28666 = state_28454__$1;
(statearr_28549_28666[(2)] = inst_28395);

(statearr_28549_28666[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (11))){
var inst_28237 = (state_28454[(59)]);
var state_28454__$1 = state_28454;
var statearr_28551_28667 = state_28454__$1;
(statearr_28551_28667[(2)] = inst_28237);

(statearr_28551_28667[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (9))){
var inst_28247 = (state_28454[(2)]);
var inst_28248 = fluree.db.util.async.throw_err(inst_28247);
var state_28454__$1 = state_28454;
var statearr_28552_28668 = state_28454__$1;
(statearr_28552_28668[(2)] = inst_28248);

(statearr_28552_28668[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (5))){
var _ = (function (){var statearr_28553 = state_28454;
(statearr_28553[(4)] = cljs.core.rest((state_28454[(4)])));

return statearr_28553;
})();
var state_28454__$1 = state_28454;
var ex28550 = (state_28454__$1[(2)]);
var statearr_28554_28669 = state_28454__$1;
(statearr_28554_28669[(5)] = ex28550);


if((ex28550 instanceof Error)){
var statearr_28555_28670 = state_28454__$1;
(statearr_28555_28670[(1)] = (4));

(statearr_28555_28670[(5)] = null);

} else {
throw ex28550;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (83))){
var inst_28437 = (state_28454[(2)]);
var inst_28438 = cljs.core.not(inst_28437);
var state_28454__$1 = state_28454;
if(inst_28438){
var statearr_28556_28671 = state_28454__$1;
(statearr_28556_28671[(1)] = (87));

} else {
var statearr_28557_28672 = state_28454__$1;
(statearr_28557_28672[(1)] = (88));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (14))){
var inst_28232 = (state_28454[(50)]);
var inst_28263 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_28232);
var state_28454__$1 = state_28454;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28454__$1,(17),inst_28263);
} else {
if((state_val_28455 === (45))){
var inst_28312 = (state_28454[(2)]);
var state_28454__$1 = state_28454;
var statearr_28558_28673 = state_28454__$1;
(statearr_28558_28673[(2)] = inst_28312);

(statearr_28558_28673[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (53))){
var state_28454__$1 = state_28454;
var statearr_28559_28674 = state_28454__$1;
(statearr_28559_28674[(2)] = true);

(statearr_28559_28674[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (78))){
var inst_28387 = (state_28454[(52)]);
var state_28454__$1 = state_28454;
var statearr_28560_28675 = state_28454__$1;
(statearr_28560_28675[(2)] = inst_28387);

(statearr_28560_28675[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (26))){
var inst_28231 = (state_28454[(20)]);
var state_28454__$1 = state_28454;
var statearr_28561_28676 = state_28454__$1;
(statearr_28561_28676[(2)] = inst_28231);

(statearr_28561_28676[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (16))){
var inst_28239 = (state_28454[(58)]);
var inst_28269 = (state_28454[(2)]);
var inst_28270 = fluree.db.util.core.pred_ident_QMARK_(inst_28239);
var state_28454__$1 = (function (){var statearr_28562 = state_28454;
(statearr_28562[(28)] = inst_28269);

return statearr_28562;
})();
if(inst_28270){
var statearr_28563_28677 = state_28454__$1;
(statearr_28563_28677[(1)] = (18));

} else {
var statearr_28564_28678 = state_28454__$1;
(statearr_28564_28678[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (81))){
var inst_28326 = (state_28454[(30)]);
var inst_28429 = (state_28454[(48)]);
var inst_28316 = (state_28454[(17)]);
var inst_28369 = (state_28454[(8)]);
var inst_28428 = (inst_28326.cljs$core$IFn$_invoke$arity$2 ? inst_28326.cljs$core$IFn$_invoke$arity$2(inst_28369,inst_28316) : inst_28326.call(null,inst_28369,inst_28316));
var inst_28429__$1 = (inst_28428 < (0));
var state_28454__$1 = (function (){var statearr_28565 = state_28454;
(statearr_28565[(48)] = inst_28429__$1);

return statearr_28565;
})();
if(cljs.core.truth_(inst_28429__$1)){
var statearr_28566_28679 = state_28454__$1;
(statearr_28566_28679[(1)] = (84));

} else {
var statearr_28567_28680 = state_28454__$1;
(statearr_28567_28680[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (79))){
var inst_28387 = (state_28454[(52)]);
var inst_28393 = (state_28454[(13)]);
var inst_28413 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(inst_28387,inst_28393);
var state_28454__$1 = state_28454;
var statearr_28568_28681 = state_28454__$1;
(statearr_28568_28681[(2)] = inst_28413);

(statearr_28568_28681[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (38))){
var state_28454__$1 = state_28454;
var statearr_28569_28682 = state_28454__$1;
(statearr_28569_28682[(2)] = (2147483647));

(statearr_28569_28682[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (87))){
var inst_28425 = (state_28454[(7)]);
var state_28454__$1 = state_28454;
var statearr_28570_28683 = state_28454__$1;
(statearr_28570_28683[(2)] = inst_28425);

(statearr_28570_28683[(1)] = (89));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (30))){
var inst_28292 = (state_28454[(2)]);
var state_28454__$1 = state_28454;
if(cljs.core.truth_(inst_28292)){
var statearr_28571_28684 = state_28454__$1;
(statearr_28571_28684[(1)] = (31));

} else {
var statearr_28572_28685 = state_28454__$1;
(statearr_28572_28685[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (73))){
var inst_28421 = (state_28454[(2)]);
var state_28454__$1 = state_28454;
var statearr_28573_28686 = state_28454__$1;
(statearr_28573_28686[(2)] = inst_28421);

(statearr_28573_28686[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (10))){
var inst_28237 = (state_28454[(59)]);
var inst_28254 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_28237);
var state_28454__$1 = state_28454;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28454__$1,(13),inst_28254);
} else {
if((state_val_28455 === (18))){
var inst_28239 = (state_28454[(58)]);
var inst_28272 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_28239);
var state_28454__$1 = state_28454;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28454__$1,(21),inst_28272);
} else {
if((state_val_28455 === (52))){
var inst_28296 = (state_28454[(25)]);
var inst_28260 = (state_28454[(26)]);
var inst_28322 = (state_28454[(31)]);
var inst_28287 = (state_28454[(32)]);
var inst_28251 = (state_28454[(45)]);
var inst_28336 = fluree.db.permissions_validate.no_filter_QMARK_(inst_28322,inst_28251,inst_28260,inst_28287,inst_28296);
var state_28454__$1 = state_28454;
var statearr_28574_28687 = state_28454__$1;
(statearr_28574_28687[(2)] = inst_28336);

(statearr_28574_28687[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (67))){
var inst_28423 = (state_28454[(2)]);
var state_28454__$1 = state_28454;
var statearr_28575_28688 = state_28454__$1;
(statearr_28575_28688[(2)] = inst_28423);

(statearr_28575_28688[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (71))){
var inst_28355 = (state_28454[(34)]);
var inst_28387 = (state_28454[(52)]);
var inst_28402 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_28387,inst_28355);
var state_28454__$1 = state_28454;
var statearr_28576_28689 = state_28454__$1;
(statearr_28576_28689[(2)] = inst_28402);

(statearr_28576_28689[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (42))){
var inst_28317 = (state_28454[(49)]);
var inst_28234 = (state_28454[(24)]);
var inst_28296 = (state_28454[(25)]);
var inst_28260 = (state_28454[(26)]);
var inst_28269 = (state_28454[(28)]);
var inst_28241 = (state_28454[(29)]);
var inst_28287 = (state_28454[(32)]);
var inst_28314 = (state_28454[(35)]);
var inst_28278 = (state_28454[(21)]);
var inst_28240 = (state_28454[(38)]);
var inst_28305 = (state_28454[(40)]);
var inst_28233 = (state_28454[(43)]);
var inst_28251 = (state_28454[(45)]);
var inst_28314__$1 = (state_28454[(2)]);
var inst_28315 = fluree.db.flake.__GT_Flake(inst_28251,inst_28287,inst_28269,inst_28233,inst_28234,inst_28305);
var inst_28316 = fluree.db.flake.__GT_Flake(inst_28260,inst_28296,inst_28278,inst_28240,inst_28241,inst_28314__$1);
var inst_28317__$1 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
var state_28454__$1 = (function (){var statearr_28577 = state_28454;
(statearr_28577[(49)] = inst_28317__$1);

(statearr_28577[(15)] = inst_28315);

(statearr_28577[(17)] = inst_28316);

(statearr_28577[(35)] = inst_28314__$1);

return statearr_28577;
})();
if(cljs.core.truth_(inst_28317__$1)){
var statearr_28578_28690 = state_28454__$1;
(statearr_28578_28690[(1)] = (46));

} else {
var statearr_28579_28691 = state_28454__$1;
(statearr_28579_28691[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (80))){
var inst_28415 = (state_28454[(2)]);
var state_28454__$1 = state_28454;
var statearr_28580_28692 = state_28454__$1;
(statearr_28580_28692[(2)] = inst_28415);

(statearr_28580_28692[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (37))){
var state_28454__$1 = state_28454;
var statearr_28581_28693 = state_28454__$1;
(statearr_28581_28693[(2)] = fluree.db.util.core.min_integer);

(statearr_28581_28693[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (63))){
var inst_28321 = (state_28454[(27)]);
var inst_28355 = (state_28454[(34)]);
var inst_28354 = (state_28454[(37)]);
var inst_28368 = (state_28454[(12)]);
var inst_28371 = (inst_28321 - inst_28354);
var inst_28372 = fluree.db.flake.take(inst_28371,inst_28368);
var inst_28373 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_28372,inst_28355);
var state_28454__$1 = state_28454;
var statearr_28582_28694 = state_28454__$1;
(statearr_28582_28694[(2)] = inst_28373);

(statearr_28582_28694[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (8))){
var inst_28237 = (state_28454[(59)]);
var inst_28251 = (state_28454[(2)]);
var inst_28252 = fluree.db.util.core.pred_ident_QMARK_(inst_28237);
var state_28454__$1 = (function (){var statearr_28583 = state_28454;
(statearr_28583[(45)] = inst_28251);

return statearr_28583;
})();
if(inst_28252){
var statearr_28584_28695 = state_28454__$1;
(statearr_28584_28695[(1)] = (10));

} else {
var statearr_28585_28696 = state_28454__$1;
(statearr_28585_28696[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (49))){
var inst_28327 = (state_28454[(51)]);
var state_28454__$1 = state_28454;
var statearr_28586_28697 = state_28454__$1;
(statearr_28586_28697[(2)] = inst_28327);

(statearr_28586_28697[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28455 === (84))){
var inst_28426 = (state_28454[(9)]);
var inst_28321 = (state_28454[(27)]);
var inst_28431 = (inst_28426 < inst_28321);
var state_28454__$1 = state_28454;
var statearr_28587_28698 = state_28454__$1;
(statearr_28587_28698[(2)] = inst_28431);

(statearr_28587_28698[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__15091__auto__ = null;
var fluree$db$query$range$state_machine__15091__auto____0 = (function (){
var statearr_28588 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28588[(0)] = fluree$db$query$range$state_machine__15091__auto__);

(statearr_28588[(1)] = (1));

return statearr_28588;
});
var fluree$db$query$range$state_machine__15091__auto____1 = (function (state_28454){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_28454);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e28589){var ex__15094__auto__ = e28589;
var statearr_28590_28699 = state_28454;
(statearr_28590_28699[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_28454[(4)]))){
var statearr_28591_28700 = state_28454;
(statearr_28591_28700[(1)] = cljs.core.first((state_28454[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__28701 = state_28454;
state_28454 = G__28701;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__15091__auto__ = function(state_28454){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__15091__auto____1.call(this,state_28454);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__15091__auto____0;
fluree$db$query$range$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__15091__auto____1;
return fluree$db$query$range$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_28592 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_28592[(6)] = c__15165__auto__);

return statearr_28592;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_28776){
var state_val_28777 = (state_28776[(1)]);
if((state_val_28777 === (7))){
var inst_28771 = (state_28776[(2)]);
var _ = (function (){var statearr_28778 = state_28776;
(statearr_28778[(4)] = cljs.core.rest((state_28776[(4)])));

return statearr_28778;
})();
var state_28776__$1 = state_28776;
var statearr_28779_28819 = state_28776__$1;
(statearr_28779_28819[(2)] = inst_28771);

(statearr_28779_28819[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28777 === (20))){
var inst_28753 = (state_28776[(2)]);
var inst_28754 = fluree.db.util.async.throw_err(inst_28753);
var state_28776__$1 = state_28776;
var statearr_28780_28820 = state_28776__$1;
(statearr_28780_28820[(2)] = inst_28754);

(statearr_28780_28820[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28777 === (1))){
var state_28776__$1 = state_28776;
var statearr_28781_28821 = state_28776__$1;
(statearr_28781_28821[(2)] = null);

(statearr_28781_28821[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28777 === (4))){
var inst_28702 = (state_28776[(2)]);
var state_28776__$1 = state_28776;
var statearr_28782_28822 = state_28776__$1;
(statearr_28782_28822[(2)] = inst_28702);

(statearr_28782_28822[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28777 === (15))){
var inst_28749 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_28776__$1 = state_28776;
if(cljs.core.truth_(inst_28749)){
var statearr_28783_28823 = state_28776__$1;
(statearr_28783_28823[(1)] = (17));

} else {
var statearr_28784_28824 = state_28776__$1;
(statearr_28784_28824[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28777 === (21))){
var state_28776__$1 = state_28776;
var statearr_28785_28825 = state_28776__$1;
(statearr_28785_28825[(2)] = (0));

(statearr_28785_28825[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28777 === (13))){
var inst_28741 = (state_28776[(2)]);
var state_28776__$1 = state_28776;
var statearr_28786_28826 = state_28776__$1;
(statearr_28786_28826[(2)] = inst_28741);

(statearr_28786_28826[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28777 === (22))){
var state_28776__$1 = state_28776;
var statearr_28787_28827 = state_28776__$1;
(statearr_28787_28827[(2)] = (1));

(statearr_28787_28827[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28777 === (6))){
var inst_28733 = (state_28776[(7)]);
var inst_28731 = (state_28776[(8)]);
var inst_28722 = (state_28776[(9)]);
var inst_28730 = cljs.core.seq(inst_28722);
var inst_28731__$1 = cljs.core.first(inst_28730);
var inst_28732 = cljs.core.next(inst_28730);
var inst_28733__$1 = (inst_28731__$1 == null);
var state_28776__$1 = (function (){var statearr_28788 = state_28776;
(statearr_28788[(7)] = inst_28733__$1);

(statearr_28788[(8)] = inst_28731__$1);

(statearr_28788[(10)] = inst_28732);

return statearr_28788;
})();
if(cljs.core.truth_(inst_28733__$1)){
var statearr_28789_28828 = state_28776__$1;
(statearr_28789_28828[(1)] = (8));

} else {
var statearr_28790_28829 = state_28776__$1;
(statearr_28790_28829[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28777 === (17))){
var inst_28731 = (state_28776[(8)]);
var inst_28751 = fluree.db.permissions_validate.allow_flakes_QMARK_(db,inst_28731);
var state_28776__$1 = state_28776;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28776__$1,(20),inst_28751);
} else {
if((state_val_28777 === (3))){
var inst_28774 = (state_28776[(2)]);
var state_28776__$1 = state_28776;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28776__$1,inst_28774);
} else {
if((state_val_28777 === (12))){
var inst_28724 = (state_28776[(11)]);
var inst_28739 = (inst_28724 >= subject_limit);
var state_28776__$1 = state_28776;
var statearr_28791_28830 = state_28776__$1;
(statearr_28791_28830[(2)] = inst_28739);

(statearr_28791_28830[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28777 === (2))){
var _ = (function (){var statearr_28792 = state_28776;
(statearr_28792[(4)] = cljs.core.cons((5),(state_28776[(4)])));

return statearr_28792;
})();
var inst_28715 = subject_groups;
var inst_28716 = cljs.core.seq(inst_28715);
var inst_28717 = cljs.core.first(inst_28716);
var inst_28718 = cljs.core.next(inst_28716);
var inst_28719 = flake_start;
var inst_28720 = subject_start;
var inst_28721 = cljs.core.PersistentVector.EMPTY;
var inst_28722 = inst_28715;
var inst_28723 = inst_28719;
var inst_28724 = inst_28720;
var inst_28725 = inst_28721;
var state_28776__$1 = (function (){var statearr_28793 = state_28776;
(statearr_28793[(12)] = inst_28723);

(statearr_28793[(13)] = inst_28725);

(statearr_28793[(11)] = inst_28724);

(statearr_28793[(14)] = inst_28718);

(statearr_28793[(15)] = inst_28717);

(statearr_28793[(9)] = inst_28722);

return statearr_28793;
})();
var statearr_28794_28831 = state_28776__$1;
(statearr_28794_28831[(2)] = null);

(statearr_28794_28831[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28777 === (23))){
var inst_28723 = (state_28776[(12)]);
var inst_28725 = (state_28776[(13)]);
var inst_28724 = (state_28776[(11)]);
var inst_28757 = (state_28776[(16)]);
var inst_28758 = (state_28776[(17)]);
var inst_28732 = (state_28776[(10)]);
var inst_28763 = (state_28776[(2)]);
var inst_28764 = (inst_28723 + inst_28758);
var inst_28765 = (inst_28724 + inst_28763);
var inst_28766 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_28725,inst_28757);
var inst_28722 = inst_28732;
var inst_28723__$1 = inst_28764;
var inst_28724__$1 = inst_28765;
var inst_28725__$1 = inst_28766;
var state_28776__$1 = (function (){var statearr_28795 = state_28776;
(statearr_28795[(12)] = inst_28723__$1);

(statearr_28795[(13)] = inst_28725__$1);

(statearr_28795[(11)] = inst_28724__$1);

(statearr_28795[(9)] = inst_28722);

return statearr_28795;
})();
var statearr_28796_28832 = state_28776__$1;
(statearr_28796_28832[(2)] = null);

(statearr_28796_28832[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28777 === (19))){
var inst_28757 = (state_28776[(16)]);
var inst_28758 = (state_28776[(17)]);
var inst_28757__$1 = (state_28776[(2)]);
var inst_28758__$1 = cljs.core.count(inst_28757__$1);
var inst_28759 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_28758__$1);
var state_28776__$1 = (function (){var statearr_28797 = state_28776;
(statearr_28797[(16)] = inst_28757__$1);

(statearr_28797[(17)] = inst_28758__$1);

return statearr_28797;
})();
if(inst_28759){
var statearr_28798_28833 = state_28776__$1;
(statearr_28798_28833[(1)] = (21));

} else {
var statearr_28799_28834 = state_28776__$1;
(statearr_28799_28834[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28777 === (11))){
var inst_28736 = (state_28776[(18)]);
var state_28776__$1 = state_28776;
var statearr_28801_28835 = state_28776__$1;
(statearr_28801_28835[(2)] = inst_28736);

(statearr_28801_28835[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28777 === (9))){
var inst_28723 = (state_28776[(12)]);
var inst_28736 = (state_28776[(18)]);
var inst_28736__$1 = (inst_28723 >= flake_limit);
var state_28776__$1 = (function (){var statearr_28802 = state_28776;
(statearr_28802[(18)] = inst_28736__$1);

return statearr_28802;
})();
if(cljs.core.truth_(inst_28736__$1)){
var statearr_28803_28836 = state_28776__$1;
(statearr_28803_28836[(1)] = (11));

} else {
var statearr_28804_28837 = state_28776__$1;
(statearr_28804_28837[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28777 === (5))){
var _ = (function (){var statearr_28805 = state_28776;
(statearr_28805[(4)] = cljs.core.rest((state_28776[(4)])));

return statearr_28805;
})();
var state_28776__$1 = state_28776;
var ex28800 = (state_28776__$1[(2)]);
var statearr_28806_28838 = state_28776__$1;
(statearr_28806_28838[(5)] = ex28800);


if((ex28800 instanceof Error)){
var statearr_28807_28839 = state_28776__$1;
(statearr_28807_28839[(1)] = (4));

(statearr_28807_28839[(5)] = null);

} else {
throw ex28800;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28777 === (14))){
var inst_28723 = (state_28776[(12)]);
var inst_28725 = (state_28776[(13)]);
var inst_28724 = (state_28776[(11)]);
var inst_28745 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28746 = [inst_28723,inst_28724,inst_28725];
var inst_28747 = (new cljs.core.PersistentVector(null,3,(5),inst_28745,inst_28746,null));
var state_28776__$1 = state_28776;
var statearr_28808_28840 = state_28776__$1;
(statearr_28808_28840[(2)] = inst_28747);

(statearr_28808_28840[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28777 === (16))){
var inst_28769 = (state_28776[(2)]);
var state_28776__$1 = state_28776;
var statearr_28809_28841 = state_28776__$1;
(statearr_28809_28841[(2)] = inst_28769);

(statearr_28809_28841[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28777 === (10))){
var inst_28743 = (state_28776[(2)]);
var state_28776__$1 = state_28776;
if(cljs.core.truth_(inst_28743)){
var statearr_28810_28842 = state_28776__$1;
(statearr_28810_28842[(1)] = (14));

} else {
var statearr_28811_28843 = state_28776__$1;
(statearr_28811_28843[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28777 === (18))){
var inst_28731 = (state_28776[(8)]);
var state_28776__$1 = state_28776;
var statearr_28812_28844 = state_28776__$1;
(statearr_28812_28844[(2)] = inst_28731);

(statearr_28812_28844[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28777 === (8))){
var inst_28733 = (state_28776[(7)]);
var state_28776__$1 = state_28776;
var statearr_28813_28845 = state_28776__$1;
(statearr_28813_28845[(2)] = inst_28733);

(statearr_28813_28845[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__15091__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__15091__auto____0 = (function (){
var statearr_28814 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28814[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__15091__auto__);

(statearr_28814[(1)] = (1));

return statearr_28814;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__15091__auto____1 = (function (state_28776){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_28776);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e28815){var ex__15094__auto__ = e28815;
var statearr_28816_28846 = state_28776;
(statearr_28816_28846[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_28776[(4)]))){
var statearr_28817_28847 = state_28776;
(statearr_28817_28847[(1)] = cljs.core.first((state_28776[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__28848 = state_28776;
state_28776 = G__28848;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__15091__auto__ = function(state_28776){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__15091__auto____1.call(this,state_28776);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__15091__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__15091__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_28818 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_28818[(6)] = c__15165__auto__);

return statearr_28818;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_28894){
var state_val_28895 = (state_28894[(1)]);
if((state_val_28895 === (7))){
var state_28894__$1 = state_28894;
var statearr_28896_28934 = state_28894__$1;
(statearr_28896_28934[(2)] = null);

(statearr_28896_28934[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28895 === (20))){
var inst_28880 = (state_28894[(2)]);
var inst_28881 = fluree.db.util.async.throw_err(inst_28880);
var inst_28859 = inst_28881;
var state_28894__$1 = (function (){var statearr_28897 = state_28894;
(statearr_28897[(7)] = inst_28859);

return statearr_28897;
})();
var statearr_28898_28935 = state_28894__$1;
(statearr_28898_28935[(2)] = null);

(statearr_28898_28935[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28895 === (1))){
var state_28894__$1 = state_28894;
var statearr_28899_28936 = state_28894__$1;
(statearr_28899_28936[(2)] = null);

(statearr_28899_28936[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28895 === (4))){
var inst_28849 = (state_28894[(2)]);
var state_28894__$1 = state_28894;
var statearr_28900_28937 = state_28894__$1;
(statearr_28900_28937[(2)] = inst_28849);

(statearr_28900_28937[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28895 === (15))){
var inst_28859 = (state_28894[(7)]);
var inst_28876 = (state_28894[(8)]);
var inst_28876__$1 = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(inst_28859);
var state_28894__$1 = (function (){var statearr_28901 = state_28894;
(statearr_28901[(8)] = inst_28876__$1);

return statearr_28901;
})();
if(cljs.core.truth_(inst_28876__$1)){
var statearr_28902_28938 = state_28894__$1;
(statearr_28902_28938[(1)] = (17));

} else {
var statearr_28903_28939 = state_28894__$1;
(statearr_28903_28939[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28895 === (13))){
var inst_28869 = (state_28894[(2)]);
var inst_28870 = fluree.db.util.async.throw_err(inst_28869);
var _ = (function (){var statearr_28904 = state_28894;
(statearr_28904[(4)] = cljs.core.rest((state_28894[(4)])));

return statearr_28904;
})();
var state_28894__$1 = state_28894;
var statearr_28905_28940 = state_28894__$1;
(statearr_28905_28940[(2)] = inst_28870);

(statearr_28905_28940[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28895 === (6))){
var inst_28857 = (state_28894[(2)]);
var inst_28858 = fluree.db.util.async.throw_err(inst_28857);
var inst_28859 = inst_28858;
var state_28894__$1 = (function (){var statearr_28906 = state_28894;
(statearr_28906[(7)] = inst_28859);

return statearr_28906;
})();
var statearr_28907_28941 = state_28894__$1;
(statearr_28907_28941[(2)] = null);

(statearr_28907_28941[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28895 === (17))){
var inst_28876 = (state_28894[(8)]);
var inst_28878 = fluree.db.dbproto._lookup_leaf(root_node,inst_28876);
var state_28894__$1 = state_28894;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28894__$1,(20),inst_28878);
} else {
if((state_val_28895 === (3))){
var inst_28892 = (state_28894[(2)]);
var state_28894__$1 = state_28894;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28894__$1,inst_28892);
} else {
if((state_val_28895 === (12))){
var _ = (function (){var statearr_28909 = state_28894;
(statearr_28909[(4)] = cljs.core.rest((state_28894[(4)])));

return statearr_28909;
})();
var state_28894__$1 = state_28894;
var ex28908 = (state_28894__$1[(2)]);
var statearr_28910_28942 = state_28894__$1;
(statearr_28910_28942[(5)] = ex28908);


var statearr_28911_28943 = state_28894__$1;
(statearr_28911_28943[(1)] = (11));

(statearr_28911_28943[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_28895 === (2))){
var _ = (function (){var statearr_28912 = state_28894;
(statearr_28912[(4)] = cljs.core.cons((5),(state_28894[(4)])));

return statearr_28912;
})();
var inst_28855 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_28894__$1 = state_28894;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28894__$1,(6),inst_28855);
} else {
if((state_val_28895 === (19))){
var inst_28885 = (state_28894[(2)]);
var state_28894__$1 = state_28894;
var statearr_28913_28944 = state_28894__$1;
(statearr_28913_28944[(2)] = inst_28885);

(statearr_28913_28944[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28895 === (11))){
var inst_28861 = (state_28894[(2)]);
var state_28894__$1 = (function (){var statearr_28915 = state_28894;
(statearr_28915[(9)] = inst_28861);

return statearr_28915;
})();
var statearr_28916_28945 = state_28894__$1;
(statearr_28916_28945[(2)] = null);

(statearr_28916_28945[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28895 === (9))){
var inst_28859 = (state_28894[(7)]);
var _ = (function (){var statearr_28917 = state_28894;
(statearr_28917[(4)] = cljs.core.cons((12),(state_28894[(4)])));

return statearr_28917;
})();
var inst_28867 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_28859,t,novelty,fast_forward_db_QMARK_);
var state_28894__$1 = state_28894;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28894__$1,(13),inst_28867);
} else {
if((state_val_28895 === (5))){
var _ = (function (){var statearr_28918 = state_28894;
(statearr_28918[(4)] = cljs.core.rest((state_28894[(4)])));

return statearr_28918;
})();
var state_28894__$1 = state_28894;
var ex28914 = (state_28894__$1[(2)]);
var statearr_28919_28946 = state_28894__$1;
(statearr_28919_28946[(5)] = ex28914);


if((ex28914 instanceof Error)){
var statearr_28920_28947 = state_28894__$1;
(statearr_28920_28947[(1)] = (4));

(statearr_28920_28947[(5)] = null);

} else {
throw ex28914;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28895 === (14))){
var inst_28873 = (state_28894[(10)]);
var state_28894__$1 = state_28894;
var statearr_28921_28948 = state_28894__$1;
(statearr_28921_28948[(2)] = inst_28873);

(statearr_28921_28948[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28895 === (16))){
var inst_28887 = (state_28894[(2)]);
var state_28894__$1 = state_28894;
var statearr_28922_28949 = state_28894__$1;
(statearr_28922_28949[(2)] = inst_28887);

(statearr_28922_28949[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28895 === (10))){
var inst_28873 = (state_28894[(10)]);
var inst_28873__$1 = (state_28894[(2)]);
var state_28894__$1 = (function (){var statearr_28923 = state_28894;
(statearr_28923[(10)] = inst_28873__$1);

return statearr_28923;
})();
if(cljs.core.truth_(inst_28873__$1)){
var statearr_28924_28950 = state_28894__$1;
(statearr_28924_28950[(1)] = (14));

} else {
var statearr_28925_28951 = state_28894__$1;
(statearr_28925_28951[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28895 === (18))){
var state_28894__$1 = state_28894;
var statearr_28926_28952 = state_28894__$1;
(statearr_28926_28952[(2)] = null);

(statearr_28926_28952[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28895 === (8))){
var inst_28889 = (state_28894[(2)]);
var _ = (function (){var statearr_28927 = state_28894;
(statearr_28927[(4)] = cljs.core.rest((state_28894[(4)])));

return statearr_28927;
})();
var state_28894__$1 = state_28894;
var statearr_28928_28953 = state_28894__$1;
(statearr_28928_28953[(2)] = inst_28889);

(statearr_28928_28953[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__15091__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__15091__auto____0 = (function (){
var statearr_28929 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28929[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__15091__auto__);

(statearr_28929[(1)] = (1));

return statearr_28929;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__15091__auto____1 = (function (state_28894){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_28894);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e28930){var ex__15094__auto__ = e28930;
var statearr_28931_28954 = state_28894;
(statearr_28931_28954[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_28894[(4)]))){
var statearr_28932_28955 = state_28894;
(statearr_28932_28955[(1)] = cljs.core.first((state_28894[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__28956 = state_28894;
state_28894 = G__28956;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__15091__auto__ = function(state_28894){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__15091__auto____1.call(this,state_28894);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__15091__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__15091__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_28933 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_28933[(6)] = c__15165__auto__);

return statearr_28933;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__28963 = arguments.length;
switch (G__28963) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__28964 = (function (){var pred__28967 = cljs.core.identical_QMARK_;
var expr__28968 = test;
if(cljs.core.truth_((pred__28967.cljs$core$IFn$_invoke$arity$2 ? pred__28967.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__28968) : pred__28967.call(null,cljs.core._EQ_,expr__28968)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__28967.cljs$core$IFn$_invoke$arity$2 ? pred__28967.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__28968) : pred__28967.call(null,cljs.core._LT_,expr__28968)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__28967.cljs$core$IFn$_invoke$arity$2 ? pred__28967.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__28968) : pred__28967.call(null,cljs.core._LT__EQ_,expr__28968)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__28967.cljs$core$IFn$_invoke$arity$2 ? pred__28967.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__28968) : pred__28967.call(null,cljs.core._GT_,expr__28968)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__28967.cljs$core$IFn$_invoke$arity$2 ? pred__28967.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__28968) : pred__28967.call(null,cljs.core._GT__EQ_,expr__28968)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__28968)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28964,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28964,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28964,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28964,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_29340){
var state_val_29341 = (state_29340[(1)]);
if((state_val_29341 === (121))){
var inst_29296 = (state_29340[(7)]);
var state_29340__$1 = state_29340;
var statearr_29342_29538 = state_29340__$1;
(statearr_29342_29538[(2)] = inst_29296);

(statearr_29342_29538[(1)] = (123));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (65))){
var inst_29148 = (state_29340[(8)]);
var inst_29154 = (state_29340[(2)]);
var state_29340__$1 = (function (){var statearr_29343 = state_29340;
(statearr_29343[(9)] = inst_29154);

return statearr_29343;
})();
if(cljs.core.truth_(inst_29148)){
var statearr_29344_29539 = state_29340__$1;
(statearr_29344_29539[(1)] = (66));

} else {
var statearr_29345_29540 = state_29340__$1;
(statearr_29345_29540[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (70))){
var inst_29332 = (state_29340[(2)]);
var state_29340__$1 = state_29340;
var statearr_29346_29541 = state_29340__$1;
(statearr_29346_29541[(2)] = inst_29332);

(statearr_29346_29541[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (62))){
var inst_29147 = (state_29340[(2)]);
var inst_29148 = fluree.db.util.async.throw_err(inst_29147);
var inst_29149 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_29340__$1 = (function (){var statearr_29347 = state_29340;
(statearr_29347[(8)] = inst_29148);

return statearr_29347;
})();
if(cljs.core.truth_(inst_29149)){
var statearr_29348_29542 = state_29340__$1;
(statearr_29348_29542[(1)] = (63));

} else {
var statearr_29349_29543 = state_29340__$1;
(statearr_29349_29543[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (74))){
var inst_29139 = (state_29340[(10)]);
var inst_29001 = (state_29340[(11)]);
var inst_29127 = (state_29340[(12)]);
var inst_29116 = (state_29340[(13)]);
var inst_29062 = (state_29340[(14)]);
var inst_28994 = (state_29340[(15)]);
var inst_29158 = (state_29340[(16)]);
var inst_29107 = (state_29340[(17)]);
var inst_29161 = (state_29340[(18)]);
var inst_29121 = (state_29340[(19)]);
var inst_29138 = (state_29340[(20)]);
var inst_29128 = (state_29340[(21)]);
var inst_29118 = (state_29340[(22)]);
var inst_29007 = (state_29340[(23)]);
var inst_29133 = (state_29340[(24)]);
var inst_29148 = (state_29340[(8)]);
var inst_29080 = (state_29340[(25)]);
var inst_28997 = (state_29340[(26)]);
var inst_29098 = (state_29340[(27)]);
var inst_29134 = (state_29340[(28)]);
var inst_29005 = (state_29340[(29)]);
var inst_29026 = (state_29340[(30)]);
var inst_29002 = (state_29340[(31)]);
var inst_29154 = (state_29340[(9)]);
var inst_29129 = (state_29340[(32)]);
var inst_28995 = (state_29340[(33)]);
var inst_29159 = (state_29340[(34)]);
var inst_29157 = (state_29340[(35)]);
var inst_29167 = (state_29340[(36)]);
var inst_29120 = (state_29340[(37)]);
var inst_29017 = (state_29340[(38)]);
var inst_29117 = (state_29340[(39)]);
var inst_29071 = (state_29340[(40)]);
var inst_28990 = (state_29340[(41)]);
var inst_29089 = (state_29340[(42)]);
var inst_29144 = (state_29340[(43)]);
var inst_29160 = (state_29340[(44)]);
var inst_29175 = (state_29340[(45)]);
var inst_29058 = (state_29340[(46)]);
var inst_29059 = (state_29340[(47)]);
var inst_29006 = (state_29340[(48)]);
var inst_29177 = (function (){var no_filter_QMARK_ = inst_29154;
var t = inst_29134;
var max_limit_QMARK_ = inst_29128;
var next_node = inst_29157;
var map__28982 = inst_29005;
var fast_forward_db_QMARK_ = inst_29139;
var s1 = inst_29017;
var o2 = inst_29080;
var t1 = inst_28994;
var predicate_fn = inst_29007;
var i = inst_29159;
var m1 = inst_29107;
var root_node = inst_29144;
var s2 = inst_29026;
var p2 = inst_29098;
var map__28989 = inst_29120;
var permissions = inst_29129;
var G__29168 = inst_29175;
var limit = inst_29127;
var start_flake = inst_29117;
var vec__28986 = inst_29059;
var flake_limit = inst_29121;
var vec__28983 = inst_29058;
var offset = inst_29158;
var acc = inst_29161;
var t2 = inst_29001;
var op1 = inst_28995;
var o1 = inst_29071;
var end_flake = inst_29118;
var base_result = inst_29167;
var s = inst_29160;
var node_start = inst_29148;
var p1 = inst_29089;
var subject_fn = inst_29006;
var vec__28976 = inst_28990;
var object_fn = inst_29062;
var idx_compare = inst_29133;
var vec__28979 = inst_28997;
var op2 = inst_29002;
var m2 = inst_29116;
var novelty = inst_29138;
return (function (p1__28958_SHARP_){
var G__29350 = p1__28958_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__29350) : subject_fn.call(null,G__29350));
});
})();
var inst_29178 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_29177,inst_29175);
var state_29340__$1 = state_29340;
var statearr_29351_29544 = state_29340__$1;
(statearr_29351_29544[(2)] = inst_29178);

(statearr_29351_29544[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (110))){
var inst_29309 = (state_29340[(2)]);
var state_29340__$1 = state_29340;
var statearr_29352_29545 = state_29340__$1;
(statearr_29352_29545[(2)] = inst_29309);

(statearr_29352_29545[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (7))){
var inst_28991 = (state_29340[(49)]);
var state_29340__$1 = state_29340;
var statearr_29353_29546 = state_29340__$1;
(statearr_29353_29546[(2)] = inst_28991);

(statearr_29353_29546[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (59))){
var state_29340__$1 = state_29340;
var statearr_29354_29547 = state_29340__$1;
(statearr_29354_29547[(2)] = fluree.db.util.core.max_long);

(statearr_29354_29547[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (86))){
var inst_29154 = (state_29340[(9)]);
var state_29340__$1 = state_29340;
var statearr_29355_29548 = state_29340__$1;
(statearr_29355_29548[(2)] = inst_29154);

(statearr_29355_29548[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (20))){
var state_29340__$1 = state_29340;
var statearr_29356_29549 = state_29340__$1;
(statearr_29356_29549[(2)] = null);

(statearr_29356_29549[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (72))){
var inst_29167 = (state_29340[(36)]);
var state_29340__$1 = state_29340;
var statearr_29357_29550 = state_29340__$1;
(statearr_29357_29550[(2)] = inst_29167);

(statearr_29357_29550[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (58))){
var inst_29122 = (state_29340[(50)]);
var state_29340__$1 = state_29340;
var statearr_29358_29551 = state_29340__$1;
(statearr_29358_29551[(2)] = inst_29122);

(statearr_29358_29551[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (60))){
var inst_29127 = (state_29340[(12)]);
var inst_29127__$1 = (state_29340[(2)]);
var inst_29128 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29127__$1,fluree.db.util.core.max_long);
var inst_29129 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_29130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29131 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_29132 = (new cljs.core.PersistentVector(null,3,(5),inst_29130,inst_29131,null));
var inst_29133 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_29132);
var inst_29134 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_29135 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29136 = [cljs.core.cst$kw$novelty,idx];
var inst_29137 = (new cljs.core.PersistentVector(null,2,(5),inst_29135,inst_29136,null));
var inst_29138 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_29137);
var inst_29139 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var inst_29140 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_29141 = fluree.db.dbproto._resolve(inst_29140);
var state_29340__$1 = (function (){var statearr_29359 = state_29340;
(statearr_29359[(10)] = inst_29139);

(statearr_29359[(12)] = inst_29127__$1);

(statearr_29359[(20)] = inst_29138);

(statearr_29359[(21)] = inst_29128);

(statearr_29359[(24)] = inst_29133);

(statearr_29359[(28)] = inst_29134);

(statearr_29359[(32)] = inst_29129);

return statearr_29359;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29340__$1,(61),inst_29141);
} else {
if((state_val_29341 === (27))){
var inst_29060 = (state_29340[(51)]);
var state_29340__$1 = state_29340;
var statearr_29360_29552 = state_29340__$1;
(statearr_29360_29552[(2)] = inst_29060);

(statearr_29360_29552[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (1))){
var state_29340__$1 = state_29340;
var statearr_29361_29553 = state_29340__$1;
(statearr_29361_29553[(2)] = null);

(statearr_29361_29553[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (69))){
var inst_29118 = (state_29340[(22)]);
var inst_29157 = (state_29340[(35)]);
var inst_29117 = (state_29340[(39)]);
var inst_29166 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_29157);
var inst_29167 = fluree.db.flake.subrange(inst_29166,start_test,inst_29117,end_test,inst_29118);
var inst_29169 = fluree.db.query.range.value_with_nil_pred(idx,inst_29117,inst_29118);
var state_29340__$1 = (function (){var statearr_29362 = state_29340;
(statearr_29362[(36)] = inst_29167);

return statearr_29362;
})();
if(inst_29169){
var statearr_29363_29554 = state_29340__$1;
(statearr_29363_29554[(1)] = (71));

} else {
var statearr_29364_29555 = state_29340__$1;
(statearr_29364_29555[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (101))){
var inst_29254 = (state_29340[(52)]);
var inst_29121 = (state_29340[(19)]);
var inst_29255 = (state_29340[(53)]);
var inst_29253 = (state_29340[(54)]);
var inst_29258 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29259 = (inst_29255 - inst_29121);
var inst_29260 = (inst_29254 - inst_29259);
var inst_29261 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_29260,inst_29253);
var inst_29262 = [inst_29121,inst_29261];
var inst_29263 = (new cljs.core.PersistentVector(null,2,(5),inst_29258,inst_29262,null));
var state_29340__$1 = state_29340;
var statearr_29365_29556 = state_29340__$1;
(statearr_29365_29556[(2)] = inst_29263);

(statearr_29365_29556[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (24))){
var inst_29000 = (state_29340[(55)]);
var inst_29001 = (state_29340[(11)]);
var inst_28996 = (state_29340[(56)]);
var inst_28994 = (state_29340[(15)]);
var inst_29008 = (state_29340[(57)]);
var inst_29007 = (state_29340[(23)]);
var inst_28997 = (state_29340[(26)]);
var inst_29005 = (state_29340[(29)]);
var inst_29026 = (state_29340[(30)]);
var inst_29040 = (state_29340[(58)]);
var inst_29002 = (state_29340[(31)]);
var inst_28995 = (state_29340[(33)]);
var inst_28993 = (state_29340[(59)]);
var inst_29017 = (state_29340[(38)]);
var inst_28992 = (state_29340[(60)]);
var inst_28990 = (state_29340[(41)]);
var inst_28999 = (state_29340[(61)]);
var inst_29003 = (state_29340[(62)]);
var inst_29006 = (state_29340[(48)]);
var inst_29050 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29051 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29052 = [null,null];
var inst_29053 = (new cljs.core.PersistentVector(null,2,(5),inst_29051,inst_29052,null));
var inst_29054 = (function (){var bool = inst_29040;
var map__28982 = inst_29005;
var s1 = inst_29017;
var o2 = inst_29000;
var t1 = inst_28994;
var predicate_fn = inst_29007;
var m1 = inst_28996;
var s2 = inst_29026;
var p2 = inst_28999;
var t2 = inst_29001;
var op1 = inst_28995;
var o1 = inst_28993;
var p1 = inst_28992;
var subject_fn = inst_29006;
var temp__5806__auto__ = inst_29040;
var vec__28976 = inst_28990;
var object_fn = inst_29008;
var vec__28979 = inst_28997;
var op2 = inst_29002;
var m2 = inst_29003;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_29055 = [inst_29053,inst_29054];
var inst_29056 = (new cljs.core.PersistentVector(null,2,(5),inst_29050,inst_29055,null));
var state_29340__$1 = state_29340;
var statearr_29366_29557 = state_29340__$1;
(statearr_29366_29557[(2)] = inst_29056);

(statearr_29366_29557[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (102))){
var inst_29255 = (state_29340[(53)]);
var inst_29253 = (state_29340[(54)]);
var inst_29265 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29266 = [inst_29255,inst_29253];
var inst_29267 = (new cljs.core.PersistentVector(null,2,(5),inst_29265,inst_29266,null));
var state_29340__$1 = state_29340;
var statearr_29367_29558 = state_29340__$1;
(statearr_29367_29558[(2)] = inst_29267);

(statearr_29367_29558[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (55))){
var state_29340__$1 = state_29340;
var statearr_29368_29559 = state_29340__$1;
(statearr_29368_29559[(2)] = (2147483647));

(statearr_29368_29559[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (85))){
var inst_29203 = (state_29340[(2)]);
var state_29340__$1 = state_29340;
if(cljs.core.truth_(inst_29203)){
var statearr_29369_29560 = state_29340__$1;
(statearr_29369_29560[(1)] = (89));

} else {
var statearr_29370_29561 = state_29340__$1;
(statearr_29370_29561[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (39))){
var inst_29090 = (state_29340[(63)]);
var inst_28999 = (state_29340[(61)]);
var inst_29089 = (state_29340[(2)]);
var inst_29090__$1 = (inst_28999 == null);
var state_29340__$1 = (function (){var statearr_29371 = state_29340;
(statearr_29371[(63)] = inst_29090__$1);

(statearr_29371[(42)] = inst_29089);

return statearr_29371;
})();
if(cljs.core.truth_(inst_29090__$1)){
var statearr_29372_29562 = state_29340__$1;
(statearr_29372_29562[(1)] = (40));

} else {
var statearr_29373_29563 = state_29340__$1;
(statearr_29373_29563[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (88))){
var inst_29200 = (state_29340[(2)]);
var state_29340__$1 = state_29340;
var statearr_29374_29564 = state_29340__$1;
(statearr_29374_29564[(2)] = inst_29200);

(statearr_29374_29564[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (46))){
var inst_28996 = (state_29340[(56)]);
var state_29340__$1 = state_29340;
var statearr_29375_29565 = state_29340__$1;
(statearr_29375_29565[(2)] = inst_28996);

(statearr_29375_29565[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (4))){
var inst_28970 = (state_29340[(2)]);
var state_29340__$1 = state_29340;
var statearr_29376_29566 = state_29340__$1;
(statearr_29376_29566[(2)] = inst_28970);

(statearr_29376_29566[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (77))){
var inst_29181 = (state_29340[(64)]);
var inst_29139 = (state_29340[(10)]);
var inst_29001 = (state_29340[(11)]);
var inst_29127 = (state_29340[(12)]);
var inst_29116 = (state_29340[(13)]);
var inst_29062 = (state_29340[(14)]);
var inst_28994 = (state_29340[(15)]);
var inst_29158 = (state_29340[(16)]);
var inst_29107 = (state_29340[(17)]);
var inst_29161 = (state_29340[(18)]);
var inst_29121 = (state_29340[(19)]);
var inst_29138 = (state_29340[(20)]);
var inst_29128 = (state_29340[(21)]);
var inst_29118 = (state_29340[(22)]);
var inst_29007 = (state_29340[(23)]);
var inst_29133 = (state_29340[(24)]);
var inst_29148 = (state_29340[(8)]);
var inst_29080 = (state_29340[(25)]);
var inst_28997 = (state_29340[(26)]);
var inst_29098 = (state_29340[(27)]);
var inst_29134 = (state_29340[(28)]);
var inst_29005 = (state_29340[(29)]);
var inst_29026 = (state_29340[(30)]);
var inst_29002 = (state_29340[(31)]);
var inst_29154 = (state_29340[(9)]);
var inst_29129 = (state_29340[(32)]);
var inst_28995 = (state_29340[(33)]);
var inst_29159 = (state_29340[(34)]);
var inst_29157 = (state_29340[(35)]);
var inst_29167 = (state_29340[(36)]);
var inst_29120 = (state_29340[(37)]);
var inst_29017 = (state_29340[(38)]);
var inst_29117 = (state_29340[(39)]);
var inst_29071 = (state_29340[(40)]);
var inst_28990 = (state_29340[(41)]);
var inst_29089 = (state_29340[(42)]);
var inst_29144 = (state_29340[(43)]);
var inst_29160 = (state_29340[(44)]);
var inst_29058 = (state_29340[(46)]);
var inst_29059 = (state_29340[(47)]);
var inst_29006 = (state_29340[(48)]);
var inst_29183 = (function (){var no_filter_QMARK_ = inst_29154;
var t = inst_29134;
var max_limit_QMARK_ = inst_29128;
var next_node = inst_29157;
var map__28982 = inst_29005;
var fast_forward_db_QMARK_ = inst_29139;
var s1 = inst_29017;
var o2 = inst_29080;
var t1 = inst_28994;
var predicate_fn = inst_29007;
var i = inst_29159;
var m1 = inst_29107;
var root_node = inst_29144;
var s2 = inst_29026;
var p2 = inst_29098;
var map__28989 = inst_29120;
var permissions = inst_29129;
var G__29168 = inst_29181;
var limit = inst_29127;
var start_flake = inst_29117;
var vec__28986 = inst_29059;
var flake_limit = inst_29121;
var vec__28983 = inst_29058;
var offset = inst_29158;
var acc = inst_29161;
var t2 = inst_29001;
var op1 = inst_28995;
var o1 = inst_29071;
var end_flake = inst_29118;
var base_result = inst_29167;
var s = inst_29160;
var node_start = inst_29148;
var p1 = inst_29089;
var subject_fn = inst_29006;
var vec__28976 = inst_28990;
var object_fn = inst_29062;
var idx_compare = inst_29133;
var vec__28979 = inst_28997;
var op2 = inst_29002;
var m2 = inst_29116;
var novelty = inst_29138;
return (function (p1__28959_SHARP_){
var G__29377 = p1__28959_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__29377) : predicate_fn.call(null,G__29377));
});
})();
var inst_29184 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_29183,inst_29181);
var state_29340__$1 = state_29340;
var statearr_29378_29567 = state_29340__$1;
(statearr_29378_29567[(2)] = inst_29184);

(statearr_29378_29567[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (106))){
var inst_29194 = (state_29340[(65)]);
var state_29340__$1 = state_29340;
var statearr_29379_29568 = state_29340__$1;
(statearr_29379_29568[(2)] = inst_29194);

(statearr_29379_29568[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (119))){
var inst_29312 = (state_29340[(66)]);
var state_29340__$1 = state_29340;
var statearr_29380_29569 = state_29340__$1;
(statearr_29380_29569[(2)] = inst_29312);

(statearr_29380_29569[(1)] = (120));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (95))){
var inst_29127 = (state_29340[(12)]);
var inst_29227 = (state_29340[(67)]);
var inst_29235 = (state_29340[(68)]);
var inst_29237 = (state_29340[(69)]);
var inst_29236 = (state_29340[(70)]);
var inst_29160 = (state_29340[(44)]);
var inst_29235__$1 = cljs.core.count(inst_29227);
var inst_29236__$1 = (inst_29160 + inst_29235__$1);
var inst_29237__$1 = (inst_29236__$1 - inst_29127);
var inst_29238 = cljs.core.pos_int_QMARK_(inst_29237__$1);
var state_29340__$1 = (function (){var statearr_29381 = state_29340;
(statearr_29381[(68)] = inst_29235__$1);

(statearr_29381[(69)] = inst_29237__$1);

(statearr_29381[(70)] = inst_29236__$1);

return statearr_29381;
})();
if(inst_29238){
var statearr_29382_29570 = state_29340__$1;
(statearr_29382_29570[(1)] = (98));

} else {
var statearr_29383_29571 = state_29340__$1;
(statearr_29383_29571[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (54))){
var inst_29001 = (state_29340[(11)]);
var inst_29116 = (state_29340[(13)]);
var inst_28994 = (state_29340[(15)]);
var inst_29107 = (state_29340[(17)]);
var inst_29080 = (state_29340[(25)]);
var inst_29098 = (state_29340[(27)]);
var inst_29026 = (state_29340[(30)]);
var inst_29002 = (state_29340[(31)]);
var inst_29122 = (state_29340[(50)]);
var inst_28995 = (state_29340[(33)]);
var inst_29120 = (state_29340[(37)]);
var inst_29017 = (state_29340[(38)]);
var inst_29071 = (state_29340[(40)]);
var inst_29089 = (state_29340[(42)]);
var inst_29116__$1 = (state_29340[(2)]);
var inst_29117 = fluree.db.flake.__GT_Flake(inst_29017,inst_29089,inst_29071,inst_28994,inst_28995,inst_29107);
var inst_29118 = fluree.db.flake.__GT_Flake(inst_29026,inst_29098,inst_29080,inst_29001,inst_29002,inst_29116__$1);
var inst_29119 = opts;
var inst_29120__$1 = cljs.core.__destructure_map(inst_29119);
var inst_29121 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_29120__$1,cljs.core.cst$kw$flake_DASH_limit,fluree.db.util.core.max_long);
var inst_29122__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29120__$1,cljs.core.cst$kw$limit);
var inst_29123 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_29120__$1,cljs.core.cst$kw$offset,(0));
var state_29340__$1 = (function (){var statearr_29384 = state_29340;
(statearr_29384[(71)] = inst_29123);

(statearr_29384[(13)] = inst_29116__$1);

(statearr_29384[(19)] = inst_29121);

(statearr_29384[(22)] = inst_29118);

(statearr_29384[(50)] = inst_29122__$1);

(statearr_29384[(37)] = inst_29120__$1);

(statearr_29384[(39)] = inst_29117);

return statearr_29384;
})();
if(cljs.core.truth_(inst_29122__$1)){
var statearr_29385_29572 = state_29340__$1;
(statearr_29385_29572[(1)] = (58));

} else {
var statearr_29386_29573 = state_29340__$1;
(statearr_29386_29573[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (92))){
var inst_29158 = (state_29340[(16)]);
var inst_29161 = (state_29340[(18)]);
var inst_29159 = (state_29340[(34)]);
var inst_29216 = (state_29340[(72)]);
var inst_29160 = (state_29340[(44)]);
var inst_29219 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29220 = (inst_29158 - inst_29216);
var inst_29221 = [inst_29220,inst_29159,inst_29160,inst_29161];
var inst_29222 = (new cljs.core.PersistentVector(null,4,(5),inst_29219,inst_29221,null));
var state_29340__$1 = state_29340;
var statearr_29387_29574 = state_29340__$1;
(statearr_29387_29574[(2)] = inst_29222);

(statearr_29387_29574[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (104))){
var inst_29278 = (state_29340[(2)]);
var inst_29279 = fluree.db.util.async.throw_err(inst_29278);
var state_29340__$1 = state_29340;
var statearr_29388_29575 = state_29340__$1;
(statearr_29388_29575[(2)] = inst_29279);

(statearr_29388_29575[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (15))){
var inst_29000 = (state_29340[(55)]);
var inst_29030 = cljs.core.boolean_QMARK_(inst_29000);
var state_29340__$1 = state_29340;
if(inst_29030){
var statearr_29389_29576 = state_29340__$1;
(statearr_29389_29576[(1)] = (17));

} else {
var statearr_29390_29577 = state_29340__$1;
(statearr_29390_29577[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (48))){
var inst_29003 = (state_29340[(62)]);
var inst_29107 = (state_29340[(2)]);
var state_29340__$1 = (function (){var statearr_29391 = state_29340;
(statearr_29391[(17)] = inst_29107);

return statearr_29391;
})();
if(cljs.core.truth_(inst_29003)){
var statearr_29392_29578 = state_29340__$1;
(statearr_29392_29578[(1)] = (52));

} else {
var statearr_29393_29579 = state_29340__$1;
(statearr_29393_29579[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (50))){
var state_29340__$1 = state_29340;
var statearr_29394_29580 = state_29340__$1;
(statearr_29394_29580[(2)] = (2147483647));

(statearr_29394_29580[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (116))){
var inst_29312 = (state_29340[(66)]);
var inst_29320 = (state_29340[(2)]);
var state_29340__$1 = (function (){var statearr_29395 = state_29340;
(statearr_29395[(73)] = inst_29320);

return statearr_29395;
})();
if(cljs.core.truth_(inst_29312)){
var statearr_29396_29581 = state_29340__$1;
(statearr_29396_29581[(1)] = (118));

} else {
var statearr_29397_29582 = state_29340__$1;
(statearr_29397_29582[(1)] = (119));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (75))){
var inst_29175 = (state_29340[(45)]);
var state_29340__$1 = state_29340;
var statearr_29398_29583 = state_29340__$1;
(statearr_29398_29583[(2)] = inst_29175);

(statearr_29398_29583[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (99))){
var inst_29236 = (state_29340[(70)]);
var inst_29245 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29246 = [inst_29236,inst_29236];
var inst_29247 = (new cljs.core.PersistentVector(null,2,(5),inst_29245,inst_29246,null));
var state_29340__$1 = state_29340;
var statearr_29399_29584 = state_29340__$1;
(statearr_29399_29584[(2)] = inst_29247);

(statearr_29399_29584[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (21))){
var state_29340__$1 = state_29340;
var statearr_29400_29585 = state_29340__$1;
(statearr_29400_29585[(2)] = null);

(statearr_29400_29585[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (31))){
var inst_29061 = (state_29340[(74)]);
var state_29340__$1 = state_29340;
var statearr_29401_29586 = state_29340__$1;
(statearr_29401_29586[(2)] = inst_29061);

(statearr_29401_29586[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (113))){
var inst_29306 = (state_29340[(2)]);
var state_29340__$1 = state_29340;
var statearr_29402_29587 = state_29340__$1;
(statearr_29402_29587[(2)] = inst_29306);

(statearr_29402_29587[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (32))){
var inst_29081 = (state_29340[(75)]);
var inst_28992 = (state_29340[(60)]);
var inst_29080 = (state_29340[(2)]);
var inst_29081__$1 = (inst_28992 == null);
var state_29340__$1 = (function (){var statearr_29403 = state_29340;
(statearr_29403[(25)] = inst_29080);

(statearr_29403[(75)] = inst_29081__$1);

return statearr_29403;
})();
if(cljs.core.truth_(inst_29081__$1)){
var statearr_29404_29588 = state_29340__$1;
(statearr_29404_29588[(1)] = (34));

} else {
var statearr_29405_29589 = state_29340__$1;
(statearr_29405_29589[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (40))){
var inst_29080 = (state_29340[(25)]);
var state_29340__$1 = state_29340;
var statearr_29406_29590 = state_29340__$1;
(statearr_29406_29590[(2)] = inst_29080);

(statearr_29406_29590[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (91))){
var inst_29194 = (state_29340[(65)]);
var inst_29292 = (state_29340[(2)]);
var inst_29293 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29292,(0),null);
var inst_29294 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29292,(1),null);
var inst_29295 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29292,(2),null);
var inst_29296 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29292,(3),null);
var state_29340__$1 = (function (){var statearr_29407 = state_29340;
(statearr_29407[(76)] = inst_29294);

(statearr_29407[(7)] = inst_29296);

(statearr_29407[(77)] = inst_29295);

(statearr_29407[(78)] = inst_29293);

return statearr_29407;
})();
if(cljs.core.truth_(inst_29194)){
var statearr_29408_29591 = state_29340__$1;
(statearr_29408_29591[(1)] = (105));

} else {
var statearr_29409_29592 = state_29340__$1;
(statearr_29409_29592[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (117))){
var inst_29316 = (state_29340[(2)]);
var inst_29317 = fluree.db.util.async.throw_err(inst_29316);
var state_29340__$1 = state_29340;
var statearr_29410_29593 = state_29340__$1;
(statearr_29410_29593[(2)] = inst_29317);

(statearr_29410_29593[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (108))){
var inst_29294 = (state_29340[(76)]);
var inst_29301 = (state_29340[(79)]);
var inst_29121 = (state_29340[(19)]);
var inst_29301__$1 = (inst_29294 < inst_29121);
var state_29340__$1 = (function (){var statearr_29411 = state_29340;
(statearr_29411[(79)] = inst_29301__$1);

return statearr_29411;
})();
if(cljs.core.truth_(inst_29301__$1)){
var statearr_29412_29594 = state_29340__$1;
(statearr_29412_29594[(1)] = (111));

} else {
var statearr_29413_29595 = state_29340__$1;
(statearr_29413_29595[(1)] = (112));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (56))){
var state_29340__$1 = state_29340;
var statearr_29414_29596 = state_29340__$1;
(statearr_29414_29596[(2)] = fluree.db.util.core.min_integer);

(statearr_29414_29596[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (33))){
var inst_29076 = (state_29340[(2)]);
var inst_29077 = fluree.db.util.async.throw_err(inst_29076);
var state_29340__$1 = state_29340;
var statearr_29415_29597 = state_29340__$1;
(statearr_29415_29597[(2)] = inst_29077);

(statearr_29415_29597[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (13))){
var inst_29022 = (state_29340[(2)]);
var inst_29023 = fluree.db.util.async.throw_err(inst_29022);
var state_29340__$1 = state_29340;
var statearr_29416_29598 = state_29340__$1;
(statearr_29416_29598[(2)] = inst_29023);

(statearr_29416_29598[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (22))){
var inst_29036 = (state_29340[(2)]);
var state_29340__$1 = state_29340;
var statearr_29417_29599 = state_29340__$1;
(statearr_29417_29599[(2)] = inst_29036);

(statearr_29417_29599[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (90))){
var inst_29139 = (state_29340[(10)]);
var inst_29001 = (state_29340[(11)]);
var inst_29127 = (state_29340[(12)]);
var inst_29116 = (state_29340[(13)]);
var inst_29194 = (state_29340[(65)]);
var inst_29062 = (state_29340[(14)]);
var inst_28994 = (state_29340[(15)]);
var inst_29158 = (state_29340[(16)]);
var inst_29107 = (state_29340[(17)]);
var inst_29161 = (state_29340[(18)]);
var inst_29121 = (state_29340[(19)]);
var inst_29138 = (state_29340[(20)]);
var inst_29128 = (state_29340[(21)]);
var inst_29118 = (state_29340[(22)]);
var inst_29007 = (state_29340[(23)]);
var inst_29133 = (state_29340[(24)]);
var inst_29148 = (state_29340[(8)]);
var inst_29080 = (state_29340[(25)]);
var inst_28997 = (state_29340[(26)]);
var inst_29098 = (state_29340[(27)]);
var inst_29134 = (state_29340[(28)]);
var inst_29005 = (state_29340[(29)]);
var inst_29026 = (state_29340[(30)]);
var inst_29002 = (state_29340[(31)]);
var inst_29154 = (state_29340[(9)]);
var inst_29129 = (state_29340[(32)]);
var inst_28995 = (state_29340[(33)]);
var inst_29159 = (state_29340[(34)]);
var inst_29216 = (state_29340[(72)]);
var inst_29193 = (state_29340[(80)]);
var inst_29157 = (state_29340[(35)]);
var inst_29167 = (state_29340[(36)]);
var inst_29120 = (state_29340[(37)]);
var inst_29017 = (state_29340[(38)]);
var inst_29117 = (state_29340[(39)]);
var inst_29071 = (state_29340[(40)]);
var inst_28990 = (state_29340[(41)]);
var inst_29089 = (state_29340[(42)]);
var inst_29144 = (state_29340[(43)]);
var inst_29160 = (state_29340[(44)]);
var inst_29058 = (state_29340[(46)]);
var inst_29059 = (state_29340[(47)]);
var inst_29215 = (state_29340[(81)]);
var inst_29006 = (state_29340[(48)]);
var inst_29214 = (function (){var no_filter_QMARK_ = inst_29154;
var base_result_SINGLEQUOTE_ = inst_29193;
var t = inst_29134;
var max_limit_QMARK_ = inst_29128;
var next_node = inst_29157;
var map__28982 = inst_29005;
var fast_forward_db_QMARK_ = inst_29139;
var s1 = inst_29017;
var o2 = inst_29080;
var t1 = inst_28994;
var predicate_fn = inst_29007;
var i = inst_29159;
var rhs = inst_29194;
var m1 = inst_29107;
var root_node = inst_29144;
var s2 = inst_29026;
var p2 = inst_29098;
var map__28989 = inst_29120;
var permissions = inst_29129;
var limit = inst_29127;
var start_flake = inst_29117;
var vec__28986 = inst_29059;
var flake_limit = inst_29121;
var vec__28983 = inst_29058;
var offset = inst_29158;
var acc = inst_29161;
var t2 = inst_29001;
var op1 = inst_28995;
var o1 = inst_29071;
var end_flake = inst_29118;
var base_result = inst_29167;
var s = inst_29160;
var node_start = inst_29148;
var p1 = inst_29089;
var subject_fn = inst_29006;
var vec__28976 = inst_28990;
var object_fn = inst_29062;
var idx_compare = inst_29133;
var vec__28979 = inst_28997;
var op2 = inst_29002;
var m2 = inst_29116;
var novelty = inst_29138;
return (function (p1__28961_SHARP_){
return p1__28961_SHARP_.s;
});
})();
var inst_29215__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_29214,inst_29193);
var inst_29216__$1 = cljs.core.count(inst_29215__$1);
var inst_29217 = (inst_29158 > inst_29216__$1);
var state_29340__$1 = (function (){var statearr_29418 = state_29340;
(statearr_29418[(72)] = inst_29216__$1);

(statearr_29418[(81)] = inst_29215__$1);

return statearr_29418;
})();
if(cljs.core.truth_(inst_29217)){
var statearr_29419_29600 = state_29340__$1;
(statearr_29419_29600[(1)] = (92));

} else {
var statearr_29420_29601 = state_29340__$1;
(statearr_29420_29601[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (109))){
var inst_29299 = (state_29340[(82)]);
var state_29340__$1 = state_29340;
var statearr_29421_29602 = state_29340__$1;
(statearr_29421_29602[(2)] = inst_29299);

(statearr_29421_29602[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (36))){
var inst_29085 = (state_29340[(2)]);
var state_29340__$1 = state_29340;
if(cljs.core.truth_(inst_29085)){
var statearr_29422_29603 = state_29340__$1;
(statearr_29422_29603[(1)] = (37));

} else {
var statearr_29423_29604 = state_29340__$1;
(statearr_29423_29604[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (41))){
var inst_29090 = (state_29340[(63)]);
var state_29340__$1 = state_29340;
var statearr_29424_29605 = state_29340__$1;
(statearr_29424_29605[(2)] = inst_29090);

(statearr_29424_29605[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (118))){
var inst_29320 = (state_29340[(73)]);
var state_29340__$1 = state_29340;
var statearr_29425_29606 = state_29340__$1;
(statearr_29425_29606[(2)] = inst_29320);

(statearr_29425_29606[(1)] = (120));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (89))){
var inst_29161 = (state_29340[(18)]);
var inst_29121 = (state_29340[(19)]);
var inst_29159 = (state_29340[(34)]);
var inst_29193 = (state_29340[(80)]);
var inst_29160 = (state_29340[(44)]);
var inst_29205 = cljs.core.count(inst_29193);
var inst_29206 = (inst_29121 - inst_29159);
var inst_29207 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_29206,inst_29193);
var inst_29208 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29161,inst_29207);
var inst_29209 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29210 = (inst_29159 + inst_29205);
var inst_29211 = [(0),inst_29210,inst_29160,inst_29208];
var inst_29212 = (new cljs.core.PersistentVector(null,4,(5),inst_29209,inst_29211,null));
var state_29340__$1 = state_29340;
var statearr_29426_29607 = state_29340__$1;
(statearr_29426_29607[(2)] = inst_29212);

(statearr_29426_29607[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (100))){
var inst_29254 = (state_29340[(52)]);
var inst_29121 = (state_29340[(19)]);
var inst_29227 = (state_29340[(67)]);
var inst_29159 = (state_29340[(34)]);
var inst_29255 = (state_29340[(53)]);
var inst_29253 = (state_29340[(54)]);
var inst_29249 = (state_29340[(2)]);
var inst_29250 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29249,(0),null);
var inst_29251 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29249,(1),null);
var inst_29252 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_29251,inst_29227);
var inst_29253__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_29252);
var inst_29254__$1 = cljs.core.count(inst_29253__$1);
var inst_29255__$1 = (inst_29159 + inst_29254__$1);
var inst_29256 = (inst_29255__$1 > inst_29121);
var state_29340__$1 = (function (){var statearr_29427 = state_29340;
(statearr_29427[(83)] = inst_29250);

(statearr_29427[(52)] = inst_29254__$1);

(statearr_29427[(53)] = inst_29255__$1);

(statearr_29427[(54)] = inst_29253__$1);

return statearr_29427;
})();
if(cljs.core.truth_(inst_29256)){
var statearr_29428_29608 = state_29340__$1;
(statearr_29428_29608[(1)] = (101));

} else {
var statearr_29429_29609 = state_29340__$1;
(statearr_29429_29609[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (122))){
var inst_29320 = (state_29340[(73)]);
var inst_29294 = (state_29340[(76)]);
var inst_29296 = (state_29340[(7)]);
var inst_29295 = (state_29340[(77)]);
var inst_29293 = (state_29340[(78)]);
var inst_29157 = inst_29320;
var inst_29158 = inst_29293;
var inst_29159 = inst_29294;
var inst_29160 = inst_29295;
var inst_29161 = inst_29296;
var state_29340__$1 = (function (){var statearr_29430 = state_29340;
(statearr_29430[(16)] = inst_29158);

(statearr_29430[(18)] = inst_29161);

(statearr_29430[(34)] = inst_29159);

(statearr_29430[(35)] = inst_29157);

(statearr_29430[(44)] = inst_29160);

return statearr_29430;
})();
var statearr_29431_29610 = state_29340__$1;
(statearr_29431_29610[(2)] = null);

(statearr_29431_29610[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (43))){
var state_29340__$1 = state_29340;
var statearr_29432_29611 = state_29340__$1;
(statearr_29432_29611[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_29432_29611[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (61))){
var inst_29139 = (state_29340[(10)]);
var inst_29138 = (state_29340[(20)]);
var inst_29134 = (state_29340[(28)]);
var inst_29117 = (state_29340[(39)]);
var inst_29144 = (state_29340[(43)]);
var inst_29143 = (state_29340[(2)]);
var inst_29144__$1 = fluree.db.util.async.throw_err(inst_29143);
var inst_29145 = fluree.db.query.range.find_next_valid_node(inst_29144__$1,inst_29117,inst_29134,inst_29138,inst_29139);
var state_29340__$1 = (function (){var statearr_29433 = state_29340;
(statearr_29433[(43)] = inst_29144__$1);

return statearr_29433;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29340__$1,(62),inst_29145);
} else {
if((state_val_29341 === (29))){
var inst_29067 = (state_29340[(2)]);
var inst_29068 = fluree.db.util.async.throw_err(inst_29067);
var state_29340__$1 = state_29340;
var statearr_29434_29612 = state_29340__$1;
(statearr_29434_29612[(2)] = inst_29068);

(statearr_29434_29612[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (44))){
var inst_28999 = (state_29340[(61)]);
var state_29340__$1 = state_29340;
var statearr_29435_29613 = state_29340__$1;
(statearr_29435_29613[(2)] = inst_28999);

(statearr_29435_29613[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (93))){
var inst_29158 = (state_29340[(16)]);
var inst_29154 = (state_29340[(9)]);
var inst_29215 = (state_29340[(81)]);
var inst_29227 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_29158,inst_29215);
var state_29340__$1 = (function (){var statearr_29436 = state_29340;
(statearr_29436[(67)] = inst_29227);

return statearr_29436;
})();
if(cljs.core.truth_(inst_29154)){
var statearr_29437_29614 = state_29340__$1;
(statearr_29437_29614[(1)] = (95));

} else {
var statearr_29438_29615 = state_29340__$1;
(statearr_29438_29615[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (6))){
var inst_28991 = (state_29340[(49)]);
var inst_29011 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_28991);
var state_29340__$1 = state_29340;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29340__$1,(9),inst_29011);
} else {
if((state_val_29341 === (111))){
var inst_29127 = (state_29340[(12)]);
var inst_29295 = (state_29340[(77)]);
var inst_29303 = (inst_29295 < inst_29127);
var state_29340__$1 = state_29340;
var statearr_29439_29616 = state_29340__$1;
(statearr_29439_29616[(2)] = inst_29303);

(statearr_29439_29616[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (28))){
var inst_29061 = (state_29340[(74)]);
var inst_29071 = (state_29340[(2)]);
var inst_29072 = fluree.db.util.core.pred_ident_QMARK_(inst_29061);
var state_29340__$1 = (function (){var statearr_29440 = state_29340;
(statearr_29440[(40)] = inst_29071);

return statearr_29440;
})();
if(inst_29072){
var statearr_29441_29617 = state_29340__$1;
(statearr_29441_29617[(1)] = (30));

} else {
var statearr_29442_29618 = state_29340__$1;
(statearr_29442_29618[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (64))){
var state_29340__$1 = state_29340;
var statearr_29443_29619 = state_29340__$1;
(statearr_29443_29619[(2)] = true);

(statearr_29443_29619[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (103))){
var inst_29250 = (state_29340[(83)]);
var inst_29269 = (state_29340[(2)]);
var inst_29270 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29269,(0),null);
var inst_29271 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29269,(1),null);
var inst_29272 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29273 = [inst_29270,inst_29250,inst_29271];
var inst_29274 = (new cljs.core.PersistentVector(null,3,(5),inst_29272,inst_29273,null));
var state_29340__$1 = state_29340;
var statearr_29444_29620 = state_29340__$1;
(statearr_29444_29620[(2)] = inst_29274);

(statearr_29444_29620[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (51))){
var inst_29105 = (state_29340[(2)]);
var state_29340__$1 = state_29340;
var statearr_29445_29621 = state_29340__$1;
(statearr_29445_29621[(2)] = inst_29105);

(statearr_29445_29621[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (25))){
var inst_29060 = (state_29340[(51)]);
var inst_29058 = (state_29340[(46)]);
var inst_29059 = (state_29340[(47)]);
var inst_29058__$1 = (state_29340[(2)]);
var inst_29059__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29058__$1,(0),null);
var inst_29060__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29059__$1,(0),null);
var inst_29061 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29059__$1,(1),null);
var inst_29062 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29058__$1,(1),null);
var inst_29063 = fluree.db.util.core.pred_ident_QMARK_(inst_29060__$1);
var state_29340__$1 = (function (){var statearr_29446 = state_29340;
(statearr_29446[(14)] = inst_29062);

(statearr_29446[(51)] = inst_29060__$1);

(statearr_29446[(74)] = inst_29061);

(statearr_29446[(46)] = inst_29058__$1);

(statearr_29446[(47)] = inst_29059__$1);

return statearr_29446;
})();
if(inst_29063){
var statearr_29447_29622 = state_29340__$1;
(statearr_29447_29622[(1)] = (26));

} else {
var statearr_29448_29623 = state_29340__$1;
(statearr_29448_29623[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (34))){
var inst_29071 = (state_29340[(40)]);
var state_29340__$1 = state_29340;
var statearr_29449_29624 = state_29340__$1;
(statearr_29449_29624[(2)] = inst_29071);

(statearr_29449_29624[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (17))){
var inst_29000 = (state_29340[(55)]);
var state_29340__$1 = state_29340;
var statearr_29450_29625 = state_29340__$1;
(statearr_29450_29625[(2)] = inst_29000);

(statearr_29450_29625[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (3))){
var inst_29338 = (state_29340[(2)]);
var state_29340__$1 = state_29340;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29340__$1,inst_29338);
} else {
if((state_val_29341 === (12))){
var inst_28993 = (state_29340[(59)]);
var inst_29026 = (state_29340[(2)]);
var inst_29027 = cljs.core.boolean_QMARK_(inst_28993);
var state_29340__$1 = (function (){var statearr_29451 = state_29340;
(statearr_29451[(30)] = inst_29026);

return statearr_29451;
})();
if(inst_29027){
var statearr_29452_29626 = state_29340__$1;
(statearr_29452_29626[(1)] = (14));

} else {
var statearr_29453_29627 = state_29340__$1;
(statearr_29453_29627[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (2))){
var inst_28991 = (state_29340[(49)]);
var inst_28997 = (state_29340[(26)]);
var inst_29005 = (state_29340[(29)]);
var inst_28990 = (state_29340[(41)]);
var _ = (function (){var statearr_29454 = state_29340;
(statearr_29454[(4)] = cljs.core.cons((5),(state_29340[(4)])));

return statearr_29454;
})();
var inst_28990__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_28991__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28990__$1,(0),null);
var inst_28992 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28990__$1,(1),null);
var inst_28993 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28990__$1,(2),null);
var inst_28994 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28990__$1,(3),null);
var inst_28995 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28990__$1,(4),null);
var inst_28996 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28990__$1,(5),null);
var inst_28997__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_28998 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28997__$1,(0),null);
var inst_28999 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28997__$1,(1),null);
var inst_29000 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28997__$1,(2),null);
var inst_29001 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28997__$1,(3),null);
var inst_29002 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28997__$1,(4),null);
var inst_29003 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28997__$1,(5),null);
var inst_29004 = opts;
var inst_29005__$1 = cljs.core.__destructure_map(inst_29004);
var inst_29006 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29005__$1,cljs.core.cst$kw$subject_DASH_fn);
var inst_29007 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29005__$1,cljs.core.cst$kw$predicate_DASH_fn);
var inst_29008 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29005__$1,cljs.core.cst$kw$object_DASH_fn);
var inst_29009 = fluree.db.util.core.pred_ident_QMARK_(inst_28991__$1);
var state_29340__$1 = (function (){var statearr_29455 = state_29340;
(statearr_29455[(55)] = inst_29000);

(statearr_29455[(11)] = inst_29001);

(statearr_29455[(56)] = inst_28996);

(statearr_29455[(15)] = inst_28994);

(statearr_29455[(57)] = inst_29008);

(statearr_29455[(23)] = inst_29007);

(statearr_29455[(49)] = inst_28991__$1);

(statearr_29455[(26)] = inst_28997__$1);

(statearr_29455[(29)] = inst_29005__$1);

(statearr_29455[(31)] = inst_29002);

(statearr_29455[(33)] = inst_28995);

(statearr_29455[(59)] = inst_28993);

(statearr_29455[(84)] = inst_28998);

(statearr_29455[(60)] = inst_28992);

(statearr_29455[(41)] = inst_28990__$1);

(statearr_29455[(61)] = inst_28999);

(statearr_29455[(62)] = inst_29003);

(statearr_29455[(48)] = inst_29006);

return statearr_29455;
})();
if(inst_29009){
var statearr_29456_29628 = state_29340__$1;
(statearr_29456_29628[(1)] = (6));

} else {
var statearr_29457_29629 = state_29340__$1;
(statearr_29457_29629[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (66))){
var inst_29123 = (state_29340[(71)]);
var inst_29148 = (state_29340[(8)]);
var inst_29156 = cljs.core.PersistentVector.EMPTY;
var inst_29157 = inst_29148;
var inst_29158 = inst_29123;
var inst_29159 = (0);
var inst_29160 = (0);
var inst_29161 = inst_29156;
var state_29340__$1 = (function (){var statearr_29458 = state_29340;
(statearr_29458[(16)] = inst_29158);

(statearr_29458[(18)] = inst_29161);

(statearr_29458[(34)] = inst_29159);

(statearr_29458[(35)] = inst_29157);

(statearr_29458[(44)] = inst_29160);

return statearr_29458;
})();
var statearr_29459_29630 = state_29340__$1;
(statearr_29459_29630[(2)] = null);

(statearr_29459_29630[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (107))){
var inst_29312 = (state_29340[(66)]);
var inst_29312__$1 = (state_29340[(2)]);
var state_29340__$1 = (function (){var statearr_29460 = state_29340;
(statearr_29460[(66)] = inst_29312__$1);

return statearr_29460;
})();
if(cljs.core.truth_(inst_29312__$1)){
var statearr_29461_29631 = state_29340__$1;
(statearr_29461_29631[(1)] = (114));

} else {
var statearr_29462_29632 = state_29340__$1;
(statearr_29462_29632[(1)] = (115));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (23))){
var inst_29000 = (state_29340[(55)]);
var inst_29008 = (state_29340[(57)]);
var inst_28993 = (state_29340[(59)]);
var inst_29043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29044 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29045 = [inst_28993,inst_29000];
var inst_29046 = (new cljs.core.PersistentVector(null,2,(5),inst_29044,inst_29045,null));
var inst_29047 = [inst_29046,inst_29008];
var inst_29048 = (new cljs.core.PersistentVector(null,2,(5),inst_29043,inst_29047,null));
var state_29340__$1 = state_29340;
var statearr_29463_29633 = state_29340__$1;
(statearr_29463_29633[(2)] = inst_29048);

(statearr_29463_29633[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (47))){
var inst_29101 = (cljs.core._GT__EQ_ === start_test);
var state_29340__$1 = state_29340;
if(cljs.core.truth_(inst_29101)){
var statearr_29464_29634 = state_29340__$1;
(statearr_29464_29634[(1)] = (49));

} else {
var statearr_29465_29635 = state_29340__$1;
(statearr_29465_29635[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (35))){
var inst_29081 = (state_29340[(75)]);
var state_29340__$1 = state_29340;
var statearr_29466_29636 = state_29340__$1;
(statearr_29466_29636[(2)] = inst_29081);

(statearr_29466_29636[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (82))){
var inst_29128 = (state_29340[(21)]);
var inst_29157 = (state_29340[(35)]);
var inst_29193 = (state_29340[(2)]);
var inst_29194 = fluree.db.dbproto._rhs(inst_29157);
var state_29340__$1 = (function (){var statearr_29467 = state_29340;
(statearr_29467[(65)] = inst_29194);

(statearr_29467[(80)] = inst_29193);

return statearr_29467;
})();
if(cljs.core.truth_(inst_29128)){
var statearr_29468_29637 = state_29340__$1;
(statearr_29468_29637[(1)] = (83));

} else {
var statearr_29469_29638 = state_29340__$1;
(statearr_29469_29638[(1)] = (84));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (76))){
var inst_29007 = (state_29340[(23)]);
var inst_29181 = (state_29340[(2)]);
var state_29340__$1 = (function (){var statearr_29470 = state_29340;
(statearr_29470[(64)] = inst_29181);

return statearr_29470;
})();
if(cljs.core.truth_(inst_29007)){
var statearr_29471_29639 = state_29340__$1;
(statearr_29471_29639[(1)] = (77));

} else {
var statearr_29472_29640 = state_29340__$1;
(statearr_29472_29640[(1)] = (78));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (97))){
var inst_29161 = (state_29340[(18)]);
var inst_29281 = (state_29340[(2)]);
var inst_29282 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29281,(0),null);
var inst_29283 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29281,(1),null);
var inst_29284 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29281,(2),null);
var inst_29285 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29286 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29161,inst_29284);
var inst_29287 = [(0),inst_29282,inst_29283,inst_29286];
var inst_29288 = (new cljs.core.PersistentVector(null,4,(5),inst_29285,inst_29287,null));
var state_29340__$1 = state_29340;
var statearr_29473_29641 = state_29340__$1;
(statearr_29473_29641[(2)] = inst_29288);

(statearr_29473_29641[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (19))){
var inst_29038 = (state_29340[(2)]);
var state_29340__$1 = state_29340;
var statearr_29474_29642 = state_29340__$1;
(statearr_29474_29642[(2)] = inst_29038);

(statearr_29474_29642[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (57))){
var inst_29114 = (state_29340[(2)]);
var state_29340__$1 = state_29340;
var statearr_29475_29643 = state_29340__$1;
(statearr_29475_29643[(2)] = inst_29114);

(statearr_29475_29643[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (68))){
var inst_29335 = (state_29340[(2)]);
var _ = (function (){var statearr_29476 = state_29340;
(statearr_29476[(4)] = cljs.core.rest((state_29340[(4)])));

return statearr_29476;
})();
var state_29340__$1 = state_29340;
var statearr_29477_29644 = state_29340__$1;
(statearr_29477_29644[(2)] = inst_29335);

(statearr_29477_29644[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (11))){
var inst_28998 = (state_29340[(84)]);
var state_29340__$1 = state_29340;
var statearr_29478_29645 = state_29340__$1;
(statearr_29478_29645[(2)] = inst_28998);

(statearr_29478_29645[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (115))){
var state_29340__$1 = state_29340;
var statearr_29480_29646 = state_29340__$1;
(statearr_29480_29646[(2)] = null);

(statearr_29480_29646[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (9))){
var inst_29013 = (state_29340[(2)]);
var inst_29014 = fluree.db.util.async.throw_err(inst_29013);
var state_29340__$1 = state_29340;
var statearr_29481_29647 = state_29340__$1;
(statearr_29481_29647[(2)] = inst_29014);

(statearr_29481_29647[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (5))){
var _ = (function (){var statearr_29482 = state_29340;
(statearr_29482[(4)] = cljs.core.rest((state_29340[(4)])));

return statearr_29482;
})();
var state_29340__$1 = state_29340;
var ex29479 = (state_29340__$1[(2)]);
var statearr_29483_29648 = state_29340__$1;
(statearr_29483_29648[(5)] = ex29479);


if((ex29479 instanceof Error)){
var statearr_29484_29649 = state_29340__$1;
(statearr_29484_29649[(1)] = (4));

(statearr_29484_29649[(5)] = null);

} else {
throw ex29479;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (112))){
var inst_29301 = (state_29340[(79)]);
var state_29340__$1 = state_29340;
var statearr_29485_29650 = state_29340__$1;
(statearr_29485_29650[(2)] = inst_29301);

(statearr_29485_29650[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (83))){
var inst_29158 = (state_29340[(16)]);
var inst_29196 = (state_29340[(85)]);
var inst_29196__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_29158);
var state_29340__$1 = (function (){var statearr_29486 = state_29340;
(statearr_29486[(85)] = inst_29196__$1);

return statearr_29486;
})();
if(inst_29196__$1){
var statearr_29487_29651 = state_29340__$1;
(statearr_29487_29651[(1)] = (86));

} else {
var statearr_29488_29652 = state_29340__$1;
(statearr_29488_29652[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (14))){
var inst_28993 = (state_29340[(59)]);
var state_29340__$1 = state_29340;
var statearr_29489_29653 = state_29340__$1;
(statearr_29489_29653[(2)] = inst_28993);

(statearr_29489_29653[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (45))){
var inst_28996 = (state_29340[(56)]);
var inst_29098 = (state_29340[(2)]);
var state_29340__$1 = (function (){var statearr_29490 = state_29340;
(statearr_29490[(27)] = inst_29098);

return statearr_29490;
})();
if(cljs.core.truth_(inst_28996)){
var statearr_29491_29654 = state_29340__$1;
(statearr_29491_29654[(1)] = (46));

} else {
var statearr_29492_29655 = state_29340__$1;
(statearr_29492_29655[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (53))){
var inst_29110 = (cljs.core._LT__EQ_ === end_test);
var state_29340__$1 = state_29340;
if(cljs.core.truth_(inst_29110)){
var statearr_29493_29656 = state_29340__$1;
(statearr_29493_29656[(1)] = (55));

} else {
var statearr_29494_29657 = state_29340__$1;
(statearr_29494_29657[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (78))){
var inst_29181 = (state_29340[(64)]);
var state_29340__$1 = state_29340;
var statearr_29495_29658 = state_29340__$1;
(statearr_29495_29658[(2)] = inst_29181);

(statearr_29495_29658[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (26))){
var inst_29060 = (state_29340[(51)]);
var inst_29065 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_29060);
var state_29340__$1 = state_29340;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29340__$1,(29),inst_29065);
} else {
if((state_val_29341 === (123))){
var inst_29330 = (state_29340[(2)]);
var state_29340__$1 = state_29340;
var statearr_29496_29659 = state_29340__$1;
(statearr_29496_29659[(2)] = inst_29330);

(statearr_29496_29659[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (16))){
var inst_29040 = (state_29340[(58)]);
var inst_29040__$1 = (state_29340[(2)]);
var inst_29041 = (inst_29040__$1 == null);
var state_29340__$1 = (function (){var statearr_29497 = state_29340;
(statearr_29497[(58)] = inst_29040__$1);

return statearr_29497;
})();
if(cljs.core.truth_(inst_29041)){
var statearr_29498_29660 = state_29340__$1;
(statearr_29498_29660[(1)] = (23));

} else {
var statearr_29499_29661 = state_29340__$1;
(statearr_29499_29661[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (81))){
var inst_29187 = (state_29340[(86)]);
var state_29340__$1 = state_29340;
var statearr_29500_29662 = state_29340__$1;
(statearr_29500_29662[(2)] = inst_29187);

(statearr_29500_29662[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (120))){
var inst_29324 = (state_29340[(2)]);
var inst_29325 = cljs.core.not(inst_29324);
var state_29340__$1 = state_29340;
if(inst_29325){
var statearr_29501_29663 = state_29340__$1;
(statearr_29501_29663[(1)] = (121));

} else {
var statearr_29502_29664 = state_29340__$1;
(statearr_29502_29664[(1)] = (122));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (79))){
var inst_29062 = (state_29340[(14)]);
var inst_29187 = (state_29340[(2)]);
var state_29340__$1 = (function (){var statearr_29503 = state_29340;
(statearr_29503[(86)] = inst_29187);

return statearr_29503;
})();
if(cljs.core.truth_(inst_29062)){
var statearr_29504_29665 = state_29340__$1;
(statearr_29504_29665[(1)] = (80));

} else {
var statearr_29505_29666 = state_29340__$1;
(statearr_29505_29666[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (38))){
var inst_28992 = (state_29340[(60)]);
var state_29340__$1 = state_29340;
var statearr_29506_29667 = state_29340__$1;
(statearr_29506_29667[(2)] = inst_28992);

(statearr_29506_29667[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (98))){
var inst_29127 = (state_29340[(12)]);
var inst_29235 = (state_29340[(68)]);
var inst_29237 = (state_29340[(69)]);
var inst_29240 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29241 = (inst_29235 - inst_29237);
var inst_29242 = [inst_29127,inst_29241];
var inst_29243 = (new cljs.core.PersistentVector(null,2,(5),inst_29240,inst_29242,null));
var state_29340__$1 = state_29340;
var statearr_29507_29668 = state_29340__$1;
(statearr_29507_29668[(2)] = inst_29243);

(statearr_29507_29668[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (87))){
var inst_29196 = (state_29340[(85)]);
var state_29340__$1 = state_29340;
var statearr_29508_29669 = state_29340__$1;
(statearr_29508_29669[(2)] = inst_29196);

(statearr_29508_29669[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (30))){
var inst_29061 = (state_29340[(74)]);
var inst_29074 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_29061);
var state_29340__$1 = state_29340;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29340__$1,(33),inst_29074);
} else {
if((state_val_29341 === (73))){
var inst_29006 = (state_29340[(48)]);
var inst_29175 = (state_29340[(2)]);
var state_29340__$1 = (function (){var statearr_29509 = state_29340;
(statearr_29509[(45)] = inst_29175);

return statearr_29509;
})();
if(cljs.core.truth_(inst_29006)){
var statearr_29510_29670 = state_29340__$1;
(statearr_29510_29670[(1)] = (74));

} else {
var statearr_29511_29671 = state_29340__$1;
(statearr_29511_29671[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (96))){
var inst_29127 = (state_29340[(12)]);
var inst_29121 = (state_29340[(19)]);
var inst_29227 = (state_29340[(67)]);
var inst_29159 = (state_29340[(34)]);
var inst_29160 = (state_29340[(44)]);
var inst_29276 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_29227,inst_29159,inst_29160,inst_29121,inst_29127);
var state_29340__$1 = state_29340;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29340__$1,(104),inst_29276);
} else {
if((state_val_29341 === (10))){
var inst_28998 = (state_29340[(84)]);
var inst_29020 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_28998);
var state_29340__$1 = state_29340;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29340__$1,(13),inst_29020);
} else {
if((state_val_29341 === (18))){
var state_29340__$1 = state_29340;
var statearr_29512_29672 = state_29340__$1;
(statearr_29512_29672[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (105))){
var inst_29194 = (state_29340[(65)]);
var inst_29118 = (state_29340[(22)]);
var inst_29133 = (state_29340[(24)]);
var inst_29299 = (state_29340[(82)]);
var inst_29298 = (inst_29133.cljs$core$IFn$_invoke$arity$2 ? inst_29133.cljs$core$IFn$_invoke$arity$2(inst_29194,inst_29118) : inst_29133.call(null,inst_29194,inst_29118));
var inst_29299__$1 = (inst_29298 < (0));
var state_29340__$1 = (function (){var statearr_29514 = state_29340;
(statearr_29514[(82)] = inst_29299__$1);

return statearr_29514;
})();
if(cljs.core.truth_(inst_29299__$1)){
var statearr_29515_29673 = state_29340__$1;
(statearr_29515_29673[(1)] = (108));

} else {
var statearr_29516_29674 = state_29340__$1;
(statearr_29516_29674[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (52))){
var inst_29003 = (state_29340[(62)]);
var state_29340__$1 = state_29340;
var statearr_29517_29675 = state_29340__$1;
(statearr_29517_29675[(2)] = inst_29003);

(statearr_29517_29675[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (114))){
var inst_29139 = (state_29340[(10)]);
var inst_29194 = (state_29340[(65)]);
var inst_29138 = (state_29340[(20)]);
var inst_29134 = (state_29340[(28)]);
var inst_29144 = (state_29340[(43)]);
var inst_29314 = fluree.db.query.range.find_next_valid_node(inst_29144,inst_29194,inst_29134,inst_29138,inst_29139);
var state_29340__$1 = state_29340;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29340__$1,(117),inst_29314);
} else {
if((state_val_29341 === (67))){
var state_29340__$1 = state_29340;
var statearr_29518_29676 = state_29340__$1;
(statearr_29518_29676[(2)] = null);

(statearr_29518_29676[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (71))){
var inst_29139 = (state_29340[(10)]);
var inst_29001 = (state_29340[(11)]);
var inst_29127 = (state_29340[(12)]);
var inst_29116 = (state_29340[(13)]);
var inst_29062 = (state_29340[(14)]);
var inst_28994 = (state_29340[(15)]);
var inst_29158 = (state_29340[(16)]);
var inst_29107 = (state_29340[(17)]);
var inst_29161 = (state_29340[(18)]);
var inst_29121 = (state_29340[(19)]);
var inst_29138 = (state_29340[(20)]);
var inst_29128 = (state_29340[(21)]);
var inst_29118 = (state_29340[(22)]);
var inst_29007 = (state_29340[(23)]);
var inst_29133 = (state_29340[(24)]);
var inst_29148 = (state_29340[(8)]);
var inst_29080 = (state_29340[(25)]);
var inst_28997 = (state_29340[(26)]);
var inst_29098 = (state_29340[(27)]);
var inst_29134 = (state_29340[(28)]);
var inst_29005 = (state_29340[(29)]);
var inst_29026 = (state_29340[(30)]);
var inst_29002 = (state_29340[(31)]);
var inst_29154 = (state_29340[(9)]);
var inst_29129 = (state_29340[(32)]);
var inst_28995 = (state_29340[(33)]);
var inst_29159 = (state_29340[(34)]);
var inst_29157 = (state_29340[(35)]);
var inst_29167 = (state_29340[(36)]);
var inst_29120 = (state_29340[(37)]);
var inst_29017 = (state_29340[(38)]);
var inst_29117 = (state_29340[(39)]);
var inst_29071 = (state_29340[(40)]);
var inst_28990 = (state_29340[(41)]);
var inst_29089 = (state_29340[(42)]);
var inst_29144 = (state_29340[(43)]);
var inst_29160 = (state_29340[(44)]);
var inst_29058 = (state_29340[(46)]);
var inst_29059 = (state_29340[(47)]);
var inst_29006 = (state_29340[(48)]);
var inst_29171 = (function (){var no_filter_QMARK_ = inst_29154;
var t = inst_29134;
var max_limit_QMARK_ = inst_29128;
var next_node = inst_29157;
var map__28982 = inst_29005;
var fast_forward_db_QMARK_ = inst_29139;
var s1 = inst_29017;
var o2 = inst_29080;
var t1 = inst_28994;
var predicate_fn = inst_29007;
var i = inst_29159;
var m1 = inst_29107;
var root_node = inst_29144;
var s2 = inst_29026;
var p2 = inst_29098;
var map__28989 = inst_29120;
var permissions = inst_29129;
var G__29168 = inst_29167;
var limit = inst_29127;
var start_flake = inst_29117;
var vec__28986 = inst_29059;
var flake_limit = inst_29121;
var vec__28983 = inst_29058;
var offset = inst_29158;
var acc = inst_29161;
var t2 = inst_29001;
var op1 = inst_28995;
var o1 = inst_29071;
var end_flake = inst_29118;
var base_result = inst_29167;
var s = inst_29160;
var node_start = inst_29148;
var p1 = inst_29089;
var subject_fn = inst_29006;
var vec__28976 = inst_28990;
var object_fn = inst_29062;
var idx_compare = inst_29133;
var vec__28979 = inst_28997;
var op2 = inst_29002;
var m2 = inst_29116;
var novelty = inst_29138;
return (function (p1__28957_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__28957_SHARP_.o,start_flake.o);
});
})();
var inst_29172 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_29171,inst_29167);
var state_29340__$1 = state_29340;
var statearr_29519_29677 = state_29340__$1;
(statearr_29519_29677[(2)] = inst_29172);

(statearr_29519_29677[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (42))){
var inst_29094 = (state_29340[(2)]);
var state_29340__$1 = state_29340;
if(cljs.core.truth_(inst_29094)){
var statearr_29520_29678 = state_29340__$1;
(statearr_29520_29678[(1)] = (43));

} else {
var statearr_29521_29679 = state_29340__$1;
(statearr_29521_29679[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (80))){
var inst_29139 = (state_29340[(10)]);
var inst_29001 = (state_29340[(11)]);
var inst_29127 = (state_29340[(12)]);
var inst_29116 = (state_29340[(13)]);
var inst_29062 = (state_29340[(14)]);
var inst_28994 = (state_29340[(15)]);
var inst_29187 = (state_29340[(86)]);
var inst_29158 = (state_29340[(16)]);
var inst_29107 = (state_29340[(17)]);
var inst_29161 = (state_29340[(18)]);
var inst_29121 = (state_29340[(19)]);
var inst_29138 = (state_29340[(20)]);
var inst_29128 = (state_29340[(21)]);
var inst_29118 = (state_29340[(22)]);
var inst_29007 = (state_29340[(23)]);
var inst_29133 = (state_29340[(24)]);
var inst_29148 = (state_29340[(8)]);
var inst_29080 = (state_29340[(25)]);
var inst_28997 = (state_29340[(26)]);
var inst_29098 = (state_29340[(27)]);
var inst_29134 = (state_29340[(28)]);
var inst_29005 = (state_29340[(29)]);
var inst_29026 = (state_29340[(30)]);
var inst_29002 = (state_29340[(31)]);
var inst_29154 = (state_29340[(9)]);
var inst_29129 = (state_29340[(32)]);
var inst_28995 = (state_29340[(33)]);
var inst_29159 = (state_29340[(34)]);
var inst_29157 = (state_29340[(35)]);
var inst_29167 = (state_29340[(36)]);
var inst_29120 = (state_29340[(37)]);
var inst_29017 = (state_29340[(38)]);
var inst_29117 = (state_29340[(39)]);
var inst_29071 = (state_29340[(40)]);
var inst_28990 = (state_29340[(41)]);
var inst_29089 = (state_29340[(42)]);
var inst_29144 = (state_29340[(43)]);
var inst_29160 = (state_29340[(44)]);
var inst_29058 = (state_29340[(46)]);
var inst_29059 = (state_29340[(47)]);
var inst_29006 = (state_29340[(48)]);
var inst_29189 = (function (){var no_filter_QMARK_ = inst_29154;
var t = inst_29134;
var max_limit_QMARK_ = inst_29128;
var next_node = inst_29157;
var map__28982 = inst_29005;
var fast_forward_db_QMARK_ = inst_29139;
var s1 = inst_29017;
var o2 = inst_29080;
var t1 = inst_28994;
var predicate_fn = inst_29007;
var i = inst_29159;
var m1 = inst_29107;
var root_node = inst_29144;
var s2 = inst_29026;
var p2 = inst_29098;
var map__28989 = inst_29120;
var permissions = inst_29129;
var G__29168 = inst_29187;
var limit = inst_29127;
var start_flake = inst_29117;
var vec__28986 = inst_29059;
var flake_limit = inst_29121;
var vec__28983 = inst_29058;
var offset = inst_29158;
var acc = inst_29161;
var t2 = inst_29001;
var op1 = inst_28995;
var o1 = inst_29071;
var end_flake = inst_29118;
var base_result = inst_29167;
var s = inst_29160;
var node_start = inst_29148;
var p1 = inst_29089;
var subject_fn = inst_29006;
var vec__28976 = inst_28990;
var object_fn = inst_29062;
var idx_compare = inst_29133;
var vec__28979 = inst_28997;
var op2 = inst_29002;
var m2 = inst_29116;
var novelty = inst_29138;
return (function (p1__28960_SHARP_){
var G__29522 = p1__28960_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__29522) : object_fn.call(null,G__29522));
});
})();
var inst_29190 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_29189,inst_29187);
var state_29340__$1 = state_29340;
var statearr_29523_29680 = state_29340__$1;
(statearr_29523_29680[(2)] = inst_29190);

(statearr_29523_29680[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (37))){
var state_29340__$1 = state_29340;
var statearr_29524_29681 = state_29340__$1;
(statearr_29524_29681[(2)] = (-1));

(statearr_29524_29681[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (63))){
var inst_29098 = (state_29340[(27)]);
var inst_29026 = (state_29340[(30)]);
var inst_29129 = (state_29340[(32)]);
var inst_29017 = (state_29340[(38)]);
var inst_29089 = (state_29340[(42)]);
var inst_29151 = fluree.db.permissions_validate.no_filter_QMARK_(inst_29129,inst_29017,inst_29026,inst_29089,inst_29098);
var state_29340__$1 = state_29340;
var statearr_29525_29682 = state_29340__$1;
(statearr_29525_29682[(2)] = inst_29151);

(statearr_29525_29682[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (94))){
var inst_29290 = (state_29340[(2)]);
var state_29340__$1 = state_29340;
var statearr_29526_29683 = state_29340__$1;
(statearr_29526_29683[(2)] = inst_29290);

(statearr_29526_29683[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (8))){
var inst_28998 = (state_29340[(84)]);
var inst_29017 = (state_29340[(2)]);
var inst_29018 = fluree.db.util.core.pred_ident_QMARK_(inst_28998);
var state_29340__$1 = (function (){var statearr_29527 = state_29340;
(statearr_29527[(38)] = inst_29017);

return statearr_29527;
})();
if(inst_29018){
var statearr_29528_29684 = state_29340__$1;
(statearr_29528_29684[(1)] = (10));

} else {
var statearr_29529_29685 = state_29340__$1;
(statearr_29529_29685[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (49))){
var state_29340__$1 = state_29340;
var statearr_29530_29686 = state_29340__$1;
(statearr_29530_29686[(2)] = fluree.db.util.core.min_integer);

(statearr_29530_29686[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29341 === (84))){
var inst_29128 = (state_29340[(21)]);
var state_29340__$1 = state_29340;
var statearr_29531_29687 = state_29340__$1;
(statearr_29531_29687[(2)] = inst_29128);

(statearr_29531_29687[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__15091__auto__ = null;
var fluree$db$query$range$state_machine__15091__auto____0 = (function (){
var statearr_29532 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29532[(0)] = fluree$db$query$range$state_machine__15091__auto__);

(statearr_29532[(1)] = (1));

return statearr_29532;
});
var fluree$db$query$range$state_machine__15091__auto____1 = (function (state_29340){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_29340);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e29533){var ex__15094__auto__ = e29533;
var statearr_29534_29688 = state_29340;
(statearr_29534_29688[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_29340[(4)]))){
var statearr_29535_29689 = state_29340;
(statearr_29535_29689[(1)] = cljs.core.first((state_29340[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__29690 = state_29340;
state_29340 = G__29690;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__15091__auto__ = function(state_29340){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__15091__auto____1.call(this,state_29340);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__15091__auto____0;
fluree$db$query$range$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__15091__auto____1;
return fluree$db$query$range$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_29536 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_29536[(6)] = c__15165__auto__);

return statearr_29536;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_29746){
var state_val_29747 = (state_29746[(1)]);
if((state_val_29747 === (7))){
var inst_29710 = (state_29746[(7)]);
var inst_29720 = (state_29746[(8)]);
var inst_29718 = fluree.db.flake.Flake__GT_parts(inst_29710);
var inst_29719 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29718,(0),null);
var inst_29720__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29718,(1),null);
var inst_29721 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29718,(2),null);
var inst_29722 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29718,(3),null);
var inst_29723 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29718,(4),null);
var inst_29724 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29718,(5),null);
var inst_29725 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_29721,inst_29720__$1);
var state_29746__$1 = (function (){var statearr_29748 = state_29746;
(statearr_29748[(9)] = inst_29723);

(statearr_29748[(10)] = inst_29722);

(statearr_29748[(11)] = inst_29719);

(statearr_29748[(8)] = inst_29720__$1);

(statearr_29748[(12)] = inst_29724);

return statearr_29748;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29746__$1,(10),inst_29725);
} else {
if((state_val_29747 === (1))){
var inst_29698 = flakes;
var inst_29699 = cljs.core.seq(inst_29698);
var inst_29700 = cljs.core.first(inst_29699);
var inst_29701 = cljs.core.next(inst_29699);
var inst_29702 = cljs.core.PersistentVector.EMPTY;
var inst_29703 = inst_29698;
var inst_29704 = inst_29702;
var state_29746__$1 = (function (){var statearr_29749 = state_29746;
(statearr_29749[(13)] = inst_29703);

(statearr_29749[(14)] = inst_29701);

(statearr_29749[(15)] = inst_29704);

(statearr_29749[(16)] = inst_29700);

return statearr_29749;
})();
var statearr_29750_29768 = state_29746__$1;
(statearr_29750_29768[(2)] = null);

(statearr_29750_29768[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29747 === (4))){
var inst_29710 = (state_29746[(7)]);
var inst_29713 = fluree.db.query.range.is_tag_flake_QMARK_(inst_29710);
var state_29746__$1 = state_29746;
if(inst_29713){
var statearr_29751_29769 = state_29746__$1;
(statearr_29751_29769[(1)] = (7));

} else {
var statearr_29752_29770 = state_29746__$1;
(statearr_29752_29770[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29747 === (6))){
var inst_29742 = (state_29746[(2)]);
var state_29746__$1 = state_29746;
var statearr_29753_29771 = state_29746__$1;
(statearr_29753_29771[(2)] = inst_29742);

(statearr_29753_29771[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29747 === (3))){
var inst_29744 = (state_29746[(2)]);
var state_29746__$1 = state_29746;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29746__$1,inst_29744);
} else {
if((state_val_29747 === (2))){
var inst_29703 = (state_29746[(13)]);
var inst_29710 = (state_29746[(7)]);
var inst_29709 = cljs.core.seq(inst_29703);
var inst_29710__$1 = cljs.core.first(inst_29709);
var inst_29711 = cljs.core.next(inst_29709);
var state_29746__$1 = (function (){var statearr_29754 = state_29746;
(statearr_29754[(7)] = inst_29710__$1);

(statearr_29754[(17)] = inst_29711);

return statearr_29754;
})();
if(cljs.core.truth_(inst_29710__$1)){
var statearr_29755_29772 = state_29746__$1;
(statearr_29755_29772[(1)] = (4));

} else {
var statearr_29756_29773 = state_29746__$1;
(statearr_29756_29773[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29747 === (9))){
var inst_29739 = (state_29746[(2)]);
var state_29746__$1 = state_29746;
var statearr_29757_29774 = state_29746__$1;
(statearr_29757_29774[(2)] = inst_29739);

(statearr_29757_29774[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29747 === (5))){
var inst_29704 = (state_29746[(15)]);
var state_29746__$1 = state_29746;
var statearr_29758_29775 = state_29746__$1;
(statearr_29758_29775[(2)] = inst_29704);

(statearr_29758_29775[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29747 === (10))){
var inst_29723 = (state_29746[(9)]);
var inst_29722 = (state_29746[(10)]);
var inst_29719 = (state_29746[(11)]);
var inst_29720 = (state_29746[(8)]);
var inst_29704 = (state_29746[(15)]);
var inst_29724 = (state_29746[(12)]);
var inst_29711 = (state_29746[(17)]);
var inst_29727 = (state_29746[(2)]);
var inst_29728 = fluree.db.util.async.throw_err(inst_29727);
var inst_29729 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29730 = [inst_29719,inst_29720,inst_29728,inst_29722,inst_29723,inst_29724];
var inst_29731 = (new cljs.core.PersistentVector(null,6,(5),inst_29729,inst_29730,null));
var inst_29732 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_29731);
var inst_29733 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_29704,inst_29732);
var inst_29703 = inst_29711;
var inst_29704__$1 = inst_29733;
var state_29746__$1 = (function (){var statearr_29759 = state_29746;
(statearr_29759[(13)] = inst_29703);

(statearr_29759[(15)] = inst_29704__$1);

return statearr_29759;
})();
var statearr_29760_29776 = state_29746__$1;
(statearr_29760_29776[(2)] = null);

(statearr_29760_29776[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29747 === (8))){
var inst_29710 = (state_29746[(7)]);
var inst_29704 = (state_29746[(15)]);
var inst_29711 = (state_29746[(17)]);
var inst_29736 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_29704,inst_29710);
var inst_29703 = inst_29711;
var inst_29704__$1 = inst_29736;
var state_29746__$1 = (function (){var statearr_29761 = state_29746;
(statearr_29761[(13)] = inst_29703);

(statearr_29761[(15)] = inst_29704__$1);

return statearr_29761;
})();
var statearr_29762_29777 = state_29746__$1;
(statearr_29762_29777[(2)] = null);

(statearr_29762_29777[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__15091__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__15091__auto____0 = (function (){
var statearr_29763 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29763[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__15091__auto__);

(statearr_29763[(1)] = (1));

return statearr_29763;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__15091__auto____1 = (function (state_29746){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_29746);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e29764){var ex__15094__auto__ = e29764;
var statearr_29765_29778 = state_29746;
(statearr_29765_29778[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_29746[(4)]))){
var statearr_29766_29779 = state_29746;
(statearr_29766_29779[(1)] = cljs.core.first((state_29746[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__29780 = state_29746;
state_29746 = G__29780;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__15091__auto__ = function(state_29746){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__15091__auto____1.call(this,state_29746);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__15091__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__15091__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_29767 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_29767[(6)] = c__15165__auto__);

return statearr_29767;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__29782 = arguments.length;
switch (G__29782) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_29952){
var state_val_29953 = (state_29952[(1)]);
if((state_val_29953 === (65))){
var state_29952__$1 = state_29952;
var statearr_29954_30054 = state_29952__$1;
(statearr_29954_30054[(2)] = null);

(statearr_29954_30054[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (70))){
var inst_29947 = (state_29952[(2)]);
var _ = (function (){var statearr_29955 = state_29952;
(statearr_29955[(4)] = cljs.core.rest((state_29952[(4)])));

return statearr_29955;
})();
var state_29952__$1 = state_29952;
var statearr_29956_30055 = state_29952__$1;
(statearr_29956_30055[(2)] = inst_29947);

(statearr_29956_30055[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (62))){
var inst_29933 = (state_29952[(2)]);
var state_29952__$1 = state_29952;
var statearr_29957_30056 = state_29952__$1;
(statearr_29957_30056[(2)] = inst_29933);

(statearr_29957_30056[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (7))){
var state_29952__$1 = state_29952;
var statearr_29958_30057 = state_29952__$1;
(statearr_29958_30057[(2)] = false);

(statearr_29958_30057[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (59))){
var inst_29907 = (state_29952[(2)]);
var inst_29908 = fluree.db.util.async.throw_err(inst_29907);
var state_29952__$1 = state_29952;
var statearr_29959_30058 = state_29952__$1;
(statearr_29959_30058[(2)] = inst_29908);

(statearr_29959_30058[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (20))){
var state_29952__$1 = state_29952;
var statearr_29960_30059 = state_29952__$1;
(statearr_29960_30059[(2)] = null);

(statearr_29960_30059[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (58))){
var inst_29897 = (state_29952[(2)]);
var inst_29898 = fluree.db.util.async.throw_err(inst_29897);
var inst_29899 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_29898);
var state_29952__$1 = state_29952;
var statearr_29961_30060 = state_29952__$1;
(statearr_29961_30060[(2)] = inst_29899);

(statearr_29961_30060[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (60))){
var inst_29796 = (state_29952[(7)]);
var inst_29833 = (state_29952[(8)]);
var inst_29794 = (state_29952[(9)]);
var inst_29793 = (state_29952[(10)]);
var inst_29913 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29914 = [inst_29794,inst_29793,inst_29833,inst_29796];
var inst_29915 = (new cljs.core.PersistentVector(null,4,(5),inst_29913,inst_29914,null));
var inst_29916 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_29915,opts);
var state_29952__$1 = state_29952;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29952__$1,(63),inst_29916);
} else {
if((state_val_29953 === (27))){
var inst_29844 = (state_29952[(11)]);
var inst_29833 = (state_29952[(8)]);
var inst_29844__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_29833);
var state_29952__$1 = (function (){var statearr_29962 = state_29952;
(statearr_29962[(11)] = inst_29844__$1);

return statearr_29962;
})();
if(inst_29844__$1){
var statearr_29963_30061 = state_29952__$1;
(statearr_29963_30061[(1)] = (30));

} else {
var statearr_29964_30062 = state_29952__$1;
(statearr_29964_30062[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (1))){
var state_29952__$1 = state_29952;
var statearr_29965_30063 = state_29952__$1;
(statearr_29965_30063[(2)] = null);

(statearr_29965_30063[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (69))){
var inst_29939 = (state_29952[(12)]);
var state_29952__$1 = state_29952;
var statearr_29966_30064 = state_29952__$1;
(statearr_29966_30064[(2)] = inst_29939);

(statearr_29966_30064[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (24))){
var inst_29794 = (state_29952[(9)]);
var state_29952__$1 = state_29952;
if(cljs.core.truth_(inst_29794)){
var statearr_29967_30065 = state_29952__$1;
(statearr_29967_30065[(1)] = (27));

} else {
var statearr_29968_30066 = state_29952__$1;
(statearr_29968_30066[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (55))){
var inst_29833 = (state_29952[(8)]);
var inst_29891 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29892 = [inst_29833];
var inst_29893 = (new cljs.core.PersistentVector(null,1,(5),inst_29891,inst_29892,null));
var inst_29894 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$limit,(1));
var inst_29895 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_29893,inst_29894);
var state_29952__$1 = state_29952;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29952__$1,(58),inst_29895);
} else {
if((state_val_29953 === (39))){
var inst_29864 = (state_29952[(2)]);
var inst_29865 = fluree.db.util.async.throw_err(inst_29864);
var state_29952__$1 = state_29952;
var statearr_29969_30067 = state_29952__$1;
(statearr_29969_30067[(2)] = inst_29865);

(statearr_29969_30067[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (46))){
var inst_29877 = (state_29952[(13)]);
var inst_29877__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(opts);
var state_29952__$1 = (function (){var statearr_29970 = state_29952;
(statearr_29970[(13)] = inst_29877__$1);

return statearr_29970;
})();
if(cljs.core.truth_(inst_29877__$1)){
var statearr_29971_30068 = state_29952__$1;
(statearr_29971_30068[(1)] = (49));

} else {
var statearr_29972_30069 = state_29952__$1;
(statearr_29972_30069[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (4))){
var inst_29783 = (state_29952[(2)]);
var state_29952__$1 = state_29952;
var statearr_29973_30070 = state_29952__$1;
(statearr_29973_30070[(2)] = inst_29783);

(statearr_29973_30070[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (54))){
var inst_29889 = (state_29952[(2)]);
var state_29952__$1 = state_29952;
if(cljs.core.truth_(inst_29889)){
var statearr_29974_30071 = state_29952__$1;
(statearr_29974_30071[(1)] = (55));

} else {
var statearr_29975_30072 = state_29952__$1;
(statearr_29975_30072[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (15))){
var inst_29795 = (state_29952[(14)]);
var inst_29814 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_29795);
var state_29952__$1 = state_29952;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29952__$1,(18),inst_29814);
} else {
if((state_val_29953 === (48))){
var inst_29935 = (state_29952[(2)]);
var state_29952__$1 = state_29952;
var statearr_29976_30073 = state_29952__$1;
(statearr_29976_30073[(2)] = inst_29935);

(statearr_29976_30073[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (50))){
var inst_29808 = (state_29952[(15)]);
var inst_29797 = (state_29952[(16)]);
var inst_29796 = (state_29952[(7)]);
var inst_29833 = (state_29952[(8)]);
var inst_29792 = (state_29952[(17)]);
var inst_29803 = (state_29952[(18)]);
var inst_29794 = (state_29952[(9)]);
var inst_29877 = (state_29952[(13)]);
var inst_29793 = (state_29952[(10)]);
var inst_29881 = (function (){var t = inst_29796;
var temp__5802__auto__ = inst_29877;
var p = inst_29794;
var idx_predicate_QMARK_ = inst_29797;
var o = inst_29833;
var tag_predicate_QMARK_ = inst_29803;
var vec__29789 = inst_29792;
var s = inst_29793;
var o_coerce_QMARK_ = inst_29808;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_29952__$1 = state_29952;
var statearr_29977_30074 = state_29952__$1;
(statearr_29977_30074[(2)] = inst_29881);

(statearr_29977_30074[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (21))){
var inst_29829 = (state_29952[(2)]);
var state_29952__$1 = state_29952;
var statearr_29978_30075 = state_29952__$1;
(statearr_29978_30075[(2)] = inst_29829);

(statearr_29978_30075[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (31))){
var inst_29844 = (state_29952[(11)]);
var state_29952__$1 = state_29952;
var statearr_29979_30076 = state_29952__$1;
(statearr_29979_30076[(2)] = inst_29844);

(statearr_29979_30076[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (32))){
var inst_29854 = (state_29952[(2)]);
var state_29952__$1 = state_29952;
var statearr_29980_30077 = state_29952__$1;
(statearr_29980_30077[(2)] = inst_29854);

(statearr_29980_30077[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (40))){
var inst_29797 = (state_29952[(16)]);
var inst_29868 = (state_29952[(19)]);
var inst_29868__$1 = cljs.core.not(inst_29797);
var state_29952__$1 = (function (){var statearr_29981 = state_29952;
(statearr_29981[(19)] = inst_29868__$1);

return statearr_29981;
})();
if(inst_29868__$1){
var statearr_29982_30078 = state_29952__$1;
(statearr_29982_30078[(1)] = (43));

} else {
var statearr_29983_30079 = state_29952__$1;
(statearr_29983_30079[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (56))){
var inst_29796 = (state_29952[(7)]);
var inst_29794 = (state_29952[(9)]);
var inst_29883 = (state_29952[(20)]);
var inst_29793 = (state_29952[(10)]);
var inst_29901 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29902 = [inst_29794,inst_29793,null,inst_29796];
var inst_29903 = (new cljs.core.PersistentVector(null,4,(5),inst_29901,inst_29902,null));
var inst_29904 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$object_DASH_fn,inst_29883);
var inst_29905 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_29903,inst_29904);
var state_29952__$1 = state_29952;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29952__$1,(59),inst_29905);
} else {
if((state_val_29953 === (33))){
var inst_29833 = (state_29952[(8)]);
var inst_29847 = cljs.core.fn_QMARK_(inst_29833);
var inst_29848 = (!(inst_29847));
var state_29952__$1 = state_29952;
var statearr_29984_30080 = state_29952__$1;
(statearr_29984_30080[(2)] = inst_29848);

(statearr_29984_30080[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (13))){
var inst_29795 = (state_29952[(14)]);
var inst_29812 = fluree.db.query.range.tag_string_QMARK_(inst_29795);
var state_29952__$1 = state_29952;
if(cljs.core.truth_(inst_29812)){
var statearr_29985_30081 = state_29952__$1;
(statearr_29985_30081[(1)] = (15));

} else {
var statearr_29986_30082 = state_29952__$1;
(statearr_29986_30082[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (22))){
var inst_29825 = (state_29952[(2)]);
var inst_29826 = fluree.db.util.async.throw_err(inst_29825);
var state_29952__$1 = state_29952;
var statearr_29987_30083 = state_29952__$1;
(statearr_29987_30083[(2)] = inst_29826);

(statearr_29987_30083[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (36))){
var inst_29796 = (state_29952[(7)]);
var inst_29833 = (state_29952[(8)]);
var inst_29794 = (state_29952[(9)]);
var inst_29793 = (state_29952[(10)]);
var inst_29859 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29860 = [inst_29794,inst_29833,inst_29793,inst_29796];
var inst_29861 = (new cljs.core.PersistentVector(null,4,(5),inst_29859,inst_29860,null));
var inst_29862 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_29861,opts);
var state_29952__$1 = state_29952;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29952__$1,(39),inst_29862);
} else {
if((state_val_29953 === (41))){
var inst_29794 = (state_29952[(9)]);
var state_29952__$1 = state_29952;
var statearr_29988_30084 = state_29952__$1;
(statearr_29988_30084[(2)] = inst_29794);

(statearr_29988_30084[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (43))){
var inst_29833 = (state_29952[(8)]);
var state_29952__$1 = state_29952;
var statearr_29989_30085 = state_29952__$1;
(statearr_29989_30085[(2)] = inst_29833);

(statearr_29989_30085[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (61))){
var inst_29833 = (state_29952[(8)]);
var state_29952__$1 = state_29952;
if(cljs.core.truth_(inst_29833)){
var statearr_29990_30086 = state_29952__$1;
(statearr_29990_30086[(1)] = (64));

} else {
var statearr_29991_30087 = state_29952__$1;
(statearr_29991_30087[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (29))){
var inst_29857 = (state_29952[(2)]);
var state_29952__$1 = state_29952;
if(cljs.core.truth_(inst_29857)){
var statearr_29992_30088 = state_29952__$1;
(statearr_29992_30088[(1)] = (36));

} else {
var statearr_29993_30089 = state_29952__$1;
(statearr_29993_30089[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (44))){
var inst_29868 = (state_29952[(19)]);
var state_29952__$1 = state_29952;
var statearr_29994_30090 = state_29952__$1;
(statearr_29994_30090[(2)] = inst_29868);

(statearr_29994_30090[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (6))){
var inst_29794 = (state_29952[(9)]);
var inst_29799 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,inst_29794);
var inst_29800 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,inst_29799);
var state_29952__$1 = state_29952;
var statearr_29995_30091 = state_29952__$1;
(statearr_29995_30091[(2)] = inst_29800);

(statearr_29995_30091[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (28))){
var inst_29794 = (state_29952[(9)]);
var state_29952__$1 = state_29952;
var statearr_29996_30092 = state_29952__$1;
(statearr_29996_30092[(2)] = inst_29794);

(statearr_29996_30092[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (64))){
var inst_29796 = (state_29952[(7)]);
var inst_29833 = (state_29952[(8)]);
var inst_29794 = (state_29952[(9)]);
var inst_29793 = (state_29952[(10)]);
var inst_29922 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29923 = [inst_29833,inst_29794,inst_29793,inst_29796];
var inst_29924 = (new cljs.core.PersistentVector(null,4,(5),inst_29922,inst_29923,null));
var inst_29925 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_29924,opts);
var state_29952__$1 = state_29952;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29952__$1,(67),inst_29925);
} else {
if((state_val_29953 === (51))){
var inst_29884 = (state_29952[(21)]);
var inst_29794 = (state_29952[(9)]);
var inst_29883 = (state_29952[(2)]);
var inst_29884__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_29794);
var state_29952__$1 = (function (){var statearr_29997 = state_29952;
(statearr_29997[(21)] = inst_29884__$1);

(statearr_29997[(20)] = inst_29883);

return statearr_29997;
})();
if(inst_29884__$1){
var statearr_29998_30093 = state_29952__$1;
(statearr_29998_30093[(1)] = (52));

} else {
var statearr_29999_30094 = state_29952__$1;
(statearr_29999_30094[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (25))){
var inst_29803 = (state_29952[(18)]);
var inst_29939 = (state_29952[(2)]);
var state_29952__$1 = (function (){var statearr_30000 = state_29952;
(statearr_30000[(12)] = inst_29939);

return statearr_30000;
})();
if(cljs.core.truth_(inst_29803)){
var statearr_30001_30095 = state_29952__$1;
(statearr_30001_30095[(1)] = (68));

} else {
var statearr_30002_30096 = state_29952__$1;
(statearr_30002_30096[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (34))){
var inst_29797 = (state_29952[(16)]);
var state_29952__$1 = state_29952;
var statearr_30003_30097 = state_29952__$1;
(statearr_30003_30097[(2)] = inst_29797);

(statearr_30003_30097[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (17))){
var inst_29831 = (state_29952[(2)]);
var state_29952__$1 = state_29952;
var statearr_30004_30098 = state_29952__$1;
(statearr_30004_30098[(2)] = inst_29831);

(statearr_30004_30098[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (3))){
var inst_29950 = (state_29952[(2)]);
var state_29952__$1 = state_29952;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29952__$1,inst_29950);
} else {
if((state_val_29953 === (12))){
var inst_29795 = (state_29952[(14)]);
var state_29952__$1 = state_29952;
var statearr_30005_30099 = state_29952__$1;
(statearr_30005_30099[(2)] = inst_29795);

(statearr_30005_30099[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (2))){
var inst_29792 = (state_29952[(17)]);
var inst_29794 = (state_29952[(9)]);
var _ = (function (){var statearr_30006 = state_29952;
(statearr_30006[(4)] = cljs.core.cons((5),(state_29952[(4)])));

return statearr_30006;
})();
var inst_29792__$1 = fparts;
var inst_29793 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29792__$1,(0),null);
var inst_29794__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29792__$1,(1),null);
var inst_29795 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29792__$1,(2),null);
var inst_29796 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29792__$1,(3),null);
var inst_29797 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,inst_29794__$1);
var state_29952__$1 = (function (){var statearr_30007 = state_29952;
(statearr_30007[(16)] = inst_29797);

(statearr_30007[(7)] = inst_29796);

(statearr_30007[(14)] = inst_29795);

(statearr_30007[(17)] = inst_29792__$1);

(statearr_30007[(9)] = inst_29794__$1);

(statearr_30007[(10)] = inst_29793);

return statearr_30007;
})();
if(cljs.core.truth_(inst_29794__$1)){
var statearr_30008_30100 = state_29952__$1;
(statearr_30008_30100[(1)] = (6));

} else {
var statearr_30009_30101 = state_29952__$1;
(statearr_30009_30101[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (66))){
var inst_29931 = (state_29952[(2)]);
var state_29952__$1 = state_29952;
var statearr_30010_30102 = state_29952__$1;
(statearr_30010_30102[(2)] = inst_29931);

(statearr_30010_30102[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (23))){
var inst_29796 = (state_29952[(7)]);
var inst_29833 = (state_29952[(8)]);
var inst_29794 = (state_29952[(9)]);
var inst_29793 = (state_29952[(10)]);
var inst_29835 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29836 = [inst_29793,inst_29794,inst_29833,inst_29796];
var inst_29837 = (new cljs.core.PersistentVector(null,4,(5),inst_29835,inst_29836,null));
var inst_29838 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_29837,opts);
var state_29952__$1 = state_29952;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29952__$1,(26),inst_29838);
} else {
if((state_val_29953 === (47))){
var inst_29794 = (state_29952[(9)]);
var state_29952__$1 = state_29952;
if(cljs.core.truth_(inst_29794)){
var statearr_30011_30103 = state_29952__$1;
(statearr_30011_30103[(1)] = (60));

} else {
var statearr_30012_30104 = state_29952__$1;
(statearr_30012_30104[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (35))){
var inst_29851 = (state_29952[(2)]);
var state_29952__$1 = state_29952;
var statearr_30013_30105 = state_29952__$1;
(statearr_30013_30105[(2)] = inst_29851);

(statearr_30013_30105[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (19))){
var inst_29795 = (state_29952[(14)]);
var inst_29794 = (state_29952[(9)]);
var inst_29821 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_29794);
var inst_29822 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29821),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29795)].join('');
var inst_29823 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_29822);
var state_29952__$1 = state_29952;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29952__$1,(22),inst_29823);
} else {
if((state_val_29953 === (57))){
var inst_29910 = (state_29952[(2)]);
var state_29952__$1 = state_29952;
var statearr_30014_30106 = state_29952__$1;
(statearr_30014_30106[(2)] = inst_29910);

(statearr_30014_30106[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (68))){
var inst_29939 = (state_29952[(12)]);
var inst_29941 = fluree.db.query.range.coerce_tag_flakes(db,inst_29939);
var state_29952__$1 = state_29952;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29952__$1,(71),inst_29941);
} else {
if((state_val_29953 === (11))){
var inst_29808 = (state_29952[(15)]);
var inst_29808__$1 = (state_29952[(2)]);
var inst_29809 = cljs.core.not(inst_29808__$1);
var state_29952__$1 = (function (){var statearr_30016 = state_29952;
(statearr_30016[(15)] = inst_29808__$1);

return statearr_30016;
})();
if(inst_29809){
var statearr_30017_30107 = state_29952__$1;
(statearr_30017_30107[(1)] = (12));

} else {
var statearr_30018_30108 = state_29952__$1;
(statearr_30018_30108[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (9))){
var inst_29795 = (state_29952[(14)]);
var inst_29805 = typeof inst_29795 === 'string';
var state_29952__$1 = state_29952;
var statearr_30019_30109 = state_29952__$1;
(statearr_30019_30109[(2)] = inst_29805);

(statearr_30019_30109[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (5))){
var _ = (function (){var statearr_30020 = state_29952;
(statearr_30020[(4)] = cljs.core.rest((state_29952[(4)])));

return statearr_30020;
})();
var state_29952__$1 = state_29952;
var ex30015 = (state_29952__$1[(2)]);
var statearr_30021_30110 = state_29952__$1;
(statearr_30021_30110[(5)] = ex30015);


if((ex30015 instanceof Error)){
var statearr_30022_30111 = state_29952__$1;
(statearr_30022_30111[(1)] = (4));

(statearr_30022_30111[(5)] = null);

} else {
throw ex30015;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (14))){
var inst_29793 = (state_29952[(10)]);
var inst_29833 = (state_29952[(2)]);
var state_29952__$1 = (function (){var statearr_30023 = state_29952;
(statearr_30023[(8)] = inst_29833);

return statearr_30023;
})();
if(cljs.core.truth_(inst_29793)){
var statearr_30024_30112 = state_29952__$1;
(statearr_30024_30112[(1)] = (23));

} else {
var statearr_30025_30113 = state_29952__$1;
(statearr_30025_30113[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (45))){
var inst_29872 = (state_29952[(2)]);
var state_29952__$1 = state_29952;
var statearr_30026_30114 = state_29952__$1;
(statearr_30026_30114[(2)] = inst_29872);

(statearr_30026_30114[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (53))){
var inst_29884 = (state_29952[(21)]);
var state_29952__$1 = state_29952;
var statearr_30027_30115 = state_29952__$1;
(statearr_30027_30115[(2)] = inst_29884);

(statearr_30027_30115[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (26))){
var inst_29840 = (state_29952[(2)]);
var inst_29841 = fluree.db.util.async.throw_err(inst_29840);
var state_29952__$1 = state_29952;
var statearr_30028_30116 = state_29952__$1;
(statearr_30028_30116[(2)] = inst_29841);

(statearr_30028_30116[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (16))){
var inst_29795 = (state_29952[(14)]);
var inst_29819 = typeof inst_29795 === 'string';
var state_29952__$1 = state_29952;
if(cljs.core.truth_(inst_29819)){
var statearr_30029_30117 = state_29952__$1;
(statearr_30029_30117[(1)] = (19));

} else {
var statearr_30030_30118 = state_29952__$1;
(statearr_30030_30118[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (38))){
var inst_29937 = (state_29952[(2)]);
var state_29952__$1 = state_29952;
var statearr_30031_30119 = state_29952__$1;
(statearr_30031_30119[(2)] = inst_29937);

(statearr_30031_30119[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (30))){
var inst_29797 = (state_29952[(16)]);
var state_29952__$1 = state_29952;
if(cljs.core.truth_(inst_29797)){
var statearr_30032_30120 = state_29952__$1;
(statearr_30032_30120[(1)] = (33));

} else {
var statearr_30033_30121 = state_29952__$1;
(statearr_30033_30121[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (10))){
var inst_29803 = (state_29952[(18)]);
var state_29952__$1 = state_29952;
var statearr_30034_30122 = state_29952__$1;
(statearr_30034_30122[(2)] = inst_29803);

(statearr_30034_30122[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (18))){
var inst_29816 = (state_29952[(2)]);
var inst_29817 = fluree.db.util.async.throw_err(inst_29816);
var state_29952__$1 = state_29952;
var statearr_30035_30123 = state_29952__$1;
(statearr_30035_30123[(2)] = inst_29817);

(statearr_30035_30123[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (52))){
var inst_29833 = (state_29952[(8)]);
var inst_29886 = cljs.core.int_QMARK_(inst_29833);
var state_29952__$1 = state_29952;
var statearr_30036_30124 = state_29952__$1;
(statearr_30036_30124[(2)] = inst_29886);

(statearr_30036_30124[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (67))){
var inst_29927 = (state_29952[(2)]);
var inst_29928 = fluree.db.util.async.throw_err(inst_29927);
var state_29952__$1 = state_29952;
var statearr_30037_30125 = state_29952__$1;
(statearr_30037_30125[(2)] = inst_29928);

(statearr_30037_30125[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (71))){
var inst_29943 = (state_29952[(2)]);
var inst_29944 = fluree.db.util.async.throw_err(inst_29943);
var state_29952__$1 = state_29952;
var statearr_30038_30126 = state_29952__$1;
(statearr_30038_30126[(2)] = inst_29944);

(statearr_30038_30126[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (42))){
var inst_29875 = (state_29952[(2)]);
var state_29952__$1 = state_29952;
if(cljs.core.truth_(inst_29875)){
var statearr_30039_30127 = state_29952__$1;
(statearr_30039_30127[(1)] = (46));

} else {
var statearr_30040_30128 = state_29952__$1;
(statearr_30040_30128[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (37))){
var inst_29794 = (state_29952[(9)]);
var state_29952__$1 = state_29952;
if(cljs.core.truth_(inst_29794)){
var statearr_30041_30129 = state_29952__$1;
(statearr_30041_30129[(1)] = (40));

} else {
var statearr_30042_30130 = state_29952__$1;
(statearr_30042_30130[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (63))){
var inst_29918 = (state_29952[(2)]);
var inst_29919 = fluree.db.util.async.throw_err(inst_29918);
var state_29952__$1 = state_29952;
var statearr_30043_30131 = state_29952__$1;
(statearr_30043_30131[(2)] = inst_29919);

(statearr_30043_30131[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (8))){
var inst_29803 = (state_29952[(18)]);
var inst_29803__$1 = (state_29952[(2)]);
var state_29952__$1 = (function (){var statearr_30044 = state_29952;
(statearr_30044[(18)] = inst_29803__$1);

return statearr_30044;
})();
if(cljs.core.truth_(inst_29803__$1)){
var statearr_30045_30132 = state_29952__$1;
(statearr_30045_30132[(1)] = (9));

} else {
var statearr_30046_30133 = state_29952__$1;
(statearr_30046_30133[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29953 === (49))){
var inst_29808 = (state_29952[(15)]);
var inst_29797 = (state_29952[(16)]);
var inst_29796 = (state_29952[(7)]);
var inst_29833 = (state_29952[(8)]);
var inst_29792 = (state_29952[(17)]);
var inst_29803 = (state_29952[(18)]);
var inst_29794 = (state_29952[(9)]);
var inst_29877 = (state_29952[(13)]);
var inst_29793 = (state_29952[(10)]);
var inst_29879 = (function (){var obj_fn = inst_29877;
var t = inst_29796;
var temp__5802__auto__ = inst_29877;
var p = inst_29794;
var idx_predicate_QMARK_ = inst_29797;
var o = inst_29833;
var tag_predicate_QMARK_ = inst_29803;
var vec__29789 = inst_29792;
var s = inst_29793;
var o_coerce_QMARK_ = inst_29808;
return (function (x){
var and__5043__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__5043__auto__;
}
});
})();
var state_29952__$1 = state_29952;
var statearr_30047_30134 = state_29952__$1;
(statearr_30047_30134[(2)] = inst_29879);

(statearr_30047_30134[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__15091__auto__ = null;
var fluree$db$query$range$state_machine__15091__auto____0 = (function (){
var statearr_30048 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30048[(0)] = fluree$db$query$range$state_machine__15091__auto__);

(statearr_30048[(1)] = (1));

return statearr_30048;
});
var fluree$db$query$range$state_machine__15091__auto____1 = (function (state_29952){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_29952);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e30049){var ex__15094__auto__ = e30049;
var statearr_30050_30135 = state_29952;
(statearr_30050_30135[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_29952[(4)]))){
var statearr_30051_30136 = state_29952;
(statearr_30051_30136[(1)] = cljs.core.first((state_29952[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__30137 = state_29952;
state_29952 = G__30137;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__15091__auto__ = function(state_29952){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__15091__auto____1.call(this,state_29952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__15091__auto____0;
fluree$db$query$range$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__15091__auto____1;
return fluree$db$query$range$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_30052 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_30052[(6)] = c__15165__auto__);

return statearr_30052;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__30139 = arguments.length;
switch (G__30139) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_30174){
var state_val_30175 = (state_30174[(1)]);
if((state_val_30175 === (7))){
var inst_30161 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_30162 = ["Invalid collection name: ",inst_30161].join('');
var inst_30163 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_30164 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_collection];
var inst_30165 = cljs.core.PersistentHashMap.fromArrays(inst_30163,inst_30164);
var inst_30166 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_30162,inst_30165);
var inst_30167 = (function(){throw inst_30166})();
var state_30174__$1 = state_30174;
var statearr_30176_30196 = state_30174__$1;
(statearr_30176_30196[(2)] = inst_30167);

(statearr_30176_30196[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30175 === (1))){
var state_30174__$1 = state_30174;
var statearr_30177_30197 = state_30174__$1;
(statearr_30177_30197[(2)] = null);

(statearr_30177_30197[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30175 === (4))){
var inst_30140 = (state_30174[(2)]);
var state_30174__$1 = state_30174;
var statearr_30178_30198 = state_30174__$1;
(statearr_30178_30198[(2)] = inst_30140);

(statearr_30178_30198[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30175 === (6))){
var inst_30146 = (state_30174[(7)]);
var inst_30148 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30149 = fluree.db.flake.max_subject_id(inst_30146);
var inst_30150 = [inst_30149];
var inst_30151 = (new cljs.core.PersistentVector(null,1,(5),inst_30148,inst_30150,null));
var inst_30152 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30153 = fluree.db.flake.min_subject_id(inst_30146);
var inst_30154 = [inst_30153];
var inst_30155 = (new cljs.core.PersistentVector(null,1,(5),inst_30152,inst_30154,null));
var inst_30156 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_30151,cljs.core._LT__EQ_,inst_30155,opts);
var state_30174__$1 = state_30174;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30174__$1,(9),inst_30156);
} else {
if((state_val_30175 === (3))){
var inst_30172 = (state_30174[(2)]);
var state_30174__$1 = state_30174;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30174__$1,inst_30172);
} else {
if((state_val_30175 === (2))){
var inst_30146 = (state_30174[(7)]);
var _ = (function (){var statearr_30180 = state_30174;
(statearr_30180[(4)] = cljs.core.cons((5),(state_30174[(4)])));

return statearr_30180;
})();
var inst_30146__$1 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$partition,name);
var state_30174__$1 = (function (){var statearr_30181 = state_30174;
(statearr_30181[(7)] = inst_30146__$1);

return statearr_30181;
})();
if(cljs.core.truth_(inst_30146__$1)){
var statearr_30182_30199 = state_30174__$1;
(statearr_30182_30199[(1)] = (6));

} else {
var statearr_30183_30200 = state_30174__$1;
(statearr_30183_30200[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30175 === (9))){
var inst_30158 = (state_30174[(2)]);
var inst_30159 = fluree.db.util.async.throw_err(inst_30158);
var state_30174__$1 = state_30174;
var statearr_30184_30201 = state_30174__$1;
(statearr_30184_30201[(2)] = inst_30159);

(statearr_30184_30201[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30175 === (5))){
var _ = (function (){var statearr_30185 = state_30174;
(statearr_30185[(4)] = cljs.core.rest((state_30174[(4)])));

return statearr_30185;
})();
var state_30174__$1 = state_30174;
var ex30179 = (state_30174__$1[(2)]);
var statearr_30186_30202 = state_30174__$1;
(statearr_30186_30202[(5)] = ex30179);


var statearr_30187_30203 = state_30174__$1;
(statearr_30187_30203[(1)] = (4));

(statearr_30187_30203[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_30175 === (8))){
var inst_30169 = (state_30174[(2)]);
var _ = (function (){var statearr_30188 = state_30174;
(statearr_30188[(4)] = cljs.core.rest((state_30174[(4)])));

return statearr_30188;
})();
var state_30174__$1 = state_30174;
var statearr_30189_30204 = state_30174__$1;
(statearr_30189_30204[(2)] = inst_30169);

(statearr_30189_30204[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__15091__auto__ = null;
var fluree$db$query$range$state_machine__15091__auto____0 = (function (){
var statearr_30190 = [null,null,null,null,null,null,null,null];
(statearr_30190[(0)] = fluree$db$query$range$state_machine__15091__auto__);

(statearr_30190[(1)] = (1));

return statearr_30190;
});
var fluree$db$query$range$state_machine__15091__auto____1 = (function (state_30174){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_30174);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e30191){var ex__15094__auto__ = e30191;
var statearr_30192_30205 = state_30174;
(statearr_30192_30205[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_30174[(4)]))){
var statearr_30193_30206 = state_30174;
(statearr_30193_30206[(1)] = cljs.core.first((state_30174[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__30207 = state_30174;
state_30174 = G__30207;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__15091__auto__ = function(state_30174){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__15091__auto____1.call(this,state_30174);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__15091__auto____0;
fluree$db$query$range$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__15091__auto____1;
return fluree$db$query$range$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_30194 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_30194[(6)] = c__15165__auto__);

return statearr_30194;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__30211 = flakes;
var vec__30212 = G__30211;
var seq__30213 = cljs.core.seq(vec__30212);
var first__30214 = cljs.core.first(seq__30213);
var seq__30213__$1 = cljs.core.next(seq__30213);
var flake_SINGLEQUOTE_ = first__30214;
var r = seq__30213__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__30211__$1 = G__30211;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__30220 = G__30211__$1;
var seq__30221 = cljs.core.seq(vec__30220);
var first__30222 = cljs.core.first(seq__30221);
var seq__30221__$1 = cljs.core.next(seq__30221);
var flake_SINGLEQUOTE___$1 = first__30222;
var r__$1 = seq__30221__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e30224){var e = e30224;
return null;
}})();
var map__30223 = cmd_map;
var map__30223__$1 = cljs.core.__destructure_map(map__30223);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30223__$1,cljs.core.cst$kw$type);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30223__$1,cljs.core.cst$kw$db);
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30223__$1,cljs.core.cst$kw$tx);
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30223__$1,cljs.core.cst$kw$nonce);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30223__$1,cljs.core.cst$kw$auth);
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30223__$1,cljs.core.cst$kw$expire);
var G__30225 = r__$1;
var G__30226 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$tx,tx,cljs.core.cst$kw$nonce,nonce,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$expire,expire], null)):result_STAR___$2);
G__30211__$1 = G__30225;
result_STAR___$1 = G__30226;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__30235 = blocks;
var vec__30236 = G__30235;
var seq__30237 = cljs.core.seq(vec__30236);
var first__30238 = cljs.core.first(seq__30237);
var seq__30237__$1 = cljs.core.next(seq__30237);
var block_SINGLEQUOTE_ = first__30238;
var r = seq__30237__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__30235__$1 = G__30235;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__30243 = G__30235__$1;
var seq__30244 = cljs.core.seq(vec__30243);
var first__30245 = cljs.core.first(seq__30244);
var seq__30244__$1 = cljs.core.next(seq__30244);
var block_SINGLEQUOTE___$1 = first__30245;
var r__$1 = seq__30244__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__30246 = block_SINGLEQUOTE___$1;
var map__30246__$1 = cljs.core.__destructure_map(map__30246);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30246__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30246__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30246__$1,cljs.core.cst$kw$flakes);
var prev_hash = cljs.core.some(((function (G__30235__$1,result_STAR___$1,map__30246,map__30246__$1,block,t,flakes,vec__30243,seq__30244,first__30245,seq__30244__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__30235,vec__30236,seq__30237,first__30238,seq__30237__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__30227_SHARP_){
var f = p1__30227_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(2))){
return f.o;
} else {
return null;
}
});})(G__30235__$1,result_STAR___$1,map__30246,map__30246__$1,block,t,flakes,vec__30243,seq__30244,first__30245,seq__30244__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__30235,vec__30236,seq__30237,first__30238,seq__30237__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__30235__$1,result_STAR___$1,map__30246,map__30246__$1,block,t,flakes,prev_hash,vec__30243,seq__30244,first__30245,seq__30244__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__30235,vec__30236,seq__30237,first__30238,seq__30237__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__30228_SHARP_){
var f = p1__30228_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(1))){
return f.o;
} else {
return null;
}
});})(G__30235__$1,result_STAR___$1,map__30246,map__30246__$1,block,t,flakes,prev_hash,vec__30243,seq__30244,first__30245,seq__30244__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__30235,vec__30236,seq__30237,first__30238,seq__30237__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__30235__$1,result_STAR___$1,map__30246,map__30246__$1,block,t,flakes,prev_hash,hash,vec__30243,seq__30244,first__30245,seq__30244__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__30235,vec__30236,seq__30237,first__30238,seq__30237__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__30229_SHARP_){
var f = p1__30229_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(5))){
return f.o;
} else {
return null;
}
});})(G__30235__$1,result_STAR___$1,map__30246,map__30246__$1,block,t,flakes,prev_hash,hash,vec__30243,seq__30244,first__30245,seq__30244__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__30235,vec__30236,seq__30237,first__30238,seq__30237__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__30235__$1,result_STAR___$1,map__30246,map__30246__$1,block,t,flakes,prev_hash,hash,instant,vec__30243,seq__30244,first__30245,seq__30244__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__30235,vec__30236,seq__30237,first__30238,seq__30237__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__30230_SHARP_){
var f = p1__30230_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(7))){
return f.o;
} else {
return null;
}
});})(G__30235__$1,result_STAR___$1,map__30246,map__30246__$1,block,t,flakes,prev_hash,hash,instant,vec__30243,seq__30244,first__30245,seq__30244__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__30235,vec__30236,seq__30237,first__30238,seq__30237__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__30235__$1,result_STAR___$1,map__30246,map__30246__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__30243,seq__30244,first__30245,seq__30244__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__30235,vec__30236,seq__30237,first__30238,seq__30237__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__30231_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__30231_SHARP_.p,(106));
});})(G__30235__$1,result_STAR___$1,map__30246,map__30246__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__30243,seq__30244,first__30245,seq__30244__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__30235,vec__30236,seq__30237,first__30238,seq__30237__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__30247 = r__$1;
var G__30248 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$prev_DASH_hash,prev_hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$sigs,sigs,cljs.core.cst$kw$flakes,flakes,cljs.core.cst$kw$txn,txn_flakes_SINGLEQUOTE_], null));
G__30235__$1 = G__30247;
result_STAR___$1 = G__30248;
continue;
}
break;
}
});
