// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_30266){
var state_val_30267 = (state_30266[(1)]);
if((state_val_30267 === (1))){
var state_30266__$1 = state_30266;
var statearr_30268_30282 = state_30266__$1;
(statearr_30268_30282[(2)] = null);

(statearr_30268_30282[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (2))){
var _ = (function (){var statearr_30269 = state_30266;
(statearr_30269[(4)] = cljs.core.cons((5),(state_30266[(4)])));

return statearr_30269;
})();
var inst_30257 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_30266__$1 = state_30266;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30266__$1,(6),inst_30257);
} else {
if((state_val_30267 === (3))){
var inst_30264 = (state_30266[(2)]);
var state_30266__$1 = state_30266;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30266__$1,inst_30264);
} else {
if((state_val_30267 === (4))){
var inst_30251 = (state_30266[(2)]);
var state_30266__$1 = state_30266;
var statearr_30271_30283 = state_30266__$1;
(statearr_30271_30283[(2)] = inst_30251);

(statearr_30271_30283[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (5))){
var _ = (function (){var statearr_30272 = state_30266;
(statearr_30272[(4)] = cljs.core.rest((state_30266[(4)])));

return statearr_30272;
})();
var state_30266__$1 = state_30266;
var ex30270 = (state_30266__$1[(2)]);
var statearr_30273_30284 = state_30266__$1;
(statearr_30273_30284[(5)] = ex30270);


if((ex30270 instanceof Error)){
var statearr_30274_30285 = state_30266__$1;
(statearr_30274_30285[(1)] = (4));

(statearr_30274_30285[(5)] = null);

} else {
throw ex30270;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (6))){
var inst_30259 = (state_30266[(2)]);
var inst_30260 = fluree.db.util.async.throw_err(inst_30259);
var inst_30261 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_30260);
var _ = (function (){var statearr_30275 = state_30266;
(statearr_30275[(4)] = cljs.core.rest((state_30266[(4)])));

return statearr_30275;
})();
var state_30266__$1 = state_30266;
var statearr_30276_30286 = state_30266__$1;
(statearr_30276_30286[(2)] = inst_30261);

(statearr_30276_30286[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__15091__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__15091__auto____0 = (function (){
var statearr_30277 = [null,null,null,null,null,null,null];
(statearr_30277[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__15091__auto__);

(statearr_30277[(1)] = (1));

return statearr_30277;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__15091__auto____1 = (function (state_30266){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_30266);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e30278){var ex__15094__auto__ = e30278;
var statearr_30279_30287 = state_30266;
(statearr_30279_30287[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_30266[(4)]))){
var statearr_30280_30288 = state_30266;
(statearr_30280_30288[(1)] = cljs.core.first((state_30266[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__30289 = state_30266;
state_30266 = G__30289;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__15091__auto__ = function(state_30266){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__15091__auto____1.call(this,state_30266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__15091__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__15091__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_30281 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_30281[(6)] = c__15165__auto__);

return statearr_30281;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_30321){
var state_val_30322 = (state_30321[(1)]);
if((state_val_30322 === (7))){
var inst_30305 = (state_30321[(7)]);
var inst_30307 = cljs.core.empty_QMARK_(inst_30305);
var inst_30308 = (!(inst_30307));
var state_30321__$1 = state_30321;
var statearr_30323_30347 = state_30321__$1;
(statearr_30323_30347[(2)] = inst_30308);

(statearr_30323_30347[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30322 === (1))){
var state_30321__$1 = state_30321;
var statearr_30324_30348 = state_30321__$1;
(statearr_30324_30348[(2)] = null);

(statearr_30324_30348[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30322 === (4))){
var inst_30291 = (state_30321[(2)]);
var state_30321__$1 = state_30321;
var statearr_30325_30349 = state_30321__$1;
(statearr_30325_30349[(2)] = inst_30291);

(statearr_30325_30349[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30322 === (6))){
var inst_30297 = (state_30321[(8)]);
var inst_30305 = (state_30321[(7)]);
var inst_30303 = (state_30321[(2)]);
var inst_30304 = fluree.db.util.async.throw_err(inst_30303);
var inst_30305__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_30297,inst_30304);
var state_30321__$1 = (function (){var statearr_30326 = state_30321;
(statearr_30326[(7)] = inst_30305__$1);

return statearr_30326;
})();
if(cljs.core.truth_(inst_30305__$1)){
var statearr_30327_30350 = state_30321__$1;
(statearr_30327_30350[(1)] = (7));

} else {
var statearr_30328_30351 = state_30321__$1;
(statearr_30328_30351[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30322 === (3))){
var inst_30319 = (state_30321[(2)]);
var state_30321__$1 = state_30321;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30321__$1,inst_30319);
} else {
if((state_val_30322 === (12))){
var inst_30316 = (state_30321[(2)]);
var _ = (function (){var statearr_30329 = state_30321;
(statearr_30329[(4)] = cljs.core.rest((state_30321[(4)])));

return statearr_30329;
})();
var state_30321__$1 = state_30321;
var statearr_30330_30352 = state_30321__$1;
(statearr_30330_30352[(2)] = inst_30316);

(statearr_30330_30352[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30322 === (2))){
var _ = (function (){var statearr_30331 = state_30321;
(statearr_30331[(4)] = cljs.core.cons((5),(state_30321[(4)])));

return statearr_30331;
})();
var inst_30297 = (function (){return (function (p1__30290_SHARP_){
return p1__30290_SHARP_.o;
});
})();
var inst_30298 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30299 = [pred_id];
var inst_30300 = (new cljs.core.PersistentVector(null,1,(5),inst_30298,inst_30299,null));
var inst_30301 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_30300);
var state_30321__$1 = (function (){var statearr_30332 = state_30321;
(statearr_30332[(8)] = inst_30297);

return statearr_30332;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30321__$1,(6),inst_30301);
} else {
if((state_val_30322 === (11))){
var state_30321__$1 = state_30321;
var statearr_30334_30353 = state_30321__$1;
(statearr_30334_30353[(2)] = true);

(statearr_30334_30353[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30322 === (9))){
var inst_30311 = (state_30321[(2)]);
var state_30321__$1 = state_30321;
if(cljs.core.truth_(inst_30311)){
var statearr_30335_30354 = state_30321__$1;
(statearr_30335_30354[(1)] = (10));

} else {
var statearr_30336_30355 = state_30321__$1;
(statearr_30336_30355[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30322 === (5))){
var _ = (function (){var statearr_30337 = state_30321;
(statearr_30337[(4)] = cljs.core.rest((state_30321[(4)])));

return statearr_30337;
})();
var state_30321__$1 = state_30321;
var ex30333 = (state_30321__$1[(2)]);
var statearr_30338_30356 = state_30321__$1;
(statearr_30338_30356[(5)] = ex30333);


if((ex30333 instanceof Error)){
var statearr_30339_30357 = state_30321__$1;
(statearr_30339_30357[(1)] = (4));

(statearr_30339_30357[(5)] = null);

} else {
throw ex30333;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30322 === (10))){
var inst_30305 = (state_30321[(7)]);
var inst_30313 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_30305);
var state_30321__$1 = state_30321;
var statearr_30340_30358 = state_30321__$1;
(statearr_30340_30358[(2)] = inst_30313);

(statearr_30340_30358[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30322 === (8))){
var inst_30305 = (state_30321[(7)]);
var state_30321__$1 = state_30321;
var statearr_30341_30359 = state_30321__$1;
(statearr_30341_30359[(2)] = inst_30305);

(statearr_30341_30359[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__15091__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__15091__auto____0 = (function (){
var statearr_30342 = [null,null,null,null,null,null,null,null,null];
(statearr_30342[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__15091__auto__);

(statearr_30342[(1)] = (1));

return statearr_30342;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__15091__auto____1 = (function (state_30321){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_30321);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e30343){var ex__15094__auto__ = e30343;
var statearr_30344_30360 = state_30321;
(statearr_30344_30360[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_30321[(4)]))){
var statearr_30345_30361 = state_30321;
(statearr_30345_30361[(1)] = cljs.core.first((state_30321[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__30362 = state_30321;
state_30321 = G__30362;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__15091__auto__ = function(state_30321){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__15091__auto____1.call(this,state_30321);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__15091__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__15091__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_30346 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_30346[(6)] = c__15165__auto__);

return statearr_30346;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_30443){
var state_val_30444 = (state_30443[(1)]);
if((state_val_30444 === (7))){
var state_30443__$1 = state_30443;
var statearr_30445_30483 = state_30443__$1;
(statearr_30445_30483[(2)] = flakes);

(statearr_30445_30483[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30444 === (20))){
var inst_30400 = (state_30443[(7)]);
var inst_30433 = (state_30443[(2)]);
var inst_30392 = inst_30400;
var inst_30393 = inst_30433;
var state_30443__$1 = (function (){var statearr_30446 = state_30443;
(statearr_30446[(8)] = inst_30392);

(statearr_30446[(9)] = inst_30393);

return statearr_30446;
})();
var statearr_30447_30484 = state_30443__$1;
(statearr_30447_30484[(2)] = null);

(statearr_30447_30484[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30444 === (1))){
var state_30443__$1 = state_30443;
var statearr_30448_30485 = state_30443__$1;
(statearr_30448_30485[(2)] = null);

(statearr_30448_30485[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30444 === (4))){
var inst_30365 = (state_30443[(2)]);
var state_30443__$1 = state_30443;
var statearr_30449_30486 = state_30443__$1;
(statearr_30449_30486[(2)] = inst_30365);

(statearr_30449_30486[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30444 === (15))){
var inst_30399 = (state_30443[(10)]);
var inst_30417 = inst_30399.o;
var state_30443__$1 = state_30443;
var statearr_30450_30487 = state_30443__$1;
(statearr_30450_30487[(2)] = inst_30417);

(statearr_30450_30487[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30444 === (13))){
var inst_30436 = (state_30443[(2)]);
var state_30443__$1 = state_30443;
var statearr_30451_30488 = state_30443__$1;
(statearr_30451_30488[(2)] = inst_30436);

(statearr_30451_30488[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30444 === (6))){
var inst_30372 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_30443__$1 = state_30443;
var statearr_30452_30489 = state_30443__$1;
(statearr_30452_30489[(2)] = inst_30372);

(statearr_30452_30489[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30444 === (17))){
var inst_30414 = (state_30443[(2)]);
var inst_30415 = fluree.db.util.async.throw_err(inst_30414);
var state_30443__$1 = state_30443;
var statearr_30453_30490 = state_30443__$1;
(statearr_30453_30490[(2)] = inst_30415);

(statearr_30453_30490[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30444 === (3))){
var inst_30441 = (state_30443[(2)]);
var state_30443__$1 = state_30443;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30443__$1,inst_30441);
} else {
if((state_val_30444 === (12))){
var inst_30399 = (state_30443[(10)]);
var inst_30406 = (state_30443[(11)]);
var inst_30404 = inst_30399.p;
var inst_30405 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_30404);
var inst_30406__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_30405);
var inst_30407 = inst_30399.op;
var inst_30408 = inst_30407 === false;
var inst_30409 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$type,inst_30406__$1);
var state_30443__$1 = (function (){var statearr_30454 = state_30443;
(statearr_30454[(11)] = inst_30406__$1);

(statearr_30454[(12)] = inst_30408);

return statearr_30454;
})();
if(inst_30409){
var statearr_30455_30491 = state_30443__$1;
(statearr_30455_30491[(1)] = (14));

} else {
var statearr_30456_30492 = state_30443__$1;
(statearr_30456_30492[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30444 === (2))){
var _ = (function (){var statearr_30457 = state_30443;
(statearr_30457[(4)] = cljs.core.cons((5),(state_30443[(4)])));

return statearr_30457;
})();
var state_30443__$1 = state_30443;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_30458_30493 = state_30443__$1;
(statearr_30458_30493[(1)] = (6));

} else {
var statearr_30459_30494 = state_30443__$1;
(statearr_30459_30494[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30444 === (19))){
var inst_30399 = (state_30443[(10)]);
var inst_30393 = (state_30443[(9)]);
var inst_30406 = (state_30443[(11)]);
var inst_30419 = (state_30443[(13)]);
var inst_30427 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30428 = inst_30399.s;
var inst_30429 = [inst_30428,inst_30406,cljs.core.cst$kw$new];
var inst_30430 = (new cljs.core.PersistentVector(null,3,(5),inst_30427,inst_30429,null));
var inst_30431 = cljs.core.assoc_in(inst_30393,inst_30430,inst_30419);
var state_30443__$1 = state_30443;
var statearr_30460_30495 = state_30443__$1;
(statearr_30460_30495[(2)] = inst_30431);

(statearr_30460_30495[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30444 === (11))){
var inst_30393 = (state_30443[(9)]);
var state_30443__$1 = state_30443;
var statearr_30462_30496 = state_30443__$1;
(statearr_30462_30496[(2)] = inst_30393);

(statearr_30462_30496[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30444 === (9))){
var inst_30392 = (state_30443[(8)]);
var inst_30399 = (state_30443[(10)]);
var inst_30398 = cljs.core.seq(inst_30392);
var inst_30399__$1 = cljs.core.first(inst_30398);
var inst_30400 = cljs.core.next(inst_30398);
var inst_30401 = cljs.core.not(inst_30399__$1);
var state_30443__$1 = (function (){var statearr_30463 = state_30443;
(statearr_30463[(10)] = inst_30399__$1);

(statearr_30463[(7)] = inst_30400);

return statearr_30463;
})();
if(inst_30401){
var statearr_30464_30497 = state_30443__$1;
(statearr_30464_30497[(1)] = (11));

} else {
var statearr_30465_30498 = state_30443__$1;
(statearr_30465_30498[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30444 === (5))){
var _ = (function (){var statearr_30466 = state_30443;
(statearr_30466[(4)] = cljs.core.rest((state_30443[(4)])));

return statearr_30466;
})();
var state_30443__$1 = state_30443;
var ex30461 = (state_30443__$1[(2)]);
var statearr_30467_30499 = state_30443__$1;
(statearr_30467_30499[(5)] = ex30461);


if((ex30461 instanceof Error)){
var statearr_30468_30500 = state_30443__$1;
(statearr_30468_30500[(1)] = (4));

(statearr_30468_30500[(5)] = null);

} else {
throw ex30461;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30444 === (14))){
var inst_30399 = (state_30443[(10)]);
var inst_30411 = inst_30399.o;
var inst_30412 = fluree.db.query.schema.convert_type_to_kw(inst_30411,db);
var state_30443__$1 = state_30443;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30443__$1,(17),inst_30412);
} else {
if((state_val_30444 === (16))){
var inst_30408 = (state_30443[(12)]);
var inst_30419 = (state_30443[(2)]);
var state_30443__$1 = (function (){var statearr_30469 = state_30443;
(statearr_30469[(13)] = inst_30419);

return statearr_30469;
})();
if(cljs.core.truth_(inst_30408)){
var statearr_30470_30501 = state_30443__$1;
(statearr_30470_30501[(1)] = (18));

} else {
var statearr_30471_30502 = state_30443__$1;
(statearr_30471_30502[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30444 === (10))){
var inst_30438 = (state_30443[(2)]);
var _ = (function (){var statearr_30472 = state_30443;
(statearr_30472[(4)] = cljs.core.rest((state_30443[(4)])));

return statearr_30472;
})();
var state_30443__$1 = state_30443;
var statearr_30473_30503 = state_30443__$1;
(statearr_30473_30503[(2)] = inst_30438);

(statearr_30473_30503[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30444 === (18))){
var inst_30399 = (state_30443[(10)]);
var inst_30393 = (state_30443[(9)]);
var inst_30406 = (state_30443[(11)]);
var inst_30419 = (state_30443[(13)]);
var inst_30421 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30422 = inst_30399.s;
var inst_30423 = [inst_30422,inst_30406,cljs.core.cst$kw$old];
var inst_30424 = (new cljs.core.PersistentVector(null,3,(5),inst_30421,inst_30423,null));
var inst_30425 = cljs.core.assoc_in(inst_30393,inst_30424,inst_30419);
var state_30443__$1 = state_30443;
var statearr_30474_30504 = state_30443__$1;
(statearr_30474_30504[(2)] = inst_30425);

(statearr_30474_30504[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30444 === (8))){
var inst_30375 = (state_30443[(2)]);
var inst_30376 = cljs.core.PersistentHashSet.EMPTY;
var inst_30377 = cljs.core.vals(tempids);
var inst_30378 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_30376,inst_30377);
var inst_30379 = (function (){var pred_flakes = inst_30375;
var is_new_QMARK_ = inst_30378;
return (function (p1__30364_SHARP_,p2__30363_SHARP_){
var f = p2__30363_SHARP_;
return cljs.core.assoc_in(p1__30364_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s,cljs.core.cst$kw$new_QMARK_], null),cljs.core.boolean$((function (){var G__30475 = f.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__30475) : is_new_QMARK_.call(null,G__30475));
})()));
});
})();
var inst_30380 = cljs.core.PersistentHashMap.EMPTY;
var inst_30381 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_30379,inst_30380,inst_30375);
var inst_30389 = cljs.core.seq(inst_30375);
var inst_30390 = cljs.core.first(inst_30389);
var inst_30391 = cljs.core.next(inst_30389);
var inst_30392 = inst_30375;
var inst_30393 = inst_30381;
var state_30443__$1 = (function (){var statearr_30476 = state_30443;
(statearr_30476[(8)] = inst_30392);

(statearr_30476[(9)] = inst_30393);

(statearr_30476[(14)] = inst_30390);

(statearr_30476[(15)] = inst_30391);

return statearr_30476;
})();
var statearr_30477_30505 = state_30443__$1;
(statearr_30477_30505[(2)] = null);

(statearr_30477_30505[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__15091__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__15091__auto____0 = (function (){
var statearr_30478 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30478[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__15091__auto__);

(statearr_30478[(1)] = (1));

return statearr_30478;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__15091__auto____1 = (function (state_30443){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_30443);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e30479){var ex__15094__auto__ = e30479;
var statearr_30480_30506 = state_30443;
(statearr_30480_30506[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_30443[(4)]))){
var statearr_30481_30507 = state_30443;
(statearr_30481_30507[(1)] = cljs.core.first((state_30443[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__30508 = state_30443;
state_30443 = G__30508;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__15091__auto__ = function(state_30443){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__15091__auto____1.call(this,state_30443);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__15091__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__15091__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_30482 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_30482[(6)] = c__15165__auto__);

return statearr_30482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__30510 = arguments.length;
switch (G__30510) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_tx], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__30513 = arguments.length;
switch (G__30513) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_30825){
var state_val_30826 = (state_30825[(1)]);
if((state_val_30826 === (121))){
var inst_30780 = (state_30825[(7)]);
var state_30825__$1 = state_30825;
var statearr_30827_31020 = state_30825__$1;
(statearr_30827_31020[(2)] = inst_30780);

(statearr_30827_31020[(1)] = (122));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (65))){
var inst_30679 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
if(cljs.core.truth_(inst_30679)){
var statearr_30828_31021 = state_30825__$1;
(statearr_30828_31021[(1)] = (66));

} else {
var statearr_30829_31022 = state_30825__$1;
(statearr_30829_31022[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (70))){
var inst_30684 = (state_30825[(8)]);
var inst_30685 = (state_30825[(9)]);
var inst_30689 = [cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$string,null,cljs.core.cst$kw$bigdec,null];
var inst_30690 = (inst_30685.cljs$core$IFn$_invoke$arity$5 ? inst_30685.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_30689,null) : inst_30685.call(null,cljs.core.PersistentArrayMap,null,3,inst_30689,null));
var inst_30691 = (inst_30685.cljs$core$IFn$_invoke$arity$4 ? inst_30685.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_30690,null) : inst_30685.call(null,cljs.core.PersistentHashSet,null,inst_30690,null));
var inst_30692 = (inst_30691.cljs$core$IFn$_invoke$arity$1 ? inst_30691.cljs$core$IFn$_invoke$arity$1(inst_30684) : inst_30691.call(null,inst_30684));
var state_30825__$1 = state_30825;
if(cljs.core.truth_(inst_30692)){
var statearr_30830_31023 = state_30825__$1;
(statearr_30830_31023[(1)] = (72));

} else {
var statearr_30831_31024 = state_30825__$1;
(statearr_30831_31024[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (62))){
var inst_30669 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
var statearr_30832_31025 = state_30825__$1;
(statearr_30832_31025[(2)] = inst_30669);

(statearr_30832_31025[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (74))){
var inst_30775 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
var statearr_30833_31026 = state_30825__$1;
(statearr_30833_31026[(2)] = inst_30775);

(statearr_30833_31026[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (110))){
var inst_30802 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
if(cljs.core.truth_(inst_30802)){
var statearr_30834_31027 = state_30825__$1;
(statearr_30834_31027[(1)] = (117));

} else {
var statearr_30835_31028 = state_30825__$1;
(statearr_30835_31028[(1)] = (118));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (7))){
var inst_30820 = (state_30825[(2)]);
var _ = (function (){var statearr_30836 = state_30825;
(statearr_30836[(4)] = cljs.core.rest((state_30825[(4)])));

return statearr_30836;
})();
var state_30825__$1 = state_30825;
var statearr_30837_31029 = state_30825__$1;
(statearr_30837_31029[(2)] = inst_30820);

(statearr_30837_31029[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (59))){
var inst_30553 = (state_30825[(10)]);
var inst_30673 = (state_30825[(11)]);
var inst_30672 = (state_30825[(2)]);
var inst_30673__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_30553);
var state_30825__$1 = (function (){var statearr_30838 = state_30825;
(statearr_30838[(12)] = inst_30672);

(statearr_30838[(11)] = inst_30673__$1);

return statearr_30838;
})();
if(cljs.core.truth_(inst_30673__$1)){
var statearr_30839_31030 = state_30825__$1;
(statearr_30839_31030[(1)] = (63));

} else {
var statearr_30840_31031 = state_30825__$1;
(statearr_30840_31031[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (86))){
var inst_30715 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
var statearr_30841_31032 = state_30825__$1;
(statearr_30841_31032[(2)] = inst_30715);

(statearr_30841_31032[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (20))){
var inst_30553 = (state_30825[(10)]);
var inst_30579 = (state_30825[(13)]);
var inst_30579__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_30553);
var state_30825__$1 = (function (){var statearr_30842 = state_30825;
(statearr_30842[(13)] = inst_30579__$1);

return statearr_30842;
})();
if(cljs.core.truth_(inst_30579__$1)){
var statearr_30843_31033 = state_30825__$1;
(statearr_30843_31033[(1)] = (23));

} else {
var statearr_30844_31034 = state_30825__$1;
(statearr_30844_31034[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (72))){
var inst_30684 = (state_30825[(8)]);
var inst_30685 = (state_30825[(9)]);
var inst_30694 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_30684,inst_30685,throw_QMARK_);
var state_30825__$1 = state_30825;
var statearr_30845_31035 = state_30825__$1;
(statearr_30845_31035[(2)] = inst_30694);

(statearr_30845_31035[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (58))){
var inst_30634 = (state_30825[(14)]);
var state_30825__$1 = state_30825;
var statearr_30846_31036 = state_30825__$1;
(statearr_30846_31036[(2)] = inst_30634);

(statearr_30846_31036[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (60))){
var inst_30552 = (state_30825[(15)]);
var inst_30541 = (state_30825[(16)]);
var inst_30660 = fluree.db.dbproto._p_prop(inst_30541,cljs.core.cst$kw$name,inst_30552);
var inst_30661 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_30660)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_30662 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_30663 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_30664 = cljs.core.PersistentHashMap.fromArrays(inst_30662,inst_30663);
var inst_30665 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_30661,inst_30664);
var inst_30666 = (function(){throw inst_30665})();
var state_30825__$1 = state_30825;
var statearr_30847_31037 = state_30825__$1;
(statearr_30847_31037[(2)] = inst_30666);

(statearr_30847_31037[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (27))){
var inst_30582 = (state_30825[(17)]);
var state_30825__$1 = state_30825;
var statearr_30848_31038 = state_30825__$1;
(statearr_30848_31038[(2)] = inst_30582);

(statearr_30848_31038[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (1))){
var state_30825__$1 = state_30825;
var statearr_30849_31039 = state_30825__$1;
(statearr_30849_31039[(2)] = null);

(statearr_30849_31039[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (69))){
var inst_30672 = (state_30825[(12)]);
var state_30825__$1 = state_30825;
var statearr_30850_31040 = state_30825__$1;
(statearr_30850_31040[(2)] = inst_30672);

(statearr_30850_31040[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (101))){
var inst_30684 = (state_30825[(8)]);
var inst_30685 = (state_30825[(9)]);
var inst_30753 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_30684,inst_30685,throw_QMARK_);
var state_30825__$1 = state_30825;
var statearr_30851_31041 = state_30825__$1;
(statearr_30851_31041[(2)] = inst_30753);

(statearr_30851_31041[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (24))){
var inst_30579 = (state_30825[(13)]);
var state_30825__$1 = state_30825;
var statearr_30852_31042 = state_30825__$1;
(statearr_30852_31042[(2)] = inst_30579);

(statearr_30852_31042[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (102))){
var inst_30755 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
var statearr_30853_31043 = state_30825__$1;
(statearr_30853_31043[(2)] = inst_30755);

(statearr_30853_31043[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (55))){
var inst_30651 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
var statearr_30854_31044 = state_30825__$1;
(statearr_30854_31044[(2)] = inst_30651);

(statearr_30854_31044[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (85))){
var inst_30684 = (state_30825[(8)]);
var inst_30685 = (state_30825[(9)]);
var inst_30713 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_30684,inst_30685,throw_QMARK_);
var state_30825__$1 = state_30825;
var statearr_30855_31045 = state_30825__$1;
(statearr_30855_31045[(2)] = inst_30713);

(statearr_30855_31045[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (39))){
var inst_30616 = (state_30825[(18)]);
var state_30825__$1 = state_30825;
var statearr_30856_31046 = state_30825__$1;
(statearr_30856_31046[(2)] = inst_30616);

(statearr_30856_31046[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (88))){
var inst_30672 = (state_30825[(12)]);
var state_30825__$1 = state_30825;
var statearr_30857_31047 = state_30825__$1;
(statearr_30857_31047[(2)] = inst_30672);

(statearr_30857_31047[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (46))){
var inst_30635 = (state_30825[(19)]);
var inst_30553 = (state_30825[(10)]);
var inst_30634 = (state_30825[(2)]);
var inst_30635__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_30553);
var state_30825__$1 = (function (){var statearr_30858 = state_30825;
(statearr_30858[(19)] = inst_30635__$1);

(statearr_30858[(14)] = inst_30634);

return statearr_30858;
})();
if(cljs.core.truth_(inst_30635__$1)){
var statearr_30859_31048 = state_30825__$1;
(statearr_30859_31048[(1)] = (47));

} else {
var statearr_30860_31049 = state_30825__$1;
(statearr_30860_31049[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (4))){
var inst_30514 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
var statearr_30861_31050 = state_30825__$1;
(statearr_30861_31050[(2)] = inst_30514);

(statearr_30861_31050[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (77))){
var inst_30773 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
var statearr_30862_31051 = state_30825__$1;
(statearr_30862_31051[(2)] = inst_30773);

(statearr_30862_31051[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (106))){
var inst_30765 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
var statearr_30863_31052 = state_30825__$1;
(statearr_30863_31052[(2)] = inst_30765);

(statearr_30863_31052[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (119))){
var inst_30551 = (state_30825[(20)]);
var inst_30815 = (state_30825[(2)]);
var inst_30540 = inst_30551;
var inst_30541 = inst_30815;
var state_30825__$1 = (function (){var statearr_30864 = state_30825;
(statearr_30864[(21)] = inst_30540);

(statearr_30864[(16)] = inst_30541);

return statearr_30864;
})();
var statearr_30865_31053 = state_30825__$1;
(statearr_30865_31053[(2)] = null);

(statearr_30865_31053[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (95))){
var inst_30684 = (state_30825[(8)]);
var inst_30685 = (state_30825[(9)]);
var inst_30737 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$double,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$float,null];
var inst_30738 = (inst_30685.cljs$core$IFn$_invoke$arity$5 ? inst_30685.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_30737,null) : inst_30685.call(null,cljs.core.PersistentArrayMap,null,5,inst_30737,null));
var inst_30739 = (inst_30685.cljs$core$IFn$_invoke$arity$4 ? inst_30685.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_30738,null) : inst_30685.call(null,cljs.core.PersistentHashSet,null,inst_30738,null));
var inst_30740 = (inst_30739.cljs$core$IFn$_invoke$arity$1 ? inst_30739.cljs$core$IFn$_invoke$arity$1(inst_30684) : inst_30739.call(null,inst_30684));
var state_30825__$1 = state_30825;
if(cljs.core.truth_(inst_30740)){
var statearr_30866_31054 = state_30825__$1;
(statearr_30866_31054[(1)] = (96));

} else {
var statearr_30867_31055 = state_30825__$1;
(statearr_30867_31055[(1)] = (97));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (54))){
var inst_30642 = (state_30825[(22)]);
var state_30825__$1 = state_30825;
var statearr_30868_31056 = state_30825__$1;
(statearr_30868_31056[(2)] = inst_30642);

(statearr_30868_31056[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (92))){
var inst_30672 = (state_30825[(12)]);
var state_30825__$1 = state_30825;
var statearr_30869_31057 = state_30825__$1;
(statearr_30869_31057[(2)] = inst_30672);

(statearr_30869_31057[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (104))){
var inst_30672 = (state_30825[(12)]);
var state_30825__$1 = state_30825;
var statearr_30870_31058 = state_30825__$1;
(statearr_30870_31058[(2)] = inst_30672);

(statearr_30870_31058[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (15))){
var inst_30561 = (state_30825[(23)]);
var state_30825__$1 = state_30825;
var statearr_30871_31059 = state_30825__$1;
(statearr_30871_31059[(2)] = inst_30561);

(statearr_30871_31059[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (48))){
var inst_30635 = (state_30825[(19)]);
var state_30825__$1 = state_30825;
var statearr_30872_31060 = state_30825__$1;
(statearr_30872_31060[(2)] = inst_30635);

(statearr_30872_31060[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (50))){
var inst_30642 = (state_30825[(22)]);
var inst_30553 = (state_30825[(10)]);
var inst_30640 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_30553);
var inst_30641 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_30640);
var inst_30642__$1 = inst_30641 === true;
var state_30825__$1 = (function (){var statearr_30873 = state_30825;
(statearr_30873[(22)] = inst_30642__$1);

return statearr_30873;
})();
if(cljs.core.truth_(inst_30642__$1)){
var statearr_30874_31061 = state_30825__$1;
(statearr_30874_31061[(1)] = (53));

} else {
var statearr_30875_31062 = state_30825__$1;
(statearr_30875_31062[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (116))){
var inst_30796 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
var statearr_30876_31063 = state_30825__$1;
(statearr_30876_31063[(2)] = inst_30796);

(statearr_30876_31063[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (75))){
var inst_30685 = (state_30825[(9)]);
var state_30825__$1 = state_30825;
var G__30877_31064 = inst_30685;
var G__30877_31065__$1 = (((G__30877_31064 instanceof cljs.core.Keyword))?G__30877_31064.fqn:null);
switch (G__30877_31065__$1) {
case "long":
var statearr_30878_31067 = state_30825__$1;
(statearr_30878_31067[(1)] = (79));


break;
case "bigint":
var statearr_30879_31068 = state_30825__$1;
(statearr_30879_31068[(1)] = (83));


break;
case "double":
var statearr_30880_31069 = state_30825__$1;
(statearr_30880_31069[(1)] = (87));


break;
case "float":
var statearr_30881_31070 = state_30825__$1;
(statearr_30881_31070[(1)] = (91));


break;
case "bigdec":
var statearr_30882_31071 = state_30825__$1;
(statearr_30882_31071[(1)] = (95));


break;
case "string":
var statearr_30883_31072 = state_30825__$1;
(statearr_30883_31072[(1)] = (99));


break;
case "instant":
var statearr_30884_31073 = state_30825__$1;
(statearr_30884_31073[(1)] = (103));


break;
default:
var statearr_30885_31074 = state_30825__$1;
(statearr_30885_31074[(1)] = (107));



}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (99))){
var inst_30684 = (state_30825[(8)]);
var inst_30685 = (state_30825[(9)]);
var inst_30747 = [cljs.core.cst$kw$geojson,null,cljs.core.cst$kw$bytes,null,cljs.core.cst$kw$uri,null,cljs.core.cst$kw$uuid,null,cljs.core.cst$kw$json,null];
var inst_30748 = (inst_30685.cljs$core$IFn$_invoke$arity$5 ? inst_30685.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_30747,null) : inst_30685.call(null,cljs.core.PersistentArrayMap,null,5,inst_30747,null));
var inst_30749 = (inst_30685.cljs$core$IFn$_invoke$arity$4 ? inst_30685.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_30748,null) : inst_30685.call(null,cljs.core.PersistentHashSet,null,inst_30748,null));
var inst_30750 = (inst_30749.cljs$core$IFn$_invoke$arity$1 ? inst_30749.cljs$core$IFn$_invoke$arity$1(inst_30684) : inst_30749.call(null,inst_30684));
var state_30825__$1 = state_30825;
if(cljs.core.truth_(inst_30750)){
var statearr_30886_31075 = state_30825__$1;
(statearr_30886_31075[(1)] = (100));

} else {
var statearr_30887_31076 = state_30825__$1;
(statearr_30887_31076[(1)] = (101));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (21))){
var inst_30577 = (state_30825[(24)]);
var state_30825__$1 = state_30825;
var statearr_30888_31077 = state_30825__$1;
(statearr_30888_31077[(2)] = inst_30577);

(statearr_30888_31077[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (31))){
var inst_30593 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
var statearr_30889_31078 = state_30825__$1;
(statearr_30889_31078[(2)] = inst_30593);

(statearr_30889_31078[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (113))){
var inst_30799 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
var statearr_30890_31079 = state_30825__$1;
(statearr_30890_31079[(2)] = inst_30799);

(statearr_30890_31079[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (32))){
var state_30825__$1 = state_30825;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_30891_31080 = state_30825__$1;
(statearr_30891_31080[(1)] = (35));

} else {
var statearr_30892_31081 = state_30825__$1;
(statearr_30892_31081[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (40))){
var inst_30629 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
if(cljs.core.truth_(inst_30629)){
var statearr_30893_31082 = state_30825__$1;
(statearr_30893_31082[(1)] = (44));

} else {
var statearr_30894_31083 = state_30825__$1;
(statearr_30894_31083[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (91))){
var inst_30684 = (state_30825[(8)]);
var inst_30685 = (state_30825[(9)]);
var inst_30727 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_30728 = (inst_30685.cljs$core$IFn$_invoke$arity$5 ? inst_30685.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_30727,null) : inst_30685.call(null,cljs.core.PersistentArrayMap,null,3,inst_30727,null));
var inst_30729 = (inst_30685.cljs$core$IFn$_invoke$arity$4 ? inst_30685.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_30728,null) : inst_30685.call(null,cljs.core.PersistentHashSet,null,inst_30728,null));
var inst_30730 = (inst_30729.cljs$core$IFn$_invoke$arity$1 ? inst_30729.cljs$core$IFn$_invoke$arity$1(inst_30684) : inst_30729.call(null,inst_30684));
var state_30825__$1 = state_30825;
if(cljs.core.truth_(inst_30730)){
var statearr_30895_31084 = state_30825__$1;
(statearr_30895_31084[(1)] = (92));

} else {
var statearr_30896_31085 = state_30825__$1;
(statearr_30896_31085[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (117))){
var state_30825__$1 = state_30825;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_30897_31086 = state_30825__$1;
(statearr_30897_31086[(1)] = (120));

} else {
var statearr_30898_31087 = state_30825__$1;
(statearr_30898_31087[(1)] = (121));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (108))){
var inst_30784 = (state_30825[(25)]);
var inst_30553 = (state_30825[(10)]);
var inst_30784__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_30553);
var state_30825__$1 = (function (){var statearr_30899 = state_30825;
(statearr_30899[(25)] = inst_30784__$1);

return statearr_30899;
})();
if(cljs.core.truth_(inst_30784__$1)){
var statearr_30900_31088 = state_30825__$1;
(statearr_30900_31088[(1)] = (111));

} else {
var statearr_30901_31089 = state_30825__$1;
(statearr_30901_31089[(1)] = (112));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (56))){
var inst_30646 = (state_30825[(2)]);
var inst_30647 = fluree.db.util.async.throw_err(inst_30646);
var inst_30648 = cljs.core.not(inst_30647);
var state_30825__$1 = state_30825;
var statearr_30902_31090 = state_30825__$1;
(statearr_30902_31090[(2)] = inst_30648);

(statearr_30902_31090[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (33))){
var inst_30576 = (state_30825[(26)]);
var state_30825__$1 = state_30825;
var statearr_30903_31091 = state_30825__$1;
(statearr_30903_31091[(2)] = inst_30576);

(statearr_30903_31091[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (13))){
var inst_30571 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
if(cljs.core.truth_(inst_30571)){
var statearr_30904_31092 = state_30825__$1;
(statearr_30904_31092[(1)] = (17));

} else {
var statearr_30905_31093 = state_30825__$1;
(statearr_30905_31093[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (22))){
var inst_30602 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
if(cljs.core.truth_(inst_30602)){
var statearr_30906_31094 = state_30825__$1;
(statearr_30906_31094[(1)] = (32));

} else {
var statearr_30907_31095 = state_30825__$1;
(statearr_30907_31095[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (90))){
var inst_30725 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
var statearr_30908_31096 = state_30825__$1;
(statearr_30908_31096[(2)] = inst_30725);

(statearr_30908_31096[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (109))){
var inst_30782 = (state_30825[(27)]);
var state_30825__$1 = state_30825;
var statearr_30909_31097 = state_30825__$1;
(statearr_30909_31097[(2)] = inst_30782);

(statearr_30909_31097[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (36))){
var inst_30576 = (state_30825[(26)]);
var state_30825__$1 = state_30825;
var statearr_30910_31098 = state_30825__$1;
(statearr_30910_31098[(2)] = inst_30576);

(statearr_30910_31098[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (41))){
var inst_30553 = (state_30825[(10)]);
var inst_30621 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_30553);
var inst_30622 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_30621);
var inst_30623 = inst_30622 === true;
var state_30825__$1 = state_30825;
var statearr_30911_31099 = state_30825__$1;
(statearr_30911_31099[(2)] = inst_30623);

(statearr_30911_31099[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (118))){
var inst_30780 = (state_30825[(7)]);
var state_30825__$1 = state_30825;
var statearr_30912_31100 = state_30825__$1;
(statearr_30912_31100[(2)] = inst_30780);

(statearr_30912_31100[(1)] = (119));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (89))){
var inst_30684 = (state_30825[(8)]);
var inst_30685 = (state_30825[(9)]);
var inst_30723 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_30684,inst_30685,throw_QMARK_);
var state_30825__$1 = state_30825;
var statearr_30913_31101 = state_30825__$1;
(statearr_30913_31101[(2)] = inst_30723);

(statearr_30913_31101[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (100))){
var inst_30672 = (state_30825[(12)]);
var state_30825__$1 = state_30825;
var statearr_30914_31102 = state_30825__$1;
(statearr_30914_31102[(2)] = inst_30672);

(statearr_30914_31102[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (122))){
var inst_30812 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
var statearr_30915_31103 = state_30825__$1;
(statearr_30915_31103[(2)] = inst_30812);

(statearr_30915_31103[(1)] = (119));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (43))){
var inst_30626 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
var statearr_30916_31104 = state_30825__$1;
(statearr_30916_31104[(2)] = inst_30626);

(statearr_30916_31104[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (61))){
var inst_30634 = (state_30825[(14)]);
var state_30825__$1 = state_30825;
var statearr_30917_31105 = state_30825__$1;
(statearr_30917_31105[(2)] = inst_30634);

(statearr_30917_31105[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (29))){
var inst_30553 = (state_30825[(10)]);
var inst_30588 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_30553);
var inst_30589 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_30588);
var inst_30590 = inst_30589 === true;
var state_30825__$1 = state_30825;
var statearr_30918_31106 = state_30825__$1;
(statearr_30918_31106[(2)] = inst_30590);

(statearr_30918_31106[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (44))){
var inst_30615 = (state_30825[(28)]);
var inst_30631 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_30615,"a component","a non-component",throw_QMARK_);
var state_30825__$1 = state_30825;
var statearr_30919_31107 = state_30825__$1;
(statearr_30919_31107[(2)] = inst_30631);

(statearr_30919_31107[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (93))){
var inst_30684 = (state_30825[(8)]);
var inst_30685 = (state_30825[(9)]);
var inst_30733 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_30684,inst_30685,throw_QMARK_);
var state_30825__$1 = state_30825;
var statearr_30920_31108 = state_30825__$1;
(statearr_30920_31108[(2)] = inst_30733);

(statearr_30920_31108[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (6))){
var inst_30540 = (state_30825[(21)]);
var inst_30552 = (state_30825[(15)]);
var inst_30549 = cljs.core.seq(inst_30540);
var inst_30550 = cljs.core.first(inst_30549);
var inst_30551 = cljs.core.next(inst_30549);
var inst_30552__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30550,(0),null);
var inst_30553 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30550,(1),null);
var inst_30554 = cljs.core.not(inst_30552__$1);
var state_30825__$1 = (function (){var statearr_30921 = state_30825;
(statearr_30921[(20)] = inst_30551);

(statearr_30921[(10)] = inst_30553);

(statearr_30921[(15)] = inst_30552__$1);

return statearr_30921;
})();
if(inst_30554){
var statearr_30922_31109 = state_30825__$1;
(statearr_30922_31109[(1)] = (8));

} else {
var statearr_30923_31110 = state_30825__$1;
(statearr_30923_31110[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (111))){
var inst_30788 = (state_30825[(29)]);
var inst_30553 = (state_30825[(10)]);
var inst_30786 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_30553);
var inst_30787 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_30786);
var inst_30788__$1 = inst_30787 === true;
var state_30825__$1 = (function (){var statearr_30924 = state_30825;
(statearr_30924[(29)] = inst_30788__$1);

return statearr_30924;
})();
if(cljs.core.truth_(inst_30788__$1)){
var statearr_30925_31111 = state_30825__$1;
(statearr_30925_31111[(1)] = (114));

} else {
var statearr_30926_31112 = state_30825__$1;
(statearr_30926_31112[(1)] = (115));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (28))){
var inst_30596 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
var statearr_30927_31113 = state_30825__$1;
(statearr_30927_31113[(2)] = inst_30596);

(statearr_30927_31113[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (64))){
var inst_30673 = (state_30825[(11)]);
var state_30825__$1 = state_30825;
var statearr_30928_31114 = state_30825__$1;
(statearr_30928_31114[(2)] = inst_30673);

(statearr_30928_31114[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (103))){
var inst_30684 = (state_30825[(8)]);
var inst_30685 = (state_30825[(9)]);
var inst_30757 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null];
var inst_30758 = (inst_30685.cljs$core$IFn$_invoke$arity$5 ? inst_30685.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_30757,null) : inst_30685.call(null,cljs.core.PersistentArrayMap,null,2,inst_30757,null));
var inst_30759 = (inst_30685.cljs$core$IFn$_invoke$arity$4 ? inst_30685.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_30758,null) : inst_30685.call(null,cljs.core.PersistentHashSet,null,inst_30758,null));
var inst_30760 = (inst_30759.cljs$core$IFn$_invoke$arity$1 ? inst_30759.cljs$core$IFn$_invoke$arity$1(inst_30684) : inst_30759.call(null,inst_30684));
var state_30825__$1 = state_30825;
if(cljs.core.truth_(inst_30760)){
var statearr_30929_31115 = state_30825__$1;
(statearr_30929_31115[(1)] = (104));

} else {
var statearr_30930_31116 = state_30825__$1;
(statearr_30930_31116[(1)] = (105));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (51))){
var inst_30638 = (state_30825[(30)]);
var state_30825__$1 = state_30825;
var statearr_30931_31117 = state_30825__$1;
(statearr_30931_31117[(2)] = inst_30638);

(statearr_30931_31117[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (25))){
var inst_30599 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
var statearr_30932_31118 = state_30825__$1;
(statearr_30932_31118[(2)] = inst_30599);

(statearr_30932_31118[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (34))){
var inst_30553 = (state_30825[(10)]);
var inst_30616 = (state_30825[(18)]);
var inst_30615 = (state_30825[(2)]);
var inst_30616__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_30553);
var state_30825__$1 = (function (){var statearr_30933 = state_30825;
(statearr_30933[(28)] = inst_30615);

(statearr_30933[(18)] = inst_30616__$1);

return statearr_30933;
})();
if(cljs.core.truth_(inst_30616__$1)){
var statearr_30934_31119 = state_30825__$1;
(statearr_30934_31119[(1)] = (38));

} else {
var statearr_30935_31120 = state_30825__$1;
(statearr_30935_31120[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (17))){
var inst_30541 = (state_30825[(16)]);
var inst_30573 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_30541,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_30825__$1 = state_30825;
var statearr_30936_31121 = state_30825__$1;
(statearr_30936_31121[(2)] = inst_30573);

(statearr_30936_31121[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (3))){
var inst_30823 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30825__$1,inst_30823);
} else {
if((state_val_30826 === (12))){
var inst_30557 = (state_30825[(31)]);
var state_30825__$1 = state_30825;
var statearr_30937_31122 = state_30825__$1;
(statearr_30937_31122[(2)] = inst_30557);

(statearr_30937_31122[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (2))){
var _ = (function (){var statearr_30938 = state_30825;
(statearr_30938[(4)] = cljs.core.cons((5),(state_30825[(4)])));

return statearr_30938;
})();
var inst_30533 = pred_changes;
var inst_30534 = cljs.core.seq(inst_30533);
var inst_30535 = cljs.core.first(inst_30534);
var inst_30536 = cljs.core.next(inst_30534);
var inst_30537 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30535,(0),null);
var inst_30538 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30535,(1),null);
var inst_30539 = db;
var inst_30540 = inst_30533;
var inst_30541 = inst_30539;
var state_30825__$1 = (function (){var statearr_30939 = state_30825;
(statearr_30939[(32)] = inst_30537);

(statearr_30939[(21)] = inst_30540);

(statearr_30939[(33)] = inst_30536);

(statearr_30939[(34)] = inst_30538);

(statearr_30939[(16)] = inst_30541);

return statearr_30939;
})();
var statearr_30940_31123 = state_30825__$1;
(statearr_30940_31123[(2)] = null);

(statearr_30940_31123[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (66))){
var inst_30684 = (state_30825[(8)]);
var inst_30685 = (state_30825[(9)]);
var inst_30553 = (state_30825[(10)]);
var inst_30682 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_30553);
var inst_30683 = cljs.core.__destructure_map(inst_30682);
var inst_30684__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30683,cljs.core.cst$kw$old);
var inst_30685__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30683,cljs.core.cst$kw$new);
var inst_30686 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30685__$1,inst_30684__$1);
var state_30825__$1 = (function (){var statearr_30941 = state_30825;
(statearr_30941[(8)] = inst_30684__$1);

(statearr_30941[(9)] = inst_30685__$1);

return statearr_30941;
})();
if(inst_30686){
var statearr_30942_31124 = state_30825__$1;
(statearr_30942_31124[(1)] = (69));

} else {
var statearr_30943_31125 = state_30825__$1;
(statearr_30943_31125[(1)] = (70));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (107))){
var inst_30684 = (state_30825[(8)]);
var inst_30685 = (state_30825[(9)]);
var inst_30767 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_30684,inst_30685,throw_QMARK_);
var state_30825__$1 = state_30825;
var statearr_30944_31126 = state_30825__$1;
(statearr_30944_31126[(2)] = inst_30767);

(statearr_30944_31126[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (23))){
var inst_30582 = (state_30825[(17)]);
var inst_30553 = (state_30825[(10)]);
var inst_30581 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_30553);
var inst_30582__$1 = inst_30581 === true;
var state_30825__$1 = (function (){var statearr_30945 = state_30825;
(statearr_30945[(17)] = inst_30582__$1);

return statearr_30945;
})();
if(cljs.core.truth_(inst_30582__$1)){
var statearr_30946_31127 = state_30825__$1;
(statearr_30946_31127[(1)] = (26));

} else {
var statearr_30947_31128 = state_30825__$1;
(statearr_30947_31128[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (47))){
var inst_30553 = (state_30825[(10)]);
var inst_30638 = (state_30825[(30)]);
var inst_30637 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_30553);
var inst_30638__$1 = cljs.core.not(inst_30637);
var state_30825__$1 = (function (){var statearr_30948 = state_30825;
(statearr_30948[(30)] = inst_30638__$1);

return statearr_30948;
})();
if(inst_30638__$1){
var statearr_30949_31129 = state_30825__$1;
(statearr_30949_31129[(1)] = (50));

} else {
var statearr_30950_31130 = state_30825__$1;
(statearr_30950_31130[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (35))){
var inst_30605 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_30606 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_30607 = cljs.core.PersistentHashMap.fromArrays(inst_30605,inst_30606);
var inst_30608 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_30607);
var inst_30609 = (function(){throw inst_30608})();
var state_30825__$1 = state_30825;
var statearr_30951_31131 = state_30825__$1;
(statearr_30951_31131[(2)] = inst_30609);

(statearr_30951_31131[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (82))){
var inst_30705 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
var statearr_30952_31132 = state_30825__$1;
(statearr_30952_31132[(2)] = inst_30705);

(statearr_30952_31132[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (76))){
var state_30825__$1 = state_30825;
var statearr_30953_31133 = state_30825__$1;
(statearr_30953_31133[(2)] = null);

(statearr_30953_31133[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (97))){
var inst_30684 = (state_30825[(8)]);
var inst_30685 = (state_30825[(9)]);
var inst_30743 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_30684,inst_30685,throw_QMARK_);
var state_30825__$1 = state_30825;
var statearr_30954_31134 = state_30825__$1;
(statearr_30954_31134[(2)] = inst_30743);

(statearr_30954_31134[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (19))){
var inst_30577 = (state_30825[(24)]);
var inst_30553 = (state_30825[(10)]);
var inst_30576 = (state_30825[(2)]);
var inst_30577__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_30553);
var state_30825__$1 = (function (){var statearr_30955 = state_30825;
(statearr_30955[(24)] = inst_30577__$1);

(statearr_30955[(26)] = inst_30576);

return statearr_30955;
})();
if(cljs.core.truth_(inst_30577__$1)){
var statearr_30956_31135 = state_30825__$1;
(statearr_30956_31135[(1)] = (20));

} else {
var statearr_30957_31136 = state_30825__$1;
(statearr_30957_31136[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (57))){
var state_30825__$1 = state_30825;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_30958_31137 = state_30825__$1;
(statearr_30958_31137[(1)] = (60));

} else {
var statearr_30959_31138 = state_30825__$1;
(statearr_30959_31138[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (68))){
var inst_30782 = (state_30825[(27)]);
var inst_30553 = (state_30825[(10)]);
var inst_30780 = (state_30825[(2)]);
var inst_30781 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_30553);
var inst_30782__$1 = inst_30781 === true;
var state_30825__$1 = (function (){var statearr_30960 = state_30825;
(statearr_30960[(27)] = inst_30782__$1);

(statearr_30960[(7)] = inst_30780);

return statearr_30960;
})();
if(cljs.core.truth_(inst_30782__$1)){
var statearr_30961_31139 = state_30825__$1;
(statearr_30961_31139[(1)] = (108));

} else {
var statearr_30962_31140 = state_30825__$1;
(statearr_30962_31140[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (11))){
var inst_30553 = (state_30825[(10)]);
var inst_30561 = (state_30825[(23)]);
var inst_30559 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_30553);
var inst_30560 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_30559);
var inst_30561__$1 = inst_30560 === false;
var state_30825__$1 = (function (){var statearr_30963 = state_30825;
(statearr_30963[(23)] = inst_30561__$1);

return statearr_30963;
})();
if(cljs.core.truth_(inst_30561__$1)){
var statearr_30964_31141 = state_30825__$1;
(statearr_30964_31141[(1)] = (14));

} else {
var statearr_30965_31142 = state_30825__$1;
(statearr_30965_31142[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (115))){
var inst_30788 = (state_30825[(29)]);
var state_30825__$1 = state_30825;
var statearr_30967_31143 = state_30825__$1;
(statearr_30967_31143[(2)] = inst_30788);

(statearr_30967_31143[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (9))){
var inst_30557 = (state_30825[(31)]);
var inst_30553 = (state_30825[(10)]);
var inst_30557__$1 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_30553);
var state_30825__$1 = (function (){var statearr_30968 = state_30825;
(statearr_30968[(31)] = inst_30557__$1);

return statearr_30968;
})();
if(cljs.core.truth_(inst_30557__$1)){
var statearr_30969_31144 = state_30825__$1;
(statearr_30969_31144[(1)] = (11));

} else {
var statearr_30970_31145 = state_30825__$1;
(statearr_30970_31145[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (5))){
var _ = (function (){var statearr_30971 = state_30825;
(statearr_30971[(4)] = cljs.core.rest((state_30825[(4)])));

return statearr_30971;
})();
var state_30825__$1 = state_30825;
var ex30966 = (state_30825__$1[(2)]);
var statearr_30972_31146 = state_30825__$1;
(statearr_30972_31146[(5)] = ex30966);


if((ex30966 instanceof Error)){
var statearr_30973_31147 = state_30825__$1;
(statearr_30973_31147[(1)] = (4));

(statearr_30973_31147[(5)] = null);

} else {
throw ex30966;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (112))){
var inst_30784 = (state_30825[(25)]);
var state_30825__$1 = state_30825;
var statearr_30974_31148 = state_30825__$1;
(statearr_30974_31148[(2)] = inst_30784);

(statearr_30974_31148[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (83))){
var inst_30684 = (state_30825[(8)]);
var inst_30685 = (state_30825[(9)]);
var inst_30707 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_30708 = (inst_30685.cljs$core$IFn$_invoke$arity$5 ? inst_30685.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_30707,null) : inst_30685.call(null,cljs.core.PersistentArrayMap,null,3,inst_30707,null));
var inst_30709 = (inst_30685.cljs$core$IFn$_invoke$arity$4 ? inst_30685.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_30708,null) : inst_30685.call(null,cljs.core.PersistentHashSet,null,inst_30708,null));
var inst_30710 = (inst_30709.cljs$core$IFn$_invoke$arity$1 ? inst_30709.cljs$core$IFn$_invoke$arity$1(inst_30684) : inst_30709.call(null,inst_30684));
var state_30825__$1 = state_30825;
if(cljs.core.truth_(inst_30710)){
var statearr_30975_31149 = state_30825__$1;
(statearr_30975_31149[(1)] = (84));

} else {
var statearr_30976_31150 = state_30825__$1;
(statearr_30976_31150[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (14))){
var inst_30553 = (state_30825[(10)]);
var inst_30563 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_30553);
var inst_30564 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_30563);
var inst_30565 = inst_30564 === true;
var state_30825__$1 = state_30825;
var statearr_30977_31151 = state_30825__$1;
(statearr_30977_31151[(2)] = inst_30565);

(statearr_30977_31151[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (45))){
var inst_30615 = (state_30825[(28)]);
var state_30825__$1 = state_30825;
var statearr_30978_31152 = state_30825__$1;
(statearr_30978_31152[(2)] = inst_30615);

(statearr_30978_31152[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (53))){
var inst_30552 = (state_30825[(15)]);
var inst_30541 = (state_30825[(16)]);
var inst_30644 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_30541,inst_30552);
var state_30825__$1 = state_30825;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30825__$1,(56),inst_30644);
} else {
if((state_val_30826 === (78))){
var inst_30770 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
var statearr_30979_31153 = state_30825__$1;
(statearr_30979_31153[(2)] = inst_30770);

(statearr_30979_31153[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (26))){
var inst_30586 = (state_30825[(35)]);
var inst_30553 = (state_30825[(10)]);
var inst_30584 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_30553);
var inst_30585 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_30584);
var inst_30586__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$boolean,inst_30585);
var state_30825__$1 = (function (){var statearr_30980 = state_30825;
(statearr_30980[(35)] = inst_30586__$1);

return statearr_30980;
})();
if(inst_30586__$1){
var statearr_30981_31154 = state_30825__$1;
(statearr_30981_31154[(1)] = (29));

} else {
var statearr_30982_31155 = state_30825__$1;
(statearr_30982_31155[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (16))){
var inst_30568 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
var statearr_30983_31156 = state_30825__$1;
(statearr_30983_31156[(2)] = inst_30568);

(statearr_30983_31156[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (81))){
var inst_30684 = (state_30825[(8)]);
var inst_30685 = (state_30825[(9)]);
var inst_30703 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_30684,inst_30685,throw_QMARK_);
var state_30825__$1 = state_30825;
var statearr_30984_31157 = state_30825__$1;
(statearr_30984_31157[(2)] = inst_30703);

(statearr_30984_31157[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (120))){
var inst_30805 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_30806 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_30807 = cljs.core.PersistentHashMap.fromArrays(inst_30805,inst_30806);
var inst_30808 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_30807);
var inst_30809 = (function(){throw inst_30808})();
var state_30825__$1 = state_30825;
var statearr_30985_31158 = state_30825__$1;
(statearr_30985_31158[(2)] = inst_30809);

(statearr_30985_31158[(1)] = (122));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (79))){
var inst_30684 = (state_30825[(8)]);
var inst_30685 = (state_30825[(9)]);
var inst_30697 = [cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_30698 = (inst_30685.cljs$core$IFn$_invoke$arity$5 ? inst_30685.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_30697,null) : inst_30685.call(null,cljs.core.PersistentArrayMap,null,2,inst_30697,null));
var inst_30699 = (inst_30685.cljs$core$IFn$_invoke$arity$4 ? inst_30685.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_30698,null) : inst_30685.call(null,cljs.core.PersistentHashSet,null,inst_30698,null));
var inst_30700 = (inst_30699.cljs$core$IFn$_invoke$arity$1 ? inst_30699.cljs$core$IFn$_invoke$arity$1(inst_30684) : inst_30699.call(null,inst_30684));
var state_30825__$1 = state_30825;
if(cljs.core.truth_(inst_30700)){
var statearr_30986_31159 = state_30825__$1;
(statearr_30986_31159[(1)] = (80));

} else {
var statearr_30987_31160 = state_30825__$1;
(statearr_30987_31160[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (38))){
var inst_30619 = (state_30825[(36)]);
var inst_30553 = (state_30825[(10)]);
var inst_30618 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_30553);
var inst_30619__$1 = cljs.core.not(inst_30618);
var state_30825__$1 = (function (){var statearr_30988 = state_30825;
(statearr_30988[(36)] = inst_30619__$1);

return statearr_30988;
})();
if(inst_30619__$1){
var statearr_30989_31161 = state_30825__$1;
(statearr_30989_31161[(1)] = (41));

} else {
var statearr_30990_31162 = state_30825__$1;
(statearr_30990_31162[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (98))){
var inst_30745 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
var statearr_30991_31163 = state_30825__$1;
(statearr_30991_31163[(2)] = inst_30745);

(statearr_30991_31163[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (87))){
var inst_30684 = (state_30825[(8)]);
var inst_30685 = (state_30825[(9)]);
var inst_30717 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_30718 = (inst_30685.cljs$core$IFn$_invoke$arity$5 ? inst_30685.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_30717,null) : inst_30685.call(null,cljs.core.PersistentArrayMap,null,3,inst_30717,null));
var inst_30719 = (inst_30685.cljs$core$IFn$_invoke$arity$4 ? inst_30685.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_30718,null) : inst_30685.call(null,cljs.core.PersistentHashSet,null,inst_30718,null));
var inst_30720 = (inst_30719.cljs$core$IFn$_invoke$arity$1 ? inst_30719.cljs$core$IFn$_invoke$arity$1(inst_30684) : inst_30719.call(null,inst_30684));
var state_30825__$1 = state_30825;
if(cljs.core.truth_(inst_30720)){
var statearr_30992_31164 = state_30825__$1;
(statearr_30992_31164[(1)] = (88));

} else {
var statearr_30993_31165 = state_30825__$1;
(statearr_30993_31165[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (30))){
var inst_30586 = (state_30825[(35)]);
var state_30825__$1 = state_30825;
var statearr_30994_31166 = state_30825__$1;
(statearr_30994_31166[(2)] = inst_30586);

(statearr_30994_31166[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (73))){
var state_30825__$1 = state_30825;
var statearr_30995_31167 = state_30825__$1;
(statearr_30995_31167[(1)] = (75));



return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (96))){
var inst_30672 = (state_30825[(12)]);
var state_30825__$1 = state_30825;
var statearr_30997_31168 = state_30825__$1;
(statearr_30997_31168[(2)] = inst_30672);

(statearr_30997_31168[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (10))){
var inst_30818 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
var statearr_30998_31169 = state_30825__$1;
(statearr_30998_31169[(2)] = inst_30818);

(statearr_30998_31169[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (18))){
var inst_30541 = (state_30825[(16)]);
var state_30825__$1 = state_30825;
var statearr_30999_31170 = state_30825__$1;
(statearr_30999_31170[(2)] = inst_30541);

(statearr_30999_31170[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (105))){
var inst_30684 = (state_30825[(8)]);
var inst_30685 = (state_30825[(9)]);
var inst_30763 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_30684,inst_30685,throw_QMARK_);
var state_30825__$1 = state_30825;
var statearr_31000_31171 = state_30825__$1;
(statearr_31000_31171[(2)] = inst_30763);

(statearr_31000_31171[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (52))){
var inst_30654 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
var statearr_31001_31172 = state_30825__$1;
(statearr_31001_31172[(2)] = inst_30654);

(statearr_31001_31172[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (114))){
var inst_30553 = (state_30825[(10)]);
var inst_30790 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_30553);
var inst_30791 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_30790);
var inst_30792 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ref,inst_30791);
var inst_30793 = (!(inst_30792));
var state_30825__$1 = state_30825;
var statearr_31002_31173 = state_30825__$1;
(statearr_31002_31173[(2)] = inst_30793);

(statearr_31002_31173[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (67))){
var inst_30672 = (state_30825[(12)]);
var state_30825__$1 = state_30825;
var statearr_31003_31174 = state_30825__$1;
(statearr_31003_31174[(2)] = inst_30672);

(statearr_31003_31174[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (71))){
var inst_30777 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
var statearr_31004_31175 = state_30825__$1;
(statearr_31004_31175[(2)] = inst_30777);

(statearr_31004_31175[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (42))){
var inst_30619 = (state_30825[(36)]);
var state_30825__$1 = state_30825;
var statearr_31005_31176 = state_30825__$1;
(statearr_31005_31176[(2)] = inst_30619);

(statearr_31005_31176[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (80))){
var inst_30672 = (state_30825[(12)]);
var state_30825__$1 = state_30825;
var statearr_31006_31177 = state_30825__$1;
(statearr_31006_31177[(2)] = inst_30672);

(statearr_31006_31177[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (37))){
var inst_30612 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
var statearr_31007_31178 = state_30825__$1;
(statearr_31007_31178[(2)] = inst_30612);

(statearr_31007_31178[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (63))){
var inst_30553 = (state_30825[(10)]);
var inst_30675 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_30553);
var inst_30676 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_30675);
var state_30825__$1 = state_30825;
var statearr_31008_31179 = state_30825__$1;
(statearr_31008_31179[(2)] = inst_30676);

(statearr_31008_31179[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (94))){
var inst_30735 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
var statearr_31009_31180 = state_30825__$1;
(statearr_31009_31180[(2)] = inst_30735);

(statearr_31009_31180[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (8))){
var inst_30541 = (state_30825[(16)]);
var state_30825__$1 = state_30825;
var statearr_31010_31181 = state_30825__$1;
(statearr_31010_31181[(2)] = inst_30541);

(statearr_31010_31181[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (49))){
var inst_30657 = (state_30825[(2)]);
var state_30825__$1 = state_30825;
if(cljs.core.truth_(inst_30657)){
var statearr_31011_31182 = state_30825__$1;
(statearr_31011_31182[(1)] = (57));

} else {
var statearr_31012_31183 = state_30825__$1;
(statearr_31012_31183[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30826 === (84))){
var inst_30672 = (state_30825[(12)]);
var state_30825__$1 = state_30825;
var statearr_31013_31184 = state_30825__$1;
(statearr_31013_31184[(2)] = inst_30672);

(statearr_31013_31184[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__15091__auto__ = null;
var fluree$db$query$schema$state_machine__15091__auto____0 = (function (){
var statearr_31014 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31014[(0)] = fluree$db$query$schema$state_machine__15091__auto__);

(statearr_31014[(1)] = (1));

return statearr_31014;
});
var fluree$db$query$schema$state_machine__15091__auto____1 = (function (state_30825){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_30825);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e31015){var ex__15094__auto__ = e31015;
var statearr_31016_31185 = state_30825;
(statearr_31016_31185[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_30825[(4)]))){
var statearr_31017_31186 = state_30825;
(statearr_31017_31186[(1)] = cljs.core.first((state_30825[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__31187 = state_30825;
state_30825 = G__31187;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__15091__auto__ = function(state_30825){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__15091__auto____1.call(this,state_30825);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__15091__auto____0;
fluree$db$query$schema$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__15091__auto____1;
return fluree$db$query$schema$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_31018 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_31018[(6)] = c__15165__auto__);

return statearr_31018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__31189 = arguments.length;
switch (G__31189) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4(db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_31213){
var state_val_31214 = (state_31213[(1)]);
if((state_val_31214 === (7))){
var state_31213__$1 = state_31213;
var statearr_31215_31235 = state_31213__$1;
(statearr_31215_31235[(2)] = db);

(statearr_31215_31235[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31214 === (1))){
var state_31213__$1 = state_31213;
var statearr_31216_31236 = state_31213__$1;
(statearr_31216_31236[(2)] = null);

(statearr_31216_31236[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31214 === (4))){
var inst_31190 = (state_31213[(2)]);
var state_31213__$1 = state_31213;
var statearr_31217_31237 = state_31213__$1;
(statearr_31217_31237[(2)] = inst_31190);

(statearr_31217_31237[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31214 === (6))){
var inst_31199 = (state_31213[(7)]);
var inst_31198 = (state_31213[(2)]);
var inst_31199__$1 = fluree.db.util.async.throw_err(inst_31198);
var inst_31200 = cljs.core.empty_QMARK_(inst_31199__$1);
var state_31213__$1 = (function (){var statearr_31218 = state_31213;
(statearr_31218[(7)] = inst_31199__$1);

return statearr_31218;
})();
if(inst_31200){
var statearr_31219_31238 = state_31213__$1;
(statearr_31219_31238[(1)] = (7));

} else {
var statearr_31220_31239 = state_31213__$1;
(statearr_31220_31239[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31214 === (3))){
var inst_31211 = (state_31213[(2)]);
var state_31213__$1 = state_31213;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31213__$1,inst_31211);
} else {
if((state_val_31214 === (2))){
var _ = (function (){var statearr_31222 = state_31213;
(statearr_31222[(4)] = cljs.core.cons((5),(state_31213[(4)])));

return statearr_31222;
})();
var inst_31196 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes,filter_QMARK_);
var state_31213__$1 = state_31213;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31213__$1,(6),inst_31196);
} else {
if((state_val_31214 === (9))){
var inst_31208 = (state_31213[(2)]);
var _ = (function (){var statearr_31223 = state_31213;
(statearr_31223[(4)] = cljs.core.rest((state_31213[(4)])));

return statearr_31223;
})();
var state_31213__$1 = state_31213;
var statearr_31224_31240 = state_31213__$1;
(statearr_31224_31240[(2)] = inst_31208);

(statearr_31224_31240[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31214 === (5))){
var _ = (function (){var statearr_31225 = state_31213;
(statearr_31225[(4)] = cljs.core.rest((state_31213[(4)])));

return statearr_31225;
})();
var state_31213__$1 = state_31213;
var ex31221 = (state_31213__$1[(2)]);
var statearr_31226_31241 = state_31213__$1;
(statearr_31226_31241[(5)] = ex31221);


if((ex31221 instanceof Error)){
var statearr_31227_31242 = state_31213__$1;
(statearr_31227_31242[(1)] = (4));

(statearr_31227_31242[(5)] = null);

} else {
throw ex31221;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31214 === (10))){
var inst_31205 = (state_31213[(2)]);
var inst_31206 = fluree.db.util.async.throw_err(inst_31205);
var state_31213__$1 = state_31213;
var statearr_31228_31243 = state_31213__$1;
(statearr_31228_31243[(2)] = inst_31206);

(statearr_31228_31243[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31214 === (8))){
var inst_31199 = (state_31213[(7)]);
var inst_31203 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_31199,db,true);
var state_31213__$1 = state_31213;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31213__$1,(10),inst_31203);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__15091__auto__ = null;
var fluree$db$query$schema$state_machine__15091__auto____0 = (function (){
var statearr_31229 = [null,null,null,null,null,null,null,null];
(statearr_31229[(0)] = fluree$db$query$schema$state_machine__15091__auto__);

(statearr_31229[(1)] = (1));

return statearr_31229;
});
var fluree$db$query$schema$state_machine__15091__auto____1 = (function (state_31213){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_31213);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e31230){var ex__15094__auto__ = e31230;
var statearr_31231_31244 = state_31213;
(statearr_31231_31244[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_31213[(4)]))){
var statearr_31232_31245 = state_31213;
(statearr_31232_31245[(1)] = cljs.core.first((state_31213[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__31246 = state_31213;
state_31213 = G__31246;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__15091__auto__ = function(state_31213){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__15091__auto____1.call(this,state_31213);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__15091__auto____0;
fluree$db$query$schema$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__15091__auto____1;
return fluree$db$query$schema$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_31233 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_31233[(6)] = c__15165__auto__);

return statearr_31233;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__31248 = arguments.length;
switch (G__31248) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__31250 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31250,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31250,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31250,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[cljs.core.cst$kw$ref,cljs.core.cst$kw$int,cljs.core.cst$kw$bigdec,cljs.core.cst$kw$json,cljs.core.cst$kw$bytes,cljs.core.cst$kw$boolean,cljs.core.cst$kw$instant,cljs.core.cst$kw$tag,cljs.core.cst$kw$geojson,cljs.core.cst$kw$bigint,cljs.core.cst$kw$float,cljs.core.cst$kw$string,cljs.core.cst$kw$long,cljs.core.cst$kw$uuid,cljs.core.cst$kw$uri,cljs.core.cst$kw$double]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[cljs.core.cst$kw$bn,cljs.core.cst$kw$hi,cljs.core.cst$kw$fr,cljs.core.cst$kw$id,cljs.core.cst$kw$br,cljs.core.cst$kw$ru,cljs.core.cst$kw$en,cljs.core.cst$kw$es,cljs.core.cst$kw$cn,cljs.core.cst$kw$ar]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__5043__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__5043__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__31253_SHARP_,p2__31254_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31253_SHARP_,p2__31254_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__31255_SHARP_){
var f = p1__31255_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(spec_pid,f.p)){
return f.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_31321){
var state_val_31322 = (state_31321[(1)]);
if((state_val_31322 === (1))){
var state_31321__$1 = state_31321;
var statearr_31323_31341 = state_31321__$1;
(statearr_31323_31341[(2)] = null);

(statearr_31323_31341[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31322 === (2))){
var _ = (function (){var statearr_31324 = state_31321;
(statearr_31324[(4)] = cljs.core.cons((5),(state_31321[(4)])));

return statearr_31324;
})();
var inst_31273 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31274 = fluree.db.flake.max_subject_id((1));
var inst_31275 = [inst_31274];
var inst_31276 = (new cljs.core.PersistentVector(null,1,(5),inst_31273,inst_31275,null));
var inst_31277 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31278 = [(0)];
var inst_31279 = (new cljs.core.PersistentVector(null,1,(5),inst_31277,inst_31278,null));
var inst_31280 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_31276,cljs.core._LT__EQ_,inst_31279);
var state_31321__$1 = state_31321;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31321__$1,(6),inst_31280);
} else {
if((state_val_31322 === (3))){
var inst_31319 = (state_31321[(2)]);
var state_31321__$1 = state_31321;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31321__$1,inst_31319);
} else {
if((state_val_31322 === (4))){
var inst_31261 = (state_31321[(2)]);
var state_31321__$1 = state_31321;
var statearr_31326_31342 = state_31321__$1;
(statearr_31326_31342[(2)] = inst_31261);

(statearr_31326_31342[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31322 === (5))){
var _ = (function (){var statearr_31327 = state_31321;
(statearr_31327[(4)] = cljs.core.rest((state_31321[(4)])));

return statearr_31327;
})();
var state_31321__$1 = state_31321;
var ex31325 = (state_31321__$1[(2)]);
var statearr_31328_31343 = state_31321__$1;
(statearr_31328_31343[(5)] = ex31325);


if((ex31325 instanceof Error)){
var statearr_31329_31344 = state_31321__$1;
(statearr_31329_31344[(1)] = (4));

(statearr_31329_31344[(5)] = null);

} else {
throw ex31325;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31322 === (6))){
var inst_31282 = (state_31321[(2)]);
var inst_31283 = fluree.db.util.async.throw_err(inst_31282);
var inst_31284 = (function (){var schema_flakes = inst_31283;
return (function (p1__31256_SHARP_){
return (p1__31256_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_31285 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_31284,inst_31283);
var inst_31286 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31285,(0),null);
var inst_31287 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31285,(1),null);
var inst_31288 = (function (){var schema_flakes = inst_31283;
var vec__31267 = inst_31285;
var collection_flakes = inst_31286;
var predicate_flakes = inst_31287;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first(coll_flakes);
var sid = first_flake.s;
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__31259_SHARP_,p2__31258_SHARP_){
var f = p2__31258_SHARP_;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__31259_SHARP_,f.p,f.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(47));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.sid__GT_i(sid);
}
})();
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids((43),coll_flakes):null);
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$name,c_name,cljs.core.cst$kw$sid,sid,cljs.core.cst$kw$spec,specs,cljs.core.cst$kw$specDoc,specDoc,cljs.core.cst$kw$id,partition,cljs.core.cst$kw$partition,partition], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,partition,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_31289 = [(-1),"_tx"];
var inst_31290 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid,cljs.core.cst$kw$partition,cljs.core.cst$kw$spec,cljs.core.cst$kw$specDoc];
var inst_31291 = ["_tx",(-1),(-1),(-1),null,null];
var inst_31292 = cljs.core.PersistentHashMap.fromArrays(inst_31290,inst_31291);
var inst_31293 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid,cljs.core.cst$kw$partition,cljs.core.cst$kw$spec,cljs.core.cst$kw$specDoc];
var inst_31294 = ["_tx",(-1),(-1),(-1),null,null];
var inst_31295 = cljs.core.PersistentHashMap.fromArrays(inst_31293,inst_31294);
var inst_31296 = [inst_31292,inst_31295];
var inst_31297 = cljs.core.PersistentHashMap.fromArrays(inst_31289,inst_31296);
var inst_31298 = (function (){var schema_flakes = inst_31283;
var vec__31267 = inst_31285;
var collection_flakes = inst_31286;
var predicate_flakes = inst_31287;
return (function (p1__31257_SHARP_){
return p1__31257_SHARP_.s;
});
})();
var inst_31299 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_31298,inst_31286);
var inst_31300 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_31288,inst_31297,inst_31299);
var inst_31302 = (function (){var schema_flakes = inst_31283;
var vec__31267 = inst_31285;
var collection_flakes = inst_31286;
var predicate_flakes = inst_31287;
var coll = inst_31300;
return (function (p__31301,pred_flakes){
var vec__31330 = p__31301;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31330,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31330,(1),null);
var first_flake = cljs.core.first(pred_flakes);
var id = first_flake.s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__31333 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$ref,null,cljs.core.cst$kw$tag,null], null), null);
return (fexpr__31333.cljs$core$IFn$_invoke$arity$1 ? fexpr__31333.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__31333.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__5045__auto__ = ref_QMARK_;
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$unique,cljs.core.cst$kw$restrictCollection,cljs.core.cst$kw$index,cljs.core.cst$kw$name,cljs.core.cst$kw$noHistory,cljs.core.cst$kw$type,cljs.core.cst$kw$txSpec,cljs.core.cst$kw$component,cljs.core.cst$kw$txSpecDoc,cljs.core.cst$kw$spec,cljs.core.cst$kw$multi,cljs.core.cst$kw$id,cljs.core.cst$kw$specDoc,cljs.core.cst$kw$idx_QMARK_,cljs.core.cst$kw$ref_QMARK_,cljs.core.cst$kw$upsert,cljs.core.cst$kw$retractDuplicates,cljs.core.cst$kw$restrictTag,cljs.core.cst$kw$fullText],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids((24),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids((20),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(29))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_31303 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31304 = cljs.core.PersistentHashMap.EMPTY;
var inst_31305 = cljs.core.PersistentHashSet.EMPTY;
var inst_31306 = [inst_31304,inst_31305];
var inst_31307 = (new cljs.core.PersistentVector(null,2,(5),inst_31303,inst_31306,null));
var inst_31308 = (function (){var schema_flakes = inst_31283;
var vec__31267 = inst_31285;
var collection_flakes = inst_31286;
var predicate_flakes = inst_31287;
var coll = inst_31300;
return (function (p1__31260_SHARP_){
return p1__31260_SHARP_.s;
});
})();
var inst_31309 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_31308,inst_31287);
var inst_31310 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_31302,inst_31307,inst_31309);
var inst_31311 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31310,(0),null);
var inst_31312 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31310,(1),null);
var inst_31313 = [cljs.core.cst$kw$t,cljs.core.cst$kw$coll,cljs.core.cst$kw$pred,cljs.core.cst$kw$fullText];
var inst_31314 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_31315 = [inst_31314,inst_31300,inst_31311,inst_31312];
var inst_31316 = cljs.core.PersistentHashMap.fromArrays(inst_31313,inst_31315);
var _ = (function (){var statearr_31334 = state_31321;
(statearr_31334[(4)] = cljs.core.rest((state_31321[(4)])));

return statearr_31334;
})();
var state_31321__$1 = state_31321;
var statearr_31335_31345 = state_31321__$1;
(statearr_31335_31345[(2)] = inst_31316);

(statearr_31335_31345[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__15091__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__15091__auto____0 = (function (){
var statearr_31336 = [null,null,null,null,null,null,null];
(statearr_31336[(0)] = fluree$db$query$schema$schema_map_$_state_machine__15091__auto__);

(statearr_31336[(1)] = (1));

return statearr_31336;
});
var fluree$db$query$schema$schema_map_$_state_machine__15091__auto____1 = (function (state_31321){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_31321);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e31337){var ex__15094__auto__ = e31337;
var statearr_31338_31346 = state_31321;
(statearr_31338_31346[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_31321[(4)]))){
var statearr_31339_31347 = state_31321;
(statearr_31339_31347[(1)] = cljs.core.first((state_31321[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__31348 = state_31321;
state_31321 = G__31348;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__15091__auto__ = function(state_31321){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__15091__auto____1.call(this,state_31321);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__15091__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__15091__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_31340 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_31340[(6)] = c__15165__auto__);

return statearr_31340;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_31390){
var state_val_31391 = (state_31390[(1)]);
if((state_val_31391 === (7))){
var inst_31373 = (state_31390[(2)]);
var inst_31374 = fluree.db.query.schema.flake__GT_pred_map(inst_31373);
var inst_31375 = [cljs.core.cst$kw$passwords,cljs.core.cst$kw$anonymous,cljs.core.cst$kw$language,cljs.core.cst$kw$ledgers,cljs.core.cst$kw$txMax,cljs.core.cst$kw$consensus];
var inst_31376 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31374,(114));
var inst_31377 = cljs.core.boolean$(inst_31376);
var inst_31378 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31374,(110));
var inst_31379 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31374,(117));
var inst_31380 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_31379);
var inst_31381 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31374,(111));
var inst_31382 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31374,(115));
var inst_31383 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31374,(112));
var inst_31384 = [inst_31377,inst_31378,inst_31380,inst_31381,inst_31382,inst_31383];
var inst_31385 = cljs.core.PersistentHashMap.fromArrays(inst_31375,inst_31384);
var _ = (function (){var statearr_31392 = state_31390;
(statearr_31392[(4)] = cljs.core.rest((state_31390[(4)])));

return statearr_31392;
})();
var state_31390__$1 = state_31390;
var statearr_31393_31416 = state_31390__$1;
(statearr_31393_31416[(2)] = inst_31385);

(statearr_31393_31416[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31391 === (1))){
var state_31390__$1 = state_31390;
var statearr_31394_31417 = state_31390__$1;
(statearr_31394_31417[(2)] = null);

(statearr_31394_31417[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31391 === (4))){
var inst_31349 = (state_31390[(2)]);
var state_31390__$1 = state_31390;
var statearr_31395_31418 = state_31390__$1;
(statearr_31395_31418[(2)] = inst_31349);

(statearr_31395_31418[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31391 === (6))){
var _ = (function (){var statearr_31396 = state_31390;
(statearr_31396[(4)] = cljs.core.cons((9),(state_31390[(4)])));

return statearr_31396;
})();
var inst_31361 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31362 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31363 = ["_setting/id","root"];
var inst_31364 = (new cljs.core.PersistentVector(null,2,(5),inst_31362,inst_31363,null));
var inst_31365 = [inst_31364];
var inst_31366 = (new cljs.core.PersistentVector(null,1,(5),inst_31361,inst_31365,null));
var inst_31367 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_31366);
var state_31390__$1 = state_31390;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31390__$1,(10),inst_31367);
} else {
if((state_val_31391 === (3))){
var inst_31388 = (state_31390[(2)]);
var state_31390__$1 = state_31390;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31390__$1,inst_31388);
} else {
if((state_val_31391 === (2))){
var _ = (function (){var statearr_31399 = state_31390;
(statearr_31399[(4)] = cljs.core.cons((5),(state_31390[(4)])));

return statearr_31399;
})();
var state_31390__$1 = state_31390;
var statearr_31400_31419 = state_31390__$1;
(statearr_31400_31419[(2)] = null);

(statearr_31400_31419[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31391 === (9))){
var _ = (function (){var statearr_31401 = state_31390;
(statearr_31401[(4)] = cljs.core.rest((state_31390[(4)])));

return statearr_31401;
})();
var state_31390__$1 = state_31390;
var ex31397 = (state_31390__$1[(2)]);
var statearr_31402_31420 = state_31390__$1;
(statearr_31402_31420[(5)] = ex31397);


var statearr_31403_31421 = state_31390__$1;
(statearr_31403_31421[(1)] = (8));

(statearr_31403_31421[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_31391 === (5))){
var _ = (function (){var statearr_31404 = state_31390;
(statearr_31404[(4)] = cljs.core.rest((state_31390[(4)])));

return statearr_31404;
})();
var state_31390__$1 = state_31390;
var ex31398 = (state_31390__$1[(2)]);
var statearr_31405_31422 = state_31390__$1;
(statearr_31405_31422[(5)] = ex31398);


if((ex31398 instanceof Error)){
var statearr_31406_31423 = state_31390__$1;
(statearr_31406_31423[(1)] = (4));

(statearr_31406_31423[(5)] = null);

} else {
throw ex31398;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31391 === (10))){
var inst_31369 = (state_31390[(2)]);
var inst_31370 = fluree.db.util.async.throw_err(inst_31369);
var _ = (function (){var statearr_31407 = state_31390;
(statearr_31407[(4)] = cljs.core.rest((state_31390[(4)])));

return statearr_31407;
})();
var state_31390__$1 = state_31390;
var statearr_31408_31424 = state_31390__$1;
(statearr_31408_31424[(2)] = inst_31370);

(statearr_31408_31424[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31391 === (8))){
var inst_31355 = (state_31390[(2)]);
var state_31390__$1 = (function (){var statearr_31409 = state_31390;
(statearr_31409[(7)] = inst_31355);

return statearr_31409;
})();
var statearr_31410_31425 = state_31390__$1;
(statearr_31410_31425[(2)] = null);

(statearr_31410_31425[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__15091__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__15091__auto____0 = (function (){
var statearr_31411 = [null,null,null,null,null,null,null,null];
(statearr_31411[(0)] = fluree$db$query$schema$setting_map_$_state_machine__15091__auto__);

(statearr_31411[(1)] = (1));

return statearr_31411;
});
var fluree$db$query$schema$setting_map_$_state_machine__15091__auto____1 = (function (state_31390){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_31390);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e31412){var ex__15094__auto__ = e31412;
var statearr_31413_31426 = state_31390;
(statearr_31413_31426[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_31390[(4)]))){
var statearr_31414_31427 = state_31390;
(statearr_31414_31427[(1)] = cljs.core.first((state_31390[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__31428 = state_31390;
state_31390 = G__31428;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__15091__auto__ = function(state_31390){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__15091__auto____1.call(this,state_31390);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__15091__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__15091__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_31415 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_31415[(6)] = c__15165__auto__);

return statearr_31415;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$t], null));
});
