// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.sql.template');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('clojure.walk');
/**
 * Capitalizes the first letter (and only the first letter) of `s`
 */
fluree.db.query.sql.template.capitalize_first = (function fluree$db$query$sql$template$capitalize_first(s){
if((cljs.core.count(s) <= (1))){
return clojure.string.upper_case(s);
} else {
return [clojure.string.upper_case(cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,(0),(1))),cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,(1))].join('');
}
});
/**
 * Combines `s1` and `s2` by concatenating `s1` with the result of capitalizing
 *   the first character of `s2`
 */
fluree.db.query.sql.template.combine_str = (function fluree$db$query$sql$template$combine_str(s1,s2){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s1),fluree.db.query.sql.template.capitalize_first(s2)].join('');
});
/**
 * Formats `s` by removing any '/' and capitalizing the following character for
 *   each '/' removed
 */
fluree.db.query.sql.template.normalize = (function fluree$db$query$sql$template$normalize(s){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(fluree.db.query.sql.template.combine_str,clojure.string.split.cljs$core$IFn$_invoke$arity$2(s,/\//));
});
/**
 * Formats `s` as a var by prepending '?', filtering out '/', and lowerCamelCasing
 *   the remaining string
 */
fluree.db.query.sql.template.build_var = (function fluree$db$query$sql$template$build_var(s){
return ["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.query.sql.template.normalize(s))].join('');
});
/**
 * Formats the collection string `c` and the field string `f` by joining them
 *   with a '/'
 */
fluree.db.query.sql.template.build_predicate = (function fluree$db$query$sql$template$build_predicate(c,f){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(c),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(f)].join('');
});
/**
 * Returns true if `s` is a predicate string
 */
fluree.db.query.sql.template.predicate_QMARK_ = (function fluree$db$query$sql$template$predicate_QMARK_(s){
var and__5043__auto__ = s;
if(cljs.core.truth_(and__5043__auto__)){
return clojure.string.includes_QMARK_(s,"/");
} else {
return and__5043__auto__;
}
});
/**
 * Formats `terms` as a function call
 */
fluree.db.query.sql.template.build_fn_call = (function fluree$db$query$sql$template$build_fn_call(var_args){
var G__80153 = arguments.length;
switch (G__80153) {
case 2:
return fluree.db.query.sql.template.build_fn_call.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return fluree.db.query.sql.template.build_fn_call.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.sql.template.build_fn_call.cljs$core$IFn$_invoke$arity$2 = (function (fst,sec){
return fluree.db.query.sql.template.build_fn_call.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fst,sec], null));
}));

(fluree.db.query.sql.template.build_fn_call.cljs$core$IFn$_invoke$arity$1 = (function (terms){
return ["(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",terms),")"].join('');
}));

(fluree.db.query.sql.template.build_fn_call.cljs$lang$maxFixedArity = 2);

fluree.db.query.sql.template.template_for = (function fluree$db$query$sql$template$template_for(kw){
return ["@<",cljs.core.str.cljs$core$IFn$_invoke$arity$1(kw),">"].join('');
});
fluree.db.query.sql.template.fill_in = (function fluree$db$query$sql$template$fill_in(tmpl_str,tmpl,v){
return clojure.string.replace(tmpl_str,tmpl,v);
});
/**
 * Template for representing flake collections
 */
fluree.db.query.sql.template.collection = fluree.db.query.sql.template.template_for(cljs.core.cst$kw$collection);
/**
 * Template for storing flake subjects as variables
 */
fluree.db.query.sql.template.collection_var = fluree.db.query.sql.template.build_var(fluree.db.query.sql.template.collection);
/**
 * Fills in the known collection name `coll-name` wherever the collection template
 *   appears in `tmpl-str`
 */
fluree.db.query.sql.template.fill_in_collection = (function fluree$db$query$sql$template$fill_in_collection(coll_name,tmpl_data){
return clojure.walk.postwalk((function (c){
if(typeof c === 'string'){
return fluree.db.query.sql.template.fill_in(c,fluree.db.query.sql.template.collection,coll_name);
} else {
return c;
}
}),tmpl_data);
});
/**
 * Template for represent collection fields
 */
fluree.db.query.sql.template.field = fluree.db.query.sql.template.template_for(cljs.core.cst$kw$field);
/**
 * Template for storing flake fields as variables
 */
fluree.db.query.sql.template.field_var = fluree.db.query.sql.template.build_var(fluree.db.query.sql.template.field);
/**
 * Build a flake predicate template string from the collection template and the
 *   known field value `f`
 */
fluree.db.query.sql.template.field__GT_predicate_template = (function fluree$db$query$sql$template$field__GT_predicate_template(f){
return fluree.db.query.sql.template.build_predicate(fluree.db.query.sql.template.collection,f);
});
/**
 * Template for representing flake predicates with both collection and field
 *   missing
 */
fluree.db.query.sql.template.predicate = fluree.db.query.sql.template.build_predicate(fluree.db.query.sql.template.collection,fluree.db.query.sql.template.field);
