// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.serde.json');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.log');
fluree.db.serde.json.deserialize_block = (function fluree$db$serde$json$deserialize_block(block){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(block,cljs.core.cst$kw$flakes,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.parts__GT_Flake,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(block)));
});
/**
 * Turns :first and :rhs into flakes
 */
fluree.db.serde.json.deserialize_child_node = (function fluree$db$serde$json$deserialize_child_node(child_node){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(child_node,cljs.core.cst$kw$first,(function (){var G__75672 = cljs.core.cst$kw$first.cljs$core$IFn$_invoke$arity$1(child_node);
if((G__75672 == null)){
return null;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(G__75672);
}
})(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$rhs,(function (){var G__75673 = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(child_node);
if((G__75673 == null)){
return null;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(G__75673);
}
})()], 0));
});
fluree.db.serde.json.deserialize_db_root = (function fluree$db$serde$json$deserialize_db_root(db_root){
var map__75674 = db_root;
var map__75674__$1 = cljs.core.__destructure_map(map__75674);
var spot = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75674__$1,cljs.core.cst$kw$spot);
var psot = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75674__$1,cljs.core.cst$kw$psot);
var post = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75674__$1,cljs.core.cst$kw$post);
var opst = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75674__$1,cljs.core.cst$kw$opst);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db_root,cljs.core.cst$kw$spot,fluree.db.serde.json.deserialize_child_node(spot),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$psot,fluree.db.serde.json.deserialize_child_node(psot),cljs.core.cst$kw$post,fluree.db.serde.json.deserialize_child_node(post),cljs.core.cst$kw$opst,fluree.db.serde.json.deserialize_child_node(opst)], 0));
});
fluree.db.serde.json.deserialize_branch_node = (function fluree$db$serde$json$deserialize_branch_node(branch){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(branch,cljs.core.cst$kw$children,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.serde.json.deserialize_child_node,cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(branch)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$rhs,(function (){var G__75675 = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(branch);
if((G__75675 == null)){
return null;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(G__75675);
}
})()], 0));
});
fluree.db.serde.json.deserialize_leaf_node = (function fluree$db$serde$json$deserialize_leaf_node(leaf){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(leaf,cljs.core.cst$kw$flakes,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.parts__GT_Flake,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(leaf)));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.serde.protocol.StorageSerializer}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.serde.json.Serializer = (function (__meta,__extmap,__hash){
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.serde.json.Serializer.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5342__auto__,k__5343__auto__){
var self__ = this;
var this__5342__auto____$1 = this;
return this__5342__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5343__auto__,null);
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5344__auto__,k75677,else__5345__auto__){
var self__ = this;
var this__5344__auto____$1 = this;
var G__75681 = k75677;
switch (G__75681) {
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k75677,else__5345__auto__);

}
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5362__auto__,f__5363__auto__,init__5364__auto__){
var self__ = this;
var this__5362__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5365__auto__,p__75682){
var vec__75683 = p__75682;
var k__5366__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75683,(0),null);
var v__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75683,(1),null);
return (f__5363__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5363__auto__.cljs$core$IFn$_invoke$arity$3(ret__5365__auto__,k__5366__auto__,v__5367__auto__) : f__5363__auto__.call(null,ret__5365__auto__,k__5366__auto__,v__5367__auto__));
}),init__5364__auto__,this__5362__auto____$1);
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5357__auto__,writer__5358__auto__,opts__5359__auto__){
var self__ = this;
var this__5357__auto____$1 = this;
var pr_pair__5360__auto__ = (function (keyval__5361__auto__){
return cljs.core.pr_sequential_writer(writer__5358__auto__,cljs.core.pr_writer,""," ","",opts__5359__auto__,keyval__5361__auto__);
});
return cljs.core.pr_sequential_writer(writer__5358__auto__,pr_pair__5360__auto__,"#fluree.db.serde.json.Serializer{",", ","}",opts__5359__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,self__.__extmap));
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__75676){
var self__ = this;
var G__75676__$1 = this;
return (new cljs.core.RecordIter((0),G__75676__$1,0,cljs.core.PersistentVector.EMPTY,(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5340__auto__){
var self__ = this;
var this__5340__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5337__auto__){
var self__ = this;
var this__5337__auto____$1 = this;
return (new fluree.db.serde.json.Serializer(self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5346__auto__){
var self__ = this;
var this__5346__auto____$1 = this;
return (0 + cljs.core.count(self__.__extmap));
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__75686 = (function (coll__5339__auto__){
return (1505122844 ^ cljs.core.hash_unordered_coll(coll__5339__auto__));
});
return fexpr__75686(this__5338__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this75678,other75679){
var self__ = this;
var this75678__$1 = this;
return (((!((other75679 == null)))) && ((((this75678__$1.constructor === other75679.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this75678__$1.__extmap,other75679.__extmap)))));
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5352__auto__,k__5353__auto__){
var self__ = this;
var this__5352__auto____$1 = this;
if(cljs.core.contains_QMARK_(cljs.core.PersistentHashSet.EMPTY,k__5353__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5352__auto____$1),self__.__meta),k__5353__auto__);
} else {
return (new fluree.db.serde.json.Serializer(self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5353__auto__)),null));
}
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5349__auto__,k75677){
var self__ = this;
var this__5349__auto____$1 = this;
return cljs.core.contains_QMARK_(self__.__extmap,k75677);
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5350__auto__,k__5351__auto__,G__75676){
var self__ = this;
var this__5350__auto____$1 = this;
var pred__75687 = cljs.core.keyword_identical_QMARK_;
var expr__75688 = k__5351__auto__;
return (new fluree.db.serde.json.Serializer(self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5351__auto__,G__75676),null));
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5355__auto__){
var self__ = this;
var this__5355__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,self__.__extmap));
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5341__auto__,G__75676){
var self__ = this;
var this__5341__auto____$1 = this;
return (new fluree.db.serde.json.Serializer(G__75676,self__.__extmap,self__.__hash));
}));

(fluree.db.serde.json.Serializer.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5347__auto__,entry__5348__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5348__auto__)){
return this__5347__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5347__auto____$1,entry__5348__auto__);
}
}));

(fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_deserialize_block$arity$2 = (function (_,block){
var self__ = this;
var ___$1 = this;
return fluree.db.serde.json.deserialize_block(fluree.db.util.json.parse(block));
}));

(fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_deserialize_branch$arity$2 = (function (_,branch){
var self__ = this;
var ___$1 = this;
return fluree.db.serde.json.deserialize_branch_node(fluree.db.util.json.parse(branch));
}));

(fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_serialize_garbage$arity$2 = (function (_,garbage){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-serialize-garbage not supported for JSON.",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_deserialize_db_pointer$arity$2 = (function (_,pointer){
var self__ = this;
var ___$1 = this;
return fluree.db.util.json.parse(pointer);
}));

(fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_deserialize_db_root$arity$2 = (function (_,db_root){
var self__ = this;
var ___$1 = this;
return fluree.db.serde.json.deserialize_db_root(fluree.db.util.json.parse(db_root));
}));

(fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_serialize_branch$arity$2 = (function (_,branch){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-serialize-branch not supported for JSON.",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_deserialize_garbage$arity$2 = (function (_,garbage){
var self__ = this;
var ___$1 = this;
return fluree.db.util.json.parse(garbage);
}));

(fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_serialize_leaf$arity$2 = (function (_,leaf){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-serialize-leaf not supported for JSON.",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_serialize_db_pointer$arity$2 = (function (_,pointer){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-serialize-db-pointer not supported for JSON.",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_deserialize_leaf$arity$2 = (function (_,leaf){
var self__ = this;
var ___$1 = this;
return fluree.db.serde.json.deserialize_leaf_node(fluree.db.util.json.parse(leaf));
}));

(fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_serialize_db_root$arity$2 = (function (_,db_root){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-serialize-db-root not supported for JSON.",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.serde.json.Serializer.prototype.fluree$db$serde$protocol$StorageSerializer$_serialize_block$arity$2 = (function (_,block){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-serialize-block not supported for JSON.",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.serde.json.Serializer.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
}));

(fluree.db.serde.json.Serializer.cljs$lang$type = true);

(fluree.db.serde.json.Serializer.cljs$lang$ctorPrSeq = (function (this__5388__auto__){
return (new cljs.core.List(null,"fluree.db.serde.json/Serializer",null,(1),null));
}));

(fluree.db.serde.json.Serializer.cljs$lang$ctorPrWriter = (function (this__5388__auto__,writer__5389__auto__){
return cljs.core._write(writer__5389__auto__,"fluree.db.serde.json/Serializer");
}));

/**
 * Positional factory function for fluree.db.serde.json/Serializer.
 */
fluree.db.serde.json.__GT_Serializer = (function fluree$db$serde$json$__GT_Serializer(){
return (new fluree.db.serde.json.Serializer(null,null,null));
});

/**
 * Factory function for fluree.db.serde.json/Serializer, taking a map of keywords to field values.
 */
fluree.db.serde.json.map__GT_Serializer = (function fluree$db$serde$json$map__GT_Serializer(G__75680){
var extmap__5384__auto__ = (function (){var G__75690 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1(G__75680);
if(cljs.core.record_QMARK_(G__75680)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__75690);
} else {
return G__75690;
}
})();
return (new fluree.db.serde.json.Serializer(null,cljs.core.not_empty(extmap__5384__auto__),null));
});

/**
 * Returns a JSON serializer / deserializer
 */
fluree.db.serde.json.json_serde = (function fluree$db$serde$json$json_serde(){
return fluree.db.serde.json.__GT_Serializer();
});
