// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5342__auto__,k__5343__auto__){
var self__ = this;
var this__5342__auto____$1 = this;
return this__5342__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5343__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5344__auto__,k42663,else__5345__auto__){
var self__ = this;
var this__5344__auto____$1 = this;
var G__42667 = k42663;
var G__42667__$1 = (((G__42667 instanceof cljs.core.Keyword))?G__42667.fqn:null);
switch (G__42667__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k42663,else__5345__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5362__auto__,f__5363__auto__,init__5364__auto__){
var self__ = this;
var this__5362__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5365__auto__,p__42668){
var vec__42669 = p__42668;
var k__5366__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42669,(0),null);
var v__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42669,(1),null);
return (f__5363__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5363__auto__.cljs$core$IFn$_invoke$arity$3(ret__5365__auto__,k__5366__auto__,v__5367__auto__) : f__5363__auto__.call(null,ret__5365__auto__,k__5366__auto__,v__5367__auto__));
}),init__5364__auto__,this__5362__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5357__auto__,writer__5358__auto__,opts__5359__auto__){
var self__ = this;
var this__5357__auto____$1 = this;
var pr_pair__5360__auto__ = (function (keyval__5361__auto__){
return cljs.core.pr_sequential_writer(writer__5358__auto__,cljs.core.pr_writer,""," ","",opts__5359__auto__,keyval__5361__auto__);
});
return cljs.core.pr_sequential_writer(writer__5358__auto__,pr_pair__5360__auto__,"#fluree.db.session.DbSession{",", ","}",opts__5359__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$db_DASH_name,self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$update_DASH_chan,self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$blank_DASH_db,self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__42662){
var self__ = this;
var G__42662__$1 = this;
return (new cljs.core.RecordIter((0),G__42662__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5340__auto__){
var self__ = this;
var this__5340__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5337__auto__){
var self__ = this;
var this__5337__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5346__auto__){
var self__ = this;
var this__5346__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__42672 = (function (coll__5339__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__5339__auto__));
});
return fexpr__42672(this__5338__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this42664,other42665){
var self__ = this;
var this42664__$1 = this;
return (((!((other42665 == null)))) && ((((this42664__$1.constructor === other42665.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42664__$1.conn,other42665.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42664__$1.network,other42665.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42664__$1.dbid,other42665.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42664__$1.db_name,other42665.db_name)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42664__$1.update_chan,other42665.update_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42664__$1.transact_chan,other42665.transact_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42664__$1.state,other42665.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42664__$1.schema_cache,other42665.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42664__$1.blank_db,other42665.blank_db)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42664__$1.close,other42665.close)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42664__$1.id,other42665.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42664__$1.__extmap,other42665.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5352__auto__,k__5353__auto__){
var self__ = this;
var this__5352__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$update_DASH_chan,null,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$transact_DASH_chan,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$blank_DASH_db,null,cljs.core.cst$kw$conn,null], null), null),k__5353__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5352__auto____$1),self__.__meta),k__5353__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5353__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5349__auto__,k42663){
var self__ = this;
var this__5349__auto____$1 = this;
var G__42673 = k42663;
var G__42673__$1 = (((G__42673 instanceof cljs.core.Keyword))?G__42673.fqn:null);
switch (G__42673__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k42663);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5350__auto__,k__5351__auto__,G__42662){
var self__ = this;
var this__5350__auto____$1 = this;
var pred__42674 = cljs.core.keyword_identical_QMARK_;
var expr__42675 = k__5351__auto__;
if(cljs.core.truth_((function (){var G__42677 = cljs.core.cst$kw$conn;
var G__42678 = expr__42675;
return (pred__42674.cljs$core$IFn$_invoke$arity$2 ? pred__42674.cljs$core$IFn$_invoke$arity$2(G__42677,G__42678) : pred__42674.call(null,G__42677,G__42678));
})())){
return (new fluree.db.session.DbSession(G__42662,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42679 = cljs.core.cst$kw$network;
var G__42680 = expr__42675;
return (pred__42674.cljs$core$IFn$_invoke$arity$2 ? pred__42674.cljs$core$IFn$_invoke$arity$2(G__42679,G__42680) : pred__42674.call(null,G__42679,G__42680));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__42662,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42681 = cljs.core.cst$kw$dbid;
var G__42682 = expr__42675;
return (pred__42674.cljs$core$IFn$_invoke$arity$2 ? pred__42674.cljs$core$IFn$_invoke$arity$2(G__42681,G__42682) : pred__42674.call(null,G__42681,G__42682));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__42662,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42683 = cljs.core.cst$kw$db_DASH_name;
var G__42684 = expr__42675;
return (pred__42674.cljs$core$IFn$_invoke$arity$2 ? pred__42674.cljs$core$IFn$_invoke$arity$2(G__42683,G__42684) : pred__42674.call(null,G__42683,G__42684));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__42662,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42685 = cljs.core.cst$kw$update_DASH_chan;
var G__42686 = expr__42675;
return (pred__42674.cljs$core$IFn$_invoke$arity$2 ? pred__42674.cljs$core$IFn$_invoke$arity$2(G__42685,G__42686) : pred__42674.call(null,G__42685,G__42686));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__42662,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42687 = cljs.core.cst$kw$transact_DASH_chan;
var G__42688 = expr__42675;
return (pred__42674.cljs$core$IFn$_invoke$arity$2 ? pred__42674.cljs$core$IFn$_invoke$arity$2(G__42687,G__42688) : pred__42674.call(null,G__42687,G__42688));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__42662,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42689 = cljs.core.cst$kw$state;
var G__42690 = expr__42675;
return (pred__42674.cljs$core$IFn$_invoke$arity$2 ? pred__42674.cljs$core$IFn$_invoke$arity$2(G__42689,G__42690) : pred__42674.call(null,G__42689,G__42690));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__42662,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42691 = cljs.core.cst$kw$schema_DASH_cache;
var G__42692 = expr__42675;
return (pred__42674.cljs$core$IFn$_invoke$arity$2 ? pred__42674.cljs$core$IFn$_invoke$arity$2(G__42691,G__42692) : pred__42674.call(null,G__42691,G__42692));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__42662,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42693 = cljs.core.cst$kw$blank_DASH_db;
var G__42694 = expr__42675;
return (pred__42674.cljs$core$IFn$_invoke$arity$2 ? pred__42674.cljs$core$IFn$_invoke$arity$2(G__42693,G__42694) : pred__42674.call(null,G__42693,G__42694));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__42662,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42695 = cljs.core.cst$kw$close;
var G__42696 = expr__42675;
return (pred__42674.cljs$core$IFn$_invoke$arity$2 ? pred__42674.cljs$core$IFn$_invoke$arity$2(G__42695,G__42696) : pred__42674.call(null,G__42695,G__42696));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__42662,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42697 = cljs.core.cst$kw$id;
var G__42698 = expr__42675;
return (pred__42674.cljs$core$IFn$_invoke$arity$2 ? pred__42674.cljs$core$IFn$_invoke$arity$2(G__42697,G__42698) : pred__42674.call(null,G__42697,G__42698));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__42662,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5351__auto__,G__42662),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5355__auto__){
var self__ = this;
var this__5355__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$db_DASH_name,self__.db_name,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$update_DASH_chan,self__.update_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$blank_DASH_db,self__.blank_db,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5341__auto__,G__42662){
var self__ = this;
var this__5341__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__42662,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5347__auto__,entry__5348__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5348__auto__)){
return this__5347__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5347__auto____$1,entry__5348__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$db_DASH_name,cljs.core.cst$sym$update_DASH_chan,cljs.core.cst$sym$transact_DASH_chan,cljs.core.cst$sym$state,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$blank_DASH_db,cljs.core.cst$sym$close,cljs.core.cst$sym$id], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__5388__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__5388__auto__,writer__5389__auto__){
return cljs.core._write(writer__5389__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__42666){
var extmap__5384__auto__ = (function (){var G__42699 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__42666,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], 0));
if(cljs.core.record_QMARK_(G__42666)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__42699);
} else {
return G__42699;
}
})();
return (new fluree.db.session.DbSession(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__42666),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__42666),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__42666),cljs.core.cst$kw$db_DASH_name.cljs$core$IFn$_invoke$arity$1(G__42666),cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__42666),cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__42666),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__42666),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__42666),cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(G__42666),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__42666),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__42666),null,cljs.core.not_empty(extmap__5384__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__42702 = session;
var map__42702__$1 = cljs.core.__destructure_map(map__42702);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42702__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42702__$1,cljs.core.cst$kw$dbid);
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.ready_QMARK_ = (function fluree$db$session$ready_QMARK_(db_info){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ready,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(db_info)));
});
fluree.db.session.load_ledger_info = (function fluree$db$session$load_ledger_info(conn,network,dbid){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_42744){
var state_val_42745 = (state_42744[(1)]);
if((state_val_42745 === (7))){
var inst_42718 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," is not found on this ledger group."].join('');
var inst_42719 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42720 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_42721 = cljs.core.PersistentHashMap.fromArrays(inst_42719,inst_42720);
var inst_42722 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42718,inst_42721);
var inst_42723 = (function(){throw inst_42722})();
var state_42744__$1 = state_42744;
var statearr_42746_42769 = state_42744__$1;
(statearr_42746_42769[(2)] = inst_42723);

(statearr_42746_42769[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42745 === (1))){
var state_42744__$1 = state_42744;
var statearr_42747_42770 = state_42744__$1;
(statearr_42747_42770[(2)] = null);

(statearr_42747_42770[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42745 === (4))){
var inst_42703 = (state_42744[(2)]);
var state_42744__$1 = state_42744;
var statearr_42748_42771 = state_42744__$1;
(statearr_42748_42771[(2)] = inst_42703);

(statearr_42748_42771[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42745 === (6))){
var inst_42715 = (state_42744[(7)]);
var inst_42714 = (state_42744[(2)]);
var inst_42715__$1 = fluree.db.util.async.throw_err(inst_42714);
var inst_42716 = cljs.core.empty_QMARK_(inst_42715__$1);
var state_42744__$1 = (function (){var statearr_42749 = state_42744;
(statearr_42749[(7)] = inst_42715__$1);

return statearr_42749;
})();
if(inst_42716){
var statearr_42750_42772 = state_42744__$1;
(statearr_42750_42772[(1)] = (7));

} else {
var statearr_42751_42773 = state_42744__$1;
(statearr_42751_42773[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42745 === (3))){
var inst_42742 = (state_42744[(2)]);
var state_42744__$1 = state_42744;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42744__$1,inst_42742);
} else {
if((state_val_42745 === (12))){
var inst_42737 = (state_42744[(2)]);
var state_42744__$1 = state_42744;
var statearr_42752_42774 = state_42744__$1;
(statearr_42752_42774[(2)] = inst_42737);

(statearr_42752_42774[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42745 === (2))){
var _ = (function (){var statearr_42753 = state_42744;
(statearr_42753[(4)] = cljs.core.cons((5),(state_42744[(4)])));

return statearr_42753;
})();
var inst_42709 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42710 = [network,dbid];
var inst_42711 = (new cljs.core.PersistentVector(null,2,(5),inst_42709,inst_42710,null));
var inst_42712 = fluree.db.operations.ledger_info_async(conn,inst_42711);
var state_42744__$1 = state_42744;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42744__$1,(6),inst_42712);
} else {
if((state_val_42745 === (11))){
var inst_42715 = (state_42744[(7)]);
var state_42744__$1 = state_42744;
var statearr_42755_42775 = state_42744__$1;
(statearr_42755_42775[(2)] = inst_42715);

(statearr_42755_42775[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42745 === (9))){
var inst_42739 = (state_42744[(2)]);
var _ = (function (){var statearr_42756 = state_42744;
(statearr_42756[(4)] = cljs.core.rest((state_42744[(4)])));

return statearr_42756;
})();
var state_42744__$1 = state_42744;
var statearr_42757_42776 = state_42744__$1;
(statearr_42757_42776[(2)] = inst_42739);

(statearr_42757_42776[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42745 === (5))){
var _ = (function (){var statearr_42758 = state_42744;
(statearr_42758[(4)] = cljs.core.rest((state_42744[(4)])));

return statearr_42758;
})();
var state_42744__$1 = state_42744;
var ex42754 = (state_42744__$1[(2)]);
var statearr_42759_42777 = state_42744__$1;
(statearr_42759_42777[(5)] = ex42754);


if((ex42754 instanceof Error)){
var statearr_42760_42778 = state_42744__$1;
(statearr_42760_42778[(1)] = (4));

(statearr_42760_42778[(5)] = null);

} else {
throw ex42754;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42745 === (10))){
var inst_42715 = (state_42744[(7)]);
var inst_42728 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_42715);
var inst_42729 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42728),"."].join('');
var inst_42730 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42731 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_42732 = cljs.core.PersistentHashMap.fromArrays(inst_42730,inst_42731);
var inst_42733 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42729,inst_42732);
var inst_42734 = (function(){throw inst_42733})();
var state_42744__$1 = state_42744;
var statearr_42761_42779 = state_42744__$1;
(statearr_42761_42779[(2)] = inst_42734);

(statearr_42761_42779[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42745 === (8))){
var inst_42715 = (state_42744[(7)]);
var inst_42725 = fluree.db.session.ready_QMARK_(inst_42715);
var inst_42726 = (!(inst_42725));
var state_42744__$1 = state_42744;
if(inst_42726){
var statearr_42762_42780 = state_42744__$1;
(statearr_42762_42780[(1)] = (10));

} else {
var statearr_42763_42781 = state_42744__$1;
(statearr_42763_42781[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_ledger_info_$_state_machine__15091__auto__ = null;
var fluree$db$session$load_ledger_info_$_state_machine__15091__auto____0 = (function (){
var statearr_42764 = [null,null,null,null,null,null,null,null];
(statearr_42764[(0)] = fluree$db$session$load_ledger_info_$_state_machine__15091__auto__);

(statearr_42764[(1)] = (1));

return statearr_42764;
});
var fluree$db$session$load_ledger_info_$_state_machine__15091__auto____1 = (function (state_42744){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_42744);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e42765){var ex__15094__auto__ = e42765;
var statearr_42766_42782 = state_42744;
(statearr_42766_42782[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_42744[(4)]))){
var statearr_42767_42783 = state_42744;
(statearr_42767_42783[(1)] = cljs.core.first((state_42744[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__42784 = state_42744;
state_42744 = G__42784;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$session$load_ledger_info_$_state_machine__15091__auto__ = function(state_42744){
switch(arguments.length){
case 0:
return fluree$db$session$load_ledger_info_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$session$load_ledger_info_$_state_machine__15091__auto____1.call(this,state_42744);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_ledger_info_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_ledger_info_$_state_machine__15091__auto____0;
fluree$db$session$load_ledger_info_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_ledger_info_$_state_machine__15091__auto____1;
return fluree$db$session$load_ledger_info_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_42768 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_42768[(6)] = c__15165__auto__);

return statearr_42768;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
fluree.db.session.load_current_db = (function fluree$db$session$load_current_db(conn,p__42785){
var map__42786 = p__42785;
var map__42786__$1 = cljs.core.__destructure_map(map__42786);
var blank_db = map__42786__$1;
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42786__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42786__$1,cljs.core.cst$kw$dbid);
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_42861){
var state_val_42862 = (state_42861[(1)]);
if((state_val_42862 === (7))){
var inst_42804 = (state_42861[(7)]);
var inst_42803 = (state_42861[(2)]);
var inst_42804__$1 = fluree.db.util.async.throw_err(inst_42803);
var state_42861__$1 = (function (){var statearr_42863 = state_42861;
(statearr_42863[(7)] = inst_42804__$1);

return statearr_42863;
})();
if(cljs.core.truth_(inst_42804__$1)){
var statearr_42864_42899 = state_42861__$1;
(statearr_42864_42899[(1)] = (8));

} else {
var statearr_42865_42900 = state_42861__$1;
(statearr_42865_42900[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42862 === (20))){
var inst_42809 = (state_42861[(8)]);
var inst_42842 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42809)," for ledger: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid),"."].join('');
var inst_42843 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42844 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_42845 = cljs.core.PersistentHashMap.fromArrays(inst_42843,inst_42844);
var inst_42846 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42842,inst_42845);
var inst_42847 = (function(){throw inst_42846})();
var state_42861__$1 = state_42861;
var statearr_42866_42901 = state_42861__$1;
(statearr_42866_42901[(2)] = inst_42847);

(statearr_42866_42901[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42862 === (1))){
var state_42861__$1 = state_42861;
var statearr_42867_42902 = state_42861__$1;
(statearr_42867_42902[(2)] = null);

(statearr_42867_42902[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42862 === (4))){
var inst_42787 = (state_42861[(2)]);
var state_42861__$1 = state_42861;
var statearr_42868_42903 = state_42861__$1;
(statearr_42868_42903[(2)] = inst_42787);

(statearr_42868_42903[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42862 === (15))){
var inst_42851 = (state_42861[(2)]);
var state_42861__$1 = state_42861;
var statearr_42869_42904 = state_42861__$1;
(statearr_42869_42904[(2)] = inst_42851);

(statearr_42869_42904[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42862 === (21))){
var inst_42849 = (state_42861[(2)]);
var state_42861__$1 = state_42861;
var statearr_42870_42905 = state_42861__$1;
(statearr_42870_42905[(2)] = inst_42849);

(statearr_42870_42905[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42862 === (13))){
var inst_42808 = (state_42861[(9)]);
var inst_42813 = fluree.db.query.schema.schema_map(inst_42808);
var inst_42814 = fluree.db.query.schema.setting_map(inst_42808);
var inst_42815 = cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(inst_42808);
var inst_42816 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_42815,cljs.core.empty);
var state_42861__$1 = (function (){var statearr_42871 = state_42861;
(statearr_42871[(10)] = inst_42816);

(statearr_42871[(11)] = inst_42814);

return statearr_42871;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42861__$1,(16),inst_42813);
} else {
if((state_val_42862 === (22))){
var inst_42809 = (state_42861[(8)]);
var inst_42837 = (state_42861[(2)]);
var inst_42838 = fluree.db.util.async.throw_err(inst_42837);
var inst_42839 = (inst_42809 + (1));
var inst_42808 = inst_42838;
var inst_42809__$1 = inst_42839;
var state_42861__$1 = (function (){var statearr_42872 = state_42861;
(statearr_42872[(9)] = inst_42808);

(statearr_42872[(8)] = inst_42809__$1);

return statearr_42872;
})();
var statearr_42873_42906 = state_42861__$1;
(statearr_42873_42906[(2)] = null);

(statearr_42873_42906[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42862 === (6))){
var inst_42796 = (state_42861[(2)]);
var inst_42797 = fluree.db.util.async.throw_err(inst_42796);
var inst_42798 = cljs.core.__destructure_map(inst_42797);
var inst_42799 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42798,cljs.core.cst$kw$block);
var inst_42800 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42798,cljs.core.cst$kw$index);
var inst_42801 = fluree.db.storage.core.reify_db(conn,network,dbid,blank_db,inst_42800);
var state_42861__$1 = (function (){var statearr_42874 = state_42861;
(statearr_42874[(12)] = inst_42799);

return statearr_42874;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42861__$1,(7),inst_42801);
} else {
if((state_val_42862 === (17))){
var inst_42808 = (state_42861[(9)]);
var inst_42819 = (state_42861[(13)]);
var inst_42821 = (state_42861[(2)]);
var inst_42822 = fluree.db.util.async.throw_err(inst_42821);
var inst_42823 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_42808,cljs.core.cst$kw$schema,inst_42819,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$settings,inst_42822], 0));
var state_42861__$1 = state_42861;
var statearr_42875_42907 = state_42861__$1;
(statearr_42875_42907[(2)] = inst_42823);

(statearr_42875_42907[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42862 === (3))){
var inst_42859 = (state_42861[(2)]);
var state_42861__$1 = state_42861;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42861__$1,inst_42859);
} else {
if((state_val_42862 === (12))){
var inst_42853 = (state_42861[(2)]);
var state_42861__$1 = state_42861;
var statearr_42876_42908 = state_42861__$1;
(statearr_42876_42908[(2)] = inst_42853);

(statearr_42876_42908[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42862 === (2))){
var _ = (function (){var statearr_42877 = state_42861;
(statearr_42877[(4)] = cljs.core.cons((5),(state_42861[(4)])));

return statearr_42877;
})();
var inst_42794 = fluree.db.session.load_ledger_info(conn,network,dbid);
var state_42861__$1 = state_42861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42861__$1,(6),inst_42794);
} else {
if((state_val_42862 === (19))){
var inst_42828 = (state_42861[(14)]);
var inst_42808 = (state_42861[(9)]);
var inst_42831 = cljs.core.__destructure_map(inst_42828);
var inst_42832 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42831,cljs.core.cst$kw$flakes);
var inst_42833 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42831,cljs.core.cst$kw$block);
var inst_42834 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42831,cljs.core.cst$kw$t);
var inst_42835 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_42808,inst_42833,inst_42832);
var state_42861__$1 = (function (){var statearr_42878 = state_42861;
(statearr_42878[(15)] = inst_42834);

return statearr_42878;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42861__$1,(22),inst_42835);
} else {
if((state_val_42862 === (11))){
var inst_42799 = (state_42861[(12)]);
var inst_42809 = (state_42861[(8)]);
var inst_42811 = (inst_42809 > inst_42799);
var state_42861__$1 = state_42861;
if(cljs.core.truth_(inst_42811)){
var statearr_42880_42909 = state_42861__$1;
(statearr_42880_42909[(1)] = (13));

} else {
var statearr_42881_42910 = state_42861__$1;
(statearr_42881_42910[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42862 === (9))){
var state_42861__$1 = state_42861;
var statearr_42882_42911 = state_42861__$1;
(statearr_42882_42911[(2)] = null);

(statearr_42882_42911[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42862 === (5))){
var _ = (function (){var statearr_42883 = state_42861;
(statearr_42883[(4)] = cljs.core.rest((state_42861[(4)])));

return statearr_42883;
})();
var state_42861__$1 = state_42861;
var ex42879 = (state_42861__$1[(2)]);
var statearr_42884_42912 = state_42861__$1;
(statearr_42884_42912[(5)] = ex42879);


if((ex42879 instanceof Error)){
var statearr_42885_42913 = state_42861__$1;
(statearr_42885_42913[(1)] = (4));

(statearr_42885_42913[(5)] = null);

} else {
throw ex42879;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42862 === (14))){
var inst_42809 = (state_42861[(8)]);
var inst_42825 = fluree.db.storage.core.read_block(conn,network,dbid,inst_42809);
var state_42861__$1 = state_42861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42861__$1,(18),inst_42825);
} else {
if((state_val_42862 === (16))){
var inst_42814 = (state_42861[(11)]);
var inst_42818 = (state_42861[(2)]);
var inst_42819 = fluree.db.util.async.throw_err(inst_42818);
var state_42861__$1 = (function (){var statearr_42886 = state_42861;
(statearr_42886[(13)] = inst_42819);

return statearr_42886;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42861__$1,(17),inst_42814);
} else {
if((state_val_42862 === (10))){
var inst_42856 = (state_42861[(2)]);
var _ = (function (){var statearr_42887 = state_42861;
(statearr_42887[(4)] = cljs.core.rest((state_42861[(4)])));

return statearr_42887;
})();
var state_42861__$1 = state_42861;
var statearr_42888_42914 = state_42861__$1;
(statearr_42888_42914[(2)] = inst_42856);

(statearr_42888_42914[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42862 === (18))){
var inst_42828 = (state_42861[(14)]);
var inst_42827 = (state_42861[(2)]);
var inst_42828__$1 = fluree.db.util.async.throw_err(inst_42827);
var state_42861__$1 = (function (){var statearr_42889 = state_42861;
(statearr_42889[(14)] = inst_42828__$1);

return statearr_42889;
})();
if(cljs.core.truth_(inst_42828__$1)){
var statearr_42890_42915 = state_42861__$1;
(statearr_42890_42915[(1)] = (19));

} else {
var statearr_42891_42916 = state_42861__$1;
(statearr_42891_42916[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42862 === (8))){
var inst_42804 = (state_42861[(7)]);
var inst_42806 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_42804);
var inst_42807 = (inst_42806 + (1));
var inst_42808 = inst_42804;
var inst_42809 = inst_42807;
var state_42861__$1 = (function (){var statearr_42892 = state_42861;
(statearr_42892[(9)] = inst_42808);

(statearr_42892[(8)] = inst_42809);

return statearr_42892;
})();
var statearr_42893_42917 = state_42861__$1;
(statearr_42893_42917[(2)] = null);

(statearr_42893_42917[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_current_db_$_state_machine__15091__auto__ = null;
var fluree$db$session$load_current_db_$_state_machine__15091__auto____0 = (function (){
var statearr_42894 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42894[(0)] = fluree$db$session$load_current_db_$_state_machine__15091__auto__);

(statearr_42894[(1)] = (1));

return statearr_42894;
});
var fluree$db$session$load_current_db_$_state_machine__15091__auto____1 = (function (state_42861){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_42861);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e42895){var ex__15094__auto__ = e42895;
var statearr_42896_42918 = state_42861;
(statearr_42896_42918[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_42861[(4)]))){
var statearr_42897_42919 = state_42861;
(statearr_42897_42919[(1)] = cljs.core.first((state_42861[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__42920 = state_42861;
state_42861 = G__42920;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$session$load_current_db_$_state_machine__15091__auto__ = function(state_42861){
switch(arguments.length){
case 0:
return fluree$db$session$load_current_db_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$session$load_current_db_$_state_machine__15091__auto____1.call(this,state_42861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_current_db_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_current_db_$_state_machine__15091__auto____0;
fluree$db$session$load_current_db_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_current_db_$_state_machine__15091__auto____1;
return fluree$db$session$load_current_db_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_42898 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_42898[(6)] = c__15165__auto__);

return statearr_42898;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Perform a compare and set operation to update the db stored in the session
 *   argument's state atom. Update the cache to `new-db-ch`, but only if the
 *   previously stored db channel is the same as the `old-db-ch`. Returns a boolean
 *   indicating whether the cache was updated.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(p__42921,old_db_ch,new_db_ch){
var map__42922 = p__42921;
var map__42922__$1 = cljs.core.__destructure_map(map__42922);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42922__$1,cljs.core.cst$kw$state);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$db_SLASH_current.cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (p__42923){
var map__42924 = p__42923;
var map__42924__$1 = cljs.core.__destructure_map(map__42924);
var s = map__42924__$1;
var current = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42924__$1,cljs.core.cst$kw$db_SLASH_current);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current,old_db_ch)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,cljs.core.cst$kw$db_SLASH_current,new_db_ch);
} else {
return s;
}
}))),new_db_ch);
});
/**
 * Clears db channel from session state, forcing a new full load next time db
 *   channel is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(p__42925){
var map__42926 = p__42925;
var map__42926__$1 = cljs.core.__destructure_map(map__42926);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42926__$1,cljs.core.cst$kw$state);
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,cljs.core.cst$kw$db_SLASH_current,null);
});
/**
 * Clears any cached database channels and forces an immediate reload. Returns a
 *   channel that will contain the newly loaded database
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(p__42927){
var map__42928 = p__42927;
var map__42928__$1 = cljs.core.__destructure_map(map__42928);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42928__$1,cljs.core.cst$kw$conn);
var blank_db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42928__$1,cljs.core.cst$kw$blank_DASH_db);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42928__$1,cljs.core.cst$kw$state);
var db_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,cljs.core.cst$kw$db_SLASH_current,db_ch);

var c__15165__auto___42965 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_42948){
var state_val_42949 = (state_42948[(1)]);
if((state_val_42949 === (1))){
var state_42948__$1 = state_42948;
var statearr_42950_42966 = state_42948__$1;
(statearr_42950_42966[(2)] = null);

(statearr_42950_42966[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42949 === (2))){
var _ = (function (){var statearr_42951 = state_42948;
(statearr_42951[(4)] = cljs.core.cons((5),(state_42948[(4)])));

return statearr_42951;
})();
var inst_42938 = fluree.db.session.load_current_db(conn,blank_db);
var state_42948__$1 = state_42948;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42948__$1,(6),inst_42938);
} else {
if((state_val_42949 === (3))){
var inst_42946 = (state_42948[(2)]);
var state_42948__$1 = state_42948;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42948__$1,inst_42946);
} else {
if((state_val_42949 === (4))){
var inst_42929 = (state_42948[(2)]);
var inst_42930 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,cljs.core.cst$kw$db_SLASH_current,null);
var inst_42931 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_42929,"Error reloading db"], 0));
var inst_42932 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(db_ch,inst_42929);
var state_42948__$1 = (function (){var statearr_42953 = state_42948;
(statearr_42953[(7)] = inst_42930);

(statearr_42953[(8)] = inst_42931);

return statearr_42953;
})();
var statearr_42954_42967 = state_42948__$1;
(statearr_42954_42967[(2)] = inst_42932);

(statearr_42954_42967[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42949 === (5))){
var _ = (function (){var statearr_42955 = state_42948;
(statearr_42955[(4)] = cljs.core.rest((state_42948[(4)])));

return statearr_42955;
})();
var state_42948__$1 = state_42948;
var ex42952 = (state_42948__$1[(2)]);
var statearr_42956_42968 = state_42948__$1;
(statearr_42956_42968[(5)] = ex42952);


var statearr_42957_42969 = state_42948__$1;
(statearr_42957_42969[(1)] = (4));

(statearr_42957_42969[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_42949 === (6))){
var inst_42940 = (state_42948[(2)]);
var inst_42941 = fluree.db.util.async.throw_err(inst_42940);
var state_42948__$1 = state_42948;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42948__$1,(7),db_ch,inst_42941);
} else {
if((state_val_42949 === (7))){
var inst_42943 = (state_42948[(2)]);
var _ = (function (){var statearr_42958 = state_42948;
(statearr_42958[(4)] = cljs.core.rest((state_42948[(4)])));

return statearr_42958;
})();
var state_42948__$1 = state_42948;
var statearr_42959_42970 = state_42948__$1;
(statearr_42959_42970[(2)] = inst_42943);

(statearr_42959_42970[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$reload_db_BANG__$_state_machine__15091__auto__ = null;
var fluree$db$session$reload_db_BANG__$_state_machine__15091__auto____0 = (function (){
var statearr_42960 = [null,null,null,null,null,null,null,null,null];
(statearr_42960[(0)] = fluree$db$session$reload_db_BANG__$_state_machine__15091__auto__);

(statearr_42960[(1)] = (1));

return statearr_42960;
});
var fluree$db$session$reload_db_BANG__$_state_machine__15091__auto____1 = (function (state_42948){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_42948);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e42961){var ex__15094__auto__ = e42961;
var statearr_42962_42971 = state_42948;
(statearr_42962_42971[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_42948[(4)]))){
var statearr_42963_42972 = state_42948;
(statearr_42963_42972[(1)] = cljs.core.first((state_42948[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__42973 = state_42948;
state_42948 = G__42973;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$session$reload_db_BANG__$_state_machine__15091__auto__ = function(state_42948){
switch(arguments.length){
case 0:
return fluree$db$session$reload_db_BANG__$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$session$reload_db_BANG__$_state_machine__15091__auto____1.call(this,state_42948);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$reload_db_BANG__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$reload_db_BANG__$_state_machine__15091__auto____0;
fluree$db$session$reload_db_BANG__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$reload_db_BANG__$_state_machine__15091__auto____1;
return fluree$db$session$reload_db_BANG__$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_42964 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_42964[(6)] = c__15165__auto___42965);

return statearr_42964;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));


return db_ch;
});
/**
 * Gets the channel containing the current database from the session's state. If
 *   no database channel is cached then the current database is loaded form storage
 *   and a new channel containing it is cached. Returns the cached channel that
 *   will contain the current database
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(var_args){
var G__42975 = arguments.length;
switch (G__42975) {
case 1:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 = (function (p__42976){
var map__42977 = p__42976;
var map__42977__$1 = cljs.core.__destructure_map(map__42977);
var session = map__42977__$1;
var blank_db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42977__$1,cljs.core.cst$kw$blank_DASH_db);
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2(session,blank_db);
}));

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2 = (function (p__42978,blank_db){
var map__42979 = p__42978;
var map__42979__$1 = cljs.core.__destructure_map(map__42979);
var session = map__42979__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42979__$1,cljs.core.cst$kw$conn);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42979__$1,cljs.core.cst$kw$state);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (s){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,cljs.core.cst$kw$req_SLASH_last,fluree.db.util.core.current_time_millis()),cljs.core.cst$kw$req_SLASH_count,cljs.core.inc);
}));

var or__5045__auto__ = cljs.core.cst$kw$db_SLASH_current.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var cur_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var state_ch = cljs.core.cst$kw$db_SLASH_current.cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (s){
if(cljs.core.not(cljs.core.cst$kw$db_SLASH_current.cljs$core$IFn$_invoke$arity$1(s))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,cljs.core.cst$kw$db_SLASH_current,cur_ch);
} else {
return s;
}
})));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cur_ch,state_ch)){
var c__15165__auto___43017 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_42999){
var state_val_43000 = (state_42999[(1)]);
if((state_val_43000 === (1))){
var state_42999__$1 = state_42999;
var statearr_43001_43018 = state_42999__$1;
(statearr_43001_43018[(2)] = null);

(statearr_43001_43018[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43000 === (2))){
var _ = (function (){var statearr_43002 = state_42999;
(statearr_43002[(4)] = cljs.core.cons((5),(state_42999[(4)])));

return statearr_43002;
})();
var inst_42989 = fluree.db.session.load_current_db(conn,blank_db);
var state_42999__$1 = state_42999;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42999__$1,(6),inst_42989);
} else {
if((state_val_43000 === (3))){
var inst_42997 = (state_42999[(2)]);
var state_42999__$1 = state_42999;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42999__$1,inst_42997);
} else {
if((state_val_43000 === (4))){
var inst_42980 = (state_42999[(2)]);
var inst_42981 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,cljs.core.cst$kw$db_SLASH_current,null);
var inst_42982 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_42980,"Error loading current db"], 0));
var inst_42983 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cur_ch,inst_42980);
var state_42999__$1 = (function (){var statearr_43004 = state_42999;
(statearr_43004[(7)] = inst_42982);

(statearr_43004[(8)] = inst_42981);

return statearr_43004;
})();
var statearr_43005_43019 = state_42999__$1;
(statearr_43005_43019[(2)] = inst_42983);

(statearr_43005_43019[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43000 === (5))){
var _ = (function (){var statearr_43006 = state_42999;
(statearr_43006[(4)] = cljs.core.rest((state_42999[(4)])));

return statearr_43006;
})();
var state_42999__$1 = state_42999;
var ex43003 = (state_42999__$1[(2)]);
var statearr_43007_43020 = state_42999__$1;
(statearr_43007_43020[(5)] = ex43003);


var statearr_43008_43021 = state_42999__$1;
(statearr_43008_43021[(1)] = (4));

(statearr_43008_43021[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_43000 === (6))){
var inst_42991 = (state_42999[(2)]);
var inst_42992 = fluree.db.util.async.throw_err(inst_42991);
var state_42999__$1 = state_42999;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42999__$1,(7),cur_ch,inst_42992);
} else {
if((state_val_43000 === (7))){
var inst_42994 = (state_42999[(2)]);
var _ = (function (){var statearr_43009 = state_42999;
(statearr_43009[(4)] = cljs.core.rest((state_42999[(4)])));

return statearr_43009;
})();
var state_42999__$1 = state_42999;
var statearr_43010_43022 = state_42999__$1;
(statearr_43010_43022[(2)] = inst_42994);

(statearr_43010_43022[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__15091__auto__ = null;
var fluree$db$session$state_machine__15091__auto____0 = (function (){
var statearr_43011 = [null,null,null,null,null,null,null,null,null];
(statearr_43011[(0)] = fluree$db$session$state_machine__15091__auto__);

(statearr_43011[(1)] = (1));

return statearr_43011;
});
var fluree$db$session$state_machine__15091__auto____1 = (function (state_42999){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_42999);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e43012){var ex__15094__auto__ = e43012;
var statearr_43013_43023 = state_42999;
(statearr_43013_43023[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_42999[(4)]))){
var statearr_43014_43024 = state_42999;
(statearr_43014_43024[(1)] = cljs.core.first((state_42999[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__43025 = state_42999;
state_42999 = G__43025;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$session$state_machine__15091__auto__ = function(state_42999){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__15091__auto____1.call(this,state_42999);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__15091__auto____0;
fluree$db$session$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__15091__auto____1;
return fluree$db$session$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_43015 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_43015[(6)] = c__15165__auto___43017);

return statearr_43015;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));


return cur_ch;
} else {
return state_ch;
}
}
}));

(fluree.db.session.current_db.cljs$lang$maxFixedArity = 2);

/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return cljs.core.cst$kw$db_SLASH_indexed.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,cljs.core.cst$kw$db_SLASH_indexing,pc);
} else {
return s;
}
}));
var res_pc = cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$db_SLASH_indexed,block], 0));
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$threshold,(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__5641__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5645__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__43026 = cljs.core.get_global_hierarchy;
return (fexpr__43026.cljs$core$IFn$_invoke$arity$0 ? fexpr__43026.cljs$core$IFn$_invoke$arity$0() : fexpr__43026.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),cljs.core.cst$kw$default,hierarchy__5645__auto__,method_table__5641__auto__,prefer_table__5642__auto__,method_cache__5643__auto__,cached_hierarchy__5644__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$local_DASH_ledger_DASH_update,(function (_,___$1,___$2){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_43028){
var state_val_43029 = (state_43028[(1)]);
if((state_val_43029 === (1))){
var state_43028__$1 = state_43028;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43028__$1,cljs.core.cst$kw$fluree$db$session_SLASH_no_DASH_op);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__15091__auto__ = null;
var fluree$db$session$state_machine__15091__auto____0 = (function (){
var statearr_43030 = [null,null,null,null,null,null,null];
(statearr_43030[(0)] = fluree$db$session$state_machine__15091__auto__);

(statearr_43030[(1)] = (1));

return statearr_43030;
});
var fluree$db$session$state_machine__15091__auto____1 = (function (state_43028){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_43028);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e43031){var ex__15094__auto__ = e43031;
var statearr_43032_43035 = state_43028;
(statearr_43032_43035[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_43028[(4)]))){
var statearr_43033_43036 = state_43028;
(statearr_43033_43036[(1)] = cljs.core.first((state_43028[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__43037 = state_43028;
state_43028 = G__43037;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$session$state_machine__15091__auto__ = function(state_43028){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__15091__auto____1.call(this,state_43028);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__15091__auto____0;
fluree$db$session$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__15091__auto____1;
return fluree$db$session$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_43034 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_43034[(6)] = c__15165__auto__);

return statearr_43034;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$block,(function (session,event_type,p__43038){
var map__43039 = p__43038;
var map__43039__$1 = cljs.core.__destructure_map(map__43039);
var data = map__43039__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43039__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43039__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43039__$1,cljs.core.cst$kw$flakes);
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_43098){
var state_val_43099 = (state_43098[(1)]);
if((state_val_43099 === (7))){
var inst_43050 = (state_43098[(7)]);
var inst_43053 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_43054 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_43055 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43053),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43054),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43050),". No-op."].join('');
var inst_43056 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43055], 0));
var state_43098__$1 = state_43098;
var statearr_43100_43138 = state_43098__$1;
(statearr_43100_43138[(2)] = inst_43056);

(statearr_43100_43138[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43099 === (1))){
var state_43098__$1 = state_43098;
var statearr_43101_43139 = state_43098__$1;
(statearr_43101_43139[(2)] = null);

(statearr_43101_43139[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43099 === (4))){
var inst_43040 = (state_43098[(2)]);
var state_43098__$1 = state_43098;
var statearr_43102_43140 = state_43098__$1;
(statearr_43102_43140[(2)] = inst_43040);

(statearr_43102_43140[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43099 === (15))){
var inst_43079 = (state_43098[(2)]);
var state_43098__$1 = state_43098;
var statearr_43103_43141 = state_43098__$1;
(statearr_43103_43141[(2)] = inst_43079);

(statearr_43103_43141[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43099 === (13))){
var inst_43070 = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
var inst_43071 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43072 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_43073 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_43074 = [inst_43072,inst_43073];
var inst_43075 = (new cljs.core.PersistentVector(null,2,(5),inst_43071,inst_43074,null));
var inst_43076 = (function (){var G__43104 = inst_43070;
var G__43105 = cljs.core.cst$kw$local_DASH_ledger_DASH_update;
var G__43106 = inst_43075;
var G__43107 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__43104,G__43105,G__43106,G__43107) : fluree.db.conn_events.process_event.call(null,G__43104,G__43105,G__43106,G__43107));
})();
var state_43098__$1 = state_43098;
var statearr_43108_43142 = state_43098__$1;
(statearr_43108_43142[(2)] = inst_43076);

(statearr_43108_43142[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43099 === (6))){
var inst_43050 = (state_43098[(7)]);
var inst_43049 = (state_43098[(8)]);
var inst_43048 = (state_43098[(2)]);
var inst_43049__$1 = fluree.db.util.async.throw_err(inst_43048);
var inst_43050__$1 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_43049__$1);
var inst_43051 = (block <= inst_43050__$1);
var state_43098__$1 = (function (){var statearr_43109 = state_43098;
(statearr_43109[(7)] = inst_43050__$1);

(statearr_43109[(8)] = inst_43049__$1);

return statearr_43109;
})();
if(cljs.core.truth_(inst_43051)){
var statearr_43110_43143 = state_43098__$1;
(statearr_43110_43143[(1)] = (7));

} else {
var statearr_43111_43144 = state_43098__$1;
(statearr_43111_43144[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43099 === (17))){
var state_43098__$1 = state_43098;
var statearr_43112_43145 = state_43098__$1;
(statearr_43112_43145[(2)] = null);

(statearr_43112_43145[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43099 === (3))){
var inst_43096 = (state_43098[(2)]);
var state_43098__$1 = state_43098;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43098__$1,inst_43096);
} else {
if((state_val_43099 === (12))){
var inst_43091 = (state_43098[(2)]);
var state_43098__$1 = state_43098;
var statearr_43113_43146 = state_43098__$1;
(statearr_43113_43146[(2)] = inst_43091);

(statearr_43113_43146[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43099 === (2))){
var inst_43046 = (state_43098[(9)]);
var _ = (function (){var statearr_43114 = state_43098;
(statearr_43114[(4)] = cljs.core.cons((5),(state_43098[(4)])));

return statearr_43114;
})();
var inst_43046__$1 = fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session);
var state_43098__$1 = (function (){var statearr_43115 = state_43098;
(statearr_43115[(9)] = inst_43046__$1);

return statearr_43115;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43098__$1,(6),inst_43046__$1);
} else {
if((state_val_43099 === (11))){
var state_43098__$1 = state_43098;
var statearr_43117_43147 = state_43098__$1;
(statearr_43117_43147[(1)] = (16));



return cljs.core.cst$kw$recur;
} else {
if((state_val_43099 === (9))){
var inst_43093 = (state_43098[(2)]);
var _ = (function (){var statearr_43119 = state_43098;
(statearr_43119[(4)] = cljs.core.rest((state_43098[(4)])));

return statearr_43119;
})();
var state_43098__$1 = state_43098;
var statearr_43120_43148 = state_43098__$1;
(statearr_43120_43148[(2)] = inst_43093);

(statearr_43120_43148[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43099 === (5))){
var _ = (function (){var statearr_43121 = state_43098;
(statearr_43121[(4)] = cljs.core.rest((state_43098[(4)])));

return statearr_43121;
})();
var state_43098__$1 = state_43098;
var ex43116 = (state_43098__$1[(2)]);
var statearr_43122_43149 = state_43098__$1;
(statearr_43122_43149[(5)] = ex43116);


if((ex43116 instanceof Error)){
var statearr_43123_43150 = state_43098__$1;
(statearr_43123_43150[(1)] = (4));

(statearr_43123_43150[(5)] = null);

} else {
throw ex43116;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43099 === (14))){
var state_43098__$1 = state_43098;
var statearr_43124_43151 = state_43098__$1;
(statearr_43124_43151[(2)] = null);

(statearr_43124_43151[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43099 === (16))){
var inst_43050 = (state_43098[(7)]);
var inst_43082 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_43083 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_43084 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43082),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43083),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43050),". Forcing a db reload."].join('');
var inst_43085 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43084], 0));
var inst_43086 = fluree.db.session.reload_db_BANG_(session);
var state_43098__$1 = (function (){var statearr_43125 = state_43098;
(statearr_43125[(10)] = inst_43085);

return statearr_43125;
})();
var statearr_43126_43152 = state_43098__$1;
(statearr_43126_43152[(2)] = inst_43086);

(statearr_43126_43152[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43099 === (10))){
var inst_43046 = (state_43098[(9)]);
var inst_43050 = (state_43098[(7)]);
var inst_43049 = (state_43098[(8)]);
var inst_43061 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_43062 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_43063 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43061),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43062),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_43064 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43063], 0));
var inst_43065 = (function (){var current_db_ch = inst_43046;
var current_db = inst_43049;
var current_block = inst_43050;
return (function (f){
if((f instanceof fluree.db.flake.Flake)){
return f;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(f);
}
});
})();
var inst_43066 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_43065,flakes);
var inst_43067 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_43049,block,inst_43066);
var inst_43068 = fluree.db.session.cas_db_BANG_(session,inst_43046,inst_43067);
var state_43098__$1 = (function (){var statearr_43127 = state_43098;
(statearr_43127[(11)] = inst_43064);

return statearr_43127;
})();
if(inst_43068){
var statearr_43128_43153 = state_43098__$1;
(statearr_43128_43153[(1)] = (13));

} else {
var statearr_43129_43154 = state_43098__$1;
(statearr_43129_43154[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43099 === (18))){
var inst_43089 = (state_43098[(2)]);
var state_43098__$1 = state_43098;
var statearr_43130_43155 = state_43098__$1;
(statearr_43130_43155[(2)] = inst_43089);

(statearr_43130_43155[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43099 === (8))){
var inst_43050 = (state_43098[(7)]);
var inst_43058 = ((1) + inst_43050);
var inst_43059 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_43058);
var state_43098__$1 = state_43098;
if(inst_43059){
var statearr_43131_43156 = state_43098__$1;
(statearr_43131_43156[(1)] = (10));

} else {
var statearr_43132_43157 = state_43098__$1;
(statearr_43132_43157[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__15091__auto__ = null;
var fluree$db$session$state_machine__15091__auto____0 = (function (){
var statearr_43133 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43133[(0)] = fluree$db$session$state_machine__15091__auto__);

(statearr_43133[(1)] = (1));

return statearr_43133;
});
var fluree$db$session$state_machine__15091__auto____1 = (function (state_43098){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_43098);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e43134){var ex__15094__auto__ = e43134;
var statearr_43135_43158 = state_43098;
(statearr_43135_43158[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_43098[(4)]))){
var statearr_43136_43159 = state_43098;
(statearr_43136_43159[(1)] = cljs.core.first((state_43098[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__43160 = state_43098;
state_43098 = G__43160;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$session$state_machine__15091__auto__ = function(state_43098){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__15091__auto____1.call(this,state_43098);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__15091__auto____0;
fluree$db$session$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__15091__auto____1;
return fluree$db$session$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_43137 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_43137[(6)] = c__15165__auto__);

return statearr_43137;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new_DASH_index,(function (session,header,block){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_43167){
var state_val_43168 = (state_43167[(1)]);
if((state_val_43168 === (1))){
var inst_43161 = fluree.db.session.clear_db_BANG_(session);
var inst_43162 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_43163 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_43164 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43162),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43163)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_43165 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43164], 0));
var state_43167__$1 = (function (){var statearr_43169 = state_43167;
(statearr_43169[(7)] = inst_43165);

(statearr_43169[(8)] = inst_43161);

return statearr_43169;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_43167__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__15091__auto__ = null;
var fluree$db$session$state_machine__15091__auto____0 = (function (){
var statearr_43170 = [null,null,null,null,null,null,null,null,null];
(statearr_43170[(0)] = fluree$db$session$state_machine__15091__auto__);

(statearr_43170[(1)] = (1));

return statearr_43170;
});
var fluree$db$session$state_machine__15091__auto____1 = (function (state_43167){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_43167);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e43171){var ex__15094__auto__ = e43171;
var statearr_43172_43175 = state_43167;
(statearr_43172_43175[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_43167[(4)]))){
var statearr_43173_43176 = state_43167;
(statearr_43173_43176[(1)] = cljs.core.first((state_43167[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__43177 = state_43167;
state_43167 = G__43177;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$session$state_machine__15091__auto__ = function(state_43167){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__15091__auto____1.call(this,state_43167);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__15091__auto____0;
fluree$db$session$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__15091__auto____1;
return fluree$db$session$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_43174 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_43174[(6)] = c__15165__auto__);

return statearr_43174;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return cljs.core.cst$kw$closed_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__43179 = arguments.length;
switch (G__43179) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (p__43180){
var map__43181 = p__43180;
var map__43181__$1 = cljs.core.__destructure_map(map__43181);
var session = map__43181__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43181__$1,cljs.core.cst$kw$conn);
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43181__$1,cljs.core.cst$kw$update_DASH_chan);
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43181__$1,cljs.core.cst$kw$transact_DASH_chan);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43181__$1,cljs.core.cst$kw$state);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43181__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43181__$1,cljs.core.cst$kw$dbid);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43181__$1,cljs.core.cst$kw$id);
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,cljs.core.cst$kw$closed_QMARK_,true);

var fexpr__43182_43185 = cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__43182_43185.cljs$core$IFn$_invoke$arity$3 ? fexpr__43182_43185.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__43182_43185.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__43183_43186 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session);
(fexpr__43183_43186.cljs$core$IFn$_invoke$arity$0 ? fexpr__43183_43186.cljs$core$IFn$_invoke$arity$0() : fexpr__43183_43186.call(null));
} else {
}

return true;
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5802__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5802__auto__)){
var session = temp__5802__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_43239){
var state_val_43240 = (state_43239[(1)]);
if((state_val_43240 === (7))){
var inst_43235 = (state_43239[(2)]);
var state_43239__$1 = state_43239;
var statearr_43241_43272 = state_43239__$1;
(statearr_43241_43272[(2)] = inst_43235);

(statearr_43241_43272[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43240 === (1))){
var state_43239__$1 = state_43239;
var statearr_43242_43273 = state_43239__$1;
(statearr_43242_43273[(2)] = null);

(statearr_43242_43273[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43240 === (4))){
var inst_43190 = (state_43239[(7)]);
var inst_43189 = (state_43239[(2)]);
var inst_43190__$1 = fluree.db.util.async.throw_err(inst_43189);
var inst_43191 = fluree.db.session.from_cache(network,ledger_id);
var inst_43192 = (inst_43190__$1 == null);
var state_43239__$1 = (function (){var statearr_43243 = state_43239;
(statearr_43243[(7)] = inst_43190__$1);

(statearr_43243[(8)] = inst_43191);

return statearr_43243;
})();
if(cljs.core.truth_(inst_43192)){
var statearr_43244_43274 = state_43239__$1;
(statearr_43244_43274[(1)] = (5));

} else {
var statearr_43245_43275 = state_43239__$1;
(statearr_43245_43275[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43240 === (15))){
var inst_43227 = (state_43239[(2)]);
var state_43239__$1 = (function (){var statearr_43246 = state_43239;
(statearr_43246[(9)] = inst_43227);

return statearr_43246;
})();
var statearr_43247_43276 = state_43239__$1;
(statearr_43247_43276[(2)] = null);

(statearr_43247_43276[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43240 === (13))){
var inst_43231 = (state_43239[(2)]);
var state_43239__$1 = state_43239;
var statearr_43249_43277 = state_43239__$1;
(statearr_43249_43277[(2)] = inst_43231);

(statearr_43249_43277[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43240 === (6))){
var inst_43191 = (state_43239[(8)]);
var inst_43197 = (inst_43191 == null);
var state_43239__$1 = state_43239;
if(cljs.core.truth_(inst_43197)){
var statearr_43250_43278 = state_43239__$1;
(statearr_43250_43278[(1)] = (8));

} else {
var statearr_43251_43279 = state_43239__$1;
(statearr_43251_43279[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43240 === (17))){
var _ = (function (){var statearr_43252 = state_43239;
(statearr_43252[(4)] = cljs.core.rest((state_43239[(4)])));

return statearr_43252;
})();
var state_43239__$1 = state_43239;
var ex43248 = (state_43239__$1[(2)]);
var statearr_43253_43280 = state_43239__$1;
(statearr_43253_43280[(5)] = ex43248);


var statearr_43254_43281 = state_43239__$1;
(statearr_43254_43281[(1)] = (16));

(statearr_43254_43281[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_43240 === (3))){
var inst_43237 = (state_43239[(2)]);
var state_43239__$1 = state_43239;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43239__$1,inst_43237);
} else {
if((state_val_43240 === (12))){
var state_43239__$1 = state_43239;
var statearr_43255_43282 = state_43239__$1;
(statearr_43255_43282[(2)] = null);

(statearr_43255_43282[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43240 === (2))){
var state_43239__$1 = state_43239;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43239__$1,(4),update_chan);
} else {
if((state_val_43240 === (11))){
var state_43239__$1 = state_43239;
var statearr_43256_43283 = state_43239__$1;
(statearr_43256_43283[(2)] = null);

(statearr_43256_43283[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43240 === (9))){
var state_43239__$1 = state_43239;
var statearr_43257_43284 = state_43239__$1;
(statearr_43257_43284[(1)] = (11));



return cljs.core.cst$kw$recur;
} else {
if((state_val_43240 === (5))){
var inst_43194 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_43195 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43194], 0));
var state_43239__$1 = state_43239;
var statearr_43259_43285 = state_43239__$1;
(statearr_43259_43285[(2)] = inst_43195);

(statearr_43259_43285[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43240 === (14))){
var inst_43190 = (state_43239[(7)]);
var inst_43191 = (state_43239[(8)]);
var _ = (function (){var statearr_43260 = state_43239;
(statearr_43260[(4)] = cljs.core.cons((17),(state_43239[(4)])));

return statearr_43260;
})();
var inst_43215 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43190,(0),null);
var inst_43216 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43190,(1),null);
var inst_43217 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_43218 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43190], 0));
var inst_43219 = fluree.db.util.core.trunc(inst_43218,(200));
var inst_43220 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43217,inst_43219], 0));
var inst_43221 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_43191,inst_43215,inst_43216) : fluree.db.session.process_ledger_update.call(null,inst_43191,inst_43215,inst_43216));
var state_43239__$1 = (function (){var statearr_43261 = state_43239;
(statearr_43261[(10)] = inst_43220);

return statearr_43261;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43239__$1,(18),inst_43221);
} else {
if((state_val_43240 === (16))){
var inst_43190 = (state_43239[(7)]);
var inst_43205 = (state_43239[(2)]);
var inst_43206 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43205,"Exception processing ledger updates for message: ",inst_43190], 0));
var state_43239__$1 = state_43239;
var statearr_43262_43286 = state_43239__$1;
(statearr_43262_43286[(2)] = inst_43206);

(statearr_43262_43286[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43240 === (10))){
var inst_43233 = (state_43239[(2)]);
var state_43239__$1 = state_43239;
var statearr_43263_43287 = state_43239__$1;
(statearr_43263_43287[(2)] = inst_43233);

(statearr_43263_43287[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43240 === (18))){
var inst_43223 = (state_43239[(2)]);
var inst_43224 = fluree.db.util.async.throw_err(inst_43223);
var _ = (function (){var statearr_43264 = state_43239;
(statearr_43264[(4)] = cljs.core.rest((state_43239[(4)])));

return statearr_43264;
})();
var state_43239__$1 = state_43239;
var statearr_43265_43288 = state_43239__$1;
(statearr_43265_43288[(2)] = inst_43224);

(statearr_43265_43288[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43240 === (8))){
var inst_43190 = (state_43239[(7)]);
var inst_43199 = cljs.core.first(inst_43190);
var inst_43200 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43199], 0));
var inst_43201 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_43200].join('');
var inst_43202 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43201], 0));
var state_43239__$1 = state_43239;
var statearr_43266_43289 = state_43239__$1;
(statearr_43266_43289[(2)] = inst_43202);

(statearr_43266_43289[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__15091__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__15091__auto____0 = (function (){
var statearr_43267 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_43267[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__15091__auto__);

(statearr_43267[(1)] = (1));

return statearr_43267;
});
var fluree$db$session$process_ledger_updates_$_state_machine__15091__auto____1 = (function (state_43239){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_43239);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e43268){var ex__15094__auto__ = e43268;
var statearr_43269_43290 = state_43239;
(statearr_43269_43290[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_43239[(4)]))){
var statearr_43270_43291 = state_43239;
(statearr_43270_43291[(1)] = cljs.core.first((state_43239[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__43292 = state_43239;
state_43239 = G__43292;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__15091__auto__ = function(state_43239){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__15091__auto____1.call(this,state_43239);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__15091__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__15091__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_43271 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_43271[(6)] = c__15165__auto__);

return statearr_43271;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Creates a connection without first checking if one already exists. Only useful
 *   if reloading and replacing an existing session.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__43293){
var map__43294 = p__43293;
var map__43294__$1 = cljs.core.__destructure_map(map__43294);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43294__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43294__$1,cljs.core.cst$kw$conn);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43294__$1,cljs.core.cst$kw$dbid);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43294__$1,cljs.core.cst$kw$db);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43294__$1,cljs.core.cst$kw$transactor_QMARK_);
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43294__$1,cljs.core.cst$kw$db_DASH_name);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43294__$1,cljs.core.cst$kw$state);
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43294__$1,cljs.core.cst$kw$close);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43294__$1,cljs.core.cst$kw$id);
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cur_db = (cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$schema_DASH_cache,schema_cache):null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$req_SLASH_sync,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$req_SLASH_count,(0),cljs.core.cst$kw$req_SLASH_last,null,cljs.core.cst$kw$db_SLASH_current,cur_db,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.cst$kw$closed_QMARK_,false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$dbid,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$id,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$network,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$conn],[dbid,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0(),db_name,state__$1,close,id,schema_cache,(cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null),network,null,conn]));
var current_db_fn = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.session.current_db,session);
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,cljs.core.cst$kw$blank_DASH_db,blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__43298 = block_result;
var map__43298__$1 = cljs.core.__destructure_map(map__43298);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43298__$1,cljs.core.cst$kw$block);
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43298__$1,cljs.core.cst$kw$hash);
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43298__$1,cljs.core.cst$kw$instant);
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43298__$1,cljs.core.cst$kw$txns);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43298__$1,cljs.core.cst$kw$flakes);
var tx_result = (function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error,cljs.core.cst$kw$block,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__43299 = tx_result;
var map__43299__$1 = cljs.core.__destructure_map(map__43299);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43299__$1,cljs.core.cst$kw$t);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43299__$1,cljs.core.cst$kw$status);
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__43295_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__43295_SHARP_.t);
}):(function (p1__43296_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__43296_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$flakes,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__43297_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__43297_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__43297_SHARP_,(2));
} else {
return null;
}
}),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(response));
var vec__43300 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43300,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43300,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43300,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43300,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__5045__auto__ = message;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response),cljs.core.cst$kw$error,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),cljs.core.cst$kw$meta,response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));

var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$id,id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,cljs.core.cst$kw$new_QMARK_,true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__43304 = arguments.length;
switch (G__43304) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__43305){
var map__43306 = p__43305;
var map__43306__$1 = cljs.core.__destructure_map(map__43306);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43306__$1,cljs.core.cst$kw$state);
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43306__$1,cljs.core.cst$kw$connect_QMARK_);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43306__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43306__$1,cljs.core.cst$kw$jwt);
var vec__43307 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43307,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43307,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43307,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt], null));
var or__5045__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,ledger_id,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt,cljs.core.cst$kw$conn,conn,cljs.core.cst$kw$state,(function (){var or__5045__auto____$1 = state;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.cst$kw$transactor_QMARK_,transactor_QMARK_], null));
var new_QMARK_ = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__43311_43431 = network;
var G__43312_43432 = ledger_id;
var G__43313_43433 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session);
var G__43314_43434 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$block,event_type)){
var temp__5804__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),cljs.core.cst$kw$db_SLASH_pending_DASH_tx));
if(cljs.core.truth_(temp__5804__auto__)){
var tx_callbacks = temp__5804__auto__;
var tids = cljs.core.keys(cljs.core.cst$kw$txns.cljs$core$IFn$_invoke$arity$1(event_data));
var seq__43315 = cljs.core.seq(tids);
var chunk__43316 = null;
var count__43317 = (0);
var i__43318 = (0);
while(true){
if((i__43318 < count__43317)){
var tid = chunk__43316.cljs$core$IIndexed$_nth$arity$2(null,i__43318);
var temp__5804__auto___43436__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5804__auto___43436__$1)){
var keyed_callbacks_43437 = temp__5804__auto___43436__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_43438 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__43359_43439 = cljs.core.seq(keyed_callbacks_43437);
var chunk__43360_43440 = null;
var count__43361_43441 = (0);
var i__43362_43442 = (0);
while(true){
if((i__43362_43442 < count__43361_43441)){
var vec__43371_43443 = chunk__43360_43440.cljs$core$IIndexed$_nth$arity$2(null,i__43362_43442);
var k_43444 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43371_43443,(0),null);
var f_43445 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43371_43443,(1),null);
try{(f_43445.cljs$core$IFn$_invoke$arity$1 ? f_43445.cljs$core$IFn$_invoke$arity$1(tx_response_43438) : f_43445.call(null,tx_response_43438));
}catch (e43374){var e_43446 = e43374;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_43446,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__43447 = seq__43359_43439;
var G__43448 = chunk__43360_43440;
var G__43449 = count__43361_43441;
var G__43450 = (i__43362_43442 + (1));
seq__43359_43439 = G__43447;
chunk__43360_43440 = G__43448;
count__43361_43441 = G__43449;
i__43362_43442 = G__43450;
continue;
} else {
var temp__5804__auto___43451__$2 = cljs.core.seq(seq__43359_43439);
if(temp__5804__auto___43451__$2){
var seq__43359_43452__$1 = temp__5804__auto___43451__$2;
if(cljs.core.chunked_seq_QMARK_(seq__43359_43452__$1)){
var c__5567__auto___43453 = cljs.core.chunk_first(seq__43359_43452__$1);
var G__43454 = cljs.core.chunk_rest(seq__43359_43452__$1);
var G__43455 = c__5567__auto___43453;
var G__43456 = cljs.core.count(c__5567__auto___43453);
var G__43457 = (0);
seq__43359_43439 = G__43454;
chunk__43360_43440 = G__43455;
count__43361_43441 = G__43456;
i__43362_43442 = G__43457;
continue;
} else {
var vec__43375_43458 = cljs.core.first(seq__43359_43452__$1);
var k_43459 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43375_43458,(0),null);
var f_43460 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43375_43458,(1),null);
try{(f_43460.cljs$core$IFn$_invoke$arity$1 ? f_43460.cljs$core$IFn$_invoke$arity$1(tx_response_43438) : f_43460.call(null,tx_response_43438));
}catch (e43378){var e_43461 = e43378;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_43461,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__43462 = cljs.core.next(seq__43359_43452__$1);
var G__43463 = null;
var G__43464 = (0);
var G__43465 = (0);
seq__43359_43439 = G__43462;
chunk__43360_43440 = G__43463;
count__43361_43441 = G__43464;
i__43362_43442 = G__43465;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__43466 = seq__43315;
var G__43467 = chunk__43316;
var G__43468 = count__43317;
var G__43469 = (i__43318 + (1));
seq__43315 = G__43466;
chunk__43316 = G__43467;
count__43317 = G__43468;
i__43318 = G__43469;
continue;
} else {
var temp__5804__auto____$1 = cljs.core.seq(seq__43315);
if(temp__5804__auto____$1){
var seq__43315__$1 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__43315__$1)){
var c__5567__auto__ = cljs.core.chunk_first(seq__43315__$1);
var G__43470 = cljs.core.chunk_rest(seq__43315__$1);
var G__43471 = c__5567__auto__;
var G__43472 = cljs.core.count(c__5567__auto__);
var G__43473 = (0);
seq__43315 = G__43470;
chunk__43316 = G__43471;
count__43317 = G__43472;
i__43318 = G__43473;
continue;
} else {
var tid = cljs.core.first(seq__43315__$1);
var temp__5804__auto___43474__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5804__auto___43474__$2)){
var keyed_callbacks_43475 = temp__5804__auto___43474__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_43476 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__43379_43477 = cljs.core.seq(keyed_callbacks_43475);
var chunk__43380_43478 = null;
var count__43381_43479 = (0);
var i__43382_43480 = (0);
while(true){
if((i__43382_43480 < count__43381_43479)){
var vec__43391_43481 = chunk__43380_43478.cljs$core$IIndexed$_nth$arity$2(null,i__43382_43480);
var k_43482 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43391_43481,(0),null);
var f_43483 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43391_43481,(1),null);
try{(f_43483.cljs$core$IFn$_invoke$arity$1 ? f_43483.cljs$core$IFn$_invoke$arity$1(tx_response_43476) : f_43483.call(null,tx_response_43476));
}catch (e43394){var e_43484 = e43394;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_43484,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__43485 = seq__43379_43477;
var G__43486 = chunk__43380_43478;
var G__43487 = count__43381_43479;
var G__43488 = (i__43382_43480 + (1));
seq__43379_43477 = G__43485;
chunk__43380_43478 = G__43486;
count__43381_43479 = G__43487;
i__43382_43480 = G__43488;
continue;
} else {
var temp__5804__auto___43489__$3 = cljs.core.seq(seq__43379_43477);
if(temp__5804__auto___43489__$3){
var seq__43379_43490__$1 = temp__5804__auto___43489__$3;
if(cljs.core.chunked_seq_QMARK_(seq__43379_43490__$1)){
var c__5567__auto___43491 = cljs.core.chunk_first(seq__43379_43490__$1);
var G__43492 = cljs.core.chunk_rest(seq__43379_43490__$1);
var G__43493 = c__5567__auto___43491;
var G__43494 = cljs.core.count(c__5567__auto___43491);
var G__43495 = (0);
seq__43379_43477 = G__43492;
chunk__43380_43478 = G__43493;
count__43381_43479 = G__43494;
i__43382_43480 = G__43495;
continue;
} else {
var vec__43395_43496 = cljs.core.first(seq__43379_43490__$1);
var k_43497 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43395_43496,(0),null);
var f_43498 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43395_43496,(1),null);
try{(f_43498.cljs$core$IFn$_invoke$arity$1 ? f_43498.cljs$core$IFn$_invoke$arity$1(tx_response_43476) : f_43498.call(null,tx_response_43476));
}catch (e43398){var e_43499 = e43398;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_43499,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__43500 = cljs.core.next(seq__43379_43490__$1);
var G__43501 = null;
var G__43502 = (0);
var G__43503 = (0);
seq__43379_43477 = G__43500;
chunk__43380_43478 = G__43501;
count__43381_43479 = G__43502;
i__43382_43480 = G__43503;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__43504 = cljs.core.next(seq__43315__$1);
var G__43505 = null;
var G__43506 = (0);
var G__43507 = (0);
seq__43315 = G__43504;
chunk__43316 = G__43505;
count__43317 = G__43506;
i__43318 = G__43507;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__43310_43435 = cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__43310_43435.cljs$core$IFn$_invoke$arity$4 ? fexpr__43310_43435.cljs$core$IFn$_invoke$arity$4(G__43311_43431,G__43312_43432,G__43313_43433,G__43314_43434) : fexpr__43310_43435.call(null,G__43311_43431,G__43312_43432,G__43313_43433,G__43314_43434));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_43508 = cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(conn);
var c__15165__auto___43509 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_43415){
var state_val_43416 = (state_43415[(1)]);
if((state_val_43416 === (1))){
var state_43415__$1 = state_43415;
var statearr_43417_43510 = state_43415__$1;
(statearr_43417_43510[(2)] = null);

(statearr_43417_43510[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43416 === (2))){
var inst_43400 = cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(session);
var state_43415__$1 = state_43415;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43415__$1,(4),inst_43400);
} else {
if((state_val_43416 === (3))){
var inst_43413 = (state_43415[(2)]);
var state_43415__$1 = state_43415;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43415__$1,inst_43413);
} else {
if((state_val_43416 === (4))){
var inst_43402 = (state_43415[(7)]);
var inst_43402__$1 = (state_43415[(2)]);
var inst_43403 = (inst_43402__$1 == null);
var state_43415__$1 = (function (){var statearr_43418 = state_43415;
(statearr_43418[(7)] = inst_43402__$1);

return statearr_43418;
})();
if(cljs.core.truth_(inst_43403)){
var statearr_43419_43511 = state_43415__$1;
(statearr_43419_43511[(1)] = (5));

} else {
var statearr_43420_43512 = state_43415__$1;
(statearr_43420_43512[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43416 === (5))){
var inst_43405 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_43406 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43405], 0));
var state_43415__$1 = state_43415;
var statearr_43421_43513 = state_43415__$1;
(statearr_43421_43513[(2)] = inst_43406);

(statearr_43421_43513[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43416 === (6))){
var inst_43402 = (state_43415[(7)]);
var inst_43408 = (transact_handler_43508.cljs$core$IFn$_invoke$arity$2 ? transact_handler_43508.cljs$core$IFn$_invoke$arity$2(conn,inst_43402) : transact_handler_43508.call(null,conn,inst_43402));
var state_43415__$1 = (function (){var statearr_43422 = state_43415;
(statearr_43422[(8)] = inst_43408);

return statearr_43422;
})();
var statearr_43423_43514 = state_43415__$1;
(statearr_43423_43514[(2)] = null);

(statearr_43423_43514[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43416 === (7))){
var inst_43411 = (state_43415[(2)]);
var state_43415__$1 = state_43415;
var statearr_43424_43515 = state_43415__$1;
(statearr_43424_43515[(2)] = inst_43411);

(statearr_43424_43515[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__15091__auto__ = null;
var fluree$db$session$state_machine__15091__auto____0 = (function (){
var statearr_43425 = [null,null,null,null,null,null,null,null,null];
(statearr_43425[(0)] = fluree$db$session$state_machine__15091__auto__);

(statearr_43425[(1)] = (1));

return statearr_43425;
});
var fluree$db$session$state_machine__15091__auto____1 = (function (state_43415){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_43415);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e43426){var ex__15094__auto__ = e43426;
var statearr_43427_43516 = state_43415;
(statearr_43427_43516[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_43415[(4)]))){
var statearr_43428_43517 = state_43415;
(statearr_43428_43517[(1)] = cljs.core.first((state_43415[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__43518 = state_43415;
state_43415 = G__43518;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$session$state_machine__15091__auto__ = function(state_43415){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__15091__auto____1.call(this,state_43415);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__15091__auto____0;
fluree$db$session$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__15091__auto____1;
return fluree$db$session$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_43429 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_43429[(6)] = c__15165__auto___43509);

return statearr_43429;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$connect_QMARK_,false], null));
return cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__43521 = arguments.length;
switch (G__43521) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__43522 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__43519_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__43519_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$id], null)));
}),G__43522);
} else {
return G__43522;
}
})();
var seq__43523 = cljs.core.seq(sessions);
var chunk__43524 = null;
var count__43525 = (0);
var i__43526 = (0);
while(true){
if((i__43526 < count__43525)){
var session = chunk__43524.cljs$core$IIndexed$_nth$arity$2(null,i__43526);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__43528 = seq__43523;
var G__43529 = chunk__43524;
var G__43530 = count__43525;
var G__43531 = (i__43526 + (1));
seq__43523 = G__43528;
chunk__43524 = G__43529;
count__43525 = G__43530;
i__43526 = G__43531;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__43523);
if(temp__5804__auto__){
var seq__43523__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__43523__$1)){
var c__5567__auto__ = cljs.core.chunk_first(seq__43523__$1);
var G__43532 = cljs.core.chunk_rest(seq__43523__$1);
var G__43533 = c__5567__auto__;
var G__43534 = cljs.core.count(c__5567__auto__);
var G__43535 = (0);
seq__43523 = G__43532;
chunk__43524 = G__43533;
count__43525 = G__43534;
i__43526 = G__43535;
continue;
} else {
var session = cljs.core.first(seq__43523__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__43536 = cljs.core.next(seq__43523__$1);
var G__43537 = null;
var G__43538 = (0);
var G__43539 = (0);
seq__43523 = G__43536;
chunk__43524 = G__43537;
count__43525 = G__43538;
i__43526 = G__43539;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_request], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
