// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = cljs.core.cst$kw$storage_DASH_exists.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_31701){
var state_val_31702 = (state_31701[(1)]);
if((state_val_31702 === (7))){
var inst_31690 = (state_31701[(7)]);
var inst_31692 = fluree.db.storage.core.serde(conn);
var inst_31693 = fluree.db.serde.protocol._deserialize_block(inst_31692,inst_31690);
var state_31701__$1 = state_31701;
var statearr_31703_31722 = state_31701__$1;
(statearr_31703_31722[(2)] = inst_31693);

(statearr_31703_31722[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31702 === (1))){
var state_31701__$1 = state_31701;
var statearr_31704_31723 = state_31701__$1;
(statearr_31704_31723[(2)] = null);

(statearr_31704_31723[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31702 === (4))){
var inst_31680 = (state_31701[(2)]);
var state_31701__$1 = state_31701;
var statearr_31705_31724 = state_31701__$1;
(statearr_31705_31724[(2)] = inst_31680);

(statearr_31705_31724[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31702 === (6))){
var inst_31690 = (state_31701[(7)]);
var inst_31689 = (state_31701[(2)]);
var inst_31690__$1 = fluree.db.util.async.throw_err(inst_31689);
var state_31701__$1 = (function (){var statearr_31706 = state_31701;
(statearr_31706[(7)] = inst_31690__$1);

return statearr_31706;
})();
if(cljs.core.truth_(inst_31690__$1)){
var statearr_31707_31725 = state_31701__$1;
(statearr_31707_31725[(1)] = (7));

} else {
var statearr_31708_31726 = state_31701__$1;
(statearr_31708_31726[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31702 === (3))){
var inst_31699 = (state_31701[(2)]);
var state_31701__$1 = state_31701;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31701__$1,inst_31699);
} else {
if((state_val_31702 === (2))){
var _ = (function (){var statearr_31710 = state_31701;
(statearr_31710[(4)] = cljs.core.cons((5),(state_31701[(4)])));

return statearr_31710;
})();
var inst_31686 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_31687 = fluree.db.storage.core.storage_read(conn,inst_31686);
var state_31701__$1 = state_31701;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31701__$1,(6),inst_31687);
} else {
if((state_val_31702 === (9))){
var inst_31696 = (state_31701[(2)]);
var _ = (function (){var statearr_31711 = state_31701;
(statearr_31711[(4)] = cljs.core.rest((state_31701[(4)])));

return statearr_31711;
})();
var state_31701__$1 = state_31701;
var statearr_31712_31727 = state_31701__$1;
(statearr_31712_31727[(2)] = inst_31696);

(statearr_31712_31727[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31702 === (5))){
var _ = (function (){var statearr_31713 = state_31701;
(statearr_31713[(4)] = cljs.core.rest((state_31701[(4)])));

return statearr_31713;
})();
var state_31701__$1 = state_31701;
var ex31709 = (state_31701__$1[(2)]);
var statearr_31714_31728 = state_31701__$1;
(statearr_31714_31728[(5)] = ex31709);


if((ex31709 instanceof Error)){
var statearr_31715_31729 = state_31701__$1;
(statearr_31715_31729[(1)] = (4));

(statearr_31715_31729[(5)] = null);

} else {
throw ex31709;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31702 === (8))){
var state_31701__$1 = state_31701;
var statearr_31716_31730 = state_31701__$1;
(statearr_31716_31730[(2)] = null);

(statearr_31716_31730[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__15091__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__15091__auto____0 = (function (){
var statearr_31717 = [null,null,null,null,null,null,null,null];
(statearr_31717[(0)] = fluree$db$storage$core$read_block_$_state_machine__15091__auto__);

(statearr_31717[(1)] = (1));

return statearr_31717;
});
var fluree$db$storage$core$read_block_$_state_machine__15091__auto____1 = (function (state_31701){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_31701);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e31718){var ex__15094__auto__ = e31718;
var statearr_31719_31731 = state_31701;
(statearr_31719_31731[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_31701[(4)]))){
var statearr_31720_31732 = state_31701;
(statearr_31720_31732[(1)] = cljs.core.first((state_31701[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__31733 = state_31701;
state_31701 = G__31733;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__15091__auto__ = function(state_31701){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__15091__auto____1.call(this,state_31701);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__15091__auto____0;
fluree$db$storage$core$read_block_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__15091__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_31721 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_31721[(6)] = c__15165__auto__);

return statearr_31721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_31756){
var state_val_31757 = (state_31756[(1)]);
if((state_val_31757 === (7))){
var inst_31745 = (state_31756[(7)]);
var inst_31747 = fluree.db.storage.core.serde(conn);
var inst_31748 = fluree.db.serde.protocol._deserialize_block(inst_31747,inst_31745);
var state_31756__$1 = state_31756;
var statearr_31758_31777 = state_31756__$1;
(statearr_31758_31777[(2)] = inst_31748);

(statearr_31758_31777[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31757 === (1))){
var state_31756__$1 = state_31756;
var statearr_31759_31778 = state_31756__$1;
(statearr_31759_31778[(2)] = null);

(statearr_31759_31778[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31757 === (4))){
var inst_31734 = (state_31756[(2)]);
var state_31756__$1 = state_31756;
var statearr_31760_31779 = state_31756__$1;
(statearr_31760_31779[(2)] = inst_31734);

(statearr_31760_31779[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31757 === (6))){
var inst_31745 = (state_31756[(7)]);
var inst_31744 = (state_31756[(2)]);
var inst_31745__$1 = fluree.db.util.async.throw_err(inst_31744);
var state_31756__$1 = (function (){var statearr_31761 = state_31756;
(statearr_31761[(7)] = inst_31745__$1);

return statearr_31761;
})();
if(cljs.core.truth_(inst_31745__$1)){
var statearr_31762_31780 = state_31756__$1;
(statearr_31762_31780[(1)] = (7));

} else {
var statearr_31763_31781 = state_31756__$1;
(statearr_31763_31781[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31757 === (3))){
var inst_31754 = (state_31756[(2)]);
var state_31756__$1 = state_31756;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31756__$1,inst_31754);
} else {
if((state_val_31757 === (2))){
var _ = (function (){var statearr_31765 = state_31756;
(statearr_31765[(4)] = cljs.core.cons((5),(state_31756[(4)])));

return statearr_31765;
})();
var inst_31740 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_31741 = [inst_31740,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_31742 = fluree.db.storage.core.storage_read(conn,inst_31741);
var state_31756__$1 = state_31756;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31756__$1,(6),inst_31742);
} else {
if((state_val_31757 === (9))){
var inst_31751 = (state_31756[(2)]);
var _ = (function (){var statearr_31766 = state_31756;
(statearr_31766[(4)] = cljs.core.rest((state_31756[(4)])));

return statearr_31766;
})();
var state_31756__$1 = state_31756;
var statearr_31767_31782 = state_31756__$1;
(statearr_31767_31782[(2)] = inst_31751);

(statearr_31767_31782[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31757 === (5))){
var _ = (function (){var statearr_31768 = state_31756;
(statearr_31768[(4)] = cljs.core.rest((state_31756[(4)])));

return statearr_31768;
})();
var state_31756__$1 = state_31756;
var ex31764 = (state_31756__$1[(2)]);
var statearr_31769_31783 = state_31756__$1;
(statearr_31769_31783[(5)] = ex31764);


if((ex31764 instanceof Error)){
var statearr_31770_31784 = state_31756__$1;
(statearr_31770_31784[(1)] = (4));

(statearr_31770_31784[(5)] = null);

} else {
throw ex31764;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31757 === (8))){
var state_31756__$1 = state_31756;
var statearr_31771_31785 = state_31756__$1;
(statearr_31771_31785[(2)] = null);

(statearr_31771_31785[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__15091__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__15091__auto____0 = (function (){
var statearr_31772 = [null,null,null,null,null,null,null,null];
(statearr_31772[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__15091__auto__);

(statearr_31772[(1)] = (1));

return statearr_31772;
});
var fluree$db$storage$core$read_block_version_$_state_machine__15091__auto____1 = (function (state_31756){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_31756);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e31773){var ex__15094__auto__ = e31773;
var statearr_31774_31786 = state_31756;
(statearr_31774_31786[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_31756[(4)]))){
var statearr_31775_31787 = state_31756;
(statearr_31775_31787[(1)] = cljs.core.first((state_31756[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__31788 = state_31756;
state_31756 = G__31788;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__15091__auto__ = function(state_31756){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__15091__auto____1.call(this,state_31756);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__15091__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__15091__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_31776 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_31776[(6)] = c__15165__auto__);

return statearr_31776;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_31812){
var state_val_31813 = (state_31812[(1)]);
if((state_val_31813 === (1))){
var state_31812__$1 = state_31812;
var statearr_31814_31828 = state_31812__$1;
(statearr_31814_31828[(2)] = null);

(statearr_31814_31828[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31813 === (2))){
var _ = (function (){var statearr_31815 = state_31812;
(statearr_31815[(4)] = cljs.core.cons((5),(state_31812[(4)])));

return statearr_31815;
})();
var inst_31795 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31796 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_31797 = (new cljs.core.PersistentVector(null,3,(5),inst_31795,inst_31796,null));
var inst_31798 = cljs.core.select_keys(block_data,inst_31797);
var inst_31799 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_31798);
var inst_31800 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_31799);
var inst_31801 = [inst_31800,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_31802 = fluree.db.storage.core.serde(conn);
var inst_31803 = fluree.db.serde.protocol._serialize_block(inst_31802,inst_31798);
var inst_31804 = fluree.db.storage.core.storage_write(conn,inst_31801,inst_31803);
var state_31812__$1 = state_31812;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31812__$1,(6),inst_31804);
} else {
if((state_val_31813 === (3))){
var inst_31810 = (state_31812[(2)]);
var state_31812__$1 = state_31812;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31812__$1,inst_31810);
} else {
if((state_val_31813 === (4))){
var inst_31789 = (state_31812[(2)]);
var state_31812__$1 = state_31812;
var statearr_31817_31829 = state_31812__$1;
(statearr_31817_31829[(2)] = inst_31789);

(statearr_31817_31829[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31813 === (5))){
var _ = (function (){var statearr_31818 = state_31812;
(statearr_31818[(4)] = cljs.core.rest((state_31812[(4)])));

return statearr_31818;
})();
var state_31812__$1 = state_31812;
var ex31816 = (state_31812__$1[(2)]);
var statearr_31819_31830 = state_31812__$1;
(statearr_31819_31830[(5)] = ex31816);


if((ex31816 instanceof Error)){
var statearr_31820_31831 = state_31812__$1;
(statearr_31820_31831[(1)] = (4));

(statearr_31820_31831[(5)] = null);

} else {
throw ex31816;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31813 === (6))){
var inst_31806 = (state_31812[(2)]);
var inst_31807 = fluree.db.util.async.throw_err(inst_31806);
var _ = (function (){var statearr_31821 = state_31812;
(statearr_31821[(4)] = cljs.core.rest((state_31812[(4)])));

return statearr_31821;
})();
var state_31812__$1 = state_31812;
var statearr_31822_31832 = state_31812__$1;
(statearr_31822_31832[(2)] = inst_31807);

(statearr_31822_31832[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__15091__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__15091__auto____0 = (function (){
var statearr_31823 = [null,null,null,null,null,null,null];
(statearr_31823[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__15091__auto__);

(statearr_31823[(1)] = (1));

return statearr_31823;
});
var fluree$db$storage$core$write_block_version_$_state_machine__15091__auto____1 = (function (state_31812){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_31812);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e31824){var ex__15094__auto__ = e31824;
var statearr_31825_31833 = state_31812;
(statearr_31825_31833[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_31812[(4)]))){
var statearr_31826_31834 = state_31812;
(statearr_31826_31834[(1)] = cljs.core.first((state_31812[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__31835 = state_31812;
state_31812 = G__31835;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__15091__auto__ = function(state_31812){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__15091__auto____1.call(this,state_31812);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__15091__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__15091__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_31827 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_31827[(6)] = c__15165__auto__);

return statearr_31827;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_31858){
var state_val_31859 = (state_31858[(1)]);
if((state_val_31859 === (1))){
var state_31858__$1 = state_31858;
var statearr_31860_31874 = state_31858__$1;
(statearr_31860_31874[(2)] = null);

(statearr_31860_31874[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31859 === (2))){
var _ = (function (){var statearr_31861 = state_31858;
(statearr_31861[(4)] = cljs.core.cons((5),(state_31858[(4)])));

return statearr_31861;
})();
var inst_31842 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31843 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_31844 = (new cljs.core.PersistentVector(null,3,(5),inst_31842,inst_31843,null));
var inst_31845 = cljs.core.select_keys(block_data,inst_31844);
var inst_31846 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_31845);
var inst_31847 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_31846);
var inst_31848 = fluree.db.storage.core.serde(conn);
var inst_31849 = fluree.db.serde.protocol._serialize_block(inst_31848,inst_31845);
var inst_31850 = fluree.db.storage.core.storage_write(conn,inst_31847,inst_31849);
var state_31858__$1 = state_31858;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31858__$1,(6),inst_31850);
} else {
if((state_val_31859 === (3))){
var inst_31856 = (state_31858[(2)]);
var state_31858__$1 = state_31858;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31858__$1,inst_31856);
} else {
if((state_val_31859 === (4))){
var inst_31836 = (state_31858[(2)]);
var state_31858__$1 = state_31858;
var statearr_31863_31875 = state_31858__$1;
(statearr_31863_31875[(2)] = inst_31836);

(statearr_31863_31875[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31859 === (5))){
var _ = (function (){var statearr_31864 = state_31858;
(statearr_31864[(4)] = cljs.core.rest((state_31858[(4)])));

return statearr_31864;
})();
var state_31858__$1 = state_31858;
var ex31862 = (state_31858__$1[(2)]);
var statearr_31865_31876 = state_31858__$1;
(statearr_31865_31876[(5)] = ex31862);


if((ex31862 instanceof Error)){
var statearr_31866_31877 = state_31858__$1;
(statearr_31866_31877[(1)] = (4));

(statearr_31866_31877[(5)] = null);

} else {
throw ex31862;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31859 === (6))){
var inst_31852 = (state_31858[(2)]);
var inst_31853 = fluree.db.util.async.throw_err(inst_31852);
var _ = (function (){var statearr_31867 = state_31858;
(statearr_31867[(4)] = cljs.core.rest((state_31858[(4)])));

return statearr_31867;
})();
var state_31858__$1 = state_31858;
var statearr_31868_31878 = state_31858__$1;
(statearr_31868_31878[(2)] = inst_31853);

(statearr_31868_31878[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__15091__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__15091__auto____0 = (function (){
var statearr_31869 = [null,null,null,null,null,null,null];
(statearr_31869[(0)] = fluree$db$storage$core$write_block_$_state_machine__15091__auto__);

(statearr_31869[(1)] = (1));

return statearr_31869;
});
var fluree$db$storage$core$write_block_$_state_machine__15091__auto____1 = (function (state_31858){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_31858);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e31870){var ex__15094__auto__ = e31870;
var statearr_31871_31879 = state_31858;
(statearr_31871_31879[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_31858[(4)]))){
var statearr_31872_31880 = state_31858;
(statearr_31872_31880[(1)] = cljs.core.first((state_31858[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__31881 = state_31858;
state_31858 = G__31881;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__15091__auto__ = function(state_31858){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__15091__auto____1.call(this,state_31858);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__15091__auto____0;
fluree$db$storage$core$write_block_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__15091__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_31873 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_31873[(6)] = c__15165__auto__);

return statearr_31873;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_31901){
var state_val_31902 = (state_31901[(1)]);
if((state_val_31902 === (1))){
var state_31901__$1 = state_31901;
var statearr_31903_31917 = state_31901__$1;
(statearr_31903_31917[(2)] = null);

(statearr_31903_31917[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31902 === (2))){
var _ = (function (){var statearr_31904 = state_31901;
(statearr_31904[(4)] = cljs.core.cons((5),(state_31901[(4)])));

return statearr_31904;
})();
var inst_31888 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_31889 = [history,next_his_key];
var inst_31890 = cljs.core.PersistentHashMap.fromArrays(inst_31888,inst_31889);
var inst_31891 = fluree.db.storage.core.serde(conn);
var inst_31892 = fluree.db.serde.protocol._serialize_leaf(inst_31891,inst_31890);
var inst_31893 = fluree.db.storage.core.storage_write(conn,his_key,inst_31892);
var state_31901__$1 = state_31901;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31901__$1,(6),inst_31893);
} else {
if((state_val_31902 === (3))){
var inst_31899 = (state_31901[(2)]);
var state_31901__$1 = state_31901;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31901__$1,inst_31899);
} else {
if((state_val_31902 === (4))){
var inst_31882 = (state_31901[(2)]);
var state_31901__$1 = state_31901;
var statearr_31906_31918 = state_31901__$1;
(statearr_31906_31918[(2)] = inst_31882);

(statearr_31906_31918[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31902 === (5))){
var _ = (function (){var statearr_31907 = state_31901;
(statearr_31907[(4)] = cljs.core.rest((state_31901[(4)])));

return statearr_31907;
})();
var state_31901__$1 = state_31901;
var ex31905 = (state_31901__$1[(2)]);
var statearr_31908_31919 = state_31901__$1;
(statearr_31908_31919[(5)] = ex31905);


if((ex31905 instanceof Error)){
var statearr_31909_31920 = state_31901__$1;
(statearr_31909_31920[(1)] = (4));

(statearr_31909_31920[(5)] = null);

} else {
throw ex31905;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31902 === (6))){
var inst_31895 = (state_31901[(2)]);
var inst_31896 = fluree.db.util.async.throw_err(inst_31895);
var _ = (function (){var statearr_31910 = state_31901;
(statearr_31910[(4)] = cljs.core.rest((state_31901[(4)])));

return statearr_31910;
})();
var state_31901__$1 = state_31901;
var statearr_31911_31921 = state_31901__$1;
(statearr_31911_31921[(2)] = inst_31896);

(statearr_31911_31921[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__15091__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__15091__auto____0 = (function (){
var statearr_31912 = [null,null,null,null,null,null,null];
(statearr_31912[(0)] = fluree$db$storage$core$write_history_$_state_machine__15091__auto__);

(statearr_31912[(1)] = (1));

return statearr_31912;
});
var fluree$db$storage$core$write_history_$_state_machine__15091__auto____1 = (function (state_31901){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_31901);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e31913){var ex__15094__auto__ = e31913;
var statearr_31914_31922 = state_31901;
(statearr_31914_31922[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_31901[(4)]))){
var statearr_31915_31923 = state_31901;
(statearr_31915_31923[(1)] = cljs.core.first((state_31901[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__31924 = state_31901;
state_31901 = G__31924;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__15091__auto__ = function(state_31901){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__15091__auto____1.call(this,state_31901);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__15091__auto____0;
fluree$db$storage$core$write_history_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__15091__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_31916 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_31916[(6)] = c__15165__auto__);

return statearr_31916;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_31950){
var state_val_31951 = (state_31950[(1)]);
if((state_val_31951 === (1))){
var state_31950__$1 = state_31950;
var statearr_31952_31969 = state_31950__$1;
(statearr_31952_31969[(2)] = null);

(statearr_31952_31969[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31951 === (2))){
var inst_31931 = (state_31950[(7)]);
var _ = (function (){var statearr_31953 = state_31950;
(statearr_31953[(4)] = cljs.core.cons((5),(state_31950[(4)])));

return statearr_31953;
})();
var inst_31931__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_31932 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31931__$1),"-his"].join('');
var inst_31933 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_31934 = [flakes,inst_31932];
var inst_31935 = cljs.core.PersistentHashMap.fromArrays(inst_31933,inst_31934);
var inst_31936 = fluree.db.storage.core.serde(conn);
var inst_31937 = fluree.db.serde.protocol._serialize_leaf(inst_31936,inst_31935);
var inst_31938 = fluree.db.storage.core.write_history(conn,history,inst_31932,null);
var inst_31939 = fluree.db.storage.core.storage_write(conn,inst_31931__$1,inst_31937);
var state_31950__$1 = (function (){var statearr_31954 = state_31950;
(statearr_31954[(8)] = inst_31939);

(statearr_31954[(7)] = inst_31931__$1);

return statearr_31954;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31950__$1,(6),inst_31938);
} else {
if((state_val_31951 === (3))){
var inst_31948 = (state_31950[(2)]);
var state_31950__$1 = state_31950;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31950__$1,inst_31948);
} else {
if((state_val_31951 === (4))){
var inst_31925 = (state_31950[(2)]);
var state_31950__$1 = state_31950;
var statearr_31956_31970 = state_31950__$1;
(statearr_31956_31970[(2)] = inst_31925);

(statearr_31956_31970[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31951 === (5))){
var _ = (function (){var statearr_31957 = state_31950;
(statearr_31957[(4)] = cljs.core.rest((state_31950[(4)])));

return statearr_31957;
})();
var state_31950__$1 = state_31950;
var ex31955 = (state_31950__$1[(2)]);
var statearr_31958_31971 = state_31950__$1;
(statearr_31958_31971[(5)] = ex31955);


if((ex31955 instanceof Error)){
var statearr_31959_31972 = state_31950__$1;
(statearr_31959_31972[(1)] = (4));

(statearr_31959_31972[(5)] = null);

} else {
throw ex31955;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31951 === (6))){
var inst_31939 = (state_31950[(8)]);
var inst_31941 = (state_31950[(2)]);
var inst_31942 = fluree.db.util.async.throw_err(inst_31941);
var state_31950__$1 = (function (){var statearr_31960 = state_31950;
(statearr_31960[(9)] = inst_31942);

return statearr_31960;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31950__$1,(7),inst_31939);
} else {
if((state_val_31951 === (7))){
var inst_31931 = (state_31950[(7)]);
var inst_31944 = (state_31950[(2)]);
var inst_31945 = fluree.db.util.async.throw_err(inst_31944);
var _ = (function (){var statearr_31961 = state_31950;
(statearr_31961[(4)] = cljs.core.rest((state_31950[(4)])));

return statearr_31961;
})();
var state_31950__$1 = (function (){var statearr_31962 = state_31950;
(statearr_31962[(10)] = inst_31945);

return statearr_31962;
})();
var statearr_31963_31973 = state_31950__$1;
(statearr_31963_31973[(2)] = inst_31931);

(statearr_31963_31973[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__15091__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__15091__auto____0 = (function (){
var statearr_31964 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31964[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__15091__auto__);

(statearr_31964[(1)] = (1));

return statearr_31964;
});
var fluree$db$storage$core$write_leaf_$_state_machine__15091__auto____1 = (function (state_31950){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_31950);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e31965){var ex__15094__auto__ = e31965;
var statearr_31966_31974 = state_31950;
(statearr_31966_31974[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_31950[(4)]))){
var statearr_31967_31975 = state_31950;
(statearr_31967_31975[(1)] = cljs.core.first((state_31950[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__31976 = state_31950;
state_31950 = G__31976;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__15091__auto__ = function(state_31950){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__15091__auto____1.call(this,state_31950);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__15091__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__15091__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_31968 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_31968[(6)] = c__15165__auto__);

return statearr_31968;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_31993){
var state_val_31994 = (state_31993[(1)]);
if((state_val_31994 === (1))){
var state_31993__$1 = state_31993;
var statearr_31995_32010 = state_31993__$1;
(statearr_31995_32010[(2)] = null);

(statearr_31995_32010[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31994 === (2))){
var _ = (function (){var statearr_31996 = state_31993;
(statearr_31996[(4)] = cljs.core.cons((5),(state_31993[(4)])));

return statearr_31996;
})();
var inst_31983 = fluree.db.storage.core.serde(conn);
var inst_31984 = fluree.db.serde.protocol._serialize_branch(inst_31983,data);
var inst_31985 = fluree.db.storage.core.storage_write(conn,key,inst_31984);
var state_31993__$1 = state_31993;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31993__$1,(6),inst_31985);
} else {
if((state_val_31994 === (3))){
var inst_31991 = (state_31993[(2)]);
var state_31993__$1 = state_31993;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31993__$1,inst_31991);
} else {
if((state_val_31994 === (4))){
var inst_31977 = (state_31993[(2)]);
var state_31993__$1 = state_31993;
var statearr_31998_32011 = state_31993__$1;
(statearr_31998_32011[(2)] = inst_31977);

(statearr_31998_32011[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31994 === (5))){
var _ = (function (){var statearr_31999 = state_31993;
(statearr_31999[(4)] = cljs.core.rest((state_31993[(4)])));

return statearr_31999;
})();
var state_31993__$1 = state_31993;
var ex31997 = (state_31993__$1[(2)]);
var statearr_32000_32012 = state_31993__$1;
(statearr_32000_32012[(5)] = ex31997);


if((ex31997 instanceof Error)){
var statearr_32001_32013 = state_31993__$1;
(statearr_32001_32013[(1)] = (4));

(statearr_32001_32013[(5)] = null);

} else {
throw ex31997;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31994 === (6))){
var inst_31987 = (state_31993[(2)]);
var inst_31988 = fluree.db.util.async.throw_err(inst_31987);
var _ = (function (){var statearr_32002 = state_31993;
(statearr_32002[(4)] = cljs.core.rest((state_31993[(4)])));

return statearr_32002;
})();
var state_31993__$1 = (function (){var statearr_32003 = state_31993;
(statearr_32003[(7)] = inst_31988);

return statearr_32003;
})();
var statearr_32004_32014 = state_31993__$1;
(statearr_32004_32014[(2)] = key);

(statearr_32004_32014[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__15091__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__15091__auto____0 = (function (){
var statearr_32005 = [null,null,null,null,null,null,null,null];
(statearr_32005[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__15091__auto__);

(statearr_32005[(1)] = (1));

return statearr_32005;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__15091__auto____1 = (function (state_31993){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_31993);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e32006){var ex__15094__auto__ = e32006;
var statearr_32007_32015 = state_31993;
(statearr_32007_32015[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_31993[(4)]))){
var statearr_32008_32016 = state_31993;
(statearr_32008_32016[(1)] = cljs.core.first((state_31993[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__32017 = state_31993;
state_31993 = G__32017;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__15091__auto__ = function(state_31993){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__15091__auto____1.call(this,state_31993);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__15091__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__15091__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_32009 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_32009[(6)] = c__15165__auto__);

return statearr_32009;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__32018_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__32018_SHARP_));
}),children);
var rhs = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$children,child_vals,cljs.core.cst$kw$rhs,rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__32019){
var map__32020 = p__32019;
var map__32020__$1 = cljs.core.__destructure_map(map__32020);
var progress = map__32020__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32020__$1,cljs.core.cst$kw$garbage);
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_32048){
var state_val_32049 = (state_32048[(1)]);
if((state_val_32049 === (1))){
var state_32048__$1 = state_32048;
var statearr_32050_32066 = state_32048__$1;
(statearr_32050_32066[(2)] = null);

(statearr_32050_32066[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32049 === (2))){
var inst_32034 = (state_32048[(7)]);
var _ = (function (){var statearr_32051 = state_32048;
(statearr_32051[(4)] = cljs.core.cons((5),(state_32048[(4)])));

return statearr_32051;
})();
var inst_32028 = db;
var inst_32029 = cljs.core.__destructure_map(inst_32028);
var inst_32030 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32029,cljs.core.cst$kw$conn);
var inst_32031 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32029,cljs.core.cst$kw$network);
var inst_32032 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32029,cljs.core.cst$kw$dbid);
var inst_32033 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32029,cljs.core.cst$kw$block);
var inst_32034__$1 = fluree.db.storage.core.ledger_garbage_key(inst_32031,inst_32032,inst_32033);
var inst_32035 = [cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$garbage];
var inst_32036 = [inst_32032,inst_32033,garbage];
var inst_32037 = cljs.core.PersistentHashMap.fromArrays(inst_32035,inst_32036);
var inst_32038 = fluree.db.storage.core.serde(inst_32030);
var inst_32039 = fluree.db.serde.protocol._serialize_garbage(inst_32038,inst_32037);
var inst_32040 = fluree.db.storage.core.storage_write(inst_32030,inst_32034__$1,inst_32039);
var state_32048__$1 = (function (){var statearr_32052 = state_32048;
(statearr_32052[(7)] = inst_32034__$1);

return statearr_32052;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32048__$1,(6),inst_32040);
} else {
if((state_val_32049 === (3))){
var inst_32046 = (state_32048[(2)]);
var state_32048__$1 = state_32048;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32048__$1,inst_32046);
} else {
if((state_val_32049 === (4))){
var inst_32021 = (state_32048[(2)]);
var state_32048__$1 = state_32048;
var statearr_32054_32067 = state_32048__$1;
(statearr_32054_32067[(2)] = inst_32021);

(statearr_32054_32067[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32049 === (5))){
var _ = (function (){var statearr_32055 = state_32048;
(statearr_32055[(4)] = cljs.core.rest((state_32048[(4)])));

return statearr_32055;
})();
var state_32048__$1 = state_32048;
var ex32053 = (state_32048__$1[(2)]);
var statearr_32056_32068 = state_32048__$1;
(statearr_32056_32068[(5)] = ex32053);


if((ex32053 instanceof Error)){
var statearr_32057_32069 = state_32048__$1;
(statearr_32057_32069[(1)] = (4));

(statearr_32057_32069[(5)] = null);

} else {
throw ex32053;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32049 === (6))){
var inst_32034 = (state_32048[(7)]);
var inst_32042 = (state_32048[(2)]);
var inst_32043 = fluree.db.util.async.throw_err(inst_32042);
var _ = (function (){var statearr_32058 = state_32048;
(statearr_32058[(4)] = cljs.core.rest((state_32048[(4)])));

return statearr_32058;
})();
var state_32048__$1 = (function (){var statearr_32059 = state_32048;
(statearr_32059[(8)] = inst_32043);

return statearr_32059;
})();
var statearr_32060_32070 = state_32048__$1;
(statearr_32060_32070[(2)] = inst_32034);

(statearr_32060_32070[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__15091__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__15091__auto____0 = (function (){
var statearr_32061 = [null,null,null,null,null,null,null,null,null];
(statearr_32061[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__15091__auto__);

(statearr_32061[(1)] = (1));

return statearr_32061;
});
var fluree$db$storage$core$write_garbage_$_state_machine__15091__auto____1 = (function (state_32048){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_32048);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e32062){var ex__15094__auto__ = e32062;
var statearr_32063_32071 = state_32048;
(statearr_32063_32071[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_32048[(4)]))){
var statearr_32064_32072 = state_32048;
(statearr_32064_32072[(1)] = cljs.core.first((state_32048[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__32073 = state_32048;
state_32048 = G__32073;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__15091__auto__ = function(state_32048){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__15091__auto____1.call(this,state_32048);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__15091__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__15091__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_32065 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_32065[(6)] = c__15165__auto__);

return statearr_32065;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__32075 = arguments.length;
switch (G__32075) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_32131){
var state_val_32132 = (state_32131[(1)]);
if((state_val_32132 === (7))){
var state_32131__$1 = state_32131;
var statearr_32133_32159 = state_32131__$1;
(statearr_32133_32159[(2)] = (0));

(statearr_32133_32159[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32132 === (1))){
var state_32131__$1 = state_32131;
var statearr_32134_32160 = state_32131__$1;
(statearr_32134_32160[(2)] = null);

(statearr_32134_32160[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32132 === (4))){
var inst_32076 = (state_32131[(2)]);
var state_32131__$1 = state_32131;
var statearr_32135_32161 = state_32131__$1;
(statearr_32135_32161[(2)] = inst_32076);

(statearr_32135_32161[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32132 === (6))){
var inst_32101 = (state_32131[(7)]);
var state_32131__$1 = state_32131;
var statearr_32136_32162 = state_32131__$1;
(statearr_32136_32162[(2)] = inst_32101);

(statearr_32136_32162[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32132 === (3))){
var inst_32129 = (state_32131[(2)]);
var state_32131__$1 = state_32131;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32131__$1,inst_32129);
} else {
if((state_val_32132 === (12))){
var inst_32098 = (state_32131[(8)]);
var inst_32125 = (state_32131[(2)]);
var inst_32126 = fluree.db.util.async.throw_err(inst_32125);
var _ = (function (){var statearr_32137 = state_32131;
(statearr_32137[(4)] = cljs.core.rest((state_32131[(4)])));

return statearr_32137;
})();
var state_32131__$1 = (function (){var statearr_32138 = state_32131;
(statearr_32138[(9)] = inst_32126);

return statearr_32138;
})();
var statearr_32139_32163 = state_32131__$1;
(statearr_32139_32163[(2)] = inst_32098);

(statearr_32139_32163[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32132 === (2))){
var inst_32091 = (state_32131[(10)]);
var inst_32089 = (state_32131[(11)]);
var inst_32101 = (state_32131[(7)]);
var inst_32093 = (state_32131[(12)]);
var _ = (function (){var statearr_32140 = state_32131;
(statearr_32140[(4)] = cljs.core.cons((5),(state_32131[(4)])));

return statearr_32140;
})();
var inst_32083 = db;
var inst_32084 = cljs.core.__destructure_map(inst_32083);
var inst_32085 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32084,cljs.core.cst$kw$network);
var inst_32086 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32084,cljs.core.cst$kw$t);
var inst_32087 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32084,cljs.core.cst$kw$fork);
var inst_32088 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32084,cljs.core.cst$kw$spot);
var inst_32089__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32084,cljs.core.cst$kw$stats);
var inst_32090 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32084,cljs.core.cst$kw$conn);
var inst_32091__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32084,cljs.core.cst$kw$block);
var inst_32092 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32084,cljs.core.cst$kw$psot);
var inst_32093__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32084,cljs.core.cst$kw$dbid);
var inst_32094 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32084,cljs.core.cst$kw$ecount);
var inst_32095 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32084,cljs.core.cst$kw$opst);
var inst_32096 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32084,cljs.core.cst$kw$fork_DASH_block);
var inst_32097 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32084,cljs.core.cst$kw$post);
var inst_32098 = fluree.db.storage.core.ledger_root_key(inst_32085,inst_32093__$1,inst_32091__$1);
var inst_32099 = [cljs.core.cst$kw$block,cljs.core.cst$kw$psot,cljs.core.cst$kw$dbid,cljs.core.cst$kw$prevIndex,cljs.core.cst$kw$ecount,cljs.core.cst$kw$opst,cljs.core.cst$kw$post,cljs.core.cst$kw$t,cljs.core.cst$kw$timestamp,cljs.core.cst$kw$fork,cljs.core.cst$kw$forkBlock,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot];
var inst_32100 = fluree.db.storage.core.child_data(inst_32092);
var inst_32101__$1 = cljs.core.cst$kw$indexed.cljs$core$IFn$_invoke$arity$1(inst_32089__$1);
var state_32131__$1 = (function (){var statearr_32141 = state_32131;
(statearr_32141[(8)] = inst_32098);

(statearr_32141[(13)] = inst_32097);

(statearr_32141[(14)] = inst_32086);

(statearr_32141[(15)] = inst_32094);

(statearr_32141[(10)] = inst_32091__$1);

(statearr_32141[(11)] = inst_32089__$1);

(statearr_32141[(7)] = inst_32101__$1);

(statearr_32141[(16)] = inst_32088);

(statearr_32141[(17)] = inst_32087);

(statearr_32141[(18)] = inst_32099);

(statearr_32141[(19)] = inst_32100);

(statearr_32141[(20)] = inst_32096);

(statearr_32141[(12)] = inst_32093__$1);

(statearr_32141[(21)] = inst_32090);

(statearr_32141[(22)] = inst_32095);

return statearr_32141;
})();
if(cljs.core.truth_(inst_32101__$1)){
var statearr_32142_32164 = state_32131__$1;
(statearr_32142_32164[(1)] = (6));

} else {
var statearr_32143_32165 = state_32131__$1;
(statearr_32143_32165[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32132 === (11))){
var inst_32098 = (state_32131[(8)]);
var inst_32097 = (state_32131[(13)]);
var inst_32105 = (state_32131[(23)]);
var inst_32086 = (state_32131[(14)]);
var inst_32091 = (state_32131[(10)]);
var inst_32089 = (state_32131[(11)]);
var inst_32088 = (state_32131[(16)]);
var inst_32087 = (state_32131[(17)]);
var inst_32099 = (state_32131[(18)]);
var inst_32100 = (state_32131[(19)]);
var inst_32096 = (state_32131[(20)]);
var inst_32093 = (state_32131[(12)]);
var inst_32090 = (state_32131[(21)]);
var inst_32095 = (state_32131[(22)]);
var inst_32110 = (state_32131[(2)]);
var inst_32111 = fluree.db.storage.core.child_data(inst_32095);
var inst_32112 = fluree.db.storage.core.child_data(inst_32097);
var inst_32113 = fluree.db.util.core.current_time_millis();
var inst_32114 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32115 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$size];
var inst_32116 = (new cljs.core.PersistentVector(null,2,(5),inst_32114,inst_32115,null));
var inst_32117 = cljs.core.select_keys(inst_32089,inst_32116);
var inst_32118 = fluree.db.storage.core.child_data(inst_32088);
var inst_32119 = [inst_32091,inst_32100,inst_32093,inst_32105,inst_32110,inst_32111,inst_32112,inst_32086,inst_32113,inst_32087,inst_32096,inst_32117,inst_32118];
var inst_32120 = cljs.core.PersistentHashMap.fromArrays(inst_32099,inst_32119);
var inst_32121 = fluree.db.storage.core.serde(inst_32090);
var inst_32122 = fluree.db.serde.protocol._serialize_db_root(inst_32121,inst_32120);
var inst_32123 = fluree.db.storage.core.storage_write(inst_32090,inst_32098,inst_32122);
var state_32131__$1 = state_32131;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32131__$1,(12),inst_32123);
} else {
if((state_val_32132 === (9))){
var inst_32106 = (state_32131[(24)]);
var state_32131__$1 = state_32131;
var statearr_32145_32166 = state_32131__$1;
(statearr_32145_32166[(2)] = inst_32106);

(statearr_32145_32166[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32132 === (5))){
var _ = (function (){var statearr_32146 = state_32131;
(statearr_32146[(4)] = cljs.core.rest((state_32131[(4)])));

return statearr_32146;
})();
var state_32131__$1 = state_32131;
var ex32144 = (state_32131__$1[(2)]);
var statearr_32147_32167 = state_32131__$1;
(statearr_32147_32167[(5)] = ex32144);


if((ex32144 instanceof Error)){
var statearr_32148_32168 = state_32131__$1;
(statearr_32148_32168[(1)] = (4));

(statearr_32148_32168[(5)] = null);

} else {
throw ex32144;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32132 === (10))){
var inst_32094 = (state_32131[(15)]);
var state_32131__$1 = state_32131;
var statearr_32149_32169 = state_32131__$1;
(statearr_32149_32169[(2)] = inst_32094);

(statearr_32149_32169[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32132 === (8))){
var inst_32106 = (state_32131[(24)]);
var inst_32105 = (state_32131[(2)]);
var inst_32106__$1 = custom_ecount;
var state_32131__$1 = (function (){var statearr_32150 = state_32131;
(statearr_32150[(23)] = inst_32105);

(statearr_32150[(24)] = inst_32106__$1);

return statearr_32150;
})();
if(cljs.core.truth_(inst_32106__$1)){
var statearr_32151_32170 = state_32131__$1;
(statearr_32151_32170[(1)] = (9));

} else {
var statearr_32152_32171 = state_32131__$1;
(statearr_32152_32171[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__15091__auto__ = null;
var fluree$db$storage$core$state_machine__15091__auto____0 = (function (){
var statearr_32153 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32153[(0)] = fluree$db$storage$core$state_machine__15091__auto__);

(statearr_32153[(1)] = (1));

return statearr_32153;
});
var fluree$db$storage$core$state_machine__15091__auto____1 = (function (state_32131){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_32131);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e32154){var ex__15094__auto__ = e32154;
var statearr_32155_32172 = state_32131;
(statearr_32155_32172[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_32131[(4)]))){
var statearr_32156_32173 = state_32131;
(statearr_32156_32173[(1)] = cljs.core.first((state_32131[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__32174 = state_32131;
state_32131 = G__32174;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__15091__auto__ = function(state_32131){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__15091__auto____1.call(this,state_32131);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__15091__auto____0;
fluree$db$storage$core$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__15091__auto____1;
return fluree$db$storage$core$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_32157 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_32157[(6)] = c__15165__auto__);

return statearr_32157;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__15165__auto___32233 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_32207){
var state_val_32208 = (state_32207[(1)]);
if((state_val_32208 === (7))){
var inst_32187 = (state_32207[(7)]);
var state_32207__$1 = state_32207;
var statearr_32209_32234 = state_32207__$1;
(statearr_32209_32234[(2)] = inst_32187);

(statearr_32209_32234[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32208 === (1))){
var state_32207__$1 = state_32207;
var statearr_32210_32235 = state_32207__$1;
(statearr_32210_32235[(2)] = null);

(statearr_32210_32235[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32208 === (4))){
var inst_32175 = (state_32207[(2)]);
var inst_32176 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_32177 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_32175);
var inst_32178 = cljs.core.async.close_BANG_(return_ch);
var state_32207__$1 = (function (){var statearr_32211 = state_32207;
(statearr_32211[(8)] = inst_32176);

(statearr_32211[(9)] = inst_32177);

return statearr_32211;
})();
var statearr_32212_32236 = state_32207__$1;
(statearr_32212_32236[(2)] = inst_32178);

(statearr_32212_32236[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32208 === (6))){
var inst_32187 = (state_32207[(7)]);
var inst_32186 = (state_32207[(10)]);
var inst_32186__$1 = (state_32207[(2)]);
var inst_32187__$1 = (inst_32186__$1 == null);
var state_32207__$1 = (function (){var statearr_32213 = state_32207;
(statearr_32213[(7)] = inst_32187__$1);

(statearr_32213[(10)] = inst_32186__$1);

return statearr_32213;
})();
if(cljs.core.truth_(inst_32187__$1)){
var statearr_32214_32237 = state_32207__$1;
(statearr_32214_32237[(1)] = (7));

} else {
var statearr_32215_32238 = state_32207__$1;
(statearr_32215_32238[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32208 === (3))){
var inst_32205 = (state_32207[(2)]);
var state_32207__$1 = state_32207;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32207__$1,inst_32205);
} else {
if((state_val_32208 === (12))){
var inst_32202 = (state_32207[(2)]);
var _ = (function (){var statearr_32216 = state_32207;
(statearr_32216[(4)] = cljs.core.rest((state_32207[(4)])));

return statearr_32216;
})();
var state_32207__$1 = state_32207;
var statearr_32217_32239 = state_32207__$1;
(statearr_32217_32239[(2)] = inst_32202);

(statearr_32217_32239[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32208 === (2))){
var _ = (function (){var statearr_32218 = state_32207;
(statearr_32218[(4)] = cljs.core.cons((5),(state_32207[(4)])));

return statearr_32218;
})();
var inst_32184 = fluree.db.storage.core.storage_read(conn,key);
var state_32207__$1 = state_32207;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32207__$1,(6),inst_32184);
} else {
if((state_val_32208 === (11))){
var inst_32186 = (state_32207[(10)]);
var inst_32196 = fluree.db.storage.core.serde(conn);
var inst_32197 = fluree.db.serde.protocol._deserialize_leaf(inst_32196,inst_32186);
var inst_32198 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_32197);
var inst_32199 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_32198);
var inst_32200 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_32199);
var state_32207__$1 = state_32207;
var statearr_32220_32240 = state_32207__$1;
(statearr_32220_32240[(2)] = inst_32200);

(statearr_32220_32240[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32208 === (9))){
var inst_32192 = (state_32207[(2)]);
var state_32207__$1 = state_32207;
if(cljs.core.truth_(inst_32192)){
var statearr_32221_32241 = state_32207__$1;
(statearr_32221_32241[(1)] = (10));

} else {
var statearr_32222_32242 = state_32207__$1;
(statearr_32222_32242[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32208 === (5))){
var _ = (function (){var statearr_32223 = state_32207;
(statearr_32223[(4)] = cljs.core.rest((state_32207[(4)])));

return statearr_32223;
})();
var state_32207__$1 = state_32207;
var ex32219 = (state_32207__$1[(2)]);
var statearr_32224_32243 = state_32207__$1;
(statearr_32224_32243[(5)] = ex32219);


var statearr_32225_32244 = state_32207__$1;
(statearr_32225_32244[(1)] = (4));

(statearr_32225_32244[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_32208 === (10))){
var inst_32194 = cljs.core.async.close_BANG_(return_ch);
var state_32207__$1 = state_32207;
var statearr_32226_32245 = state_32207__$1;
(statearr_32226_32245[(2)] = inst_32194);

(statearr_32226_32245[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32208 === (8))){
var inst_32186 = (state_32207[(10)]);
var inst_32190 = (inst_32186 instanceof Error);
var state_32207__$1 = state_32207;
var statearr_32227_32246 = state_32207__$1;
(statearr_32227_32246[(2)] = inst_32190);

(statearr_32227_32246[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__15091__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__15091__auto____0 = (function (){
var statearr_32228 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32228[(0)] = fluree$db$storage$core$reify_history_$_state_machine__15091__auto__);

(statearr_32228[(1)] = (1));

return statearr_32228;
});
var fluree$db$storage$core$reify_history_$_state_machine__15091__auto____1 = (function (state_32207){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_32207);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e32229){var ex__15094__auto__ = e32229;
var statearr_32230_32247 = state_32207;
(statearr_32230_32247[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_32207[(4)]))){
var statearr_32231_32248 = state_32207;
(statearr_32231_32248[(1)] = cljs.core.first((state_32207[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__32249 = state_32207;
state_32207 = G__32249;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__15091__auto__ = function(state_32207){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__15091__auto____1.call(this,state_32207);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__15091__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__15091__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_32232 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_32232[(6)] = c__15165__auto___32233);

return statearr_32232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__32251 = arguments.length;
switch (G__32251) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__5043__auto__ = rhs;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__5043__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__5043__auto__ = rhs;
if(cljs.core.truth_(and__5043__auto__)){
return leftmost_QMARK_;
} else {
return and__5043__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__5043__auto__ = (rhs == null);
if(and__5043__auto__){
return leftmost_QMARK_;
} else {
return and__5043__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__15165__auto___32363 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_32314){
var state_val_32315 = (state_32314[(1)]);
if((state_val_32315 === (7))){
var state_32314__$1 = state_32314;
var statearr_32316_32364 = state_32314__$1;
(statearr_32316_32364[(2)] = cljs.core.cst$kw$novelty);

(statearr_32316_32364[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32315 === (20))){
var inst_32293 = cljs.core.PersistentVector.EMPTY;
var state_32314__$1 = state_32314;
var statearr_32317_32365 = state_32314__$1;
(statearr_32317_32365[(2)] = inst_32293);

(statearr_32317_32365[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32315 === (1))){
var state_32314__$1 = state_32314;
var statearr_32318_32366 = state_32314__$1;
(statearr_32318_32366[(2)] = null);

(statearr_32318_32366[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32315 === (24))){
var state_32314__$1 = state_32314;
var statearr_32319_32367 = state_32314__$1;
(statearr_32319_32367[(2)] = null);

(statearr_32319_32367[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32315 === (4))){
var inst_32254 = (state_32314[(2)]);
var inst_32255 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_32256 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_32254);
var inst_32257 = cljs.core.async.close_BANG_(result_ch);
var state_32314__$1 = (function (){var statearr_32320 = state_32314;
(statearr_32320[(7)] = inst_32255);

(statearr_32320[(8)] = inst_32256);

return statearr_32320;
})();
var statearr_32321_32368 = state_32314__$1;
(statearr_32321_32368[(2)] = inst_32257);

(statearr_32321_32368[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32315 === (15))){
var inst_32279 = (state_32314[(2)]);
var state_32314__$1 = state_32314;
var statearr_32322_32369 = state_32314__$1;
(statearr_32322_32369[(2)] = inst_32279);

(statearr_32322_32369[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32315 === (21))){
var inst_32283 = (state_32314[(9)]);
var inst_32266 = (state_32314[(10)]);
var inst_32267 = (state_32314[(11)]);
var inst_32268 = (state_32314[(12)]);
var inst_32296 = (state_32314[(13)]);
var inst_32303 = (state_32314[(2)]);
var inst_32304 = (function (){var base_node = inst_32266;
var first_flake = inst_32267;
var node_t = inst_32268;
var source = inst_32283;
var coll = inst_32296;
var conj_QMARK_ = inst_32303;
return (function (acc,f){
if(cljs.core.truth_((function (){var G__32324 = f.p;
var fexpr__32323 = (function (){var or__5045__auto__ = remove_preds;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__32323.cljs$core$IFn$_invoke$arity$1 ? fexpr__32323.cljs$core$IFn$_invoke$arity$1(G__32324) : fexpr__32323.call(null,G__32324));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
})();
var inst_32305 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_32266);
var inst_32306 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_32304,inst_32305,inst_32296);
var inst_32307 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_32306);
var inst_32308 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_32266,cljs.core.cst$kw$flakes,inst_32307);
var inst_32309 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_32308);
var _ = (function (){var statearr_32325 = state_32314;
(statearr_32325[(4)] = cljs.core.rest((state_32314[(4)])));

return statearr_32325;
})();
var state_32314__$1 = state_32314;
var statearr_32326_32370 = state_32314__$1;
(statearr_32326_32370[(2)] = inst_32309);

(statearr_32326_32370[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32315 === (13))){
var state_32314__$1 = state_32314;
var statearr_32327_32371 = state_32314__$1;
(statearr_32327_32371[(2)] = cljs.core.cst$kw$none);

(statearr_32327_32371[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32315 === (22))){
var inst_32283 = (state_32314[(9)]);
var inst_32266 = (state_32314[(10)]);
var inst_32267 = (state_32314[(11)]);
var inst_32268 = (state_32314[(12)]);
var inst_32296 = (state_32314[(13)]);
var inst_32297 = (function (){var base_node = inst_32266;
var first_flake = inst_32267;
var node_t = inst_32268;
var source = inst_32283;
var coll = inst_32296;
return (function (f){
return f.op === true;
});
})();
var state_32314__$1 = state_32314;
var statearr_32328_32372 = state_32314__$1;
(statearr_32328_32372[(2)] = inst_32297);

(statearr_32328_32372[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32315 === (6))){
var inst_32266 = (state_32314[(10)]);
var inst_32268 = (state_32314[(12)]);
var inst_32265 = (state_32314[(2)]);
var inst_32266__$1 = fluree.db.util.async.throw_err(inst_32265);
var inst_32267 = fluree.db.dbproto._first_flake(inst_32266__$1);
var inst_32268__$1 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_32266__$1);
var inst_32269 = (inst_32268__$1 > t);
var state_32314__$1 = (function (){var statearr_32329 = state_32314;
(statearr_32329[(10)] = inst_32266__$1);

(statearr_32329[(11)] = inst_32267);

(statearr_32329[(12)] = inst_32268__$1);

return statearr_32329;
})();
if(cljs.core.truth_(inst_32269)){
var statearr_32330_32373 = state_32314__$1;
(statearr_32330_32373[(1)] = (7));

} else {
var statearr_32331_32374 = state_32314__$1;
(statearr_32331_32374[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32315 === (17))){
var inst_32267 = (state_32314[(11)]);
var inst_32284 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_32267,rhs,leftmost_QMARK_,t);
var state_32314__$1 = state_32314;
var statearr_32332_32375 = state_32314__$1;
(statearr_32332_32375[(2)] = inst_32284);

(statearr_32332_32375[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32315 === (3))){
var inst_32312 = (state_32314[(2)]);
var state_32314__$1 = state_32314;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32314__$1,inst_32312);
} else {
if((state_val_32315 === (12))){
var inst_32281 = (state_32314[(2)]);
var state_32314__$1 = state_32314;
var statearr_32333_32376 = state_32314__$1;
(statearr_32333_32376[(2)] = inst_32281);

(statearr_32333_32376[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32315 === (2))){
var _ = (function (){var statearr_32334 = state_32314;
(statearr_32334[(4)] = cljs.core.cons((5),(state_32314[(4)])));

return statearr_32334;
})();
var inst_32263 = fluree.db.dbproto._resolve(node);
var state_32314__$1 = state_32314;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32314__$1,(6),inst_32263);
} else {
if((state_val_32315 === (23))){
var inst_32283 = (state_32314[(9)]);
var inst_32266 = (state_32314[(10)]);
var inst_32267 = (state_32314[(11)]);
var inst_32268 = (state_32314[(12)]);
var inst_32296 = (state_32314[(13)]);
var inst_32299 = (function (){var base_node = inst_32266;
var first_flake = inst_32267;
var node_t = inst_32268;
var source = inst_32283;
var coll = inst_32296;
return (function (f){
return f.op === false;
});
})();
var state_32314__$1 = state_32314;
var statearr_32335_32377 = state_32314__$1;
(statearr_32335_32377[(2)] = inst_32299);

(statearr_32335_32377[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32315 === (19))){
var inst_32286 = (state_32314[(14)]);
var inst_32289 = (state_32314[(2)]);
var inst_32290 = fluree.db.util.async.throw_err(inst_32289);
var inst_32291 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_32286,inst_32290);
var state_32314__$1 = state_32314;
var statearr_32336_32378 = state_32314__$1;
(statearr_32336_32378[(2)] = inst_32291);

(statearr_32336_32378[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32315 === (11))){
var inst_32268 = (state_32314[(12)]);
var inst_32275 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32268,t);
var state_32314__$1 = state_32314;
if(inst_32275){
var statearr_32338_32379 = state_32314__$1;
(statearr_32338_32379[(1)] = (13));

} else {
var statearr_32339_32380 = state_32314__$1;
(statearr_32339_32380[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32315 === (9))){
var inst_32283 = (state_32314[(9)]);
var inst_32283__$1 = (state_32314[(2)]);
var state_32314__$1 = (function (){var statearr_32340 = state_32314;
(statearr_32340[(9)] = inst_32283__$1);

return statearr_32340;
})();
var G__32341_32381 = inst_32283__$1;
var G__32341_32382__$1 = (((G__32341_32381 instanceof cljs.core.Keyword))?G__32341_32381.fqn:null);
switch (G__32341_32382__$1) {
case "novelty":
var statearr_32342_32384 = state_32314__$1;
(statearr_32342_32384[(1)] = (17));


break;
case "history":
var statearr_32343_32385 = state_32314__$1;
(statearr_32343_32385[(1)] = (18));


break;
case "none":
var statearr_32344_32386 = state_32314__$1;
(statearr_32344_32386[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32341_32382__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32315 === (5))){
var _ = (function (){var statearr_32345 = state_32314;
(statearr_32345[(4)] = cljs.core.rest((state_32314[(4)])));

return statearr_32345;
})();
var state_32314__$1 = state_32314;
var ex32337 = (state_32314__$1[(2)]);
var statearr_32346_32387 = state_32314__$1;
(statearr_32346_32387[(5)] = ex32337);


var statearr_32347_32388 = state_32314__$1;
(statearr_32347_32388[(1)] = (4));

(statearr_32347_32388[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_32315 === (14))){
var state_32314__$1 = state_32314;
var statearr_32348_32389 = state_32314__$1;
(statearr_32348_32389[(2)] = null);

(statearr_32348_32389[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32315 === (16))){
var inst_32283 = (state_32314[(9)]);
var inst_32296 = (state_32314[(2)]);
var state_32314__$1 = (function (){var statearr_32349 = state_32314;
(statearr_32349[(13)] = inst_32296);

return statearr_32349;
})();
var G__32350_32390 = inst_32283;
var G__32350_32391__$1 = (((G__32350_32390 instanceof cljs.core.Keyword))?G__32350_32390.fqn:null);
switch (G__32350_32391__$1) {
case "novelty":
var statearr_32351_32393 = state_32314__$1;
(statearr_32351_32393[(1)] = (22));


break;
case "history":
var statearr_32352_32394 = state_32314__$1;
(statearr_32352_32394[(1)] = (23));


break;
case "none":
var statearr_32353_32395 = state_32314__$1;
(statearr_32353_32395[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32350_32391__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32315 === (10))){
var state_32314__$1 = state_32314;
var statearr_32354_32396 = state_32314__$1;
(statearr_32354_32396[(2)] = cljs.core.cst$kw$history);

(statearr_32354_32396[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32315 === (18))){
var inst_32283 = (state_32314[(9)]);
var inst_32266 = (state_32314[(10)]);
var inst_32267 = (state_32314[(11)]);
var inst_32268 = (state_32314[(12)]);
var inst_32286 = (function (){var base_node = inst_32266;
var first_flake = inst_32267;
var node_t = inst_32268;
var source = inst_32283;
return (function (p1__32253_SHARP_){
return (p1__32253_SHARP_.t <= t);
});
})();
var inst_32287 = fluree.db.dbproto._resolve_history(node);
var state_32314__$1 = (function (){var statearr_32355 = state_32314;
(statearr_32355[(14)] = inst_32286);

return statearr_32355;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32314__$1,(19),inst_32287);
} else {
if((state_val_32315 === (8))){
var inst_32268 = (state_32314[(12)]);
var inst_32272 = (inst_32268 < t);
var state_32314__$1 = state_32314;
if(cljs.core.truth_(inst_32272)){
var statearr_32356_32397 = state_32314__$1;
(statearr_32356_32397[(1)] = (10));

} else {
var statearr_32357_32398 = state_32314__$1;
(statearr_32357_32398[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__15091__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__15091__auto____0 = (function (){
var statearr_32358 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32358[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__15091__auto__);

(statearr_32358[(1)] = (1));

return statearr_32358;
});
var fluree$db$storage$core$resolve_t_$_state_machine__15091__auto____1 = (function (state_32314){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_32314);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e32359){var ex__15094__auto__ = e32359;
var statearr_32360_32399 = state_32314;
(statearr_32360_32399[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_32314[(4)]))){
var statearr_32361_32400 = state_32314;
(statearr_32361_32400[(1)] = cljs.core.first((state_32314[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__32401 = state_32314;
state_32314 = G__32401;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__15091__auto__ = function(state_32314){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__15091__auto____1.call(this,state_32314);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__15091__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__15091__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_32362 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_32362[(6)] = c__15165__auto___32363);

return statearr_32362;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_32461){
var state_val_32462 = (state_32461[(1)]);
if((state_val_32462 === (7))){
var inst_32412 = (state_32461[(7)]);
var inst_32416 = (inst_32412 <= from_t);
var state_32461__$1 = state_32461;
var statearr_32463_32503 = state_32461__$1;
(statearr_32463_32503[(2)] = inst_32416);

(statearr_32463_32503[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (20))){
var inst_32446 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(node);
var inst_32447 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32446)].join('');
var inst_32448 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_32449 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_32450 = cljs.core.PersistentHashMap.fromArrays(inst_32448,inst_32449);
var inst_32451 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_32447,inst_32450);
var inst_32452 = (function(){throw inst_32451})();
var state_32461__$1 = state_32461;
var statearr_32464_32504 = state_32461__$1;
(statearr_32464_32504[(2)] = inst_32452);

(statearr_32464_32504[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (1))){
var state_32461__$1 = state_32461;
var statearr_32465_32505 = state_32461__$1;
(statearr_32465_32505[(2)] = null);

(statearr_32465_32505[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (4))){
var inst_32404 = (state_32461[(2)]);
var inst_32405 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_32404], 0));
var inst_32406 = (function(){throw inst_32404})();
var state_32461__$1 = (function (){var statearr_32466 = state_32461;
(statearr_32466[(8)] = inst_32405);

return statearr_32466;
})();
var statearr_32467_32506 = state_32461__$1;
(statearr_32467_32506[(2)] = inst_32406);

(statearr_32467_32506[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (15))){
var inst_32431 = (state_32461[(2)]);
var state_32461__$1 = (function (){var statearr_32468 = state_32461;
(statearr_32468[(9)] = inst_32431);

return statearr_32468;
})();
if(cljs.core.truth_(from_t)){
var statearr_32469_32507 = state_32461__$1;
(statearr_32469_32507[(1)] = (16));

} else {
var statearr_32470_32508 = state_32461__$1;
(statearr_32470_32508[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (21))){
var inst_32442 = (state_32461[(10)]);
var inst_32441 = (state_32461[(11)]);
var inst_32440 = (state_32461[(12)]);
var inst_32454 = (state_32461[(2)]);
var inst_32455 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_32441,inst_32442,leftmost_QMARK_,to_t);
var inst_32456 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_32455,inst_32440);
var _ = (function (){var statearr_32471 = state_32461;
(statearr_32471[(4)] = cljs.core.rest((state_32461[(4)])));

return statearr_32471;
})();
var state_32461__$1 = (function (){var statearr_32472 = state_32461;
(statearr_32472[(13)] = inst_32454);

return statearr_32472;
})();
var statearr_32473_32509 = state_32461__$1;
(statearr_32473_32509[(2)] = inst_32456);

(statearr_32473_32509[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (13))){
var inst_32424 = (state_32461[(14)]);
var inst_32412 = (state_32461[(7)]);
var inst_32427 = (function (){var node_t = inst_32412;
var G__32420 = inst_32424;
return (function (p1__32402_SHARP_){
return (p1__32402_SHARP_.t < to_t);
});
})();
var inst_32428 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_32427,inst_32424);
var state_32461__$1 = state_32461;
var statearr_32474_32510 = state_32461__$1;
(statearr_32474_32510[(2)] = inst_32428);

(statearr_32474_32510[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (6))){
var inst_32413 = (state_32461[(15)]);
var state_32461__$1 = state_32461;
var statearr_32475_32511 = state_32461__$1;
(statearr_32475_32511[(2)] = inst_32413);

(statearr_32475_32511[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (17))){
var inst_32431 = (state_32461[(9)]);
var state_32461__$1 = state_32461;
var statearr_32476_32512 = state_32461__$1;
(statearr_32476_32512[(2)] = inst_32431);

(statearr_32476_32512[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (3))){
var inst_32459 = (state_32461[(2)]);
var state_32461__$1 = state_32461;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32461__$1,inst_32459);
} else {
if((state_val_32462 === (12))){
var inst_32412 = (state_32461[(7)]);
var inst_32423 = (state_32461[(2)]);
var inst_32424 = fluree.db.util.async.throw_err(inst_32423);
var inst_32425 = (to_t > inst_32412);
var state_32461__$1 = (function (){var statearr_32477 = state_32461;
(statearr_32477[(14)] = inst_32424);

return statearr_32477;
})();
if(cljs.core.truth_(inst_32425)){
var statearr_32478_32513 = state_32461__$1;
(statearr_32478_32513[(1)] = (13));

} else {
var statearr_32479_32514 = state_32461__$1;
(statearr_32479_32514[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (2))){
var inst_32413 = (state_32461[(15)]);
var _ = (function (){var statearr_32480 = state_32461;
(statearr_32480[(4)] = cljs.core.cons((5),(state_32461[(4)])));

return statearr_32480;
})();
var inst_32412 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(node);
var inst_32413__$1 = (from_t == null);
var state_32461__$1 = (function (){var statearr_32481 = state_32461;
(statearr_32481[(7)] = inst_32412);

(statearr_32481[(15)] = inst_32413__$1);

return statearr_32481;
})();
if(cljs.core.truth_(inst_32413__$1)){
var statearr_32482_32515 = state_32461__$1;
(statearr_32482_32515[(1)] = (6));

} else {
var statearr_32483_32516 = state_32461__$1;
(statearr_32483_32516[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (19))){
var state_32461__$1 = state_32461;
var statearr_32484_32517 = state_32461__$1;
(statearr_32484_32517[(2)] = null);

(statearr_32484_32517[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (11))){
var inst_32440 = (state_32461[(2)]);
var inst_32441 = fluree.db.dbproto._first_flake(node);
var inst_32442 = fluree.db.dbproto._rhs(node);
var inst_32443 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(node);
var state_32461__$1 = (function (){var statearr_32486 = state_32461;
(statearr_32486[(10)] = inst_32442);

(statearr_32486[(11)] = inst_32441);

(statearr_32486[(12)] = inst_32440);

return statearr_32486;
})();
if(cljs.core.truth_(inst_32443)){
var statearr_32487_32518 = state_32461__$1;
(statearr_32487_32518[(1)] = (19));

} else {
var statearr_32488_32519 = state_32461__$1;
(statearr_32488_32519[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (9))){
var inst_32421 = fluree.db.dbproto._resolve_history(node);
var state_32461__$1 = state_32461;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32461__$1,(12),inst_32421);
} else {
if((state_val_32462 === (5))){
var _ = (function (){var statearr_32489 = state_32461;
(statearr_32489[(4)] = cljs.core.rest((state_32461[(4)])));

return statearr_32489;
})();
var state_32461__$1 = state_32461;
var ex32485 = (state_32461__$1[(2)]);
var statearr_32490_32520 = state_32461__$1;
(statearr_32490_32520[(5)] = ex32485);


var statearr_32491_32521 = state_32461__$1;
(statearr_32491_32521[(1)] = (4));

(statearr_32491_32521[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (14))){
var inst_32424 = (state_32461[(14)]);
var state_32461__$1 = state_32461;
var statearr_32492_32522 = state_32461__$1;
(statearr_32492_32522[(2)] = inst_32424);

(statearr_32492_32522[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (16))){
var inst_32412 = (state_32461[(7)]);
var inst_32431 = (state_32461[(9)]);
var inst_32433 = (function (){var node_t = inst_32412;
var G__32420 = inst_32431;
return (function (p1__32403_SHARP_){
return (p1__32403_SHARP_.t <= from_t);
});
})();
var inst_32434 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_32433,inst_32431);
var state_32461__$1 = state_32461;
var statearr_32493_32523 = state_32461__$1;
(statearr_32493_32523[(2)] = inst_32434);

(statearr_32493_32523[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (10))){
var state_32461__$1 = state_32461;
var statearr_32494_32524 = state_32461__$1;
(statearr_32494_32524[(2)] = null);

(statearr_32494_32524[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (18))){
var inst_32437 = (state_32461[(2)]);
var state_32461__$1 = state_32461;
var statearr_32495_32525 = state_32461__$1;
(statearr_32495_32525[(2)] = inst_32437);

(statearr_32495_32525[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (8))){
var inst_32418 = (state_32461[(2)]);
var state_32461__$1 = state_32461;
if(cljs.core.truth_(inst_32418)){
var statearr_32496_32526 = state_32461__$1;
(statearr_32496_32526[(1)] = (9));

} else {
var statearr_32497_32527 = state_32461__$1;
(statearr_32497_32527[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__15091__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__15091__auto____0 = (function (){
var statearr_32498 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32498[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__15091__auto__);

(statearr_32498[(1)] = (1));

return statearr_32498;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__15091__auto____1 = (function (state_32461){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_32461);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e32499){var ex__15094__auto__ = e32499;
var statearr_32500_32528 = state_32461;
(statearr_32500_32528[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_32461[(4)]))){
var statearr_32501_32529 = state_32461;
(statearr_32501_32529[(1)] = cljs.core.first((state_32461[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__32530 = state_32461;
state_32461 = G__32530;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__15091__auto__ = function(state_32461){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__15091__auto____1.call(this,state_32461);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__15091__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__15091__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_32502 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_32502[(6)] = c__15165__auto__);

return statearr_32502;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__5045__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__32531_32541 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__32532_32542 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__32531_32541,G__32532_32542) : object_cache.call(null,G__32531_32541,G__32532_32542));

var G__32533 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__32534 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__32535 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__32536 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__32535,G__32536) : object_cache.call(null,G__32535,G__32536));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__32533,G__32534) : object_cache.call(null,G__32533,G__32534));
} else {
var G__32537 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__32538 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__32539 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__32540 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__32539,G__32540) : object_cache.call(null,G__32539,G__32540));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__32537,G__32538) : object_cache.call(null,G__32537,G__32538));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_32563){
var state_val_32564 = (state_32563[(1)]);
if((state_val_32564 === (7))){
var inst_32552 = (state_32563[(7)]);
var inst_32554 = fluree.db.storage.core.serde(conn);
var inst_32555 = fluree.db.serde.protocol._deserialize_branch(inst_32554,inst_32552);
var state_32563__$1 = state_32563;
var statearr_32565_32584 = state_32563__$1;
(statearr_32565_32584[(2)] = inst_32555);

(statearr_32565_32584[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32564 === (1))){
var state_32563__$1 = state_32563;
var statearr_32566_32585 = state_32563__$1;
(statearr_32566_32585[(2)] = null);

(statearr_32566_32585[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32564 === (4))){
var inst_32543 = (state_32563[(2)]);
var state_32563__$1 = state_32563;
var statearr_32567_32586 = state_32563__$1;
(statearr_32567_32586[(2)] = inst_32543);

(statearr_32567_32586[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32564 === (6))){
var inst_32552 = (state_32563[(7)]);
var inst_32551 = (state_32563[(2)]);
var inst_32552__$1 = fluree.db.util.async.throw_err(inst_32551);
var state_32563__$1 = (function (){var statearr_32568 = state_32563;
(statearr_32568[(7)] = inst_32552__$1);

return statearr_32568;
})();
if(cljs.core.truth_(inst_32552__$1)){
var statearr_32569_32587 = state_32563__$1;
(statearr_32569_32587[(1)] = (7));

} else {
var statearr_32570_32588 = state_32563__$1;
(statearr_32570_32588[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32564 === (3))){
var inst_32561 = (state_32563[(2)]);
var state_32563__$1 = state_32563;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32563__$1,inst_32561);
} else {
if((state_val_32564 === (2))){
var _ = (function (){var statearr_32572 = state_32563;
(statearr_32572[(4)] = cljs.core.cons((5),(state_32563[(4)])));

return statearr_32572;
})();
var inst_32549 = fluree.db.storage.core.storage_read(conn,key);
var state_32563__$1 = state_32563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32563__$1,(6),inst_32549);
} else {
if((state_val_32564 === (9))){
var inst_32558 = (state_32563[(2)]);
var _ = (function (){var statearr_32573 = state_32563;
(statearr_32573[(4)] = cljs.core.rest((state_32563[(4)])));

return statearr_32573;
})();
var state_32563__$1 = state_32563;
var statearr_32574_32589 = state_32563__$1;
(statearr_32574_32589[(2)] = inst_32558);

(statearr_32574_32589[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32564 === (5))){
var _ = (function (){var statearr_32575 = state_32563;
(statearr_32575[(4)] = cljs.core.rest((state_32563[(4)])));

return statearr_32575;
})();
var state_32563__$1 = state_32563;
var ex32571 = (state_32563__$1[(2)]);
var statearr_32576_32590 = state_32563__$1;
(statearr_32576_32590[(5)] = ex32571);


if((ex32571 instanceof Error)){
var statearr_32577_32591 = state_32563__$1;
(statearr_32577_32591[(1)] = (4));

(statearr_32577_32591[(5)] = null);

} else {
throw ex32571;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32564 === (8))){
var state_32563__$1 = state_32563;
var statearr_32578_32592 = state_32563__$1;
(statearr_32578_32592[(2)] = null);

(statearr_32578_32592[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__15091__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__15091__auto____0 = (function (){
var statearr_32579 = [null,null,null,null,null,null,null,null];
(statearr_32579[(0)] = fluree$db$storage$core$read_branch_$_state_machine__15091__auto__);

(statearr_32579[(1)] = (1));

return statearr_32579;
});
var fluree$db$storage$core$read_branch_$_state_machine__15091__auto____1 = (function (state_32563){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_32563);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e32580){var ex__15094__auto__ = e32580;
var statearr_32581_32593 = state_32563;
(statearr_32581_32593[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_32563[(4)]))){
var statearr_32582_32594 = state_32563;
(statearr_32582_32594[(1)] = cljs.core.first((state_32563[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__32595 = state_32563;
state_32563 = G__32595;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__15091__auto__ = function(state_32563){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__15091__auto____1.call(this,state_32563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__15091__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__15091__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_32583 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_32583[(6)] = c__15165__auto__);

return statearr_32583;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__15165__auto___32674 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_32646){
var state_val_32647 = (state_32646[(1)]);
if((state_val_32647 === (7))){
var inst_32613 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_32614 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_32615 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_32616 = cljs.core.PersistentHashMap.fromArrays(inst_32614,inst_32615);
var inst_32617 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_32613,inst_32616);
var inst_32618 = (function(){throw inst_32617})();
var state_32646__$1 = state_32646;
var statearr_32648_32675 = state_32646__$1;
(statearr_32648_32675[(2)] = inst_32618);

(statearr_32648_32675[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32647 === (1))){
var state_32646__$1 = state_32646;
var statearr_32649_32676 = state_32646__$1;
(statearr_32649_32676[(2)] = null);

(statearr_32649_32676[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32647 === (4))){
var inst_32596 = (state_32646[(2)]);
var inst_32597 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_32598 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_32596);
var inst_32599 = cljs.core.async.close_BANG_(return_ch);
var state_32646__$1 = (function (){var statearr_32650 = state_32646;
(statearr_32650[(7)] = inst_32597);

(statearr_32650[(8)] = inst_32598);

return statearr_32650;
})();
var statearr_32651_32677 = state_32646__$1;
(statearr_32651_32677[(2)] = inst_32599);

(statearr_32651_32677[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32647 === (6))){
var inst_32610 = (state_32646[(9)]);
var inst_32609 = (state_32646[(2)]);
var inst_32610__$1 = fluree.db.util.async.throw_err(inst_32609);
var inst_32611 = (inst_32610__$1 == null);
var state_32646__$1 = (function (){var statearr_32652 = state_32646;
(statearr_32652[(9)] = inst_32610__$1);

return statearr_32652;
})();
if(cljs.core.truth_(inst_32611)){
var statearr_32653_32678 = state_32646__$1;
(statearr_32653_32678[(1)] = (7));

} else {
var statearr_32654_32679 = state_32646__$1;
(statearr_32654_32679[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32647 === (3))){
var inst_32644 = (state_32646[(2)]);
var state_32646__$1 = state_32646;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32646__$1,inst_32644);
} else {
if((state_val_32647 === (12))){
var inst_32610 = (state_32646[(9)]);
var inst_32627 = (state_32646[(2)]);
var inst_32628 = cljs.core.__destructure_map(inst_32610);
var inst_32629 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32628,cljs.core.cst$kw$children);
var inst_32630 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32628,cljs.core.cst$kw$rhs);
var inst_32631 = config;
var inst_32632 = cljs.core.__destructure_map(inst_32631);
var inst_32633 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32632,cljs.core.cst$kw$comparator);
var inst_32635 = (function (){var data = inst_32610;
var _ = inst_32627;
var map__32605 = inst_32628;
var children = inst_32629;
var rhs = inst_32630;
var map__32606 = inst_32632;
var comparator = inst_32633;
return (function (idx,p__32634){
var map__32655 = p__32634;
var map__32655__$1 = cljs.core.__destructure_map(map__32655);
var child = map__32655__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32655__$1,cljs.core.cst$kw$id);
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32655__$1,cljs.core.cst$kw$leaf);
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32655__$1,cljs.core.cst$kw$first);
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32655__$1,cljs.core.cst$kw$rhs);
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32655__$1,cljs.core.cst$kw$size);
var at_leftmost_QMARK_ = (function (){var and__5043__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return (idx === (0));
} else {
return and__5043__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
})();
var inst_32636 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_32635,inst_32629);
var inst_32637 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$first,inst_32636);
var inst_32638 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_32637,inst_32636);
var inst_32639 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_32633,inst_32638);
var inst_32640 = fluree.db.index.__GT_IndexNode(block,t,inst_32630,inst_32639,config,leftmost_QMARK_);
var inst_32641 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_32640);
var _ = (function (){var statearr_32656 = state_32646;
(statearr_32656[(4)] = cljs.core.rest((state_32646[(4)])));

return statearr_32656;
})();
var state_32646__$1 = state_32646;
var statearr_32657_32680 = state_32646__$1;
(statearr_32657_32680[(2)] = inst_32641);

(statearr_32657_32680[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32647 === (2))){
var _ = (function (){var statearr_32658 = state_32646;
(statearr_32658[(4)] = cljs.core.cons((5),(state_32646[(4)])));

return statearr_32658;
})();
var inst_32607 = fluree.db.storage.core.read_branch(conn,key);
var state_32646__$1 = state_32646;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32646__$1,(6),inst_32607);
} else {
if((state_val_32647 === (11))){
var state_32646__$1 = state_32646;
var statearr_32660_32681 = state_32646__$1;
(statearr_32660_32681[(2)] = null);

(statearr_32660_32681[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32647 === (9))){
var inst_32610 = (state_32646[(9)]);
var inst_32621 = (state_32646[(2)]);
var inst_32622 = fluree.db.util.core.exception_QMARK_(inst_32610);
var state_32646__$1 = (function (){var statearr_32661 = state_32646;
(statearr_32661[(10)] = inst_32621);

return statearr_32661;
})();
if(inst_32622){
var statearr_32662_32682 = state_32646__$1;
(statearr_32662_32682[(1)] = (10));

} else {
var statearr_32663_32683 = state_32646__$1;
(statearr_32663_32683[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32647 === (5))){
var _ = (function (){var statearr_32664 = state_32646;
(statearr_32664[(4)] = cljs.core.rest((state_32646[(4)])));

return statearr_32664;
})();
var state_32646__$1 = state_32646;
var ex32659 = (state_32646__$1[(2)]);
var statearr_32665_32684 = state_32646__$1;
(statearr_32665_32684[(5)] = ex32659);


var statearr_32666_32685 = state_32646__$1;
(statearr_32666_32685[(1)] = (4));

(statearr_32666_32685[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_32647 === (10))){
var inst_32610 = (state_32646[(9)]);
var inst_32624 = (function(){throw inst_32610})();
var state_32646__$1 = state_32646;
var statearr_32667_32686 = state_32646__$1;
(statearr_32667_32686[(2)] = inst_32624);

(statearr_32667_32686[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32647 === (8))){
var state_32646__$1 = state_32646;
var statearr_32668_32687 = state_32646__$1;
(statearr_32668_32687[(2)] = null);

(statearr_32668_32687[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__15091__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__15091__auto____0 = (function (){
var statearr_32669 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32669[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__15091__auto__);

(statearr_32669[(1)] = (1));

return statearr_32669;
});
var fluree$db$storage$core$reify_branch_$_state_machine__15091__auto____1 = (function (state_32646){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_32646);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e32670){var ex__15094__auto__ = e32670;
var statearr_32671_32688 = state_32646;
(statearr_32671_32688[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_32646[(4)]))){
var statearr_32672_32689 = state_32646;
(statearr_32672_32689[(1)] = cljs.core.first((state_32646[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__32690 = state_32646;
state_32646 = G__32690;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__15091__auto__ = function(state_32646){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__15091__auto____1.call(this,state_32646);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__15091__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__15091__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_32673 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_32673[(6)] = c__15165__auto___32674);

return statearr_32673;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_32711){
var state_val_32712 = (state_32711[(1)]);
if((state_val_32712 === (7))){
var state_32711__$1 = state_32711;
var statearr_32713_32733 = state_32711__$1;
(statearr_32713_32733[(2)] = null);

(statearr_32713_32733[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32712 === (1))){
var state_32711__$1 = state_32711;
var statearr_32714_32734 = state_32711__$1;
(statearr_32714_32734[(2)] = null);

(statearr_32714_32734[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32712 === (4))){
var inst_32691 = (state_32711[(2)]);
var state_32711__$1 = state_32711;
var statearr_32715_32735 = state_32711__$1;
(statearr_32715_32735[(2)] = inst_32691);

(statearr_32715_32735[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32712 === (6))){
var inst_32697 = (state_32711[(7)]);
var inst_32699 = fluree.db.storage.core.serde(conn);
var state_32711__$1 = (function (){var statearr_32716 = state_32711;
(statearr_32716[(8)] = inst_32699);

return statearr_32716;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32711__$1,(9),inst_32697);
} else {
if((state_val_32712 === (3))){
var inst_32709 = (state_32711[(2)]);
var state_32711__$1 = state_32711;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32711__$1,inst_32709);
} else {
if((state_val_32712 === (2))){
var inst_32697 = (state_32711[(7)]);
var _ = (function (){var statearr_32718 = state_32711;
(statearr_32718[(4)] = cljs.core.cons((5),(state_32711[(4)])));

return statearr_32718;
})();
var inst_32697__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_32711__$1 = (function (){var statearr_32719 = state_32711;
(statearr_32719[(7)] = inst_32697__$1);

return statearr_32719;
})();
if(cljs.core.truth_(inst_32697__$1)){
var statearr_32720_32736 = state_32711__$1;
(statearr_32720_32736[(1)] = (6));

} else {
var statearr_32721_32737 = state_32711__$1;
(statearr_32721_32737[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32712 === (9))){
var inst_32699 = (state_32711[(8)]);
var inst_32701 = (state_32711[(2)]);
var inst_32702 = fluree.db.util.async.throw_err(inst_32701);
var inst_32703 = fluree.db.serde.protocol._deserialize_leaf(inst_32699,inst_32702);
var state_32711__$1 = state_32711;
var statearr_32722_32738 = state_32711__$1;
(statearr_32722_32738[(2)] = inst_32703);

(statearr_32722_32738[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32712 === (5))){
var _ = (function (){var statearr_32723 = state_32711;
(statearr_32723[(4)] = cljs.core.rest((state_32711[(4)])));

return statearr_32723;
})();
var state_32711__$1 = state_32711;
var ex32717 = (state_32711__$1[(2)]);
var statearr_32724_32739 = state_32711__$1;
(statearr_32724_32739[(5)] = ex32717);


if((ex32717 instanceof Error)){
var statearr_32725_32740 = state_32711__$1;
(statearr_32725_32740[(1)] = (4));

(statearr_32725_32740[(5)] = null);

} else {
throw ex32717;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32712 === (8))){
var inst_32706 = (state_32711[(2)]);
var _ = (function (){var statearr_32726 = state_32711;
(statearr_32726[(4)] = cljs.core.rest((state_32711[(4)])));

return statearr_32726;
})();
var state_32711__$1 = state_32711;
var statearr_32727_32741 = state_32711__$1;
(statearr_32727_32741[(2)] = inst_32706);

(statearr_32727_32741[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__15091__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__15091__auto____0 = (function (){
var statearr_32728 = [null,null,null,null,null,null,null,null,null];
(statearr_32728[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__15091__auto__);

(statearr_32728[(1)] = (1));

return statearr_32728;
});
var fluree$db$storage$core$read_leaf_$_state_machine__15091__auto____1 = (function (state_32711){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_32711);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e32729){var ex__15094__auto__ = e32729;
var statearr_32730_32742 = state_32711;
(statearr_32730_32742[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_32711[(4)]))){
var statearr_32731_32743 = state_32711;
(statearr_32731_32743[(1)] = cljs.core.first((state_32711[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__32744 = state_32711;
state_32711 = G__32744;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__15091__auto__ = function(state_32711){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__15091__auto____1.call(this,state_32711);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__15091__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__15091__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_32732 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_32732[(6)] = c__15165__auto__);

return statearr_32732;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__15165__auto___32817 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_32789){
var state_val_32790 = (state_32789[(1)]);
if((state_val_32790 === (7))){
var inst_32761 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_32762 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_32763 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_32764 = cljs.core.PersistentHashMap.fromArrays(inst_32762,inst_32763);
var inst_32765 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_32761,inst_32764);
var inst_32766 = (function(){throw inst_32765})();
var state_32789__$1 = state_32789;
var statearr_32791_32818 = state_32789__$1;
(statearr_32791_32818[(2)] = inst_32766);

(statearr_32791_32818[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32790 === (1))){
var state_32789__$1 = state_32789;
var statearr_32792_32819 = state_32789__$1;
(statearr_32792_32819[(2)] = null);

(statearr_32792_32819[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32790 === (4))){
var inst_32745 = (state_32789[(2)]);
var inst_32746 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_32747 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_32745);
var inst_32748 = cljs.core.async.close_BANG_(return_ch);
var state_32789__$1 = (function (){var statearr_32793 = state_32789;
(statearr_32793[(7)] = inst_32746);

(statearr_32793[(8)] = inst_32747);

return statearr_32793;
})();
var statearr_32794_32820 = state_32789__$1;
(statearr_32794_32820[(2)] = inst_32748);

(statearr_32794_32820[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32790 === (6))){
var inst_32758 = (state_32789[(9)]);
var inst_32758__$1 = (state_32789[(2)]);
var inst_32759 = (inst_32758__$1 == null);
var state_32789__$1 = (function (){var statearr_32795 = state_32789;
(statearr_32795[(9)] = inst_32758__$1);

return statearr_32795;
})();
if(cljs.core.truth_(inst_32759)){
var statearr_32796_32821 = state_32789__$1;
(statearr_32796_32821[(1)] = (7));

} else {
var statearr_32797_32822 = state_32789__$1;
(statearr_32797_32822[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32790 === (3))){
var inst_32787 = (state_32789[(2)]);
var state_32789__$1 = state_32789;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32789__$1,inst_32787);
} else {
if((state_val_32790 === (12))){
var inst_32758 = (state_32789[(9)]);
var inst_32775 = (state_32789[(2)]);
var inst_32776 = cljs.core.__destructure_map(inst_32758);
var inst_32777 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32776,cljs.core.cst$kw$flakes);
var inst_32778 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32776,cljs.core.cst$kw$his);
var inst_32779 = config;
var inst_32780 = cljs.core.__destructure_map(inst_32779);
var inst_32781 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32780,cljs.core.cst$kw$comparator);
var inst_32782 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_32781,inst_32777);
var inst_32783 = fluree.db.index.data_node(block,t,inst_32782,rhs,config);
var inst_32784 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_32783);
var _ = (function (){var statearr_32798 = state_32789;
(statearr_32798[(4)] = cljs.core.rest((state_32789[(4)])));

return statearr_32798;
})();
var state_32789__$1 = (function (){var statearr_32799 = state_32789;
(statearr_32799[(10)] = inst_32778);

(statearr_32799[(11)] = inst_32775);

return statearr_32799;
})();
var statearr_32800_32823 = state_32789__$1;
(statearr_32800_32823[(2)] = inst_32784);

(statearr_32800_32823[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32790 === (2))){
var _ = (function (){var statearr_32801 = state_32789;
(statearr_32801[(4)] = cljs.core.cons((5),(state_32789[(4)])));

return statearr_32801;
})();
var inst_32756 = fluree.db.storage.core.read_leaf(conn,key);
var state_32789__$1 = state_32789;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32789__$1,(6),inst_32756);
} else {
if((state_val_32790 === (11))){
var state_32789__$1 = state_32789;
var statearr_32803_32824 = state_32789__$1;
(statearr_32803_32824[(2)] = null);

(statearr_32803_32824[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32790 === (9))){
var inst_32758 = (state_32789[(9)]);
var inst_32769 = (state_32789[(2)]);
var inst_32770 = fluree.db.util.core.exception_QMARK_(inst_32758);
var state_32789__$1 = (function (){var statearr_32804 = state_32789;
(statearr_32804[(12)] = inst_32769);

return statearr_32804;
})();
if(inst_32770){
var statearr_32805_32825 = state_32789__$1;
(statearr_32805_32825[(1)] = (10));

} else {
var statearr_32806_32826 = state_32789__$1;
(statearr_32806_32826[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32790 === (5))){
var _ = (function (){var statearr_32807 = state_32789;
(statearr_32807[(4)] = cljs.core.rest((state_32789[(4)])));

return statearr_32807;
})();
var state_32789__$1 = state_32789;
var ex32802 = (state_32789__$1[(2)]);
var statearr_32808_32827 = state_32789__$1;
(statearr_32808_32827[(5)] = ex32802);


var statearr_32809_32828 = state_32789__$1;
(statearr_32809_32828[(1)] = (4));

(statearr_32809_32828[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_32790 === (10))){
var inst_32758 = (state_32789[(9)]);
var inst_32772 = (function(){throw inst_32758})();
var state_32789__$1 = state_32789;
var statearr_32810_32829 = state_32789__$1;
(statearr_32810_32829[(2)] = inst_32772);

(statearr_32810_32829[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32790 === (8))){
var state_32789__$1 = state_32789;
var statearr_32811_32830 = state_32789__$1;
(statearr_32811_32830[(2)] = null);

(statearr_32811_32830[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__15091__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__15091__auto____0 = (function (){
var statearr_32812 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32812[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__15091__auto__);

(statearr_32812[(1)] = (1));

return statearr_32812;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__15091__auto____1 = (function (state_32789){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_32789);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e32813){var ex__15094__auto__ = e32813;
var statearr_32814_32831 = state_32789;
(statearr_32814_32831[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_32789[(4)]))){
var statearr_32815_32832 = state_32789;
(statearr_32815_32832[(1)] = cljs.core.first((state_32789[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__32833 = state_32789;
state_32789 = G__32833;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__15091__auto__ = function(state_32789){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__15091__auto____1.call(this,state_32789);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__15091__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__15091__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_32816 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_32816[(6)] = c__15165__auto___32817);

return statearr_32816;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5342__auto__,k__5343__auto__){
var self__ = this;
var this__5342__auto____$1 = this;
return this__5342__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5343__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5344__auto__,k32835,else__5345__auto__){
var self__ = this;
var this__5344__auto____$1 = this;
var G__32839 = k32835;
var G__32839__$1 = (((G__32839 instanceof cljs.core.Keyword))?G__32839.fqn:null);
switch (G__32839__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32835,else__5345__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5362__auto__,f__5363__auto__,init__5364__auto__){
var self__ = this;
var this__5362__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5365__auto__,p__32840){
var vec__32841 = p__32840;
var k__5366__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32841,(0),null);
var v__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32841,(1),null);
return (f__5363__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5363__auto__.cljs$core$IFn$_invoke$arity$3(ret__5365__auto__,k__5366__auto__,v__5367__auto__) : f__5363__auto__.call(null,ret__5365__auto__,k__5366__auto__,v__5367__auto__));
}),init__5364__auto__,this__5362__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5357__auto__,writer__5358__auto__,opts__5359__auto__){
var self__ = this;
var this__5357__auto____$1 = this;
var pr_pair__5360__auto__ = (function (keyval__5361__auto__){
return cljs.core.pr_sequential_writer(writer__5358__auto__,cljs.core.pr_writer,""," ","",opts__5359__auto__,keyval__5361__auto__);
});
return cljs.core.pr_sequential_writer(writer__5358__auto__,pr_pair__5360__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__5359__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leaf,self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$first,self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$size,self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tempid,self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32834){
var self__ = this;
var G__32834__$1 = this;
return (new cljs.core.RecordIter((0),G__32834__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__32844 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__32845 = (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
var G__32846 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__32847 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__32846,G__32847) : object_cache.call(null,G__32846,G__32847));
}));
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
var G__32848 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__32849 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__32848,G__32849) : object_cache.call(null,G__32848,G__32849));
}));
}
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__32844,G__32845) : object_cache.call(null,G__32844,G__32845));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});
var G__32850 = history_id;
var G__32851 = (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__32850,G__32851) : object_cache.call(null,G__32850,G__32851));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5340__auto__){
var self__ = this;
var this__5340__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5337__auto__){
var self__ = this;
var this__5337__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5346__auto__){
var self__ = this;
var this__5346__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__32852 = (function (coll__5339__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__5339__auto__));
});
return fexpr__32852(this__5338__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32836,other32837){
var self__ = this;
var this32836__$1 = this;
return (((!((other32837 == null)))) && ((((this32836__$1.constructor === other32837.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32836__$1.conn,other32837.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32836__$1.config,other32837.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32836__$1.network,other32837.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32836__$1.dbid,other32837.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32836__$1.id,other32837.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32836__$1.leaf,other32837.leaf)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32836__$1.first,other32837.first)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32836__$1.rhs,other32837.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32836__$1.size,other32837.size)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32836__$1.block,other32837.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32836__$1.t,other32837.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32836__$1.tt_id,other32837.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32836__$1.leftmost_QMARK_,other32837.leftmost_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32836__$1.tempid,other32837.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32836__$1.__extmap,other32837.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5352__auto__,k__5353__auto__){
var self__ = this;
var this__5352__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leaf,null,cljs.core.cst$kw$size,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$tempid,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$first,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$rhs,null,cljs.core.cst$kw$conn,null], null), null),k__5353__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5352__auto____$1),self__.__meta),k__5353__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5353__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5349__auto__,k32835){
var self__ = this;
var this__5349__auto____$1 = this;
var G__32853 = k32835;
var G__32853__$1 = (((G__32853 instanceof cljs.core.Keyword))?G__32853.fqn:null);
switch (G__32853__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k32835);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5350__auto__,k__5351__auto__,G__32834){
var self__ = this;
var this__5350__auto____$1 = this;
var pred__32854 = cljs.core.keyword_identical_QMARK_;
var expr__32855 = k__5351__auto__;
if(cljs.core.truth_((function (){var G__32857 = cljs.core.cst$kw$conn;
var G__32858 = expr__32855;
return (pred__32854.cljs$core$IFn$_invoke$arity$2 ? pred__32854.cljs$core$IFn$_invoke$arity$2(G__32857,G__32858) : pred__32854.call(null,G__32857,G__32858));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__32834,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32859 = cljs.core.cst$kw$config;
var G__32860 = expr__32855;
return (pred__32854.cljs$core$IFn$_invoke$arity$2 ? pred__32854.cljs$core$IFn$_invoke$arity$2(G__32859,G__32860) : pred__32854.call(null,G__32859,G__32860));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__32834,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32861 = cljs.core.cst$kw$network;
var G__32862 = expr__32855;
return (pred__32854.cljs$core$IFn$_invoke$arity$2 ? pred__32854.cljs$core$IFn$_invoke$arity$2(G__32861,G__32862) : pred__32854.call(null,G__32861,G__32862));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__32834,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32863 = cljs.core.cst$kw$dbid;
var G__32864 = expr__32855;
return (pred__32854.cljs$core$IFn$_invoke$arity$2 ? pred__32854.cljs$core$IFn$_invoke$arity$2(G__32863,G__32864) : pred__32854.call(null,G__32863,G__32864));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__32834,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32865 = cljs.core.cst$kw$id;
var G__32866 = expr__32855;
return (pred__32854.cljs$core$IFn$_invoke$arity$2 ? pred__32854.cljs$core$IFn$_invoke$arity$2(G__32865,G__32866) : pred__32854.call(null,G__32865,G__32866));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__32834,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32867 = cljs.core.cst$kw$leaf;
var G__32868 = expr__32855;
return (pred__32854.cljs$core$IFn$_invoke$arity$2 ? pred__32854.cljs$core$IFn$_invoke$arity$2(G__32867,G__32868) : pred__32854.call(null,G__32867,G__32868));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__32834,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32869 = cljs.core.cst$kw$first;
var G__32870 = expr__32855;
return (pred__32854.cljs$core$IFn$_invoke$arity$2 ? pred__32854.cljs$core$IFn$_invoke$arity$2(G__32869,G__32870) : pred__32854.call(null,G__32869,G__32870));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__32834,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32871 = cljs.core.cst$kw$rhs;
var G__32872 = expr__32855;
return (pred__32854.cljs$core$IFn$_invoke$arity$2 ? pred__32854.cljs$core$IFn$_invoke$arity$2(G__32871,G__32872) : pred__32854.call(null,G__32871,G__32872));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__32834,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32873 = cljs.core.cst$kw$size;
var G__32874 = expr__32855;
return (pred__32854.cljs$core$IFn$_invoke$arity$2 ? pred__32854.cljs$core$IFn$_invoke$arity$2(G__32873,G__32874) : pred__32854.call(null,G__32873,G__32874));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__32834,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32875 = cljs.core.cst$kw$block;
var G__32876 = expr__32855;
return (pred__32854.cljs$core$IFn$_invoke$arity$2 ? pred__32854.cljs$core$IFn$_invoke$arity$2(G__32875,G__32876) : pred__32854.call(null,G__32875,G__32876));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__32834,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32877 = cljs.core.cst$kw$t;
var G__32878 = expr__32855;
return (pred__32854.cljs$core$IFn$_invoke$arity$2 ? pred__32854.cljs$core$IFn$_invoke$arity$2(G__32877,G__32878) : pred__32854.call(null,G__32877,G__32878));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__32834,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32879 = cljs.core.cst$kw$tt_DASH_id;
var G__32880 = expr__32855;
return (pred__32854.cljs$core$IFn$_invoke$arity$2 ? pred__32854.cljs$core$IFn$_invoke$arity$2(G__32879,G__32880) : pred__32854.call(null,G__32879,G__32880));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__32834,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32881 = cljs.core.cst$kw$leftmost_QMARK_;
var G__32882 = expr__32855;
return (pred__32854.cljs$core$IFn$_invoke$arity$2 ? pred__32854.cljs$core$IFn$_invoke$arity$2(G__32881,G__32882) : pred__32854.call(null,G__32881,G__32882));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__32834,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32883 = cljs.core.cst$kw$tempid;
var G__32884 = expr__32855;
return (pred__32854.cljs$core$IFn$_invoke$arity$2 ? pred__32854.cljs$core$IFn$_invoke$arity$2(G__32883,G__32884) : pred__32854.call(null,G__32883,G__32884));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__32834,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5351__auto__,G__32834),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5355__auto__){
var self__ = this;
var this__5355__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leaf,self__.leaf,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$first,self__.first,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$size,self__.size,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tempid,self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5341__auto__,G__32834){
var self__ = this;
var this__5341__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__32834,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5347__auto__,entry__5348__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5348__auto__)){
return this__5347__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5347__auto____$1,entry__5348__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$config,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$id,cljs.core.cst$sym$leaf,cljs.core.cst$sym$first,cljs.core.cst$sym$rhs,cljs.core.cst$sym$size,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$leftmost_QMARK_,cljs.core.cst$sym$tempid], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__5388__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__5388__auto__,writer__5389__auto__){
return cljs.core._write(writer__5389__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__32838){
var extmap__5384__auto__ = (function (){var G__32885 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32838,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], 0));
if(cljs.core.record_QMARK_(G__32838)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32885);
} else {
return G__32885;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__32838),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__32838),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__32838),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__32838),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__32838),cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(G__32838),cljs.core.cst$kw$first.cljs$core$IFn$_invoke$arity$1(G__32838),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__32838),cljs.core.cst$kw$size.cljs$core$IFn$_invoke$arity$1(G__32838),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__32838),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__32838),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__32838),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__32838),cljs.core.cst$kw$tempid.cljs$core$IFn$_invoke$arity$1(G__32838),null,cljs.core.not_empty(extmap__5384__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,cljs.core.cst$kw$conn,conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cfg,cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$leftmost_QMARK_,true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__32888 = blank_db;
var map__32888__$1 = cljs.core.__destructure_map(map__32888);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32888__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32888__$1,cljs.core.cst$kw$dbid);
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32888__$1,cljs.core.cst$kw$index_DASH_configs);
var map__32889 = root_data;
var map__32889__$1 = cljs.core.__destructure_map(map__32889);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32889__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32889__$1,cljs.core.cst$kw$t);
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32889__$1,cljs.core.cst$kw$ecount);
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32889__$1,cljs.core.cst$kw$stats);
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,t,cljs.core.cst$kw$ecount,ecount,cljs.core.cst$kw$stats,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,cljs.core.cst$kw$indexed,block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_32911){
var state_val_32912 = (state_32911[(1)]);
if((state_val_32912 === (7))){
var state_32911__$1 = state_32911;
var statearr_32913_32933 = state_32911__$1;
(statearr_32913_32933[(2)] = null);

(statearr_32913_32933[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32912 === (1))){
var state_32911__$1 = state_32911;
var statearr_32914_32934 = state_32911__$1;
(statearr_32914_32934[(2)] = null);

(statearr_32914_32934[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32912 === (4))){
var inst_32890 = (state_32911[(2)]);
var state_32911__$1 = state_32911;
var statearr_32915_32935 = state_32911__$1;
(statearr_32915_32935[(2)] = inst_32890);

(statearr_32915_32935[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32912 === (6))){
var inst_32897 = (state_32911[(7)]);
var inst_32899 = fluree.db.storage.core.serde(conn);
var state_32911__$1 = (function (){var statearr_32916 = state_32911;
(statearr_32916[(8)] = inst_32899);

return statearr_32916;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32911__$1,(9),inst_32897);
} else {
if((state_val_32912 === (3))){
var inst_32909 = (state_32911[(2)]);
var state_32911__$1 = state_32911;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32911__$1,inst_32909);
} else {
if((state_val_32912 === (2))){
var inst_32897 = (state_32911[(7)]);
var _ = (function (){var statearr_32918 = state_32911;
(statearr_32918[(4)] = cljs.core.cons((5),(state_32911[(4)])));

return statearr_32918;
})();
var inst_32896 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_32897__$1 = fluree.db.storage.core.storage_read(conn,inst_32896);
var state_32911__$1 = (function (){var statearr_32919 = state_32911;
(statearr_32919[(7)] = inst_32897__$1);

return statearr_32919;
})();
if(cljs.core.truth_(inst_32897__$1)){
var statearr_32920_32936 = state_32911__$1;
(statearr_32920_32936[(1)] = (6));

} else {
var statearr_32921_32937 = state_32911__$1;
(statearr_32921_32937[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32912 === (9))){
var inst_32899 = (state_32911[(8)]);
var inst_32901 = (state_32911[(2)]);
var inst_32902 = fluree.db.util.async.throw_err(inst_32901);
var inst_32903 = fluree.db.serde.protocol._deserialize_garbage(inst_32899,inst_32902);
var state_32911__$1 = state_32911;
var statearr_32922_32938 = state_32911__$1;
(statearr_32922_32938[(2)] = inst_32903);

(statearr_32922_32938[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32912 === (5))){
var _ = (function (){var statearr_32923 = state_32911;
(statearr_32923[(4)] = cljs.core.rest((state_32911[(4)])));

return statearr_32923;
})();
var state_32911__$1 = state_32911;
var ex32917 = (state_32911__$1[(2)]);
var statearr_32924_32939 = state_32911__$1;
(statearr_32924_32939[(5)] = ex32917);


if((ex32917 instanceof Error)){
var statearr_32925_32940 = state_32911__$1;
(statearr_32925_32940[(1)] = (4));

(statearr_32925_32940[(5)] = null);

} else {
throw ex32917;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32912 === (8))){
var inst_32906 = (state_32911[(2)]);
var _ = (function (){var statearr_32926 = state_32911;
(statearr_32926[(4)] = cljs.core.rest((state_32911[(4)])));

return statearr_32926;
})();
var state_32911__$1 = state_32911;
var statearr_32927_32941 = state_32911__$1;
(statearr_32927_32941[(2)] = inst_32906);

(statearr_32927_32941[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__15091__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__15091__auto____0 = (function (){
var statearr_32928 = [null,null,null,null,null,null,null,null,null];
(statearr_32928[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__15091__auto__);

(statearr_32928[(1)] = (1));

return statearr_32928;
});
var fluree$db$storage$core$read_garbage_$_state_machine__15091__auto____1 = (function (state_32911){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_32911);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e32929){var ex__15094__auto__ = e32929;
var statearr_32930_32942 = state_32911;
(statearr_32930_32942[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_32911[(4)]))){
var statearr_32931_32943 = state_32911;
(statearr_32931_32943[(1)] = cljs.core.first((state_32911[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__32944 = state_32911;
state_32911 = G__32944;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__15091__auto__ = function(state_32911){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__15091__auto____1.call(this,state_32911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__15091__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__15091__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_32932 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_32932[(6)] = c__15165__auto__);

return statearr_32932;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_32966){
var state_val_32967 = (state_32966[(1)]);
if((state_val_32967 === (7))){
var inst_32955 = (state_32966[(7)]);
var inst_32957 = fluree.db.storage.core.serde(conn);
var inst_32958 = fluree.db.serde.protocol._deserialize_db_root(inst_32957,inst_32955);
var state_32966__$1 = state_32966;
var statearr_32968_32987 = state_32966__$1;
(statearr_32968_32987[(2)] = inst_32958);

(statearr_32968_32987[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32967 === (1))){
var state_32966__$1 = state_32966;
var statearr_32969_32988 = state_32966__$1;
(statearr_32969_32988[(2)] = null);

(statearr_32969_32988[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32967 === (4))){
var inst_32945 = (state_32966[(2)]);
var state_32966__$1 = state_32966;
var statearr_32970_32989 = state_32966__$1;
(statearr_32970_32989[(2)] = inst_32945);

(statearr_32970_32989[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32967 === (6))){
var inst_32955 = (state_32966[(7)]);
var inst_32954 = (state_32966[(2)]);
var inst_32955__$1 = fluree.db.util.async.throw_err(inst_32954);
var state_32966__$1 = (function (){var statearr_32971 = state_32966;
(statearr_32971[(7)] = inst_32955__$1);

return statearr_32971;
})();
if(cljs.core.truth_(inst_32955__$1)){
var statearr_32972_32990 = state_32966__$1;
(statearr_32972_32990[(1)] = (7));

} else {
var statearr_32973_32991 = state_32966__$1;
(statearr_32973_32991[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32967 === (3))){
var inst_32964 = (state_32966[(2)]);
var state_32966__$1 = state_32966;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32966__$1,inst_32964);
} else {
if((state_val_32967 === (2))){
var _ = (function (){var statearr_32975 = state_32966;
(statearr_32975[(4)] = cljs.core.cons((5),(state_32966[(4)])));

return statearr_32975;
})();
var inst_32951 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_32952 = fluree.db.storage.core.storage_read(conn,inst_32951);
var state_32966__$1 = state_32966;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32966__$1,(6),inst_32952);
} else {
if((state_val_32967 === (9))){
var inst_32961 = (state_32966[(2)]);
var _ = (function (){var statearr_32976 = state_32966;
(statearr_32976[(4)] = cljs.core.rest((state_32966[(4)])));

return statearr_32976;
})();
var state_32966__$1 = state_32966;
var statearr_32977_32992 = state_32966__$1;
(statearr_32977_32992[(2)] = inst_32961);

(statearr_32977_32992[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32967 === (5))){
var _ = (function (){var statearr_32978 = state_32966;
(statearr_32978[(4)] = cljs.core.rest((state_32966[(4)])));

return statearr_32978;
})();
var state_32966__$1 = state_32966;
var ex32974 = (state_32966__$1[(2)]);
var statearr_32979_32993 = state_32966__$1;
(statearr_32979_32993[(5)] = ex32974);


if((ex32974 instanceof Error)){
var statearr_32980_32994 = state_32966__$1;
(statearr_32980_32994[(1)] = (4));

(statearr_32980_32994[(5)] = null);

} else {
throw ex32974;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32967 === (8))){
var state_32966__$1 = state_32966;
var statearr_32981_32995 = state_32966__$1;
(statearr_32981_32995[(2)] = null);

(statearr_32981_32995[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__15091__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__15091__auto____0 = (function (){
var statearr_32982 = [null,null,null,null,null,null,null,null];
(statearr_32982[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__15091__auto__);

(statearr_32982[(1)] = (1));

return statearr_32982;
});
var fluree$db$storage$core$read_db_root_$_state_machine__15091__auto____1 = (function (state_32966){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_32966);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e32983){var ex__15094__auto__ = e32983;
var statearr_32984_32996 = state_32966;
(statearr_32984_32996[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_32966[(4)]))){
var statearr_32985_32997 = state_32966;
(statearr_32985_32997[(1)] = cljs.core.first((state_32966[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__32998 = state_32966;
state_32966 = G__32998;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__15091__auto__ = function(state_32966){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__15091__auto____1.call(this,state_32966);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__15091__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__15091__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_32986 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_32986[(6)] = c__15165__auto__);

return statearr_32986;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_33034){
var state_val_33035 = (state_33034[(1)]);
if((state_val_33035 === (7))){
var inst_33008 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_33009 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33010 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_33011 = cljs.core.PersistentHashMap.fromArrays(inst_33009,inst_33010);
var inst_33012 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33008,inst_33011);
var inst_33013 = (function(){throw inst_33012})();
var state_33034__$1 = state_33034;
var statearr_33036_33058 = state_33034__$1;
(statearr_33036_33058[(2)] = inst_33013);

(statearr_33036_33058[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33035 === (1))){
var state_33034__$1 = state_33034;
var statearr_33037_33059 = state_33034__$1;
(statearr_33037_33059[(2)] = null);

(statearr_33037_33059[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33035 === (4))){
var inst_32999 = (state_33034[(2)]);
var state_33034__$1 = state_33034;
var statearr_33038_33060 = state_33034__$1;
(statearr_33038_33060[(2)] = inst_32999);

(statearr_33038_33060[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33035 === (6))){
var state_33034__$1 = state_33034;
var statearr_33039_33061 = state_33034__$1;
(statearr_33039_33061[(2)] = null);

(statearr_33039_33061[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33035 === (3))){
var inst_33032 = (state_33034[(2)]);
var state_33034__$1 = state_33034;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33034__$1,inst_33032);
} else {
if((state_val_33035 === (2))){
var inst_33005 = (state_33034[(7)]);
var _ = (function (){var statearr_33040 = state_33034;
(statearr_33040[(4)] = cljs.core.cons((5),(state_33034[(4)])));

return statearr_33040;
})();
var inst_33005__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_33034__$1 = (function (){var statearr_33041 = state_33034;
(statearr_33041[(7)] = inst_33005__$1);

return statearr_33041;
})();
if(cljs.core.truth_(inst_33005__$1)){
var statearr_33042_33062 = state_33034__$1;
(statearr_33042_33062[(1)] = (6));

} else {
var statearr_33043_33063 = state_33034__$1;
(statearr_33043_33063[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33035 === (11))){
var inst_33024 = (state_33034[(8)]);
var inst_33027 = (state_33034[(2)]);
var inst_33028 = fluree.db.util.async.throw_err(inst_33027);
var inst_33029 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_33024,cljs.core.cst$kw$settings,inst_33028);
var _ = (function (){var statearr_33045 = state_33034;
(statearr_33045[(4)] = cljs.core.rest((state_33034[(4)])));

return statearr_33045;
})();
var state_33034__$1 = state_33034;
var statearr_33046_33064 = state_33034__$1;
(statearr_33046_33064[(2)] = inst_33029);

(statearr_33046_33064[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33035 === (9))){
var inst_33019 = (state_33034[(9)]);
var inst_33017 = (state_33034[(2)]);
var inst_33018 = fluree.db.util.async.throw_err(inst_33017);
var inst_33019__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_33018);
var inst_33020 = fluree.db.query.schema.schema_map(inst_33019__$1);
var state_33034__$1 = (function (){var statearr_33047 = state_33034;
(statearr_33047[(9)] = inst_33019__$1);

return statearr_33047;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33034__$1,(10),inst_33020);
} else {
if((state_val_33035 === (5))){
var _ = (function (){var statearr_33048 = state_33034;
(statearr_33048[(4)] = cljs.core.rest((state_33034[(4)])));

return statearr_33048;
})();
var state_33034__$1 = state_33034;
var ex33044 = (state_33034__$1[(2)]);
var statearr_33049_33065 = state_33034__$1;
(statearr_33049_33065[(5)] = ex33044);


if((ex33044 instanceof Error)){
var statearr_33050_33066 = state_33034__$1;
(statearr_33050_33066[(1)] = (4));

(statearr_33050_33066[(5)] = null);

} else {
throw ex33044;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33035 === (10))){
var inst_33019 = (state_33034[(9)]);
var inst_33024 = (state_33034[(8)]);
var inst_33022 = (state_33034[(2)]);
var inst_33023 = fluree.db.util.async.throw_err(inst_33022);
var inst_33024__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_33019,cljs.core.cst$kw$schema,inst_33023);
var inst_33025 = fluree.db.query.schema.setting_map(inst_33024__$1);
var state_33034__$1 = (function (){var statearr_33051 = state_33034;
(statearr_33051[(8)] = inst_33024__$1);

return statearr_33051;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33034__$1,(11),inst_33025);
} else {
if((state_val_33035 === (8))){
var inst_33005 = (state_33034[(7)]);
var inst_33015 = (state_33034[(2)]);
var state_33034__$1 = (function (){var statearr_33052 = state_33034;
(statearr_33052[(10)] = inst_33015);

return statearr_33052;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33034__$1,(9),inst_33005);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__15091__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__15091__auto____0 = (function (){
var statearr_33053 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33053[(0)] = fluree$db$storage$core$reify_db_$_state_machine__15091__auto__);

(statearr_33053[(1)] = (1));

return statearr_33053;
});
var fluree$db$storage$core$reify_db_$_state_machine__15091__auto____1 = (function (state_33034){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_33034);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e33054){var ex__15094__auto__ = e33054;
var statearr_33055_33067 = state_33034;
(statearr_33055_33067[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_33034[(4)]))){
var statearr_33056_33068 = state_33034;
(statearr_33056_33068[(1)] = cljs.core.first((state_33034[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__33069 = state_33034;
state_33034 = G__33069;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__15091__auto__ = function(state_33034){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__15091__auto____1.call(this,state_33034);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__15091__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__15091__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_33057 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_33057[(6)] = c__15165__auto__);

return statearr_33057;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__33071 = arguments.length;
switch (G__33071) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_33124){
var state_val_33125 = (state_33124[(1)]);
if((state_val_33125 === (7))){
var inst_33081 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_33082 = (new Error(inst_33081));
var inst_33083 = (function(){throw inst_33082})();
var state_33124__$1 = state_33124;
var statearr_33126_33166 = state_33124__$1;
(statearr_33126_33166[(2)] = inst_33083);

(statearr_33126_33166[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33125 === (20))){
var inst_33115 = (state_33124[(2)]);
var state_33124__$1 = state_33124;
var statearr_33127_33167 = state_33124__$1;
(statearr_33127_33167[(2)] = inst_33115);

(statearr_33127_33167[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33125 === (1))){
var state_33124__$1 = state_33124;
var statearr_33128_33168 = state_33124__$1;
(statearr_33128_33168[(2)] = null);

(statearr_33128_33168[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33125 === (4))){
var inst_33072 = (state_33124[(2)]);
var state_33124__$1 = state_33124;
var statearr_33129_33169 = state_33124__$1;
(statearr_33129_33169[(2)] = inst_33072);

(statearr_33129_33169[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33125 === (15))){
var inst_33090 = (state_33124[(7)]);
var state_33124__$1 = state_33124;
var statearr_33130_33170 = state_33124__$1;
(statearr_33130_33170[(2)] = inst_33090);

(statearr_33130_33170[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33125 === (21))){
var inst_33089 = (state_33124[(8)]);
var inst_33090 = (state_33124[(7)]);
var inst_33094 = (state_33124[(9)]);
var inst_33108 = (inst_33089 + (1));
var inst_33109 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33090,inst_33094);
var inst_33089__$1 = inst_33108;
var inst_33090__$1 = inst_33109;
var state_33124__$1 = (function (){var statearr_33131 = state_33124;
(statearr_33131[(8)] = inst_33089__$1);

(statearr_33131[(7)] = inst_33090__$1);

return statearr_33131;
})();
var statearr_33132_33171 = state_33124__$1;
(statearr_33132_33171[(2)] = null);

(statearr_33132_33171[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33125 === (13))){
var inst_33094 = (state_33124[(9)]);
var inst_33098 = (inst_33094 instanceof Error);
var state_33124__$1 = state_33124;
var statearr_33133_33172 = state_33124__$1;
(statearr_33133_33172[(2)] = inst_33098);

(statearr_33133_33172[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33125 === (22))){
var state_33124__$1 = state_33124;
var statearr_33134_33173 = state_33124__$1;
(statearr_33134_33173[(2)] = null);

(statearr_33134_33173[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33125 === (6))){
var state_33124__$1 = state_33124;
var statearr_33135_33174 = state_33124__$1;
(statearr_33135_33174[(2)] = null);

(statearr_33135_33174[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33125 === (17))){
var inst_33117 = (state_33124[(2)]);
var state_33124__$1 = state_33124;
var statearr_33136_33175 = state_33124__$1;
(statearr_33136_33175[(2)] = inst_33117);

(statearr_33136_33175[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33125 === (3))){
var inst_33122 = (state_33124[(2)]);
var state_33124__$1 = state_33124;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33124__$1,inst_33122);
} else {
if((state_val_33125 === (12))){
var inst_33095 = (state_33124[(10)]);
var state_33124__$1 = state_33124;
var statearr_33137_33176 = state_33124__$1;
(statearr_33137_33176[(2)] = inst_33095);

(statearr_33137_33176[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33125 === (2))){
var _ = (function (){var statearr_33138 = state_33124;
(statearr_33138[(4)] = cljs.core.cons((5),(state_33124[(4)])));

return statearr_33138;
})();
var inst_33078 = (end >= start);
var state_33124__$1 = state_33124;
if(cljs.core.truth_(inst_33078)){
var statearr_33139_33177 = state_33124__$1;
(statearr_33139_33177[(1)] = (6));

} else {
var statearr_33140_33178 = state_33124__$1;
(statearr_33140_33178[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33125 === (23))){
var inst_33113 = (state_33124[(2)]);
var state_33124__$1 = state_33124;
var statearr_33141_33179 = state_33124__$1;
(statearr_33141_33179[(2)] = inst_33113);

(statearr_33141_33179[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33125 === (19))){
var state_33124__$1 = state_33124;
var statearr_33142_33180 = state_33124__$1;
(statearr_33142_33180[(1)] = (21));



return cljs.core.cst$kw$recur;
} else {
if((state_val_33125 === (11))){
var inst_33095 = (state_33124[(10)]);
var inst_33094 = (state_33124[(9)]);
var inst_33094__$1 = (state_33124[(2)]);
var inst_33095__$1 = (inst_33094__$1 == null);
var state_33124__$1 = (function (){var statearr_33145 = state_33124;
(statearr_33145[(10)] = inst_33095__$1);

(statearr_33145[(9)] = inst_33094__$1);

return statearr_33145;
})();
if(cljs.core.truth_(inst_33095__$1)){
var statearr_33146_33181 = state_33124__$1;
(statearr_33146_33181[(1)] = (12));

} else {
var statearr_33147_33182 = state_33124__$1;
(statearr_33147_33182[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33125 === (9))){
var inst_33089 = (state_33124[(8)]);
var inst_33092 = fluree.db.storage.core.read_block(conn,network,dbid,inst_33089);
var state_33124__$1 = state_33124;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33124__$1,(11),inst_33092);
} else {
if((state_val_33125 === (5))){
var _ = (function (){var statearr_33148 = state_33124;
(statearr_33148[(4)] = cljs.core.rest((state_33124[(4)])));

return statearr_33148;
})();
var state_33124__$1 = state_33124;
var ex33144 = (state_33124__$1[(2)]);
var statearr_33149_33183 = state_33124__$1;
(statearr_33149_33183[(5)] = ex33144);


if((ex33144 instanceof Error)){
var statearr_33150_33184 = state_33124__$1;
(statearr_33150_33184[(1)] = (4));

(statearr_33150_33184[(5)] = null);

} else {
throw ex33144;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33125 === (14))){
var inst_33100 = (state_33124[(2)]);
var state_33124__$1 = state_33124;
if(cljs.core.truth_(inst_33100)){
var statearr_33151_33185 = state_33124__$1;
(statearr_33151_33185[(1)] = (15));

} else {
var statearr_33152_33186 = state_33124__$1;
(statearr_33152_33186[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33125 === (16))){
var inst_33089 = (state_33124[(8)]);
var inst_33103 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33089,end);
var state_33124__$1 = state_33124;
if(inst_33103){
var statearr_33153_33187 = state_33124__$1;
(statearr_33153_33187[(1)] = (18));

} else {
var statearr_33154_33188 = state_33124__$1;
(statearr_33154_33188[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33125 === (10))){
var inst_33119 = (state_33124[(2)]);
var _ = (function (){var statearr_33155 = state_33124;
(statearr_33155[(4)] = cljs.core.rest((state_33124[(4)])));

return statearr_33155;
})();
var state_33124__$1 = state_33124;
var statearr_33156_33189 = state_33124__$1;
(statearr_33156_33189[(2)] = inst_33119);

(statearr_33156_33189[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33125 === (18))){
var inst_33090 = (state_33124[(7)]);
var inst_33094 = (state_33124[(9)]);
var inst_33105 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33090,inst_33094);
var state_33124__$1 = state_33124;
var statearr_33157_33190 = state_33124__$1;
(statearr_33157_33190[(2)] = inst_33105);

(statearr_33157_33190[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33125 === (8))){
var inst_33085 = (state_33124[(2)]);
var inst_33086 = cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(conn);
var inst_33087 = start;
var inst_33088 = cljs.core.PersistentVector.EMPTY;
var inst_33089 = inst_33087;
var inst_33090 = inst_33088;
var state_33124__$1 = (function (){var statearr_33158 = state_33124;
(statearr_33158[(8)] = inst_33089);

(statearr_33158[(7)] = inst_33090);

(statearr_33158[(11)] = inst_33086);

(statearr_33158[(12)] = inst_33085);

return statearr_33158;
})();
var statearr_33159_33191 = state_33124__$1;
(statearr_33159_33191[(2)] = null);

(statearr_33159_33191[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__15091__auto__ = null;
var fluree$db$storage$core$state_machine__15091__auto____0 = (function (){
var statearr_33160 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33160[(0)] = fluree$db$storage$core$state_machine__15091__auto__);

(statearr_33160[(1)] = (1));

return statearr_33160;
});
var fluree$db$storage$core$state_machine__15091__auto____1 = (function (state_33124){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_33124);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e33161){var ex__15094__auto__ = e33161;
var statearr_33162_33192 = state_33124;
(statearr_33162_33192[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_33124[(4)]))){
var statearr_33163_33193 = state_33124;
(statearr_33163_33193[(1)] = cljs.core.first((state_33124[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__33194 = state_33124;
state_33124 = G__33194;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__15091__auto__ = function(state_33124){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__15091__auto____1.call(this,state_33124);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__15091__auto____0;
fluree$db$storage$core$state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__15091__auto____1;
return fluree$db$storage$core$state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_33164 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_33164[(6)] = c__15165__auto__);

return statearr_33164;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_33210){
var state_val_33211 = (state_33210[(1)]);
if((state_val_33211 === (1))){
var state_33210__$1 = state_33210;
var statearr_33212_33226 = state_33210__$1;
(statearr_33212_33226[(2)] = null);

(statearr_33212_33226[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33211 === (2))){
var _ = (function (){var statearr_33213 = state_33210;
(statearr_33213[(4)] = cljs.core.cons((5),(state_33210[(4)])));

return statearr_33213;
})();
var inst_33201 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_33210__$1 = state_33210;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33210__$1,(6),inst_33201);
} else {
if((state_val_33211 === (3))){
var inst_33208 = (state_33210[(2)]);
var state_33210__$1 = state_33210;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33210__$1,inst_33208);
} else {
if((state_val_33211 === (4))){
var inst_33195 = (state_33210[(2)]);
var state_33210__$1 = state_33210;
var statearr_33215_33227 = state_33210__$1;
(statearr_33215_33227[(2)] = inst_33195);

(statearr_33215_33227[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33211 === (5))){
var _ = (function (){var statearr_33216 = state_33210;
(statearr_33216[(4)] = cljs.core.rest((state_33210[(4)])));

return statearr_33216;
})();
var state_33210__$1 = state_33210;
var ex33214 = (state_33210__$1[(2)]);
var statearr_33217_33228 = state_33210__$1;
(statearr_33217_33228[(5)] = ex33214);


if((ex33214 instanceof Error)){
var statearr_33218_33229 = state_33210__$1;
(statearr_33218_33229[(1)] = (4));

(statearr_33218_33229[(5)] = null);

} else {
throw ex33214;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33211 === (6))){
var inst_33203 = (state_33210[(2)]);
var inst_33204 = fluree.db.util.async.throw_err(inst_33203);
var inst_33205 = cljs.core.first(inst_33204);
var _ = (function (){var statearr_33219 = state_33210;
(statearr_33219[(4)] = cljs.core.rest((state_33210[(4)])));

return statearr_33219;
})();
var state_33210__$1 = state_33210;
var statearr_33220_33230 = state_33210__$1;
(statearr_33220_33230[(2)] = inst_33205);

(statearr_33220_33230[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__15091__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__15091__auto____0 = (function (){
var statearr_33221 = [null,null,null,null,null,null,null];
(statearr_33221[(0)] = fluree$db$storage$core$block_$_state_machine__15091__auto__);

(statearr_33221[(1)] = (1));

return statearr_33221;
});
var fluree$db$storage$core$block_$_state_machine__15091__auto____1 = (function (state_33210){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_33210);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e33222){var ex__15094__auto__ = e33222;
var statearr_33223_33231 = state_33210;
(statearr_33223_33231[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_33210[(4)]))){
var statearr_33224_33232 = state_33210;
(statearr_33224_33232[(1)] = cljs.core.first((state_33210[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__33233 = state_33210;
state_33210 = G__33233;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__15091__auto__ = function(state_33210){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__15091__auto____1.call(this,state_33210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__15091__auto____0;
fluree$db$storage$core$block_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__15091__auto____1;
return fluree$db$storage$core$block_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_33225 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_33225[(6)] = c__15165__auto__);

return statearr_33225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
