// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__5045__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_25653){
var state_val_25654 = (state_25653[(1)]);
if((state_val_25654 === (7))){
var inst_25648 = (state_25653[(2)]);
var _ = (function (){var statearr_25655 = state_25653;
(statearr_25655[(4)] = cljs.core.rest((state_25653[(4)])));

return statearr_25655;
})();
var state_25653__$1 = state_25653;
var statearr_25656_25678 = state_25653__$1;
(statearr_25656_25678[(2)] = inst_25648);

(statearr_25656_25678[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25654 === (1))){
var state_25653__$1 = state_25653;
var statearr_25657_25679 = state_25653__$1;
(statearr_25657_25679[(2)] = null);

(statearr_25657_25679[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25654 === (4))){
var inst_25610 = (state_25653[(2)]);
var state_25653__$1 = state_25653;
var statearr_25658_25680 = state_25653__$1;
(statearr_25658_25680[(2)] = inst_25610);

(statearr_25658_25680[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25654 === (6))){
var inst_25628 = (state_25653[(7)]);
var inst_25635 = (state_25653[(8)]);
var inst_25634 = cljs.core.seq(inst_25628);
var inst_25635__$1 = cljs.core.first(inst_25634);
var inst_25636 = cljs.core.next(inst_25634);
var inst_25637 = cljs.core.not(inst_25635__$1);
var state_25653__$1 = (function (){var statearr_25659 = state_25653;
(statearr_25659[(8)] = inst_25635__$1);

(statearr_25659[(9)] = inst_25636);

return statearr_25659;
})();
if(inst_25637){
var statearr_25660_25681 = state_25653__$1;
(statearr_25660_25681[(1)] = (8));

} else {
var statearr_25661_25682 = state_25653__$1;
(statearr_25661_25682[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25654 === (3))){
var inst_25651 = (state_25653[(2)]);
var state_25653__$1 = state_25653;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25653__$1,inst_25651);
} else {
if((state_val_25654 === (2))){
var _ = (function (){var statearr_25662 = state_25653;
(statearr_25662[(4)] = cljs.core.cons((5),(state_25653[(4)])));

return statearr_25662;
})();
var inst_25623 = chs;
var inst_25624 = cljs.core.seq(inst_25623);
var inst_25625 = cljs.core.first(inst_25624);
var inst_25626 = cljs.core.next(inst_25624);
var inst_25627 = coll;
var inst_25628 = inst_25623;
var inst_25629 = inst_25627;
var state_25653__$1 = (function (){var statearr_25663 = state_25653;
(statearr_25663[(7)] = inst_25628);

(statearr_25663[(10)] = inst_25626);

(statearr_25663[(11)] = inst_25629);

(statearr_25663[(12)] = inst_25625);

return statearr_25663;
})();
var statearr_25664_25683 = state_25653__$1;
(statearr_25664_25683[(2)] = null);

(statearr_25664_25683[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25654 === (11))){
var inst_25629 = (state_25653[(11)]);
var inst_25636 = (state_25653[(9)]);
var inst_25641 = (state_25653[(2)]);
var inst_25642 = fluree.db.util.async.throw_err(inst_25641);
var inst_25643 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25629,inst_25642);
var inst_25628 = inst_25636;
var inst_25629__$1 = inst_25643;
var state_25653__$1 = (function (){var statearr_25666 = state_25653;
(statearr_25666[(7)] = inst_25628);

(statearr_25666[(11)] = inst_25629__$1);

return statearr_25666;
})();
var statearr_25667_25684 = state_25653__$1;
(statearr_25667_25684[(2)] = null);

(statearr_25667_25684[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25654 === (9))){
var inst_25635 = (state_25653[(8)]);
var state_25653__$1 = state_25653;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25653__$1,(11),inst_25635);
} else {
if((state_val_25654 === (5))){
var _ = (function (){var statearr_25668 = state_25653;
(statearr_25668[(4)] = cljs.core.rest((state_25653[(4)])));

return statearr_25668;
})();
var state_25653__$1 = state_25653;
var ex25665 = (state_25653__$1[(2)]);
var statearr_25669_25685 = state_25653__$1;
(statearr_25669_25685[(5)] = ex25665);


var statearr_25670_25686 = state_25653__$1;
(statearr_25670_25686[(1)] = (4));

(statearr_25670_25686[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_25654 === (10))){
var inst_25646 = (state_25653[(2)]);
var state_25653__$1 = state_25653;
var statearr_25671_25687 = state_25653__$1;
(statearr_25671_25687[(2)] = inst_25646);

(statearr_25671_25687[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25654 === (8))){
var inst_25629 = (state_25653[(11)]);
var state_25653__$1 = state_25653;
var statearr_25672_25688 = state_25653__$1;
(statearr_25672_25688[(2)] = inst_25629);

(statearr_25672_25688[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__15091__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__15091__auto____0 = (function (){
var statearr_25673 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25673[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__15091__auto__);

(statearr_25673[(1)] = (1));

return statearr_25673;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__15091__auto____1 = (function (state_25653){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_25653);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e25674){var ex__15094__auto__ = e25674;
var statearr_25675_25689 = state_25653;
(statearr_25675_25689[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_25653[(4)]))){
var statearr_25676_25690 = state_25653;
(statearr_25676_25690[(1)] = cljs.core.first((state_25653[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__25691 = state_25653;
state_25653 = G__25691;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__15091__auto__ = function(state_25653){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__15091__auto____1.call(this,state_25653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__15091__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__15091__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_25677 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_25677[(6)] = c__15165__auto__);

return statearr_25677;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_25717){
var state_val_25718 = (state_25717[(1)]);
if((state_val_25718 === (7))){
var inst_25712 = (state_25717[(2)]);
var _ = (function (){var statearr_25719 = state_25717;
(statearr_25719[(4)] = cljs.core.rest((state_25717[(4)])));

return statearr_25719;
})();
var state_25717__$1 = state_25717;
var statearr_25720_25742 = state_25717__$1;
(statearr_25720_25742[(2)] = inst_25712);

(statearr_25720_25742[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25718 === (1))){
var state_25717__$1 = state_25717;
var statearr_25721_25743 = state_25717__$1;
(statearr_25721_25743[(2)] = null);

(statearr_25721_25743[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25718 === (4))){
var inst_25692 = (state_25717[(2)]);
var state_25717__$1 = state_25717;
var statearr_25722_25744 = state_25717__$1;
(statearr_25722_25744[(2)] = inst_25692);

(statearr_25722_25744[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25718 === (6))){
var state_25717__$1 = state_25717;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25717__$1,(8),chan);
} else {
if((state_val_25718 === (3))){
var inst_25715 = (state_25717[(2)]);
var state_25717__$1 = state_25717;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25717__$1,inst_25715);
} else {
if((state_val_25718 === (2))){
var _ = (function (){var statearr_25723 = state_25717;
(statearr_25723[(4)] = cljs.core.cons((5),(state_25717[(4)])));

return statearr_25723;
})();
var inst_25698 = coll;
var inst_25699 = inst_25698;
var state_25717__$1 = (function (){var statearr_25724 = state_25717;
(statearr_25724[(7)] = inst_25699);

return statearr_25724;
})();
var statearr_25725_25745 = state_25717__$1;
(statearr_25725_25745[(2)] = null);

(statearr_25725_25745[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25718 === (11))){
var inst_25710 = (state_25717[(2)]);
var state_25717__$1 = state_25717;
var statearr_25727_25746 = state_25717__$1;
(statearr_25727_25746[(2)] = inst_25710);

(statearr_25727_25746[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25718 === (9))){
var inst_25699 = (state_25717[(7)]);
var state_25717__$1 = state_25717;
var statearr_25728_25747 = state_25717__$1;
(statearr_25728_25747[(2)] = inst_25699);

(statearr_25728_25747[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25718 === (5))){
var _ = (function (){var statearr_25729 = state_25717;
(statearr_25729[(4)] = cljs.core.rest((state_25717[(4)])));

return statearr_25729;
})();
var state_25717__$1 = state_25717;
var ex25726 = (state_25717__$1[(2)]);
var statearr_25730_25748 = state_25717__$1;
(statearr_25730_25748[(5)] = ex25726);


var statearr_25731_25749 = state_25717__$1;
(statearr_25731_25749[(1)] = (4));

(statearr_25731_25749[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_25718 === (10))){
var inst_25703 = (state_25717[(8)]);
var inst_25699 = (state_25717[(7)]);
var inst_25707 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25699,inst_25703);
var inst_25699__$1 = inst_25707;
var state_25717__$1 = (function (){var statearr_25732 = state_25717;
(statearr_25732[(7)] = inst_25699__$1);

return statearr_25732;
})();
var statearr_25733_25750 = state_25717__$1;
(statearr_25733_25750[(2)] = null);

(statearr_25733_25750[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25718 === (8))){
var inst_25703 = (state_25717[(8)]);
var inst_25702 = (state_25717[(2)]);
var inst_25703__$1 = fluree.db.util.async.throw_err(inst_25702);
var inst_25704 = (inst_25703__$1 == null);
var state_25717__$1 = (function (){var statearr_25734 = state_25717;
(statearr_25734[(8)] = inst_25703__$1);

return statearr_25734;
})();
if(cljs.core.truth_(inst_25704)){
var statearr_25735_25751 = state_25717__$1;
(statearr_25735_25751[(1)] = (9));

} else {
var statearr_25736_25752 = state_25717__$1;
(statearr_25736_25752[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__15091__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__15091__auto____0 = (function (){
var statearr_25737 = [null,null,null,null,null,null,null,null,null];
(statearr_25737[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__15091__auto__);

(statearr_25737[(1)] = (1));

return statearr_25737;
});
var fluree$db$util$async$into_QMARK__$_state_machine__15091__auto____1 = (function (state_25717){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_25717);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e25738){var ex__15094__auto__ = e25738;
var statearr_25739_25753 = state_25717;
(statearr_25739_25753[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_25717[(4)]))){
var statearr_25740_25754 = state_25717;
(statearr_25740_25754[(1)] = cljs.core.first((state_25717[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__25755 = state_25717;
state_25717 = G__25755;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__15091__auto__ = function(state_25717){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__15091__auto____1.call(this,state_25717);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__15091__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__15091__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_25741 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_25741[(6)] = c__15165__auto__);

return statearr_25741;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
