// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.json');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.bytes');
goog.require('fluree.db.util.core');
goog.require('goog.object');
goog.scope(function(){
fluree.db.util.json.goog$module$goog$object = goog.module.get('goog.object');
});
fluree.db.util.json.clj__GT_js_SINGLEQUOTE_ = (function fluree$db$util$json$clj__GT_js_SINGLEQUOTE_(var_args){
var G__28067 = arguments.length;
switch (G__28067) {
case 1:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(x,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$keyword_DASH_fn,fluree.db.util.core.keyword__GT_str], null));
}));

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 = (function (x,options){
var map__28068 = options;
var map__28068__$1 = cljs.core.__destructure_map(map__28068);
var keyword_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28068__$1,cljs.core.cst$kw$keyword_DASH_fn);
var keyfn = (function fluree$db$util$json$keyfn(k){
return cljs.core.key__GT_js.cljs$core$IFn$_invoke$arity$2(k,thisfn);
});
var thisfn = (function fluree$db$util$json$thisfn(x__$1){
if((x__$1 == null)){
return null;
} else {
if((((!((x__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === x__$1.cljs$core$IEncodeJS$))))?true:(((!x__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,x__$1):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,x__$1))){
return cljs.core._clj__GT_js(x__$1);
} else {
if((x__$1 instanceof cljs.core.Keyword)){
return (keyword_fn.cljs$core$IFn$_invoke$arity$1 ? keyword_fn.cljs$core$IFn$_invoke$arity$1(x__$1) : keyword_fn.call(null,x__$1));
} else {
if((x__$1 instanceof cljs.core.Symbol)){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x__$1);
} else {
if(cljs.core.map_QMARK_(x__$1)){
var m = ({});
var seq__28107_28140 = cljs.core.seq(x__$1);
var chunk__28108_28141 = null;
var count__28109_28142 = (0);
var i__28110_28143 = (0);
while(true){
if((i__28110_28143 < count__28109_28142)){
var vec__28123_28144 = chunk__28108_28141.cljs$core$IIndexed$_nth$arity$2(null,i__28110_28143);
var k_28145 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28123_28144,(0),null);
var v_28146 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28123_28144,(1),null);
var G__28126_28147 = m;
var G__28127_28148 = keyfn(k_28145);
var G__28128_28149 = fluree$db$util$json$thisfn(v_28146);
fluree.db.util.json.goog$module$goog$object.set.call(null,G__28126_28147,G__28127_28148,G__28128_28149);


var G__28150 = seq__28107_28140;
var G__28151 = chunk__28108_28141;
var G__28152 = count__28109_28142;
var G__28153 = (i__28110_28143 + (1));
seq__28107_28140 = G__28150;
chunk__28108_28141 = G__28151;
count__28109_28142 = G__28152;
i__28110_28143 = G__28153;
continue;
} else {
var temp__5804__auto___28154 = cljs.core.seq(seq__28107_28140);
if(temp__5804__auto___28154){
var seq__28107_28155__$1 = temp__5804__auto___28154;
if(cljs.core.chunked_seq_QMARK_(seq__28107_28155__$1)){
var c__5567__auto___28156 = cljs.core.chunk_first(seq__28107_28155__$1);
var G__28157 = cljs.core.chunk_rest(seq__28107_28155__$1);
var G__28158 = c__5567__auto___28156;
var G__28159 = cljs.core.count(c__5567__auto___28156);
var G__28160 = (0);
seq__28107_28140 = G__28157;
chunk__28108_28141 = G__28158;
count__28109_28142 = G__28159;
i__28110_28143 = G__28160;
continue;
} else {
var vec__28129_28161 = cljs.core.first(seq__28107_28155__$1);
var k_28162 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28129_28161,(0),null);
var v_28163 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28129_28161,(1),null);
var G__28132_28164 = m;
var G__28133_28165 = keyfn(k_28162);
var G__28134_28166 = fluree$db$util$json$thisfn(v_28163);
fluree.db.util.json.goog$module$goog$object.set.call(null,G__28132_28164,G__28133_28165,G__28134_28166);


var G__28167 = cljs.core.next(seq__28107_28155__$1);
var G__28168 = null;
var G__28169 = (0);
var G__28170 = (0);
seq__28107_28140 = G__28167;
chunk__28108_28141 = G__28168;
count__28109_28142 = G__28169;
i__28110_28143 = G__28170;
continue;
}
} else {
}
}
break;
}

return m;
} else {
if(cljs.core.coll_QMARK_(x__$1)){
var arr = [];
var seq__28135_28171 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree$db$util$json$thisfn,x__$1));
var chunk__28136_28172 = null;
var count__28137_28173 = (0);
var i__28138_28174 = (0);
while(true){
if((i__28138_28174 < count__28137_28173)){
var x_28175__$2 = chunk__28136_28172.cljs$core$IIndexed$_nth$arity$2(null,i__28138_28174);
arr.push(x_28175__$2);


var G__28176 = seq__28135_28171;
var G__28177 = chunk__28136_28172;
var G__28178 = count__28137_28173;
var G__28179 = (i__28138_28174 + (1));
seq__28135_28171 = G__28176;
chunk__28136_28172 = G__28177;
count__28137_28173 = G__28178;
i__28138_28174 = G__28179;
continue;
} else {
var temp__5804__auto___28180 = cljs.core.seq(seq__28135_28171);
if(temp__5804__auto___28180){
var seq__28135_28181__$1 = temp__5804__auto___28180;
if(cljs.core.chunked_seq_QMARK_(seq__28135_28181__$1)){
var c__5567__auto___28182 = cljs.core.chunk_first(seq__28135_28181__$1);
var G__28183 = cljs.core.chunk_rest(seq__28135_28181__$1);
var G__28184 = c__5567__auto___28182;
var G__28185 = cljs.core.count(c__5567__auto___28182);
var G__28186 = (0);
seq__28135_28171 = G__28183;
chunk__28136_28172 = G__28184;
count__28137_28173 = G__28185;
i__28138_28174 = G__28186;
continue;
} else {
var x_28187__$2 = cljs.core.first(seq__28135_28181__$1);
arr.push(x_28187__$2);


var G__28188 = cljs.core.next(seq__28135_28181__$1);
var G__28189 = null;
var G__28190 = (0);
var G__28191 = (0);
seq__28135_28171 = G__28188;
chunk__28136_28172 = G__28189;
count__28137_28173 = G__28190;
i__28138_28174 = G__28191;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
return x__$1;

}
}
}
}
}
}
});
return thisfn(x);
}));

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$lang$maxFixedArity = 2);

fluree.db.util.json.parse = (function fluree$db$util$json$parse(x){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(JSON.parse(((typeof x === 'string')?x:fluree.db.util.bytes.UTF8__GT_string(x))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
fluree.db.util.json.stringify_preserve_namespace = (function fluree$db$util$json$stringify_preserve_namespace(x){
return JSON.stringify(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1(x));
});
fluree.db.util.json.stringify = (function fluree$db$util$json$stringify(x){
return JSON.stringify(cljs.core.clj__GT_js(x));
});
fluree.db.util.json.stringify_UTF8 = (function fluree$db$util$json$stringify_UTF8(x){
return fluree.db.util.bytes.string__GT_UTF8(fluree.db.util.json.stringify(x));
});
/**
 * Given a sequence of coordinates, ensure that, for the given depth:
 * 1) they contain only sequences until
 * 2) they contain only numbers at depth 1
 */
fluree.db.util.json.valid_coordinates_QMARK_ = (function fluree$db$util$json$valid_coordinates_QMARK_(depth,coordinates){
if((depth > (0))){
} else {
throw (new Error("Assert failed: (pos? depth)"));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),depth)){
return ((cljs.core.every_QMARK_(cljs.core.number_QMARK_,coordinates)) && (((2) <= cljs.core.count(coordinates))));
} else {
return (((!((coordinates == null)))) && (((cljs.core.every_QMARK_(cljs.core.sequential_QMARK_,coordinates)) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__28192_SHARP_){
var G__28193 = (depth - (1));
var G__28194 = p1__28192_SHARP_;
return (fluree.db.util.json.valid_coordinates_QMARK_.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.json.valid_coordinates_QMARK_.cljs$core$IFn$_invoke$arity$2(G__28193,G__28194) : fluree.db.util.json.valid_coordinates_QMARK_.call(null,G__28193,G__28194));
}),coordinates))))));
}
});
/**
 * Checks to make sure that the given coordinates are valid linear rings, which
 * is a requirement for Polygon types.
 */
fluree.db.util.json.linear_ring_QMARK_ = (function fluree$db$util$json$linear_ring_QMARK_(coordinates){
return ((cljs.core.sequential_QMARK_(coordinates)) && (((((4) <= cljs.core.count(coordinates))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(coordinates),cljs.core.last(coordinates))))));
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.util !== 'undefined') && (typeof fluree.db.util.json !== 'undefined') && (typeof fluree.db.util.json.valid_geojson_QMARK_ !== 'undefined')){
} else {
fluree.db.util.json.valid_geojson_QMARK_ = (function (){var method_table__5641__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5645__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__28195 = cljs.core.get_global_hierarchy;
return (fexpr__28195.cljs$core$IFn$_invoke$arity$0 ? fexpr__28195.cljs$core$IFn$_invoke$arity$0() : fexpr__28195.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.util.json","valid-geojson?"),cljs.core.cst$kw$type,cljs.core.cst$kw$default,hierarchy__5645__auto__,method_table__5641__auto__,prefer_table__5642__auto__,method_cache__5643__auto__,cached_hierarchy__5644__auto__));
})();
}
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Feature",(function (geometry){
var and__5043__auto__ = (function (){var or__5045__auto__ = (function (){var G__28196 = cljs.core.cst$kw$geometry.cljs$core$IFn$_invoke$arity$1(geometry);
return (fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IFn$_invoke$arity$1(G__28196) : fluree.db.util.json.valid_geojson_QMARK_.call(null,G__28196));
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (cljs.core.cst$kw$geometry.cljs$core$IFn$_invoke$arity$1(geometry) == null);
}
})();
if(cljs.core.truth_(and__5043__auto__)){
return ((cljs.core.map_QMARK_(cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(geometry))) || ((cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(geometry) == null)));
} else {
return and__5043__auto__;
}
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"FeatureCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.util.json.valid_geojson_QMARK_,cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"GeometryCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_(cljs.core.cst$kw$geometries.cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.util.json.valid_geojson_QMARK_,cljs.core.cst$kw$geometries.cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Point",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((1),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"LineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((2),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Polygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_((3),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(fluree.db.util.json.linear_ring_QMARK_,cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiPoint",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((2),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiLineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((3),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiPolygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_((4),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_((function (p1__28197_SHARP_){
return cljs.core.every_QMARK_(fluree.db.util.json.linear_ring_QMARK_,p1__28197_SHARP_);
}),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (geometry){
return false;
}));
