// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
fluree.db.util.xhttp.node$module$axios = require('axios');
fluree.db.util.xhttp.node$module$ws = require('ws');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5804__auto__ = e.response;
if(cljs.core.truth_(temp__5804__auto__)){
var resp = temp__5804__auto__;
var temp__5804__auto____$1 = resp.status;
if(cljs.core.truth_(temp__5804__auto____$1)){
var st = temp__5804__auto____$1;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
})();
var error = ((clojure.string.starts_with_QMARK_(e.message,"timeout"))?cljs.core.cst$kw$xhttp_SLASH_timeout:(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return ((((300) <= status)) && ((status <= (499))));
} else {
return and__5043__auto__;
}
})())?cljs.core.cst$kw$xhttp_SLASH_http_DASH_error:(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return (status >= (500));
} else {
return and__5043__auto__;
}
})())?cljs.core.cst$kw$xhttp_SLASH_exception:(function (){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["XHTTP Request Error:",e.request], 0));

return cljs.core.cst$kw$xhttp_SLASH_unknown_DASH_error;
})()

)));
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return (status > (0));
} else {
return and__5043__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__34270 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$error,error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__34270,cljs.core.cst$kw$status,status);
} else {
return G__34270;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__34271 = opts;
var map__34271__$1 = cljs.core.__destructure_map(map__34271);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34271__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34271__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34271__$1,cljs.core.cst$kw$headers);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__34272 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__34272__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__34272,headers], 0)):G__34272);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__34272__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__34272__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$method,"post",cljs.core.cst$kw$timeout,request_timeout,cljs.core.cst$kw$headers,headers__$1,cljs.core.cst$kw$data,message], null))).then((function (resp){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0))));
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__34273 = opts;
var map__34273__$1 = cljs.core.__destructure_map(map__34273);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34273__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34273__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34273__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34273__$1,cljs.core.cst$kw$body);
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34273__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$text);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__34274 = cljs.core.PersistentArrayMap.EMPTY;
var G__34274__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__34274,headers], 0)):G__34274);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__34274__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__34274__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$method,"get",cljs.core.cst$kw$timeout,request_timeout,cljs.core.cst$kw$headers,headers__$1], null))).then((function (resp){
var data = cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0)));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__34275 = output_format;
var G__34275__$1 = (((G__34275 instanceof cljs.core.Keyword))?G__34275.fqn:null);
switch (G__34275__$1) {
case "text":
return data;

break;
case "json":
return fluree.db.util.json.stringify(data);

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__34277 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"Accept"], null),"application/json"),cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$json);
if(cljs.core.truth_(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__34277,cljs.core.cst$kw$body,fluree.db.util.json.stringify(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__34277;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__15165__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_34309){
var state_val_34310 = (state_34309[(1)]);
if((state_val_34310 === (7))){
var inst_34305 = (state_34309[(2)]);
var state_34309__$1 = state_34309;
var statearr_34311_34336 = state_34309__$1;
(statearr_34311_34336[(2)] = inst_34305);

(statearr_34311_34336[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34310 === (1))){
var state_34309__$1 = state_34309;
var statearr_34312_34337 = state_34309__$1;
(statearr_34312_34337[(2)] = null);

(statearr_34312_34337[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34310 === (4))){
var inst_34280 = (state_34309[(7)]);
var inst_34280__$1 = (state_34309[(2)]);
var inst_34281 = (inst_34280__$1 == null);
var state_34309__$1 = (function (){var statearr_34313 = state_34309;
(statearr_34313[(7)] = inst_34280__$1);

return statearr_34313;
})();
if(cljs.core.truth_(inst_34281)){
var statearr_34314_34338 = state_34309__$1;
(statearr_34314_34338[(1)] = (5));

} else {
var statearr_34315_34339 = state_34309__$1;
(statearr_34315_34339[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34310 === (6))){
var inst_34280 = (state_34309[(7)]);
var inst_34288 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34280,(0),null);
var inst_34289 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34280,(1),null);
var state_34309__$1 = (function (){var statearr_34316 = state_34309;
(statearr_34316[(8)] = inst_34289);

(statearr_34316[(9)] = inst_34288);

return statearr_34316;
})();
var statearr_34317_34340 = state_34309__$1;
(statearr_34317_34340[(2)] = null);

(statearr_34317_34340[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34310 === (3))){
var inst_34307 = (state_34309[(2)]);
var state_34309__$1 = state_34309;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34309__$1,inst_34307);
} else {
if((state_val_34310 === (2))){
var state_34309__$1 = state_34309;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34309__$1,(4),pub_chan);
} else {
if((state_val_34310 === (11))){
var _ = (function (){var statearr_34319 = state_34309;
(statearr_34319[(4)] = cljs.core.rest((state_34309[(4)])));

return statearr_34319;
})();
var state_34309__$1 = state_34309;
var ex34318 = (state_34309__$1[(2)]);
var statearr_34320_34341 = state_34309__$1;
(statearr_34320_34341[(5)] = ex34318);


var statearr_34321_34342 = state_34309__$1;
(statearr_34321_34342[(1)] = (10));

(statearr_34321_34342[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_34310 === (9))){
var inst_34302 = (state_34309[(2)]);
var state_34309__$1 = (function (){var statearr_34322 = state_34309;
(statearr_34322[(10)] = inst_34302);

return statearr_34322;
})();
var statearr_34323_34343 = state_34309__$1;
(statearr_34323_34343[(2)] = null);

(statearr_34323_34343[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34310 === (5))){
var inst_34283 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_34309__$1 = state_34309;
var statearr_34324_34344 = state_34309__$1;
(statearr_34324_34344[(2)] = inst_34283);

(statearr_34324_34344[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34310 === (10))){
var inst_34289 = (state_34309[(8)]);
var inst_34288 = (state_34309[(9)]);
var inst_34290 = (state_34309[(2)]);
var inst_34291 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_34290,"Error sending websocket message:",inst_34288], 0));
var inst_34292 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_34289,false);
var state_34309__$1 = (function (){var statearr_34325 = state_34309;
(statearr_34325[(11)] = inst_34291);

return statearr_34325;
})();
var statearr_34326_34345 = state_34309__$1;
(statearr_34326_34345[(2)] = inst_34292);

(statearr_34326_34345[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34310 === (8))){
var inst_34289 = (state_34309[(8)]);
var inst_34288 = (state_34309[(9)]);
var _ = (function (){var statearr_34327 = state_34309;
(statearr_34327[(4)] = cljs.core.cons((11),(state_34309[(4)])));

return statearr_34327;
})();
var inst_34298 = ws.send(inst_34288);
var inst_34299 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_34289,true);
var ___$1 = (function (){var statearr_34328 = state_34309;
(statearr_34328[(4)] = cljs.core.rest((state_34309[(4)])));

return statearr_34328;
})();
var state_34309__$1 = (function (){var statearr_34329 = state_34309;
(statearr_34329[(12)] = inst_34298);

return statearr_34329;
})();
var statearr_34330_34346 = state_34309__$1;
(statearr_34330_34346[(2)] = inst_34299);

(statearr_34330_34346[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__15091__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__15091__auto____0 = (function (){
var statearr_34331 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34331[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__15091__auto__);

(statearr_34331[(1)] = (1));

return statearr_34331;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__15091__auto____1 = (function (state_34309){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_34309);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e34332){var ex__15094__auto__ = e34332;
var statearr_34333_34347 = state_34309;
(statearr_34333_34347[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_34309[(4)]))){
var statearr_34334_34348 = state_34309;
(statearr_34334_34348[(1)] = cljs.core.first((state_34309[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__34349 = state_34309;
state_34309 = G__34349;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__15091__auto__ = function(state_34309){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__15091__auto____1.call(this,state_34309);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__15091__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__15091__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_34335 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_34335[(6)] = c__15165__auto__);

return statearr_34335;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));

return c__15165__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (((cljs.core._STAR_target_STAR_ === "nodejs"))?(new fluree.db.util.xhttp.node$module$ws(url)):(new WebSocket(url)));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__15165__auto___34387 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__15166__auto__ = (function (){var switch__15090__auto__ = (function (state_34374){
var state_val_34375 = (state_34374[(1)]);
if((state_val_34375 === (1))){
var inst_34353 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34354 = [open_QMARK_,timeout_chan];
var inst_34355 = (new cljs.core.PersistentVector(null,2,(5),inst_34353,inst_34354,null));
var state_34374__$1 = state_34374;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_34374__$1,(2),inst_34355,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$priority,true], 0));
} else {
if((state_val_34375 === (2))){
var inst_34357 = (state_34374[(2)]);
var inst_34358 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34357,(0),null);
var inst_34359 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34357,(1),null);
var inst_34360 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34359,timeout_chan);
var state_34374__$1 = (function (){var statearr_34376 = state_34374;
(statearr_34376[(7)] = inst_34358);

return statearr_34376;
})();
if(inst_34360){
var statearr_34377_34388 = state_34374__$1;
(statearr_34377_34388[(1)] = (3));

} else {
var statearr_34378_34389 = state_34374__$1;
(statearr_34378_34389[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34375 === (3))){
var inst_34362 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_34363 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34364 = [(400),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_34365 = cljs.core.PersistentHashMap.fromArrays(inst_34363,inst_34364);
var inst_34366 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34362,inst_34365);
var inst_34367 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_34366);
var inst_34368 = fluree.db.util.xhttp.close_websocket(ws);
var state_34374__$1 = (function (){var statearr_34379 = state_34374;
(statearr_34379[(8)] = inst_34367);

return statearr_34379;
})();
var statearr_34380_34390 = state_34374__$1;
(statearr_34380_34390[(2)] = inst_34368);

(statearr_34380_34390[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34375 === (4))){
var inst_34370 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_34374__$1 = state_34374;
var statearr_34381_34391 = state_34374__$1;
(statearr_34381_34391[(2)] = inst_34370);

(statearr_34381_34391[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34375 === (5))){
var inst_34372 = (state_34374[(2)]);
var state_34374__$1 = state_34374;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34374__$1,inst_34372);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__15091__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__15091__auto____0 = (function (){
var statearr_34382 = [null,null,null,null,null,null,null,null,null];
(statearr_34382[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__15091__auto__);

(statearr_34382[(1)] = (1));

return statearr_34382;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__15091__auto____1 = (function (state_34374){
while(true){
var ret_value__15092__auto__ = (function (){try{while(true){
var result__15093__auto__ = switch__15090__auto__(state_34374);
if(cljs.core.keyword_identical_QMARK_(result__15093__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15093__auto__;
}
break;
}
}catch (e34383){var ex__15094__auto__ = e34383;
var statearr_34384_34392 = state_34374;
(statearr_34384_34392[(2)] = ex__15094__auto__);


if(cljs.core.seq((state_34374[(4)]))){
var statearr_34385_34393 = state_34374;
(statearr_34385_34393[(1)] = cljs.core.first((state_34374[(4)])));

} else {
throw ex__15094__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15092__auto__,cljs.core.cst$kw$recur)){
var G__34394 = state_34374;
state_34374 = G__34394;
continue;
} else {
return ret_value__15092__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__15091__auto__ = function(state_34374){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__15091__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__15091__auto____1.call(this,state_34374);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__15091__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__15091__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__15091__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__15091__auto__;
})()
})();
var state__15167__auto__ = (function (){var statearr_34386 = (f__15166__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15166__auto__.cljs$core$IFn$_invoke$arity$0() : f__15166__auto__.call(null));
(statearr_34386[(6)] = c__15165__auto___34387);

return statearr_34386;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15167__auto__);
}));


return cljs.core.cst$kw$fluree$db$util$xhttp_SLASH_no_DASH_return;
});
