// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$column,col], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.get.cljs$core$IFn$_invoke$arity$2(text,counter))){
var G__78470 = (line + (1));
var G__78471 = (1);
var G__78472 = (counter + (1));
line = G__78470;
col = G__78471;
counter = G__78472;
continue;
} else {
var G__78473 = line;
var G__78474 = (col + (1));
var G__78475 = (counter + (1));
line = G__78473;
col = G__78474;
counter = G__78475;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq(clojure.string.replace(text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_(chars)){
return "";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n__$1,(1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.first(chars))){
var G__78476 = cljs.core.next(chars);
var G__78477 = (n__$1 - (1));
chars = G__78476;
n__$1 = G__78477;
continue;
} else {
var G__78478 = cljs.core.next(chars);
var G__78479 = n__$1;
chars = G__78478;
n__$1 = G__78479;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 * and accounts for horizontal tabs which might change
 * the alignment of the '^' to the error location.
 */
instaparse.failure.marker = (function instaparse$failure$marker(text,n){
if(cljs.core.truth_((function (){var and__5043__auto__ = text;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.integer_QMARK_(n);
} else {
return and__5043__auto__;
}
})())){
var marker_text = clojure.string.replace(text,/[^\s]/," ");
if((n <= (1))){
return "^";
} else {
return [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(marker_text,(0),(n - (1))),"^"].join('');
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column(cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([failure,lc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$text,instaparse.failure.get_line(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(lc),text)], null)], 0));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NOT "], 0));

return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r)], 0));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$char_DASH_range.cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.char_range__GT_str(r)], 0));
} else {
if((r instanceof RegExp)){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.regexp__GT_str(r)], 0));
} else {
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([r], 0));

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__78480){
var map__78481 = p__78480;
var map__78481__$1 = cljs.core.__destructure_map(map__78481);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78481__$1,cljs.core.cst$kw$line);
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78481__$1,cljs.core.cst$kw$column);
var text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78481__$1,cljs.core.cst$kw$text);
var reason = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78481__$1,cljs.core.cst$kw$reason);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join('')], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([text], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.failure.marker(text,column)], 0));

var full_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full,reason)));
var partial_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(cljs.core.cst$kw$full),reason)));
var total = (cljs.core.count(full_reasons) + cljs.core.count(partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),total)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected:"], 0));
} else {
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected one of:"], 0));

}
}

var seq__78482_78490 = cljs.core.seq(full_reasons);
var chunk__78483_78491 = null;
var count__78484_78492 = (0);
var i__78485_78493 = (0);
while(true){
if((i__78485_78493 < count__78484_78492)){
var r_78494 = chunk__78483_78491.cljs$core$IIndexed$_nth$arity$2(null,i__78485_78493);
instaparse.failure.print_reason(r_78494);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__78495 = seq__78482_78490;
var G__78496 = chunk__78483_78491;
var G__78497 = count__78484_78492;
var G__78498 = (i__78485_78493 + (1));
seq__78482_78490 = G__78495;
chunk__78483_78491 = G__78496;
count__78484_78492 = G__78497;
i__78485_78493 = G__78498;
continue;
} else {
var temp__5804__auto___78499 = cljs.core.seq(seq__78482_78490);
if(temp__5804__auto___78499){
var seq__78482_78500__$1 = temp__5804__auto___78499;
if(cljs.core.chunked_seq_QMARK_(seq__78482_78500__$1)){
var c__5567__auto___78501 = cljs.core.chunk_first(seq__78482_78500__$1);
var G__78502 = cljs.core.chunk_rest(seq__78482_78500__$1);
var G__78503 = c__5567__auto___78501;
var G__78504 = cljs.core.count(c__5567__auto___78501);
var G__78505 = (0);
seq__78482_78490 = G__78502;
chunk__78483_78491 = G__78503;
count__78484_78492 = G__78504;
i__78485_78493 = G__78505;
continue;
} else {
var r_78506 = cljs.core.first(seq__78482_78500__$1);
instaparse.failure.print_reason(r_78506);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__78507 = cljs.core.next(seq__78482_78500__$1);
var G__78508 = null;
var G__78509 = (0);
var G__78510 = (0);
seq__78482_78490 = G__78507;
chunk__78483_78491 = G__78508;
count__78484_78492 = G__78509;
i__78485_78493 = G__78510;
continue;
}
} else {
}
}
break;
}

var seq__78486 = cljs.core.seq(partial_reasons);
var chunk__78487 = null;
var count__78488 = (0);
var i__78489 = (0);
while(true){
if((i__78489 < count__78488)){
var r = chunk__78487.cljs$core$IIndexed$_nth$arity$2(null,i__78489);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__78511 = seq__78486;
var G__78512 = chunk__78487;
var G__78513 = count__78488;
var G__78514 = (i__78489 + (1));
seq__78486 = G__78511;
chunk__78487 = G__78512;
count__78488 = G__78513;
i__78489 = G__78514;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__78486);
if(temp__5804__auto__){
var seq__78486__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__78486__$1)){
var c__5567__auto__ = cljs.core.chunk_first(seq__78486__$1);
var G__78515 = cljs.core.chunk_rest(seq__78486__$1);
var G__78516 = c__5567__auto__;
var G__78517 = cljs.core.count(c__5567__auto__);
var G__78518 = (0);
seq__78486 = G__78515;
chunk__78487 = G__78516;
count__78488 = G__78517;
i__78489 = G__78518;
continue;
} else {
var r = cljs.core.first(seq__78486__$1);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__78519 = cljs.core.next(seq__78486__$1);
var G__78520 = null;
var G__78521 = (0);
var G__78522 = (0);
seq__78486 = G__78519;
chunk__78487 = G__78520;
count__78488 = G__78521;
i__78489 = G__78522;
continue;
}
} else {
return null;
}
}
break;
}
});
