// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('tailrecursion.priority_map');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core');
goog.require('cljs.reader');

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
tailrecursion.priority_map.PersistentPriorityMap = (function (priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
this.priority__GT_set_of_items = priority__GT_set_of_items;
this.item__GT_priority = item__GT_priority;
this.meta = meta;
this.keyfn = keyfn;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2565220111;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,item,not_found){
var self__ = this;
var coll__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var self__ = this;
var coll__$1 = this;
var pr_pair = (function (keyval){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,""," ","",opts,keyval);
});
return cljs.core.pr_sequential_writer(writer,pr_pair,"#tailrecursion.priority-map {",", ","}",opts,coll__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.count(self__.item__GT_priority);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_peek$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
return null;
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item = cljs.core.first(cljs.core.val(f));
if(cljs.core.truth_(self__.keyfn)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,cljs.core.key(f)], null);
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_pop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
throw (new Error("Can't pop empty priority map"));
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item_set = cljs.core.val(f);
var item = cljs.core.first(item_set);
var priority_key = cljs.core.key(f);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__5522__auto__ = (function tailrecursion$priority_map$iter__42468(s__42469){
return (new cljs.core.LazySeq(null,(function (){
var s__42469__$1 = s__42469;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__42469__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var vec__42474 = cljs.core.first(xs__6360__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42474,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42474,(1),null);
var iterys__5518__auto__ = ((function (s__42469__$1,vec__42474,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__42468_$_iter__42470(s__42471){
return (new cljs.core.LazySeq(null,((function (s__42469__$1,vec__42474,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1){
return (function (){
var s__42471__$1 = s__42471;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__42471__$1);
if(temp__5804__auto____$1){
var s__42471__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__42471__$2)){
var c__5520__auto__ = cljs.core.chunk_first(s__42471__$2);
var size__5521__auto__ = cljs.core.count(c__5520__auto__);
var b__42473 = cljs.core.chunk_buffer(size__5521__auto__);
if((function (){var i__42472 = (0);
while(true){
if((i__42472 < size__5521__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5520__auto__,i__42472);
cljs.core.chunk_append(b__42473,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__42527 = (i__42472 + (1));
i__42472 = G__42527;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__42473),tailrecursion$priority_map$iter__42468_$_iter__42470(cljs.core.chunk_rest(s__42471__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__42473),null);
}
} else {
var item = cljs.core.first(s__42471__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__42468_$_iter__42470(cljs.core.rest(s__42471__$2)));
}
} else {
return null;
}
break;
}
});})(s__42469__$1,vec__42474,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1))
,null,null));
});})(s__42469__$1,vec__42474,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1))
;
var fs__5519__auto__ = cljs.core.seq(iterys__5518__auto__(item_set));
if(fs__5519__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__5519__auto__,tailrecursion$priority_map$iter__42468(cljs.core.rest(s__42469__$1)));
} else {
var G__42528 = cljs.core.rest(s__42469__$1);
s__42469__$1 = G__42528;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5522__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
} else {
return cljs.core.seq((function (){var iter__5522__auto__ = (function tailrecursion$priority_map$iter__42477(s__42478){
return (new cljs.core.LazySeq(null,(function (){
var s__42478__$1 = s__42478;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__42478__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var vec__42483 = cljs.core.first(xs__6360__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42483,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42483,(1),null);
var iterys__5518__auto__ = ((function (s__42478__$1,vec__42483,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__42477_$_iter__42479(s__42480){
return (new cljs.core.LazySeq(null,((function (s__42478__$1,vec__42483,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1){
return (function (){
var s__42480__$1 = s__42480;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__42480__$1);
if(temp__5804__auto____$1){
var s__42480__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__42480__$2)){
var c__5520__auto__ = cljs.core.chunk_first(s__42480__$2);
var size__5521__auto__ = cljs.core.count(c__5520__auto__);
var b__42482 = cljs.core.chunk_buffer(size__5521__auto__);
if((function (){var i__42481 = (0);
while(true){
if((i__42481 < size__5521__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5520__auto__,i__42481);
cljs.core.chunk_append(b__42482,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__42529 = (i__42481 + (1));
i__42481 = G__42529;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__42482),tailrecursion$priority_map$iter__42477_$_iter__42479(cljs.core.chunk_rest(s__42480__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__42482),null);
}
} else {
var item = cljs.core.first(s__42480__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__42477_$_iter__42479(cljs.core.rest(s__42480__$2)));
}
} else {
return null;
}
break;
}
});})(s__42478__$1,vec__42483,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1))
,null,null));
});})(s__42478__$1,vec__42483,priority,item_set,xs__6360__auto__,temp__5804__auto__,coll__$1))
;
var fs__5519__auto__ = cljs.core.seq(iterys__5518__auto__(item_set));
if(fs__5519__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__5519__auto__,tailrecursion$priority_map$iter__42477(cljs.core.rest(s__42478__$1)));
} else {
var G__42530 = cljs.core.rest(s__42478__$1);
s__42478__$1 = G__42530;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5522__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = cljs.core.hash_unordered_coll(this$__$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return cljs.core._equiv(self__.item__GT_priority,other);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.with_meta(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,self__.meta);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var priority = (function (){var G__42486 = item;
var G__42487 = cljs.core.cst$kw$tailrecursion$priority_DASH_map_SLASH_not_DASH_found;
return (self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2(G__42486,G__42487) : self__.item__GT_priority.call(null,G__42486,G__42487));
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(priority,cljs.core.cst$kw$tailrecursion$priority_DASH_map_SLASH_not_DASH_found)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var item_set = (self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1 ? self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1(priority_key) : self__.priority__GT_set_of_items.call(null,priority_key));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,item,priority){
var self__ = this;
var this$__$1 = this;
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,null);
if(cljs.core.truth_(temp__5802__auto__)){
var current_priority = temp__5802__auto__;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current_priority,priority)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var current_priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(current_priority) : self__.keyfn.call(null,current_priority));
var item_set = cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(self__.priority__GT_set_of_items,current_priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),item),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)], 0)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.contains_QMARK_(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__5522__auto__ = (function tailrecursion$priority_map$iter__42488(s__42489){
return (new cljs.core.LazySeq(null,(function (){
var s__42489__$1 = s__42489;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__42489__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var vec__42494 = cljs.core.first(xs__6360__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42494,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42494,(1),null);
var iterys__5518__auto__ = ((function (s__42489__$1,vec__42494,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__42488_$_iter__42490(s__42491){
return (new cljs.core.LazySeq(null,((function (s__42489__$1,vec__42494,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1){
return (function (){
var s__42491__$1 = s__42491;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__42491__$1);
if(temp__5804__auto____$1){
var s__42491__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__42491__$2)){
var c__5520__auto__ = cljs.core.chunk_first(s__42491__$2);
var size__5521__auto__ = cljs.core.count(c__5520__auto__);
var b__42493 = cljs.core.chunk_buffer(size__5521__auto__);
if((function (){var i__42492 = (0);
while(true){
if((i__42492 < size__5521__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5520__auto__,i__42492);
cljs.core.chunk_append(b__42493,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__42531 = (i__42492 + (1));
i__42492 = G__42531;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__42493),tailrecursion$priority_map$iter__42488_$_iter__42490(cljs.core.chunk_rest(s__42491__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__42493),null);
}
} else {
var item = cljs.core.first(s__42491__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__42488_$_iter__42490(cljs.core.rest(s__42491__$2)));
}
} else {
return null;
}
break;
}
});})(s__42489__$1,vec__42494,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1))
,null,null));
});})(s__42489__$1,vec__42494,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1))
;
var fs__5519__auto__ = cljs.core.seq(iterys__5518__auto__(item_set));
if(fs__5519__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__5519__auto__,tailrecursion$priority_map$iter__42488(cljs.core.rest(s__42489__$1)));
} else {
var G__42532 = cljs.core.rest(s__42489__$1);
s__42489__$1 = G__42532;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5522__auto__(self__.priority__GT_set_of_items);
})());
} else {
return cljs.core.seq((function (){var iter__5522__auto__ = (function tailrecursion$priority_map$iter__42497(s__42498){
return (new cljs.core.LazySeq(null,(function (){
var s__42498__$1 = s__42498;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__42498__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var vec__42503 = cljs.core.first(xs__6360__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42503,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42503,(1),null);
var iterys__5518__auto__ = ((function (s__42498__$1,vec__42503,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__42497_$_iter__42499(s__42500){
return (new cljs.core.LazySeq(null,((function (s__42498__$1,vec__42503,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1){
return (function (){
var s__42500__$1 = s__42500;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__42500__$1);
if(temp__5804__auto____$1){
var s__42500__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__42500__$2)){
var c__5520__auto__ = cljs.core.chunk_first(s__42500__$2);
var size__5521__auto__ = cljs.core.count(c__5520__auto__);
var b__42502 = cljs.core.chunk_buffer(size__5521__auto__);
if((function (){var i__42501 = (0);
while(true){
if((i__42501 < size__5521__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5520__auto__,i__42501);
cljs.core.chunk_append(b__42502,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__42533 = (i__42501 + (1));
i__42501 = G__42533;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__42502),tailrecursion$priority_map$iter__42497_$_iter__42499(cljs.core.chunk_rest(s__42500__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__42502),null);
}
} else {
var item = cljs.core.first(s__42500__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__42497_$_iter__42499(cljs.core.rest(s__42500__$2)));
}
} else {
return null;
}
break;
}
});})(s__42498__$1,vec__42503,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1))
,null,null));
});})(s__42498__$1,vec__42503,priority,item_set,xs__6360__auto__,temp__5804__auto__,this$__$1))
;
var fs__5519__auto__ = cljs.core.seq(iterys__5518__auto__(item_set));
if(fs__5519__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__5519__auto__,tailrecursion$priority_map$iter__42497(cljs.core.rest(s__42498__$1)));
} else {
var G__42534 = cljs.core.rest(s__42498__$1);
s__42498__$1 = G__42534;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5522__auto__(self__.priority__GT_set_of_items);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta__$1){
var self__ = this;
var this$__$1 = this;
return (new tailrecursion.priority_map.PersistentPriorityMap(self__.priority__GT_set_of_items,self__.item__GT_priority,meta__$1,self__.keyfn,self__.__hash));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return this$__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this$__$1,entry);
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.call = (function() {
var G__42535 = null;
var G__42535__2 = (function (self__,item){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
});
var G__42535__3 = (function (self__,item,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
});
G__42535 = function(self__,item,not_found){
switch(arguments.length){
case 2:
return G__42535__2.call(this,self__,item);
case 3:
return G__42535__3.call(this,self__,item,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__42535.cljs$core$IFn$_invoke$arity$2 = G__42535__2;
G__42535.cljs$core$IFn$_invoke$arity$3 = G__42535__3;
return G__42535;
})()
);

(tailrecursion.priority_map.PersistentPriorityMap.prototype.apply = (function (self__,args42467){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat((((args42467.length > (20)))?(function (){var G__42506 = args42467.slice((0),(20));
G__42506.push(args42467.slice((20)));

return G__42506;
})():args42467)));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (item){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (item,not_found){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var fexpr__42507 = (cljs.core.truth_(ascending_QMARK_)?cljs.core.seq:cljs.core.rseq);
return (fexpr__42507.cljs$core$IFn$_invoke$arity$1 ? fexpr__42507.cljs$core$IFn$_invoke$arity$1(this$__$1) : fexpr__42507.call(null,this$__$1));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var sets = (cljs.core.truth_(ascending_QMARK_)?cljs.core.subseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._GT__EQ_,k):cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._LT__EQ_,k));
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__5522__auto__ = (function tailrecursion$priority_map$iter__42508(s__42509){
return (new cljs.core.LazySeq(null,(function (){
var s__42509__$1 = s__42509;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__42509__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var vec__42514 = cljs.core.first(xs__6360__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42514,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42514,(1),null);
var iterys__5518__auto__ = ((function (s__42509__$1,vec__42514,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__42508_$_iter__42510(s__42511){
return (new cljs.core.LazySeq(null,((function (s__42509__$1,vec__42514,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1){
return (function (){
var s__42511__$1 = s__42511;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__42511__$1);
if(temp__5804__auto____$1){
var s__42511__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__42511__$2)){
var c__5520__auto__ = cljs.core.chunk_first(s__42511__$2);
var size__5521__auto__ = cljs.core.count(c__5520__auto__);
var b__42513 = cljs.core.chunk_buffer(size__5521__auto__);
if((function (){var i__42512 = (0);
while(true){
if((i__42512 < size__5521__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5520__auto__,i__42512);
cljs.core.chunk_append(b__42513,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__42536 = (i__42512 + (1));
i__42512 = G__42536;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__42513),tailrecursion$priority_map$iter__42508_$_iter__42510(cljs.core.chunk_rest(s__42511__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__42513),null);
}
} else {
var item = cljs.core.first(s__42511__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__42508_$_iter__42510(cljs.core.rest(s__42511__$2)));
}
} else {
return null;
}
break;
}
});})(s__42509__$1,vec__42514,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1))
,null,null));
});})(s__42509__$1,vec__42514,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1))
;
var fs__5519__auto__ = cljs.core.seq(iterys__5518__auto__(item_set));
if(fs__5519__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__5519__auto__,tailrecursion$priority_map$iter__42508(cljs.core.rest(s__42509__$1)));
} else {
var G__42537 = cljs.core.rest(s__42509__$1);
s__42509__$1 = G__42537;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5522__auto__(sets);
})());
} else {
return cljs.core.seq((function (){var iter__5522__auto__ = (function tailrecursion$priority_map$iter__42517(s__42518){
return (new cljs.core.LazySeq(null,(function (){
var s__42518__$1 = s__42518;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__42518__$1);
if(temp__5804__auto__){
var xs__6360__auto__ = temp__5804__auto__;
var vec__42523 = cljs.core.first(xs__6360__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42523,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42523,(1),null);
var iterys__5518__auto__ = ((function (s__42518__$1,vec__42523,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__42517_$_iter__42519(s__42520){
return (new cljs.core.LazySeq(null,((function (s__42518__$1,vec__42523,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1){
return (function (){
var s__42520__$1 = s__42520;
while(true){
var temp__5804__auto____$1 = cljs.core.seq(s__42520__$1);
if(temp__5804__auto____$1){
var s__42520__$2 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__42520__$2)){
var c__5520__auto__ = cljs.core.chunk_first(s__42520__$2);
var size__5521__auto__ = cljs.core.count(c__5520__auto__);
var b__42522 = cljs.core.chunk_buffer(size__5521__auto__);
if((function (){var i__42521 = (0);
while(true){
if((i__42521 < size__5521__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5520__auto__,i__42521);
cljs.core.chunk_append(b__42522,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__42538 = (i__42521 + (1));
i__42521 = G__42538;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__42522),tailrecursion$priority_map$iter__42517_$_iter__42519(cljs.core.chunk_rest(s__42520__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__42522),null);
}
} else {
var item = cljs.core.first(s__42520__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__42517_$_iter__42519(cljs.core.rest(s__42520__$2)));
}
} else {
return null;
}
break;
}
});})(s__42518__$1,vec__42523,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1))
,null,null));
});})(s__42518__$1,vec__42523,priority,item_set,xs__6360__auto__,temp__5804__auto__,sets,this$__$1))
;
var fs__5519__auto__ = cljs.core.seq(iterys__5518__auto__(item_set));
if(fs__5519__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__5519__auto__,tailrecursion$priority_map$iter__42517(cljs.core.rest(s__42518__$1)));
} else {
var G__42539 = cljs.core.rest(s__42518__$1);
s__42518__$1 = G__42539;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5522__auto__(sets);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
var G__42526 = cljs.core.val(entry);
return (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(G__42526) : self__.keyfn.call(null,G__42526));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.compare;
}));

(tailrecursion.priority_map.PersistentPriorityMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$priority_DASH__GT_set_DASH_of_DASH_items,cljs.core.cst$sym$item_DASH__GT_priority,cljs.core.cst$sym$meta,cljs.core.cst$sym$keyfn,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$type = true);

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorStr = "tailrecursion.priority-map/PersistentPriorityMap");

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"tailrecursion.priority-map/PersistentPriorityMap");
}));

/**
 * Positional factory function for tailrecursion.priority-map/PersistentPriorityMap.
 */
tailrecursion.priority_map.__GT_PersistentPriorityMap = (function tailrecursion$priority_map$__GT_PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
return (new tailrecursion.priority_map.PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash));
});

(tailrecursion.priority_map.PersistentPriorityMap.EMPTY = (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null)));
tailrecursion.priority_map.pm_empty_by = (function tailrecursion$priority_map$pm_empty_by(comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null));
});
tailrecursion.priority_map.pm_empty_keyfn = (function tailrecursion$priority_map$pm_empty_keyfn(var_args){
var G__42541 = arguments.length;
switch (G__42541) {
case 1:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$lang$maxFixedArity = 2);

tailrecursion.priority_map.read_priority_map = (function tailrecursion$priority_map$read_priority_map(elems){
if(cljs.core.map_QMARK_(elems)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,elems);
} else {
throw Error("Priority map literal expects a map for its elements.");
}
});
cljs.reader.register_tag_parser_BANG_("tailrecursion.priority-map",tailrecursion.priority_map.read_priority_map);
/**
 * keyval => key val
 *   Returns a new priority map with supplied mappings.
 */
tailrecursion.priority_map.priority_map = (function tailrecursion$priority_map$priority_map(var_args){
var args__5774__auto__ = [];
var len__5768__auto___42544 = arguments.length;
var i__5769__auto___42545 = (0);
while(true){
if((i__5769__auto___42545 < len__5768__auto___42544)){
args__5774__auto__.push((arguments[i__5769__auto___42545]));

var G__42546 = (i__5769__auto___42545 + (1));
i__5769__auto___42545 = G__42546;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.PersistentPriorityMap.EMPTY;
while(true){
if(in$){
var G__42547 = cljs.core.nnext(in$);
var G__42548 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__42547;
out = G__42548;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(tailrecursion.priority_map.priority_map.cljs$lang$applyTo = (function (seq42543){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42543));
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied comparator.
 */
tailrecursion.priority_map.priority_map_by = (function tailrecursion$priority_map$priority_map_by(var_args){
var args__5774__auto__ = [];
var len__5768__auto___42551 = arguments.length;
var i__5769__auto___42552 = (0);
while(true){
if((i__5769__auto___42552 < len__5768__auto___42551)){
args__5774__auto__.push((arguments[i__5769__auto___42552]));

var G__42553 = (i__5769__auto___42552 + (1));
i__5769__auto___42552 = G__42553;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_by(comparator);
while(true){
if(in$){
var G__42554 = cljs.core.nnext(in$);
var G__42555 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__42554;
out = G__42555;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_by.cljs$lang$applyTo = (function (seq42549){
var G__42550 = cljs.core.first(seq42549);
var seq42549__$1 = cljs.core.next(seq42549);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__42550,seq42549__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn.
 */
tailrecursion.priority_map.priority_map_keyfn = (function tailrecursion$priority_map$priority_map_keyfn(var_args){
var args__5774__auto__ = [];
var len__5768__auto___42558 = arguments.length;
var i__5769__auto___42559 = (0);
while(true){
if((i__5769__auto___42559 < len__5768__auto___42558)){
args__5774__auto__.push((arguments[i__5769__auto___42559]));

var G__42560 = (i__5769__auto___42559 + (1));
i__5769__auto___42559 = G__42560;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1(keyfn);
while(true){
if(in$){
var G__42561 = cljs.core.nnext(in$);
var G__42562 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__42561;
out = G__42562;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$applyTo = (function (seq42556){
var G__42557 = cljs.core.first(seq42556);
var seq42556__$1 = cljs.core.next(seq42556);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__42557,seq42556__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn and comparator.
 */
tailrecursion.priority_map.priority_map_keyfn_by = (function tailrecursion$priority_map$priority_map_keyfn_by(var_args){
var args__5774__auto__ = [];
var len__5768__auto___42566 = arguments.length;
var i__5769__auto___42567 = (0);
while(true){
if((i__5769__auto___42567 < len__5768__auto___42566)){
args__5774__auto__.push((arguments[i__5769__auto___42567]));

var G__42568 = (i__5769__auto___42567 + (1));
i__5769__auto___42567 = G__42568;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((2) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((2)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5775__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2(keyfn,comparator);
while(true){
if(in$){
var G__42569 = cljs.core.nnext(in$);
var G__42570 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__42569;
out = G__42570;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$applyTo = (function (seq42563){
var G__42564 = cljs.core.first(seq42563);
var seq42563__$1 = cljs.core.next(seq42563);
var G__42565 = cljs.core.first(seq42563__$1);
var seq42563__$2 = cljs.core.next(seq42563__$1);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__42564,G__42565,seq42563__$2);
}));

