// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.analyzer.impl.namespaces');
goog.require('cljs.core');
/**
 * Given a libspec return a map of :as-alias alias, if was present. Return the
 * libspec with :as-alias elided. If the libspec was *only* :as-alias do not
 * return it.
 */
cljs.analyzer.impl.namespaces.check_and_remove_as_alias = (function cljs$analyzer$impl$namespaces$check_and_remove_as_alias(libspec){
if((((libspec instanceof cljs.core.Symbol)) || ((libspec instanceof cljs.core.Keyword)))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"libspec","libspec",1228503756),libspec], null);
} else {
var vec__4232 = libspec;
var seq__4233 = cljs.core.seq(vec__4232);
var first__4234 = cljs.core.first(seq__4233);
var seq__4233__$1 = cljs.core.next(seq__4233);
var lib = first__4234;
var spec = seq__4233__$1;
var libspec__$1 = vec__4232;
var vec__4235 = cljs.core.split_with(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"as-alias","as-alias",82482467),null], null), null)),spec);
var pre_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4235,(0),null);
var vec__4238 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4235,(1),null);
var seq__4239 = cljs.core.seq(vec__4238);
var first__4240 = cljs.core.first(seq__4239);
var seq__4239__$1 = cljs.core.next(seq__4239);
var _ = first__4240;
var first__4240__$1 = cljs.core.first(seq__4239__$1);
var seq__4239__$2 = cljs.core.next(seq__4239__$1);
var alias = first__4240__$1;
var post_spec = seq__4239__$2;
var post = vec__4238;
if(cljs.core.seq(post)){
var libspec_SINGLEQUOTE_ = cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [lib], null),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(pre_spec,post_spec));
if((alias instanceof cljs.core.Symbol)){
} else {
throw (new Error(["Assert failed: ",[":as-alias must be followed by a symbol, got: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(alias)].join(''),"\n","(symbol? alias)"].join('')));
}

var G__4241 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"as-alias","as-alias",82482467),cljs.core.PersistentArrayMap.createAsIfByAssoc([alias,lib])], null);
if((cljs.core.count(libspec_SINGLEQUOTE_) > (1))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__4241,new cljs.core.Keyword(null,"libspec","libspec",1228503756),libspec_SINGLEQUOTE_);
} else {
return G__4241;
}
} else {
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"libspec","libspec",1228503756),libspec__$1], null);
}
}
});
cljs.analyzer.impl.namespaces.check_as_alias_duplicates = (function cljs$analyzer$impl$namespaces$check_as_alias_duplicates(as_aliases,new_as_aliases){
var seq__4242 = cljs.core.seq(new_as_aliases);
var chunk__4243 = null;
var count__4244 = (0);
var i__4245 = (0);
while(true){
if((i__4245 < count__4244)){
var vec__4252 = chunk__4243.cljs$core$IIndexed$_nth$arity$2(null,i__4245);
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4252,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4252,(1),null);
if((!(cljs.core.contains_QMARK_(as_aliases,alias)))){
} else {
throw (new Error(["Assert failed: ",["Duplicate :as-alias ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(alias),", already in use for lib ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(as_aliases,alias))].join(''),"\n","(not (contains? as-aliases alias))"].join('')));
}


var G__4258 = seq__4242;
var G__4259 = chunk__4243;
var G__4260 = count__4244;
var G__4261 = (i__4245 + (1));
seq__4242 = G__4258;
chunk__4243 = G__4259;
count__4244 = G__4260;
i__4245 = G__4261;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__4242);
if(temp__5804__auto__){
var seq__4242__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__4242__$1)){
var c__5567__auto__ = cljs.core.chunk_first(seq__4242__$1);
var G__4262 = cljs.core.chunk_rest(seq__4242__$1);
var G__4263 = c__5567__auto__;
var G__4264 = cljs.core.count(c__5567__auto__);
var G__4265 = (0);
seq__4242 = G__4262;
chunk__4243 = G__4263;
count__4244 = G__4264;
i__4245 = G__4265;
continue;
} else {
var vec__4255 = cljs.core.first(seq__4242__$1);
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4255,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4255,(1),null);
if((!(cljs.core.contains_QMARK_(as_aliases,alias)))){
} else {
throw (new Error(["Assert failed: ",["Duplicate :as-alias ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(alias),", already in use for lib ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(as_aliases,alias))].join(''),"\n","(not (contains? as-aliases alias))"].join('')));
}


var G__4266 = cljs.core.next(seq__4242__$1);
var G__4267 = null;
var G__4268 = (0);
var G__4269 = (0);
seq__4242 = G__4266;
chunk__4243 = G__4267;
count__4244 = G__4268;
i__4245 = G__4269;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Given libspecs, elide all :as-alias. Return a map of :libspecs (filtered)
 * and :as-aliases.
 */
cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs = (function cljs$analyzer$impl$namespaces$elide_aliases_from_libspecs(var_args){
var G__4271 = arguments.length;
switch (G__4271) {
case 1:
return cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$1 = (function (libspecs){
return cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2(libspecs,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2 = (function (libspecs,as_aliases){
var ret = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),as_aliases,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.PersistentVector.EMPTY], null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__$1,libspec){
var map__4272 = cljs.analyzer.impl.namespaces.check_and_remove_as_alias(libspec);
var map__4272__$1 = cljs.core.__destructure_map(map__4272);
var as_alias = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4272__$1,new cljs.core.Keyword(null,"as-alias","as-alias",82482467));
var libspec__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4272__$1,new cljs.core.Keyword(null,"libspec","libspec",1228503756));
cljs.analyzer.impl.namespaces.check_as_alias_duplicates(new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798).cljs$core$IFn$_invoke$arity$1(ret__$1),as_alias);

var G__4273 = ret__$1;
var G__4273__$1 = (cljs.core.truth_(libspec__$1)?cljs.core.update.cljs$core$IFn$_invoke$arity$4(G__4273,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.conj,libspec__$1):G__4273);
if(cljs.core.truth_(as_alias)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(G__4273__$1,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),cljs.core.merge,as_alias);
} else {
return G__4273__$1;
}
}),ret,libspecs);
}));

(cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$lang$maxFixedArity = 2);

cljs.analyzer.impl.namespaces.elide_aliases_from_ns_specs = (function cljs$analyzer$impl$namespaces$elide_aliases_from_ns_specs(ns_specs){

var ret = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.PersistentVector.EMPTY], null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__4275,p__4276){
var map__4277 = p__4275;
var map__4277__$1 = cljs.core.__destructure_map(map__4277);
var ret__$1 = map__4277__$1;
var as_aliases = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4277__$1,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798));
var vec__4278 = p__4276;
var seq__4279 = cljs.core.seq(vec__4278);
var first__4280 = cljs.core.first(seq__4279);
var seq__4279__$1 = cljs.core.next(seq__4279);
var spec_key = first__4280;
var libspecs = seq__4279__$1;
if((!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"refer-clojure","refer-clojure",813784440),spec_key)))){
var map__4281 = cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2(libspecs,as_aliases);
var map__4281__$1 = cljs.core.__destructure_map(map__4281);
var as_aliases__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4281__$1,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798));
var libspecs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4281__$1,new cljs.core.Keyword(null,"libspecs","libspecs",59807195));
var G__4282 = ret__$1;
var G__4282__$1 = (((!(cljs.core.empty_QMARK_(as_aliases__$1))))?cljs.core.update.cljs$core$IFn$_invoke$arity$4(G__4282,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),cljs.core.merge,as_aliases__$1):G__4282);
if((!(cljs.core.empty_QMARK_(libspecs__$1)))){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(G__4282__$1,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.conj,cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(spec_key,libspecs__$1));
} else {
return G__4282__$1;
}
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(ret__$1,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.conj,cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(spec_key,libspecs));
}
}),ret,ns_specs);
});
