// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
goog.require('goog.object');
goog.scope(function(){
cljs.source_map.goog$module$goog$object = goog.module.get('goog.object');
});
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__5773){
var vec__5774 = p__5773;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5774,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5774,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__5777 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5777,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5777,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5777,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5777,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5777,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5804__auto__)){
var name__$1 = temp__5804__auto__;
return (cljs.source_map.goog$module$goog$object.get.call(null,source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__5780 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5780,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5780,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5780,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5780,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5780,(4),null);
var vec__5783 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5783,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5783,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5783,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5783,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5783,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__5045__auto__ = source;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__5045__auto__ = line;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__5045__auto__ = col;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__5786 = segmap;
var map__5786__$1 = cljs.core.__destructure_map(map__5786);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5786__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5786__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5786__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5786__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5786__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__5788 = arguments.length;
switch (G__5788) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(cljs.source_map.goog$module$goog$object.get.call(null,source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__5792 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__5796 = cljs.core.next(segs__$1);
var G__5797 = nrelseg;
var G__5798 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__5796;
relseg__$1 = G__5797;
result__$1 = G__5798;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5792,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5792,(1),null);
var G__5799 = (gline + (1));
var G__5800 = cljs.core.next(lines__$1);
var G__5801 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__5802 = result__$1;
gline = G__5799;
lines__$1 = G__5800;
relseg = G__5801;
result = G__5802;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__5804 = segmap;
var map__5804__$1 = cljs.core.__destructure_map(map__5804);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5804__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5804__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5804__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5804__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5804__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__5803_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__5803_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__5806 = arguments.length;
switch (G__5806) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(cljs.source_map.goog$module$goog$object.get.call(null,source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = cljs.source_map.goog$module$goog$object.get.call(null,source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__5810 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__5814 = cljs.core.next(segs__$1);
var G__5815 = nrelseg;
var G__5816 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__5814;
relseg__$1 = G__5815;
result__$1 = G__5816;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5810,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5810,(1),null);
var G__5817 = (gline + (1));
var G__5818 = cljs.core.next(lines__$1);
var G__5819 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__5820 = result__$1;
gline = G__5817;
lines__$1 = G__5818;
relseg = G__5819;
result = G__5820;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__5821){
var vec__5822 = p__5821;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5822,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5822,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5822,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5822,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5822,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__5825){
var vec__5826 = p__5825;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5826,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5826,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5826,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5826,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5826,(4),null);
var seg = vec__5826;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__5829){
var vec__5830 = p__5829;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5830,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5830,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5830,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5830,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5830,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5802__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5802__auto__)){
var name = temp__5802__auto__;
var idx = (function (){var temp__5802__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5802__auto____$1)){
var idx = temp__5802__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__5836 = cljs.core.seq(infos);
var chunk__5837 = null;
var count__5838 = (0);
var i__5839 = (0);
while(true){
if((i__5839 < count__5838)){
var info = chunk__5837.cljs$core$IIndexed$_nth$arity$2(null,i__5839);
var segv_6193 = info__GT_segv(info,source_idx,line,col);
var gline_6194 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_6195 = cljs.core.count(cljs.core.deref(lines));
if((gline_6194 > (lc_6195 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__5836,chunk__5837,count__5838,i__5839,segv_6193,gline_6194,lc_6195,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_6194 - (lc_6195 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_6193], null));
});})(seq__5836,chunk__5837,count__5838,i__5839,segv_6193,gline_6194,lc_6195,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__5836,chunk__5837,count__5838,i__5839,segv_6193,gline_6194,lc_6195,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6194], null),cljs.core.conj,segv_6193);
});})(seq__5836,chunk__5837,count__5838,i__5839,segv_6193,gline_6194,lc_6195,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__6196 = seq__5836;
var G__6197 = chunk__5837;
var G__6198 = count__5838;
var G__6199 = (i__5839 + (1));
seq__5836 = G__6196;
chunk__5837 = G__6197;
count__5838 = G__6198;
i__5839 = G__6199;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__5836);
if(temp__5804__auto__){
var seq__5836__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__5836__$1)){
var c__5567__auto__ = cljs.core.chunk_first(seq__5836__$1);
var G__6200 = cljs.core.chunk_rest(seq__5836__$1);
var G__6201 = c__5567__auto__;
var G__6202 = cljs.core.count(c__5567__auto__);
var G__6203 = (0);
seq__5836 = G__6200;
chunk__5837 = G__6201;
count__5838 = G__6202;
i__5839 = G__6203;
continue;
} else {
var info = cljs.core.first(seq__5836__$1);
var segv_6204 = info__GT_segv(info,source_idx,line,col);
var gline_6205 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_6206 = cljs.core.count(cljs.core.deref(lines));
if((gline_6205 > (lc_6206 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__5836,chunk__5837,count__5838,i__5839,segv_6204,gline_6205,lc_6206,info,seq__5836__$1,temp__5804__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_6205 - (lc_6206 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_6204], null));
});})(seq__5836,chunk__5837,count__5838,i__5839,segv_6204,gline_6205,lc_6206,info,seq__5836__$1,temp__5804__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__5836,chunk__5837,count__5838,i__5839,segv_6204,gline_6205,lc_6206,info,seq__5836__$1,temp__5804__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6205], null),cljs.core.conj,segv_6204);
});})(seq__5836,chunk__5837,count__5838,i__5839,segv_6204,gline_6205,lc_6206,info,seq__5836__$1,temp__5804__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__6207 = cljs.core.next(seq__5836__$1);
var G__6208 = null;
var G__6209 = (0);
var G__6210 = (0);
seq__5836 = G__6207;
chunk__5837 = G__6208;
count__5838 = G__6209;
i__5839 = G__6210;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__5840_6211 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__5841_6212 = null;
var count__5842_6213 = (0);
var i__5843_6214 = (0);
while(true){
if((i__5843_6214 < count__5842_6213)){
var vec__6016_6215 = chunk__5841_6212.cljs$core$IIndexed$_nth$arity$2(null,i__5843_6214);
var source_idx_6216 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6016_6215,(0),null);
var vec__6019_6217 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6016_6215,(1),null);
var __6218 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6019_6217,(0),null);
var lines_6219__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6019_6217,(1),null);
var seq__6022_6220 = cljs.core.seq(lines_6219__$1);
var chunk__6023_6221 = null;
var count__6024_6222 = (0);
var i__6025_6223 = (0);
while(true){
if((i__6025_6223 < count__6024_6222)){
var vec__6064_6224 = chunk__6023_6221.cljs$core$IIndexed$_nth$arity$2(null,i__6025_6223);
var line_6225 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6064_6224,(0),null);
var cols_6226 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6064_6224,(1),null);
var seq__6067_6227 = cljs.core.seq(cols_6226);
var chunk__6068_6228 = null;
var count__6069_6229 = (0);
var i__6070_6230 = (0);
while(true){
if((i__6070_6230 < count__6069_6229)){
var vec__6077_6231 = chunk__6068_6228.cljs$core$IIndexed$_nth$arity$2(null,i__6070_6230);
var col_6232 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6077_6231,(0),null);
var infos_6233 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6077_6231,(1),null);
encode_cols(infos_6233,source_idx_6216,line_6225,col_6232);


var G__6234 = seq__6067_6227;
var G__6235 = chunk__6068_6228;
var G__6236 = count__6069_6229;
var G__6237 = (i__6070_6230 + (1));
seq__6067_6227 = G__6234;
chunk__6068_6228 = G__6235;
count__6069_6229 = G__6236;
i__6070_6230 = G__6237;
continue;
} else {
var temp__5804__auto___6238 = cljs.core.seq(seq__6067_6227);
if(temp__5804__auto___6238){
var seq__6067_6239__$1 = temp__5804__auto___6238;
if(cljs.core.chunked_seq_QMARK_(seq__6067_6239__$1)){
var c__5567__auto___6240 = cljs.core.chunk_first(seq__6067_6239__$1);
var G__6241 = cljs.core.chunk_rest(seq__6067_6239__$1);
var G__6242 = c__5567__auto___6240;
var G__6243 = cljs.core.count(c__5567__auto___6240);
var G__6244 = (0);
seq__6067_6227 = G__6241;
chunk__6068_6228 = G__6242;
count__6069_6229 = G__6243;
i__6070_6230 = G__6244;
continue;
} else {
var vec__6080_6245 = cljs.core.first(seq__6067_6239__$1);
var col_6246 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6080_6245,(0),null);
var infos_6247 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6080_6245,(1),null);
encode_cols(infos_6247,source_idx_6216,line_6225,col_6246);


var G__6248 = cljs.core.next(seq__6067_6239__$1);
var G__6249 = null;
var G__6250 = (0);
var G__6251 = (0);
seq__6067_6227 = G__6248;
chunk__6068_6228 = G__6249;
count__6069_6229 = G__6250;
i__6070_6230 = G__6251;
continue;
}
} else {
}
}
break;
}


var G__6252 = seq__6022_6220;
var G__6253 = chunk__6023_6221;
var G__6254 = count__6024_6222;
var G__6255 = (i__6025_6223 + (1));
seq__6022_6220 = G__6252;
chunk__6023_6221 = G__6253;
count__6024_6222 = G__6254;
i__6025_6223 = G__6255;
continue;
} else {
var temp__5804__auto___6256 = cljs.core.seq(seq__6022_6220);
if(temp__5804__auto___6256){
var seq__6022_6257__$1 = temp__5804__auto___6256;
if(cljs.core.chunked_seq_QMARK_(seq__6022_6257__$1)){
var c__5567__auto___6258 = cljs.core.chunk_first(seq__6022_6257__$1);
var G__6259 = cljs.core.chunk_rest(seq__6022_6257__$1);
var G__6260 = c__5567__auto___6258;
var G__6261 = cljs.core.count(c__5567__auto___6258);
var G__6262 = (0);
seq__6022_6220 = G__6259;
chunk__6023_6221 = G__6260;
count__6024_6222 = G__6261;
i__6025_6223 = G__6262;
continue;
} else {
var vec__6083_6263 = cljs.core.first(seq__6022_6257__$1);
var line_6264 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6083_6263,(0),null);
var cols_6265 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6083_6263,(1),null);
var seq__6086_6266 = cljs.core.seq(cols_6265);
var chunk__6087_6267 = null;
var count__6088_6268 = (0);
var i__6089_6269 = (0);
while(true){
if((i__6089_6269 < count__6088_6268)){
var vec__6096_6270 = chunk__6087_6267.cljs$core$IIndexed$_nth$arity$2(null,i__6089_6269);
var col_6271 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6096_6270,(0),null);
var infos_6272 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6096_6270,(1),null);
encode_cols(infos_6272,source_idx_6216,line_6264,col_6271);


var G__6273 = seq__6086_6266;
var G__6274 = chunk__6087_6267;
var G__6275 = count__6088_6268;
var G__6276 = (i__6089_6269 + (1));
seq__6086_6266 = G__6273;
chunk__6087_6267 = G__6274;
count__6088_6268 = G__6275;
i__6089_6269 = G__6276;
continue;
} else {
var temp__5804__auto___6277__$1 = cljs.core.seq(seq__6086_6266);
if(temp__5804__auto___6277__$1){
var seq__6086_6278__$1 = temp__5804__auto___6277__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6086_6278__$1)){
var c__5567__auto___6279 = cljs.core.chunk_first(seq__6086_6278__$1);
var G__6280 = cljs.core.chunk_rest(seq__6086_6278__$1);
var G__6281 = c__5567__auto___6279;
var G__6282 = cljs.core.count(c__5567__auto___6279);
var G__6283 = (0);
seq__6086_6266 = G__6280;
chunk__6087_6267 = G__6281;
count__6088_6268 = G__6282;
i__6089_6269 = G__6283;
continue;
} else {
var vec__6099_6284 = cljs.core.first(seq__6086_6278__$1);
var col_6285 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6099_6284,(0),null);
var infos_6286 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6099_6284,(1),null);
encode_cols(infos_6286,source_idx_6216,line_6264,col_6285);


var G__6287 = cljs.core.next(seq__6086_6278__$1);
var G__6288 = null;
var G__6289 = (0);
var G__6290 = (0);
seq__6086_6266 = G__6287;
chunk__6087_6267 = G__6288;
count__6088_6268 = G__6289;
i__6089_6269 = G__6290;
continue;
}
} else {
}
}
break;
}


var G__6291 = cljs.core.next(seq__6022_6257__$1);
var G__6292 = null;
var G__6293 = (0);
var G__6294 = (0);
seq__6022_6220 = G__6291;
chunk__6023_6221 = G__6292;
count__6024_6222 = G__6293;
i__6025_6223 = G__6294;
continue;
}
} else {
}
}
break;
}


var G__6295 = seq__5840_6211;
var G__6296 = chunk__5841_6212;
var G__6297 = count__5842_6213;
var G__6298 = (i__5843_6214 + (1));
seq__5840_6211 = G__6295;
chunk__5841_6212 = G__6296;
count__5842_6213 = G__6297;
i__5843_6214 = G__6298;
continue;
} else {
var temp__5804__auto___6299 = cljs.core.seq(seq__5840_6211);
if(temp__5804__auto___6299){
var seq__5840_6300__$1 = temp__5804__auto___6299;
if(cljs.core.chunked_seq_QMARK_(seq__5840_6300__$1)){
var c__5567__auto___6301 = cljs.core.chunk_first(seq__5840_6300__$1);
var G__6302 = cljs.core.chunk_rest(seq__5840_6300__$1);
var G__6303 = c__5567__auto___6301;
var G__6304 = cljs.core.count(c__5567__auto___6301);
var G__6305 = (0);
seq__5840_6211 = G__6302;
chunk__5841_6212 = G__6303;
count__5842_6213 = G__6304;
i__5843_6214 = G__6305;
continue;
} else {
var vec__6102_6306 = cljs.core.first(seq__5840_6300__$1);
var source_idx_6307 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6102_6306,(0),null);
var vec__6105_6308 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6102_6306,(1),null);
var __6309 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6105_6308,(0),null);
var lines_6310__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6105_6308,(1),null);
var seq__6108_6311 = cljs.core.seq(lines_6310__$1);
var chunk__6109_6312 = null;
var count__6110_6313 = (0);
var i__6111_6314 = (0);
while(true){
if((i__6111_6314 < count__6110_6313)){
var vec__6150_6315 = chunk__6109_6312.cljs$core$IIndexed$_nth$arity$2(null,i__6111_6314);
var line_6316 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6150_6315,(0),null);
var cols_6317 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6150_6315,(1),null);
var seq__6153_6318 = cljs.core.seq(cols_6317);
var chunk__6154_6319 = null;
var count__6155_6320 = (0);
var i__6156_6321 = (0);
while(true){
if((i__6156_6321 < count__6155_6320)){
var vec__6163_6322 = chunk__6154_6319.cljs$core$IIndexed$_nth$arity$2(null,i__6156_6321);
var col_6323 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6163_6322,(0),null);
var infos_6324 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6163_6322,(1),null);
encode_cols(infos_6324,source_idx_6307,line_6316,col_6323);


var G__6325 = seq__6153_6318;
var G__6326 = chunk__6154_6319;
var G__6327 = count__6155_6320;
var G__6328 = (i__6156_6321 + (1));
seq__6153_6318 = G__6325;
chunk__6154_6319 = G__6326;
count__6155_6320 = G__6327;
i__6156_6321 = G__6328;
continue;
} else {
var temp__5804__auto___6329__$1 = cljs.core.seq(seq__6153_6318);
if(temp__5804__auto___6329__$1){
var seq__6153_6330__$1 = temp__5804__auto___6329__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6153_6330__$1)){
var c__5567__auto___6331 = cljs.core.chunk_first(seq__6153_6330__$1);
var G__6332 = cljs.core.chunk_rest(seq__6153_6330__$1);
var G__6333 = c__5567__auto___6331;
var G__6334 = cljs.core.count(c__5567__auto___6331);
var G__6335 = (0);
seq__6153_6318 = G__6332;
chunk__6154_6319 = G__6333;
count__6155_6320 = G__6334;
i__6156_6321 = G__6335;
continue;
} else {
var vec__6166_6336 = cljs.core.first(seq__6153_6330__$1);
var col_6337 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6166_6336,(0),null);
var infos_6338 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6166_6336,(1),null);
encode_cols(infos_6338,source_idx_6307,line_6316,col_6337);


var G__6339 = cljs.core.next(seq__6153_6330__$1);
var G__6340 = null;
var G__6341 = (0);
var G__6342 = (0);
seq__6153_6318 = G__6339;
chunk__6154_6319 = G__6340;
count__6155_6320 = G__6341;
i__6156_6321 = G__6342;
continue;
}
} else {
}
}
break;
}


var G__6343 = seq__6108_6311;
var G__6344 = chunk__6109_6312;
var G__6345 = count__6110_6313;
var G__6346 = (i__6111_6314 + (1));
seq__6108_6311 = G__6343;
chunk__6109_6312 = G__6344;
count__6110_6313 = G__6345;
i__6111_6314 = G__6346;
continue;
} else {
var temp__5804__auto___6347__$1 = cljs.core.seq(seq__6108_6311);
if(temp__5804__auto___6347__$1){
var seq__6108_6348__$1 = temp__5804__auto___6347__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6108_6348__$1)){
var c__5567__auto___6349 = cljs.core.chunk_first(seq__6108_6348__$1);
var G__6350 = cljs.core.chunk_rest(seq__6108_6348__$1);
var G__6351 = c__5567__auto___6349;
var G__6352 = cljs.core.count(c__5567__auto___6349);
var G__6353 = (0);
seq__6108_6311 = G__6350;
chunk__6109_6312 = G__6351;
count__6110_6313 = G__6352;
i__6111_6314 = G__6353;
continue;
} else {
var vec__6169_6354 = cljs.core.first(seq__6108_6348__$1);
var line_6355 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6169_6354,(0),null);
var cols_6356 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6169_6354,(1),null);
var seq__6172_6357 = cljs.core.seq(cols_6356);
var chunk__6173_6358 = null;
var count__6174_6359 = (0);
var i__6175_6360 = (0);
while(true){
if((i__6175_6360 < count__6174_6359)){
var vec__6182_6361 = chunk__6173_6358.cljs$core$IIndexed$_nth$arity$2(null,i__6175_6360);
var col_6362 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6182_6361,(0),null);
var infos_6363 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6182_6361,(1),null);
encode_cols(infos_6363,source_idx_6307,line_6355,col_6362);


var G__6364 = seq__6172_6357;
var G__6365 = chunk__6173_6358;
var G__6366 = count__6174_6359;
var G__6367 = (i__6175_6360 + (1));
seq__6172_6357 = G__6364;
chunk__6173_6358 = G__6365;
count__6174_6359 = G__6366;
i__6175_6360 = G__6367;
continue;
} else {
var temp__5804__auto___6368__$2 = cljs.core.seq(seq__6172_6357);
if(temp__5804__auto___6368__$2){
var seq__6172_6369__$1 = temp__5804__auto___6368__$2;
if(cljs.core.chunked_seq_QMARK_(seq__6172_6369__$1)){
var c__5567__auto___6370 = cljs.core.chunk_first(seq__6172_6369__$1);
var G__6371 = cljs.core.chunk_rest(seq__6172_6369__$1);
var G__6372 = c__5567__auto___6370;
var G__6373 = cljs.core.count(c__5567__auto___6370);
var G__6374 = (0);
seq__6172_6357 = G__6371;
chunk__6173_6358 = G__6372;
count__6174_6359 = G__6373;
i__6175_6360 = G__6374;
continue;
} else {
var vec__6185_6375 = cljs.core.first(seq__6172_6369__$1);
var col_6376 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6185_6375,(0),null);
var infos_6377 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6185_6375,(1),null);
encode_cols(infos_6377,source_idx_6307,line_6355,col_6376);


var G__6378 = cljs.core.next(seq__6172_6369__$1);
var G__6379 = null;
var G__6380 = (0);
var G__6381 = (0);
seq__6172_6357 = G__6378;
chunk__6173_6358 = G__6379;
count__6174_6359 = G__6380;
i__6175_6360 = G__6381;
continue;
}
} else {
}
}
break;
}


var G__6382 = cljs.core.next(seq__6108_6348__$1);
var G__6383 = null;
var G__6384 = (0);
var G__6385 = (0);
seq__6108_6311 = G__6382;
chunk__6109_6312 = G__6383;
count__6110_6313 = G__6384;
i__6111_6314 = G__6385;
continue;
}
} else {
}
}
break;
}


var G__6386 = cljs.core.next(seq__5840_6300__$1);
var G__6387 = null;
var G__6388 = (0);
var G__6389 = (0);
seq__5840_6211 = G__6386;
chunk__5841_6212 = G__6387;
count__5842_6213 = G__6388;
i__5843_6214 = G__6389;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__6188 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__5833_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__5833_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__5834_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__5834_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__5835_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__5835_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__6189 = G__6188;
var G__6190_6390 = G__6189;
var G__6191_6391 = "sourcesContent";
var G__6192_6392 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts));
cljs.source_map.goog$module$goog$object.set.call(null,G__6190_6390,G__6191_6391,G__6192_6392);

return G__6189;
} else {
return G__6188;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__6393 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6393,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6393,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__6396 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6396,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6396,(1),null);
var G__6401 = cljs.core.next(col_map_seq);
var G__6402 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__6396,col,infos,vec__6393,line,col_map){
return (function (v,p__6399){
var map__6400 = p__6399;
var map__6400__$1 = cljs.core.__destructure_map(map__6400);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6400__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6400__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__6396,col,infos,vec__6393,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__6401;
new_cols = G__6402;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__6403 = cljs.core.next(line_map_seq);
var G__6404 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__6403;
new_lines = G__6404;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__6405_6613 = cljs.core.seq(reverse_map);
var chunk__6406_6614 = null;
var count__6407_6615 = (0);
var i__6408_6616 = (0);
while(true){
if((i__6408_6616 < count__6407_6615)){
var vec__6511_6617 = chunk__6406_6614.cljs$core$IIndexed$_nth$arity$2(null,i__6408_6616);
var line_6618 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6511_6617,(0),null);
var columns_6619 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6511_6617,(1),null);
var seq__6514_6620 = cljs.core.seq(columns_6619);
var chunk__6515_6621 = null;
var count__6516_6622 = (0);
var i__6517_6623 = (0);
while(true){
if((i__6517_6623 < count__6516_6622)){
var vec__6540_6624 = chunk__6515_6621.cljs$core$IIndexed$_nth$arity$2(null,i__6517_6623);
var column_6625 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6540_6624,(0),null);
var column_info_6626 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6540_6624,(1),null);
var seq__6543_6627 = cljs.core.seq(column_info_6626);
var chunk__6544_6628 = null;
var count__6545_6629 = (0);
var i__6546_6630 = (0);
while(true){
if((i__6546_6630 < count__6545_6629)){
var map__6549_6631 = chunk__6544_6628.cljs$core$IIndexed$_nth$arity$2(null,i__6546_6630);
var map__6549_6632__$1 = cljs.core.__destructure_map(map__6549_6631);
var gline_6633 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6549_6632__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6634 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6549_6632__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6635 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6549_6632__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6633], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6543_6627,chunk__6544_6628,count__6545_6629,i__6546_6630,seq__6514_6620,chunk__6515_6621,count__6516_6622,i__6517_6623,seq__6405_6613,chunk__6406_6614,count__6407_6615,i__6408_6616,map__6549_6631,map__6549_6632__$1,gline_6633,gcol_6634,name_6635,vec__6540_6624,column_6625,column_info_6626,vec__6511_6617,line_6618,columns_6619,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6634], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6618,new cljs.core.Keyword(null,"col","col",-1959363084),column_6625,new cljs.core.Keyword(null,"name","name",1843675177),name_6635], null));
});})(seq__6543_6627,chunk__6544_6628,count__6545_6629,i__6546_6630,seq__6514_6620,chunk__6515_6621,count__6516_6622,i__6517_6623,seq__6405_6613,chunk__6406_6614,count__6407_6615,i__6408_6616,map__6549_6631,map__6549_6632__$1,gline_6633,gcol_6634,name_6635,vec__6540_6624,column_6625,column_info_6626,vec__6511_6617,line_6618,columns_6619,inverted))
,cljs.core.sorted_map()));


var G__6636 = seq__6543_6627;
var G__6637 = chunk__6544_6628;
var G__6638 = count__6545_6629;
var G__6639 = (i__6546_6630 + (1));
seq__6543_6627 = G__6636;
chunk__6544_6628 = G__6637;
count__6545_6629 = G__6638;
i__6546_6630 = G__6639;
continue;
} else {
var temp__5804__auto___6640 = cljs.core.seq(seq__6543_6627);
if(temp__5804__auto___6640){
var seq__6543_6641__$1 = temp__5804__auto___6640;
if(cljs.core.chunked_seq_QMARK_(seq__6543_6641__$1)){
var c__5567__auto___6642 = cljs.core.chunk_first(seq__6543_6641__$1);
var G__6643 = cljs.core.chunk_rest(seq__6543_6641__$1);
var G__6644 = c__5567__auto___6642;
var G__6645 = cljs.core.count(c__5567__auto___6642);
var G__6646 = (0);
seq__6543_6627 = G__6643;
chunk__6544_6628 = G__6644;
count__6545_6629 = G__6645;
i__6546_6630 = G__6646;
continue;
} else {
var map__6550_6647 = cljs.core.first(seq__6543_6641__$1);
var map__6550_6648__$1 = cljs.core.__destructure_map(map__6550_6647);
var gline_6649 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6550_6648__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6650 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6550_6648__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6651 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6550_6648__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6649], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6543_6627,chunk__6544_6628,count__6545_6629,i__6546_6630,seq__6514_6620,chunk__6515_6621,count__6516_6622,i__6517_6623,seq__6405_6613,chunk__6406_6614,count__6407_6615,i__6408_6616,map__6550_6647,map__6550_6648__$1,gline_6649,gcol_6650,name_6651,seq__6543_6641__$1,temp__5804__auto___6640,vec__6540_6624,column_6625,column_info_6626,vec__6511_6617,line_6618,columns_6619,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6650], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6618,new cljs.core.Keyword(null,"col","col",-1959363084),column_6625,new cljs.core.Keyword(null,"name","name",1843675177),name_6651], null));
});})(seq__6543_6627,chunk__6544_6628,count__6545_6629,i__6546_6630,seq__6514_6620,chunk__6515_6621,count__6516_6622,i__6517_6623,seq__6405_6613,chunk__6406_6614,count__6407_6615,i__6408_6616,map__6550_6647,map__6550_6648__$1,gline_6649,gcol_6650,name_6651,seq__6543_6641__$1,temp__5804__auto___6640,vec__6540_6624,column_6625,column_info_6626,vec__6511_6617,line_6618,columns_6619,inverted))
,cljs.core.sorted_map()));


var G__6652 = cljs.core.next(seq__6543_6641__$1);
var G__6653 = null;
var G__6654 = (0);
var G__6655 = (0);
seq__6543_6627 = G__6652;
chunk__6544_6628 = G__6653;
count__6545_6629 = G__6654;
i__6546_6630 = G__6655;
continue;
}
} else {
}
}
break;
}


var G__6656 = seq__6514_6620;
var G__6657 = chunk__6515_6621;
var G__6658 = count__6516_6622;
var G__6659 = (i__6517_6623 + (1));
seq__6514_6620 = G__6656;
chunk__6515_6621 = G__6657;
count__6516_6622 = G__6658;
i__6517_6623 = G__6659;
continue;
} else {
var temp__5804__auto___6660 = cljs.core.seq(seq__6514_6620);
if(temp__5804__auto___6660){
var seq__6514_6661__$1 = temp__5804__auto___6660;
if(cljs.core.chunked_seq_QMARK_(seq__6514_6661__$1)){
var c__5567__auto___6662 = cljs.core.chunk_first(seq__6514_6661__$1);
var G__6663 = cljs.core.chunk_rest(seq__6514_6661__$1);
var G__6664 = c__5567__auto___6662;
var G__6665 = cljs.core.count(c__5567__auto___6662);
var G__6666 = (0);
seq__6514_6620 = G__6663;
chunk__6515_6621 = G__6664;
count__6516_6622 = G__6665;
i__6517_6623 = G__6666;
continue;
} else {
var vec__6551_6667 = cljs.core.first(seq__6514_6661__$1);
var column_6668 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6551_6667,(0),null);
var column_info_6669 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6551_6667,(1),null);
var seq__6554_6670 = cljs.core.seq(column_info_6669);
var chunk__6555_6671 = null;
var count__6556_6672 = (0);
var i__6557_6673 = (0);
while(true){
if((i__6557_6673 < count__6556_6672)){
var map__6560_6674 = chunk__6555_6671.cljs$core$IIndexed$_nth$arity$2(null,i__6557_6673);
var map__6560_6675__$1 = cljs.core.__destructure_map(map__6560_6674);
var gline_6676 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6560_6675__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6677 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6560_6675__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6678 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6560_6675__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6676], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6554_6670,chunk__6555_6671,count__6556_6672,i__6557_6673,seq__6514_6620,chunk__6515_6621,count__6516_6622,i__6517_6623,seq__6405_6613,chunk__6406_6614,count__6407_6615,i__6408_6616,map__6560_6674,map__6560_6675__$1,gline_6676,gcol_6677,name_6678,vec__6551_6667,column_6668,column_info_6669,seq__6514_6661__$1,temp__5804__auto___6660,vec__6511_6617,line_6618,columns_6619,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6677], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6618,new cljs.core.Keyword(null,"col","col",-1959363084),column_6668,new cljs.core.Keyword(null,"name","name",1843675177),name_6678], null));
});})(seq__6554_6670,chunk__6555_6671,count__6556_6672,i__6557_6673,seq__6514_6620,chunk__6515_6621,count__6516_6622,i__6517_6623,seq__6405_6613,chunk__6406_6614,count__6407_6615,i__6408_6616,map__6560_6674,map__6560_6675__$1,gline_6676,gcol_6677,name_6678,vec__6551_6667,column_6668,column_info_6669,seq__6514_6661__$1,temp__5804__auto___6660,vec__6511_6617,line_6618,columns_6619,inverted))
,cljs.core.sorted_map()));


var G__6679 = seq__6554_6670;
var G__6680 = chunk__6555_6671;
var G__6681 = count__6556_6672;
var G__6682 = (i__6557_6673 + (1));
seq__6554_6670 = G__6679;
chunk__6555_6671 = G__6680;
count__6556_6672 = G__6681;
i__6557_6673 = G__6682;
continue;
} else {
var temp__5804__auto___6683__$1 = cljs.core.seq(seq__6554_6670);
if(temp__5804__auto___6683__$1){
var seq__6554_6684__$1 = temp__5804__auto___6683__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6554_6684__$1)){
var c__5567__auto___6685 = cljs.core.chunk_first(seq__6554_6684__$1);
var G__6686 = cljs.core.chunk_rest(seq__6554_6684__$1);
var G__6687 = c__5567__auto___6685;
var G__6688 = cljs.core.count(c__5567__auto___6685);
var G__6689 = (0);
seq__6554_6670 = G__6686;
chunk__6555_6671 = G__6687;
count__6556_6672 = G__6688;
i__6557_6673 = G__6689;
continue;
} else {
var map__6561_6690 = cljs.core.first(seq__6554_6684__$1);
var map__6561_6691__$1 = cljs.core.__destructure_map(map__6561_6690);
var gline_6692 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6561_6691__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6693 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6561_6691__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6694 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6561_6691__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6692], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6554_6670,chunk__6555_6671,count__6556_6672,i__6557_6673,seq__6514_6620,chunk__6515_6621,count__6516_6622,i__6517_6623,seq__6405_6613,chunk__6406_6614,count__6407_6615,i__6408_6616,map__6561_6690,map__6561_6691__$1,gline_6692,gcol_6693,name_6694,seq__6554_6684__$1,temp__5804__auto___6683__$1,vec__6551_6667,column_6668,column_info_6669,seq__6514_6661__$1,temp__5804__auto___6660,vec__6511_6617,line_6618,columns_6619,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6693], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6618,new cljs.core.Keyword(null,"col","col",-1959363084),column_6668,new cljs.core.Keyword(null,"name","name",1843675177),name_6694], null));
});})(seq__6554_6670,chunk__6555_6671,count__6556_6672,i__6557_6673,seq__6514_6620,chunk__6515_6621,count__6516_6622,i__6517_6623,seq__6405_6613,chunk__6406_6614,count__6407_6615,i__6408_6616,map__6561_6690,map__6561_6691__$1,gline_6692,gcol_6693,name_6694,seq__6554_6684__$1,temp__5804__auto___6683__$1,vec__6551_6667,column_6668,column_info_6669,seq__6514_6661__$1,temp__5804__auto___6660,vec__6511_6617,line_6618,columns_6619,inverted))
,cljs.core.sorted_map()));


var G__6695 = cljs.core.next(seq__6554_6684__$1);
var G__6696 = null;
var G__6697 = (0);
var G__6698 = (0);
seq__6554_6670 = G__6695;
chunk__6555_6671 = G__6696;
count__6556_6672 = G__6697;
i__6557_6673 = G__6698;
continue;
}
} else {
}
}
break;
}


var G__6699 = cljs.core.next(seq__6514_6661__$1);
var G__6700 = null;
var G__6701 = (0);
var G__6702 = (0);
seq__6514_6620 = G__6699;
chunk__6515_6621 = G__6700;
count__6516_6622 = G__6701;
i__6517_6623 = G__6702;
continue;
}
} else {
}
}
break;
}


var G__6703 = seq__6405_6613;
var G__6704 = chunk__6406_6614;
var G__6705 = count__6407_6615;
var G__6706 = (i__6408_6616 + (1));
seq__6405_6613 = G__6703;
chunk__6406_6614 = G__6704;
count__6407_6615 = G__6705;
i__6408_6616 = G__6706;
continue;
} else {
var temp__5804__auto___6707 = cljs.core.seq(seq__6405_6613);
if(temp__5804__auto___6707){
var seq__6405_6708__$1 = temp__5804__auto___6707;
if(cljs.core.chunked_seq_QMARK_(seq__6405_6708__$1)){
var c__5567__auto___6709 = cljs.core.chunk_first(seq__6405_6708__$1);
var G__6710 = cljs.core.chunk_rest(seq__6405_6708__$1);
var G__6711 = c__5567__auto___6709;
var G__6712 = cljs.core.count(c__5567__auto___6709);
var G__6713 = (0);
seq__6405_6613 = G__6710;
chunk__6406_6614 = G__6711;
count__6407_6615 = G__6712;
i__6408_6616 = G__6713;
continue;
} else {
var vec__6562_6714 = cljs.core.first(seq__6405_6708__$1);
var line_6715 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6562_6714,(0),null);
var columns_6716 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6562_6714,(1),null);
var seq__6565_6717 = cljs.core.seq(columns_6716);
var chunk__6566_6718 = null;
var count__6567_6719 = (0);
var i__6568_6720 = (0);
while(true){
if((i__6568_6720 < count__6567_6719)){
var vec__6591_6721 = chunk__6566_6718.cljs$core$IIndexed$_nth$arity$2(null,i__6568_6720);
var column_6722 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6591_6721,(0),null);
var column_info_6723 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6591_6721,(1),null);
var seq__6594_6724 = cljs.core.seq(column_info_6723);
var chunk__6595_6725 = null;
var count__6596_6726 = (0);
var i__6597_6727 = (0);
while(true){
if((i__6597_6727 < count__6596_6726)){
var map__6600_6728 = chunk__6595_6725.cljs$core$IIndexed$_nth$arity$2(null,i__6597_6727);
var map__6600_6729__$1 = cljs.core.__destructure_map(map__6600_6728);
var gline_6730 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6600_6729__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6731 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6600_6729__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6732 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6600_6729__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6730], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6594_6724,chunk__6595_6725,count__6596_6726,i__6597_6727,seq__6565_6717,chunk__6566_6718,count__6567_6719,i__6568_6720,seq__6405_6613,chunk__6406_6614,count__6407_6615,i__6408_6616,map__6600_6728,map__6600_6729__$1,gline_6730,gcol_6731,name_6732,vec__6591_6721,column_6722,column_info_6723,vec__6562_6714,line_6715,columns_6716,seq__6405_6708__$1,temp__5804__auto___6707,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6731], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6715,new cljs.core.Keyword(null,"col","col",-1959363084),column_6722,new cljs.core.Keyword(null,"name","name",1843675177),name_6732], null));
});})(seq__6594_6724,chunk__6595_6725,count__6596_6726,i__6597_6727,seq__6565_6717,chunk__6566_6718,count__6567_6719,i__6568_6720,seq__6405_6613,chunk__6406_6614,count__6407_6615,i__6408_6616,map__6600_6728,map__6600_6729__$1,gline_6730,gcol_6731,name_6732,vec__6591_6721,column_6722,column_info_6723,vec__6562_6714,line_6715,columns_6716,seq__6405_6708__$1,temp__5804__auto___6707,inverted))
,cljs.core.sorted_map()));


var G__6733 = seq__6594_6724;
var G__6734 = chunk__6595_6725;
var G__6735 = count__6596_6726;
var G__6736 = (i__6597_6727 + (1));
seq__6594_6724 = G__6733;
chunk__6595_6725 = G__6734;
count__6596_6726 = G__6735;
i__6597_6727 = G__6736;
continue;
} else {
var temp__5804__auto___6737__$1 = cljs.core.seq(seq__6594_6724);
if(temp__5804__auto___6737__$1){
var seq__6594_6738__$1 = temp__5804__auto___6737__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6594_6738__$1)){
var c__5567__auto___6739 = cljs.core.chunk_first(seq__6594_6738__$1);
var G__6740 = cljs.core.chunk_rest(seq__6594_6738__$1);
var G__6741 = c__5567__auto___6739;
var G__6742 = cljs.core.count(c__5567__auto___6739);
var G__6743 = (0);
seq__6594_6724 = G__6740;
chunk__6595_6725 = G__6741;
count__6596_6726 = G__6742;
i__6597_6727 = G__6743;
continue;
} else {
var map__6601_6744 = cljs.core.first(seq__6594_6738__$1);
var map__6601_6745__$1 = cljs.core.__destructure_map(map__6601_6744);
var gline_6746 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6601_6745__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6747 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6601_6745__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6748 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6601_6745__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6746], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6594_6724,chunk__6595_6725,count__6596_6726,i__6597_6727,seq__6565_6717,chunk__6566_6718,count__6567_6719,i__6568_6720,seq__6405_6613,chunk__6406_6614,count__6407_6615,i__6408_6616,map__6601_6744,map__6601_6745__$1,gline_6746,gcol_6747,name_6748,seq__6594_6738__$1,temp__5804__auto___6737__$1,vec__6591_6721,column_6722,column_info_6723,vec__6562_6714,line_6715,columns_6716,seq__6405_6708__$1,temp__5804__auto___6707,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6747], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6715,new cljs.core.Keyword(null,"col","col",-1959363084),column_6722,new cljs.core.Keyword(null,"name","name",1843675177),name_6748], null));
});})(seq__6594_6724,chunk__6595_6725,count__6596_6726,i__6597_6727,seq__6565_6717,chunk__6566_6718,count__6567_6719,i__6568_6720,seq__6405_6613,chunk__6406_6614,count__6407_6615,i__6408_6616,map__6601_6744,map__6601_6745__$1,gline_6746,gcol_6747,name_6748,seq__6594_6738__$1,temp__5804__auto___6737__$1,vec__6591_6721,column_6722,column_info_6723,vec__6562_6714,line_6715,columns_6716,seq__6405_6708__$1,temp__5804__auto___6707,inverted))
,cljs.core.sorted_map()));


var G__6749 = cljs.core.next(seq__6594_6738__$1);
var G__6750 = null;
var G__6751 = (0);
var G__6752 = (0);
seq__6594_6724 = G__6749;
chunk__6595_6725 = G__6750;
count__6596_6726 = G__6751;
i__6597_6727 = G__6752;
continue;
}
} else {
}
}
break;
}


var G__6753 = seq__6565_6717;
var G__6754 = chunk__6566_6718;
var G__6755 = count__6567_6719;
var G__6756 = (i__6568_6720 + (1));
seq__6565_6717 = G__6753;
chunk__6566_6718 = G__6754;
count__6567_6719 = G__6755;
i__6568_6720 = G__6756;
continue;
} else {
var temp__5804__auto___6757__$1 = cljs.core.seq(seq__6565_6717);
if(temp__5804__auto___6757__$1){
var seq__6565_6758__$1 = temp__5804__auto___6757__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6565_6758__$1)){
var c__5567__auto___6759 = cljs.core.chunk_first(seq__6565_6758__$1);
var G__6760 = cljs.core.chunk_rest(seq__6565_6758__$1);
var G__6761 = c__5567__auto___6759;
var G__6762 = cljs.core.count(c__5567__auto___6759);
var G__6763 = (0);
seq__6565_6717 = G__6760;
chunk__6566_6718 = G__6761;
count__6567_6719 = G__6762;
i__6568_6720 = G__6763;
continue;
} else {
var vec__6602_6764 = cljs.core.first(seq__6565_6758__$1);
var column_6765 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6602_6764,(0),null);
var column_info_6766 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6602_6764,(1),null);
var seq__6605_6767 = cljs.core.seq(column_info_6766);
var chunk__6606_6768 = null;
var count__6607_6769 = (0);
var i__6608_6770 = (0);
while(true){
if((i__6608_6770 < count__6607_6769)){
var map__6611_6771 = chunk__6606_6768.cljs$core$IIndexed$_nth$arity$2(null,i__6608_6770);
var map__6611_6772__$1 = cljs.core.__destructure_map(map__6611_6771);
var gline_6773 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6611_6772__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6774 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6611_6772__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6775 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6611_6772__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6773], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6605_6767,chunk__6606_6768,count__6607_6769,i__6608_6770,seq__6565_6717,chunk__6566_6718,count__6567_6719,i__6568_6720,seq__6405_6613,chunk__6406_6614,count__6407_6615,i__6408_6616,map__6611_6771,map__6611_6772__$1,gline_6773,gcol_6774,name_6775,vec__6602_6764,column_6765,column_info_6766,seq__6565_6758__$1,temp__5804__auto___6757__$1,vec__6562_6714,line_6715,columns_6716,seq__6405_6708__$1,temp__5804__auto___6707,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6774], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6715,new cljs.core.Keyword(null,"col","col",-1959363084),column_6765,new cljs.core.Keyword(null,"name","name",1843675177),name_6775], null));
});})(seq__6605_6767,chunk__6606_6768,count__6607_6769,i__6608_6770,seq__6565_6717,chunk__6566_6718,count__6567_6719,i__6568_6720,seq__6405_6613,chunk__6406_6614,count__6407_6615,i__6408_6616,map__6611_6771,map__6611_6772__$1,gline_6773,gcol_6774,name_6775,vec__6602_6764,column_6765,column_info_6766,seq__6565_6758__$1,temp__5804__auto___6757__$1,vec__6562_6714,line_6715,columns_6716,seq__6405_6708__$1,temp__5804__auto___6707,inverted))
,cljs.core.sorted_map()));


var G__6776 = seq__6605_6767;
var G__6777 = chunk__6606_6768;
var G__6778 = count__6607_6769;
var G__6779 = (i__6608_6770 + (1));
seq__6605_6767 = G__6776;
chunk__6606_6768 = G__6777;
count__6607_6769 = G__6778;
i__6608_6770 = G__6779;
continue;
} else {
var temp__5804__auto___6780__$2 = cljs.core.seq(seq__6605_6767);
if(temp__5804__auto___6780__$2){
var seq__6605_6781__$1 = temp__5804__auto___6780__$2;
if(cljs.core.chunked_seq_QMARK_(seq__6605_6781__$1)){
var c__5567__auto___6782 = cljs.core.chunk_first(seq__6605_6781__$1);
var G__6783 = cljs.core.chunk_rest(seq__6605_6781__$1);
var G__6784 = c__5567__auto___6782;
var G__6785 = cljs.core.count(c__5567__auto___6782);
var G__6786 = (0);
seq__6605_6767 = G__6783;
chunk__6606_6768 = G__6784;
count__6607_6769 = G__6785;
i__6608_6770 = G__6786;
continue;
} else {
var map__6612_6787 = cljs.core.first(seq__6605_6781__$1);
var map__6612_6788__$1 = cljs.core.__destructure_map(map__6612_6787);
var gline_6789 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6612_6788__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6790 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6612_6788__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6791 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6612_6788__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6789], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6605_6767,chunk__6606_6768,count__6607_6769,i__6608_6770,seq__6565_6717,chunk__6566_6718,count__6567_6719,i__6568_6720,seq__6405_6613,chunk__6406_6614,count__6407_6615,i__6408_6616,map__6612_6787,map__6612_6788__$1,gline_6789,gcol_6790,name_6791,seq__6605_6781__$1,temp__5804__auto___6780__$2,vec__6602_6764,column_6765,column_info_6766,seq__6565_6758__$1,temp__5804__auto___6757__$1,vec__6562_6714,line_6715,columns_6716,seq__6405_6708__$1,temp__5804__auto___6707,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6790], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6715,new cljs.core.Keyword(null,"col","col",-1959363084),column_6765,new cljs.core.Keyword(null,"name","name",1843675177),name_6791], null));
});})(seq__6605_6767,chunk__6606_6768,count__6607_6769,i__6608_6770,seq__6565_6717,chunk__6566_6718,count__6567_6719,i__6568_6720,seq__6405_6613,chunk__6406_6614,count__6407_6615,i__6408_6616,map__6612_6787,map__6612_6788__$1,gline_6789,gcol_6790,name_6791,seq__6605_6781__$1,temp__5804__auto___6780__$2,vec__6602_6764,column_6765,column_info_6766,seq__6565_6758__$1,temp__5804__auto___6757__$1,vec__6562_6714,line_6715,columns_6716,seq__6405_6708__$1,temp__5804__auto___6707,inverted))
,cljs.core.sorted_map()));


var G__6792 = cljs.core.next(seq__6605_6781__$1);
var G__6793 = null;
var G__6794 = (0);
var G__6795 = (0);
seq__6605_6767 = G__6792;
chunk__6606_6768 = G__6793;
count__6607_6769 = G__6794;
i__6608_6770 = G__6795;
continue;
}
} else {
}
}
break;
}


var G__6796 = cljs.core.next(seq__6565_6758__$1);
var G__6797 = null;
var G__6798 = (0);
var G__6799 = (0);
seq__6565_6717 = G__6796;
chunk__6566_6718 = G__6797;
count__6567_6719 = G__6798;
i__6568_6720 = G__6799;
continue;
}
} else {
}
}
break;
}


var G__6800 = cljs.core.next(seq__6405_6708__$1);
var G__6801 = null;
var G__6802 = (0);
var G__6803 = (0);
seq__6405_6613 = G__6800;
chunk__6406_6614 = G__6801;
count__6407_6615 = G__6802;
i__6408_6616 = G__6803;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
