// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__63990 = arguments.length;
switch (G__63990) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2771__auto___64029 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_64011){
var state_val_64012 = (state_64011[(1)]);
if((state_val_64012 === (1))){
var state_64011__$1 = state_64011;
var statearr_64013_64030 = state_64011__$1;
(statearr_64013_64030[(2)] = null);

(statearr_64013_64030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64012 === (2))){
var _ = (function (){var statearr_64014 = state_64011;
(statearr_64014[(4)] = cljs.core.cons((5),(state_64011[(4)])));

return statearr_64014;
})();
var inst_63997 = fluree.db.session.db(conn,ledger,null);
var state_64011__$1 = state_64011;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64011__$1,(7),inst_63997);
} else {
if((state_val_64012 === (3))){
var inst_64007 = (state_64011[(2)]);
var inst_64008 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64007);
var inst_64009 = cljs.core.async.close_BANG_(pc);
var state_64011__$1 = (function (){var statearr_64016 = state_64011;
(statearr_64016[(7)] = inst_64008);

return statearr_64016;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_64011__$1,inst_64009);
} else {
if((state_val_64012 === (4))){
var inst_63991 = (state_64011[(2)]);
var state_64011__$1 = state_64011;
var statearr_64017_64031 = state_64011__$1;
(statearr_64017_64031[(2)] = inst_63991);

(statearr_64017_64031[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64012 === (5))){
var _ = (function (){var statearr_64018 = state_64011;
(statearr_64018[(4)] = cljs.core.rest((state_64011[(4)])));

return statearr_64018;
})();
var state_64011__$1 = state_64011;
var ex64015 = (state_64011__$1[(2)]);
var statearr_64019_64032 = state_64011__$1;
(statearr_64019_64032[(5)] = ex64015);


var statearr_64020_64033 = state_64011__$1;
(statearr_64020_64033[(1)] = (4));

(statearr_64020_64033[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64012 === (6))){
var inst_64003 = (state_64011[(2)]);
var inst_64004 = fluree.db.util.async.throw_err(inst_64003);
var _ = (function (){var statearr_64021 = state_64011;
(statearr_64021[(4)] = cljs.core.rest((state_64011[(4)])));

return statearr_64021;
})();
var state_64011__$1 = state_64011;
var statearr_64022_64034 = state_64011__$1;
(statearr_64022_64034[(2)] = inst_64004);

(statearr_64022_64034[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64012 === (7))){
var inst_63999 = (state_64011[(2)]);
var inst_64000 = fluree.db.util.async.throw_err(inst_63999);
var inst_64001 = fluree.db.time_travel.as_of_block(inst_64000,block);
var state_64011__$1 = state_64011;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64011__$1,(6),inst_64001);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2749__auto__ = null;
var fluree$db$api$ledger$state_machine__2749__auto____0 = (function (){
var statearr_64023 = [null,null,null,null,null,null,null,null];
(statearr_64023[(0)] = fluree$db$api$ledger$state_machine__2749__auto__);

(statearr_64023[(1)] = (1));

return statearr_64023;
});
var fluree$db$api$ledger$state_machine__2749__auto____1 = (function (state_64011){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_64011);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e64024){var ex__2752__auto__ = e64024;
var statearr_64025_64035 = state_64011;
(statearr_64025_64035[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_64011[(4)]))){
var statearr_64026_64036 = state_64011;
(statearr_64026_64036[(1)] = cljs.core.first((state_64011[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64037 = state_64011;
state_64011 = G__64037;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2749__auto__ = function(state_64011){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2749__auto____1.call(this,state_64011);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2749__auto____0;
fluree$db$api$ledger$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2749__auto____1;
return fluree$db$api$ledger$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_64027 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_64027[(6)] = c__2771__auto___64029);

return statearr_64027;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_64078){
var state_val_64079 = (state_64078[(1)]);
if((state_val_64079 === (7))){
var inst_64047 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_64078__$1 = state_64078;
if(inst_64047){
var statearr_64080_64111 = state_64078__$1;
(statearr_64080_64111[(1)] = (9));

} else {
var statearr_64081_64112 = state_64078__$1;
(statearr_64081_64112[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64079 === (1))){
var state_64078__$1 = state_64078;
var statearr_64082_64113 = state_64078__$1;
(statearr_64082_64113[(2)] = null);

(statearr_64082_64113[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64079 === (4))){
var inst_64038 = (state_64078[(2)]);
var state_64078__$1 = state_64078;
var statearr_64083_64114 = state_64078__$1;
(statearr_64083_64114[(2)] = inst_64038);

(statearr_64083_64114[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64079 === (15))){
var inst_64055 = (state_64078[(7)]);
var inst_64054 = (state_64078[(2)]);
var inst_64055__$1 = fluree.db.util.async.throw_err(inst_64054);
var state_64078__$1 = (function (){var statearr_64084 = state_64078;
(statearr_64084[(7)] = inst_64055__$1);

return statearr_64084;
})();
if(cljs.core.truth_(inst_64055__$1)){
var statearr_64085_64115 = state_64078__$1;
(statearr_64085_64115[(1)] = (16));

} else {
var statearr_64086_64116 = state_64078__$1;
(statearr_64086_64116[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64079 === (13))){
var state_64078__$1 = state_64078;
var statearr_64087_64117 = state_64078__$1;
(statearr_64087_64117[(2)] = null);

(statearr_64087_64117[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64079 === (6))){
var state_64078__$1 = state_64078;
var statearr_64088_64118 = state_64078__$1;
(statearr_64088_64118[(2)] = db);

(statearr_64088_64118[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64079 === (17))){
var inst_64059 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_64060 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64061 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_64062 = cljs.core.PersistentHashMap.fromArrays(inst_64060,inst_64061);
var inst_64063 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64059,inst_64062);
var inst_64064 = (function(){throw inst_64063})();
var state_64078__$1 = state_64078;
var statearr_64089_64119 = state_64078__$1;
(statearr_64089_64119[(2)] = inst_64064);

(statearr_64089_64119[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64079 === (3))){
var inst_64076 = (state_64078[(2)]);
var state_64078__$1 = state_64078;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64078__$1,inst_64076);
} else {
if((state_val_64079 === (12))){
var inst_64052 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_64078__$1 = state_64078;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64078__$1,(15),inst_64052);
} else {
if((state_val_64079 === (2))){
var _ = (function (){var statearr_64090 = state_64078;
(statearr_64090[(4)] = cljs.core.cons((5),(state_64078[(4)])));

return statearr_64090;
})();
var inst_64044 = cljs.core.not(auth);
var state_64078__$1 = state_64078;
if(inst_64044){
var statearr_64091_64120 = state_64078__$1;
(statearr_64091_64120[(1)] = (6));

} else {
var statearr_64092_64121 = state_64078__$1;
(statearr_64092_64121[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64079 === (11))){
var inst_64071 = (state_64078[(2)]);
var state_64078__$1 = state_64078;
var statearr_64094_64122 = state_64078__$1;
(statearr_64094_64122[(2)] = inst_64071);

(statearr_64094_64122[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64079 === (9))){
var inst_64049 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_64078__$1 = state_64078;
var statearr_64095_64123 = state_64078__$1;
(statearr_64095_64123[(2)] = inst_64049);

(statearr_64095_64123[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64079 === (5))){
var _ = (function (){var statearr_64096 = state_64078;
(statearr_64096[(4)] = cljs.core.rest((state_64078[(4)])));

return statearr_64096;
})();
var state_64078__$1 = state_64078;
var ex64093 = (state_64078__$1[(2)]);
var statearr_64097_64124 = state_64078__$1;
(statearr_64097_64124[(5)] = ex64093);


if((ex64093 instanceof Error)){
var statearr_64098_64125 = state_64078__$1;
(statearr_64098_64125[(1)] = (4));

(statearr_64098_64125[(5)] = null);

} else {
throw ex64093;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64079 === (14))){
var inst_64069 = (state_64078[(2)]);
var state_64078__$1 = state_64078;
var statearr_64099_64126 = state_64078__$1;
(statearr_64099_64126[(2)] = inst_64069);

(statearr_64099_64126[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64079 === (16))){
var inst_64055 = (state_64078[(7)]);
var inst_64057 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_64055);
var state_64078__$1 = state_64078;
var statearr_64100_64127 = state_64078__$1;
(statearr_64100_64127[(2)] = inst_64057);

(statearr_64100_64127[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64079 === (10))){
var state_64078__$1 = state_64078;
var statearr_64101_64128 = state_64078__$1;
(statearr_64101_64128[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64079 === (18))){
var inst_64066 = (state_64078[(2)]);
var state_64078__$1 = state_64078;
var statearr_64103_64129 = state_64078__$1;
(statearr_64103_64129[(2)] = inst_64066);

(statearr_64103_64129[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64079 === (8))){
var inst_64073 = (state_64078[(2)]);
var _ = (function (){var statearr_64104 = state_64078;
(statearr_64104[(4)] = cljs.core.rest((state_64078[(4)])));

return statearr_64104;
})();
var state_64078__$1 = state_64078;
var statearr_64105_64130 = state_64078__$1;
(statearr_64105_64130[(2)] = inst_64073);

(statearr_64105_64130[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2749__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2749__auto____0 = (function (){
var statearr_64106 = [null,null,null,null,null,null,null,null];
(statearr_64106[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2749__auto__);

(statearr_64106[(1)] = (1));

return statearr_64106;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2749__auto____1 = (function (state_64078){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_64078);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e64107){var ex__2752__auto__ = e64107;
var statearr_64108_64131 = state_64078;
(statearr_64108_64131[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_64078[(4)]))){
var statearr_64109_64132 = state_64078;
(statearr_64109_64132[(1)] = cljs.core.first((state_64078[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64133 = state_64078;
state_64078 = G__64133;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2749__auto__ = function(state_64078){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2749__auto____1.call(this,state_64078);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2749__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2749__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_64110 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_64110[(6)] = c__2771__auto__);

return statearr_64110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_64197){
var state_val_64198 = (state_64197[(1)]);
if((state_val_64198 === (7))){
var inst_64143 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_64197__$1 = state_64197;
if(inst_64143){
var statearr_64199_64248 = state_64197__$1;
(statearr_64199_64248[(1)] = (9));

} else {
var statearr_64200_64249 = state_64197__$1;
(statearr_64200_64249[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (20))){
var inst_64167 = (state_64197[(7)]);
var state_64197__$1 = state_64197;
if(cljs.core.truth_(inst_64167)){
var statearr_64201_64250 = state_64197__$1;
(statearr_64201_64250[(1)] = (22));

} else {
var statearr_64202_64251 = state_64197__$1;
(statearr_64202_64251[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (27))){
var state_64197__$1 = state_64197;
var statearr_64203_64252 = state_64197__$1;
(statearr_64203_64252[(2)] = null);

(statearr_64203_64252[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (1))){
var state_64197__$1 = state_64197;
var statearr_64204_64253 = state_64197__$1;
(statearr_64204_64253[(2)] = null);

(statearr_64204_64253[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (24))){
var inst_64181 = (state_64197[(2)]);
var state_64197__$1 = state_64197;
var statearr_64205_64254 = state_64197__$1;
(statearr_64205_64254[(2)] = inst_64181);

(statearr_64205_64254[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (4))){
var inst_64134 = (state_64197[(2)]);
var state_64197__$1 = state_64197;
var statearr_64206_64255 = state_64197__$1;
(statearr_64206_64255[(2)] = inst_64134);

(statearr_64206_64255[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (15))){
var inst_64150 = (state_64197[(8)]);
var inst_64149 = (state_64197[(2)]);
var inst_64150__$1 = fluree.db.util.async.throw_err(inst_64149);
var state_64197__$1 = (function (){var statearr_64207 = state_64197;
(statearr_64207[(8)] = inst_64150__$1);

return statearr_64207;
})();
if(cljs.core.truth_(inst_64150__$1)){
var statearr_64208_64256 = state_64197__$1;
(statearr_64208_64256[(1)] = (16));

} else {
var statearr_64209_64257 = state_64197__$1;
(statearr_64209_64257[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (21))){
var inst_64183 = (state_64197[(9)]);
var inst_64183__$1 = (state_64197[(2)]);
var state_64197__$1 = (function (){var statearr_64210 = state_64197;
(statearr_64210[(9)] = inst_64183__$1);

return statearr_64210;
})();
if(cljs.core.truth_(inst_64183__$1)){
var statearr_64211_64258 = state_64197__$1;
(statearr_64211_64258[(1)] = (29));

} else {
var statearr_64212_64259 = state_64197__$1;
(statearr_64212_64259[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (31))){
var inst_64183 = (state_64197[(9)]);
var inst_64167 = (state_64197[(7)]);
var inst_64191 = (state_64197[(2)]);
var inst_64192 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_64167,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_64183,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_64191], 0));
var _ = (function (){var statearr_64213 = state_64197;
(statearr_64213[(4)] = cljs.core.rest((state_64197[(4)])));

return statearr_64213;
})();
var state_64197__$1 = state_64197;
var statearr_64214_64260 = state_64197__$1;
(statearr_64214_64260[(2)] = inst_64192);

(statearr_64214_64260[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (32))){
var inst_64187 = (state_64197[(2)]);
var inst_64188 = fluree.db.util.async.throw_err(inst_64187);
var state_64197__$1 = state_64197;
var statearr_64215_64261 = state_64197__$1;
(statearr_64215_64261[(2)] = inst_64188);

(statearr_64215_64261[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (13))){
var state_64197__$1 = state_64197;
var statearr_64216_64262 = state_64197__$1;
(statearr_64216_64262[(2)] = null);

(statearr_64216_64262[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (22))){
var inst_64167 = (state_64197[(7)]);
var inst_64171 = fluree.db.auth.roles(db,inst_64167);
var state_64197__$1 = state_64197;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64197__$1,(25),inst_64171);
} else {
if((state_val_64198 === (29))){
var inst_64183 = (state_64197[(9)]);
var inst_64185 = fluree.db.permissions.permission_map(db,inst_64183,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_64197__$1 = state_64197;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64197__$1,(32),inst_64185);
} else {
if((state_val_64198 === (6))){
var state_64197__$1 = state_64197;
var statearr_64217_64263 = state_64197__$1;
(statearr_64217_64263[(2)] = null);

(statearr_64217_64263[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (28))){
var inst_64179 = (state_64197[(2)]);
var state_64197__$1 = state_64197;
var statearr_64218_64264 = state_64197__$1;
(statearr_64218_64264[(2)] = inst_64179);

(statearr_64218_64264[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (25))){
var inst_64173 = (state_64197[(2)]);
var inst_64174 = fluree.db.util.async.throw_err(inst_64173);
var state_64197__$1 = state_64197;
var statearr_64219_64265 = state_64197__$1;
(statearr_64219_64265[(2)] = inst_64174);

(statearr_64219_64265[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (17))){
var inst_64153 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_64154 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64155 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_64156 = cljs.core.PersistentHashMap.fromArrays(inst_64154,inst_64155);
var inst_64157 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64153,inst_64156);
var inst_64158 = (function(){throw inst_64157})();
var state_64197__$1 = state_64197;
var statearr_64220_64266 = state_64197__$1;
(statearr_64220_64266[(2)] = inst_64158);

(statearr_64220_64266[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (3))){
var inst_64195 = (state_64197[(2)]);
var state_64197__$1 = state_64197;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64197__$1,inst_64195);
} else {
if((state_val_64198 === (12))){
var inst_64147 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_64197__$1 = state_64197;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64197__$1,(15),inst_64147);
} else {
if((state_val_64198 === (2))){
var _ = (function (){var statearr_64221 = state_64197;
(statearr_64221[(4)] = cljs.core.cons((5),(state_64197[(4)])));

return statearr_64221;
})();
var inst_64140 = (auth == null);
var state_64197__$1 = state_64197;
if(cljs.core.truth_(inst_64140)){
var statearr_64222_64267 = state_64197__$1;
(statearr_64222_64267[(1)] = (6));

} else {
var statearr_64223_64268 = state_64197__$1;
(statearr_64223_64268[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (23))){
var state_64197__$1 = state_64197;
var statearr_64224_64269 = state_64197__$1;
(statearr_64224_64269[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (19))){
var state_64197__$1 = state_64197;
var statearr_64226_64270 = state_64197__$1;
(statearr_64226_64270[(2)] = roles);

(statearr_64226_64270[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (11))){
var inst_64165 = (state_64197[(2)]);
var state_64197__$1 = state_64197;
var statearr_64228_64271 = state_64197__$1;
(statearr_64228_64271[(2)] = inst_64165);

(statearr_64228_64271[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (9))){
var state_64197__$1 = state_64197;
var statearr_64229_64272 = state_64197__$1;
(statearr_64229_64272[(2)] = (0));

(statearr_64229_64272[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (5))){
var _ = (function (){var statearr_64230 = state_64197;
(statearr_64230[(4)] = cljs.core.rest((state_64197[(4)])));

return statearr_64230;
})();
var state_64197__$1 = state_64197;
var ex64227 = (state_64197__$1[(2)]);
var statearr_64231_64273 = state_64197__$1;
(statearr_64231_64273[(5)] = ex64227);


if((ex64227 instanceof Error)){
var statearr_64232_64274 = state_64197__$1;
(statearr_64232_64274[(1)] = (4));

(statearr_64232_64274[(5)] = null);

} else {
throw ex64227;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (14))){
var inst_64163 = (state_64197[(2)]);
var state_64197__$1 = state_64197;
var statearr_64233_64275 = state_64197__$1;
(statearr_64233_64275[(2)] = inst_64163);

(statearr_64233_64275[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (26))){
var state_64197__$1 = state_64197;
var statearr_64234_64276 = state_64197__$1;
(statearr_64234_64276[(2)] = null);

(statearr_64234_64276[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (16))){
var inst_64150 = (state_64197[(8)]);
var state_64197__$1 = state_64197;
var statearr_64235_64277 = state_64197__$1;
(statearr_64235_64277[(2)] = inst_64150);

(statearr_64235_64277[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (30))){
var state_64197__$1 = state_64197;
var statearr_64236_64278 = state_64197__$1;
(statearr_64236_64278[(2)] = null);

(statearr_64236_64278[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (10))){
var state_64197__$1 = state_64197;
if(cljs.core.truth_(auth)){
var statearr_64237_64279 = state_64197__$1;
(statearr_64237_64279[(1)] = (12));

} else {
var statearr_64238_64280 = state_64197__$1;
(statearr_64238_64280[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (18))){
var inst_64160 = (state_64197[(2)]);
var state_64197__$1 = state_64197;
var statearr_64239_64281 = state_64197__$1;
(statearr_64239_64281[(2)] = inst_64160);

(statearr_64239_64281[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64198 === (8))){
var inst_64167 = (state_64197[(2)]);
var state_64197__$1 = (function (){var statearr_64240 = state_64197;
(statearr_64240[(7)] = inst_64167);

return statearr_64240;
})();
if(cljs.core.truth_(roles)){
var statearr_64241_64282 = state_64197__$1;
(statearr_64241_64282[(1)] = (19));

} else {
var statearr_64242_64283 = state_64197__$1;
(statearr_64242_64283[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2749__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2749__auto____0 = (function (){
var statearr_64243 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64243[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2749__auto__);

(statearr_64243[(1)] = (1));

return statearr_64243;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2749__auto____1 = (function (state_64197){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_64197);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e64244){var ex__2752__auto__ = e64244;
var statearr_64245_64284 = state_64197;
(statearr_64245_64284[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_64197[(4)]))){
var statearr_64246_64285 = state_64197;
(statearr_64246_64285[(1)] = cljs.core.first((state_64197[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64286 = state_64197;
state_64197 = G__64286;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2749__auto__ = function(state_64197){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2749__auto____1.call(this,state_64197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2749__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2749__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_64247 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_64247[(6)] = c__2771__auto__);

return statearr_64247;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__64287 = db;
var map__64287__$1 = cljs.core.__destructure_map(map__64287);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64287__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64287__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64287__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NEW EVENT:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([evt], 0)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([data], 0))], 0));

if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,dbid,listen_id);

var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_64294){
var state_val_64295 = (state_64294[(1)]);
if((state_val_64295 === (1))){
var inst_64288 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_64289 = fluree.db.session.db(conn,inst_64288,null);
var state_64294__$1 = state_64294;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64294__$1,(2),inst_64289);
} else {
if((state_val_64295 === (2))){
var inst_64291 = (state_64294[(2)]);
var inst_64292 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_64291);
var state_64294__$1 = state_64294;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64294__$1,inst_64292);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2749__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2749__auto____0 = (function (){
var statearr_64296 = [null,null,null,null,null,null,null];
(statearr_64296[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2749__auto__);

(statearr_64296[(1)] = (1));

return statearr_64296;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2749__auto____1 = (function (state_64294){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_64294);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e64297){var ex__2752__auto__ = e64297;
var statearr_64298_64325 = state_64294;
(statearr_64298_64325[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_64294[(4)]))){
var statearr_64299_64326 = state_64294;
(statearr_64299_64326[(1)] = cljs.core.first((state_64294[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64327 = state_64294;
state_64294 = G__64327;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2749__auto__ = function(state_64294){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2749__auto____1.call(this,state_64294);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2749__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2749__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_64300 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_64300[(6)] = c__2771__auto__);

return statearr_64300;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,dbid,listen_id,event_fn);

var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_64313){
var state_val_64314 = (state_64313[(1)]);
if((state_val_64314 === (1))){
var inst_64301 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_64302 = fluree.db.session.db(conn,inst_64301,null);
var state_64313__$1 = state_64313;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64313__$1,(2),inst_64302);
} else {
if((state_val_64314 === (2))){
var inst_64304 = (state_64313[(7)]);
var inst_64304__$1 = (state_64313[(2)]);
var inst_64305 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_64304__$1);
var inst_64306 = newer_block_QMARK_(inst_64305);
var state_64313__$1 = (function (){var statearr_64315 = state_64313;
(statearr_64315[(7)] = inst_64304__$1);

return statearr_64315;
})();
if(inst_64306){
var statearr_64316_64328 = state_64313__$1;
(statearr_64316_64328[(1)] = (3));

} else {
var statearr_64317_64329 = state_64313__$1;
(statearr_64317_64329[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64314 === (3))){
var inst_64304 = (state_64313[(7)]);
var inst_64308 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_64304);
var state_64313__$1 = state_64313;
var statearr_64318_64330 = state_64313__$1;
(statearr_64318_64330[(2)] = inst_64308);

(statearr_64318_64330[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64314 === (4))){
var state_64313__$1 = state_64313;
var statearr_64319_64331 = state_64313__$1;
(statearr_64319_64331[(2)] = null);

(statearr_64319_64331[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64314 === (5))){
var inst_64311 = (state_64313[(2)]);
var state_64313__$1 = state_64313;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64313__$1,inst_64311);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2749__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2749__auto____0 = (function (){
var statearr_64320 = [null,null,null,null,null,null,null,null];
(statearr_64320[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2749__auto__);

(statearr_64320[(1)] = (1));

return statearr_64320;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2749__auto____1 = (function (state_64313){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_64313);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e64321){var ex__2752__auto__ = e64321;
var statearr_64322_64332 = state_64313;
(statearr_64322_64332[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_64313[(4)]))){
var statearr_64323_64333 = state_64313;
(statearr_64323_64333[(1)] = cljs.core.first((state_64313[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64334 = state_64313;
state_64313 = G__64334;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2749__auto__ = function(state_64313){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2749__auto____1.call(this,state_64313);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2749__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2749__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_64324 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_64324[(6)] = c__2771__auto__);

return statearr_64324;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__64335 = db;
var map__64335__$1 = cljs.core.__destructure_map(map__64335);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64335__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64335__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64335__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__5133__auto__ = syncTimeout;
var y__5134__auto__ = (120000);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2771__auto___64411 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_64385){
var state_val_64386 = (state_64385[(1)]);
if((state_val_64386 === (7))){
var inst_64351 = (state_64385[(7)]);
var inst_64362 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_64351,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_64385__$1 = state_64385;
if(inst_64362){
var statearr_64387_64412 = state_64385__$1;
(statearr_64387_64412[(1)] = (9));

} else {
var statearr_64388_64413 = state_64385__$1;
(statearr_64388_64413[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64386 === (1))){
var inst_64344 = (state_64385[(8)]);
var inst_64336 = (state_64385[(9)]);
var inst_64336__$1 = cljs.core.async.timeout(timeout);
var inst_64344__$1 = res_port;
var inst_64345 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64346 = [inst_64336__$1,inst_64344__$1];
var inst_64347 = (new cljs.core.PersistentVector(null,2,(5),inst_64345,inst_64346,null));
var state_64385__$1 = (function (){var statearr_64389 = state_64385;
(statearr_64389[(8)] = inst_64344__$1);

(statearr_64389[(9)] = inst_64336__$1);

return statearr_64389;
})();
return cljs.core.async.ioc_alts_BANG_(state_64385__$1,(2),inst_64347);
} else {
if((state_val_64386 === (4))){
var inst_64351 = (state_64385[(7)]);
var inst_64344 = (state_64385[(8)]);
var inst_64355 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_64351,inst_64344);
var state_64385__$1 = state_64385;
if(inst_64355){
var statearr_64390_64414 = state_64385__$1;
(statearr_64390_64414[(1)] = (6));

} else {
var statearr_64391_64415 = state_64385__$1;
(statearr_64391_64415[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64386 === (13))){
var inst_64370 = (state_64385[(10)]);
var inst_64381 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64370);
var state_64385__$1 = state_64385;
var statearr_64392_64416 = state_64385__$1;
(statearr_64392_64416[(2)] = inst_64381);

(statearr_64392_64416[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64386 === (6))){
var inst_64349 = (state_64385[(11)]);
var inst_64360 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64349,(0),null);
var state_64385__$1 = state_64385;
var statearr_64393_64417 = state_64385__$1;
(statearr_64393_64417[(2)] = inst_64360);

(statearr_64393_64417[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64386 === (3))){
var state_64385__$1 = state_64385;
var statearr_64394_64418 = state_64385__$1;
(statearr_64394_64418[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_64394_64418[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64386 === (12))){
var inst_64374 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_64375 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64376 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_64377 = cljs.core.PersistentHashMap.fromArrays(inst_64375,inst_64376);
var inst_64378 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64374,inst_64377);
var inst_64379 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64378);
var state_64385__$1 = state_64385;
var statearr_64395_64419 = state_64385__$1;
(statearr_64395_64419[(2)] = inst_64379);

(statearr_64395_64419[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64386 === (2))){
var inst_64351 = (state_64385[(7)]);
var inst_64349 = (state_64385[(11)]);
var inst_64336 = (state_64385[(9)]);
var inst_64349__$1 = (state_64385[(2)]);
var inst_64350 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64349__$1,(0),null);
var inst_64351__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64349__$1,(1),null);
var inst_64352 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_64351__$1,inst_64336);
var state_64385__$1 = (function (){var statearr_64396 = state_64385;
(statearr_64396[(7)] = inst_64351__$1);

(statearr_64396[(12)] = inst_64350);

(statearr_64396[(11)] = inst_64349__$1);

return statearr_64396;
})();
if(inst_64352){
var statearr_64397_64420 = state_64385__$1;
(statearr_64397_64420[(1)] = (3));

} else {
var statearr_64398_64421 = state_64385__$1;
(statearr_64398_64421[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64386 === (11))){
var inst_64366 = (state_64385[(2)]);
var state_64385__$1 = state_64385;
var statearr_64399_64422 = state_64385__$1;
(statearr_64399_64422[(2)] = inst_64366);

(statearr_64399_64422[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64386 === (9))){
var inst_64350 = (state_64385[(12)]);
var state_64385__$1 = state_64385;
var statearr_64400_64423 = state_64385__$1;
(statearr_64400_64423[(2)] = inst_64350);

(statearr_64400_64423[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64386 === (5))){
var inst_64370 = (state_64385[(10)]);
var inst_64370__$1 = (state_64385[(2)]);
var inst_64371 = fluree.db.connection.remove_listener(conn,network,dbid,listen_id);
var inst_64372 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_64370__$1);
var state_64385__$1 = (function (){var statearr_64401 = state_64385;
(statearr_64401[(10)] = inst_64370__$1);

(statearr_64401[(13)] = inst_64371);

return statearr_64401;
})();
if(inst_64372){
var statearr_64402_64424 = state_64385__$1;
(statearr_64402_64424[(1)] = (12));

} else {
var statearr_64403_64425 = state_64385__$1;
(statearr_64403_64425[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64386 === (14))){
var inst_64383 = (state_64385[(2)]);
var state_64385__$1 = state_64385;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64385__$1,inst_64383);
} else {
if((state_val_64386 === (10))){
var state_64385__$1 = state_64385;
var statearr_64404_64426 = state_64385__$1;
(statearr_64404_64426[(2)] = null);

(statearr_64404_64426[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64386 === (8))){
var inst_64368 = (state_64385[(2)]);
var state_64385__$1 = state_64385;
var statearr_64405_64427 = state_64385__$1;
(statearr_64405_64427[(2)] = inst_64368);

(statearr_64405_64427[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2749__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2749__auto____0 = (function (){
var statearr_64406 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64406[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2749__auto__);

(statearr_64406[(1)] = (1));

return statearr_64406;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2749__auto____1 = (function (state_64385){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_64385);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e64407){var ex__2752__auto__ = e64407;
var statearr_64408_64428 = state_64385;
(statearr_64408_64428[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_64385[(4)]))){
var statearr_64409_64429 = state_64385;
(statearr_64409_64429[(1)] = cljs.core.first((state_64385[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64430 = state_64385;
state_64385 = G__64430;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2749__auto__ = function(state_64385){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2749__auto____1.call(this,state_64385);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2749__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2749__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_64410 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_64410[(6)] = c__2771__auto___64411);

return statearr_64410;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__64432 = arguments.length;
switch (G__64432) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__64433){
var map__64434 = p__64433;
var map__64434__$1 = cljs.core.__destructure_map(map__64434);
var opts = map__64434__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64434__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64434__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64434__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64434__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64434__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2771__auto___64523 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_64485){
var state_val_64486 = (state_64485[(1)]);
if((state_val_64486 === (7))){
var inst_64447 = (state_64485[(7)]);
var inst_64449 = fluree.db.api.ledger.syncTo_db(inst_64447,syncTo,syncTimeout);
var state_64485__$1 = state_64485;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64485__$1,(10),inst_64449);
} else {
if((state_val_64486 === (20))){
var inst_64471 = (state_64485[(8)]);
var state_64485__$1 = state_64485;
var statearr_64487_64524 = state_64485__$1;
(statearr_64487_64524[(2)] = inst_64471);

(statearr_64487_64524[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64486 === (1))){
var state_64485__$1 = state_64485;
var statearr_64488_64525 = state_64485__$1;
(statearr_64488_64525[(2)] = null);

(statearr_64488_64525[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64486 === (4))){
var inst_64435 = (state_64485[(2)]);
var inst_64436 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64435);
var inst_64437 = cljs.core.async.close_BANG_(pc);
var state_64485__$1 = (function (){var statearr_64489 = state_64485;
(statearr_64489[(9)] = inst_64436);

return statearr_64489;
})();
var statearr_64490_64526 = state_64485__$1;
(statearr_64490_64526[(2)] = inst_64437);

(statearr_64490_64526[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64486 === (15))){
var inst_64463 = (state_64485[(10)]);
var inst_64465 = fluree.db.api.ledger.add_db_permissions(inst_64463,auth,roles);
var state_64485__$1 = state_64485;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64485__$1,(18),inst_64465);
} else {
if((state_val_64486 === (21))){
var inst_64479 = (state_64485[(2)]);
var inst_64480 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64479);
var _ = (function (){var statearr_64491 = state_64485;
(statearr_64491[(4)] = cljs.core.rest((state_64485[(4)])));

return statearr_64491;
})();
var state_64485__$1 = state_64485;
var statearr_64492_64527 = state_64485__$1;
(statearr_64492_64527[(2)] = inst_64480);

(statearr_64492_64527[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64486 === (13))){
var inst_64463 = (state_64485[(2)]);
var state_64485__$1 = (function (){var statearr_64493 = state_64485;
(statearr_64493[(10)] = inst_64463);

return statearr_64493;
})();
if(cljs.core.truth_(roles)){
var statearr_64494_64528 = state_64485__$1;
(statearr_64494_64528[(1)] = (15));

} else {
var statearr_64495_64529 = state_64485__$1;
(statearr_64495_64529[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64486 === (22))){
var inst_64475 = (state_64485[(2)]);
var inst_64476 = fluree.db.util.async.throw_err(inst_64475);
var state_64485__$1 = state_64485;
var statearr_64496_64530 = state_64485__$1;
(statearr_64496_64530[(2)] = inst_64476);

(statearr_64496_64530[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64486 === (6))){
var inst_64446 = (state_64485[(2)]);
var inst_64447 = fluree.db.util.async.throw_err(inst_64446);
var state_64485__$1 = (function (){var statearr_64497 = state_64485;
(statearr_64497[(7)] = inst_64447);

return statearr_64497;
})();
if(cljs.core.truth_(syncTo)){
var statearr_64498_64531 = state_64485__$1;
(statearr_64498_64531[(1)] = (7));

} else {
var statearr_64499_64532 = state_64485__$1;
(statearr_64499_64532[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64486 === (17))){
var inst_64471 = (state_64485[(2)]);
var state_64485__$1 = (function (){var statearr_64500 = state_64485;
(statearr_64500[(8)] = inst_64471);

return statearr_64500;
})();
if(cljs.core.truth_(auth)){
var statearr_64501_64533 = state_64485__$1;
(statearr_64501_64533[(1)] = (19));

} else {
var statearr_64502_64534 = state_64485__$1;
(statearr_64502_64534[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64486 === (3))){
var inst_64483 = (state_64485[(2)]);
var state_64485__$1 = state_64485;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64485__$1,inst_64483);
} else {
if((state_val_64486 === (12))){
var inst_64455 = (state_64485[(11)]);
var state_64485__$1 = state_64485;
var statearr_64503_64535 = state_64485__$1;
(statearr_64503_64535[(2)] = inst_64455);

(statearr_64503_64535[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64486 === (2))){
var _ = (function (){var statearr_64504 = state_64485;
(statearr_64504[(4)] = cljs.core.cons((5),(state_64485[(4)])));

return statearr_64504;
})();
var inst_64444 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_64485__$1 = state_64485;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64485__$1,(6),inst_64444);
} else {
if((state_val_64486 === (19))){
var inst_64471 = (state_64485[(8)]);
var inst_64473 = fluree.db.api.ledger.add_db_permissions(inst_64471,auth,roles);
var state_64485__$1 = state_64485;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64485__$1,(22),inst_64473);
} else {
if((state_val_64486 === (11))){
var inst_64455 = (state_64485[(11)]);
var inst_64457 = fluree.db.time_travel.as_of_block(inst_64455,block);
var state_64485__$1 = state_64485;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64485__$1,(14),inst_64457);
} else {
if((state_val_64486 === (9))){
var inst_64455 = (state_64485[(2)]);
var state_64485__$1 = (function (){var statearr_64506 = state_64485;
(statearr_64506[(11)] = inst_64455);

return statearr_64506;
})();
if(cljs.core.truth_(block)){
var statearr_64507_64536 = state_64485__$1;
(statearr_64507_64536[(1)] = (11));

} else {
var statearr_64508_64537 = state_64485__$1;
(statearr_64508_64537[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64486 === (5))){
var _ = (function (){var statearr_64509 = state_64485;
(statearr_64509[(4)] = cljs.core.rest((state_64485[(4)])));

return statearr_64509;
})();
var state_64485__$1 = state_64485;
var ex64505 = (state_64485__$1[(2)]);
var statearr_64510_64538 = state_64485__$1;
(statearr_64510_64538[(5)] = ex64505);


var statearr_64511_64539 = state_64485__$1;
(statearr_64511_64539[(1)] = (4));

(statearr_64511_64539[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64486 === (14))){
var inst_64459 = (state_64485[(2)]);
var inst_64460 = fluree.db.util.async.throw_err(inst_64459);
var state_64485__$1 = state_64485;
var statearr_64512_64540 = state_64485__$1;
(statearr_64512_64540[(2)] = inst_64460);

(statearr_64512_64540[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64486 === (16))){
var inst_64463 = (state_64485[(10)]);
var state_64485__$1 = state_64485;
var statearr_64513_64541 = state_64485__$1;
(statearr_64513_64541[(2)] = inst_64463);

(statearr_64513_64541[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64486 === (10))){
var inst_64451 = (state_64485[(2)]);
var inst_64452 = fluree.db.util.async.throw_err(inst_64451);
var state_64485__$1 = state_64485;
var statearr_64514_64542 = state_64485__$1;
(statearr_64514_64542[(2)] = inst_64452);

(statearr_64514_64542[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64486 === (18))){
var inst_64467 = (state_64485[(2)]);
var inst_64468 = fluree.db.util.async.throw_err(inst_64467);
var state_64485__$1 = state_64485;
var statearr_64515_64543 = state_64485__$1;
(statearr_64515_64543[(2)] = inst_64468);

(statearr_64515_64543[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64486 === (8))){
var inst_64447 = (state_64485[(7)]);
var state_64485__$1 = state_64485;
var statearr_64516_64544 = state_64485__$1;
(statearr_64516_64544[(2)] = inst_64447);

(statearr_64516_64544[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2749__auto__ = null;
var fluree$db$api$ledger$state_machine__2749__auto____0 = (function (){
var statearr_64517 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64517[(0)] = fluree$db$api$ledger$state_machine__2749__auto__);

(statearr_64517[(1)] = (1));

return statearr_64517;
});
var fluree$db$api$ledger$state_machine__2749__auto____1 = (function (state_64485){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_64485);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e64518){var ex__2752__auto__ = e64518;
var statearr_64519_64545 = state_64485;
(statearr_64519_64545[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_64485[(4)]))){
var statearr_64520_64546 = state_64485;
(statearr_64520_64546[(1)] = cljs.core.first((state_64485[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64547 = state_64485;
state_64485 = G__64547;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2749__auto__ = function(state_64485){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2749__auto____1.call(this,state_64485);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2749__auto____0;
fluree$db$api$ledger$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2749__auto____1;
return fluree$db$api$ledger$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_64521 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_64521[(6)] = c__2771__auto___64523);

return statearr_64521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

