// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__60239 = arguments.length;
switch (G__60239) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2771__auto___60387 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_60326){
var state_val_60327 = (state_60326[(1)]);
if((state_val_60327 === (7))){
var inst_60257 = (state_60326[(7)]);
var inst_60260 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_60257);
var state_60326__$1 = state_60326;
var statearr_60328_60388 = state_60326__$1;
(statearr_60328_60388[(2)] = inst_60260);

(statearr_60328_60388[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (20))){
var inst_60252 = (state_60326[(8)]);
var inst_60281 = (state_60326[(9)]);
var inst_60285 = fluree.db.auth.roles(inst_60252,inst_60281);
var state_60326__$1 = state_60326;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60326__$1,(23),inst_60285);
} else {
if((state_val_60327 === (27))){
var inst_60252 = (state_60326[(8)]);
var inst_60300 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_60301 = fluree.db.time_travel.as_of_block(inst_60252,inst_60300);
var state_60326__$1 = state_60326;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60326__$1,(30),inst_60301);
} else {
if((state_val_60327 === (1))){
var state_60326__$1 = state_60326;
var statearr_60329_60389 = state_60326__$1;
(statearr_60329_60389[(2)] = null);

(statearr_60329_60389[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (24))){
var inst_60252 = (state_60326[(8)]);
var inst_60293 = (state_60326[(10)]);
var inst_60295 = fluree.db.permissions.permission_map(inst_60252,inst_60293,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_60326__$1 = state_60326;
var statearr_60330_60390 = state_60326__$1;
(statearr_60330_60390[(2)] = inst_60295);

(statearr_60330_60390[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (4))){
var inst_60240 = (state_60326[(2)]);
var inst_60241 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_60240);
var inst_60242 = cljs.core.async.close_BANG_(pc);
var state_60326__$1 = (function (){var statearr_60331 = state_60326;
(statearr_60331[(11)] = inst_60241);

return statearr_60331;
})();
var statearr_60332_60391 = state_60326__$1;
(statearr_60332_60391[(2)] = inst_60242);

(statearr_60332_60391[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (15))){
var inst_60257 = (state_60326[(7)]);
var inst_60271 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_60257)," unknown."].join('');
var inst_60272 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60273 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_60274 = cljs.core.PersistentHashMap.fromArrays(inst_60272,inst_60273);
var inst_60275 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60271,inst_60274);
var inst_60276 = (function(){throw inst_60275})();
var state_60326__$1 = state_60326;
var statearr_60333_60392 = state_60326__$1;
(statearr_60333_60392[(2)] = inst_60276);

(statearr_60333_60392[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (21))){
var state_60326__$1 = state_60326;
var statearr_60334_60393 = state_60326__$1;
(statearr_60334_60393[(2)] = null);

(statearr_60334_60393[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (31))){
var inst_60307 = (state_60326[(12)]);
var inst_60257 = (state_60326[(7)]);
var inst_60309 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_60307,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_60257);
var state_60326__$1 = state_60326;
var statearr_60335_60394 = state_60326__$1;
(statearr_60335_60394[(2)] = inst_60309);

(statearr_60335_60394[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (32))){
var inst_60307 = (state_60326[(12)]);
var state_60326__$1 = state_60326;
var statearr_60336_60395 = state_60326__$1;
(statearr_60336_60395[(2)] = inst_60307);

(statearr_60336_60395[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (33))){
var inst_60293 = (state_60326[(10)]);
var inst_60312 = (state_60326[(2)]);
var state_60326__$1 = (function (){var statearr_60337 = state_60326;
(statearr_60337[(13)] = inst_60312);

return statearr_60337;
})();
if(cljs.core.truth_(inst_60293)){
var statearr_60338_60396 = state_60326__$1;
(statearr_60338_60396[(1)] = (34));

} else {
var statearr_60339_60397 = state_60326__$1;
(statearr_60339_60397[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (13))){
var inst_60268 = (state_60326[(14)]);
var inst_60267 = (state_60326[(2)]);
var inst_60268__$1 = fluree.db.util.async.throw_err(inst_60267);
var state_60326__$1 = (function (){var statearr_60340 = state_60326;
(statearr_60340[(14)] = inst_60268__$1);

return statearr_60340;
})();
if(cljs.core.truth_(inst_60268__$1)){
var statearr_60341_60398 = state_60326__$1;
(statearr_60341_60398[(1)] = (14));

} else {
var statearr_60342_60399 = state_60326__$1;
(statearr_60342_60399[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (22))){
var inst_60291 = (state_60326[(2)]);
var state_60326__$1 = state_60326;
var statearr_60343_60400 = state_60326__$1;
(statearr_60343_60400[(2)] = inst_60291);

(statearr_60343_60400[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (36))){
var inst_60320 = (state_60326[(2)]);
var inst_60321 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_60320);
var _ = (function (){var statearr_60344 = state_60326;
(statearr_60344[(4)] = cljs.core.rest((state_60326[(4)])));

return statearr_60344;
})();
var state_60326__$1 = state_60326;
var statearr_60345_60401 = state_60326__$1;
(statearr_60345_60401[(2)] = inst_60321);

(statearr_60345_60401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (29))){
var inst_60257 = (state_60326[(7)]);
var inst_60307 = (state_60326[(2)]);
var state_60326__$1 = (function (){var statearr_60346 = state_60326;
(statearr_60346[(12)] = inst_60307);

return statearr_60346;
})();
if(cljs.core.truth_(inst_60257)){
var statearr_60347_60402 = state_60326__$1;
(statearr_60347_60402[(1)] = (31));

} else {
var statearr_60348_60403 = state_60326__$1;
(statearr_60348_60403[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (6))){
var inst_60257 = (state_60326[(7)]);
var inst_60251 = (state_60326[(2)]);
var inst_60252 = fluree.db.util.async.throw_err(inst_60251);
var inst_60253 = opts;
var inst_60254 = cljs.core.__destructure_map(inst_60253);
var inst_60255 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60254,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_60256 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60254,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_60257__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60254,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_60258 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60254,new cljs.core.Keyword(null,"block","block",664686210));
var state_60326__$1 = (function (){var statearr_60349 = state_60326;
(statearr_60349[(8)] = inst_60252);

(statearr_60349[(15)] = inst_60256);

(statearr_60349[(16)] = inst_60258);

(statearr_60349[(7)] = inst_60257__$1);

(statearr_60349[(17)] = inst_60255);

return statearr_60349;
})();
if(cljs.core.truth_(inst_60257__$1)){
var statearr_60350_60404 = state_60326__$1;
(statearr_60350_60404[(1)] = (7));

} else {
var statearr_60351_60405 = state_60326__$1;
(statearr_60351_60405[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (28))){
var inst_60252 = (state_60326[(8)]);
var state_60326__$1 = state_60326;
var statearr_60352_60406 = state_60326__$1;
(statearr_60352_60406[(2)] = inst_60252);

(statearr_60352_60406[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (25))){
var state_60326__$1 = state_60326;
var statearr_60353_60407 = state_60326__$1;
(statearr_60353_60407[(2)] = null);

(statearr_60353_60407[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (34))){
var inst_60298 = (state_60326[(18)]);
var state_60326__$1 = state_60326;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60326__$1,(37),inst_60298);
} else {
if((state_val_60327 === (17))){
var inst_60255 = (state_60326[(17)]);
var state_60326__$1 = state_60326;
var statearr_60354_60408 = state_60326__$1;
(statearr_60354_60408[(2)] = inst_60255);

(statearr_60354_60408[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (3))){
var inst_60324 = (state_60326[(2)]);
var state_60326__$1 = state_60326;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60326__$1,inst_60324);
} else {
if((state_val_60327 === (12))){
var inst_60255 = (state_60326[(17)]);
var inst_60281 = (state_60326[(2)]);
var state_60326__$1 = (function (){var statearr_60355 = state_60326;
(statearr_60355[(9)] = inst_60281);

return statearr_60355;
})();
if(cljs.core.truth_(inst_60255)){
var statearr_60356_60409 = state_60326__$1;
(statearr_60356_60409[(1)] = (17));

} else {
var statearr_60357_60410 = state_60326__$1;
(statearr_60357_60410[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (2))){
var _ = (function (){var statearr_60358 = state_60326;
(statearr_60358[(4)] = cljs.core.cons((5),(state_60326[(4)])));

return statearr_60358;
})();
var inst_60249 = fluree.db.session.db(conn,ledger,null);
var state_60326__$1 = state_60326;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60326__$1,(6),inst_60249);
} else {
if((state_val_60327 === (23))){
var inst_60287 = (state_60326[(2)]);
var inst_60288 = fluree.db.util.async.throw_err(inst_60287);
var state_60326__$1 = state_60326;
var statearr_60359_60411 = state_60326__$1;
(statearr_60359_60411[(2)] = inst_60288);

(statearr_60359_60411[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (35))){
var inst_60312 = (state_60326[(13)]);
var state_60326__$1 = state_60326;
var statearr_60360_60412 = state_60326__$1;
(statearr_60360_60412[(2)] = inst_60312);

(statearr_60360_60412[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (19))){
var inst_60293 = (state_60326[(10)]);
var inst_60293__$1 = (state_60326[(2)]);
var state_60326__$1 = (function (){var statearr_60361 = state_60326;
(statearr_60361[(10)] = inst_60293__$1);

return statearr_60361;
})();
if(cljs.core.truth_(inst_60293__$1)){
var statearr_60362_60413 = state_60326__$1;
(statearr_60362_60413[(1)] = (24));

} else {
var statearr_60363_60414 = state_60326__$1;
(statearr_60363_60414[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (11))){
var state_60326__$1 = state_60326;
var statearr_60365_60415 = state_60326__$1;
(statearr_60365_60415[(2)] = null);

(statearr_60365_60415[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (9))){
var inst_60263 = (state_60326[(2)]);
var state_60326__$1 = state_60326;
if(cljs.core.truth_(inst_60263)){
var statearr_60366_60416 = state_60326__$1;
(statearr_60366_60416[(1)] = (10));

} else {
var statearr_60367_60417 = state_60326__$1;
(statearr_60367_60417[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (5))){
var _ = (function (){var statearr_60368 = state_60326;
(statearr_60368[(4)] = cljs.core.rest((state_60326[(4)])));

return statearr_60368;
})();
var state_60326__$1 = state_60326;
var ex60364 = (state_60326__$1[(2)]);
var statearr_60369_60418 = state_60326__$1;
(statearr_60369_60418[(5)] = ex60364);


var statearr_60370_60419 = state_60326__$1;
(statearr_60370_60419[(1)] = (4));

(statearr_60370_60419[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (14))){
var inst_60268 = (state_60326[(14)]);
var state_60326__$1 = state_60326;
var statearr_60371_60420 = state_60326__$1;
(statearr_60371_60420[(2)] = inst_60268);

(statearr_60371_60420[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (26))){
var inst_60258 = (state_60326[(16)]);
var inst_60298 = (state_60326[(2)]);
var state_60326__$1 = (function (){var statearr_60372 = state_60326;
(statearr_60372[(18)] = inst_60298);

return statearr_60372;
})();
if(cljs.core.truth_(inst_60258)){
var statearr_60373_60421 = state_60326__$1;
(statearr_60373_60421[(1)] = (27));

} else {
var statearr_60374_60422 = state_60326__$1;
(statearr_60374_60422[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (16))){
var inst_60278 = (state_60326[(2)]);
var state_60326__$1 = state_60326;
var statearr_60375_60423 = state_60326__$1;
(statearr_60375_60423[(2)] = inst_60278);

(statearr_60375_60423[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (30))){
var inst_60303 = (state_60326[(2)]);
var inst_60304 = fluree.db.util.async.throw_err(inst_60303);
var state_60326__$1 = state_60326;
var statearr_60376_60424 = state_60326__$1;
(statearr_60376_60424[(2)] = inst_60304);

(statearr_60376_60424[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (10))){
var inst_60252 = (state_60326[(8)]);
var inst_60257 = (state_60326[(7)]);
var inst_60265 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_60252,inst_60257);
var state_60326__$1 = state_60326;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60326__$1,(13),inst_60265);
} else {
if((state_val_60327 === (18))){
var inst_60281 = (state_60326[(9)]);
var state_60326__$1 = state_60326;
if(cljs.core.truth_(inst_60281)){
var statearr_60377_60425 = state_60326__$1;
(statearr_60377_60425[(1)] = (20));

} else {
var statearr_60378_60426 = state_60326__$1;
(statearr_60378_60426[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (37))){
var inst_60312 = (state_60326[(13)]);
var inst_60315 = (state_60326[(2)]);
var inst_60316 = fluree.db.util.async.throw_err(inst_60315);
var inst_60317 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_60312,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_60316);
var state_60326__$1 = state_60326;
var statearr_60379_60427 = state_60326__$1;
(statearr_60379_60427[(2)] = inst_60317);

(statearr_60379_60427[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60327 === (8))){
var inst_60257 = (state_60326[(7)]);
var state_60326__$1 = state_60326;
var statearr_60380_60428 = state_60326__$1;
(statearr_60380_60428[(2)] = inst_60257);

(statearr_60380_60428[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2749__auto__ = null;
var fluree$db$api$query$state_machine__2749__auto____0 = (function (){
var statearr_60381 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60381[(0)] = fluree$db$api$query$state_machine__2749__auto__);

(statearr_60381[(1)] = (1));

return statearr_60381;
});
var fluree$db$api$query$state_machine__2749__auto____1 = (function (state_60326){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_60326);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e60382){var ex__2752__auto__ = e60382;
var statearr_60383_60429 = state_60326;
(statearr_60383_60429[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_60326[(4)]))){
var statearr_60384_60430 = state_60326;
(statearr_60384_60430[(1)] = cljs.core.first((state_60326[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60431 = state_60326;
state_60326 = G__60431;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2749__auto__ = function(state_60326){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2749__auto____1.call(this,state_60326);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2749__auto____0;
fluree$db$api$query$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2749__auto____1;
return fluree$db$api$query$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_60385 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_60385[(6)] = c__2771__auto___60387);

return statearr_60385;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_(val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_60572){
var state_val_60573 = (state_60572[(1)]);
if((state_val_60573 === (7))){
var inst_60452 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60453 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60454 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60455 = [inst_60453,inst_60454];
var inst_60456 = (new cljs.core.PersistentVector(null,2,(5),inst_60452,inst_60455,null));
var state_60572__$1 = state_60572;
var statearr_60574_60644 = state_60572__$1;
(statearr_60574_60644[(2)] = inst_60456);

(statearr_60574_60644[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (20))){
var inst_60482 = (state_60572[(7)]);
var state_60572__$1 = state_60572;
var statearr_60575_60645 = state_60572__$1;
(statearr_60575_60645[(2)] = inst_60482);

(statearr_60575_60645[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (27))){
var state_60572__$1 = state_60572;
var statearr_60576_60646 = state_60572__$1;
(statearr_60576_60646[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (1))){
var state_60572__$1 = state_60572;
var statearr_60578_60647 = state_60572__$1;
(statearr_60578_60647[(2)] = null);

(statearr_60578_60647[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (24))){
var inst_60481 = (state_60572[(8)]);
var state_60572__$1 = state_60572;
if(cljs.core.truth_(inst_60481)){
var statearr_60579_60648 = state_60572__$1;
(statearr_60579_60648[(1)] = (26));

} else {
var statearr_60580_60649 = state_60572__$1;
(statearr_60580_60649[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (39))){
var inst_60528 = (state_60572[(9)]);
var inst_60527 = (state_60572[(10)]);
var inst_60553 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60554 = [inst_60527,inst_60528];
var inst_60555 = (new cljs.core.PersistentVector(null,2,(5),inst_60553,inst_60554,null));
var state_60572__$1 = state_60572;
var statearr_60581_60650 = state_60572__$1;
(statearr_60581_60650[(2)] = inst_60555);

(statearr_60581_60650[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (4))){
var inst_60432 = (state_60572[(2)]);
var state_60572__$1 = state_60572;
var statearr_60582_60651 = state_60572__$1;
(statearr_60582_60651[(2)] = inst_60432);

(statearr_60582_60651[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (15))){
var inst_60466 = (state_60572[(11)]);
var inst_60461 = (state_60572[(12)]);
var inst_60475 = (state_60572[(2)]);
var inst_60476 = [inst_60466,inst_60475];
var inst_60477 = (new cljs.core.PersistentVector(null,2,(5),inst_60461,inst_60476,null));
var state_60572__$1 = state_60572;
var statearr_60583_60652 = state_60572__$1;
(statearr_60583_60652[(2)] = inst_60477);

(statearr_60583_60652[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (21))){
var inst_60481 = (state_60572[(8)]);
var state_60572__$1 = state_60572;
var statearr_60584_60653 = state_60572__$1;
(statearr_60584_60653[(2)] = inst_60481);

(statearr_60584_60653[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (31))){
var inst_60522 = (state_60572[(2)]);
var state_60572__$1 = state_60572;
var statearr_60585_60654 = state_60572__$1;
(statearr_60585_60654[(2)] = inst_60522);

(statearr_60585_60654[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (32))){
var inst_60528 = (state_60572[(9)]);
var inst_60531 = cljs.core.pos_int_QMARK_(inst_60528);
var state_60572__$1 = state_60572;
var statearr_60586_60655 = state_60572__$1;
(statearr_60586_60655[(2)] = inst_60531);

(statearr_60586_60655[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (40))){
var inst_60559 = (state_60572[(13)]);
var inst_60483 = (state_60572[(14)]);
var inst_60557 = (state_60572[(2)]);
var inst_60558 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60557,(0),null);
var inst_60559__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60557,(1),null);
var inst_60560 = (inst_60559__$1 > inst_60483);
var state_60572__$1 = (function (){var statearr_60587 = state_60572;
(statearr_60587[(13)] = inst_60559__$1);

(statearr_60587[(15)] = inst_60558);

return statearr_60587;
})();
if(cljs.core.truth_(inst_60560)){
var statearr_60588_60656 = state_60572__$1;
(statearr_60588_60656[(1)] = (41));

} else {
var statearr_60589_60657 = state_60572__$1;
(statearr_60589_60657[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (33))){
var inst_60529 = (state_60572[(16)]);
var state_60572__$1 = state_60572;
var statearr_60590_60658 = state_60572__$1;
(statearr_60590_60658[(2)] = inst_60529);

(statearr_60590_60658[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (13))){
var inst_60467 = (state_60572[(17)]);
var inst_60469 = fluree.db.time_travel.block_to_int_format(db,inst_60467);
var state_60572__$1 = state_60572;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60572__$1,(16),inst_60469);
} else {
if((state_val_60573 === (22))){
var inst_60500 = (state_60572[(2)]);
var state_60572__$1 = state_60572;
if(cljs.core.truth_(inst_60500)){
var statearr_60591_60659 = state_60572__$1;
(statearr_60591_60659[(1)] = (23));

} else {
var statearr_60592_60660 = state_60572__$1;
(statearr_60592_60660[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (36))){
var state_60572__$1 = state_60572;
var statearr_60593_60661 = state_60572__$1;
(statearr_60593_60661[(2)] = null);

(statearr_60593_60661[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (41))){
var inst_60483 = (state_60572[(14)]);
var state_60572__$1 = state_60572;
var statearr_60594_60662 = state_60572__$1;
(statearr_60594_60662[(2)] = inst_60483);

(statearr_60594_60662[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (43))){
var inst_60558 = (state_60572[(15)]);
var inst_60564 = (state_60572[(2)]);
var inst_60565 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60566 = [inst_60558,inst_60564];
var inst_60567 = (new cljs.core.PersistentVector(null,2,(5),inst_60565,inst_60566,null));
var _ = (function (){var statearr_60595 = state_60572;
(statearr_60595[(4)] = cljs.core.rest((state_60572[(4)])));

return statearr_60595;
})();
var state_60572__$1 = state_60572;
var statearr_60596_60663 = state_60572__$1;
(statearr_60596_60663[(2)] = inst_60567);

(statearr_60596_60663[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (29))){
var inst_60458 = (state_60572[(18)]);
var inst_60513 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60458], 0));
var inst_60514 = ["Invalid block range provided: ",inst_60513].join('');
var inst_60515 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60516 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60517 = cljs.core.PersistentHashMap.fromArrays(inst_60515,inst_60516);
var inst_60518 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60514,inst_60517);
var inst_60519 = (function(){throw inst_60518})();
var state_60572__$1 = state_60572;
var statearr_60597_60664 = state_60572__$1;
(statearr_60597_60664[(2)] = inst_60519);

(statearr_60597_60664[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (6))){
var inst_60450 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_60572__$1 = state_60572;
var statearr_60598_60665 = state_60572__$1;
(statearr_60598_60665[(2)] = inst_60450);

(statearr_60598_60665[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (28))){
var inst_60524 = (state_60572[(2)]);
var state_60572__$1 = state_60572;
var statearr_60599_60666 = state_60572__$1;
(statearr_60599_60666[(2)] = inst_60524);

(statearr_60599_60666[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (25))){
var inst_60529 = (state_60572[(16)]);
var inst_60527 = (state_60572[(10)]);
var inst_60526 = (state_60572[(2)]);
var inst_60527__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60526,(0),null);
var inst_60528 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60526,(1),null);
var inst_60529__$1 = cljs.core.pos_int_QMARK_(inst_60527__$1);
var state_60572__$1 = (function (){var statearr_60600 = state_60572;
(statearr_60600[(16)] = inst_60529__$1);

(statearr_60600[(9)] = inst_60528);

(statearr_60600[(10)] = inst_60527__$1);

return statearr_60600;
})();
if(inst_60529__$1){
var statearr_60601_60667 = state_60572__$1;
(statearr_60601_60667[(1)] = (32));

} else {
var statearr_60602_60668 = state_60572__$1;
(statearr_60602_60668[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (34))){
var inst_60534 = (state_60572[(2)]);
var inst_60535 = cljs.core.not(inst_60534);
var state_60572__$1 = state_60572;
if(inst_60535){
var statearr_60603_60669 = state_60572__$1;
(statearr_60603_60669[(1)] = (35));

} else {
var statearr_60604_60670 = state_60572__$1;
(statearr_60604_60670[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (17))){
var inst_60481 = (state_60572[(8)]);
var inst_60483 = (state_60572[(14)]);
var inst_60486 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60481], 0));
var inst_60487 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60483], 0));
var inst_60488 = ["Start block is out of range for this ledger. Start block provided: ",inst_60486,". Database block: ",inst_60487].join('');
var inst_60489 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60490 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60491 = cljs.core.PersistentHashMap.fromArrays(inst_60489,inst_60490);
var inst_60492 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60488,inst_60491);
var inst_60493 = (function(){throw inst_60492})();
var state_60572__$1 = state_60572;
var statearr_60605_60671 = state_60572__$1;
(statearr_60605_60671[(2)] = inst_60493);

(statearr_60605_60671[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (3))){
var inst_60570 = (state_60572[(2)]);
var state_60572__$1 = state_60572;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60572__$1,inst_60570);
} else {
if((state_val_60573 === (12))){
var inst_60458 = (state_60572[(18)]);
var inst_60467 = (state_60572[(17)]);
var inst_60465 = (state_60572[(2)]);
var inst_60466 = fluree.db.util.async.throw_err(inst_60465);
var inst_60467__$1 = cljs.core.second(inst_60458);
var state_60572__$1 = (function (){var statearr_60606 = state_60572;
(statearr_60606[(17)] = inst_60467__$1);

(statearr_60606[(11)] = inst_60466);

return statearr_60606;
})();
if(cljs.core.truth_(inst_60467__$1)){
var statearr_60607_60672 = state_60572__$1;
(statearr_60607_60672[(1)] = (13));

} else {
var statearr_60608_60673 = state_60572__$1;
(statearr_60608_60673[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (2))){
var _ = (function (){var statearr_60609 = state_60572;
(statearr_60609[(4)] = cljs.core.cons((5),(state_60572[(4)])));

return statearr_60609;
})();
var inst_60447 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60448 = cljs.core.sequential_QMARK_(inst_60447);
var state_60572__$1 = state_60572;
if(inst_60448){
var statearr_60610_60674 = state_60572__$1;
(statearr_60610_60674[(1)] = (6));

} else {
var statearr_60611_60675 = state_60572__$1;
(statearr_60611_60675[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (23))){
var inst_60481 = (state_60572[(8)]);
var inst_60482 = (state_60572[(7)]);
var inst_60502 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60503 = [inst_60481,inst_60482];
var inst_60504 = (new cljs.core.PersistentVector(null,2,(5),inst_60502,inst_60503,null));
var state_60572__$1 = state_60572;
var statearr_60612_60676 = state_60572__$1;
(statearr_60612_60676[(2)] = inst_60504);

(statearr_60612_60676[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (35))){
var inst_60458 = (state_60572[(18)]);
var inst_60537 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60458], 0));
var inst_60538 = ["Invalid block range provided: ",inst_60537].join('');
var inst_60539 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60540 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60541 = cljs.core.PersistentHashMap.fromArrays(inst_60539,inst_60540);
var inst_60542 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60538,inst_60541);
var inst_60543 = (function(){throw inst_60542})();
var state_60572__$1 = state_60572;
var statearr_60613_60677 = state_60572__$1;
(statearr_60613_60677[(2)] = inst_60543);

(statearr_60613_60677[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (19))){
var inst_60481 = (state_60572[(8)]);
var inst_60496 = (state_60572[(2)]);
var state_60572__$1 = (function (){var statearr_60614 = state_60572;
(statearr_60614[(19)] = inst_60496);

return statearr_60614;
})();
if(cljs.core.truth_(inst_60481)){
var statearr_60615_60678 = state_60572__$1;
(statearr_60615_60678[(1)] = (20));

} else {
var statearr_60616_60679 = state_60572__$1;
(statearr_60616_60679[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (11))){
var inst_60481 = (state_60572[(8)]);
var inst_60483 = (state_60572[(14)]);
var inst_60480 = (state_60572[(2)]);
var inst_60481__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60480,(0),null);
var inst_60482 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60480,(1),null);
var inst_60483__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_60484 = (inst_60481__$1 > inst_60483__$1);
var state_60572__$1 = (function (){var statearr_60618 = state_60572;
(statearr_60618[(8)] = inst_60481__$1);

(statearr_60618[(14)] = inst_60483__$1);

(statearr_60618[(7)] = inst_60482);

return statearr_60618;
})();
if(cljs.core.truth_(inst_60484)){
var statearr_60619_60680 = state_60572__$1;
(statearr_60619_60680[(1)] = (17));

} else {
var statearr_60620_60681 = state_60572__$1;
(statearr_60620_60681[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (9))){
var inst_60458 = (state_60572[(18)]);
var inst_60461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60462 = cljs.core.first(inst_60458);
var inst_60463 = fluree.db.time_travel.block_to_int_format(db,inst_60462);
var state_60572__$1 = (function (){var statearr_60621 = state_60572;
(statearr_60621[(12)] = inst_60461);

return statearr_60621;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60572__$1,(12),inst_60463);
} else {
if((state_val_60573 === (5))){
var _ = (function (){var statearr_60622 = state_60572;
(statearr_60622[(4)] = cljs.core.rest((state_60572[(4)])));

return statearr_60622;
})();
var state_60572__$1 = state_60572;
var ex60617 = (state_60572__$1[(2)]);
var statearr_60623_60682 = state_60572__$1;
(statearr_60623_60682[(5)] = ex60617);


if((ex60617 instanceof Error)){
var statearr_60624_60683 = state_60572__$1;
(statearr_60624_60683[(1)] = (4));

(statearr_60624_60683[(5)] = null);

} else {
throw ex60617;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (14))){
var state_60572__$1 = state_60572;
var statearr_60625_60684 = state_60572__$1;
(statearr_60625_60684[(2)] = null);

(statearr_60625_60684[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (26))){
var inst_60481 = (state_60572[(8)]);
var inst_60507 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60508 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_60509 = [inst_60481,inst_60508];
var inst_60510 = (new cljs.core.PersistentVector(null,2,(5),inst_60507,inst_60509,null));
var state_60572__$1 = state_60572;
var statearr_60626_60685 = state_60572__$1;
(statearr_60626_60685[(2)] = inst_60510);

(statearr_60626_60685[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (16))){
var inst_60471 = (state_60572[(2)]);
var inst_60472 = fluree.db.util.async.throw_err(inst_60471);
var state_60572__$1 = state_60572;
var statearr_60627_60686 = state_60572__$1;
(statearr_60627_60686[(2)] = inst_60472);

(statearr_60627_60686[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (38))){
var inst_60528 = (state_60572[(9)]);
var inst_60527 = (state_60572[(10)]);
var inst_60549 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60550 = [inst_60528,inst_60527];
var inst_60551 = (new cljs.core.PersistentVector(null,2,(5),inst_60549,inst_60550,null));
var state_60572__$1 = state_60572;
var statearr_60628_60687 = state_60572__$1;
(statearr_60628_60687[(2)] = inst_60551);

(statearr_60628_60687[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (30))){
var state_60572__$1 = state_60572;
var statearr_60629_60688 = state_60572__$1;
(statearr_60629_60688[(2)] = null);

(statearr_60629_60688[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (10))){
var inst_60458 = (state_60572[(18)]);
var state_60572__$1 = state_60572;
var statearr_60630_60689 = state_60572__$1;
(statearr_60630_60689[(2)] = inst_60458);

(statearr_60630_60689[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (18))){
var state_60572__$1 = state_60572;
var statearr_60631_60690 = state_60572__$1;
(statearr_60631_60690[(2)] = null);

(statearr_60631_60690[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (42))){
var inst_60559 = (state_60572[(13)]);
var state_60572__$1 = state_60572;
var statearr_60632_60691 = state_60572__$1;
(statearr_60632_60691[(2)] = inst_60559);

(statearr_60632_60691[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (37))){
var inst_60528 = (state_60572[(9)]);
var inst_60527 = (state_60572[(10)]);
var inst_60546 = (state_60572[(2)]);
var inst_60547 = (inst_60528 < inst_60527);
var state_60572__$1 = (function (){var statearr_60633 = state_60572;
(statearr_60633[(20)] = inst_60546);

return statearr_60633;
})();
if(cljs.core.truth_(inst_60547)){
var statearr_60634_60692 = state_60572__$1;
(statearr_60634_60692[(1)] = (38));

} else {
var statearr_60635_60693 = state_60572__$1;
(statearr_60635_60693[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60573 === (8))){
var inst_60458 = (state_60572[(18)]);
var inst_60458__$1 = (state_60572[(2)]);
var inst_60459 = cljs.core.some(cljs.core.string_QMARK_,inst_60458__$1);
var state_60572__$1 = (function (){var statearr_60636 = state_60572;
(statearr_60636[(18)] = inst_60458__$1);

return statearr_60636;
})();
if(cljs.core.truth_(inst_60459)){
var statearr_60637_60694 = state_60572__$1;
(statearr_60637_60694[(1)] = (9));

} else {
var statearr_60638_60695 = state_60572__$1;
(statearr_60638_60695[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2749__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2749__auto____0 = (function (){
var statearr_60639 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60639[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2749__auto__);

(statearr_60639[(1)] = (1));

return statearr_60639;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2749__auto____1 = (function (state_60572){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_60572);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e60640){var ex__2752__auto__ = e60640;
var statearr_60641_60696 = state_60572;
(statearr_60641_60696[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_60572[(4)]))){
var statearr_60642_60697 = state_60572;
(statearr_60642_60697[(1)] = cljs.core.first((state_60572[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60698 = state_60572;
state_60572 = G__60698;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2749__auto__ = function(state_60572){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2749__auto____1.call(this,state_60572);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2749__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2749__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_60643 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_60643[(6)] = c__2771__auto__);

return statearr_60643;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_60848){
var state_val_60849 = (state_60848[(1)]);
if((state_val_60849 === (7))){
var inst_60760 = (state_60848[(2)]);
var inst_60761 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60760,(0),null);
var inst_60762 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60760,(1),null);
var inst_60770 = cljs.core.vals(inst_60762);
var inst_60771 = cljs.core.seq(inst_60770);
var inst_60772 = cljs.core.first(inst_60771);
var inst_60773 = cljs.core.next(inst_60771);
var inst_60774 = cljs.core.PersistentVector.EMPTY;
var inst_60775 = inst_60770;
var inst_60776 = inst_60774;
var state_60848__$1 = (function (){var statearr_60850 = state_60848;
(statearr_60850[(7)] = inst_60775);

(statearr_60850[(8)] = inst_60761);

(statearr_60850[(9)] = inst_60776);

(statearr_60850[(10)] = inst_60773);

(statearr_60850[(11)] = inst_60772);

return statearr_60850;
})();
var statearr_60851_60904 = state_60848__$1;
(statearr_60851_60904[(2)] = null);

(statearr_60851_60904[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60849 === (20))){
var inst_60782 = (state_60848[(12)]);
var inst_60787 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_60788 = cljs.core.PersistentHashMap.EMPTY;
var inst_60789 = [true,inst_60788];
var inst_60790 = cljs.core.PersistentHashMap.fromArrays(inst_60787,inst_60789);
var inst_60791 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_60790,inst_60782);
var state_60848__$1 = state_60848;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60848__$1,(22),inst_60791);
} else {
if((state_val_60849 === (27))){
var inst_60836 = (state_60848[(2)]);
var state_60848__$1 = state_60848;
var statearr_60852_60905 = state_60848__$1;
(statearr_60852_60905[(2)] = inst_60836);

(statearr_60852_60905[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60849 === (1))){
var state_60848__$1 = state_60848;
var statearr_60853_60906 = state_60848__$1;
(statearr_60853_60906[(2)] = null);

(statearr_60853_60906[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60849 === (24))){
var inst_60800 = (state_60848[(13)]);
var inst_60838 = (state_60848[(2)]);
var inst_60839 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_60840 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60841 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60842 = [inst_60840,inst_60841,inst_60800,inst_60838];
var inst_60843 = cljs.core.PersistentHashMap.fromArrays(inst_60839,inst_60842);
var _ = (function (){var statearr_60855 = state_60848;
(statearr_60855[(4)] = cljs.core.rest((state_60848[(4)])));

return statearr_60855;
})();
var state_60848__$1 = state_60848;
var statearr_60856_60907 = state_60848__$1;
(statearr_60856_60907[(2)] = inst_60843);

(statearr_60856_60907[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60849 === (4))){
var inst_60701 = (state_60848[(2)]);
var state_60848__$1 = state_60848;
var statearr_60857_60908 = state_60848__$1;
(statearr_60857_60908[(2)] = inst_60701);

(statearr_60857_60908[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60849 === (15))){
var inst_60723 = (state_60848[(14)]);
var inst_60725 = (state_60848[(15)]);
var inst_60731 = (state_60848[(16)]);
var inst_60739 = (state_60848[(17)]);
var inst_60746 = (state_60848[(18)]);
var inst_60724 = (state_60848[(19)]);
var inst_60732 = (state_60848[(20)]);
var inst_60717 = (state_60848[(21)]);
var inst_60719 = (state_60848[(22)]);
var inst_60741 = (state_60848[(23)]);
var inst_60720 = (state_60848[(24)]);
var inst_60752 = (function (){var first__60729 = inst_60731;
var subject = inst_60739;
var flake = inst_60731;
var vec__60714 = inst_60717;
var r = inst_60732;
var vec__60727 = inst_60723;
var G__60713 = inst_60723;
var asserted_subjects = inst_60724;
var seq__60728 = inst_60732;
var flake_SINGLEQUOTE_ = inst_60746;
var retracted_subjects = inst_60725;
var asserted_QMARK_ = inst_60741;
var first__60716 = inst_60719;
var seq__60715 = inst_60720;
return (function (p1__60700_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__60700_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_60753 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_60725,inst_60739,inst_60752);
var tmp60854 = inst_60724;
var inst_60723__$1 = inst_60732;
var inst_60724__$1 = tmp60854;
var inst_60725__$1 = inst_60753;
var state_60848__$1 = (function (){var statearr_60858 = state_60848;
(statearr_60858[(14)] = inst_60723__$1);

(statearr_60858[(15)] = inst_60725__$1);

(statearr_60858[(19)] = inst_60724__$1);

return statearr_60858;
})();
var statearr_60859_60909 = state_60848__$1;
(statearr_60859_60909[(2)] = null);

(statearr_60859_60909[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60849 === (21))){
var inst_60798 = (state_60848[(2)]);
var state_60848__$1 = state_60848;
var statearr_60860_60910 = state_60848__$1;
(statearr_60860_60910[(2)] = inst_60798);

(statearr_60860_60910[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60849 === (13))){
var inst_60741 = (state_60848[(23)]);
var inst_60746 = (state_60848[(2)]);
var state_60848__$1 = (function (){var statearr_60861 = state_60848;
(statearr_60861[(18)] = inst_60746);

return statearr_60861;
})();
if(cljs.core.truth_(inst_60741)){
var statearr_60862_60911 = state_60848__$1;
(statearr_60862_60911[(1)] = (14));

} else {
var statearr_60863_60912 = state_60848__$1;
(statearr_60863_60912[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60849 === (22))){
var inst_60776 = (state_60848[(9)]);
var inst_60783 = (state_60848[(25)]);
var inst_60793 = (state_60848[(2)]);
var inst_60794 = fluree.db.util.async.throw_err(inst_60793);
var inst_60795 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_60776,inst_60794);
var inst_60775 = inst_60783;
var inst_60776__$1 = inst_60795;
var state_60848__$1 = (function (){var statearr_60864 = state_60848;
(statearr_60864[(7)] = inst_60775);

(statearr_60864[(9)] = inst_60776__$1);

return statearr_60864;
})();
var statearr_60865_60913 = state_60848__$1;
(statearr_60865_60913[(2)] = null);

(statearr_60865_60913[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60849 === (6))){
var inst_60723 = (state_60848[(14)]);
var inst_60731 = (state_60848[(16)]);
var inst_60730 = cljs.core.seq(inst_60723);
var inst_60731__$1 = cljs.core.first(inst_60730);
var inst_60732 = cljs.core.next(inst_60730);
var inst_60733 = cljs.core.not(inst_60731__$1);
var state_60848__$1 = (function (){var statearr_60866 = state_60848;
(statearr_60866[(16)] = inst_60731__$1);

(statearr_60866[(20)] = inst_60732);

return statearr_60866;
})();
if(inst_60733){
var statearr_60867_60914 = state_60848__$1;
(statearr_60867_60914[(1)] = (8));

} else {
var statearr_60868_60915 = state_60848__$1;
(statearr_60868_60915[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60849 === (28))){
var inst_60821 = (state_60848[(26)]);
var inst_60814 = (state_60848[(27)]);
var inst_60831 = (state_60848[(2)]);
var inst_60832 = fluree.db.util.async.throw_err(inst_60831);
var inst_60833 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_60814,inst_60832);
var inst_60813 = inst_60821;
var inst_60814__$1 = inst_60833;
var state_60848__$1 = (function (){var statearr_60869 = state_60848;
(statearr_60869[(28)] = inst_60813);

(statearr_60869[(27)] = inst_60814__$1);

return statearr_60869;
})();
var statearr_60870_60916 = state_60848__$1;
(statearr_60870_60916[(2)] = null);

(statearr_60870_60916[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60849 === (25))){
var inst_60814 = (state_60848[(27)]);
var state_60848__$1 = state_60848;
var statearr_60871_60917 = state_60848__$1;
(statearr_60871_60917[(2)] = inst_60814);

(statearr_60871_60917[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60849 === (17))){
var inst_60775 = (state_60848[(7)]);
var inst_60782 = (state_60848[(12)]);
var inst_60781 = cljs.core.seq(inst_60775);
var inst_60782__$1 = cljs.core.first(inst_60781);
var inst_60783 = cljs.core.next(inst_60781);
var inst_60784 = cljs.core.not(inst_60782__$1);
var state_60848__$1 = (function (){var statearr_60872 = state_60848;
(statearr_60872[(12)] = inst_60782__$1);

(statearr_60872[(25)] = inst_60783);

return statearr_60872;
})();
if(inst_60784){
var statearr_60873_60918 = state_60848__$1;
(statearr_60873_60918[(1)] = (19));

} else {
var statearr_60874_60919 = state_60848__$1;
(statearr_60874_60919[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60849 === (3))){
var inst_60846 = (state_60848[(2)]);
var state_60848__$1 = state_60848;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60848__$1,inst_60846);
} else {
if((state_val_60849 === (12))){
var inst_60731 = (state_60848[(16)]);
var inst_60744 = fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1(inst_60731);
var state_60848__$1 = state_60848;
var statearr_60875_60920 = state_60848__$1;
(statearr_60875_60920[(2)] = inst_60744);

(statearr_60875_60920[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60849 === (2))){
var inst_60717 = (state_60848[(21)]);
var _ = (function (){var statearr_60876 = state_60848;
(statearr_60876[(4)] = cljs.core.cons((5),(state_60848[(4)])));

return statearr_60876;
})();
var inst_60717__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60718 = cljs.core.seq(inst_60717__$1);
var inst_60719 = cljs.core.first(inst_60718);
var inst_60720 = cljs.core.next(inst_60718);
var inst_60721 = cljs.core.PersistentHashMap.EMPTY;
var inst_60722 = cljs.core.PersistentHashMap.EMPTY;
var inst_60723 = inst_60717__$1;
var inst_60724 = inst_60721;
var inst_60725 = inst_60722;
var state_60848__$1 = (function (){var statearr_60877 = state_60848;
(statearr_60877[(14)] = inst_60723);

(statearr_60877[(15)] = inst_60725);

(statearr_60877[(19)] = inst_60724);

(statearr_60877[(21)] = inst_60717__$1);

(statearr_60877[(22)] = inst_60719);

(statearr_60877[(24)] = inst_60720);

return statearr_60877;
})();
var statearr_60878_60921 = state_60848__$1;
(statearr_60878_60921[(2)] = null);

(statearr_60878_60921[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60849 === (23))){
var inst_60813 = (state_60848[(28)]);
var inst_60820 = (state_60848[(29)]);
var inst_60819 = cljs.core.seq(inst_60813);
var inst_60820__$1 = cljs.core.first(inst_60819);
var inst_60821 = cljs.core.next(inst_60819);
var inst_60822 = cljs.core.not(inst_60820__$1);
var state_60848__$1 = (function (){var statearr_60879 = state_60848;
(statearr_60879[(26)] = inst_60821);

(statearr_60879[(29)] = inst_60820__$1);

return statearr_60879;
})();
if(inst_60822){
var statearr_60880_60922 = state_60848__$1;
(statearr_60880_60922[(1)] = (25));

} else {
var statearr_60881_60923 = state_60848__$1;
(statearr_60881_60923[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60849 === (19))){
var inst_60776 = (state_60848[(9)]);
var state_60848__$1 = state_60848;
var statearr_60882_60924 = state_60848__$1;
(statearr_60882_60924[(2)] = inst_60776);

(statearr_60882_60924[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60849 === (11))){
var inst_60731 = (state_60848[(16)]);
var state_60848__$1 = state_60848;
var statearr_60884_60925 = state_60848__$1;
(statearr_60884_60925[(2)] = inst_60731);

(statearr_60884_60925[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60849 === (9))){
var inst_60731 = (state_60848[(16)]);
var inst_60741 = (state_60848[(23)]);
var inst_60739 = inst_60731.s;
var inst_60740 = inst_60731.op;
var inst_60741__$1 = inst_60740 === true;
var state_60848__$1 = (function (){var statearr_60886 = state_60848;
(statearr_60886[(17)] = inst_60739);

(statearr_60886[(23)] = inst_60741__$1);

return statearr_60886;
})();
if(cljs.core.truth_(inst_60741__$1)){
var statearr_60887_60926 = state_60848__$1;
(statearr_60887_60926[(1)] = (11));

} else {
var statearr_60888_60927 = state_60848__$1;
(statearr_60888_60927[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60849 === (5))){
var _ = (function (){var statearr_60889 = state_60848;
(statearr_60889[(4)] = cljs.core.rest((state_60848[(4)])));

return statearr_60889;
})();
var state_60848__$1 = state_60848;
var ex60883 = (state_60848__$1[(2)]);
var statearr_60890_60928 = state_60848__$1;
(statearr_60890_60928[(5)] = ex60883);


if((ex60883 instanceof Error)){
var statearr_60891_60929 = state_60848__$1;
(statearr_60891_60929[(1)] = (4));

(statearr_60891_60929[(5)] = null);

} else {
throw ex60883;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60849 === (14))){
var inst_60723 = (state_60848[(14)]);
var inst_60725 = (state_60848[(15)]);
var inst_60731 = (state_60848[(16)]);
var inst_60739 = (state_60848[(17)]);
var inst_60746 = (state_60848[(18)]);
var inst_60724 = (state_60848[(19)]);
var inst_60732 = (state_60848[(20)]);
var inst_60717 = (state_60848[(21)]);
var inst_60719 = (state_60848[(22)]);
var inst_60741 = (state_60848[(23)]);
var inst_60720 = (state_60848[(24)]);
var inst_60748 = (function (){var first__60729 = inst_60731;
var subject = inst_60739;
var flake = inst_60731;
var vec__60714 = inst_60717;
var r = inst_60732;
var vec__60727 = inst_60723;
var G__60713 = inst_60723;
var asserted_subjects = inst_60724;
var seq__60728 = inst_60732;
var flake_SINGLEQUOTE_ = inst_60746;
var retracted_subjects = inst_60725;
var asserted_QMARK_ = inst_60741;
var first__60716 = inst_60719;
var seq__60715 = inst_60720;
return (function (p1__60699_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__60699_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_60749 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_60724,inst_60739,inst_60748);
var tmp60885 = inst_60725;
var inst_60723__$1 = inst_60732;
var inst_60724__$1 = inst_60749;
var inst_60725__$1 = tmp60885;
var state_60848__$1 = (function (){var statearr_60892 = state_60848;
(statearr_60892[(14)] = inst_60723__$1);

(statearr_60892[(15)] = inst_60725__$1);

(statearr_60892[(19)] = inst_60724__$1);

return statearr_60892;
})();
var statearr_60893_60930 = state_60848__$1;
(statearr_60893_60930[(2)] = null);

(statearr_60893_60930[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60849 === (26))){
var inst_60820 = (state_60848[(29)]);
var inst_60825 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_60826 = cljs.core.PersistentHashMap.EMPTY;
var inst_60827 = [true,inst_60826];
var inst_60828 = cljs.core.PersistentHashMap.fromArrays(inst_60825,inst_60827);
var inst_60829 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_60828,inst_60820);
var state_60848__$1 = state_60848;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60848__$1,(28),inst_60829);
} else {
if((state_val_60849 === (16))){
var inst_60756 = (state_60848[(2)]);
var state_60848__$1 = state_60848;
var statearr_60894_60931 = state_60848__$1;
(statearr_60894_60931[(2)] = inst_60756);

(statearr_60894_60931[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60849 === (10))){
var inst_60758 = (state_60848[(2)]);
var state_60848__$1 = state_60848;
var statearr_60895_60932 = state_60848__$1;
(statearr_60895_60932[(2)] = inst_60758);

(statearr_60895_60932[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60849 === (18))){
var inst_60761 = (state_60848[(8)]);
var inst_60800 = (state_60848[(2)]);
var inst_60808 = cljs.core.vals(inst_60761);
var inst_60809 = cljs.core.seq(inst_60808);
var inst_60810 = cljs.core.first(inst_60809);
var inst_60811 = cljs.core.next(inst_60809);
var inst_60812 = cljs.core.PersistentVector.EMPTY;
var inst_60813 = inst_60808;
var inst_60814 = inst_60812;
var state_60848__$1 = (function (){var statearr_60896 = state_60848;
(statearr_60896[(28)] = inst_60813);

(statearr_60896[(30)] = inst_60811);

(statearr_60896[(31)] = inst_60810);

(statearr_60896[(13)] = inst_60800);

(statearr_60896[(27)] = inst_60814);

return statearr_60896;
})();
var statearr_60897_60933 = state_60848__$1;
(statearr_60897_60933[(2)] = null);

(statearr_60897_60933[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60849 === (8))){
var inst_60725 = (state_60848[(15)]);
var inst_60724 = (state_60848[(19)]);
var inst_60735 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60736 = [inst_60724,inst_60725];
var inst_60737 = (new cljs.core.PersistentVector(null,2,(5),inst_60735,inst_60736,null));
var state_60848__$1 = state_60848;
var statearr_60898_60934 = state_60848__$1;
(statearr_60898_60934[(2)] = inst_60737);

(statearr_60898_60934[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2749__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2749__auto____0 = (function (){
var statearr_60899 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60899[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2749__auto__);

(statearr_60899[(1)] = (1));

return statearr_60899;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2749__auto____1 = (function (state_60848){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_60848);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e60900){var ex__2752__auto__ = e60900;
var statearr_60901_60935 = state_60848;
(statearr_60901_60935[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_60848[(4)]))){
var statearr_60902_60936 = state_60848;
(statearr_60902_60936[(1)] = cljs.core.first((state_60848[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60937 = state_60848;
state_60848 = G__60937;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2749__auto__ = function(state_60848){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2749__auto____1.call(this,state_60848);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2749__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2749__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_60903 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_60903[(6)] = c__2771__auto__);

return statearr_60903;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_60969){
var state_val_60970 = (state_60969[(1)]);
if((state_val_60970 === (1))){
var inst_60938 = cljs.core.volatile_BANG_((0));
var inst_60939 = cljs.core.PersistentHashMap.EMPTY;
var inst_60940 = cljs.core.volatile_BANG_(inst_60939);
var inst_60941 = cljs.core.first(resp);
var inst_60942 = cljs.core.rest(resp);
var inst_60943 = cljs.core.PersistentVector.EMPTY;
var inst_60944 = inst_60938;
var inst_60945 = inst_60940;
var inst_60946 = inst_60941;
var inst_60947 = inst_60942;
var inst_60948 = inst_60943;
var state_60969__$1 = (function (){var statearr_60971 = state_60969;
(statearr_60971[(7)] = inst_60948);

(statearr_60971[(8)] = inst_60944);

(statearr_60971[(9)] = inst_60946);

(statearr_60971[(10)] = inst_60947);

(statearr_60971[(11)] = inst_60945);

return statearr_60971;
})();
var statearr_60972_60987 = state_60969__$1;
(statearr_60972_60987[(2)] = null);

(statearr_60972_60987[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60970 === (2))){
var inst_60944 = (state_60969[(8)]);
var inst_60946 = (state_60969[(9)]);
var inst_60945 = (state_60969[(11)]);
var inst_60950 = fluree.db.api.query.format_block_resp_pretty(db,inst_60946,inst_60945,inst_60944);
var state_60969__$1 = state_60969;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60969__$1,(4),inst_60950);
} else {
if((state_val_60970 === (3))){
var inst_60967 = (state_60969[(2)]);
var state_60969__$1 = state_60969;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60969__$1,inst_60967);
} else {
if((state_val_60970 === (4))){
var inst_60948 = (state_60969[(7)]);
var inst_60947 = (state_60969[(10)]);
var inst_60952 = (state_60969[(2)]);
var inst_60953 = fluree.db.util.async.throw_err(inst_60952);
var inst_60954 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60955 = [inst_60953];
var inst_60956 = (new cljs.core.PersistentVector(null,1,(5),inst_60954,inst_60955,null));
var inst_60957 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_60948,inst_60956);
var inst_60958 = cljs.core.first(inst_60947);
var state_60969__$1 = (function (){var statearr_60975 = state_60969;
(statearr_60975[(12)] = inst_60957);

return statearr_60975;
})();
if(cljs.core.truth_(inst_60958)){
var statearr_60976_60988 = state_60969__$1;
(statearr_60976_60988[(1)] = (5));

} else {
var statearr_60977_60989 = state_60969__$1;
(statearr_60977_60989[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60970 === (5))){
var inst_60944 = (state_60969[(8)]);
var inst_60947 = (state_60969[(10)]);
var inst_60957 = (state_60969[(12)]);
var inst_60945 = (state_60969[(11)]);
var inst_60960 = cljs.core.first(inst_60947);
var inst_60961 = cljs.core.rest(inst_60947);
var tmp60973 = inst_60944;
var tmp60974 = inst_60945;
var inst_60944__$1 = tmp60973;
var inst_60945__$1 = tmp60974;
var inst_60946 = inst_60960;
var inst_60947__$1 = inst_60961;
var inst_60948 = inst_60957;
var state_60969__$1 = (function (){var statearr_60978 = state_60969;
(statearr_60978[(7)] = inst_60948);

(statearr_60978[(8)] = inst_60944__$1);

(statearr_60978[(9)] = inst_60946);

(statearr_60978[(10)] = inst_60947__$1);

(statearr_60978[(11)] = inst_60945__$1);

return statearr_60978;
})();
var statearr_60979_60990 = state_60969__$1;
(statearr_60979_60990[(2)] = null);

(statearr_60979_60990[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60970 === (6))){
var inst_60957 = (state_60969[(12)]);
var state_60969__$1 = state_60969;
var statearr_60980_60991 = state_60969__$1;
(statearr_60980_60991[(2)] = inst_60957);

(statearr_60980_60991[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60970 === (7))){
var inst_60965 = (state_60969[(2)]);
var state_60969__$1 = state_60969;
var statearr_60981_60992 = state_60969__$1;
(statearr_60981_60992[(2)] = inst_60965);

(statearr_60981_60992[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2749__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2749__auto____0 = (function (){
var statearr_60982 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60982[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2749__auto__);

(statearr_60982[(1)] = (1));

return statearr_60982;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2749__auto____1 = (function (state_60969){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_60969);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e60983){var ex__2752__auto__ = e60983;
var statearr_60984_60993 = state_60969;
(statearr_60984_60993[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_60969[(4)]))){
var statearr_60985_60994 = state_60969;
(statearr_60985_60994[(1)] = cljs.core.first((state_60969[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60995 = state_60969;
state_60969 = G__60995;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2749__auto__ = function(state_60969){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2749__auto____1.call(this,state_60969);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2749__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2749__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_60986 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_60986[(6)] = c__2771__auto__);

return statearr_60986;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__60997 = arguments.length;
switch (G__60997) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range(db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__60999){
var map__61000 = p__60999;
var map__61000__$1 = cljs.core.__destructure_map(map__61000);
var query = map__61000__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__61000__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_61085){
var state_val_61086 = (state_61085[(1)]);
if((state_val_61086 === (7))){
var inst_61011 = (state_61085[(7)]);
var inst_61015 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61016 = ["_auth/id",inst_61011];
var inst_61017 = (new cljs.core.PersistentVector(null,2,(5),inst_61015,inst_61016,null));
var state_61085__$1 = state_61085;
var statearr_61087_61131 = state_61085__$1;
(statearr_61087_61131[(2)] = inst_61017);

(statearr_61087_61131[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61086 === (20))){
var inst_61065 = (state_61085[(2)]);
var inst_61066 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_61085__$1 = (function (){var statearr_61088 = state_61085;
(statearr_61088[(8)] = inst_61065);

return statearr_61088;
})();
if(cljs.core.truth_(inst_61066)){
var statearr_61089_61132 = state_61085__$1;
(statearr_61089_61132[(1)] = (22));

} else {
var statearr_61090_61133 = state_61085__$1;
(statearr_61090_61133[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61086 === (27))){
var inst_61068 = (state_61085[(9)]);
var inst_61012 = (state_61085[(10)]);
var inst_61074 = (state_61085[(2)]);
var inst_61075 = fluree.db.util.core.response_time_formatted(inst_61012);
var inst_61076 = [(200),inst_61074,(100),inst_61075];
var inst_61077 = cljs.core.PersistentHashMap.fromArrays(inst_61068,inst_61076);
var state_61085__$1 = state_61085;
var statearr_61091_61134 = state_61085__$1;
(statearr_61091_61134[(2)] = inst_61077);

(statearr_61091_61134[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61086 === (1))){
var state_61085__$1 = state_61085;
var statearr_61092_61135 = state_61085__$1;
(statearr_61092_61135[(2)] = null);

(statearr_61092_61135[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61086 === (24))){
var inst_61080 = (state_61085[(2)]);
var _ = (function (){var statearr_61093 = state_61085;
(statearr_61093[(4)] = cljs.core.rest((state_61085[(4)])));

return statearr_61093;
})();
var state_61085__$1 = state_61085;
var statearr_61094_61136 = state_61085__$1;
(statearr_61094_61136[(2)] = inst_61080);

(statearr_61094_61136[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61086 === (4))){
var inst_61001 = (state_61085[(2)]);
var state_61085__$1 = state_61085;
var statearr_61095_61137 = state_61085__$1;
(statearr_61095_61137[(2)] = inst_61001);

(statearr_61095_61137[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61086 === (15))){
var inst_61052 = (state_61085[(11)]);
var state_61085__$1 = state_61085;
var statearr_61096_61138 = state_61085__$1;
(statearr_61096_61138[(2)] = inst_61052);

(statearr_61096_61138[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61086 === (21))){
var inst_61061 = (state_61085[(2)]);
var inst_61062 = fluree.db.util.async.throw_err(inst_61061);
var state_61085__$1 = state_61085;
var statearr_61097_61139 = state_61085__$1;
(statearr_61097_61139[(2)] = inst_61062);

(statearr_61097_61139[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61086 === (13))){
var inst_61052 = (state_61085[(11)]);
var inst_61010 = (state_61085[(12)]);
var inst_61051 = (state_61085[(2)]);
var inst_61052__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_61010);
var state_61085__$1 = (function (){var statearr_61098 = state_61085;
(statearr_61098[(11)] = inst_61052__$1);

(statearr_61098[(13)] = inst_61051);

return statearr_61098;
})();
if(cljs.core.truth_(inst_61052__$1)){
var statearr_61099_61140 = state_61085__$1;
(statearr_61099_61140[(1)] = (15));

} else {
var statearr_61100_61141 = state_61085__$1;
(statearr_61100_61141[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61086 === (22))){
var inst_61065 = (state_61085[(8)]);
var inst_61068 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_61069 = cljs.core.sequential_QMARK_(inst_61065);
var state_61085__$1 = (function (){var statearr_61101 = state_61085;
(statearr_61101[(9)] = inst_61068);

return statearr_61101;
})();
if(inst_61069){
var statearr_61102_61142 = state_61085__$1;
(statearr_61102_61142[(1)] = (25));

} else {
var statearr_61103_61143 = state_61085__$1;
(statearr_61103_61143[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61086 === (6))){
var inst_61010 = (state_61085[(12)]);
var inst_61026 = (state_61085[(14)]);
var inst_61025 = (state_61085[(2)]);
var inst_61026__$1 = fluree.db.util.async.throw_err(inst_61025);
var inst_61027 = fluree.db.api.query.resolve_block_range(inst_61026__$1,inst_61010);
var state_61085__$1 = (function (){var statearr_61104 = state_61085;
(statearr_61104[(14)] = inst_61026__$1);

return statearr_61104;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61085__$1,(10),inst_61027);
} else {
if((state_val_61086 === (25))){
var inst_61065 = (state_61085[(8)]);
var inst_61071 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_61065);
var state_61085__$1 = state_61085;
var statearr_61105_61144 = state_61085__$1;
(statearr_61105_61144[(2)] = inst_61071);

(statearr_61105_61144[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61086 === (17))){
var inst_61057 = (state_61085[(2)]);
var state_61085__$1 = state_61085;
if(cljs.core.truth_(inst_61057)){
var statearr_61106_61145 = state_61085__$1;
(statearr_61106_61145[(1)] = (18));

} else {
var statearr_61107_61146 = state_61085__$1;
(statearr_61107_61146[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61086 === (3))){
var inst_61083 = (state_61085[(2)]);
var state_61085__$1 = state_61085;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61085__$1,inst_61083);
} else {
if((state_val_61086 === (12))){
var inst_61010 = (state_61085[(12)]);
var inst_61043 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_61010], 0));
var inst_61044 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_61043].join('');
var inst_61045 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61046 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61047 = cljs.core.PersistentHashMap.fromArrays(inst_61045,inst_61046);
var inst_61048 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_61044,inst_61047);
var inst_61049 = (function(){throw inst_61048})();
var state_61085__$1 = state_61085;
var statearr_61108_61147 = state_61085__$1;
(statearr_61108_61147[(2)] = inst_61049);

(statearr_61108_61147[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61086 === (2))){
var inst_61011 = (state_61085[(7)]);
var _ = (function (){var statearr_61109 = state_61085;
(statearr_61109[(4)] = cljs.core.cons((5),(state_61085[(4)])));

return statearr_61109;
})();
var inst_61010 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_61011__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_61012 = fluree.db.util.core.current_time_millis();
var inst_61013 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_61085__$1 = (function (){var statearr_61110 = state_61085;
(statearr_61110[(15)] = inst_61013);

(statearr_61110[(12)] = inst_61010);

(statearr_61110[(10)] = inst_61012);

(statearr_61110[(7)] = inst_61011__$1);

return statearr_61110;
})();
if(cljs.core.truth_(inst_61011__$1)){
var statearr_61111_61148 = state_61085__$1;
(statearr_61111_61148[(1)] = (7));

} else {
var statearr_61112_61149 = state_61085__$1;
(statearr_61112_61149[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61086 === (23))){
var inst_61065 = (state_61085[(8)]);
var state_61085__$1 = state_61085;
var statearr_61113_61150 = state_61085__$1;
(statearr_61113_61150[(2)] = inst_61065);

(statearr_61113_61150[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61086 === (19))){
var inst_61051 = (state_61085[(13)]);
var state_61085__$1 = state_61085;
var statearr_61114_61151 = state_61085__$1;
(statearr_61114_61151[(2)] = inst_61051);

(statearr_61114_61151[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61086 === (11))){
var inst_61026 = (state_61085[(14)]);
var inst_61032 = (state_61085[(16)]);
var inst_61031 = (state_61085[(17)]);
var inst_61038 = fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(inst_61026,inst_61031,inst_61032,opts);
var state_61085__$1 = state_61085;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61085__$1,(14),inst_61038);
} else {
if((state_val_61086 === (9))){
var inst_61013 = (state_61085[(15)]);
var inst_61020 = (state_61085[(2)]);
var inst_61021 = [inst_61020];
var inst_61022 = cljs.core.PersistentHashMap.fromArrays(inst_61013,inst_61021);
var inst_61023 = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,inst_61022);
var state_61085__$1 = state_61085;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61085__$1,(6),inst_61023);
} else {
if((state_val_61086 === (5))){
var _ = (function (){var statearr_61116 = state_61085;
(statearr_61116[(4)] = cljs.core.rest((state_61085[(4)])));

return statearr_61116;
})();
var state_61085__$1 = state_61085;
var ex61115 = (state_61085__$1[(2)]);
var statearr_61117_61152 = state_61085__$1;
(statearr_61117_61152[(5)] = ex61115);


if((ex61115 instanceof Error)){
var statearr_61118_61153 = state_61085__$1;
(statearr_61118_61153[(1)] = (4));

(statearr_61118_61153[(5)] = null);

} else {
throw ex61115;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61086 === (14))){
var inst_61040 = (state_61085[(2)]);
var inst_61041 = fluree.db.util.async.throw_err(inst_61040);
var state_61085__$1 = state_61085;
var statearr_61119_61154 = state_61085__$1;
(statearr_61119_61154[(2)] = inst_61041);

(statearr_61119_61154[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61086 === (26))){
var inst_61065 = (state_61085[(8)]);
var state_61085__$1 = state_61085;
var statearr_61120_61155 = state_61085__$1;
(statearr_61120_61155[(2)] = inst_61065);

(statearr_61120_61155[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61086 === (16))){
var inst_61010 = (state_61085[(12)]);
var inst_61055 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_61010);
var state_61085__$1 = state_61085;
var statearr_61121_61156 = state_61085__$1;
(statearr_61121_61156[(2)] = inst_61055);

(statearr_61121_61156[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61086 === (10))){
var inst_61010 = (state_61085[(12)]);
var inst_61029 = (state_61085[(2)]);
var inst_61030 = fluree.db.util.async.throw_err(inst_61029);
var inst_61031 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61030,(0),null);
var inst_61032 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61030,(1),null);
var inst_61033 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_61034 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(inst_61010,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)], 0));
var inst_61035 = cljs.core.keys(inst_61034);
var inst_61036 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61033,inst_61035);
var state_61085__$1 = (function (){var statearr_61122 = state_61085;
(statearr_61122[(16)] = inst_61032);

(statearr_61122[(17)] = inst_61031);

return statearr_61122;
})();
if(inst_61036){
var statearr_61123_61157 = state_61085__$1;
(statearr_61123_61157[(1)] = (11));

} else {
var statearr_61124_61158 = state_61085__$1;
(statearr_61124_61158[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61086 === (18))){
var inst_61051 = (state_61085[(13)]);
var inst_61026 = (state_61085[(14)]);
var inst_61059 = fluree.db.api.query.format_blocks_resp_pretty(inst_61026,inst_61051);
var state_61085__$1 = state_61085;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61085__$1,(21),inst_61059);
} else {
if((state_val_61086 === (8))){
var state_61085__$1 = state_61085;
var statearr_61125_61159 = state_61085__$1;
(statearr_61125_61159[(2)] = null);

(statearr_61125_61159[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2749__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2749__auto____0 = (function (){
var statearr_61126 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61126[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2749__auto__);

(statearr_61126[(1)] = (1));

return statearr_61126;
});
var fluree$db$api$query$block_query_async_$_state_machine__2749__auto____1 = (function (state_61085){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_61085);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e61127){var ex__2752__auto__ = e61127;
var statearr_61128_61160 = state_61085;
(statearr_61128_61160[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_61085[(4)]))){
var statearr_61129_61161 = state_61085;
(statearr_61129_61161[(1)] = cljs.core.first((state_61085[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61162 = state_61085;
state_61085 = G__61162;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2749__auto__ = function(state_61085){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2749__auto____1.call(this,state_61085);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2749__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2749__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_61130 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_61130[(6)] = c__2771__auto__);

return statearr_61130;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_(history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_(history))?((cljs.core.empty_QMARK_(history))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__61163 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(0)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(1)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(2)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(3))], null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61163,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61163,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61163,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61163,(3),null);
var vec__61166 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61166,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61166,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__61169 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61169,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61169,(1),null);
var or__5045__auto__ = (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(auth) : auth_set.call(null,auth));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(id) : auth_set.call(null,id));
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__5774__auto__ = [];
var len__5768__auto___61173 = arguments.length;
var i__5769__auto___61174 = (0);
while(true){
if((i__5769__auto___61174 < len__5768__auto___61173)){
args__5774__auto__.push((arguments[i__5769__auto___61174]));

var G__61175 = (i__5769__auto___61174 + (1));
i__5769__auto___61174 = G__61175;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq61172){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq61172));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_61371){
var state_val_61372 = (state_61371[(1)]);
if((state_val_61372 === (7))){
var inst_61298 = (state_61371[(7)]);
var inst_61291 = (state_61371[(8)]);
var inst_61297 = cljs.core.seq(inst_61291);
var inst_61298__$1 = cljs.core.first(inst_61297);
var inst_61299 = cljs.core.next(inst_61297);
var state_61371__$1 = (function (){var statearr_61373 = state_61371;
(statearr_61373[(7)] = inst_61298__$1);

(statearr_61373[(9)] = inst_61299);

return statearr_61373;
})();
if(cljs.core.truth_(inst_61298__$1)){
var statearr_61374_61474 = state_61371__$1;
(statearr_61374_61474[(1)] = (9));

} else {
var statearr_61375_61475 = state_61371__$1;
(statearr_61375_61475[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (20))){
var inst_61361 = (state_61371[(2)]);
var state_61371__$1 = state_61371;
var statearr_61376_61476 = state_61371__$1;
(statearr_61376_61476[(2)] = inst_61361);

(statearr_61376_61476[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (27))){
var inst_61319 = (state_61371[(10)]);
var inst_61337 = (state_61371[(11)]);
var inst_61316 = (state_61371[(12)]);
var inst_61339 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61340 = [inst_61319,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_61341 = (new cljs.core.PersistentVector(null,2,(5),inst_61339,inst_61340,null));
var inst_61342 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_61337,inst_61341,fluree.db.api.query.min_safe,inst_61316);
var state_61371__$1 = state_61371;
var statearr_61377_61477 = state_61371__$1;
(statearr_61377_61477[(2)] = inst_61342);

(statearr_61377_61477[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (1))){
var state_61371__$1 = state_61371;
var statearr_61378_61478 = state_61371__$1;
(statearr_61378_61478[(2)] = null);

(statearr_61378_61478[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (24))){
var inst_61329 = (state_61371[(13)]);
var inst_61298 = (state_61371[(7)]);
var inst_61319 = (state_61371[(10)]);
var inst_61331 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61332 = [inst_61319,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_61333 = (new cljs.core.PersistentVector(null,2,(5),inst_61331,inst_61332,null));
var inst_61334 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_61329,inst_61333,cljs.core.conj,inst_61298);
var state_61371__$1 = state_61371;
var statearr_61380_61479 = state_61371__$1;
(statearr_61380_61479[(2)] = inst_61334);

(statearr_61380_61479[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (4))){
var inst_61177 = (state_61371[(2)]);
var state_61371__$1 = state_61371;
var statearr_61381_61480 = state_61371__$1;
(statearr_61381_61480[(2)] = inst_61177);

(statearr_61381_61480[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (15))){
var inst_61299 = (state_61371[(9)]);
var inst_61292 = (state_61371[(14)]);
var tmp61379 = inst_61292;
var inst_61291 = inst_61299;
var inst_61292__$1 = tmp61379;
var state_61371__$1 = (function (){var statearr_61382 = state_61371;
(statearr_61382[(8)] = inst_61291);

(statearr_61382[(14)] = inst_61292__$1);

return statearr_61382;
})();
var statearr_61383_61481 = state_61371__$1;
(statearr_61383_61481[(2)] = null);

(statearr_61383_61481[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (21))){
var inst_61319 = (state_61371[(10)]);
var inst_61292 = (state_61371[(14)]);
var inst_61323 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61324 = [inst_61319,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_61325 = (new cljs.core.PersistentVector(null,2,(5),inst_61323,inst_61324,null));
var inst_61326 = cljs.core.assoc_in(inst_61292,inst_61325,inst_61319);
var state_61371__$1 = state_61371;
var statearr_61384_61482 = state_61371__$1;
(statearr_61384_61482[(2)] = inst_61326);

(statearr_61384_61482[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (31))){
var inst_61345 = (state_61371[(15)]);
var state_61371__$1 = state_61371;
var statearr_61385_61483 = state_61371__$1;
(statearr_61385_61483[(2)] = inst_61345);

(statearr_61385_61483[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (32))){
var inst_61299 = (state_61371[(9)]);
var inst_61353 = (state_61371[(2)]);
var inst_61291 = inst_61299;
var inst_61292 = inst_61353;
var state_61371__$1 = (function (){var statearr_61386 = state_61371;
(statearr_61386[(8)] = inst_61291);

(statearr_61386[(14)] = inst_61292);

return statearr_61386;
})();
var statearr_61387_61484 = state_61371__$1;
(statearr_61387_61484[(2)] = null);

(statearr_61387_61484[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (33))){
var inst_61292 = (state_61371[(14)]);
var state_61371__$1 = state_61371;
var statearr_61388_61485 = state_61371__$1;
(statearr_61388_61485[(2)] = inst_61292);

(statearr_61388_61485[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (13))){
var inst_61301 = (state_61371[(16)]);
var state_61371__$1 = state_61371;
var statearr_61389_61486 = state_61371__$1;
(statearr_61389_61486[(2)] = inst_61301);

(statearr_61389_61486[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (22))){
var inst_61292 = (state_61371[(14)]);
var state_61371__$1 = state_61371;
var statearr_61390_61487 = state_61371__$1;
(statearr_61390_61487[(2)] = inst_61292);

(statearr_61390_61487[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (29))){
var inst_61345 = (state_61371[(2)]);
var state_61371__$1 = (function (){var statearr_61391 = state_61371;
(statearr_61391[(15)] = inst_61345);

return statearr_61391;
})();
if(cljs.core.truth_(show_auth)){
var statearr_61392_61488 = state_61371__$1;
(statearr_61392_61488[(1)] = (30));

} else {
var statearr_61393_61489 = state_61371__$1;
(statearr_61393_61489[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (6))){
var inst_61277 = (state_61371[(2)]);
var inst_61278 = fluree.db.util.async.throw_err(inst_61277);
var inst_61286 = resp;
var inst_61287 = cljs.core.seq(inst_61286);
var inst_61288 = cljs.core.first(inst_61287);
var inst_61289 = cljs.core.next(inst_61287);
var inst_61290 = cljs.core.PersistentHashMap.EMPTY;
var inst_61291 = inst_61286;
var inst_61292 = inst_61290;
var state_61371__$1 = (function (){var statearr_61394 = state_61371;
(statearr_61394[(17)] = inst_61278);

(statearr_61394[(8)] = inst_61291);

(statearr_61394[(18)] = inst_61289);

(statearr_61394[(14)] = inst_61292);

(statearr_61394[(19)] = inst_61288);

return statearr_61394;
})();
var statearr_61395_61490 = state_61371__$1;
(statearr_61395_61490[(2)] = null);

(statearr_61395_61490[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (28))){
var inst_61337 = (state_61371[(11)]);
var state_61371__$1 = state_61371;
var statearr_61396_61491 = state_61371__$1;
(statearr_61396_61491[(2)] = inst_61337);

(statearr_61396_61491[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (25))){
var inst_61329 = (state_61371[(13)]);
var state_61371__$1 = state_61371;
var statearr_61397_61492 = state_61371__$1;
(statearr_61397_61492[(2)] = inst_61329);

(statearr_61397_61492[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (34))){
var state_61371__$1 = state_61371;
var statearr_61398_61493 = state_61371__$1;
(statearr_61398_61493[(2)] = null);

(statearr_61398_61493[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (17))){
var inst_61363 = (state_61371[(2)]);
var state_61371__$1 = state_61371;
var statearr_61399_61494 = state_61371__$1;
(statearr_61399_61494[(2)] = inst_61363);

(statearr_61399_61494[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (3))){
var inst_61369 = (state_61371[(2)]);
var state_61371__$1 = state_61371;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61371__$1,inst_61369);
} else {
if((state_val_61372 === (12))){
var inst_61278 = (state_61371[(17)]);
var inst_61298 = (state_61371[(7)]);
var inst_61303 = fluree.db.api.query.auth_match(auth,inst_61278,inst_61298);
var inst_61304 = cljs.core.not(inst_61303);
var state_61371__$1 = state_61371;
var statearr_61400_61495 = state_61371__$1;
(statearr_61400_61495[(2)] = inst_61304);

(statearr_61400_61495[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (2))){
var _ = (function (){var statearr_61401 = state_61371;
(statearr_61401[(4)] = cljs.core.cons((5),(state_61371[(4)])));

return statearr_61401;
})();
var inst_61183 = (function (){return (function (p1__61176_SHARP_){
return p1__61176_SHARP_.t;
});
})();
var inst_61184 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_61183,resp);
var inst_61185 = cljs.core.set(inst_61184);
var inst_61273 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_61274 = (function (){var ts = inst_61185;
var c__2771__auto____$1 = inst_61273;
return (function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_61271){
var state_val_61272 = (state_61271[(1)]);
if((state_val_61272 === (7))){
var inst_61205 = (state_61271[(7)]);
var inst_61211 = (state_61271[(8)]);
var inst_61199 = (state_61271[(9)]);
var inst_61217 = (state_61271[(10)]);
var inst_61210 = (state_61271[(2)]);
var inst_61211__$1 = fluree.db.util.async.throw_err(inst_61210);
var inst_61213 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61214 = [inst_61205,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_61215 = (new cljs.core.PersistentVector(null,2,(5),inst_61213,inst_61214,null));
var inst_61216 = cljs.core.assoc_in(inst_61199,inst_61215,inst_61211__$1);
var inst_61217__$1 = auth;
var state_61271__$1 = (function (){var statearr_61402 = state_61271;
(statearr_61402[(8)] = inst_61211__$1);

(statearr_61402[(10)] = inst_61217__$1);

(statearr_61402[(11)] = inst_61216);

return statearr_61402;
})();
if(cljs.core.truth_(inst_61217__$1)){
var statearr_61403_61496 = state_61271__$1;
(statearr_61403_61496[(1)] = (8));

} else {
var statearr_61404_61497 = state_61271__$1;
(statearr_61404_61497[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61272 === (1))){
var inst_61193 = (state_61271[(12)]);
var inst_61193__$1 = ts;
var inst_61194 = cljs.core.seq(inst_61193__$1);
var inst_61195 = cljs.core.first(inst_61194);
var inst_61196 = cljs.core.next(inst_61194);
var inst_61197 = cljs.core.PersistentHashMap.EMPTY;
var inst_61198 = inst_61193__$1;
var inst_61199 = inst_61197;
var state_61271__$1 = (function (){var statearr_61405 = state_61271;
(statearr_61405[(13)] = inst_61198);

(statearr_61405[(9)] = inst_61199);

(statearr_61405[(14)] = inst_61196);

(statearr_61405[(15)] = inst_61195);

(statearr_61405[(12)] = inst_61193__$1);

return statearr_61405;
})();
var statearr_61406_61498 = state_61271__$1;
(statearr_61406_61498[(2)] = null);

(statearr_61406_61498[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61272 === (4))){
var inst_61205 = (state_61271[(7)]);
var inst_61208 = fluree.db.time_travel.non_border_t_to_block(db,inst_61205);
var state_61271__$1 = state_61271;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61271__$1,(7),inst_61208);
} else {
if((state_val_61272 === (13))){
var inst_61206 = (state_61271[(16)]);
var inst_61263 = (state_61271[(2)]);
var inst_61198 = inst_61206;
var inst_61199 = inst_61263;
var state_61271__$1 = (function (){var statearr_61407 = state_61271;
(statearr_61407[(13)] = inst_61198);

(statearr_61407[(9)] = inst_61199);

return statearr_61407;
})();
var statearr_61408_61499 = state_61271__$1;
(statearr_61408_61499[(2)] = null);

(statearr_61408_61499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61272 === (6))){
var inst_61267 = (state_61271[(2)]);
var state_61271__$1 = state_61271;
var statearr_61409_61500 = state_61271__$1;
(statearr_61409_61500[(2)] = inst_61267);

(statearr_61409_61500[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61272 === (3))){
var inst_61269 = (state_61271[(2)]);
var state_61271__$1 = state_61271;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61271__$1,inst_61269);
} else {
if((state_val_61272 === (12))){
var inst_61216 = (state_61271[(11)]);
var state_61271__$1 = state_61271;
var statearr_61410_61501 = state_61271__$1;
(statearr_61410_61501[(2)] = inst_61216);

(statearr_61410_61501[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61272 === (2))){
var inst_61205 = (state_61271[(7)]);
var inst_61198 = (state_61271[(13)]);
var inst_61204 = cljs.core.seq(inst_61198);
var inst_61205__$1 = cljs.core.first(inst_61204);
var inst_61206 = cljs.core.next(inst_61204);
var state_61271__$1 = (function (){var statearr_61411 = state_61271;
(statearr_61411[(7)] = inst_61205__$1);

(statearr_61411[(16)] = inst_61206);

return statearr_61411;
})();
if(cljs.core.truth_(inst_61205__$1)){
var statearr_61412_61502 = state_61271__$1;
(statearr_61412_61502[(1)] = (4));

} else {
var statearr_61413_61503 = state_61271__$1;
(statearr_61413_61503[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61272 === (11))){
var inst_61205 = (state_61271[(7)]);
var inst_61211 = (state_61271[(8)]);
var inst_61206 = (state_61271[(16)]);
var inst_61198 = (state_61271[(13)]);
var inst_61199 = (state_61271[(9)]);
var inst_61196 = (state_61271[(14)]);
var inst_61195 = (state_61271[(15)]);
var inst_61193 = (state_61271[(12)]);
var inst_61216 = (state_61271[(11)]);
var inst_61223 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61224 = [inst_61205,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_61225 = (new cljs.core.PersistentVector(null,2,(5),inst_61223,inst_61224,null));
var inst_61238 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_61239 = (function (){var vec__61201 = inst_61198;
var t = inst_61205;
var block = inst_61211;
var r = inst_61206;
var seq__61202 = inst_61206;
var vec__61190 = inst_61193;
var first__61192 = inst_61195;
var acc = inst_61199;
var G__61189 = inst_61198;
var first__61203 = inst_61205;
var G__61212 = inst_61216;
var c__2771__auto____$2 = inst_61238;
var seq__61191 = inst_61196;
return (function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_61236){
var state_val_61237 = (state_61236[(1)]);
if((state_val_61237 === (1))){
var state_61236__$1 = state_61236;
var statearr_61414_61504 = state_61236__$1;
(statearr_61414_61504[(2)] = null);

(statearr_61414_61504[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61237 === (2))){
var ___$1 = (function (){var statearr_61415 = state_61236;
(statearr_61415[(4)] = cljs.core.cons((5),(state_61236[(4)])));

return statearr_61415;
})();
var ___$2 = (function (){var statearr_61416 = state_61236;
(statearr_61416[(4)] = cljs.core.rest((state_61236[(4)])));

return statearr_61416;
})();
var state_61236__$1 = state_61236;
var statearr_61417_61505 = state_61236__$1;
(statearr_61417_61505[(2)] = db);

(statearr_61417_61505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61237 === (3))){
var inst_61234 = (state_61236[(2)]);
var state_61236__$1 = state_61236;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61236__$1,inst_61234);
} else {
if((state_val_61237 === (4))){
var inst_61226 = (state_61236[(2)]);
var state_61236__$1 = state_61236;
var statearr_61419_61506 = state_61236__$1;
(statearr_61419_61506[(2)] = inst_61226);

(statearr_61419_61506[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61237 === (5))){
var ___$1 = (function (){var statearr_61420 = state_61236;
(statearr_61420[(4)] = cljs.core.rest((state_61236[(4)])));

return statearr_61420;
})();
var state_61236__$1 = state_61236;
var ex61418 = (state_61236__$1[(2)]);
var statearr_61421_61507 = state_61236__$1;
(statearr_61421_61507[(5)] = ex61418);


if((ex61418 instanceof Error)){
var statearr_61422_61508 = state_61236__$1;
(statearr_61422_61508[(1)] = (4));

(statearr_61422_61508[(5)] = null);

} else {
throw ex61418;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2749__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2749__auto____0 = (function (){
var statearr_61423 = [null,null,null,null,null,null,null];
(statearr_61423[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2749__auto__);

(statearr_61423[(1)] = (1));

return statearr_61423;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2749__auto____1 = (function (state_61236){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_61236);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e61424){var ex__2752__auto__ = e61424;
var statearr_61425_61509 = state_61236;
(statearr_61425_61509[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_61236[(4)]))){
var statearr_61426_61510 = state_61236;
(statearr_61426_61510[(1)] = cljs.core.first((state_61236[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61511 = state_61236;
state_61236 = G__61511;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2749__auto__ = function(state_61236){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2749__auto____1.call(this,state_61236);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2749__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2749__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_61427 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_61427[(6)] = c__2771__auto____$2);

return statearr_61427;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
});
})();
var inst_61240 = cljs.core.async.impl.dispatch.run(inst_61239);
var inst_61241 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_61242 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61243 = ["?auth","?id"];
var inst_61244 = (new cljs.core.PersistentVector(null,2,(5),inst_61242,inst_61243,null));
var inst_61245 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61246 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61247 = [inst_61205,"_tx/auth","?auth"];
var inst_61248 = (new cljs.core.PersistentVector(null,3,(5),inst_61246,inst_61247,null));
var inst_61249 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61250 = ["?auth","_auth/id","?id"];
var inst_61251 = (new cljs.core.PersistentVector(null,3,(5),inst_61249,inst_61250,null));
var inst_61252 = [inst_61248,inst_61251];
var inst_61253 = (new cljs.core.PersistentVector(null,2,(5),inst_61245,inst_61252,null));
var inst_61254 = [inst_61244,inst_61253];
var inst_61255 = cljs.core.PersistentHashMap.fromArrays(inst_61241,inst_61254);
var inst_61256 = (fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2(inst_61238,inst_61255) : fluree.db.api.query.query_async.call(null,inst_61238,inst_61255));
var state_61271__$1 = (function (){var statearr_61428 = state_61271;
(statearr_61428[(17)] = inst_61225);

(statearr_61428[(18)] = inst_61240);

return statearr_61428;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61271__$1,(14),inst_61256);
} else {
if((state_val_61272 === (9))){
var state_61271__$1 = state_61271;
var statearr_61429_61512 = state_61271__$1;
(statearr_61429_61512[(2)] = show_auth);

(statearr_61429_61512[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61272 === (5))){
var inst_61199 = (state_61271[(9)]);
var state_61271__$1 = state_61271;
var statearr_61430_61513 = state_61271__$1;
(statearr_61430_61513[(2)] = inst_61199);

(statearr_61430_61513[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61272 === (14))){
var inst_61225 = (state_61271[(17)]);
var inst_61216 = (state_61271[(11)]);
var inst_61258 = (state_61271[(2)]);
var inst_61259 = fluree.db.util.async.throw_err(inst_61258);
var inst_61260 = cljs.core.assoc_in(inst_61216,inst_61225,inst_61259);
var state_61271__$1 = state_61271;
var statearr_61431_61514 = state_61271__$1;
(statearr_61431_61514[(2)] = inst_61260);

(statearr_61431_61514[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61272 === (10))){
var inst_61221 = (state_61271[(2)]);
var state_61271__$1 = state_61271;
if(cljs.core.truth_(inst_61221)){
var statearr_61432_61515 = state_61271__$1;
(statearr_61432_61515[(1)] = (11));

} else {
var statearr_61433_61516 = state_61271__$1;
(statearr_61433_61516[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61272 === (8))){
var inst_61217 = (state_61271[(10)]);
var state_61271__$1 = state_61271;
var statearr_61434_61517 = state_61271__$1;
(statearr_61434_61517[(2)] = inst_61217);

(statearr_61434_61517[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2749__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2749__auto____0 = (function (){
var statearr_61435 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61435[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2749__auto__);

(statearr_61435[(1)] = (1));

return statearr_61435;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2749__auto____1 = (function (state_61271){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_61271);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e61436){var ex__2752__auto__ = e61436;
var statearr_61437_61518 = state_61271;
(statearr_61437_61518[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_61271[(4)]))){
var statearr_61438_61519 = state_61271;
(statearr_61438_61519[(1)] = cljs.core.first((state_61271[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61520 = state_61271;
state_61271 = G__61520;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2749__auto__ = function(state_61271){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2749__auto____1.call(this,state_61271);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2749__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2749__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_61439 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_61439[(6)] = c__2771__auto____$1);

return statearr_61439;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
});
})();
var inst_61275 = cljs.core.async.impl.dispatch.run(inst_61274);
var state_61371__$1 = (function (){var statearr_61440 = state_61371;
(statearr_61440[(20)] = inst_61275);

return statearr_61440;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61371__$1,(6),inst_61273);
} else {
if((state_val_61372 === (23))){
var inst_61329 = (state_61371[(2)]);
var state_61371__$1 = (function (){var statearr_61441 = state_61371;
(statearr_61441[(13)] = inst_61329);

return statearr_61441;
})();
var statearr_61442_61521 = state_61371__$1;
(statearr_61442_61521[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (35))){
var inst_61359 = (state_61371[(2)]);
var state_61371__$1 = state_61371;
var statearr_61444_61522 = state_61371__$1;
(statearr_61444_61522[(2)] = inst_61359);

(statearr_61444_61522[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (19))){
var state_61371__$1 = state_61371;
var statearr_61445_61523 = state_61371__$1;
(statearr_61445_61523[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (11))){
var inst_61310 = (state_61371[(2)]);
var state_61371__$1 = state_61371;
if(cljs.core.truth_(inst_61310)){
var statearr_61448_61524 = state_61371__$1;
(statearr_61448_61524[(1)] = (15));

} else {
var statearr_61449_61525 = state_61371__$1;
(statearr_61449_61525[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (9))){
var inst_61301 = (state_61371[(16)]);
var inst_61301__$1 = auth;
var state_61371__$1 = (function (){var statearr_61450 = state_61371;
(statearr_61450[(16)] = inst_61301__$1);

return statearr_61450;
})();
if(cljs.core.truth_(inst_61301__$1)){
var statearr_61451_61526 = state_61371__$1;
(statearr_61451_61526[(1)] = (12));

} else {
var statearr_61452_61527 = state_61371__$1;
(statearr_61452_61527[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (5))){
var _ = (function (){var statearr_61453 = state_61371;
(statearr_61453[(4)] = cljs.core.rest((state_61371[(4)])));

return statearr_61453;
})();
var state_61371__$1 = state_61371;
var ex61447 = (state_61371__$1[(2)]);
var statearr_61454_61528 = state_61371__$1;
(statearr_61454_61528[(5)] = ex61447);


if((ex61447 instanceof Error)){
var statearr_61455_61529 = state_61371__$1;
(statearr_61455_61529[(1)] = (4));

(statearr_61455_61529[(5)] = null);

} else {
throw ex61447;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (14))){
var inst_61307 = (state_61371[(2)]);
var state_61371__$1 = state_61371;
var statearr_61456_61530 = state_61371__$1;
(statearr_61456_61530[(2)] = inst_61307);

(statearr_61456_61530[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (26))){
var inst_61337 = (state_61371[(2)]);
var state_61371__$1 = (function (){var statearr_61457 = state_61371;
(statearr_61457[(11)] = inst_61337);

return statearr_61457;
})();
var statearr_61458_61531 = state_61371__$1;
(statearr_61458_61531[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (16))){
var inst_61298 = (state_61371[(7)]);
var state_61371__$1 = state_61371;
if(cljs.core.truth_(inst_61298)){
var statearr_61460_61532 = state_61371__$1;
(statearr_61460_61532[(1)] = (18));

} else {
var statearr_61461_61533 = state_61371__$1;
(statearr_61461_61533[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (30))){
var inst_61345 = (state_61371[(15)]);
var inst_61319 = (state_61371[(10)]);
var inst_61320 = (state_61371[(21)]);
var inst_61347 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61348 = [inst_61319,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_61349 = (new cljs.core.PersistentVector(null,2,(5),inst_61347,inst_61348,null));
var inst_61350 = cljs.core.assoc_in(inst_61345,inst_61349,inst_61320);
var state_61371__$1 = state_61371;
var statearr_61462_61534 = state_61371__$1;
(statearr_61462_61534[(2)] = inst_61350);

(statearr_61462_61534[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (10))){
var inst_61298 = (state_61371[(7)]);
var state_61371__$1 = state_61371;
var statearr_61463_61535 = state_61371__$1;
(statearr_61463_61535[(2)] = inst_61298);

(statearr_61463_61535[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (18))){
var inst_61278 = (state_61371[(17)]);
var inst_61298 = (state_61371[(7)]);
var inst_61316 = (state_61371[(12)]);
var inst_61316__$1 = inst_61298.t;
var inst_61317 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61278,inst_61316__$1);
var inst_61318 = cljs.core.__destructure_map(inst_61317);
var inst_61319 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61318,new cljs.core.Keyword(null,"block","block",664686210));
var inst_61320 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61318,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_61371__$1 = (function (){var statearr_61464 = state_61371;
(statearr_61464[(10)] = inst_61319);

(statearr_61464[(21)] = inst_61320);

(statearr_61464[(12)] = inst_61316__$1);

return statearr_61464;
})();
var statearr_61465_61536 = state_61371__$1;
(statearr_61465_61536[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61372 === (8))){
var inst_61365 = (state_61371[(2)]);
var inst_61366 = cljs.core.vals(inst_61365);
var _ = (function (){var statearr_61467 = state_61371;
(statearr_61467[(4)] = cljs.core.rest((state_61371[(4)])));

return statearr_61467;
})();
var state_61371__$1 = state_61371;
var statearr_61468_61537 = state_61371__$1;
(statearr_61468_61537[(2)] = inst_61366);

(statearr_61468_61537[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2749__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2749__auto____0 = (function (){
var statearr_61469 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61469[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2749__auto__);

(statearr_61469[(1)] = (1));

return statearr_61469;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2749__auto____1 = (function (state_61371){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_61371);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e61470){var ex__2752__auto__ = e61470;
var statearr_61471_61538 = state_61371;
(statearr_61471_61538[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_61371[(4)]))){
var statearr_61472_61539 = state_61371;
(statearr_61472_61539[(1)] = cljs.core.first((state_61371[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61540 = state_61371;
state_61371 = G__61540;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2749__auto__ = function(state_61371){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2749__auto____1.call(this,state_61371);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2749__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2749__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_61473 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_61473[(6)] = c__2771__auto__);

return statearr_61473;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (block){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_61667){
var state_val_61668 = (state_61667[(1)]);
if((state_val_61668 === (7))){
var inst_61563 = (state_61667[(7)]);
var inst_61565 = fluree.db.api.query.resolve_block_range(inst_61563,query_map);
var state_61667__$1 = state_61667;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61667__$1,(10),inst_61565);
} else {
if((state_val_61668 === (20))){
var inst_61592 = (state_61667[(2)]);
var inst_61593 = fluree.db.util.async.throw_err(inst_61592);
var inst_61594 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_61593);
var inst_61595 = (inst_61594 - (1));
var state_61667__$1 = state_61667;
var statearr_61669_61732 = state_61667__$1;
(statearr_61669_61732[(2)] = inst_61595);

(statearr_61669_61732[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (27))){
var state_61667__$1 = state_61667;
var statearr_61670_61733 = state_61667__$1;
(statearr_61670_61733[(2)] = null);

(statearr_61670_61733[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (1))){
var state_61667__$1 = state_61667;
var statearr_61671_61734 = state_61667__$1;
(statearr_61671_61734[(2)] = null);

(statearr_61671_61734[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (24))){
var inst_61602 = (state_61667[(2)]);
var inst_61603 = fluree.db.util.async.throw_err(inst_61602);
var inst_61604 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_61603);
var state_61667__$1 = state_61667;
var statearr_61672_61735 = state_61667__$1;
(statearr_61672_61735[(2)] = inst_61604);

(statearr_61672_61735[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (39))){
var inst_61639 = (state_61667[(2)]);
var inst_61640 = fluree.db.util.async.throw_err(inst_61639);
var state_61667__$1 = state_61667;
var statearr_61673_61736 = state_61667__$1;
(statearr_61673_61736[(2)] = inst_61640);

(statearr_61673_61736[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (4))){
var inst_61541 = (state_61667[(2)]);
var state_61667__$1 = state_61667;
var statearr_61674_61737 = state_61667__$1;
(statearr_61674_61737[(2)] = inst_61541);

(statearr_61674_61737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (15))){
var inst_61572 = (state_61667[(8)]);
var state_61667__$1 = state_61667;
var statearr_61675_61738 = state_61667__$1;
(statearr_61675_61738[(2)] = inst_61572);

(statearr_61675_61738[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (21))){
var inst_61573 = (state_61667[(9)]);
var inst_61563 = (state_61667[(7)]);
var inst_61600 = fluree.db.time_travel.as_of_block(inst_61563,inst_61573);
var state_61667__$1 = state_61667;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61667__$1,(24),inst_61600);
} else {
if((state_val_61668 === (31))){
var inst_61557 = (state_61667[(10)]);
var state_61667__$1 = state_61667;
var statearr_61676_61739 = state_61667__$1;
(statearr_61676_61739[(2)] = inst_61557);

(statearr_61676_61739[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (32))){
var inst_61618 = (state_61667[(11)]);
var inst_61563 = (state_61667[(7)]);
var inst_61623 = (state_61667[(12)]);
var inst_61627 = (state_61667[(2)]);
var inst_61628 = fluree.db.api.query.format_history_resp(inst_61563,inst_61618,inst_61623,inst_61627);
var state_61667__$1 = state_61667;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61667__$1,(29),inst_61628);
} else {
if((state_val_61668 === (40))){
var inst_61618 = (state_61667[(11)]);
var inst_61644 = (state_61667[(13)]);
var inst_61646 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_61647 = cljs.core.count(inst_61618);
var inst_61648 = [inst_61644,inst_61647,(200)];
var inst_61649 = cljs.core.PersistentHashMap.fromArrays(inst_61646,inst_61648);
var state_61667__$1 = state_61667;
var statearr_61677_61740 = state_61667__$1;
(statearr_61677_61740[(2)] = inst_61649);

(statearr_61677_61740[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (33))){
var inst_61556 = (state_61667[(14)]);
var state_61667__$1 = state_61667;
var statearr_61678_61741 = state_61667__$1;
(statearr_61678_61741[(2)] = inst_61556);

(statearr_61678_61741[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (13))){
var inst_61662 = (state_61667[(2)]);
var _ = (function (){var statearr_61679 = state_61667;
(statearr_61679[(4)] = cljs.core.rest((state_61667[(4)])));

return statearr_61679;
})();
var state_61667__$1 = state_61667;
var statearr_61680_61742 = state_61667__$1;
(statearr_61680_61742[(2)] = inst_61662);

(statearr_61680_61742[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (22))){
var inst_61563 = (state_61667[(7)]);
var inst_61606 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_61563);
var state_61667__$1 = state_61667;
var statearr_61681_61743 = state_61667__$1;
(statearr_61681_61743[(2)] = inst_61606);

(statearr_61681_61743[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (36))){
var inst_61563 = (state_61667[(7)]);
var inst_61631 = (state_61667[(15)]);
var inst_61637 = fluree.db.api.query.format_blocks_resp_pretty(inst_61563,inst_61631);
var state_61667__$1 = state_61667;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61667__$1,(39),inst_61637);
} else {
if((state_val_61668 === (41))){
var inst_61644 = (state_61667[(13)]);
var state_61667__$1 = state_61667;
var statearr_61682_61744 = state_61667__$1;
(statearr_61682_61744[(2)] = inst_61644);

(statearr_61682_61744[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (29))){
var inst_61556 = (state_61667[(14)]);
var inst_61630 = (state_61667[(2)]);
var inst_61631 = fluree.db.util.async.throw_err(inst_61630);
var state_61667__$1 = (function (){var statearr_61683 = state_61667;
(statearr_61683[(15)] = inst_61631);

return statearr_61683;
})();
if(cljs.core.truth_(inst_61556)){
var statearr_61684_61745 = state_61667__$1;
(statearr_61684_61745[(1)] = (33));

} else {
var statearr_61685_61746 = state_61667__$1;
(statearr_61685_61746[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (6))){
var inst_61553 = (state_61667[(16)]);
var inst_61562 = (state_61667[(2)]);
var inst_61563 = fluree.db.util.async.throw_err(inst_61562);
var state_61667__$1 = (function (){var statearr_61686 = state_61667;
(statearr_61686[(7)] = inst_61563);

return statearr_61686;
})();
if(cljs.core.truth_(inst_61553)){
var statearr_61687_61747 = state_61667__$1;
(statearr_61687_61747[(1)] = (7));

} else {
var statearr_61688_61748 = state_61667__$1;
(statearr_61688_61748[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (28))){
var inst_61558 = (state_61667[(17)]);
var inst_61623 = (state_61667[(2)]);
var state_61667__$1 = (function (){var statearr_61689 = state_61667;
(statearr_61689[(12)] = inst_61623);

return statearr_61689;
})();
if(cljs.core.truth_(inst_61558)){
var statearr_61690_61749 = state_61667__$1;
(statearr_61690_61749[(1)] = (30));

} else {
var statearr_61691_61750 = state_61667__$1;
(statearr_61691_61750[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (25))){
var inst_61559 = (state_61667[(18)]);
var inst_61617 = (state_61667[(2)]);
var inst_61618 = fluree.db.util.async.throw_err(inst_61617);
var state_61667__$1 = (function (){var statearr_61692 = state_61667;
(statearr_61692[(11)] = inst_61618);

return statearr_61692;
})();
if(cljs.core.truth_(inst_61559)){
var statearr_61693_61751 = state_61667__$1;
(statearr_61693_61751[(1)] = (26));

} else {
var statearr_61694_61752 = state_61667__$1;
(statearr_61694_61752[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (34))){
var inst_61555 = (state_61667[(19)]);
var state_61667__$1 = state_61667;
var statearr_61695_61753 = state_61667__$1;
(statearr_61695_61753[(2)] = inst_61555);

(statearr_61695_61753[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (17))){
var inst_61572 = (state_61667[(8)]);
var inst_61563 = (state_61667[(7)]);
var inst_61589 = (inst_61572 - (1));
var inst_61590 = fluree.db.time_travel.as_of_block(inst_61563,inst_61589);
var state_61667__$1 = state_61667;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61667__$1,(20),inst_61590);
} else {
if((state_val_61668 === (3))){
var inst_61665 = (state_61667[(2)]);
var state_61667__$1 = state_61667;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61667__$1,inst_61665);
} else {
if((state_val_61668 === (12))){
var inst_61654 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_61655 = ["History query not properly formatted. Provided ",inst_61654].join('');
var inst_61656 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61657 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61658 = cljs.core.PersistentHashMap.fromArrays(inst_61656,inst_61657);
var inst_61659 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_61655,inst_61658);
var inst_61660 = (function(){throw inst_61659})();
var state_61667__$1 = state_61667;
var statearr_61696_61754 = state_61667__$1;
(statearr_61696_61754[(2)] = inst_61660);

(statearr_61696_61754[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (2))){
var _ = (function (){var statearr_61697 = state_61667;
(statearr_61697[(4)] = cljs.core.cons((5),(state_61667[(4)])));

return statearr_61697;
})();
var inst_61551 = query_map;
var inst_61552 = cljs.core.__destructure_map(inst_61551);
var inst_61553 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61552,new cljs.core.Keyword(null,"block","block",664686210));
var inst_61554 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61552,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_61555 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61552,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_61556 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61552,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_61557 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61552,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_61558 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61552,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_61559 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61552,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_61560 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61552,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_61667__$1 = (function (){var statearr_61698 = state_61667;
(statearr_61698[(17)] = inst_61558);

(statearr_61698[(19)] = inst_61555);

(statearr_61698[(20)] = inst_61560);

(statearr_61698[(14)] = inst_61556);

(statearr_61698[(10)] = inst_61557);

(statearr_61698[(18)] = inst_61559);

(statearr_61698[(21)] = inst_61554);

(statearr_61698[(16)] = inst_61553);

return statearr_61698;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61667__$1,(6),sources);
} else {
if((state_val_61668 === (23))){
var inst_61598 = (state_61667[(22)]);
var inst_61563 = (state_61667[(7)]);
var inst_61554 = (state_61667[(21)]);
var inst_61608 = (state_61667[(2)]);
var inst_61609 = fluree.db.api.query.get_history_pattern(inst_61554);
var inst_61610 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61609,(0),null);
var inst_61611 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61609,(1),null);
var inst_61612 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_61613 = [inst_61598,inst_61608];
var inst_61614 = cljs.core.PersistentHashMap.fromArrays(inst_61612,inst_61613);
var inst_61615 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_61563,inst_61611,cljs.core._EQ_,inst_61610,inst_61614);
var state_61667__$1 = state_61667;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61667__$1,(25),inst_61615);
} else {
if((state_val_61668 === (35))){
var inst_61635 = (state_61667[(2)]);
var state_61667__$1 = state_61667;
if(cljs.core.truth_(inst_61635)){
var statearr_61699_61755 = state_61667__$1;
(statearr_61699_61755[(1)] = (36));

} else {
var statearr_61700_61756 = state_61667__$1;
(statearr_61700_61756[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (19))){
var inst_61573 = (state_61667[(9)]);
var inst_61598 = (state_61667[(2)]);
var state_61667__$1 = (function (){var statearr_61701 = state_61667;
(statearr_61701[(22)] = inst_61598);

return statearr_61701;
})();
if(cljs.core.truth_(inst_61573)){
var statearr_61702_61757 = state_61667__$1;
(statearr_61702_61757[(1)] = (21));

} else {
var statearr_61703_61758 = state_61667__$1;
(statearr_61703_61758[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (11))){
var inst_61560 = (state_61667[(20)]);
var inst_61572 = (state_61667[(8)]);
var inst_61582 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_61560);
var state_61667__$1 = (function (){var statearr_61705 = state_61667;
(statearr_61705[(23)] = inst_61582);

return statearr_61705;
})();
if(cljs.core.truth_(inst_61572)){
var statearr_61706_61759 = state_61667__$1;
(statearr_61706_61759[(1)] = (14));

} else {
var statearr_61707_61760 = state_61667__$1;
(statearr_61707_61760[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (9))){
var inst_61571 = (state_61667[(2)]);
var inst_61572 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61571,(0),null);
var inst_61573 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61571,(1),null);
var inst_61574 = cljs.core.list(new cljs.core.Keyword(null,"history","history",-247395220));
var inst_61575 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(query_map,new cljs.core.Keyword(null,"block","block",664686210),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"show-auth","show-auth",686103141),new cljs.core.Keyword(null,"showAuth","showAuth",-347871529),new cljs.core.Keyword(null,"opts","opts",155075701)], 0));
var inst_61576 = cljs.core.keys(inst_61575);
var inst_61577 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61574,inst_61576);
var state_61667__$1 = (function (){var statearr_61708 = state_61667;
(statearr_61708[(9)] = inst_61573);

(statearr_61708[(8)] = inst_61572);

return statearr_61708;
})();
if(inst_61577){
var statearr_61709_61761 = state_61667__$1;
(statearr_61709_61761[(1)] = (11));

} else {
var statearr_61710_61762 = state_61667__$1;
(statearr_61710_61762[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (5))){
var _ = (function (){var statearr_61711 = state_61667;
(statearr_61711[(4)] = cljs.core.rest((state_61667[(4)])));

return statearr_61711;
})();
var state_61667__$1 = state_61667;
var ex61704 = (state_61667__$1[(2)]);
var statearr_61712_61763 = state_61667__$1;
(statearr_61712_61763[(5)] = ex61704);


if((ex61704 instanceof Error)){
var statearr_61713_61764 = state_61667__$1;
(statearr_61713_61764[(1)] = (4));

(statearr_61713_61764[(5)] = null);

} else {
throw ex61704;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (14))){
var inst_61572 = (state_61667[(8)]);
var inst_61584 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_61572);
var state_61667__$1 = state_61667;
var statearr_61714_61765 = state_61667__$1;
(statearr_61714_61765[(2)] = inst_61584);

(statearr_61714_61765[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (26))){
var inst_61559 = (state_61667[(18)]);
var inst_61620 = cljs.core.set(inst_61559);
var state_61667__$1 = state_61667;
var statearr_61715_61766 = state_61667__$1;
(statearr_61715_61766[(2)] = inst_61620);

(statearr_61715_61766[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (16))){
var inst_61587 = (state_61667[(2)]);
var state_61667__$1 = state_61667;
if(cljs.core.truth_(inst_61587)){
var statearr_61716_61767 = state_61667__$1;
(statearr_61716_61767[(1)] = (17));

} else {
var statearr_61717_61768 = state_61667__$1;
(statearr_61717_61768[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (38))){
var inst_61582 = (state_61667[(23)]);
var inst_61644 = (state_61667[(2)]);
var state_61667__$1 = (function (){var statearr_61718 = state_61667;
(statearr_61718[(13)] = inst_61644);

return statearr_61718;
})();
if(cljs.core.truth_(inst_61582)){
var statearr_61719_61769 = state_61667__$1;
(statearr_61719_61769[(1)] = (40));

} else {
var statearr_61720_61770 = state_61667__$1;
(statearr_61720_61770[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (30))){
var inst_61558 = (state_61667[(17)]);
var state_61667__$1 = state_61667;
var statearr_61721_61771 = state_61667__$1;
(statearr_61721_61771[(2)] = inst_61558);

(statearr_61721_61771[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (10))){
var inst_61567 = (state_61667[(2)]);
var inst_61568 = fluree.db.util.async.throw_err(inst_61567);
var state_61667__$1 = state_61667;
var statearr_61722_61772 = state_61667__$1;
(statearr_61722_61772[(2)] = inst_61568);

(statearr_61722_61772[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (18))){
var state_61667__$1 = state_61667;
var statearr_61723_61773 = state_61667__$1;
(statearr_61723_61773[(2)] = (-1));

(statearr_61723_61773[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (42))){
var inst_61652 = (state_61667[(2)]);
var state_61667__$1 = state_61667;
var statearr_61724_61774 = state_61667__$1;
(statearr_61724_61774[(2)] = inst_61652);

(statearr_61724_61774[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (37))){
var inst_61631 = (state_61667[(15)]);
var inst_61642 = fluree.db.api.query.block_Flakes__GT_vector(inst_61631);
var state_61667__$1 = state_61667;
var statearr_61725_61775 = state_61667__$1;
(statearr_61725_61775[(2)] = inst_61642);

(statearr_61725_61775[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61668 === (8))){
var state_61667__$1 = state_61667;
var statearr_61726_61776 = state_61667__$1;
(statearr_61726_61776[(2)] = null);

(statearr_61726_61776[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2749__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2749__auto____0 = (function (){
var statearr_61727 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61727[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2749__auto__);

(statearr_61727[(1)] = (1));

return statearr_61727;
});
var fluree$db$api$query$history_query_async_$_state_machine__2749__auto____1 = (function (state_61667){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_61667);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e61728){var ex__2752__auto__ = e61728;
var statearr_61729_61777 = state_61667;
(statearr_61729_61777[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_61667[(4)]))){
var statearr_61730_61778 = state_61667;
(statearr_61730_61778[(1)] = cljs.core.first((state_61667[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61779 = state_61667;
state_61667 = G__61779;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2749__auto__ = function(state_61667){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2749__auto____1.call(this,state_61667);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2749__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2749__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_61731 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_61731[(6)] = c__2771__auto__);

return statearr_61731;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_61912){
var state_val_61913 = (state_61912[(1)]);
if((state_val_61913 === (7))){
var inst_61809 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flureeQL], 0));
var inst_61810 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_61809].join('');
var inst_61811 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61812 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61813 = cljs.core.PersistentHashMap.fromArrays(inst_61811,inst_61812);
var inst_61814 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_61810,inst_61813);
var inst_61815 = (function(){throw inst_61814})();
var state_61912__$1 = state_61912;
var statearr_61914_61993 = state_61912__$1;
(statearr_61914_61993[(2)] = inst_61815);

(statearr_61914_61993[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (20))){
var inst_61847 = (state_61912[(2)]);
var state_61912__$1 = state_61912;
if(cljs.core.truth_(inst_61847)){
var statearr_61915_61994 = state_61912__$1;
(statearr_61915_61994[(1)] = (21));

} else {
var statearr_61916_61995 = state_61912__$1;
(statearr_61916_61995[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (27))){
var inst_61791 = (state_61912[(7)]);
var state_61912__$1 = state_61912;
var statearr_61917_61996 = state_61912__$1;
(statearr_61917_61996[(2)] = inst_61791);

(statearr_61917_61996[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (1))){
var state_61912__$1 = state_61912;
var statearr_61918_61997 = state_61912__$1;
(statearr_61918_61997[(2)] = null);

(statearr_61918_61997[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (24))){
var inst_61853 = (state_61912[(8)]);
var state_61912__$1 = state_61912;
var statearr_61919_61998 = state_61912__$1;
(statearr_61919_61998[(2)] = inst_61853);

(statearr_61919_61998[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (39))){
var inst_61797 = (state_61912[(9)]);
var state_61912__$1 = state_61912;
if(cljs.core.truth_(inst_61797)){
var statearr_61920_61999 = state_61912__$1;
(statearr_61920_61999[(1)] = (42));

} else {
var statearr_61921_62000 = state_61912__$1;
(statearr_61921_62000[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (46))){
var inst_61885 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61886 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61887 = cljs.core.PersistentHashMap.fromArrays(inst_61885,inst_61886);
var inst_61888 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid query.",inst_61887);
var inst_61889 = (function(){throw inst_61888})();
var state_61912__$1 = state_61912;
var statearr_61922_62001 = state_61912__$1;
(statearr_61922_62001[(2)] = inst_61889);

(statearr_61922_62001[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (4))){
var inst_61781 = (state_61912[(2)]);
var state_61912__$1 = state_61912;
var statearr_61923_62002 = state_61912__$1;
(statearr_61923_62002[(2)] = inst_61781);

(statearr_61923_62002[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (15))){
var inst_61794 = (state_61912[(10)]);
var inst_61832 = (state_61912[(11)]);
var inst_61834 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_61832);
var inst_61835 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_61832);
var inst_61836 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_61832);
var inst_61837 = fluree.db.api.query.get_sources(inst_61834,inst_61835,inst_61836,inst_61794);
var state_61912__$1 = state_61912;
var statearr_61924_62003 = state_61912__$1;
(statearr_61924_62003[(2)] = inst_61837);

(statearr_61924_62003[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (48))){
var inst_61842 = (state_61912[(12)]);
var inst_61896 = (state_61912[(2)]);
var inst_61897 = fluree.db.util.async.throw_err(inst_61896);
var state_61912__$1 = (function (){var statearr_61925 = state_61912;
(statearr_61925[(13)] = inst_61897);

return statearr_61925;
})();
if(cljs.core.truth_(inst_61842)){
var statearr_61926_62004 = state_61912__$1;
(statearr_61926_62004[(1)] = (49));

} else {
var statearr_61927_62005 = state_61912__$1;
(statearr_61927_62005[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (50))){
var inst_61897 = (state_61912[(13)]);
var state_61912__$1 = state_61912;
var statearr_61928_62006 = state_61912__$1;
(statearr_61928_62006[(2)] = inst_61897);

(statearr_61928_62006[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (21))){
var inst_61849 = cljs.core.volatile_BANG_((0));
var state_61912__$1 = state_61912;
var statearr_61929_62007 = state_61912__$1;
(statearr_61929_62007[(2)] = inst_61849);

(statearr_61929_62007[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (31))){
var inst_61795 = (state_61912[(14)]);
var state_61912__$1 = state_61912;
if(cljs.core.truth_(inst_61795)){
var statearr_61930_62008 = state_61912__$1;
(statearr_61930_62008[(1)] = (33));

} else {
var statearr_61931_62009 = state_61912__$1;
(statearr_61931_62009[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (32))){
var inst_61872 = (state_61912[(2)]);
var state_61912__$1 = state_61912;
var statearr_61932_62010 = state_61912__$1;
(statearr_61932_62010[(2)] = inst_61872);

(statearr_61932_62010[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (40))){
var inst_61874 = (state_61912[(15)]);
var state_61912__$1 = state_61912;
var statearr_61933_62011 = state_61912__$1;
(statearr_61933_62011[(2)] = inst_61874);

(statearr_61933_62011[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (33))){
var inst_61795 = (state_61912[(14)]);
var state_61912__$1 = state_61912;
var statearr_61934_62012 = state_61912__$1;
(statearr_61934_62012[(2)] = inst_61795);

(statearr_61934_62012[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (13))){
var inst_61792 = (state_61912[(16)]);
var inst_61821 = (state_61912[(2)]);
var inst_61822 = fluree.db.util.async.throw_err(inst_61821);
var inst_61823 = fluree.db.time_travel.as_of_block(inst_61822,inst_61792);
var state_61912__$1 = state_61912;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61912__$1,(12),inst_61823);
} else {
if((state_val_61913 === (22))){
var state_61912__$1 = state_61912;
var statearr_61935_62013 = state_61912__$1;
(statearr_61935_62013[(2)] = null);

(statearr_61935_62013[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (36))){
var inst_61799 = (state_61912[(17)]);
var state_61912__$1 = state_61912;
var statearr_61936_62014 = state_61912__$1;
(statearr_61936_62014[(2)] = inst_61799);

(statearr_61936_62014[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (41))){
var inst_61882 = (state_61912[(2)]);
var state_61912__$1 = state_61912;
if(cljs.core.truth_(inst_61882)){
var statearr_61937_62015 = state_61912__$1;
(statearr_61937_62015[(1)] = (45));

} else {
var statearr_61938_62016 = state_61912__$1;
(statearr_61938_62016[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (43))){
var inst_61793 = (state_61912[(18)]);
var state_61912__$1 = state_61912;
var statearr_61939_62017 = state_61912__$1;
(statearr_61939_62017[(2)] = inst_61793);

(statearr_61939_62017[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (29))){
var inst_61874 = (state_61912[(15)]);
var inst_61874__$1 = (state_61912[(2)]);
var state_61912__$1 = (function (){var statearr_61940 = state_61912;
(statearr_61940[(15)] = inst_61874__$1);

return statearr_61940;
})();
if(cljs.core.truth_(inst_61874__$1)){
var statearr_61941_62018 = state_61912__$1;
(statearr_61941_62018[(1)] = (39));

} else {
var statearr_61942_62019 = state_61912__$1;
(statearr_61942_62019[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (44))){
var inst_61879 = (state_61912[(2)]);
var state_61912__$1 = state_61912;
var statearr_61943_62020 = state_61912__$1;
(statearr_61943_62020[(2)] = inst_61879);

(statearr_61943_62020[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (6))){
var state_61912__$1 = state_61912;
var statearr_61944_62021 = state_61912__$1;
(statearr_61944_62021[(2)] = null);

(statearr_61944_62021[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (28))){
var inst_61796 = (state_61912[(19)]);
var state_61912__$1 = state_61912;
if(cljs.core.truth_(inst_61796)){
var statearr_61945_62022 = state_61912__$1;
(statearr_61945_62022[(1)] = (30));

} else {
var statearr_61946_62023 = state_61912__$1;
(statearr_61946_62023[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (51))){
var inst_61907 = (state_61912[(2)]);
var _ = (function (){var statearr_61947 = state_61912;
(statearr_61947[(4)] = cljs.core.rest((state_61912[(4)])));

return statearr_61947;
})();
var state_61912__$1 = state_61912;
var statearr_61948_62024 = state_61912__$1;
(statearr_61948_62024[(2)] = inst_61907);

(statearr_61948_62024[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (25))){
var state_61912__$1 = state_61912;
var statearr_61949_62025 = state_61912__$1;
(statearr_61949_62025[(2)] = (1000000));

(statearr_61949_62025[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (34))){
var inst_61799 = (state_61912[(17)]);
var state_61912__$1 = state_61912;
if(cljs.core.truth_(inst_61799)){
var statearr_61950_62026 = state_61912__$1;
(statearr_61950_62026[(1)] = (36));

} else {
var statearr_61951_62027 = state_61912__$1;
(statearr_61951_62027[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (17))){
var inst_61843 = (state_61912[(20)]);
var inst_61798 = (state_61912[(21)]);
var inst_61841 = (state_61912[(2)]);
var inst_61842 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_61798);
var inst_61843__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_61798);
var state_61912__$1 = (function (){var statearr_61952 = state_61912;
(statearr_61952[(22)] = inst_61841);

(statearr_61952[(20)] = inst_61843__$1);

(statearr_61952[(12)] = inst_61842);

return statearr_61952;
})();
if(cljs.core.truth_(inst_61843__$1)){
var statearr_61953_62028 = state_61912__$1;
(statearr_61953_62028[(1)] = (18));

} else {
var statearr_61954_62029 = state_61912__$1;
(statearr_61954_62029[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (3))){
var inst_61910 = (state_61912[(2)]);
var state_61912__$1 = state_61912;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61912__$1,inst_61910);
} else {
if((state_val_61913 === (12))){
var inst_61825 = (state_61912[(2)]);
var inst_61826 = fluree.db.util.async.throw_err(inst_61825);
var state_61912__$1 = state_61912;
var statearr_61955_62030 = state_61912__$1;
(statearr_61955_62030[(2)] = inst_61826);

(statearr_61955_62030[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (2))){
var inst_61795 = (state_61912[(14)]);
var inst_61792 = (state_61912[(16)]);
var inst_61799 = (state_61912[(17)]);
var inst_61790 = (state_61912[(23)]);
var inst_61791 = (state_61912[(7)]);
var inst_61798 = (state_61912[(21)]);
var inst_61797 = (state_61912[(9)]);
var inst_61793 = (state_61912[(18)]);
var inst_61794 = (state_61912[(10)]);
var inst_61796 = (state_61912[(19)]);
var _ = (function (){var statearr_61956 = state_61912;
(statearr_61956[(4)] = cljs.core.cons((5),(state_61912[(4)])));

return statearr_61956;
})();
var inst_61788 = flureeQL;
var inst_61789 = cljs.core.__destructure_map(inst_61788);
var inst_61790__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61789,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_61791__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61789,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_61792__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61789,new cljs.core.Keyword(null,"block","block",664686210));
var inst_61793__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61789,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_61794__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61789,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_61795__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61789,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_61796__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61789,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_61797__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61789,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_61798__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61789,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_61799__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61789,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_61800 = (function (){var construct = inst_61790__$1;
var select = inst_61791__$1;
var map__61787 = inst_61789;
var block = inst_61792__$1;
var where = inst_61793__$1;
var prefixes = inst_61794__$1;
var selectDistinct = inst_61795__$1;
var selectOne = inst_61796__$1;
var from = inst_61797__$1;
var opts = inst_61798__$1;
var selectReduced = inst_61799__$1;
return (function (p1__61780_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__61780_SHARP_);
});
})();
var inst_61801 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61802 = [inst_61791__$1,inst_61796__$1,inst_61795__$1,inst_61799__$1];
var inst_61803 = (new cljs.core.PersistentVector(null,4,(5),inst_61801,inst_61802,null));
var inst_61804 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_61803);
var inst_61805 = cljs.core.count(inst_61804);
var inst_61806 = (inst_61800.cljs$core$IFn$_invoke$arity$1 ? inst_61800.cljs$core$IFn$_invoke$arity$1(inst_61805) : inst_61800.call(null,inst_61805));
var state_61912__$1 = (function (){var statearr_61957 = state_61912;
(statearr_61957[(14)] = inst_61795__$1);

(statearr_61957[(16)] = inst_61792__$1);

(statearr_61957[(17)] = inst_61799__$1);

(statearr_61957[(23)] = inst_61790__$1);

(statearr_61957[(7)] = inst_61791__$1);

(statearr_61957[(21)] = inst_61798__$1);

(statearr_61957[(9)] = inst_61797__$1);

(statearr_61957[(18)] = inst_61793__$1);

(statearr_61957[(10)] = inst_61794__$1);

(statearr_61957[(19)] = inst_61796__$1);

return statearr_61957;
})();
if(cljs.core.truth_(inst_61806)){
var statearr_61958_62031 = state_61912__$1;
(statearr_61958_62031[(1)] = (6));

} else {
var statearr_61959_62032 = state_61912__$1;
(statearr_61959_62032[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (23))){
var inst_61853 = (state_61912[(8)]);
var inst_61798 = (state_61912[(21)]);
var inst_61852 = (state_61912[(2)]);
var inst_61853__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_61798);
var state_61912__$1 = (function (){var statearr_61960 = state_61912;
(statearr_61960[(24)] = inst_61852);

(statearr_61960[(8)] = inst_61853__$1);

return statearr_61960;
})();
if(cljs.core.truth_(inst_61853__$1)){
var statearr_61961_62033 = state_61912__$1;
(statearr_61961_62033[(1)] = (24));

} else {
var statearr_61962_62034 = state_61912__$1;
(statearr_61962_62034[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (47))){
var inst_61858 = (state_61912[(25)]);
var inst_61832 = (state_61912[(11)]);
var inst_61891 = (state_61912[(2)]);
var inst_61892 = fluree.db.util.core.current_time_millis();
var inst_61893 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_61858);
var inst_61894 = fluree.db.query.fql.query(inst_61832,inst_61893);
var state_61912__$1 = (function (){var statearr_61963 = state_61912;
(statearr_61963[(26)] = inst_61891);

(statearr_61963[(27)] = inst_61892);

return statearr_61963;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61912__$1,(48),inst_61894);
} else {
if((state_val_61913 === (35))){
var inst_61870 = (state_61912[(2)]);
var state_61912__$1 = state_61912;
var statearr_61964_62035 = state_61912__$1;
(statearr_61964_62035[(2)] = inst_61870);

(statearr_61964_62035[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (19))){
var inst_61842 = (state_61912[(12)]);
var state_61912__$1 = state_61912;
var statearr_61965_62036 = state_61912__$1;
(statearr_61965_62036[(2)] = inst_61842);

(statearr_61965_62036[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (11))){
var inst_61794 = (state_61912[(10)]);
var inst_61832 = (state_61912[(2)]);
var state_61912__$1 = (function (){var statearr_61967 = state_61912;
(statearr_61967[(11)] = inst_61832);

return statearr_61967;
})();
if(cljs.core.truth_(inst_61794)){
var statearr_61968_62037 = state_61912__$1;
(statearr_61968_62037[(1)] = (15));

} else {
var statearr_61969_62038 = state_61912__$1;
(statearr_61969_62038[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (9))){
var inst_61818 = (state_61912[(28)]);
var state_61912__$1 = state_61912;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61912__$1,(13),inst_61818);
} else {
if((state_val_61913 === (5))){
var _ = (function (){var statearr_61970 = state_61912;
(statearr_61970[(4)] = cljs.core.rest((state_61912[(4)])));

return statearr_61970;
})();
var state_61912__$1 = state_61912;
var ex61966 = (state_61912__$1[(2)]);
var statearr_61971_62039 = state_61912__$1;
(statearr_61971_62039[(5)] = ex61966);


if((ex61966 instanceof Error)){
var statearr_61972_62040 = state_61912__$1;
(statearr_61972_62040[(1)] = (4));

(statearr_61972_62040[(5)] = null);

} else {
throw ex61966;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (14))){
var inst_61829 = (state_61912[(2)]);
var inst_61830 = fluree.db.util.async.throw_err(inst_61829);
var state_61912__$1 = state_61912;
var statearr_61973_62041 = state_61912__$1;
(statearr_61973_62041[(2)] = inst_61830);

(statearr_61973_62041[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (45))){
var state_61912__$1 = state_61912;
var statearr_61974_62042 = state_61912__$1;
(statearr_61974_62042[(2)] = null);

(statearr_61974_62042[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (26))){
var inst_61852 = (state_61912[(24)]);
var inst_61841 = (state_61912[(22)]);
var inst_61791 = (state_61912[(7)]);
var inst_61798 = (state_61912[(21)]);
var inst_61857 = (state_61912[(2)]);
var inst_61858 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_61798,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_61841,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_61857,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_61852], 0));
var state_61912__$1 = (function (){var statearr_61975 = state_61912;
(statearr_61975[(25)] = inst_61858);

return statearr_61975;
})();
if(cljs.core.truth_(inst_61791)){
var statearr_61976_62043 = state_61912__$1;
(statearr_61976_62043[(1)] = (27));

} else {
var statearr_61977_62044 = state_61912__$1;
(statearr_61977_62044[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (16))){
var inst_61839 = cljs.core.PersistentHashMap.EMPTY;
var state_61912__$1 = state_61912;
var statearr_61978_62045 = state_61912__$1;
(statearr_61978_62045[(2)] = inst_61839);

(statearr_61978_62045[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (38))){
var inst_61868 = (state_61912[(2)]);
var state_61912__$1 = state_61912;
var statearr_61979_62046 = state_61912__$1;
(statearr_61979_62046[(2)] = inst_61868);

(statearr_61979_62046[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (30))){
var inst_61796 = (state_61912[(19)]);
var state_61912__$1 = state_61912;
var statearr_61980_62047 = state_61912__$1;
(statearr_61980_62047[(2)] = inst_61796);

(statearr_61980_62047[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (10))){
var inst_61818 = (state_61912[(28)]);
var state_61912__$1 = state_61912;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61912__$1,(14),inst_61818);
} else {
if((state_val_61913 === (18))){
var inst_61843 = (state_61912[(20)]);
var state_61912__$1 = state_61912;
var statearr_61981_62048 = state_61912__$1;
(statearr_61981_62048[(2)] = inst_61843);

(statearr_61981_62048[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (42))){
var inst_61797 = (state_61912[(9)]);
var state_61912__$1 = state_61912;
var statearr_61982_62049 = state_61912__$1;
(statearr_61982_62049[(2)] = inst_61797);

(statearr_61982_62049[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (37))){
var inst_61790 = (state_61912[(23)]);
var state_61912__$1 = state_61912;
var statearr_61983_62050 = state_61912__$1;
(statearr_61983_62050[(2)] = inst_61790);

(statearr_61983_62050[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (8))){
var inst_61792 = (state_61912[(16)]);
var inst_61817 = (state_61912[(2)]);
var inst_61818 = sources;
var state_61912__$1 = (function (){var statearr_61984 = state_61912;
(statearr_61984[(29)] = inst_61817);

(statearr_61984[(28)] = inst_61818);

return statearr_61984;
})();
if(cljs.core.truth_(inst_61792)){
var statearr_61985_62051 = state_61912__$1;
(statearr_61985_62051[(1)] = (9));

} else {
var statearr_61986_62052 = state_61912__$1;
(statearr_61986_62052[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61913 === (49))){
var inst_61852 = (state_61912[(24)]);
var inst_61897 = (state_61912[(13)]);
var inst_61892 = (state_61912[(27)]);
var inst_61832 = (state_61912[(11)]);
var inst_61899 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_61900 = cljs.core.deref(inst_61852);
var inst_61901 = fluree.db.util.core.response_time_formatted(inst_61892);
var inst_61902 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_61832);
var inst_61903 = [(200),inst_61897,inst_61900,inst_61901,inst_61902];
var inst_61904 = cljs.core.PersistentHashMap.fromArrays(inst_61899,inst_61903);
var state_61912__$1 = state_61912;
var statearr_61987_62053 = state_61912__$1;
(statearr_61987_62053[(2)] = inst_61904);

(statearr_61987_62053[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2749__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2749__auto____0 = (function (){
var statearr_61988 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61988[(0)] = fluree$db$api$query$query_async_$_state_machine__2749__auto__);

(statearr_61988[(1)] = (1));

return statearr_61988;
});
var fluree$db$api$query$query_async_$_state_machine__2749__auto____1 = (function (state_61912){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_61912);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e61989){var ex__2752__auto__ = e61989;
var statearr_61990_62054 = state_61912;
(statearr_61990_62054[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_61912[(4)]))){
var statearr_61991_62055 = state_61912;
(statearr_61991_62055[(1)] = cljs.core.first((state_61912[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62056 = state_61912;
state_61912 = G__62056;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2749__auto__ = function(state_61912){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2749__auto____1.call(this,state_61912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2749__auto____0;
fluree$db$api$query$query_async_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2749__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_61992 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_61992[(6)] = c__2771__auto__);

return statearr_61992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_62197){
var state_val_62198 = (state_62197[(1)]);
if((state_val_62198 === (7))){
var inst_62192 = (state_62197[(2)]);
var _ = (function (){var statearr_62199 = state_62197;
(statearr_62199[(4)] = cljs.core.rest((state_62197[(4)])));

return statearr_62199;
})();
var state_62197__$1 = state_62197;
var statearr_62200_62276 = state_62197__$1;
(statearr_62200_62276[(2)] = inst_62192);

(statearr_62200_62276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (20))){
var inst_62164 = (state_62197[(2)]);
var state_62197__$1 = state_62197;
var statearr_62201_62277 = state_62197__$1;
(statearr_62201_62277[(2)] = inst_62164);

(statearr_62201_62277[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (27))){
var inst_62144 = (state_62197[(7)]);
var state_62197__$1 = state_62197;
var statearr_62202_62278 = state_62197__$1;
(statearr_62202_62278[(2)] = inst_62144);

(statearr_62202_62278[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (1))){
var state_62197__$1 = state_62197;
var statearr_62203_62279 = state_62197__$1;
(statearr_62203_62279[(2)] = null);

(statearr_62203_62279[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (24))){
var inst_62141 = (state_62197[(8)]);
var state_62197__$1 = state_62197;
var statearr_62204_62280 = state_62197__$1;
(statearr_62204_62280[(2)] = inst_62141);

(statearr_62204_62280[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (39))){
var inst_62131 = (state_62197[(9)]);
var inst_62098 = (state_62197[(10)]);
var inst_62109 = (state_62197[(11)]);
var inst_62175 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62176 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_62109];
var inst_62177 = (new cljs.core.PersistentVector(null,2,(5),inst_62175,inst_62176,null));
var inst_62178 = cljs.core.assoc_in(inst_62098,inst_62177,inst_62131);
var state_62197__$1 = state_62197;
var statearr_62205_62281 = state_62197__$1;
(statearr_62205_62281[(2)] = inst_62178);

(statearr_62205_62281[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (4))){
var inst_62057 = (state_62197[(2)]);
var state_62197__$1 = state_62197;
var statearr_62206_62282 = state_62197__$1;
(statearr_62206_62282[(2)] = inst_62057);

(statearr_62206_62282[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (15))){
var inst_62131 = (state_62197[(9)]);
var inst_62096 = (state_62197[(12)]);
var inst_62134 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_62131);
var inst_62135 = (inst_62096 == null);
var state_62197__$1 = (function (){var statearr_62207 = state_62197;
(statearr_62207[(13)] = inst_62134);

return statearr_62207;
})();
if(cljs.core.truth_(inst_62135)){
var statearr_62208_62283 = state_62197__$1;
(statearr_62208_62283[(1)] = (18));

} else {
var statearr_62209_62284 = state_62197__$1;
(statearr_62209_62284[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (21))){
var inst_62134 = (state_62197[(13)]);
var state_62197__$1 = state_62197;
var statearr_62210_62285 = state_62197__$1;
(statearr_62210_62285[(2)] = inst_62134);

(statearr_62210_62285[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (31))){
var state_62197__$1 = state_62197;
var statearr_62211_62286 = state_62197__$1;
(statearr_62211_62286[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (32))){
var inst_62160 = (state_62197[(2)]);
var state_62197__$1 = state_62197;
var statearr_62213_62287 = state_62197__$1;
(statearr_62213_62287[(2)] = inst_62160);

(statearr_62213_62287[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (40))){
var inst_62129 = (state_62197[(14)]);
var state_62197__$1 = state_62197;
if(cljs.core.truth_(inst_62129)){
var statearr_62214_62288 = state_62197__$1;
(statearr_62214_62288[(1)] = (42));

} else {
var statearr_62215_62289 = state_62197__$1;
(statearr_62215_62289[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (33))){
var inst_62134 = (state_62197[(13)]);
var inst_62096 = (state_62197[(12)]);
var inst_62155 = ((inst_62134 > inst_62096) ? inst_62134 : inst_62096);
var state_62197__$1 = state_62197;
var statearr_62216_62290 = state_62197__$1;
(statearr_62216_62290[(2)] = inst_62155);

(statearr_62216_62290[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (13))){
var inst_62120 = (state_62197[(2)]);
var state_62197__$1 = state_62197;
var statearr_62217_62291 = state_62197__$1;
(statearr_62217_62291[(2)] = inst_62120);

(statearr_62217_62291[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (22))){
var inst_62141 = (state_62197[(8)]);
var inst_62134 = (state_62197[(13)]);
var inst_62141__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_62134);
var state_62197__$1 = (function (){var statearr_62218 = state_62197;
(statearr_62218[(8)] = inst_62141__$1);

return statearr_62218;
})();
if(inst_62141__$1){
var statearr_62219_62292 = state_62197__$1;
(statearr_62219_62292[(1)] = (24));

} else {
var statearr_62220_62293 = state_62197__$1;
(statearr_62220_62293[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (36))){
var inst_62131 = (state_62197[(9)]);
var inst_62097 = (state_62197[(15)]);
var inst_62169 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_62131,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_62170 = (inst_62097 + inst_62169);
var state_62197__$1 = state_62197;
var statearr_62221_62294 = state_62197__$1;
(statearr_62221_62294[(2)] = inst_62170);

(statearr_62221_62294[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (41))){
var inst_62167 = (state_62197[(16)]);
var inst_62108 = (state_62197[(17)]);
var inst_62173 = (state_62197[(18)]);
var inst_62187 = (state_62197[(2)]);
var inst_62095 = inst_62108;
var inst_62096 = inst_62167;
var inst_62097 = inst_62173;
var inst_62098 = inst_62187;
var state_62197__$1 = (function (){var statearr_62222 = state_62197;
(statearr_62222[(10)] = inst_62098);

(statearr_62222[(19)] = inst_62095);

(statearr_62222[(12)] = inst_62096);

(statearr_62222[(15)] = inst_62097);

return statearr_62222;
})();
var statearr_62223_62295 = state_62197__$1;
(statearr_62223_62295[(2)] = null);

(statearr_62223_62295[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (43))){
var inst_62131 = (state_62197[(9)]);
var state_62197__$1 = state_62197;
var statearr_62224_62296 = state_62197__$1;
(statearr_62224_62296[(2)] = inst_62131);

(statearr_62224_62296[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (29))){
var inst_62149 = (state_62197[(2)]);
var state_62197__$1 = state_62197;
var statearr_62225_62297 = state_62197__$1;
(statearr_62225_62297[(2)] = inst_62149);

(statearr_62225_62297[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (44))){
var inst_62098 = (state_62197[(10)]);
var inst_62109 = (state_62197[(11)]);
var inst_62184 = (state_62197[(2)]);
var inst_62185 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_62098,inst_62109,inst_62184);
var state_62197__$1 = state_62197;
var statearr_62226_62298 = state_62197__$1;
(statearr_62226_62298[(2)] = inst_62185);

(statearr_62226_62298[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (6))){
var inst_62095 = (state_62197[(19)]);
var inst_62110 = (state_62197[(20)]);
var inst_62106 = cljs.core.seq(inst_62095);
var inst_62107 = cljs.core.first(inst_62106);
var inst_62108 = cljs.core.next(inst_62106);
var inst_62109 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62107,(0),null);
var inst_62110__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62107,(1),null);
var inst_62111 = (inst_62110__$1 == null);
var state_62197__$1 = (function (){var statearr_62227 = state_62197;
(statearr_62227[(11)] = inst_62109);

(statearr_62227[(17)] = inst_62108);

(statearr_62227[(20)] = inst_62110__$1);

return statearr_62227;
})();
if(cljs.core.truth_(inst_62111)){
var statearr_62228_62299 = state_62197__$1;
(statearr_62228_62299[(1)] = (8));

} else {
var statearr_62229_62300 = state_62197__$1;
(statearr_62229_62300[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (28))){
var inst_62096 = (state_62197[(12)]);
var inst_62147 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((207),inst_62096);
var state_62197__$1 = state_62197;
var statearr_62230_62301 = state_62197__$1;
(statearr_62230_62301[(2)] = inst_62147);

(statearr_62230_62301[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (25))){
var inst_62144 = (state_62197[(7)]);
var inst_62096 = (state_62197[(12)]);
var inst_62144__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_62096);
var state_62197__$1 = (function (){var statearr_62231 = state_62197;
(statearr_62231[(7)] = inst_62144__$1);

return statearr_62231;
})();
if(inst_62144__$1){
var statearr_62232_62302 = state_62197__$1;
(statearr_62232_62302[(1)] = (27));

} else {
var statearr_62233_62303 = state_62197__$1;
(statearr_62233_62303[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (34))){
var state_62197__$1 = state_62197;
var statearr_62234_62304 = state_62197__$1;
(statearr_62234_62304[(2)] = null);

(statearr_62234_62304[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (17))){
var inst_62128 = (state_62197[(21)]);
var inst_62167 = (state_62197[(2)]);
var state_62197__$1 = (function (){var statearr_62235 = state_62197;
(statearr_62235[(16)] = inst_62167);

return statearr_62235;
})();
if(cljs.core.truth_(inst_62128)){
var statearr_62236_62305 = state_62197__$1;
(statearr_62236_62305[(1)] = (36));

} else {
var statearr_62237_62306 = state_62197__$1;
(statearr_62237_62306[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (3))){
var inst_62195 = (state_62197[(2)]);
var state_62197__$1 = state_62197;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62197__$1,inst_62195);
} else {
if((state_val_62198 === (12))){
var inst_62098 = (state_62197[(10)]);
var state_62197__$1 = state_62197;
var statearr_62238_62307 = state_62197__$1;
(statearr_62238_62307[(2)] = inst_62098);

(statearr_62238_62307[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (2))){
var inst_62072 = (state_62197[(22)]);
var inst_62071 = (state_62197[(23)]);
var inst_62067 = (state_62197[(24)]);
var _ = (function (){var statearr_62239 = state_62197;
(statearr_62239[(4)] = cljs.core.cons((5),(state_62197[(4)])));

return statearr_62239;
})();
var inst_62063 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_62064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62065 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_62066 = (new cljs.core.PersistentVector(null,2,(5),inst_62064,inst_62065,null));
var inst_62067__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(flureeQL,inst_62066);
var inst_62068 = (function (){var global_block = inst_62063;
var global_meta_QMARK_ = inst_62067__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__5045__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__5043__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not(query_meta_QMARK_);
} else {
return and__5043__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_], 0));
var query_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return global_block;
}
})()], 0));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,alias,query_STAR_);
});
})();
var inst_62069 = cljs.core.PersistentHashMap.EMPTY;
var inst_62070 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210)], 0));
var inst_62071__$1 = cljs.core.reduce_kv(inst_62068,inst_62069,inst_62070);
var inst_62072__$1 = fluree.db.util.core.current_time_millis();
var inst_62074 = (function (){var global_block = inst_62063;
var global_meta_QMARK_ = inst_62067__$1;
var queries = inst_62071__$1;
var start_time = inst_62072__$1;
return (function (p__62073){
var vec__62240 = p__62073;
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62240,(0),null);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62240,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,(fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2(source,q) : fluree.db.api.query.query.call(null,source,q))], null);
});
})();
var inst_62075 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_62074,inst_62071__$1);
var inst_62089 = cljs.core.seq(inst_62075);
var inst_62090 = cljs.core.first(inst_62089);
var inst_62091 = cljs.core.next(inst_62089);
var inst_62092 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62090,(0),null);
var inst_62093 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62090,(1),null);
var inst_62094 = cljs.core.PersistentHashMap.EMPTY;
var inst_62095 = inst_62075;
var inst_62096 = null;
var inst_62097 = (0);
var inst_62098 = inst_62094;
var state_62197__$1 = (function (){var statearr_62243 = state_62197;
(statearr_62243[(22)] = inst_62072__$1);

(statearr_62243[(23)] = inst_62071__$1);

(statearr_62243[(24)] = inst_62067__$1);

(statearr_62243[(10)] = inst_62098);

(statearr_62243[(25)] = inst_62093);

(statearr_62243[(19)] = inst_62095);

(statearr_62243[(26)] = inst_62092);

(statearr_62243[(12)] = inst_62096);

(statearr_62243[(15)] = inst_62097);

(statearr_62243[(27)] = inst_62091);

return statearr_62243;
})();
var statearr_62244_62308 = state_62197__$1;
(statearr_62244_62308[(2)] = null);

(statearr_62244_62308[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (23))){
var inst_62162 = (state_62197[(2)]);
var state_62197__$1 = state_62197;
var statearr_62245_62309 = state_62197__$1;
(statearr_62245_62309[(2)] = inst_62162);

(statearr_62245_62309[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (35))){
var inst_62158 = (state_62197[(2)]);
var state_62197__$1 = state_62197;
var statearr_62246_62310 = state_62197__$1;
(statearr_62246_62310[(2)] = inst_62158);

(statearr_62246_62310[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (19))){
var inst_62134 = (state_62197[(13)]);
var inst_62096 = (state_62197[(12)]);
var inst_62138 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62096,inst_62134);
var state_62197__$1 = state_62197;
if(inst_62138){
var statearr_62247_62311 = state_62197__$1;
(statearr_62247_62311[(1)] = (21));

} else {
var statearr_62248_62312 = state_62197__$1;
(statearr_62248_62312[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (11))){
var inst_62072 = (state_62197[(22)]);
var inst_62098 = (state_62197[(10)]);
var inst_62096 = (state_62197[(12)]);
var inst_62097 = (state_62197[(15)]);
var inst_62114 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_62115 = fluree.db.util.core.response_time_formatted(inst_62072);
var inst_62116 = [inst_62098,inst_62097,inst_62096,inst_62115];
var inst_62117 = cljs.core.PersistentHashMap.fromArrays(inst_62114,inst_62116);
var state_62197__$1 = state_62197;
var statearr_62250_62313 = state_62197__$1;
(statearr_62250_62313[(2)] = inst_62117);

(statearr_62250_62313[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (9))){
var inst_62071 = (state_62197[(23)]);
var inst_62109 = (state_62197[(11)]);
var inst_62110 = (state_62197[(20)]);
var inst_62123 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62124 = [inst_62109,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_62125 = (new cljs.core.PersistentVector(null,2,(5),inst_62123,inst_62124,null));
var inst_62126 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62071,inst_62125);
var inst_62127 = cljs.core.__destructure_map(inst_62126);
var inst_62128 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62127,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_62129 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62127,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_62197__$1 = (function (){var statearr_62251 = state_62197;
(statearr_62251[(14)] = inst_62129);

(statearr_62251[(21)] = inst_62128);

return statearr_62251;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62197__$1,(14),inst_62110);
} else {
if((state_val_62198 === (5))){
var _ = (function (){var statearr_62252 = state_62197;
(statearr_62252[(4)] = cljs.core.rest((state_62197[(4)])));

return statearr_62252;
})();
var state_62197__$1 = state_62197;
var ex62249 = (state_62197__$1[(2)]);
var statearr_62253_62314 = state_62197__$1;
(statearr_62253_62314[(5)] = ex62249);


var statearr_62254_62315 = state_62197__$1;
(statearr_62254_62315[(1)] = (4));

(statearr_62254_62315[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (14))){
var inst_62131 = (state_62197[(9)]);
var inst_62128 = (state_62197[(21)]);
var inst_62131__$1 = (state_62197[(2)]);
var inst_62132 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_62131__$1);
var state_62197__$1 = (function (){var statearr_62255 = state_62197;
(statearr_62255[(9)] = inst_62131__$1);

(statearr_62255[(28)] = inst_62132);

return statearr_62255;
})();
if(cljs.core.truth_(inst_62128)){
var statearr_62256_62316 = state_62197__$1;
(statearr_62256_62316[(1)] = (15));

} else {
var statearr_62257_62317 = state_62197__$1;
(statearr_62257_62317[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (26))){
var inst_62151 = (state_62197[(2)]);
var state_62197__$1 = state_62197;
if(cljs.core.truth_(inst_62151)){
var statearr_62258_62318 = state_62197__$1;
(statearr_62258_62318[(1)] = (30));

} else {
var statearr_62259_62319 = state_62197__$1;
(statearr_62259_62319[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (16))){
var state_62197__$1 = state_62197;
var statearr_62260_62320 = state_62197__$1;
(statearr_62260_62320[(2)] = null);

(statearr_62260_62320[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (38))){
var inst_62132 = (state_62197[(28)]);
var inst_62173 = (state_62197[(2)]);
var state_62197__$1 = (function (){var statearr_62261 = state_62197;
(statearr_62261[(18)] = inst_62173);

return statearr_62261;
})();
if(cljs.core.truth_(inst_62132)){
var statearr_62262_62321 = state_62197__$1;
(statearr_62262_62321[(1)] = (39));

} else {
var statearr_62263_62322 = state_62197__$1;
(statearr_62263_62322[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (30))){
var state_62197__$1 = state_62197;
var statearr_62264_62323 = state_62197__$1;
(statearr_62264_62323[(2)] = (207));

(statearr_62264_62323[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (10))){
var inst_62190 = (state_62197[(2)]);
var state_62197__$1 = state_62197;
var statearr_62265_62324 = state_62197__$1;
(statearr_62265_62324[(2)] = inst_62190);

(statearr_62265_62324[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (18))){
var inst_62134 = (state_62197[(13)]);
var state_62197__$1 = state_62197;
var statearr_62266_62325 = state_62197__$1;
(statearr_62266_62325[(2)] = inst_62134);

(statearr_62266_62325[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (42))){
var inst_62131 = (state_62197[(9)]);
var inst_62181 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_62131);
var state_62197__$1 = state_62197;
var statearr_62267_62326 = state_62197__$1;
(statearr_62267_62326[(2)] = inst_62181);

(statearr_62267_62326[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (37))){
var state_62197__$1 = state_62197;
var statearr_62268_62327 = state_62197__$1;
(statearr_62268_62327[(2)] = null);

(statearr_62268_62327[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62198 === (8))){
var inst_62067 = (state_62197[(24)]);
var state_62197__$1 = state_62197;
if(cljs.core.truth_(inst_62067)){
var statearr_62269_62328 = state_62197__$1;
(statearr_62269_62328[(1)] = (11));

} else {
var statearr_62270_62329 = state_62197__$1;
(statearr_62270_62329[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2749__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2749__auto____0 = (function (){
var statearr_62271 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62271[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2749__auto__);

(statearr_62271[(1)] = (1));

return statearr_62271;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2749__auto____1 = (function (state_62197){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_62197);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e62272){var ex__2752__auto__ = e62272;
var statearr_62273_62330 = state_62197;
(statearr_62273_62330[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_62197[(4)]))){
var statearr_62274_62331 = state_62197;
(statearr_62274_62331[(1)] = cljs.core.first((state_62197[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62332 = state_62197;
state_62197 = G__62332;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2749__auto__ = function(state_62197){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2749__auto____1.call(this,state_62197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2749__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2749__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_62275 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_62275[(6)] = c__2771__auto__);

return statearr_62275;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type(flureeQL);
var G__62333 = query_type;
var G__62333__$1 = (((G__62333 instanceof cljs.core.Keyword))?G__62333.fqn:null);
switch (G__62333__$1) {
case "standard":
return fluree.db.api.query.query_async(source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async(source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async(conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async(source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__62333__$1)].join('')));

}
});
