// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__62380_62549 = cljs.core.seq(servers);
var chunk__62381_62550 = null;
var count__62382_62551 = (0);
var i__62383_62552 = (0);
while(true){
if((i__62383_62552 < count__62382_62551)){
var server_62553 = chunk__62381_62550.cljs$core$IIndexed$_nth$arity$2(null,i__62383_62552);
var healthcheck_uri_62554 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_62553),"/fdb/health"].join('');
var resp_chan_62555 = fluree.db.util.xhttp.post_json(healthcheck_uri_62554,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2771__auto___62556 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__62380_62549,chunk__62381_62550,count__62382_62551,i__62383_62552,c__2771__auto___62556,healthcheck_uri_62554,resp_chan_62555,server_62553){
return (function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = ((function (seq__62380_62549,chunk__62381_62550,count__62382_62551,i__62383_62552,c__2771__auto___62556,healthcheck_uri_62554,resp_chan_62555,server_62553){
return (function (state_62444){
var state_val_62445 = (state_62444[(1)]);
if((state_val_62445 === (1))){
var state_62444__$1 = state_62444;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62444__$1,(2),resp_chan_62555);
} else {
if((state_val_62445 === (2))){
var inst_62433 = (state_62444[(7)]);
var inst_62433__$1 = (state_62444[(2)]);
var inst_62434 = fluree.db.util.core.exception_QMARK_(inst_62433__$1);
var state_62444__$1 = (function (){var statearr_62446 = state_62444;
(statearr_62446[(7)] = inst_62433__$1);

return statearr_62446;
})();
if(inst_62434){
var statearr_62447_62557 = state_62444__$1;
(statearr_62447_62557[(1)] = (3));

} else {
var statearr_62448_62558 = state_62444__$1;
(statearr_62448_62558[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62445 === (3))){
var inst_62433 = (state_62444[(7)]);
var inst_62436 = cljs.core.ex_message(inst_62433);
var inst_62437 = cljs.core.ex_data(inst_62433);
var inst_62438 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_62436,inst_62437], 0));
var state_62444__$1 = state_62444;
var statearr_62449_62559 = state_62444__$1;
(statearr_62449_62559[(2)] = inst_62438);

(statearr_62449_62559[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62445 === (4))){
var inst_62440 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_62553);
var state_62444__$1 = state_62444;
var statearr_62450_62560 = state_62444__$1;
(statearr_62450_62560[(2)] = inst_62440);

(statearr_62450_62560[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62445 === (5))){
var inst_62442 = (state_62444[(2)]);
var state_62444__$1 = state_62444;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62444__$1,inst_62442);
} else {
return null;
}
}
}
}
}
});})(seq__62380_62549,chunk__62381_62550,count__62382_62551,i__62383_62552,c__2771__auto___62556,healthcheck_uri_62554,resp_chan_62555,server_62553))
;
return ((function (seq__62380_62549,chunk__62381_62550,count__62382_62551,i__62383_62552,switch__2748__auto__,c__2771__auto___62556,healthcheck_uri_62554,resp_chan_62555,server_62553){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto____0 = (function (){
var statearr_62451 = [null,null,null,null,null,null,null,null];
(statearr_62451[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto__);

(statearr_62451[(1)] = (1));

return statearr_62451;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto____1 = (function (state_62444){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_62444);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e62452){var ex__2752__auto__ = e62452;
var statearr_62453_62561 = state_62444;
(statearr_62453_62561[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_62444[(4)]))){
var statearr_62454_62562 = state_62444;
(statearr_62454_62562[(1)] = cljs.core.first((state_62444[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62563 = state_62444;
state_62444 = G__62563;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto__ = function(state_62444){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto____1.call(this,state_62444);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto__;
})()
;})(seq__62380_62549,chunk__62381_62550,count__62382_62551,i__62383_62552,switch__2748__auto__,c__2771__auto___62556,healthcheck_uri_62554,resp_chan_62555,server_62553))
})();
var state__2773__auto__ = (function (){var statearr_62455 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_62455[(6)] = c__2771__auto___62556);

return statearr_62455;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
});})(seq__62380_62549,chunk__62381_62550,count__62382_62551,i__62383_62552,c__2771__auto___62556,healthcheck_uri_62554,resp_chan_62555,server_62553))
);



var G__62564 = seq__62380_62549;
var G__62565 = chunk__62381_62550;
var G__62566 = count__62382_62551;
var G__62567 = (i__62383_62552 + (1));
seq__62380_62549 = G__62564;
chunk__62381_62550 = G__62565;
count__62382_62551 = G__62566;
i__62383_62552 = G__62567;
continue;
} else {
var temp__5804__auto___62568 = cljs.core.seq(seq__62380_62549);
if(temp__5804__auto___62568){
var seq__62380_62569__$1 = temp__5804__auto___62568;
if(cljs.core.chunked_seq_QMARK_(seq__62380_62569__$1)){
var c__5567__auto___62570 = cljs.core.chunk_first(seq__62380_62569__$1);
var G__62571 = cljs.core.chunk_rest(seq__62380_62569__$1);
var G__62572 = c__5567__auto___62570;
var G__62573 = cljs.core.count(c__5567__auto___62570);
var G__62574 = (0);
seq__62380_62549 = G__62571;
chunk__62381_62550 = G__62572;
count__62382_62551 = G__62573;
i__62383_62552 = G__62574;
continue;
} else {
var server_62575 = cljs.core.first(seq__62380_62569__$1);
var healthcheck_uri_62576 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_62575),"/fdb/health"].join('');
var resp_chan_62577 = fluree.db.util.xhttp.post_json(healthcheck_uri_62576,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2771__auto___62578 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__62380_62549,chunk__62381_62550,count__62382_62551,i__62383_62552,c__2771__auto___62578,healthcheck_uri_62576,resp_chan_62577,server_62575,seq__62380_62569__$1,temp__5804__auto___62568){
return (function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = ((function (seq__62380_62549,chunk__62381_62550,count__62382_62551,i__62383_62552,c__2771__auto___62578,healthcheck_uri_62576,resp_chan_62577,server_62575,seq__62380_62569__$1,temp__5804__auto___62568){
return (function (state_62468){
var state_val_62469 = (state_62468[(1)]);
if((state_val_62469 === (1))){
var state_62468__$1 = state_62468;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62468__$1,(2),resp_chan_62577);
} else {
if((state_val_62469 === (2))){
var inst_62457 = (state_62468[(7)]);
var inst_62457__$1 = (state_62468[(2)]);
var inst_62458 = fluree.db.util.core.exception_QMARK_(inst_62457__$1);
var state_62468__$1 = (function (){var statearr_62470 = state_62468;
(statearr_62470[(7)] = inst_62457__$1);

return statearr_62470;
})();
if(inst_62458){
var statearr_62471_62579 = state_62468__$1;
(statearr_62471_62579[(1)] = (3));

} else {
var statearr_62472_62580 = state_62468__$1;
(statearr_62472_62580[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62469 === (3))){
var inst_62457 = (state_62468[(7)]);
var inst_62460 = cljs.core.ex_message(inst_62457);
var inst_62461 = cljs.core.ex_data(inst_62457);
var inst_62462 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_62460,inst_62461], 0));
var state_62468__$1 = state_62468;
var statearr_62473_62581 = state_62468__$1;
(statearr_62473_62581[(2)] = inst_62462);

(statearr_62473_62581[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62469 === (4))){
var inst_62464 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_62575);
var state_62468__$1 = state_62468;
var statearr_62474_62582 = state_62468__$1;
(statearr_62474_62582[(2)] = inst_62464);

(statearr_62474_62582[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62469 === (5))){
var inst_62466 = (state_62468[(2)]);
var state_62468__$1 = state_62468;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62468__$1,inst_62466);
} else {
return null;
}
}
}
}
}
});})(seq__62380_62549,chunk__62381_62550,count__62382_62551,i__62383_62552,c__2771__auto___62578,healthcheck_uri_62576,resp_chan_62577,server_62575,seq__62380_62569__$1,temp__5804__auto___62568))
;
return ((function (seq__62380_62549,chunk__62381_62550,count__62382_62551,i__62383_62552,switch__2748__auto__,c__2771__auto___62578,healthcheck_uri_62576,resp_chan_62577,server_62575,seq__62380_62569__$1,temp__5804__auto___62568){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto____0 = (function (){
var statearr_62475 = [null,null,null,null,null,null,null,null];
(statearr_62475[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto__);

(statearr_62475[(1)] = (1));

return statearr_62475;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto____1 = (function (state_62468){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_62468);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e62476){var ex__2752__auto__ = e62476;
var statearr_62477_62583 = state_62468;
(statearr_62477_62583[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_62468[(4)]))){
var statearr_62478_62584 = state_62468;
(statearr_62478_62584[(1)] = cljs.core.first((state_62468[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62585 = state_62468;
state_62468 = G__62585;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto__ = function(state_62468){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto____1.call(this,state_62468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto__;
})()
;})(seq__62380_62549,chunk__62381_62550,count__62382_62551,i__62383_62552,switch__2748__auto__,c__2771__auto___62578,healthcheck_uri_62576,resp_chan_62577,server_62575,seq__62380_62569__$1,temp__5804__auto___62568))
})();
var state__2773__auto__ = (function (){var statearr_62479 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_62479[(6)] = c__2771__auto___62578);

return statearr_62479;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
});})(seq__62380_62549,chunk__62381_62550,count__62382_62551,i__62383_62552,c__2771__auto___62578,healthcheck_uri_62576,resp_chan_62577,server_62575,seq__62380_62569__$1,temp__5804__auto___62568))
);



var G__62586 = cljs.core.next(seq__62380_62569__$1);
var G__62587 = null;
var G__62588 = (0);
var G__62589 = (0);
seq__62380_62549 = G__62586;
chunk__62381_62550 = G__62587;
count__62382_62551 = G__62588;
i__62383_62552 = G__62589;
continue;
}
} else {
}
}
break;
}

var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_62523){
var state_val_62524 = (state_62523[(1)]);
if((state_val_62524 === (7))){
var inst_62495 = (state_62523[(7)]);
var inst_62502 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62495,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_62523__$1 = state_62523;
if(inst_62502){
var statearr_62525_62590 = state_62523__$1;
(statearr_62525_62590[(1)] = (9));

} else {
var statearr_62526_62591 = state_62523__$1;
(statearr_62526_62591[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62524 === (1))){
var inst_62487 = (state_62523[(8)]);
var inst_62488 = (state_62523[(9)]);
var inst_62487__$1 = promise_chan;
var inst_62488__$1 = cljs.core.async.timeout((60000));
var inst_62489 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62490 = [inst_62487__$1,inst_62488__$1];
var inst_62491 = (new cljs.core.PersistentVector(null,2,(5),inst_62489,inst_62490,null));
var state_62523__$1 = (function (){var statearr_62527 = state_62523;
(statearr_62527[(8)] = inst_62487__$1);

(statearr_62527[(9)] = inst_62488__$1);

return statearr_62527;
})();
return cljs.core.async.ioc_alts_BANG_(state_62523__$1,(2),inst_62491);
} else {
if((state_val_62524 === (4))){
var inst_62495 = (state_62523[(7)]);
var inst_62488 = (state_62523[(9)]);
var inst_62499 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62495,inst_62488);
var state_62523__$1 = state_62523;
if(inst_62499){
var statearr_62528_62592 = state_62523__$1;
(statearr_62528_62592[(1)] = (6));

} else {
var statearr_62529_62593 = state_62523__$1;
(statearr_62529_62593[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62524 === (13))){
var state_62523__$1 = state_62523;
var statearr_62530_62594 = state_62523__$1;
(statearr_62530_62594[(2)] = null);

(statearr_62530_62594[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62524 === (6))){
var state_62523__$1 = state_62523;
var statearr_62531_62595 = state_62523__$1;
(statearr_62531_62595[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_62531_62595[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62524 === (3))){
var state_62523__$1 = state_62523;
var statearr_62532_62596 = state_62523__$1;
(statearr_62532_62596[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_62532_62596[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62524 === (12))){
var inst_62513 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"server","server",1499190120)], 0));
var inst_62514 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62515 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_62516 = cljs.core.PersistentHashMap.fromArrays(inst_62514,inst_62515);
var inst_62517 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_62516);
var inst_62518 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_62517);
var state_62523__$1 = (function (){var statearr_62533 = state_62523;
(statearr_62533[(10)] = inst_62513);

return statearr_62533;
})();
var statearr_62534_62597 = state_62523__$1;
(statearr_62534_62597[(2)] = inst_62518);

(statearr_62534_62597[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62524 === (2))){
var inst_62495 = (state_62523[(7)]);
var inst_62487 = (state_62523[(8)]);
var inst_62493 = (state_62523[(2)]);
var inst_62494 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62493,(0),null);
var inst_62495__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62493,(1),null);
var inst_62496 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62495__$1,inst_62487);
var state_62523__$1 = (function (){var statearr_62535 = state_62523;
(statearr_62535[(7)] = inst_62495__$1);

(statearr_62535[(11)] = inst_62494);

return statearr_62535;
})();
if(inst_62496){
var statearr_62536_62598 = state_62523__$1;
(statearr_62536_62598[(1)] = (3));

} else {
var statearr_62537_62599 = state_62523__$1;
(statearr_62537_62599[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62524 === (11))){
var inst_62506 = (state_62523[(2)]);
var state_62523__$1 = state_62523;
var statearr_62538_62600 = state_62523__$1;
(statearr_62538_62600[(2)] = inst_62506);

(statearr_62538_62600[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62524 === (9))){
var inst_62494 = (state_62523[(11)]);
var state_62523__$1 = state_62523;
var statearr_62539_62601 = state_62523__$1;
(statearr_62539_62601[(2)] = inst_62494);

(statearr_62539_62601[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62524 === (5))){
var inst_62510 = (state_62523[(2)]);
var inst_62511 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_62510);
var state_62523__$1 = state_62523;
if(inst_62511){
var statearr_62540_62602 = state_62523__$1;
(statearr_62540_62602[(1)] = (12));

} else {
var statearr_62541_62603 = state_62523__$1;
(statearr_62541_62603[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62524 === (14))){
var inst_62521 = (state_62523[(2)]);
var state_62523__$1 = state_62523;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62523__$1,inst_62521);
} else {
if((state_val_62524 === (10))){
var state_62523__$1 = state_62523;
var statearr_62542_62604 = state_62523__$1;
(statearr_62542_62604[(2)] = null);

(statearr_62542_62604[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62524 === (8))){
var inst_62508 = (state_62523[(2)]);
var state_62523__$1 = state_62523;
var statearr_62543_62605 = state_62523__$1;
(statearr_62543_62605[(2)] = inst_62508);

(statearr_62543_62605[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto____0 = (function (){
var statearr_62544 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62544[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto__);

(statearr_62544[(1)] = (1));

return statearr_62544;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto____1 = (function (state_62523){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_62523);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e62545){var ex__2752__auto__ = e62545;
var statearr_62546_62606 = state_62523;
(statearr_62546_62606[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_62523[(4)]))){
var statearr_62547_62607 = state_62523;
(statearr_62547_62607[(1)] = cljs.core.first((state_62523[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62608 = state_62523;
state_62523 = G__62608;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto__ = function(state_62523){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto____1.call(this,state_62523);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_62548 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_62548[(6)] = c__2771__auto__);

return statearr_62548;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_62652){
var state_val_62653 = (state_62652[(1)]);
if((state_val_62653 === (7))){
var state_62652__$1 = state_62652;
var statearr_62654_62680 = state_62652__$1;
(statearr_62654_62680[(2)] = null);

(statearr_62654_62680[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62653 === (1))){
var state_62652__$1 = state_62652;
var statearr_62655_62681 = state_62652__$1;
(statearr_62655_62681[(2)] = null);

(statearr_62655_62681[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62653 === (4))){
var inst_62609 = (state_62652[(2)]);
var state_62652__$1 = state_62652;
var statearr_62656_62682 = state_62652__$1;
(statearr_62656_62682[(2)] = inst_62609);

(statearr_62656_62682[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62653 === (6))){
var inst_62631 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_62652__$1 = state_62652;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62652__$1,(9),inst_62631);
} else {
if((state_val_62653 === (3))){
var inst_62650 = (state_62652[(2)]);
var state_62652__$1 = state_62652;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62652__$1,inst_62650);
} else {
if((state_val_62653 === (12))){
var inst_62644 = (state_62652[(2)]);
var state_62652__$1 = state_62652;
var statearr_62657_62683 = state_62652__$1;
(statearr_62657_62683[(2)] = inst_62644);

(statearr_62657_62683[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62653 === (2))){
var inst_62620 = (state_62652[(7)]);
var inst_62625 = (state_62652[(8)]);
var inst_62615 = (state_62652[(9)]);
var _ = (function (){var statearr_62658 = state_62652;
(statearr_62658[(4)] = cljs.core.cons((5),(state_62652[(4)])));

return statearr_62658;
})();
var inst_62615__$1 = fluree.db.util.core.random_uuid();
var inst_62616 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62617 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_62618 = (new cljs.core.PersistentVector(null,2,(5),inst_62616,inst_62617,null));
var inst_62619 = (function (){var lock_id = inst_62615__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_62620__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_62618,inst_62619);
var inst_62621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62622 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_62623 = (new cljs.core.PersistentVector(null,3,(5),inst_62621,inst_62622,null));
var inst_62624 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62620__$1,inst_62623);
var inst_62625__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62615__$1,inst_62624);
var inst_62626 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62627 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_62628 = (new cljs.core.PersistentVector(null,3,(5),inst_62626,inst_62627,null));
var inst_62629 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62620__$1,inst_62628);
var state_62652__$1 = (function (){var statearr_62659 = state_62652;
(statearr_62659[(10)] = inst_62629);

(statearr_62659[(7)] = inst_62620__$1);

(statearr_62659[(8)] = inst_62625__$1);

(statearr_62659[(9)] = inst_62615__$1);

return statearr_62659;
})();
if(inst_62625__$1){
var statearr_62660_62684 = state_62652__$1;
(statearr_62660_62684[(1)] = (6));

} else {
var statearr_62661_62685 = state_62652__$1;
(statearr_62661_62685[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62653 === (11))){
var inst_62629 = (state_62652[(10)]);
var inst_62636 = (state_62652[(11)]);
var inst_62635 = (state_62652[(12)]);
var inst_62642 = fluree.db.util.xhttp.try_socket(inst_62635,sub_chan,pub_chan,inst_62629,(60000),inst_62636);
var state_62652__$1 = state_62652;
var statearr_62663_62686 = state_62652__$1;
(statearr_62663_62686[(2)] = inst_62642);

(statearr_62663_62686[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62653 === (9))){
var inst_62629 = (state_62652[(10)]);
var inst_62620 = (state_62652[(7)]);
var inst_62633 = (state_62652[(13)]);
var inst_62625 = (state_62652[(8)]);
var inst_62635 = (state_62652[(12)]);
var inst_62615 = (state_62652[(9)]);
var inst_62633__$1 = (state_62652[(2)]);
var inst_62634 = clojure.string.replace(inst_62633__$1,"http","ws");
var inst_62635__$1 = [inst_62634,"/fdb/ws"].join('');
var inst_62636 = (function (){var lock_id = inst_62615;
var state = inst_62620;
var have_lock_QMARK_ = inst_62625;
var resp_chan = inst_62629;
var healthy_server = inst_62633__$1;
var ws_url = inst_62635__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_62637 = fluree.db.util.core.exception_QMARK_(inst_62633__$1);
var state_62652__$1 = (function (){var statearr_62664 = state_62652;
(statearr_62664[(11)] = inst_62636);

(statearr_62664[(13)] = inst_62633__$1);

(statearr_62664[(12)] = inst_62635__$1);

return statearr_62664;
})();
if(inst_62637){
var statearr_62665_62687 = state_62652__$1;
(statearr_62665_62687[(1)] = (10));

} else {
var statearr_62666_62688 = state_62652__$1;
(statearr_62666_62688[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62653 === (5))){
var _ = (function (){var statearr_62667 = state_62652;
(statearr_62667[(4)] = cljs.core.rest((state_62652[(4)])));

return statearr_62667;
})();
var state_62652__$1 = state_62652;
var ex62662 = (state_62652__$1[(2)]);
var statearr_62668_62689 = state_62652__$1;
(statearr_62668_62689[(5)] = ex62662);


if((ex62662 instanceof Error)){
var statearr_62669_62690 = state_62652__$1;
(statearr_62669_62690[(1)] = (4));

(statearr_62669_62690[(5)] = null);

} else {
throw ex62662;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62653 === (10))){
var inst_62629 = (state_62652[(10)]);
var inst_62633 = (state_62652[(13)]);
var inst_62639 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ws","ws",86841443)], 0));
var inst_62640 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62629,inst_62633);
var state_62652__$1 = (function (){var statearr_62670 = state_62652;
(statearr_62670[(14)] = inst_62639);

return statearr_62670;
})();
var statearr_62671_62691 = state_62652__$1;
(statearr_62671_62691[(2)] = inst_62640);

(statearr_62671_62691[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62653 === (8))){
var inst_62629 = (state_62652[(10)]);
var inst_62647 = (state_62652[(2)]);
var _ = (function (){var statearr_62672 = state_62652;
(statearr_62672[(4)] = cljs.core.rest((state_62652[(4)])));

return statearr_62672;
})();
var state_62652__$1 = (function (){var statearr_62673 = state_62652;
(statearr_62673[(15)] = inst_62647);

return statearr_62673;
})();
var statearr_62674_62692 = state_62652__$1;
(statearr_62674_62692[(2)] = inst_62629);

(statearr_62674_62692[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2749__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2749__auto____0 = (function (){
var statearr_62675 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62675[(0)] = fluree$db$connection$establish_socket_$_state_machine__2749__auto__);

(statearr_62675[(1)] = (1));

return statearr_62675;
});
var fluree$db$connection$establish_socket_$_state_machine__2749__auto____1 = (function (state_62652){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_62652);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e62676){var ex__2752__auto__ = e62676;
var statearr_62677_62693 = state_62652;
(statearr_62677_62693[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_62652[(4)]))){
var statearr_62678_62694 = state_62652;
(statearr_62678_62694[(1)] = cljs.core.first((state_62652[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62695 = state_62652;
state_62652 = G__62695;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2749__auto__ = function(state_62652){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2749__auto____1.call(this,state_62652);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2749__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2749__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_62679 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_62679[(6)] = c__2771__auto__);

return statearr_62679;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5342__auto__,k__5343__auto__){
var self__ = this;
var this__5342__auto____$1 = this;
return this__5342__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5343__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5344__auto__,k62697,else__5345__auto__){
var self__ = this;
var this__5344__auto____$1 = this;
var G__62701 = k62697;
var G__62701__$1 = (((G__62701 instanceof cljs.core.Keyword))?G__62701.fqn:null);
switch (G__62701__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k62697,else__5345__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5362__auto__,f__5363__auto__,init__5364__auto__){
var self__ = this;
var this__5362__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5365__auto__,p__62702){
var vec__62703 = p__62702;
var k__5366__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62703,(0),null);
var v__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62703,(1),null);
return (f__5363__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5363__auto__.cljs$core$IFn$_invoke$arity$3(ret__5365__auto__,k__5366__auto__,v__5367__auto__) : f__5363__auto__.call(null,ret__5365__auto__,k__5366__auto__,v__5367__auto__));
}),init__5364__auto__,this__5362__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5357__auto__,writer__5358__auto__,opts__5359__auto__){
var self__ = this;
var this__5357__auto____$1 = this;
var pr_pair__5360__auto__ = (function (keyval__5361__auto__){
return cljs.core.pr_sequential_writer(writer__5358__auto__,cljs.core.pr_writer,""," ","",opts__5359__auto__,keyval__5361__auto__);
});
return cljs.core.pr_sequential_writer(writer__5358__auto__,pr_pair__5360__auto__,"#fluree.db.connection.Connection{",", ","}",opts__5359__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__62696){
var self__ = this;
var G__62696__$1 = this;
return (new cljs.core.RecordIter((0),G__62696__$1,22,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5340__auto__){
var self__ = this;
var this__5340__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5337__auto__){
var self__ = this;
var this__5337__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5346__auto__){
var self__ = this;
var this__5346__auto____$1 = this;
return (22 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__62706 = (function (coll__5339__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__5339__auto__));
});
return fexpr__62706(this__5338__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this62698,other62699){
var self__ = this;
var this62698__$1 = this;
return (((!((other62699 == null)))) && ((((this62698__$1.constructor === other62699.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62698__$1.id,other62699.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62698__$1.servers,other62699.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62698__$1.state,other62699.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62698__$1.req_chan,other62699.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62698__$1.sub_chan,other62699.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62698__$1.pub_chan,other62699.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62698__$1.group,other62699.group)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62698__$1.storage_read,other62699.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62698__$1.storage_write,other62699.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62698__$1.object_cache,other62699.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62698__$1.parallelism,other62699.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62698__$1.serializer,other62699.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62698__$1.default_network,other62699.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62698__$1.transactor_QMARK_,other62699.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62698__$1.publish,other62699.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62698__$1.transact_handler,other62699.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62698__$1.tx_private_key,other62699.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62698__$1.tx_key_id,other62699.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62698__$1.meta,other62699.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62698__$1.add_listener,other62699.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62698__$1.remove_listener,other62699.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62698__$1.close,other62699.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62698__$1.__extmap,other62699.__extmap)))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5352__auto__,k__5353__auto__){
var self__ = this;
var this__5352__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__5353__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5352__auto____$1),self__.__meta),k__5353__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5353__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5349__auto__,k62697){
var self__ = this;
var this__5349__auto____$1 = this;
var G__62707 = k62697;
var G__62707__$1 = (((G__62707 instanceof cljs.core.Keyword))?G__62707.fqn:null);
switch (G__62707__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k62697);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5350__auto__,k__5351__auto__,G__62696){
var self__ = this;
var this__5350__auto____$1 = this;
var pred__62708 = cljs.core.keyword_identical_QMARK_;
var expr__62709 = k__5351__auto__;
if(cljs.core.truth_((function (){var G__62711 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__62712 = expr__62709;
return (pred__62708.cljs$core$IFn$_invoke$arity$2 ? pred__62708.cljs$core$IFn$_invoke$arity$2(G__62711,G__62712) : pred__62708.call(null,G__62711,G__62712));
})())){
return (new fluree.db.connection.Connection(G__62696,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62713 = new cljs.core.Keyword(null,"servers","servers",1881102005);
var G__62714 = expr__62709;
return (pred__62708.cljs$core$IFn$_invoke$arity$2 ? pred__62708.cljs$core$IFn$_invoke$arity$2(G__62713,G__62714) : pred__62708.call(null,G__62713,G__62714));
})())){
return (new fluree.db.connection.Connection(self__.id,G__62696,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62715 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__62716 = expr__62709;
return (pred__62708.cljs$core$IFn$_invoke$arity$2 ? pred__62708.cljs$core$IFn$_invoke$arity$2(G__62715,G__62716) : pred__62708.call(null,G__62715,G__62716));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__62696,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62717 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046);
var G__62718 = expr__62709;
return (pred__62708.cljs$core$IFn$_invoke$arity$2 ? pred__62708.cljs$core$IFn$_invoke$arity$2(G__62717,G__62718) : pred__62708.call(null,G__62717,G__62718));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__62696,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62719 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215);
var G__62720 = expr__62709;
return (pred__62708.cljs$core$IFn$_invoke$arity$2 ? pred__62708.cljs$core$IFn$_invoke$arity$2(G__62719,G__62720) : pred__62708.call(null,G__62719,G__62720));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__62696,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62721 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593);
var G__62722 = expr__62709;
return (pred__62708.cljs$core$IFn$_invoke$arity$2 ? pred__62708.cljs$core$IFn$_invoke$arity$2(G__62721,G__62722) : pred__62708.call(null,G__62721,G__62722));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__62696,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62723 = new cljs.core.Keyword(null,"group","group",582596132);
var G__62724 = expr__62709;
return (pred__62708.cljs$core$IFn$_invoke$arity$2 ? pred__62708.cljs$core$IFn$_invoke$arity$2(G__62723,G__62724) : pred__62708.call(null,G__62723,G__62724));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__62696,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62725 = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537);
var G__62726 = expr__62709;
return (pred__62708.cljs$core$IFn$_invoke$arity$2 ? pred__62708.cljs$core$IFn$_invoke$arity$2(G__62725,G__62726) : pred__62708.call(null,G__62725,G__62726));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__62696,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62727 = new cljs.core.Keyword(null,"storage-write","storage-write",595144816);
var G__62728 = expr__62709;
return (pred__62708.cljs$core$IFn$_invoke$arity$2 ? pred__62708.cljs$core$IFn$_invoke$arity$2(G__62727,G__62728) : pred__62708.call(null,G__62727,G__62728));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__62696,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62729 = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287);
var G__62730 = expr__62709;
return (pred__62708.cljs$core$IFn$_invoke$arity$2 ? pred__62708.cljs$core$IFn$_invoke$arity$2(G__62729,G__62730) : pred__62708.call(null,G__62729,G__62730));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,G__62696,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62731 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333);
var G__62732 = expr__62709;
return (pred__62708.cljs$core$IFn$_invoke$arity$2 ? pred__62708.cljs$core$IFn$_invoke$arity$2(G__62731,G__62732) : pred__62708.call(null,G__62731,G__62732));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,G__62696,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62733 = new cljs.core.Keyword(null,"serializer","serializer",-875689688);
var G__62734 = expr__62709;
return (pred__62708.cljs$core$IFn$_invoke$arity$2 ? pred__62708.cljs$core$IFn$_invoke$arity$2(G__62733,G__62734) : pred__62708.call(null,G__62733,G__62734));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__62696,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62735 = new cljs.core.Keyword(null,"default-network","default-network",586420705);
var G__62736 = expr__62709;
return (pred__62708.cljs$core$IFn$_invoke$arity$2 ? pred__62708.cljs$core$IFn$_invoke$arity$2(G__62735,G__62736) : pred__62708.call(null,G__62735,G__62736));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__62696,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62737 = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057);
var G__62738 = expr__62709;
return (pred__62708.cljs$core$IFn$_invoke$arity$2 ? pred__62708.cljs$core$IFn$_invoke$arity$2(G__62737,G__62738) : pred__62708.call(null,G__62737,G__62738));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__62696,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62739 = new cljs.core.Keyword(null,"publish","publish",-1178026850);
var G__62740 = expr__62709;
return (pred__62708.cljs$core$IFn$_invoke$arity$2 ? pred__62708.cljs$core$IFn$_invoke$arity$2(G__62739,G__62740) : pred__62708.call(null,G__62739,G__62740));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__62696,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62741 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037);
var G__62742 = expr__62709;
return (pred__62708.cljs$core$IFn$_invoke$arity$2 ? pred__62708.cljs$core$IFn$_invoke$arity$2(G__62741,G__62742) : pred__62708.call(null,G__62741,G__62742));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__62696,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62743 = new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122);
var G__62744 = expr__62709;
return (pred__62708.cljs$core$IFn$_invoke$arity$2 ? pred__62708.cljs$core$IFn$_invoke$arity$2(G__62743,G__62744) : pred__62708.call(null,G__62743,G__62744));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__62696,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62745 = new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145);
var G__62746 = expr__62709;
return (pred__62708.cljs$core$IFn$_invoke$arity$2 ? pred__62708.cljs$core$IFn$_invoke$arity$2(G__62745,G__62746) : pred__62708.call(null,G__62745,G__62746));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__62696,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62747 = new cljs.core.Keyword(null,"meta","meta",1499536964);
var G__62748 = expr__62709;
return (pred__62708.cljs$core$IFn$_invoke$arity$2 ? pred__62708.cljs$core$IFn$_invoke$arity$2(G__62747,G__62748) : pred__62708.call(null,G__62747,G__62748));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__62696,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62749 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051);
var G__62750 = expr__62709;
return (pred__62708.cljs$core$IFn$_invoke$arity$2 ? pred__62708.cljs$core$IFn$_invoke$arity$2(G__62749,G__62750) : pred__62708.call(null,G__62749,G__62750));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__62696,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62751 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802);
var G__62752 = expr__62709;
return (pred__62708.cljs$core$IFn$_invoke$arity$2 ? pred__62708.cljs$core$IFn$_invoke$arity$2(G__62751,G__62752) : pred__62708.call(null,G__62751,G__62752));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__62696,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62753 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__62754 = expr__62709;
return (pred__62708.cljs$core$IFn$_invoke$arity$2 ? pred__62708.cljs$core$IFn$_invoke$arity$2(G__62753,G__62754) : pred__62708.call(null,G__62753,G__62754));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__62696,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5351__auto__,G__62696),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5355__auto__){
var self__ = this;
var this__5355__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5341__auto__,G__62696){
var self__ = this;
var this__5341__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__62696,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5347__auto__,entry__5348__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5348__auto__)){
return this__5347__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5347__auto____$1,entry__5348__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__5388__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__5388__auto__,writer__5389__auto__){
return cljs.core._write(writer__5389__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__62700){
var extmap__5384__auto__ = (function (){var G__62755 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__62700,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], 0));
if(cljs.core.record_QMARK_(G__62700)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__62755);
} else {
return G__62755;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__62700),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__62700),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__62700),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__62700),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__62700),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__62700),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__62700),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__62700),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__62700),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__62700),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__62700),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__62700),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__62700),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__62700),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__62700),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__62700),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__62700),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__62700),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__62700),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__62700),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__62700),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__62700),null,cljs.core.not_empty(extmap__5384__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__62761 = servers_STAR_;
var vec__62762 = G__62761;
var seq__62763 = cljs.core.seq(vec__62762);
var first__62764 = cljs.core.first(seq__62763);
var seq__62763__$1 = cljs.core.next(seq__62763);
var server = first__62764;
var r = seq__62763__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__62761__$1 = G__62761;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__62768 = G__62761__$1;
var seq__62769 = cljs.core.seq(vec__62768);
var first__62770 = cljs.core.first(seq__62769);
var seq__62769__$1 = cljs.core.next(seq__62769);
var server__$1 = first__62770;
var r__$1 = seq__62769__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__62771 = r__$1;
var G__62772 = is_https_QMARK_;
var G__62773 = result_STAR_;
G__62761__$1 = G__62771;
https_QMARK___$1 = G__62772;
result__$1 = G__62773;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__62774 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__62774 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__62774);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_62803){
var state_val_62804 = (state_62803[(1)]);
if((state_val_62804 === (7))){
var inst_62789 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62790 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62791 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62792 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62793 = fluree.db.connection.establish_socket(inst_62789,inst_62790,inst_62791,inst_62792);
var state_62803__$1 = state_62803;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62803__$1,(9),inst_62793);
} else {
if((state_val_62804 === (1))){
var state_62803__$1 = state_62803;
var statearr_62805_62824 = state_62803__$1;
(statearr_62805_62824[(2)] = null);

(statearr_62805_62824[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62804 === (4))){
var inst_62775 = (state_62803[(2)]);
var state_62803__$1 = state_62803;
var statearr_62806_62825 = state_62803__$1;
(statearr_62806_62825[(2)] = inst_62775);

(statearr_62806_62825[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62804 === (6))){
var inst_62786 = (state_62803[(7)]);
var state_62803__$1 = state_62803;
var statearr_62807_62826 = state_62803__$1;
(statearr_62807_62826[(2)] = inst_62786);

(statearr_62807_62826[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62804 === (3))){
var inst_62801 = (state_62803[(2)]);
var state_62803__$1 = state_62803;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62803__$1,inst_62801);
} else {
if((state_val_62804 === (2))){
var inst_62786 = (state_62803[(7)]);
var _ = (function (){var statearr_62809 = state_62803;
(statearr_62809[(4)] = cljs.core.cons((5),(state_62803[(4)])));

return statearr_62809;
})();
var inst_62781 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_62782 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62783 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62784 = [inst_62783,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_62785 = (new cljs.core.PersistentVector(null,3,(5),inst_62782,inst_62784,null));
var inst_62786__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62781,inst_62785);
var state_62803__$1 = (function (){var statearr_62810 = state_62803;
(statearr_62810[(7)] = inst_62786__$1);

return statearr_62810;
})();
if(cljs.core.truth_(inst_62786__$1)){
var statearr_62811_62827 = state_62803__$1;
(statearr_62811_62827[(1)] = (6));

} else {
var statearr_62812_62828 = state_62803__$1;
(statearr_62812_62828[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62804 === (9))){
var inst_62795 = (state_62803[(2)]);
var inst_62796 = fluree.db.util.async.throw_err(inst_62795);
var state_62803__$1 = state_62803;
var statearr_62813_62829 = state_62803__$1;
(statearr_62813_62829[(2)] = inst_62796);

(statearr_62813_62829[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62804 === (5))){
var _ = (function (){var statearr_62814 = state_62803;
(statearr_62814[(4)] = cljs.core.rest((state_62803[(4)])));

return statearr_62814;
})();
var state_62803__$1 = state_62803;
var ex62808 = (state_62803__$1[(2)]);
var statearr_62815_62830 = state_62803__$1;
(statearr_62815_62830[(5)] = ex62808);


if((ex62808 instanceof Error)){
var statearr_62816_62831 = state_62803__$1;
(statearr_62816_62831[(1)] = (4));

(statearr_62816_62831[(5)] = null);

} else {
throw ex62808;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62804 === (8))){
var inst_62798 = (state_62803[(2)]);
var _ = (function (){var statearr_62817 = state_62803;
(statearr_62817[(4)] = cljs.core.rest((state_62803[(4)])));

return statearr_62817;
})();
var state_62803__$1 = state_62803;
var statearr_62818_62832 = state_62803__$1;
(statearr_62818_62832[(2)] = inst_62798);

(statearr_62818_62832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2749__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2749__auto____0 = (function (){
var statearr_62819 = [null,null,null,null,null,null,null,null];
(statearr_62819[(0)] = fluree$db$connection$get_socket_$_state_machine__2749__auto__);

(statearr_62819[(1)] = (1));

return statearr_62819;
});
var fluree$db$connection$get_socket_$_state_machine__2749__auto____1 = (function (state_62803){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_62803);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e62820){var ex__2752__auto__ = e62820;
var statearr_62821_62833 = state_62803;
(statearr_62821_62833[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_62803[(4)]))){
var statearr_62822_62834 = state_62803;
(statearr_62822_62834[(1)] = cljs.core.first((state_62803[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62835 = state_62803;
state_62803 = G__62835;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2749__auto__ = function(state_62803){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2749__auto____1.call(this,state_62803);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2749__auto____0;
fluree$db$connection$get_socket_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2749__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_62823 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_62823[(6)] = c__2771__auto__);

return statearr_62823;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e62836){var e = e62836;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_62963){
var state_val_62964 = (state_62963[(1)]);
if((state_val_62964 === (7))){
var inst_62959 = (state_62963[(2)]);
var state_62963__$1 = state_62963;
var statearr_62966_63036 = state_62963__$1;
(statearr_62966_63036[(2)] = inst_62959);

(statearr_62966_63036[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (20))){
var _ = (function (){var statearr_62967 = state_62963;
(statearr_62967[(4)] = cljs.core.rest((state_62963[(4)])));

return statearr_62967;
})();
var state_62963__$1 = state_62963;
var ex62965 = (state_62963__$1[(2)]);
var statearr_62968_63037 = state_62963__$1;
(statearr_62968_63037[(5)] = ex62965);


var statearr_62969_63038 = state_62963__$1;
(statearr_62969_63038[(1)] = (10));

(statearr_62969_63038[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (27))){
var inst_62951 = (state_62963[(2)]);
var _ = (function (){var statearr_62970 = state_62963;
(statearr_62970[(4)] = cljs.core.rest((state_62963[(4)])));

return statearr_62970;
})();
var state_62963__$1 = state_62963;
var statearr_62971_63039 = state_62963__$1;
(statearr_62971_63039[(2)] = inst_62951);

(statearr_62971_63039[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (1))){
var inst_62838 = (0);
var state_62963__$1 = (function (){var statearr_62972 = state_62963;
(statearr_62972[(7)] = inst_62838);

return statearr_62972;
})();
var statearr_62973_63040 = state_62963__$1;
(statearr_62973_63040[(2)] = null);

(statearr_62973_63040[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (24))){
var inst_62929 = (state_62963[(8)]);
var inst_62929__$1 = (state_62963[(2)]);
var inst_62930 = inst_62929__$1 === true;
var state_62963__$1 = (function (){var statearr_62974 = state_62963;
(statearr_62974[(8)] = inst_62929__$1);

return statearr_62974;
})();
if(cljs.core.truth_(inst_62930)){
var statearr_62975_63041 = state_62963__$1;
(statearr_62975_63041[(1)] = (25));

} else {
var statearr_62976_63042 = state_62963__$1;
(statearr_62976_63042[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (4))){
var inst_62841 = (state_62963[(9)]);
var inst_62841__$1 = (state_62963[(2)]);
var state_62963__$1 = (function (){var statearr_62977 = state_62963;
(statearr_62977[(9)] = inst_62841__$1);

return statearr_62977;
})();
if(cljs.core.truth_(inst_62841__$1)){
var statearr_62978_63043 = state_62963__$1;
(statearr_62978_63043[(1)] = (5));

} else {
var statearr_62979_63044 = state_62963__$1;
(statearr_62979_63044[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (15))){
var inst_62854 = (state_62963[(10)]);
var state_62963__$1 = state_62963;
var statearr_62980_63045 = state_62963__$1;
(statearr_62980_63045[(2)] = inst_62854);

(statearr_62980_63045[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (21))){
var inst_62838 = (state_62963[(7)]);
var inst_62880 = (state_62963[(11)]);
var inst_62877 = (state_62963[(12)]);
var inst_62881 = (state_62963[(13)]);
var inst_62841 = (state_62963[(9)]);
var inst_62879 = (state_62963[(14)]);
var inst_62878 = (state_62963[(15)]);
var inst_62885 = (state_62963[(16)]);
var inst_62882 = (state_62963[(17)]);
var inst_62886 = (state_62963[(18)]);
var inst_62888 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62889 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_62885];
var inst_62890 = (new cljs.core.PersistentVector(null,2,(5),inst_62888,inst_62889,null));
var inst_62891 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_62890,inst_62880);
var inst_62918 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_62919 = (function (){var resp_chan = inst_62880;
var timeout = inst_62886;
var i = inst_62838;
var data = inst_62879;
var map__62876 = inst_62882;
var _ = inst_62877;
var vec__62873 = inst_62841;
var req_id = inst_62885;
var operation = inst_62878;
var msg = inst_62841;
var c__2771__auto____$1 = inst_62918;
var opts = inst_62881;
return (function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_62916){
var state_val_62917 = (state_62916[(1)]);
if((state_val_62917 === (1))){
var inst_62895 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62896 = cljs.core.async.timeout(timeout);
var inst_62897 = [resp_chan,inst_62896];
var inst_62898 = (new cljs.core.PersistentVector(null,2,(5),inst_62895,inst_62897,null));
var state_62916__$1 = state_62916;
return cljs.core.async.ioc_alts_BANG_(state_62916__$1,(2),inst_62898);
} else {
if((state_val_62917 === (2))){
var inst_62901 = (state_62916[(7)]);
var inst_62900 = (state_62916[(2)]);
var inst_62901__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62900,(0),null);
var inst_62902 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62900,(1),null);
var inst_62903 = (function (){var vec__62892 = inst_62900;
var resp = inst_62901__$1;
var c = inst_62902;
return (function (p1__62837_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__62837_SHARP_,req_id);
});
})();
var inst_62904 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_62903);
var inst_62905 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62902,resp_chan);
var state_62916__$1 = (function (){var statearr_62981 = state_62916;
(statearr_62981[(7)] = inst_62901__$1);

(statearr_62981[(8)] = inst_62904);

return statearr_62981;
})();
if(inst_62905){
var statearr_62982_63046 = state_62916__$1;
(statearr_62982_63046[(1)] = (3));

} else {
var statearr_62983_63047 = state_62916__$1;
(statearr_62983_63047[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62917 === (3))){
var inst_62901 = (state_62916[(7)]);
var state_62916__$1 = state_62916;
var statearr_62984_63048 = state_62916__$1;
(statearr_62984_63048[(2)] = inst_62901);

(statearr_62984_63048[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62917 === (4))){
var inst_62908 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_62909 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62910 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_62911 = cljs.core.PersistentHashMap.fromArrays(inst_62909,inst_62910);
var inst_62912 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_62908,inst_62911);
var state_62916__$1 = state_62916;
var statearr_62985_63049 = state_62916__$1;
(statearr_62985_63049[(2)] = inst_62912);

(statearr_62985_63049[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62917 === (5))){
var inst_62914 = (state_62916[(2)]);
var state_62916__$1 = state_62916;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62916__$1,inst_62914);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2749__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2749__auto____0 = (function (){
var statearr_62986 = [null,null,null,null,null,null,null,null,null];
(statearr_62986[(0)] = fluree$db$connection$msg_producer_$_state_machine__2749__auto__);

(statearr_62986[(1)] = (1));

return statearr_62986;
});
var fluree$db$connection$msg_producer_$_state_machine__2749__auto____1 = (function (state_62916){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_62916);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e62987){var ex__2752__auto__ = e62987;
var statearr_62988_63050 = state_62916;
(statearr_62988_63050[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_62916[(4)]))){
var statearr_62989_63051 = state_62916;
(statearr_62989_63051[(1)] = cljs.core.first((state_62916[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63052 = state_62916;
state_62916 = G__63052;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2749__auto__ = function(state_62916){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2749__auto____1.call(this,state_62916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2749__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2749__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_62990 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_62990[(6)] = c__2771__auto____$1);

return statearr_62990;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
});
})();
var inst_62920 = cljs.core.async.impl.dispatch.run(inst_62919);
var state_62963__$1 = (function (){var statearr_62991 = state_62963;
(statearr_62991[(19)] = inst_62891);

(statearr_62991[(20)] = inst_62920);

return statearr_62991;
})();
var statearr_62992_63053 = state_62963__$1;
(statearr_62992_63053[(2)] = inst_62918);

(statearr_62992_63053[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (31))){
var inst_62939 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_62963__$1 = state_62963;
var statearr_62993_63054 = state_62963__$1;
(statearr_62993_63054[(2)] = inst_62939);

(statearr_62993_63054[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (32))){
var state_62963__$1 = state_62963;
var statearr_62994_63055 = state_62963__$1;
(statearr_62994_63055[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (33))){
var inst_62947 = (state_62963[(2)]);
var state_62963__$1 = state_62963;
var statearr_62996_63056 = state_62963__$1;
(statearr_62996_63056[(2)] = inst_62947);

(statearr_62996_63056[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (13))){
var inst_62854 = (state_62963[(10)]);
var inst_62851 = (state_62963[(2)]);
var inst_62852 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62851,(0),null);
var inst_62853 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62851,(1),null);
var inst_62854__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62851,(2),null);
var state_62963__$1 = (function (){var statearr_62997 = state_62963;
(statearr_62997[(10)] = inst_62854__$1);

(statearr_62997[(21)] = inst_62853);

(statearr_62997[(22)] = inst_62852);

return statearr_62997;
})();
if(cljs.core.truth_(inst_62854__$1)){
var statearr_62998_63057 = state_62963__$1;
(statearr_62998_63057[(1)] = (14));

} else {
var statearr_62999_63058 = state_62963__$1;
(statearr_62999_63058[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (22))){
var state_62963__$1 = state_62963;
var statearr_63000_63059 = state_62963__$1;
(statearr_63000_63059[(2)] = null);

(statearr_63000_63059[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (36))){
var inst_62945 = (state_62963[(2)]);
var state_62963__$1 = state_62963;
var statearr_63001_63060 = state_62963__$1;
(statearr_63001_63060[(2)] = inst_62945);

(statearr_63001_63060[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (29))){
var inst_62929 = (state_62963[(8)]);
var inst_62937 = (inst_62929 == null);
var state_62963__$1 = state_62963;
if(cljs.core.truth_(inst_62937)){
var statearr_63002_63061 = state_62963__$1;
(statearr_63002_63061[(1)] = (31));

} else {
var statearr_63003_63062 = state_62963__$1;
(statearr_63003_63062[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (6))){
var state_62963__$1 = state_62963;
var statearr_63004_63063 = state_62963__$1;
(statearr_63004_63063[(2)] = null);

(statearr_63004_63063[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (28))){
var inst_62929 = (state_62963[(8)]);
var inst_62935 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62929,"Error processing message in producer."], 0));
var state_62963__$1 = state_62963;
var statearr_63005_63064 = state_62963__$1;
(statearr_63005_63064[(2)] = inst_62935);

(statearr_63005_63064[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (25))){
var state_62963__$1 = state_62963;
var statearr_63006_63065 = state_62963__$1;
(statearr_63006_63065[(2)] = null);

(statearr_63006_63065[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (34))){
var inst_62929 = (state_62963[(8)]);
var inst_62942 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_62929], 0));
var state_62963__$1 = state_62963;
var statearr_63007_63066 = state_62963__$1;
(statearr_63007_63066[(2)] = inst_62942);

(statearr_63007_63066[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (17))){
var inst_62854 = (state_62963[(10)]);
var inst_62843 = (state_62963[(23)]);
var inst_62861 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62854,inst_62843);
var state_62963__$1 = state_62963;
var statearr_63008_63067 = state_62963__$1;
(statearr_63008_63067[(2)] = inst_62861);

(statearr_63008_63067[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (3))){
var inst_62961 = (state_62963[(2)]);
var state_62963__$1 = state_62963;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62963__$1,inst_62961);
} else {
if((state_val_62964 === (12))){
var state_62963__$1 = state_62963;
var statearr_63009_63068 = state_62963__$1;
(statearr_63009_63068[(2)] = null);

(statearr_63009_63068[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (2))){
var state_62963__$1 = state_62963;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62963__$1,(4),req_chan);
} else {
if((state_val_62964 === (23))){
var inst_62879 = (state_62963[(14)]);
var inst_62878 = (state_62963[(15)]);
var inst_62885 = (state_62963[(16)]);
var inst_62923 = (state_62963[(2)]);
var inst_62924 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62925 = [inst_62878,inst_62885,inst_62879];
var inst_62926 = (new cljs.core.PersistentVector(null,3,(5),inst_62924,inst_62925,null));
var inst_62927 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_62926) : publish_fn.call(null,conn,inst_62926));
var state_62963__$1 = (function (){var statearr_63010 = state_62963;
(statearr_63010[(24)] = inst_62923);

return statearr_63010;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62963__$1,(24),inst_62927);
} else {
if((state_val_62964 === (35))){
var state_62963__$1 = state_62963;
var statearr_63011_63069 = state_62963__$1;
(statearr_63011_63069[(2)] = null);

(statearr_63011_63069[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (19))){
var inst_62867 = (state_62963[(2)]);
var state_62963__$1 = state_62963;
var statearr_63012_63070 = state_62963__$1;
(statearr_63012_63070[(2)] = inst_62867);

(statearr_63012_63070[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (11))){
var inst_62841 = (state_62963[(9)]);
var state_62963__$1 = state_62963;
var statearr_63013_63071 = state_62963__$1;
(statearr_63013_63071[(2)] = inst_62841);

(statearr_63013_63071[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (9))){
var inst_62838 = (state_62963[(7)]);
var inst_62954 = (state_62963[(2)]);
var inst_62955 = (inst_62838 + (1));
var inst_62838__$1 = inst_62955;
var state_62963__$1 = (function (){var statearr_63014 = state_62963;
(statearr_63014[(7)] = inst_62838__$1);

(statearr_63014[(25)] = inst_62954);

return statearr_63014;
})();
var statearr_63015_63072 = state_62963__$1;
(statearr_63015_63072[(2)] = null);

(statearr_63015_63072[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (5))){
var state_62963__$1 = state_62963;
var statearr_63016_63073 = state_62963__$1;
(statearr_63016_63073[(2)] = null);

(statearr_63016_63073[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (14))){
var inst_62854 = (state_62963[(10)]);
var inst_62856 = fluree.db.util.async.channel_QMARK_(inst_62854);
var state_62963__$1 = state_62963;
var statearr_63017_63074 = state_62963__$1;
(statearr_63017_63074[(2)] = inst_62856);

(statearr_63017_63074[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (26))){
var inst_62929 = (state_62963[(8)]);
var inst_62933 = fluree.db.util.core.exception_QMARK_(inst_62929);
var state_62963__$1 = state_62963;
if(inst_62933){
var statearr_63018_63075 = state_62963__$1;
(statearr_63018_63075[(1)] = (28));

} else {
var statearr_63019_63076 = state_62963__$1;
(statearr_63019_63076[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (16))){
var inst_62859 = (state_62963[(2)]);
var state_62963__$1 = state_62963;
if(cljs.core.truth_(inst_62859)){
var statearr_63020_63077 = state_62963__$1;
(statearr_63020_63077[(1)] = (17));

} else {
var statearr_63021_63078 = state_62963__$1;
(statearr_63021_63078[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (30))){
var inst_62949 = (state_62963[(2)]);
var state_62963__$1 = state_62963;
var statearr_63022_63079 = state_62963__$1;
(statearr_63022_63079[(2)] = inst_62949);

(statearr_63022_63079[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (10))){
var inst_62841 = (state_62963[(9)]);
var inst_62843 = (state_62963[(2)]);
var inst_62847 = cljs.core.sequential_QMARK_(inst_62841);
var state_62963__$1 = (function (){var statearr_63023 = state_62963;
(statearr_63023[(23)] = inst_62843);

return statearr_63023;
})();
if(inst_62847){
var statearr_63024_63080 = state_62963__$1;
(statearr_63024_63080[(1)] = (11));

} else {
var statearr_63025_63081 = state_62963__$1;
(statearr_63025_63081[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (18))){
var inst_62841 = (state_62963[(9)]);
var inst_62843 = (state_62963[(23)]);
var inst_62863 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62841], 0));
var inst_62864 = ["Error processing ledger request, no valid return channel: ",inst_62863].join('');
var inst_62865 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62843,inst_62864], 0));
var state_62963__$1 = state_62963;
var statearr_63026_63082 = state_62963__$1;
(statearr_63026_63082[(2)] = inst_62865);

(statearr_63026_63082[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62964 === (8))){
var inst_62880 = (state_62963[(11)]);
var inst_62881 = (state_62963[(13)]);
var inst_62841 = (state_62963[(9)]);
var inst_62882 = (state_62963[(17)]);
var _ = (function (){var statearr_63027 = state_62963;
(statearr_63027[(4)] = cljs.core.cons((20),(state_62963[(4)])));

return statearr_63027;
})();
var inst_62877 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_62841], 0));
var inst_62878 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62841,(0),null);
var inst_62879 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62841,(1),null);
var inst_62880__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62841,(2),null);
var inst_62881__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62841,(3),null);
var inst_62882__$1 = cljs.core.__destructure_map(inst_62881__$1);
var inst_62883 = fluree.db.util.core.random_uuid();
var inst_62884 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62883);
var inst_62885 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_62882__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_62884);
var inst_62886 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_62882__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_62963__$1 = (function (){var statearr_63028 = state_62963;
(statearr_63028[(11)] = inst_62880__$1);

(statearr_63028[(12)] = inst_62877);

(statearr_63028[(13)] = inst_62881__$1);

(statearr_63028[(14)] = inst_62879);

(statearr_63028[(15)] = inst_62878);

(statearr_63028[(16)] = inst_62885);

(statearr_63028[(17)] = inst_62882__$1);

(statearr_63028[(18)] = inst_62886);

return statearr_63028;
})();
if(cljs.core.truth_(inst_62880__$1)){
var statearr_63029_63083 = state_62963__$1;
(statearr_63029_63083[(1)] = (21));

} else {
var statearr_63030_63084 = state_62963__$1;
(statearr_63030_63084[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2749__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2749__auto____0 = (function (){
var statearr_63031 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63031[(0)] = fluree$db$connection$msg_producer_$_state_machine__2749__auto__);

(statearr_63031[(1)] = (1));

return statearr_63031;
});
var fluree$db$connection$msg_producer_$_state_machine__2749__auto____1 = (function (state_62963){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_62963);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e63032){var ex__2752__auto__ = e63032;
var statearr_63033_63085 = state_62963;
(statearr_63033_63085[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_62963[(4)]))){
var statearr_63034_63086 = state_62963;
(statearr_63034_63086[(1)] = cljs.core.first((state_62963[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63087 = state_62963;
state_62963 = G__63087;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2749__auto__ = function(state_62963){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2749__auto____1.call(this,state_62963);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2749__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2749__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_63035 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_63035[(6)] = c__2771__auto__);

return statearr_63035;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__63088 = conn;
var map__63088__$1 = cljs.core.__destructure_map(map__63088);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63088__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_63173){
var state_val_63174 = (state_63173[(1)]);
if((state_val_63174 === (7))){
var inst_63169 = (state_63173[(2)]);
var state_63173__$1 = state_63173;
var statearr_63175_63226 = state_63173__$1;
(statearr_63175_63226[(2)] = inst_63169);

(statearr_63175_63226[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (20))){
var inst_63107 = (state_63173[(7)]);
var inst_63121 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_63122 = [inst_63107];
var inst_63123 = cljs.core.PersistentHashMap.fromArrays(inst_63121,inst_63122);
var inst_63124 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_63123], 0));
var state_63173__$1 = state_63173;
var statearr_63176_63227 = state_63173__$1;
(statearr_63176_63227[(2)] = inst_63124);

(statearr_63176_63227[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (27))){
var state_63173__$1 = state_63173;
var statearr_63177_63228 = state_63173__$1;
(statearr_63177_63228[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (1))){
var inst_63089 = (0);
var state_63173__$1 = (function (){var statearr_63179 = state_63173;
(statearr_63179[(8)] = inst_63089);

return statearr_63179;
})();
var statearr_63180_63229 = state_63173__$1;
(statearr_63180_63229[(2)] = null);

(statearr_63180_63229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (24))){
var inst_63100 = (state_63173[(9)]);
var inst_63149 = fluree.db.util.core.exception_QMARK_(inst_63100);
var state_63173__$1 = state_63173;
if(inst_63149){
var statearr_63181_63230 = state_63173__$1;
(statearr_63181_63230[(1)] = (26));

} else {
var statearr_63182_63231 = state_63173__$1;
(statearr_63182_63231[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (4))){
var inst_63094 = (state_63173[(10)]);
var inst_63099 = (state_63173[(2)]);
var inst_63100 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63099,(0),null);
var inst_63101 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63099,(1),null);
var inst_63102 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_63101,inst_63094);
var state_63173__$1 = (function (){var statearr_63183 = state_63173;
(statearr_63183[(9)] = inst_63100);

return statearr_63183;
})();
if(inst_63102){
var statearr_63184_63232 = state_63173__$1;
(statearr_63184_63232[(1)] = (5));

} else {
var statearr_63185_63233 = state_63173__$1;
(statearr_63185_63233[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (15))){
var inst_63107 = (state_63173[(7)]);
var inst_63116 = typeof inst_63107 === 'string';
var state_63173__$1 = state_63173;
if(cljs.core.truth_(inst_63116)){
var statearr_63186_63234 = state_63173__$1;
(statearr_63186_63234[(1)] = (17));

} else {
var statearr_63187_63235 = state_63173__$1;
(statearr_63187_63235[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (21))){
var state_63173__$1 = state_63173;
var statearr_63188_63236 = state_63173__$1;
(statearr_63188_63236[(2)] = null);

(statearr_63188_63236[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (31))){
var inst_63163 = (state_63173[(2)]);
var state_63173__$1 = state_63173;
var statearr_63189_63237 = state_63173__$1;
(statearr_63189_63237[(2)] = inst_63163);

(statearr_63189_63237[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (13))){
var inst_63133 = (state_63173[(2)]);
var inst_63134 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63135 = fluree.db.connection.close_websocket(inst_63134);
var inst_63136 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63137 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_63136);
var state_63173__$1 = (function (){var statearr_63190 = state_63173;
(statearr_63190[(11)] = inst_63133);

(statearr_63190[(12)] = inst_63135);

return statearr_63190;
})();
var statearr_63191_63238 = state_63173__$1;
(statearr_63191_63238[(2)] = inst_63137);

(statearr_63191_63238[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (22))){
var inst_63127 = (state_63173[(2)]);
var state_63173__$1 = state_63173;
var statearr_63192_63239 = state_63173__$1;
(statearr_63192_63239[(2)] = inst_63127);

(statearr_63192_63239[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (29))){
var inst_63100 = (state_63173[(9)]);
var inst_63155 = fluree.db.util.json.parse(inst_63100);
var inst_63156 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63155], 0));
var inst_63157 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Received message:",inst_63156], 0));
var inst_63158 = fluree.db.util.json.parse(inst_63100);
var inst_63159 = fluree.db.conn_events.process_events(conn,inst_63158);
var inst_63089 = (0);
var state_63173__$1 = (function (){var statearr_63193 = state_63173;
(statearr_63193[(8)] = inst_63089);

(statearr_63193[(13)] = inst_63159);

(statearr_63193[(14)] = inst_63157);

return statearr_63193;
})();
var statearr_63194_63240 = state_63173__$1;
(statearr_63194_63240[(2)] = null);

(statearr_63194_63240[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (6))){
var inst_63100 = (state_63173[(9)]);
var inst_63145 = (inst_63100 == null);
var state_63173__$1 = state_63173;
if(cljs.core.truth_(inst_63145)){
var statearr_63195_63241 = state_63173__$1;
(statearr_63195_63241[(1)] = (23));

} else {
var statearr_63196_63242 = state_63173__$1;
(statearr_63196_63242[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (28))){
var inst_63165 = (state_63173[(2)]);
var state_63173__$1 = state_63173;
var statearr_63197_63243 = state_63173__$1;
(statearr_63197_63243[(2)] = inst_63165);

(statearr_63197_63243[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (25))){
var inst_63167 = (state_63173[(2)]);
var state_63173__$1 = state_63173;
var statearr_63198_63244 = state_63173__$1;
(statearr_63198_63244[(2)] = inst_63167);

(statearr_63198_63244[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (17))){
var inst_63107 = (state_63173[(7)]);
var inst_63118 = cljs.core.eval(inst_63107);
var state_63173__$1 = state_63173;
var statearr_63199_63245 = state_63173__$1;
(statearr_63199_63245[(2)] = inst_63118);

(statearr_63199_63245[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (3))){
var inst_63171 = (state_63173[(2)]);
var state_63173__$1 = state_63173;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63173__$1,inst_63171);
} else {
if((state_val_63174 === (12))){
var inst_63107 = (state_63173[(7)]);
var inst_63112 = cljs.core.fn_QMARK_(inst_63107);
var state_63173__$1 = state_63173;
if(inst_63112){
var statearr_63200_63246 = state_63173__$1;
(statearr_63200_63246[(1)] = (14));

} else {
var statearr_63201_63247 = state_63173__$1;
(statearr_63201_63247[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (2))){
var inst_63094 = (state_63173[(10)]);
var inst_63094__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_63095 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63096 = [sub_chan,inst_63094__$1];
var inst_63097 = (new cljs.core.PersistentVector(null,2,(5),inst_63095,inst_63096,null));
var state_63173__$1 = (function (){var statearr_63202 = state_63173;
(statearr_63202[(10)] = inst_63094__$1);

return statearr_63202;
})();
return cljs.core.async.ioc_alts_BANG_(state_63173__$1,(4),inst_63097);
} else {
if((state_val_63174 === (23))){
var inst_63147 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_63173__$1 = state_63173;
var statearr_63203_63248 = state_63173__$1;
(statearr_63203_63248[(2)] = inst_63147);

(statearr_63203_63248[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (19))){
var inst_63129 = (state_63173[(2)]);
var state_63173__$1 = state_63173;
var statearr_63204_63249 = state_63173__$1;
(statearr_63204_63249[(2)] = inst_63129);

(statearr_63204_63249[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (11))){
var inst_63110 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_63173__$1 = state_63173;
var statearr_63205_63250 = state_63173__$1;
(statearr_63205_63250[(2)] = inst_63110);

(statearr_63205_63250[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (9))){
var inst_63089 = (state_63173[(8)]);
var inst_63139 = fluree.db.connection.ping_transactor(conn);
var inst_63140 = (inst_63089 + (1));
var inst_63089__$1 = inst_63140;
var state_63173__$1 = (function (){var statearr_63206 = state_63173;
(statearr_63206[(8)] = inst_63089__$1);

(statearr_63206[(15)] = inst_63139);

return statearr_63206;
})();
var statearr_63207_63251 = state_63173__$1;
(statearr_63207_63251[(2)] = null);

(statearr_63207_63251[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (5))){
var inst_63089 = (state_63173[(8)]);
var inst_63104 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_63089);
var state_63173__$1 = state_63173;
if(inst_63104){
var statearr_63208_63252 = state_63173__$1;
(statearr_63208_63252[(1)] = (8));

} else {
var statearr_63209_63253 = state_63173__$1;
(statearr_63209_63253[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (14))){
var inst_63107 = (state_63173[(7)]);
var inst_63114 = (inst_63107.cljs$core$IFn$_invoke$arity$0 ? inst_63107.cljs$core$IFn$_invoke$arity$0() : inst_63107.call(null));
var state_63173__$1 = state_63173;
var statearr_63210_63254 = state_63173__$1;
(statearr_63210_63254[(2)] = inst_63114);

(statearr_63210_63254[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (26))){
var inst_63100 = (state_63173[(9)]);
var inst_63151 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63100], 0));
var inst_63089 = (0);
var state_63173__$1 = (function (){var statearr_63211 = state_63173;
(statearr_63211[(8)] = inst_63089);

(statearr_63211[(16)] = inst_63151);

return statearr_63211;
})();
var statearr_63212_63255 = state_63173__$1;
(statearr_63212_63255[(2)] = null);

(statearr_63212_63255[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (16))){
var inst_63131 = (state_63173[(2)]);
var state_63173__$1 = state_63173;
var statearr_63213_63256 = state_63173__$1;
(statearr_63213_63256[(2)] = inst_63131);

(statearr_63213_63256[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (30))){
var state_63173__$1 = state_63173;
var statearr_63214_63257 = state_63173__$1;
(statearr_63214_63257[(2)] = null);

(statearr_63214_63257[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (10))){
var inst_63143 = (state_63173[(2)]);
var state_63173__$1 = state_63173;
var statearr_63215_63258 = state_63173__$1;
(statearr_63215_63258[(2)] = inst_63143);

(statearr_63215_63258[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (18))){
var state_63173__$1 = state_63173;
var statearr_63216_63259 = state_63173__$1;
(statearr_63216_63259[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63174 === (8))){
var inst_63107 = (state_63173[(7)]);
var inst_63106 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_63107__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63108 = (inst_63107__$1 == null);
var state_63173__$1 = (function (){var statearr_63218 = state_63173;
(statearr_63218[(7)] = inst_63107__$1);

(statearr_63218[(17)] = inst_63106);

return statearr_63218;
})();
if(cljs.core.truth_(inst_63108)){
var statearr_63219_63260 = state_63173__$1;
(statearr_63219_63260[(1)] = (11));

} else {
var statearr_63220_63261 = state_63173__$1;
(statearr_63220_63261[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2749__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2749__auto____0 = (function (){
var statearr_63221 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63221[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2749__auto__);

(statearr_63221[(1)] = (1));

return statearr_63221;
});
var fluree$db$connection$msg_consumer_$_state_machine__2749__auto____1 = (function (state_63173){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_63173);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e63222){var ex__2752__auto__ = e63222;
var statearr_63223_63262 = state_63173;
(statearr_63223_63262[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_63173[(4)]))){
var statearr_63224_63263 = state_63173;
(statearr_63224_63263[(1)] = cljs.core.first((state_63173[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63264 = state_63173;
state_63173 = G__63264;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2749__auto__ = function(state_63173){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2749__auto____1.call(this,state_63173);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2749__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2749__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_63225 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_63225[(6)] = c__2771__auto__);

return statearr_63225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__63266 = arguments.length;
switch (G__63266) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__63267 = opts;
var map__63267__$1 = cljs.core.__destructure_map(map__63267);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63267__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63267__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_63319){
var state_val_63320 = (state_63319[(1)]);
if((state_val_63320 === (7))){
var inst_63277 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_63278 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63279 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_63280 = (new cljs.core.PersistentVector(null,2,(5),inst_63278,inst_63279,null));
var inst_63281 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_63277,inst_63280);
var state_63319__$1 = state_63319;
var statearr_63321_63352 = state_63319__$1;
(statearr_63321_63352[(2)] = inst_63281);

(statearr_63321_63352[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63320 === (1))){
var state_63319__$1 = state_63319;
var statearr_63322_63353 = state_63319__$1;
(statearr_63322_63353[(2)] = null);

(statearr_63322_63353[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63320 === (4))){
var inst_63268 = (state_63319[(2)]);
var state_63319__$1 = state_63319;
var statearr_63323_63354 = state_63319__$1;
(statearr_63323_63354[(2)] = inst_63268);

(statearr_63323_63354[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63320 === (15))){
var inst_63288 = (state_63319[(7)]);
var inst_63307 = (state_63319[(2)]);
var inst_63308 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_63309 = [(5000),inst_63307,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_63310 = cljs.core.PersistentHashMap.fromArrays(inst_63308,inst_63309);
var inst_63311 = fluree.db.util.xhttp.get(inst_63288,inst_63310);
var state_63319__$1 = state_63319;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63319__$1,(16),inst_63311);
} else {
if((state_val_63320 === (13))){
var inst_63288 = (state_63319[(7)]);
var inst_63298 = (state_63319[(8)]);
var inst_63300 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_63301 = [inst_63298];
var inst_63302 = cljs.core.PersistentHashMap.fromArrays(inst_63300,inst_63301);
var inst_63303 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_63288,inst_63302,private$);
var inst_63304 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_63303);
var state_63319__$1 = state_63319;
var statearr_63324_63355 = state_63319__$1;
(statearr_63324_63355[(2)] = inst_63304);

(statearr_63324_63355[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63320 === (6))){
var inst_63274 = (state_63319[(9)]);
var state_63319__$1 = state_63319;
var statearr_63325_63356 = state_63319__$1;
(statearr_63325_63356[(2)] = inst_63274);

(statearr_63325_63356[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63320 === (3))){
var inst_63317 = (state_63319[(2)]);
var state_63319__$1 = state_63319;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63319__$1,inst_63317);
} else {
if((state_val_63320 === (12))){
var inst_63298 = (state_63319[(2)]);
var state_63319__$1 = (function (){var statearr_63326 = state_63319;
(statearr_63326[(8)] = inst_63298);

return statearr_63326;
})();
if(cljs.core.truth_(private$)){
var statearr_63327_63357 = state_63319__$1;
(statearr_63327_63357[(1)] = (13));

} else {
var statearr_63328_63358 = state_63319__$1;
(statearr_63328_63358[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63320 === (2))){
var inst_63274 = (state_63319[(9)]);
var _ = (function (){var statearr_63329 = state_63319;
(statearr_63329[(4)] = cljs.core.cons((5),(state_63319[(4)])));

return statearr_63329;
})();
var inst_63274__$1 = jwt;
var state_63319__$1 = (function (){var statearr_63330 = state_63319;
(statearr_63330[(9)] = inst_63274__$1);

return statearr_63330;
})();
if(cljs.core.truth_(inst_63274__$1)){
var statearr_63331_63359 = state_63319__$1;
(statearr_63331_63359[(1)] = (6));

} else {
var statearr_63332_63360 = state_63319__$1;
(statearr_63332_63360[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63320 === (11))){
var inst_63292 = (state_63319[(10)]);
var state_63319__$1 = state_63319;
var statearr_63334_63361 = state_63319__$1;
(statearr_63334_63361[(2)] = inst_63292);

(statearr_63334_63361[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63320 === (9))){
var inst_63284 = (state_63319[(11)]);
var inst_63283 = (state_63319[(12)]);
var inst_63287 = (state_63319[(2)]);
var inst_63288 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63287),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63284)].join('');
var inst_63290 = ["Accept"];
var inst_63291 = ["application/json"];
var inst_63292 = cljs.core.PersistentHashMap.fromArrays(inst_63290,inst_63291);
var state_63319__$1 = (function (){var statearr_63335 = state_63319;
(statearr_63335[(10)] = inst_63292);

(statearr_63335[(7)] = inst_63288);

return statearr_63335;
})();
if(cljs.core.truth_(inst_63283)){
var statearr_63336_63362 = state_63319__$1;
(statearr_63336_63362[(1)] = (10));

} else {
var statearr_63337_63363 = state_63319__$1;
(statearr_63337_63363[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63320 === (5))){
var _ = (function (){var statearr_63338 = state_63319;
(statearr_63338[(4)] = cljs.core.rest((state_63319[(4)])));

return statearr_63338;
})();
var state_63319__$1 = state_63319;
var ex63333 = (state_63319__$1[(2)]);
var statearr_63339_63364 = state_63319__$1;
(statearr_63339_63364[(5)] = ex63333);


if((ex63333 instanceof Error)){
var statearr_63340_63365 = state_63319__$1;
(statearr_63340_63365[(1)] = (4));

(statearr_63340_63365[(5)] = null);

} else {
throw ex63333;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63320 === (14))){
var inst_63298 = (state_63319[(8)]);
var state_63319__$1 = state_63319;
var statearr_63341_63366 = state_63319__$1;
(statearr_63341_63366[(2)] = inst_63298);

(statearr_63341_63366[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63320 === (16))){
var inst_63313 = (state_63319[(2)]);
var inst_63314 = fluree.db.util.async.throw_err(inst_63313);
var _ = (function (){var statearr_63342 = state_63319;
(statearr_63342[(4)] = cljs.core.rest((state_63319[(4)])));

return statearr_63342;
})();
var state_63319__$1 = state_63319;
var statearr_63343_63367 = state_63319__$1;
(statearr_63343_63367[(2)] = inst_63314);

(statearr_63343_63367[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63320 === (10))){
var inst_63292 = (state_63319[(10)]);
var inst_63283 = (state_63319[(12)]);
var inst_63294 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63283)].join('');
var inst_63295 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_63292,"Authorization",inst_63294);
var state_63319__$1 = state_63319;
var statearr_63344_63368 = state_63319__$1;
(statearr_63344_63368[(2)] = inst_63295);

(statearr_63344_63368[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63320 === (8))){
var inst_63283 = (state_63319[(2)]);
var inst_63284 = clojure.string.replace(k,"_","/");
var inst_63285 = fluree.db.connection.get_server(conn_id,servers);
var state_63319__$1 = (function (){var statearr_63345 = state_63319;
(statearr_63345[(11)] = inst_63284);

(statearr_63345[(12)] = inst_63283);

return statearr_63345;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63319__$1,(9),inst_63285);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2749__auto__ = null;
var fluree$db$connection$state_machine__2749__auto____0 = (function (){
var statearr_63346 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63346[(0)] = fluree$db$connection$state_machine__2749__auto__);

(statearr_63346[(1)] = (1));

return statearr_63346;
});
var fluree$db$connection$state_machine__2749__auto____1 = (function (state_63319){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_63319);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e63347){var ex__2752__auto__ = e63347;
var statearr_63348_63369 = state_63319;
(statearr_63348_63369[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_63319[(4)]))){
var statearr_63349_63370 = state_63319;
(statearr_63349_63370[(1)] = cljs.core.first((state_63319[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63371 = state_63319;
state_63319 = G__63371;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2749__auto__ = function(state_63319){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2749__auto____1.call(this,state_63319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2749__auto____0;
fluree$db$connection$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2749__auto____1;
return fluree$db$connection$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_63350 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_63350[(6)] = c__2771__auto__);

return statearr_63350;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5802__auto__)){
var v = temp__5802__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__63372_SHARP_){
if(cljs.core.truth_(p1__63372_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__63373_SHARP_){
var or__5045__auto__ = p1__63373_SHARP_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return token;
}
}));

return true;
}catch (e63374){var e = e63374;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__63375 = opts;
var map__63375__$1 = cljs.core.__destructure_map(map__63375);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63375__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63375__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63375__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63375__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63375__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63375__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63375__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63375__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63375__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63375__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63375__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63375__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63375__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63375__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63375__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63375__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63375__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63375__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63375__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63375__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63375__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63375__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63375__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63375__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__5045__auto__ = object_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache();
} else {
}

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356)], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__5045__auto__ = storage_read;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__5045__auto__ = storage_exists;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = storage_read;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__5043__auto__ = storage_write;
if(cljs.core.truth_(and__5043__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__63376_63377 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__63376_63377.cljs$core$IFn$_invoke$arity$0 ? fexpr__63376_63377.cljs$core$IFn$_invoke$arity$0() : fexpr__63376_63377.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__5774__auto__ = [];
var len__5768__auto___63418 = arguments.length;
var i__5769__auto___63419 = (0);
while(true){
if((i__5769__auto___63419 < len__5768__auto___63418)){
args__5774__auto__.push((arguments[i__5769__auto___63419]));

var G__63420 = (i__5769__auto___63419 + (1));
i__5769__auto___63419 = G__63420;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__63380){
var vec__63381 = p__63380;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63381,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2771__auto___63421 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_63401){
var state_val_63402 = (state_63401[(1)]);
if((state_val_63402 === (1))){
var inst_63384 = fluree.db.connection.get_socket(conn);
var state_63401__$1 = state_63401;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63401__$1,(2),inst_63384);
} else {
if((state_val_63402 === (2))){
var inst_63387 = (state_63401[(7)]);
var inst_63386 = (state_63401[(8)]);
var inst_63386__$1 = (state_63401[(2)]);
var inst_63387__$1 = (inst_63386__$1 == null);
var state_63401__$1 = (function (){var statearr_63403 = state_63401;
(statearr_63403[(7)] = inst_63387__$1);

(statearr_63403[(8)] = inst_63386__$1);

return statearr_63403;
})();
if(cljs.core.truth_(inst_63387__$1)){
var statearr_63404_63422 = state_63401__$1;
(statearr_63404_63422[(1)] = (3));

} else {
var statearr_63405_63423 = state_63401__$1;
(statearr_63405_63423[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63402 === (3))){
var inst_63387 = (state_63401[(7)]);
var state_63401__$1 = state_63401;
var statearr_63406_63424 = state_63401__$1;
(statearr_63406_63424[(2)] = inst_63387);

(statearr_63406_63424[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63402 === (4))){
var inst_63386 = (state_63401[(8)]);
var inst_63390 = fluree.db.util.core.exception_QMARK_(inst_63386);
var state_63401__$1 = state_63401;
var statearr_63407_63425 = state_63401__$1;
(statearr_63407_63425[(2)] = inst_63390);

(statearr_63407_63425[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63402 === (5))){
var inst_63392 = (state_63401[(2)]);
var state_63401__$1 = state_63401;
if(cljs.core.truth_(inst_63392)){
var statearr_63408_63426 = state_63401__$1;
(statearr_63408_63426[(1)] = (6));

} else {
var statearr_63409_63427 = state_63401__$1;
(statearr_63409_63427[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63402 === (6))){
var inst_63386 = (state_63401[(8)]);
var inst_63394 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63386,"Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_63395 = cljs.core.async.close_BANG_(conn);
var state_63401__$1 = (function (){var statearr_63410 = state_63401;
(statearr_63410[(9)] = inst_63394);

return statearr_63410;
})();
var statearr_63411_63428 = state_63401__$1;
(statearr_63411_63428[(2)] = inst_63395);

(statearr_63411_63428[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63402 === (7))){
var inst_63397 = fluree.db.connection.msg_consumer(conn);
var state_63401__$1 = state_63401;
var statearr_63412_63429 = state_63401__$1;
(statearr_63412_63429[(2)] = inst_63397);

(statearr_63412_63429[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63402 === (8))){
var inst_63399 = (state_63401[(2)]);
var state_63401__$1 = state_63401;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63401__$1,inst_63399);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2749__auto__ = null;
var fluree$db$connection$state_machine__2749__auto____0 = (function (){
var statearr_63413 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63413[(0)] = fluree$db$connection$state_machine__2749__auto__);

(statearr_63413[(1)] = (1));

return statearr_63413;
});
var fluree$db$connection$state_machine__2749__auto____1 = (function (state_63401){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_63401);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e63414){var ex__2752__auto__ = e63414;
var statearr_63415_63430 = state_63401;
(statearr_63415_63430[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_63401[(4)]))){
var statearr_63416_63431 = state_63401;
(statearr_63416_63431[(1)] = cljs.core.first((state_63401[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63432 = state_63401;
state_63401 = G__63432;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2749__auto__ = function(state_63401){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2749__auto____1.call(this,state_63401);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2749__auto____0;
fluree$db$connection$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2749__auto____1;
return fluree$db$connection$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_63417 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_63417[(6)] = c__2771__auto___63421);

return statearr_63417;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq63378){
var G__63379 = cljs.core.first(seq63378);
var seq63378__$1 = cljs.core.next(seq63378);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63379,seq63378__$1);
}));

