// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__5823__auto___54084 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_54135){
var state_val_54136 = (state_54135[(1)]);
if((state_val_54136 === (7))){
var inst_54130 = (state_54135[(2)]);
var _ = (function (){var statearr_54137 = state_54135;
(statearr_54137[(4)] = cljs.core.rest((state_54135[(4)])));

return statearr_54137;
})();
var state_54135__$1 = state_54135;
var statearr_54138_54165 = state_54135__$1;
(statearr_54138_54165[(2)] = inst_54130);

(statearr_54138_54165[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54136 === (1))){
var state_54135__$1 = state_54135;
var statearr_54139_54166 = state_54135__$1;
(statearr_54139_54166[(2)] = null);

(statearr_54139_54166[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54136 === (4))){
var inst_54085 = (state_54135[(2)]);
var state_54135__$1 = state_54135;
var statearr_54140_54167 = state_54135__$1;
(statearr_54140_54167[(2)] = inst_54085);

(statearr_54140_54167[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54136 === (13))){
var inst_54126 = (state_54135[(2)]);
var state_54135__$1 = state_54135;
var statearr_54141_54168 = state_54135__$1;
(statearr_54141_54168[(2)] = inst_54126);

(statearr_54141_54168[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54136 === (6))){
var inst_54103 = (state_54135[(7)]);
var inst_54110 = (state_54135[(8)]);
var inst_54109 = cljs.core.seq(inst_54103);
var inst_54110__$1 = cljs.core.first(inst_54109);
var inst_54111 = cljs.core.next(inst_54109);
var inst_54112 = cljs.core.not(inst_54110__$1);
var state_54135__$1 = (function (){var statearr_54142 = state_54135;
(statearr_54142[(9)] = inst_54111);

(statearr_54142[(8)] = inst_54110__$1);

return statearr_54142;
})();
if(inst_54112){
var statearr_54143_54169 = state_54135__$1;
(statearr_54143_54169[(1)] = (8));

} else {
var statearr_54144_54170 = state_54135__$1;
(statearr_54144_54170[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54136 === (3))){
var inst_54133 = (state_54135[(2)]);
var state_54135__$1 = state_54135;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54135__$1,inst_54133);
} else {
if((state_val_54136 === (12))){
var inst_54104 = (state_54135[(10)]);
var inst_54111 = (state_54135[(9)]);
var inst_54110 = (state_54135[(8)]);
var inst_54123 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_54104,inst_54110);
var inst_54103 = inst_54111;
var inst_54104__$1 = inst_54123;
var state_54135__$1 = (function (){var statearr_54145 = state_54135;
(statearr_54145[(10)] = inst_54104__$1);

(statearr_54145[(7)] = inst_54103);

return statearr_54145;
})();
var statearr_54146_54171 = state_54135__$1;
(statearr_54146_54171[(2)] = null);

(statearr_54146_54171[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54136 === (2))){
var _ = (function (){var statearr_54147 = state_54135;
(statearr_54147[(4)] = cljs.core.cons((5),(state_54135[(4)])));

return statearr_54147;
})();
var inst_54098 = args;
var inst_54099 = cljs.core.seq(inst_54098);
var inst_54100 = cljs.core.first(inst_54099);
var inst_54101 = cljs.core.next(inst_54099);
var inst_54102 = cljs.core.PersistentVector.EMPTY;
var inst_54103 = inst_54098;
var inst_54104 = inst_54102;
var state_54135__$1 = (function (){var statearr_54148 = state_54135;
(statearr_54148[(10)] = inst_54104);

(statearr_54148[(11)] = inst_54101);

(statearr_54148[(7)] = inst_54103);

(statearr_54148[(12)] = inst_54100);

return statearr_54148;
})();
var statearr_54149_54172 = state_54135__$1;
(statearr_54149_54172[(2)] = null);

(statearr_54149_54172[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54136 === (11))){
var inst_54110 = (state_54135[(8)]);
var state_54135__$1 = state_54135;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54135__$1,(14),inst_54110);
} else {
if((state_val_54136 === (9))){
var inst_54110 = (state_54135[(8)]);
var inst_54115 = fluree.db.util.async.channel_QMARK_(inst_54110);
var state_54135__$1 = state_54135;
if(inst_54115){
var statearr_54151_54173 = state_54135__$1;
(statearr_54151_54173[(1)] = (11));

} else {
var statearr_54152_54174 = state_54135__$1;
(statearr_54152_54174[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54136 === (5))){
var _ = (function (){var statearr_54153 = state_54135;
(statearr_54153[(4)] = cljs.core.rest((state_54135[(4)])));

return statearr_54153;
})();
var state_54135__$1 = state_54135;
var ex54150 = (state_54135__$1[(2)]);
var statearr_54154_54175 = state_54135__$1;
(statearr_54154_54175[(5)] = ex54150);


if((ex54150 instanceof Error)){
var statearr_54155_54176 = state_54135__$1;
(statearr_54155_54176[(1)] = (4));

(statearr_54155_54176[(5)] = null);

} else {
throw ex54150;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54136 === (14))){
var inst_54104 = (state_54135[(10)]);
var inst_54111 = (state_54135[(9)]);
var inst_54118 = (state_54135[(2)]);
var inst_54119 = fluree.db.util.async.throw_err(inst_54118);
var inst_54120 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_54104,inst_54119);
var inst_54103 = inst_54111;
var inst_54104__$1 = inst_54120;
var state_54135__$1 = (function (){var statearr_54156 = state_54135;
(statearr_54156[(10)] = inst_54104__$1);

(statearr_54156[(7)] = inst_54103);

return statearr_54156;
})();
var statearr_54157_54177 = state_54135__$1;
(statearr_54157_54177[(2)] = null);

(statearr_54157_54177[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54136 === (10))){
var inst_54128 = (state_54135[(2)]);
var state_54135__$1 = state_54135;
var statearr_54158_54178 = state_54135__$1;
(statearr_54158_54178[(2)] = inst_54128);

(statearr_54158_54178[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54136 === (8))){
var inst_54104 = (state_54135[(10)]);
var state_54135__$1 = state_54135;
var statearr_54159_54179 = state_54135__$1;
(statearr_54159_54179[(2)] = inst_54104);

(statearr_54159_54179[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2749__auto____0 = (function (){
var statearr_54160 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54160[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2749__auto__);

(statearr_54160[(1)] = (1));

return statearr_54160;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2749__auto____1 = (function (state_54135){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_54135);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e54161){var ex__2752__auto__ = e54161;
var statearr_54162_54180 = state_54135;
(statearr_54162_54180[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_54135[(4)]))){
var statearr_54163_54181 = state_54135;
(statearr_54163_54181[(1)] = cljs.core.first((state_54135[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54182 = state_54135;
state_54135 = G__54182;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2749__auto__ = function(state_54135){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2749__auto____1.call(this,state_54135);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_54164 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_54164[(6)] = c__2771__auto__);

return statearr_54164;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__54183 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54183,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54183,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost], 0)),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_54231){
var state_val_54232 = (state_54231[(1)]);
if((state_val_54232 === (7))){
var state_54231__$1 = state_54231;
var statearr_54233_54262 = state_54231__$1;
(statearr_54233_54262[(2)] = coll);

(statearr_54233_54262[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54232 === (1))){
var state_54231__$1 = state_54231;
var statearr_54234_54263 = state_54231__$1;
(statearr_54234_54263[(2)] = null);

(statearr_54234_54263[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54232 === (4))){
var inst_54186 = (state_54231[(2)]);
var state_54231__$1 = state_54231;
var statearr_54235_54264 = state_54231__$1;
(statearr_54235_54264[(2)] = inst_54186);

(statearr_54235_54264[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54232 === (15))){
var inst_54205 = (state_54231[(7)]);
var inst_54213 = (state_54231[(2)]);
var inst_54214 = fluree.db.dbfunctions.internal.nth(inst_54205,inst_54213);
var inst_54215 = cljs.core.count(inst_54205);
var inst_54216 = ((9) + inst_54215);
var inst_54217 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54218 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54219 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54220 = [inst_54205,inst_54213];
var inst_54221 = (new cljs.core.PersistentVector(null,2,(5),inst_54219,inst_54220,null));
var inst_54222 = ["nth",inst_54221,inst_54214];
var inst_54223 = cljs.core.PersistentHashMap.fromArrays(inst_54218,inst_54222);
var inst_54224 = [inst_54223,inst_54216];
var inst_54225 = (new cljs.core.PersistentVector(null,2,(5),inst_54217,inst_54224,null));
var inst_54226 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54225);
var _ = (function (){var statearr_54236 = state_54231;
(statearr_54236[(4)] = cljs.core.rest((state_54231[(4)])));

return statearr_54236;
})();
var state_54231__$1 = (function (){var statearr_54237 = state_54231;
(statearr_54237[(8)] = inst_54226);

return statearr_54237;
})();
var statearr_54238_54265 = state_54231__$1;
(statearr_54238_54265[(2)] = inst_54214);

(statearr_54238_54265[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54232 === (13))){
var state_54231__$1 = state_54231;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54231__$1,(16),key);
} else {
if((state_val_54232 === (6))){
var state_54231__$1 = state_54231;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54231__$1,(9),coll);
} else {
if((state_val_54232 === (3))){
var inst_54229 = (state_54231[(2)]);
var state_54231__$1 = state_54231;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54231__$1,inst_54229);
} else {
if((state_val_54232 === (12))){
var inst_54205 = (state_54231[(2)]);
var inst_54206 = fluree.db.util.async.channel_QMARK_(key);
var state_54231__$1 = (function (){var statearr_54239 = state_54231;
(statearr_54239[(7)] = inst_54205);

return statearr_54239;
})();
if(inst_54206){
var statearr_54240_54266 = state_54231__$1;
(statearr_54240_54266[(1)] = (13));

} else {
var statearr_54241_54267 = state_54231__$1;
(statearr_54241_54267[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54232 === (2))){
var _ = (function (){var statearr_54242 = state_54231;
(statearr_54242[(4)] = cljs.core.cons((5),(state_54231[(4)])));

return statearr_54242;
})();
var inst_54192 = fluree.db.util.async.channel_QMARK_(coll);
var state_54231__$1 = state_54231;
if(inst_54192){
var statearr_54243_54268 = state_54231__$1;
(statearr_54243_54268[(1)] = (6));

} else {
var statearr_54244_54269 = state_54231__$1;
(statearr_54244_54269[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54232 === (11))){
var inst_54199 = (state_54231[(9)]);
var state_54231__$1 = state_54231;
var statearr_54246_54270 = state_54231__$1;
(statearr_54246_54270[(2)] = inst_54199);

(statearr_54246_54270[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54232 === (9))){
var inst_54195 = (state_54231[(2)]);
var inst_54196 = fluree.db.util.async.throw_err(inst_54195);
var state_54231__$1 = state_54231;
var statearr_54247_54271 = state_54231__$1;
(statearr_54247_54271[(2)] = inst_54196);

(statearr_54247_54271[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54232 === (5))){
var _ = (function (){var statearr_54248 = state_54231;
(statearr_54248[(4)] = cljs.core.rest((state_54231[(4)])));

return statearr_54248;
})();
var state_54231__$1 = state_54231;
var ex54245 = (state_54231__$1[(2)]);
var statearr_54249_54272 = state_54231__$1;
(statearr_54249_54272[(5)] = ex54245);


if((ex54245 instanceof Error)){
var statearr_54250_54273 = state_54231__$1;
(statearr_54250_54273[(1)] = (4));

(statearr_54250_54273[(5)] = null);

} else {
throw ex54245;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54232 === (14))){
var state_54231__$1 = state_54231;
var statearr_54251_54274 = state_54231__$1;
(statearr_54251_54274[(2)] = key);

(statearr_54251_54274[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54232 === (16))){
var inst_54209 = (state_54231[(2)]);
var inst_54210 = fluree.db.util.async.throw_err(inst_54209);
var state_54231__$1 = state_54231;
var statearr_54252_54275 = state_54231__$1;
(statearr_54252_54275[(2)] = inst_54210);

(statearr_54252_54275[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54232 === (10))){
var inst_54199 = (state_54231[(9)]);
var inst_54202 = cljs.core.vec(inst_54199);
var state_54231__$1 = state_54231;
var statearr_54253_54276 = state_54231__$1;
(statearr_54253_54276[(2)] = inst_54202);

(statearr_54253_54276[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54232 === (8))){
var inst_54199 = (state_54231[(9)]);
var inst_54199__$1 = (state_54231[(2)]);
var inst_54200 = cljs.core.set_QMARK_(inst_54199__$1);
var state_54231__$1 = (function (){var statearr_54254 = state_54231;
(statearr_54254[(9)] = inst_54199__$1);

return statearr_54254;
})();
if(inst_54200){
var statearr_54255_54277 = state_54231__$1;
(statearr_54255_54277[(1)] = (10));

} else {
var statearr_54256_54278 = state_54231__$1;
(statearr_54256_54278[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2749__auto____0 = (function (){
var statearr_54257 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54257[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2749__auto__);

(statearr_54257[(1)] = (1));

return statearr_54257;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2749__auto____1 = (function (state_54231){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_54231);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e54258){var ex__2752__auto__ = e54258;
var statearr_54259_54279 = state_54231;
(statearr_54259_54279[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_54231[(4)]))){
var statearr_54260_54280 = state_54231;
(statearr_54260_54280[(1)] = cljs.core.first((state_54231[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54281 = state_54231;
state_54231 = G__54281;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2749__auto__ = function(state_54231){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2749__auto____1.call(this,state_54231);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_54261 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_54261[(6)] = c__2771__auto__);

return statearr_54261;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_54342){
var state_val_54343 = (state_54342[(1)]);
if((state_val_54343 === (7))){
var state_54342__$1 = state_54342;
var statearr_54344_54378 = state_54342__$1;
(statearr_54344_54378[(2)] = test);

(statearr_54344_54378[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54343 === (20))){
var inst_54316 = (state_54342[(2)]);
var inst_54317 = fluree.db.util.async.throw_err(inst_54316);
var state_54342__$1 = state_54342;
var statearr_54345_54379 = state_54342__$1;
(statearr_54345_54379[(2)] = inst_54317);

(statearr_54345_54379[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54343 === (1))){
var state_54342__$1 = state_54342;
var statearr_54346_54380 = state_54342__$1;
(statearr_54346_54380[(2)] = null);

(statearr_54346_54380[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54343 === (4))){
var inst_54282 = (state_54342[(2)]);
var state_54342__$1 = state_54342;
var statearr_54347_54381 = state_54342__$1;
(statearr_54347_54381[(2)] = inst_54282);

(statearr_54347_54381[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54343 === (15))){
var inst_54300 = (state_54342[(7)]);
var inst_54308 = (state_54342[(2)]);
var inst_54309 = [inst_54308,f];
var inst_54310 = (new cljs.core.PersistentVector(null,2,(5),inst_54300,inst_54309,null));
var state_54342__$1 = state_54342;
var statearr_54348_54382 = state_54342__$1;
(statearr_54348_54382[(2)] = inst_54310);

(statearr_54348_54382[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54343 === (13))){
var state_54342__$1 = state_54342;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54342__$1,(16),t);
} else {
if((state_val_54343 === (6))){
var state_54342__$1 = state_54342;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54342__$1,(9),test);
} else {
if((state_val_54343 === (17))){
var state_54342__$1 = state_54342;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54342__$1,(20),f);
} else {
if((state_val_54343 === (3))){
var inst_54340 = (state_54342[(2)]);
var state_54342__$1 = state_54342;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54342__$1,inst_54340);
} else {
if((state_val_54343 === (12))){
var inst_54298 = (state_54342[(8)]);
var inst_54324 = (state_54342[(2)]);
var inst_54325 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54324,(0),null);
var inst_54326 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54324,(1),null);
var inst_54327 = fluree.db.dbfunctions.internal.if_else(inst_54298,inst_54325,inst_54326);
var inst_54328 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54329 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54330 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54331 = [inst_54298,inst_54325,inst_54326];
var inst_54332 = (new cljs.core.PersistentVector(null,3,(5),inst_54330,inst_54331,null));
var inst_54333 = ["if-else",inst_54332,inst_54327];
var inst_54334 = cljs.core.PersistentHashMap.fromArrays(inst_54329,inst_54333);
var inst_54335 = [inst_54334,(10)];
var inst_54336 = (new cljs.core.PersistentVector(null,2,(5),inst_54328,inst_54335,null));
var inst_54337 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54336);
var _ = (function (){var statearr_54349 = state_54342;
(statearr_54349[(4)] = cljs.core.rest((state_54342[(4)])));

return statearr_54349;
})();
var state_54342__$1 = (function (){var statearr_54350 = state_54342;
(statearr_54350[(9)] = inst_54337);

return statearr_54350;
})();
var statearr_54351_54383 = state_54342__$1;
(statearr_54351_54383[(2)] = inst_54327);

(statearr_54351_54383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54343 === (2))){
var _ = (function (){var statearr_54352 = state_54342;
(statearr_54352[(4)] = cljs.core.cons((5),(state_54342[(4)])));

return statearr_54352;
})();
var inst_54291 = fluree.db.util.async.channel_QMARK_(test);
var state_54342__$1 = state_54342;
if(inst_54291){
var statearr_54353_54384 = state_54342__$1;
(statearr_54353_54384[(1)] = (6));

} else {
var statearr_54354_54385 = state_54342__$1;
(statearr_54354_54385[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54343 === (19))){
var inst_54312 = (state_54342[(10)]);
var inst_54320 = (state_54342[(2)]);
var inst_54321 = [f,inst_54320];
var inst_54322 = (new cljs.core.PersistentVector(null,2,(5),inst_54312,inst_54321,null));
var state_54342__$1 = state_54342;
var statearr_54355_54386 = state_54342__$1;
(statearr_54355_54386[(2)] = inst_54322);

(statearr_54355_54386[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54343 === (11))){
var inst_54312 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54313 = fluree.db.util.async.channel_QMARK_(f);
var state_54342__$1 = (function (){var statearr_54357 = state_54342;
(statearr_54357[(10)] = inst_54312);

return statearr_54357;
})();
if(inst_54313){
var statearr_54358_54387 = state_54342__$1;
(statearr_54358_54387[(1)] = (17));

} else {
var statearr_54359_54388 = state_54342__$1;
(statearr_54359_54388[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54343 === (9))){
var inst_54294 = (state_54342[(2)]);
var inst_54295 = fluree.db.util.async.throw_err(inst_54294);
var state_54342__$1 = state_54342;
var statearr_54360_54389 = state_54342__$1;
(statearr_54360_54389[(2)] = inst_54295);

(statearr_54360_54389[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54343 === (5))){
var _ = (function (){var statearr_54361 = state_54342;
(statearr_54361[(4)] = cljs.core.rest((state_54342[(4)])));

return statearr_54361;
})();
var state_54342__$1 = state_54342;
var ex54356 = (state_54342__$1[(2)]);
var statearr_54362_54390 = state_54342__$1;
(statearr_54362_54390[(5)] = ex54356);


if((ex54356 instanceof Error)){
var statearr_54363_54391 = state_54342__$1;
(statearr_54363_54391[(1)] = (4));

(statearr_54363_54391[(5)] = null);

} else {
throw ex54356;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54343 === (14))){
var state_54342__$1 = state_54342;
var statearr_54364_54392 = state_54342__$1;
(statearr_54364_54392[(2)] = t);

(statearr_54364_54392[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54343 === (16))){
var inst_54304 = (state_54342[(2)]);
var inst_54305 = fluree.db.util.async.throw_err(inst_54304);
var state_54342__$1 = state_54342;
var statearr_54365_54393 = state_54342__$1;
(statearr_54365_54393[(2)] = inst_54305);

(statearr_54365_54393[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54343 === (10))){
var inst_54300 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54301 = fluree.db.util.async.channel_QMARK_(t);
var state_54342__$1 = (function (){var statearr_54366 = state_54342;
(statearr_54366[(7)] = inst_54300);

return statearr_54366;
})();
if(inst_54301){
var statearr_54367_54394 = state_54342__$1;
(statearr_54367_54394[(1)] = (13));

} else {
var statearr_54368_54395 = state_54342__$1;
(statearr_54368_54395[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54343 === (18))){
var state_54342__$1 = state_54342;
var statearr_54369_54396 = state_54342__$1;
(statearr_54369_54396[(2)] = f);

(statearr_54369_54396[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54343 === (8))){
var inst_54298 = (state_54342[(8)]);
var inst_54298__$1 = (state_54342[(2)]);
var state_54342__$1 = (function (){var statearr_54370 = state_54342;
(statearr_54370[(8)] = inst_54298__$1);

return statearr_54370;
})();
if(cljs.core.truth_(inst_54298__$1)){
var statearr_54371_54397 = state_54342__$1;
(statearr_54371_54397[(1)] = (10));

} else {
var statearr_54372_54398 = state_54342__$1;
(statearr_54372_54398[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2749__auto____0 = (function (){
var statearr_54373 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54373[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2749__auto__);

(statearr_54373[(1)] = (1));

return statearr_54373;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2749__auto____1 = (function (state_54342){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_54342);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e54374){var ex__2752__auto__ = e54374;
var statearr_54375_54399 = state_54342;
(statearr_54375_54399[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_54342[(4)]))){
var statearr_54376_54400 = state_54342;
(statearr_54376_54400[(1)] = cljs.core.first((state_54342[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54401 = state_54342;
state_54342 = G__54401;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2749__auto__ = function(state_54342){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2749__auto____1.call(this,state_54342);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_54377 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_54377[(6)] = c__2771__auto__);

return statearr_54377;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_54431){
var state_val_54432 = (state_54431[(1)]);
if((state_val_54432 === (7))){
var state_54431__$1 = state_54431;
var statearr_54433_54452 = state_54431__$1;
(statearr_54433_54452[(2)] = arg);

(statearr_54433_54452[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54432 === (1))){
var state_54431__$1 = state_54431;
var statearr_54434_54453 = state_54431__$1;
(statearr_54434_54453[(2)] = null);

(statearr_54434_54453[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54432 === (4))){
var inst_54402 = (state_54431[(2)]);
var state_54431__$1 = state_54431;
var statearr_54435_54454 = state_54431__$1;
(statearr_54435_54454[(2)] = inst_54402);

(statearr_54435_54454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54432 === (6))){
var state_54431__$1 = state_54431;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54431__$1,(9),arg);
} else {
if((state_val_54432 === (3))){
var inst_54429 = (state_54431[(2)]);
var state_54431__$1 = state_54431;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54431__$1,inst_54429);
} else {
if((state_val_54432 === (2))){
var _ = (function (){var statearr_54437 = state_54431;
(statearr_54437[(4)] = cljs.core.cons((5),(state_54431[(4)])));

return statearr_54437;
})();
var inst_54408 = fluree.db.util.async.channel_QMARK_(arg);
var state_54431__$1 = state_54431;
if(inst_54408){
var statearr_54438_54455 = state_54431__$1;
(statearr_54438_54455[(1)] = (6));

} else {
var statearr_54439_54456 = state_54431__$1;
(statearr_54439_54456[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54432 === (9))){
var inst_54411 = (state_54431[(2)]);
var inst_54412 = fluree.db.util.async.throw_err(inst_54411);
var state_54431__$1 = state_54431;
var statearr_54440_54457 = state_54431__$1;
(statearr_54440_54457[(2)] = inst_54412);

(statearr_54440_54457[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54432 === (5))){
var _ = (function (){var statearr_54441 = state_54431;
(statearr_54441[(4)] = cljs.core.rest((state_54431[(4)])));

return statearr_54441;
})();
var state_54431__$1 = state_54431;
var ex54436 = (state_54431__$1[(2)]);
var statearr_54442_54458 = state_54431__$1;
(statearr_54442_54458[(5)] = ex54436);


if((ex54436 instanceof Error)){
var statearr_54443_54459 = state_54431__$1;
(statearr_54443_54459[(1)] = (4));

(statearr_54443_54459[(5)] = null);

} else {
throw ex54436;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54432 === (8))){
var inst_54415 = (state_54431[(2)]);
var inst_54416 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_54415);
var inst_54417 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54418 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54419 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54420 = [inst_54415];
var inst_54421 = (new cljs.core.PersistentVector(null,1,(5),inst_54419,inst_54420,null));
var inst_54422 = ["nil?",inst_54421,inst_54416];
var inst_54423 = cljs.core.PersistentHashMap.fromArrays(inst_54418,inst_54422);
var inst_54424 = [inst_54423,(10)];
var inst_54425 = (new cljs.core.PersistentVector(null,2,(5),inst_54417,inst_54424,null));
var inst_54426 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54425);
var _ = (function (){var statearr_54444 = state_54431;
(statearr_54444[(4)] = cljs.core.rest((state_54431[(4)])));

return statearr_54444;
})();
var state_54431__$1 = (function (){var statearr_54445 = state_54431;
(statearr_54445[(7)] = inst_54426);

return statearr_54445;
})();
var statearr_54446_54460 = state_54431__$1;
(statearr_54446_54460[(2)] = inst_54416);

(statearr_54446_54460[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2749__auto____0 = (function (){
var statearr_54447 = [null,null,null,null,null,null,null,null];
(statearr_54447[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2749__auto__);

(statearr_54447[(1)] = (1));

return statearr_54447;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2749__auto____1 = (function (state_54431){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_54431);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e54448){var ex__2752__auto__ = e54448;
var statearr_54449_54461 = state_54431;
(statearr_54449_54461[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_54431[(4)]))){
var statearr_54450_54462 = state_54431;
(statearr_54450_54462[(1)] = cljs.core.first((state_54431[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54463 = state_54431;
state_54431 = G__54463;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2749__auto__ = function(state_54431){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2749__auto____1.call(this,state_54431);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_54451 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_54451[(6)] = c__2771__auto__);

return statearr_54451;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_54493){
var state_val_54494 = (state_54493[(1)]);
if((state_val_54494 === (7))){
var state_54493__$1 = state_54493;
var statearr_54495_54514 = state_54493__$1;
(statearr_54495_54514[(2)] = arg);

(statearr_54495_54514[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54494 === (1))){
var state_54493__$1 = state_54493;
var statearr_54496_54515 = state_54493__$1;
(statearr_54496_54515[(2)] = null);

(statearr_54496_54515[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54494 === (4))){
var inst_54464 = (state_54493[(2)]);
var state_54493__$1 = state_54493;
var statearr_54497_54516 = state_54493__$1;
(statearr_54497_54516[(2)] = inst_54464);

(statearr_54497_54516[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54494 === (6))){
var state_54493__$1 = state_54493;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54493__$1,(9),arg);
} else {
if((state_val_54494 === (3))){
var inst_54491 = (state_54493[(2)]);
var state_54493__$1 = state_54493;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54493__$1,inst_54491);
} else {
if((state_val_54494 === (2))){
var _ = (function (){var statearr_54499 = state_54493;
(statearr_54499[(4)] = cljs.core.cons((5),(state_54493[(4)])));

return statearr_54499;
})();
var inst_54470 = fluree.db.util.async.channel_QMARK_(arg);
var state_54493__$1 = state_54493;
if(inst_54470){
var statearr_54500_54517 = state_54493__$1;
(statearr_54500_54517[(1)] = (6));

} else {
var statearr_54501_54518 = state_54493__$1;
(statearr_54501_54518[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54494 === (9))){
var inst_54473 = (state_54493[(2)]);
var inst_54474 = fluree.db.util.async.throw_err(inst_54473);
var state_54493__$1 = state_54493;
var statearr_54502_54519 = state_54493__$1;
(statearr_54502_54519[(2)] = inst_54474);

(statearr_54502_54519[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54494 === (5))){
var _ = (function (){var statearr_54503 = state_54493;
(statearr_54503[(4)] = cljs.core.rest((state_54493[(4)])));

return statearr_54503;
})();
var state_54493__$1 = state_54493;
var ex54498 = (state_54493__$1[(2)]);
var statearr_54504_54520 = state_54493__$1;
(statearr_54504_54520[(5)] = ex54498);


if((ex54498 instanceof Error)){
var statearr_54505_54521 = state_54493__$1;
(statearr_54505_54521[(1)] = (4));

(statearr_54505_54521[(5)] = null);

} else {
throw ex54498;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54494 === (8))){
var inst_54477 = (state_54493[(2)]);
var inst_54478 = fluree.db.dbfunctions.internal.not(inst_54477);
var inst_54479 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54480 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54481 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54482 = [inst_54477];
var inst_54483 = (new cljs.core.PersistentVector(null,1,(5),inst_54481,inst_54482,null));
var inst_54484 = ["not?",inst_54483,inst_54478];
var inst_54485 = cljs.core.PersistentHashMap.fromArrays(inst_54480,inst_54484);
var inst_54486 = [inst_54485,(10)];
var inst_54487 = (new cljs.core.PersistentVector(null,2,(5),inst_54479,inst_54486,null));
var inst_54488 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54487);
var _ = (function (){var statearr_54506 = state_54493;
(statearr_54506[(4)] = cljs.core.rest((state_54493[(4)])));

return statearr_54506;
})();
var state_54493__$1 = (function (){var statearr_54507 = state_54493;
(statearr_54507[(7)] = inst_54488);

return statearr_54507;
})();
var statearr_54508_54522 = state_54493__$1;
(statearr_54508_54522[(2)] = inst_54478);

(statearr_54508_54522[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2749__auto____0 = (function (){
var statearr_54509 = [null,null,null,null,null,null,null,null];
(statearr_54509[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2749__auto__);

(statearr_54509[(1)] = (1));

return statearr_54509;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2749__auto____1 = (function (state_54493){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_54493);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e54510){var ex__2752__auto__ = e54510;
var statearr_54511_54523 = state_54493;
(statearr_54511_54523[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_54493[(4)]))){
var statearr_54512_54524 = state_54493;
(statearr_54512_54524[(1)] = cljs.core.first((state_54493[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54525 = state_54493;
state_54493 = G__54525;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2749__auto__ = function(state_54493){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2749__auto____1.call(this,state_54493);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_54513 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_54513[(6)] = c__2771__auto__);

return statearr_54513;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_54555){
var state_val_54556 = (state_54555[(1)]);
if((state_val_54556 === (7))){
var state_54555__$1 = state_54555;
var statearr_54557_54576 = state_54555__$1;
(statearr_54557_54576[(2)] = arg);

(statearr_54557_54576[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54556 === (1))){
var state_54555__$1 = state_54555;
var statearr_54558_54577 = state_54555__$1;
(statearr_54558_54577[(2)] = null);

(statearr_54558_54577[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54556 === (4))){
var inst_54526 = (state_54555[(2)]);
var state_54555__$1 = state_54555;
var statearr_54559_54578 = state_54555__$1;
(statearr_54559_54578[(2)] = inst_54526);

(statearr_54559_54578[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54556 === (6))){
var state_54555__$1 = state_54555;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54555__$1,(9),arg);
} else {
if((state_val_54556 === (3))){
var inst_54553 = (state_54555[(2)]);
var state_54555__$1 = state_54555;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54555__$1,inst_54553);
} else {
if((state_val_54556 === (2))){
var _ = (function (){var statearr_54561 = state_54555;
(statearr_54561[(4)] = cljs.core.cons((5),(state_54555[(4)])));

return statearr_54561;
})();
var inst_54532 = fluree.db.util.async.channel_QMARK_(arg);
var state_54555__$1 = state_54555;
if(inst_54532){
var statearr_54562_54579 = state_54555__$1;
(statearr_54562_54579[(1)] = (6));

} else {
var statearr_54563_54580 = state_54555__$1;
(statearr_54563_54580[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54556 === (9))){
var inst_54535 = (state_54555[(2)]);
var inst_54536 = fluree.db.util.async.throw_err(inst_54535);
var state_54555__$1 = state_54555;
var statearr_54564_54581 = state_54555__$1;
(statearr_54564_54581[(2)] = inst_54536);

(statearr_54564_54581[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54556 === (5))){
var _ = (function (){var statearr_54565 = state_54555;
(statearr_54565[(4)] = cljs.core.rest((state_54555[(4)])));

return statearr_54565;
})();
var state_54555__$1 = state_54555;
var ex54560 = (state_54555__$1[(2)]);
var statearr_54566_54582 = state_54555__$1;
(statearr_54566_54582[(5)] = ex54560);


if((ex54560 instanceof Error)){
var statearr_54567_54583 = state_54555__$1;
(statearr_54567_54583[(1)] = (4));

(statearr_54567_54583[(5)] = null);

} else {
throw ex54560;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54556 === (8))){
var inst_54539 = (state_54555[(2)]);
var inst_54540 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_54539);
var inst_54541 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54542 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54543 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54544 = [inst_54539];
var inst_54545 = (new cljs.core.PersistentVector(null,1,(5),inst_54543,inst_54544,null));
var inst_54546 = ["empty?",inst_54545,inst_54540];
var inst_54547 = cljs.core.PersistentHashMap.fromArrays(inst_54542,inst_54546);
var inst_54548 = [inst_54547,(10)];
var inst_54549 = (new cljs.core.PersistentVector(null,2,(5),inst_54541,inst_54548,null));
var inst_54550 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54549);
var _ = (function (){var statearr_54568 = state_54555;
(statearr_54568[(4)] = cljs.core.rest((state_54555[(4)])));

return statearr_54568;
})();
var state_54555__$1 = (function (){var statearr_54569 = state_54555;
(statearr_54569[(7)] = inst_54550);

return statearr_54569;
})();
var statearr_54570_54584 = state_54555__$1;
(statearr_54570_54584[(2)] = inst_54540);

(statearr_54570_54584[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2749__auto____0 = (function (){
var statearr_54571 = [null,null,null,null,null,null,null,null];
(statearr_54571[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2749__auto__);

(statearr_54571[(1)] = (1));

return statearr_54571;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2749__auto____1 = (function (state_54555){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_54555);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e54572){var ex__2752__auto__ = e54572;
var statearr_54573_54585 = state_54555;
(statearr_54573_54585[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_54555[(4)]))){
var statearr_54574_54586 = state_54555;
(statearr_54574_54586[(1)] = cljs.core.first((state_54555[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54587 = state_54555;
state_54555 = G__54587;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2749__auto__ = function(state_54555){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2749__auto____1.call(this,state_54555);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_54575 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_54575[(6)] = c__2771__auto__);

return statearr_54575;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__5774__auto__ = [];
var len__5768__auto___54632 = arguments.length;
var i__5769__auto___54633 = (0);
while(true){
if((i__5769__auto___54633 < len__5768__auto___54632)){
args__5774__auto__.push((arguments[i__5769__auto___54633]));

var G__54634 = (i__5769__auto___54633 + (1));
i__5769__auto___54633 = G__54634;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_54615){
var state_val_54616 = (state_54615[(1)]);
if((state_val_54616 === (1))){
var state_54615__$1 = state_54615;
var statearr_54617_54635 = state_54615__$1;
(statearr_54617_54635[(2)] = null);

(statearr_54617_54635[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54616 === (2))){
var _ = (function (){var statearr_54618 = state_54615;
(statearr_54618[(4)] = cljs.core.cons((5),(state_54615[(4)])));

return statearr_54618;
})();
var inst_54596 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54615__$1 = state_54615;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54615__$1,(6),inst_54596);
} else {
if((state_val_54616 === (3))){
var inst_54613 = (state_54615[(2)]);
var state_54615__$1 = state_54615;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54615__$1,inst_54613);
} else {
if((state_val_54616 === (4))){
var inst_54590 = (state_54615[(2)]);
var state_54615__$1 = state_54615;
var statearr_54620_54636 = state_54615__$1;
(statearr_54620_54636[(2)] = inst_54590);

(statearr_54620_54636[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54616 === (5))){
var _ = (function (){var statearr_54621 = state_54615;
(statearr_54621[(4)] = cljs.core.rest((state_54615[(4)])));

return statearr_54621;
})();
var state_54615__$1 = state_54615;
var ex54619 = (state_54615__$1[(2)]);
var statearr_54622_54637 = state_54615__$1;
(statearr_54622_54637[(5)] = ex54619);


if((ex54619 instanceof Error)){
var statearr_54623_54638 = state_54615__$1;
(statearr_54623_54638[(1)] = (4));

(statearr_54623_54638[(5)] = null);

} else {
throw ex54619;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54616 === (6))){
var inst_54598 = (state_54615[(2)]);
var inst_54599 = fluree.db.util.async.throw_err(inst_54598);
var inst_54600 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_54599);
var inst_54601 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54602 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54603 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54604 = [inst_54599];
var inst_54605 = (new cljs.core.PersistentVector(null,1,(5),inst_54603,inst_54604,null));
var inst_54606 = ["str",inst_54605,inst_54600];
var inst_54607 = cljs.core.PersistentHashMap.fromArrays(inst_54602,inst_54606);
var inst_54608 = [inst_54607,(10)];
var inst_54609 = (new cljs.core.PersistentVector(null,2,(5),inst_54601,inst_54608,null));
var inst_54610 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54609);
var _ = (function (){var statearr_54624 = state_54615;
(statearr_54624[(4)] = cljs.core.rest((state_54615[(4)])));

return statearr_54624;
})();
var state_54615__$1 = (function (){var statearr_54625 = state_54615;
(statearr_54625[(7)] = inst_54610);

return statearr_54625;
})();
var statearr_54626_54639 = state_54615__$1;
(statearr_54626_54639[(2)] = inst_54600);

(statearr_54626_54639[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2749__auto____0 = (function (){
var statearr_54627 = [null,null,null,null,null,null,null,null];
(statearr_54627[(0)] = fluree$db$dbfunctions$fns$state_machine__2749__auto__);

(statearr_54627[(1)] = (1));

return statearr_54627;
});
var fluree$db$dbfunctions$fns$state_machine__2749__auto____1 = (function (state_54615){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_54615);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e54628){var ex__2752__auto__ = e54628;
var statearr_54629_54640 = state_54615;
(statearr_54629_54640[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_54615[(4)]))){
var statearr_54630_54641 = state_54615;
(statearr_54630_54641[(1)] = cljs.core.first((state_54615[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54642 = state_54615;
state_54615 = G__54642;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2749__auto__ = function(state_54615){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____1.call(this,state_54615);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_54631 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_54631[(6)] = c__2771__auto__);

return statearr_54631;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq54588){
var G__54589 = cljs.core.first(seq54588);
var seq54588__$1 = cljs.core.next(seq54588);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54589,seq54588__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_54668){
var state_val_54669 = (state_54668[(1)]);
if((state_val_54669 === (1))){
var state_54668__$1 = state_54668;
var statearr_54670_54685 = state_54668__$1;
(statearr_54670_54685[(2)] = null);

(statearr_54670_54685[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54669 === (2))){
var _ = (function (){var statearr_54671 = state_54668;
(statearr_54671[(4)] = cljs.core.cons((5),(state_54668[(4)])));

return statearr_54671;
})();
var inst_54649 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54668__$1 = state_54668;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54668__$1,(6),inst_54649);
} else {
if((state_val_54669 === (3))){
var inst_54666 = (state_54668[(2)]);
var state_54668__$1 = state_54668;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54668__$1,inst_54666);
} else {
if((state_val_54669 === (4))){
var inst_54643 = (state_54668[(2)]);
var state_54668__$1 = state_54668;
var statearr_54673_54686 = state_54668__$1;
(statearr_54673_54686[(2)] = inst_54643);

(statearr_54673_54686[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54669 === (5))){
var _ = (function (){var statearr_54674 = state_54668;
(statearr_54674[(4)] = cljs.core.rest((state_54668[(4)])));

return statearr_54674;
})();
var state_54668__$1 = state_54668;
var ex54672 = (state_54668__$1[(2)]);
var statearr_54675_54687 = state_54668__$1;
(statearr_54675_54687[(5)] = ex54672);


if((ex54672 instanceof Error)){
var statearr_54676_54688 = state_54668__$1;
(statearr_54676_54688[(1)] = (4));

(statearr_54676_54688[(5)] = null);

} else {
throw ex54672;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54669 === (6))){
var inst_54651 = (state_54668[(2)]);
var inst_54652 = fluree.db.util.async.throw_err(inst_54651);
var inst_54653 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_54652);
var inst_54654 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54655 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54656 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54657 = [inst_54652];
var inst_54658 = (new cljs.core.PersistentVector(null,1,(5),inst_54656,inst_54657,null));
var inst_54659 = ["subs",inst_54658,inst_54653];
var inst_54660 = cljs.core.PersistentHashMap.fromArrays(inst_54655,inst_54659);
var inst_54661 = [inst_54660,(30)];
var inst_54662 = (new cljs.core.PersistentVector(null,2,(5),inst_54654,inst_54661,null));
var inst_54663 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54662);
var _ = (function (){var statearr_54677 = state_54668;
(statearr_54677[(4)] = cljs.core.rest((state_54668[(4)])));

return statearr_54677;
})();
var state_54668__$1 = (function (){var statearr_54678 = state_54668;
(statearr_54678[(7)] = inst_54663);

return statearr_54678;
})();
var statearr_54679_54689 = state_54668__$1;
(statearr_54679_54689[(2)] = inst_54653);

(statearr_54679_54689[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2749__auto____0 = (function (){
var statearr_54680 = [null,null,null,null,null,null,null,null];
(statearr_54680[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2749__auto__);

(statearr_54680[(1)] = (1));

return statearr_54680;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2749__auto____1 = (function (state_54668){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_54668);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e54681){var ex__2752__auto__ = e54681;
var statearr_54682_54690 = state_54668;
(statearr_54682_54690[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_54668[(4)]))){
var statearr_54683_54691 = state_54668;
(statearr_54683_54691[(1)] = cljs.core.first((state_54668[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54692 = state_54668;
state_54668 = G__54692;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2749__auto__ = function(state_54668){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2749__auto____1.call(this,state_54668);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_54684 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_54684[(6)] = c__2771__auto__);

return statearr_54684;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_54722){
var state_val_54723 = (state_54722[(1)]);
if((state_val_54723 === (7))){
var state_54722__$1 = state_54722;
var statearr_54724_54743 = state_54722__$1;
(statearr_54724_54743[(2)] = str);

(statearr_54724_54743[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54723 === (1))){
var state_54722__$1 = state_54722;
var statearr_54725_54744 = state_54722__$1;
(statearr_54725_54744[(2)] = null);

(statearr_54725_54744[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54723 === (4))){
var inst_54693 = (state_54722[(2)]);
var state_54722__$1 = state_54722;
var statearr_54726_54745 = state_54722__$1;
(statearr_54726_54745[(2)] = inst_54693);

(statearr_54726_54745[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54723 === (6))){
var state_54722__$1 = state_54722;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54722__$1,(9),str);
} else {
if((state_val_54723 === (3))){
var inst_54720 = (state_54722[(2)]);
var state_54722__$1 = state_54722;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54722__$1,inst_54720);
} else {
if((state_val_54723 === (2))){
var _ = (function (){var statearr_54728 = state_54722;
(statearr_54728[(4)] = cljs.core.cons((5),(state_54722[(4)])));

return statearr_54728;
})();
var inst_54699 = fluree.db.util.async.channel_QMARK_(str);
var state_54722__$1 = state_54722;
if(inst_54699){
var statearr_54729_54746 = state_54722__$1;
(statearr_54729_54746[(1)] = (6));

} else {
var statearr_54730_54747 = state_54722__$1;
(statearr_54730_54747[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54723 === (9))){
var inst_54702 = (state_54722[(2)]);
var inst_54703 = fluree.db.util.async.throw_err(inst_54702);
var state_54722__$1 = state_54722;
var statearr_54731_54748 = state_54722__$1;
(statearr_54731_54748[(2)] = inst_54703);

(statearr_54731_54748[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54723 === (5))){
var _ = (function (){var statearr_54732 = state_54722;
(statearr_54732[(4)] = cljs.core.rest((state_54722[(4)])));

return statearr_54732;
})();
var state_54722__$1 = state_54722;
var ex54727 = (state_54722__$1[(2)]);
var statearr_54733_54749 = state_54722__$1;
(statearr_54733_54749[(5)] = ex54727);


if((ex54727 instanceof Error)){
var statearr_54734_54750 = state_54722__$1;
(statearr_54734_54750[(1)] = (4));

(statearr_54734_54750[(5)] = null);

} else {
throw ex54727;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54723 === (8))){
var inst_54706 = (state_54722[(2)]);
var inst_54707 = fluree.db.dbfunctions.internal.lower_case(inst_54706);
var inst_54708 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54709 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54710 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54711 = [inst_54706];
var inst_54712 = (new cljs.core.PersistentVector(null,1,(5),inst_54710,inst_54711,null));
var inst_54713 = ["lower-case",inst_54712,inst_54707];
var inst_54714 = cljs.core.PersistentHashMap.fromArrays(inst_54709,inst_54713);
var inst_54715 = [inst_54714,(10)];
var inst_54716 = (new cljs.core.PersistentVector(null,2,(5),inst_54708,inst_54715,null));
var inst_54717 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54716);
var _ = (function (){var statearr_54735 = state_54722;
(statearr_54735[(4)] = cljs.core.rest((state_54722[(4)])));

return statearr_54735;
})();
var state_54722__$1 = (function (){var statearr_54736 = state_54722;
(statearr_54736[(7)] = inst_54717);

return statearr_54736;
})();
var statearr_54737_54751 = state_54722__$1;
(statearr_54737_54751[(2)] = inst_54707);

(statearr_54737_54751[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2749__auto____0 = (function (){
var statearr_54738 = [null,null,null,null,null,null,null,null];
(statearr_54738[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2749__auto__);

(statearr_54738[(1)] = (1));

return statearr_54738;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2749__auto____1 = (function (state_54722){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_54722);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e54739){var ex__2752__auto__ = e54739;
var statearr_54740_54752 = state_54722;
(statearr_54740_54752[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_54722[(4)]))){
var statearr_54741_54753 = state_54722;
(statearr_54741_54753[(1)] = cljs.core.first((state_54722[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54754 = state_54722;
state_54722 = G__54754;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2749__auto__ = function(state_54722){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2749__auto____1.call(this,state_54722);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_54742 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_54742[(6)] = c__2771__auto__);

return statearr_54742;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_54784){
var state_val_54785 = (state_54784[(1)]);
if((state_val_54785 === (7))){
var state_54784__$1 = state_54784;
var statearr_54786_54805 = state_54784__$1;
(statearr_54786_54805[(2)] = str);

(statearr_54786_54805[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54785 === (1))){
var state_54784__$1 = state_54784;
var statearr_54787_54806 = state_54784__$1;
(statearr_54787_54806[(2)] = null);

(statearr_54787_54806[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54785 === (4))){
var inst_54755 = (state_54784[(2)]);
var state_54784__$1 = state_54784;
var statearr_54788_54807 = state_54784__$1;
(statearr_54788_54807[(2)] = inst_54755);

(statearr_54788_54807[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54785 === (6))){
var state_54784__$1 = state_54784;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54784__$1,(9),str);
} else {
if((state_val_54785 === (3))){
var inst_54782 = (state_54784[(2)]);
var state_54784__$1 = state_54784;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54784__$1,inst_54782);
} else {
if((state_val_54785 === (2))){
var _ = (function (){var statearr_54790 = state_54784;
(statearr_54790[(4)] = cljs.core.cons((5),(state_54784[(4)])));

return statearr_54790;
})();
var inst_54761 = fluree.db.util.async.channel_QMARK_(str);
var state_54784__$1 = state_54784;
if(inst_54761){
var statearr_54791_54808 = state_54784__$1;
(statearr_54791_54808[(1)] = (6));

} else {
var statearr_54792_54809 = state_54784__$1;
(statearr_54792_54809[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54785 === (9))){
var inst_54764 = (state_54784[(2)]);
var inst_54765 = fluree.db.util.async.throw_err(inst_54764);
var state_54784__$1 = state_54784;
var statearr_54793_54810 = state_54784__$1;
(statearr_54793_54810[(2)] = inst_54765);

(statearr_54793_54810[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54785 === (5))){
var _ = (function (){var statearr_54794 = state_54784;
(statearr_54794[(4)] = cljs.core.rest((state_54784[(4)])));

return statearr_54794;
})();
var state_54784__$1 = state_54784;
var ex54789 = (state_54784__$1[(2)]);
var statearr_54795_54811 = state_54784__$1;
(statearr_54795_54811[(5)] = ex54789);


if((ex54789 instanceof Error)){
var statearr_54796_54812 = state_54784__$1;
(statearr_54796_54812[(1)] = (4));

(statearr_54796_54812[(5)] = null);

} else {
throw ex54789;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54785 === (8))){
var inst_54768 = (state_54784[(2)]);
var inst_54769 = fluree.db.dbfunctions.internal.upper_case(inst_54768);
var inst_54770 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54771 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54772 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54773 = [inst_54768];
var inst_54774 = (new cljs.core.PersistentVector(null,1,(5),inst_54772,inst_54773,null));
var inst_54775 = ["upper-case",inst_54774,inst_54769];
var inst_54776 = cljs.core.PersistentHashMap.fromArrays(inst_54771,inst_54775);
var inst_54777 = [inst_54776,(10)];
var inst_54778 = (new cljs.core.PersistentVector(null,2,(5),inst_54770,inst_54777,null));
var inst_54779 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54778);
var _ = (function (){var statearr_54797 = state_54784;
(statearr_54797[(4)] = cljs.core.rest((state_54784[(4)])));

return statearr_54797;
})();
var state_54784__$1 = (function (){var statearr_54798 = state_54784;
(statearr_54798[(7)] = inst_54779);

return statearr_54798;
})();
var statearr_54799_54813 = state_54784__$1;
(statearr_54799_54813[(2)] = inst_54769);

(statearr_54799_54813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2749__auto____0 = (function (){
var statearr_54800 = [null,null,null,null,null,null,null,null];
(statearr_54800[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2749__auto__);

(statearr_54800[(1)] = (1));

return statearr_54800;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2749__auto____1 = (function (state_54784){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_54784);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e54801){var ex__2752__auto__ = e54801;
var statearr_54802_54814 = state_54784;
(statearr_54802_54814[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_54784[(4)]))){
var statearr_54803_54815 = state_54784;
(statearr_54803_54815[(1)] = cljs.core.first((state_54784[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54816 = state_54784;
state_54784 = G__54816;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2749__auto__ = function(state_54784){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2749__auto____1.call(this,state_54784);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_54804 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_54804[(6)] = c__2771__auto__);

return statearr_54804;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__5043__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__5043__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__54818 = arguments.length;
switch (G__54818) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_54846){
var state_val_54847 = (state_54846[(1)]);
if((state_val_54847 === (1))){
var state_54846__$1 = state_54846;
var statearr_54848_54864 = state_54846__$1;
(statearr_54848_54864[(2)] = null);

(statearr_54848_54864[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54847 === (2))){
var _ = (function (){var statearr_54849 = state_54846;
(statearr_54849[(4)] = cljs.core.cons((5),(state_54846[(4)])));

return statearr_54849;
})();
var inst_54828 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_54846__$1 = state_54846;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54846__$1,(6),inst_54828);
} else {
if((state_val_54847 === (3))){
var inst_54844 = (state_54846[(2)]);
var state_54846__$1 = state_54846;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54846__$1,inst_54844);
} else {
if((state_val_54847 === (4))){
var inst_54819 = (state_54846[(2)]);
var state_54846__$1 = state_54846;
var statearr_54851_54865 = state_54846__$1;
(statearr_54851_54865[(2)] = inst_54819);

(statearr_54851_54865[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54847 === (5))){
var _ = (function (){var statearr_54852 = state_54846;
(statearr_54852[(4)] = cljs.core.rest((state_54846[(4)])));

return statearr_54852;
})();
var state_54846__$1 = state_54846;
var ex54850 = (state_54846__$1[(2)]);
var statearr_54853_54866 = state_54846__$1;
(statearr_54853_54866[(5)] = ex54850);


if((ex54850 instanceof Error)){
var statearr_54854_54867 = state_54846__$1;
(statearr_54854_54867[(1)] = (4));

(statearr_54854_54867[(5)] = null);

} else {
throw ex54850;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54847 === (6))){
var inst_54830 = (state_54846[(2)]);
var inst_54831 = fluree.db.util.async.throw_err(inst_54830);
var inst_54832 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54831,(0),null);
var inst_54833 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54831,(1),null);
var inst_54834 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54835 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54836 = ["?s","?ctx",inst_54832];
var inst_54837 = cljs.core.PersistentHashMap.fromArrays(inst_54835,inst_54836);
var inst_54838 = ((10) + inst_54833);
var inst_54839 = [inst_54837,inst_54838];
var inst_54840 = (new cljs.core.PersistentVector(null,2,(5),inst_54834,inst_54839,null));
var inst_54841 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54840);
var _ = (function (){var statearr_54855 = state_54846;
(statearr_54855[(4)] = cljs.core.rest((state_54846[(4)])));

return statearr_54855;
})();
var state_54846__$1 = (function (){var statearr_54856 = state_54846;
(statearr_54856[(7)] = inst_54841);

return statearr_54856;
})();
var statearr_54857_54868 = state_54846__$1;
(statearr_54857_54868[(2)] = inst_54832);

(statearr_54857_54868[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2749__auto____0 = (function (){
var statearr_54858 = [null,null,null,null,null,null,null,null];
(statearr_54858[(0)] = fluree$db$dbfunctions$fns$state_machine__2749__auto__);

(statearr_54858[(1)] = (1));

return statearr_54858;
});
var fluree$db$dbfunctions$fns$state_machine__2749__auto____1 = (function (state_54846){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_54846);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e54859){var ex__2752__auto__ = e54859;
var statearr_54860_54869 = state_54846;
(statearr_54860_54869[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_54846[(4)]))){
var statearr_54861_54870 = state_54846;
(statearr_54861_54870[(1)] = cljs.core.first((state_54846[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54871 = state_54846;
state_54846 = G__54871;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2749__auto__ = function(state_54846){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____1.call(this,state_54846);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_54862 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_54862[(6)] = c__2771__auto__);

return statearr_54862;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__54873 = arguments.length;
switch (G__54873) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_54911){
var state_val_54912 = (state_54911[(1)]);
if((state_val_54912 === (7))){
var inst_54904 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_54911__$1 = state_54911;
var statearr_54913_54933 = state_54911__$1;
(statearr_54913_54933[(2)] = inst_54904);

(statearr_54913_54933[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54912 === (1))){
var state_54911__$1 = state_54911;
var statearr_54914_54934 = state_54911__$1;
(statearr_54914_54934[(2)] = null);

(statearr_54914_54934[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54912 === (4))){
var inst_54874 = (state_54911[(2)]);
var state_54911__$1 = state_54911;
var statearr_54915_54935 = state_54911__$1;
(statearr_54915_54935[(2)] = inst_54874);

(statearr_54915_54935[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54912 === (6))){
var inst_54885 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_54911__$1 = state_54911;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54911__$1,(10),inst_54885);
} else {
if((state_val_54912 === (3))){
var inst_54909 = (state_54911[(2)]);
var state_54911__$1 = state_54911;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54911__$1,inst_54909);
} else {
if((state_val_54912 === (2))){
var _ = (function (){var statearr_54917 = state_54911;
(statearr_54917[(4)] = cljs.core.cons((5),(state_54911[(4)])));

return statearr_54917;
})();
var inst_54880 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54911__$1 = state_54911;
if(cljs.core.truth_(inst_54880)){
var statearr_54918_54936 = state_54911__$1;
(statearr_54918_54936[(1)] = (6));

} else {
var statearr_54919_54937 = state_54911__$1;
(statearr_54919_54937[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54912 === (9))){
var inst_54891 = (state_54911[(2)]);
var inst_54892 = fluree.db.util.async.throw_err(inst_54891);
var inst_54893 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54892,(0),null);
var inst_54894 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54892,(1),null);
var inst_54895 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54896 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54897 = ["?p","?ctx",inst_54893];
var inst_54898 = cljs.core.PersistentHashMap.fromArrays(inst_54896,inst_54897);
var inst_54899 = ((10) + inst_54894);
var inst_54900 = [inst_54898,inst_54899];
var inst_54901 = (new cljs.core.PersistentVector(null,2,(5),inst_54895,inst_54900,null));
var inst_54902 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54901);
var state_54911__$1 = (function (){var statearr_54920 = state_54911;
(statearr_54920[(7)] = inst_54902);

return statearr_54920;
})();
var statearr_54921_54938 = state_54911__$1;
(statearr_54921_54938[(2)] = inst_54893);

(statearr_54921_54938[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54912 === (5))){
var _ = (function (){var statearr_54922 = state_54911;
(statearr_54922[(4)] = cljs.core.rest((state_54911[(4)])));

return statearr_54922;
})();
var state_54911__$1 = state_54911;
var ex54916 = (state_54911__$1[(2)]);
var statearr_54923_54939 = state_54911__$1;
(statearr_54923_54939[(5)] = ex54916);


if((ex54916 instanceof Error)){
var statearr_54924_54940 = state_54911__$1;
(statearr_54924_54940[(1)] = (4));

(statearr_54924_54940[(5)] = null);

} else {
throw ex54916;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54912 === (10))){
var inst_54887 = (state_54911[(2)]);
var inst_54888 = fluree.db.util.async.throw_err(inst_54887);
var inst_54889 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_54888);
var state_54911__$1 = state_54911;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54911__$1,(9),inst_54889);
} else {
if((state_val_54912 === (8))){
var inst_54906 = (state_54911[(2)]);
var _ = (function (){var statearr_54925 = state_54911;
(statearr_54925[(4)] = cljs.core.rest((state_54911[(4)])));

return statearr_54925;
})();
var state_54911__$1 = state_54911;
var statearr_54926_54941 = state_54911__$1;
(statearr_54926_54941[(2)] = inst_54906);

(statearr_54926_54941[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2749__auto____0 = (function (){
var statearr_54927 = [null,null,null,null,null,null,null,null];
(statearr_54927[(0)] = fluree$db$dbfunctions$fns$state_machine__2749__auto__);

(statearr_54927[(1)] = (1));

return statearr_54927;
});
var fluree$db$dbfunctions$fns$state_machine__2749__auto____1 = (function (state_54911){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_54911);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e54928){var ex__2752__auto__ = e54928;
var statearr_54929_54942 = state_54911;
(statearr_54929_54942[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_54911[(4)]))){
var statearr_54930_54943 = state_54911;
(statearr_54930_54943[(1)] = cljs.core.first((state_54911[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54944 = state_54911;
state_54911 = G__54944;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2749__auto__ = function(state_54911){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____1.call(this,state_54911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_54931 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_54931[(6)] = c__2771__auto__);

return statearr_54931;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__5774__auto__ = [];
var len__5768__auto___54993 = arguments.length;
var i__5769__auto___54994 = (0);
while(true){
if((i__5769__auto___54994 < len__5768__auto___54993)){
args__5774__auto__.push((arguments[i__5769__auto___54994]));

var G__54995 = (i__5769__auto___54994 + (1));
i__5769__auto___54994 = G__54995;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_54976){
var state_val_54977 = (state_54976[(1)]);
if((state_val_54977 === (1))){
var state_54976__$1 = state_54976;
var statearr_54978_54996 = state_54976__$1;
(statearr_54978_54996[(2)] = null);

(statearr_54978_54996[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (2))){
var _ = (function (){var statearr_54979 = state_54976;
(statearr_54979[(4)] = cljs.core.cons((5),(state_54976[(4)])));

return statearr_54979;
})();
var inst_54953 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54976__$1 = state_54976;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54976__$1,(6),inst_54953);
} else {
if((state_val_54977 === (3))){
var inst_54974 = (state_54976[(2)]);
var state_54976__$1 = state_54976;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54976__$1,inst_54974);
} else {
if((state_val_54977 === (4))){
var inst_54947 = (state_54976[(2)]);
var state_54976__$1 = state_54976;
var statearr_54981_54997 = state_54976__$1;
(statearr_54981_54997[(2)] = inst_54947);

(statearr_54981_54997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (5))){
var _ = (function (){var statearr_54982 = state_54976;
(statearr_54982[(4)] = cljs.core.rest((state_54976[(4)])));

return statearr_54982;
})();
var state_54976__$1 = state_54976;
var ex54980 = (state_54976__$1[(2)]);
var statearr_54983_54998 = state_54976__$1;
(statearr_54983_54998[(5)] = ex54980);


if((ex54980 instanceof Error)){
var statearr_54984_54999 = state_54976__$1;
(statearr_54984_54999[(1)] = (4));

(statearr_54984_54999[(5)] = null);

} else {
throw ex54980;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54977 === (6))){
var inst_54955 = (state_54976[(2)]);
var inst_54956 = fluree.db.util.async.throw_err(inst_54955);
var inst_54957 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_54956);
var inst_54958 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54959 = [inst_54956];
var inst_54960 = (new cljs.core.PersistentVector(null,1,(5),inst_54958,inst_54959,null));
var inst_54961 = cljs.core.count(inst_54960);
var inst_54962 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54963 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54965 = [inst_54956];
var inst_54966 = (new cljs.core.PersistentVector(null,1,(5),inst_54964,inst_54965,null));
var inst_54967 = ["and",inst_54966,inst_54957];
var inst_54968 = cljs.core.PersistentHashMap.fromArrays(inst_54963,inst_54967);
var inst_54969 = [inst_54968,inst_54961];
var inst_54970 = (new cljs.core.PersistentVector(null,2,(5),inst_54962,inst_54969,null));
var inst_54971 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54970);
var _ = (function (){var statearr_54985 = state_54976;
(statearr_54985[(4)] = cljs.core.rest((state_54976[(4)])));

return statearr_54985;
})();
var state_54976__$1 = (function (){var statearr_54986 = state_54976;
(statearr_54986[(7)] = inst_54971);

return statearr_54986;
})();
var statearr_54987_55000 = state_54976__$1;
(statearr_54987_55000[(2)] = inst_54957);

(statearr_54987_55000[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2749__auto____0 = (function (){
var statearr_54988 = [null,null,null,null,null,null,null,null];
(statearr_54988[(0)] = fluree$db$dbfunctions$fns$state_machine__2749__auto__);

(statearr_54988[(1)] = (1));

return statearr_54988;
});
var fluree$db$dbfunctions$fns$state_machine__2749__auto____1 = (function (state_54976){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_54976);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e54989){var ex__2752__auto__ = e54989;
var statearr_54990_55001 = state_54976;
(statearr_54990_55001[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_54976[(4)]))){
var statearr_54991_55002 = state_54976;
(statearr_54991_55002[(1)] = cljs.core.first((state_54976[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55003 = state_54976;
state_54976 = G__55003;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2749__auto__ = function(state_54976){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____1.call(this,state_54976);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_54992 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_54992[(6)] = c__2771__auto__);

return statearr_54992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq54945){
var G__54946 = cljs.core.first(seq54945);
var seq54945__$1 = cljs.core.next(seq54945);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54946,seq54945__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__5774__auto__ = [];
var len__5768__auto___55052 = arguments.length;
var i__5769__auto___55053 = (0);
while(true){
if((i__5769__auto___55053 < len__5768__auto___55052)){
args__5774__auto__.push((arguments[i__5769__auto___55053]));

var G__55054 = (i__5769__auto___55053 + (1));
i__5769__auto___55053 = G__55054;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_55035){
var state_val_55036 = (state_55035[(1)]);
if((state_val_55036 === (1))){
var state_55035__$1 = state_55035;
var statearr_55037_55055 = state_55035__$1;
(statearr_55037_55055[(2)] = null);

(statearr_55037_55055[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55036 === (2))){
var _ = (function (){var statearr_55038 = state_55035;
(statearr_55038[(4)] = cljs.core.cons((5),(state_55035[(4)])));

return statearr_55038;
})();
var inst_55012 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55035__$1 = state_55035;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55035__$1,(6),inst_55012);
} else {
if((state_val_55036 === (3))){
var inst_55033 = (state_55035[(2)]);
var state_55035__$1 = state_55035;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55035__$1,inst_55033);
} else {
if((state_val_55036 === (4))){
var inst_55006 = (state_55035[(2)]);
var state_55035__$1 = state_55035;
var statearr_55040_55056 = state_55035__$1;
(statearr_55040_55056[(2)] = inst_55006);

(statearr_55040_55056[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55036 === (5))){
var _ = (function (){var statearr_55041 = state_55035;
(statearr_55041[(4)] = cljs.core.rest((state_55035[(4)])));

return statearr_55041;
})();
var state_55035__$1 = state_55035;
var ex55039 = (state_55035__$1[(2)]);
var statearr_55042_55057 = state_55035__$1;
(statearr_55042_55057[(5)] = ex55039);


if((ex55039 instanceof Error)){
var statearr_55043_55058 = state_55035__$1;
(statearr_55043_55058[(1)] = (4));

(statearr_55043_55058[(5)] = null);

} else {
throw ex55039;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55036 === (6))){
var inst_55014 = (state_55035[(2)]);
var inst_55015 = fluree.db.util.async.throw_err(inst_55014);
var inst_55016 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_55015);
var inst_55017 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55018 = [inst_55015];
var inst_55019 = (new cljs.core.PersistentVector(null,1,(5),inst_55017,inst_55018,null));
var inst_55020 = cljs.core.count(inst_55019);
var inst_55021 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55022 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55023 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55024 = [inst_55015];
var inst_55025 = (new cljs.core.PersistentVector(null,1,(5),inst_55023,inst_55024,null));
var inst_55026 = ["or",inst_55025,inst_55016];
var inst_55027 = cljs.core.PersistentHashMap.fromArrays(inst_55022,inst_55026);
var inst_55028 = [inst_55027,inst_55020];
var inst_55029 = (new cljs.core.PersistentVector(null,2,(5),inst_55021,inst_55028,null));
var inst_55030 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55029);
var _ = (function (){var statearr_55044 = state_55035;
(statearr_55044[(4)] = cljs.core.rest((state_55035[(4)])));

return statearr_55044;
})();
var state_55035__$1 = (function (){var statearr_55045 = state_55035;
(statearr_55045[(7)] = inst_55030);

return statearr_55045;
})();
var statearr_55046_55059 = state_55035__$1;
(statearr_55046_55059[(2)] = inst_55016);

(statearr_55046_55059[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2749__auto____0 = (function (){
var statearr_55047 = [null,null,null,null,null,null,null,null];
(statearr_55047[(0)] = fluree$db$dbfunctions$fns$state_machine__2749__auto__);

(statearr_55047[(1)] = (1));

return statearr_55047;
});
var fluree$db$dbfunctions$fns$state_machine__2749__auto____1 = (function (state_55035){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_55035);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e55048){var ex__2752__auto__ = e55048;
var statearr_55049_55060 = state_55035;
(statearr_55049_55060[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_55035[(4)]))){
var statearr_55050_55061 = state_55035;
(statearr_55050_55061[(1)] = cljs.core.first((state_55035[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55062 = state_55035;
state_55035 = G__55062;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2749__auto__ = function(state_55035){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____1.call(this,state_55035);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_55051 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_55051[(6)] = c__2771__auto__);

return statearr_55051;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq55004){
var G__55005 = cljs.core.first(seq55004);
var seq55004__$1 = cljs.core.next(seq55004);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55005,seq55004__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_55100){
var state_val_55101 = (state_55100[(1)]);
if((state_val_55101 === (7))){
var inst_55076 = fluree.db.util.async.channel_QMARK_(coll);
var state_55100__$1 = state_55100;
if(inst_55076){
var statearr_55102_55125 = state_55100__$1;
(statearr_55102_55125[(1)] = (10));

} else {
var statearr_55103_55126 = state_55100__$1;
(statearr_55103_55126[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55101 === (1))){
var state_55100__$1 = state_55100;
var statearr_55104_55127 = state_55100__$1;
(statearr_55104_55127[(2)] = null);

(statearr_55104_55127[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55101 === (4))){
var inst_55063 = (state_55100[(2)]);
var state_55100__$1 = state_55100;
var statearr_55105_55128 = state_55100__$1;
(statearr_55105_55128[(2)] = inst_55063);

(statearr_55105_55128[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55101 === (13))){
var inst_55079 = (state_55100[(2)]);
var inst_55080 = fluree.db.util.async.throw_err(inst_55079);
var state_55100__$1 = state_55100;
var statearr_55106_55129 = state_55100__$1;
(statearr_55106_55129[(2)] = inst_55080);

(statearr_55106_55129[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55101 === (6))){
var inst_55071 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_55100__$1 = state_55100;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55100__$1,(9),inst_55071);
} else {
if((state_val_55101 === (3))){
var inst_55098 = (state_55100[(2)]);
var state_55100__$1 = state_55100;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55100__$1,inst_55098);
} else {
if((state_val_55101 === (12))){
var inst_55083 = (state_55100[(2)]);
var state_55100__$1 = state_55100;
var statearr_55107_55130 = state_55100__$1;
(statearr_55107_55130[(2)] = inst_55083);

(statearr_55107_55130[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55101 === (2))){
var _ = (function (){var statearr_55108 = state_55100;
(statearr_55108[(4)] = cljs.core.cons((5),(state_55100[(4)])));

return statearr_55108;
})();
var inst_55069 = cljs.core.vector_QMARK_(coll);
var state_55100__$1 = state_55100;
if(inst_55069){
var statearr_55109_55131 = state_55100__$1;
(statearr_55109_55131[(1)] = (6));

} else {
var statearr_55110_55132 = state_55100__$1;
(statearr_55110_55132[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55101 === (11))){
var state_55100__$1 = state_55100;
var statearr_55112_55133 = state_55100__$1;
(statearr_55112_55133[(2)] = coll);

(statearr_55112_55133[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55101 === (9))){
var inst_55073 = (state_55100[(2)]);
var inst_55074 = fluree.db.util.async.throw_err(inst_55073);
var state_55100__$1 = state_55100;
var statearr_55113_55134 = state_55100__$1;
(statearr_55113_55134[(2)] = inst_55074);

(statearr_55113_55134[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55101 === (5))){
var _ = (function (){var statearr_55114 = state_55100;
(statearr_55114[(4)] = cljs.core.rest((state_55100[(4)])));

return statearr_55114;
})();
var state_55100__$1 = state_55100;
var ex55111 = (state_55100__$1[(2)]);
var statearr_55115_55135 = state_55100__$1;
(statearr_55115_55135[(5)] = ex55111);


if((ex55111 instanceof Error)){
var statearr_55116_55136 = state_55100__$1;
(statearr_55116_55136[(1)] = (4));

(statearr_55116_55136[(5)] = null);

} else {
throw ex55111;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55101 === (10))){
var state_55100__$1 = state_55100;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55100__$1,(13),coll);
} else {
if((state_val_55101 === (8))){
var inst_55085 = (state_55100[(2)]);
var inst_55086 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_55085);
var inst_55087 = cljs.core.count(inst_55086);
var inst_55088 = ((9) + inst_55087);
var inst_55089 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55090 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55091 = ["count",inst_55085,inst_55087];
var inst_55092 = cljs.core.PersistentHashMap.fromArrays(inst_55090,inst_55091);
var inst_55093 = [inst_55092,inst_55088];
var inst_55094 = (new cljs.core.PersistentVector(null,2,(5),inst_55089,inst_55093,null));
var inst_55095 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55094);
var _ = (function (){var statearr_55117 = state_55100;
(statearr_55117[(4)] = cljs.core.rest((state_55100[(4)])));

return statearr_55117;
})();
var state_55100__$1 = (function (){var statearr_55118 = state_55100;
(statearr_55118[(7)] = inst_55095);

return statearr_55118;
})();
var statearr_55119_55137 = state_55100__$1;
(statearr_55119_55137[(2)] = inst_55087);

(statearr_55119_55137[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2749__auto____0 = (function (){
var statearr_55120 = [null,null,null,null,null,null,null,null];
(statearr_55120[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2749__auto__);

(statearr_55120[(1)] = (1));

return statearr_55120;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2749__auto____1 = (function (state_55100){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_55100);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e55121){var ex__2752__auto__ = e55121;
var statearr_55122_55138 = state_55100;
(statearr_55122_55138[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_55100[(4)]))){
var statearr_55123_55139 = state_55100;
(statearr_55123_55139[(1)] = cljs.core.first((state_55100[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55140 = state_55100;
state_55100 = G__55140;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2749__auto__ = function(state_55100){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2749__auto____1.call(this,state_55100);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_55124 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_55124[(6)] = c__2771__auto__);

return statearr_55124;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_55190){
var state_val_55191 = (state_55190[(1)]);
if((state_val_55191 === (7))){
var state_55190__$1 = state_55190;
var statearr_55192_55225 = state_55190__$1;
(statearr_55192_55225[(2)] = subject);

(statearr_55192_55225[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55191 === (1))){
var state_55190__$1 = state_55190;
var statearr_55193_55226 = state_55190__$1;
(statearr_55193_55226[(2)] = null);

(statearr_55193_55226[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55191 === (4))){
var inst_55141 = (state_55190[(2)]);
var state_55190__$1 = state_55190;
var statearr_55194_55227 = state_55190__$1;
(statearr_55194_55227[(2)] = inst_55141);

(statearr_55194_55227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55191 === (15))){
var inst_55154 = (state_55190[(7)]);
var state_55190__$1 = state_55190;
var statearr_55195_55228 = state_55190__$1;
(statearr_55195_55228[(2)] = inst_55154);

(statearr_55195_55228[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55191 === (13))){
var inst_55158 = (state_55190[(2)]);
var inst_55159 = fluree.db.util.async.throw_err(inst_55158);
var state_55190__$1 = state_55190;
var statearr_55196_55229 = state_55190__$1;
(statearr_55196_55229[(2)] = inst_55159);

(statearr_55196_55229[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55191 === (6))){
var state_55190__$1 = state_55190;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55190__$1,(9),subject);
} else {
if((state_val_55191 === (17))){
var inst_55154 = (state_55190[(7)]);
var inst_55168 = cljs.core.first(inst_55154);
var state_55190__$1 = state_55190;
var statearr_55197_55230 = state_55190__$1;
(statearr_55197_55230[(2)] = inst_55168);

(statearr_55197_55230[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55191 === (3))){
var inst_55188 = (state_55190[(2)]);
var state_55190__$1 = state_55190;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55190__$1,inst_55188);
} else {
if((state_val_55191 === (12))){
var inst_55154 = (state_55190[(7)]);
var inst_55162 = (state_55190[(2)]);
var inst_55163 = cljs.core.vector_QMARK_(inst_55154);
var state_55190__$1 = (function (){var statearr_55198 = state_55190;
(statearr_55198[(8)] = inst_55162);

return statearr_55198;
})();
if(inst_55163){
var statearr_55199_55231 = state_55190__$1;
(statearr_55199_55231[(1)] = (14));

} else {
var statearr_55200_55232 = state_55190__$1;
(statearr_55200_55232[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55191 === (2))){
var _ = (function (){var statearr_55201 = state_55190;
(statearr_55201[(4)] = cljs.core.cons((5),(state_55190[(4)])));

return statearr_55201;
})();
var inst_55147 = fluree.db.util.async.channel_QMARK_(subject);
var state_55190__$1 = state_55190;
if(inst_55147){
var statearr_55202_55233 = state_55190__$1;
(statearr_55202_55233[(1)] = (6));

} else {
var statearr_55203_55234 = state_55190__$1;
(statearr_55203_55234[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55191 === (19))){
var inst_55171 = (state_55190[(2)]);
var state_55190__$1 = state_55190;
var statearr_55204_55235 = state_55190__$1;
(statearr_55204_55235[(2)] = inst_55171);

(statearr_55204_55235[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55191 === (11))){
var state_55190__$1 = state_55190;
var statearr_55206_55236 = state_55190__$1;
(statearr_55206_55236[(2)] = pred);

(statearr_55206_55236[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55191 === (9))){
var inst_55150 = (state_55190[(2)]);
var inst_55151 = fluree.db.util.async.throw_err(inst_55150);
var state_55190__$1 = state_55190;
var statearr_55207_55237 = state_55190__$1;
(statearr_55207_55237[(2)] = inst_55151);

(statearr_55207_55237[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55191 === (5))){
var _ = (function (){var statearr_55208 = state_55190;
(statearr_55208[(4)] = cljs.core.rest((state_55190[(4)])));

return statearr_55208;
})();
var state_55190__$1 = state_55190;
var ex55205 = (state_55190__$1[(2)]);
var statearr_55209_55238 = state_55190__$1;
(statearr_55209_55238[(5)] = ex55205);


if((ex55205 instanceof Error)){
var statearr_55210_55239 = state_55190__$1;
(statearr_55210_55239[(1)] = (4));

(statearr_55210_55239[(5)] = null);

} else {
throw ex55205;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55191 === (14))){
var inst_55154 = (state_55190[(7)]);
var inst_55165 = cljs.core.count(inst_55154);
var inst_55166 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_55165);
var state_55190__$1 = state_55190;
if(inst_55166){
var statearr_55211_55240 = state_55190__$1;
(statearr_55211_55240[(1)] = (17));

} else {
var statearr_55212_55241 = state_55190__$1;
(statearr_55212_55241[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55191 === (16))){
var inst_55162 = (state_55190[(8)]);
var inst_55154 = (state_55190[(7)]);
var inst_55174 = (state_55190[(2)]);
var inst_55175 = fluree.db.dbfunctions.internal.get(inst_55174,inst_55162);
var inst_55176 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55177 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55178 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55179 = [inst_55154,inst_55162];
var inst_55180 = (new cljs.core.PersistentVector(null,2,(5),inst_55178,inst_55179,null));
var inst_55181 = ["get",inst_55180,inst_55175];
var inst_55182 = cljs.core.PersistentHashMap.fromArrays(inst_55177,inst_55181);
var inst_55183 = [inst_55182,(10)];
var inst_55184 = (new cljs.core.PersistentVector(null,2,(5),inst_55176,inst_55183,null));
var inst_55185 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55184);
var _ = (function (){var statearr_55213 = state_55190;
(statearr_55213[(4)] = cljs.core.rest((state_55190[(4)])));

return statearr_55213;
})();
var state_55190__$1 = (function (){var statearr_55214 = state_55190;
(statearr_55214[(9)] = inst_55185);

return statearr_55214;
})();
var statearr_55215_55242 = state_55190__$1;
(statearr_55215_55242[(2)] = inst_55175);

(statearr_55215_55242[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55191 === (10))){
var state_55190__$1 = state_55190;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55190__$1,(13),pred);
} else {
if((state_val_55191 === (18))){
var inst_55154 = (state_55190[(7)]);
var state_55190__$1 = state_55190;
var statearr_55216_55243 = state_55190__$1;
(statearr_55216_55243[(2)] = inst_55154);

(statearr_55216_55243[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55191 === (8))){
var inst_55154 = (state_55190[(2)]);
var inst_55155 = fluree.db.util.async.channel_QMARK_(pred);
var state_55190__$1 = (function (){var statearr_55217 = state_55190;
(statearr_55217[(7)] = inst_55154);

return statearr_55217;
})();
if(inst_55155){
var statearr_55218_55244 = state_55190__$1;
(statearr_55218_55244[(1)] = (10));

} else {
var statearr_55219_55245 = state_55190__$1;
(statearr_55219_55245[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2749__auto____0 = (function (){
var statearr_55220 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55220[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2749__auto__);

(statearr_55220[(1)] = (1));

return statearr_55220;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2749__auto____1 = (function (state_55190){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_55190);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e55221){var ex__2752__auto__ = e55221;
var statearr_55222_55246 = state_55190;
(statearr_55222_55246[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_55190[(4)]))){
var statearr_55223_55247 = state_55190;
(statearr_55223_55247[(1)] = cljs.core.first((state_55190[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55248 = state_55190;
state_55190 = G__55248;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2749__auto__ = function(state_55190){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2749__auto____1.call(this,state_55190);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_55224 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_55224[(6)] = c__2771__auto__);

return statearr_55224;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_55287){
var state_val_55288 = (state_55287[(1)]);
if((state_val_55288 === (7))){
var inst_55255 = (state_55287[(7)]);
var state_55287__$1 = state_55287;
var statearr_55289_55313 = state_55287__$1;
(statearr_55289_55313[(2)] = inst_55255);

(statearr_55289_55313[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55288 === (1))){
var state_55287__$1 = state_55287;
var statearr_55290_55314 = state_55287__$1;
(statearr_55290_55314[(2)] = null);

(statearr_55290_55314[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55288 === (4))){
var inst_55249 = (state_55287[(2)]);
var state_55287__$1 = state_55287;
var statearr_55291_55315 = state_55287__$1;
(statearr_55291_55315[(2)] = inst_55249);

(statearr_55291_55315[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55288 === (6))){
var inst_55257 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55287__$1 = state_55287;
var statearr_55292_55316 = state_55287__$1;
(statearr_55292_55316[(2)] = inst_55257);

(statearr_55292_55316[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55288 === (3))){
var inst_55285 = (state_55287[(2)]);
var state_55287__$1 = state_55287;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55287__$1,inst_55285);
} else {
if((state_val_55288 === (12))){
var inst_55267 = (state_55287[(2)]);
var inst_55268 = fluree.db.util.async.throw_err(inst_55267);
var inst_55269 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55268,(0),null);
var inst_55270 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55268,(1),null);
var inst_55271 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55272 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55273 = ["?pO","?ctx",inst_55269];
var inst_55274 = cljs.core.PersistentHashMap.fromArrays(inst_55272,inst_55273);
var inst_55275 = ((10) + inst_55270);
var inst_55276 = [inst_55274,inst_55275];
var inst_55277 = (new cljs.core.PersistentVector(null,2,(5),inst_55271,inst_55276,null));
var inst_55278 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55277);
var state_55287__$1 = (function (){var statearr_55293 = state_55287;
(statearr_55293[(8)] = inst_55278);

return statearr_55293;
})();
var statearr_55294_55317 = state_55287__$1;
(statearr_55294_55317[(2)] = inst_55269);

(statearr_55294_55317[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55288 === (2))){
var inst_55255 = (state_55287[(7)]);
var _ = (function (){var statearr_55295 = state_55287;
(statearr_55295[(4)] = cljs.core.cons((5),(state_55287[(4)])));

return statearr_55295;
})();
var inst_55255__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55287__$1 = (function (){var statearr_55296 = state_55287;
(statearr_55296[(7)] = inst_55255__$1);

return statearr_55296;
})();
if(cljs.core.truth_(inst_55255__$1)){
var statearr_55297_55318 = state_55287__$1;
(statearr_55297_55318[(1)] = (6));

} else {
var statearr_55298_55319 = state_55287__$1;
(statearr_55298_55319[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55288 === (11))){
var inst_55282 = (state_55287[(2)]);
var _ = (function (){var statearr_55300 = state_55287;
(statearr_55300[(4)] = cljs.core.rest((state_55287[(4)])));

return statearr_55300;
})();
var state_55287__$1 = state_55287;
var statearr_55301_55320 = state_55287__$1;
(statearr_55301_55320[(2)] = inst_55282);

(statearr_55301_55320[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55288 === (9))){
var inst_55265 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_55287__$1 = state_55287;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55287__$1,(12),inst_55265);
} else {
if((state_val_55288 === (5))){
var _ = (function (){var statearr_55302 = state_55287;
(statearr_55302[(4)] = cljs.core.rest((state_55287[(4)])));

return statearr_55302;
})();
var state_55287__$1 = state_55287;
var ex55299 = (state_55287__$1[(2)]);
var statearr_55303_55321 = state_55287__$1;
(statearr_55303_55321[(5)] = ex55299);


if((ex55299 instanceof Error)){
var statearr_55304_55322 = state_55287__$1;
(statearr_55304_55322[(1)] = (4));

(statearr_55304_55322[(5)] = null);

} else {
throw ex55299;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55288 === (10))){
var inst_55280 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_55287__$1 = state_55287;
var statearr_55305_55323 = state_55287__$1;
(statearr_55305_55323[(2)] = inst_55280);

(statearr_55305_55323[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55288 === (8))){
var inst_55260 = (state_55287[(2)]);
var state_55287__$1 = state_55287;
if(cljs.core.truth_(inst_55260)){
var statearr_55306_55324 = state_55287__$1;
(statearr_55306_55324[(1)] = (9));

} else {
var statearr_55307_55325 = state_55287__$1;
(statearr_55307_55325[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2749__auto____0 = (function (){
var statearr_55308 = [null,null,null,null,null,null,null,null,null];
(statearr_55308[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2749__auto__);

(statearr_55308[(1)] = (1));

return statearr_55308;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2749__auto____1 = (function (state_55287){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_55287);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e55309){var ex__2752__auto__ = e55309;
var statearr_55310_55326 = state_55287;
(statearr_55310_55326[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_55287[(4)]))){
var statearr_55311_55327 = state_55287;
(statearr_55311_55327[(1)] = cljs.core.first((state_55287[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55328 = state_55287;
state_55287 = G__55328;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2749__auto__ = function(state_55287){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2749__auto____1.call(this,state_55287);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_55312 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_55312[(6)] = c__2771__auto__);

return statearr_55312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_55380){
var state_val_55381 = (state_55380[(1)]);
if((state_val_55381 === (7))){
var state_55380__$1 = state_55380;
var statearr_55382_55415 = state_55380__$1;
(statearr_55382_55415[(2)] = subject);

(statearr_55382_55415[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55381 === (1))){
var state_55380__$1 = state_55380;
var statearr_55383_55416 = state_55380__$1;
(statearr_55383_55416[(2)] = null);

(statearr_55383_55416[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55381 === (4))){
var inst_55329 = (state_55380[(2)]);
var state_55380__$1 = state_55380;
var statearr_55384_55417 = state_55380__$1;
(statearr_55384_55417[(2)] = inst_55329);

(statearr_55384_55417[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55381 === (15))){
var inst_55342 = (state_55380[(7)]);
var state_55380__$1 = state_55380;
var statearr_55385_55418 = state_55380__$1;
(statearr_55385_55418[(2)] = inst_55342);

(statearr_55385_55418[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55381 === (13))){
var inst_55346 = (state_55380[(2)]);
var inst_55347 = fluree.db.util.async.throw_err(inst_55346);
var state_55380__$1 = state_55380;
var statearr_55386_55419 = state_55380__$1;
(statearr_55386_55419[(2)] = inst_55347);

(statearr_55386_55419[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55381 === (6))){
var state_55380__$1 = state_55380;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55380__$1,(9),subject);
} else {
if((state_val_55381 === (17))){
var inst_55342 = (state_55380[(7)]);
var inst_55356 = cljs.core.first(inst_55342);
var state_55380__$1 = state_55380;
var statearr_55387_55420 = state_55380__$1;
(statearr_55387_55420[(2)] = inst_55356);

(statearr_55387_55420[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55381 === (3))){
var inst_55378 = (state_55380[(2)]);
var state_55380__$1 = state_55380;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55380__$1,inst_55378);
} else {
if((state_val_55381 === (12))){
var inst_55342 = (state_55380[(7)]);
var inst_55350 = (state_55380[(2)]);
var inst_55351 = cljs.core.vector_QMARK_(inst_55342);
var state_55380__$1 = (function (){var statearr_55388 = state_55380;
(statearr_55388[(8)] = inst_55350);

return statearr_55388;
})();
if(inst_55351){
var statearr_55389_55421 = state_55380__$1;
(statearr_55389_55421[(1)] = (14));

} else {
var statearr_55390_55422 = state_55380__$1;
(statearr_55390_55422[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55381 === (2))){
var _ = (function (){var statearr_55391 = state_55380;
(statearr_55391[(4)] = cljs.core.cons((5),(state_55380[(4)])));

return statearr_55391;
})();
var inst_55335 = fluree.db.util.async.channel_QMARK_(subject);
var state_55380__$1 = state_55380;
if(inst_55335){
var statearr_55392_55423 = state_55380__$1;
(statearr_55392_55423[(1)] = (6));

} else {
var statearr_55393_55424 = state_55380__$1;
(statearr_55393_55424[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55381 === (19))){
var inst_55359 = (state_55380[(2)]);
var state_55380__$1 = state_55380;
var statearr_55394_55425 = state_55380__$1;
(statearr_55394_55425[(2)] = inst_55359);

(statearr_55394_55425[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55381 === (11))){
var state_55380__$1 = state_55380;
var statearr_55396_55426 = state_55380__$1;
(statearr_55396_55426[(2)] = path);

(statearr_55396_55426[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55381 === (9))){
var inst_55338 = (state_55380[(2)]);
var inst_55339 = fluree.db.util.async.throw_err(inst_55338);
var state_55380__$1 = state_55380;
var statearr_55397_55427 = state_55380__$1;
(statearr_55397_55427[(2)] = inst_55339);

(statearr_55397_55427[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55381 === (5))){
var _ = (function (){var statearr_55398 = state_55380;
(statearr_55398[(4)] = cljs.core.rest((state_55380[(4)])));

return statearr_55398;
})();
var state_55380__$1 = state_55380;
var ex55395 = (state_55380__$1[(2)]);
var statearr_55399_55428 = state_55380__$1;
(statearr_55399_55428[(5)] = ex55395);


if((ex55395 instanceof Error)){
var statearr_55400_55429 = state_55380__$1;
(statearr_55400_55429[(1)] = (4));

(statearr_55400_55429[(5)] = null);

} else {
throw ex55395;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55381 === (14))){
var inst_55342 = (state_55380[(7)]);
var inst_55353 = cljs.core.count(inst_55342);
var inst_55354 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_55353);
var state_55380__$1 = state_55380;
if(inst_55354){
var statearr_55401_55430 = state_55380__$1;
(statearr_55401_55430[(1)] = (17));

} else {
var statearr_55402_55431 = state_55380__$1;
(statearr_55402_55431[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55381 === (16))){
var inst_55350 = (state_55380[(8)]);
var inst_55342 = (state_55380[(7)]);
var inst_55362 = (state_55380[(2)]);
var inst_55363 = fluree.db.dbfunctions.internal.get_all(inst_55362,inst_55350);
var inst_55364 = cljs.core.count(inst_55350);
var inst_55365 = ((9) + inst_55364);
var inst_55366 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55367 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55368 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55369 = [inst_55342,inst_55350];
var inst_55370 = (new cljs.core.PersistentVector(null,2,(5),inst_55368,inst_55369,null));
var inst_55371 = ["get-all",inst_55370,inst_55363];
var inst_55372 = cljs.core.PersistentHashMap.fromArrays(inst_55367,inst_55371);
var inst_55373 = [inst_55372,inst_55365];
var inst_55374 = (new cljs.core.PersistentVector(null,2,(5),inst_55366,inst_55373,null));
var inst_55375 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55374);
var _ = (function (){var statearr_55403 = state_55380;
(statearr_55403[(4)] = cljs.core.rest((state_55380[(4)])));

return statearr_55403;
})();
var state_55380__$1 = (function (){var statearr_55404 = state_55380;
(statearr_55404[(9)] = inst_55375);

return statearr_55404;
})();
var statearr_55405_55432 = state_55380__$1;
(statearr_55405_55432[(2)] = inst_55363);

(statearr_55405_55432[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55381 === (10))){
var state_55380__$1 = state_55380;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55380__$1,(13),path);
} else {
if((state_val_55381 === (18))){
var inst_55342 = (state_55380[(7)]);
var state_55380__$1 = state_55380;
var statearr_55406_55433 = state_55380__$1;
(statearr_55406_55433[(2)] = inst_55342);

(statearr_55406_55433[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55381 === (8))){
var inst_55342 = (state_55380[(2)]);
var inst_55343 = fluree.db.util.async.channel_QMARK_(path);
var state_55380__$1 = (function (){var statearr_55407 = state_55380;
(statearr_55407[(7)] = inst_55342);

return statearr_55407;
})();
if(inst_55343){
var statearr_55408_55434 = state_55380__$1;
(statearr_55408_55434[(1)] = (10));

} else {
var statearr_55409_55435 = state_55380__$1;
(statearr_55409_55435[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2749__auto____0 = (function (){
var statearr_55410 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55410[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2749__auto__);

(statearr_55410[(1)] = (1));

return statearr_55410;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2749__auto____1 = (function (state_55380){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_55380);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e55411){var ex__2752__auto__ = e55411;
var statearr_55412_55436 = state_55380;
(statearr_55412_55436[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_55380[(4)]))){
var statearr_55413_55437 = state_55380;
(statearr_55413_55437[(1)] = cljs.core.first((state_55380[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55438 = state_55380;
state_55380 = G__55438;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2749__auto__ = function(state_55380){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2749__auto____1.call(this,state_55380);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_55414 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_55414[(6)] = c__2771__auto__);

return statearr_55414;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_55477){
var state_val_55478 = (state_55477[(1)]);
if((state_val_55478 === (7))){
var state_55477__$1 = state_55477;
var statearr_55479_55503 = state_55477__$1;
(statearr_55479_55503[(2)] = subject);

(statearr_55479_55503[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55478 === (1))){
var state_55477__$1 = state_55477;
var statearr_55480_55504 = state_55477__$1;
(statearr_55480_55504[(2)] = null);

(statearr_55480_55504[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55478 === (4))){
var inst_55439 = (state_55477[(2)]);
var state_55477__$1 = state_55477;
var statearr_55481_55505 = state_55477__$1;
(statearr_55481_55505[(2)] = inst_55439);

(statearr_55481_55505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55478 === (13))){
var inst_55456 = (state_55477[(2)]);
var inst_55457 = fluree.db.util.async.throw_err(inst_55456);
var state_55477__$1 = state_55477;
var statearr_55482_55506 = state_55477__$1;
(statearr_55482_55506[(2)] = inst_55457);

(statearr_55482_55506[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55478 === (6))){
var state_55477__$1 = state_55477;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55477__$1,(9),subject);
} else {
if((state_val_55478 === (3))){
var inst_55475 = (state_55477[(2)]);
var state_55477__$1 = state_55477;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55477__$1,inst_55475);
} else {
if((state_val_55478 === (12))){
var inst_55452 = (state_55477[(7)]);
var inst_55460 = (state_55477[(2)]);
var inst_55461 = fluree.db.dbfunctions.internal.get_in(inst_55452,inst_55460);
var inst_55462 = cljs.core.count(inst_55460);
var inst_55463 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55464 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55465 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55466 = [inst_55452,inst_55460];
var inst_55467 = (new cljs.core.PersistentVector(null,2,(5),inst_55465,inst_55466,null));
var inst_55468 = ["get-in",inst_55467,inst_55461];
var inst_55469 = cljs.core.PersistentHashMap.fromArrays(inst_55464,inst_55468);
var inst_55470 = [inst_55469,inst_55462];
var inst_55471 = (new cljs.core.PersistentVector(null,2,(5),inst_55463,inst_55470,null));
var inst_55472 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55471);
var _ = (function (){var statearr_55483 = state_55477;
(statearr_55483[(4)] = cljs.core.rest((state_55477[(4)])));

return statearr_55483;
})();
var state_55477__$1 = (function (){var statearr_55484 = state_55477;
(statearr_55484[(8)] = inst_55472);

return statearr_55484;
})();
var statearr_55485_55507 = state_55477__$1;
(statearr_55485_55507[(2)] = inst_55461);

(statearr_55485_55507[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55478 === (2))){
var _ = (function (){var statearr_55486 = state_55477;
(statearr_55486[(4)] = cljs.core.cons((5),(state_55477[(4)])));

return statearr_55486;
})();
var inst_55445 = fluree.db.util.async.channel_QMARK_(subject);
var state_55477__$1 = state_55477;
if(inst_55445){
var statearr_55487_55508 = state_55477__$1;
(statearr_55487_55508[(1)] = (6));

} else {
var statearr_55488_55509 = state_55477__$1;
(statearr_55488_55509[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55478 === (11))){
var state_55477__$1 = state_55477;
var statearr_55490_55510 = state_55477__$1;
(statearr_55490_55510[(2)] = path);

(statearr_55490_55510[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55478 === (9))){
var inst_55448 = (state_55477[(2)]);
var inst_55449 = fluree.db.util.async.throw_err(inst_55448);
var state_55477__$1 = state_55477;
var statearr_55491_55511 = state_55477__$1;
(statearr_55491_55511[(2)] = inst_55449);

(statearr_55491_55511[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55478 === (5))){
var _ = (function (){var statearr_55492 = state_55477;
(statearr_55492[(4)] = cljs.core.rest((state_55477[(4)])));

return statearr_55492;
})();
var state_55477__$1 = state_55477;
var ex55489 = (state_55477__$1[(2)]);
var statearr_55493_55512 = state_55477__$1;
(statearr_55493_55512[(5)] = ex55489);


if((ex55489 instanceof Error)){
var statearr_55494_55513 = state_55477__$1;
(statearr_55494_55513[(1)] = (4));

(statearr_55494_55513[(5)] = null);

} else {
throw ex55489;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55478 === (10))){
var state_55477__$1 = state_55477;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55477__$1,(13),path);
} else {
if((state_val_55478 === (8))){
var inst_55452 = (state_55477[(2)]);
var inst_55453 = fluree.db.util.async.channel_QMARK_(path);
var state_55477__$1 = (function (){var statearr_55495 = state_55477;
(statearr_55495[(7)] = inst_55452);

return statearr_55495;
})();
if(inst_55453){
var statearr_55496_55514 = state_55477__$1;
(statearr_55496_55514[(1)] = (10));

} else {
var statearr_55497_55515 = state_55477__$1;
(statearr_55497_55515[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2749__auto____0 = (function (){
var statearr_55498 = [null,null,null,null,null,null,null,null,null];
(statearr_55498[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2749__auto__);

(statearr_55498[(1)] = (1));

return statearr_55498;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2749__auto____1 = (function (state_55477){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_55477);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e55499){var ex__2752__auto__ = e55499;
var statearr_55500_55516 = state_55477;
(statearr_55500_55516[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_55477[(4)]))){
var statearr_55501_55517 = state_55477;
(statearr_55501_55517[(1)] = cljs.core.first((state_55477[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55518 = state_55477;
state_55477 = G__55518;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2749__auto__ = function(state_55477){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2749__auto____1.call(this,state_55477);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_55502 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_55502[(6)] = c__2771__auto__);

return statearr_55502;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_55563){
var state_val_55564 = (state_55563[(1)]);
if((state_val_55564 === (7))){
var state_55563__$1 = state_55563;
var statearr_55565_55594 = state_55563__$1;
(statearr_55565_55594[(2)] = coll);

(statearr_55565_55594[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55564 === (1))){
var state_55563__$1 = state_55563;
var statearr_55566_55595 = state_55563__$1;
(statearr_55566_55595[(2)] = null);

(statearr_55566_55595[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55564 === (4))){
var inst_55519 = (state_55563[(2)]);
var state_55563__$1 = state_55563;
var statearr_55567_55596 = state_55563__$1;
(statearr_55567_55596[(2)] = inst_55519);

(statearr_55567_55596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55564 === (15))){
var inst_55539 = (state_55563[(7)]);
var inst_55547 = (state_55563[(2)]);
var inst_55548 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_55539,inst_55547);
var inst_55549 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55550 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55551 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55552 = [inst_55539,inst_55547];
var inst_55553 = (new cljs.core.PersistentVector(null,2,(5),inst_55551,inst_55552,null));
var inst_55554 = ["contains?",inst_55553,inst_55548];
var inst_55555 = cljs.core.PersistentHashMap.fromArrays(inst_55550,inst_55554);
var inst_55556 = [inst_55555,(10)];
var inst_55557 = (new cljs.core.PersistentVector(null,2,(5),inst_55549,inst_55556,null));
var inst_55558 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55557);
var _ = (function (){var statearr_55568 = state_55563;
(statearr_55568[(4)] = cljs.core.rest((state_55563[(4)])));

return statearr_55568;
})();
var state_55563__$1 = (function (){var statearr_55569 = state_55563;
(statearr_55569[(8)] = inst_55558);

return statearr_55569;
})();
var statearr_55570_55597 = state_55563__$1;
(statearr_55570_55597[(2)] = inst_55548);

(statearr_55570_55597[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55564 === (13))){
var state_55563__$1 = state_55563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55563__$1,(16),key);
} else {
if((state_val_55564 === (6))){
var state_55563__$1 = state_55563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55563__$1,(9),coll);
} else {
if((state_val_55564 === (3))){
var inst_55561 = (state_55563[(2)]);
var state_55563__$1 = state_55563;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55563__$1,inst_55561);
} else {
if((state_val_55564 === (12))){
var inst_55539 = (state_55563[(2)]);
var inst_55540 = fluree.db.util.async.channel_QMARK_(key);
var state_55563__$1 = (function (){var statearr_55571 = state_55563;
(statearr_55571[(7)] = inst_55539);

return statearr_55571;
})();
if(inst_55540){
var statearr_55572_55598 = state_55563__$1;
(statearr_55572_55598[(1)] = (13));

} else {
var statearr_55573_55599 = state_55563__$1;
(statearr_55573_55599[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55564 === (2))){
var _ = (function (){var statearr_55574 = state_55563;
(statearr_55574[(4)] = cljs.core.cons((5),(state_55563[(4)])));

return statearr_55574;
})();
var inst_55525 = fluree.db.util.async.channel_QMARK_(coll);
var state_55563__$1 = state_55563;
if(inst_55525){
var statearr_55575_55600 = state_55563__$1;
(statearr_55575_55600[(1)] = (6));

} else {
var statearr_55576_55601 = state_55563__$1;
(statearr_55576_55601[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55564 === (11))){
var inst_55532 = (state_55563[(9)]);
var inst_55536 = cljs.core.flatten(inst_55532);
var inst_55537 = cljs.core.set(inst_55536);
var state_55563__$1 = state_55563;
var statearr_55578_55602 = state_55563__$1;
(statearr_55578_55602[(2)] = inst_55537);

(statearr_55578_55602[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55564 === (9))){
var inst_55528 = (state_55563[(2)]);
var inst_55529 = fluree.db.util.async.throw_err(inst_55528);
var state_55563__$1 = state_55563;
var statearr_55579_55603 = state_55563__$1;
(statearr_55579_55603[(2)] = inst_55529);

(statearr_55579_55603[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55564 === (5))){
var _ = (function (){var statearr_55580 = state_55563;
(statearr_55580[(4)] = cljs.core.rest((state_55563[(4)])));

return statearr_55580;
})();
var state_55563__$1 = state_55563;
var ex55577 = (state_55563__$1[(2)]);
var statearr_55581_55604 = state_55563__$1;
(statearr_55581_55604[(5)] = ex55577);


if((ex55577 instanceof Error)){
var statearr_55582_55605 = state_55563__$1;
(statearr_55582_55605[(1)] = (4));

(statearr_55582_55605[(5)] = null);

} else {
throw ex55577;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55564 === (14))){
var state_55563__$1 = state_55563;
var statearr_55583_55606 = state_55563__$1;
(statearr_55583_55606[(2)] = key);

(statearr_55583_55606[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55564 === (16))){
var inst_55543 = (state_55563[(2)]);
var inst_55544 = fluree.db.util.async.throw_err(inst_55543);
var state_55563__$1 = state_55563;
var statearr_55584_55607 = state_55563__$1;
(statearr_55584_55607[(2)] = inst_55544);

(statearr_55584_55607[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55564 === (10))){
var inst_55532 = (state_55563[(9)]);
var state_55563__$1 = state_55563;
var statearr_55585_55608 = state_55563__$1;
(statearr_55585_55608[(2)] = inst_55532);

(statearr_55585_55608[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55564 === (8))){
var inst_55532 = (state_55563[(9)]);
var inst_55532__$1 = (state_55563[(2)]);
var inst_55533 = cljs.core.set_QMARK_(inst_55532__$1);
var state_55563__$1 = (function (){var statearr_55586 = state_55563;
(statearr_55586[(9)] = inst_55532__$1);

return statearr_55586;
})();
if(inst_55533){
var statearr_55587_55609 = state_55563__$1;
(statearr_55587_55609[(1)] = (10));

} else {
var statearr_55588_55610 = state_55563__$1;
(statearr_55588_55610[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2749__auto____0 = (function (){
var statearr_55589 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55589[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2749__auto__);

(statearr_55589[(1)] = (1));

return statearr_55589;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2749__auto____1 = (function (state_55563){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_55563);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e55590){var ex__2752__auto__ = e55590;
var statearr_55591_55611 = state_55563;
(statearr_55591_55611[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_55563[(4)]))){
var statearr_55592_55612 = state_55563;
(statearr_55592_55612[(1)] = cljs.core.first((state_55563[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55613 = state_55563;
state_55563 = G__55613;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2749__auto__ = function(state_55563){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2749__auto____1.call(this,state_55563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_55593 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_55593[(6)] = c__2771__auto__);

return statearr_55593;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__5774__auto__ = [];
var len__5768__auto___55685 = arguments.length;
var i__5769__auto___55686 = (0);
while(true){
if((i__5769__auto___55686 < len__5768__auto___55685)){
args__5774__auto__.push((arguments[i__5769__auto___55686]));

var G__55687 = (i__5769__auto___55686 + (1));
i__5769__auto___55686 = G__55687;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_55659){
var state_val_55660 = (state_55659[(1)]);
if((state_val_55660 === (7))){
var inst_55625 = (state_55659[(7)]);
var inst_55629 = cljs.core.first(inst_55625);
var inst_55630 = cljs.core.coll_QMARK_(inst_55629);
var state_55659__$1 = state_55659;
var statearr_55661_55688 = state_55659__$1;
(statearr_55661_55688[(2)] = inst_55630);

(statearr_55661_55688[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55660 === (1))){
var state_55659__$1 = state_55659;
var statearr_55662_55689 = state_55659__$1;
(statearr_55662_55689[(2)] = null);

(statearr_55662_55689[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55660 === (4))){
var inst_55616 = (state_55659[(2)]);
var state_55659__$1 = state_55659;
var statearr_55663_55690 = state_55659__$1;
(statearr_55663_55690[(2)] = inst_55616);

(statearr_55663_55690[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55660 === (6))){
var inst_55625 = (state_55659[(7)]);
var inst_55627 = (state_55659[(8)]);
var inst_55624 = (state_55659[(2)]);
var inst_55625__$1 = fluree.db.util.async.throw_err(inst_55624);
var inst_55626 = cljs.core.count(inst_55625__$1);
var inst_55627__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_55626);
var state_55659__$1 = (function (){var statearr_55664 = state_55659;
(statearr_55664[(7)] = inst_55625__$1);

(statearr_55664[(8)] = inst_55627__$1);

return statearr_55664;
})();
if(inst_55627__$1){
var statearr_55665_55691 = state_55659__$1;
(statearr_55665_55691[(1)] = (7));

} else {
var statearr_55666_55692 = state_55659__$1;
(statearr_55666_55692[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55660 === (3))){
var inst_55657 = (state_55659[(2)]);
var state_55659__$1 = state_55659;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55659__$1,inst_55657);
} else {
if((state_val_55660 === (12))){
var inst_55638 = (state_55659[(2)]);
var inst_55639 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_55638);
var inst_55640 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55641 = [inst_55638];
var inst_55642 = (new cljs.core.PersistentVector(null,1,(5),inst_55640,inst_55641,null));
var inst_55643 = cljs.core.count(inst_55642);
var inst_55644 = ((9) + inst_55643);
var inst_55645 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55646 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55647 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55648 = [inst_55638];
var inst_55649 = (new cljs.core.PersistentVector(null,1,(5),inst_55647,inst_55648,null));
var inst_55650 = ["hash-set",inst_55649,inst_55639];
var inst_55651 = cljs.core.PersistentHashMap.fromArrays(inst_55646,inst_55650);
var inst_55652 = [inst_55651,inst_55644];
var inst_55653 = (new cljs.core.PersistentVector(null,2,(5),inst_55645,inst_55652,null));
var inst_55654 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55653);
var _ = (function (){var statearr_55667 = state_55659;
(statearr_55667[(4)] = cljs.core.rest((state_55659[(4)])));

return statearr_55667;
})();
var state_55659__$1 = (function (){var statearr_55668 = state_55659;
(statearr_55668[(9)] = inst_55654);

return statearr_55668;
})();
var statearr_55669_55693 = state_55659__$1;
(statearr_55669_55693[(2)] = inst_55639);

(statearr_55669_55693[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55660 === (2))){
var _ = (function (){var statearr_55670 = state_55659;
(statearr_55670[(4)] = cljs.core.cons((5),(state_55659[(4)])));

return statearr_55670;
})();
var inst_55622 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55659__$1 = state_55659;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55659__$1,(6),inst_55622);
} else {
if((state_val_55660 === (11))){
var inst_55625 = (state_55659[(7)]);
var state_55659__$1 = state_55659;
var statearr_55672_55694 = state_55659__$1;
(statearr_55672_55694[(2)] = inst_55625);

(statearr_55672_55694[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55660 === (9))){
var inst_55633 = (state_55659[(2)]);
var state_55659__$1 = state_55659;
if(cljs.core.truth_(inst_55633)){
var statearr_55673_55695 = state_55659__$1;
(statearr_55673_55695[(1)] = (10));

} else {
var statearr_55674_55696 = state_55659__$1;
(statearr_55674_55696[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55660 === (5))){
var _ = (function (){var statearr_55675 = state_55659;
(statearr_55675[(4)] = cljs.core.rest((state_55659[(4)])));

return statearr_55675;
})();
var state_55659__$1 = state_55659;
var ex55671 = (state_55659__$1[(2)]);
var statearr_55676_55697 = state_55659__$1;
(statearr_55676_55697[(5)] = ex55671);


if((ex55671 instanceof Error)){
var statearr_55677_55698 = state_55659__$1;
(statearr_55677_55698[(1)] = (4));

(statearr_55677_55698[(5)] = null);

} else {
throw ex55671;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55660 === (10))){
var inst_55625 = (state_55659[(7)]);
var inst_55635 = cljs.core.first(inst_55625);
var state_55659__$1 = state_55659;
var statearr_55678_55699 = state_55659__$1;
(statearr_55678_55699[(2)] = inst_55635);

(statearr_55678_55699[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55660 === (8))){
var inst_55627 = (state_55659[(8)]);
var state_55659__$1 = state_55659;
var statearr_55679_55700 = state_55659__$1;
(statearr_55679_55700[(2)] = inst_55627);

(statearr_55679_55700[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2749__auto____0 = (function (){
var statearr_55680 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55680[(0)] = fluree$db$dbfunctions$fns$state_machine__2749__auto__);

(statearr_55680[(1)] = (1));

return statearr_55680;
});
var fluree$db$dbfunctions$fns$state_machine__2749__auto____1 = (function (state_55659){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_55659);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e55681){var ex__2752__auto__ = e55681;
var statearr_55682_55701 = state_55659;
(statearr_55682_55701[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_55659[(4)]))){
var statearr_55683_55702 = state_55659;
(statearr_55683_55702[(1)] = cljs.core.first((state_55659[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55703 = state_55659;
state_55659 = G__55703;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2749__auto__ = function(state_55659){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____1.call(this,state_55659);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_55684 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_55684[(6)] = c__2771__auto__);

return statearr_55684;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq55614){
var G__55615 = cljs.core.first(seq55614);
var seq55614__$1 = cljs.core.next(seq55614);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55615,seq55614__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___55753 = arguments.length;
var i__5769__auto___55754 = (0);
while(true){
if((i__5769__auto___55754 < len__5768__auto___55753)){
args__5774__auto__.push((arguments[i__5769__auto___55754]));

var G__55755 = (i__5769__auto___55754 + (1));
i__5769__auto___55754 = G__55755;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_55736){
var state_val_55737 = (state_55736[(1)]);
if((state_val_55737 === (1))){
var state_55736__$1 = state_55736;
var statearr_55738_55756 = state_55736__$1;
(statearr_55738_55756[(2)] = null);

(statearr_55738_55756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55737 === (2))){
var _ = (function (){var statearr_55739 = state_55736;
(statearr_55739[(4)] = cljs.core.cons((5),(state_55736[(4)])));

return statearr_55739;
})();
var inst_55712 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55736__$1 = state_55736;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55736__$1,(6),inst_55712);
} else {
if((state_val_55737 === (3))){
var inst_55734 = (state_55736[(2)]);
var state_55736__$1 = state_55736;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55736__$1,inst_55734);
} else {
if((state_val_55737 === (4))){
var inst_55706 = (state_55736[(2)]);
var state_55736__$1 = state_55736;
var statearr_55741_55757 = state_55736__$1;
(statearr_55741_55757[(2)] = inst_55706);

(statearr_55741_55757[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55737 === (5))){
var _ = (function (){var statearr_55742 = state_55736;
(statearr_55742[(4)] = cljs.core.rest((state_55736[(4)])));

return statearr_55742;
})();
var state_55736__$1 = state_55736;
var ex55740 = (state_55736__$1[(2)]);
var statearr_55743_55758 = state_55736__$1;
(statearr_55743_55758[(5)] = ex55740);


if((ex55740 instanceof Error)){
var statearr_55744_55759 = state_55736__$1;
(statearr_55744_55759[(1)] = (4));

(statearr_55744_55759[(5)] = null);

} else {
throw ex55740;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55737 === (6))){
var inst_55714 = (state_55736[(2)]);
var inst_55715 = fluree.db.util.async.throw_err(inst_55714);
var inst_55716 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_55715);
var inst_55717 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55718 = [inst_55715];
var inst_55719 = (new cljs.core.PersistentVector(null,1,(5),inst_55717,inst_55718,null));
var inst_55720 = cljs.core.count(inst_55719);
var inst_55721 = ((9) + inst_55720);
var inst_55722 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55723 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55724 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55725 = [inst_55715];
var inst_55726 = (new cljs.core.PersistentVector(null,1,(5),inst_55724,inst_55725,null));
var inst_55727 = ["==",inst_55726,inst_55716];
var inst_55728 = cljs.core.PersistentHashMap.fromArrays(inst_55723,inst_55727);
var inst_55729 = [inst_55728,inst_55721];
var inst_55730 = (new cljs.core.PersistentVector(null,2,(5),inst_55722,inst_55729,null));
var inst_55731 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55730);
var _ = (function (){var statearr_55745 = state_55736;
(statearr_55745[(4)] = cljs.core.rest((state_55736[(4)])));

return statearr_55745;
})();
var state_55736__$1 = (function (){var statearr_55746 = state_55736;
(statearr_55746[(7)] = inst_55731);

return statearr_55746;
})();
var statearr_55747_55760 = state_55736__$1;
(statearr_55747_55760[(2)] = inst_55716);

(statearr_55747_55760[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2749__auto____0 = (function (){
var statearr_55748 = [null,null,null,null,null,null,null,null];
(statearr_55748[(0)] = fluree$db$dbfunctions$fns$state_machine__2749__auto__);

(statearr_55748[(1)] = (1));

return statearr_55748;
});
var fluree$db$dbfunctions$fns$state_machine__2749__auto____1 = (function (state_55736){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_55736);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e55749){var ex__2752__auto__ = e55749;
var statearr_55750_55761 = state_55736;
(statearr_55750_55761[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_55736[(4)]))){
var statearr_55751_55762 = state_55736;
(statearr_55751_55762[(1)] = cljs.core.first((state_55736[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55763 = state_55736;
state_55736 = G__55763;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2749__auto__ = function(state_55736){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____1.call(this,state_55736);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_55752 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_55752[(6)] = c__2771__auto__);

return statearr_55752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq55704){
var G__55705 = cljs.core.first(seq55704);
var seq55704__$1 = cljs.core.next(seq55704);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55705,seq55704__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___55813 = arguments.length;
var i__5769__auto___55814 = (0);
while(true){
if((i__5769__auto___55814 < len__5768__auto___55813)){
args__5774__auto__.push((arguments[i__5769__auto___55814]));

var G__55815 = (i__5769__auto___55814 + (1));
i__5769__auto___55814 = G__55815;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_55796){
var state_val_55797 = (state_55796[(1)]);
if((state_val_55797 === (1))){
var state_55796__$1 = state_55796;
var statearr_55798_55816 = state_55796__$1;
(statearr_55798_55816[(2)] = null);

(statearr_55798_55816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55797 === (2))){
var _ = (function (){var statearr_55799 = state_55796;
(statearr_55799[(4)] = cljs.core.cons((5),(state_55796[(4)])));

return statearr_55799;
})();
var inst_55772 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55796__$1 = state_55796;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55796__$1,(6),inst_55772);
} else {
if((state_val_55797 === (3))){
var inst_55794 = (state_55796[(2)]);
var state_55796__$1 = state_55796;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55796__$1,inst_55794);
} else {
if((state_val_55797 === (4))){
var inst_55766 = (state_55796[(2)]);
var state_55796__$1 = state_55796;
var statearr_55801_55817 = state_55796__$1;
(statearr_55801_55817[(2)] = inst_55766);

(statearr_55801_55817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55797 === (5))){
var _ = (function (){var statearr_55802 = state_55796;
(statearr_55802[(4)] = cljs.core.rest((state_55796[(4)])));

return statearr_55802;
})();
var state_55796__$1 = state_55796;
var ex55800 = (state_55796__$1[(2)]);
var statearr_55803_55818 = state_55796__$1;
(statearr_55803_55818[(5)] = ex55800);


if((ex55800 instanceof Error)){
var statearr_55804_55819 = state_55796__$1;
(statearr_55804_55819[(1)] = (4));

(statearr_55804_55819[(5)] = null);

} else {
throw ex55800;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55797 === (6))){
var inst_55774 = (state_55796[(2)]);
var inst_55775 = fluree.db.util.async.throw_err(inst_55774);
var inst_55776 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_55775);
var inst_55777 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55778 = [inst_55775];
var inst_55779 = (new cljs.core.PersistentVector(null,1,(5),inst_55777,inst_55778,null));
var inst_55780 = cljs.core.count(inst_55779);
var inst_55781 = ((9) + inst_55780);
var inst_55782 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55783 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55784 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55785 = [inst_55775];
var inst_55786 = (new cljs.core.PersistentVector(null,1,(5),inst_55784,inst_55785,null));
var inst_55787 = [">",inst_55786,inst_55776];
var inst_55788 = cljs.core.PersistentHashMap.fromArrays(inst_55783,inst_55787);
var inst_55789 = [inst_55788,inst_55781];
var inst_55790 = (new cljs.core.PersistentVector(null,2,(5),inst_55782,inst_55789,null));
var inst_55791 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55790);
var _ = (function (){var statearr_55805 = state_55796;
(statearr_55805[(4)] = cljs.core.rest((state_55796[(4)])));

return statearr_55805;
})();
var state_55796__$1 = (function (){var statearr_55806 = state_55796;
(statearr_55806[(7)] = inst_55791);

return statearr_55806;
})();
var statearr_55807_55820 = state_55796__$1;
(statearr_55807_55820[(2)] = inst_55776);

(statearr_55807_55820[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2749__auto____0 = (function (){
var statearr_55808 = [null,null,null,null,null,null,null,null];
(statearr_55808[(0)] = fluree$db$dbfunctions$fns$state_machine__2749__auto__);

(statearr_55808[(1)] = (1));

return statearr_55808;
});
var fluree$db$dbfunctions$fns$state_machine__2749__auto____1 = (function (state_55796){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_55796);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e55809){var ex__2752__auto__ = e55809;
var statearr_55810_55821 = state_55796;
(statearr_55810_55821[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_55796[(4)]))){
var statearr_55811_55822 = state_55796;
(statearr_55811_55822[(1)] = cljs.core.first((state_55796[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55823 = state_55796;
state_55796 = G__55823;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2749__auto__ = function(state_55796){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____1.call(this,state_55796);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_55812 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_55812[(6)] = c__2771__auto__);

return statearr_55812;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq55764){
var G__55765 = cljs.core.first(seq55764);
var seq55764__$1 = cljs.core.next(seq55764);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55765,seq55764__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___55873 = arguments.length;
var i__5769__auto___55874 = (0);
while(true){
if((i__5769__auto___55874 < len__5768__auto___55873)){
args__5774__auto__.push((arguments[i__5769__auto___55874]));

var G__55875 = (i__5769__auto___55874 + (1));
i__5769__auto___55874 = G__55875;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_55856){
var state_val_55857 = (state_55856[(1)]);
if((state_val_55857 === (1))){
var state_55856__$1 = state_55856;
var statearr_55858_55876 = state_55856__$1;
(statearr_55858_55876[(2)] = null);

(statearr_55858_55876[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55857 === (2))){
var _ = (function (){var statearr_55859 = state_55856;
(statearr_55859[(4)] = cljs.core.cons((5),(state_55856[(4)])));

return statearr_55859;
})();
var inst_55832 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55856__$1 = state_55856;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55856__$1,(6),inst_55832);
} else {
if((state_val_55857 === (3))){
var inst_55854 = (state_55856[(2)]);
var state_55856__$1 = state_55856;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55856__$1,inst_55854);
} else {
if((state_val_55857 === (4))){
var inst_55826 = (state_55856[(2)]);
var state_55856__$1 = state_55856;
var statearr_55861_55877 = state_55856__$1;
(statearr_55861_55877[(2)] = inst_55826);

(statearr_55861_55877[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55857 === (5))){
var _ = (function (){var statearr_55862 = state_55856;
(statearr_55862[(4)] = cljs.core.rest((state_55856[(4)])));

return statearr_55862;
})();
var state_55856__$1 = state_55856;
var ex55860 = (state_55856__$1[(2)]);
var statearr_55863_55878 = state_55856__$1;
(statearr_55863_55878[(5)] = ex55860);


if((ex55860 instanceof Error)){
var statearr_55864_55879 = state_55856__$1;
(statearr_55864_55879[(1)] = (4));

(statearr_55864_55879[(5)] = null);

} else {
throw ex55860;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55857 === (6))){
var inst_55834 = (state_55856[(2)]);
var inst_55835 = fluree.db.util.async.throw_err(inst_55834);
var inst_55836 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_55835);
var inst_55837 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55838 = [inst_55835];
var inst_55839 = (new cljs.core.PersistentVector(null,1,(5),inst_55837,inst_55838,null));
var inst_55840 = cljs.core.count(inst_55839);
var inst_55841 = ((9) + inst_55840);
var inst_55842 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55843 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55844 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55845 = [inst_55835];
var inst_55846 = (new cljs.core.PersistentVector(null,1,(5),inst_55844,inst_55845,null));
var inst_55847 = ["<",inst_55846,inst_55836];
var inst_55848 = cljs.core.PersistentHashMap.fromArrays(inst_55843,inst_55847);
var inst_55849 = [inst_55848,inst_55841];
var inst_55850 = (new cljs.core.PersistentVector(null,2,(5),inst_55842,inst_55849,null));
var inst_55851 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55850);
var _ = (function (){var statearr_55865 = state_55856;
(statearr_55865[(4)] = cljs.core.rest((state_55856[(4)])));

return statearr_55865;
})();
var state_55856__$1 = (function (){var statearr_55866 = state_55856;
(statearr_55866[(7)] = inst_55851);

return statearr_55866;
})();
var statearr_55867_55880 = state_55856__$1;
(statearr_55867_55880[(2)] = inst_55836);

(statearr_55867_55880[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2749__auto____0 = (function (){
var statearr_55868 = [null,null,null,null,null,null,null,null];
(statearr_55868[(0)] = fluree$db$dbfunctions$fns$state_machine__2749__auto__);

(statearr_55868[(1)] = (1));

return statearr_55868;
});
var fluree$db$dbfunctions$fns$state_machine__2749__auto____1 = (function (state_55856){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_55856);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e55869){var ex__2752__auto__ = e55869;
var statearr_55870_55881 = state_55856;
(statearr_55870_55881[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_55856[(4)]))){
var statearr_55871_55882 = state_55856;
(statearr_55871_55882[(1)] = cljs.core.first((state_55856[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55883 = state_55856;
state_55856 = G__55883;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2749__auto__ = function(state_55856){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____1.call(this,state_55856);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_55872 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_55872[(6)] = c__2771__auto__);

return statearr_55872;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq55824){
var G__55825 = cljs.core.first(seq55824);
var seq55824__$1 = cljs.core.next(seq55824);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55825,seq55824__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___55933 = arguments.length;
var i__5769__auto___55934 = (0);
while(true){
if((i__5769__auto___55934 < len__5768__auto___55933)){
args__5774__auto__.push((arguments[i__5769__auto___55934]));

var G__55935 = (i__5769__auto___55934 + (1));
i__5769__auto___55934 = G__55935;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_55916){
var state_val_55917 = (state_55916[(1)]);
if((state_val_55917 === (1))){
var state_55916__$1 = state_55916;
var statearr_55918_55936 = state_55916__$1;
(statearr_55918_55936[(2)] = null);

(statearr_55918_55936[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55917 === (2))){
var _ = (function (){var statearr_55919 = state_55916;
(statearr_55919[(4)] = cljs.core.cons((5),(state_55916[(4)])));

return statearr_55919;
})();
var inst_55892 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55916__$1 = state_55916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55916__$1,(6),inst_55892);
} else {
if((state_val_55917 === (3))){
var inst_55914 = (state_55916[(2)]);
var state_55916__$1 = state_55916;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55916__$1,inst_55914);
} else {
if((state_val_55917 === (4))){
var inst_55886 = (state_55916[(2)]);
var state_55916__$1 = state_55916;
var statearr_55921_55937 = state_55916__$1;
(statearr_55921_55937[(2)] = inst_55886);

(statearr_55921_55937[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55917 === (5))){
var _ = (function (){var statearr_55922 = state_55916;
(statearr_55922[(4)] = cljs.core.rest((state_55916[(4)])));

return statearr_55922;
})();
var state_55916__$1 = state_55916;
var ex55920 = (state_55916__$1[(2)]);
var statearr_55923_55938 = state_55916__$1;
(statearr_55923_55938[(5)] = ex55920);


if((ex55920 instanceof Error)){
var statearr_55924_55939 = state_55916__$1;
(statearr_55924_55939[(1)] = (4));

(statearr_55924_55939[(5)] = null);

} else {
throw ex55920;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55917 === (6))){
var inst_55894 = (state_55916[(2)]);
var inst_55895 = fluree.db.util.async.throw_err(inst_55894);
var inst_55896 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_55895);
var inst_55897 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55898 = [inst_55895];
var inst_55899 = (new cljs.core.PersistentVector(null,1,(5),inst_55897,inst_55898,null));
var inst_55900 = cljs.core.count(inst_55899);
var inst_55901 = ((9) + inst_55900);
var inst_55902 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55903 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55904 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55905 = [inst_55895];
var inst_55906 = (new cljs.core.PersistentVector(null,1,(5),inst_55904,inst_55905,null));
var inst_55907 = ["<=",inst_55906,inst_55896];
var inst_55908 = cljs.core.PersistentHashMap.fromArrays(inst_55903,inst_55907);
var inst_55909 = [inst_55908,inst_55901];
var inst_55910 = (new cljs.core.PersistentVector(null,2,(5),inst_55902,inst_55909,null));
var inst_55911 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55910);
var _ = (function (){var statearr_55925 = state_55916;
(statearr_55925[(4)] = cljs.core.rest((state_55916[(4)])));

return statearr_55925;
})();
var state_55916__$1 = (function (){var statearr_55926 = state_55916;
(statearr_55926[(7)] = inst_55911);

return statearr_55926;
})();
var statearr_55927_55940 = state_55916__$1;
(statearr_55927_55940[(2)] = inst_55896);

(statearr_55927_55940[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2749__auto____0 = (function (){
var statearr_55928 = [null,null,null,null,null,null,null,null];
(statearr_55928[(0)] = fluree$db$dbfunctions$fns$state_machine__2749__auto__);

(statearr_55928[(1)] = (1));

return statearr_55928;
});
var fluree$db$dbfunctions$fns$state_machine__2749__auto____1 = (function (state_55916){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_55916);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e55929){var ex__2752__auto__ = e55929;
var statearr_55930_55941 = state_55916;
(statearr_55930_55941[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_55916[(4)]))){
var statearr_55931_55942 = state_55916;
(statearr_55931_55942[(1)] = cljs.core.first((state_55916[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55943 = state_55916;
state_55916 = G__55943;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2749__auto__ = function(state_55916){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____1.call(this,state_55916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_55932 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_55932[(6)] = c__2771__auto__);

return statearr_55932;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq55884){
var G__55885 = cljs.core.first(seq55884);
var seq55884__$1 = cljs.core.next(seq55884);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55885,seq55884__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___55993 = arguments.length;
var i__5769__auto___55994 = (0);
while(true){
if((i__5769__auto___55994 < len__5768__auto___55993)){
args__5774__auto__.push((arguments[i__5769__auto___55994]));

var G__55995 = (i__5769__auto___55994 + (1));
i__5769__auto___55994 = G__55995;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_55976){
var state_val_55977 = (state_55976[(1)]);
if((state_val_55977 === (1))){
var state_55976__$1 = state_55976;
var statearr_55978_55996 = state_55976__$1;
(statearr_55978_55996[(2)] = null);

(statearr_55978_55996[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (2))){
var _ = (function (){var statearr_55979 = state_55976;
(statearr_55979[(4)] = cljs.core.cons((5),(state_55976[(4)])));

return statearr_55979;
})();
var inst_55952 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55976__$1 = state_55976;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55976__$1,(6),inst_55952);
} else {
if((state_val_55977 === (3))){
var inst_55974 = (state_55976[(2)]);
var state_55976__$1 = state_55976;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55976__$1,inst_55974);
} else {
if((state_val_55977 === (4))){
var inst_55946 = (state_55976[(2)]);
var state_55976__$1 = state_55976;
var statearr_55981_55997 = state_55976__$1;
(statearr_55981_55997[(2)] = inst_55946);

(statearr_55981_55997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (5))){
var _ = (function (){var statearr_55982 = state_55976;
(statearr_55982[(4)] = cljs.core.rest((state_55976[(4)])));

return statearr_55982;
})();
var state_55976__$1 = state_55976;
var ex55980 = (state_55976__$1[(2)]);
var statearr_55983_55998 = state_55976__$1;
(statearr_55983_55998[(5)] = ex55980);


if((ex55980 instanceof Error)){
var statearr_55984_55999 = state_55976__$1;
(statearr_55984_55999[(1)] = (4));

(statearr_55984_55999[(5)] = null);

} else {
throw ex55980;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (6))){
var inst_55954 = (state_55976[(2)]);
var inst_55955 = fluree.db.util.async.throw_err(inst_55954);
var inst_55956 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_55955);
var inst_55957 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55958 = [inst_55955];
var inst_55959 = (new cljs.core.PersistentVector(null,1,(5),inst_55957,inst_55958,null));
var inst_55960 = cljs.core.count(inst_55959);
var inst_55961 = ((9) + inst_55960);
var inst_55962 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55963 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55965 = [inst_55955];
var inst_55966 = (new cljs.core.PersistentVector(null,1,(5),inst_55964,inst_55965,null));
var inst_55967 = [">=",inst_55966,inst_55956];
var inst_55968 = cljs.core.PersistentHashMap.fromArrays(inst_55963,inst_55967);
var inst_55969 = [inst_55968,inst_55961];
var inst_55970 = (new cljs.core.PersistentVector(null,2,(5),inst_55962,inst_55969,null));
var inst_55971 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55970);
var _ = (function (){var statearr_55985 = state_55976;
(statearr_55985[(4)] = cljs.core.rest((state_55976[(4)])));

return statearr_55985;
})();
var state_55976__$1 = (function (){var statearr_55986 = state_55976;
(statearr_55986[(7)] = inst_55971);

return statearr_55986;
})();
var statearr_55987_56000 = state_55976__$1;
(statearr_55987_56000[(2)] = inst_55956);

(statearr_55987_56000[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2749__auto____0 = (function (){
var statearr_55988 = [null,null,null,null,null,null,null,null];
(statearr_55988[(0)] = fluree$db$dbfunctions$fns$state_machine__2749__auto__);

(statearr_55988[(1)] = (1));

return statearr_55988;
});
var fluree$db$dbfunctions$fns$state_machine__2749__auto____1 = (function (state_55976){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_55976);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e55989){var ex__2752__auto__ = e55989;
var statearr_55990_56001 = state_55976;
(statearr_55990_56001[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_55976[(4)]))){
var statearr_55991_56002 = state_55976;
(statearr_55991_56002[(1)] = cljs.core.first((state_55976[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56003 = state_55976;
state_55976 = G__56003;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2749__auto__ = function(state_55976){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____1.call(this,state_55976);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_55992 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_55992[(6)] = c__2771__auto__);

return statearr_55992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq55944){
var G__55945 = cljs.core.first(seq55944);
var seq55944__$1 = cljs.core.next(seq55944);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55945,seq55944__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___56053 = arguments.length;
var i__5769__auto___56054 = (0);
while(true){
if((i__5769__auto___56054 < len__5768__auto___56053)){
args__5774__auto__.push((arguments[i__5769__auto___56054]));

var G__56055 = (i__5769__auto___56054 + (1));
i__5769__auto___56054 = G__56055;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_56036){
var state_val_56037 = (state_56036[(1)]);
if((state_val_56037 === (1))){
var state_56036__$1 = state_56036;
var statearr_56038_56056 = state_56036__$1;
(statearr_56038_56056[(2)] = null);

(statearr_56038_56056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56037 === (2))){
var _ = (function (){var statearr_56039 = state_56036;
(statearr_56039[(4)] = cljs.core.cons((5),(state_56036[(4)])));

return statearr_56039;
})();
var inst_56012 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56036__$1 = state_56036;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56036__$1,(6),inst_56012);
} else {
if((state_val_56037 === (3))){
var inst_56034 = (state_56036[(2)]);
var state_56036__$1 = state_56036;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56036__$1,inst_56034);
} else {
if((state_val_56037 === (4))){
var inst_56006 = (state_56036[(2)]);
var state_56036__$1 = state_56036;
var statearr_56041_56057 = state_56036__$1;
(statearr_56041_56057[(2)] = inst_56006);

(statearr_56041_56057[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56037 === (5))){
var _ = (function (){var statearr_56042 = state_56036;
(statearr_56042[(4)] = cljs.core.rest((state_56036[(4)])));

return statearr_56042;
})();
var state_56036__$1 = state_56036;
var ex56040 = (state_56036__$1[(2)]);
var statearr_56043_56058 = state_56036__$1;
(statearr_56043_56058[(5)] = ex56040);


if((ex56040 instanceof Error)){
var statearr_56044_56059 = state_56036__$1;
(statearr_56044_56059[(1)] = (4));

(statearr_56044_56059[(5)] = null);

} else {
throw ex56040;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56037 === (6))){
var inst_56014 = (state_56036[(2)]);
var inst_56015 = fluree.db.util.async.throw_err(inst_56014);
var inst_56016 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_56015);
var inst_56017 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56018 = [inst_56015];
var inst_56019 = (new cljs.core.PersistentVector(null,1,(5),inst_56017,inst_56018,null));
var inst_56020 = cljs.core.count(inst_56019);
var inst_56021 = ((9) + inst_56020);
var inst_56022 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56023 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56024 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56025 = [inst_56015];
var inst_56026 = (new cljs.core.PersistentVector(null,1,(5),inst_56024,inst_56025,null));
var inst_56027 = ["not=",inst_56026,inst_56016];
var inst_56028 = cljs.core.PersistentHashMap.fromArrays(inst_56023,inst_56027);
var inst_56029 = [inst_56028,inst_56021];
var inst_56030 = (new cljs.core.PersistentVector(null,2,(5),inst_56022,inst_56029,null));
var inst_56031 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56030);
var _ = (function (){var statearr_56045 = state_56036;
(statearr_56045[(4)] = cljs.core.rest((state_56036[(4)])));

return statearr_56045;
})();
var state_56036__$1 = (function (){var statearr_56046 = state_56036;
(statearr_56046[(7)] = inst_56031);

return statearr_56046;
})();
var statearr_56047_56060 = state_56036__$1;
(statearr_56047_56060[(2)] = inst_56016);

(statearr_56047_56060[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2749__auto____0 = (function (){
var statearr_56048 = [null,null,null,null,null,null,null,null];
(statearr_56048[(0)] = fluree$db$dbfunctions$fns$state_machine__2749__auto__);

(statearr_56048[(1)] = (1));

return statearr_56048;
});
var fluree$db$dbfunctions$fns$state_machine__2749__auto____1 = (function (state_56036){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_56036);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e56049){var ex__2752__auto__ = e56049;
var statearr_56050_56061 = state_56036;
(statearr_56050_56061[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_56036[(4)]))){
var statearr_56051_56062 = state_56036;
(statearr_56051_56062[(1)] = cljs.core.first((state_56036[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56063 = state_56036;
state_56036 = G__56063;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2749__auto__ = function(state_56036){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____1.call(this,state_56036);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_56052 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_56052[(6)] = c__2771__auto__);

return statearr_56052;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq56004){
var G__56005 = cljs.core.first(seq56004);
var seq56004__$1 = cljs.core.next(seq56004);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56005,seq56004__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__5774__auto__ = [];
var len__5768__auto___56113 = arguments.length;
var i__5769__auto___56114 = (0);
while(true){
if((i__5769__auto___56114 < len__5768__auto___56113)){
args__5774__auto__.push((arguments[i__5769__auto___56114]));

var G__56115 = (i__5769__auto___56114 + (1));
i__5769__auto___56114 = G__56115;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_56096){
var state_val_56097 = (state_56096[(1)]);
if((state_val_56097 === (1))){
var state_56096__$1 = state_56096;
var statearr_56098_56116 = state_56096__$1;
(statearr_56098_56116[(2)] = null);

(statearr_56098_56116[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56097 === (2))){
var _ = (function (){var statearr_56099 = state_56096;
(statearr_56099[(4)] = cljs.core.cons((5),(state_56096[(4)])));

return statearr_56099;
})();
var inst_56072 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56096__$1 = state_56096;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56096__$1,(6),inst_56072);
} else {
if((state_val_56097 === (3))){
var inst_56094 = (state_56096[(2)]);
var state_56096__$1 = state_56096;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56096__$1,inst_56094);
} else {
if((state_val_56097 === (4))){
var inst_56066 = (state_56096[(2)]);
var state_56096__$1 = state_56096;
var statearr_56101_56117 = state_56096__$1;
(statearr_56101_56117[(2)] = inst_56066);

(statearr_56101_56117[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56097 === (5))){
var _ = (function (){var statearr_56102 = state_56096;
(statearr_56102[(4)] = cljs.core.rest((state_56096[(4)])));

return statearr_56102;
})();
var state_56096__$1 = state_56096;
var ex56100 = (state_56096__$1[(2)]);
var statearr_56103_56118 = state_56096__$1;
(statearr_56103_56118[(5)] = ex56100);


if((ex56100 instanceof Error)){
var statearr_56104_56119 = state_56096__$1;
(statearr_56104_56119[(1)] = (4));

(statearr_56104_56119[(5)] = null);

} else {
throw ex56100;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56097 === (6))){
var inst_56074 = (state_56096[(2)]);
var inst_56075 = fluree.db.util.async.throw_err(inst_56074);
var inst_56076 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_56075);
var inst_56077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56078 = [inst_56075];
var inst_56079 = (new cljs.core.PersistentVector(null,1,(5),inst_56077,inst_56078,null));
var inst_56080 = cljs.core.count(inst_56079);
var inst_56081 = ((9) + inst_56080);
var inst_56082 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56083 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56084 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56085 = [inst_56075];
var inst_56086 = (new cljs.core.PersistentVector(null,1,(5),inst_56084,inst_56085,null));
var inst_56087 = ["max",inst_56086,inst_56076];
var inst_56088 = cljs.core.PersistentHashMap.fromArrays(inst_56083,inst_56087);
var inst_56089 = [inst_56088,inst_56081];
var inst_56090 = (new cljs.core.PersistentVector(null,2,(5),inst_56082,inst_56089,null));
var inst_56091 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56090);
var _ = (function (){var statearr_56105 = state_56096;
(statearr_56105[(4)] = cljs.core.rest((state_56096[(4)])));

return statearr_56105;
})();
var state_56096__$1 = (function (){var statearr_56106 = state_56096;
(statearr_56106[(7)] = inst_56091);

return statearr_56106;
})();
var statearr_56107_56120 = state_56096__$1;
(statearr_56107_56120[(2)] = inst_56076);

(statearr_56107_56120[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2749__auto____0 = (function (){
var statearr_56108 = [null,null,null,null,null,null,null,null];
(statearr_56108[(0)] = fluree$db$dbfunctions$fns$state_machine__2749__auto__);

(statearr_56108[(1)] = (1));

return statearr_56108;
});
var fluree$db$dbfunctions$fns$state_machine__2749__auto____1 = (function (state_56096){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_56096);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e56109){var ex__2752__auto__ = e56109;
var statearr_56110_56121 = state_56096;
(statearr_56110_56121[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_56096[(4)]))){
var statearr_56111_56122 = state_56096;
(statearr_56111_56122[(1)] = cljs.core.first((state_56096[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56123 = state_56096;
state_56096 = G__56123;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2749__auto__ = function(state_56096){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____1.call(this,state_56096);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_56112 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_56112[(6)] = c__2771__auto__);

return statearr_56112;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq56064){
var G__56065 = cljs.core.first(seq56064);
var seq56064__$1 = cljs.core.next(seq56064);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56065,seq56064__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__5774__auto__ = [];
var len__5768__auto___56173 = arguments.length;
var i__5769__auto___56174 = (0);
while(true){
if((i__5769__auto___56174 < len__5768__auto___56173)){
args__5774__auto__.push((arguments[i__5769__auto___56174]));

var G__56175 = (i__5769__auto___56174 + (1));
i__5769__auto___56174 = G__56175;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_56156){
var state_val_56157 = (state_56156[(1)]);
if((state_val_56157 === (1))){
var state_56156__$1 = state_56156;
var statearr_56158_56176 = state_56156__$1;
(statearr_56158_56176[(2)] = null);

(statearr_56158_56176[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56157 === (2))){
var _ = (function (){var statearr_56159 = state_56156;
(statearr_56159[(4)] = cljs.core.cons((5),(state_56156[(4)])));

return statearr_56159;
})();
var inst_56132 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56156__$1 = state_56156;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56156__$1,(6),inst_56132);
} else {
if((state_val_56157 === (3))){
var inst_56154 = (state_56156[(2)]);
var state_56156__$1 = state_56156;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56156__$1,inst_56154);
} else {
if((state_val_56157 === (4))){
var inst_56126 = (state_56156[(2)]);
var state_56156__$1 = state_56156;
var statearr_56161_56177 = state_56156__$1;
(statearr_56161_56177[(2)] = inst_56126);

(statearr_56161_56177[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56157 === (5))){
var _ = (function (){var statearr_56162 = state_56156;
(statearr_56162[(4)] = cljs.core.rest((state_56156[(4)])));

return statearr_56162;
})();
var state_56156__$1 = state_56156;
var ex56160 = (state_56156__$1[(2)]);
var statearr_56163_56178 = state_56156__$1;
(statearr_56163_56178[(5)] = ex56160);


if((ex56160 instanceof Error)){
var statearr_56164_56179 = state_56156__$1;
(statearr_56164_56179[(1)] = (4));

(statearr_56164_56179[(5)] = null);

} else {
throw ex56160;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56157 === (6))){
var inst_56134 = (state_56156[(2)]);
var inst_56135 = fluree.db.util.async.throw_err(inst_56134);
var inst_56136 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_56135);
var inst_56137 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56138 = [inst_56135];
var inst_56139 = (new cljs.core.PersistentVector(null,1,(5),inst_56137,inst_56138,null));
var inst_56140 = cljs.core.count(inst_56139);
var inst_56141 = ((9) + inst_56140);
var inst_56142 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56143 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56144 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56145 = [inst_56135];
var inst_56146 = (new cljs.core.PersistentVector(null,1,(5),inst_56144,inst_56145,null));
var inst_56147 = ["min",inst_56146,inst_56136];
var inst_56148 = cljs.core.PersistentHashMap.fromArrays(inst_56143,inst_56147);
var inst_56149 = [inst_56148,inst_56141];
var inst_56150 = (new cljs.core.PersistentVector(null,2,(5),inst_56142,inst_56149,null));
var inst_56151 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56150);
var _ = (function (){var statearr_56165 = state_56156;
(statearr_56165[(4)] = cljs.core.rest((state_56156[(4)])));

return statearr_56165;
})();
var state_56156__$1 = (function (){var statearr_56166 = state_56156;
(statearr_56166[(7)] = inst_56151);

return statearr_56166;
})();
var statearr_56167_56180 = state_56156__$1;
(statearr_56167_56180[(2)] = inst_56136);

(statearr_56167_56180[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2749__auto____0 = (function (){
var statearr_56168 = [null,null,null,null,null,null,null,null];
(statearr_56168[(0)] = fluree$db$dbfunctions$fns$state_machine__2749__auto__);

(statearr_56168[(1)] = (1));

return statearr_56168;
});
var fluree$db$dbfunctions$fns$state_machine__2749__auto____1 = (function (state_56156){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_56156);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e56169){var ex__2752__auto__ = e56169;
var statearr_56170_56181 = state_56156;
(statearr_56170_56181[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_56156[(4)]))){
var statearr_56171_56182 = state_56156;
(statearr_56171_56182[(1)] = cljs.core.first((state_56156[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56183 = state_56156;
state_56156 = G__56183;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2749__auto__ = function(state_56156){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____1.call(this,state_56156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_56172 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_56172[(6)] = c__2771__auto__);

return statearr_56172;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq56124){
var G__56125 = cljs.core.first(seq56124);
var seq56124__$1 = cljs.core.next(seq56124);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56125,seq56124__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__56185 = arguments.length;
switch (G__56185) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_56230){
var state_val_56231 = (state_56230[(1)]);
if((state_val_56231 === (7))){
var state_56230__$1 = state_56230;
var statearr_56232_56369 = state_56230__$1;
(statearr_56232_56369[(2)] = query_map);

(statearr_56232_56369[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56231 === (1))){
var state_56230__$1 = state_56230;
var statearr_56233_56370 = state_56230__$1;
(statearr_56233_56370[(2)] = null);

(statearr_56233_56370[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56231 === (4))){
var inst_56186 = (state_56230[(2)]);
var state_56230__$1 = state_56230;
var statearr_56234_56371 = state_56230__$1;
(statearr_56234_56371[(2)] = inst_56186);

(statearr_56234_56371[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56231 === (13))){
var inst_56208 = (state_56230[(7)]);
var inst_56212 = (state_56230[(2)]);
var inst_56213 = fluree.db.util.async.throw_err(inst_56212);
var inst_56214 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56213,(0),null);
var inst_56215 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56213,(1),null);
var inst_56216 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56217 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56218 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56219 = [inst_56208];
var inst_56220 = (new cljs.core.PersistentVector(null,1,(5),inst_56218,inst_56219,null));
var inst_56221 = ["query",inst_56220,inst_56214];
var inst_56222 = cljs.core.PersistentHashMap.fromArrays(inst_56217,inst_56221);
var inst_56223 = [inst_56222,inst_56215];
var inst_56224 = (new cljs.core.PersistentVector(null,2,(5),inst_56216,inst_56223,null));
var inst_56225 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56224);
var _ = (function (){var statearr_56235 = state_56230;
(statearr_56235[(4)] = cljs.core.rest((state_56230[(4)])));

return statearr_56235;
})();
var state_56230__$1 = (function (){var statearr_56236 = state_56230;
(statearr_56236[(8)] = inst_56225);

return statearr_56236;
})();
var statearr_56237_56372 = state_56230__$1;
(statearr_56237_56372[(2)] = inst_56214);

(statearr_56237_56372[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56231 === (6))){
var state_56230__$1 = state_56230;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56230__$1,(9),query_map);
} else {
if((state_val_56231 === (3))){
var inst_56228 = (state_56230[(2)]);
var state_56230__$1 = state_56230;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56230__$1,inst_56228);
} else {
if((state_val_56231 === (12))){
var inst_56208 = (state_56230[(7)]);
var inst_56208__$1 = (state_56230[(2)]);
var inst_56209 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56210 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_56209,inst_56208__$1);
var state_56230__$1 = (function (){var statearr_56238 = state_56230;
(statearr_56238[(7)] = inst_56208__$1);

return statearr_56238;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56230__$1,(13),inst_56210);
} else {
if((state_val_56231 === (2))){
var _ = (function (){var statearr_56239 = state_56230;
(statearr_56239[(4)] = cljs.core.cons((5),(state_56230[(4)])));

return statearr_56239;
})();
var inst_56195 = fluree.db.util.async.channel_QMARK_(query_map);
var state_56230__$1 = state_56230;
if(inst_56195){
var statearr_56240_56373 = state_56230__$1;
(statearr_56240_56373[(1)] = (6));

} else {
var statearr_56241_56374 = state_56230__$1;
(statearr_56241_56374[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56231 === (11))){
var inst_56202 = (state_56230[(9)]);
var state_56230__$1 = state_56230;
var statearr_56243_56375 = state_56230__$1;
(statearr_56243_56375[(2)] = inst_56202);

(statearr_56243_56375[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56231 === (9))){
var inst_56198 = (state_56230[(2)]);
var inst_56199 = fluree.db.util.async.throw_err(inst_56198);
var state_56230__$1 = state_56230;
var statearr_56244_56376 = state_56230__$1;
(statearr_56244_56376[(2)] = inst_56199);

(statearr_56244_56376[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56231 === (5))){
var _ = (function (){var statearr_56245 = state_56230;
(statearr_56245[(4)] = cljs.core.rest((state_56230[(4)])));

return statearr_56245;
})();
var state_56230__$1 = state_56230;
var ex56242 = (state_56230__$1[(2)]);
var statearr_56246_56377 = state_56230__$1;
(statearr_56246_56377[(5)] = ex56242);


if((ex56242 instanceof Error)){
var statearr_56247_56378 = state_56230__$1;
(statearr_56247_56378[(1)] = (4));

(statearr_56247_56378[(5)] = null);

} else {
throw ex56242;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56231 === (10))){
var inst_56202 = (state_56230[(9)]);
var inst_56205 = fluree.db.util.json.parse(inst_56202);
var state_56230__$1 = state_56230;
var statearr_56248_56379 = state_56230__$1;
(statearr_56248_56379[(2)] = inst_56205);

(statearr_56248_56379[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56231 === (8))){
var inst_56202 = (state_56230[(9)]);
var inst_56202__$1 = (state_56230[(2)]);
var inst_56203 = typeof inst_56202__$1 === 'string';
var state_56230__$1 = (function (){var statearr_56249 = state_56230;
(statearr_56249[(9)] = inst_56202__$1);

return statearr_56249;
})();
if(cljs.core.truth_(inst_56203)){
var statearr_56250_56380 = state_56230__$1;
(statearr_56250_56380[(1)] = (10));

} else {
var statearr_56251_56381 = state_56230__$1;
(statearr_56251_56381[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2749__auto____0 = (function (){
var statearr_56252 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56252[(0)] = fluree$db$dbfunctions$fns$state_machine__2749__auto__);

(statearr_56252[(1)] = (1));

return statearr_56252;
});
var fluree$db$dbfunctions$fns$state_machine__2749__auto____1 = (function (state_56230){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_56230);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e56253){var ex__2752__auto__ = e56253;
var statearr_56254_56382 = state_56230;
(statearr_56254_56382[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_56230[(4)]))){
var statearr_56255_56383 = state_56230;
(statearr_56255_56383[(1)] = cljs.core.first((state_56230[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56384 = state_56230;
state_56230 = G__56384;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2749__auto__ = function(state_56230){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____1.call(this,state_56230);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_56256 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_56256[(6)] = c__2771__auto__);

return statearr_56256;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_56327){
var state_val_56328 = (state_56327[(1)]);
if((state_val_56328 === (7))){
var state_56327__$1 = state_56327;
var statearr_56329_56385 = state_56327__$1;
(statearr_56329_56385[(2)] = select);

(statearr_56329_56385[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56328 === (20))){
var inst_56297 = (state_56327[(2)]);
var inst_56298 = fluree.db.util.async.channel_QMARK_(limit);
var state_56327__$1 = (function (){var statearr_56330 = state_56327;
(statearr_56330[(7)] = inst_56297);

return statearr_56330;
})();
if(inst_56298){
var statearr_56331_56386 = state_56327__$1;
(statearr_56331_56386[(1)] = (22));

} else {
var statearr_56332_56387 = state_56327__$1;
(statearr_56332_56387[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56328 === (1))){
var state_56327__$1 = state_56327;
var statearr_56333_56388 = state_56327__$1;
(statearr_56333_56388[(2)] = null);

(statearr_56333_56388[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56328 === (24))){
var inst_56281 = (state_56327[(8)]);
var inst_56273 = (state_56327[(9)]);
var inst_56297 = (state_56327[(7)]);
var inst_56289 = (state_56327[(10)]);
var inst_56305 = (state_56327[(2)]);
var inst_56306 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56307 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_56306,inst_56273,inst_56281,inst_56289,inst_56297,inst_56305);
var state_56327__$1 = state_56327;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56327__$1,(26),inst_56307);
} else {
if((state_val_56328 === (4))){
var inst_56257 = (state_56327[(2)]);
var state_56327__$1 = state_56327;
var statearr_56334_56389 = state_56327__$1;
(statearr_56334_56389[(2)] = inst_56257);

(statearr_56334_56389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56328 === (15))){
var state_56327__$1 = state_56327;
var statearr_56335_56390 = state_56327__$1;
(statearr_56335_56390[(2)] = where);

(statearr_56335_56390[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56328 === (21))){
var inst_56293 = (state_56327[(2)]);
var inst_56294 = fluree.db.util.async.throw_err(inst_56293);
var state_56327__$1 = state_56327;
var statearr_56336_56391 = state_56327__$1;
(statearr_56336_56391[(2)] = inst_56294);

(statearr_56336_56391[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56328 === (13))){
var inst_56277 = (state_56327[(2)]);
var inst_56278 = fluree.db.util.async.throw_err(inst_56277);
var state_56327__$1 = state_56327;
var statearr_56337_56392 = state_56327__$1;
(statearr_56337_56392[(2)] = inst_56278);

(statearr_56337_56392[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56328 === (22))){
var state_56327__$1 = state_56327;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56327__$1,(25),limit);
} else {
if((state_val_56328 === (6))){
var state_56327__$1 = state_56327;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56327__$1,(9),select);
} else {
if((state_val_56328 === (25))){
var inst_56301 = (state_56327[(2)]);
var inst_56302 = fluree.db.util.async.throw_err(inst_56301);
var state_56327__$1 = state_56327;
var statearr_56338_56393 = state_56327__$1;
(statearr_56338_56393[(2)] = inst_56302);

(statearr_56338_56393[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56328 === (17))){
var inst_56285 = (state_56327[(2)]);
var inst_56286 = fluree.db.util.async.throw_err(inst_56285);
var state_56327__$1 = state_56327;
var statearr_56339_56394 = state_56327__$1;
(statearr_56339_56394[(2)] = inst_56286);

(statearr_56339_56394[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56328 === (3))){
var inst_56325 = (state_56327[(2)]);
var state_56327__$1 = state_56327;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56327__$1,inst_56325);
} else {
if((state_val_56328 === (12))){
var inst_56281 = (state_56327[(2)]);
var inst_56282 = fluree.db.util.async.channel_QMARK_(where);
var state_56327__$1 = (function (){var statearr_56340 = state_56327;
(statearr_56340[(8)] = inst_56281);

return statearr_56340;
})();
if(inst_56282){
var statearr_56341_56395 = state_56327__$1;
(statearr_56341_56395[(1)] = (14));

} else {
var statearr_56342_56396 = state_56327__$1;
(statearr_56342_56396[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56328 === (2))){
var _ = (function (){var statearr_56343 = state_56327;
(statearr_56343[(4)] = cljs.core.cons((5),(state_56327[(4)])));

return statearr_56343;
})();
var inst_56266 = fluree.db.util.async.channel_QMARK_(select);
var state_56327__$1 = state_56327;
if(inst_56266){
var statearr_56344_56397 = state_56327__$1;
(statearr_56344_56397[(1)] = (6));

} else {
var statearr_56345_56398 = state_56327__$1;
(statearr_56345_56398[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56328 === (23))){
var state_56327__$1 = state_56327;
var statearr_56346_56399 = state_56327__$1;
(statearr_56346_56399[(2)] = limit);

(statearr_56346_56399[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56328 === (19))){
var state_56327__$1 = state_56327;
var statearr_56347_56400 = state_56327__$1;
(statearr_56347_56400[(2)] = block);

(statearr_56347_56400[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56328 === (11))){
var state_56327__$1 = state_56327;
var statearr_56349_56401 = state_56327__$1;
(statearr_56349_56401[(2)] = from);

(statearr_56349_56401[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56328 === (9))){
var inst_56269 = (state_56327[(2)]);
var inst_56270 = fluree.db.util.async.throw_err(inst_56269);
var state_56327__$1 = state_56327;
var statearr_56350_56402 = state_56327__$1;
(statearr_56350_56402[(2)] = inst_56270);

(statearr_56350_56402[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56328 === (5))){
var _ = (function (){var statearr_56351 = state_56327;
(statearr_56351[(4)] = cljs.core.rest((state_56327[(4)])));

return statearr_56351;
})();
var state_56327__$1 = state_56327;
var ex56348 = (state_56327__$1[(2)]);
var statearr_56352_56403 = state_56327__$1;
(statearr_56352_56403[(5)] = ex56348);


if((ex56348 instanceof Error)){
var statearr_56353_56404 = state_56327__$1;
(statearr_56353_56404[(1)] = (4));

(statearr_56353_56404[(5)] = null);

} else {
throw ex56348;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56328 === (14))){
var state_56327__$1 = state_56327;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56327__$1,(17),where);
} else {
if((state_val_56328 === (26))){
var inst_56281 = (state_56327[(8)]);
var inst_56273 = (state_56327[(9)]);
var inst_56297 = (state_56327[(7)]);
var inst_56289 = (state_56327[(10)]);
var inst_56309 = (state_56327[(2)]);
var inst_56310 = fluree.db.util.async.throw_err(inst_56309);
var inst_56311 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56310,(0),null);
var inst_56312 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56310,(1),null);
var inst_56313 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56314 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56315 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56316 = [inst_56273,inst_56281,inst_56289,inst_56297];
var inst_56317 = (new cljs.core.PersistentVector(null,4,(5),inst_56315,inst_56316,null));
var inst_56318 = ["query",inst_56317,inst_56311];
var inst_56319 = cljs.core.PersistentHashMap.fromArrays(inst_56314,inst_56318);
var inst_56320 = [inst_56319,inst_56312];
var inst_56321 = (new cljs.core.PersistentVector(null,2,(5),inst_56313,inst_56320,null));
var inst_56322 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56321);
var _ = (function (){var statearr_56354 = state_56327;
(statearr_56354[(4)] = cljs.core.rest((state_56327[(4)])));

return statearr_56354;
})();
var state_56327__$1 = (function (){var statearr_56355 = state_56327;
(statearr_56355[(11)] = inst_56322);

return statearr_56355;
})();
var statearr_56356_56405 = state_56327__$1;
(statearr_56356_56405[(2)] = inst_56311);

(statearr_56356_56405[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56328 === (16))){
var inst_56289 = (state_56327[(2)]);
var inst_56290 = fluree.db.util.async.channel_QMARK_(block);
var state_56327__$1 = (function (){var statearr_56357 = state_56327;
(statearr_56357[(10)] = inst_56289);

return statearr_56357;
})();
if(inst_56290){
var statearr_56358_56406 = state_56327__$1;
(statearr_56358_56406[(1)] = (18));

} else {
var statearr_56359_56407 = state_56327__$1;
(statearr_56359_56407[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56328 === (10))){
var state_56327__$1 = state_56327;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56327__$1,(13),from);
} else {
if((state_val_56328 === (18))){
var state_56327__$1 = state_56327;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56327__$1,(21),block);
} else {
if((state_val_56328 === (8))){
var inst_56273 = (state_56327[(2)]);
var inst_56274 = fluree.db.util.async.channel_QMARK_(from);
var state_56327__$1 = (function (){var statearr_56360 = state_56327;
(statearr_56360[(9)] = inst_56273);

return statearr_56360;
})();
if(inst_56274){
var statearr_56361_56408 = state_56327__$1;
(statearr_56361_56408[(1)] = (10));

} else {
var statearr_56362_56409 = state_56327__$1;
(statearr_56362_56409[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2749__auto____0 = (function (){
var statearr_56363 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56363[(0)] = fluree$db$dbfunctions$fns$state_machine__2749__auto__);

(statearr_56363[(1)] = (1));

return statearr_56363;
});
var fluree$db$dbfunctions$fns$state_machine__2749__auto____1 = (function (state_56327){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_56327);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e56364){var ex__2752__auto__ = e56364;
var statearr_56365_56410 = state_56327;
(statearr_56365_56410[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_56327[(4)]))){
var statearr_56366_56411 = state_56327;
(statearr_56366_56411[(1)] = cljs.core.first((state_56327[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56412 = state_56327;
state_56327 = G__56412;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2749__auto__ = function(state_56327){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____1.call(this,state_56327);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_56367 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_56367[(6)] = c__2771__auto__);

return statearr_56367;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_56468){
var state_val_56469 = (state_56468[(1)]);
if((state_val_56469 === (7))){
var state_56468__$1 = state_56468;
var statearr_56470_56501 = state_56468__$1;
(statearr_56470_56501[(2)] = startSubject);

(statearr_56470_56501[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56469 === (1))){
var state_56468__$1 = state_56468;
var statearr_56471_56502 = state_56468__$1;
(statearr_56471_56502[(2)] = null);

(statearr_56471_56502[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56469 === (4))){
var inst_56413 = (state_56468[(2)]);
var state_56468__$1 = state_56468;
var statearr_56472_56503 = state_56468__$1;
(statearr_56472_56503[(2)] = inst_56413);

(statearr_56472_56503[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56469 === (15))){
var inst_56445 = (state_56468[(2)]);
var inst_56446 = fluree.db.util.async.throw_err(inst_56445);
var inst_56447 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56446,(0),null);
var inst_56448 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56446,(1),null);
var inst_56449 = cljs.core.empty_QMARK_(inst_56447);
var state_56468__$1 = (function (){var statearr_56473 = state_56468;
(statearr_56473[(7)] = inst_56448);

return statearr_56473;
})();
if(inst_56449){
var statearr_56474_56504 = state_56468__$1;
(statearr_56474_56504[(1)] = (16));

} else {
var statearr_56475_56505 = state_56468__$1;
(statearr_56475_56505[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56469 === (13))){
var inst_56441 = (state_56468[(8)]);
var inst_56433 = (state_56468[(9)]);
var inst_56429 = (state_56468[(10)]);
var inst_56441__$1 = (state_56468[(2)]);
var inst_56442 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56443 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_56442,inst_56429,inst_56433,inst_56441__$1);
var state_56468__$1 = (function (){var statearr_56476 = state_56468;
(statearr_56476[(8)] = inst_56441__$1);

return statearr_56476;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56468__$1,(15),inst_56443);
} else {
if((state_val_56469 === (6))){
var state_56468__$1 = state_56468;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56468__$1,(9),startSubject);
} else {
if((state_val_56469 === (17))){
var state_56468__$1 = state_56468;
var statearr_56477_56506 = state_56468__$1;
(statearr_56477_56506[(2)] = true);

(statearr_56477_56506[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56469 === (3))){
var inst_56466 = (state_56468[(2)]);
var state_56468__$1 = state_56468;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56468__$1,inst_56466);
} else {
if((state_val_56469 === (12))){
var state_56468__$1 = state_56468;
var statearr_56478_56507 = state_56468__$1;
(statearr_56478_56507[(2)] = endSubject);

(statearr_56478_56507[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56469 === (2))){
var _ = (function (){var statearr_56479 = state_56468;
(statearr_56479[(4)] = cljs.core.cons((5),(state_56468[(4)])));

return statearr_56479;
})();
var inst_56422 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_56468__$1 = state_56468;
if(inst_56422){
var statearr_56480_56508 = state_56468__$1;
(statearr_56480_56508[(1)] = (6));

} else {
var statearr_56481_56509 = state_56468__$1;
(statearr_56481_56509[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56469 === (11))){
var state_56468__$1 = state_56468;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56468__$1,(14),endSubject);
} else {
if((state_val_56469 === (9))){
var inst_56425 = (state_56468[(2)]);
var inst_56426 = fluree.db.util.async.throw_err(inst_56425);
var state_56468__$1 = state_56468;
var statearr_56483_56510 = state_56468__$1;
(statearr_56483_56510[(2)] = inst_56426);

(statearr_56483_56510[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56469 === (5))){
var _ = (function (){var statearr_56484 = state_56468;
(statearr_56484[(4)] = cljs.core.rest((state_56468[(4)])));

return statearr_56484;
})();
var state_56468__$1 = state_56468;
var ex56482 = (state_56468__$1[(2)]);
var statearr_56485_56511 = state_56468__$1;
(statearr_56485_56511[(5)] = ex56482);


if((ex56482 instanceof Error)){
var statearr_56486_56512 = state_56468__$1;
(statearr_56486_56512[(1)] = (4));

(statearr_56486_56512[(5)] = null);

} else {
throw ex56482;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56469 === (14))){
var inst_56437 = (state_56468[(2)]);
var inst_56438 = fluree.db.util.async.throw_err(inst_56437);
var state_56468__$1 = state_56468;
var statearr_56487_56513 = state_56468__$1;
(statearr_56487_56513[(2)] = inst_56438);

(statearr_56487_56513[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56469 === (16))){
var state_56468__$1 = state_56468;
var statearr_56488_56514 = state_56468__$1;
(statearr_56488_56514[(2)] = false);

(statearr_56488_56514[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56469 === (10))){
var inst_56432 = (state_56468[(2)]);
var inst_56433 = fluree.db.util.async.throw_err(inst_56432);
var inst_56434 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_56468__$1 = (function (){var statearr_56489 = state_56468;
(statearr_56489[(9)] = inst_56433);

return statearr_56489;
})();
if(inst_56434){
var statearr_56490_56515 = state_56468__$1;
(statearr_56490_56515[(1)] = (11));

} else {
var statearr_56491_56516 = state_56468__$1;
(statearr_56491_56516[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56469 === (18))){
var inst_56441 = (state_56468[(8)]);
var inst_56433 = (state_56468[(9)]);
var inst_56429 = (state_56468[(10)]);
var inst_56448 = (state_56468[(7)]);
var inst_56453 = (state_56468[(2)]);
var inst_56454 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56455 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56456 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56457 = [inst_56429,inst_56433,inst_56441];
var inst_56458 = (new cljs.core.PersistentVector(null,3,(5),inst_56456,inst_56457,null));
var inst_56459 = ["relationship?",inst_56458,inst_56453];
var inst_56460 = cljs.core.PersistentHashMap.fromArrays(inst_56455,inst_56459);
var inst_56461 = [inst_56460,inst_56448];
var inst_56462 = (new cljs.core.PersistentVector(null,2,(5),inst_56454,inst_56461,null));
var inst_56463 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56462);
var _ = (function (){var statearr_56492 = state_56468;
(statearr_56492[(4)] = cljs.core.rest((state_56468[(4)])));

return statearr_56492;
})();
var state_56468__$1 = (function (){var statearr_56493 = state_56468;
(statearr_56493[(11)] = inst_56463);

return statearr_56493;
})();
var statearr_56494_56517 = state_56468__$1;
(statearr_56494_56517[(2)] = inst_56453);

(statearr_56494_56517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56469 === (8))){
var inst_56429 = (state_56468[(2)]);
var inst_56430 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_56468__$1 = (function (){var statearr_56495 = state_56468;
(statearr_56495[(10)] = inst_56429);

return statearr_56495;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56468__$1,(10),inst_56430);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2749__auto____0 = (function (){
var statearr_56496 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56496[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2749__auto__);

(statearr_56496[(1)] = (1));

return statearr_56496;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2749__auto____1 = (function (state_56468){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_56468);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e56497){var ex__2752__auto__ = e56497;
var statearr_56498_56518 = state_56468;
(statearr_56498_56518[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_56468[(4)]))){
var statearr_56499_56519 = state_56468;
(statearr_56499_56519[(1)] = cljs.core.first((state_56468[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56520 = state_56468;
state_56468 = G__56520;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2749__auto__ = function(state_56468){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2749__auto____1.call(this,state_56468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_56500 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_56500[(6)] = c__2771__auto__);

return statearr_56500;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_56557){
var state_val_56558 = (state_56557[(1)]);
if((state_val_56558 === (7))){
var state_56557__$1 = state_56557;
var statearr_56559_56579 = state_56557__$1;
(statearr_56559_56579[(2)] = pred_name);

(statearr_56559_56579[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56558 === (1))){
var state_56557__$1 = state_56557;
var statearr_56560_56580 = state_56557__$1;
(statearr_56560_56580[(2)] = null);

(statearr_56560_56580[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56558 === (4))){
var inst_56521 = (state_56557[(2)]);
var state_56557__$1 = state_56557;
var statearr_56561_56581 = state_56557__$1;
(statearr_56561_56581[(2)] = inst_56521);

(statearr_56561_56581[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56558 === (6))){
var state_56557__$1 = state_56557;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56557__$1,(9),pred_name);
} else {
if((state_val_56558 === (3))){
var inst_56555 = (state_56557[(2)]);
var state_56557__$1 = state_56557;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56557__$1,inst_56555);
} else {
if((state_val_56558 === (2))){
var _ = (function (){var statearr_56563 = state_56557;
(statearr_56563[(4)] = cljs.core.cons((5),(state_56557[(4)])));

return statearr_56563;
})();
var inst_56530 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_56557__$1 = state_56557;
if(inst_56530){
var statearr_56564_56582 = state_56557__$1;
(statearr_56564_56582[(1)] = (6));

} else {
var statearr_56565_56583 = state_56557__$1;
(statearr_56565_56583[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56558 === (9))){
var inst_56533 = (state_56557[(2)]);
var inst_56534 = fluree.db.util.async.throw_err(inst_56533);
var state_56557__$1 = state_56557;
var statearr_56566_56584 = state_56557__$1;
(statearr_56566_56584[(2)] = inst_56534);

(statearr_56566_56584[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56558 === (5))){
var _ = (function (){var statearr_56567 = state_56557;
(statearr_56567[(4)] = cljs.core.rest((state_56557[(4)])));

return statearr_56567;
})();
var state_56557__$1 = state_56557;
var ex56562 = (state_56557__$1[(2)]);
var statearr_56568_56585 = state_56557__$1;
(statearr_56568_56585[(5)] = ex56562);


if((ex56562 instanceof Error)){
var statearr_56569_56586 = state_56557__$1;
(statearr_56569_56586[(1)] = (4));

(statearr_56569_56586[(5)] = null);

} else {
throw ex56562;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56558 === (10))){
var inst_56537 = (state_56557[(7)]);
var inst_56541 = (state_56557[(2)]);
var inst_56542 = fluree.db.util.async.throw_err(inst_56541);
var inst_56543 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56542,(0),null);
var inst_56544 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56542,(1),null);
var inst_56545 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56546 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56547 = ["max-pred-val",inst_56537,inst_56543];
var inst_56548 = cljs.core.PersistentHashMap.fromArrays(inst_56546,inst_56547);
var inst_56549 = (inst_56544 + (10));
var inst_56550 = [inst_56548,inst_56549];
var inst_56551 = (new cljs.core.PersistentVector(null,2,(5),inst_56545,inst_56550,null));
var inst_56552 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56551);
var _ = (function (){var statearr_56570 = state_56557;
(statearr_56570[(4)] = cljs.core.rest((state_56557[(4)])));

return statearr_56570;
})();
var state_56557__$1 = (function (){var statearr_56571 = state_56557;
(statearr_56571[(8)] = inst_56552);

return statearr_56571;
})();
var statearr_56572_56587 = state_56557__$1;
(statearr_56572_56587[(2)] = inst_56543);

(statearr_56572_56587[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56558 === (8))){
var inst_56537 = (state_56557[(7)]);
var inst_56537__$1 = (state_56557[(2)]);
var inst_56538 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56539 = fluree.db.dbfunctions.internal.max_pred_val(inst_56538,inst_56537__$1,null);
var state_56557__$1 = (function (){var statearr_56573 = state_56557;
(statearr_56573[(7)] = inst_56537__$1);

return statearr_56573;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56557__$1,(10),inst_56539);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2749__auto____0 = (function (){
var statearr_56574 = [null,null,null,null,null,null,null,null,null];
(statearr_56574[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2749__auto__);

(statearr_56574[(1)] = (1));

return statearr_56574;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2749__auto____1 = (function (state_56557){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_56557);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e56575){var ex__2752__auto__ = e56575;
var statearr_56576_56588 = state_56557;
(statearr_56576_56588[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_56557[(4)]))){
var statearr_56577_56589 = state_56557;
(statearr_56577_56589[(1)] = cljs.core.first((state_56557[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56590 = state_56557;
state_56557 = G__56590;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2749__auto__ = function(state_56557){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2749__auto____1.call(this,state_56557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_56578 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_56578[(6)] = c__2771__auto__);

return statearr_56578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_56617){
var state_val_56618 = (state_56617[(1)]);
if((state_val_56618 === (7))){
var state_56617__$1 = state_56617;
var statearr_56619_56638 = state_56617__$1;
(statearr_56619_56638[(2)] = n);

(statearr_56619_56638[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56618 === (1))){
var state_56617__$1 = state_56617;
var statearr_56620_56639 = state_56617__$1;
(statearr_56620_56639[(2)] = null);

(statearr_56620_56639[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56618 === (4))){
var inst_56591 = (state_56617[(2)]);
var state_56617__$1 = state_56617;
var statearr_56621_56640 = state_56617__$1;
(statearr_56621_56640[(2)] = inst_56591);

(statearr_56621_56640[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56618 === (6))){
var state_56617__$1 = state_56617;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56617__$1,(9),n);
} else {
if((state_val_56618 === (3))){
var inst_56615 = (state_56617[(2)]);
var state_56617__$1 = state_56617;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56617__$1,inst_56615);
} else {
if((state_val_56618 === (2))){
var _ = (function (){var statearr_56623 = state_56617;
(statearr_56623[(4)] = cljs.core.cons((5),(state_56617[(4)])));

return statearr_56623;
})();
var inst_56597 = fluree.db.util.async.channel_QMARK_(n);
var state_56617__$1 = state_56617;
if(inst_56597){
var statearr_56624_56641 = state_56617__$1;
(statearr_56624_56641[(1)] = (6));

} else {
var statearr_56625_56642 = state_56617__$1;
(statearr_56625_56642[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56618 === (9))){
var inst_56600 = (state_56617[(2)]);
var inst_56601 = fluree.db.util.async.throw_err(inst_56600);
var state_56617__$1 = state_56617;
var statearr_56626_56643 = state_56617__$1;
(statearr_56626_56643[(2)] = inst_56601);

(statearr_56626_56643[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56618 === (5))){
var _ = (function (){var statearr_56627 = state_56617;
(statearr_56627[(4)] = cljs.core.rest((state_56617[(4)])));

return statearr_56627;
})();
var state_56617__$1 = state_56617;
var ex56622 = (state_56617__$1[(2)]);
var statearr_56628_56644 = state_56617__$1;
(statearr_56628_56644[(5)] = ex56622);


if((ex56622 instanceof Error)){
var statearr_56629_56645 = state_56617__$1;
(statearr_56629_56645[(1)] = (4));

(statearr_56629_56645[(5)] = null);

} else {
throw ex56622;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56618 === (8))){
var inst_56604 = (state_56617[(2)]);
var inst_56605 = fluree.db.dbfunctions.internal.inc(inst_56604);
var inst_56606 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56607 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56608 = ["inc",inst_56604,inst_56605];
var inst_56609 = cljs.core.PersistentHashMap.fromArrays(inst_56607,inst_56608);
var inst_56610 = [inst_56609,(10)];
var inst_56611 = (new cljs.core.PersistentVector(null,2,(5),inst_56606,inst_56610,null));
var inst_56612 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56611);
var _ = (function (){var statearr_56630 = state_56617;
(statearr_56630[(4)] = cljs.core.rest((state_56617[(4)])));

return statearr_56630;
})();
var state_56617__$1 = (function (){var statearr_56631 = state_56617;
(statearr_56631[(7)] = inst_56612);

return statearr_56631;
})();
var statearr_56632_56646 = state_56617__$1;
(statearr_56632_56646[(2)] = inst_56605);

(statearr_56632_56646[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2749__auto____0 = (function (){
var statearr_56633 = [null,null,null,null,null,null,null,null];
(statearr_56633[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2749__auto__);

(statearr_56633[(1)] = (1));

return statearr_56633;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2749__auto____1 = (function (state_56617){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_56617);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e56634){var ex__2752__auto__ = e56634;
var statearr_56635_56647 = state_56617;
(statearr_56635_56647[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_56617[(4)]))){
var statearr_56636_56648 = state_56617;
(statearr_56636_56648[(1)] = cljs.core.first((state_56617[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56649 = state_56617;
state_56617 = G__56649;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2749__auto__ = function(state_56617){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2749__auto____1.call(this,state_56617);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_56637 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_56637[(6)] = c__2771__auto__);

return statearr_56637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_56676){
var state_val_56677 = (state_56676[(1)]);
if((state_val_56677 === (7))){
var state_56676__$1 = state_56676;
var statearr_56678_56697 = state_56676__$1;
(statearr_56678_56697[(2)] = n);

(statearr_56678_56697[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56677 === (1))){
var state_56676__$1 = state_56676;
var statearr_56679_56698 = state_56676__$1;
(statearr_56679_56698[(2)] = null);

(statearr_56679_56698[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56677 === (4))){
var inst_56650 = (state_56676[(2)]);
var state_56676__$1 = state_56676;
var statearr_56680_56699 = state_56676__$1;
(statearr_56680_56699[(2)] = inst_56650);

(statearr_56680_56699[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56677 === (6))){
var state_56676__$1 = state_56676;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56676__$1,(9),n);
} else {
if((state_val_56677 === (3))){
var inst_56674 = (state_56676[(2)]);
var state_56676__$1 = state_56676;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56676__$1,inst_56674);
} else {
if((state_val_56677 === (2))){
var _ = (function (){var statearr_56682 = state_56676;
(statearr_56682[(4)] = cljs.core.cons((5),(state_56676[(4)])));

return statearr_56682;
})();
var inst_56656 = fluree.db.util.async.channel_QMARK_(n);
var state_56676__$1 = state_56676;
if(inst_56656){
var statearr_56683_56700 = state_56676__$1;
(statearr_56683_56700[(1)] = (6));

} else {
var statearr_56684_56701 = state_56676__$1;
(statearr_56684_56701[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56677 === (9))){
var inst_56659 = (state_56676[(2)]);
var inst_56660 = fluree.db.util.async.throw_err(inst_56659);
var state_56676__$1 = state_56676;
var statearr_56685_56702 = state_56676__$1;
(statearr_56685_56702[(2)] = inst_56660);

(statearr_56685_56702[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56677 === (5))){
var _ = (function (){var statearr_56686 = state_56676;
(statearr_56686[(4)] = cljs.core.rest((state_56676[(4)])));

return statearr_56686;
})();
var state_56676__$1 = state_56676;
var ex56681 = (state_56676__$1[(2)]);
var statearr_56687_56703 = state_56676__$1;
(statearr_56687_56703[(5)] = ex56681);


if((ex56681 instanceof Error)){
var statearr_56688_56704 = state_56676__$1;
(statearr_56688_56704[(1)] = (4));

(statearr_56688_56704[(5)] = null);

} else {
throw ex56681;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56677 === (8))){
var inst_56663 = (state_56676[(2)]);
var inst_56664 = fluree.db.dbfunctions.internal.dec(inst_56663);
var inst_56665 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56666 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56667 = ["dec",inst_56663,inst_56664];
var inst_56668 = cljs.core.PersistentHashMap.fromArrays(inst_56666,inst_56667);
var inst_56669 = [inst_56668,(10)];
var inst_56670 = (new cljs.core.PersistentVector(null,2,(5),inst_56665,inst_56669,null));
var inst_56671 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56670);
var _ = (function (){var statearr_56689 = state_56676;
(statearr_56689[(4)] = cljs.core.rest((state_56676[(4)])));

return statearr_56689;
})();
var state_56676__$1 = (function (){var statearr_56690 = state_56676;
(statearr_56690[(7)] = inst_56671);

return statearr_56690;
})();
var statearr_56691_56705 = state_56676__$1;
(statearr_56691_56705[(2)] = inst_56664);

(statearr_56691_56705[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2749__auto____0 = (function (){
var statearr_56692 = [null,null,null,null,null,null,null,null];
(statearr_56692[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2749__auto__);

(statearr_56692[(1)] = (1));

return statearr_56692;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2749__auto____1 = (function (state_56676){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_56676);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e56693){var ex__2752__auto__ = e56693;
var statearr_56694_56706 = state_56676;
(statearr_56694_56706[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_56676[(4)]))){
var statearr_56695_56707 = state_56676;
(statearr_56695_56707[(1)] = cljs.core.first((state_56676[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56708 = state_56676;
state_56676 = G__56708;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2749__auto__ = function(state_56676){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2749__auto____1.call(this,state_56676);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_56696 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_56696[(6)] = c__2771__auto__);

return statearr_56696;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___56758 = arguments.length;
var i__5769__auto___56759 = (0);
while(true){
if((i__5769__auto___56759 < len__5768__auto___56758)){
args__5774__auto__.push((arguments[i__5769__auto___56759]));

var G__56760 = (i__5769__auto___56759 + (1));
i__5769__auto___56759 = G__56760;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_56741){
var state_val_56742 = (state_56741[(1)]);
if((state_val_56742 === (1))){
var state_56741__$1 = state_56741;
var statearr_56743_56761 = state_56741__$1;
(statearr_56743_56761[(2)] = null);

(statearr_56743_56761[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56742 === (2))){
var _ = (function (){var statearr_56744 = state_56741;
(statearr_56744[(4)] = cljs.core.cons((5),(state_56741[(4)])));

return statearr_56744;
})();
var inst_56717 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56741__$1 = state_56741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56741__$1,(6),inst_56717);
} else {
if((state_val_56742 === (3))){
var inst_56739 = (state_56741[(2)]);
var state_56741__$1 = state_56741;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56741__$1,inst_56739);
} else {
if((state_val_56742 === (4))){
var inst_56711 = (state_56741[(2)]);
var state_56741__$1 = state_56741;
var statearr_56746_56762 = state_56741__$1;
(statearr_56746_56762[(2)] = inst_56711);

(statearr_56746_56762[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56742 === (5))){
var _ = (function (){var statearr_56747 = state_56741;
(statearr_56747[(4)] = cljs.core.rest((state_56741[(4)])));

return statearr_56747;
})();
var state_56741__$1 = state_56741;
var ex56745 = (state_56741__$1[(2)]);
var statearr_56748_56763 = state_56741__$1;
(statearr_56748_56763[(5)] = ex56745);


if((ex56745 instanceof Error)){
var statearr_56749_56764 = state_56741__$1;
(statearr_56749_56764[(1)] = (4));

(statearr_56749_56764[(5)] = null);

} else {
throw ex56745;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56742 === (6))){
var inst_56719 = (state_56741[(2)]);
var inst_56720 = fluree.db.util.async.throw_err(inst_56719);
var inst_56721 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_56720);
var inst_56722 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56723 = [inst_56720];
var inst_56724 = (new cljs.core.PersistentVector(null,1,(5),inst_56722,inst_56723,null));
var inst_56725 = cljs.core.count(inst_56724);
var inst_56726 = ((9) + inst_56725);
var inst_56727 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56728 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56729 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56730 = [inst_56720];
var inst_56731 = (new cljs.core.PersistentVector(null,1,(5),inst_56729,inst_56730,null));
var inst_56732 = ["+",inst_56731,inst_56721];
var inst_56733 = cljs.core.PersistentHashMap.fromArrays(inst_56728,inst_56732);
var inst_56734 = [inst_56733,inst_56726];
var inst_56735 = (new cljs.core.PersistentVector(null,2,(5),inst_56727,inst_56734,null));
var inst_56736 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56735);
var _ = (function (){var statearr_56750 = state_56741;
(statearr_56750[(4)] = cljs.core.rest((state_56741[(4)])));

return statearr_56750;
})();
var state_56741__$1 = (function (){var statearr_56751 = state_56741;
(statearr_56751[(7)] = inst_56736);

return statearr_56751;
})();
var statearr_56752_56765 = state_56741__$1;
(statearr_56752_56765[(2)] = inst_56721);

(statearr_56752_56765[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2749__auto____0 = (function (){
var statearr_56753 = [null,null,null,null,null,null,null,null];
(statearr_56753[(0)] = fluree$db$dbfunctions$fns$state_machine__2749__auto__);

(statearr_56753[(1)] = (1));

return statearr_56753;
});
var fluree$db$dbfunctions$fns$state_machine__2749__auto____1 = (function (state_56741){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_56741);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e56754){var ex__2752__auto__ = e56754;
var statearr_56755_56766 = state_56741;
(statearr_56755_56766[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_56741[(4)]))){
var statearr_56756_56767 = state_56741;
(statearr_56756_56767[(1)] = cljs.core.first((state_56741[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56768 = state_56741;
state_56741 = G__56768;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2749__auto__ = function(state_56741){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____1.call(this,state_56741);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_56757 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_56757[(6)] = c__2771__auto__);

return statearr_56757;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq56709){
var G__56710 = cljs.core.first(seq56709);
var seq56709__$1 = cljs.core.next(seq56709);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56710,seq56709__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___56818 = arguments.length;
var i__5769__auto___56819 = (0);
while(true){
if((i__5769__auto___56819 < len__5768__auto___56818)){
args__5774__auto__.push((arguments[i__5769__auto___56819]));

var G__56820 = (i__5769__auto___56819 + (1));
i__5769__auto___56819 = G__56820;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_56801){
var state_val_56802 = (state_56801[(1)]);
if((state_val_56802 === (1))){
var state_56801__$1 = state_56801;
var statearr_56803_56821 = state_56801__$1;
(statearr_56803_56821[(2)] = null);

(statearr_56803_56821[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56802 === (2))){
var _ = (function (){var statearr_56804 = state_56801;
(statearr_56804[(4)] = cljs.core.cons((5),(state_56801[(4)])));

return statearr_56804;
})();
var inst_56777 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56801__$1 = state_56801;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56801__$1,(6),inst_56777);
} else {
if((state_val_56802 === (3))){
var inst_56799 = (state_56801[(2)]);
var state_56801__$1 = state_56801;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56801__$1,inst_56799);
} else {
if((state_val_56802 === (4))){
var inst_56771 = (state_56801[(2)]);
var state_56801__$1 = state_56801;
var statearr_56806_56822 = state_56801__$1;
(statearr_56806_56822[(2)] = inst_56771);

(statearr_56806_56822[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56802 === (5))){
var _ = (function (){var statearr_56807 = state_56801;
(statearr_56807[(4)] = cljs.core.rest((state_56801[(4)])));

return statearr_56807;
})();
var state_56801__$1 = state_56801;
var ex56805 = (state_56801__$1[(2)]);
var statearr_56808_56823 = state_56801__$1;
(statearr_56808_56823[(5)] = ex56805);


if((ex56805 instanceof Error)){
var statearr_56809_56824 = state_56801__$1;
(statearr_56809_56824[(1)] = (4));

(statearr_56809_56824[(5)] = null);

} else {
throw ex56805;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56802 === (6))){
var inst_56779 = (state_56801[(2)]);
var inst_56780 = fluree.db.util.async.throw_err(inst_56779);
var inst_56781 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_56780);
var inst_56782 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56783 = [inst_56780];
var inst_56784 = (new cljs.core.PersistentVector(null,1,(5),inst_56782,inst_56783,null));
var inst_56785 = cljs.core.count(inst_56784);
var inst_56786 = ((9) + inst_56785);
var inst_56787 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56788 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56790 = [inst_56780];
var inst_56791 = (new cljs.core.PersistentVector(null,1,(5),inst_56789,inst_56790,null));
var inst_56792 = ["-",inst_56791,inst_56781];
var inst_56793 = cljs.core.PersistentHashMap.fromArrays(inst_56788,inst_56792);
var inst_56794 = [inst_56793,inst_56786];
var inst_56795 = (new cljs.core.PersistentVector(null,2,(5),inst_56787,inst_56794,null));
var inst_56796 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56795);
var _ = (function (){var statearr_56810 = state_56801;
(statearr_56810[(4)] = cljs.core.rest((state_56801[(4)])));

return statearr_56810;
})();
var state_56801__$1 = (function (){var statearr_56811 = state_56801;
(statearr_56811[(7)] = inst_56796);

return statearr_56811;
})();
var statearr_56812_56825 = state_56801__$1;
(statearr_56812_56825[(2)] = inst_56781);

(statearr_56812_56825[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2749__auto____0 = (function (){
var statearr_56813 = [null,null,null,null,null,null,null,null];
(statearr_56813[(0)] = fluree$db$dbfunctions$fns$state_machine__2749__auto__);

(statearr_56813[(1)] = (1));

return statearr_56813;
});
var fluree$db$dbfunctions$fns$state_machine__2749__auto____1 = (function (state_56801){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_56801);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e56814){var ex__2752__auto__ = e56814;
var statearr_56815_56826 = state_56801;
(statearr_56815_56826[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_56801[(4)]))){
var statearr_56816_56827 = state_56801;
(statearr_56816_56827[(1)] = cljs.core.first((state_56801[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56828 = state_56801;
state_56801 = G__56828;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2749__auto__ = function(state_56801){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____1.call(this,state_56801);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_56817 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_56817[(6)] = c__2771__auto__);

return statearr_56817;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq56769){
var G__56770 = cljs.core.first(seq56769);
var seq56769__$1 = cljs.core.next(seq56769);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56770,seq56769__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___56878 = arguments.length;
var i__5769__auto___56879 = (0);
while(true){
if((i__5769__auto___56879 < len__5768__auto___56878)){
args__5774__auto__.push((arguments[i__5769__auto___56879]));

var G__56880 = (i__5769__auto___56879 + (1));
i__5769__auto___56879 = G__56880;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_56861){
var state_val_56862 = (state_56861[(1)]);
if((state_val_56862 === (1))){
var state_56861__$1 = state_56861;
var statearr_56863_56881 = state_56861__$1;
(statearr_56863_56881[(2)] = null);

(statearr_56863_56881[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56862 === (2))){
var _ = (function (){var statearr_56864 = state_56861;
(statearr_56864[(4)] = cljs.core.cons((5),(state_56861[(4)])));

return statearr_56864;
})();
var inst_56837 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56861__$1 = state_56861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56861__$1,(6),inst_56837);
} else {
if((state_val_56862 === (3))){
var inst_56859 = (state_56861[(2)]);
var state_56861__$1 = state_56861;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56861__$1,inst_56859);
} else {
if((state_val_56862 === (4))){
var inst_56831 = (state_56861[(2)]);
var state_56861__$1 = state_56861;
var statearr_56866_56882 = state_56861__$1;
(statearr_56866_56882[(2)] = inst_56831);

(statearr_56866_56882[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56862 === (5))){
var _ = (function (){var statearr_56867 = state_56861;
(statearr_56867[(4)] = cljs.core.rest((state_56861[(4)])));

return statearr_56867;
})();
var state_56861__$1 = state_56861;
var ex56865 = (state_56861__$1[(2)]);
var statearr_56868_56883 = state_56861__$1;
(statearr_56868_56883[(5)] = ex56865);


if((ex56865 instanceof Error)){
var statearr_56869_56884 = state_56861__$1;
(statearr_56869_56884[(1)] = (4));

(statearr_56869_56884[(5)] = null);

} else {
throw ex56865;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56862 === (6))){
var inst_56839 = (state_56861[(2)]);
var inst_56840 = fluree.db.util.async.throw_err(inst_56839);
var inst_56841 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_56840);
var inst_56842 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56843 = [inst_56840];
var inst_56844 = (new cljs.core.PersistentVector(null,1,(5),inst_56842,inst_56843,null));
var inst_56845 = cljs.core.count(inst_56844);
var inst_56846 = ((9) + inst_56845);
var inst_56847 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56848 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56849 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56850 = [inst_56840];
var inst_56851 = (new cljs.core.PersistentVector(null,1,(5),inst_56849,inst_56850,null));
var inst_56852 = ["*",inst_56851,inst_56841];
var inst_56853 = cljs.core.PersistentHashMap.fromArrays(inst_56848,inst_56852);
var inst_56854 = [inst_56853,inst_56846];
var inst_56855 = (new cljs.core.PersistentVector(null,2,(5),inst_56847,inst_56854,null));
var inst_56856 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56855);
var _ = (function (){var statearr_56870 = state_56861;
(statearr_56870[(4)] = cljs.core.rest((state_56861[(4)])));

return statearr_56870;
})();
var state_56861__$1 = (function (){var statearr_56871 = state_56861;
(statearr_56871[(7)] = inst_56856);

return statearr_56871;
})();
var statearr_56872_56885 = state_56861__$1;
(statearr_56872_56885[(2)] = inst_56841);

(statearr_56872_56885[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2749__auto____0 = (function (){
var statearr_56873 = [null,null,null,null,null,null,null,null];
(statearr_56873[(0)] = fluree$db$dbfunctions$fns$state_machine__2749__auto__);

(statearr_56873[(1)] = (1));

return statearr_56873;
});
var fluree$db$dbfunctions$fns$state_machine__2749__auto____1 = (function (state_56861){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_56861);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e56874){var ex__2752__auto__ = e56874;
var statearr_56875_56886 = state_56861;
(statearr_56875_56886[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_56861[(4)]))){
var statearr_56876_56887 = state_56861;
(statearr_56876_56887[(1)] = cljs.core.first((state_56861[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56888 = state_56861;
state_56861 = G__56888;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2749__auto__ = function(state_56861){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____1.call(this,state_56861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_56877 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_56877[(6)] = c__2771__auto__);

return statearr_56877;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq56829){
var G__56830 = cljs.core.first(seq56829);
var seq56829__$1 = cljs.core.next(seq56829);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56830,seq56829__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___56938 = arguments.length;
var i__5769__auto___56939 = (0);
while(true){
if((i__5769__auto___56939 < len__5768__auto___56938)){
args__5774__auto__.push((arguments[i__5769__auto___56939]));

var G__56940 = (i__5769__auto___56939 + (1));
i__5769__auto___56939 = G__56940;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_56921){
var state_val_56922 = (state_56921[(1)]);
if((state_val_56922 === (1))){
var state_56921__$1 = state_56921;
var statearr_56923_56941 = state_56921__$1;
(statearr_56923_56941[(2)] = null);

(statearr_56923_56941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56922 === (2))){
var _ = (function (){var statearr_56924 = state_56921;
(statearr_56924[(4)] = cljs.core.cons((5),(state_56921[(4)])));

return statearr_56924;
})();
var inst_56897 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56921__$1 = state_56921;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56921__$1,(6),inst_56897);
} else {
if((state_val_56922 === (3))){
var inst_56919 = (state_56921[(2)]);
var state_56921__$1 = state_56921;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56921__$1,inst_56919);
} else {
if((state_val_56922 === (4))){
var inst_56891 = (state_56921[(2)]);
var state_56921__$1 = state_56921;
var statearr_56926_56942 = state_56921__$1;
(statearr_56926_56942[(2)] = inst_56891);

(statearr_56926_56942[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56922 === (5))){
var _ = (function (){var statearr_56927 = state_56921;
(statearr_56927[(4)] = cljs.core.rest((state_56921[(4)])));

return statearr_56927;
})();
var state_56921__$1 = state_56921;
var ex56925 = (state_56921__$1[(2)]);
var statearr_56928_56943 = state_56921__$1;
(statearr_56928_56943[(5)] = ex56925);


if((ex56925 instanceof Error)){
var statearr_56929_56944 = state_56921__$1;
(statearr_56929_56944[(1)] = (4));

(statearr_56929_56944[(5)] = null);

} else {
throw ex56925;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56922 === (6))){
var inst_56899 = (state_56921[(2)]);
var inst_56900 = fluree.db.util.async.throw_err(inst_56899);
var inst_56901 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_56900);
var inst_56902 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56903 = [inst_56900];
var inst_56904 = (new cljs.core.PersistentVector(null,1,(5),inst_56902,inst_56903,null));
var inst_56905 = cljs.core.count(inst_56904);
var inst_56906 = ((9) + inst_56905);
var inst_56907 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56908 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56910 = [inst_56900];
var inst_56911 = (new cljs.core.PersistentVector(null,1,(5),inst_56909,inst_56910,null));
var inst_56912 = ["/",inst_56911,inst_56901];
var inst_56913 = cljs.core.PersistentHashMap.fromArrays(inst_56908,inst_56912);
var inst_56914 = [inst_56913,inst_56906];
var inst_56915 = (new cljs.core.PersistentVector(null,2,(5),inst_56907,inst_56914,null));
var inst_56916 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56915);
var _ = (function (){var statearr_56930 = state_56921;
(statearr_56930[(4)] = cljs.core.rest((state_56921[(4)])));

return statearr_56930;
})();
var state_56921__$1 = (function (){var statearr_56931 = state_56921;
(statearr_56931[(7)] = inst_56916);

return statearr_56931;
})();
var statearr_56932_56945 = state_56921__$1;
(statearr_56932_56945[(2)] = inst_56901);

(statearr_56932_56945[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2749__auto____0 = (function (){
var statearr_56933 = [null,null,null,null,null,null,null,null];
(statearr_56933[(0)] = fluree$db$dbfunctions$fns$state_machine__2749__auto__);

(statearr_56933[(1)] = (1));

return statearr_56933;
});
var fluree$db$dbfunctions$fns$state_machine__2749__auto____1 = (function (state_56921){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_56921);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e56934){var ex__2752__auto__ = e56934;
var statearr_56935_56946 = state_56921;
(statearr_56935_56946[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_56921[(4)]))){
var statearr_56936_56947 = state_56921;
(statearr_56936_56947[(1)] = cljs.core.first((state_56921[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56948 = state_56921;
state_56921 = G__56948;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2749__auto__ = function(state_56921){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____1.call(this,state_56921);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_56937 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_56937[(6)] = c__2771__auto__);

return statearr_56937;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq56889){
var G__56890 = cljs.core.first(seq56889);
var seq56889__$1 = cljs.core.next(seq56889);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56890,seq56889__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_56986){
var state_val_56987 = (state_56986[(1)]);
if((state_val_56987 === (7))){
var state_56986__$1 = state_56986;
var statearr_56988_57012 = state_56986__$1;
(statearr_56988_57012[(2)] = n);

(statearr_56988_57012[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56987 === (1))){
var state_56986__$1 = state_56986;
var statearr_56989_57013 = state_56986__$1;
(statearr_56989_57013[(2)] = null);

(statearr_56989_57013[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56987 === (4))){
var inst_56949 = (state_56986[(2)]);
var state_56986__$1 = state_56986;
var statearr_56990_57014 = state_56986__$1;
(statearr_56990_57014[(2)] = inst_56949);

(statearr_56990_57014[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56987 === (13))){
var inst_56966 = (state_56986[(2)]);
var inst_56967 = fluree.db.util.async.throw_err(inst_56966);
var state_56986__$1 = state_56986;
var statearr_56991_57015 = state_56986__$1;
(statearr_56991_57015[(2)] = inst_56967);

(statearr_56991_57015[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56987 === (6))){
var state_56986__$1 = state_56986;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56986__$1,(9),n);
} else {
if((state_val_56987 === (3))){
var inst_56984 = (state_56986[(2)]);
var state_56986__$1 = state_56986;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56986__$1,inst_56984);
} else {
if((state_val_56987 === (12))){
var inst_56962 = (state_56986[(7)]);
var inst_56970 = (state_56986[(2)]);
var inst_56971 = fluree.db.dbfunctions.internal.quot(inst_56962,inst_56970);
var inst_56972 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56973 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56974 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56975 = [inst_56962,inst_56970];
var inst_56976 = (new cljs.core.PersistentVector(null,2,(5),inst_56974,inst_56975,null));
var inst_56977 = ["quot",inst_56976,inst_56971];
var inst_56978 = cljs.core.PersistentHashMap.fromArrays(inst_56973,inst_56977);
var inst_56979 = [inst_56978,(2)];
var inst_56980 = (new cljs.core.PersistentVector(null,2,(5),inst_56972,inst_56979,null));
var inst_56981 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56980);
var _ = (function (){var statearr_56992 = state_56986;
(statearr_56992[(4)] = cljs.core.rest((state_56986[(4)])));

return statearr_56992;
})();
var state_56986__$1 = (function (){var statearr_56993 = state_56986;
(statearr_56993[(8)] = inst_56981);

return statearr_56993;
})();
var statearr_56994_57016 = state_56986__$1;
(statearr_56994_57016[(2)] = inst_56971);

(statearr_56994_57016[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56987 === (2))){
var _ = (function (){var statearr_56995 = state_56986;
(statearr_56995[(4)] = cljs.core.cons((5),(state_56986[(4)])));

return statearr_56995;
})();
var inst_56955 = fluree.db.util.async.channel_QMARK_(n);
var state_56986__$1 = state_56986;
if(inst_56955){
var statearr_56996_57017 = state_56986__$1;
(statearr_56996_57017[(1)] = (6));

} else {
var statearr_56997_57018 = state_56986__$1;
(statearr_56997_57018[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56987 === (11))){
var state_56986__$1 = state_56986;
var statearr_56999_57019 = state_56986__$1;
(statearr_56999_57019[(2)] = d);

(statearr_56999_57019[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56987 === (9))){
var inst_56958 = (state_56986[(2)]);
var inst_56959 = fluree.db.util.async.throw_err(inst_56958);
var state_56986__$1 = state_56986;
var statearr_57000_57020 = state_56986__$1;
(statearr_57000_57020[(2)] = inst_56959);

(statearr_57000_57020[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56987 === (5))){
var _ = (function (){var statearr_57001 = state_56986;
(statearr_57001[(4)] = cljs.core.rest((state_56986[(4)])));

return statearr_57001;
})();
var state_56986__$1 = state_56986;
var ex56998 = (state_56986__$1[(2)]);
var statearr_57002_57021 = state_56986__$1;
(statearr_57002_57021[(5)] = ex56998);


if((ex56998 instanceof Error)){
var statearr_57003_57022 = state_56986__$1;
(statearr_57003_57022[(1)] = (4));

(statearr_57003_57022[(5)] = null);

} else {
throw ex56998;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56987 === (10))){
var state_56986__$1 = state_56986;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56986__$1,(13),d);
} else {
if((state_val_56987 === (8))){
var inst_56962 = (state_56986[(2)]);
var inst_56963 = fluree.db.util.async.channel_QMARK_(d);
var state_56986__$1 = (function (){var statearr_57004 = state_56986;
(statearr_57004[(7)] = inst_56962);

return statearr_57004;
})();
if(inst_56963){
var statearr_57005_57023 = state_56986__$1;
(statearr_57005_57023[(1)] = (10));

} else {
var statearr_57006_57024 = state_56986__$1;
(statearr_57006_57024[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2749__auto____0 = (function (){
var statearr_57007 = [null,null,null,null,null,null,null,null,null];
(statearr_57007[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2749__auto__);

(statearr_57007[(1)] = (1));

return statearr_57007;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2749__auto____1 = (function (state_56986){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_56986);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e57008){var ex__2752__auto__ = e57008;
var statearr_57009_57025 = state_56986;
(statearr_57009_57025[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_56986[(4)]))){
var statearr_57010_57026 = state_56986;
(statearr_57010_57026[(1)] = cljs.core.first((state_56986[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57027 = state_56986;
state_56986 = G__57027;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2749__auto__ = function(state_56986){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2749__auto____1.call(this,state_56986);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_57011 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_57011[(6)] = c__2771__auto__);

return statearr_57011;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_57065){
var state_val_57066 = (state_57065[(1)]);
if((state_val_57066 === (7))){
var state_57065__$1 = state_57065;
var statearr_57067_57091 = state_57065__$1;
(statearr_57067_57091[(2)] = n);

(statearr_57067_57091[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57066 === (1))){
var state_57065__$1 = state_57065;
var statearr_57068_57092 = state_57065__$1;
(statearr_57068_57092[(2)] = null);

(statearr_57068_57092[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57066 === (4))){
var inst_57028 = (state_57065[(2)]);
var state_57065__$1 = state_57065;
var statearr_57069_57093 = state_57065__$1;
(statearr_57069_57093[(2)] = inst_57028);

(statearr_57069_57093[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57066 === (13))){
var inst_57045 = (state_57065[(2)]);
var inst_57046 = fluree.db.util.async.throw_err(inst_57045);
var state_57065__$1 = state_57065;
var statearr_57070_57094 = state_57065__$1;
(statearr_57070_57094[(2)] = inst_57046);

(statearr_57070_57094[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57066 === (6))){
var state_57065__$1 = state_57065;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57065__$1,(9),n);
} else {
if((state_val_57066 === (3))){
var inst_57063 = (state_57065[(2)]);
var state_57065__$1 = state_57065;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57065__$1,inst_57063);
} else {
if((state_val_57066 === (12))){
var inst_57041 = (state_57065[(7)]);
var inst_57049 = (state_57065[(2)]);
var inst_57050 = fluree.db.dbfunctions.internal.mod(inst_57041,inst_57049);
var inst_57051 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57052 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57053 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57054 = [inst_57041,inst_57049];
var inst_57055 = (new cljs.core.PersistentVector(null,2,(5),inst_57053,inst_57054,null));
var inst_57056 = ["mod",inst_57055,inst_57050];
var inst_57057 = cljs.core.PersistentHashMap.fromArrays(inst_57052,inst_57056);
var inst_57058 = [inst_57057,(2)];
var inst_57059 = (new cljs.core.PersistentVector(null,2,(5),inst_57051,inst_57058,null));
var inst_57060 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57059);
var _ = (function (){var statearr_57071 = state_57065;
(statearr_57071[(4)] = cljs.core.rest((state_57065[(4)])));

return statearr_57071;
})();
var state_57065__$1 = (function (){var statearr_57072 = state_57065;
(statearr_57072[(8)] = inst_57060);

return statearr_57072;
})();
var statearr_57073_57095 = state_57065__$1;
(statearr_57073_57095[(2)] = inst_57050);

(statearr_57073_57095[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57066 === (2))){
var _ = (function (){var statearr_57074 = state_57065;
(statearr_57074[(4)] = cljs.core.cons((5),(state_57065[(4)])));

return statearr_57074;
})();
var inst_57034 = fluree.db.util.async.channel_QMARK_(n);
var state_57065__$1 = state_57065;
if(inst_57034){
var statearr_57075_57096 = state_57065__$1;
(statearr_57075_57096[(1)] = (6));

} else {
var statearr_57076_57097 = state_57065__$1;
(statearr_57076_57097[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57066 === (11))){
var state_57065__$1 = state_57065;
var statearr_57078_57098 = state_57065__$1;
(statearr_57078_57098[(2)] = d);

(statearr_57078_57098[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57066 === (9))){
var inst_57037 = (state_57065[(2)]);
var inst_57038 = fluree.db.util.async.throw_err(inst_57037);
var state_57065__$1 = state_57065;
var statearr_57079_57099 = state_57065__$1;
(statearr_57079_57099[(2)] = inst_57038);

(statearr_57079_57099[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57066 === (5))){
var _ = (function (){var statearr_57080 = state_57065;
(statearr_57080[(4)] = cljs.core.rest((state_57065[(4)])));

return statearr_57080;
})();
var state_57065__$1 = state_57065;
var ex57077 = (state_57065__$1[(2)]);
var statearr_57081_57100 = state_57065__$1;
(statearr_57081_57100[(5)] = ex57077);


if((ex57077 instanceof Error)){
var statearr_57082_57101 = state_57065__$1;
(statearr_57082_57101[(1)] = (4));

(statearr_57082_57101[(5)] = null);

} else {
throw ex57077;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57066 === (10))){
var state_57065__$1 = state_57065;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57065__$1,(13),d);
} else {
if((state_val_57066 === (8))){
var inst_57041 = (state_57065[(2)]);
var inst_57042 = fluree.db.util.async.channel_QMARK_(d);
var state_57065__$1 = (function (){var statearr_57083 = state_57065;
(statearr_57083[(7)] = inst_57041);

return statearr_57083;
})();
if(inst_57042){
var statearr_57084_57102 = state_57065__$1;
(statearr_57084_57102[(1)] = (10));

} else {
var statearr_57085_57103 = state_57065__$1;
(statearr_57085_57103[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2749__auto____0 = (function (){
var statearr_57086 = [null,null,null,null,null,null,null,null,null];
(statearr_57086[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2749__auto__);

(statearr_57086[(1)] = (1));

return statearr_57086;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2749__auto____1 = (function (state_57065){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_57065);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e57087){var ex__2752__auto__ = e57087;
var statearr_57088_57104 = state_57065;
(statearr_57088_57104[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_57065[(4)]))){
var statearr_57089_57105 = state_57065;
(statearr_57089_57105[(1)] = cljs.core.first((state_57065[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57106 = state_57065;
state_57065 = G__57106;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2749__auto__ = function(state_57065){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2749__auto____1.call(this,state_57065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_57090 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_57090[(6)] = c__2771__auto__);

return statearr_57090;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_57144){
var state_val_57145 = (state_57144[(1)]);
if((state_val_57145 === (7))){
var state_57144__$1 = state_57144;
var statearr_57146_57170 = state_57144__$1;
(statearr_57146_57170[(2)] = n);

(statearr_57146_57170[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57145 === (1))){
var state_57144__$1 = state_57144;
var statearr_57147_57171 = state_57144__$1;
(statearr_57147_57171[(2)] = null);

(statearr_57147_57171[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57145 === (4))){
var inst_57107 = (state_57144[(2)]);
var state_57144__$1 = state_57144;
var statearr_57148_57172 = state_57144__$1;
(statearr_57148_57172[(2)] = inst_57107);

(statearr_57148_57172[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57145 === (13))){
var inst_57124 = (state_57144[(2)]);
var inst_57125 = fluree.db.util.async.throw_err(inst_57124);
var state_57144__$1 = state_57144;
var statearr_57149_57173 = state_57144__$1;
(statearr_57149_57173[(2)] = inst_57125);

(statearr_57149_57173[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57145 === (6))){
var state_57144__$1 = state_57144;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57144__$1,(9),n);
} else {
if((state_val_57145 === (3))){
var inst_57142 = (state_57144[(2)]);
var state_57144__$1 = state_57144;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57144__$1,inst_57142);
} else {
if((state_val_57145 === (12))){
var inst_57120 = (state_57144[(7)]);
var inst_57128 = (state_57144[(2)]);
var inst_57129 = fluree.db.dbfunctions.internal.rem(inst_57120,inst_57128);
var inst_57130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57131 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57132 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57133 = [inst_57120,inst_57128];
var inst_57134 = (new cljs.core.PersistentVector(null,2,(5),inst_57132,inst_57133,null));
var inst_57135 = ["rem",inst_57134,inst_57129];
var inst_57136 = cljs.core.PersistentHashMap.fromArrays(inst_57131,inst_57135);
var inst_57137 = [inst_57136,(2)];
var inst_57138 = (new cljs.core.PersistentVector(null,2,(5),inst_57130,inst_57137,null));
var inst_57139 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57138);
var _ = (function (){var statearr_57150 = state_57144;
(statearr_57150[(4)] = cljs.core.rest((state_57144[(4)])));

return statearr_57150;
})();
var state_57144__$1 = (function (){var statearr_57151 = state_57144;
(statearr_57151[(8)] = inst_57139);

return statearr_57151;
})();
var statearr_57152_57174 = state_57144__$1;
(statearr_57152_57174[(2)] = inst_57129);

(statearr_57152_57174[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57145 === (2))){
var _ = (function (){var statearr_57153 = state_57144;
(statearr_57153[(4)] = cljs.core.cons((5),(state_57144[(4)])));

return statearr_57153;
})();
var inst_57113 = fluree.db.util.async.channel_QMARK_(n);
var state_57144__$1 = state_57144;
if(inst_57113){
var statearr_57154_57175 = state_57144__$1;
(statearr_57154_57175[(1)] = (6));

} else {
var statearr_57155_57176 = state_57144__$1;
(statearr_57155_57176[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57145 === (11))){
var state_57144__$1 = state_57144;
var statearr_57157_57177 = state_57144__$1;
(statearr_57157_57177[(2)] = d);

(statearr_57157_57177[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57145 === (9))){
var inst_57116 = (state_57144[(2)]);
var inst_57117 = fluree.db.util.async.throw_err(inst_57116);
var state_57144__$1 = state_57144;
var statearr_57158_57178 = state_57144__$1;
(statearr_57158_57178[(2)] = inst_57117);

(statearr_57158_57178[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57145 === (5))){
var _ = (function (){var statearr_57159 = state_57144;
(statearr_57159[(4)] = cljs.core.rest((state_57144[(4)])));

return statearr_57159;
})();
var state_57144__$1 = state_57144;
var ex57156 = (state_57144__$1[(2)]);
var statearr_57160_57179 = state_57144__$1;
(statearr_57160_57179[(5)] = ex57156);


if((ex57156 instanceof Error)){
var statearr_57161_57180 = state_57144__$1;
(statearr_57161_57180[(1)] = (4));

(statearr_57161_57180[(5)] = null);

} else {
throw ex57156;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57145 === (10))){
var state_57144__$1 = state_57144;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57144__$1,(13),d);
} else {
if((state_val_57145 === (8))){
var inst_57120 = (state_57144[(2)]);
var inst_57121 = fluree.db.util.async.channel_QMARK_(d);
var state_57144__$1 = (function (){var statearr_57162 = state_57144;
(statearr_57162[(7)] = inst_57120);

return statearr_57162;
})();
if(inst_57121){
var statearr_57163_57181 = state_57144__$1;
(statearr_57163_57181[(1)] = (10));

} else {
var statearr_57164_57182 = state_57144__$1;
(statearr_57164_57182[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2749__auto____0 = (function (){
var statearr_57165 = [null,null,null,null,null,null,null,null,null];
(statearr_57165[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2749__auto__);

(statearr_57165[(1)] = (1));

return statearr_57165;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2749__auto____1 = (function (state_57144){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_57144);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e57166){var ex__2752__auto__ = e57166;
var statearr_57167_57183 = state_57144;
(statearr_57167_57183[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_57144[(4)]))){
var statearr_57168_57184 = state_57144;
(statearr_57168_57184[(1)] = cljs.core.first((state_57144[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57185 = state_57144;
state_57144 = G__57185;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2749__auto__ = function(state_57144){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2749__auto____1.call(this,state_57144);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_57169 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_57169[(6)] = c__2771__auto__);

return statearr_57169;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_57212){
var state_val_57213 = (state_57212[(1)]);
if((state_val_57213 === (7))){
var state_57212__$1 = state_57212;
var statearr_57214_57233 = state_57212__$1;
(statearr_57214_57233[(2)] = x);

(statearr_57214_57233[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57213 === (1))){
var state_57212__$1 = state_57212;
var statearr_57215_57234 = state_57212__$1;
(statearr_57215_57234[(2)] = null);

(statearr_57215_57234[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57213 === (4))){
var inst_57186 = (state_57212[(2)]);
var state_57212__$1 = state_57212;
var statearr_57216_57235 = state_57212__$1;
(statearr_57216_57235[(2)] = inst_57186);

(statearr_57216_57235[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57213 === (6))){
var state_57212__$1 = state_57212;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57212__$1,(9),x);
} else {
if((state_val_57213 === (3))){
var inst_57210 = (state_57212[(2)]);
var state_57212__$1 = state_57212;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57212__$1,inst_57210);
} else {
if((state_val_57213 === (2))){
var _ = (function (){var statearr_57218 = state_57212;
(statearr_57218[(4)] = cljs.core.cons((5),(state_57212[(4)])));

return statearr_57218;
})();
var inst_57192 = fluree.db.util.async.channel_QMARK_(x);
var state_57212__$1 = state_57212;
if(inst_57192){
var statearr_57219_57236 = state_57212__$1;
(statearr_57219_57236[(1)] = (6));

} else {
var statearr_57220_57237 = state_57212__$1;
(statearr_57220_57237[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57213 === (9))){
var inst_57195 = (state_57212[(2)]);
var inst_57196 = fluree.db.util.async.throw_err(inst_57195);
var state_57212__$1 = state_57212;
var statearr_57221_57238 = state_57212__$1;
(statearr_57221_57238[(2)] = inst_57196);

(statearr_57221_57238[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57213 === (5))){
var _ = (function (){var statearr_57222 = state_57212;
(statearr_57222[(4)] = cljs.core.rest((state_57212[(4)])));

return statearr_57222;
})();
var state_57212__$1 = state_57212;
var ex57217 = (state_57212__$1[(2)]);
var statearr_57223_57239 = state_57212__$1;
(statearr_57223_57239[(5)] = ex57217);


if((ex57217 instanceof Error)){
var statearr_57224_57240 = state_57212__$1;
(statearr_57224_57240[(1)] = (4));

(statearr_57224_57240[(5)] = null);

} else {
throw ex57217;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57213 === (8))){
var inst_57199 = (state_57212[(2)]);
var inst_57200 = fluree.db.dbfunctions.internal.boolean$(inst_57199);
var inst_57201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57202 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57203 = ["boolean",inst_57199,inst_57200];
var inst_57204 = cljs.core.PersistentHashMap.fromArrays(inst_57202,inst_57203);
var inst_57205 = [inst_57204,(10)];
var inst_57206 = (new cljs.core.PersistentVector(null,2,(5),inst_57201,inst_57205,null));
var inst_57207 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57206);
var _ = (function (){var statearr_57225 = state_57212;
(statearr_57225[(4)] = cljs.core.rest((state_57212[(4)])));

return statearr_57225;
})();
var state_57212__$1 = (function (){var statearr_57226 = state_57212;
(statearr_57226[(7)] = inst_57207);

return statearr_57226;
})();
var statearr_57227_57241 = state_57212__$1;
(statearr_57227_57241[(2)] = inst_57200);

(statearr_57227_57241[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2749__auto____0 = (function (){
var statearr_57228 = [null,null,null,null,null,null,null,null];
(statearr_57228[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2749__auto__);

(statearr_57228[(1)] = (1));

return statearr_57228;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2749__auto____1 = (function (state_57212){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_57212);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e57229){var ex__2752__auto__ = e57229;
var statearr_57230_57242 = state_57212;
(statearr_57230_57242[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_57212[(4)]))){
var statearr_57231_57243 = state_57212;
(statearr_57231_57243[(1)] = cljs.core.first((state_57212[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57244 = state_57212;
state_57212 = G__57244;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2749__auto__ = function(state_57212){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2749__auto____1.call(this,state_57212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_57232 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_57232[(6)] = c__2771__auto__);

return statearr_57232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_57282){
var state_val_57283 = (state_57282[(1)]);
if((state_val_57283 === (7))){
var state_57282__$1 = state_57282;
var statearr_57284_57308 = state_57282__$1;
(statearr_57284_57308[(2)] = pattern);

(statearr_57284_57308[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57283 === (1))){
var state_57282__$1 = state_57282;
var statearr_57285_57309 = state_57282__$1;
(statearr_57285_57309[(2)] = null);

(statearr_57285_57309[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57283 === (4))){
var inst_57245 = (state_57282[(2)]);
var state_57282__$1 = state_57282;
var statearr_57286_57310 = state_57282__$1;
(statearr_57286_57310[(2)] = inst_57245);

(statearr_57286_57310[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57283 === (13))){
var inst_57262 = (state_57282[(2)]);
var inst_57263 = fluree.db.util.async.throw_err(inst_57262);
var state_57282__$1 = state_57282;
var statearr_57287_57311 = state_57282__$1;
(statearr_57287_57311[(2)] = inst_57263);

(statearr_57287_57311[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57283 === (6))){
var state_57282__$1 = state_57282;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57282__$1,(9),pattern);
} else {
if((state_val_57283 === (3))){
var inst_57280 = (state_57282[(2)]);
var state_57282__$1 = state_57282;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57282__$1,inst_57280);
} else {
if((state_val_57283 === (12))){
var inst_57258 = (state_57282[(7)]);
var inst_57266 = (state_57282[(2)]);
var inst_57267 = fluree.db.dbfunctions.internal.re_find(inst_57258,inst_57266);
var inst_57268 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57269 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57270 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57271 = [inst_57258,inst_57266];
var inst_57272 = (new cljs.core.PersistentVector(null,2,(5),inst_57270,inst_57271,null));
var inst_57273 = ["re-find",inst_57272,inst_57267];
var inst_57274 = cljs.core.PersistentHashMap.fromArrays(inst_57269,inst_57273);
var inst_57275 = [inst_57274,(10)];
var inst_57276 = (new cljs.core.PersistentVector(null,2,(5),inst_57268,inst_57275,null));
var inst_57277 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57276);
var _ = (function (){var statearr_57288 = state_57282;
(statearr_57288[(4)] = cljs.core.rest((state_57282[(4)])));

return statearr_57288;
})();
var state_57282__$1 = (function (){var statearr_57289 = state_57282;
(statearr_57289[(8)] = inst_57277);

return statearr_57289;
})();
var statearr_57290_57312 = state_57282__$1;
(statearr_57290_57312[(2)] = inst_57267);

(statearr_57290_57312[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57283 === (2))){
var _ = (function (){var statearr_57291 = state_57282;
(statearr_57291[(4)] = cljs.core.cons((5),(state_57282[(4)])));

return statearr_57291;
})();
var inst_57251 = fluree.db.util.async.channel_QMARK_(pattern);
var state_57282__$1 = state_57282;
if(inst_57251){
var statearr_57292_57313 = state_57282__$1;
(statearr_57292_57313[(1)] = (6));

} else {
var statearr_57293_57314 = state_57282__$1;
(statearr_57293_57314[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57283 === (11))){
var state_57282__$1 = state_57282;
var statearr_57295_57315 = state_57282__$1;
(statearr_57295_57315[(2)] = string);

(statearr_57295_57315[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57283 === (9))){
var inst_57254 = (state_57282[(2)]);
var inst_57255 = fluree.db.util.async.throw_err(inst_57254);
var state_57282__$1 = state_57282;
var statearr_57296_57316 = state_57282__$1;
(statearr_57296_57316[(2)] = inst_57255);

(statearr_57296_57316[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57283 === (5))){
var _ = (function (){var statearr_57297 = state_57282;
(statearr_57297[(4)] = cljs.core.rest((state_57282[(4)])));

return statearr_57297;
})();
var state_57282__$1 = state_57282;
var ex57294 = (state_57282__$1[(2)]);
var statearr_57298_57317 = state_57282__$1;
(statearr_57298_57317[(5)] = ex57294);


if((ex57294 instanceof Error)){
var statearr_57299_57318 = state_57282__$1;
(statearr_57299_57318[(1)] = (4));

(statearr_57299_57318[(5)] = null);

} else {
throw ex57294;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57283 === (10))){
var state_57282__$1 = state_57282;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57282__$1,(13),string);
} else {
if((state_val_57283 === (8))){
var inst_57258 = (state_57282[(2)]);
var inst_57259 = fluree.db.util.async.channel_QMARK_(string);
var state_57282__$1 = (function (){var statearr_57300 = state_57282;
(statearr_57300[(7)] = inst_57258);

return statearr_57300;
})();
if(inst_57259){
var statearr_57301_57319 = state_57282__$1;
(statearr_57301_57319[(1)] = (10));

} else {
var statearr_57302_57320 = state_57282__$1;
(statearr_57302_57320[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2749__auto____0 = (function (){
var statearr_57303 = [null,null,null,null,null,null,null,null,null];
(statearr_57303[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2749__auto__);

(statearr_57303[(1)] = (1));

return statearr_57303;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2749__auto____1 = (function (state_57282){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_57282);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e57304){var ex__2752__auto__ = e57304;
var statearr_57305_57321 = state_57282;
(statearr_57305_57321[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_57282[(4)]))){
var statearr_57306_57322 = state_57282;
(statearr_57306_57322[(1)] = cljs.core.first((state_57282[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57323 = state_57282;
state_57282 = G__57323;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2749__auto__ = function(state_57282){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2749__auto____1.call(this,state_57282);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_57307 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_57307[(6)] = c__2771__auto__);

return statearr_57307;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_57350){
var state_val_57351 = (state_57350[(1)]);
if((state_val_57351 === (7))){
var state_57350__$1 = state_57350;
var statearr_57352_57371 = state_57350__$1;
(statearr_57352_57371[(2)] = email);

(statearr_57352_57371[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57351 === (1))){
var state_57350__$1 = state_57350;
var statearr_57353_57372 = state_57350__$1;
(statearr_57353_57372[(2)] = null);

(statearr_57353_57372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57351 === (4))){
var inst_57324 = (state_57350[(2)]);
var state_57350__$1 = state_57350;
var statearr_57354_57373 = state_57350__$1;
(statearr_57354_57373[(2)] = inst_57324);

(statearr_57354_57373[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57351 === (6))){
var state_57350__$1 = state_57350;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57350__$1,(9),email);
} else {
if((state_val_57351 === (3))){
var inst_57348 = (state_57350[(2)]);
var state_57350__$1 = state_57350;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57350__$1,inst_57348);
} else {
if((state_val_57351 === (2))){
var _ = (function (){var statearr_57356 = state_57350;
(statearr_57356[(4)] = cljs.core.cons((5),(state_57350[(4)])));

return statearr_57356;
})();
var inst_57330 = fluree.db.util.async.channel_QMARK_(email);
var state_57350__$1 = state_57350;
if(inst_57330){
var statearr_57357_57374 = state_57350__$1;
(statearr_57357_57374[(1)] = (6));

} else {
var statearr_57358_57375 = state_57350__$1;
(statearr_57358_57375[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57351 === (9))){
var inst_57333 = (state_57350[(2)]);
var inst_57334 = fluree.db.util.async.throw_err(inst_57333);
var state_57350__$1 = state_57350;
var statearr_57359_57376 = state_57350__$1;
(statearr_57359_57376[(2)] = inst_57334);

(statearr_57359_57376[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57351 === (5))){
var _ = (function (){var statearr_57360 = state_57350;
(statearr_57360[(4)] = cljs.core.rest((state_57350[(4)])));

return statearr_57360;
})();
var state_57350__$1 = state_57350;
var ex57355 = (state_57350__$1[(2)]);
var statearr_57361_57377 = state_57350__$1;
(statearr_57361_57377[(5)] = ex57355);


if((ex57355 instanceof Error)){
var statearr_57362_57378 = state_57350__$1;
(statearr_57362_57378[(1)] = (4));

(statearr_57362_57378[(5)] = null);

} else {
throw ex57355;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57351 === (8))){
var inst_57337 = (state_57350[(2)]);
var inst_57338 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_57337);
var inst_57339 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57340 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57341 = ["re-find",inst_57337,inst_57338];
var inst_57342 = cljs.core.PersistentHashMap.fromArrays(inst_57340,inst_57341);
var inst_57343 = [inst_57342,(10)];
var inst_57344 = (new cljs.core.PersistentVector(null,2,(5),inst_57339,inst_57343,null));
var inst_57345 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57344);
var _ = (function (){var statearr_57363 = state_57350;
(statearr_57363[(4)] = cljs.core.rest((state_57350[(4)])));

return statearr_57363;
})();
var state_57350__$1 = (function (){var statearr_57364 = state_57350;
(statearr_57364[(7)] = inst_57345);

return statearr_57364;
})();
var statearr_57365_57379 = state_57350__$1;
(statearr_57365_57379[(2)] = inst_57338);

(statearr_57365_57379[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2749__auto____0 = (function (){
var statearr_57366 = [null,null,null,null,null,null,null,null];
(statearr_57366[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2749__auto__);

(statearr_57366[(1)] = (1));

return statearr_57366;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2749__auto____1 = (function (state_57350){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_57350);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e57367){var ex__2752__auto__ = e57367;
var statearr_57368_57380 = state_57350;
(statearr_57368_57380[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_57350[(4)]))){
var statearr_57369_57381 = state_57350;
(statearr_57369_57381[(1)] = cljs.core.first((state_57350[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57382 = state_57350;
state_57350 = G__57382;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2749__auto__ = function(state_57350){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2749__auto____1.call(this,state_57350);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_57370 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_57370[(6)] = c__2771__auto__);

return statearr_57370;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_57429){
var state_val_57430 = (state_57429[(1)]);
if((state_val_57430 === (7))){
var inst_57399 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57429__$1 = state_57429;
if(cljs.core.truth_(inst_57399)){
var statearr_57431_57458 = state_57429__$1;
(statearr_57431_57458[(1)] = (9));

} else {
var statearr_57432_57459 = state_57429__$1;
(statearr_57432_57459[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57430 === (1))){
var state_57429__$1 = state_57429;
var statearr_57433_57460 = state_57429__$1;
(statearr_57433_57460[(2)] = null);

(statearr_57433_57460[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57430 === (4))){
var inst_57383 = (state_57429[(2)]);
var state_57429__$1 = state_57429;
var statearr_57434_57461 = state_57429__$1;
(statearr_57434_57461[(2)] = inst_57383);

(statearr_57434_57461[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57430 === (15))){
var inst_57410 = (state_57429[(2)]);
var state_57429__$1 = state_57429;
var statearr_57435_57462 = state_57429__$1;
(statearr_57435_57462[(2)] = inst_57410);

(statearr_57435_57462[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57430 === (13))){
var inst_57407 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_57429__$1 = state_57429;
var statearr_57436_57463 = state_57429__$1;
(statearr_57436_57463[(2)] = inst_57407);

(statearr_57436_57463[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57430 === (6))){
var inst_57394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57395 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_57396 = [inst_57395,(0)];
var inst_57397 = (new cljs.core.PersistentVector(null,2,(5),inst_57394,inst_57396,null));
var state_57429__$1 = state_57429;
var statearr_57437_57464 = state_57429__$1;
(statearr_57437_57464[(2)] = inst_57397);

(statearr_57437_57464[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57430 === (3))){
var inst_57427 = (state_57429[(2)]);
var state_57429__$1 = state_57429;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57429__$1,inst_57427);
} else {
if((state_val_57430 === (12))){
var inst_57403 = (state_57429[(2)]);
var inst_57404 = fluree.db.util.async.throw_err(inst_57403);
var state_57429__$1 = state_57429;
var statearr_57438_57465 = state_57429__$1;
(statearr_57438_57465[(2)] = inst_57404);

(statearr_57438_57465[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57430 === (2))){
var _ = (function (){var statearr_57439 = state_57429;
(statearr_57439[(4)] = cljs.core.cons((5),(state_57429[(4)])));

return statearr_57439;
})();
var inst_57392 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57429__$1 = state_57429;
if(cljs.core.truth_(inst_57392)){
var statearr_57440_57466 = state_57429__$1;
(statearr_57440_57466[(1)] = (6));

} else {
var statearr_57441_57467 = state_57429__$1;
(statearr_57441_57467[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57430 === (11))){
var inst_57412 = (state_57429[(2)]);
var state_57429__$1 = state_57429;
var statearr_57443_57468 = state_57429__$1;
(statearr_57443_57468[(2)] = inst_57412);

(statearr_57443_57468[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57430 === (9))){
var inst_57401 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_57429__$1 = state_57429;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57429__$1,(12),inst_57401);
} else {
if((state_val_57430 === (5))){
var _ = (function (){var statearr_57444 = state_57429;
(statearr_57444[(4)] = cljs.core.rest((state_57429[(4)])));

return statearr_57444;
})();
var state_57429__$1 = state_57429;
var ex57442 = (state_57429__$1[(2)]);
var statearr_57445_57469 = state_57429__$1;
(statearr_57445_57469[(5)] = ex57442);


if((ex57442 instanceof Error)){
var statearr_57446_57470 = state_57429__$1;
(statearr_57446_57470[(1)] = (4));

(statearr_57446_57470[(5)] = null);

} else {
throw ex57442;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57430 === (14))){
var state_57429__$1 = state_57429;
var statearr_57447_57471 = state_57429__$1;
(statearr_57447_57471[(2)] = null);

(statearr_57447_57471[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57430 === (10))){
var state_57429__$1 = state_57429;
var statearr_57448_57472 = state_57429__$1;
(statearr_57448_57472[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57430 === (8))){
var inst_57414 = (state_57429[(2)]);
var inst_57415 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57414,(0),null);
var inst_57416 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57414,(1),null);
var inst_57417 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57418 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57419 = ["?user_id","?ctx",inst_57415];
var inst_57420 = cljs.core.PersistentHashMap.fromArrays(inst_57418,inst_57419);
var inst_57421 = ((10) + inst_57416);
var inst_57422 = [inst_57420,inst_57421];
var inst_57423 = (new cljs.core.PersistentVector(null,2,(5),inst_57417,inst_57422,null));
var inst_57424 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57423);
var _ = (function (){var statearr_57450 = state_57429;
(statearr_57450[(4)] = cljs.core.rest((state_57429[(4)])));

return statearr_57450;
})();
var state_57429__$1 = (function (){var statearr_57451 = state_57429;
(statearr_57451[(7)] = inst_57424);

return statearr_57451;
})();
var statearr_57452_57473 = state_57429__$1;
(statearr_57452_57473[(2)] = inst_57415);

(statearr_57452_57473[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2749__auto____0 = (function (){
var statearr_57453 = [null,null,null,null,null,null,null,null];
(statearr_57453[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2749__auto__);

(statearr_57453[(1)] = (1));

return statearr_57453;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2749__auto____1 = (function (state_57429){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_57429);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e57454){var ex__2752__auto__ = e57454;
var statearr_57455_57474 = state_57429;
(statearr_57455_57474[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_57429[(4)]))){
var statearr_57456_57475 = state_57429;
(statearr_57456_57475[(1)] = cljs.core.first((state_57429[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57476 = state_57429;
state_57429 = G__57476;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2749__auto__ = function(state_57429){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2749__auto____1.call(this,state_57429);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_57457 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_57457[(6)] = c__2771__auto__);

return statearr_57457;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_57504){
var state_val_57505 = (state_57504[(1)]);
if((state_val_57505 === (7))){
var inst_57497 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_57504__$1 = state_57504;
var statearr_57506_57525 = state_57504__$1;
(statearr_57506_57525[(2)] = inst_57497);

(statearr_57506_57525[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57505 === (1))){
var state_57504__$1 = state_57504;
var statearr_57507_57526 = state_57504__$1;
(statearr_57507_57526[(2)] = null);

(statearr_57507_57526[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57505 === (4))){
var inst_57477 = (state_57504[(2)]);
var state_57504__$1 = state_57504;
var statearr_57508_57527 = state_57504__$1;
(statearr_57508_57527[(2)] = inst_57477);

(statearr_57508_57527[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57505 === (6))){
var inst_57485 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_57504__$1 = state_57504;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57504__$1,(9),inst_57485);
} else {
if((state_val_57505 === (3))){
var inst_57502 = (state_57504[(2)]);
var state_57504__$1 = state_57504;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57504__$1,inst_57502);
} else {
if((state_val_57505 === (2))){
var _ = (function (){var statearr_57510 = state_57504;
(statearr_57510[(4)] = cljs.core.cons((5),(state_57504[(4)])));

return statearr_57510;
})();
var inst_57483 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57504__$1 = state_57504;
if(cljs.core.truth_(inst_57483)){
var statearr_57511_57528 = state_57504__$1;
(statearr_57511_57528[(1)] = (6));

} else {
var statearr_57512_57529 = state_57504__$1;
(statearr_57512_57529[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57505 === (9))){
var inst_57487 = (state_57504[(2)]);
var inst_57488 = fluree.db.util.async.throw_err(inst_57487);
var inst_57489 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57490 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57491 = ["?auth_id","?ctx",inst_57488];
var inst_57492 = cljs.core.PersistentHashMap.fromArrays(inst_57490,inst_57491);
var inst_57493 = [inst_57492,(10)];
var inst_57494 = (new cljs.core.PersistentVector(null,2,(5),inst_57489,inst_57493,null));
var inst_57495 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57494);
var state_57504__$1 = (function (){var statearr_57513 = state_57504;
(statearr_57513[(7)] = inst_57495);

return statearr_57513;
})();
var statearr_57514_57530 = state_57504__$1;
(statearr_57514_57530[(2)] = inst_57488);

(statearr_57514_57530[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57505 === (5))){
var _ = (function (){var statearr_57515 = state_57504;
(statearr_57515[(4)] = cljs.core.rest((state_57504[(4)])));

return statearr_57515;
})();
var state_57504__$1 = state_57504;
var ex57509 = (state_57504__$1[(2)]);
var statearr_57516_57531 = state_57504__$1;
(statearr_57516_57531[(5)] = ex57509);


if((ex57509 instanceof Error)){
var statearr_57517_57532 = state_57504__$1;
(statearr_57517_57532[(1)] = (4));

(statearr_57517_57532[(5)] = null);

} else {
throw ex57509;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57505 === (8))){
var inst_57499 = (state_57504[(2)]);
var _ = (function (){var statearr_57518 = state_57504;
(statearr_57518[(4)] = cljs.core.rest((state_57504[(4)])));

return statearr_57518;
})();
var state_57504__$1 = state_57504;
var statearr_57519_57533 = state_57504__$1;
(statearr_57519_57533[(2)] = inst_57499);

(statearr_57519_57533[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2749__auto____0 = (function (){
var statearr_57520 = [null,null,null,null,null,null,null,null];
(statearr_57520[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2749__auto__);

(statearr_57520[(1)] = (1));

return statearr_57520;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2749__auto____1 = (function (state_57504){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_57504);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e57521){var ex__2752__auto__ = e57521;
var statearr_57522_57534 = state_57504;
(statearr_57522_57534[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_57504[(4)]))){
var statearr_57523_57535 = state_57504;
(statearr_57523_57535[(1)] = cljs.core.first((state_57504[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57536 = state_57504;
state_57504 = G__57536;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2749__auto__ = function(state_57504){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2749__auto____1.call(this,state_57504);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_57524 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_57524[(6)] = c__2771__auto__);

return statearr_57524;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__57538 = arguments.length;
switch (G__57538) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_57580){
var state_val_57581 = (state_57580[(1)]);
if((state_val_57581 === (7))){
var state_57580__$1 = state_57580;
var statearr_57582_57612 = state_57580__$1;
(statearr_57582_57612[(2)] = seed);

(statearr_57582_57612[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57581 === (1))){
var state_57580__$1 = state_57580;
var statearr_57583_57613 = state_57580__$1;
(statearr_57583_57613[(2)] = null);

(statearr_57583_57613[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57581 === (4))){
var inst_57539 = (state_57580[(2)]);
var state_57580__$1 = state_57580;
var statearr_57584_57614 = state_57580__$1;
(statearr_57584_57614[(2)] = inst_57539);

(statearr_57584_57614[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57581 === (15))){
var state_57580__$1 = state_57580;
var statearr_57585_57615 = state_57580__$1;
(statearr_57585_57615[(2)] = (10));

(statearr_57585_57615[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57581 === (13))){
var inst_57556 = (state_57580[(2)]);
var inst_57557 = fluree.db.util.async.throw_err(inst_57556);
var state_57580__$1 = state_57580;
var statearr_57586_57616 = state_57580__$1;
(statearr_57586_57616[(2)] = inst_57557);

(statearr_57586_57616[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57581 === (6))){
var state_57580__$1 = state_57580;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57580__$1,(9),seed);
} else {
if((state_val_57581 === (3))){
var inst_57578 = (state_57580[(2)]);
var state_57580__$1 = state_57580;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57580__$1,inst_57578);
} else {
if((state_val_57581 === (12))){
var inst_57560 = (state_57580[(7)]);
var inst_57560__$1 = (state_57580[(2)]);
var state_57580__$1 = (function (){var statearr_57587 = state_57580;
(statearr_57587[(7)] = inst_57560__$1);

return statearr_57587;
})();
if(cljs.core.truth_(inst_57560__$1)){
var statearr_57588_57617 = state_57580__$1;
(statearr_57588_57617[(1)] = (14));

} else {
var statearr_57589_57618 = state_57580__$1;
(statearr_57589_57618[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57581 === (2))){
var _ = (function (){var statearr_57590 = state_57580;
(statearr_57590[(4)] = cljs.core.cons((5),(state_57580[(4)])));

return statearr_57590;
})();
var inst_57545 = fluree.db.util.async.channel_QMARK_(seed);
var state_57580__$1 = state_57580;
if(inst_57545){
var statearr_57591_57619 = state_57580__$1;
(statearr_57591_57619[(1)] = (6));

} else {
var statearr_57592_57620 = state_57580__$1;
(statearr_57592_57620[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57581 === (11))){
var state_57580__$1 = state_57580;
var statearr_57594_57621 = state_57580__$1;
(statearr_57594_57621[(2)] = max);

(statearr_57594_57621[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57581 === (9))){
var inst_57548 = (state_57580[(2)]);
var inst_57549 = fluree.db.util.async.throw_err(inst_57548);
var state_57580__$1 = state_57580;
var statearr_57595_57622 = state_57580__$1;
(statearr_57595_57622[(2)] = inst_57549);

(statearr_57595_57622[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57581 === (5))){
var _ = (function (){var statearr_57596 = state_57580;
(statearr_57596[(4)] = cljs.core.rest((state_57580[(4)])));

return statearr_57596;
})();
var state_57580__$1 = state_57580;
var ex57593 = (state_57580__$1[(2)]);
var statearr_57597_57623 = state_57580__$1;
(statearr_57597_57623[(5)] = ex57593);


if((ex57593 instanceof Error)){
var statearr_57598_57624 = state_57580__$1;
(statearr_57598_57624[(1)] = (4));

(statearr_57598_57624[(5)] = null);

} else {
throw ex57593;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57581 === (14))){
var inst_57560 = (state_57580[(7)]);
var state_57580__$1 = state_57580;
var statearr_57599_57625 = state_57580__$1;
(statearr_57599_57625[(2)] = inst_57560);

(statearr_57599_57625[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57581 === (16))){
var inst_57552 = (state_57580[(8)]);
var inst_57564 = (state_57580[(2)]);
var inst_57565 = fluree.db.dbfunctions.internal.rand(inst_57552,inst_57564);
var inst_57566 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57567 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57568 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57569 = [max,seed];
var inst_57570 = (new cljs.core.PersistentVector(null,2,(5),inst_57568,inst_57569,null));
var inst_57571 = ["rand",inst_57570,inst_57565];
var inst_57572 = cljs.core.PersistentHashMap.fromArrays(inst_57567,inst_57571);
var inst_57573 = [inst_57572,(10)];
var inst_57574 = (new cljs.core.PersistentVector(null,2,(5),inst_57566,inst_57573,null));
var inst_57575 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57574);
var _ = (function (){var statearr_57600 = state_57580;
(statearr_57600[(4)] = cljs.core.rest((state_57580[(4)])));

return statearr_57600;
})();
var state_57580__$1 = (function (){var statearr_57601 = state_57580;
(statearr_57601[(9)] = inst_57575);

return statearr_57601;
})();
var statearr_57602_57626 = state_57580__$1;
(statearr_57602_57626[(2)] = inst_57565);

(statearr_57602_57626[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57581 === (10))){
var state_57580__$1 = state_57580;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57580__$1,(13),max);
} else {
if((state_val_57581 === (8))){
var inst_57552 = (state_57580[(2)]);
var inst_57553 = fluree.db.util.async.channel_QMARK_(max);
var state_57580__$1 = (function (){var statearr_57603 = state_57580;
(statearr_57603[(8)] = inst_57552);

return statearr_57603;
})();
if(inst_57553){
var statearr_57604_57627 = state_57580__$1;
(statearr_57604_57627[(1)] = (10));

} else {
var statearr_57605_57628 = state_57580__$1;
(statearr_57605_57628[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2749__auto____0 = (function (){
var statearr_57606 = [null,null,null,null,null,null,null,null,null,null];
(statearr_57606[(0)] = fluree$db$dbfunctions$fns$state_machine__2749__auto__);

(statearr_57606[(1)] = (1));

return statearr_57606;
});
var fluree$db$dbfunctions$fns$state_machine__2749__auto____1 = (function (state_57580){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_57580);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e57607){var ex__2752__auto__ = e57607;
var statearr_57608_57629 = state_57580;
(statearr_57608_57629[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_57580[(4)]))){
var statearr_57609_57630 = state_57580;
(statearr_57609_57630[(1)] = cljs.core.first((state_57580[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57631 = state_57580;
state_57580 = G__57631;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2749__auto__ = function(state_57580){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2749__auto____1.call(this,state_57580);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_57610 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_57610[(6)] = c__2771__auto__);

return statearr_57610;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_57652){
var state_val_57653 = (state_57652[(1)]);
if((state_val_57653 === (1))){
var state_57652__$1 = state_57652;
var statearr_57654_57669 = state_57652__$1;
(statearr_57654_57669[(2)] = null);

(statearr_57654_57669[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (2))){
var _ = (function (){var statearr_57655 = state_57652;
(statearr_57655[(4)] = cljs.core.cons((5),(state_57652[(4)])));

return statearr_57655;
})();
var inst_57638 = fluree.db.util.core.random_uuid();
var inst_57639 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_57638);
var inst_57640 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57641 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57642 = cljs.core.PersistentVector.EMPTY;
var inst_57643 = ["uuid",inst_57642,inst_57639];
var inst_57644 = cljs.core.PersistentHashMap.fromArrays(inst_57641,inst_57643);
var inst_57645 = [inst_57644,(10)];
var inst_57646 = (new cljs.core.PersistentVector(null,2,(5),inst_57640,inst_57645,null));
var inst_57647 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57646);
var ___$1 = (function (){var statearr_57656 = state_57652;
(statearr_57656[(4)] = cljs.core.rest((state_57652[(4)])));

return statearr_57656;
})();
var state_57652__$1 = (function (){var statearr_57657 = state_57652;
(statearr_57657[(7)] = inst_57647);

return statearr_57657;
})();
var statearr_57658_57670 = state_57652__$1;
(statearr_57658_57670[(2)] = inst_57639);

(statearr_57658_57670[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (3))){
var inst_57650 = (state_57652[(2)]);
var state_57652__$1 = state_57652;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57652__$1,inst_57650);
} else {
if((state_val_57653 === (4))){
var inst_57632 = (state_57652[(2)]);
var state_57652__$1 = state_57652;
var statearr_57660_57671 = state_57652__$1;
(statearr_57660_57671[(2)] = inst_57632);

(statearr_57660_57671[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (5))){
var _ = (function (){var statearr_57661 = state_57652;
(statearr_57661[(4)] = cljs.core.rest((state_57652[(4)])));

return statearr_57661;
})();
var state_57652__$1 = state_57652;
var ex57659 = (state_57652__$1[(2)]);
var statearr_57662_57672 = state_57652__$1;
(statearr_57662_57672[(5)] = ex57659);


if((ex57659 instanceof Error)){
var statearr_57663_57673 = state_57652__$1;
(statearr_57663_57673[(1)] = (4));

(statearr_57663_57673[(5)] = null);

} else {
throw ex57659;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2749__auto____0 = (function (){
var statearr_57664 = [null,null,null,null,null,null,null,null];
(statearr_57664[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2749__auto__);

(statearr_57664[(1)] = (1));

return statearr_57664;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2749__auto____1 = (function (state_57652){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_57652);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e57665){var ex__2752__auto__ = e57665;
var statearr_57666_57674 = state_57652;
(statearr_57666_57674[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_57652[(4)]))){
var statearr_57667_57675 = state_57652;
(statearr_57667_57675[(1)] = cljs.core.first((state_57652[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57676 = state_57652;
state_57652 = G__57676;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2749__auto__ = function(state_57652){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2749__auto____1.call(this,state_57652);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_57668 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_57668[(6)] = c__2771__auto__);

return statearr_57668;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_57706){
var state_val_57707 = (state_57706[(1)]);
if((state_val_57707 === (7))){
var state_57706__$1 = state_57706;
var statearr_57708_57727 = state_57706__$1;
(statearr_57708_57727[(2)] = num);

(statearr_57708_57727[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57707 === (1))){
var state_57706__$1 = state_57706;
var statearr_57709_57728 = state_57706__$1;
(statearr_57709_57728[(2)] = null);

(statearr_57709_57728[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57707 === (4))){
var inst_57677 = (state_57706[(2)]);
var state_57706__$1 = state_57706;
var statearr_57710_57729 = state_57706__$1;
(statearr_57710_57729[(2)] = inst_57677);

(statearr_57710_57729[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57707 === (6))){
var state_57706__$1 = state_57706;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57706__$1,(9),num);
} else {
if((state_val_57707 === (3))){
var inst_57704 = (state_57706[(2)]);
var state_57706__$1 = state_57706;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57706__$1,inst_57704);
} else {
if((state_val_57707 === (2))){
var _ = (function (){var statearr_57712 = state_57706;
(statearr_57712[(4)] = cljs.core.cons((5),(state_57706[(4)])));

return statearr_57712;
})();
var inst_57683 = fluree.db.util.async.channel_QMARK_(num);
var state_57706__$1 = state_57706;
if(inst_57683){
var statearr_57713_57730 = state_57706__$1;
(statearr_57713_57730[(1)] = (6));

} else {
var statearr_57714_57731 = state_57706__$1;
(statearr_57714_57731[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57707 === (9))){
var inst_57686 = (state_57706[(2)]);
var inst_57687 = fluree.db.util.async.throw_err(inst_57686);
var state_57706__$1 = state_57706;
var statearr_57715_57732 = state_57706__$1;
(statearr_57715_57732[(2)] = inst_57687);

(statearr_57715_57732[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57707 === (5))){
var _ = (function (){var statearr_57716 = state_57706;
(statearr_57716[(4)] = cljs.core.rest((state_57706[(4)])));

return statearr_57716;
})();
var state_57706__$1 = state_57706;
var ex57711 = (state_57706__$1[(2)]);
var statearr_57717_57733 = state_57706__$1;
(statearr_57717_57733[(5)] = ex57711);


if((ex57711 instanceof Error)){
var statearr_57718_57734 = state_57706__$1;
(statearr_57718_57734[(1)] = (4));

(statearr_57718_57734[(5)] = null);

} else {
throw ex57711;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57707 === (8))){
var inst_57690 = (state_57706[(2)]);
var inst_57691 = fluree.db.dbfunctions.internal.ceil(inst_57690);
var inst_57692 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57693 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57694 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57695 = [fluree.db.dbfunctions.fns.ceil];
var inst_57696 = (new cljs.core.PersistentVector(null,1,(5),inst_57694,inst_57695,null));
var inst_57697 = ["",inst_57696,inst_57691];
var inst_57698 = cljs.core.PersistentHashMap.fromArrays(inst_57693,inst_57697);
var inst_57699 = [inst_57698,(10)];
var inst_57700 = (new cljs.core.PersistentVector(null,2,(5),inst_57692,inst_57699,null));
var inst_57701 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57700);
var _ = (function (){var statearr_57719 = state_57706;
(statearr_57719[(4)] = cljs.core.rest((state_57706[(4)])));

return statearr_57719;
})();
var state_57706__$1 = (function (){var statearr_57720 = state_57706;
(statearr_57720[(7)] = inst_57701);

return statearr_57720;
})();
var statearr_57721_57735 = state_57706__$1;
(statearr_57721_57735[(2)] = inst_57691);

(statearr_57721_57735[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2749__auto____0 = (function (){
var statearr_57722 = [null,null,null,null,null,null,null,null];
(statearr_57722[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2749__auto__);

(statearr_57722[(1)] = (1));

return statearr_57722;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2749__auto____1 = (function (state_57706){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_57706);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e57723){var ex__2752__auto__ = e57723;
var statearr_57724_57736 = state_57706;
(statearr_57724_57736[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_57706[(4)]))){
var statearr_57725_57737 = state_57706;
(statearr_57725_57737[(1)] = cljs.core.first((state_57706[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57738 = state_57706;
state_57706 = G__57738;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2749__auto__ = function(state_57706){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2749__auto____1.call(this,state_57706);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_57726 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_57726[(6)] = c__2771__auto__);

return statearr_57726;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_57768){
var state_val_57769 = (state_57768[(1)]);
if((state_val_57769 === (7))){
var state_57768__$1 = state_57768;
var statearr_57770_57789 = state_57768__$1;
(statearr_57770_57789[(2)] = num);

(statearr_57770_57789[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57769 === (1))){
var state_57768__$1 = state_57768;
var statearr_57771_57790 = state_57768__$1;
(statearr_57771_57790[(2)] = null);

(statearr_57771_57790[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57769 === (4))){
var inst_57739 = (state_57768[(2)]);
var state_57768__$1 = state_57768;
var statearr_57772_57791 = state_57768__$1;
(statearr_57772_57791[(2)] = inst_57739);

(statearr_57772_57791[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57769 === (6))){
var state_57768__$1 = state_57768;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57768__$1,(9),num);
} else {
if((state_val_57769 === (3))){
var inst_57766 = (state_57768[(2)]);
var state_57768__$1 = state_57768;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57768__$1,inst_57766);
} else {
if((state_val_57769 === (2))){
var _ = (function (){var statearr_57774 = state_57768;
(statearr_57774[(4)] = cljs.core.cons((5),(state_57768[(4)])));

return statearr_57774;
})();
var inst_57745 = fluree.db.util.async.channel_QMARK_(num);
var state_57768__$1 = state_57768;
if(inst_57745){
var statearr_57775_57792 = state_57768__$1;
(statearr_57775_57792[(1)] = (6));

} else {
var statearr_57776_57793 = state_57768__$1;
(statearr_57776_57793[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57769 === (9))){
var inst_57748 = (state_57768[(2)]);
var inst_57749 = fluree.db.util.async.throw_err(inst_57748);
var state_57768__$1 = state_57768;
var statearr_57777_57794 = state_57768__$1;
(statearr_57777_57794[(2)] = inst_57749);

(statearr_57777_57794[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57769 === (5))){
var _ = (function (){var statearr_57778 = state_57768;
(statearr_57778[(4)] = cljs.core.rest((state_57768[(4)])));

return statearr_57778;
})();
var state_57768__$1 = state_57768;
var ex57773 = (state_57768__$1[(2)]);
var statearr_57779_57795 = state_57768__$1;
(statearr_57779_57795[(5)] = ex57773);


if((ex57773 instanceof Error)){
var statearr_57780_57796 = state_57768__$1;
(statearr_57780_57796[(1)] = (4));

(statearr_57780_57796[(5)] = null);

} else {
throw ex57773;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57769 === (8))){
var inst_57752 = (state_57768[(2)]);
var inst_57753 = fluree.db.dbfunctions.internal.floor(inst_57752);
var inst_57754 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57755 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57756 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57757 = [fluree.db.dbfunctions.fns.floor];
var inst_57758 = (new cljs.core.PersistentVector(null,1,(5),inst_57756,inst_57757,null));
var inst_57759 = ["",inst_57758,inst_57753];
var inst_57760 = cljs.core.PersistentHashMap.fromArrays(inst_57755,inst_57759);
var inst_57761 = [inst_57760,(10)];
var inst_57762 = (new cljs.core.PersistentVector(null,2,(5),inst_57754,inst_57761,null));
var inst_57763 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57762);
var _ = (function (){var statearr_57781 = state_57768;
(statearr_57781[(4)] = cljs.core.rest((state_57768[(4)])));

return statearr_57781;
})();
var state_57768__$1 = (function (){var statearr_57782 = state_57768;
(statearr_57782[(7)] = inst_57763);

return statearr_57782;
})();
var statearr_57783_57797 = state_57768__$1;
(statearr_57783_57797[(2)] = inst_57753);

(statearr_57783_57797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2749__auto____0 = (function (){
var statearr_57784 = [null,null,null,null,null,null,null,null];
(statearr_57784[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2749__auto__);

(statearr_57784[(1)] = (1));

return statearr_57784;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2749__auto____1 = (function (state_57768){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_57768);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e57785){var ex__2752__auto__ = e57785;
var statearr_57786_57798 = state_57768;
(statearr_57786_57798[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_57768[(4)]))){
var statearr_57787_57799 = state_57768;
(statearr_57787_57799[(1)] = cljs.core.first((state_57768[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57800 = state_57768;
state_57768 = G__57800;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2749__auto__ = function(state_57768){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2749__auto____1.call(this,state_57768);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_57788 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_57788[(6)] = c__2771__auto__);

return statearr_57788;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_57825){
var state_val_57826 = (state_57825[(1)]);
if((state_val_57826 === (1))){
var state_57825__$1 = state_57825;
var statearr_57827_57842 = state_57825__$1;
(statearr_57827_57842[(2)] = null);

(statearr_57827_57842[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57826 === (2))){
var _ = (function (){var statearr_57828 = state_57825;
(statearr_57828[(4)] = cljs.core.cons((5),(state_57825[(4)])));

return statearr_57828;
})();
var inst_57807 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_57825__$1 = state_57825;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57825__$1,(6),inst_57807);
} else {
if((state_val_57826 === (3))){
var inst_57823 = (state_57825[(2)]);
var state_57825__$1 = state_57825;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57825__$1,inst_57823);
} else {
if((state_val_57826 === (4))){
var inst_57801 = (state_57825[(2)]);
var state_57825__$1 = state_57825;
var statearr_57830_57843 = state_57825__$1;
(statearr_57830_57843[(2)] = inst_57801);

(statearr_57830_57843[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57826 === (5))){
var _ = (function (){var statearr_57831 = state_57825;
(statearr_57831[(4)] = cljs.core.rest((state_57825[(4)])));

return statearr_57831;
})();
var state_57825__$1 = state_57825;
var ex57829 = (state_57825__$1[(2)]);
var statearr_57832_57844 = state_57825__$1;
(statearr_57832_57844[(5)] = ex57829);


if((ex57829 instanceof Error)){
var statearr_57833_57845 = state_57825__$1;
(statearr_57833_57845[(1)] = (4));

(statearr_57833_57845[(5)] = null);

} else {
throw ex57829;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57826 === (6))){
var inst_57809 = (state_57825[(2)]);
var inst_57810 = fluree.db.util.async.throw_err(inst_57809);
var inst_57811 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57812 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57813 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57814 = [compare_val,new_val];
var inst_57815 = (new cljs.core.PersistentVector(null,2,(5),inst_57813,inst_57814,null));
var inst_57816 = ["",inst_57815,inst_57810];
var inst_57817 = cljs.core.PersistentHashMap.fromArrays(inst_57812,inst_57816);
var inst_57818 = [inst_57817,(10)];
var inst_57819 = (new cljs.core.PersistentVector(null,2,(5),inst_57811,inst_57818,null));
var inst_57820 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57819);
var _ = (function (){var statearr_57834 = state_57825;
(statearr_57834[(4)] = cljs.core.rest((state_57825[(4)])));

return statearr_57834;
})();
var state_57825__$1 = (function (){var statearr_57835 = state_57825;
(statearr_57835[(7)] = inst_57820);

return statearr_57835;
})();
var statearr_57836_57846 = state_57825__$1;
(statearr_57836_57846[(2)] = inst_57810);

(statearr_57836_57846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2749__auto____0 = (function (){
var statearr_57837 = [null,null,null,null,null,null,null,null];
(statearr_57837[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2749__auto__);

(statearr_57837[(1)] = (1));

return statearr_57837;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2749__auto____1 = (function (state_57825){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_57825);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e57838){var ex__2752__auto__ = e57838;
var statearr_57839_57847 = state_57825;
(statearr_57839_57847[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_57825[(4)]))){
var statearr_57840_57848 = state_57825;
(statearr_57840_57848[(1)] = cljs.core.first((state_57825[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57849 = state_57825;
state_57825 = G__57849;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2749__auto__ = function(state_57825){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2749__auto____1.call(this,state_57825);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_57841 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_57841[(6)] = c__2771__auto__);

return statearr_57841;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
