// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__5774__auto__ = [];
var len__5768__auto___29681 = arguments.length;
var i__5769__auto___29682 = (0);
while(true){
if((i__5769__auto___29682 < len__5768__auto___29681)){
args__5774__auto__.push((arguments[i__5769__auto___29682]));

var G__29683 = (i__5769__auto___29682 + (1));
i__5769__auto___29682 = G__29683;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((2) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq29678){
var G__29679 = cljs.core.first(seq29678);
var seq29678__$1 = cljs.core.next(seq29678);
var G__29680 = cljs.core.first(seq29678__$1);
var seq29678__$2 = cljs.core.next(seq29678__$1);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29679,G__29680,seq29678__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e29684){var e = e29684;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e29685){var e = e29685;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e29686){var e = e29686;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e29687){var e = e29687;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e29688){var e = e29688;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__5774__auto__ = [];
var len__5768__auto___29691 = arguments.length;
var i__5769__auto___29692 = (0);
while(true){
if((i__5769__auto___29692 < len__5768__auto___29691)){
args__5774__auto__.push((arguments[i__5769__auto___29692]));

var G__29693 = (i__5769__auto___29692 + (1));
i__5769__auto___29692 = G__29693;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e29690){var e = e29690;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq29689){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29689));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__5774__auto__ = [];
var len__5768__auto___29696 = arguments.length;
var i__5769__auto___29697 = (0);
while(true){
if((i__5769__auto___29697 < len__5768__auto___29696)){
args__5774__auto__.push((arguments[i__5769__auto___29697]));

var G__29698 = (i__5769__auto___29697 + (1));
i__5769__auto___29697 = G__29698;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e29695){var e = e29695;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq29694){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29694));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e29699){var e = e29699;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__5774__auto__ = [];
var len__5768__auto___29702 = arguments.length;
var i__5769__auto___29703 = (0);
while(true){
if((i__5769__auto___29703 < len__5768__auto___29702)){
args__5774__auto__.push((arguments[i__5769__auto___29703]));

var G__29704 = (i__5769__auto___29703 + (1));
i__5769__auto___29703 = G__29704;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e29701){var e = e29701;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq29700){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29700));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__5774__auto__ = [];
var len__5768__auto___29707 = arguments.length;
var i__5769__auto___29708 = (0);
while(true){
if((i__5769__auto___29708 < len__5768__auto___29707)){
args__5774__auto__.push((arguments[i__5769__auto___29708]));

var G__29709 = (i__5769__auto___29708 + (1));
i__5769__auto___29708 = G__29709;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e29706){var e = e29706;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq29705){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29705));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e29710){var e = e29710;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e29711){var e = e29711;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__5774__auto__ = [];
var len__5768__auto___29714 = arguments.length;
var i__5769__auto___29715 = (0);
while(true){
if((i__5769__auto___29715 < len__5768__auto___29714)){
args__5774__auto__.push((arguments[i__5769__auto___29715]));

var G__29716 = (i__5769__auto___29715 + (1));
i__5769__auto___29715 = G__29716;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e29713){var e = e29713;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq29712){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29712));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__5774__auto__ = [];
var len__5768__auto___29719 = arguments.length;
var i__5769__auto___29720 = (0);
while(true){
if((i__5769__auto___29720 < len__5768__auto___29719)){
args__5774__auto__.push((arguments[i__5769__auto___29720]));

var G__29721 = (i__5769__auto___29720 + (1));
i__5769__auto___29720 = G__29721;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e29718){var e = e29718;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq29717){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29717));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___29724 = arguments.length;
var i__5769__auto___29725 = (0);
while(true){
if((i__5769__auto___29725 < len__5768__auto___29724)){
args__5774__auto__.push((arguments[i__5769__auto___29725]));

var G__29726 = (i__5769__auto___29725 + (1));
i__5769__auto___29725 = G__29726;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e29723){var e = e29723;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq29722){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29722));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___29729 = arguments.length;
var i__5769__auto___29730 = (0);
while(true){
if((i__5769__auto___29730 < len__5768__auto___29729)){
args__5774__auto__.push((arguments[i__5769__auto___29730]));

var G__29731 = (i__5769__auto___29730 + (1));
i__5769__auto___29730 = G__29731;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e29728){var e = e29728;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq29727){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29727));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___29734 = arguments.length;
var i__5769__auto___29735 = (0);
while(true){
if((i__5769__auto___29735 < len__5768__auto___29734)){
args__5774__auto__.push((arguments[i__5769__auto___29735]));

var G__29736 = (i__5769__auto___29735 + (1));
i__5769__auto___29735 = G__29736;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e29733){var e = e29733;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq29732){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29732));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___29739 = arguments.length;
var i__5769__auto___29740 = (0);
while(true){
if((i__5769__auto___29740 < len__5768__auto___29739)){
args__5774__auto__.push((arguments[i__5769__auto___29740]));

var G__29741 = (i__5769__auto___29740 + (1));
i__5769__auto___29740 = G__29741;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e29738){var e = e29738;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq29737){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29737));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___29744 = arguments.length;
var i__5769__auto___29745 = (0);
while(true){
if((i__5769__auto___29745 < len__5768__auto___29744)){
args__5774__auto__.push((arguments[i__5769__auto___29745]));

var G__29746 = (i__5769__auto___29745 + (1));
i__5769__auto___29745 = G__29746;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e29743){var e = e29743;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq29742){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29742));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__29748 = arguments.length;
switch (G__29748) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_29776){
var state_val_29777 = (state_29776[(1)]);
if((state_val_29777 === (7))){
var inst_29761 = (state_29776[(7)]);
var inst_29764 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29761,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_29776__$1 = state_29776;
var statearr_29778_29864 = state_29776__$1;
(statearr_29778_29864[(2)] = inst_29764);

(statearr_29778_29864[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29777 === (1))){
var state_29776__$1 = state_29776;
var statearr_29779_29865 = state_29776__$1;
(statearr_29779_29865[(2)] = null);

(statearr_29779_29865[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29777 === (4))){
var inst_29749 = (state_29776[(2)]);
var state_29776__$1 = state_29776;
var statearr_29780_29866 = state_29776__$1;
(statearr_29780_29866[(2)] = inst_29749);

(statearr_29780_29866[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29777 === (6))){
var inst_29761 = (state_29776[(7)]);
var inst_29761__$1 = (state_29776[(2)]);
var inst_29762 = fluree.db.util.core.exception_QMARK_(inst_29761__$1);
var state_29776__$1 = (function (){var statearr_29781 = state_29776;
(statearr_29781[(7)] = inst_29761__$1);

return statearr_29781;
})();
if(inst_29762){
var statearr_29782_29867 = state_29776__$1;
(statearr_29782_29867[(1)] = (7));

} else {
var statearr_29783_29868 = state_29776__$1;
(statearr_29783_29868[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29777 === (3))){
var inst_29774 = (state_29776[(2)]);
var state_29776__$1 = state_29776;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29776__$1,inst_29774);
} else {
if((state_val_29777 === (2))){
var inst_29755 = (state_29776[(8)]);
var _ = (function (){var statearr_29785 = state_29776;
(statearr_29785[(4)] = cljs.core.cons((5),(state_29776[(4)])));

return statearr_29785;
})();
var inst_29755__$1 = cljs.core.volatile_BANG_((0));
var inst_29756 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_29757 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_29756,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_29755__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000)], 0));
var inst_29758 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_29757);
var inst_29759 = fluree.db.query.fql.query(db,inst_29758);
var state_29776__$1 = (function (){var statearr_29786 = state_29776;
(statearr_29786[(8)] = inst_29755__$1);

return statearr_29786;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29776__$1,(6),inst_29759);
} else {
if((state_val_29777 === (9))){
var inst_29771 = (state_29776[(2)]);
var _ = (function (){var statearr_29787 = state_29776;
(statearr_29787[(4)] = cljs.core.rest((state_29776[(4)])));

return statearr_29787;
})();
var state_29776__$1 = state_29776;
var statearr_29788_29869 = state_29776__$1;
(statearr_29788_29869[(2)] = inst_29771);

(statearr_29788_29869[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29777 === (5))){
var _ = (function (){var statearr_29789 = state_29776;
(statearr_29789[(4)] = cljs.core.rest((state_29776[(4)])));

return statearr_29789;
})();
var state_29776__$1 = state_29776;
var ex29784 = (state_29776__$1[(2)]);
var statearr_29790_29870 = state_29776__$1;
(statearr_29790_29870[(5)] = ex29784);


if((ex29784 instanceof Error)){
var statearr_29791_29871 = state_29776__$1;
(statearr_29791_29871[(1)] = (4));

(statearr_29791_29871[(5)] = null);

} else {
throw ex29784;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29777 === (8))){
var inst_29755 = (state_29776[(8)]);
var inst_29761 = (state_29776[(7)]);
var inst_29766 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29767 = cljs.core.deref(inst_29755);
var inst_29768 = [inst_29761,inst_29767];
var inst_29769 = (new cljs.core.PersistentVector(null,2,(5),inst_29766,inst_29768,null));
var state_29776__$1 = state_29776;
var statearr_29792_29872 = state_29776__$1;
(statearr_29792_29872[(2)] = inst_29769);

(statearr_29792_29872[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2749__auto____0 = (function (){
var statearr_29793 = [null,null,null,null,null,null,null,null,null];
(statearr_29793[(0)] = fluree$db$dbfunctions$internal$state_machine__2749__auto__);

(statearr_29793[(1)] = (1));

return statearr_29793;
});
var fluree$db$dbfunctions$internal$state_machine__2749__auto____1 = (function (state_29776){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_29776);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e29794){var ex__2752__auto__ = e29794;
var statearr_29795_29873 = state_29776;
(statearr_29795_29873[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_29776[(4)]))){
var statearr_29796_29874 = state_29776;
(statearr_29796_29874[(1)] = cljs.core.first((state_29776[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29875 = state_29776;
state_29776 = G__29875;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2749__auto__ = function(state_29776){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2749__auto____1.call(this,state_29776);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2749__auto____0;
fluree$db$dbfunctions$internal$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2749__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_29797 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_29797[(6)] = c__2771__auto__);

return statearr_29797;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_29842){
var state_val_29843 = (state_29842[(1)]);
if((state_val_29843 === (7))){
var inst_29828 = (state_29842[(2)]);
var inst_29829 = fluree.db.query.fql.query(db,inst_29828);
var state_29842__$1 = state_29842;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29842__$1,(8),inst_29829);
} else {
if((state_val_29843 === (1))){
var inst_29798 = typeof select === 'string';
var state_29842__$1 = state_29842;
if(cljs.core.truth_(inst_29798)){
var statearr_29844_29876 = state_29842__$1;
(statearr_29844_29876[(1)] = (2));

} else {
var statearr_29845_29877 = state_29842__$1;
(statearr_29845_29877[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29843 === (4))){
var inst_29804 = (state_29842[(7)]);
var inst_29811 = (state_29842[(8)]);
var inst_29803 = (state_29842[(2)]);
var inst_29804__$1 = cljs.core.volatile_BANG_((0));
var inst_29805 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29806 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_29807 = [inst_29804__$1,(100000)];
var inst_29808 = cljs.core.PersistentHashMap.fromArrays(inst_29806,inst_29807);
var inst_29809 = [inst_29803,from,where,block,limit,inst_29808];
var inst_29810 = cljs.core.PersistentHashMap.fromArrays(inst_29805,inst_29809);
var inst_29811__$1 = fluree.db.util.core.without_nils(inst_29810);
var inst_29812 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_29811__$1);
var inst_29813 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_29811__$1);
var inst_29814 = cljs.core.first(inst_29813);
var inst_29815 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29814], 0));
var inst_29816 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_29815);
var inst_29817 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_29811__$1);
var inst_29818 = cljs.core.last(inst_29817);
var inst_29819 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29818], 0));
var inst_29820 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_29819);
var inst_29821 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29812,inst_29816,inst_29820], 0));
var state_29842__$1 = (function (){var statearr_29846 = state_29842;
(statearr_29846[(7)] = inst_29804__$1);

(statearr_29846[(8)] = inst_29811__$1);

return statearr_29846;
})();
if(cljs.core.truth_(inst_29821)){
var statearr_29847_29878 = state_29842__$1;
(statearr_29847_29878[(1)] = (5));

} else {
var statearr_29848_29879 = state_29842__$1;
(statearr_29848_29879[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29843 === (6))){
var inst_29811 = (state_29842[(8)]);
var state_29842__$1 = state_29842;
var statearr_29849_29880 = state_29842__$1;
(statearr_29849_29880[(2)] = inst_29811);

(statearr_29849_29880[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29843 === (3))){
var state_29842__$1 = state_29842;
var statearr_29850_29881 = state_29842__$1;
(statearr_29850_29881[(2)] = select);

(statearr_29850_29881[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29843 === (2))){
var inst_29800 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_29842__$1 = state_29842;
var statearr_29851_29882 = state_29842__$1;
(statearr_29851_29882[(2)] = inst_29800);

(statearr_29851_29882[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29843 === (11))){
var inst_29840 = (state_29842[(2)]);
var state_29842__$1 = state_29842;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29842__$1,inst_29840);
} else {
if((state_val_29843 === (9))){
var inst_29831 = (state_29842[(9)]);
var state_29842__$1 = state_29842;
var statearr_29852_29883 = state_29842__$1;
(statearr_29852_29883[(2)] = inst_29831);

(statearr_29852_29883[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29843 === (5))){
var inst_29811 = (state_29842[(8)]);
var inst_29823 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_29811);
var inst_29824 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_29823);
var inst_29825 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_29811,new cljs.core.Keyword(null,"where","where",-2044795965),inst_29824);
var state_29842__$1 = state_29842;
var statearr_29853_29884 = state_29842__$1;
(statearr_29853_29884[(2)] = inst_29825);

(statearr_29853_29884[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29843 === (10))){
var inst_29831 = (state_29842[(9)]);
var inst_29804 = (state_29842[(7)]);
var inst_29835 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29836 = cljs.core.deref(inst_29804);
var inst_29837 = [inst_29831,inst_29836];
var inst_29838 = (new cljs.core.PersistentVector(null,2,(5),inst_29835,inst_29837,null));
var state_29842__$1 = state_29842;
var statearr_29854_29885 = state_29842__$1;
(statearr_29854_29885[(2)] = inst_29838);

(statearr_29854_29885[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29843 === (8))){
var inst_29831 = (state_29842[(9)]);
var inst_29831__$1 = (state_29842[(2)]);
var inst_29832 = fluree.db.util.core.exception_QMARK_(inst_29831__$1);
var state_29842__$1 = (function (){var statearr_29855 = state_29842;
(statearr_29855[(9)] = inst_29831__$1);

return statearr_29855;
})();
if(inst_29832){
var statearr_29856_29886 = state_29842__$1;
(statearr_29856_29886[(1)] = (9));

} else {
var statearr_29857_29887 = state_29842__$1;
(statearr_29857_29887[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2749__auto____0 = (function (){
var statearr_29858 = [null,null,null,null,null,null,null,null,null,null];
(statearr_29858[(0)] = fluree$db$dbfunctions$internal$state_machine__2749__auto__);

(statearr_29858[(1)] = (1));

return statearr_29858;
});
var fluree$db$dbfunctions$internal$state_machine__2749__auto____1 = (function (state_29842){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_29842);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e29859){var ex__2752__auto__ = e29859;
var statearr_29860_29888 = state_29842;
(statearr_29860_29888[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_29842[(4)]))){
var statearr_29861_29889 = state_29842;
(statearr_29861_29889[(1)] = cljs.core.first((state_29842[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29890 = state_29842;
state_29842 = G__29890;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2749__auto__ = function(state_29842){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2749__auto____1.call(this,state_29842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2749__auto____0;
fluree$db$dbfunctions$internal$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2749__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_29862 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_29862[(6)] = c__2771__auto__);

return statearr_29862;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__29894 = path;
var vec__29895 = G__29894;
var seq__29896 = cljs.core.seq(vec__29895);
var first__29897 = cljs.core.first(seq__29896);
var seq__29896__$1 = cljs.core.next(seq__29896);
var var$ = first__29897;
var r = seq__29896__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__29894__$1 = G__29894;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__29901 = G__29894__$1;
var seq__29902 = cljs.core.seq(vec__29901);
var first__29903 = cljs.core.first(seq__29902);
var seq__29902__$1 = cljs.core.next(seq__29902);
var var$__$1 = first__29903;
var r__$1 = seq__29902__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__29904 = r__$1;
var G__29905 = n__$2;
var G__29906 = next_clauses;
G__29894__$1 = G__29904;
n__$1 = G__29905;
where_clauses__$1 = G__29906;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__29907 = r__$1;
var G__29908 = next_n;
var G__29909 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__29894__$1 = G__29907;
n__$1 = G__29908;
where_clauses__$1 = G__29909;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_29946){
var state_val_29947 = (state_29946[(1)]);
if((state_val_29947 === (7))){
var inst_29919 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29920 = [path];
var inst_29921 = (new cljs.core.PersistentVector(null,1,(5),inst_29919,inst_29920,null));
var state_29946__$1 = state_29946;
var statearr_29948_29976 = state_29946__$1;
(statearr_29948_29976[(2)] = inst_29921);

(statearr_29948_29976[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29947 === (1))){
var state_29946__$1 = state_29946;
var statearr_29949_29977 = state_29946__$1;
(statearr_29949_29977[(2)] = null);

(statearr_29949_29977[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29947 === (4))){
var inst_29910 = (state_29946[(2)]);
var state_29946__$1 = state_29946;
var statearr_29950_29978 = state_29946__$1;
(statearr_29950_29978[(2)] = inst_29910);

(statearr_29950_29978[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29947 === (13))){
var inst_29937 = (state_29946[(2)]);
var inst_29938 = fluree.db.util.async.throw_err(inst_29937);
var _ = (function (){var statearr_29951 = state_29946;
(statearr_29951[(4)] = cljs.core.rest((state_29946[(4)])));

return statearr_29951;
})();
var state_29946__$1 = state_29946;
var statearr_29952_29979 = state_29946__$1;
(statearr_29952_29979[(2)] = inst_29938);

(statearr_29952_29979[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29947 === (6))){
var state_29946__$1 = state_29946;
var statearr_29954_29980 = state_29946__$1;
(statearr_29954_29980[(2)] = path);

(statearr_29954_29980[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29947 === (3))){
var inst_29944 = (state_29946[(2)]);
var state_29946__$1 = state_29946;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29946__$1,inst_29944);
} else {
if((state_val_29947 === (12))){
var _ = (function (){var statearr_29955 = state_29946;
(statearr_29955[(4)] = cljs.core.rest((state_29946[(4)])));

return statearr_29955;
})();
var state_29946__$1 = state_29946;
var ex29953 = (state_29946__$1[(2)]);
var statearr_29956_29981 = state_29946__$1;
(statearr_29956_29981[(5)] = ex29953);


var statearr_29957_29982 = state_29946__$1;
(statearr_29957_29982[(1)] = (11));

(statearr_29957_29982[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29947 === (2))){
var _ = (function (){var statearr_29958 = state_29946;
(statearr_29958[(4)] = cljs.core.cons((5),(state_29946[(4)])));

return statearr_29958;
})();
var inst_29916 = cljs.core.vector_QMARK_(path);
var state_29946__$1 = state_29946;
if(inst_29916){
var statearr_29959_29983 = state_29946__$1;
(statearr_29959_29983[(1)] = (6));

} else {
var statearr_29960_29984 = state_29946__$1;
(statearr_29960_29984[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29947 === (11))){
var inst_29923 = (state_29946[(7)]);
var inst_29928 = (state_29946[(2)]);
var inst_29929 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29928,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_29923,endSubject], 0));
var state_29946__$1 = state_29946;
var statearr_29962_29985 = state_29946__$1;
(statearr_29962_29985[(2)] = inst_29929);

(statearr_29962_29985[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29947 === (9))){
var inst_29927 = (state_29946[(8)]);
var _ = (function (){var statearr_29963 = state_29946;
(statearr_29963[(4)] = cljs.core.cons((12),(state_29946[(4)])));

return statearr_29963;
})();
var inst_29935 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_29927);
var state_29946__$1 = state_29946;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29946__$1,(13),inst_29935);
} else {
if((state_val_29947 === (5))){
var _ = (function (){var statearr_29964 = state_29946;
(statearr_29964[(4)] = cljs.core.rest((state_29946[(4)])));

return statearr_29964;
})();
var state_29946__$1 = state_29946;
var ex29961 = (state_29946__$1[(2)]);
var statearr_29965_29986 = state_29946__$1;
(statearr_29965_29986[(5)] = ex29961);


if((ex29961 instanceof Error)){
var statearr_29966_29987 = state_29946__$1;
(statearr_29966_29987[(1)] = (4));

(statearr_29966_29987[(5)] = null);

} else {
throw ex29961;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29947 === (10))){
var inst_29941 = (state_29946[(2)]);
var _ = (function (){var statearr_29967 = state_29946;
(statearr_29967[(4)] = cljs.core.rest((state_29946[(4)])));

return statearr_29967;
})();
var state_29946__$1 = state_29946;
var statearr_29968_29988 = state_29946__$1;
(statearr_29968_29988[(2)] = inst_29941);

(statearr_29968_29988[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29947 === (8))){
var inst_29923 = (state_29946[(7)]);
var inst_29923__$1 = (state_29946[(2)]);
var inst_29924 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_29923__$1,endSubject);
var inst_29925 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_29926 = ["?var1",inst_29924];
var inst_29927 = cljs.core.PersistentHashMap.fromArrays(inst_29925,inst_29926);
var state_29946__$1 = (function (){var statearr_29969 = state_29946;
(statearr_29969[(8)] = inst_29927);

(statearr_29969[(7)] = inst_29923__$1);

return statearr_29969;
})();
var statearr_29970_29989 = state_29946__$1;
(statearr_29970_29989[(2)] = null);

(statearr_29970_29989[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2749__auto____0 = (function (){
var statearr_29971 = [null,null,null,null,null,null,null,null,null];
(statearr_29971[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2749__auto__);

(statearr_29971[(1)] = (1));

return statearr_29971;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2749__auto____1 = (function (state_29946){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_29946);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e29972){var ex__2752__auto__ = e29972;
var statearr_29973_29990 = state_29946;
(statearr_29973_29990[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_29946[(4)]))){
var statearr_29974_29991 = state_29946;
(statearr_29974_29991[(1)] = cljs.core.first((state_29946[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29992 = state_29946;
state_29946 = G__29992;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2749__auto__ = function(state_29946){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2749__auto____1.call(this,state_29946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2749__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_29975 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_29975[(6)] = c__2771__auto__);

return statearr_29975;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e29993){var e = e29993;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e29994){var e = e29994;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e29995){var e = e29995;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e29996){var e = e29996;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___29999 = arguments.length;
var i__5769__auto___30000 = (0);
while(true){
if((i__5769__auto___30000 < len__5768__auto___29999)){
args__5774__auto__.push((arguments[i__5769__auto___30000]));

var G__30001 = (i__5769__auto___30000 + (1));
i__5769__auto___30000 = G__30001;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e29998){var e = e29998;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq29997){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29997));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___30004 = arguments.length;
var i__5769__auto___30005 = (0);
while(true){
if((i__5769__auto___30005 < len__5768__auto___30004)){
args__5774__auto__.push((arguments[i__5769__auto___30005]));

var G__30006 = (i__5769__auto___30005 + (1));
i__5769__auto___30005 = G__30006;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e30003){var e = e30003;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq30002){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq30002));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___30009 = arguments.length;
var i__5769__auto___30010 = (0);
while(true){
if((i__5769__auto___30010 < len__5768__auto___30009)){
args__5774__auto__.push((arguments[i__5769__auto___30010]));

var G__30011 = (i__5769__auto___30010 + (1));
i__5769__auto___30010 = G__30011;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__5045__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e30008){var e = e30008;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq30007){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq30007));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___30014 = arguments.length;
var i__5769__auto___30015 = (0);
while(true){
if((i__5769__auto___30015 < len__5768__auto___30014)){
args__5774__auto__.push((arguments[i__5769__auto___30015]));

var G__30016 = (i__5769__auto___30015 + (1));
i__5769__auto___30015 = G__30016;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e30013){var e = e30013;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq30012){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq30012));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e30017){var e = e30017;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e30018){var e = e30018;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e30019){var e = e30019;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e30020){var e = e30020;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e30021){var e = e30021;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__30027 = path;
var vec__30028 = G__30027;
var seq__30029 = cljs.core.seq(vec__30028);
var first__30030 = cljs.core.first(seq__30029);
var seq__30029__$1 = cljs.core.next(seq__30029);
var pred = first__30030;
var r = seq__30029__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__30027__$1 = G__30027;
var subjects__$1 = subjects;
while(true){
var vec__30034 = G__30027__$1;
var seq__30035 = cljs.core.seq(vec__30034);
var first__30036 = cljs.core.first(seq__30035);
var seq__30035__$1 = cljs.core.next(seq__30035);
var pred__$1 = first__30036;
var r__$1 = seq__30035__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__30027__$1,subjects__$1,vec__30034,seq__30035,first__30036,seq__30035__$1,pred__$1,r__$1,subjects__$2,G__30027,vec__30028,seq__30029,first__30030,seq__30029__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__30027__$1,subjects__$1,vec__30034,seq__30035,first__30036,seq__30035__$1,pred__$1,r__$1,subjects__$2,G__30027,vec__30028,seq__30029,first__30030,seq__30029__$1,pred,r,subjects){
return (function (p1__30022_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__30022_SHARP_,pred__$1);
});})(G__30027__$1,subjects__$1,vec__30034,seq__30035,first__30036,seq__30035__$1,pred__$1,r__$1,subjects__$2,G__30027,vec__30028,seq__30029,first__30030,seq__30029__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__30027__$1,subjects__$1,vec__30034,seq__30035,first__30036,seq__30035__$1,pred__$1,r__$1,subjects__$2,G__30027,vec__30028,seq__30029,first__30030,seq__30029__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__5043__auto__ = r__$1;
if(and__5043__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__5043__auto__;
}
})())){
var G__30037 = r__$1;
var G__30038 = next_subjects;
G__30027__$1 = G__30037;
subjects__$1 = G__30038;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e30023){var e = e30023;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e30039){var e = e30039;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e30040){var e = e30040;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__5774__auto__ = [];
var len__5768__auto___30043 = arguments.length;
var i__5769__auto___30044 = (0);
while(true){
if((i__5769__auto___30044 < len__5768__auto___30043)){
args__5774__auto__.push((arguments[i__5769__auto___30044]));

var G__30045 = (i__5769__auto___30044 + (1));
i__5769__auto___30044 = G__30045;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e30042){var e = e30042;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq30041){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq30041));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e30046){var e = e30046;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___30049 = arguments.length;
var i__5769__auto___30050 = (0);
while(true){
if((i__5769__auto___30050 < len__5768__auto___30049)){
args__5774__auto__.push((arguments[i__5769__auto___30050]));

var G__30051 = (i__5769__auto___30050 + (1));
i__5769__auto___30050 = G__30051;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e30048){var e = e30048;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq30047){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq30047));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e30052){var e = e30052;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_30109){
var state_val_30110 = (state_30109[(1)]);
if((state_val_30110 === (7))){
var inst_30055 = (state_30109[(2)]);
var state_30109__$1 = state_30109;
var statearr_30111_30145 = state_30109__$1;
(statearr_30111_30145[(2)] = inst_30055);

(statearr_30111_30145[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30110 === (1))){
var state_30109__$1 = state_30109;
var statearr_30112_30146 = state_30109__$1;
(statearr_30112_30146[(2)] = null);

(statearr_30112_30146[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30110 === (4))){
var inst_30054 = (state_30109[(2)]);
var state_30109__$1 = (function (){var statearr_30113 = state_30109;
(statearr_30113[(7)] = inst_30054);

return statearr_30113;
})();
var statearr_30114_30147 = state_30109__$1;
(statearr_30114_30147[(2)] = null);

(statearr_30114_30147[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30110 === (15))){
var inst_30090 = (state_30109[(8)]);
var inst_30089 = (state_30109[(9)]);
var inst_30092 = (state_30109[(10)]);
var inst_30080 = (state_30109[(11)]);
var inst_30077 = (state_30109[(12)]);
var inst_30079 = (state_30109[(13)]);
var inst_30096 = (function (){var db = inst_30077;
var prevT = inst_30079;
var db_SINGLEQUOTE_ = inst_30080;
var prev_vals = inst_30089;
var fuel = inst_30090;
var G__30091 = inst_30092;
return (function (p1__30053_SHARP_){
var f = p1__30053_SHARP_;
return f.o;
});
})();
var inst_30097 = (inst_30096.cljs$core$IFn$_invoke$arity$1 ? inst_30096.cljs$core$IFn$_invoke$arity$1(inst_30092) : inst_30096.call(null,inst_30092));
var state_30109__$1 = state_30109;
var statearr_30115_30148 = state_30109__$1;
(statearr_30115_30148[(2)] = inst_30097);

(statearr_30115_30148[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30110 === (13))){
var inst_30089 = (state_30109[(9)]);
var inst_30092 = (state_30109[(10)]);
var inst_30088 = (state_30109[(2)]);
var inst_30089__$1 = fluree.db.util.async.throw_err(inst_30088);
var inst_30090 = fluree.db.dbfunctions.internal.count(inst_30089__$1);
var inst_30092__$1 = cljs.core.first(inst_30089__$1);
var inst_30093 = (inst_30092__$1 == null);
var state_30109__$1 = (function (){var statearr_30116 = state_30109;
(statearr_30116[(8)] = inst_30090);

(statearr_30116[(9)] = inst_30089__$1);

(statearr_30116[(10)] = inst_30092__$1);

return statearr_30116;
})();
if(cljs.core.truth_(inst_30093)){
var statearr_30117_30149 = state_30109__$1;
(statearr_30117_30149[(1)] = (14));

} else {
var statearr_30118_30150 = state_30109__$1;
(statearr_30118_30150[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30110 === (6))){
var inst_30064 = (state_30109[(2)]);
var state_30109__$1 = state_30109;
var statearr_30119_30151 = state_30109__$1;
(statearr_30119_30151[(2)] = inst_30064);

(statearr_30119_30151[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30110 === (3))){
var inst_30107 = (state_30109[(2)]);
var state_30109__$1 = state_30109;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30109__$1,inst_30107);
} else {
if((state_val_30110 === (12))){
var inst_30104 = (state_30109[(2)]);
var _ = (function (){var statearr_30120 = state_30109;
(statearr_30120[(4)] = cljs.core.rest((state_30109[(4)])));

return statearr_30120;
})();
var state_30109__$1 = state_30109;
var statearr_30121_30152 = state_30109__$1;
(statearr_30121_30152[(2)] = inst_30104);

(statearr_30121_30152[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30110 === (2))){
var _ = (function (){var statearr_30123 = state_30109;
(statearr_30123[(4)] = cljs.core.cons((9),(state_30109[(4)])));

return statearr_30123;
})();
var inst_30070 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30071 = typeof inst_30070 === 'string';
var state_30109__$1 = state_30109;
if(cljs.core.truth_(inst_30071)){
var statearr_30124_30153 = state_30109__$1;
(statearr_30124_30153[(1)] = (10));

} else {
var statearr_30125_30154 = state_30109__$1;
(statearr_30125_30154[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30110 === (11))){
var inst_30080 = (state_30109[(11)]);
var inst_30077 = (state_30109[(12)]);
var inst_30079 = (state_30109[(13)]);
var inst_30077__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30078 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_30077__$1);
var inst_30079__$1 = fluree.db.dbfunctions.internal.inc(inst_30078);
var inst_30080__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_30077__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_30079__$1);
var inst_30081 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30082 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30083 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30084 = [inst_30082,inst_30083];
var inst_30085 = (new cljs.core.PersistentVector(null,2,(5),inst_30081,inst_30084,null));
var inst_30086 = fluree.db.dbproto._search(inst_30080__$1,inst_30085);
var state_30109__$1 = (function (){var statearr_30126 = state_30109;
(statearr_30126[(11)] = inst_30080__$1);

(statearr_30126[(12)] = inst_30077__$1);

(statearr_30126[(13)] = inst_30079__$1);

return statearr_30126;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30109__$1,(13),inst_30086);
} else {
if((state_val_30110 === (9))){
var _ = (function (){var statearr_30127 = state_30109;
(statearr_30127[(4)] = cljs.core.rest((state_30109[(4)])));

return statearr_30127;
})();
var state_30109__$1 = state_30109;
var ex30122 = (state_30109__$1[(2)]);
var statearr_30128_30155 = state_30109__$1;
(statearr_30128_30155[(5)] = ex30122);


var statearr_30129_30156 = state_30109__$1;
(statearr_30129_30156[(1)] = (4));

(statearr_30129_30156[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30110 === (5))){
var inst_30054 = (state_30109[(7)]);
var _ = (function (){var statearr_30130 = state_30109;
(statearr_30130[(4)] = cljs.core.cons((8),(state_30109[(4)])));

return statearr_30130;
})();
var inst_30061 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_30054,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_30131 = state_30109;
(statearr_30131[(4)] = cljs.core.rest((state_30109[(4)])));

return statearr_30131;
})();
var state_30109__$1 = state_30109;
var statearr_30132_30157 = state_30109__$1;
(statearr_30132_30157[(2)] = inst_30061);

(statearr_30132_30157[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30110 === (14))){
var state_30109__$1 = state_30109;
var statearr_30133_30158 = state_30109__$1;
(statearr_30133_30158[(2)] = null);

(statearr_30133_30158[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30110 === (16))){
var inst_30090 = (state_30109[(8)]);
var inst_30099 = (state_30109[(2)]);
var inst_30100 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30101 = [inst_30099,inst_30090];
var inst_30102 = (new cljs.core.PersistentVector(null,2,(5),inst_30100,inst_30101,null));
var state_30109__$1 = state_30109;
var statearr_30135_30159 = state_30109__$1;
(statearr_30135_30159[(2)] = inst_30102);

(statearr_30135_30159[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30110 === (10))){
var inst_30073 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30074 = [null,(0)];
var inst_30075 = (new cljs.core.PersistentVector(null,2,(5),inst_30073,inst_30074,null));
var state_30109__$1 = state_30109;
var statearr_30136_30160 = state_30109__$1;
(statearr_30136_30160[(2)] = inst_30075);

(statearr_30136_30160[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30110 === (8))){
var _ = (function (){var statearr_30137 = state_30109;
(statearr_30137[(4)] = cljs.core.rest((state_30109[(4)])));

return statearr_30137;
})();
var state_30109__$1 = state_30109;
var ex30134 = (state_30109__$1[(2)]);
var statearr_30138_30161 = state_30109__$1;
(statearr_30138_30161[(5)] = ex30134);


var statearr_30139_30162 = state_30109__$1;
(statearr_30139_30162[(1)] = (7));

(statearr_30139_30162[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2749__auto____0 = (function (){
var statearr_30140 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30140[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2749__auto__);

(statearr_30140[(1)] = (1));

return statearr_30140;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2749__auto____1 = (function (state_30109){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_30109);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e30141){var ex__2752__auto__ = e30141;
var statearr_30142_30163 = state_30109;
(statearr_30142_30163[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_30109[(4)]))){
var statearr_30143_30164 = state_30109;
(statearr_30143_30164[(1)] = cljs.core.first((state_30109[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30165 = state_30109;
state_30109 = G__30165;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2749__auto__ = function(state_30109){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2749__auto____1.call(this,state_30109);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_30144 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_30144[(6)] = c__2771__auto__);

return statearr_30144;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_30217){
var state_val_30218 = (state_30217[(1)]);
if((state_val_30218 === (7))){
var inst_30167 = (state_30217[(2)]);
var state_30217__$1 = state_30217;
var statearr_30219_30248 = state_30217__$1;
(statearr_30219_30248[(2)] = inst_30167);

(statearr_30219_30248[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30218 === (1))){
var state_30217__$1 = state_30217;
var statearr_30220_30249 = state_30217__$1;
(statearr_30220_30249[(2)] = null);

(statearr_30220_30249[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30218 === (4))){
var inst_30166 = (state_30217[(2)]);
var state_30217__$1 = (function (){var statearr_30221 = state_30217;
(statearr_30221[(7)] = inst_30166);

return statearr_30221;
})();
var statearr_30222_30250 = state_30217__$1;
(statearr_30222_30250[(2)] = null);

(statearr_30222_30250[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30218 === (13))){
var inst_30212 = (state_30217[(2)]);
var _ = (function (){var statearr_30223 = state_30217;
(statearr_30223[(4)] = cljs.core.rest((state_30217[(4)])));

return statearr_30223;
})();
var state_30217__$1 = state_30217;
var statearr_30224_30251 = state_30217__$1;
(statearr_30224_30251[(2)] = inst_30212);

(statearr_30224_30251[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30218 === (6))){
var inst_30176 = (state_30217[(2)]);
var state_30217__$1 = state_30217;
var statearr_30225_30252 = state_30217__$1;
(statearr_30225_30252[(2)] = inst_30176);

(statearr_30225_30252[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30218 === (3))){
var inst_30215 = (state_30217[(2)]);
var state_30217__$1 = state_30217;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30217__$1,inst_30215);
} else {
if((state_val_30218 === (12))){
var inst_30199 = (state_30217[(8)]);
var inst_30208 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30209 = [null,inst_30199];
var inst_30210 = (new cljs.core.PersistentVector(null,2,(5),inst_30208,inst_30209,null));
var state_30217__$1 = state_30217;
var statearr_30226_30253 = state_30217__$1;
(statearr_30226_30253[(2)] = inst_30210);

(statearr_30226_30253[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30218 === (2))){
var _ = (function (){var statearr_30228 = state_30217;
(statearr_30228[(4)] = cljs.core.cons((9),(state_30217[(4)])));

return statearr_30228;
})();
var inst_30185 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_30186 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30187 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30188 = [null,pred_name,"?o"];
var inst_30189 = (new cljs.core.PersistentVector(null,3,(5),inst_30187,inst_30188,null));
var inst_30190 = [inst_30189];
var inst_30191 = (new cljs.core.PersistentVector(null,1,(5),inst_30186,inst_30190,null));
var inst_30192 = ["?o",inst_30191,opts];
var inst_30193 = cljs.core.PersistentHashMap.fromArrays(inst_30185,inst_30192);
var inst_30194 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_30193);
var state_30217__$1 = state_30217;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30217__$1,(10),inst_30194);
} else {
if((state_val_30218 === (11))){
var inst_30198 = (state_30217[(9)]);
var inst_30199 = (state_30217[(8)]);
var inst_30203 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30204 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_30198);
var inst_30205 = [inst_30204,inst_30199];
var inst_30206 = (new cljs.core.PersistentVector(null,2,(5),inst_30203,inst_30205,null));
var state_30217__$1 = state_30217;
var statearr_30229_30254 = state_30217__$1;
(statearr_30229_30254[(2)] = inst_30206);

(statearr_30229_30254[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30218 === (9))){
var _ = (function (){var statearr_30230 = state_30217;
(statearr_30230[(4)] = cljs.core.rest((state_30217[(4)])));

return statearr_30230;
})();
var state_30217__$1 = state_30217;
var ex30227 = (state_30217__$1[(2)]);
var statearr_30231_30255 = state_30217__$1;
(statearr_30231_30255[(5)] = ex30227);


var statearr_30232_30256 = state_30217__$1;
(statearr_30232_30256[(1)] = (4));

(statearr_30232_30256[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30218 === (5))){
var inst_30166 = (state_30217[(7)]);
var _ = (function (){var statearr_30234 = state_30217;
(statearr_30234[(4)] = cljs.core.cons((8),(state_30217[(4)])));

return statearr_30234;
})();
var inst_30173 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_30166,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_30235 = state_30217;
(statearr_30235[(4)] = cljs.core.rest((state_30217[(4)])));

return statearr_30235;
})();
var state_30217__$1 = state_30217;
var statearr_30236_30257 = state_30217__$1;
(statearr_30236_30257[(2)] = inst_30173);

(statearr_30236_30257[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30218 === (10))){
var inst_30198 = (state_30217[(9)]);
var inst_30196 = (state_30217[(2)]);
var inst_30197 = fluree.db.util.async.throw_err(inst_30196);
var inst_30198__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30197,(0),null);
var inst_30199 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30197,(1),null);
var inst_30200 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_30198__$1);
var inst_30201 = cljs.core.not(inst_30200);
var state_30217__$1 = (function (){var statearr_30237 = state_30217;
(statearr_30237[(9)] = inst_30198__$1);

(statearr_30237[(8)] = inst_30199);

return statearr_30237;
})();
if(inst_30201){
var statearr_30238_30258 = state_30217__$1;
(statearr_30238_30258[(1)] = (11));

} else {
var statearr_30239_30259 = state_30217__$1;
(statearr_30239_30259[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30218 === (8))){
var _ = (function (){var statearr_30240 = state_30217;
(statearr_30240[(4)] = cljs.core.rest((state_30217[(4)])));

return statearr_30240;
})();
var state_30217__$1 = state_30217;
var ex30233 = (state_30217__$1[(2)]);
var statearr_30241_30260 = state_30217__$1;
(statearr_30241_30260[(5)] = ex30233);


var statearr_30242_30261 = state_30217__$1;
(statearr_30242_30261[(1)] = (7));

(statearr_30242_30261[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2749__auto____0 = (function (){
var statearr_30243 = [null,null,null,null,null,null,null,null,null,null];
(statearr_30243[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2749__auto__);

(statearr_30243[(1)] = (1));

return statearr_30243;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2749__auto____1 = (function (state_30217){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_30217);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e30244){var ex__2752__auto__ = e30244;
var statearr_30245_30262 = state_30217;
(statearr_30245_30262[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_30217[(4)]))){
var statearr_30246_30263 = state_30217;
(statearr_30246_30263[(1)] = cljs.core.first((state_30217[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30264 = state_30217;
state_30217 = G__30264;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2749__auto__ = function(state_30217){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2749__auto____1.call(this,state_30217);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_30247 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_30247[(6)] = c__2771__auto__);

return statearr_30247;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__5043__auto__ = typeof email === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__5043__auto__;
}
})());
}catch (e30265){var e = e30265;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__30267 = arguments.length;
switch (G__30267) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_30337){
var state_val_30338 = (state_30337[(1)]);
if((state_val_30338 === (7))){
var inst_30269 = (state_30337[(2)]);
var state_30337__$1 = state_30337;
var statearr_30339_30383 = state_30337__$1;
(statearr_30339_30383[(2)] = inst_30269);

(statearr_30339_30383[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30338 === (20))){
var inst_30313 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30314 = ["*"];
var inst_30315 = (new cljs.core.PersistentVector(null,1,(5),inst_30313,inst_30314,null));
var state_30337__$1 = state_30337;
var statearr_30340_30384 = state_30337__$1;
(statearr_30340_30384[(2)] = inst_30315);

(statearr_30340_30384[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30338 === (1))){
var state_30337__$1 = state_30337;
var statearr_30341_30385 = state_30337__$1;
(statearr_30341_30385[(2)] = null);

(statearr_30341_30385[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30338 === (4))){
var inst_30268 = (state_30337[(2)]);
var state_30337__$1 = (function (){var statearr_30342 = state_30337;
(statearr_30342[(7)] = inst_30268);

return statearr_30342;
})();
var statearr_30343_30386 = state_30337__$1;
(statearr_30343_30386[(2)] = null);

(statearr_30343_30386[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30338 === (15))){
var inst_30332 = (state_30337[(2)]);
var _ = (function (){var statearr_30344 = state_30337;
(statearr_30344[(4)] = cljs.core.rest((state_30337[(4)])));

return statearr_30344;
})();
var state_30337__$1 = state_30337;
var statearr_30345_30387 = state_30337__$1;
(statearr_30345_30387[(2)] = inst_30332);

(statearr_30345_30387[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30338 === (21))){
var inst_30303 = (state_30337[(8)]);
var inst_30296 = (state_30337[(9)]);
var inst_30317 = (state_30337[(2)]);
var inst_30318 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_30319 = cljs.core.PersistentHashMap.EMPTY;
var inst_30320 = [inst_30317,inst_30303,inst_30319];
var inst_30321 = cljs.core.PersistentHashMap.fromArrays(inst_30318,inst_30320);
var inst_30322 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_30296,inst_30321);
var state_30337__$1 = state_30337;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30337__$1,(22),inst_30322);
} else {
if((state_val_30338 === (13))){
var inst_30291 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_30337__$1 = state_30337;
var statearr_30346_30388 = state_30337__$1;
(statearr_30346_30388[(2)] = inst_30291);

(statearr_30346_30388[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30338 === (22))){
var inst_30324 = (state_30337[(2)]);
var inst_30325 = fluree.db.util.async.throw_err(inst_30324);
var inst_30326 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30325,(0),null);
var inst_30327 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30325,(1),null);
var inst_30328 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30329 = [inst_30326,inst_30327];
var inst_30330 = (new cljs.core.PersistentVector(null,2,(5),inst_30328,inst_30329,null));
var state_30337__$1 = state_30337;
var statearr_30347_30389 = state_30337__$1;
(statearr_30347_30389[(2)] = inst_30330);

(statearr_30347_30389[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30338 === (6))){
var inst_30278 = (state_30337[(2)]);
var state_30337__$1 = state_30337;
var statearr_30348_30390 = state_30337__$1;
(statearr_30348_30390[(2)] = inst_30278);

(statearr_30348_30390[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30338 === (17))){
var inst_30300 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30301 = fluree.db.dbfunctions.internal.get(inst_30300,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_30337__$1 = state_30337;
var statearr_30349_30391 = state_30337__$1;
(statearr_30349_30391[(2)] = inst_30301);

(statearr_30349_30391[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30338 === (3))){
var inst_30335 = (state_30337[(2)]);
var state_30337__$1 = state_30337;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30337__$1,inst_30335);
} else {
if((state_val_30338 === (12))){
var inst_30289 = (state_30337[(2)]);
var state_30337__$1 = state_30337;
if(cljs.core.truth_(inst_30289)){
var statearr_30350_30392 = state_30337__$1;
(statearr_30350_30392[(1)] = (13));

} else {
var statearr_30351_30393 = state_30337__$1;
(statearr_30351_30393[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30338 === (2))){
var inst_30284 = (state_30337[(10)]);
var _ = (function (){var statearr_30352 = state_30337;
(statearr_30352[(4)] = cljs.core.cons((9),(state_30337[(4)])));

return statearr_30352;
})();
var inst_30284__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_30337__$1 = (function (){var statearr_30353 = state_30337;
(statearr_30353[(10)] = inst_30284__$1);

return statearr_30353;
})();
if(cljs.core.truth_(inst_30284__$1)){
var statearr_30354_30394 = state_30337__$1;
(statearr_30354_30394[(1)] = (10));

} else {
var statearr_30355_30395 = state_30337__$1;
(statearr_30355_30395[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30338 === (19))){
var inst_30305 = cljs.core.PersistentVector.EMPTY;
var inst_30306 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30307 = ["*"];
var inst_30308 = (new cljs.core.PersistentVector(null,1,(5),inst_30306,inst_30307,null));
var inst_30309 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_30310 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_30308,inst_30309);
var inst_30311 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_30305,inst_30310);
var state_30337__$1 = state_30337;
var statearr_30357_30396 = state_30337__$1;
(statearr_30357_30396[(2)] = inst_30311);

(statearr_30357_30396[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30338 === (11))){
var inst_30284 = (state_30337[(10)]);
var state_30337__$1 = state_30337;
var statearr_30358_30397 = state_30337__$1;
(statearr_30358_30397[(2)] = inst_30284);

(statearr_30358_30397[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30338 === (9))){
var _ = (function (){var statearr_30359 = state_30337;
(statearr_30359[(4)] = cljs.core.rest((state_30337[(4)])));

return statearr_30359;
})();
var state_30337__$1 = state_30337;
var ex30356 = (state_30337__$1[(2)]);
var statearr_30360_30398 = state_30337__$1;
(statearr_30360_30398[(5)] = ex30356);


var statearr_30361_30399 = state_30337__$1;
(statearr_30361_30399[(1)] = (4));

(statearr_30361_30399[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30338 === (5))){
var inst_30268 = (state_30337[(7)]);
var _ = (function (){var statearr_30362 = state_30337;
(statearr_30362[(4)] = cljs.core.cons((8),(state_30337[(4)])));

return statearr_30362;
})();
var inst_30275 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_30268,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_30363 = state_30337;
(statearr_30363[(4)] = cljs.core.rest((state_30337[(4)])));

return statearr_30363;
})();
var state_30337__$1 = state_30337;
var statearr_30364_30400 = state_30337__$1;
(statearr_30364_30400[(2)] = inst_30275);

(statearr_30364_30400[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30338 === (14))){
var inst_30297 = (state_30337[(11)]);
var inst_30296 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30297__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_30337__$1 = (function (){var statearr_30365 = state_30337;
(statearr_30365[(11)] = inst_30297__$1);

(statearr_30365[(9)] = inst_30296);

return statearr_30365;
})();
if(cljs.core.truth_(inst_30297__$1)){
var statearr_30366_30401 = state_30337__$1;
(statearr_30366_30401[(1)] = (16));

} else {
var statearr_30367_30402 = state_30337__$1;
(statearr_30367_30402[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30338 === (16))){
var inst_30297 = (state_30337[(11)]);
var state_30337__$1 = state_30337;
var statearr_30368_30403 = state_30337__$1;
(statearr_30368_30403[(2)] = inst_30297);

(statearr_30368_30403[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30338 === (10))){
var inst_30286 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_30337__$1 = state_30337;
var statearr_30370_30404 = state_30337__$1;
(statearr_30370_30404[(2)] = inst_30286);

(statearr_30370_30404[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30338 === (18))){
var inst_30303 = (state_30337[(2)]);
var state_30337__$1 = (function (){var statearr_30371 = state_30337;
(statearr_30371[(8)] = inst_30303);

return statearr_30371;
})();
if(cljs.core.truth_(additional_params)){
var statearr_30372_30405 = state_30337__$1;
(statearr_30372_30405[(1)] = (19));

} else {
var statearr_30373_30406 = state_30337__$1;
(statearr_30373_30406[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30338 === (8))){
var _ = (function (){var statearr_30374 = state_30337;
(statearr_30374[(4)] = cljs.core.rest((state_30337[(4)])));

return statearr_30374;
})();
var state_30337__$1 = state_30337;
var ex30369 = (state_30337__$1[(2)]);
var statearr_30375_30407 = state_30337__$1;
(statearr_30375_30407[(5)] = ex30369);


var statearr_30376_30408 = state_30337__$1;
(statearr_30376_30408[(1)] = (7));

(statearr_30376_30408[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2749__auto____0 = (function (){
var statearr_30377 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30377[(0)] = fluree$db$dbfunctions$internal$state_machine__2749__auto__);

(statearr_30377[(1)] = (1));

return statearr_30377;
});
var fluree$db$dbfunctions$internal$state_machine__2749__auto____1 = (function (state_30337){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_30337);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e30378){var ex__2752__auto__ = e30378;
var statearr_30379_30409 = state_30337;
(statearr_30379_30409[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_30337[(4)]))){
var statearr_30380_30410 = state_30337;
(statearr_30380_30410[(1)] = cljs.core.first((state_30337[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30411 = state_30337;
state_30337 = G__30411;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2749__auto__ = function(state_30337){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2749__auto____1.call(this,state_30337);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2749__auto____0;
fluree$db$dbfunctions$internal$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2749__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_30381 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_30381[(6)] = c__2771__auto__);

return statearr_30381;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__30413 = arguments.length;
switch (G__30413) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_30457){
var state_val_30458 = (state_30457[(1)]);
if((state_val_30458 === (7))){
var inst_30435 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30436 = ["*"];
var inst_30437 = (new cljs.core.PersistentVector(null,1,(5),inst_30435,inst_30436,null));
var state_30457__$1 = state_30457;
var statearr_30459_30479 = state_30457__$1;
(statearr_30459_30479[(2)] = inst_30437);

(statearr_30459_30479[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30458 === (1))){
var state_30457__$1 = state_30457;
var statearr_30460_30480 = state_30457__$1;
(statearr_30460_30480[(2)] = null);

(statearr_30460_30480[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30458 === (4))){
var inst_30414 = (state_30457[(2)]);
var inst_30415 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_30414,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_30457__$1 = state_30457;
var statearr_30461_30481 = state_30457__$1;
(statearr_30461_30481[(2)] = inst_30415);

(statearr_30461_30481[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30458 === (6))){
var inst_30427 = cljs.core.PersistentVector.EMPTY;
var inst_30428 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30429 = ["*"];
var inst_30430 = (new cljs.core.PersistentVector(null,1,(5),inst_30428,inst_30429,null));
var inst_30431 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_30432 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_30430,inst_30431);
var inst_30433 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_30427,inst_30432);
var state_30457__$1 = state_30457;
var statearr_30462_30482 = state_30457__$1;
(statearr_30462_30482[(2)] = inst_30433);

(statearr_30462_30482[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30458 === (3))){
var inst_30455 = (state_30457[(2)]);
var state_30457__$1 = state_30457;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30457__$1,inst_30455);
} else {
if((state_val_30458 === (2))){
var _ = (function (){var statearr_30464 = state_30457;
(statearr_30464[(4)] = cljs.core.cons((5),(state_30457[(4)])));

return statearr_30464;
})();
var inst_30424 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30425 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_30457__$1 = (function (){var statearr_30465 = state_30457;
(statearr_30465[(7)] = inst_30424);

(statearr_30465[(8)] = inst_30425);

return statearr_30465;
})();
if(cljs.core.truth_(additional_params)){
var statearr_30466_30483 = state_30457__$1;
(statearr_30466_30483[(1)] = (6));

} else {
var statearr_30467_30484 = state_30457__$1;
(statearr_30467_30484[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30458 === (9))){
var inst_30446 = (state_30457[(2)]);
var inst_30447 = fluree.db.util.async.throw_err(inst_30446);
var inst_30448 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30447,(0),null);
var inst_30449 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30447,(1),null);
var inst_30450 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30451 = [inst_30448,inst_30449];
var inst_30452 = (new cljs.core.PersistentVector(null,2,(5),inst_30450,inst_30451,null));
var _ = (function (){var statearr_30468 = state_30457;
(statearr_30468[(4)] = cljs.core.rest((state_30457[(4)])));

return statearr_30468;
})();
var state_30457__$1 = state_30457;
var statearr_30469_30485 = state_30457__$1;
(statearr_30469_30485[(2)] = inst_30452);

(statearr_30469_30485[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30458 === (5))){
var _ = (function (){var statearr_30470 = state_30457;
(statearr_30470[(4)] = cljs.core.rest((state_30457[(4)])));

return statearr_30470;
})();
var state_30457__$1 = state_30457;
var ex30463 = (state_30457__$1[(2)]);
var statearr_30471_30486 = state_30457__$1;
(statearr_30471_30486[(5)] = ex30463);


var statearr_30472_30487 = state_30457__$1;
(statearr_30472_30487[(1)] = (4));

(statearr_30472_30487[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30458 === (8))){
var inst_30424 = (state_30457[(7)]);
var inst_30425 = (state_30457[(8)]);
var inst_30439 = (state_30457[(2)]);
var inst_30440 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_30441 = cljs.core.PersistentHashMap.EMPTY;
var inst_30442 = [inst_30439,inst_30425,inst_30441];
var inst_30443 = cljs.core.PersistentHashMap.fromArrays(inst_30440,inst_30442);
var inst_30444 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_30424,inst_30443);
var state_30457__$1 = state_30457;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30457__$1,(9),inst_30444);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2749__auto____0 = (function (){
var statearr_30473 = [null,null,null,null,null,null,null,null,null];
(statearr_30473[(0)] = fluree$db$dbfunctions$internal$state_machine__2749__auto__);

(statearr_30473[(1)] = (1));

return statearr_30473;
});
var fluree$db$dbfunctions$internal$state_machine__2749__auto____1 = (function (state_30457){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_30457);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e30474){var ex__2752__auto__ = e30474;
var statearr_30475_30488 = state_30457;
(statearr_30475_30488[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_30457[(4)]))){
var statearr_30476_30489 = state_30457;
(statearr_30476_30489[(1)] = cljs.core.first((state_30457[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30490 = state_30457;
state_30457 = G__30490;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2749__auto__ = function(state_30457){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2749__auto____1.call(this,state_30457);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2749__auto____0;
fluree$db$dbfunctions$internal$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2749__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_30477 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_30477[(6)] = c__2771__auto__);

return statearr_30477;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_30534){
var state_val_30535 = (state_30534[(1)]);
if((state_val_30535 === (1))){
var state_30534__$1 = state_30534;
var statearr_30536_30550 = state_30534__$1;
(statearr_30536_30550[(2)] = null);

(statearr_30536_30550[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30535 === (2))){
var _ = (function (){var statearr_30537 = state_30534;
(statearr_30537[(4)] = cljs.core.cons((5),(state_30534[(4)])));

return statearr_30537;
})();
var inst_30501 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_30502 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30503 = ["_user/_auth"];
var inst_30504 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30505 = ["*"];
var inst_30506 = (new cljs.core.PersistentVector(null,1,(5),inst_30504,inst_30505,null));
var inst_30507 = [inst_30506];
var inst_30508 = cljs.core.PersistentHashMap.fromArrays(inst_30503,inst_30507);
var inst_30509 = [inst_30508];
var inst_30510 = (new cljs.core.PersistentVector(null,1,(5),inst_30502,inst_30509,null));
var inst_30511 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30512 = cljs.core.PersistentHashMap.EMPTY;
var inst_30513 = [inst_30510,inst_30511,inst_30512];
var inst_30514 = cljs.core.PersistentHashMap.fromArrays(inst_30501,inst_30513);
var inst_30515 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30516 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_30515,inst_30514);
var state_30534__$1 = state_30534;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30534__$1,(6),inst_30516);
} else {
if((state_val_30535 === (3))){
var inst_30532 = (state_30534[(2)]);
var state_30534__$1 = state_30534;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30534__$1,inst_30532);
} else {
if((state_val_30535 === (4))){
var inst_30491 = (state_30534[(2)]);
var inst_30492 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_30491,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_30534__$1 = state_30534;
var statearr_30539_30551 = state_30534__$1;
(statearr_30539_30551[(2)] = inst_30492);

(statearr_30539_30551[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30535 === (5))){
var _ = (function (){var statearr_30540 = state_30534;
(statearr_30540[(4)] = cljs.core.rest((state_30534[(4)])));

return statearr_30540;
})();
var state_30534__$1 = state_30534;
var ex30538 = (state_30534__$1[(2)]);
var statearr_30541_30552 = state_30534__$1;
(statearr_30541_30552[(5)] = ex30538);


var statearr_30542_30553 = state_30534__$1;
(statearr_30542_30553[(1)] = (4));

(statearr_30542_30553[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30535 === (6))){
var inst_30518 = (state_30534[(2)]);
var inst_30519 = fluree.db.util.async.throw_err(inst_30518);
var inst_30520 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30519,(0),null);
var inst_30521 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30519,(1),null);
var inst_30522 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30523 = ["_user/_auth","_id"];
var inst_30524 = (new cljs.core.PersistentVector(null,2,(5),inst_30522,inst_30523,null));
var inst_30525 = fluree.db.dbfunctions.internal.get_in(inst_30520,inst_30524);
var inst_30526 = cljs.core.first(inst_30525);
var inst_30527 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30528 = [inst_30526,inst_30521];
var inst_30529 = (new cljs.core.PersistentVector(null,2,(5),inst_30527,inst_30528,null));
var _ = (function (){var statearr_30543 = state_30534;
(statearr_30543[(4)] = cljs.core.rest((state_30534[(4)])));

return statearr_30543;
})();
var state_30534__$1 = state_30534;
var statearr_30544_30554 = state_30534__$1;
(statearr_30544_30554[(2)] = inst_30529);

(statearr_30544_30554[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2749__auto____0 = (function (){
var statearr_30545 = [null,null,null,null,null,null,null];
(statearr_30545[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2749__auto__);

(statearr_30545[(1)] = (1));

return statearr_30545;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2749__auto____1 = (function (state_30534){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_30534);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e30546){var ex__2752__auto__ = e30546;
var statearr_30547_30555 = state_30534;
(statearr_30547_30555[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_30534[(4)]))){
var statearr_30548_30556 = state_30534;
(statearr_30548_30556[(1)] = cljs.core.first((state_30534[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30557 = state_30534;
state_30534 = G__30557;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2749__auto__ = function(state_30534){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2749__auto____1.call(this,state_30534);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_30549 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_30549[(6)] = c__2771__auto__);

return statearr_30549;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_30574){
var state_val_30575 = (state_30574[(1)]);
if((state_val_30575 === (1))){
var state_30574__$1 = state_30574;
var statearr_30576_30590 = state_30574__$1;
(statearr_30576_30590[(2)] = null);

(statearr_30576_30590[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30575 === (2))){
var _ = (function (){var statearr_30577 = state_30574;
(statearr_30577[(4)] = cljs.core.cons((5),(state_30574[(4)])));

return statearr_30577;
})();
var inst_30564 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30565 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_30566 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_30565,inst_30564);
var state_30574__$1 = state_30574;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30574__$1,(6),inst_30566);
} else {
if((state_val_30575 === (3))){
var inst_30572 = (state_30574[(2)]);
var state_30574__$1 = state_30574;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30574__$1,inst_30572);
} else {
if((state_val_30575 === (4))){
var inst_30558 = (state_30574[(2)]);
var state_30574__$1 = state_30574;
var statearr_30579_30591 = state_30574__$1;
(statearr_30579_30591[(2)] = inst_30558);

(statearr_30579_30591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30575 === (5))){
var _ = (function (){var statearr_30580 = state_30574;
(statearr_30580[(4)] = cljs.core.rest((state_30574[(4)])));

return statearr_30580;
})();
var state_30574__$1 = state_30574;
var ex30578 = (state_30574__$1[(2)]);
var statearr_30581_30592 = state_30574__$1;
(statearr_30581_30592[(5)] = ex30578);


if((ex30578 instanceof Error)){
var statearr_30582_30593 = state_30574__$1;
(statearr_30582_30593[(1)] = (4));

(statearr_30582_30593[(5)] = null);

} else {
throw ex30578;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30575 === (6))){
var inst_30568 = (state_30574[(2)]);
var inst_30569 = fluree.db.util.async.throw_err(inst_30568);
var _ = (function (){var statearr_30583 = state_30574;
(statearr_30583[(4)] = cljs.core.rest((state_30574[(4)])));

return statearr_30583;
})();
var state_30574__$1 = state_30574;
var statearr_30584_30594 = state_30574__$1;
(statearr_30584_30594[(2)] = inst_30569);

(statearr_30584_30594[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2749__auto____0 = (function (){
var statearr_30585 = [null,null,null,null,null,null,null];
(statearr_30585[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2749__auto__);

(statearr_30585[(1)] = (1));

return statearr_30585;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2749__auto____1 = (function (state_30574){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_30574);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e30586){var ex__2752__auto__ = e30586;
var statearr_30587_30595 = state_30574;
(statearr_30587_30595[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_30574[(4)]))){
var statearr_30588_30596 = state_30574;
(statearr_30588_30596[(1)] = cljs.core.first((state_30574[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30597 = state_30574;
state_30574 = G__30597;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2749__auto__ = function(state_30574){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2749__auto____1.call(this,state_30574);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_30589 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_30589[(6)] = c__2771__auto__);

return statearr_30589;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__30598_SHARP_){
return p1__30598_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30599_SHARP_){
return p1__30599_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e30600){var e = e30600;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__30601_SHARP_){
return p1__30601_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30602_SHARP_){
return p1__30602_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e30603){var e = e30603;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__30605 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__30605);
})() | (0));
return num;
}catch (e30604){var e = e30604;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_30685){
var state_val_30686 = (state_30685[(1)]);
if((state_val_30686 === (7))){
var inst_30624 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_30625 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30626 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_30627 = cljs.core.PersistentHashMap.fromArrays(inst_30625,inst_30626);
var inst_30628 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_30624,inst_30627);
var inst_30629 = (function(){throw inst_30628})();
var state_30685__$1 = state_30685;
var statearr_30687_30722 = state_30685__$1;
(statearr_30687_30722[(2)] = inst_30629);

(statearr_30687_30722[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (1))){
var state_30685__$1 = state_30685;
var statearr_30688_30723 = state_30685__$1;
(statearr_30688_30723[(2)] = null);

(statearr_30688_30723[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (4))){
var inst_30606 = (state_30685[(2)]);
var state_30685__$1 = state_30685;
var statearr_30689_30724 = state_30685__$1;
(statearr_30689_30724[(2)] = inst_30606);

(statearr_30689_30724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (15))){
var inst_30669 = (state_30685[(7)]);
var inst_30665 = (state_30685[(2)]);
var inst_30666 = fluree.db.util.async.throw_err(inst_30665);
var inst_30667 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30666,(0),null);
var inst_30668 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30666,(1),null);
var inst_30669__$1 = cljs.core.first(inst_30667);
var inst_30670 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30669__$1,compare_val);
var state_30685__$1 = (function (){var statearr_30690 = state_30685;
(statearr_30690[(8)] = inst_30668);

(statearr_30690[(7)] = inst_30669__$1);

return statearr_30690;
})();
if(inst_30670){
var statearr_30691_30725 = state_30685__$1;
(statearr_30691_30725[(1)] = (16));

} else {
var statearr_30692_30726 = state_30685__$1;
(statearr_30692_30726[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (13))){
var state_30685__$1 = state_30685;
var statearr_30693_30727 = state_30685__$1;
(statearr_30693_30727[(2)] = null);

(statearr_30693_30727[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (6))){
var state_30685__$1 = state_30685;
var statearr_30694_30728 = state_30685__$1;
(statearr_30694_30728[(2)] = null);

(statearr_30694_30728[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (17))){
var inst_30669 = (state_30685[(7)]);
var inst_30673 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_30669)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_30674 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30675 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_30676 = cljs.core.PersistentHashMap.fromArrays(inst_30674,inst_30675);
var inst_30677 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_30673,inst_30676);
var inst_30678 = (function(){throw inst_30677})();
var state_30685__$1 = state_30685;
var statearr_30695_30729 = state_30685__$1;
(statearr_30695_30729[(2)] = inst_30678);

(statearr_30695_30729[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (3))){
var inst_30683 = (state_30685[(2)]);
var state_30685__$1 = state_30685;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30685__$1,inst_30683);
} else {
if((state_val_30686 === (12))){
var inst_30621 = (state_30685[(9)]);
var inst_30644 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_30621], 0));
var inst_30645 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30646 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_30647 = cljs.core.PersistentHashMap.fromArrays(inst_30645,inst_30646);
var inst_30648 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_30644,inst_30647);
var inst_30649 = (function(){throw inst_30648})();
var state_30685__$1 = state_30685;
var statearr_30696_30730 = state_30685__$1;
(statearr_30696_30730[(2)] = inst_30649);

(statearr_30696_30730[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (2))){
var inst_30619 = (state_30685[(10)]);
var inst_30618 = (state_30685[(11)]);
var inst_30620 = (state_30685[(12)]);
var _ = (function (){var statearr_30697 = state_30685;
(statearr_30697[(4)] = cljs.core.cons((5),(state_30685[(4)])));

return statearr_30697;
})();
var inst_30616 = _QMARK_ctx;
var inst_30617 = cljs.core.__destructure_map(inst_30616);
var inst_30618__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30617,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_30619__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30617,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_30620__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30617,new cljs.core.Keyword(null,"db","db",993250759));
var inst_30621 = fluree.db.dbproto._p_prop(inst_30620__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_30619__$1);
var state_30685__$1 = (function (){var statearr_30698 = state_30685;
(statearr_30698[(10)] = inst_30619__$1);

(statearr_30698[(9)] = inst_30621);

(statearr_30698[(11)] = inst_30618__$1);

(statearr_30698[(12)] = inst_30620__$1);

return statearr_30698;
})();
if(cljs.core.truth_(inst_30618__$1)){
var statearr_30699_30731 = state_30685__$1;
(statearr_30699_30731[(1)] = (6));

} else {
var statearr_30700_30732 = state_30685__$1;
(statearr_30700_30732[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (11))){
var inst_30619 = (state_30685[(10)]);
var inst_30620 = (state_30685[(12)]);
var inst_30641 = (state_30685[(2)]);
var inst_30642 = fluree.db.dbproto._p_prop(inst_30620,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_30619);
var state_30685__$1 = (function (){var statearr_30702 = state_30685;
(statearr_30702[(13)] = inst_30641);

return statearr_30702;
})();
if(cljs.core.truth_(inst_30642)){
var statearr_30703_30733 = state_30685__$1;
(statearr_30703_30733[(1)] = (12));

} else {
var statearr_30704_30734 = state_30685__$1;
(statearr_30704_30734[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (9))){
var state_30685__$1 = state_30685;
var statearr_30705_30735 = state_30685__$1;
(statearr_30705_30735[(2)] = null);

(statearr_30705_30735[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (5))){
var _ = (function (){var statearr_30706 = state_30685;
(statearr_30706[(4)] = cljs.core.rest((state_30685[(4)])));

return statearr_30706;
})();
var state_30685__$1 = state_30685;
var ex30701 = (state_30685__$1[(2)]);
var statearr_30707_30736 = state_30685__$1;
(statearr_30707_30736[(5)] = ex30701);


if((ex30701 instanceof Error)){
var statearr_30708_30737 = state_30685__$1;
(statearr_30708_30737[(1)] = (4));

(statearr_30708_30737[(5)] = null);

} else {
throw ex30701;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (14))){
var inst_30621 = (state_30685[(9)]);
var inst_30618 = (state_30685[(11)]);
var inst_30620 = (state_30685[(12)]);
var inst_30652 = (state_30685[(2)]);
var inst_30653 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_30654 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30655 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30656 = [inst_30618,inst_30621,"?current-val"];
var inst_30657 = (new cljs.core.PersistentVector(null,3,(5),inst_30655,inst_30656,null));
var inst_30658 = [inst_30657];
var inst_30659 = (new cljs.core.PersistentVector(null,1,(5),inst_30654,inst_30658,null));
var inst_30660 = cljs.core.PersistentHashMap.EMPTY;
var inst_30661 = ["?current-val",inst_30659,inst_30660];
var inst_30662 = cljs.core.PersistentHashMap.fromArrays(inst_30653,inst_30661);
var inst_30663 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_30620,inst_30662);
var state_30685__$1 = (function (){var statearr_30709 = state_30685;
(statearr_30709[(14)] = inst_30652);

return statearr_30709;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30685__$1,(15),inst_30663);
} else {
if((state_val_30686 === (16))){
var state_30685__$1 = state_30685;
var statearr_30710_30738 = state_30685__$1;
(statearr_30710_30738[(2)] = new_val);

(statearr_30710_30738[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (10))){
var inst_30634 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_30635 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30636 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_30637 = cljs.core.PersistentHashMap.fromArrays(inst_30635,inst_30636);
var inst_30638 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_30634,inst_30637);
var inst_30639 = (function(){throw inst_30638})();
var state_30685__$1 = state_30685;
var statearr_30711_30739 = state_30685__$1;
(statearr_30711_30739[(2)] = inst_30639);

(statearr_30711_30739[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (18))){
var inst_30680 = (state_30685[(2)]);
var _ = (function (){var statearr_30712 = state_30685;
(statearr_30712[(4)] = cljs.core.rest((state_30685[(4)])));

return statearr_30712;
})();
var state_30685__$1 = state_30685;
var statearr_30713_30740 = state_30685__$1;
(statearr_30713_30740[(2)] = inst_30680);

(statearr_30713_30740[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30686 === (8))){
var inst_30621 = (state_30685[(9)]);
var inst_30631 = (state_30685[(2)]);
var state_30685__$1 = (function (){var statearr_30714 = state_30685;
(statearr_30714[(15)] = inst_30631);

return statearr_30714;
})();
if(cljs.core.truth_(inst_30621)){
var statearr_30715_30741 = state_30685__$1;
(statearr_30715_30741[(1)] = (9));

} else {
var statearr_30716_30742 = state_30685__$1;
(statearr_30716_30742[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2749__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2749__auto____0 = (function (){
var statearr_30717 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30717[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2749__auto__);

(statearr_30717[(1)] = (1));

return statearr_30717;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2749__auto____1 = (function (state_30685){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_30685);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e30718){var ex__2752__auto__ = e30718;
var statearr_30719_30743 = state_30685;
(statearr_30719_30743[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_30685[(4)]))){
var statearr_30720_30744 = state_30685;
(statearr_30720_30744[(1)] = cljs.core.first((state_30685[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30745 = state_30685;
state_30685 = G__30745;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2749__auto__ = function(state_30685){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2749__auto____1.call(this,state_30685);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2749__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2749__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_30721 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_30721[(6)] = c__2771__auto__);

return statearr_30721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
