// Compiled by ClojureScript 1.11.57 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__27386 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27386,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27386,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27386,(2),null);
if(cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__27389){
var map__27390 = p__27389;
var map__27390__$1 = cljs.core.__destructure_map(map__27390);
var opts = map__27390__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27390__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_27450){
var state_val_27451 = (state_27450[(1)]);
if((state_val_27451 === (7))){
var inst_27421 = cljs.core.not(reindex_QMARK_);
var state_27450__$1 = state_27450;
var statearr_27452_27476 = state_27450__$1;
(statearr_27452_27476[(2)] = inst_27421);

(statearr_27452_27476[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27451 === (1))){
var state_27450__$1 = state_27450;
var statearr_27453_27477 = state_27450__$1;
(statearr_27453_27477[(2)] = null);

(statearr_27453_27477[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27451 === (4))){
var inst_27391 = (state_27450[(2)]);
var state_27450__$1 = state_27450;
var statearr_27454_27478 = state_27450__$1;
(statearr_27454_27478[(2)] = inst_27391);

(statearr_27454_27478[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27451 === (6))){
var inst_27411 = (state_27450[(7)]);
var inst_27405 = (state_27450[(8)]);
var inst_27419 = (state_27450[(9)]);
var inst_27404 = (state_27450[(2)]);
var inst_27405__$1 = fluree.db.util.async.throw_err(inst_27404);
var inst_27406 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_27407 = cljs.core.__destructure_map(inst_27406);
var inst_27408 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27407,new cljs.core.Keyword(null,"post","post",269697687));
var inst_27409 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27407,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_27410 = fluree.db.flake.size_bytes(inst_27405__$1);
var inst_27411__$1 = (inst_27409 + inst_27410);
var inst_27412 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27413 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_27414 = (new cljs.core.PersistentVector(null,2,(5),inst_27412,inst_27413,null));
var inst_27415 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_27414);
var inst_27416 = cljs.core.__destructure_map(inst_27415);
var inst_27417 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27416,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_27418 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27416,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_27419__$1 = (inst_27411__$1 > inst_27418);
var state_27450__$1 = (function (){var statearr_27455 = state_27450;
(statearr_27455[(7)] = inst_27411__$1);

(statearr_27455[(10)] = inst_27408);

(statearr_27455[(8)] = inst_27405__$1);

(statearr_27455[(11)] = inst_27417);

(statearr_27455[(9)] = inst_27419__$1);

return statearr_27455;
})();
if(cljs.core.truth_(inst_27419__$1)){
var statearr_27456_27479 = state_27450__$1;
(statearr_27456_27479[(1)] = (7));

} else {
var statearr_27457_27480 = state_27450__$1;
(statearr_27457_27480[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27451 === (3))){
var inst_27448 = (state_27450[(2)]);
var state_27450__$1 = state_27450;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27450__$1,inst_27448);
} else {
if((state_val_27451 === (12))){
var inst_27411 = (state_27450[(7)]);
var inst_27408 = (state_27450[(10)]);
var inst_27405 = (state_27450[(8)]);
var inst_27434 = (state_27450[(2)]);
var inst_27435 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_27408,inst_27405);
var inst_27436 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_27437 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_27436,cljs.core.empty);
var inst_27438 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27439 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_27440 = (new cljs.core.PersistentVector(null,2,(5),inst_27438,inst_27439,null));
var inst_27441 = cljs.core.assoc_in(db,inst_27440,inst_27435);
var inst_27442 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27443 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_27444 = (new cljs.core.PersistentVector(null,2,(5),inst_27442,inst_27443,null));
var inst_27445 = cljs.core.assoc_in(inst_27441,inst_27444,inst_27411);
var _ = (function (){var statearr_27458 = state_27450;
(statearr_27458[(4)] = cljs.core.rest((state_27450[(4)])));

return statearr_27458;
})();
var state_27450__$1 = (function (){var statearr_27459 = state_27450;
(statearr_27459[(12)] = inst_27437);

(statearr_27459[(13)] = inst_27434);

return statearr_27459;
})();
var statearr_27460_27481 = state_27450__$1;
(statearr_27460_27481[(2)] = inst_27445);

(statearr_27460_27481[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27451 === (2))){
var _ = (function (){var statearr_27461 = state_27450;
(statearr_27461[(4)] = cljs.core.cons((5),(state_27450[(4)])));

return statearr_27461;
})();
var inst_27399 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27400 = [pred_id];
var inst_27401 = (new cljs.core.PersistentVector(null,1,(5),inst_27399,inst_27400,null));
var inst_27402 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_27401);
var state_27450__$1 = state_27450;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27450__$1,(6),inst_27402);
} else {
if((state_val_27451 === (11))){
var state_27450__$1 = state_27450;
var statearr_27463_27482 = state_27450__$1;
(statearr_27463_27482[(2)] = null);

(statearr_27463_27482[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27451 === (9))){
var inst_27424 = (state_27450[(2)]);
var state_27450__$1 = state_27450;
if(cljs.core.truth_(inst_27424)){
var statearr_27464_27483 = state_27450__$1;
(statearr_27464_27483[(1)] = (10));

} else {
var statearr_27465_27484 = state_27450__$1;
(statearr_27465_27484[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27451 === (5))){
var _ = (function (){var statearr_27466 = state_27450;
(statearr_27466[(4)] = cljs.core.rest((state_27450[(4)])));

return statearr_27466;
})();
var state_27450__$1 = state_27450;
var ex27462 = (state_27450__$1[(2)]);
var statearr_27467_27485 = state_27450__$1;
(statearr_27467_27485[(5)] = ex27462);


if((ex27462 instanceof Error)){
var statearr_27468_27486 = state_27450__$1;
(statearr_27468_27486[(1)] = (4));

(statearr_27468_27486[(5)] = null);

} else {
throw ex27462;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27451 === (10))){
var inst_27426 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_27427 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_27428 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_27429 = cljs.core.PersistentHashMap.fromArrays(inst_27427,inst_27428);
var inst_27430 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27426,inst_27429);
var inst_27431 = (function(){throw inst_27430})();
var state_27450__$1 = state_27450;
var statearr_27469_27487 = state_27450__$1;
(statearr_27469_27487[(2)] = inst_27431);

(statearr_27469_27487[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27451 === (8))){
var inst_27419 = (state_27450[(9)]);
var state_27450__$1 = state_27450;
var statearr_27470_27488 = state_27450__$1;
(statearr_27470_27488[(2)] = inst_27419);

(statearr_27470_27488[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2749__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2749__auto____0 = (function (){
var statearr_27471 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27471[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2749__auto__);

(statearr_27471[(1)] = (1));

return statearr_27471;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2749__auto____1 = (function (state_27450){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_27450);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e27472){var ex__2752__auto__ = e27472;
var statearr_27473_27489 = state_27450;
(statearr_27473_27489[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_27450[(4)]))){
var statearr_27474_27490 = state_27450;
(statearr_27474_27490[(1)] = cljs.core.first((state_27450[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27491 = state_27450;
state_27450 = G__27491;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2749__auto__ = function(state_27450){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2749__auto____1.call(this,state_27450);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2749__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2749__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_27475 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_27475[(6)] = c__2771__auto__);

return statearr_27475;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__27496 = arguments.length;
switch (G__27496) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_27692){
var state_val_27693 = (state_27692[(1)]);
if((state_val_27693 === (7))){
var state_27692__$1 = state_27692;
var statearr_27694_27762 = state_27692__$1;
(statearr_27694_27762[(2)] = null);

(statearr_27694_27762[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (20))){
var inst_27617 = (state_27692[(7)]);
var inst_27616 = (state_27692[(8)]);
var inst_27615 = (state_27692[(9)]);
var inst_27614 = (state_27692[(10)]);
var inst_27535 = (state_27692[(11)]);
var inst_27534 = (state_27692[(12)]);
var inst_27585 = (state_27692[(13)]);
var inst_27618 = (state_27692[(14)]);
var inst_27628 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_27629 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27630 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_27631 = (new cljs.core.PersistentVector(null,2,(5),inst_27629,inst_27630,null));
var inst_27632 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_27585,inst_27631);
var inst_27633 = (inst_27534 + inst_27632);
var inst_27634 = [inst_27614,inst_27615,inst_27616,inst_27617,inst_27633];
var inst_27635 = cljs.core.PersistentHashMap.fromArrays(inst_27628,inst_27634);
var inst_27636 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_27585,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_27618,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_27635], 0));
var state_27692__$1 = (function (){var statearr_27695 = state_27692;
(statearr_27695[(15)] = inst_27636);

return statearr_27695;
})();
if(cljs.core.truth_(inst_27535)){
var statearr_27696_27763 = state_27692__$1;
(statearr_27696_27763[(1)] = (23));

} else {
var statearr_27697_27764 = state_27692__$1;
(statearr_27697_27764[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (27))){
var inst_27636 = (state_27692[(15)]);
var state_27692__$1 = state_27692;
var statearr_27698_27765 = state_27692__$1;
(statearr_27698_27765[(2)] = inst_27636);

(statearr_27698_27765[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (1))){
var state_27692__$1 = state_27692;
var statearr_27699_27766 = state_27692__$1;
(statearr_27699_27766[(2)] = null);

(statearr_27699_27766[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (24))){
var inst_27636 = (state_27692[(15)]);
var inst_27639 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_27636);
var inst_27640 = (inst_27639 == null);
var state_27692__$1 = state_27692;
var statearr_27700_27767 = state_27692__$1;
(statearr_27700_27767[(2)] = inst_27640);

(statearr_27700_27767[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (39))){
var inst_27667 = (state_27692[(16)]);
var inst_27675 = (state_27692[(17)]);
var inst_27625 = (state_27692[(18)]);
var inst_27668 = (state_27692[(19)]);
var inst_27666 = (state_27692[(20)]);
var inst_27682 = (state_27692[(2)]);
var inst_27613 = inst_27625;
var inst_27614 = inst_27667;
var inst_27615 = inst_27668;
var inst_27616 = inst_27675;
var inst_27617 = inst_27682;
var inst_27618 = inst_27666;
var state_27692__$1 = (function (){var statearr_27701 = state_27692;
(statearr_27701[(7)] = inst_27617);

(statearr_27701[(21)] = inst_27613);

(statearr_27701[(8)] = inst_27616);

(statearr_27701[(9)] = inst_27615);

(statearr_27701[(10)] = inst_27614);

(statearr_27701[(14)] = inst_27618);

return statearr_27701;
})();
var statearr_27702_27768 = state_27692__$1;
(statearr_27702_27768[(2)] = null);

(statearr_27702_27768[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (4))){
var inst_27497 = (state_27692[(2)]);
var state_27692__$1 = state_27692;
var statearr_27703_27769 = state_27692__$1;
(statearr_27703_27769[(2)] = inst_27497);

(statearr_27703_27769[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (15))){
var inst_27557 = (state_27692[(22)]);
var state_27692__$1 = state_27692;
var statearr_27704_27770 = state_27692__$1;
(statearr_27704_27770[(2)] = inst_27557);

(statearr_27704_27770[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (21))){
var inst_27617 = (state_27692[(7)]);
var inst_27521 = (state_27692[(23)]);
var inst_27624 = (state_27692[(24)]);
var inst_27529 = (state_27692[(25)]);
var inst_27544 = (state_27692[(26)]);
var inst_27613 = (state_27692[(21)]);
var inst_27519 = (state_27692[(27)]);
var inst_27504 = (state_27692[(28)]);
var inst_27525 = (state_27692[(29)]);
var inst_27616 = (state_27692[(8)]);
var inst_27615 = (state_27692[(9)]);
var inst_27625 = (state_27692[(18)]);
var inst_27614 = (state_27692[(10)]);
var inst_27594 = (state_27692[(30)]);
var inst_27535 = (state_27692[(11)]);
var inst_27534 = (state_27692[(12)]);
var inst_27533 = (state_27692[(31)]);
var inst_27585 = (state_27692[(13)]);
var inst_27618 = (state_27692[(14)]);
var inst_27595 = (state_27692[(32)]);
var inst_27538 = (state_27692[(33)]);
var inst_27536 = (state_27692[(34)]);
var inst_27663 = inst_27624.s;
var inst_27664 = fluree.db.flake.sid__GT_cid(inst_27663);
var inst_27665 = (function (){var flakes_bytes = inst_27534;
var t = inst_27504;
var spot = inst_27614;
var add_flakes = inst_27521;
var root_setting_change_QMARK_ = inst_27536;
var ref_QMARK__map = inst_27533;
var r = inst_27625;
var psot = inst_27615;
var seq__27621 = inst_27625;
var vec__27590 = inst_27521;
var add_pred_to_idx_QMARK_ = inst_27544;
var seq__27591 = inst_27595;
var _ = inst_27519;
var first__27592 = inst_27594;
var vec__27620 = inst_27613;
var first__27622 = inst_27624;
var cid = inst_27664;
var ecount = inst_27618;
var pred_ecount = inst_27538;
var G__27589 = inst_27613;
var db_STAR_ = inst_27585;
var schema_change_QMARK_ = inst_27535;
var add_preds = inst_27525;
var opst = inst_27617;
var idx_QMARK__map = inst_27529;
var post = inst_27616;
var f = inst_27624;
return (function (p1__27494_SHARP_){
if(cljs.core.truth_(p1__27494_SHARP_)){
var x__5130__auto__ = p1__27494_SHARP_;
var y__5131__auto__ = f.s;
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
} else {
return f.s;
}
});
})();
var inst_27666 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_27618,inst_27664,inst_27665);
var inst_27667 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_27614,inst_27624);
var inst_27668 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_27615,inst_27624);
var inst_27669 = inst_27624.p;
var inst_27670 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27529,inst_27669);
var state_27692__$1 = (function (){var statearr_27705 = state_27692;
(statearr_27705[(16)] = inst_27667);

(statearr_27705[(19)] = inst_27668);

(statearr_27705[(20)] = inst_27666);

return statearr_27705;
})();
if(cljs.core.truth_(inst_27670)){
var statearr_27706_27771 = state_27692__$1;
(statearr_27706_27771[(1)] = (34));

} else {
var statearr_27707_27772 = state_27692__$1;
(statearr_27707_27772[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (31))){
var inst_27651 = (state_27692[(35)]);
var state_27692__$1 = state_27692;
var statearr_27708_27773 = state_27692__$1;
(statearr_27708_27773[(2)] = inst_27651);

(statearr_27708_27773[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (32))){
var inst_27661 = (state_27692[(2)]);
var state_27692__$1 = state_27692;
var statearr_27709_27774 = state_27692__$1;
(statearr_27709_27774[(2)] = inst_27661);

(statearr_27709_27774[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (33))){
var inst_27651 = (state_27692[(35)]);
var inst_27656 = (state_27692[(2)]);
var inst_27657 = fluree.db.util.async.throw_err(inst_27656);
var inst_27658 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27651,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_27657);
var state_27692__$1 = state_27692;
var statearr_27710_27775 = state_27692__$1;
(statearr_27710_27775[(2)] = inst_27658);

(statearr_27710_27775[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (13))){
var inst_27521 = (state_27692[(23)]);
var inst_27504 = (state_27692[(28)]);
var inst_27534 = (state_27692[(12)]);
var inst_27585 = (state_27692[(13)]);
var inst_27575 = (state_27692[(2)]);
var inst_27576 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27575,new cljs.core.Keyword(null,"t","t",-1397832519),inst_27504);
var inst_27577 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27578 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_27579 = (new cljs.core.PersistentVector(null,2,(5),inst_27577,inst_27578,null));
var inst_27580 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_27576,inst_27579,cljs.core._PLUS_,inst_27534);
var inst_27581 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27582 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_27583 = (new cljs.core.PersistentVector(null,2,(5),inst_27581,inst_27582,null));
var inst_27584 = cljs.core.count(inst_27521);
var inst_27585__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_27580,inst_27583,cljs.core._PLUS_,inst_27584);
var inst_27593 = cljs.core.seq(inst_27521);
var inst_27594 = cljs.core.first(inst_27593);
var inst_27595 = cljs.core.next(inst_27593);
var inst_27596 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27597 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_27598 = (new cljs.core.PersistentVector(null,2,(5),inst_27596,inst_27597,null));
var inst_27599 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_27585__$1,inst_27598);
var inst_27600 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27601 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_27602 = (new cljs.core.PersistentVector(null,2,(5),inst_27600,inst_27601,null));
var inst_27603 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_27585__$1,inst_27602);
var inst_27604 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27605 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_27606 = (new cljs.core.PersistentVector(null,2,(5),inst_27604,inst_27605,null));
var inst_27607 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_27585__$1,inst_27606);
var inst_27608 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27609 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_27610 = (new cljs.core.PersistentVector(null,2,(5),inst_27608,inst_27609,null));
var inst_27611 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_27585__$1,inst_27610);
var inst_27612 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_27613 = inst_27521;
var inst_27614 = inst_27599;
var inst_27615 = inst_27603;
var inst_27616 = inst_27607;
var inst_27617 = inst_27611;
var inst_27618 = inst_27612;
var state_27692__$1 = (function (){var statearr_27711 = state_27692;
(statearr_27711[(7)] = inst_27617);

(statearr_27711[(21)] = inst_27613);

(statearr_27711[(8)] = inst_27616);

(statearr_27711[(9)] = inst_27615);

(statearr_27711[(10)] = inst_27614);

(statearr_27711[(30)] = inst_27594);

(statearr_27711[(13)] = inst_27585__$1);

(statearr_27711[(14)] = inst_27618);

(statearr_27711[(32)] = inst_27595);

return statearr_27711;
})();
var statearr_27712_27776 = state_27692__$1;
(statearr_27712_27776[(2)] = null);

(statearr_27712_27776[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (22))){
var inst_27685 = (state_27692[(2)]);
var state_27692__$1 = state_27692;
var statearr_27713_27777 = state_27692__$1;
(statearr_27713_27777[(2)] = inst_27685);

(statearr_27713_27777[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (36))){
var inst_27624 = (state_27692[(24)]);
var inst_27533 = (state_27692[(31)]);
var inst_27675 = (state_27692[(2)]);
var inst_27676 = inst_27624.p;
var inst_27677 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27533,inst_27676);
var state_27692__$1 = (function (){var statearr_27714 = state_27692;
(statearr_27714[(17)] = inst_27675);

return statearr_27714;
})();
if(cljs.core.truth_(inst_27677)){
var statearr_27715_27778 = state_27692__$1;
(statearr_27715_27778[(1)] = (37));

} else {
var statearr_27716_27779 = state_27692__$1;
(statearr_27716_27779[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (29))){
var inst_27636 = (state_27692[(15)]);
var inst_27646 = (state_27692[(2)]);
var inst_27647 = fluree.db.util.async.throw_err(inst_27646);
var inst_27648 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27636,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_27647);
var state_27692__$1 = state_27692;
var statearr_27717_27780 = state_27692__$1;
(statearr_27717_27780[(2)] = inst_27648);

(statearr_27717_27780[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (6))){
var inst_27504 = (state_27692[(28)]);
var inst_27509 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_27510 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_27511 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27509)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27510)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27504),"."].join('');
var inst_27512 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27513 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27514 = cljs.core.PersistentHashMap.fromArrays(inst_27512,inst_27513);
var inst_27515 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27511,inst_27514);
var inst_27516 = (function(){throw inst_27515})();
var state_27692__$1 = state_27692;
var statearr_27718_27781 = state_27692__$1;
(statearr_27718_27781[(2)] = inst_27516);

(statearr_27718_27781[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (28))){
var inst_27536 = (state_27692[(34)]);
var inst_27651 = (state_27692[(2)]);
var state_27692__$1 = (function (){var statearr_27719 = state_27692;
(statearr_27719[(35)] = inst_27651);

return statearr_27719;
})();
if(cljs.core.truth_(inst_27536)){
var statearr_27720_27782 = state_27692__$1;
(statearr_27720_27782[(1)] = (30));

} else {
var statearr_27721_27783 = state_27692__$1;
(statearr_27721_27783[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (25))){
var inst_27642 = (state_27692[(2)]);
var state_27692__$1 = state_27692;
if(cljs.core.truth_(inst_27642)){
var statearr_27722_27784 = state_27692__$1;
(statearr_27722_27784[(1)] = (26));

} else {
var statearr_27723_27785 = state_27692__$1;
(statearr_27723_27785[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (34))){
var inst_27624 = (state_27692[(24)]);
var inst_27616 = (state_27692[(8)]);
var inst_27672 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_27616,inst_27624);
var state_27692__$1 = state_27692;
var statearr_27724_27786 = state_27692__$1;
(statearr_27724_27786[(2)] = inst_27672);

(statearr_27724_27786[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (17))){
var inst_27564 = (state_27692[(36)]);
var inst_27568 = (state_27692[(2)]);
var inst_27569 = fluree.db.util.async.throw_err(inst_27568);
var inst_27556 = inst_27564;
var inst_27557 = inst_27569;
var state_27692__$1 = (function (){var statearr_27725 = state_27692;
(statearr_27725[(37)] = inst_27556);

(statearr_27725[(22)] = inst_27557);

return statearr_27725;
})();
var statearr_27726_27787 = state_27692__$1;
(statearr_27726_27787[(2)] = null);

(statearr_27726_27787[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (3))){
var inst_27690 = (state_27692[(2)]);
var state_27692__$1 = state_27692;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27692__$1,inst_27690);
} else {
if((state_val_27693 === (12))){
var inst_27563 = (state_27692[(38)]);
var inst_27556 = (state_27692[(37)]);
var inst_27562 = cljs.core.seq(inst_27556);
var inst_27563__$1 = cljs.core.first(inst_27562);
var inst_27564 = cljs.core.next(inst_27562);
var state_27692__$1 = (function (){var statearr_27727 = state_27692;
(statearr_27727[(38)] = inst_27563__$1);

(statearr_27727[(36)] = inst_27564);

return statearr_27727;
})();
if(cljs.core.truth_(inst_27563__$1)){
var statearr_27728_27788 = state_27692__$1;
(statearr_27728_27788[(1)] = (14));

} else {
var statearr_27729_27789 = state_27692__$1;
(statearr_27729_27789[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (2))){
var inst_27504 = (state_27692[(28)]);
var _ = (function (){var statearr_27730 = state_27692;
(statearr_27730[(4)] = cljs.core.cons((5),(state_27692[(4)])));

return statearr_27730;
})();
var inst_27503 = cljs.core.first(flakes);
var inst_27504__$1 = inst_27503.t;
var inst_27505 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_27506 = (inst_27505 - (1));
var inst_27507 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_27504__$1,inst_27506);
var state_27692__$1 = (function (){var statearr_27731 = state_27692;
(statearr_27731[(28)] = inst_27504__$1);

return statearr_27731;
})();
if(inst_27507){
var statearr_27732_27790 = state_27692__$1;
(statearr_27732_27790[(1)] = (6));

} else {
var statearr_27733_27791 = state_27692__$1;
(statearr_27733_27791[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (23))){
var inst_27535 = (state_27692[(11)]);
var state_27692__$1 = state_27692;
var statearr_27734_27792 = state_27692__$1;
(statearr_27734_27792[(2)] = inst_27535);

(statearr_27734_27792[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (35))){
var inst_27616 = (state_27692[(8)]);
var state_27692__$1 = state_27692;
var statearr_27735_27793 = state_27692__$1;
(statearr_27735_27793[(2)] = inst_27616);

(statearr_27735_27793[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (19))){
var inst_27687 = (state_27692[(2)]);
var _ = (function (){var statearr_27736 = state_27692;
(statearr_27736[(4)] = cljs.core.rest((state_27692[(4)])));

return statearr_27736;
})();
var state_27692__$1 = state_27692;
var statearr_27737_27794 = state_27692__$1;
(statearr_27737_27794[(2)] = inst_27687);

(statearr_27737_27794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (11))){
var inst_27544 = (state_27692[(26)]);
var inst_27544__$1 = (state_27692[(2)]);
var inst_27552 = cljs.core.seq(inst_27544__$1);
var inst_27553 = cljs.core.first(inst_27552);
var inst_27554 = cljs.core.next(inst_27552);
var inst_27555 = db;
var inst_27556 = inst_27544__$1;
var inst_27557 = inst_27555;
var state_27692__$1 = (function (){var statearr_27739 = state_27692;
(statearr_27739[(26)] = inst_27544__$1);

(statearr_27739[(37)] = inst_27556);

(statearr_27739[(39)] = inst_27554);

(statearr_27739[(22)] = inst_27557);

(statearr_27739[(40)] = inst_27553);

return statearr_27739;
})();
var statearr_27740_27795 = state_27692__$1;
(statearr_27740_27795[(2)] = null);

(statearr_27740_27795[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (9))){
var inst_27521 = (state_27692[(23)]);
var inst_27538 = (state_27692[(33)]);
var inst_27540 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_27521,inst_27538);
var state_27692__$1 = state_27692;
var statearr_27741_27796 = state_27692__$1;
(statearr_27741_27796[(2)] = inst_27540);

(statearr_27741_27796[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (5))){
var _ = (function (){var statearr_27742 = state_27692;
(statearr_27742[(4)] = cljs.core.rest((state_27692[(4)])));

return statearr_27742;
})();
var state_27692__$1 = state_27692;
var ex27738 = (state_27692__$1[(2)]);
var statearr_27743_27797 = state_27692__$1;
(statearr_27743_27797[(5)] = ex27738);


if((ex27738 instanceof Error)){
var statearr_27744_27798 = state_27692__$1;
(statearr_27744_27798[(1)] = (4));

(statearr_27744_27798[(5)] = null);

} else {
throw ex27738;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (14))){
var inst_27563 = (state_27692[(38)]);
var inst_27557 = (state_27692[(22)]);
var inst_27566 = fluree.db.graphdb.add_predicate_to_idx(inst_27557,inst_27563,opts);
var state_27692__$1 = state_27692;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27692__$1,(17),inst_27566);
} else {
if((state_val_27693 === (26))){
var inst_27636 = (state_27692[(15)]);
var inst_27644 = fluree.db.query.schema.schema_map(inst_27636);
var state_27692__$1 = state_27692;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27692__$1,(29),inst_27644);
} else {
if((state_val_27693 === (16))){
var inst_27573 = (state_27692[(2)]);
var state_27692__$1 = state_27692;
var statearr_27745_27799 = state_27692__$1;
(statearr_27745_27799[(2)] = inst_27573);

(statearr_27745_27799[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (38))){
var inst_27617 = (state_27692[(7)]);
var state_27692__$1 = state_27692;
var statearr_27746_27800 = state_27692__$1;
(statearr_27746_27800[(2)] = inst_27617);

(statearr_27746_27800[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (30))){
var inst_27651 = (state_27692[(35)]);
var inst_27654 = fluree.db.query.schema.setting_map(inst_27651);
var state_27692__$1 = state_27692;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27692__$1,(33),inst_27654);
} else {
if((state_val_27693 === (10))){
var inst_27542 = cljs.core.PersistentVector.EMPTY;
var state_27692__$1 = state_27692;
var statearr_27747_27801 = state_27692__$1;
(statearr_27747_27801[(2)] = inst_27542);

(statearr_27747_27801[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (18))){
var inst_27624 = (state_27692[(24)]);
var inst_27613 = (state_27692[(21)]);
var inst_27623 = cljs.core.seq(inst_27613);
var inst_27624__$1 = cljs.core.first(inst_27623);
var inst_27625 = cljs.core.next(inst_27623);
var inst_27626 = cljs.core.not(inst_27624__$1);
var state_27692__$1 = (function (){var statearr_27748 = state_27692;
(statearr_27748[(24)] = inst_27624__$1);

(statearr_27748[(18)] = inst_27625);

return statearr_27748;
})();
if(inst_27626){
var statearr_27749_27802 = state_27692__$1;
(statearr_27749_27802[(1)] = (20));

} else {
var statearr_27750_27803 = state_27692__$1;
(statearr_27750_27803[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (37))){
var inst_27617 = (state_27692[(7)]);
var inst_27624 = (state_27692[(24)]);
var inst_27679 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_27617,inst_27624);
var state_27692__$1 = state_27692;
var statearr_27751_27804 = state_27692__$1;
(statearr_27751_27804[(2)] = inst_27679);

(statearr_27751_27804[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27693 === (8))){
var inst_27521 = (state_27692[(23)]);
var inst_27529 = (state_27692[(25)]);
var inst_27519 = (state_27692[(27)]);
var inst_27504 = (state_27692[(28)]);
var inst_27525 = (state_27692[(29)]);
var inst_27535 = (state_27692[(11)]);
var inst_27519__$1 = (state_27692[(2)]);
var inst_27520 = (function (){var t = inst_27504;
var _ = inst_27519__$1;
return (function (p1__27492_SHARP_){
return cljs.core.not((function (){var G__27752 = p1__27492_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__27752) : fluree.db.graphdb.exclude_predicates.call(null,G__27752));
})());
});
})();
var inst_27521__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_27520,flakes);
var inst_27522 = cljs.core.PersistentHashSet.EMPTY;
var inst_27523 = (function (){var t = inst_27504;
var _ = inst_27519__$1;
var add_flakes = inst_27521__$1;
return (function (p1__27493_SHARP_){
return p1__27493_SHARP_.p;
});
})();
var inst_27524 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_27523,inst_27521__$1);
var inst_27525__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_27522,inst_27524);
var inst_27526 = cljs.core.PersistentHashMap.EMPTY;
var inst_27527 = (function (){var t = inst_27504;
var _ = inst_27519__$1;
var add_flakes = inst_27521__$1;
var add_preds = inst_27525__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_27528 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_27527,inst_27525__$1);
var inst_27529__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_27526,inst_27528);
var inst_27530 = cljs.core.PersistentHashMap.EMPTY;
var inst_27531 = (function (){var t = inst_27504;
var _ = inst_27519__$1;
var add_flakes = inst_27521__$1;
var add_preds = inst_27525__$1;
var idx_QMARK__map = inst_27529__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_27532 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_27531,inst_27525__$1);
var inst_27533 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_27530,inst_27532);
var inst_27534 = fluree.db.flake.size_bytes(inst_27521__$1);
var inst_27535__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_27521__$1);
var inst_27536 = fluree.db.util.schema.setting_change_QMARK_(inst_27521__$1);
var inst_27537 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_27538 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27537,(0));
var state_27692__$1 = (function (){var statearr_27753 = state_27692;
(statearr_27753[(23)] = inst_27521__$1);

(statearr_27753[(25)] = inst_27529__$1);

(statearr_27753[(27)] = inst_27519__$1);

(statearr_27753[(29)] = inst_27525__$1);

(statearr_27753[(11)] = inst_27535__$1);

(statearr_27753[(12)] = inst_27534);

(statearr_27753[(31)] = inst_27533);

(statearr_27753[(33)] = inst_27538);

(statearr_27753[(34)] = inst_27536);

return statearr_27753;
})();
if(cljs.core.truth_(inst_27535__$1)){
var statearr_27754_27805 = state_27692__$1;
(statearr_27754_27805[(1)] = (9));

} else {
var statearr_27755_27806 = state_27692__$1;
(statearr_27755_27806[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2749__auto__ = null;
var fluree$db$graphdb$state_machine__2749__auto____0 = (function (){
var statearr_27756 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27756[(0)] = fluree$db$graphdb$state_machine__2749__auto__);

(statearr_27756[(1)] = (1));

return statearr_27756;
});
var fluree$db$graphdb$state_machine__2749__auto____1 = (function (state_27692){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_27692);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e27757){var ex__2752__auto__ = e27757;
var statearr_27758_27807 = state_27692;
(statearr_27758_27807[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_27692[(4)]))){
var statearr_27759_27808 = state_27692;
(statearr_27759_27808[(1)] = cljs.core.first((state_27692[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27809 = state_27692;
state_27692 = G__27809;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2749__auto__ = function(state_27692){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2749__auto____1.call(this,state_27692);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2749__auto____0;
fluree$db$graphdb$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2749__auto____1;
return fluree$db$graphdb$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_27760 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_27760[(6)] = c__2771__auto__);

return statearr_27760;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__27811 = arguments.length;
switch (G__27811) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2771__auto___27958 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_27907){
var state_val_27908 = (state_27907[(1)]);
if((state_val_27908 === (7))){
var state_27907__$1 = state_27907;
var statearr_27909_27959 = state_27907__$1;
(statearr_27909_27959[(2)] = null);

(statearr_27909_27959[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27908 === (20))){
var inst_27856 = (state_27907[(7)]);
var inst_27857 = (state_27907[(8)]);
var inst_27855 = (state_27907[(9)]);
var inst_27876 = (inst_27855 + (1));
var inst_27877 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27857,new cljs.core.Keyword(null,"t","t",-1397832519),inst_27876);
var inst_27878 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_27877,inst_27856,opts);
var state_27907__$1 = state_27907;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27907__$1,(23),inst_27878);
} else {
if((state_val_27908 === (1))){
var state_27907__$1 = state_27907;
var statearr_27910_27960 = state_27907__$1;
(statearr_27910_27960[(2)] = null);

(statearr_27910_27960[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27908 === (24))){
var inst_27881 = (state_27907[(10)]);
var inst_27884 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27881,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_27907__$1 = state_27907;
var statearr_27911_27961 = state_27907__$1;
(statearr_27911_27961[(2)] = inst_27884);

(statearr_27911_27961[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27908 === (4))){
var inst_27812 = (state_27907[(2)]);
var inst_27813 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_27812);
var state_27907__$1 = state_27907;
var statearr_27912_27962 = state_27907__$1;
(statearr_27912_27962[(2)] = inst_27813);

(statearr_27912_27962[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27908 === (15))){
var inst_27863 = (state_27907[(11)]);
var state_27907__$1 = state_27907;
var statearr_27913_27963 = state_27907__$1;
(statearr_27913_27963[(2)] = inst_27863);

(statearr_27913_27963[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27908 === (21))){
var state_27907__$1 = state_27907;
var statearr_27914_27964 = state_27907__$1;
(statearr_27914_27964[(2)] = null);

(statearr_27914_27964[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27908 === (13))){
var inst_27899 = (state_27907[(2)]);
var inst_27900 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_27899);
var state_27907__$1 = state_27907;
var statearr_27915_27965 = state_27907__$1;
(statearr_27915_27965[(2)] = inst_27900);

(statearr_27915_27965[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27908 === (22))){
var inst_27895 = (state_27907[(2)]);
var state_27907__$1 = state_27907;
var statearr_27916_27966 = state_27907__$1;
(statearr_27916_27966[(2)] = inst_27895);

(statearr_27916_27966[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27908 === (6))){
var inst_27823 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_27824 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_27825 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27823)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27824)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_27826 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27827 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27828 = cljs.core.PersistentHashMap.fromArrays(inst_27826,inst_27827);
var inst_27829 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27825,inst_27828);
var inst_27830 = (function(){throw inst_27829})();
var state_27907__$1 = state_27907;
var statearr_27919_27967 = state_27907__$1;
(statearr_27919_27967[(2)] = inst_27830);

(statearr_27919_27967[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27908 === (25))){
var inst_27881 = (state_27907[(10)]);
var inst_27864 = (state_27907[(12)]);
var inst_27863 = (state_27907[(11)]);
var inst_27886 = inst_27863.t;
var inst_27887 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27888 = [inst_27863];
var inst_27889 = (new cljs.core.PersistentVector(null,1,(5),inst_27887,inst_27888,null));
var inst_27854 = inst_27864;
var inst_27855 = inst_27886;
var inst_27856 = inst_27889;
var inst_27857 = inst_27881;
var state_27907__$1 = (function (){var statearr_27920 = state_27907;
(statearr_27920[(7)] = inst_27856);

(statearr_27920[(8)] = inst_27857);

(statearr_27920[(13)] = inst_27854);

(statearr_27920[(9)] = inst_27855);

return statearr_27920;
})();
var statearr_27921_27968 = state_27907__$1;
(statearr_27921_27968[(2)] = null);

(statearr_27921_27968[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27908 === (17))){
var inst_27864 = (state_27907[(12)]);
var inst_27856 = (state_27907[(7)]);
var inst_27857 = (state_27907[(8)]);
var inst_27863 = (state_27907[(11)]);
var inst_27855 = (state_27907[(9)]);
var inst_27872 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_27856,inst_27863);
var tmp27917 = inst_27857;
var tmp27918 = inst_27855;
var inst_27854 = inst_27864;
var inst_27855__$1 = tmp27918;
var inst_27856__$1 = inst_27872;
var inst_27857__$1 = tmp27917;
var state_27907__$1 = (function (){var statearr_27922 = state_27907;
(statearr_27922[(7)] = inst_27856__$1);

(statearr_27922[(8)] = inst_27857__$1);

(statearr_27922[(13)] = inst_27854);

(statearr_27922[(9)] = inst_27855__$1);

return statearr_27922;
})();
var statearr_27923_27969 = state_27907__$1;
(statearr_27923_27969[(2)] = null);

(statearr_27923_27969[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27908 === (3))){
var inst_27905 = (state_27907[(2)]);
var state_27907__$1 = state_27907;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27907__$1,inst_27905);
} else {
if((state_val_27908 === (12))){
var inst_27863 = (state_27907[(11)]);
var inst_27854 = (state_27907[(13)]);
var inst_27862 = cljs.core.seq(inst_27854);
var inst_27863__$1 = cljs.core.first(inst_27862);
var inst_27864 = cljs.core.next(inst_27862);
var state_27907__$1 = (function (){var statearr_27924 = state_27907;
(statearr_27924[(12)] = inst_27864);

(statearr_27924[(11)] = inst_27863__$1);

return statearr_27924;
})();
if(cljs.core.truth_(inst_27863__$1)){
var statearr_27925_27970 = state_27907__$1;
(statearr_27925_27970[(1)] = (14));

} else {
var statearr_27926_27971 = state_27907__$1;
(statearr_27926_27971[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27908 === (2))){
var _ = (function (){var statearr_27927 = state_27907;
(statearr_27927[(4)] = cljs.core.cons((5),(state_27907[(4)])));

return statearr_27927;
})();
var inst_27819 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_27820 = (inst_27819 + (1));
var inst_27821 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_27820);
var state_27907__$1 = state_27907;
if(inst_27821){
var statearr_27928_27972 = state_27907__$1;
(statearr_27928_27972[(1)] = (6));

} else {
var statearr_27929_27973 = state_27907__$1;
(statearr_27929_27973[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27908 === (23))){
var inst_27863 = (state_27907[(11)]);
var inst_27880 = (state_27907[(2)]);
var inst_27881 = fluree.db.util.async.throw_err(inst_27880);
var inst_27882 = (inst_27863 == null);
var state_27907__$1 = (function (){var statearr_27930 = state_27907;
(statearr_27930[(10)] = inst_27881);

return statearr_27930;
})();
if(cljs.core.truth_(inst_27882)){
var statearr_27931_27974 = state_27907__$1;
(statearr_27931_27974[(1)] = (24));

} else {
var statearr_27932_27975 = state_27907__$1;
(statearr_27932_27975[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27908 === (19))){
var inst_27897 = (state_27907[(2)]);
var state_27907__$1 = state_27907;
var statearr_27933_27976 = state_27907__$1;
(statearr_27933_27976[(2)] = inst_27897);

(statearr_27933_27976[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27908 === (11))){
var inst_27902 = (state_27907[(2)]);
var _ = (function (){var statearr_27935 = state_27907;
(statearr_27935[(4)] = cljs.core.rest((state_27907[(4)])));

return statearr_27935;
})();
var state_27907__$1 = state_27907;
var statearr_27936_27977 = state_27907__$1;
(statearr_27936_27977[(2)] = inst_27902);

(statearr_27936_27977[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27908 === (9))){
var inst_27836 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_27837 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_27836);
var state_27907__$1 = state_27907;
var statearr_27937_27978 = state_27907__$1;
(statearr_27937_27978[(2)] = inst_27837);

(statearr_27937_27978[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27908 === (5))){
var _ = (function (){var statearr_27938 = state_27907;
(statearr_27938[(4)] = cljs.core.rest((state_27907[(4)])));

return statearr_27938;
})();
var state_27907__$1 = state_27907;
var ex27934 = (state_27907__$1[(2)]);
var statearr_27939_27979 = state_27907__$1;
(statearr_27939_27979[(5)] = ex27934);


var statearr_27940_27980 = state_27907__$1;
(statearr_27940_27980[(1)] = (4));

(statearr_27940_27980[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27908 === (14))){
var inst_27863 = (state_27907[(11)]);
var inst_27855 = (state_27907[(9)]);
var inst_27866 = inst_27863.t;
var inst_27867 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_27855,inst_27866);
var state_27907__$1 = state_27907;
var statearr_27941_27981 = state_27907__$1;
(statearr_27941_27981[(2)] = inst_27867);

(statearr_27941_27981[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27908 === (26))){
var inst_27892 = (state_27907[(2)]);
var state_27907__$1 = state_27907;
var statearr_27942_27982 = state_27907__$1;
(statearr_27942_27982[(2)] = inst_27892);

(statearr_27942_27982[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27908 === (16))){
var inst_27870 = (state_27907[(2)]);
var state_27907__$1 = state_27907;
if(cljs.core.truth_(inst_27870)){
var statearr_27943_27983 = state_27907__$1;
(statearr_27943_27983[(1)] = (17));

} else {
var statearr_27944_27984 = state_27907__$1;
(statearr_27944_27984[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27908 === (10))){
var inst_27839 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_27840 = cljs.core.first(inst_27839);
var inst_27848 = cljs.core.seq(inst_27839);
var inst_27849 = cljs.core.first(inst_27848);
var inst_27850 = cljs.core.next(inst_27848);
var inst_27851 = inst_27840.t;
var inst_27852 = cljs.core.PersistentVector.EMPTY;
var inst_27853 = db;
var inst_27854 = inst_27839;
var inst_27855 = inst_27851;
var inst_27856 = inst_27852;
var inst_27857 = inst_27853;
var state_27907__$1 = (function (){var statearr_27945 = state_27907;
(statearr_27945[(14)] = inst_27849);

(statearr_27945[(7)] = inst_27856);

(statearr_27945[(8)] = inst_27857);

(statearr_27945[(15)] = inst_27850);

(statearr_27945[(13)] = inst_27854);

(statearr_27945[(9)] = inst_27855);

return statearr_27945;
})();
var statearr_27946_27985 = state_27907__$1;
(statearr_27946_27985[(2)] = null);

(statearr_27946_27985[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27908 === (18))){
var state_27907__$1 = state_27907;
var statearr_27947_27986 = state_27907__$1;
(statearr_27947_27986[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27908 === (8))){
var inst_27833 = (state_27907[(2)]);
var inst_27834 = cljs.core.empty_QMARK_(flakes);
var state_27907__$1 = (function (){var statearr_27949 = state_27907;
(statearr_27949[(16)] = inst_27833);

return statearr_27949;
})();
if(inst_27834){
var statearr_27950_27987 = state_27907__$1;
(statearr_27950_27987[(1)] = (9));

} else {
var statearr_27951_27988 = state_27907__$1;
(statearr_27951_27988[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2749__auto__ = null;
var fluree$db$graphdb$state_machine__2749__auto____0 = (function (){
var statearr_27952 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27952[(0)] = fluree$db$graphdb$state_machine__2749__auto__);

(statearr_27952[(1)] = (1));

return statearr_27952;
});
var fluree$db$graphdb$state_machine__2749__auto____1 = (function (state_27907){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_27907);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e27953){var ex__2752__auto__ = e27953;
var statearr_27954_27989 = state_27907;
(statearr_27954_27989[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_27907[(4)]))){
var statearr_27955_27990 = state_27907;
(statearr_27955_27990[(1)] = cljs.core.first((state_27907[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27991 = state_27907;
state_27907 = G__27991;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2749__auto__ = function(state_27907){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2749__auto____1.call(this,state_27907);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2749__auto____0;
fluree$db$graphdb$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2749__auto____1;
return fluree$db$graphdb$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_27956 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_27956[(6)] = c__2771__auto___27958);

return statearr_27956;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_28047){
var state_val_28048 = (state_28047[(1)]);
if((state_val_28048 === (7))){
var state_28047__$1 = state_28047;
var statearr_28049_28076 = state_28047__$1;
(statearr_28049_28076[(2)] = tt_id);

(statearr_28049_28076[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28048 === (1))){
var state_28047__$1 = state_28047;
var statearr_28050_28077 = state_28047__$1;
(statearr_28050_28077[(2)] = null);

(statearr_28050_28077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28048 === (4))){
var inst_27992 = (state_28047[(2)]);
var state_28047__$1 = state_28047;
var statearr_28051_28078 = state_28047__$1;
(statearr_28051_28078[(2)] = inst_27992);

(statearr_28051_28078[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28048 === (13))){
var inst_28040 = (state_28047[(2)]);
var state_28047__$1 = state_28047;
var statearr_28052_28079 = state_28047__$1;
(statearr_28052_28079[(2)] = inst_28040);

(statearr_28052_28079[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28048 === (6))){
var inst_28000 = fluree.db.util.core.random_uuid();
var state_28047__$1 = state_28047;
var statearr_28053_28080 = state_28047__$1;
(statearr_28053_28080[(2)] = inst_28000);

(statearr_28053_28080[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28048 === (3))){
var inst_28045 = (state_28047[(2)]);
var state_28047__$1 = state_28047;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28047__$1,inst_28045);
} else {
if((state_val_28048 === (12))){
var inst_28023 = (state_28047[(7)]);
var state_28047__$1 = state_28047;
var statearr_28054_28081 = state_28047__$1;
(statearr_28054_28081[(2)] = inst_28023);

(statearr_28054_28081[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28048 === (2))){
var _ = (function (){var statearr_28055 = state_28047;
(statearr_28055[(4)] = cljs.core.cons((5),(state_28047[(4)])));

return statearr_28055;
})();
var inst_27998 = (tt_id == null);
var state_28047__$1 = state_28047;
if(cljs.core.truth_(inst_27998)){
var statearr_28056_28082 = state_28047__$1;
(statearr_28056_28082[(1)] = (6));

} else {
var statearr_28057_28083 = state_28047__$1;
(statearr_28057_28083[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28048 === (11))){
var inst_28023 = (state_28047[(7)]);
var inst_28030 = (state_28047[(8)]);
var inst_28033 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_28023,inst_28030);
var state_28047__$1 = state_28047;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28047__$1,(14),inst_28033);
} else {
if((state_val_28048 === (9))){
var inst_28024 = (state_28047[(9)]);
var inst_28030 = (state_28047[(8)]);
var inst_28029 = cljs.core.seq(inst_28024);
var inst_28030__$1 = cljs.core.first(inst_28029);
var inst_28031 = cljs.core.next(inst_28029);
var state_28047__$1 = (function (){var statearr_28059 = state_28047;
(statearr_28059[(8)] = inst_28030__$1);

(statearr_28059[(10)] = inst_28031);

return statearr_28059;
})();
if(cljs.core.truth_(inst_28030__$1)){
var statearr_28060_28084 = state_28047__$1;
(statearr_28060_28084[(1)] = (11));

} else {
var statearr_28061_28085 = state_28047__$1;
(statearr_28061_28085[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28048 === (5))){
var _ = (function (){var statearr_28062 = state_28047;
(statearr_28062[(4)] = cljs.core.rest((state_28047[(4)])));

return statearr_28062;
})();
var state_28047__$1 = state_28047;
var ex28058 = (state_28047__$1[(2)]);
var statearr_28063_28086 = state_28047__$1;
(statearr_28063_28086[(5)] = ex28058);


if((ex28058 instanceof Error)){
var statearr_28064_28087 = state_28047__$1;
(statearr_28064_28087[(1)] = (4));

(statearr_28064_28087[(5)] = null);

} else {
throw ex28058;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28048 === (14))){
var inst_28031 = (state_28047[(10)]);
var inst_28035 = (state_28047[(2)]);
var inst_28036 = fluree.db.util.async.throw_err(inst_28035);
var inst_28023 = inst_28036;
var inst_28024 = inst_28031;
var state_28047__$1 = (function (){var statearr_28065 = state_28047;
(statearr_28065[(9)] = inst_28024);

(statearr_28065[(7)] = inst_28023);

return statearr_28065;
})();
var statearr_28066_28088 = state_28047__$1;
(statearr_28066_28088[(2)] = null);

(statearr_28066_28088[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28048 === (10))){
var inst_28042 = (state_28047[(2)]);
var _ = (function (){var statearr_28067 = state_28047;
(statearr_28067[(4)] = cljs.core.rest((state_28047[(4)])));

return statearr_28067;
})();
var state_28047__$1 = state_28047;
var statearr_28068_28089 = state_28047__$1;
(statearr_28068_28089[(2)] = inst_28042);

(statearr_28068_28089[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28048 === (8))){
var inst_28003 = (state_28047[(2)]);
var inst_28004 = (function (){var tt_id_SINGLEQUOTE_ = inst_28003;
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id_SINGLEQUOTE_));
});
})();
var inst_28005 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_28003);
var inst_28006 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28007 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_28008 = (new cljs.core.PersistentVector(null,4,(5),inst_28006,inst_28007,null));
var inst_28009 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_28004,inst_28005,inst_28008);
var inst_28010 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),flakes);
var inst_28011 = cljs.core.reverse(inst_28010);
var inst_28012 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),inst_28011);
var inst_28020 = cljs.core.seq(inst_28012);
var inst_28021 = cljs.core.first(inst_28020);
var inst_28022 = cljs.core.next(inst_28020);
var inst_28023 = inst_28009;
var inst_28024 = inst_28012;
var state_28047__$1 = (function (){var statearr_28069 = state_28047;
(statearr_28069[(9)] = inst_28024);

(statearr_28069[(11)] = inst_28022);

(statearr_28069[(7)] = inst_28023);

(statearr_28069[(12)] = inst_28021);

return statearr_28069;
})();
var statearr_28070_28090 = state_28047__$1;
(statearr_28070_28090[(2)] = null);

(statearr_28070_28090[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2749__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2749__auto____0 = (function (){
var statearr_28071 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28071[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2749__auto__);

(statearr_28071[(1)] = (1));

return statearr_28071;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2749__auto____1 = (function (state_28047){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_28047);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e28072){var ex__2752__auto__ = e28072;
var statearr_28073_28091 = state_28047;
(statearr_28073_28091[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_28047[(4)]))){
var statearr_28074_28092 = state_28047;
(statearr_28074_28092[(1)] = cljs.core.first((state_28047[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28093 = state_28047;
state_28047 = G__28093;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2749__auto__ = function(state_28047){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2749__auto____1.call(this,state_28047);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2749__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2749__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_28075 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_28075[(6)] = c__2771__auto__);

return statearr_28075;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2771__auto___28280 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_28211){
var state_val_28212 = (state_28211[(1)]);
if((state_val_28212 === (7))){
var inst_28121 = (state_28211[(7)]);
var inst_28121__$1 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_28211__$1 = (function (){var statearr_28213 = state_28211;
(statearr_28213[(7)] = inst_28121__$1);

return statearr_28213;
})();
if(inst_28121__$1){
var statearr_28214_28281 = state_28211__$1;
(statearr_28214_28281[(1)] = (13));

} else {
var statearr_28215_28282 = state_28211__$1;
(statearr_28215_28282[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (20))){
var state_28211__$1 = state_28211;
var statearr_28216_28283 = state_28211__$1;
(statearr_28216_28283[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (27))){
var inst_28157 = (state_28211[(8)]);
var inst_28161 = inst_28157.s;
var state_28211__$1 = state_28211;
var statearr_28218_28284 = state_28211__$1;
(statearr_28218_28284[(2)] = inst_28161);

(statearr_28218_28284[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (1))){
var state_28211__$1 = state_28211;
var statearr_28219_28285 = state_28211__$1;
(statearr_28219_28285[(2)] = null);

(statearr_28219_28285[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (24))){
var inst_28151 = (state_28211[(9)]);
var inst_28155 = cljs.core.first(inst_28151);
var state_28211__$1 = state_28211;
var statearr_28220_28286 = state_28211__$1;
(statearr_28220_28286[(2)] = inst_28155);

(statearr_28220_28286[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (39))){
var state_28211__$1 = state_28211;
var statearr_28221_28287 = state_28211__$1;
(statearr_28221_28287[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (4))){
var inst_28094 = (state_28211[(2)]);
var inst_28095 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_28096 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28097 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_28098 = cljs.core.PersistentHashMap.fromArrays(inst_28096,inst_28097);
var inst_28099 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_28095,inst_28098,inst_28094);
var inst_28100 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_28099);
var state_28211__$1 = state_28211;
var statearr_28223_28288 = state_28211__$1;
(statearr_28223_28288[(2)] = inst_28100);

(statearr_28223_28288[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (15))){
var inst_28128 = (state_28211[(2)]);
var state_28211__$1 = state_28211;
if(cljs.core.truth_(inst_28128)){
var statearr_28224_28289 = state_28211__$1;
(statearr_28224_28289[(1)] = (16));

} else {
var statearr_28225_28290 = state_28211__$1;
(statearr_28225_28290[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (21))){
var inst_28177 = (state_28211[(2)]);
var state_28211__$1 = state_28211;
var statearr_28226_28291 = state_28211__$1;
(statearr_28226_28291[(2)] = inst_28177);

(statearr_28226_28291[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (31))){
var inst_28175 = (state_28211[(2)]);
var state_28211__$1 = state_28211;
var statearr_28227_28292 = state_28211__$1;
(statearr_28227_28292[(2)] = inst_28175);

(statearr_28227_28292[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (32))){
var inst_28181 = (state_28211[(10)]);
var inst_28183 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_28181);
var state_28211__$1 = state_28211;
var statearr_28228_28293 = state_28211__$1;
(statearr_28228_28293[(2)] = inst_28183);

(statearr_28228_28293[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (40))){
var inst_28204 = (state_28211[(2)]);
var state_28211__$1 = state_28211;
var statearr_28229_28294 = state_28211__$1;
(statearr_28229_28294[(2)] = inst_28204);

(statearr_28229_28294[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (33))){
var inst_28185 = (state_28211[(11)]);
var inst_28181 = (state_28211[(10)]);
var inst_28185__$1 = (inst_28181 == null);
var state_28211__$1 = (function (){var statearr_28230 = state_28211;
(statearr_28230[(11)] = inst_28185__$1);

return statearr_28230;
})();
if(cljs.core.truth_(inst_28185__$1)){
var statearr_28231_28295 = state_28211__$1;
(statearr_28231_28295[(1)] = (35));

} else {
var statearr_28232_28296 = state_28211__$1;
(statearr_28232_28296[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (13))){
var inst_28123 = cljs.core.first(ident);
var inst_28124 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_28123);
var inst_28125 = (inst_28124 == null);
var state_28211__$1 = state_28211;
var statearr_28233_28297 = state_28211__$1;
(statearr_28233_28297[(2)] = inst_28125);

(statearr_28233_28297[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (22))){
var inst_28151 = (state_28211[(9)]);
var inst_28150 = (state_28211[(2)]);
var inst_28151__$1 = fluree.db.util.async.throw_err(inst_28150);
var inst_28152 = (inst_28151__$1 == null);
var state_28211__$1 = (function (){var statearr_28234 = state_28211;
(statearr_28234[(9)] = inst_28151__$1);

return statearr_28234;
})();
if(cljs.core.truth_(inst_28152)){
var statearr_28235_28298 = state_28211__$1;
(statearr_28235_28298[(1)] = (23));

} else {
var statearr_28236_28299 = state_28211__$1;
(statearr_28236_28299[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (36))){
var inst_28185 = (state_28211[(11)]);
var state_28211__$1 = state_28211;
var statearr_28237_28300 = state_28211__$1;
(statearr_28237_28300[(2)] = inst_28185);

(statearr_28237_28300[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (41))){
var inst_28199 = cljs.core.async.close_BANG_(return_chan);
var state_28211__$1 = state_28211;
var statearr_28238_28301 = state_28211__$1;
(statearr_28238_28301[(2)] = inst_28199);

(statearr_28238_28301[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (43))){
var inst_28202 = (state_28211[(2)]);
var state_28211__$1 = state_28211;
var statearr_28239_28302 = state_28211__$1;
(statearr_28239_28302[(2)] = inst_28202);

(statearr_28239_28302[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (29))){
var inst_28166 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_28167 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_28166].join('');
var inst_28168 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28169 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_28170 = cljs.core.PersistentHashMap.fromArrays(inst_28168,inst_28169);
var inst_28171 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28167,inst_28170);
var inst_28172 = (function(){throw inst_28171})();
var state_28211__$1 = state_28211;
var statearr_28240_28303 = state_28211__$1;
(statearr_28240_28303[(2)] = inst_28172);

(statearr_28240_28303[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (6))){
var inst_28108 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28109 = [ident];
var inst_28110 = (new cljs.core.PersistentVector(null,1,(5),inst_28108,inst_28109,null));
var inst_28111 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_28110);
var state_28211__$1 = state_28211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28211__$1,(9),inst_28111);
} else {
if((state_val_28212 === (28))){
var inst_28163 = (state_28211[(2)]);
var state_28211__$1 = state_28211;
var statearr_28241_28304 = state_28211__$1;
(statearr_28241_28304[(2)] = inst_28163);

(statearr_28241_28304[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (25))){
var inst_28157 = (state_28211[(8)]);
var inst_28157__$1 = (state_28211[(2)]);
var inst_28158 = (inst_28157__$1 == null);
var state_28211__$1 = (function (){var statearr_28242 = state_28211;
(statearr_28242[(8)] = inst_28157__$1);

return statearr_28242;
})();
if(cljs.core.truth_(inst_28158)){
var statearr_28243_28305 = state_28211__$1;
(statearr_28243_28305[(1)] = (26));

} else {
var statearr_28244_28306 = state_28211__$1;
(statearr_28244_28306[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (34))){
var inst_28206 = (state_28211[(2)]);
var _ = (function (){var statearr_28245 = state_28211;
(statearr_28245[(4)] = cljs.core.rest((state_28211[(4)])));

return statearr_28245;
})();
var state_28211__$1 = state_28211;
var statearr_28246_28307 = state_28211__$1;
(statearr_28246_28307[(2)] = inst_28206);

(statearr_28246_28307[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (17))){
var inst_28139 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_28211__$1 = state_28211;
if(inst_28139){
var statearr_28247_28308 = state_28211__$1;
(statearr_28247_28308[(1)] = (19));

} else {
var statearr_28248_28309 = state_28211__$1;
(statearr_28248_28309[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (3))){
var inst_28209 = (state_28211[(2)]);
var state_28211__$1 = state_28211;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28211__$1,inst_28209);
} else {
if((state_val_28212 === (12))){
var inst_28119 = (state_28211[(2)]);
var state_28211__$1 = state_28211;
var statearr_28249_28310 = state_28211__$1;
(statearr_28249_28310[(2)] = inst_28119);

(statearr_28249_28310[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (2))){
var _ = (function (){var statearr_28250 = state_28211;
(statearr_28250[(4)] = cljs.core.cons((5),(state_28211[(4)])));

return statearr_28250;
})();
var inst_28106 = typeof ident === 'number';
var state_28211__$1 = state_28211;
if(cljs.core.truth_(inst_28106)){
var statearr_28251_28311 = state_28211__$1;
(statearr_28251_28311[(1)] = (6));

} else {
var statearr_28252_28312 = state_28211__$1;
(statearr_28252_28312[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (23))){
var state_28211__$1 = state_28211;
var statearr_28253_28313 = state_28211__$1;
(statearr_28253_28313[(2)] = null);

(statearr_28253_28313[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (35))){
var state_28211__$1 = state_28211;
var statearr_28254_28314 = state_28211__$1;
(statearr_28254_28314[(2)] = strict_QMARK_);

(statearr_28254_28314[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (19))){
var inst_28142 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28143 = cljs.core.first(ident);
var inst_28144 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_28143);
var inst_28145 = cljs.core.second(ident);
var inst_28146 = [inst_28144,inst_28145];
var inst_28147 = (new cljs.core.PersistentVector(null,2,(5),inst_28142,inst_28146,null));
var inst_28148 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_28147);
var state_28211__$1 = state_28211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28211__$1,(22),inst_28148);
} else {
if((state_val_28212 === (11))){
var state_28211__$1 = state_28211;
var statearr_28256_28315 = state_28211__$1;
(statearr_28256_28315[(2)] = null);

(statearr_28256_28315[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (9))){
var inst_28113 = (state_28211[(2)]);
var inst_28114 = fluree.db.util.async.throw_err(inst_28113);
var inst_28115 = cljs.core.not_empty(inst_28114);
var state_28211__$1 = state_28211;
if(cljs.core.truth_(inst_28115)){
var statearr_28257_28316 = state_28211__$1;
(statearr_28257_28316[(1)] = (10));

} else {
var statearr_28258_28317 = state_28211__$1;
(statearr_28258_28317[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (5))){
var _ = (function (){var statearr_28259 = state_28211;
(statearr_28259[(4)] = cljs.core.rest((state_28211[(4)])));

return statearr_28259;
})();
var state_28211__$1 = state_28211;
var ex28255 = (state_28211__$1[(2)]);
var statearr_28260_28318 = state_28211__$1;
(statearr_28260_28318[(5)] = ex28255);


var statearr_28261_28319 = state_28211__$1;
(statearr_28261_28319[(1)] = (4));

(statearr_28261_28319[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (14))){
var inst_28121 = (state_28211[(7)]);
var state_28211__$1 = state_28211;
var statearr_28262_28320 = state_28211__$1;
(statearr_28262_28320[(2)] = inst_28121);

(statearr_28262_28320[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (26))){
var state_28211__$1 = state_28211;
var statearr_28263_28321 = state_28211__$1;
(statearr_28263_28321[(2)] = null);

(statearr_28263_28321[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (16))){
var inst_28130 = cljs.core.first(ident);
var inst_28131 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28130], 0));
var inst_28132 = ["Subject ID lookup failed. The predicate ",inst_28131," does not exist."].join('');
var inst_28133 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28134 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_28135 = cljs.core.PersistentHashMap.fromArrays(inst_28133,inst_28134);
var inst_28136 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28132,inst_28135);
var inst_28137 = (function(){throw inst_28136})();
var state_28211__$1 = state_28211;
var statearr_28264_28322 = state_28211__$1;
(statearr_28264_28322[(2)] = inst_28137);

(statearr_28264_28322[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (38))){
var inst_28191 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_28192 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28193 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_28194 = cljs.core.PersistentHashMap.fromArrays(inst_28192,inst_28193);
var inst_28195 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28191,inst_28194);
var inst_28196 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_28195);
var state_28211__$1 = state_28211;
var statearr_28265_28323 = state_28211__$1;
(statearr_28265_28323[(2)] = inst_28196);

(statearr_28265_28323[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (30))){
var state_28211__$1 = state_28211;
var statearr_28266_28324 = state_28211__$1;
(statearr_28266_28324[(2)] = null);

(statearr_28266_28324[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (10))){
var state_28211__$1 = state_28211;
var statearr_28267_28325 = state_28211__$1;
(statearr_28267_28325[(2)] = ident);

(statearr_28267_28325[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (18))){
var inst_28179 = (state_28211[(2)]);
var state_28211__$1 = state_28211;
var statearr_28268_28326 = state_28211__$1;
(statearr_28268_28326[(2)] = inst_28179);

(statearr_28268_28326[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (42))){
var state_28211__$1 = state_28211;
var statearr_28269_28327 = state_28211__$1;
(statearr_28269_28327[(2)] = null);

(statearr_28269_28327[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (37))){
var inst_28189 = (state_28211[(2)]);
var state_28211__$1 = state_28211;
if(cljs.core.truth_(inst_28189)){
var statearr_28270_28328 = state_28211__$1;
(statearr_28270_28328[(1)] = (38));

} else {
var statearr_28271_28329 = state_28211__$1;
(statearr_28271_28329[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28212 === (8))){
var inst_28181 = (state_28211[(10)]);
var inst_28181__$1 = (state_28211[(2)]);
var state_28211__$1 = (function (){var statearr_28272 = state_28211;
(statearr_28272[(10)] = inst_28181__$1);

return statearr_28272;
})();
if(cljs.core.truth_(inst_28181__$1)){
var statearr_28273_28330 = state_28211__$1;
(statearr_28273_28330[(1)] = (32));

} else {
var statearr_28274_28331 = state_28211__$1;
(statearr_28274_28331[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2749__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2749__auto____0 = (function (){
var statearr_28275 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28275[(0)] = fluree$db$graphdb$subid_$_state_machine__2749__auto__);

(statearr_28275[(1)] = (1));

return statearr_28275;
});
var fluree$db$graphdb$subid_$_state_machine__2749__auto____1 = (function (state_28211){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_28211);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e28276){var ex__2752__auto__ = e28276;
var statearr_28277_28332 = state_28211;
(statearr_28277_28332[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_28211[(4)]))){
var statearr_28278_28333 = state_28211;
(statearr_28278_28333[(1)] = cljs.core.first((state_28211[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28334 = state_28211;
state_28211 = G__28334;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2749__auto__ = function(state_28211){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2749__auto____1.call(this,state_28211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2749__auto____0;
fluree$db$graphdb$subid_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2749__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_28279 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_28279[(6)] = c__2771__auto___28280);

return statearr_28279;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__28335){
var map__28336 = p__28335;
var map__28336__$1 = cljs.core.__destructure_map(map__28336);
var db = map__28336__$1;
var current_db_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28336__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28336__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_28352){
var state_val_28353 = (state_28352[(1)]);
if((state_val_28353 === (1))){
var state_28352__$1 = state_28352;
var statearr_28354_28368 = state_28352__$1;
(statearr_28354_28368[(2)] = null);

(statearr_28354_28368[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28353 === (2))){
var _ = (function (){var statearr_28355 = state_28352;
(statearr_28355[(4)] = cljs.core.cons((5),(state_28352[(4)])));

return statearr_28355;
})();
var inst_28343 = (current_db_fn.cljs$core$IFn$_invoke$arity$1 ? current_db_fn.cljs$core$IFn$_invoke$arity$1(db) : current_db_fn.call(null,db));
var state_28352__$1 = state_28352;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28352__$1,(6),inst_28343);
} else {
if((state_val_28353 === (3))){
var inst_28350 = (state_28352[(2)]);
var state_28352__$1 = state_28352;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28352__$1,inst_28350);
} else {
if((state_val_28353 === (4))){
var inst_28337 = (state_28352[(2)]);
var state_28352__$1 = state_28352;
var statearr_28357_28369 = state_28352__$1;
(statearr_28357_28369[(2)] = inst_28337);

(statearr_28357_28369[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28353 === (5))){
var _ = (function (){var statearr_28358 = state_28352;
(statearr_28358[(4)] = cljs.core.rest((state_28352[(4)])));

return statearr_28358;
})();
var state_28352__$1 = state_28352;
var ex28356 = (state_28352__$1[(2)]);
var statearr_28359_28370 = state_28352__$1;
(statearr_28359_28370[(5)] = ex28356);


if((ex28356 instanceof Error)){
var statearr_28360_28371 = state_28352__$1;
(statearr_28360_28371[(1)] = (4));

(statearr_28360_28371[(5)] = null);

} else {
throw ex28356;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28353 === (6))){
var inst_28345 = (state_28352[(2)]);
var inst_28346 = fluree.db.util.async.throw_err(inst_28345);
var inst_28347 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_28346,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_28361 = state_28352;
(statearr_28361[(4)] = cljs.core.rest((state_28352[(4)])));

return statearr_28361;
})();
var state_28352__$1 = state_28352;
var statearr_28362_28372 = state_28352__$1;
(statearr_28362_28372[(2)] = inst_28347);

(statearr_28362_28372[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2749__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2749__auto____0 = (function (){
var statearr_28363 = [null,null,null,null,null,null,null];
(statearr_28363[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2749__auto__);

(statearr_28363[(1)] = (1));

return statearr_28363;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2749__auto____1 = (function (state_28352){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_28352);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e28364){var ex__2752__auto__ = e28364;
var statearr_28365_28373 = state_28352;
(statearr_28365_28373[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_28352[(4)]))){
var statearr_28366_28374 = state_28352;
(statearr_28366_28374[(1)] = cljs.core.first((state_28352[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28375 = state_28352;
state_28352 = G__28375;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2749__auto__ = function(state_28352){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2749__auto____1.call(this,state_28352);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2749__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2749__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_28367 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_28367[(6)] = c__2771__auto__);

return statearr_28367;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__28376,property,collection){
var map__28377 = p__28376;
var map__28377__$1 = cljs.core.__destructure_map(map__28377);
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28377__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__28378 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null);
return (fexpr__28378.cljs$core$IFn$_invoke$arity$1 ? fexpr__28378.cljs$core$IFn$_invoke$arity$1(property) : fexpr__28378.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__28379,property,predicate){
var map__28380 = p__28379;
var map__28380__$1 = cljs.core.__destructure_map(map__28380);
var this$ = map__28380__$1;
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28380__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__28381 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null);
return (fexpr__28381.cljs$core$IFn$_invoke$arity$1 ? fexpr__28381.cljs$core$IFn$_invoke$arity$1(property) : fexpr__28381.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__28382 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop(this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__28382);
} else {
return G__28382;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__28384 = arguments.length;
switch (G__28384) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_28416){
var state_val_28417 = (state_28416[(1)]);
if((state_val_28417 === (7))){
var state_28416__$1 = state_28416;
var statearr_28418_28512 = state_28416__$1;
(statearr_28418_28512[(2)] = null);

(statearr_28418_28512[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28417 === (1))){
var state_28416__$1 = state_28416;
var statearr_28419_28513 = state_28416__$1;
(statearr_28419_28513[(2)] = null);

(statearr_28419_28513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28417 === (4))){
var inst_28385 = (state_28416[(2)]);
var state_28416__$1 = state_28416;
var statearr_28420_28514 = state_28416__$1;
(statearr_28420_28514[(2)] = inst_28385);

(statearr_28420_28514[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28417 === (6))){
var inst_28399 = (state_28416[(7)]);
var inst_28398 = (state_28416[(2)]);
var inst_28399__$1 = fluree.db.util.async.throw_err(inst_28398);
var inst_28400 = (inst_28399__$1 == null);
var state_28416__$1 = (function (){var statearr_28421 = state_28416;
(statearr_28421[(7)] = inst_28399__$1);

return statearr_28421;
})();
if(cljs.core.truth_(inst_28400)){
var statearr_28422_28515 = state_28416__$1;
(statearr_28422_28515[(1)] = (7));

} else {
var statearr_28423_28516 = state_28416__$1;
(statearr_28423_28516[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28417 === (3))){
var inst_28414 = (state_28416[(2)]);
var state_28416__$1 = state_28416;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28416__$1,inst_28414);
} else {
if((state_val_28417 === (12))){
var inst_28411 = (state_28416[(2)]);
var _ = (function (){var statearr_28424 = state_28416;
(statearr_28424[(4)] = cljs.core.rest((state_28416[(4)])));

return statearr_28424;
})();
var state_28416__$1 = state_28416;
var statearr_28425_28517 = state_28416__$1;
(statearr_28425_28517[(2)] = inst_28411);

(statearr_28425_28517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28417 === (2))){
var _ = (function (){var statearr_28426 = state_28416;
(statearr_28426[(4)] = cljs.core.cons((5),(state_28416[(4)])));

return statearr_28426;
})();
var inst_28392 = fluree.db.dbproto._rootdb(this$);
var inst_28393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28394 = [tag_id,(30)];
var inst_28395 = (new cljs.core.PersistentVector(null,2,(5),inst_28393,inst_28394,null));
var inst_28396 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_28392,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_28395);
var state_28416__$1 = state_28416;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28416__$1,(6),inst_28396);
} else {
if((state_val_28417 === (11))){
var inst_28405 = (state_28416[(8)]);
var inst_28409 = inst_28405.o;
var state_28416__$1 = state_28416;
var statearr_28428_28518 = state_28416__$1;
(statearr_28428_28518[(2)] = inst_28409);

(statearr_28428_28518[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28417 === (9))){
var inst_28405 = (state_28416[(8)]);
var inst_28405__$1 = (state_28416[(2)]);
var inst_28406 = (inst_28405__$1 == null);
var state_28416__$1 = (function (){var statearr_28429 = state_28416;
(statearr_28429[(8)] = inst_28405__$1);

return statearr_28429;
})();
if(cljs.core.truth_(inst_28406)){
var statearr_28430_28519 = state_28416__$1;
(statearr_28430_28519[(1)] = (10));

} else {
var statearr_28431_28520 = state_28416__$1;
(statearr_28431_28520[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28417 === (5))){
var _ = (function (){var statearr_28432 = state_28416;
(statearr_28432[(4)] = cljs.core.rest((state_28416[(4)])));

return statearr_28432;
})();
var state_28416__$1 = state_28416;
var ex28427 = (state_28416__$1[(2)]);
var statearr_28433_28521 = state_28416__$1;
(statearr_28433_28521[(5)] = ex28427);


if((ex28427 instanceof Error)){
var statearr_28434_28522 = state_28416__$1;
(statearr_28434_28522[(1)] = (4));

(statearr_28434_28522[(5)] = null);

} else {
throw ex28427;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28417 === (10))){
var state_28416__$1 = state_28416;
var statearr_28435_28523 = state_28416__$1;
(statearr_28435_28523[(2)] = null);

(statearr_28435_28523[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28417 === (8))){
var inst_28399 = (state_28416[(7)]);
var inst_28403 = cljs.core.first(inst_28399);
var state_28416__$1 = state_28416;
var statearr_28436_28524 = state_28416__$1;
(statearr_28436_28524[(2)] = inst_28403);

(statearr_28436_28524[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2749__auto__ = null;
var fluree$db$graphdb$state_machine__2749__auto____0 = (function (){
var statearr_28437 = [null,null,null,null,null,null,null,null,null];
(statearr_28437[(0)] = fluree$db$graphdb$state_machine__2749__auto__);

(statearr_28437[(1)] = (1));

return statearr_28437;
});
var fluree$db$graphdb$state_machine__2749__auto____1 = (function (state_28416){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_28416);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e28438){var ex__2752__auto__ = e28438;
var statearr_28439_28525 = state_28416;
(statearr_28439_28525[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_28416[(4)]))){
var statearr_28440_28526 = state_28416;
(statearr_28440_28526[(1)] = cljs.core.first((state_28416[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28527 = state_28416;
state_28416 = G__28527;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2749__auto__ = function(state_28416){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2749__auto____1.call(this,state_28416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2749__auto____0;
fluree$db$graphdb$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2749__auto____1;
return fluree$db$graphdb$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_28441 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_28441[(6)] = c__2771__auto__);

return statearr_28441;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_28477){
var state_val_28478 = (state_28477[(1)]);
if((state_val_28478 === (7))){
var inst_28451 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_28477__$1 = state_28477;
var statearr_28479_28528 = state_28477__$1;
(statearr_28479_28528[(2)] = inst_28451);

(statearr_28479_28528[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28478 === (1))){
var state_28477__$1 = state_28477;
var statearr_28480_28529 = state_28477__$1;
(statearr_28480_28529[(2)] = null);

(statearr_28480_28529[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28478 === (4))){
var inst_28442 = (state_28477[(2)]);
var state_28477__$1 = state_28477;
var statearr_28481_28530 = state_28477__$1;
(statearr_28481_28530[(2)] = inst_28442);

(statearr_28481_28530[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28478 === (15))){
var inst_28472 = (state_28477[(2)]);
var _ = (function (){var statearr_28482 = state_28477;
(statearr_28482[(4)] = cljs.core.rest((state_28477[(4)])));

return statearr_28482;
})();
var state_28477__$1 = state_28477;
var statearr_28483_28531 = state_28477__$1;
(statearr_28483_28531[(2)] = inst_28472);

(statearr_28483_28531[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28478 === (13))){
var inst_28457 = (state_28477[(7)]);
var inst_28463 = clojure.string.includes_QMARK_(inst_28457,":");
var state_28477__$1 = state_28477;
if(inst_28463){
var statearr_28484_28532 = state_28477__$1;
(statearr_28484_28532[(1)] = (16));

} else {
var statearr_28485_28533 = state_28477__$1;
(statearr_28485_28533[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28478 === (6))){
var state_28477__$1 = state_28477;
var statearr_28486_28534 = state_28477__$1;
(statearr_28486_28534[(2)] = pred);

(statearr_28486_28534[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28478 === (17))){
var inst_28457 = (state_28477[(7)]);
var state_28477__$1 = state_28477;
var statearr_28487_28535 = state_28477__$1;
(statearr_28487_28535[(2)] = inst_28457);

(statearr_28487_28535[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28478 === (3))){
var inst_28475 = (state_28477[(2)]);
var state_28477__$1 = state_28477;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28477__$1,inst_28475);
} else {
if((state_val_28478 === (12))){
var inst_28461 = (state_28477[(2)]);
var state_28477__$1 = state_28477;
if(cljs.core.truth_(inst_28461)){
var statearr_28488_28536 = state_28477__$1;
(statearr_28488_28536[(1)] = (13));

} else {
var statearr_28489_28537 = state_28477__$1;
(statearr_28489_28537[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28478 === (2))){
var _ = (function (){var statearr_28490 = state_28477;
(statearr_28490[(4)] = cljs.core.cons((5),(state_28477[(4)])));

return statearr_28490;
})();
var inst_28448 = typeof pred === 'string';
var state_28477__$1 = state_28477;
if(cljs.core.truth_(inst_28448)){
var statearr_28491_28538 = state_28477__$1;
(statearr_28491_28538[(1)] = (6));

} else {
var statearr_28492_28539 = state_28477__$1;
(statearr_28492_28539[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28478 === (11))){
var inst_28453 = (state_28477[(8)]);
var state_28477__$1 = state_28477;
var statearr_28494_28540 = state_28477__$1;
(statearr_28494_28540[(2)] = inst_28453);

(statearr_28494_28540[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28478 === (9))){
var inst_28453 = (state_28477[(8)]);
var inst_28456 = (state_28477[(2)]);
var inst_28457 = fluree.db.util.async.throw_err(inst_28456);
var state_28477__$1 = (function (){var statearr_28495 = state_28477;
(statearr_28495[(7)] = inst_28457);

return statearr_28495;
})();
if(cljs.core.truth_(inst_28453)){
var statearr_28496_28541 = state_28477__$1;
(statearr_28496_28541[(1)] = (10));

} else {
var statearr_28497_28542 = state_28477__$1;
(statearr_28497_28542[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28478 === (5))){
var _ = (function (){var statearr_28498 = state_28477;
(statearr_28498[(4)] = cljs.core.rest((state_28477[(4)])));

return statearr_28498;
})();
var state_28477__$1 = state_28477;
var ex28493 = (state_28477__$1[(2)]);
var statearr_28499_28543 = state_28477__$1;
(statearr_28499_28543[(5)] = ex28493);


if((ex28493 instanceof Error)){
var statearr_28500_28544 = state_28477__$1;
(statearr_28500_28544[(1)] = (4));

(statearr_28500_28544[(5)] = null);

} else {
throw ex28493;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28478 === (14))){
var state_28477__$1 = state_28477;
var statearr_28501_28545 = state_28477__$1;
(statearr_28501_28545[(2)] = null);

(statearr_28501_28545[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28478 === (16))){
var inst_28457 = (state_28477[(7)]);
var inst_28465 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_28457,/:/);
var inst_28466 = cljs.core.second(inst_28465);
var state_28477__$1 = state_28477;
var statearr_28502_28546 = state_28477__$1;
(statearr_28502_28546[(2)] = inst_28466);

(statearr_28502_28546[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28478 === (10))){
var inst_28457 = (state_28477[(7)]);
var state_28477__$1 = state_28477;
var statearr_28503_28547 = state_28477__$1;
(statearr_28503_28547[(2)] = inst_28457);

(statearr_28503_28547[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28478 === (18))){
var inst_28469 = (state_28477[(2)]);
var state_28477__$1 = state_28477;
var statearr_28504_28548 = state_28477__$1;
(statearr_28504_28548[(2)] = inst_28469);

(statearr_28504_28548[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28478 === (8))){
var inst_28453 = (state_28477[(2)]);
var inst_28454 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2(this$,tag_id);
var state_28477__$1 = (function (){var statearr_28505 = state_28477;
(statearr_28505[(8)] = inst_28453);

return statearr_28505;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28477__$1,(9),inst_28454);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2749__auto__ = null;
var fluree$db$graphdb$state_machine__2749__auto____0 = (function (){
var statearr_28506 = [null,null,null,null,null,null,null,null,null];
(statearr_28506[(0)] = fluree$db$graphdb$state_machine__2749__auto__);

(statearr_28506[(1)] = (1));

return statearr_28506;
});
var fluree$db$graphdb$state_machine__2749__auto____1 = (function (state_28477){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_28477);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e28507){var ex__2752__auto__ = e28507;
var statearr_28508_28549 = state_28477;
(statearr_28508_28549[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_28477[(4)]))){
var statearr_28509_28550 = state_28477;
(statearr_28509_28550[(1)] = cljs.core.first((state_28477[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28551 = state_28477;
state_28477 = G__28551;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2749__auto__ = function(state_28477){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2749__auto____1.call(this,state_28477);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2749__auto____0;
fluree$db$graphdb$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2749__auto____1;
return fluree$db$graphdb$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_28510 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_28510[(6)] = c__2771__auto__);

return statearr_28510;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__28553 = arguments.length;
switch (G__28553) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_28586){
var state_val_28587 = (state_28586[(1)]);
if((state_val_28587 === (7))){
var state_28586__$1 = state_28586;
var statearr_28588_28676 = state_28586__$1;
(statearr_28588_28676[(2)] = null);

(statearr_28588_28676[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28587 === (1))){
var state_28586__$1 = state_28586;
var statearr_28589_28677 = state_28586__$1;
(statearr_28589_28677[(2)] = null);

(statearr_28589_28677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28587 === (4))){
var inst_28554 = (state_28586[(2)]);
var state_28586__$1 = state_28586;
var statearr_28590_28678 = state_28586__$1;
(statearr_28590_28678[(2)] = inst_28554);

(statearr_28590_28678[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28587 === (6))){
var inst_28569 = (state_28586[(7)]);
var inst_28568 = (state_28586[(2)]);
var inst_28569__$1 = fluree.db.util.async.throw_err(inst_28568);
var inst_28570 = (inst_28569__$1 == null);
var state_28586__$1 = (function (){var statearr_28591 = state_28586;
(statearr_28591[(7)] = inst_28569__$1);

return statearr_28591;
})();
if(cljs.core.truth_(inst_28570)){
var statearr_28592_28679 = state_28586__$1;
(statearr_28592_28679[(1)] = (7));

} else {
var statearr_28593_28680 = state_28586__$1;
(statearr_28593_28680[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28587 === (3))){
var inst_28584 = (state_28586[(2)]);
var state_28586__$1 = state_28586;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28586__$1,inst_28584);
} else {
if((state_val_28587 === (12))){
var inst_28581 = (state_28586[(2)]);
var _ = (function (){var statearr_28594 = state_28586;
(statearr_28594[(4)] = cljs.core.rest((state_28586[(4)])));

return statearr_28594;
})();
var state_28586__$1 = state_28586;
var statearr_28595_28681 = state_28586__$1;
(statearr_28595_28681[(2)] = inst_28581);

(statearr_28595_28681[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28587 === (2))){
var _ = (function (){var statearr_28596 = state_28586;
(statearr_28596[(4)] = cljs.core.cons((5),(state_28586[(4)])));

return statearr_28596;
})();
var inst_28560 = (30);
var inst_28562 = fluree.db.dbproto._rootdb(this$);
var inst_28563 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28564 = [inst_28560,tag_name];
var inst_28565 = (new cljs.core.PersistentVector(null,2,(5),inst_28563,inst_28564,null));
var inst_28566 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_28562,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_28565);
var state_28586__$1 = state_28586;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28586__$1,(6),inst_28566);
} else {
if((state_val_28587 === (11))){
var inst_28575 = (state_28586[(8)]);
var inst_28579 = inst_28575.s;
var state_28586__$1 = state_28586;
var statearr_28598_28682 = state_28586__$1;
(statearr_28598_28682[(2)] = inst_28579);

(statearr_28598_28682[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28587 === (9))){
var inst_28575 = (state_28586[(8)]);
var inst_28575__$1 = (state_28586[(2)]);
var inst_28576 = (inst_28575__$1 == null);
var state_28586__$1 = (function (){var statearr_28599 = state_28586;
(statearr_28599[(8)] = inst_28575__$1);

return statearr_28599;
})();
if(cljs.core.truth_(inst_28576)){
var statearr_28600_28683 = state_28586__$1;
(statearr_28600_28683[(1)] = (10));

} else {
var statearr_28601_28684 = state_28586__$1;
(statearr_28601_28684[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28587 === (5))){
var _ = (function (){var statearr_28602 = state_28586;
(statearr_28602[(4)] = cljs.core.rest((state_28586[(4)])));

return statearr_28602;
})();
var state_28586__$1 = state_28586;
var ex28597 = (state_28586__$1[(2)]);
var statearr_28603_28685 = state_28586__$1;
(statearr_28603_28685[(5)] = ex28597);


if((ex28597 instanceof Error)){
var statearr_28604_28686 = state_28586__$1;
(statearr_28604_28686[(1)] = (4));

(statearr_28604_28686[(5)] = null);

} else {
throw ex28597;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28587 === (10))){
var state_28586__$1 = state_28586;
var statearr_28605_28687 = state_28586__$1;
(statearr_28605_28687[(2)] = null);

(statearr_28605_28687[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28587 === (8))){
var inst_28569 = (state_28586[(7)]);
var inst_28573 = cljs.core.first(inst_28569);
var state_28586__$1 = state_28586;
var statearr_28606_28688 = state_28586__$1;
(statearr_28606_28688[(2)] = inst_28573);

(statearr_28606_28688[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2749__auto__ = null;
var fluree$db$graphdb$state_machine__2749__auto____0 = (function (){
var statearr_28607 = [null,null,null,null,null,null,null,null,null];
(statearr_28607[(0)] = fluree$db$graphdb$state_machine__2749__auto__);

(statearr_28607[(1)] = (1));

return statearr_28607;
});
var fluree$db$graphdb$state_machine__2749__auto____1 = (function (state_28586){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_28586);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e28608){var ex__2752__auto__ = e28608;
var statearr_28609_28689 = state_28586;
(statearr_28609_28689[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_28586[(4)]))){
var statearr_28610_28690 = state_28586;
(statearr_28610_28690[(1)] = cljs.core.first((state_28586[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28691 = state_28586;
state_28586 = G__28691;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2749__auto__ = function(state_28586){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2749__auto____1.call(this,state_28586);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2749__auto____0;
fluree$db$graphdb$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2749__auto____1;
return fluree$db$graphdb$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_28611 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_28611[(6)] = c__2771__auto__);

return statearr_28611;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__2771__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2772__auto__ = (function (){var switch__2748__auto__ = (function (state_28646){
var state_val_28647 = (state_28646[(1)]);
if((state_val_28647 === (7))){
var inst_28625 = typeof pred === 'string';
var state_28646__$1 = state_28646;
if(cljs.core.truth_(inst_28625)){
var statearr_28648_28692 = state_28646__$1;
(statearr_28648_28692[(1)] = (10));

} else {
var statearr_28649_28693 = state_28646__$1;
(statearr_28649_28693[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28647 === (1))){
var state_28646__$1 = state_28646;
var statearr_28650_28694 = state_28646__$1;
(statearr_28650_28694[(2)] = null);

(statearr_28650_28694[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28647 === (4))){
var inst_28612 = (state_28646[(2)]);
var state_28646__$1 = state_28646;
var statearr_28651_28695 = state_28646__$1;
(statearr_28651_28695[(2)] = inst_28612);

(statearr_28651_28695[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28647 === (15))){
var inst_28639 = (state_28646[(2)]);
var state_28646__$1 = state_28646;
var statearr_28652_28696 = state_28646__$1;
(statearr_28652_28696[(2)] = inst_28639);

(statearr_28652_28696[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28647 === (13))){
var inst_28630 = (state_28646[(7)]);
var inst_28632 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28630),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_28633 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,inst_28632);
var state_28646__$1 = state_28646;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28646__$1,(16),inst_28633);
} else {
if((state_val_28647 === (6))){
var inst_28620 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,tag_name);
var state_28646__$1 = state_28646;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28646__$1,(9),inst_28620);
} else {
if((state_val_28647 === (3))){
var inst_28644 = (state_28646[(2)]);
var state_28646__$1 = state_28646;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28646__$1,inst_28644);
} else {
if((state_val_28647 === (12))){
var inst_28630 = (state_28646[(7)]);
var inst_28630__$1 = (state_28646[(2)]);
var state_28646__$1 = (function (){var statearr_28653 = state_28646;
(statearr_28653[(7)] = inst_28630__$1);

return statearr_28653;
})();
if(cljs.core.truth_(inst_28630__$1)){
var statearr_28654_28697 = state_28646__$1;
(statearr_28654_28697[(1)] = (13));

} else {
var statearr_28655_28698 = state_28646__$1;
(statearr_28655_28698[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28647 === (2))){
var _ = (function (){var statearr_28656 = state_28646;
(statearr_28656[(4)] = cljs.core.cons((5),(state_28646[(4)])));

return statearr_28656;
})();
var inst_28618 = clojure.string.includes_QMARK_(tag_name,"/");
var state_28646__$1 = state_28646;
if(inst_28618){
var statearr_28657_28699 = state_28646__$1;
(statearr_28657_28699[(1)] = (6));

} else {
var statearr_28658_28700 = state_28646__$1;
(statearr_28658_28700[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28647 === (11))){
var inst_28628 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_28646__$1 = state_28646;
var statearr_28660_28701 = state_28646__$1;
(statearr_28660_28701[(2)] = inst_28628);

(statearr_28660_28701[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28647 === (9))){
var inst_28622 = (state_28646[(2)]);
var inst_28623 = fluree.db.util.async.throw_err(inst_28622);
var state_28646__$1 = state_28646;
var statearr_28661_28702 = state_28646__$1;
(statearr_28661_28702[(2)] = inst_28623);

(statearr_28661_28702[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28647 === (5))){
var _ = (function (){var statearr_28662 = state_28646;
(statearr_28662[(4)] = cljs.core.rest((state_28646[(4)])));

return statearr_28662;
})();
var state_28646__$1 = state_28646;
var ex28659 = (state_28646__$1[(2)]);
var statearr_28663_28703 = state_28646__$1;
(statearr_28663_28703[(5)] = ex28659);


if((ex28659 instanceof Error)){
var statearr_28664_28704 = state_28646__$1;
(statearr_28664_28704[(1)] = (4));

(statearr_28664_28704[(5)] = null);

} else {
throw ex28659;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28647 === (14))){
var state_28646__$1 = state_28646;
var statearr_28665_28705 = state_28646__$1;
(statearr_28665_28705[(2)] = null);

(statearr_28665_28705[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28647 === (16))){
var inst_28635 = (state_28646[(2)]);
var inst_28636 = fluree.db.util.async.throw_err(inst_28635);
var state_28646__$1 = state_28646;
var statearr_28666_28706 = state_28646__$1;
(statearr_28666_28706[(2)] = inst_28636);

(statearr_28666_28706[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28647 === (10))){
var state_28646__$1 = state_28646;
var statearr_28667_28707 = state_28646__$1;
(statearr_28667_28707[(2)] = pred);

(statearr_28667_28707[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28647 === (8))){
var inst_28641 = (state_28646[(2)]);
var _ = (function (){var statearr_28668 = state_28646;
(statearr_28668[(4)] = cljs.core.rest((state_28646[(4)])));

return statearr_28668;
})();
var state_28646__$1 = state_28646;
var statearr_28669_28708 = state_28646__$1;
(statearr_28669_28708[(2)] = inst_28641);

(statearr_28669_28708[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2749__auto__ = null;
var fluree$db$graphdb$state_machine__2749__auto____0 = (function (){
var statearr_28670 = [null,null,null,null,null,null,null,null];
(statearr_28670[(0)] = fluree$db$graphdb$state_machine__2749__auto__);

(statearr_28670[(1)] = (1));

return statearr_28670;
});
var fluree$db$graphdb$state_machine__2749__auto____1 = (function (state_28646){
while(true){
var ret_value__2750__auto__ = (function (){try{while(true){
var result__2751__auto__ = switch__2748__auto__(state_28646);
if(cljs.core.keyword_identical_QMARK_(result__2751__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2751__auto__;
}
break;
}
}catch (e28671){var ex__2752__auto__ = e28671;
var statearr_28672_28709 = state_28646;
(statearr_28672_28709[(2)] = ex__2752__auto__);


if(cljs.core.seq((state_28646[(4)]))){
var statearr_28673_28710 = state_28646;
(statearr_28673_28710[(1)] = cljs.core.first((state_28646[(4)])));

} else {
throw ex__2752__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2750__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28711 = state_28646;
state_28646 = G__28711;
continue;
} else {
return ret_value__2750__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2749__auto__ = function(state_28646){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2749__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2749__auto____1.call(this,state_28646);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2749__auto____0;
fluree$db$graphdb$state_machine__2749__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2749__auto____1;
return fluree$db$graphdb$state_machine__2749__auto__;
})()
})();
var state__2773__auto__ = (function (){var statearr_28674 = (f__2772__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2772__auto__.cljs$core$IFn$_invoke$arity$0() : f__2772__auto__.call(null));
(statearr_28674[(6)] = c__2771__auto__);

return statearr_28674;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2773__auto__);
}));

return c__2771__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5342__auto__,k__5343__auto__){
var self__ = this;
var this__5342__auto____$1 = this;
return this__5342__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5343__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5344__auto__,k28713,else__5345__auto__){
var self__ = this;
var this__5344__auto____$1 = this;
var G__28717 = k28713;
var G__28717__$1 = (((G__28717 instanceof cljs.core.Keyword))?G__28717.fqn:null);
switch (G__28717__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k28713,else__5345__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5362__auto__,f__5363__auto__,init__5364__auto__){
var self__ = this;
var this__5362__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5365__auto__,p__28718){
var vec__28719 = p__28718;
var k__5366__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28719,(0),null);
var v__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28719,(1),null);
return (f__5363__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5363__auto__.cljs$core$IFn$_invoke$arity$3(ret__5365__auto__,k__5366__auto__,v__5367__auto__) : f__5363__auto__.call(null,ret__5365__auto__,k__5366__auto__,v__5367__auto__));
}),init__5364__auto__,this__5362__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5357__auto__,writer__5358__auto__,opts__5359__auto__){
var self__ = this;
var this__5357__auto____$1 = this;
var pr_pair__5360__auto__ = (function (keyval__5361__auto__){
return cljs.core.pr_sequential_writer(writer__5358__auto__,cljs.core.pr_writer,""," ","",opts__5359__auto__,keyval__5361__auto__);
});
return cljs.core.pr_sequential_writer(writer__5358__auto__,pr_pair__5360__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__5359__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__28712){
var self__ = this;
var G__28712__$1 = this;
return (new cljs.core.RecordIter((0),G__28712__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5340__auto__){
var self__ = this;
var this__5340__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5337__auto__){
var self__ = this;
var this__5337__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5346__auto__){
var self__ = this;
var this__5346__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__28722 = (function (coll__5339__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__5339__auto__));
});
return fexpr__28722(this__5338__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this28714,other28715){
var self__ = this;
var this28714__$1 = this;
return (((!((other28715 == null)))) && ((((this28714__$1.constructor === other28715.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28714__$1.conn,other28715.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28714__$1.network,other28715.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28714__$1.dbid,other28715.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28714__$1.block,other28715.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28714__$1.t,other28715.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28714__$1.tt_id,other28715.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28714__$1.stats,other28715.stats)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28714__$1.spot,other28715.spot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28714__$1.psot,other28715.psot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28714__$1.post,other28715.post)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28714__$1.opst,other28715.opst)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28714__$1.schema,other28715.schema)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28714__$1.settings,other28715.settings)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28714__$1.index_configs,other28715.index_configs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28714__$1.schema_cache,other28715.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28714__$1.novelty,other28715.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28714__$1.permissions,other28715.permissions)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28714__$1.fork,other28715.fork)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28714__$1.fork_block,other28715.fork_block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28714__$1.current_db_fn,other28715.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28714__$1.__extmap,other28715.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5352__auto__,k__5353__auto__){
var self__ = this;
var this__5352__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5353__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5352__auto____$1),self__.__meta),k__5353__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5353__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5349__auto__,k28713){
var self__ = this;
var this__5349__auto____$1 = this;
var G__28723 = k28713;
var G__28723__$1 = (((G__28723 instanceof cljs.core.Keyword))?G__28723.fqn:null);
switch (G__28723__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k28713);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5350__auto__,k__5351__auto__,G__28712){
var self__ = this;
var this__5350__auto____$1 = this;
var pred__28724 = cljs.core.keyword_identical_QMARK_;
var expr__28725 = k__5351__auto__;
if(cljs.core.truth_((function (){var G__28727 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__28728 = expr__28725;
return (pred__28724.cljs$core$IFn$_invoke$arity$2 ? pred__28724.cljs$core$IFn$_invoke$arity$2(G__28727,G__28728) : pred__28724.call(null,G__28727,G__28728));
})())){
return (new fluree.db.graphdb.GraphDb(G__28712,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28729 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__28730 = expr__28725;
return (pred__28724.cljs$core$IFn$_invoke$arity$2 ? pred__28724.cljs$core$IFn$_invoke$arity$2(G__28729,G__28730) : pred__28724.call(null,G__28729,G__28730));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__28712,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28731 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__28732 = expr__28725;
return (pred__28724.cljs$core$IFn$_invoke$arity$2 ? pred__28724.cljs$core$IFn$_invoke$arity$2(G__28731,G__28732) : pred__28724.call(null,G__28731,G__28732));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__28712,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28733 = new cljs.core.Keyword(null,"block","block",664686210);
var G__28734 = expr__28725;
return (pred__28724.cljs$core$IFn$_invoke$arity$2 ? pred__28724.cljs$core$IFn$_invoke$arity$2(G__28733,G__28734) : pred__28724.call(null,G__28733,G__28734));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__28712,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28735 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__28736 = expr__28725;
return (pred__28724.cljs$core$IFn$_invoke$arity$2 ? pred__28724.cljs$core$IFn$_invoke$arity$2(G__28735,G__28736) : pred__28724.call(null,G__28735,G__28736));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__28712,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28737 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__28738 = expr__28725;
return (pred__28724.cljs$core$IFn$_invoke$arity$2 ? pred__28724.cljs$core$IFn$_invoke$arity$2(G__28737,G__28738) : pred__28724.call(null,G__28737,G__28738));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__28712,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28739 = new cljs.core.Keyword(null,"stats","stats",-85643011);
var G__28740 = expr__28725;
return (pred__28724.cljs$core$IFn$_invoke$arity$2 ? pred__28724.cljs$core$IFn$_invoke$arity$2(G__28739,G__28740) : pred__28724.call(null,G__28739,G__28740));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__28712,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28741 = new cljs.core.Keyword(null,"spot","spot",-1706962147);
var G__28742 = expr__28725;
return (pred__28724.cljs$core$IFn$_invoke$arity$2 ? pred__28724.cljs$core$IFn$_invoke$arity$2(G__28741,G__28742) : pred__28724.call(null,G__28741,G__28742));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__28712,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28743 = new cljs.core.Keyword(null,"psot","psot",2111653059);
var G__28744 = expr__28725;
return (pred__28724.cljs$core$IFn$_invoke$arity$2 ? pred__28724.cljs$core$IFn$_invoke$arity$2(G__28743,G__28744) : pred__28724.call(null,G__28743,G__28744));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__28712,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28745 = new cljs.core.Keyword(null,"post","post",269697687);
var G__28746 = expr__28725;
return (pred__28724.cljs$core$IFn$_invoke$arity$2 ? pred__28724.cljs$core$IFn$_invoke$arity$2(G__28745,G__28746) : pred__28724.call(null,G__28745,G__28746));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__28712,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28747 = new cljs.core.Keyword(null,"opst","opst",1213963058);
var G__28748 = expr__28725;
return (pred__28724.cljs$core$IFn$_invoke$arity$2 ? pred__28724.cljs$core$IFn$_invoke$arity$2(G__28747,G__28748) : pred__28724.call(null,G__28747,G__28748));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__28712,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28749 = new cljs.core.Keyword(null,"schema","schema",-1582001791);
var G__28750 = expr__28725;
return (pred__28724.cljs$core$IFn$_invoke$arity$2 ? pred__28724.cljs$core$IFn$_invoke$arity$2(G__28749,G__28750) : pred__28724.call(null,G__28749,G__28750));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__28712,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28751 = new cljs.core.Keyword(null,"settings","settings",1556144875);
var G__28752 = expr__28725;
return (pred__28724.cljs$core$IFn$_invoke$arity$2 ? pred__28724.cljs$core$IFn$_invoke$arity$2(G__28751,G__28752) : pred__28724.call(null,G__28751,G__28752));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__28712,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28753 = new cljs.core.Keyword(null,"index-configs","index-configs",1053959280);
var G__28754 = expr__28725;
return (pred__28724.cljs$core$IFn$_invoke$arity$2 ? pred__28724.cljs$core$IFn$_invoke$arity$2(G__28753,G__28754) : pred__28724.call(null,G__28753,G__28754));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__28712,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28755 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__28756 = expr__28725;
return (pred__28724.cljs$core$IFn$_invoke$arity$2 ? pred__28724.cljs$core$IFn$_invoke$arity$2(G__28755,G__28756) : pred__28724.call(null,G__28755,G__28756));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__28712,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28757 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024);
var G__28758 = expr__28725;
return (pred__28724.cljs$core$IFn$_invoke$arity$2 ? pred__28724.cljs$core$IFn$_invoke$arity$2(G__28757,G__28758) : pred__28724.call(null,G__28757,G__28758));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__28712,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28759 = new cljs.core.Keyword(null,"permissions","permissions",67803075);
var G__28760 = expr__28725;
return (pred__28724.cljs$core$IFn$_invoke$arity$2 ? pred__28724.cljs$core$IFn$_invoke$arity$2(G__28759,G__28760) : pred__28724.call(null,G__28759,G__28760));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__28712,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28761 = new cljs.core.Keyword(null,"fork","fork",1062974235);
var G__28762 = expr__28725;
return (pred__28724.cljs$core$IFn$_invoke$arity$2 ? pred__28724.cljs$core$IFn$_invoke$arity$2(G__28761,G__28762) : pred__28724.call(null,G__28761,G__28762));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__28712,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28763 = new cljs.core.Keyword(null,"fork-block","fork-block",178387923);
var G__28764 = expr__28725;
return (pred__28724.cljs$core$IFn$_invoke$arity$2 ? pred__28724.cljs$core$IFn$_invoke$arity$2(G__28763,G__28764) : pred__28724.call(null,G__28763,G__28764));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__28712,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28765 = new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336);
var G__28766 = expr__28725;
return (pred__28724.cljs$core$IFn$_invoke$arity$2 ? pred__28724.cljs$core$IFn$_invoke$arity$2(G__28765,G__28766) : pred__28724.call(null,G__28765,G__28766));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__28712,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5351__auto__,G__28712),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5355__auto__){
var self__ = this;
var this__5355__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5341__auto__,G__28712){
var self__ = this;
var this__5341__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__28712,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5347__auto__,entry__5348__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5348__auto__)){
return this__5347__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5348__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5347__auto____$1,entry__5348__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop(this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop(this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"index-configs","index-configs",-1600476489,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__5388__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__5388__auto__,writer__5389__auto__){
return cljs.core._write(writer__5389__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__28716){
var extmap__5384__auto__ = (function (){var G__28767 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__28716,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], 0));
if(cljs.core.record_QMARK_(G__28716)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__28767);
} else {
return G__28767;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__28716),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__28716),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__28716),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__28716),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__28716),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__28716),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__28716),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__28716),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__28716),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__28716),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__28716),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__28716),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__28716),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280).cljs$core$IFn$_invoke$arity$1(G__28716),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__28716),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__28716),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__28716),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__28716),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__28716),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__28716),null,cljs.core.not_empty(extmap__5384__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),db__$1.dbid,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"conn","conn",278309663)],[(0),dbid,index_config,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_spot_novelty], null)),new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_psot_novelty], null)),new cljs.core.Keyword(null,"post","post",269697687),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_post_novelty], null)),new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"post","post",269697687));
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"opst","opst",1213963058));
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
